 /*E ** Copyright  1993, 1994 by Eric M. LaFranchi.  All Rights Reserved.  **J ** This software is Copyright 1993, 1994 by Eric M. LaFranchi.  PermissionJ ** to use, copy, and freely redistributed this software in its entirety isC ** hereby granted provided that the above copyright notice and this L ** permission notice are retained.  This software may not be sold for profitF ** or incorporated in commercial software products without the writtenK ** permission of the author.  This software is provided "as is", the author L ** nor his employer make any representation of warranty, express or implied,J ** with respect to any code or other information herein.  In addition, theI ** author disclaim's any liability whatsoever for any use of such code or  ** other information.  **   **+-+  ** ** Module: VMS_CMDLINE ** ** Abstract:< **	This module contains all the constants and definitions to@ **	parse the command line and extract the proper components into@ **	the associated variables and then dispatch to the appropriate **	action routines.  **
 ** Author: **	Eric M. LaFranchi ** ** Creation Date:  **	03-MAY-1993 ** ** Special Notes: C **	This module assumes that the verb used in the CLD is "PACKASM ". = **	If the verb PACKASM is changed in the CLD file, it will be # **	necessary to update this module.  ** ** Modification History:( **	EML003		Eric M. LaFranchi	14-Jan-1994B **	Added /MAIL_FILE qualifier which allows the user to specify the **      mailfile to be read. **( **	EML002		Eric M. LaFranchi	26-Oct-1993< **	Revamped parameter parsing, making it easier to added new **	parameters and qualifiers.  ** **-+-  */- #include <ctype.h>			/* type macros			     */ 9 #include <stdio.h>			/* Standard I/O definitions.	     */ = #include <stdlib.h>			/* Standard library definitions.     */ = #include <string.h>			/* Standard string definitions.      */ @ #include <climsgdef.h>			/* Command definition utility symbols*/= #include <descrip.h>			/* VMS descriptor definitions.	     */ : #include <ssdef.h>			/* Standard VMS messages code	     */= #include <stsdef.h>			/* System service failure and status */ : #include <rms.h>			/* RMS system service condition defs */ #include "packdef.h" #include "msgdef.h"  #include "vmsdef.h"    #ifndef CLI$_SYNTAX  #define CLI$_SYNTAX 200956 #endif       /* Program banner       */ U static const char banner[] = "Package Assembler (PACKASM) Utility - Version %d.%d%s"; f static const char copyright[] = "Copyright  1993, 1994 by Eric M. LaFranchi. All Rights Reserved.\n";  &     /* Global data area initialization      */  #ifdef VAXC  #pragma nostandard #endif  H GLOBAL size_t (*pack_connect)( void **const, const char *const ) = NULL;J GLOBAL size_t (*select_articles)( void *const, const char *const ) = NULL;Q GLOBAL size_t (*scan_articles)( void *const, size_t (*)(), const void * ) = NULL; c GLOBAL size_t (*extract_articles)( void *const, const size_t, size_t (*)( ), const void * ) = NULL; F GLOBAL size_t (*cleanup_articles)( void *const, const size_t ) = NULL;3 GLOBAL size_t (*disconnect)( void **const ) = NULL;   ! GLOBAL unsigned int gblflags = 0;    extern void *vms_cldtables;    #ifdef VAXC  #pragma standard #endif  $     /* command line argument buffers      */   static char excludes[CMDLINSIZ]; static char folders[CMDLINSIZ];   static char mailfile[CMDLINSIZ]; static char newsgrp[CMDLINSIZ];  static char outfil[FILNAMSIZ];  static char packages[CMDLINSIZ];! static char separator[CMDLINSIZ];  static char scratch[CMDLINSIZ];  static char srvbuf[CMDLINSIZ];  ( static unsigned int since[2], before[2];       /* command line qualifiers      */  static const struct  {      const char *const name;      unsigned int retval;     unsigned int flag; } qualifier[] = { 3 	{ "ANU_NEWS",		CLI$_PRESENT,	PACKASM_M_ANU_NEWS	}, < 	{ "ARTICLE_QUALIFIER",  CLI$_PRESENT,	PACKASM_M_ARTICLES	},Q 	{ "CONFIRM_QUALIFIER",  CLI$_PRESENT,	PACKASM_M_CONFIRM|PACKASM_M_CONFIRM_DEL }, 8 	{ "DECODE_QUALIFIER",	CLI$_PRESENT,	PACKASM_M_DECODE	},9 	{ "DELETE_QUALIFIER",	CLI$_PRESENT,	PACKASM_M_CLEANUP	}, 3 	{ "LOG_QUALIFIER",	CLI$_PRESENT,	PACKASM_M_LOG		}, < 	{ "OVERRIDE_QUALIFIER", CLI$_PRESENT,	PACKASM_M_OVERRIDE	},= 	{ "REMOVE_QUALIFIER",	CLI$_PRESENT,	PACKASM_M_REMOVE_HDRS	}, : 	{ "UNPACK_QUALIFIER",	CLI$_NEGATED,	PACKASM_M_NOUNPACK	}, 	{ NULL, 		0,		0 } };   7     /* Command line qualifiers with VMS time arguments.       */  static const struct  {      const char *const name;      char *const scratch;     unsigned int size;     unsigned int *const buf;
 } dates[] = { : 	{ "BEFORE_DATE",  scratch,  sizeof( scratch ),  before },; 	{ "SINCE_DATE",	  scratch,  sizeof( scratch ),  since  },  & 	{ NULL,		  NULL,     0,			NULL   } };  F     /* Command line parameters and qualifiers with list and arguments.      */  static const struct  {      char *const name;      char *const buffer;      unsigned int size;     unsigned int flag;     const char *const defaults; 
 } quals[] = { > 	{ "EXCLUDE_LIST", excludes,  sizeof( excludes ),  0,  NULL },? 	{ "FOLDER_LIST",  folders,   sizeof( folders ),	  0, "MAIL" }, > 	{ "MAIL_FILE",    mailfile,  sizeof( mailfile ),  0,  NULL },I 	{ "NEWS_GROUPS",  newsgrp,   sizeof( newsgrp ),	  0, "vmsnet.sources" }, L 	{ "NNTP_SERVER",  srvbuf,    sizeof( srvbuf ),	  PACKASM_M_NNTPSRV, NULL },= 	{ "OUTPUT_FILE",  outfil,    sizeof( outfil ),	  0,  NULL }, > 	{ "PACKAGE_LIST", packages,  sizeof( packages ),  0,  NULL },= 	{ "PROTOCOL",	  scratch,   sizeof( scratch ),	  0,  "TCP" }, = 	{ "SEPARATOR",	  separator, sizeof( separator ), 0,  NULL }, + 	{ NULL,		  NULL,      0,			  0,  NULL } };    /*  *+-+   *  * Function: execute  *  * Abstract:E  *	The routine determines the appropriate action based on the command @  *	line arguments and dispatches to the correct action routines.  *
  * Inputs:&  *	packages -- pointer to package list$  *	folders -- pointer to folder list&  *	excludes -- pointer to exclude list5  *	output -- pointer to output file                   !  *	since -- pointer to since time #  *	before -- pointer to before time 3  *	archive_type -- type of archive storing articles   *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t  execute( char *const server, 	 char *const packages,  	 char *const folders, 	 const char *const excludes,  	 const char *const output,  	 const char *const separator," 	 const unsigned int *const since,# 	 const unsigned int *const before,  	 unsigned int archive_type )  {      void *handle = NULL;!     struct subject_record subcxt;   ,     register char *f, *folder, *p, *package;     register status;  9 	/* dynamic load appropriate low level transport routines  	 */     switch ( archive_type )      {  	case	PACKASM_C_VMSMAIL: 	    load_VMSmail_routines( ); 	    break;    	case	PACKASM_C_NNTP_TCP:  	    load_nntp_tcp_routines( );  	    break;    	case	PACKASM_C_NNTP_DNET:  	    load_nntp_dnet_routines( ); 	    break;    	case	PACKASM_C_ANUNEWS: 	    load_ANUnews_routines( ); 	    break;   	 	default: - 	    raise_exception( PACKASM_INTERNERR, 0 );      }   6 	/* Establish mail context and open appropriate files. 	 */-     status = pack_connect( &handle, server ); +     if ( !(status & 1) ) return ( status );   5 	/* copy user specified flags, before and since times  	 * into subject context block 	 */     subcxt.flags = gblflags;     subcxt.since = since;      subcxt.before = before;      subcxt.excludes = excludes; !     subcxt.separator = separator;   6 	/* scan though all the package names folder by folder 	 */     for ( f = folders; f; )      {  	folder = f; 	if ( f = strchr( f, ',' ) ) 	    *f++ = '\0';   % 	    /* copy user folder name pointer  	     */ 	subcxt.folder = folder;   	    /* select the folder  	     */, 	status = select_articles( handle, folder ); 	if ( !(status & 1) ) continue;   ( 	if ( !(gblflags & PACKASM_M_ARTICLES) ) 	{" 		/* copy the package name pointer 		 */   	    subcxt.packages = packages;  E 	    status = scan_articles( handle, pack_process_subject, &subcxt );  	    if ( !(status & 1) ) 	     
 		goto abort;  	} 	else  	{= 	    (void)pack_extract_articles( handle, packages, excludes,  					 folder, output );  	    if ( !(status & 1) ) 
 		goto abort;  	}     }     	/* Unpack all the package found 	 */0     status = pack_extract_all( handle, output );   abort:( 	/* clean up mail context and open files 	 */     disconnect( &handle );   	/* remove all packages  	 */     pack_remove( );        return ( status ); }      /*  *+-+   *!  * Function: process_command_line   *  * Abstract:B  *	Parse the command line using the VMS command definition utility3  *	and extracts the appropriate VMS_SHARE packages.   *
  * Inputs:  *	None   *  * Outputs:   *	None   *  * Side Effects:0  *	VMS_SHARE packages are be extracted from mail  *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */  size_t process_command_line( )  {      char *server, *folder, *p;     unsigned int archive, i;  
     struct     {  	char *buf;  	char *qualifier;      } artval[2];       register status;  < 	/* Test for specified command line qualifiers and set flags 	 * accordingly. 	 */1     for ( i = 0; qualifier[i].name != NULL; i++ )      { ; 	if ( present( qualifier[i].name ) == qualifier[i].retval ) # 	    gblflags |= qualifier[i].flag;      }   < 	/* Get the since/before time if specified and convert it to 	 * system specific time.  	 */-     for ( i = 0; dates[i].name != NULL; i++ )      { F 	status = get_value( dates[i].name, dates[i].scratch, dates[i].size );0 	if ( !(status & 1) && (status != CLI$_ABSENT) ) 	    return( status );  9 	status = convert_time( dates[i].scratch, dates[i].buf );  	if ( !(status & 1) )  	{ 	    strcpy( scratch, "/" );* 	    strncat( scratch, dates[i].name, 5 );F 	    raise_exception( PACKASM_INVQUAVAL, 2, dates[i].scratch, scratch, 			     status );  	}     }   : 	/* Get the arguments that have data associated with them. 	 */-     for ( i = 0; quals[i].name != NULL; i++ )      { E 	status = get_value( quals[i].name, quals[i].buffer, quals[i].size );  	if ( status == CLI$_ABSENT )  	{% 	    if ( quals[i].defaults != NULL ) / 		strcpy( quals[i].buffer, quals[i].defaults );  	    continue; 	}   	if ( !(status & 1) )  	    raise_exception( status );    	gblflags |= quals[i].flag;      }   / 	/* initialize the non static argument pointers  	 */     server = NULL;     folder = folders;   . 	/* Determine the type of archive we're using. 	 */'     if ( gblflags & PACKASM_M_NNTPSRV )      {  	server = srvbuf;  	folder = newsgrp;  ' 	if ( (strcmp( scratch, "TCP" ) == 0) ) " 	    archive = PACKASM_C_NNTP_TCP;  ( 	if ( strcmp( scratch, "DECNET" ) == 0 )# 	    archive = PACKASM_C_NNTP_DNET;      } -     else if ( gblflags & PACKASM_M_ANU_NEWS )      {  	folder = newsgrp; 	archive = PACKASM_C_ANUNEWS;      }      else     {  	folder = folders; 	server = mailfile;  	archive = PACKASM_C_VMSMAIL;      }   = 	/* if article numbers are specified, then validate the input  	 */(     if ( gblflags & PACKASM_M_ARTICLES )     {  	artval[0].buf = packages;# 	artval[0].qualifier = "/ARTICLES";  	artval[1].buf = excludes;# 	artval[1].qualifier = "/EXCLUDES";    	for ( i = 0; i < 2; i++ ) 	{' 	    for ( p = artval[i].buf; *p; p++ )  	    { 		if ( isdigit( *p ) ) 		    continue;   < 		if ( ((*p == '-') || (*p == ':')) && isdigit( *(p + 1) ) )& 		    for ( p++; isdigit( *p ); p++ );  , 		if ( (*p == ',') && isdigit( *(p + 1) ) )  		    continue;    		if ( *p == '\0' )  		    break;  7 		raise_exception( PACKASM_INVQUAVAL, 3, artval[i].buf, 2 				 artval[i].qualifier, PACKASM_INVARTSPEC, 0 ); 	    } 	}     }   9     status = execute( server, packages, folder, excludes, 4 		      outfil, separator, since, before, archive );     return ( status ); }      /*  *+-+   *  * Function: get_cmdline  *  * Abstract:D  *	This routine calls the CLI services to return command line valuesF  *	and calls process_message routine for each package specified on the  *	command line.  *
  * Inputs:*  *	command line parameters and qualifiers.  *  * Outputs:   *	None   *  * Returns: *  *	returns error status or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t  main( )  { !     static $DESCALLOC( cmdline ); #     static $DESCALLOC_DD( cmdstr ); 1     static const $DESCRIPTOR( verb, "PACKASM " ); <     static const $DESCRIPTOR( prompt, "Command: PACKASM " );       char update[32];     char cmdlinebuf[512];      register size_t status;    	/* establish exception handler  	 */     LIB$ESTABLISH( handler );   % 	/* write PACKASM banner with version  	 */C     sprintf( update, UPDATE_VERSION ? "-%d" : "", UPDATE_VERSION ); H     sprintf( cmdlinebuf, banner, MAJOR_VERSION, MINOR_VERSION, update );%     $DESCINIT( cmdline, cmdlinebuf );      LIB$PUT_OUTPUT( &cmdline ); ,     $DESCINIT( cmdline, (char *)copyright );     LIB$PUT_OUTPUT( &cmdline );   : 	/* Tests to see if PACKASM is installed using the Command> 	 * Definition Utility (CDU) (i.e. $ set command PACKASM.cld),$ 	 * foreign command, or run command. 	 */'     status = present( "PACKAGE_LIST" );        switch ( status )      {  	case CLI$_ABSENT: 	case CLI$_PRESENT: & 	    status = process_command_line( ); 	    break;    	case CLI$_SYNTAX: 	{< 	    $DESCFILL( cmdline, sizeof( cmdlinebuf ), cmdlinebuf );E 	    status = LIB$GET_FOREIGN( &cmdline, NULL, &cmdline.dsc$w_length,  				      NULL );  	    if ( !(status & 1) )  		break;  % 	    if ( cmdline.dsc$w_length == 0 )  	    {9 		$DESCFILL( cmdline, sizeof( cmdlinebuf ), cmdlinebuf ); A 		status = get_input( &cmdline, &prompt, &cmdline.dsc$w_length );  		if ( !(status & 1) ) 		    break; 	    }  6 		/* Concatenate verb and command line buffer into one 		 * string. 		 */ 5 	    status = STR$CONCAT( &cmdstr, &verb, &cmdline );  	    if ( !(status & 1) ) 2 		raise_exception( PACKASM_INTERNERR, 0, status );   		/* parse command line  		 */ 5 	    status = CLI$DCL_PARSE( &cmdstr, &vms_cldtables, % 				    get_input, get_input, NULL );    	    STR$FREE1_DX( &cmdstr );    	    if ( !(status & 1) )  	    { 		if ( status == CLI$_IVVERB )  		    status |= STS$M_INHIB_MSG; 		break; 	    }   	    status = CLI$DISPATCH( ); 	    break; 	         }   	 	default: 5 	    raise_exception( PACKASM_INTERNERR, 0, status );      }        if ( status == RMS$_EOF )  	SYS$EXIT( PACKASM_SUCCESS );        return ( status ); } 