 /*% cc -O -o getvms %   *C  *  Copy files from VMS (ODS-2) filesystem.  Files may be copied to D  *  disk or to standard output.  Transfer modes supported are "text"C  *  (RMS stuff is thrown away, newline is tacked on the end of each D  *  VMS record), and "image" (straight byte-by-byte transfer).	ThereD  *  were once plans to support a third mode ("binary"), but this hasF  *  not yet been implemented.  Defaults for the output destination andF  *  transfer mode are set by #defines, but the destination/mode can beB  *  specified at runtime by using various flags (see "options()").  *G  *  The input device and directory, if omitted, will default to that of H  *  the previous filespec.  Note that this means that the first filespecI  *  MUST have a directory specified, and (if DFLTDEV is not defined) also F  *  a device as well.  The filename syntax is the same as the standardD  *  VMS naming scheme, except that a "." may be used to separate theH  *  filetype from the version number, and some delimiters may be changedG  *  via #defines, if desired.  (This is all to avoid the possibility of D  *  having to escape some of the characters that the shell treats asF  *  special.)  The device name is the name of the UNIX special file in2  *  /dev, rather than what VMS thinks it would be.  *F  *  If the first character of argv[0] is "l", or if the "-l" option isE  *  used, the program lists the contents of the directory rather than E  *  copying a file.  At present, only one directory may be listed per   *  command.  *E  *  Written by Mark Bartelt, based on an earlier program which copied   *  files from ODS-1 volumes.   *!  *	hacked 6-aug-82 norman wilson: /  *		in getvb, don't let h_use get sign extended $  *		added -T & line number stripping$  *		bwk'd putch a bit in the process:  *		added access checks to openout to plug a security hole;  *		this last should probably be commented out for non-unix   *!  *	hacked 16-aug-84  Sam Sjogren: 0  *		In gethdr(), check to see if the user is the.  *		superuser.  If so, ignore file protection.  *"  *	hacked 26-feb-85  Carl J Lydick=  *		In getde(), check for end-of-file occurring as first word >  *		in the block returned by getvb().  Failure to do so causes  *		garbage and core dumps. <  *      hacked 22-feb-93  George J Carrette (GJC@MITECH.COM)A  *              Made this run under VMS, just for the heck of it. C  *              Updated crack() to allow newer VMS filename syntax. F  *      hacked 1-jun-93 (GJC@MITECH.COM) to have procedure prototypes,C  *              and use stdarg.h so that DEC C ANSI89 will be happy C  *              and member_alignment pragma on alpha, just in case.   */    #include <stdio.h> #include <stdlib.h>  #include <stdarg.h>   
 #ifdef VMS #ifdef __ALPHA4 /* define these so people don't need to compile with7    the flag /PREFIX_LIBRARY_ENTRIES=ALL_ENTRIES because *    /STANDARD=RELAXED_ANSI89 is the default */ #define access decc$access #define getgid decc$getgid #define getuid decc$getuid #endif #define index strchr #define rindex strrchr #include <string.h>  #include <descrip.h> #include <ssdef.h> #include <iodef.h> #include <starlet.h> #include <unixlib.h> #include <unixio.h>  #endif   #define DFLTDEV "disk$users"  / #define err0(msg)	{ errmsg(msg,0); return(0); } 5 #define err1(msg,arg)	{ errmsg(msg,arg); return(0); }    #define alphnum(x)	( ( 'a'<=(x) && (x)<='z' ) || ( 'A'<=(x) && (x)<='Z' ) || ( '0'<=(x) && (x)<='9' ) || ((x) == '-') || ((x) == '_') || ((x) == '$') )   + #define decimal(x)	( '0'<=(x) && (x)<='9' )    typedef unsigned short	ushort;   #ifdef __ALPHA #pragma member_alignment __save  #pragma nomember_alignment #endif   struct filnam { ( 	char	f_nam[14];	/* File name (ASCII) */$ 	ushort	f_ver;		/* Version number */ };   struct uic {( 	ushort	u_prog; 	/* Programmer number */% 	ushort	u_proj; 	/* Project number */  };   struct fileid { ! 	ushort	f_num;		/* File number */ > 	ushort	f_seq;		/* File sequence number (worthless concept) */< 	ushort	f_rvn;		/* Relative volume number (ditto and MBZ) */ };   struct rms {8 	char	f_forg; 	/* Record format and file organization */& 	char	f_ratt; 	/* Record attributes */" 	ushort	f_rsiz; 	/* Record size */. 	ushort	f_hvbn[2];	/* Highest VBN allocated */* 	ushort	f_heof[2];	/* End of file block */& 	ushort	f_ffby; 	/* First free byte */  	char	f_bksz; 	/* Bucket size */& 	char	f_hdsz; 	/* Fixed header size */) 	ushort	f_mrs;		/* Maximum record size */ - 	ushort	f_deq;		/* Default extend quantity */  };   struct ident {! 	char	i_fnam[20];	/* File name */ & 	ushort	i_rvno; 	/* Revision number */- 	char	i_crdt[8];	/* Creation date and time */ - 	char	i_rvdt[8];	/* Revision date and time */ / 	char	i_exdt[8];	/* Expiration date and time */ + 	char	i_bkdt[8];	/* Backup date and time */ " 	char	i_ulab[80];	/* User label */ };   struct header { & 	char	h_idof; 	/* Ident area offset */$ 	char	h_mpof; 	/* Map area offset *// 	char	h_acof; 	/* Access control list offset */ ) 	char	h_rsof; 	/* Reserved area offset */ / 	ushort	h_fseg; 	/* Extension segment number */ 2 	ushort	h_flev; 	/* Structure level and version */" 	ushort	h_fnum; 	/* File number */+ 	ushort	h_fseq; 	/* File sequence number */ - 	ushort	h_frvn; 	/* Relative volume number */ , 	ushort	h_efnu; 	/* Extension file number */5 	ushort	h_efsq; 	/* Extension file sequence number */ 7 	ushort	h_ervn; 	/* Extension relative volume number */  	union {. 		char	hu_ufat[32];	/* User file attributes */. 		struct rms hu_rms;	/* RMS file attributes */
 	} h_ufat; #define h_rms	h_ufat.hu_rms + 	char	h_fcha[4];	/* File characteristics */ > #define h_ucha	h_fcha[0]	/* User controlled characteristics */@ #define h_scha	h_fcha[1]	/* System controlled characteristics */ 	char	h_UU1[2];	/* Unused 1 */$ 	char	h_use;		/* Map words in use */- 	char	h_priv; 	/* Accessor privilege level */ ( 	struct uic h_fown;	/* File owner UIC */= #define h_prog	h_fown.u_prog	/* Programmer (member) number */ 9 #define h_proj	h_fown.u_proj	/* Project (group) number */ + 	ushort	h_fpro; 	/* File protection code */ - 	ushort	h_rpro; 	/* Record protection code */  	char	h_UU2[4];	/* Ununsed 2 */ $ 	char	h_semk[4];	/* Security mask */' 	struct ident h_ident;	/* Ident area */ < 	char	h_other[300];	/* Map area, access control area, etc */ };   struct homeblock {# 	long	H_hblb; 	/* Home block LBN */ - 	long	H_ahlb; 	/* Alternate home block LBN */ 1 	long	H_ihlb; 	/* Backup index file header LBN */ 2 	char	H_vlev[2];	/* Structure level and version */4 	ushort	H_sbcl; 	/* Storage bitmap cluster factor */% 	ushort	H_hbvb; 	/* Home block VBN */ , 	ushort	H_ahvb; 	/* Backup home block VBN */3 	ushort	H_ihvb; 	/* Backup index file header VBN */ , 	ushort	H_ibvb; 	/* Index file bitmap VBN */. 	ushort	H_iblb[2];	/* Index file bitmap LBN */, 	long	H_fmax; 	/* Maximum number of files */- 	ushort	H_ibsz; 	/* Index file bitmap size */ / 	ushort	H_rsvf; 	/* Number of reserved files */ ' 	ushort	H_dvty; 	/* Disk device type */ , 	ushort	H_rvn;		/* Relative volume number */( 	ushort	H_nvol; 	/* Number of volumes */- 	ushort	H_vcha; 	/* Volume characteristics */ * 	struct uic H_vown;	/* Volume owner UIC */) 	long	H_vsmx; 	/* Volume security mask */ - 	ushort	H_vpro; 	/* Volume protection code */ . 	ushort	H_dfpr; 	/* Default file protection */0 	ushort	H_drpr; 	/* Default record protection */% 	ushort	H_chk1; 	/* First checksum */ + 	char	H_vdat[8];	/* Volume creation date */ ( 	char	H_wisz; 	/* Default window size *// 	char	H_lruc; 	/* Directory pre-access limit */ * 	ushort	H_fiex; 	/* Default file extend */  	char	H_UU1[388];	/* Unused 1 */& 	char	H_snam[12];	/* Structure name */# 	char	H_indn[12];	/* Volume name */ $ 	char	H_indo[12];	/* Volume owner */# 	char	H_indf[12];	/* Format type */  	char	H_UU2[2];	/* Unused 2 */& 	ushort	H_chk2; 	/* Second checksum */	 } hblock;    struct directory {' 	ushort	d_rbc;		/* Record byte count */ $ 	ushort	d_vrlm; 	/* Version limit */ 	char	d_flags;	/* Flags */# 	char	d_nbc;		/* Name byte count */ ( 	char	d_fname[1];	/* File name string */ };   struct dirval { $ 	ushort	d_ver;		/* Version number */# 	struct fileid d_fid;	/* File ID */c };   #ifdef __ALPHA" #pragma member_alignment __restore #endif   #define BUFSIZE 512    #define bit(x)	((01)<<(x))   #define DEV	bit(0) #define DIR	bit(1) #define FIL	bit(2) #define EXT	bit(3) #define VER	bit(4)   #define DIRBEG	'[' #define DIREND	']'   #define NULLCHR '\0' #define NULLSTR ""   #define FSMAX	100o #define DEVMAX	20i   #define TEXT	0 #define IMGRMS	1 #define IMGFULL 2f #define BINARY	3   #define DISK	0 #define STDOUT	1   #define DFLTMOD TEXT #define DFLTOUT DISK   void usage(void);e void options(char *arg); void getvms(void); void errmsg(char *msg,...);e int openin(void);  void listdir(void);u int copyfile(void);h int crack(void); int openvms(char *devname);  int finddir(void);* int gethdr(ushort fnum,struct header *hp); int getlb(long	lbn,char *buf);/ void dirmsg(char *msg,char *dirname,char *ptr);  int okwrite(char *file);0 int getvb(long vbn,char *buf,struct header *hp); void putch(char c);i3 void prtfn(struct directory *de,struct dirval *vp);a9 int convert(char *fl,char *tp,char *vr,struct filnam *f);o" long lbnbase(register ushort *rp); int openout(void);   char	**av;				/* Global argv */t3 char	lsflag = 0;			/* Nonzero ==> list directory */h, int	xfermode = DFLTMOD;		/* Transfer mode */7 int	rmlineno = 0;			/* ntw - remove sos line numbers */t0 int	outdest = DFLTOUT;		/* Output destination */A char	filspec[FSMAX]; 		/* Full filename string being processed */ . int	pflags; 			/* Flags returned by crack() */L char	*dev, *dir, *fil, *typ, *ver;	/* Pointers to cracked filename fields */B char	vmsdev[DEVMAX+6];		/* Special file name for VMS filesystem */B int	vmsfd = -1;			/* File descriptor for reading VMS filesystem */1 FILE	*of;				/* Stream pointer for output file */s& char	dirfound;			/* Directory found */  M struct header	indexh, mfdh, dirh, fileh;	/* File headers for index file, MFD,   UFD, and file */c     main(argc,argv)u	 int	argc;* char	**argv; {  	char	*basename();   	av = argv;e   	if ( --argc == 0 )s
 		usage();   	if ( *basename(*argv) == 'l' )t 		++lsflag;h   	while ( argc-- ) {  		if ( **++av == '-' ) 			options(*argv); 		else 			getvms(); 	} }*     void usage(void) {yI 	fprintf(stderr,"usage: %s [-t] [-i] [-b] [-d] [-f] [-s] vmsfile\n",*av);a
 	exit(-1); }      char * basename(s)T register char	*s;  { N /* NOTE:  Some versions of UNIX use the name strrchr() rather than rindex() */ 	char		*rindex();r 	register char	*t;   	if ( (t=rindex(s,
 #ifdef VMS 		       ']' #elseo 		       '/' #endif 		       )) == NULL )t 		return(s); 	elseA 		return(t+1); }      /*  *  Process option flags  */p   void options(char *arg)e {  	register char	*p;   	for ( p = *av; *++p; ) {    		switch ( *p ) {    		case 'd':i" 		case 'f':	outdest = DISK; break;$ 		case 's':	outdest = STDOUT; break;  # 		case 't':	xfermode = TEXT; break;E9 		case 'T':	xfermode = TEXT; rmlineno++; break;	/* ntw */ % 		case 'i':	xfermode = IMGRMS; break;g& 		case 'I':	xfermode = IMGFULL; break;% 		case 'b':	xfermode = BINARY; break;n   		case 'l':	++lsflag; break; 		case 'c':	lsflag = 0; break;  6 		default:	fprintf(stderr,"Invalid option (%c)\n",*p);   		}u 	} }x     /*7  *  Get the next requested file from the VMS filesystemr  */    void getvms(void)r {g 	if ( strlen(*av) > FSMAX )n  	  {errmsg("Filespec too long"); 	   return;} 	strcpy(filspec,*av);(   	if ( lsflag ) { 		if ( openin() ) 
 			listdir();|	 	} else {   		if ( openin() && openout() ) { 			copyfile(); 			if ( of != stdout ) 				fclose(of);' 		}  	} }=     /*  *  Open VMS file for inputr  */    int openin(void) {  	static int	filecnt = 0; 	struct filnam	fn; 	ushort		fnum; 	ushort		search();	 	int		gh;[   	++filecnt;m 	if (crack() == 0)
 		return (0);r# 	if ( pflags&DEV && !openvms(dev) )u 		return(0); #ifdef DFLTDEV8 	if ( !(pflags&DEV) && filecnt==1 && !openvms(DFLTDEV) ) 		return(0); #endif 	if ( vmsfd < 0 )u 		err0("No device specified");& 	if ( pflags&(DEV|DIR) && !finddir() ) 		return(0); 	if ( !dirfound )u! 		err0("No directory specified");  	if ( lsflag ) { 		if ( pflags & (FIL|EXT|VER) )i+ 			err0("Invalid directory specification");a 		return(1); 	} 	if ( !(pflags&EXT) )s 		typ = NULLSTR; 	if ( !(pflags&VER) )  		ver = NULLSTR;! 	if ( !convert(fil,typ,ver,&fn) )  		return(0);! 	if ( !(fnum=search(&dirh,&fn)) )	 		err0("File does not exist");! 	if ( !(gh=gethdr(fnum,&fileh)) ) ) 		err0("Can't get file header for file");  	if ( gh == -1 )' 		err0("No access privilege for file");t 	return(1);a }_     /*?  *  Crack the filename string -- First step in parsing it; just	>  *  locates the fields, doesn't do much real validity checking  */n   int crack(void)  {a 	register char	*p = filspec; 	register char	*q;   	for ( pflags=0; *p; ) {   		if ( *p == DIRBEG ) {8$ 			if ( pflags & (DIR|FIL|EXT|VER) )  				err0("Bad filename syntax");
 			dir = p+1;c 			while ( *p != DIREND ) {e; 				if ( 'a' <= *p && *p <= 'z' )	/* SHOUT the directory */	. 					*p += 'A' - 'a';	/* name in UPPER CASE */ 				if ( *p++ == NULLCHR )! 					err0("Bad filename syntax");u 			} 			*p++ = NULLCHR; 			pflags |= DIR;/ 			continue; 		}u   		for ( q=p; alphnum(*q); ++q )b 			;   		if ( *q == ':' ) {& 			if ( pflags&(DEV|DIR|FIL|EXT|VER) )  				err0("Bad filename syntax"); 			dev = p;  			pflags |= DEV;s 			*q = NULLCHR;
 			p = q + 1;n 			continue; 		}a  2 		if ( *q == '.' || *q == ';' || *q == NULLCHR ) {   			if ( !(pflags&FIL) ) {	 				if ( p == q )/ 					err0("Filename missing"); 				fil = p; 				pflags |= FIL; 				if ( *q == ';' ) { 					typ = NULLSTR;  					pflags |= EXT;h 				}   			} else if ( !(pflags&EXT) ) { 				typ = p; 				pflags |= EXT;  			} else if ( !(pflags&VER) ) { 				ver = p; 				pflags |= VER;	 			} else	  				err0("Bad filename syntax");   			if ( *q == NULLCHR ) {v 				if ( !(pflags&EXT) ) 					typ = NULLSTR;/ 				if ( !(pflags&VER) ) 					ver = NULLSTR;e
 				break; 			} 			*q = NULLCHR;
 			p = q + 1;r 			continue; 		}r   		err0("Bad filename syntax"); 	}   	return(1);u }r     /*,  *  Open a disk containing an VMS filesystem  */*   int openvms(char	*devname) {/ 	long	ifhbn;    	if ( strlen(devname) > DEVMAX ), 		err1("Device name too long (%s)",devname);
 #ifdef VMS 	strcpy(vmsdev,"");  #elseh 	strcpy(vmsdev,"/dev/");' 	if ( strncmp(devname,"disk$",5) == 0 )  		devname += 5;o% 	if ( strncmp(devname,"vms",3) != 0 )d 		strcat(vmsdev,"vms");c #endif 	strcat(vmsdev,devname);
 #ifdef VMS 	{int retcode; 	 struct dsc$descriptor devd;f% 	 devd.dsc$w_length = strlen(vmsdev);k 	 devd.dsc$a_pointer = vmsdev;# 	 devd.dsc$b_class = DSC$K_CLASS_S;b# 	 devd.dsc$b_dtype = DSC$K_DTYPE_T;  	 vmsfd = 0;) 	 retcode = sys$assign(&devd,&vmsfd,0,0);_) 	 if (retcode != SS$_NORMAL) vmsfd = -1;}	 #else  	vmsfd=open(vmsdev,0); #endif 	if ( vmsfd < 0 )  		err1("Can't open %s",vmsdev);r  " 	if ( !getlb(1L,(char *)&hblock) ), 		err1("Can't read homeblock on %s",vmsdev);  O 	ifhbn = ((long)hblock.H_iblb[1]<<16) + (long)hblock.H_iblb[0] + hblock.H_ibsz;e% 	if ( !getlb(ifhbn,(char *)&indexh) )t6 		err1("Can't read index file header on %s\n",vmsdev);  % 	if ( !getlb(ifhbn+3,(char *)&mfdh) )*- 		err1("Can't read mfd header on %s",vmsdev);*   	return(1);f }      /*:  *  Locate the directory whose name is pointed to by "dir"  */t   #define alphanum   int finddir(void)m { G #define direrr(msg,dirname,ptr) { dirmsg(msg,dirname,ptr); return(0); }  	struct header	*hp = &mfdh;  	register char	*p = dir; 	register char	*q; 	char		*strchr();i
 	int		nch; 	struct filnam	dirfn;U 	ushort		dirfnum;_ 	ushort		search();	 	int		gh;    	do {n 		for ( q=p; alphnum(*q); ++q )	 			;7 		if ( ( *q && *q!='.' ) || (nch=q-p) == 0 || nch > 9 )e( 			err1("Invalid directory ([%s])",dir); 		strncpy(dirfn.f_nam,p,nch);  		dirfn.f_nam[nch] = '\0'; 		strcat(dirfn.f_nam,".DIR");c 		dirfn.f_ver = 1;% 		if ( !(dirfnum=search(hp,&dirfn)) )c1 			direrr("Directory [%s] does not exist",dir,q);e+ 		if ( !(gh=gethdr(dirfnum,(hp=(&dirh)))) )r< 			direrr("Can't get file header for directory [%s]",dir,q); 		if ( gh == -1 )e: 			direrr("No access privilege for directory [%s]",dir,q); 		p = q + 1; 	} while (*q); 	dirfound = 1; 	return(1);d }n     /*  *  Error accessing a directory)  */f  . void dirmsg(char *msg,char *dirname,char *ptr) {) 	char	c;  
 	c = *ptr;
 	*ptr = '\0';' 	errmsg(msg,dirname); 
 	*ptr = c; }H     /*I  *  Convert file name, type, and version number to "struct filnam" formatT  */d  8 int convert(char *fl,char *tp,char *vr,struct filnam *f) {  	register char *p;   	if ( strlen(fl) > 9 ), 		err0("Filename longer than 9 characters"); 	if ( strlen(tp) > 3 )- 		err0("File type longer than 3 characters");. 	strcpy(f->f_nam,fl);  	strcat(f->f_nam,"."); 	strcat(f->f_nam,tp);n= 	for ( p=f->f_nam; *p; ++p )		/* This code is needed since */;? 		if ( 'a' <= *p && *p <= 'z' )	/* VMS loves to SHOUT at you */c4 			*p += 'A' - 'a';	/* in UPPER CASE all the time */ 	for ( f->f_ver=0; *vr; ) {e 		if ( !decimal(*vr) )' 			err0("Non-digit in version number");c 		f->f_ver *= 10;n 		f->f_ver += *vr++ - '0'; 	} 	return(1);n }o     /*9  *  Search a directory (identified by dhp) for a filenamer  */e   ushort search(dhp,fn) register struct header	*dhp; register struct filnam	*fn;  {	 	int				len; 	int				bod; 	register struct directory	*de;/ 	struct directory		*getde(); 	register struct dirval		*vp;i  	register struct dirval		*vplim;   	len = strlen(fn->f_nam);/* 	for ( bod=1; de=getde(dhp,bod); bod=0 ) {@ 		if ( de->d_nbc!=len || strncmp(de->d_fname,fn->f_nam,len)!=0 ) 			continue;@ 		vp = (struct dirval *) ( de->d_fname + ((de->d_nbc+1)&0376) ); 		if ( !fn->f_ver )M 			return(vp->d_fid.f_num);fP 		for ( vplim=(struct dirval *)((char *)(&de->d_vrlm)+de->d_rbc); vp<vplim; ++vp  ) { 			if ( vp->d_ver > fn->f_ver )f
 				continue;*  			if ( vp->d_ver == fn->f_ver ) 				return(vp->d_fid.f_num);
 			return(0);  		}; 		return(0); 	} 	return(0);, }D     /*  *  Open output file  */g   int openout(void)  {r 	char	outfile[256];b   	if ( outdest == STDOUT ) {i 		of = stdout; 		return(1); 	}   	strcpy(outfile,fil);  	strcat(outfile,".");  	strcat(outfile,typ);	% 	if (okwrite(outfile) == 0		/* ntw */;' 	||   (of=fopen(outfile,"w")) == NULL )u! 		err0("Can't open output file");a 	return(1);- }[     /*&  * see if ok to write/create this file.  * needed because we might be setuid or setgid(  * to get at the special files for disks4  * nb we assume the file is in the working directory>  * always true at the moment;  might neeed more mess in future  */    int okwrite(char *file)' {    	if (access(file, 02) == 0) , 		return (1);		/* exists and is writeable */ 	if (access(file, 0) == 0)2 		return (0);		/* exists although not writeable */ 	if (index(file, '/')) 		return (0);		/* snh */
 #ifdef VMS 	return(1);  #endif   	if (access(".", 02) == 0)9 		return (1);		/* file doesn't exist and can create it */= 	return (0); }	     /*)  *  Copy input file to output destinationw  */    int copyfile(void) {G 	long		eofblk; 	register long	block = 0;L 	register long	b = 0;f 	char		buf[BUFSIZE]; 	int		nbytes = BUFSIZE;g 	register char	*p;   	if ( xfermode == BINARY )( 		err0("Binary mode not yet supported"); 	if ( xfermode != IMGFULL )*I 		eofblk = ( (long)fileh.h_rms.f_heof[0] << 16 ) + fileh.h_rms.f_heof[1];t& 	while ( getvb(++block,buf,&fileh) ) { 		if ( xfermode == IMGFULL ) {- 			if ( fwrite(buf,1,BUFSIZE,of) == BUFSIZE ) 
 				continue;{ 			err0("write error");l 		}r 		if ( ++b > eofblk )(
 			return(1);e 		if ( b == eofblk ) 			nbytes = fileh.h_rms.f_ffby;	 		if ( xfermode == IMGRMS ) { + 			if ( fwrite(buf,1,nbytes,of) == nbytes ) 
 				continue;  			err0("write error");; 		}r 		for ( p=buf; p<buf+nbytes; ) 			putch(*p++);; 	} 	return(1);+ }l     /**  *  Process next character from input file  *  for text modes  */    /*"  * possible states of the machine:  */s  : #define INIT	0	/* waiting for the beginning of a record */# #define COUNT	1	/* in byte count */v% #define LINENO	2	/* in line number */) #define DATA	3	/* in data */: #define NULLPAD	4	/* eating the padding null at the end */   void putch(char c) {l 	static unsigned	count;	 	static int	state = INIT;e 	static int	nextstate; 	static int	lnbytes;   	switch (state) {U 	case INIT:  		count = (c&0377);e 		state = COUNT; 		break;   	case COUNT:& 		if ( (count+=((c&0377)<<8)) == 0 ) { 			putc('\n',of);r 			state = INIT;
 		} else { 			if (rmlineno == 0)i 				state = DATA;a	 			else {e 				lnbytes = 0; 				state = LINENO;  			} 			nextstate = INIT; 			if ( count&1 )r 				nextstate = NULLPAD; 		}h 		break;  
 	case LINENO:s 		if (lnbytes == 0)s
 			lnbytes++;  		else 			state = DATA; 		if (--count == 0) {g 			putc('\n', of); 			state = INIT; 		}h 		break;   	case DATA:e
 		putc(c,of);f 		if ( --count == 0 ) {  			state = nextstate;8 			putc('\n',of);( 		}I 		break;   	case NULLPAD: 		state = INIT;; 		break;  	 	default:i$ 		errmsg("internal error in putch");
 		abort(); 	} }	     /*  *  List contents of a UFD  */'   void listdir(void) {C 	register int			bod; 	register struct directory	*de;n 	struct directory		*getde(); 	register struct dirval		*vp;   	register struct dirval		*vplim;  , 	for ( bod=1; de=getde(&dirh,bod); bod=0 ) {@ 		vp = (struct dirval *) ( de->d_fname + ((de->d_nbc+1)&0376) );> 		vplim = (struct dirval *) ((char *)(&de->d_vrlm)+de->d_rbc); 		for ( ; vp<vplim; ++vp ) 			prtfn(de,vp); 	} }'     /*%  *  Write filename to standard output(  */s  2 void prtfn(struct directory *de,struct dirval *vp) {n 	register char	*p; 	register int	i;  - 	for ( p=de->d_fname, i=de->d_nbc; i>0; --i )	 		putc(*p++,stdout);# 	fprintf(stdout,";%d\n",vp->d_ver);{ }	     /**  *  Return pointer to next directory entry  */E   struct directory * getde(dhp,bod) register struct header	*dhp;
 int			bod; {"! #define recsize (*((ushort *)de))	 #define STOP	((ushort)0177777) 	static long		vb;f 	static long		eofblk;	 	static char		*limit;r 	static char		dirbuf[BUFSIZE]; 	static char		*de;  
 	if ( bod ) {		 		vb = 0;iG 		eofblk = ( (long)dhp->h_rms.f_heof[0] << 16 ) + dhp->h_rms.f_heof[1];i 		limit = &dirbuf[BUFSIZE];  	}: 	if ( bod || (de+=(recsize+2))>=limit || recsize==STOP ) { 		if ( ++vb == eofblk )"& 			limit = &dirbuf[dhp->h_rms.f_ffby];> 		if ( !getvb(vb,dirbuf,dhp) || (*((ushort *)dirbuf)) == STOP)! 			return((struct directory *)0);= 		de = dirbuf; 	} 	if ( de >= limit )e  		return((struct directory *)0);  	return((struct directory *)de); }v     /*D  *  Get a file header, given the file number; check access privilege  */w  ) int gethdr(ushort fnum,struct header *hp)t {= #define G_DENY	bit(8)c #define W_DENY	bit(12) 	register long	bn;
 	int		grp; 	int		ogrp;   4 	bn = (long)fnum + hblock.H_ibvb + hblock.H_ibsz -1;% 	if ( !getvb(bn,(char *)hp,&indexh) )e 		return(0);( 	if ( !(hp->h_fpro&W_DENY) || !getuid()) 		return(1); 	grp = getgid();2 	ogrp = 64*(grp/100) + 8*((grp/10)%10) + (grp%10);
 #ifdef VMS8 	/* the user must have LOGIO priv to run this anyway. */ 	return(1);) #endif/ 	if ( ogrp != hp->h_proj || hp->h_fpro&G_DENY )h
 		return(-1);t 	else1 		return(1); }x     /*B  *  Routine to get specified virtual block from a file.  Returns 0@  *  on EOF, 1 otherwise.  Note that vbn is 1-based, not 0-based.  */*  / int getvb(long vbn,char *buf,struct header *hp)  {" #define WTPMASK 0140000h #define WTP00	0000000d #define WTP01	0040000m #define WTP10	0100000g #define WTP11	0140000r 	register ushort 	*rp; 	register long		block; 	register ushort 	*limit;  	register ushort 	wtype; 	register long		lbn; 	register long		size;r 	ushort			getsize();  ' 	rp = (ushort *)hp + (hp->h_mpof&0377);= 	block = 1;), 	limit = rp + (hp->h_use & 0377);		/* ntw */@ 	while ( rp < limit && vbn >= ( block + (size=getsize(rp)) ) ) { 		wtype = (*rp) & WTPMASK; 		switch (wtype) { 			case WTP00:	rp += 1; break; 			case WTP01:	rp += 2; break; 			case WTP10:	rp += 3; break; 			case WTP11:	rp += 4; break; 		}  		block += size; 	} 	if ( rp >= limit )r 		return(0);! 	lbn = lbnbase(rp) + vbn - block;f 	return(getlb(lbn,buf)); }"     /*8  *  Return number of blocks mapped by the current window  */o   ushort getsize(rp)  register ushort *rp; {d 	register ushort wtype;d   	wtype = (*rp) & WTPMASK;s 	switch (wtype) {* 		case WTP00:	return(0);/ 		case WTP01:	return(((*((char *)rp))&0377)+1);*' 		case WTP10:	return(((*rp)&037777)+1);); 		case WTP11:	return(((((long)(*rp)&037777)<<16)+rp[1])+1);v 	} }n     /*0  *  Return base lbn mapped by the current window  */c  ! long lbnbase(register ushort *rp)  {r 	register ushort wtype;    	wtype = (*rp)&WTPMASK;i 	switch ( wtype ) {c 		case WTP00:	return(0L);t9 		case WTP01:	return(((((char *)rp)[1]&077L)<<16)+rp[1]);s6 		case WTP10:	return((((long)rp[2])<<16)+(long)rp[1]);6 		case WTP11:	return((((long)rp[3])<<16)+(long)rp[2]); 	} }d     /*A  *  Get block from the filesystem, given the logical block number*  */	   int getlb(long	lbn,char *buf)E {l 	if ( lbn == 0L )( 		err0("Bad block in file");
 #ifdef VMS 	{int retcode; 	 short iosb[4];4 	 retcode = sys$qiow(0,vmsfd,IO$_READLBLK,&iosb,0,0, 			    buf,BUFSIZE,lbn,  			    0,0,0);: 	 if (retcode != SS$_NORMAL) err1("QIO error %d",retcode);@ 	 if (iosb[0] != SS$_NORMAL) err1("READVBLK error %d",iosb[0]);} #else P 	if ( lseek(vmsfd,BUFSIZE*lbn,0) == -1L ||  read(vmsfd,buf,BUFSIZE) != BUFSIZE ) 		err0("Read error");( #endif 	return(1);d }a     /*  *  Issue an error message  */;   void errmsg(char *msg,...) {va_list arglist;g  fprintf(stderr,"%s -- ",*av);  va_start(arglist,msg);p  vfprintf(stderr,msg,arglist);  va_end(arglist);p  fprintf(stderr,"\n");}-