 /*  *  local_net_check.c   *  *A  *  Callout module for performing local network address and relay   *  checks for MX SMTP server.  '    Copyright (c) 2008, Matthew Madison.          All rights reserved.      E    Redistribution and use in source and binary forms, with or without E    modification, are permitted provided that the following conditions     are met:      =        * Redistributions of source code must retain the above D          copyright notice, this list of conditions and the following          disclaimer.@        * Redistributions in binary form must reproduce the aboveD          copyright notice, this list of conditions and the followingH          disclaimer in the documentation and/or other materials provided          with the distribution. E        * Neither the name of the copyright owner nor the names of any F          other contributors may be used to endorse or promote productsB          derived from this software without specific prior written          permission.     F    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORSD    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOTH    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FORG    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT H    OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,C    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT H    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,H    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANYF    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORTH    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEG    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.   *  *!  *  To build this module (ALPHA):   *  *  $ CC/DECC LOCAL_NET_CHECK U  *  $ LINK/SHARE/EXEC=dev:[dir]LOCAL_NET_CHECK.EXE LOCAL_NET_CHECK.OBJ,SYS$INPUT:/OPT D  *  SYMBOL_VECTOR=(INIT=PROCEDURE,CHECK=PROCEDURE,CLEANUP=PROCEDURE)  *  <ctrl/Z>  *  *  To build this module (VAX):   *  $ CC/DECC LOCAL_NET_CHECK U  *  $ LINK/SHARE/EXEC=dev:[dir]LOCAL_NET_CHECK.EXE LOCAL_NET_CHECK.OBJ,SYS$INPUT:/OPT    *  UNIVERSAL=INIT,CHECK,CLEANUP  *  <ctrl/Z>  *5  *  To make this module available to the SMTP server:   *M  *  $ DEFINE/SYSTEM/EXEC MX_SITE_LOCAL_NETWORK_CHECK dev:[dir]LOCAL_NET_CHECK   *  *O  *  N.B.:  The MX SMTP server uses asynchronous I/O to manage multiple incoming N  *         connections.  Be careful when performing any I/O operations in thisL  *         module, since any significant delays could cause SMTP sessions to  *         fail!  *M  *  N.B.:  Be careful about using C run-time library routines in this module. K  *         It is loaded by the SMTP server dynamically at run-time, and the O  *         CRTL may not be initialized properly when these routines are called.   *  */  #include <types.h> #include <socket.h>  #include <inet.h>  #include <descrip.h> #include <lib$routines.h>  #include <stsdef.h>  #include <ssdef.h>       struct my_context {      	int        initialized;     };  >     static unsigned int myctxsize = sizeof(struct my_context); /*  *  ROUTINE NAME:  INIT   *  *  DESCRIPTION:3  *     Initializes the context used by this module.   *G  *     If you do not need to maintain any context between calls to your I  *     CHECK routine, it is OK to simply set the context pointer to NULL. A  *     If you do this, your CLEANUP routine will never be called.   *  *  PARAMETERS: ?  *     context:   address of a pointer to the allocated context   *"  *  RETURNS:   VMS condition value  */ 1 unsigned int INIT (struct my_context **context) {        unsigned int status;  -     status = LIB$GET_VM(&myctxsize, context); $     if ($VMS_STATUS_SUCCESS(status))!     	(*context)->initialized = 1;           return status;   } /* INIT */   /*    *  ROUTINE NAME:  CHECK  *  *  DESCRIPTION:R  *    Checks to see if a host's network address is local (on the "inside" network)P  *    and also indicates whether the host is permitted to use the MX SMTP serverT  *    as a relay (i.e., where both the MAIL FROM domain name and RCPT TO domain name  *    are non-local).   *  *  PARAMETERS: S  *    context:    address of a pointer to the context allocated in the INIT routine 8  *    addr:       address of the IP network address (in)[  *    relay_ok:   address of an int (out); set this to 1 if relay is permitted, 0 otherwise   *  *  RETURNS:  int -  *    1 = network address is local ("inside") /  *    0 = network address is remote ("outside")   */ N int CHECK (struct my_context **context, struct in_addr *addr, int *relay_ok) {  "     struct in_addr okaddr, okmask;       /*(      *	Sample check for loopback network      */ +     okaddr.s_addr = inet_addr("127.0.0.0"); +     okmask.s_addr = inet_addr("255.0.0.0");        /*4      *	Never allow relay, even if the host is inside      */      *relay_ok = 0;       /*6      *  The check -- apply the netmask to the address;E      *  it is local if the result matches the loopback network number       */ E     return ((addr->s_addr & okmask.s_addr) == okaddr.s_addr) ? 1 : 0;   
 } /* CHECK */    /*  *  ROUTINE NAME:   CLEANUP   *  *  DESCRIPTION:F  *    Cleans up the context allocated in the INIT routine.  Not called2  *    if the INIT routine set the context to NULL.  *  *  PARAMETERS: .  *    context:   address of pointer to context  *!  *  RETURNS:  VMS condition value   */ 4 unsigned int CLEANUP (struct my_context **context) {  %     LIB$FREE_VM(&myctxsize, context);        *context = 0;        return SS$_NORMAL;   } /* CLEANUP */ 