 /*  *  auth_callout_example.c  *I  *  Example of an authentication callout for use with the MX SMTP server.   *  '    Copyright (c) 2008, Matthew Madison.          All rights reserved.      E    Redistribution and use in source and binary forms, with or without E    modification, are permitted provided that the following conditions     are met:      =        * Redistributions of source code must retain the above D          copyright notice, this list of conditions and the following          disclaimer.@        * Redistributions in binary form must reproduce the aboveD          copyright notice, this list of conditions and the followingH          disclaimer in the documentation and/or other materials provided          with the distribution. E        * Neither the name of the copyright owner nor the names of any F          other contributors may be used to endorse or promote productsB          derived from this software without specific prior written          permission.     F    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORSD    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOTH    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FORG    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT H    OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,C    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT H    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,H    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANYF    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORTH    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEG    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.   *  *  MODULE DESCRIPTION:   *@  *  	This module contains routines that implement an alternativeD  *  authentication source for use with the AUTH PLAIN and AUTH LOGIND  *  authentication mechanisms implemented by the MX SMTP server.  ItD  *  may also provide an optional accounting callout, which is calledI  *  by the SMTP server after each message accepted from the authenticated   *  client.   *  &  *  Building the callout module (VAX):  *#  *  	$ CC/DECC AUTH_CALLOUT_EXAMPLE E  *  	$ LINK/NOTRACE/SHARE AUTH_CALLOUT_EXAMPLE.OBJ, SYS$INPUT:/OPTION 6  *      UNIVERSAL=INIT,AUTHENTICATE,ACCOUNTING,CLEANUP  *      ^Z ! (ctrl/Z)   *(  *  Building the callout module (Alpha):  *  *  	$ CC AUTH_CALLOUT_EXAMPLEE  *  	$ LINK/NOTRACE/SHARE AUTH_CALLOUT_EXAMPLE.OBJ, SYS$INPUT:/OPTION >  *      SYMBOL_VECTOR=(INIT=PROCEDURE,AUTHENTICATE=PROCEDURE,->  *                     ACCOUNTING=PROCEDURE,CLEANUP=PROCEDURE)  *      ^Z ! (ctrl/Z)   *  *  Installing the callout: Z  *      $ DEFINE/SYSTEM/EXEC MX_SITE_SMTP_AUTHENTICATION dev:[dir]AUTH_CALLOUT_EXAMPLE.EXE(  *  	$ MCP SET SMTP/AUTHENTICATION=PLAIN  *  	$ MCP SHUTDOWN SMTP_SERVER -  *      $ @SYS$STARTUP:MX_STARTUP SMTP_SERVER   */  #include <descrip.h> #include <socket.h>  #include <str$routines.h>  #include <lib$routines.h>  #include <starlet.h> #include <stsdef.h>  #include <ssdef.h> #include <string.h>   0 #define OK(status_) $VMS_STATUS_SUCCESS(status_)       /*7      *	Context structure used to track a single session       */ 8     typedef unsigned int (*ast_routine_t)(void *astprm);       typedef struct {     	unsigned int	placeholder;     	ast_routine_t	astadr;     	void	    	*astprm;      	unsigned int	*authstatus;     	unsigned int	*sessid;     	int 	    	success;      } auth_context_t;     D     static const unsigned int context_size = sizeof(auth_context_t);       /*      *	Forward declarations       */ %     unsigned int INIT(void **ctxptr); Q     unsigned int AUTHENTICATE(void **ctxptr, const struct dsc$descriptor *usrnam, W     	    	    	      const struct dsc$descriptor *pass, const struct sockaddr *cliaddr, T     	    	    	      int cliaddrlen, unsigned int *sessid, unsigned int *authstatus,9     	    	    	      ast_routine_t astadr, void *astprm); /     static unsigned int auth_ast(void *astprm); c     unsigned int ACCOUNTING(void **ctxptr, const unsigned int *sessid, const unsigned int *msgsize, ]     	    	    	    const struct dsc$descriptor *fromadr, const struct dsc$descriptor *toadr); (     unsigned int CLEANUP(void **ctxptr);   /*  *  ROUTINE:	INIT   *  *  DESCRIPTION:X  *  	Initializes an authentication session.  Responsible for allocating and initializingZ  *  	a context block for later authentication and accounting.  This routine is called once<  *  	per SMTP session for which authentication is requested.  *  *  PARAMETERS: ;  *  	ctxptr:	    context block address, passed by reference   *   *  RETURNS:	VMS condition value  *  */ # unsigned int INIT (void **ctxptr) {        auth_context_t  *ctx;      unsigned int    status;   .     status = lib$get_vm (&context_size, &ctx);       if (OK(status)) { "     	memset(ctx, 0, sizeof(*ctx));     	*ctxptr = ctx;      }        return status;   } /* INIT */   /*  *  ROUTINE:	AUTHENTICATE   *  *  DESCRIPTION:[  *  	Performs authentication for a username/password combination.  If this routine requires X  *  	any I/O operation that may not complete immediately, it should use asynchronous I/OX  *  	and its AST completion routine should call the AST routine that is passed in by the  *  	caller.  *Y  *  	Only one authentication request will ever be outstanding for a single authentication i  *  	context, so the context block can be used to store the caller's AST routine address, AST parameter,  S  *  	and authentication status address for later use by its AST completion routine.   *V  *  	Note that the SMTP server provides the username and password _exactly_ as sent byV  *  	the client.  No case conversion, blank stripping, or other editing is done by the  *  	server.  *  *  PARAMETERS: ^  *  	ctxptr:	    (in) context block address (as returned by INIT routine), passed by referenceG  *  	usrnam:	    (in) username provided by client, passed by descriptor E  *  	pass:	    (in) password provided by client, passed by descriptor G  *  	cliaddr:    (in) socket address of the client, passed by reference G  *  	cliaddrlen: (in) length of cliaddr socket address, passed by value E  *  	sessid:	    (out) authentication session ID, passed by reference c  *  	authstatus: (out) cond_value indicating success/failure of authentication, passed by reference Q  *  	astadr:	    (in) address of caller's AST completion routine, passed by value H  *  	asptrm:	    (in) parameter to caller's AST routine, passed by value  *   *  RETURNS:	VMS condition valueX  *      -   success status indicates that asynchronous I/O was started and caller should7  *  	    expect its AST completion routine to be called T  *  	-   non-success status indicates that the operation completed synchronously andX  *  	    that the authstatus argument is valid immediately upon return from this routine  */ N unsigned int AUTHENTICATE (void **ctxptr, const struct dsc$descriptor *usrnam,T     	    	    	   const struct dsc$descriptor *pass, const struct sockaddr *cliaddr,Q     	    	    	   int cliaddrlen, unsigned int *sessid, unsigned int *authstatus, 7     	    	    	   ast_routine_t astadr, void *astprm) {   &     auth_context_t  *ctx    = *ctxptr;     unsigned int    status;   !     ctx->authstatus = authstatus;      ctx->sessid	    = sessid;      ctx->astadr	    = astadr;      ctx->astprm	    = astprm;        /*U      *	Even though we don't perform any I/O here, we use the AST completion mechanism U      *  for demonstration purposes.  Set the "success" context field for later use by "      *	our AST completion routine.      */      ctx->success = 0; U     if (usrnam->dsc$w_length == 6 && memcmp(usrnam->dsc$a_pointer, "Farfel", 6) == 0) R     	if (pass->dsc$w_length == 6 && memcmp(pass->dsc$a_pointer, "1A2b3C", 6) == 0)     	    ctx->success = 1;  *     status = sys$dclast(auth_ast, ctx, 0);     /*L      *	If the AST isn't going to fire, then we should set the authentication3      *	status in this routine (to a failure value).       *Q      *	Note that if this routine normally completes synchronously, then it should S      *	always set the authstatus argument to the appropriate success/failure status V      *	and should always return a failure status.   The returned status only indicatesS      *	to the caller whether or not asynchronous completion is being used; it's the ^      *	authstatus argument that indicates the success or failure of the authentication itself.      */      if (!OK(status))      	*authstatus = SS$_INVLOGIN;       return status;   } /* AUTHENTICATE */   /*  *  ROUTINE:	auth_ast   *  *  DESCRIPTION:4  *  	Sample AST completion routine for AUTHENTICATE.  *  *  PARAMETERS: 8  *  	astprm:	    address of our context, passed by value  *!  *  RETURNS:  VMS condition value D  *  	Always returns SS$_NORMAL (returned value is actually ignored)j  */ - static unsigned int auth_ast (void *astprm) {   !     auth_context_t *ctx	= astprm;   /     static unsigned int session_id_counter = 0;        /*L      *	For a successful authentication, we assign a session ID which will beR      *	included in the Received: header of any message sent by the client and willJ      *	be provided to the ACCOUNTING routine.  For this example, we simplyY      *	use a monotonically increasing integer; however, it can be any valid 32-bit value. Z      *  If you set the session ID to zero, however, the SMTP server assumes that it should/      *	not be included in the Received: header.       */      if (ctx->success) { #     	*ctx->authstatus = SS$_NORMAL; )     	*ctx->sessid = ++session_id_counter; 
     } else%     	*ctx->authstatus = SS$_INVLOGIN;        /*7      *	Now inform the caller that the I/O has completed       */ '     return (*ctx->astadr)(ctx->astprm);    } /* auth_ast */   /*  *  ROUTINE:	ACCOUNTING   *  *  DESCRIPTION:S  *  	Accounting callout, called by the SMTP server after a message is accepted from S  *  	the authenticated client.  Note that this routine may be called multiple times 4  *  	for each message -- once per recipient address.  *M  *  	Note that this routine is optional; it is only called by the SMTP serverwF  *  	if it is provided by the installed authentication callout module.  *  *  PARAMETERS: ^  *  	ctxptr:	    (in) context block address (as returned by INIT routine), passed by reference[  *  	sessid:	    (in) session ID (as assigned by AUTHENTICATE routine), passed by reference*N  *  	msgsize:    (in) number of bytes in the message body, passed by reference>  *  	fromadr:    (in) MAIL FROM: address, passed by descriptor;  *  	toadr:	    (in) RCPT TO: address, passed by descriptore  *   *  RETURNS:	VMS condition value+  *  	The caller ignores the returned value.   */s` unsigned int ACCOUNTING (void **ctxptr, const unsigned int *sessid, const unsigned int *msgsize,[     	    	    	 const struct dsc$descriptor *fromadr, const struct dsc$descriptor *toadr) {t  F     static $DESCRIPTOR(ctrstr, "!%D ID=!UL SIZE=!UL FROM=!AS TO=!AS");     struct dsc$descriptor dsc;     char buf[512];     unsigned int status;  $     dsc.dsc$b_class = DSC$K_CLASS_S;$     dsc.dsc$b_dtype = DSC$K_DTYPE_T;#     dsc.dsc$w_length = sizeof(buf);N     dsc.dsc$a_pointer = buf;  ]     status = sys$fao(&ctrstr, &dsc.dsc$w_length, &dsc, 0, *sessid, *msgsize, fromadr, toadr);M     if (OK(status))      	lib$put_output(&dsc);       return status;   } /* ACCOUNTING */     /*  *  ROUTINE:	CLEANUP  *  *  DESCRIPTION:K  *  	Called by the SMTP server to clean up after an authentication session.GZ  *  	This routine should free any resources that were allocated in the INIT, AUTHENTICATE,9  *  	or ACCOUNTING routines, including the context block.S  *  *  PARAMETERS:Ob  *  	ctxptr:	    (in/out) context block address (as returned by INIT routine), passed by reference  *!  *  RETURNS:  VMS condition valueC  */A& unsigned int CLEANUP (void **ctxptr) {       unsigned int status;  (     lib$free_vm (&context_size, ctxptr);  9     *ctxptr = 0;  /* not required, but just to be safe */N       return SS$_NORMAL;   } /* CLEANUP */y