B /*	$NetBSD: regerror.c,v 1.16 2000/01/22 22:19:17 mycroft Exp $	*/   /*- 0  * Copyright (c) 1992, 1993, 1994 Henry Spencer.!  * Copyright (c) 1992, 1993, 1994 E  *	The Regents of the University of California.  All rights reserved.   *@  * This code is derived from software contributed to Berkeley by  * Henry Spencer.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *(  *	@(#)regerror.c	8.4 (Berkeley) 3/20/94  */    #include "cdefs.h"( #if defined(LIBC_SCCS) && !defined(lint) #if 0 ? static char sccsid[] = "@(#)regerror.c	8.4 (Berkeley) 3/20/94";  #else H __RCSID("$NetBSD: regerror.c,v 1.16 2000/01/22 22:19:17 mycroft Exp $"); #endif# #endif /* LIBC_SCCS and not lint */    #include "namespace.h" #include types   #include ctype #include limits  #include "regex.h" #include stdlib  #include string  #include descrip #include starlet   #ifdef __weak_alias   __weak_alias(regerror,_regerror) #endif   #include "utils.h"  9 /* ========= begin header generated by ./mkh ========= */  #ifdef __cplusplus extern "C" { #endif   /* === regerror.c === */O static char *regatoi __P((const regex_t *preg, char *localbuf, size_t buflen));    #ifdef __cplusplus }  #endif7 /* ========= end header generated by ./mkh ========= */  /*  = #define	REG_NOMATCH	 1   = #define	REG_BADPAT	 2  = #define	REG_ECOLLATE	 3  = #define	REG_ECTYPE	 4  = #define	REG_EESCAPE	 5   = #define	REG_ESUBREG	 6   = #define	REG_EBRACK	 7  = #define	REG_EPAREN	 8  = #define	REG_EBRACE	 9  = #define	REG_BADBR	10   = #define	REG_ERANGE	11  = #define	REG_ESPACE	12  = #define	REG_BADRPT	13  = #define	REG_EMPTY	14   = #define	REG_ASSERT	15  = #define	REG_INVARG	165  = #define	REG_ATOI	255	// convert name to number (!) 6  = #define	REG_ITOA	0400	// convert number to name (!)  */  static const struct rerr {
 	int code; 	const char *name; 	const char *explain; 
 } rerrs[] = { = 	{ REG_NOMATCH,	"REG_NOMATCH",	"regexec() failed to match" }, < 	{ REG_BADPAT,	"REG_BADPAT",	"invalid regular expression" },? 	{ REG_ECOLLATE,	"REG_ECOLLATE",	"invalid collating element" }, 9 	{ REG_ECTYPE,	"REG_ECTYPE",	"invalid character class" }, ; 	{ REG_EESCAPE,	"REG_EESCAPE",	"trailing backslash (\\)" }, @ 	{ REG_ESUBREG,	"REG_ESUBREG",	"invalid backreference number" },= 	{ REG_EBRACK,	"REG_EBRACK",	"brackets ([ ]) not balanced" }, : 	{ REG_EPAREN,	"REG_EPAREN",	"parentheses not balanced" },5 	{ REG_EBRACE,	"REG_EBRACE",	"braces not balanced" }, ; 	{ REG_BADBR,	"REG_BADBR",	"invalid repetition count(s)" }, 9 	{ REG_ERANGE,	"REG_ERANGE",	"invalid character range" }, / 	{ REG_ESPACE,	"REG_ESPACE",	"out of memory" }, E 	{ REG_BADRPT,	"REG_BADRPT",	"repetition-operator operand invalid" }, 5 	{ REG_EMPTY,	"REG_EMPTY",	"empty (sub)expression" }, E 	{ REG_ASSERT,	"REG_ASSERT",	"\"can't happen\" -- you found a bug" }, C 	{ REG_INVARG,	"REG_INVARG",	"invalid argument to regex routine" }, 1 	{ 0,		"",		"*** unknown regexp error code ***" }  };   /*,  * regerror - the interface to error numbers@  * extern size_t regerror(int, const regex_t *, char *, size_t);  */  /* ARGSUSED */ size_t/ mx_regerror(errcode, preg, errbuf, errbuf_size)  int errcode; const regex_t *preg;
 char *errbuf;  size_t errbuf_size;  {  	const struct rerr *r; 	size_t len;" 	int target = errcode &~ REG_ITOA; 	const char *s;  	char convbuf[50];  2 	_DIAGASSERT(errcode != REG_ATOI || preg != NULL); 	_DIAGASSERT(errbuf != NULL);    	if (errcode == REG_ATOI) - 		s = regatoi(preg, convbuf, sizeof convbuf);  	else { $ 		for (r = rerrs; r->code != 0; r++) 			if (r->code == target) 
 				break; 	  		if (errcode & REG_ITOA) {  			if (r->code != 0) {4 				(void)strncpy(convbuf, r->name, sizeof convbuf);( 				convbuf[sizeof(convbuf) - 1] = '\0'; 			} else { >                                 $DESCRIPTOR(fmt, "REG_0x!XL");:                                 struct dsc$descriptor dsc;3                                 unsigned short len; @                                 dsc.dsc$b_dtype = DSC$K_DTYPE_T;@                                 dsc.dsc$b_class = DSC$K_CLASS_S;F                                 dsc.dsc$w_length = sizeof convbuf - 1;<                                 dsc.dsc$a_pointer = convbuf;M                                 if (!(sys$fao(&fmt, &len, &dsc, target) & 1)) ,                                     len = 0;4                                 convbuf[len] = '\0';                         }  			s = convbuf;  		} else 			s = r->explain; 	}   	len = strlen(s) + 1;  	if (errbuf_size > 0) { , 		(void)strncpy(errbuf, s, errbuf_size - 1); 		errbuf[errbuf_size-1] = '\0';  	}  
 	return(len);  }    /*3  * regatoi - internal routine to implement REG_ATOI L  * static char *regatoi(const regex_t *preg, char *localbuf, size_t buflen);  */ 
 static char *  regatoi(preg, localbuf, buflen)  const regex_t *preg; char *localbuf;  size_t buflen; {  	const struct rerr *r;"         struct dsc$descriptor dsc;         unsigned short len;           $DESCRIPTOR(fmt, "!UL");  # 	for (r = rerrs; r->code != 0; r++) * 		if (strcmp(r->name, preg->re_endp) == 0)	 			break;  	if (r->code == 0) 		return("0");  (         dsc.dsc$b_dtype = DSC$K_DTYPE_T;(         dsc.dsc$b_class = DSC$K_CLASS_S;&         dsc.dsc$w_length = buflen - 1;%         dsc.dsc$a_pointer = localbuf; 6         if (!(sys$fao(&fmt, &len, &dsc, r->code) & 1))             len = 0;         localbuf[len] = '\0';  	return(localbuf); } 