 /*	  *  mem.c   *<  *  Memory management routines for ADDRESS_REWRITER callout.  *=  *  Copyright  2001, MadGoat Software.  All Rights Reserved.   */  #include "address_rewriter.h"  #include <libvmdef.h>    /*  *  Forward declarations  */ &     void    	 mem_init(config_t *cfg);0     void         mem_destroy_all(config_t *cfg);T     mailbox_t   *mem_mailbox_alloc(config_t *cfg, const char *act, u_int16_t actlen,F                                    const char *des, u_int16_t deslen);O     vms_status_t mem_node_alloc(void *symbol, void *new_node, void *user_data);    /*  *  ROUTINE:	mem_init   *  *  DESCRIPTION:>  *  	Initializes the memory zones for use with these routines.  *  *  PARAMETERS:	none  *  *  RETURNS:	void   */  void mem_init (config_t *cfg) {        vms_status_t    status;      u_int32_t	    alg;     u_int32_t	    param;F     u_int32_t	    flags   = LIB$M_VM_GET_FILL0 | LIB$M_VM_EXTEND_AREA;       alg = LIB$K_VM_FIXED;      param = sizeof(node_t); J     status = LIB$CREATE_VM_ZONE(&cfg->cfg_nodezone, &alg, &param, &flags);     if (!OK(status))         cfg->cfg_nodezone = 0;       alg = LIB$K_VM_FREQ_SIZES;     param = 8;I     status = LIB$CREATE_VM_ZONE(&cfg->cfg_mbxzone, &alg, &param, &flags);      if (!OK(status))         cfg->cfg_mbxzone = 0;    } /* mem_init */       /*  *  ROUTINE:	mem_destroy_all  *  *  DESCRIPTION:1  *  	Deletes the memory zones used for the trees.   *  *  PARAMETERS:	none  *  *  RETURNS:	void   */ & void mem_destroy_all (config_t *cfg) {       vms_status_t    status;        if (cfg->cfg_nodezone != 0) /         LIB$DELETE_VM_ZONE(&cfg->cfg_nodezone);        if (cfg->cfg_mbxzone != 0).         LIB$DELETE_VM_ZONE(&cfg->cfg_mbxzone);  -     cfg->cfg_nodezone = cfg->cfg_mbxzone = 0;    } /* mem_destroy_all */    /*  *  ROUTINE:	mem_mailbox_alloc  *  *  DESCRIPTION:H  *  	Allocates a mailbox structure from the mailbox zone, filling in the  *  	name and rewrite address.  *  *  PARAMETERS: 2  *  	act:	    char_string, read only, by reference3  *  	actlen:     word_unsigned, read only, by value 2  *  	des:	    char_string, read only, by reference3  *  	deslen:     word_unsigned, read only, by value   *  *  RETURNS:	mailbox_t pointer  *  	0:  	error occurred  *  	non-0:	valid pointer   */ t mailbox_t *mem_mailbox_alloc (config_t *cfg, const char *act, u_int16_t actlen, const char *des, u_int16_t deslen) {  ?     int              len = sizeof(mailbox_t) + actlen + deslen;      mailbox_t	    *mbx;      vms_status_t    status;      7     status = LIB$GET_VM(&len, &mbx, &cfg->cfg_mbxzone);      if (!OK(status))     	return 0;       mbx->mbx_actlen = actlen; )     mbx->mbx_actual = (char *) (mbx + 1); )     memcpy(mbx->mbx_actual, act, actlen);      mbx->mbx_deslen = deslen; 0     mbx->mbx_desired = mbx->mbx_actual + actlen;*     memcpy(mbx->mbx_desired, des, deslen);       return mbx;    } /* mem_mailbox_alloc */    /*  *  ROUTINE:	mem_node_alloc   *  *  DESCRIPTION:.  *  	Allocates a tree node from the node zone.  *  *  PARAMETERS: /  *      symbol:     mailbox_t pointer, by value 0  *      new_node:   node_t pointer, by reference,  *  	user_data:  cconfig_t pointer, by value  *  *  RETURNS:	vms_status_t   */ M vms_status_t mem_node_alloc (void *symbol, void *new_node, void *user_data) {   &     node_t         **nodep = new_node;     node_t          *node;%     config_t        *cfg = user_data; *     int              len = sizeof(node_t);     vms_status_t     status;  9     status = LIB$GET_VM(&len, &node, &cfg->cfg_nodezone);      if (OK(status)) {           node->node_mbx = symbol;         *nodep = node;     }        return status;   } /* mem_node_alloc */