 /*  *  config.c  *8  *  Configuration routines for ADDRESS_REWRITER callout.  *=  *  Copyright  2001, MadGoat Software.  All Rights Reserved.   */  #include "address_rewriter.h"  #include <starlet.h> #include <rms.h> #include <stdarg.h>  #include <stdio.h>   /*&  *  For older versions of the compiler  */  #ifndef sys$close ) #define SYS$CLOSE               sys$close + #define SYS$CONNECT             sys$connect ' #define SYS$GET                 sys$get ( #define SYS$OPEN                sys$open) #define SYS$PARSE               sys$parse  #endif   #ifndef FAB  #define FAB fabdef #define RAB rabdef #define NAM namdef #define XABRDT xabrdtdef #endif  '     typedef struct FAB          FABDEF; '     typedef struct RAB          RABDEF; '     typedef struct NAM          NAMDEF; *     typedef struct XABRDT       XABRDTDEF; /*  *  Forward declarations  */ ;     	    vms_status_t    load_configuration(config_t *cfg); e     static  int	    	    get_next_line(RABDEF *rab, char **linepp, u_int16_t *countp, int *linenump); j     static  int	    	    get_next_word(char **linepp, u_int16_t *remainp, char **wordpp, u_int16_t *lenp);9     static  void    	    log_error(const char *fmt, ...);   %     static  unsigned int    zero = 0;         /*  *  ROUTINE:	load_configuration   *  *  DESCRIPTION:+  *  	Loads or reloads the address database.   *  *  PARAMETERS: ,  *  	cfg:	    config_t, modify, by reference  *   *  RETURNS:	VMS condition value  */ 1 vms_status_t load_configuration (config_t *cfg) {        FABDEF  	    fab;      RABDEF  	    rab;      NAMDEF  	    nam;      XABRDTDEF	    xabrdt;      vms_status_t    status; -     char    	    *linep, *actp, *desp, *msgp; (     u_int16_t	    count, actlen, deslen;     mailbox_t       *mbx;      node_t          *node;     int	    	    linenum, i;#     char    	    line_buffer[2048]; 7     char    	    espec[MAX_FN_LEN], rspec [MAX_FN_LEN];        fab = cc$rms_fab;      nam = cc$rms_nam;      xabrdt = cc$rms_xabrdt;        fab.fab$b_fac = FAB$M_GET;!     fab.fab$b_shr = FAB$M_SHRGET; )     fab.fab$l_fna = "MX_ALIAS_ADDRESSES"; *     fab.fab$b_fns = strlen(fab.fab$l_fna);"     fab.fab$l_dna = "MX_DIR:.TXT";*     fab.fab$b_dns = strlen(fab.fab$l_dna);%     fab.fab$l_xab = (void *) &xabrdt;      fab.fab$l_nam = &nam;      nam.nam$l_esa = espec;!     nam.nam$b_ess = MAX_FN_LEN-1;      nam.nam$l_rsa = rspec;!     nam.nam$b_rss = MAX_FN_LEN-1;        status = SYS$OPEN(&fab);     if (!OK(status))     	return status;        rab = cc$rms_rab;      rab.rab$l_fab = &fab;      rab.rab$v_rah = 1;     status = SYS$CONNECT(&rab);      if (!OK(status)) {     	SYS$CLOSE(&fab);      	nam.nam$v_synchk = 1;     	SYS$PARSE(&fab);      	return status;      }        /*;      *	If no change to configuration file, don't re-read it       */      if (cfg->cfg_loaded) {)         struct dsc$descriptor dsc1, dsc2; 8         INIT_SDESC(&dsc1, nam.nam$b_rsl, nam.nam$l_rsa);:         INIT_SDESC(&dsc2, cfg->cfg_fnlen, cfg->cfg_fname);8         if (STR$CASE_BLIND_COMPARE(&dsc1, &dsc2) == 0 &&V             memcmp(&cfg->cfg_moddt, &xabrdt.xab$q_rdt, sizeof(cfg->cfg_moddt)) == 0) {     	    SYS$CLOSE(&fab);      	    nam.nam$v_synchk = 1;     	    SYS$PARSE(&fab);      	    return SS$_NORMAL;      	}  
         /*6          *  Need to reload, clean up the configuration          */          mem_destroy_all(cfg);          cfg->cfg_hdrtree = 0;          cfg->cfg_envtree = 0;          cfg->cfg_loaded = 0;         mem_init(cfg);       } /* if reloading */        rab.rab$l_ubf = line_buffer;(     rab.rab$w_usz = sizeof(line_buffer);       linenum = 0;  &     msgp = "configuration file empty";     status = 0;   ;     while (get_next_line(&rab, &linep, &count, &linenum)) {        	status = 0;  *         msgp = "expecting actual address";9     	if (!get_next_word(&linep, &count, &actp, &actlen))       	    break;   +         msgp = "expecting desired address"; ;         if (!get_next_word(&linep, &count, &desp, &deslen))              break;  +         msgp = "memory allocation failure"; A         mbx = mem_mailbox_alloc(cfg, actp, actlen, desp, deslen);          if (mbx == 0)              break;  (         msgp = "tree insertion failure";3         status = LIB$INSERT_TREE(&cfg->cfg_hdrtree, 9                                  (librtl_symbol_t *) mbx, '                                  &zero, ?                                  (librtl_cmprtn_t) hdr_compare, B                                  (librtl_alcrtn_t) mem_node_alloc,'                                  &node, &                                  cfg);         if (!OK(status))             break;3         status = LIB$INSERT_TREE(&cfg->cfg_envtree, 9                                  (librtl_symbol_t *) mbx, '                                  &zero, ?                                  (librtl_cmprtn_t) env_compare, B                                  (librtl_alcrtn_t) mem_node_alloc,'                                  &node, &                                  cfg);         if (!OK(status))             break;       	status = SS$_NORMAL;        } /* while get_next_line */        if (!OK(status)) {A     	log_error("Error in configuration file %.*s, line %d: %s\n", <     	    	    	nam.nam$b_rsl, nam.nam$l_rsa, linenum, msgp);         mem_destroy_all(cfg);          cfg->cfg_hdrtree = 0;          cfg->cfg_envtree = 0;          mem_init(cfg);     } else {$     	cfg->cfg_fnlen = nam.nam$b_rsl;3     	memcpy(cfg->cfg_fname, rspec, cfg->cfg_fnlen); K         memcpy(&cfg->cfg_moddt, &xabrdt.xab$q_rdt, sizeof(cfg->cfg_moddt));          cfg->cfg_loaded = 1;     }        SYS$CLOSE(&fab);     nam.nam$v_synchk = 1;      SYS$PARSE(&fab);     return status;   } /* load_configuration */   /*  *  ROUTINE:	get_next_line  *  *  DESCRIPTION:E  *  	Gets the next non-comment line from a file, trimming off leading   *  	whitespace.  *D  *  	Comments begin with an exclamation point (!) or pound sign (#).  *  *  PARAMETERS: *  *  	rab:	    RABDEF, modify, by reference5  *  	linepp:	    string pointer, modify, by reference 4  *  	countp:	    word_unsigned, modify, by reference*  *  	linenump:   int, modify, by reference  *  *  RETURNS:	int  *  	1 = success  *  	0 = failure  */ Y static int get_next_line (RABDEF *rab, char **linepp, u_int16_t *countp, int *linenump) {        char    	    *linep;     u_int16_t	    count;       while (OK(SYS$GET(rab))) {       	*linenump += 1;       	linep = rab->rab$l_rbf;     	count = rab->rab$w_rsz;  =     	while (count > 0 && (*linep == ' ' || *linep == '\t')) {      	    linep += 1;     	    count -= 1;     	}  6     	if (count == 0 || *linep == '!' || *linep == '#')     	    continue;       	*linepp = linep;      	*countp = count;        	return 1;       }   
     return 0;    } /* get_next_line */    /*  *  ROUTINE:	get_next_word  *  *  DESCRIPTION:H  *  	Gets the next "word" (string of non-whitespace characters or quotedM  *  	string) from a line.  Stops if it hits end of line or comment delimiter. H  *  	Increments position in line past next batch of whitespace after the  *  	discovered word.   *D  *  	Comments begin with an exclamation point (!) or pound sign (#).  *  *  PARAMETERS: 5  *  	linepp:	    string pointer, modify, by reference 4  *  	remainp:    word_unsigned, modify, by reference5  *  	wordpp:	    string pointer, modify, by reference 2  *  	lenp:	    word_unsigned, modify, by reference  *  *  RETURNS:	int  *  	1 = success  *  	0 = failure  */ ^ static int get_next_word (char **linepp, u_int16_t *remainp, char **wordpp, u_int16_t *lenp) {  "     char    	    *linep = *linepp;$     u_int16_t	    remain = *remainp;     char    	    *wordp;       if (remain == 0)     	return 0;  '     if (*linep == '!' || *linep == '#')      	return 0;       wordp = linep;       while (remain > 0) {         if (*linep == '"') {             linep += 1;              remain -= 1;.     	    while (remain > 0 && *linep != '"') {0     	        if (*linep == '\\' && remain > 1) {     	    	    linep += 2;      	    	    remain -= 2;     	    	    continue;      	        }     	        linep += 1;     	        remain -= 1; 
             }              if (remain > 0) {                  linep += 1;                  remain -= 1;
             } 5         } else if (*linep == ' ' || *linep == '\t') {      	    break;          } else {             linep += 1;              remain -= 1;	         }      }        *wordpp = wordp;     *lenp = linep - wordp;  =     while (remain > 0 && (*linep == ' ' || *linep == '\t')) {      	linep += 1;     	remain -= 1;      } 
     	    	     *linepp = linep;     *remainp = remain;  
     return 1;    } /* get_next_word */      /*  *  ROUTINE:	log_error  *  *  DESCRIPTION:.  *  	Logs an error message to standard output.  *  *  PARAMETERS: 2  *  	fmt:	    char_string, read only, by reference$  *  	... 	    variable argument list  *  *  RETURNS:	void   */ . static void log_error (const char *fmt, ...) {        struct dsc$descriptor   dsc;      char    	    	    buf[2048];     va_list  	    	    ap;  '     INIT_SDESC(&dsc, sizeof(buf), buf);      va_start(ap, fmt);.     dsc.dsc$w_length = vsprintf(buf, fmt, ap);     va_end(ap);        LIB$PUT_OUTPUT(&dsc);    } /* log_error */ 