 /*5 	MBMONCP - MBMON Control Program - the user interface     COPYRIGHT NOTICE   F  This software is COPYRIGHT (c) 2005, Ian Miller. ALL RIGHTS RESERVED.  9  Released under licence described in freeware_readme.txt      DISCLAIMER   K THIS PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"  Q AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED F WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE AREO DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR N ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGESL (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;N LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ONG ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT M (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS < SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */ #pragma module MBMONCP "V0.1"   ( /* define the version to be displayed */ #define VERSION "V1.0"   #include <stdio.h> #include <stdlib.h>  #include <ctype.h> #include <descrip.h> #include <climsgdef.h> #include <cli$routines.h>  #include <rmsdef.h>  #include <smgmsg.h>  #include <ssdef.h> #include <varargs.h> #include <stsdef.h>  #include <hlpdef.h>  #include <string.h>  #include <errno.h> #include <lib$routines.h>  #include <dvidef.h>  #include <iodef.h> #include <jpidef.h>  #include <dcdef.h> #include <starlet.h> #include <iodef.h> #if OLD_EFN  #define EFN 21 #else  #include <efndef.h>  #define EFN EFN$C_ENF  #endif   #include "mbmon.h" #include "mbmoncp.h" #include "mbmon_prv.h"  K /* bodgelet to surpress message about putmsg being called with only 1 arg*/ % //#pragma message disable TOOFEWARGSO    /* local routines	*/ static void initialise(void); C static unsigned long execute(struct dsc$descriptor_s *command_dsc); L static unsigned long read_message(unsigned long chan, unsigned short maxmsg, 	MBMON_MESSAGE *msgbuf);< static unsigned long display_message(MBMON_MESSAGE *msgbuf);E static unsigned long record_message(FILE *fp, MBMON_MESSAGE *msgbuf); I static void get_process_name(unsigned long pid, char *name, int namelen);  static FORMAT get_format(void); % static DATA_SIZE get_data_size(void); % static unsigned long get_width(void); & static unsigned long get_length(void);& static unsigned long get_output(void);@ static unsigned long create_record_file(char *name, FILE **fpp);> static unsigned long open_record_file(char *name, FILE **fpp); static void putmsg();  unsigned long exit_cmd(); ? static unsigned long get_input(struct dsc$descriptor_s *result, # 		 struct dsc$descriptor_s *prompt,  		 unsigned short *length);   $ extern unsigned int LIB$SFREE1_DD();  # /* control C AST parameter block	*/  typedef struct { , 	unsigned long *flag;	/* flag to be set			*/: 	unsigned short chan;	/* channel to have I/O cancelled	*/	3 	unsigned short ctrlc;	/* control-C was pressed		*/  } CCAP; @ static unsigned long catch_ctrl_c(unsigned short *chan,CCAP *p);  4 static unsigned long width = 80;	/* display width	*/1 static FORMAT format = HEX;		/* display format	*/ " static DATA_SIZE data_size = BYTE;? static unsigned long max_length;		/* max of bytes to display */    /* virtual keyboard id		*/! static unsigned long keyboard_id;    /* output redirected flag	*/ static unsigned redir = FALSE;   /* output wanted flag		*/  static unsigned output = TRUE;   int  main(int argc, char *argv[]) {  	unsigned long ccode;  	unsigned short len;  	static $DESCRIPTOR_D(line_dsc);* 	static $DESCRIPTOR(prompt_dsc,"MBMON> ");   	/* initialise global data	*/  	initialise();   	/* get command line		*/    	if (argc > 1)  	{6 		ccode=LIB$GET_FOREIGN(&line_dsc,&prompt_dsc,&len,0); 	}    	else 	{0 		ccode = get_input(&line_dsc,&prompt_dsc,&len); 	}
 	while (1) 	{# 		if ((ccode & 1) != 0 && len != 0)  		{ " 			/* parse and execute command	*/( 			if (line_dsc.dsc$a_pointer[0] == '!') 				/* comment - ignore line*/ 				ccode = MBMON__NORMAL; 			else  				ccode = execute(&line_dsc);  			/* free command line		*/  			LIB$SFREE1_DD(&line_dsc); 		} 2 		else if (ccode == RMS$_EOF || ccode == SMG$_EOF) 		{  			/* end of file			*/ 			ccode = SS$_NORMAL;   			/* EOF mean exit	*/ 			exit_cmd(FALSE);  			break;	/* exit		*/  		}  		if ((ccode & 1) == 0)  		{  			/* output error message		*/ 			putmsg(ccode);  		} ) 		/* if invoked with command then exit	*/  		if (argc > 1) 	 			break;    		/* get next command line		*/0 		ccode = get_input(&line_dsc,&prompt_dsc,&len); 	} 	  	exit_cmd(FALSE); " 	return (ccode | STS$M_INHIB_MSG); }    /*& 	execute		- parse and execute command  */ static unsigned long- execute(struct dsc$descriptor_s *command_dsc)  {  	extern void VAXC$ESTABLISH(); 	unsigned long ccode;  	globalref mbmoncld;   	/* catch any exceptions		*/  	VAXC$ESTABLISH(LIB$SIG_TO_RET);   	/* parse command		*/ B 	ccode = CLI$DCL_PARSE(command_dsc,&mbmoncld,get_input,get_input); 	/* if ok, perform command	*/  	if ((ccode & 1) != 0) 		ccode = CLI$DISPATCH(TRUE);    	return(ccode);  }    /*  	monitor_cld	- monitor a mailbox */
 unsigned long  monitor_cmd(void)  { ) 	static $DESCRIPTOR(record_dsc,"RECORD"); % 	static $DESCRIPTOR(name_dsc,"NAME");  	$DESCRIPTOR_D(value_dsc); 	$DESCRIPTOR_D(mbname_dsc);  	$DESCRIPTOR_D(mb2name_dsc);? 	unsigned short chan1, chan2, iosb[4], mb2name_len, mbname_len;  	unsigned short msglen, ttchan; D 	char mbname[256], outfilename[256], recfilename[256], mb2name[256]; 	FILE *fprec = NULL; 	MBMON_MESSAGE *msgbuf = NULL;  	unsigned long ccode, exit_flag; 	CCAP ccap = {0}; / 	static unsigned long devclass, devbufsiz, pid;  	static ITEM dvi_list[] =  	{/ 		{sizeof(devclass),DVI$_DEVCLASS,&devclass,0}, 2 		{sizeof(devbufsiz),DVI$_DEVBUFSIZ,&devbufsiz,0}, 		{0,0,0,0}  	};   " 	/* get the mailbox device name	*/. 	ccode = CLI$GET_VALUE(&name_dsc,&mbname_dsc); 	if (!(ccode & 1)) 		return MBMON__SYNTAX; A 	memcpy(mbname,mbname_dsc.dsc$a_pointer,mbname_dsc.dsc$w_length); ( 	mbname[mbname_dsc.dsc$w_length] = '\0'; 	 4 	ccode = get_output();	/* handle OUTPUT qualifier	*/ 	if (!(ccode & 1)) 	{ 		putmsg(MBMON__OPENOUT);  		return ccode;  	}  ! 	/* open record file if wanted	*/ " 	ccode = CLI$PRESENT(&record_dsc); 	if (ccode & 1)  	{0 		ccode = CLI$GET_VALUE(&record_dsc,&value_dsc); 		if (!(ccode & 1))  			return MBMON__SYNTAX;E 		memcpy(recfilename,value_dsc.dsc$a_pointer,value_dsc.dsc$w_length); - 		recfilename[value_dsc.dsc$w_length] = '\0';  		LIB$SFREE1_DD(&value_dsc);1 		ccode = create_record_file(recfilename,&fprec);  		if (!(ccode & 1))  		{  			putmsg(MBMON__OPENREC); 			return ccode; 		}  	}   	data_size = get_data_size();  	format = get_format();  	width = get_width();  	max_length = get_length();   ( 	/* assign a channel to mb to monitor	*/1 	ccode = SYS$ASSIGN(&mbname_dsc,&chan1,0,NULL,0);  	if (!(ccode & 1)) 	{ 		LIB$SFREE1_DD(&mbname_dsc);  		return ccode;  	}  " 	/* check its a mailbox device		*/5 	ccode = SYS$GETDVIW(0,chan1,0,&dvi_list,iosb,0,0,0);          if (ccode & 1) 		ccode = iosb[0]; 	if (!(ccode & 1)) 	{ 		LIB$SFREE1_DD(&mbname_dsc);  		SYS$DASSGN(chan1); 		return ccode;  	} 	if (devclass != DC$_MAILBOX)  	{ 		LIB$SFREE1_DD(&mbname_dsc);  		SYS$DASSGN(chan1); 		return MBMON__NOTAMB;  	}  9 	/* get the device name of the mailbox being monitored */ @ 	ccode = LIB$GETDVI(&DVI$_ALLDEVNAM, &chan1, 0, 0, &mbname_dsc,  		&mbname_len);   @ 	/* create a second temporary mailbox to receive the messages	*/3 	/* (same msg size, quota is 3 x message size)			*/ - 	/* (protection is S:RWLP, O:RWLP, G,W)				*/ @ 	ccode = SYS$CREMBX(0,&chan2, devbufsiz, devbufsiz*3, 0xFF00, 0, 		NULL, 0, 0); 	if (!(ccode & 1)) 	{ 		SYS$DASSGN(chan1); 		LIB$SFREE1_DD(&mbname_dsc);  		return ccode;  	}+ 	/* get the name of my temporary mailbox	*/ A 	ccode = LIB$GETDVI(&DVI$_ALLDEVNAM, &chan2, 0, 0, &mb2name_dsc,   		&mb2name_len); 	if (!(ccode & 1)) 	{ 		LIB$SFREE1_DD(&mbname_dsc);  		SYS$DASSGN(chan1); 		SYS$DASSGN(chan2); 		return ccode;  	}  1 	/* add the mailbox to the list for monitoring	*/ ! 	ccode = mbmon_add(chan1, chan2);  	if (!(ccode & 1)) 	{ 		LIB$SFREE1_DD(&mbname_dsc);  		LIB$SFREE1_DD(&mb2name_dsc); 		SYS$DASSGN(chan1); 		SYS$DASSGN(chan2); 		return ccode;  	}  ' 	/* prepare for message reading loop	*/  	exit_flag = FALSE; 4 	msgbuf = malloc(devbufsiz + sizeof(MBMON_MESSAGE)); 	if (msgbuf == NULL) 	{ 		ccode = MBMON__ERROR;  		exit_flag = TRUE;  	}   	/* catch control C	*/ 	ccap.flag = &exit_flag; 	ccap.chan = chan2; % 	ccode = catch_ctrl_c(&ttchan,&ccap);  	if (ccode & 1) , 		fputs("Press control-C to exit\n",stderr); 	while (!exit_flag)  	{( 		/* read message from second mailbox	*/1 		ccode = read_message(chan2, devbufsiz, msgbuf);  		if (ccode & 1) 		{  			if (output) 				display_message(msgbuf); 			if (fprec != NULL) " 				record_message(fprec, msgbuf); 		}  		else 			exit_flag = TRUE;	  	} 	if (ccap.ctrlc)- 		fputs("Exiting due to control-C\n",stderr);  	if (msgbuf != NULL) 		free(msgbuf);   & 	/* remove mailbox from monitoring		*/ 	ccode = mbmon_remove(chan1);  	  	/* delete second mailbox			*/ 	SYS$DELMBX(chan2);  	SYS$DASSGN(chan2);   , 	/* deassign channel to monitored mailbox	*/ 	SYS$DASSGN(chan1);    	/* deassign channel to TT			*/  	SYS$DASSGN(ttchan);   	LIB$SFREE1_DD(&mbname_dsc); 	LIB$SFREE1_DD(&mb2name_dsc);    	if (fprec != NULL)  		fclose(fprec);   	return ccode; }    /*1 	display_cmd	- display a file previously recorded  */
 unsigned long  display_cmd(void)  { ) 	static $DESCRIPTOR(output_dsc,"OUTPUT"); ) 	static $DESCRIPTOR(record_dsc,"RECORD"); % 	static $DESCRIPTOR(name_dsc,"NAME");  	$DESCRIPTOR_D(value_dsc); 	char recfilename[256];  	FILE *fprec = NULL; 	MBMON_MESSAGE *msgbuf = NULL; 	MBMON_FHEADER *fhdr; % 	unsigned long ccode = MBMON__NORMAL;  	unsigned long exit_flag; 
 	int reclen;	 / 	int maxreclen = sizeof(MBMON_MESSAGE) + 32000;  	CCAP ccap = {0};  	unsigned short ttchan;    	/* get the filename name	*/- 	ccode = CLI$GET_VALUE(&name_dsc,&value_dsc);  	if (!(ccode & 1)) 		return MBMON__SYNTAX; D 	memcpy(recfilename,value_dsc.dsc$a_pointer,value_dsc.dsc$w_length);, 	recfilename[value_dsc.dsc$w_length] = '\0'; 	LIB$SFREE1_DD(&value_dsc);   . 	ccode = open_record_file(recfilename,&fprec); 	if (!(ccode & 1)) 	{ 		putmsg(MBMON__OPENREC);  		return ccode;  	}   	data_size = get_data_size();  	format = get_format();  	width = get_width();  	max_length = get_length();   4 	ccode = get_output();	/* handle OUTPUT qualifier	*/ 	if (!(ccode & 1)) 	{ 		putmsg(MBMON__OPENOUT);  		return ccode;  	}   	msgbuf = malloc(maxreclen); 	if (msgbuf == NULL) 		return MBMON__ERROR;   	exit_flag = FALSE;    	/* catch control C	*/ 	ccap.flag = &exit_flag; 	ccap.chan = 0; % 	ccode = catch_ctrl_c(&ttchan,&ccap);  	if (ccode & 1) , 		fputs("Press control-C to exit\n",stderr);  ? 	while (((reclen=decc$record_read(fprec,msgbuf,maxreclen)) > 0)  	&&     (!exit_flag))  	{ 		switch(msgbuf->type) 		{  		case MBMON_K_HEADER:" 			fhdr = (MBMON_FHEADER *)msgbuf;- 			if (fhdr->version == MBMON_K_FILE_VERSION)  			{% 				putmsg(MBMON__FTIME,&fhdr->time);  			} 			else  			{ 				exit_flag = TRUE; ) 				putmsg(MBMON__UNKFVER,fhdr->version);  			}	 			break;  		case MBMON_K_MESSAGE:  			display_message(msgbuf); 	 			break; 
 		default:( 			putmsg(MBMON__INVRTYPE,msgbuf->type); 			exit_flag = TRUE;	 			break;  		}  	} 	if (ccap.ctrlc)- 		fputs("Exiting due to control-C\n",stderr);    	fclose(fprec);	   	free(msgbuf);   	SYS$DASSGN(ttchan);   	return ccode; }    /* 	help_cmd	- help command */
 unsigned long  help_cmd(void) { 6 	extern unsigned long STR$CONCAT(), LBR$OUTPUT_HELP();* 	static $DESCRIPTOR(prefix_dsc,"MBMON  ");' 	static $DESCRIPTOR(topic_dsc,"TOPIC"); + 	static $DESCRIPTOR(helplib_dsc,"HELPLIB");  	$DESCRIPTOR_D(param_dsc); 	$DESCRIPTOR_D(line_dsc);  	unsigned long ccode, flags;  H 	flags = HLP$M_PROMPT|HLP$M_PROCESS|HLP$M_GROUP|HLP$M_SYSTEM|HLP$M_HELP;. 	ccode = CLI$GET_VALUE(&topic_dsc,&param_dsc);5 	ccode= STR$CONCAT(&line_dsc,&prefix_dsc,&param_dsc); A 	ccode = LBR$OUTPUT_HELP(LIB$PUT_OUTPUT,0,&line_dsc,&helplib_dsc,  		&flags,LIB$GET_INPUT); 	LIB$SFREE1_DD(&line_dsc); 	LIB$SFREE1_DD(&param_dsc);  	ccode = MBMON__NORMAL;    	return(ccode);  }    /* 	exit_cmd - exit this program  */
 unsigned long 
 exit_cmd() { 	 	exit(1);    	return MBMON__BUG;  }    /*9 	version_cmd	- version command - display software version  */
 unsigned long  version_cmd(void)  { ) 	static $DESCRIPTOR(version_dsc,VERSION); ( 	static $DESCRIPTOR(bdate_dsc,__DATE__);. 	static $DESCRIPTOR(vmsver_dsc,__VMS_VERSION); #if __ALPHA & 	static $DESCRIPTOR(arch_dsc,"Alpha"); #else $ 	static $DESCRIPTOR(arch_dsc,"VAX"); #endif  F 	putmsg(MBMON__VERSION,&version_dsc,&bdate_dsc,&arch_dsc,&vmsver_dsc);   	return (MBMON__NORMAL); }    /* 	get_input	- read a line   */
 unsigned long  get_input(result,prompt,length)   struct dsc$descriptor_s *result;  struct dsc$descriptor_s *prompt; unsigned short *length;  {  	unsigned long ccode; / 	extern unsigned long SMG$READ_COMPOSED_LINE();   E 	ccode = SMG$READ_COMPOSED_LINE(&keyboard_id,0,result,prompt,length);    	return(ccode);  }    /* 	initialise	- initialise data  */ static void  initialise(void) {  	int i;     	unsigned long ccode;4 	extern unsigned long smg$create_virtual_keyboard();  !    	/* create virtual keyboard	*/ G 	ccode = smg$create_virtual_keyboard(&keyboard_id,0,0,0,&RECALL_COUNT);  	if (!(ccode & 1)) 		exit(ccode); }    /** 	put_output	- write message to output file */ static unsigned longD put_output(struct dsc$descriptor_s *msg_dsc, unsigned long severity) {  	unsigned long result;   	if (redir)  	{
 		if (output)  		{ ' 			/* output message to output file		*/ 7 			fwrite(msg_dsc->dsc$a_pointer,msg_dsc->dsc$w_length,  				1,stdout); 		} 3 		/* if not error then don't output to SYS$ERROR	*/ : 		if (severity == STS$K_SUCCESS || severity == STS$K_INFO). 			result = 0;	/* don't output to SYS$ERROR	*/ 		else+ 			result = 1;	/* do output to SYS$ERROR	*/  	} 	else * 		result = 1;	/* do output to SYS$ERROR	*/   	return(result); }    /* 	putmsg		- output message  */ static void  putmsg(ccode,va_alist) unsigned long ccode; va_dcl {  	unsigned long args[20], *argp;  	va_list ap; 	int nargs;  	unsigned short fac;  ! 	fac = $VMS_STATUS_FAC_NO(ccode);  	va_start(ap); 	va_count(nargs);  	args[0] = nargs--;  	args[1] = ccode;   5 	if (fac == SYSTEM$_FACILITY || fac == RMS$_FACILITY)  		argp = &args[2]; 	else  	{ 		args[2] = nargs; 		argp = &args[3]; 	}   	while (nargs-- > 0)% 		*argp++ = va_arg(ap,unsigned long);    	va_end(ap);  ; 	SYS$PUTMSG(args,put_output,0,$VMS_STATUS_SEVERITY(ccode));  }    /*- 	read_message - read a message from a mailbox    	chan 	- mailbox channel 	maxmsg	- max message size 	msgbuf	- message buffer */ static unsigned longN read_message(unsigned long chan, unsigned short maxmsg, MBMON_MESSAGE *msgbuf) {  	struct  	{ 		unsigned short iostatus; 		unsigned short msglen; 		unsigned long pid;
 	} read_iosb;  	unsigned long ccode;   8 	ccode = SYS$QIOW(18,chan, IO$_READVBLK, &read_iosb,0,0," 		&msgbuf->msg, maxmsg,0,0,0,0);		 	if (ccode & 1)  		ccode = read_iosb.iostatus;  	if (ccode & 1)  	{$ 		msgbuf->length = read_iosb.msglen; 		msgbuf->pid = read_iosb.pid; 	} 	else  	{# 		msgbuf->pid = msgbuf->length = 0;  	} 	return ccode; }    /*$ 	display_message - display a message   	msgbuf	- message buffer */ static unsigned long  & display_message(MBMON_MESSAGE *msgbuf) {  	unsigned char *buf; 	unsigned long ccode=1, value;" 	int outlen, outwidth, inc, dec,i;1 	char *outbuf, outbuf2[50], outbuf3[50], *outptr;   9 	get_process_name(msgbuf->pid,outbuf2,sizeof(outbuf2)-1);   . 	printf("Message from %08x %s, length %u%s\n",% 		msgbuf->pid,outbuf2,msgbuf->length, 4 		(msgbuf->length==0)?" (possible EOF message)":"");  - 	/* allocate a buffer for formatted output */  	outbuf = malloc(width+1);  D 	/* set outlen to be the number of bytes of the message to output */4 	if (max_length != 0 && msgbuf->length > max_length) 		outlen = max_length; 	else  		outlen = msgbuf->length;  5 	outwidth=width;	/* number of characters to output	*/ * 	outptr=outbuf;	/* display buffer ptr			*/ 	buf = &msgbuf->msg;  5 	while (outlen > 0)	/* while bytes left to display	*/  	{ 		if (format == TEXT)  		{ 9 			outptr = outbuf; /* reset to start of display buffer*/ 7 			if (outlen > width) /* if No. bytes left too wide */ 8                         	inc = width;	/* do this many */ 			else  				inc = outlen; 2 			/* copy bytes from message to output buffer 	*/0 			/* replacing non-printable characters by .	*/ 			for (i=0; i < inc; i++) 			{ 				if (isprint(*buf)) 					*outptr++ = *buf; 				else 					*outptr++ = '.'; 
 				buf++;
 				outlen--;  			}1 			*outptr = '\0'; /* terminate display string */ / 			puts(outbuf);	/* output display string    */  			outwidth = width; 		}  		else 		{     			value = 0; 			switch(data_size) 			{
 			case BYTE: " 				value = *(unsigned char *)buf; 				dec = sizeof(char); 
 				break;
 			case WORD:  				value = *(short *)buf; 				dec = sizeof(short);
 				break;
 			case LONG:  				value = *(long *)buf;  				dec = sizeof(long); 
 				break; 			}    			if (format == HEX).    				sprintf(outbuf2,"%x ",(unsigned)value);
    			else! 				sprintf(outbuf2,"%d ",value);  			inc = strlen(outbuf2);  			if ((outwidth - inc) <= 0)  			{ 				puts(outbuf);  				outptr = outbuf; 				outwidth = width;  			} 			strcpy(outptr,outbuf2);/ 			outwidth -= inc; /* output inc characters	*/  			outptr += inc;  			*outptr = '\0';. 			outlen -= dec;   /* processed dec bytes		*/ 			buf += dec; 		}  	} 	if (outwidth != width) 6 		puts(outbuf);	/* display remaining part of buffer */ 			  	  	free(outbuf); 	return(ccode);  }    /*" 	record_message - record a message   	fp	- file pointer 	msgbuf	- message buffer */ static unsigned long  / record_message(FILE *fp, MBMON_MESSAGE *msgbuf)  { 	 	int len;  	unsigned long ccode;    	SYS$GETTIM(&msgbuf->time);   	msgbuf->type = MBMON_K_MESSAGE;  . 	len = sizeof(MBMON_MESSAGE)+msgbuf->length-1;* 	if (decc$record_write(fp,msgbuf,len) > 0) 		ccode = MBMON__NORMAL; 	else $ 		ccode = (unsigned long)vaxc$errno;   	return ccode;	  }    /* 	get_process_name  */ static void < get_process_name(unsigned long pid, char *name, int namelen) {  	$DESCRIPTOR(name_dsc,name); 	unsigned long ccode;  	unsigned short len;   	if (pid != 0) 	{" 		name_dsc.dsc$w_length = namelen;C 	       	ccode  = LIB$GETJPI(&JPI$_PRCNAM,&pid,0,0,&name_dsc,&len);  		if (ccode & 1) 	        	name[len] = '\0';  		else 			name[0] = '\0'; 	} 	else  	{ 		name[0] = '\0';  	} }    /* 	get_format	- get data format  */
 static FORMAT  get_format(void) { ) 	static $DESCRIPTOR(format_dsc,"FORMAT");  	$DESCRIPTOR_D(value_dsc); 	unsigned short len; 	unsigned long ccode;  	FORMAT format;   4 	ccode = CLI$GET_VALUE(&format_dsc,&value_dsc,&len); 	if ((ccode & 1) != 0) 	{& 		if (*value_dsc.dsc$a_pointer == 'H') 			format = HEX;+ 		else if (*value_dsc.dsc$a_pointer == 'D')  			format = DECIMAL;+ 		else if (*value_dsc.dsc$a_pointer == 'T')  			format = TEXT;  		else 		{  			putmsg(MBMON__BADFORMAT); 			format = HEX; 		}  	} 	else  		format = HEX;    	LIB$SFREE1_DD(&value_dsc);  	return(format); }    /* 	get_data_size	- get data size */ static DATA_SIZE   get_data_size(void)  { / 	static $DESCRIPTOR(data_size_dsc,"DATA_SIZE");  	$DESCRIPTOR_D(value_dsc); 	unsigned short len; 	unsigned long ccode;  	DATA_SIZE data_size;   7 	ccode = CLI$GET_VALUE(&data_size_dsc,&value_dsc,&len);  	if ((ccode & 1) != 0) 	{& 		if (*value_dsc.dsc$a_pointer == 'B') 			data_size = BYTE;+ 		else if (*value_dsc.dsc$a_pointer == 'W')  			data_size = WORD;+ 		else if (*value_dsc.dsc$a_pointer == 'L')  			data_size = LONG; 		else 		{  			putmsg(MBMON__BADSIZE); 			data_size = BYTE; 		}  	} 	else  		data_size = BYTE;    	LIB$SFREE1_DD(&value_dsc);  	return(data_size);  }    /*
 	get_width */ static unsigned long   get_width(void)  { ' 	static $DESCRIPTOR(width_dsc,"WIDTH");  	$DESCRIPTOR_D(value_dsc); 	unsigned short len; 	unsigned long ccode, width;  3 	ccode = CLI$GET_VALUE(&width_dsc,&value_dsc,&len);  	if ((ccode & 1) != 0) 	{( 		width = atoi(value_dsc.dsc$a_pointer); 	} 	else 
 		width = 80;    	if (width < MIN_WIDTH)  	{ 		putmsg(MBMON__INVVAL); 		width = MIN_WIDTH; 	}   	if (width > MAX_WIDTH)  	{ 		putmsg(MBMON__INVVAL); 		width = MAX_WIDTH; 	}   	LIB$SFREE1_DD(&value_dsc);  	return(width);  }    /* 	get_length  */ static unsigned long   get_length(void) { ) 	static $DESCRIPTOR(length_dsc,"LENGTH");  	$DESCRIPTOR_D(value_dsc); 	unsigned short len; 	unsigned long ccode, length;   4 	ccode = CLI$GET_VALUE(&length_dsc,&value_dsc,&len); 	if ((ccode & 1) != 0) 	{) 		length = atoi(value_dsc.dsc$a_pointer);  	} 	else 
 		length = 0;    	LIB$SFREE1_DD(&value_dsc);  	return(length); }    /** 	get_output	- get output filename (if any) */ static unsigned long get_output(void) { ) 	static $DESCRIPTOR(output_dsc,"OUTPUT");  	$DESCRIPTOR_D(value_dsc); 	unsigned short len; 	unsigned long ccode;  	char outname[256];  	int new_redir;   " 	ccode = CLI$PRESENT(&output_dsc);7 	if ((ccode == CLI$_NEGATED) || (ccode == CLI$_LOCNEG))  	{( 		output = FALSE;	/* no output wanted	*/ 		redir = TRUE;  		ccode = MBMON__NORMAL; 	} 	else  	{' 		output = TRUE;	/* output is wanted	*/ 5 		ccode = CLI$GET_VALUE(&output_dsc,&value_dsc,&len);  		if ((ccode & 1) && (len > 0))  		{ * 			memcpy(outname,value_dsc.dsc$a_pointer, 				value_dsc.dsc$w_length);* 			outname[value_dsc.dsc$w_length] = '\0'; 			LIB$SFREE1_DD(&value_dsc);   5 			/* default extention is .LOG                    */ 1                 	if (strchr(outname,'.') == NULL) 0 	                        strcat(outname,".LOG");" 	                new_redir = TRUE;    		} 		else 		{  			/* output to terminal	*/  			new_redir = FALSE; ! 			strcpy(outname,"SYS$OUTPUT:");  			ccode = MBMON__NORMAL;  		} ?  		if (freopen(outname,"w",stdout,"ctx=rec","rfm=var") != NULL)  		{  			redir = new_redir;  		}  		else 		{  			ccode = vaxc$errno; 		}   	}  	return ccode;	  }    /*? 	ctrl_c_ast - routine called by AST when user presses control C  */ static void  ctrl_c_ast(CCAP *p)  {  	if (p != NULL)  	{ 		p->ctrlc = TRUE; 		if (p->flag != NULL) 			*(p->flag) = TRUE;  		if (p->chan != 0)  			SYS$CANCEL(p->chan);  	} }    /*9 	catch_ctrl_c	- establish a control C AST which will set  2 		the specified flag if the user presses control C */ static unsigned long  * catch_ctrl_c(unsigned short *chan,CCAP *p) { " 	static $DESCRIPTOR(tt_dsc,"TT:");         unsigned long ccode; 	unsigned short iosb[4];  ( 	ccode = SYS$ASSIGN(&tt_dsc,chan,0,0,0); 	if (ccode & 1)  	{: 		ccode = SYS$QIOW(EFN, *chan, IO$_SETMODE|IO$M_CTRLCAST, " 			iosb,0,0,ctrl_c_ast,p,0,0,0,0); 		if (ccode & 1) 			ccode = iosb[0];  	} 	return ccode; }    /* 	create record file  */ static unsigned long  * create_record_file(char *name, FILE **fpp) {  	MBMON_FHEADER fhdr; 	unsigned long ccode;  	int i;   - 	*fpp = fopen(name,"wb","ctx=rec","rfm=var");  	if (*fpp != NULL) 	{ 		/* write header record	*/  		fhdr.type = MBMON_K_HEADER; & 		fhdr.version = MBMON_K_FILE_VERSION; 		SYS$GETTIM(&fhdr.time); 5 		if (decc$record_write(*fpp,&fhdr,sizeof(fhdr)) > 0)  			ccode = MBMON__NORMAL;  		else 			ccode = vaxc$errno; 	} 	else  	{ 		ccode = vaxc$errno;  	} 	return ccode; }    /* 	open existing record file */ static unsigned long( open_record_file(char *name, FILE **fpp) {  	unsigned long ccode;   # 	*fpp = fopen(name,"rb","ctx=rec");  	if (*fpp != NULL) 		ccode = MBMON__NORMAL; 	else  		ccode = vaxc$errno;  	return ccode; } 