 /* MAKE version 1.1, April 1987" Copyright (C) 1987 by Jesse Perry.; MAKE is in the public domain and may be freely distributed, 8 used, and modified, provided this notice is not removed.   mkmain.cD This file contains the main program, and the code which decides what@ targets to update and sends commands to the subprocess to do the updates. */   #include "make.h"   ; /* Argument variables are not declared because this program < uses the CLI routines to get its command line parameters. */   main() {  	int targlen, fdret;$ 	MAKE_TARGET *mlist, *rlist, *tlist; 	DATE datebuf; 	char datestr[ASCII_DATE_LEN];: 	char drname[FILE_NAME_LEN + 1], fname[FILE_NAME_LEN + 1];  > 	/* First thing to do is establish exit handler, so that if an> 	unexpected exit occurs, the sub-process is not left alive. */  
 	estexhand();   / 	/* Get simple qualifiers from command line. */   % 	Active = cli_present("ACTIVE") >= 0; ' 	Created = cli_present("REVISED") <= 0; $ 	Ignore = cli_present("IGNORE") > 0;$ 	Silent = cli_present("SILENT") > 0;" 	Touch = cli_present("TOUCH") > 0;& 	Verbose = cli_present("VERBOSE") > 0;  - 	/* See if a command file must be created. */    	fname[0] = '\0';  	Bldfile = NULL;  	if (cli_present("BUILD") > 0) {: 		if (cli_get_value("BUILD", fname, sizeof(fname)) <= 0) {" 			strecpy(Def_build_name, fname); 		} & 		if (find_file_type(fname) == NULL) {/ 			set_file_type(fname, Def_build_type, fname);  		} > 		Bldfile = fopen(fname, "w", "MRS=255", "RFM=VAR", "RAT=CR"); 		if (Bldfile == NULL) { #ifdef VMS_ERROR. 			lib$stop(&Mak_errcrebld, 2, FAO_AD(fname)); #else 8 			printf("  ** Can't create command file %s\n", fname); 			make_exit(NORMAL_EXIT); #endif 		}  	}    	/* Set up to read makefiles. */   	init_ctype(); 	mlist = rlist = tlist = NULL;  3 	/* Get possible command line macro definitions. */   7 	if (get_make_file(NULL, &mlist, &rlist, &tlist) < 0) {  #ifdef VMS_ERROR 		lib$stop(&Mak_cmdlnerr); #else 7 		printf("  ** Errors in command line definitions.\n");  #endif 	}  > 	/* See if special makefile name was given on command line. */   	fname[0] = '\0'; $ 	if (cli_present("MAKEFILE") >= 0 &&< 	    cli_get_value("MAKEFILE", fname, sizeof(fname)) <= 0) {$ 		strecpy(Def_makefile_name, fname); 	}, 	translate(fname, fname, sizeof(fname) - 1);4 	if (fname[0] && (*find_file_type(fname) == '\0')) {- 		set_file_type(fname, Def_file_type, fname);  	}   	/* Read user makefile. */   	if (fname[0] != '\0' &&8 	    get_make_file(fname, &mlist, &rlist, &tlist) < 0) { #ifdef VMS_ERROR, 		lib$stop(&Mak_errinmak, 2, FAO_AD(fname)); #else ; 		printf("  ** Errors in makefile %s, aborting.\n", fname);  		make_exit(NORMAL_EXIT);  #endif 	}  @ 	/* Check for special default rules definition file.  (This fileA 	defines the rules MAKE uses when the user makefile does not have 9 	specific instructions on how to make a given target.) */    	drname[0] = '\0';  	if (cli_present("RULE") >= 0 &&: 	    cli_get_value("RULE", drname, sizeof(drname)) <= 0) {! 		strecpy(Def_rule_name, drname);  	}/ 	translate(drname, drname, sizeof(drname) - 1); 6 	if (drname[0] && (*find_file_type(drname) == '\0')) {/ 		set_file_type(drname, Def_file_type, drname);  	}  * 	/* Read default rules definition file. */   	if (drname[0] != '\0' && 9 	    get_make_file(drname, &mlist, &rlist, &tlist) < 0) {  #ifdef VMS_ERROR- 		lib$stop(&Mak_errindef, 2, FAO_AD(drname));  #else < 		printf("  ** Errors in default rule file %s, aborting.\n", 		    drname); 		make_exit(NORMAL_EXIT);  #endif 	}  H 	/* If /PRINT option given, show all macros, rules, and dependencies. */    	if (cli_present("PRINT") > 0) {& 		printf("#----------------------\n");! 		show_target(mlist, STMT_MACRO);   		show_target(rlist, STMT_RULE);" 		show_target(tlist, STMT_TARGET);& 		printf("#----------------------\n"); 	}  ( 	/* Get name of first target to make. */  > 	if (cli_get_value("TARGET", fname, sizeof(fname) - 1) <= 0) { 		if (tlist == NULL) { #ifdef VMS_ERROR 			lib$stop(&Mak_nothing); #else % 			printf("  ** Nothing to make.\n");  			make_exit(NORMAL_EXIT); #endif 		} * 		strecpy(tlist->tg_name->mt_text, fname); 	}  A 	/* Update the first target, and any others from command line. */    	do {  		Update_level = 0;  		if (Bldfile != NULL) {5 			fprintf(Bldfile, "$\n$! Creating %s\n$\n", fname);  		}  		update(fname, rlist, tlist);A 	} while (cli_get_value("TARGET", fname, sizeof(fname) - 1) > 0);    	/* Clean-up and exit. */    	make_exit(NORMAL_EXIT); }   I /* Make sure named target is up to date with respect to its dependencies. H Return UPDT_OKAY for success, UPDT_ERROR for error, or UPDT_HOW if don't know how to update. */   static  update(targetname, rlist, tlist) char *targetname;  MAKE_TARGET *rlist, *tlist;  { , 	MAKE_TARGET *find_target(), *usable_rule(); 	int dep_exists, remake_target;  	char *deptype, *targtype; 	MAKE_TOKEN *dptr, *ruledep;. 	MAKE_TARGET *rlptr, *tptr, *saveptr, *newptr; 	DATE depdate, targdate;@ 	char rlsrcname[FILE_NAME_LEN + 1], updtname[FILE_NAME_LEN + 1];" 	char ruletarg[FILE_NAME_LEN + 1];  ? 	/* Kludge to ignore use of empty macros.  This should properly : 	be taken care of by the code which expands the macros. */  1 	if (targetname == NULL || *targetname == '\0') {  		return (UPDT_OKAY);  	}  6 	/* See if any way of updating the target is known. */  ' 	tptr = find_target(targetname, tlist); H 	if (tptr == NULL && ((targtype = find_file_type(targetname)) == NULL || 	    *targtype == '\0')) {> 		targetname = set_file_type(targetname, Def_targ_type, NULL);( 		tptr = find_target(targetname, tlist); 	}  A 	/* Get the date of the target file.  If an error occurs, this is A 	assumed to mean the target does not exist (and therefore is "out , 	of date", since it needs to be created). */  < 	remake_target = (get_file_date(targetname, &targdate) < 0);5 	verbose_show(targetname, !remake_target, &targdate);   < 	/* If no way of making the target is given in the makefile,- 	try to find a default rule which applies. */    	rlptr = NULL; 	if (tptr == NULL) {  * 		/* See if a default rule can be used. */  > 		rlptr = usable_rule(rlist, targetname, rlsrcname, &depdate);& 		if (tptr == NULL && rlptr == NULL) { 			if (remake_target) {  #ifdef VMS_ERROR0 				lib$signal(&Mak_how, 2, FAO_AD(targetname)); #else . 				printf("  ** Don't know how to make %s\n", 				    targetname); #endif 				return (UPDT_HOW); 			} 			return (UPDT_OKAY); 		} # 	} else if (tptr->tg_cmd == NULL) {   : 		/* The current target file is described in the makefile,7 		but the dependency statement describing it has no DCL 8 		command lines.  Therefore a default rule must be found/ 		which tells how to update the target file. */   4 		targtype = find_file_type(tptr->tg_name->mt_text); 		if (targtype != NULL) {  			dptr = tptr->tg_dep;  			while (dptr != NULL) { , 				deptype = find_file_type(dptr->mt_text); 				if (deptype != NULL) {' 					strecpy(targtype, strecpy(deptype,  					    ruletarg));* 					rlptr = find_target(ruletarg, rlist); 					if (rlptr != NULL) { ( 						strecpy(dptr->mt_text, rlsrcname); 						break; 					} 				}  				dptr = dptr->mt_next;  			} 		}  		if (rlptr == NULL) {) 			rlptr = usable_rule(rlist, targetname,  			    rlsrcname, &depdate); 		}  	}  F 	/* If a default rule is being used, generate a dependency from it. */   	if (rlptr != NULL) {   ; 		/* At this point, rlptr points to the default rule to use > 		to create the current target.  The modification date (either= 		creation or revision) of the source file for the rule is in < 		depdate.  Create a MAKE_TARGET which shows how the rule is" 		used in this particular case. */   		if (Verbose) { 			print_prefix();2 			printf("Using default rule %s for target %s\n",, 			    rlptr->tg_name->mt_text, targetname); 		}     		ruledep = E_ALLOC(MAKE_TOKEN);+ 		ruledep->mt_text = newstr(rlsrcname, -1);  		ruledep->mt_simple = TRUE;9 		new_copy_token(rlptr->tg_dep, &ruledep->mt_next, NULL);  		if (tptr == NULL) {  			tptr = E_ALLOC(MAKE_TARGET); ' 			tptr->tg_name = E_ALLOC(MAKE_TOKEN); 3 			tptr->tg_name->mt_text = newstr(targetname, -1); ! 			tptr->tg_name->mt_next = NULL;  			tptr->tg_dep = NULL;  			tptr->tg_next = NULL;
 		} else { 			saveptr = tptr->tg_next;  			tptr->tg_next = NULL;" 			new_copy_target(tptr, &newptr); 			tptr->tg_next = saveptr;  			tptr = newptr;  		} * 		merge_dep(ruledep, &tptr->tg_dep, NULL);- 		new_copy_cmd(rlptr->tg_cmd, &tptr->tg_cmd);   1 		/* Expand any macros in the dependency list. */   : 		if (expand_special(tptr->tg_dep, tptr->tg_name, NULL) == 		    EXP_ERROR) { #ifdef VMS_ERROR! 			lib$signal(&Mak_expandrule, 6,  			    FAO_AD("dependencies"),' 			    FAO_AD(rlptr->tg_name->mt_text),  			    FAO_AD(targetname));  #else I 			printf("  ** Error expanding dependencies of rule %s for target %s\n", , 			    rlptr->tg_name->mt_text, targetname); #endif 			return (UPDT_ERROR);  		} $ 		char_process(tptr->tg_dep, FALSE);  3 		/* Expand special macros in update commands using 1 		the current target name and dependency list. */   # 		if (cmd_exp_special(tptr->tg_cmd, 2 		    tptr->tg_name, tptr->tg_dep) == EXP_ERROR) { #ifdef VMS_ERROR! 			lib$signal(&Mak_expandrule, 6,  			    FAO_AD("commands"),' 			    FAO_AD(rlptr->tg_name->mt_text),  			    FAO_AD(targetname));  #else E 			printf("  ** Error expanding commands of rule %s for target %s\n", , 			    rlptr->tg_name->mt_text, targetname); #endif 			return (UPDT_ERROR);  		}  	}  L 	/* If a command file is being created, assume the target is out of date. */   	if (Bldfile != NULL) {  		remake_target = TRUE;  	}  ; 	/* Update the dependencies, if any, and see if the current 6 	target is out of date with respect to any of them. */  @ 	for (dptr = tptr->tg_dep; dptr != NULL; dptr = dptr->mt_next) {  + 		/* Check for blank dependencies caused by ) 		macros which are defined as nothing. */   8 		if (dptr->mt_text == NULL || *dptr->mt_text == '\0') { 			continue; 		}   1 		/* State which dependency is being done now. */    		if (Verbose) { 			print_prefix(); 			printf("%s depends on %s\n", " 			    targetname, dptr->mt_text); 		}    		/* Update the dependency. */    		Update_level += UPDATE_INDENT;# 		strecpy(dptr->mt_text, updtname); 4 		if (update(updtname, rlist, tlist) != UPDT_OKAY) {! 			Update_level -= UPDATE_INDENT;  			return (UPDT_ERROR);  		}   8 		/* If the current target is up to date with respect to7 		all dependencies checked so far, see if it is also up ) 		to date with the current dependency. */    		if (!remake_target) { - 			dep_exists = (get_file_date(dptr->mt_text,  			    &depdate) >= 0); 5 			verbose_show(dptr->mt_text, dep_exists, &depdate); * 			if (out_of_date(&depdate, &targdate)) { 				if (Verbose) { 					print_prefix();5 					printf("%s is out of date with respect to %s\n", $ 					    targetname, dptr->mt_text); 				}  				remake_target = TRUE;  			} else if (Verbose) { 				print_prefix(); 3 				printf("%s is up to date with respect to %s\n", # 				    targetname, dptr->mt_text);  			} 		}   		Update_level -= UPDATE_INDENT; 	}  : 	/* If target does not exist, or if it is out of date with= 	respect to one or more of its dependencies, execute commands  	to re-create it. */   	if (remake_target) {  		if (Verbose) { 			print_prefix();- 			printf("Recreating %s ...\n", targetname);  		}  		Curr_targ = targetname;  		if (Touch) { 			touch_file(targetname);3 		} else if (do_cmd(tptr->tg_cmd) != NORMAL_EXIT) {  			if (!precious(targetname)) {  				if (Verbose) { 					print_prefix();: 					printf("Error during creation of %s; deleting it.\n", 					    targetname);  				}  				delete_file(targetname); 			} 			return (UPDT_ERROR);  		}  		Curr_targ = NULL;  		if (Verbose) { 			print_prefix();' 			printf("%s updated.\n", targetname);  		} + 	} else if (Verbose || Update_level == 0) {  		if (Update_level != 0) { 			print_prefix(); 		} , 		printf("%s is up to date.\n", targetname); 	} 	return (UPDT_OKAY); }   < /* Search for the named target in a list of MAKE_TARGETs. */   static
 MAKE_TARGET *  find_target(tname, tlist)  char *tname; register MAKE_TARGET *tlist; { C 	while (tlist != NULL && COMPARE(tname, tlist->tg_name->mt_text)) {  		tlist = tlist->tg_next;  	} 	return (tlist); }   J /* Execute a list of commands to update a target.  If a command exits withI an error status, and the command flags do not include CMD_IGN_ERROR, stop I executing commands and return the error status.  If all commands complete 1 successfully, return the standard exit status. */    static do_cmd(cmdptr) register MAKE_COMMAND *cmdptr; {  	int status;  	char cmd_text[MAX_CMD_LEN + 1];   	while (cmdptr != NULL) { $ 		status = tok2str(cmdptr->cmd_word,& 		    cmd_text, sizeof(cmd_text) - 1);   		if (Bldfile != NULL) {( 			fprintf(Bldfile, "$ %s\n", cmd_text); 			cmdptr = cmdptr->cmd_next;  			continue; 		}   5 		if (!Silent && !(cmdptr->cmd_flag & CMD_NO_ECHO)) { 3 			printf("%c\t%s\n", (Active ? ' ' : CLI_COMMENT),  			    cmd_text);  		}    		if (Active) { 6 			if (Ignore || (cmdptr->cmd_flag & CMD_IGN_ERROR)) { 				if (!Sub_ign_err) { * 					sub_write("on severe then continue"); 					Sub_ign_err = TRUE; 				}  			} else {  				if (Sub_ign_err) {, 					sub_write("on warning then stop/id=0"); 					Sub_ign_err = FALSE;  				}  			} 			sub_write(cmd_text); * 			if (~cmdptr->cmd_flag & CMD_CONTINUE) { 				sub_write(""); 			} 		}    		cmdptr = cmdptr->cmd_next; 	} 	return (NORMAL_EXIT); }   K /* This routine returns TRUE if the named target is "precious".  A precious G target is a target which is named as a dependency of the special target H .PRECIOUS in the makefile.  This feature is not yet implemented, so this  routine always returns FALSE. */   precious(tname)  char *tname; {  	return (FALSE); }   H /* Concatenate the text of each token in a list to form a single string.# Return the length of the string. */    static tok2str(tokptr, str, maxlen) register MAKE_TOKEN *tokptr; register char *str;  int maxlen;  {  	char *str0;   	str0 = str; 	while (tokptr != NULL && 5 	    str - str0 + strlen(tokptr->mt_text) < maxlen) { & 		str = strecpy(tokptr->mt_text, str); 		tokptr = tokptr->mt_next;  		if (tokptr != NULL) {  			*str++ = ' '; 		}  	}
 	*str = '\0';  	return (str - str0);  }   A /* If verbose mode is on, describe a file and its modify time. */    static* verbose_show(fname, file_exists, fdateptr) char *fname; int file_exists; DATE *fdateptr;  {  	if (Verbose) {  		print_prefix();  		printf("%s ", fname);  		if (file_exists) {2 			printf("%sed ", (Created ? "creat" : "revis")); 			printdate(fdateptr);  			putchar('\n'); 
 		} else { 			printf("does not exist.\n");  		}  	} }   N /* This routine searches the default rules list for rules which can be used toL create the current target file.  If such a rule is found, and the dependencyK file (the file from which the target is created) exists, it puts the modify I date of the dependency file in the date buffer pointed to by dateptr, and I returns a pointer to the default rule being used.  If no default rule can  be used, it returns NULL. */   static
 MAKE_TARGET * ) usable_rule(rlist, tname, sname, dateptr)  register MAKE_TARGET *rlist; char *tname, *sname; DATE *dateptr; { - 	register char *rule_to, *src_end, *targtype;    	/* Set up empty name. */    	if (sname != NULL) {  		*sname = '\0'; 	}  1 	/* Determine what kind of file the target is. */   2 	if ((targtype = find_file_type(tname)) == NULL) { 		return (NULL); 	}  1 	/* Check each rule for one which might apply. */   0 	for (; rlist != NULL; rlist = rlist->tg_next) {8 		rule_to = find_file_type(&rlist->tg_name->mt_text[1]);; 		if (rule_to != NULL && COMPARE(rule_to, targtype) == 0) {  			strecpy(tname, sname); * 			src_end = &sname[targtype - tname + 1];) 			rule_to = &rlist->tg_name->mt_text[1];  			do {  				*src_end++ = *rule_to++;) 			} while (*rule_to && *rule_to != '.');  			*src_end = '\0'; , 			if (get_file_date(sname, dateptr) >= 0) { 				return (rlist);  			} 		}  	} 	return (NULL);  } 