  L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |              ViewXbm              %%   \ @  *                %% |         XwinCode.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h" #pragma module XWINCODE VERSION    #include <stdio.h> #include <descrip.h> #include <stdlib.h>  #include <X11/Xos.h> #include <X11/dxmhelpb.h>  #include <Xm/BulletinB.h>  #include <Xm/DrawingA.h> #include <Xm/Form.h> #include <Xm/Frame.h>  #include <Xm/PushB.h>  #include <Xm/ScrollBar.h>  #include <Xm/ScrolledW.h>  #include <Xm/Text.h> #include <Xm/TextF.h>  #include "defs.h"  #include "externs.h"  
 FILE *PathFp;    extern void ArrowCB(); extern void DialogCB();  extern void ErrorPopup();  extern void MenubarCB(); extern void ReDisplayCB(); extern void ResizeCB();   N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *   *    Function: CreateMainWindowD  * Description: initialize application widgets used in main display   *              window.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void CreateMainWindow()  {      char labelstr[80];L     Widget cascade, options_pane, menubar, Sep1, scrollwin, workarea, frame;  9         /* define foreground and background for arrows */   &     appforeground = GetPixel("black");2     appbackground = GetPixel("Window Background");  6         /*  Create a form widget as the main window */  
     n = 0;.     XtSetArg(args[n], XmNnoResize, True); n++;+     XtSetArg(args[n], XmNheight, 130); n++; *     XtSetArg(args[n], XmNwidth, 330); n++;;     XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE); n++; =     MainForm = XmCreateForm(MainWindow, "MainForm", args, n);      XtManageChild(MainForm);!     window = XtDisplay(MainForm);   A         /* Create a text gadget label for file counts. At startup 7            we use label to tell user how to begin... */   5     sprintf(labelstr, "Select Actions to begin...");    
     n = 0;<     XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;-     XtSetArg(args[n], XmNtopOffset, 20); n++; =     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++; .     XtSetArg(args[n], XmNleftOffset, 35); n++;+     XtSetArg(args[n], XmNcolumns, 25); n++; /     XtSetArg(args[n], XmNeditable, False); n++; <     XtSetArg(args[n], XmNcursorPositionVisible, False); n++;2     XtSetArg(args[n], XmNshadowThickness, 0); n++;5     XtSetArg(args[n], XmNhighlightThickness, 0); n++; *     XtSetArg(args[n], XmNwidth, 230); n++;/     XtSetArg(args[n], XmNvalue, labelstr); n++; P     CurXbmCountTextw = XmCreateTextField(MainForm, "CurXbmCountTextw", args, n);$     XtManageChild(CurXbmCountTextw);  A         /* Create text widget for bitmap filename (BmFileText) */   0     sprintf(LabelStr, "  ViewXbm %s", VERSION);   
     n = 0;<     XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;-     XtSetArg(args[n], XmNtopOffset, 45); n++; =     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++; .     XtSetArg(args[n], XmNleftOffset, 35); n++;+     XtSetArg(args[n], XmNcolumns, 19); n++; /     XtSetArg(args[n], XmNeditable, False); n++; <     XtSetArg(args[n], XmNcursorPositionVisible, False); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;5     XtSetArg(args[n], XmNhighlightThickness, 3); n++; /     XtSetArg(args[n], XmNvalue, LabelStr); n++; D     BmFileText = XmCreateTextField(MainForm, "BmFileText", args, n);     XtManageChild(BmFileText);    $         /* Create Up arrow button */  
     n = 0;<     XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;.     XtSetArg(args[n], XmNtopOffset, 120); n++;=     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++; .     XtSetArg(args[n], XmNleftOffset, 45); n++;)     XtSetArg(args[n], XmNwidth, 35); n++; *     XtSetArg(args[n], XmNheight, 35); n++;:     XtSetArg(args[n], XmNarrowDirection, XmARROW_UP); n++;9     XtSetArg(args[n], XmNforeground, appbackground); n++; ?     UpBtn = XmCreateArrowButton(MainForm, "arrowbtn", args, n);      XtManageChild(UpBtn); @     XtAddCallback (UpBtn, XmNactivateCallback, ArrowCB, UP_BTN);  :         /* Create Scrolled Window, which doesn't scroll */  
     n = 0;<     XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;.     XtSetArg(args[n], XmNtopOffset, 100); n++;=     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++; /     XtSetArg(args[n], XmNleftOffset, 105); n++; )     XtSetArg(args[n], XmNwidth, 80); n++; *     XtSetArg(args[n], XmNheight, 80); n++;=     XtSetArg(args[n], XmNscrolledWindowMarginHeight, 5); n++; <     XtSetArg(args[n], XmNscrolledWindowMarginWidth, 5); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;2     XtSetArg(args[n], XmNworkWindow, Canvas); n++;G     scrollwin = XmCreateScrolledWindow(MainForm, "scrollwin", args, n);      XtManageChild(scrollwin);   D         /* Create a drawing area as a child of the ScrolledWindow */  
     n = 0;)     XtSetArg(args[n], XmNwidth, 64); n++; *     XtSetArg(args[n], XmNheight, 64); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;;     XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE); n++; ?     Canvas = XmCreateDrawingArea(scrollwin, "Canvas", args, n);      XtManageChild(Canvas);G     XtAddCallback(Canvas, XmNexposeCallback, ReDisplayCB, &BitmapData); D     XtAddCallback(Canvas, XmNresizeCallback, ResizeCB, &BitmapData);  &         /* Create Down arrow button */  
     n = 0;<     XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;.     XtSetArg(args[n], XmNtopOffset, 120); n++;>     XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;/     XtSetArg(args[n], XmNrightOffset, 45); n++; )     XtSetArg(args[n], XmNwidth, 35); n++; *     XtSetArg(args[n], XmNheight, 35); n++;<     XtSetArg(args[n], XmNarrowDirection, XmARROW_DOWN); n++;9     XtSetArg(args[n], XmNforeground, appbackground); n++; A     DownBtn = XmCreateArrowButton(MainForm, "arrowbtn", args, n);      XtManageChild(DownBtn); D     XtAddCallback (DownBtn, XmNactivateCallback, ArrowCB, DOWN_BTN);  <         /* Create the Frame widget as a child of MainForm */  
     n = 0;7     XtSetArg(args[n], XmNshadowType, XmSHADOW_IN); n++; 2     XtSetArg(args[n], XmNshadowThickness, 3); n++;-     XtSetArg(args[n], XmNtopOffset, 10); n++; <     XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;0     XtSetArg(args[n], XmNbottomOffset, 10); n++;?     XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++; .     XtSetArg(args[n], XmNleftOffset, 10); n++;=     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++; /     XtSetArg(args[n], XmNrightOffset, 10); n++; >     XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;0     XtSetArg(args[n], XmNmarginHeight, 10); n++;/     XtSetArg(args[n], XmNmarginWidth, 10); n++; 6     frame = XmCreateFrame(MainForm, "frame", args, n);     XtManageChild(frame);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *!  *    Function: DisplayPathsPopup F  * Description: Used to display a list of filepaths which are known toK  *              contain bitmap files. A multiline, non-editable text widget E  *              displays the filepaths which are loaded form filespec G  *              pointed to by the VIEWXBM_PATHFILE process logical. The F  *              buffer used to load these filepaths is large enough toC  *              contain 1023 chars, or 13 lines of 80 chars. If the D  *              length of any unstored filepath line will exceed theI  *              overall length of Buffer, loading of buffer is terminated -  *              and an error popup is posted.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void DisplayPathsPopup() {      int status;      int indx = 0;      int done = 0;      short blen = 0;      short flen = 0;      char filebuf[80];      char *pbuf;      char *ptr;     XmTextPosition StartPos;     Widget CloseBtn, SelectBtn;   G         /* if PathListDlg widget is nonzero, we have already loaded the D            pathlist file. Caller should have already initialised the5            dialog, so we will manage it and return */        if(PathListDlg) { #         XtManageChild(PathListDlg);          return;      }   *         /* Create BulletinBoard Dialog for)            text and pushbutton widgets */   =     CpStr = XmStringCreateLtoR("Bitmap File Paths", charset); 
     n = 0;2     XtSetArg(args[n], XmNdialogTitle, CpStr); n++;*     XtSetArg(args[n], XmNwidth, 535); n++;+     XtSetArg(args[n], XmNheight, 290); n++; L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;5     XtSetArg(args[n], XmNdefaultPosition, True); n++; H     PathListDlg = XmCreateBulletinBoardDialog(MainForm, "DisplayDialog",         args, n);      XmStringFree(CpStr);  9         /* Create a text gadget label current filepath */   ,     sprintf(filebuf, "Current Filepath: ");   
     n = 0;%     XtSetArg(args[n], XmNx, 10); n++; $     XtSetArg(args[n], XmNy, 1); n++;+     XtSetArg(args[n], XmNcolumns, 65); n++; /     XtSetArg(args[n], XmNeditable, False); n++; <     XtSetArg(args[n], XmNcursorPositionVisible, False); n++;2     XtSetArg(args[n], XmNshadowThickness, 0); n++;5     XtSetArg(args[n], XmNhighlightThickness, 0); n++; .     XtSetArg(args[n], XmNvalue, filebuf); n++;K     CurPathTextW = XmCreateTextField(PathListDlg, "CurPathTextW", args, n);       XtManageChild(CurPathTextW);  9         /* Create ScrolledText to display textual info */   
     n = 0;%     XtSetArg(args[n], XmNx, 10); n++; %     XtSetArg(args[n], XmNy, 40); n++; /     XtSetArg(args[n], XmNeditable, False); n++; ;     XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++; <     XtSetArg(args[n], XmNcursorPositionVisible, False); n++;(     XtSetArg(args[n], XmNrows, 12); n++;+     XtSetArg(args[n], XmNcolumns, 60); n++; <     XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;C     XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++; P     PathListTextW = XmCreateScrolledText(PathListDlg, "PathListTextW", args, n);!     XtManageChild(PathListTextW);   /         /* Create PushButton to select popup */   2     CpStr = XmStringCreateLtoR("Select", charset);
     n = 0;)     XtSetArg(args[n], XmNwidth, 80); n++; *     XtSetArg(args[n], XmNheight, 30); n++;&     XtSetArg(args[n], XmNx, 125); n++;&     XtSetArg(args[n], XmNy, 250); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;5     SelectBtn = XmCreatePushButtonGadget(PathListDlg, *                     "SelectBtn", args, n);1     XtAddCallback(SelectBtn, XmNactivateCallback, 0                     DialogCB, PATHLIST_SEL_BTN);     XtManageChild(SelectBtn);      XmStringFree(CpStr);  .         /* Create PushButton to close popup */  1     CpStr = XmStringCreateLtoR("Close", charset); 
     n = 0;)     XtSetArg(args[n], XmNwidth, 80); n++; *     XtSetArg(args[n], XmNheight, 30); n++;&     XtSetArg(args[n], XmNx, 330); n++;&     XtSetArg(args[n], XmNy, 250); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;4     CloseBtn = XmCreatePushButtonGadget(PathListDlg,)                     "CloseBtn", args, n); 0     XtAddCallback(CloseBtn, XmNactivateCallback,2                     DialogCB, PATHLIST_CLOSE_BTN);     XtManageChild(CloseBtn);     XmStringFree(CpStr);  E         /* open the file specified by 'PathListFile', if specified */   %     if(!strlen(PathListFile)) return;   &     PathFp = fopen(PathListFile, "r");     if(!PathFp) { O         sprintf(Buffer, "Unable to open BitmapPath file:\n %s ", PathListFile); /         ErrorPopup(&Buffer, "BitmapPath File");          return;      }   )     memset(&filebuf, 0, sizeof(filebuf)); '     memset(&Buffer, 0, sizeof(Buffer)); C     sprintf(Buffer, "     \n"); /* move first line away from top */        while(!done) {;         status = fgets(filebuf, sizeof(filebuf)-1, PathFp); !         if(isspace(filebuf[0])) { "             blen = strlen(Buffer);#             flen = strlen(filebuf); 0             if((blen + flen) > sizeof(Buffer)) {                 done = TRUE;                  sprintf(filebuf,O                     "DisplayPathsPopup: Overflow: %d of %d bytes (%d lines)\n", 7                     blen + flen, sizeof(Buffer), indx); 8                 ErrorPopup(&filebuf, "BitmapPath File");
             } )             else strcat(Buffer, filebuf);              indx++; 	         } "         else if(indx) done = TRUE;     }      fclose(PathFp);          F         /* display buffer fill status even if verbose mode disabled */  E     printf(" DisplayPathsPopup: Buffer: %d of %d bytes (%d lines)\n", .         strlen(Buffer), sizeof(Buffer), indx);  5         /* move filepath strings info to the popup */   %     pbuf = calloc(strlen(Buffer), 1);      strcpy(pbuf, Buffer); L     XmTextInsert(PathListTextW, XmTextGetLastPosition(PathListTextW), pbuf);     cfree(pbuf);  7         /* move scrollbar to top of display viewport */        StartPos = 0; 3     XmTextSetTopCharacter(PathListTextW, StartPos);   D         /* we wont manage this so the DialogCB callback can init theD            popup when the first path string is entered. It will thenC            become managed, with proper current path info, when user >            selects the 'Pathlist' button in the parent routine            (GetPathPopup) */   }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ErrorPopupH  * Description: A user action has caused an event which prevents desiredE  *              action to occur. Create a popup window which requires B  *              user acknowlegment to continue, This may be called8  *              for non error events, just to save code.  *E  *              Caller provides pointers to message and title strings    *              to be displayed.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ + void ErrorPopup(char *message, char *title)  {      Widget Button;  .         /* format title and message strings */  F     if(strlen(title)) CsTitleStr = XmStringCreateLtoR(title, charset);C     else CsTitleStr = XmStringCreateLtoR("ViewXbm Error", charset); 8     CsMessageStr = XmStringCreateLtoR(message, charset);  >         /* if ErrorDlg already created, just skip init code */  
     n = 0;     if(!ErrorDlg) { 9         XtSetArg(args[n], XmNdefaultPosition, True); n++; ;         XtSetArg(args[n], XmNdialogTitle, CsTitleStr); n++; ?         XtSetArg(args[n], XmNmessageString, CsMessageStr); n++; P         XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;H         ErrorDlg = XmCreateMessageDialog(MainForm, "ErrorDlg", args, n);  D         Button = XmMessageBoxGetChild(ErrorDlg, XmDIALOG_OK_BUTTON);          XtUnmanageChild(Button);F         Button = XmMessageBoxGetChild(ErrorDlg, XmDIALOG_HELP_BUTTON);          XtUnmanageChild(Button);  N         XtAddCallback(ErrorDlg, XmNcancelCallback, DialogCB, RESP_CANCEL_BTN);     } 
     else {;         XtSetArg(args[n], XmNdialogTitle, CsTitleStr); n++; ?         XtSetArg(args[n], XmNmessageString, CsMessageStr); n++; '         XtSetValues(ErrorDlg, args, n);      }        XmStringFree(CsTitleStr);      XmStringFree(CsMessageStr);*     XtManageChild(ErrorDlg); }*        N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetPathPopupG  * Description: Used to get TargetPath location, from which the bitmaps G  *              are to be displayed. A text widget is used to input the E  *              filespec of target directory path, with a pushbutton, B  *              'Pathlist', optionally available to display a list.  *              of preferred bitmap file paths  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */% void GetPathPopup()  {      char labelstr[80];  E     CsTitleStr = XmStringCreateLtoR("Load Target Filepath", charset); >     CsLabelStr = XmStringCreateLtoR("New FilePath:", charset);  
     n = 0;8     XtSetArg(args[n], XmNdialogTitle, CsTitleStr);  n++;@     XtSetArg(args[n], XmNselectionLabelString, CsLabelStr); n++;'     XtSetArg(args[n], XmNokLabelString,e2         XmStringCreateLtoR("Load", charset)); n++;+     XtSetArg(args[n], XmNcancelLabelString, 6         XmStringCreateLtoR("Pathlist", charset)); n++;)     XtSetArg(args[n], XmNhelpLabelString,"3         XmStringCreateLtoR("Close", charset)); n++;,3     XtSetArg(args[n], XmNautoUnmanage, False); n++;*5     XtSetArg(args[n], XmNdefaultPosition, True); n++;*/     XtSetArg(args[n], XmNtextColumns, 35); n++;oL     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;G     GetPathDlg = XmCreatePromptDialog(MainForm, "GetPathDlg", args, n);m  M     PathListBtn = XmSelectionBoxGetChild(GetPathDlg, XmDIALOG_CANCEL_BUTTON);e8     if(!PathListFlg) XtSetSensitive(PathListBtn, False);E     GetPathTextw = XmSelectionBoxGetChild(GetPathDlg, XmDIALOG_TEXT);   E         /* Create a text widget for filespec label (CurPathLabelW) */i  -     sprintf(labelstr, "Current Filepath: "); i  
     n = 0;%     XtSetArg(args[n], XmNx, 10); n++;i%     XtSetArg(args[n], XmNy, 10); n++;)+     XtSetArg(args[n], XmNcolumns, 50); n++;*/     XtSetArg(args[n], XmNeditable, False); n++; <     XtSetArg(args[n], XmNcursorPositionVisible, False); n++;2     XtSetArg(args[n], XmNshadowThickness, 0); n++;5     XtSetArg(args[n], XmNhighlightThickness, 0); n++;*/     XtSetArg(args[n], XmNvalue, labelstr); n++;tL     CurPathLabelW = XmCreateTextField(GetPathDlg, "CurPathLabelW", args, n);!     XtManageChild(CurPathLabelW);   G     XtAddCallback (GetPathDlg, XmNokCallback, DialogCB, PATH_LOAD_BTN); K     XtAddCallback (GetPathDlg, XmNcancelCallback, DialogCB, PATH_LIST_BTN);gJ     XtAddCallback (GetPathDlg, XmNhelpCallback, DialogCB, PATH_CLOSE_BTN);       XmStringFree(CsTitleStr);R     XmStringFree(CsLabelStr);g }g        N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetPixelJ  * Description: Get the color value associated with colorstr. This routine?  *              is public domain and original author is unknownr  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ ! XtArgVal GetPixel(char *colorstr)e {.    XrmValue from, to;a  #    from.size = strlen(colorstr) +1; >    if (from.size < sizeof(String)) from.size = sizeof(String);    from.addr = colorstr;    to.addr = NULL;8    XtConvert(TopLevel, XmRString, &from, XmRPixel, &to);  /    return ((XtArgVal) *((XtArgVal *) to.addr));O }e      N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: InitHelpDlgAF  * Description: Create the help dialog. ViewXbm uses the DxmHelpdialogE  *              widget from the DECwindows Toolkit Extensions group. nF  *              DxmHelp is designed to be called by another Motif app.H  *              This routine define logical pointing to help library and:  *              defines error message for missing library.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */x void InitHelpDlg() {a     char HlpStr[50];     XmString CsOverview;     XmString CsNoHlbMsg;  6         /* create some comp strs regarding help lib */  *     sprintf(HlpStr, "%s", ViewXbmHelpLib);)     CpStr = XmStringCreateSimple(HlpStr); &     sprintf(HlpStr, "%s", "Overview");.     CsOverview = XmStringCreateSimple(HlpStr);3     sprintf(HlpStr, "Cannot open VIEWXBM_HELPLIB");+.     CsNoHlbMsg = XmStringCreateSimple(HlpStr);  6         /* create the Help widget with some options */  
     n = 0;%     XtSetArg(args[n], XmNx, 20); n++;s%     XtSetArg(args[n], XmNy, 20); n++;v*     XtSetArg(args[n], DXmNapplicationName,.         XmStringCreateSimple("ViewXbm")); n++;%     XtSetArg(args[n], DXmNcloseLabel, ,         XmStringCreateSimple("Close")); n++;3     XtSetArg(args[n], DXmNlibrarySpec, CpStr); n++;F:     XtSetArg(args[n], DXmNbadlibMessage, CsNoHlbMsg); n++;7     XtSetArg(args[n], DXmNdefaultPosition, False); n++;n7     XtSetArg(args[n], DXmNfirstTopic, CsOverview); n++; 2     XtSetArg(args[n], XmNshadowThickness, 3); n++;1     XtSetArg(args[n], XmNfontList, charset); n++;]@     HelpDlg = DXmCreateHelpDialog(TopLevel, "DxmHelp", args, n);     XtManageChild(HelpDlg);+  $         /* Add the unmap callback */  H     XtAddCallback(HelpDlg, XmNunmapCallback, MenubarCB, HELP_CLOSE_BTN);     XmStringFree(CpStr);     XmStringFree(CsNoHlbMsg);  }C        N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: UpdateArrowsC  * Description: Set the foreground arrow button color based on the ]C  *              value of ArrowPtr. If ArrowPtr at either limit, setlF  *              the foreground color to the background color, else set*  *              foreground color to normal  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */s void UpdateArrows()d { 8     if(ArrowPtr > BitmapList && ArrowPtr < MaxDownPtr) {         n = 0;=         XtSetArg(args[n], XmNforeground, appforeground); n++;e&         XtSetValues(DownBtn, args, n);         DownBtnActive = TRUE;o         n = 0;=         XtSetArg(args[n], XmNforeground, appforeground); n++;/$         XtSetValues(UpBtn, args, n);         UpBtnActive = TRUE;e         return;h     }6           if(ArrowPtr == BitmapList) {         n = 0;=         XtSetArg(args[n], XmNforeground, appbackground); n++;+$         XtSetValues(UpBtn, args, n);         UpBtnActive = FALSE;0         if(NumBitmaps == 2 || NumBitmaps == 3) {             n = 0;A             XtSetArg(args[n], XmNforeground, appforeground); n++;z*             XtSetValues(DownBtn, args, n);!             DownBtnActive = TRUE; 	         }          else {!             if(NumBitmaps != 1) {R                 n = 0;E                 XtSetArg(args[n], XmNforeground, appforeground); n++;e.                 XtSetValues(DownBtn, args, n);%                 DownBtnActive = TRUE;g
             }d	         }+     }         if(ArrowPtr == MaxDownPtr) {         n = 0;=         XtSetArg(args[n], XmNforeground, appbackground); n++;a&         XtSetValues(DownBtn, args, n);         DownBtnActive = FALSE;0         if(NumBitmaps == 2 || NumBitmaps == 3) {             n = 0;A             XtSetArg(args[n], XmNforeground, appforeground); n++;N(             XtSetValues(UpBtn, args, n);             UpBtnActive = TRUE; 	         }t         else {!             if(NumBitmaps != 1) {                  n = 0;E                 XtSetArg(args[n], XmNforeground, appforeground); n++;+,                 XtSetValues(UpBtn, args, n);#                 UpBtnActive = TRUE;[
             }f	         }+     }  }e    