L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |               CHFOWN              %%   \ @  *                %% |          utility.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *>  *  Copyright (C) 2003,2004 Lyle W. West, All Rights Reserved.J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #define VERSION "V1.2-2" #pragma module UTILITY VERSION    #include <stdio.h> #include <atrdef.h>  #include <clidef.h>  #include <climsgdef.h> #include <ctype.h> #include <descrip.h> #include <jpidef.h>  #include <lnmdef.h>  #include <psldef.h>  #include <ssdef.h> #include <stat.h>  #include <string.h>  #include <stdlib.h> A #include <rms.h>                /* Include the RMS definitions */     globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;     extern int status;   D extern short OldPriv;               /* target file privs at entry */C extern short NewPriv;               /* target file privs at exit */    L extern char CmdVerb[32];            /* foreign symbol invoking this image */A extern char DevName[24];            /* target disk device name */ K extern char InputFile[80];          /* input file to change from cmdline */ F extern char NewAscUic[32];          /* new owner uic (from SYS$FAO) */H extern char NewOwner[32];           /* new owner ident (from cmdline) */F extern char OldAscUic[32];          /* old owner uic (from SYS$FAO) */G extern char OldOwner[32];           /* old owner ident (from XABPRO) */ J extern char TargetFspec[80];        /* target of change owner operation */ extern char *ptr;        extern int lib$get_input();  extern void ShowHelp();     globalvalue CHFOWN_CLD;     char Buffer[80];   : struct {                            /* I/O Status Block */     short cond_value;      short count;
     int info;  } iosb;       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetCliInfo F  * Description: check for parameters and qualifiers which were enteredJ  *              at the command line. If values are required, verify syntax-  *              and set respective variables.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void GetCliInfo()  { ;     char CliStr[80];                /* cli string buffer */ J     char CmdLine[132];              /* buffer reflecting input cmd line */     char LineBuf[132];   F     int CliStat;                    /* return status from cli calls */   J     short CliStrLen;                /* integer depicting cli value size */     short CmdLen;    G     $DESCRIPTOR(DscCli, CliStr);    /* cli param or qualifier string */ J     $DESCRIPTOR(DscBuf, Buffer);    /* string returned by cli$get_value */"     $DESCRIPTOR(DscLbuf, LineBuf);!     $DESCRIPTOR(DscCmd, CmdLine);       G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */   5     status = lib$get_foreign(&DscCmd, 0, &CmdLen, 0); *     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0';      strcpy(LineBuf, "CHFOWN ");      strcat(LineBuf, CmdLine); +     DscLbuf.dsc$w_length = strlen(LineBuf); G     CliStat = cli$dcl_parse(&DscLbuf, CHFOWN_CLD, lib$get_input, 0, 0); ,     if(CliStat != CLI$_NORMAL) exit(status);   C         /* check for presence of qualifiers which are not dependant (            on additional input values */        strcpy(CliStr, "VERSION");)     DscCli.dsc$w_length = strlen(CliStr); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowVers();         strcpy(CliStr,"HELP");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowHelp();    I         /* if we get here (we would not if either of the above qualifiers I            were entered, as they call sys$exit at the conclusion of their K            respective function calls) then check for and process input file 2            parameter if it is present and valid */        strcpy(CliStr,"FILENAME");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; D             strcpy(InputFile, Buffer);    /* input file to change */	         }      } @     else {          /* FILENAME not specified on command line */         exit(0x381F0);H     }    /* %CLI-W-ABSENT, entity or value absent from command string */        strcpy(CliStr,"OWNER"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; E             strcpy(NewOwner, Buffer);    /* resultant outfile name */ 	         }      }      else exit(CliStat);  }          H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ShowHelp H  * Description: Display a brief combination of CHFOWN.README and the cduI  *              CHFOWN.CLD file. It provides a command line glance at the 9  *              optional implementations of CHFOWN usage.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowHelp()  { 0     printf("\n  %s (%s)\n\n", CmdVerb, VERSION);N     printf("\tAllows user to change the owner of a file or group of files\n");L     printf("\tin a specified filepath while retaining creation/revision\n");9     printf("\t(modification) date and time values.\n\n"); #     printf("      Parameter:\n\n"); K     printf("\tFILENAME - the name of filespec where ownership is to be\n"); M     printf("\t\tchanged. Target file(s) can be in the current or another\n"); H     printf("\t\tspecified directory path. This filespec can include\n");!     printf("\t\twildcards.\n\n"); #     printf("      Qualifiers\n\n"); O     printf("\t/OWNER - username which is to become owner of above file(s).\n"); H     printf("\t\tThis username must be entered exactly as it appears\n");>     printf("\t\tin the user authorization file (SYSUAF)\n\n");/     printf("\t/HELP - Displays this text\n\n"); ;     printf("\t/VERSION - Displays version, build date,\n"); D     printf("\t\t  and required privs for VMS Install utility.\n\n");     exit(1); }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckLnm L  * Description: Function to translate a provided logical name to the definedK  *              equivalence string. Only the current JOB logical name table D  *              is searched for a match. If successful, the returnedK  *              equivalence string is copied to the memory location used to L  *              provide the input logical name (*lnmstr) so caller must makeG  *              certain the buffer containing the input logical name is F  *              large enough to contain the full equivalence string orG  *              this routine returns SS$_BUFFEROVF. In all other cases, F  *              the return status of SYS$TRNLNM is returned to caller.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ & int CheckLnm(char *lnmstr, int buflen) { I     int nocase = LNM$M_CASE_BLIND;  /* resolve lnm without case issues */ K     int eqvattrb = 0;               /* returned attributes of eqv string */      int lnmstat = 0;     short eqv_len = 0;     short tbl_len = 0;?     char acmode;                    /* always from user mode */ <     char LnmTable[40];              /* logical name table */=     char LnmDef[40];                /* logical name string */ I     char LnmEqv[80];                /* logical name equivalence string */    >     struct {short len, code; int *bufadr, *retlen;} lnmitm[4];   &     $DESCRIPTOR(dsc_tabnam, LnmTable);$     $DESCRIPTOR(dsc_lognam, LnmDef);$     $DESCRIPTOR(dsc_eqvnam, LnmEqv);   
 #ifdef SECURE <     acmode = PSL$C_EXEC;            /* requires exec mode */ #else :     acmode = PSL$C_USER;            /* simple user mode */ #endif   '     memset(&LnmEqv, 0, sizeof(LnmEqv));      strcpy(LnmDef, lnmstr);       strcpy(LnmTable, "LNM$JOB");   /     dsc_tabnam.dsc$w_length = strlen(LnmTable); -     dsc_lognam.dsc$w_length = strlen(LnmDef); -     dsc_eqvnam.dsc$w_length = sizeof(LnmEqv);    %     lnmitm[0].len = sizeof(eqvattrb); %     lnmitm[0].code = LNM$_ATTRIBUTES; !     lnmitm[0].bufadr = &eqvattrb;      lnmitm[0].retlen = 0; %     lnmitm[1].len = sizeof(LnmTable);       lnmitm[1].code = LNM$_TABLE;!     lnmitm[1].bufadr = &LnmTable;       lnmitm[1].retlen = &tbl_len;#     lnmitm[2].len = sizeof(LnmEqv); !     lnmitm[2].code = LNM$_STRING;      lnmitm[2].bufadr = &LnmEqv;       lnmitm[2].retlen = &eqv_len;     lnmitm[3].len = 0;     lnmitm[3].code = 0;    N     lnmstat = sys$trnlnm(&nocase, &dsc_tabnam, &dsc_lognam, &acmode, &lnmitm);     if(lnmstat == SS$_NORMAL) {          LnmEqv[eqv_len] = '\0'; !         LnmTable[tbl_len] = '\0'; 4         if(eqv_len < buflen) strcpy(lnmstr, LnmEqv);#         else return(SS$_BUFFEROVF);      } 8     if(eqvattrb & LNM$M_CONCEALED) return(SS$_IVLOGNAM);     else return(lnmstat);  }       H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL   *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.   *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)  { <     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */        short   ExpBuf = 0; @     short   *Lptr = 0;      /* pointer to callers length word */        int     BufSize;     int     RecallAddr = 0;      int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */    D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */   =     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */   8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */ A     Iptr = RecallAddr;              /* pseudo pointer register */      RecallAddr = *Iptr; 0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */   A         /* here we use recall allocation to determine the size of B            the recall buffer length field, changed at vms 7.3.2 */   E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */      Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;   B         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */        if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */          else {             *length = -1; "             return(SS$_BUFFEROVF);	         }      } 2     else *length = *Sptr;       /*  8 bit value */   C         /* get buffer length and copy cmd line to callers buffer */         Sptr -= *length;!     strncpy(Dptr, Sptr, *length);      return(SS$_NORMAL);  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            