L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |               CHFNAM              %%   \ @  *                %% |          utility.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *>  *  Copyright (C) 2003,2004 Lyle W. West, All Rights Reserved.J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #define VERSION "V2.0-2" #pragma module UTILITY VERSION    #include <stdio.h> #include <climsgdef.h> #include <ctype.h> #include <descrip.h> #include <jpidef.h>  #include <lnmdef.h>  #include <prvdef.h>  #include <psldef.h>  #include <ssdef.h> #include <string.h>  #include <stdlib.h> A #include <rms.h>                /* Include the RMS definitions */     globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;     extern int status;H extern int RevBin[2];           /* modify/revision date of input file */   I extern short NewEqsOld;         /* use same dir for infile and outfile */ B extern short CopyFlg;           /* copy create date to rev date */F extern short RevdFlg;           /* user specified new revision date */H extern short RevnFlg;           /* user specified new revision number */I extern short RevNum;            /* revision count of input file header */    H extern char CmdVerb[32];        /* foreign symbol invoking this image */F extern char NewFname[80];       /* output filename after SYS$SEARCH */B extern char NewFspec[80];       /* output filespec from cmdline */E extern char OldFname[80];       /* input filename after SYS$SEARCH */ A extern char OldFspec[80];       /* input filespec from cmdline */  extern char *ptr1; extern char *ptr2;    extern int lib$get_foreign();  extern int lib$get_input();  extern void ShowHelp();     globalvalue CHFNAM_CLD;     char Buffer[80];I char DateStr[28];               /* time string for revision time input */     $DESCRIPTOR(DscDate, DateStr);   N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *D  * CheckPrv - Verify user running this image has sufficient privs to=  *            succesfully excute the cmdline input operation. H  *            If priv(s) not available then exit with SS$_NOPRIV status.  *I  *            First get the priv values of the invoking process. Then see I  *            if target is a directory, in which case we will need BYPASS G  *            in addition to the required SYSPRV. We compare the needed F  *            privs (PrivMask) with current privs (ProcPriv[0]) and if7  *            equal we reurn to caller with SS$_NORMAL.   *I  *            We can modify current privs if the SETPRV bit is set in the J  *            authorized priv mask for the user. Set the above needed bitsF  *            in ProcPriv[0] (including SETPRV) and attempt to set theN  *            required privs for this process. If return status is SS$_NORMAL,K  *            return this status to caller. Else exit with the status value    *            from SYS$SETPRV().  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckPrv() {      int enabflg = 1;     int needbypass = FALSE;      int prmflg = 0;      int PrvStat;     int PrivMask = 0;      int ProcPriv[2] = 0;   @     struct  {short len, code; int *bufadr, *retlen;} JpiItem[2];   &     JpiItem[0].len = sizeof(ProcPriv);$     JpiItem[0].code = JPI$_PROCPRIV;%     JpiItem[0].bufadr = &ProcPriv[0];      JpiItem[0].retlen = 0;     JpiItem[1].len = 0;      JpiItem[1].code = 0;   6     PrvStat = sys$getjpiw(0, 0, 0, &JpiItem, 0, 0, 0);,     if(PrvStat != SS$_NORMAL) exit(PrvStat);  =         /* determine priv required and see if they are set */   $     ptr1 = strstr(OldFspec, ".DIR");     if(ptr1) {2         PrivMask |= (PRV$M_SYSPRV + PRV$M_BYPASS);         needbypass = TRUE;     } "     else PrivMask |= PRV$M_SYSPRV;   @     if((ProcPriv[0] & PrivMask) == PrivMask) return(SS$_NORMAL);       PrivMask |= PRV$M_SETPRV;      ProcPriv[0] |= PrivMask;8     PrvStat = sys$setprv(enabflg, &ProcPriv, prmflg, 0);F     if(PrvStat != SS$_NORMAL) exit(1666);   /* not all req privs... */     else return(SS$_NORMAL); }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetCliInfo F  * Description: check for parameters and qualifiers which were enteredJ  *              at the command line. If values are required, verify syntax-  *              and set respective variables.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int GetCliInfo() { 3     char CliStr[80];        /* cli string buffer */ B     char CmdLine[132];      /* buffer reflecting input cmd line */     char LineBuf[132];   >     int CliStat;            /* return status from cli calls */        short CmdLen;      short CliStrLen;   K     $DESCRIPTOR(DscCli, CliStr);        /* cli param or qualifier string */ J     $DESCRIPTOR(DscCmd, CmdLine);       /* user supplied input cmd line */N     $DESCRIPTOR(DscBuf, Buffer);        /* string returned by cli$get_value */"     $DESCRIPTOR(DscLbuf, LineBuf);   G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */   5     status = lib$get_foreign(&DscCmd, 0, &CmdLen, 0); *     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0'; E     strcpy(LineBuf, "CHFNAM ");         /* use imagename here only */      strcat(LineBuf, CmdLine); +     DscLbuf.dsc$w_length = strlen(LineBuf); G     CliStat = cli$dcl_parse(&DscLbuf, CHFNAM_CLD, lib$get_input, 0, 0); ,     if(CliStat != CLI$_NORMAL) exit(status);   @         /* if user typed /VERSION then show versinfo and exit */        strcpy(CliStr, "VERSION");)     DscCli.dsc$w_length = strlen(CliStr); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowVers();         strcpy(CliStr,"HELP");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowHelp();         strcpy(CliStr, "REVDATE");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { ?         CliStat = cli$get_value(&DscCli, &DscDate, &CliStrLen); #         if(CliStat == SS$_NORMAL) { &             DateStr[CliStrLen] = '\0';3             DscDate.dsc$w_length = strlen(DateStr); 3             status = sys$bintim(&DscDate, &RevBin); 2             if(status != SS$_NORMAL) exit(status);             RevdFlg = TRUE; 	         }          else {E             if(CliStat == 0x381f0) { /* CLI-W-ABSENT, value absent */                  CopyFlg = TRUE; 
             }              else exit(CliStat); 	         }      }         strcpy(CliStr,"REVNUM");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; "             RevNum = atoi(Buffer);             RevnFlg = TRUE; 	         }          else {O             if(CliStat == 0x381f0) RevNum = 1; /* CLI-W-ABSENT, value absent */              else exit(CliStat); 	         }      }         strcpy(CliStr,"INFILE");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; I             strcpy(OldFspec, Buffer);    /* input file(spec) to rename */ >             if(strchr(OldFspec, ']') || strchr(OldFspec, ':'))!                 NewEqsOld = TRUE; 	         }      } >     else {          /* INFILE not specified on command line */         exit(0x381F0);H     }    /* %CLI-W-ABSENT, entity or value absent from command string */        strcpy(CliStr,"OUTFILE"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; G             strcpy(NewFspec, Buffer);    /* new outfile spec or name */ 	         }      }      else NewEqsOld = FALSE;        return(SS$_NORMAL);  }       H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *D  *  ShowHelp - Display a brief combination of AAAREADME.TXT and the D  *             CHFNAM.CLD file. It provides a command line glance at/  *             the optional featuress of CHFNAM   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowHelp()  { 2     printf("\n\n  %s (%s)\n\n", CmdVerb, VERSION);G     printf("\tMini replication of the DCL RENAME command. While it\n"); J     printf("\tdoes not utilize all the qualifiers provided by RENAME,\n");K     printf("\tthe primary purpose is to rename a given file, or using \n"); L     printf("\twildcards, a group of files without changing the revision\n");M     printf("\tdate of the target file(s) from the date/time info present\n"); K     printf("\tprior to executing %s. Additionally, revision information\n",          CmdVerb); N     printf("\tvalues can be modified using provided command qualifiers.\n\n");#     printf("     Parameters:\n\n"); H     printf("\t%s requires one parameter, a VMS filename which is the\n",         CmdVerb); M     printf("\tinput file. Optionally, and usually, a second parameter is\n"); M     printf("\tthe output filename (aka Rename) to receive requested file\n");      printf("\tchanges.\n\n"); "     printf("     Qualifiers\n\n");I     printf("\t/REVDATE - if present, %s will change the revision date\n",          CmdVerb); J     printf("\t\t  and time to the specified VMS time value. The input\n");M     printf("\t\t  string must be in standard VMS time format and MUST be\n"); L     printf("\t\t  enclosed in double quotes. If input value is omitted,\n");F     printf("\t\t  the datetime value for Creation will be used.\n\n");J     printf("\t/REVNUM - if present, %s will change the revision number\n",         CmdVerb); P     printf("\t\t  value shown with the revision info to the value specified\n");O     printf("\t\t  If value omitted, the revision number will be set to 1\n\n"); /     printf("\t/HELP - Displays this text\n\n"); G     printf("\t/VERSION - %s displays version, build date,\n", CmdVerb); D     printf("\t\t  and required privs for VMS Install utility.\n\n");     exit(1); }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckLnm L  * Description: Function to translate a provided logical name to the definedK  *              equivalence string. Only the current JOB logical name table D  *              is searched for a match. If successful, the returnedK  *              equivalence string is copied to the memory location used to L  *              provide the input logical name (*lnmstr) so caller must makeG  *              certain the buffer containing the input logical name is F  *              large enough to contain the full equivalence string orG  *              this routine returns SS$_BUFFEROVF. In all other cases, F  *              the return status of SYS$TRNLNM is returned to caller.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ & int CheckLnm(char *lnmstr, int buflen) { I     int nocase = LNM$M_CASE_BLIND;  /* resolve lnm without case issues */ K     int eqvattrb = 0;               /* returned attributes of eqv string */      int lnmstat = 0;     short eqv_len = 0;     short tbl_len = 0;<     char acmode;                    /* requires exec mode */<     char LnmTable[40];              /* logical name table */=     char LnmDef[40];                /* logical name string */ I     char LnmEqv[80];                /* logical name equivalence string */    >     struct {short len, code; int *bufadr, *retlen;} lnmitm[4];   &     $DESCRIPTOR(dsc_tabnam, LnmTable);$     $DESCRIPTOR(dsc_lognam, LnmDef);$     $DESCRIPTOR(dsc_eqvnam, LnmEqv);   
 #ifdef SECURE      acmode = PSL$C_EXEC; #else      acmode = PSL$C_USER; #endif   '     memset(&LnmEqv, 0, sizeof(LnmEqv));      strcpy(LnmDef, lnmstr);       strcpy(LnmTable, "LNM$JOB");   /     dsc_tabnam.dsc$w_length = strlen(LnmTable); -     dsc_lognam.dsc$w_length = strlen(LnmDef); -     dsc_eqvnam.dsc$w_length = sizeof(LnmEqv);    %     lnmitm[0].len = sizeof(eqvattrb); %     lnmitm[0].code = LNM$_ATTRIBUTES; !     lnmitm[0].bufadr = &eqvattrb;      lnmitm[0].retlen = 0; %     lnmitm[1].len = sizeof(LnmTable);       lnmitm[1].code = LNM$_TABLE;!     lnmitm[1].bufadr = &LnmTable;       lnmitm[1].retlen = &tbl_len;#     lnmitm[2].len = sizeof(LnmEqv); !     lnmitm[2].code = LNM$_STRING;      lnmitm[2].bufadr = &LnmEqv;       lnmitm[2].retlen = &eqv_len;     lnmitm[3].len = 0;     lnmitm[3].code = 0;    N     lnmstat = sys$trnlnm(&nocase, &dsc_tabnam, &dsc_lognam, &acmode, &lnmitm);     if(lnmstat == SS$_NORMAL) {          LnmEqv[eqv_len] = '\0'; !         LnmTable[tbl_len] = '\0'; 4         if(eqv_len < buflen) strcpy(lnmstr, LnmEqv);#         else return(SS$_BUFFEROVF);      } 8     if(eqvattrb & LNM$M_CONCEALED) return(SS$_IVLOGNAM);     else return(lnmstat);  }       H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL   *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.   *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)  { <     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */        short   ExpBuf = 0; @     short   *Lptr = 0;      /* pointer to callers length word */        int     BufSize;     int     RecallAddr = 0;      int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */    D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */   =     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */   8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */*A     Iptr = RecallAddr;              /* pseudo pointer register */%     RecallAddr = *Iptr;%0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */   A         /* here we use recall allocation to determine the size of\B            the recall buffer length field, changed at vms 7.3.2 */   E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */      Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;   B         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */        if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */h         else {             *length = -1;c"             return(SS$_BUFFEROVF);	         }*     }i2     else *length = *Sptr;       /*  8 bit value */  nC         /* get buffer length and copy cmd line to callers buffer */"  r     Sptr -= *length;!     strncpy(Dptr, Sptr, *length);s     return(SS$_NORMAL);* }f  e  t  .