  L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *;  *               %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\ <  *               %% \                                   %% \=  *               %%  \__________________________________%%  \ >  *               %%  |                                  %%   \?  *               %%  |              LnmTool             %%    | ?  *               %%  |          Support.c  c2003        %%    | ?  *               %%  |            Lyle W. West          %%    | ?  *               %%  |                                  %%    | ?  *               %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    | ?  *               \                                        \   | ?  *                \                                        \  | ?  *                 \                                        \ | ?  *                  \________________________________________\|   *  *  *:  *   Copyright (C) 2003 Lyle W. West, All Rights Reserved.  *K  *   Permission is granted to copy and use this program so long as [1] this I  *   copyright notice is preserved, and [2] no financial gain is involved I  *   in copying the program.  This program may not be sold as "shareware" H  *   or "public domain" software without the express, written permission  *   of the author.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h" #pragma module support VERSION   #include <stdio.h> #include <clidef.h>  #include <ctype.h> #include <descrip.h> #include <dirent.h>  #include <lnmdef.h>  #include <psldef.h>  #include <ssdef.h> #include <string.h>  #include <types.h> #include <X11/cursorfont.h>  #include <X11/dxmhelpb.h>  #include <X11/Intrinsic.h> #include <X11/StringDefs.h>  #include <X11/Xos.h> #include <X11/Xlib.h>  #include <X11/Xutil.h> #include <Xm/MwmUtil.h>  #include <Xm/Xm.h> #include <Xm/BulletinB.h>  #include <Xm/CascadeB.h> #include <Xm/Frame.h>  #include <Xm/Label.h>  #include <Xm/LabelG.h> #include <Xm/List.h> #include <Xm/MainW.h>  #include <Xm/PushB.h>  #include <Xm/PushBG.h> #include <Xm/RowColumn.h>  #include <Xm/Text.h> #include <Xm/TextF.h>  #include "defs.h"  #include "externs.h"  A     /* the following declarations are used only in this module so A        while global within thios module, they are not defined for         use in other modules */   char linestr[10];  char funcstr[32];    extern void HelpCB();  extern int TableSort();   N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *$  *    Function: DisplayLnmAttributesC  * Description: Collect and display the attributes for the selected F  *              logical name. Note that collected/displayed attributesD  *              are for the index number specified in input argumentH  *              Index, which is diplayed as (n) in the Attributed widget*  *              where n is value of Index.  *5  *      Inputs: Index for which to display attributes 0  *     Returns: TRUE = success, FALSE is failure  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ # int DisplayLnmAttributes(int Index)  {      int Attributes = 0;      int indx = 0;      int max_indx = 0;      int status;      char AcMode;     char ClearBuf[40];     XmTextPosition curpos = 0;     ITEM_LST  *LnmItm;  ,     $DESCRIPTOR(Dsc_Lnm, TargetLogicalName);*     $DESCRIPTOR(Dsc_Tbl, TargetTableName);  5     Dsc_Lnm.dsc$w_length = strlen(TargetLogicalName); 3     Dsc_Tbl.dsc$w_length = strlen(TargetTableName);   .     curpos = XmTextGetLastPosition(AttrTextW);     if(curpos) {7         memset(&AscAttribStr, 0, sizeof(AscAttribStr));          NumAttr = 0;2         memset(&ClearBuf, 0x20, sizeof(ClearBuf));         ClearBuf[0] = 0;-         XmTextSetString(AttrTextW, ClearBuf);          startpos = 0; 8         XmTextSetInsertionPosition(AttrTextW, startpos);     }   0     curpos = XmTextGetLastPosition(AccessTextW);     if(curpos) {7         memset(&AscAttribStr, 0, sizeof(AscAttribStr));          NumAttr = 0;2         memset(&ClearBuf, 0x20, sizeof(ClearBuf));         ClearBuf[0] = 0;/         XmTextSetString(AccessTextW, ClearBuf);          startpos = 0; :         XmTextSetInsertionPosition(AccessTextW, startpos);     }   )     memset(&LnmItm0, 0, sizeof(LnmItm0)); &     LnmItm0[0].len = sizeof(max_indx);%     LnmItm0[0].code = LNM$_MAX_INDEX; "     LnmItm0[0].bufadr = &max_indx;     LnmItm0[0].retlen = 0;  ;     status = sys$trnlnm(0, &Dsc_Tbl, &Dsc_Lnm, 0, LnmItm0);      if(status != SS$_NORMAL) {)         sprintf(linestr, "%d", __LINE__); 3         sprintf(funcstr, "DisplayLnmAttributes()"); 2         LnmErrorPopup(status, &linestr, &funcstr);         return(FALSE);     }   C         /* Reconfigure LnmItm to get attribute and access values */   )     memset(&LnmItm1, 0, sizeof(LnmItm1)); #     LnmItm1[0].len = sizeof(Index); !     LnmItm1[0].code = LNM$_INDEX;      LnmItm1[0].bufadr = &Index;      LnmItm1[0].retlen = 0;(     LnmItm1[1].len = sizeof(Attributes);&     LnmItm1[1].code = LNM$_ATTRIBUTES;$     LnmItm1[1].bufadr = &Attributes;     LnmItm1[1].retlen = 0;$     LnmItm1[2].len = sizeof(AcMode);"     LnmItm1[2].code = LNM$_ACMODE;      LnmItm1[2].bufadr = &AcMode;     LnmItm1[2].retlen = 0;  ;     status = sys$trnlnm(0, &Dsc_Tbl, &Dsc_Lnm, 0, LnmItm1);      if(status != SS$_NORMAL) {)         sprintf(linestr, "%d", __LINE__); 3         sprintf(funcstr, "DisplayLnmAttributes()"); 2         LnmErrorPopup(status, &linestr, &funcstr);         return(FALSE);     }        switch((int)AcMode) {            case PSL$C_KERNEL:,             sprintf(AscAccessStr, "Kernel");             break;           case PSL$C_EXEC:/             sprintf(AscAccessStr, "Executive");              break;           case PSL$C_SUPER: 0             sprintf(AscAccessStr, "Supervisor");             break;           case PSL$C_USER:*             sprintf(AscAccessStr, "User");             break;       }   H         /* now put the access mode string into the AccessTextW widget */  P     XmTextInsert(AccessTextW, XmTextGetLastPosition(AccessTextW), AscAccessStr);  D         /* Perform a logical AND on each bit if the Attribute flag, E            for each set bit, append attribute name to AscAttribStr */     %     if(LNM$M_NO_ALIAS & Attributes) { *         strcat(AscAttribStr, "No_alias ");         NumAttr++;     } $     if(LNM$M_CONFINE & Attributes) {)         strcat(AscAttribStr, "Confine ");          NumAttr++;     } #     if(LNM$M_CRELOG & Attributes) { (         strcat(AscAttribStr, "Crelog ");         NumAttr++;     } "     if(LNM$M_TABLE & Attributes) {'         strcat(AscAttribStr, "Table ");          NumAttr++;     } &     if(LNM$M_CONCEALED & Attributes) {+         strcat(AscAttribStr, "Concealed ");          NumAttr++;-         XtSetSensitive(TypeOptions[1], True);      } %     if(LNM$M_TERMINAL & Attributes) { *         strcat(AscAttribStr, "Terminal ");         NumAttr++;     } > #ifdef ARF      /* if it didn't exist, we wouldn't be here! */#     if(LNM$M_EXISTS & Attributes) { (         strcat(AscAttribStr, "Exists ");         NumAttr++;     }  #endif&     if(LNM$M_SHAREABLE & Attributes) {+         strcat(AscAttribStr, "Shareable ");          NumAttr++;     } (     if(LNM$M_CLUSTERWIDE & Attributes) {-         strcat(AscAttribStr, "Clusterwide ");          NumAttr++;     } &     if(LNM$M_CREATE_IF & Attributes) {+         strcat(AscAttribStr, "Create_if ");          NumAttr++;     } '     if(LNM$M_CASE_BLIND & Attributes) { ,         strcat(AscAttribStr, "Case_blind ");         NumAttr++;     } (     if(LNM$M_INTERLOCKED & Attributes) {-         strcat(AscAttribStr, "Interlocked ");          NumAttr++;     }        if(!NumAttr) {*         sprintf(AscAttribStr, "< None >");         NumAttr++;     }   D         /* now put the attribute string into the AttrTextW widget */  L     XmTextInsert(AttrTextW, XmTextGetLastPosition(AttrTextW), AscAttribStr);:     XmUpdateDisplay(LnmForm);    /* refresh immediately */       return(TRUE);  }   N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: DisplayLnmEquiv H  * Description: Determine and load all equivalence strings for selected 7  *              logical name into the EquivTextW widget   *0  *      Inputs: TRUE = success, FALSE is failure  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int DisplayLnmEquiv()  {      int indx = 0;      int max_indx = 0;      int status; O     int increment=0, maximum=0, minimum=0, page_incr=0, slider_size=0, value=0;      short EqvLen = 0;      char ClearBuf[10];     char EquivName[80];        ITEM_LST  *LnmItm;     EQUIV_LST *EqvPtr;  ,     $DESCRIPTOR(Dsc_Lnm, TargetLogicalName);*     $DESCRIPTOR(Dsc_Tbl, TargetTableName);  5     Dsc_Lnm.dsc$w_length = strlen(TargetLogicalName); 3     Dsc_Tbl.dsc$w_length = strlen(TargetTableName);   E         /* initialize various items if equivs previously displayed */        if(NumEqv) {         cfree(AscEquivList);         NumEqv = 0;          strcpy(ClearBuf, ""); .         XmTextSetString(EquivTextW, ClearBuf);         startpos = 0; 9         XmTextSetInsertionPosition(EquivTextW, startpos);      }   G         /* determine the number of index values for selected logical */   )     memset(&LnmItm0, 0, sizeof(LnmItm0)); &     LnmItm0[0].len = sizeof(max_indx);%     LnmItm0[0].code = LNM$_MAX_INDEX; "     LnmItm0[0].bufadr = &max_indx;     LnmItm0[0].retlen = 0;;     status = sys$trnlnm(0, &Dsc_Tbl, &Dsc_Lnm, 0, LnmItm0);      if(status != SS$_NORMAL) {)         sprintf(linestr, "%d", __LINE__); .         sprintf(funcstr, "DisplayLnmEquiv()");2         LnmErrorPopup(status, &linestr, &funcstr);         return(FALSE);     }   A         /* allocate memory to write equivalence string(s) into */        NumEqv = max_indx + 1;G     AscEquivList = (EQUIV_LST *) calloc(max_indx+1, sizeof(EQUIV_LST));      EqvPtr = AscEquivList;  A         /* Reinitialize LnmItm to get equiv names. Get each equiv I            name and save in 'AscEquivList' array and EquivTextW widget */   )     memset(&LnmItm1, 0, sizeof(LnmItm1)); "     LnmItm1[0].len = sizeof(indx);!     LnmItm1[0].code = LNM$_INDEX;      LnmItm1[0].bufadr = &indx;     LnmItm1[0].retlen = 0;'     LnmItm1[1].len = sizeof(EquivName); "     LnmItm1[1].code = LNM$_STRING;"     LnmItm1[1].bufadr = EquivName;      LnmItm1[1].retlen = &EqvLen;  -     for(indx = 0; indx <= max_indx; indx++) { ?         status = sys$trnlnm(0, &Dsc_Tbl, &Dsc_Lnm, 0, LnmItm1); "         if(status != SS$_NORMAL) {-             sprintf(linestr, "%d", __LINE__); 2             sprintf(funcstr, "DisplayLnmEquiv()");6             LnmErrorPopup(status, &linestr, &funcstr);             return(FALSE);	         }          EquivName[EqvLen] = 0;"         strcpy(EqvPtr, EquivName);         strcat(EqvPtr, "\n"); D         XmTextInsert(EquivTextW, XmTextGetLastPosition(EquivTextW),              EqvPtr->EquivName); >         XmUpdateDisplay(LnmForm);    /* refresh immediately */         EqvPtr++;      }   H         /* the purpose of the following exercise is to put the scrollbarG            slider back at the top, as after 3 or more lines of text are H            loaded, it sits at the bottom+1 of the text window. This code&            moves it back to the top */        XtVaGetValues(EquivSB,%         XmNincrement,     &increment, #         XmNmaximum,       &maximum, #         XmNminimum,       &minimum, %         XmNpageIncrement, &page_incr, '         XmNsliderSize,    &slider_size, !         XmNvalue,         &value,          NULL);       value = 0;@     XmScrollBarSetValues(EquivSB, value, slider_size, increment,*                          page_incr, TRUE);:     XmUpdateDisplay(LnmForm);    /* refresh immediately */     return(TRUE);  }         N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetLnm L  * Description: Function to translate a provided logical name to the definedJ  *              equivalence string. All accessable logical name tables areK  *              searched until a match is found. If successful the returned K  *              equivalence string is copied to the memory location used to J  *              provide the input logical name (lnmstr). In all cases, theB  *              return status of SYS$TRNLNM is returned to caller.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ ( int GetLnm(char *lnmstr, int lookuptype) { I     int nocase = LNM$M_CASE_BLIND;  /* resolve lnm without case issues */ K     int eqvattrb = 0;               /* returned attributes of eqv string */      int LnmStat = 0;     short eqv_len = 0;     short tbl_len = 0;?     char acmode = PSL$C_USER;       /* always from user mode */ <     char LnmTable[40];              /* logical name table */=     char LnmDef[40];                /* logical name string */ I     char LnmEqv[132];               /* logical name equivalence string */   &     $DESCRIPTOR(Dsc_Tabnam, LnmTable);$     $DESCRIPTOR(Dsc_Lognam, LnmDef);$     $DESCRIPTOR(Dsc_Eqvnam, LnmEqv);  '     memset(&LnmEqv, 0, sizeof(LnmEqv));      strcpy(LnmDef, lnmstr); C     if(lookuptype == LNM_LOGICAL) strcpy(LnmTable, "LNM$FILE_DEV"); 2     else strcpy(LnmTable, "LNM$SYSTEM_DIRECTORY");/     Dsc_Tabnam.dsc$w_length = strlen(LnmTable); -     Dsc_Lognam.dsc$w_length = strlen(LnmDef); -     Dsc_Eqvnam.dsc$w_length = sizeof(LnmEqv);   )     memset(&LnmItm1, 0, sizeof(LnmItm1)); &     LnmItm1[0].len = sizeof(eqvattrb);&     LnmItm1[0].code = LNM$_ATTRIBUTES;"     LnmItm1[0].bufadr = &eqvattrb;     LnmItm1[0].retlen = 0;&     LnmItm1[1].len = sizeof(LnmTable);!     LnmItm1[1].code = LNM$_TABLE; "     LnmItm1[1].bufadr = &LnmTable;!     LnmItm1[1].retlen = &tbl_len; $     LnmItm1[2].len = sizeof(LnmEqv);"     LnmItm1[2].code = LNM$_STRING;      LnmItm1[2].bufadr = &LnmEqv;!     LnmItm1[2].retlen = &eqv_len;   O     LnmStat = sys$trnlnm(&nocase, &Dsc_Tabnam, &Dsc_Lognam, &acmode, &LnmItm1);      if(LnmStat == SS$_NORMAL) {          LnmEqv[eqv_len] = '\0'; !         LnmTable[tbl_len] = '\0';          strcpy(lnmstr, LnmEqv);          return(LnmStat);       }      else return(LnmStat);  }         N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *   *    Function: CheckEnvLogicalsE  * Description: This routine checks the users environment for several G  *              logical names which affect the startup of LnmTool. They <  *              are (with default equivalence values shown):C  *               - LNMTOOL_INPUTFILE DECW$USER_DEFAULTS:LNMTOOL.INP #  *               - LNMTOOL_FORMAT 2 :  *               - LNMTOOL_LOGFILE SYS$SCRATCH:LNMTOOL.LOGB  *               - LNMTOOL_HELPLIB DECW$_USER_DEFAULTS:LNMTOOL.HLBF  *              Note that if the equivalence values have syntax errors*  *              their presence is ignored.  *  *      Inputs: None  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void CheckEnvLogicals()  {      int CelStat;     char LnmBuf[80];  8         /* check for the startup file, LNMTOOL_INFILE */  &     sprintf(LnmBuf, "LNMTOOL_INFILE");+     CelStat = GetLnm(&LnmBuf, LNM_LOGICAL);      if(CelStat == SS$_NORMAL) {           StartFileDefined = TRUE;&         strcpy(InputFileSpec, LnmBuf);     }   7         /* check for the format mode, LNMTOOL_FORMAT */   &     sprintf(LnmBuf, "LNMTOOL_FORMAT");+     CelStat = GetLnm(&LnmBuf, LNM_LOGICAL);      if(CelStat == SS$_NORMAL) { !         switch((int) LnmBuf[0]) {              case '4': -                 DisplayRootMode = COLSMODE_4;                  break;             case '2': -                 DisplayRootMode = COLSMODE_2;                  break;             case '1': -                 DisplayRootMode = COLSMODE_1;                  break;	         }      }   9         /* check for the help library, LNMTOOL_HELPLIB */   '     sprintf(LnmBuf, "LNMTOOL_HELPLIB"); +     CelStat = GetLnm(&LnmBuf, LNM_LOGICAL); >     if(CelStat == SS$_NORMAL)  strcpy(LnmToolHelpLib, LnmBuf);  4         /* check for verify state, LNMTOOL_VERIFY */  &     sprintf(LnmBuf, "LNMTOOL_VERIFY");+     CelStat = GetLnm(&LnmBuf, LNM_LOGICAL);      if(CelStat == SS$_NORMAL) {%!         switch((int) LnmBuf[0]) {              case 'T': "                 VerifyMode = TRUE;                 break;             case 'F':_#                 VerifyMode = FALSE;                  break;	         }      }   ;         /* check for logfile name state, LNMTOOL_LOGFILE */   '     sprintf(LnmBuf, "LNMTOOL_LOGFILE"); +     CelStat = GetLnm(&LnmBuf, LNM_LOGICAL);|     if(CelStat == SS$_NORMAL) {          LoggingEnabled = TRUE;$         strcpy(LogFileSpec, LnmBuf);     }* }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *   *    Function: OpenLnmtoolLog()  * Description: .   *              .   *              .   *              .   *              .   *              .   *              .   *              ._  *  *      Inputs: None  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void OpenLnmtoolLog()u {t     char openstat;     char buffer[80];     char CurTime[24];v#     $DESCRIPTOR(Dsc_Time, CurTime);l  .     openstat = sys$asctim(0, &Dsc_Time, 0, 0);H     lnmlog_fp = fopen(LogFileSpec, "w", "rat=cr", "rfm=var", "shr=upi");     if(lnmlog_fp == -1) {iF         printf("%%LNMTOOL-E-OPEN, Cannot open '%s'\n\n", LogFileSpec);         exit(1);     }*G     fprintf(lnmlog_fp, "LnmTool %s started, %s\n\n", VERSION, CurTime);c }e    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: InitHelpDlg F  * Description: Create the help dialog. LnmTool uses the DxmHelpdialogD  *              widget from the DECwindows Toolkit Extensions group.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */c void InitHelpDlg() {c     char HlpStr[50];     XmString CpStr;      XmString CsOverview;     XmString CsNoHlbMsg;  6         /* create some comp strs regarding help lib */  *     sprintf(HlpStr, "%s", LnmToolHelpLib);)     CpStr = XmStringCreateSimple(HlpStr);u&     sprintf(HlpStr, "%s", "Overview");.     CsOverview = XmStringCreateSimple(HlpStr);3     sprintf(HlpStr, "Cannot open LNMTOOL_HELPLIB");u.     CsNoHlbMsg = XmStringCreateSimple(HlpStr);  6         /* create the Help widget with some options */  
     n = 0;%     XtSetArg(args[n], XmNx, 20); n++; %     XtSetArg(args[n], XmNy, 20); n++;r*     XtSetArg(args[n], DXmNapplicationName,.         XmStringCreateSimple("LnmTool")); n++;%     XtSetArg(args[n], DXmNcloseLabel,*,         XmStringCreateSimple("Close")); n++;3     XtSetArg(args[n], DXmNlibrarySpec, CpStr); n++; :     XtSetArg(args[n], DXmNbadlibMessage, CsNoHlbMsg); n++;7     XtSetArg(args[n], DXmNdefaultPosition, False); n++; 7     XtSetArg(args[n], DXmNfirstTopic, CsOverview); n++;r1     XtSetArg(args[n], XmNfontList, charset); n++; ?     HelpDlg = DXmCreateHelpDialog(LnmForm, "DxmHelp", args, n);      XtManageChild(HelpDlg);n  $         /* Add the unmap callback */  E     XtAddCallback(HelpDlg, XmNunmapCallback, HelpCB, HELP_CLOSE_BTN);*     XmStringFree(CpStr);     XmStringFree(CsNoHlbMsg);  }n    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *!  *    Function: LoadFileTableListsK  * Description: Load the Logicalname Tables widget with table names from a  J  *              previously saved file. This operation replaces the normal E  *              load operation by LoadTableList, which translates therE  *              indexes from LNM$FILE_DEV. Here we read from the fileN8  *              specified in the variable InputFileSpec.  *              J  *              Determine the number of tables by reading table names from@  *              the file. Use this value to allocate an array ofJ  *              ascii table names. Then copy the ascii table contents intoK  *              compound strings which are then loaded into the List widget !  *              'MainTableListW. n  *  *      Inputs: None  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */a void LoadFileTableList() {;
     int done;B     int indx = 0;      int status;c     char TableStr[40];     char RecordBuf[132];     char *ptr1;s     char *ptr2;c       TABLE_LST *TablePtr;       if(NumTbl) {         cfree(AscTableList);-         XmListDeleteAllItems(MainTableListW);m         NumTbl = 0;I     }   8         /* open the file specified by 'InputFileSpec' */  *     lnmlst_fp = fopen(InputFileSpec, "r");     if(!lnmlst_fp) {-         if(LoggingEnabled) fprintf(lnmlog_fp,(N             "Unable to open %s, \n loading from LNM$FILE_DEV", InputFileSpec);M         sprintf(RecordBuf, "Unable to open %s, \n loading from LNM$FILE_DEV",              InputFileSpec);e1         DispErrPopup("Load File", &RecordBuf, 0);          LoadTableList();         return;      }m  (         /* get number of tables first */       NumTbl = 0; >     status = fgets(RecordBuf, sizeof(RecordBuf)-1, lnmlst_fp);(     ptr1 = strstr(RecordBuf, "LnmTool");     if(!ptr1) {          fclose(lnmlst_fp);         if(LoggingEnabled) {S             fprintf(lnmlog_fp, "Invalid Load Format, loading from LNM$FILE_DEV\n"); E             fprintf(lnmlog_fp, "Loadfile %s invalid", InputFileSpec); 	         } O         sprintf(RecordBuf, "Invalid Load Format, loading from LNM$FILE_DEV\n");RC         sprintf(RecordBuf+strlen(RecordBuf), "Loadfile %s invalid",u             InputFileSpec);)1         DispErrPopup("Load File", &RecordBuf, 0);s         LoadTableList();         return;      }(
     else {         if(LoggingEnabled)J             fprintf(lnmlog_fp, "Loading Tables from %s\n", InputFileSpec);         done = FALSE;          while (!done) {cF             status = fgets(RecordBuf, sizeof(RecordBuf)-1, lnmlst_fp);2             if (status != &RecordBuf) done = TRUE;             else {"                 ptr1 = &RecordBuf;$                 if(isspace(*ptr1)) {1                     while(isspace(*ptr1)) ptr1++;e0                     if(isalnum(*ptr1)) NumTbl++;                 }t1                 else if(isalnum(*ptr1)) NumTbl++;s
             } 	         }P     }a  3         /* allocate some memory for AscTableList */   E     AscTableList = (TABLE_LST *) calloc(NumTbl+1, sizeof(TABLE_LST));      TablePtr = AscTableList;  <         /* now copy table names from file to AscTableList */       status = rewind(lnmlst_fp);&     TablePtr = AscTableList;     done = FALSE;f     while (!done) {A1         memset(&RecordBuf, 0, sizeof(RecordBuf)); B         status = fgets(RecordBuf, sizeof(RecordBuf)-1, lnmlst_fp);.         if (status != &RecordBuf) done = TRUE;         else {             ptr1 = &RecordBuf;              if(isspace(*ptr1)) {-                 while(isspace(*ptr1)) ptr1++;,2                 sscanf(RecordBuf, "%s", TableStr);6                 strcpy(TablePtr->TableName, TableStr);H                 TablePtr->LnmCount = 32768;      /* not valid (X8000) */                 TablePtr++;f
             }   	         }s     }o     fclose(lnmlst_fp);     TablePtr = AscTableList;  3         /* sort newly loaded list of table names */u  B     qsort((void *)TablePtr, NumTbl, sizeof(TABLE_LST), TableSort);  8         /* Move table list into compound string array */       TablePtr = AscTableList;+     for(indx = 0; indx <= NumTbl; indx++) {t'         CsTlistItems[indx] = (XmString) =             XmStringCreateLtoR(TablePtr->TableName, charset);A         TablePtr++;i     }   C         /* Update the target table list with new number of items */   
     n = 0;3     XtSetArg(args[n], XmNitems, CsTlistItems); n++; 1     XtSetArg(args[n], XmNitemCount, NumTbl); n++; 3     XtSetArg(args[n], XmNvisibleItemCount, 5); n++;A)     XtSetValues(MainTableListW, args, n);    }i