I {************************************************************************  *									* % *  J U M P -- JUMP_FIDDLER.PAS						*  *									* I *-----------------------------------------------------------------------* = *  ****  CAUTION: KERNEL-mode code fiddles things !!! ****		*  *									* / *  JUMP requires the following privileges:				* < *	CMEXEC, CMKRNL, DETACH (or IMPERSONATE), SYSNAM, SYSPRV 	* *									* G *  INSTALL JUMP with these privileges if non-privileged users will be	*  *  running JUMP.							* *									* H *  NOTE: The definition of privilege sets has been adopted for ease of	*H *  coding.  The source for the information is SYS$LIBRARY:STARLET.PAS.	*E *  The definition will need reviewing with each release of OpenVMS!	* I *-----------------------------------------------------------------------*  *									* F *  ***	CAUTION: JUMP has dependencies on the underlying architecture	*@ *  ***		 (VAX, Alpha or IA64) and the version of OpenVMS.  Any	*; *  ***		 changes to either of these *REQUIRES* JUMP to be	*  *  ***		 re-linked.						* *									* I ************************************************************************* / *  Author and Maintainer: Jonathan Ridler.				*  *									* C *  This software is owned and maintained privately by the author,	* F *  Jonathan Ridler. It is NOT in any way produced, owned, supported,	*D *  maintained or endorsed by Hewlett Packard Pty Ltd or any of its	* *  legal entities.							* *									* ( *  Email: vmsjump@internode.on.net					*I ************************************************************************* I *************************************************************************  ***								      ***$ ***			    LICENCE NOTICE			      *** ***								      ***H ***  This software is COPYRIGHT (c) 1993-2012 Jonathan Ridler.	      ***' ***  ALL RIGHTS RESERVED.					      ***  ***								      ***G ***  Please READ the file JUMP_LICENCE.TXT which contains the	      *** C ***  complete Licence and all conditions of use for JUMP.	      ***  ***								      ***I ************************************************************************* I *************************************************************************  *									*  *  History:								*. *	01-Feb-2012	JER	New module for JUMP V6.0.		*! *	03-Feb-2012	JER	JUMP V6.1.				* 8 *	21-Feb-2012	JER	JUMP V6.1a; added build level ident.	*I ************************************************************************}   ! [INHERIT ('SYS$LIBRARY:STARLET')]    MODULE Jump_Fiddler ;      TYPE  % Unsigned_Ptr = [VOLATILE] ^UNSIGNED ;    VAR   I {************************************************************************ I  ****  INCREMENT the BUILD LEVEL every time the module is changed!!  **** J  ************************************************************************}  7 Fiddler_Bl : [GLOBAL] VARYING [12] OF CHAR := '1.006' ;     2 [ASYNCHRONOUS,Check(None)] PROCEDURE Read_Longword 				(VAR Location , ' 				 Pointer : [UNSAFE] Unsigned_Ptr) ;   % { In EXEC MODE, peek at a location. }      BEGIN "   Location::UNSIGNED := Pointer^ ;   END ;     3 [ASYNCHRONOUS,Check(None)] PROCEDURE Write_Longword  				(VAR Location , ( 				 Pointer  : [UNSAFE] Unsigned_Ptr) ;  1 { In KERNEL MODE, poke a value into a location. }      BEGIN "   Pointer^ := Location::UNSIGNED ;   END ;     ) [GLOBAL] PROCEDURE Getmem (VAR Location , ) 			   Pointer  : [UNSAFE] Unsigned_Ptr) ;   6 { Jacket routine to peek at a location in EXEC MODE. }  P   VAR Arglst : [UNSAFE] ARRAY [1..3] OF UNSIGNED := (2,0,0) ;  { Argument list }     BEGIN 	{ Getmem } $   Arglst[2] := IADDRESS (Location) ;#   Arglst[3] := IADDRESS (Pointer) ; .   $CMEXEC (%IMMED Read_Longword,%REF Arglst) ;   END ; 	{ of Getmem }    ) [GLOBAL] PROCEDURE Putmem (VAR Location , ) 			   Pointer  : [UNSAFE] Unsigned_Ptr) ;   B { Jacket routine to poke a value into a location in KERNEL MODE. }  P   VAR Arglst : [UNSAFE] ARRAY [1..3] OF UNSIGNED := (2,0,0) ;  { Argument list }     BEGIN 	{ Putmem } $   Arglst[2] := IADDRESS (Location) ;#   Arglst[3] := IADDRESS (Pointer) ; /   $CMKRNL (%IMMED Write_Longword,%REF Arglst) ;    END ; 	{ of Putmem }   END.	{ JUMP_Fiddler } 