I {************************************************************************  *									*  *  J U M P -- JUMP.PAS							* *									* B *  JUMP allows a user to login exactly as another user without a	*I *  password. It also allows a more restricted (non-exact) impersonation *  *  of another user.							*  *									* G *  Use of JUMP is restricted to specific categories of users: Systems	* B *  Programmers, Operators and any specifically authorised users.	* *									* 3 *  The syntax of the JUMP command generally is				*  *									* + *      $ JUMP [username] [qualifiers]					*  *									* F *  For full documentation on JUMP, see the HELP file (JUMP.HLP), the	*B *  example access file (JUMP_ACCESS.DAT) and other files in the 	* *  distribution kit.							*I *-----------------------------------------------------------------------* = *  ****  CAUTION: KERNEL-mode code fiddles things !!! ****		*  *									* / *  JUMP requires the following privileges:				* < *	CMEXEC, CMKRNL, DETACH (or IMPERSONATE), SYSNAM, SYSPRV 	* *									* G *  INSTALL JUMP with these privileges if non-privileged users will be	*  *  running JUMP.							* *									* H *  NOTE: The definition of privilege sets has been adopted for ease of	*H *  coding.  The source for the information is SYS$LIBRARY:STARLET.PAS.	*E *  The definition will need reviewing with each release of OpenVMS!	* I *-----------------------------------------------------------------------*  *									* F *  ***	CAUTION: JUMP has dependencies on the underlying architecture	*@ *  ***		 (VAX, Alpha or IA64) and the version of OpenVMS.  Any	*; *  ***		 changes to either of these *REQUIRES* JUMP to be	*  *  ***		 re-linked.						* *									* I ************************************************************************* / *  Author and Maintainer: Jonathan Ridler.				*  *									* C *  This software is owned and maintained privately by the author,	* F *  Jonathan Ridler. It is NOT in any way produced, owned, supported,	*D *  maintained or endorsed by Hewlett Packard Pty Ltd or any of its	* *  legal entities.							* *									* ( *  Email: vmsjump@internode.on.net					*I ************************************************************************* I *************************************************************************  ***								      ***$ ***			    LICENCE NOTICE			      *** ***								      ***H ***  This software is COPYRIGHT (c) 1993-2012 Jonathan Ridler.	      ***' ***  ALL RIGHTS RESERVED.					      ***  ***								      ***G ***  Please READ the file JUMP_LICENCE.TXT which contains the	      *** C ***  complete Licence and all conditions of use for JUMP.	      ***  ***								      ***I ************************************************************************* I *************************************************************************  *									* E *  Revision History: See file CHANGES.TXT in the JUMP distribution.	*  *									* I ************************************************************************}     [INHERIT ('SYS$LIBRARY:STARLET',% 	  'SYS$LIBRARY:PASCAL$CLI_ROUTINES', % 	  'SYS$LIBRARY:PASCAL$LIB_ROUTINES', % 	  'SYS$LIBRARY:PASCAL$LBR_ROUTINES', & 	  'SYS$LIBRARY:PASCAL$MAIL_ROUTINES',& 	  'SYS$LIBRARY:PASCAL$STR_ROUTINES')]  ) PROGRAM Jump (OUTPUT, Logfile, Dbgfile) ;    CONST    Null = CHR (00) ;		{ NUL } Bell = CHR (07) ;		{ BEL } Lf   = CHR (10) ;		{ Linefeed } & Cr   = CHR (13) ;		{ Carriage Return } Xon  = CHR (17) ;		{ XON } Xoff = CHR (19) ;		{ XOFF }  Esc  = CHR (27) ;		{ ESC }  B Io_Buflen = 1 * 512 ;		{ *WORDS* = 1 pair of 512 byte R/W blocks }< Rsts = 1 ;			{ Index to read status in pseudo-terminal buf }; Rcnt = 2 ;			{ Count of chars read in pseudo-terminal buf } - Rbuf = 3 ;			{ Actual read data area begins } L Wsts = Io_Buflen DIV 2 + 1 ;	{ Start of write buffer area and write status }A Wcnt = Wsts + 1 ;		{ Count of chars writ in pseudo-terminal buf } 3 Wbuf = Wsts + 2 ;		{ Actual read data area begins } E Ft_Buflen = Io_Buflen - 4 ;	{ *BYTES* Size of buffer for FTA device } B Py_Buflen = Io_Buflen ; 	{ *BYTES* Size of buffer for PYA device }  L { The effective length of a username is 12 characters. However, the internalE   fields are 32 characters.  Use 12 characters as the maximum length.   K   ENSURE the constant is identical in the JUMP, JUMP_POKER and JUMP_PERSONA 
   modules!  }    Max_Username_Len = 12 ;   > Rightsize = 80 ;		{ Number of rightslist entries to retrieve }   Digits	   = ['0'..'9'] ;" Alphanum   = ['0'..'9','A'..'Z'] ; Wildcard   = ['*','%'] ;" Symbol	   = Alphanum + ['$','_'] ; Uic_Left   = ['[','<'] ; Uic_Right  = [']','>'] ; Separators = [',','-'] ;8 Esc_Chars  = ['D','F','G','I','K','L','N','P','U','V'] ;  K Max_Scm_Num = 1024 ;	{ Maximum number of commands for Single Command Mode }    TYPE  " $BOOL  = [BIT(1),UNSAFE] BOOLEAN ; $UBYTE = [BYTE] 0..255 ; $UWORD = [WORD] 0..65535 ;: $UQUAD = [QUAD,UNSAFE] RECORD  L0 , L1 : UNSIGNED ;  END ;   Word_Ptr     = ^$UWORD ;% Unsigned_Ptr = [VOLATILE] ^UNSIGNED ;   6 Privilege = (Cmkrnl,	{  0: May change Mode to Kernel }A 	     Cmexec,	{  1: May change Mode to Exec; MUST follow Cmkrnl } = 	     Sysnam,	{  2: May insert in system logical name table } E 	     Grpnam,	{  3: May insert in group l.n.tab; MUST follow Sysnam } 3 	     Allspool,	{  4: May allocate spooled device } E 	     Detach,	{  5: May create detached processes (aka Impersonate) } , 	     Diagnose,	{  6: May diagnose devices }( 	     Log_Io,	{  7: May do logical I/O }A 	     Group,	{  8: May affect other processes in same UIC group } + 	     Acnt,	{  9: May suppress accounting } @ 	     Prmceb,	{ 10: May create permanent common event clusters }3 	     Prmmbx,	{ 11: May create permanent mail box } - 	     Pswapm,	{ 12: May change process mode } 0 	     Altpri,	{ 13: May set any priority value }0 	     Setprv,	{ 14: May set any privilege bits }2 	     Tmpmbx,	{ 15: May create temporary mailbox }< 	     World,	{ 16: May affect other processes in the world }4 	     Mount,	{ 17: May execute mount ACP functions }& 	     Oper,	{ 18: Operator privilege }- 	     Exquota,	{ 19: May exceed disk quotas } / 	     Netmbx,	{ 20: May create network device } 4 	     Volpro,	{ 21: May override volume protection }) 	     Phy_Io,	{ 22: May do physical I/O } : 	     Bugchk,	{ 23: May make bug check error log entries }: 	     Prmgbl,	{ 24: May create permanent global sections }< 	     Sysgbl,	{ 25: May create system-wide global sections }/ 	     Pfnmap,	{ 26: May map to section by PFN } = 	     Shmem,	{ 27: May allocate structures in shared memory } : 	     Sysprv,	{ 28: Eligible for system protection field }5 	     Bypass,	{ 29: May bypass UIC-based protection } 2 	     Syslck,	{ 30: May create system-wide locks }< 	     Share,	{ 31: May assign channel to non-shared device }3 	     Upgrade,	{ 32: May upgrade object integrity } 5 	     Downgrade, { 33: May downgrade object secrecy } > 	     Grpprv,	{ 34: Group access via system protection field }* 	     Readall,	{ 35: May read any object }A 	     Import,	{ 36: May set classification for unlabeled object } B 	     Audit,	{ 37: May direct audit to system security audit log }6 	     Security,	{ 38: May perform security functions }= 	     Pbit39, Pbit40, Pbit41, Pbit42, Pbit43, Pbit44, Pbit45, = 	     Pbit46, Pbit47, Pbit48, Pbit49, Pbit50, Pbit51, Pbit52, = 	     Pbit53, Pbit54, Pbit55, Pbit56, Pbit57, Pbit58, Pbit59, F 	     Pbit60, Pbit61, Pbit62, Pbit63) ;	{ 39-63: dummy bits: 2 LONGs }  C Privset = PACKED SET OF Privilege ;		{ Allow easy bit union, etc. }   H { Oper_Class defines the bits in the operator class mask. This should be0   reviewed with each major release of OpenVMS. }   Oper_Class = (Central,		{  0 } 	      Printer,		{  1 }  	      Tapes,		{  2 }  	      Disks,		{  3 }  	      Devices,		{  4 }  	      Cards,		{  5 }  	      Network,		{  6 }  	      Cluster,		{  7 } C 	      Opc_Security,	{  8 = SECURITY ... avoid same name as priv! }  	      Reply,		{  9 }  	      Software, 	{ 10 } 	      License,		{ 11 }  	      Oper1,		{ 12 = USER1 }  	      Oper2,		{ 13 = USER2 }  	      Oper3,		{ 14 = USER3 }  	      Oper4,		{ 15 = USER4 }  	      Oper5,		{ 16 = USER5 }  	      Oper6,		{ 17 = USER6 }  	      Oper7,		{ 18 = USER7 }  	      Oper8,		{ 19 = USER8 }  	      Oper9,		{ 20 = USER9 }  	      Oper10,		{ 21 = USER10 }  	      Oper11,		{ 22 = USER11 } ! 	      Oper12) ; 	{ 23 = USER12 }   J Access_Status = (Granted,Denied,Unspecified) ;	{ Status from access file }  L Architecture_Type = (Vax,Alpha,Integrity) ;	{ Past, present ... and future!}  < Status_Block_Type = [UNSAFE] PACKED ARRAY [1..4] OF $UWORD ;   Item_List_Cell = RECORD  		   CASE INTEGER OF 		     1: (			{ Normal Cell }  			 Buffer_Length : $UWORD ; 			 Item_Code     : $UWORD ; 			 Buffer_Addr   : UNSIGNED ; 			 Return_Addr   : UNSIGNED 			) ; 		     2: (			{ Terminator } 			 Terminator    : UNSIGNED 			) ; 		 END ;  I Item_List_Template (Count:INTEGER) = ARRAY [1..Count] OF Item_List_Cell ;   < Username_Type = PACKED ARRAY [1..Max_Username_Len] OF CHAR ;  3 Just_A_String = VARYING [1024] OF CHAR VALUE ZERO ;   / Rights_Array = ARRAY [1..Rightsize] OF $UQUAD ;   ' { Signal and Mechanism parameters ... }   ' Sig_Args  = ARRAY [0..100] OF INTEGER ; E Mech_Args = ARRAY [0..(SIZE(CHF2$TYPE)-4)DIV 4] OF [UNSAFE] INTEGER ;   < Io_Buffer = [ALIGNED(9),STATIC,UNSAFE]			{ Pagelet aligned } 		RECORD 		  CASE BOOLEAN OF A 		  TRUE:  (Raw : ARRAY [1..Io_Buflen]   OF $UWORD  VALUE ZERO) ; @ 		  FALSE: (One : ARRAY [1..Io_Buflen*2] OF CHAR	  VALUE ZERO) ; 		END ;    Terminal_Chars = PACKED RECORD% 		   Tt_Class    : [POS(0)]  $UBYTE ; % 		   Tt_Type     : [POS(8)]  $UBYTE ; % 		   Tt_Width    : [POS(16)] $UWORD ; & 		   Tt_Devchar  : [POS(32)] TT$TYPE ;' 		   Tt_Devchar2 : [POS(64)] TT2$TYPE ;  		 END ;   Prtctl_Type = PACKED RECORD + 		TTY$V_PC_NOTIME       : [POS(0)]  $BOOL ; + 		TTY$V_PC_DMAENA       : [POS(1)]  $BOOL ; + 		TTY$V_PC_DMAAVL       : [POS(2)]  $BOOL ; + 		TTY$V_PC_PRMMAP       : [POS(3)]  $BOOL ; + 		TTY$V_PC_MAPAVL       : [POS(4)]  $BOOL ; + 		TTY$V_PC_XOFAVL       : [POS(5)]  $BOOL ; + 		TTY$V_PC_XOFENA       : [POS(6)]  $BOOL ; + 		TTY$V_PC_NOCRLF       : [POS(7)]  $BOOL ; * 		TTY$V_PC_BREAK	      : [POS(8)]  $BOOL ;+ 		TTY$V_PC_PORTFDT      : [POS(9)]  $BOOL ; + 		TTY$V_PC_NOMODEM      : [POS(10)] $BOOL ; + 		TTY$V_PC_NODISCONNECT : [POS(11)] $BOOL ; + 		TTY$V_PC_SMART_READ   : [POS(12)] $BOOL ; + 		TTY$V_PC_ACCPORNAM    : [POS(13)] $BOOL ; + 		TTY$V_PC_MULTISESSION : [POS(15)] $BOOL ;  	      END ;   Notify_Mask = RECORD 		CASE INTEGER OF 7 		1: (All_Bits	: UNSIGNED ;) ; 	{ 32 bits - roomy! :) } < 		2: (After	: [BIT, POS(0)] BOOLEAN ;    { EXACT completed }= 		    Before	: [BIT, POS(1)] BOOLEAN ;    { EXACT initiated } > 		    Include_Log : [BIT, POS(2)] BOOLEAN ;    { Log in MAIL }8 		    By_Mail	: [BIT, POS(3)] BOOLEAN ;    { Send MAIL }= 		    By_Opcom	: [BIT, POS(4)] BOOLEAN ;    { OPCOM message } > 		    Vamoose	: [BIT, POS(5)] BOOLEAN ;) ; { Exit if problem } 	      END ;   Debug_Mask = RECORD  	       CASE INTEGER OF ? 	       1: (All_Bits : UNSIGNED ;) ;    { 32 bits - roomy! :) } C 	       2: (Info     : [BIT, POS(0)]  BOOLEAN ;	   { General Info } = 		   D1	    : [BIT, POS(1)]  BOOLEAN ;	   { Diagnostic info } = 		   D2	    : [BIT, POS(2)]  BOOLEAN ;	   { Diagnostic info } = 		   D3	    : [BIT, POS(3)]  BOOLEAN ;	   { Diagnostic info } = 		   D4	    : [BIT, POS(4)]  BOOLEAN ;	   { Diagnostic info } = 		   D5	    : [BIT, POS(5)]  BOOLEAN ;	   { Diagnostic info } = 		   D6	    : [BIT, POS(6)]  BOOLEAN ;	   { Diagnostic info } = 		   D7	    : [BIT, POS(7)]  BOOLEAN ;	   { Diagnostic info } = 		   D8	    : [BIT, POS(8)]  BOOLEAN ;	   { Diagnostic info } = 		   D9	    : [BIT, POS(9)]  BOOLEAN ;	   { Diagnostic info } > 		   X1	    : [BIT, POS(11)] BOOLEAN ;	   { Change execution }> 		   X2	    : [BIT, POS(12)] BOOLEAN ;	   { Change execution }> 		   X3	    : [BIT, POS(13)] BOOLEAN ;	   { Change execution }> 		   X4	    : [BIT, POS(14)] BOOLEAN ;	   { Change execution }> 		   X5	    : [BIT, POS(15)] BOOLEAN ;	   { Change execution }> 		   X6	    : [BIT, POS(16)] BOOLEAN ;	   { Change execution }> 		   X7	    : [BIT, POS(17)] BOOLEAN ;	   { Change execution }> 		   X8	    : [BIT, POS(18)] BOOLEAN ;	   { Change execution }? 		   X9	    : [BIT, POS(19)] BOOLEAN ;) ;  { Change execution }  	     END ;    CONST   N Required_Privs = [Cmexec,Cmkrnl,Detach,Sysnam,Sysprv] ; { Needed to run JUMP }A Single_Cmd_Mode_Privs = [Group,World] ; 		{ Extra privs for SCM }   I {************************************************************************ F  ****	   Update the Production_Version status as appropriate	     ****J  ************************************************************************}  K Production_Version = TRUE ;	{ Set TRUE only when ready for PRODUCTION use }    VAR   1 Fiddler_Bl ,			{ Build level for Fiddler module } 2 Persona_Bl ,			{ Build level for Persona modules }- Poker_Bl ,			{ Build level for Poker module } ) Vax_Bl				{ Build level for VAX modules } # : [EXTERNAL] VARYING [12] OF CHAR ;   I {************************************************************************ I  ****  INCREMENT the BUILD LEVEL every time the module is changed!!  **** J  ************************************************************************}  4 Main_Bl : [GLOBAL] VARYING [12] OF CHAR := '1.008' ;  I {************************************************************************ I  **** Keep the version up-to-date and in sync with the JUMP.OPT file **** J  ************************************************************************}   Jump_VersionB : VARYING [255] OF CHAR := 'JUMP V6.1a 2012-02-21 (21-Feb-2012)' ;  5 Sysprog ,			{ SETPRV priv or group <= MAXSYSGROUP ? }  Operator ,			{ OPER priv ? }" Log ,				{ Log success messages? } Debug , 			{ Debug messages? }" Alter_Ego ,			{ Change Username? }# Transmute ,			{ Change UIC, etc.? }  Auditing ,			{ Audit jumps? } = Real_Mccoy ,			{ Use a pseudo-terminal and *really* do it!? } G Double_Check ,                  { Double check general user's access? } 4 Narcissus ,			{ Allow users to jump to themselves? }? Broken_Chain ,			{ Attempt to chain when chaining prohibited? } * Figment ,			{ Allow username NOT in UAF? }< Stamp_Uaf ,			{ Update UAF Last Interactive Login + Fails? }. Suspect ,			{ Trying to subvert Secure Mode? }. Houdini ,			{ Allow override of Secure Mode? }' High_Security , 		{ Secure file open? } * Secure_Mode ,			{ Secure mode requested? }/ System_Secure_Mode ,		{ Secure mode mandated? } < Secure_Logical			{ Logical name is defined /SYSTEM /EXEC ? } : BOOLEAN := FALSE ;  O Chain ,                         { JUMP to target user's allowed JUMP targets? } > Secure_User_Dir 		{ JUMP_USER_DIR defined by System Manager? } : BOOLEAN := TRUE ;   9 Viewable ,			{ Text entered in terminal buffer visible? } 7 Visible 			{ Text entered in terminal buffer visible? }  : [VOLATILE] BOOLEAN := TRUE ;  ? Use_Persona ,			{ Use the PERSONA system calls, if available? } 4 Single_Cmd_Mode ,		{ Single Command Mode for EXACT }9 Open_New_File , 		{ Open new file in Special File Open? } A Debug_To_Terminal ,		{ Debug output going to a terminal device? } 8 Record_Session ,		{ Make a recording of an EXACT jump? }= Escape_Hatch ,			{ Escape character defined for EXACT jump? } 6 Jeronimo			{ Have we pulled the ripcord and escaped? } : [VOLATILE] BOOLEAN := FALSE ;   > Arb_Full_Support ,		{ Access Rights Block: ARB_SUPPORT = 3 ? }? Psb_Available			{ OpenVMS V7.2+ ? ==> Persona Security Block! } & : [GLOBAL,VOLATILE] BOOLEAN := FALSE ;  F Ripcord : [VOLATILE] CHAR := 'D' ;	{ Escape character for EXACT jump }  / Default_Scm ,				{ Default SCM command number } 3 Scm_Count ,				{ Number of commands in 'U' option } 6 Scm_Selection , 			{ Command number selected for SCM }K Max_Sys_Group : INTEGER := 0 ;	{ Maximum UIC group with system privileges }   ! Oper_Class_Mask : UNSIGNED := 0 ;   N Mail_Error_Status : [VOLATILE] UNSIGNED := 0 ;	       { MAIL condition value }  G Acme_Agent_Name ,    { External authentication Persona extension name } N Orig_User ,                                             { Invoker's username }? New_User : [GLOBAL,VOLATILE] VARYING [Max_Username_Len] OF CHAR 5 			:= PAD ('',' ',Max_Username_Len) ; { Target user }   " Open_File_Name ,					{ File spec }@ Command : VARYING [255] OF CHAR := '' ; 		{ Input command line }  ! Orig_Uic ,						{ UIC of caller } F New_Uic : [GLOBAL,VOLATILE] UIC$TYPE := ZERO ;		{ UIC of target user }   Terminal ,						{ Audit this } Port ,							{ Audit this } $ Physical_Device ,					{ Audit this }D Def_Dev : [VOLATILE] VARYING [64] OF CHAR := '' ;	{ Default device }  4 Target_Attributes ,				{ Target process attributes }, Help_Library ,					{ Help Library filespec }, Help_Topic ,					{ Optional topic for help }3 Secure_Directory ,				{ Directory for secure logs } 3 User_Directory ,				{ Directory for insecure logs } - Session_Log ,					{ Filespec of session log }  Access_List ,					{ Filespec }8 Audit_Trail : VARYING [255] OF CHAR := '' ;	{ Filespec }  - Single_Cmd ,					{ Single Command for EXACT } / Dbgfile_Name ,					   { Debug output filename } L Def_Dir : [VOLATILE] VARYING [255] OF CHAR := '' ;     { Default directory }  B Notify_Maillist : VARYING [1022] OF CHAR := '' ;	{ Who to notify }   Valid_Scm_Numbers C : ARRAY [1..Max_Scm_Num] OF BOOLEAN := ZERO ;		{ Allowed SCM nums }   $ Vms_Arch ,						{ VMS architecture }% Vms_Version ,						{ Version of VMS } - Vms_Version_Num ,					{ Just the number bit } 9 Uic_Str : VARYING [15] OF CHAR := ZERO ;		{ String form }   ( Eq_Id_Str ,						{ UIC string handling }@ Id_Str	: VARYING [32] OF CHAR := ZERO ;		{ UIC string handling }  * Minor_Privs ,						{ Not major privs! :) }O Def_Priv ,                                              { Target's def  privs } O Auth_Priv : [UNSAFE,VOLATILE]  Privset := ZERO ;        { Target's auth privs }   1 Oper_Classes : PACKED SET OF Oper_Class := ZERO ;    Vmsauth_Flag ,# Extauth_Flag : [EXTERNAL] BOOLEAN ;    Caller_Flags ,N Target_Flags : [VOLATILE]  FLAGS$TYPE := ZERO ;         { Target's UAF flags }  7 Notify : Notify_Mask := ZERO ;			{ Notification flags } ? Bugger : [GLOBAL,VOLATILE] Debug_Mask := ZERO ; { Debug flags }   < Architecture : Architecture_Type := Alpha ;	{ Assume Alpha }  < Jib_User_Ptr : [VOLATILE] ^[VOLATILE] Username_Type := NIL ;  	 Jib_Ptr , 
 Jib_Uic_Ptr ,  Uic_Ptr : Unsigned_Ptr := NIL ;   / Pchan_Created , 				{ Has Pchan been created? } G Pseudo_Ft : [VOLATILE] BOOLEAN := FALSE ;	{ Is pseudo-terminal FTA0:? }   ( Pchan , 					{ Pseudo-terminal channel }& Rchan , 					{ Real terminal channel }5 Mchan : [VOLATILE] $UWORD := 0 ;		{ Mailbox channel }   D Pdev : VARYING [12] OF CHAR := '' ;		{ Pseudo-terminal device name }  O Pbuf_Range : ARRAY [1..2] OF UNSIGNED := ZERO ; { Quasi descriptor of I/O buf }   L Mbbuf : ARRAY [1..ACC$K_TERMLEN] OF $UBYTE := ZERO ;	{ Termination MBX buf }  O Piosb : [VOLATILE] Status_Block_Type := ZERO ;	{ IOSB for pseudo-terminal IOs }   G Buffer : [VOLATILE] Io_Buffer := ZERO ; 	{ Pseudo-terminal I/O buffer }   @ Rchars : Terminal_Chars := ZERO ;		{ Device chars of real term }  & Exit_Rst ,					{ Exit Handler status }" Pid ,						{ Current process PID }/ Master_Pid ,					{ Current process master PID } 0 Pseudo_Pid ,					{ Pseudo-terminal process PID }/ Job_Proc_Cnt_Now ,				{ Job subproc count now } 0 Job_Proc_Cnt ,					{ Initial job subproc count }- Proc_Cnt_Now ,					{ Proc subproc count now } E Proc_Cnt : [VOLATILE] UNSIGNED := 0 ;		{ Current proc subproc count }   P Proc_Cur_Priv ,                                       { Caller's current privs }P Proc_Perm_Priv ,                                      { Caller's default privs }P Proc_Auth_Priv : [UNSAFE,VOLATILE]  Privset := ZERO ; { Caller's auth'd  privs }  N Caller_Rights ,                                       { Caller's proc rights }N Target_Rights ,                                       { Target's proc rights }? System_Rights : Rights_Array := ZERO ;		      { System rights }   1 Time_Now : TIMESTAMP ;				      { Real time now }   M Login_Time : $UQUAD := ZERO ;                         { Caller's login time }   M Login_Time_Str : VARYING [23] OF CHAR := '' ;         { Caller's login time }   O Process_Name : VARYING [16] OF CHAR := '' ;           { Caller's process name }   E Null_List : Item_List_Template(1) := ZERO ;	      { Empty item list }   ? Open_File_Fab : FAB$TYPE := ZERO ;		{ So we can see file info }   # Dbgfile ,					{ Debug output file } A Logfile : [GLOBAL,VOLATILE] TEXT ;		{ Logfile for EXACT session }   D { The values "Jump__*" are condition codes used exclusively by JUMP.<   Details can be found in the Message file (JUMP_MSG.MSG). }   Jump__Abortx9 ,  Jump__Badaccfil ,  Jump__Badaudit , Jump__Baddata ,  Jump__Baddbgfil ,  Jump__Badinclude , Jump__Badlogfil ,  Jump__Badnotify ,  Jump__Badoperclass , Jump__Badprivset , Jump__Baduser ,  Jump__Conflict , Jump__Default ,  Jump__Denied , Jump__Devnotprd ,  Jump__Disabled , Jump__Fixnotify ,  Jump__Forcepss , Jump__Intabort1 ,  Jump__Invescchar , Jump__Invlnm , Jump__Invuser ,  Jump__Ivident ,  Jump__Jumped , Jump__Mailfail , Jump__Modules ,  Jump__Nochain ,  Jump__Noescape , Jump__Noinsub ,  Jump__Nolnmforscm ,  Jump__Noovrsnglcmd , Jump__Nopriv , Jump__Nopseudo , Jump__Nospawn , 
 Jump__Nosub ,  Jump__Notusepss ,  Jump__Restrict , Jump__Return , Jump__Sameuic ,  Jump__Sameuser , Jump__Scmcmddef ,  Jump__Scmnotsel ,  Jump__Scmreqcmd ,  Jump__Selnotreq ,  Jump__Setuser ,  Jump__Transfer , Jump__Unkscmnum ,  Jump__Unsupported ,  Jump__Userabort , + Jump__Version : [EXTERNAL,VALUE] UNSIGNED ;   A { Some system and compiler-related values not found in STARLET. }    CCB$L_UCB ,  CCB$L_CHAN , CCB$K_LENGTH , UCB$L_TL_PHYUCB ,  UCB$W_TT_PRTCTL ,  UCB$L_TT_ACCPORNAM , JIB$T_USERNAME , PAS$K_SUCCESS , - PAS$K_FILNOTFOU : [EXTERNAL,VALUE] UNSIGNED ;   ' Iss__C_Arb_Full ,		{ = ISS$C_ARB_FULL } + Syi___Arb_Support ,		{ = SYI$_ARB_SUPPORT }  CTL$GL_PCB , CTL$GL_CCBBASE ,( CTL$GA_CCB_TABLE : [EXTERNAL] UNSIGNED ;  4 CTL$T_USERNAME : [EXTERNAL,VOLATILE] Username_Type ;    ? PROCEDURE Check_Extauth_Flags (Flags : FLAGS$TYPE) ; EXTERNAL ;     H PROCEDURE  Set_Default_Dir (Def_Dir : VARYING [Len] OF CHAR); EXTERNAL ;    ? FUNCTION Condition_Code (Pascal_Status : UNSIGNED) : UNSIGNED ;   0 { Convert a Pascal status to a condition code. }     BEGIN 	{ Condition_Code } 3   Condition_Code := 16#218644 + Pascal_Status * 8 ;    END ; 	{ Condition_Code }     6 [GLOBAL,ASYNCHRONOUS] PROCEDURE Zip (Rst1 : UNSIGNED ;) 				     Rst2 : UNSIGNED := SS$_NORMAL) ;   F   { Just a shorthand for signalling return statuses. The second returnE     status is optional. Normally, the second value will be IOSB[1]. }      BEGIN 	{ Zip }   IF NOT ODD (Rst1)  THEN       LIB$SIGNAL (Rst1)    ELSE    IF NOT ODD (Rst2)  THEN       LIB$SIGNAL (Rst2) ;   END ; 	{ Zip }    0 FUNCTION Special_File_Open (VAR Fab : FAB$TYPE ; 			    VAR Rab : RAB$TYPE ; # 			    VAR Log : TEXT) : UNSIGNED ;   L   { Special file open. Hijack the NAM block to determine the actual filespecK     of the file. If high security, use executive mode logical names only. }      VAR Rst : UNSIGNED := 0 ;        Nam : ^NAM$TYPE := ZERO ;      BEGIN 	{ Special_File_Open }:   IF High_Security OR Secure_Mode OR Secure_User_Dir  THENF      Fab.FAB$V_LNM_MODE := PSL$C_EXEC ;       { Executive mode only! }  6   High_Security := FALSE ;		      { Reset to default }=   Open_File_Fab := ZERO ;		      { In case the action fails }   !   Nam := Fab.FAB$L_NAM::Pointer ;      IF Open_New_File  THEN
      BEGIN9      Open_New_File := FALSE ;		      { Reset to default }       Rst := $CREATE (Fab) ;       END    ELSE       Rst := $OPEN (Fab) ;      IF ODD (Rst)	THEN 
      BEGIN      Open_File_Fab := Fab ; N      STR$COPY_R (%DESCR Open_File_Name,Nam^.NAM$B_RSL,%IMMED Nam^.NAM$L_RSA) ;      Rst := $CONNECT (Rab)
      END ;     Special_File_Open := Rst ;!   END ; 	{ of Special_File_Open }      FUNCTION Get_Logical_Name ( < 		Lognam	: [CLASS_S] PACKED ARRAY [L1..U1:INTEGER] OF CHAR ;# 		Default : VARYING [Sz1] OF CHAR ; & 		VAR Actual : VARYING [Sz2] OF CHAR ;< 		Table	: [CLASS_S] PACKED ARRAY [L2..U2:INTEGER] OF CHAR := 				'LNM$SYSTEM' ; 		Mode	: $UBYTE := PSL$C_EXEC ;  		Lnm_Index  : UNSIGNED := 0 		) : UNSIGNED ;  K { Get the translation of the logical name specified.  If it does not exist, M   use the default value if the index is zero, or flag a non-existant index. }      VAR Rst : UNSIGNED := 0 ; %       Attributes : LNM$TYPE := ZERO ; *       Actual_Mode : $UBYTE := PSL$C_USER ;1       Actual_Table : VARYING [32] OF CHAR := '' ; 3       Item_List  : Item_List_Template (6) := ZERO ;   "   BEGIN       { Get_Logical_Name }#   Item_List[1].Buffer_Length := 4 ; ,   Item_List[1].Item_Code     := LNM$_INDEX ;6   Item_List[1].Buffer_Addr   := IADDRESS (Lnm_Index) ;#   Item_List[1].Return_Addr   := 0 ;   3   Item_List[2].Buffer_Length := SIZE (Attributes) ; 1   Item_List[2].Item_Code     := LNM$_ATTRIBUTES ; 7   Item_List[2].Buffer_Addr   := IADDRESS (Attributes) ; #   Item_List[2].Return_Addr   := 0 ;   :   Item_List[3].Buffer_Length := SIZE (Actual_Table.BODY) ;,   Item_List[3].Item_Code     := LNM$_TABLE ;>   Item_List[3].Buffer_Addr   := IADDRESS (Actual_Table.BODY) ;@   Item_List[3].Return_Addr   := IADDRESS (Actual_Table.LENGTH) ;  #   Item_List[4].Buffer_Length := 1 ; -   Item_List[4].Item_Code     := LNM$_ACMODE ; 8   Item_List[4].Buffer_Addr   := IADDRESS (Actual_Mode) ;#   Item_List[4].Return_Addr   := 0 ;   4   Item_List[5].Buffer_Length := SIZE (Actual.BODY) ;-   Item_List[5].Item_Code     := LNM$_STRING ; 8   Item_List[5].Buffer_Addr   := IADDRESS (Actual.BODY) ;:   Item_List[5].Return_Addr   := IADDRESS (Actual.LENGTH) ;  A   Item_List[6].Terminator    := 0 ;   { Terminate the item list }   1   Rst := $TRNLNM (Attr	 := %REF LNM$M_CASE_BLIND,  		  Tabnam := Table, 		  Lognam := Lognam,  		  Acmode := %REF Mode, 		  Itmlst := Item_List) ;   Get_Logical_Name := Rst ;      Secure_Logical := FALSE ;      IF Rst = SS$_NOLOGNAM  THEN       Actual := Default    ELSE    IF Rst = SS$_NORMAL  THEN 
      BEGIN)      IF NOT Attributes.LNM$V_EXISTS  THEN I 	Get_Logical_Name := SS$_VALNOTVALID ;  { Index not found - tell caller } J      IF (Actual_Mode = PSL$C_EXEC) AND (Actual_Table = 'LNM$SYSTEM')  THEN 	Secure_Logical := TRUE ;       END    ELSE H   IF Rst = SS$_BUFFEROVF  THEN		     { Do nothing - caller must handle }    ELSE 
   Zip (Rst) ; %   END ;       { of Get_Logical_Name }      PROCEDURE Define_Logical_Name ( < 		Lognam : [CLASS_S] PACKED ARRAY [L1..U1:INTEGER] OF CHAR ;< 		Xlate  : [CLASS_S] PACKED ARRAY [L2..U2:INTEGER] OF CHAR ;= 		Table  : [CLASS_S] PACKED ARRAY [L3..U3:INTEGER] OF CHAR :=  				'LNM$SYSTEM' ;" 		Mode   : $UBYTE := PSL$C_EXEC) ;  K { Define the logical name specified.  BEWARE!  SYSNAM privilege is REQUIRED #   for supervisor mode or greater. }      VAR Rst : UNSIGNED := 0 ; 2       Item_List : Item_List_Template (2) := ZERO ;  %   BEGIN       { Define_Logical_Name } $   Item_List[1].Buffer_Length := U2 ;-   Item_List[1].Item_Code     := LNM$_STRING ; 2   Item_List[1].Buffer_Addr   := IADDRESS (Xlate) ;#   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Terminator    := 0 ;   "   Rst := $CRELNM (Tabnam := Table, 		  Lognam := Lognam,  		  Acmode := Mode,  		  Itmlst := Item_List) ;
   Zip (Rst) ; (   END ;       { of Define_Logical_Name }    2 FUNCTION Oprmsg (Message : VARYING [Len] OF CHAR ;? 		 Oper_Class_Mask : UNSIGNED := 16#00FFFFFF ;	{ 24 bits only } ( 		 Reply : BOOLEAN := FALSE) : BOOLEAN ;  I { Send an operator message (REQUEST).  Limit size to maximum (128 chars). D   If required, wait for a REPLY and flag if an ABORT was received. }     VAR	Rst : UNSIGNED := 0 ;  	Mbx_Chan : $UWORD := 0 ; + 	Msg_Text : VARYING [128] OF CHAR := ZERO ;  	Opr_Reply : OPC$TYPE := ZERO ; # 	Iosb : Status_Block_Type := ZERO ;  	Msg_Dsc : DSC1$TYPE := ZERO ; 	Msg : PACKED RECORD 		Msg_Type : $UBYTE ; # 		Msg_Targ : [BYTE(3)] 0..2**24-1 ;  		Msg_Rqst : UNSIGNED ; ( 		Mess : PACKED ARRAY [1..128] OF CHAR ; 	      END := ZERO ;     BEGIN 	{ Oprmsg } !   Oprmsg := TRUE ;				{ Default }      IF Message.LENGTH > 128  THEN =      Msg_Text := SUBSTR (Message.BODY,1,128)	{ Max msg size }     ELSE       Msg_Text := Message ;    Msg.Msg_Type := OPC$_RQ_RQST ;#   Msg.Msg_Targ := Oper_Class_Mask ;    Msg.Msg_Rqst := 0 ; !   Msg.Mess     := Msg_Text.BODY ; 2   Msg_Dsc.DSC$W_MAXSTRLEN := 8 + Msg_Text.LENGTH ;J   Msg_Dsc.DSC$B_DTYPE	  := DSC$K_DTYPE_T ;	{ Not essential ... but neat! }-   Msg_Dsc.DSC$A_POINTER   := IADDRESS (Msg) ; *   Msg_Dsc.DSC$B_CLASS	  := DSC$K_CLASS_S ;     IF Reply  THEN
      BEGIN<      Rst := $CREMBX (Chan := Mbx_Chan) ;		{ Create mailbox }      Zip (Rst) ;
      END ;  F   Rst := $SNDOPR (%REF Msg_Dsc,%IMMED Mbx_Chan) ;	{ Send to Operator }
   Zip (Rst) ;      IF Reply  THEN
      BEGIN<      Rst := $QIOW (Chan := Mbx_Chan,			{ Read from mailbox } 		   Func := IO$_READVBLK, 		   P1	:= Opr_Reply,  		   P2	:= SIZE (Opr_Reply), 		   Iosb := Iosb) ;      Zip (Rst,Iosb[1]) ;  A      Rst := Opr_Reply.OPC$W_MS_STATUS + 65536 * OPCOM$_FACILITY ; "      IF Rst = OPC$_RQSTABORT  THEN 	Oprmsg := FALSE
       ELSE      Zip (Rst) ;  5      Rst := $DASSGN (Mbx_Chan) ;			{ Delete mailbox }       Zip (Rst) ;
      END ;   END ; 	{ of Oprmsg }    - [GLOBAL,ASYNCHRONOUS] FUNCTION	Str_Compress ( ; 			Source : [CLASS_S] PACKED ARRAY [L..U:INTEGER] OF CHAR ; $ 			VAR  Dest : VARYING [D] OF CHAR ;, 			Collapse : BOOLEAN := FALSE) : UNSIGNED ;  L { Compress a string by removing leading and trailing white space (blanks andL   tabs), and replacing multiple consecutive white space with a single blank./   If collapse is set, remove ALL white space. }   %   CONST  Blanks = [' ',''(9),''(0)] ;  	 Maxsize = 1024 ;F 	 Warn_Inpstrtru = UAND (LIB$_INPSTRTRU,%Xfffffff8) ;	{ Warning only }  !   VAR  S , J , K : INTEGER := 0 ;          Done : BOOLEAN := FALSE ;,        Spacer : VARYING [1] OF CHAR := ' ' ;5        Dstr, Sstr : VARYING [Maxsize] OF CHAR := '' ;      BEGIN 	{ Str_Compress } .   Str_Compress := SS$_NORMAL ;		{ Presume so }   S := LENGTH (Source) ;  %   IF S = 0  THEN			{ Nothing passed }       Dest := ''     ELSE 
      BEGIN      IF S > Maxsize  THEN  	BEGIN$ 	Sstr := SUBSTR (Source,1,Maxsize) ;& 	Str_Compress := INT(Warn_Inpstrtru) ; 	END
       ELSE 	Sstr := Source ;   %      IF Collapse  THEN	Spacer := '' ;   D      IF FIND_MEMBER (Source,Blanks) = 0  THEN		{ Nothing to change }
 	Dstr := Sstr 
       ELSE 	WHILE NOT Done	DO 	  BEGIN& 	  J := FIND_NONMEMBER (Sstr,Blanks) ; 	  IF J = 0  THEN  	     Done := TRUE 	   ELSE 	     BEGIN / 	     Sstr := SUBSTR (Sstr,J,Sstr.LENGTH-J+1) ; & 	     K := FIND_MEMBER (Sstr,Blanks) ; 	     IF K = 0  THEN 		BEGIN  		Dstr := Dstr + Sstr ;  		Done := TRUE ; 		END  	      ELSE  		BEGIN / 		Dstr := Dstr + SUBSTR (Sstr,1,K-1) + Spacer ; + 		Sstr := SUBSTR (Sstr,K,Sstr.LENGTH-K+1) ;  		END ;  	     END ;  	  END ; 	{ of While }        IF Dstr <> ''  THEN! 	IF Dstr[Dstr.LENGTH] = ' '  THEN * 	   Dstr:= SUBSTR (Dstr,1,Dstr.LENGTH-1) ;        IF Dstr.LENGTH <= D  THEN
 	Dest := Dstr 
       ELSE 	BEGIN 	Dest := SUBSTR (Dstr,1,D) ;! 	Str_Compress := LIB$_OUTSTRTRU ;  	END ;
      END ;   END ; 	{ of Str_Compress }     PROCEDURE Give_Help ;   - { M'aidez!  Allow a subtopic specification. }      VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Give_Help }B   Rst := LBR$OUTPUT_HELP (Output_Routine := %IMMED LIB$PUT_OUTPUT,( 			  Line_Desc	 := 'JUMP ' + Help_Topic,# 			  Library_Name	 := Help_Library, . 			  Input_Routine  := %IMMED LIB$GET_INPUT) ;
   Zip (Rst) ;    END ; 	{ Give_Help }    L [GLOBAL,ASYNCHRONOUS] FUNCTION Str_Privs (Privs : Privset) : Just_A_String ;  C { Create a string representing the privileges in a privilege set. }      VAR	P : Privilege ; " 	T1 , T2 : Just_A_String := ZERO ;     BEGIN 	{ Str_Privs }    FOR P := Cmkrnl TO Security DO       IF P IN Privs  THEN  	 BEGIN  	 WRITEV (T1,P) ;  	 Str_Compress (T1,T1) ;$ 	 T2 := T2 + ' ' + SUBSTR (T1,1,4) ; 	 END ;    Str_Privs := T2 ;    END ; 	{ Str_Privs }    ( PROCEDURE Format_User (Uic : UIC$TYPE) ;  B { Create a string with the UIC in numeric and identifier formats }     VAR  Rst : INTEGER := 0 ;      BEGIN 	{ Format_User }G   Rst := $FAO ('!%U',Uic_Str.LENGTH,%STDESCR Uic_Str.BODY,%IMMED Uic) ; 
   Zip (Rst) ; E   Rst := $FAO ('!%I',Id_Str.LENGTH,%STDESCR Id_Str.BODY,%IMMED Uic) ; 
   Zip (Rst) ;    IF Uic_Str = Id_Str  THEN       Eq_Id_Str := ''    ELSE "      Eq_Id_Str := ' = ' + Id_Str ;   END ; 	{ of Format_User }*     PROCEDURE Get_System_Info ;U  : { Get relevant information about the system environment. }     VAR	Rst ,y 	Arb_Support : INTEGER := 0 ; # 	Iosb : Status_Block_Type := ZERO ;r- 	Item_List : Item_List_Template (6) := ZERO ;e     BEGIN 	{ Get_System_Info }#   Item_List[1].Buffer_Length := 4 ;f2   Item_List[1].Item_Code     := SYI$_MAXSYSGROUP ;:   Item_List[1].Buffer_Addr   := IADDRESS (Max_Sys_Group) ;#   Item_List[1].Return_Addr   := 0 ;n  6   Item_List[2].Buffer_Length := SIZE (System_Rights) ;4   Item_List[2].Item_Code     := SYI$_SYSTEM_RIGHTS ;:   Item_List[2].Buffer_Addr   := IADDRESS (System_Rights) ;#   Item_List[2].Return_Addr   := 0 ;a  $   Item_List[3].Buffer_Length := 15 ;0   Item_List[3].Item_Code     := SYI$_ARCH_NAME ;:   Item_List[3].Buffer_Addr   := IADDRESS (Vms_Arch.BODY) ;<   Item_List[3].Return_Addr   := IADDRESS (Vms_Arch.LENGTH) ;  #   Item_List[4].Buffer_Length := 8 ;:.   Item_List[4].Item_Code     := SYI$_VERSION ;=   Item_List[4].Buffer_Addr   := IADDRESS (Vms_Version.BODY) ;p?   Item_List[4].Return_Addr   := IADDRESS (Vms_Version.LENGTH) ;	  #   Item_List[5].Buffer_Length := 4 ;t3   Item_List[5].Item_Code     := Syi___Arb_Support ; 8   Item_List[5].Buffer_Addr   := IADDRESS (Arb_Support) ;#   Item_List[5].Return_Addr   := 0 ;l  A   Item_List[6].Terminator    := 0 ;   { Terminate the item list }-  '   Rst := $GETSYIW (Itmlst := Item_List,- 		   Iosb   := Iosb) ;   Zip (Rst,Iosb[1]) ;h  5   Arb_Full_Support := Arb_Support = Iss__C_Arb_Full ;	  0   Rst := STR$UPCASE (%DESCR Vms_Arch,Vms_Arch) ;
   Zip (Rst) ;c     IF (Vms_Arch <> 'VAX') AND      (Vms_Arch <> 'ALPHA') AND      (Vms_Arch <> 'IA64') THEN@        $EXIT (Jump__Unsupported) ;	{ Should never be the case! }     IF Vms_Arch = 'VAX'  THENr      Architecture := Vax    ELSE	   IF Vms_Arch = 'IA64'	THEN        Architecture := Integrity ;  F   Vms_Version_Num := SUBSTR (Vms_Version,INDEX(Vms_Version,'.')-1,3) ;  I   { The Persona Security Block (PSB) is implemented only on OpenVMS Alpha )     and OpenVMS IA64 from V7.2 onwards. }   I   Psb_Available := (Architecture <> Vax) AND (Vms_Version_Num >= '7.2') ;*   END ; 	{ of Get_System_Info }*     PROCEDURE Get_Caller_Info ;*  > { Get relevant information about the invoker of the program. }     VAR	Rst : INTEGER := 0 ;# 	Iosb : Status_Block_Type := ZERO ;T. 	Item_List : Item_List_Template (16) := ZERO ;     BEGIN 	{ Get_Caller_Info }#   Item_List[1].Buffer_Length := 8 ;	/   Item_List[1].Item_Code     := JPI$_PROCPRIV ;N;   Item_List[1].Buffer_Addr   := IADDRESS (Proc_Perm_Priv) ;n#   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Buffer_Length := 8 ;*/   Item_List[2].Item_Code     := JPI$_AUTHPRIV ;*;   Item_List[2].Buffer_Addr   := IADDRESS (Proc_Auth_Priv) ;*#   Item_List[2].Return_Addr   := 0 ;	  #   Item_List[3].Buffer_Length := 8 ;N.   Item_List[3].Item_Code     := JPI$_CURPRIV ;:   Item_List[3].Buffer_Addr   := IADDRESS (Proc_Cur_Priv) ;#   Item_List[3].Return_Addr   := 0 ;L  #   Item_List[4].Buffer_Length := 4 ;L*   Item_List[4].Item_Code     := JPI$_UIC ;?   Item_List[4].Buffer_Addr   := IADDRESS (Orig_Uic.UIC$L_UIC) ;R#   Item_List[4].Return_Addr   := 0 ;I  2   Item_List[5].Buffer_Length := SIZE (Orig_User) ;/   Item_List[5].Item_Code     := JPI$_USERNAME ; ;   Item_List[5].Buffer_Addr   := IADDRESS (Orig_User.BODY) ;L=   Item_List[5].Return_Addr   := IADDRESS (Orig_User.LENGTH) ;(  #   Item_List[6].Buffer_Length := 4 ;F*   Item_List[6].Item_Code     := JPI$_PID ;0   Item_List[6].Buffer_Addr   := IADDRESS (Pid) ;#   Item_List[6].Return_Addr   := 0 ;d  #   Item_List[7].Buffer_Length := 4 ;=1   Item_List[7].Item_Code     := JPI$_MASTER_PID ; 7   Item_List[7].Buffer_Addr   := IADDRESS (Master_Pid) ;=#   Item_List[7].Return_Addr   := 0 ;t  #   Item_List[8].Buffer_Length := 4 ;=-   Item_List[8].Item_Code     := JPI$_PRCCNT ;r5   Item_List[8].Buffer_Addr   := IADDRESS (Proc_Cnt) ;a#   Item_List[8].Return_Addr   := 0 ;   2   Item_List[9].Buffer_Length := SIZE (Port.BODY) ;3   Item_List[9].Item_Code     := JPI$_TT_ACCPORNAM ;i6   Item_List[9].Buffer_Addr   := IADDRESS (Port.BODY) ;8   Item_List[9].Return_Addr   := IADDRESS (Port.LENGTH) ;  7   Item_List[10].Buffer_Length := SIZE (Terminal.BODY) ;c0   Item_List[10].Item_Code     := JPI$_TERMINAL ;;   Item_List[10].Buffer_Addr   := IADDRESS (Terminal.BODY) ;i=   Item_List[10].Return_Addr   := IADDRESS (Terminal.LENGTH) ;   >   Item_List[11].Buffer_Length := SIZE (Physical_Device.BODY) ;4   Item_List[11].Item_Code     := JPI$_TT_PHYDEVNAM ;B   Item_List[11].Buffer_Addr   := IADDRESS (Physical_Device.BODY) ;D   Item_List[11].Return_Addr   := IADDRESS (Physical_Device.LENGTH) ;  7   Item_List[12].Buffer_Length := SIZE (Caller_Rights) ;iK   Item_List[12].Item_Code     := JPI$_RIGHTSLIST ;	    { Process + System }[;   Item_List[12].Buffer_Addr   := IADDRESS (Caller_Rights) ;S$   Item_List[12].Return_Addr   := 0 ;  $   Item_List[13].Buffer_Length := 8 ;0   Item_List[13].Item_Code     := JPI$_LOGINTIM ;8   Item_List[13].Buffer_Addr   := IADDRESS (Login_Time) ;$   Item_List[13].Return_Addr   := 0 ;  %   Item_List[14].Buffer_Length := 16 ;t.   Item_List[14].Item_Code     := JPI$_PRCNAM ;?   Item_List[14].Buffer_Addr   := IADDRESS (Process_Name.BODY) ;lA   Item_List[14].Return_Addr   := IADDRESS (Process_Name.LENGTH) ;a  $   Item_List[15].Buffer_Length := 4 ;1   Item_List[15].Item_Code     := JPI$_JOBPRCCNT ;s:   Item_List[15].Buffer_Addr   := IADDRESS (Job_Proc_Cnt) ;$   Item_List[15].Return_Addr   := 0 ;  @   Item_List[16].Terminator    := 0 ;	{ Terminate the item list }  '   Rst := $GETJPIW (Itmlst := Item_List,v 		   Iosb   := Iosb) ;   Zip (Rst,Iosb[1]) ;p  7   Rst := STR$TRIM (%DESCR Orig_User,%DESCR Orig_User) ;s
   Zip (Rst) ;   %   IF (Physical_Device <> '') AND_THEN}%      (Physical_Device[1] = '_')  THENlN       Physical_Device := SUBSTR (Physical_Device,2,Physical_Device.LENGTH-1) ;  F   IF NOT (Required_Privs <= Proc_Cur_Priv)  THEN	{ Got needed privs? }      $EXIT (Jump__Nopriv) ;   I   Rst := $ASCTIM (Login_Time_Str.LENGTH,Login_Time_Str.BODY,Login_Time) ;a
   Zip (Rst) ;m"   IF Login_Time_Str[1]	= ' '  THEN      Login_Time_Str[1] := '0' ;i     { Get the flags }   #   Item_List[1].Buffer_Length := 4 ; ,   Item_List[1].Item_Code     := UAI$_FLAGS ;9   Item_List[1].Buffer_Addr   := IADDRESS (Caller_Flags) ;g#   Item_List[1].Return_Addr   := 0 ;   ?   Item_List[2].Terminator    := 0 ;	{ Terminate the item list }a  K   Rst := $GETUAI (Usrnam := %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH),m 		  Itmlst := Item_List) ;
   Zip (Rst) ;s  8   Sysprog  := (Orig_Uic.UIC$V_GROUP <= Max_Sys_Group) OR$ 	      (Setprv IN Proc_Auth_Priv) OR# 	      (Setprv IN Proc_Perm_Priv) ;   )   Operator := (Oper IN Proc_Auth_Priv) ORe! 	      (Oper IN Proc_Perm_Priv) ;y     END ; 	{ of Get_Caller_Info }     % PROCEDURE Audit_Jump (Ok : BOOLEAN) ;c  H { Record who, when, where, how, etc. for auditing purposes. Any problems/   opening the audit file will terminate JUMP. }t     VAR	Rst : UNSIGNED := 0 ;f7 	Imprint : VARYING [240] OF CHAR := '' ; 	{ 3 lines!! }i 	Audit : TEXT ;i- 	Stamp : PACKED ARRAY [1..23] OF CHAR := '' ;r     BEGIN 	{ Audit_Jump }    High_Security := TRUE ;bE   OPEN (Audit,FILE_NAME:=Audit_Trail,HISTORY:=Old,SHARING:=READWRITE,b8 	      USER_ACTION:=Special_File_Open,Error:=CONTINUE) ;   Rst := STATUS (Audit) ;    IF Rst <> PAS$K_SUCCESS  THENb
      BEGIN"      LIB$SIGNAL (Jump__Badaudit) ;&      LIB$STOP (Condition_Code (Rst)) ;
      END ;     EXTEND (Audit) ;  -   Rst := $ASCTIM (Timbuf := %STDESCR Stamp) ; 
   Zip (Rst) ; ,   IF Stamp[1] = ' '  THEN  Stamp[1] := '0' ;4   Imprint := SUBSTR (Stamp,1,20) + ' ' + Orig_User ;
   IF Ok  THEN 
      BEGIN7      IF (New_User = Orig_User) AND NOT Real_Mccoy  THEN  	BEGIN  	Imprint := Imprint + ' from ' ; 	Format_User (Orig_Uic) ;  	END
       ELSE 	BEGIN  	Imprint := Imprint + '  to  ' ; 	Format_User (New_Uic) ; 	END ;  )      IF Alter_Ego AND NOT Transmute  THEN	 	Imprint := Imprint + New_User
       ELSE+ 	Imprint := Imprint + Uic_Str + Eq_Id_Str ;{        IF Alter_Ego  THEN4$ 	Imprint := Imprint + ' *SETUSER*' ;  "      IF New_User = Orig_User  THEN8 	Format_User (New_Uic) ; 	{ Provide format for display }      END    ELSE 9      Imprint := Imprint + ' PRIV violation: ' + Command ;      IF Broken_Chain  THEN1)      Imprint := Imprint + ' *CHAINING*' ;      IF Real_Mccoy  THEND
      BEGIN      IF Secure_Mode  THENs 	BEGIN# 	Imprint := Imprint + ' *SECURE*' ;t8 	IF Suspect  THEN  Imprint := Imprint + ' ??SUSPECT??' ; 	END
       ELSE" 	Imprint := Imprint + ' *EXACT*' ;;      IF Pdev <> ''  THEN  Imprint := Imprint + ' ' + Pdev ; 
      END ;  8   IF Port <> ''  THEN  Imprint := Imprint + ' ' + Port ;@   IF Terminal <> ''  THEN  Imprint := Imprint + ' ' + Terminal ;N   IF Physical_Device <> ''  THEN  Imprint := Imprint + ' ' + Physical_Device ;     WRITELN (Audit,Imprint) ;n   CLOSE (Audit) ;[     IF Bugger.Info  THEN5      WRITELN (Dbgfile,'*** Audit record: ',Imprint) ;e   END ; 	{ of Audit_Jump }    ! PROCEDURE Get_And_Parse_Command ;   E { Get and parse the DCL command line.  Do some basic username checks.a$   Evaluate all JUMP logical names. }  "   VAR	Rst , Spot : UNSIGNED := 0 ; 	Bool : BOOLEAN := FALSE ; 	Prv : Privilege := Tmpmbx ; 	Jump_Attributes ,$ 	Str : VARYING [255] OF CHAR := '' ;" 	Opclass : Oper_Class := Central ;! 	Device_Info : DEV$TYPE := ZERO ;./ 	Jump_Cld : [EXTERNAL] INTEGER ; { CLD module }:  A   PROCEDURE Check_Boolean (Boolean_Name : VARYING [Len] OF CHAR ;e" 			   VAR Boolean_Bit : BOOLEAN) ;       BEGIN	{ Check_Boolean } '     Rst := CLI$PRESENT (Boolean_Name) ; ;     IF (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED)  THENO        Boolean_Bit := TRUE	      ELSEO     IF Rst = CLI$_NEGATED  THENr        Boolean_Bit := FALSE ;T     END ;	{ Check_Boolean }]  "   BEGIN 	{ Get_And_Parse_Command }E   Rst := LIB$GET_FOREIGN (%DESCR Command) ;		{ Get the command line }$
   Zip (Rst) ;       Command := 'JUMP ' + Command ;C   Rst := CLI$DCL_PARSE (Command,%REF Jump_Cld,%IMMED LIB$GET_INPUT, # 			%IMMED LIB$GET_INPUT,'JUMP> ') ;PM   IF (Rst = RMS$_EOF) OR (Rst = CLI$_NOCOMD) OR (NOT ODD (Rst)) THEN  $EXIT ;K  B   Jump_Version := Jump_Version + ' on OpenVMS ' + Vms_Arch + ' ' + 		  Vms_Version ;D,   Str_Compress (Jump_Version,Jump_Version) ;  C   { If the version is requested, ignore everything else and exit. }   1   IF CLI$PRESENT ('VERSION') = CLI$_PRESENT  THENT
      BEGIN!      LIB$SIGNAL (Jump__Version,1, > 		 %STDESCR SUBSTR(Jump_Version.BODY,1,Jump_Version.LENGTH)) ;  E      Jump_Version := 'Module build levels: Mn ' + Main_Bl + ', Fd ' + 2 		     Fiddler_Bl + ', Pk ' + Poker_Bl + ', Ps ' +& 		     Persona_Bl + ', Vx ' + Vax_Bl ;!      LIB$SIGNAL (Jump__Modules,1,(> 		 %STDESCR SUBSTR(Jump_Version.BODY,1,Jump_Version.LENGTH)) ;  C      IF NOT Production_Version	THEN  LIB$SIGNAL (Jump__Devnotprd) ;       $EXIT ;
      END ;  G   { If Help is requested, ignore everything else, give help, then exit.e)     Help is only available to Sysprogs! }   .   IF CLI$PRESENT ('HELP') = CLI$_PRESENT  THEN      IF NOT Sysprog  THEN: 	LIB$SIGNAL (Jump__Nopriv)
       ELSE 	BEGINI 	Rst := CLI$GET_VALUE ('TOPIC',%DESCR Help_Topic) ;    { Might be there }  	IF Rst = CLI$_PRESENT  THEN( 	   Str_Compress (Help_Topic,Help_Topic) 	 ELSE& 	IF Rst = CLI$_ABSENT  THEN	{ Ignore } 	 ELSE 	   Zip (Rst) ;T  - 	Get_Logical_Name (Lognam  := 'JUMP_HELPLIB', ; 			  Default := 'SYS_HELP:PUBHELP.HLB',   { SITE-specific }	 			  Actual  := Help_Library) ;N 	Give_Help ; 	$EXIT ; 	END ;  N   Rst := CLI$GET_VALUE ('USERNAME',%DESCR New_User) ;	{ Assume will be there }   IF Rst = CLI$_ABSENT	THENt=      New_User := Orig_User			 { Default to current username }t    ELSE    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)n    ELSEi
      BEGIN8      Rst := STR$TRIM (%DESCR New_User,%DESCR New_User) ;      Zip (Rst) ;
      END ;  /   IF FIND_NONMEMBER (New_User,Symbol) <> 0 THENT      $EXIT (Jump__Baduser) ;      Rst := CLI$PRESENT ('EXACT') ;@   Real_Mccoy := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;     IF Real_Mccoy THEN
      BEGIN5      Get_Logical_Name (Lognam  := 'JUMP_SECURE_MODE',e6 		       Default := 'FALSE',		       { SITE-specific } 		       Actual  := Str) ;      Str_Compress (Str,Str) ;;)      Rst := STR$UPCASE (%DESCR Str,Str) ;       Zip (Rst) ;C      System_Secure_Mode := Str = 'TRUE' ;	{ Mandatory Secure_Mode }}  C      Rst := CLI$PRESENT ('SECURE_MODE') ;	{ Requested Secure_Mode } D      Secure_Mode := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;$      Suspect := Rst = CLI$_NEGATED ;  4      Get_Logical_Name (Lognam  := 'JUMP_SECURE_DIR',< 		       Default := 'SYS_MANAGER:',	       { SITE-specific }' 		       Actual  := Secure_Directory) ;l  9      Rst := Get_Logical_Name (Lognam  := 'JUMP_USER_DIR',{: 			      Default := 'SYS$LOGIN:',	       { SITE-specific }% 			      Actual  := User_Directory) ;	  I      { If the System Manager has not explicitly defined the JUMP_USER_DIR I        logical name, allow the user to do so. In this way, EXECUTIVE mode*L        definitions will always override definitions in outer access modes. }         IF Rst = SS$_NOLOGNAM  THEN 	BEGIN5 	Rst := Get_Logical_Name (Lognam  := 'JUMP_USER_DIR',*4 				 Default := 'SYS$LOGIN:',      { SITE-specific } 				 Actual  := User_Directory,* 				 Table	 := 'LNM$FILE_DEV', 				 Mode	 := PSL$C_USER) ;  	IF Rst = SS$_NORMAL  THEN 	   Secure_User_Dir := FALSE ; 	END ;  9      Get_Logical_Name (Lognam  := 'JUMP_ACME_AGENT_NAME',*3 		       Default := 'VMS',	       { SITE-specific }  		       Actual  := Str) ;      Str_Compress (Str,Str) ;o)      Rst := STR$UPCASE (%DESCR Str,Str) ;       Zip (Rst) ;      Acme_Agent_Name := Str ;g  $      Rst := CLI$PRESENT ('RECORD') ;G      Record_Session := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;U1      Suspect := Suspect OR (Rst = CLI$_NEGATED) ;M  8      IF Secure_Mode  THEN			{ Requested - set defaults } 	BEGIN7 	Notify.All_Bits := 16#Ffffffff ;	{ Full notification }s2 	Record_Session	:= TRUE ;		{ Required, obviously } 	END ;  E      { System_Secure_Mode is handled in Validate_Access.  For now, if E        Secure_Mode is requested, allow other qualifiers to modify thee        notification profile. }  $      Rst := CLI$PRESENT ('NOTIFY') ;F      IF Rst = CLI$_PRESENT THEN 	{ Present if not explicitly negated } 	BEGIN' 	Rst := CLI$PRESENT ('NOTIFY.BEFORE') ; ) 	Notify.Before := (Rst = CLI$_PRESENT) ORe 			 (Rst = CLI$_DEFAULTED) ORc0 			 (Secure_Mode AND NOT (Rst = CLI$_NEGATED)) ;  & 	Rst := CLI$PRESENT ('NOTIFY.AFTER') ;( 	Notify.After := (Rst = CLI$_PRESENT) OR 			(Rst = CLI$_DEFAULTED) OR/ 			(Secure_Mode AND NOT (Rst = CLI$_NEGATED)) ;e  & 	Rst := CLI$PRESENT ('NOTIFY.OPCOM') ;+ 	Notify.By_Opcom := (Rst = CLI$_PRESENT) OR  			   (Rst = CLI$_DEFAULTED) ORr2 			   (Secure_Mode AND NOT (Rst = CLI$_NEGATED)) ;  % 	Rst := CLI$PRESENT ('NOTIFY.MAIL') ; * 	Notify.By_Mail := (Rst = CLI$_PRESENT) OR 			  (Rst = CLI$_DEFAULTED) OR1 			  (Secure_Mode AND NOT (Rst = CLI$_NEGATED)) ;i  ( 	Rst := CLI$PRESENT ('NOTIFY.INCLUDE') ;) 	Notify.Include_Log := Record_Session ANDe 			      Notify.By_Mail ANDr! 			      ((Rst = CLI$_PRESENT) ORt# 			       (Rst = CLI$_DEFAULTED) OR 7 			       (Secure_Mode AND NOT (Rst = CLI$_NEGATED))) ;n  3 	Rst := CLI$PRESENT ('NOTIFY.EXIT_ON_MAIL_ERROR') ;u* 	Notify.Vamoose := (Rst = CLI$_PRESENT) OR 			  (Rst = CLI$_DEFAULTED) OR' 			  (Secure_Mode AND Notify.By_Mail) ;k  7 	IF Notify.All_Bits = 0	THEN		{ Default to everything }V	 	   BEGINA$ 	   Notify.All_Bits := 16#Ffffffff ;* 	   Notify.Include_Log := Record_Session ;	 	   END ;e 	END
       ELSE"      IF Rst = CLI$_DEFAULTED  THEN 	BEGINC 	Notify.All_Bits    := 16#Ffffffff ;	{ Full notification, almost? } ' 	Notify.Include_Log := Record_Session ;y 	END ;  .      Rst := CLI$PRESENT ('ESCAPE_CHARACTER') ;A      IF Rst = CLI$_PRESENT THEN 		{ Turn into Control character }i 	BEGIN7 	Rst := CLI$GET_VALUE ('ESCAPE_CHARACTER',%DESCR Str) ;r 	IF Rst = CLI$_ABSENT  THENU5 	   Ripcord := CHR (ORD(Ripcord)-64)		{ Use default }o 	 ELSE 	IF NOT ODD (Rst)  THENB 	   LIB$SIGNAL (Rst) 	 ELSE	 	   BEGINF( 	   Rst := STR$UPCASE (%DESCR Str,Str) ; 	   Zip (Rst) ; @ 	   IF (Str.LENGTH <> 1) OR_ELSE NOT (Str[1] IN Esc_Chars)  THEN$ 	      LIB$SIGNAL (Jump__Invescchar)	 	    ELSEU( 	      Ripcord := CHR (ORD(Str[1])-64) ;	 	   END ;I 	Escape_Hatch := TRUE ;  	END ;  %      Rst := CLI$PRESENT ('COMMAND') ;h      IF Rst = CLI$_PRESENT THEN  	BEGIN. 	Rst := CLI$GET_VALUE ('COMMAND',%DESCR Str) ; 	IF NOT ODD (Rst)  THEN  	   LIB$SIGNAL (Rst) 	 ELSE	 	   BEGINi 	   Single_Cmd_Mode := TRUE ;r 	   Str_Compress (Str,Str) ; 	   IF Str[1] = '"'  THENe 	      BEGIN+ 	      Str := SUBSTR (Str,2,Str.LENGTH-1) ;y$ 	      IF Str[Str.LENGTH] = '"'	THEN' 		 Str := SUBSTR (Str,1,Str.LENGTH-1) ;u 	      Str_Compress (Str,Str) ;i 	      END ; 	   IF Str[1] = '$'  THEN	+ 	      Str := SUBSTR (Str,2,Str.LENGTH-1) ;F 	   Str_Compress (Str,Str) ; 	   Single_Cmd := Str ; 	 	   END ;  	END ;  $      Rst := CLI$PRESENT ('SELECT') ;      IF Rst = CLI$_PRESENT THENV 	BEGIN- 	Rst := CLI$GET_VALUE ('SELECT',%DESCR Str) ;  	IF NOT ODD (Rst)  THENN 	   LIB$SIGNAL (Rst) 	 ELSE 	   READV (Str,Scm_Selection) ;  	END ;      END ;	{ of IF Real_Mccoy }Z  6   Get_Logical_Name (Lognam  := 'JUMP_NOTIFY_MAILLIST',4 		    Default := 'SYSTEM',		       { SITE-specific }# 		    Actual  := Notify_Maillist) ; 7   Str_Compress (Notify_Maillist,Notify_Maillist,TRUE) ;g  '   Check_Boolean ('SETUSER',Alter_Ego) ;a.   Transmute := NOT (Alter_Ego OR Real_Mccoy) ;     Rst := CLI$PRESENT ('ALL') ;L   Alter_Ego := Alter_Ego OR (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;  *   Check_Boolean ('OVERRIDE_UAF',Figment) ;*   Check_Boolean ('UPDATE_UAF',Stamp_Uaf) ;   Check_Boolean ('LOG',Log) ; $   Check_Boolean ('AUDIT',Auditing) ;  2   Get_Logical_Name (Lognam  := 'JUMP_AUDIT_TRAIL',B 		    Default := 'SYS_MANAGER:JUMP_AUDIT.DAT',   { SITE-specific } 		    Actual  := Audit_Trail) ;g  2   Get_Logical_Name (Lognam  := 'JUMP_ACCESS_LIST',B 		    Default := 'SYS_MANAGER:JUMP_ACCESS.DAT',  { SITE-specific } 		    Actual  := Access_List) ;u  3   Get_Logical_Name (Lognam  := 'JUMP_DOUBLE_CHECK',i3 		    Default := 'TRUE',			       { SITE-specific }N 		    Actual  := Str) ;i   Str_Compress (Str,Str) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;
   Zip (Rst) ;c    Double_Check := Str = 'TRUE' ;  O   { If the current process is a JUMP pseudo-terminal, check for any attributes.l%     Prevent chaining, if necessary. }l  P   Get_Logical_Name (Lognam  := 'JUMP_' + HEX (Pid,8,8),     { Process-specific }3 		    Default := 'NONE',			       { SITE-specific }}# 		    Actual  := Jump_Attributes) ;GJ   IF (INDEX (Jump_Attributes,'NOCHAIN ') > 0) AND	{ Chaining not allowed }P      (New_User <> Orig_User)  THEN             { ... and it's a real chain ... }        BEGIN        Broken_Chain := TRUE ;         IF Auditing  THEN 	  Audit_Jump (FALSE) ;{P        $EXIT (Jump__Nochain) ;                  { ... c'est bon soir ma chere! }        END ;  #   { Allow an EXACT JUMP to chain? }t  ,   Get_Logical_Name (Lognam  := 'JUMP_CHAIN',3 		    Default := 'TRUE',			       { SITE-specific }d 		    Actual  := Str) ;p   Str_Compress (Str,Str) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;
   Zip (Rst) ;{   Chain := Str = 'TRUE' ;}  +   Get_Logical_Name (Lognam  := 'JUMP_SELF', 3 		    Default := 'TRUE',			       { SITE-specific }o 		    Actual  := Str) ;c   Str_Compress (Str,Str) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;
   Zip (Rst) ;P   Narcissus := Str = 'TRUE' ;   2   Get_Logical_Name (Lognam  := 'JUMP_MINOR_PRIVS',; 		    Default := 'NETMBX TMPMBX', 	       { SITE-specific }  		    Actual  := Str) ;    Str_Compress (Str,Str) ;   REPEAT%     READV (Str,Prv,Error:=CONTINUE) ;t     IF STATUSV <> 0  THEN         $EXIT (Jump__Badprivset)h	      ELSEm        BEGIN+        Minor_Privs := Minor_Privs + [Prv] ;          Spot := INDEX (Str,' ') ;        IF Spot = 0  THEN 	  Str := '' 	ELSER/ 	  Str := SUBSTR (Str,Spot+1,Str.LENGTH-Spot) ;         END ;   UNTIL Str = '' ;  3   Get_Logical_Name (Lognam  := 'JUMP_OPER_CLASSES',r5 		    Default := 'CENTRAL',		       { SITE-specific }a 		    Actual  := Str) ;    Str_Compress (Str,Str) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;
   Zip (Rst) ;_D   IF Str = 'SECURITY'  THEN		{ Do nothing - SECURITY only required }    ELSE 
      BEGIN%      Spot := INDEX (Str,'SECURITY') ;	      IF Spot > 0  THEN 	BEGIN! 	IF Spot = 1  THEN			{ First up }i' 	   Str := SUBSTR (Str,10,Str.LENGTH-9)a 	 ELSE* 	IF Spot+7 = Str.LENGTH	THEN		{ Last one }& 	   Str := SUBSTR (Str,1,Str.LENGTH-9) 	 ELSE1 	   Str := SUBSTR (Str,1,Spot-1) +	{ Sandwiched } + 		  SUBSTR (Str,Spot+9,Str.LENGTH-Spot-8) ;_ 	Str_Compress (Str,Str) ;c 	END ;        REPEATt,        READV (Str,Opclass,Error:=CONTINUE) ;        IF STATUSV <> 0	THENu 	  $EXIT (Jump__Badoperclass)d 	ELSEp 	  BEGIN- 	  Oper_Classes := Oper_Classes + [Opclass] ;p 	  Spot := INDEX (Str,' ') ; 	  IF Spot = 0  THEN 	     Str := ''u 	   ELSE2 	     Str := SUBSTR (Str,Spot+1,Str.LENGTH-Spot) ; 	  END ;      UNTIL Str = '' ;n
      END ;  P   Oper_Classes := Oper_Classes + [Opc_Security] ;      { SECURITY is mandatory }-   Oper_Class_Mask := Oper_Classes::UNSIGNED ;p  !   Check_Boolean ('DEBUG',Debug) ;a   IF Debug  THEN      IF NOT Sysprog  THEN  	LIB$SIGNAL (Jump__Nopriv)
       ELSE 	BEGIN# 	Rst := CLI$PRESENT ('DEBUG.ALL') ;_ 	IF Rst = CLI$_PRESENT  THEN" 	   Bugger.All_Bits := 16#Ffffffff 	 ELSE 	IF Rst = CLI$_NEGATED  THEN 	   Bugger.All_Bits := 0 ;   	Bool := Bugger.Info ;$ 	Check_Boolean ('DEBUG.INFO',Bool) ; 	Bugger.Info := Bool ;   	Bool := Bugger.D1 ;" 	Check_Boolean ('DEBUG.D1',Bool) ; 	Bugger.D1 := Bool ;   	Bool := Bugger.D2 ;" 	Check_Boolean ('DEBUG.D2',Bool) ; 	Bugger.D2 := Bool ;   	Bool := Bugger.D3 ;" 	Check_Boolean ('DEBUG.D3',Bool) ; 	Bugger.D3 := Bool ;   	Bool := Bugger.D4 ;" 	Check_Boolean ('DEBUG.D4',Bool) ; 	Bugger.D4 := Bool ;   	Bool := Bugger.D5 ;" 	Check_Boolean ('DEBUG.D5',Bool) ; 	Bugger.D5 := Bool ;   	Bool := Bugger.D6 ;" 	Check_Boolean ('DEBUG.D6',Bool) ; 	Bugger.D6 := Bool ;   	Bool := Bugger.D7 ;" 	Check_Boolean ('DEBUG.D7',Bool) ; 	Bugger.D7 := Bool ;   	Bool := Bugger.D8 ;" 	Check_Boolean ('DEBUG.D8',Bool) ; 	Bugger.D8 := Bool ;   	Bool := Bugger.D9 ;" 	Check_Boolean ('DEBUG.D9',Bool) ; 	Bugger.D9 := Bool ;   	Bool := Bugger.X1 ;" 	Check_Boolean ('DEBUG.X1',Bool) ; 	Bugger.X1 := Bool ;   	Bool := Bugger.X2 ;" 	Check_Boolean ('DEBUG.X2',Bool) ; 	Bugger.X2 := Bool ;   	Bool := Bugger.X3 ;" 	Check_Boolean ('DEBUG.X3',Bool) ; 	Bugger.X3 := Bool ;   	Bool := Bugger.X4 ;" 	Check_Boolean ('DEBUG.X4',Bool) ; 	Bugger.X4 := Bool ;   	Bool := Bugger.X5 ;" 	Check_Boolean ('DEBUG.X5',Bool) ; 	Bugger.X5 := Bool ;   	Bool := Bugger.X6 ;" 	Check_Boolean ('DEBUG.X6',Bool) ; 	Bugger.X6 := Bool ;   	Bool := Bugger.X7 ;" 	Check_Boolean ('DEBUG.X7',Bool) ; 	Bugger.X7 := Bool ;   	Bool := Bugger.X8 ;" 	Check_Boolean ('DEBUG.X8',Bool) ; 	Bugger.X8 := Bool ;   	Bool := Bugger.X9 ;" 	Check_Boolean ('DEBUG.X9',Bool) ; 	Bugger.X9 := Bool ;  3 	Dbgfile_Name := 'SYS$OUTPUT' ;		{ Default output }S3 	IF CLI$PRESENT ('DEBUG.FILE') = CLI$_PRESENT  THEN 	 	   BEGINs= 	   Rst := CLI$GET_VALUE ('DEBUG.FILE',%DESCR Dbgfile_Name) ;x 	   Zip (Rst) ;!	 	   END ;h   	Open_New_File := TRUE ;G 	OPEN (Dbgfile,FILE_NAME:=Dbgfile_Name,HISTORY:=NEW,SHARING:=READWRITE,o9 		      USER_ACTION:=Special_File_Open,Error:=CONTINUE) ;e 	Rst := STATUS (Dbgfile) ; 	IF Rst <> PAS$K_SUCCESS  THEN	 	   BEGINs" 	   LIB$SIGNAL (Jump__Baddbgfil) ;% 	   LIB$STOP (Condition_Code (Rst)) ;t	 	   END ;F 	REWRITE (Dbgfile) ;  ! 	Dbgfile_Name := Open_File_Name ;F3 	Device_Info::UNSIGNED := Open_File_Fab.FAB$L_DEV ;N- 	Debug_To_Terminal := Device_Info.DEV$V_TRM ;t   	IF Bugger.Info	THEN	 	   BEGIN 2 	   WRITELN (Dbgfile,'*** ',Jump_Version,' ***') ;, 	   WRITELN (Dbgfile,'*** DEBUG Mode ***') ;# 	   IF NOT Production_Version  THEN.8 	      WRITELN (Dbgfile,'*** DEVELOPMENT VERSION ***') ;" 	   IF NOT Debug_To_Terminal  THEN: 	      WRITELN (Dbgfile,'*** Debug File: ',Dbgfile_Name) ;7 	   WRITELN (Dbgfile,'*** Audit Trail: ',Audit_Trail) ;E7 	   WRITELN (Dbgfile,'*** Access List: ',Access_List) ; / 	   WRITELN (Dbgfile,'*** Command: ',Command) ;.9 	   WRITELN (Dbgfile,'*** Caller Username: ',Orig_User) ;d 	   Format_User (Orig_Uic) ;1 	   WRITELN (Dbgfile,'*** Caller UIC: ',Id_Str) ; 7 	   WRITELN (Dbgfile,'*** Caller PID: ',HEX(Pid,8,8)) ;U@ 	   WRITELN (Dbgfile,'*** Caller Process Name: ',Process_Name) ;I 	   WRITELN (Dbgfile,'*** Caller Cur  privs:',Str_Privs(Proc_Cur_Priv)) ; I 	   WRITELN (Dbgfile,'*** Caller Def  privs:',Str_Privs(Proc_Perm_Priv));]I 	   WRITELN (Dbgfile,'*** Caller Auth privs:',Str_Privs(Proc_Auth_Priv));n: 	   WRITELN (Dbgfile,'*** PSB Available:',Psb_Available) ; 	   IF Psb_Available  THEN 	      BEGIN+ 	      Check_Extauth_Flags (Caller_Flags) ;I= 	      WRITELN (Dbgfile,'*** Caller EXTAUTH:',Extauth_Flag) ; = 	      WRITELN (Dbgfile,'*** Caller VMSAUTH:',Vmsauth_Flag) ;e' 	      IF Acme_Agent_Name = 'VMS'  THEN / 		 WRITELN (Dbgfile,'*** ACME Agent: VMS only')m 	       ELSE$ 	      IF Acme_Agent_Name <> ''	THENB 		 WRITELN (Dbgfile,'*** ACME Agents: VMS and ',Acme_Agent_Name) ; 	      END ;H 	   WRITELN (Dbgfile,'*** Max Sys Grp (Octal): ',OCT(Max_Sys_Group,3)) ;. 	   IF Real_Mccoy AND System_Secure_Mode  THEN3 	      WRITELN (Dbgfile,'*** System Secure Mode') ; 8 	   WRITELN (Dbgfile,'*** DOUBLE CHECK:',Double_Check) ;* 	   WRITELN (Dbgfile,'*** CHAIN:',Chain) ;A 	   WRITELN (Dbgfile,'*** Caller Attributes: ',Jump_Attributes) ;s	 	   END ;_ 	END ;  $   END ; { of Get_And_Parse_Command }    $ FUNCTION Get_Target_Info : BOOLEAN ;  J { Get the required information for the particular new user from the UAF. }     VAR	I , J : INTEGER := 0 ; 	Rst , Ctx : UNSIGNED := 0 ; 	Holder : $UQUAD := ZERO ;- 	Item_List : Item_List_Template (7) := ZERO ;g     BEGIN 	{ Get_Target_Info }#   Item_List[1].Buffer_Length := 8 ;f/   Item_List[1].Item_Code     := UAI$_DEF_PRIV ; 5   Item_List[1].Buffer_Addr   := IADDRESS (Def_Priv) ;t#   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Buffer_Length := 8 ;I+   Item_List[2].Item_Code     := UAI$_PRIV ;e6   Item_List[2].Buffer_Addr   := IADDRESS (Auth_Priv) ;#   Item_List[2].Return_Addr   := 0 ;O  #   Item_List[3].Buffer_Length := 4 ;s*   Item_List[3].Item_Code     := UAI$_UIC ;>   Item_List[3].Buffer_Addr   := IADDRESS (New_Uic.UIC$L_UIC) ;#   Item_List[3].Return_Addr   := 0 ;R  #   Item_List[4].Buffer_Length := 4 ; ,   Item_List[4].Item_Code     := UAI$_FLAGS ;9   Item_List[4].Buffer_Addr   := IADDRESS (Target_Flags) ;O#   Item_List[4].Return_Addr   := 0 ;e  0   Item_List[5].Buffer_Length := SIZE (Def_Dir) ;-   Item_List[5].Item_Code     := UAI$_DEFDIR ;R9   Item_List[5].Buffer_Addr   := IADDRESS (Def_Dir.BODY) ; #   Item_List[5].Return_Addr   := 0 ;   0   Item_List[6].Buffer_Length := SIZE (Def_Dev) ;-   Item_List[6].Item_Code     := UAI$_DEFDEV ;e9   Item_List[6].Buffer_Addr   := IADDRESS (Def_Dev.BODY) ; #   Item_List[6].Return_Addr   := 0 ;D  ?   Item_List[7].Terminator    := 0 ;	{ Terminate the item list }[  I   Rst := $GETUAI (Usrnam := %STDESCR SUBSTR (New_User,1,New_User.LENGTH),  		  Itmlst := Item_List) ;      Get_Target_Info := ODD (Rst) ;     IF NOT ODD (Rst)  THEN
      BEGIN      IF Rst <> RMS$_RNF  THENs 	LIB$SIGNAL (Rst) ;[      END    ELSEO
      BEGIN.      Def_Dir.LENGTH := INT (Def_Dir.BODY[1]) ;.      Def_Dev.LENGTH := INT (Def_Dev.BODY[1]) ;=      Def_Dir.BODY := SUBSTR (Def_Dir.BODY,2,Def_Dir.LENGTH) ; =      Def_Dev.BODY := SUBSTR (Def_Dev.BODY,2,Def_Dev.LENGTH) ;w  3      { Get the Rights IDs held by the target user }a  %      Holder.L0 := New_Uic.UIC$L_UIC ;1      REPEAT=        I := I + 1 ;:+        Rst := $FIND_HELD (Holder := Holder,p  			  Id	 := Target_Rights[I].L0, 			  Contxt := Ctx) ;E7        IF (Rst <> SS$_NOSUCHID) AND NOT ODD (Rst)  THEN0 	  LIB$SIGNAL (Rst) ;t4      UNTIL (Rst = SS$_NOSUCHID) OR (I = Rightsize) ;        I := I - 1 ;O
      J := 1 ;{&      WHILE System_Rights[J].L0 > 0  DO        BEGIN5        Target_Rights[I+J].L0 := System_Rights[J].L0 ;M        J := J + 1 ;M        END ;
      END ;     IF Bugger.Info  THEN
      BEGIN9      WRITELN (Dbgfile,'*** Target Username: ',New_User) ;       Format_User (New_Uic) ;2      WRITELN (Dbgfile,'*** Target UIC: ',Id_Str) ;E      WRITELN (Dbgfile,'*** Target Def  privs:',Str_Privs(Def_Priv)) ;TF      WRITELN (Dbgfile,'*** Target Auth privs:',Str_Privs(Auth_Priv)) ;      IF Psb_Available  THENL 	BEGIN% 	Check_Extauth_Flags (Target_Flags) ; 7 	WRITELN (Dbgfile,'*** Target EXTAUTH:',Extauth_Flag) ;a7 	WRITELN (Dbgfile,'*** Target VMSAUTH:',Vmsauth_Flag) ;N 	END ;
      END ;     END ; 	{ of Get_Target_Info }r    B FUNCTION Valid_Username (User : VARYING [Len] OF CHAR) : BOOLEAN ;  G { Determine if the string corresponds to a valid username in the UAF. }P  #   VAR	Rst , Flags : UNSIGNED := 0 ;R- 	Item_List : Item_List_Template (2) := ZERO ;b     BEGIN 	{ Valid_Username }.#   Item_List[1].Buffer_Length := 4 ;L,   Item_List[1].Item_Code     := UAI$_FLAGS ;G   Item_List[1].Buffer_Addr   := IADDRESS (Flags) ;	{ Anything will do }C#   Item_List[1].Return_Addr   := 0 ;p  ?   Item_List[2].Terminator    := 0 ;	{ Terminate the item list }O  9   Rst := $GETUAI (Usrnam := %STDESCR SUBSTR (User,1,Len),R 		  Itmlst := Item_List) ;     Valid_Username := ODD (Rst) ;R  3   IF NOT ODD (Rst) AND_THEN (Rst <> RMS$_RNF)  THENo      LIB$SIGNAL (Rst) ;n   END ; 	{ of Valid_Username }    9 FUNCTION Parse_Ident (Ident_Str : VARYING [Len] OF CHAR ;t" 		      VAR Ident_Val : UIC$TYPE ;% 		      VAR Parse_Result : UNSIGNED ; - 		      Req_Type : UNSIGNED := 0) : BOOLEAN ;   J   { Use LIB$TABLE_PARSE to parse an identifier string.	This neatly handles>     all parsing issues associated with UICs and identifiers. }     CONSTF  E   No_Req  = 0 ; 	{ No specific requirements - any valid value is OK } (   Req_Rid = 1 ; 	{ Must be a Rights ID }"   Req_Uic = 2 ; 	{ Must be a UIC }7   Req_Uic_Nowild = 3 ;	{ Must be a non-wildcarded UIC })2   Req_Uic_Wild	 = 4 ;	{ Must be a wildcarded UIC }     VAR      Rst : UNSIGNED := 0 ;   9   State_Tbl ,				      { TABLE_PARSE table - see source }sP   Key_Tbl   : [EXTERNAL,VALUE] UNSIGNED ;     { TABLE_PARSE table - see source }L   Arg_Block : [VOLATILE] TPA$TYPE := ZERO ;   { TABLE_PARSE argument block }     BEGIN 	{ Parse_Ident }   Parse_Ident := FALSE ;  7   Ident_Val.UIC$L_UIC := 0 ;			{ Return null if error }N:   Ident_Val.UIC$V_FORMAT := 1 ; 		{ Invalid format value }  -   Arg_Block.TPA$L_COUNT     := TPA$K_COUNT0 ;($   Arg_Block.TPA$L_STRINGCNT := Len ;:   Arg_Block.TPA$L_STRINGPTR := IADDRESS (Ident_Str.BODY) ;  )   Rst := LIB$TABLE_PARSE (%REF Arg_Block, 0 			  %IMMED State_Tbl,	{ See JUMP MACRO source }0 			  %IMMED Key_Tbl) ;	{ See JUMP MACRO source }     Parse_Result := Rst ;       IF Rst <> LIB$_SYNTAXERR  THEN      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst)D
       ELSE 	BEGIN0 	Ident_Val.UIC$L_UIC := Arg_Block.TPA$L_NUMBER ; 	IF Req_Type = No_Req  THENH 	   Parse_Ident := TRUE  	 ELSE2 	IF (Ident_Val.UIC$V_FORMAT = UIC$K_ID_FORMAT) AND 	   (Req_Type = Req_Rid)  THEN 	   Parse_Ident := TRUE_ 	 ELSE3 	IF Ident_Val.UIC$V_FORMAT = UIC$K_UIC_FORMAT  THEN  	   IF (Req_Type  = Req_Uic) ORA' 	      ((Req_Type = Req_Uic_Nowild) ANDv8 	       (Ident_Val.UIC$V_GROUP  <> UIC$K_WILD_GROUP) AND9 	       (Ident_Val.UIC$V_MEMBER <> UIC$K_WILD_MEMBER)) OR,% 	      ((Req_Type = Req_Uic_Wild) AND 1 		((Ident_Val.UIC$V_GROUP  = UIC$K_WILD_GROUP) ORi7 		 (Ident_Val.UIC$V_MEMBER = UIC$K_WILD_MEMBER)))  THENO 	      Parse_Ident := TRUE ; 	END ;   END ; 	{ of Parse_Ident }a    * FUNCTION Match_Uic (Id1 , Id2 : UIC$TYPE ;" 		    Exact   : BOOLEAN := FALSE ;- 		    Ordered : BOOLEAN := FALSE) : BOOLEAN ;E  F { Determine if a pair of UICs match, either uniquely if "EXACT", or asB   wildcarded UICs.  If "ORDERED", Id1 must be a "subset" of Id2. }     BEGIN 	{ Match_UIC }   Match_Uic := FALSE ;  9   IF Id1.UIC$L_UIC = Id2.UIC$L_UIC  THEN		{ Exact match }U      Match_Uic := TRUE    ELSEe,   IF NOT Exact	THEN					{ Wildcarded forms }      IF Ordered  THENR8 	Match_Uic := ((Id2.UIC$V_MEMBER = UIC$K_WILD_MEMBER) OR2 		      (Id1.UIC$V_MEMBER = Id2.UIC$V_MEMBER)) AND/ 		     ((Id2.UIC$V_GROUP	= UIC$K_WILD_GROUP) OR', 		      (Id1.UIC$V_GROUP	= Id2.UIC$V_GROUP))
       ELSE8 	Match_Uic := ((Id1.UIC$V_MEMBER = UIC$K_WILD_MEMBER) OR1 		      (Id2.UIC$V_MEMBER = UIC$K_WILD_MEMBER) OR 2 		      (Id1.UIC$V_MEMBER = Id2.UIC$V_MEMBER)) AND/ 		     ((Id1.UIC$V_GROUP	= UIC$K_WILD_GROUP) ORs/ 		      (Id2.UIC$V_GROUP	= UIC$K_WILD_GROUP) ORt. 		      (Id1.UIC$V_GROUP	= Id2.UIC$V_GROUP)) ;   END ; 	{ of Match_UIC }_    7 FUNCTION Match_List (Candidate	: VARYING [L1] OF CHAR ; ' 		     Targets : VARYING [L2] OF CHAR ;t! 		     Candidate_Uic : UIC$TYPE ;X4 		     Candidate_Rights : Rights_Array) : UNSIGNED ;  M   { Determine if a given candidate string, which may be either a (wildcarded)eJ     username, a (wildcarded) UIC, or a rights identifier, is included in a>     list of targets which may be of any of these same types. }  ;   TYPE	Style_Type = (Unknown,Wild_S,User_S,Uic_S,Ident_S) ;f  "   VAR	Rst , Spot : UNSIGNED := 0 ;' 	Negated , Matched : BOOLEAN := FALSE ;s# 	Id_Style : Style_Type := Unknown ;r' 	Dancer : VARYING [100] OF CHAR := '' ;: 	Dancer_Id : UIC$TYPE := ZERO ;      BEGIN 	{ Match_List }h   Match_List := CLI$_ABSENT ;o     WHILE Targets <> ''  DOt	     BEGINB+     IF Targets[1] = '!'  THEN			{ Negated }p        BEGIN9        IF Targets.LENGTH = 1  THEN		{ Last character??? }t 	  $EXIT (Jump__Baddata) 	ELSE 3 	  Targets := SUBSTR (Targets,2,Targets.LENGTH-1) ;         Negated := TRUE ;
        END	      ELSEp        Negated := FALSE ;r  *     IF Targets[1] IN Symbol+Wildcard  THEN        BEGIN9        Spot := FIND_NONMEMBER (Targets,Symbol+Wildcard) ;I        IF Spot = 0  THEN 	  BEGIN 	  Dancer  := Targets ;  	  Targets := '' ; 	  END 	ELSE #        IF Targets[Spot] = ','  THENC 	  BEGIN 	  Spot := Spot - 1 ; & 	  Dancer := SUBSTR (Targets,1,Spot) ; 	  END 	ELSEm 	  $EXIT (Jump__Baddata) ;1        IF FIND_MEMBER (Dancer,Wildcard) > 0  THENu 	  Id_Style := Wild_Se 	ELSEe= 	  Id_Style := User_S ;	{ User or ID?  Assume user for now. }V
        END	      ELSEA#     IF Targets[1] IN Uic_Left  THEN         BEGIN0        Spot := FIND_MEMBER (Targets,Uic_Right) ;        IF Spot = 0  THEN 	  $EXIT (Jump__Baddata) ;*        Dancer := SUBSTR (Targets,1,Spot) ;C        IF ((Dancer[1] = '[') AND (Dancer[Dancer.LENGTH] <> ']')) OR=? 	  ((Dancer[1] = '<') AND (Dancer[Dancer.LENGTH] <> '>'))  THEN  	  $EXIT (Jump__Baddata) ;        Id_Style := Uic_S ;
        END	      ELSEf        $EXIT (Jump__Baddata) ;  "     IF Spot < Targets.LENGTH  THEN=        Targets := SUBSTR (Targets,Spot+1,Targets.LENGTH-Spot)i	      ELSE         Targets := '' ;=     IF (Targets.LENGTH > 1) AND_THEN (Targets[1] = ',')  THEN 1 	Targets := SUBSTR (Targets,2,Targets.LENGTH-1) ;t  B     IF Id_Style = Unknown  THEN 		  { Huh??? Should never happen }        $EXIT (Jump__Baddata)	      ELSE]:     IF Id_Style = Wild_S  THEN				   { Wildcard username }        BEGIN1        Rst := STR$MATCH_WILD (Candidate,Dancer) ;_         IF Rst = STR$_MATCH  THEN 	  Matched := TRUE 	ELSE[;        IF NOT ODD (Rst) AND_THEN (Rst <> STR$_NOMATCH)	THEN$ 	  LIB$SIGNAL (Rst) ;[
        END	      ELSED>     IF (Id_Style = User_S) AND_THEN			      { Exact username }!        (Candidate = Dancer)  THENL 	  Matched := TRUE.      ELSE					 { Another username, UIC or ID }6     IF NOT Parse_Ident (Dancer,Dancer_Id,Rst) AND_THENP        (((Rst  = LIB$_SYNTAXERR) AND (Id_Style = Uic_S)) OR   { Bad UIC syntax }I 	((Rst <> LIB$_SYNTAXERR) AND NOT ODD (Rst)))  THEN { Parse_Ident error }  	  $EXIT (Jump__Baddata)	      ELSEt        BEGIN  M       { If we reach here, it's a UIC, a UIC ID or a rights ID that has parsed E 	successfully to an existing identifier. Ignore UIC IDs that are alsodH 	usernames to eliminate ambiguity -- usernames always take precedence. }  $        IF (Id_Style = Uic_S) OR_ELSE& 	  (NOT Valid_Username (Dancer))  THEN4 	  IF Dancer_Id.UIC$V_FORMAT = UIC$K_ID_FORMAT  THEN 	     Id_Style := Ident_S_ 	   ELSE4 	  IF Dancer_Id.UIC$V_FORMAT = UIC$K_UIC_FORMAT	THEN 	     Id_Style := Uic_S ;$  ,        IF (Id_Style = Uic_S)  AND				{ UIC }, 	  Match_Uic (Candidate_Uic,Dancer_Id)  THEN 	    Matched := TRUE 	ELSEB3        IF Id_Style = Ident_S  THEN				{ Rights ID }e! 	  FOR Spot := 1 TO Rightsize  DO ? 	      IF Dancer_Id.UIC$L_UIC = Candidate_Rights[Spot].L0  THENs 		 Matched := TRUE ;        END ;       IF Matched	THENs        IF Negated  THENZ 	  Match_List := CLI$_NEGATEDs 	ELSEt 	  Match_List := CLI$_PRESENT ; 	     END ;0   END ; 	{ of Match_List }    D PROCEDURE Parse_Number_List (VAR List_Str : VARYING [Len] OF CHAR) ;     CONST Max_Str_Sz = 1024 ;f  ;   VAR	I , Cycle , Spot , Num , Range_Start : INTEGER := 0 ;m 	Range : BOOLEAN := FALSE ;M 	Next_Chr : CHAR := Null ;- 	Str : VARYING [Max_Str_Sz] OF CHAR := ZERO ;t     BEGIN 	{ Parse_Number_List }   IF Bugger.D3	THENLB      WRITELN (Dbgfile,'*** Parsing numbers: Source = ',List_Str) ;  J   IF (FIND_NONMEMBER (List_Str,Digits+Separators) <> 0) OR (Len = 0)  THEN#        LIB$SIGNAL (Jump__Baddata) ;D      WHILE LENGTH(List_Str) > 0  DO	     BEGINn     Cycle := Cycle + 1 ;     IF Bugger.D3  THENG        WRITELN (Dbgfile,'*** Parsing numbers: -------- CYCLE ',Cycle:1,u 			' --------') ;R  /     Spot := FIND_MEMBER (List_Str,Separators) ;=     IF Bugger.D3  THENA        WRITELN (Dbgfile,'*** Parsing numbers: Spot  = ',Spot:1) ;M       IF Spot = 0  THENr        BEGIN        Str := List_Str ;        List_Str := '' ;n
        END	      ELSEo3     IF (Spot = 1) OR (Spot = LENGTH(List_Str))	THEN @        LIB$SIGNAL (Jump__Baddata)	{ Adjacent/hanging separator }	      ELSEu        BEGIN*        Str := SUBSTR (List_Str,1,Spot-1) ;#        Next_Chr := List_Str[Spot] ;6C        List_Str := SUBSTR (List_Str,Spot+1,LENGTH(List_Str)-Spot) ;I        IF Next_Chr = '-'  THEN 	  BEGIN 	  IF Range  THENI: 	     LIB$SIGNAL (Jump__Baddata) ;	{ Already in a range! } 	  Range := TRUE ; 	  END ;        END ;       IF Bugger.D3  THEN        BEGIN>        WRITELN (Dbgfile,'*** Parsing numbers: Str   = ',Str) ;C        WRITELN (Dbgfile,'*** Parsing numbers: Rem   = ',List_Str) ;<@        WRITELN (Dbgfile,'*** Parsing numbers: Range =' ,Range) ;C        WRITELN (Dbgfile,'*** Parsing numbers: Next  = ',Next_Chr) ;D        END ;       READV (Str,Num) ;L-     IF (Num < 1) OR (Num > Max_Scm_Num)  THENt#        LIB$SIGNAL (Jump__Baddata) ;      IF Default_Scm = 0	THENgH        Default_Scm := Num ;	{ First in list is default cmd if only one }       IF Bugger.D3  THEN@        WRITELN (Dbgfile,'*** Parsing numbers: Num   = ',Num:1) ;       IF Range  THEN        IF Range_Start = 0  THENa 	  Range_Start := Nums 	ELSE  	  BEGIN 	  IF Num <= Range_Start  THEN" 	     LIB$SIGNAL (Jump__Baddata) ;" 	  FOR I := Range_Start TO Num  DO 	      BEGIN% 	      Valid_Scm_Numbers[I] := TRUE ;v# 	      Scm_Count := Scm_Count + 1 ;v 	      END ; 	  Range := FALSE ;r 	  Range_Start := 0 ;P 	  END	      ELSEp        BEGIN'        Valid_Scm_Numbers[Num] := TRUE ;f#        Scm_Count := Scm_Count + 1 ;B        END ;     END ;	{ While }h       IF Bugger.D4  THEN$        FOR I := 1 TO Max_Scm_Num  DO  	   IF Valid_Scm_Numbers[I]	THEN> 	      WRITELN (Dbgfile,'*** Parsing numbers: Valid = ',I:4) ;     END ; 	{ Parse_Number_List }     PROCEDURE Validate_Access ;A  F { For the type of user running the program, validate the user's access'   against the target user's UAF record.T  H   Non-SysProgs can jump using /NOEXACT only to users who do not have anyI   privileges other than "minor" privileges, or to those to whom access is K   granted in the Access List file. "Minor" privileges are specified throughiK   a SITE-specific privilege list using the JUMP_MINOR_PRIVS logical name. }f     VAR	I   : INTEGER  := 0 ;R 	Rst : UNSIGNED := 0 ;F         Chekov ,                        { User has JUMP's rights ID? }- 	Priv_Target ,			{ Target is "privileged" ? } E 	Id_Check_Ok : BOOLEAN := FALSE ;{ JUMP_ACCESS rights ID check ok ? }mI 	Access : Access_Status := Unspecified ; { Result of access list checks }I 	Jump_Id : UIC$TYPE := ZERO ;   5   FUNCTION Check_Access_And_Options : Access_Status ;   K   { Determine if the caller is specifically authorised to access the targetm(     user in the access list data file. }  (     VAR I , Spot , Skip : INTEGER := 0 ;& 	Rst , Target_Status : UNSIGNED := 0 ; 	Done : BOOLEAN := FALSE ;& 	Option , Scanning : BOOLEAN := TRUE ;= 	Str , Src , Dst , Opt , Line : VARYING [120] OF CHAR := '' ; % 	Buf : VARYING [1024] OF CHAR := '' ;E( 	Result : Access_Status := Unspecified ; 	Access : TEXT ;  &     BEGIN	{ Check_Access_And_Options };     Check_Access_And_Options := Unspecified ;			{ Default }        High_Security := TRUE ;nL     OPEN (Access,FILE_NAME:=Access_List,HISTORY:=READONLY,SHARING:=READONLY,4 		 USER_ACTION:=Special_File_Open,Error:=CONTINUE) ;     Rst := STATUS (Access) ;      IF Rst = PAS$K_SUCCESS  THEN        BEGIN        RESET (Access) ; &        Access_List := Open_File_Name ;  +        WHILE NOT (EOF (Access) OR Done)  DOp 	 BEGIN' 	 READLN (Access,Line) ;3 	 Str_Compress (Line,Line,TRUE) ;		{ Squeeeeeeze! }F( 	 Rst := STR$UPCASE (%DESCR Line,Line) ;
 	 Zip (Rst) ;rI 	 IF (Line.LENGTH > 0) AND_THEN (Line[1] <> '#')  THEN  { Not a comment }o
 	    BEGIN7 	    Spot := INDEX (Line,'#') ;			{ Trailing comment? }n 	    IF Spot > 0  THEN( 	       Line := SUBSTR (Line,1,Spot-1) ; 	    Spot := INDEX (Line,'\') ;O- 	    IF Spot > 0  THEN				{ Continued ... ? } + 	       Buf := Buf + SUBSTR (Line,1,Spot-1)H
 	     ELSE5 	    IF Line = '!!!'  THEN			{ Terminate processing }T 	       Done := TRUE
 	     ELSE
 	       BEGIN{ 	       Buf  := Buf + Line ;! 	       Spot := INDEX (Buf,':') ;N2 	       IF Spot = 0  THEN  $EXIT (Jump__Baddata) ;' 	       Src  := SUBSTR (Buf,1,Spot-1) ;s5 	       Dst  := SUBSTR (Buf,Spot+1,Buf.LENGTH-Spot) ;P! 	       Spot := INDEX (Dst,':') ;T 	       IF Spot = 0  THEN 
 		  Opt := ''O 		ELSE	 		  BEGIN_0 		  Opt := SUBSTR (Dst,Spot+1,Dst.LENGTH-Spot) ;" 		  Dst := SUBSTR (Dst,1,Spot-1) ;	 		  END ;d) 	       IF (Src = '') OR (Dst = '')  THEN( 		  $EXIT (Jump__Baddata) ;c  9 	       { Check if target user is in valid target list. }a  I 	       Target_Status := Match_List (New_User,Dst,New_Uic,Target_Rights);	  G 	       { If caller is in valid caller list, determine access status. }C   	       IF Match_ListHA 		    (Orig_User,Src,Orig_Uic,Caller_Rights) = CLI$_PRESENT  THENm	 		  BEGIN'B 		  IF Target_Status = CLI$_PRESENT  THEN  { Newuser in target...}/ 		     Result := Granted			 { ... NOT negated }t	 		   ELSEn; 		  IF Target_Status = CLI$_NEGATED  THEN  { ... negated! }E 		     Result := DeniedS	 		   ELSE_. 		     Result := Unspecified ;		 { Not there }  " 		  IF Result <> Unspecified  THEN 		     BEGIN 		     Done := TRUE ;M+ 		     Check_Access_And_Options := Result ;  		     END ;	 		  END ;   B 	       { If access is Granted, check and action any options ... }  3 	       IF (Result = Granted) AND (Opt <> '')  THENm  		  FOR I := 1 TO Opt.LENGTH  DO 		    IF Scanning  THEN 
 		      BEGINm 		      CASE Opt[I]  OFX& 			'!': Option := FALSE ;			{ Negate }! 			'A': Notify.After  := Option ;h! 			'B': Notify.Before := Option ;a. 			'C': IF NOT Option  THEN	 { Not negatable } 				$EXIT (Jump__Baddata) 
 			      ELSEp 				Chain := FALSE ;
 			'E': BEGIN)) 			     IF (Option AND NOT Real_Mccoy) OR % 				(Real_Mccoy AND NOT Option)  THENt* 				  Check_Access_And_Options := Denied ;7 			     IF (NOT Option) AND (Opt <> '!E')	THEN	{ ONLY }  				$EXIT (Jump__Baddata) ;}
 			     END ;i( 			'I': Notify.Include_Log := Option AND 						   Record_Session ANDu 						   Notify.By_Mail  ;" 			'M': Notify.By_Mail := Option ;
 			'N': BEGINy; 			     Notify.All_Bits := Option::Unsigned8 * 16#Ffffffff;E9 			     Notify.Include_Log := Record_Session AND Option ; 
 			     END ;B# 			'O': Notify.By_Opcom := Option ;r 			'R': IF Opt[1] = 'S'  THENm 				$EXIT (Jump__Baddata)D
 			      ELSE + 			     IF Secure_Mode AND NOT Option  THEN  				$EXIT (Jump__Conflict)
 			      ELSEN 				Record_Session := Option ;
 			'U': BEGINF 			     IF NOT Option  THENb 				$EXIT (Jump__Baddata) ;u$ 			     IF (Opt.LENGTH > I) AND_THEN 				(Opt[I+1] IN Digits)  THEN	 				BEGINR* 				Str := SUBSTR (Opt,I+1,Opt.LENGTH-I) ;4 				Spot := FIND_NONMEMBER (Str,Digits+Separators) ; 				IF Spot > 0  THEND 				   BEGIN% 				   Str := SUBSTR (Str,1,Spot-1) ;c 				   Skip := Spot - 1 ; 
 				   END	 				 ELSEs 				   Skip := Str.LENGTH ;T 				Parse_Number_List (Str) ;  				IF Scm_Selection > 0  THEN4 				   IF NOT Valid_Scm_Numbers[Scm_Selection]  THEN& 				      LIB$SIGNAL (Jump__Unkscmnum) 				    ELSE 				      Spot := Scm_Selectione	 				 ELSEC 				   Spot := Default_Scm ; 				WRITEV (Str,Spot:1) ;  				Get_Logical_Name (( 					Lognam	:= 'JUMP_SINGLE_CMD_' + Str,  					Default := 'MYDOGHASFLEAS',% 					Table	:= 'JUMP_SINGLE_COMMANDS',  					Actual	:= Str) ;u+ 				IF Single_Cmd_Mode  THEN	{ Imposter?! }a( 				   LIB$SIGNAL (Jump__Noovrsnglcmd) ;" 				IF Str = 'MYDOGHASFLEAS'  THEN( 				   LIB$SIGNAL  (Jump__Nolnmforscm) ; 				Single_Cmd := Str ;  				Single_Cmd_Mode := TRUE ;i4 				IF (Scm_Selection = 0) AND (Scm_Count > 1)  THEN4 				   LIB$SIGNAL (Jump__Scmcmddef) ;  { Warn them } 				ENDd
 			      ELSE " 			     IF Scm_Selection > 0  THEN  				LIB$SIGNAL (Jump__Scmnotsel)
 			      ELSEH3 			     IF NOT Single_Cmd_Mode  THEN	{ Mandatory! }P 				$EXIT (Jump__Scmreqcmd) ;S
 			     END ; 
 			'S': BEGINc 			     IF I <> 1	THEN 				$EXIT (Jump__Baddata) ;' 			     Secure_Mode := TRUE ;S( 			     Notify.All_Bits := 16#Ffffffff ;! 			     Record_Session  := TRUE ;D
 			     END ;L
 			'X': BEGINg0 			     IF Opt <> 'X'  THEN	{ Must be just 'X' } 				$EXIT (Jump__Baddata) ;i 			     Houdini := TRUE ; 
 			     END ;r 			'+', ( 			'=': BEGIN			{ Buf no longer in use } 			     IF NOT Option  THEN) 				$EXIT (Jump__Baddata) ;t. 			     Buf := SUBSTR (Opt,I+1,Opt.LENGTH-I) ; 			     IF Opt[I] = '+'  THEN$, 				Notify_Maillist := Notify_Maillist + Buf
 			      ELSEc 				Notify_Maillist := Buf ;) 			     Scanning := FALSE ;	{ Stop here } 
 			     END ;  			OTHERWISE 			     IF Skip > 0  THEN	 				Skip := Skip - 1
 			      ELSEo  				LIB$SIGNAL (Jump__Baddata) ; 			END ;	{ of Case }  ( 		      IF Opt[I] <> '!'	THEN		{ Reset } 			 Option := TRUE ; 		      END ;	{ of FOR }  , 	       Buf := '' ;		{ Logical end of line }4 	       END ;	{ of continue processing (not "!!!") } 	    END ;	{ of not a comment }P 	 END ;		{ of WHILE }i          IF Bugger.Info  THENG 	  BEGIN2 	  WRITELN (Dbgfile,'*** Target access:',Result) ;! 	  IF Result <> Unspecified  THENt- 	     WRITELN (Dbgfile,'*** Options: ',Opt) ;T 	  END ;  2        IF Buf <> ''  THEN		{ Continuation?  Huh? } 	  $EXIT (Jump__Baddata) ;        CLOSE (Access) ; '        END		{ of successful file open } 	      ELSECK     IF Rst <> PAS$K_FILNOTFOU  THEN	{ Ignore FILNOTFOU - file is optional }:        BEGIN%        LIB$SIGNAL (Jump__Badaccfil) ;E'        LIB$STOP (Condition_Code(Rst)) ;         END ;  3     IF Bugger.Info AND (Rst = PAS$K_FILNOTFOU)	THENy@        WRITELN (Dbgfile,'*** Access List file does not exist') ;  *     IF (Notify.Before OR Notify.After) AND3        NOT (Notify.By_Mail OR Notify.By_Opcom)	THENt 	 $EXIT (Jump__Badnotify) ;s       IF Notify.Include_Log AND 3        NOT (Record_Session AND Notify.By_Mail)	THENR 	 $EXIT (Jump__Badinclude) ;  /     IF System_Secure_Mode AND NOT Houdini  THENn        BEGIN'        Notify.All_Bits := 16#Ffffffff ;u         Record_Session  := TRUE ;        Secure_Mode := TRUE ;        END ;  .     IF (Notify.By_Mail OR Notify.By_Opcom) AND0        NOT (Notify.Before OR Notify.After)  THEN        BEGIN        Notify.After  := TRUE ;        Notify.Before := TRUE ;%        LIB$SIGNAL (Jump__Fixnotify) ;         END ;       IF Secure_Mode  THEN        BEGIN        IF Notify.By_Mail  THEN 	  BEGIN 	  Notify.Vamoose := TRUE ;f1 	  Notify.Before  := TRUE ;	{ After is too late }R 	  END ;        IF Escape_Hatch	THEN; 	  BEGIN 	  Escape_Hatch := FALSE ;  	  LIB$SIGNAL (Jump__Noescape) ; 	  END ;        END ;  8     IF (Scm_Selection > 0) AND NOT Single_Cmd_Mode  THEN%        LIB$SIGNAL (Jump__Selnotreq) ;r  <     Suspect := Suspect AND (Secure_Mode OR Record_Session) ;)     END ;	{ of Check_Access_And_Options }s    A   PROCEDURE Validate_Maillist (Listname : VARYING [Sz] OF CHAR) ;H  H   { Check the addresses in the Mailing List file to see if there are anyE     dodgy logical names (not defined /SYSTEM /EXEC).  The validity of #     mail addresses is not tested. }   $     VAR  Rst , Spot : INTEGER := 0 ; 	 Done : BOOLEAN := FALSE ;T4 	 Dest_Addr , Result : VARYING [255] OF CHAR := '' ; 	 Dis_File : TEXT ;R       BEGIN	{ Validate_Maillist } ;     Dest_Addr := SUBSTR (Listname,2,Sz-1) ;  { Remove "@" }p       High_Security := TRUE ; L     OPEN (Dis_File,FILE_NAME:=Dest_Addr,HISTORY:=READONLY,SHARING:=READONLY,6 		   USER_ACTION:=Special_File_Open,Error:=CONTINUE) ;     Rst := STATUS (Dis_File) ;  !     IF Rst <> PAS$K_SUCCESS  THEN L        LIB$SIGNAL (Condition_Code (Rst))   { Map to a condition code value }	      ELSE(        BEGIN        RESET (Dis_File) ; -        WHILE NOT (Done OR EOF (Dis_File))  DOE 	 BEGIN  	 READLN (Dis_File,Dest_Addr) ;B+ 	 Str_Compress (Dest_Addr,Dest_Addr,TRUE) ;S! 	 Spot := INDEX (Dest_Addr,'!') ;  	 IF Spot > 1  THEN / 	    Dest_Addr := SUBSTR (Dest_Addr,1,Spot-1) ;  	 IF Spot <> 1  THEN
 	    BEGIN5 	    Rst := Get_Logical_Name (Dest_Addr,'###',Result, % 				     'LNM$FILE_DEV',PSL$C_USER) ;T: 	    IF NOT ((Rst = SS$_NOLOGNAM) OR Secure_Logical)  THEN# 	       LIB$SIGNAL (Jump__Invlnm,1,s7 			   %STDESCR SUBSTR (Dest_Addr,1,Dest_Addr.LENGTH)) ;  	    Done := NOT ODD (Rst) ;
 	    END ; 	 END ;s        CLOSE (Dis_File) ;         END ;"     END ;	{ of Validate_Maillist }    "   PROCEDURE Validate_Notify_List ;  J   { Check the addresses in the JUMP_NOTIFY_MAILLIST logical name to see ifG     there are any dodgy logical names (not defined /SYSTEM /EXEC).  The /     validity of mail addresses is not tested. }   !     VAR  Rst , I : INTEGER := 0 ;D
 	 Dest_Addr ,T
 	 Result ,+ 	 Addr_List : VARYING [255] OF CHAR := '' ;o  "     BEGIN	{ Validate_Notify_List }  "     Addr_List := Notify_Maillist ;  !     WHILE Addr_List.LENGTH > 0	DO	       BEGIN="       I := INDEX (Addr_List,',') ;       IF I > 0	THEND 	 BEGINC) 	 Dest_Addr := SUBSTR (Addr_List,1,I-1) ;I: 	 Addr_List := SUBSTR (Addr_List,I+1,Addr_List.LENGTH-I) ; 	 END;        ELSER 	 BEGIN% 	 Dest_Addr := Addr_List ; 	 Addr_List := '' ;: 	 END ;T  #       IF Dest_Addr.LENGTH > 0  THEN  	 BEGINe 	 IF Dest_Addr[1] = '@'	THEN" 	    Validate_Maillist (Dest_Addr) 	  ELSEy
 	    BEGIN5 	    Rst := Get_Logical_Name (Dest_Addr,'###',Result, % 				     'LNM$FILE_DEV',PSL$C_USER) ;': 	    IF NOT ((Rst = SS$_NOLOGNAM) OR Secure_Logical)  THEN# 	       LIB$SIGNAL (Jump__Invlnm,1,b7 			   %STDESCR SUBSTR (Dest_Addr,1,Dest_Addr.LENGTH)) ;(
 	    END ; 	 END ;)       END ; $   END ; 	{ of Validate_Notify_List }       BEGIN 	{ Validate_Access }  G   { Check that the invoker has the required access to run this program.XH     This is independant of any installed privileges.  Identify SysProgs.D     If need be, check to see if process has JUMP_ACCESS rights ID. }     IF Double_Check  THEN,
      BEGINI      IF NOT Parse_Ident ('JUMP_ACCESS',Jump_Id,Rst,1)  THEN	{ Rights ID }_ 	$EXIT (Jump__Ivident) ;
      I := 1 ;       REPEATt:        Chekov := Jump_Id.UIC$L_UIC = Caller_Rights[I].L0 ;        I := I + 1 ;=&      UNTIL Chekov OR (I > Rightsize) ;
      END ;  B   Id_Check_Ok := (Double_Check AND Chekov) OR (NOT Double_Check) ;  G   IF NOT Real_Mccoy  THEN               { For "poor man's" JUMP only. }r
      BEGINN      IF Proc_Cnt > 0  THEN              { Don't jump if we have subprocesses } 	$EXIT (Jump__Nosub) ;  M      IF Pid <> Master_Pid  THEN         { Don't jump if we are a subprocess }  	$EXIT (Jump__Noinsub) ;
      END ;  "   IF Figment AND NOT Sysprog  THEN      $EXIT (Jump__Nopriv) ;S     IF NOT Get_Target_Info  THENE      IF Figment AND Alter_Ego AND NOT (Transmute OR Real_Mccoy)  THENI 	LIB$SIGNAL (Jump__Invuser)'
       ELSE% 	LIB$STOP (Jump__Invuser) ;	{ Fatal }p  &   Access := Check_Access_And_Options ;  5   Priv_Target := ((Auth_Priv - Minor_Privs) <> []) OR	' 		 ((Def_Priv  - Minor_Privs) <> []) ORs+ 		 (New_Uic.UIC$V_GROUP <= Max_Sys_Group) ;o     IF (NOT (Sysprog OR + 	   ((Access = Granted) AND Id_Check_Ok) OR  	   ((Access <> Denied) ANDE' 	    ((Operator AND NOT Priv_Target) OR}2 	    ((New_User = Orig_User) AND Narcissus))))) OR&      (NOT Auditing AND NOT Sysprog) OR&      (Alter_Ego AND NOT Sysprog)  THEN        BEGIN        Audit_Jump (FALSE) ;         $EXIT (Jump__Nopriv) ;H        END ;  E   IF Alter_Ego AND (New_User = Orig_User)  THEN 	{ Change username? }r
      BEGIN"      LIB$SIGNAL (Jump__Sameuser,1,4 		 %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH)) ;      $EXIT ;
      END ;     IF Transmute ANDG      (New_Uic.UIC$L_UIC = Orig_Uic.UIC$L_UIC)  THEN { Change UIC etc? }o
      BEGIN=      LIB$SIGNAL (Jump__Sameuic,1,%IMMED Orig_Uic.UIC$L_UIC) ;p      $EXIT ;
      END ;  (   IF Sysprog AND (Access = Denied)  THEN       LIB$SIGNAL (Jump__Denied) ;  H   IF (Target_Flags.UAI$V_RESTRICTED OR Target_Flags.UAI$V_CAPTIVE)  THEN
      BEGIN+      IF Sysprog OR (Access = Granted)  THEN{ 	LIB$SIGNAL (Jump__Restrict)
       ELSE' 	LIB$STOP (Jump__Restrict) ;		{ Fatal }_  F      IF Escape_Hatch  THEN                      { Don't allow escape } 	BEGIN 	Escape_Hatch := FALSE ; 	LIB$SIGNAL (Jump__Noescape) ; 	END ;
      END ;  %   IF Target_Flags.UAI$V_DISACNT  THENA      IF Figment  THEN  	LIB$SIGNAL (Jump__Disabled)
       ELSE' 	LIB$STOP (Jump__Disabled) ;		{ Fatal }.  A   IF Secure_Mode AND Notify.By_Mail  THEN  Validate_Notify_List ;    END ; 	{ of Validate_Access }o    , [ASYNCHRONOUS] FUNCTION Mail_Error_Handler ( 			VAR Sa : Sig_Args;C+ 			VAR Ma : Mech_Args) : [UNSAFE] INTEGER ;:  F { A simple handler that always allows MAIL to handle the condition ...G   but ensures the status returned is accurate!	This is required for the)C   MAIL$SEND_MESSAGE routine which fails to return its status to theB   caller! 8-(( }     BEGIN <   Mail_Error_Status  := Sa[1] ; 	{ Primary condition value }A   Mail_Error_Handler := SS$_RESIGNAL ;	{ Propagate back to MAIL }(   END ;'    P FUNCTION Send_Mail_Message (To_Address : PACKED ARRAY [L0..H0:INTEGER] OF CHAR ;; 			    Subj_Line  : PACKED ARRAY [L1..H1:INTEGER] OF CHAR ;o9 			    Msg_Text   : PACKED ARRAY [L2..H2:INTEGER] OF CHARB 		) : INTEGER ;k  K { Send a mail message using Callable MAIL.  The Msg_Text is treated firstlyeE   as the file specification of a message file to be used in a call to.L   MAIL$SEND_ADD_BODYPART.  If it is not a valid specification of an existingG   file, the Msg_Text will be inserted into the mail message verbatim. }o  !   VAR  I , Rst	 : INTEGER  := 0 ;B        Mail_Ctx  ,,        Context	 : [VOLATILE] UNSIGNED := 0 ;2        Mail_List : Item_List_Template(2) := ZERO ;        Addr_List,.?        Dest_Addr : STRING (MAX(510,SIZE(To_Address))) := ZERO ;         Msg_Buff,4        Msg_Line  : STRING (SIZE(Msg_Text)) := ZERO ;0        Msg_File  : VARYING [255] OF CHAR := '' ;        Dis_File  : TEXT ;9  (   FUNCTION Distribution_List : INTEGER ;  $     VAR  Rst , Spot : INTEGER := 0 ; 	 Done : BOOLEAN := FALSE ;        BEGIN	{ Distribution_List }GK     Dest_Addr := SUBSTR (Dest_Addr,2,LENGTH(Dest_Addr)-1) ;  { Remove "@" }        High_Security := TRUE ;EL     OPEN (Dis_File,FILE_NAME:=Dest_Addr,HISTORY:=READONLY,SHARING:=READONLY,6 		   USER_ACTION:=Special_File_Open,Error:=CONTINUE) ;     Rst := STATUS (Dis_File) ;  !     IF Rst <> PAS$K_SUCCESS  THEN D        Rst := Condition_Code (Rst)	{ Map to a condition code value }	      ELSE         BEGIN        RESET (Dis_File) ; -        WHILE NOT (Done OR EOF (Dis_File))  DO  	 BEGIN_ 	 READLN (Dis_File,Dest_Addr) ;n+ 	 Str_Compress (Dest_Addr,Dest_Addr,TRUE) ;I! 	 Spot := INDEX (Dest_Addr,'!') ;D 	 IF Spot > 1  THENr/ 	    Dest_Addr := SUBSTR (Dest_Addr,1,Spot-1) ;o 	 IF Spot <> 1  THEN
 	    BEGIN7 	    Mail_List[1].Buffer_Length := LENGTH (Dest_Addr) ;VB 	    Rst := MAIL$SEND_ADD_ADDRESS (Mail_Ctx,Mail_List,Null_List) ; 	    Done := NOT ODD (Rst) ;
 	    END ; 	 END ;T        CLOSE (Dis_File) ;i        END ;     Distribution_List := Rst ;"     END ;	{ of Distribution_List }     BEGIN 	{ Send_Mail_Message }  #   { Prepare the Mail SEND context }   9   Rst := MAIL$SEND_BEGIN (Mail_Ctx,Null_List,Null_List) ;;+   IF Notify.Vamoose AND NOT ODD (Rst)  THENS"      LIB$SIGNAL (Jump__Mailfail) ;      { Set up the To: address(es) }  7   Mail_List[1].Buffer_Length := 0 ;			{ Initially ... } 5   Mail_List[1].Item_Code     := MAIL$_SEND_USERNAME ;(;   Mail_List[1].Buffer_Addr   := IADDRESS (Dest_Addr.BODY) ;v#   Mail_List[1].Return_Addr   := 0 ;   ?   Mail_List[2].Terminator    := 0 ;	{ Terminate the item list })     Addr_List := To_Address ;S  !   WHILE LENGTH (Addr_List) > 0	DOF	     BEGINb      I := INDEX (Addr_List,',') ;     IF I > 0  THEN        BEGIN.        Dest_Addr := SUBSTR (Addr_List,1,I-1) ;@        Addr_List := SUBSTR (Addr_List,I+1,LENGTH(Addr_List)-I) ;
        END	      ELSEI        BEGIN        Dest_Addr := Addr_List ;b        Addr_List := '' ;        END ;#     IF LENGTH (Dest_Addr) > 0  THEN>        BEGIN"        IF Dest_Addr[1] = '@'  THEN 	  Rst := Distribution_List  	ELSED 	  BEGIN5 	  Mail_List[1].Buffer_Length := LENGTH (Dest_Addr) ;G@ 	  Rst := MAIL$SEND_ADD_ADDRESS (Mail_Ctx,Mail_List,Null_List) ; 	  END ;0        IF Notify.Vamoose AND NOT ODD (Rst)  THEN  	  LIB$SIGNAL (Jump__Mailfail) ;        END ;	     END ;D     { Set up the Subject line }   4   Mail_List[1].Buffer_Length := LENGTH (Subj_Line) ;4   Mail_List[1].Item_Code     := MAIL$_SEND_SUBJECT ;6   Mail_List[1].Buffer_Addr   := IADDRESS (Subj_Line) ;#   Mail_List[1].Return_Addr   := 0 ;t  #   Mail_List[2].Terminator    := 0 ;   A   Rst := MAIL$SEND_ADD_ATTRIBUTE (Mail_Ctx,Mail_List,Null_List) ; +   IF Notify.Vamoose AND NOT ODD (Rst)  THENm"      LIB$SIGNAL (Jump__Mailfail) ;  I   { Determine if Msg_Text is a valid specification of an existing file. }o  -   Rst := LIB$FIND_FILE (Filespec := Msg_Text,_) 			Resultant_Filespec := %DESCR Msg_File,s 			Context  := Context, " 			Flags	 := 0) ;	{ No wildcards }  0   IF ODD (Rst)	THEN	{ File exists - attach it. }
      BEGIN6      Mail_List[1].Buffer_Length := LENGTH (Msg_Text) ;4      Mail_List[1].Item_Code	:= MAIL$_SEND_FILENAME ;6      Mail_List[1].Buffer_Addr	:= IADDRESS (Msg_Text) ;$      Mail_List[1].Return_Addr	:= 0 ;  #      Mail_List[2].Terminator	:= 0 ;]  C      Rst := MAIL$SEND_ADD_BODYPART (Mail_Ctx,Mail_List,Null_List) ;L.      IF Notify.Vamoose AND NOT ODD (Rst)  THEN 	LIB$SIGNAL (Jump__Mailfail) ;      ENDF    ELSE 	{ Split Msg_Text at LF characters and send record by record }
      BEGIN4      Mail_List[1].Item_Code   := MAIL$_SEND_RECORD ;;      Mail_List[1].Buffer_Addr := IADDRESS (Msg_Line.BODY) ;Y      Msg_Buff := Msg_Text ;d$      WHILE LENGTH (Msg_Buff) > 0  DO        BEGIN!        I := INDEX (Msg_Buff,Lf) ;o        IF I > 0 THEN 	  BEGIN( 	  Msg_Line := SUBSTR (Msg_Buff,1,I-1) ;9 	  Msg_Buff := SUBSTR (Msg_Buff,I+1,LENGTH(Msg_Buff)-I) ;L 	  END 	ELSEo 	  BEGIN 	  Msg_Line := Msg_Buff ;  	  Msg_Buff := '' ;I 	  END ;8        Mail_List[1].Buffer_Length := LENGTH (Msg_Line) ;E        Rst := MAIL$SEND_ADD_BODYPART (Mail_Ctx,Mail_List,Null_List) ;(0        IF Notify.Vamoose AND NOT ODD (Rst)  THEN  	  LIB$SIGNAL (Jump__Mailfail) ;        END ;
      END ;  B   { The message is complete.  Let's send it.  Mail_Error_Status isI     updated by the error handler ... so we can handle errors correctly. }i  "   ESTABLISH (Mail_Error_Handler) ;;   Rst := MAIL$SEND_MESSAGE (Mail_Ctx,Null_List,Null_List) ;t
   REVERT ;     IF Notify.Vamoose AND       ((NOT ODD (Rst)) OR*       (NOT ODD (Mail_Error_Status)))  THEN"      LIB$SIGNAL (Jump__Mailfail) ;   Send_Mail_Message := Rst ;  7   Rst := MAIL$SEND_END (Mail_Ctx,Null_List,Null_List) ;S+   IF Notify.Vamoose AND NOT ODD (Rst)  THENS"      LIB$SIGNAL (Jump__Mailfail) ;!   END ; 	{ of Send_Mail_Message }      PROCEDURE Update_Uaf ;  F { Set the Last Interactive Login time, and reset the Login Failures to	   zero. }J     VAR	Fails : $UWORD := 0 ;  	Rst : UNSIGNED := 0 ; 	Now : $UQUAD := ZERO ; - 	Item_List : Item_List_Template (3) := ZERO ;N     BEGIN 	{ Update_UAF }a   GETTIMESTAMP (Time_Now) ;a   Now := Time_Now.Binary_Time ;(  #   Item_List[1].Buffer_Length := 2 ; /   Item_List[1].Item_Code     := UAI$_LOGFAILS ;P2   Item_List[1].Buffer_Addr   := IADDRESS (Fails) ;#   Item_List[1].Return_Addr   := 0 ;;  #   Item_List[2].Buffer_Length := 8 ; 2   Item_List[2].Item_Code     := UAI$_LASTLOGIN_I ;0   Item_List[2].Buffer_Addr   := IADDRESS (Now) ;#   Item_List[2].Return_Addr   := 0 ;m  ?   Item_List[3].Terminator    := 0 ;	{ Terminate the item list }   I   Rst := $SETUAI (Usrnam := %STDESCR SUBSTR (New_User,1,New_User.LENGTH),  		  Itmlst := Item_List) ;  3   IF NOT ODD (Rst) AND_THEN (Rst <> RMS$_RNF)  THENs      LIB$SIGNAL (Rst) ;    END ; 	{ of Update_UAF }      PROCEDURE Getmem (VAR Location ,2 		  Pointer  : [UNSAFE] Unsigned_Ptr) ; EXTERNAL ;    PROCEDURE Putmem (VAR Location ,2 		  Pointer  : [UNSAFE] Unsigned_Ptr) ; EXTERNAL ;  9 [ASYNCHRONOUS,Check(None)] PROCEDURE Getuser ; EXTERNAL ;r  9 [ASYNCHRONOUS,Check(None)] PROCEDURE Setuser ; EXTERNAL ;   A PROCEDURE Change_Persona (New_Username : VARYING [Len] OF CHAR) ;, 			    EXTERNAL ;t  A PROCEDURE Change_Username (New_Username : VARYING [Len] OF CHAR ;(" 			   Faking : BOOLEAN := FALSE) ; 			     EXTERNAL ;  * PROCEDURE Change_Uic (New_Uic : UIC$TYPE ;$ 		      Faking : BOOLEAN := FALSE) ;
 			EXTERNAL ;A   PROCEDURE Kangaroo ;  H { Do all that is required to JUMP /NOEXACT to the new user, or to return9   to the original user.  This is the "poor man's" jump. }p  (   VAR	Rst , Attributes : UNSIGNED := 0 ;& 	Aclstr : VARYING [64] OF CHAR := '' ;. 	Aclent : PACKED ARRAY [1..32] OF CHAR := '' ;. 	Grptbl : PACKED ARRAY [1..16] OF CHAR := '' ;- 	Item_List : Item_List_Template (3) := ZERO ;R     BEGIN 	{ Kangaroo }   0   Change_Uic (New_Uic) ;	{ *** Set new UIC *** }      { Set new default directory. }     Set_Default_Dir (Def_Dir) ;d     { Set new default disk. }N  0   Item_List[1].Buffer_Length := Def_Dev.LENGTH ;-   Item_List[1].Item_Code     := LNM$_STRING ;A9   Item_List[1].Buffer_Addr   := IADDRESS (Def_Dev.BODY) ; #   Item_List[1].Return_Addr   := 0 ;Z  #   Item_List[2].Terminator    := 0 ;   3   Rst := $CRELNM (Tabnam := %STDESCR 'LNM$PROCESS', " 		  Lognam := %STDESCR 'SYS$DISK', 		  Acmode := PSL$C_SUPER, 		  Itmlst := Item_List) ;
   Zip (Rst) ;t  9   { Point LNM$GROUP logical to group table for new UIC. }       Attributes := LNM$M_TERMINAL ;:   Grptbl := 'LNM$GROUP_' + OCT (New_Uic.UIC$V_GROUP,6,6) ;  #   Item_List[1].Buffer_Length := 4 ;o1   Item_List[1].Item_Code     := LNM$_ATTRIBUTES ;e7   Item_List[1].Buffer_Addr   := IADDRESS (Attributes) ; #   Item_List[1].Return_Addr   := 0 ;   /   Item_List[2].Buffer_Length := SIZE (Grptbl) ; -   Item_List[2].Item_Code     := LNM$_STRING ;V3   Item_List[2].Buffer_Addr   := IADDRESS (Grptbl) ;e#   Item_List[2].Return_Addr   := 0 ;T  #   Item_List[3].Terminator    := 0 ;A  =   Rst := $CRELNM (Tabnam := %STDESCR 'LNM$PROCESS_DIRECTORY',s# 		  Lognam := %STDESCR 'LNM$GROUP',a 		  Acmode := PSL$C_KERNEL,R 		  Itmlst := Item_List) ;
   Zip (Rst) ;A  M   { If going to a different UIC, allow the current LNM$JOB logical name tableCM     to be accessed by the new UIC.  If returning to original user, remove the $     ACL access previously applied. }      Item_List[2].Terminator := 0 ;  =   IF New_User = Orig_User  THEN 	{ Return to original user. })
      BEGIN&      Item_List[1].Buffer_Length := 0 ;0      Item_List[1].Item_Code	:= ACL$C_DELETEACL ;$      Item_List[1].Buffer_Addr	:= 0 ;$      Item_List[1].Return_Addr	:= 0 ;      END)    ELSE 				{ Allow access to new user. }i
      BEGIN      Format_User (New_Uic) ;A      Aclstr := '(IDENTIFIER=' + Uic_Str + ',ACCESS=READ+WRITE)' ;oG      Rst := $PARSE_ACL (Aclstr := SUBSTR (Aclstr.BODY,1,Aclstr.LENGTH),C 			Aclent := %STDESCR Aclent) ;x      Zip (Rst) ;  4      Item_List[1].Buffer_Length := INT (Aclent[1]) ;0      Item_List[1].Item_Code	:= ACL$C_ADDACLENT ;4      Item_List[1].Buffer_Addr	:= IADDRESS (Aclent) ;$      Item_List[1].Return_Addr	:= 0 ;
      END ;  9   Rst := $CHANGE_ACL (Objtyp := ACL$C_LOGICAL_NAME_TABLE,1 		      Objnam := 'LNM$JOB', 		      Itmlst := Item_List) ;
   Zip (Rst) ;R   END ; 	{ of Kangaroo }     PROCEDURE Display_Jump ;  4 { Display data about the requested non-exact jump. }     BEGIN 	{ Display_Jump }1   IF Transmute	THENW
      BEGIN       LIB$SIGNAL (Jump__Jumped,4,2 		 %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH),0 		 %STDESCR SUBSTR (New_User,1,New_User.LENGTH),. 		 %STDESCR SUBSTR (Uic_Str,1,Uic_Str.LENGTH),4 		 %STDESCR SUBSTR (Eq_Id_Str,1,Eq_Id_Str.LENGTH)) ;!      LIB$SIGNAL (Jump__Default,2, - 		 %STDESCR SUBSTR(Def_Dev,1,Def_Dev.LENGTH),;/ 		 %STDESCR SUBSTR(Def_Dir,1,Def_Dir.LENGTH)) ;i
      END ;     IF Alter_Ego	THEN !      LIB$SIGNAL (Jump__Setuser,2,a2 		 %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH),2 		 %STDESCR SUBSTR (New_User,1,New_User.LENGTH)) ;   END ; 	{ of Display_Jump }    6 PROCEDURE Get_Channel (Device : VARYING [L1] OF CHAR ;+ 		       VAR Channel : [VOLATILE] $UWORD) ;S  ! { Assign a channel to a device. }w     VAR Rst : UNSIGNED := 0 ;F     BEGIN 	{ Get_Channel }#   Rst := $ASSIGN (Devnam := Device,t 		  Chan	 := Channel) ;:
   Zip (Rst) ;o   END ; 	{ of Get_Channel }t    / PROCEDURE Exit_Handler (Condition : UNSIGNED) ;e  L { For an EXACT JUMP only, clean up after the pseudo-terminal session ends or   on abnormal termination. }     VAR Rst  : UNSIGNED := 0 ;(       Iosb : Status_Block_Type := ZERO ;     BEGIN 	{ Exit_Handler }S  #   $SETAST (0) ; 			{ Disable ASTs }F  M   { If recording session for an EXACT jump, be sure the log file is closed. }      IF Record_Session  THEN &      CLOSE (Logfile,Error:=CONTINUE) ;  +   { Restore username and UIC if required. }D     IF Use_Persona  THEN      Change_Persona (Orig_User)     ELSES
      BEGIN"      IF New_User <> Orig_User THEN 	BEGINI 	New_User.BODY := PAD ('',' ',Max_Username_Len) ;     { Totally blat it }a 	New_User := Orig_User ;E 	Change_Username (New_User) ;	{ *** Change to original username *** }r 	END ;  4      IF New_Uic.UIC$L_UIC <> Orig_Uic.UIC$L_UIC THEN 	BEGIN 	New_Uic := Orig_Uic ;; 	Change_Uic (New_Uic) ;		{ *** Change to original UIC *** }0 	END ;
      END ;     IF Pchan_Created  THEN      IF Pseudo_Ft  THENo 	BEGIN> 	Rst := PTD$CANCEL (Pchan) ;	{ Cancel I/O to pseudo-terminal } 	Zip (Rst) ;  7 	Rst := PTD$DELETE (Pchan) ;	{ Delete pseudo-terminal }$ 	Zip (Rst) ; 	END
       ELSE8 	$DASSGN (Pchan) ;		{ Deassign pseudo-terminal channel }  6   $CANCEL (Rchan) ;			{ Cancel I/Os on real terminal }  D   Rst := $QIOW (Chan := Rchan,		{ Restore original characteristics } 		Func := IO$_SETMODE, 		Iosb := Iosb,. 		P1   := Rchars,N 		P2   := 12) ;'   Zip (Rst,Iosb[1]) ;U  '   $DASSGN (Rchan) ;			{ Shut up shop. }   .   { Clean up process attributes (if any) ... }  )   Rst := $DELLNM (Tabnam := 'LNM$SYSTEM', - 		  Lognam := 'JUMP_' + HEX (Pseudo_Pid,8,8),{ 		  Acmode := PSL$C_EXEC) ;B2   IF NOT (ODD (Rst) OR (Rst = SS$_NOLOGNAM))  THEN      LIB$SIGNAL (Rst) ;$     END ; 	{ of Exit_Handler }    J [ASYNCHRONOUS] PROCEDURE Get_Proc_Info (Target_Pid : [VOLATILE] UNSIGNED ; 					VAR Prccnt , + 					    Jobprccnt : [VOLATILE] UNSIGNED) ;)  7 { Get some process information for the specified PID. }a     VAR	Rst : INTEGER := 0 ;# 	Iosb : Status_Block_Type := ZERO ;,- 	Item_List : Item_List_Template (3) := ZERO ;n     BEGIN 	{ Get_Proc_Info }#   Item_List[1].Buffer_Length := 4 ;e-   Item_List[1].Item_Code     := JPI$_PRCCNT ;I3   Item_List[1].Buffer_Addr   := IADDRESS (Prccnt) ; #   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Buffer_Length := 4 ; 0   Item_List[2].Item_Code     := JPI$_JOBPRCCNT ;6   Item_List[2].Buffer_Addr   := IADDRESS (Jobprccnt) ;#   Item_List[2].Return_Addr   := 0 ;n  ?   Item_List[3].Terminator    := 0 ;	{ Terminate the item list }   (   Rst := $GETJPIW (Pidadr := Target_Pid, 		   Itmlst := Item_List,) 		   Iosb   := Iosb) ;     Zip (Rst,Iosb[1]) ;O   END ; 	{ of Get_Proc_Info }d    > [ASYNCHRONOUS] PROCEDURE Inject (Str : VARYING [Len] OF CHAR ;
 				 Pseudo ,y" 				 See_This : BOOLEAN := TRUE) ;  + { Inject a string into a terminal buffer. }d  %   VAR  Choice , Rst : UNSIGNED := 0 ;      BEGIN 	{ Inject }    IF Bugger.D1	THENH
      BEGIN,      WRITELN (Dbgfile,'+++ INJECTING +++') ;%      WRITELN (Dbgfile,'PUSH: ',Str) ;t
      END ;      IF Pseudo  THEN  Choice := 1 ;     Viewable := See_This ;     CASE Choice  OFe     1: BEGIN        FOR Rst := 1 TO Len  DO* 	   Buffer.One[Wsts*2+2+Rst] := Str[Rst] ;          IF Pseudo_Ft  THEN_ 	  BEGIN) 	  Rst := PTD$WRITE (Chan       := Pchan, & 			    Wrtbuf     := Buffer.Raw[Wsts], 			    Wrtbuf_Len := Len) ;  	  Zip (Rst) ; 	  END 	ELSEa 	  BEGIN" {W}	  Rst := $QIOW (Chan := Pchan, 			Func := IO$_WRITEVBLK,u 			P1   := Buffer.Raw[Wsts], 			P2   := Len) ;  	  Zip (Rst) ; 	  END ;        END ;     0: BEGIN        IF Pseudo_Ft  THEN, 	  BEGIN 	  FOR Rst := 1 TO Len  DO- 	      Buffer.One[Rbuf*2+2+Rst] := Str[Rst] ;+ 	  Rst := $QIOW (Chan := Rchan,H 			Func := IO$_WRITEVBLK,_ 			P1   := Buffer.Raw[Rbuf], 			P2   := Len) ;  	  Zip (Rst) ; 	  END 	ELSE+ 	  BEGIN 	  FOR Rst := 1 TO Len  DO- 	      Buffer.One[Rsts*2+2+Rst] := Str[Rst] ;C 	  Rst := $QIOW (Chan := Rchan,  			Func := IO$_WRITEVBLK,E 			P1   := Buffer.Raw[Rsts], 			P2   := Len) ;N
 	 Zip (Rst) ;N 	 END ;,        END ;     END ;	{ of Case }1     IF Bugger.D1	THEN +      WRITELN (Dbgfile,'=== INJECTED ===') ;;   END ; 	{ Inject }'    $ [ASYNCHRONOUS] PROCEDURE Rchan_Ast ;  J { Called when a keystroke occurs on the real keyboard - the keystrokes areL   passed to the pseudo-terminal and another read queued.  If escaping, avoid3   all read/write activity and simply wake up Mum. }t     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Rchan_Ast}iA   IF Escape_Hatch AND_THEN (Buffer.One[Wsts*2+3] = Ripcord)  THENa
      BEGIN2      LIB$SIGNAL (Jump__Userabort) ;		{ Bail out! }0      Jeronimo := TRUE ; 			{ Pull the ripcord! }      Rst := $WAKE ;       Zip (Rst) ;      END    ELSEb   IF Pseudo_Ft	THENm
      BEGIN'      Rst := PTD$WRITE (Chan	  := Pchan,P& 		       Wrtbuf	  := Buffer.Raw[Wsts], 		       Wrtbuf_Len := 1) ;P      Zip (Rst) ;  !      Rst := $QIO (Chan	 := Rchan,f 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer.Raw[Wbuf], 		  P2	 := 1) ;       Zip (Rst) ;      END    ELSE 
      BEGIN       Rst := $QIO (Chan := Pchan, 		  Func := IO$_WRITEVBLK, 		  P1   := Buffer.Raw[Wsts],l 		  P2   := 1) ;      Zip (Rst) ;  !      Rst := $QIO (Chan	 := Rchan,N 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer.Raw[Wsts], 		  P2	 := 1) ;T      Zip (Rst) ;
      END ;   END ; 	{ of Rchan_Ast }     $ [ASYNCHRONOUS] PROCEDURE Pchan_Ast ;  M { Called when characters are received from the pseudo-terminal - the data arem6   passed to the real screen and another read queued. }  .   CONST  Jump_Guillotine = 'JUMP_GUILLOTINE' ;     VAR  Rst ,!        Null_Pos : UNSIGNED := 0 ; %        I , J , K , M : INTEGER := 0 ;         Spawned ,%        Prompting : BOOLEAN := FALSE ;N5        Current_Prompt : VARYING [255] OF CHAR := '' ;:=        Log_Buffer : VARYING [SIZE(Io_Buffer)] OF CHAR := '' ;   2        Was_Spawned   : [STATIC] BOOLEAN := FALSE ;1        Green_Process : [STATIC] BOOLEAN := TRUE ;         Stage ,&        Cycle : [STATIC] INTEGER := 0 ;:        Dcl_Prompt : [STATIC] VARYING [255] OF CHAR := '' ;     BEGIN 	{ Pchan_Ast }  2   { Make it easy to work with the returned text. }     IF Buffer.Raw[Rcnt] > 0  THENtJ      STR$COPY_R (%DESCR Log_Buffer,Buffer.Raw[Rcnt],%REF Buffer.Raw[Rbuf])    ELSEf      Log_Buffer := '' ;r     IF Single_Cmd_Mode  THEN
      BEGIN      Cycle := Cycle + 1 ;_      IF Bugger.D1  THEN ; 	WRITELN (Dbgfile,'Pchan_Ast: --- Cycle ',Cycle:1,' ---') ;   G      { If using PERSONA calls, we need to temporarily enable some extra_)        privileges for the $GETJPI call. }I        IF Use_Persona  THEN 4 	$SETPRV (Enbflg := %IMMED 1,		{ Enable extra privs}% 		 Prvadr := Single_Cmd_Mode_Privs) ;a  ?      Get_Proc_Info (Pseudo_Pid,Proc_Cnt_Now,Job_Proc_Cnt_Now) ;C        IF Use_Persona  THENe5 	$SETPRV (Enbflg := %IMMED 0,		{ Disable extra privs}a% 		 Prvadr := Single_Cmd_Mode_Privs) ;   ,      Spawned := (Proc_Cnt_Now > Proc_Cnt) OR% 		(Job_Proc_Cnt_Now > Job_Proc_Cnt) ;t,      Was_Spawned := Spawned OR Was_Spawned ;  *      Null_Pos := INDEX (Log_Buffer,Null) ;  <      { If debugging, write the new text to the debug file or        dump it to the screen. }         IF Bugger.D1  THEN  	BEGIN  	K := Log_Buffer.LENGTH DIV 20 ;  	M := Log_Buffer.LENGTH REM 20 ;3 	WRITELN (Dbgfile,'BufLen: ',Log_Buffer.LENGTH:1) ;c, 	WRITELN (Dbgfile,'NULL Pos: ',Null_Pos:1) ; 	WRITE (Dbgfile,'Buffer:') ; 	FOR I := 1 TO K  DO
 	    BEGIN 	    FOR J := 1 TO 20  DOU3 		WRITE (Dbgfile,HEX(Log_Buffer[(I-1)*20+J],3,2)) ;  	    WRITELN (Dbgfile) ;0 	    IF M > 0  THEN  WRITE (Dbgfile,'       ') ;
 	    END ;C 	FOR I := 1 TO M  DO  WRITE (Dbgfile,HEX(Log_Buffer[K*20+I],3,2)) ;T 	WRITELN (Dbgfile,Lf) ;D 	END ;  6      IF Bugger.D1 AND_THEN NOT Debug_To_Terminal  THEN? 	  WRITELN (Dbgfile,'Buffer: ',Lf+Log_Buffer,Error:=CONTINUE) ;)  *      Prompting := ((Null_Pos = 2) AND_THEN8 		    ((Log_Buffer[1] = Lf) OR (Log_Buffer[1] = Cr))) OR 		  ((Null_Pos = 3) AND_THEN+ 		    ((SUBSTR (Log_Buffer,1,2) = Cr+Lf) OR>* 			  (SUBSTR (Log_Buffer,1,2) = Lf+Cr))) ;      IF Prompting  THENX1 	Current_Prompt := SUBSTR (Log_Buffer,Null_Pos+1,e# 				  Log_Buffer.LENGTH-Null_Pos) ;T  A      { At process initiation, determine what the DCL prompt is. }a  O      IF Green_Process AND_THEN Prompting  THEN	  { Have not seen first prompt }  	BEGIN 	Dcl_Prompt := Current_Prompt ;' 	Green_Process := FALSE ;  	IF Bugger.D1  THENa< 	   WRITELN (Dbgfile,'Pchan_Ast: DCL_Prompt: ',Dcl_Prompt) ; 	END ;  -      IF Prompting AND NOT Green_Process  THENt 	BEGIN 	Stage := Stage + 1 ;  	IF Bugger.D1  THEN		 	   BEGINO1 	   WRITELN (Dbgfile,'Prompt: ',Current_Prompt) ;,* 	   WRITELN (Dbgfile,'Stage:  ',Stage:1) ;	 	   END ;    	CASE Stage OF: 	  1: Inject ('SET PROMPT = '+Jump_Guillotine+Cr,,FALSE) ; 	  2: Inject (Lf+Cr+Null) ;t# 	  3: Inject ('$ '+Single_Cmd+Cr) ;a 	  4: BEGINa 	     Inject (Cr) ;L 	     IF Spawned  THEN 		LIB$SIGNAL (Jump__Nospawn) ; 	     END ;i2 	  5: Inject ('JUMP_SQUISHER :== EOJ'+Cr,,FALSE) ; 	  6: BEGINt* 	     Inject ('JUMP_SQUISHER'+Cr,,FALSE) ; 	     IF Was_Spawned  THEN 		BEGIN  		Was_Spawned := FALSE ; 		Stage := 3 ; 		END ;{ 	     END ;aH 	  OTHERWISE LIB$SIGNAL (Jump__Intabort1) ; { Report to JUMP developer } 	  END ; { of Case }  G 	Visible := Viewable AND NOT (INDEX (Log_Buffer,Jump_Guillotine) > 0) ;  	END
       ELSE 	BEGIN 	Visible := Viewable ; 	Viewable := TRUE ;e 	END ;        IF Bugger.D1  THEND 	BEGIN' 	WRITELN (Dbgfile,'Spawned:',Spawned) ;=' 	WRITELN (Dbgfile,'Visible:',Visible) ; & 	IF Visible  THEN  WRITELN (Dbgfile) ; 	END ;      END ;	{ Single_Cmd_Mode }  7   { If recording, write the new text to the log file. }   %   IF Record_Session AND Visible  THEN E      WRITELN (Logfile,Log_Buffer,Error:=CONTINUE) ;	{ Ignore errors }      IF Pseudo_Ft	THENy
      BEGIN      IF Visible  THENy 	BEGIN 	Rst := $QIOW (Chan := Rchan,t 		      Func := IO$_WRITEVBLK,! 		      P1   := Buffer.Raw[Rbuf],E# 		      P2   := Buffer.Raw[Rcnt]) ;E 	Zip (Rst) ; 	END ;  &      Rst := PTD$READ (Chan	  := Pchan, 		      Astadr	  := Pchan_Ast,& 		      Readbuf	  := Buffer.Raw[Rsts],# 		      Readbuf_Len := Ft_Buflen) ;'      Zip (Rst) ;      END    ELSEd
      BEGIN      IF Visible  THENo 	BEGIN 	Rst := $QIOW (Chan := Rchan,  		      Func := IO$_WRITEVBLK,! 		      P1   := Buffer.Raw[Rsts],_ 		      P2   := Piosb[2]) ;I 	Zip (Rst) ; 	END ;  !      Rst := $QIO (Chan	 := Pchan,f 		  Func	 := IO$_READVBLK, 		  Iosb	 := Piosb,n 		  Astadr := Pchan_Ast, 		  P1	 := Buffer.Raw[Rsts], 		  P2	 := Py_Buflen) ;O      Zip (Rst) ;
      END ;   END ; 	{ of Pchan_Ast }E      [ASYNCHRONOUS] PROCEDURE Mbast ;  F { Invoked by the detached process termination mailbox AST - WAKE UP! }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ MBast }  F   { Try to avoid any issues with typeahead buffer and EXACT log file }     IF Record_Session  THENH
      BEGIN       Rst := PTD$CANCEL (Pchan) ;      Zip (Rst) ;
      END ;     Rst := $WAKE ;
   Zip (Rst) ;;   END ; 	{ of MBast }D    ( [ASYNCHRONOUS] PROCEDURE Send_Bell_Ast ;    { Bell event notification AST. }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Send_BELL_AST }   Rst := $QIO (Chan := Rchan,F 	       Func := IO$_WRITEVBLK, 	       P1   := Bell,r 	       P2   := 1) ;
   Zip (Rst) ;$   END ; 	{ of Send_BELL_AST }     ' [ASYNCHRONOUS] PROCEDURE Send_Xon_Ast ;	   { Xon event notification AST. };     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Send_XON_AST }g   Rst := $QIO (Chan := Rchan,, 	       Func := IO$_WRITEVBLK, 	       P1   := Xon, 	       P2   := 1) ;
   Zip (Rst) ;S   END ; 	{ of Send_XON_AST }    ( [ASYNCHRONOUS] PROCEDURE Send_Xoff_Ast ;    { Xoff event notification AST. }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Send_XOFF_AST }   Rst := $QIO (Chan := Rchan,i 	       Func := IO$_WRITEVBLK, 	       P1   := Xoff,D 	       P2   := 1) ;
   Zip (Rst) ;G   END ; 	{ of Send_XOFF_AST }      PROCEDURE Transmography ;   L { Create a pseudo-terminal connected to a detached process and actually *be*#   the user!  This is JUMP /EXACT. }e     CONSTn  N   Subversion_Msg = '**** JUMP WARNING!! Attempt to subvert Secure Mode ****' ;     TYPE  8   Desc_Blk = PACKED RECORD			{ Exit handler descriptor } 	       Fwd_Link : UNSIGNED ;t& 	       Exit_Handler_Addr : UNSIGNED ; 	       Argcnt : $UBYTE ; 5 	       Fill_Zero : [UNSAFE] ARRAY [1..3] OF $UBYTE ;b 	       Condition ,I0 	       P2 , P3 , P4 , P5 , P6 , P7 : UNSIGNED ; 	     END VALUE ZERO ;     VAR   $   Modify_Sysprv : BOOLEAN := FALSE ;+   Rst , Mbunit , Stsflags : UNSIGNED := 0 ;a.   Pctl : [VOLATILE,LONG] Prtctl_Type := ZERO ;)   Pctl_Ptr : [VOLATILE] Word_Ptr := NIL ;	   Rucb , Pucb ,=#   Rapn, Papn: Unsigned_Ptr := NIL ;c%   Newchars : Terminal_Chars := ZERO ; )   Exit_Desc : [STATIC] Desc_Blk := ZERO ; $   Iosb : Status_Block_Type := ZERO ;.   Item_List : Item_List_Template (2) := ZERO ;=   Specified_User : VARYING [Max_Username_Len] OF CHAR := '' ; +   Time_Str   : VARYING [23] OF CHAR := '' ;i+   Notify_Msg : VARYING [80] OF CHAR := '' ;   7   FUNCTION Find_Device (Device : VARYING [L1] OF CHAR ;f$ 			Chan   : $UWORD := 0) : BOOLEAN ;  7   { Determine if a device exists and return its name. }        VAR Rst : UNSIGNED := 0 ;G# 	Iosb : Status_Block_Type := ZERO ;c- 	Item_List : Item_List_Template (2) := ZERO ;T       BEGIN	{ Find_Device }'     Find_Device := TRUE ;E  4     Item_List[1].Buffer_Length := SIZE (Pdev.BODY) ;/     Item_List[1].Item_Code     := DVI$_DEVNAM ;e8     Item_List[1].Buffer_Addr   := IADDRESS (Pdev.BODY) ;:     Item_List[1].Return_Addr   := IADDRESS (Pdev.LENGTH) ;  B     Item_List[2].Terminator    := 0 ;		{ Terminate the item list }  C     IF (Chan = 0) AND (Device <> '')  THEN	{ Device name supplied }B,        Rst := $GETDVIW (Itmlst := Item_List, 			Devnam := Device, 			Iosb   := Iosb))      ELSE					{ Channel number supplied }f,        Rst := $GETDVIW (Itmlst := Item_List, 			Chan   := Chan, 			Iosb   := Iosb) ;        IF Rst = SS$_NOSUCHDEV  THEN        Find_Device := FALSET	      ELSEs     Zip (Rst,Iosb[1]) ;T     END ;	{ of Find_Device }  *   PROCEDURE Get_Ucb (Chan_Num : UNSIGNED ;! 		     VAR Ucb  : Unsigned_Ptr) ;t  F   { Use the logical UCB address in the CCB to get to the physical UCB.A     VAX and Alpha/Integrity handle things slightly differently. }i       VAR Inx : UNSIGNED := 0 ;i& 	Ccb_Chan : [VOLATILE] UNSIGNED := 0 ;% 	Ccb_Chan_Ptr : Unsigned_Ptr := NIL ;        BEGIN	{ Get_Ucb }R     CASE Architecture OF       Vax:   BEGIN- 	     Inx := Chan_Num DIV 16 * CCB$K_LENGTH ; ' 	     Ucb::UNSIGNED := CTL$GL_CCBBASE - - 				Inx - CCB$L_UCB ;	{ Logical UCB address }. 	     END ;U       Integrity,       Alpha: BEGIN 	     REPEATG 	       Ccb_Chan_Ptr::UNSIGNED := CTL$GA_CCB_TABLE + Inx + CCB$L_CHAN ;_( 	       Getmem (Ccb_Chan,Ccb_Chan_Ptr) ;# 	       Inx := Inx + CCB$K_LENGTH ;l! 	     UNTIL Ccb_Chan = Chan_Num ;   > 	     Ucb::UNSIGNED := CTL$GA_CCB_TABLE + Inx - CCB$K_LENGTH +- 			      CCB$L_UCB ;		{ Logical UCB address }_ 	     END ;s       END ;	{ of Case }e  )     Getmem (Ucb,Ucb) ;				{ Logical UCB }H$     Ucb::UNSIGNED := Ucb::UNSIGNED +2 		     UCB$L_TL_PHYUCB ;		{ Physical UCB address }*     Getmem (Ucb,Ucb) ;				{ Physical UCB }     END ;	{ of Get_Ucb }     BEGIN 	{ Transmography }7   IF Suspect  THEN			{ Secure Mode subversion attempt } 
      BEGIN.      Oprmsg (Subversion_Msg,Oper_Class_Mask) ;?      Send_Mail_Message (Notify_Maillist,Subversion_Msg,'NL:') ; 
      END ;     Specified_User := New_User ;  F   { Is external authentication being used? If so, use PERSONA routine.     ***** ASSUMPTION *****F     The EXTAUTH flags will *only* be set if external authentication is)     either possibly or actually in use. }F     IF Psb_Available  THEN
      BEGIN)      Check_Extauth_Flags (Target_Flags) ; "      Use_Persona := Extauth_Flag ;)      Check_Extauth_Flags (Caller_Flags) ; 3      Use_Persona := (Use_Persona OR Extauth_Flag) ;         IF Bugger.Info  THENr3 	WRITELN (Dbgfile,'*** Use_Persona:',Use_Persona) ;   '      IF Use_Persona AND Bugger.X1  THEN  	BEGIN 	Use_Persona := FALSE ;S 	LIB$SIGNAL (Jump__Notusepss) ;S 	END ;  -      IF (NOT Use_Persona) AND Bugger.X2  THEN( 	BEGIN 	Use_Persona := TRUE ; 	LIB$SIGNAL (Jump__Forcepss) ; 	END ;
      END ;  I   { Determine which pseudo-terminal type (if any) exists on the system. }s  &   Pseudo_Ft := Find_Device ('FTA0:') ;   IF NOT Pseudo_Ft  THEN'      IF NOT Find_Device ('PYA0:')  THENs 	$EXIT (Jump__Nopseudo) ;   I   { Get current (real) terminal process-specific device characteristics }N     Get_Channel ('TT:',Rchan) ;r     Rst := $QIOW (Chan := Rchan, 		Func := IO$_SENSEMODE, 		Iosb := Iosb,o 		P1   := Rchars,n 		P2   := 12) ;M   Zip (Rst,Iosb[1]) ;i  N   { Audit close to, but before the guts of it, so that even if the jump fails,     the attempt is audited. }r     IF Auditing  THENF      Audit_Jump (TRUE) ;  I   { If recording, construct the session log filename and make sure we can      open the file early on. }      IF Record_Session THEN
      BEGIN      GETTIMESTAMP (Time_Now) ;:      Time_Str := DATE (Time_Now) + ' ' + TIME (Time_Now) ;       IF Time_Str[1]  = ' '  THEN 	Time_Str[1] := '0' ;         IF NOT Secure_Mode  THEN % 	Secure_Directory := User_Directory ; *      WRITEV (Session_Log,Secure_Directory, 			 'JUMP_', 			 Orig_User, 			 '-',
 			 New_User,t 			 '.', 			 DEC (Time_Now.Year,4,4), 			 DEC (Time_Now.Month,2,2),a 			 DEC (Time_Now.Day,2,2),  			 '_', 			 DEC (Time_Now.Hour,2,2), 			 DEC (Time_Now.Minute,2,2),! 			 DEC (Time_Now.Second,2,2) ) ;   I      { If the user has specified JUMP_USER_DIR and the System Manager hasNL        not, turn off SYSPRV for the file open if SYSPRV is not in the user's         process privilege mask. }  K      Modify_Sysprv := NOT (Secure_User_Dir OR (Sysprv IN Proc_Perm_Priv)) ;X        IF Modify_Sysprv  THENy1 	$SETPRV (Enbflg := %IMMED 0,		{ Disable SYSPRV }n 		 Prvadr := PRV$M_SYSPRV) ;        Open_New_File := TRUE ;7      OPEN (Logfile,FILE_NAME:=Session_Log,HISTORY:=NEW,_; 		   Record_Length:=SIZE(Io_Buffer),Carriage_Control:=None,X6 		   USER_ACTION:=Special_File_Open,Error:=CONTINUE) ;      Rst := STATUS (Logfile) ;"      IF Rst <> PAS$K_SUCCESS  THEN 	BEGIN 	LIB$SIGNAL (Jump__Badlogfil) ;s" 	LIB$STOP (Condition_Code (Rst)) ; 	END ;        REWRITE (Logfile) ;$      Session_Log := Open_File_Name ;  &      { If necessary, restore SYSPRV. }        IF Modify_Sysprv  THENI0 	$SETPRV (Enbflg := %IMMED 1,		{ Enable SYSPRV } 		 Prvadr := PRV$M_SYSPRV) ;
      END ;  )   { Set up and declare the exit handler }   :   Exit_Desc.Exit_Handler_Addr := IADDRESS (Exit_Handler) ;   Exit_Desc.Argcnt := 1 ;g.   Exit_Desc.Condition := IADDRESS (Exit_Rst) ;  (   Rst := $DCLEXH (Desblk := Exit_Desc) ;
   Zip (Rst) ;   *   { If required, issue the notification. }     IF Notify.Before  THEN
      BEGIN:      Notify_Msg := 'Initiated JUMP/EXACT to ' + New_User ;      IF Notify.By_Opcom  THEN;& 	Oprmsg (Notify_Msg,Oper_Class_Mask) ;      IF Notify.By_Mail	THENP7 	Send_Mail_Message (Notify_Maillist,Notify_Msg,'NL:') ;=
      END ;  &   { Set new terminal characteristics }     Newchars := Rchars ;.   Newchars.Tt_Devchar.TT$V_NOECHO    := TRUE ;/   Newchars.Tt_Devchar.TT$V_WRAP      := FALSE ;e.   Newchars.Tt_Devchar2.TT2$V_PASTHRU := TRUE ;     Rst := $QIOW (Chan := Rchan, 		Func := IO$_SETMODE, 		Iosb := Iosb,  		P1   := Newchars,J 		P2   := 12) ;    Zip (Rst,Iosb[1]) ;v     IF Use_Persona  THEN      Change_Persona (New_User)    ELSEE
      BEGIND      Change_Username (New_User) ;	{ *** Change to new username *** }:      Change_Uic (New_Uic) ;		{ *** Change to new UIC *** }
      END ;  M   IF Bugger.X9	THEN  $EXIT (Jump__Abortx9) ;{ Bug out before we get serious }e     IF Bugger.D4	THENN4      WRITELN (Dbgfile,'*** Create Pseudoterm ...') ;      { Create the pseudo-terminal }  &   Pbuf_Range[1] := IADDRESS (Buffer) ;6   Pbuf_Range[2] := Pbuf_Range[1] + Io_Buflen * 2 - 1 ;     IF Pseudo_Ft	THENT
      BEGIN'      Rst := PTD$CREATE (Chan	 := Pchan,  			Charbuff := Rchars, 			Buflen	 := SIZE (Rchars), 			Inadr	 := Pbuf_Range) ;      Zip (Rst) ;         { Set event notifications }  8      Rst := PTD$SET_EVENT_NOTIFICATION (Chan   := Pchan, 					Astadr := Send_Bell_Ast,;! 					Type_  := PTD$C_SEND_BELL) ;E      Zip (Rst) ;  8      Rst := PTD$SET_EVENT_NOTIFICATION (Chan   := Pchan, 					Astadr := Send_Xon_Ast,  					Type_  := PTD$C_SEND_XON) ;      Zip (Rst) ;  8      Rst := PTD$SET_EVENT_NOTIFICATION (Chan   := Pchan, 					Astadr := Send_Xoff_Ast, ! 					Type_  := PTD$C_SEND_XOFF) ;U      Zip (Rst) ;      END    ELSEV
      BEGIN"      Get_Channel ('PYA0:',Pchan) ;
      END ;  8   Find_Device ('',Pchan) ;		{ Sets Pdev to device name }   Pchan_Created := TRUE ;n  K   { If the "real" process has a valid value for ACCPORNAM, set the "pseudo"E     process to point to it. }t     Get_Ucb (Pchan,Pucb) ;:   Pctl_Ptr::UNSIGNED := Pucb::UNSIGNED + UCB$W_TT_PRTCTL ;   Getmem (Pctl,Pctl_Ptr) ;9   Papn::UNSIGNED := Pucb::UNSIGNED + UCB$L_TT_ACCPORNAM ;M     IF Port = ''	THENU
      BEGIN  M      { Welcome to a futureware section of code!  When ACCPORNAM is not valid,iI        the port name will be empty.  In this case, use the terminal name.AF        Allocate an appropriate buffer, copy the terminal name into it,J        put the address of the buffer into ACCPORNAM of the pseudo-terminalK        and set the validity bit in the port control mask.  When the pseudo-TO        terminal is terminated, deallocate the buffer.  This exercise remains toeP        be attempted ... or supplied by an eager code jockey somewhere else! :) }        END    ELSE 
      BEGIN      Get_Ucb (Rchan,Rucb) ;0<      Rapn::UNSIGNED := Rucb::UNSIGNED + UCB$L_TT_ACCPORNAM ;      Getmem (Rapn,Rapn) ;d      Putmem (Rapn,Papn) ;o3      Pctl::Prtctl_Type.TTY$V_PC_ACCPORNAM := TRUE ;L      Putmem (Pctl,Pctl_Ptr) ;:
      END ;     IF Bugger.D4	THENG9      WRITELN (Dbgfile,'*** Create Termination MBX ...') ;C  E   { Create a termination mailbox for the soon-to-be detached process,;     and get its unit number }   !   Rst := $CREMBX (Chan	 := Mchan,  		  Maxmsg := ACC$K_TERMLEN) ;
   Zip (Rst) ;A  #   Item_List[1].Buffer_Length := 4 ;S+   Item_List[1].Item_Code     := DVI$_UNIT ;A3   Item_List[1].Buffer_Addr   := IADDRESS (Mbunit) ;	#   Item_List[1].Return_Addr   := 0 ;o  ?   Item_List[2].Terminator    := 0 ;	{ Terminate the item list }$  '   Rst := $GETDVIW (Itmlst := Item_List,o 		   Chan   := Mchan,d 		   Iosb   := Iosb) ;   Zip (Rst,Iosb[1]) ;   /   { Queue an asynchronous read to the mailbox }      Rst := $QIO (Chan   := Mchan,E 	       Func   := IO$_READVBLK,t 	       Astadr := Mbast, 	       P1     := Mbbuf," 	       P2     := ACC$K_TERMLEN) ;
   Zip (Rst) ;      IF Bugger.D4	THENe:      WRITELN (Dbgfile,'*** Create Detached Process ...') ;  !   { Create the detached process }   =   Stsflags := PRC$M_DETACH + PRC$M_INTER + PRC$M_NOPASSWORD ;L   IF Figment  THEN<      Stsflags := Stsflags + PRC$M_LOGIN ;	{ == PRC$M_NOUAF }  ,   Rst := $CREPRC (Pidadr := %REF Pseudo_Pid,( 		  Image  := 'SYS$SYSTEM:LOGINOUT.EXE', 		  INPUT  := Pdev,S 		  OUTPUT := Pdev,  		  Error  := Pdev,S 		  Baspri := 4, 		  Mbxunt := Mbunit,N% 		  Prcnam := 'JUMP_' + HEX(Pid,8,8),F  		  Stsflg := %IMMED Stsflags) ;  
   Zip (Rst) ;S  >   IF Stamp_Uaf	THEN  Update_Uaf ;	{ Update UAF login details }  .   IF NOT Chain	THEN			{ Chaining not allowed }:      Target_Attributes := Target_Attributes + 'NOCHAIN ' ;  !   IF Target_Attributes = ''  THEND       Target_Attributes := 'NONE'    ELSEtJ      Define_Logical_Name ('JUMP_'+HEX(Pseudo_Pid,8,8),Target_Attributes) ;  #   IF Bugger.Info OR Bugger.D4  THEN 
      BEGIN?      WRITELN (Dbgfile,'*** Target PID: ',HEX(Pseudo_Pid,8,8)) ;sD      WRITELN (Dbgfile,'*** Target Attributes: ',Target_Attributes) ;      WRITELN (Dbgfile) ;
      END ;     IF Log  THEN
      BEGIN"      LIB$SIGNAL (Jump__Transfer,1,2 		 %STDESCR SUBSTR (New_User,1,New_User.LENGTH)) ;      WRITELN ;3      IF Single_Cmd_Mode  THEN  WRITELN ;  { Again } 
      END ;     { Restore username and UIC }  F   New_User.BODY := PAD ('',' ',Max_Username_Len) ;	{ Totally blat it }   New_User := Orig_User ;T   New_Uic  := Orig_Uic ;     IF Use_Persona  THEN      Change_Persona (New_User)    ELSE 
      BEGIND      Change_Username (New_User) ;	{ *** Change to new username *** }:      Change_Uic (New_Uic) ;		{ *** Change to new UIC *** }
      END ;  I   { Put some audit information at the start of the session log file. Note F     that we have to put the carriage control in explicitly because the?     log file is created without any implied carriage control. }i     IF Record_Session THEN
      BEGIN,      WRITELN (Logfile,PAD ('-','-',78),Cr) ;+      WRITELN (Logfile,Lf,Jump_Version,Cr) ;m=      WRITELN (Logfile,Lf,'Pseudo-terminal session log.',Cr) ;x*      WRITELN (Logfile,Lf,Session_Log,Cr) ;8      WRITELN (Logfile,Lf,'User:        ',Orig_User,Cr) ;?      WRITELN (Logfile,Lf,'Login time:  ', Login_Time_Str, Cr) ;tC      WRITELN (Logfile,Lf,'From PID:    ',HEX (Master_Pid,8,8),Cr) ;e;      WRITELN (Logfile,Lf,'Process:     ',Process_Name,Cr) ;nC      WRITELN (Logfile,Lf,'To PID:      ',HEX (Pseudo_Pid,8,8),Cr) ;_#      IF Physical_Device <> ''  THENA: 	WRITELN (Logfile,Lf,'Phys Dev:    ',Physical_Device,Cr) ;      IF Terminal <> ''	THENe3 	WRITELN (Logfile,Lf,'Terminal:    ',Terminal,Cr) ;T      IF Port <> ''  THEN/ 	WRITELN (Logfile,Lf,'Port:        ',Port,Cr) ;)7      WRITELN (Logfile,Lf,'JUMP time:   ',Time_Str,Cr) ; =      WRITELN (Logfile,Lf,'Target user: ',Specified_User,Cr) ;       IF Secure_Mode  THEN1. 	WRITELN (Logfile,Lf,'Mode:        Secure',Cr)
       ELSE0 	WRITELN (Logfile,Lf,'Mode:        Record',Cr) ;@      WRITELN (Logfile,Lf,'Attributes:  ',Target_Attributes,Cr) ;6      WRITELN (Logfile,Lf,'Command:     ',Command,Cr) ;      IF Suspect  THENg) 	WRITELN (Logfile,Lf,Subversion_Msg,Cr) ;B+      WRITELN (Logfile,PAD (Lf,'-',78),Cr) ;I      WRITELN (Logfile,Lf,Cr) ;
      END ;  O   { Queue the appropriate reads to both the real terminal and pseudo-terminal }=     IF Pseudo_Ft	THEN 
      BEGIN!      Rst := $QIO (Chan	 := Rchan,i 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer.Raw[Wbuf], 		  P2	 := 1) ;)      Zip (Rst) ;  &      Rst := PTD$READ (Chan	  := Pchan, 		      Astadr	  := Pchan_Ast,& 		      Readbuf	  := Buffer.Raw[Rsts],# 		      Readbuf_Len := Ft_Buflen) ;y      Zip (Rst) ;      END    ELSEe
      BEGIN!      Rst := $QIO (Chan	 := Rchan,_ 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer.Raw[Wsts], 		  P2	 := 1) ;(      Zip (Rst) ;  !      Rst := $QIO (Chan	 := Pchan,f 		  Func	 := IO$_READVBLK, 		  Iosb	 := Piosb,M 		  Astadr := Pchan_Ast, 		  P1	 := Buffer.Raw[Rsts], 		  P2	 := Py_Buflen) ;R      Zip (Rst) ;
      END ;  >   { Hibernate until termination mailbox message wakes us up. }  
   $HIBER ;     { All Done! We're back! ...g  M     If recording session for an EXACT jump, close the log file. If the escape L     character terminated the session, add an appropriate termination message+     to the session log before closing it. }A     IF Record_Session  THENw
      BEGIN      IF Jeronimo  THEN% 	WRITELN (Logfile,Lf,'************ ', 4 			    'Process terminated by user escape request ',+ 			    '************',Cr,Error:=CONTINUE) ;l&      CLOSE (Logfile,Error:=CONTINUE) ;
      END ;  *   { Same deal for debug as for recording }  J   IF Debug AND NOT Debug_To_Terminal  THEN      { Not if it's a terminal }
      BEGIN      IF Jeronimo  THEN 	BEGIN 	WRITELN (Dbgfile) ;" 	WRITELN (Dbgfile,'************ ',1 			 'Process terminated by user escape request ',R% 			 '************',Error:=CONTINUE) ;  	END ;&      CLOSE (Dbgfile,Error:=CONTINUE) ;
      END ;  %   { If required, notify the troops. }R     IF Notify.After  THENe
      BEGIN@      Notify_Msg := 'Completed JUMP/EXACT to ' + Specified_User ;      IF Notify.By_Mail	THENR 	BEGIN 	IF Notify.Include_Log  THEN> 	   Send_Mail_Message (Notify_Maillist,Notify_Msg,Session_Log) 	 ELSE 	IF Record_Session  THEN2 	   Send_Mail_Message (Notify_Maillist,Notify_Msg,2 			      'The JUMP session log is ' + Session_Log) 	 ELSE2 	   Send_Mail_Message (Notify_Maillist,Notify_Msg,, 			      'There was no JUMP session log.') ; 	END ;      IF Notify.By_Opcom  THEN: 	BEGIN& 	Oprmsg (Notify_Msg,Oper_Class_Mask) ; 	IF Record_Session  THENA 	   Oprmsg ('JUMP Session log: ' + Session_Log,Oper_Class_Mask) ;R 	END ;
      END ;     WRITELN ;q   IF Log  THEN
      BEGIN       LIB$SIGNAL (Jump__Return,1,4 		 %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH)) ;      WRITELN ;
      END ;  +   { The Exit_Handler will do the cleanup. }      END ; 	{ of Transmography }3    E { * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *iC   * * * * * * * * * *	M A I N   P R O G R A M   * * * * * * * * * * G   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }e     BEGIN	{ Jump }   Get_System_Info ;d Get_Caller_Info ;a   Get_And_Parse_Command ;[' Validate_Access ;			{ Stop intruders! }t  ? IF NOT Production_Version  THEN  LIB$SIGNAL (Jump__Devnotprd) ;d   IF Real_Mccoy  THENe    Transmography			{ Clone! }r  ELSE     BEGIN    IF Auditing	THENi       Audit_Jump (TRUE)      ELSE       Format_User (New_Uic) ;S  3    IF Alter_Ego  THEN			{ *** Change username *** } "       Change_Username (New_User) ;  -    IF Transmute  THEN			{ Long jump! Boing! }a9       Kangaroo ;			{ *** Change miscellany of items *** }E      IF Log  THEN  Display_Jump ;+    END ;   END.	{ of it all }