c==========================================================================
c			random number generator #2
c==========================================================================

        FUNCTION        g05caf(tidum)

	integer		tidum
        INTEGER         idum,IM1,IM2,IMM1,IA1,IA2,IQ1,IQ2,IR1,IR2,NTAB,NDIV
        REAL            g05caf,AM,EPS,RNMX

        PARAMETER       (IM1=2147483563,IM2=2147483399,AM=1./IM1,IMM1=IM1-1,
     &                  IA1=40014,IA2=40692,IQ1=53668,IQ2=52774,IR1=12211,
     &                  IR2=3791,NTAB=32,NDIV=1+IMM1/NTAB,EPS=1.E-7,RNMX=1.-EPS)

        INTEGER         idum2,j,k,iv(NTAB),iy
        SAVE            iv,iy,idum2
        DATA            idum2/123456789/,iv/NTAB*0/,iy/0/

c  This modified version of RAN2 (2nde edition) use an intermediate number
c  tidum (the r=function parameter) because g05caf is often called as
c  g05caf(0). The test is also .LT. and not .LE. for the same reason.
c  Therefore, only a negative seed value will initialize the random number
c  generator. The program will still crash on a call such as g05caf(-2000)
c  since it expect g05caf(int *tidum).

	IF(tidum.lt.0)then
		idum = tidum
		tidum= 0
	endif
        IF(idum.Lt.0) THEN
                idum=MAX(-idum,1)
                idum2=idum
                DO j=NTAB+8,1,-1
                        k=idum/IQ1
                        idum=IA1*(idum-k*IQ1)-k*IR1
                        IF(idum.LT.0) idum=idum+IM1
                        IF(j.LE.NTAB) iv(j)=idum
                ENDDO
                iy=iv(1)
        ENDIF


        k=idum/IQ1
        idum=IA1*(idum-k*IQ1)-k*IR1
        IF (idum.LT.0) idum=idum+IM1
        k=idum2/IQ2
        idum2=IA2*(idum2-k*IQ2)-k*IR2
        IF (idum2.LT.0) idum2=idum2+IM2
        j=1+iy/NDIV
        iy=iv(j)-idum2
        iv(j)=idum
        IF(iy.LT.1)iy=iy+IMM1
        g05caf=MIN(AM*iy,RNMX)
        return
        END

