. *   Extr_Edit.For -- Edit routines for ExtractJ *                                                       Pat Rankin, Apr'89J *                                                          revised, Sep'91( *  sub  Edit_Record ( record$, rec_len )$ *  sub  Parse_Edit_Options ( flags )# *  sub  Alpha_Init ( atype, acase ) 7 *  sub  Insert_Number_Prefix ( rec_num, work, record$ )  *       ;       subroutine  Edit_Record ( in_rec$, outrec$, rec_len )  	!1 	!   Perform requested edits on the input record. = 	!   Provides the same alternatives as DCL's lexical function $ 	!   F$EDIT(), with some extensions. 	!: 	!   Note:  fallback mode might distort quote or space/tabC 	!       recognition but it's not important enought to worry about.  	! * M *       COLLAPSE   Remove all spaces and tabs (overrides 'compress' & 'trim') G *       COMPRESS   Replace multiple spaces and tabs with a single space " *       LOWERCASE  Make lower case> *       TRIM       Remove leading and trailing spaces and tabsI *       UNCOMMENT  Remove comments (delimited by 'explanation' point "!") D *       UPCASE     Make upper case (has precedence over 'lowercase')7 *       STRIP_TRAILING  Remove trailing spaces and tabs = *       IGNORE_QUOTES   Ignore quotes when making other edits F *       FALLBACK   Strips 8th bit to translate into 7-bit 'equivalent'M *       FORMAT     Convert non-visible characters into "." (ala $FAO's "!AF")  *  	implicit none C     called by:& *       subroutine      Process_Record C     constant: + 	parameter       eDIT_NO_OP      = '0001'x, 2      &                  eDIT_COLLAPSE   = '0002'x,2      &                  eDIT_COMPRESS   = '0004'x,2      &                  eDIT_LOWERCASE  = '0008'x,2      &                  eDIT_TRIM       = '0010'x,2      &                  eDIT_UNCOMMENT  = '0020'x,2      &                  eDIT_UPCASE     = '0040'x,6      &                  eDIT_STRIP_TRAILING = '0080'x,6      &                  eDIT_IGNORE_QUOTES  = '0100'x,2      &                  eDIT_FALLBACK   = '0200'x,1      &                  eDIT_FORMAT     = '0400'x 4 	byte            sPACE,  tAB,  rUB,  cOMMENT,  qUOTE3 	parameter     ( sPACE = ' ',  tAB = 9,  rUB = 127, 5      &                  cOMMENT = '!',  qUOTE = '"' ) , 	byte            aTYPE(0:255),  aCASE(0:255)
 C     global:  	include 'Extract.F' C     input: 	character *(*)  in_rec$
 C     output:  	character *(*)  outrec$ C     input/output:  	integer *2      rec_len C     local:& 	integer *4      ip,  op,  last,  reclH 	integer *2      last_word       !i*2 for final return length assignment; 	  equivalence ( last, last_word )       !overlay i*2 & i*4 - 	logical         init_done,  keep,  in_quote, 9      &                  collpse,  comprss,  lower,  trim, :      &                  uncomnt,  upper,  strip,  ignor_q,$      &                  falbk,  frmt 	character *1    c$  	byte            c,  t 	integer         c_ # 	  equivalence ( c$, c ), ( c_, c )   	    data    init_done /.false./ 	    save    init_done C     functions: 	intrinsic       ZEXT   " C     set up character case tables 	if ( .not. init_done ) then# 	    call Alpha_Init( aTYPE, aCASE)  	    init_done = .true.  	end if   = C     set up individual flags for quicker testing within loop / 	collpse = ( (edit .and. eDIT_COLLAPSE).ne. 0 ) / 	comprss = ( (edit .and. eDIT_COMPRESS).ne. 0 ) ) 	trim  = ( (edit .and. eDIT_TRIM).ne. 0 ) > 	strip = ( (edit .and. eDIT_STRIP_TRAILING).ne. 0 .or. trim  )+ 	upper = ( (edit .and. eDIT_UPCASE).ne. 0 ) @ 	lower = ( (edit .and. eDIT_LOWERCASE).ne. 0 .and. .not. upper )0 	uncomnt = ( (edit .and. eDIT_UNCOMMENT).ne. 0 )4 	ignor_q = ( (edit .and. eDIT_IGNORE_QUOTES).ne. 0 )- 	falbk = ( (edit .and. eDIT_FALLBACK).ne. 0 ) + 	frmt  = ( (edit .and. eDIT_FORMAT).ne. 0 )   + 	c_ = 0                  !clear upper bytes 8 	recl = ZEXT(rec_len)    !(unsigned) input record lengthE 	in_quote = .false.      !flag indicating whether we're within quotes G 	last = 0                !index of last non-blank char in output string C 	op = 0                  !index of last char put into output string ? 	ip = 0                  !index of current char in input string  C     loop through input string  	do while ( ip .lt. recl )6 	    ip = ip + 1                 !advance to next charA 	    c$ = in_rec$(ip:ip)         !get next char into 'c' and 'c_' ; 	    if ( falbk )  c = c .and. '7F'x         !strip 8th bit E 	    t = aTYPE(c_)               ! -1 => upper-case, +1 => lower-case 6 	    keep = .true.               !retain it by default 	    if ( in_quote ) then > 		if ( c .eq. qUOTE )  in_quote = .false.         !close quote" 	    else if ( c .eq. qUOTE ) then= 		if ( .not. ignor_q )  in_quote = .true.         !open quote > 	    else if ( t .lt. 0 ) then   !negative => uppercase letter1 		if ( lower )  c = aCASE(c_)     !make lowercase E 	    else if ( t ) then          !odd (but non-negative) => lowercase 1 		if ( upper )  c = aCASE(c_)     !make uppercase 2 	    else if ( c .eq. sPACE .or. c .eq. tAB ) then* *-              if ( .not. in_quote ) then: 		    if (  collpse                       !drop all blanksN      &               .or. comprss .and. last .ne. op    !drop successive blankK      &               .or. trim    .and.   op .eq. 0     !drop leading blank       &              ) then 			keep = .false.  		    else if ( comprss ) then0 			c = sPACE               !convert tab to space 		    end if *-              end if$ 	    else if ( c .eq. cOMMENT ) then$ 		keep = in_quote .or. .not. uncomnt4 		if ( .not. keep )  ip = recl    !break out of loop	 	    else * *               do nothing (except 'keep') 	    end if    	    if ( keep ) then 3 		op = op + 1             !increment output pointer 4 		if ( in_quote .or. c .ne. sPACE .and. c .ne. tAB )J      &                  last = op       !keep track of last non-blank char. 		if ( frmt .and. ( (c .and. '7F'x) .lt. sPACEH      &                       .or. (c .and. '7F'x) .eq. rUB ) )  c$ = '.'+ *-              if ( op .lt. LEN(outrec$) ) + 		outrec$(op:op) = c$     !retain character  	    end if  	end do !loop (next input char)   F 	if ( .not. strip )  last = op   !don't care if last+1..op were blanks 	rec_len = last_word   	return        end !of Edit_Record         .       subroutine  Parse_Edit_Options ( flags ) 	!; 	!   Parse the keywords supplied by /EDIT=(keyword,...) and > 	!   put the result into a simple bitmask.  We are only called/ 	!   when /EDIT is present on the command line.  	!E 	!   Note:  combinations like UPCASE+LOWERCASE are handled elsewhere.  	!/ 	!   NB:  negation information is not retained; = 	!       should possibly check for some workable combinations 7 	!       like TRIM+NOSTRIP (remove leading blanks only) A 	!       or COMPRESS+NOTRIM[+STRIP] (compress within line but not & 	!       leading or trailing portion). 	! 	implicit none C     called by:" *       function        Param_Init C     constant: ' 	parameter       eDIT_OPTION_COUNT = 10 5 	character *16   eDIT_OPTION_NAMES(eDIT_OPTION_COUNT) A      &                    / 'COLLAPSE', 'COMPRESS',  'LOWERCASE', >      &                      'TRIM',     'UNCOMMENT', 'UPCASE',?      &                      'STRIP_TRAILING',  'IGNORE_QUOTES', 4      &                      'FALLBACK',   'FORMAT' /
 C     output:  	integer *4      flags C     local: 	character *16   keyword 	integer *2      ln  	integer         idx C     functions: 	integer *4      Cli_Present 	intrinsic       IBSET  7 	flags = 1       !first bit means that /edit is present  	do idx = 1, eDIT_OPTION_COUNT8 	    call STR$TRIM( keyword, eDIT_OPTION_NAMES(idx), ln)/ 	    if ( Cli_Present( 'EDIT.'//keyword(:ln)) ) O      &              flags = IBSET( flags, idx)          !=> IOR( flags, 2**idx)  	end do   F 	if ( flags .eq. 1 )  flags = 0          !clear it if no options found 	return         end !of Parse_Edit_Options        -       subroutine  Alpha_Init ( atype, acase ) C 	!                                               Pat Rankin, May'89 ? 	!   Create upper- <-> lower-case identification and conversion A 	!   tables.  Character-set independent (assuming that STR$UPCASE C 	!   supports the character-set in use; don't know if/how alternate B 	!   sets can be specified).  The 'atype' array will contain three? 	!   values, indexed by character's byte code:  -1 if character A 	!   has a lower-case equivalent (implies that it is upper case); = 	!   +1 [odd but non-negative] if character has an upper-case C 	!   equivalent (which implies that it is lower-case); 0 otherwise. = 	!   Note that if a character represents an alphabetic letter ? 	!   which has only one case present (such as some Scandinavian B 	!   over-loading of ascii bracket characters and such), then this> 	!   table does not identify it as a letter; that's ok for our? 	!   purpose (which is upper<->lower conversion, not alphabetic D 	!   identification).  The 'acase' array will hold the case-inverted# 	!   equivalent for each character.  	! 	implicit none C     called by:# *       subroutine      Edit_Record 
 C     output: B 	byte            atype(0:255),   !alpha type: -1 => upper, 1 lower9      &                  acase(0:255)    !conversion table  C     local:& 	character *256  mixed,  upper,  c$ *1 	integer         i,  j 	byte            b,  cH 	  equivalence ( i, b ), ( c, c$ )       !not very pretty, but it works! C     functions: 	intrinsic       CHAR,  ZEXT" *       subroutine      STR$UPCASE  ? C     create a string containing every possible 8-bit character ' 	do i = 0, 255           !b = -128..127 $ 	    j = i + 1           !j = 1..256 	    mixed(j:j) = CHAR(i) ; 	    atype(i) = 0                !non-alphabetic by default F 	    acase(i) = b                !not strictly applicable; init anyway
 	end do !loop ! C     make an uppercase-only copy  	call STR$UPCASE( upper, mixed) B C     compare the two strings and process identifiable differences/ 	do j = 1, 256                   !1..LEN(mixed) + 	    if ( upper(j:j) .ne. mixed(j:j) ) then J C             got a character which has both upper and lower case variants5 		i = j - 1               !i = 0..255 (also sets 'b') % 		c$ = upper(j:j)         !set up 'c' ? 		atype(i) = 1            !identify 'i' (aka 'b') as lower-case 6 		acase(i) = c            !c$ is upper-case equivalent5 		atype(ZEXT(c)) = -1     !identify 'c' as upper-case ; 		acase(ZEXT(c)) =  b     !'b' is its lower-case equivalent) 	    end ifs 	end do !next if   	returns       end !of Alpha_Init        G       logical function  Insert_Number_Prefix ( rec_num, work, record$ )  	!; 	!   Format the record number and prepend it to the record.P 	! 	implicit none C     called by:& *       subroutine      Process_Record C     constant:c1 	include 'f_inc:Dsc.F'           !descriptor defs F 	parameter       nUM_PREFIX_SIZE = 12    !also defined in Process_File C     input: 	integer *4      rec_num C     input/output: < 	record /dsc/    work            !descriptor for data recordI 	character *(*)  record$         !large string buffer for manipulation(s)b C     local:* 	character *(nUM_PREFIX_SIZE)  rec_prefix$ 	logical         resultv 	integer *4      tmp_longe# 	integer *2      tmp_word,  num_siz % 	  equivalence ( tmp_long, tmp_word )i C     functions: 	intrinsic       ZEXT,  ICHAR   3 c     figure out how wide to make the number formate* 	if (      rec_num .lt.      10 000 ) then 	    num_siz = 4* 	else if ( rec_num .lt.   1 000 000 ) then 	    num_siz = 6* 	else if ( rec_num .lt. 100 000 000 ) then 	    num_siz = 8 	elset" 	    num_siz = nUM_PREFIX_SIZE - 1 	end if"   c     format the number : 	if ( work.d_adr .ge. %LOC(record$)  !!  + nUM_PREFIX_SIZE@      & .and. work.d_adr .lt. %LOC(record$) + LEN(record$) ) thenG c         do the number in place; we've got a buffer that can handle itD= 	    tmp_long = ZEXT(work.d_len)                 !save lengthE@ 	    work.d_adr = work.d_adr - (num_siz + 1)     !adjust pointerB 	    work.d_len = num_siz                        !temporary lengthA 	    call OTS$CVT_L_TU( rec_num, work)           !format longwordRG 	    call Buf_BPoke( %VAL(work.d_adr + num_siz), ICHAR(' ')) !add space0? 	    tmp_long = tmp_long + (num_siz + 1)         !update length @ 	    work.d_len = tmp_word                       !restore length6 	    result = .true.     !moved address by subtraction 	elsetI c         do the number separately, then rebuild the buffer [lots slower] @ 	    call OTS$CVT_L_TU( rec_num, rec_prefix$(:num_siz))  !formatC 	    rec_prefix$(num_siz+1:num_siz+1) = ' '              !add spacepB 	    tmp_long = ZEXT(work.d_len) + (num_siz + 1) !calculate lengthE 	    call STR$CONCAT( record$(:tmp_long),        !concatenate stringsg:      &                      rec_prefix$(:num_siz+1), work)C 	    work.d_adr = %LOC(record$)                  !update descriptor  	    work.d_len = tmp_word+ 	    result = .false.    !swapped addresseso 	end ifo   	Insert_Number_Prefix = result 	return "       end !of Insert_Number_Prefix