
 @Make(Manual)  @String(ETHVersion="V2.4-1") @String(ETHDate="29-Oct-1992") @LibraryFile(MultiLevelIndex) , @Modify(InputExample, LongLines Wrap, Group). @Modify(ProgramExample, LongLines Wrap, Group) @Begin(TitlePage)  @Begin(TitleBox) @MajorHeading(ETHERMON)  @Heading(@Value[ETHVersion]) @Center(@Value[ETHDate]) @End(TitleBox)" @CopyrightNotice(Andrew C. Pavlin) @Center(written by)  @Center(Andrew C. Pavlin)  @Center(General Electric Co.) ) @Center(Aerospace Information Technology)  @Center(Syracuse, NY 13221)  @End(TitlePage) > @PageHeading(Left="@Value[SectionTitle]",Right="@Value[Page]") @Process(PageHeadings) @Begin(Abstract)C ETHERMON is a software implementation of an Ethernet line activity  F monitor. It permits a suitably privileged user to observe the flow of I data across the Ethernet, as seen from any DEC-standard Ethernet adapter  I connected to a VAX/VMS system. The data can be observed statistically in  I several forms, or can be recorded to a disk file for additional off-line  B analysis. The received data can be selectively filtered to remove @ messages not of interest. When possible, Ethernet addresses are < displayed symbolically in addition to the physical hardware  representation.  @End(Abstract) @Chapter(Requirements for Use)M To operate, ETHERMON requires a VAX/VMS system at version 4.x or higher, and  O at least one Ethernet or FDDI interface that uses a driver compatible with the  E Ethernet driver specifications in the @u[@i<VMS I/O User's Reference  F Manual: Part II>] (DEUNA, DELUA, DEQNA, DELQA, DEBNT, etc.). The user J account running ETHERMON must have PHY_IO, NETMBX, and TMPMBX (or SETPRV) J privileges, and a buffered I/O byte limit quota (BYTLM) of at least 16000 N (depending on the value of certain SYSGEN parameters; see section @Ref[quota] O on page @PageRef[quota]). For systems running VAX/VMS V5.4-3 and above, CMKRNL  K privilege is also required; it is preferred for systems at lower versions.  H @Foot{For more information regarding this new privilege requirement for N ETHERMON V2.4 (needed to implement the new "fast" port interface), please see F section @Ref[CMKRNL] describing ETHERMON's @i<modus operandi> on page  @PageRef[CMKRNL].}3 @IndexSecondary(Primary="quotas",Secondary="BYTLM") 8 @IndexSecondary(Primary="privileges",Secondary="CMKRNL")8 @IndexSecondary(Primary="privileges",Secondary="NETMBX")8 @IndexSecondary(Primary="privileges",Secondary="PHY_IO")8 @IndexSecondary(Primary="privileges",Secondary="SETPRV")8 @IndexSecondary(Primary="privileges",Secondary="TMPMBX") @Index(SYSGEN parameters)  @Index(Fast port interface)  @Index(FDDI)# The system must not be running any  < application using promiscuous mode on the selected Ethernet M interface (if running in fallback Ethernet-only mode, there must be no other  O protocol type FF-FF user on the Ethernet interface; see section @Ref[V4.x] for   more details). @Index(promiscuous mode): @IndexSecondary(Primary="protocol type",Secondary="FF-FF")  B Note that only one copy of ETHERMON can be running on an Ethernet A interface at a time (due to a driver limitation on the number of  A simultaneous promiscuous Ethernet users); however, any number of  C @i[other] applications (DECnet, TCP/IP, etc.) may be running on an  B Ethernet interface at the same time as ETHERMON (as long as those / applications do not create a promiscuous user).   E Note also that, if your Ethernet has any kind of serious load on it,  H ETHERMON will tend to be a CPU hog. The program has been tuned, but the H vast majority of its CPU time is spent in the VMS I/O executive and the E Ethernet interface I/O driver (per VAX SPM analyses), which can't be  G "tweaked" for better performance. It is therefore recommended that you  F use ETHERMON on the most powerful CPU you have available, in order to H prevent data loss in ETHERMON's analysis. Work is being done to attempt H to correct this problem, but the work has not been completed as of this  release.  P One final limitation is that ETHERMON cannot see any messages being transmitted A by the local system through the selected Ethernet interface (the  K loopback buffer isn't big enough for ETHERMON to bother turning it on, and  L most interfaces can't run in loopback or echo without also turning off real J transmissions to and receptions from the actual cable). Bear this in mind % when you interpret the received data.     @Section(Statement of Liability)I As usual, you use this program @b[at your own risk]; neither the author,  ) the author's employer, DECUS, or anybody  D but yourself is liable for any problems caused by this program. The I information used to construct this program was culled from many sources,  I not all of which could be considered to be 100% reliable; the author has  K tried for the best accuracy and reliability possible, but some of the data  K and logic in this program is based on conjecture. If you have any comments  H or suggestions as to improvements, corrections, etc., please contact me 8 regarding them. As of 6 March 1992, I can be reached at:+ @Begin(Verbatim, Group, LeftMargin +1 inch)  General Electric Company# Electronics Park, Bldg. 7, Room C67  Syracuse, NY 13221 U.S.A.  telephone: 1-315-456-6212 '            8*256-6212 (GE/RCA DIALCOMM)  fax:       1-315-456-0956  GE DECnet: C5VR::PAVLIN  Internet: PAVLIN@@syr.ge.com"           PAVLIN@@c5vr.dnet.ge.com @Label[author] @End(Verbatim) @Section(Acknowledgements): DEC, DECnet, DECbridge, DECserver, LAT, UCX, Ultrix, VAX, D VAXcluster, and VMS are trademarks of Digital Equipment Corporation.  D ARPANET, Internet, and TCP/IP are trademarks of the U.S. Government  Department of Defense.  : MultiNet is a trademark of SRI International and TGV, Inc.  0 MULTIBUS II is a trademark of Intel Corporation.  # Scribe is a trademark of Unus, Inc.   3 SUN and NFS are trademarks of Sun Microsystems Inc.   J U-B, NIU, and Access/One are registered trademarks of Ungermann-Bass, Inc.  B AT&T and Unix are trademarks of American Telephone & Telegraph Co.  8 Xerox, XNS, and PUP are trademarks of Xerox Corporation.  9 HIU, CC, and Xyplex are trademarks of Xyplex Corporation.   J Macintosh, AppleTalk, and EtherTalk are trademarks of Apple Computer, Inc.  C PostScript is a registered trademark of Adobe Systems Incorporated.   % HP is a trademark of Hewlett-Packard.   A All other manufacturer names are those manufacturers' trademarks.   @Chapter(Installing the Program) @Section(Manifest)A ETHERMON consists of several FORTRAN subroutines, a set of MACRO  D routines and a syntax table, a file of error message definitions, a H VAX/VMS help library, and documentation files. The complete set of files composing ETHERMON contains: @Begin(Enumerate) B the FORTRAN source files and INCLUDE files defining COMMON blocks: @Begin(Itemize) > ETHERMON.FOR - initialization and support routines source file  9 ETHERMON_ETHREAD.FOR - Ethernet read routines source file   9 ETHERMON_CMD_AL.FOR - commands (from @@ to L) source file   8 ETHERMON_CMD_MR.FOR - commands (from M to R) source file  - ETHERMON_CMD_S.FOR - commands (S) source file   8 ETHERMON_CMD_TZ.FOR - commands (from T to Z) source file  * ETHERMON_ADDR.INC - Ethernet address table  B ETHERMON_BRIDGES.INC - bridge table and bridge interconnection map  K ETHERMON_CMD.INC - control flags related to command execution (not parsing)   * ETHERMON_DEV.INC - device and system names  @ ETHERMON_ETH.INC - raw Ethernet data buffers and port parameters  * ETHERMON_FILTER.INC - data filtering table  @ ETHERMON_MANUF.INC - manufacturer prefix numbers and names table  6 ETHERMON_PING.INC - PING command flags and data buffer  9 ETHERMON_PROT.INC - protocol type numbers and names table   7 ETHERMON_PRS.INC - parameters from command line parsing   J ETHERMON_SMG.INC - pointers and control information for use of the Screen  Management Facility (SMG)   4 ETHERMON_STATS.INC - counters for message statistics  E ETHERMON_TCPIP.INC - protocol numbers and names for the DoD Internet   protocol suite  C ETHERMON_TRACE.INC - control flags and RMS blocks for TRACE command 
 @End(Itemize)   E ETHERMON_PARSE.MAR - the MACRO source file containing the LIB$TPARSE  1 state table and assorted support action routines.   E ETHERMON_FASTCALL.MAR - the MACRO source file providing the run-time  ) link access to the "fast" port interface.   H ETHERMON_FASTSHR.MAR - the MACRO source file containing the kernel-mode < access routines used to implement the "fast" port interface. @Index(Fast port interface)   I ETHERMON_MSG.MSG - the MESSAGE source file (containing the error message  
 definitions).   G ETHERMON.COM - a command prcedure which compiles and links the ETHERMON F program, creates the ETHERMON help library, and attempts to build the C unsupported utilities (see section @Ref[Utilities] and the list of  * unsupported off-line utility files below).   On-line documentation: @Begin(Itemize) H ETHERMON.HLP - the HELP command source text (used to build the VMS help  library file).  6 ETHERMON.HLB - the VMS help library file for ETHERMON.
 @End(Itemize)    Off-line documentation:  @Begin(Itemize) E ETHERMON.MSS - the user's guide (this document) in Scribe manuscript   source format.  H ETHERMON.LN0 - the user's guide in DEC LN03 laser printer output format.  K ETHERMON.LPT - the user's guide in "dumb" line printer output format (note  ; that this document version will not contain illustrations).   ; ETHERMON.PS - the user's guide in PostScript output format.   J ETHERMON_MSS_KEYDEF.PS - illustration of default state keypad definitions D for PostScript version of user's guide (automatically included into  ETHERMON.MSS by Scribe).  H ETHERMON_MSS_KEYGOLD.PS - illustration of GOLD state keypad definitions D for PostScript version of user's guide (automatically included into  ETHERMON.MSS by Scribe).
 @End(Itemize)    Distribution tools:  @Begin(Itemize) L ETHERMON_SEND.COM - a command procedure to help in distributing ETHERMON by F electronic mail (e-mail); currently, it only supports DECnet mail and F Internet mail using the TGV MultiNet product's foreign mail interface.  ? AAAREADME.TXT - the introductory file for the ETHERMON package. 
 @End(Itemize)    Off-line unsupported utilities:  @Begin(Itemize) K ETHTRSTRUC.INC - FORTRAN include file describing the structure of a binary   TRACE file's records  I ETHERPARSE.FOR - FORTRAN source file of basic ASCII formatter for binary   TRACE files   M ETHERPARSE2.FOR - FORTRAN source file of enhanced ASCII formatter for binary   TRACE files   E ETHERPARSE2_CRF.MAR - MACRO source file of support code and data for   ETHERPARSE2   E ETHERPARSE_TCP.FOR - FORTRAN source file of alternate ASCII formatter   F ETHERPARSE_XREF.FOR - FORTRAN source file of alternate ASCII formatter  9 ETHFILT_ETHADDR.FOR - FORTRAN source file for post-filter   < ETHFILT_IPADDR_TGV.FOR - FORTRAN source file for post-filter  < ETHFILT_IPADDR_UCX.FOR - FORTRAN source file for post-filter  5 ETHFILT_NFS.FOR - FORTRAN source file for post-filter   N ETH_CHECK_SUBPROC.FOR - FORTRAN source file for support subroutine: verifying + if a process is a TRACE/ANALYZER subprocess   O ETH_MAP_ADDRTBL.FOR - FORTRAN source file for support subroutine: connecting a  D TRACE/ANALYZER subprocess to ETHERMON's address table global section  < ETHFILT_IPADDR_TGV.OPT - linker options file for post-filter  < ETHFILT_IPADDR_UCX.OPT - linker options file for post-filter  J ETHERMON_ALL.COM - sample command procedure for batch-mode data collection
 @End(Itemize)  @End(Enumerate)     @Section(Installation Procedure)F To prepare ETHERMON for use, the program must be compiled and linked, K and its associated help library must be built; optionally, the program can  $ be defined as a DCL foreign command.  J Building the program means, first of all, all the source files must be in C the same directory, and that directory must be the current default  - directory. Then issue the following commands:  @Begin(InputExample)3    $ @b[FORTRAN/OPTIMIZE/CONTINUATIONS=99 ETHERMON] ;    $ @b[FORTRAN/OPTIMIZE/CONTINUATIONS=99 ETHERMON_ETHREAD] :    $ @b[FORTRAN/OPTIMIZE/CONTINUATIONS=99 ETHERMON_CMD_AL]:    $ @b[FORTRAN/OPTIMIZE/CONTINUATIONS=99 ETHERMON_CMD_MR]9    $ @b[FORTRAN/OPTIMIZE/CONTINUATIONS=99 ETHERMON_CMD_S] :    $ @b[FORTRAN/OPTIMIZE/CONTINUATIONS=99 ETHERMON_CMD_TZ]    $ @b[MACRO ETHERMON_PARSE]      $ @b[MACRO ETHERMON_FASTCALL]    $ @b[MESSAGE ETHERMON_MSG]     $ @b[LINK ETHERMON,-]     $_     @b[ETHERMON_ETHREAD,-]    $_     @b[ETHERMON_CMD_AL,-]     $_     @b[ETHERMON_CMD_MR,-]     $_     @b[ETHERMON_CMD_S,-]    $_     @b[ETHERMON_CMD_TZ,-]     $_     @b[ETHERMON_PARSE,-]!    $_     @b[ETHERMON_FASTCALL,-]     $_     @b[ETHERMON_MSG,-]     $_     @b[SYS$INPUT:/OPTIONS]*    @b[COLLECT=ADDRESS_NAMES,ADDRESS_NAMES]    $ @b[MACRO ETHERMON_FASTSHR] .    $ @b[LINK/SHARE/PROTECT ETHERMON_FASTSHR,-]A    $_                   @b[SYS$SYSTEM:SYS.STB/SELECTIVE_SEARCH,-] .    $_                   @b[SYS$INPUT:/OPTIONS]     @b[UNIVERSAL=FASTSHR_VERSION]!    @b[UNIVERSAL=P_INIT_FAST_$QIO] '    @b[UNIVERSAL=P_FAST_BUFIO_READ_$QIO] #    @b[UNIVERSAL=P_FAST_$QIO_D_LINE]  @End(InputExample)K which produces several .OBJ files, ETHERMON.EXE, and ETHERMON_FASTSHR.EXE.   Alternatively, do  @Begin(InputExample)    $ @b[@@ETHERMON]  @End(InputExample)G which does the same thing (and additional compiles for other programs)   with less typing.   O The shareable image ETHERMON_FASTSHR.EXE must be located in the same directory  H as the copy of the ETHERMON.EXE file that will be run, or the shareable J image's location must identified by an executive-mode system-wide logical N name. The shareable image must also be installed as a shared, protected image < with the INSTALL utility, using commands like the following: @Label[INSTALL]  @Begin(ProgramExample)* $ ! begin optional logical name definition$ $ @b{ASSIGN/SYSTEM/EXECUTIVE_MODE -}* $_@b{     dev:[dir]ETHERMON_FASTSHR.EXE -} $_@b{     ETHERMON_FASTSHR} ( $ ! end optional logical name definition' $ @b{INSTALL :== $INSTALL/COMMAND_MODE} 
 $ @b{INSTALL} C INSTALL> @b{ADD dev:[dir]ETHERMON_FASTSHR.EXE/SHARE/OPEN/HEAD/PROT}  INSTALL> @b{EXIT}  @End(ProgramExample) @Index(INSTALL utility)  @Index(logical name) @Index(SYSTARTUP_V5.COM)E It is suggested that these commands be placed in your system startup  F command procedure (SYS$MANAGER:SYSTARTUP_V5.COM) if you plan on using  ETHERMON regularly.     Building the help library means: @Begin(InputExample).    $ @b[LIBRARY/CREATE/HELP ETHERMON ETHERMON] @End(InputExample)G which produces ETHERMON.HLB. The program expects to find the .HLB file  H in the same directory as the .EXE files; it cannot be redirected by use F of logical names. If you wish to change this behavior, the subroutine 9 HELP in ETHERMON_CMD_AL.FOR must be edited appropriately.  @Index(help library)  D ETHERMON can be invoked either with the RUN command or as a foreign G command. To define ETHERMON as a foreign command, the following line of - DCL must be executed before ETHERMON is used:  @Begin(InputExample)4      $ @b<ETHER*MON :== $@i{disk}:[@i{dir}]ETHERMON> @End(InputExample)I where @i[disk] and @i[dir] specify the location of the ETHERMON*.EXE and  G ETHERMON.HLB files (a good place to put this line is in your LOGIN.COM  G file; although it can be done in SYLOGIN.COM, it is not recommended to  M encourage general users to try to use ETHERMON). Once that is done, ETHERMON  % can be invoked with the command line:  @Index(LOGIN.COM)  @Index(SYLOGIN.COM)  @Begin(InputExample)%      $ @b<ETHERMON> @i<@u[interface]>  @End(InputExample)K where @i<@u[interface]> is the name of the Ethernet interface to use. Only  E the device and controller letters need be specified; the unit number  D will always be discarded and replaced by a zero (to ensure that the E program gets a unique device unit for its work). Optionally, you can  D specify an initial command to ETHERMON as well by using the command  form:  @Begin(InputExample)9      $ @b<ETHERMON> @i<@u[interface]>@b<,>@i<@u[command]>  @End(InputExample)H where @i<@u[command]> is any legal ETHERMON command as defined later in E this manual (including an indirect file using the @b<@@@i[filename]>  I command form). This command will be executed immediately upon completing  H initialization of the Ethernet interface. You must specify an interface F name if you also wish to specify a command. Remember also, if you are H going to use a command with embedded quotes ("), that DCL preparses the E command line before passing it to the application, possibly removing (= your quote marks before ETHERMON gets to look at the command.v  F When invoking ETHERMON with a RUN command, the start-up command looks 
 like this: @Begin(InputExample)      $ @b<RUN ETHERMON>C @End(InputExample)@ If you do not specify your Ethernet port name, or if you invoke D ETHERMON with a RUN command, ETHERMON will search for all recognized= interface devices on your system, and will display a list of  J acceptable device names for your system on your terminal and query you forN a device name; if only one standard Ethernet interface exists on your system, J ETHERMON will not query but will automatically select that one device and C inform you of that action. For example, using the RUN command on a  D system with two Ethernet adapters (underlined text is user-entered):   @Begin(InputExample) $ @u<run ethermon>H %ETHERMON-I-PORT, enter VMS device name of the Ethernet interface to use& _ETA0:   DEBNA      1: 60-07 DEC: LAVC0                     2: 60-03 DEC: DECnet Phase 4/                     3: 60-01 DEC: MOP Dump/Loadh%                     4: 90-00 LoopbackF.                     7: 08-00 Internet IP (DoD))                     8: 08-06 Internet ARPh* _ETB0:   DEBNA      1: 06-00 XEROX: NS IDP Ethernet_port_: @u<eta0>, ETHERMON @Value[ETHVersion], @Value[ETHDate]	 ETHERMON>E @End(InputExample)  F A single Ethernet adapter system's session (using the foreign command - method without specifying an interface name):g   @Begin(InputExample) $ @u<ethermon>G %ETHERMON-I-ONEPORT, implicitly using the one Ethernet interface _XEA0:n, ETHERMON @Value[ETHVersion], @Value[ETHDate]	 ETHERMON>e @End(InputExample)  K Once ETHERMON is started and has initialized the chosen interface, it will  ? attempt to locate an initialization file with the logical name tC ETHERMON$INIT; if the logical name is incomplete or undefined, the sK initialization file's default filespec is ETHERMON$INIT.COM in the current oJ default directory. This text file may contain any legal ETHERMON commands,F although commands that expect certain data to be in the address table M automatically should take into account that ETHERMON has not been collecting oK data very long yet. The commands in this file will execute before ETHERMON iN begins prompting for commands, but @i<after> any initial command typed on the F invocation command line; if the invocation line initial command is an ? indirect file, the default initialization file will be skipped.n @Index(initialization file)  @Index(ETHERMON$INIT)o @Chapter(Operation)  @Section(Theory of Operation)rC ETHERMON operates by using the most basic property of the Ethernet sE promiscuous mode: that @b[ALL] Ethernet messages are received by the o promiscuous user.  @Index(promiscuous mode)/ ETHERMON begins by connecting to the specified  C Ethernet interface and enabling the necessary privileges needed to e@ perform the privileged I/O operations. The interface is started M in promiscuous mode as a IEEE 802.3 mode receiver (Ethernet mode is a subset EN thereof; if Ethernet mode is used because you are running under VAX/VMS V4.x, ' the program uses protocol type FF-FF). kJ It then posts an asynchronous read to the device; the read completion AST N analyzes a received message and queues up another read, forever (or until the  program is terminated).e @Index(IEEE 802.3): @IndexSecondary(Primary="protocol type",Secondary="FF-FF")3 @IndexSecondary(Primary="VAX/VMS",Secondary="V4.x")t  P As of version V2.4 of ETHERMON, certain enhancements were needed to work around O a bug/"feature" in VAX/VMS V5.4-3 and above. These required directly accessing tE the raw Ethernet packet buffers in non-paged pool to ensure that the  G Ethernet MAC-level header was returned to ETHERMON correctly. This was nL implemented by writing a customized, streamlined version of the $QIO system G service that is optimized for issuing asynchronous reads to an already dL assigned and protection-checked Ethernet port channel. This special version I also adds an "intercept" routine to catch the completed read requests as nL they are sent to VMS I/O postprocessing; the intercept routine corrects the K system buffer pointers to return the MAC-level headers in the format tthey  : were returned in earlier versions of VAX/VMS. This allows G for more accurate interpretation of the MAC headers, but requires that:  @Index(Fast port interface)l< @IndexSecondary(Primary="VAX/VMS",Secondary="V5.4-3 and up") @Index($QIO) @Index(QIO)u @Label[CMKRNL] @Begin(Itemize)c< the user must hold the CMKRNL privilege, in addition to the * other privileges required to use ETHERMON.8 @IndexSecondary(Primary="privileges",Secondary="CMKRNL")  O the shareable image ETHERMON_FASTSHR.EXE must be located in the same directory aJ as the ETHERMON.EXE file (or its location identified by an executive-mode B logical name), and must be installed as a shared, protected image < with the INSTALL utility (see section @Ref[INSTALL] on page  @PageRef[INSTALL] for details).3
 @End(Itemize)E  A All the fancy features of ETHERMON are based on how the received NG messages are analyzed. Normally, received messages are analyzed to see eF if the sending nodes have been listed in the table of known addresses E kept by ETHERMON (this is only done for messages with protocol types EF where ETHERMON knows how to interpret the message body). If a sending E node (and, in some cases, the destination node) are not found in the  G addresses table, the addresses are added to the table with appropriate rH identification; i.e., for Internet IP messages, the Internet logical IP F address is stored in the table with the Ethernet address. An Ethernet E address may have more than one equivalence name in the address table gF (since a node may be used for more than one purpose on the Ethernet). L This table of equivalence names is used by the DISPLAY, SHOW ADDRESS_NAMES, J and SUMMARIZE commands to supply more meaningful identifications with the ( Ethernet addresses reported to the user.  H The combinations of addresses and protocol types that can be recognized ' and decoded by ETHERMON are as follows:m @Begin(Enumerate)sB any single-node (not multicast) address under protocol type 60-03 C (DECnet Phase IV) (symbolic names obtained from the local system's , NETACP process)m @Index(DECnet)C @IndexSecondary(Primary="protocol type",Secondary="DECnet (60-03)")e @Index(NETACP)  H any single-node address transmitting DEC MOP System ID packets (type 7) J under the DEC MOP Remote Console protocol (60-02, either Ethernet or IEEE  802.3 SNAP protocol subtype) @Index(MOP) @ @IndexSecondary(Primary="protocol type",Secondary="MOP (60-02)")  D any single-node address under protocol type 08-00 (DoD Internet IP) ) (assuming the IP message header is valid)e @Index(Internet)? @IndexSecondary(Primary="protocol type",Secondary="IP (08-00)")s  J any source address under protocol type 08-06 (Internet ARP) (assuming the G ARP header is correct; in ARP reply cases, the destination address can ME be deciphered as well) (proxy ARP is not processed because it is not   trusted) @Index(ARP)v3 @IndexSecondary(Primary="Internet",Secondary="ARP")e@ @IndexSecondary(Primary="protocol type",Secondary="ARP (08-06)")  G source and multicast destination addresses for messages under protocol sE type 60-07 (DEC Local Area VAXcluster) that are sending to LAVC Node EF ID multicast addresses (AB-00-04-01-@i<xx-yy>), where @i<yyxx> is the / hexadecimal cluster group ID plus 256 (decimal)E @Index(LAVC) @Index(VAXcluster)A @IndexSecondary(Primary="protocol type",Secondary="LAVC (60-07)")  @Index(multicast address)r  L any address under protocol type 80-35 (Internet reverse ARP) (RARP response  packet types only) @Index(RARP)4 @IndexSecondary(Primary="Internet",Secondary="RARP")A @IndexSecondary(Primary="protocol type",Secondary="RARP (80-35)")O  B any single-node source or destination address under protocol type  08-88 (Xyplex terminal network)N @Index(Xyplex)C @IndexSecondary(Primary="protocol type",Secondary="Xyplex (08-88)")a  @ addresses assigned to Ungermann-Bass, Inc., under protocol type F 06-00 (Xerox NS IDP) (prefixes 00-DD-00, 00-DD-01, and 00-DD-0F only),2 including NIU's and XNS-based Access/One equipment @Index(XNS)M@ @IndexSecondary(Primary="protocol type",Secondary="XNS (06-00)")  A all addresses assigned to DEC hardware under protocol type 80-38 n (DEC Bridge management), @Index(bridge) @Index(DEC LAN Bridge)G @IndexSecondary(Primary="protocol type",Secondary="LAN Bridge (80-38)")]  J all addresses assigned to DEC hardware under protocol type 60-04 (DEC LAT) @Index(LAT)B@ @IndexSecondary(Primary="protocol type",Secondary="LAT (60-04)")  C certain source and destination addresses under protocol type 80-9B i@ (AppleTalk, either Ethernet or IEEE 802.3 SNAP protocol subtype) @Index(AppleTalk) F @IndexSecondary(Primary="protocol type",Secondary="AppleTalk (80-9B)")  F all source addresses under protocol type 80-F3 (AppleTalk ARP, either - Ethernet or IEEE 802.3 SNAP protocol subtype)  @Index(AARP)4 @IndexSecondary(Primary="AppleTalk",Secondary="ARP")A @IndexSecondary(Primary="protocol type",Secondary="AARP (80-F3)")s  G all source addresses under protocol type 80-80 (Vitalink TransLAN III) rG sending to destination addresses 09-00-02-04-00-01 or 09-00-7C-04-00-01r2 (3Com/Bridge or Vitalink bridge logging multicast) @Index(bridge)I @IndexSecondary(Primary="protocol type",Secondary="TransLAN III (80-80)")o @Index(multicast address)r @End(Enumerate)i  I When a DISPLAY or SUMMARIZE command is in progress, messages are counted nH up in categories corresponding to the search scheme selected (by source H address, destination address, message body size, or protocol type). The @ resulting summations are reported as the output data from these F commands. In a TRACE command, the messages are passed directly to the  specified output file.   @SubSection(Filtering)L For more selective viewing of data, @i<@b[filters]> may be used to choose a L subset of the data on the network for analysis. In ETHERMON, packets may be K accepted or rejected by source address, destination address, an address in CE either source or destination field, protocol type, packet size, or a mJ combination thereof. The filtering applies to data processed by the TRACE N command, the SUMMARIZE commands, and the DISPLAY commands (when the /NOFILTER  qualifier is not used).I @Index(filter)  A The internal structure of an ETHERMON filter is two Ethernet MAC rH addresses and a protocol type. The source address is used either for an F actual source address or an address that will checked for in both the J source and destination MAC header address fields. The destination address I is used only for destination mapping; therefore, you could have a single oB filter that accepts packets to or from a particular node and to a L particular destination, but not one that matched a to-or-from address and a  source address.   ; Protocol type matching is done independently of whether or cJ not a packet is plain Ethernet or IEEE 802.3 SNAP extended type; only the J Ethernet protocol type field or the last two bytes of the SNAP header are  used for matching.  L An Ethernet address may be specified as only the 3-byte manufacturer prefix I (which will also ignore the least significant bit of the first byte; you  I must specify that bit as zero for a manufacturer prefix filter to work). tF This way, you may filter on an entire manufacturer's class of systems.  F There is a single packet size filter (which may not be saved with the K SAVE/FILTERS command); it specifies a range of packet data body sizes (not .G counting the MAC header) which will be accepted for further processing.A  G Filters may be enabled and disabled independently of each other. Newly OK created filters (with ADD FILTER) default to being enabled; filters loaded CL with the LOAD/FILTER command are initially disabled. The SET FILTER command * may be used to enable or disable a filter.  L A filter may be set up to exclude a matching message from processing, or to K only process the message if it matches. If multiple filters are enabled, a MI packet is accepted only if it matches at least one ONLY address and ONLY  E protocol (if such are enabled) and does not match any of the enabled EL EXCLUDE filters. For example, if you wanted to accept packets only from any A of 10 workstations, you would create 10 filters, each specifying ,L ONLY=SOURCE=@i<workstation-address> for one of the workstations, and enable  all of these filters.M  H Filters may be entered using DECnet or IP addresses; however, these are K always translated to corresponding physical Ethernet addresses. You cannot  K presently filter on the actual Internet IP address field in a packet body, NJ or on other information in the body of a packet, with the current version " of ETHERMON (although two offline D analysis tools are provided to use with TRACE files to provide such H additional filtering; see section @Ref[Utilities] for more information). @Newpage @Section(Commands)I Once ETHERMON is running, initially nothing will be going on (except for  J automatic address/name data collecting); the utility will prompt the user D for command input. ETHERMON will continue to execute until the EXIT 9 command or a control-Z is typed to terminate the program.n  G The defined commands are listed below; explanations of their functions e8 and detailed syntax are given in the following sections. @Begin(Verbatim)        @@indirect-command-file        ADD FILTERn        CLEAR FILTER         CLEAR FLAGS        DEFINE/KEY         DELETE/KEYE        DISPLAY DESTINATIONSe        DISPLAY PROTOCOLS        DISPLAY SIZES        DISPLAY SOURCES        DISPLAY STATISTICSi        EXITA        HELPL        LOADE
        MAP        MONITOR        PINGd        QUERY        SAVER        SET ADDRESS_NAMEL        SET FILTERP        SET INTERVALx        SET KEYPAD         SET MANUFACTURERd        SET MESSAGES         SET PROTOCOL_NAME        SHOW ADDRESS_NAMES         SHOW BRIDGESm        SHOW FILTERSN        SHOW KEY.        SHOW MANUFACTURERS         SHOW MESSAGES        SHOW PERFORMANCEr        SHOW PORT_STATUSm        SHOW PROTOCOL_NAMES        SPAWN        SUMMARIZE DESTINATION        SUMMARIZE INTERNETL        SUMMARIZE PROTOCOLi        SUMMARIZE SIZEt        SUMMARIZE SOURCE.        SUMMARIZE STATISTICSe        TRACE        WAITm @End(Verbatim) @Newpage @SubSection(Command Parameters)EJ Certain command parameters have a constant format throughout ETHERMON. To K simplify this user's manual, these formats are described here, rather than o individually for each command." @SubSubSection(Ethernet addresses) @Label[address]xK Ethernet addresses are 6-byte addresses. Users can specify them as command =? parameter and qualifier values in any of the following formats:] @Begin(Enumerate)yC a physical Ethernet address in standard Xerox notation of the form pF @i<aa-bb-cc-dd-ee-ff>, where each letter group is a one- or two-digit  hexadecimal number.t  K a physical manufacturer prefix code in standard Xerox notation of the form  I @i<aa-bb-cc>, where each letter group is a one- or two-digit hexadecimal GL number. You should always enter this as a even address (LSB of first number H even), as the multicast bit is always cleared before doing manufacturer J comparisons. Note that this is only legal for the ADD/SET FILTER command, H the SHOW ADDRESS_NAMES command, and the SET MANUFACTURER command; other % commands require a full node address.   I a DECnet node number in the form @i<aa.bbb>, where @i<aa> is the decimal iL DECnet area number (in the range 1 to 63) and @i<bbb> is the decimal DECnet I node number within the area (in the range 1 to 1023); the DECnet address p7 translates directly to an Ethernet address of the form oC AA-00-04-00-@i<xx-yy>, where @i<yyxx> is the hexadecimal composite s( DECnet address ((area * 1024) + number).  G a DECnet node name (a 1- to 6-character alphanumeric string); the node i> name must already be listed in the address table (so that the 5 command can look up the equivalent Ethernet address).,  B an Internet logical IP address (four decimal numbers separated by E periods, each ranging from 0 to 255, in the format @i<a.b.c.d>); the sF Internet address must already be listed in the address table (so that 9 the command can look up the equivalent Ethernet address).s  I an Ungermann-Bass device serial number in the format UB#@i<nnnnn>, where MJ @i<nnnnn> is the serial number of the device; ETHERMON will automatically K determine which manufacturer prefix the device uses from the serial number oC range, and compute an address of the form 00-DD-00-@i<aa-bb>-00 or   00-DD-01-@i<aa-bb-cc>. @End(Enumerate)   J Some commands can accept wildcards; in these cases, wildcards may only be G used in the physical hexadecimal Ethernet and Internet logical address tM formats, and is done by replacing a number in a field with an asterisk ('*').  @SubSubSection(Protocol types) @Label[protocol]N Ethernet protocols are 2-byte code numbers. Users can specify them as command B parameter and qualifier values in either of the following formats: @Begin(Enumerate) K a physical Ethernet protocol number in standard Xerox notation of the form nM @i<aa-bb>, where each letter group is a one- or two-digit hexadecimal number.   M for certain commonly used protocol types, a symbolic name may also be used.    The defined symbolic names are:E @Begin(Itemize) 4 AARP - AppleTalk Address Resolution Protocol (80-F3)  ; APPLETALK - AppleTalk Phase I or Phase II EtherTalk (80-9B)t  6 ARP - DoD Internet Address Resolution Protocol (08-06)  I DECNET - Digital Equipment Corporation's DECnet Phase IV protocol (60-03)B  ' DOMAIN - Apollo DOMAIN protocol (80-19)O  " IP - DoD Internet Protocol (08-00)  K LAT - Digital Equipment Corporation's Local Area Terminal service protocol M (60-04)d  F LAVC - Digital Equipment Corporation's Local Area VAXcluster protocol  (60-07),  D LOOPBACK - the Ethernet-specification loopback test protocol (90-00)  J MOP_DLA - Digital Equipment Corporation's Maintenance Operations Protocol   for Dump/Load Assistance (60-01)  I MOP_RC - Digital Equipment Corporation's Maintenance Operations Protocol a% for Remote Console operations (60-02)   ? RARP - DoD Internet Reverse Address Resolution Protocol (80-35)l  @ XNS - Xerox Network Services: Internet Datagram Protocol (06-00)
 @End(Itemize)  @End(Enumerate)t  M Protocol type numbers may not be wild-carded. At present, the command parser cO cannot tell the difference between an IEEE 802.3 SNAP extended protocol and an ;G Ethernet protocol, so if you have a protocol used in both modes, it is tH specified the same way, and the ETHERMON software will treat both forms D identically. This limitation will be removed in a future release of 	 ETHERMON.N  J A list of protocol types known to ETHERMON can be obtained by issuing the   SHOW PROTOCOL_NAMES/ALL command.C @IndexSecondary(Primary="commands",Secondary="SHOW PROTOCOL_NAMES")T @Index(SHOW PROTOCOL_NAMES)o& @SubSection(Command Editing and Entry)! @SubSubSection(Keypad Operations)nP On ANSI-compatible video terminals with numeric and editing keypads, the keypad E may be used to enter command lines with single keystrokes, using the tH command recall and line-editing features of the VMS terminal driver and K Screen Management facility (SMG$). Some keypad keys are predefined and may nC not be changed by the user; others are undefined, and may be given  ' definitions via the DEFINE/KEY command.e: @IndexSecondary(Primary="commands",Secondary="DEFINE/KEY") @Index(DEFINE/KEY)J The keypad is defined in two states (similar to other VMS utilities): the J default state, and the GOLD state (entered by pressing the PF1 key before K pressing another key). As such, there are two sets of key definitions, one eJ by default and the other GOLDed. For the VT220/LK201 keyboard layout, the J default definitions for the numeric keypad and editing keypad as as shown  below:< @Picture(Size=3.6inches,PostScript="ETHERMON_MSS_KEYDEF.PS")N On VT100 keyboards, use only the numeric keypad keys; the cursor (arrow) keys I will still operate, but are located in a different place on the keyboard.   A When the GOLD key has been used, the initial key definitions are:a= @Picture(Size=3.6inches,PostScript="ETHERMON_MSS_KEYGOLD.PS")p  ? Note that all of these key definitions are not user-changeable.o  D For convenience in defining several key definitions, the DEFINE/KEY P commands may be placed in an indirect command file (just as any another command 
 may be used).d @SubSubSection(Control Keys)E There are several control keys on the keyboard which control special VH functions of ETHERMON. Most of them are standard VMS editing keys (DEL, G control-R, control-V, etc.), but a few of them are special to ETHERMON.r  D Control-C is the command abort key; rather than interrupting all of K ETHERMON like the control-Y key would do, it merely interrupts the current tN ETHERMON internal command or indirect command file in progress (if any). This N way, commands that continue to execute for a very long time (or indefinitely) O may be stopped prematurely. For commands that cannot be aborted, the control-C fH is ignored. @b[Note that control-C is now the only way to end a DISPLAY I command (unlike earlier versions of ETHERMON, where any key would stop a i
 DISPLAY).] @Index(control-C)e @Index(control-Y)n7 @IndexSecondary(Primary="commands",Secondary="DISPLAY")e @Index(DISPLAY)h  L Control-Z is the program termination command; it performs the same function J as the EXIT command does; however, it will not terminate ETHERMON while a H DISPLAY command is running until the DISPLAY is first terminated with a 
 control-C. @Index(control-Z)r @Newpage$ @SubSection(@@indirect-command-file)J The @@@i<file> command causes a file of ETHERMON commands to be executed. G Only one level of input indirection is allowed, and parameters may not nL be passed to the command file. It is not recommended to put an EXIT command K into the indirect file, as it will cause the program to terminate (unless,  D of course, that is what you want to happen). The file is assumed to   have a default filetype of .COM. @Index(@@filespec): @IndexSecondary(Primary="commands",Secondary="@@filespec")   Command format:r @Begin(InputExample)   @@@i<filename> @End(InputExample)  H The control-C key may be used to interrupt the execution of an indirect K command file, but only at points where the individual commands in the file E could be interrupted.D @SubSection(ADD FILTER)rI The ADD FILTER command adds a new filter definition to the filter table, iF optionally (and defaultly) enabling the filter for use in restricting I data collection. No check is performed to test if this filter duplicates .@ an existing definition. The filter can accept either matches or F mismatches independently on source and/or destination address, and/or " protocol type, in any combination.  G During message reception for any DISPLAY, SUMMARIZE, or TRACE command, oH only those messages which can pass all of the enabled exclusion filters D (if any) and at least one of each enabled address and protocol type , inclusion filter (if any) will be processed.   Command format:e: @IndexSecondary(Primary="commands",Secondary="ADD FILTER") @Index(ADD FILTER) @Index(filter) @Begin(InputExample)   ADD FILTER /ENABLE (default)            /DISABLE=?            /ONLY=([PROTOCOL=@i<protocol>],[SOURCE=@i<address>],dB                   [DESTINATION=@i<address>],[ADDRESS=@i<address>],                   [MULTICAST])B            /EXCLUDE=([PROTOCOL=@i<protocol>],[SOURCE=@i<address>],E                      [DESTINATION=@i<address>],[ADDRESS=@i<address>],m!                      [MULTICAST])e   @End(InputExample)L where @i<protocol> is a Ethernet protocol type code, expressed as described K in section @Ref[protocol], and @i<address> is a node address, expressed as  # described in section @Ref[address].I  G The use of SOURCE= specifies that the @i<address> is only treated as a =B source address; DESTINATION= specifies a destination address only;F ADDRESS= implies the address regardless of whether it was a source or J destination; and MULTICAST specifies any multicast destination (including  the Broadcast address).s @Index(multicast address)a @SubSection(CLEAR FILTER)pH The CLEAR FILTER command removes one or all filter definitions from the B filter table. The definition(s) are completely erased (not merely @ disabled); to disable a filter without deleting it, use the SET  FILTER/DISABLE command.t: @IndexSecondary(Primary="commands",Secondary="SET FILTER") @Index(SET FILTER) @Index(filter)   Command format:x< @IndexSecondary(Primary="commands",Secondary="CLEAR FILTER") @Index(CLEAR FILTER) @Begin(InputExample)   CLEAR FILTER @i<filternumber>    CLEAR FILTER /ALLI   @End(InputExample)D where @i<filternumber> specifies the number of the filter to delete N (displayed by the ADD FILTER, SET FILTER, and SHOW FILTER commands), and /ALL . specifies clearing all filters from the table. @SubSection(CLEAR FLAGS)C The CLEAR FLAGS command clears the Internet (IP) flag bits for all sH address table entries (see the SHOW ADDRESS_NAMES command for the /TYPE C qualifier). This is primarily available to allow re-deriving of IP eJ addresses for nodes when some of the addresses are garbled (generally due I to glitchy RIP-type IP routing messages detected on the Ethernet). After TF entering the command, automatic IP address derivation will start over H from scratch (although the Ethernet address entries themselves will not  be deleted).B @IndexSecondary(Primary="commands",Secondary="SHOW ADDRESS_NAMES") @Index(SHOW ADDRESS_NAMES)8 @IndexSecondary(Primary="protocol type",Secondary="RIP") @Index(RIP)g   Command format:c; @IndexSecondary(Primary="commands",Secondary="CLEAR FLAGS")  @Index(CLEAR FLAGS)  @Begin(InputExample)   CLEAR FLAGS    @End(InputExample) @SubSection(DEFINE/KEY)uE The DEFINE/KEY command associates an equivalence string and a set of AF attributes with a key on the terminal keyboard. The /KEY qualifier is 	 required.b   Command format: : @IndexSecondary(Primary="commands",Secondary="DEFINE/KEY") @Index(DEFINE/KEY) @Begin(InputExample)  @ DEFINE/KEY [/@i<qualifiers>] @i<key-name> @i<equivalence-string>   @End(InputExample)G where @i<key-name> specifies the name of the key that you are defining,eI and @i<equivalence-string> specifies the string which is to be processed aG when you press the key. The entire remaining portion of the line after aB the key name is accepted as the equivalence string, as-is, so all E qualifiers for the DEFINE/KEY command (as opposed to the equivalence w( string) must appear before the key-name.  2 The defined command qualifiers for DEFINE/KEY are: @Begin(Itemize) H /NOECHO - determines whether the equivalence string is displayed on yourB screen after the key has been pressed. By default, the equivalence2 string is echoed to the screen when it is pressed.  L /IF_STATE=state-name - specifies a state which must be in effect for the keyE definition to be in effect. If you omit the /IF_STATE qualifier, the  L default state is used. The state name is an alphanumeric string. States are G established with the /SET_STATE qualifier. The states already known to lK ETHERMON are DEFAULT (implied if /IF_STATE is not used) and GOLD (keypress  , immediately following pressing the PF1 key).  G /LOCK_STATE - specifies that the state set by the /SET_STATE qualifier oL remain in effect until explicitly changed. If you do not use the /LOCK_STATEF qualifier, the state set by /SET_STATE is in effect only for the next H defineable key that you press or for the next read terminating characterH that you type. The /LOCK_STATE qualifier can only be specified with the  /SET_STATE qualifier.a  K /SET_STATE=state-name - causes the specified state-name to be set when the cK key is pressed. The state name can be any alphanumeric string. If you omit dG the /SET_STATE qualifier, the current state that was locked remains in oG effect; if there is no locked state, the DEFAULT state becomes the new l state.  G /TERMINATE - specifies whether the current equivalence string is to be  I terminated (that is, processed) when the key is pressed. Pressing RETURN  G after pressing the defined key has the same effect as using /TERMINATE.,
 @End(Itemize)   J The following table lists the key names in column one. The remaining threeD columns indicate the key designations on the keyboards for the three< different types of terminals that allow key definitions. AllC definable keys on VT52 terminals are located on the numeric keypad.g@ On VT100-type terminals, you can define the LEFT and RIGHT arrowI keys as well as all the keys on the numeric keypad (although re-defining e3 the arrow keys is not recommended). There are threeaD types of keys that can be defined on terminals with LK201 keyboards:> (1) keys on the numeric keypad, (2) keys on the editing keypadA (except the UP and DOWN arrow keys), and (3) keys on the functionu> key row across the top of the terminal.  (Note that you cannot$ define function keys F1 through F5.)   @Begin(Verbatim);       Key-name         LK201            VT100-type     VT52f  =       PF1              PF1              PF1            [blue]g<       PF2              PF2              PF2            [red]=       PF3              PF3              PF3            [gray] :       PF4              PF4              PF4            - -@       KP0,KP1,...,KP9  0,1,...,9        0,1,...,9      0,1,...,98       PERIOD           .                .              .:       COMMA            ,                ,              n/a:       MINUS            -                -              n/a<       ENTER            Enter            ENTER          ENTER:       Find (E1)        Find             - -            - -:       Insert Here (E2) Insert Here      - -            - -:       Remove (E3)      Remove           - -            - -:       Select (E4)      Select           - -            - -:       Prev Screen (E5) Prev Screen      - -            - -:       Next Screen (E6) Next Screen      - -            - -:       HELP             Help             - -            - -:       DO               Do               - -            - -:       F6, F7, ..., F20 F6, F7, ..., F20 - -            - - @End(Verbatim)  = Some defineable keys are enabled for definition all the time. D Others, including KP0 through KP9, PERIOD, COMMA, and MINUS, need to: be enabled for definition purposes. You must issue the SETI KEYPAD APPLICATION command before using these keys (by default, ETHERMON  H implicitly issues this command, but its effect may be cancelled with the SET KEYPAD NUMERIC command). @Index(SET KEYPAD): @IndexSecondary(Primary="commands",Secondary="SET KEYPAD")  C The LEFT and RIGHT arrow keys and the F6 through F14 VT200 keys arer; reserved for command line editing.  You must issue the SET EI TERMINAL/NOLINE_EDITING command from the DCL level before defining these eM keys. You can also press control-V to enable keys F7 through F14.  Note that f% control-V will not enable the F6 key.a @Index(control-V)h  G Following is a sample of how to use defineable keys. The user wanted a fK method of typing a long, complicated TRACE command in as soon as a certain  L event occurred. A key definition was made to define the keypad ENTER key as L translating to the command. When the event alert message occurred, the user 4 merely had to press a single key to begin recording.   @Begin(InputExample)K ETHERMON> @u[DEFINE/KEY/TERM/NOECHO ENTER TRACE/BIN/PARA/INT=:5/OUT=GRABIT]s
 ETHERMON>      .      .      .oL %ETHERMON-I-MOPMSG, 11:22:33 08-00-2B-12-34-56 sent MOP DLA msg, t=0508 ln=8* ETHERMON> @i{@u[<press keypad ENTER key>]}= %ETHERMON-I-ASYNTRCBEG, asynchronous TRACE command started...a @End(InputExample) @SubSection(DELETE/KEY)aM The DELETE/KEY command deletes key definitions that have been established by e8 the DEFINE/KEY command.  The /KEY qualifier is required.   Command Format:d: @IndexSecondary(Primary="commands",Secondary="DELETE/KEY") @Index(DELETE/KEY) @Begin(InputExample)  ( DELETE/KEY [/@i<qualifier>] @i<key-name>   @End(InputExample)N where @i<key-name> specifies the name of the key whose definition you want to M delete, and the optional qualifier is /STATE=state-name, which specifies the aK name of the state for which the specified key definition is to be deleted. eB State names can be any alphanumeric string already defined by the + DEFINE/KEY command. If you omit the /STATE l< qualifier, key definitions in the DEFAULT state are deleted.  ! @SubSection(DISPLAY DESTINATIONS)rC The DISPLAY DESTINATIONS command brings up a continuously updating nI screen (similar to the VMS MONITOR utility) reporting on the current top  J @i<N> destination addresses that Ethernet messages are being sent to. The L screen is updated at the rate specified by the SET INTERVAL command, and is * terminated by the user typing a control-C. @Index(control-C)a< @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL)   Command format:rD @IndexSecondary(Primary="commands",Secondary="DISPLAY DESTINATIONS") @Index(DISPLAY DESTINATIONS) @Begin(InputExample)    DISPLAY DESTINATIONS [/NOFILTER]   @End(InputExample)  E The upper part of the screen reports the display type and the system eH name and interface port used for collecting the data. Below that is the F report of messages lost (generally because the program could not read D and process them as fast as they were coming in), and the number of D messages and bytes of data received before and after filtering. The A remainder of the screen is a bar graph, displaying the number of  G post-filter messages received for the top @i<N> destination addresses,  I where the addresses are displayed as physical Ethernet addresses and the nI first few characters of their combined equivalence names (if any, as manyr2 as will fit for the available screen size). After A the physical address is the message count in messages per second (F (averaged over the sampling interval) and the bar graph line for that  value.  D The /NOFILTER qualifier specifies that the DISPLAY will not use the M currently active filters to restrict displayed data; this is useful when you tB have a background TRACE command running and still want to use the 	 displays.p5 @IndexSecondary(Primary="commands",Secondary="TRACE") 
 @Index(TRACE)l @SubSection(DISPLAY PROTOCOLS)@ The DISPLAY PROTOCOLS command brings up a continuously updating I screen (similar to the VMS MONITOR utility) reporting on the current top  F @i<N> protocol types that Ethernet messages are being sent under. The L screen is updated at the rate specified by the SET INTERVAL command, and is * terminated by the user typing a control-C. @Index(control-C)a< @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL)   Command format: A @IndexSecondary(Primary="commands",Secondary="DISPLAY PROTOCOLS")i @Index(DISPLAY PROTOCOLS)i @Begin(InputExample)   DISPLAY PROTOCOLS [/NOFILTER]a   @End(InputExample)  E The upper part of the screen reports the display type and the system  H name and interface port used for collecting the data. Below that is the F report of messages lost (generally because the program could not read D and process them as fast as they were coming in), and the number of D messages and bytes of data received before and after filtering. The A remainder of the screen is a bar graph, displaying the number of u? post-filter messages received for the top @i<N> protocol types,eO where the protocol types are displayed as physical Ethernet type codes and the f? first few characters of their equivalence name (if any, as many H as will fit for the available screen size); if an 'i' appears after the E physical protocol type number, this is an IEEE 802.3 extended (SNAP)  1 protocol rather than an Ethernet protocol. After MC the physical type code is the message count in messages per second sF (averaged over the sampling interval) and the bar graph line for that  value.  D The /NOFILTER qualifier specifies that the DISPLAY will not use the M currently active filters to restrict displayed data; this is useful when you iB have a background TRACE command running and still want to use the 	 displays.S5 @IndexSecondary(Primary="commands",Secondary="TRACE")k
 @Index(TRACE)  @SubSection(DISPLAY SIZES)< The DISPLAY SIZES command brings up a continuously updating E screen (similar to the VMS MONITOR utility) reporting on the current a? number of Ethernet messages in each of 15 size categories. The "L screen is updated at the rate specified by the SET INTERVAL command, and is * terminated by the user typing a control-C. @Index(control-C) < @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL)   Command format:b= @IndexSecondary(Primary="commands",Secondary="DISPLAY SIZES")  @Index(DISPLAY SIZES)s @Begin(InputExample)   DISPLAY SIZES [/NOFILTER]t   @End(InputExample)  E The upper part of the screen reports the display type and the system TH name and interface port used for collecting the data. Below that is the F report of messages lost (generally because the program could not read D and process them as fast as they were coming in), and the number of D messages and bytes of data received before and after filtering. The A remainder of the screen is a bar graph, displaying the number of oI post-filter messages received for the 15 size categories, ranging from 1 nE to 100 bytes, to 1401 to 1500 bytes, in size partitions of 100 bytes.eP After the size range on the display is the message count in messages per second F (averaged over the sampling interval) and the bar graph line for that  range.  D The /NOFILTER qualifier specifies that the DISPLAY will not use the M currently active filters to restrict displayed data; this is useful when you eB have a background TRACE command running and still want to use the 	 displays.n5 @IndexSecondary(Primary="commands",Secondary="TRACE") 
 @Index(TRACE)n @SubSection(DISPLAY SOURCES)> The DISPLAY SOURCES command brings up a continuously updating I screen (similar to the VMS MONITOR utility) reporting on the current top nE @i<N> source addresses that Ethernet messages are being sent to. The oL screen is updated at the rate specified by the SET INTERVAL command, and is * terminated by the user typing a control-C. @Index(control-C)s< @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL)   Command format:S? @IndexSecondary(Primary="commands",Secondary="DISPLAY SOURCES")  @Index(DISPLAY SOURCES)p @Begin(InputExample)   DISPLAY SOURCES [/NOFILTER]u   @End(InputExample)  E The upper part of the screen reports the display type and the system sH name and interface port used for collecting the data. Below that is the F report of messages lost (generally because the program could not read D and process them as fast as they were coming in), and the number of D messages and bytes of data received before and after filtering. The A remainder of the screen is a bar graph, displaying the number of  B post-filter messages received for the top @i<N> source addresses, I where the addresses are displayed as physical Ethernet addresses and the yI first few characters of their combined equivalence names (if any, as manys2 as will fit for the available screen size). After A the physical address is the message count in messages per second  F (averaged over the sampling interval) and the bar graph line for that  value.  D The /NOFILTER qualifier specifies that the DISPLAY will not use the M currently active filters to restrict displayed data; this is useful when you  B have a background TRACE command running and still want to use the 	 displays. 5 @IndexSecondary(Primary="commands",Secondary="TRACE") 
 @Index(TRACE)L @SubSection(DISPLAY STATISTICS)RA The DISPLAY STATISTICS command brings up a continuously updating EH screen (similar to the VMS MONITOR utility's unsupported ETHERNET class L display) reporting on the current Ethernet port statistics (or counters, to ! use DECnet NCP terminology). The sL screen is updated at the rate specified by the SET INTERVAL command, and is * terminated by the user typing a control-C. @Index(control-C)s< @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL) @Index(NCP)n   Command format:RB @IndexSecondary(Primary="commands",Secondary="DISPLAY STATISTICS") @Index(DISPLAY STATISTICS) @Begin(InputExample)   DISPLAY STATISTICS   @End(InputExample)  E The upper part of the screen reports the display type and the system  H name and interface port used for collecting the data. Below that is the F report of messages lost (generally because the program could not read D and process them as fast as they were coming in), and the number of D messages and bytes of data received before and after filtering. The G remainder of the screen is a display of current, average, minimum, and mD maximum counts (averaged over the sampling interval) for data bytes F received, data messages received, multicast bytes received, multicast G messages received, single and multiple collisions, transmission delays f7 due to potential collision, and assorted buffer errors.R  < There are two points to keep in mind regarding this command: @Begin(Enumerate)lL The data displayed by this command is from the raw counters in the Ethernet C interface itself; no filtering can be applied to this data, so the EL /NOFILTER qualifier is meaningless (the results will be the same whether or  not filtering is applied).  C Because some of the data counters saturate or "wrap around" if the iI interface has been running for a while since it was last zeroed, some of iH the "current data" fields in this display may appear as lines of hyphens9 (flagging that those particular counters have saturated). C To correct this, use the SHOW PORT_STATUS/ZERO command to zero the WF counters; this should correct any such display errors. Conversely, if L another user issues the DECnet NCP command ZERO LINE COUNTERS, it may cause H the display to briefly show erroneous currnet data (which will probably J corrupt the average, minimum, and maximum data). This can be corrected by J re-issuing the DISPLAY STATISTICS command, so that it starts with a fresh  set of data. @Index(SHOW PORT_STATUS)@ @IndexSecondary(Primary="commands",Secondary="SHOW PORT_STATUS") @Index(NCP)d @End(Enumerate)a @SubSection(EXIT)ID The EXIT command terminates execution of the ETHERMON utility. This H function is also performed by typing control-Z. The special promiscuous E Ethernet port is shut down and deleted, any active TRACE/PARALLEL or  J TRACE/REPEAT command is terminated as if a TRACE/ABORT command was typed, ! and all information collected by rL ETHERMON (except that previously stored with the SAVE command) is discarded.   Command format:s4 @IndexSecondary(Primary="commands",Secondary="EXIT") @Index(EXIT) @Index(control-Z) 
 @Index(TRACE)o5 @IndexSecondary(Primary="commands",Secondary="TRACE")D @Begin(InputExample)   EXIT   @End(InputExample) @SubSection(HELP)vG The HELP command obtains helpful information on the formats and usages .F of the ETHERMON commands. It functions similarly to standard VMS HELP.   Command format:T4 @IndexSecondary(Primary="commands",Secondary="HELP") @Index(HELP) @Begin(InputExample)   HELP [topic ...]   @End(InputExample) @SubSection(LOAD)tG The LOAD command reads a saved file of ETHERMON table information into lA the run-time database of the program. Four tables of dynamically  E updated name equivalences are maintained by the utility: the address eH table (storing equivalences to Ethernet physical addresses), the filter F table (storing message filtering definitions), the manufacturer prefixL table (storing three-byte Ethernet address prefixes), and the protocol type I table (storing equivalence names for Ethernet protocol types). LOAD will oI read a file and merge the file contents into one of these tables (append KE to table end for the filters table). The input file format is rather aH inflexible and defined to match the files generated by the SAVE command.   Command format:s @Index(LOAD)4 @IndexSecondary(Primary="commands",Secondary="LOAD") @Index(SAVE)4 @IndexSecondary(Primary="commands",Secondary="SAVE") @Index(address)e @Index(filter) @Index(Internet) @Index(manufacturer prefix)t @Index(protocol type)i @Begin(InputExample)  # LOAD /ADDRESSES     [@i<inputfile>]n#      /FILTERS       [@i<inputfile>]y      /INTERNET#      /MANUFACTURERS [@i<inputfile>]f#      /PROTOCOLS     [@i<inputfile>]    @End(InputExample)B where /ADDRESSES if the default if no qualifier is specified, and D @i<inputfile> is the optional specification of the file to read; if I @i<inputfile> is missing or incomplete, the file specification is filled AD in from the default of SYS$DISK:[]ETHERMON.ETH_@i<qualifier>, where ? @i<qualifier> is the name of the qualifier currently in effect.r  I Upon LOADing an address, manufacturer prefix, or protocol type file, the eJ file entries are merged with any existing entries in the table; duplicate N fields are overwritten, but fields not specified in the file for a particular J Ethernet address, prefix, or protocol are not changed. Note that multiple I protocol entries for with and without IEEE 802 mode will not be properly a handled by the current version.s   Upon LOADing a filter F file, all file entries are added as new entries; no match-ups between I existing filter table entries and the new ones are made. Also, since the FH filter table is rather small (only 25 entries), it is very possible for G the file read to prematurely terminate with a "table full" error; this  G will not abort ETHERMON, but will merely stop reading any more entries ,A from the file. Also note that all filters LOADed from a file are  C initially disabled and, to be used, must be turned on with the SET a FILTER/ENABLE command.: @IndexSecondary(Primary="commands",Secondary="SET FILTER") @Index(SET FILTER) @Index(filter)  E If /INTERNET is specified, ETHERMON attempts to connect to the local eC Internet software running on the local system; currently, only TGV  O MultiNet, DEC VMS/Ultrix Connection (UCX, now called TCP/IP Services for VMS),  E Carnegie-Mellon University TCP/IP (CMU TCP/IP), and Network Research  1 Corporation's Fusion (NRC Fusion) are supported.  C @IndexSecondary(Primary="Internet software",Secondary="CMU TCP/IP")-@ @IndexSecondary(Primary="Internet software",Secondary="DEC UCX")T @IndexSecondary(Primary="Internet software",Secondary="DEC TCP/IP Services for VMS")E @IndexSecondary(Primary="Internet software",Secondary="TGV MultiNet") C @IndexSecondary(Primary="Internet software",Secondary="NRC Fusion")f* If the connection succeeds, ETHERMON will I query the Internet software for any entries that match detected Internet mL addresses seen on the cable which have not received "real" name strings (as I opposed to ASCII representations of the physical address). Any match-ups dH have their Internet name strings replaced with the name supplied by the K Internet software. Note that the results of this command will be no better tK than the local Internet software can supply, so if your local node doesn't tH know much and does not have access to Domain Name Service, don't expect  much from this command.i @Index(Domain Name Service)I @SubSection(MAP)G The MAP command attempts to query each Ethernet bridge currently known fH to the program for its packet forwarding tables, in order to attempt to H build a interconnection "map" of the Ethernet segments visible from the  current monitoring point.e   Command format:e3 @IndexSecondary(Primary="commands",Secondary="MAP")  @Index(MAP)e @Index(bridge) @Begin(InputExample)   MAPl   @End(InputExample)  I Note that the MAP command only works for bridges speaking DEC LAN Bridge  J protocol (80-38) or Ungermann-Bass's spanning tree protocol run over XNS,  @Index(DEC LAN Bridge)G @IndexSecondary(Primary="protocol type",Secondary="LAN Bridge (80-38)")o @Index(XNS)a@ @IndexSecondary(Primary="protocol type",Secondary="XNS (06-00)")6 and is not guaranteed to work for those (depending on C filtering, passwords, etc.); however, references to any recognized qH bridge (whether or not it speaks a bridge protocol that the MAP command ( knows how to use) will be listed in the ? overall bridge routing map constructed by ETHERMON. To see the IH computed map, issue the SHOW BRIDGES/FULL command; to plot the map as a = PostScript graphic image, issue the SHOW BRIDGES/MAP command.E< @IndexSecondary(Primary="commands",Secondary="SHOW BRIDGES") @Index(SHOW BRIDGES)  N Note that the map is not guaranteed to be totally accurate; since bridges may L not respond to queries, or the responses may get dropped due to overloading  of the monitoring VAX. @SubSection(MONITOR)F The MONITOR command is a synonym for the DISPLAY command, for ease of A use for heavy VMS MONITOR users. Any of the DISPLAY keywords and T$ qualifiers may be used with MONITOR.   Command format:t7 @IndexSecondary(Primary="commands",Secondary="MONITOR")h @Index(MONITOR)a @Begin(InputExample)   MONITOR DESTINATIONS   MONITOR PROTOCOLSm  
 MONITOR SIZESr   MONITOR SOURCES.   MONITOR STATISTICS   @End(InputExample) @SubSection(PING)aG The PING command attempts to "ping" a message off a remote node on the dI Ethernet, similar to the Unix "ping" utility, and reports the turnaround SH time if successful; however, the ETHERMON PING command can "ping" using  multiple protocols.h   Command format: 4 @IndexSecondary(Primary="commands",Secondary="PING") @Index(PING) @Begin(InputExample)  # PING [/IEEE_LOOPBACK] [@i<address>]t PING /IEEE_MOP [@i<address>] PING /INTERNET [@i<address>] PING /LOOPBACK [@i<address>] PING /MOP [@i<address>]    @End(InputExample)J where the address of the remote node is expressed as described in section L @Ref[address]; note that a full, non-wildcarded address must be used. If no 5 address is specified, the Ethernet Broadcast address  G (FF-FF-FF-FF-FF-FF) will be used. This is useful when you wish to test nH for the existence of a certain group of nodes, or just to help fill the B address names table (by causing relatively idle nodes to generate " traffic that ETHERMON can detect).  B The qualifiers specify which format of "ping" message to use. The @ default is /IEEE_LOOPBACK if no qualifier is given. The message  formats available are: @Begin(Enumerate)l@ /IEEE_LOOPBACK: using IEEE 802.3 SNAP protocols for the general  loopback protocol type (90-00).mE @IndexSecondary(Primary="protocol type",Secondary="loopback (90-00)")m @Index(IEEE 802.3)  D /IEEE_MOP: using IEEE 802.3 SNAP protocols using the DEC MOP Remote B Console protocol (60-02) type's Request ID and System ID response  message types.@ @IndexSecondary(Primary="protocol type",Secondary="MOP (60-02)") @Index(IEEE 802.3)  B /INTERNET: using DoD Internet IP (08-00) datagrams using the ICMP G Echo Request and Echo Reply message formats. Note that the target node  F must have an IP address stored for it in the address table, and, most J likely, replies may not come back if the Ethernet port you are monitoring " on is not already speaking TCP/IP.? @IndexSecondary(Primary="protocol type",Secondary="IP (08-00)")m  F /LOOPBACK: using Ethernet protocols for the general loopback protocol 
 type (90-00).eE @IndexSecondary(Primary="protocol type",Secondary="loopback (90-00)")s  I /MOP: using Ethernet protocols using the DEC MOP Remote Console protocol r? (60-02) type's Request ID and System ID response message types.t@ @IndexSecondary(Primary="protocol type",Secondary="MOP (60-02)") @End(Enumerate)e  H @b<Note that, on a busy Ethernet, the PING command may fail because the D reply packet was discarded by the Ethernet I/O driver when ETHERMON H couldn't keep up with the incoming data flow. This does not necessatily * mean that the target node does not exist.> @SubSection(QUERY)H The QUERY command issues various types of queries to ranges of Ethernet F addresses; it assumes that the automatic address recognition logic in I ETHERMON will do something useful with the reply messages (if any). This tH allows searching for various types of remote devices by forcing them to   respond to a direct status poll.   Command format:r
 @Index(QUERY)a5 @IndexSecondary(Primary="commands",Secondary="QUERY")e @Begin(InputExample)  A QUERY/@i<querytype> [/@i<qualifier>] @i<address> [@i<endaddress>]e   @End(InputExample)K where @i<address> is the first address to query, expressed as described in dK section @Ref[address]; @i<endaddress> is an optional last address to query oG (all Ethernet addresses between the first address and the last address tF inclusive will be queried); and @i<querytype> is the type of query to  issue.   Legal query types include: @Begin(Itemize)tN /DECBRIDGE - issues a DEC "dump bridge statistics" query using DEC Lan Bridge  protocol (80-38).n  N /DECMOP - issues a DEC MOP "Request ID" query using DEC Maintenance Operations+ Protocols' Remote Console protocol (60-02).S  M /UB_BRIDGE - issues an Ungermann-Bass 'dump bridge forwarding table B' query IF using the XNS protocol (as would be done by an Ungermann-Bass Network  Management Console).
 @End(Itemize)l  H Additional @i<qualifiers> that may be specified are /LITTLE2_ENDIAN and K /LITTLE3_ENDIAN, which control the sequence in which the span of addresses eG is traversed. By default, Ethernet addresses are assumed to be big-end  L first, so one will be added to the last byte, with carries trickling to the J left as each byte overflows. However, some address sequences are differentK (DECnet addresses are little-endian over the last two bytes, for example); eJ to traverse these in a rational order, either of the above two qualifiers L may be used to indicate how many of the last bytes of the address should be G treated as little-endian order; bytes to the left of the little-endian nG group are treated as big-endian order and of larger magnitude than the l little-endian block.  I Note that this command can cause large amounts of network traffic, which dL may be particularly damaging to your network if you use remote bridges with I sub-Ethernet line speeds between the Ethernet segments. ETHERMON's QUERY a command has been xO measured to spew out approximately 200 messages/second on a VAX 6000-440, each oJ of which has a different destination address, which will massively strain L bridges trying to locate all the addresses that do not actually exist. Bear J this in mind before using this command. To prevent accidental overloading L of the Ethernet, a sanity check is applied to limit the number of addresses H that will be queried; if more than 1000 addresses could be queried, the K user is asked to confirm the address range before proceeding. If more than yD 16777215 addresses are in the range, the command is unconditionally 	 rejected.O @SubSection(SAVE) G The SAVE command writes the current contents of the ETHERMON utility's tN address, filter, manufacturer prefix, and protocol type tables to disk files, M where they may be archived for later use with the LOAD command. These tables tI are built from a combination of pre-defined "hardwired" entries, entries  N manually entered by the user, and entries automatically made by the automatic F address recognition and interpretation logic. However, their contents ! are lost when ETHERMON is exited.    Command format:  @Index(LOAD)4 @IndexSecondary(Primary="commands",Secondary="LOAD") @Index(SAVE)4 @IndexSecondary(Primary="commands",Secondary="SAVE") @Index(address)s @Index(filter) @Index(manufacturer prefix)e @Index(protocol type)s @Begin(InputExample)  $ SAVE /ADDRESSES     [@i<outputfile>]$      /FILTERS       [@i<outputfile>]$      /MANUFACTURERS [@i<outputfile>]$      /PROTOCOLS     [@i<outputfile>]   @End(InputExample)B where /ADDRESSES if the default if no qualifier is specified, and F @i<outputfile> is the optional specification of the file to write; if J @i<outputfile> is missing or incomplete, the file specification is filled D in from the default of SYS$DISK:[]ETHERMON.ETH_@i<qualifier>, where ? @i<qualifier> is the name of the qualifier currently in effect.   I For the /ADDRESSES qualifier, the output file is an ASCII file where one oG record corresponds to one entry in the address table. Each line begins tB with the Ethernet address expressed as a single 48-bit (12-digit) D hexadecimal number, last byte (not first) first. After the address, B delimited by spaces are the equivalences for the other fields, if I those fields are not empty (it is possible to have a record with only an IN Ethernet address and no equivalences whatsoever, if that node sent or receivedO messages only on protocols that ETHERMON cannot decipher). The second Ethernet   address field is of the form @Begin(ProgramExample) A:ffeeddccbbaa @End(ProgramExample)L where @i<ffeeddccbbaa> is the alternate Ethernet address stored in the same E form as the primary Ethernet address. The DECnet field is of the formt @Begin(ProgramExample) D:nn.mmm @End(ProgramExample) or @Begin(ProgramExample) D:name @End(ProgramExample)D where @i<name> is the DECnet node name (as recognized by your local G node's DECnet NETACP volatile database), or @i<nn.mmm> is the area and   @Index(NETACP)I node number representation if the node name was not known. The preceding ,I 'D:' is required and must be in upper case. The Internet field is of the l form @Begin(ProgramExample) I:a.b.c.d'domain-name' @End(ProgramExample)O where @i<a.b.c.d> is the decimal Internet IP physical address for the node and iG @i<domain-name> is the symbolic equivalence name string (surrounded by cB single quotes). Currently, ETHERMON has no way to translate an IP H address to a domain-name (other than the LOAD/INTERNET command), so the 0 @i<domain-name> field is usually a duplicate of B the IP address; the user may change this by editing the SAVE file F manually and LOADing the modified file back into ETHERMON. The serial  number field is of the forme @Begin(ProgramExample) S:nnnn @End(ProgramExample)C where @i<nnnn> is the variable-length decimal serial number in the eH manufacturer's numbering scheme. The XNS network number field is of the  form @Begin(ProgramExample)
 X:ddccbbaa @End(ProgramExample)K where @i<ddccbbaa> is a 4-byte hexadecimal number (last byte first) of the c@ XNS network number field. The miscellaneous field is of the form @Begin(ProgramExample)' Mxxxx:text optionally containing blanksm @End(ProgramExample)I where @i<xxxx> is a hexadecimal mask indicating what types of names have mI been stored in the miscellaneous name string, and the @i<text> can be of a) any length (not more than 80 characters, iB currently) and may contain embedded blanks or any other printable F characters; because of this, the miscellaneous field must be the last O field on the line, and all of the line after the 'M@i<xxxx>:' is assumed to be mM part of the miscellaneous name. Other fields stored in the address table are y& currently not stored in the SAVE file.  G For the /FILTERS qualifier, the output file is an ASCII file where one rC record corresponds to one entry in the filter table. Each line may ZG contain one or more definitions, delimited by spaces, which, combined, D4 make up that filter. The definitions are of the form @Begin(ProgramExample) @i[<mode>]S:addressh @i[<mode>]D:address  @i[<mode>]A:addresss @i[<mode>]MH @i[<mode>]P:typecode @End(ProgramExample)F where @i[<mode>] is one of the letters @b[O] (for Only) or @b[E] (for N Exclude), @b[S], @b[D], @b[A], and @b[P] indicate source address, destination F address, any address, or protocol type, @b[M] indicates any mulitcast ? destination address, @i<address> is either a 48-bit, 12-digit, tG high-byte-first physical Ethernet address (as used in the address SAVE aI file) or a 24-bit, 6-digit, high-byte first physical manufacturer prefix rF code, and @i<typecode> is a 16-bit, 4-digit, high-byte-first physical @ Ethernet protocol type code (as used in the protocol SAVE file).  M For the /MANUFACTURERS qualifier, the output file is an ASCII file where one sL record corresponds to one entry in the manufacturer prefix table. Each line I starts with a 24-bit, 6-digit hexadecimal number (high byte first) which eE is the manufacturer prefix code, followed by a space, an 8-character hJ blank-padded field for the short version of the prefix name, a space, and = arbitrary text (to the end of line) for the long form of the ) manufacturer name. m  I For the /PROTOCOLS qualifier, the output file is an ASCII file where one tF record corresponds to one entry in the protocol type table. Each line I starts with a 16-bit, 4-digit hexadecimal number (high byte first) which <F is the protocol type code, followed by a space and arbitrary text (to H the end of line) which is the equivalence name. Note that the IEEE flag G (indicating that the protocol is an IEEE 802.3 SNAP subtype or not) is tG not stored in a SAVE file. This limitation will be removed in a future   release. @SubSection(SET ADDRESS_NAME)lF The SET ADDRESS_NAME command manually adds a new entry to the address C name table with an equivalence name in the miscellaneous field, or  I overwrites the miscellaneous field of an existing entry. Hence, Ethernet eD addresses that cannot be recognized by the automatic interpretation  logic can be manually named.   Command format:e @Index(SET ADDRESS_NAME)@ @IndexSecondary(Primary="commands",Secondary="SET ADDRESS_NAME") @Begin(InputExample)  ' SET ADDRESS_NAME aa-bb-cc-dd-ee-ff name8  2 SET ADDRESS_NAME aa-bb-cc-dd-ee-ff "quoted string"   @End(InputExample)E where @i<aa-bb-cc-dd-ee-ff> is the standard format physical Ethernet cF address specification (low byte first, hexadecimal numbers); symbolic 1 address formats cannot be used here. @i<name> is nH a text string without embedded blanks or punctuation marks (other than _E or $), and @i<"quoted string"> is a string enclosed in double quotes wD (not considered part of the string) which may contain any printable I character other than a double quote. Only the first 80 characters of the dE supplied equivalence name will be stored in the table; if a matching dI entry already exists in the address table and its miscellaneous field is fI not empty, ETHERMON will prompt to verify that you wish to overwrite the cF existing field contents. Note that some pieces of address information I automatically computed by ETHERMON are stored in the miscellaneous field;rJ these will be destroyed by using this command, but will be regenerated by J ETHERMON when it sees new packets containing the information that derived   the name data the previous time. @SubSection(SET FILTER)eC The SET FILTER command modifies the configuration of a pre-defined dC filter, enables or disables a filter, or modifies the message size S6 filter settings. Filters can accept either matches or F mismatches independently on source and/or destination address, and/or " protocol type, in any combination.  G During message reception for any DISPLAY, SUMMARIZE, or TRACE command, mH only those messages which can pass all of the enabled exclusion filters D (if any) and at least one of each enabled address and protocol type , inclusion filter (if any) will be processed.   Command format:n: @IndexSecondary(Primary="commands",Secondary="SET FILTER") @Index(SET FILTER) @Index(filter) @Begin(InputExample)   SET FILTER filternum /ENABLE                      /DISABLEaI                      /ONLY=([PROTOCOL=@i<protocol>],[SOURCE=@i<address>],,L                             [DESTINATION=@i<address>],[ADDRESS=@i<address>],(                             [MULTICAST])L                      /EXCLUDE=([PROTOCOL=@i<protocol>],[SOURCE=@i<address>],9                                [DESTINATION=@i<address>],tA                                [ADDRESS=@i<address>],[MULTICAST])o#                      /NODESTINATIONd                       /NOPROTOCOL                      /NOSOURCE   SET FILTER /SIZE=(ENABLE,m                   DISABLE,                   MAXIMUM=nnn,                   MINIMUM=nnn)   @End(InputExample)J For the first form of the command, @i<filternum> is the index number of a L pre-existing filter definition (as reported by ADD FILTER and SHOW FILTER), M @i<protocol> is a protocol type code as described in section @Ref[protocol], dH and @i<address> is a node address as described in section @Ref[address].H Wildcards are permitted in the address, as are manufacturer-prefix-only M values. The use of SOURCE= specifies that the @i<address> is only treated as oE a source address; DESTINATION= specifies a destination address only; dF ADDRESS= implies the address regardless of whether it was a source or J destination; and MULTICAST specifies any multicast destination (including  the Broadcast address).e @Index(multicast address)S  I For the second form of the command, only one of ENABLE or DISABLE may be aF specified for the /SIZE qualifier, and these may be specified with or K without the MAXIMUM and MINIMUM options; these options take a decimal byte AM count @i<nnn> as the minimum and maximum message sizes that may pass through aE the filter. There is no safety check on minimum and maximum sizes to eH ensure that the maximum is greater than the minimum, so the size filter 9 could be set to exclude all messages; be careful of this.d @SubSection(SET INTERVAL)xC The SET INTERVAL command sets the number of seconds between screen rA updates for the DISPLAY commands, and the default period of data S0 collection for the SUMMARIZE and TRACE commands.   Command format: < @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL) @Begin(InputExample)   SET INTERVAL nn,   @End(InputExample)E where @i<nn> is the decimal integer number of seconds to be used, in x? the range of 2 to 59 seconds. The initial default is 4 seconds.g @SubSection(SET KEYPAD)[K The SET KEYPAD command switches the state of the terminal's numeric keypad [F to numeric or applications mode. By default, ETHERMON will switch the G keypad to applications mode upon start-up, and restore the terminal to dC whatever state it was in before ETHERMON was invoked when ETHERMON   terminates.b   Command format:r: @IndexSecondary(Primary="commands",Secondary="SET KEYPAD") @Index(SET KEYPAD) @Begin(InputExample)   SET KEYPAD APPLICATIONS  SET KEYPAD NUMERIC   @End(InputExample) @SubSection(SET MANUFACTURER)r> The SET MANUFACTURER command manually adds a new entry to the < manufacturer prefix name table with an equivalence name, or F overwrites the equivalence name of an existing entry. Hence, Ethernet L interface manufacturers not already known to ETHERMON can be manually named.   Command format: @ @IndexSecondary(Primary="commands",Secondary="SET MANUFACTURER") @Index(SET MANUFACTURER) @Index(manufacturer prefix)e @Begin(InputExample)  . SET MANUFACTURER aa-bb-cc short-name long-name  7 SET MANUFACTURER aa-bb-cc short-name "quoted long name"l   @End(InputExample)L where @i<aa-bb-cc> is the first three bytes of the standard format physical F Ethernet address specification (low byte first, hexadecimal numbers), M @i<short-name> is a text string without embedded blanks or punctuation marks EH (other than _ or $) which is used to prefix node name information on theB DISPLAY screens, and @i<long-name> and @i<"quoted long name"> are I strings (optionally enclosed in double quotes, may contain any printable eA character other than a double quote), which is a more descriptived> name for the manufacturer. Only the first 8 characters of the L supplied short-name and first 24 characters of the long-name will be stored L in the table; if a matching entry already exists in the manufacturer table, G ETHERMON will prompt to verify that you wish to overwrite the existing t names. @SubSection(SET MESSAGES)dE The SET MESSAGES command enables or disables display of asynchronous e? "significant event" messages on the user terminal. By default, fM asynchronous event messages can interrupt any output on your screen any time HK while ETHERMON is running; however, when executing a DISPLAY command, such lH messages are displayed in a separate scrolling window, and the messages C are not written to any SHOW or SUMMARIZE command's output when the d /OUTPUT qualifier is used.   Command format:r @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES")B @IndexSecondary(Primary="messages",Secondary="asynchronous event") @Begin(InputExample)   SET MESSAGES [@i<msgtype>] ON    SET MESSAGES [@i<msgtype>] OFF   SET MESSAGES DEBUG   @End(InputExample)F where ON specifies that significant messages should be displayed (the  default), OFF specifies B that messages should not be displayed, and DEBUG not only enables = display, but turns on additional event messages not normally <F considered significant. Note that the default changes to DEBUG if you = compile ETHERMON_CMD_S.FOR with the /D_LINES compiler option. $ @Index[/D_LINES (FORTRAN qualifier)]  G The optional @i<msgtype> of the SET MESSAGE command allow enabling and eK disabling optional sanity checks and other possibly annoying messages in a i+ selective fashion. These message types are:a @Begin(Itemize) E ARP - if ARP checking is enabled, ETHERMON will report any proxy ARP rL messages, any ARP or RARP messages using unrecognized ARP/RARP opcodes, and J any ARP or RARP packets requesting addresses for protocols other than DoD H Internet IP, Berkeley trailer negotiation, AppleTalk, or Apollo DOMAIN.  (ON by default)y3 @IndexSecondary(Primary="messages",Secondary="ARP")A  K DUPIP - if DUPIP checking is enabled, ETHERMON will check for any new node yK addresses that claim the same IP address as a node already existing in the b address table. (OFF by default)rF @IndexSecondary(Primary="messages",Secondary="duplicate IP addresses")  F IP - if IP checking is enabled, ETHERMON will report any DoD Internet J IP-speaking nodes that are transmitting more than one source address, and 7 any nodes claiming they are IP routers. (ON by default)o2 @IndexSecondary(Primary="messages",Secondary="IP")  I MOP - if MOP checking is enabled, any time a DEC MOP protocol message is uH received (other than a System ID message), ETHERMON will report the MOP E protocol used, the message length, and the message type byte. (ON by e default)3 @IndexSecondary(Primary="messages",Secondary="MOP")t  O NEWNODE - if NEWNODE checking is enabled, ETHERMON will report each time a new  J entry is added to the address table (entries loaded by the LOAD/ADDRESSES L command but not previously seen by the current ETHERMON session will not be D reported, as they are assumed to already be known). (OFF by default)A @IndexSecondary(Primary="messages",Secondary="new node detected")i
 @End(Itemize)s @SubSection(SET PROTOCOL_NAME)H The SET PROTOCOL_NAME command manually adds a new entry to the protocol ( name table with an equivalence name, or F overwrites the equivalence name of an existing entry. Hence, Ethernet > protocols not already known to ETHERMON can be manually named.   Command format:a @Index(SET PROTOCOL_NAME)dA @IndexSecondary(Primary="commands",Secondary="SET PROTOCOL_NAME")a @Begin(InputExample)   SET PROTOCOL_NAME aa-bb name  ' SET PROTOCOL_NAME aa-bb "quoted string"    @End(InputExample)9 where @i<aa-bb> is the standard format physical Ethernet eO protocol type specification (low byte first, hexadecimal numbers), @i<name> is eH a text string without embedded blanks or punctuation marks (other than _E or $), and @i<"quoted string"> is a string enclosed in double quotes eD (not considered part of the string) which may contain any printable I character other than a double quote. Only the first 24 characters of the SE supplied equivalence name will be stored in the table; if a matching nK entry already exists in the protocol table, ETHERMON will prompt to verify  9 that you wish to overwrite the existing equivalence name.S   @Begin(Description)]L @b[@i<WARNING !!!!>]@\At present, the SET PROTOCOL_NAME command cannot tell G the difference between an IEEE 802.3 extended protocol and an Ethernet SM protocol in the table, so if you have a protocol used in both modes, the SET iF PROTOCOL_NAME command will affect the first occurrence located in the J protocol name table (not necessarily the displayed order, as the table is 7 sorted by the SHOW PROTOCOL_NAMES command for display).  @End(Description)q @SubSection(SHOW ADDRESS_NAMES) L The SHOW ADDRESS_NAMES command displays the current contents of the address G table on the user terminal, preceded and followed by the current table iA size. This includes all pre-defined "hardwired" names, all names eM extracted from the local node or VAXcluster, all names manually entered with yI the SET ADDRESS_NAME command, and all names automatically derived by the t9 address recognition logic and the LOAD/INTERNET command. e @Index(SET ADDRESS_NAME)@ @IndexSecondary(Primary="commands",Secondary="SET ADDRESS_NAME") @Index(LOAD)4 @IndexSecondary(Primary="commands",Secondary="LOAD")1 Any address which has been seen on your Ethernet  C since ETHERMON was started will have a letter displayed before the lG hexadecimal address string; the letter will be a "s" (for source only),tE "d" (for destination only), "m" (for multicast destination only), or n* "b" (used both as source and destination). @Index(multicast address)o   Command format:  @Index(SHOW ADDRESS_NAMES)B @IndexSecondary(Primary="commands",Secondary="SHOW ADDRESS_NAMES") @Begin(InputExample)  % SHOW ADDRESS_NAMES [wildcard-address]n                    [/ALL]                     [/FULL]%                    [/OUTPUT=filespec] '                    [/PROTOCOL=protocol]f!                    [/TYPE=%Xnnnn])3                    [/TYPE=(typename[,typename...])]    @End(InputExample)  G Note that the name count at the end of a display may be larger than at eG the beginning, due to automatic name insertion while the command is in nG progress. Also note that, unless the /ALL qualifier is specified, only tI addresses that have actually been seen on the Ethernet since the current lC ETHERMON session was started will actually be displayed; alternate nL addresses and addresses predefined by ETHERMON (but not active) will not be 
 displayed.  J The @i[wildcard-address] parameter allows you to restrict address display K to a subset of known addresses, where the parameter is expressed in one of a/ the formats described in section @Ref[address].mF The address can be specified as just a manufacturer prefix, where the H missing terms are assumed to be wildcarded. If no address is given, the F address @i[*-*-*-*-*-*] is assumed. The Internet logical address form H @i[a.b.c.d], where each number is a legal (0 to 255) decimal byte value L or the '*' wildcard symbol, may also be used, providing at least one of the N octets is not a wildcard. Specifying both an Ethernet address and an Internet B address will cause only addresses meeting @i<both> criteria to be % displayed (if any meet the criteria).o  L The /ALL qualifier specifies that all addresses, not just active ones, will - be displayed (subject to other restrictions).h  K The /FULL qualifier specifies that the protocol types used by each address eI are displayed after that address when the table is displayed. Currently, hL ETHERMON can save up to 10 protocol types (Ethernet or IEEE 802.3 SNAP) per K Ethernet address. The protocol type names (if any) from the protocol names yC table will be displayed after the physical numbers; preceding each iG protocol type number will be letters indicating direction of use ('s', rH 'd', or 'b') and IEEE mode ('i' for IEEE 802.3 SNAP, '@ ' for Ethernet). @Index(IEEE 802.3)  H The /OUTPUT=filespec qualifier allows you to redirect the SHOW command'sJ display to a file instead of the user terminal. If the file specification H is missing or incomplete, the name SYS$DISK:[]ETHERMON_ADDRESSES.LIS is & used to supply any missing components.  O The /PROTOCOL=@i<protocol> qualifier allows you to restrict address display to hL only those addresses that have used the protocol specified (using one of theH formats described in section @Ref[protocol]). By default, all addresses L (subject to other restrictions) are displayed, regardless of protocol used. ? Note that there is no way to specify that the protocol is IEEE qF 802.3 SNAP or plain-vanilla Ethernet; both kinds will be displayed if ' both kinds exist for a specified value.x  E The /TYPE=@i<value> qualifier allows you to specify that the listing hC should only include address table entries which have the specified s attributes.The value can be: @Begin(Enumerate)eF a hexadecimal number in the form %X@i<nnnn>, where the numeric values A correspond to the internal binary flag codes used in the address o@ table (and seen as the M@i<xxxx>: number in SAVE/ADDRESS files); @Index(SAVE)4 @IndexSecondary(Primary="commands",Secondary="SAVE")  B one or more symbolic names of the flag bits. if more than one name? is specified, the names must be separated by commas "," and theaF entire list enclosed in parenthesis "()". The symbolic type names are * (with their associated binary hex values): @Begin(Itemize) 4 DECBRIDGE    (%X00080): identified as DEC LAN Bridge  0 DECNET       (%X00008): running DECnet protocols  = DECSERVER    (%X00100): identified as DEC LAT terminal serverA  3 DESTINATION  (%X00004): node has been a destinationa  6 DNSSERVER    (%X10000): node is an Internet DNS server  : IARP         (%X20000): node's IP address confirmed by ARP  = INETGATEWAY  (%X08000): node is an Internet IP gateway/routere  A INETNAME     (%X00800): node has a symbolic Internet name definedo  9 INTERNET     (%X00010): running DoD Internet IP protocolsm  C LAVC         (%X00200): running DEC Local Area VAXcluster protocolsS  L LINE2ADDR    (%X80000): displayed address is for 2nd port of two-port device  3 MACNUM       (%X02000): running AppleTalk protocols   ; MACZONE      (%X01000): identified as AppleTalk zone routero  1 MOP          (%X04000): running DEC MOP protocolsd  N OTHERADDR    (%X40000): node has two addresses because it is a two-port device  . SOURCE       (%X00002): node has been a source  @ UB           (%X00020): node is running Ungermann-Bass protocols  5 VITALINK     (%X00400): identified as Vitalink bridgen  = XYPLEX       (%X00040): running Xyplex terminal net protocolsa
 @End(Itemize)d @End(Enumerate)l  M Additional information will be displayed after the Ethernet physical address hI if such information has been collected on the node. Such information can p6 include (depending on the protocols used by the node): @Begin(Itemize).G the DECnet node name (as understood by the local VAX's DECnet volatile  J database); if the specified node number is not listed in the local DECnet G volatile database, the node address in DECnet area.node format will be e displayed instead.  F the DoD Internet protocol address, in dotted numeric notation. If the H LOAD/INTERNET command has been used, the node may also have a host name J displayed in the format known to the local TCP/IP software (assuming that G the IP address was added to the address table before the LOAD/INTERNET sH command was issued and that the local node has access to a name/address H pair for the specified IP address). If the node also speaks the Routing L Information Protocol or RIP (documented in NIC.DDN.MIL Request For Comments L RFC:RFC1058.TXT), an asterisk (*) will be displayed before the host name or 9 address to indicate that the node is apparently a router.  @Index(NIC.DDN.MIL)I @Index(RFC1058)m8 @IndexSecondary(Primary="protocol type",Secondary="RIP") @Index(RIP)e  H DEC interface characteristics (if the interface is of Digital Equipment N Corporation manufacture or emulates such); this information is collected from M the DEC MOP Remote Console protocol broadcasts (the System ID messages) made rK periodically by all DEC-compatible interfaces which announce the interface D. characteristics. Such entries are of the form N @u[device-type:attribute;attribute...], where the @u[device-type] is either a K DEC interface type (DEUNA, DEBNA, etc.) or @u[t=@i{xx}], where @i{xx} is a TJ one-byte hexadecimal number representing a type code unknown to ETHERMON.  The known type codes include:  @Begin(Enumerate)A$ '01'X: deuna (UNIBUS interface card)  # '05'X: deqna (Q-BUS interface card)I  $ '0B'X: delua (UNIBUS interface card)  ! '15'X: debet (DEC LAN Bridge 100)u    '17'X: debna (BI interface card)  " '21'X: lat?? (LAT terminal server)  # '25'X: delqa (Q-BUS interface card)c  , '27'X: desva (VAXstation built-in interface)   '2B'X: PC??1  6 '2D'X: TrfMn (DECbridge running LAN Traffic Monitor??)  ! '35'X: db200 (DEC LAN Bridge 200)e   '3F'X: vx??1   '40'X: vx??2    '41'X: debni (BI interface card)   '42'X: demna  # '4B'X: deqta (Q-BUS interface card)   1 '4C'X: db150 (DEC LAN Bridge 150, improved DEBET)n   '72'X: vt1200 (DEC X-terminal)  B '75'X: MacII (certain brand of Apple Macintosh Ethernet interface)  J '79'X: CSrtr (multi-protocol bridge/router manufactured by cisco Systems,  Inc.)e @End(Enumerate)tI The attributes reported by a given node vary, but can include any of the A
 following:@ @IndexSecondary(Primary="protocol type",Secondary="MOP (60-02)") @Begin(Enumerate) G f=@i{xx} - hexadecimal flags byte for the functions this interface can i perform; bit values are: @Begin(Enumerate)s bit 0: loops   bit 1: dump   6 bit 2: primary loader (can only load secondary loader)  > bit 3: multi-block loader (can load tertiary loader or system)   bit 4: boot    bit 5: console carrier   bit 6: data link countersh  " bit 7: console carrier reservation @End(Enumerate)a  $ s=@i{x} - system processor type code  J hw@u<@i{aabbccddeeff}> - hardware (ROM) Ethernet address of interface (if 2 address has been changed by node's local software)  E log@u<@i{aabbccddeeff}> - logical Ethernet address of interface (for L& interface's listing under ROM address) @End(Enumerate)E  I the AppleTalk node number in the form @u[Mac@i{network}.@i{node}], where  K @i{network} is the AppleTalk Phase II network number (or zero if a Phase I sJ node), and @i{node} is the node number within the logical network. If the L node is also an AppleTalk router, the node's routing zone is appended after 6 the network address in the form @u[rt@ @i{zone-name}].F @IndexSecondary(Primary="protocol type",Secondary="AppleTalk (80-9B)")  H the Ungermann-Bass host serial number if the node speaks XNS and has an H Ungermann-Bass manufacturer's prefix, in the form @u[#@i{nnnnn}], where I @i{nnnnn} is the decimal serial number of the U-B device. The '#' may be DI prefixed by 'BRG' (if this node is the root bridge of the spanning tree) U) or 'tr' (if the node is on a Token Ring).t @Index(XNS)a@ @IndexSecondary(Primary="protocol type",Secondary="XNS (06-00)")  H the Xyplex host serial number if the node speaks the Xyplex proprietary I terminal network protocol and has a Xyplex manufacturer's prefix, in the oH form @u[unit@i{nnnnn}], where @i{nnnnn} is the decimal serial number of  the Xyplex device. @Index(Xyplex)C @IndexSecondary(Primary="protocol type",Secondary="Xyplex (08-88)") 
 @End(Itemize)- @SubSection(SHOW BRIDGES)-= The SHOW BRIDGES command displays the addresses and symbolic rB identifications of all Ethernet devices tentatively identified as = bridges. Optionally, it also displays a "best-approximation" a; overall bridge routing "map" as created by the MAP command.d   Command format:i< @IndexSecondary(Primary="commands",Secondary="SHOW BRIDGES") @Index(SHOW BRIDGES) @Index(bridge) @Begin(InputExample)   SHOW BRIDGES [/FULL]              [/MAP[=filespec]]!              [/OUTPUT[=filespec]]a   @End(InputExample)  J The /FULL qualifier specifies that the protocol types used by each bridge I are displayed after that address when the table is displayed (currently, sG ETHERMON can save up to 10 protocol types {Ethernet or IEEE 802.3} per hK Ethernet address; the protocol type names {if any} from the protocol names  D table will be displayed after the physical numbers), along with any H routing "map" information for each bridge that was computed by the last  MAP command's execution. @Index(MAP)g3 @IndexSecondary(Primary="commands",Secondary="MAP")e  H The /OUTPUT=filespec qualifier allows you to redirect the SHOW command'sJ display to a file instead of the user terminal. If the file specification F is missing or incomplete, the name SYS$DISK:[]ETHERMON_BRIDGES.LIS is & used to supply any missing components.  M The /MAP=filespec qualifier tells ETHERMON to generate a graphical sketch of TN the bridged Ethernet, instead of a tabular report. The plot is generated as a M stand-alone portable Level 1 PostScript document. Due to limited information lN available from the bridges, the map is not guaranteed to be totally accurate; G however, it is a good attempt. If the file specification is missing or eL incomplete, the name SYS$DISK:[]BRIDGE_MAP.PS is used to supply any missing  components.p @Index(PostScript)  N Note that neither form of the map is guaranteed to be totally accurate; since I bridges may not respond to MAP command queries, or the responses may get lE dropped due to overloading of the monitoring VAX; in such cases, the EH information used to construct the maps will be obviously incomplete. To L verify that a bridge actually supplied information to the MAP command (even H if it was irrelevant information), the /FULL output format will display J question marks after the identification of any bridge that did not supply  information. @SubSection(SHOW FILTERS)sE The SHOW FILTERS command displays the current contents of the filter  G table, listing first the size filter thresholds and its enable/disable  E status. This is followed by all the currently defined filters, where IF each filter displays its index number, current enable/disable status, H and the attributes it filters on, where Ethernet addresses and protocol C types may be followed by their equivalence names (if any) from the s+ address, manufacturer, and protocol tables.r   Command format:c @Index(SHOW FILTERS)< @IndexSecondary(Primary="commands",Secondary="SHOW FILTERS") @Index(filter) @Begin(InputExample)   SHOW FILTERS   @End(InputExample) @SubSection(SHOW KEY) K The SHOW KEY command displays the current key definitions as set up by the mI DEFINE/KEY command. All key definitions are displayed in the form of the eJ DEFINE/KEY commands needed to re-create the definitions. Definitions that K are "hard-wired" into ETHERMON have an asterisk (*) displayed before their sE DEFINE/KEY commands to indicate that these are non-redefineable keys.S   Command format:  @Index(SHOW KEY)8 @IndexSecondary(Primary="commands",Secondary="SHOW KEY") @Begin(InputExample)   SHOW KEY   @End(InputExample) @SubSection(SHOW MANUFACTURERS) D The SHOW MANUFACTURERS command displays the current contents of the F manufacturers' address prefix table on the user terminal, followed by H the current table size. This includes all pre-defined "hardwired" names K and all prefix codes automatically entered by the message analyzing logic. yI Manufacturer address prefixes which have been seen on the local Ethernet  M since starting ETHERMON will have a letter displayed in front of the address c3 prefix; the letter will be a "s" (for source only),eI "d" (for destination only), or "b" (used both as source and destination).=   Command format:yB @IndexSecondary(Primary="commands",Secondary="SHOW MANUFACTURERS") @Index(SHOW MANUFACTURERS) @Index(manufacturer prefix)E @Begin(InputExample)   SHOW MANUFACTURERS [/ALL]o%                    [/OUTPUT=filespec]    @End(InputExample)L Note that, unless the /ALL qualifier is specified, only manufacturer prefix B codes that have actually been seen on the Ethernet since ETHERMON ' was started will actually be displayed.s  J The /ALL qualifier specifies that all manufacturer codes, not just active  ones, will be displayed.  H The /OUTPUT=filespec qualifier allows you to redirect the SHOW command'sJ display to a file instead of the user terminal. If the file specification L is missing or incomplete, the name SYS$DISK:[]ETHERMON_MANUFACTURERS.LIS is & used to supply any missing components. @SubSection(SHOW MESSAGES)L The SHOW MESSAGES command displays the current settings of the SET MESSAGES M command for enabling or disabling output of asynchronous "significant event" s messages to the user terminal.   Command format:T @Index(SHOW MESSAGES)n= @IndexSecondary(Primary="commands",Secondary="SHOW MESSAGES")m @Begin(InputExample)  
 SHOW MESSAGESo   @End(InputExample) @SubSection(SHOW PERFORMANCE)AH The SHOW PERFORMANCE command is a debugging command for ETHERMON itself;M it supplies internal performance data about the operation of ETHERMON in the rF current network environment. The output format of this command is not J documented, as it may change at any time without notice; however, the use F of this command will not damage other operations being performed with 	 ETHERMON.    Command format:m @Index(SHOW PERFORMANCE)@ @IndexSecondary(Primary="commands",Secondary="SHOW PERFORMANCE") @Begin(InputExample)  & SHOW PERFORMANCE [/INTERVAL=deltatime]   @End(InputExample)F where /INTERVAL specifies a standard VMS @i<deltatime> value (without G enclosing double quotes, and without a day count); if /INTERVAL is not  G specified, the current SET INTERVAL value is used as the sample period a length.d< @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL) @SubSection(SHOW PORT_STATUS)iB The SHOW PORT_STATUS command displays the current Ethernet port's G current status. Some of the status is global for the entire interface, x? where other status is peculiar to ETHERMON's connection to the g> interface. For more information, see the @i<@u[VMS I/O User's E Reference Manual: Part II]> (the chapter on Ethernet interfaces) for [H information about the IO$_SENSEMODE function's extended characteristics ? buffer, and the @i<@u[VMS Network Control Program Manual]> for n  information about line counters.   Command format:e @Index(SHOW PORT_STATUS)@ @IndexSecondary(Primary="commands",Secondary="SHOW PORT_STATUS") @Index(NCP)i @Begin(InputExample)   SHOW PORT_STATUS [/ZERO]   @End(InputExample)I where /ZERO can be optionally specified to zero the interface's counters eF after displaying the old data (similar to the DECnet NCP command ZERO G LINE COUNTERS). Note that some port parameters may show up as question uL marks, i.e. @i[???]; this implies that those parameters are not returned by ! the type of interface being used.a  @SubSection(SHOW PROTOCOL_NAMES)E The SHOW PROTOCOL_NAMES command displays the current contents of the nC protocol table on the user terminal, followed by the current table fA size. This includes all pre-defined "hardwired" names, all names dE manually entered with the SET PROTOCOL_NAME command, and all protocolhO types actually seen on the Ethernet since ETHERMON was started. Protocol types  P which have been seen on the local Ethernet since ETHERMON was started will have ? an asterisk (*) displayed in front of the protocol type number.n   Command format:n @Index(SHOW PROTOCOL_NAMES)cC @IndexSecondary(Primary="commands",Secondary="SHOW PROTOCOL_NAMES")n @Begin(InputExample)   SHOW PROTOCOL_NAMES [/ALL]&                     [/OUTPUT=filespec]   @End(InputExample)8 Note that, unless the /ALL qualifier is specified, only K protocol types that have actually been seen on the Ethernet since ETHERMON e' was started will actually be displayed.d  F The /ALL qualifier specifies that all protocol types, not just active  ones, will be displayed.  H The /OUTPUT=filespec qualifier allows you to redirect the SHOW command'sJ display to a file instead of the user terminal. If the file specification H is missing or incomplete, the name SYS$DISK:[]ETHERMON_PROTOCOLS.LIS is & used to supply any missing components. @SubSection(SPAWN)H The SPAWN command spins off a DCL subprocess, either executing a single F command or beginning DCL prompting. While the subprocess is SPAWN'ed, F ETHERMON continues to record address, manufacturer, and protocol type O information in its tables, and any active asynchronous TRACE command continues O to collect data.
 @Index(TRACE)w5 @IndexSecondary(Primary="commands",Secondary="TRACE")e   Command format: 
 @Index(SPAWN)e5 @IndexSecondary(Primary="commands",Secondary="SPAWN")@ @Begin(InputExample)   SPAWN [@i<DCL-command-string>]   @End(InputExample)I Note that this command functions similarly to the DCL SPAWN command, but eC with fewer options. Also, you must have sufficient PRCLM and other tF quotas to SPAWN a subprocess while ETHERMON is consuming most of your J available BYTLM resources; ETHERMON computes how much BYTLM it must leave F unused to guarantee that one minimal-quota SPAWNed subprocess and one I TRACE/ANALYZER command may be succesfully created, but it does not check  
 other quotas.n3 @IndexSecondary(Primary="quotas",Secondary="BYTLM")e3 @IndexSecondary(Primary="quotas",Secondary="PRCLM")a# @SubSection(SUMMARIZE DESTINATIONS)AG The SUMMARIZE DESTINATIONS command collects data over a specified time n> period, then generates a report of counts of messages sent to 8 destinations, sorted by descending quantity of messages.   Command format:n @Index(SUMMARIZE DESTINATIONS)F @IndexSecondary(Primary="commands",Secondary="SUMMARIZE DESTINATIONS") @Begin(InputExample)  , SUMMARIZE DESTINATIONS [/INTERVAL=deltatime]'                        [/OUTPUT[=file]]0   @End(InputExample)F where /INTERVAL specifies a standard VMS @i<deltatime> value (without G enclosing double quotes, and without a day count); if /INTERVAL is not  G specified, the current SET INTERVAL value is used as the sample period e length.r< @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL)  : The /OUTPUT=filespec qualifier allows you to redirect the D SUMMARIZE command's display to a file instead of the user terminal. = If the file specification is missing or incomplete, the name  A SYS$DISK:[]ETHERMON.SUM is used to supply any missing components.p  G Only messages passing the currently enabled filters are counted in the lH summation. The output report is printed to the user terminal; after the H report header, each line of data gives the number of messages received, E the physical Ethernet address they were sent to, and any equivalence ( names known for the address. @SubSection(SUMMARIZE INTERNET)eC The SUMMARIZE INTERNET command collects data over a specified time iD period, then generates a report of counts of Internet messages sent C under different second level Internet protocols (such as TCP, UDP, i1 etc.), sorted by descending quantity of messages.s   Command format:s @Index(SUMMARIZE INTERNET)B @IndexSecondary(Primary="commands",Secondary="SUMMARIZE INTERNET") @Index(Internet) @Begin(InputExample)  ( SUMMARIZE INTERNET [/INTERVAL=deltatime]#                    [/OUTPUT[=file]]    @End(InputExample)F where /INTERVAL specifies a standard VMS @i<deltatime> value (without G enclosing double quotes, and without a day count); if /INTERVAL is not aG specified, the current SET INTERVAL value is used as the sample period hD length. @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL)  : The /OUTPUT=filespec qualifier allows you to redirect the D SUMMARIZE command's display to a file instead of the user terminal. = If the file specification is missing or incomplete, the name nA SYS$DISK:[]ETHERMON.SUM is used to supply any missing components.s  G Only messages passing the currently enabled filters are counted in the RI summation; an additional filter is automatically defined and enabled for e? the duration of the command to ensure that only messages under rJ protocol type 08-00 (DoD Internet IP) are processed. The output report is ( printed to the user terminal; after the H report header, each line of data gives the number of messages received, F the second level protocol number, and the mnemonic name of the second F level protocol (per NIC.DDN.MIL Request For Comments RFC:RFC1060.TXT).A For the TCP (6) and UDP (17) second-level protocols, counts on a t per-port basis are also kept.r @Index(NIC.DDN.MIL)c @Index(RFC1060)r8 @IndexSecondary(Primary="protocol type",Secondary="TCP")8 @IndexSecondary(Primary="protocol type",Secondary="UDP")  @SubSection(SUMMARIZE PROTOCOLS)D The SUMMARIZE PROTOCOLS command collects data over a specified time A period, then generates a report of counts of messages sent under nD different protocol types, sorted by descending quantity of messages.   Command format:I @Index(SUMMARIZE PROTOCOLS)rC @IndexSecondary(Primary="commands",Secondary="SUMMARIZE PROTOCOLS")i @Begin(InputExample)  ) SUMMARIZE PROTOCOLS [/INTERVAL=deltatime]a$                     [/OUTPUT[=file]]   @End(InputExample)F where /INTERVAL specifies a standard VMS @i<deltatime> value (without G enclosing double quotes, and without a day count); if /INTERVAL is not 4G specified, the current SET INTERVAL value is used as the sample period dD length. @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL): The /OUTPUT=filespec qualifier allows you to redirect the D SUMMARIZE command's display to a file instead of the user terminal. = If the file specification is missing or incomplete, the name aA SYS$DISK:[]ETHERMON.SUM is used to supply any missing components.   G Only messages passing the currently enabled filters are counted in the =H summation. The output report is printed to the user terminal; after the H report header, each line of data gives the number of messages received, G the physical Ethernet protocol type code they were sent under, and any o- equivalence name known for the protocol type.e @SubSection(SUMMARIZE SIZES)@ The SUMMARIZE SIZES command collects data over a specified time F period, then generates a report of counts of messages of various size 6 categories, sorted by descending quantity of messages.   Command format:  @Index(SUMMARIZE SIZES) ? @IndexSecondary(Primary="commands",Secondary="SUMMARIZE SIZES")) @Begin(InputExample)  % SUMMARIZE SIZES [/INTERVAL=deltatime]f                  [/OUTPUT[=file]]   @End(InputExample)F where /INTERVAL specifies a standard VMS @i<deltatime> value (without G enclosing double quotes, and without a day count); if /INTERVAL is not (G specified, the current SET INTERVAL value is used as the sample period  D length. @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL): The /OUTPUT=filespec qualifier allows you to redirect the D SUMMARIZE command's display to a file instead of the user terminal. = If the file specification is missing or incomplete, the name pA SYS$DISK:[]ETHERMON.SUM is used to supply any missing components.f  G Only messages passing the currently enabled filters are counted in the -H summation. The output report is printed to the user terminal; after the G report header, each line of data gives the number of messages received  0 and the message size range the messages were in. @SubSection(SUMMARIZE SOURCES)B The SUMMARIZE SOURCES command collects data over a specified time ? period, then generates a report of counts of messages sent fromr3 sources, sorted by descending quantity of messages.n   Command format:r @Index(SUMMARIZE SOURCES)dA @IndexSecondary(Primary="commands",Secondary="SUMMARIZE SOURCES")o @Begin(InputExample)  ' SUMMARIZE SOURCES [/INTERVAL=deltatime]S"                   [/OUTPUT[=file]]   @End(InputExample)F where /INTERVAL specifies a standard VMS @i<deltatime> value (without G enclosing double quotes, and without a day count); if /INTERVAL is not rG specified, the current SET INTERVAL value is used as the sample period tD length. @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL): The /OUTPUT=filespec qualifier allows you to redirect the D SUMMARIZE command's display to a file instead of the user terminal. = If the file specification is missing or incomplete, the name oA SYS$DISK:[]ETHERMON.SUM is used to supply any missing components.e  G Only messages passing the currently enabled filters are counted in the  H summation. The output report is printed to the user terminal; after the H report header, each line of data gives the number of messages received, G the physical Ethernet address they were sent from, and any equivalence b names known for the address.! @SubSection(SUMMARIZE STATISTICS)IE The SUMMARIZE STATISTICS command collects data over a specified time  G period, then generates a report of Ethernet port counter value changes.p   Command format:a @Index(SUMMARIZE STATISTICS)D @IndexSecondary(Primary="commands",Secondary="SUMMARIZE STATISTICS") @Begin(InputExample)  * SUMMARIZE STATISTICS [/INTERVAL=deltatime]%                      [/OUTPUT[=file]]N   @End(InputExample)F where /INTERVAL specifies a standard VMS @i<deltatime> value (without G enclosing double quotes, and without a day count); if /INTERVAL is not  G specified, the current SET INTERVAL value is used as the sample period gD length. @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL)  : The /OUTPUT=filespec qualifier allows you to redirect the D SUMMARIZE command's display to a file instead of the user terminal. = If the file specification is missing or incomplete, the name cA SYS$DISK:[]ETHERMON.SUM is used to supply any missing components.t  L Note that, for counters that have saturated, a triple asterisk ('***') will L in the right margin of the report for the saturated values; if the counters J are already saturated on initiation of the SUMMARIZE command, the command + will be rejected with an appropriate error.n @SubSection(TRACE)M The TRACE command collects Ethernet messages after filtering and writes them tG to a disk file for offline processing by another program. The messages E/ can be recorded in either ASCII or binary form.i   Command format:i5 @IndexSecondary(Primary="commands",Secondary="TRACE")b
 @Index(TRACE)h @Begin(InputExample)  9 TRACE [/ASCII] [/BINARY] [/SNIFFER] [/ANALYZER=imagename]i       [/INTERVAL=deltatime]l       [/OUTPUT=outfilespec]t       [/PARALLEL]        [/REPEAT[=@i<n>]]s       [/[NO]STATISTICS]a       [/TRUNCATE=@i<m>]u   TRACE /ABORT   @End(InputExample)O where only one of /ASCII, /BINARY, /SNIFFER, or /ANALYZER may be specified (if RJ none of them is specified, /BINARY is the default). /INTERVAL specifies a O standard VMS @i<deltatime> value (without enclosing double quotes, and without WF a day count); if /INTERVAL is not specified, the current SET INTERVAL + value is used as the sample period length. i< @IndexSecondary(Primary="commands",Secondary="SET INTERVAL") @Index(SET INTERVAL) /OUTPUT specifies the F output file name (if file specification is incomplete or qualifier is @ missing, the default is SYS$DISK:[]ETHERMON.DAT for binary mode,H SYS$DISK:[]ETHERMON.LIS for ASCII mode, SYS$DISK:[]ETHERMON.SNIFFER for J Sniffer mode, and SYS$OUTPUT: for analyzer mode). The /PARALLEL qualifier E specifies that recording should go on in the background, leaving the NB terminal free to execute other ETHERMON commands. The /REPEAT[=n] H qualifier also specifies background recording, but specifies that after E each interval, the recording file should be closed and a new version r? opened, keeping the recording running forever or until aborted yC (whichever comes first); to prevent running out of disk space, the eF optional @i<n> is used to specify a maximum version count allowed for I the recording files (automatic file purging is done when more than @i<n> fD files are collected). Note that the /REPEAT qualifier is ignored if E /ANALYZER is specified (only one analyzer session will be done). The M2 /[NO]STATISTICS qualifier is used to override the B default choice of reporting TRACEd packet statistics; by default, J statistics are reported at the end of a synchronous (non-/PARALLEL) TRACE D command, and are not at the end of a /PARALLEL or /REPEAT command's L background execution. /TRUNCATE=@i<m> allows recording only the first @i<m> F bytes of each packet in a binary or Sniffer-format recording file; by H default, all bytes are recorded, and there is no choice for ASCII files K (the 40 bytes that are reported are fewer than the minimum physical packet aL length anyway). It is strongly recommended that records not be truncated to J shorter than the length of an IEEE 802.3 SNAP header (22 bytes), as there I would not be enough information left in the file's records to be able to o decipher the data.  I The TRACE/ABORT command is used to cleanly shut down a TRACE/PARALLEL or tG TRACE/REPEAT command; it specifies that the currently open file should  N be closed immediately and all tracing should cease. Note that an asynchronous G TRACE will also be terminated if ETHERMON is exited; parallel TRACEing IJ does NOT spin off a background batch job or subprocess to do the parallel J monitoring, but just saves the data directly from the data collection AST.J Also, you cannot perform a foreground TRACE and a background TRACE at the H same time. The /[NO]STATISTICS qualifier may be used on the TRACE/ABORT J command to override the reporting choice made when the asynchronous TRACE  session was started.  H Several unsupported utilities are supplied to help analyze binary TRACE E file recordings, and may be used as a template for your own expanded gK offline message analysis tools. Some of these may also be used as analyzer lD modules with the /ANALYZER qualifier. For more information on these 8 utilities, see section @Ref[Utilities] of this document.  G For ASCII mode, the output file contains three lines for each received tN and filter-passed Ethernet message. The first line contains the VMS timestamp O when the message was received, the source and destination addresses in standardTK Xerox ASCII-hexadecimal format, the protocol type (also ASCII-hex), and thehH message body's length in bytes. The second line is a hexadecimal dump ofF the first 40 bytes of the received message; the third line is the sameI 40 bytes dumped in ASCII (with a space before each actual character, such H that the ASCII characters line up under their hexadecimal bytes; periodsI are displayed for unprintable characters). Preceding the dump lines is a aH single line reporting when the dump began; following the dump lines are L three lines reporting when the dump was completed, and the quantity of data J bytes and messages processed from the Ethernet before and after filtering.K The file has carriage-return carriage control and variable-length records. e/ A typical ASCII recording file looks like this:  @Begin(OutputExample)NE   Ethernet TRACE: starting data collection at 21-JUN-1991 09:28:54.22oM 21-JUN-1991 09:28:54.29 s:AA-00-04-00-CA-28 d:AA-00-04-00-D1-28 p:60-07    46 P 1400AA000400D1280500AA000400CA280800AA340000000000000000000000000000000000000000P  . .  . . .  ( . .  . . .  ( . .  4 . . . . . . . . . . . . . . . . . . . .M 21-JUN-1991 09:28:54.40 s:08-00-7C-00-30-26 d:09-00-2B-01-00-01 p:80-38    46cP E1190100003108007C003B7101DE007F08007C0030260101050F1E0F3004000081000100000D7465P   . . . . 1 . . | . ; q .  . . . . | . 0 & . . . . . . 0 . . . . . . . . . t eM 21-JUN-1991 09:28:54.43 s:00-DD-01-02-96-2C d:08-00-2B-10-1A-E5 p:06-00    46tP FFFF002A00050000000108002B101AE5872C0000000100DD0102962C8713C000075EC05F0039010FP  . . . * . . . . . . . . + . .  . , . . . . .  . . . , . .  . . ^  _ . 9 . .M 21-JUN-1991 09:28:54.44 s:00-DD-01-0A-12-A8 d:FF-FF-FF-FF-FF-FF p:06-00    70tP FFFF0046000400000000FFFFFFFFFFFF80010000000100DD010A12A8802000000000000100000000P  . . . F . . . . . . . . . . . . . . . . . . .  . . .  .   . . . . . . . . . .M 21-JUN-1991 09:28:54.47 s:AA-00-04-00-D8-28 d:AB-00-00-03-00-00 p:60-03    46tP 22000D020000AA000400D82803DA05000000000000000000AA00040063280F000002AAAA00000000P  " . . . . .  . . .  ( .  . . . . . . . . . .  . . . c ( . . . .   . . . .M 21-JUN-1991 09:28:54.48 s:00-DD-01-08-50-A2 d:AA-00-04-00-3D-30 p:80-9Bi   17e" 0011000013601360C7A60606060101835B"  . . . . . ` . `   . . . . . . [M 21-JUN-1991 09:28:54.48 s:00-DD-01-08-50-A2 d:AA-00-04-00-3D-30 p:80-9Bi   17e" 0011000013601360C7A60606060101EB62"  . . . . . ` . `   . . . . .  b                               .n                             .h                             .   M 21-JUN-1991 09:28:57.26 s:AA-00-04-00-F5-28 d:AA-00-04-00-CE-28 p:60-07    87tP 5500AA000400CE280500AA000400F5280B00D2BDF3BD023E0004000A0001003000966A0900D3670EP  U .  . . .  ( . .  . . .  ( . .     . > . . . . . . . 0 . . j . .  g .C   Ethernet TRACE: ending data collection at 21-JUN-1991 09:28:57.27",          15805 bytes,  234 messages analyzed=          15805 bytes,  234 messages received before filtering  @End(OutputExample)s  N For binary mode, the file contains one variable-length record per received andF filter-passed Ethernet message. A set of structure definitions of the H records for various programming languages are listed below. The FORTRAN L version of this structure definition is supplied in the file ETHTRSTRUC.INC.   FORTRAN: @Begin(OutputExample)N       STRUCTURE /BIN_REC/s6 	INTEGER*4 VMS_DATETIME(2) ! quadword system timestamp
         UNION( 	  MAPH 	    BYTE      DSTADDR(0:5) ! beginning of XEDRIVER P5 buffer: dest addr5 	    BYTE      SRCADDR(0:5) ! source Ethernet addressM
 	  END MAP 	  MAP 	    INTEGER*2 W_DSTADDR(0:2)c 	    INTEGER*2 W_SRCADDR(0:2)r
 	  END MAP 	  MAP 	    INTEGER*4 L_DSTADDR 	    INTEGER*2 W_DSTADDR4c 	    INTEGER*4 L_SRCADDR 	    INTEGER*2 W_SRCADDR4d
 	  END MAP
 	END UNION 	UNION 	  MAP 	    CHARACTER*8 PROTBUF
 	  END MAP 	  MAP3 	    BYTE    PROTOCOL(0:1) ! Ethernet protocol typeN
 	  END MAP 	  MAP 	    INTEGER*2 W_PROTOCOL 
 	  END MAP 	  MAP3 	    BYTE    DSAP        ! IEEE 802 destination SAP . 	    BYTE    SSAP        ! IEEE 802 source SAP
 	    UNION
 	      MAP( 		BYTE  CTL(0:1)  ! IEEE 802 CTL byte(s) 	      END MAP
 	      MAP. 		BYTE  ECTL      ! IEEE extended 802 CTL byte= 		BYTE  PID(0:4)  ! IEEE extended 802 Protocol IDentificationN 	      END MAP 	    END UNION
 	  END MAP? 	END UNION               ! end of XEDRIVER P5 buffer (20 bytes)n1 	INTEGER*2 LENGTH        ! length of message body  	UNION 	  MAPB 	    BYTE      BODY(4470)! not all of this array may be sent; onlyG           END MAP               ! part actually used is written to file  	  MAP 	    CHARACTER*4470 CBODYo
 	  END MAP
 	END UNION       END STRUCTURE ! /BIN_REC/o @End(OutputExample)f   MACRO: @Begin(OutputExample)e         $DEFINI RECm7 $EQU    REC$Q_TIME      0    ; VAX/VMS binary timestamp 9 $EQU    REC$B_DESTADDR  8    ; 6-byte destination addressh4 $EQU    REC$B_SRCADDR   14   ; 6-byte source address< $EQU    REC$B_PROTOCOL  20   ; 2-byte Ethernet protocol type3 $EQU    REC$B_DSAP      20   ; 1-byte IEEE 802 DSAP 3 $EQU    REC$B_SSAP      21   ; 1-byte IEEE 802 SSAP > $EQU    REC$B_CTL       22   ; 1- or 2-byte IEEE 802 CTL fieldA $EQU    REC$B_ECTL      22   ; 1-byte IEEE extended 802 CTL field C $EQU    REC$B_PID       23   ; 5-byte IEEE extended 802 protocol IDI: $EQU    REC$W_LENGTH    28   ; word length of message body. $EQU    REC$T_BODY      30   ; body of message< $EQU    REC$K_MAXLEN    4500 ; maximum length of file record         $DEFEND RECt @End(OutputExample)   J Note that the above file record format definitions assume a fixed size of H the protocol type field; if the protocol field of a particular Ethernet K packet is shorter than the maximum size, the field is padded out with zero IL bytes. Also, the network CRC field is not recorded, nor is the length field H in the header of an IEEE 802.3 packet, nor the padding to minimum legal K packet length of an IEEE 802.3 packet with less than the minimum number of  O actual data body bytes. Therefore, the records in a binary-format file are NOT  3 in the same format as they were as network packets.d  G To get a closer approximation of the actual network packet format, the  J Sniffer format can be used. It is also a binary file format, but contains H ONLY the used header fields (including length if IEEE 802.3, unlike the H binary format) and the message body; unused header fields, the CRC, and K IEEE 802.3 padding are not stored in the file's records. No timestamps are t" recorded in a Sniffer-format file.  L All the unsupported utilities delivered with ETHERMON (described in section I @Ref[Utilities]) expect to read binary format files (not Sniffer format).N  K To analyze data in real-time in greater detail than TRACE/ASCII is capable rE of doing, or to provide additional filtering capabilities beyond the bJ existing filtering logic in ETHERMON, the /ANALYZER qualifier may be used J to spin off a subprocess that will be fed the recorded data in real-time. 9 The subprocess is created with the following environment:i @Begin(Itemize)sH SYS$INPUT is a VMS temporary mailbox with no logical name, specified by B physical device name. this mailbox is written with network packet L data in the binary file format, and is written with an end-of-file when the D TRACE terminates (either due to completion timeout or a TRACE/ABORT M command). the mailbox is written with resource wait mode disabled, so if the yM mailbox overflows, the main ETHERMON process will not be suspended, but some eK data will be lost (a count will be kept of SS$_MBFULL errors incurred, and yG reported in the TRACE/STATISTICS messages); the subprocess will not be l informed of message losses.M @Index(mailbox)i  L SYS$OUTPUT defaults to the SYS$OUTPUT file of the process running ETHERMON, G but may be redirected with the /OUTPUT qualifier on the TRACE command;  K interpretation of this file specification is done by the selected analyzer r module.n  . SYS$ERROR is the ETHERMON process's SYS$ERROR.  G default disk and directory is the same as the process running ETHERMON.s  ; base priority is the base priority of the ETHERMON process.c  L privileges are those of the ETHERMON process (including those automatically ? enabled by ETHERMON, unlike for subprocesses created by SPAWN).o  C no CLI is present; the subprocess is created by SYS$CREPRC, not by p
 LIB$SPAWN.  I all quotas are set to system defaults (see the @i<@u[VMS System Services m@ Reference Manual]> for details on subprocess quota allocations).  N process name is the parent ETHERMON process's process name, prefixed with the 3 string 'Eanl_' (truncated to fit in 15 characters).   H a termination mailbox is defined, and will be used to keep track of the B subprocess even after the SYS$INPUT mailbox is closed and deleted.   image dumping is enabled.A  H the image file being run must be a .EXE file in the ETHERMON executable E image's directory, with the filename being the name specified on the E" /ANALYZER=@i<imagefile> qualifier.  H a writeable temporary group global section containing the address table L COMMON is created and may be mapped by the subprocess to allow it access to J the analytical data already computed by ETHERMON. the supplied subroutine K ETH_MAP_ADDRTBL (documented in section @Ref[Utilities]) may be used to map r the section.
 @End(Itemize)t  ) You must have sufficient PRCLM and other  G quotas to create a subprocess while ETHERMON is consuming most of your fJ available BYTLM resources; ETHERMON computes how much BYTLM it must leave F unused to guarantee that one minimal-quota SPAWNed subprocess and one I TRACE/ANALYZER command may be succesfully created, but it does not check e
 other quotas.o3 @IndexSecondary(Primary="quotas",Secondary="BYTLM") 3 @IndexSecondary(Primary="quotas",Secondary="PRCLM")e  I No additional parameters may be passed to the subprocess by this command lJ (although the analyzer module could examine shareable logical name tables I for information). The analyzer module may do anything it wishes with the e" data it receives from the mailbox.  K Only one analyzer module may execute at a time; even if an analyzer module cK has had its input data stream terminated, the image will be allowed to run dJ to its chosen completion (allowing post-processing of the data as it sees J fit). As such, another TRACE/ANALYZER command may not be issued until the 4 previous subprocess has terminated; if the previous 8 subprocess is still running, the TRACE/ANALYZER command 3 will be rejected. If an analyzer module terminates nF pre-maturely, the TRACE command (synchronous or asynchronous) will be > aborted with a message reporting that the analyzer image died. @SubSection(WAIT)fG The WAIT command allows suspending command execution of ETHERMON while e@ maintaining data collection. This is primarily useful for batch F monitoring jobs which want to use the TRACE/REPEAT command, but don't 7 want ETHERMON to exit after initiating data collection.a5 @IndexSecondary(Primary="commands",Secondary="TRACE")r
 @Index(TRACE)o   Command format:a4 @IndexSecondary(Primary="commands",Secondary="WAIT") @Index(WAIT) @Index(batch mode) @Begin(InputExample)   WAIT hh:mm:ss.cc [message]   WAIT FOREVER [message]   @End(InputExample)C where @i<hh:mm:ss.cc> is a standard VMS delta time (without a days  H value), and FOREVER means wait until external events continue execution E (no timer is started to end a FOREVER wait). The optional @i<message> 2 is a string of text which will be displayed on theC standard output device (terminal or batch log file) before the WAITnN begins. This is useful for ETHERMON indirect command files, where the commands* being executed cannot be seen by the user.  D Since the WAIT command suspends execution in a main-level user-mode & $HIBERnate, data collection continues.D The WAIT can be terminated before its specified end time by entering? any keyboard character (for interactive mode use) or by issuingkJ a $WAKE service request at the process running ETHERMON (given appropriateE access privileges). A message will be output indicating how the WAIT c was aborted.  D A sample DCL command procedure, ETHERMON_ALL.COM, is supplied as an E example of how to use the WAIT and TRACE/REPEAT commands to create a e: 24-hour-a-day network monitor. The sanple looks like this: @Begin(ProgramExample)* $ ETHERMON :== $'F$ENV("DEFAULT")'ETHERMON9 $ ETHERMON ETA		! assuming a DEBNA or DEBNI on the system" SET MESSAGES OFF. WAIT 00:00:10 "Wait for address table to fill"- ADD FILTER/ONLY=(ADDRESS=C5VR,PROTOCOL=08-00)e4 TRACE/REPEAT=20/INTERVAL=00:05:00/BINARY/OUTPUT=C5VR= WAIT FOREVER "Now collecting IP data from NFS Server node..."  @End(ProgramExample) @Label[WAITdemo]G where this particular application first waits for the address table to BH be populated (the first WAIT command), then defines a filter to monitor G the Internet IP traffic in and out of the DECnet node named C5VR, then eH starts a repeating asynchronous TRACE command that collects a series of H files (each covering a 5 minute interval) for a total holding period of D 1 hour 40 minutes. It then WAITs FOREVER (so as to maintain the 100 6 minute sliding window of collected data indefinitely). @Chapter(Utilities)t @Label(Utilities) G Seven offline analysis utilities are supplied with ETHERMON for use in $* deciphering binary TRACE files. These are:5 @IndexSecondary(Primary="commands",Secondary="TRACE")N
 @Index(TRACE)f1 @IndexSecondary(Primary="TRACE",Secondary="file")P @Begin(Enumerate) 2 ETHERPARSE - the first attempt at an analysis tool  ? ETHERPARSE2 - a fancier version of ETHERPARSE; it can decipher sD AppleTalk packet headers, Internet IP, TCP, UDP, RIP, RPC, NFS, RPC  portmapper, and SNMP headers,tG XNS packet headers, DEC LAN Bridge packets, and ARP/RARP packets. This e4 program may be used for a TRACE/ANALYZER subprocess.  F ETHERPARSE_TCP - a specialized parser, it matches up packets from TCP K sessions, using remote/local host-address/port-number to uniquely identify oH sessions, and reports on the status of the session flow control countersJ (SEQ and ACK, from the RFC793 specification of the TCP protocol) for each  session.  A ETHERPARSE_XREF - a specialized parser, it matches up source and lA destination hosts, and counts the number of packets sent by each pH combination, then reports a list of such pairs sorted as to most active  pairs. Very slow program!R  H ETHFILT_ETHADDR - a secondary filter to help fine-tune the results of a I SET FILTER command in ETHERMON; it selects only records from a recording  @ file that contain the user-supplied Ethernet address and copies  them to another file.t  M ETHFILT_IPADDR - another secondary filter to help fine-tune the results of a rI SET FILTER command in ETHERMON; it selects only records from a recording  G file that contain the user-supplied DoD Internet IP address and copies l them to another file.S  H ETHFILT_NFS - yet another secondary filter; it passes only records that ? are speaking DoD Internet IP, and furthermore are speaking Sun /1 Microsystems' Network File System (NFS) protocol.P @End(Enumerate)C  L There are also two support subroutines which are available to help programs C connect up with ETHERMON as TRACE/ANALYZER subprocesses. These are:  @Begin(Enumerate)tI ETH_CHECK_SUBPROC - this subroutine accepts a dummy argument (it ignores aD it, but the variable is required for FORTRAN syntax), and returns a F LOGICAL*1 value indicating whether or not the calling program is in a J CLI-less subprocess (.TRUE. if environment appears to be a TRACE/ANALYZER  subprocess).6 @IndexSecondary(Primary="TRACE",Secondary="/ANALYZER")  I ETH_MAP_ADDRTBL - this subroutine does everything that ETH_CHECK_SUBPROC aC does, but then attempts to map the parent ETHERMON's address table yO COMMON global section into this process's address space; the procedure accepts aG a LOGICAL*1 argument that is .TRUE. if the subprocess wants read/write  E access to the table, and .FALSE. if read-only access is desired. The oJ procedure returns a LOGICAL*1 value indicating whether or not the calling K program is in a CLI-less subprocess (.TRUE. if environment appears to be a rJ TRACE/ANALYZER subprocess). It signals a fatal error if everything was OK E except that the global section was not properly aligned in memory (a rK COLLECT= linker option was not used to put the /ADDRESS_NAMES/ COMMON in a hC separate cluster of linker-allocated address space) or there was a dL mismatch between the ETHERMON main program's version of the section and the J calling subprocess's version. The proper linker /OPTIONS file directive is @Begin(ProgramExample)# COLLECT=ADDRESS_NAMES,ADDRESS_NAMESy @End(ProgramExample)6 @IndexSecondary(Primary="TRACE",Secondary="/ANALYZER") @End(Enumerate)e   @Section(ETHERPARSE); ETHERPARSE's source files consist of a single FORTRAN file tH ETHERPARSE.FOR. This program will prompt for the name of a TRACE binary G recording file (default file type .DAT), the name of an output listing sG file (default file type .LIS), and the optional start and end times of aG the data to select (if not supplied, all data in the file is accepted; nE if supplied, they must be valid VAX/VMS absolute times). Very little 1B error checking is done; if an invalid input file is supplied, the  program will crash sloppily. @Index(ETHERPARSE); @IndexSecondary(Primary="Utilities",Secondary="ETHERPARSE").  C The output file contains a series of formatted packets, where each 2C packet is begun with a blank line and a line containing the packet 1F time, source address, destination address, protocol type (with an 'i' D suffix if IEEE 802.3 SNAP protocol), and the packet length in bytes.G After this, there are lines of hexadecimal and ASCII representation of -= the packet data (16 bytes per line), with the hex data going 0D right-to-left, and the ASCII data going left-to-right (with periods @ representing unprintable characters); each line is ended with a > four-hex-digit number giving the offset of this line from the E beginning of the data link's data field of the packet. At the end of 0< the report is a list of packet counts for source addresses, G destination addresses, and protocol types; the left count is the total 2? for the entire file, and second column is the count within the A? specified time window (identical if no time limits were given)..   @Section(ETHERPARSE2).5 ETHERPARSE2's source files consist of a FORTRAN file  G ETHERPARSE2.FOR, and a MACRO source file ETHERPARSE2_CRF.MAR. Its user 0@ interface is identical to ETHERPARSE, with the exception of one B additional query: does the user want all of each packet dumped in B ASCII and hexadecimal, even if part of the packet was also dumped G symbolically (by default, any data dumped symbolically is skipped over  " in generating the ASCII/hex dump). @Index(ETHERPARSE2)2< @IndexSecondary(Primary="Utilities",Secondary="ETHERPARSE2")H Note that, to link ETHERPARSE2, you must use a LINK command of the form: @Begin(InputExample)  E $ @b<LINK ETHERPARSE2,ETHERPARSE2_CRF,ETH_MAP_ADDRTBL,SYS$INPUT:/OPT>t' @b<COLLECT=ADDRESS_NAMES,ADDRESS_NAMES>1 @i[<ctl-Z>]2   @End(InputExample)  @ The additional processing that ETHERPARSE2 supplies consists of: @Begin(Enumerate)iG decoding the LLP prefixes of AppleTalk packets, the DDP packet header, v% and (when valid) the NBP packet body. F @IndexSecondary(Primary="protocol type",Secondary="AppleTalk (80-9B)")4 @IndexSecondary(Primary="AppleTalk",Secondary="DDP")4 @IndexSecondary(Primary="AppleTalk",Secondary="NBP")  : decoding ARP messages (IP ARP, IP RARP, and AppleTalk ARP) @Index(ARP)e@ @IndexSecondary(Primary="protocol type",Secondary="ARP (08-06)") @Index(RARP)A @IndexSecondary(Primary="protocol type",Secondary="RARP (80-35)")n @Index(AARP)A @IndexSecondary(Primary="protocol type",Secondary="AARP (80-F3)")e  6 decoding some forms of DEC LAN Bridge control messagesG @IndexSecondary(Primary="protocol type",Secondary="LAN Bridge (80-38)")L  ) decoding XNS network level packet headersT @Index(XNS)D@ @IndexSecondary(Primary="protocol type",Secondary="XNS (06-00)")  I decoding DoD Internet message headers: IP (RFC 791, always), TCP and UDP )A (RFC's 793 and 768, when protocol type is one of these and not a OI continuation IP packet), ICMP (RFC 792, when protocol type is this), RIP  K (Routing Information Protocol, RFC 1058, when valid UDP and port number is  H 520), RPC (Sun Remote Procedure Call, RFC 1057; when valid after either J a TCP or UDP header), Sun NFS (Network File System, RFC 1094, after valid G UDP and RPC headers that specify NFS), RPC portmapper (RFC 1057, after PI valid TCP or UDP headers), and SNMP (Simple Network Management Protocol, R! RFC 1157, after valid UDP header)e? @IndexSecondary(Primary="protocol type",Secondary="IP (08-00)")s9 @IndexSecondary(Primary="protocol type",Secondary="ICMP")  @Index(NFS) 8 @IndexSecondary(Primary="protocol type",Secondary="NFS") @Index(RIP)P8 @IndexSecondary(Primary="protocol type",Secondary="RIP")8 @IndexSecondary(Primary="protocol type",Secondary="RPC")C @IndexSecondary(Primary="protocol type",Secondary="RPC portmapper")E9 @IndexSecondary(Primary="protocol type",Secondary="SNMP")E8 @IndexSecondary(Primary="protocol type",Secondary="TCP")8 @IndexSecondary(Primary="protocol type",Secondary="UDP") @Index(RFC768) @Index(RFC791) @Index(RFC792) @Index(RFC793) @Index(RFC1057); @Index(RFC1058)S @Index(RFC1094)$ @Index(RFC1157); @End(Enumerate)E  A Additional reports generated at the end of the formatted listing 0? include any of the following items that had their type of data   collected in the data file:$ @Begin(Enumerate)wF cross-reference of XNS socket usage by Ethernet addresses (flagged as  source or destination users) @Index(XNS)l@ @IndexSecondary(Primary="protocol type",Secondary="XNS (06-00)")  M per-Ethernet address client usage of NFS service calls, listing the names of  C the procedures called, and counts for each procedure for number of  I calls, number of identified successful replies, and number of identified I erroneous replies. @Index(NFS)e8 @IndexSecondary(Primary="protocol type",Secondary="NFS") @End(Enumerate)3  7 ETHERPARSE2 may be used as a TRACE/ANALYZER subprocess.f6 @IndexSecondary(Primary="TRACE",Secondary="/ANALYZER")   @Section(ETHERPARSE_TCP)? ETHERPARSE_TCP's source files consist of a single FORTRAN file eL ETHERPARSE_TCP.FOR. This program will prompt for the name of a TRACE binary J recording file (default file type .DAT) and the name of an output listing + file (default file type .LIS). Very little  B error checking is done; if an invalid input file is supplied, the  program will crash sloppily. @Index(ETHERPARSE_TCP)? @IndexSecondary(Primary="Utilities",Secondary="ETHERPARSE_TCP")e  C The output file contains a series of formatted packets, where each .; packet is displayed on a single line containing the packet sK time, source IP address and TCP port, destination IP address and TCP port, SF sequence number (with computed error flags), acknowledge number (with L computed error flags), window size value, and any additional flags from the J TCP header (URG, FIN, PSH, etc.). This processes the TCP header according G to the documentation in RFC793. At the end of the report, a summary of dG packets processed and packets discarded as not being TCP/IP is printed.n8 @IndexSecondary(Primary="protocol type",Secondary="TCP") @Index(RFC793)   @Section(ETHERPARSE_XREF)s@ ETHERPARSE_XREF's source files consist of a single FORTRAN file M ETHERPARSE_XREF.FOR. This program will prompt for the name of a TRACE binary CG recording file (default file type .DAT), the name of an output listing )+ file (default file type .LIS). Very little oB error checking is done; if an invalid input file is supplied, the  program will crash sloppily. @Index(ETHERPARSE_XREF) @ @IndexSecondary(Primary="Utilities",Secondary="ETHERPARSE_XREF")  G The output file contains a list of packet counts for source addresses, dK destination addresses, and protocol types. Following this list is one more UH list of matched pairs of source and destination addresses (displayed in G Ethernet physical format and Internet IP [if valid] with packet counts.cG All lists (except the protocol list) are sorted in descending order of e number of packets.  K This program was written rather inefficiently with regard to both CPU time EJ and virtual memory consumption; do not expect quick response from it if a G large number of different combinations are present in your data sample.    @Section(ETHFILT_ETHADDR) @ ETHFILT_ETHADDR's source files consist of a single FORTRAN file  ETHFILT_ETHADDR.FOR. Its user B interface is similar to ETHERPARSE; it prompts for an input TRACE B binary recrding file (default file type .DAT), and a name for the E to-be-created output binary recording file (default file type .DAT). rA It then prompts for the Ethernet physical address of the packets  I (using the fixed format @i<@u[aa-bb-cc-dd-ee-ff]>, where the hyphens are  G required and each byte must be specified by two hexadecimal digits) to sD filter for. Any packets which do not contain the specified Ethernet   address in either the source or L destination address fields of the data link layer header are discarded; the 7 remaining packets are copied to the output file, and a  @ statistical summary of packets processed is printed on the user 	 terminal.N @Index(filter) @Index(ETHFILT_ETHADDR)r@ @IndexSecondary(Primary="Utilities",Secondary="ETHFILT_ETHADDR")   @Section(ETHFILT_IPADDR)H ETHFILT_IPADDR's source files consist of two versions of a FORTRAN file,E ETHFILT_IPADDR_TGV.FOR and ETHFILT_IPADDR_UCX.FOR, and corresponding tH linker options files ETHFILT_IPADDR_TGV.OPT and ETHFILT_IPADDR_UCX.OPT. K Its user interface is similar to ETHERPARSE; it prompts for an input TRACE LC binary recording file (default file type .DAT), and a name for the sE to-be-created output binary recording file (default file type .DAT). bE It then prompts for the Internet IP physical (numeric, not symbolic) "F address of the packets to filter for. Any packets which are not IP or @ do not contain the specified IP address in either the source or ? destination address fields of the IP header are discarded; the a7 remaining packets are copied to the output file, and a m@ statistical summary of packets processed is printed on the user 	 terminal.. @Index(filter) @Index(ETHFILT_IPADDR)? @IndexSecondary(Primary="Utilities",Secondary="ETHFILT_IPADDR")s? @IndexSecondary(Primary="protocol type",Secondary="IP (08-00)")e  B The linker options file is used to specify the object files to be @ linked. The two versions assume that either TGV MultiNet or DEC P VMS/Ultrix Connection (UCX, now called TCP/IP Services for VMS) is the Internet  software running YJ on the local system; as such, they specify the appropriate socket library > shareable image as a place to get the Internet address format @ conversion routines (either MULTINET:MULTINET_SOCKET_LIBRARY or D SYS$SHARE:VAXCRTL). To link either image, a LINK command of the form @Begin(InputExample)  G $ @b<LINK/EXE=ETHFILT_IPADDR ETHFILT_IPADDR_>@i<@u[version]>@b</OPTION>g   @End(InputExample); should be used, where @i<@u[version]> is either TGV or UCX. E @IndexSecondary(Primary="Internet software",Secondary="TGV MultiNet")S@ @IndexSecondary(Primary="Internet software",Secondary="DEC UCX")T @IndexSecondary(Primary="Internet software",Secondary="DEC TCP/IP Services for VMS")   @Section(ETHFILT_NFS)mM ETHFILT_NFS's source files consist of a single FORTRAN file ETHFILT_NFS.FOR. mK Its user interface is similar to ETHERPARSE; it prompts for an input TRACE eB binary recrding file (default file type .DAT), and a name for the E to-be-created output binary recording file (default file type .DAT). tD Any packets which are not IP/UDP or do not contain RPC/NFS data are F discarded; the remaining packets are copied to the output file, and a @ statistical summary of packets processed is printed on the user 	 terminal.t @Index(filter) @Index(ETHFILT_NFS)s< @IndexSecondary(Primary="Utilities",Secondary="ETHFILT_NFS")? @IndexSecondary(Primary="protocol type",Secondary="IP (08-00)")f8 @IndexSecondary(Primary="protocol type",Secondary="UDP")8 @IndexSecondary(Primary="protocol type",Secondary="RPC") @Index(NFS)s8 @IndexSecondary(Primary="protocol type",Secondary="NFS")  H Note that, to link ETHFILT_NFS, you must use a LINK command of the form: @Begin(InputExample)  ( $ @b<LINK ETHFILT_NFS,ETH_CHECK_SUBPROC>   @End(InputExample)  7 ETHFILT_NFS may be used as a TRACE/ANALYZER subprocess. 6 @IndexSecondary(Primary="TRACE",Secondary="/ANALYZER")! @Chapter(Security Considerations)VF For system and network administrators who are concerned about illicit K monitoring of their networks: ETHERMON does that sort of thing just dandy! DL Seriously, network monitoring is the whole purpose of ETHERMON; ETHERMON is G supposed to be able to see all traffic that passes by on your network. rJ However, there are constraints to help prevent @u<@i{illicit}> monitoring  of the network with ETHERMON:d @Begin(Enumerate)eP ETHERMON requires a fair number of sensitive user privileges to be able to run: O PHY_IO, NETMBX, TMPMBX, and CMKRNL, to be precise (or SETPRV, which allows all gK the others to be enabled). Similarly, it requires rather large user quotas a@ (BYTLM). All of these can only be granted by a user with system K administrator privileges. As such, it is highly recommended NOT to install   ETHERMON.EXE with privilege.8 @IndexSecondary(Primary="privileges",Secondary="CMKRNL")8 @IndexSecondary(Primary="privileges",Secondary="NETMBX")8 @IndexSecondary(Primary="privileges",Secondary="TMPMBX")8 @IndexSecondary(Primary="privileges",Secondary="PHY_IO")8 @IndexSecondary(Primary="privileges",Secondary="SETPRV")3 @IndexSecondary(Primary="quotas",Secondary="BYTLM")n  H VAX/VMS V5.4-3 and higher @i<require> the use of an installed protected K shareable image, which requires even more privileges to set up. Changes to  F the installed image list can be easily audited for, and the essential L shareable image (ETHERMON_FASTSHR) can be placed under VMS file protections  to control access to it. @Index(INSTALL)p  F The main executable image file of ETHERMON depends on its location to K locate other files. Therefore, illicit copies of the executable file would uN not be able to access the installed official copy of the shareable image file H (unless a system-wide executive-mode logical name was defined @b[@i<and % visible>] to the account being used).l @Index(logical name) @End(Enumerate)b  G This is as opposed to PC and Macintosh-based monitoring tools, such as sH NetMinder, where simple physical access to the software package and the J computer in question is enough to guarantee the ability to run a monitor. G Even if a VAX/VMS user was to "roll their own" monitoring software (as iK ETHERMON V1.0 was originally created), a minimum of PHY_IO privilege would TL still be required to enable the promiscuous monitoring mode on the Ethernet  interface device.i @Index(promiscuous mode)  I For system administrators who are concerned about un-trusted kernel-mode tM code (the V2.4 enhancements involving ETHERMON_FASTSHR.EXE) running on their e/ systems, there are four safety checks in place:  @Begin(Enumerate)eI As with the rest of ETHERMON, complete commented source code is provided  L for the program, allowing you to study what ETHERMON would be doing to your E system. This source code is located in the file ETHERMON_FASTSHR.MAR./  H Random users cannot take advantage of the kernel mode hooks because the H shareable image does not implement a user-written system service; it is K implemented as a shareable image only to keep the necessary system version gJ dependencies out of the main ETHERMON code, and to allow a non-defeatable H image rundown routine to be executed. Therefore, users of the shareable F image still require all the privileges needed to run ETHERMON and the K shareable image's extensions (i.e., users could link their own code to the p@ shareable image, but they would not gain any privilege from it).  I ETHERMON is capable of functioning without the "fast" port interface for tI VAX/VMS versions V5.4-2 and below (it requires it for VAX/VMS V5.4-3 and dK above). To disable ETHERMON's attempts to use the "fast" interface, simply  D do not keep a copy of ETHERMON_FASTSHR.EXE in the same directory as J ETHERMON.EXE, and/or do not install the image appropriately (as described > in section @Ref[INSTALL] on page @PageRef[INSTALL]). ETHERMON M @b[cannot] use the shareable image unless it is installed as described above.pK On a failed attempt to use the shareable image, ETHERMON will print out an oJ appropriate error message describing why it could not activate the "fast" F interface, and then either continue using the old interface scheme or 6 terminate (depending on the operating system version).< @IndexSecondary(Primary="VAX/VMS",Secondary="V5.4-3 and up")  L Because the shareable image is activated using the standard services of the H VAX/VMS Image Activator, an image that was linked under an incompatible J operating system version cannot be activated; however, do not just relink L ETHERMON_FASTSHR if this happens, but re-compile it as well (to ensure that N any system macro changes will be accounted for). Note that there should never L be any link-time errors from linking the shareable image; if there are, the I image is suspect and should not be used. Also, a linker options file (as  H embedded in the file ETHERMON.COM) must be used to guarantee the proper ! structure of the shareable image.I @End(Enumerate)  @Appendix(Messages)r @Section(ETHERMON Messages)R @Begin(Enumerate)p
 @Begin(Group)s @Begin(ProgramExample)T %ETHERMON-I-ADRPROTOVF, no room to store @i<@u[aa-bb]> for @i<@u[aa-bb-cc-dd-ee-ff]> @End(ProgramExample)F While automatically updating the address table during a message read, J ETHERMON ran out of protocol type slots for a single address entry in the L address table, and could not store an additional new protocol type for that J address. Verify that the specified address on the Ethernet is supposed to I be servicing that many protocol types simultaneously; if this is normal, lG edit the file ETHERMON_ADDR.INC to increase the value of the parameter e8 ICPADR_MAXPROTS and recompile and relink ETHERMON. This J message will only be displayed with the SET MESSAGES DEBUG command active. @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)i  
 @Begin(Group)n @Begin(ProgramExample)K %ETHERMON-W-ADRTBLFUL, address table full - new address/name pair not added  @End(ProgramExample)C A SET ADDRESS_NAME or LOAD command attempted to add a new Ethernet EF address to the address table, but there was no more room for it. This C requires a rather complicated procedure to enlarge the size of the qH address table in the source code (file ETHERMON_ADDR.INC, and scattered B changes to address insertion logic throughout ETHERMON.FOR), then  rebuilding the program.y @End(Group)   
 @Begin(Group)n @Begin(ProgramExample)F %ETHERMON-F-ADRTBLOVF, Ethernet address table overflow - PROGRAM ABORT @End(ProgramExample)G During a DISPLAY or SUMMARIZE command, there was no longer room in the  H address table to add a new entry that was being counted up. The program K has crashed. To correct this, the address table must be enlarged. However,  L this also implies that you have an exceedingly busy Ethernet, which you may  wish to correct.  G Note that this message will only appear while SET MESSAGES DEBUG is in tK effect (which can happen by default if ETHERMON_CMD_S.FOR is compiled with p the /D_LINES option).= @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES")$ @Index[/D_LINES (FORTRAN qualifier)] @End(Group)o  
 @Begin(Group)  @Begin(ProgramExample)2 %ETHERMON-I-ALLFLTDEL, all defined filters deleted @End(ProgramExample)F A CLEAR FILTERS/ALL command has been executed successfully. No action  is required. @End(Group)n  
 @Begin(Group)I @Begin(ProgramExample)J %ETHERMON-E-ALRDYPRMUSR, promiscuous user already active on this interface @End(ProgramExample)M This error is caused by the fact that there is already a promiscuous user on eI the Ethernet interface you are attempting to use. Try another interface, mA or get rid of the existing promiscuous user (it could be another e invocation of this program). @End(Group)P  
 @Begin(Group)s @Begin(ProgramExample)S %ETHERMON-I-ANLRPT, TRACE/ANALYZER PID=@i<@u[xxxxxxxx]> elapsed=@i<@u[hh:mm:ss.cc]>oh                    CPU=@i<@u[hh:mm:ss.cc]> pf=@i<@u[nn]> bio=@i<@u[nn]>(@i<@u[nn]> extra) dio=@i<@u[nn]> @End(ProgramExample)F The subprocess created by a TRACE/ANALYZER command completed with the O specified accounting statistics. An additional message will follow, giving the sJ final completion status of the subprocess. No action is necessary (unless : you wish to troubleshoot a non-success completion status). @End(Group)   
 @Begin(Group)e @Begin(ProgramExample)= %ETHERMON-I-ASYNTRCBEG, asynchronous TRACE command started...o @End(ProgramExample)E A TRACE command was entered with the /PARALLEL or /REPEAT qualifier, =D and is now running in the background while another ETHERMON command ( prompt is issued. No action is required. @End(Group)d  
 @Begin(Group)x @Begin(ProgramExample)= %ETHERMON-I-ASYNTRCDON, asynchronous TRACE command completed.= @End(ProgramExample)C A TRACE command with /PARALLEL completed its time interval, or the )A TRACE/ABORT command was entered to shut down a TRACE/PARALLEL or RG TRACE/REPEAT command, or ETHERMON was exited while a TRACE/PARALLEL or  / TRACE/REPEAT was active. No action is required.7 @End(Group)e  
 @Begin(Group)n @Begin(ProgramExample)@ %ETHERMON-W-BADADDRNUM, invalid octet in Ethernet address number @End(ProgramExample)G A standard format physical Ethernet address was specified where one of eG the octets was outside the range 00 to FF. Re-enter the command with a e valid address. @End(Group)l  
 @Begin(Group)( @Begin(ProgramExample)L %ETHERMON-I-BADAPPLE, @i<@u[aa-bb-cc-dd-ee-ff]> sent unknown AppleTalk layer @End(ProgramExample)G The specified node transmitted an AppleTalk/EtherTalk packet where the fF higher-level protocol type was not recognized (not DDP). Find why the F node is sending invalid packets; if the packets turn out to be valid, C please send a bug report to the author of ETHERMON, reporting what e5 type of traffic is being mislabeled as invalid. This m< message can be suppressed with the SET MESSAGES OFF command.4 @IndexSecondary(Primary="AppleTalk",Secondary="DDP") @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)d  
 @Begin(Group)  @Begin(ProgramExample)* %ETHERMON-W-BADFIL, invalid record in file @End(ProgramExample)H While reading a SAVE'd address or filter file, an invalid record in the I file was found; the record was ignored. If the file was manually edited, mD use an un-edited version of the file or correct the record's syntax. @End(Group)f  
 @Begin(Group)s @Begin(ProgramExample)K %ETHERMON-I-BADPNGADR, can't ping to a multicast address (except Broadcast)  @End(ProgramExample)G The PING command was entered with a multicast address as a target. Use sD a valid physical (not multicast) Ethernet address when entering the 
 PING command.i @Index(multicast address)e @End(Group)N  
 @Begin(Group)s @Begin(ProgramExample)A %ETHERMON-W-BADPROTNUM, invalid octet in Ethernet protocol numbero @End(ProgramExample)I A standard format Ethernet protocol type code was specified where one of dI the octets was outside the range 00 to FF. Re-enter the command with the c correct protocol type code.P @End(Group)o  
 @Begin(Group)t @Begin(ProgramExample)H %ETHERMON-I-BRGMAPOLD, bridge map is out of date - use MAP command again @End(ProgramExample)D A new Ethernet bridge made itself known after the last time the MAP = command was executed, thereby probably obsoleting the bridge fC interconnection map computed by the MAP command. This message will .F appear when using the SHOW BRIDGES/FULL command to display the bridge ? map. Enter the MAP command again to recompute the map with the   additional data. @Index(MAP) 3 @IndexSecondary(Primary="commands",Secondary="MAP")t @Index(SHOW BRIDGES)< @IndexSecondary(Primary="commands",Secondary="SHOW BRIDGES") @End(Group)   
 @Begin(Group)  @Begin(ProgramExample)M %ETHERMON-I-BRGPRTINF, vague remote line data obtained; bridge map unreliable  @End(ProgramExample)P While executing a MAP command, bridge port data was not complete for the remote J side of some bridge map entries. This is a frequent occurrence if bridges H using the DEC LAN Bridge protocol appear on the network, as they do not K specify which Ethernet address corresponds to which side of the bridge. No fK action is required, but it does imply possible errors that might appear in f) the output of a SHOW BRIDGES/MAP command.r @Index(MAP)C3 @IndexSecondary(Primary="commands",Secondary="MAP")d @Index(SHOW BRIDGES)< @IndexSecondary(Primary="commands",Secondary="SHOW BRIDGES")G @IndexSecondary(Primary="protocol type",Secondary="LAN Bridge (80-38)")  @End(Group)x  
 @Begin(Group)a @Begin(ProgramExample)@ %ETHERMON-W-BRGROUTOVF, routing table overflow for bridge #@u<n> @End(ProgramExample)F While executing a MAP command, the bridge being queried returned more F valid bridge addresses than the bridge mapping table could hold. Note  that this can only happen when:d @Begin(Enumerate) D executing the MAP command on a large Ethernet with many bridges, and  5 in the file ETHERMON_BRIDGES.INC file, the parameter IB ICPBRG_MAXBRGROUT is smaller than the parameter ICPBRG_MAXBRIDGES. @End(Enumerate)=K To correct the problem, edit ETHERMON_BRIDGES.INC to set ICPBRG_MAXBRGROUT  N equal to ICPBRG_MAXBRIDGES (you may also wish to enlarge ICPBRG_MAXBRIDGES if A you find that the SHOW BRIDGES command shows you exactly as many AI bridges as the current table size); then re-compile and re-link ETHERMON.E @End(Group)   
 @Begin(Group)p @Begin(ProgramExample)Q %ETHERMON-I-BRGTMO, @u<n> timeouts while querying bridges - use MAP command againr @End(ProgramExample)I While executing a MAP command, responses were not received the specified iD number of times, either due to packet drops by ETHERMON, the bridge L ignoring the request, or some other network glitch that would cause packets I to be dropped before they reached the monitoring system. It is suggested  I that you repeat the MAP command to ensure that data is received from all r the bridges. @Index(MAP)r3 @IndexSecondary(Primary="commands",Secondary="MAP")x @End(Group)D  
 @Begin(Group)r @Begin(ProgramExample), %ETHERMON-I-BRGTMO2, bridge #@u<n> timed out @End(ProgramExample)J While executing a MAP command with SET MESSAGES DEBUG, a response was not M received from the specified bridge, either due to a packet drop by ETHERMON,  N the bridge ignored the request, or some other network glitch that would cause H a packet to be dropped before they reached the monitoring system. It is O suggested that you repeat the MAP command to ensure that data is received from e all the bridges. @Index(MAP) 3 @IndexSecondary(Primary="commands",Secondary="MAP")R @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)X  
 @Begin(Group)E @Begin(ProgramExample)< %ETHERMON-E-CANTDOIEEE, this VAX can't support IEEE 802 mode @End(ProgramExample)A A command was entered that requires the Ethernet interface to be oO running in IEEE 802.3 extended mode, but ETHERMON was started in Ethernet mode CB instead because the interface or the VAX system, for some reason, F could not operate in IEEE 802.3 mode. Find why the VAX cannot support H IEEE 802.3 extended mode on the selected Ethernet interface (typically, A this is because you are using a VAX running VMS V4.7 or earlier).a3 @IndexSecondary(Primary="VAX/VMS",Secondary="V4.x")  @Index(IEEE 802.3) @End(Group)n  
 @Begin(Group)e @Begin(ProgramExample)F %ETHERMON-W-CANTSTART, can't start Ethernet port, devchar=@u<xxxxxxxx> @End(ProgramExample)E Some sort of VMS I/O driver error occurred while trying to start the rF Ethernet interface for promiscuous monitoring. An accompanying system B message will give additional details as to the cause of the error. @End(Group)N  
 @Begin(Group)d @Begin(ProgramExample)D %ETHERMON-I-CLSINDFIL, indirect command file closed due to control-C @End(ProgramExample)M A control-C was typed while an indirect command file was executing. Not only dK was the current command aborted, but the command file was closed and input SI redirected to the standard input device SYS$INPUT. No action is required.N @End(Group),  
 @Begin(Group)> @Begin(ProgramExample)4 %ETHERMON-W-CMPETHRD, error completing Ethernet read @End(ProgramExample)C Some sort of VMS I/O driver error occurred during completion of an oD asynchronous read of the Ethernet interface. An accompanying system B message will give additional details as to the cause of the error. @End(Group)!  
 @Begin(Group)t @Begin(ProgramExample)E %ETHERMON-W-CMPNETACP, error completing status query to DECnet NETACPt @End(ProgramExample)F A request was sent to the DECnet NETACP process to translate a DECnet C node number to a node name, and the request completed in error. An aI accompanying system message will give additional details as to the cause lG of the error. This message can be suppressed with the SET MESSAGES OFF   command. @Index(DECnet) @Index(NETACP) @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)   
 @Begin(Group)s @Begin(ProgramExample)- %ETHERMON-F-CRASHDUMP, crash dump of ETHERMONo @End(ProgramExample)H This prefixes a fatal error report from within the per-message read and H analysis code in ETHERMON. The following lines will give context of the I error. This information (other than the traceback) will also be recorded iK in a disk file named ETHERMON.CRASH_DUMP in the current directory. If this EJ should happen, please contact the author and send him a copy of the crash C dump file's contents (the file is ASCII and easily mailed); please lD include the version of ETHERMON you were running and the version of  VAX/VMS you were running under.a @Index(crash dump file)  @End(Group)h  
 @Begin(Group)H @Begin(ProgramExample)C %ETHERMON-W-DISPJAMMD, screen stalled for > 7 minutes; data munchedS @End(ProgramExample)F Either the user accidentally pressed the NO SCROLL key (control-S) on H his/her keyboard for too long during a DISPLAY command, or ETHERMON was D over-saturated with network messages continuously for too long. The F DISPLAY command is terminated. Re-enter the DISPLAY command and don't 3 leave NO SCROLL active for such a long time period.g @Index(control-S)u @End(Group)h  
 @Begin(Group)t @Begin(ProgramExample)m %ETHERMON-W-DUPIPADR, @i<@u[aa-bb-cc-dd-ee-ff]> has same IP adr @i<@u[a.b.c.d]> as @i<@u[aa-bb-cc-dd-ee-ff]> r @End(ProgramExample)L The SET MESSAGES DUPIP ON command has been entered, and ETHERMON detected a H node claiming the same IP source address as an existing node (the first J Ethernet address displayed in the message is the new node, and the second M Ethernet address is the older entry in the address table). Determine why two i1 different IP hosts are using the same IP address.o @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)E  
 @Begin(Group)r @Begin(ProgramExample)9 %ETHERMON-W-ERRGETSYI, error issuing $GETSYI service callh @End(ProgramExample)F During ETHERMON initialization, an attempt to query VAX/VMS for systemH identification or configuration data failed. Use the associated VAX/VMS ? error message to determine why the $GETSYI service call failed.n @End(Group)n  
 @Begin(Group)l @Begin(ProgramExample)A %ETHERMON-E-ERROPNIND, can't open specified indirect command file  @End(ProgramExample)@ For some reason, ETHERMON cannot open the indirect command file / specified with the last @@@i<filespec> command.a @Index(@@filespec): @IndexSecondary(Primary="commands",Secondary="@@filespec") @End(Group)l  
 @Begin(Group)e @Begin(ProgramExample)I %ETHERMON-E-FILOPNERR, FORTRAN I/O error #@u<nn> trying to open LOAD file  @End(ProgramExample)G ETHERMON could not open the specified file during a LOAD command. Look  I up the FORTRAN IOSTAT error message number and correct the corresponding e problem. @End(Group)s  
 @Begin(Group)  @Begin(ProgramExample)8 %ETHERMON-I-FLTADDDIS, filter #@u<nn> added and disabled @End(ProgramExample)J The ADD FILTER command successfully defined a new filter and disabled it.  No action is necessary.n @End(Group)n  
 @Begin(Group)p @Begin(ProgramExample)7 %ETHERMON-I-FLTADDENA, filter #@u<nn> added and enabledE @End(ProgramExample)H The ADD FILTER command successfully defined a new filter and enabled it. No action is necessary.s @End(Group)e  
 @Begin(Group)r @Begin(ProgramExample)* %ETHERMON-I-FLTDEL, filter #@u<nn> deleted @End(ProgramExample)F The CLEAR FILTER command successfully deleted a filter definition. No  action is necessary. @End(Group)n  
 @Begin(Group). @Begin(ProgramExample); %ETHERMON-I-FLTMODDIS, filter #@u<nn> modified and disabledl @End(ProgramExample)B The SET FILTER command successfully modified a filter definition, 9 leaving it in the disabled state. No action is necessary.v @End(Group)   
 @Begin(Group)e @Begin(ProgramExample): %ETHERMON-I-FLTMODENA, filter #@u<nn> modified and enabled @End(ProgramExample)B The SET FILTER command successfully modified a filter definition, 8 leaving it in the enabled state. No action is necessary. @End(Group)t  
 @Begin(Group)m @Begin(ProgramExample)? %ETHERMON-W-FLTTBLFUL, filter table full - new filter not added  @End(ProgramExample)H An ADD FILTER or LOAD command failed because there was not enough space D in the filter table. Remove some unused filter definitions with the B CLEAR FILTER command and try the ADD FILTER or LOAD command again. @End(Group)   
 @Begin(Group)@ @Begin(ProgramExample)J %ETHERMON-I-FNDINETGW, @i<@u[aa-bb-cc-dd-ee-ff]> is an Internet IP gateway @End(ProgramExample)G Sufficient data has been received to determine that the specified node eC is an Internet IP gateway, or router. No action is necessary. This w? message can be suppressed with the SET MESSAGES IP OFF command.e @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)   
 @Begin(Group)t @Begin(ProgramExample)S %ETHERMON-I-FNDMLTIPA, @i<@u[aa-bb-cc-dd-ee-ff]> has multiple Internet IP addresseskC                 first is @i<@u[a.b.c.d]>, second is @i<@u[e.f.g.h]>S @End(ProgramExample)? During the monitoring, messages specifying more than one legal a non-broadcast DoD Internet IP D address was detected being sent to or received by a single Ethernet F node; this may imply that the node is an Internet IP gateway (but not M yet confirmed as such), or that the node is misconfigured. The first address  E displayed is the one the node originally appeared as, and the second sG is the second address listed. Note that third, fourth, etc., addresses l> will not be displayed; only enough addresses to determine the A multi-address characteristics of the node will be reported. This e? message can be suppressed with the SET MESSAGES IP OFF command.o @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)m  
 @Begin(Group)a @Begin(ProgramExample)x %ETHERMON-I-HISYSGEN, SYSGEN parameters are high: DEFMBXBUFQUO=@u<@i[nnn]> PQL_MBYTLM=@u<@i[nnn]> PQL_DBYTLM=@u<@i[nnn]> @End(ProgramExample)L While initializing ETHERMON, the program happened to notice that the values G for one or more of the SYSGEN parameters DEFMBXBUFQUO, PQL_MBYTLM, and eL PQL_DBYTLM seemed to be unusually large. This may or may not have an affect H on the operation of ETHERMON; however, these parameters are used in the L BYTLM quota calculations (documented under the LOWBYTLM error message), and I may cause a following LOWBYTLM error to occur. SHould you get a LOWBYTLM oL message immediately after receiving the HISYSGEN message, check whether the L SYSGEN parameters are supposed to be that large; if they are, you will need @ to increase the BYTLM quota for your user account to compensate. @Index(SYSGEN)3 @IndexSecondary(Primary="quotas",Secondary="BYTLM")c @End(Group)e  
 @Begin(Group)s @Begin(ProgramExample)K %ETHERMON-I-INCBRGDAT, incomplete data used for map - use MAP command agains @End(ProgramExample)H While the MAP command was being executed, it discovered that incomplete E infomation was stored for some of the bridges known to ETHERMON. The oK additional information was automatically filled in, but not necessarily in HH time for previous queries to other bridges to take advantage of the new F information. The MAP command should be re-executed to re-run the data . collection with the new information available. @Index(MAP))3 @IndexSecondary(Primary="commands",Secondary="MAP")c @End(Group)   
 @Begin(Group)c @Begin(ProgramExample)K %ETHERMON-F-INCONSIST, internal inconsistency in command parser - submit PRs @End(ProgramExample)G While parsing a command entered by the user, the parser disconvered an tL internal inconsistency in the parsing logic. If this message occurs, please I submit a problem report to the author, giving the exact command line you R/ entered (character for character). Also please PD include the version of ETHERMON you were running and the version of  VAX/VMS you were running under.d @End(Group)s  
 @Begin(Group)G @Begin(ProgramExample)p %ETHERMON-I-IMOPMSG, @i<@u[hh:mm:ss aa-bb-cc-dd-ee-ff]> sent iMOP @i<@u[prot]> msg, t=@i<@u[xxxx]> ln=@i<@u[nn]> @End(ProgramExample)A The specified node transmitted a DEC MOP (Maintenance Operations aF Protocol) message (using IEEE 802.3 SNAP formatting) of a significant A type. @i<@u[prot]> specified whether the message was a Dump/Load t@ Assistance (60-01) or Remote Console (60-02) protocol type, the < "t=@i<@u[xxxx]>' specifies the first word of the message in K hexadecimal (high byte first), and "ln=@i<@u[nn]>" gives the length of the r message in bytes. This  @ message can be suppressed with the SET MESSAGES MOP OFF command. @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @Index(IEEE 802.3) @End(Group)   
 @Begin(Group)- @Begin(ProgramExample)J %ETHERMON-W-INVDSPINT, invalid display interval of @u<nn> sec; not changed @End(ProgramExample)H The SET INTERVAL command specified an invalid or out-of-range number of A seconds for the display update interval; the old setting was not tC changed. Re-enter the command with a valid number between 2 and 59.o @End(Group)   
 @Begin(Group)s @Begin(ProgramExample)D %ETHERMON-W-INVFLTNUM, specified filter is undefined or out of range @End(ProgramExample)< In a SET FILTER or CLEAR FILTER command, there is no filter I corresponding to the specified filter index number. Re-enter the command  E with a valid filter index (use the SHOW FILTER command to check what o filter numbers are defined). @End(Group)d  
 @Begin(Group)e @Begin(ProgramExample)9 %ETHERMON-E-INVNODSPC, invalid network node specificationd @End(ProgramExample)B An ADD FILTER or SET FILTER command specified an Ethernet address E symbolically by DECnet node number, DECnet node name, or Internet IP )I address, but there was a syntax error in the specification. Re-enter the t$ command with a valid-syntax address. @End(Group)r  
 @Begin(Group)s @Begin(ProgramExample)I %ETHERMON-W-INVTRCTYP, only 1 file format qualifier may be given on TRACE  @End(ProgramExample)I A TRACE command was entered with more than one of the qualifiers /ASCII, )M /BINARY, /SNIFFER, or /ANALYZER. Only one of these qualifiers may be used at rO a time. Re-enter the TRACE command with only one of the file format qualifiers.  @End(Group)e  
 @Begin(Group)e @Begin(ProgramExample)\ %ETHERMON-I-LOWBYTLM, current BYTLM=@i<@u[nnnn]> lower than recommended minimum @i<@u[mmmm]> @End(ProgramExample)K This message will appear during ETHERMON start-up if your process does not oM have sufficient BYTLM quota left to allow ETHERMON to execute. It may appear AN as an informational message (ETHERMON will run anyway, with possible degraded K performance) or as a fatal error (ETHERMON cannot run and will terminate). hJ Get your BYTLM quota raised, or don't run as many other applications that M consume BYTLM quota from your process. Note that the recommended minimum for xM efficient operation is at least 10000 bytes higher than the absolute minimum oB required for the program to run at all. Note that the recommended J minimum may seem rather large if other layered products have modified the P SYSGEN parameters DEFMBXBUFQUO, PQL_MBYTLM, or PQL_DBYTLM. The absolute minimum  is determined by the formula @Begin(ProgramExample)# value = MAX(PQL_MBYTLM,PQL_DBYTLM) n         + DEFMBXBUFQUO&         + @i<buffer_size_of_port> + 50         + 1100&         + @i<buffer_size_of_port> + 50,         + 4 * (@i<buffer_size_of_port> + 50)         + 4 * 512h
         + 252  @End(ProgramExample)E where the SYSGEN parameters are used to reserve enough quota for the  N SPAWN command to work, the first @i<buffer_size_of_port>+50 is for the normal G $QIO read buffer needed by ETHERMON, the 1100 is for other I/O buffers S8 (terminal I/O, etc.) needed by ETHERMON, and the second : @i<buffer_size_of_port>+50 is to account for at least one > pre-allocated receive buffer for the Ethernet I/O driver (the K NMA$C_PCLI_BFN extended characteristic), the 4*(@i<buffer_size_of_port>+50) M is for two maximum-size messages in a mailbox for the TRACE/ANALYZER command tP and the write $QIO by ETHERMON and the read by the subprocess, the 4*512 is for I standard output and standard error output by the TRACE/ANALYZER command,  L and the 252 is for TRACE/ANALYZER termination handling; for each additional C @i<buffer_size_of_port>+50 bytes available above this minimum, the uN NMA$C_PCLI_BFN value used is incremented by 1, to a maximum value of 127. The L value of @i<buffer_size_of_port> is 1492 for Ethernet devices, and 4468 for J FDDI devices (the NMA$C_PCLI_MBS extended characteristic). Note also that ; these calculations are performed after some BYTLM quota haslN already been consumed to create the cloned device units for the Ethernet/FDDI ) interface and the DECnet network mailbox.r
 @Label[quota]  @Index(FDDI) @Index(SYSGEN parameters)l3 @IndexSecondary(Primary="quotas",Secondary="BYTLM")d
 @Index(SPAWN)i5 @IndexSecondary(Primary="commands",Secondary="SPAWN")O
 @Index(TRACE) 5 @IndexSecondary(Primary="commands",Secondary="TRACE")  @Index(DECnet) @Index(mailbox)e @End(Group)   
 @Begin(Group)o @Begin(ProgramExample)a %ETHERMON-W-MDUPIP, @i<@u[aa-bb-cc-dd-ee-ff]> (@i<@u[name]>) claims @i<@u[aa-bb-cc-dd-ee-ff]> hasIL                    same IP adr @i<@u[a.b.c.d]> as @i<@u[aa-bb-cc-dd-ee-ff]>  @End(ProgramExample)L The SET MESSAGES DUPIP ON command has been entered, and ETHERMON detected a H node claiming the same IP source address as an existing node (the first J Ethernet address displayed in the message is the new node, and the second M Ethernet address is the older entry in the address table). Determine why two t1 different IP hosts are using the same IP address.y @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)d  
 @Begin(Group)r @Begin(ProgramExample)M %ETHERMON-W-MNFTBLFUL, manufacturer table full - new code/name pair not addedM @End(ProgramExample)H A SET MANUFACTURER command attempted to add a new Ethernet manufacturer E prefix to the manufacturer table, but there was no more room for it. sA Increase the value of the manufacturer name table size parameter hI ICPMNF_MAXNAMES in ETHERMON_MANUF.INC, then rebuild the ETHERMON program.m @End(Group)R  
 @Begin(Group)n @Begin(ProgramExample)K %ETHERMON-F-MNFTBLOVF, Ethernet manufacturer table overflow - PROGRAM ABORTt @End(ProgramExample)M The manufacturer prefix table did not have enough free space to store all therM different manufacturer prefixes seen on your Ethernet. Increase the value of 7@ the manufacturer prefix table size parameter ICPMNF_MAXNAMES in J ETHERMON_MANUF.INC, then rebuild the ETHERMON program. However, this also H implies that you have an exceedingly busy Ethernet running far too many O unrecognized manufacturer prefix codes, which you may wish to correct. Use the oK SHOW MANUFACTURERS command to dump the contents of the manufacturer prefix sN table after it has filled up to maximum while SET MESSAGES ON or SET MESSAGES * OFF (not SET MESSAGES DEBUG) is in effect. @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES")  G Note that this message will only appear while SET MESSAGES DEBUG is in eK effect (which can happen by default if ETHERMON_CMD_S.FOR is compiled with   the /D_LINES option).i$ @Index[/D_LINES (FORTRAN qualifier)] @End(Group)c  
 @Begin(Group)N @Begin(ProgramExample)n %ETHERMON-I-MOPMSG, @i<@u[hh:mm:ss aa-bb-cc-dd-ee-ff]> sent MOP @i<@u[prot]> msg, t=@i<@u[xxxx]> ln=@i<@u[nn]> @End(ProgramExample)A The specified node transmitted a DEC MOP (Maintenance Operations t? Protocol) message (using Ethernet formatting) of a significant  A type. @i<@u[prot]> specified whether the message was a Dump/Load B@ Assistance (60-01) or Remote Console (60-02) protocol type, the < "t=@i<@u[xxxx]>' specifies the first word of the message in K hexadecimal (high byte first), and "ln=@i<@u[nn]>" gives the length of the o message in bytes. This  @ message can be suppressed with the SET MESSAGES MOP OFF command. @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)w  
 @Begin(Group)G @Begin(ProgramExample)@ %ETHERMON-W-MSGLEN, specified message buffer length out of range @End(ProgramExample)B A SET FILTER/SIZE command was entered with the MAXIMUM or MINIMUM B option, but the numeric size was outside the range of 46 to 4470. / Re-enter the command with a valid message size.f @End(Group)e  
 @Begin(Group)  @Begin(ProgramExample); %ETHERMON-W-NETACPDAT, insufficient data returned by NETACP. @End(ProgramExample)I A query was sent to the DECnet NETACP process, but the returned data was OF too short to be intelligible. Contact your local DEC software support L center, as this implies a weird fault within DECnet; however, please notify  the author as well.a @Index(DECnet) @Index(NETACP) @End(Group)f  
 @Begin(Group)e @Begin(ProgramExample)K %ETHERMON-I-NEWNODE, new Ethernet sender @i<@u[aa-bb-cc-dd-ee-ff]> detectedh @End(ProgramExample)M The SET MESSAGES NEWNODE ON command has been entered, and a new sending node tH has just been added to the address table. No action is required (except M possibly to enter the SET MESSAGES NEWNODE OFF command if you do not wish to c see these messages). @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)i  
 @Begin(Group)h @Begin(ProgramExample)N %ETHERMON-E-NOASYNTRC, no asynchronous TRACE active to abort - command ignored @End(ProgramExample)= The TRACE/ABORT command was entered when there was no active aB TRACE/PARALLEL or TRACE/REPEAT background command in progress. No B action is required (except possibly to determine why there was no 9 active TRACE command when you expected one to be active).  @End(Group)o  
 @Begin(Group)n @Begin(ProgramExample)2 %ETHERMON-I-NODECNET, can't access DECnet services @End(ProgramExample)I At ETHERMON start-up, a connection to a DECnet network mailbox could not wP be made, preventing ETHERMON from translating DECnet addresses with the help of E NETACP. DECnet may not be running on your system, or you may not haveoI NETMBX (or SETPRV) privilege. If DECnet is supposed to be on your system rG but isn't, contact your system manager to find why it is not currently t running. @Index(DECnet) @Index(NETACP)8 @IndexSecondary(Primary="privileges",Secondary="NETMBX") @End(Group)e  
 @Begin(Group)  @Begin(ProgramExample)V %ETHERMON-W-NOFASTFB, can't activate ETHERMON_FASTSHR.EXE; using unsupported interface @End(ProgramExample)N The "fast" $QIO interface for ETHERMON could not be started. However, you are E using a sufficiently old version of VAX/VMS for the old "plain" $QIO hJ interface to still function. Unless you wish to use the "fast" interface, K no action is required; if you do wish to use the "fast" interface, see the n8 actions described for the %ETHERMON-F-NOFASTSHR message. @End(Group)n  
 @Begin(Group)l @Begin(ProgramExample)J %ETHERMON-F-NOFASTSHR, can't activate ETHERMON_FASTSHR.EXE - PROGRAM ABORT @End(ProgramExample)E The "fast" $QIO interface for ETHERMON could not be started for some oK reason, and, because you are using a version of VAX/VMS later than V5.4-2,  J the old-style $QIO interface could not be used successfully. A VMS system G error message should accompany this message, explaining why the "fast" n! interface could not be activated.B< @IndexSecondary(Primary="VAX/VMS",Secondary="V5.4-3 and up")D The expected VMS error message (and corresponding action) should be  one of the following:t @Begin(Itemize).
 @Begin(Group)n @Begin(ProgramExample)
 -RMS-F-FNF @End(ProgramExample)L The shareable image file ETHERMON_FASTSHR.EXE could not be found, either by N executive-mode logical name translation, or by looking in the directory where L the ETHERMON.EXE file being executed was located. Define the logical name orE move the file to the same directory as the ETHERMON executable image.) @End(Group)T @Hinge  
 @Begin(Group)o @Begin(ProgramExample) -SYSTEM-F-SHRIDMISMAT  -LIB-F-KEYNOTFOU @End(ProgramExample)N The installed shareable image file ETHERMON_FASTSHR.EXE is of an incompatible H patch level for the current version of ETHERMON. Re-compile and re-link K both ETHERMON and ETHERMON_FASTSHR under the current operating system with e7 current source files, then re-install ETHERMON_FASTSHR.G @End(Group)n @Hinge  
 @Begin(Group)O @Begin(ProgramExample) -SYSTEM-F-EXQUOTAe @End(ProgramExample)J You do not have enough BYTLM quota left to create the non-paged pool data K structures needed to support the "fast" interface. This error should never hJ occur (ETHERMON should have reserved enough BYTLM when it saved quota for + spawning subprocesses); if it does, please mI submit a problem report to the author, giving the exact command line you t/ entered (character for character). Also please eD include the version of ETHERMON you were running and the version of  VAX/VMS you were running under.n3 @IndexSecondary(Primary="quotas",Secondary="BYTLM")S @End(Group)P @Hinge  
 @Begin(Group)T @Begin(ProgramExample) -SYSTEM-F-INSFMEMd @End(ProgramExample)K Your system does not have enough non-paged pool left to allocate space for NF the data structures needed by the "fast" interface. Exit ETHERMON and E re-SYSGEN your system (if you get this error, your system is far too EB tight on non-paged pool to consider running ETHERMON in any mode). @End(Group)l @Hinge  
 @Begin(Group)e @Begin(ProgramExample) -SYSTEM-F-LKWSETFULo @End(ProgramExample)D Your process's working set is too small to be able to lock down the A additional memory pages required for the "fast" interface to run uF successfully. In this case, you definitely do not have a large enough L working set for ETHERMON to be able to run adequately. Enlarge your working E set limit and/or quota (or have your system administrator grant your e$ account more quota), then try again.7 @IndexSecondary(Primary="quotas",Secondary="WSDEFAULT")e @End(Group)i  
 @Begin(Group)E @Begin(ProgramExample) -SYSTEM-F-NOPRIV -SYSTEM-F-NOTALLPRIV @End(ProgramExample)K The user has all the privileges necessary to run ETHERMON in the old mode, HH but does not have the CMKRNL (or SETPRV) privilege necessary to use the I "fast" mode interface. Have your system administrator grant your account t the necessary privileges.r8 @IndexSecondary(Primary="privileges",Secondary="CMKRNL") @End(Group)a @Hinge  
 @Begin(Group)L @Begin(ProgramExample) -SYSTEM-F-PROTINSTALLl @End(ProgramExample)E The shareable image file ETHERMON_FASTSHR.EXE was not installed as a rI protected shareable image with the INSTALL utility. Install the image as W" described in section @Ref[CMKRNL]. @Index(INSTALL utility)r @End(Group)S @Hinge  
 @Begin(Group)o @Begin(ProgramExample) -SYSTEM-F-SYSVERDIFY @End(ProgramExample)L The shareable image file ETHERMON_FASTSHR.EXE was compiled and linked under L an incompatible version of VAX/VMS. Re-compile and re-link ETHERMON_FASTSHR 7 under the current operating system, then re-install it.y @End(Group)E @Hinge  
 @Begin(Group)p @Begin(ProgramExample) -SYSTEM-F-VECFULLB @End(ProgramExample)I For some strange reason, your account environment has so many privileged  L images using the kernel-mode user-rundown facility that there are no vector I entries left in the rundown vector table. If this message occurs, please nI submit a problem report to the author, giving the exact command line you u/ entered (character for character). Also please eA include the version of ETHERMON you were running, the version of eF VAX/VMS you were running under, and the names and descriptions of any > privileged layered products that are installed on your system. @End(Group)o
 @End(Itemize)o @End(Group)   
 @Begin(Group)S @Begin(ProgramExample)2 %ETHERMON-E-NOFILE, can't find specified LOAD file @End(ProgramExample)H The file specified on a LOAD command cannot be found. Re-enter the LOAD A command with the correct file specification (watch the defaults).t @End(Group)p  
 @Begin(Group), @Begin(ProgramExample)B %ETHERMON-W-NOGBLSEC, couldn't create address table global section @End(ProgramExample)G During start-up of ETHERMON, an attempt was made to create a temporary rG group global section containing the address table, such that the table MG might be shared with TRACE/ANALYZER subprocesses. However, the section iG creation failed. An accompanying system error message from the $CRMPSC iD system service should explain why the section could not be created. H ETHERMON will function without the section; however, address table data F cannot be shared in real-time with subprocesses unless the section is H created. As of ETHERMON V2.4, creating the global section requires 2009 G contiguous free global pages, and (preferably) the same number of free vN global page-file pages; these pages will be released when ETHERMON is exited. I If the contiguous global pages are available, but the page file space is r@ not, ETHERMON will attempt to create its own paging file (named I SYS$SCRATCH:ETH_ADDRTBL.GBLSEC); this file will be automatically deleted , when ETHERMON exits. @End(Group)   
 @Begin(Group)  @Begin(ProgramExample)? %ETHERMON-I-NOINET, can't find known Internet software to queryr @End(ProgramExample)B Upon receiving a LOAD/INTERNET command, ETHERMON could not find a H recognized type of Internet software to query for name information. The M LOAD/INTERNET command only works with the products DEC VMS/Ultrix Connection uI (UCX, now called TCP/IP Services for VMS), TGV MultiNet, NRC Fusion, and L; CMU TCP/IP; if you have no Internet software, or something i5 other than these, the command probably will not work.v@ @IndexSecondary(Primary="Internet software",Secondary="DEC UCX")T @IndexSecondary(Primary="Internet software",Secondary="DEC TCP/IP Services for VMS")E @IndexSecondary(Primary="Internet software",Secondary="TGV MultiNet")xC @IndexSecondary(Primary="Internet software",Secondary="NRC Fusion")rC @IndexSecondary(Primary="Internet software",Secondary="CMU TCP/IP")e  F Should you have another manufacturer's Internet software and know how N to query it to translate Internet physical addresses to @i[host.network] name @ format, please contact the author so I can add support for your  configuration to ETHERMON. @End(Group)o  
 @Begin(Group)R @Begin(ProgramExample)G %ETHERMON-E-NOINETDST, specified destination hasn't spoken Internet yetA @End(ProgramExample)G A PING/INTERNET command was issued to a node which does not have an IP nE address assigned to it yet. Verify that the correct Ethernet address  G was given on the PING command, or determine why the specified node has l< not yet been seen to speak DoD Internet IP protocol (08-00). @Index(PING)4 @IndexSecondary(Primary="commands",Secondary="PING") @Index(Internet) @End(Group)Y  
 @Begin(Group)  @Begin(ProgramExample)b %ETHERMON-I-NONSTDMOP, @i<@u[aa-bb-cc-dd-ee-ff]> had non-std MOP type @i<@u[xxxx]>, len=@i<@u[nn]> @End(ProgramExample)< A DEC MOP (Maintenance Operations Protocol) message with an G undocumented message type was sent by the specified node. You may wish sB to investigate why the non-standard message packet was sent. This C message will only be displayed with the SET MESSAGES DEBUG command.b @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)   
 @Begin(Group)  @Begin(ProgramExample)O %ETHERMON-I-ONEPORT, implicitly using the one Ethernet interface @i<@u[_ddc0:]>T @End(ProgramExample)M ETHERMON was invoked with a RUN command, or as a foreign command but without LG an Ethernet device name, and it has searched for the expected types of 0I Ethernet devices on the system, and found only one such device, which it <L automatically selected for use. No action is required (unless you wanted to L use some non-standard third-party interface; in that case, you must specify - its device name on the foreign command line).z @End(Group)   
 @Begin(Group)  @Begin(ProgramExample)M %ETHERMON-I-PNGNOTSENT, PING message was not transmitted during wait interval  @End(ProgramExample)E For some reason, during the period that ETHERMON waits for a PING to -@ be acknowledged, the Ethernet device driver did not even finish C sending the PING request. Please notify the author if this message  C appears, and describe what type of Ethernet interface hardware and RK device driver software you were using. Note that this message was reported eC falsely in versions V2.2 to V2.3-1 of ETHERMON when PINGing to the E= Broadcast address; the error has been corrected as of V2.3-2.t @End(Group)   
 @Begin(Group)a @Begin(ProgramExample)H %ETHERMON-I-PORT, enter VMS device name of the Ethernet interface to use @End(ProgramExample)M ETHERMON was invoked with a RUN command, or as a foreign command but without EG an Ethernet device name, and it has searched for the expected types of  E Ethernet devices on the system, and found more than one such device. rJ Following this message will be a list of VMS device names and a prompt to I enter a device name. Enter one of the displayed device names to continue b
 execution. @End(Group)   
 @Begin(Group)a @Begin(ProgramExample)E %ETHERMON-F-PORTASNFAI, error assigning channel to Ethernet interface( @End(ProgramExample)E During ETHERMON initialization, an I/O channel could not be assigned cD to the specified or defaulted Ethernet interface device. Check that D your account is permitted access to the Ethernet device, and verify E that the device name was typed in properly and any logical name used  C translates properly to a valid Ethernet interface device name. The ]G associated VMS error message will help describe why the $ASSIGN system r service failed.d @End(Group)o  
 @Begin(Group)a @Begin(ProgramExample)G %ETHERMON-F-PROTBLOVF, Ethernet protocol table overflow - PROGRAM ABORTs @End(ProgramExample)G The protocol type table did not have enough free space to store all therF different protocol types seen on your Ethernet. Increase the value of M the protocol name table size parameter ICPPRT_MAXNAMES in ETHERMON_PROT.INC,  6 then rebuild the ETHERMON program. However, this also H implies that you have an exceedingly busy Ethernet running far too many I unrecognized protocol types, which you may wish to correct. Use the SHOW eK PROTOCOL_NAMES command to dump the contents of the protocol table after it mL has filled up to maximum while SET MESSAGES ON or SET MESSAGES OFF (not SET  MESSAGES DEBUG) is in effect.H @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES")  G Note that this message will only appear while SET MESSAGES DEBUG is in eK effect (which can happen by default if ETHERMON_CMD_S.FOR is compiled with l the /D_LINES option).r$ @Index[/D_LINES (FORTRAN qualifier)] @End(Group)p  
 @Begin(Group)o @Begin(ProgramExample)] %ETHERMON-I-PROXYARP, @i<@u[aa-bb-cc-dd-ee-ff]> is proxy-ARPing for @i<@u[aa-bb-cc-dd-ee-ff]>I @End(ProgramExample)H A node on the Ethernet was detected sending an Internet ARP message for E another node (not for itself). You may wish to verify that proxy-ARP c6 is supposed to be enabled for the selected node. This @ message can be suppressed with the SET MESSAGES ARP OFF command. @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @Index(ARP)M3 @IndexSecondary(Primary="Internet",Secondary="ARP")I@ @IndexSecondary(Primary="protocol type",Secondary="ARP (08-06)") @End(Group)s  
 @Begin(Group)p @Begin(ProgramExample)M %ETHERMON-W-PRTTBLFUL, protocol table full - new protocol/name pair not addedi @End(ProgramExample)G A SET PROTOCOL_NAME or LOAD command was entered, but there was no room nK in the protocol name table to add another new entry. Increase the value of -M the protocol name table size parameter ICPPRT_MAXNAMES in ETHERMON_PROT.INC, m" then rebuild the ETHERMON program. @End(Group)P  
 @Begin(Group)r @Begin(ProgramExample)B %ETHERMON-W-QIONETACP, error queuing status query to DECnet NETACP @End(ProgramExample)G An attempt to send a query to the DECnet NETACP process to translate a )C DECnet node number was made, but the query could not be queued. An eI accompanying system message will give more details about the error. This l< message can be suppressed with the SET MESSAGES OFF command. @Index(DECnet) @Index(NETACP) @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)   
 @Begin(Group)B @Begin(ProgramExample)P %ETHERMON-E-SATURATED, port counters at limits; do SHOW PORT_ST/ZERO & try again @End(ProgramExample)L A DISPLAY or SUMMARIZE command was entered; however, the Ethernet interface H port counters that were needed to compute some of the display data were L saturated and need to be reset. The command was not processed (allowing the K user to decide whether or not the counters should be reset). If you decide PK that the old counter values do not need to be preserved, you can enter the eL SHOW PORT_STATUS/ZERO command to zero the counters, then re-try the DISPLAY  or SUMMARIZE command.  @Index(SHOW PORT_STATUS)@ @IndexSecondary(Primary="commands",Secondary="SHOW PORT_STATUS") @End(Group)x  
 @Begin(Group)o @Begin(ProgramExample); %ETHERMON-E-STRTANLZ, couldn't start TRACE/ANALYZER commandd @End(ProgramExample)K A TRACE/ANALYZER command was entered; however, for some system reason, the aJ environment for the analyzer subprocess could not be created. The command K was not processed. An accompanying system error message should explain why WL the command could not be processed (usually indicating some system resource  or quota limitation).( @End(Group)a  
 @Begin(Group)E @Begin(ProgramExample)M %ETHERMON-W-TOOMANYADR, too many addresses for QUERY command; command ignoredo @End(ProgramExample)J The QUERY command was issued with a range of addresses that was too large J to practically deal with, so the command was ignored. Use a smaller range L of addresses if you are going to use the QUERY command (less than one whole 3 manufacturer's prefix worth is the absolute limit).d @End(Group)t  
 @Begin(Group)p @Begin(ProgramExample)9 %ETHERMON-E-TOOMANYIND, can't nest indirect command filesC @End(ProgramExample)H An indirect command file was invoked, which in turn attempted to invoke E another file. Only one level of indirection is permitted; remove the d5 indirect file reference from the first indirect file.n @End(Group)y  
 @Begin(Group)n @Begin(ProgramExample)Q %ETHERMON-I-TRACERPT, post-filter: @u<nn> bytes, @u<nn> messages recorded to fileu @End(ProgramExample)F The specified number of messages and bytes of data were recorded in a 4 TRACE command's output file. No action is necessary. @End(Group)p  
 @Begin(Group)p @Begin(ProgramExample)P %ETHERMON-I-TRACERPT2, pre-filter: @u<nn> bytes, @u<nn> messages received on net @End(ProgramExample)F The specified number of messages and bytes of data were received from < the Ethernet during a TRACE command. No action is necessary. @End(Group)p  
 @Begin(Group)e @Begin(ProgramExample)I %ETHERMON-I-TRACERPT3, pre-ETHERMON: @u<nn> messages lost before analysiso @End(ProgramExample)E The specified number of network packets were dropped by the Ethernet TJ interface device driver during a TRACE command, because ETHERMON couldn't K keep up with the data rate. No action is necessary (except possibly to use o2 a more powerful VAX in future network monitoring). @End(Group)   
 @Begin(Group)o @Begin(ProgramExample)M %ETHERMON-I-TRACERPTA, pre-analyzer: @u<nn> messages lost due to mailbox fullr @End(ProgramExample)J The specified number of network packets were dropped by ETHERMON during a L TRACE command, because the analyzer module subprocess couldn't keep up with I the data rate and let its input mailbox overflow. No action is necessary aJ (except possibly to use a more powerful VAX in future network monitoring, 5 and/or to tune the execution of the analyzer module).F @Index(mailbox)x @End(Group)h  
 @Begin(Group)e @Begin(ProgramExample)K %ETHERMON-E-TRCBSY, couldn't start TRACE command; previous TRACE still busyl @End(ProgramExample)C A TRACE command was entered; however, a previous asynchronous TRACEeL command is still running. Abort the running TRACE with TRACE/ABORT, or wait M for it to finish executing. If there is no active TRACE running, please send SK a problem report to the author, and describe your system's VAX/VMS version r and ETHERMON version.O @End(Group)   
 @Begin(Group)i @Begin(ProgramExample)R %ETHERMON-I-UNDDECNOD, node @u<nn>.@u<nn> seen on Ethernet; not in DECnet database @End(ProgramExample)F ETHERMON requested the local DECnet NETACP to translate a DECnet node G number to a node name, but NETACP did not have a corresponding name in lB its database. Check with your system or network manager as to why ? the specified DECnet node is appearing on your Ethernet but is nI not listed in the local system's DECnet node database. This message will HE only be displayed if you have entered the SET MESSAGES DEBUG command.i @Index(DECnet) @Index(NETACP) @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @End(Group)a  
 @Begin(Group)r @Begin(ProgramExample)n %ETHERMON-I-UNKARPOPC, @i<@u[aa-bb-cc-dd-ee-ff]> sent unknown ARP opcode: prot=@i<@u[pp-pp]> opc=@i<@u[pp-pp]> @End(ProgramExample)G An Internet ARP or RARP message was received, but the ar$op field (see x- NIC.DDN.MIL Request For Comments RFC826.TXT) ) @Index(NIC.DDN.MIL)t @Index(RFC826)E for details of ARP message formats) was not one of the values 01-00,  J 02-00, 03-00, 04-00 (the legal values for ARP and RARP), or 05-00, 06-00, & or 07-00 (dynamic RARP). You may wish G to determine if there is a node transmitting erroneous packets on your oI Ethernet; if not, please inform the author of your discoveries so that a oH future version of ETHERMON can properly deal with the extensions to the K ARP protocol. This message can be suppressed with the SET MESSAGES ARP OFF   command. @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @Index(ARP)t @Index(RARP)@ @IndexSecondary(Primary="protocol type",Secondary="ARP (08-06)")A @IndexSecondary(Primary="protocol type",Secondary="RARP (80-35)")e @End(Group)   
 @Begin(Group)r @Begin(ProgramExample)S %ETHERMON-I-UNKETHCHR, unknown Ethernet port characteristic code=@u<xxxx>, @u<xxxx>R @End(ProgramExample)H An undeciphered port characteristics code was received while performing M an IO$_SENSEMODE operation on the interface. This message can only appear if eG you have compiled ETHERMON.FOR with the /D_LINES option on the FORTRAN aC compiler. Check for compatability of your Ethernet interface's I/O (D driver with the standard DEC driver, as documented in the @i<@u[VMS ' I/O User's Reference Manual: Part II]>.E$ @Index[/D_LINES (FORTRAN qualifier)] @End(Group)l  
 @Begin(Group)R @Begin(ProgramExample)L %ETHERMON-I-UNKETHCNT, unknown Ethernet port counter code=@u<xxxx>, @u<xxxx> @End(ProgramExample)C An undeciphered port counter ID code was received while performing  M an IO$_SENSEMODE with IO$M_RD_COUNT operation on the interface. This message oN can only appear if you have compiled ETHERMON.FOR with the /D_LINES option on O the FORTRAN compiler. Check for compatability of your Ethernet interface's I/O AD driver with the standard DEC driver, as documented in the @i<@u[VMS ' I/O User's Reference Manual: Part II]>.n$ @Index[/D_LINES (FORTRAN qualifier)] @End(Group)x  
 @Begin(Group)s @Begin(ProgramExample)v %ETHERMON-I-UNKIPARP, @i<@u[aa-bb-cc-dd-ee-ff]> sent unknown ARP pkt: prot=@i<@u[pp-pp]> Hlen=@i<@u[n]> Plen=@i<@u[n]> @End(ProgramExample)L An Internet ARP or RARP message was received, but the values of the ar$hrd, C ar$hln, and/or ar$pln fields (see NIC.DDN.MIL Request For Comments r RFC:RFC826.TXT)  @Index(NIC.DDN.MIL)  @Index(RFC826)A for details of ARP message formats) were not legal for IP and/or g! Ethernet addresses. You may wish oG to determine if there is a node transmitting erroneous packets on your .I Ethernet; if not, please inform the author of your discoveries so that a rH future version of ETHERMON can properly deal with the extensions to the K ARP protocol. This message can be suppressed with the SET MESSAGES ARP OFF e command. @Index(SET MESSAGES)< @IndexSecondary(Primary="commands",Secondary="SET MESSAGES") @Index(ARP)  @Index(RARP)@ @IndexSecondary(Primary="protocol type",Secondary="ARP (08-06)")A @IndexSecondary(Primary="protocol type",Secondary="RARP (80-35)")t @End(Group)e   @End(Enumerate)a) @Section(System Messages Frequently Seen)d @Begin(Enumerate)h
 @Begin(Group)  @Begin(ProgramExample)L %SMG-E-KEYDEFPRO, key definition is protected - cannot be changed or deleted @End(ProgramExample)L You attempted to re-define a key (using the DEFINE/KEY command) or delete a G key definition (using DELETE/KEY) for a key with a permanently defined eJ function. The attempt has failed, and the key definition has not changed. . Use a different key for your local definition. @Index(DEFINE/KEY): @IndexSecondary(Primary="commands",Secondary="DEFINE/KEY") @Index(DELETE/KEY): @IndexSecondary(Primary="commands",Secondary="DELETE/KEY") @End(Group)E  
 @Begin(Group)  @Begin(ProgramExample)! %SYSTEM-F-BADPARAM, bad parameterf @End(ProgramExample)+ This error is caused by one of two reasons:  @Begin(Enumerate)CF There is already a promiscuous user on the Ethernet interface you are E attempting to use. Try another interface, or get rid of the existing lB promiscuous user (it could be another invocation of this program).   @Label[V4.x]H You are attempting to run under Version V4.x of VAX/VMS, which does not L recognize IEEE 802.3 mode operation of the Ethernet interface. ETHERMON can I be retrofitted to run in Ethernet mode; however, all IEEE 802.3 extended uG messages seen on the cable will be discarded (data that would appear asdJ Ethernet protocol type AA-AA). To make the change, uncomment all lines in  ETHERMON.FOR that begin K with the comment string "C4.x", and recompile and relink ETHERMON. You may CG also need to comment out the lines ending in "! V5.x". Note that these  I edits should not need to be done; ETHERMON should work under either V4.x TL or V5,x after re-compiling and re-linking. Note also that, if you are using H the "fast" $QIO interface, you should be able to successfully interpret L IEEE 802.3 messages even if you are using VAX/VMS V4.x. This configuration, 2 although theoretically workable, is not supported.3 @IndexSecondary(Primary="VAX/VMS",Secondary="V4.x")e @Index(IEEE 802.3) @End(Enumerate)  @End(Group)o  
 @Begin(Group)E @Begin(ProgramExample), %SYSTEM-F-EXBYTLM, exceeded byte count quota @End(ProgramExample)J Under some installations of VAX/VMS with some homebrew and/or third-party O software installed, sometimes the SPAWN command will fail with this error. You tN will also find on these systems that VAX DEBUG cannot run in subprocess mode. @ The reason for this is improper values of the SYSGEN parameters I controlling default mailbox parameters (DEFMBXBUFQUO and MAXBUF); MAXBUF cD should always be larger than DEFMBXBUFQUO, and the user BYTLM quota N must be at least 10000 bytes larger than DEFMBXBUFQUO for ETHERMON to operate L (assuming the DEC default value for PQL_MBYTLM; preferably, your user BYTLM % quota should be considerably larger). 
 @Index(SPAWN) 5 @IndexSecondary(Primary="commands",Secondary="SPAWN")o @Index(SYSGEN parameters)s4 @IndexSecondary(Primary="quotas","Secondary="BYTLM") @Index(mailbox)l @End(Group)l  
 @Begin(Group)  @Begin(ProgramExample)" %RMS-F-EXT, ACP file extend failed* -SYSTEM-F-EXDISKQUOTA, disk quota exceeded @End(ProgramExample)H While writing an output disk file (a SHOW, SUMMARIZE, or TRACE command, H typically), your process exceeded your allowed disk quota. Free up some  disk space and try again. 3 @IndexSecondary(Primary="quotas","Secondary="disk")h @End(Group)n  
 @Begin(Group)e @Begin(ProgramExample)! %SYSTEM-F-EXQUOTA, exceeded quota  @End(ProgramExample)K Typically, this will occur when issuing a SPAWN or TRACE/ANALYZER command, qC because the user account will not have enough BYTLM or PRCLM quota fK (although other quotas may be exceeded) left to create the subprocess. Get lH your quotas raised by your system administrator or reduce the number of $ active subprocesses you are running.
 @Index(SPAWN) 5 @IndexSecondary(Primary="commands",Secondary="SPAWN")d4 @IndexSecondary(Primary="quotas","Secondary="BYTLM")4 @IndexSecondary(Primary="quotas","Secondary="PRCLM") @End(Group)e  
 @Begin(Group)q @Begin(ProgramExample), %SYSTEM-F-NOSUCHNODE, remote node is unknown @End(ProgramExample)E A symbolic node address was specified on an ADD FILTER or SET FILTER  I command, but the specified DECnet node name or Internet IP address could EC not be found in the address name table. Either specify the address rG correctly, or add the address specification to the address table. This lI message may appear when using the ADD or SET FILTER commands immediately eE after starting ETHERMON, before ETHERMON has seen the node speak the aI corresponding protocol; in that case, just wait a little while until the dI remote node speaks the appropriate protocol (in batch jobs, use the WAIT e< command to stall a few seconds; an example is given on page  @PageRef[WAITdemo]). @Index(WAIT)4 @IndexSecondary(Primary="commands",Secondary="WAIT") @End(Group)   
 @Begin(Group)t @Begin(ProgramExample)F %HELP-E-OPENIN, error opening @i<@u{disk:[dir]}>ETHERMON.HLB; as input -RMS-E-FNF, file not found @End(ProgramExample)H Upon issuing the HELP command, the help library file ETHERMON.HLB could B not be found. This is generally due to placing the .HLB file in a F different directory from the ETHERMON.EXE file; all ETHERMON run-time F files expect to be in the same directory (location of source files is @ irrelevant, except that they all must be in the current default C directory at build time). Either move the help library file to the AI directory containing the .EXE file, or edit appropriately the subroutine o3 HELP in the file ETHERMON.FOR and rebuild ETHERMON.l @Index(help library)2 @IndexSecondary(Primary="HELP",Secondary="errors") @End(Group)  @End(Enumerate)s @Appendix(Known Ethernet Data)E There are a great deal of numbers associated with the Ethernet. Some t8 of these numbers are in the DEC/Xerox/Intel and/or IEEE D specifications. Some of them were assigned by various authoritative < bodies. Some of them were just claimed by squatter's rights A (thankfully very few of these). The information used to pre-load eJ ETHERMON's protocol type and manufacturer prefix tables, and, in general, ? analyze the data packets (both in ETHERMON and the unsupported  # utilities), came from many sources:S @Begin(Itemize) G @i<@u[VMS I/O User's Reference Manual: Part II]>, Version 5.0, Digital aO Equipment Corporation, April 1988, order number AA-LA85A-TE, in the chapter on D1 Ethernet interfaces (previous editions also used)f  A @i<@u[VMS Network Control Program Manual]>, Version 5.0, Digital xM Equipment Corporation, April 1988, order number AA-LA50A-TE, in the sections xK on the SHOW LINE command and on line counters (previous editions also used)i  L @i<@u[VMS System Services Reference Manual: Part II]>, Version 5.0, Digital O Equipment Corporation, April 1988, order number AA-LA69A-TE (previous editions w
 also used)  K @i<@u[DECnet Digital Network Architecture Phase IV: Maintenance Operations sA Functional Specification]>, MOP Version 3.0.0, Digital Equipment x5 Corporation, December 1983, order number AA-X436A-TK.n  A DoD Internet Requests For Comments (RFC's), as obtained from the "H Network Information Center (the NIC, with Internet address NIC.DDN.MIL)  via anonymous FTP: @Index(NIC.DDN.MIL)p @Begin(Enumerate)m> RFC 768, @u[User Datagram Protocol], Postel, J.B., August 1980 @Index(RFC768)  < RFC 791, @u[Internet Protocol], Postel, J.B., September 1981 @Index(RFC791)  L RFC 792, @u[Internet Control Message Protocol], Postel, J.B., September 1981 @Index(RFC792)  H RFC 793, @u[Transmission Control Protocol], Postel, J.B., September 1981 @Index(RFC793)  @ RFC 826, @u[Ethernet Address Resolution Protocol: Or converting G network protocol addresses to 48.bit Ethernet address for transmission e3 on Ethernet hardware], Plummer, D.C., November 1982q @Index(RFC826)  H RFC 1057, @u[RPC: Remote Procedure Call Protocol specification: Version % 2], Sun Microsystems, Inc., June 1988i @Index(RFC1057)   D RFC 1058, @u[Routing Information Protocol], Hedrick, C.L., June 1988 @Index(RFC1058)S  N RFC 1060, @u[Assigned Numbers], Reynolds, J.K.; Postel, J.B., March 1990 (the P now-obsoleted RFC 1010, May 1987, was also used in earlier versions of ETHERMON) @Index(RFC1060)m  C RFC 1094, @u[NFS: Network File System Protocol specification], Sun S Microsystems, Inc., March 1989 @Index(RFC1094)A  L RFC 1157, @u[Simple Network Management Protocol (SNMP)], Case, J.D.; Fedor, * M.; Schoffstall, M.L.; Davin, C., May 1990 @Index(RFC1157)  @End(Enumerate)e  A @i<@u[Inside AppleTalk]>, 2nd ed., Sidhu, G., Andrews, R.F., and   Oppenheimer, A.B., 1990.  B other obscure vendor documents whose titles have been lost in the 
 mists of timeo  M sheer trial and error by many parties ("Ah hah! Another unknown manufacturer nG prefix... but it speaks IP. What happens if I Telnet to it? Ahhh... an S: operating system signon message, so now I know what it is I {@i<@b[maybe...]>}.") Thanks to all those users in the field who told me RE about new values they spotted, so I could add them to this program's m knowledge base.L
 @End(Itemize)s  D As none of these sources is either complete or infallible, the data E known by ETHERMON is necessarily incomplete and prone to errors. All .B the information the author was able to obtain is embedded in this E program (with the exception of non-SNAP IEEE 802.3 data; that is not r? yet properly supported by ETHERMON). If you find any errors or rF determine any new manufacturer prefixes or protocol types, please let E the author know, so that the information can be shared with all in a w> new release of ETHERMON. The author's address (electronic and F real-world) is given in section @Ref[author] on page @PageRef[author].   @Section(Manufacturer Prefixes)mD These are the manufacturer prefixes currently known to ETHERMON, as E displayed by the SHOW MANUFACTURERS/ALL command. Note that this only HG shows the physical prefix assignments. As far as the author knows, the lF corresponding multicast address blocks (same prefix except the LSB of G the first byte is set) are also assigned to the same party. Generally, eF the name displayed is of the Ethernet @i<@u[interface]> manufacturer, : which is not necessarily the same as the whole computer's E manufacturer; in cases where two names are displayed, separated by a dE slash "/", this generally implies that either two manufacturers were rB merged on the corporate level, or that the second manufacturer is E (apparently) the exclusive user of the first manufacturer's Ethernet -A boards in the specified address block. None of this, however, is t
 confirmed. @Index(manufacturer prefix)b   @Begin(OutputExample)oB 00-00-0C Cisco[Cisco]                 00-DD-07 Ungermann-Bass[U-B]B 00-00-0F NeXT[NeXT]                   00-DD-08 Ungermann-Bass[U-B]B 00-00-10 Sytek[Sytek]                 00-DD-09 Ungermann-Bass[U-B]B 00-00-18 Multigate[Multigat]          00-DD-0A Ungermann-Bass[U-B]B 00-00-1B Novell[Novell]               00-DD-0B Ungermann-Bass[U-B]B 00-00-1D Cabletron[Cabltron]          00-DD-0C Ungermann-Bass[U-B]B 00-00-20 Data Industrier AB[DIAB]     00-DD-0D Ungermann-Bass[U-B]B 00-00-22 Visual Technology[VisTec]    00-DD-0E Ungermann-Bass[U-B]B 00-00-2A TRW[TRW]                     00-DD-0F Ungermann-Bass[U-B]@ 00-00-3D AT&T[AT&T]                   02-04-06 BBN internal[BBN]G 00-00-44 Castelle[Castelle]           02-07-01 MICOM/InterLAN[InterLAN] L 00-00-55 AT&T[AT&T]                   02-60-86 Satelcom MegaPac (UK)[SatelcoB 00-00-5A S & Koch[S&K]                02-60-8C 3Com (IBM PC)[3Com]7 00-00-5D RGE[RGE]                     02-CF-1F CMC[CMC]nB 00-00-5E I-net Asnd.Num.Authority[IAN 08-00-02 3Com/Bridge[Bridge]K 00-00-62 Honeywell[Honeywel]          08-00-03 Adv. Computer Communic.[ACC]oL 00-00-65 Network General[N-G]         08-00-05 Symbolics LISP machine[SymbolD 00-00-6B MIPS[MIPS]                   08-00-07 Apple Computer[Apple]7 00-00-77 MIPS[MIPS]                   08-00-08 BBN[BBN]iC 00-00-7A Ardent[Ardent]               08-00-09 Hewlett-Packard[H-P]iE 00-00-81 Synoptics[Synoptic]          08-00-0A Nestar Systems[Nestar]b= 00-00-86 Gateway Communications[Gatew 08-00-0B Unisys[Unisys]r7 00-00-89 Cayman Systems[Cayman]       08-00-0D ICL[ICL]o7 00-00-8E Solburne (Sun clone)[Solburn 08-00-0E NCR[NCR] 9 00-00-93 Proteon 802.3/802.4[Proteon] 08-00-10 AT&T[AT&T]dE 00-00-94 Asante (Macintosh)[Asante]   08-00-11 Tektronix, Inc.[Tektr]t? 00-00-9F Ameristar Technology[Amersta 08-00-14 Excelan[Excelan]aH 00-00-A0 Sanyo Electronics[Sanyo]     08-00-17 Network System Corp.[NSC]? 00-00-A2 Wellfleet[Wellflt]           08-00-1A Data General[DG]r? 00-00-A3 Network Appl. Technology[N-A 08-00-1B Data General[DG]d= 00-00-A4 Acorn[Acorn]                 08-00-1E Apollo[Apollo]e; 00-00-A6 Network General[N-G]         08-00-1F Sharp[Sharp]ND 00-00-A7 NCD[NCD]                     08-00-20 Sun Microsystems[Sun]7 00-00-A9 Network System Corp.[N-S]    08-00-22 NBI[NBI]gI 00-00-AA Xerox[Xerox]                 08-00-23 Matsushita Denso[Matsushi]n7 00-00-AB Logic Modeling Systems[LMS]  08-00-25 CDC[CDC]E@ 00-00-B0 RAD Network Devices Ltd.[RND 08-00-26 Norsk Data[Norsk]L 00-00-B3 CIMLinc[CIMLinc]             08-00-27 PCS Computer System GmbH[PCS]D 00-00-B5 Vista[Vista]                 08-00-28 Texas Instruments[TI]7 00-00-B7 Dove[Dove]                   08-00-2B DEC[DEC] A 00-00-BB Tri-Data Systems, Inc.[TriDa 08-00-2E Metaphor[Metaphor]yD 00-00-BC Allen-Bradley[A-B]           08-00-2F Prime Computer[Prime]C 00-00-C0 Western Digital[W-D]         08-00-36 Intergraph[Intrgrph]uE 00-00-C3 Harris[Harris]               08-00-37 Fujitsu-Xerox[Fujitsu]o9 00-00-C6 Hewlett-Packard INO(Eon)[HP  08-00-38 Bull[Bull]mE 00-00-C8 Altos[Altos]                 08-00-39 Spider Systems[Spider]d? 00-00-C9 Emulex (term.servers)[Emulex 08-00-3E Motorola ?[Mot?]EL 00-00-D1 Adaptec Inc. ("Nodem")[Adapt 08-00-41 DCA Digital Comm. Assoc.[DCA]E 00-00-D3 Wang[Wang]                   08-00-45 ???? (Xylogics?)[????]e9 00-00-D7 Dartmouth College[Dartmth]   08-00-46 Sony[Sony]BB 00-00-D8 3Com/Novell ?? PS/2[? PS/2]  08-00-47 Sequential[Sequent]A 00-00-DD Gould[Gould]                 08-00-49 Univation[Univatn]d= 00-00-DE Unigraph[Unigraph]           08-00-4C Encore[Encore]n9 00-00-E2 Acer Counterpoint[Acer C]    08-00-4E BICC[BICC]gB 00-00-E8 Acoton Technology Corp.[Acot 08-00-51 Experdata[Experdat]L 00-00-EF Alantec[Alantec]             08-00-56 Stanford University[Stanford]I 00-00-F0 Samsung[Samsung]             08-00-58 ??? (DECsystem-20)[?DEC20] 7 00-00-FD High Level Hardware[HLH]     08-00-5A IBM[IBM] B 00-01-02 BBN internal[BBN]            08-00-67 Comdesign[Comdesgn]; 00-01-1B Network Peripherals Inc.[NPI 08-00-68 Ridge[Ridge]rJ 00-01-68 Wandel & Goltermann[W&G]     08-00-69 Silicon Graphics/Iris[Iris]9 00-01-C8 Thomas Conrad Corp[ThoConrd] 08-00-6A AT&T[AT&T]nJ 00-17-00 Kabel[Kabel]                 08-00-6E Excelan/Concurrent[Cncrrnt]C 00-40-27 Sigma Network Systems[Sigma] 08-00-70 Mitsubishi[Mitsubis] ; 00-40-C8 Milan Technology Corp[Milan] 08-00-74 Casio[Casio]yL 00-60-8C 3Com (IBM PC)[3Com]          08-00-75 Danish Data ElektronikAS[DDE]@ 00-80-00 IEEE[IEEE]                   08-00-77 Retix Inc.[Retix]H 00-80-10 Commodore[Commodor]          08-00-7C Vitalink bridge[Vitalink]9 00-80-19 Dayna Etherprint[Dayna]      08-00-80 XIOS[XIOS]-L 00-80-2D Xylogics, Inc.[Xylogic]      08-00-81 Cross Field Electronics[CrossB 00-80-34 SMT-Goupil[SMT-G]            08-00-83 Seiko Denshi[Seiko]@ 00-80-52 TE Concepts[TE]              08-00-86 Imagen/QMS[I/QMS]= 00-80-87 Okidata[Okidata]             08-00-87 Xyplex[Xyplex]NA 00-80-8C Frontier Software Dvlpmt[Fro 08-00-89 Kinetics[Kinetics]e? 00-80-A1 Microtest[Microtst]          08-00-8B Pyramid[Pyramid] A 00-80-A3 Lantronix[Lantrnx]           08-00-8D XYVision[XYVision]o? 00-80-A9 Clearpoint[Clearpnt]         08-00-8E Jupiter[Jupiter]i@ 00-80-B2 Network Equipment Tech.[NET] 08-00-90 Retix Inc.[Retix]7 00-80-C7 Xircom[Xircom]               10-00-5A IBM[IBM] = 00-80-D3 Shiva[Shiva]                 48-44-53 HDS ??[HDS ??]T7 00-80-D6 NuvoLinkSC[NuvoLink]         80-00-07 Mac[Mac]"7 00-AA-00 Intel[Intel]                 AA-00-00 DEC[DEC]r7 00-DD-00 Ungermann-Bass[U-B]          AA-00-01 DEC[DEC]x7 00-DD-01 Ungermann-Bass[U-B]          AA-00-02 DEC[DEC]"7 00-DD-02 Ungermann-Bass[U-B]          AA-00-03 DEC[DEC]sE 00-DD-03 Ungermann-Bass[U-B]          AA-00-04 DEC networking[DECnet]rJ 00-DD-04 Ungermann-Bass[U-B]          CE-00-00 Ethernet spec (global)[gbl]J 00-DD-05 Ungermann-Bass[U-B]          FE-FF-FF Ethernet spec (global)[gbl] 00-DD-06 Ungermann-Bass[U-B]2 Total of 177 manufacturers defined, 177 displayed. @End(OutputExample)f   @Section(Multicast Addresses) C These are the multicast address currently known to and "hardwired"  F into ETHERMON. There are two types of multicast addresses: those that C have a single fixed address (truly hardwired), and those which are rB assigned a range of addresses where the specific address not only B means multicast but to a specific subgroup within the total group D covered by the set of multicast addresses. The latter set, in a few D cases, can be recognized and identified by ETHERMON as belonging to E the specific subgroup, sometimes even naming the subgroup (ex: local r% area VAXcluster group ID multicasts).( @Index(address)e @Index(multicast address)m  " The fixed multicast addresses are: @Begin(OutputExample)4)   01-80-C2-00-00-00 bridge spanning tree E   01-DD-00-68-DE-00 U-B:??? #1 h   01-DD-00-A1-BC-00 U-B:??? #2 e   01-DD-00-FF-FF-FF U-B:??? #3 o+   01-DD-01-00-00-00 U-B:spanning tree hellog(   09-00-02-04-00-01 Bridge:printer msgs 2   09-00-02-04-00-02 Bridge:All Bridges (DBD/DSTD) /   09-00-07-FF-FF-FF Apple:Appletalk ARP brdcst     09-00-09-00-00-01 H-P:Probe    09-00-09-00-00-04 H-P:DTC "   09-00-1E-00-00-00 Apollo:DOMAIN    09-00-2B-00-00-00 DEC:MUMPS? e!   09-00-2B-00-00-01 DEC:DSM/DTP? t,   09-00-2B-00-00-03 DEC:LAN Traffic Monitor -   09-00-2B-00-00-04 DEC:MAP End-System Hello  3   09-00-2B-00-00-05 DEC:MAP Intermediate-Sys Hello  +   09-00-2B-00-00-06 DEC:CSMA/CD Encryption u0   09-00-2B-00-00-07 DEC:NetBIOS Emulator (PCSG) $   09-00-2B-00-00-0F DEC:LAT (LANCE) $   09-00-2B-01-00-00 DEC:Bridge Mgmt %   09-00-2B-01-00-01 DEC:Bridge hello p&   09-00-2B-02-00-00 DEC:Lvl 2 Routers ,   09-00-2B-02-01-00 DEC:DNA Name Svc Advert -   09-00-2B-02-01-01 DEC:DNA Name Svc Solicit B*   09-00-2B-02-01-02 DEC:DNA Time Service? 0   09-00-2B-04-00-00 DEC:LA Sys Transport (LAST) )   09-00-2B-23-00-00 DEC:Argonaut Console o/   09-00-77-00-00-01 Retix:bridge spanning tree o+   09-00-7C-01-00-01 Vitalink:DLS Multicast  1   09-00-7C-01-00-02 Vitalink:DLS Hello Multicast V4   09-00-7C-01-00-03 Vitalink:DLS Inlink Hello Multi 3   09-00-7C-01-00-04 Vitalink:DLS/Non-DLS Multicast  )   09-00-7C-02-00-05 Vitalink:diagnostics M,   09-00-7C-04-00-01 Vitalink:bridge logging &   09-00-7C-05-00-01 Vitalink:gateway? 0   09-00-7C-05-00-02 Vitalink:Network Validation *   09-00-87-00-FF-FF Xyplex:Load Assistance-   AB-00-00-01-00-00 DEC:Dump/Load Assistance M'   AB-00-00-02-00-00 DEC:Remote Console u(   AB-00-00-03-00-00 DEC:Lvl 1,2 Routers %   AB-00-00-04-00-00 DEC:All Endnodes S"   AB-00-03-00-00-00 DEC:LAT (old) ,   CF-00-00-00-00-00 gbl:Loopback Assistance "   FF-FF-FF-FF-FF-FF gbl:Broadcast 6 Total of 44 addresses defined, 0 active, 44 displayed. @End(OutputExample)e    The variable address blocks are: @Begin(Enumerate)dC the DEC Local Area VAXcluster group ID multicast addresses, of the SE form AB-00-04-01-@i<xx-yy>, where the hexadecimal number @i<yyxx> is l' the group ID number plus 256 (decimal).e @Index(LAVC) @Index(VAXcluster)  E the AppleTalk router zone broadcast addresses 09-00-07-@i<aa-bb-cc>, gI where @i<aa-bb-cc> is a dynamically negotiated-for code for a particular ) AppleTalk zone.  @Index(AppleTalk)u @End(Enumerate)A   @Section(Protocol Types)? These are the protocol types (IEEE 802.3 SNAP subprotocols and  B plain-vanilla Ethernet protocols) currently known to ETHERMON, as E displayed by the SHOW PROTOCOL_NAMES/ALL command. In cases where the  = protocol type is assigned to a particular manufacturer, that  ? manufacturer's "short name" (the one in square brackets in the eE manufacturer prefix table) is prepended to the protocol name (if the qE name is known). Some protocols are assigned to manufacturers but the rD use thereof is unknown; these have "???" as their name, or only the  manufacturer's name is given.s @Index(protocol type)D   @Begin(OutputExample) 0  02-00 XEROX: PUP                  80-66 U.Mass.>  02-01 XEROX: PUP Addr. Trans      80-67 Veeco Integrated Auto9  04-00 Nixford                     80-68 General Dynamicss-  06-00 XEROX: NS IDP               80-69 AT&Te1  08-00 Internet IP (DoD)           80-6A Autophono2  08-01 Internet IP (X.75)          80-6C ComDesign5  08-02 Internet IP (NBS)           80-6D Compugraphic :  08-03 Internet IP (ECMA)          80-6E Landmark Graphics:  08-04 Chaosnet                    80-6F Landmark Graphics:  08-05 X.25 Level 3                80-70 Landmark Graphics:  08-06 Internet ARP                80-71 Landmark Graphics:  08-07 XNS Compatibility           80-72 Landmark Graphics:  08-1C Symbolics: private          80-73 Landmark Graphics:  08-88 Xyplex: terminal net        80-74 Landmark Graphics:  08-89 Xyplex: ???                 80-75 Landmark Graphics:  08-8A Xyplex: ???                 80-76 Landmark Graphics:  09-00 U-B: Net Debug              80-77 Landmark Graphics.  0A-00 XEROX: 802.3 PUP            80-7A Matra>  0A-01 XEROX: 802.3 PUP AdrTrans   80-7B Danak Data Elektronik>  0B-AD Banyan Systems              80-7C U.M.:Merit Internodal1  10-00 Berkeley: trailer           80-7D Vitalinkr1  10-01 IP trailer 1 blk            80-7E Vitalink 1  10-02 IP trailer 2 blks           80-7F Vitalinki?  10-03 IP trailer 3 blks           80-80 Vitalink: TransLAN IIIn?  10-04 IP trailer 4 blks           80-81 Counterpoint Computersr?  10-05 IP trailer 5 blks           80-82 Counterpoint Computersp?  10-06 IP trailer 6 blks           80-83 Counterpoint Computerso2  10-07 IP trailer 7 blks           80-9B AppleTalk2  10-08 IP trailer 8 blks          i80-9B AppleTalk3  10-09 IP trailer 9 blks           80-9C Databilityv3  10-0A IP trailer 10 blks          80-9D Databilityr3  10-0B IP trailer 11 blks          80-9E Databilitym?  10-0C IP trailer 12 blks          80-9F Spider Sys.LAN Monitore0  10-0D IP trailer 13 blks          80-A3 Nixdorf<  10-0E IP trailer 14 blks          80-A4 Siemens Gammasonics<  10-0F IP trailer 15 blks          80-A5 Siemens Gammasonics<  16-00 VALID systems               80-A6 Siemens Gammasonics<  3C-00 3Com:NBP VC datagram        80-A7 Siemens Gammasonics<  3C-01 3Com:NBP sysctl datagram    80-A8 Siemens Gammasonics<  3C-02 3Com:NBP connect req        80-A9 Siemens Gammasonics<  3C-03 3Com:NBP connect resp       80-AA Siemens Gammasonics<  3C-04 3Com:NBP connect complete   80-AB Siemens Gammasonics<  3C-05 3Com:NBP close req          80-AC Siemens Gammasonics<  3C-06 3Com:NBP close resp         80-AD Siemens Gammasonics<  3C-07 3Com:NBP datagram           80-AE Siemens Gammasonics<  3C-08 3Com:NBP datagram brdcst    80-AF Siemens Gammasonics<  3C-09 3Com:NBP claim NetBIOS name 80-B0 Siemens Gammasonics<  3C-0A 3Com:NBP delete NetBIOS nam 80-B1 Siemens Gammasonics<  3C-0B 3Com:NBP rem sts req        80-B2 Siemens Gammasonics<  3C-0C 3Com:NBP rem sts resp       80-B3 Siemens Gammasonics1  3C-0D 3Com:NBP reset              80-C0 DCA: ???a;  42-42 PCS Basic Block             80-C1 DCA: Data Exchangep1  52-08 BBN: SIMnet                 80-C2 DCA: ???t1  60-00 DEC: Experimental           80-C3 DCA: ??? 7  60-01 DEC: MOP Dump/Load          80-C6 Pacer Software91 i60-01 DEC: MOP Dump/Load          80-C7 ApplitekM3 i60-02 DEC: MOP Remote Console     80-C8 Intergraphx3  60-02 DEC: MOP Remote Console     80-C9 Intergraph]3  60-03 DEC: DECnet Phase 4         80-CA Intergraph 3  60-04 DEC: LAT                    80-CB Intergraphe3  60-05 DEC: Diagnostics            80-CC Intergraph /  60-06 DEC: Customer/VAXELN        80-CD Harris,/  60-07 DEC: LAVC                   80-CE Harris ;  60-08 DEC: AMBER                  80-CF Taylor Instrumentsn;  60-09 DEC: MUMPS                  80-D0 Taylor InstrumentsC;  60-10 3Com: ???                   80-D1 Taylor Instruments,;  60-11 3Com: ???                   80-D2 Taylor Instrumentsu8  60-12 3Com: ???                   80-D3 Rosemount Corp.8  60-13 3Com: ???                   80-D4 Rosemount Corp.9  60-14 3Com: ???                   80-D5 IBM: SNA Service :  70-00 U-B: NIU Boot               80-DD Varian Associates2  70-01 U-B: Network Management     80-DE I.S. TRFS=  70-02 U-B: NIU Diagnostic         80-DF Integrated Solutionsd6  70-03 Interlan: ???               80-E0 Allen Bradley6  70-05 U-B: Bridge                 80-E1 Allen Bradley6  70-06 U-B: Network Management     80-E2 Allen Bradley6  70-20 LRT: ???                    80-E3 Allen Bradley3  70-21 LRT: ???                    80-E4 Databilityr3  70-22 LRT: ???                    80-E5 Databilityw3  70-23 LRT: ???                    80-E6 Databilityp3  70-24 LRT: ???                    80-E7 Databilitym3  70-25 LRT: ???                    80-E8 Databilityy3  70-26 LRT: ???                    80-E9 Databilityo3  70-27 LRT: ???                    80-EA Datability 3  70-28 LRT: ???                    80-EB DatabilityI3  70-29 LRT: ???                    80-EC Databilityt3  70-30 Proteon: ???                80-ED Databilitys3  70-34 Cabletron                   80-EE Databilityo3  80-03 Cronus VLN                  80-EF Databilityt3  80-04 Cronus Direct               80-F0 Datability2;  80-05 HP Probe                    80-F2 Retix: Router MgmtI6  80-06 Nestar                      80-F3 ARP AppleTalk6  80-08 AT&T                       i80-F3 ARP AppleTalk=  80-10 Excelan                     80-F4 Kinetics: Appletalk? =  80-13 SilGraph: diag              80-F5 Kinetics: Appletalk?l4  80-14 SilGraph: net games         80-F7 Apollo: ???A  80-15 SilGraph: reserved          80-FF Wellfleet CommunicationsuA  80-16 SilGraph: XNS NameSvc       81-00 Wellfleet CommunicationseA  80-19 Apollo: remote file sys     81-01 Wellfleet CommunicationshA  80-2E Tymeshare: ??               81-02 Wellfleet CommunicationssA  80-2F Tigan Inc.: ?               81-03 Wellfleet Communicationsh;  80-35 Reverse ARP                 81-07 Symbolics: privatee;  80-36 Aeonic Systems: ??          81-08 Symbolics: privatec;  80-38 DEC: LAN Bridge             81-09 Symbolics: privatew:  80-39 DEC: DSM/DTP                81-2B Talaris TLAP data>  80-3A DEC: Argonaut console       81-30 Waterloo Microsystems>  80-3B DEC: VAXeln (hah!)          81-31 VG Laboratory Systems@  80-3C DEC: DNA Name Service       81-37 Novell: old NetWare IPX<  80-3D DEC: Encryption             81-38 Novell: NetWare IPX1  80-3E DEC: DNA Time Service       81-39 KTI: ???t1  80-3F DEC: LAN Traffic Monitor    81-3A KTI: ???n1  80-40 DEC: NetBios emulator       81-3B KTI: ??? 1  80-41 DEC: LA Sys Transport       81-3C KTI: ???T1  80-42 DEC: -unassigned-           81-3D KTI: ???0-  80-44 Planning Research Corp.     81-4C SNMPg4  80-46 AT&T                        81-4F TE Concepts<  80-47 AT&T                        85-2B Talaris TLAP status1  80-49 Expert Data                 90-00 Loopbacke9  80-5B Stanford V Exper            90-01 Bridge: XNS mgmt-;  80-5C Stanford V Product          90-02 Bridge: TCP/IP sys <  80-5D Evans & Sutherland          90-03 Bridge: loop detect7  80-60 Little Machines             AF-AF Logicraft: ???r<  80-62 Counterpoint Computers      FF-00 BBN VITAL-LANBridge  80-65 U.Mass.. Total of 247 protocols defined, 247 displayed. @End(OutputExample)e @Appendix(Release Notes) @Section(V2.4-1)4 Changes, enhancements, and bug-fixes for V2.4-1 are: @Begin(Enumerate) & fix compile-time subscript range error= in SET_MANUFNAM (appeared only when compiling /CHECK=BOUNDS).I  D fix zero-length string error for filespec in LOAD and SAVE commands : (appeared at run-time only after compiling /CHECK=BOUNDS).  D fix typo in specifying control-C trap mask in ENABLE_CONTROL_C_TRAP I subroutine; this prevented control-C's from being trapped as out-of-band l2 characters but instead specified other characters.  G fix SET MESSAGE xxx ON command so that turn-ons would actually happen. P. formerly, only SET MESSAGE xxx OFF would work.  J fix global section creation logic for cases when an explicit mapping file J is needed (because insufficient global pagefile space is available). also I make sure that explicit mapping file is deleted when ETHERMON terminates.3  B have control-C automatically abort using an indirect command file.  L search for an initialization file at ETHERMON start-up time; if one exists, L open it as an indirect command file and execute its commands before reading  commands from standard input.W  G add more entries to known manufacturer prefix and protocol type tables.p  E add information to user's manual regarding implementation of filters.  @End(Enumerate)E @Section(V2.4)2 Changes, enhancements, and bug-fixes for V2.4 are: @Begin(Enumerate)7H Add the "fast" $QIO interface that corrects for the VMS V5.4-3 (and up) F Ethernet driver change. Include a performance check routine in FASTSHRJ and FASTCALL to get kernel-based data without forcing main ETHERMON image  to be system version dependent.0  L Add control-C trapping to command parser and commands that could be aborted J prematurely (DISPLAY, SHOW ADDRESSES, SHOW MANUFACTURERS, SHOW PROTOCOLS, @ SUMMARIZE, TRACE). Make control-C logic modular and then disableG control-C traps in SPAWN command (so subprocess can field them itself).,  F Add logic to the MAP command to pick up "other-side" addresses of U-B N bridges, and to take advantage of the Ungermann-Bass bridge path XNS message. * Add the SHOW BRIDGES/MAP plotting command.  I Add symbolic protocol names in command parser for usage of the /PROTOCOL a& qualifier (wherever it might be used).  F Add the QUERY command, with support to query U-B bridge route tables,   M Add recognition of Ungermann-Bass device serial numbers as symbolic Ethernet c  address in the syntax UB#nnnnnn.  G Fix "feature" in V5.4-3+ drivers where they attempt to process padding  9 in Ethernet packets received in IEEE 802.3 extended mode.8  / Clean up handling of Apollo DOMAIN ARP queries.P  I Improve command syntax error reporting by having it report which command 0( line token the syntax error occurred at.  ? Break up the FORTRAN source file into multiple files for easiere e-mail transmittal of product.  I Added support for NRC Fusion to LOAD/INTERNET command (courtesy of Galen 0 Tackett, DECUServe).  I Add new information to program crash exception handler (privilege/quota, gK system/device info, traceback computation (non-symbolic), SYSGEN parameter aJ data, more user environmental data). Generalize exception handling to use N crash-dump handler for non-AST exceptions. Clean up exception handlers to use B parameter definitions of system-defined exception codes instead ofM external definition (to create more compact, faster-executing FORTRAN code in-
 handlers).  J Clean up TRACE command code and add /STATISTICS, /TRUNCATE, /SNIFFER, and M /ANALYZER qualifiers to it. Put the address table FORTRAN COMMON in a global pL section so /ANALYZER subprocesses can get at it. Create support subroutines J to allow analyzers to verify they are running in analyzer subprocess mode N and map successfully to the address table global section. Clean up "can't makeH global section" error message to be more meaningful to end-user. Define G parameters for character array element lengths in address table COMMON.CM Add more stringent version checking for global section. Add logic to support -N creating section without using pagefile instead of just giving up and leaving  user confused.  G Correct message loss value "glitch" at initiation of a DISPLAY command.K  M Add extra informational message at ETHERMON start-up to tell users "RTFM" on d, failure to invoke the "fast" $QIO interface.  > Remove erroneous and unnecessary code in LAVC packet analysis.  H Fix privilege restoration problem in SPAWN command, where extra enabled I privileges used by ETHERMON were turned off before SPAWNing a subprocess.0  L Centralize obtaining device and directory location of ETHERMON's .EXE file, D so that other parts of ETHERMON can use that data without having to ( duplicate the code and effort to get it.  I Add new asynchronous event report messages and extensions to SET MESSAGE  M command to control the new message categories. New messages are: identifying sJ multiple nodes with duplicate IP addresses; new address table entries for 
 source nodes.n  M Clean up the SUMMARIZE INTERNET command to report TCP & UDP port information [0 with canonical protocol names whenever possible.  P Correct SUMMARIZE STATISTICS and DISPLAY STATISTICS to ignore "integer overflow"F of unsigned Ethernet port counter values. Correct SUMMARIZE STATISTICS
 averaging.  H Make "remainder-of-line" command parameters be parsed more consistently  across different commands.  O Add DEFINE/KEY, DELETE/KEY, SET KEYPAD, and SHOW KEY commands, and pre-defined i keypad commands.  I Add the /MANUFACTURER qualifier and related support code to the LOAD and i? SAVE commands. Clean up flag mask processing in SAVE/ADDRESSES.s  L Fix address table scan to also check "other address" field in table (to try B to prevent bridges from being entered twice in the address table).  L Correct bandwidth calculation to account for FDDI and proper interframe gap L in places where computed bandwidth is displayed (DISPLAY, SHOW PERFORMANCE,  SUMMARIZE).E  H Add table overflow checking for manufacturer prefix table in ETHER_READ.  9 Add Ethernet interface port counter saturation checks to FD SUMMARIZE, SHOW PERFORMANCE, SHOW PORT_STATUS, and DISPLAY commands.  @ Enlarge extended characteristics buffer for GET_PORT_STATUS and D GET_PORT_COUNTERS procedures (to account for additional information # returned by newer versions of VMS).0  E Fix LOAD/FILTER "feature" for address that is last item on line (was -? automatically converted to a manufacturers' prefix by mistake).B @End(Enumerate) 