 /*  *++  *  * Module: stackutl.c   *  * Abstract:E  *	This module contains three routines for managing a stack of binary E  *	strings. The strings can be no more than 255 characters in length, E  *	and are stored as counted string in the stack. The memory used for G  *	the stack is the per-process common data area. The four pages before F  *	the location CTL$A_COMMON are documented in the VMS module SHELL asD  *	reserved to the user. Although not really documented, no problemsF  *	have existed using this area. Note that the per-process common areaB  *	is maintained across image activation, thus all images within a  *	process can share the stack.   *(  *	The routines to manage the stack are:B  *	1.) PUSH saves the string on the stack. The string is specified$  *	    as a pointer to a descriptor.E  *	2.) POP removes the top entry from the stack and write it into the B  *	    users buffer. The buffer to receive the string is specified$  *	    as a pointer to a descriptor.D  *	3.) SCAN returns entries in the directory stack. SCAN keeps trackA  *	    of the next stack entry by maintaining a context variable.   *  * Environment: 2  *	OpenVMS VAX/AXP operating systems -- User mode.  *  * Special notes: G  *	This code MODIFIES the per process user common area and assumes that 9  *	it is initialized to zero when the process is created. #  *	This code is not ast re-entrant.   *
  * Author:  *	Eric M. LaFranchi  *  * Creation date:   *	22-jun-1988  *  * Modification History:'  *	13-oct-1992	EML000	Eric M. LaFranchi E  *	converted original macro-32 code to C and rewrote the scan routine   *  *--  */   = #include <ctype.h>			/* Character Type Classification Mac  */ ; #include <ssdef.h>			/* Standard VMS messages code	      */ : #include <stdio.h>			/* Standard I/O definitions.	      */> #include <stdlib.h>			/* Standard library definitions.      */> #include <string.h>			/* Standard string definitions.       */> #include <descrip.h>			/* VMS descriptor definitions.	      */  > #include "dirutl.h"			/* directory utility macros and def   */  D    /* Declare the VMS global CTL$A_COMMON as an array. Note that theG     * array declares the common area used by VMS. It is easy to compute ?     * the users per process common area using negative offsets.      */ #ifndef __ALPHA  # pragma nostandard ,     globalref unsigned char *CTL$A_COMMON[]; # pragma standard  #else /* __ALPHA */  # ifndef DECC_BUG )     extern unsigned char *CTL$A_COMMON[];  # else /* DECC_BUG */ = 	/* To avoid bug in DEC C for OpenVMS AXP, hard code address.  	 */I     static unsigned char **CTL$A_COMMON = (unsigned char **)(0x7FFC0800);  # endif /* DECC_BUG */ #endif /* __ALPHA */   /*  *++  * Function: init_stack( )  *  * Abstract:A  *	init_stack initializes the stack to contain no string entries.   *
  * Inputs:  *	None   *  * Outputs:   *	None   *  * Return Value:  *	DIRUTL$_STACKEMPTY;  *  *--  */  unsigned long int 
 init_stack( )  { ;     CTL$A_COMMON[-1] = (unsigned char * )&CTL$A_COMMON[-1]; "     return ( DIRUTL$_STACKEMPTY ); }    /*  *++  * Function: push( )  *  * Abstract:B  *	This function takes the address of a binary string described byF  *	descriptor and places it on the stack. The string must be no longer  *	than 255 characters.   *
  * Inputs:6  *	bistr -- is a pointer to a binary string descriptor  *  * Outputs:   *	None   *  * Return Value:  *	DIRUTL$_STACKFULL  *	DIRUTL$_STRTOLONG
  *	SS$_NORMAL   *  *--  */  unsigned long int 2 push( const struct dsc$descriptor_s *const bistr ) {      register unsigned len;     register unsigned char *sp;        len = bistr->dsc$w_length;  % 	/* check that string is not too long  	 */     if ( len > MAXDIRLEN - 1 ) 	return ( DIRUTL$_STRTOLONG );   	/* update stack pointer 	 */S     sp = CTL$A_COMMON[-1] ? CTL$A_COMMON[-1] : (unsigned char * )&CTL$A_COMMON[-1];      sp = sp - (len + 1);8     if ( sp < ((unsigned char *)&CTL$A_COMMON[-0x200]) ) 	return( DIRUTL$_STACKFULL );    	/* write string to stack  	 */     sp[0] = len;0     memcpy( &sp[1], bistr->dsc$a_pointer, len );     CTL$A_COMMON[-1] = sp;       return ( SS$_NORMAL ); }    /*  *++  * Function: pop( )   *  * Abstract:E  *	This function removes the last saved stack entry and write it into   *	the supplied descriptor.   *
  * Inputs:E  *	bistr -- is a pointer to a descriptor to receive the binary string   *  * Outputs:   *	None   *  * Return Value:  *	DIRUTL$_STACKEMPTY   *	SS$_BUFFEROVF
  *	SS$_NORMAL   *  *--  */  unsigned long int + pop( struct dsc$descriptor_s *const bistr )  {      register status;     register unsigned len;$     register unsigned char *sp, *sb;  2 	/* compute stack pointer and stack base addresses 	 */     sp = CTL$A_COMMON[-1];.     sb = ((unsigned char *)&CTL$A_COMMON[-1]);   	/* check for empty stack  	 */'     if ( (sp == NULL) || ( sp == sb ) )  	return ( DIRUTL$_STACKEMPTY );   8 	/* update stack pointer and copy string to users buffer 	 */     len = sp[0];$     CTL$A_COMMON[-1] = sp + len + 1;$     if ( bistr->dsc$w_length < len )     {  	len = bistr->dsc$w_length;  	status = SS$_BUFFEROVF;     }      else     {  	bistr->dsc$w_length = len;  	status = SS$_NORMAL;      }   0     memcpy( bistr->dsc$a_pointer, &sp[1], len );       return ( status ); }    /*  *++  * Function: scan( )  *  * Abstract:C  *	Scan returns the item stack specified by the context variable in G  *	the users buffer. The users buffer is specified by pointer to string   *	descriptor.  *C  *	The context variable is pointer to a variable that is maintained A  *	by this routine. This variable must be a pointer to a variable G  *	containing zero the first time it is called. If the context variable J  *	is not correct Access violation is returned. Regardless of the value inF  *	the context variable, the stack will never be corrupted as a result  *	of this routine.   *
  * Inputs:C  *	entry -- is a pointer to a descriptor to receive the stack entry 5  *	context -- pointer to pointer to the context block   *  * Outputs:   *	None   *  * Return Value:  *	DIRUTL$_STACKEMPTY   *	SS$_BUFFEROVF
  *	SS$_ACCVIO 
  *	SS$_NORMAL   *	  * EML001   *--  */  unsigned long int < scan( struct dsc$descriptor_s *const entry, void **context ) {      register status;     register unsigned len;/     register unsigned char *cxt, *sp, *sb, *sl;   : 	/* compute pointers to the stack limits (base and length) 	 * for bounds testing 	 */     cxt = *context; 7     sp = cxt ? cxt : (unsigned char *)CTL$A_COMMON[-1]; .     sb = ((unsigned char *)&CTL$A_COMMON[-1]);2     sl = ((unsigned char *)&CTL$A_COMMON[-0x200]);   	/* check for empty stack  	 */%     if ( (sp == NULL) || (sp == sb) )  	return ( DIRUTL$_STACKEMPTY );     	/* compute new context variable 	 */     len = *sp++;     cxt = sp + len;   , 	/* check the bounds of the context variable 	 */#     if ( (cxt > sb) || (cxt < sl) )  	return ( SS$_ACCVIO );   - 	/* write string into the supplied descriptor  	 */$     if ( entry->dsc$w_length < len )     {  	len = entry->dsc$w_length;  	status = SS$_BUFFEROVF;     }      else     {  	entry->dsc$w_length = len;  	status = SS$_NORMAL;      }   ,     memcpy( entry->dsc$a_pointer, sp, len );       *context = cxt;        return ( status ); } 