 #ifdef VAXC & #module CLUE$PROCESS "BOL-V1.0/AUG-96" #else - #pragma module CLUE$PROCESS "BOL-V1.0/AUG-96"  #endif  6 /* This module processes the CLUE PROCESS commands. */  < /* Include definitions from LIB. These includes were created<    by the MLB2H (Macro library to .H file) DCL procedure. */    #include "inc:ccbdef.h"  #include "inc:boddef.h"  #include "inc:lnmstrdef.h" #include "inc:pcbdef.h"  #include "inc:phddef.h"  #include "inc:symdef.h"   9 /* DEC C includes are all given in the following file. */    #include "clue$include.h"    /* Local primary routines. */   B void clue$proc_buffer(), clue$proc_layout(), clue$proc_logicals(),-      clue$proc_recall(), clue$proc_symbols();    /* Auxiliary routines. */    int proc_bufobs();  & void disp_gen_symb(), disp_lbl_symb();   /* External routines. */   extern int symval_and_trymem();   - extern void translate_bits(), symbol_value();   9 /* Global constants (defined in SYS$SYSTEM:DCLDEF.STB) */    globalvalue . 	PPD$L_PRC,		/* Pointer to process PPD area */3 	PPD$Q_CLISYMTBL,	/* Pointer to CLI symbol table */ 0 	PRC_L_RECALLPTR,	/* Pointer to recall buffer *// 	PRC_G_COMMANDS,		/* Pointer to last command */ . 	PRC_C_CMDBUFSIZ;	/* Size of command buffer */  : #define MY_BUFSIZ 0x2000	/* Size of working buffer (8k) */   /***  ***/    void clue$sda_process()  { C  /* Main routine. Depending on given qualifiers, this routine calls $     all process-related routines. */  1  int all_flg = 0,			/* 1 if /ALL was specified */ 3      full_flg = 0,			/* 1 if /FULL was specified */ <      act_flg = 0;			/* 1 if at least one cmd was executed */   <  $DESCRIPTOR(dcl_all,      "ALL");	/* Names of qualifiers */%  $DESCRIPTOR(dcl_buffer,   "BUFFER"); #  $DESCRIPTOR(dcl_full,     "FULL"); %  $DESCRIPTOR(dcl_layout,   "LAYOUT"); '  $DESCRIPTOR(dcl_logicals, "LOGICALS"); %  $DESCRIPTOR(dcl_recall,   "RECALL"); &  $DESCRIPTOR(dcl_symbols,  "SYMBOLS");  E  /* /ALL qualifier specified? If so, mark it (for PROCESS/BUFFER). */   1  all_flg = cli$present(&dcl_all) == CLI$_PRESENT;   >  /* /FULL qualifier specified? Get it for PROCESS/LOGICALS. */  3  full_flg = cli$present(&dcl_full) == CLI$_PRESENT;   *  /* /RECALL? Display DCL recall buffer. */  .  if (cli$present(&dcl_recall) == CLI$_PRESENT)  {   clue$proc_recall();      act_flg = 1;  }8  /* /LOGICALS? Display process-private logical names. */  0  if (cli$present(&dcl_logicals) == CLI$_PRESENT)  {   clue$proc_logicals(full_flg);      act_flg = 1;  }B  /* /BUFFER? If so, display information about buffered objects. */  .  if (cli$present(&dcl_buffer) == CLI$_PRESENT)  {   clue$proc_buffer(all_flg);     act_flg = 1;  }4  /* /LAYOUT? Display layout of process' P1 space. */  .  if (cli$present(&dcl_layout) == CLI$_PRESENT)  {   clue$proc_layout();      act_flg = 1;  }%  /* /SYMBOLS? Display DCL symbols. */   /  if (cli$present(&dcl_symbols) == CLI$_PRESENT)   {   clue$proc_symbols(full_flg);     act_flg = 1;  }8  /* If no qualifier was specified, give a short help. */    if (!act_flg)  {Y   sda$extend_print(desc("PROCESS qualifiers: /BUFFER[/ALL], /LAYOUT, /LOGICALS[/FULL]"));   Y   sda$extend_print(desc("                    /RECALL, /SYMBOLS[/FULL][/GLOBAL|/LOCAL]"));   }  /* Well, all done */  }    /***  ***/    void clue$proc_recall()  { B  /* This routine processes the PROCESS/RECALL command. It displays:     the contents of the current process' recall buffer. */  A  char noacc_msg[] = "%CLUE-W-NOACC, cannot access recall buffer", .       cmd_buf[MY_BUFSIZ],		/* Recall buffer */3       loc_buf[256],			/* Contains single command */ &       *ptr,*cptr;			/* Aux pointers */  !  int aux[4],				/* Aux storage */ &      length[2],				/* String length */)      cmd_cnt = 0,			/* Command counter */ *      clidata,				/* Pointer to CLI data */*      ppddata;				/* Pointer to PPD data */  L /* -------------------------> WE START HERE <---------------------------- */   " /* Display header and new page. */  B  sda$extend_format_subheading(desc("Process DCL Recall Buffer:"));    sda$extend_new_page();   *  /* Get address of DCL data structures. */  /  symbol_value(desc("CTL$AG_CLIDATA"),&clidata);   7  /* Add offset to process-permanent data structures. */     clidata += PPD$L_PRC;  7  /* Let's see whether this process has a CLI mapped. */   '  sda$extend_trymem(clidata,&ppddata,4);   .  /* If it hasn't, print message and return. */    if (!ppddata)    {$   sda$extend_print(desc(noacc_msg));  	   return;   }G  aux[0] = ppddata + PRC_L_RECALLPTR;	/* Get offset to recall pointer */   B  aux[1] = ppddata + PRC_G_COMMANDS;	/* Recall area base address */   >  sda$extend_reqmem(aux[0],&aux[2],4);	/* Get recall pointer */  ,  /* If it is 0, print message and return. */  
  if (!aux[2])   {$   sda$extend_print(desc(noacc_msg));  	   return;   }3  /* Compute upper length: curr_ptr - buffer_base */     length[0] = aux[2] - aux[1];   7  /* Compute lower length: upper_length - buffer_size */   )  length[1] = PRC_C_CMDBUFSIZ - length[0];     /* Get upper buffer. */  -  sda$extend_reqmem(aux[2],cmd_buf,length[1]);   9  sda$extend_reqmem(aux[1],&cmd_buf[length[1]],length[0]);   1  aux[1] = PRC_C_CMDBUFSIZ;	/* Initialize index */   C  /* If the length of the last command is 0, the buffer is empty. */     if (!cmd_buf[aux[1]-1])  {J   sda$extend_print(desc("%CLUE-W-EMPTY, command recall buffer is empty"));  	   return;   }&  /* else proceed with heading line. */  *  sda$extend_print(desc("Index  Command"));  &  /* Scan recall buffer, get length. */  #  while (aux[0] = cmd_buf[aux[1]-1])   {?   ptr = &cmd_buf[aux[1]-aux[0]-1];		/* Set start of command. */   >   strncpy(loc_buf, ptr, aux[0]);  		/* Copy single command. */  3   loc_buf[aux[0]] = 0;				/* Mark end of command */   F   /* If this string contains a password, replace it with asterisk (*).E      Password are assumed to exist if the string \"::\ is found and a ,      blank is located before this string. */  <   if (ptr = strstr(loc_buf,"\"::"))		/* Key string found? */   { $    *ptr = 0;					/* Yes, Mark end */  7    if (cptr = strrchr(loc_buf,' '))		/* Blanc found? */     {-     cptr++;					/* Yes, point to next char */   >     while (*cptr) *cptr++ = '*';		/* and overwrite with '*' */    }/    *ptr = '"';					/* Restore quotation mark */    } 0   cmd_cnt++;					/* Increment command counter */     /* Display command. */  H   sda$extend_print(desc("!3UL    !AF"),cmd_cnt,strlen(loc_buf),loc_buf);  4   /* Compute offset to next command and continue. */     aux[1] = aux[1] - aux[0] - 3;   }  /* Ok, done. */ }    /***  ***/   ! void clue$proc_logicals(int full)  { D  /* This routine processes the PROCESS/LOGICALS command. It displaysB     the process-private logical name table stored in P1 space. The4     table can be accessed by address CTL$GL_LNMHASH.  A     If full = 1, the logical name and equivalence name attributes      are displayed as well. */   9  char accmodtab[4][8] = {"kernel","exec","super","user"};   /  char nambuf[80],				/* Buffer for name attr */ 1       equbuf[80],				/* Buffer for equ. string */ *       bitbuf[30],				/* Buffer for bits */!       *ptr;					/* Aux pointer */   -  int tab_adr,					/* Address of hash table */ "      tab_siz,					/* Table size */-      lnmbptr,					/* Pointer to LNMB chain */ '      lnmxptr,					/* Pointer to LNMX */ $      namcnt = 0;				/* # of names */  *  struct	bittab					/* Logical name bits */.    nambittab[6] = {LNMB$M_NO_ALIAS,"no_alias", 		   LNMB$M_CONFINE, "confine",  		   LNMB$M_CRELOG,  "crelog", 		   LNMB$M_TABLE,   "table",   		   LNMB$M_NODELETE,"nodelete", 		   0,0};	   .  struct bittab					/* Equivalence name bits */0    equbittab[3] = {LNMX$M_CONCEALED,"concealed",! 		   LNMX$M_TERMINAL, "terminal", 
 		   0,0};  0  struct __LNMB lnmb;				/* Logical name block */  4  struct __LNMX lnmx;				/* Equivalence name block */  L /* -------------------------> WE START HERE <---------------------------- */  #  /* Display header and new page. */   >  sda$extend_format_subheading(desc("Process Logical Names:"));    sda$extend_new_page();   C  /* Get address and size of per-process logical name hash table. */   4  symval_and_trymem(desc("CTL$GL_LNMHASH"),&tab_adr);  5  symval_and_trymem(desc("LNM$GL_HTBLSIZP"),&tab_siz);   5  /* If one of these cells is 0, we can't continue. */     if (!tab_adr || !tab_siz)  {V   sda$extend_print(desc("%CLUE-W-NOACC, cannot access logical name data structures"));  	   return;   }=  tab_adr += LNMHSH$S_LNMHSHDEF;		/* Skip hash table header */   4  while (tab_siz)			/* Scan through all hash heads */  {@   sda$extend_reqmem(tab_adr,&lnmbptr,4); /* Get head of chain */  6   while (lnmbptr)			/* LNMB found? Copy fixed part. */   { 6    sda$extend_reqmem(lnmbptr,&lnmb,LNMB$T_NAME_OFF+1);  :    /* Copy name into local buffer. The first byte contains.       length of the name, it is not copied. */  K    sda$extend_reqmem(lnmbptr+LNMB$T_NAME_OFF+1,nambuf,lnmb.LNMB$T_NAME[0]);   #    nambuf[lnmb.LNMB$T_NAME[0]] = 0;   E    /* If /FULL was given, add the access mode and name attributes. */       if (full)    {     strcat(nambuf," [");  1     strcat(nambuf,accmodtab[lnmb.LNMB$B_ACMODE]);   (     /* Get flag bits of name, if any. */  7     translate_bits(nambittab,lnmb.LNMB$B_FLAGS,bitbuf);   )     /* Append this buffer to the name. */        if (bitbuf[0])     {       strcat(nambuf,",");        strcat(nambuf,bitbuf);      } 2     strcat(nambuf,"]");				/* Append a bracket. */    }K    /* Lets start with the equivalence name(s). Set pointer to LNMX and copy        fixed part. */  8    lnmxptr = lnmbptr+LNMB$S_LNMBDEF+lnmb.LNMB$T_NAME[0];  9    sda$extend_reqmem(lnmxptr,&lnmx,LNMX$T_XLATION_OFF+1);   E    /* If the LNMX$M_XEND bit is the in LNMX$B_FLAGS, this is the LNMX 5       marked the end, it is not further processed. */   -    while (!(lnmx.LNMX$B_FLAGS & LNMX$M_XEND))     {>     /* Handle equivalence strings for name tables in a special<        manner. The index of these strings is always negative=        (> 0x7F), they contain non-displayable information. In ?        addition, for name tables, there is no second LNMX (with #        the LNMX$M_XEND bit set). */   0     if (lnmx.LNMX$B_INDEX > 0x7F) equbuf[1] = 0;       else     { B      /* Copy equivalence string. In the output buffer, we start at/        position 1 to leave space for quotes. */   W      sda$extend_reqmem(lnmxptr+LNMX$T_XLATION_OFF+1,&equbuf[1],lnmx.LNMX$T_XLATION[0]);   *      equbuf[lnmx.LNMX$T_XLATION[0]+1] = 0;     } D     /* If this is a 'canonical' name (pointer to PPD), skip over PPDC       information (4 bytes). The equivalence strings of these names !       always start with 1B 00. */   >     if (equbuf[1] == 0x1B && equbuf[2] == 0) ptr = &equbuf[5];       else ptr = &equbuf[1];  @     /* Place the equivalence string under quotes to display null,        strings and blank strings as well. */       *(--ptr) = '"';        strcat(ptr,"\"");   C     /* For /FULL, display equivalence string attributes as well. */   
     if (full)      { <      translate_bits(equbittab,lnmx.LNMX$B_FLAGS,&bitbuf[2]);  C      /* If bits were returned, bitbuf[2] contains a non-zero value. 8         So include surrounding brackets as well. */             if (bitbuf[2])       {'       bitbuf[0] = ' '; bitbuf[1] = '[';          strcat(bitbuf,"]");          strcat(ptr,bitbuf);       }     } D  /* If this is the first equivalence string, display the name stringI        as well. Otherwise, display the equivalence string only, preceeded E        by a 8 blanks and an equal sign (similar to the output of SHOW         LOGICALS). */       if (!lnmx.LNMX$B_INDEX || lnmx.LNMX$B_INDEX > 0x7F) sda$extend_print(desc("  !AF = !AF"),strlen(nambuf),nambuf,strlen(ptr),ptr);  A     else sda$extend_print(desc("        = !AF"),strlen(ptr),ptr);   ?     /* If this logical was a name table name, we can stop here, /        here are no more equivalence strings. */   0     if (lnmb.LNMB$B_FLAGS & LNMB$M_TABLE) break;  =     /* Otherwise, let's see the next LNMX. Adjust pointer. */   <     lnmxptr = lnmxptr+LNMX$S_LNMXDEF+lnmx.LNMX$T_XLATION[0];       /* Get next LNMX. */   :     sda$extend_reqmem(lnmxptr,&lnmx,LNMX$T_XLATION_OFF+1);    }+    namcnt++;					/* Increment name count */   ?    lnmbptr = lnmb.LNMB$L_FLINK;			/* Try next name in chain. */    } 7   /* Try next chain, 'til all chaines are exhausted. */   3   tab_adr += 4;					/* Point to next hash header */   2   tab_siz --;					/* Decrement remaining hashes */  }  /* Print final name count. */    sda$extend_skip_lines(1);  8  sda$extend_print(desc("Total of !UW name!%S."),namcnt);    /* That's all. */ }    /***  ***/    void clue$proc_buffer(int all) { B  /* This routine processes the PROCESS/BUFFER command. It displaysD     the buffer objects of the current process, or, if /ALL is given,?     of all processes. Buffer objects are special, memory-locked @     buffers mostly used for I/O purposes. They are mapped twice:=     once in per-process address space to allow the process to =     access them, and OTOS, by system (S0) addresses, allowing A     drivers and executive components directly to process with it. :     Since they are locked in memory, their contents may be>     accessed at higher IPLs as well. They must be aligned on a     physical page boundary.   A     The offset PCB$Q_BUFOBJ_LIST in the PCB contains a pointer to C     a chained list of all buffered objects owned by the process. */   ,   int *curpcb,				/* Address of curr. PCB */-       *pcbvec,				/* Address of PCB vector */ ,       *nullpcb,				/* Address of NULL PCB */)       maxproc,				/* Maximum processes */ 4       objcnt = 0,			/* At least one object found? */#       cnt = 0,				/* Process cnt */ $       status;				/* Return status */  L /* -------------------------> WE START HERE <---------------------------- */  #  /* Display header and new page. */   A  sda$extend_format_subheading(desc("Process Buffered Objects:"));     sda$extend_new_page();   c  sda$extend_print(desc("Address     PID     BasePVA   BaseSVA   Acmode  Seq#  RefC  PagC  Flags"));   l  sda$extend_print(desc("--------  --------  --------  --------  ------  ----  ----  ----  --------------"));  >  /* If not /ALL was given, examine the buffered objects of the     current process only. */  
  if (!all)  {F   symval_and_trymem(desc("CTL$GL_PCB"),&curpcb);	/* Get PCB address */  >   status = proc_bufobs(curpcb);		/* Display objects, if any */  2   if (!status)				/* Status = 0: no obj's found */   { D    sda$extend_print(desc("%CLUE-I-NOBOD, no buffer objects found"));  
    return;   }   }  else   {9   /* Scan through the PCB array and try every process. */   H   symval_and_trymem(desc("SCH$GL_NULLPCB"),&nullpcb);	/* Get NULL PCB */  H   symval_and_trymem(desc("SCH$GL_PCBVEC"),&pcbvec);	/* And PCB Vector */  I   symval_and_trymem(desc("SCH$GL_MAXPIX"),&maxproc);	/* And PCB Vector */    4   maxproc++; cnt = 2;				/* Skip NULL and SWAPPER */     /* Scan every process. */      while (cnt != maxproc)   { &    /* Get next PCB from PCB vector. */  -    sda$extend_reqmem(&pcbvec[cnt],&curpcb,4);   C    if (curpcb == nullpcb)        /* If NULL PCB: unused PCB slot */     {     cnt++;			/* Try next */   
     continue;     }>    status = proc_bufobs(curpcb); /* Display objects, if any */  +    if (status < 0)		/* In case of error, */     {-     objcnt = status;		/* Mark object count */        break;			/* and abort */    }7    objcnt += status;		/* Save # of displayed objects */   .    cnt++;			/* Try next, until end of array */   } E   /* If no buffered objects were found, let the user know, otherwise,       display # of objects. */      if (!objcnt)   { W    sda$extend_print(desc("%CLUE-I-NOBOD, there are no processes with buffer objects"));    }    else   {     sda$extend_skip_lines(1);  B    sda$extend_print(desc("Total of !UW object!%S found."),objcnt);   }   }  /* That's all. */ }    /***  ***/    void clue$proc_layout()  { B  /* This routine processes the PROCESS/LAYOUT command. It displays3     the layout of the current process' P1 space. */   >  char buf_asc[] = "!48<CLI buffer pages (!UB)!>!XL  !XL  !XL",Y       clidat_asc[] = "!48<CLI data area and symbol table (CLISYMTBL=!UW)!>!XL  !XL  !XL", =       clitab_asc[] = "!48<CLI command tables!>!XL  !XL  !XL";9  +  unsigned int val[4],				/* Aux integers */.) 	      curend,				/* Current end of P1 */s,               stack[4],				/* Stack array */' 	      array[8],				/* pointer array */e0               page_size,			/* Phys. page size */2               round_mask,			/* Mask to round up */4               p1_end_va,			/* Low end of P1 space */5 	      clidata,clidata_size,		/* CLI data and size */c8 	      clitable,clitable_size;		/* CLI table and size */    struct __PHD phd;  A  /* Perform some sanitary checks to ensure that the process we're A     examing is a valid one. First get contents of stack array. */   ,  symbol_value(desc("CTL$AL_STACK"),&val[0]);  $  sda$extend_reqmem(val[0],stack,16);  @  /* If kernel stack pointer is 0, the process is the SWAPPER. */    if (!stack[PSL$C_KERNEL])  {W   sda$extend_print(desc("%CLUE-W-NOP1, the SWAPPER process does not have a P1 space"));d  	   return;$  }0  /* Get physical page size and round-up mask. */  8  symval_and_trymem(desc("MMG$GL_PAGE_SIZE"),&page_size);    round_mask = page_size - 1;  *  /* Get low value of P1 space from PHD. */  /  symval_and_trymem(desc("CTL$GL_PHD"),&val[1]);P     /* If not accessible: error. */  
  if (!val[1])n  {=   sda$extend_print(desc("%CLUE-W-BADPROC, no such process"));   	   return;$  }  /* Copy PHD. */  8  if (!(sda$extend_trymem(val[1],&phd,PHD$K_LENGTH) & 1))  {  N   sda$extend_print(desc("%CLUE-W-NOPHD, cannot access process header (PHD)"));  	   return;   }+  p1_end_va = phd.PHD$L_FREP1VA + page_size;*  I  /* Sanitary check: FREP1VA muse be 0x7F000000 > FREP1VA > 0x7FFE0000. */I  6  if (p1_end_va < 0x7F000000 || p1_end_va > 0x7FFE0000)  {  R   sda$extend_print(desc("%CLUE-W-BADP1, invalid P1 base address: !XL"),p1_end_va);  	   return;A  }D  /* Well, it's a valid address, so we can start with our display. */  P  sda$extend_format_subheading(desc("Process P1 Virtual Address Space Layout:"));    sda$extend_new_page();R  ?  sda$extend_print(desc("!50<Item!>Base      End      Length"));E     /* Compute size of P1 space. */  -  val[0] = (0x80000000-p1_end_va) / page_size;   \  sda$extend_print(desc("!58<P1 space lower bound (size: !UL pages)!>!XL"),val[0],p1_end_va);  5  curend = p1_end_va;		/* Save this value for later */_  @  /* Get the fixed end of the P1 space. If this is the same value?     as p1_end_va, there is no user stack and image I/O segment._     Otherwise, display it. */a  4  symval_and_trymem(desc("CTL$GL_CTLBASVA"),&val[0]);    if (val[0] != p1_end_va)u  {}   sda$extend_print(desc("!48<User mode stack and extra image I/O segment!>!XL  !XL  !XL"),p1_end_va,val[0],val[0]-p1_end_va);L  ,   curend = val[0];		/* Update end pointer */  }C  /* If the process has a message section mapped, display it now. */)  ,  symbol_value(desc("CTL$GL_PPMSG"),&val[0]);  %  sda$extend_reqmem(val[0],&val[1],8);_  '  val[2]++;			/* Set to page boundary */_    if (val[1])  {g   sda$extend_print(desc("!48<Per-process message section!>!XL  !XL  !XL"),val[1],val[2],val[2]-val[1]);d  ,   curend = val[2];		/* Update end pointer */  }I  /* If the process has a CLI mapped, display CLI-related items. Normally, D     they start with the CLI data area (used to store symbols, labelsG     and key definitions). If, however, the CLI tables were remapped andrF     are greather than the initial tables (SET COMMAND), the CLI tablesC     start at lower addresses. Let's determine which comes first. */%  .  symbol_value(desc("CTL$AG_CLIDATA"),&val[0]);  &  sda$extend_reqmem(val[0],array,0x14);    /* The array contains now:a  > 	in longword[3]: the size of the CLI data area (symbol table),6 	in longword[4]: the base address o the CLI data area.  4     The remaining longwords are meaningless here. */    clidata = array[4];    clidata_size = array[3];   <  if (clidata)		/* Points to CLI data area or 0, if no CLI */  {0   symbol_value(desc("CTL$AG_CLITABLE"),&val[0]);  &   sda$extend_reqmem(val[0],&val[1],8);  .   val[2]++;			/* Increment to page boundary */     clitable = val[1];  "   clitable_size = val[2] - val[1];  -   /* If data area comes first, display it. */(     if (clidata < clitable)t   { B    /* If there is a difference beetween the end of the I/O segment@       and the base address of the CLI data area, display them as       'buffer pages'. */      if (clidata != curend)     {     val[2] = clidata - curend;  K     sda$extend_print(desc(buf_asc),val[2]/page_size,curend,clidata,val[2]);e    }    /* CLI data area. */   g    sda$extend_print(desc(clidat_asc),clidata_size/page_size,clidata,clidata+clidata_size,clidata_size);b      /* CLI table. */a  T    sda$extend_print(desc(clitab_asc),clitable,clitable+clitable_size,clitable_size);  %    curend = clitable + clitable_size;    }$   else   {dL    /* Otherwise, display CLI tables first, followed by the CLI data area. */  %    curend = clitable + clitable_size;]  D    sda$extend_print(desc(clitab_asc),clitable,curend,clitable_size);  @    /* If there is a difference beetween the end of the CLI table@       and the base address of the CLI data area, display them as       'buffer pages'. */      if (curend != clidata)     {     val[2] = clidata - curend;  K     sda$extend_print(desc(buf_asc),val[2]/page_size,curend,clidata,val[2]);i    }    /* CLI data area. */d  g    sda$extend_print(desc(clidat_asc),clidata_size/page_size,clidata,clidata+clidata_size,clidata_size);w  #    curend = clidata + clidata_size;n   }cE   /* Display the CLI image. Location CTL$AG_CLIMAGE contains its basee0      address, CTL$AG_CLIIMAGE+4 the size - 1. */  /   symbol_value(desc("CTL$AG_CLIMAGE"),&val[0]);   &   sda$extend_reqmem(val[0],&val[1],8);  /   val[2]++;			/* Increment to page boundary. */	  .   val[0] = val[2] - val[1];	/* Compute size */  A   /* If there is a hole from the end of the data area to the base @      of the CLI image, it was the VA range of a previously used,;      now unmapped CLI table. Display it as 'spare area'. */f     if (val[1] != curend)u   {/b    sda$extend_print(desc("!48<CLI tables spare area!>!XL  !XL  !XL"),curend,val[1],val[1]-curend);   }    /* CLI image. */  N   sda$extend_print(desc("!48<CLI image!>!XL  !XL  !XL"),val[1],val[2],val[0]);  }E  /* Every process has F11-XQP code and data permanently mapped in its A     P1 space. For VMS V5 and V6, this information can be found iny     CTL$GL_F11XQP at:x       longword[3]: Size of code,*     longword[4]: Base address of XQP code,*     longword[6]: Base address of XQP data.       For VMS V7:        longword[3]: 0     longword[4]: 0+     longword[5]: Size of XQP code and data, 3     longword[6]: Base address of XQP code and data.G  /     The remaining longwords are meaningless. */   3  symval_and_trymem(desc("CTL$GL_F11BXQP"),&val[0]);a  &  sda$extend_reqmem(val[0],array,0x1C);  *  if (array[3] && array[4])	/* V5 and V6 */  {y   sda$extend_print(desc("!48<File System (F11B-XQP) data and stack!>!XL  !XL  !XL"),array[6],array[4],array[4]-array[6]);a  s  sda$extend_print(desc("!48<File System (F11B-XQP) code area!>!XL  !XL  !XL"),array[4],array[4]+array[3],array[3]);u  }|  else sda$extend_print(desc("!48<File System (F11B-XQP) code and data!>!XL  !XL  !XL"),array[6],array[6]+array[5],array[5]);   ?  /* Display image I/O segments. There are two of this: one withrA     the protection UREW (User-mode read/executive-mode write) and @     one with EW (Executive mode read/write). They are pointed by;     locations PIO$GQ_UREW_IIODEFAULT and PIO$GQ_IIODEFAULT, @     respectively. The first longword at these addresses contains=     the segment size, the second the segment base address. */	  6  symbol_value(desc("PIO$GQ_UREW_IIODEFAULT"),&val[0]);  #  sda$extend_reqmem(val[0],array,8);M  Lk  sda$extend_print(desc("!48<Image I/O segment (UREW)!>!XL  !XL  !XL"),array[1],array[1]+array[0],array[0]);E  1  symbol_value(desc("PIO$GQ_IIODEFAULT"),&val[0]);-  #  sda$extend_reqmem(val[0],array,8);-  -k  sda$extend_print(desc("!48<Image I/O segment (exec)!>!XL  !XL  !XL"),array[1],array[1]+array[0],array[0]);)  C  /* Display process I/O segment. The end of this area is determineds<     by CTL$GL_LNMDIRECT (the base address of the pre-process@     allocation region). Its base address is the end of the image     I/O segment. *//  5  symval_and_trymem(desc("CTL$GL_LNMDIRECT"),&val[1]);i    val[0] = array[1] + array[0];    val[2] = val[1] - val[0];  Cw  sda$extend_print(desc("!48<Process I/O segment (PIOPAGES=!UW)!>!XL  !XL  !XL"),val[2]/page_size,val[0],val[1],val[2]);e  ?  /* Display the process allocation region. The system parameter{$     CTLPAGES determines its size. */  $  val[0] = val[1];		/* start = end */  4  symval_and_trymem(desc("SGN$GW_CTLPAGES"),&val[2]);  -  val[2] &= 0xFFFF;		/* Mask out upper word */1    val[1] = val[2] * page_size;b  z  sda$extend_print(desc("!48<Process allocation region (CTLPAGES=!UW)!>!XL  !XL  !XL"),val[2],val[0],val[0]+val[1],val[1]);  ?  /* Display channel control block (CCB) table. The upper end of=<     this table is at CTL$GL_CCBBASE. Since CCB's are indexedC     by negative offsets (each offset is a multiple of CCB$K_LENGTH) C     and the first CCB is at offset 0xFFF0, we must add CCB$K_LENGTHiD     to reach the actual table end. The lower value can be determined9     by: rnd (upper_end - (CHANNELCNT * CCB$K_LENGTH)). */   4  symval_and_trymem(desc("SGN$GW_PCHANCNT"),&val[2]);  -  val[2] &= 0xFFFF;		/* Mask out upper word */t  3  symval_and_trymem(desc("CTL$GL_CCBBASE"),&val[1]);e    val[1] += CCB$K_LENGTH;  a=  val[0] = val[1] - ((val[2]+1) * CCB$K_LENGTH) & ~round_mask;   ~  sda$extend_print(desc("!48<Channel control block table (CHANNELCNT=!UW)!>!XL  !XL  !XL"),val[2],val[0],val[1],val[1]-val[0]);  D  /* Display window to process header. Base is in CTL$GL_PHD, size is     SGN$GL_PHDPAGCT. */t  /  symval_and_trymem(desc("CTL$GL_PHD"),&val[0]);   N4  symval_and_trymem(desc("SGN$GL_PHDPAGCT"),&val[1]);  8  val[1] *= page_size;			/* Compute page count to size */      il  sda$extend_print(desc("!48<P1 window to process header (PHD)!>!XL  !XL  !XL"),val[0],val[0]+val[1],val[1]);  B  /* NSA scratch area: from NSA$A_SCRATCH to CTL$A_PRCPRM_SDATA. */  -  symbol_value(desc("NSA$A_SCRATCH"),&val[0]);q  2  symbol_value(desc("CTL$A_PRCPRM_SDATA"),&val[1]);  =  /* On V5, these cells doesn't exist, so don't display it. */     if (val[0])  {e   sda$extend_print(desc("!48<Security audit data (NSA)!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);   &   /* Supervisor mode data (1 page). */  &   val[0] = val[1];			/* Start = end */     val[1] = page_size;s  Z   sda$extend_print(desc("!48<VMS supervisor mode data area!>!20<!XL!>!XL"),val[0],val[1]);  %   /* Executive mode data (1 page). */f  3   symbol_value(desc("CTL$A_PRCPRM_EDATA"),&val[0]);   Y   sda$extend_print(desc("!48<VMS executive mode data area!>!20<!XL!>!XL"),val[0],val[1]);   }O  /* User-, executive-, supervisor- and kernel-mode event data (1 page each). */"  /  symbol_value(desc("CTL$A_EVI_UDATA"),&val[0]);i    val[1] = page_size;  U  sda$extend_print(desc("!48<User mode event data area!>!20<!XL!>!XL"),val[0],val[1]);;  /  symbol_value(desc("CTL$A_EVI_SDATA"),&val[0]);n  [  sda$extend_print(desc("!48<Supervisor mode event data area!>!20<!XL!>!XL"),val[0],val[1]);u  /  symbol_value(desc("CTL$A_EVI_EDATA"),&val[0]);'  Z  sda$extend_print(desc("!48<Executive mode event data area!>!20<!XL!>!XL"),val[0],val[1]);  /  symbol_value(desc("CTL$A_EVI_KDATA"),&val[0]);t  W  sda$extend_print(desc("!48<Kernel mode event data area!>!20<!XL!>!XL"),val[0],val[1]);   8  /* Pages reserved for VWS (VMS Workstation Software) */  )  symbol_value(desc("CTL$A_VWS"),&val[0]);B  
  val[1] *= 2;M  n  sda$extend_print(desc("!48<VWS (VMS workstation software) area!>!XL  !XL  !XL"),val[0],val[0]+val[1],val[1]);  >  /* RMS context area. Starts at PIO$A_RMS_PIOBASE, 2 pages. */  1  symbol_value(desc("PIO$A_RMS_PIOBASE"),&val[0]);     val[1] = page_size * 2;  c  sda$extend_print(desc("!48<RMS process context area!>!XL  !XL  !XL"),val[0],val[0]+val[1],val[1]);   %  /* RMS directory cache (4 pages). */   .  symbol_value(desc("PIO$A_DIRCACHE"),&val[0]);    val[1] = page_size * 4;  ^  sda$extend_print(desc("!48<RMS directory cache!>!XL  !XL  !XL"),val[0],val[0]+val[1],val[1]);  (  /* RMS internal structures (1 page). */    val[0] = val[0] + val[1];    val[1] = page_size;  f  sda$extend_print(desc("!48<RMS internal structures (IFAB/IRAB tables)!>!20<!XL!>!XL"),val[0],val[1]);  B  /* Per-process common areas. There a 2 (user and DEC), we display<     it in a single line. Starts at PIO$A_RMS_PIOEND, ends at     CTL$AG_CMEDATA. */    val[0] += val[1];  .  symbol_value(desc("CTL$AG_CMEDATA"),&val[1]);  c  sda$extend_print(desc("!48<Per-process common areas!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);p  E  /* Compatibility mode data pages (always 2, start at CTL$AG_CMEDATA,,     end at NSA$T_IDT. */  %  val[0] = val[1];			/* Start = end */   )  symbol_value(desc("NSA$T_IDT"),&val[1]);y  h  sda$extend_print(desc("!48<Compatibility mode data pages!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);  ,  /* Security audit data pages (always 3). */  %  val[0] = val[1];			/* Start = end */p  .  symbol_value(desc("CTL$GL_IAFLINK"),&val[1]);  d  sda$extend_print(desc("!48<Security audit data pages!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);  %   /* Image activator context area. */B  %  val[0] = val[1];			/* Start = end */t  /  symbol_value(desc("CTL$AL_CLICALBK"),&val[1]);d  _  sda$extend_print(desc("!48<Image activator context area!>!20<!XL!>!XL"),val[0],val[1]-val[0]);o    /* Generic CLI data pages. */  %  val[0] = val[1];			/* Start = end */o  0  symbol_value(desc("IAC$AL_IMGACTBUF"),&val[1]);  a  sda$extend_print(desc("!48<Generic CLI data pages!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);a  @  /* Image activator scratch and debugger context pages. Start at.     IAC$AL_IMGACTBUF, end at CTL$A_DISPVEC. */  %  val[0] = val[1];			/* Start = end */n  -  symbol_value(desc("CTL$A_DISPVEC"),&val[1]);t  g  sda$extend_print(desc("!48<Image activator scratch area!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);C  8  /* User-written system services and message vectors. */  %  val[0] = val[1];			/* Start = end */-  -  symbol_value(desc("MMG$IMGHDRBUF"),&val[1]);e  m  sda$extend_print(desc("!48<Privileged shareable image vectors!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);"  $  /* Image header buffer (1 page). */  %  val[0] = val[1];			/* Start = end *//    val[1] = page_size;  O  sda$extend_print(desc("!48<Image header buffer!>!20<!XL!>!XL"),val[0],val[1]);n  e6  /* Kernel request packet lookaside list (4 pages). */  *  symbol_value(desc("CTL$GL_KRP"),&val[0]);    val[1] = page_size * 4;  u  sda$extend_print(desc("!48<Kernel request packet lookaside list (KRP)!>!XL  !XL  !XL"),val[0],val[0]+val[1],val[1]);$    /* One guard page follows. */    val[0] += val[1];    val[1] = page_size;  F  sda$extend_print(desc("!48<Guard page!>!20<!XL!>!XL"),val[0],val[1]);  pA  /* Per-process stacks (kernel, executive, supervisor). The startt>     of the stacks is at location CTL$GL_KSTKBASEXP, the kernel@     stack expansion area, until KST$GL_KSTKBAS, the lower end of     the kernel stack. */  1  symbol_value(desc("CTL$GL_KSTKBASEXP"),&val[0]);e  .  symbol_value(desc("CTL$GL_KSTKBAS"),&val[1]);  f  sda$extend_print(desc("!48<Kernel stack expansion area!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);  ;  /* Kernel, executive and supervisor stack follows (in this 8     sequence). The top end of a stack is the base of its6     adjacent stack. Note that stacks grow toward lower     addresses.  8     The base address of all stacks were already obtained"     and saved in array 'stack'. */  %  val[0] = val[1];			/* Start = end */t  A  val[1] = stack[PSL$C_KERNEL];		/* Top (begin) of kernel stack */e  b  sda$extend_print(desc("!48<Kernel mode stack (KSP)!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);  %  val[0] = val[1];			/* Start = end */   B  val[1] = stack[PSL$C_EXEC];		/* Top (begin) of executive stack */  e  sda$extend_print(desc("!48<Executive mode stack (ESP)!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);P  %  val[0] = val[1];			/* Start = end */I  D  val[1] = stack[PSL$C_SUPER];		/* Top (begin) of supervisor stack */  f  sda$extend_print(desc("!48<Supervisor mode stack (SSP)!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);  &  /* VMS kernel mode data (2 pages). */  2  symbol_value(desc("CTL$A_PRCPRM_KDATA"),&val[0]);    val[1] = page_size * 2;  d  sda$extend_print(desc("!48<VMS kernel mode data area!>!XL  !XL  !XL"),val[0],val[0]+val[1],val[1]);    /* VMS user mode data page. */n  0  symbol_value(desc("CTL$GL_DCLPRSOWN"),&val[0]);  U  sda$extend_print(desc("!48<VMS user mode data area!>!20<!XL!>!XL"),val[0],val[1]/2);c  ?  /* P1 System service vectors. This area ends at CTL$GL_VECTORScF     (16 pages), wherein only 6 pages are currently used. The remaining(     pages are reserved for expansion. */  ,  symbol_value(desc("P1SYSVECTORS"),&val[0]);  .  symbol_value(desc("CTL$GL_VECTORS"),&val[1]);  d  sda$extend_print(desc("!48<P1 system service vectors!>!XL  !XL  !XL"),val[0],val[1],val[1]-val[0]);    /* P1 pointer page. */     val[0] = val[1];(    val[1] = page_size;  K  sda$extend_print(desc("!48<P1 pointer page!>!20<!XL!>!XL"),val[0],val[1]);g  C  /* Debugger area. The base address and size of this area is storedZD     at CTL$GQ_DBGAREA (size) and CTL$GQ_DBGAREA+4 (base). Currently,K     this are always the upper 64 kBytes of P1 space (7FFF0000-7FFFFFFF). */   /.  symbol_value(desc("CTL$GQ_DBGAREA"),&val[2]);  !  sda$extend_reqmem(val[2],val,8);W  Z  sda$extend_print(desc("!48<Debug data area!>!XL  !XL  !XL"),val[1],val[1]+val[0],val[0]);  J  /* Well, we're at 0x80000000 now. CLUE MEMORY/LAYOUT displays information5     about S0 space organization. Here, that's all! */  }    /***  ***/d  # void clue$proc_symbols(int ful_flg)i {yC  /* This routine processes the PROCESS/SYMBOLS command. It displays 9     the contents of the current process' symbol table. */   <  $DESCRIPTOR(dcl_gbl,"GLOBAL");		/* DCL qualifier /GLOBAL */:  $DESCRIPTOR(dcl_loc,"LOCAL");		/* DCL qualifier /LOCAL */  @  char noacc_msg[] = "%CLUE-W-NOACC, cannot access symbol table",:       symdatbuf[32+256];		/* Buffer containing symbol name 					   and value */  "  int cnt = 0,			/* Symbol count */#      hashcnt = 0,		/* Hash count */ =      scp = 0,			/* Symbol scope: 0=All, 1=Global, 2=Local) */e+      hashaddr,			/* Address of next hash */c1      symptr,			/* Pointer to next symbol block */,1      clidata,			/* Pointer to generic CLI data */ ;      symdata[2];		/* Size of and pointer to symbol table */p  &  struct __SYM sym;		/* Symbol block */    a  /* Evaluate qualifiers. */i  H  if (cli$present(&dcl_gbl) == CLI$_PRESENT) scp += LIB$K_CLI_GLOBAL_SYM;  G  if (cli$present(&dcl_loc) == CLI$_PRESENT) scp += LIB$K_CLI_LOCAL_SYM;e  $  /* /LOCAL and /GLOBAL means all. */  @  if (scp == LIB$K_CLI_GLOBAL_SYM + LIB$K_CLI_LOCAL_SYM) scp = 0;  " /* Display header and new page. */  =  sda$extend_format_subheading(desc("Process Symbol Table:"));m    sda$extend_new_page();   *  /* Get address of DCL data structures. */  /  symbol_value(desc("CTL$AG_CLIDATA"),&clidata);2  -  /* Add offset to symbol table descriptor. */)    clidata += PPD$Q_CLISYMTBL;  7  /* Let's see whether this process has a CLI mapped. */2  &  sda$extend_trymem(clidata,symdata,8);  .  /* If it hasn't, print message and return. */    if (!symdata[0])   {$   sda$extend_print(desc(noacc_msg));  	   return;h  }9  hashaddr = symdata[1];				/* Initialize hash address. */i  8  /* Loop through all chains. There are 256 currently. */    while(hashcnt != 256)  {B   sda$extend_reqmem(hashaddr,&symptr,4);	/* Get next hash chain */  B   /* If the hash chain points to itself, it is empty. Try next. */     if (symptr == hashaddr)e   {_3    hashaddr += 8;				/* Point to next hash chain */n  .    hashcnt++;					/* Increment hash counter */  $    continue;					/* And try again */   }s=   /* We've found a symbol block in the hash chain. Follow ther;      chain until its end is reached. This is indicated by az,      forward link back to the hash chain. */  ?   while (symptr != hashaddr)			/* Until chain end is reached */L   {EE    sda$extend_reqmem(symptr,&sym,SYM_S_SYMDEF);	/* Copy fixed part */	  2    /* If this an abbreviation pointer, drop it. */      if (sym.SYM_W_NOUNIQUE < 0)    {D     sda$extend_reqmem(symptr,&symptr,4);	/* Get next symbol block */  %     continue;					/* skip this one */f    })    switch (scp)					/* Determine scope */     {4     case LIB$K_CLI_GLOBAL_SYM:			/* Globals only? */     {b@      if (sym.SYM_W_PROCLEVEL >= 0)		/* Level >= 0 means local */      {F       sda$extend_reqmem(symptr,&symptr,4);	/* Get next symbol block */  '       continue;					/* skip this one */e      }      break;n     }(2     case LIB$K_CLI_LOCAL_SYM:			/* Locals only? */     {d?      if (sym.SYM_W_PROCLEVEL < 0)		/* Level < 0 means global */_      {F       sda$extend_reqmem(symptr,&symptr,4);	/* Get next symbol block */  '       continue;					/* skip this one */l      }      break;w     }s    }=    /* Copy remaining symbol data (symbol name and value) into J       buffer for further processing. They start at offset SYM_T_SYMBOL. */  J    sda$extend_reqmem(symptr+SYM_T_SYMBOL_OFF,symdatbuf,sym.SYM_W_SIZE-34);  ?    /* Display info about this symbol, depending on its type. */s      switch(sym.SYM_B_TYPE)a    {     case SYM_K_STRING:     case SYM_K_PERM:     case SYM_K_PROCESS_CONTEXT:d     case SYM_K_CLUSYS_CONTEXT:F     case SYM_K_BINARY: {disp_gen_symb(&sym,symdatbuf,ful_flg); break;}  E     case SYM_K_LABEL: {disp_lbl_symb(&sym,symdatbuf,ful_flg); break;}d  w     default: sda$extend_print(desc("%CLUE-W-UNKSYMTYP, unknown symbol type !UB at address !XL"),sym.SYM_B_TYPE,symptr);_    }%    cnt++;					/* Increment counter */$  D    sda$extend_reqmem(symptr,&symptr,4);		/* Get next symbol block */   }0,   hashaddr += 8;				/* Point to next hash */  -   hashcnt++;					/* Increment hash counter */*  }6  sda$extend_skip_lines(1);	 		/* Print summary info */  7  sda$extend_print(desc("Total of !UW symbol!%S."),cnt);s    /* That's all. */ },   /***  ***/r   int proc_bufobs(int pcbptr)  {wD  /* Given a PCB address, this routine displays information about allE     buffer objectes owned by the process. Buffer objects are recorded!C     in the PCB at offset PCB$Q_BUFOBJ_LIST in a double-linked list./F     For counting purposes, the routine returns the # of buffer objects0     found. If an error occurs, it returns -1. */  M  char noacc[] = "%CLUE-W-NOACC, cannot access buffer object data structures";m  L  char accmodtab[4][8] = {"kernel","exec","super","user"}; /* Access modes */  (  char bitbuf[20];		/* Buffer for bits */  !  int objhdr,			/* Chain header */P*      curobj,			/* Current buffer object */0      cnt = 0;			/* Count of buffered objects. */  /  struct __PCB pcb;		/* Buffer to receive PCB */   ?  struct __BOD bod;		/* Buffer to receive BOD (buffer object) */s  )  struct	bittab			/* Buffer object bits */B*    bodbittab[3] = {BOD$M_DELPEN, "delpen", 		   BOD$M_NOQUOTA,"noquota",  		   0,0};	/  L /* -------------------------> WE START HERE <---------------------------- */  8  /* Copy PCB. Display error and return if this fails. */  8  if (!(sda$extend_trymem(pcbptr,&pcb,PCB$K_LENGTH) & 1))  {    sda$extend_print(desc(noacc));     return -1;  }   /* Get chain header address. */  '  objhdr = pcbptr+PCB$Q_BUFOBJ_LIST_OFF;t  &  /* Get ptr to first buffer object. */  %  sda$extend_trymem(objhdr,&curobj,4);   %  /* If 0, return (may be SWAPPER). */r  
  if (!curobj)i  {    sda$extend_print(desc(noacc));     return -1;  }M  /* Try until end of list (forward pointer points to listhead) is reached. */Q    while (curobj != objhdr)I  {.   sda$extend_reqmem(curobj,&bod,BOD$S_BODDEF);  +   /* Translate flag bits to text string. */   3   translate_bits(bodbittab,bod.BOD$W_FLAGS,bitbuf);u  -   /* Display all info about buffer object. */a  O   sda$extend_print(desc("!XL  !XL  !XL  !XL   !4AZ   !4XW  !4UW  !4UW  !14AZ"),  		curobj,			/* BOD address */]! 		bod.BOD$L_PID,		/* owner PID */s. 		bod.BOD$L_BASEPVA,	/* process-specific VA */$ 		bod.BOD$L_BASESVA,	/* system VA */0 		accmodtab[bod.BOD$B_ACMODE],	/* Access mode */) 		bod.BOD$L_SEQNUM,	/* sequence number */1) 		bod.BOD$W_REFCNT,	/* reference count */s; 		bod.BOD$L_PAGCNT,	/* Size of buffer object (phys pags) */L% 		bitbuf);		/* Bits in BOD$W_FLAGS */p  +   cnt++;				/* Increment object counter. */d  A   sda$extend_reqmem(curobj,&curobj,4);	/* Point to next object */m  }(  return cnt;			/* Return # of objects */ }   	 /******/a  D void disp_gen_symb(struct __SYM *symptr,char *symdatbuf,int ful_flg) {cE  /* This routine display a general-purpose symbol (string or binary).,  
     Input:8 	symptr:		a pointer to the symbol block (first 34 bytes)5 	symdatbuf: 	a pointer to the symbol's name and valuev: 	ful_flg:	if 1, all info about the symbols is displayed */    char *ptr,				/* Aux ptr */%       wrkbuf[40],			/* work buffer */ -       dispbuf[300];			/* Buffer to display */s  '  short len;				/* Unique name length */n  !  int *i_ptr;				/* Aux int ptr */"  4  memset(dispbuf,0,300);			/* clear display buffer */  B  /* If this is an abbreviated symbol (one with a '*' in the name),?     the offset SYM_W_NOUNIQUE contains the characters followingt     the '*'. */     if (symptr->SYM_W_NOUNIQUE)  {C   len = symdatbuf[0] - symptr->SYM_W_NOUNIQUE;	/* compute length */o  D   strncat(dispbuf,&symdatbuf[1],len);		/* copy first part of name */  ,   strcat(dispbuf,"*");				/* append a '*' */  S   strncat(dispbuf,&symdatbuf[len+1],symptr->SYM_W_NOUNIQUE); /* copy second part */s  }N  else strncat(dispbuf,&symdatbuf[1],symdatbuf[0]); /* else copy entire name */  A  /* Symbol data starts with ASCIC symbol name string, followed byT8     word-counted symbol value string. Adjust pointer. */  $  ptr = symdatbuf + symdatbuf[0] + 1;  B  /* If this is a global symbol, display '==', else display '='. */  9  if (symptr->SYM_W_PROCLEVEL < 0) strcat(dispbuf," == ");$    else strcat(dispbuf," = ");  <  /* Display string data for string and permanent symbols. */  *  if (symptr->SYM_B_TYPE == SYM_K_STRING ||&      symptr->SYM_B_TYPE == SYM_K_PERM)  {/   /* Symbol value is displayed under quotes. */o     strcat(dispbuf,"\"");   #   /* Append symbol value string. */;     strncat(dispbuf,ptr+2,*ptr);     strcat(dispbuf,"\"");S  }  else   {6   /* For numeric symbols, display the binary value. */     i_ptr = (int*) ptr;A  F   sprintf(wrkbuf,"%d  Hex = %08X  Oct = %011o",*i_ptr,*i_ptr,*i_ptr);      strcat(dispbuf,wrkbuf);   }E  /* If /FULL is specified, display some other information as well. */]  
  if (ful_flg)l  {#   len = 0;					/* Use it as flag */g     switch (symptr->SYM_B_TYPE)    { ?    case SYM_K_PERM: {strcat(dispbuf,"   [perm"); len=1; break;}8      case SYM_K_PROCESS_CONTEXT:    case SYM_K_CLUSYS_CONTEXT:     {B     /* The offset SYM_L_CONTEXT contains a pointer to the symbol's1        context block. Display it, if non-zero. */8        sprintf(wrkbuf,"   [%s_ctx",E 	    symptr->SYM_B_TYPE == SYM_K_PROCESS_CONTEXT ? "prc" : "clusys");k       strcat(dispbuf,wrkbuf);a       if (symptr->SYM_L_CONTEXT)     {_3      sprintf(wrkbuf,"=%08X",symptr->SYM_L_CONTEXT);t        strcat(dispbuf,wrkbuf);     }a     len = 1;  
     break;    }   } ?   /* For local symbols, display procedure level in addition. */_  #   if (symptr->SYM_W_PROCLEVEL >= 0)a   {eH    /* If we have already info, append a comma, else start with a '['. */       if (len) strcat(dispbuf,",");      else strcat(dispbuf,"   [");r  6    sprintf(wrkbuf,"level=%d",symptr->SYM_W_PROCLEVEL);      strcat(dispbuf,wrkbuf);      len = 1;r   }e$   /* Append the ']', if required. */     if (len) strcat(dispbuf,"]");/  }G  /* Print the entire line. We use !AF instead of !AZ to substitute non-"%     printable characters by a dot. */M  9  sda$extend_print(desc("  !AF"),strlen(dispbuf),dispbuf);) }e  	 /******/!  D void disp_lbl_symb(struct __SYM *symptr,char *symdatbuf,int ful_flg) {_4  /* Label symbols contain the following information:  F     o - a word, which mostly contains the value 6 (don't know its use,,         we call it 'control value' here; andK     o - 6 bytes RFA (record file address) of the associated procedure file.   C     These symbols are always local (there a no 'global' labels) andz      always have unique names. */  1  short *shrtptr,			/* Pointer to control value */]'        *rfaptr;				/* Pointer to RFA */c     char *ptr;				/* Aux pointer */  6  /* Unless /FULL is given, display short info only. */    if (!ful_flg)  {6   sda$extend_print(desc("  !AC = [label]"),symdatbuf);  	   return;   }*  /* Adjust pointer to display contents. */  ?  ptr = symdatbuf + symdatbuf[0] + 1;	/* Point to symbol data */,  d?  shrtptr = (short*) ptr;		/* Points to the control value now */u  /  ptr += 2;				/* Point to the first RFA byte */r  /  rfaptr = (short*) ptr;			/* Set RFA pointer */X    sda$extend_print(desc("  !AC = [label,level=!UB,Ctrl=!XW,RFA=(!XW,!XW,!XW)]"),symdatbuf,symptr->SYM_W_PROCLEVEL,*shrtptr,*rfaptr,*(rfaptr+1),*(rfaptr+2));* }a  	 /******/   D void disp_key_symb(struct __SYM *symptr,char *symdatbuf,int ful_flg) {<   char *ptr;				/* Aux pointer */  6  /* Unless /FULL is given, display short info only. */    if (!ful_flg)  {7   sda$extend_print(desc("  !AC = [keypad]"),symdatbuf);s  	   return;e  }+  /* Adjust pointer to annalyze contents. */n  ?  ptr = symdatbuf + symdatbuf[0] + 1;	/* Point to symbol data */] }l