 /**  * clrref()	- Clear device reference count  *A  *	If you've ever seen a LAT port owned by a nonexistent process, ?  *	you've wondered how to eliminate it without a system reboot.   *D  *	This program will assign a channel to a device, set the ownershipF  *	to be its own, set the reference count down to 1, and then deassignF  *	the channel.  Poof, magic, it's all fixed.  Of course crashes couldE  *	occur if any outstanding I/O ever completes, but that's the beauty 
  *	of VMS.  *	  *	Usage: %  *	$ clrref == "$location:clrref.exe"   *	$ clrref [device]  *6  *      Ehud Gavron             gavron@Spades.ACES.COM  *?  *	V1.0.0	20-Oct-1992	Ehud Gavron	Ported my MACRO-32 version to   *						alpha DEC C.  */    #define module_name CLRREF #define module_vers "V1.0.0"   #ifdef __alpha& #pragma module module_name module_vers #else /* __vax */  #module module_name module_vers  #endif /* __alpha */  D #include "ccbdef.h"	/* Channel Control Block offsets (to get UCB) */H #include <descrip.h>	/* Descriptor Structure Definitions (for prompt) */? #include <devdef.h>	/* Device defintions (for allocated bit) */ D #include "pcbdef.h"	/* Process Control Block offsets (to get PID) */G #include <prvdef.h>	/* Privilege definitions (to get BYPASS and _IO) */ H #include "orbdef.h"	/* Object Resource Block offsets (to clear owner) */I #include <ssdef.h>	/* System Service status values (for normal status) */ D #include "ucbdef.h"	/* Unit Control Block offsets (miscellaneous) */  5 #define check	if(!(sav_stat & 1)) sys$exit(sav_stat); 
 int sav_stat;  int channel; struct dsc$descriptor_s device;  char devbuf[32]; int privmsk[2];   $DESCRIPTOR(prompt,"_Device: "); int ucb;  H int lib$get_foreign(),sys$setprv(),sys$assign(),sys$cmkrnl(),sys$exit(), 	sys$dassgn();  int channel_to_ucb(),clrref_k(); #ifdef __alpha main()   #else  /* __vax   */ cmain()  #endif /* __alpha */ { ) 	device.dsc$a_pointer = (char *) &devbuf; ' 	device.dsc$w_length  = sizeof(devbuf); & 	device.dsc$b_class   = DSC$K_CLASS_S;& 	device.dsc$b_dtype   = DSC$K_DTYPE_T;  0 	/* Get the device name from the command line */D 	sav_stat = lib$get_foreign(&device,&prompt,&device.dsc$w_length,0); 	check;    	/* Enable privileges */  9 	privmsk[0] = PRV$M_BYPASS | PRV$M_PHY_IO | PRV$M_LOG_IO; ' 	sav_stat = sys$setprv(1,&privmsk,0,0);  	check;   % 	/* Assign a channel to the device */ / 	sav_stat = sys$assign(&device,&channel,0,0,0);  	check;  	  	  	/* Get UCB address from CCB */   	ucb = channel_to_ucb(&channel); 	if (ucb >= 0) sys$exit(ucb);   I 	/* Call the kernel-mode routine to set the reference count and owner */	 # 	sav_stat = sys$cmkrnl(clrref_k,0);  	check;    	/* Deassign the channel */   	sav_stat = sys$dassgn(channel); 	check;    	return(SS$_NORMAL); }    /*"  * clrref_k	- The kernel mode code  *  */ 
 clrref_k() { ! 	char	*pucb;	/* Pointer to UCB */ ! 	char 	*orb;	/* Pointer to ORB */  #ifdef __alpha7 	int	*refc;	/* pointer to reference count - longword */  #else /* __vax */ / 	short 	*refc;	/* pointer to reference count */  #endif< 	long  *p,*q;	/* pointer to owner pid and other longwords */1 	char  *u;	/* pointer to ucb and other buffers */ ! 	char  *pcb;	/* pointer to pcb */  #ifdef __alpha #pragma nostandard #endif 	globalref ctl$gl_pcb; #ifdef __alpha #pragma standard #endif   	/* Set reference count to 1 */  	pucb = (char *)ucb;' #if defined(__alpha) || defined(__ia64) + 	refc = (int *)((char *)&pucb[UCB$L_REFC]);  #else /* __vax */ - 	refc = (short *)((char *)&pucb[UCB$W_REFC]);  #endif 	*refc = 1;    	/* Clear the allocated bit */, 	p = (long *)((char *)&pucb[UCB$L_DEVCHAR]); 	*p = *p & (~DEV$M_ALL);% 	/* Set us as the owner in the UCB */ ( 	p = (long *)((char *)&pucb[UCB$L_PID]); 	pcb = (char *)ctl$gl_pcb;.         q = (long *)((char *)&pcb[PCB$L_PID]);	 	*p = *q;    	/* Get orb address */+ 	orb = (char *)(*(long *)&pucb[UCB$L_ORB]); % 	/* Set us as the owner in the ORB */ ) 	p = (long *)((char *)&orb[ORB$L_OWNER]); .         q = (long *)((char *)&pcb[PCB$L_UIC]);	 	*p = *q;  	  	return(SS$_NORMAL); }  /* CHANNEL_TO_UCB.MAR:   1 	.iif ndf $ccbdef, .library "sys$Library:lib.mlb"  	.iif ndf ccb$l_ucb, $ccbdef, 	.link "sys$system:sys.stb"/selective_search  .         .entry  channel_to_ucb,^m<r2,r3,r4,r5>C         movzwl  @4(ap),r0                       ; Get channel in R0 ?         jsb     g^ioc$verifychan                ; Get CCB in R1 ?         blbc    r0,10$                          ; Quit on error G         movl    ccb$l_ucb(r1),r0                ; Get UCB address in R0  10$:         ret  	.end  */