 #ifdef VAXC   #module CHKQUO "BOL-V1.0/OCT-95" #else ' #pragma module CHKQUO "BOL-V1.0/OCT-95"  #endif  : /* This routine checks the MAXJOBS and MAXACCTJOBS quotas.  ;    (P) 1995 by Ing. Ferry Bolhr (bol@adv.magwien.gv.at) */   2 #include ssdef			/* SS$_xxx system status codes */< #include starlet		/* SYS$xxx() system service definitions */* #include string			/* strxxx() functions */  @ #include "chklgidef.h"		/* CHKLGI$_xxx login source constants */@ #include "lgibufdef.h"		/* LGIBUF structure field definitions */9 #include "lgimsgdef.h"		/* LGI$_xxx login status codes */   8 int _getquo();			/* Kernel-mode routine to obtain values 				   for quota checks */ /***  ***/    /*** CHKQUO() ***/ /*** ======== ***/   /* Input arguments:   B    lgi:  Login buffer containing further information. By reference        Return codes:  + 	SS$_NORMAL:    account quota validation ok   0 	LGI$_USEREXC:  too many processes for this user  3 	LGI$_ACNTEXC:  too many processes for this account   " 	Any other error code returned by:   	o - System Service: SYS$CMKRNL     */  F int chkquo(struct LGIBUF* lgi)	/* Buffer containing UAF information */ {   char -  accnam[8],			/* blank-filled account name */ *  usrnam[12];			/* blank-filled username */    int  status,			/* Return status */6  acccnt,			/* # of processes with this account name */2  usrcnt,			/* # of processes with this username */8  netusrcnt;			/* # of network jobs with this username */  /  struct				/* Kernel-mode routine parameters */   {
   int prmcnt;    char* accptr;    char* usrptr;    void* cntptr1;   void* cntptr2;   void* cntptr3;	  } k_prm;   C  /* If the MAXJOBS and MAXACCTJOBS are both zero (user has no login 5     quota limits), we can skip all further checks. */   >  if (!lgi->W_MAXJOBS && !lgi->W_MAXACCJOBS) return SS$_NORMAL;  D  /* Obtain the current # of processes for username and account name.E     This must be done in kernel mode. First, initialize the structure 6     passed as parameter to the kernel-mode routine. */  &  k_prm.prmcnt = 5;		/* 5 parameters */+  k_prm.accptr = accnam;		/* Account name */ '  k_prm.usrptr = usrnam;		/* Username */ E  k_prm.cntptr1 = &acccnt;	/* Curr # of proc with this account name */ A  k_prm.cntptr2 = &usrcnt;	/* Curr # of proc with this username */ % 			   	/* (excluding network jobs) */ L  k_prm.cntptr3 = &netusrcnt;	/* Curr # of network jobs with this username */  (  /* Prepare the blank-filled strings. */  %  memset (accnam,0x20,sizeof(accnam));   5  memcpy (accnam,lgi->T_ACCNAM,strlen(lgi->T_ACCNAM));   %  memset (usrnam,0x20,sizeof(usrnam));   5  memcpy (usrnam,lgi->T_USRNAM,strlen(lgi->T_USRNAM));   9  /* Call the kernel-mode routine to obtain the values. */   H  if ((status = sys$cmkrnl(_getquo,&k_prm)) != SS$_NORMAL) return status;  =  /* Since we simulate a new logon with a new process, we must %     increment the counters for it. */   
  acccnt++;  3  if (lgi->L_LGISRC == CHKLGI$_NETWORK) netusrcnt++;     else usrcnt++;   A  /* By convention, the first four network jobs aren't counted. */     switch (netusrcnt)   {!   case 0: {netusrcnt = 0; break;}   	   case 1: 	   case 2: 	   case 3: !   case 4: {netusrcnt = 1; break;}      default: netusrcnt -= 4;  }  G  /* The total number of processes with the given username is the sum of (     usrcnt and the updated netusrcnt. */    usrcnt += netusrcnt;   E  /* Now check for expired quotas, unless the user has disabled it. */   0  if (!(lgi->L_IFLAGS & CHKLGI$M_SKP_MAXACC_CHK))  {K   if (lgi->W_MAXACCJOBS && acccnt > lgi->W_MAXACCJOBS) return LGI$_ACNTEXC;   }0  if (!(lgi->L_IFLAGS & CHKLGI$M_SKP_MAXUSR_CHK))  {E   if (lgi->W_MAXJOBS && usrcnt > lgi->W_MAXJOBS) return LGI$_USEREXC;   }  /* OK, that's all. */    return SS$_NORMAL;  } 