 #ifdef VAXC   #module CHKLGI "BOL-V1.0/OCT-95" #else ' #pragma module CHKLGI "BOL-V1.0/OCT-95"  #endif  = /* This is the main part of the CHKLGI (check login) routine.   <    (P) 1995 by Ing. Ferry Bolhr (bol@adv.magwien.gv.at). */  * #include ctype				/* toupper() function */4 #include descrip			/* Definitions for descriptors */, #include jpidef				/* JPI$_xxx item codes */; #include lib$routines			/* LIB$xxx() routine definitions */ 7 #include prvdef				/* PRV$_xxx privilege definitions */ , #include ssdef				/* SS$_xxx status codes */2 #include starlet			/* SYS$xxx() system services */6 #include stdlib				/* Standard C library defintions */0 #include stdio				/* Standard I/O definitions */+ #include string				/* strxxx() functions */ ( #include uaidef				/* UAI$M_xxx flags */  A #include "chklgidef.h"			/* CHKLGI$_xxx login source constants */ A #include "lgibufdef.h"			/* LGIBUF structure field definitions */ : #include "lgimsgdef.h"			/* LGI$_xxx login status codes */= #include "compdepnd.h"			/* Compiler-dependend definitions */   M typedef struct dsc$descriptor_s dsc;	/* Abbreviation for descriptor struct.*/   > #define C_MAX_USRNAM	12	/* maximum length of a VMS username */@ #define C_MAX_LGIDEV	64	/* maximum login device string length */G #define C_MAX_REMINF	255	/* maximum remote information string length */ 5 #define C_MAX_PASSWD	32	/* maximum password length */     + /* External routines called by chklgi(): */   @ int getusr(char*,char*,char*,struct LGIBUF*);	/* Get username */@ int chkpwd(char*,int,int*,struct LGIBUF*);	/* Check passwords */= int chktim(int,int*,struct LGIBUF*);		/* Check login times */ 6 int chkquo(struct LGIBUF*);			/* Check login quotas */A int chkitm(struct LGIBUF*,void*);		/* Check items (qualifiers) */ 2 int chklic(struct LGIBUF*);			/* Check licenses */A int intrus(int,struct LGIBUF*);			/* Update intrusion database */ = int upduaf(int,struct LGIBUF*,int*);		/* Update UAF record */ B int audevt(int,struct LGIBUF*,int*,char*);	/* Audit login event */   /* Internal routines: */  > static int setup(dsc*,char*,short);		/* Setup input strings */@ int conlgi(struct LGIBUF*,char*);		/* Check for console login */   /*  */    /*** Main Entry CHKLGI ***/  /*** ================= ***/    /* Input arguments:   2  usrnam.....1-12 character username. By descriptor  A  lgidev.....1-64 character login device (terminal). By descriptor   =  reminf.....1-255 character remote information. By descriptor   0  paswd1.....1-32 primary password. By descriptor  2  paswd2.....1-32 secondary password. By descriptor  -  lgisrc.....Login source (type). By reference   +  lgitim.....Binary login time. By reference   $  lgiday.....Login day. By reference   '  flags......Control flags. By reference   )  initmlst...Input item list. By reference   *  outitmlst..Output item list. By reference      Return codes:  / 	SS$_NORMAL:	all checks performed successfully.   * 	SS$_NOAUDIT:	AUDIT privilege is required.  , 	SS$_NOCMKRNL:	CMKRNL privilege is required.  . 	SS$_SECURITY:	SECURITY privilege is required.  , 	SS$_NOSYSPRV:	SYSPRV privilege is required.  :         SS$_BADPARAM:	a string argument is too long or has- 			incorrect format or the given login source ) 			is invalid or an invalid item code was 
 			specified.   >         SS$_CONFQUAL:	an invalid argument combination (missing' 			or conflicting arguments) was given.   2 	LGI$_ACNTEXC:	too many processes for this account  + 	LGI$_ACNTEXPIR:	user's account has expired   / 	LGI$_AUTOLOGIN:	account is for auto-login only    * 	LGI$_BADDAY:	no login allowed at this day  , 	LGI$_BADHOUR:	no login allowed at this time  8 	LGI$_CAPTIVE:	no qualifiers allowed in captive accounts  3 	LGI$_CLIFAIL:	error activating command interpreter   = 	LGI$_CLITBLFAIL: error activating command interpreter tables   9 	LGI$_DECWCAPTIVE: no DECwindows login on captive account   + 	LGI$_DISRECONNEC: no reconnections allowed   ) 	LGI$_DISUSER:	user's account is disabled   4 	LGI$_DEFCLI:	CLI-related qualifiers are not allowed  ) 	LGI$_EVADE:	Breakin evasion is in effect   9 	LGI$_EXLICENSE:	licensed number of system users exceeded   ; 	LGI$_EXQUOTA:	maximum number of interactive users exceeded   > 	LGI$_INVINPUT:	the name given in the 'lgidev' argument is not, 			a (known) terminal or workstation device.  * 	LGI$_INVPWD:	given password doesn't match  ; 	LGI$_LICNOTREQ:	no license check required for this process   : 	LGI$_LOGDISABL:	interactive logins are currently disabled  8 	LGI$_LOGOPRCON:	no VMS or VMSCLUSTER license found, but  			logins are allowed from OPA0:  ; 	LGI$_PWDEXPIR:	password in UAF is marked as (pre-) expired   = 	LGI$_NOSUCHUSER: the given username wasn't found in the UAF.   6 	LGI$_NOTVALID:	either there was no correspondig proxy. 			(remote/network logins) or no corresponding- 			record in the ALF database (local logins).   C 	LGI$_NOVAXCLUSTER: no (valid) VMSCLUSTER(VAXCLUSTER) license found   0 	LGI$_RESTRICT	no login allowed from this source  / 	LGI$_USEREXC:	too many processes for this user      @         Any other error codes returned by these system services:  ) 	SYS$AUDIT_EVENTW	SYS$CMKRNL		SYS$GETDVIW * 	SYS$GETTIM		SYS$GETUAI		SYS$GRANT_LICENSE1 	SYS$HASH_PASSWORD	SYS$IMGACT		SYS$LOOKUP_LICENSE 2 	SYS$RELEASE_LICENSE	SYS$SCAN_INTRUSION	SYS$SETUAI 	SYS$VERIFY_PROXY   =         Any other error codes returned by these RMS services:   /         SYS$CONNECT	SYS$CLOSE	SYS$GET 	SYS$OPEN   =         Any other error codes returned by these RTL routines:    * 	LIB$ADD_TIMES		LIB$CVT_FROM_INTERNAL_TIME( 	LIB$DAY_OF_WEEK		LIB$GETJPI		LIB$GETSYI    */  , int chklgi     (dsc* usrnam,		/* Username */" 		dsc* lgidev,		/* Login Device */6 		dsc* reminf,		/* Remote Node::User or Server/Port */& 		dsc* paswd1,		/* Primary Password */( 		dsc* paswd2,		/* Secondary Password */) 		int* lgisrc,		/* Login Source (Type) */   		int* lgitim,		/* Login Time */ 		int* lgiday,		/* Login Day */ % 		int* flags,		/* Processing Flags */ ( 		void *initmlst,		/* Input item list */) 		void *outitmlst)	/* Output item list */  {   char :  usrnambuf[14], *usrnamptr = NULL,	/* Auxiliary buffers */5  lgidevbuf[66], *lgidevptr = NULL,	/* and pointers */ "  reminfbuf[256],*reminfptr = NULL,  paswd1buf[32],   paswd2buf[32];     int&  tmp,					/* Holds temporary values */  status,				/* Return status */ %  prcsts,				/* Process status bits */ (  curtim[2] = {0,0},			/* Current time */  logday = 0,				/* Login day */ %  privs[2];				/* Process privieges */   2  $DESCRIPTOR(usr,usrnambuf);		/* Aux descriptor */  =  struct LGIBUF lgi;			/* Buffer to receive UAF information */     /*  */    /* START OF CHKLGI */  /* =============== */  '  /* Clear buffer to receive UAF info */   &  memset(&lgi,0,sizeof(struct LGIBUF));  9  /* If a login time was specified by the user, use it. */   2  if (lgitim != (int*) 0) memcpy (curtim,lgitim,8);  #  /* Otherwise, use current time. */     if (!curtim[0] || !curtim[1])  @  if ((status = sys$gettim(curtim)) != SS$_NORMAL) return status;  9  /* Obtain privileges to see whether user may call us. */   C  if ((status = lib$getjpi(&JPI$_PROCPRIV,0,0,privs)) != SS$_NORMAL)      return status;  ?  /* We require SYSPRV, CMKRNL and AUDIT privileges at least. */   5  if (!(privs[0] & PRV$M_SYSPRV)) return SS$_NOSYSPRV;   5  if (!(privs[0] & PRV$M_CMKRNL)) return SS$_NOCMKRNL;   3  if (!(privs[1] & PRV$M_AUDIT)) return SS$_NOAUDIT;   B  /* Copy the given flags and login source into our work buffer. */  /  lgi.L_IFLAGS = flags != (int*) 0 ? *flags : 0;   1  lgi.L_LGISRC = lgisrc != (int*) 0 ? *lgisrc : 3;   E  /* If the user specified the CHKLGI$M_NO_AUDIT or CHKLGI$M_INTRUSION 8     flags, we require SECURITY privilege in addition. */  L  if ((lgi.L_IFLAGS & CHKLGI$M_NO_AUDIT || lgi.L_IFLAGS & CHKLGI$M_INTRUSION)?       && (!(privs[1] & PRV$M_SECURITY))) return SS$_NOSECURITY;   1  /* Setup buffers and store the given strings. */     if (usrnam != (dsc*) 0)  {G   if (!(setup(usrnam,usrnambuf,C_MAX_USRNAM)) & 1) return SS$_BADPARAM;   /   if (strlen(usrnambuf)) usrnamptr = usrnambuf;   }  if (lgidev != (dsc*) 0)  {G   if (!(setup(lgidev,lgidevbuf,C_MAX_LGIDEV)) & 1) return SS$_BADPARAM;   /   if (strlen(lgidevbuf)) lgidevptr = lgidevbuf;   }  if (reminf != (dsc*) 0)  {G   if (!(setup(reminf,reminfbuf,C_MAX_REMINF)) & 1) return SS$_BADPARAM;   /   if (strlen(reminfbuf)) reminfptr = reminfbuf;   }!  /* Pre-init password buffers. */     paswd1buf[0] = '\0';     if (paswd1 != (dsc*) 0)  {G   if (!(setup(paswd1,paswd1buf,C_MAX_PASSWD)) & 1) return SS$_BADPARAM;   }  paswd2buf[0] = '\0';     if (paswd2 != (dsc*) 0)  {G   if (!(setup(paswd2,paswd2buf,C_MAX_PASSWD)) & 1) return SS$_BADPARAM;   }H  /* Since we may audit the password later (in case of breakin evasions),H     setup a template string which is used when no password was supplied.E     This string is eventually overwritten with the incorrect password      by chkpwd(). */      strcpy(lgi.T_PASSWD,"<valid>");   /*  */   F  /* Well, let's go... first, we have to find an entry in the UAF whichF     we can use for all checks. This entry may be given in the 'usrnam'F     argument, but may also obtained either by the ALF (automatic loginG     facility) or, in the case of network jobs, by proxy processing. The &     routine getusr() will do this job.  F     Perform all checks within a pseudo-loop. This allows to abort flowE     of control with a simple 'break' and avoids the use of goto's. */   
  while (1)  {+   /* Obtain username for further checks. */   6   status = getusr(usrnamptr,lgidevptr,reminfptr,&lgi);  G   /* If the status is success, we've found a username and may continue. 0      Otherwise, we must do one of the following:  G      If the status is a failure code from a system or RMS service, just       return it to the user.   E      Otherwise, it is a LGI$_xxxx error code. Break here, the rest is ,      done at the end of this pseudo loop. */     if (status != SS$_NORMAL)    { D    if (status < LGI$_FACILITY) return status; /* return VMS error */      else break;   } 1   /* Update username descriptor for later use. */   #   usr.dsc$a_pointer = lgi.T_USRNAM;   *   usr.dsc$w_length = strlen(lgi.T_USRNAM);   /***  ***/   (   /* Perform password-related checks. */  +   status = chkpwd(paswd1buf,0,curtim,&lgi);      if (status != SS$_NORMAL)    { D    if (status < LGI$_FACILITY) return status; /* return VMS error */      else break;   } +   status = chkpwd(paswd2buf,1,curtim,&lgi);      if (status != SS$_NORMAL)    { D    if (status < LGI$_FACILITY) return status; /* return VMS error */      else break;   }    /*  */   I   /* Account-related checks. The account must not be disabled or expired. <      These checks are bypassed for system console logins. */  8   if (!conlgi(&lgi,lgi.T_USRNAM))			/* If not console */   { G    if (!(lgi.L_IFLAGS & CHKLGI$M_SKP_DISACC_CHK))	/* and not to skip */     {9     if (lgi.L_FLAGS & UAI$M_DISACNT)			/* and disabled */      { /      status = LGI$_DISUSER;				/* then abort */         break;      }     }F    /* To see whether the account is expired, compare the given/current/       time with the account expiration time. */    6    if (lgi.Q_EXPTIM[1])			/* if exp time set in UAF */    {H     if (!(lgi.L_IFLAGS & CHKLGI$M_SKP_EXPACC_CHK)) /* and not to skip */     { ;      if (lgi.Q_EXPTIM[1] < curtim[1] || 		/* and expired */ G          (lgi.Q_EXPTIM[1] == curtim[1] && lgi.Q_EXPTIM[0] < curtim[0]))       {1       status = LGI$_ACNTEXPIR;			/* then abort */          break;      }     }     }   } D   /* Check for auto-login only account. This is done for interactive       and network logins only. */  M   if (lgi.L_LGISRC >= CHKLGI$_INTERACTIVE || lgi.L_LGISRC == CHKLGI$_NETWORK)    { E    if (!(lgi.L_IFLAGS & CHKLGI$M_AUTO_LOGIN))	/* If not auto-login */     {G     if (!(lgi.L_IFLAGS & CHKLGI$M_SKP_ALOGIN_CHK))/* and not to skip */      { B      if (lgi.L_FLAGS & UAI$M_AUTOLOGIN)		/* and auto-login only */      {1       status = LGI$_AUTOLOGIN;			/* then abort */          break;      }     }     }   } ?   /* DECwindows logins aren't allowed with captive accounts. */   D   if (lgi.L_LGISRC == CHKLGI$_DECWINDOWS)		/* If DECwindows login */   { G    if (!(lgi.L_IFLAGS & CHKLGI$M_SKP_DWICAP_CHK))	/* and not to skip */     {=     if (lgi.L_FLAGS & UAI$M_CAPTIVE ||			/* and captive or */ 3 	lgi.L_FLAGS & UAI$M_RESTRICTED)			/* restricted */      { .      status = LGI$_DECWCAPTIVE;				/* abort */        break;      }     }   }    /*  */   J   /* Login-time and login-source related checks. These checks are bypassed"      for system console logins. */  !   if (!conlgi(&lgi,lgi.T_USRNAM))    { ,    /* If login day was specified, use it. */      if (lgiday != (int*) 0)    {     if (*lgiday)     { +      /* Login day must be in range 1...7 */   9      if (*lgiday > 7 || *lgiday < 0) return SS$_BADPARAM;         logday = *lgiday;     }     }'    status = chktim(logday,curtim,&lgi);       if (status != SS$_NORMAL)    {E     if (status < LGI$_FACILITY) return status; /* return VMS error */        else break;     }   }      /*  */   F   /* Login-quota-related checks. If the interactive login limit is setH      to 0, no further logins are allowed. This is also true if the limitI      is set to <n>, but there are <n> users logged in already. This check G      is made for interactive logins only and is bypassed if the account +      has the default OPER privilege set. */   @   if (!(lgi.Q_DEFPRIV[0] & PRV$M_OPER))			/* If not OPER priv */   { H    if (lgi.L_LGISRC >= CHKLGI$_INTERACTIVE)		/* and interactive login */    {C     if (IJOBCNT > (short) SYS$GW_IJOBLIM)		/* and quota exceeded */      { C      /* If the limit was set to 0 (SET LOGIN/INTERACTIVE=0), return B         LGI$_LOGDISABL; otherwise return LGI$_EXQUOTA. Both checks 	may be suppressed. */  !      if (!(short) SYS$GW_IJOBLIM)       {4       if (!(lgi.L_IFLAGS & CHKLGI$M_SKP_LGIDIS_CHK))       {         status = LGI$_LOGDISABL;   
        break;        }       }	      else       {4       if (!(lgi.L_IFLAGS & CHKLGI$M_SKP_MAXINT_CHK))       {         status = LGI$_EXQUOTA;   
        break;        }       }     }     }   } B   /* Check for maximum number of processes for the given username.?      Network jobs are included here, but the first four network A      jobs are "free" (not counted). This check is bypassed if the 7      process has the PRC$M_NOACNT bit set in PCB$L_STS.   ?      In addition, check for maximum number of processes for the B      user's account. Network jobs are not counted here. This check?      is bypassed if the process has the PRC$M_NOACNT bit set in       PCB$L_STS. */  P   if ((status = lib$getjpi(&JPI$_STS,0,0,&prcsts)) != SS$_NORMAL) return status;     if (!(prcsts & PCB$M_NOACNT))    {     status = chkquo(&lgi);       if (status != SS$_NORMAL)    {E     if (status < LGI$_FACILITY) return status; /* return VMS error */        else break;     }     }    /*  */   H   /* Check for qualifiers specified in command line. This is emulated by       the 'initmlst' argument. */  >   if (initmlst != (void*) 0)			/* If input items were spec. */   { 9    status = chkitm(&lgi,initmlst);		/* check for items */       if (status != SS$_NORMAL)    {E     if (status < LGI$_FACILITY) return status; /* return VMS error */        else break;     }   }    /*  */   .   /* Check for licenses. This check occurs for       interactive logins only. */   B   if (!(lgi.L_IFLAGS & CHKLGI$M_SKP_LIC_CHK))	/* If not to skip */   { G    if (lgi.L_LGISRC >= CHKLGI$_INTERACTIVE)	/* and interactive login */     {:     status = chklic(&lgi);			/* then check for licenses */       if (!(status & 1))     { F      if (status < LGI$_FACILITY) return status; /* return VMS error */        else break;     }     }   } ;   /* FINISH! All checks done, terminate the pseudo-loop. */      break;  } /*  */   A  /* Now update the intrusion database, if user requested it. This '     will not occur for batch logins. */   '  if (lgi.L_IFLAGS & CHKLGI$M_INTRUSION)   {$   if (lgi.L_LGISRC != CHKLGI$_BATCH)   {      status = intrus(status,&lgi);      if (!(status & 1))   D    if (status < LGI$_FACILITY) return status; /* return VMS error */   }   }7  /* If user requested it, update UAF record as well. */"  (  if (lgi.L_IFLAGS & CHKLGI$M_UPDATE_UAF)  {&   status = upduaf(status,&lgi,curtim);     if (!(status & 1))  C   if (status < LGI$_FACILITY) return status; /* return VMS error */d  }*  /* Unless suppressed, audit the event. */  )  if (!(lgi.L_IFLAGS & CHKLGI$M_NO_AUDIT))i  {0   status = audevt(status,&lgi,curtim,lgidevptr);     if (!(status & 1))  C   if (status < LGI$_FACILITY) return status; /* return VMS error */e  }K  /* Finally, if requested by the user, return UAF information, as specifiedo#     in the 'outitmlst' argument. */(    if (outitmlst != (void*) 0)  {.   tmp = sys$getuai (0,0,&usr,outitmlst,0,0,0);  >   if (tmp != SS$_NORMAL) return tmp;	/* Return getuai error */  }8  return status;				/* Otherwise, return actual status */ }    /*  */"  5 static int setup(dsc *val,char *buf, short maxlength)  {c@  /* Copy string from descriptor to private buffer and convert it8     to uppercase. Also check for maximum allowed length.     Return 1, if ok, else 0. */l  -  if (val->dsc$w_length > maxlength) return 0;c  3  strncpy(buf,val->dsc$a_pointer,val->dsc$w_length);t    buf[val->dsc$w_length] = '\0';m  
  while (*buf)a  {   *buf = toupper(*buf);A     buf++;  }
  return 1; }v   /*  */l  + int conlgi(struct LGIBUF *lgi,char *usrnam)e {e8 /* Returns true, id console login occurs, else false. */  "  if (!(strcmp(usrnam,"SYSTEM")) &&4      !(strcmp(lgi->T_PHYDEVNAM,"_OPA0:"))) return 1;    else return 0;s }c