 #include "ckcsym.h"  #ifndef NOCSETS < char *xlav = "Character Set Translation 5A(022), 24 Jan 94";   /*  C K U X L A  */   K /*  C-Kermit tables and functions supporting character set translation.  */  /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   /*I   CAVEAT PROGRAMMATOR: The mechanism used herein turns out to be somewhat G   inflexible and maybe a little dangerous.  It is designed for Kermit's G   character-at-a-time processing during protocol operations.  Elaborate K   kludges are used for translating one character into two (like stuffing an K   extra character into the input stream), or two into one, or two into two.   J   The whole translation business might be redesigned to be string-orientedB   rather than character oriented, so (a) we can have more flexibleN   translations, and (b) we don't have to be concerned about which input streamB   we are using.  The current mechanism is also quite inappropriateJ   for multibyte character sets and for flexible user-defined translations.  D   For the future: perhaps it would be better to represent charactersJ   internally using a universal character set like UNICODE (ISO 10646 BMP),3   the ultimate "transfer character set" (or not)...  */' #include "ckcdeb.h"			/* Includes... */  #include "ckcker.h"  #include "ckucmd.h"  #include "ckcxla.h"   2 /* Character set translation data and functions */  8 extern int zincnt;			/* File i/o macros and variables */ extern char *zinptr; extern int zoutcnt;  extern char *zoutptr;   ; int tslevel  = TS_L0;			/* Transfer syntax level (0,1,2) */ > int tcharset = TC_TRANSP;		/* Transfer syntax character set */? int tcsr     = FC_USASCII;		/* Remote terminal character set */ ) int language = L_USASCII;		/* Language */    /*0   Default local file and terminal character set.9   Normally ASCII, but for some systems we know otherwise.  */. #ifdef datageneral			/* Data General AOS/VS */= int fcharset = FC_DGMCS;		/* uses the DG International set */  int tcsl     = FC_DGMCS; #else ) #ifdef NEXT				/* The NeXT workstation */ 6 int fcharset = FC_NEXT;			/* uses its own 8-bit set */ int tcsl     = FC_NEXT;  #else ! #ifdef MAC				/* The Macintosh */ ; int fcharset = FC_APPQD;		/* uses an extended version of */ / int tcsl     = FC_APPQD;		/* Apple Quickdraw */  #else 
 #ifdef AUX4 int fcharset = FC_APPQD;		/* Ditto for Apple A/UX */ int tcsl     = FC_APPQD; #else ) #ifdef AMIGA				/* The Commodore Amiga */ - int fcharset = FC_1LATIN;		/* uses Latin-1 */  int tcsl     = FC_1LATIN;  #else					/* All others */6 int fcharset = FC_USASCII;		/* use ASCII by default */ int tcsl     = FC_USASCII; #endif /* AMIGA */ #endif /* AUX */ #endif /* MAC */ #endif /* NEXT */  #endif /* datageneral */   /* Bureaucracy section */   8 _PROTOTYP( CHAR xnel1, (CHAR c) );	/* NeXT to Latin-1 */= _PROTOTYP( CHAR xl143, (CHAR c) );	/* Latin-1 to IBM CP437 */ < _PROTOTYP( CHAR xl1as, (CHAR c) );	/* Latin-1 to US ASCII */< _PROTOTYP( CHAR zl1as, (CHAR c) );	/* Latin-1 to US ASCII */   #ifdef CYRILLIC ; _PROTOTYP( CHAR xassk, (CHAR c) );	/* ASCII to Short KOI */ D _PROTOTYP( CHAR xskcy, (CHAR c) );	/* Short KOI to Latin/Cyrillic */ #endif /* CYRILLIC */   
 #ifdef LATIN2 8 _PROTOTYP( CHAR xnel2, (CHAR c) );	/* NeXT to Latin-2 */= _PROTOTYP( CHAR xl243, (CHAR c) );	/* Latin-2 to IBM CP437 */ < _PROTOTYP( CHAR xl2as, (CHAR c) );	/* Latin-2 to US ASCII */< _PROTOTYP( CHAR zl2as, (CHAR c) );	/* Latin-2 to US ASCII */6 _PROTOTYP( CHAR xl2r8, (CHAR c) );	/* Latin-2 to HP */ #endif /* LATIN2 */   ! /* Transfer character-set info */    struct csinfo tcsinfo[] = { N /*  Name              size code      designator alphabet keyword            */N   "TRANSPARENT",       256,TC_TRANSP, "",      AL_UNK,  "transparent", /* 0 */N   "ASCII",             128,TC_USASCII,"",      AL_ROMAN,"ascii",       /* 1 */N   "LATIN1, ISO 8859-1",256,TC_1LATIN, "I6/100",AL_ROMAN,"latin1-iso",  /* 2 */
 #ifdef LATIN2 N   "LATIN2, ISO 8859-2",256,TC_2LATIN, "I6/101",AL_ROMAN,"latin2-iso",  /* 3 */ #endif /* LATIN2 */  #ifdef CYRILLIC O   "CYRILLIC, ISO 8859-5",256,TC_CYRILL,"I6/144",AL_CYRIL,"cyrillic-iso",/* 4 */  #endif /* CYRILLIC */  #ifdef KANJIO   "KANJI (EUC)", 16384,TC_JEUC,  "I14/87/13", AL_JAPAN, "japanese-euc", /* 5 */  #endif /* KANJI */
 #ifdef HEBREW O   "HEBREW, ISO 8859-8",256,TC_HEBREW,"I6/138",AL_HEBREW,"hebrew-iso"    /* 6 */  #endif /* HEBREW */  };8 int ntcsets = (sizeof(tcsinfo) / sizeof(struct csinfo));  3 struct keytab tcstab[] = {		/* Keyword table for */ D     "ascii",         TC_USASCII, 0,	/* SET TRANSFER CHARACTER-SET */ #ifdef CYRILLIC #     "cyrillic-iso",  TC_CYRILL,  0,  #endif /* CYRILLIC */ 
 #ifdef HEBREW #     "hebrew-iso",    TC_HEBREW,  0,  #endif /* HEBREW */  #ifdef KANJI#     "japanese-euc",  TC_JEUC,    0,  #endif /* KANJI */
 #ifdef LATIN2  /*C   If Latin-2 is defined, let the following be invisible, non-unique    abbreviations for LATIN1.  *//     "l",             TC_1LATIN,  CM_ABR|CM_INV, /     "la",            TC_1LATIN,  CM_ABR|CM_INV, /     "lat",           TC_1LATIN,  CM_ABR|CM_INV, /     "lati",          TC_1LATIN,  CM_ABR|CM_INV, /     "latin",         TC_1LATIN,  CM_ABR|CM_INV,  #endif /* LATIN2 */ #     "latin1-iso",    TC_1LATIN,  0, 
 #ifdef LATIN2 #     "latin2-iso",    TC_2LATIN,  0,  #endif /* LATIN2 */ "     "transparent",   TC_TRANSP,  0 };4 int ntcs = (sizeof(tcstab) / sizeof(struct keytab));  N /* File character set information structure, indexed by character set code, */L /* as defined in ckuxla.h.  This table must be in order of file character */ /* set number! */   C struct csinfo fcsinfo[] = { /* File character set information... */ 6   /* Descriptive Name              Size  Designator */K   "US ASCII",                     128, FC_USASCII, NULL, AL_ROMAN, "ascii", M   "British/UK ISO-646",           128, FC_UKASCII, NULL, AL_ROMAN, "british", K   "Dutch ISO-646",                128, FC_DUASCII, NULL, AL_ROMAN, "dutch", M   "Finnish ISO-646",              128, FC_FIASCII, NULL, AL_ROMAN, "finnish", L   "French ISO-646",               128, FC_FRASCII, NULL, AL_ROMAN, "french",L   "Canadian-French NRC", 128, FC_FCASCII, NULL, AL_ROMAN, "canadian-french",L   "German ISO-646",               128, FC_GEASCII, NULL, AL_ROMAN, "german",O   "Hungarian ISO-646",            128, FC_HUASCII, NULL, AL_ROMAN, "hungarian", M   "Italian ISO-646",              128, FC_ITASCII, NULL, AL_ROMAN, "italian", M   "Norwegian/Danish ISO-646",128,FC_NOASCII,NULL,AL_ROMAN,"norwegian/danish", O   "Portuguese ISO-646",           128, FC_POASCII, NULL, AL_ROMAN,"portuguese", M   "Spanish ISO-646",              128, FC_SPASCII, NULL, AL_ROMAN, "spanish", M   "Swedish ISO-646",              128, FC_SWASCII, NULL, AL_ROMAN, "swedish", K   "Swiss NRC",                    128, FC_CHASCII, NULL, AL_ROMAN, "swiss", O   "ISO 8859-1 Latin-1",           256, FC_1LATIN,  NULL, AL_ROMAN,"latin1-iso", 
 #ifdef LATIN2 O   "ISO 8859-2 Latin-2",           256, FC_2LATIN,  NULL, AL_ROMAN,"latin2-iso",  #endif /* LATIN2 */ J   "DEC Multinational", 256,  FC_DECMCS, NULL,AL_ROMAN,"dec-multinational",K   "NeXT Multinational", 256, FC_NEXT,   NULL,AL_ROMAN,"next-multinational", J   "IBM Code Page 437",            256, FC_CP437,   NULL, AL_ROMAN,"cp437",J   "IBM Code Page 850",            256, FC_CP850,   NULL, AL_ROMAN,"cp850",
 #ifdef LATIN2 J   "IBM Code Page 852",            256, FC_CP852,   NULL, AL_ROMAN,"cp852", #endif /* LATIN2 */ M   "Apple Macintosh Latin", 256, FC_APPQD,   NULL, AL_ROMAN,"macintosh-latin", M   "Data General International",256,FC_DGMCS,NULL,AL_ROMAN,"dg-international", K   "Hewlett Packard Roman8",    256, FC_HPR8,    NULL, AL_ROMAN, "hp-roman8"  #ifdef CYRILLIC N , "ISO 8859-5 Latin/Cyrillic", 256, FC_CYRILL,  NULL, AL_CYRIL,"cyrillic-iso",C   "CP866 Cyrillic",	       256, FC_CP866,   NULL, AL_CYRIL,"cp866", K   "Short KOI",                 128, FC_KOI7,    NULL, AL_CYRIL,"short-koi", N   "Old KOI-8 Cyrillic",        256, FC_KOI8,    NULL, AL_CYRIL,"koi8-cyrillic" #endif /* CYRILLIC */  #ifdef KANJIE , "Japanese JIS7",	    256, FC_JIS7,    NULL, AL_JAPAN, "jis7-kanji", O   "Japanese Shift JIS",	  16384, FC_SHJIS,   NULL, AL_JAPAN, "shift-jis-kanji", F   "Japanese EUC",	  16384, FC_JEUC,    NULL, AL_JAPAN, "japanese-euc",H   "Japanese DEC Kanji",	  16384, FC_JDEC,    NULL, AL_JAPAN, "dec-kanji" #endif /* KANJI */
 #ifdef HEBREW I , "Hebrew-7 DEC",           128, FC_HE7,     NULL, AL_HEBREW, "hebrew-7", K   "ISO 8859-8 Latin/Hebrew",256, FC_HEBREW,  NULL, AL_HEBREW, "hebrew-iso", L   "CP862 Hebrew",           256, FC_CP862,   NULL, AL_HEBREW, "cp862-hebrew" #endif /* HEBREW */  };       /* Local file character sets */ C /* Includes 7-bit National Replacement Character Sets of ISO 646 */ L /* Plus ISO Latin-1, DEC Multinational Character Set (MCS), NeXT char set */  K struct keytab fcstab[] = { /* Keyword table for 'set file character-set' */    /*K   IMPORTANT: This table is replicated below as ttcstab (terminal character  C   set table).  The only differences are the addition of TRANSPARENT A   and the removal of the Kanji sets, which are not supported yet. 9   If you make changes to this table, also change ttcstab.  */  + /* Keyword             Value       Flags */ C     "apple-quickdraw",    FC_APPQD,   CM_INV, /* Apple Quickdraw */ 4     "ascii",              FC_USASCII, 0, /* ASCII */:     "british",            FC_UKASCII, 0, /* British NRC */B     "canadian-french",    FC_FCASCII, 0, /* French Canadian NRC */7     "cp437",              FC_CP437,   0, /* PC CP437 */ 7     "cp850",              FC_CP850,   0, /* PC CP850 */ 
 #ifdef LATIN2 7     "cp852",              FC_CP852,   0, /* PC CP852 */  #endif /* LATIN2 */ 
 #ifdef HEBREW 7     "cp862-hebrew",       FC_CP862,   0, /* PC CP862 */  #endif /* HEBREW */  #ifdef CYRILLIC =     "cp866-cyrillic",     FC_CP866,   0, /* CP866 Cyrillic */ J     "cyrillic-iso",       FC_CYRILL,  0, /* ISO Latin/Cyrillic Alphabet */ #endif /* CYRILLIC */ G     "danish",             FC_NOASCII, 0, /* Norwegian and Danish NRC */  #ifdef KANJIA     "dec-kanji",          FC_JDEC,    0, /* Japanese DEC Kanji */  #endif /* KANJI */N     "dec-multinational",  FC_DECMCS,  0, /* DEC multinational character set */I     "dg-international",   FC_DGMCS,   0, /* Data General multinational */ 8     "dutch",              FC_DUASCII, 0, /* Dutch NRC */:     "finnish",            FC_FIASCII, 0, /* Finnish NRC */9     "french",             FC_FRASCII, 0, /* French NRC */ G     "fr-canadian",        FC_FCASCII, CM_INV, /* French Canadian NRC */ 9     "german",             FC_GEASCII, 0, /* German NRC */ 
 #ifdef HEBREW 4     "he",                 FC_HEBREW,  CM_ABR|CM_INV,4     "heb",                FC_HEBREW,  CM_ABR|CM_INV,4     "hebr",               FC_HEBREW,  CM_ABR|CM_INV,4     "hebre",              FC_HEBREW,  CM_ABR|CM_INV,4     "hebrew",             FC_HEBREW,  CM_ABR|CM_INV,?     "hebrew-7",           FC_HE7,     0, /* DEC 7-Bit Hebrew */ ?     "hebrew-iso",         FC_HEBREW,  0, /* ISO Latin/Hebrew */  #endif /* HEBREW */ E     "hp-roman8",          FC_HPR8,    0, /* Hewlett Packard Roman8 */ <     "hungarian",          FC_HUASCII, 0, /* Hungarian NRC */:     "italian",            FC_ITASCII, 0, /* Italian NRC */ #ifdef KANJI;     "japanese-euc",       FC_JEUC,    0, /* Japanese EUC */ F     "jis7-kanji",         FC_JIS7,    0, /* Japanese JIS7 7bit code */ #endif /* KANJI */ #ifdef CYRILLIC A     "koi8-cyrillic",      FC_KOI8,    0, /* Old KOI-8 Cyrillic */  #endif /* CYRILLIC */ 
 #ifdef LATIN2 4     "l",                  FC_1LATIN,  CM_ABR|CM_INV,4     "la",                 FC_1LATIN,  CM_ABR|CM_INV,4     "lat",                FC_1LATIN,  CM_ABR|CM_INV,4     "lati",               FC_1LATIN,  CM_ABR|CM_INV,4     "latin",              FC_1LATIN,  CM_ABR|CM_INV, #endif /* LATIN2 */ C     "latin1-iso",         FC_1LATIN,  0, /* ISO Latin Alphabet 1 */ 
 #ifdef LATIN2 C     "latin2-iso",         FC_2LATIN,  0, /* ISO Latin Alphabet 2 */  #endif /* LATIN2 */ C     "macintosh-latin",    FC_APPQD,   0, /* "Extended Mac Latin" */ ?     "next-multinational", FC_NEXT,    0, /* NeXT workstation */ G     "norwegian",          FC_NOASCII, 0, /* Norwegian and Danish NRC */ =     "portuguese",         FC_POASCII, 0, /* Portuguese NRC */  #ifdef KANJIG     "shift-jis-kanji",    FC_SHJIS,   0, /* Japanese Kanji Shift-JIS */  #endif /* KANJI */ #ifdef CYRILLIC A     "short-koi",          FC_KOI7,    0, /* Short KOI Cyrillic */  #endif /* CYRILLIC */ :     "spanish",            FC_SPASCII, 0, /* Spanish NRC */:     "swedish",            FC_SWASCII, 0, /* Swedish NRC */8     "swiss",              FC_CHASCII, 0	 /* Swiss NRC */ };N int nfilc = (sizeof(fcstab) / sizeof(struct keytab)); /* size of this table */    N struct keytab ttcstab[] = { /* Keyword table for SET TERMINAL CHARACTER-SET */ /*K   IMPORTANT: This table is a replica of fcstab, immediately above, with the G   addition of TRANSPARENT.  If you make changes to this table, make the "   corresponding changes to fcstab. */- /* Keyword               Value       Flags */ C     "apple-quickdraw",    FC_APPQD,   CM_INV, /* Apple Quickdraw */ 4     "ascii",              FC_USASCII, 0, /* ASCII */:     "british",            FC_UKASCII, 0, /* British NRC */B     "canadian-french",    FC_FCASCII, 0, /* French Canadian NRC */8     "cp437",              FC_CP437,   0, /* IBM CP437 */8     "cp850",              FC_CP850,   0, /* IBM CP850 */
 #ifdef LATIN2 8     "cp852",              FC_CP852,   0, /* IBM CP852 */ #endif /* LATIN2 */ 
 #ifdef HEBREW 7     "cp862-hebrew",       FC_CP862,   0, /* PC CP862 */  #endif /* HEBREW */  #ifdef CYRILLIC =     "cp866-cyrillic",     FC_CP866,   0, /* CP866 Cyrillic */ J     "cyrillic-iso",       FC_CYRILL,  0, /* ISO Latin/Cyrillic Alphabet */ #endif /* CYRILLIC */ G     "danish",             FC_NOASCII, 0, /* Norwegian and Danish NRC */  #ifdef COMMENT #ifdef KANJIA     "dec-kanji",          FC_JDEC,    0, /* Japanese DEC Kanji */  #endif /* KANJI */ #endif /* COMMENT */N     "dec-multinational",  FC_DECMCS,  0, /* DEC multinational character set */I     "dg-international",   FC_DGMCS,   0, /* Data General multinational */ 8     "dutch",              FC_DUASCII, 0, /* Dutch NRC */:     "finnish",            FC_FIASCII, 0, /* Finnish NRC */9     "french",             FC_FRASCII, 0, /* French NRC */ G     "fr-canadian",        FC_FCASCII, CM_INV, /* French Canadian NRC */ 9     "german",             FC_GEASCII, 0, /* German NRC */ 
 #ifdef HEBREW 4     "he",                 FC_HEBREW,  CM_ABR|CM_INV,4     "heb",                FC_HEBREW,  CM_ABR|CM_INV,4     "hebr",               FC_HEBREW,  CM_ABR|CM_INV,4     "hebre",              FC_HEBREW,  CM_ABR|CM_INV,4     "hebrew",             FC_HEBREW,  CM_ABR|CM_INV,?     "hebrew-7",           FC_HE7,     0, /* DEC 7-Bit Hebrew */ ?     "hebrew-iso",         FC_HEBREW,  0, /* ISO Latin/Hebrew */  #endif /* HEBREW */ E     "hp-roman8",          FC_HPR8,    0, /* Hewlett Packard Roman8 */ <     "hungarian",          FC_HUASCII, 0, /* Hungarian NRC */:     "italian",            FC_ITASCII, 0, /* Italian NRC */ #ifdef COMMENT7 /* Kanji terminal character sets not implemented yet */  #ifdef KANJI;     "japanese-euc",       FC_JEUC,    0, /* Japanese EUC */ F     "jis7-kanji",         FC_JIS7,    0, /* Japanese JIS7 7bit code */ #endif /* KANJI */ #endif /* COMMENT */ #ifdef CYRILLIC A     "koi8-cyrillic",      FC_KOI8,    0, /* Old KOI-8 Cyrillic */  #endif /* CYRILLIC */ 
 #ifdef LATIN2 4     "l",                  FC_1LATIN,  CM_ABR|CM_INV,4     "la",                 FC_1LATIN,  CM_ABR|CM_INV,4     "lat",                FC_1LATIN,  CM_ABR|CM_INV,4     "lati",               FC_1LATIN,  CM_ABR|CM_INV,4     "latin",              FC_1LATIN,  CM_ABR|CM_INV, #endif /* LATIN2 */ C     "latin1-iso",         FC_1LATIN,  0, /* ISO Latin Alphabet 1 */a
 #ifdef LATIN2aC     "latin2-iso",         FC_2LATIN,  0, /* ISO Latin Alphabet 2 */A #endif /* LATIN2 */aB     "macintosh-latin",    FC_APPQD,   0, /* "Extended Mac Latin */?     "next-multinational", FC_NEXT,    0, /* NeXT workstation */fG     "norwegian",          FC_NOASCII, 0, /* Norwegian and Danish NRC */e=     "portuguese",         FC_POASCII, 0, /* Portuguese NRC */a #ifdef COMMENT8 /* Kanji terminal character sets not implemented yet. */ #ifdef KANJIG     "shift-jis-kanji",    FC_SHJIS,   0, /* Japanese Kanji Shift-JIS */p #endif /* KANJI */ #endif /* COMMENT */ #ifdef CYRILLICbA     "short-koi",          FC_KOI7,    0, /* Short KOI Cyrillic */r #endif /* CYRILLIC */c:     "spanish",            FC_SPASCII, 0, /* Spanish NRC */:     "swedish",            FC_SWASCII, 0, /* Swedish NRC */8     "swiss",              FC_CHASCII, 0, /* Swiss NRC */:     "transparent",        FC_TRANSP,  0  /* Transparent */ };K int ntermc = (sizeof(ttcstab) / sizeof(struct keytab)); /* size of table */    /*  Languages:n  K  This table allows C-Kermit to have a SET LANGUAGE command to apply specialtL  language-specific rules when translating from a character set that containsG  national characters into plain ASCII, like German umlaut-a becomes ae.d  N  Originally, I thought it would be a good idea to let SET LANGUAGE also selectL  an appropriate FILE CHARACTER-SET and TRANSFER CHARACTER-SET automatically,N  and these are included in the langinfo structure.  Later I realized that thisI  was a bad idea.  Users are confused by unexpected side effects.  If thiskB  functionality is desired, it's better to define a macro to do it. */   struct langinfo langs[] = {h5 /*  Language code   File Charset Xfer Charset Name */"I     L_USASCII,      FC_USASCII,  TC_USASCII,  "ASCII (American English)",u7     L_DANISH,       FC_NOASCII,  TC_1LATIN,   "Danish", 6     L_DUTCH,        FC_DUASCII,  TC_1LATIN,   "Dutch",8     L_FINNISH,      FC_FIASCII,  TC_1LATIN,   "Finnish",7     L_FRENCH,       FC_FRASCII,  TC_1LATIN,   "French",	7     L_GERMAN,       FC_GEASCII,  TC_1LATIN,   "German",S
 #ifdef HEBREWt7     L_HEBREW,       FC_HEBREW,   TC_HEBREW,   "Hebrew",/ #endif /* HEBREW */ :     L_HUNGARIAN,    FC_HUASCII,  TC_2LATIN,   "Hungarian",:     L_ICELANDIC,    FC_USASCII,  TC_1LATIN,   "Icelandic",8     L_ITALIAN,      FC_ITASCII,  TC_1LATIN,   "Italian", #ifdef KANJI9     L_JAPANESE,     FC_JEUC,     TC_JEUC,     "Japanese",  #endif /* KANJI */:     L_NORWEGIAN,    FC_NOASCII,  TC_1LATIN,   "Norwegian",;     L_PORTUGUESE,   FC_POASCII,  TC_1LATIN,   "Portuguese",  #ifdef CYRILLICT8     L_RUSSIAN,      FC_CP866,    TC_CYRILL,   "Russian", #endif /* CYRILLIC */n8     L_SPANISH,      FC_SPASCII,  TC_1LATIN,   "Spanish",8     L_SWEDISH,      FC_SWASCII,  TC_1LATIN,   "Swedish",5     L_SWISS,        FC_CHASCII,  TC_1LATIN,   "Swiss"	 };7 int nlangs = (sizeof(langs) / sizeof(struct langinfo));s   /*-   Keyword table for the SET LANGUAGE command.*G   Only a few of these (German, Scandinavian, etc) actually do anything.nJ   The language is used to invoke special translation rules when convertingG   from an 8-bit character set to ASCII; for example, German u-diaeresisiM   becomes "ue", Dutch y-diaeresis becomes "ij".  Languages without associatedC   rules are invisible (CM_INV).  */ struct keytab lngtab[] = {-     "ascii",            L_USASCII,    CM_INV, (     "danish",           L_DANISH,     0,(     "dutch",            L_DUTCH,      0,-     "english",          L_USASCII,    CM_INV,o(     "finnish",          L_FINNISH,    0,(     "french",           L_FRENCH,     0,(     "german",           L_GERMAN,     0,
 #ifdef HEBREWn-     "hebrew",           L_HEBREW,     CM_INV,Y #endif /* HEBREW */    ;-     "hungarian",        L_HUNGARIAN,  CM_INV,l(     "icelandic",        L_ICELANDIC,  0,-     "italian",          L_ITALIAN,    CM_INV,  #ifdef KANJI-     "japanese",         L_JAPANESE,   CM_INV,  #endif /* KANJI */(     "norwegian",        L_NORWEGIAN,  0,(     "none",             L_USASCII,    0,-     "portuguese",       L_PORTUGUESE, CM_INV,l #ifdef CYRILLIC (     "russian",          L_RUSSIAN,    0, #endif /* CYRILLIC */,-     "spanish",          L_SPANISH,    CM_INV, '     "swedish",          L_SWEDISH,    0, #ifdef CYRILLIC ' ,   "ukrainian",        L_RUSSIAN,    00 #endif /* CYRILLIC */" };M int nlng = (sizeof(lngtab) / sizeof(struct keytab)); /* how many languages */,     /* Translation tables ... */   /*J   For each pair of (transfer,file) character sets, we need two translation0   functions, one for sending, one for receiving. */   /*?   Here is the first table, Latin-1 to ASCII, fully annotated...jH   This one is absolutely NOT invertible, since we're going from an 8-bit@   set to a 7-bit set.  Accented letters are mapped to unaccentedD   equivalents, C1 control characters are all translated to "?", etc. */ CHAR: yl1as[] = {  /* ISO 8859-1 Latin Alphabet 1 to US ASCII */I       /*  Source character    Description               => Translation */dF       /*  Dec row/col Set                                           */F   0,  /*  000  00/00  C0 NUL  Ctrl-@                    =>  (self)  */F   1,  /*  001  00/01  C0 SOH  Ctrl-A                    =>  (self)  */F   2,  /*  002  00/02  C0 STX  Ctrl-B                    =>  (self)  */F   3,  /*  003  00/03  C0 ETX  Ctrl-C                    =>  (self)  */F   4,  /*  004  00/04  C0 EOT  Ctrl-D                    =>  (self)  */F   5,  /*  005  00/05  C0 ENQ  Ctrl-E                    =>  (self)  */F   6,  /*  006  00/06  C0 ACK  Ctrl-F                    =>  (self)  */F   7,  /*  007  00/07  C0 BEL  Ctrl-G                    =>  (self)  */F   8,  /*  008  00/08  C0 BS   Ctrl-H                    =>  (self)  */F   9,  /*  009  00/09  C0 HT   Ctrl-I                    =>  (self)  */F  10,  /*  010  00/10  C0 LF   Ctrl-J                    =>  (self)  */F  11,  /*  011  00/11  C0 VT   Ctrl-K                    =>  (self)  */F  12,  /*  012  00/12  C0 FF   Ctrl-L                    =>  (self)  */F  13,  /*  013  00/13  C0 CR   Ctrl-M                    =>  (self)  */F  14,  /*  014  00/14  C0 SO   Ctrl-N                    =>  (self)  */F  15,  /*  015  00/15  C0 SI   Ctrl-O                    =>  (self)  */F  16,  /*  016  01/00  C0 DLE  Ctrl-P                    =>  (self)  */F  17,  /*  017  01/01  C0 DC1  Ctrl-Q                    =>  (self)  */F  18,  /*  018  01/02  C0 DC2  Ctrl-R                    =>  (self)  */F  19,  /*  019  01/03  C0 DC3  Ctrl-S                    =>  (self)  */F  20,  /*  020  01/04  C0 DC4  Ctrl-T                    =>  (self)  */F  21,  /*  021  01/05  C0 NAK  Ctrl-U                    =>  (self)  */F  22,  /*  022  01/06  C0 SYN  Ctrl-V                    =>  (self)  */F  23,  /*  023  01/07  C0 ETB  Ctrl-W                    =>  (self)  */F  24,  /*  024  01/08  C0 CAN  Ctrl-X                    =>  (self)  */F  25,  /*  025  01/09  C0 EM   Ctrl-Y                    =>  (self)  */F  26,  /*  026  01/10  C0 SUB  Ctrl-Z                    =>  (self)  */F  27,  /*  027  01/11  C0 ESC  Ctrl-[                    =>  (self)  */F  28,  /*  028  01/12  C0 FS   Ctrl-\                    =>  (self)  */F  29,  /*  029  01/13  C0 GS   Ctrl-]                    =>  (self)  */F  30,  /*  030  01/14  C0 RS   Ctrl-^                    =>  (self)  */F  31,  /*  031  01/15  C0 US   Ctrl-_                    =>  (self)  */F  32,  /*  032  02/00     SP   Space                     =>  (self)  */F  33,  /*  033  02/01  G0 !    Exclamation mark          =>  (self)  */F  34,  /*  034  02/02  G0 "    Doublequote               =>  (self)  */F  35,  /*  035  02/03  G0 #    Number sign               =>  (self)  */F  36,  /*  036  02/04  G0 $    Dollar sign               =>  (self)  */F  37,  /*  037  02/05  G0 %    Percent sign              =>  (self)  */F  38,  /*  038  02/06  G0 &    Ampersand                 =>  (self)  */F  39,  /*  039  02/07  G0 '    Apostrophe                =>  (self)  */F  40,  /*  040  02/08  G0 (    Left parenthesis          =>  (self)  */F  41,  /*  041  02/09  G0 )    Right parenthesis         =>  (self)  */F  42,  /*  042  02/10  G0 *    Asterisk                  =>  (self)  */F  43,  /*  043  02/11  G0 +    Plus sign                 =>  (self)  */F  44,  /*  044  02/12  G0 ,    Comma                     =>  (self)  */F  45,  /*  045  02/13  G0 -    Hyphen, minus sign        =>  (self)  */F  46,  /*  046  02/14  G0 .    Period, full stop         =>  (self)  */F  47,  /*  047  02/15  G0 /    Slash, solidus            =>  (self)  */F  48,  /*  048  03/00  G0 0    Digit 0                   =>  (self)  */F  49,  /*  049  03/01  G0 1    Digit 1                   =>  (self)  */F  50,  /*  050  03/02  G0 2    Digit 2                   =>  (self)  */F  51,  /*  051  03/03  G0 3    Digit 3                   =>  (self)  */F  52,  /*  052  03/04  G0 4    Digit 4                   =>  (self)  */F  53,  /*  053  03/05  G0 5    Digit 5                   =>  (self)  */F  54,  /*  054  03/06  G0 6    Digit 6                   =>  (self)  */F  55,  /*  055  03/07  G0 7    Digit 7                   =>  (self)  */F  56,  /*  056  03/08  G0 8    Digit 8                   =>  (self)  */F  57,  /*  057  03/09  G0 9    Digit 9                   =>  (self)  */F  58,  /*  058  03/10  G0 :    Colon                     =>  (self)  */F  59,  /*  059  03/11  G0 ;    Semicolon                 =>  (self)  */F  60,  /*  060  03/12  G0 <    Less-than sign            =>  (self)  */F  61,  /*  061  03/13  G0 =    Equals sign               =>  (self)  */F  62,  /*  062  03/14  G0 >    Greater-than sign         =>  (self)  */F  63,  /*  063  03/15  G0 ?    Question mark             =>  (self)  */F  64,  /*  064  04/00  G0 @    Commercial at sign        =>  (self)  */F  65,  /*  065  04/01  G0 A    Letter A                  =>  (self)  */F  66,  /*  066  04/02  G0 B    Letter B                  =>  (self)  */F  67,  /*  067  04/03  G0 C    Letter C                  =>  (self)  */F  68,  /*  068  04/04  G0 D    Letter D                  =>  (self)  */F  69,  /*  069  04/05  G0 E    Letter E                  =>  (self)  */F  70,  /*  070  04/06  G0 F    Letter F                  =>  (self)  */F  71,  /*  071  04/07  G0 G    Letter G                  =>  (self)  */F  72,  /*  072  04/08  G0 H    Letter H                  =>  (self)  */F  73,  /*  073  04/09  G0 I    Letter I                  =>  (self)  */F  74,  /*  074  04/10  G0 J    Letter J                  =>  (self)  */F  75,  /*  075  04/11  G0 K    Letter K                  =>  (self)  */F  76,  /*  076  04/12  G0 L    Letter L                  =>  (self)  */F  77,  /*  077  04/13  G0 M    Letter M                  =>  (self)  */F  78,  /*  078  04/14  G0 N    Letter N                  =>  (self)  */F  79,  /*  079  04/15  G0 O    Letter O                  =>  (self)  */F  80,  /*  080  05/00  G0 P    Letter P                  =>  (self)  */F  81,  /*  081  05/01  G0 Q    Letter Q                  =>  (self)  */F  82,  /*  082  05/02  G0 R    Letter R                  =>  (self)  */F  83,  /*  083  05/03  G0 S    Letter S                  =>  (self)  */F  84,  /*  084  05/04  G0 T    Letter T                  =>  (self)  */F  85,  /*  085  05/05  G0 U    Letter U                  =>  (self)  */F  86,  /*  086  05/06  G0 V    Letter V                  =>  (self)  */F  87,  /*  087  05/07  G0 W    Letter W                  =>  (self)  */F  88,  /*  088  05/08  G0 X    Letter X                  =>  (self)  */F  89,  /*  089  05/09  G0 Y    Letter Y                  =>  (self)  */F  90,  /*  090  05/10  G0 Z    Letter Z                  =>  (self)  */F  91,  /*  091  05/11  G0 [    Left square bracket       =>  (self)  */F  92,  /*  092  05/12  G0 \    Reverse slash             =>  (self)  */F  93,  /*  093  05/13  G0 ]    Right square bracket      =>  (self)  */F  94,  /*  094  05/14  G0 ^    Circumflex accent         =>  (self)  */F  95,  /*  095  05/15  G0 _    Underline, low line       =>  (self)  */F  96,  /*  096  06/00  G0 `    Grave accent              =>  (self)  */F  97,  /*  097  06/01  G0 a    Letter a                  =>  (self)  */F  98,  /*  098  06/02  G0 b    Letter b                  =>  (self)  */F  99,  /*  099  06/03  G0 c    Letter c                  =>  (self)  */F 100,  /*  100  06/04  G0 d    Letter d                  =>  (self)  */F 101,  /*  101  06/05  G0 e    Letter e                  =>  (self)  */F 102,  /*  102  06/06  G0 f    Letter f                  =>  (self)  */F 103,  /*  103  06/07  G0 g    Letter g                  =>  (self)  */F 104,  /*  104  06/08  G0 h    Letter h                  =>  (self)  */F 105,  /*  105  06/09  G0 i    Letter i                  =>  (self)  */F 106,  /*  106  06/10  G0 j    Letter j                  =>  (self)  */F 107,  /*  107  06/11  G0 k    Letter k                  =>  (self)  */F 108,  /*  108  06/12  G0 l    Letter l                  =>  (self)  */F 109,  /*  109  06/13  G0 m    Letter m                  =>  (self)  */F 110,  /*  110  06/14  G0 n    Letter n                  =>  (self)  */F 111,  /*  111  06/15  G0 o    Letter o                  =>  (self)  */F 112,  /*  112  07/00  G0 p    Letter p                  =>  (self)  */F 113,  /*  113  07/01  G0 q    Letter q                  =>  (self)  */F 114,  /*  114  07/02  G0 r    Letter r                  =>  (self)  */F 115,  /*  115  07/03  G0 s    Letter s                  =>  (self)  */F 116,  /*  116  07/04  G0 t    Letter t                  =>  (self)  */F 117,  /*  117  07/05  G0 u    Letter u                  =>  (self)  */F 118,  /*  118  07/06  G0 v    Letter v                  =>  (self)  */F 119,  /*  119  07/07  G0 w    Letter w                  =>  (self)  */F 120,  /*  120  07/08  G0 x    Letter x                  =>  (self)  */F 121,  /*  121  07/09  G0 y    Letter y                  =>  (self)  */F 122,  /*  122  07/10  G0 z    Letter z                  =>  (self)  */F 123,  /*  123  07/11  G0 {    Left curly bracket        =>  (self)  */F 124,  /*  124  07/12  G0 |    Vertical bar              =>  (self)  */F 125,  /*  125  07/13  G0 }    Right curly bracket       =>  (self)  */F 126,  /*  126  07/14  G0 ~    Tilde                     =>  (self)  */F 127,  /*  127  07/15     DEL  Delete, Rubout            =>  (self)  */F UNK,  /*  128  08/00  C1                                =>  UNK     */F UNK,  /*  129  08/01  C1                                =>  UNK     */F UNK,  /*  130  08/02  C1                                =>  UNK     */F UNK,  /*  131  08/03  C1                                =>  UNK     */F UNK,  /*  132  08/04  C1 IND                            =>  UNK     */F UNK,  /*  133  08/05  C1 NEL                            =>  UNK     */F UNK,  /*  134  08/06  C1 SSA                            =>  UNK     */F UNK,  /*  135  08/07  C1 ESA                            =>  UNK     */F UNK,  /*  136  08/08  C1 HTS                            =>  UNK     */F UNK,  /*  137  08/09  C1                                =>  UNK     */F UNK,  /*  138  08/10  C1                                =>  UNK     */F UNK,  /*  139  08/11  C1                                =>  UNK     */F UNK,  /*  140  08/12  C1                                =>  UNK     */F UNK,  /*  141  08/13  C1 RI                             =>  UNK     */F UNK,  /*  142  08/14  C1 SS2                            =>  UNK     */F UNK,  /*  143  08/15  C1 SS3                            =>  UNK     */F UNK,  /*  144  09/00  C1 DCS                            =>  UNK     */F UNK,  /*  145  09/01  C1                                =>  UNK     */F UNK,  /*  146  09/02  C1                                =>  UNK     */F UNK,  /*  147  09/03  C1 STS                            =>  UNK     */F UNK,  /*  148  09/04  C1                                =>  UNK     */F UNK,  /*  149  09/05  C1                                =>  UNK     */F UNK,  /*  150  09/06  C1 SPA                            =>  UNK     */F UNK,  /*  151  09/07  C1 EPA                            =>  UNK     */F UNK,  /*  152  09/08  C1                                =>  UNK     */F UNK,  /*  153  09/09  C1                                =>  UNK     */F UNK,  /*  154  09/10  C1                                =>  UNK     */F UNK,  /*  155  09/11  C1 CSI                            =>  UNK     */F UNK,  /*  156  09/12  C1 ST                             =>  UNK     */F UNK,  /*  157  09/13  C1 OSC                            =>  UNK     */F UNK,  /*  158  09/14  C1 PM                             =>  UNK     */F UNK,  /*  159  09/15  C1 APC                            =>  UNK     */F  32,  /*  160  10/00  G1      No-break space            =>  SP      */F  33,  /*  161  10/01  G1      Inverted exclamation      =>  !       */F  99,  /*  162  10/02  G1      Cent sign                 =>  c       */F  35,  /*  163  10/03  G1      Pound sign                =>  #       */F  36,  /*  164  10/04  G1      Currency sign             =>  $       */F  89,  /*  165  10/05  G1      Yen sign                  =>  Y       */F 124,  /*  166  10/06  G1      Broken bar                =>  |       */F  80,  /*  167  10/07  G1      Paragraph sign            =>  P       */F  34,  /*  168  10/08  G1      Diaeresis                 =>  "       */F  67,  /*  169  10/09  G1      Copyright sign            =>  C       */F  97,  /*  170  10/10  G1      Feminine ordinal          =>  a       */F  34,  /*  171  10/11  G1      Left angle quotation      =>  "       */F 126,  /*  172  10/12  G1      Not sign                  =>  ~       */F  45,  /*  173  10/13  G1      Soft hyphen               =>  -       */F  82,  /*  174  10/14  G1      Registered trade mark     =>  R       */F  95,  /*  175  10/15  G1      Macron                    =>  _       */F 111,  /*  176  11/00  G1      Degree sign, ring above   =>  o       */F UNK,  /*  177  11/01  G1      Plus-minus sign           =>  UNK     */F  50,  /*  178  11/02  G1      Superscript two           =>  2       */F  51,  /*  179  11/03  G1      Superscript three         =>  3       */F  39,  /*  180  11/04  G1      Acute accent              =>  '       */F 117,  /*  181  11/05  G1      Micro sign                =>  u       */F  45,  /*  182  11/06  G1      Pilcrow sign              =>  -       */F  45,  /*  183  11/07  G1      Middle dot                =>  -       */F  44,  /*  184  11/08  G1      Cedilla                   =>  ,       */F  49,  /*  185  11/09  G1      Superscript one           =>  1       */F 111,  /*  186  11/10  G1      Masculine ordinal         =>  o       */F  34,  /*  187  11/11  G1      Right angle quotation     =>  "       */F UNK,  /*  188  11/12  G1      One quarter               =>  UNK     */F UNK,  /*  189  11/13  G1      One half                  =>  UNK     */F UNK,  /*  190  11/14  G1      Three quarters            =>  UNK     */F  63,  /*  191  11/15  G1      Inverted question mark    =>  ?       */F  65,  /*  192  12/00  G1      A grave                   =>  A       */F  65,  /*  193  12/01  G1      A acute                   =>  A       */F  65,  /*  194  12/02  G1      A circumflex              =>  A       */F  65,  /*  195  12/03  G1      A tilde                   =>  A       */F  65,  /*  196  12/04  G1      A diaeresis               =>  A       */F  65,  /*  197  12/05  G1      A ring above              =>  A       */F  65,  /*  198  12/06  G1      A with E                  =>  A       */F  67,  /*  199  12/07  G1      C Cedilla                 =>  C       */F  69,  /*  200  12/08  G1      E grave                   =>  E       */F  69,  /*  201  12/09  G1      E acute                   =>  E       */F  69,  /*  202  12/10  G1      E circumflex              =>  E       */F  69,  /*  203  12/11  G1      E diaeresis               =>  E       */F  73,  /*  204  12/12  G1      I grave                   =>  I       */F  73,  /*  205  12/13  G1      I acute                   =>  I       */F  73,  /*  206  12/14  G1      I circumflex              =>  I       */F  73,  /*  207  12/15  G1      I diaeresis               =>  I       */F  68,  /*  208  13/00  G1      Icelandic Eth             =>  D       */F  78,  /*  209  13/01  G1      N tilde                   =>  N       */F  79,  /*  210  13/02  G1      O grave                   =>  O       */F  79,  /*  211  13/03  G1      O acute                   =>  O       */F  79,  /*  212  13/04  G1      O circumflex              =>  O       */F  79,  /*  213  13/05  G1      O tilde                   =>  O       */F  79,  /*  214  13/06  G1      O diaeresis               =>  O       */F 120,  /*  215  13/07  G1      Multiplication sign       =>  x       */F  79,  /*  216  13/08  G1      O oblique stroke          =>  O       */F  85,  /*  217  13/09  G1      U grave                   =>  U       */F  85,  /*  218  13/10  G1      U acute                   =>  U       */F  85,  /*  219  13/11  G1      U circumflex              =>  U       */F  85,  /*  220  13/12  G1      U diaeresis               =>  U       */F  89,  /*  221  13/13  G1      Y acute                   =>  Y       */F  84,  /*  222  13/14  G1      Icelandic Thorn           =>  T       */F 115,  /*  223  13/15  G1      German sharp s            =>  s       */F  97,  /*  224  14/00  G1      a grave                   =>  a       */F  97,  /*  225  14/01  G1      a acute                   =>  a       */F  97,  /*  226  14/02  G1      a circumflex              =>  a       */F  97,  /*  227  14/03  G1      a tilde                   =>  a       */F  97,  /*  228  14/04  G1      a diaeresis               =>  a       */F  97,  /*  229  14/05  G1      a ring above              =>  a       */F  97,  /*  230  14/06  G1      a with e                  =>  a       */F  99,  /*  231  14/07  G1      c cedilla                 =>  c       */F 101,  /*  232  14/08  G1      e grave                   =>  e       */F 101,  /*  233  14/09  G1      e acute                   =>  e       */F 101,  /*  234  14/10  G1      e circumflex              =>  e       */F 101,  /*  235  14/11  G1      e diaeresis               =>  e       */F 105,  /*  236  14/12  G1      i grave                   =>  i       */F 105,  /*  237  14/13  G1      i acute                   =>  i       */F 105,  /*  238  14/14  G1      i circumflex              =>  i       */F 105,  /*  239  14/15  G1      i diaeresis               =>  i       */F 100,  /*  240  15/00  G1      Icelandic eth             =>  d       */F 110,  /*  241  15/01  G1      n tilde                   =>  n       */F 111,  /*  242  15/02  G1      o grave                   =>  o       */F 111,  /*  243  15/03  G1      o acute                   =>  o       */F 111,  /*  244  15/04  G1      o circumflex              =>  o       */F 111,  /*  245  15/05  G1      o tilde                   =>  o       */F 111,  /*  246  15/06  G1      o diaeresis               =>  o       */F  47,  /*  247  15/07  G1      Division sign             =>  /       */F 111,  /*  248  15/08  G1      o oblique stroke          =>  o       */F 117,  /*  249  15/09  G1      u grave                   =>  u       */F 117,  /*  250  15/10  G1      u acute                   =>  u       */F 117,  /*  251  15/11  G1      u circumflex              =>  u       */F 117,  /*  252  15/12  G1      u diaeresis               =>  u       */F 121,  /*  253  15/13  G1      y acute                   =>  y       */F 116,  /*  254  15/14  G1      Icelandic thorn           =>  t       */F 121   /*  255  15/15  G1      y diaeresis               =>  y       */ };    N /* Translation tables for ISO Latin Alphabet 1 to local file character sets */   /*L   Most of the remaining tables are not annotated like the one above, becauseM   the size of the resulting source file would be ridiculous.  Each row in the)9   following tables corresponds to a column of ISO 8859-1.  */   CHARM yl185[] = {  /* ISO 8859-1 Latin Alphabet 1 (Latin-1) to IBM Code Page 850 */3 /*I   This is based on IBM's official invertible translation.  Reference: IBM G   Character Data Representation Architecture (CDRA), Level 1, Registry,3M   SC09-1291-00 (1990), p.152.  (Note: Latin-1 is IBM Code Page 00819.)  Note:5L   IBM's bizarre rearrangement of C0 controls and DEL has been undone in this   table. */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,/O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,*O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,/O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, O 186, 205, 201, 187, 200, 188, 204, 185, 203, 202, 206, 223, 220, 219, 254, 242,>O 179, 196, 218, 191, 192, 217, 195, 180, 194, 193, 197, 176, 177, 178, 213, 159, O 255, 173, 189, 156, 207, 190, 221, 245, 249, 184, 166, 174, 170, 240, 169, 238, O 248, 241, 253, 252, 239, 230, 244, 250, 247, 251, 167, 175, 172, 171, 243, 168,0O 183, 181, 182, 199, 142, 143, 146, 128, 212, 144, 210, 211, 222, 214, 215, 216,5O 209, 165, 227, 224, 226, 229, 153, 158, 157, 235, 233, 234, 154, 237, 232, 225, O 133, 160, 131, 198, 132, 134, 145, 135, 138, 130, 136, 137, 141, 161, 140, 139, N 208, 164, 149, 162, 147, 228, 148, 246, 155, 151, 163, 150, 129, 236, 231, 152 };   CHAR/ y85l1[] = {  /* IBM Code Page 850 to Latin-1 */  /*@   This is from IBM CDRA page 153.  It is the inverse of yl185[].G   As of edit 183, this table is no longer pure CDRA.  The translations  2   involving C0 controls and DEL have been removed. */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,sO  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,>O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,0O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,DO 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,rO 199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 196, 197, O 201, 230, 198, 244, 246, 242, 251, 249, 255, 214, 220, 248, 163, 216, 215, 159, O 225, 237, 243, 250, 241, 209, 170, 186, 191, 174, 172, 189, 188, 161, 171, 187,)O 155, 156, 157, 144, 151, 193, 194, 192, 169, 135, 128, 131, 133, 162, 165, 147,,O 148, 153, 152, 150, 145, 154, 227, 195, 132, 130, 137, 136, 134, 129, 138, 164, O 240, 208, 202, 203, 200, 158, 205, 206, 207, 149, 146, 141, 140, 166, 204, 139,0O 211, 223, 212, 210, 245, 213, 181, 254, 222, 218, 219, 217, 253, 221, 175, 180,tN 173, 177, 143, 190, 182, 167, 247, 184, 176, 168, 183, 185, 179, 178, 142, 160 };   #ifdef COMMENT CHAR4 yl1r8[] = {  /* Latin-1 to Hewlett Packard Roman8 */< /* This is HP's official translation, straight from iconv */ /* It is NOT invertible. */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,3O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,/O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,*O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,/O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O 160, 184, 191, 187, 186, 188, 124, 189, 171,  99, 249, 251, 126,  45,  82, 176,qO 179, 254,  50,  51, 168, 243, 244, 242,  44,  49, 250, 253, 247, 248, 245, 185, O 161, 224, 162, 225, 216, 208, 211, 180, 163, 220, 164, 165, 230, 229, 166, 167,>O 227, 182, 232, 231, 223, 233, 218, 120, 210, 173, 237, 174, 219, 177, 240, 222, O 200, 196, 192, 226, 204, 212, 215, 181, 201, 197, 193, 205, 217, 213, 209, 221, N 228, 183, 202, 198, 194, 234, 206,  47, 214, 203, 199, 195, 207, 178, 241, 239 }; CHAR4 yr8l1[] = {  /* Hewlett Packard Roman8 to Latin-1 */< /* This is HP's official translation, straight from iconv */ /* It is NOT invertible. */eO   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,rO  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,)O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,0O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,tO 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O 160, 192, 194, 200, 202, 203, 206, 207, 180,  96,  94, 168, 126, 217, 219, 163,lO 175, 221, 253, 176, 199, 231, 209, 241, 161, 191, 164, 163, 165, 167, 102, 162,1O 226, 234, 244, 251, 225, 233, 243, 250, 224, 232, 242, 249, 228, 235, 246, 252,1O 197, 238, 216, 198, 229, 237, 248, 230, 196, 236, 214, 220, 201, 239, 223, 212, O 193, 195, 227, 208, 240, 205, 204, 211, 210, 213, 245,  83, 115, 218,  89, 255,eN 222, 254, 183, 181, 182, 190,  45, 188, 189, 170, 186, 171,  42, 187, 177, 160 }; #else /* !COMMENT */D /* This is an invertible mapping, approved by HP in January 1994. */ CHAR7 yl1r8[] = {  /* ISO Latin-1 to HP Roman8, Invertible */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,)O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,,O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,0O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,eO  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,NO 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,3O 160, 184, 191, 187, 186, 188, 169, 189, 171, 170, 249, 251, 172, 175, 190, 176, O 179, 254, 235, 236, 168, 243, 244, 242, 238, 246, 250, 253, 247, 248, 245, 185, O 161, 224, 162, 225, 216, 208, 211, 180, 163, 220, 164, 165, 230, 229, 166, 167, O 227, 182, 232, 231, 223, 233, 218, 252, 210, 173, 237, 174, 219, 177, 240, 222, O 200, 196, 192, 226, 204, 212, 215, 181, 201, 197, 193, 205, 217, 213, 209, 221,NN 228, 183, 202, 198, 194, 234, 206, 255, 214, 203, 199, 195, 207, 178, 241, 239 };   CHAR6 yr8l1[] = { /* HP Roman8 to ISO Latin-1, Invertible */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,,O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,1O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,NO 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,5O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O 160, 192, 194, 200, 202, 203, 206, 207, 180, 166, 169, 168, 172, 217, 219, 173, O 175, 221, 253, 176, 199, 231, 209, 241, 161, 191, 164, 163, 165, 167, 174, 162, O 226, 234, 244, 251, 225, 233, 243, 250, 224, 232, 242, 249, 228, 235, 246, 252, O 197, 238, 216, 198, 229, 237, 248, 230, 196, 236, 214, 220, 201, 239, 223, 212,NO 193, 195, 227, 208, 240, 205, 204, 211, 210, 213, 245, 178, 179, 218, 184, 255, N 222, 254, 183, 181, 182, 190, 185, 188, 189, 170, 186, 171, 215, 187, 177, 247 }; #endif /* COMMENT */   CHAR/ yl143[] = {  /* Latin-1 to IBM Code Page 437 */0 /*N   Although the IBM CDRA does not include an official translation between CP437C   and ISO Latin Alphabet 1, it does include an official, invertible K   translation between CP437 and CP850 (page 196), and another from CP850 to L   Latin-1 (CP819) (page 153).  This translation was obtained with a two-step    process based on those tables.I   As of edit 183, the translation is modified to leave C0 controls alone.* */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,iO  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,iO  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,5O 186, 205, 201, 187, 200, 188, 204, 185, 203, 202, 206, 223, 220, 219, 254, 242, O 179, 196, 218, 191, 192, 217, 195, 180, 194, 193, 197, 176, 177, 178, 213, 159,sO 255, 173, 155, 156, 207, 157, 221, 245, 249, 184, 166, 174, 170, 240, 169, 238, O 248, 241, 253, 252, 239, 230, 244, 250, 247, 251, 167, 175, 172, 171, 243, 168, O 183, 181, 182, 199, 142, 143, 146, 128, 212, 144, 210, 211, 222, 214, 215, 216,/O 209, 165, 227, 224, 226, 229, 153, 158, 190, 235, 233, 234, 154, 237, 232, 225,*O 133, 160, 131, 198, 132, 134, 145, 135, 138, 130, 136, 137, 141, 161, 140, 139,/N 208, 164, 149, 162, 147, 228, 148, 246, 189, 151, 163, 150, 129, 236, 231, 152 };   CHAR/ y43l1[] = {  /* IBM Code Page 437 to Latin-1 */1 /*'   This table is the inverse of yl143[].  */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,,O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,1O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,eO  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,tO  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,6O 199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 196, 197,9O 201, 230, 198, 244, 246, 242, 251, 249, 255, 214, 220, 162, 163, 165, 215, 159, O 225, 237, 243, 250, 241, 209, 170, 186, 191, 174, 172, 189, 188, 161, 171, 187, O 155, 156, 157, 144, 151, 193, 194, 192, 169, 135, 128, 131, 133, 248, 216, 147, O 148, 153, 152, 150, 145, 154, 227, 195, 132, 130, 137, 136, 134, 129, 138, 164, O 240, 208, 202, 203, 200, 158, 205, 206, 207, 149, 146, 141, 140, 166, 204, 139, O 211, 223, 212, 210, 245, 213, 181, 254, 222, 218, 219, 217, 253, 221, 175, 180, N 173, 177, 143, 190, 182, 167, 247, 184, 176, 168, 183, 185, 179, 178, 142, 160 };   CHARK yl1aq[] = {  /* Latin-1 to Extended Mac Latin (based on Apple QuickDraw) */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,cO  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,1O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,iO 182, 183, 184, 185, 189, 196, 197, 198, 206, 207, 210, 211, 217, 218, 195, 212,nO 209, 215, 213, 226, 227, 228, 240, 245, 246, 247, 249, 250, 251, 253, 254, 255, O 202, 193, 162, 163, 219, 180, 201, 164, 172, 169, 187, 199, 194, 208, 168, 248, O 161, 177, 170, 173, 171, 181, 166, 225, 252, 176, 188, 200, 178, 179, 186, 192,8O 203, 231, 229, 204, 128, 129, 174, 130, 233, 131, 230, 232, 237, 234, 235, 236,2O 220, 132, 241, 238, 239, 205, 133, 165, 175, 244, 242, 243, 134, 160, 222, 167, O 136, 135, 137, 139, 138, 140, 190, 141, 143, 142, 144, 145, 147, 146, 148, 149,cN 221, 150, 152, 151, 153, 155, 154, 214, 191, 157, 156, 158, 159, 224, 223, 216 };   CHAR+ yl1du[] = {  /* Latin-1 to Dutch ISO 646 */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,tO  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34, UNK,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O UNK,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, UNK, UNK, UNK,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,1O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK,  39, 127,cO 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O  32,  33, UNK,  35, 124, UNK, UNK,  93, 123,  67, UNK,  34, UNK,  45,  82, UNK, O  91, UNK, UNK, UNK, 126, 117, UNK, UNK,  44, UNK, UNK,  34, 125,  92,  64,  63,0O  65,  65,  65,  65,  91,  65,  65,  67,  69,  69,  69,  69,  73,  73,  73,  73,3O UNK,  78,  79,  79,  79,  79,  79, 120,  79,  85,  85,  85,  85,  89, UNK, 115, O  97,  97,  97,  97,  97,  97,  97,  99, 101, 101, 101, 101, 105, 105, 105, 105, N UNK, 110, 111, 111, 111, 111, 111,  47, 111, 117, 117, 117, 117, 121, UNK,  91 };   CHAR- yl1fi[] = {  /* Latin-1 to Finnish ISO 646 */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,mO  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,>O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, UNK, UNK, UNK, UNK,  95,1O UNK,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK, UNK, UNK,eO 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O  32,  33, UNK, UNK, UNK, UNK, UNK, UNK,  34,  67, UNK,  34, UNK,  45,  82, UNK, O UNK, UNK, UNK, UNK,  39, 117, UNK, UNK,  44, UNK, UNK,  34, UNK, UNK, UNK,  63,tO  65,  65,  65,  65,  91,  93,  65,  67,  69,  69,  69,  69,  73,  73,  73,  73,bO UNK,  78,  79,  79,  79,  79,  92, 120,  79,  85,  85,  85,  94,  89, UNK, 115,rO  97,  97,  97,  97, 123, 125,  97,  99, 101,  96, 101, 101, 105, 105, 105, 105,RN UNK, 110, 111, 111, 111, 111, 124,  47, 111, 117, 117, 117, 126, 121, UNK, 121 };   CHAR, yl1fr[] = {  /* Latin-1 to French ISO 646 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,lO  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,8O  32,  33,  34, UNK,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,eO  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,1O UNK,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,7O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, UNK, UNK, UNK,  94,  95,3O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,9O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK, UNK, 127,5O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,1O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,7O  32,  33, UNK,  35, UNK, UNK, UNK,  93,  34,  67, UNK,  34, UNK,  45,  82, UNK,3O  91, UNK, UNK, UNK,  39, 117, UNK, UNK,  44, UNK, UNK,  34, UNK, UNK, UNK,  63,3O  65,  65,  65,  65,  65,  65,  65,  67,  69,  69,  69,  69,  73,  73,  73,  73,6O UNK,  78,  79,  79,  79,  79,  79, 120,  79,  85,  85,  85,  85,  89, UNK, 115,4O  64,  97,  97,  97,  97,  97,  97,  92, 125, 123, 101, 101, 105, 105, 105, 105,5N UNK, 110, 111, 111, 111, 111, 111,  47, 111, 124, 117, 117, 117, 121, UNK, 121 };   CHAR5 yl1fc[] = {  /* Latin-1 to French-Canadian ISO 646 */5O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,3O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,5O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,5O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,8O UNK,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, UNK, UNK, UNK, UNK,  95,5O UNK,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,1O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK, UNK, 127,7O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,3O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,9O  32,  33, UNK, UNK, UNK, UNK, UNK, UNK,  34,  67, UNK,  34, UNK,  45,  82, UNK,5O UNK, UNK, UNK, UNK,  39, 117, UNK, UNK,  44, UNK, UNK,  34, UNK, UNK, UNK,  63,1O  65,  65,  65,  65,  65,  65,  65,  67,  69,  69,  69,  69,  73,  73,  73,  73,7O UNK,  78,  79,  79,  79,  79,  79, 120,  79,  85,  85,  85,  85,  89, UNK, 115,4O  64,  97,  91,  97,  97,  97,  97,  92, 125, 123,  93, 101, 105, 105,  94, 105,2N UNK, 110, 111, 111,  96, 111, 111,  47, 111, 124, 117, 126, 117, 121, UNK, 121 };   CHAR, yl1ge[] = {  /* Latin-1 to German ISO 646 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,4O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,4O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,1O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,7O UNK,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, UNK, UNK, UNK,  94,  95,TO  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,.O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK, UNK, 127, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O  32,  33, UNK, UNK, UNK, UNK, UNK,  64,  34,  67, UNK,  34, UNK,  45,  82, UNK, O UNK, UNK, UNK, UNK,  39, 117, UNK, UNK,  44, UNK, UNK,  34, UNK, UNK, UNK,  63, O  65,  65,  65,  65,  91,  65,  65,  67,  69,  69,  69,  69,  73,  73,  73,  73, O UNK,  78,  79,  79,  79,  79,  92, 120,  79,  85,  85,  85,  93,  89, UNK, 126,1O  97,  97,  97,  97, 123,  97,  97,  99, 101, 101, 101, 101, 105, 105, 105, 105,1N UNK, 110, 111, 111, 111, 111, 124,  47, 111, 117, 117, 117, 125, 121, UNK, 121 };   CHAR/ yl1hu[] = {  /* Latin-1 to Hungarian ISO-646 */,O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,,O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,,O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,,O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,,O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,,O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,iO 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,TO 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,,O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,,O  32,  33, UNK, UNK,  36, UNK, UNK, UNK,  34,  67, UNK,  34, UNK,  45,  82, UNK,,O UNK,  64, UNK, UNK,  39, 117, UNK, UNK,  44, UNK, UNK,  34, UNK, UNK, UNK,  63,,O  65,  65,  65,  65,  65,  65,  65,  67,  69,  91,  69,  69,  73,  73,  73,  73,,O UNK,  78,  79,  79,  79,  79,  92, 120,  79,  85,  85,  85,  93,  89, UNK, 115,,O  97,  96,  97,  97,  97,  97,  97,  99, 101, 123, 101, 101, 105, 105, 105, 105,,N UNK, 110, 111, 111, 111, 111, 124,  47, 111, 117, 117, 117, 125, 121, UNK, 121 };   CHAR- yl1it[] = {  /* Latin-1 to Italian ISO 646 */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34, UNK,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O UNK,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, UNK, UNK, UNK,  94,  95, O UNK,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK, UNK, 127,nO 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,aO 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O  32,  33, UNK,  35, UNK, UNK, UNK,  64,  34,  67, UNK,  34, UNK,  45,  82, UNK, O  91, UNK, UNK, UNK,  39, 117, UNK, UNK,  44, UNK, UNK,  34, UNK, UNK, UNK,  63, O  65,  65,  65,  65,  65,  65,  65,  67,  69,  69,  69,  69,  73,  73,  73,  73, O UNK,  78,  79,  79,  79,  79,  79, 120,  79,  85,  85,  85,  85,  89, UNK, 115, O 123,  97,  97,  97,  97,  97,  97,  92, 125,  93, 101, 101, 126, 105, 105, 105, N UNK, 110, 124, 111, 111, 111, 111,  47, 111,  96, 117, 117, 117, 121, UNK, 121 };   CHAR" yl1ne[] = {  /* Latin-1 to NeXT */2 /* NEED TO MAKE THIS ONE INVERTIBLE, LIKE CP850 */ /*J   Which means finding all the graphic characters in the NeXT set that haveJ   no equivalent in Latin-1 and assigning them to the UNK positions (mostlyK   Latin-1 C1 controls).  Then make the ynel1[] table be the inverse of this K   one.  But first we should try to get an official Latin-1/NeXT translation2   table from NeXT, Inc.4 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,1O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,2O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,2O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,2O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O  32, 161, 162, 163, 168, 165, 181, 167, 200, 160, 227, 171, 190, UNK, 176, 197, O 202, 209, 201, 204, 194, 157, 182, 183, 203, 192, 235, 187, 210, 211, 212, 191, O 129, 130, 131, 132, 133, 134, 225, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 158, 233, 151, 152, 153, 154, 155, 156, 251, O 213, 214, 215, 216, 217, 218, 241, 219, 220, 221, 222, 223, 224, 226, 228, 229, N 230, 231, 236, 237, 238, 239, 240, 159, 249, 242, 243, 244, 246, 247, 252, 253 };   CHAR6 yl1no[] = {  /* Latin-1 to Norwegian/Danish ISO 646 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,2O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,2O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,2O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,2O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,7O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, UNK, UNK, UNK,  94,  95,nO  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,rO 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK, 126, 127,-O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,aO 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,oO  32,  33, UNK, UNK, UNK, UNK, UNK, UNK,  34,  67, UNK,  34, UNK,  45,  82, UNK,1O UNK, UNK, UNK, UNK,  39, 117, UNK, UNK,  44, UNK, UNK,  34, UNK, UNK, UNK,  63,2O  65,  65,  65,  65,  65,  93,  91,  67,  69,  69,  69,  69,  73,  73,  73,  73,4O UNK,  78,  79,  79,  79,  79,  79, 120,  92,  85,  85,  85,  85,  89, UNK, 115,6O  97,  97,  97,  97,  97, 125, 123,  99, 101, 101, 101, 101, 105, 105, 105, 105,7N UNK, 110, 111, 111, 111, 111, 111,  47, 124, 117, 117, 117, 117, 121, UNK, 121 };   CHAR0 yl1po[] = {  /* Latin-1 to Portuguese ISO 646 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, UNK, UNK, UNK,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK, 126, 127, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O  32,  33, UNK, UNK, UNK, UNK, UNK, UNK,  34,  67, UNK,  34, UNK,  45,  82, UNK, O UNK, UNK, UNK, UNK,  39, 117, UNK, UNK,  44, UNK, UNK,  34, UNK, UNK, UNK,  63,1O  65,  65,  65,  91,  65,  65,  65,  92,  69,  69,  69,  69,  73,  73,  73,  73,3O UNK,  78,  79,  79,  79,  93,  79, 120,  79,  85,  85,  85,  85,  89, UNK, 115,5O  97,  97,  97, 123,  97,  97,  97, 124, 101, 101, 101, 101, 105, 105, 105, 105,6N UNK, 110, 111, 111, 111, 125, 111,  47, 111, 117, 117, 117, 117, 121, UNK, 121 };   CHAR- yl1sp[] = {  /* Latin-1 to Spanish ISO 646 */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34, UNK,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O UNK,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, UNK, UNK, UNK,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122,  96, UNK, UNK, 126, 127, O 126, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O  32,  91, UNK,  35, UNK, UNK, UNK,  64,  34,  67, UNK,  34, UNK,  45,  82, UNK,lO 123, UNK, UNK, UNK,  39, 117, UNK, UNK,  44, UNK, UNK,  34, UNK, UNK, UNK,  93,,O  65,  65,  65,  65,  65,  65,  65,  67,  69,  69,  69,  69,  73,  73,  73,  73,,O UNK,  92,  79,  79,  79,  79,  79, 120,  79,  85,  85,  85,  85,  89, UNK, 115,,O 124,  97,  97,  97,  97,  97,  97, 125, 101, 101, 101, 101, 105, 105, 105, 105,,N UNK, 124, 111, 111, 111, 111, 111,  47, 111, 117, 117, 117, 117, 121, UNK, 121 };   CHAR- yl1sw[] = {  /* Latin-1 to Swedish ISO 646 */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O UNK,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, UNK, UNK, UNK, UNK,  95, O UNK,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK, UNK, 127, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O  32,  33, UNK, UNK, UNK, UNK, UNK, UNK,  34,  67, UNK,  34, UNK,  45,  82, UNK,tO UNK, UNK, UNK, UNK,  39, 117, UNK, UNK,  44, UNK, UNK,  34, UNK, UNK, UNK,  63, O  65,  65,  65,  65,  91,  93,  65,  67,  69,  64,  69,  69,  73,  73,  73,  73, O UNK,  78,  79,  79,  79,  79,  92, 120,  79,  85,  85,  85,  94,  89, UNK, 115, O  97,  97,  97,  97, 123, 125,  97,  99, 101,  96, 101, 101, 105, 105, 105, 105, N UNK, 110, 111, 111, 111, 111, 124,  47, 111, 117, 117, 117, 126, 121, UNK, 121 };   CHAR+ yl1ch[] = {  /* Latin-1 to Swiss ISO 646 */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34, UNK,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O UNK,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, UNK, UNK, UNK, UNK, UNK, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK, UNK, 127, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O  32,  33, UNK, UNK, UNK, UNK, UNK, UNK,  34,  67, UNK,  34, UNK,  45,  82, UNK,nO UNK, UNK, UNK, UNK,  39, 117, UNK, UNK,  44, UNK, UNK,  34, UNK, UNK, UNK,  63,,O  65,  65,  65,  65,  65,  65,  65,  67,  69,  69,  69,  69,  73,  73,  73,  73,,O UNK,  78,  79,  79,  79,  79,  79, 120,  79,  85,  85,  85,  85,  89, UNK, 115,,O  64,  97,  97,  97, 123,  97,  97,  92,  95,  91,  93, 101, 105, 105,  94, 105,,N UNK, 110, 111, 111,  96, 111, 124,  47, 111,  35, 117, 126, 125, 121, UNK, 121 };   CHAR= yl1dm[] = {  /* Latin-1 to DEC Multinational Character Set */UO   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,1O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,UO  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,1O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,1O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,1O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,1O  32, 161, 162, 163, 168, 165, 124, 167,  34, 169, 170, 171, 126, UNK,  82, UNK, O 176, 177, 178, 179,  39, 181, 182, 183,  44, 185, 186, 187, 188, 189, UNK, 191, O 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, O UNK, 209, 210, 211, 212, 213, 214, 120, 216, 217, 218, 219, 220, 221, UNK, 223, O 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, N UNK, 241, 242, 243, 244, 245, 246,  47, 248, 249, 250, 251, 252, UNK, UNK, 253 };   CHARF yl1dg[] = {  /* Latin-1 to Data General International Character Set */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,;O 160, 171, 167, 168, 166, 181, 191, 187, 189, 173, 169, 177, 161, 255, 174, 175, O 188, 182, 164, 165, 190, 163, 178, 185, 186, 179, 170, 176, 223, 162, 220, 172, O 193, 192, 194, 196, 195, 197, 198, 199, 201, 200, 202, 203, 205, 204, 206, 207, O 184, 208, 210, 209, 211, 213, 212, 215, 214, 217, 216, 218, 219, 221, 222, 252, O 225, 224, 226, 228, 227, 229, 230, 231, 233, 232, 234, 235, 237, 236, 238, 239, N 183, 240, 242, 241, 243, 245, 244, 247, 246, 249, 248, 250, 251, 180, 254, 253 };    7 /* Local file character sets to ISO Latin Alphabet 1 */5   #ifdef NOTUSED CHAR# yasl1[] = {  /* ASCII to Latin-1 */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127 }; #endif /* NOTUSED */   CHARK yaql1[] = {  /* Extended Mac Latin (based on Apple Quickdraw) to Latin-1 */HO   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,2O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,3O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,5O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,7O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,8O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,0O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,1O 196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,3O 234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,5O 221, 176, 162, 163, 167, 215, 182, 223, 174, 169, 178, 180, 168, 179, 198, 216,NO 185, 177, 188, 189, 165, 181, 128, 129, 130, 131, 190, 170, 186, 132, 230, 248,NO 191, 161, 172, 142, 133, 134, 135, 171, 187, 166, 160, 192, 195, 213, 136, 137,6O 173, 144, 138, 139, 143, 146, 247, 145, 255, 140, 141, 164, 208, 240, 222, 254,9O 253, 183, 147, 148, 149, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212,9N 150, 210, 218, 219, 217, 151, 152, 153, 175, 154, 155, 156, 184, 157, 158, 159 };   CHAR+ ydul1[] = {  /* Dutch ISO 646 to Latin-1 */HO   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,5O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,1O  32,  33,  34, 163,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,7O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,3O 190,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,9O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 255, 189, 124,  94,  95,5O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,1N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 168, 164, 188,  39, 127 };   CHAR- yfil1[] = {  /* Finnish ISO 646 to Latin-1 */,O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,,O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,,O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,,O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,,O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 196, 214, 197, 220,  95,,O 233,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,,N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 229, 252, 127 };   CHAR, yfrl1[] = {  /* French ISO 646 to Latin-1 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,1O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,3O  32,  33,  34, 163,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,4O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,NO 224,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,8O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 176, 231, 167,  94,  95,NO  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,1N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 233, 249, 232, 168, 127 };   CHAR5 yfcl1[] = {  /* French-Canadian ISO 646 to Latin-1 */1O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,7O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,5O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,KO  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,3O 224,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,9O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 226, 231, 234, 238,  95,5O 244,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,1N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 233, 249, 232, 251, 127 };   CHAR, ygel1[] = {  /* German ISO 646 to Latin-1 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,aO  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,eO  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,tO  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O 167,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,1O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 196, 214, 220,  94,  95,3O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,5N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 252, 223, 127 };   CHAR- yitl1[] = {  /* Italian ISO 646 to Latin-1 */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34, 163,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O 167,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 176, 231, 233,  94,  95, O 249,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 224, 242, 232, 236, 127 };   CHAR" ynel1[] = {  /* NeXT to Latin-1 */& /* NEED TO MAKE THIS ONE INVERTIBLE */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,,O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,,O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,1O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,7O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,3O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,9O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,5O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,1O 160, 192, 193, 194, 195, 196, 197, 199, 200, 201, 202, 203, 204, 205, 206, 207,7O 208, 209, 210, 211, 212, 213, 214, 217, 218, 219, 220, 221, 222, 181, 215, 247,3O 169, 161, 162, 163, UNK, 165, UNK, 167, 164, UNK, UNK, 171, UNK, UNK, UNK, UNK,9O 174, UNK, UNK, UNK, 183, 166, 182, UNK, UNK, UNK, UNK, 187, UNK, UNK, 172, 191,5O 185,  96, 180,  94, 126, 175, UNK, UNK, 168, 178, 176, 184, 179, UNK, UNK, UNK,3O UNK, 177, 188, 189, 190, 224, 225, 226, 227, 228, 229, 231, 232, 233, 234, 235,KO 236, 198, 237, 170, 238, 239, 240, 241, UNK, 216, UNK, 186, 242, 243, 244, 245,5N 246, 230, 249, 250, 251, UNK, 252, 253, UNK, 248, UNK, 223, 254, 255, UNK, UNK };   CHAR6 ynol1[] = {  /* Norwegian/Danish ISO 646 to Latin-1 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,,O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,,O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,,O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,,O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 198, 216, 197,  94,  95,,O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,,N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 230, 248, 229, 126, 127 };   CHAR0 ypol1[] = {  /* Portuguese ISO 646 to Latin-1 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,,O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,,O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,,O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,,O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 195, 199, 213,  94,  95,,O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,,N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 227, 231, 245, 126, 127 };   CHAR- yspl1[] = {  /* Spanish ISO 646 to Latin-1 */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,6O  32,  33,  34, 163,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,,O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,,O 167,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 161, 209, 191,  94,  95,,O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,,N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 176, 241, 231, 126, 127 };   CHAR- yswl1[] = {  /* Swedish ISO 646 to Latin-1 */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O 201,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 196, 214, 197, 220,  95, O 233,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 229, 252, 127 };   CHAR+ ychl1[] = {  /* Swiss ISO 646 to Latin-1 */,O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,/O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,9O  32,  33,  34, 249,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,5O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,1O 224,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,7O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 233, 231, 234, 238, 232,3O 244,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,9N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 252, 251, 127 };   CHAR/ yhul1[] = {  /* Hungarian ISO 646 to Latin-1 */1O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,1O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,1O  32,  33,  34,  35, 164,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,UO  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,1O 193,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 201, 214, 220,  94,  95, O 225,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,1N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 233, 246, 252,  34, 127 };   CHAR= ydml1[] = {  /* DEC Multinational Character Set to Latin-1 */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,,O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,,O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,,O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,,O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,,O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,,O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,,O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,,O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,,O 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,,O 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,,O 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,,O 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,,O 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,,O 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,, };   CHAR8 ydgl1[] = {  /* Data General International to Latin-1 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O 160, 172, 189, 181, 178, 179, 164, 162, 163, 170, 186, 161, 191, 169, 174, 175, O 187, 171, 182, 185, 253, 165, 177, 240, 208, 183, 184, 167, 176, 168, 180, 166, O 193, 192, 194, 196, 195, 197, 198, 199, 201, 200, 202, 203, 205, 204, 206, 207, O 209, 211, 210, 212, 214, 213, 216, 215, 218, 217, 219, 220, 190, 221, 222, 188, O 225, 224, 226, 228, 227, 229, 230, 231, 233, 232, 234, 235, 237, 236, 238, 239, N 241, 243, 242, 244, 246, 245, 248, 247, 250, 249, 251, 252, 223, 255, 254, 173 };    4 /* Translation tables for Cyrillic character sets */   #ifdef CYRILLICD CHAR* ylcac[] = {  /* Latin/Cyrillic to CP866 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19, 208, 209,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,1O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,1O 196, 179, 192, 217, 191, 218, 195, 193, 180, 194, 197, 176, 177, 178, 211, 216,1O 205, 186, 200, 188, 187, 201, 204, 202, 185, 203, 206, 223, 220, 219, 254, UNK,1O 255, 240, 132, 131, 242,  83,  73, 244,  74, 139, 141, 151, 138,  45, 246, 135,1O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,1O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,2O 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,2O 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,2N 252, 241, 164, 163, 243, 115, 105, 245, 106, 171, 173, 231, 170,  21, 247, 167 };   CHAR7 ylck8[] = {  /* Latin/Cyrillic to Old KOI-8 Cyrillic */NO   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,RO 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O UNK, 229, UNK, UNK, UNK,  83,  73,  73,  74, UNK, UNK, UNK, 235, UNK, 245, UNK,1O 225, 226, 247, 231, 228, 229, 246, 250, 233, 234, 235, 236, 237, 238, 239, 240,3O 242, 243, 244, 245, 230, 232, 227, 254, 251, 253, 255, 249, 248, 252, 224, 241,4O 193, 194, 215, 199, 196, 197, 214, 218, 201, 202, 203, 204, 205, 206, 207, 208,6O 210, 211, 212, 213, 198, 200, 195, 222, 219, 221, 223, 217, 216, 220, 192, 209,8N UNK, 197, UNK, UNK, UNK, 115, 105, 105, 106, UNK, UNK, UNK, 203, UNK, 213, UNK };   CHAR* yaclc[] = {  /* CP866 to Latin/Cyrillic */& /* NEED TO MAKE THIS ONE INVERTIBLE */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,,O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,,O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,,O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,,O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,,O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,,O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,,O 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,lO 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, O 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, N 161, 241, 164, 244, 167, 247, 174, 254, UNK, UNK, UNK, UNK, 240, UNK, UNK, UNK };   CHAR7 yk8lc[] = {  /* Old KOI-8 Cyrillic to Latin/Cyrillic */1O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,-O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O 238, 208, 209, 230, 212, 213, 228, 211, 229, 216, 217, 218, 219, 220, 221, 222, O 223, 239, 224, 225, 226, 227, 214, 210, 236, 235, 215, 232, 237, 233, 231, 234, O 206, 176, 177, 198, 180, 181, 196, 179, 197, 184, 185, 186, 187, 188, 189, 190, N 191, 207, 192, 193, 194, 195, 182, 178, 204, 203, 183, 200, 205, 201, 199, 127 };   CHAR. ylcsk[] = {  /* Latin/Cyrillic to Short KOI */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,2O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,oO  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,3O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,9O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,5O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,1O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,7O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94, 127,4O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,9O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,2O  32, 101, UNK, UNK, UNK,  83,  73,  73,  74, UNK, UNK, UNK, 107,  45, 117, UNK, O  97,  98, 119, 103, 100, 101, 118, 122, 105, 106, 107, 108, 109, 110, 111, 112,1O 114, 115, 116, 117, 102, 104,  99, 126, 123, 125,  39, 121, 120, 124,  96, 113,3O  97,  98, 119, 103, 100, 101, 118, 122, 105, 106, 107, 108, 109, 110, 111, 112,5O 114, 115, 116, 117, 102, 104,  99, 126, 123, 125,  39, 121, 120, 124,  96, 113,6N UNK, 101, UNK, UNK, UNK,  83,  73,  73,  74, UNK, UNK, UNK, 107, UNK, 117, UNK };  3 CHAR yskcy[] = {  /* Short KOI to Latin/Cyrillic */ O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,1O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,3O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,5O 206, 176, 177, 198, 180, 181, 196, 179, 197, 184, 185, 186, 187, 188, 189, 190,6N 191, 207, 192, 193, 194, 195, 182, 178, 204, 203, 183, 200, 205, 201, 199, 127 }; #endif /* CYRILLIC */7  
 #ifdef LATIN21   /* Latin-2 tables */   CHAR+ yl252[] = {  /* Latin-2 to Code Page 852 */0O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,2O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,EO  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,9O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,5O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,1O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,7O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,3O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,9O 174, 175, 176, 177, 178, 179, 180, 185, 186, 187, 188, 191, 192, 193, 194, 195,5O 196, 197, 200, 201, 202, 203, 204, 205, 206, 217, 218, 219, 220, 223, 240, 254,1O 255, 164, 244, 157, 207, 149, 151, 245, 249, 230, 184, 155, 141, 170, 166, 189,1O 248, 165, 242, 136, 239, 150, 152, 243, 247, 231, 173, 156, 171, 241, 167, 190,9O 232, 181, 182, 198, 142, 145, 143, 128, 172, 144, 168, 211, 183, 214, 215, 210,KO 209, 227, 213, 224, 226, 138, 153, 158, 252, 222, 233, 235, 154, 237, 221, 225,KO 234, 160, 131, 199, 132, 146, 134, 135, 159, 130, 169, 137, 216, 161, 140, 212,8N 208, 228, 229, 162, 147, 139, 148, 246, 253, 133, 163, 251, 129, 236, 238, 250 };   CHAR+ y52l2[] = {  /* Code Page 852 to Latin-2 */3O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,5O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,7O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,3O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,9O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,5O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,1O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,7O 199, 252, 233, 226, 228, 249, 230, 231, 179, 235, 213, 245, 238, 172, 196, 198,3O 201, 197, 229, 244, 246, 165, 181, 166, 182, 214, 220, 171, 187, 163, 215, 232,9O 225, 237, 243, 250, 161, 177, 174, 190, 202, 234, 173, 188, 200, 186, 128, 129,IO 130, 131, 132, 133, 134, 193, 194, 204, 170, 135, 136, 137, 138, 175, 191, 139, O 140, 141, 142, 143, 144, 145, 195, 227, 146, 147, 148, 149, 150, 151, 152, 164, O 240, 208, 207, 203, 239, 210, 205, 206, 236, 153, 154, 155, 156, 222, 217, 157, O 211, 223, 212, 209, 241, 242, 169, 185, 192, 218, 224, 219, 253, 221, 254, 180, N 158, 189, 178, 183, 162, 167, 247, 184, 176, 168, 255, 251, 216, 248, 159, 160 };   CHAR% yl2l1[] = {  /* Latin-2 to Latin-1 */5O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,1O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,7O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,pO  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,1O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,2O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,4O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,5O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,7O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,9O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,0O 160, 'A', UNK, 'L', 164, 'L', 'S', 167, 168, 'S', 'S', 'T', 'Z', 173, 'Z', 'Z',2O 176, 'a', UNK, 'l', 180, 'l', 's', UNK, 184, 's', 's', 't', 'z', UNK, 'z', 'z',1O 'R', 193, 194, 'A', 196, 'L', 'C', 199, 'C', 201, 'E', 203, 'E', 205, 'I', 'D', O 208, 'N', 'N', 211, 212, 'O', 214, 215, 'R', 'U', 218, 'U', 220, 221, 'T', 's', O 'r', 225, 226, 'a', 228, 'l', 'c', 231, 'c', 233, 'e', 235, 'e', 237, 'i', 'd', N 240, 'n', 'n', 243, 244, 'o', 246, 247, 'r', 'u', 250, 'u', 252, 253, 't', '.' };   CHAR% yl1l2[] = {  /* Latin-1 to Latin-2 */,O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,,O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,,O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,,O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,LO  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, O 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, O 160, 'A', UNK, 'L', 164, UNK, UNK, 167, 168, 'C', 'a', '<', '>', 173, 'R', UNK, O 176, UNK, UNK, UNK, 180, UNK, UNK, UNK, 184, UNK, 'o', '>', UNK, UNK, UNK, UNK, O 'A', 193, 194, 'A', 196, 'A', 'A', 199, 'E', 201, 'E', 203, 'I', 205, 'I', 'I', O 208, 'N', 'O', 211, 212, 'O', 214, 215, 'O', 'U', 218, 'U', 220, 221, UNK, 223, O 'a', 225, 226, 'a', 228, 'a', 'a', 231, 'e', 233, 'e', 235, 'i', 237, 'i', 'i', N 240, 'n', 'o', 243, 244, 'o', 246, 247, 'o', 'u', 250, 'u', 252, 253, UNK, 'y' };   CHAR# yl2as[] = {  /* Latin-2 to ASCII */9O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,5O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,1O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,7O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,3O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O  32, 'A', UNK, 'L', UNK, 'L', 'S', UNK,  34, 'S', 'S', 'T', 'Z', '-', 'Z', 'Z', O UNK, 'a', UNK, 'l',  39, 'l', 's', UNK,  44, 's', 's', 't', 'z', UNK, 'z', 'z',1O 'R', 'A', 'A', 'A', 'A', 'L', 'C', 'C', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'D',1O 'D', 'N', 'N', 'O', 'O', 'O', 'O', 'x', 'R', 'U', 'U', 'U', 'U', 'Y', 'T', 's',1O 'r', 'a', 'a', 'a', 'a', 'l', 'c', 'c', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'd',1N 'd', 'n', 'n', 'o', 'o', 'o', 'o', '/', 'r', 'u', 'u', 'u', 'u', 'y', 't', '.' }; #endif /* LATIN2 */7  
 #ifdef HEBREW1 /*O   8-bit Tables providing invertible translation between Latin/Hebrew and CP862.  */ CHAR> y62lh[] = {  /* PC Code Page 862 to ISO 8859-8 Latin/Hebrew */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,2O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,4O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,,O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,,O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,,O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,,O 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,,O 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 162, 163, 165, 128, 129,,O 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 172, 189, 188, 140, 171, 187,,O 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156,,O 157, 158, 159, 161, 164, 166, 167, 168, 169, 170, 173, 174, 175, 223, 179, 180,,O 182, 184, 185, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202,,O 203, 204, 205, 206, 207, 208, 181, 209, 210, 211, 212, 213, 214, 215, 216, 217,,N 218, 177, 219, 220, 221, 222, 186, 251, 176, 183, 252, 253, 254, 178, 255, 160 };   CHAR> ylh62[] = {  /* ISO 8859-8 Latin/Hebrew to PC Code Page 862 */O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,2O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,2O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,eO  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,/O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, O 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 173, 176, 177, 178, O 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, O 255, 195, 155, 156, 196, 157, 197, 198, 199, 200, 201, 174, 170, 202, 203, 204, O 248, 241, 253, 206, 207, 230, 208, 249, 209, 210, 246, 175, 172, 171, 211, 212, O 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, O 229, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 242, 243, 244, 245, 205, O 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, N 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 247, 250, 251, 252, 254 }; /*H   7-bit table providing readable translation from DEC Hebrew-7 to CP862. */ CHAR yh762[] = { O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,;O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,,O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,,O UNK,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,N  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 123, 124, 125, 126, 127 }; /*D   8-bit table providing readable translation from CP862 to Hebrew-7. */ CHAR/ y62h7[] = {  /* PC Code Page 862 to Hebrew-7 */3O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,9O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,5O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,1O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,7O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,KO  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,8O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,2O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 123, 124, 125, 126, 127,6O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,0O 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK, UNK, UNK,KO UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK,KO UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, N UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK }; /*O   7-bit table providing readable translation from Hebrew-7 to ISO Latin/Hebrew.9 */ CHAR yh7lh[] = {,O   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,,O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,,O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,,O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,,O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,,O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,,O 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,,N 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 123, 124, 125, 126, 127 }; /*O   8-bit table providing readable translation from ISO Latin/Hebrew to Hebrew-7.  */ CHAR+ ylhh7[] = {  /* Latin/Hebrew to Hebrew-7 */UO   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,1O  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31, O  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, O  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, O  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, O  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 123, 124, 125, 126, 127, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK,-O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, UNK, O  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, N 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, UNK, UNK, UNK, UNK, UNK }; #endif /* HEBREW */9   /* Translation functions ... */0  1 CHAR				/* The identity translation function.  */i #ifdef CK_ANSICr' ident(CHAR c)				/* (no longer used) */  #else  ident(c) CHAR c; #endif /* CK_ANSIC */ 
 { /* ident */ 3     return(c);				/* Instead, enter NULL in the  */ ' }					/* table of functions to avoid */ & 					/* needless function calls.    */ CHAR #ifdef CK_ANSIC5 xl1as(CHAR c)  #else  xl1as(c) CHAR c;   #endif /* CK_ANSIC */9- { /* xl1as */ 			/* Latin-1 to US ASCII... */       switch(langs[language].id) {         case L_DUTCH:8' 	if (c == 255) {			/* Dutch umlaut-y */,$ 	    zmstuff('j');		/* becomes ij */ 	    return('i'); 6 	} else return(yl1as[c]);	/* all others by the book */         case L_GERMAN:, 	switch (c) {			/* German, special rules. */# 	  case 196:			/* umlaut-A -> Ae */  	    zmstuff('e'); 	    return('A');9# 	  case 214:			/* umlaut-O -> Oe */  	    zmstuff('e'); 	    return('O'); # 	  case 220:			/* umlaut-U -> Ue */7 	    zmstuff('e'); 	    return('U');1# 	  case 228:			/* umlaut-a -> ae */1 	    zmstuff('e'); 	    return('a');0# 	  case 246:			/* umlaut-o -> oe */, 	    zmstuff('e'); 	    return('o');,# 	  case 252:			/* umlaut-u -> ue */  	    zmstuff('e'); 	    return('u'); " 	  case 223:			/* ess-zet -> ss */ 	    zmstuff('s'); 	    return('s');,: 	  default: return(yl1as[c]);	/* all others by the book */ 	}       case L_DANISH:       case L_FINNISH:;       case L_NORWEGIAN:S       case L_SWEDISH:l- 	switch (c) {			/* Scandanavian languages. */ # 	  case 196:			/* umlaut-A -> Ae */52           case 198:			/* AE ligature also -> Ae */ 	    zmstuff('e'); 	    return('A'); # 	  case 214:			/* umlaut-O -> Oe */," 	  case 216:			/* O-slash -> Oe */ 	    zmstuff('e'); 	    return('O');5# 	  case 220:			/* umlaut-U -> Ue */ : 	  /*  return('Y'); replaced by "Ue" by popular demand. */=           /*  Y for Umlaut-U is only used in German names. */  	    zmstuff('e'); 	    return('U'); # 	  case 228:			/* umlaut-a -> ae */91           case 230:			/* ditto for ae ligature */9 	    zmstuff('e'); 	    return('a');0# 	  case 246:			/* umlaut-o -> oe */ " 	  case 248:			/* o-slash -> oe */ 	    zmstuff('e'); 	    return('o');R# 	  case 252:			/* umlaut-u -> ue */e: 	  /*  return('y'); replaced by "ue" by popular demand. */ 	    zmstuff('e'); 	    return('u');7! 	  case 197:			/* A-ring -> Aa */, 	    zmstuff('a'); 	    return('A');3(           case 229:			/* a-ring -> aa */ 	    zmstuff('a'); 	    return('a');4: 	  default: return(yl1as[c]);	/* All others by the book */ 	}*       case L_ICELANDIC:			/* Icelandic. */ 	switch (c) {	' 	  case 198:			/* uppercase AE -> AE */, 	    zmstuff('e'); 	    return('A');,' 	  case 208:			/* uppercase Eth -> D */, 	    return('D');,0 	  case 214:			/* uppercase O-diaeresis -> Oe */ 	    zmstuff('e'); 	    return('O');1* 	  case 222:			/* uppercase Thorn -> Th */ 	    zmstuff('h'); 	    return('T');,' 	  case 230:			/* lowercase ae -> ae */1 	    zmstuff('e'); 	    return('a');,' 	  case 240:			/* lowercase Eth -> d */2 	    return('d');,0 	  case 246:			/* lowercase O-diaeresis -> oe */ 	    zmstuff('e'); 	    return('o');3* 	  case 254:			/* lowercase Thorn -> th */ 	    zmstuff('h'); 	    return('t');,: 	  default: return(yl1as[c]);	/* All others by the book */ 	}       default:: 	return(yl1as[c]);		/* None of the above, by the table. */     }0 }3    CHAR					/* Latin-1 to German */ #ifdef CK_ANSIC1 xl1ge(CHAR c)  #else8 xl1ge(c) CHAR c; 9 #endif /* CK_ANSIC */6
 { /* xl1ge */6     return(yl1ge[c]);  }l    CHAR					/* German to Latin-1 */ #ifdef CK_ANSIC  xgel1(CHAR c)  #else  xgel1(c) CHAR c;   #endif /* CK_ANSIC */5
 { /* xgel1 */,     return(ygel1[c]);3 }2   CHAR #ifdef CK_ANSIC9 xgeas(CHAR c)  #else  xgeas(c) CHAR c;   #endif /* CK_ANSIC */,- { /* xgeas */			/* German ISO 646 to ASCII */      switch (c) {&       case 91:				/* umlaut-A -> Ae */ 	zmstuff('e');
 	return('A');9&       case 92:				/* umlaut-O -> Oe */ 	zmstuff('e');
 	return('O');3&       case 93:				/* umlaut-U -> Ue */ 	zmstuff('e');
 	return('U');7'       case 123:				/* umlaut-a -> ae */  	zmstuff('e');
 	return('a'); '       case 124:				/* umlaut-o -> oe */2 	zmstuff('e');
 	return('o');,'       case 125:				/* umlaut-u -> ue */, 	zmstuff('e');
 	return('u');1&       case 126:				/* ess-zet -> ss */ 	zmstuff('s');
 	return('s');1:       default:  return(c);		/* all others stay the same */     }0 }2   CHAR #ifdef CK_ANSIC2 xduas(CHAR c)  #else, xduas(c) CHAR c; , #endif /* CK_ANSIC */7/ { /* xduas */			/* Dutch ISO 646 to US ASCII */1     switch (c) {'       case 64:  return(UNK);		/* 3/4 */,#       case 91:				/* y-diaeresis */3 	zmstuff('j');
 	return('i');,'       case 92:  return(UNK);		/* 1/2 */,0       case 93:  return(124);		/* vertical bar */,       case 123: return(34);		/* diaeresis */*       case 124: return(UNK);		/* Florin */'       case 125: return(UNK);		/* 1/4 */ -       case 126: return(39);		/* Apostrophe */        default:  return(c);     }, }7   CHAR #ifdef CK_ANSIC, xfias(CHAR c)  #else7 xfias(c) CHAR c; 1 #endif /* CK_ANSIC */ 1 { /* xfias */			/* Finnish ISO 646 to US ASCII */4     switch (c) {#       case 91:				/* A-diaeresis */  	zmstuff('e');
 	return('A');3#       case 92:				/* O-diaeresis */, 	zmstuff('e');
 	return('O');        case 93:				/* A-ring */ 	zmstuff('a');
 	return('A');9#       case 94:				/* U-diaeresis */, 	/* return('Y'); */1 	zmstuff('e');
 	return('U');7       case 96:				/* e-acute */ 
 	return('e');1$       case 123:				/* a-diaeresis */ 	zmstuff('e');
 	return('a');,$       case 124:				/* o-diaeresis */ 	zmstuff('e');
 	return('o');4       case 125:				/* a-ring */1 	zmstuff('a');
 	return('a');7$       case 126:				/* u-diaeresis */ 	/* return('y'); */' 	zmstuff('e');
 	return('U');'       default: 	return(c);'     }, }K   CHAR #ifdef CK_ANSIC, xfras(CHAR c)  #else1 xfras(c) CHAR c; ' #endif /* CK_ANSIC */ 0 { /* xfras */			/* French ISO 646 to US ASCII */     switch (c) {*       case 64:  return(97);		/* a grave *//       case 91:  return(UNK);		/* degree sign */3,       case 92:  return(99);		/* c cedilla */2       case 93:  return(UNK);		/* paragraph sign */+       case 123: return(101);		/* e acute */a+       case 124: return(117);		/* u grave */,+       case 125: return(101);		/* e grave */ ,       case 126: return(34);		/* diaeresis */       default:  return(c);     }  },   CHAR #ifdef CK_ANSIC5 xfcas(CHAR c)  #else4 xfcas(c) CHAR c; 4 #endif /* CK_ANSIC */,6 { /* xfcas */			/* French Canadian ISO 646 to ASCII */     switch (c) {+       case 64:  return('a');		/* a grave */70       case 91:  return('a');		/* a circumflex */-       case 92:  return('c');		/* c cedilla */10       case 93:  return('e');		/* e circumflex */0       case 94:  return('i');		/* i circumflex */0       case 96:  return('o');		/* o circumflex */+       case 123: return('e');		/* e acute */9+       case 124: return('u');		/* u grave */,+       case 125: return('e');		/* e grave */70       case 126: return('u');		/* u circumflex */       default:  return(c);     }6 }U   CHAR #ifdef CK_ANSICa xitas(CHAR c)  #elseU xitas(c) CHAR c; , #endif /* CK_ANSIC */K. { /* xitas */			/* Italian ISO 646 to ASCII */     switch (c) {*       case 91:  return(UNK);		/* degree */-       case 92:  return('c');		/* c cedilla */1+       case 93:  return('e');		/* e acute */3+       case 96:  return('u');		/* u grave */e+       case 123: return('a');		/* a grave */'+       case 124: return('o');		/* o grave */5+       case 125: return('e');		/* e grave */[+       case 126: return('i');		/* i grave */,       default:  return(c);     }  },   CHAR #ifdef CK_ANSIC5 xneas(CHAR c)  #else2 xneas(c) CHAR c; 2 #endif /* CK_ANSIC */ # { /* xneas */			/* NeXT to ASCII */3F     if (langs[language].id == L_FRENCH) { /* If SET LANGUAGE FRENCH */+ 	if (c == 234) {			/* handle OE digraph. */9 	    zmstuff('E'); 	    return('O'); 1 	} else if (c == 250) {		/* Also lowercase oe. */7 	    zmstuff('e'); 	    return('o');  	}     }7,     c = xnel1(c);			/* Convert to Latin-1 */6     return(yl1as[c]);			/* Convert Latin-1 to ASCII */ }0   CHAR #ifdef CK_ANSIC1 xnoas(CHAR c)  #else  xnoas(c) CHAR c;   #endif /* CK_ANSIC */,3 { /* xnoas */			/* Norge/Danish ISO 646 to ASCII */U     switch (c) {       case 91:! 	zmstuff('E');			/* AE digraph */,
 	return('A'); *       case 92: return('O');		/* O slash */       case 93:				/* A ring */ 	zmstuff('a');
 	return('A');'#       case 123:				/* ae digraph */s 	zmstuff('e');
 	return('a');,+       case 124: return('o');		/* o slash */'       case 125:				/* a ring */E 	zmstuff('a');
 	return('a');N       default:  return(c);     }' }U   CHAR #ifdef CK_ANSIC' xpoas(CHAR c)  #else  xpoas(c) CHAR c;   #endif /* CK_ANSIC */,1 { /* xpoas */			/* Portuguese ISO 646 to ASCII */,     switch (c) {+       case 91:  return('A');		/* A tilde */I-       case 92:  return('C');		/* C cedilla */o+       case 93:  return('O');		/* O tilde */e+       case 123: return('a');		/* a tilde */C-       case 124: return('c');		/* c cedilla */ +       case 125: return('o');		/* o tilde */9       default:  return(c);     }1 }    CHAR #ifdef CK_ANSIC2 xspas(CHAR c)  #else  xspas(c) CHAR c;   #endif /* CK_ANSIC */5. { /* xspas */			/* Spanish ISO 646 to ASCII */     switch (c) {7       case 91:  return(33);		/* Inverted exclamation */ +       case 92:  return('N');		/* N tilde */,9       case 93:  return(63);		/* Inverted question mark */8*       case 123: return(UNK);		/* degree */+       case 124: return('n');		/* n tilde */ -       case 125: return('c');		/* c cedilla */7       default:  return(c);     }1 }1   CHAR #ifdef CK_ANSIC2 xswas(CHAR c)  #else1 xswas(c) CHAR c; , #endif /* CK_ANSIC */9. { /* xswas */			/* Swedish ISO 646 to ASCII */     switch (c) {+       case 64:  return('E');		/* E acute */2#       case 91:				/* A diaeresis */, 	zmstuff('e');
 	return('A');1#       case 92:				/* O diaeresis */4 	zmstuff('e');
 	return('O');,       case 93:				/* A ring */ 	zmstuff('a');
 	return('A');1#       case 94:				/* U diaeresis */, 	/* return('Y'); */1 	zmstuff('e');
 	return('U');1+       case 96:  return('e');		/* e acute */0$       case 123:				/* a diaeresis */ 	zmstuff('e');
 	return('a'); $       case 124:				/* o diaeresis */ 	zmstuff('e');
 	return('o');3       case 125:				/* a ring */; 	zmstuff('a');
 	return('a');8$       case 126:				/* u diaeresis */ 	/* return('y'); */3 	zmstuff('e');
 	return('u');        default:  return(c);     }, }7   CHAR #ifdef CK_ANSIC, xchas(CHAR c)  #else7 xchas(c) CHAR c; 1 #endif /* CK_ANSIC */ , { /* xchas */			/* Swiss ISO 646 to ASCII */     switch (c) {+       case 35:  return('u');		/* u grave */7+       case 64:  return('a');		/* a grave */6+       case 91:  return('e');		/* e acute */5-       case 92:  return('c');		/* c cedilla */,0       case 93:  return('e');		/* e circumflex */0       case 94:  return('i');		/* i circumflex */+       case 95:  return('e');		/* e grave */10       case 96:  return('o');		/* o circumflex */$       case 123:				/* a diaeresis */ 	zmstuff('e');
 	return('a');,$       case 124:				/* o diaeresis */ 	zmstuff('e');
 	return('o');8$       case 125:				/* u diaeresis */ 	zmstuff('e');
 	return('u'); 0       case 126: return('u');		/* u circumflex */       default:  return(c);     }, }0   CHAR #ifdef CK_ANSIC, xhuas(CHAR c)  #else2 xhuas(c) CHAR c; 2 #endif /* CK_ANSIC */ 0 { /* xhuas */			/* Hungarian ISO 646 to ASCII */     switch (c) {+       case 64:  return('A');		/* A acute */4+       case 91:  return('E');		/* E acute */1/       case 92:  return('O');		/* O diaeresis */,/       case 93:  return('U');		/* U diaeresis */,+       case 96:  return('a');		/* a acute */l+       case 123: return('e');		/* e acute */r+       case 124: return('o');		/* o acute */ +       case 125: return('u');		/* u acute */16       case 126: return(34);		/* double acute accent */       default:  return(c);     }2 }    CHAR #ifdef CK_ANSIC  xdmas(CHAR c)  #else, xdmas(c) CHAR c; , #endif /* CK_ANSIC */7& { /* xdmas */			/* DEC MCS to ASCII */F     if (langs[language].id == L_FRENCH) { /* If SET LANGUAGE FRENCH */+ 	if (c == 215) {			/* handle OE digraph. */7 	    zmstuff('E'); 	    return('O'); 1 	} else if (c == 247) {		/* Also lowercase oe. */  	    zmstuff('e'); 	    return('o');  	}     }7:     return(yl1as[c]);			/* Otherwise treat like Latin-1 */ },   CHAR #ifdef CK_ANSIC 
 xdgas(CHAR c)1 #else  xdgas(c) CHAR c; #endif /* CK_ANSIC */s, { /*  xdgas */			/* Data General to ASCII */     switch(c) {d*       case 180: return('f');		/* Florin */.       case 183: return('<');		/* Less-equal */1       case 184: return('>');		/* Greater-equal */,/       case 186: return(96);		/* Grave accent */3+       case 191: return('^');		/* Uparrow */1       case 215: 7 	if (langs[language].id == L_FRENCH) { /* OE digraph */5 	    zmstuff('E'); 	    return('O');  	} else return('O');       case 247: 7 	if (langs[language].id == L_FRENCH) { /* oe digraph */  	    zmstuff('e'); 	    return('o');  	} else return('o');-       case 175: case 179: case 220: case 222:,#       case 223: case 254: case 255: 
 	return(UNK); 4       default:				/* The rest, convert to Latin-1 */7 	return(yl1as[ydgl1[c]]);	/* and from there to ASCII */1     }, }7   CHAR #ifdef CK_ANSIC1
 xr8as(CHAR c)5 #else1 xr8as(c) CHAR c; #endif /* CK_ANSIC */K7 { /*  xr8as */				/* Hewlett Packard Roman8 to ASCII */,     switch(c) {N(       case 175: return('L');		/* Lira */*       case 190: return('f');		/* Florin */+       case 235: return('S');		/* S caron */ +       case 236: return('s');		/* s caron */U2       case 246: return('-');		/* Horizontal bar */-       case 252: return('*');		/* Solid box */N4       default:				/* The rest, convert to Latin-1 */7 	return(yl1as[yr8l1[c]]);	/* and from there to ASCII */N     }  },   CHAR #ifdef CK_ANSIC  xukl1(CHAR c)  #elser xukl1(c) CHAR c; a #endif /* CK_ANSIC */t) { /* xukl1 */			/* UK ASCII to Latin-1 */,     if (c == 35)       return(163);     else return(c);1 }1   CHAR #ifdef CK_ANSIC  xl1uk(CHAR c)  #else  xl1uk(c) CHAR c;   #endif /* CK_ANSIC */,) { /* xl1uk */			/* Latin-1 to UK ASCII */      if (c == 163)        return(35);      else return(yl1as[c]); }   ( CHAR					/* Latin-1 to French ISO 646 */ #ifdef CK_ANSIC  xl1fr(CHAR c)  #else  xl1fr(c) CHAR c;   #endif /* CK_ANSIC */,
 { /* xl1fr */1     return(yl1fr[c]);8 }     & CHAR					/* French ASCII to Latin-1 */ #ifdef CK_ANSIC2 xfrl1(CHAR c)  #else  xfrl1(c) CHAR c;   #endif /* CK_ANSIC */2
 { /* xfrl1 */7     return(yfrl1[c]);3 }2  % CHAR					/* Latin-1 to Dutch ASCII */  #ifdef CK_ANSICv xl1du(CHAR c)  #elsei xl1du(c) CHAR c; e #endif /* CK_ANSIC */ 
 { /* xl1du */      return(yl1du[c]);e }w   CHAR #ifdef CK_ANSIC3 xdul1(CHAR c)  #else  xdul1(c) CHAR c; 1 #endif /* CK_ANSIC */,. { /* xdul1 */			/* Dutch ISO 646 to Latin-1 */     return(ydul1[c]);  }    CHAR #ifdef CK_ANSIC, xfil1(CHAR c)  #else1 xfil1(c) CHAR c; 5 #endif /* CK_ANSIC */ 0 { /* xfil1 */			/* Finnish ISO 646 to Latin-1 */     return(yfil1[c]);  }    CHAR #ifdef CK_ANSIC7 xl1fi(CHAR c)  #else  xl1fi(c) CHAR c;   #endif /* CK_ANSIC */30 { /* xl1fi */			/* Latin-1 to Finnish ISO 646 */     return(yl1fi[c]);  },   CHAR #ifdef CK_ANSIC  xfcl1(CHAR c)  #else, xfcl1(c) CHAR c; 8 #endif /* CK_ANSIC */ 7 { /* xfcl1 */			/* French Canadian ISO646 to Latin-1 */N     return(yfcl1[c]);  }    CHAR #ifdef CK_ANSICU xl1fc(CHAR c)  #else  xl1fc(c) CHAR c; K #endif /* CK_ANSIC */N7 { /* xl1fc */			/* Latin-1 to French Canadian ISO646 */K     return(yl1fc[c]);  }U   CHAR #ifdef CK_ANSICN xitl1(CHAR c)  #else, xitl1(c) CHAR c; , #endif /* CK_ANSIC */K0 { /* xitl1 */			/* Italian ISO 646 to Latin-1 */     return(yitl1[c]);  },   CHAR #ifdef CK_ANSIC  xl1it(CHAR c)  #elseN xl1it(c) CHAR c; N #endif /* CK_ANSIC */U0 { /* xl1it */			/* Latin-1 to Italian ISO 646 */     return(yl1it[c]);  }0   CHAR #ifdef CK_ANSIC1 xnel1(CHAR c)  #else  xnel1(c) CHAR c;   #endif /* CK_ANSIC */,% { /* xnel1 */		 /* NeXT to Latin-1 */aF     if (langs[language].id == L_FRENCH) { /* If SET LANGUAGE FRENCH */+ 	if (c == 234) {			/* handle OE digraph. *// 	    zmstuff('E'); 	    return('O');)1 	} else if (c == 250) {		/* Also lowercase oe. */  	    zmstuff('e'); 	    return('o');i 	}     }      return(ynel1[c]);i }    CHAR #ifdef CK_ANSICd xl1ne(CHAR c)  #else  xl1ne(c) CHAR c; _ #endif /* CK_ANSIC */ % { /* xl1ne */		 /* Latin-1 to NeXT */K     return(yl1ne[c]);* }	   CHAR #ifdef CK_ANSIC. xnol1(CHAR c)  #elsel xnol1(c) CHAR c;   #endif /* CK_ANSIC */ = { /* xnol1 */		 /* Norwegian and Danish ISO 646 to Latin-1 */c     return(ynol1[c]);  })   CHAR #ifdef CK_ANSICc xl1no(CHAR c)  #elsee xl1no(c) CHAR c; a #endif /* CK_ANSIC */c= { /* xl1no */		 /* Latin-1 to Norwegian and Danish ISO 646 */-     return(yl1no[c]);  };   CHAR #ifdef CK_ANSICc xpol1(CHAR c)  #else- xpol1(c) CHAR c; u #endif /* CK_ANSIC */O3 { /* xpol1 */			/* Portuguese ISO 646 to Latin-1 */u     return(ypol1[c]);  }1   CHAR #ifdef CK_ANSICt xl1po(CHAR c)  #elseu xl1po(c) CHAR c; r #endif /* CK_ANSIC */	3 { /* xl1po */			/* Latin-1 to Portuguese ISO 646 */r     return(yl1po[c]);  }    CHAR #ifdef CK_ANSICz xspl1(CHAR c)  #elser xspl1(c) CHAR c; 2 #endif /* CK_ANSIC *//0 { /* xspl1 */			/* Spanish ISO 646 to Latin-1 */     return(yspl1[c]);  }l   CHAR #ifdef CK_ANSIC} xl1sp(CHAR c)  #else  xl1sp(c) CHAR c; H #endif /* CK_ANSIC */I0 { /* xl1sp */			/* Latin-1 to Spanish ISO 646 */     return(yl1sp[c]);  }    CHAR #ifdef CK_ANSICA xswl1(CHAR c)  #elsea xswl1(c) CHAR c; a #endif /* CK_ANSIC */ 0 { /* xswl1 */			/* Swedish ISO 646 to Latin-1 */     return(yswl1[c]);  }c   CHAR #ifdef CK_ANSICO xl1sw(CHAR c)  #else; xl1sw(c) CHAR c; 5 #endif /* CK_ANSIC */a0 { /* xl1sw */			/* Latin-1 to Swedish ISO 646 */     return(yl1sw[c]);  }    CHAR #ifdef CK_ANSICU xchl1(CHAR c)  #else  xchl1(c) CHAR c; s #endif /* CK_ANSIC */(. { /* xchl1 */			/* Swiss ISO 646 to Latin-1 */     return(ychl1[c]);  }o   CHAR #ifdef CK_ANSIC  xl1ch(CHAR c)  #elset xl1ch(c) CHAR c;   #endif /* CK_ANSIC */e. { /* xl1ch */			/* Latin-1 to Swiss ISO 646 */     return(yl1ch[c]);  }o   CHAR #ifdef CK_ANSICm xhul1(CHAR c)  #else  xhul1(c) CHAR c; c #endif /* CK_ANSIC */e2 { /* xhul1 */			/* Hungarian ISO 646 to Latin-1 */     return(yhul1[c]);- }a   CHAR #ifdef CK_ANSIC  xl1hu(CHAR c)  #else  xl1hu(c) CHAR c; * #endif /* CK_ANSIC */z2 { /* xl1hu */			/* Latin-1 to Hungarian ISO 646 */     return(yl1hu[c]);r }y   CHAR #ifdef CK_ANSICa xl1dm(CHAR c)  #elsee xl1dm(c) CHAR c;   #endif /* CK_ANSIC *//D { /* xl1dm */ /* Latin-1 to DEC Multinational Character Set (MCS) */     return(yl1dm[c]);  }    CHAR #ifdef CK_ANSIC) xl1dg(CHAR c)  #elsep xl1dg(c) CHAR c;   #endif /* CK_ANSIC */'C { /* xl1dg */ /* Latin-1 to DG International Character Set (MCS) */      return(yl1dg[c]);  }t   CHAR #ifdef CK_ANSIC	 xdml1(CHAR c)  #else* xdml1(c) CHAR c; ' #endif /* CK_ANSIC */ D { /* xdml1 */ /* DEC Multinational Character Set (MCS) to Latin-1 */F     if (langs[language].id == L_FRENCH) { /* If SET LANGUAGE FRENCH */+ 	if (c == 215) {			/* handle OE digraph. */> 	    zmstuff('E'); 	    return('O');(1 	} else if (c == 247) {		/* Also lowercase oe. */  	    zmstuff('e'); 	    return('o');t 	}     }]     return(ydml1[c]);  }y   CHAR #ifdef CK_ANSIC3 xdgl1(CHAR c)  #else  xdgl1(c) CHAR c; f #endif /* CK_ANSIC */cC { /* xdgl1 */ /* DG International Character Set (MCS) to Latin-1 */6F     if (langs[language].id == L_FRENCH) { /* If SET LANGUAGE FRENCH */+ 	if (c == 215) {			/* handle OE digraph. */C 	    zmstuff('E'); 	    return('O');x1 	} else if (c == 247) {		/* Also lowercase oe. */f 	    zmstuff('e'); 	    return('o');a 	}     };     return(ydgl1[c]);  }    CHAR #ifdef CK_ANSIC  xr8l1(CHAR c)  #else  xr8l1(c) CHAR c;   #endif /* CK_ANSIC */-5 { /* xr8l1 */ /* Hewlett Packard Roman8 to Latin-1 */9     return(yr8l1[c]);  }    CHAR #ifdef CK_ANSICO xl1r8(CHAR c)  #else	 xl1r8(c) CHAR c; / #endif /* CK_ANSIC */rC { /* xl1r8 */ /* Latin-1 to Hewlett Packard Roman8 Character Set */r     return(yl1r8[c]);  }4    O /* Translation functions for receiving files and translating them into ASCII */a   CHAR #ifdef CK_ANSIC' zl1as(CHAR c)  #else  zl1as(c) CHAR c;   #endif /* CK_ANSIC */u
 { /* zl1as */r      switch(langs[language].id) {         case L_DUTCH:t' 	if (c == 255) {			/* Dutch umlaut-y */_$ 	    zdstuff('j');		/* becomes ij */ 	    return('i');f6 	} else return(yl1as[c]);	/* all others by the book */         case L_GERMAN:, 	switch (c) {			/* German, special rules. */# 	  case 196:			/* umlaut-A -> Ae */3 	    zdstuff('e'); 	    return('A'); # 	  case 214:			/* umlaut-O -> Oe */  	    zdstuff('e'); 	    return('O'); # 	  case 220:			/* umlaut-U -> Ue *// 	    zdstuff('e'); 	    return('U');U# 	  case 228:			/* umlaut-a -> ae */e 	    zdstuff('e'); 	    return('a'); # 	  case 246:			/* umlaut-o -> oe */  	    zdstuff('e'); 	    return('o');R# 	  case 252:			/* umlaut-u -> ue */e 	    zdstuff('e'); 	    return('u');A" 	  case 223:			/* ess-zet -> ss */ 	    zdstuff('s'); 	    return('s');): 	  default: return(yl1as[c]);	/* all others by the book */ 	}       case L_DANISH:       case L_FINNISH:,       case L_NORWEGIAN:(       case L_SWEDISH:	- 	switch (c) {			/* Scandanavian languages. */ # 	  case 196:			/* umlaut-A -> Ae */  	    zdstuff('e'); 	    return('A');r# 	  case 214:			/* umlaut-O -> Oe */a" 	  case 216:			/* O-slash -> Oe */ 	    zdstuff('e'); 	    return('O');'" 	  case 220:			/* umlaut-U -> Y */ 	    /* return('Y'); */s 	    zdstuff('e'); 	    return('U');1# 	  case 228:			/* umlaut-a -> ae */  	    zdstuff('e'); 	    return('a');-# 	  case 246:			/* umlaut-o -> oe */z" 	  case 248:			/* o-slash -> oe */ 	    zdstuff('e'); 	    return('o');H" 	  case 252:			/* umlaut-u -> y */ 	    /* return('y'); */; 	    zdstuff('e'); 	    return('u');*! 	  case 197:			/* A-ring -> Aa *// 	    zdstuff('a'); 	    return('A');u(           case 229:			/* a-ring -> aa */ 	    zdstuff('a'); 	    return('a');a: 	  default: return(yl1as[c]);	/* All others by the book */ 	}       default:3 	return(yl1as[c]);		/* Not German, by the table. */a     }  }e  # CHAR					/* IBM CP437 to Latin-1 */  #ifdef CK_ANSICn x43l1(CHAR c)  #else  x43l1(c) CHAR c; u #endif /* CK_ANSIC *//
 { /* x43l1 */:     return(y43l1[c]);, }   # CHAR					/* IBM CP850 to Latin-1 */  #ifdef CK_ANSICC x85l1(CHAR c)  #elseA x85l1(c) CHAR c; s #endif /* CK_ANSIC */n
 { /* x85l1 */I     return(y85l1[c]);  }   # CHAR					/* Latin-1 to IBM CP437 */7 #ifdef CK_ANSIC  xl143(CHAR c)  #elseu xl143(c) CHAR c; e #endif /* CK_ANSIC */c
 { /* xl143 */      return(yl143[c]);' }	   CHAR					/* Latin-1 to CP850 */  #ifdef CK_ANSICi xl185(CHAR c)  #elsea xl185(c) CHAR c; ; #endif /* CK_ANSIC */ 
 { /* xl185 */e     return(yl185[c]);* }    CHAR #ifdef CK_ANSIC' x43as(CHAR c)  #else  x43as(c) CHAR c; ' #endif /* CK_ANSIC */ % { /* x43as */				/* CP437 to ASCII */f.     c = y43l1[c];			/* Translate to Latin-1 */8     return(xl143(c));			/* and from Latin-1 to ASCII. */ }A   CHAR #ifdef CK_ANSICC x85as(CHAR c)  #else* x85as(c) CHAR c;   #endif /* CK_ANSIC */)% { /* x85as */				/* CP850 to ASCII */g.     c = y85l1[c];			/* Translate to Latin-1 */8     return(xl1as(c));			/* and from Latin-1 to ASCII. */ }a  ) CHAR					/* Macintosh Latin to Latin-1 */a #ifdef CK_ANSIC' xaql1(CHAR c)  #else  xaql1(c) CHAR c; ' #endif /* CK_ANSIC */ 
 { /* xaql1 */eF     if (langs[language].id == L_FRENCH) { /* If SET LANGUAGE FRENCH */+ 	if (c == 206) {			/* handle OE digraph. */H 	    zmstuff('E'); 	    return('O');e1 	} else if (c == 207) {		/* Also lowercase oe. */  	    zmstuff('e'); 	    return('o');  	}     }a     return(yaql1[c]);  }*  ' CHAR					/* Macintosh Latin to ASCII */{ #ifdef CK_ANSICi xaqas(CHAR c)  #elsef xaqas(c) CHAR c; ( #endif /* CK_ANSIC */=
 { /* xaqas */oF     if (langs[language].id == L_FRENCH) { /* If SET LANGUAGE FRENCH */+ 	if (c == 206) {			/* handle OE digraph. */  	    zmstuff('E'); 	    return('O');n1 	} else if (c == 207) {		/* Also lowercase oe. */( 	    zmstuff('e'); 	    return('o');e 	}     }A.     c = yaql1[c];			/* Translate to Latin-1 */,     return(xl1as(c));			/* then to ASCII. */ }   ) CHAR					/* Latin-1 to Macintosh Latin */A #ifdef CK_ANSIC9 xl1aq(CHAR c)  #elsel xl1aq(c) CHAR c; 9 #endif /* CK_ANSIC */s
 { /* xl1aq */t     return(yl1aq[c]);1 }	  
 #ifdef LATIN2*  0 /* Translation functions for Latin Alphabet 2 */  ! CHAR					/* Latin-2 to Latin-1 */a #ifdef CK_ANSICi xl2l1(CHAR c)  #else  xl2l1(c) CHAR c;   #endif /* CK_ANSIC */  { /* xll2l1 */     return(yl2l1[c]);p }(  ! CHAR					/* Latin-1 to Latin-2 */  #ifdef CK_ANSICC xl1l2(CHAR c)  #else* xl1l2(c) CHAR c;   #endif /* CK_ANSIC */h { /* xll1l2 */     return(yl1l2[c]);* }t   CHAR					/* Latin-2 to ASCII */' #ifdef CK_ANSIC* xl2as(CHAR c)  #elseu xl2as(c) CHAR c; e #endif /* CK_ANSIC */e { /* xll2as */     return(yl2as[c]);1 }    CHAR					/* Latin-2 to CP852 */  #ifdef CK_ANSICn xl252(CHAR c)  #else  xl252(c) CHAR c; u #endif /* CK_ANSIC */H { /* xll252 */     return(yl252[c]);e }    CHAR					/* CP852 to Latin-2 */A #ifdef CK_ANSICp x52l2(CHAR c)  #else6 x52l2(c) CHAR c;   #endif /* CK_ANSIC */e
 { /* x52l2 */)     return(y52l2[c]);i }*   CHAR					/* CP852 to ASCII */	 #ifdef CK_ANSIC  x52as(CHAR c)  #else) x52as(c) CHAR c; t #endif /* CK_ANSIC */e { /* xl52as */=     return(yl2as[y52l2[c]]);		/* CP852 -> Latin-2 -> ASCII */  }    CHAR					/* CP852 to Latin-1 */l #ifdef CK_ANSICa x52l1(CHAR c)  #else1 x52l1(c) CHAR c; f #endif /* CK_ANSIC */c { /* xl52l1 */?     return(yl2l1[y52l2[c]]);		/* CP852 -> Latin-2 -> Latin-1 */h }O   CHAR					/* Latin-1 to CP852 */  #ifdef CK_ANSICe xl152(CHAR c)  #else* xl152(c) CHAR c; 	 #endif /* CK_ANSIC */z { /* xll152 */?     return(yl252[yl1l2[c]]);		/* Latin-1 -> Latin-2 -> CP852 */; }r   CHAR					/* Latin-2 to NeXT */ #ifdef CK_ANSICu xl2ne(CHAR c)  #else1 xl2ne(c) CHAR c; 	 #endif /* CK_ANSIC */  { /* xll2ne */     switch(c) { )       case 162: return(198);		/* Breve */;1       case 163: return(232);		/* L with stroke */ *       case 178: return(206);		/* Ogonek */1       case 179: return(248);		/* l with stroke */r)       case 183: return(207);		/* Caron */ 0       case 189: return(205);		/* Double acute */2       case 208: return(144);		/* D stroke = Eth */2       case 240: return(230);		/* d stroke = eth */-       case 255: return(199);		/* Dot above */c(       default:  return(yl1ne[yl2l1[c]]);     }C }    CHAR					/* Latin-2 to CP437 */t #ifdef CK_ANSICw xl243(CHAR c)  #else3 xl243(c) CHAR c; * #endif /* CK_ANSIC */e { /* xll243 */     return(yl1l2[y43l1[c]]); }:   CHAR					/* Latin-2 to CP850 */  #ifdef CK_ANSICn xl285(CHAR c)  #else, xl285(c) CHAR c; e #endif /* CK_ANSIC */f { /* xll285 */     return(yl1l2[y85l1[c]]); }f   CHAR					/* Latin-2 to Apple */; #ifdef CK_ANSIC  xl2aq(CHAR c)  #else' xl2aq(c) CHAR c; e #endif /* CK_ANSIC */	
 { /* xl2aq */ 4     return(yl1aq[yl2l1[c]]);		/* Could do more... */ }    CHAR					/* Latin-2 to DGI */r #ifdef CK_ANSIC  xl2dg(CHAR c)  #elsee xl2dg(c) CHAR c; ' #endif /* CK_ANSIC */  { /* xll2dg */     return(ydgl1[yl1l2[c]]); }   # CHAR					/* Latin-2 to Short KOI */  #ifdef CK_ANSICN xl2sk(CHAR c)  #elsee xl2sk(c) CHAR c;   #endif /* CK_ANSIC */C { /* xll2sk */(     return(islower(c) ? toupper(c) : c); }w   CHAR					/* NeXT to Latin-2 */ #ifdef CK_ANSICe xnel2(CHAR c)  #elsee xnel2(c) CHAR c; u #endif /* CK_ANSIC */ 
 { /* xnel2 */*     switch (c) {2       case 144: return(208);		/* D stroke = Eth */)       case 198: return(162);		/* Breve */ -       case 199: return(255);		/* Dot above */ 0       case 205: return(189);		/* Double acute */*       case 206: return(178);		/* Ogonek */)       case 207: return(183);		/* Caron */c2       case 230: return(240);		/* d stroke = eth */1       case 232: return(163);		/* L with stroke */(1       case 248: return(179);		/* l with stroke */	F       default:  return(yl1l2[ynel1[c]]); /* Others, go thru Latin-1 */     }A }A   CHAR					/* CP437 to Latin-2 */  #ifdef CK_ANSIC. x43l2(CHAR c)  #else; x43l2(c) CHAR c;   #endif /* CK_ANSIC */  { /* xl43l2 */     return(yl1l2[y43l1[c]]); }    CHAR					/* CP850 to Latin-2 */  #ifdef CK_ANSIC	 x85l2(CHAR c)  #elsek x85l2(c) CHAR c;   #endif /* CK_ANSIC */  { /* xl85l2 */     return(yl1l2[y85l1[c]]); }/   CHAR					/* Apple to Latin-2 */  #ifdef CK_ANSICS xaql2(CHAR c)  #elsed xaql2(c) CHAR c; e #endif /* CK_ANSIC *// { /* xlaql2 */     switch (c) {0       case 249: return(162);		/* Breve accent */.       case 250: return(255);		/* Dot accent */0       case 253: return(189);		/* Double acute */'       default: return(yl1l2[yaql1[c]]);n     }u }]   CHAR					/* DGI to Latin-2 */* #ifdef CK_ANSIC' xdgl2(CHAR c)  #else  xdgl2(c) CHAR c; ' #endif /* CK_ANSIC */i { /* xldgl2 */-     return(yl1l2[ydgl1[c]]);		/* (for now) */s }f  # CHAR					/* Short KOI to Latin-2 */u #ifdef CK_ANSICa xskl2(CHAR c)  #else2 xskl2(c) CHAR c;   #endif /* CK_ANSIC */a { /* xlskl2 */(     return(islower(c) ? toupper(c) : c); }e    CHAR					/* Latin-2 to German */ #ifdef CK_ANSICo xl2ge(CHAR c)  #else  xl2ge(c) CHAR c; i #endif /* CK_ANSIC */H { /* xll2ge */     switch(c) { 1       case 167: return(64);		/* Paragraph sign */t.       case 196: return(91);		/* A-diaeresis */.       case 214: return(92);		/* O-diaeresis */.       case 220: return(93);		/* U-diaeresis */,       case 223: return(126);		/* double-s *//       case 228: return(123);		/* a-diaeresis */6/       case 246: return(124);		/* o-diaeresis */2/       case 252: return(125);		/* u-diaeresis */:.       default:  return(yl2as[c]);	/* Others */     }r }[    CHAR					/* German to Latin-2 */ #ifdef CK_ANSICH xgel2(CHAR c)  #elseu xgel2(c) CHAR c; r #endif /* CK_ANSIC */e { /* xlgel2 */     switch(c) {*2       case 64:  return(167);		/* Paragraph sign *//       case 91:  return(196);		/* A-diaeresis */R/       case 92:  return(214);		/* O-diaeresis */(/       case 93:  return(220);		/* U-diaeresis */*/       case 123: return(228);		/* a-diaeresis */ ,       case 126: return(223);		/* double-s *//       case 124: return(246);		/* o-diaeresis *///       case 125: return(252);		/* u-diaeresis */((       default:  return(c);		/* Others */     }* }   # CHAR					/* Latin-2 to Hungarian */	 #ifdef CK_ANSICt xl2hu(CHAR c)  #else_ xl2hu(c) CHAR c; c #endif /* CK_ANSIC */A { /* xll2hu */     switch(c) { 2       case 164: return(36);		/* Currency symbol */7       case 189: return(126);		/* Double acute accent */H*       case 193: return(64);		/* A-acute */*       case 201: return(91);		/* E-acute */.       case 214: return(92);		/* O-diaeresis */.       case 220: return(93);		/* U-diaeresis */*       case 225: return(96);		/* a-acute */+       case 233: return(123);		/* e-acute */ /       case 246: return(124);		/* o-diaeresis */ /       case 252: return(125);		/* u-diaeresis */x.       default:  return(yl2as[c]);	/* Others */     }y }1  # CHAR					/* Hungarian to Latin-2 */l #ifdef CK_ANSICs xhul2(CHAR c)  #else  xhul2(c) CHAR c; * #endif /* CK_ANSIC */L { /* xlhul2 */     switch(c) { 3       case 36:  return(164);		/* Currency symbol */l+       case 64:  return(193);		/* A-acute */f+       case 91:  return(201);		/* E-acute */a/       case 92:  return(214);		/* O-diaeresis */)/       case 93:  return(220);		/* U-diaeresis */ +       case 96:  return(225);		/* a-acute */C+       case 123: return(233);		/* e-acute */n/       case 124: return(246);		/* o-diaeresis */H/       case 125: return(252);		/* u-diaeresis */l7       case 126: return(189);		/* Double acute accent */*(       default:  return(c);		/* Others */     }c }    CHAR #ifdef CK_ANSICN xr8l2(CHAR c)  #elsee xr8l2(c) CHAR c;   #endif /* CK_ANSIC */C5 { /* xr8l2 */ /* Hewlett Packard Roman8 to Latin-2 */      switch (c) {+       case 235: return(169);		/* S caron */R+       case 236: return(185);		/* s caron */K(       default:  return(yl1l2[yr8l1[c]]);     }a }    CHAR #ifdef CK_ANSIC= xl2r8(CHAR c)  #else  xl2r8(c) CHAR c;   #endif /* CK_ANSIC */aC { /* xl2r8 */ /* Latin-2 to Hewlett Packard Roman8 Character Set */      switch (c) {+       case 169: return(235);		/* S caron */ +       case 185: return(236);		/* s caron */e(       default:  return(yr8l1[yl1l2[c]]);     }R }    #else /* NOLATIN2 */   #define xl2l1 NULL #define xl1l2 NULL #define xl2as NULL #define xl252 NULL #define x52l2 NULL #define x52as NULL #define x52l1 NULL #define xl152 NULL #define xl2ne NULL #define xl243 NULL #define xl285 NULL #define xl2aq NULL #define xl2dg NULL #define xl2sk NULL #define xnel2 NULL #define x43l2 NULL #define x85l2 NULL #define xaql2 NULL #define xdgl2 NULL #define xskl2 NULL #define xl2ge NULL #define xgel2 NULL #define xl2hu NULL #define xhul2 NULL #define xl2r8 NULL #define xr8l2 NULL #endif /* LATIN2 */d   #ifdef CYRILLIC 7 /* Translation functions for Cyrillic character sets */     CHAR					/* Latin/Cyrillic to */ #ifdef CK_ANSICp xlcac(CHAR c)  #elsep xlcac(c) CHAR c; d #endif /* CK_ANSIC */*- { /* xlcac */			/* Microsoft Code Page 866 */r     return(ylcac[c]);  }   * CHAR					/* Latin/Cyrillic to Old KOI-8 */ #ifdef CK_ANSICA xlck8(CHAR c)  #elseS xlck8(c) CHAR c; * #endif /* CK_ANSIC */t
 { /* xlck8 */      return(ylck8[c]);l }    CHAR #ifdef CK_ANSICl xlcsk(CHAR c)  #elsel xlcsk(c) CHAR c; e #endif /* CK_ANSIC */ 1 { /* xlcsk */			/* Latin/Cyrillic to Short KOI */      return(ylcsk[c]);  }H   CHAR #ifdef CK_ANSICl xlcas(CHAR c)  #elsel xlcas(c) CHAR c; d #endif /* CK_ANSIC */*- { /* xlcas */			/* Latin/Cyrillic to ASCII */ (     if (langs[language].id == L_RUSSIAN)       return(ylcsk[c]);      else"       return((c > 127) ? '?' : c); }a   CHAR					/* CP866 */ #ifdef CK_ANSICS xaclc(CHAR c)  #else1 xaclc(c) CHAR c; R #endif /* CK_ANSIC */l' { /* xaclc */			/* to Latin/Cyrillic */e     return(yaclc[c]);  }x  * CHAR					/* Old KOI-8 to Latin/Cyrillic */ #ifdef CK_ANSIC  xk8lc(CHAR c)  #else_ xk8lc(c) CHAR c; c #endif /* CK_ANSIC */A
 { /* xk8lc *//     return(yk8lc[c]);1 }*   CHAR #ifdef CK_ANSICS xskcy(CHAR c)  #else1 xskcy(c) CHAR c; R #endif /* CK_ANSIC */l1 { /* xskcy */			/* Short KOI to Latin/Cyrillic */K     return(yskcy[c & 0x7f]); }n   CHAR #ifdef CK_ANSIC  xascy(CHAR c)  #else) xascy(c) CHAR c; d #endif /* CK_ANSIC */R- { /* xascy */			/* ASCII to Latin/Cyrillic */AH     if (langs[language].id == L_RUSSIAN) { /* If LANGUAGE == RUSSIAN  */8 	return(yskcy[c & 0x7f]);	/* treat ASCII as Short KOI */'     } else return((c > 127) ? '?' : c);A }C   CHAR #ifdef CK_ANSICt xacas(CHAR c)  #elsea xacas(c) CHAR c; S #endif /* CK_ANSIC */c$ { /* xacas */			/* CP866 to ASCII */*     if (langs[language].id == L_RUSSIAN) {. 	c = yaclc[c];			/* First to Latin/Cyrillic */+ 	return(ylcsk[c]);		/* Then to Short KOI */ '     } else return((c > 127) ? '?' : c);C }N   CHAR #ifdef CK_ANSICs xskas(CHAR c)  #else  xskas(c) CHAR c; * #endif /* CK_ANSIC */C( { /* xskas */			/* Short KOI to ASCII */     return((c > 95) ? '?' : c);d }    CHAR #ifdef CK_ANSICG xk8as(CHAR c)  #else= xk8as(c) CHAR c; e #endif /* CK_ANSIC */z1 { /* xk8as */			/* Old KOI-8 Cyrillic to ASCII */2*     if (langs[language].id == L_RUSSIAN) {. 	c = yk8lc[c];			/* First to Latin/Cyrillic */+ 	return(ylcsk[c]);		/* Then to Short KOI */3'     } else return((c > 127) ? '?' : c);; }    CHAR #ifdef CK_ANSIC  xassk(CHAR c)  #elsen xassk(c) CHAR c; e #endif /* CK_ANSIC */ ( { /* xassk */			/* ASCII to Short KOI */,     c &= 0x77;				/* Force it to be ASCII */B     return((c > 95) ? (c - 32) : c);	/* Fold columns 6-7 to 4-5 */ }}   CHAR #ifdef CK_ANSIC  xl1sk(CHAR c)  #else  xl1sk(c) CHAR c;   #endif /* CK_ANSIC */ * { /* xl1sk */			/* Latin-1 to Short KOI */*     c = zl1as(c);			/* Convert to ASCII */;     return(c = xassk(c));		/* Convert ASCII to Short KOI */w }t   CHAR #ifdef CK_ANSIC1 xaslc(CHAR c)  #elsec xaslc(c) CHAR c; i #endif /* CK_ANSIC */H- { /* xaslc */			/* ASCII to Latin/Cyrillic */K(     if (langs[language].id == L_RUSSIAN)       return(yskcy[c & 0x7f]);     else return(c & 0x7f); }    CHAR #ifdef CK_ANSICn xasac(CHAR c)  #elsel xasac(c) CHAR c; t #endif /* CK_ANSIC */H$ { /* xasac */			/* ASCII to CP866 */>     if (langs[language].id == L_RUSSIAN) { /* Use Short KOI */2 	c = xskcy(c);			/* Translate to Latin/Cyrillic */' 	return(ylcac[c]);		/* Then to CP866 */a     } else return(c & 0x7f); }b   CHAR #ifdef CK_ANSIC( xask8(CHAR c)  #elsey xask8(c) CHAR c; h #endif /* CK_ANSIC */ $ { /* xask8 */			/* ASCII to KOI-8 */>     if (langs[language].id == L_RUSSIAN) { /* Use Short KOI */2 	c = xskcy(c);			/* Translate to Latin/Cyrillic */' 	return(ylck8[c]);		/* Then to KOI-8 */'     } else return(c & 0x7f); }  #else /* No Cyrillic */* #define xacas NULL #define xaclc NULL #define xasac NULL #define xascy NULL #define xask8 NULL #define xaslc NULL #define xassk NULL #define xk8as NULL #define xk8lc NULL #define xl1sk NULL #define xlcac NULL #define xlcas NULL #define xlck8 NULL #define xlch7 NULL #define xlcsk NULL #define xskas NULL #define xskcy NULL #endif /* CYRILLIC */t  5 /* Translation functions for Hebrew character sets */   
 #ifdef HEBREW    CHAR #ifdef CK_ANSIC  xash7(CHAR c)  #else  xash7(c) CHAR c; H #endif /* CK_ANSIC */S' { /* xash7 */			/* ASCII to Hebrew-7 */	     if (c == 96) return('?');s*     if (c > 96 && c < 123) return(c - 32);     else return(c);* }    CHAR #ifdef CK_ANSIC  xl1h7(CHAR c)  #else' xl1h7(c) CHAR c; O #endif /* CK_ANSIC */ ) { /* xl1h7 */			/* Latin-1 to Hebrew-7 */      return(xash7(xl1as(c))); }U   CHAR #ifdef CK_ANSICm xl1lh(CHAR c)  #elsez xl1lh(c) CHAR c; r #endif /* CK_ANSIC */4- { /* xl1lh */			/* Latin-1 to Latin/Hebrew */-     switch(c) { 4       case 170: return('a');		/* Feminine ordinal */5       case 186: return('o');		/* Masculine ordinal */u)       case 215: return(170);		/* Times */	*       case 247: return(186);		/* Divide */3       default:  return( (c > 190) ? xl1as(c) : c );a     }  }z   CHAR #ifdef CK_ANSIC( xl2h7(CHAR c)  #elseu xl2h7(c) CHAR c; l #endif /* CK_ANSIC */ ) { /* xl2h7 */			/* Latin-2 to Hebrew-7 */N     return(xash7(xl2as(c))); }    #ifndef NOCYRIL/ CHAR #ifdef CK_ANSIC* xlch7(CHAR c)  #else4 xlch7(c) CHAR c;   #endif /* CK_ANSIC */e0 { /* xlch7 */			/* Latin/Cyrillic to Hebrew-7 */     return(xash7(xlcas(c))); }  #endif /* NOCYRIL */   CHAR #ifdef CK_ANSICH xlhas(CHAR c)  #else) xlhas(c) CHAR c; / #endif /* CK_ANSIC */5+ { /* xlhas */			/* Latin/Hebrew to ASCII */	"     return( (c > 127) ? '?' : c ); }_   CHAR #ifdef CK_ANSICe xlhl1(CHAR c)  #elsee xlhl1(c) CHAR c; C #endif /* CK_ANSIC */ - { /* xlhl1 */			/* Latin/Hebrew to Latin-1 */      switch (c) {       case 170: return(215);       case 186: return(247);-       default: return( (c > 190) ? '?' : c );n     }c }*   CHAR #ifdef CK_ANSICN xlh62(CHAR c)  #elsee xlh62(c) CHAR c;   #endif /* CK_ANSIC */C+ { /* xlh62 */			/* Latin/Hebrew to CP862 */      return(ylh62[c]);T }s   CHAR #ifdef CK_ANSICe xl162(CHAR c)  #elsed xl162(c) CHAR c; C #endif /* CK_ANSIC */d& { /* xl162 */			/* Latin-1 to CP862 */3     return(xlh62(xl1lh(c)));	/* Via Latin/Hebrew */* }	   CHAR #ifdef CK_ANSIC  xlhh7(CHAR c)  #elsea xlhh7(c) CHAR c; / #endif /* CK_ANSIC */	. { /* xlhh7 */			/* Latin/Hebrew to Hebrew-7 */     return(ylhh7[c]);o }t   CHAR #ifdef CK_ANSIC' xh7as(CHAR c)  #else  xh7as(c) CHAR c; ' #endif /* CK_ANSIC */ ' { /* xh7as */			/* Hebrew-7 to ASCII */.,     return( (c > 95 && c < 123) ? '?' : c ); }i   CHAR #ifdef CK_ANSICe x62lh(CHAR c)  #elsez x62lh(c) CHAR c; r #endif /* CK_ANSIC */f+ { /* x62lh */			/* CP862 to Latin/Hebrew */      return(y62lh[c]);t }(   CHAR #ifdef CK_ANSICe x62as(CHAR c)  #else  x62as(c) CHAR c; s #endif /* CK_ANSIC */i$ { /* x62as */			/* CP862 to ASCII */     return( xlhas(x62lh(c)) ); }A   CHAR #ifdef CK_ANSIC  x62l1(CHAR c)  #else. x62l1(c) CHAR c; * #endif /* CK_ANSIC */ & { /* x62l1 */			/* CP862 to Latin-1 */     return( xlhl1(x62lh(c)) ); }r   CHAR #ifdef CK_ANSIC( xh7lh(CHAR c)  #elsew xh7lh(c) CHAR c;   #endif /* CK_ANSIC */t. { /* xh7lh */			/* Hebrew-7 to Latin/Hebrew */     return(yh7lh[c]);  }    #else /* No Hebrew */e   #define xash7 NULL #define xl1h7 NULL #define xl2h7 NULL #define xlch7 NULL #define xl1lh NULL #define xlhas NULL #define xlhl1 NULL #define xl162 NULL #define xlhh7 NULL #define xlh62 NULL #define xh7as NULL #define x62as NULL #define x62l1 NULL #define xh7lh NULL #define x62lh NULL   #endif /* HEBREW */l  = /* Translation functions for Japanese Kanji character sets */    #ifdef KANJI /*K   Translate Kanji Transfer Character Set (EUC) to local file character set, J   contributed by Dr. Hirofumi Fujii, Japan High Energy Research Laboratory   (KEK), Tokyo, Japan.  E   a is a byte to be translated, which may be a single-byte character,HK   the Katakana prefix, the first byte of a two-byte Kanji character, or the (   second byte of 2-byte Kanji character.     fn is the output function.  &   Returns 0 on success, -1 on failure. */  , _PROTOTYP(static int jpnxas, (int, int[]) );, _PROTOTYP(static int jpnxkt, (int, int[]) );. _PROTOTYP(static int jpnxkn, (int[], int[]) );  6 static int jpncnt;       /* byte count for Japanese */5 static int jpnlst;       /* last status (for JIS7) */5  
 static intM jpnxas(a, obuf) int a; int obuf[]; { /* Translate ASCII to local file code */S
     int r;  
     r = 0;     if (fcharset == FC_JIS7) { 	switch (jpnlst) {
 	  case 1: 	    obuf[0] = 0x0f; 	    obuf[1] = a;d 	    r = 2;  	    break; 
 	  case 2: 	    obuf[0] = 0x1b; 	    obuf[1] = 0x28; 	    obuf[2] = 0x4a; 	    obuf[3] = a;; 	    r = 4;  	    break;t 	  default:  	    obuf[0] = a;- 	    r = 1;  	    break;N 	}     } else {
 	obuf[0] = a;5 	r = 1;      }e     return(r); }z  
 static int% jpnxkt(a, obuf) int a; int obuf[]; { t0 /* Translate JIS X 201 Katakana to local code */  
     int r;   
     r = 0;     if (fcharset == FC_JIS7) { 	switch (jpnlst) { 	  case 2:				/* from Kanji */ 	    obuf[r++] = 0x1b; 	    obuf[r++] = 0x28; 	    obuf[r++] = 0x4a; 	  case 0:				/* from Roman */ 	    obuf[r++] = 0x0e; 	  default:n 	    obuf[r++] = (a & 0x7f);	 	  break;u 	}     } else { 	if (fcharset == FC_JEUC)3 	  obuf[r++] = 0x8e; 	obuf[r++] = (a | 0x80);     }5     return(r); }   
 static int( jpnxkn(ibuf, obuf) int ibuf[], obuf[]; {2     /* Translate JIS X 0208 Kanji to local code */     int c1, c2;e
     int r;       c1 = ibuf[0] & 0x7f;     c2 = ibuf[1] & 0x7f;       if (fcharset == FC_SHJIS) {i 	if (c1 & 1) 	  c2 += 0x1f; 	elsel 	  c2 += 0x7d;           if (c2 >= 0x7f) c2++;/  '         c1 = ((c1 - 0x21) >> 1) + 0x81;y"         if (c1 > 0x9f) c1 += 0x40;           obuf[0] = c1;d         obuf[1] = c2;R         r = 2;%     } else if (fcharset == FC_JIS7) {f         r = 0;         switch (jpnlst) {]   	  case 1:* 	    obuf[r++] = 0x0f; /* From Katakana */   	  case 0: 	    obuf[r++] = 0x1b; 	    obuf[r++] = 0x24; 	    obuf[r++] = 0x42; 	  default:y 	    obuf[r++] = c1; 	    obuf[r++] = c2; 	    break;/ 	}     } else {         obuf[0] = (c1 | 0x80);         obuf[1] = (c2 | 0x80);         r = 2;     }      return(r); }    intn
 xkanjf() {& /* Initialize parameters for xkanji */@ /* This function should be called when F/X-packet is received */     jpncnt = jpnlst = 0;     return(0); }/   inte #ifdef CK_ANSIC  xkanjz( int (*fn)(char) )R #else  xkanjz( fn ) int (*fn)();C #endif /* CK_ANSIC */  { /* xkanjz */ /*   Terminate xkanji8   This function must be called when Z-packet is received   (before closing the file). */     static int obuf[6];e     int r, i, c;        if (fcharset == FC_JIS7) {.         c = 'A';			/* Dummy Roman character */A         r = jpnxas(c, obuf) - 1;	/* -1 removes Dummy character */          if (r > 0) { 	    for (i = 0; i < r; i++)) 	      if ( ((*fn)((char) obuf[i])) < 0 )  		return( -1 );u 	}     }*     return( 0 ); }    inte #ifdef CK_ANSIC; xkanji(int a, int (*fn)(char)) #else ! xkanji(a, fn) int a; int (*fn)();  #endif /* CK_ANSIC */  { /* xkanji */     static int xbuf[2];      static int obuf[8];(  
     int i, r;      int c7;      int state;  
     r = 0;     if (jpncnt == 0) { 	/* 1st byte */] 	if ( (a & 0x80) == 0 ) { / 	    /* 8th bit is 0, i.e., single-byte code */  	    r = jpnxas(a, obuf);  	    state = 0;C	 	} else {x( 	    /* 8th bit is 1, check the range */ 	    c7 = a & 0x7f; : 	    if ( ((c7 > 0x20) && (c7 < 0x7f)) || (c7 == 0x0e) ) { 	        /* double byte code */S 	        xbuf[jpncnt++] = a;
 	    } else {  	        /* single byte code */e 	        r = jpnxas(a, obuf);u 	        state = 0;n 	    } 	}     } else { 	/* not the 1st byte */  	xbuf[jpncnt++] = a; 	if (xbuf[0] == 0x8e) { ! 	    r = jpnxkt( xbuf[1], obuf );n 	    state = 1;_	 	} else {l 	    r = jpnxkn(xbuf, obuf); 	    state = 2;/ 	}     }*     if (r > 0) {          for (i = 0; i < r; i++ )% 	  if ( ((*fn)((char) obuf[i])) < 0 )  	    return( -1 );         jpnlst = state;H         jpncnt = 0;(     }      return( 0 ); }S   /*;   Function for translating from Japanese file character sete)   to Japanese EUC transfer character set.f<   Returns a pointer to a string containing 0, 1, or 2 bytes. */   /* zkanji */+ static int jpnstz;			/* status for JIS-7 */72 static int jpnpnd;			/* number of pending bytes *// static int jpnpnt;			/* pending buffer index */ , static int jpnpbf[8];			/* pending buffer */   intn zkanjf() {				/* Initialize */!     jpnstz = jpnpnd = jpnpnt = 0;      return(0); }    int1
 zkanjz() {     return( 0 ); }a   int  #ifdef CK_ANSICo zkanji( int (*fn)(void) )2 #elseu zkanji( fn ) int (*fn)();: #endif /* CK_ANSIC */n { /* zkanji */@     /* Read Japanese local code and translate to Japanese EUC */
     int a;     int sc[3];          /* No pending characters */AA     if (fcharset == FC_SHJIS) {		/* Translating from Shift-JIS */1         if (jpnpnd) {              jpnpnd--;u'             return( jpnpbf[jpnpnt++] );9	         }2                  a = (*fn)(); 	jpnpnd = jpnpnt = 0;	$ 	if (((a >= 0x81) && (a <= 0x9f)) ||< 	    ((a >= 0xe0) && (a <= 0xfc))) { /* 2-byte Kanji code */ 	    sc[0] = a; 5 	    if ((sc[1] = (*fn)()) < 0)	/* Get second byte */a 	      return( sc[1] );u 	    if (sc[0] <= 0x9f)a 	      sc[0] -= 0x71;h	 	    else  	      sc[0] -= 0xb1;a 	    sc[0] = sc[0] * 2 + 1;f 	    if (sc[1] > 0x7f) 	      sc[1]--;( 	    if (sc[1] >= 0x9e) {A 	        sc[1] -= 0x7d;  	        sc[0]++; 
 	    } else {e 	        sc[1] -= 0x1f;m 	    } 	    a = (sc[0] | 0x80);  	    jpnpbf[0] = (sc[1] | 0x80); 	    jpnpnd = 1; 	    jpnpnt = 0;8 	} else if ((a >= 0xa1) && (a <= 0xdf)) { /* Katakana */ 	    jpnpbf[0] = a;/ 	    jpnpnd = 1; 	    jpnpnt = 0; 	    a = 0x8e; 	} 	return(a); =     } else if (fcharset == FC_JIS7 ) {	/* 7-bit JIS X 0208 */1         if (jpnpnd) { !             a = jpnpbf[jpnpnt++];a 	    jpnpnd--;             return(a);	         }r         jpnpnt = 0;l         if ((a = (*fn)()) < 0)
 	  return(a);          while (jpnpnd == 0) {n+             if ((a > 0x20) && (a < 0x7f)) {s!                 switch (jpnstz) {K 		  case 1: - 		    jpnpbf[jpnpnd++] = 0x80; /* Katakana */ $ 		    jpnpbf[jpnpnd++] = (a | 0x80); 		    break; 		  case 2:;0 		    jpnpbf[jpnpnd++] = (a | 0x80); /* Kanji */ 		    if ((a = (*fn)()) < 0) 		      return(a);$ 		    jpnpbf[jpnpnd++] = (a | 0x80); 		    break; 		  default:- 		    jpnpbf[jpnpnd++] = a; /* Single byte */  		    break;                 }u#             } else if (a == 0x0e) {	                 jpnstz = 1;e&                 if ((a = (*fn)()) < 0) 		  return(a);#             } else if (a == 0x0f) {*                 jpnstz = 0;;&                 if ((a = (*fn)()) < 0) 		  return(a);#             } else if (a == 0x1b) {;2                 jpnpbf[jpnpnd++] = a;	/* Escape */&                 if ((a = (*fn)()) < 0) 		  return(a);%                 jpnpbf[jpnpnd++] = a;                  if (a == '$') {s*                     if ((a = (*fn)()) < 0) 		      return(a);)                     jpnpbf[jpnpnd++] = a; 3                     if ((a == '@') || (a == 'B')) { #                         jpnstz = 2;k 			jpnpnt = jpnpnd = 0;*.                         if ((a = (*fn)()) < 0) 			  return(a);                      }n&                 } else if (a == '(') {*                     if ((a = (*fn)()) < 0) 		      return( a );)                     jpnpbf[jpnpnd++] = a;n3                     if ((a == 'B') || (a == 'J')) { #                         jpnstz = 0;L 			jpnpnt = jpnpnd = 0;f.                         if ((a = (*fn)()) < 0) 			  return(a);l                     } '                 } else if (a == 0x1b) {U(                     jpnpnt = jpnpnd = 0;*                     if ((a = (*fn)()) < 0) 		      return(a);                 }d             } else {%                 jpnpbf[jpnpnd++] = a;f
             } 	         }l         jpnpnt = 0;I         a = jpnpbf[jpnpnt++];T
 	jpnpnd--;         return(a);     } else {         a = (*fn)();         return(a);     }f }_ #endif /* KANJI */  & /*  TABLES OF TRANSLATION FUNCTIONS */   /*J   First, the table of translation functions for RECEIVING files.  That is,L   *from* the TRANSFER character set *to* the FILE character set, an array ofG   pointers to functions.  The first index is the TRANSFER CHARACTER-SET*<   number, the second index is the FILE CHARACTER-SET number.  J   These arrays must be fully populated, even if (as is the case with KanjiB   character sets), all the entries are NULL.  Otherwise, subscript?   calculations will be wrong and we'll use the wrong functions.d */   #ifdef CK_ANSIC*. CHAR (*xlr[MAXTCSETS+1][MAXFCSETS+1])(CHAR) =  #elsef* CHAR (*xlr[MAXTCSETS+1][MAXFCSETS+1])() =  #endif /* CK_ANSIC */l { -     NULL,			/* 0,0 transparent to us ascii */	-     NULL,			/* 0,1 transparent to uk ascii */ .     NULL,			/* 0,2 transparent to dutch nrc */0     NULL,			/* 0,3 transparent to finnish nrc *//     NULL,			/* 0,4 transparent to french nrc */ 4     NULL,			/* 0,5 transparent to fr-canadian nrc *//     NULL,			/* 0,6 transparent to german nrc */*2     NULL,			/* 0,7 transparent to hungarian nrc */0     NULL,			/* 0,8 transparent to italian nrc */5     NULL,			/* 0,9 transparent to norge/danish nrc */	4     NULL,			/* 0,10 transparent to portuguese nrc */1     NULL,			/* 0,11 transparent to spanish nrc */R1     NULL,			/* 0,12 transparent to swedish nrc */C/     NULL,			/* 0,13 transparent to swiss nrc */*-     NULL,			/* 0,14 transparent to latin-1 *//-     NULL,			/* 0,15 transparent to latin-2 */ -     NULL,			/* 0,16 transparent to DEC MCS */l*     NULL,			/* 0,17 transparent to NeXT */+     NULL,			/* 0,18 transparent to CP437 */a+     NULL,			/* 0,19 transparent to CP850 */*+     NULL,			/* 0,20 transparent to CP852 */g5     NULL,			/* 0,21 transparent to Macintosh Latin */s)     NULL,			/* 0,22 transparent to DGI */	(     NULL,			/* 0,23 transparent to HP */4     NULL,			/* 0,24 transparent to Latin/Cyrillic */?     NULL,                       /* 0,25 transparent to CP866 */*1     NULL,			/* 0,26 transparent to Short KOI-7 */eL     NULL,                       /* 0,27 transparent to Old KOI-8 Cyrillic */+     NULL,			/* 0,28 transparent to JIS-7 */z/     NULL,			/* 0,29 transparent to Shift-JIS */*+     NULL,			/* 0,30 transparent to J-EUC */{/     NULL,			/* 0,31 transparent to DEC Kanji */ .     NULL,			/* 0,32 transparent to Hebrew-7 */2     NULL,			/* 0,33 transparent to Latin/Hebrew */2     NULL,			/* 0,34 transparent to CP862 Hebrew */'     NULL,			/* 1,0 ascii to us ascii */s'     NULL,			/* 1,1 ascii to uk ascii */=(     NULL,			/* 1,2 ascii to dutch nrc */*     NULL,			/* 1,3 ascii to finnish nrc */)     NULL,			/* 1,4 ascii to french nrc */N.     NULL,			/* 1,5 ascii to fr-canadian nrc */)     NULL,			/* 1,6 ascii to german nrc */*,     NULL,			/* 1,7 ascii to hungarian nrc */*     NULL,			/* 1,8 ascii to italian nrc *//     NULL,			/* 1,9 ascii to norge/danish nrc */H.     NULL,			/* 1,10 ascii to portuguese nrc */+     NULL,			/* 1,11 ascii to spanish nrc */*+     NULL,			/* 1,12 ascii to swedish nrc */ )     NULL,			/* 1,13 ascii to swiss nrc */ '     NULL,			/* 1,14 ascii to latin-1 */r'     NULL,			/* 1,15 ascii to latin-2 */n'     NULL,			/* 1,16 ascii to DEC MCS */;$     NULL,			/* 1,17 ascii to NeXT */%     NULL,			/* 1,18 ascii to CP437 */g%     NULL,			/* 1,19 ascii to CP850 */h%     NULL,			/* 1,20 ascii to CP852 */t/     NULL,			/* 1,21 ascii to Macintosh Latin */e#     NULL,			/* 1,22 ascii to DGI */ "     NULL,			/* 1,23 ascii to HP */B     xaslc,                      /* 1,24 ascii to Latin/Cyrillic */9     xasac,                      /* 1,25 ascii to CP866 */a=     xassk,                      /* 1,26 ascii to Short KOI */ F     xask8,                      /* 1,27 ascii to Old KOI-8 Cyrillic */%     NULL,			/* 1,28 ascii to JIS-7 */s)     NULL,			/* 1,29 ascii to Shift-JIS */d%     NULL,			/* 1,30 ascii to J-EUC */d)     NULL,			/* 1,31 ascii to DEC Kanji */n)     xash7,			/* 1,32 ascii to Hebrew-7 */k,     NULL,			/* 1,33 ascii to Latin/Hebrew */,     NULL,			/* 1,34 ascii to CP862 Hebrew */*     zl1as,			/* 2,0 latin-1 to us ascii */*     xl1uk,			/* 2,1 latin-1 to uk ascii */+     xl1du,			/* 2,2 latin-1 to dutch nrc */a-     xl1fi,			/* 2,3 latin-1 to finnish nrc */ ,     xl1fr,			/* 2,4 latin-1 to french nrc */1     xl1fc,			/* 2,5 latin-1 to fr-canadian nrc */K,     xl1ge,			/* 2,6 latin-1 to german nrc */-     xl1it,			/* 2,7 latin-1 to italian nrc */(/     xl1hu,			/* 2,8 latin-1 to hungarian nrc */r2     xl1no,			/* 2,9 latin-1 to norge/danish nrc */1     xl1po,			/* 2,10 latin-1 to portuguese nrc */ .     xl1sp,			/* 2,11 latin-1 to spanish nrc */.     xl1sw,			/* 2,12 latin-1 to swedish nrc */,     xl1ch,			/* 2,13 latin-1 to swiss nrc */)     NULL,			/* 2,14 latin-1 to latin-1 */**     xl1l2,			/* 2,15 latin-1 to latin-2 */*     xl1dm,			/* 2,16 latin-1 to DEC MCS */'     xl1ne,			/* 2,17 latin-1 to NeXT */n(     xl143,			/* 2,18 latin-1 to CP437 */(     xl185,			/* 2,19 latin-1 to CP850 */(     xl152,			/* 2,20 latin-1 to CP852 */2     xl1aq,			/* 2,21 latin-1 to Macintosh Latin */&     xl1dg,			/* 2,22 latin-1 to DGI */,     xl1r8,			/* 2,23 latin-1 to HP Roman8 */1     zl1as,			/* 2,24 latin-1 to Latin/Cyrillic */r;     zl1as,                      /* 2,25 latin-1 to CP866 *//?     xl1sk,                      /* 2,26 latin-1 to Short KOI */;<     zl1as,		       	/* 2,27 latin-1 to Old KOI-8 Cyrillic */'     NULL,			/* 2,28 latin-1 to JIS-7 */)+     NULL,			/* 2,29 latin-1 to Shift-JIS */C'     NULL,			/* 2,30 latin-1 to J-EUC */)+     NULL,			/* 2,31 latin-1 to DEC Kanji */s+     xl1h7,			/* 2,32 latin-1 to Hebrew-7 */n/     xl1lh,			/* 2,33 latin-1 to Latin/Hebrew */N/     xl162,			/* 2,34 latin-1 to CP862 Hebrew */ *     xl2as,			/* 3,0 latin-2 to us ascii */*     xl2as,			/* 3,1 latin-2 to uk ascii */+     xl2as,			/* 3,2 latin-2 to dutch nrc */6-     xl2as,			/* 3,3 latin-2 to finnish nrc */),     xl2as,			/* 3,4 latin-2 to french nrc */1     xl2as,			/* 3,5 latin-2 to fr-canadian nrc */ ,     xl2as,			/* 3,6 latin-2 to german nrc */-     xl2as,			/* 3,7 latin-2 to italian nrc */ /     xl2as,			/* 3,8 latin-2 to hungarian nrc */s2     xl2as,			/* 3,9 latin-2 to norge/danish nrc */1     xl2as,			/* 3,10 latin-2 to portuguese nrc */2.     xl2as,			/* 3,11 latin-2 to spanish nrc */.     xl2as,			/* 3,12 latin-2 to swedish nrc */,     xl2as,			/* 3,13 latin-2 to swiss nrc */*     xl2l1,			/* 3,14 latin-2 to latin-1 */)     NULL,			/* 3,15 latin-2 to latin-2 */_*     xl2l1,			/* 3,16 latin-2 to DEC MCS */'     xl2ne,			/* 3,17 latin-2 to NeXT */s(     xl243,			/* 3,18 latin-2 to CP437 */(     xl285,			/* 3,19 latin-2 to CP850 */(     xl252,			/* 3,20 latin-2 to CP852 */2     xl2aq,			/* 3,21 latin-2 to Macintosh Latin */&     xl2dg,			/* 3,22 latin-2 to DGI */%     xl2r8,			/* 3,23 latin-2 to HP */ 1     xl2as,			/* 3,24 latin-2 to Latin/Cyrillic */C;     xl2as,                      /* 3,25 latin-2 to CP866 */ ?     xl2sk,                      /* 3,26 latin-2 to Short KOI */N<     xl2as,		       	/* 3,27 latin-2 to Old KOI-8 Cyrillic */'     NULL,			/* 3,28 latin-2 to JIS-7 */a+     NULL,			/* 3,29 latin-2 to Shift-JIS */ '     NULL,			/* 3,30 latin-2 to J-EUC */ +     NULL,			/* 3,31 latin-2 to DEC Kanji */C+     xl2h7,			/* 3,32 latin-2 to Hebrew-7 */b/     xl2as,			/* 3,33 latin-2 to Latin/Hebrew */ /     xl2as,			/* 3,34 latin-2 to CP862 Hebrew */U1     xlcas,			/* 4,0 latin/cyrillic to us ascii */ 1     xlcas,			/* 4,1 latin/cyrillic to uk ascii */ :     xlcas, 		        /* 4,2 latin/cyrillic to dutch nrc */6     xlcas,			/* 4,3 latin/cyrillic to finnish ascii */3     xlcas,			/* 4,4 latin/cyrillic to french nrc *//8     xlcas,			/* 4,5 latin/cyrillic to fr-canadian nrc */3     xlcas,			/* 4,6 latin/cyrillic to german nrc */ 4     xlcas,			/* 4,7 latin/cyrillic to italian nrc */6     xlcas,			/* 4,8 latin/cyrillic to hungarian nrc */9     xlcas,			/* 4,9 latin/cyrillic to norge/danish nrc */ 8     xlcas,			/* 4,10 latin/cyrillic to portuguese nrc */5     xlcas,			/* 4,11 latin/cyrillic to spanish nrc */t5     xlcas,			/* 4,12 latin/cyrillic to swedish nrc */t3     xlcas,			/* 4,13 latin/cyrillic to swiss nrc */ 1     xlcas,			/* 4,14 latin/cyrillic to latin-1 */O1     xlcas,			/* 4,15 latin/cyrillic to latin-2 */t1     xlcas,			/* 4,16 latin/cyrillic to DEC MCS */i.     xlcas,			/* 4,17 latin/cyrillic to NeXT *//     xlcas,			/* 4,18 latin/cyrillic to CP437 */t/     xlcas,			/* 4,19 latin/cyrillic to CP850 */t/     xlcas,			/* 4,20 latin/cyrillic to CP852 */ 9     xlcas,			/* 4,21 latin/cyrillic to Macintosh Latin */ -     xlcas,			/* 4,22 latin/cyrillic to DGI */j,     xlcas,			/* 4,23 latin/cyrillic to HP */K     NULL,                       /* 4,24 latin/cyrillic to Latin/Cyrillic */;B     xlcac,                      /* 4,25 latin/cyrillic to CP866 */F     xlcsk,                      /* 4,26 latin/cyrillic to Short KOI */C     xlck8,		       	/* 4,27 latin/cyrillic to Old KOI-8 Cyrillic */ +     NULL,			/* 4,28 latin/cyril to JIS-7 */f/     NULL,			/* 4,29 latin/cyril to Shift-JIS */K+     NULL,			/* 4,30 latin/cyril to J-EUC */ /     NULL,			/* 4,31 latin/cyril to DEC Kanji */ /     xlch7,			/* 4,32 latin/cyril to Hebrew-7 */o3     xlcas,			/* 4,33 latin/cyril to Latin/Hebrew */+3     xlcas,			/* 4,34 latin/cyril to CP862 Hebrew */[   /* Kanji to others ... */        NULL,			/* 5,00 */     NULL,			/* 5,01 */     NULL,			/* 5,02 */     NULL,			/* 5,03 */     NULL,			/* 5,04 */     NULL,			/* 5,05 */     NULL,			/* 5,06 */     NULL,			/* 5,07 */     NULL,			/* 5,08 */     NULL,			/* 5,09 */     NULL,			/* 5,10 */     NULL,			/* 5,11 */     NULL,			/* 5,12 */     NULL,			/* 5,13 */     NULL,			/* 5,14 */     NULL,			/* 5,15 */     NULL,			/* 5,16 */     NULL,			/* 5,17 */     NULL,			/* 5,18 */     NULL,			/* 5,19 */     NULL,			/* 5,20 */     NULL,			/* 5,21 */     NULL,			/* 5,22 */     NULL,			/* 5,23 */     NULL,			/* 5,24 */     NULL,			/* 5,25 */     NULL,			/* 5,26 */     NULL,			/* 5,27 */     NULL,			/* 5,28 */     NULL,			/* 5,29 */     NULL,			/* 5,30 */     NULL,			/* 5,31 */     NULL,			/* 5,32 */     NULL,			/* 5,33 */     NULL,			/* 5,34 */ /* Latin/Hebrew to others *//     xlhas,			/* 6,0 latin/hebrew to us ascii *///     xlhas,			/* 6,1 latin/hebrew to uk ascii */;8     xlhas, 		        /* 6,2 latin/hebrew to dutch nrc */4     xlhas,			/* 6,3 latin/hebrew to finnish ascii */1     xlhas,			/* 6,4 latin/hebrew to french nrc */e6     xlhas,			/* 6,5 latin/hebrew to fr-canadian nrc */1     xlhas,			/* 6,6 latin/hebrew to german nrc */I2     xlhas,			/* 6,7 latin/hebrew to italian nrc */4     xlhas,			/* 6,8 latin/hebrew to hungarian nrc */7     xlhas,			/* 6,9 latin/hebrew to norge/danish nrc */w6     xlhas,			/* 6,10 latin/hebrew to portuguese nrc */3     xlhas,			/* 6,11 latin/hebrew to spanish nrc */ 3     xlhas,			/* 6,12 latin/hebrew to swedish nrc */u1     xlhas,			/* 6,13 latin/hebrew to swiss nrc */ /     xlhl1,			/* 6,14 latin/hebrew to latin-1 */f/     xlhas,			/* 6,15 latin/hebrew to latin-2 */i/     xlhl1,			/* 6,16 latin/hebrew to DEC MCS */),     xlhas,			/* 6,17 latin/hebrew to NeXT */-     xlhas,			/* 6,18 latin/hebrew to CP437 */)-     xlhas,			/* 6,19 latin/hebrew to CP850 */e-     xlhas,			/* 6,20 latin/hebrew to CP852 */c7     xlhas,			/* 6,21 latin/hebrew to Macintosh Latin */ +     xlhas,			/* 6,22 latin/hebrew to DGI */ =     xlhas,                      /* 6,23 latin/hebrew to HP */ I     xlhas,                      /* 6,24 latin/hebrew to Latin/Cyrillic */o@     xlhas,                      /* 6,25 latin/hebrew to CP866 */D     NULL,                       /* 6,26 latin/hebrew to Short KOI */A     xlhas,		       	/* 6,27 latin/hebrew to Old KOI-8 Cyrillic */ ,     NULL,			/* 6,28 latin/hebrew to JIS-7 */0     NULL,			/* 6,29 latin/hebrew to Shift-JIS */,     NULL,			/* 6,30 latin/hebrew to J-EUC */0     NULL,			/* 6,31 latin/hebrew to DEC Kanji */0     xlhh7,			/* 6,32 latin/hebrew to Hebrew-7 */3     NULL,			/* 6,33 latin/hebrew to Latin/Hebrew */ 3     xlh62			/* 6,34 latin/hebrew to CP862 Hebrew */* };   /*/   Translation function table for sending files. D   Array of pointers to functions for translating from the local fileJ   character set to the transfer syntax character set.  Indexed in the same   way as the xlr array above.e */ #ifdef CK_ANSIC - CHAR (*xls[MAXTCSETS+1][MAXFCSETS+1])(CHAR) =e #else ) CHAR (*xls[MAXTCSETS+1][MAXFCSETS+1])() =y #endif /* CK_ANSIC *// {t-     NULL,			/* 0,0 us ascii to transparent */t-     NULL,			/* 0,1 uk ascii to transparent */ .     NULL,			/* 0,2 dutch nrc to transparent */0     NULL,			/* 0,3 finnish nrc to transparent *//     NULL,			/* 0,4 french nrc to transparent */=4     NULL,			/* 0,5 fr-canadian nrc to transparent *//     NULL,			/* 0,6 german nrc to transparent */_2     NULL,			/* 0,7 hungarian nrc to transparent */0     NULL,			/* 0,8 italian nrc to transparent */5     NULL,			/* 0,9 norge/danish nrc to transparent */ 4     NULL,			/* 0,10 portuguese nrc to transparent */1     NULL,			/* 0,11 spanish nrc to transparent */=1     NULL,			/* 0,12 swedish nrc to transparent */ /     NULL,			/* 0,13 swiss nrc to transparent */ -     NULL,			/* 0,14 latin-1 to transparent */2-     NULL,			/* 0,15 latin-2 to transparent */p-     NULL,			/* 0,16 DEC MCS to transparent */ *     NULL,			/* 0,17 NeXT to transparent */+     NULL,			/* 0,18 CP437 to transparent */(+     NULL,			/* 0,19 CP850 to transparent */ +     NULL,			/* 0,20 CP852 to transparent */x5     NULL,			/* 0,21 Macintosh Latin to transparent */-)     NULL,			/* 0,22 DGI to transparent */ (     NULL,			/* 0,23 HP to transparent */4     NULL,			/* 0,24 Latin/Cyrillic to transparent */?     NULL,                       /* 0,25 CP866 to transparent */ C     NULL,                       /* 0,26 Short KOI to transparent */nC     NULL,                       /* 0,27 Old KOI-8 to transparent */*+     NULL,			/* 0,28 JIS-7 to transparent */n/     NULL,			/* 0,29 Shift JIS to transparent */t2     NULL,			/* 0,30 Japanese EUC to transparent *//     NULL,			/* 0,31 DEC Kanji to transparent */ .     NULL,			/* 0,32 Hebrew-7 to transparent */2     NULL,			/* 0,33 Latin/Hebrew to transparent */2     NULL,			/* 0,34 CP862 Hebrew to transparent */'     NULL,			/* 1,0 us ascii to ascii */ '     NULL,			/* 1,1 uk ascii to ascii */ )     xduas,			/* 1,2 dutch nrc to ascii */ +     xfias,			/* 1,3 finnish nrc to ascii */**     xfras,			/* 1,4 french nrc to ascii */3     xfcas,			/* 1,5 french canadian nrc to ascii */ *     xgeas,			/* 1,6 german nrc to ascii */-     xhuas,			/* 1,7 hungarian nrc to ascii */++     xitas,			/* 1,8 italian nrc to ascii */ 4     xnoas,			/* 1,9 norwegian/danish nrc to ascii *//     xpoas,			/* 1,10 portuguese nrc to ascii */ ,     xspas,			/* 1,11 spanish nrc to ascii */,     xswas,			/* 1,12 swedish nrc to ascii */*     xchas,			/* 1,13 swiss nrc to ascii */(     xl1as,			/* 1,14 latin-1 to ascii */(     xl2as,			/* 1,15 latin-2 to ascii */(     xdmas,			/* 1,16 dec mcs to ascii */%     xneas,			/* 1,17 NeXT to ascii */	&     x43as,			/* 1,18 CP437 to ascii */&     x85as,			/* 1,19 CP850 to ascii */&     x52as,			/* 1,20 CP850 to ascii */0     xaqas,			/* 1,21 Macintosh Latin to ascii */$     xdgas,			/* 1,22 DGI to ascii */#     xr8as,			/* 1,23 HP to ASCII */=/     xlcas,			/* 1,24 Latin/Cyrillic to ASCII */ 9     xacas,                      /* 1,25 CP866 to ASCII */ *     xskas,			/* 1,26 Short KOI to ASCII */F     xk8as,                      /* 1,27 Old KOI-8 Cyrillic to ASCII */     NULL,			/* 1,28 */     NULL,			/* 1,29 */     NULL,			/* 1,30 */     NULL,			/* 1,31 */)     xh7as,			/* 1,32 Hebrew-7 to ASCII */ -     xlhas,			/* 1,33 Latin/Hebrew to ASCII */ -     x62as,			/* 1,34 CP862 Hebrew to ASCII */n)     NULL,			/* 2,0 us ascii to latin-1 */ *     xukl1,			/* 2,1 uk ascii to latin-1 */+     xdul1,			/* 2,2 dutch nrc to latin-1 */i-     xfil1,			/* 2,3 finnish nrc to latin-1 */j,     xfrl1,			/* 2,4 french nrc to latin-1 */5     xfcl1,			/* 2,5 french canadian nrc to latin-1 */ ,     xgel1,			/* 2,6 german nrc to latin-1 *//     xhul1,			/* 2,7 hungarian nrc to latin-1 */p-     xitl1,			/* 2,8 italian nrc to latin-1 */n6     xnol1,			/* 2,9 norwegian/danish nrc to latin-1 */1     xpol1,			/* 2,10 portuguese nrc to latin-1 */J.     xspl1,			/* 2,11 spanish nrc to latin-1 */.     xswl1,			/* 2,12 swedish nrc to latin-1 */,     xchl1,			/* 2,13 swiss nrc to latin-1 */)     NULL,			/* 2,14 latin-1 to latin-1 */c*     xl2l1,			/* 2,15 latin-2 to latin-1 */*     xdml1,			/* 2,16 dec mcs to latin-1 */:     xnel1,                      /* 2,17 NeXT to Latin-1 */;     x43l1,                      /* 2,18 CP437 to Latin-1 */a;     x85l1,                      /* 2,19 CP850 to Latin-1 */a;     x52l1,                      /* 2,20 CP852 to Latin-1 */aE     xaql1,                      /* 2,21 Macintosh Latin to Latin-1 */M9     xdgl1,                      /* 2,22 DGI to Latin-1 */C8     xr8l1,                      /* 2,23 HP to Latin-1 */D     xlcas,                      /* 2,24 Latin/Cyrillic to Latin-1 */;     xacas,                      /* 2,25 CP866 to Latin-1 */c?     xskas,                      /* 2,26 Short KOI to Latin-1 */UH     xk8as,                      /* 2,27 Old KOI-8 Cyrillic to Latin-1 */      NULL,			/* 2,28 Kanji ... */     NULL,			/* 2,29 */     NULL,			/* 2,30 */     NULL,			/* 2,32 */+     xh7as,			/* 2,32 Hebrew-7 to Latin-1 */a/     xlhl1,			/* 2,33 Latin/Hebrew to Latin-1 */a/     x62l1,			/* 2,34 CP862 Hebrew to Latin-1 */ )     NULL,			/* 3,0 us ascii to latin-2 */	)     NULL,			/* 3,1 uk ascii to latin-2 */ +     xduas,			/* 3,2 dutch nrc to latin-2 */*-     xfias,			/* 3,3 finnish nrc to latin-2 */c,     xfras,			/* 3,4 french nrc to latin-2 */5     xfcas,			/* 3,5 french canadian nrc to latin-2 */ ,     xgel2,			/* 3,6 german nrc to latin-2 *//     xhul2,			/* 3,7 hungarian nrc to latin-2 */ -     xitas,			/* 3,8 italian nrc to latin-2 */U6     xnoas,			/* 3,9 norwegian/danish nrc to latin-2 */1     xpoas,			/* 3,10 portuguese nrc to latin-2 */r.     xspas,			/* 3,11 spanish nrc to latin-2 */.     xswas,			/* 3,12 swedish nrc to latin-2 */,     xchas,			/* 3,13 swiss nrc to latin-2 */*     xl1l2,			/* 3,14 latin-1 to latin-2 */)     NULL,			/* 3,15 latin-2 to latin-2 */C*     xl1l2,			/* 3,16 dec mcs to latin-2 */:     xnel2,                      /* 3,17 NeXT to Latin-2 */;     x43l2,                      /* 3,18 CP437 to Latin-2 */p;     x85l2,                      /* 3,19 CP850 to Latin-2 */J;     x52l2,                      /* 3,20 CP852 to Latin-2 */LE     xaql2,                      /* 3,21 Macintosh Latin to Latin-2 */n9     xdgl2,                      /* 3,22 DGI to Latin-2 */H8     xr8l2,                      /* 3,22 HP to Latin-2 */D     xlcas,                      /* 3,24 Latin/Cyrillic to Latin-2 */;     xacas,                      /* 3,25 CP866 to Latin-2 */ ?     xskas,                      /* 3,26 Short KOI to Latin-2 */iH     xk8as,                      /* 3,27 Old KOI-8 Cyrillic to Latin-2 */      NULL,			/* 3,28 Kanji ... */     NULL,			/* 3,29 */     NULL,			/* 3,30 */     NULL,			/* 3,31 */+     xh7as,			/* 3,32 Hebrew-7 to Latin-2 */i/     xlhas,			/* 3,33 Latin/Hebrew to Latin-2 */i/     x62as,			/* 3,34 CP862 Hebrew to Latin-2 */ 1     xaslc,			/* 4,0 us ascii to latin/cyrillic */e1     xaslc,			/* 4,1 uk ascii to latin/cyrillic */c2     xduas,			/* 4,2 dutch nrc to latin/cyrillic */4     xfias,			/* 4,3 finnish nrc to latin/cyrillic */3     xfras,			/* 4,4 french nrc to latin/cyrillic */o<     xfcas,			/* 4,5 french canadian nrc to latin/cyrillic */3     xgeas,			/* 4,6 german nrc to latin/cyrillic */ 6     xhuas,			/* 4,7 hungarian nrc to latin/cyrillic */4     xitas,			/* 4,8 italian nrc to latin/cyrillic */9     xnoas,			/* 4,9 norge/danish nrc to latin/cyrillic */ 8     xpoas,			/* 4,10 portuguese nrc to latin/cyrillic */5     xspas,			/* 4,11 spanish nrc to latin/cyrillic */ 5     xswas,			/* 4,12 swedish nrc to latin/cyrillic */,3     xchas,			/* 4,13 swiss nrc to latin/cyrillic */l1     xl1as,			/* 4,14 latin-1 to latin/cyrillic */ 1     xl2as,			/* 4,15 latin-2 to latin/cyrillic */	1     xdmas,			/* 4,16 dec mcs to latin/cyrillic */i.     xneas,			/* 4,17 NeXT to latin/cyrillic *//     x43as,			/* 4,18 CP437 to latin/cyrillic */n/     x85as,			/* 4,19 CP850 to latin/cyrillic */b/     x52as,			/* 4,20 CP852 to latin/cyrillic *//9     xaqas,			/* 4,21 Macintosh Latin to latin/cyrillic *//-     xdgas,			/* 4,22 DGI to Latin/Cyrillic */ ,     xr8as,			/* 4,23 HP to Latin/Cyrillic */K     NULL,                       /* 4,24 Latin/Cyrillic to Latin/Cyrillic */cB     xaclc,                      /* 4,25 CP866 to Latin/Cyrillic */F     xskcy,                      /* 4,26 Short KOI to Latin/Cyrillic */O     xk8lc,                      /* 4,27 Old KOI-8 Cyrillic to Latin/Cyrillic */0     NULL,			/* 4,28 Kanji... */      NULL,			/* 4,29 */     NULL,			/* 4,30 */     NULL,			/* 4,31 */2     xh7as,			/* 4,32 Hebrew-7 to Latin/Cyrillic */6     xlhas,			/* 4,33 Latin/Hebrew to Latin/Cyrillic */6     x62as,			/* 4,34 CP862 Hebrew to Latin/Cyrillic */     NULL,			/* 5,00 */     NULL,			/* 5,01 */     NULL,			/* 5,02 */     NULL,			/* 5,03 */     NULL,			/* 5,04 */     NULL,			/* 5,05 */     NULL,			/* 5,06 */     NULL,			/* 4.07 */     NULL,			/* 5,08 */     NULL,			/* 5,09 */     NULL,			/* 5,10 */     NULL,			/* 5,11 */     NULL,			/* 5,12 */     NULL,			/* 5,13 */     NULL,			/* 5,14 */     NULL,			/* 5,15 */     NULL,			/* 5,16 */     NULL,			/* 5,17 */     NULL,			/* 5,18 */     NULL,			/* 5,19 */     NULL,			/* 5,20 */     NULL,			/* 5,21 */     NULL,			/* 5,22 */     NULL,			/* 5,23 */     NULL,			/* 5,24 */     NULL,			/* 5,25 */     NULL,			/* 5,26 */     NULL,			/* 5,27 */     NULL,			/* 5,28 */     NULL,			/* 5,29 */     NULL,			/* 5,30 */     NULL,			/* 5,31 */     NULL,			/* 5,32 */     NULL,			/* 5,33 */     NULL,			/* 5,34 */.     NULL,			/* 6,0 us ascii to Latin/Hebrew */.     NULL,			/* 6,1 uk ascii to Latin/Hebrew */0     xduas,			/* 6,2 dutch nrc to Latin/Hebrew */2     xfias,			/* 6,3 finnish nrc to Latin/Hebrew */1     xfras,			/* 6,4 french nrc to Latin/Hebrew */ :     xfcas,			/* 6,5 french canadian nrc to Latin/Hebrew */1     xgeas,			/* 6,6 german nrc to Latin/Hebrew */ 4     xhuas,			/* 6,7 hungarian nrc to Latin/Hebrew */2     xitas,			/* 6,8 italian nrc to Latin/Hebrew */7     xnoas,			/* 6,9 norge/danish nrc to Latin/Hebrew */e6     xpoas,			/* 6,10 portuguese nrc to Latin/Hebrew */3     xspas,			/* 6,11 spanish nrc to Latin/Hebrew */r3     xswas,			/* 6,12 swedish nrc to Latin/Hebrew */ 1     xchas,			/* 6,13 swiss nrc to Latin/Hebrew */l/     xl1lh,			/* 6,14 latin-1 to Latin/Hebrew */	/     xl2as,			/* 6,15 latin-2 to Latin/Hebrew */,/     xdmas,			/* 6,16 dec mcs to Latin/Hebrew */t,     xneas,			/* 6,17 NeXT to Latin/Hebrew */-     x43as,			/* 6,18 CP437 to Latin/Hebrew */P-     x85as,			/* 6,19 CP850 to Latin/Hebrew *//-     x52as,			/* 6,20 CP852 to Latin/Hebrew */i7     xaqas,			/* 6,21 Macintosh Latin to Latin/Hebrew */	+     xdgas,			/* 6,22 DGI to Latin/Hebrew */,*     xr8as,			/* 6,23 HP to Latin/Hebrew */I     xlcas,                      /* 6,24 Latin/Cyrillic to Latin/Hebrew */ @     xacas,                      /* 6,25 CP866 to Latin/Hebrew */D     xskas,                      /* 6,26 Short KOI to Latin/Hebrew */M     xk8as,                      /* 6,27 Old KOI-8 Cyrillic to Latin/Hebrew */i     NULL,			/* 6,28 Kanji... */3     NULL,			/* 4,29 */     NULL,			/* 4,30 */     NULL,			/* 4,31 */0     xh7lh,			/* 4,32 Hebrew-7 to Latin/Hebrew */3     NULL,			/* 6,33 Latin/Hebrew to Latin/Hebrew */ 3     x62lh			/* 6,34 CP862 Hebrew to Latin/Hebrew */  }; #endif /* NOCSETS */