 #include "ckcsym.h"   9 /*  C K U U S X --  "User Interface" common functions. */    /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   /*N   This module contains user interface functions needed by both the interactive:   user interface and the command-line-only user interface. */   /* Includes */   #include "ckcdeb.h"  #include "ckcasc.h"  #include "ckcker.h"  #include "ckuusr.h"    extern xx_strp xxstring;   #ifndef NETCONN  /*O   We should just pull in ckcnet.h here, but it causes a conflict with curses.h.  */ #ifdef TCPSOCKET #define NETCONN  #else 
 #ifdef SUNX25  #define NETCONN  #else  #ifdef STRATUSX25  #define NETCONN  #else 
 #ifdef DECNET  #define NETCONN  #else  #ifdef NPIPE #define NETCONN  #else  #ifdef CK_NETBIOS  #define NETCONN  #endif /* TCPSOCKET */ #endif /* SUNX25 */  #endif /* STRATUSX25 */  #endif /* DECNET */  #endif /* NPIPE */ #endif /* CK_NETBIOS */  #endif /* NETCONN */  
 #ifdef OS2 #ifdef CK_NETBIOS  #include "os2.h") #ifdef COMMENT				/* Would you believe */ . #undef COMMENT				/* <os2.h> defines this ? */ #endif /* COMMENT */ #include "ckonbi.h" 1 extern PNCB pRecvNCB, pSendNCB[MAXWS], pWorkNCB ;  extern UCHAR NetBiosAdapter ;  extern BOOL NetbeuiAPI ; #endif /* CK_NETBIOS */   D typedef struct ascreen_rec {		/* Structure for saving screen info */     unsigned char   ox;      unsigned char   oy;      unsigned char   att;     char            *scrncpy; 
 } ascreen; extern ascreen commandscreen;    /* Functions from ckocon.c */ % void savescreen(ascreen *, int, int);  int  restorescreen(ascreen *); #endif /* OS2 */   #ifndef WINTCP #include <signal.h>  #endif /* WINTCP */   
 #ifdef VMS
 #ifdef WINTCP  #include <descrip.h> #include <ssdef.h> #include <stsdef.h>  #include <signal.h>  #else  #include <descrip.h> #include <ssdef.h> #include <stsdef.h>  #endif /* WINTCP */  #endif /* VMS */   /* Used internally */   5 _PROTOTYP( VOID screenc, (int, char, long, char *) );  #ifdef CK_CURSES' _PROTOTYP( static long shocps, (int) ); : _PROTOTYP( static long shoetl, (long, long, long, long) ); #endif /* CK_CURSES */  O static int ft_win = 0;  /* Fullscreen file transfer display window is active */    /* Variables declared here */   8 int fdispla = XYFD_R;			/* File transfer display type */0 int tt_crd = 0;				/* Carriage return display */   #ifdef DEBUG0 char debfil[50];			/* Debugging log file name */ #endif /* DEBUG */   #ifdef TLOG 2 char trafil[50];			/* Transaction log file name */ #endif /* TLOG */   - char pktfil[50];			/* Packet log file name */ . char sesfil[50];			/* Session log file name */   #ifndef NOFRILLS: char optbuf[100];			/* Options for MAIL or REMOTE PRINT */ #endif /* NOFRILLS */    #ifdef DYNAMICA static char *cmdstr = NULL;		/* Place to build generic command */  #else  #ifdef pdp11 static char cmdstr[256]; #else  static char cmdstr[4096];  #endif /* pdp11 */ #endif /* DYNAMIC */  < char fspec[FSPECL];			/* Filename string for \v(filespec) */  > /*  C C N T A B  --  Names of ASCII control characters 0-31 */  J char *ccntab[] = { "NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL",0  "BS", "HT", "LF", "VT", "FF", "CR", "SO", "SI",H  "DLE", "DC1/XON", "DC2", "DC3/XOFF", "DC4", "NAK", "SYN", "ETB", "CAN",+  "EM", "SUB", "ESC", "FS", "GS", "RS", "US"  };  5 int success = 1,			/* Command success/failure flag */   
 #ifndef NOSPL &     cmdlvl = 0,				/* Command level */ #endif /* NOSPL */4     action,				/* Action selected on command line */8     sessft = 0,				/* Session log file type, 0 = text */$     pflag = 1,				/* Print prompt */5     msgflg = 1;				/* Print informational messages */   & #ifndef NOMSEND				/* Multiple SEND */ char *msfiles[MSENDMAX]; #endif /* NOMSEND */   #ifdef CK_RESEND extern int sendmode; extern long sendstart, rs_len; #endif /* CK_RESEND */  
 #ifdef CK_APC  extern int apcactive;  #endif /* CK_APC */  /* External variables */   #ifndef NODIAL/ extern FILE * dialfd;			/* Dialing directory */  #endif /* NODIAL */   3 #ifdef CK_PCT_BAR			/* File transfer thermometer */ * int thermometer = 1;			/* ON by default */ #endif /* CK_PCT_BAR */   G extern int local, quiet, binary, bctu, rptflg, ebqflg, network, server, K   what, spsiz, urpsiz, wmax, czseen, cxseen, winlo, displa, timint, parity, O   npad, ebq, ebqflg, bctr, rptq, atcapu, lpcapu, swcapu, wslotn, wslotr, rtimo, I   mypadn, sq, capas, rpsiz, tsecs, dfloc, tralog, pktlog, seslog, lscapu, K   xitsta, escape, tlevel, bgset, backgrd, wslots, suspend, srvdis, nettype, J   spackets, spktl, rpktl, retrans, wcur, numerrs, fsecs, sendmode, whatru;  & #ifdef datageneral			/* 2/12/92 ENH */ #include <sysid.h>/ extern int con_reads_mt, conint_ch, conint_avl;  #endif /* datageneral */  D extern long speed, filcnt, ffc, tfc, rptn, fsize, sendstart, rs_len; long oldcps = 0L, cps = 0L;   4 extern CHAR *rdatap, padch, seol, ctlq, mypadc, eol;  B extern char ttname[], *dftty, *cmarg, **cmlist, *versio, myhost[];
 #ifndef NOICP  #ifdef DCMDBUF+ extern char *cmdbuf;			/* Command buffer */  #else , extern char cmdbuf[];			/* Command buffer */ #endif /* DCMDBUF */ #endif /* NOICP */   #ifndef NOCCTRAP* #include <setjmp.h>			/* Control-C trap */1 #ifdef CK_POSIX_SIG			/* POSIX signal handling */  sigjmp_buf cmjbuf; #else  jmp_buf cmjbuf;  #endif /* CK_POSIX_SIG */  #endif /* NOCCTRAP */    #ifndef NOCSETS  #include "ckcxla.h"  extern int fcharset, tcharset;* extern struct csinfo fcsinfo[], tcsinfo[]; #endif /* NOCSETS */  * /*  P A R N A M  --  Return parity name */   char * #ifdef CK_ANSIC  parnam(char c) #else  parnam(c) char c;  #endif /* CK_ANSIC */  /* parnam */ {     switch (c) { 	case 'e': return("even"); 	case 'o': return("odd");  	case 'm': return("mark"); 	case 's': return("space");  	case 0:   return("none"); 	default:  return("invalid");      }  }   + /*  S H O M D M  --  Show modem signals  */    VOID
 shomdm() { /*E   Note use of "\r\n" to make sure this report prints right, even when    called during CONNECT mode.  */
     int y;     y = ttgmdm();      switch (y) {       case -3: printf(E 	         "Modem signals unavailable in this version of Kermit\r\n");  	       break;E       case -2: printf("No modem control for this device\r\n"); break; >       case -1: printf("Modem signals unavailable\r\n"); break;       default: #ifndef MAC          printf( D 	  " Carrier Detect      (CD):  %s\r\n",(y & BM_DCD) ? "On": "Off"); 	printf(K           " Dataset Ready       (DSR): %s\r\n",(y & BM_DSR) ? "On": "Off");  #endif /* MAC */ 	printf(K           " Clear To Send       (CTS): %s\r\n",(y & BM_CTS) ? "On": "Off");  #ifndef STRATUS  #ifndef MAC          printf( K           " Ring Indicator      (RI):  %s\r\n",(y & BM_RNG) ? "On": "Off");  #endif /* MAC */         printf( K           " Data Terminal Ready (DTR): %s\r\n",(y & BM_DTR) ? "On": "Off");  #ifndef MAC          printf( K           " Request to Send     (RTS): %s\r\n",(y & BM_RTS) ? "On": "Off");  #endif /* MAC */ #endif /* STRATUS */     }  }   : /*  S D E B U  -- Record spar results in debugging log  */   VOID sdebu(len) int len; { 1     debug(F111,"spar: data",(char *) rdatap,len); $     debug(F101," spsiz ","", spsiz);$     debug(F101," timint","",timint);$     debug(F101," npad  ","",  npad);$     debug(F101," padch ","", padch);$     debug(F101," seol  ","",  seol);$     debug(F101," ctlq  ","",  ctlq);$     debug(F101," ebq   ","",   ebq);$     debug(F101," ebqflg","",ebqflg);$     debug(F101," bctr  ","",  bctr);$     debug(F101," rptq  ","",  rptq);$     debug(F101," rptflg","",rptflg);$     debug(F101," lscapu","",lscapu);$     debug(F101," atcapu","",atcapu);$     debug(F101," lpcapu","",lpcapu);$     debug(F101," swcapu","",swcapu);%     debug(F101," wslotn","", wslotn); %     debug(F101," whatru","", whatru);  } 7 /*  R D E B U -- Debugging display of rpar() values  */    VOID  rdebu(d,len) CHAR *d; int len; {#     debug(F111,"rpar: data",d,len); ,     debug(F101," rpsiz ","", xunchar(d[0]));$     debug(F101," rtimo ","", rtimo);$     debug(F101," mypadn","",mypadn);$     debug(F101," mypadc","",mypadc);$     debug(F101," eol   ","",   eol);$     debug(F101," ctlq  ","",  ctlq);$     debug(F101," sq    ","",    sq);$     debug(F101," ebq   ","",   ebq);$     debug(F101," ebqflg","",ebqflg);$     debug(F101," bctr  ","",  bctr);$     debug(F101," rptq  ","",  d[8]);$     debug(F101," rptflg","",rptflg);$     debug(F101," capas ","", capas);&     debug(F101," bits  ","",d[capas]);$     debug(F101," lscapu","",lscapu);$     debug(F101," atcapu","",atcapu);$     debug(F101," lpcapu","",lpcapu);$     debug(F101," swcapu","",swcapu);%     debug(F101," wslotr","", wslotr); ,     debug(F101," rpsiz(extended)","",rpsiz); }    #ifdef COMMENTE /*  C H K E R R  --  Decide whether to exit upon a protocol error  */    VOID
 chkerr() {4     if (backgrd && !server) fatal("Protocol error"); }  #endif /* COMMENT */  ) /*  F A T A L  --  Fatal error message */    VOID& fatal2(msg1,msg2) char *msg1, *msg2; {     if (!msg1) msg1 = "";      if (!msg2) msg2 = ""; +     sprintf(fspec,"\"%s\" - %s",msg1,msg2);      fatal(fspec);  }    VOID fatal(msg) char *msg; {      if (!msg) msg = ""; 
 #ifdef VMS"     if (strncmp(msg,"%CKERMIT",8))"       conol("%CKERMIT-E-FATAL, ");     conoll(msg); #else /* !VMS */     screen(SCR_EM,0,0L,msg); #endif /* VMS */     debug(F110,"fatal",msg,0);     tlog(F110,"Fatal:",msg,0L); >     doexit(BAD_EXIT,xitsta | 1);	/* Exit indicating failure */ }   ; /*  B L D L E N  --  Make length-encoded copy of string  */    char *$ bldlen(str,dest) char *str, *dest; {     int len;     len = (int)strlen(str);      if (len > 94)        *dest = SP;      else       *dest = tochar(len);     strcpy(dest+1,str);      return(dest+len+1);  }     4 /*  S E T G E N  --  Construct a generic command  */ /*K   Call with Generic command character followed by three string arguments.   M   Trailing strings are allowed to be empty ("").  Each string except the last L   non-empty string must be less than 95 characters long.  The final nonempty!   string is allowed to be longer.  */ CHAR #ifdef CK_ANSIC 8 setgen(char type, char * arg1, char * arg2, char * arg3) #else ; setgen(type,arg1,arg2,arg3) char type, *arg1, *arg2, *arg3;  #endif /* CK_ANSIC */  /* setgen */ {     char *upstr, *cp;  #ifdef DYNAMIC     if (!cmdstr)(       if (!(cmdstr = malloc(MAXSP + 1)))( 	fatal("setgen: can't allocate memory"); #endif /* DYNAMIC */       cp = cmdstr;     *cp++ = type;      *cp = NUL;     if (!arg1) arg1 = "";      if (!arg2) arg2 = "";      if (!arg3) arg3 = "";      if (*arg1 != NUL) {  	upstr = bldlen(arg1,cp);  	if (*arg2 != NUL) {  	    upstr = bldlen(arg2,upstr);* 	    if (*arg3 != NUL) bldlen(arg3,upstr); 	}     }      cmarg = cmdstr; !     debug(F110,"setgen",cmarg,0);        return('g'); }    #ifndef NOMSEND  static char *mgbufp = NULL;    /*  F N P A R S E  --  */    /*B   Argument is a character string containing one or more filespecs.F   This function breaks the string apart into an array of pointers, oneH   to each filespec, and returns the number of filespecs.  Used by serverE   when it receives a GET command to allow it to process multiple file G   specifications in one transaction.  Sets cmlist to point to a list of @   file pointers, exactly as if they were command line arguments.  H   This version of fnparse treats spaces as filename separators.  If yourF   operating system allows spaces in filenames, you'll need a different   separator.  K   This version of fnparse mallocs a string buffer to contain the names.  It K   cannot assume that the string that is pointed to by the argument is safe.  */ int  fnparse(string) char *string; {      char *p, *s, *q;%     int r = 0, x;			/* Return code */   >     if (mgbufp) free(mgbufp);		/* Free this from last time. */+     mgbufp = malloc((int)strlen(string)+2);      if (!mgbufp) {) 	debug(F100,"fnparse malloc error","",0);  	return(0);      }	
 #ifndef NOICP 
 #ifndef NOSPL B     strncpy(fspec,string,FSPECL);	/* Make copy for \v(filespec) */ #endif /* NOSPL */ #endif /* NOICP */%     s = string;				/* Input string */ -     p = q = mgbufp;			/* Point to the copy */ .     r = 0;				/* Initialize our return code */C     while (*s == SP || *s == HT)	/* Skip leading spaces and tabs */ 
       s++;5     for (x = strlen(s);			/* Strip trailing spaces */ , 	 (x > 1) && (s[x-1] == SP || s[x-1] == HT); 	 x--)       s[x-1] = NUL; 4     while (1) {				/* Loop through rest of string */6 	if (*s == CMDQ) {		/* Backslash (quote character)? */7 	    if ((x = xxesc(&s)) > -1) {	/* Go interpret it. */ 3 		*q++ = (char) x;	/* Numeric backslash code, ok */ 1 	    } else {			/* Just let it quote next char */ % 		s++;			/* get past the backslash */ ' 		*q++ = *s++;		/* deposit next char */  	    } 	    continue;A 	} else if (*s == SP || *s == NUL) { /* Unquoted space or NUL? */ 0 	    *q++ = NUL;			/* End of output filename. */9 	    msfiles[r] = p;		/* Add this filename to the list */ ( 	    debug(F111,"fnparse",msfiles[r],r); 	    r++;			/* Count it *// 	    if (*s == NUL) break;	/* End of string? */ 5 	    while (*s == SP) s++;	/* Skip repeated spaces */ & 	    p = q;			/* Start of next name */ 	    continue;6 	} else *q++ = *s;		/* Otherwise copy the character */# 	s++;				/* Next input character */      } !     debug(F101,"fnparse r","",r); <     msfiles[r] = "";			/* Put empty string at end of list */     cmlist = msfiles;      return(r); }  #endif /* NOMSEND */  * char *					/* dbchr() for DEBUG SESSION */ dbchr(c) int c; {      static char s[8];      char *cp = s;        c &= 0xff;&     if (c & 0x80) {			/* 8th bit on */
 	*cp++ = '~';  	c &= 0x7f;      } +     if (c < SP) {			/* Control character */ 
 	*cp++ = '^';  	*cp++ = ctl(c);     } else if (c == DEL) {
 	*cp++ = '^'; 
 	*cp++ = '?'; (     } else {				/* Printing character */ 	*cp++ = c;      } )     *cp = '\0';				/* Terminate string */ )     cp = s;				/* Return pointer to it */      return(cp);  }   K /*  C K H O S T  --  Get name of local host (where C-Kermit is running)  */    /*G   Call with pointer to buffer to put hostname in, and length of buffer. G   Copies hostname into buffer on success, puts null string in buffer on 
   failure. */ #ifdef BSD44 #define BSD4 #undef ATTSV #endif /* BSD44 */   #ifdef SVORPOSIX
 #ifndef BSD44  #ifndef apollo #include <sys/utsname.h> #endif /* apollo */  #endif /* BSD44 */ #endif /* SVORPOSIX*/    VOID. ckhost(vvbuf,vvlen) char * vvbuf; int vvlen; { #ifdef pdp11     *vvbuf = NUL;  #else      char *g;
 #ifdef VMS
     int x; #endif /* VMS */ #ifdef SVORPOSIX
 #ifndef BSD44  #ifndef _386BSD      struct utsname hname;  #endif /* _386BSD */ #endif /* BSD44 */ #endif /* SVORPOSIX */ #ifdef datageneral0     int ac0 = (char *) vvbuf, ac1 = -1, ac2 = 0; #endif /* datageneral */       *vvbuf = NUL;  #ifndef OXOS #ifdef SVORPOSIX #ifdef BSD443     if (gethostname(vvbuf,vvlen) < 0) *vvbuf = NUL;  #else  #ifdef _386BSD3     if (gethostname(vvbuf,vvlen) < 0) *vvbuf = NUL;  #else 
 #ifdef QNX #ifdef TCPSOCKET3     if (gethostname(vvbuf,vvlen) < 0) *vvbuf = NUL;  #else @     if (uname(&hname) > -1) strncpy(vvbuf,hname.nodename,vvlen); #endif /* TCPSOCKET */. #else /* SVORPOSIX but not _386BSD or BSD44 */@     if (uname(&hname) > -1) strncpy(vvbuf,hname.nodename,vvlen); #endif /* QNX */ #endif /* _386BSD */ #endif /* BSD44 */ #else /* !SVORPOSIX */ #ifdef BSD4 3     if (gethostname(vvbuf,vvlen) < 0) *vvbuf = NUL;  #else /* !BSD4 */ 
 #ifdef VMS     g = getenv("SYS$NODE"); "     if (g) strncpy(vvbuf,g,vvlen);     x = (int)strlen(vvbuf); J     if (x > 1 && vvbuf[x-1] == ':' && vvbuf[x-2] == ':') vvbuf[x-2] = NUL; #elsec #ifdef datageneral9     if (sys($HNAME,&ac0,&ac1,&ac2) == 0) /* successful */n5         vvlen = ac2 + 1;		/* enh - have to add one */  #elses #ifdef OS2				/* OS/2 */>     g = getenv("HOSTNAME");		/* (Created by TCP/IP install) */K     if (!g) g = getenv("SYSTEMNAME");	/* (Created by PATHWORKS install?) */f"     if (g) strncpy(vvbuf,g,vvlen); #endif /* OS2 */ #endif /* datageneral */ #endif /* VMS */ #endif /* BSD4 */c #endif /* SVORPOSIX */ #else /* OXOS */F     /* If TCP/IP is not installed, gethostname() fails, use uname() */'     if (gethostname(vvbuf,vvlen) < 0) {i 	if (uname(&hname) > -1)) 	    strncpy(vvbuf,hname.nodename,vvlen);h 	elsel 	    *vvbuf = NUL;     }u #endif /* OXOS */o3     if (*vvbuf == NUL) {		/* If it's still empty */l+         g = getenv("HOST");		/* try this *//&         if (g) strncpy(vvbuf,g,vvlen);     } @     vvbuf[vvlen-1] = NUL;		/* Make sure result is terminated. */ #endif /* pdp11 */ }  #ifdef BSD44 #undef BSD4 
 #define ATTSVe #endif /* BSD44 */  
 #ifndef NOSPLs #define ASKMORET #endif /* NOSPL */ #ifndef NOHELP #ifndef ASKMOREd #define ASKMOREe #endif /* ASKMORE */ #endif /* NOHELP */    #ifdef ASKMORE /**   A S K M O R E  --  Poor person's "more".)   Returns 0 if no more, 1 if more wanted. L   Presently used by SHO MAC, SHO GLOB, SHO VAR, and HELP, so compiled out if&   those options are also compiled out. */ int  askmore() {      char c; int rv;f       rv = -1;     while (rv < 0) { #ifndef OS2i 	printf("more? "); #ifdef UNIX	 #ifdef NOSETBUFe 	fflush(stdout); #endif /* NOSETBUF */n #endif /* UNIX */f #elseM5 	printf("more? (Y or space-bar for yes, N for no) ");n 	fflush(stdout); #endif /* OS2 */ 	c = coninc(0); 
 	switch (c) {  	  /* Yes */4 	  case SP: case 'y': case 'Y': case 012:  case 015: 	    printf("\015      \015"); 	    rv = 1; 	    break;a           /* No */* 	  case 'n': case 'N': case 'q': case 'Q': 	    printf("\015\012"); 	    rv = 0; 	    break;e 	  /* Invalid answer */F 	  default: 2 	    printf("Y or space-bar for yes, N for no\n"); 	    continue; 	}
 #ifdef OS29 	printf("\r                                         \r");  	fflush(stdout); #endif /* OS2 */     }W     return(rv);< }c #endif /* ASKMORE */  . /*  T R A P  --  Terminal interrupt handler */   SIGTYP trap(sig) int sig; {
 #ifdef VMS     int i; FILE *f;f #endif /* VMS */ #ifdef __EMX__     signal(SIGINT, SIG_ACK); #endif
 #ifdef GEMDOSI7 /* GEM is not reentrant, no i/o from interrupt level */S7     longjmp(cmjbuf,1);			/* Jump back to parser now! */a #endif /* GEMDOS */g1     debug(F101,"^C trap() caught signal","",sig);t;     zclose(ZIFILE);			/* If we were transferring a file, */d%     zclose(ZOFILE);			/* close it. */e
 #ifdef CK_APCn     apcactive = 0; #endif /* CK_APC */s  
 #ifdef VMS /*   Fix terminal.  *//     if (ft_win) {			/* If curses window open */i% 	debug(F100,"^C trap() curses","",0); ( 	screen(SCR_CW,0,0L,"");		/* Close it */# 	conres();			/* Restore terminal */n7 	i = printf("^C...");		/* Echo ^C to standard output */t     } else {
 	conres();9 	i = printf("^C...\n");		/* Echo ^C to standard output */S     }o>     if (i < 1 && ferror(stdout)) {	/* If there was an error */% 	debug(F100,"^C trap() error","",0);	c. 	fclose(stdout);			/* close standard output */< 	f = fopen(dftty, "w");		/* open the controlling terminal */6 	if (f) stdout = f;		/* and make it standard output */1 	printf("^C...\n");		/* and echo the ^C again. */n     }i #else					/* Not VMS */  #ifdef STRATUS6     conres();				/* Set console back to normal mode */ #endif /* STRATUS */0     if (ft_win) {			/* If curses window open, */% 	debug(F100,"^C trap() curses","",0);,) 	screen(SCR_CW,0,0L,"");		/* close it. */"3 	printf("^C...");		/* Echo ^C to standard output */E     } else { 	printf("^C...\n");      }c #endif /* VMS */ #ifdef datageneral:     connoi_mt(); 			/* Kill asynch task that listens to */     ttimoff();#     conres();				/* the keyboard */s #endif /* datageneral */   #ifndef NOCCTRAP@ /*  This is stupid -- every version should have ttimoff()...  */ #ifdef UNIX 5     ttimoff();				/* Turn off any timer interrupts */  #else 
 #ifdef OSK5     ttimoff();				/* Turn off any timer interrupts */  #else  #ifdef STRATUS5     ttimoff();				/* Turn off any timer interrupts */_ #elsee
 #ifdef OS2 #ifdef CK_NETBIOS     if ( netbiosAvail ) {        int i ;        NCB CancelNCB ;A        /* Cancel all outstanding Netbios Send or Work requests */d  '        for ( i = 0 ; i < MAXWS ; i++) {f3 	   if ( pSendNCB[i]->basic_ncb.bncb.ncb_retcode ==h! 	       NB_COMMAND_IN_PROCESS ) {/ 	       NCBCancel( NetbeuiAPI, 			 &CancelNCB,u 			 NetBiosAdapter,t 			 pSendNCB[i] ) ; ; 	       Dos16SemWait( pSendNCB[i]->basic_ncb.ncb_semaphore,  			    SEM_INDEFINITE_WAIT ) ; 	   }e        }M        if ( pWorkNCB->basic_ncb.bncb.ncb_retcode == NB_COMMAND_IN_PROCESS ) {rC 	   NCBCancel( NetbeuiAPI, &CancelNCB, NetBiosAdapter, pWorkNCB ) ;e4 	   Dos16SemWait( pWorkNCB->basic_ncb.ncb_semaphore,/                         SEM_INDEFINITE_WAIT ) ;n        }    } #endif /* CK_NETBIOS */f4    ttimoff();				/* Turn off any timer interrupts */ #elsei
 #ifdef VMS5     ttimoff();				/* Turn off any timer interrupts */  #endif /* VMS */ #endif /* OS2 */ #endif /* STRATUS */ #endif /* OSK */ #endif /* UNIX */   
 #ifdef OSK     sigmask(-1); /*L   We are in an intercept routine but do not perform a F$RTE (done implicitlyF   but rts).  We have to decrement the sigmask as F$RTE does.  Warning:L   longjump only restores the cpu registers, NOT the fpu registers.  So don'tL   use fpu at all or at least don't use common fpu (double or float) register   variables. */ #endif /* OSK */ #ifdef CK_POSIX_SIGX5     siglongjmp(cmjbuf,1);			/* Jump back to parser */u #elsef     longjmp(cmjbuf,1); #endif /* CK_POSIX_SIG */* #elsei  /* No Ctrl-C trap, just exit. */( #ifdef CK_CURSES			/* Curses support? */6     screen(SCR_CW,0,0L,"");		/* Close curses window */ #endif /* CK_CURSES */-     doexit(BAD_EXIT,what);		/* Exit poorly */N #endif /* NOCCTRAP */e     SIGRETURN; }r  9 /*  C K _ T I M E  -- Returns pointer to current time. */{   char * ck_time() {e     static char tbuf[10];d     char *p;
     int x;  2     ztime(&p);				/* "Thu Feb  8 12:00:00 1990" */$     if (!p)				/* like asctime()! */       return(""); 
     if (*p) { . 	for (x = 11; x < 19; x++)	/* copy hh:mm:ss */& 	  tbuf[x - 11] = p[x];		/* to tbuf */! 	tbuf[8] = NUL;			/* terminate */      }l'     return(tbuf);			/* and return it */  }   D /*  C C _ C L E A N  --  Cleanup after terminal interrupt handler */  
 #ifdef GEMDOSl inti cc_clean() {;     zclose(ZIFILE);			/* If we were transferring a file, */ %     zclose(ZOFILE);			/* close it. */e5     printf("^C...\n");			/* Not VMS, no problem... */r }) #endif /* GEMDOS */l    8 /*  S T P T R A P -- Handle SIGTSTP (suspend) signals */   SIGTYP stptrap(sig) int sig; {" #ifndef NOJC     int x; extern int cmflgs; 1     debug(F101,"stptrap() caught signal","",sig);e     if (!suspend) {t$ 	printf("\r\nsuspend disabled\r\n");
 #ifndef NOICP ; 	if (what == W_COMMAND) {	/* If we were parsing commands */ < 	    prompt(xxstring);		/* reissue the prompt and partial */) 	    if (!cmflgs)		/* command (if any) */A 	      printf("%s",cmdbuf);  	} #endif /* NOICP */     } else {$ 	conres();			/* Reset the console */ #ifndef OS2 ; 	/* Flush pending output first, in case we are continued */(3 	/* in the background, which could make us block */f 	fflush(stdout);  . 	x = psuspend(suspend);		/* Try to suspend. */ 	if (x < 0)l #endif /* OS2 */+ 	  printf("Job control not supported\r\n");a- 	conint(trap,stptrap);		/* Rearm the trap. */s. 	debug(F100,"stptrap back from suspend","",0); 	switch (what) {6 	  case W_CONNECT:		/* If suspended during CONNECT? */@ 	    conbin((char)escape);	/* put console back in binary mode */* 	    debug(F100,"stptrap W_CONNECT","",0); 	    break; 
 #ifndef NOICP"3 	  case W_COMMAND:		/* Suspended in command mode */c4 	    debug(F101,"stptrap W_COMMAND pflag","",pflag);8 	    concb((char)escape);	/* Put back CBREAK tty mode *// 	    if (pflag) {		/* If command parsing was */ 8 		prompt(xxstring);	/* reissue the prompt and partial */& 		if (!cmflgs)		/* command (if any) */ 		  printf("%s",cmdbuf); 	    } 	    break;r #endif /* NOICP */& 	  default:			/* All other cases... */( 	    debug(F100,"stptrap default","",0);: 	    concb((char)escape);	/* Put it back in CBREAK mode */ 	    break;, 	}     }0 #endif /* NOJC */1     SIGRETURN; }o   #ifdef TLOG1 #define TBUFL 300a9 /*  T L O G  --  Log a record in the transaction file  */" /*>  Call with a format and 3 arguments: two strings and a number:J    f  - Format, a bit string in range 0-7, bit x is on, arg #x is printed.$    s1,s2 - String arguments 1 and 2.    n  - Int, argument 3. */ VOID #ifdef CK_ANSIC"' tlog(int f, char *s1, char *s2, long n), #else;- tlog(f,s1,s2,n) int f; long n; char *s1, *s2;u #endif /* CK_ANSIC */a /* tlog */ {     static char s[TBUFL];u     char *sp = s; int x;  <     if (!tralog) return;		/* If no transaction log, don't */     switch (f) {.     	case F000:			/* 0 (special) "s1 n s2"  */8 	    if ((int)strlen(s1) + (int)strlen(s2) + 15 > TBUFL), 	      sprintf(sp,"?T-Log string too long");* 	    else sprintf(sp,"%s %ld %s",s1,n,s2);* 	    if (zsoutl(ZTFILE,s) < 0) tralog = 0; 	    break;      	case F001:			/* 1, " n" *// 	    sprintf(sp," %ld",n);* 	    if (zsoutl(ZTFILE,s) < 0) tralog = 0; 	    break; !     	case F010:			/* 2, "[s2]" */  	    x = (int)strlen(s2); % 	    if (s2[x] == '\n') s2[x] = '\0';m 	    if (x + 6 > TBUFL) & 	      sprintf(sp,"?String too long");  	    else sprintf(sp,"[%s]",s2);+ 	    if (zsoutl(ZTFILE,"") < 0) tralog = 0;  	    break;I#     	case F011:			/* 3, "[s2] n" */s 	    x = (int)strlen(s2);R% 	    if (s2[x] == '\n') s2[x] = '\0';e 	    if (x + 6 > TBUFL) & 	      sprintf(sp,"?String too long");& 	    else sprintf(sp,"[%s] %ld",s2,n);* 	    if (zsoutl(ZTFILE,s) < 0) tralog = 0; 	    break;e     	case F100:			/* 4, "s1" */r+ 	    if (zsoutl(ZTFILE,s1) < 0) tralog = 0;  	    break; "     	case F101:			/* 5, "s1: n" */& 	    if ((int)strlen(s1) + 15 > TBUFL)& 	      sprintf(sp,"?String too long");% 	    else sprintf(sp,"%s: %ld",s1,n); * 	    if (zsoutl(ZTFILE,s) < 0) tralog = 0; 	    break; "     	case F110:			/* 6, "s1 s2" */ 	    x = (int)strlen(s2); % 	    if (s2[x] == '\n') s2[x] = '\0';s) 	    if ((int)strlen(s1) + x + 4 > TBUFL) & 	      sprintf(sp,"?String too long");$ 	    else sprintf(sp,"%s %s",s1,s2);* 	    if (zsoutl(ZTFILE,s) < 0) tralog = 0; 	    break; %     	case F111:			/* 7, "s1 s2: n" */e 	    x = (int)strlen(s2); % 	    if (s2[x] == '\n') s2[x] = '\0';a* 	    if ((int)strlen(s1) + x + 15 > TBUFL)& 	      sprintf(sp,"?String too long");+ 	    else sprintf(sp,"%s %s: %ld",s1,s2,n);f* 	    if (zsoutl(ZTFILE,s) < 0) tralog = 0; 	    break;t	 	default: 6 	    sprintf(sp,"?Invalid format for tlog() - %ld",n);* 	    if (zsoutl(ZTFILE,s) < 0) tralog = 0;     }  }( #endif /* TLOG */    #ifndef MACa /*E   The rest of this file is for all implementations but the Macintosh.b */  5 /*  C H K I N T  --  Check for console interrupts  */r   #ifdef CK_CURSESA static int repaint = 0;			/* Transfer display needs repainting */  #endif /* CK_CURSES */   int,
 chkint() {     int ch, cn, ofd; long zz;S  O     if ((!local) || (quiet)) return(0);	/* Only do this if local & not quiet */i #ifdef datageneralI     if (con_reads_mt)                   /* if conint_mt task is active */ N         if (conint_avl) {               /* and there's an interrupt pending */8             cn = 1;                     /* process it */             ch = conint_ch;pL             conint_avl = 0;             /* turn off flag so conint_mt can */5         } else                          /* proceed */l             return(0);E     else                                /* if conint_mt not active */pF         if ((ch = coninc(2)) < 0)       /* try to get char manually */C             return(0);                  /* I/O error, or no data */aI         else                            /* if successful, set cn so we */h=             cn = 1;                     /* know we got one */ 6     debug(F101,"chkint got keyboard character",ch,cn); #else /* !datageneral */-     cn = conchk();			/* Any input waiting? */      debug(F101,"conchk","",cn);t     if (cn < 1) return(0);(     if ((ch = coninc(5)) < 0) return(0); #endif /* datageneral */       switch (ch & 0177) {9       case 'A': case 'a': case 0001:		/* Status report */( #ifdef COMMENT, 	if (fdispla != XYFD_R && fdispla != XYFD_S)E 	  return(0);	                        /* Only for serial or simple */o #else A 	if (fdispla != XYFD_R && fdispla != XYFD_S && fdispla != XYFD_N) C 	  return(0);	                        /* Only for serial, simple */  						/* or none */S1 	ofd = fdispla; /* [MF] Save file display type */P 	if (fdispla == XYFD_N))A 	  fdispla = XYFD_R; /* [MF] Pretend serial if no file display */s #endif /* COMMENT */& 	screen(SCR_TN,0,0l,"Status report:");$ 	screen(SCR_TN,0,0l," file type: "); 	if (binary) { 	    switch(binary) { 9 	      case XYFT_L: screen(SCR_TZ,0,0l,"labeled"); break;s7 	      case XYFT_I: screen(SCR_TZ,0,0l,"image"); break;cB 	      case XYFT_U: screen(SCR_TZ,0,0l,"binary undefined"); break; 	      default: 8 	      case XYFT_B: screen(SCR_TZ,0,0l,"binary"); break; 	    }	 	} else {	 #ifdef NOCSETS  	    screen(SCR_TZ,0,0l,"text"); #elseA" 	    screen(SCR_TU,0,0l,"text, ");! 	    if (tcharset == TC_TRANSP) {r$ 		screen(SCR_TZ,0,0l,"transparent");
 	    } else {r 		if (what == W_SEND) { 4 		    screen(SCR_TZ,0,0l,tcsinfo[tcharset].keyword);! 		    screen(SCR_TU,0,0l," => ");n4 		    screen(SCR_TZ,0,0l,fcsinfo[fcharset].keyword);
 		} else {4 		    screen(SCR_TZ,0,0l,fcsinfo[fcharset].keyword);! 		    screen(SCR_TU,0,0l," => ");,4 		    screen(SCR_TZ,0,0l,tcsinfo[tcharset].keyword); 		}l 	    } #endif /* NOCSETS */ 	}( 	screen(SCR_QE,0,filcnt," file number");+ 	if (fsize) screen(SCR_QE,0,fsize," size");b. 	screen(SCR_QE,0,ffc,   " characters so far"); 	if (fsize > 0L) {/ 	    zz = ( (ffc + sendstart) * 100L ) / fsize;// 	    screen(SCR_QE,0,zz,      " percent done");  	}$ 	if (bctu == 4) {		/* Block check */* 	    screen(SCR_TU,0,0L," block check: ");( 	    screen(SCR_TZ,0,0L,"blank-free-2");5 	} else screen(SCR_QE,0,(long)bctu,  " block check"); . 	screen(SCR_QE,0,(long)rptflg," compression");4 	screen(SCR_QE,0,(long)ebqflg," 8th-bit prefixing");1 	screen(SCR_QE,0,(long)lscapu," locking shifts");f 	if (!network)% 	  screen(SCR_QE,0, speed, " speed");a 	if (what == W_SEND)  2 	  screen(SCR_QE,0,(long)spsiz, " packet length");+ 	else if (what == W_RECV || what == W_REMO) 2 	  screen(SCR_QE,0,(long)urpsiz," packet length");1 	screen(SCR_QE,0,(long)wslots,  " window slots");i4 	fdispla = ofd; /* [MF] Restore file display type */ 	return(0);m  7       case 'B': case 'b': case 0002:	/* Cancel batch */V$       case 'Z': case 'z': case 0032:) 	screen(SCR_TN,0,0l,"Cancelling Batch ");  	czseen = 1; 	return(0);   6       case 'F': case 'f': case 0006:	/* Cancel file */$       case 'X': case 'x': case 0030:( 	screen(SCR_TN,0,0l,"Cancelling File "); 	cxseen = 1; 	return(0);/  8       case 'R': case 'r': case 0022:	/* Resend packet */       case 0015: case 0012: ) 	screen(SCR_TN,0,0l,"Resending packet ");  	numerrs++;N 	resend(winlo);S 	return(1);P  2       case 'E': case 'e':		/* Send error packet */       case 0005: 	return(-1);   #ifdef datageneralJ       case '\03':                       /* We're not trapping ^C's with */J         trap(0);                        /* signals, so we check here    */ #endif /* datageneral */   #ifdef CK_CURSES1       case 0014:			/* Ctrl-L to refresh screen */S=       case 'L': case 'l':		/* Also accept L (upper, lower) */n8       case 0027:			/* Ctrl-W synonym for VMS & Ingres */
 	repaint = 1;  	return(0);4 #endif /* CK_CURSES */  4       default:				/* Anything else, print message */ 	intmsg(1L); 	return(0);!     }  }i  @ /*  I N T M S G  --  Issue message about terminal interrupts  */   VOID #ifdef CK_ANSICe intmsg(long n) #else  intmsg(n) long n;' #endif /* CK_ANSIC */) /* intmsg */ {     char buf[80];d  9     if (!displa || quiet)		/* Not if we're being quiet */s
       return; @     if (server && (!srvdis || n > -1L))	/* Special for server */
       return;/.     buf[0] = NUL;			/* Keep compilers happy */ #ifndef OXOS #ifdef SVORPOSIX7     conchk();				/* Clear out pending escape-signals */) #endif /* SVORPOSIX */ #endif /* ! OXOS */d
 #ifdef VMS*     conres();				/* So Ctrl-C will work */ #endif /* VMS */5     if ((!server && n == 1L) || (server && n < 0L)) {    #ifdef CK_NEED_SIGF 	sprintf(buf,"Type escape character (%s) followed by:",dbchr(escape)); 	screen(SCR_TN,0,0l,buf);) #endif /* CK_NEED_SIG */  F  screen(SCR_TN,0,0l,"X to cancel file,  CR to resend current packet");>  screen(SCR_TN,0,0l,"Z to cancel group, A for status report");L  screen(SCR_TN,0,0l,"E to send Error packet, Ctrl-C to quit immediately: ");) /* if (server) */ screen(SCR_TN,0,0l,"");      }r!     else screen(SCR_TU,0,0l," ");/ }d  / static int newdpy = 0;			/* New display flag */S- static char fbuf[80];			/* Filename buffer */n, static char abuf[80];			/* As-name buffer */ static long oldffc = 0L; static long dots = 0L; static int hpos = 0;  5 static VOID				/* Initialize Serial or CTR display */  dpyinit() {e-     newdpy = 0;				/*  Don't do this again */ $     oldffc = 0L;			/*  Reset this */#     dots = 0L;				/*  and this.. */f     oldcps = cps = 0L ;o  #     conoll("");						/* New line */ :     if (what == W_SEND) conol("Sending: "); 		/* Action */2     else if (what == W_RECV) conol("Receiving: ");     conol(fbuf);9     if (*abuf) conol(" => "); conoll(abuf); 		/* Names */e     *fbuf = NUL; *abuf = NUL;e%     if (fsize > -1L) {					/* Size */t) 	sprintf(fbuf,"Size: %ld, Type: ",fsize);  	conol(fbuf); *fbuf = NUL;*     } else conol("Size: unknown, Type: ");      if (binary) {					/* Type */ 	switch(binary) { - 	      case XYFT_L: conoll("labeled"); break;n+ 	      case XYFT_I: conoll("image"); break;(6 	      case XYFT_U: conoll("binary undefined"); break; 	      default: , 	      case XYFT_B: conoll("binary"); break; 	}     } else { #ifdef NOCSETS 	conoll("text"); #else  	conol("text, ");  	if (tcharset == TC_TRANSP) {s 	    conoll("transparent"); 	 	} else {  	    if (what == W_SEND) {# 		conol(fcsinfo[fcharset].keyword);a 		conol(" => ");$ 		conoll(tcsinfo[tcharset].keyword);
 	    } else { # 		conol(tcsinfo[tcharset].keyword);i 		conol(" => ");$ 		conoll(fcsinfo[fcharset].keyword); 	    } 	} #endif /* NOCSETS */     }/6     if (fdispla == XYFD_S) {		/* CRT field headings */ /*.   Define CK_CPS to show current transfer rate.6   Leave it undefined to show estimated time remaining.=   Estimated-time-remaining code from Andy Fyfe, not tested onc   pathological cases.e */ #define CK_CPS  
 #ifdef CK_CPSv+ 	conoll("    File   Percent       Packet");*+ 	conoll("    Bytes  Done     CPS  Length");* #elses+ 	conoll("    File   Percent  Secs Packet");r+ 	conoll("    Bytes  Done     Left Length");o #endif /* CK_CPS */	 	newdpy = 0;     }*
     hpos = 0;( }.   /*   showpkt(c)M   c = completion code: 0 means transfer in progress, nonzero means it's done.oJ   Show the file transfer progress counter and perhaps verbose packet type.   Original by: Kai Uwe Rommel. */ VOID #ifdef CK_ANSIC; showpkt(char c)t #else  showpkt(c) char c; #endif /* CK_ANSIC */  /* showpkt */ {e  *     long howfar;			/* How far into file */  /     if (newdpy)				/* Put up filenames, etc, */n6       dpyinit();			/* if they're not there already. */  !     howfar = ffc;			/* How far */r  /     if (fdispla == XYFD_S) {		/* CRT display */d 	char buffer[40]; - 	long et;			/* Elapsed time, entire batch  */ - 	long pd;			/* Percent done, this file     */(- 	long tp;			/* Transfer rate, entire batch */.- 	long ps;			/* Packet size, current packet */ 0 	long mytfc;			/* Local copy of byte counter  */  % 	et = gtimer();			/* Elapsed time  */;? 	ps = (what == W_RECV) ? rpktl+1 : spktl+1; /* Packet length */o #ifdef CK_RESEND5 	if (what == W_SEND)		/* And if we didn't start at */R0 	  howfar += sendstart;		/*  the beginning... */ 	else if (what == W_RECV)U 	  howfar += rs_len; #endif /* CK_RESEND */ 	pd = -1;			/* Percent done. */K3 	if (c == NUL) {			/* Still going, figure % done */*< 	    if (fsize == 0L) return;	/* Empty file, don't bother */9 	    pd = (fsize > 99L) ? (howfar / (fsize / 100L)) : 0L; , 	    if (pd > 100) pd = 100;	/* Expansion */0 	} else pd = 100;		/* File complete, so 100%. */   #ifndef CK_CPS /*E   fsecs = time (from gtimer) that this file started (set in sfile()).pH   Rate so far is ffc / (et - fsecs),  estimated time for remaining bytes,   is (fsize - ffc) / ( ffc / (et - fsecs )). */D 	tp = (howfar > 0L) ? (fsize - howfar) * (et - fsecs) / howfar : 0L; #endif /* CK_CPS */n  
 #ifdef CK_CPS ) 	mytfc = (pd < 100) ? tfc + howfar : tfc; 4 	tp = (et > 0) ? mytfc / et : 0; /* Transfer rate */9 	if (c && (tp == 0))		/* Watch out for subsecond times */, 	  tp = howfar;i #endif /* CK_CPS */  	if (pd > -1L)D 	  sprintf(buffer, "%c%9ld%5ld%%%8ld%8ld ", CR, howfar, pd, tp, ps); 	elseI@ 	  sprintf(buffer, "%c%9ld      %8ld%8ld ", CR, howfar, tp, ps); 	conol(buffer);f 	hpos = 31;t$     } else {				/* SERIAL display */ 	long i, k;*: 	if (howfar - oldffc < 1024)	/* Update display every 1K */
 	  return;- 	oldffc = howfar;		/* Time for new display *//5 	k = (howfar / 1024L) - dots;	/* How many K so far */e 	for (i = 0L; i < k; i++) {d, 	    if (hpos++ > 77) {		/* Time to wrap? */
 		conoll("");t 		hpos = 0;h 	    }/ 	    conoc('.');			/* Print a dot for this K */r 	    dots++;			/* Count it */p 	}     }. }o  0 /*  S C R E E N  --  Screen display function  */   /*   screen(f,c,n,s)e     f - argument descriptord$     c - a character or small integer     n - a long integer     s - a string.aJ   Fill in this routine with the appropriate display update for the system.K     FILE DISPLAY SERIAL:     Default, works on any terminal, even hardcopy. H     FILE DISPLAY CRT:        Works on any CRT, writes over current line.H     FILE DISPLAY FULLSCREEN: Requires terminal-dependent screen control. */ VOID #ifdef CK_ANSIC*$ screen(int f, char c,long n,char *s) #elset/ screen(f,c,n,s) int f; char c; long n; char *s;a #endif /* CK_ANSIC */* /* screen */ {     char buf[80];	&     int len;				/* Length of string */ #ifdef UNIXi #ifndef NOJC     int obg;  _PROTOTYP( VOID conbgt, (int) );       if (local) {2 	obg = backgrd;			/* Previous background status */0 	conbgt(1);			/* See if running in background */9 	if (!backgrd && obg) {		/* Just came into foreground? */ ? 	    concb((char)escape);	/* Put console back in CBREAK mode */d9 	    conint(trap,stptrap);	/* Turn interrupts back on. */  	}     }n #endif /* NOJC */  #endif /* UNIX */)  M     if ((f != SCR_WM) && (f != SCR_EM)) /* Always update warnings & errors */ =       if (!displa || quiet || backgrd || fdispla == XYFD_N ||s 	  (server && !srvdis))T 	return;   #ifdef CK_CURSESB     if (fdispla == XYFD_C) {		/* If fullscreen display selected */5 	screenc(f,c,n,s);		/* call the fullscreen version */i 	return;     }d #endif /* CK_CURSES */  1     len = (int)strlen(s);		/* Length of string */n  1     switch (f) {			/* Handle our function code */e  ! case SCR_FN:    			/* Filename */l
 #ifdef MAC4     conoll(""); conol(s); conoc(SP); hpos = len + 1; #else      strncpy(fbuf,s,80);c4     newdpy = 1;				/* New file so refresh display */ #endif /* MAC */     return;c    case SCR_AN:    			/* As-name */
 #ifdef MAC2     if (hpos + len > 75) { conoll(""); hpos = 0; }     conol("=> "); conol(s);r;     if ((hpos += (len + 3)) > 78) { conoll(""); hpos = 0; }J #elser     strncpy(abuf,s,80);  #endif /* MAC */     return;m    case SCR_FS: 				/* File-size */
 #ifdef MAC:     sprintf(buf,", Size: %ld",n);  conoll(buf);  hpos = 0; #endif /* MAC */     return;   & case SCR_XD:    			/* X-packet data */
 #ifdef MAC$     conoll(""); conoll(s); hpos = 0; #else,     strncpy(fbuf,s,80);n #endif /* MAC */     return;	  & case SCR_ST:      			/* File status */     switch (c) {.       case ST_OK:   	   		/* Transferred OK */3 	showpkt('Z');			/* Update numbers one last time */ G 	if ((hpos += 5) > 78) conoll(""); /* Wrap screen line if necessary. */p3 	conoll(" [OK]"); hpos = 0;	/* Print OK message. */ < 	if (fdispla == XYFD_S) {	/* We didn't show Z packet when */1 	    conoc('Z');			/* it came, so show it now. */  	    hpos = 1; 	} 	return;	      ;  '       case ST_DISC: 			/*  Discarded */i# 	if ((hpos += 12) > 78) conoll(""); " 	conoll(" [discarded]"); hpos = 0; 	return;  -       case ST_INT:       		/*  Interrupted */-# 	if ((hpos += 14) > 78) conoll("");l$ 	conoll(" [interrupted]"); hpos = 0; 	return;  %       case ST_SKIP: 			/*  Skipped */t# 	if ((hpos += 10) > 78) conoll("");  	conol(" [skipped]"); hpos = 0;- 	return;          case ST_ERR:			/* Error */ 	conoll("");' 	conol("Error: "); conoll(s); hpos = 0;1 	return;  #       case ST_REFU:			/* Refused */  	conoll("");) 	conol("Refused: "); conoll(s); hpos = 0;o 	return;  +       case ST_INC:       		/* Incomplete */ # 	if ((hpos += 12) > 78) conoll(""); # 	conoll(" [incomplete]"); hpos = 0;t 	return;         default:3 	conoll("*** screen() called with bad status ***");)
 	hpos = 0; 	return;     }F  
 #ifdef MAC& case SCR_PN:    			/* Packet number */M     sprintf(buf,"%s: %ld",s,n); conol(buf); hpos += (int)strlen(buf); return;  #endif /* MAC */  2 case SCR_PT:    			/* Packet type or pseudotype */7     if (c == 'Y') return;		/* Don't bother with ACKs */b3     if (c == 'D') {			/* In data transfer phase, */(% 	showpkt(NUL);			/* show progress. */' 	return;     } 
 #ifndef AMIGA>4     if (hpos++ > 77) {			/* If near right margin, */# 	conoll("");			/* Start new line */ % 	hpos = 0;			/* and reset counter. */      }k #endif /* AMIGA */&     if (c == 'Z' && fdispla == XYFD_S)
       return;i     else1       conoc(c);				/* Display the packet type. */  #ifdef AMIGAF     if (c == 'G') conoll("");           /* New line after G packets */ #endif /* AMIGA */     return;;  - case SCR_TC:    			/* Transaction complete */ #     conoc(BEL); conoll(""); return;g  # case SCR_EM:				/* Error message */	8     conoll(""); conoc('?'); conoll(s); hpos = 0; return;  % case SCR_WM:				/* Warning message */ ,     conoll(""); conoll(s); hpos = 0; return;  & case SCR_TU:				/* Undelimited text */7     if ((hpos += len) > 77) { conoll(""); hpos = len; })     conol(s); return;s  1 case SCR_TN:				/* Text delimited at beginning */)-     conoll(""); conol(s); hpos = len; return;t  + case SCR_TZ:				/* Text delimited at end */;7     if ((hpos += len) > 77) { conoll(""); hpos = len; }      conoll(s); return;  % case SCR_QE:				/* Quantity equals */)     sprintf(buf,"%s: %ld",s,n); "     conoll(buf); hpos = 0; return;  - case SCR_CW:				/* Close fullscreen window */l'     return;				/* No window to close */,   case SCR_CD:     return;T   default:6     conoll("*** screen() called with bad object ***");
     hpos = 0;t     return;      }; }   - /*  E R M S G  --  Nonfatal error message  */   M /* Should be used only for printing the message text from an Error packet. */p   VOID3 ermsg(msg) char *msg; {			/* Print error message */C     debug(F110,"ermsg",msg,0);     if (local)       screen(SCR_EM,0,0L,msg);(     tlog(F110,"Protocol Error:",msg,0L); }d   VOID. doclean() {				/* General cleanup upon exit */
 #ifndef NOICP 
 #ifndef NOSPLa9     extern struct mtab *mactab;		/* For ON_EXIT macro. */i     extern int nmac; #endif /* NOSPL */ #endif /* NOICP */       if (pktlog) {  	*pktfil = '\0'; 	pktlog = 0; 	zclose(ZPFILE);     }      if (seslog) {      	*sesfil = '\0'; 	seslog = 0; 	zclose(ZSFILE);     }  #ifdef TLOG      if (tralog) {=+ 	tlog(F100,"Transaction Log Closed","",0L);  	*trafil = '\0'; 	tralog = 0; 	zclose(ZTFILE);     }l #endif /* TLOG */   
 #ifndef NOICPd
 #ifndef NOSPL 9     zclose(ZRFILE);			/* READ and WRITE files, if any. */      zclose(ZWFILE);* #ifndef NODIAL>     if (dialfd) fclose(dialfd);		/* Dial directory, if any. */ #endif /* NODIAL */  /*M   If a macro named "on_exit" is defined, execute it.  Also remove it from the M   macro table, in case its definition includes an EXIT or QUIT command, whichkM   would cause much recursion and would prevent the program from ever actuallys
   EXITing. */,     if (nmac) {				/* Any macros defined? */ 	int k;				/* Yes */: 	k = mlook(mactab,"on_exit",nmac); /* Look up "on_exit" */  	if (k >= 0) {			/* If found, */@ 	    *(mactab[k].kwd) = NUL;	/* poke its name from the table, */* 	    if (dodo(k,"") > -1)	/* set it up, */' 	      parser(1);		/* and execute it */ 	         }X     }  #endif /* NOSPL */ #endif /* NOICP */   /*E   Put console terminal back to normal.  This is done here because theXL   ON_EXIT macro calls the parser, which meddles with console terminal modes. */3     ttclos(0);				/* Close external line, if any */a     if (local) {1 	strcpy(ttname,dftty);		/* Restore default tty */i7 	local = dfloc;			/* And default remote/local status */*     }d0     conres();				/* Restore console terminal. */   #ifdef COMMENTD /* Should be no need for this, and maybe it's screwing things up? */7     connoi();				/* Turn off console interrupt traps */  #endif /* COMMENT */  8     syscleanup();			/* System-dependent cleanup, last */ }S  / /*  D O E X I T  --  Exit from the program.  */u   /*I   First arg is general, system-independent symbol: GOOD_EXIT or BAD_EXIT.	.   If second arg is -1, take 1st arg literally.6   If second arg is not -1, work it into the exit code. */ VOID+ doexit(exitstat,what) int exitstat, what; {p
 #ifdef VMS     char envstr[64];0     static $DESCRIPTOR(symnam,"CKERMIT_STATUS");*     static struct dsc$descriptor_s symval;
     int i; #endif /* VMS */  .     debug(F101,"doexit exitstat","",exitstat);&     debug(F101,"doexit what","",what);  3     doclean();				/* First, clean up most things */   
 #ifdef VMS     if (what == -1)]9       what = 0;				/* Since we set two different items */(*     sprintf(envstr,"%d", exitstat | what);.     symval.dsc$w_length = (int)strlen(envstr);"     symval.dsc$a_pointer = envstr;'     symval.dsc$b_class = DSC$K_CLASS_S;n'     symval.dsc$b_dtype = DSC$K_DTYPE_T;C)     i = 2;				/* Store in global table */ )     LIB$SET_SYMBOL(&symnam, &symval, &i);e     if (exitstat == BAD_EXIT);-       exitstat = SS$_ABORT | STS$M_INHIB_MSG;e     if (exitstat == GOOD_EXIT).       exitstat = SS$_NORMAL | STS$M_INHIB_MSG; #else /* Not VMS */s2     if (what != -1)			/* Take 1st arg literally */       exitstat |= what;c #endif /* VMS */  7 /* We have put this off till the very last moment... */)   #ifdef DEBUG.     if (deblog) {			/* Close the debug log. */0 	debug(F101,"C-Kermit EXIT status","",exitstat); 	*debfil = '\0'; 	deblog = 0; 	zclose(ZDFILE);     }t #endif /* DEBUG */  0       exit(exitstat);			/* Exit from C-Kermit */ }*   /* Set up interrupts */t   VOID
 setint() {J     conint(trap,stptrap);       /* Turn on console terminal interrupts. */7     bgchk();	    	        /* Check background status */a }    VOID* bgchk() {				/* Check background status */     if (bgset < 0)/       pflag = !backgrd;			/* Set prompt flag */e0     else				/* based on foreground/background */#       pflag = (bgset == 0 ? 1 : 0);a  M     /* Message flag on only if at top level, pflag is on, and QUIET is OFF */s       if (
 #ifndef NOSPLg 	cmdlvl == 0 #elses 	tlevel < 0( #endif /* NOSPL */ 	))       msgflg = (pflag == 0) ? 0 : !quiet;p     else msgflg = 0; }:   #ifdef DEBUG: /*  D E B U G  --  Enter a record in the debugging log  */   /*/  Call with a format, two strings, and a number: *    f  - Format, a bit string in range 0-7.:         If bit x is on, then argument number x is printed.?    s1 - String, argument number 1.  If selected, printed as is.'E    s2 - String, argument number 2.  If selected, printed in brackets. L    n  - Long int, argument 3.  If selected, printed preceded by equals sign.  :    f=0 is special: print s1,s2, and interpret n as a char. */   /*H   WARNING: Don't change DEBUFL without changing sprintf() formats below,   accordingly. */ #define DBUFL 2300 static char *dbptr = (char *)0;e static int dbufl = DBUFL;e   int  #ifdef CK_ANSICi* dodebug(int f, char *s1, char *s2, long n) #else|0 dodebug(f,s1,s2,n) int f; char *s1, *s2; long n; #endif /* CK_ANSIC */& /* dodebug */ { 
     char *sp;l
     int x;  :     if (!deblog) return(0);		/* If no debug log, don't. */0     if (!dbptr) {			/* Allocate memory buffer */6 	dbptr = malloc(DBUFL+1);	/* This only happens once */" 	dbufl = DBUFL;			/* Unless ... */ 	if (!dbptr) { 	    deblog = 0; 	    return(0);  	}     }/     if (!s1) s1="(NULL)";&     if (!s2) s2="(NULL)";<   #ifdef COMMENT /*#   This should work, but it doesn't.h:   So instead we'll cope with overflow via sprintf formats.A   N.B.: UNFORTUNATELY, this means we have to put constants in thea   sprintf formats. */<     if (!f || (f & 6)) {		/* String argument(s) included? */. 	x = (int) strlen(s1) + (int) strlen(s2) + 18;, 	if (x > dbufl) {		/* Longer than buffer? */1 	    if (dbptr)			/* Yes, free previous buffer */  	      free(dbptr);(= 	    dbptr = (char *) malloc(x + 2); /* Allocate a new one */a 	    if (!dbptr) {4 		zsoutl(ZDFILE,"DEBUG: Memory allocation failure"); 		zclose(ZDFILE);e
 		deblog = 0;t 		return(0);
 	    } else {l 		dbufl = x;: 		sprintf(dbptr,"DEBUG: Buffer expanded to %d\n", x + 18); 		zsoutl(ZDFILE,dbptr);i 	    } 	}     }y #endif /* COMMENT */   #ifdef COMMENT: /* The aforementioned sprintf() formats were like this: */ 	if (n > 31 && n < 127)=3 	  sprintf(sp,"%.100s%.2000s:%c\n",s1,s2,(CHAR) n);  	else if (n < 32 || n == 127)SB 	  sprintf(sp,"%.100s%.2000s:^%c\n",s1,s2,(CHAR) ((n+64) & 0x7F)); 	else if (n > 127 && n < 160) B 	  sprintf(sp,"%.100s%.2000s:~^%c\n",s1,s2,(CHAR)((n-64) & 0x7F)); 	else if (n > 159 && n < 256)s= 	  sprintf(sp,"%.100s%.2000s:~%c\n",s1,s2,(CHAR) (n & 0x7F));,0 	else sprintf(sp,"%.100s%.2000s:%ld\n",s1,s2,n); /*D   But, naturally, it turns out these are not portable either, so now%   we do the stupidest possible thing." */ #endif /* COMMENT */  ?     if ((x = (int) strlen(s1)) > 100) s1 = "(string too long)";"B     if ((int) strlen(s2) + 101 >= DBUFL) s2 = "(string too long)";       sp = dbptr;a  =     switch (f) {		/* Write log record according to format. */c@       case F000:		/* 0 = print both strings, and n as a char. */ 	if (n > 31 && n < 127) * 	  sprintf(sp,"%s%s:%c\n",s1,s2,(CHAR) n); 	else if (n < 32 || n == 127) 9 	  sprintf(sp,"%s%s:^%c\n",s1,s2,(CHAR) ((n+64) & 0x7F));  	else if (n > 127 && n < 160)w9 	  sprintf(sp,"%s%s:~^%c\n",s1,s2,(CHAR)((n-64) & 0x7F));d 	else if (n > 159 && n < 256)T4 	  sprintf(sp,"%s%s:~%c\n",s1,s2,(CHAR) (n & 0x7F));' 	else sprintf(sp,"%s%s:%ld\n",s1,s2,n);o) 	if (zsout(ZDFILE,dbptr) < 0) deblog = 0;n 	break;w        case F001:			/* 1, "=n" */ 	sprintf(sp,"=%ld\n",n);) 	if (zsout(ZDFILE,dbptr) < 0) deblog = 0;c 	break;e"       case F010:			/* 2, "[s2]" */ 	sprintf(sp,"[%s]\n",s2);c& 	if (zsout(ZDFILE,"") < 0) deblog = 0; 	break; $       case F011:			/* 3, "[s2]=n" */ 	sprintf(sp,"[%s]=%ld\n",s2,n); ) 	if (zsout(ZDFILE,dbptr) < 0) deblog = 0;o 	break;/        case F100:			/* 4, "s1" */' 	if (zsoutl(ZDFILE,s1) < 0) deblog = 0;  	break;p"       case F101:			/* 5, "s1=n" */ 	sprintf(sp,"%s=%ld\n",s1,n);o) 	if (zsout(ZDFILE,dbptr) < 0) deblog = 0;  	break;p$       case F110:			/* 6, "s1[s2]" */ 	sprintf(sp,"%s[%s]\n",s1,s2);) 	if (zsout(ZDFILE,dbptr) < 0) deblog = 0;w 	break;a&       case F111:			/* 7, "s1[s2]=n" */$ 	sprintf(sp,"%s[%s]=%ld\n",s1,s2,n);) 	if (zsout(ZDFILE,dbptr) < 0) deblog = 0;  	break;m       default:6 	sprintf(sp,"\n?Invalid format for debug() - %d\n",f);) 	if (zsout(ZDFILE,dbptr) < 0) deblog = 0;f     }l     return(0); }C #endif /* DEBUG */   #ifdef CK_CURSES   /*9   There are three different ways to do fullscreen on VMS.t,   1. Use the real curses library, VAXCCURSE.   2. Use do-it-yourself code.n"   3. Use the Screen Manager, SMG$.  L   Method 1 doesn't work quite right; you can't call endwin(), so once you've+   started curses mode, you can never leave.r  I   Method 2 doesn't optimize the screen, and so much more time is spent in)I   screen writes.  This actually causes file transfers to fail because theiK   tty device input buffer can be overrun while the screen is being updated,NA   especially on a slow MicroVAX that has small typeahead buffers.   L   In the following #ifdef block, #define one of them and #undef the other 2.     So now let's try method 3... */
 #ifdef VMS& #define CK_SMG				/* Screen Manager */' #undef MYCURSES				/* Do-it-yourself */	* #undef VMSCURSE				/* VAXCCURSE library */ #endif /* VMS */  ? /*  S C R E E N C  --  Screen display function, uses curses  */a  I /* Idea for curses display contributed by Chris Pratt of APV Baker, UK */s  " /* Avoid conficts with curses.h */  
 #ifdef QNX3 /* Same as ckcasc.h, but in a different radix... */:
 #ifdef ESC
 #undef ESC #endif /* ESC */ #endif /* QNX */   #ifndef MYCURSES1 #undef VOID				/* This was defined in ckcdeb.h */f #endif /* MYCURSES */t  1 #undef BS				/* These were defined in ckcasc.h */ 	 #undef CR 	 #undef NLK	 #undef SOi	 #undef US)  * #ifdef VMS				/* VMS fullscreen display */. #ifdef MYCURSES				/* Do-it-yourself method */( extern int isvt52;			/* From CKVTIO.C */ #define printw printf) #elseo5 #ifdef VMSCURSE				/* VMS curses library VAXCCURSE */, #include <curses.h> 5 /* Note: Screen manager doesn't need a header file */  #endif /* VMSCURSE */i #endif /* MYCURSES */  #else					/* Not VMS */o. #ifdef MYCURSES				/* Do-it-yourself method */9 #define isvt52 0			/* Used by OS/2, VT-100/ANSI always */	 #define printw printf0 #else . #include <curses.h>			/* So use real curses */ #endif /* MYCURSES */  #endif /* VMS */  
 #ifdef CK_SMG  /*0   Long section for Screen Manager starts here...   By William Bader.  */ #include "ckvvms.h"  /* #include <smgdef.h> */l /* #include <smgmsg.h> */t  O extern unsigned int vms_status;	    /* Used for system service return status */e  ? static long smg_pasteboard_id = -1;	/* pasteboard identifier */y9 static long smg_display_id = -1;	/* display identifier */r8 static int smg_open = 0;		/* flag if smg current open */  8 #define	clrtoeol()	SMG$ERASE_LINE(&smg_display_id, 0, 0)  ? #define clear()		SMG$ERASE_DISPLAY(&smg_display_id, 0, 0, 0, 0)s  < #define	touchwin(scr)	SMG$REPAINT_SCREEN(&smg_pasteboard_id)  < #define clearok(curscr,ok)		/* Let wrefresh() do the work */  & #define wrefresh(cursrc) touchwin(scr)   static void  move(row, col) int row, col; {;     /* Change from 0-based for curses to 1-based for SMG */      ++row; ++col;/)     CHECK_ERR("move: smg$set_cursor_abs",o8 	      SMG$SET_CURSOR_ABS(&smg_display_id, &row, &col)); }?   static voidb refresh() {)3     CHECK_ERR("refresh: smg$end_pasteboard_update",(6 	      SMG$END_PASTEBOARD_UPDATE(&smg_pasteboard_id));5     CHECK_ERR("refresh: smg$begin_pasteboard_update",f8 	      SMG$BEGIN_PASTEBOARD_UPDATE(&smg_pasteboard_id)); }o   #ifdef VMS_V40 #define	OLD_VMS| #endif /* VMS_V40 */ #ifdef VMS_V42 #define	OLD_VMSi #endif /* VMS_V42 */ #ifdef VMS_V44 #define	OLD_VMSX #endif /* VMS_V44 */  
 static int initscr() {s     int rows = 24, cols = 80;u     int row = 1, col = 1;r  9     if (smg_pasteboard_id == -1) { 	/* Open the screen */) #ifdef OLD_VMS, 	CHECK_ERR("initscr: smg$create_pasteboard",; 		  SMG$CREATE_PASTEBOARD(&smg_pasteboard_id, 0, 0, 0, 0));d #else  	/* For VMS V5, not tested */(, 	CHECK_ERR("initscr: smg$create_pasteboard",> 		  SMG$CREATE_PASTEBOARD(&smg_pasteboard_id, 0, 0, 0, 0, 0)); #endif /* OLD_VMS */     }c  >     if (smg_display_id == -1) {		/* Create a display window */  1 	CHECK_ERR("initscr: smg$create_virtual_display", = 		  SMG$CREATE_VIRTUAL_DISPLAY(&rows, &cols, &smg_display_id,s 					     0, 0, 0));  / 	/* Connect the display window to the screen */m0 	CHECK_ERR("initscr: smg$paste_virtual_display",A 		  SMG$PASTE_VIRTUAL_DISPLAY(&smg_display_id,&smg_pasteboard_id,/ 					    &row,&col));      }S  1     if (!smg_open) {			/* Start a batch update */o 	smg_open = 1;2 	CHECK_ERR("initscr: smg$begin_pasteboard_update",5 		  SMG$BEGIN_PASTEBOARD_UPDATE(&smg_pasteboard_id));i     }u     return(1); })   static voidS
 endwin() {     if (!smg_open)
       return;'       smg_open = 0;s  2     CHECK_ERR("endwin: smg$end_pasteboard_update",6 	      SMG$END_PASTEBOARD_UPDATE(&smg_pasteboard_id));       move(22, 0);   #ifdef COMMENT /*   These calls clear the screen.t */3     CHECK_ERR("endwin: smg$delete_virtual_display", 4 	      SMG$DELETE_VIRTUAL_DISPLAY(&smg_display_id));     smg_display_id = -1;  .     CHECK_ERR("endwin: smg$delete_pasteboard",5 	      SMG$DELETE_PASTEBOARD(&smg_pasteboard_id, 0));      smg_pasteboard_id = -1;  #endif /* COMMENT */ }p  7 static void printw(str, a1, a2, a3, a4, a5, a6, a7, a8)o
 char *str;$ long a1, a2, a3, a4, a5, a6, a7, a8; /* printw */ {     char buf[255];     $DESCRIPTOR(text_dsc, buf);   N     text_dsc.dsc$w_length = sprintf(buf, str, a1, a2, a3, a4, a5, a6, a7, a8);&     CHECK_ERR("printw: smg$put_chars",A 	      SMG$PUT_CHARS(&smg_display_id, &text_dsc, 0, 0, 0, 0, 0));u }: #endif /* CK_SMG */=   #ifdef MYCURSES  /*M   Do-it-yourself curses implementation for VMS, OS/2 and other ANSI/VT-100's.cG   Supports only the VT52 and VT1xx (and later VT2xx/3xx/4xx) terminals.*&   By Terry Kennedy, St Peters College.   '   First, some stuff we can just ignore:C */   intP touchwin(x) int x; { }  int  initscr() {, }: int, refresh() {u }  int+
 endwin() { }u   /*!  * Now, some stuff we need to do:R  */   " _PROTOTYP( int move, (int, int) );   int( move(row, col) int row, col; {     if (isvt52) 0       printf("\033Y%c%c", row + 037, col + 037);     else.       printf("\033[%d;%dH", row + 1, col + 1); }    int 	 clear() {      move(1,1);     if (isvt52)i       printf("\033J");     else       printf("\033[J");  };   intn clrtoeol() {     if (isvt52)e       printf("\033K");     else       printf("\033[K");  }  #endif /* MYCURSES */    /* Screen line numbers */   . #define CW_BAN  0			/* Curses Window Banner */+ #define CW_DIR  2			/* Current directory */k. #define CW_LIN  3			/* Communication device */- #define CW_SPD  4			/* Communication speed */   #define CW_PAR  5			/* Parity */" #define CW_NAM  7			/* Filename */# #define CW_TYP  8			/* File type */l# #define CW_SIZ  9			/* File size */:& #define CW_PCD 10			/* Percent done */   #ifndef CK_PCT_BAR( #define CW_TR  11			/* Time remaining *// #define CW_CP  12			/* Characters per second */"& #define CW_WS  13			/* Window slots */% #define CW_PT  14			/* Packet type */ & #define CW_PC  15			/* Packet count */' #define CW_PL  16			/* Packet length */	& #define CW_PR  17			/* Packet retry */ #ifdef COMMENT, #define CW_PB  17			/* Packet block check */ #endif /* COMMENT */ #else /* CK_PCT_BAR *// #define CW_BAR 11       /* Percent Bar Scale */o( #define CW_TR  12			/* Time remaining */' #define CW_CP  13			/* Chars per sec */e& #define CW_WS  14			/* Window slots */% #define CW_PT  15			/* Packet type */ & #define CW_PC  16			/* Packet count */' #define CW_PL  17			/* Packet length */ & #define CW_PR  18			/* Packet retry */ #ifdef COMMENT, #define CW_PB  18			/* Packet block check */ #endif /* COMMENT */ #endif /* CK_PCT_BAR */O  ' #define CW_ERR 19			/* Error message */r& #define CW_MSG 20			/* Info message */& #define CW_INT 22			/* Instructions */  4 static int cinit = 0;			/* Flag for curses init'd */1 static int cendw = 0;			/* endwin() was called */e   static6 #ifdef CK_ANSIC				/* Because VOID used by curses.h */ void #else  #ifdef MYCURSESi VOID #elsei inta #endif /* MYCURSES */  #endif /* CK_ANSIC */   6 #ifdef CK_ANSIC				/* Update % transfered and % bar */ updpct( long old, long new)l #else /* CK_ANSIC */ updpct(old, new) long old, new;I #endif /* CK_ANSIC */O /* updpct */ { #ifdef COMMENT
     int m, n;      move(CW_PCD,22);     printw("%ld", new);  #ifdef CK_PCT_BARE     if (thermometer) { #ifndef OS2n 	if (old > new) old = 0; 	m = old/2;Z 	move(CW_PCD, 26 + m); 	n = new / 2 - m;* 	while (n > 0) { 	    if (( m + 1) % 5 == 0)f 	      printw("*");f	 	    elsel 	      printw("=");/	 	    m++; 	 	    n--;  	} 	if (new % 2 != 0) printw("-");e 	/* move(CW_PCD, 22+53); */v #else /* OS2 */  	if (old > new) old = 0 ;f
 	m = old / 2;s
 	n = new/2-m;T 	move(CW_PCD, 26+m); 	while (n > 0) { 	    printw("%c", '\333'); 	    m++; n--; 	} 	if (new % 2 != 0) 	  printw("%c", '\261'); #endif /* OS2 */     }  #endif /* CK_PCT_BAR */=     /* clrtoeol(); */, #else  /* !COMMENT */x
 #ifdef OS2 #define CHAR1	'\333'		/* OS2 */  #define CHAR2	'\261' #elseo  #define CHAR1	'/'		/* Default */ #define CHAR2	'-'  #endif /* OS2 */     move(CW_PCD,22);     printw("%ld", new);  #ifdef CK_PCT_BARe     if (thermometer) {         int m, n;    	if (old > new) old = 0 ;o 	if (new <= 100L) {e 	    m = old / 2;  	    n = new / 2 - m;h 	    move(CW_PCD, 26+m); 	    while (n-- > 0) 	      printw("%c", CHAR1);* 	    if (new % 2 != 0) 	      printw("%c", CHAR2);s 	}     }e #endif /* CK_PCT_BAR */u #endif /* COMMENT */ }c   static long gtv = -1L, oldgtv;   static longd shocps(pct) int pct; {     static long oldffc = 0L; #ifndef CPS_WEIGHTED     long secs; #endif /* CPS_WEIGHTED */e  K     /* gtv starts at -1 but we want to ignore it until it is at least 1 */ e  %     oldgtv = (gtv >= 0) ? gtv : 0;   	     gtv = gtimer();l   #ifdef CPS_WEIGHTED*;     if (gtv != oldgtv) {		/* The first packet is ignored */  	if (ffc < oldffc) 	  oldffc = ffc; 	oldcps = cps;> 	if (oldcps && oldgtv > 1) {	/* The first second is ignored */ /*@   This version of shocps() produces a weighted average that someC   people like, but most people find it disconcerting and bombard us4F   with questions and complaints about why the CPS figure fluctuates soD   wildly.  So now you only get the weighted average if you build the-   program yourself with CPS_WEIGHTED defined.1 */ #ifndef CPS_VINCEtE /* Here is Jeff's weighting scheme, current = 25%, history = 75%.. */S@ 	    cps = ( (oldcps * 3) + (ffc - oldffc) / (gtv-oldgtv) ) / 4; #elsei> /* And an alternate weighting scheme from Vincent Fatica... */ 	    cps = (3 *iH 	     ((1+pct/300)*oldffc/oldgtv+(1-pct/100)*(ffc-oldffc)/(gtv-oldgtv))) 	      / 4;C #endif /* CPS_VINCE */	 	} else {D> 	    /* No weighted average since there is nothing to weigh */C 	    cps = gtv ? (ffc - oldffc) / (gtv - oldgtv) : (ffc - oldffc) ;; 	} 	if (deblog) {) 	    debug(F101,"SHOCPS: pct   ","",pct);t) 	    debug(F101,"SHOCPS: gtv   ","",gtv);A, 	    debug(F101,"SHOCPS: oldgtv","",oldgtv);0 	    debug(F101,"SHOCPS: dgtv  ","",gtv-oldgtv);) 	    debug(F101,"SHOCPS: ffc   ","",ffc); , 	    debug(F101,"SHOCPS: oldffc","",oldffc);0 	    debug(F101,"SHOCPS: dffc  ","",ffc-oldffc);) 	    debug(F101,"SHOCPS: cps   ","",cps);K 	} 	move(CW_CP,22); 	printw("%ld", cps); 	clrtoeol(); 	oldffc = ffc;     }; #else /* !CPS_WEIGHTED *//;     if (gtv != oldgtv) {		/* The first packet is ignored */*  	if ((secs = gtv - fsecs) > 0) {* 	    cps = (secs < 1L) ? ffc : ffc / secs; 	    move(CW_CP,22); 	    printw("%ld", cps); 	    clrtoeol(); 	}     }b #endif /* CPS_WEIGHTED */      return(cps); }    static long #ifdef CK_ANSICf6 shoetl(long old_tr, long cps, long fsiz, long howfar ) #else A shoetl(old_tr, cps, fsiz, howfar) long old_tr, cps, fsiz, howfar;s #endif /* CK_ANSIC */  /* shoetl */ {.     /* Show estimated time left in transfer */
     long tr ;   F     tr = (fsiz > 0L && cps > 0L) ? ( ( fsiz - howfar ) / cps ) : -1L ;#     if (tr > -1L && tr != old_tr) {0 	move(CW_TR,22); 	printw("%s",hhmmss(tr));  	clrtoeol();     }      return(tr);a }c   static6 #ifdef CK_ANSIC				/* Because VOID used by curses.h */ void #elseb #ifdef MYCURSESm VOID #elsei int  #endif /* MYCURSES */b #endif /* CK_ANSIC */n$ scrft() {				/* Display file type */     move(CW_TYP,22);     if (binary) {d 	switch(binary) {t- 	      case XYFT_L: printw("LABELED"); break;i+ 	      case XYFT_I: printw("IMAGE"); break;I6 	      case XYFT_U: printw("BINARY UNDEFINED"); break; 	      default: , 	      case XYFT_B: printw("BINARY"); break; 	} #ifdef CK_RESEND( 	if (what == W_SEND && sendstart > 0L) { 	    if (sendmode == SM_PSEND) 	      printw(" / partial");$ 	    else if (sendmode == SM_RESEND) 	      printw(" / resend");N* 	} else if (what == W_RECV && rs_len > 0L) 	  printw(" / resend");1 #endif /* CK_RESEND */     } else { 	printw("TEXT"); #ifndef NOCSETS* 	if (tcharset == TC_TRANSP) {;! 	    printw(" (no translation)"); 	 	} else {  	    if (what == W_SEND) 	      printw(" (%s => %s)",! 		     fcsinfo[fcharset].keyword,	" 		     tcsinfo[tcharset].keyword); 	    else printw(" (%s => %s)", ! 		     tcsinfo[tcharset].keyword,r" 		     fcsinfo[fcharset].keyword); 	} #endif /* NOCSETS */     }(     clrtoeol();f     return;  }h  , char *					/* Convert seconds to hh:mm:ss */ #ifdef CK_ANSICe hhmmss(long x) #elset hhmmss(x) long x;N #endif /* CK_ANSIC */v /* hhmmss(x) */ {i     static char buf[10];     long s, h, m;       h = x / 3600L;			/* Hours */     x = x % 3600L;      m = x / 60L;			/* Minutes */      s = x % 60L;			/* Seconds */     if (x > -1L)-       sprintf(buf,"%02ld:%02ld:%02ld",h,m,s);r     else buf[0] = NUL;     return((char *)buf); }l   #ifdef CK_NEWTERMe static FILE *ck_stdout = NULL; static int ck_fd = -1; #endif /* CK_NEWTERM */l  5 static long pct = 100, oldpct = 0;	/* Percent done */ = static int oldtyp = 0, oldwin = -1, oldtry = -1, oldlen = -1;p   #ifdef NETCONN static char *netname[] = {K     "none", "TCP/IP", "TCP/IP", "X.25", "DECnet", "VAX PSI", "Named Pipes",e     "X.25", "NetBIOS"m }; #endif /* NETCONN */   #ifdef CK_ANSIC7 void% screenc(int f, char c,long n,char *s)( #else) #ifdef MYCURSES  VOID #else7 int  #endif /* MYCURSES */0 screenc(f,c,n,s)! int f;		/* argument descriptor */ + char c;		/* a character or small integer */0 long n;		/* a long integer */& char *s;	/* a string */5 #endif /* CK_ANSIC */n /* screenc() */ {s       static int q = 0; 4     static long fsiz = -1L;		/* Copy of file size */=     static long fcnt = 0L;		/* Number of files transferred */ M     static long fbyt = 0L;    /* Total file bytes of all files transferred *//2     static long old_tr = -1L; /* Time remaining */N     static long howfar = 0L;  /* How much of current file has been transfer */     long cps = 0L;  &     int len;				/* Length of string */     int x;				/* Worker */  )     debug(F101,"screenc cinit","",cinit);,)     debug(F101,"screenc cendw","",cendw);7  C     if (cinit == 0 || cendw > 0) {	/* Handle borderline cases... */=: 	if (f == SCR_CW) {		/* Close window, but it's not open */ 	    ft_win = 0; 	    return; 	} 	if (f == SCR_EM ||%E 	   (f == SCR_PT && c == 'E')) {	/* Fatal error before window open */TE 	    conoll(""); conoc('?'); conoll(s); return; /* Regular display */p 	}     }n6     if (cinit == 0) {			/* Only call initscr() once *// 	cendw = 1;			/* New window needs repainting */r #ifdef COMMENT8 	if (!initscr()) {		/* Oops, can't initialize window? */ /*F   In fact, this doesn't happen.  "man curses" says initscr() halts theE   entire program if it fails, which is true on the systems where I'venD   tested it.  It will fail if your terminal type is not known to it.I   That's why SET FILE DISPLAY FULLSCREEN calls tgetent() to make sure theE:   terminal type is known before allowing a curses display. */0 	    fprintf(stderr,"CURSES INITSCR ERROR\r\n");8 	    fdispla = XYFD_R;		/* Go back to regular display */ 	    return;	 	} else {r+ 	    cinit++;			/* Window initialized ok */,* 	    debug(F100,"CURSES INITSCR OK","",0); 	}! #else					/* Save some memory. */f #ifdef CK_NEWTERMs/ 	/* (From Andy Fyfe <andy@vlsi.cs.caltech.edu>)0E 	   System V curses seems to reserve the right to alter the buffering)C 	   on the output FILE* without restoring it.  Fortunately System V @ 	   curses provides newterm(), an alternative to initscr(), thatC 	   allows us to specify explicitly the terminal type and input andrC 	   output FILE pointers.  Thus we duplicate stdout, and let cursesUC 	   have the copy.  The original remains unaltered.  Unfortunately,y1 	   newterm() seems to be particular to System V.u 	*/m 	s = getenv("TERM"); 	if (ck_fd < 0) {d! 	    ck_fd = dup(fileno(stdout));m: 	    ck_stdout = (ck_fd >= 0) ? fdopen(ck_fd, "w") : NULL; 	}' 	debug(F100,"screenc newterm...","",0); > 	if (ck_stdout == NULL || newterm(s, ck_stdout, stdin) == 0) { 	    fprintf(stderr,G 	      "Fullscreen display not supported for terminal type: %s\r\n",s);o8 	    fdispla = XYFD_R;		/* Go back to regular display */ 	    return; 	}' 	debug(F100,"screenc newterm ok","",0);f #elseS+ 	debug(F100,"screen calling initscr","",0);	& 	initscr();			/* Initialize curses. */& 	debug(F100,"screen initscr ok","",0); #endif /* CK_NEWTERM */ 2 	cinit++;			/* Remember curses was initialized. */ #endif /* COMMENT */     }r'     ft_win = 1;				/* Window is open */s     if (repaint) { #ifdef CK_WREFRESH   /*F   This totally repaints the screen, just what we want, but we can onlyI   do this with real curses, and then only if clearok() and wrefresh() aref!   provided in the curses library.d */
 #ifdef OS2   	restorescreen(&commandscreen); #else 
 #ifdef QNX3 	clearok(stdscr, 1);		/* QNX doesn't have curscr */  	wrefresh(stdscr); #else	 	wrefresh(curscr); #endif /* QNX */ #endif /* OS2 */ #else  /* No CK_WREFRESH */i /*D   Kermit's do-it-yourself method, works with all types of fullscreenJ   support, but does not repaint all the fields.  For example, the filenameJ   is lost, because it arrives at a certain time and never comes again, andJ   Kermit presently does not save it anywhere.  Making this method work forJ   all fields would be a rather major recoding task, and would add a lot of   complexity and storage space.  */ 	cendw = 1;s #endif /* CK_WREFRESH */
 	repaint = 0;      }S7     if (cendw) {			/* endwin() was called previously */i
 #ifdef VMS* 	initscr();			/* (or should have been!) */	 	clear();c 	touchwin(stdscr); 	refresh();g #else*
 #ifdef QNX /*7   In QNX, if we don't call initscr() here we core dump.UE   I don't have any QNX curses documentation, but other curses manualsiD   say that initscr() should be called only once per application, andJ   experience shows that on other systems, calling initscr() here generally   results in a core dump.l */3 	debug(F100,"screenc re-calling initscr QNX","",0);( 	initscr();D	 	clear();_ 	refresh();, #ifdef COMMENT /*C   But even so, second and subsequent curses displays are messed up.a>   Calling touchwin, refresh, etc, doesn't make any difference. */1 	debug(F100,"screenc calling touchwin QNX","",0);o 	touchwin(stdscr);0 	debug(F100,"screenc calling refresh QNX","",0); 	refresh();  #endif /* COMMENT */   #else /* All others... */o* 	debug(F100,"screenc calling clear","",0);	 	clear();o% 	debug(F100,"screenc clear ok","",0);( #endif /* QNX */ #endif /* VMS */% 	debug(F100,"screenc setup ok","",0);P- 	debug(F100,"screenc doing first move","",0);C+ 	move(CW_BAN,0);			/* Display the banner */f9 	if (*myhost) debug(F111,"screenc myhost",myhost,myhost); - 	else debug(F111,"screenc myhost","",myhost);/  	/* if (!myhost) myhost = ""; */5 	if (*myhost) printw("%s, %s",versio,(char *)myhost);f 	else printw("%s",versio);; 	move(CW_DIR,3);  printw("Current Directory: %s",zgtdir());  	if (network) { 7 	    move(CW_LIN,8); printw("Network Host: %s",ttname);O	 	} else {e@ 	    move(CW_LIN,0);  printw("Communication Device: %s",ttname); 	} 	if (network) {S 	    move(CW_SPD,8); 	    printw("Network Type: ");	 	} else {5 	    move(CW_SPD,1);% 	    printw("Communication Speed: ");, 	} 	move(CW_SPD,22);		/* Speed */ 	if (network) {  #ifdef NETCONN# 	    printw("%s",netname[nettype]);m #elsea 	    printw("(network)");d #endif /* NETCONN */	 	} else {n& 	    if (speed < 0L) speed = ttgspd(); 	    if (speed > 0L) {' 		if (speed == 8880) printw("75/1200");	 		else printw("%ld",speed);c 	    } else printw("unknown"); 	}< 	move(CW_PAR,14); printw("Parity: %s",parnam((char)parity));' 	move(CW_TYP,11); printw("File Type:");g' 	move(CW_SIZ,11); printw("File Size:"); * 	move(CW_PCD, 8); printw("Percent Done:"); #ifdef CK_PCT_BARs 	if (thermometer) {E 	    oldpct = pct = 0 ;s 	    move(CW_BAR,22);MF 	    printw("    ...10...20...30...40...50...60...70...80...90..100"); 	    move(CW_BAR,22+56); 	} #endif /* CK_PCT_BAR */ 1 	move(CW_TR,  1); printw("Estimated Time Left:");(0 	move(CW_CP,  2); printw("Transfer Rate, CPS:");* 	move(CW_WS,  8); printw("Window Slots:");) 	move(CW_PT,  9); printw("Packet Type:"); * 	move(CW_PC,  8); printw("Packet Count:");+ 	move(CW_PL,  7); printw("Packet Length:"); 0 	move(CW_PR,  2); printw("Packet Retry Count:"); #ifdef COMMENT0 	move(CW_PB,  2); printw("Packet Block Check:"); #endif /* COMMENT */( 	move(CW_ERR,10); printw("Last Error:");* 	move(CW_MSG, 8); printw("Last Message:");   #ifdef CK_NEED_SIG 	move(CW_INT, 0);r 	printw(N "<%s>X to cancel file, <%s>Z to cancel group, <%s><CR> to resend last packet",3 	       dbchr(escape), dbchr(escape), dbchr(escape)d
 	       ); 	move(CW_INT + 1, 0);n 	printw(O "<%s>E to send Error packet, ^C to quit immediately, <%s>L to refresh screen.",a$ 	       dbchr(escape), dbchr(escape)
 	       ); #else /* !CK_NEED_SIG */ 	move(CW_INT, 0);*
 #ifdef OS2 	printw(E "X to cancel file, Z to cancel group, <Enter> to resend last packet,"S
 	       ); #else /* !OS2 */ 	printw(B "X to cancel file, Z to cancel group, <CR> to resend last packet,"
 	       ); #endif /* OS2 */ 	move(CW_INT + 1, 0);s 	printw(
 #ifdef VMSG "E to send Error packet, ^C to quit immediately, ^W to refresh screen."  #else G "E to send Error packet, ^C to quit immediately, ^L to refresh screen."Y #endif /* VMS */
 	       ); #endif /* CK_NEED_SIG */ 	refresh();  	cendw = 0;      } 6     len = strlen(s);			/* Length of argument string */  E     debug(F101,"SCREENC switch","",f);	/* Handle our function code */      switch (f) {'       case SCR_FN:    			/* Filename */l2 	fsiz = -1L;			/* Invalidate previous file size */: 	move(CW_PCD,22);		/* Erase percent done from last time */ 	clrtoeol();7 	move(CW_SIZ,22);		/* Erase file size from last time */e 	clrtoeol();/ 	move(CW_ERR,22);		/* And last error message */n 	clrtoeol();1 	if (what == W_SEND) {		/* If we're sending... */m #ifdef CK_RESEND 	    switch (sendmode) { 	      case SM_RESEND: 		move(CW_NAM,11); 		printw("Resending:");W 		break; 	      default:d 		move(CW_NAM,13); 		printw("Sending:");  		break; 	    } #else* 	    move(CW_NAM,13);	 	    printw("Sending:"); #endif /* CK_RESEND */  9 	} else if (what == W_RECV) {	/* If we're receiving... */a 	    move(CW_NAM,11);d 	    printw("Receiving:");% 	} else {			/* If we don't know... */ 4 	    move(CW_NAM,11);		/* (should never see this) */ 	    printw("File Name:"); 	}- 	move(CW_NAM,22);		/* Display the filename */i 	if (len > 57) { 	    printw("%.55s..",s);l 	    len = 57; 	} else printw("%s",s); 0 	q = len;			/* Remember name length for later */ 	clrtoeol();0 	scrft();			/* Display file type (can change) */ 	refresh();	
 #ifdef OS2" 	savescreen(&commandscreen, 0, 0); #endif /* OS2 */ 	return;  +       case SCR_AN:    			/* File as-name */	( 	if (q + len + 4 < 58) {		/* Will fit */ 	    move(CW_NAM, 22 + q); 	    printw(" => %s",s); 	} else {			/* Too long */5 	    move(CW_NAM, 22);		/* Overwrite previous name */N 	    q = 0;/' 	    if (len + 4 > 57) {					/* wg15 */*' 		printw(" => %.51s..",s);			/* wg15 */* 		len = 53;					/* wg15 */- 	    } else printw(" => %s",s);				/* wg15 */t 	}3 	q += len + 4;			/* Remember horizontal position */0 	clrtoeol(); 	refresh();*
 #ifdef OS2" 	savescreen(&commandscreen, 0, 0); #endif /* OS2 */ 	return;  %       case SCR_FS: 			/* File size */n
 	fsiz = n; 	move(CW_SIZ,22);d! 	if (fsiz > -1L) printw("%ld",n);I 	clrtoeol(); 	scrft();			/* File type */p 	refresh();d
 #ifdef OS2" 	savescreen(&commandscreen, 0, 0); #endif /* OS2 */ 	return;  8       case SCR_PT:    			/* Packet type or pseudotype */ 	if (spackets < 5) {8 	    /* Things that won't change after the 4th packet */D 	    move(CW_PAR,22); printw("%s",parnam((char)parity)); clrtoeol(); 	    clrtoeol(); #ifdef COMMENT7 	    move(CW_PB, 22);		/* Block check on this packet */f8 	    if (bctu == 4) printw("B"); else printw("%d",bctu); 	    clrtoeol(); #endif /* COMMENT */ 	}  , 	x = (what == W_RECV) ?		/* Packet length */ 	  rpktl+1 : 	    spktl ;2 	if (x != oldlen) {		/* But only if it changed. */ 	    move(CW_PL, 22);i 	    printw("%d",x); 	    clrtoeol(); 	    oldlen = x; 	}/ 	move(CW_PC, 22);		/* Packet count (always). */d< 	printw("%d",spackets);		/* WARNING: this can slow us way */- 	clrtoeol();			/* down with short packets. */d  7 	if (wcur != oldwin) {		/* Window slots, if changed. */o 	    move(CW_WS, 22); $ 	    printw("%d of %d",wcur,wslotr); 	    clrtoeol(); 	    oldwin = wcur;r 	}7 	if (retrans != oldtry) {	/* Retry count, if changed */{ 	    move(CW_PR, 22);  	    printw("%d",retrans); 	    clrtoeol(); 	    oldtry = retrans; 	}F 	if (c != oldtyp && c != 'Y' && c != 'N') { /* Sender's packet type */ 	    move(CW_PT,22); 	    printw("%c",c); 	    clrtoeol(); 	    oldtyp = c; 	}6 	switch (c) {			/* Now handle specific packet types */* 	  case 'S':			/* Beginning of transfer */, 	    fcnt = fbyt = 0L;		/* Clear counters */- 	    gtv = -1L;			/* And old/new things... */g 	    oldpct = pct = 0L;G 	    break;   	  case 'D':			/* Data packet */7 	    if (fsiz > 0L) {		/* Show percent done if known */( 		long rpct;0 		oldpct = pct;		/* Remember previous percent */ 		howfar = ffc;t #ifdef CK_RESEND7 		if (what == W_SEND)	/* Account for PSEND or RESEND */o 		  howfar += sendstart; 		else if (what == W_RECV) 		  howfar += rs_len;d #endif /* CK_RESEND */( 		/* Percent done, to be displayed... */5 		pct = (fsiz > 99L) ? (howfar / (fsiz / 100L)) : 0L; 1 		if (pct > 100L ||	/* Allow for expansion and */aA 		   (oldpct == 99L && pct < 0L)) /* other boundary conditions */  		  pct = 100L;t: 		if (pct != oldpct)	/* Only do this 100 times per file */ 		  updpct(oldpct, pct); 	    } /* Fall thru... */H  . 	  case '%':			/* Timeouts, retransmissions */ 	    cps = shocps((int) pct);(3 	    old_tr = shoetl( old_tr, cps, fsiz, howfar ) ;e 	    break;a  ! 	  case 'E':			/* Error packet */c #ifdef COMMENT1 	    move(CW_ERR,22);		/* Print its data field */v 	    if (*s) printw("%s",s); 	    clrtoeol(); #endif /* COMMENT */7 	    fcnt = fbyt = 0L;		/* So no bytes for this file */h 	    break;g$ 	  case 'Q':			/* Crunched packet */ 	    cps = shocps((int) pct); 3 	    old_tr = shoetl( old_tr, cps, fsiz, howfar ) ;O 	    move(CW_ERR,22);  	    printw("Damaged Packet"); 	    clrtoeol(); 	    break;O 	  case 'T':			/* Timeout */ 	    cps = shocps((int) pct);,3 	    old_tr = shoetl( old_tr, cps, fsiz, howfar ) ;) 	    move(CW_ERR,22);O 	    printw("Timeout");  	    clrtoeol(); 	    break;"& 	  default:			/* Others, do nothing */ 	    break;, 	} 	refresh();(
 #ifdef OS2% 	savescreen( &commandscreen, 0, 0 ) ;d #endif /* OS2 */ 	return;  /       case SCR_ST:			/* File transfer status */e #ifdef COMMENT, 	move(CW_PCD,22);		/* Update percent done */) 	if (c == ST_OK) {		/* OK, print 100 % */; 	    updpct(oldpct,100); 	    pct = 100;c 	    oldpct = 0;: 	} else if (fsiz > 0L)		/* Not OK, update final percent */ /*E   The else part writes all over the screen -- howfar and/or fsiz haveg@   been reset as a consequence of the not-OKness of the transfer. */* 	  updpct(oldpct, (howfar * 100L) / fsiz);   	clrtoeol(); #else ) 	if (c == ST_OK) {		/* OK, print 100 % */ 0 	    move(CW_PCD,22);		/* Update percent done */ 	    updpct(oldpct,100); 	    pct = 100;  	    oldpct = 0; 	    clrtoeol(); 	} #endif /* COMMENT */  4 	move(CW_MSG,22);		/* Remove any previous message */ 	clrtoeol(); refresh();f 	move(CW_TR, 22);a 	clrtoeol(); refresh();   . 	switch (c) {			/* Print new status message */" 	  case ST_OK:			/* Transfer OK */$ 	    fcnt++;			/* Count this file */( 	    fbyt += ffc;		/* Count its bytes */ 	    move(CW_MSG,22);c5 	    printw("Transfer OK");	/* Say Transfer was OK */e 	    clrtoeol(); refresh();n 	    return;  " 	  case ST_DISC:			/* Discarded *// 	    move(CW_ERR,22); printw("File discarded");  	    pct = oldpct = 0; 	    clrtoeol(); refresh();_ 	    return;  ) 	  case ST_INT:       		/* Interrupted */s5 	    move(CW_ERR,22); printw("Transfer interrupted");  	    pct = oldpct = 0; 	    clrtoeol(); refresh();e 	    return;    	  case ST_SKIP:			/* Skipped */- 	    move(CW_ERR,22); printw("File skipped");N 	    pct = oldpct = 0; 	    clrtoeol(); refresh();* 	    return;  % 	  case ST_ERR:			/* Error message */n% 	    move(CW_ERR,22); printw("%s",s);  	    pct = oldpct = 0; 	    clrtoeol(); refresh();n 	    return;    	  case ST_REFU:			/* Refused */ 	    move(CW_ERR,22);n 	    if (*s) 	      printw("Refused, %s",s);y 	    else printw("Refused"); 	    pct = oldpct = 0; 	    clrtoeol(); refresh();l 	    return;   	  case ST_INC:h+ 	    move(CW_ERR,22); printw("Incomplete");i 	    pct = oldpct = 0; 	    clrtoeol(); refresh();g 	    return;   	  default:			/* Bad call */H 	    move(CW_ERR,22); printw("*** screen() called with bad status ***");# 	    clrtoeol(); refresh(); return;  	}  5       case SCR_TC: {   			/* Transaction complete */	 
 	  long ecps;  	  int eff = -1;C 	  ecps = (tsecs > 0) ? ((fbyt * 10L) / (long) tsecs) / 10L : fbyt;r0 	  move(CW_CP,22);			/* Overall transfer rate */ 	  printw("%ld", ecps);i 	  clrtoeol();; 	  move(CW_MSG,22);		/* Print statistics in message line */;5 	  if (speed > 99L && speed != 8880L && network == 0)19 	    eff = (((ecps * 100L) / (speed / 100L)) + 5L) / 10L; 4 	  printw("Files: %ld, Total Bytes: %ld",fcnt,fbyt);3 	  if (eff > -1) printw(", Efficiency: %d%%", eff);N 	  clrtoeol(); 	  move(CW_TR, 1);9 	  printw("       Elapsed Time: %s",hhmmss((long)tsecs));  	  clrtoeol();9 	  move(23,0); clrtoeol();	/* Clear instructions lines */ 9 	  move(22,0); clrtoeol();	/* to make room for prompt. */c
 	  refresh();e #ifndef VMSCURSE 	  endwin(); #ifdef SOLARIS 	  conres(); #endif /* SOLARIS */ #endif /* VMSCURSE */*: 	  pct = 100; oldpct = 0;	/* Reset these for next time. */5 	  oldtyp = 0; oldwin = -1; oldtry = -1; oldlen = -1;c8 	  cendw = 1; conoc(BEL);	/* Close window, then beep. */% 	  ft_win = 0;			/* Window closed. */f
 	  return;       }d/       case SCR_EM:			/* Error packet (fatal) */n 	move (CW_ERR,22); 	printw("? %s",s); 	conoc(BEL); 	pct = oldpct = 0; 	clrtoeol(); refresh(); return;   *       case SCR_QE:			/* Quantity equals */+       case SCR_TU:			/* Undelimited text */e2       case SCR_TN:			/* Text delimited at start */0       case SCR_TZ:			/* Text delimited at end */1 	return;				/* (ignored in fullscreen display) */_  ,       case SCR_XD:    			/* X-packet data */ 	move(CW_NAM,22);  	printw("%s",s); 	clrtoeol(); refresh(); return;T  '       case SCR_CW:			/* Close Window */o< 	clrtoeol(); move(23,0); clrtoeol(); move(22,0);	clrtoeol(); 	refresh();l9 	pct = 100; oldpct = 0;		/* Reset these for next time. */i3 	oldtyp = 0; oldwin = -1; oldtry = -1; oldlen = -1;a   #ifndef VMSCURSE
 	endwin(); #endif /* VMSCURSE */,0 	ft_win = 0;			/* Flag that window is closed. */ 	cendw = 1; return;   4       case SCR_CD:			/* Display current directory */ 	move(CW_DIR,22); printw(s); 	clrtoeol(); 	refresh();d
 #ifdef OS2" 	savescreen(&commandscreen, 0, 0); #endif /* OS2 */	 	return;	T          default:				/* Bad call */ 	move (CW_ERR,22);: 	printw("*** screen() called with bad function code ***"); 	clrtoeol(); refresh(); return;E     }C }R #endif /* CK_CURSES */   #endif /* MAC */