 #include "ckcsym.h" 
 #ifndef NOICP   = /*  C K U U S 7 --  "User Interface" for C-Kermit, part 7  */     /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */    /*C   This file created from parts of ckuus3.c, which became to big for ,   Mark Williams Coherent compiler to handle. */   /*=   Definitions here supersede those from system include files.  */7 #include "ckcdeb.h"			/* Debugging & compiler things */ 3 #include "ckcasc.h"			/* ASCII character symbols */ : #include "ckcker.h"			/* Kermit application definitions */5 #include "ckcxla.h"			/* Character set translation */ + #include "ckcnet.h"			/* Network symbols */ 2 #include "ckuusr.h"			/* User interface symbols */  3 #ifdef STRATUS				/* Stratus Computer, Inc.  VOS */  #ifdef putchar #undef putchar #endif /* putchar */ #define putchar(x) conoc(x)  #ifdef getchar #undef getchar #endif /* getchar */ #define getchar(x) coninc(0) #endif /* STRATUS */   static int x, y = 0, z;  static char *s;    #ifdef CK_SPEED 9 extern short ctlp[];			/* Control-char prefixing table */  #endif /* CK_SPEED */    #ifdef NETCONN> static int mdmsav = -1;			/* Save modem type around network */< static int oldplex = -1;		/* Duplex holder around network */ #endif /* NETCONN */   extern xx_strp xxstring;  E extern int success, nfilp, fmask, fncnv, frecl, binary, warn, msgflg; K extern int cmask, maxrps, wslotr, bigsbsiz, bigrbsiz, urpsiz, rpsiz, spsiz; K extern int spsizr, spsizf, maxsps, spmax, pflag, bctr, npad, timef, timint; H extern int pkttim, rtimo, local, nfils, displa, atcapr, nettype, escape;B extern int mdmtyp, duplex, dfloc, network, cdtimo, fncact, mypadn;? extern int tnlm, sosi, tlevel, lf_opts, backgrd, flow, fdispla; 5 extern int fnrpath, fnspath, debses, parity, pktpaus; 
 extern intA   atenci, atenco, atdati, atdato, atleni, atleno, atblki, atblko, B   attypi, attypo, atsidi, atsido, atsysi, atsyso, atdisi, atdiso;    #ifdef STRATUS: extern int atfrmi, atfrmo, atcrei, atcreo, atacti, atacto; #endif /* STRATUS */   extern long speed;  J extern CHAR sstate, eol, seol, stchr, mystch, mypadc, padch, ctlq, myctlq;  $ extern char *cmarg, *cmarg2, *dftty;  9 extern char *tp, *lp;			/* Temporary buffer & pointers */  #ifndef NOFRILLS> extern char optbuf[];			/* Buffer for MAIL or PRINT options */- extern int rprintf;			/* REMOTE PRINT flag */  #endif /* NOFRILLS */  extern char ttname[];  #ifdef NPIPE extern char pipename[];  #endif /* NPIPE */  0 extern struct keytab onoff[], filtab[], rltab[]; extern int nrlt;   C static struct keytab fttab[] = {	/* File types for SET FILE TYPE */       "ascii",     XYFT_B, CM_INV,
 #ifdef VMS'     "b",         XYFT_B, CM_INV|CM_ABR,  #endif /* VMS */     "binary",    XYFT_B, 0, 
 #ifdef VMS      "block",     XYFT_I, CM_INV,     "image",     XYFT_I, 0,  #endif /* VMS */ #ifdef CK_LABELED      "labeled",   XYFT_L, 0,  #endif /* CK_LABELED */ 
 #ifdef MAC     "macbinary", XYFT_M, 0,  #endif /* MAC */     "text",      XYFT_T, 0 };< static int nfttyp = (sizeof(fttab) / sizeof(struct keytab));  F static struct keytab rfttab[] = {	/* File types for REMOTE SET FILE */      "ascii",     XYFT_B, CM_INV,     "binary",    XYFT_B, 0, 
 #ifdef VMS     "labeled",   XYFT_L, 0,  #else 
 #ifdef OS2     "labeled",   XYFT_L, 0,  #endif /* OS2 */ #endif /* VMS */     "text",      XYFT_T, 0 };> static int nrfttyp = (sizeof(rfttab) / sizeof(struct keytab));  
 #ifndef NOSPL 4 int query = 0;				/* Global flag for QUERY active */  G static struct keytab vartyp[] = {	/* Variable types for REMOTE QUERY */  "global", (int) 'G', CM_INV, "kermit", (int) 'K', 0,  "system", (int) 'S', 0,  "user",   (int) 'G', 0 };> static int nvartyp = (sizeof(vartyp) / sizeof(struct keytab));   #endif /* NOSPL */   #ifdef DCMDBUF( extern char *atxbuf;			/* Atom buffer */+ extern char *cmdbuf;			/* Command buffer */ A extern char *line, *tmpbuf;		/* Character buffers for anything */ ) extern int *intime;			/* INPUT TIMEOUT */  #ifdef CK_CURSES /* This needs cleaning up... */  #ifdef UNIX + extern char *trmbuf;			/* Termcap buffer */  #endif /* UNIX */ 
 #ifdef OS2+ extern char *trmbuf;			/* Termcap buffer */  #endif /* OS2 */
 #ifdef OSK+ extern char *trmbuf;			/* Termcap buffer */  #endif /* OSK */ #ifdef AMIGA+ extern char *trmbuf;			/* Termcap buffer */  #endif /* AMIGA */ #ifdef STRATUS+ extern char *trmbuf;			/* Termcap buffer */  #endif /* STRATUS */ #endif /* CK_CURSES */ #else ) extern char atxbuf[];			/* Atom buffer */ , extern char cmdbuf[];			/* Command buffer */B extern char line[], tmpbuf[];		/* Character buffer for anything */ extern int intime[]; #ifdef CK_CURSES #ifdef UNIX , extern char trmbuf[];			/* Termcap buffer */ #endif /* UNIX */  #endif /* CK_CURSES */ #endif /* DCMDBUF */   #ifndef NOCSETS @ extern struct keytab fcstab[];		/* For SET FILE CHARACTER-SET */ extern struct keytab ttcstab[]; / extern int nfilc, fcharset, ntermc, tcsr, tcsl; 
 #ifdef OS2! _PROTOTYP( int os2setcp, (int) ); " _PROTOTYP( int os2getcp, (void) );& _PROTOTYP( void os2debugoff, (void) );' _PROTOTYP( int os2settitle, (char *) ); ? static int savtcsr = -1, savtcsl = -1, savfcs = -1, savcp = -1;  #endif /* OS2 */ #endif /* NOCSETS */  
 #ifndef NOSPL 0 extern int cmdlvl;			/* Overall command level */ #ifdef DCMDBUF; extern int *inpcas;			/* INPUT CASE setting on cmd stack */  #else  extern int inpcas[]; #endif /* DCMDBUF */ #endif /* NOSPL */  
 #ifdef TNCODE  extern int tn_init;  #endif /* TNCODE */   
 #ifdef ANYX25 1 extern int revcall, closgr, cudata, nx25, npadx3;  extern char udata[MAXCUDATA]; $ extern CHAR padparms[MAXPADPARMS+1];* extern struct keytab x25tab[], padx3tab[]; #endif /* ANYX25 */    #ifdef CK_CURSES #ifndef VMS  #ifndef COHERENT( _PROTOTYP(int tgetent,(char *, char *)); #endif /* COHERENT */  #endif /* VMS */ #endif /* CK_CURSES */   #ifndef NODIAL@ extern int dialhng, dialtmo, dialksp, dialdpy, dialmnp, dialmhu; extern int mdmspd;3 extern char *dialini, *dialdir, *dialcmd, *dialnpr;  extern FILE * dialfd;      struct keytab dialtab[] = {      "dial-command", XYDDIA, 0,     "directory", XYDDIR, 0,      "display", XYDDPY, 0,      "hangup",  XYDHUP, 0,      "init-string", XYDINI, 0,  #ifdef COMMENT     "hup-string", XYDHCM, 0, #endif /* COMMENT */     "kermit-spoof", XYDKSP, 0,     "mnp-enable", XYDMNP, 0,
 #ifdef MDMHUP      "modem-hangup", XYDMHU, 0, #endif /* MDMHUP */      "prefix", XYDNPR, 0,      "speed-matching", XYDSPD, 0,     "timeout", XYDTMO, 0 };6 int ndial = (sizeof(dialtab) / sizeof(struct keytab)); #endif /* NODIAL */    #ifndef NOXMIT /* set transmit */ #define XMITF 0  #define XMITL 1  #define XMITP 2  #define XMITE 3  #define XMITX 4  #define XMITS 5  #define XMITW 6    #define XMBUFL 50 4 extern int xmitf, xmitl, xmitp, xmitx, xmits, xmitw;; char xmitbuf[XMBUFL+1] = { NUL };	/* TRANSMIT eof string */    struct keytab xmitab[] = {     "echo",     XMITX, 0,      "eof",      XMITE, 0,      "fill",     XMITF, 0,      "linefeed", XMITL, 0,      "locking-shift", XMITS, 0,     "pause",    XMITW, 0,      "prompt",   XMITP, 0 };5 int nxmit = (sizeof(xmitab) / sizeof(struct keytab));  #endif /* NOXMIT */    /* For SET FILE COLLISION */M /* Some of the following may be possible for some C-Kermit implementations */ J /* but not others.  Those that are not possible for your implementation */ /* should be ifdef'd out. */  < struct keytab colxtab[] = { /* SET FILE COLLISION options */ #ifndef MAC 5     "append",    XYFX_A, 0,  /* append to old file */  #endif /* MAC */ #ifdef COMMENTC     "ask",       XYFX_Q, 0,  /* ask what to do (not implemented) */  #endif2     "backup",    XYFX_B, 0,  /* rename old file */ #ifndef MAC "     /* This crashes Mac Kermit. */8     "discard",   XYFX_D, 0,  /* don't accept new file */C     "no-supersede", XYFX_D, CM_INV, /* ditto (MSK compatibility) */  #endif /* MAC */M     "overwrite", XYFX_X, 0,  /* overwrite the old file == file warning off */ N     "rename",    XYFX_R, 0,  /* rename the incoming file == file warning on */ #ifndef MAC "     /* This crashes Mac Kermit. */3     "update",    XYFX_U, 0,  /* replace if newer */  #endif /* MAC */ };6 int ncolx = (sizeof(colxtab) / sizeof(struct keytab));  < static struct keytab rfiltab[] = {	/* for REMOTE SET FILE */     "collision",     XYFILX, 0,      "names",         XYFILN, 0,      "record-length", XYFILR, 0,      "type",          XYFILT, 0 };7 int nrfilp = (sizeof(rfiltab) / sizeof(struct keytab));   / struct keytab fntab[] = {   		/* File naming */      "converted", 1, 0,     "literal",   0, 0  };   #ifndef NOLOCAL  /* Terminal parameters table */  struct keytab trmtab[] = {
 #ifdef OS2     "answerback",    XYTANS, 0,  #endif /* OS2 */
 #ifdef CK_APC      "apc",           XYTAPC, 0,  #endif /* CK_APC */ 
 #ifdef OS2     "arrow-keys",    XYTARR, 0,  #endif /* OS2 */
 #ifdef OS2     "bell",          XYTBEL, 0,  #endif /* OS2 */     "bytesize",      XYTBYT, 0,  #ifndef NOCSETS      "character-set", XYTCS,  0,  #endif /* NOCSETS */
 #ifdef OS2     "code-page",     XYTCPG, 0,      "color",         XYTCOL, 0,  #endif /* OS2 */     "cr-display",    XYTCRD, 0, 
 #ifdef OS2     "cursor",        XYTCUR, 0,  #endif /* OS2 */     "debug",         XYTDEB, 0,      "echo",          XYTEC,  0, 
 #ifdef OS2     "hide-cursor",   XYTHCU, 0,      "keypad-mode",   XYTKPD, 0,  #endif /* OS2 */     "locking-shift", XYTSO,  0,  #ifdef OS2MOUSE      "mouse",         XYTMOU, 0,  #endif /* OS2MOUSE */      "newline-mode",  XYTNL,  0
 #ifdef OS2 ,   "output-pacing", XYTPAC, 0,      "roll",          XYTROL, 0,      "scrollback",    XYSCRS, 0, "     "transmit-timeout", XYTCTS, 0,     "type",          XYTTYP, 0,      "wrap",          XYTWRP, 0 #endif /* OS2 */ };4 int ntrm = (sizeof(trmtab) / sizeof(struct keytab));  9 struct keytab crdtab[] = {		/* Carriage-return display */      "crlf",        1, 0,     "normal",      0, 0  };; extern int tt_crd;			/* Carriage-return display variable */   
 #ifdef CK_APC   extern int apcstatus, apcactive;? static struct keytab apctab[] = {	/* Terminal APC parameters */      "off",	 APC_OFF,  0,     "on",	 APC_ON,   0,      "unchecked", APC_UNCH, 0 }; #endif /* CK_APC */  #endif /* NOLOCAL */  
 #ifdef OS2 /*$   OS/2 serial communication devices. */ struct keytab os2devtab[] = { 7     "1",    1, CM_INV,			/* Invisible synonyms, like */ +     "2",    2, CM_INV,			/* "set port 1" */      "3",    3, CM_INV,     "4",    4, CM_INV,     "5",    5, CM_INV,     "6",    6, CM_INV,     "7",    7, CM_INV,     "8",    8, CM_INV,+     "com1", 1, 0,			/* Real device names */      "com2", 2, 0,      "com3", 3, 0,      "com4", 4, 0,      "com5", 5, 0,      "com6", 6, 0,      "com7", 7, 0,      "com8", 8, 0 };: int nos2dev = (sizeof(os2devtab) / sizeof(struct keytab));   /*6   Terminal parameters that can be set by SET commands.0   Used by the ck?con.c terminal emulator code.  >   For now, only use for OS/2.  Should add these for Macintosh. */? int tt_arrow = TTK_NORM;		/* Arrow key mode: normal (cursor) */ > int tt_keypad = TTK_NORM;		/* Keypad mode: normal (numeric) */. int tt_wrap = 1;			/* Terminal wrap, 1 = On */> int tt_type = TT_VT220;			/* Terminal type, initially VT220 */9 int tt_cursor = 0;			/* Terminal cursor, 0 = Underline */ 9 int tt_answer = 0;			/* Terminal answerback (disabled) */ M int tt_scrsize = 240;                   /* Terminal scrollback buffer size */ 0 int tt_bell = 1;			/* Terminal bell (audible) */, int tt_roll = 0;			/* Terminal roll (off) */8 int tt_pacing = 0;			/* Terminal output-pacing (none) */2 int tt_hide = 1;			/* Terminal hide-cursor (on) */5 int tt_ctstmo = 15;			/* Terminal transmit-timeout */ 0 int tt_codepage = -1;			/* Terminal code-page */( int tt_mouse = 0;			/* Terminal mouse */. static int savcolor = 0;		/* Terminal color */< static int savcmask = 0;		/* For saving terminal bytesize */% extern int colornormal, colorreverse, F  colorunderline, colorstatus, colorhelp, colorborder, scrninitialised;  4 struct keytab beltab[] = {		/* Terminal bell mode */     "audible", 1, 0,     "none",    0, 0,     "visible", 2, 0  };0 struct keytab akmtab[] = {		/* Arrow key mode */     "application", TTK_APPL, 0,      "cursor",      TTK_NORM, 0 };- struct keytab kpmtab[] = {		/* Keypad mode */      "application", TTK_APPL, 0,      "numeric",     TTK_NORM, 0 };  C struct keytab ttycoltab[] = {		/* Screen coloring during CONNECT */ 4     "border",             5, 0,		/* Screen border */3     "help-text",          4, 0,		/* Help screens */ =     "normal",             0, CM_INV,	/* Normal screen text */ 8     "reverse-video",      1, CM_INV,	/* Reverse video */2     "status-line",        3, 0,		/* Status line */@     "terminal-screen",    0, 0,		/* Better name than "normal" */5     "underlined-text",    2, 0		/* Underlined text */  };: int ncolors = (sizeof(ttycoltab) / sizeof(struct keytab));  + struct keytab ttyclrtab[] = {		/* Colors */      "black",       0, 0,     "blue",        1, 0,     "brown",       6, 0,     "cyan",        3, 0,     "dgray",       8, 0,     "green",       2, 0,     "lblue",       9, 0,     "lcyan",      11, 0,     "lgray",       7, 0,     "lgreen",     10, 0,     "lmagenta",   13, 0,     "lred",       12, 0,     "magenta",     5, 0,     "red",         4, 0,     "white",      15, 0,     "yellow",     14, 0  }; int nclrs = 16;    struct keytab ttycurtab[] = {      "full",        2, 0,     "half",        1, 0,     "underline",   0, 0  }; int ncursors = 3;    struct keytab ttyptab[] = { 1     "ansi",    TT_ANSI,  0,		/* ANSI.SYS (BBS) */  /*L   The idea of NONE is to let the console driver handle the escape sequences,M   which, in theory at least, would give not only ANSI emulation, but also any G   other kind of emulation that might be provided by alternative console    drivers, if any existed.  K   For this to work, ckocon.c would need to be modified to make higher-level G   calls, like VioWrtTTY(), DosWrite(), or (simply) write(), rather than K   VioWrt*Cell() and similar, and it would also have to give up its rollback E   feature, and its status line and help screens would also have to be (   forgotten or else done in an ANSI way.  K   As matters stand, we already have perfectly good ANSI emulation built in, N   and there are no alternative console drivers available, so there is no pointM   in having a terminal type of NONE, so it is commented out.  However, should I   you uncomment it, it will work like a "glass tty" -- no escape sequence K   interpretation at all; somewhat similar to debug mode, except without the H   debugging (no highlighting of control chars or escape sequences); help5   screens, status line, and rollback will still work.  */ #ifdef COMMENT     "none",    TT_NONE,  0,  #endif /* COMMENT */ #ifdef OS2PM #ifdef COMMENT     "tek4014", TT_TEK40, 0,  #endif /* COMMENT */ #endif /* OS2PM */     "vt100",   TT_VT100, 0,      "vt102",   TT_VT102, 0,      "vt220",   TT_VT220, 0,  #ifdef COMMENT%     /* Let's not get carried away! */      "vt320",   TT_VT320, 0,  #endif /* COMMENT */     "vt52",    TT_VT52,  0 };6 int nttyp = (sizeof(ttyptab) / sizeof(struct keytab)); #endif /* OS2 */   /* #ifdef VMS */< struct keytab fbtab[] = {		/* Binary record types for VMS */=     "fixed",     XYFT_B, 0,		/* Fixed is normal for binary */ >     "undefined", XYFT_U, 0		/* Undefined if they ask for it */ };5 int nfbtyp = (sizeof(fbtab) / sizeof(struct keytab));  /* #endif */  
 #ifdef VMS3 struct keytab lbltab[] = {		/* Labeled File info */      "acl",         LBL_ACL, 0,     "backup-date", LBL_BCK, 0,     "name",        LBL_NAM, 0,     "owner",       LBL_OWN, 0,     "path",        LBL_PTH, 0C };5 int nlblp = (sizeof(lbltab) / sizeof(struct keytab));c #else.
 #ifdef OS23 struct keytab lbltab[] = {		/* Labeled File info */a     "archive",   LBL_ARC, 0,     "extended",  LBL_EXT, 0,     "hidden",    LBL_HID, 0,     "read-only", LBL_RO,  0,     "system",    LBL_SYS, 0t };5 int nlblp = (sizeof(lbltab) / sizeof(struct keytab));s #endif /* OS2 */ #endif /* VMS */   #ifdef CK_CURSES #ifdef CK_PCT_BARhE static struct keytab fdftab[] = {	/* SET FILE DISPLAY FULL options */s     "thermometer", 1, 0,     "no-thermometer", 0, 0 }; extern int thermometer;t #endif /* CK_PCT_BAR */t #endif /* CK_CURSES */  ? static struct keytab fdtab[] = {	/* SET FILE DISPLAY options */r #ifdef MAC				/* Macintosh */r>     "fullscreen", XYFD_R, 0,		/* Full-screen but not curses */     "none",   XYFD_N, 0,     "off",    XYFD_N, CM_INV,i     "on",     XYFD_R, CM_INV,y     "quiet",  XYFD_N, CM_INV   #else					/* Not Mac */i)     "crt", XYFD_S, 0,			/* CRT display */h #ifdef CK_CURSES #ifdef COMMENT;     "curses",     XYFD_C, CM_INV,	/* Full-screen, curses */  #endif /* COMMENT */D     "fullscreen", XYFD_C, 0,		/* Full-screen, whatever the method */ #endif /* CK_CURSES */*     "none",   XYFD_N, 0,		/* No display */*     "off",    XYFD_N, CM_INV,		/* Ditto */0     "on",     XYFD_R, CM_INV,		/* On = Serial *//     "quiet",  XYFD_N, CM_INV,		/* No display */t&     "serial", XYFD_R, 0			/* Serial */ #endif /* MAC */ };5 int nfdtab = (sizeof(fdtab) / sizeof(struct keytab));,  8 struct keytab rsrtab[] = {		/* For REMOTE SET RECEIVE */     "packet-length", XYLEN, 0,     "timeout", XYTIMO, 0 };7 int nrsrtab = (sizeof(rsrtab) / sizeof(struct keytab));    /* Send/Receive Parameters */t  i struct keytab srtab[] = {       "control-prefix", XYQCTL, 0,     "end-of-packet", XYEOL, 0,     "packet-length", XYLEN, 0,     "pad-character", XYPADC, 0,y     "padding", XYNPAD, 0,t     "pathnames", XYFPATH, 0,     "pause", XYPAUS, 0,i4     "quote", XYQCTL, CM_INV,		/* = CONTROL-PREFIX */!     "start-of-packet", XYMARK, 0,      "timeout", XYTIMO, 0 };5 int nsrtab = (sizeof(srtab) / sizeof(struct keytab));m   /* REMOTE SET */   struct keytab rmstab[] = {     "attributes",  XYATTR, 0,e     "block-check", XYCHKT, 0,i     "file",        XYFILE, 0,p     "incomplete",  XYIFD,  0,      "receive",     XYRECV, 0,t     "retry",       XYRETR, 0,t     "server",      XYSERV, 0,o     "transfer",    XYXFER, 0,o     "window",      XYWIND, 0 };4 int nrms = (sizeof(rmstab) / sizeof(struct keytab));   struct keytab attrtab[] = {  #ifdef STRATUS     "account",	     AT_ACCT, 0,s #endif /* STRATUS */      "all",           AT_XALL, 0, #ifdef COMMENT/     "blocksize",     AT_BLKS, 0,	/* not used */m #endif /* COMMENT */ #ifndef NOCSETSO      "character-set", AT_ENCO, 0, #endif /* NOCSETS */ #ifdef STRATUS     "creator",	     AT_CREA, 0,R #endif /* STRATUS */      "date",          AT_DATE, 0,      "disposition",   AT_DISP, 0,%     "encoding",      AT_ENCO, CM_INV,n #ifdef STRATUS     "format",	     AT_RECF, 0, #endif /* STRATUS */      "length",        AT_LENK, 0,      "off",           AT_ALLN, 0,      "on",            AT_ALLY, 0, #ifdef COMMENT>     "os-specific",   AT_SYSP, 0,	/* not used by UNIX or VMS */ #endif /* COMMENT */      "system-id",     AT_SYSI, 0,      "type",          AT_FTYP, 0, };O int natr = (sizeof(attrtab) / sizeof(struct keytab)); /* how many attributes */K  
 #ifndef NOSPLd$ extern int indef, inecho, insilence;7 struct keytab inptab [] = {		/* SET INPUT parameters */i!     "case",            IN_CAS, 0,(&     "default-timeout", IN_DEF, CM_INV,!     "echo",            IN_ECH, 0,O!     "silence",         IN_SIL, 0,F      "timeout-action",  IN_TIM, 0 };4 int ninp = (sizeof(inptab) / sizeof(struct keytab));  > struct keytab intimt[] = {		/* SET INPUT TIMEOUT parameters */(     "proceed", 0, 0,			/* 0 = proceed */$     "quit",    1, 0			/* 1 = quit */ };  ; struct keytab incast[] = {		/* SET INPUT CASE parameters */*'     "ignore",  0, 0,			/* 0 = ignore */c'     "observe", 1, 0			/* 1 = observe */y }; #endif /* NOSPL */ gM /* The following routines broken out of doprm() to give compilers a break. */   I /*  S E T O N  --  Parse on/off (default on), set parameter to result  */u  k int) seton(prm) int *prm; {
     int x, y;B=     if ((y = cmkey(onoff,2,"","on",xxstring)) < 0) return(y);u%     if ((x = cmcfm()) < 0) return(x); 
     *prm = y;	     return(1); }r  oB /*  S E T N U M  --  Set parameter to result of cmnum() parse.  */ /*1  Call with pointer to integer variable to be set, :    x = number from cnum parse, y = return code from cmnum,3    max = maximum value to accept, -1 if no maximum. B  Returns -9 on failure, after printing a message, or 1 on success. */ intu* setnum(prm,x,y,max) int x, y, *prm, max; {     extern int cmflgs;     debug(F101,"setnum","",y);     if (y == -3) { 	printf("\n?Value required\n");m 	return(-9);     }f     if (y == -2) {A 	printf("%s?Not a number: %s\n",cmflgs == 1 ? "" : "\n", atxbuf);* 	return(-9);     }f     if (y < 0) return(y);      if (max > -1 && x > max) {+ 	printf("?Sorry, %d is the maximum\n",max);t 	return(-9);     }_%     if ((y = cmcfm()) < 0) return(y);f
     *prm = x;p     return(1); }/  NI /*  S E T C C  --  Set parameter to an ASCII control character value.  */x  n intc  setcc(prm,x,y) int x, y, *prm; {     if (y == -3) { 	printf("\n?Value required\n");  	return(-3);     }a     if (y < 0) return(y); #     if ((x > 037) && (x != 0177)) {(2 	printf("\n?Not in ASCII control range - %d\n",x); 	return(-2);     },%     if ((y = cmcfm()) < 0) return(y); 
     *prm = x;t     return(1); }-   #ifndef NODIAL0 _PROTOTYP(static int dialstr,(char **, char *)); /*B   Parse a DIAL-related string, stripping enclosing braces, if any. */
 static int% dialstr(p,msg) char **p; char *msg; {P
     int x;/     if ((x = cmtxt(msg, "", &s, xxstring)) < 0);       return(x);0     s = brstrip(s);			/* Strip braces around. */0     if (*p) {				/* Free any previous string. */
 	free(*p); 	*p = (char *) 0;r     }	     if ((x = strlen(s)) > 0) {1 	*p = malloc(x + 1);		/* Allocate space for it */1, 	strcpy(*p,s);			/* and make a safe copy. */     } else *p = (char *) 0;d     return(success = 1); }i  & int					/* Set DIAL command options */ setdial() {;A     if ((y = cmkey(dialtab,ndial,"","",xxstring)) < 0) return(y);      switch (y) {&       case XYDHUP:			/* DIAL HANGUP */ 	return(seton(&dialhng));x+       case XYDINI:			/* DIAL INIT-STRING */d@ 	return(dialstr(&dialini,"Modem dialer initialization string"));-       case XYDNPR:			/* DIAL NUMBER-PREFIX */,B 	return(dialstr(&dialnpr,"Modem dialer telephone number prefix"));,       case XYDDIA:			/* DIAL DIAL-COMMAND */) 	x = cmtxt("Dialing command for modem,\n\H-  include \"%s\" to stand for phone number,\n\"4  for example, \"set dial dial-command ATDT%s\\13\"", 		  "",  		  &s,n 		  xxstring);1 	if (x < 0 && x != -3)		/* Handle parse errors */ 
 	  return(x);n- 	y = x = strlen(s);		/* Get length of text */n8 	if (x > 0 && *s == '{') {	/* Strip enclosing braces, */' 	    if (s[x-1] == '}') {	/* if any. */t 		s[x-1] = NUL;f 		s++;	 		y -= 2;n 	    } 	}2 	if (y > 0) {			/* If there is any text (left), */A 	    for (x = 0; x < y; x++) {	/* make sure they included "%s" */i 		if (s[x] != '%') continue; 		if (s[x+1] == 's') break;X 	    } 	    if (x == y) {	 		printf(i> "?Dial-command must contain \"%cs\" for phone number.\n",'%');
 		return(-9);  	    } 	}1 	if (dialcmd) {			/* Free any previous string. */, 	    free(dialcmd);i 	    dialcmd = (char *) 0; 	}	M
 	if (y > 0) {p9 	    dialcmd = malloc(y + 1);	/* Allocate space for it */f4 	    strcpy(dialcmd,s);		/* and make a safe copy. */ 	} 	return(success = 1); ,       case XYDKSP:			/* DIAL KERMIT-SPOOF */ 	return(seton(&dialksp));*'       case XYDTMO:			/* DIAL TIMEOUT */iE 	y = cmnum("Seconds to wait for call completion","0",10,&x,xxstring);k$ 	return(setnum(&dialtmo,x,y,10000));'       case XYDDPY:			/* DIAL DISPLAY */" 	return(seton(&dialdpy));t.       case XYDSPD:			/* DIAL SPEED-MATCHING */$ 					/* used to be speed-changing */) 	if ((y = seton(&mdmspd)) < 0) return(y);  #ifdef COMMENT; 	mdmspd = 1 - mdmspd;		/* so here we reverse the meaning */r #endif /* COMMENT */ 	return(success = 1);,*       case XYDMNP:			/* DIAL MNP-ENABLE */ 	return(seton(&dialmnp));*
 #ifdef MDMHUPp,       case XYDMHU:			/* DIAL MODEM-HANGUP */ 	return(seton(&dialmhu));t #endif /* MDMHUP */e)       case XYDDIR:			/* DIAL DIRECTORY */0: 	if ((y = cmifi("Name of dialing directory file","",&s,&x, 		       xxstring)) < 0) { 	    if (y == -3) {u= 		if (dialdir) free(dialdir);	/* Free any previous storage *// 		dialdir = NULL;s 		return(success = 1); 	    } else return(y); 	}	 	if (x) {b( 	    printf("?Wildcards not allowed\n"); 	    return(-9); 	}6 	strcpy(line,s);			/* Make safe copy of dial string */< 	if ((y = cmcfm()) < 0) return(y); /* Confirm the command */A 	if (dialdir) free(dialdir);	/* Free previous filename storage */y2 	if (dialfd) {			/* Close previous file, if any */ 	    fclose(dialfd); 	    dialfd = NULL;i 	}, 	s = line;			/* Point back to dial string */5 	if (s == NULL || *s == NUL) {	/* If no name given */"2 	    dialdir = NULL;		/* remove the name string */ 	    return(success = 1);,6 	} else if ((dialdir = malloc(strlen(s)+1)) == NULL) {= 	    return(success = 0);	/* Can't malloc storage for name */ ' 	} else {			/* Have storage for name */b; 	    strcpy(dialdir,s);		/* Copy string into new storage */sE 	    if ((dialfd = fopen(dialdir,"r")) == NULL) { /* Open the file */ 8 		perror(dialdir);	/* Can't, print message saying why */' 		success = 0;		/* We didn't succeed */ 2 		return(-9);		/* Fail, message already printed */ 	    }0 	    return(success = 1);	/* Everything is OK */ 	} #ifdef COMMENT*       case XYDHCM:			/* DIAL HUP-STRING */? 	return(dialstr(&hupcmd,"Modem dialer hangup command string"));i #endif /* COMMENT */         default:, 	printf("?Unexpected SET DIAL parameter\n"); 	return(-2);     }w }e #endif /* NODIAL */i   int2 setfil(rmsflg) int rmsflg; {     if (rmsflg) { : 	if ((y = cmkey(rfiltab,nrfilp,"Remote file parameter","", 		       xxstring)) < 0) { 	    if (y == -3) { . 		printf("?Remote file parameter required\n");
 		return(-9);  	    } else return(y); 	}     } else {@ 	if ((y = cmkey(filtab,nfilp,"File parameter","",xxstring)) < 0)
 	  return(y);      }      switch (y) {" #ifdef COMMENT				/* Not needed */$       case XYFILB:			/* Blocksize */ 	sprintf(tmpbuf,"%d",DBLKSIZ);> 	if ((y = cmnum("file block size",tmpbuf,10,&z,xxstring)) < 0)
 	  return(y); " 	if ((x = cmcfm()) < 0) return(x); 	if (rmsflg) { 	    sprintf(tmpbuf,"%d",z);- 	    sstate = setgen('S', "311", tmpbuf, "");e 	    return((int) sstate);	 	} else {  	    fblksiz = z;c 	    return(success = 1);k 	} #endif /* COMMENT */  $       case XYFILS:			/* Byte size */C 	if ((y = cmnum("file byte size (7 or 8)","8",10,&z,xxstring)) < 0),
 	  return(y);  	if (z != 7 && z != 8) {, 	    printf("\n?The choices are 7 and 8\n"); 	    return(0);_ 	}" 	if ((y = cmcfm()) < 0) return(y); 	if (z == 7) fmask = 0177; 	else if (z == 8) fmask = 0377;c 	return(success = 1);"   #ifndef NOCSETS"(       case XYFILC:			/* Character set */G 	if ((x = cmkey(fcstab,nfilc,"local file code","ascii", xxstring)) < 0)t
 	  return(x); " 	if ((z = cmcfm()) < 0) return(z); 	fcharset = x; 	return(success = 1);  #endif /* NOCSETS */  "       case XYFILD:			/* Display */> 	if ((x = cmkey(fdtab,nfdtab,"file transfer display style","", 		       xxstring)) < 0)
 	  return(x);* #ifdef CK_PCT_BAR 9 	if ((y = cmkey(fdftab,2,"","thermometer",xxstring)) < 0) 
 	  return(y);n 	thermometer = y;  #endif /* CK_PCT_BAR */	" 	if ((z = cmcfm()) < 0) return(z); #ifdef CK_CURSES 	if (x == XYFD_C) {o
 #ifdef VMS 	    lp = line;a #else  	    lp = trmbuf;s #endif /* VMS */ #ifndef MYCURSES 	    s = getenv("TERM"); 	    if (!s) s = "unknown";e0 	    else if ((int)strlen(s) < 1) s = "unknown"; #ifndef COHERENT 	    if (tgetent(lp,s) < 1) {o
 #ifdef VMS7 		printf("Sorry, terminal type not supported: %s\n",s);  #else 1 		printf("Sorry, terminal type unknown: %s\n",s);m #endif /* VMS */ 		return(success = 0); 	    } #endif /* COHERENT */r #endif /* MYCURSES */  	    line[0] = '\0'; 	} #endif /* CK_CURSES */ 	fdispla = x;			/* It's OK. */ 	return(success = 1);           case XYFILN:			/* Names */> 	if ((x = cmkey(fntab,2,"how to handle filenames","converted", 		       xxstring)) < 0)
 	  return(x);n" 	if ((z = cmcfm()) < 0) return(z); 	if (rmsflg) {  	    sprintf(tmpbuf,"%d",1 - x);- 	    sstate = setgen('S', "301", tmpbuf, "");  	    return((int) sstate);	 	} else {w 	    fncnv = x;  	    return(success = 1);  	}  (       case XYFILR:			/* Record length */ 	sprintf(tmpbuf,"%d",DLRECL);eA 	if ((y = cmnum("file record length",tmpbuf,10,&z,xxstring)) < 0),
 	  return(y);t" 	if ((x = cmcfm()) < 0) return(x); 	if (rmsflg) { 	    sprintf(tmpbuf,"%d",z);- 	    sstate = setgen('S', "312", tmpbuf, "");e 	    return((int) sstate);	 	} else {  	    frecl = z;  	    return(success = 1);m 	}   #ifdef COMMENT'       case XYFILO:			/* Organization */e? 	if ((x = cmkey(forgtab,nforg,"file organization","sequential",  		       xxstring)) < 0)
 	  return(x);r" 	if ((y = cmcfm()) < 0) return(y); 	if (rmsflg) { 	    sprintf(tmpbuf,"%d",x);- 	    sstate = setgen('S', "314", tmpbuf, "");u 	    return((int) sstate);	 	} else {[ 	    forg = x; 	    return(success = 1);  	}	  #endif /* COMMENT */  " #ifdef COMMENT				/* Not needed */!       case XYFILF:			/* Format */8< 	if ((x = cmkey(frectab,nfrec,"file record format","stream", 		       xxstring)) < 0)
 	  return(x);7" 	if ((y = cmcfm()) < 0) return(y); 	if (rmsflg) { 	    sprintf(tmpbuf,"%d",x);- 	    sstate = setgen('S', "313", tmpbuf, "");4 	    return((int) sstate);	 	} else {l 	    frecfm = x; 	    return(success = 1);u 	} #endif /* COMMENT */   #ifdef COMMENT3       case XYFILP:			/* Printer carriage control */ > 	if ((x = cmkey(fcctab,nfcc,"file carriage control","newline", 		       xxstring)) < 0)
 	  return(x);(" 	if ((y = cmcfm()) < 0) return(y); 	if (rmsflg) { 	    sprintf(tmpbuf,"%d",x);- 	    sstate = setgen('S', "315", tmpbuf, "");v 	    return((int) sstate);	 	} else {  	    fcctrl = x; 	    return(success = 1);v 	}	b #endif /* COMMENT */         case XYFILT:			/* Type */o) 	if ((x = cmkey(rmsflg ? rfttab  : fttab,o# 		       rmsflg ? nrfttyp : nfttyp,,7 		       "type of file transfer","text",xxstring)) < 0)r
 	  return(x);t  
 #ifdef VMSF         /* Allow VMS users to choose record format for binary files */-         if ((x == XYFT_B) && (rmsflg == 0)) { = 	    if ((x = cmkey(fbtab,nfbtyp,"VMS record format","fixed",s 			   xxstring)) < 0)  	      return(x);  	} #endif /* VMS */" 	if ((y = cmcfm()) < 0) return(y);1 	binary = x;			/* Do it locally too (edit 190) */v
 #ifdef MAC 	(void) mac_setfildflg(binary);e #endif /* MAC */ 	if (rmsflg) {8 	    char buf[4];		/* Allow for LABELED in VMS & OS/2 */ 	    sprintf(buf,"%d",x);a* 	    sstate = setgen('S', "300", buf, ""); 	    return((int) sstate);	 	} else {h 	    return(success = 1);c 	}  +       case XYFILX:			/* Collision Action */oC 	if ((x = cmkey(colxtab,ncolx,"Filename collision action","backup",  		       xxstring)) < 0)
 	  return(x); " 	if ((y = cmcfm()) < 0) return(y); 	fncact = x; 	if (rmsflg) {! 	    sprintf(tmpbuf,"%d",fncact); - 	    sstate = setgen('S', "302", tmpbuf, "");  	    return((int) sstate);	 	} else {EH 	    if (fncact == XYFX_R) warn = 1; /* SET FILE WARNING implications */. 	    if (fncact == XYFX_X) warn = 0; /* ... */ 	    return(success = 1);t 	}  0       case XYFILW:			/* Warning/Write-Protect */' 	if ((x = seton(&warn)) < 0) return(x);	
 	if (warn) 	  fncact = XYFX_R;/ 	elsef 	  fncact = XYFX_X;	 	return(success = 1);    #ifdef CK_LABELEDf2       case XYFILL:			/* LABELED FILE parameters */7 	if ((x = cmkey(lbltab,nlblp,"Labeled file feature","",) 		       xxstring)) < 0)
 	  return(x);y 	if ((success = seton(&y)) < 0)  	  return(success); . 	if (y)				/* Set or reset the selected bit */0 	  lf_opts |= x;			/* in the options bitmask. */ 	elseL 	  lf_opts &= ~x;" 	return(success);C #endif /* CK_LABELED */(  %       case XYFILI:			/* INCOMPLETE */. 	return(doprm(XYIFD,rmsflg));t         default:( 	printf("?unexpected file parameter\n"); 	return(-2);     }  }L   #ifndef NOLOCALe int 
 settrm() {@     if ((y = cmkey(trmtab,ntrm,"", "",xxstring)) < 0) return(y);
 #ifdef MACN     printf("\n?Sorry, not implemented yet.  Please use the Settings menu.\n");     return(-9);S #elsef     switch (y) {0       case XYTBYT:			/* SET TERMINAL BYTESIZE */= 	if ((y = cmnum("bytesize for terminal connection","8",10,&x," 		       xxstring)) < 0)
 	  return(y);d 	if (x != 7 && x != 8) {, 	    printf("\n?The choices are 7 and 8\n"); 	    return(success = 0);Y 	}" 	if ((y = cmcfm()) < 0) return(y); 	if (x == 7) cmask = 0177; 	else if (x == 8) cmask = 0377;r         return(success = 1);  4       case XYTSO:			/* SET TERMINAL LOCKING-SHIFT */ 	return(seton(&sosi));  3       case XYTNL:			/* SET TERMINAL NEWLINE-MODE */, 	return(seton(&tnlm)); l  
 #ifdef OS2-       case XYTCOL:			/* SET TERMINAL COLOR */YA 	if ((x = cmkey(ttycoltab,ncolors,"","terminal",xxstring)) < 0) {  	    return(x);D         } else { 	    int fg, bg;  	    fg = cmkey(ttyclrtab,nclrs,- 		       (x == 5 ? "color for screen border"  @ 		              : "foreground color and then background color"),   		       "black",xxstring);q 	    if (fg < 0)return(fg);o 	    if (x != 5) {" 		if ((bg = cmkey(ttyclrtab,nclrs,- 				"background color","cyan",xxstring)) < 0)  		  return(bg);e 	    } 	    if ((y = cmcfm()) < 0){ 	      return(y);  	    switch (x) {c 	      case 0: 		colornormal = fg | bg << 4;0 		break; 	      case 1: #ifdef COMMENT 		colorreverse = fg | bg << 4; #else  		if (pflag &&
 #ifndef NOSPLa 		  cmdlvl == 0  #elser 		    tlevel < 0 #endif /* NOSPL */ 		      ) { 5 		printf(" Sorry, this command has been retired.\n");,; 		printf(" Reverse video is now accomplished simply by\n");F; 		printf(" exchanging the fore- and background colors.\n");N 	    } #endif /* COMMENT */ 		break; 	      case 2:  		colorunderline = fg | bg << 4; 		break; 	      case 3: 		colorstatus = fg | bg << 4;m 		break; 	      case 4: 		colorhelp = fg | bg << 4;  		break; 	      case 5: 		colorborder = fg;X 		break; 	      default: " 		printf("%s - invalid\n",cmdbuf);
 		return(-9);  		break; 	    } 	    scrninitialised = 0; 	         }t 	return(success = 1);S  .       case XYTCUR:			/* SET TERMINAL CURSOR */A 	if ((x = cmkey(ttycurtab,ncursors,"","underline",xxstring)) < 0)t
 	  return(x);t" 	if ((y = cmcfm()) < 0) return(y);         tt_cursor = x; 	return(success = 1);f  ,       case XYTTYP:			/* SET TERMINAL TYPE */C 	if ((x = cmkey(ttyptab,nttyp,"","vt220",xxstring)) < 0) return(x);e" 	if ((y = cmcfm()) < 0) return(y);
 	tt_type = x;r 	if (tt_type == TT_ANSI) { 	    if (parity) 	      printf(H "WARNING, ANSI terminal emulation works right only if PARITY is NONE.\n\+ HELP SET PARITY for further information.\n" 	 		     );n2 	    savcolor = colornormal;	/* Save coloration */3 	    colornormal = 0x07;		/* Light gray on black */n6 	    scrninitialised = 0;	/* To make it take effect */* 	    savcmask = cmask;		/* Go to 8 bits */ 	    cmask = 0xFF;1 	    savtcsl = tcsl;		/* Save terminal charset *// 	    savtcsr = tcsr;	      	    savfcs  = fcharset;4 	    tcsr = tcsl = FC_CP437;	/* Go to transparent */1 	    y = os2getcp();		/* Get current code page */n+ 	    if (y != 437) {		/* If it's not 437 */t* 		savcp = y;		/* Save current code page */1 		y = os2setcp(437);	/* Try to switch to CP437 */" 		if (pflag) 		  printf(y ?' 			 "Switching to Code Page 437...\n" :e+ 			 "Warning: Code Page 437 not prepared\n"  			 ); 	    }+ 	} else {			/* Not ANSI, but a real type */ 4 	    if (savcolor) {		/* Restore this stuff if we */3 		colornormal = savcolor;	/* were ANSI before... */t 		savcolor = 0;e 		scrninitialised = 0; 	    }5 	    if (savcmask) {		/* Restore terminal bytesize */a 		cmask = savcmask;T 		savcmask = 0;e 	    }6 	    if (savtcsl > -1) {		/* Restore character sets */ 		tcsl = savtcsl;s 		tcsr = savtcsr;	     		fcharset = savfcs; 		savtcsl = -1;  	    }. 	    if (savcp > 0) {		/* Restore code page */ 		os2setcp(savcp);
 		savcp = -1;f 	    } 	} 	return(success = 1);*  2       case XYTARR:			/* SET TERMINAL ARROW-KEYS */9 	if ((x = cmkey(akmtab,2,"","",xxstring)) < 0) return(x);)" 	if ((y = cmcfm()) < 0) return(y);8 	tt_arrow = x;			/* TTK_NORM / TTK_APPL; see ckuusr.h */ 	return(success = 1);r  3       case XYTKPD:			/* SET TERMINAL KEYPAD-MODE */r9 	if ((x = cmkey(kpmtab,2,"","",xxstring)) < 0) return(x);a" 	if ((y = cmcfm()) < 0) return(y);9 	tt_keypad = x;			/* TTK_NORM / TTK_APPL; see ckuusr.h */s 	return(success = 1);r  ,       case XYTWRP:			/* SET TERMINAL WRAP */ 	return(seton(&tt_wrap));          case XYSCRS:D 	if ((y = cmnum("CONNECT scrollback buffer size, lines","240",10,&x, 		       xxstring)) < 0)
 	  return(y);9 #ifdef __32BIT__G 	if (x < 1 || x > 2000000L) { /* The max number of lines is the RAM  */xN                                      /* we can actually dedicate to a       */2 				     /* scrollback buffer given the maximum */N                                      /* process memory space of 512MB       */> 	    printf("\n?The size must be between 1 and 2,000,000\n");  	    return(success = 0);l  	}  #else  	if (x < 64 || x > 240) { 8 	    printf("\n?The size must be between 64 and 240\n"); 	    return(success = 0);a 	} #endif /* __32BIT__ */" 	if ((y = cmcfm()) < 0) return(y); 	tt_scrsize = x; 	return(success = 1);e #endif /* OS2 */   #ifndef NOCSETS 4       case XYTCS:			/* SET TERMINAL CHARACTER-SET */2 	/* set terminal character-set <remote> <local> */ 	if ((x = cmkey(ttcstab,ntermc,;< 		       "remote terminal character-set","",xxstring)) < 0) 
 	  return(x); * 	if (x == FC_TRANSP) {		/* TRANSPARENT? */@ 	    if ((x = cmcfm()) < 0) return(x); /* Confirm the command */< 	    tcsr = tcsl = FC_USASCII;	/* Make them both the same */ 	    return(success = 1);/ 	}  < /* Not transparent, so get local set to translate it into */   	s = "";
 #ifdef OS25 	y = os2getcp();			/* Default is current code page */ 
 	switch (y) {(  	  case 437: s = "cp437"; break;  	  case 850: s = "cp850"; break;  	  case 852: s = "cp852"; break;  	  case 862: s = "cp862"; break;  	  case 866: s = "cp866"; break; 	} #elsen% 					/* Make current file char set */ 5 	for (y = 0; y <= nfilc; y++)	/* be the default... *//% 	  if (fcstab[y].kwval == fcharset) {e 	      s = fcstab[y].kwd;I
 	      break;( 	  } #endif /* OS2 */ 	if ((y = cmkey(fcstab,nfilc,;0 		       "local character-set",s,xxstring)) < 0)
 	  return(y);(< 	if ((z = cmcfm()) < 0) return(z); /* Confirm the command */' 	tcsr = x;			/* Remote character set */c& 	tcsl = y;			/* Local character set */ 	return(success = 1);f #endif /* NOCSETS */  +       case XYTEC:			/* SET TERMINAL ECHO */3= 	if ((x = cmkey(rltab,nrlt,"which side echos during CONNECT",)- 		       "remote", xxstring)) < 0) return(x);y" 	if ((y = cmcfm()) < 0) return(y); 	duplex = x; 	return(success = 1);   2       case XYTCRD:			/* SET TERMINAL CR-DISPLAY */A 	if ((x = cmkey(crdtab,2,"", "normal", xxstring)) < 0) return(x); " 	if ((y = cmcfm()) < 0) return(y); 	tt_crd = x; 	return(success = 1);   
 #ifdef OS22       case XYTANS:			/* SET TERMINAL ANSWERBACK */ /*F   NOTE: We let them enable and disable the answerback sequence, but weJ   do NOT let them change it, and we definitely do not let the host set it.   This is a security feature.d */ 	return(seton(&tt_answer));. #endif /* OS2 */  
 #ifdef CK_APCa       case XYTAPC:D 	if ((y = cmkey(apctab,3,"application program command execution","", 		       xxstring)) < 0)
 	  return(y);n" 	if ((x = cmcfm()) < 0) return(x);= 	if (apcactive && apcstatus != APC_UNCH) return(success = 0);r 	apcstatus = y;	 	return(success = 1);M #endif /* CK_APC */*  
 #ifdef OS2       case XYTBEL:G 	if ((y = cmkey(beltab,3,"how terminal emulator rings bells","audible",0 		       xxstring)) < 0)
 	  return(y);Y" 	if ((x = cmcfm()) < 0) return(x);
 	tt_bell = y;: 	return(success = 1);N #endif /* OS2 */  )       case XYTDEB:			/* TERMINAL DEBUG */m' 	x = debses;			/* What it was before */m. 	y = seton(&debses);		/* Go parse ON or OFF */
 #ifdef OS2& 	if (y > 0)			/* Command succeeded? */G 	  if ((x != 0) && (debses == 0)) /* It was on and we turned it off? */). 	    os2debugoff();		/* Fix OS/2 coloration */ #endif /* OS2 */ 	return(y);(  
 #ifdef OS2,       case XYTROL:			/* SET TERMINAL ROLL */ 	return(seton(&tt_roll));   8       case XYTCTS:			/* SET TERMINAL TRANSMIT-TIMEOUT */= 	y = cmnum("Maximum seconds to allow CTS off during CONNECT",i 		  "5",10,&x,xxstring);& 	return(setnum(&tt_ctstmo,x,y,10000));  3       case XYTCPG: {			/* SET TERMINAL CODE-PAGE */ 
 	int cp = -1;(; 	y = cmnum("PC code page to use during terminal emulation",i 		  "850",10,&x,xxstring);/ 	if ((x = setnum(&cp,x,y,2000)) < 0) return(x);y 	if (os2setcp(cp) != 1) {/D 	    printf("Sorry, %d is not a valid code page for this system\n"); 	    return(-9); 	} 	return(1);f       }n  3       case XYTHCU:			/* SET TERMINAL HIDE-CURSOR */s 	return(seton(&tt_hide));   5       case XYTPAC:			/* SET TERMINAL OUTPUT-PACING */a 	y = cmnum( H 	   "Pause between sending each character during CONNECT, milliseconds", 		  "-1",10,&x,xxstring);=& 	return(setnum(&tt_pacing,x,y,10000));   #ifdef OS2MOUSE	-       case XYTMOU:			/* SET TERMINAL MOUSE */	 	return(seton(&tt_mouse)); #endif /* OS2MOUSE */,   #endif /* OS2 */  +       default:				/* Shouldn't get here. */d 	return(-2);     }  #endif /* MAC */ }  #endif /* NOLOCAL */   int					/* SET SEND/RECEIVE */' setsr(xx, rmsflg) int xx; int rmsflg; {*     if (xx == XYRECV)a3       strcpy(line,"Parameter for inbound packets");u     else4       strcpy(line,"Parameter for outbound packets");  X     if (rmsflg) {P8 	if ((y = cmkey(rsrtab,nrsrtab,line,"",xxstring)) < 0) { 	    if (y == -3) {e1 		printf("?Remote receive parameter required\n");x
 		return(-9);  	    } else return(y); 	}     } else {? 	if ((y = cmkey(srtab,nsrtab,line,"",xxstring)) < 0) return(y);f     }g     switch (y) {)       case XYQCTL:			/* CONTROL-PREFIX */"H 	if ((x = cmnum("ASCII value of control prefix","",10,&y,xxstring)) < 0)
 	  return(x);q" 	if ((x = cmcfm()) < 0) return(x);1 	if ((y > 32 && y < 63) || (y > 95 && y < 127)) {i 	    if (xx == XYRECV)@ 	      ctlq = (CHAR) y;		/* RECEIVE prefix, use with caution! */	 	    elseE9 	      myctlq = (CHAR) y;	/* SEND prefix, OK to change *// 	    return(success = 1); 	 	} else {(5 	    printf("?Illegal value for prefix character\n");) 	    return(-9); 	}         case XYEOL:eA 	y = cmnum("Decimal ASCII code for packet terminator","13",10,&x,  		  xxstring);( 	if ((y = setcc(&z,x,y)) < 0) return(y); 	if (z > 31) {2 	    printf("Sorry, the legal values are 0-31\n"); 	    return(-9); 	}" 	if (xx == XYRECV) eol = z; else { 	    seol = z; 	} 	return(success = y);   ,       case XYLEN:)A 	y = cmnum("Maximum number of characters in a packet","90",10,&x,h 		  xxstring);& 	if (xx == XYRECV) {		/* Receive... */) 	    if ((y = setnum(&z,x,y,maxrps)) < 0)f 	      return(y);  	    if (z < 10) {' 		printf("Sorry, 10 is the minimum\n"); 
 		return(-9);  	    } 	    if (rmsflg) { 		tp = tmpbuf; 		sprintf(tp,"%d",z);o& 		sstate = setgen('S', "401", tp, ""); 		return((int) sstate); 
 	    } else {  		if (z > MAXRP) z = MAXRP;r  		y = adjpkl(z,wslotr,bigrbsiz); 		if (y != z) {  		    urpsiz = y;i
 		    if (
 #ifndef NOSPLd 			cmdlvl == 0 #elsee
 			tlevel < 0" #endif /* NOSPL */ 			) 		      if (msgflg) printf(C? " Adjusting receive packet-length to %d for %d window slots\n",< 			 y, wslotr);) 		}t
 		urpsiz = y;  		rpsiz =  (y > 94) ? 94 : y;  	    } 	} else {			/* Send... */d) 	    if ((y = setnum(&z,x,y,maxsps)) < 0)V 	      return(y);a 	    if (z < 10) {' 		printf("Sorry, 10 is the minimum\n");S
 		return(-9);t 	    } 	    if (z > MAXSP) z = MAXSP; 	    spsiz = z;			/* Set it */' 	    y = adjpkl(spsiz,wslotr,bigsbsiz);  	    if (y != spsiz &&
 #ifndef NOSPLS
 		cmdlvl == 0r #elsei 		tlevel < 0 #endif /* NOSPL */ 		)s 	      if (msgflg)= 		printf("Adjusting packet size to %d for %d window slots\n",s 		     y,wslotr);}F 	    spsiz = spmax = spsizr = y;	/* Set it and flag that it was set */7 	    spsizf = 1;			/* to allow overriding Send-Init. *// 	}
 	if (pflag && 
 #ifndef NOSPLa 	    cmdlvl == 0 #else  	    tlevel < 0n #endif /* NOSPL */ 	    ) { 	    if (z > 94 && msgflg) {1 		printf("Extended-length packets requested.\n"); $ 		if (bctr < 2 && z > 200) printf("\3 Remember to SET BLOCK 2 or 3 for long packets.\n");1 	    }' 	    if (speed <= 0L) speed = ttgspd();e #ifdef COMMENT /*   Kermit does this now itself. */, 	    if (speed <= 0L && z > 200 && msgflg) { 		printf("\uJ Make sure your timeout interval is long enough for %d-byte packets.\n",z); 	    } #endif /* COMMENT */ 	} 	return(success = y);x         case XYMARK:A 	y = cmnum("Code for packet-start character","1",10,&x,xxstring);, #ifdef UNIXr /*8   Printable start-of-packet works for UNIX and VMS only! */- 	if ((y = setnum(&z,x,y,126)) < 0) return(y);X #else	
 #ifdef VMS- 	if ((y = setnum(&z,x,y,126)) < 0) return(y);r #elsei
 #ifdef OS2- 	if ((y = setnum(&z,x,y,126)) < 0) return(y);r #else(( 	if ((y = setcc(&z,x,y)) < 0) return(y); #endif /* OS2 */ #endif /* VMS */ #endif /* UNIX */'$ 	if (xx == XYRECV) stchr = z; else { 	    mystch = z; 	} 	return(success = y);   "       case XYNPAD:			/* PADDING */G 	y = cmnum("How many padding characters for inbound packets","0",10,&x,	 		  xxstring);, 	if ((y = setnum(&z,x,y,94)) < 0) return(y);- 	if (xx == XYRECV) mypadn = z; else npad = z;t 	return(success = y);f  )(       case XYPADC:			/* PAD-CHARACTER */G 	y = cmnum("Decimal ASCII code for packet padding character","0",10,&x,  		  xxstring);( 	if ((y = setcc(&z,x,y)) < 0) return(y);. 	if (xx == XYRECV) mypadc = z; else padch = z; 	return(success = y);   a"       case XYTIMO:			/* TIMEOUT */ 	if (xx == XYRECV) {+ 	    char buf[16];		/* Construct default */i 	    sprintf(buf,"%d",URTIME);= 	    y = cmnum("Packet timeout interval",buf,10,&x,xxstring);)0 	    if ((y = setnum(&z,x,y,94)) < 0) return(y);  4 	    if (rmsflg) {		/* REMOTE SET RECEIVE TIMEOUT *// 		tp = tmpbuf;		/*   Tell Kermit server what */c7 		sprintf(tp,"%d",z);	/*   timeout to ask me to use. */L& 		sstate = setgen('S', "402", tp, ""); 		return((int) sstate); ) 	    } else {			/* SET RECEIVE TIMEOUT */"5 		pkttim = z;		/*   Value to put in my negotiation */r0 	    }				/*   packet for other Kermit to use */  " 	} else {			/* SET SEND TIMEOUT */< 	    y = cmnum("Packet timeout interval","",10,&x,xxstring);4 	    if (y == -3) {		/* They cancelled a previous */1 		x = DMYTIM;		/* SET SEND command, so restore */e 		y = 0;			/* the default */2 		timef = 0;		/* and turn off the override flag */( 	    } else {			/* They gave a number */0 		timef = 1;		/* so turn on the override flag */ 	    }% 	    if ((y = setnum(&z,x,y,94)) < 0)E 	      return(y); < 	    timint = rtimo = z;		/* Override value for me to use */ 	} 	return(success = 1);   %       case XYFPATH:			/* PATHNAMES */ : 	if ((y = cmkey(onoff,2,"","on",xxstring)) < 0) return(y);" 	if ((x = cmcfm()) < 0) return(x);/ 	if (xx == XYRECV)		/* SET RECEIVE PATHNAMES */n6 	  fnrpath = 1 - y;		/* OFF (with their heads!), ON */! 	else				/* SET SEND PATHNAMES */ " 	  fnspath = 1 - y;		/* OFF, ON */2 	return(success = 1);		/* Note: 0 = ON, 1 = OFF */D 	/* In other words, ON = leave pathnames ON, OFF = take them off. */  1       case XYPAUS:			/* SET SEND/RECEIVE PAUSE */cG 	y = cmnum("Milliseconds to pause between packets","0",10,&x,xxstring); $ 	if ((y = setnum(&z,x,y,15000)) < 0)
 	  return(y); 
 	pktpaus = z;  	return(success = 1);r         default: 	return(-2);*     }					/* End of SET SEND/RECEIVE... */ }    #ifndef NOXMIT int  setxmit() {L@     if ((y = cmkey(xmitab,nxmit,"","",xxstring)) < 0) return(y);     switch (y) {       case XMITE:			/* EOF */ 1 	y = cmtxt("Characters to send at end of file,\n\ =  Use backslash codes for control characters","",&s,xxstring);  	if (y < 0) return(y); 	if ((int)strlen(s) > XMBUFL) { 9 	    printf("?Too many characters, %d maximum\n",XMBUFL);K 	    return(-2); 	} 	strcpy(xmitbuf,s);O 	return(success = 1);r         case XMITF:			/* Fill */B 	y = cmnum("Numeric code for blank-line fill character","0",10,&x, 		  xxstring);- 	if ((y = setnum(&z,x,y,127)) < 0) return(y);m 	xmitf = z;" 	return(success = 1);n"       case XMITL:			/* Linefeed */         return(seton(&xmitl));'       case XMITS:			/* Locking-Shift */-         return(seton(&xmits));        case XMITP:			/* Prompt */B 	y = cmnum("Numeric code for host's prompt character, 0 for none", 		  "10",10,&x,xxstring);n- 	if ((y = setnum(&z,x,y,127)) < 0) return(y);) 	xmitp = z;t 	return(success = 1);        case XMITX:			/* Echo */         return(seton(&xmitx));       case XMITW:			/* Pause */kH 	y = cmnum("Number of milliseconds to pause between binary characters\n\7 or text lines during transmission","0",10,&x,xxstring);r. 	if ((y = setnum(&z,x,y,1000)) < 0) return(y); 	xmitw = z;E 	return(success = 1);(       default: 	return(-2);     }  }e #endif /* NOXMIT */M L* /*  D O R M T  --  Do a remote command  */  "
 VOID rmsg() {t     if (pflag)
       printf(D #ifdef CK_NEED_SIGJ        " Type your escape character, %s, followed by X or E to cancel.\n",        dbchr(escape) #else +        " Press the X or E key to cancel.\n"o #endif /* CK_NEED_SIG */       ); }n   int + dormt(xx) int xx; {			/* REMOTE commands */{     int x, y, retcode;     char *s, sbuf[50], *s2;   o     if (xx < 0) return(xx);	  )     if (xx == XZSET) {			/* REMOTE SET */)3 	if ((y = cmkey(rmstab,nrms,"","",xxstring)) < 0) {  	    if (y == -3) {a' 		printf("?Parameter name required\n"); 
 		return(-9);E 	    } else return(y); 	} 	return(doprm(y,1));     }&  #     switch (xx) {			/* Others... */s    case XZCWD:				/* CWD */K     if ((x = cmtxt("Remote directory name","",&s,xxstring)) < 0) return(x);)     debug(F111,"XZCWD: ",s,x);     *sbuf = NUL;     s2 = sbuf;  E /* The following is commented out, because there is practically no */dL /* computer in the world that requires a password for directory changing. */A /* (The DEC-20 was the only one, and they're mostly all gone.) */  #ifdef DIRPWDPR	5     if (*s != NUL) {			/* If directory name given, */	) 					/* get password on separate line. */t3         if (tlevel > -1) {		/* From take file... */   	. 	    if (fgets(sbuf,50,tfile[tlevel]) == NULL): 	    	fatal("take file ends prematurely in 'remote cwd'");- 	    debug(F110," pswd from take file",s2,0);,  	    for (x = (int)strlen(sbuf);6 	     	 x > 0 && (sbuf[x-1] == NL || sbuf[x-1] == CR); 		 x--)  		sbuf[x-1] = '\0';t  ()         } else {			/* From terminal... */E  E2 	    printf(" Password: "); 		/* get a password */
 #ifdef OS2) 	    while (((x = isatty(0) ? coninc(0) :0? 		     getchar()) != NL) && (x != CR)) {     /* with no echo */  #else)F 	    while (((x = getchar()) != NL) && (x != CR)) { /* with no echo */ #endif /* OS2 */ 	    	if ((x &= 0177) == '?') {o@ 	    	    printf("? Password of remote directory\n Password: "); 		    s2 = sbuf; 		    *sbuf = NUL; 	    	}g: 	    	else if (x == ESC)	/* Mini command line editor... */ 	    	    putchar(BEL);s  		else if (x == BS || x == 0177) 		    s2--;F# 		else if (x == 025) {	/* Ctrl-U */m 		    s2 = sbuf; 		    *sbuf = NUL; 		} 
 	    	else 		    *s2++ = x;
             }= 	    *s2 = NUL;t 	    putchar('\n'); 	         }c         s2 = sbuf;     } else s2 = "";i #endif /* DIRPWDPR */t  !     debug(F110," password",s2,0); !     sstate = setgen('C',s,s2,"");p     retcode = 0;
     break;   case XZDEL:				/* Delete */fM     if ((x = cmtxt("Name of remote file(s) to delete","",&s,xxstring)) < 0) {  	if (x == -3) { 2 	    printf("?Name of remote file(s) required\n"); 	    return(-9); 	} else return(x);     }t@     if (local) ttflui();		/* If local, flush tty input buffer */%     retcode = sstate = rfilop(s,'E'); 
     break;    case XZDIR:				/* Directory */B     if ((x = cmtxt("Remote directory or file specification","",&s, 		   xxstring)) < 0)     	return(x);a@     if (local) ttflui();		/* If local, flush tty input buffer */     rmsg();;+     retcode = sstate = setgen('D',s,"","");0
     break;    case XZHLP:				/* Help */v%     if ((x = cmcfm()) < 0) return(x);r"     sstate = setgen('H',"","","");     retcode = 0;     break;     #ifndef NOPUSH case XZHOS:				/* Host */ H     if ((x = cmtxt("Command for remote system","",&cmarg,xxstring)) < 0)       return(x);"     if ((int)strlen(cmarg) < 1)  { 	if (x == -3) {a/ 	    printf("?Remote host command required\n");  	    return(-9); 	} else return(x);     }t     rmsg();      retcode = sstate = 'c';;     break; = #endif /* NOPUSH */T   #ifndef NOFRILLS case XZKER:(H     if ((x = cmtxt("Command for remote Kermit","",&cmarg,xxstring)) < 0)       return(x);"     if ((int)strlen(cmarg) < 1)  { 	if (x == -3) {b1 	    printf("?Remote Kermit command required\n");r 	    return(-9); 	} else return(x);     }      retcode = sstate = 'k';      rmsg();m     break; i   case XZLGI: {				/* Login */     char *p1, *p2, *p3;e=     if ((x = cmfld("User ID","",&s,xxstring)) < 0) return(x);f4     if ((p1 = malloc((int)strlen(s) + 1)) == NULL) {$ 	printf("Internal error: malloc\n"); 	return(-2);     } else strcpy(p1,s);>     if ((x = cmfld("Password","",&s,xxstring)) < 0) return(x);4     if ((p2 = malloc((int)strlen(s) + 1)) == NULL) {$ 	printf("Internal error: malloc\n"); 	return(-2);     } else strcpy(p2,s);3     if ((x = cmtxt("Account or carriage return","",u" 		   &s,xxstring)) < 0 && x != -3) 	return(x); 4     if ((p3 = malloc((int)strlen(s) + 1)) == NULL) {$ 	printf("Internal error: malloc\n"); 	return(-2);     } else strcpy(p3,s);"     sstate = setgen('I',p1,p2,p3);     if (p3) free(p3);o     if (p2) free(p2);e     if (p1) free(p1);      retcode = 0;     break; A })   case XZLGO:				/* Logout */ %     if ((x = cmcfm()) < 0) return(x);r"     sstate = setgen('I',"","","");     retcode = 0;     break; t   case XZPRI:				/* Print */?     if (!atdiso || !atcapr) {		/* Disposition attribute off? */ + 	printf("?Disposition Attribute is Off\n");e 	return(-2);     }s     cmarg = "";e     cmarg2 = "";G     if ((x = cmifi("Local file(s) to print on remote printer","",&s,&y,  		   xxstring)) < 0) { 	if (x == -3) {61 	    printf("?Name of local file(s) required\n");r 	    return(-9); 	} 	return(x);e     } 8     strcpy(line,s);			/* Make a safe copy of filename */3     *optbuf = NUL;			/* Wipe out any old options */ K     if ((x = cmtxt("Options for remote print command","",&s,xxstring)) < 0)m       return(x);9     strcpy(optbuf,s);			/* Make a safe copy of options */rA     if ((int)strlen(optbuf) > 94) {	/* Make sure this is legal *//% 	printf("?Option string too long\n");* 	return(-9);     }o4     nfils = -1;				/* Expand file list internally */-     cmarg = line;			/* Point to file list. */I7     rprintf = 1;			/* REMOTE PRINT modifier for SEND */s1     sstate = 's';			/* Set start state to SEND */      if (local) displa = 1;     retcode = 0;
     break; #endif /* NOFRILLS */  	) case XZSPA:				/* Space */L     if ((x = cmtxt("Confirm, or remote directory name","",&s,xxstring)) < 0)       return(x);+     retcode = sstate = setgen('U',s,"",""); 
     break;      #ifndef NOFRILLS case XZTYP:				/* Type */	D     if ((x = cmtxt("Remote file specification","",&s,xxstring)) < 0)       return(x);     if ((int)strlen(s) < 1) {t' 	printf("?Remote filename required\n");          return(-9);	     }i     rmsg();f%     retcode = sstate = rfilop(s,'T');)
     break; #endif /* NOFRILLS */P    #ifndef NOFRILLS case XZWHO:mO     if ((x = cmtxt("Remote user name, or carriage return","",&s,xxstring)) < 0))     	return(x); +     retcode = sstate = setgen('W',s,"","");c
     break; #endif /* NOFRILLS */r  u case XZPWD:				/* PWD */%     if ((x = cmcfm()) < 0) return(x); "     sstate = setgen('A',"","","");     retcode = 0;     break; b     
 #ifndef NOSPLa case XZQUE: {				/* Query */     char buf[2];$     extern char querybuf[], * qbufp;     extern int qbufn;t7     if ((y = cmkey(vartyp,nvartyp,"","",xxstring)) < 0)        return(y);I     if ((x = cmtxt("Remote variable name","",&s,NULL)) < 0) /* No eval */t       return(x);'     query = 1;				/* QUERY is active */>>     qbufp = querybuf;			/* Initialize query response buffer */     qbufn = 0;     querybuf[0] = NUL;     buf[0] = (char) (y & 127);     buf[1] = NUL;e5     retcode = sstate = setgen('V',"Q",(char *)buf,s);X
     break; }    case XZASG: {				/* Assign */t     char buf[VNAML];I     if ((y = cmfld("Remote variable name","",&s,NULL)) < 0) /* No eval */d       return(y);     strcpy(buf,s);4     if ((x = cmtxt("Assignment for remote variable",2 		   "",&s,xxstring)) < 0) /* Evaluate this one */       return(x); #ifdef COMMENT /*H   Server commands can't be long packets.  In principle there's no reasonG   why they shouldn't be, except that we don't know at this point if the(H   server is capable of accepting long packets because we haven't startedJ   the protocol yet.  In practice, allowing a long packet here breaks a lotG   of assumptions, causes buffer overruns and crashes, etc.  To be fixeda   later. */B     if ((int)strlen(s) > 85) {		/* Allow for encoding expansion */; 	printf("?Sorry, value is too long - 85 characters max\n");" 	return(-9);     }r #endif /* COMMENT */5     retcode = sstate = setgen('V',"S",(char *)buf,s);	
     break; }L #endif /* NOSPL */   default:)         if ((x = cmcfm()) < 0) return(x); 1         printf("?Not implemented - %s\n",cmdbuf);*         return(-2);      }d@     if (local) ttflui();		/* If local, flush tty input buffer */     return(retcode); }       . /*  R F I L O P  --  Remote File Operation  */  y CHAR #ifdef CK_ANSICb rfilop(char * s, char t) #else  rfilop(s,t) char *s, t;  #endif /* CK_ANSIC */X /* rfilop */ {     if (*s == NUL) {* 	printf("?File specification required\n"); 	return((CHAR) 0);     }f     debug(F111,"rfilop",s,t);u     return(setgen(t,s,"","")); }e  
 #ifdef ANYX25} int 
 setx25() {E     if ((y = cmkey(x25tab,nx25,"X.25 call options","",xxstring)) < 0)        return(y);     switch (y) {       case XYUDAT:; 	if ((z = cmkey(onoff,2,"X.25 call user data","",xxstring))y 	    < 0) return(z); 	if (z == 0) {& 	    if ((z = cmcfm()) < 0) return(z);9 	    cudata = 0;             /* disable call user data */X 	    return (success = 1); 	}B 	if ((x = cmtxt("X.25 call user data string","",&s,xxstring)) < 0)
 	  return(x);S 	if ((int)strlen(s) == 0) {  	    return (-3); ) 	} else if ((int)strlen(s) > MAXCUDATA) {a= 	    printf("?The length must be > 0 and <= %d\n",MAXCUDATA);a 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	strcpy(udata,s); 2 	cudata = 1;			/* X.25 call user data specified */ 	return (success = 1);       case XYCLOS:C 	if ((z = cmkey(onoff,2,"X.25 closed user group call","",xxstring))C 	    < 0) return(z); 	if (z == 0) {& 	    if ((z = cmcfm()) < 0) return(z);2 	    closgr = -1;		/* disable closed user group */ 	    return (success = 1); 	}? 	if ((y = cmnum("0 <= cug index >= 99","",10,&x,xxstring)) < 0)e
 	  return(y);r 	if (x < 0 || x > 99) {(7 	    printf("?The choices are 0 <= cug index >= 99\n");m 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y);/ 	closgr = x;			/* closed user group selected */t 	return (success = 1);         case XYREVC:D 	if((z = cmkey(onoff,2,"X.25 reverse charge call","",xxstring)) < 0)
 	  return(z); " 	if ((x = cmcfm()) < 0) return(x);
 	revcall = z;i 	return (success = 1);     }e }e   inte setpadp() {dN     if ((y = cmkey(padx3tab,npadx3,"PAD X.3 parameter name","",xxstring)) < 0)       return(y);
     x = y;     switch (x) {       case PAD_BREAK_CHARACTER:pD 	if ((y = cmnum("PAD break character value","",10,&z,xxstring)) < 0)
 	  return(y);&" 	if ((y = cmcfm()) < 0) return(y); 	break;        case PAD_ESCAPE:@ 	if ((y = cmnum("PAD escape","",10,&z,xxstring)) < 0) return(y); 	if (z != 0 && z != 1) {) 	    printf("?The choices are 0 or 1\n");k 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;        case PAD_ECHO:?  	if ((y = cmnum("PAD echo","",10,&z,xxstring)) < 0) return(y);r 	if (z != 0 && z != 1) {) 	    printf("?The choices are 0 or 1\n");w 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;i!       case PAD_DATA_FORWARD_CHAR: A  	if ((y = cmnum("PAD data forward char","",10,&z,xxstring)) < 0)P
 	  return(y);  	if (z != 0 && z != 2) {) 	    printf("?The choices are 0 or 2\n");  	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;n$       case PAD_DATA_FORWARD_TIMEOUT:D  	if ((y = cmnum("PAD data forward timeout","",10,&z,xxstring)) < 0) 	    return(y);L 	if (z < 0 || z > 255) {; 	    printf("?The choices are 0 or 1 <= timeout <= 255\n");s 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;m#       case PAD_FLOW_CONTROL_BY_PAD:y@  	if ((y = cmnum("PAD pad flow control","",10,&z,xxstring)) < 0)
 	  return(y);  	if (z != 0 && z != 1) {) 	    printf("?The choices are 0 or 1\n");, 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break; &       case PAD_SUPPRESSION_OF_SIGNALS:B  	if ((y = cmnum("PAD service","",10,&z,xxstring)) < 0) return(y); 	if (z != 0 && z != 1) {) 	    printf("?The choices are 0 or 1\n");n 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;<         case PAD_BREAK_ACTION:G  	if ((y = cmnum("PAD break action","",10,&z,xxstring)) < 0) return(y);eA 	if (z != 0 && z != 1 && z != 2 && z != 5 && z != 8 && z != 21) {A6 	    printf("?The choices are 0, 1, 2, 5, 8 or 21\n"); 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;n  #       case PAD_SUPPRESSION_OF_DATA: H  	if ((y = cmnum("PAD data delivery","",10,&z,xxstring)) < 0) return(y); 	if (z != 0 && z != 1) {) 	    printf("?The choices are 0 or 1\n");r 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;e          case PAD_PADDING_AFTER_CR:@  	if ((y = cmnum("PAD crpad","",10,&z,xxstring)) < 0) return(y); 	if (z < 0 || z > 7) {7 	    printf("?The choices are 0 or 1 <= crpad <= 7\n");	 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;c         case PAD_LINE_FOLDING:C  	if ((y = cmnum("PAD linefold","",10,&z,xxstring)) < 0) return(y);; 	if (z < 0 || z > 255) {< 	    printf("?The choices are 0 or 1 <= linefold <= 255\n"); 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;          case PAD_LINE_SPEED:C  	if ((y = cmnum("PAD baudrate","",10,&z,xxstring)) < 0) return(y);R 	if (z < 0 || z > 18) {t6 	    printf("?The choices are 0 <= baudrate <= 18\n"); 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;N  $       case PAD_FLOW_CONTROL_BY_USER:E  	if ((y = cmnum("PAD terminal flow control","",10,&z,xxstring)) < 0)l 	    return(y);  	if (z != 0 && z != 1) {) 	    printf("?The choices are 0 or 1\n");  	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;          case PAD_LF_AFTER_CR:e@  	if ((y = cmnum("PAD crpad","",10,&z,xxstring)) < 0) return(y);  	if (z < 0 || z == 3 || z > 7) {8 	    printf("?The choices are 0, 1, 2, 4, 5, 6 or 7\n"); 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;e          case PAD_PADDING_AFTER_LF:@  	if ((y = cmnum("PAD lfpad","",10,&z,xxstring)) < 0) return(y); 	if (z < 0 || z > 7) {7 	    printf("?The choices are 0 or 1 <= lfpad <= 7\n");a 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;D         case PAD_EDITING:=G  	if ((y = cmnum("PAD edit control","",10,&z,xxstring)) < 0) return(y);/ 	if (z != 0 && z != 1) {) 	    printf("?The choices are 0 or 1\n");/ 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;"          case PAD_CHAR_DELETE_CHAR:@  	if ((y = cmnum("PAD char delete char","",10,&z,xxstring)) < 0) 	    return(y);t 	if (z < 0 || z > 127) {> 	    printf("?The choices are 0 or 1 <= chardelete <= 127\n"); 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;   "       case PAD_BUFFER_DELETE_CHAR:B  	if ((y = cmnum("PAD buffer delete char","",10,&z,xxstring)) < 0) 	    return(y);" 	if (z < 0 || z > 127) {? 	    printf("?The choices are 0 or 1 <= bufferdelte <= 127\n");x 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;   #       case PAD_BUFFER_DISPLAY_CHAR: A  	if ((y = cmnum("PAD display line char","",10,&z,xxstring)) < 0)r 	    return(y);) 	if (z < 0 || z > 127) {? 	    printf("?The choices are 0 or 1 <= displayline <= 127\n");r 	    return(-2); 	}" 	if ((y = cmcfm()) < 0) return(y); 	break;t     }m     padparms[x] = z;     return(success = 1); }X #endif /* ANYX25 */    int  setat(rmsflg) int rmsflg; {      int xx;	K     if ((y = cmkey(attrtab,natr,"File Attribute packets","",xxstring)) < 0)*       return(y);    <     if (y == AT_XALL) {			/* ATTRIBUTES ALL ON or ALL OFF */% 	if ((z = seton(&xx)) < 0) return(z);m 	if (rmsflg) {. 	    printf("Sorry, command not available\n"); 	    return(-9);	 	} else {E$ 	    atenci = xx;		/* Encoding in */% 	    atenco = xx;		/* Encoding out */=  	    atdati = xx;		/* Date in */! 	    atdato = xx;		/* Date out */ + 	    atdisi = xx;		/* Disposition in/out */x 	    atdiso = xx; 3 	    atleni = xx;		/* Length in/out (both kinds) */  	    atleno = xx;)) 	    atblki = xx;		/* Blocksize in/out */e 	    atblko = xx;*) 	    attypi = xx;		/* File type in/out */a 	    attypo = xx;s) 	    atsidi = xx;		/* System ID in/out */d 	    atsido = xx; 7 	    atsysi = xx;		/* System-dependent params in/out */o 	    atsyso = xx;  #ifdef STRATUS& 	    atfrmi = xx;		/* Format in/out */ 	    atfrmo = xx;f* 	    atcrei = xx;		/* Creator id in/out */ 	    atcreo = xx;	' 	    atacti = xx;		/* Account in/out */c 	    atacto = xx;s #endif /* STRATUS */ 	} 	return(z);uI     } else if (y == AT_ALLY || y == AT_ALLN) { /* ATTRIBUTES ON or OFF */t" 	if ((x = cmcfm()) < 0) return(x);! 	atcapr = (y == AT_ALLY) ? 1 : 0;m 	if (rmsflg) {9 	    sstate = setgen('S', "132", atcapr ? "1" : "0", "");r 	    return((int) sstate); 	} else return(success = 1);     } K     /* Otherwise, it's an individual attribute that wants turning off/on */x  ;     if ((z = cmkey(onoff,2,"","",xxstring)) < 0) return(z); %     if ((x = cmcfm()) < 0) return(x);f  ) /* There are better ways to do this... */rH /* The real problem is that we're not separating the in and out cases */K /* and so we have to arbitrarily pick the "in" case, i.e tell the remote */ H /* server to ignore incoming attributes of the specified type, rather */K /* than telling it not to send them.  The protocol does not (yet) define */-. /* codes for "in-and-out-at-the-same-time". */       switch(y) {e       case AT_DISP:	 	if (rmsflg) {4 	    sstate = setgen('S', "142", z ? "1" : "0", ""); 	    return((int) sstate); 	} 	atdisi = atdiso = z; break;       case AT_ENCO:( 	if (rmsflg) {4 	    sstate = setgen('S', "141", z ? "1" : "0", ""); 	    return((int) sstate); 	} 	atenci = atenco = z; break;       case AT_DATE:* 	if (rmsflg) {4 	    sstate = setgen('S', "135", z ? "1" : "0", ""); 	    return((int) sstate); 	} 	atdati = atdato = z; break;       case AT_LENB:        case AT_LENK:( 	if (rmsflg) {4 	    sstate = setgen('S', "133", z ? "1" : "0", ""); 	    return((int) sstate); 	} 	atleni = atleno = z; break;       case AT_BLKS:w 	if (rmsflg) {4 	    sstate = setgen('S', "139", z ? "1" : "0", ""); 	    return((int) sstate); 	} 	atblki = atblko = z; break;       case AT_FTYP:  	if (rmsflg) {4 	    sstate = setgen('S', "134", z ? "1" : "0", ""); 	    return((int) sstate); 	} 	attypi = attypo = z; break; #ifdef STRATUS       case AT_CREA:  	if (rmsflg) {4 	    sstate = setgen('S', "136", z ? "1" : "0", ""); 	    return((int) sstate); 	} 	atcrei = atcreo = z; break;       case AT_ACCT:  	if (rmsflg) {4 	    sstate = setgen('S', "137", z ? "1" : "0", ""); 	    return((int) sstate); 	} 	atacti = atacto = z; break; #endif /* STRATUS */       case AT_SYSI:  	if (rmsflg) {4 	    sstate = setgen('S', "145", z ? "1" : "0", ""); 	    return((int) sstate); 	} 	atsidi = atsido = z; break; #ifdef STRATUS       case AT_RECF:t 	if (rmsflg) {4 	    sstate = setgen('S', "146", z ? "1" : "0", ""); 	    return((int) sstate); 	}#         atfrmi = atfrmo = z; break;  #endif /* STRATUS */       case AT_SYSP:  	if (rmsflg) {4 	    sstate = setgen('S', "147", z ? "1" : "0", ""); 	    return((int) sstate); 	} 	atsysi = atsyso = z; break;       default: 	printf("?Not available\n"); 	return(-2);     }f     return(1); })  
 #ifndef NOSPL  inte
 setinp() {?     if ((y = cmkey(inptab,ninp,"","",xxstring)) < 0) return(y);a     switch (y) {4       case IN_DEF:			/* SET INPUT DEFAULT-TIMEOUT */0 	z = cmnum("Positive number","",10,&x,xxstring); 	return(setnum(&indef,x,z,94));i3       case IN_TIM:			/* SET INPUT TIMEOUT-ACTION */u9 	if ((z = cmkey(intimt,2,"","",xxstring)) < 0) return(z); " 	if ((x = cmcfm()) < 0) return(x); 	intime[cmdlvl] = z; 	return(success = 1);i)       case IN_CAS:			/* SET INPUT CASE */c9 	if ((z = cmkey(incast,2,"","",xxstring)) < 0) return(z); " 	if ((x = cmcfm()) < 0) return(x); 	inpcas[cmdlvl] = z; 	return(success = 1);t)       case IN_ECH:			/* SET INPUT ECHO */  	return(seton(&inecho));,       case IN_SIL:			/* SET INPUT SILENCE */? 	z = cmnum("Seconds of inactivity before INPUT fails","",10,&x,  		  xxstring);# 	return(setnum(&insilence,x,z,-1));,     }r     return(0); }) #endif /* NOSPL */   /*?   setlin -- parse name of and then open a communication device."   Call with:D     xx == XXLINE for a serial (tty) line, XXHOST for a network host,F     zz == 0 means if user doesn't give a device name, continue current'             active connection (if any);;D     zz != 0 means if user doesn't give a device name, then close theL             current connection and restore the default communication device. */ int  setlin(xx, zz) int xx, zz; {3     if (xx == XYHOST) {			/* SET HOST <hostname> */t #ifndef NETCONNl7         printf("?Network connections not supported\n");  	return(-9); #else  	if (2 	    (nettype != NET_DEC) && 	    (nettype != NET_SX25) &&r 	    (nettype != NET_VX25) &&  #ifdef NPIPE 	    (nettype != NET_PIPE) &&( #endif /* NPIPE */ #ifdef CK_NETBIOS; 	    (nettype != NET_BIOS) &&t #endif /* CK_NETBIOS */n 	    (nettype != NET_TCPB)) {r- 	    printf("?Network type not supported\n");( 	    return(-9); 	} #ifdef CK_NETBIOSt 	if ( nettype == NET_BIOS) { 	    if ((x = cmtxt( zz ? H     "server name, *,\n or carriage return to close an open connection" :H     "server name, *,\n or carriage return to resume an open connection", 			   "",&s,xxstring)) < 0)9 	      return(x);e 	} else  #endif /* CK_NETBIOS */M #ifdef NPIPE 	if (nettype == NET_PIPE ) { 	    if ((x = cmtxt( zz ? H     "server name, *,\n or carriage return to close an open connection" :H     "server name, *,\n or carriage return to resume an open connection", 			   "",&s,xxstring)) < 0)( 	      return(x);  	    if ( *s != '\0' ) {( 		if ( strcmp(s,"*")) {	/* If remote, */7 		    strcpy(line,"\\\\"); /* begin with server name */x 		    strcat(line,s);l
 		} else { 		    line[0]='\0' ; 		}i6 		strcat(line,"\\pipe\\"); /* Make this a pipe name */9 		strcat(line,pipename);   /* Add the name of the pipe */E 		s = line;f 	    } 	} else  #endif /* NPIPE */; 	  if (nettype != NET_TCPB) {	/* Not a TCP/IP connection */p! 					/* Just get a text string */, 	    if ((x = cmtxt( zz ? K     "Network host name,\n or carriage return to close an open connection" :"K     "Network host name,\n or carriage return to resume an open connection",f 			   "",&s,xxstring)) < 0)c 	      return(x);s& 	} else {			/* TCP/IP connection... */  1 	    /* Parse for host and service separately. */u   	    if ((x = cmfld( zz ?)O    "IP host name or number,\n or carriage return to close an open connection" :dO    "IP host name or number,\n or carriage return to resume an open connection",e 			   "",&s,xxstring)) < 0) {,! 		if (x != -3)		/* Parse error */( 		  return(x);		/* return it */e 		else if (!network) {1 		    printf("?Host name or address required\n");  		    return(-9);=* 		} else if (!zz)		/* No hostname given */( 		  return(1);		/* and none required, */, 	    }				/* continue current connection. */2 	    if (*s) {			/* If they gave a host name... */$ 		strcpy(line,s);		/* make a copy */  		/* Check for "host:service" */- 		for ( ; (*s != '\0') && (*s != ':'); s++) ;   3 		/* If no service given, let them type one now. */<   		if (!*s) { 		    if ((x = cmfld( G     "TCP service name or number,\n or carriage return for telnet (23)",l) 				   "23",&s,xxstring)) < 0 && x != -3); 		      return(x);. 		    if (*s) {		/* If they gave a service, */9 			strcat(line,":"); /* concatenate it to the hostname */,6 			strcat(line,s);	/* separated by a colon, because */. 		    }			/* this is how ttopen() wants it. */ 		}a= 		if ((x = cmcfm()) < 0) return(x); /* Confirm the command */  		s = line;s 	    } 	}   	/* New connection wanted. */    	if (!hupok(1)), 	  return(success = 0);l  . 	ttflui();			/* Clear away buffered up junk */0 	ttclos(0);			/* Close old connection, if any */1 	if (oldplex > -1)		/* Restore duplex setting. */b 	  duplex = oldplex;' 	if (*s) {			/* They gave a hostname */ 3 	    x = 1;			/* Network connection always local */s4 	    mdmsav = mdmtyp;		/* Remember old modem type */7 	    mdmtyp = -nettype;		/* Special code for network */fC 	    if (nettype == NET_TCPB) {	/* For TCP/IP telnet connections */i2 		oldplex = duplex;	/* Remember previous duplex */, 		duplex = 0;		/* Set full duplex and let */A 		                        /* negotiations change if necessary. */  	    }+ 	} else {			/* They just said "set host" */  	    if (network && msgflg)P' 	      printf(" Closing connection\n");), 	    s = dftty;			/* So go back to normal */. 	    x = dfloc;			/* default tty, location, */4 	    network = 0;		/* No more network connection. */ 	    if (oldplex > -1); 	      duplex = oldplex;		/* Restore old duplex setting. */e: 	    if (mdmtyp < 0) {		/* Switching from net to async? */5 		if (mdmsav > -1)	/* Restore modem type from last */K5 		  mdmtyp = mdmsav;	/* SET MODEM command, if any. */t 		else 		  mdmtyp = 0;q 	    } 	} #endif /* NETCONN */     }   6 /* Serial tty device, possibly modem, connection... */  (     if (xx == XYLINE) {			/* SET LINE */ #ifdef OS2				/* or SET PORT */. /*   User can type:!     COM1..COM8 = Regular COM port D     1..8       = Synonym for COM1..COM8, is translated to COM1..COM83     _n         = (n is a number) = open file handle E     string     = any text string = name of some other kind of device, +                  taken literally, as given.r */D 	if ((x = cmtxt("Communication device name",dftty,&s,xxstring)) < 0)
 	  return(x); " 	debug(F110,"OS2 SET PORT s",s,0);C 	y = lookup(os2devtab,s,nos2dev,&x); /* Look up in keyword table */A# 	debug(F101,"OS2 SET PORT x","",x); # 	debug(F101,"OS2 SET PORT y","",y); C 	if ((y > -1) && (x >= 0 && x < 8)) { /* User typed a digit 1..8 */); 	    s = os2devtab[x+8].kwd;	/* Substitite its real name */r- 	    debug(F110,"OS2 SET PORT subst s",s,""); 4 	} else if (*s == '_') {		/* User used "_" prefix */ 	    s++;			/* Remove it */iH 	    debug(F110,"OS2 SET PORT _subst s",s,0); /* Rest must be numeric */ 	    if (!rdigits(s)) {u. 		printf("?Invalid format for file handle\n");
 		return(-9);  	    } 	}) 	debug(F110,"OS2 SET PORT final s",s,"");  #else<D 	if ((x = cmtxt("Communication device name",dftty,&s,xxstring)) < 0)
 	  return(x);r #endif /* OS2 */   	if (!hupok(1))e 	  return(success = 0);/  8 	if (local) ttflui();		/* Clear away buffered up junk */3 	ttclos(0);			/* Close old line, if any was open */r* 	if (*s) {			/* They gave a device name *// 	    x = -1;			/* Let ttopen decide about it */a+ 	} else {			/* They just said "set line" */ 0 	    s = dftty;			/* so go back to normal tty */! 	    x = dfloc;			/* and mode. */x 	} #ifdef NETCONN6 	if (mdmtyp < 0) {		/* Switching from net to async? */9 	    if (mdmsav > -1)		/* Restore modem type from last */v9 	      mdmtyp = mdmsav;		/* SET MODEM command, if any. */m	 	    else  	      mdmtyp = 0; 	    mdmsav = -1;C 	}< 	if (oldplex > -1) {		/* Restore previous duplex setting. */ 	    duplex = oldplex; 	    oldplex = -1; 	}   	if (network) {1
 #ifdef TNCODEt@ /* This should be unnecessary, since ttclos() did it already? */ /* But it can't hurt ... */n4 	    tn_init = 0;		/* TELNET not init'd any more. */ #endif /* TNCODE */{) 	    network = 0;		/* No more network. */w 	} #endif /* NETCONN */     }  #ifdef COMMENT /*I   The following is removed, not so much because it's a horrible hack, butaJ   because it only works if the SET FLOW command was given *before* the SETJ   LINE command, whereas normally these commands can be given in any order. */ #ifdef NEXT) /*L   This is a horrible hack, but it's nice for users.  On the NeXT, you selectL   RTS/CTS hardware flow control not by system calls, but by referring to theG   device with a different name.  If the user has asked for RTS/CTS flow5I   control on a NeXT, but used the non-RTS/CTS device name in the SET LINE M   command, we make the appropriate substitute here.  I wonder how much bigger"7   this section of code will grow as the years go by... ! */B     if ((flow == FLO_RTSC) &&		/* RTS/CTS flow control selected */0 	strcmp(s,dftty)) {		/*  ...on external port? */7 	y = strlen(s);			/* Yes, insert "f" as next-to-last */A< 	if (s[y-2] != 'f') {		/* character in device name if not */, 	    strcpy(line,s);		/* already there... */> 	    line[y] = line[y-1];	/* So /dev/cua => /dev/cufa, etc. */ 	    line[y-1] = 'f';a 	    line[y+1] = '\0'; 	    s = line; 	}     }c #endif /* NEXT */r #endif /* COMMENT */  H     if ((y = ttopen(s,&x,mdmtyp,cdtimo)) < 0 ) { /* Open the new line */ 	if (y == -2) {e) 	    printf("?Timed out, no carrier.\n");(A 	    printf("Try SET CARRIER OFF and SET LINE again, or else\n");e5 	    printf("SET MODEM, SET LINE, and then DIAL.\n");d 	} else if (y == -3) {4 	    printf("Sorry, access to lock denied: %s\n",s); 	} else if (y == -4) {6 	    printf("Sorry, access to device denied: %s\n",s); 	} else if (y == -5) {
 #ifdef VMSH 	    printf("Sorry, device is in use or otherwise unavailable: %s\n",s); #elsee/ 	    printf("Sorry, device is in use: %s\n",s);h #endif /* VMS */%         } else {			/* Other error. */; #ifndef VMS  	    if (errno) {u) 		int x;			/* Find a safe, long buffer */D4 		x = strlen(line) + 2;	/* for the error message. */; 		if (LINBUFSIZ - x > 100) { /* Allow room for 100 chars */? 		    tp = line + x;7 		    sprintf(tp,"Sorry, can't open connection: %s",s);  		    perror(tp);n8 		} else printf("Sorry, can't open connection: %s\n",s); 	    } elsed #endif /* VMS */6 	      printf("Sorry, can't open connection: %s\n",s); 	}     /*   NOTE: B   The following will fail if Kermit is running as a daemon with no#   controlling tty.  Needs research.  */) 	local = dfloc;			/* Go back to normal */m #ifndef MACl6 	strcpy(ttname,dftty);		/* Restore default tty name */ #endif /* MAC */ 	speed = ttgspd();2 	network = 0;			/* No network connection active */+ 	return(success = 0);		/* Return failure */e     } >     if (x > -1) local = x;		/* Opened ok, set local/remote. */<     network = (mdmtyp < 0);		/* Remember connection type. */8     strcpy(ttname,s);			/* Copy name into real place. */
 #ifdef OS2!     {					/* Set session title */0+ 	char * p, name[72];		/* in window list. */I 	strcpy(name,"C-Kermit "); 	p = name + 9; 	strncpy(p, ttname, 60);0 	while (*p) {			/* Uppercase it for emphasis. */ 	    if (islower(*p))  	      *p = toupper(*p);	 	    p++;} 	} 	os2settitle((char *) name);     }e #endif /* OS2 */4     speed = ttgspd();			/* Get the current speed. */)     debug(F111,"set line ",ttname,local);! #ifdef NETCONN     if (network) #ifdef CK_SPEEDr;       /* Force prefixing of 255 on TCP/IP connections... */n        if (nettype == NET_TCPB) { 	  ctlp[255] = 1;	       } else #endif /* CK_SPEED */,0 	if (nettype == NET_SX25 || nettype == NET_VX25)* 	  duplex = 1;			/* Local echo for X.25 */ #endif /* NETCONN */     return(success = 1); }( #endif /* NOICP */