 #include "ckcsym.h" 
 #ifndef NOICP    A /*  C K U U S 6 --  "User Interface" for Unix Kermit (Part 6)  */    /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   /* Includes */    #include "ckcdeb.h"  #include "ckcasc.h"  #include "ckcker.h"  #include "ckuusr.h"  #include "ckcxla.h" + #include "ckcnet.h"			/* Network symbols */     #ifdef datageneral: #define fgets(stringbuf,max,fd) dg_fgets(stringbuf,max,fd) #endif /* datageneral */  > /* External Kermit Variables, see ckmain.c for description. */    extern xx_strp xxstring;  > extern int size, rpsiz, urpsiz, local, stdinf, sndsrc, xitsta,'   displa, binary, parity, escape, flow, >   turn, duplex, nfils, ckxech, pktlog, seslog, tralog, stdouf,B   turnch, dfloc, keep, maxrps, warn, cnflg, tlevel, pflag, msgflg,H   mdmtyp, zincnt, fblksiz, frecl, frecfm, atcapr, atdiso, verwho, quiet; extern int repars, techo;     #ifdef CK_IFRO extern int remonly;  #endif /* CK_IFRO */   extern long vernum, speed;H extern char *versio, *protv, *ckxv, *ckzv, *fnsv, *connv, *dftty, *cmdv;A extern char *dialv, *loginv, *for_def[], *whil_def[], *xif_def[]; . extern char *ckxsys, *ckzsys, *cmarg, *cmarg2;C extern char *DIRCMD, *PWDCMD, *DELCMD, *WHOCMD, ttname[], filnam[];  extern CHAR sstate;  extern char *zinptr;  & #ifndef NOMSEND				/* Multiple SEND */ extern char *msfiles[];  #endif /* NOMSEND */1 extern char fspec[];			/* Most recent filespec */    #ifdef CK_TMPDIR: extern int f_tmpdir;			/* Directory changed temporarily */: extern char savdir[];			/* For saving current directory */ #endif /* CK_TMPDIR */  # /* Declarations from cmd package */     #ifdef DCMDBUF4 extern char *cmdbuf, *atmbuf;		/* Command buffers */ #else 6 extern char cmdbuf[], atmbuf[];		/* Command buffers */ #endif /* DCMDBUF */  
 #ifndef NOSPL  extern struct mtab *mactab;  extern int nmac; #endif /* NOSPL */  ' /* Declarations from ck?fio.c module */    @ extern int backgrd, bgset;		/* Kermit executing in background */    #ifdef COMMENT /*   These must be on stack!  */
 #ifndef NOSPL 8 extern char vnambuf[];			/* Buffer for variable names */) extern char *vnp;			/* Pointer to same */  #endif /* NOSPL */ #endif /* COMMENT */  : extern char psave[];			/* For saving & restoring prompt */) extern char *tp;			/* Temporary buffer */   , /* Keyword tables specific to this module */   /* Modem signal table */   struct keytab mstab[] = {  #ifdef COMMENTJ /* The forms preceded by backslash are for MS-DOS Kermit compatibility. */G /* But... \dsr doesn't work because \d = decimal constant introducer */ 2     "\\cd",  BM_DCD, CM_INV,		/* Carrier Detect */2     "\\cts", BM_CTS, CM_INV,		/* Clear To Send  */2     "\\dsr", BM_DSR, CM_INV,		/* Data Set Ready */2     "\\ri",  BM_RNG, CM_INV,		/* Ring Indicator */ #endif /* COMMENT */.     "cd",    BM_DCD, 0,			/* Carrier Detect */.     "cts",   BM_CTS, 0,			/* Clear To Send  */.     "dsr",   BM_DSR, 0,			/* Data Set Ready */-     "ri",    BM_RNG, 0			/* Ring Indicator */  };2 int nms = (sizeof(mstab) / sizeof(struct keytab));  
 #ifndef NOSPL  struct keytab opntab[] = { #ifndef NOPUSH     "!read",  XYFZ_Y, 0,     "!write", XYFZ_X, 0, #endif /* NOPUSH */      "append", XYFZ_A, 0,     "read",   XYFZ_O, 0,     "write",  XYFZ_N, 0  };4 int nopn = (sizeof(opntab) / sizeof(struct keytab));  , struct keytab iftab[] = {		/* IF commands */     "<",          XXIFLT, 0,     "=",          XXIFAE, 0,     ">",          XXIFGT, 0,     "background", XXIFBG, 0,     "count",      XXIFCO, 0,     "defined",    XXIFDE, 0, #ifdef CK_TMPDIR     "directory",  XXIFDI, 0, #endif /* CK_TMPDIR */ #ifdef COMMENT     "eof",        XXIFEO, 0, #endif /* COMMENT */     "equal",      XXIFEQ, 0,!     "error",      XXIFFA, CM_INV,      "exist",      XXIFEX, 0,     "failure",    XXIFFA, 0,     "foreground", XXIFFG, 0,     "llt",        XXIFLL, 0,     "lgt",        XXIFLG, 0,
 #ifdef ZFCDAT      "newer",      XXIFNE, 0, #endif /* ZFCDAT */      "not",        XXIFNO, 0,!     "ok",         XXIFSU, CM_INV,      "numeric",    XXIFNU, 0,     "remote-only",XXIFRO, 0,     "success",    XXIFSU, 0  };2 int nif = (sizeof(iftab) / sizeof(struct keytab)); #endif /* NOSPL */  0 /* Variables and symbols local to this module */    #ifndef NODIAL  A char *dialnum = (char *)0;		/* Remember DIAL number for REDIAL */ 7 extern char * dialdir;			/* Dial directory file name */ < extern FILE * dialfd;			/* Dial directory file descriptor */ #endif /* NODIAL */   
 #ifndef NOSPL  int ifc,				/* IF case */ %     not = 0,				/* Flag for IF NOT */ 0     ifargs;				/* Count of IF condition words */+ char ifcond[100];			/* IF condition text */ 1 char *ifcp;				/* Pointer to IF condition text */  #ifdef DCMDBUFG extern int *ifcmd, *count, *iftest, *intime, *inpcas, *takerr, *merror;  #else / extern int ifcmd[];			/* Last command was IF */ - extern int iftest[];			/* Last IF was true */ = extern int count[];			/* For IF COUNT, one for each cmdlvl */  extern int intime[]; extern int inpcas[]; extern int takerr[]; extern int merror[]; #endif /* DCMDBUF */ #else  extern int takerr[]; #endif /* NOSPL */   #ifdef DCMDBUF8 extern char *line;			/* Character buffer for anything */ extern char *tmpbuf; #else  extern char line[], tmpbuf[];  #endif /* DCMDBUF *// extern char *lp;			/* Pointer to line buffer */   ( int cwdf = 0;				/* CWD has been done */   #ifndef NOSERVERI extern int en_cwd, en_del, en_dir, en_fin, /* Flags for ENABLE/DISABLE */ B    en_get, en_hos, en_sen, en_set, en_spa, en_typ, en_who, en_bye,    en_asg, en_que; #endif /* NOSERVER */   < extern FILE *tfile[];			/* File pointers for TAKE command */1 extern char *tfnam[];			/* Names of TAKE files */   8 extern int success;			/* Command success/failure flag */  
 #ifndef NOSPL + extern int maclvl;			/* Macro to execute */ 3 extern char *macx[];			/* Index of current macro */ 0 extern char *mrval[];			/* Macro return value */- extern char *macp[];			/* Pointer to macro */ 8 extern int macargc[];			/* ARGC from macro invocation */  C extern char *m_arg[MACLEVEL][NARGS];	/* Stack of macro arguments */ : extern char *g_var[];			/* Global variables %a, %b, etc */    #ifdef DCMDBUF= extern struct cmdptr *cmdstk;		/* The command stack itself */  #else > extern struct cmdptr cmdstk[];		/* The command stack itself */ #endif /* DCMDBUF */< extern int cmdlvl;			/* Current position in command stack */ #endif /* NOSPL */   #define xsystem(s) zsyscmd(s)    static int x, y, z = 0;  static char *s, *p;   7 /*  X X S T R C M P  --  Caseless string comparison  */  /*D   Call with pointers to the two strings, s1 and s2, and a length, n.=   Compares up to n characters of the two strings and returns:      1 if s1 > t1     0 if s1 = s2    -1 if s1 < t1 */ int K xxstrcmp(s1,s2,n) char *s1, *s2; int n; { /* Caseless string comparison. */      char t1, t2;			   :     if (!s1) s1 = "";			/* Watch out for null pointers. */     if (!s2) s2 = "";      while (n--) { 2 	t1 = *s1++;			/* Get next character from each. */# 	if (isupper(t1)) t1 = tolower(t1);  	t2 = *s2++;# 	if (isupper(t2)) t2 = tolower(t2); ' 	if (t1 < t2) return(-1);	/* s1 < s2 */ ' 	if (t1 > t2) return(1);		/* s1 > s2 */      } %     return(0);				/* They're equal */  }   
 #ifndef NOSPL   0 /* Do the ASK, ASKQ, GETOK, and READ commands */   #ifndef NOFRILLS     extern struct keytab yesno[];    extern int nyesno;  #endif /* NOFRILLS */    int  doask(cx) int cx; {  #ifdef CK_RECALL     int sv_recall;     extern int on_recall;  #endif /* CK_RECALL */0     if (cx != XXGOK) {			/* Get variable name */3 	if ((y = cmfld("Variable name","",&s,NULL)) < 0) {  	    if (y == -3) { & 		printf("?Variable name required\n");
 		return(-9);  	    } else return(y); 	}% 	strcpy(line,s);			/* Make a copy. */  	lp = line; B 	if ((y = parsevar(s,&x,&z)) < 0)  /* Check to make sure it's a */& 	  return(y);			  /* variable name. */     } +     if (cx == XXREA) {			/* READ command */ / 	if ((y = cmcfm()) < 0)		/* Get confirmation */ 
 	  return(y); * 	if (chkfn(ZRFILE) < 1) {	/* File open? */% 	    printf("?Read file not open\n");  	    return(0);  	}- 	s = line+VNAML+1;		/* Where to read into. */ @ 	y = zsinl(ZRFILE, s, LINBUFSIZ - VNAML - 1); /* Read a line. */ 	debug(F111,"read zsinl",s,y);, 	if (y < 0) {			/* On EOF or other error, */+ 	    zclose(ZRFILE);		/* close the file, */ - 	    delmac(lp);			/* delete the variable, */ 3 	    return(success = 0);	/* and return failure. */  	} else {			/* Read was OK. */D 	    success = (addmac(lp,s) < 0 ? 0 : 1); /* Define the variable */1             debug(F111,"read addmac",lp,success); , 	    return(success);		/* Return success. */ 	}     }        /* ASK, ASKQ, or GETOK */   @     if ((y = cmtxt("Prompt, enclose in { braces } to preserve\n\I leading and trailing spaces, precede question mark with backslash (\\).", ) 		   cx == XXGOK ? "{ Yes or no? }" : "",  		   &p,xxstring)) < 0) {  	return(y);      } 
 #ifdef VMS /*I   In VMS, whenever a TAKE file or macro is active, we had to restore the  K   original console modes or else Ctrl-C/Ctrl-Y would not work.  But here we @   go interactive again, so we have to temporarily put them back. */     if (cmdlvl > 0)        concb((char)escape); #endif /* VMS */       1     cmsavp(psave,PROMPTL);		/* Save old prompt */ /     cmsetp(brstrip(p));			/* Make new prompt */ )     if (cx == XXASKQ) {			/* For ASKQ, */ 7 	concb((char)escape);		/* put console in cbreak mode */ $ 	cmini(0);			/* and no-echo mode. */2     } else {				/* For others, regular echoing. */ 	cmini(ckxech);      } +     x = -1;				/* This means to reparse. */ 	 reprompt: 4     if (pflag) prompt(xxstring);	/* Issue prompt. */     if (cx == XXGOK) { #ifndef NOFRILLSG 	x = cmkey(yesno,nyesno,"","",xxstring);	/* GETOK uses keyword table */ ! 	if (x < 0) {			/* Parse error */ % 	    if (x == -3) {		/* No answer? */ > 		printf("Please respond Yes or No\n"); /* Make them answer */ 		cmini(ckxech); 	    } 	    goto reprompt;  	}/ 	if ((y = cmcfm()) < 0)		/* Get confirmation */  	  goto reprompt; & 	cmsetp(psave);			/* Restore prompt */
 #ifdef VMS5 	if (cmdlvl > 0)			/* In VMS and not at top level, */ , 	  conres();			/*  restore console again. */ #endif /* VMS */- 	return(x);			/* Return success or failure */  #else /* NOFRILLS */ 	; #endif /* NOFRILLS */ *     } else if (cx == XXGETC) {		/* GETC */
 	char tmp[2]; / 	x = coninc(0);			/* Just read one character */  	if (x > -1) { 	    printf("\r\n");  	    tmp[0] = (char) (x & 0xff); 	    tmp[1] = NUL;: 	    y = addmac(lp,tmp);		/* Add it to the macro table. */$ 	    debug(F111,"getc addmac",lp,y);. 	    cmsetp(psave);		/* Restore old prompt. */ 	} else y = -1; ! 	return(success = y < 0 ? 0 : 1); !     } else {				/* ASK or ASKQ */  #ifdef CK_RECALL 	sv_recall = on_recall;  	on_recall = 0;  #endif /* CK_RECALL */+ 	y = cmdgquo();			/* Get current quoting */ % 	cmdsquo(0);			/* Turn off quoting */ 1 	while (x == -1) {		/* Prompt till they answer */ - 	    x = cmtxt("Please respond.","",&s,NULL);  	    debug(F111," cmtxt",s,x); 	}- 	cmdsquo(y);			/* Restore previous quoting */  #ifdef CK_RECALL 	on_recall = sv_recall;  #endif /* CK_RECALL */2 	if (cx == XXASKQ)		/* ASKQ must echo CRLF here */ 	  printf("\r\n");+ 	if (x < 0) {			/* If cmtxt parse error, */ 2 	    cmsetp(psave);		/* restore original prompt */
 #ifdef VMS8 	    if (cmdlvl > 0)		/* In VMS and not at top level, */0 	      conres();			/*  restore console again. */ #endif /* VMS */6 	    return(x);			/* and return cmtxt's error code. */ 	}1 	if (*s == NUL) {		/* If user typed a bare CR, */ . 	    cmsetp(psave);		/* Restore old prompt, */6 	    delmac(lp);			/* delete variable if it exists, */
 #ifdef VMS8 	    if (cmdlvl > 0)		/* In VMS and not at top level, */0 	      conres();			/*  restore console again. */ #endif /* VMS */+ 	    return(success = 1);	/* and return. */  	}4 	y = addmac(lp,s);		/* Add it to the macro table. */ 	debug(F111,"ask addmac",lp,y); + 	cmsetp(psave);			/* Restore old prompt. */ 
 #ifdef VMS5 	if (cmdlvl > 0)			/* In VMS and not at top level, */ , 	  conres();			/*  restore console again. */ #endif /* VMS */! 	return(success = y < 0 ? 0 : 1);      }  }  #endif /* NOSPL */  
 #ifndef NOSPL  int 1 doincr(cx) int cx; {			/* INCREMENT, DECREMENT */ 9     char vnambuf[VNAML];		/* Buffer for variable names */   6     if ((y = cmfld("Variable name","",&s,NULL)) < 0) { 	if (y == -3) { ) 	    printf("?Variable name required\n");  	    return(-9); 	} else return(y);     }      if (*s != CMDQ) {          *vnambuf = CMDQ; 	strncpy(vnambuf+1,s,VNAML-1);$     } else strncpy(vnambuf,s,VNAML);  *     if ((y = parsevar(vnambuf,&x,&z)) < 0)       return(y);  C     if ((y = cmnum("by amount","1",10,&x,xxstring)) < 0) return(y); %     if ((y = cmcfm()) < 0) return(y);   =     z = (cx == XXINC ? 1 : 0);		/* Increment or decrement? */   %     if (incvar(vnambuf,x,z,&y) < 0) { = 	printf("?Variable %s not defined or not numeric\n",vnambuf);  	return(success = 0);      }      return(success = 1); }  #endif /* NOSPL */    - /* Do the (_)DEFINE and (_)ASSIGN commands */   
 #ifndef NOSPL  int  dodef(cx) int cx; { 9     char vnambuf[VNAML];		/* Buffer for variable names */ '     char *vnp;				/* Pointer to same */ $     if (cx == XXDFX || cx == XXASX) M       y = cmfld("Macro or variable name","",&s,xxstring); /* eval var name */ 	     else  N       y = cmfld("Macro or variable name","",&s,NULL);     /* don't evaluate */     if (y < 0) { 	if (y == -3) { ) 	    printf("?Variable name required\n");  	    return(-9); 	} else return(y);     } *     debug(F111,"dodef success",s,success);     strcpy(vnambuf,s);     vnp = vnambuf;N     if (vnambuf[0] == CMDQ && (vnambuf[1] == '%' || vnambuf[1] == '&')) vnp++;%     if (*vnp == '%' || *vnp == '&') { . 	if ((y = parsevar(vnp,&x,&z)) < 0) return(y); 	debug(F101,"dodef","",x);& 	if (y == 1) {			/* Simple variable */> 	    if ((y = cmtxt("Definition of variable","",&s,NULL)) < 0) 	      return(y);  	    s = brstrip(s);( 	    debug(F110,"xxdef var name",vnp,0);% 	    debug(F110,"xxdef var def",s,0); * 	} else if (y == 2) {		/* Array element */0 	    if ((y = arraynam(s,&x,&z)) < 0) return(y); 	    if (x == 96) { 2 		printf("?Argument vector array is read-only\n");
 		return(-9);  	    }' 	    if (chkarray(x,z) < 0) return(-2); C 	    if ((y = cmtxt("Definition of array element","",&s,NULL)) < 0)  	      return(y); ) 	    debug(F110,"xxdef array ref",vnp,0); ' 	    debug(F110,"xxdef array def",s,0);  	}     } else {				/* Macro */ B 	if ((y = cmtxt("Definition of macro","",&s,NULL)) < 0) return(y);& 	debug(F110,"xxdef macro name",vnp,0);# 	debug(F110,"xxdef macro def",s,0); 9 	if (*s == '{') {		/* Allow macro def to be bracketed. */ 0 	    s++;			/* If it is, remove the brackets. */< 	    y = (int)strlen(s);		/* FOR command depends on this! */. 	    if (y > 0 && s[y-1] == '}') s[y-1] = NUL; 	}     } 3     if (*s == NUL) {			/* No arg given, undefine */ ! 	delmac(vnp);			/* silently... */ 8 	return(success = 1);		/* even if it doesn't exist... */     }   *     /* Defining a new macro or variable */  F     if (cx == XXASS || cx == XXASX) {	/* ASSIGN rather than DEFINE? */ 	int t;  	t = LINBUFSIZ-1; / 	lp = line;			/* If so, expand its value now */  	zzstring(s,&lp,&t);
 	s = line;     } 2     debug(F111,"calling addmac",s,(int)strlen(s));  ?     y = addmac(vnp,s);			/* Add it to the appropriate table. */      if (y < 0) {5 	printf("?%s failed\n",(cx == XXASS || cx == XXASX) ?  	       "ASSIGN" : "DEFINE");  	return(success = 0); B     } else if (cx == XXASX || cx == XXDFX) /* For _ASG or _DEF, */9       return(1);			   /* don't change success variable */      else       return(success = 1); }m #endif /* NOSPL */     #ifndef NODIAL extern struct keytab partbl[]; /*6    L U D I A L  --  Lookup up dialing directory entry.   L    Call with string to look up and file descriptor of open dialing directoryD    file.  On success, returns pointer to phone number and sets speedM    and parity according to the directory entry.  On failure, returns the NULLf    pointer.b */ char * ludial(s,f) char *s; FILE *f; {a'     int n, n1, n2, i, t;		/* Workers */mC     long xspeed = -1L, x2;		/* Speed to set from directory entry */r.     int xparity = -1;			/* Parity to set ...*/4     char *info[5];			/* Array of words from entry */  9     if (!s || !f) return(NULL);		/* Validate arguments */      if ((n1 = strlen(s)) < 1)k       return(NULL);k /*I   We make one or two passes.  The first pass searches for an exact match.cH   If it fails, the second pass searches for the first entry of which theH   search string is an abbreviation.  Of course this could be done in oneG   pass, but it was safer to add a couple lines for the for-loop than to <   totally rearrange the code at the last minute.  (Edit 186) */2     for (i = 0; i < 2; i++) {		/* Do this twice */" 	debug(F101,"ludial pass","",i+1);5 	rewind(f);			/* Go to beginning of directory file */f 	while (1) {= 	    if (fgets(line,LINBUFSIZ,f) == NULL) { /* Read a line */k 		if (i == 0)		/* EOF */2 		  break;		/* If first pass, start second pass */< 		if (!backgrd && !quiet)	/* If second pass, give message */( 		  printf(" %s not in %s\n",s,dialdir);! 		debug(F110,"ludial fails",s,0);* 		return(NULL);t 	    }1 	    n = strlen(line);		/* Strip terminator(s) */d) 	    while ((n > 0) && (line[n-1] < '!'))k 	      line[--n] = NUL;x! 	    debug(F111,"ludial",line,n);,  4 	    info[0] = NULL; info[1] = NULL; info[2] = NULL;$ 	    info[3] = NULL; info[4] = NULL;  . 	    xwords(line,4,info);	/* Get the words. */& 	    if (info[1]) {		/* First word. */8 		if ((n2 = (int) strlen(info[1])) < 1) /* Its length */4 		  continue;		/* If no first word, keep looking. */  5 		if (n2 < n1)		/* If directory entry name shorter */ 5 		  continue;		/* than search name, then no match. */pA 		if (i == 0 && n2 != n1)	/* Require exact match on first pass */o
 		  continue;/> 		if (xxstrcmp(s,info[1],n1)) /* Caseless string comparison */0 		  continue;		/* up to length of search name */ 		if (!backgrd && !quiet)n1 		  printf(" From dialing directory %s: %s=%s\n",r> 		    dialdir,info[1],info[2] ? info[2] : "(number missing)"); 		if (!info[2])c 		  return("");i* 		if (info[3]) {		/* Third word = speed */< 		    if (*info[3] != '=') { /* "=" means don't change it */ 			xspeed = atol(info[3]); 			x2 = xspeed / 10L;  			if (x2 > 0) {  			    if (ttsspd((int) x2) < 0)6 			      printf("\n Can't set speed to %s\n",info[3]); 			    else  			      speed = ttgspd(); 			} 		    }y 		}t) 		if (info[4]) {		/* 4th word = parity */m< 		    if (*info[4] != '=') { /* "=" means don't change it */4 			if ((xparity = lookup(partbl,info[4],5,&t)) > -1) 			  parity = xparity; 		    }  		}d7 		return(info[2]);	/* Return 2nd word = phone number */  	    } 	}     },!     return(NULL);			/* Failure */  }c   int_+ dodial(cx) int cx; {			/* DIAL or REDIAL */r7     int sparity;			/* For saving global parity value */_+     if (cx == XXRED) {			/* REDIAL or... */ " 	if ((y = cmcfm()) < 0) return(y); 	if (dialnum) {c 	    s = dialnum;B	 	} else {	, 	    printf("?No DIAL command given yet\n"); 	    return(-9); 	}2     } else if (cx == XXDIAL) {		/* DIAL command */
 	char *s2; 	if (dialdir && *dialdir)u6 	  s2 = "Number to dial or entry from dial directory"; 	elsen 	  s2 = "Number to dial";Y( 	if ((x = cmtxt(s2,"",&s,xxstring)) < 0)
 	  return(x); ( 	if (s == NULL || (int)strlen(s) == 0) {4 	    printf("?You must specify a number to dial\n"); 	    return(-9); 	}. 	if (dialfd) {			/* Have dialing directory? */> 	    s2 = ludial(s,dialfd);	/* Look up in dialing directory */ 	    if (s2) { 		if ((int)strlen(s2) < 1) {
 		    printf( A 		     "?Dialing directory \"%s\" entry lacks phone number\n",s);  		    return(-9);R 		} else- 		  s = s2;		/* Make substitution if found */i 	    } 	}7 	if (dialnum) free(dialnum);	/* Make copy for REDIAL */ & 	dialnum = malloc((int)strlen(s) + 1);  	if (dialnum) strcpy(dialnum,s);     } else return(-2);
 #ifdef VMS,     conres();				/* So Ctrl-C/Y will work */ #endif /* VMS */ /*)   A rather radical change for edit 190...C  M   Some modems do not react well to parity.  Also, if we are dialing through aOL   TCP/IP TELNET modem server, parity can be fatally misinterpreted as TELNETN   negotiations.  Note that at this point it is very likely that we picked up aL   parity setting from the dialing directory (in the call to ludial() above).F   So now we save the current parity, set it to NONE during the dialingM   process, and then restore it afterwards.  This should work even if the usercL   interrupts the DIAL command, because the DIAL module has its own interruptL   handler.  BUT... if, for some reason, a dialing device actually *requires*H   parity (e.g. CCITT V.25bis says that even parity should be used), this#   might prevent successful dialing.o */1     sparity = parity;			/* Save current parity */t+     parity = 0;				/* Set parity to NONE */m+     success = ckdial(s);		/* Try to dial */,,     parity = sparity;			/* Restore parity */
 #ifdef OS2     ttres(); #endif /* OS2 */
 #ifdef VMS<     concb((char)escape);		/* Back to command parsing mode */ #endif /* VMS */     return(success); }e #endif /* NODIAL */e  & int					/* Do the DIRECTORY command */	 dodir() {D #ifndef MAC 
     char *dc;k #endif /* MAC */
 #ifdef MAC /*F   This is a crude, do-it-yourself directory command.  It shows all theK   files in the current directory: size and name of each file.  Only regular L   files are shown.  With a little more work, it could also show directories,I   and mark files as regular or directories, and it could also show dates.e1   See sample code in zldir() routine in ckmfio.c.e */     char mac_name[65];!     long mac_len, nfiles, nbytes;s;     extern long mac_znextlen;		/* See ckmfio.c for this. */	       if ((y = cmcfm()) < 0)       return(y);       nfiles = nbytes = 0L;E-     printf("\nDirectory of %s\n\n",zgtdir());s     x = zxpand(":");     while (x-- > 0) {e 	if (!znext(mac_name))	 	  break;e 	mac_len = zchki(mac_name);/ 	if (mac_len > -1L) {o 	    nfiles++; 	    nbytes += mac_znextlen;2 	    printf("%10ld %s\n", mac_znextlen, mac_name); 	}     }n*     printf("\n%ld file%s, %ld byte%s\n\n", 	   nfiles,e 	   (nfiles == 1) ? "" : "s",; 	   nbytes,m 	   (nbytes == 1) ? "" : "s" 	   );     return(success = 1); #else 
 #ifdef VMSG     if ((x = cmtxt("Directory/file specification","",&s,xxstring)) < 0)f       return(x);C     /* now do this the same as a shell command - helps with LAT  */ *     conres();				/* Make console normal */     lp = line;.     if (!(dc = getenv("CK_DIR"))) dc = DIRCMD;     sprintf(lp,"%s %s",dc,s);t&     debug(F110,"DIR string", line, 0);     x = zshcmd(lp);-)     debug(F101,"DIR return code", "", x);a     concb((char)escape);&     return(success = (x > 0) ? 1 : 0); #elser #ifdef AMIGAG     if ((x = cmtxt("Directory/file specification","",&s,xxstring)) < 0)        return(x); #else  #ifdef datageneralH     if ((x = cmtxt("Directory/file specification","+",&s,xxstring)) < 0)       return(x); #else)
 #ifdef OS2     tmpbuf[0] = NUL;     if ((x = cmifi2(1 "Device, directory, and/or file specification,\n\/   or switch(es), or '> file'","", 		    &s,&y,1,xxstring)) < 0) {t 	debug(F101,"DIR cmifi2","",x);t 	if (x == -3) {			/* Done. */  	    goto sw_skip;2 	} else if (x == -2 && (*s == '/' || *s == '>')) {: 	    strncpy(tmpbuf,s,TMPBUFSIZ); /* Switch or redirect */ 	    if ((y = cmcfm()) < 0), 	      return(y);E	 	    else  	      goto sw_skip;D 	} else if (x == -2 && !strchr(s,'.')) {	/* Maybe ".*" is missing */ 	    goto fs_copy; 	} else if (x == -2) {  	    printf("%s not found\n",s); 	    return(-9); 	} elsel
 	  return(x);K     }  #else /* General Case */G     if ((x = cmdir("Directory/file specification","",&s,xxstring)) < 0)<       if (x != -3) return(x);	 #endif /* OS2 */ #endif /* datageneral */ #endif /* AMIGA */  
 #ifdef OS2 fs_copy: #endif /* OS2 */"     debug(F110,"DIR fs_copy",s,0);8     strncpy(tmpbuf,s,TMPBUFSIZ);	/* Copy the filespec */  
 #ifdef OS2H     {   /* Lower level functions change / to \, not good for CMD.EXE. *// 	/* Only do this to filenames, not switches! */a 	char *p = tmpbuf;+ 	while (*p) {			/* Change them back to \ */  	    if (*p == '/') *p = '\\';	 	    p++;  	}     }((     debug(F110,"DIR tmpbuf 1",tmpbuf,0);4     /* Now parse trailing switches like /P/O-D... */L     if ((x = cmtxt("Optional switches and/or redirect for OS/2 DIR command", 		   "",&s,xxstring)) < 0)       return(x);9     strcat(tmpbuf,s);			/* Append them to the filespec */e(     debug(F110,"DIR tmpbuf 2",tmpbuf,0); sw_skip: #elsel%     if ((y = cmcfm()) < 0) return(y);/ #endif /* OS2 */     s = tmpbuf;?     lp = line;.     if (!(dc = getenv("CK_DIR"))) dc = DIRCMD;     sprintf(lp,"%s %s",dc,s);t     debug(F110,"DIR",line,0);s     xsystem(line);,     return(success = 1);		/* who cares... */ #endif /* VMS */ #endif /* MAC */ }o   #ifndef NOSERVER #ifndef NOFRILLS( /* Do the ENABLE and DISABLE commands */   int  doenable(cx,x) int cx, x; {r      y = ((cx == XXENA) ? 1 : 0);     switch (x) {       case EN_ALL:0 	en_cwd = en_del = en_dir = en_fin = en_get = y;0 	en_sen = en_set = en_spa = en_typ = en_who = y; #ifndef datageneralr         en_bye = y;w #endif /* datageneral */ #ifndef NOPUSH 	en_hos = y; #endif /* NOPUSH */m
 #ifndef NOSPL  	en_asg = en_que = y;  #endif /* NOSPL */ 	break;/       case EN_BYE: #ifndef datageneralL /*C   In Data General AOS/VS Kermit can't log out its superior process.* */         en_bye = y;  #endif /* datageneral */ 	break;e       case EN_CWD: 	en_cwd = y; 	break;        case EN_DEL: 	en_del = y; 	break;        case EN_DIR: 	en_dir = y; 	break;/       case EN_FIN: 	en_fin = y; 	break;/       case EN_GET: 	en_get = y; 	break;  #ifndef NOPUSH       case EN_HOS: 	en_hos = y; 	break;( #endif /* NOPUSH */e       case EN_SEN: 	en_sen = y; 	break;x       case EN_SET: 	en_set = y; 	break;i       case EN_SPA: 	en_spa = y; 	break;x       case EN_TYP: 	en_typ = y; 	break;a       case EN_WHO: 	en_who = y; 	break;e
 #ifndef NOSPLk       case EN_ASG: 	en_asg = y; 	break;i       case EN_QUE: 	en_que = y; 	break;* #endif /* NOSPL */       default: 	return(-2);     }p     return(1); }i #endif /* NOFRILLS */V #endif /* NOSERVER */,   #ifndef NOFRILLS intr dodel() {				/* DELETE */e #ifndef MAC/     long zl; #endif /* MAC */A     if ((x = cmifi("File(s) to delete","",&s,&y,xxstring)) < 0) {  	if (x == -3) { 3 	    printf("?A file specification is required\n");( 	    return(-9); 	} else return(x);     }>
 #ifdef MAC     strcpy(line,s);  #else D     strncpy(tmpbuf,s,TMPBUFSIZ);	/* Make a safe copy of the name. */
 #ifdef OS2H     {   /* Lower level functions change / to \, not good for CMD.EXE. */ 	char *p = tmpbuf;+ 	while (*p) {			/* Change them back to \ */  	    if (*p == '/') *p = '\\';	 	    p++;o 	}     }  #endif /* OS2 */(     debug(F110,"xxdel tmpbuf",tmpbuf,0);L     sprintf(line,"%s %s",DELCMD,tmpbuf); /* Construct the system command. */ #endif /* MAC */$     debug(F110,"xxdel line",line,0);G     if ((y = cmcfm()) < 0) return(y);	/* Confirm the user's command. */)
 #ifdef VMS
     conres();" #endif /* VMS */
 #ifdef MAC
     s = line;s"     success = (zdelet(line) == 0); #else=     s = tmpbuf;d0     xsystem(line);			/* Let the system do it. */     zl = zchki(tmpbuf);p     success = (zl == -1L); #endif /* MAC */     if (msgflg) :       printf("%s - %sdeleted\n",s, success ? "" : "not ");
 #ifdef VMS     concb((char)escape); #endif /* VMS */     return(success); }  #endif /* NOFRILLS */   ' #ifndef NOSPL				/* The ELSE command */a intt
 doelse() {     if (!ifcmd[cmdlvl]) { % 	printf("?ELSE doesn't follow IF\n");* 	return(-2);     }) #ifdef COMMENT /*A   Wrong.  This prevents IF..ELSE IF...ELSE IF...ELSE IF...ELSE...i   from working.  */     ifcmd[cmdlvl] = 0; #endif /* COMMENT */>     if (!iftest[cmdlvl]) {		/* If IF was false do ELSE part */$ 	if (maclvl > -1) {		/* In macro, */- 	    pushcmd();			/* save rest of command. */o. 	} else if (tlevel > -1) {	/* In take file, */- 	    pushcmd();			/* save rest of command. */.! 	} else {			/* If interactive, */	3 	    cmini(ckxech);		/* just start a new command *//1 	    printf("\n");		/* (like in MS-DOS Kermit) */t! 	    if (pflag) prompt(xxstring);  	}(     } else {				/* Condition is false */9 	if ((y = cmtxt("command to be ignored","",&s,NULL)) < 0) , 	  return(y);			/* Gobble up rest of line */     }*     return(0); }c #endif /* NOSPL */  
 #ifndef NOSPL) inti# dofor() {				/* The FOR command. */e*     int fx, fy, fz;			/* loop variables */-     char *ap;				/* macro argument pointer */   N     if ((y = cmfld("Variable name","",&s,NULL)) < 0) { /* Get variable name */ 	if (y == -3) { ) 	    printf("?Variable name required\n");  	    return(-9); 	} else return(y);     }n4     if ((y = parsevar(s,&x,&z)) < 0)	/* Check it. */       return(y);  3     lp = line;				/* Build a copy of the command */t     strcpy(lp,"_forx ");1     lp += (int)strlen(line);		/* "_for" macro. */b1     ap = lp;				/* Save pointer to macro args. */t  ;     if (*s == CMDQ) s++;		/* Skip past backslash if any. */f)     while (*lp++ = *s++) ;		/* copy it */_)     lp--; *lp++ = SP;			/* add a space */   >     if ((y = cmnum("initial value","",10,&fx,xxstring)) < 0) { 	if (y == -3) return(-2);* 	else return(y);     }e-     s = atmbuf;				/* Copy the atom buffer */ (     if ((int)strlen(s) < 1) goto badfor;<     while (*lp++ = *s++) ;		/* (what they actually typed) */     lp--; *lp++ = SP;"  <     if ((y = cmnum("final value","",10,&fy,xxstring)) < 0) { 	if (y == -3) return(-2);a 	else return(y);     } "     s = atmbuf;				/* Same deal */(     if ((int)strlen(s) < 1) goto badfor;     while (*lp++ = *s++) ;     lp--; *lp++ = SP;m  ;     if ((y = cmnum("increment","1",10,&fz,xxstring)) < 0) {u 	if (y == -3) return(-2);f 	else return(y);     }'     sprintf(tmpbuf,"%d ",fz);&"     s = atmbuf;				/* same deal */(     if ((int)strlen(s) < 1) goto badfor;     while (*lp++ = *s++) ;     lp--; *lp++ = SP;r  4     /* Insert the appropriate comparison operator */     if (fz < 0)d       *lp++ = '<';     else       *lp++ = '>';     *lp++ = SP;,  D     if ((y = cmtxt("Command to execute","",&s,NULL)) < 0) return(y);'     if ((int)strlen(s) < 1) return(-2);=          if (litcmd(&s,&lp) < 0) {a" 	printf("?Unbalanced brackets\n"); 	return(0);      }c     if (fz == 0) {) 	printf("?Zero increment not allowed\n");  	return(0);e     }&F     x = mlook(mactab,"_forx",nmac);	/* Look up FOR macro definition */#     if (x < 0) {			/* Not there? */d- 	addmmac("_forx",for_def);	/* Put it back. */iD 	if ((x = mlook(mactab,"_forx",nmac)) < 0) { /* Look it up again. */E 	    printf("?FOR macro definition gone!\n"); /* Shouldn't happen. */  	    return(success = 0);o 	}     } %     debug(F110,"FOR command",line,0); >     return(success = dodo(x,ap));	/* Execute the FOR macro. */  , badfor: printf("?Incomplete FOR command\n");     return(-2);y }  #endif /* NOSPL */   #ifndef NOFRILLS /* Do the BUG command */   int 	 dobug() {):     printf("\n%s,%s\n Numeric: %ld",versio,ckxsys,vernum);%     if (verwho) printf("-%d",verwho);D     printf("\n\n\ L Before deciding you have found a bug, please consult the documentation:\n");&     printf(" . \"Using C-Kermit\"\n"); #ifndef OS2	&    printf(" . The CKCKER.BWR file\n"); #endif /* OS2 */ #ifdef UNIX '     printf(" . The CKUKER.BWR file\n");, #elser
 #ifdef VMS'     printf(" . The CKVKER.BWR file\n");  #elsei
 #ifdef OS2(     printf(" . The CKERMIT.INF file\n"); #else= #ifdef datageneral'     printf(" . The CKDKER.BWR file\n");r #elseu #ifdef STRATUS'     printf(" . The CKLKER.BWR file\n");/ #elseA #ifdef AMIGA'     printf(" . The CKIKER.BWR file\n");u #elsea
 #ifdef GEMDOS '     printf(" . The CKSKER.BWR file\n");d #elseO
 #ifdef MAC'     printf(" . The CKMKER.BWR file\n");b #else*
 #ifdef OSK'     printf(" . The CK9KER.BWR file\n");r #else D     printf(" . The appropriate system-dependent CK?KER.BWR file\n"); #endif #endif #endif #endif #endif #endif #endif #endif #endif  ;     printf("\nTo report C-Kermit bugs, send e-mail to:\n");r0     printf(" kermit@columbia.edu (Internet)\n");1     printf(" KERMIT@CUVMA (EARN/CREN/BITNET)\n");i8     printf(" ...!uunet!columbia.edu!kermit (Usenet)\n");H     printf("Or write to:\n Kermit Development\n Columbia University\n");"     printf(" 612 W 115 Street\n");N     printf(" New York, NY  10025  USA\nOr call:\n +1 212 854-5126 (USA)\n\n"); #ifndef NOSHOW #ifndef NOFRILLS     printf(eN "Before reporting problems, please use the SHOW VERSION and SHOW FEATURES\n");     printf( O "commands to get detailed program version and configuration information.\n\n");h #endif /* NOFRILLS */i #endif /* NOSHOW */o     return(1); }  #endif /* NOFRILLS */r  
 #ifndef NOSPLl intf dopaus(cx) int cx; {G     /* Both should take not only secs but also hh:mm:ss as argument. */      if (cx == XXWAI)6       y = cmnum("seconds to wait","1",10,&x,xxstring);     else if (cx == XXPAU)o7       y = cmnum("seconds to pause","1",10,&x,xxstring);f     else>       y = cmnum("milliseconds to sleep","100",10,&x,xxstring);     if (y < 0) return(y);s     if (x < 0) x = 0;s     switch (cx) {d       case XXPAU:			/* PAUSE */v        case XXMSL:			/* MSLEEP */" 	if ((y = cmcfm()) < 0) return(y); 	break;i       case XXWAI:			/* WAIT */" 	z = 0;				/* Modem signal mask */3 	while (1) {			/* Read zero or more signal names */15 	    y = cmkey(mstab,nms,"modem signal","",xxstring);l6 	    if (y == -3) break;		/* -3 means they typed CR */; 	    if (y < 0) return(y);	/* Other negatives are errors */ 4 	    z |= y;			/* OR the bit into the signal mask */ 	} 	break;   (       default:				/* Shouldn't happen */ 	return(-2);     }n  $ /* Command is entered, now do it. */  0     if (cx == XXMSL) {			/* Millisecond sleep */ 	msleep(x);e 	return(success = 1);n     } $     while (x--) {			/* Sleep loop */ 	int mdmsig;4 	if (y = conchk()) {		/* Did they type something? */ #ifdef COMMENT3 	    while (y--) coninc(0);	/* Yes, gobble it up */a #endif/ 	    break;			/* And quit PAUSing or WAITing *// 	} 	if (cx == XXWAI && z != 0) {r 	    mdmsig = ttgmdm();t) 	    if (mdmsig < 0) return(success = 0);n0 	    if ((mdmsig & z) == z) return(success = 1); 	}1 	sleep(1);			/* No interrupt, sleep one second */r     }e!     if (cx == XXWAI) success = 0;/C     else success = (x == -1);		/* Set SUCCESS/FAILURE for PAUSE. */s     return(0); }  #endif /* NOSPL */     #ifndef NOFRILLS int	 dorenam() {(>     if ((x = cmifi("File to rename","",&s,&y,xxstring)) < 0) { 	if (x == -3) { 1 	    printf("?Name of existing file required\n");  	    return(-9); 	} else return(x);     } *     if (y) {				/* No wildcards allowed */- 	printf("\n?Please specify a single file\n");r 	return(-9);     } <     strcpy(line,s);			/* Make a safe copy of the old name */>     p = line + (int)strlen(line) + 2;	/* Place for new name */H     if ((x = cmofi("New name","",&s,xxstring)) < 0) { /* Get new name */ 	if (x == -3) {o- 	    printf("?New name for file required\n");/ 	    return(-9); 	} else return(x);     }e9     strcpy(p,s);			/* Make a safe copy of the new name */ %     if ((y = cmcfm()) < 0) return(y);\
 #ifdef VMS'     conres();				/* Let Ctrl-C work. */A #endif /* VMS */'     debug(F110,"dorename line",line,0);d!     debug(F110,"dorename p",p,0);t     if (zrename(line,p) < 0) {+ 	printf("?Can't rename %s to %s\n",line,p);(
 #ifdef VMS 	concb((char)escape);( #endif /* VMS */ 	return(-9);     } else {
 #ifdef VMS 	concb((char)escape);n #endif /* VMS */ 	return(success = 1);      }a }) #endif /* NOFRILLS */r    
 #ifndef NOSPL    /* Do the RETURN command */i   intn doreturn(s) char *s; {     int x; char *p;r     if (maclvl < 0) {r2 	printf("\n?Can't return from level %d\n",maclvl); 	return(success = 0);      }e/     lp = line;				/* Expand return value now */t     x = LINBUFSIZ-1;"     if (zzstring(s,&lp,&x) > -1) {
 	s = line;  	debug(F110,"RETURN parse",s,0);     }t,     debug(F101,"RETURN maclvl 1","",maclvl);%     /* Pop from all FOR/WHILE/XIFs */S     while ((maclvl > 0) && 	   (m_arg[maclvl-1][0]) && % 	   (cmdstk[cmdlvl].src == CMD_MD) &&o- 	   (!strncmp(m_arg[maclvl-1][0],"_xif",4) ||l- 	    !strncmp(m_arg[maclvl-1][0],"_for",4) ||O. 	    !strncmp(m_arg[maclvl-1][0],"_whi",4))) {3 	debug(F110,"RETURN popping",m_arg[maclvl-1][0],0); # 	dogta(XXPTA);		/* Put args back */t$ 	popclvl();		/* Pop up two levels */ 	popclvl();n) 	debug(F101,"RETURN maclvl 2","",maclvl);.     }n8     popclvl();				/* Pop from enclosing TAKE or macro */,     debug(F101,"RETURN maclvl 3","",maclvl);  6     x = (int)strlen(s);			/* Length of return value */+     if (x > 0) {			/* Have return value? */s4 	p = malloc(x+2);		/* Allocate a place to keep it */1 	if (mrval[maclvl+1])		/* Free old one, if any */. 	  free(mrval[maclvl+1]);e% 	if (p) {			/* Did we get a place? */h7 	    strcpy(p, s);		/* Yes, copy the string into it. */	> 	    mrval[maclvl+1] = p;	/* Make return value point to it. *// 	    debug(F110,"RETURN copy",mrval[maclvl],0);i* 	} else {			/* No, could not get space. */7 	    mrval[maclvl+1] = NULL;	/* Return null pointer. */d, 	    x = 0;			/* Set failure return code. */ 	}:     } else mrval[maclvl+1] = NULL;	/* Blank return code */:     return(success = x ? 1 : 0);	/* Return status code */	 }  #endif /* NOSPL */  
 #ifndef NOSPLr /* Do the OPEN command */i   intC1 doopen()  {				/* OPEN { append, read, write } */o     int x, y, z; char *s; 6     static struct filinfo fcb;		/* (must be static) */:     if ((x = cmkey(opntab,nopn,"mode","",xxstring)) < 0) { 	if (x == -3) {o  	    printf("?Mode required\n"); 	    return(-9); 	} else return(x);     }s     switch (x) {*       case XYFZ_O:			/* Old file (READ) */ 	if (chkfn(ZRFILE) > 0) {[) 	    printf("?Read file already open\n");  	    return(-2); 	}9 	if ((z = cmifi("File to read","",&s,&y,xxstring)) < 0) {) 	    if (z == -3) {y' 		printf("?Input filename required\n");n
 		return(-9);  	    } else return(z); 	}' 	if (y) {				/* No wildcards allowed */ 1 	    printf("\n?Please specify a single file\n");i 	    return(-2); 	} 	strcpy(line,s);' 	if ((int)strlen(line) < 1) return(-2);;" 	if ((y = cmcfm()) < 0) return(y);' 	return(success = zopeni(ZRFILE,line));"   #ifndef MACl #ifndef NOPUSH.       case XYFZ_Y:			/* Pipe/Process (READ) */ 	if (chkfn(ZRFILE) > 0) {1) 	    printf("?Read file already open\n");1 	    return(-2); 	}L         if ((y = cmtxt("System command to read from","",&s,xxstring)) < 0) { 	    if (y == -3) {*% 		printf("?Command name required\n");d
 		return(-9);A 	    } else return(y); 	} 	strcpy(line,s);' 	if ((int)strlen(line) < 1) return(-2);n" 	if ((y = cmcfm()) < 0) return(y);& 	return(success = zxcmd(ZRFILE,line));  (       case XYFZ_X:			/* Write to pipe */ 	if (chkfn(ZWFILE) > 0) {n* 	    printf("?Write file already open\n"); 	    return(-2); 	}K         if ((y = cmtxt("System command to write to","",&s,xxstring)) < 0) {e 	    if (y == -3) {t% 		printf("?Command name required\n"); 
 		return(-9);r 	    } else return(y); 	} 	strcpy(line,s);' 	if ((int)strlen(line) < 1) return(-2);u" 	if ((y = cmcfm()) < 0) return(y); 	success = zxcmd(ZWFILE,line); 	if (!success && msgflg)7 	  printf("Can't open process for writing: %s\n",line);" 	return(success);, #endif /* NOPUSH */d #endif /* MAC */  +       case XYFZ_N:			/* New file (WRITE) */ #       case XYFZ_A:			/* (APPEND) */ F 	if ((z = cmofi("Name of local file to create","",&s,xxstring)) < 0) { 	    if (z == -3) { ! 		printf("?Filename required\n");r
 		return(-9);  	    } else return(z); 	} 	if (z == 2) {2 	    printf("?Sorry, %s is a directory name\n",s); 	    return(-9); 	} 	if (chkfn(ZWFILE) > 0) { 1 	    printf("?Write/Append file already open\n");} 	    return(-2); 	}L         fcb.bs = fcb.cs = fcb.rl = fcb.fmt = fcb.org = fcb.cc = fcb.typ = 0; 	fcb.lblopts = 0;i& 	fcb.dsp = x;			/* Create or Append */ 	strcpy(line,s);' 	if ((int)strlen(line) < 1) return(-2);M" 	if ((y = cmcfm()) < 0) return(y);1 	return(success = zopeno(ZWFILE,line,NULL,&fcb));          default: 	printf("?Not implemented"); 	return(-2);     }  }  #endif /* NOSPL */  + /* Finish parsing and do the GET command *//   intn	 doget() {t
     int x, y;t     char *cbp;  6     cmarg2 = "";			/* Initialize as-name to nothing */
     x = 0; #ifdef NOFRILLSp     if (*cmarg == NUL) {' 	printf("?Remote filespec required\n");b 	return(-3);     }r #elsel /*F   If remote file name omitted, get foreign and local names separately.=   But multine GET is allowed only if NOFRILLS is not defined.  */     if (*cmarg == NUL) {  , 	if (tlevel > -1
 #ifndef NOSPLp$ 	    && cmdstk[cmdlvl].src == CMD_TF #endif /* NOSPL */ 	    ) {  # /* Input is from a command file. */   ' 	    /* Read 2nd line of GET command */=  $ 	    if (getnct(cmdbuf,CMDBL) < 0) {= 		printf("Command file ends prematurely in multiline GET\n");" 		popclvl();
 		return(-9);i 	    } 	    cmres();			/* Parse it */0 	    if ((x = cmtxt("Oofa","",&s,xxstring)) < 0) 	      return(x);R4 	    strcpy(line,brstrip(s));	/* Make a safe copy */2 	    cmarg = line;		/* Point to remote filename */6 	    if (*cmarg == NUL) {	/* Make sure there is one */7 		printf("Remote filename missing in multiline GET\n");;
 		return(-9);s 	    }: 	    lp = line + strlen(line) + 1; /* Place for as-name */   	    /* And third line... */  * 	    cmarg2 = "";		/* Assume no as-name */8 	    if (getnct(cmdbuf,CMDBL) < 0) { /* Get next line */$ 		popclvl();		/* There isn't one. */! 	    } else {			/* There is... */n6 		if (*cmdbuf >= ' ') {	/* Parse as output filename */ 		    cmres();6 		    if ((x = cmofi("Mupeen",cmarg,&s,xxstring)) < 0) 		      return(x);* 		    strcpy(lp,s);	/* Make a safe copy */4 		    cmarg2 = lp;	/* Point as-name pointer at it */ 		}b 	    })             x = 0;			/* Return code OK */   
 #ifndef NOSPL:. /* Reading commands from a macro definition */  9 	} else if (cmdlvl > 0 && cmdstk[cmdlvl].src == CMD_MD) {   * 	    /* Read second line of GET command */   	    cbp = cmdbuf;! 	    if (getncm(cbp,CMDBL) < 0) {:A 		printf("Macro definition ends prematurely in multiline GET\n");a
 		return(-9);_ 	    }
 	    cmres();e; 	    if ((x = cmtxt("Oofa","",&s,xxstring)) < 0) return(x);k7 	    if (*s == NUL) {		/* Make sure we got something */ 7 		printf("Remote filename missing in multiline GET\n");n
 		return(-9);f 	    }? 	    strcpy(line,brstrip(s));	/* Copy filename to safe place */(% 	    cmarg = line;		/* Point to it */ , 	    x = strlen(line);		/* Get its length */8 	    lp = line + x + 1;		/* Where to put the next bit */8 	    y = LINBUFSIZ - x - 1;	/* Room left for next bit */   	    /* And third line... */  * 	    cmarg2 = "";		/* Assume no as-name */@ 	    if (getncm(lp,y) > -1 && *lp >= ' ') { /* Read next line */ 		x = strlen(lp); 3 		if (lp[x-1] == CR) lp[x-1] = NUL; /* Remove CR */ ) 		cbp = cmdbuf;		/* Interpret the line */t 		*cbp = NUL;		/* ... */+ 		y = CMDBL;		/* into the command buffer */' 		zzstring(lp,&cbp,&y); , 		if (*cmdbuf) {		/* If we have something */4 		    cmres();		/* parse it as an output filename */ 		    strcat(cmdbuf," ");h/ 		    if ((x = cmofi("Mupeen","",&s,NULL)) < 0)( 		      return(x);5 		    strcpy(lp,s);	/* Copy the name to safe place */m1 		    cmarg2 = lp;	/* and make as-name pointer */" 		}d 	    })             x = 0;			/* Return code OK */s #endif /* NOSPL *//         } else {			/* Input is from terminal */;  / 	    cmsavp(psave,PROMPTL); ? 	    cmsetp(" Remote file specification: "); /* Make new one */  	    cmini(ckxech);  	    x = -1;! 	    if (pflag) prompt(xxstring); 5 	    while (x == -1) {		/* Prompt till they answer *//= 	    	x = cmtxt("Name of remote file(s)","",&cmarg,xxstring);i 		debug(F111," cmtxt",cmarg,x);d 	    } 	    if (x < 0) {  		cmsetp(psave); 		return(x); 	    }9 	    if (*cmarg == NUL) { 	/* If user types a bare CR, */T3 		printf("(cancelled)\n"); /* Forget about this. */./ 	    	cmsetp(psave);		/* Restore old prompt, */m 		return(0);		/* and return. */  	    }8 	    strcpy(line,brstrip(cmarg)); /* Make a safe copy */ 	    cmarg = line;@ 	    cmsetp(" Local name to store it under: "); /* New prompt */ 	    cmini(ckxech);> 	    x = -1;! 	    if (pflag) prompt(xxstring);s8 	    while (x == -1) {		/* Again, parse till answered */7 	    	x = cmofi("Local file name","",&cmarg2,xxstring);  	    }$ 	    if (x < 0) {		/* Parse error */# 		if (x == -3) {		/* CR = cancel */)2 		    printf("(cancelled)\n"); /* Print message */* 		    x = 0;		/* Avoid further messages */ 		})& 		cmsetp(psave);		/* Restore prompt */ 		return(x); 	    }	    e& 	    x = -1;			/* Get confirmation. */! 	    while (x == -1) x = cmcfm();h. 	    cmsetp(psave);		/* Restore old prompt. */	         }      }  #endif /* NOFRILLS */r  :     if (x == 0) {			/* Good return from cmtxt or cmcfm, */# 	debug(F110,"xxget cmarg",cmarg,0);/ 	strncpy(fspec,cmarg,FSPECL);(( 	debug(F111,"xxget fspec",fspec,FSPECL);' 	sstate = 'r';			/* Set start state. */f
 	if (local) {( 	    displa = 1; 	    ttflui(); 	}     }y #ifndef NOFRILLS #ifdef CK_TMPDIR= /* cmarg2 is also allowed to be a device or directory name */t   	y = strlen(cmarg2); 	if (.
 #ifdef OS2 	    (isalpha(cmarg2[0]) &&m 	     cmarg2[1] == ':' &&s 	     cmarg2[2] == '\0') ||b 	    isdir(cmarg2) #elseh #ifdef UNIX*3 	    (y > 0 && cmarg2[y-1] == '/') || isdir(cmarg2)d #elsee
 #ifdef VMS 	    (y > 0) && isdir(cmarg2)" #elsex #ifdef STRATUS 	    (y > 0) && isdir(cmarg2)  #endif /* STRATUS */ #endif /* VMS */ #endif /* UNIX */o   #endif /* OS2 */ 	    ) {4 	    debug(F110,"RECEIVE arg disk or dir",cmarg2,0);6 	    if (s = zgtdir()) {		/* Get current directory, */= 		if (zchdir(cmarg2)) {	/* change to given disk/directory, */{> 		    strncpy(savdir,s,TMPDIRLEN); /* remember old disk/dir */+ 		    debug(F110,"tmpdir saving",savdir,0);e- 		    debug(F110,"tmpdir changing",cmarg2,0);). 		    f_tmpdir = 1;	/* and that we did this */6 		    cmarg2 = "";	/* and we don't have an as-name. */
 		} else {* 		    printf("?Can't access %s\n",cmarg2); 		    f_tmpdir = 0;  		    cmarg2 = ""; 		    return(-9);( 		}s
 	    } else {o+ 		printf("?Can't get current directory\n");p 		cmarg2 = ""; 		f_tmpdir = 0; 
 		return(-9);  	    } 	} #endif /* CK_TMPDIR */ #endif /* NOFRILLS */;       return(x); }+  
 #ifndef NOSPL+   /*   _ G E T A R G Sc  G   Used by XIF, FOR, and WHILE, each of which are implemented as 2-level(@   macros; the first level defines the macro, the second runs it.C   This routine hides the fact that they are macros by importing the{E   macro arguments (if any) from two levels up, to make them available E   in the XIF, FOR, and WHILE commands themselves; for example as loop    indices, etc.  */ int? dogta(cx) int cx; {")     int i; char c; char mbuf[4]; char *p;l       if ((y = cmcfm()) < 0)       return(y);     if (cx == XXGTA).       debug(F101,"_getargs maclvl","",maclvl);     else if (cx == XXPTA)c.       debug(F101,"_putargs maclvl","",maclvl);     else       return(-2);c     if (maclvl < 1)*       return(success = 0);  %     debug(F101,"success","",success);\  I     mbuf[0] = '%'; mbuf[1] = '0'; mbuf[2] = '\0'; /* Argument name buf */ 2     for (i = 0; i < 10; i++) {		/* For all args */% 	c = (char) i + '0';		/* Make name */m" 	mbuf[1] = c;			/* Insert digit */5 	if (cx == XXGTA) {		/* Get arg from level-minus-2 */uH 	    if (maclvl == 1) p = g_var[c]; /* If at level 1 use globals 0..9 */F 	    else p = m_arg[maclvl-2][i]; /* Otherwise they're on the stack */ 	    if (!p) {- 		debug(F111,"_getarg p","(null pointer)",i);e( 	    } else debug(F111,"_getarg p",p,i); 	    addmac(mbuf,p);1 	} else if (cx == XXPTA) {	/* Put args level+2 */T #ifndef MAC;+ 	    connoi();			/* Turn off interrupts. */T #endif /* MAC */( 	    maclvl -= 2;		/* This is gross.. */ 	    p = m_arg[maclvl+2][i]; 	    if (p)d4 	      debug(F111,"_putarg m_arg[maclvl+2][i]",p,i);	 	    elsefC 	      debug(F111,"_putarg m_arg[maclvl+2][i]","(null pointer)",i);C% 	    addmac(mbuf,m_arg[maclvl+2][i]);) 	    maclvl += 2;O #ifndef MACf3 	    conint(trap,stptrap);	/* Restore interrupts */. #endif /* MAC */ 	} else return(success = 0);     } (     debug(F101,"_get/putarg exit","",i);4     debug(F101,"_get/putarg exit maclvl","",maclvl); #ifdef COMMENT /*B   Internal commands don't change success variable if they succeed. */     return(success = 1); #elseN     return(1); #endif /* COMMENT */   }m #endif /* NOSPL */  
 #ifndef NOSPLn /*#   Do the GOTO and FORWARD commands.o?   s = Label to search for, cx = function code, XXGOTO or XXFWD.r */ intw  dogoto(s, cx) char *s; int cx; {     int i, j, x, y;\     char tmplbl[50], *lp;n        debug(F101,"goto cx","",cx);(     debug(F101,"goto cmdlvl","",cmdlvl);(     debug(F101,"goto maclvl","",maclvl);(     debug(F101,"goto tlevel","",tlevel);-     debug(F110,"goto before conversion",s,0);f     y = (int)strlen(s);/3     if (*s != ':') {			/* If the label mentioned */*= 	for (i = y; i > 0; i--) {	/* does not begin with a colon, */h+ 	    s[i] = s[i-1];		/* then insert one. */a' 	}				/* Also, convert to lowercase. */  	s[0] = ':'; 	s[++y] = '\0';,     }x,     debug(F111,"goto after conversion",s,y);3     if (s[1] == '.' || s[1] == SP || s[1] == NUL) { ( 	printf("?Bad label syntax - '%s'\n",s); 	return(success = 0);g     }      if (cmdlvl == 0) {@ 	printf("?Sorry, GOTO only works in a command file or macro\n"); 	return(success = 0);X     }	@     while (cmdlvl > 0) {		/* Only works inside macros & files */< 	if (cmdstk[cmdlvl].src == CMD_MD) { /* GOTO inside macro */ 	    int i, m, flag; 	    char *xp, *tp;n  E 	    /* GOTO: rewind the macro; FORWARD: start at current position */   7 	    lp = (cx == XXGOTO) ? macx[maclvl] : macp[maclvl];<! 	    m = (int)strlen(lp) - y + 1;r& 	    debug(F111,"goto in macro",lp,m);  4 	    flag = 1;			/* flag for valid label position */H 	    for (i = 0; i < m; i++,lp++) { /* search for label in macro body */6 		if (*lp == ',') {	/* Really should also watch out */4 		    flag = 1;		/* for braces here...  Commas in */6 		    continue;		/* in braces are not really commas */ 		} / 		if (flag) {		/* If in valid label position */ - 		    if (*lp == SP)	/* eat leading spaces */Y 		      continue;a7 		    if (*lp != ':') {	/* Look for label introducer *//  			flag = 0;	/* this isn't it */ 			continue;	/* keep looking */  		    }i 		})) 		if (!flag)		/* We don't have a label */z( 		  continue;		/*  so keep looking... */; 		xp = lp; tp = tmplbl;	/* Copy the label from the macro */x+ 		j = 0;			/* to make it null-terminated */( 		while (*tp = *xp) {S? 		    if (j++ > 50) break;  /* j = length of word from macro */ < 		    if (*tp < 33 || *tp == ',')	/* Look for end of word */ 		      break;+ 		    else tp++, xp++;	/* Next character */  		}p- 		*tp = '\0';		/* In case we stopped early */ ? 		/* Now do caseless string comparison, using longest length */ % 		debug(F111,"macro GOTO label",s,y);e, 		debug(F111,"macro target label",tmplbl,j);* 		if (!xxstrcmp(s,tmplbl,(y > j) ? y : j))
 		  break; 		else flag = 0; 	    }/ 	    if (i == m) {		/* didn't find the label */ 0 		debug(F101,"goto failed at cmdlvl","",cmdlvl);5 		if (!popclvl()) {	/* pop up to next higher level */?8 		    printf("?Label '%s' not found\n",s); /* if none */ 		    return(0);		/* quit */- 		} else continue;	/* otherwise look again */* 	    }/ 	    debug(F110,"goto found macro label",lp,0); 7 	    macp[maclvl] = lp;		/* set macro buffer pointer */  	    return(1);o+ 	} else if (cmdstk[cmdlvl].src == CMD_TF) {a, 	    x = 0;			/* GOTO issued in take file */7 	    if (cx == XXGOTO)		/* If GOTO, but not FORWARD, */ > 	      rewind(tfile[tlevel]);	/* search file from beginning */$ 	    while (! feof(tfile[tlevel])) {A 		if (fgets(line,LINBUFSIZ,tfile[tlevel]) == NULL) /* Get line */ 3 		  break;		/* If no more, done, label not found */c 		lp = line;		/* Got line */  		while (*lp == SP || *lp == HT)* 		  lp++;			/* Strip leading whitespace */< 		if (*lp != ':') continue; /* Check for label introducer */! 		tp = lp;		/* Get end of word */u 		j = 0;, 		while (*tp) {		/* And null-terminate it */ 		    if (*tp < 33) {= 			*tp = '\0';	 			break;  		    } else tp++, j++;  		}(? 		if (!xxstrcmp(lp,s,(y > j) ? y : j)) { /* Caseless compare *// 		    x = 1;		/* Got it */ 		    break;		/* done. */- 		}) 	    }5 	    if (x == 0) {		/* If not found, print message */r0 		debug(F101,"goto failed at cmdlvl","",cmdlvl);5 		if (!popclvl()) {	/* pop up to next higher level */18 		    printf("?Label '%s' not found\n",s);	/* if none */ 		    return(0);		/* quit */- 		} else continue;	/* otherwise look again */t 	    }- 	    return(x);			/* Send back return code */2 	}     })E     printf("?Stack problem in GOTO %s\n",s); /* Shouldn't see this */      return(0); }N #endif /* NOSPL */  ; /* Finish parsing and do the IF, XIF, and WHILE commands */    char * brstrip(p) char *p; {a     if (!p) return("");)     if (*p == '{') { 	int x;i 	x = (int)strlen(p) - 1; 	if (p[x] == '}') {f 	    p[x] = NUL;	 	    p++;l 	}     }      return(p); }e  
 #ifndef NOSPL  intr doif(cx) int cx; {     int x, y, z; char *s, *p;   5     not = 0;				/* Flag for whether "NOT" was seen */ (     z = 0;				/* Initial IF condition */4     ifargs = 0;				/* Count of IF condition words */   ifagain:H     if ((ifc = cmkey(iftab,nif,"","",xxstring)) < 0) { /* If what?... */ 	if (ifc == -3) { % 	    printf("?Condition required\n");/ 	    return(-9); 	} else return(ifc);     }?:     switch (ifc) {			/* set z = 1 for true, 0 for false */!       case XXIFNO:			/* IF NOT */m/ 	not ^= 1;			/* So NOT NOT NOT ... will work */,
 	ifargs++; 	goto ifagain;%       case XXIFSU:			/* IF SUCCESS */i 	z = ( success != 0 ); 	debug(F101,"if success","",z);n
 	ifargs += 1;, 	break;n%       case XXIFFA:			/* IF FAILURE */t 	z = ( success == 0 ); 	debug(F101,"if failure","",z);x
 	ifargs += 1;  	break;)%       case XXIFDE:			/* IF DEFINED */E< 	if ((x = cmfld("Macro or variable name","",&s,NULL)) < 0) { 	    if (x == -3) return(-2);2 	    else return(x); 	} #ifdef COMMENT$ 	strcpy(line,s);			/* Make a copy */.         if ((int)strlen(line) < 1) return(-2); 	lp = line;-A 	if (line[0] == CMDQ && (line[1] == '%' || line[1] == '&')) lp++;w+ 	if (*lp == '%')	{		/* Is it a variable? */l$ 	    x = *(lp + 1);		/* Fold case */, 	    if (isupper(x)) *(lp + 1) = tolower(x);F 	    if (x >= '0' && x <= '9' && maclvl > -1) /* Digit is macro arg */2 	      z = ( (m_arg[maclvl][x - '0'] != (char *)0)2 		   && (int)strlen(m_arg[maclvl][x - '0']) != 0);2 	    else			/* Otherwise it's a global variable */$ 	      z = ( (g_var[x] != (char *)0)& 		   &&  (int)strlen(g_var[x]) != 0 );/ 	} else if (*lp == '&') {	/* Array reference */  	    int cc, nn;" 	    if (arraynam(lp,&cc,&nn) < 0)
 	      z = 0;}0 	    else z = (arrayval(cc,nn) == NULL ? 0 : 1); 	} #else)+         if ((int)strlen(s) < 1) return(-2);e  	z = 0;				/* Assume failure. */7 	if (*s == CMDQ) {		/* Object begins with backslash. *// 	    char c;4 	    c = s[1];			/* Character following backslash */
 	    if (c) {r" 		c = islower(c) ? toupper(c) : c;( 		if (c == '%' ||		/* Simple variable */& 		    c == '&' ||		/* Array element */- 		    c == '$' ||		/* Environment variable */r/ 		    c == 'V' ||		/* Builtin named variable */i# 		    c == 'M' ||		/* Macro name */u) 		    c == 'F') {		/* Builtin function */e. 		    int t;		/* Let zzstring() evaluate it */6 		    t = LINBUFSIZ-1;	/* This lets us test \v(xxx) */+ 		    lp = line;		/* and even \f...(xxx) */d< 		    zzstring(s,&lp,&t);	/* Evaluate it, whatever it is. */- 		    t = strlen(line);	/* Get its length. */ " 		    debug(F111,"IF DEF",line,t);3 		    z = t > 0;		/* If length > 0, it's defined */  		}n 	    } 	} #endif /* COMMENT */+ 	else {			/* Otherwise it's a macro name */zC 	    z = ( mxlook(mactab,s,nmac) > -1 ); /* Look for exact match */t 	} 	debug(F111,"if defined",s,z);
 	ifargs += 2;t 	break;/  (       case XXIFBG:			/* IF BACKGROUND */,       case XXIFFG:			/* IF FOREGROUND */    ) 	bgchk();			/* Check background status */f% 	if (ifc == XXIFFG)		/* Foreground */e 	  z = pflag ? 1 : 0;p1         else z = pflag ? 0 : 1;		/* Background */M
 	ifargs += 1;f 	break;   #       case XXIFCO:			/* IF COUNT */F 	z = ( --count[cmdlvl] > 0 ); 8 	if (cx == XXWHI) count[cmdlvl] += 2; /* Don't ask... */ 	debug(F101,"if count","",z);*
 	ifargs += 1;  	break;e  #       case XXIFEX:			/* IF EXIST */  #ifdef CK_TMPDIR'       case XXIFDI:			/* IF DIRECTORY */a #endif /* CK_TMPDIR */ 	if ((x = cmfld(7 		       ((ifc == XXIFEX) ? "File" : "Directory name"),e 		       "",&s,d
 #ifdef OS21 		       NULL		/* This allows \'s in filenames */  #else, 		       xxstringc #endif /* OS2 */ 		       )) < 0) { 	    if (x == -3) {N/ 		printf("?File or directory name required\n");U
 		return(-9);t 	    } else return(x); 	} 	if (ifc == XXIFEX) {s 	    z = ( zchki(s) > -1L );# 	    debug(F101,"if exist 1","",z);m #ifdef OS2	     & 	    if (!z) {			/* File not found. */( 		int t;			/* Try expanding variables */+ 		t = LINBUFSIZ-1;	/* and looking again. */l 		lp = line; 		zzstring(s,&lp,&t);u 		s = line;  		z = ( zchki(s) > -1L );e  		debug(F101,"if exist 2","",z); 	    } #endif /* OS2 */ #ifdef CK_TMPDIR	 	} else {( 	    z = isdir(s)*
 #ifdef OS2  	      || (isalpha(cmarg2[0]) && 		  cmarg2[1] == ':' &&/ 		  cmarg2[2] == '\0') #endif /* OS2 */ 	      ;' 	    debug(F101,"if directory 1","",z);n  & 	    if (!z) {			/* File not found. */( 		int t;			/* Try expanding variables */+ 		t = LINBUFSIZ-1;	/* and looking again. */e 		lp = line; 		zzstring(s,&lp,&t);e 		s = line;/ 		z = isdir(s)
 #ifdef OS2 		  || (isalpha(cmarg2[0]) &&  		      cmarg2[1] == ':' &&o 		      cmarg2[2] == '\0') #endif /* OS2 */ 		    ;u$ 		debug(F101,"if directory 2","",z); 	    } #endif /* CK_TMPDIR */ 	}
 	ifargs += 2;, 	break;x  8       case XXIFEQ: 			/* IF EQUAL (string comparison) */1       case XXIFLL:			/* IF Lexically Less Than */n4       case XXIFLG:			/* If Lexically Greater Than */E 	if ((x = cmfld("first word or variable name","",&s,xxstring)) < 0) {m 	    if (x == -3) {  		printf("?Text required\n");k
 		return(-9);  	    } else return(x); 	}% 	s = brstrip(s);			/* Strip braces */p 	x = (int)strlen(s); 	if (x > LINBUFSIZ-1) { ' 	    printf("?IF: strings too long\n");l 	    return(-2); 	}- 	lp = line;			/* lp points to first string */  	strcpy(lp,s);F 	if ((y = cmfld("second word or variable name","",&s,xxstring)) < 0) { 	    if (y == -3) {g 		printf("?Text required\n"); 
 		return(-9);i 	    } else return(y); 	} 	s = brstrip(s); 	y = (int)strlen(s); 	if (x + y + 2 > LINBUFSIZ) {e' 	    printf("?IF: strings too long\n");* 	    return(-2); 	}3 	tp = lp + y + 2;		/* tp points to second string *// 	strcpy(tp,s);& 	debug(F111,"IF EQ string 1, x",lp,x);& 	debug(F111,"IF EQ string 2, y",tp,y);0 	if (inpcas[cmdlvl]) {		/* INPUT CASE OBSERVE */ 	    x = strcmp(lp,tp); % 	    debug(F101,"IF EQ strcmp","",x); $ 	} else {				/* INPUT CASE IGNORE */B 	    x = xxstrcmp(lp,tp,(y > x) ? y : x); /* Use longest length */' 	    debug(F101,"IF EQ xxstrcmp","",x);= 	} 	switch (ifc) { 5 	  case XXIFEQ: 			/* IF EQUAL (string comparison) */, 	    z = (x == 0); 	    break;I. 	  case XXIFLL:			/* IF Lexically Less Than */ 	    z = (x < 0);l 	    break; 1 	  case XXIFLG:			/* If Lexically Greater Than */n 	    z = (x > 0);( 	    break;u 	}
 	ifargs += 3;y 	break;*  0       case XXIFAE:			/* IF (arithmetically) = */0       case XXIFLT:			/* IF (arithmetically) < */2       case XXIFGT: {			/* IF (arithmetically) > */& 	/* Really should use longs here... */ 	/* But cmnum parses ints. */s 	int n1, n2;; 	x = cmfld("first number or variable name","",&s,xxstring);n 	if (x == -3) {c$ 	    printf("?Quantity required\n"); 	    return(-9); 	} 	if (x < 0) return(x);! 	debug(F101,"xxifgt cmfld","",x);/ 	lp = line;m 	strcpy(lp,s);  	debug(F110,"xxifgt exp1",lp,0); 	if (!xxstrcmp(lp,"count",5)) {d 	    n1 = count[cmdlvl];( 	} else if (!xxstrcmp(lp,"version",7)) { 	    n1 = (int) vernum; % 	} else if (!xxstrcmp(lp,"argc",4)) {r  	    n1 = (int) macargc[maclvl];	 	} else {*! 	    if (!chknum(lp)) return(-2);e 	    n1 = atoi(lp);e 	}< 	y = cmfld("second number or variable name","",&s,xxstring); 	if (y == -3) {a$ 	    printf("?Quantity required\n"); 	    return(-9); 	} 	if (y < 0) return(y);+         if ((int)strlen(s) < 1) return(-2);- 	x = (int)strlen(lp);m 	tp = line + x + 2;w 	strcpy(tp,s);  	debug(F110,"xxifgt exp2",tp,0); 	if (!xxstrcmp(tp,"count",5)) {e 	    n2 = count[cmdlvl];( 	} else if (!xxstrcmp(tp,"version",7)) { 	    n2 = (int) vernum;C% 	} else if (!xxstrcmp(tp,"argc",4)) {d  	    n2 = (int) macargc[maclvl];	 	} else {A! 	    if (!chknum(tp)) return(-2);m 	    n2 = atoi(tp);o 	}! 	debug(F101,"xxifft ifc","",ifc);e! 	z = ((n1 <  n2 && ifc == XXIFLT)n! 	  || (n1 == n2 && ifc == XXIFAE)m# 	  || (n1 >  n2 && ifc == XXIFGT));  	debug(F101,"xxifft n1","",n1);  	debug(F101,"xxifft n2","",n2);f 	debug(F101,"xxifft z","",z);o
 	ifargs += 3;m	 	break; }g  %       case XXIFNU:			/* IF NUMERIC */f7 	x = cmfld("variable name or constant","",&s,xxstring);E 	if (x == -3) {r$ 	    printf("?Quantity required\n"); 	    return(-9); 	} 	if (x < 0) return(x);  	debug(F111,"xxifnu cmfld",s,x); 	lp = line;c 	strcpy(lp,s);$ 	debug(F110,"xxifnu quantity",lp,0);         z = chknum(lp);2)         debug(F101,"xxifnu chknum","",z);2
 	ifargs += 2;  	break;   
 #ifdef ZFCDAT %       case XXIFNE: {			/* IF NEWER */g. 	char d1[20], * d2;		/* Buffers for 2 dates */5 	if ((z = cmifi("First file","",&s,&y,xxstring)) < 0) 
 	  return(z);i 	strcpy(d1,zfcdat(s));6 	if ((z = cmifi("Second file","",&s,&y,xxstring)) < 0)
 	  return(z);f 	d2 = zfcdat(s);6 	if ((int)strlen(d1) != 17 || (int)strlen(d2) != 17) {+ 	    printf("?Failure to get file date\n");  	    return(-9); 	}! 	debug(F110,"xxifnewer d1",d1,0);(! 	debug(F110,"xxifnewer d2",d2,0);n! 	z = (strcmp(d1,d2) > 0) ? 1 : 0;(%         debug(F101,"xxifnewer","",z);s
 	ifargs += 2;  	break;0       }s #endif /* ZFCDAT */	   #ifdef CK_IFRO/       case XXIFRO:			/* REMOTE-ONLY advisory */*
 	ifargs++;
 	z = remonly;	 	break;2 #endif /* CK_IFRO */  (       default:				/* Shouldn't happen */ 	return(-2);     }n>     if (not) z = !z;			/* Handle NOT here for both IF & XIF */  :     switch (cx) {			/* Separate handling for IF and XIF */  &       case XXIF:			/* This is IF... */: 	ifcmd[cmdlvl] = 1;		/* We just completed an IF command */(         debug(F101,"IF condition","",z);# 	if (z) {			/* Condition is true */ : 	    iftest[cmdlvl] = 1;		/* Remember that IF succeeded */( 	    if (maclvl > -1) {		/* In macro, */) 		pushcmd();		/* save rest of command. */s2 	    } else if (tlevel > -1) {	/* In take file, */. 		debug(F100, "doif: pushing command", "", 0);) 		pushcmd();		/* save rest of command. */l% 	    } else {			/* If interactive, */d0 		cmini(ckxech);		/* just start a new command */. 		printf("\n");		/* (like in MS-DOS Kermit) */ 		if (pflag) prompt(xxstring); 	    }$ 	} else {			/* Condition is false */8 	    iftest[cmdlvl] = 0;		/* Remember command failed. */= 	    if ((y = cmtxt("command to be ignored","",&s,NULL)) < 0)t/ 	      return(y);		/* Gobble up rest of line */- 	} 	return(0);l  5       case XXIFX: {			/* This is XIF (Extended IF) */u 	  char *p;c
 	  char e[5];b	 	  int i;;4 	  if ((y = cmtxt("Object command","",&s,NULL)) < 0)+ 	    return(y);			/* Get object command. */l	 	  p = s;c
 	  lp = line;0= 	  if (litcmd(&p,&lp) < 0) {	/* Insert quotes in THEN-part */c 	      return(-2); 	  }* 	  if (!z) {			/* Use ELSE-part, if any */. 	      lp = line;		/* Write over THEN part. */ 	      *lp = NUL; 8 	      while (*p == SP) p++;	/* Strip trailing spaces */  	      if (*p) {			/* At end? */A 		  for (i = 0; i < 4; i++) e[i] = *p++; /* No, check for ELSE */i@ 		  if (xxstrcmp(e,"else",4)) return(-2);	/* No, syntax error */1 		  if (litcmd(&p,&lp) < 0) { /* Insert quotes */o 		      return(-2);e 		  } 5 		  while (*p == SP) p++;	/* Strip trailing spaces */p5 		  if (*p) return(-2);	/* Should be nothing here. */, 	      } 	  } 	  if (line[0]) { F 	      x = mlook(mactab,"_xif",nmac); /* get index of "_xif" macro. */& 	      if (x < 0) {			/* Not there? *// 		  addmmac("_xif",xif_def);	/* Put it back. */c@ 		  if (mlook(mactab,"_xif",nmac) < 0) { /* Look it up again. */% 		      printf("?XIF macro gone!\n");  		      return(success = 0); 		  }; 	      }, 	      dodo(x,line);		/* Do the XIF macro */ 	  }
 	  return(0);        }c)       case XXWHI: {			/* WHILE Command */e+ 	  p = cmdbuf;			/* Capture IF condition */s. 	  ifcond[0] = NUL;		/* from command buffer */ 	  while (*p == SP) p++; 	  while (*p != SP) p++; 	  ifcp = ifcond;m# 	  strcpy(ifcp,"{ \\flit(if not ");  	  ifcp += (int)strlen(ifcp);D1 	  while (*p != '{' && *p != NUL) *ifcp++ = *p++;  	  p = " goto bot) } ";r 	  while (*ifcp++ = *p++) ;u$ 	  debug(F110,"WHILE cmd",ifcond,0);  4 	  if ((y = cmtxt("Object command","",&s,NULL)) < 0)+ 	    return(y);			/* Get object command. */"	 	  p = s; 
 	  lp = line;"B 	  if (litcmd(&p,&lp) < 0) {	/* Insert quotes in object command */ 	      return(-2); 	  }# 	  debug(F110,"WHILE body",line,0);  	  if (line[0]) {b 	      char *p;,F 	      x = mlook(mactab,"_while",nmac); /* index of "_while" macro. */% 	      if (x < 0) {		/* Not there? */+2 		  addmmac("_while",whil_def); /* Put it back. */A 		  if (mlook(mactab,"_while",nmac) < 0) { /* Look it up again */ 2 		      printf("?WHILE macro definition gone!\n"); 		      return(success = 0); 		  }l 	      }? 	      p = malloc((int)strlen(ifcond) + (int)strlen(line) + 2);  	      if (p) {  		  strcpy(p,ifcond);  		  strcat(p,line);l! 		  debug(F110,"WHILE dodo",p,0);i 		  dodo(x,p); 		  free(p); 	      } else {d8 		  printf("?Can't allocate storage for WHILE command"); 		  return(success = 0); 	      } 	  }
 	  return(0);        }*       default: 	return(-2);     }[ }l #endif /* NOSPL */    /* Set up a TAKE command file */   intd dotake(s) char *s; {3     if ((tfile[++tlevel] = fopen(s,"r")) == NULL) {l 	perror(s); # 	debug(F110,"Failure to open",s,0);*
 	success = 0;e
 	tlevel--;     } else {
 #ifdef VMS& 	conres();			/* So Ctrl-C will work */ #endif /* VMS */
 #ifndef NOSPL./ 	cmdlvl++;			/* Entering a new command level */r 	if (cmdlvl > CMDSTKL) { 	    cmdlvl--;B 	    printf("?TAKE files and/or DO commands nested too deeply\n"); 	    return(success = 0);o 	}@ 	if (tfnam[tlevel]) free(tfnam[tlevel]);	/* Copy the filename */+ 	if (tfnam[tlevel] = malloc(strlen(s) + 1))/ 	  strcpy(tfnam[tlevel],s); : 	ifcmd[cmdlvl] = 0;		/* Set variables for this cmd file */ 	iftest[cmdlvl] = 0;6 	count[cmdlvl]  = count[cmdlvl-1];  /* Inherit this */6 	intime[cmdlvl] = intime[cmdlvl-1]; /* Inherit this */6 	inpcas[cmdlvl] = inpcas[cmdlvl-1]; /* Inherit this */6 	takerr[cmdlvl] = takerr[cmdlvl-1]; /* Inherit this */6 	merror[cmdlvl] = merror[cmdlvl-1]; /* Inherit this */< 	cmdstk[cmdlvl].src = CMD_TF;	/* Say we're in a TAKE file */8 	cmdstk[cmdlvl].lvl = tlevel;	/* nested at this level */ #elses6 	takerr[tlevel] = takerr[tlevel-1]; /* Inherit this */ #endif /* NOSPL */     }      return(1); }  #endif /* NOICP */