 /* written by:    Nigel R. Arnot,6    dept. Physics, Kings College, London WC2R 2LS, U.K.C    NRA@UK.AC.KCL.PH.IPG     NRA%UK.AC.KCL.PH.IPG@nsfnet-relay.ac.uk  */$ /* Copyright (C) 1993 Nigel R. Arnot  G This program is free software; you can redistribute it and/or modify it E under the terms of the GNU General Public License as published by the  Free Software Foundation.   ? This program is distributed in the hope that it will be useful, ? but WITHOUT ANY WARRANTY; without even the implied warranty of  @ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU( General Public License for more details.  < This distribution should have come with a copy of the GPL inE file COPYING.TXT. If not, write to the Free Software Foundation inc., ' 675 Mass Ave, Cambridge, MA 02139, USA.    */    K /* philosophy: creation and access to symbols is made fast by a hash table. J    symbols are linked as circular double-link list for later access to all@     of them: can sort into another order once all adding done */   #include "symdefs.h" #include <stdlib>  #include <string>    /* initialize a symbol table */ . struct symtable * init_sym_table( int nhash) {   	    int i;     struct symtable * tbl;    &    tbl = ( struct symtable *) malloc( P                   sizeof( struct symtable) + sizeof( struct symbol *) * nhash );    if( tbl != 0) {       tbl -> nhash = nhash;        tbl -> nsym = 0;K                                       /* circular double-linked list ... */ D       tbl -> flink = tbl -> blink = (struct symbol *) &(tbl->flink);  5       for (i=0; i<nhash; ++i) (tbl -> hheads)[i] = 0;     };     return( tbl); };  H /* find a symbol. Returns pointer to symbol if it exists, NULL if not */  D struct symbol *  find_symbol ( struct symtable * tbl, char * name) {  ,    struct symbol * sym; struct symbol * prv;
    int nh;    char *c1, *c2;   %    nh = hashsym( name, tbl -> nhash); $    sym = tbl -> hheads[nh]; prv = 0;
    while(1) {        if( sym == 0) return(0);       c1 = &( sym -> name)[0];       c2 = name;       while( 1) {          if (*c1 != *c2) break;L         if (*c1 == 0 && *c2 == 0){   /* both strings terminate same place */             K            /* optimisation: promote sym to the front of the hash list. This L            promotes frequently accessed symbols if a hash list gets crowded,0            and also makes del_symbol easier   */                     if( prv != 0) {# 	      prv -> hlink = sym -> hlink; /               sym -> hlink = tbl -> hheads[nh]; &               tbl -> hheads[nh] = sym;
            };             return( sym ); 
         };         c1++; c2++;        };$       prv = sym; sym = sym -> hlink;    };  };  M /* copies maximum of nbytes from the symbol's data area. Returns actual count L    of bytes read, or zero for non-existent symbol                         */  O int read_symbol (struct symtable * tbl, char * name, void * data, int nbytes) {   	    int n;     struct symbol * sym;   <    sym  = find_symbol( tbl, name);  if( sym == 0) return(0);     /    n = sym->ndata; if( n > nbytes) n = nbytes;    3    memcpy( data, &(sym -> name)[ sym -> doff],  n); 
    return(n);  };  M /* sets up a symbol with an nbytes data area copied from data. Returns nbytes $    normally, zero if malloc fails */  N int set_symbol  (struct symtable * tbl, char * name, void * data, int nbytes){     struct symbol * sym;
   int len, n;   8   len = strlen( name) + 1; /* include terminator null */  N   /* we want to align the stored data on a 4-byte boundary. Calculate header ++    name allocation, round up, add nbytes */   P   n = sizeof( struct symbol) + len - 2; /* 2 bytes included in structure defn */   n = ( ( n+3) >>2 ) <<2;    sym = malloc( n + nbytes);   if( sym == 0) return(0);  M   sym -> doff = n - sizeof( struct symbol) + 2; /* add back the two bytes! */    sym -> ndata = nbytes;-   memcpy( &sym->name[0],          name, len); 1   memcpy( &sym->name[ sym->doff], data, nbytes );   "   n = hashsym(name, tbl -> nhash);A   sym -> hlink = (tbl -> hheads)[n];   /* link into hash chain */    (tbl -> hheads)[n] = sym;    G   tbl->nsym = tbl->nsym + 1;           /* link into double link list */    sym -> flink = tbl -> flink;     tbl -> flink = sym; (   sym -> blink = (sym->flink) -> blink;    (sym->flink) -> blink = sym;   };  P /* deletes the named symbol. Returns 1 on success, 0 failure (no such symbol) */6 int del_symbol  (struct symtable * tbl, char * name ){      struct symbol * sym; 
    int nh;  <    sym  = find_symbol( tbl, name);  if( sym == 0) return(0);O    /* note: sym is now at the head of its hash list, see find_symbol comment */   %    nh = hashsym( name, tbl -> nhash); M    tbl -> hheads[nh] = sym->hlink;       /* unhitch ourself from hash chain*/      P    (sym->blink)->flink = sym->flink;     /* unhitch ourself from all-sym list */$    (sym->flink)->blink = sym->blink;     ?    free(sym);                            /* free our storage */ '    tbl->nsym = tbl->nsym - 1;            };     /* internal routines */   J int hashsym( char * name , int nhash) { /* 15 char limit stops overflow */     int i, h;      h = *name++;J   for( i = 1; i<15; ++i) { if (*name == 0) break; h = h * 3 + *name++; };    return( h % nhash);  };    M /* debug routine (also example): walk chain of allocated symbols printing out =    all of their names and value, assuming it to be a long int  */   #include <stdio>& void dump_tbl( struct symtable *tbl) {      struct symbol * sym; 	    int i;     int val;     char * nam;      printf("\n");      sym = tbl -> flink;  &    for( i = 1; i <= tbl->nsym; ++i) {         nam = &sym->name[0]; 7        val = *( (long int *) (&sym->name[sym->doff]) ); %        printf("%s = %d\n", nam, val);         sym = sym->flink;    };  };  ' void dump_hash( struct symtable *tbl) {       struct symbol *sym;    char * nam;	    int i;       printf("\n");  %    for( i = 0; i < tbl->nhash; ++i) {         printf("%d :", i);       sym = tbl->hheads[i];        while( sym != 0) {         nam = &sym->name[0];         printf("-> %s", nam);        sym = sym->hlink;      };       printf("\n");    };  };    