#! /bin/sh

echo " "
#
#
# *****************************************************************
# *                                                               *
# *    Copyright (c) Compaq Computer Corporation, 1997-1999       *
# *                                                               *
# *   All Rights Reserved.  Unpublished rights  reserved  under   *
# *   the copyright laws of the United States.                    *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Digital   *
# *   Equipment Corporation.  Possession, use,  duplication  or   *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Digital Equipment  *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
#
# Description:  install.sh
#               Compaq SANworks Command Scripter ${CMDSCRDOTVER} for
#               Tru64 and Solaris installation script
#
#               Root privileges are required to run this script.
#

##################################################################
# Function to process the user's response with help if needed    #
##################################################################
read_input()
{
   [ -z "$2" ] && _prompt="$1 [ ? ]: "
   [ -n "$2" ] && _prompt="$1 [ $2 ] [ ? ]: "
   [ -n "$3" -a -z "$2" ] && _prompt="$1 [ ? ](default= $3): "
   [ -n "$3" -a -n "$2" ] && _prompt="$1 [ $2 ] [ ? ](default= $3): "
   case $_prompt in
      ??????????????????????????????????????????????????????????????????*)
         [ -z "$2" ] && _prompt="$1${newline} [ ? ]: "
         [ -n "$2" ] && _prompt="$1${newline} [ $2 ] [ ? ]: "
         [ -n "$3" -a -z "$2" ] && _prompt="$1${newline} [ ? ](default= $3): "
         [ -n "$3" -a -n "$2" ] && _prompt="$1${newline} [ $2 ] [ ? ](default= $3): "
      ;;
   esac
   while true
   do
      echo "$_prompt\c"
      read input
      newinput="`echo ${input}`"
      case $newinput in
         "")
            input=$3; return 0
            ;;
         '?'|h|help)
            help_input "$4"; continue
            ;;
         *) input=${newinput}; return ${input}
            ;;
      esac
   done
}

##################################################################
# Function to process the user's response with help if needed    #
##################################################################
YesOrNo()
{
   [ -z "$2" ] && _prompt="$1 [ ? ]: "
   [ -n "$2" ] && _prompt="$1 [ $2 ] [ ? ]: "
   [ -n "$3" -a -z "$2" ] && _prompt="$1 [ ? ](default= $3): "
   [ -n "$3" -a -n "$2" ] && _prompt="$1 [ $2 ] [ ? ](default= $3): "
   case $_prompt in
      ??????????????????????????????????????????????????????????????????*)
         [ -z "$2" ] && _prompt="$1${newline} [ ? ]: "
         [ -n "$2" ] && _prompt="$1${newline} [ $2 ] [ ? ]: "
         [ -n "$3" -a -z "$2" ] && _prompt="$1${newline} [ ? ](default= $3): "
         [ -n "$3" -a -n "$2" ] && _prompt="$1${newline} [ $2 ] [ ? ](default= $3): "
      ;;
   esac
   while true
   do
      echo "$_prompt\c"
      read input
      newinput="`echo ${input} | tr '[:upper:]' '[:lower:]'`"
      case $newinput in
         "")
            input=$3; return 0
            ;;
         '?'|h|help)
            help_input "$4"; continue
            ;;
         y|yes)
            input="yes"; return 0
            ;;
         n|no)
            input="no"; return 0
            ;;
         c|client)
            input="client"; return 0
            ;;
         s|server)
            input="server"; return 0
            ;;
         *)
            ;;
      esac
   done
}

help_input()
{

  case "$1" in
   STOPCMDSCR)  cat<<EOF

   If the Command Scripter daemon is currently running, then the daemon
   must be stopped before continuing with ${ScriptName}. Please stop the
   daemon and then continue with ${ScriptName}.

EOF
   ;;
   LicenseAgree) cat<<EOF

If you agree to the terms, enter yes then <enter>. If you do not agree to the terms,
enter no then <enter>, which will also terminate your installation procedure. If
you do not agree to these terms, COMPAQ does not grant you a license to use the
Software.  In this case you may not use the Software and you should contact the
supplier from which you obtained the Software for instructions on returning the
Software for a refund.

EOF
   ;;
   DOIT)  cat<<EOF

   An alphanumeric response is not required. Pressing any key will take you
   to the License terms display.

EOF
   ;;
   esac
}

##################################################################
# Confirm Copyright                                              #
##################################################################
ConfirmCopyright()
{
  ${CLEAR}
  cat <<EOREAD

Welcome to the Compaq SANworks Command Scripter (CMDSCR) version ${PREFIX}${CMDSCRDOTVER}
installation script. This script will install CMDSCR on your computer.

CONVENTIONS:
Throughout this installation, messages which require input are displayed
(such as: Are you are ready to continue? [ y|n ] [ ? ](default= yes):).
The "y|n" indicates that a yes or no answer is required and the
"default= yes" indicates that pressing the ENTER key will accept the yes
answer. The "?" indicates that installation help is available. Pressing
the ? key and then the ENTER key displays a help message and repeats the
original question.

IMPORTANT: Carefully read the License Agreement terms before proceeding.
The "more" command is used to display the License Terms. Use <Enter> to
move one line down, <spacebar> to page down, or <b> to page up. Enter
<q> to quit.

EOREAD
  YesOrNo "Press the Enter key to continue" "" "" "DOIT"
  more licenseTerms.txt
  cat <<EOAGREE

If you agree to the terms, enter "y" then <enter>.

If you do not agree to the terms, enter "n" then <enter>, which will
also terminate your installation procedure. If you do not agree to these
terms, COMPAQ does not grant you a license and you may not use the Software.
You should contact the supplier from which you obtained this Software for
instructions on returning the Software for a refund.

EOAGREE
  YesOrNo "Do you agree to the terms?" "y|n" "yes" "LicenseAgree"
  if [ "${input}" = "no" ]; then
     echo
     echo "Aborting ${ScriptName}"
     sleep 1
     exit
  fi
}

##################################################################
# tru64 install                                                  #
##################################################################
Tru64Inst()
{
  cd ${StartDir}
  # install CPQcmdscr
  if [ -d /usr/opt/CPQcmdscr ]; then
    rm -rf /usr/opt/CPQcmdscr
  fi
  ${CLEAR}
  echo "Starting to install Command Scripter...."
  echo
  if [ "${OSMAJOR}" = "5" ]; then
    setld -l ./Tru64V5Kit CPQCMDSCR${CMDSCRVER}
  else
    setld -l ./Tru64V4Kit CPQCMDSCR${CMDSCRVER}
  fi
}

DoLinks()
{
  rm -f /sbin/init.d/cmdscr
  rm -f /sbin/rc3.d/S89cmdscr
  rm -f /sbin/rc2.d/K89cmdscr
  rm -f /sbin/rc0.d/K89cmdscr
  cp -p /usr/opt/CPQcmdscr/rc3.d/S89cmdscr /sbin/init.d/cmdscr
  cd /sbin/rc3.d; ln -fs ../init.d/cmdscr ./S89cmdscr
  cd /sbin/rc2.d; ln -fs ../init.d/cmdscr ./K89cmdscr
  cd /sbin/rc0.d; ln -fs ../init.d/cmdscr ./K89cmdscr
  cd ${StartDir}
}

##################################################################
# Prompt the user to start the cmdscr script                        #
##################################################################
StartCommandScripter()
{
  if [ -f /sbin/rc3.d/S89cmdscr ]; then
    /sbin/rc3.d/S89cmdscr start
  else
    /sbin/rc3.d/S48cmdscr start
  fi
}

##################################################################
# Main processing                                                #
##################################################################
# Two things we need up front are platform and user is root      #
##################################################################
if [ -f /usr/bin/uname ]; then
  OS=`/usr/bin/uname -s`;export OS
elif [ -f /bin/uname ]; then
  OS=`/bin/uname -s`;export OS
else
  OS=`uname -s > /dev/null`;export OS
fi
if [ -f /usr/bin/basename ]; then
   ScriptName=`/usr/bin/basename $0`;export ScriptName
elif [ -f /bin/basename ]; then
   ScriptName=`/bin/basename $0`;export ScriptName
else
   ScriptName=`basename $0 > /dev/null`;export ScriptName
fi

if [ -f /bin/whoami ]; then
   whoami=`/bin/whoami`;export whoami
elif [ -f /usr/ucb/whoami ]; then
     whoami=`/usr/ucb/whoami`;export whoami
else
     whoami=`whoami > /dev/null`;export whoami
fi

if [ -z "${OS}" ]; then
  echo "The integral command uname can not be found. Exiting $0"
  exit 1
elif [ -z "${ScriptName}" ]; then
  echo "The integral command basename can not be found. Exiting $0"
  exit 1
else 
  if [ -z "${whoami}" ]; then
   echo "The integral command whoami can not be found. Exiting $0"
   exit 1
  fi
fi

if [ "${whoami}" != "root" ]; then
  echo "${ScriptName} can be used by super-user only. Exiting ${ScriptName}"
  exit 1
fi

##################################################################
# Generic variables not based upon platform                      #
##################################################################
PREFIX=V;export PREFIX
CMDSCRVER=101;export CMDSCRVER
CMDSCRDOTVER=1.0A;export CMDSCRDOTVER
StartDir=`pwd`;export StartDir
TMP=/tmp;export TMP

##################################################################
# Host specific variables                                        #
##################################################################
if [ "${OS}" = "OSF1" ]; then
  if [ ! -f /var/opt/CPQcmdscr/bin/install_info ];then
    echo "Command Scripter V1.0 must exist to install this update. Exiting $0"
    exit 1
  fi
  CMDSCRHome=/usr/opt/CPQcmdscr; export CMDSCRHome
  OSMAJOR=`cat /usr/sys/conf/version.major 2> /dev/null`;export OSMAJOR
  OSMINOR=`cat /usr/sys/conf/version.minor 2> /dev/null`;export OSMINOR
  OSVARIANT=`cat /usr/sys/conf/version.variant 2> /dev/null`;export OSVARIANT
  OSVERSION=`cat /usr/sys/conf/version.type 2> /dev/null`;export OSVARIANT
  OSBUILD=`cat /usr/sys/conf/version.build 2> /dev/null`; export OSBUILD
  SETLDPath="${StartDir}/tru64";export SETLDPath
  OS=`uname -s`
  FGREP="/bin/fgrep -s"
  CLEAR="/bin/clear"
  if [ ${OSMAJOR} -ne 5 ]; then
    echo "This script executes on a Tru64 V5.0 or above only. Exiting this script"
    exit 1
  fi
else
  echo "${ScriptName} can only be used on a Compaq Tru64 host. Exiting ${ScriptName}"
  exit 1
fi

ConfirmCopyright
[ -f ${StartDir}/ckinst.sh ] && ${StartDir}/ckinst.sh
FirstErrorCode=$?
if [ ${FirstErrorCode} -eq 3 ]; then
  echo "Error 1 returned from ckinst.sh. Exiting $0"
  exit 1
else
  if [ ${FirstErrorCode} -eq 99 ]; then
    exit 1
  fi
fi
Tru64Inst
DoLinks
StartCommandScripter
echo
echo
echo "Installation complete"
echo
echo "Please consult the release notes before running Command Scripter."
echo
exit 0
