#!/bin/sh

##################################################################
# Function to process the user's response with help if needed    #
##################################################################
YesOrNo()
{
   [ -z "$2" ] && _prompt="$1 [ ? ]: "
   [ -n "$2" ] && _prompt="$1 [ $2 ] [ ? ]: "
   [ -n "$3" -a -z "$2" ] && _prompt="$1 [ ? ](default= $3): "
   [ -n "$3" -a -n "$2" ] && _prompt="$1 [ $2 ] [ ? ](default= $3): "
   case $_prompt in
      ??????????????????????????????????????????????????????????????????*)
         [ -z "$2" ] && _prompt="$1${newline} [ ? ]: "
         [ -n "$2" ] && _prompt="$1${newline} [ $2 ] [ ? ]: "
         [ -n "$3" -a -z "$2" ] && _prompt="$1${newline} [ ? ](default= $3): "
         [ -n "$3" -a -n "$2" ] && _prompt="$1${newline} [ $2 ] [ ? ](default= $3): "
      ;;
   esac
   while true
   do
      echo "$_prompt\c"
      read input
      newinput="`echo ${input} | tr '[:upper:]' '[:lower:]'`"
      case $newinput in
         "")
            input=$3; return 0
            ;;
         '?'|h|help)
            help_input "$4"; continue
            ;;
         y|yes)
            input="yes"; return 0
            ;;
         n|no)
            input="no"; return 0
            ;;
         c|client)
            input="client"; return 0
            ;;
         s|server)
            input="server"; return 0
            ;;
         *)
            ;;
      esac
   done
}

help_input()
{
  case "$1" in
   REMOVECMDSCR)  cat<<EOF

   Command Scripter can be automatically removed by ${ScriptName}. If you answer yes to
   this question then Command Scripter ${CMDSCRINST} will be removed. If you answer no to
   this question then ${ScriptName} will exit.

EOF
   ;;
   STOPCMDSCR)  cat<<EOF

   If the Command Scripter daemon is currently running, then the daemon
   must be stopped before continuing with ${ScriptName}. Please stop the
   daemon and then continue with ${ScriptName}.

EOF
   ;;
   esac
}

##################################################################
# Determine if the cmdscr script is running                         #
##################################################################
CheckCMDSCRPid()
{
  ${CLEAR}
  cmdscrcount=0
  while [  -n "`ps -e | grep cmdscrip | grep -v grep | awk '{print $1}'`" ]; do
    echo "Stopping the Command Scripter daemon"
    cmdscrpid=`ps -e | grep cmdscrip | grep -v grep | awk '{print $1}'`
    if [ -f /etc/rc3.d/S31cmdscr ]; then
      /etc/rc3.d/S31cmdscr stop
      sleep 2
     fi
  done
}

##################################################################
# Check for preinstallation dependencies                         #
##################################################################
SolarisPreInstallCheck()
{
  if [ ! -f /opt/CPQcmdscr/bin/install_info ]; then
    cat <<EOF

This is an update to Command Scripter V1.0 which must be installed. Exiting $0

EOF
    exit 3
  else
    cat <<EOF

This Command Scripter update will replace the V1.0 files in /opt/CPQcmdscr.
Answer yes to allow this script to replace Command Scripter V1.0

EOF
    YesOrNo "Allow this script to replace Command Scripter V1.0?" "y|n" "yes" "REMOVECMDSCR"
    if [ "${input}" = "yes" ]; then
      CheckCMDSCRPid
      rm -rf /opt/CPQcmdscr
    else
      exit 99
    fi
  fi
  ELMINST=`/usr/bin/pkginfo -l CPQelm 2>/dev/null | grep VERSION | grep -v grep | awk '{print $2}'`;export ELMINST
  if [ -n "${ELMINST}" ]; then
    if [ "${ELMINST}" = "${CMDSCRDOTVER}" ]; then
      cat <<EOF
  
ELM ${ELMINST} is installed. If you want to reinstall
Command Scripter ${CMDSCRINST} then two options exist:
- Stop the Command Scripter daemon , select no to exit this script, and then remove
  Command Scripter ${CMDSCRINST} by performing /usr/sbin/pkgrm CPQcmdscr and then
  rerun this script again
- Stop the Command Scripter daemon and answer yes to allow this script to remove
  Command Scripter ${PREFIX}${CMDSCRINSTDOTVER}

EOF
      YesOrNo "Allow this script to remove Command Scripter ${CMDSCRINST}?" "y|n" "yes" "REMOVECMDSCR"
      if [ "${input}" = "yes" ]; then
        CheckCMDSCRPid
        /usr/sbin/pkgrm CPQcmdscr
        if [ $? -ne 0 ]; then
          echo "Error removing CMDSCR ${CMDSCRINST}. Exiting ${ScriptName}"
          exit 3
        fi
      else
        exit 99
      fi
    fi
  fi
}

###############################################################################
# Miscellaneous info                                                          #
###############################################################################
if [ -f /usr/bin/uname ]; then
  OS=`/usr/bin/uname -s`;export OS
elif [ -f /bin/uname ]; then
  OS=`/bin/uname -s`;export OS
else
  OS=`uname -s > /dev/null`;export OS
fi

###############################################################################
# Call this script CheckInstall.sh instead of ./CheckInstall.sh               #
###############################################################################
if [ -f /usr/bin/basename ]; then
   ScriptName=`/usr/bin/basename $0`;export ScriptName
elif [ -f /bin/basename ]; then
   ScriptName=`/bin/basename $0`;export ScriptName
else
   ScriptName=`basename $0 > /dev/null`;export ScriptName
fi

###############################################################################
# OS specific variables                                                       # 
###############################################################################
PREFIX=V;export PREFIX
CMDSCRDOTVER=1.0A;export CMDSCRDOTVER
StartDir=`pwd`;export StartDir
if [ "${OS}" = "SunOS" ]; then
  if [ -f /var/sadm/pkg/CPQcmdscr/pkginfo ]; then
    CMDSCRHome=`/usr/bin/pkginfo -l CPQcmdscr | grep BASEDIR | cut -f 2 -d: | awk '{print $1}'`
  else
    CMDSCRHome=/opt/CPQcmdscr;export CMDSCRHome
  fi
  CMDSCR=CPQcmdscr-${CMDSCRDOTVER};export CMDSCR
  CLEAR="/usr/bin/clear";export CLEAR
else
  echo "${ScriptName} can only be used on a SUN Solaris host. Exiting $0"
  exit 1
fi

###############################################################################
# Call the correct preinstall check                                           #
###############################################################################
if [ "${OS}" = "SunOS" ]; then
  SolarisPreInstallCheck
else
  echo "${ScriptName} can only be used on a SUN Solaris host"
fi

echo "Returning to install.sh"
