/* Call dbms_registry.upgrade This is always the first call in Upgrade */
declare
  version_str             varchar2(1000) := '';
  compatibility_str       varchar2(1000) := '';
begin
   dbms_utility.db_version(version_str,compatibility_str);
   version_str := sys.wm$convertDbVersion(version_str);
   if (version_str >= '9.2.0.0.0') then
     execute immediate 'begin dbms_registry.upgrading(''OWM'', new_proc=>''VALIDATE_OWM''); end;' ;
   end if;
end;
/
/* We added OIDs to object types for AQs as import/export bug-fix. To ensure
 * that objects are recreated with new OIDs, we have to drop the dependent
 * tables. So, uinstall AQs. They will be reinstalled as part of the upgrade.
 */
declare
  owm_curr_version   varchar2(50) ;
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);
  if (version_str >= 'A.0.0.0.0') then
    purgeOption := ' PURGE' ;
  end if ;
  select sys.wm$convertDBVersion(value) into owm_curr_version
  from wm_installation
  where name = 'OWM_VERSION';
  if ( owm_curr_version >= '9.2.0.0.0' and owm_curr_version < '9.2.0.4.0') then
    begin
      dbms_aqadm.stop_queue(
        queue_name => 'WMSYS.WM$EVENT_QUEUE');
      dbms_aqadm.drop_queue(
        queue_name => 'WMSYS.WM$EVENT_QUEUE');
      dbms_aqadm.drop_queue_table(
        queue_table => 'WMSYS.WM$EVENT_QUEUE_TABLE',
        force => true);
      execute immediate 'drop public synonym wm_events_info' ;
      execute immediate 'drop view wmsys.wm_events_info' ;
      execute immediate 'drop table wmsys.wm$events_info' || purgeOption ;
      execute immediate 'drop type wmsys.wm$event_type' ;
      execute immediate 'drop type wmsys.wm$nv_pair_nt_type' ;
      execute immediate 'drop type wmsys.wm$nv_pair_type' ;
    exception when others then null; 
    end;
  end if ;
end;
/
/* --------------------------------------------------------------------- */
/* Create package specs                                                  */
/* --------------------------------------------------------------------- */
@@owmcpkgs.plb
/* --------------------------------------------------------------------- */
/* Will Create all the views, etc.                                       */
/* --------------------------------------------------------------------- */
column v_file_name new_value v_file noprint;
var owm_version varchar2(30);
var owm_v_script varchar2(30);
begin
  select sys.wm$convertDBVersion(value) into :owm_version from wm_installation where name = 'OWM_VERSION';
  if (:owm_version = '9.0.1.4.0') then :owm_v_script := 'owmv9014.plb' ;
  elsif (:owm_version >= '9.2.0.1.0' and :owm_version < '9.2.0.4.0') then :owm_v_script := 'owmv920.plb' ;
  elsif (:owm_version >= 'A.0.0.0.0' and :owm_version < 'A.1.0.2.0') then :owm_v_script := 'owmv1010.plb' ;
  elsif ((:owm_version >= '9.0.1.5.0' and :owm_version <= '9.0.1.5.0') or
         (:owm_version >= '9.2.0.4.0' and :owm_version <= '9.2.0.4.0') or
         (:owm_version >= 'A.1.0.2.0' and :owm_version <= 'A.1.0.4.0') ) then :owm_v_script := 'owmv1012.plb' ;
  else :owm_v_script := 'nothing.sql' ;
  end if;
end;
/
select :owm_v_script AS v_file_name from dual;
@@&v_file
/* --------------------------------------------------------------------- */
/* Create package body                                                   */
/* --------------------------------------------------------------------- */
@@owmcpkgb.plb
/* Init the old owm version - somethings in migration depend on that */
begin
 sys.owm_mig_pkg.old_owm_version_for_upgrade := :owm_version ;
end;
/
/* --------------------------------------------------------------------- */
/* Light-weight EnableVersion the tables.                                */
/* --------------------------------------------------------------------- */
execute sys.owm_mig_pkg.AllLwEnableVersioning ;
execute sys.ltric.recreatePtUpdDelTriggers;
execute sys.owm_mig_pkg.moveWMMetaData;
/* Recompile any invalid objects */
execute sys.owm_mig_pkg.recompileAllObjects ;
/* --------------------------------------------------------------------- */
/* If there is atleast one versioned table, enable the system triggers.  */
/* This is because reinstall of WM creates triggers as disabled.         */
/* --------------------------------------------------------------------- */
declare
 found integer;
begin
  select 1 into found from dual where exists (select 1 from wmsys.wm$versioned_tables);
  sys.ltadm.enableSystemTriggers_exp;
exception when no_data_found then
  null;
end;
/
/* 
 * Update the regsitry after verifying successful install. This
 * should always be the last step.
 */
declare
  version_str             varchar2(100)  := '';
  compatibility_str       varchar2(100)  := '';
  ver                     varchar2(100)  := null;
begin
   dbms_utility.db_version(version_str,compatibility_str);
   version_str := sys.wm$convertDbVersion(version_str);
   if (version_str >= '9.2.0.0.0') then
       execute immediate 'select value from wm_installation where name = ''OWM_VERSION''' into ver ;
       execute immediate 'begin dbms_registry.upgraded(''OWM'', ''' || ver || ''', ''Oracle Workspace Manager ' || ver || ' - Production''); end;' ;
       if ((version_str >= '9.2.0.7.0' and version_str < 'A.0.0.0.0') or version_str >= 'A.1.0.4.0') then
         execute immediate 'begin sys.validate_owm; end;' ;
       else
         execute immediate 'begin wmsys.validate_owm; end;' ;
       end if ;
   end if;
end;
/
