/* 
 * Call dbms_registry.downgrade This is always the first call in Upgrade. 
 */
declare
  version_str             varchar2(1000) := '';
  compatibility_str       varchar2(1000) := '';
begin
   dbms_utility.db_version(version_str,compatibility_str);
   version_str := sys.wm$convertDbVersion(version_str);
   if (version_str >= '9.2.0.0.0') then
     execute immediate 'begin dbms_registry.downgrading(''OWM''); end;' ;
   end if;
end;
/
/* --------------------------------------------------------------------- */
/* Fix CR workspaces to hang off latest version in parent-workspace      */
/* --------------------------------------------------------------------- */
execute sys.owm_mig_pkg.RollbackFixCrWorkspaces ;
/* --------------------------------------------------------------------- */
/* Fix the version number of sentinel rows                               */
/* --------------------------------------------------------------------- */
execute sys.owm_mig_pkg.AllRollbackFixSentinelVersion ;
execute sys.ltadm.disableSystemTriggers_exp ;
/* --------------------------------------------------------------------- */
/* Light-weight DisableVersion the tables. They will be lwEnabled later. */
/* This is becuase triggers, dispatch procs, views etc are dependent on  */
/* new packages and tables.                                              */
/* In the later releases, we will do this step before upgrading because  */
/* lwDisable should be compatible with the current release and lwEnable  */
/* should be done after upgrade. Since we didn't have lwDisable in 901,  */
/* do it here.                                                           */
/* --------------------------------------------------------------------- */
execute sys.owm_mig_pkg.AllLwDisableVersioning ;
Declare
    delTrigCode varchar2(32000);
    updTrigCode varchar2(32000);
    cursor ricPtTrigCur is 
    select * 
    from wmsys.wm$ric_triggers_table;
    where not exists
      ( select 1 from wmsys.wm$versioned_tables
        where owner = pt_owner
          and (table_name = pt_name or
               table_name || '_LT' = pt_name)
      ) ;
Begin
    for ricPtTrigCurRec in ricPtTrigCur loop
       sys.ltric.getPtBeforeTrigStrs( ricPtTrigCurRec.ct_owner,
                                      ricPtTrigCurRec.ct_name, 
                                      ricPtTrigCurRec.pt_owner,
                                      ricPtTrigCurRec.pt_name,
                                      ricPtTrigCurRec.update_trigger_name,
                                      updTrigCode,
                                      ricPtTrigCurRec.delete_trigger_name,
                                      delTrigCode );
       execute immediate delTrigCode;
       execute immediate updTrigCode;
    end loop;
End;
/
/* --------------------------------------------------------------------- */
/* Drop existing tables, packages, views, synonyms, system triggers etc. */
/* --------------------------------------------------------------------- */
/* Create procedure in sys schema for executing sql with ignoring error. */
create or replace procedure wm$execSQLIgnoreError wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
7
9200000
1
4
0 
6
2 :e:
1WM$EXECSQLIGNOREERROR:
1SQL_STMT:
1VARCHAR2:
1EXECUTE:
1IMMEDIATE:
1OTHERS:
0

0
0
22
2
0 9a 8f a0 b0 3d b4 55
6a :3 a0 11e 11d b7 a0 53 4f
b7 a6 9 a4 b1 11 4f b7
a4 b1 11 68 4f 1d 17 b5 
22
2
0 3 1f 1b 1a 27 17 2c
30 34 38 3c 40 45 49 4b
1 4f 51 53 54 59 5d 5f
6b 6d 6f 73 75 81 85 87
88 91 
22
2
0 b 21 2a :2 21 20 :2 1 4
c 16 :2 4 2 :2 9 15 10 :2 4
2 :c 1 
22
4
0 :8 1 :5 4 3
:6 6 5 :5 2 :7 1

93
4
:3 0 1 :a 0 1d
1 :7 0 5 :2 0
:2 3 :3 0 2 :7 0
4 3 :3 0 6
:2 0 1d 1 7
:2 0 4 :3 0 5
:3 0 2 :3 0 b
:4 0 c :2 0 e
7 17 6 :4 0
12 9 14 b
13 12 :2 0 15
d :2 0 17 0
17 16 e 15
:6 0 19 1 :3 0
f 1c :3 0 1c
0 1c 1b 19
1a :6 0 1d :2 0
1 7 1c 20
:3 0 1f 1d 21
:8 0 
11
4
:3 0 1 2 1
5 1 d 1
11 1 10 1
14 1 17 
1
4
0 
20
0
1
14
2
2
0 1 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
1 0 1
2 1 0
0

/
/* --------------------------------------------------------------------- */
/* Call owmr9013.plb to Rollback the metadate to 9013.                   */
/* --------------------------------------------------------------------- */
@@owmr9013.plb
drop context lt_ctx ;
drop package lt_ctx_pkg ;
drop type wmsys.oper_lockvalues_array_type ;
drop type wmsys.oper_lockvalues_type ;
drop type wmsys.IntToStr_array_type ;
drop type wmsys.trigOptionsType ;
/* --------------------------------------------------------------------- */
/* Create package specs                                                  */
/* --------------------------------------------------------------------- */
@@owmcpkgs.plb
grant execute on lt_ctx_pkg to public with grant option;
create or replace view wmsys.wm$current_workspace_view as 
  select * from wmsys.wm$workspaces_table  
  where workspace = nvl(SYS_CONTEXT('lt_ctx','state'),'LIVE')
WITH READ ONLY;
/* --------------------------------------------------------------------- */
/* Create package body                                                   */
/* --------------------------------------------------------------------- */
@@owmcpkgb.plb
create or replace function wmsys.wm$disallowQnDML wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
8
9200000
1
4
0 
5
2 :e:
1FUNCTION:
1WM$DISALLOWQNDML:
1RETURN:
1INTEGER:
10:
0

0
0
14
2
0 a0 8d a0 b4 a0 2c 6a
a0 51 65 b7 a4 b1 11 68
4f 1d 17 b5 
14
2
0 3 f b a 23 27 2b
2f 7 33 37 39 3d 3f 4b
4f 51 52 5b 
14
2
0 1 10 21 0 28 :2 1 3
a 3 :9 1 
14
4
0 :3 1 0 :3 1
:3 3 :2 2 :7 1 
5d
4
:3 0 1 :3 0 5
:3 0 3 :3 0 2
:a 0 f 1 :7 0
4 :3 0 4 5
0 f 2 6
:2 0 3 :3 0 9
:2 0 b 3 e
:3 0 e 0 e
d b c :6 0
f :2 0 2 6
e 12 :3 0 11
f 13 :8 0 
5
4
:3 0 1 a 
1
4
0 
12
0
1
14
1
1
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
2 0 1
0

/
/* --------------------------------------------------------------------- */
/* Light-weight EnableVersion the tables.                                */
/* --------------------------------------------------------------------- */
declare
  l_owner varchar2(30);
  l_table_name varchar2(30);
  found integer;
  error_flag boolean := false;
  err_num             number;
  err_msg             varchar2(200);
  l_pt_owner          varchar2(30);
  l_pt_table_name     varchar2(30);
  cursor vertab_cur is
    select owner, table_name
    from wmsys.wm$versioned_tables 
    where disabling_ver = 'LW_DISABLED' order by ricWeight desc;
  cursor pt_cur is
    select pt_owner, pt_name
    from wmsys.wm$ric_table 
    where ct_owner = l_owner and ct_name = l_table_name 
      and not(pt_owner = ct_owner and pt_name = ct_name) and status = 'ENABLED';
begin
     open vertab_cur;
     loop
        fetch vertab_cur into l_owner, l_table_name;
        EXIT WHEN vertab_cur%NOTFOUND;
        /* If there is an error, we still want to continue */
        begin
          sys.owm_ddl_pkg.lwEnableVersioning(l_owner,l_table_name);
          open pt_cur;
          loop
            fetch pt_cur into l_pt_owner, l_pt_table_name;
            exit when pt_cur%NOTFOUND;
            execute immediate 'drop view ' || l_pt_owner || '.' || l_pt_table_name ; 
          end loop;
          close pt_cur;                                 
        exception 
          when others then 
            begin
             err_num := SQLCODE;
             err_msg := substr(SQLERRM,1,200);
	     error_flag := true;
            end;
        end;
     end loop;
     close vertab_cur;
   if(error_flag) then
     SYS.WM_ERROR.RAISEERROR(SYS.LT.WM_ERROR_194_NO, err_msg);
   end if;
end;
/
/* --------------------------------------------------------------------- */
/* If there is atleast one versioned table, enable the system triggers.  */
/* This is because reinstall of WM creates triggers as disabled.         */
/* --------------------------------------------------------------------- */
declare
 found integer;
begin
   begin
     select 1 into found from dual where exists (select 1 from wmsys.wm$versioned_tables);
     sys.ltadm.enableSystemTriggers;
   exception
     when no_data_found then null;
     when others then raise;
   end;
end;
/
/* Drop the temporary procedure created */
drop procedure wm$execSQLIgnoreError;
/* 
 * Update the regsitry. This should always be the last step.
 */
declare
  version_str             varchar2(100)  := '';
  compatibility_str       varchar2(100)  := '';
  cnt                     integer        := 0 ;
  ver                     varchar2(100)  := null;
begin
   dbms_utility.db_version(version_str,compatibility_str);
   version_str := sys.wm$convertDbVersion(version_str);
   if (version_str >= '9.2.0.0.0') then
     select count(*) into cnt from user_objects where status = 'VALID' and object_type = 'PACKAGE BODY' and object_name = 'LT' ;
     if(cnt = 0) then
       execute immediate 'begin dbms_registry.invalid(''OWM''); end;' ;
     else
       execute immediate 'select value from wm_installation where name = ''OWM_VERSION''' into ver ;
       execute immediate 'begin dbms_registry.downgraded(''OWM'',''' || ver || '''); end;' ;
     end if;
   end if;
end;
/
