declare
  found integer := 0;
begin
  select count(*) into found 
  from all_triggers 
  where owner = 'SYS' and 
         trigger_name in ('NO_VM_CREATE', 'NO_VM_DROP', 'NO_VM_DROP_A', 'NO_VM_ALTER');
  if (found < 4) then 
    SYS.WM_ERROR.RAISEERROR(SYS.LT.WM_ERROR_99_NO);
  end if;   
  select count(*) into found 
  from all_errors 
  where owner = 'SYS' and 
        type  = 'TRIGGER' and
        name in ('NO_VM_CREATE', 'NO_VM_DROP', 'NO_VM_DROP_A', 'NO_VM_ALTER');
  if ( found != 0 ) then 
    SYS.WM_ERROR.RAISEERROR(SYS.LT.WM_ERROR_99_NO);
  end if;
  execute immediate  'grant execute on lt_ctx_pkg to public with grant option';
  execute immediate  'grant execute on lt to public';
  execute immediate  'grant execute on owm_vt_pkg to public with grant option';
  execute immediate  'grant execute on wm_error to public';
  execute immediate  'grant execute on lt_export_pkg to public';
  execute immediate  'grant execute on ltadm to imp_full_database';
end;
/
execute wmsys.wm$execSQL('grant delete on wmsys.wm$workspaces_table to imp_full_database') ;
execute wmsys.wm$execSQL('grant delete on wmsys.wm$workspace_priv_table to imp_full_database') ;
execute wmsys.wm$execSQL('grant delete on wmsys.wm$version_hierarchy_table to imp_full_database') ;
/* Compile all OWM invalid views. Some views might be
 * invalid if native-plsql is used.
 */
declare
  cursor c1 is
    select owner,object_name  
    from dba_objects 
    where ((owner = 'WMSYS') or
           (owner = 'SYS' and object_name like '%WORKSPACE%'))
    and status != 'VALID'
    and object_type = 'VIEW' ;  
begin
  for c1_rec in c1 loop
    execute immediate 'alter view ' || c1_rec.owner || '.' || c1_rec.object_name || ' compile' ;
  end loop;
end;
/
/* Drop the temporary procedure created */
drop procedure wmsys.wm$execSQL;
