/* --------------------------------------------------------------------- */
/* Create procedure in wmsys schema for grating privs, etc.              */
/* --------------------------------------------------------------------- */
create or replace procedure wmsys.wm$execSQL wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
7
9200000
1
4
0 
5
2 :e:
1WM$EXECSQL:
1SQLSTR:
1VARCHAR2:
1EXECUTE:
1IMMEDIATE:
0

0
0
17
2
0 9a 8f a0 b0 3d b4 55
6a :3 a0 11e 11d b7 a4 b1 11
68 4f 1d 17 b5 
17
2
0 3 1f 1b 1a 27 17 2c
30 34 38 3c 40 45 49 4b
4f 51 5d 61 63 64 6d 
17
2
0 11 1c 23 :2 1c 1b :2 1 3
b 15 :2 3 :9 1 
17
4
0 :8 1 :5 3 :2 2
:7 1 
6f
4
:3 0 1 :a 0 12
1 :7 0 5 :2 0
:2 3 :3 0 2 :7 0
4 3 :3 0 6
:2 0 12 1 7
:2 0 4 :3 0 5
:3 0 2 :3 0 b
:4 0 c :2 0 e
7 11 :3 0 11
0 11 10 e
f :6 0 12 :2 0
1 7 11 15
:3 0 14 12 16
:8 0 
9
4
:3 0 1 2 1
5 1 d 
1
4
0 
15
0
1
14
1
2
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
1 0 1
2 1 0
0

/
/* 
 * Call dbms_registry.downgrade This is always the first call in Downgrade. 
 */
declare
  version_str             varchar2(1000) := '';
  compatibility_str       varchar2(1000) := '';
begin
   dbms_utility.db_version(version_str,compatibility_str);
   version_str := sys.wm$convertDbVersion(version_str);
   if (version_str >= '9.2.0.0.0') then
     execute immediate 'begin dbms_registry.downgrading(''OWM''); end;' ;
   end if;
end;
/
execute sys.ltadm.disableSystemTriggers_exp ;
/* --------------------------------------------------------------------- */
/* Light-weight DisableVersion the tables. They will be lwEnabled later. */
/* This is becuase triggers, dispatch procs, views etc are dependent on  */
/* new packages and tables.                                              */
/* --------------------------------------------------------------------- */
execute sys.owm_mig_pkg.AllLwDisableVersioning ;
/* --------------------------------------------------------------------- */
/* Call owmr1010.plb to Rollback the metadate to 101.                    */
/* --------------------------------------------------------------------- */
@@owmr1012.plb
/* 
 * Update the regsitry. This should always be the last step.
 */
declare
  version_str             varchar2(100)  := '';
  compatibility_str       varchar2(100)  := '';
  cnt                     integer        := 0 ;
  ver                     varchar2(100)  := null;
begin
   dbms_utility.db_version(version_str,compatibility_str);
   version_str := sys.wm$convertDbVersion(version_str);
   if (version_str >= '9.2.0.0.0') then
       execute immediate 'select value from wmsys.wm$env_vars where name = ''OWM_VERSION''' into ver ;
       execute immediate 'begin dbms_registry.downgraded(''OWM'',''' || ver || '''); end;' ;
   end if;
end;
/
