drop context lt_ctx ;
drop package lt_ctx_pkg ;
/* --------------------------------------------------------------------- */
/* Create package specs                                                  */
/* --------------------------------------------------------------------- */
@@owmcpkgs.plb
grant execute on lt_ctx_pkg to public with grant option;
create or replace view wmsys.wm$current_workspace_view as 
  select * from wmsys.wm$workspaces_table  
  where workspace = nvl(SYS_CONTEXT('lt_ctx','state'),'LIVE')
WITH READ ONLY;
/* --------------------------------------------------------------------- */
/* Create package body                                                   */
/* --------------------------------------------------------------------- */
@@owmcpkgb.plb
create or replace function wmsys.wm$disallowQnDML wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
8
9200000
1
4
0 
5
2 :e:
1FUNCTION:
1WM$DISALLOWQNDML:
1RETURN:
1INTEGER:
10:
0

0
0
14
2
0 a0 8d a0 b4 a0 2c 6a
a0 51 65 b7 a4 b1 11 68
4f 1d 17 b5 
14
2
0 3 f b a 23 27 2b
2f 7 33 37 39 3d 3f 4b
4f 51 52 5b 
14
2
0 1 10 21 0 28 :2 1 3
a 3 :9 1 
14
4
0 :3 1 0 :3 1
:3 3 :2 2 :7 1 
5d
4
:3 0 1 :3 0 5
:3 0 3 :3 0 2
:a 0 f 1 :7 0
4 :3 0 4 5
0 f 2 6
:2 0 3 :3 0 9
:2 0 b 3 e
:3 0 e 0 e
d b c :6 0
f :2 0 2 6
e 12 :3 0 11
f 13 :8 0 
5
4
:3 0 1 a 
1
4
0 
12
0
1
14
1
1
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
2 0 1
0

/
/* --------------------------------------------------------------------- */
/* Light-weight EnableVersion the tables.                                */
/* --------------------------------------------------------------------- */
execute sys.owm_mig_pkg.AllLwEnableVersioning ;
Declare
    delTrigCode varchar2(32000);
    updTrigCode varchar2(32000);
    cursor ricPtTrigCur is 
    select * 
    from wmsys.wm$ric_triggers_table
    where not exists
      ( select 1 from wmsys.wm$versioned_tables
        where owner = pt_owner
          and (table_name = pt_name or
               table_name || '_LT' = pt_name)
      ) ;
Begin
    for ricPtTrigCurRec in ricPtTrigCur loop
       sys.ltric.getPtBeforeTrigStrs( ricPtTrigCurRec.ct_owner,
                                      ricPtTrigCurRec.ct_name, 
                                      ricPtTrigCurRec.pt_owner,
                                      ricPtTrigCurRec.pt_name,
                                      ricPtTrigCurRec.update_trigger_name,
                                      updTrigCode,
                                      ricPtTrigCurRec.delete_trigger_name,
                                      delTrigCode );
       execute immediate delTrigCode;
       execute immediate updTrigCode;
    end loop;
End;
/
drop function sys.wm$convertDbVersion ;
drop function wmsys.wm$getdbversionstr ;
/* --------------------------------------------------------------------- */
/* If there is atleast one versioned table, enable the system triggers.  */
/* This is because reinstall of WM creates triggers as disabled.         */
/* --------------------------------------------------------------------- */
declare
 found integer;
begin
   begin
     select 1 into found from dual where exists (select 1 from wmsys.wm$versioned_tables);
     sys.ltadm.enableSystemTriggers;
   exception
     when no_data_found then null;
     when others then raise;
   end;
end;
/
