/* NOTE:
 * We create the wmsys user and lock his account because we want
 * to make his password public but restrict access to the account
 * to the SYS schema. So, to unlock the account, dba privs are
 * required.
 */
create or replace function sys.wm$convertDbVersion wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
8
9200000
1
4
0 
1d
2 :e:
1FUNCTION:
1WM$CONVERTDBVERSION:
1VERSION_STR:
1VARCHAR2:
1RETURN:
1DB_VER:
1INTEGER:
1HEX_DB_VER:
11:
1INSTR:
1.:
1=:
13:
1SUBSTR:
12:
110:
1A:
1ELSIF:
111:
1B:
112:
1C:
113:
1D:
114:
1E:
115:
1F:
1||:
0

0
0
8e
2
0 a0 8d 8f a0 b0 3d b4
:2 a0 2c 6a a3 a0 1c 81 b0
a3 a0 51 a5 1c 81 b0 :2 a0
6e a5 b 7e 51 b4 2e 5a
:3 a0 :2 51 a5 b d a0 7e 51
b4 2e 5a a0 6e d a0 b7
a0 7e 51 b4 2e 5a a0 6e
d a0 b7 19 a0 7e 51 b4
2e 5a a0 6e d a0 b7 19
a0 7e 51 b4 2e 5a a0 6e
d a0 b7 19 a0 7e 51 b4
2e 5a a0 6e d a0 b7 19
a0 7e 51 b4 2e 5a a0 6e
d b7 :2 19 3c :2 a0 7e :2 a0 51
a5 b b4 2e 65 b7 :2 a0 65
b7 :2 19 3c b7 a4 b1 11 68
4f 1d 17 b5 
8e
2
0 3 7 23 1f 1e 2b 1b
30 34 38 3c 55 44 48 50
43 72 60 40 64 65 6d 5f
79 7d 81 5c 86 88 8b 8e
8f 94 97 9b 9f a3 a6 a9
aa ac b0 b4 b7 ba bb c0
c3 c7 cc d0 d4 d6 da dd
e0 e1 e6 e9 ed f2 f6 fa
fc 100 104 107 10a 10b 110 113
117 11c 120 124 126 12a 12e 131
134 135 13a 13d 141 146 14a 14e
150 154 158 15b 15e 15f 164 167
16b 170 174 178 17a 17e 182 185
188 189 18e 191 195 19a 19e 1a0
1a4 1a8 1ab 1af 1b3 1b6 1ba 1be
1c1 1c2 1c4 1c5 1ca 1ce 1d0 1d4
1d8 1dc 1de 1e2 1e6 1e9 1eb 1ef
1f1 1fd 201 203 204 20d 
8e
2
0 1 e 22 2e :2 22 21 38
3f :2 1 3 :3 a :2 3 e 17 16
:2 e 3 7 d 19 :2 7 1e 20
:2 1e :2 5 f 16 22 24 :2 f 5
8 f 11 :2 f :2 7 15 7 5
15 b 12 14 :2 12 a 7 15
7 5 18 15 b 12 14 :2 12
a 7 15 7 5 18 15 b
12 14 :2 12 a 7 15 7 5
18 15 b 12 14 :2 12 a 7
15 7 5 18 15 b 12 14
:2 12 a 7 15 7 18 15 :3 5
c 17 1a 21 2d :2 1a :2 c 5
24 5 c 5 :4 3 :9 1 
8e
4
0 :b 1 :5 3 :7 4
:a 6 :8 7 :6 8 :3 9
a 8 :6 a :3 b
c a 8 :6 c
:3 d e c 8
:6 e :3 f 10 e
8 :6 10 :3 11 12
10 8 :6 12 :3 13
12 :3 8 :b 15 6
:3 17 16 :3 6 :2 5
:7 1 
20f
4
:3 0 1 :3 0 2
:a 0 89 1 :7 0
5 :2 0 3 4
:3 0 3 :7 0 5
4 :3 0 5 :3 0
4 :3 0 7 9
0 89 2 a
:2 0 9 :2 0 :2 7
:3 0 d :7 0 10
e 0 87 0
6 :6 0 d :2 0
b 4 :3 0 9
12 14 :6 0 17
15 0 87 0
8 :6 0 a :3 0
3 :3 0 b :4 0
18 1b c :2 0
d :2 0 12 1d
1f :3 0 20 :2 0
6 :3 0 e :3 0
3 :3 0 9 :2 0
f :2 0 15 23
27 22 28 0
7d 6 :3 0 c
:2 0 10 :2 0 1b
2b 2d :3 0 2e
:2 0 8 :3 0 11
:4 0 30 31 0
34 12 :3 0 1e
70 6 :3 0 c
:2 0 13 :2 0 22
36 38 :3 0 39
:2 0 8 :3 0 14
:4 0 3b 3c 0
3f 12 :3 0 25
40 3a 3f 0
71 6 :3 0 c
:2 0 15 :2 0 29
42 44 :3 0 45
:2 0 8 :3 0 16
:4 0 47 48 0
4b 12 :3 0 2c
4c 46 4b 0
71 6 :3 0 c
:2 0 17 :2 0 30
4e 50 :3 0 51
:2 0 8 :3 0 18
:4 0 53 54 0
57 12 :3 0 33
58 52 57 0
71 6 :3 0 c
:2 0 19 :2 0 37
5a 5c :3 0 5d
:2 0 8 :3 0 1a
:4 0 5f 60 0
63 12 :3 0 3a
64 5e 63 0
71 6 :3 0 c
:2 0 1b :2 0 3e
66 68 :3 0 69
:2 0 8 :3 0 1c
:4 0 6b 6c 0
6e 41 6f 6a
6e 0 71 2f
34 0 71 43
0 7d 5 :3 0
8 :3 0 1d :2 0
e :3 0 3 :3 0
d :2 0 4a 75
78 4d 74 7a
:3 0 7b :2 0 7d
50 82 5 :3 0
3 :3 0 7f :2 0
81 54 83 21
7d 0 84 0
81 0 84 56
0 85 59 88
:3 0 88 5b 88
87 85 86 :6 0
89 :2 0 2 a
88 8c :3 0 8b
89 8d :8 0 
5e
4
:3 0 1 3 1
6 1 c 1
13 1 11 2
19 1a 1 1e
2 1c 1e 3
24 25 26 1
2c 2 2a 2c
1 32 1 37
2 35 37 1
3d 1 43 2
41 43 1 49
1 4f 2 4d
4f 1 55 1
5b 2 59 5b
1 61 1 67
2 65 67 1
6d 6 70 40
4c 58 64 6f
2 76 77 2
73 79 3 29
71 7c 1 80
2 82 83 1
84 2 f 16

1
4
0 
8c
0
1
14
1
4
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
11 1 0
2 0 1
c 1 0
3 1 0
0

/
grant execute on sys.wm$convertDBVersion to public;
Declare
  cnt                  integer; 
  version_str          varchar2(1000) := '';
  compatibility_str    varchar2(1000) := '';
Begin
    dbms_utility.db_version(version_str,compatibility_str);
    version_str := sys.wm$convertDbVersion(version_str);
    compatibility_str := sys.wm$convertDbVersion(compatibility_str);
    select count(*) into cnt
    from   dba_tablespaces 
    where  tablespace_name = 'SYSAUX';
    if ( version_str >= 'A.0.0.0.0'  and compatibility_str >= '9.2.0.0.0' and cnt > 0 ) then
       execute immediate 'create user wmsys identified by wmsys account lock password expire 
                          default tablespace SYSAUX';
    else
       execute immediate 'create user wmsys identified by wmsys account lock password expire'; 
    end if;
End;
/
grant connect, resource, create public synonym, drop public synonym, create role to wmsys;
/* 
 * SYS cannot directly grant execute on wmsys.type to public.
 * So, we have to do this hack of creating a procedure in wmsys, 
 * that does the SQL...
 */
create or replace procedure wmsys.wm$execSQL wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
7
9200000
1
4
0 
5
2 :e:
1WM$EXECSQL:
1SQLSTR:
1VARCHAR2:
1EXECUTE:
1IMMEDIATE:
0

0
0
17
2
0 9a 8f a0 b0 3d b4 55
6a :3 a0 11e 11d b7 a4 b1 11
68 4f 1d 17 b5 
17
2
0 3 1f 1b 1a 27 17 2c
30 34 38 3c 40 45 49 4b
4f 51 5d 61 63 64 6d 
17
2
0 11 1c 23 :2 1c 1b :2 1 3
b 15 :2 3 :9 1 
17
4
0 :8 1 :5 3 :2 2
:7 1 
6f
4
:3 0 1 :a 0 12
1 :7 0 5 :2 0
:2 3 :3 0 2 :7 0
4 3 :3 0 6
:2 0 12 1 7
:2 0 4 :3 0 5
:3 0 2 :3 0 b
:4 0 c :2 0 e
7 11 :3 0 11
0 11 10 e
f :6 0 12 :2 0
1 7 11 15
:3 0 14 12 16
:8 0 
9
4
:3 0 1 2 1
5 1 d 
1
4
0 
15
0
1
14
1
2
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
1 0 1
2 1 0
0

/
/*
 * !!!!!!!!!! NOTE !!!!! NOTE !!!!!!! NOTE !!!!!!! NOTE !!!!!!!!!!!!!
 * ------------------------------------------------------------------
 * Whenever the definition of a table is changed i.e. either a new column
 * is added or the definition of any column is changed OR whenever a new
 * table is added, please make sure that export is made aware of the change.
 * The export support code is tightly dependent on the definition of the
 * system tables and will break if the table definitons are modified. 
 * All the export support code is in the following files:
 *   ovmeadms.sql, ovmeadmb.sql, ovmexps.sql, ovmexpb.sql
 */
create type wmsys.wm$lock_info_type 
 TIMESTAMP '2001-07-29:12:06:07'
 OID '8A3DB78598BD5DE2E034080020EDC61B'
 wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
9
2 :e:
1TYPE:
1WM$LOCK_INFO_TYPE:
1OBJECT:
1TABLE_OWNER:
1VARCHAR2:
140:
1TABLE_NAME:
1INFO:
1100:
0

0
0
22
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 51 a5
1c b0 81 a3 a0 51 a5 1c
b0 81 77 a0 102 a0 c6 1d
17 b5 
22
2
0 3 79 b f 33 23 27
2a 2b 22 3a 50 43 1f 47
48 42 57 6d 60 3f 64 65
5f 74 7 80 5c 84 88 8a
8b 94 
22
2
0 1 c 4e 1 b 17 20
1f 17 :3 b 17 20 1f 17 :3 b
17 20 1f 17 :2 b 1 :2 9 :5 1

22
4
0 :2 1 2 1
:7 3 :7 4 :7 5 1
:2 9 :5 1 
96
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 f :3 0 1c
1 1a :9 0 6
:2 0 :2 5 :3 0 6
:2 0 3 6 8
:6 0 4 :6 0 a
9 0 4 0
9 :2 0 9 5
:3 0 7 d f
:6 0 7 :6 0 11
10 0 4 0
1b :2 0 d 5
:3 0 b 14 16
:6 0 8 :6 0 18
17 0 4 0
2 4 2 1
:3 0 2 :3 0 2
:2 0 2 1d 1a
0 1f 1e 21
:8 0 
13
4
:3 0 1 7 1
5 1 e 1
c 1 15 1
13 3 b 12
19 
1
4
0 
20
0
1
14
1
4
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
13 1 0
5 1 0
2 0 1
c 1 0
0

/
create type wmsys.wm$lock_table_type 
 TIMESTAMP '2001-07-29:12:06:07'
 OID '8A3DB78598C35DE2E034080020EDC61B'
as table of wmsys.wm$lock_info_type;
/
execute wmsys.wm$execSQL('grant execute on wmsys.wm$lock_table_type to public');
/* Referential integrity constraints table */
create table wmsys.wm$ric_table (
ct_owner              varchar2(40),   /* child table owner */
ct_name               varchar2(40),   /* child table name */
pt_owner              varchar2(40),   /* parent table owner */
pt_name               varchar2(40),   /* parent table name */
ric_name              varchar2(40),   
                          /* referential integrity constraint name */
ct_cols               varchar2(4000), 
                          /* foreign key columns of the child table 
                             participating in the RIC. Comma separated and 
                             comma at the end. */ 
pt_cols               varchar2(4000),  
                          /* unique key columns of the parent table
                             participating in the RIC. comma separated and
                             comma at the end. */  
pt_unique_const_name  varchar2(40),  
                          /* name of the unique constraint defined on the 
                             parent table. */ 
my_mode               varchar2(2),     /* cascade or restrict */
status                varchar2(8),     /* 'ENABLED' or 'DISABLED' */
constraint wm$ric_pk  PRIMARY KEY (ct_owner, ric_name) ); 
create index wmsys.wm$ric_table_ct_idx on wmsys.wm$ric_table(ct_owner, ct_name);
create index wmsys.wm$ric_table_pt_idx on wmsys.wm$ric_table(pt_owner, pt_name);
/* 
 * Table for storing sql code for before update and before delete triggers 
 * on a non-version-enabled parent table. The child table is version enabled.
 */
create table wmsys.wm$ric_triggers_table (
pt_owner                 varchar2(40),    /* parent table owner */
pt_name                  varchar2(40),    /* parent table name */
ct_owner                 varchar2(40),    /* child table owner */
ct_name                  varchar2(40),    /* child table name */
update_trigger_name      varchar2(40),    /* before update trigger name */
delete_trigger_name      varchar2(40),    /* before delete trigger name */
CONSTRAINT wm$ric_triggers_pk PRIMARY KEY (pt_owner, pt_name, ct_owner, ct_name) );
/* 
 * sequence for generating names of before update and delete triggers 
 * defined on a non-versioned parent table for implementing RIC's 
 */ 
create sequence wmsys.wm$up_del_trig_name_sequence;
/* table for storing istead of triggers names */
create table wmsys.wm$insteadof_trigs_table (
table_owner             varchar2(40),
table_name              varchar2(40),
insert_trig_name        varchar2(40),
update_trig_name        varchar2(40),
delete_trig_name        varchar2(40),
CONSTRAINT wm$insteadof_trigs_pk PRIMARY KEY (table_owner, table_name));
/* sequence for constructing instead of trigger names */
create sequence wmsys.wm$insteadof_trigs_sequence;
create table wmsys.wm$workspaces_table (
workspace         varchar2(30),
parent_workspace  varchar2(30),
current_version   number,
parent_version    number,
post_version      number,
verlist           varchar2(2000),
owner             varchar2(30),
createTime        date,
description       varchar2(1000),
workspace_lock_id integer,
freeze_status     varchar2(8),
freeze_mode       varchar2(12),
freeze_writer     varchar2(30),
oper_status       varchar2(30),
wm_lockmode       varchar2(5),
isRefreshed       integer,
constraint wm$workspaces_pk PRIMARY KEY (workspace)
);
/* UNCOMMENT FOR EXTENDED STATE NAMES 
   create index state_table_indx on state_table (reverse(state_name));
 */
insert into wmsys.wm$workspaces_table values ('LIVE',null,0,null,null,null,'SYS', null, null, 0, 'UNLOCKED',null,null,null,null,0);
commit;
/* sequence for constructing instead of trigger names */
create sequence wmsys.wm$lock_sequence;
/*
create table wmsys.wm$version_table (
version     integer, 
parent_vers integer,
workspace   varchar2(30),
constraint wm$version_pk PRIMARY KEY (version,parent_vers));
*/
create table wmsys.wm$version_table (
workspace     varchar2(30), 
anc_workspace varchar2(30), 
anc_version   integer,
constraint wm$version_pk PRIMARY KEY (workspace, anc_workspace));
create table wmsys.wm$nextver_table (
version     integer, 
next_vers   varchar2(500),
workspace   varchar2(30),
split       integer);
create index wmsys.wm$nextver_table_indx on wmsys.wm$nextver_table(version);
create table wmsys.wm$version_hierarchy_table (
version        integer, 
parent_version integer,
workspace      varchar2(30),
constraint wm$version_hierarchy_pk PRIMARY KEY (version));
insert into wmsys.wm$version_hierarchy_table values (0,-1,'LIVE');
/* Create the Versioned tables table */
/* create enable/disable versioning undo code related types */
create type wmsys.wm$ed_undo_code_node_type 
 TIMESTAMP '2001-07-29:12:08:55'
 OID '8A3DA47750525DCEE034080020EDC61B'
 wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
8
2 :e:
1TYPE:
1WM$ED_UNDO_CODE_NODE_TYPE:
1OBJECT:
1INDEX_TYPE:
1INTEGER:
1INDEX_FIELD:
1SQL_STR:
1CLOB:
0

0
0
1c
2
0 a0 9d a0 60 a3 a0 1c
b0 81 a3 a0 1c b0 81 a3
a0 1c b0 81 77 a0 102 a0
c6 1d 17 b5 
1c
2
0 3 6f b f 2f 23 27
22 36 4b 3f 43 1f 52 63
57 5b 3e 6a 7 76 3b 7a
7e 80 81 8a 
1c
2
0 1 c 4d 1 2 :2 f :3 2
:2 f :3 2 :2 e :2 2 1 :2 14 :5 1 
1c
4
0 :2 1 2 1
:5 3 :5 4 :5 5 1
:2 5 :5 1 
8c
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 9 :3 0 16
1 14 :9 0 5
3b 0 3 5
:3 0 6 :7 0 4
:6 0 8 7 0
4 0 15 :2 0
7 5 :3 0 b
:7 0 6 :6 0 d
c 0 4 0
8 :3 0 10 :7 0
7 :6 0 12 11
0 4 0 2
4 2 1 :3 0
2 :3 0 2 :2 0
2 17 14 0
19 18 1b :8 0

d
4
:3 0 1 5 1
a 1 f 3
9 e 13 
1
4
0 
1a
0
1
14
1
4
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
a 1 0
2 0 1
5 1 0
f 1 0
0

/
execute wmsys.wm$execSQL('grant execute on wmsys.wm$ed_undo_code_node_type to public'); 
create type wmsys.wm$ed_undo_code_table_type 
TIMESTAMP '2001-07-29:12:08:55'
OID '8A3DA47750585DCEE034080020EDC61B'
as table of wmsys.wm$ed_undo_code_node_type;
/
execute wmsys.wm$execSQL('grant execute on wmsys.wm$ed_undo_code_table_type to public');
create table wmsys.wm$versioned_tables (
vtid            integer not null,
table_name      varchar2(30),
owner           varchar2(30),
notification    integer,
notifyWorkspaces varchar2(4000),
disabling_ver   VARCHAR2(13),
ricWeight       integer,
isFastLive      integer default 0,
isWorkflow      integer default 0,
hist            varchar2(50) default 'NONE',      /* history option */
pkey_cols       varchar2(4000) default '',
undo_code       wmsys.wm$ed_undo_code_table_type,
constraint wm$versioned_tables__pk PRIMARY KEY (table_name, owner)
) nested table undo_code store as wm$versioned_tables_undo_code;
create sequence wmsys.wm$vtid;
create table wmsys.wm$workspace_priv_table (
grantee        varchar2(30),
workspace      varchar2(30),
grantor        varchar2(30),
priv           varchar2(10),
admin          integer
);
insert into wmsys.wm$workspace_priv_table values ('WM_ADMIN_ROLE',null,'SYS','AA',1);
insert into wmsys.wm$workspace_priv_table values ('WM_ADMIN_ROLE',null,'SYS','CA',1);
insert into wmsys.wm$workspace_priv_table values ('WM_ADMIN_ROLE',null,'SYS','RA',1);
insert into wmsys.wm$workspace_priv_table values ('WM_ADMIN_ROLE',null,'SYS','DA',1);
insert into wmsys.wm$workspace_priv_table values ('WM_ADMIN_ROLE',null,'SYS','MA',1);
insert into wmsys.wm$workspace_priv_table values ('PUBLIC','LIVE','SYS','M',0);
insert into wmsys.wm$workspace_priv_table values ('PUBLIC','LIVE','SYS','A',0);
commit;
create table wmsys.wm$workspace_sessions_table (
username        varchar2(30),
workspace       varchar2(30),
sid             varchar2(25),
myver           integer default -1,
constraint wm$workspace_sessions_pk PRIMARY KEY (workspace, sid));
create table wmsys.wm$workspace_savepoints_table (
workspace       varchar2(30),
savepoint       varchar2(30),
version         number,
position        integer,
is_implicit     number,
owner           varchar2(30),
createTime      date,
description     varchar2(1000),
constraint wm$workspace_savepoints_pk PRIMARY KEY (workspace, savepoint));
create type wmsys.wm$conflict_payload_type 
TIMESTAMP '2001-07-29:12:06:11'
OID '8A3DB78598D25DE2E034080020EDC61B'
 wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
d
2 :e:
1TYPE:
1WM$CONFLICT_PAYLOAD_TYPE:
1OBJECT:
1USERSTATE:
1VARCHAR2:
130:
1TIMESTAMP:
1DATE:
1CONF_WORKSPACES:
14000:
1TABLENAME:
1KEYVALUE:
1200:
0

0
0
2e
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 1c b0
81 a3 a0 51 a5 1c b0 81
a3 a0 51 a5 1c b0 81 a3
a0 51 a5 1c b0 81 77 a0
102 a0 c6 1d 17 b5 
2e
2
0 3 b1 b f 33 23 27
2a 2b 22 3a 4f 43 47 1f
56 6b 5b 5f 62 63 42 72
88 7b 3f 7f 80 7a 8f a5
98 77 9c 9d 97 ac 7 b8
94 bc c0 c2 c3 cc 
2e
2
0 1 c 4b 1 2 12 1b
1a 12 :3 2 :2 12 :3 2 12 1b 1a
12 :3 2 12 1b 1a 12 :3 2 12
1b 1a 12 :2 2 1 :2 2 :5 1 
2e
4
0 :2 1 2 1
:7 3 :5 4 :7 5 :7 6
:7 7 1 :2 8 :5 1

ce
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 15 :3 0 28
1 26 :9 0 7
3f 0 :2 5 :3 0
6 :2 0 3 6
8 :6 0 4 :6 0
a 9 0 4
0 6 :2 0 b
8 :3 0 d :7 0
7 :6 0 f e
0 4 0 5
:3 0 a :2 0 9
12 14 :6 0 9
:6 0 16 15 0
4 0 d :2 0
f 5 :3 0 d
19 1b :6 0 b
:6 0 1d 1c 0
4 0 27 :2 0
13 5 :3 0 11
20 22 :6 0 c
:6 0 24 23 0
4 0 2 4
2 1 :3 0 2
:3 0 2 :2 0 2
29 26 0 2b
2a 2d :8 0 
1b
4
:3 0 1 7 1
5 1 c 1
13 1 11 1
1a 1 18 1
21 1 1f 5
b 10 17 1e
25 
1
4
0 
2c
0
1
14
1
6
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
1f 1 0
2 0 1
5 1 0
11 1 0
c 1 0
18 1 0
0

/
create table wmsys.wm$modified_tables (
  vtid          integer,      /* unique id for versioned_table */
  table_name    varchar2(61), /* owner_name.table_name */
  version       integer,
  workspace     varchar2(30)
);
declare
  version_str             varchar2(1000) := '';
  compatibility_str       varchar2(1000) := '';
begin
   dbms_utility.db_version(version_str,compatibility_str);
   version_str := sys.wm$convertDbVersion(version_str);
   if (version_str < '9.0.0.0.0') then
     execute immediate 'create index wmsys.modified_tables_idx on wmsys.wm$modified_tables(workspace, table_name, version)';
   else
     execute immediate 'alter table wmsys.wm$modified_tables add constraint modified_tables_pk PRIMARY KEY (workspace, table_name, version)';
   end if;
end;
/
create table wmsys.wm$adt_func_table (
  func_name  varchar2(30),    
  type_name  varchar2(30),
  ref_count  number        /* number of cols using this type */
);
create sequence wmsys.wm$adt_sequence;
/*
begin
dbms_aqadm.create_queue_table(
  queue_table=> 'wmsys.wm$conflicts_queue_table',
  multiple_consumers => TRUE,
  queue_payload_type => 'wmsys.wm$conflict_payload_type',
  compatible => '8.1.5');
dbms_aqadm.create_queue(
  queue_name => 'wmsys.wm$conflicts_queue',
  queue_table => 'wmsys.wm$conflicts_queue_table',
  retention_time => 1,
  comment => 'Q for WM Conflicts');
dbms_aqadm.start_queue('wmsys.wm$conflicts_queue');
end;
/
*/
create sequence wmsys.wm$version_sequence;
create sequence wmsys.wm$row_sync_id_sequence start with 11;
create table wmsys.wm$udtrig_info (
trig_owner_name  varchar2(50),
trig_name        varchar2(50),
table_owner_name varchar2(50),
table_name       varchar2(50),
trig_type        varchar2(3),
status           varchar(10),  /* ENABLED OR DISABLED */
trig_procedure   varchar2(50), /* wmsys.wm generated proc implementing the trigger */
when_clause      varchar2(4000),
description      varchar2(4000),
trig_code        long,
constraint wm$udtrig_info_pk primary key (trig_owner_name,trig_name));     
/* stores names of OVM generated procedures for dispatching 
   procedures implementing user-defined triggers 
*/
create table wmsys.wm$udtrig_dispatch_procs (
table_owner_name varchar2(50),
table_name       varchar2(50),
dispatcher_name  varchar2(50),
bir_flag         varchar2(3) default '',
air_flag         varchar2(3) default '',
bur_flag         varchar2(3) default '',
aur_flag         varchar2(3) default '',
bdr_flag         varchar2(3) default '',
adr_flag         varchar2(3) default '',
constraint wm$udtrig_dispatch_procs_pk primary key (table_owner_name,table_name));
create sequence wmsys.wm$udtrig_dispatcher_sequence;
create table wmsys.wm$resolve_workspaces_table (
  workspace     varchar2(30), 
  resolve_user  varchar2(30),
  undo_sp_name  varchar2(30),
  undo_sp_ver   integer,
  oldFreezeMode varchar2(30),
  oldFreezeWriter varchar2(30),
 constraint wm$resolve_workspaces_pk PRIMARY KEY (workspace)
);
INSERT INTO sys.exppkgact$ VALUES ('LT_EXPORT_PKG','SYS',1,1000);
INSERT INTO sys.exppkgact$ VALUES ('LT_EXPORT_PKG','SYS',2,1000);
commit;
create table wmsys.wm$env_vars( name varchar2(100), value varchar2(4000) ); 
/* Ramesh - 
 * In workspace operations like commit,remove, etc. it becomes very 
 * expensive to look for rows that were locked by an explicit call to
 * lockRows - These are ancestor rows that are locked but not versioned
 * in the workspace. So, finding these rows essentially requires a table 
 * scan. In order to avoid the table scan, we keep additional info during
 * each lockRows call. We keep the workspace, table_name and the where
 * clause passed in to lock Rows for use later..
 */
create table wmsys.wm$lockrows_info( workspace    varchar2(30), 
                                   owner        varchar2(30),
                                   table_name   varchar2(30),
                                   where_clause clob);
create index wmsys.wm$lockrows_info_idx on wmsys.wm$lockrows_info (workspace);
insert into wmsys.wm$env_vars values('OWM_VERSION','9.0.1.2.0');
commit;
@@owmt9012.plb
