? /*	$NetBSD: regcomp.c,v 1.17 2000/07/07 08:03:40 itohy Exp $	*/    /*- 0  * Copyright (c) 1992, 1993, 1994 Henry Spencer.!  * Copyright (c) 1992, 1993, 1994 E  *	The Regents of the University of California.  All rights reserved.   *@  * This code is derived from software contributed to Berkeley by  * Henry Spencer.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *'  *	@(#)regcomp.c	8.5 (Berkeley) 3/20/94   */    #include "cdefs.h"( #if defined(LIBC_SCCS) && !defined(lint) #if 0 > static char sccsid[] = "@(#)regcomp.c	8.5 (Berkeley) 3/20/94"; #else E __RCSID("$NetBSD: regcomp.c,v 1.17 2000/07/07 08:03:40 itohy Exp $");  #endif# #endif /* LIBC_SCCS and not lint */    #include "namespace.h" #include types #include ctype #include limits  #include "regex.h" #include stdlib  #include string  #include descrip #include lib$routines    #ifdef __weak_alias  __weak_alias(regcomp,_regcomp) #endif   #include "utils.h" #include "regex2.h"    #include "cclass.h"  #include "cname.h"   /*D  * parse structure, passed up and down to avoid global variables and  * other clumsinesses   */  struct parse {( 	char *next;		/* next character in RE */2 	char *end;		/* end of string (-> NUL normally) */* 	int error;		/* has an error been seen? */" 	sop *strip;		/* malloced strip */4 	sopno ssize;		/* malloced strip size (allocated) */0 	sopno slen;		/* malloced strip length (used) *// 	int ncsalloc;		/* number of csets allocated */  	struct re_guts *g; A #	define	NPAREN	10	/* we need to remember () 1-9 for back refs */ . 	sopno pbegin[NPAREN];	/* -> ( ([0] unused) */, 	sopno pend[NPAREN];	/* -> ) ([0] unused) */ };  9 /* ========= begin header generated by ./mkh ========= */  #ifdef __cplusplus extern "C" { #endif   /* === regcomp.c === */ 3 static void p_ere __P((struct parse *p, int stop)); - static void p_ere_exp __P((struct parse *p)); ) static void p_str __P((struct parse *p)); = static void p_bre __P((struct parse *p, int end1, int end2)); > static int p_simp_re __P((struct parse *p, int starordinary));* static int p_count __P((struct parse *p));- static void p_bracket __P((struct parse *p)); 6 static void p_b_term __P((struct parse *p, cset *cs));8 static void p_b_cclass __P((struct parse *p, cset *cs));8 static void p_b_eclass __P((struct parse *p, cset *cs));. static char p_b_symbol __P((struct parse *p));; static char p_b_coll_elem __P((struct parse *p, int endc)); $ static char othercase __P((int ch));5 static void bothcases __P((struct parse *p, int ch)); 4 static void ordinary __P((struct parse *p, int ch));. static void nonnewline __P((struct parse *p));I static void repeat __P((struct parse *p, sopno start, int from, int to)); 0 static int seterr __P((struct parse *p, int e));- static cset *allocset __P((struct parse *p)); 5 static void freeset __P((struct parse *p, cset *cs)); 6 static int freezeset __P((struct parse *p, cset *cs));4 static int firstch __P((struct parse *p, cset *cs));0 static int nch __P((struct parse *p, cset *cs));C static void mcadd __P((struct parse *p, cset *cs, const char *cp));  #if 0 , static void mcsub __P((cset *cs, char *cp));* static int mcin __P((cset *cs, char *cp));. static char *mcfind __P((cset *cs, char *cp)); #endif6 static void mcinvert __P((struct parse *p, cset *cs));4 static void mccase __P((struct parse *p, cset *cs));4 static int isinsets __P((struct re_guts *g, int c));= static int samesets __P((struct re_guts *g, int c1, int c2)); A static void categorize __P((struct parse *p, struct re_guts *g)); D static sopno dupl __P((struct parse *p, sopno start, sopno finish));> static void doemit __P((struct parse *p, sop op, sopno opnd));K static void doinsert __P((struct parse *p, sop op, sopno opnd, sopno pos)); A static void dofwd __P((struct parse *p, sopno pos, sopno value)); 7 static void enlarge __P((struct parse *p, sopno size)); @ static void stripsnug __P((struct parse *p, struct re_guts *g));? static void findmust __P((struct parse *p, struct re_guts *g)); A static sopno pluscount __P((struct parse *p, struct re_guts *g));    #ifdef __cplusplus }  #endif7 /* ========= end header generated by ./mkh ========= */   E static char nuls[10];		/* place to point scanner in event of error */    /*&  * macros for use with parse structure@  * BEWARE:  these know that the parse structure is named `p' !!!  */  #define	PEEK()	(*p->next)  #define	PEEK2()	(*(p->next+1))! #define	MORE()	(p->next < p->end) $ #define	MORE2()	(p->next+1 < p->end)( #define	SEE(c)	(MORE() && PEEK() == (c))K #define	SEETWO(a, b)	(MORE() && MORE2() && PEEK() == (a) && PEEK2() == (b)) + #define	EAT(c)	((SEE(c)) ? (NEXT(), 1) : 0) 8 #define	EATTWO(a, b)	((SEETWO(a, b)) ? (NEXT2(), 1) : 0) #define	NEXT()	(p->next++) #define	NEXT2()	(p->next += 2)! #define	NEXTn(n)	(p->next += (n))  #define	GETNEXT()	(*p->next++)" #define	SETERROR(e)	seterr(p, (e))3 #define	REQUIRE(co, e)	(void) ((co) || SETERROR(e)) ; #define	MUSTSEE(c, e)	(REQUIRE(MORE() && PEEK() == (c), e)) E #define	MUSTEAT(c, e)	(void) (REQUIRE(MORE() && GETNEXT() == (c), e)) ? #define	MUSTNOTSEE(c, e)	(REQUIRE(!MORE() || PEEK() != (c), e)) 3 #define	EMIT(op, sopnd)	doemit(p, (sop)(op), sopnd) C #define	INSERT(op, pos)	doinsert(p, (sop)(op), HERE()-(pos)+1, pos) / #define	AHEAD(pos)		dofwd(p, pos, HERE()-(pos)) . #define	ASTERN(sop, pos)	EMIT(sop, HERE()-pos) #define	HERE()		(p->slen)  #define	THERE()		(p->slen - 1)" #define	THERETHERE()	(p->slen - 2)  #define	DROP(n)	(p->slen -= (n))   #ifndef NDEBUG> static int never = 0;		/* for use in asserts; shuts lint up */ #else 5 #define	never	0		/* some <assert.h>s have bugs too */  #endif   /*1  - regcomp - interface for parser and compilation 4  = extern int regcomp(regex_t *, const char *, int);  = #define	REG_BASIC	0000   = #define	REG_EXTENDED	0001  = #define	REG_ICASE	0002   = #define	REG_NOSUB	0004   = #define	REG_NEWLINE	0010   = #define	REG_NOSPEC	0020  = #define	REG_PEND	0040  = #define	REG_DUMP	0200  */ / int				/* 0 success, otherwise REG_something */   mx_regcomp(preg, patdsc, cflags) regex_t *preg; struct dsc$descriptor *patdsc; int cflags;  {          const char *pattern; 	struct parse pa;  	struct re_guts *g;  	struct parse *p = &pa;  	int i;          unsigned short len;  #ifdef REDEBUG #	define	GOODFLAGS(f)	(f)  #else % #	define	GOODFLAGS(f)	((f)&~REG_DUMP)  #endif   	_DIAGASSERT(preg != NULL);  	_DIAGASSERT(pattern != NULL);   	cflags = GOODFLAGS(cflags);2 	if ((cflags&REG_EXTENDED) && (cflags&REG_NOSPEC)) 		return(REG_INVARG);   7         i = lib$analyze_sdesc (patdsc, &len, &pattern);          if (!(i & 1))              return REG_INVARG;  7 	/* do the mallocs early so failure handling is easy */ 6 	g = (struct re_guts *)malloc(sizeof(struct re_guts) + 							(NC-1)*sizeof(cat_t));  	if (g == NULL)  		return(REG_ESPACE); : 	p->ssize = len/(size_t)2*(size_t)3 + (size_t)1;	/* ugh */2 	p->strip = (sop *)malloc(p->ssize * sizeof(sop));
 	p->slen = 0;  	if (p->strip == NULL) {
 		free(g); 		return(REG_ESPACE);  	}   	/* set things up */
 	p->g = g;. 	/* LINTED convenience; we do not modify it */ 	p->next = (char *)pattern;  	p->end = p->next + len; 	p->error = 0; 	p->ncsalloc = 0;  	for (i = 0; i < NPAREN; i++) {  		p->pbegin[i] = 0;  		p->pend[i] = 0;  	} 	g->csetsize = NC; 	g->sets = NULL; 	g->setbits = NULL;  	g->ncsets = 0;  	g->cflags = cflags; 	g->iflags = 0; 
 	g->nbol = 0; 
 	g->neol = 0;  	g->must = NULL;
 	g->mlen = 0; 
 	g->nsub = 0; : 	g->ncategories = 1;	/* category 0 is "everything else" */+ 	g->categories = &g->catspace[-(CHAR_MIN)]; 9 	(void) memset((char *)g->catspace, 0, NC*sizeof(cat_t));  	g->backrefs = 0;    	/* do it */ 	EMIT(OEND, 0);  	g->firststate = THERE();  	if (cflags&REG_EXTENDED)  		p_ere(p, OUT); 	else if (cflags&REG_NOSPEC) 		p_str(p);  	else  		p_bre(p, OUT, OUT);  	EMIT(OEND, 0);  	g->laststate = THERE();  , 	/* tidy up loose ends and fill things in */ 	categorize(p, g); 	stripsnug(p, g);  	findmust(p, g); 	g->nplus = pluscount(p, g); 	g->magic = MAGIC2;  	preg->re_nsub = g->nsub;  	preg->re_g = g; 	preg->re_magic = MAGIC1;  #ifndef REDEBUG @ 	/* not debugging, so can't rely on the assert() in regexec() */ 	if (g->iflags&BAD)  		SETERROR(REG_ASSERT);  #endif   	/* win or lose, we're done */ 	if (p->error != 0)	/* lose */ 		mx_regfree(preg);  	return(p->error); }    /*>  - p_ere - ERE parser top level, concatenation and alternation1  == static void p_ere(struct parse *p, int stop);   */* static voidc p_ere(p, stop) struct parse *p;2 int stop;			/* character this ERE should end at */ {9 	char c;% 	sopno prevback = 0;	/* pacify gcc */9% 	sopno prevfwd = 0; 	/* pacify gcc */  	sopno conc;5 	int first = 1;		/* is this the first alternative? */s   	_DIAGASSERT(p != NULL);   	for (;;) {y. 		/* do a bunch of concatenated expressions */ 		conc = HERE();4 		while (MORE() && (c = PEEK()) != '|' && c != stop) 			p_ere_exp(p);< 		REQUIRE(HERE() != conc, REG_EMPTY);	/* require nonempty */   		if (!EAT('|')) 			break;		/* NOTE BREAK OUT */i   		if (first) {, 			INSERT(OCH_, conc);	/* offset is wrong */ 			prevfwd = conc; 			prevback = conc;r
 			first = 0;  		}i 		ASTERN(OOR1, prevback);s 		prevback = THERE(); - 		AHEAD(prevfwd);			/* fix previous offset */o 		prevfwd = HERE();a- 		EMIT(OOR2, 0);			/* offset is very wrong */d 	}  % 	if (!first) {		/* tail-end fixups */e 		AHEAD(prevfwd);  		ASTERN(O_CH, prevback);o 	}   	assert(!MORE() || SEE(stop)); }n   /*M  - p_ere_exp - parse one subERE, an atom possibly followed by a repetition opi+  == static void p_ere_exp(struct parse *p);r  */n static voido p_ere_exp(p) struct parse *p; {e 	char c; 	sopno pos;  	int count;v 	int count2;
 	sopno subno;  	int wascaret = 0;   	_DIAGASSERT(p != NULL);  7 	assert(MORE());		/* caller should have ensured this */S 	c = GETNEXT();*   	pos = HERE();
 	switch (c) {S
 	case '(': 		REQUIRE(MORE(), REG_EPAREN); 		p->g->nsub++;F 		subno = p->g->nsub;T 		if (subno < NPAREN)U 			p->pbegin[subno] = HERE();N 		EMIT(OLPAREN, subno);  		if (!SEE(')')) 			p_ere(p, ')');Y 		if (subno < NPAREN) {N 			p->pend[subno] = HERE();O 			assert(p->pend[subno] != 0);N 		}T 		EMIT(ORPAREN, subno);E 		MUSTEAT(')', REG_EPAREN);  		break; #ifndef POSIX_MISTAKER8 	case ')':		/* happens only if no current unmatched ( */ 		/*: 		 * You may ask, why the ifndef?  Because I didn't notice= 		 * this until slightly too late for 1003.2, and none of theW< 		 * other 1003.2 regular-expression reviewers noticed it at; 		 * all.  So an unmatched ) is legal POSIX, at least until( 		 * we can get it fixed.  		 */e 		SETERROR(REG_EPAREN);I 		break; #endif
 	case '^': 		EMIT(OBOL, 0); 		p->g->iflags |= USEBOL;. 		p->g->nbol++;/ 		wascaret = 1;C 		break;
 	case '$': 		EMIT(OEOL, 0); 		p->g->iflags |= USEEOL;  		p->g->neol++;  		break;
 	case '|': 		SETERROR(REG_EMPTY); 		break;
 	case '*':
 	case '+':
 	case '?': 		SETERROR(REG_BADRPT);e 		break;
 	case '.': 		if (p->g->cflags&REG_NEWLINE)r 			nonnewline(p);u 		else 			EMIT(OANY, 0);a 		break;
 	case '[': 		p_bracket(p);d 		break; 	case '\\':" 		REQUIRE(MORE(), REG_EESCAPE);e 		c = GETNEXT(); 		ordinary(p, c);* 		break;: 	case '{':		/* okay as ordinary except if digit follows */B 		REQUIRE(!MORE() || !isdigit((unsigned char)PEEK()), REG_BADRPT); 		/* FALLTHROUGH */ 	 	default:	 		ordinary(p, c);- 		break; 	}  
 	if (!MORE())		 		return;e 	c = PEEK();4 	/* we call { a repetition if followed by a digit */+ 	if (!( c == '*' || c == '+' || c == '?' ||p@ 	    (c == '{' && MORE2() && isdigit((unsigned char)PEEK2())) ))* 		return;		/* no repetition, we're done */ 	NEXT();    	REQUIRE(!wascaret, REG_BADRPT);
 	switch (c) {b" 	case '*':	/* implemented as +? */; 		/* this case does not require the (y|) trick, noKLUDGE */n 		INSERT(OPLUS_, pos); 		ASTERN(O_PLUS, pos); 		INSERT(OQUEST_, pos);  		ASTERN(O_QUEST, pos);e 		break;
 	case '+': 		INSERT(OPLUS_, pos); 		ASTERN(O_PLUS, pos); 		break;
 	case '?':; 		/* KLUDGE: emit y? as (y|) until subtle bug gets fixed */c1 		INSERT(OCH_, pos);		/* offset slightly wrong */_, 		ASTERN(OOR1, pos);		/* this one's right */" 		AHEAD(pos);			/* fix the OCH_ */- 		EMIT(OOR2, 0);			/* offset very wrong... */u& 		AHEAD(THERE());			/* ...so fix it */ 		ASTERN(O_CH, THERETHERE());) 		break;
 	case '{': 		count = p_count(p);, 		if (EAT(',')) {c( 			if (isdigit((unsigned char)PEEK())) { 				count2 = p_count(p);( 				REQUIRE(count <= count2, REG_BADBR);) 			} else		/* single number with comma */) 				count2 = INFINITY;$ 		} else		/* just a single number */ 			count2 = count;  		repeat(p, pos, count, count2);) 		if (!EAT('}')) {	/* error heuristics */ " 			while (MORE() && PEEK() != '}') 				NEXT();) 			REQUIRE(MORE(), REG_EBRACE);t 			SETERROR(REG_BADBR);v 		}e 		break; 	}  
 	if (!MORE())o	 		return;  	c = PEEK();+ 	if (!( c == '*' || c == '+' || c == '?' ||nA 	    (c == '{' && MORE2() && isdigit((unsigned char)PEEK2())) ) ) 	 		return;( 	SETERROR(REG_BADRPT); })   /*.  - p_str - string (no metacharacters) "parser"'  == static void p_str(struct parse *p);e  */c static voidt p_str(p) struct parse *p; {*   	_DIAGASSERT(p != NULL);   	REQUIRE(MORE(), REG_EMPTY); 	while (MORE())* 		ordinary(p, GETNEXT());  }u   /*<  - p_bre - BRE parser top level, anchoring and concatenation2  == static void p_bre(struct parse *p, int end1, \  ==	int end2);A  * Giving end1 as OUT essentially eliminates the end1/end2 check.e  *J  * This implementation is a bit of a kludge, in that a trailing $ is firstH  * taken as an ordinary character and then revised to be an anchor.  TheH  * only undesirable side effect is that '$' gets included as a characterF  * category in such cases.  This is fairly harmless; not worth fixing.D  * The amount of lookahead needed to avoid this kludge is excessive.  */t static voidp p_bre(p, end1, end2) struct parse *p;, int end1;		/* first terminating character */- int end2;		/* second terminating character */_ {s
 	sopno start; , 	int first = 1;			/* first subexpression? */ 	int wasdollar = 0;r   	_DIAGASSERT(p != NULL);   	start = HERE();   	if (EAT('^')) { 		EMIT(OBOL, 0); 		p->g->iflags |= USEBOL;t 		p->g->nbol++;  	}( 	while (MORE() && !SEETWO(end1, end2)) {" 		wasdollar = p_simp_re(p, first); 		first = 0; 	}8 	if (wasdollar) {	/* oops, that was a trailing anchor */
 		DROP(1); 		EMIT(OEOL, 0); 		p->g->iflags |= USEEOL;e 		p->g->neol++;W 	}  < 	REQUIRE(HERE() != start, REG_EMPTY);	/* require nonempty */ }n   /*K  - p_simp_re - parse a simple RE, an atom possibly followed by a repetitione<  == static int p_simp_re(struct parse *p, int starordinary);  */&8 static int			/* was the simple RE an unbackslashed $? */ p_simp_re(p, starordinary) struct parse *p;> int starordinary;		/* is a leading * an ordinary character? */ {( 	int c;( 	int count;  	int count2; 	sopno pos;+ 	int i;n
 	sopno subno;e #	define	BACKSL	(1<<CHAR_BIT)n   	_DIAGASSERT(p != NULL);  ; 	pos = HERE();		/* repetion op, if any, covers from here */E  7 	assert(MORE());		/* caller should have ensured this */( 	c = GETNEXT();R 	if (c == '\\') {) 		REQUIRE(MORE(), REG_EESCAPE);i( 		c = BACKSL | (unsigned char)GETNEXT(); 	}
 	switch (c) {S
 	case '.': 		if (p->g->cflags&REG_NEWLINE)) 			nonnewline(p);, 		else 			EMIT(OANY, 0);, 		break;
 	case '[': 		p_bracket(p);e 		break; 	case BACKSL|'{':+ 		SETERROR(REG_BADRPT);o 		break; 	case BACKSL|'(':) 		p->g->nsub++;N 		subno = p->g->nsub;R 		if (subno < NPAREN)) 			p->pbegin[subno] = HERE();( 		EMIT(OLPAREN, subno);R+ 		/* the MORE here is an error heuristic */l# 		if (MORE() && !SEETWO('\\', ')'))i 			p_bre(p, '\\', ')');  		if (subno < NPAREN) {  			p->pend[subno] = HERE();/ 			assert(p->pend[subno] != 0);* 		}e 		EMIT(ORPAREN, subno);i) 		REQUIRE(EATTWO('\\', ')'), REG_EPAREN);t 		break;; 	case BACKSL|')':	/* should not get here -- must be user */0 	case BACKSL|'}':E 		SETERROR(REG_EPAREN);R 		break; 	case BACKSL|'1':G 	case BACKSL|'2':e 	case BACKSL|'3':1 	case BACKSL|'4':N 	case BACKSL|'5':i 	case BACKSL|'6':= 	case BACKSL|'7':2 	case BACKSL|'8':  	case BACKSL|'9':e 		i = (c&~BACKSL) - '0'; 		assert(i < NPAREN);g 		if (p->pend[i] != 0) { 			assert(i <= p->g->nsub);  			EMIT(OBACK_, i);  			assert(p->pbegin[i] != 0);a1 			assert(OP(p->strip[p->pbegin[i]]) == OLPAREN);&/ 			assert(OP(p->strip[p->pend[i]]) == ORPAREN);d. 			(void) dupl(p, p->pbegin[i]+1, p->pend[i]); 			EMIT(O_BACK, i);	 		} else 			SETERROR(REG_ESUBREG);E 		p->g->backrefs = 1;I 		break;
 	case '*':$ 		REQUIRE(starordinary, REG_BADRPT); 		/* FALLTHROUGH */N	 	default:l 		ordinary(p, c &~ BACKSL);G 		break; 	}  ) 	if (EAT('*')) {		/* implemented as +? */&; 		/* this case does not require the (y|) trick, noKLUDGE */V 		INSERT(OPLUS_, pos); 		ASTERN(O_PLUS, pos); 		INSERT(OQUEST_, pos);t 		ASTERN(O_QUEST, pos);e  	} else if (EATTWO('\\', '{')) { 		count = p_count(p);  		if (EAT(',')) {u2 			if (MORE() && isdigit((unsigned char)PEEK())) { 				count2 = p_count(p);( 				REQUIRE(count <= count2, REG_BADBR);) 			} else		/* single number with comma */N 				count2 = INFINITY;$ 		} else		/* just a single number */ 			count2 = count;  		repeat(p, pos, count, count2);2 		if (!EATTWO('\\', '}')) {	/* error heuristics */' 			while (MORE() && !SEETWO('\\', '}'))c 				NEXT();  			REQUIRE(MORE(), REG_EBRACE);  			SETERROR(REG_BADBR);- 		}[A 	} else if (c == (unsigned char)'$')	/* $ (but not \$) ends it */U 		return(1);   	return(0);f }s   /*%  - p_count - parse a repetition count (  == static int p_count(struct parse *p);  */  static int			/* the value */
 p_count(p) struct parse *p; {h 	int count = 0;> 	int ndigits = 0;t   	_DIAGASSERT(p != NULL);  F 	while (MORE() && isdigit((unsigned char)PEEK()) && count <= DUPMAX) {' 		count = count*10 + (GETNEXT() - '0');s 		ndigits++; 	}  4 	REQUIRE(ndigits > 0 && count <= DUPMAX, REG_BADBR); 	return(count);E }    /*/  - p_bracket - parse a bracketed character listD+  == static void p_bracket(struct parse *p);u  *M  * Note a significant property of this code:  if the allocset() did SETERROR,s  * no set operations are done.  */; static void  p_bracket(p) struct parse *p; { 
 	cset *cs; 	int invert = 0;   	_DIAGASSERT(p != NULL);   	cs = allocset(p);  3 	/* Dept of Truly Sickening Special-Case Kludges */ 7 	if (p->next + 5 < p->end && strncmp(p->next, "[:<:]]",  					    (size_t)6) == 0) {i 		EMIT(OBOW, 0); 		NEXTn(6);		 		return;p 	}7 	if (p->next + 5 < p->end && strncmp(p->next, "[:>:]]",o 					    (size_t)6) == 0) {t 		EMIT(OEOW, 0); 		NEXTn(6);(	 		return;e 	}   	if (EAT('^'))0 		invert++;	/* make note to invert set at end */ 	if (EAT(']')) 		CHadd(cs, ']');h 	else if (EAT('-'))c 		CHadd(cs, '-');b5 	while (MORE() && PEEK() != ']' && !SEETWO('-', ']'))i 		p_b_term(p, cs); 	if (EAT('-')) 		CHadd(cs, '-');h 	MUSTEAT(']', REG_EBRACK);  6 	if (p->error != 0)	/* don't mess things up further */	 		return;a   	if (p->g->cflags&REG_ICASE) { 		int i;	 		int ci;&  + 		for (i = p->g->csetsize - 1; i >= 0; i--)p# 			if (CHIN(cs, i) && isalpha(i)) {M 				ci = othercase(i); 				if (ci != i) 					CHadd(cs, ci);  			} 		if (cs->multis != NULL)) 			mccase(p, cs);  	} 	if (invert) { 		int i;  + 		for (i = p->g->csetsize - 1; i >= 0; i--)r 			if (CHIN(cs, i))E 				CHsub(cs, i);s 			elsea 				CHadd(cs, i);H 		if (p->g->cflags&REG_NEWLINE)f 			CHsub(cs, '\n');  		if (cs->multis != NULL)	 			mcinvert(p, cs);o 	}  ' 	assert(cs->multis == NULL);		/* xxx */s  6 	if (nch(p, cs) == 1) {		/* optimize singleton sets */ 		ordinary(p, firstch(p, cs)); 		freeset(p, cs);e 	} elser! 		EMIT(OANYOF, freezeset(p, cs));l }d   /*:  - p_b_term - parse one term of a bracketed character list4  == static void p_b_term(struct parse *p, cset *cs);  */c static voido p_b_term(p, cs)t struct parse *p;	 cset *cs;o {  	char c; 	char start, finish; 	int i;U   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(cs != NULL);    	/* classify what we've got */$ 	switch ((MORE()) ? PEEK() : '\0') {
 	case '[':! 		c = (MORE2()) ? PEEK2() : '\0';+ 		break;  
 	case '-': 		SETERROR(REG_ERANGE);U 		return;			/* NOTE RETURN */N  	 	default:R 		c = '\0';  		break; 	}  
 	switch (c) {)! 	case ':':		/* character class */p
 		NEXT2(); 		REQUIRE(MORE(), REG_EBRACK);
 		c = PEEK(); , 		REQUIRE(c != '-' && c != ']', REG_ECTYPE); 		p_b_cclass(p, cs); 		REQUIRE(MORE(), REG_EBRACK);( 		REQUIRE(EATTWO(':', ']'), REG_ECTYPE); 		break;# 	case '=':		/* equivalence class */d
 		NEXT2(); 		REQUIRE(MORE(), REG_EBRACK);
 		c = PEEK();l. 		REQUIRE(c != '-' && c != ']', REG_ECOLLATE); 		p_b_eclass(p, cs); 		REQUIRE(MORE(), REG_EBRACK);* 		REQUIRE(EATTWO('=', ']'), REG_ECOLLATE); 		break;5 	default:		/* symbol, ordinary character, or range */A- /* xxx revision needed for multichar stuff */O 		start = p_b_symbol(p);. 		if (SEE('-') && MORE2() && PEEK2() != ']') { 			/* range */
 			NEXT(); 			if (EAT('-')) 				finish = '-';  			elsee 				finish = p_b_symbol(p);  		} else 			finish = start;) /* xxx what about signed chars here... */E' 		REQUIRE(start <= finish, REG_ERANGE);:# 		for (i = start; i <= finish; i++)	 			CHadd(cs, i); 		break; 	} }A   /*=  - p_b_cclass - parse a character-class name and deal with it'6  == static void p_b_cclass(struct parse *p, cset *cs);  */i static void  p_b_cclass(p, cs): struct parse *p;	 cset *cs;i {i
 	char *sp; 	const struct cclass *cp;s 	size_t len; 	const char *u;E 	char c;   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(cs != NULL);    	sp = p->next;  1 	while (MORE() && isalpha((unsigned char)PEEK())) 	 		NEXT();n 	len = p->next - sp;, 	for (cp = cclasses; cp->name != NULL; cp++)? 		if (strncmp(cp->name, sp, len) == 0 && cp->name[len] == '\0'))	 			break;u 	if (cp->name == NULL) { 		/* oops, didn't find it */ 		SETERROR(REG_ECTYPE);;	 		return;c 	}   	u = cp->chars;l 	while ((c = *u++) != '\0')a 		CHadd(cs, c);r5 	for (u = cp->multis; *u != '\0'; u += strlen(u) + 1)  		MCadd(p, cs, u); }    /*@  - p_b_eclass - parse an equivalence-class name and deal with it6  == static void p_b_eclass(struct parse *p, cset *cs);  *)  * This implementation is incomplete. xxxt  */b static voidf p_b_eclass(p, cs)O struct parse *p;	 cset *cs;y {o 	char c;   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(cs != NULL);)   	c = p_b_coll_elem(p, '=');O 	CHadd(cs, c); }t   /*K  - p_b_symbol - parse a character or [..]ed multicharacter collating symbolR,  == static char p_b_symbol(struct parse *p);  */,# static char			/* value of symbol */(
 p_b_symbol(p)E struct parse *p; {= 	char value;   	_DIAGASSERT(p != NULL);   	REQUIRE(MORE(), REG_EBRACK);e 	if (!EATTWO('[', '.'))	 		return(GETNEXT());   	/* collating symbol */n 	value = p_b_coll_elem(p, '.');e) 	REQUIRE(EATTWO('.', ']'), REG_ECOLLATE);' 	return(value);r }i   /*@  - p_b_coll_elem - parse a collating-element name and look it up9  == static char p_b_coll_elem(struct parse *p, int endc);;  */ . static char			/* value of collating element */ p_b_coll_elem(p, endc) struct parse *p;( int endc;			/* name ended by endc,']' */ {d
 	char *sp; 	const struct cname *cp; 	size_t len;   	_DIAGASSERT(p != NULL);   	sp = p->next;  % 	while (MORE() && !SEETWO(endc, ']'))t	 		NEXT();* 	if (!MORE()) {c 		SETERROR(REG_EBRACK);p 		return(0); 	} 	len = p->next - sp;* 	for (cp = cnames; cp->name != NULL; cp++)? 		if (strncmp(cp->name, sp, len) == 0 && cp->name[len] == '\0')e% 			return(cp->code);	/* known name */n 	if (len == 1)% 		return(*sp);	/* single character */=( 	SETERROR(REG_ECOLLATE);			/* neither */ 	return(0);t }t   /*;  - othercase - return the case counterpart of an alphabeticg"  == static char othercase(int ch);  */n0 static char			/* if no counterpart, return ch */
 othercase(ch)  int ch;n {i 	assert(isalpha(ch));a 	if (isupper(ch))  		return(tolower(ch)); 	else if (islower(ch)) 		return(toupper(ch));( 	else			/* peculiar, but could happen */
 		return(ch);d }i   /*>  - bothcases - emit a dualcase version of a two-case character3  == static void bothcases(struct parse *p, int ch);e  */  * Boy, is this implementation ever a kludge...   */s static void  bothcases(p, ch) struct parse *p; int ch;  {t 	char *oldnext;  	char *oldend; 	char bracket[3];t   	_DIAGASSERT(p != NULL);   	oldnext = p->next;	 	oldend = p->end;B  = 	assert(othercase(ch) != ch);	/* p_bracket() would recurse */) 	p->next = bracket;i 	p->end = bracket+2; 	bracket[0] = ch;w 	bracket[1] = ']'; 	bracket[2] = '\0';a 	p_bracket(p); 	assert(p->next == bracket+2); 	p->next = oldnext;	 	p->end = oldend;  }R   /*(  - ordinary - emit an ordinary character2  == static void ordinary(struct parse *p, int ch);  */n static voidy ordinary(p, ch)p struct parse *p; int ch;s {_ 	cat_t *cap;   	_DIAGASSERT(p != NULL);   	cap = p->g->categories;< 	if ((p->g->cflags&REG_ICASE) && isalpha((unsigned char) ch)< 	    && othercase((unsigned char) ch) != (unsigned char) ch)# 		bothcases(p, (unsigned char) ch);t 	else { ! 		EMIT(OCHAR, (unsigned char)ch);n 		if (cap[ch] == 0)e! 			cap[ch] = p->g->ncategories++;G 	} }p   /*0  - nonnewline - emit REG_NEWLINE version of OANY,  == static void nonnewline(struct parse *p);  */  * Boy, is this implementation ever a kludge...i  */= static void	
 nonnewline(p)  struct parse *p; {  	char *oldnext;d 	char *oldend; 	char bracket[4];S   	_DIAGASSERT(p != NULL);   	oldnext = p->next;n 	oldend = p->end;l   	p->next = bracket;  	p->end = bracket+3; 	bracket[0] = '^'; 	bracket[1] = '\n';' 	bracket[2] = ']'; 	bracket[3] = '\0';  	p_bracket(p); 	assert(p->next == bracket+3); 	p->next = oldnext;u 	p->end = oldend;p }b   /*I  - repeat - generate code for a bounded repetition, recursively if neededhG  == static void repeat(struct parse *p, sopno start, int from, int to);)  */	 static voidP repeat(p, start, from, to) struct parse *p;6 sopno start;			/* operand from here to end of strip */+ int from;			/* repeated from this number */t9 int to;				/* to this number of times (maybe INFINITY) */t {  	sopno finish; #	define	N	2 #	define	INF	3  #	define	REP(f, t)	((f)*8 + (t))@ #	define	MAP(n)	(((n) <= 1) ? (n) : ((n) == INFINITY) ? INF : N) 	sopno copy;   	_DIAGASSERT(p != NULL);   	finish = HERE();s  = 	if (p->error != 0)	/* head off possible runaway recursion */s	 		return;A   	assert(from <= to);  # 	switch (REP(MAP(from), MAP(to))) { 0 	case REP(0, 0):			/* must be user doing this */, 		DROP(finish-start);	/* drop the operand */ 		break;# 	case REP(0, 1):			/* as x{1,1}? */ # 	case REP(0, N):			/* as x{1,n}? */i# 	case REP(0, INF):		/* as x{1,}? */ ; 		/* KLUDGE: emit y? as (y|) until subtle bug gets fixed */=0 		INSERT(OCH_, start);		/* offset is wrong... */ 		repeat(p, start+1, 1, to); 		ASTERN(OOR1, start);" 		AHEAD(start);			/* ... fix it */ 		EMIT(OOR2, 0); 		AHEAD(THERE());d 		ASTERN(O_CH, THERETHERE());  		break;% 	case REP(1, 1):			/* trivial case */T 		/* done */ 		break;& 	case REP(1, N):			/* as x?x{1,n-1} */; 		/* KLUDGE: emit y? as (y|) until subtle bug gets fixed */  		INSERT(OCH_, start); 		ASTERN(OOR1, start); 		AHEAD(start);g- 		EMIT(OOR2, 0);			/* offset very wrong... */u& 		AHEAD(THERE());			/* ...so fix it */ 		ASTERN(O_CH, THERETHERE());n$ 		copy = dupl(p, start+1, finish+1); 		assert(copy == finish+4);i 		repeat(p, copy, 1, to-1);o 		break; 	case REP(1, INF):		/* as x+ */f 		INSERT(OPLUS_, start); 		ASTERN(O_PLUS, start); 		break;' 	case REP(N, N):			/* as xx{m-1,n-1} */   		copy = dupl(p, start, finish);  		repeat(p, copy, from-1, to-1); 		break;( 	case REP(N, INF):		/* as xx{n-1,INF} */  		copy = dupl(p, start, finish); 		repeat(p, copy, from-1, to); 		break;  	default:			/* "can't happen" */* 		SETERROR(REG_ASSERT);	/* just in case */ 		break; 	} }    /*"  - seterr - set an error condition.  == static int seterr(struct parse *p, int e);  */L8 static int			/* useless but makes type checking happy */ seterr(p, e) struct parse *p; int e; {E   	_DIAGASSERT(p != NULL);  7 	if (p->error == 0)	/* keep earliest error condition */R 		p->error = e;)5 	p->next = nuls;		/* try to bring things to a halt */r 	p->end = nuls;c5 	return(0);		/* make the return value well-defined */f }n   /*1  - allocset - allocate a set of characters for []s+  == static cset *allocset(struct parse *p);c  */ 
 static cset *  allocset(p)* struct parse *p; {i 	int no; 	size_t nc;G 	size_t nbytes;;
 	cset *cs; 	size_t css; 	int i;o   	_DIAGASSERT(p != NULL);   	no = p->g->ncsets++;e 	css = (size_t)p->g->csetsize;< 	if (no >= p->ncsalloc) {	/* need another column of space */ 		p->ncsalloc += CHAR_BIT; 		nc = p->ncsalloc;< 		assert(nc % CHAR_BIT == 0);> 		nbytes = nc / CHAR_BIT * css;  		if (p->g->sets == NULL)T* 			p->g->sets = malloc(nc * sizeof(cset)); 		else7 			p->g->sets = realloc(p->g->sets, nc * sizeof(cset));	 		if (p->g->setbits == NULL)" 			p->g->setbits = malloc(nbytes); 		else {2 			p->g->setbits = realloc(p->g->setbits, nbytes);4 			/* xxx this isn't right if setbits is now NULL */ 			for (i = 0; i < no; i++)r9 				p->g->sets[i].ptr = p->g->setbits + css*(i/CHAR_BIT);  		}p2 		if (p->g->sets != NULL && p->g->setbits != NULL)8 			(void) memset((char *)p->g->setbits + (nbytes - css), 								0, css); 		else {
 			no = 0; 			SETERROR(REG_ESPACE);2 			/* caller's responsibility not to do set ops */ 		}	 	}  & 	assert(p->g->sets != NULL);	/* xxx */ 	cs = &p->g->sets[no];/ 	cs->ptr = p->g->setbits + css*((no)/CHAR_BIT);	# 	cs->mask = 1 << ((no) % CHAR_BIT);( 	cs->hash = 0; 	cs->smultis = 0;W 	cs->multis = NULL;'   	return(cs); }u   /*"  - freeset - free a now-unused set3  == static void freeset(struct parse *p, cset *cs);h  */s static void  freeset(p, cs) struct parse *p;	 cset *cs;s {( 	int i;  	cset *top;c 	size_t css;   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(cs != NULL);t  ! 	top = &p->g->sets[p->g->ncsets];h 	css = (size_t)p->g->csetsize;   	for (i = 0; i < css; i++) 		CHsub(cs, i);c2 	if (cs == top-1)	/* recover only the easy case */ 		p->g->ncsets--;c }    /*6  - freezeset - final processing on a set of characters4  == static int freezeset(struct parse *p, cset *cs);  *I  * The main task here is merging identical sets.  This is usually a waste\G  * of time (although the hash code minimizes the overhead), but can winTJ  * big if REG_ICASE is being used.  REG_ICASE, by the way, is why the hashG  * is done using addition rather than xor -- all ASCII [aA] sets xor toK  * the same value!  */U static int			/* set number */C freezeset(p, cs) struct parse *p;	 cset *cs;  {_ 	uch h;  	int i;( 	cset *top;] 	cset *cs2;E 	size_t css;   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(cs != NULL);U   	h = cs->hash;! 	top = &p->g->sets[p->g->ncsets];  	css = (size_t)p->g->csetsize;  0 	/* look for an earlier one which is the same */- 	for (cs2 = &p->g->sets[0]; cs2 < top; cs2++);$ 		if (cs2->hash == h && cs2 != cs) { 			/* maybe */ 			for (i = 0; i < css; i++)( 				if (!!CHIN(cs2, i) != !!CHIN(cs, i)) 					break;		/* no */E 			if (i == css) 				break;			/* yes */ 		}a  ! 	if (cs2 < top) {	/* found one */  		freeset(p, cs);  		cs = cs2;	 	}    	return((int)(cs - p->g->sets)); }s   /*K  - firstch - return first character in a set (which must have at least one)R2  == static int firstch(struct parse *p, cset *cs);  */a6 static int			/* character; there is no "none" value */ firstch(p, cs) struct parse *p;	 cset *cs;= {t 	int i;  	size_t css;   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(cs != NULL);s   	css = (size_t)p->g->csetsize;   	for (i = 0; i < css; i++) 		if (CHIN(cs, i)) 			return((char)i);c 	assert(never);; 	return(0);		/* arbitrary */ }I   /*&  - nch - number of characters in a set.  == static int nch(struct parse *p, cset *cs);  */E
 static int
 nch(p, cs) struct parse *p;	 cset *cs;- {m 	int i;; 	size_t css; 	int n = 0;a   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(cs != NULL);u   	css = (size_t)p->g->csetsize;   	for (i = 0; i < css; i++) 		if (CHIN(cs, i)) 			n++;c 	return(n);c }c   /*,  - mcadd - add a collating element to a cset2  == static void mcadd(struct parse *p, cset *cs, \  ==	char *cp);  */, static void* mcadd(p, cs, cp) struct parse *p;	 cset *cs;m const char *cp;t {= 	size_t oldend;_   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(cs != NULL);n 	_DIAGASSERT(cp != NULL);    	oldend = cs->smultis;   	cs->smultis += strlen(cp) + 1;t 	if (cs->multis == NULL)# 		cs->multis = malloc(cs->smultis);c 	elseL0 		cs->multis = realloc(cs->multis, cs->smultis); 	if (cs->multis == NULL) { 		SETERROR(REG_ESPACE);.	 		return;a 	}  , 	(void) strcpy(cs->multis + oldend - 1, cp);$ 	cs->multis[cs->smultis - 1] = '\0'; }*   #if 0  /*3  - mcsub - subtract a collating element from a cseta*  == static void mcsub(cset *cs, char *cp);  */( static void)
 mcsub(cs, cp)O	 cset *cs;		 char *cp;G {E
 	char *fp; 	size_t len;   	_DIAGASSERT(cs != NULL);l 	_DIAGASSERT(cp != NULL);W   	fp = mcfind(cs, cp);) 	len = strlen(fp);   	assert(fp != NULL);! 	(void) memmove(fp, fp + len + 1,m/ 				cs->smultis - (fp + len + 1 - cs->multis));t 	cs->smultis -= len;   	if (cs->smultis == 0) { 		free(cs->multis);l 		cs->multis = NULL;	 		return;  	}  / 	cs->multis = realloc(cs->multis, cs->smultis);  	assert(cs->multis != NULL); }    /*+  - mcin - is a collating element in a cset?;(  == static int mcin(cset *cs, char *cp);  */(
 static int mcin(cs, cp)	 cset *cs;)	 char *cp;E {R   	_DIAGASSERT(cs != NULL);  	_DIAGASSERT(cp != NULL);f    	return(mcfind(cs, cp) != NULL); })   /*.  - mcfind - find a collating element in a cset,  == static char *mcfind(cset *cs, char *cp);  */n
 static char *) mcfind(cs, cp)	 cset *cs;c	 char *cp;= {S	 	char *p;_   	_DIAGASSERT(cs != NULL);r 	_DIAGASSERT(cp != NULL);h   	if (cs->multis == NULL) 		return(NULL);p5 	for (p = cs->multis; *p != '\0'; p += strlen(p) + 1)t 		if (strcmp(cp, p) == 0)a
 			return(p);/ 	return(NULL); }n #endif   /*=  - mcinvert - invert the list of collating elements in a cset;4  == static void mcinvert(struct parse *p, cset *cs);  *D  * This would have to know the set of possibilities.  Implementation  * is deferred.a  */r /* ARGSUSED */ static void  mcinvert(p, cs)o struct parse *p;	 cset *cs;c {e   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(cs != NULL);   & 	assert(cs->multis == NULL);	/* xxx */ }p   /*M  - mccase - add case counterparts of the list of collating elements in a csetG2  == static void mccase(struct parse *p, cset *cs);  *D  * This would have to know the set of possibilities.  Implementation  * is deferred.a  */i /* ARGSUSED */ static voidk
 mccase(p, cs)b struct parse *p;	 cset *cs;  {\   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(cs != NULL);p  & 	assert(cs->multis == NULL);	/* xxx */ }    /*,  - isinsets - is this character in any sets?2  == static int isinsets(struct re_guts *g, int c);  */c static int			/* predicate */ isinsets(g, c) struct re_guts *g; int c; {I
 	uch *col; 	int i;  	int ncols;-  	unsigned uc = (unsigned char)c;   	_DIAGASSERT(g != NULL);  - 	ncols = (g->ncsets+(CHAR_BIT-1)) / CHAR_BIT;h  B 	for (i = 0, col = g->setbits; i < ncols; i++, col += g->csetsize) 		if (col[uc] != 0)s
 			return(1);n 	return(0);h }=   /*@  - samesets - are these two characters in exactly the same sets?;  == static int samesets(struct re_guts *g, int c1, int c2);s  */  static int			/* predicate */ samesets(g, c1, c2)  struct re_guts *g; int c1;i int c2;w {e
 	uch *col; 	int i;; 	int ncols;o" 	unsigned uc1 = (unsigned char)c1;" 	unsigned uc2 = (unsigned char)c2;   	_DIAGASSERT(g != NULL);  - 	ncols = (g->ncsets+(CHAR_BIT-1)) / CHAR_BIT;   B 	for (i = 0, col = g->setbits; i < ncols; i++, col += g->csetsize) 		if (col[uc1] != col[uc2])p
 			return(0);a 	return(1);  }b   /*-  - categorize - sort out character categories ?  == static void categorize(struct parse *p, struct re_guts *g);u  */l static void  categorize(p, g) struct parse *p; struct re_guts *g; {o
 	cat_t *cats;* 	int c;c 	int c2; 	cat_t cat;,   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(g != NULL);   	cats = g->categories;  * 	/* avoid making error situations worse */ 	if (p->error != 0)o	 		return;r  ' 	for (c = CHAR_MIN; c <= CHAR_MAX; c++)f' 		if (cats[c] == 0 && isinsets(g, c)) {e 			cat = g->ncategories++; 			cats[c] = cat;(' 			for (c2 = c+1; c2 <= CHAR_MAX; c2++) , 				if (cats[c2] == 0 && samesets(g, c, c2)) 					cats[c2] = cat; 		}i }p   /*-  - dupl - emit a duplicate of a bunch of sops*B  == static sopno dupl(struct parse *p, sopno start, sopno finish);  */)' static sopno			/* start of duplicate */d dupl(p, start, finish) struct parse *p; sopno start;			/* from here */& sopno finish;			/* to this less one */ {( 	sopno ret;s 	sopno len = finish - start;   	_DIAGASSERT(p != NULL);   	ret = HERE();   	assert(finish >= start);x 	if (len == 0) 		return(ret);A 	enlarge(p, p->ssize + len);	/* this many unexpected additions */R# 	assert(p->ssize >= p->slen + len);f3 	(void)memcpy(p->strip + p->slen, p->strip + start,E  	    (size_t)len * sizeof(sop)); 	p->slen += len;
 	return(ret);a }*   /*!  - doemit - emit a strip operatorN=  == static void doemit(struct parse *p, sop op, size_t opnd);b  *G  * It might seem better to implement this as a macro with a function asAE  * hard-case backup, but it's just too big and messy unless there areR5  * some changes to the data structures.  Maybe later.)  */	 static void, doemit(p, op, opnd)  struct parse *p; sop op;i sopno opnd;  {y   	_DIAGASSERT(p != NULL);  * 	/* avoid making error situations worse */ 	if (p->error != 0)P	 		return;;  A 	/* deal with oversize operands ("can't happen", more or less) */, 	assert(opnd < 1<<OPSHIFT);   ! 	/* deal with undersized strip */  	if (p->slen >= p->ssize)I. 		enlarge(p, (p->ssize+1) / 2 * 3);	/* +50% */ 	assert(p->slen < p->ssize);  1 	/* finally, it's all reduced to the easy case */G% 	p->strip[p->slen++] = SOP(op, opnd);  }    /*)  - doinsert - insert a sop into the strip J  == static void doinsert(struct parse *p, sop op, size_t opnd, sopno pos);  */e static voidn doinsert(p, op, opnd, pos) struct parse *p; sop op;  sopno opnd;T
 sopno pos; { 
 	sopno sn; 	sop s;* 	int i;l   	_DIAGASSERT(p != NULL);  * 	/* avoid making error situations worse */ 	if (p->error != 0)*	 		return;   
 	sn = HERE();(/ 	EMIT(op, opnd);		/* do checks, ensure space */n 	assert(HERE() == sn+1); 	s = p->strip[sn];   	/* adjust paren pointers */ 	assert(pos > 0);e 	for (i = 1; i < NPAREN; i++) {o 		if (p->pbegin[i] >= pos) { 			p->pbegin[i]++; 		}  		if (p->pend[i] >= pos) { 			p->pend[i]++; 		}o 	}  G 	memmove(&p->strip[pos+1], &p->strip[pos], (HERE()-pos-1)*sizeof(sop));e 	p->strip[pos] = s;> }a   /*'  - dofwd - complete a forward reference-=  == static void dofwd(struct parse *p, sopno pos, sop value);R  */= static voidt dofwd(p, pos, value) struct parse *p;
 sopno pos; sopno value; {    	_DIAGASSERT(p != NULL);  * 	/* avoid making error situations worse */ 	if (p->error != 0) 	 		return;>   	assert(value < 1<<OPSHIFT);+ 	p->strip[pos] = OP(p->strip[pos]) | value;i }=   /*  - enlarge - enlarge the strip5  == static void enlarge(struct parse *p, sopno size);r  */  static void+ enlarge(p, size) struct parse *p; sopno size;i {A	 	sop *sp;	   	_DIAGASSERT(p != NULL);   	if (p->ssize >= size)	 		return;   1 	sp = (sop *)realloc(p->strip, size*sizeof(sop));	 	if (sp == NULL) { 		SETERROR(REG_ESPACE);(	 		return;; 	} 	p->strip = sp;o 	p->ssize = size;  }    /*   - stripsnug - compact the strip>  == static void stripsnug(struct parse *p, struct re_guts *g);  */+ static voidA stripsnug(p, g)s struct parse *p; struct re_guts *g; {    	_DIAGASSERT(p != NULL); 	_DIAGASSERT(g != NULL);   	g->nstates = p->slen;5 	g->strip = realloc(p->strip, p->slen * sizeof(sop));u 	if (g->strip == NULL) { 		SETERROR(REG_ESPACE);e 		g->strip = p->strip; 	} }t   /*I  - findmust - fill in must and mlen with longest mandatory literal stringI=  == static void findmust(struct parse *p, struct re_guts *g);c  *H  * This algorithm could do fancy things like analyzing the operands of |I  * for common subsequences.  Someday.  This code is simple and finds most   * of the interesting cases.  *8  * Note that must and mlen got initialized during setup.  */s static voids findmust(p, g) struct parse *p; struct re_guts *g; {  	sop *scan;l 	sop *start = NULL;e 	sop *newstart = NULL; 	sopno newlen; 	sop s; 
 	char *cp;	 	sopno i;    	_DIAGASSERT(p != NULL); 	_DIAGASSERT(g != NULL);  * 	/* avoid making error situations worse */ 	if (p->error != 0)[	 		return;r  / 	/* find the longest OCHAR sequence in strip */  	newlen = 0; 	scan = g->strip + 1;p 	do {; 		s = *scan++; 		switch (OP(s)) {$ 		case OCHAR:		/* sequence member */' 			if (newlen == 0)		/* new sequence */S 				newstart = scan - 1; 			newlen++;	 			break;>1 		case OPLUS_:		/* things that don't break one */; 		case OLPAREN:a 		case ORPAREN:c	 			break;m2 		case OQUEST_:		/* things that must be skipped */ 		case OCH_:
 			scan--; 			do {) 				scan += OPND(s); 				s = *scan;/ 				/* assert() interferes w debug printouts */i, 				if (OP(s) != O_QUEST && OP(s) != O_CH && 							OP(s) != OOR2) {	 					g->iflags |= BAD; 					return; 				}r/ 			} while (OP(s) != O_QUEST && OP(s) != O_CH);( 			/* FALLTHROUGH */. 		default:		/* things that break a sequence */* 			if (newlen > g->mlen) {		/* ends one */ 				start = newstart;  				g->mlen = newlen;* 			} 			newlen = 0;	 			break;e 		}  	} while (OP(s) != OEND);(  ) 	if (g->mlen == 0)		/* there isn't one */t	 		return;_  & 	/* turn it into a character string */' 	g->must = malloc((size_t)g->mlen + 1);>3 	if (g->must == NULL) {		/* argh; just forget it */N 		g->mlen = 0;	 		return;) 	} 	cp = g->must; 	scan = start;  	for (i = g->mlen; i > 0; i--) {" 		while (OP(s = *scan++) != OCHAR) 			continue;! 		assert(cp < g->must + g->mlen);  		*cp++ = (char)OPND(s); 	}! 	assert(cp == g->must + g->mlen);;0 	*cp++ = '\0';		/* just on general principles */ }L   /*  - pluscount - count + nesting?  == static sopno pluscount(struct parse *p, struct re_guts *g);H  */," static sopno			/* nesting depth */ pluscount(p, g)d struct parse *p; struct re_guts *g; {c 	sop *scan;t 	sop s;e 	sopno plusnest = 0; 	sopno maxnest = 0;t   	_DIAGASSERT(p != NULL); 	_DIAGASSERT(g != NULL);   	if (p->error != 0)=+ 		return(0);	/* there may not be an OEND */;   	scan = g->strip + 1;) 	do {I 		s = *scan++; 		switch (OP(s)) { 		case OPLUS_: 			plusnest++;	 			break;+ 		case O_PLUS: 			if (plusnest > maxnest) 				maxnest = plusnest;  			plusnest--;	 			break;l 		}- 	} while (OP(s) != OEND);  	if (plusnest != 0){ 		g->iflags |= BAD;C 	return(maxnest);} } 