 /*I  * valid.c : part of the code use to do the DTD handling and the validity   *           checking   *1  * See Copyright for the status of this software.   *  * Daniel.Veillard@w3.org   */    #ifdef WIN32 #include "win32config.h" #else  #include "config.h"  #endif   #include <stdio.h> #include <string.h>    #ifdef HAVE_STDLIB_H #include <stdlib.h>  #endif   #include <libxml/xmlmemory.h>  #include <libxml/valid.h>  #include <libxml/parser.h># #include <libxml/parserInternals.h>    /*@  * Generic function for accessing stacks in the Validity Context  */   - #define PUSH_AND_POP(scope, type, name)					\ < scope int name##VPush(xmlValidCtxtPtr ctxt, type value) {		\1     if (ctxt->name##Nr >= ctxt->name##Max) {				\  	ctxt->name##Max *= 2;						\ A         ctxt->name##Tab = (type *) xmlRealloc(ctxt->name##Tab,		\ > 	             ctxt->name##Max * sizeof(ctxt->name##Tab[0]));	\,         if (ctxt->name##Tab == NULL) {					\/ 	    fprintf(stderr, "realloc failed !\n");			\  	    return(0);							\  	}								\      }									\ 1     ctxt->name##Tab[ctxt->name##Nr] = value;				\      ctxt->name = value;							\ $     return(ctxt->name##Nr++);						\ }									\ 2 scope type name##VPop(xmlValidCtxtPtr ctxt) {				\     type ret;								\-     if (ctxt->name##Nr <= 0) return(0);					\      ctxt->name##Nr--;							\ "     if (ctxt->name##Nr > 0)						\5 	ctxt->name = ctxt->name##Tab[ctxt->name##Nr - 1];		\      else								\ !         ctxt->name = NULL;						\ /     ret = ctxt->name##Tab[ctxt->name##Nr];				\ -     ctxt->name##Tab[ctxt->name##Nr] = 0;				\      return(ret);							\ }									\   & PUSH_AND_POP(static, xmlNodePtr, node)   /* #define DEBUG_VALID_ALGO */   #ifdef DEBUG_VALID_ALGO , void xmlValidPrintNodeList(xmlNodePtr cur) {     if (cur == NULL) 	fprintf(stderr, "null ");     while (cur != NULL) {  	switch (cur->type) {  	    case XML_ELEMENT_NODE: $ 		fprintf(stderr, "%s ", cur->name); 		break; 	    case XML_TEXT_NODE: 		fprintf(stderr, "text ");  		break;! 	    case XML_CDATA_SECTION_NODE:  		fprintf(stderr, "cdata "); 		break; 	    case XML_ENTITY_REF_NODE:& 		fprintf(stderr, "&%s; ", cur->name); 		break; 	    case XML_PI_NODE:( 		fprintf(stderr, "pi(%s) ", cur->name); 		break; 	    case XML_COMMENT_NODE:  		fprintf(stderr, "comment "); 		break; 	    case XML_ATTRIBUTE_NODE:  		fprintf(stderr, "?attr? ");  		break; 	    case XML_ENTITY_NODE: 		fprintf(stderr, "?ent? "); 		break; 	    case XML_DOCUMENT_NODE: 		fprintf(stderr, "?doc? "); 		break;! 	    case XML_DOCUMENT_TYPE_NODE:   		fprintf(stderr, "?doctype? "); 		break;! 	    case XML_DOCUMENT_FRAG_NODE:  		fprintf(stderr, "?frag? ");  		break; 	    case XML_NOTATION_NODE: 		fprintf(stderr, "?nota? ");  		break;! 	    case XML_HTML_DOCUMENT_NODE:  		fprintf(stderr, "?html? ");  		break; 	    case XML_DTD_NODE:  		fprintf(stderr, "?dtd? "); 		break; 	    case XML_ELEMENT_DECL:  		fprintf(stderr, "?edecl? "); 		break; 	    case XML_ATTRIBUTE_DECL:  		fprintf(stderr, "?adecl? "); 		break; 	    case XML_ENTITY_DECL:  		fprintf(stderr, "?entdecl? "); 		break; 	} 	cur = cur->next;      }  }   ? void xmlValidDebug(xmlNodePtr cur, xmlElementContentPtr cont) {      char expr[1000];       expr[0] = 0;     fprintf(stderr, "valid: ");      xmlValidPrintNodeList(cur);       fprintf(stderr, "against ");,     xmlSprintfElementContent(expr, cont, 0);"     fprintf(stderr, "%s\n", expr); }   2 #define DEBUG_VALID_STATE(n,c) xmlValidDebug(n,c); #else  #define DEBUG_VALID_STATE(n,c) #endif  I /* TODO: use hash table for accesses to elem and attribute dedinitions */    #define VERROR							\;    if ((ctxt != NULL) && (ctxt->error != NULL)) ctxt->error    #define VWARNING						\ ?    if ((ctxt != NULL) && (ctxt->warning != NULL)) ctxt->warning    #define CHECK_DTD						\$    if (doc == NULL) return(0);					\-    else if (doc->intSubset == NULL) return(0)   G xmlElementPtr xmlGetDtdElementDesc(xmlDtdPtr dtd, const xmlChar *name); I xmlAttributePtr xmlScanAttributeDecl(xmlDtdPtr dtd, const xmlChar *elem);   I /************************************************************************   *									*  *			QName handling helper				*   *									*J  ************************************************************************/   /**   * xmlSplitQName2:   * @name:  an XML parser context  * @prefix:  a xmlChar **   *%  * parse an XML qualified name string   *+  * [NS 5] QName ::= (Prefix ':')? LocalPart   *  * [NS 6] Prefix ::= NCName   *  * [NS 7] LocalPart ::= NCName  *D  * Returns NULL if not a QName, otherwise the local part, and prefix)  *   is updated to get the Prefix if any.   */   	 xmlChar * 7 xmlSplitQName2(const xmlChar *name, xmlChar **prefix) {      int len = 0;     xmlChar *ret = NULL;       *prefix = NULL;   /     /* xml: prefix is not really a namespace */ /     if ((name[0] == 'x') && (name[1] == 'm') && -         (name[2] == 'l') && (name[3] == ':'))  	return(NULL);       /* nasty but valid */      if (name[0] == ':')  	return(NULL);       /*E      * we are not trying to validate but just to cut, and yes it will 9      * work even if this is as set of UTF-8 encoded chars       */ 3     while ((name[len] != 0) && (name[len] != ':'))   	len++;           if (name[len] == 0)  	return(NULL);  $     *prefix = xmlStrndup(name, len);$     ret = xmlStrdup(&name[len + 1]);       return(ret); }   A /****************************************************************   *								* 5  *	Util functions for data allocation/deallocation		*   *								* B  ****************************************************************/   /**   * xmlNewElementContent:&  * @name:  the subelement name or NULL+  * @type:  the type of element content decl   *)  * Allocate an element content structure.   *C  * Returns NULL if not, othervise the new element content structure   */  xmlElementContentPtrA xmlNewElementContent(xmlChar *name, xmlElementContentType type) {      xmlElementContentPtr ret;        switch(type) {" 	case XML_ELEMENT_CONTENT_ELEMENT: 	    if (name == NULL) {D 	        fprintf(stderr, "xmlNewElementContent : name == NULL !\n"); 	    } 	    break; (         case XML_ELEMENT_CONTENT_PCDATA: 	case XML_ELEMENT_CONTENT_SEQ: 	case XML_ELEMENT_CONTENT_OR:  	    if (name != NULL) {D 	        fprintf(stderr, "xmlNewElementContent : name != NULL !\n"); 	    } 	    break; 	 	default: F 	    fprintf(stderr, "xmlNewElementContent: unknown type %d\n", type); 	    return(NULL);     } F     ret = (xmlElementContentPtr) xmlMalloc(sizeof(xmlElementContent));     if (ret == NULL) {< 	fprintf(stderr, "xmlNewElementContent : out of memory!\n"); 	return(NULL);     }      ret->type = type; )     ret->ocur = XML_ELEMENT_CONTENT_ONCE;      if (name != NULL) $         ret->name = xmlStrdup(name);     else         ret->name = NULL;      ret->c1 = ret->c2 = NULL;      return(ret); }    /**   * xmlCopyElementContent: )  * @content:  An element content pointer.   *2  * Build a copy of an element content description.  *  A  * Returns the new xmlElementContentPtr or NULL in case of error.   */  xmlElementContentPtr1 xmlCopyElementContent(xmlElementContentPtr cur) {      xmlElementContentPtr ret;   "     if (cur == NULL) return(NULL);A     ret = xmlNewElementContent((xmlChar *) cur->name, cur->type);      if (ret == NULL) {C         fprintf(stderr, "xmlCopyElementContent : out of memory\n");  	return(NULL);     }      ret->ocur = cur->ocur;B     if (cur->c1 != NULL) ret->c1 = xmlCopyElementContent(cur->c1);B     if (cur->c2 != NULL) ret->c2 = xmlCopyElementContent(cur->c2);     return(ret); }    /**   * xmlFreeElementContent: *  * @cur:  the element content tree to free  *@  * Free an element content structure. This is a recursive call !  */  void1 xmlFreeElementContent(xmlElementContentPtr cur) {      if (cur == NULL) return;     switch (cur->type) {! 	case XML_ELEMENT_CONTENT_PCDATA: " 	case XML_ELEMENT_CONTENT_ELEMENT: 	case XML_ELEMENT_CONTENT_SEQ: 	case XML_ELEMENT_CONTENT_OR:  	    break; 	 	default: E 	    fprintf(stderr, "xmlFreeElementContent : type %d\n", cur->type);  	    return;     } 8     if (cur->c1 != NULL) xmlFreeElementContent(cur->c1);8     if (cur->c2 != NULL) xmlFreeElementContent(cur->c2);:     if (cur->name != NULL) xmlFree((xmlChar *) cur->name);/     memset(cur, -1, sizeof(xmlElementContent));      xmlFree(cur);  }    /**   * xmlDumpElementContent:   * @buf:  An XML buffer   * @content:  An element tableD  * @glob: 1 if one must print the englobing parenthesis, 0 otherwise  *K  * This will dump the content of the element table as an XML DTD definition   */  voidQ xmlDumpElementContent(xmlBufferPtr buf, xmlElementContentPtr content, int glob) {       if (content == NULL) return;  +     if (glob) xmlBufferWriteChar(buf, "(");      switch (content->type) {(         case XML_ELEMENT_CONTENT_PCDATA:/             xmlBufferWriteChar(buf, "#PCDATA");  	    break; " 	case XML_ELEMENT_CONTENT_ELEMENT:, 	    xmlBufferWriteCHAR(buf, content->name); 	    break;  	case XML_ELEMENT_CONTENT_SEQ:9 	    if ((content->c1->type == XML_ELEMENT_CONTENT_OR) || 8 	        (content->c1->type == XML_ELEMENT_CONTENT_SEQ))- 		xmlDumpElementContent(buf, content->c1, 1); 	 	    else - 		xmlDumpElementContent(buf, content->c1, 0); +             xmlBufferWriteChar(buf, " , "); 5 	    if (content->c2->type == XML_ELEMENT_CONTENT_OR) - 		xmlDumpElementContent(buf, content->c2, 1); 	 	    else - 		xmlDumpElementContent(buf, content->c2, 0);  	    break;  	case XML_ELEMENT_CONTENT_OR: 9 	    if ((content->c1->type == XML_ELEMENT_CONTENT_OR) || 8 	        (content->c1->type == XML_ELEMENT_CONTENT_SEQ))- 		xmlDumpElementContent(buf, content->c1, 1); 	 	    else - 		xmlDumpElementContent(buf, content->c1, 0); +             xmlBufferWriteChar(buf, " | "); 6 	    if (content->c2->type == XML_ELEMENT_CONTENT_SEQ)- 		xmlDumpElementContent(buf, content->c2, 1); 	 	    else - 		xmlDumpElementContent(buf, content->c2, 0);  	    break; 	 	default: @ 	    fprintf(stderr, "xmlDumpElementContent: unknown type %d\n", 	            content->type);     } 
     if (glob) %         xmlBufferWriteChar(buf, ")");      switch (content->ocur) {&         case XML_ELEMENT_CONTENT_ONCE: 	    break; %         case XML_ELEMENT_CONTENT_OPT: " 	    xmlBufferWriteChar(buf, "?"); 	    break; &         case XML_ELEMENT_CONTENT_MULT:" 	    xmlBufferWriteChar(buf, "*"); 	    break; &         case XML_ELEMENT_CONTENT_PLUS:" 	    xmlBufferWriteChar(buf, "+"); 	    break;      }  }    /**   * xmlSprintfElementContent:  * @buf:  an output buffer  * @content:  An element tableD  * @glob: 1 if one must print the englobing parenthesis, 0 otherwise  *?  * This will dump the content of the element content definition &  * Intended just for the debug routine  */  voidM xmlSprintfElementContent(char *buf, xmlElementContentPtr content, int glob) {       if (content == NULL) return;     if (glob) strcat(buf, "(");      switch (content->type) {(         case XML_ELEMENT_CONTENT_PCDATA:#             strcat(buf, "#PCDATA");  	    break; " 	case XML_ELEMENT_CONTENT_ELEMENT:) 	    strcat(buf, (char *) content->name);  	    break;  	case XML_ELEMENT_CONTENT_SEQ:9 	    if ((content->c1->type == XML_ELEMENT_CONTENT_OR) || 8 	        (content->c1->type == XML_ELEMENT_CONTENT_SEQ))0 		xmlSprintfElementContent(buf, content->c1, 1);	 	    else 0 		xmlSprintfElementContent(buf, content->c1, 0);             strcat(buf, " , "); 5 	    if (content->c2->type == XML_ELEMENT_CONTENT_OR) 0 		xmlSprintfElementContent(buf, content->c2, 1);	 	    else 0 		xmlSprintfElementContent(buf, content->c2, 0); 	    break;  	case XML_ELEMENT_CONTENT_OR: 9 	    if ((content->c1->type == XML_ELEMENT_CONTENT_OR) || 8 	        (content->c1->type == XML_ELEMENT_CONTENT_SEQ))0 		xmlSprintfElementContent(buf, content->c1, 1);	 	    else 0 		xmlSprintfElementContent(buf, content->c1, 0);             strcat(buf, " | "); 6 	    if (content->c2->type == XML_ELEMENT_CONTENT_SEQ)0 		xmlSprintfElementContent(buf, content->c2, 1);	 	    else 0 		xmlSprintfElementContent(buf, content->c2, 0); 	    break;      } 
     if (glob)          strcat(buf, ")");      switch (content->ocur) {&         case XML_ELEMENT_CONTENT_ONCE: 	    break; %         case XML_ELEMENT_CONTENT_OPT:  	    strcat(buf, "?"); 	    break; &         case XML_ELEMENT_CONTENT_MULT: 	    strcat(buf, "*"); 	    break; &         case XML_ELEMENT_CONTENT_PLUS: 	    strcat(buf, "+"); 	    break;      }  }   A /****************************************************************   *								* '  *	Registration of DTD declarations			*   *								* B  ****************************************************************/   /**   * xmlCreateElementTable:   *5  * create and initialize an empty element hash table.   *H  * Returns the xmlElementTablePtr just created or NULL in case of error.  */  xmlElementTablePtr xmlCreateElementTable(void) {      xmlElementTablePtr ret;        ret = (xmlElementTablePtr)  ,          xmlMalloc(sizeof(xmlElementTable));     if (ret == NULL) {J         fprintf(stderr, "xmlCreateElementTable : xmlMalloc(%ld) failed\n",( 	        (long)sizeof(xmlElementTable));         return(NULL);      } .     ret->max_elements = XML_MIN_ELEMENT_TABLE;     ret->nb_elements = 0;      ret->last = 0;#     ret->table = (xmlElementPtr *)  >          xmlMalloc(ret->max_elements * sizeof(xmlElementPtr));     if (ret->table == NULL) { J         fprintf(stderr, "xmlCreateElementTable : xmlMalloc(%ld) failed\n",7 	        ret->max_elements * (long)sizeof(xmlElement));  	xmlFree(ret);         return(NULL);      }      return(ret); }      /**   * xmlAddElementDecl: !  * @ctxt:  the validation context   * @dtd:  pointer to the DTD  * @name:  the entity name  * @type:  the element type .  * @content:  the element content tree or NULL  *%  * Register a new element declaration   *,  * Returns NULL if not, othervise the entity  */ 
 xmlElementPtr K xmlAddElementDecl(xmlValidCtxtPtr ctxt, xmlDtdPtr dtd, const xmlChar *name, )                   xmlElementTypeVal type, # 		  xmlElementContentPtr content) {      xmlElementPtr ret, cur;      xmlElementTablePtr table;      xmlChar *ns, *uqname; 
     int i;       if (dtd == NULL) {<         fprintf(stderr, "xmlAddElementDecl: dtd == NULL\n"); 	return(NULL);     }      if (name == NULL) { =         fprintf(stderr, "xmlAddElementDecl: name == NULL\n");  	return(NULL);     }      switch (type) { $         case XML_ELEMENT_TYPE_EMPTY: 	    if (content != NULL) {  	        fprintf(stderr,< 		        "xmlAddElementDecl: content != NULL for EMPTY\n"); 		return(NULL);  	    } 	    break;  	case XML_ELEMENT_TYPE_ANY:  	    if (content != NULL) {  	        fprintf(stderr,: 		        "xmlAddElementDecl: content != NULL for ANY\n"); 		return(NULL);  	    } 	    break;  	case XML_ELEMENT_TYPE_MIXED:  	    if (content == NULL) {  	        fprintf(stderr,< 		        "xmlAddElementDecl: content == NULL for MIXED\n"); 		return(NULL);  	    } 	    break;  	case XML_ELEMENT_TYPE_ELEMENT:  	    if (content == NULL) {  	        fprintf(stderr,> 		        "xmlAddElementDecl: content == NULL for ELEMENT\n"); 		return(NULL);  	    } 	    break; 	 	default: C 	    fprintf(stderr, "xmlAddElementDecl: unknown type %d\n", type);  	    return(NULL);     }        /*      * check if name is a QName       */ '     uqname = xmlSplitQName2(name, &ns);      if (uqname != NULL)  	name = uqname;        /**      * Create the Element table if needed.      */ /     table = (xmlElementTablePtr) dtd->elements;      if (table == NULL) {(         table = xmlCreateElementTable();  	dtd->elements = (void *) table;     }      if (table == NULL) {@ 	fprintf(stderr, "xmlAddElementDecl: Table creation failed!\n");         return(NULL);      }        /*      * Validity Check:>      * Search the DTD for previous declarations of the ELEMENT      */ ,     for (i = 0;i < table->nb_elements;i++) {         cur = table->table[i];5 	if ((ns != NULL) && (cur->prefix == NULL)) continue; 5 	if ((ns == NULL) && (cur->prefix != NULL)) continue; & 	if ((xmlStrEqual(cur->name, name)) &&8 	    ((ns == NULL) || (xmlStrEqual(cur->prefix, ns)))) { 	    /* 3 	     * The element is already defined in this Dtd.  	     */B 	    VERROR(ctxt->userData, "Redefinition of element %s\n", name); 	    return(NULL); 	}     }        /*!      * Grow the table, if needed.       */ 4     if (table->nb_elements >= table->max_elements) {
         /* 	 * need more elements.  	 */ 	table->max_elements *= 2;" 	table->table = (xmlElementPtr *) K 	    xmlRealloc(table->table, table->max_elements * sizeof(xmlElementPtr));  	if (table->table == NULL) {; 	    fprintf(stderr, "xmlAddElementDecl: out of memory\n");  	    return(NULL); 	}     } 8     ret = (xmlElementPtr) xmlMalloc(sizeof(xmlElement));     if (ret == NULL) {7 	fprintf(stderr, "xmlAddElementDecl: out of memory\n");  	return(NULL);     } '     memset(ret, 0, sizeof(xmlElement)); !     ret->type = XML_ELEMENT_DECL; +     table->table[table->nb_elements] = ret;        /*      * fill the structure.      */      ret->etype = type;      ret->name = xmlStrdup(name);     ret->prefix = ns; 2     ret->content = xmlCopyElementContent(content);6     ret->attributes = xmlScanAttributeDecl(dtd, name);     table->nb_elements++;        /*      * Link it to the Dtd       */      ret->parent = dtd;     ret->doc = dtd->doc;     if (dtd->last == NULL) {. 	dtd->children = dtd->last = (xmlNodePtr) ret;     } else {+         dtd->last->next = (xmlNodePtr) ret;  	ret->prev = dtd->last;  	dtd->last = (xmlNodePtr) ret;     }      if (uqname != NULL)  	xmlFree(uqname);      return(ret); }    /**   * xmlFreeElement:  * @elem:  An element   *6  * Deallocate the memory used by an element definition  */  void$ xmlFreeElement(xmlElementPtr elem) {     if (elem == NULL) return; %     xmlUnlinkNode((xmlNodePtr) elem); )     xmlFreeElementContent(elem->content);      if (elem->name != NULL) ! 	xmlFree((xmlChar *) elem->name);      if (elem->prefix != NULL) # 	xmlFree((xmlChar *) elem->prefix); )     memset(elem, -1, sizeof(xmlElement));      xmlFree(elem); }    /**   * xmlFreeElementTable:   * @table:  An element table  *7  * Deallocate the memory used by an element hash table.   */  void/ xmlFreeElementTable(xmlElementTablePtr table) { 
     int i;       if (table == NULL) return;  ,     for (i = 0;i < table->nb_elements;i++) {(         xmlFreeElement(table->table[i]);     }      xmlFree(table->table);     xmlFree(table);  }    /**   * xmlCopyElementTable:   * @table:  An element table  *$  * Build a copy of an element table.  *  ?  * Returns the new xmlElementTablePtr or NULL in case of error.   */  xmlElementTablePtr/ xmlCopyElementTable(xmlElementTablePtr table) {      xmlElementTablePtr ret;      xmlElementPtr cur, ent; 
     int i;  B     ret = (xmlElementTablePtr) xmlMalloc(sizeof(xmlElementTable));     if (ret == NULL) {B         fprintf(stderr, "xmlCopyElementTable: out of memory !\n"); 	return(NULL);     } B     ret->table = (xmlElementPtr *) xmlMalloc(table->max_elements *@                                          sizeof(xmlElementPtr));     if (ret->table == NULL) { B         fprintf(stderr, "xmlCopyElementTable: out of memory !\n"); 	xmlFree(ret); 	return(NULL);     } ,     ret->max_elements = table->max_elements;*     ret->nb_elements = table->nb_elements;*     for (i = 0;i < ret->nb_elements;i++) {5 	cur = (xmlElementPtr) xmlMalloc(sizeof(xmlElement));  	if (cur == NULL) { ? 	    fprintf(stderr, "xmlCopyElementTable: out of memory !\n");  	    xmlFree(ret); 	    xmlFree(ret->table);  	    return(NULL); 	}$ 	memset(cur, 0, sizeof(xmlElement)); 	cur->type = XML_ELEMENT_DECL; 	ret->table[i] = cur;  	ent = table->table[i];  	cur->etype = ent->etype;  	if (ent->name != NULL) & 	    cur->name = xmlStrdup(ent->name); 	else  	    cur->name = NULL;4 	cur->content = xmlCopyElementContent(ent->content);4 	/* TODO : rebuild the attribute list on the copy */ 	cur->attributes = NULL;     }      return(ret); }    /**   * xmlDumpElementDecl:  * @buf:  the XML buffer output   * @elem:  An element table   *B  * This will dump the content of the element declaration as an XML  * DTD definition   */  void: xmlDumpElementDecl(xmlBufferPtr buf, xmlElementPtr elem) {     switch (elem->etype) { 	case XML_ELEMENT_TYPE_EMPTY: + 	    xmlBufferWriteChar(buf, "<!ELEMENT "); ) 	    xmlBufferWriteCHAR(buf, elem->name); * 	    xmlBufferWriteChar(buf, " EMPTY>\n"); 	    break;  	case XML_ELEMENT_TYPE_ANY: + 	    xmlBufferWriteChar(buf, "<!ELEMENT "); ) 	    xmlBufferWriteCHAR(buf, elem->name); ( 	    xmlBufferWriteChar(buf, " ANY>\n"); 	    break;  	case XML_ELEMENT_TYPE_MIXED: + 	    xmlBufferWriteChar(buf, "<!ELEMENT "); ) 	    xmlBufferWriteCHAR(buf, elem->name); " 	    xmlBufferWriteChar(buf, " ");2 	    xmlDumpElementContent(buf, elem->content, 1);$ 	    xmlBufferWriteChar(buf, ">\n"); 	    break;  	case XML_ELEMENT_TYPE_ELEMENT: + 	    xmlBufferWriteChar(buf, "<!ELEMENT "); ) 	    xmlBufferWriteCHAR(buf, elem->name); " 	    xmlBufferWriteChar(buf, " ");2 	    xmlDumpElementContent(buf, elem->content, 1);$ 	    xmlBufferWriteChar(buf, ">\n"); 	    break; 	 	default:  	    fprintf(stderr,4 		"xmlDumpElementDecl: internal: unknown type %d\n", 		    elem->etype);      }  }    /**   * xmlDumpElementTable:   * @buf:  the XML buffer output   * @table:  An element table  *K  * This will dump the content of the element table as an XML DTD definition   */  voidA xmlDumpElementTable(xmlBufferPtr buf, xmlElementTablePtr table) { 
     int i;     xmlElementPtr cur;       if (table == NULL) return;  ,     for (i = 0;i < table->nb_elements;i++) {         cur = table->table[i]; 	xmlDumpElementDecl(buf, cur);     }  }    /**   * xmlCreateEnumeration:'  * @name:  the enumeration name or NULL   *7  * create and initialize an enumeration attribute node.   *=  * Returns the xmlEnumerationPtr just created or NULL in case   *                of error.   */  xmlEnumerationPtr % xmlCreateEnumeration(xmlChar *name) {      xmlEnumerationPtr ret;  @     ret = (xmlEnumerationPtr) xmlMalloc(sizeof(xmlEnumeration));     if (ret == NULL) {I         fprintf(stderr, "xmlCreateEnumeration : xmlMalloc(%ld) failed\n", ' 	        (long)sizeof(xmlEnumeration));          return(NULL);      } +     memset(ret, 0, sizeof(xmlEnumeration));        if (name != NULL) $         ret->name = xmlStrdup(name);     return(ret); }    /**   * xmlFreeEnumeration:  * @cur:  the tree to free.   *2  * free an enumeration attribute node (recursive).  */  void+ xmlFreeEnumeration(xmlEnumerationPtr cur) {      if (cur == NULL) return;  9     if (cur->next != NULL) xmlFreeEnumeration(cur->next);   :     if (cur->name != NULL) xmlFree((xmlChar *) cur->name);,     memset(cur, -1, sizeof(xmlEnumeration));     xmlFree(cur);  }    /**   * xmlCopyEnumeration:  * @cur:  the tree to copy.   *2  * Copy an enumeration attribute node (recursive).  *=  * Returns the xmlEnumerationPtr just created or NULL in case   *                of error.   */  xmlEnumerationPtr + xmlCopyEnumeration(xmlEnumerationPtr cur) {      xmlEnumerationPtr ret;  "     if (cur == NULL) return(NULL);6     ret = xmlCreateEnumeration((xmlChar *) cur->name);  E     if (cur->next != NULL) ret->next = xmlCopyEnumeration(cur->next);      else ret->next = NULL;       return(ret); }    /**   * xmlDumpEnumeration:  * @buf:  the XML buffer output   * @enum:  An enumeration   *0  * This will dump the content of the enumeration  */  void= xmlDumpEnumeration(xmlBufferPtr buf, xmlEnumerationPtr cur) {      if (cur == NULL)  return;      '     xmlBufferWriteCHAR(buf, cur->name);      if (cur->next == NULL) 	xmlBufferWriteChar(buf, ")");
     else {  	xmlBufferWriteChar(buf, " | ");$ 	xmlDumpEnumeration(buf, cur->next);     }  }    /**   * xmlCreateAttributeTable:   *7  * create and initialize an empty attribute hash table.   *@  * Returns the xmlAttributeTablePtr just created or NULL in case  *                of error.   */  xmlAttributeTablePtr xmlCreateAttributeTable(void) {      xmlAttributeTablePtr ret;   !     ret = (xmlAttributeTablePtr)  .          xmlMalloc(sizeof(xmlAttributeTable));     if (ret == NULL) {L         fprintf(stderr, "xmlCreateAttributeTable : xmlMalloc(%ld) failed\n",* 	        (long)sizeof(xmlAttributeTable));         return(NULL);      } 2     ret->max_attributes = XML_MIN_ATTRIBUTE_TABLE;     ret->nb_attributes = 0; %     ret->table = (xmlAttributePtr *)  B          xmlMalloc(ret->max_attributes * sizeof(xmlAttributePtr));     if (ret->table == NULL) { L         fprintf(stderr, "xmlCreateAttributeTable : xmlMalloc(%ld) failed\n",> 	        ret->max_attributes * (long)sizeof(xmlAttributePtr)); 	xmlFree(ret);         return(NULL);      }      return(ret); }    /**   * xmlScanAttributeDecl:  * @dtd:  pointer to the DTD  * @elem:  the element name   *D  * When inserting a new element scan the DtD for existing attributes6  * for taht element and initialize the Attribute chain  *@  * Returns the pointer to the first attribute decl in the chain,  *         possibly NULL.   */  xmlAttributePtr : xmlScanAttributeDecl(xmlDtdPtr dtd, const xmlChar *elem) {     xmlAttributePtr ret = NULL;      xmlAttributeTablePtr table; 
     int i;       if (dtd == NULL) {?         fprintf(stderr, "xmlScanAttributeDecl: dtd == NULL\n");  	return(NULL);     }      if (elem == NULL) { @         fprintf(stderr, "xmlScanAttributeDecl: elem == NULL\n"); 	return(NULL);     } 3     table = (xmlAttributeTablePtr) dtd->attributes;      if (table == NULL)           return(NULL);   .     for (i = 0;i < table->nb_attributes;i++) {7         if (xmlStrEqual(table->table[i]->elem, elem)) { " 	    table->table[i]->nexth = ret; 	    ret = table->table[i];  	}     }      return(ret); }    /**   * xmlScanIDAttributeDecl:!  * @ctxt:  the validation context   * @elem:  the element name   *<  * Verify that the element don't have too many ID attributes  * declared.  *-  * Returns the number of ID attributes found.   */  int B xmlScanIDAttributeDecl(xmlValidCtxtPtr ctxt, xmlElementPtr elem) {     xmlAttributePtr cur;     int ret = 0;        if (elem == NULL) return(0);     cur = elem->attributes;      while (cur != NULL) { -         if (cur->atype == XML_ATTRIBUTE_ID) {  	    ret ++; 	    if (ret > 1)  		VERROR(ctxt->userData,  > 	       "Element %s has too may ID attributes defined : %s\n",  		       elem->name, cur->name); 	} 	cur = cur->nexth;     }      return(ret); }      /**   * xmlAddAttributeDecl: !  * @ctxt:  the validation context   * @dtd:  pointer to the DTD  * @elem:  the element name   * @name:  the attribute name '  * @ns:  the attribute namespace prefix   * @type:  the attribute type $  * @def:  the attribute default type.  * @defaultValue:  the attribute default value6  * @tree:  if it's an enumeration, the associated list  *'  * Register a new attribute declaration 3  * Note that @tree becomes the ownership of the DTD   *8  * Returns NULL if not new, othervise the attribute decl  */  xmlAttributePtr M xmlAddAttributeDecl(xmlValidCtxtPtr ctxt, xmlDtdPtr dtd, const xmlChar *elem, ;                     const xmlChar *name, const xmlChar *ns, 5 		    xmlAttributeType type, xmlAttributeDefault def, < 		    const xmlChar *defaultValue, xmlEnumerationPtr tree) {     xmlAttributePtr ret, cur;      xmlAttributeTablePtr table;      xmlElementPtr elemDef;
     int i;       if (dtd == NULL) {>         fprintf(stderr, "xmlAddAttributeDecl: dtd == NULL\n"); 	xmlFreeEnumeration(tree); 	return(NULL);     }      if (name == NULL) { ?         fprintf(stderr, "xmlAddAttributeDecl: name == NULL\n");  	xmlFreeEnumeration(tree); 	return(NULL);     }      if (elem == NULL) { ?         fprintf(stderr, "xmlAddAttributeDecl: elem == NULL\n");  	xmlFreeEnumeration(tree); 	return(NULL);     }      /*5      * Check the type and possibly the default value.       */      switch (type) { !         case XML_ATTRIBUTE_CDATA:  	    break;          case XML_ATTRIBUTE_ID: 	    break; !         case XML_ATTRIBUTE_IDREF:  	    break; "         case XML_ATTRIBUTE_IDREFS: 	    break; "         case XML_ATTRIBUTE_ENTITY: 	    break; $         case XML_ATTRIBUTE_ENTITIES: 	    break; #         case XML_ATTRIBUTE_NMTOKEN:  	    break; $         case XML_ATTRIBUTE_NMTOKENS: 	    break; '         case XML_ATTRIBUTE_ENUMERATION:  	    break; $         case XML_ATTRIBUTE_NOTATION: 	    break; 	 	default: E 	    fprintf(stderr, "xmlAddAttributeDecl: unknown type %d\n", type);  	    xmlFreeEnumeration(tree); 	    return(NULL);     } "     if ((defaultValue != NULL) && ;         (!xmlValidateAttributeValue(type, defaultValue))) { F 	VERROR(ctxt->userData, "Attribute %s on %s: invalid default value\n"," 	       elem, name, defaultValue); 	defaultValue = NULL;      }        /*,      * Create the Attribute table if needed.      */ 3     table = (xmlAttributeTablePtr) dtd->attributes;      if (table == NULL) {*         table = xmlCreateAttributeTable();" 	dtd->attributes = (void *) table;     }      if (table == NULL) {B 	fprintf(stderr, "xmlAddAttributeDecl: Table creation failed!\n");         return(NULL);      }        /*      * Validity Check:>      * Search the DTD for previous declarations of the ATTLISTB      * The initial code used to walk the attribute table comparingA      * all pairs of element/attribute names, and was far too slow C      * for large DtDs, we now walk the attribute list associated to D      * the element declaration instead if this declaration is found.      */ .     elemDef = xmlGetDtdElementDesc(dtd, elem);     if (elemDef != NULL) { 	/*  	 * follow the attribute list. 	 */ 	cur = elemDef->attributes;  	while (cur != NULL) {1 	    if ((ns != NULL) && (cur->prefix == NULL)) {  		cur = cur->nexth;  		continue;  	    }1 	    if ((ns == NULL) && (cur->prefix != NULL)) {  		cur = cur->nexth;  		continue;  	    }* 	    if ((xmlStrEqual(cur->name, name)) &&5 		((ns == NULL) || (xmlStrEqual(cur->prefix, ns)))) {  		/*2 		 * The attribute is already defined in this Dtd. 		 */  		VWARNING(ctxt->userData,, 			 "Attribute %s on %s: already defined\n", 		         name, elem);  		xmlFreeEnumeration(tree);  		return(NULL);  	    } 	    cur = cur->nexth; 	}     } else { 	/* " 	 * Walk down the attribute table. 	 */+ 	for (i = 0;i < table->nb_attributes;i++) {  	    cur = table->table[i]; 9 	    if ((ns != NULL) && (cur->prefix == NULL)) continue; 9 	    if ((ns == NULL) && (cur->prefix != NULL)) continue; * 	    if ((xmlStrEqual(cur->name, name)) &&# 		(xmlStrEqual(cur->elem, elem)) && 5 		((ns == NULL) || (xmlStrEqual(cur->prefix, ns)))) {  		/*2 		 * The attribute is already defined in this Dtd. 		 */  		VWARNING(ctxt->userData,, 			 "Attribute %s on %s: already defined\n", 		         elem, name);  		xmlFreeEnumeration(tree);  		return(NULL);  	    } 	}     }        /*!      * Grow the table, if needed.       */ 8     if (table->nb_attributes >= table->max_attributes) {
         /* 	 * need more attributes.  	 */ 	table->max_attributes *= 2;$ 	table->table = (xmlAttributePtr *) 6 	    xmlRealloc(table->table, table->max_attributes * & 	            sizeof(xmlAttributePtr)); 	if (table->table == NULL) {= 	    fprintf(stderr, "xmlAddAttributeDecl: out of memory\n");  	    return(NULL); 	}     } <     ret = (xmlAttributePtr) xmlMalloc(sizeof(xmlAttribute));     if (ret == NULL) {9 	fprintf(stderr, "xmlAddAttributeDecl: out of memory\n");  	return(NULL);     } )     memset(ret, 0, sizeof(xmlAttribute)); #     ret->type = XML_ATTRIBUTE_DECL; -     table->table[table->nb_attributes] = ret;        /*      * fill the structure.      */      ret->atype = type;      ret->name = xmlStrdup(name);      ret->prefix = xmlStrdup(ns);      ret->elem = xmlStrdup(elem);     ret->def = def;      ret->tree = tree;      if (defaultValue != NULL) - 	ret->defaultValue = xmlStrdup(defaultValue);      if (elemDef != NULL) {)         if ((type == XML_ATTRIBUTE_ID) && 2 	    (xmlScanIDAttributeDecl(NULL, elemDef) != 0)) 	    VERROR(ctxt->userData, : 	   "Element %s has too may ID attributes defined : %s\n", 		   elem, name); )         ret->nexth = elemDef->attributes; "         elemDef->attributes = ret;     }      table->nb_attributes++;        /*      * Link it to the Dtd       */      ret->parent = dtd;     ret->doc = dtd->doc;     if (dtd->last == NULL) {. 	dtd->children = dtd->last = (xmlNodePtr) ret;     } else {+         dtd->last->next = (xmlNodePtr) ret;  	ret->prev = dtd->last;  	dtd->last = (xmlNodePtr) ret;     }      return(ret); }    /**   * xmlFreeAttribute:  * @elem:  An attribute   *8  * Deallocate the memory used by an attribute definition  */  void( xmlFreeAttribute(xmlAttributePtr attr) {     if (attr == NULL) return; %     xmlUnlinkNode((xmlNodePtr) attr);      if (attr->tree != NULL) '         xmlFreeEnumeration(attr->tree);      if (attr->elem != NULL) ! 	xmlFree((xmlChar *) attr->elem);      if (attr->name != NULL) ! 	xmlFree((xmlChar *) attr->name); #     if (attr->defaultValue != NULL) ) 	xmlFree((xmlChar *) attr->defaultValue);      if (attr->prefix != NULL) # 	xmlFree((xmlChar *) attr->prefix); +     memset(attr, -1, sizeof(xmlAttribute));      xmlFree(attr); }    /**   * xmlFreeAttributeTable:   * @table:  An attribute table  *8  * Deallocate the memory used by an entities hash table.  */  void3 xmlFreeAttributeTable(xmlAttributeTablePtr table) { 
     int i;       if (table == NULL) return;  .     for (i = 0;i < table->nb_attributes;i++) {*         xmlFreeAttribute(table->table[i]);     }      xmlFree(table->table);     xmlFree(table);  }    /**   * xmlCopyAttributeTable:   * @table:  An attribute table  *&  * Build a copy of an attribute table.  *  A  * Returns the new xmlAttributeTablePtr or NULL in case of error.   */  xmlAttributeTablePtr3 xmlCopyAttributeTable(xmlAttributeTablePtr table) {      xmlAttributeTablePtr ret;      xmlAttributePtr cur, attr;
     int i;  F     ret = (xmlAttributeTablePtr) xmlMalloc(sizeof(xmlAttributeTable));     if (ret == NULL) {D         fprintf(stderr, "xmlCopyAttributeTable: out of memory !\n"); 	return(NULL);     } F     ret->table = (xmlAttributePtr *) xmlMalloc(table->max_attributes *C                                           sizeof(xmlAttributePtr));      if (ret->table == NULL) { D         fprintf(stderr, "xmlCopyAttributeTable: out of memory !\n"); 	xmlFree(ret); 	return(NULL);     } 0     ret->max_attributes = table->max_attributes;.     ret->nb_attributes = table->nb_attributes;,     for (i = 0;i < ret->nb_attributes;i++) { 	attr = table->table[i];9 	cur = (xmlAttributePtr) xmlMalloc(sizeof(xmlAttribute));  	if (cur == NULL) { A 	    fprintf(stderr, "xmlCopyAttributeTable: out of memory !\n");  	    xmlFree(ret); 	    xmlFree(ret->table);  	    return(NULL); 	}& 	memset(cur, 0, sizeof(xmlAttribute));* 	/* !!! cur->type = XML_ATTRIBUTE_DECL; */ 	ret->table[i] = cur;  	cur->atype = attr->atype; 	cur->def = attr->def;, 	cur->tree = xmlCopyEnumeration(attr->tree); 	if (attr->elem != NULL)' 	    cur->elem = xmlStrdup(attr->elem);  	if (attr->name != NULL)' 	    cur->name = xmlStrdup(attr->name);   	if (attr->defaultValue != NULL)7 	    cur->defaultValue = xmlStrdup(attr->defaultValue); , 	/* NEED to rebuild the next chain !!!!!! */     }      return(ret); }    /**   * xmlDumpAttributeDecl:  * @buf:  the XML buffer output #  * @attr:  An attribute declaration   *D  * This will dump the content of the attribute declaration as an XML  * DTD definition   */  void> xmlDumpAttributeDecl(xmlBufferPtr buf, xmlAttributePtr attr) {*     xmlBufferWriteChar(buf, "<!ATTLIST ");(     xmlBufferWriteCHAR(buf, attr->elem);!     xmlBufferWriteChar(buf, " ");      if (attr->prefix != NULL) { ' 	xmlBufferWriteCHAR(buf, attr->prefix);  	xmlBufferWriteChar(buf, ":");     } (     xmlBufferWriteCHAR(buf, attr->name);     switch (attr->atype) { 	case XML_ATTRIBUTE_CDATA:' 	    xmlBufferWriteChar(buf, " CDATA");  	    break;  	case XML_ATTRIBUTE_ID: $ 	    xmlBufferWriteChar(buf, " ID"); 	    break;  	case XML_ATTRIBUTE_IDREF:' 	    xmlBufferWriteChar(buf, " IDREF");  	    break;  	case XML_ATTRIBUTE_IDREFS: ( 	    xmlBufferWriteChar(buf, " IDREFS"); 	    break;  	case XML_ATTRIBUTE_ENTITY: ( 	    xmlBufferWriteChar(buf, " ENTITY"); 	    break;  	case XML_ATTRIBUTE_ENTITIES: * 	    xmlBufferWriteChar(buf, " ENTITIES"); 	    break;  	case XML_ATTRIBUTE_NMTOKEN:) 	    xmlBufferWriteChar(buf, " NMTOKEN");  	    break;  	case XML_ATTRIBUTE_NMTOKENS: * 	    xmlBufferWriteChar(buf, " NMTOKENS"); 	    break;   	case XML_ATTRIBUTE_ENUMERATION:# 	    xmlBufferWriteChar(buf, " ("); ) 	    xmlDumpEnumeration(buf, attr->tree);  	    break;  	case XML_ATTRIBUTE_NOTATION: , 	    xmlBufferWriteChar(buf, " NOTATION (");) 	    xmlDumpEnumeration(buf, attr->tree);  	    break; 	 	default:  	    fprintf(stderr,7 		"xmlDumpAttributeTable: internal: unknown type %d\n",  		    attr->atype);      }      switch (attr->def) { 	case XML_ATTRIBUTE_NONE:  	    break;  	case XML_ATTRIBUTE_REQUIRED: + 	    xmlBufferWriteChar(buf, " #REQUIRED");  	    break;  	case XML_ATTRIBUTE_IMPLIED:* 	    xmlBufferWriteChar(buf, " #IMPLIED"); 	    break;  	case XML_ATTRIBUTE_FIXED:( 	    xmlBufferWriteChar(buf, " #FIXED"); 	    break; 	 	default:  	    fprintf(stderr,: 		"xmlDumpAttributeTable: internal: unknown default %d\n", 		    attr->def);      } %     if (attr->defaultValue != NULL) {  	xmlBufferWriteChar(buf, " ");5 	xmlBufferWriteQuotedString(buf, attr->defaultValue);      } #     xmlBufferWriteChar(buf, ">\n");  }    /**   * xmlDumpAttributeTable:   * @buf:  the XML buffer output   * @table:  An attribute table  *M  * This will dump the content of the attribute table as an XML DTD definition   */  voidE xmlDumpAttributeTable(xmlBufferPtr buf, xmlAttributeTablePtr table) { 
     int i;     xmlAttributePtr cur;       if (table == NULL) return;  .     for (i = 0;i < table->nb_attributes;i++) {         cur = table->table[i];  	xmlDumpAttributeDecl(buf, cur);     }  }   I /************************************************************************   *									*  *				NOTATIONs				*  *									*J  ************************************************************************/ /**   * xmlCreateNotationTable:  *6  * create and initialize an empty notation hash table.  *?  * Returns the xmlNotationTablePtr just created or NULL in case   *                of error.   */  xmlNotationTablePtr  xmlCreateNotationTable(void) {     xmlNotationTablePtr ret;        ret = (xmlNotationTablePtr) -          xmlMalloc(sizeof(xmlNotationTable));      if (ret == NULL) {K         fprintf(stderr, "xmlCreateNotationTable : xmlMalloc(%ld) failed\n", ) 	        (long)sizeof(xmlNotationTable));          return(NULL);      } 0     ret->max_notations = XML_MIN_NOTATION_TABLE;     ret->nb_notations = 0;$     ret->table = (xmlNotationPtr *) @          xmlMalloc(ret->max_notations * sizeof(xmlNotationPtr));     if (ret->table == NULL) { K         fprintf(stderr, "xmlCreateNotationTable : xmlMalloc(%ld) failed\n", 9 	        ret->max_notations * (long)sizeof(xmlNotation));  	xmlFree(ret);         return(NULL);      }      return(ret); }      /**   * xmlAddNotationDecl:  * @dtd:  pointer to the DTD!  * @ctxt:  the validation context   * @name:  the entity name,  * @PublicID:  the public identifier or NULL,  * @SystemID:  the system identifier or NULL  *&  * Register a new notation declaration  *,  * Returns NULL if not, othervise the entity  */  xmlNotationPtrL xmlAddNotationDecl(xmlValidCtxtPtr ctxt, xmlDtdPtr dtd, const xmlChar *name,F                    const xmlChar *PublicID, const xmlChar *SystemID) {     xmlNotationPtr ret, cur;     xmlNotationTablePtr table;
     int i;       if (dtd == NULL) {=         fprintf(stderr, "xmlAddNotationDecl: dtd == NULL\n");  	return(NULL);     }      if (name == NULL) { >         fprintf(stderr, "xmlAddNotationDecl: name == NULL\n"); 	return(NULL);     } 3     if ((PublicID == NULL) && (SystemID == NULL)) { L         fprintf(stderr, "xmlAddNotationDecl: no PUBLIC ID nor SYSTEM ID\n");     }        /*+      * Create the Notation table if needed.       */ 1     table = (xmlNotationTablePtr) dtd->notations;      if (table == NULL)  :         dtd->notations = table = xmlCreateNotationTable();     if (table == NULL) {A 	fprintf(stderr, "xmlAddNotationDecl: Table creation failed!\n");          return(NULL);      }        /*      * Validity Check:>      * Search the DTD for previous declarations of the ATTLIST      */ -     for (i = 0;i < table->nb_notations;i++) {          cur = table->table[i];$ 	if (xmlStrEqual(cur->name, name)) { 	    /* 4 	     * The notation is already defined in this Dtd. 	     */ 	    fprintf(stderr,8 		    "xmlAddNotationDecl: %s already defined\n", name); 	}     }        /*!      * Grow the table, if needed.       */ 6     if (table->nb_notations >= table->max_notations) {
         /* 	 * need more notations. 	 */ 	table->max_notations *= 2; # 	table->table = (xmlNotationPtr *)  4 	    xmlRealloc(table->table, table->max_notations *% 	            sizeof(xmlNotationPtr));  	if (table->table == NULL) {< 	    fprintf(stderr, "xmlAddNotationDecl: out of memory\n"); 	    return(NULL); 	}     } :     ret = (xmlNotationPtr) xmlMalloc(sizeof(xmlNotation));     if (ret == NULL) {8 	fprintf(stderr, "xmlAddNotationDecl: out of memory\n"); 	return(NULL);     } (     memset(ret, 0, sizeof(xmlNotation));,     table->table[table->nb_notations] = ret;       /*      * fill the structure.      */       ret->name = xmlStrdup(name);     if (SystemID != NULL) ,         ret->SystemID = xmlStrdup(SystemID);     if (PublicID != NULL) ,         ret->PublicID = xmlStrdup(PublicID);     table->nb_notations++;       return(ret); }    /**   * xmlFreeNotation:   * @not:  A notation  *7  * Deallocate the memory used by an notation definition   */  void& xmlFreeNotation(xmlNotationPtr nota) {     if (nota == NULL) return;      if (nota->name != NULL) ! 	xmlFree((xmlChar *) nota->name);      if (nota->PublicID != NULL) % 	xmlFree((xmlChar *) nota->PublicID);      if (nota->SystemID != NULL) % 	xmlFree((xmlChar *) nota->SystemID); *     memset(nota, -1, sizeof(xmlNotation));     xmlFree(nota); }    /**   * xmlFreeNotationTable:  * @table:  An notation table   *8  * Deallocate the memory used by an entities hash table.  */  void1 xmlFreeNotationTable(xmlNotationTablePtr table) { 
     int i;       if (table == NULL) return;  -     for (i = 0;i < table->nb_notations;i++) { )         xmlFreeNotation(table->table[i]);      }      xmlFree(table->table);     xmlFree(table);  }    /**   * xmlCopyNotationTable:  * @table:  A notation table  *$  * Build a copy of a notation table.  *  @  * Returns the new xmlNotationTablePtr or NULL in case of error.  */  xmlNotationTablePtr 1 xmlCopyNotationTable(xmlNotationTablePtr table) {      xmlNotationTablePtr ret;     xmlNotationPtr cur, nota; 
     int i;  D     ret = (xmlNotationTablePtr) xmlMalloc(sizeof(xmlNotationTable));     if (ret == NULL) {C         fprintf(stderr, "xmlCopyNotationTable: out of memory !\n");  	return(NULL);     } D     ret->table = (xmlNotationPtr *) xmlMalloc(table->max_notations *A                                          sizeof(xmlNotationPtr));      if (ret->table == NULL) { C         fprintf(stderr, "xmlCopyNotationTable: out of memory !\n");  	xmlFree(ret); 	return(NULL);     } .     ret->max_notations = table->max_notations;,     ret->nb_notations = table->nb_notations;+     for (i = 0;i < ret->nb_notations;i++) { 7 	cur = (xmlNotationPtr) xmlMalloc(sizeof(xmlNotation));  	if (cur == NULL) { @ 	    fprintf(stderr, "xmlCopyNotationTable: out of memory !\n"); 	    xmlFree(ret); 	    xmlFree(ret->table);  	    return(NULL); 	} 	ret->table[i] = cur;  	nota = table->table[i]; 	if (nota->name != NULL)' 	    cur->name = xmlStrdup(nota->name);  	else  	    cur->name = NULL; 	if (nota->PublicID != NULL)/ 	    cur->PublicID = xmlStrdup(nota->PublicID);  	else  	    cur->PublicID = NULL; 	if (nota->SystemID != NULL)/ 	    cur->SystemID = xmlStrdup(nota->SystemID);  	else  	    cur->SystemID = NULL;     }      return(ret); }    /**   * xmlDumpNotationDecl:   * @buf:  the XML buffer output !  * @nota:  A notation declaration   *O  * This will dump the content the notation declaration as an XML DTD definition   */  void< xmlDumpNotationDecl(xmlBufferPtr buf, xmlNotationPtr nota) {+     xmlBufferWriteChar(buf, "<!NOTATION "); (     xmlBufferWriteCHAR(buf, nota->name);!     if (nota->PublicID != NULL) { % 	xmlBufferWriteChar(buf, " PUBLIC "); 1 	xmlBufferWriteQuotedString(buf, nota->PublicID);  	if (nota->SystemID != NULL) {" 	    xmlBufferWriteChar(buf, " ");- 	    xmlBufferWriteCHAR(buf, nota->SystemID);  	}     } else {% 	xmlBufferWriteChar(buf, " SYSTEM "); ) 	xmlBufferWriteCHAR(buf, nota->SystemID);      } $     xmlBufferWriteChar(buf, " >\n"); }    /**   * xmlDumpNotationTable:  * @buf:  the XML buffer output   * @table:  A notation table  *L  * This will dump the content of the notation table as an XML DTD definition  */  voidC xmlDumpNotationTable(xmlBufferPtr buf, xmlNotationTablePtr table) { 
     int i;     xmlNotationPtr cur;        if (table == NULL) return;  -     for (i = 0;i < table->nb_notations;i++) {          cur = table->table[i]; 	xmlDumpNotationDecl(buf, cur);      }  }   I /************************************************************************   *									*  *				IDs					*   *									*J  ************************************************************************/ /**   * xmlCreateIDTable:  *0  * create and initialize an empty id hash table.  *9  * Returns the xmlIDTablePtr just created or NULL in case   *                of error.   */ 
 xmlIDTablePtr  xmlCreateIDTable(void) {     xmlIDTablePtr ret;       ret = (xmlIDTablePtr) '          xmlMalloc(sizeof(xmlIDTable));      if (ret == NULL) {E         fprintf(stderr, "xmlCreateIDTable : xmlMalloc(%ld) failed\n", # 	        (long)sizeof(xmlIDTable));          return(NULL);      } *     ret->max_ids = XML_MIN_NOTATION_TABLE;     ret->nb_ids = 0;     ret->table = (xmlIDPtr *) 4          xmlMalloc(ret->max_ids * sizeof(xmlIDPtr));     if (ret->table == NULL) { E         fprintf(stderr, "xmlCreateIDTable : xmlMalloc(%ld) failed\n", - 	        ret->max_ids * (long)sizeof(xmlID));  	xmlFree(ret);         return(NULL);      }      return(ret); }      /**   * xmlAddID:!  * @ctxt:  the validation context !  * @doc:  pointer to the document   * @value:  the value name'  * @attr:  the attribute holding the ID   *   * Register a new id declaration  *2  * Returns NULL if not, othervise the new xmlIDPtr  */ 	 xmlIDPtr  C xmlAddID(xmlValidCtxtPtr ctxt, xmlDocPtr doc, const xmlChar *value,           xmlAttrPtr attr) {      xmlIDPtr ret, cur;     xmlIDTablePtr table;
     int i;       if (doc == NULL) {7         fprintf(stderr, "xmlAddIDDecl: doc == NULL\n");  	return(NULL);     }      if (value == NULL) {9         fprintf(stderr, "xmlAddIDDecl: value == NULL\n");  	return(NULL);     }      if (attr == NULL) { 8         fprintf(stderr, "xmlAddIDDecl: attr == NULL\n"); 	return(NULL);     }        /*%      * Create the ID table if needed.       */ %     table = (xmlIDTablePtr) doc->ids;      if (table == NULL)  .         doc->ids = table = xmlCreateIDTable();     if (table == NULL) {7 	fprintf(stderr, "xmlAddID: Table creation failed!\n");          return(NULL);      }        /*      * Validity Check:>      * Search the DTD for previous declarations of the ATTLIST      */ '     for (i = 0;i < table->nb_ids;i++) {          cur = table->table[i];& 	if (xmlStrEqual(cur->value, value)) { 	    /* . 	     * The id is already defined in this Dtd. 	     */> 	    VERROR(ctxt->userData, "ID %s already defined\n", value); 	    return(NULL); 	}     }        /*!      * Grow the table, if needed.       */ *     if (table->nb_ids >= table->max_ids) {
         /* 	 * need more ids. 	 */ 	table->max_ids *= 2;  	table->table = (xmlIDPtr *)  . 	    xmlRealloc(table->table, table->max_ids * 	            sizeof(xmlIDPtr));  	if (table->table == NULL) {2 	    fprintf(stderr, "xmlAddID: out of memory\n"); 	    return(NULL); 	}     } .     ret = (xmlIDPtr) xmlMalloc(sizeof(xmlID));     if (ret == NULL) {. 	fprintf(stderr, "xmlAddID: out of memory\n"); 	return(NULL);     } &     table->table[table->nb_ids] = ret;       /*      * fill the structure.      */ "     ret->value = xmlStrdup(value);     ret->attr = attr;      table->nb_ids++;       return(ret); }    /** 
  * xmlFreeID:   * @not:  A id  *1  * Deallocate the memory used by an id definition   */  void xmlFreeID(xmlIDPtr id) {     if (id == NULL) return;      if (id->value != NULL)  	xmlFree((xmlChar *) id->value);"     memset(id, -1, sizeof(xmlID));     xmlFree(id); }    /**   * xmlFreeIDTable:  * @table:  An id table   *2  * Deallocate the memory used by an ID hash table.  */  void% xmlFreeIDTable(xmlIDTablePtr table) { 
     int i;       if (table == NULL) return;  '     for (i = 0;i < table->nb_ids;i++) { #         xmlFreeID(table->table[i]);      }      xmlFree(table->table);     xmlFree(table);  }    /**   * xmlIsID:   * @doc:  the document-  * @elem:  the element carrying the attribute   * @attr:  the attribute  *G  * Determine whether an attribute is of type ID. In case we have Dtd(s) E  * then this is simple, otherwise we use an heuristic: name ID (upper   * or lowercase).   *0  * Returns 0 or 1 depending on the lookup result  */  int : xmlIsID(xmlDocPtr doc, xmlNodePtr elem, xmlAttrPtr attr) {     if (doc == NULL) return(0);       if (attr == NULL) return(0);?     if ((doc->intSubset == NULL) && (doc->extSubset == NULL)) { A         if (((attr->name[0] == 'I') || (attr->name[0] == 'i')) && A             ((attr->name[1] == 'D') || (attr->name[1] == 'd')) && % 	    (attr->name[2] == 0)) return(1); 5     } else if (doc->type == XML_HTML_DOCUMENT_NODE) { 7         if ((xmlStrEqual(BAD_CAST "id", attr->name)) || 0 	    (xmlStrEqual(BAD_CAST "name", attr->name))) 	    return(1);  	return(0);          } else { 	xmlAttributePtr attrDecl;   	if (elem == NULL) return(0); F 	attrDecl = xmlGetDtdAttrDesc(doc->intSubset, elem->name, attr->name);4 	if ((attrDecl == NULL) && (doc->extSubset != NULL))= 	    attrDecl = xmlGetDtdAttrDesc(doc->extSubset, elem->name, . 	                                 attr->name);  H         if ((attrDecl != NULL) && (attrDecl->atype == XML_ATTRIBUTE_ID)) 	    return(1);      }      return(0); }    /**   * xmlRemoveID  * @doc:  the document  * @attr:  the attribute  *F  * Remove the given attribute from the ID table maintained internally.  *2  * Returns -1 if the lookup failed and 0 otherwise  */  int - xmlRemoveID(xmlDocPtr doc, xmlAttrPtr attr) {      xmlIDPtr cur;      xmlIDTablePtr table;
     int i;        if (doc == NULL) return(-1);!     if (attr == NULL) return(-1); %     table = (xmlIDTablePtr) doc->ids;      if (table == NULL)           return(-1);        /*      * Search the ID list.      */ '     for (i = 0;i < table->nb_ids;i++) {          cur = table->table[i]; 	if (cur->attr == attr) {  	    table->nb_ids--; 2 	    memmove(&table->table[i], &table->table[i+1],5 	            (table->nb_ids - i) * sizeof(xmlIDPtr));  	    return(0);  	}     }      return(-1);  }    /**   * xmlGetID:!  * @doc:  pointer to the document   * @ID:  the ID value   *.  * Search the attribute declaring the given ID  *F  * Returns NULL if not found, otherwise the xmlAttrPtr defining the ID  */  xmlAttrPtr  , xmlGetID(xmlDocPtr doc, const xmlChar *ID) {     xmlIDPtr cur;      xmlIDTablePtr table;
     int i;       if (doc == NULL) {3         fprintf(stderr, "xmlGetID: doc == NULL\n");  	return(NULL);     }        if (ID == NULL) { 2         fprintf(stderr, "xmlGetID: ID == NULL\n"); 	return(NULL);     }   %     table = (xmlIDTablePtr) doc->ids;      if (table == NULL)           return(NULL);        /*      * Search the ID list.      */ '     for (i = 0;i < table->nb_ids;i++) {          cur = table->table[i];# 	if (xmlStrEqual(cur->value, ID)) {  	    return(cur->attr);  	}     }      return(NULL);  }   I /************************************************************************   *									*  *				Refs					*  *									*J  ************************************************************************/ /**   * xmlCreateRefTable:   *1  * create and initialize an empty ref hash table.   *:  * Returns the xmlRefTablePtr just created or NULL in case  *                of error.   */  xmlRefTablePtr xmlCreateRefTable(void) {      xmlRefTablePtr ret;        ret = (xmlRefTablePtr)  (          xmlMalloc(sizeof(xmlRefTable));     if (ret == NULL) {F         fprintf(stderr, "xmlCreateRefTable : xmlMalloc(%ld) failed\n",$ 	        (long)sizeof(xmlRefTable));         return(NULL);      } +     ret->max_refs = XML_MIN_NOTATION_TABLE;      ret->nb_refs = 0;      ret->table = (xmlRefPtr *)  6          xmlMalloc(ret->max_refs * sizeof(xmlRefPtr));     if (ret->table == NULL) { F         fprintf(stderr, "xmlCreateRefTable : xmlMalloc(%ld) failed\n",/ 	        ret->max_refs * (long)sizeof(xmlRef));  	xmlFree(ret);         return(NULL);      }      return(ret); }      /** 
  * xmlAddRef: !  * @ctxt:  the validation context !  * @doc:  pointer to the document   * @value:  the value name(  * @attr:  the attribute holding the Ref  *!  * Register a new ref declaration   *3  * Returns NULL if not, othervise the new xmlRefPtr   */ 
 xmlRefPtr D xmlAddRef(xmlValidCtxtPtr ctxt, xmlDocPtr doc, const xmlChar *value,          xmlAttrPtr attr) {      xmlRefPtr ret;     xmlRefTablePtr table;        if (doc == NULL) {8         fprintf(stderr, "xmlAddRefDecl: doc == NULL\n"); 	return(NULL);     }      if (value == NULL) {:         fprintf(stderr, "xmlAddRefDecl: value == NULL\n"); 	return(NULL);     }      if (attr == NULL) { 9         fprintf(stderr, "xmlAddRefDecl: attr == NULL\n");  	return(NULL);     }        /*&      * Create the Ref table if needed.      */ '     table = (xmlRefTablePtr) doc->refs;      if (table == NULL)  0         doc->refs = table = xmlCreateRefTable();     if (table == NULL) {8 	fprintf(stderr, "xmlAddRef: Table creation failed!\n");         return(NULL);      }        /*!      * Grow the table, if needed.       */ ,     if (table->nb_refs >= table->max_refs) {
         /* 	 * need more refs.  	 */ 	table->max_refs *= 2; 	table->table = (xmlRefPtr *) / 	    xmlRealloc(table->table, table->max_refs *   	            sizeof(xmlRefPtr)); 	if (table->table == NULL) {3 	    fprintf(stderr, "xmlAddRef: out of memory\n");  	    return(NULL); 	}     } 0     ret = (xmlRefPtr) xmlMalloc(sizeof(xmlRef));     if (ret == NULL) {/ 	fprintf(stderr, "xmlAddRef: out of memory\n");  	return(NULL);     } '     table->table[table->nb_refs] = ret;        /*      * fill the structure.      */ "     ret->value = xmlStrdup(value);     ret->attr = attr;      table->nb_refs++;        return(ret); }    /**   * xmlFreeRef:  * @not:  A ref   *2  * Deallocate the memory used by an ref definition  */  void xmlFreeRef(xmlRefPtr ref) {      if (ref == NULL) return;     if (ref->value != NULL) ! 	xmlFree((xmlChar *) ref->value); $     memset(ref, -1, sizeof(xmlRef));     xmlFree(ref);  }    /**   * xmlFreeRefTable:   * @table:  An ref table  *3  * Deallocate the memory used by an Ref hash table.   */  void' xmlFreeRefTable(xmlRefTablePtr table) { 
     int i;       if (table == NULL) return;  (     for (i = 0;i < table->nb_refs;i++) {$         xmlFreeRef(table->table[i]);     }      xmlFree(table->table);     xmlFree(table);  }    /**   * xmlIsRef:  * @doc:  the document-  * @elem:  the element carrying the attribute   * @attr:  the attribute  *H  * Determine whether an attribute is of type Ref. In case we have Dtd(s)F  * then this is simple, otherwise we use an heuristic: name Ref (upper  * or lowercase).   *0  * Returns 0 or 1 depending on the lookup result  */  int ; xmlIsRef(xmlDocPtr doc, xmlNodePtr elem, xmlAttrPtr attr) { ?     if ((doc->intSubset == NULL) && (doc->extSubset == NULL)) {          return(0); 	/******************* A         if (((attr->name[0] == 'I') || (attr->name[0] == 'i')) && A             ((attr->name[1] == 'D') || (attr->name[1] == 'd')) && % 	    (attr->name[2] == 0)) return(1);  	 *******************/5     } else if (doc->type == XML_HTML_DOCUMENT_NODE) {  	/* TODO @@@ */  	return(0);          } else { 	xmlAttributePtr attrDecl;  F 	attrDecl = xmlGetDtdAttrDesc(doc->intSubset, elem->name, attr->name);4 	if ((attrDecl == NULL) && (doc->extSubset != NULL))= 	    attrDecl = xmlGetDtdAttrDesc(doc->extSubset, elem->name, . 	                                 attr->name);  K         if ((attrDecl != NULL) && (attrDecl->atype == XML_ATTRIBUTE_IDREF))  	    return(1);      }      return(0); }    /**   * xmlRemoveRef   * @doc:  the document  * @attr:  the attribute  *G  * Remove the given attribute from the Ref table maintained internally.   *2  * Returns -1 if the lookup failed and 0 otherwise  */  int . xmlRemoveRef(xmlDocPtr doc, xmlAttrPtr attr) {     xmlRefPtr cur;     xmlRefTablePtr table; 
     int i;        if (doc == NULL) return(-1);!     if (attr == NULL) return(-1); '     table = (xmlRefTablePtr) doc->refs;      if (table == NULL)           return(-1);        /*      * Search the Ref list.       */ (     for (i = 0;i < table->nb_refs;i++) {         cur = table->table[i]; 	if (cur->attr == attr) {  	    table->nb_refs--;2 	    memmove(&table->table[i], &table->table[i+1],7 	            (table->nb_refs - i) * sizeof(xmlRefPtr));  	    return(0);  	}     }      return(-1);  }    /** 
  * xmlGetRef: !  * @doc:  pointer to the document   * @Ref:  the Ref value   *4  * Search the next attribute declaring the given Ref  *G  * Returns NULL if not found, otherwise the xmlAttrPtr defining the Ref   */  xmlAttrPtr  . xmlGetRef(xmlDocPtr doc, const xmlChar *Ref) {     xmlRefPtr cur;     xmlRefTablePtr table; 
     int i;       if (doc == NULL) {4         fprintf(stderr, "xmlGetRef: doc == NULL\n"); 	return(NULL);     }        if (Ref == NULL) {4         fprintf(stderr, "xmlGetRef: Ref == NULL\n"); 	return(NULL);     }   '     table = (xmlRefTablePtr) doc->refs;      if (table == NULL)           return(NULL);        /*      * Search the Ref list.       */ (     for (i = 0;i < table->nb_refs;i++) {         cur = table->table[i];$ 	if (xmlStrEqual(cur->value, Ref)) { 	    return(cur->attr);  	}     }      return(NULL);  }   I /************************************************************************   *									*'  *		Routines for validity checking				*   *									*J  ************************************************************************/   /**   * xmlGetDtdElementDesc:(  * @dtd:  a pointer to the DtD to search  * @name:  the element name   *5  * Search the Dtd for the description of this element   *-  * returns the xmlElementPtr if found or NULL   */   
 xmlElementPtr : xmlGetDtdElementDesc(xmlDtdPtr dtd, const xmlChar *name) {     xmlElementTablePtr table;      xmlElementPtr cur;+     xmlChar *uqname = NULL, *prefix = NULL; 
     int i;  "     if (dtd == NULL) return(NULL);,     if (dtd->elements == NULL) return(NULL);/     table = (xmlElementTablePtr) dtd->elements;   C     if ((table->last >= 0) && (table->last < table->nb_elements)) { ! 	cur = table->table[table->last]; " 	if (xmlStrEqual(cur->name, name)) 	    return(cur);      } ,     for (i = 0;i < table->nb_elements;i++) {         cur = table->table[i];$ 	if (xmlStrEqual(cur->name, name)) { 	    table->last = i;  	    return(cur);  	}     }        /*(      * Specific case if name is a QName.      */ +     uqname = xmlSplitQName2(name, &prefix); %     if (uqname == NULL) return(NULL);   ,     for (i = 0;i < table->nb_elements;i++) {         cur = table->table[i];( 	if ((xmlStrEqual(cur->name, uqname)) &&  	    ((prefix == cur->prefix) ||3 	     ((prefix != NULL) && (cur->prefix != NULL) && . 	      (xmlStrEqual(cur->prefix, prefix))))) {) 	    if (prefix != NULL) xmlFree(prefix); ) 	    if (uqname != NULL) xmlFree(uqname);  	    return(cur);  	}     } (     if (prefix != NULL) xmlFree(prefix);(     if (uqname != NULL) xmlFree(uqname);     return(NULL);  }    /**   * xmlGetDtdQElementDesc: (  * @dtd:  a pointer to the DtD to search  * @name:  the element name )  * @prefix:  the element namespace prefix   *5  * Search the Dtd for the description of this element   *-  * returns the xmlElementPtr if found or NULL   */   
 xmlElementPtr 9 xmlGetDtdQElementDesc(xmlDtdPtr dtd, const xmlChar *name, ' 	              const xmlChar *prefix) {      xmlElementTablePtr table;      xmlElementPtr cur;
     int i;  "     if (dtd == NULL) return(NULL);,     if (dtd->elements == NULL) return(NULL);/     table = (xmlElementTablePtr) dtd->elements;   ,     for (i = 0;i < table->nb_elements;i++) {         cur = table->table[i];$ 	if (xmlStrEqual(cur->name, name) &&  	    ((prefix == cur->prefix) ||3 	     ((prefix != NULL) && (cur->prefix != NULL) && , 	      (xmlStrEqual(cur->prefix, prefix))))) 	    return(cur);      }      return(NULL);  }    /**   * xmlGetDtdAttrDesc: (  * @dtd:  a pointer to the DtD to search  * @elem:  the element name   * @name:  the attribute name   *:  * Search the Dtd for the description of this attribute on  * this element.  */  * returns the xmlAttributePtr if found or NULL   */    xmlAttributePtr L xmlGetDtdAttrDesc(xmlDtdPtr dtd, const xmlChar *elem, const xmlChar *name) {     xmlAttributeTablePtr table;      xmlElementTablePtr etable;     xmlAttributePtr cur;     xmlElementPtr ecur; +     xmlChar *uqname = NULL, *prefix = NULL; 
     int i;  "     if (dtd == NULL) return(NULL);.     if (dtd->attributes == NULL) return(NULL);       /*.      * Faster lookup through the element table      */ 0     etable = (xmlElementTablePtr) dtd->elements;     if (etable != NULL) { * 	for (i = 0;i < etable->nb_elements;i++) { 	    ecur = etable->table[i]; ) 	    if (xmlStrEqual(ecur->name, elem)) {  		cur = ecur->attributes;  		while (cur != NULL) { ' 		    if (xmlStrEqual(cur->name, name))  			return(cur); %                     cur = cur->nexth;  		} - 		/* TODO: same accelerator for QNames !!! */  		break; 	    } 	}     }      /*<      * Miss on the element table, retry on the attribute one      */   3     table = (xmlAttributeTablePtr) dtd->attributes;      if (table == NULL) 	return(NULL);.     for (i = 0;i < table->nb_attributes;i++) {         cur = table->table[i];& 	if ((xmlStrEqual(cur->name, name)) &&$ 	    (xmlStrEqual(cur->elem, elem))) 	    return(cur);      }        /*(      * Specific case if name is a QName.      */ +     uqname = xmlSplitQName2(name, &prefix); %     if (uqname == NULL) return(NULL);   .     for (i = 0;i < table->nb_attributes;i++) {         cur = table->table[i];( 	if ((xmlStrEqual(cur->name, uqname)) &&& 	    (xmlStrEqual(cur->elem, elem)) &&  	    ((prefix == cur->prefix) ||3 	     ((prefix != NULL) && (cur->prefix != NULL) && . 	      (xmlStrEqual(cur->prefix, prefix))))) {) 	    if (prefix != NULL) xmlFree(prefix); ) 	    if (uqname != NULL) xmlFree(uqname);  	    return(cur);  	}     } (     if (prefix != NULL) xmlFree(prefix);(     if (uqname != NULL) xmlFree(uqname);     return(NULL);  }    /**   * xmlGetDtdQAttrDesc:(  * @dtd:  a pointer to the DtD to search  * @elem:  the element name   * @name:  the attribute name +  * @prefix:  the attribute namespace prefix   *D  * Search the Dtd for the description of this qualified attribute on  * this element.  */  * returns the xmlAttributePtr if found or NULL   */    xmlAttributePtr K xmlGetDtdQAttrDesc(xmlDtdPtr dtd, const xmlChar *elem, const xmlChar *name, # 	          const xmlChar *prefix) {      xmlAttributeTablePtr table;      xmlAttributePtr cur;
     int i;  "     if (dtd == NULL) return(NULL);.     if (dtd->attributes == NULL) return(NULL);3     table = (xmlAttributeTablePtr) dtd->attributes;   .     for (i = 0;i < table->nb_attributes;i++) {         cur = table->table[i];& 	if ((xmlStrEqual(cur->name, name)) &&& 	    (xmlStrEqual(cur->elem, elem)) &&  	    ((prefix == cur->prefix) ||3 	     ((prefix != NULL) && (cur->prefix != NULL) && , 	      (xmlStrEqual(cur->prefix, prefix))))) 	    return(cur);      }      return(NULL);  }    /**   * xmlGetDtdNotationDesc: (  * @dtd:  a pointer to the DtD to search  * @name:  the notation name  *6  * Search the Dtd for the description of this notation  *.  * returns the xmlNotationPtr if found or NULL  */    xmlNotationPtr; xmlGetDtdNotationDesc(xmlDtdPtr dtd, const xmlChar *name) {      xmlNotationTablePtr table;     xmlNotationPtr cur; 
     int i;  "     if (dtd == NULL) return(NULL);-     if (dtd->notations == NULL) return(NULL); 1     table = (xmlNotationTablePtr) dtd->notations;   -     for (i = 0;i < table->nb_notations;i++) {          cur = table->table[i];" 	if (xmlStrEqual(cur->name, name)) 	    return(cur);      }      return(NULL);  }    /**   * xmlValidateNotationUse:!  * @ctxt:  the validation context   * @doc:  the document-  * @notationName:  the notation name to check   *=  * Validate that the given mame match a notation declaration.   * - [ VC: Notation Declared ]  *$  * returns 1 if valid or 0 otherwise  */    int ; xmlValidateNotationUse(xmlValidCtxtPtr ctxt, xmlDocPtr doc, 5                        const xmlChar *notationName) {      xmlNotationPtr notaDecl;>     if ((doc == NULL) || (doc->intSubset == NULL)) return(-1);  C     notaDecl = xmlGetDtdNotationDesc(doc->intSubset, notationName); 7     if ((notaDecl == NULL) && (doc->extSubset != NULL)) @ 	notaDecl = xmlGetDtdNotationDesc(doc->extSubset, notationName);       if (notaDecl == NULL) { 8 	VERROR(ctxt->userData, "NOTATION %s is not declared\n", 	       notationName); 	return(0);      }      return(1); }    /**   * xmlIsMixedElement  * @doc:  the document  * @name:  the element name   *F  * Search in the DtDs whether an element accept Mixed content (or ANY)4  * basically if it is supposed to accept text childs  *K  * returns 0 if no, 1 if yes, and -1 if no element description is available   */    int 7 xmlIsMixedElement(xmlDocPtr doc, const xmlChar *name) {      xmlElementPtr elemDecl;   >     if ((doc == NULL) || (doc->intSubset == NULL)) return(-1);  :     elemDecl = xmlGetDtdElementDesc(doc->intSubset, name);7     if ((elemDecl == NULL) && (doc->extSubset != NULL)) 7 	elemDecl = xmlGetDtdElementDesc(doc->extSubset, name); %     if (elemDecl == NULL) return(-1);      switch (elemDecl->etype) { 	case XML_ELEMENT_TYPE_ELEMENT:  	    return(0); $         case XML_ELEMENT_TYPE_EMPTY: 	    /* ; 	     * return 1 for EMPTY since we want VC error to pop up + 	     * on <empty>     </empty> for example  	     */ 	case XML_ELEMENT_TYPE_ANY:  	case XML_ELEMENT_TYPE_MIXED:  	    return(1);      }      return(1); }    /**   * xmlValidateNameValue:  * @value:  an Name value   *6  * Validate that the given value match Name production  *$  * returns 1 if valid or 0 otherwise  */    int , xmlValidateNameValue(const xmlChar *value) {     const xmlChar *cur;   !     if (value == NULL) return(0);      cur = value;     ,     if (!IS_LETTER(*cur) && (*cur != '_') &&         (*cur != ':')) { 	return(0);      }   3     while ((IS_LETTER(*cur)) || (IS_DIGIT(*cur)) || ,            (*cur == '.') || (*cur == '-') ||& 	   (*cur == '_') || (*cur == ':') ||  	   (IS_COMBINING(*cur)) ||  	   (IS_EXTENDER(*cur)))
 	   cur++;       if (*cur != 0) return(0);        return(1); }    /**   * xmlValidateNamesValue:   * @value:  an Names value  *7  * Validate that the given value match Names production   *$  * returns 1 if valid or 0 otherwise  */    int - xmlValidateNamesValue(const xmlChar *value) {      const xmlChar *cur;   !     if (value == NULL) return(0);      cur = value;     ,     if (!IS_LETTER(*cur) && (*cur != '_') &&         (*cur != ':')) { 	return(0);      }   3     while ((IS_LETTER(*cur)) || (IS_DIGIT(*cur)) || ,            (*cur == '.') || (*cur == '-') ||& 	   (*cur == '_') || (*cur == ':') ||  	   (IS_COMBINING(*cur)) ||  	   (IS_EXTENDER(*cur)))
 	   cur++;       while (IS_BLANK(*cur)) { 	while (IS_BLANK(*cur)) cur++;  ) 	if (!IS_LETTER(*cur) && (*cur != '_') &&  	    (*cur != ':')) {  	    return(0);  	}  0 	while ((IS_LETTER(*cur)) || (IS_DIGIT(*cur)) ||) 	       (*cur == '.') || (*cur == '-') || * 	       (*cur == '_') || (*cur == ':') ||  	       (IS_COMBINING(*cur)) ||  	       (IS_EXTENDER(*cur))) 	       cur++;     }        if (*cur != 0) return(0);        return(1); }    /**   * xmlValidateNmtokenValue:   * @value:  an Mntoken value  *9  * Validate that the given value match Nmtoken production   *  * [ VC: Name Token ]   *  $  * returns 1 if valid or 0 otherwise  */    int / xmlValidateNmtokenValue(const xmlChar *value) {      const xmlChar *cur;   !     if (value == NULL) return(0);      cur = value;     .     if (!IS_LETTER(*cur) && !IS_DIGIT(*cur) &&)         (*cur != '.') && (*cur != '-') && *         (*cur != '_') && (*cur != ':') &&           (!IS_COMBINING(*cur)) &&         (!IS_EXTENDER(*cur)))  	return(0);   3     while ((IS_LETTER(*cur)) || (IS_DIGIT(*cur)) || ,            (*cur == '.') || (*cur == '-') ||& 	   (*cur == '_') || (*cur == ':') ||  	   (IS_COMBINING(*cur)) ||  	   (IS_EXTENDER(*cur)))
 	   cur++;       if (*cur != 0) return(0);        return(1); }    /**   * xmlValidateNmtokensValue:  * @value:  an Mntokens value   *:  * Validate that the given value match Nmtokens production  *  * [ VC: Name Token ]   *  $  * returns 1 if valid or 0 otherwise  */    int 0 xmlValidateNmtokensValue(const xmlChar *value) {     const xmlChar *cur;   !     if (value == NULL) return(0);      cur = value;     !     while (IS_BLANK(*cur)) cur++; .     if (!IS_LETTER(*cur) && !IS_DIGIT(*cur) &&)         (*cur != '.') && (*cur != '-') && *         (*cur != '_') && (*cur != ':') &&           (!IS_COMBINING(*cur)) &&         (!IS_EXTENDER(*cur)))  	return(0);   3     while ((IS_LETTER(*cur)) || (IS_DIGIT(*cur)) || ,            (*cur == '.') || (*cur == '-') ||& 	   (*cur == '_') || (*cur == ':') ||  	   (IS_COMBINING(*cur)) ||  	   (IS_EXTENDER(*cur)))
 	   cur++;       while (IS_BLANK(*cur)) { 	while (IS_BLANK(*cur)) cur++; 	if (*cur == 0) return(1);  + 	if (!IS_LETTER(*cur) && !IS_DIGIT(*cur) && & 	    (*cur != '.') && (*cur != '-') &&' 	    (*cur != '_') && (*cur != ':') &&   	    (!IS_COMBINING(*cur)) &&  	    (!IS_EXTENDER(*cur))) 	    return(0);   0 	while ((IS_LETTER(*cur)) || (IS_DIGIT(*cur)) ||) 	       (*cur == '.') || (*cur == '-') || * 	       (*cur == '_') || (*cur == ':') ||  	       (IS_COMBINING(*cur)) ||  	       (IS_EXTENDER(*cur))) 	       cur++;     }        if (*cur != 0) return(0);        return(1); }    /**   * xmlValidateNotationDecl: !  * @ctxt:  the validation context   * @doc:  a document instance    * @nota:  a notation definition  */  * Try to validate a single notation definition =  * basically it does the following checks as described by the   * XML-1.0 recommendation:I  *  - it seems that no validity constraing exist on notation declarations *  * But this function get called anyway ...  *$  * returns 1 if valid or 0 otherwise  */    int < xmlValidateNotationDecl(xmlValidCtxtPtr ctxt, xmlDocPtr doc,/                          xmlNotationPtr nota) {      int ret = 1;       return(ret); }    /**   * xmlValidateAttributeValue:   * @type:  an attribute type  * @value:  an attribute value  *G  * Validate that the given attribute value match  the proper production   *
  * [ VC: ID ] 7  * Values of type ID must match the Name production....   *  * [ VC: IDREF ]B  * Values of type IDREF must match the Name production, and values&  * of type IDREFS must match Names ...  *  * [ VC: Entity Name ]?  * Values of type ENTITY must match the Name production, values (  * of type ENTITIES must match Names ...  *  * [ VC: Name Token ] C  * Values of type NMTOKEN must match the Nmtoken production; values )  * of type NMTOKENS must match Nmtokens.    *$  * returns 1 if valid or 0 otherwise  */    int H xmlValidateAttributeValue(xmlAttributeType type, const xmlChar *value) {     switch (type) {  	case XML_ATTRIBUTE_ENTITIES:  	case XML_ATTRIBUTE_IDREFS: * 	    return(xmlValidateNamesValue(value)); 	case XML_ATTRIBUTE_ENTITY:  	case XML_ATTRIBUTE_IDREF: 	case XML_ATTRIBUTE_ID:  	case XML_ATTRIBUTE_NOTATION: ) 	    return(xmlValidateNameValue(value));  	case XML_ATTRIBUTE_NMTOKENS:   	case XML_ATTRIBUTE_ENUMERATION:- 	    return(xmlValidateNmtokensValue(value));  	case XML_ATTRIBUTE_NMTOKEN:, 	    return(xmlValidateNmtokenValue(value));!         case XML_ATTRIBUTE_CDATA:  	    break;      }      return(1); }    /**   * xmlValidateAttributeValue2:!  * @ctxt:  the validation context   * @doc:  the document=  * @name:  the attribute name (used for error reporting only)   * @type:  the attribute type   * @value:  the attribute value   *>  * Validate that the given attribute value match a given type.?  * This typically cannot be done before having finished parsing   * the subsets.   *  * [ VC: IDREF ]:  * Values of type IDREF must match one of the declared IDsB  * Values of type IDREFS must match a sequence of the declared IDsD  * each Name must match the value of an ID attribute on some elementA  * in the XML document; i.e. IDREF values must match the value of   * some ID attribute  *  * [ VC: Entity Name ]7  * Values of type ENTITY must match one declared entity E  * Values of type ENTITIES must match a sequence of declared entities   *  * [ VC: Notation Attributes ]:  * all notation names in the declaration must be declared.  *$  * returns 1 if valid or 0 otherwise  */    int ? xmlValidateAttributeValue2(xmlValidCtxtPtr ctxt, xmlDocPtr doc, I       const xmlChar *name, xmlAttributeType type, const xmlChar *value) {      int ret = 1;     switch (type) {  	case XML_ATTRIBUTE_IDREFS:  	case XML_ATTRIBUTE_IDREF: 	case XML_ATTRIBUTE_ID:  	case XML_ATTRIBUTE_NMTOKENS:   	case XML_ATTRIBUTE_ENUMERATION: 	case XML_ATTRIBUTE_NMTOKEN:!         case XML_ATTRIBUTE_CDATA:  	    break;  	case XML_ATTRIBUTE_ENTITY: {  	    xmlEntityPtr ent;  ' 	    ent = xmlGetDocEntity(doc, value);  	    if (ent == NULL) {  		VERROR(ctxt->userData,  >    "ENTITY attribute %s reference an unknown entity \"%s\"\n", 		       name, value);
 		ret = 0;E 	    } else if (ent->etype != XML_EXTERNAL_GENERAL_UNPARSED_ENTITY) {  		VERROR(ctxt->userData,  D    "ENTITY attribute %s reference an entity \"%s\" of wrong type\n", 		       name, value);
 		ret = 0; 	    } 	    break; 	         }  	case XML_ATTRIBUTE_ENTITIES: { + 	    xmlChar *dup, *nam = NULL, *cur, save;  	    xmlEntityPtr ent;   	    dup = xmlStrdup(value); 	    if (dup == NULL)  		return(0); 	    cur = dup;  	    while (*cur != 0) { 		nam = cur;1 		while ((*cur != 0) && (!IS_BLANK(*cur))) cur++;  		save = *cur; 		*cur = 0; " 		ent = xmlGetDocEntity(doc, nam); 		if (ent == NULL) { 		    VERROR(ctxt->userData,  D        "ENTITIES attribute %s reference an unknown entity \"%s\"\n", 			   name, nam);  		    ret = 0;B 		} else if (ent->etype != XML_EXTERNAL_GENERAL_UNPARSED_ENTITY) { 		    VERROR(ctxt->userData,  J        "ENTITIES attribute %s reference an entity \"%s\" of wrong type\n", 			   name, nam);  		    ret = 0; 		}  		if (save == 0) 		    break; 		*cur = save; 		while (IS_BLANK(*cur)) cur++;  	    } 	    xmlFree(dup); 	    break;  	} 	case XML_ATTRIBUTE_NOTATION: {  	    xmlNotationPtr nota;   9 	    nota = xmlGetDtdNotationDesc(doc->intSubset, value); 4 	    if ((nota == NULL) && (doc->extSubset != NULL))6 		nota = xmlGetDtdNotationDesc(doc->extSubset, value);   	    if (nota == NULL) { 		VERROR(ctxt->userData,  F        "NOTATION attribute %s reference an unknown notation \"%s\"\n", 		       name, value);
 		ret = 0; 	    } 	    break; 	         }      }      return(ret); }    /** #  * xmlValidNormalizeAttributeValue:   * @doc:  the document  * @elem:  the parent   * @name:  the attribute name   * @value:  the attribute value   *K  * Does the validation related extra step of the normalization of attribute 
  * values:  *J  * If the declared value is not CDATA, then the XML processor must furtherG  * process the normalized attribute value by discarding any leading and H  * trailing space (#x20) characters, and by replacing sequences of space6  * (#x20) characters by single space (#x20) character.  *M  * returns a new normalized string if normalization is needed, NULL otherwise 0  *      the caller must free the returned value.  */   	 xmlChar * ? xmlValidNormalizeAttributeValue(xmlDocPtr doc, xmlNodePtr elem, 7 			        const xmlChar *name, const xmlChar *value) {      xmlChar *ret, *dst;      const xmlChar *src; $     xmlAttributePtr attrDecl = NULL;  "     if (doc == NULL) return(NULL);#     if (elem == NULL) return(NULL); #     if (name == NULL) return(NULL); $     if (value == NULL) return(NULL);  ;     if ((elem->ns != NULL) && (elem->ns->prefix != NULL)) {  	xmlChar qname[500]; #ifdef HAVE_SNPRINTF1 	snprintf((char *) qname, sizeof(qname), "%s:%s", ! 		 elem->ns->prefix, elem->name);  #else @ 	sprintf((char *) qname, "%s:%s", elem->ns->prefix, elem->name); #endif%         qname[sizeof(qname) - 1] = 0; ; 	attrDecl = xmlGetDtdAttrDesc(doc->intSubset, qname, name); 4 	if ((attrDecl == NULL) && (doc->extSubset != NULL))? 	    attrDecl = xmlGetDtdAttrDesc(doc->extSubset, qname, name);      } C     attrDecl = xmlGetDtdAttrDesc(doc->intSubset, elem->name, name); 7     if ((attrDecl == NULL) && (doc->extSubset != NULL)) @ 	attrDecl = xmlGetDtdAttrDesc(doc->extSubset, elem->name, name);       if (attrDecl == NULL)  	return(NULL);/     if (attrDecl->atype == XML_ATTRIBUTE_CDATA)  	return(NULL);       ret = xmlStrdup(value);      if (ret == NULL) 	return(NULL);     src = value;     dst = ret;     while (*src == 0x20) src++;      while (*src != 0) {  	if (*src == 0x20) {  	    while (*src == 0x20) src++; 	    if (*src != 0)  		*dst++ = 0x20;	 	} else {  	    *dst++ = *src++;  	}     } 
     *dst = 0;      return(ret); }    /**   * xmlValidateAttributeDecl:!  * @ctxt:  the validation context   * @doc:  a document instance "  * @attr:  an attribute definition  *0  * Try to validate a single attribute definition=  * basically it does the following checks as described by the   * XML-1.0 recommendation:%  *  - [ VC: Attribute Default Legal ]   *  - [ VC: Enumeration ] "  *  - [ VC: ID Attribute Default ]  *;  * The ID/IDREF uniqueness and matching are done separately   *$  * returns 1 if valid or 0 otherwise  */    int = xmlValidateAttributeDecl(xmlValidCtxtPtr ctxt, xmlDocPtr doc, 0                          xmlAttributePtr attr) {     int ret = 1;     int val;     CHECK_DTD;     if(attr == NULL) return(1);      !     /* Attribute Default Legal */      /* Enumeration */ %     if (attr->defaultValue != NULL) { B 	val = xmlValidateAttributeValue(attr->atype, attr->defaultValue); 	if (val == 0) { 	    VERROR(ctxt->userData, H 	       "Syntax of default value for attribute %s on %s is not valid\n",$ 	           attr->name, attr->elem); 	}         ret &= val;      }        /* ID Attribute Default */+     if ((attr->atype == XML_ATTRIBUTE_ID)&& /         (attr->def != XML_ATTRIBUTE_IMPLIED) && ) 	(attr->def != XML_ATTRIBUTE_REQUIRED)) {  	VERROR(ctxt->userData, O           "ID attribute %s on %s is not valid must be #IMPLIED or #REQUIRED\n",   	       attr->name, attr->elem);	 	ret = 0;      }   !     /* One ID per Element Type */ *     if (attr->atype == XML_ATTRIBUTE_ID) {         int nbId;   B 	/* the trick is taht we parse DtD as their own internal subset */A         xmlElementPtr elem = xmlGetDtdElementDesc(doc->intSubset, 7 	                                          attr->elem);  	if (elem != NULL) {/ 	    nbId = xmlScanIDAttributeDecl(NULL, elem); 	 	} else {   	    xmlAttributeTablePtr table; 	    int i;    	    /* D 	     * The attribute may be declared in the internal subset and the' 	     * element in the external subset.  	     */ 	    nbId = 0;? 	    table = (xmlAttributeTablePtr) doc->intSubset->attributes;  	    if (table != NULL) { , 		for (i = 0;i < table->nb_attributes;i++) {9 		    if ((table->table[i]->atype == XML_ATTRIBUTE_ID) && 6 			(xmlStrEqual(table->table[i]->elem, attr->elem))) {
 			nbId++; 		    }  		}  	    }	  	} 	if (nbId > 1) { 	    VERROR(ctxt->userData, N        "Element %s has %d ID attribute defined in the internal subset : %s\n",# 		   attr->elem, nbId, attr->name); % 	} else if (doc->extSubset != NULL) {  	    int extId = 0; = 	    elem = xmlGetDtdElementDesc(doc->extSubset, attr->elem);  	    if (elem != NULL) {- 		extId = xmlScanIDAttributeDecl(NULL, elem);  	    } 	    if (extId > 1) {  		VERROR(ctxt->userData,  N        "Element %s has %d ID attribute defined in the external subset : %s\n",( 		       attr->elem, extId, attr->name);# 	    } else if (extId + nbId > 1) {  		VERROR(ctxt->userData,  R "Element %s has ID attributes defined in the internal and external subset : %s\n",! 		       attr->elem, attr->name);  	    } 	}     }   *     /* Validity Constraint: Enumeration */?     if ((attr->defaultValue != NULL) && (attr->tree != NULL)) { ,         xmlEnumerationPtr tree = attr->tree; 	while (tree != NULL) { < 	    if (xmlStrEqual(tree->name, attr->defaultValue)) break; 	    tree = tree->next;  	} 	if (tree == NULL) { 	    VERROR(ctxt->userData, P "Default value \"%s\" for attribute %s on %s is not among the enumerated set\n",1 		   attr->defaultValue, attr->name, attr->elem); 
 	    ret = 0;  	}     }        return(ret); }    /**   * xmlValidateElementDecl:!  * @ctxt:  the validation context   * @doc:  a document instance    * @elem:  an element definition  *.  * Try to validate a single element definition=  * basically it does the following checks as described by the   * XML-1.0 recommendation:%  *  - [ VC: One ID per Element Type ]    *  - [ VC: No Duplicate Types ]-  *  - [ VC: Unique Element Type Declaration ]   *$  * returns 1 if valid or 0 otherwise  */    int ; xmlValidateElementDecl(xmlValidCtxtPtr ctxt, xmlDocPtr doc, ,                        xmlElementPtr elem) {     int ret = 1;     xmlElementPtr tst;       CHECK_DTD;           if (elem == NULL) return(1);       /* No Duplicate Types */0     if (elem->etype == XML_ELEMENT_TYPE_MIXED) {  	xmlElementContentPtr cur, next;         const xmlChar *name;   	cur = elem->content;  	while (cur != NULL) {4 	    if (cur->type != XML_ELEMENT_CONTENT_OR) break;  	    if (cur->c1 == NULL) break;8 	    if (cur->c1->type == XML_ELEMENT_CONTENT_ELEMENT) { 		name = cur->c1->name;  		next = cur->c2;  		while (next != NULL) {6 		    if (next->type == XML_ELEMENT_CONTENT_ELEMENT) {. 		        if (xmlStrEqual(next->name, name)) { 			    VERROR(ctxt->userData, 9 		   "Definition of %s has duplicate references of %s\n",  				   elem->name, name);  			    ret = 0;  			}	 			break;  		    } " 		    if (next->c1 == NULL) break;? 		    if (next->c1->type != XML_ELEMENT_CONTENT_ELEMENT) break; . 		    if (xmlStrEqual(next->c1->name, name)) { 			VERROR(ctxt->userData, < 	       "Definition of %s has duplicate references of %s\n", 			       elem->name, name); 			ret = 0;  		    }  		    next = next->c2; 		}  	    } 	    cur = cur->c2;  	}     }   -     /* VC: Unique Element Type Declaration */ ;     tst = xmlGetDtdElementDesc(doc->intSubset, elem->name); *     if ((tst != NULL ) && (tst != elem)) {7 	VERROR(ctxt->userData, "Redefinition of element %s\n",  	       elem->name);	 	ret = 0;      } ;     tst = xmlGetDtdElementDesc(doc->extSubset, elem->name); *     if ((tst != NULL ) && (tst != elem)) {7 	VERROR(ctxt->userData, "Redefinition of element %s\n",  	       elem->name);	 	ret = 0;      }   !     /* One ID per Element Type */ 1     if (xmlScanIDAttributeDecl(ctxt, elem) > 1) { 	 	ret = 0;      }      return(ret); }    /**   * xmlValidateOneAttribute: !  * @ctxt:  the validation context   * @doc:  a document instance   * @elem:  an element instance   * @attr:  an attribute instance=  * @value:  the attribute value (without entities processing)   *4  * Try to validate a single attribute for an element=  * basically it does the following checks as described by the   * XML-1.0 recommendation:"  *  - [ VC: Attribute Value Type ]%  *  - [ VC: Fixed Attribute Default ]   *  - [ VC: Entity Name ]   *  - [ VC: Name Token ]  *  - [ VC: ID ]  *  - [ VC: IDREF ]   *  - [ VC: Entity Name ] !  *  - [ VC: Notation Attributes ]   *;  * The ID/IDREF uniqueness and matching are done separately   *$  * returns 1 if valid or 0 otherwise  */    int < xmlValidateOneAttribute(xmlValidCtxtPtr ctxt, xmlDocPtr doc,Q                         xmlNodePtr elem, xmlAttrPtr attr, const xmlChar *value) { !     /* xmlElementPtr elemDecl; */ %     xmlAttributePtr attrDecl =  NULL;      int val;     int ret = 1;       CHECK_DTD;:     if ((elem == NULL) || (elem->name == NULL)) return(0);:     if ((attr == NULL) || (attr->name == NULL)) return(0);  ;     if ((elem->ns != NULL) && (elem->ns->prefix != NULL)) {  	xmlChar qname[500]; #ifdef HAVE_SNPRINTF1 	snprintf((char *) qname, sizeof(qname), "%s:%s", ! 		 elem->ns->prefix, elem->name);  #else @ 	sprintf((char *) qname, "%s:%s", elem->ns->prefix, elem->name); #endif%         qname[sizeof(qname) - 1] = 0;  	if (attr->ns != NULL) {9 	    attrDecl = xmlGetDtdQAttrDesc(doc->intSubset, qname, : 		                          attr->name, attr->ns->prefix);8 	    if ((attrDecl == NULL) && (doc->extSubset != NULL))6 		attrDecl = xmlGetDtdQAttrDesc(doc->extSubset, qname,) 					      attr->name, attr->ns->prefix); 	 	} else { E 	    attrDecl = xmlGetDtdAttrDesc(doc->intSubset, qname, attr->name); 8 	    if ((attrDecl == NULL) && (doc->extSubset != NULL)). 		attrDecl = xmlGetDtdAttrDesc(doc->extSubset, 					     qname, attr->name);  	}     }      if (attrDecl == NULL) {  	if (attr->ns != NULL) {> 	    attrDecl = xmlGetDtdQAttrDesc(doc->intSubset, elem->name,: 		                          attr->name, attr->ns->prefix);8 	    if ((attrDecl == NULL) && (doc->extSubset != NULL)); 		attrDecl = xmlGetDtdQAttrDesc(doc->extSubset, elem->name, ) 					      attr->name, attr->ns->prefix); 	 	} else { 1 	    attrDecl = xmlGetDtdAttrDesc(doc->intSubset, 3 		                         elem->name, attr->name); 8 	    if ((attrDecl == NULL) && (doc->extSubset != NULL)). 		attrDecl = xmlGetDtdAttrDesc(doc->extSubset," 					     elem->name, attr->name); 	}     }     3     /* Validity Constraint: Attribute Value Type */      if (attrDecl == NULL) {  	VERROR(ctxt->userData, : 	       "No declaration for attribute %s on element %s\n",  	       attr->name, elem->name); 	return(0);      } "     attr->atype = attrDecl->atype;  <     val = xmlValidateAttributeValue(attrDecl->atype, value);     if (val == 0) {  	VERROR(ctxt->userData, < 	   "Syntax of value for attribute %s on %s is not valid\n",  	       attr->name, elem->name);         ret = 0;     }   6     /* Validity constraint: Fixed Attribute Default *//     if (attrDecl->def == XML_ATTRIBUTE_FIXED) { 3 	if (!xmlStrEqual(value, attrDecl->defaultValue)) {  	    VERROR(ctxt->userData, E 	   "Value for attribute %s on %s is differnt from default \"%s\"\n", 5 		   attr->name, elem->name, attrDecl->defaultValue); 
 	    ret = 0;  	}     }   ,     /* Validity Constraint: ID uniqueness */.     if (attrDecl->atype == XML_ATTRIBUTE_ID) {)         xmlAddID(ctxt, doc, value, attr);      }   3     if ((attrDecl->atype == XML_ATTRIBUTE_IDREF) || - 	(attrDecl->atype == XML_ATTRIBUTE_IDREFS)) { *         xmlAddRef(ctxt, doc, value, attr);     }   2     /* Validity Constraint: Notation Attributes */4     if (attrDecl->atype == XML_ATTRIBUTE_NOTATION) {0         xmlEnumerationPtr tree = attrDecl->tree;         xmlNotationPtr nota;  >         /* First check that the given NOTATION was declared */5 	nota = xmlGetDtdNotationDesc(doc->intSubset, value);  	if (nota == NULL)9 	    nota = xmlGetDtdNotationDesc(doc->extSubset, value);  	  	if (nota == NULL) { 	    VERROR(ctxt->userData, J        "Value \"%s\" for attribute %s on %s is not a declared Notation\n",$ 		   value, attr->name, elem->name);
 	    ret = 0; 	         }   . 	/* Second, verify that it's among the list */ 	while (tree != NULL) { / 	    if (xmlStrEqual(tree->name, value)) break;  	    tree = tree->next;  	} 	if (tree == NULL) { 	    VERROR(ctxt->userData, N "Value \"%s\" for attribute %s on %s is not among the enumerated notations\n",$ 		   value, attr->name, elem->name);
 	    ret = 0;  	}     }   *     /* Validity Constraint: Enumeration */7     if (attrDecl->atype == XML_ATTRIBUTE_ENUMERATION) { 0         xmlEnumerationPtr tree = attrDecl->tree; 	while (tree != NULL) { / 	    if (xmlStrEqual(tree->name, value)) break;  	    tree = tree->next;  	} 	if (tree == NULL) { 	    VERROR(ctxt->userData, O        "Value \"%s\" for attribute %s on %s is not among the enumerated set\n", $ 		   value, attr->name, elem->name);
 	    ret = 0;  	}     }   !     /* Fixed Attribute Default */ 1     if ((attrDecl->def == XML_ATTRIBUTE_FIXED) && 8         (!xmlStrEqual(attrDecl->defaultValue, value))) { 	VERROR(ctxt->userData, 4 	   "Value for attribute %s on %s must be \"%s\"\n",8 	       attr->name, elem->name, attrDecl->defaultValue);         ret = 0;     }   -     /* Extra check for the attribute value */ <     ret &= xmlValidateAttributeValue2(ctxt, doc, attr->name," 				      attrDecl->atype, value);       return(ret); }   J int xmlValidateElementTypeElement(xmlValidCtxtPtr ctxt, xmlNodePtr *child,! 				  xmlElementContentPtr cont);    /**   * xmlValidateElementTypeExpr:!  * @ctxt:  the validation context %  * @child:  pointer to the child list -  * @cont:  pointer to the content declaration   *<  * Try to validate the content of an element of type element(  * but don't handle the occurence factor  *;  * returns 1 if valid or 0 and -1 if PCDATA stuff is found, +  *         also update child value in-situ.   */    int C xmlValidateElementTypeExpr(xmlValidCtxtPtr ctxt, xmlNodePtr *child, " 			   xmlElementContentPtr cont) {     xmlNodePtr cur;      int ret = 1;  !     if (cont == NULL) return(-1); #     DEBUG_VALID_STATE(*child, cont)      while (*child != NULL) {4         if ((*child)->type == XML_ENTITY_REF_NODE) { 	    /* 8 	     * If there is an entity declared an it's not empty? 	     * Push the current node on the stack and process with the  	     * entity content.  	     */( 	    if (((*child)->children != NULL) &&+ 		((*child)->children->children != NULL)) {  		nodeVPush(ctxt, *child);( 		*child = (*child)->children->children; 	    } else  		*child = (*child)->next; 	    continue; 	},         if ((*child)->type == XML_PI_NODE) { 	    *child = (*child)->next;  	    continue; 	}1         if ((*child)->type == XML_COMMENT_NODE) {  	    *child = (*child)->next;  	    continue; 	}/ 	else if ((*child)->type != XML_ELEMENT_NODE) {  	    return(-1); 	} 	break;      } #     DEBUG_VALID_STATE(*child, cont)      switch (cont->type) { ! 	case XML_ELEMENT_CONTENT_PCDATA: # 	    if (*child == NULL) return(0); 4 	    if ((*child)->type == XML_TEXT_NODE) return(1); 	    return(0); " 	case XML_ELEMENT_CONTENT_ELEMENT:# 	    if (*child == NULL) return(0); 5 	    ret = (xmlStrEqual((*child)->name, cont->name));  	    if (ret == 1) {" 		while ((*child)->next == NULL) {5                     if (((*child)->parent != NULL) && 1 			((*child)->parent->type == XML_ENTITY_DECL)) {  			*child = nodeVPop(ctxt);  		    } else	 			break;  		} ! 	        *child = (*child)->next;  	    } 	    return(ret);  	case XML_ELEMENT_CONTENT_OR:  	    cur = *child;@ 	    ret = xmlValidateElementTypeElement(ctxt, child, cont->c1); 	    if (ret == -1) return(-1);  	    if (ret == 1) {
 		 return(1);  	    }, 	    /* rollback and retry the other path */ 	    *child = cur;@ 	    ret = xmlValidateElementTypeElement(ctxt, child, cont->c2); 	    if (ret == -1) return(-1);  	    if (ret == 0) { 		*child = cur;  		return(0); 	    } 	    return(1);  	case XML_ELEMENT_CONTENT_SEQ: 	    cur = *child;@ 	    ret = xmlValidateElementTypeElement(ctxt, child, cont->c1); 	    if (ret == -1) return(-1);  	    if (ret == 0) { 		*child = cur;  		return(0); 	    }@ 	    ret = xmlValidateElementTypeElement(ctxt, child, cont->c2); 	    if (ret == -1) return(-1);  	    if (ret == 0) { 		*child = cur;  		return(0); 	    } 	    return(1);      }      return(ret); }    /** !  * xmlValidateElementTypeElement: !  * @ctxt:  the validation context %  * @child:  pointer to the child list -  * @cont:  pointer to the content declaration   *<  * Try to validate the content of an element of type element9  * yeah, Yet Another Regexp Implementation, and recursive   *;  * returns 1 if valid or 0 and -1 if PCDATA stuff is found, 8  *         also update child and content values in-situ.  */    int F xmlValidateElementTypeElement(xmlValidCtxtPtr ctxt, xmlNodePtr *child,% 			      xmlElementContentPtr cont) {      xmlNodePtr cur;      int ret = 1;  !     if (cont == NULL) return(-1);   #     DEBUG_VALID_STATE(*child, cont)      while (*child != NULL) {4         if ((*child)->type == XML_ENTITY_REF_NODE) { 	    /* 8 	     * If there is an entity declared an it's not empty? 	     * Push the current node on the stack and process with the  	     * entity content.  	     */( 	    if (((*child)->children != NULL) &&+ 		((*child)->children->children != NULL)) {  		nodeVPush(ctxt, *child);( 		*child = (*child)->children->children; 	    } else  		*child = (*child)->next; 	    continue; 	},         if ((*child)->type == XML_PI_NODE) { 	    *child = (*child)->next;  	    continue; 	}1         if ((*child)->type == XML_COMMENT_NODE) {  	    *child = (*child)->next;  	    continue; 	}/ 	else if ((*child)->type != XML_ELEMENT_NODE) {  	    return(-1); 	} 	break;      } #     DEBUG_VALID_STATE(*child, cont)      cur = *child; 8     ret = xmlValidateElementTypeExpr(ctxt, child, cont);     if (ret == -1) return(-1);     switch (cont->ocur) {  	case XML_ELEMENT_CONTENT_ONCE:  	    if (ret == 1) { 		/* skip ignorable elems */ 		while ((*child != NULL) &&, 		       (((*child)->type == XML_PI_NODE) ||+ 			((*child)->type == XML_COMMENT_NODE))) { & 		    while ((*child)->next == NULL) {$ 			if (((*child)->parent != NULL) &&9 			    ((*child)->parent->type == XML_ENTITY_REF_NODE)) { ! 			    *child = (*child)->parent; 	 			} else 
 			    break;  		    }  		    *child = (*child)->next; 		}  		return(1); 	    } 	    *child = cur; 	    return(0);  	case XML_ELEMENT_CONTENT_OPT: 	    if (ret == 0) { 		*child = cur;  	        return(1);  	    } 	    break;  	case XML_ELEMENT_CONTENT_MULT:  	    if (ret == 0) { 		*child = cur;  	        break;  	    } 	    /* no break on purpose */ 	case XML_ELEMENT_CONTENT_PLUS:  	    if (ret == 0) { 		*child = cur;  	        return(0);  	    }	 	    do {  		cur = *child; 6 		ret = xmlValidateElementTypeExpr(ctxt, child, cont); 	    } while (ret == 1); 	    if (ret == -1) return(-1);  	    *child = cur; 	    break;      }      while (*child != NULL) {4         if ((*child)->type == XML_ENTITY_REF_NODE) { 	    /* 8 	     * If there is an entity declared an it's not empty? 	     * Push the current node on the stack and process with the  	     * entity content.  	     */( 	    if (((*child)->children != NULL) &&+ 		((*child)->children->children != NULL)) {  		nodeVPush(ctxt, *child);( 		*child = (*child)->children->children; 	    } else  		*child = (*child)->next; 	    continue; 	},         if ((*child)->type == XML_PI_NODE) { 	    *child = (*child)->next;  	    continue; 	}1         if ((*child)->type == XML_COMMENT_NODE) {  	    *child = (*child)->next;  	    continue; 	}/ 	else if ((*child)->type != XML_ELEMENT_NODE) {  	    return(-1); 	} 	break;      }      return(1); }    /**   * xmlSprintfElementChilds:   * @buf:  an output buffer  * @content:  An elementD  * @glob: 1 if one must print the englobing parenthesis, 0 otherwise  *2  * This will dump the list of childs to the buffer&  * Intended just for the debug routine  */  void? xmlSprintfElementChilds(char *buf, xmlNodePtr node, int glob) {      xmlNodePtr cur;        if (node == NULL) return;      if (glob) strcat(buf, "(");      cur = node->children;      while (cur != NULL) {          switch (cur->type) {"             case XML_ELEMENT_NODE:* 	         strcat(buf, (char *) cur->name); 		 if (cur->next != NULL)  		     strcat(buf, " ");	 		 break;              case XML_TEXT_NODE: (             case XML_CDATA_SECTION_NODE:%             case XML_ENTITY_REF_NODE:  	         strcat(buf, "CDATA");  		 if (cur->next != NULL)  		     strcat(buf, " ");	 		 break; $             case XML_ATTRIBUTE_NODE:#             case XML_DOCUMENT_NODE:  #ifdef LIBXML_SGML_ENABLED! 	    case XML_SGML_DOCUMENT_NODE:  #endif! 	    case XML_HTML_DOCUMENT_NODE: (             case XML_DOCUMENT_TYPE_NODE:(             case XML_DOCUMENT_FRAG_NODE:#             case XML_NOTATION_NODE:  	         strcat(buf, "???");  		 if (cur->next != NULL)  		     strcat(buf, " ");	 		 break; !             case XML_ENTITY_NODE:              case XML_PI_NODE:              case XML_DTD_NODE:"             case XML_COMMENT_NODE: 	    case XML_ELEMENT_DECL:  	    case XML_ATTRIBUTE_DECL:  	    case XML_ENTITY_DECL:	 		 break;  	} 	cur = cur->next;      }      if (glob) strcat(buf, ")");  }      /**   * xmlValidateOneElement: !  * @ctxt:  the validation context   * @doc:  a document instance   * @elem:  an element instance  *8  * Try to validate a single element and it's attributes,=  * basically it does the following checks as described by the   * XML-1.0 recommendation:  *  - [ VC: Element Valid ]    *  - [ VC: Required Attribute ]B  * Then call xmlValidateOneAttribute() for each attribute present.  *-  * The ID/IDREF checkings are done separately   *$  * returns 1 if valid or 0 otherwise  */    int : xmlValidateOneElement(xmlValidCtxtPtr ctxt, xmlDocPtr doc,(                       xmlNodePtr elem) {"     xmlElementPtr elemDecl = NULL;     xmlElementContentPtr cont;     xmlAttributePtr attr;      xmlNodePtr child;      int ret = 1;     const xmlChar *name;       CHECK_DTD;        if (elem == NULL) return(0);&     if (elem->type == XML_TEXT_NODE) {     }      switch (elem->type) {           case XML_ATTRIBUTE_NODE: 	    VERROR(ctxt->userData, . 		   "Attribute element not expected here\n"); 	    return(0);          case XML_TEXT_NODE: " 	    if (elem->children != NULL) {8 		VERROR(ctxt->userData, "Text element has childs !\n"); 		return(0); 	    }$ 	    if (elem->properties != NULL) {< 		VERROR(ctxt->userData, "Text element has attributes !\n"); 		return(0); 	    } 	    if (elem->ns != NULL) {; 		VERROR(ctxt->userData, "Text element has namespace !\n");  		return(0); 	    } 	    if (elem->nsDef != NULL) {  		VERROR(ctxt->userData,  ; 		       "Text element carries namespace definitions !\n");  		return(0); 	    }! 	    if (elem->content == NULL) {  		VERROR(ctxt->userData,  , 		       "Text element has no content !\n"); 		return(0); 	    } 	    return(1); $         case XML_CDATA_SECTION_NODE:!         case XML_ENTITY_REF_NODE:          case XML_PI_NODE:          case XML_COMMENT_NODE: 	    return(1);          case XML_ENTITY_NODE:  	    VERROR(ctxt->userData, + 		   "Entity element not expected here\n");  	    return(0);          case XML_NOTATION_NODE:  	    VERROR(ctxt->userData, - 		   "Notation element not expected here\n");  	    return(0);          case XML_DOCUMENT_NODE: $         case XML_DOCUMENT_TYPE_NODE:$         case XML_DOCUMENT_FRAG_NODE: 	    VERROR(ctxt->userData, - 		   "Document element not expected here\n");  	    return(0); $         case XML_HTML_DOCUMENT_NODE: 	    VERROR(ctxt->userData,  		   "\n");  	    return(0);          case XML_ELEMENT_NODE: 	    break; 	 	default:  	    VERROR(ctxt->userData, . 		   "unknown element type %d\n", elem->type); 	    return(0);      } &     if (elem->name == NULL) return(0);       /*3      * Fetch the declaration for the qualified name       */ ;     if ((elem->ns != NULL) && (elem->ns->prefix != NULL)) { 1 	elemDecl = xmlGetDtdQElementDesc(doc->intSubset, 9 		                         elem->name, elem->ns->prefix); 4 	if ((elemDecl == NULL) && (doc->extSubset != NULL))5 	    elemDecl = xmlGetDtdQElementDesc(doc->extSubset, = 		                             elem->name, elem->ns->prefix);      }        /*7      * Fetch the declaration for the non qualified name       */      if (elemDecl == NULL) { = 	elemDecl = xmlGetDtdElementDesc(doc->intSubset, elem->name); 4 	if ((elemDecl == NULL) && (doc->extSubset != NULL))A 	    elemDecl = xmlGetDtdElementDesc(doc->extSubset, elem->name);      }      if (elemDecl == NULL) { : 	VERROR(ctxt->userData, "No declaration for element %s\n", 	       elem->name); 	return(0);      }   ?     /* Check taht the element content matches the definition */      switch (elemDecl->etype) {$         case XML_ELEMENT_TYPE_EMPTY:" 	    if (elem->children != NULL) { 		VERROR(ctxt->userData,? 	       "Element %s was declared EMPTY this one has content\n",  	               elem->name);
 		ret = 0; 	    } 	    break; "         case XML_ELEMENT_TYPE_ANY:2 	    /* I don't think anything is required then */ 	    break; $         case XML_ELEMENT_TYPE_MIXED:' 	    /* Hum, this start to get messy */  	    child = elem->children; 	    while (child != NULL) {/ 	        if (child->type == XML_ELEMENT_NODE) {  		    name = child->name; ? 		    if ((child->ns != NULL) && (child->ns->prefix != NULL)) {  			xmlChar qname[500]; #ifdef HAVE_SNPRINTF3 			snprintf((char *) qname, sizeof(qname), "%s:%s", % 				 child->ns->prefix, child->name);  #else # 			sprintf((char *) qname, "%s:%s", A                                  child->ns->prefix, child->name);  #endif5                         qname[sizeof(qname) - 1] = 0;  			cont = elemDecl->content; 			while (cont != NULL) { 7 			    if (cont->type == XML_ELEMENT_CONTENT_ELEMENT) { . 				if (xmlStrEqual(cont->name, qname)) break;; 			    } else if ((cont->type == XML_ELEMENT_CONTENT_OR) &&  			       (cont->c1 != NULL) && ; 			       (cont->c1->type == XML_ELEMENT_CONTENT_ELEMENT)){ 2 				if (xmlStrEqual(cont->c1->name, qname)) break;; 			    } else if ((cont->type != XML_ELEMENT_CONTENT_OR) ||  				(cont->c1 == NULL) || 4 				(cont->c1->type != XML_ELEMENT_CONTENT_PCDATA)){ 				/* Internal error !!! */4 				fprintf(stderr, "Internal: MIXED struct bad\n");
 				break; 			    } 			    cont = cont->c2;  			} 			if (cont != NULL) 			    goto child_ok;  		    }  		    cont = elemDecl->content;  		    while (cont != NULL) {: 		        if (cont->type == XML_ELEMENT_CONTENT_ELEMENT) {0 			    if (xmlStrEqual(cont->name, name)) break;7 			} else if ((cont->type == XML_ELEMENT_CONTENT_OR) &&  			   (cont->c1 != NULL) && 8 			   (cont->c1->type == XML_ELEMENT_CONTENT_ELEMENT)) {4 			    if (xmlStrEqual(cont->c1->name, name)) break;7 			} else if ((cont->type != XML_ELEMENT_CONTENT_OR) ||  			    (cont->c1 == NULL) ||8 			    (cont->c1->type != XML_ELEMENT_CONTENT_PCDATA)) { 			    /* Internal error !!! */ 7 			    fprintf(stderr, "Internal: MIXED struct bad\n"); 
 			    break;  			} 			cont = cont->c2;  		    }  		    if (cont == NULL) {  			VERROR(ctxt->userData, E 	       "Element %s is not declared in %s list of possible childs\n",  			       name, elem->name); 			ret = 0;  		    }  		} 	 child_ok:  	        child = child->next;  	    } 	    break; &         case XML_ELEMENT_TYPE_ELEMENT: 	    child = elem->children; 	    cont = elemDecl->content;= 	    ret = xmlValidateElementTypeElement(ctxt, &child, cont); ) 	    if ((ret == 0) || (child != NULL)) {  	        char expr[1000];  	        char list[2000];    		expr[0] = 0;* 		xmlSprintfElementContent(expr, cont, 1); 		list[0] = 0;) 		xmlSprintfElementChilds(list, elem, 1);    		VERROR(ctxt->userData,H 	   "Element %s content doesn't follow the Dtd\nExpecting %s, got %s\n",( 	               elem->name, expr, list);
 		ret = 0; 	    } 	    break;      }   $     /* [ VC: Required Attribute ] */      attr = elemDecl->attributes;     while (attr != NULL) {+ 	if (attr->def == XML_ATTRIBUTE_REQUIRED) {  	    xmlAttrPtr attrib;  	    int qualified = -1; 	      	    attrib = elem->properties;  	    while (attrib != NULL) { . 		if (xmlStrEqual(attrib->name, attr->name)) {! 		    if (attr->prefix != NULL) { * 		        xmlNsPtr nameSpace = attrib->ns;   			if (nameSpace == NULL)  			    nameSpace = elem->ns; 			/* 7 			 * qualified names handling is problematic, having a 8 			 * different prefix should be possible but DTDs don't7 			 * allow to define the URI instead of the prefix :-(  			 */ 			if (nameSpace == NULL) {  			    if (qualified < 0)  				qualified = 0;B 	    		} else if (!xmlStrEqual(nameSpace->prefix, attr->prefix)) { 			    if (qualified < 1)  				qualified = 1;	 			} else  			    goto found; 		    } else { 		        /*7 			 * We should allow applications to define namespaces 4 			 * for their application even if the DTD doesn't 5 			 * carry one, otherwise, basically we would always  			 * break. 			 */ 			goto found; 		    }  		}  		attrib = attrib->next; 	    } 	    if (qualified == -1) {  		if (attr->prefix == NULL) {  		    VERROR(ctxt->userData,3 		       "Element %s doesn't carry attribute %s\n",  			   elem->name, attr->name); 	        } else {  		    VERROR(ctxt->userData,6 		       "Element %s doesn't carry attribute %s:%s\n",+ 			   elem->name, attr->prefix,attr->name);  		} ! 	    } else if (qualified == 0) {  		VWARNING(ctxt->userData,; 		   "Element %s required attribute %s:%s has no prefix\n", . 		       elem->name, attr->prefix,attr->name);! 	    } else if (qualified == 1) {  		VWARNING(ctxt->userData,B 		   "Element %s required attribute %s:%s has different prefix\n",. 		       elem->name, attr->prefix,attr->name); 	    } 	} found:	              attr = attr->nexth;      }      return(ret); }    /**   * xmlValidateRoot: !  * @ctxt:  the validation context   * @doc:  a document instance   *%  * Try to validate a the root element <  * basically it does the following check as described by the  * XML-1.0 recommendation:  *  - [ VC: Root Element Type ] @  * it doesn't try to recurse or apply other check to the element  *$  * returns 1 if valid or 0 otherwise  */    int 6 xmlValidateRoot(xmlValidCtxtPtr ctxt, xmlDocPtr doc) {     xmlNodePtr root;     if (doc == NULL) return(0);   #     if ((doc->intSubset == NULL) || " 	(doc->intSubset->name == NULL)) {5 	VERROR(ctxt->userData, "Not valid: no DtD found\n");          return(0);     } %     root = xmlDocGetRootElement(doc); 1     if ((root == NULL) || (root->name == NULL)) { 8 	VERROR(ctxt->userData, "Not valid: no root element\n");         return(0);     }        /*7      * Check first the document root against the NQName       */ 9     if (!xmlStrEqual(doc->intSubset->name, root->name)) { 8 	if ((root->ns != NULL) && (root->ns->prefix != NULL)) { 	    xmlChar qname[500]; #ifdef HAVE_SNPRINTF5 	    snprintf((char *) qname, sizeof(qname), "%s:%s", % 		     root->ns->prefix, root->name);  #else D 	    sprintf((char *) qname, "%s:%s", root->ns->prefix, root->name); #endif)             qname[sizeof(qname) - 1] = 0; 2 	    if (xmlStrEqual(doc->intSubset->name, qname)) 		goto name_ok;  	}  < 	if ((xmlStrEqual(doc->intSubset->name, BAD_CAST "HTML")) &&0 	    (xmlStrEqual(root->name, BAD_CAST "html"))) 	    goto name_ok; 	VERROR(ctxt->userData, D 	       "Not valid: root and DtD name do not match '%s' and '%s'\n",* 	       root->name, doc->intSubset->name); 	return(0);  	      }  name_ok:     return(1); }      /**   * xmlValidateElement:!  * @ctxt:  the validation context   * @doc:  a document instance   * @elem:  an element instance  *0  * Try to validate the subtree under an element   *$  * returns 1 if valid or 0 otherwise  */    int J xmlValidateElement(xmlValidCtxtPtr ctxt, xmlDocPtr doc, xmlNodePtr elem) {     xmlNodePtr child;      xmlAttrPtr attr;     xmlChar *value;      int ret = 1;        if (elem == NULL) return(0);     CHECK_DTD;  2     ret &= xmlValidateOneElement(ctxt, doc, elem);     attr = elem->properties;     while(attr != NULL) { =         value = xmlNodeListGetString(doc, attr->children, 0); > 	ret &= xmlValidateOneAttribute(ctxt, doc, elem, attr, value); 	if (value != NULL)  	    xmlFree(value); 	attr= attr->next;     }      child = elem->children;      while (child != NULL) { 4         ret &= xmlValidateElement(ctxt, doc, child);         child = child->next;     }        return(ret); }    /**   * xmlValidateDocumentFinal:!  * @ctxt:  the validation context   * @doc:  a document instance   *?  * Does the final step for the document validation once all the 3  * incremental validation steps have been completed   *B  * basically it does the following checks described by the XML Rec  *    *$  * returns 1 if valid or 0 otherwise  */    int ? xmlValidateDocumentFinal(xmlValidCtxtPtr ctxt, xmlDocPtr doc) {      int ret = 1, i;      xmlRefTablePtr table;      xmlAttrPtr id;       if (doc == NULL) {C         fprintf(stderr, "xmlValidateDocumentFinal: doc == NULL\n");  	return(0);      }        /*2      * Check all the NOTATION/NOTATIONS attributes      */      /*G      * Check all the ENTITY/ENTITIES attributes definition for validity       */      /*D      * Check all the IDREF/IDREFS attributes definition for validity      */ '     table = (xmlRefTablePtr) doc->refs;      if (table != NULL) {.         for (i = 0; i < table->nb_refs; i++) {? 	    if (table->table[i]->attr->atype == XML_ATTRIBUTE_IDREF) { - 		id = xmlGetID(doc, table->table[i]->value);  		if (id == NULL) {  		    VERROR(ctxt->userData,  ? 		       "IDREF attribute %s reference an unknown ID \"%s\"\n", ; 			   table->table[i]->attr->name, table->table[i]->value);  		    ret = 0; 		} G 	    } else if (table->table[i]->attr->atype == XML_ATTRIBUTE_IDREFS) { ) 		xmlChar *dup, *name = NULL, *cur, save;   * 		dup = xmlStrdup(table->table[i]->value); 		if (dup == NULL) 		    return(0); 		cur = dup; 		while (*cur != 0) {  		    name = cur; 5 		    while ((*cur != 0) && (!IS_BLANK(*cur))) cur++;  		    save = *cur; 		    *cur = 0;  		    id = xmlGetID(doc, name);  		    if (id == NULL) {  			VERROR(ctxt->userData, @ 		       "IDREFS attribute %s reference an unknown ID \"%s\"\n",- 			       table->table[i]->attr->name, name);  			ret = 0;  		    }  		    if (save == 0)	 			break;  		    *cur = save;1                     while (IS_BLANK(*cur)) cur++;  		}  		xmlFree(dup);  	    } 	}     }      return(ret); }    /**   * xmlValidateDtd:!  * @ctxt:  the validation context   * @doc:  a document instance   * @dtd:  a dtd instance  *8  * Try to validate the document against the dtd instance  *:  * basically it does check all the definitions in the DtD.  *$  * returns 1 if valid or 0 otherwise  */    int D xmlValidateDtd(xmlValidCtxtPtr ctxt, xmlDocPtr doc, xmlDtdPtr dtd) {     int ret;     xmlDtdPtr oldExt;      xmlNodePtr root;       if (dtd == NULL) return(0);      if (doc == NULL) return(0);      oldExt = doc->extSubset;     doc->extSubset = dtd; %     ret = xmlValidateRoot(ctxt, doc);      if (ret == 0) {  	doc->extSubset = oldExt; 
 	return(ret);      } %     root = xmlDocGetRootElement(doc); .     ret = xmlValidateElement(ctxt, doc, root);/     ret &= xmlValidateDocumentFinal(ctxt, doc);      doc->extSubset = oldExt;     return(ret); }    /**   * xmlValidateDtdFinal: !  * @ctxt:  the validation context   * @doc:  a document instance   *;  * Does the final step for the dtds validation once all the   * subsets have been parsed   *B  * basically it does the following checks described by the XML Rec?  * - check that ENTITY and ENTITIES type attributes default or  9  *   possible values matches one of the defined entities. 4  * - check that NOTATION type attributes default or :  *   possible values matches one of the defined notations.  *$  * returns 1 if valid or 0 otherwise  */    int : xmlValidateDtdFinal(xmlValidCtxtPtr ctxt, xmlDocPtr doc) {     int ret = 1, i;      xmlDtdPtr dtd;     xmlAttributeTablePtr table;      xmlAttributePtr cur;       if (doc == NULL) return(0); =     if ((doc->intSubset == NULL) && (doc->extSubset == NULL))  	return(0);      dtd = doc->intSubset; 5     if ((dtd != NULL) && (dtd->attributes != NULL)) { 0 	table = (xmlAttributeTablePtr) dtd->attributes;  + 	for (i = 0;i < table->nb_attributes;i++) {  	    cur = table->table[i];  	    switch (cur->atype) { 		case XML_ATTRIBUTE_CDATA:  		case XML_ATTRIBUTE_ID: 		case XML_ATTRIBUTE_IDREF	: 		case XML_ATTRIBUTE_IDREFS: 		case XML_ATTRIBUTE_NMTOKEN:  		case XML_ATTRIBUTE_NMTOKENS:! 		case XML_ATTRIBUTE_ENUMERATION:  		    break; 		case XML_ATTRIBUTE_ENTITY: 		case XML_ATTRIBUTE_ENTITIES: 		case XML_ATTRIBUTE_NOTATION:& 		    if (cur->defaultValue != NULL) {: 			ret &= xmlValidateAttributeValue2(ctxt, doc, cur->name,+ 					       cur->atype, cur->defaultValue);  		    }  		    if (cur->tree != NULL) {& 			xmlEnumerationPtr tree = cur->tree; 			while (tree != NULL) { 3 			    ret &= xmlValidateAttributeValue2(ctxt, doc, 3 				            cur->name, cur->atype, tree->name);  			    tree = tree->next;  			} 		    }  	    } 	}     }      dtd = doc->extSubset; 5     if ((dtd != NULL) && (dtd->attributes != NULL)) { 0 	table = (xmlAttributeTablePtr) dtd->attributes;  + 	for (i = 0;i < table->nb_attributes;i++) {  	    cur = table->table[i];  	    switch (cur->atype) { 		case XML_ATTRIBUTE_CDATA:  		case XML_ATTRIBUTE_ID: 		case XML_ATTRIBUTE_IDREF	: 		case XML_ATTRIBUTE_IDREFS: 		case XML_ATTRIBUTE_NMTOKEN:  		case XML_ATTRIBUTE_NMTOKENS:! 		case XML_ATTRIBUTE_ENUMERATION:  		    break; 		case XML_ATTRIBUTE_ENTITY: 		case XML_ATTRIBUTE_ENTITIES: 		case XML_ATTRIBUTE_NOTATION:& 		    if (cur->defaultValue != NULL) {: 			ret &= xmlValidateAttributeValue2(ctxt, doc, cur->name,+ 					       cur->atype, cur->defaultValue);  		    }  		    if (cur->tree != NULL) {& 			xmlEnumerationPtr tree = cur->tree; 			while (tree != NULL) { 3 			    ret &= xmlValidateAttributeValue2(ctxt, doc, 3 				            cur->name, cur->atype, tree->name);  			    tree = tree->next;  			} 		    }  	    } 	}     }      return(ret); }    /**   * xmlValidateDocument: !  * @ctxt:  the validation context   * @doc:  a document instance   *(  * Try to validate the document instance  *@  * basically it does the all the checks described by the XML Rec?  * i.e. validates the internal and external subset (if present) "  * and validate the document tree.  *$  * returns 1 if valid or 0 otherwise  */    int : xmlValidateDocument(xmlValidCtxtPtr ctxt, xmlDocPtr doc) {     int ret;     xmlNodePtr root;  =     if ((doc->intSubset == NULL) && (doc->extSubset == NULL))  	return(0); J     if ((doc->intSubset != NULL) && ((doc->intSubset->SystemID != NULL) ||E 	(doc->intSubset->ExternalID != NULL)) && (doc->extSubset == NULL)) { @         doc->extSubset = xmlParseDTD(doc->intSubset->ExternalID,1 		                     doc->intSubset->SystemID); %         if (doc->extSubset == NULL) { , 	    if (doc->intSubset->SystemID != NULL) { 		VERROR(ctxt->userData,  7 		       "Could not load the external subset \"%s\"\n", # 		       doc->intSubset->SystemID); 
 	    } else {  		VERROR(ctxt->userData,  7 		       "Could not load the external subset \"%s\"\n", % 		       doc->intSubset->ExternalID);  	    } 	    return(0);  	}     }   )     ret = xmlValidateDtdFinal(ctxt, doc); /     if (!xmlValidateRoot(ctxt, doc)) return(0);   %     root = xmlDocGetRootElement(doc); /     ret &= xmlValidateElement(ctxt, doc, root); /     ret &= xmlValidateDocumentFinal(ctxt, doc);      return(ret); }     I /************************************************************************   *									*/  *		Routines for dynamic validation editing			*   *									*J  ************************************************************************/   /**    * xmlValidGetPotentialChildren:#  * @ctree:  an element content tree 4  * @list:  an array to store the list of child names8  * @len:  a pointer to the number of element in the list  * @max:  the size of the array   *I  * Build/extend a list of  potential children allowed by the content tree   *E  * returns the number of element in the list, or -1 in case of error.   */    int L xmlValidGetPotentialChildren(xmlElementContent *ctree, const xmlChar **list,1                              int *len, int max) { 
     int i;  ;     if ((ctree == NULL) || (list == NULL) || (len == NULL))          return(-1); "     if (*len >= max) return(*len);       switch (ctree->type) {" 	case XML_ELEMENT_CONTENT_PCDATA:  	    for (i = 0; i < *len;i++)= 		if (xmlStrEqual(BAD_CAST "#PCDATA", list[i])) return(*len); ) 	    list[(*len)++] = BAD_CAST "#PCDATA";  	    break; # 	case XML_ELEMENT_CONTENT_ELEMENT:   	    for (i = 0; i < *len;i++)6 		if (xmlStrEqual(ctree->name, list[i])) return(*len);" 	    list[(*len)++] = ctree->name; 	    break;  	case XML_ELEMENT_CONTENT_SEQ:  = 	    xmlValidGetPotentialChildren(ctree->c1, list, len, max); = 	    xmlValidGetPotentialChildren(ctree->c2, list, len, max);  	    break;  	case XML_ELEMENT_CONTENT_OR: = 	    xmlValidGetPotentialChildren(ctree->c1, list, len, max); = 	    xmlValidGetPotentialChildren(ctree->c2, list, len, max);  	    break;     }         return(*len); }    /**   * xmlValidGetValidElements:%  * @prev:  an element to insert after $  * @next:  an element to insert next4  * @list:  an array to store the list of child names  * @max:  the size of the array   *B  * This function returns the list of authorized children to insertD  * within an existing tree while respecting the validity constraintsD  * forced by the Dtd. The insertion point is defined using @prev and  * @next in the following ways: K  *  to insert before 'node': xmlValidGetValidElements(node->prev, node, ... I  *  to insert next 'node': xmlValidGetValidElements(node, node->next, ... K  *  to replace 'node': xmlValidGetValidElements(node->prev, node->next, ... N  *  to prepend a child to 'node': xmlValidGetValidElements(NULL, node->childs,O  *  to append a child to 'node': xmlValidGetValidElements(node->last, NULL, ...   *K  * pointers to the element names are inserted at the beginning of the array   * and do not need to be freed.   *H  * returns the number of element in the list, or -1 in case of error. IfK  *    the function returns the value @max the caller is invited to grow the    *    receiving array and retry.  */    int L xmlValidGetValidElements(xmlNode *prev, xmlNode *next, const xmlChar **list,#                          int max) {      int nb_valid_elements = 0;!     const xmlChar *elements[256];      int nb_elements = 0, i;           xmlNode *ref_node;     xmlNode *parent;     xmlNode *test_node;           xmlNode *prev_next;      xmlNode *next_prev;      xmlNode *parent_childs;      xmlNode *parent_last;           xmlElement *element_desc;   %     if (prev == NULL && next == NULL)          return(-1);   !     if (list == NULL) return(-1);      if (max <= 0) return(-1);        nb_valid_elements = 0;"     ref_node = prev ? prev : next;     parent = ref_node->parent;       /*/      * Retrieves the parent element declaration       */ ?     element_desc = xmlGetDtdElementDesc(parent->doc->intSubset, 7                                          parent->name); C     if ((element_desc == NULL) && (parent->doc->extSubset != NULL)) C         element_desc = xmlGetDtdElementDesc(parent->doc->extSubset, ;                                              parent->name); )     if (element_desc == NULL) return(-1);  	      /*0      * Do a backup of the current tree structure      */ )     prev_next = prev ? prev->next : NULL; )     next_prev = next ? next->prev : NULL; %     parent_childs = parent->children;      parent_last = parent->last;        /*7      * Creates a dummy node and insert it into the tree       */     8     test_node = xmlNewNode (NULL, BAD_CAST "<!dummy?>");#     test_node->doc = ref_node->doc;      test_node->parent = parent;      test_node->prev = prev;      test_node->next = next;      %     if (prev) prev->next = test_node; &     else parent->children = test_node; 		%     if (next) next->prev = test_node; "     else parent->last = test_node;       /*B      * Insert each potential child node and check if the parent is      * still valid      */ E     nb_elements = xmlValidGetPotentialChildren(element_desc->content, & 		       elements, &nb_elements, 256);     %     for (i = 0;i < nb_elements;i++) {  	test_node->name = elements[i]; 8 	if (xmlValidateOneElement(NULL, parent->doc, parent)) { 	    int j;   + 	    for (j = 0; j < nb_valid_elements;j++) / 		if (xmlStrEqual(elements[i], list[j])) break; - 	    list[nb_valid_elements++] = elements[i]; ) 	    if (nb_valid_elements >= max) break;  	}     }        /*!      * Restore the tree structure       */ %     if (prev) prev->next = prev_next; %     if (next) next->prev = next_prev; %     parent->children = parent_childs;      parent->last = parent_last;           return(nb_valid_elements); } 