 /*H  * parser.h : Interfaces, constants and types related to the XML parser.  *1  * See Copyright for the status of this software.   *  * Daniel.Veillard@w3.org   */    #ifndef __XML_PARSER_H__ #define __XML_PARSER_H__   #include <libxml/tree.h> #include <libxml/valid.h>  #include <libxml/xmlIO.h>  #include <libxml/entities.h>     #ifdef __cplusplus extern "C" { #endif   /*
  * Constants.   */ ! #define XML_DEFAULT_VERSION	"1.0"    /** <  * an xmlParserInput is an input flow for the XML processor.A  * Each entity parsed is associated an xmlParserInput (except the D  * few predefined ones). This is the case both for internal entities@  * - in which case the flow is already completely in memory - orA  * external entities - in which case we use the buf structure for I  * progressive reading and I18N conversions to the internal UTF-8 format.   */   5 typedef void (* xmlParserInputDeallocate)(xmlChar *); . typedef struct _xmlParserInput xmlParserInput;* typedef xmlParserInput *xmlParserInputPtr; struct _xmlParserInput {     /* Input buffer */@     xmlParserInputBufferPtr buf;      /* UTF-8 encoded buffer */  E     const char *filename;             /* The file analyzed, if any */ J     const char *directory;            /* the directory/base of teh file */F     const xmlChar *base;              /* Base of the array to parse */E     const xmlChar *cur;               /* Current char being parsed */ ;     int length;                       /* length if known */ 8     int line;                         /* Current line */:     int col;                          /* Current column */N     int consumed;                     /* How many xmlChars already consumed */K     xmlParserInputDeallocate free;    /* function to deallocate the base */ J     const xmlChar *encoding;          /* the encoding string for entity */I     const xmlChar *version;           /* the version string for entity */ M     int standalone;                   /* Was that entity marked standalone */  };   /** E  * the parser can be asked to collect Node informations, i.e. at what )  * place in the file they were detected.  9  * NOTE: This is off by default and not very well tested.   */ 4 typedef struct _xmlParserNodeInfo xmlParserNodeInfo;0 typedef xmlParserNodeInfo *xmlParserNodeInfoPtr;   struct _xmlParserNodeInfo {    const struct _xmlNode* node;J   /* Position & line # that text that created the node begins & ends on */   unsigned long begin_pos;   unsigned long begin_line;    unsigned long end_pos;   unsigned long end_line;  };  : typedef struct _xmlParserNodeInfoSeq xmlParserNodeInfoSeq;6 typedef xmlParserNodeInfoSeq *xmlParserNodeInfoSeqPtr; struct _xmlParserNodeInfoSeq {   unsigned long maximum;   unsigned long length;    xmlParserNodeInfo* buffer; };   /** 9  * The parser is now working also as a state based parser @  * The recursive one use the stagte info for entities processing  */  typedef enum {6     XML_PARSER_EOF = -1,	/* nothing is to be parsed */7     XML_PARSER_START = 0,	/* nothing has been parsed */ 3     XML_PARSER_MISC,		/* Misc* before int subset */ :     XML_PARSER_PI,		/* Whithin a processing instruction */2     XML_PARSER_DTD,		/* within some DTD content */9     XML_PARSER_PROLOG,		/* Misc* after internal subset */ /     XML_PARSER_COMMENT,		/* within a comment */ 2     XML_PARSER_START_TAG,	/* within a start tag */1     XML_PARSER_CONTENT,		/* within the content */ :     XML_PARSER_CDATA_SECTION,	/* within a CDATA section */3     XML_PARSER_END_TAG,		/* within a closing tag */ >     XML_PARSER_ENTITY_DECL,	/* within an entity declaration */C     XML_PARSER_ENTITY_VALUE,	/* within an entity value in a decl */ ?     XML_PARSER_ATTRIBUTE_VALUE,	/* within an attribute value */ :     XML_PARSER_SYSTEM_LITERAL,	/* within a SYSTEM value */>     XML_PARSER_EPILOG 		/* the Misc* after the last end tag */ } xmlParserInputState;   /**   * The parser context.I  * NOTE This doesn't completely defines the parser state, the (current ?) K  *      design of the parser uses recursive function calls since this allow G  *      and easy mapping from the production rules of the specification I  *      to the actual code. The drawback is that the actual function call K  *      also reflect the parser state. However most of the parsing routines K  *      takes as the only argument the parser context pointer, so migrating N  *      to a state based parser for progressive parsing shouldn't be too hard.  */ , typedef struct _xmlParserCtxt xmlParserCtxt;( typedef xmlParserCtxt *xmlParserCtxtPtr; struct _xmlParserCtxt { ;     struct _xmlSAXHandler *sax;       /* The SAX handler */ U     void            *userData;        /* For SAX interface only, used by DOM build */ D     xmlDocPtr           myDoc;        /* the document being built */G     int            wellFormed;        /* is the document well formed */ G     int       replaceEntities;        /* shall we replace entities ? */ B     const xmlChar    *version;        /* the XML version string */I     const xmlChar   *encoding;        /* the declared encoding, if any */ ?     int            standalone;        /* standalone document */ J     int                  html;        /* an HTML(1)/Docbook(2) document */       /* Input stream stack */@     xmlParserInputPtr  input;         /* Current input stream */K     int                inputNr;       /* Number of current input streams */ G     int                inputMax;      /* Max number of input streams */ ;     xmlParserInputPtr *inputTab;      /* stack of inputs */   8     /* Node analysis stack only used for DOM building */?     xmlNodePtr         node;          /* Current parsed Node */ F     int                nodeNr;        /* Depth of the parsing stack */J     int                nodeMax;       /* Max depth of the parsing stack */:     xmlNodePtr        *nodeTab;       /* array of nodes */  L     int record_info;                  /* Whether node info should be kept */G     xmlParserNodeInfoSeq node_seq;    /* info about each node parsed */   6     int errNo;                        /* error code */  I     int     hasExternalSubset;        /* reference and external subset */ K     int             hasPErefs;        /* the internal subset has PE refs */ M     int              external;        /* are we parsing an external entity */   A     int                 valid;        /* is the document valid */ F     int              validate;        /* shall we try to validate ? */@     xmlValidCtxt        vctxt;        /* The validity context */  A     xmlParserInputState instate;      /* current type of input */ D     int                 token;        /* next char look-ahead */      >     char           *directory;        /* the data directory */       /* Node name stack */ ?     xmlChar           *name;          /* Current parsed Node */ F     int                nameNr;        /* Depth of the parsing stack */J     int                nameMax;       /* Max depth of the parsing stack */:     xmlChar *         *nameTab;       /* array of nodes */  G     long               nbChars;       /* number of xmlChar processed */ N     long            checkIndex;       /* used by progressive parsing lookup */8     int             keepBlanks;       /* ugly but ... */F     int             disableSAX;       /* SAX callbacks are disabled */L     int               inSubset;       /* Parsing is in int 1/ext 2 subset */:     xmlChar *          intSubName;    /* name of subset */B     xmlChar *          extSubURI;     /* URI of external subset */H     xmlChar *          extSubSystem;  /* SYSTEM ID of external subset */       /* xml:space values */M     int *              space;         /* Should the parser preserve spaces */ F     int                spaceNr;       /* Depth of the parsing stack */J     int                spaceMax;      /* Max depth of the parsing stack */@     int *              spaceTab;      /* array of space infos */  P     int                depth;         /* to prevent entity substitution loops */M     xmlParserInputPtr  entity;        /* used to check entities boundaries */ J     int                charset;       /* encoding of the in-memory content+ 				         actually an xmlCharEncoding */ I     int                nodelen;       /* Those two fields are there to */ G     int                nodemem;       /* Speed up large node parsing */ D     int                pedantic;      /* signal pedantic warnings */P     void              *_private;      /* For user data, libxml won't touch it */ };   /**   * a SAX Locator.   */ , typedef struct _xmlSAXLocator xmlSAXLocator;( typedef xmlSAXLocator *xmlSAXLocatorPtr; struct _xmlSAXLocator { -     const xmlChar *(*getPublicId)(void *ctx); -     const xmlChar *(*getSystemId)(void *ctx); $     int (*getLineNumber)(void *ctx);&     int (*getColumnNumber)(void *ctx); };   /** K  * a SAX handler is bunch of callbacks called by the parser when processing 8  * of the input generate data or structure informations.  */   = typedef xmlParserInputPtr (*resolveEntitySAXFunc) (void *ctx, 9 			    const xmlChar *publicId, const xmlChar *systemId); F typedef void (*internalSubsetSAXFunc) (void *ctx, const xmlChar *name,P                             const xmlChar *ExternalID, const xmlChar *SystemID);F typedef void (*externalSubsetSAXFunc) (void *ctx, const xmlChar *name,P                             const xmlChar *ExternalID, const xmlChar *SystemID);4 typedef xmlEntityPtr (*getEntitySAXFunc) (void *ctx,1                             const xmlChar *name); = typedef xmlEntityPtr (*getParameterEntitySAXFunc) (void *ctx, 1                             const xmlChar *name); - typedef void (*entityDeclSAXFunc) (void *ctx, S                             const xmlChar *name, int type, const xmlChar *publicId, 2 			    const xmlChar *systemId, xmlChar *content);C typedef void (*notationDeclSAXFunc)(void *ctx, const xmlChar *name, 9 			    const xmlChar *publicId, const xmlChar *systemId); D typedef void (*attributeDeclSAXFunc)(void *ctx, const xmlChar *elem,C                             const xmlChar *name, int type, int def, < 			    const xmlChar *defaultValue, xmlEnumerationPtr tree);B typedef void (*elementDeclSAXFunc)(void *ctx, const xmlChar *name,/ 			    int type, xmlElementContentPtr content); 4 typedef void (*unparsedEntityDeclSAXFunc)(void *ctx,I                             const xmlChar *name, const xmlChar *publicId, = 			    const xmlChar *systemId, const xmlChar *notationName); 5 typedef void (*setDocumentLocatorSAXFunc) (void *ctx, 2                             xmlSAXLocatorPtr loc);1 typedef void (*startDocumentSAXFunc) (void *ctx); / typedef void (*endDocumentSAXFunc) (void *ctx); D typedef void (*startElementSAXFunc) (void *ctx, const xmlChar *name,2                             const xmlChar **atts);C typedef void (*endElementSAXFunc) (void *ctx, const xmlChar *name); A typedef void (*attributeSAXFunc) (void *ctx, const xmlChar *name, 8                                   const xmlChar *value);B typedef void (*referenceSAXFunc) (void *ctx, const xmlChar *name);@ typedef void (*charactersSAXFunc) (void *ctx, const xmlChar *ch, 		            int len); 6 typedef void (*ignorableWhitespaceSAXFunc) (void *ctx,# 			    const xmlChar *ch, int len); 8 typedef void (*processingInstructionSAXFunc) (void *ctx,H                             const xmlChar *target, const xmlChar *data);A typedef void (*commentSAXFunc) (void *ctx, const xmlChar *value); M typedef void (*cdataBlockSAXFunc) (void *ctx, const xmlChar *value, int len); A typedef void (*warningSAXFunc) (void *ctx, const char *msg, ...); ? typedef void (*errorSAXFunc) (void *ctx, const char *msg, ...); D typedef void (*fatalErrorSAXFunc) (void *ctx, const char *msg, ...);/ typedef int (*isStandaloneSAXFunc) (void *ctx); 4 typedef int (*hasInternalSubsetSAXFunc) (void *ctx);4 typedef int (*hasExternalSubsetSAXFunc) (void *ctx);  , typedef struct _xmlSAXHandler xmlSAXHandler;( typedef xmlSAXHandler *xmlSAXHandlerPtr; struct _xmlSAXHandler { )     internalSubsetSAXFunc internalSubset; %     isStandaloneSAXFunc isStandalone; /     hasInternalSubsetSAXFunc hasInternalSubset; /     hasExternalSubsetSAXFunc hasExternalSubset; '     resolveEntitySAXFunc resolveEntity;      getEntitySAXFunc getEntity; !     entityDeclSAXFunc entityDecl; %     notationDeclSAXFunc notationDecl; '     attributeDeclSAXFunc attributeDecl; #     elementDeclSAXFunc elementDecl; 1     unparsedEntityDeclSAXFunc unparsedEntityDecl; 1     setDocumentLocatorSAXFunc setDocumentLocator; '     startDocumentSAXFunc startDocument; #     endDocumentSAXFunc endDocument; %     startElementSAXFunc startElement; !     endElementSAXFunc endElement;      referenceSAXFunc reference; !     charactersSAXFunc characters; 3     ignorableWhitespaceSAXFunc ignorableWhitespace; 7     processingInstructionSAXFunc processingInstruction;      commentSAXFunc comment;      warningSAXFunc warning;      errorSAXFunc error; !     fatalErrorSAXFunc fatalError; 1     getParameterEntitySAXFunc getParameterEntity; !     cdataBlockSAXFunc cdataBlock; )     externalSubsetSAXFunc externalSubset;  };   /**    * External entity loaders types  */ E typedef xmlParserInputPtr (*xmlExternalEntityLoader)(const char *URL,  						     const char *ID,% 						     xmlParserCtxtPtr context);    /** B  * Global variables: just the default SAX interface tables and XML  * version infos.   */ $ extern const char *xmlParserVersion;  * extern xmlSAXLocator xmlDefaultSAXLocator;* extern xmlSAXHandler xmlDefaultSAXHandler;+ extern xmlSAXHandler htmlDefaultSAXHandler; + extern xmlSAXHandler sgmlDefaultSAXHandler;    /** )  * entity substitution default behaviour.   */   - extern int xmlSubstituteEntitiesDefaultValue; & extern int xmlGetWarningsDefaultValue;     /**   * Init/Cleanup   */  void		xmlInitParser		(void); void		xmlCleanupParser	(void);   /**   * Input functions  */ . int		xmlParserInputRead	(xmlParserInputPtr in, 					 int len); . int		xmlParserInputGrow	(xmlParserInputPtr in, 					 int len);    /**   * xmlChar handling   */ * xmlChar *	xmlStrdup		(const xmlChar *cur);* xmlChar *	xmlStrndup		(const xmlChar *cur, 					 int len); ) xmlChar *	xmlStrsub		(const xmlChar *str,  					 int start, 					 int len); / const xmlChar *	xmlStrchr		(const xmlChar *str,  					 xmlChar val); / const xmlChar *	xmlStrstr		(const xmlChar *str,  					 xmlChar *val);3 const xmlChar *	xmlStrcasestr		(const xmlChar *str,  					 xmlChar *val);% int		xmlStrcmp		(const xmlChar *str1,  					 const xmlChar *str2); & int		xmlStrncmp		(const xmlChar *str1, 					 const xmlChar *str2, 					 int len); ) int		xmlStrcasecmp		(const xmlChar *str1,  					 const xmlChar *str2); * int		xmlStrncasecmp		(const xmlChar *str1, 					 const xmlChar *str2, 					 int len); ' int		xmlStrEqual		(const xmlChar *str1,  					 const xmlChar *str2); % int		xmlStrlen		(const xmlChar *str); # xmlChar *	xmlStrcat		(xmlChar *cur,  					 const xmlChar *add);$ xmlChar *	xmlStrncat		(xmlChar *cur, 					 const xmlChar *add,  					 int len);    /**   * Basic parsing Interfaces   */ & xmlDocPtr	xmlParseDoc		(xmlChar *cur);( xmlDocPtr	xmlParseMemory		(char *buffer, 					 int size);/ xmlDocPtr	xmlParseFile		(const char *filename); + int		xmlSubstituteEntitiesDefault(int val); $ int		xmlKeepBlanksDefault	(int val);- void		xmlStopParser		(xmlParserCtxtPtr ctxt); ' int		xmlPedanticParserDefault(int val);    /**   * Recovery mode    */ ( xmlDocPtr	xmlRecoverDoc		(xmlChar *cur);) xmlDocPtr	xmlRecoverMemory	(char *buffer,  					 int size);1 xmlDocPtr	xmlRecoverFile		(const char *filename);    /** *  * Less common routines and SAX interfaces  */ . int		xmlParseDocument	(xmlParserCtxtPtr ctxt);2 int		xmlParseExtParsedEnt	(xmlParserCtxtPtr ctxt);0 xmlDocPtr	xmlSAXParseDoc		(xmlSAXHandlerPtr sax, 					 xmlChar *cur,  					 int recovery);/ int		xmlSAXUserParseFile	(xmlSAXHandlerPtr sax,  					 void *user_data, 					 const char *filename);1 int		xmlSAXUserParseMemory	(xmlSAXHandlerPtr sax,  					 void *user_data, 					 char *buffer,  					 int size);2 xmlDocPtr	xmlSAXParseMemory	(xmlSAXHandlerPtr sax, 					 char *buffer, .                                    	 int size, 					 int recovery);1 xmlDocPtr	xmlSAXParseFile		(xmlSAXHandlerPtr sax,  					 const char *filename,  					 int recovery);2 xmlDocPtr	xmlSAXParseEntity	(xmlSAXHandlerPtr sax, 					 const char *filename);1 xmlDocPtr	xmlParseEntity		(const char *filename); 2 xmlDtdPtr	xmlParseDTD		(const xmlChar *ExternalID, 					 const xmlChar *SystemID); 0 xmlDtdPtr	xmlSAXParseDTD		(xmlSAXHandlerPtr sax,  					 const xmlChar *ExternalID, 					 const xmlChar *SystemID); / int		xmlParseBalancedChunkMemory(xmlDocPtr doc,  					 xmlSAXHandlerPtr sax,  					 void *user_data, 					 int depth, 					 const xmlChar *string, 					 xmlNodePtr *list);+ int		xmlParseExternalEntity	(xmlDocPtr doc,  					 xmlSAXHandlerPtr sax,  					 void *user_data, 					 int depth, 					 const xmlChar *URL,  					 const xmlChar *ID, 					 xmlNodePtr *list);5 int		xmlParseCtxtExternalEntity(xmlParserCtxtPtr ctx,  					 const xmlChar *URL,  					 const xmlChar *ID, 					 xmlNodePtr *list);   /**   * SAX initialization routines  */ % void		xmlDefaultSAXHandlerInit(void); & void		htmlDefaultSAXHandlerInit(void);   /**   * Parser contexts handling.  */ 0 void		xmlInitParserCtxt	(xmlParserCtxtPtr ctxt);1 void		xmlClearParserCtxt	(xmlParserCtxtPtr ctxt); 0 void		xmlFreeParserCtxt	(xmlParserCtxtPtr ctxt);5 void		xmlSetupParserForBuffer	(xmlParserCtxtPtr ctxt,  					 const xmlChar* buffer, 					 const char* filename);7 xmlParserCtxtPtr xmlCreateDocParserCtxt	(xmlChar *cur);    /** -  * Reading/setting optional parsing features.   */   " int		xmlGetFeaturesList	(int *len, 					 const char **result); + int		xmlGetFeature		(xmlParserCtxtPtr ctxt,  					 const char *name,  					 void *result);+ int		xmlSetFeature		(xmlParserCtxtPtr ctxt,  					 const char *name,  					 void *value);    /**   * Interfaces for the Push mode   */ > xmlParserCtxtPtr xmlCreatePushParserCtxt(xmlSAXHandlerPtr sax, 					 void *user_data, 					 const char *chunk, 					 int size,  					 const char *filename);, int		 xmlParseChunk		(xmlParserCtxtPtr ctxt, 					 const char *chunk, 					 int size,  					 int terminate);    /**   * Special I/O mode   */   = xmlParserCtxtPtr xmlCreateIOParserCtxt	(xmlSAXHandlerPtr sax,  					 void *user_data,$ 					 xmlInputReadCallback   ioread,% 					 xmlInputCloseCallback  ioclose,  					 void *ioctx, 					 xmlCharEncoding enc);   = xmlParserInputPtr xmlNewIOInputStream	(xmlParserCtxtPtr ctxt, $ 					 xmlParserInputBufferPtr input, 					 xmlCharEncoding enc);    /** 
  * Node infos   */  const xmlParserNodeInfo*3 		xmlParserFindNodeInfo	(const xmlParserCtxt* ctxt, D                                                const xmlNode* node);7 void		xmlInitNodeInfoSeq	(xmlParserNodeInfoSeqPtr seq); 8 void		xmlClearNodeInfoSeq	(xmlParserNodeInfoSeqPtr seq);I unsigned long xmlParserFindNodeInfoIndex(const xmlParserNodeInfoSeq* seq, >                                          const xmlNode* node);2 void		xmlParserAddNodeInfo	(xmlParserCtxtPtr ctxt,% 					 const xmlParserNodeInfo* info);    /*;  * External entities handling actually implemented in xmlIO   */   < void		xmlSetExternalEntityLoader(xmlExternalEntityLoader f); xmlExternalEntityLoader # 		xmlGetExternalEntityLoader(void);  xmlParserInputPtr ) 		xmlLoadExternalEntity	(const char *URL,  					 const char *ID,   					 xmlParserCtxtPtr context);   #ifdef __cplusplus }  #endif   #endif /* __XML_PARSER_H__ */   