 /*:  * xpath.c: interface for XML Path Language implementation  *+  * Reference: W3C Working Draft 5 July 1999 K  *            http://www.w3.org/Style/XSL/Group/1999/07/xpath-19990705.html   *0  * See COPYRIGHT for the status of this software  *!  * Author: Daniel.Veillard@w3.org   */    #ifndef __XML_XPATH_H__  #define __XML_XPATH_H__    #include <libxml/tree.h>   #ifdef __cplusplus extern "C" { #endif  0 typedef struct _xmlXPathContext xmlXPathContext;, typedef xmlXPathContext *xmlXPathContextPtr;< typedef struct _xmlXPathParserContext xmlXPathParserContext;8 typedef xmlXPathParserContext *xmlXPathParserContextPtr;   /*D  * A node-set (an unordered collection of nodes without duplicates)   */ & typedef struct _xmlNodeSet xmlNodeSet;" typedef xmlNodeSet *xmlNodeSetPtr; struct _xmlNodeSet {2     int nodeNr;			/* number of nodes in the set */6     int nodeMax;		/* size of the array as allocated */D     xmlNodePtr *nodeTab;	/* array of nodes in no particular order */ };   /*7  * An expression is evaluated to yield an object, which -  * has one of the following four basic types:   *   - node-set   *   - boolean
  *   - number 
  *   - string   *$  * @@ XPointer will add more types !  */    typedef enum {     XPATH_UNDEFINED = 0,     XPATH_NODESET = 1,     XPATH_BOOLEAN = 2,     XPATH_NUMBER = 3,      XPATH_STRING = 4,      XPATH_USERS = 5  } xmlXPathObjectType;   . typedef struct _xmlXPathObject xmlXPathObject;* typedef xmlXPathObject *xmlXPathObjectPtr; struct _xmlXPathObject {     xmlXPathObjectType type;     xmlNodeSetPtr nodesetval;      int boolval;     double floatval;     xmlChar *stringval;      void *user;  };   /*A  * A conversion function is associated to a type and used to cast $  * the new type to primitive values.  */ E typedef int (*xmlXPathConvertFunc) (xmlXPathObjectPtr obj, int type);    /*0  * Extra type: a name and a conversion function.  */   * typedef struct _xmlXPathType xmlXPathType;& typedef xmlXPathType *xmlXPathTypePtr; struct _xmlXPathType {5     const xmlChar         *name;		/* the type name */ <     xmlXPathConvertFunc func;		/* the conversion function */ };   /*&  * Extra variable: a name and a value.  */   2 typedef struct _xmlXPathVariable xmlXPathVariable;. typedef xmlXPathVariable *xmlXPathVariablePtr; struct _xmlXPathVariable {7     const xmlChar       *name;		/* the variable name */ -     xmlXPathObjectPtr value;		/* the value */  };   /*B  * an evaluation function, the parameters are on the context stack  */   K typedef void (*xmlXPathEvalFunc)(xmlXPathParserContextPtr ctxt, int nargs);    /*4  * Extra function: a name and a evaluation function.  */   , typedef struct _xmlXPathFunct xmlXPathFunct;' typedef xmlXPathFunct *xmlXPathFuncPtr;  struct _xmlXPathFunct { 6     const xmlChar      *name;		/* the function name */9     xmlXPathEvalFunc func;		/* the evaluation function */  };   /*D  * An axis traversal function. To traverse an axis, the engine callsH  * the first time with cur == NULL and repeat until the function returns1  * NULL indicating the end of the axis traversal.   */   M typedef xmlXPathObjectPtr (*xmlXPathAxisFunc)	(xmlXPathParserContextPtr ctxt,  						 xmlXPathObjectPtr cur);   /*+  * Extra axis: a name and an axis function.   */   * typedef struct _xmlXPathAxis xmlXPathAxis;& typedef xmlXPathAxis *xmlXPathAxisPtr; struct _xmlXPathAxis {2     const xmlChar      *name;		/* the axis name */5     xmlXPathAxisFunc func;		/* the search function */  };   /*  :  * Expression evaluation occurs with respect to a context.  * he context consists of:"  *    - a node (the context node) ,  *    - a node list (the context node list) #  *    - a set of variable bindings    *    - a function library  F  *    - the set of namespace declarations in scope for the expression   */    struct _xmlXPathContext { /     xmlDocPtr doc;			/* The current document */ -     xmlNodePtr node;			/* The current node */ 8     xmlNodeSetPtr nodelist;		/* The current node list */  9     int nb_variables;			/* number of defined variables */ 6     int max_variables;			/* max number of variables */D     xmlXPathVariablePtr *variables;	/* Array of defined variables */  1     int nb_types;			/* number of defined types */ .     int max_types;			/* max number of types */9     xmlXPathTypePtr *types;		/* Array of defined types */   1     int nb_funcs;			/* number of defined funcs */ .     int max_funcs;			/* max number of funcs */9     xmlXPathFuncPtr *funcs;		/* Array of defined funcs */   /     int nb_axis;			/* number of defined axis */ ,     int max_axis;			/* max number of axis */7     xmlXPathAxisPtr *axis;		/* Array of defined axis */   =     /* Namespace traversal should be implemented with user */ 6     xmlNsPtr *namespaces;		/* The namespaces lookup */2     int nsNr;				/* the current Namespace index */0     void *user;				/* user defined extra info */       /* extra variables */ -     int contextSize;			/* the context size */ 8     int proximityPosition;		/* the proximity position */ };   /*B  * An XPath parser context, it contains pure parsing informations,0  * an xmlXPathContext, and the stack of objects.  */  struct _xmlXPathParserContext { =     const xmlChar *cur;			/* the current char being parsed */ 4     const xmlChar *base;			/* the full expression */  "     int error;				/* error code */  =     xmlXPathContextPtr  context;	/* the evaluation context */ 8     xmlXPathObjectPtr     value;	/* the current value */?     int                 valueNr;	/* number of values stacked */ C     int                valueMax;	/* max number of values stacked */ 6     xmlXPathObjectPtr *valueTab;	/* stack of values */ };   /*  * An XPath function=  * The arguments (if any) are popped out of the context stack )  * and the result is pushed on the stack.   */   L typedef void (*xmlXPathFunction) (xmlXPathParserContextPtr ctxt, int nargs);  I /************************************************************************   *									*  *			Public API					*   *									*J  ************************************************************************/   /** 4  * Registering extensions to the expression language  */ A /* TODO */ int	   xmlXPathRegisterType		(xmlXPathContextPtr ctxt,  						 const xmlChar *name, H                                                  xmlXPathConvertFunc f);A /* TODO */ int	   xmlXPathRegisterAxis		(xmlXPathContextPtr ctxt,  						 const xmlChar *name,  						 xmlXPathAxisFunc f); A /* TODO */ int	   xmlXPathRegisterFunc		(xmlXPathContextPtr ctxt,  						 const xmlChar *name,  						 xmlXPathFunction f); D /* TODO */ int	   xmlXPathRegisterVariable	(xmlXPathContextPtr ctxt, 						 const xmlChar *name,  						 xmlXPathObject value);    /**   * Evaluation functions.  */ 7 xmlXPathContextPtr xmlXPathNewContext		(xmlDocPtr doc); 8 void		   xmlXPathFreeContext		(xmlXPathContextPtr ctxt);6 xmlXPathObjectPtr  xmlXPathEval			(const xmlChar *str,  						 xmlXPathContextPtr ctxt);5 void		   xmlXPathFreeObject		(xmlXPathObjectPtr obj); > xmlXPathObjectPtr  xmlXPathEvalExpression	(const xmlChar *str,  						 xmlXPathContextPtr ctxt);8 xmlNodeSetPtr	   xmlXPathNodeSetCreate	(xmlNodePtr val);9 void		   xmlXPathFreeNodeSetList	(xmlXPathObjectPtr obj); 2 void		   xmlXPathFreeNodeSet		(xmlNodeSetPtr obj);   #ifdef __cplusplus }  #endif #endif /* ! __XML_XPATH_H__ */