$! RCM_START.COM V4.0-507SP4a  Generation: 736  30-APR-2002 16:43:39.67  !!!!>
$ SET SYMBOL/SCOPE=(NOLOCAL,NOGLOBAL)                                    !!!!>
$ rcm_ver = "V4.0-507SP4a"                                               !!!!>
$!
$! RCM_START.COM 		   Pat Moran	2-Feb-2000
$!*****************************************************************************
$!
$ set noon
$ on control_y then goto finish_up
$ on control_c then goto finish_up
$ set noverify
$ set default []   ! makes sure directory spec does not have <,>
$ curdir = f$environment("default")
$ if f$trnlnm("RCM$DATA") .eqs. ""
$ then
$    coll_dir = f$environment("default")
$    rdev = f$getdvi(f$parse(coll_dir,,,"device"),"logvolnam")
$    rdir = f$parse(coll_dir,,,"directory","no_conceal") - "]["
$    rdata = rdev + ":" + rdir
$    define/system/nolog RCM$DATA 'rdata'
$ endif
$ rcmdata = f$trnlnm("RCM$DATA")
$ curdirdev = F$PARSE(curdir,,,"DEVICE")
$ curdirdev = f$getdvi(curdirdev, "LOGVOLNAM") +":"
$ curdirdir = F$PARSE(curdir,,,"DIRECTORY","NO_CONCEAL")
$ rcmdatadev = F$PARSE(rcmdata,,,"DEVICE")
$ rcmdatadev = f$getdvi(rcmdatadev, "LOGVOLNAM") +":"
$ rcmdatadir = F$PARSE(rcmdata,,,"DIRECTORY","NO_CONCEAL")
$ installnode = f$trnlnm("RCM$NODE")
$ if installnode .eqs. "" then installnode = f$getsyi("nodename")
$!
$ if (curdirdev .nes. rcmdatadev) .or. (curdirdir .nes. rcmdatadir) 
$ then 
$    set default RCM$DATA
$    write sys$output ""
$    write sys$output "Changed default directory to RCM$DATA: (''rcmdata')"
$    write sys$output ""
$ endif
$ models = " 1200 4000 4100 4X00 8200 8400 GS60 GS60E GS140 "
$ alpha = f$getsyi("HW_MODEL").ge.1024
$ thisnode = f$getsyi("NODENAME")
$ open/write/error=error_1 rcm_log RCM$DATA:RCM_START_'thisnode'.LOG
$!
$ write rcm_log "p1 = ''p1', p2 = ''p2'"
$ if f$type(bld_num) .eqs. "" then bld_num = "Unknown"
$!
$ if f$mode() .eqs. "INTERACTIVE"
$ then
$   write sys$output ""                                                                             
$   write sys$output "               RCM Data Collector ''rcm_ver' for OpenVMS"
$   write sys$output ""            
$   write sys$output "       Copyright 2001 Compaq Information Technologies Group, L.P."
$   write sys$output ""                                                                             
$ endif
$!
$ gosub setup_variables
$ gosub check_for_rcmprocess
$ if f$mode() .nes. "INTERACTIVE" then gosub get_cfg_file 
$ gosub check_cpu_model
$ gosub check_privs
$ gosub check_config_file
$ gosub read_config_file
$ if node_string .eqs. "" then gosub get_nodes 
$ if f$edit(p2, "upcase") .eqs. "-THISNODE" then node_string = thisnode
$ gosub make_zip_name
$ if f$mode() .eqs. "INTERACTIVE" 
$ then 
$   gosub create_home_file  
$   gosub create_decevent_com        		  
$ endif
$ if f$edit(p2, "UPCASE") .eqs. "-SETUP" 
$ then 
$      write sys$output "Edit RCM$DATA:''thisnode'.CFG if you want to change any options." 
$      write sys$output ""
$      gosub create_rcm_run        	  	  
$ endif
$ gosub create_sysman_file        	  	  
$ gosub check_for_frequency
$!
$ if f$edit(p1, "UPCASE") .eqs. "-NOW" 
$ then 
$   freq = ""
$ else
$   gosub schedule_collections
$ endif
$ if f$edit(p2, "UPCASE") .eqs. "-SETUP" then goto finish_up
$!
$ prcn = f$getjpi("", "prcnam")
$ if f$mode() .nes. "INTERACTIVE" .and. prcn .eqs. "RCM1" 
$ then 
$   	gosub run_now 	     !don't start if rebooting!!
$   	goto finish_up
$ endif
$ if f$mode() .nes. "INTERACTIVE" .and. run_on_reboot .eqs. "Y" 
$ then 
$   	gosub run_now   !unless run_on_reboot flag set
$   	goto finish_up
$ endif
$ if f$mode() .eqs. "INTERACTIVE"
$ then
$   	run_on_reboot = "N"  !for interactive, this must be N
$   	if passed .eq. 1
$   	then
$      		gosub run_now
$   	else
$      		if freq .eqs. "" .and. f$edit(p1, "UPCASE") .eqs. "-NOW" then gosub run_now
$   	endif
$ else
$      	if f$edit(p1, "UPCASE") .eqs. "-NOW" then gosub run_now
$ endif
$!
$ finish_up:
$ if f$search("rcmp.tmp") .nes. "" then delete/nolog rcmp.tmp;*
$ close/error=err_close rcm_log
$ err_close:
$ if (curdirdev .nes. rcmdatadev) .or. (curdirdir .nes. rcmdatadir) 
$ then
$   set default 'curdir'
$   write sys$output ""
$   write sys$output "Reset default directory to ''curdir'"
$   write sys$output ""
$ endif
$ exit
$!
$!--------------------------------------------------------------------------------------------------
$!--------------------------------------------------------------------------------------------------
$!
$ get_cfg_file:
$  if p1 .eqs. "" .or. f$edit(p1, "UPCASE") .eqs. "-NOW"
$  then
$      if f$trnlnm("RCM$CONFIGFILE") .nes. "" 
$      then
$         cfg_file = f$trnlnm("RCM$CONFIGFILE")
$         cfg_file = f$parse(cfg_file,,,"NAME") + f$parse(cfg_file,,,"TYPE")  
$         return
$      endif
$      homfil = f$search("RCM$DATA:*.home",1) 
$      if homfil .nes. ""
$      then
$        open/read home 'homfil'
$        read home homenode
$        read home node_string
$        read home cfg_file
$        close home
$      else
$         err_msg = "To use '-now' you must have setup a schedule. Use @RCM$DIR:RCM_START ''thisnode'.CFG"  
$!        err_msg = "No RCM$DATA:*.HOME file found!"
$        goto error_exit
$      endif
$  else
$      cfg_file = p1
$  endif
$ return
$!
$!--------------------------------------------------------------------------------------------------
$!
$ delete_old_files:
$ if f$search("RCM$DATA:RCM*.MKR",101) .nes. "" then delete/nolog RCM$DATA:rcm*.mkr;*
$ if f$search("RCM$DATA:RCM*.ZIP",102) .nes. "" then delete/nolog RCM$DATA:rcm*.zip;*
$ if f$search("RCM$DATA:RCM*.UUE",103) .nes. "" then delete/nolog RCM$DATA:rcm*.uue;*
$ if f$search("RCM$DATA:RCMO*.HTML",104) .nes. "" then delete/nolog RCM$DATA:rcmo*.html;*
$ if f$search("RCM$DATA:RCMO*.TXT",105) .nes. "" then delete/nolog RCM$DATA:rcmo*.txt;*
$ if f$search("RCM$DATA:RCM*.LOG",106) .nes. "" then delete/nolog/exclude=rcm_start*.log RCM$DATA:rcm*.log;*
$ if f$search("RCM$DATA:RCM*.LOG1",107) .nes. "" then delete/nolog RCM$DATA:rcm*.log1;*
$ if f$search("RCM$DATA:*.LIF",108) .nes. "" then delete/nolog RCM$DATA:*.lif;*
$ if f$search("RCM$DIR:HS*.LOCK") .nes. "" then delete/nolog RCM$DIR:HS*.LOCK;*
$ if f$search("RCM$DIR:HS*.LOG") .nes. "" then delete/nolog RCM$DIR:HS*.LOG;*
$ if f$search("RCM$DIR:HSJD*.TMP") .nes. "" then delete/nolog RCM$DIR:HSJD*.TMP;*
$ if f$search("RCM$DIR:RCMS*.EXE") .nes. "" then delete/nolog RCM$DIR:RCMS*.EXE;*
$ purge/nolog RCM$DATA:*.*
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$ check_cpu_model:
$ machine_name = f$getsyi("HW_NAME")
$ if f$locate("AlphaServer", machine_name) .ne. f$length(machine_name)
$ then
$   modl = f$extract(f$locate("AlphaServer", machine_name)+12, 5, machine_name)
$   modl = f$extract(0, f$locate(" ", modl), modl)
$ endif
$ modl = " ''modl' "
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$ check_for_rcmprocess:
$ if f$search("rcmp.tmp") .nes. "" then delete rcmp.tmp;*
$ show system/process="RCM*"/node='node'/output=rcmp.tmp
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search rcmp.tmp "RCM_COLLECT"
$ if $severity .eq. 1 
$ then
$   err_msg = "RCM Collection process is running on this node. Use RCM$DIR:RCM_STOP to kill all RCM Processes"
$   goto error_exit
$ endif
$!
$! if this is the RCM Process skip next check
$!
$ prnam = f$getjpi("","PRCNAM")
$!
$ if prnam .eqs. "RCM" then return
$!
$! If an immediate collection was requested, via "-now" parameter, skip this test
$!
$ if f$edit(p1, "UPCASE") .eqs. "-NOW" then return
$!
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search rcmp.tmp " RCM "    	!PTR36-4-496 19-Feb-1999
$ if $severity .eq. 1                                   
$ then
$   write rcm_log "''f$time()': RCM Scheduling process is running"
$   write sys$output ""
$   write sys$output "Warning: RCM Scheduling process is running:"
$   write sys$output ""
$   search/nohighlight rcmp.tmp " RCM ", " on node "    
$   if f$search("RCM$DATA:*.home",2) .nes. "" 
$   then
$      gosub get_next_time
$      write sys$output ""
$      write sys$output "Next Scheduled collection time: ''value'"
$      write sys$output ""
$   endif
$   write sys$output "To stop all RCM processes, execute @RCM$DIR:RCM_STOP.COM"
$   write sys$output ""
$   write sys$output "To carry-out an immediate RCM Collection execute @RCM$DIR:RCM_START -now"
$   write sys$output ""
$   goto finish_up
$ endif
$ if f$search("rcmp.tmp") .nes. "" then delete/nolog rcmp.tmp;*
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$setup_variables:
$! get vms-ver
$ cr[0,8] = 13
$ lf[0,8] = 10
$ partid = -1
$ vver = f$getsyi("version")
$ vver = f$edit(vver, "trim") - "." - "-"
$ vver = f$integer(f$extract(1,3,vver))
$ if vver .lt. 100 then vver = vver * 10  ! e.g V7.1 becomes 710, V7.1-1 becomes 711 
$ suppress_ip = "N"
$ node = thisnode
$ fct_image = "N"
$ anal_data = "F"
$ cmpy_name = ""
$ cmpy_c = ""
$ cmpy_tel = ""
$ cmpy_email = ""
$ set default []   ! makes sure directory spec does not have <,>
$ delete = "delete/noconfirm"
$ rcm_device = "''f$parse(f$environment("default"),,,"device",)'"
$ rcm_device = f$getdvi(rcm_device, "LOGVOLNAM") + ":"
$ rcm_dir = "''f$parse(f$environment("default"),,,"directory","no_conceal")'"
$ rcm_path = rcm_device + rcm_dir   
$ rcm_path = rcm_path - "]["   ! in case there are rooted directories
$ if f$locate("[000000.", rcm_path) .ne. f$length(rcm_path) then rcm_path = rcm_path - "000000."
$ if f$locate(".000000.", rcm_path) .ne. f$length(rcm_path) then rcm_path = rcm_path - "000000."  
$ tmp_str = rcm_path
$ gosub replace_bkts        ! if there are <> - change to []"
$ rcm_path = tmp_str
$ if f$trnlnm("RCM$DIR") .eqs. "" 
$ then 
$   rdev = f$getdvi(f$parse(rcm_path,"device"),"logvolnam")
$   rdir = f$parse(rcm_path,,,"directory","no_conceal") - "]["
$   rcdir = rdev + ":" + rdir
$   define/system/nolog RCM$DIR 'rcm_path'
$ endif
$ rcmdirlog = f$trnlnm("RCM$DIR")
$ rcmroot = f$parse("RCM$DIR",,,,) - "][" - "].;" + ".]"
$ define/system/nolog/translate=concealed RCM$ROOT 'rcmroot'  !make sure RCM$ROOT is derived from RCM$DIR
$ run_on_reboot = "N"
$ node_string = ""
$ node_sn_string = ""
$ old_node_sn_string = ""
$ trans = "M"
$ passed = 0
$ max_archives_def = 10     			  ! edit the .CFG file to change
$ archive_directory_def = "RCM$ROOT:[RCM_ARCHIVE]"!
$ coll_dir_def = f$trnlnm("RCM$DATA")             !
$ ftp_area = "rcm.support.compaq.com/to_rcm/"     !
$ ftp_procedure = ""
$ email_adr = "rcm.data@compaq.com"               !
$ error_email = "<not_defined>"
$ archive_dir = archive_directory_def
$ coll_dir = coll_dir_def                         !
$ define sys$output NLA0:
$ define sys$error NLA0:
$ if ALPHA
$ then
$    if f$search("rcm$dir:uuencode_alpha.exe") .eqs. "" then link/exe=rcm$dir:uuencode_alpha rcm$dir:uuencode_alpha
$    enc := $rcm$dir:uuencode_alpha
$ else
$    if f$search("rcm$dir:uuencode_vax.exe") .eqs. "" then link/exe=rcm$dir:uuencode_vax rcm$dir:uuencode_vax
$    enc := $rcm$dir:uuencode_vax
$ endif
$ deass sys$output
$ deass sys$error
$!
$! now try to get defaults from RCM$DEFAULTS.CFG
$!
$ if f$search("RCM$DIR:RCM$DEFAULTS.CFG") .nes. ""
$ then
$    open/read cfil RCM$DIR:RCM$DEFAULTS.CFG
$    rcmdloop:
$    read/end=endcfil cfil line
$    if f$extract(0,1,line) .eqs. "["
$    then
$      rbracket = f$locate("]",line)+1
$      semic = f$locate(";",line)
$      semic = semic - rbracket
$      value = f$edit(f$extract(rbracket, semic, line), "TRIM")
$      if f$locate("[COMPANY NAME]",line) .ne. f$length(line) then cmpy_name = value
$      if f$locate("[CONTACT NAME]",line) .ne. f$length(line) then cmpy_c = value
$      if f$locate("[CONTACT TELEPHONE]",line) .ne. f$length(line) then cmpy_tel = value
$      if f$locate("[CONTACT EMAIL]",line) .ne. f$length(line) then cmpy_email = value
$      if f$locate("[ACCOUNT MANAGER]",line) .ne. f$length(line) then tam_name = value
$      if f$locate("[ACCOUNT MANAGER EMAIL]",line) .ne. f$length(line) then tam_email = value
$      if f$locate("[CUSTOMER ACCESS ID]",line) .ne. f$length(line) then cust_id = value
$      if f$locate("[TRANSPORT OPTION]",line) .ne. f$length(line) then trans = value
$      if f$locate("[COLLECTION FREQUENCY]",line) .ne. f$length(line) then coll_freq = value
$      if f$locate("[NEXT COLLECTION TIME]", line) .ne. f$length(line) then nextime = value
$      if f$locate("[MAX ARCHIVES]", line) .ne. f$length(line) then max_archives_def = value
$      if f$locate("[ARCHIVE DIRECTORY]", line) .ne. f$length(line) then archive_directory_def = value
$      if f$locate("[COLLECTION DIRECTORY]", line) .ne. f$length(line) then coll_dir_def = value
$      if f$locate("[FTP AREA]",line) .ne. f$length(line) then ftp_area = value
$      if f$locate("[FTP PROCEDURE]",line) .ne. f$length(line) then ftp_procedure = value
$      if f$locate("[EMAIL ADDRESS]", line) .ne. f$length(line) then email_adr = value
$      if f$locate("[LOCAL SITE]",  line) .ne. f$length(line) then local_site = value 
$      if f$locate("[LOCAL TRANSPORT OPTION]",  line) .ne. f$length(line) then local_trans = value 
$      if f$locate("[LOCAL EMAIL ADDRESS]",  line) .ne. f$length(line) then local_email = value 
$      if f$locate("[LOCAL HOSTNAME]",  line) .ne. f$length(line) then local_host = value 
$      if f$locate(" LOGIN]",  line) .ne. f$length(line) then local_login = value 
$      if f$locate(" PASSWORD]",  line) .ne. f$length(line) then local_password = value 
$      if f$locate(" UPLOADDIR]",  line) .ne. f$length(line) then local_dir = value 
$      if f$locate("[LOCAL FTP PROCEDURE]",  line) .ne. f$length(line) then local_ftpproc = value 
$      if f$locate("[SUPPRESS IP ADDRESSES]",  line) .ne. f$length(line) then suppress_ip = value 
$      if f$locate("[RUN ON REBOOT]", line) .ne. f$length(line) then run_on_reboot = value
$      if f$locate("[FCT BINARY IMAGE]", line) .ne. f$length(line) then fct_image = value
$      if f$locate("[DATA FOR ANALYSIS]", line) .ne. f$length(line) then anal_data = value
$      if f$locate("[NODES]", line) .ne. f$length(line) then node_string = f$edit(value, "collapse")
$    endif
$    goto rcmdloop
$    endcfil:
$    close  cfil
$ endif
$ if max_archives_def .eq. 0 then max_archives_def = 10
$ max_archives = max_archives_def
$!
$ err_msg = "RCM Collection failed - check the log files"
$!
$ time_zone = f$trnlnm("sys$timezone_name")
$ write rcm_log "RCM Data Collector ''rcm_ver' for OpenVMS "
$ write rcm_log ""
$ write rcm_log "Executing RCM$DIR:RCM_START at ''f$time()' ''time_zone' on ''thisnode'"
$!
$ if alpha
$   then arch = "A"
$   else arch = "V"
$ endif
$!
$ fru_ver = "000"
$ sn = ""
$ syssn = ""
$ define/user sys$output sn.tmp
$ show cpu/full                       
$ convert/fdl=sys$input sn.tmp sn1.tmp
record; format stream;
$ search/out=sn2.tmp/format=passall sn1.tmp "Serial Number =","Serial Number	="  ! V7.3 has Tab before =
$ if $status .ne. 1 then goto skipsn
$ if f$search("sn2.tmp") .eqs. "" then return
$ open/read snfil sn2.tmp
$ read/end=skipsn snfil snrec
$ close snfil
$ sn = f$edit(f$extract(f$loc("=", snrec)+1, 13, snrec), "compress,trim,upcase")
$ skipsn:
$ delete sn*.tmp;*
$!
$ t = f$time()
$ dte = f$extract(0, 10, f$cvtime(t, "comparison")) - "-" - "-"
$ hhmmss = f$extract(11, 8, f$cvtime(t, "comparison")) - ":" - ":"
$ tim = dte + "-" + hhmmss
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$check_privs:
$ write sys$output ""
$ write rcm_log "Checking Privs"
$ prvs = "OPER,SYSPRV,DIAGNOSE,CMKRNL,SYSLCK,PHY_IO"
$ if F$PRIVILEGE(prvs) .nes. "TRUE"
$ then
$   err_msg = "RCM needs ''prvs' privileges!"
$   goto error_exit
$ endif
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$check_config_file:
$ if f$mode() .nes. "INTERACTIVE" then return
$ if p1 .eqs. ""
$ then
$      if f$trnlnm("RCM$CONFIGFILE") .nes. "" 
$      then
$         cfg_file = f$trnlnm("RCM$CONFIGFILE")
$         cfg_file = f$parse(cfg_file,,,"NAME") + f$parse(cfg_file,,,"TYPE")  
$         write rcm_log "Using Config file ''cfg_file'"
$      else
$       tmp_cfg =  f$search("*.CFG")
$       if tmp_cfg .nes. ""
$       then
$         cfg_file = f$parse(tmp_cfg,,,"NAME") + f$parse(tmp_cfg,,,"TYPE")  
$       else
$         prmt = "Enter RCM configuration file (.CFG) to use or create (<cr> to exit): "
$         cfg_file = ""
$         read/end=cfg_exit/prompt="''prmt'" sys$command cfg_file
$         if cfg_file .eqs. ""
$         then
$            write rcm_log "No Config filename entered"
$            goto finish_up
$         endif
$       endif
$      endif
$ else
$   if f$edit(p1, "UPCASE") .eqs. "-NOW" 
$   then 
$     gosub get_cfg_file
$   else
$     cfg_file = p1
$   endif
$ endif
$ !
$ cfg_file = f$edit(cfg_file, "UPCASE")
$ if f$trnlnm(cfg_file) .eqs. ""
$ then
$   if f$loc(".CFG", cfg_file) .eq. f$len(cfg_file) then cfg_file = "''cfg_file'.CFG"
$ else
$   cfg_file = f$search("RCM$DATA:''cfg_file'")
$ endif
$!
$ if f$search("RCM$DATA:''cfg_file'") .eqs. ""
$ then
$   gosub create_cfg_file
$ else
$   write sys$output "Using configuration file " + f$search("RCM$DATA:''cfg_file'")
$   write rcm_log "Using configuration file " + f$search("RCM$DATA:''cfg_file'")
$ endif
$ tmp = f$search("RCM$DATA:''cfg_file'")
$ define/system/nolog RCM$CONFIGFILE 'tmp'
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$ cfg_exit:
$  goto finish_up
$!
$!--------------------------------------------------------------------------------------------
$!
$create_cfg_file:
$ gosub get_answers
$ gosub get_nodes
$ create RCM$DATA:'cfg_file'
$ open/append/error=error_2 cfgf RCM$DATA:'cfg_file'
$ write sys$output "Creating RCM configuration file RCM$DATA:''cfg_file'"
$ write cfgf ";"
$ write cfgf "; RCM ''rcm_ver' Configuration file ''cfg_file'"
$ write cfgf "; created by RCM_START.COM on node ''thisnode' at ''f$time()'"
$ write cfgf ";"
$ write cfgf "[COMPANY NAME]                        " + cmpy_name      
$ write cfgf "[CONTACT NAME]                        " + cmpy_c  
$ write cfgf "[CONTACT TELEPHONE]                   " + cmpy_tel  
$ write cfgf "[CONTACT EMAIL]                       " + cmpy_email  
$ write cfgf "[ACCOUNT MANAGER]                     " + tam_name  
$ write cfgf "[ACCOUNT MANAGER EMAIL]               " + tam_email  
$ cust_id = f$edit(cust_id, "UPCASE")
$ write cfgf "[CUSTOMER ACCESS ID]                  " + cust_id  
$ trans = f$edit(trans, "UPCASE")
$ write cfgf "[TRANSPORT OPTION]                    " + trans  
$ coll_freq = f$edit(coll_freq, "UPCASE")
$ write cfgf "[COLLECTION FREQUENCY]                " + coll_freq
$ nextime = f$cvtime(nextime, "absolute")
$ write cfgf "[NEXT COLLECTION TIME]                " + nextime
$ write cfgf "[MAX ARCHIVES]                        " + max_archives
$ archdev = f$parse(archive_dir,,,"DEVICE")
$ archdir = f$parse(archive_dir,,,"DIRECTORY")
$ adir = archdev + archdir - "]["
$ define/system/nolog RCM$ARCHIVE 'adir'
$ write cfgf "[ARCHIVE DIRECTORY]                   " + adir
$ coldev = f$parse(coll_dir,,,"DEVICE")
$ coldir = f$parse(coll_dir,,,"DIRECTORY")
$ datadir = coldev + coldir - "]["
$ write cfgf "[COLLECTION DIRECTORY]                " + datadir
$ write cfgf "[FTP AREA]                            " + ftp_area 
$ write cfgf "[FTP PROCEDURE]                       " + ftp_procedure 
$ write cfgf "[EMAIL ADDRESS]                       " + email_adr 
$ write cfgf "[LOCAL SITE]                          " + local_site
$ write cfgf "[LOCAL TRANSPORT OPTION]              " + local_trans
$ write cfgf "[LOCAL EMAIL ADDRESS]                 " + local_email
$ write cfgf "[LOCAL HOSTNAME]                      " + local_host
$ write cfgf "[LOCAL LOGIN]                         " + local_login
$ if f$extract(0,1,local_password) .nes. "" 
$ then 
$    gosub isencd
$    if .not. encd then gosub encp
$ endif
$ write cfgf "[LOCAL PASSWORD]                      " + local_password
$ write cfgf "[LOCAL UPLOADDIR]                     " + local_dir
$ write cfgf "[LOCAL FTP PROCEDURE]                 " + local_ftpproc
$ write cfgf "[SUPPRESS IP ADDRESSES]               " + suppress_ip
$ write cfgf "[RUN ON REBOOT]                       " + run_on_reboot
$ write cfgf "[FCT BINARY IMAGE]                    " + fct_image
$ write cfgf "[DATA FOR ANALYSIS]                   " + anal_data
$ node_string = f$edit(node_string, "UPCASE, COLLAPSE")
$ write cfgf "[NODES]                               " + node_string
$ write sys$output ""
$ write sys$output "Please wait while Serial Numbers of all nodes are obtained..."
$ write sys$output ""
$ gosub get_serialnums
$ close cfgf
$ purge/nolo 'cfg_file'
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$get_answers:
$ if f$edit(p2, "upcase") .eqs. "-SETUP" then goto getfreq1 !skip some prompts if setup via WEBES install
$ write sys$output "Enter '?' at any prompt for Help"
$ write sys$output ""
$!
$ company_name:
$ defau = cmpy_name
$ read/end=cfg_exit/prompt= "Company Name                        : [''defau'] " sys$command cmpy_name
$ if cmpy_name .eqs. ""  then cmpy_name = defau
$ if f$extract(0,1,cmpy_name) .eqs. "?" 
$ then 
$   gosub cmpy_name_help
$   goto company_name
$ endif
$!
$ contact_name:
$ defau = cmpy_c
$ read/end=cfg_exit/prompt= "Contact Name                        : [''defau'] " sys$command cmpy_c
$ if cmpy_c .eqs. ""  then cmpy_c = defau
$ if f$extract(0,1,cmpy_c) .eqs. "?" 
$ then 
$   gosub cmpy_c_help
$   goto contact_name
$ endif
$!
$ contact_telephone:
$ defau = cmpy_tel
$ read/end=cfg_exit/prompt= "Contact telephone                   : [''defau'] " sys$command cmpy_tel
$ if cmpy_tel .eqs. ""  then cmpy_tel = defau 
$ if f$extract(0,1,cmpy_tel) .eqs. "?" 
$ then 
$   gosub cmpy_tel_help
$   goto contact_telephone
$ endif
$!
$ contact_email:
$ if cmpy_email .eqs. "" .or. cmpy_email .eqs. "<not_defined>" 
$ then 
$   user = f$edit(f$getjpi("","USERNAME"), "trim")
$ else
$   user = cmpy_email
$ endif
$ read/end=cfg_exit/prompt= "Contact Email address               : [''user'] " sys$command cmpy_email
$ if cmpy_email .eqs. ""  then cmpy_email = user
$ if f$extract(0,1,cmpy_email) .eqs. "?" 
$ then 
$   gosub cmpy_email_help
$   cmpy_email = user
$   goto contact_email
$ endif
$ if cmpy_email .nes. "<not_defined>" then error_email = cmpy_email  ! use for error messages
$!
$ account_manager:
$ defau = tam_name
$ read/end=cfg_exit/prompt= "Technical Account Manager           : [''defau'] " sys$command tam_name
$ if tam_name .eqs. ""  then tam_name = defau
$ tam_name = f$edit(tam_name, "compress,trim")
$ if f$extract(0,1,tam_name) .eqs. "?" 
$ then 
$   gosub tam_name_help
$   goto account_manager
$ endif
$!
$ tamcnt1=0
$ get_email_adr:
$ fir = f$element(0, " ", tam_name)
$ las = f$element(1, " ", tam_name)
$ emnam = "''fir'.''las'@compaq.com" 
$ emnam = f$edit(emnam, "collapse")
$ defau = emnam
$!
$! If a 'valid' email address is in RCM$DEFAULTS.CFG, use that as default
$!
$ if f$locate("COMPAQ.COM", f$edit(tam_email ,"UPCASE")) .ne. f$len(tam_email)
$ then
$     if f$locate("NOT_DEFINED", f$edit(tam_email ,"UPCASE")) .eq. f$len(tam_email) then defau = tam_email
$ endif
$!
$ read/end=cfg_exit/prompt= "Account Manager Email               : [''defau'] " sys$command tam_email
$ if tam_email .eqs. "" then tam_email = defau
$ if f$extract(0,1,tam_email) .eqs. "?" 
$ then 
$   gosub tam_email_help
$   goto get_email_adr
$ endif
$!
$ uptam_email = f$edit(tam_email, "UPCASE")     !Will not Uppercase between Quotes !!
$ if f$locate("COMPAQ.COM", uptam_email) .eq. f$length(uptam_email) -
    .and. f$locate("compaq.com", uptam_email) .eq. f$length(uptam_email)
$ then
$   write sys$output ""
$   write sys$output "Email address must be a compaq.com address"
$   write sys$output ""
$   tamcnt1 = tamcnt1 + 1
$   if tamcnt1 .lt. 5 then goto get_email_adr
$ endif
$!
$ tm = f$time()
$ tm = f$cvtime(tm, "comparison")
$ tm = tm - "-" - "-" - " " - ":" - ":"
$ tm = f$extract(2, 10, tm)
$!
$ custid:
$ badcust = 0
$ defau = cust_id 
$ read/end=cfg_exit/prompt= "Customer Access ID                  : [''defau'] " sys$command cust_id
$ if cust_id .eqs. ""  then cust_id = defau
$!
$ if f$extract(0,1,cust_id) .eqs. "?" 
$ then 
$   gosub cust_id_help
$   goto custid
$ endif
$!
$ cust_id = f$edit(cust_id, "UPCASE")
$ gosub check_custid_format
$ if badcust .eq. 1 then goto custid
$!
$ defau = trans
$ transp:
$ read/end=cfg_exit/prompt= "Transport Option                    : [''defau'] " sys$command trans
$ if trans .eqs. "" then trans = defau
$ if f$extract(0,1,trans) .eqs. "?" 
$ then 
$   gosub trans_help
$   goto transp
$ endif
$ trans = f$edit(f$extract(0,1,trans), "UPCASE")
$ if trans .eqs. "" then trans = "F"
$ if f$loc(trans, "FEDM") .eq. f$len("FEDM") 
$ then 
$   write sys$output "Transport Option must be either FTP, Email, DSNlink, or Manual (F/E/D/M) ! "
$   goto transp
$ endif
$ if trans .eqs. "F" 
$ then 
$    trans = "FTP"
$    gosub get_tcpip_prod
$    if tcpip .nes. "Compaq's TCPIP" .and. tcpip .nes. "MULTINET"
$    then
$       gosub ftp_proc_help
$       defau = ftp_procedure
$       ftpproc:
$         read/end=cfg_exit/prompt= "FTP Procedure                       : [''defau'] " sys$command ftp_procedure
$         if ftp_procedure .eqs. "?" 
$         then 
$           gosub ftp_proc_help
$           goto ftpproc
$         endif
$    endif
$ endif
$ if trans .eqs. "E" then trans = "EMAIL"
$ if trans .eqs. "D" then trans = "DSNLINK"
$ if trans .eqs. "M" then trans = "MANUAL TRANSPORT"
$!
$ defau = coll_freq
$ getfreq:
$ read/end=cfg_exit/prompt= "Collection Frequency                : [''defau'] " sys$command coll_freq
$ getfreq1:
$ if coll_freq .eqs. "" then coll_freq = defau
$ if f$extract(0,1,coll_freq) .eqs. "?" 
$ then 
$   gosub coll_freq_help
$   goto getfreq
$ endif
$ coll_freq = f$edit(coll_freq, "UPCASE")
$ if coll_freq .eqs. "" then coll_freq = "MONTHLY" 
$ if f$loc(f$edit(f$extract(0,1,coll_freq),"UPCASE"), "NDWMQ") .eq. f$len("NDWMQ") 
$ then 
$  	tmp = f$cvtime(coll_freq, "delta")
$  	if ($status .and. 1) then goto getnxtcoll
$       goto getfreq
$ endif
$ coll_freq = f$edit(f$extract(0,1,coll_freq), "UPCASE")
$ if coll_freq .eqs. "D" then coll_freq = "DAILY"
$ if coll_freq .eqs. "W" then coll_freq = "WEEKLY"
$ if coll_freq .eqs. "M" then coll_freq = "MONTHLY"
$ if coll_freq .eqs. "Q" then coll_freq = "QUARTERLY"
$ if coll_freq .eqs. "N" then coll_freq = "NONE"
$ if f$edit(f$extract(0, 1, coll_freq), "UPCASE") .eqs. "N" 
$ then
$    write sys$output ""
$    write sys$output "Only one RCM Collection will be carried out."
$    nextime = ""
$    goto next_q
$ endif
$!
$ getnxtcoll:
$ nextime = ""
$ td = f$extract(0, 17, f$cvtime(f$time(), "absolute"))
$ if f$extract(16,1,td) .eqs. ":" then td = f$extract(0, 16, td)
$   !
$   ! Calculate 1st of next month (for use with M or Q options)
$   !
$ m=f$cvtime("today",, "month")
$ y=f$cvtime("today",, "year")
$ nm = f$element(m, " ", "JAN FEB MAR APR MAY JUN JUL AUG SEP OCT NOV DEC JAN FEB MAR ")
$ if m .ge. 12 then y = y + 1
$ firs = "1-''nm'-''y' 03:20"
$!
$ ans = ""
$ if f$loc(f$edit(f$extract(0, 1, coll_freq), "UPCASE"), "MQ") .ne. f$len("MQ")
$ then
$   td = f$extract(0, 16, f$cvtime(firs, "absolute"))
$ endif
$!
$ if f$edit(p2, "upcase") .eqs. "-SETUP" then goto skip_nxtprmt
$!
$ if f$edit(f$extract(0, 1, coll_freq), "UPCASE") .eqs. "M" 
$ then
$   td = f$extract(0, 16, f$cvtime(firs, "absolute"))
$ endif
$ if f$edit(f$extract(0, 1, coll_freq), "UPCASE") .eqs. "Q" 
$ then
$   td = f$extract(0, 16, f$cvtime(firs, "absolute"))
$ endif
$!
$ get_nxtcoll:
$ ans = ""
$ read/end=cfg_exit/prompt="Next Collection Time                : [''td'] " sys$command ans
$ skip_nxtprmt:
$ ans = f$edit(ans, "UPCASE")
$ if f$extract(0,1,ans) .eqs. "N" then ans = f$time()
$ if f$extract(0,1,ans) .eqs. "?" 
$ then 
$   gosub nxtcoll_help
$   goto get_nxtcoll
$ endif
$!
$ if coll_freq .eqs. "" then goto next_q
$ if ans .eqs. "" then ans = td
$ define sys$output NLA0:
$ define sys$error NLA0: 
$ nextime = f$cvtime(ans, "absolute")
$ stat = $status
$ deass sys$output
$ deass sys$error
$ if (stat .and. 1) .EQ. 0 
$ then 
$    goto getnxtcoll
$ else
$    if coll_freq .eqs. "" then goto next_q
$ endif
$!
$ hhmm = f$cvtime(nextime, "absolute", "time")
$ if f$loc(f$edit(f$extract(0,1,coll_freq),"upcase"), "DWMQ") .eq. f$len("DWMQ") 
$ then 
$  	tmp = f$cvtime(coll_freq, "delta")
$  	if ($status .and. 1) .eq. 0 
$  	then 
$    	    goto getfreq
$  	else
$           tmpd = f$cvtime(coll_freq, "delta", "day")
$           tmph = f$cvtime(coll_freq, "delta", "hour")
$           tmpm = f$cvtime(coll_freq, "delta", "minute")
$           if tmpd.ne.0.and.tmph.ne.0.and.tmpm.ne.0 then -
              write sys$output "RCM Collection will be run every ''tmpd' days ''tmph' hours and ''tmpm' minutes"
$           if tmpd.ne.0.and.tmph.ne.0.and.tmpm.eq.0 then -
              write sys$output "RCM Collection will be run every ''tmpd' days and ''tmph' hours"
$           if tmpd.ne.0.and.tmph.eq.0.and.tmpm.ne.0 then -
              write sys$output "RCM Collection will be run every ''tmpd' days and ''tmpm' minutes"
$           if tmpd.ne.0.and.tmph.eq.0.and.tmpm.eq.0 then -
              write sys$output "RCM Collection will be run every ''tmpd' days at ''hhmm'"
$           if tmpd.eq.0.and.tmph.ne.0.and.tmpm.ne.0 then -
              write sys$output "RCM Collection will be run every ''tmph' hours and ''tmpm' minutes"
$           if tmpd.eq.0.and.tmph.ne.0.and.tmpm.eq.0 then -
              write sys$output "RCM Collection will be run every ''tmph' hours"
$           if tmpd.eq.0.and.tmph.eq.0.and.tmpm.ne.0 then -
              write sys$output "RCM Collection will be run every ''tmpm' minutes"
$!    	    write sys$output "RCM Collection will be run every ''tmp'"
$  	endif
$ endif
$! write sys$output ""
$!
$ next_q:
$ if f$edit(p2, "UPCASE") .eqs. "-SETUP" 
$ then         	  	  
$   max_archives = max_archives_def
$   archive_dir = archive_directory_def
$   coll_dir = coll_dir_def
$   gosub get_dir_spec
$   if invalid_dir .eqs. "TRUE"
$   then
$        create/dir 'coll_dir'
$        if ($status .and. 1) .eq. 0 
$        then 
$          write sys$output "Unable to create collection directory ''coll_dir'"
$          exit
$        endif
$   endif
$ else         	  	  
$   maxarchives:
$   defau = max_archives_def
$   max_archives = ""
$   read/end=cfg_exit/prompt="Number of Collections to keep       : [''defau'] " sys$command max_archives
$   max_archives = f$edit(max_archives, "UPCASE")
$   if max_archives .eqs. ""  then max_archives = defau
$   if f$extract(0,1,max_archives) .eqs. "?" 
$   then 
$     gosub max_archives_help
$     goto maxarchives
$   endif
$!
$   archive_directory:
$   defau = archive_directory_def
$   archive_dir = ""
$   read/end=cfg_exit/prompt="Archive Directory                   : [ ''defau' ] " sys$command archive_dir
$   archive_dir = f$edit(archive_dir, "UPCASE")
$   if archive_dir .eqs. ""  then archive_dir = defau
$   if f$extract(0,1,archive_dir) .eqs. "?" 
$   then 
$     gosub archive_dir_help
$     goto archive_directory
$   endif
$   get_coll_directory:
$   defau = coll_dir_def
$   coll_dir = ""
$   read/end=cfg_exit/prompt="Data Directory                      : [ ''defau' ] " sys$command coll_dir
$   coll_dir = f$edit(coll_dir, "UPCASE")
$   if coll_dir .eqs. "" then coll_dir = defau
$   if f$extract(0,1,coll_dir) .eqs. "?" 
$   then 
$     gosub coll_dir_help
$     goto get_coll_directory
$   endif
$   gosub get_dir_spec
$   if invalid_dir .eqs. "TRUE"
$   then
$     ans = ""
$     read/end=cfg_exit/prompt="Directory ''coll_dir' does not exist: Create it [Y]/N : " sys$command ans
$     if ans .eqs. "" then ans = "Y"
$     if f$edit(ans, "upcase") .eqs. "Y"
$     then
$        create/dir 'coll_dir'
$        if ($status .and. 1) .eq. 0 then goto get_coll_directory
$     else
$        goto get_coll_directory
$     endif
$   endif
$ endif
$!
$ olddir = f$environment("default")
$ olddev = f$getdvi(f$parse(olddir,,,"device"),"logvolnam")
$ olddirect = f$parse(olddir,,,"directory","no_conceal") - "]["
$ set default 'coll_dir'
$ newdir = f$environment("default")
$ ndev = f$getdvi(f$parse(newdir,,,"device"),"logvolnam")
$ ndir = f$parse(newdir,,,"directory","no_conceal") - "]["
$ if ndev .nes. olddev .or. ndir .nes. olddirect 
$ then
$   write sys$output "Warning: Changing RCM$DATA directory from ''olddir' to ''newdir'"
$   ndata = ndev + ":" + ndir
$   define/system/nolog RCM$DATA 'ndata'
$ endif
$!
$ local_trans        = ""
$ local_email        = ""
$ local_host         = ""
$ local_dir          = ""
$ local_ftpproc      = ""
$ suppress_ip        = "N"
$ local_login        = ""
$ local_password     = ""
$ local_site         = "N"
$ run_on_reboot      = "N"
$!
$ if f$edit(p2, "UPCASE") .nes. "-SETUP" 
$ then         	  	  
$   defau = local_site
$   localsite:
$   read/end=cfg_exit/prompt="Send RCM data to local site         : [''defau'] " sys$command local_site
$   local_site = f$edit(f$extract(0,1,local_site), "UPCASE")
$   if local_site .eqs. "" then local_site = defau
$   if local_site .eqs. "?" 
$   then 
$     gosub local_site_help
$     goto localsite
$   endif
$!
$   if local_site .nes. "Y"  
$   then 
$      local_site = "N"
$   else
$      lcl_trans:
$      local_trans = "F"
$      read/end=cfg_exit/prompt="Local Transport Option              : [''local_trans'] " sys$command local_trans
$      local_trans = f$extract(0,1,local_trans)
$      if local_trans .eqs. "" then local_trans = "F"
$      if local_trans .eqs. "?" 
$      then 
$         gosub local_trans_help
$         goto lcl_trans
$      endif
$      local_trans = f$edit(local_trans, "UPCASE")
$      if f$locate(f$extract(0,1,local_trans), "FED") .eq. f$length("FED")  
$      then 
$         write sys$output "Local Transport Option must be either FTP, Email or DECnet!"
$         goto lcl_trans
$      endif
$      if f$extract(0,1,local_trans) .eqs. "F" 
$      then 
$         local_trans = "FTP"
$         local_email = ""
$         local_host = ""
$         local_login = "anonymous"
$         local_password = "''tam_email'"
$         local_dir = ""
$         local_ftpproc = ""
$         lcl_host:
$         read/end=cfg_exit/prompt= "Local FTP Hostname                  : " sys$command local_host
$         if local_host .eqs. "?" 
$         then 
$           gosub local_host_help
$           goto lcl_host
$         endif
$         lcl_login:
$         read/end=cfg_exit/prompt= "Local FTP Login Username            : " sys$command local_login
$         if local_login .eqs. "?" 
$         then 
$           gosub local_login_help
$           goto lcl_login
$         endif
$         lcl_pswd:
$         gosub get_pass
$         lcl_ftpdir:
$         read/end=cfg_exit/prompt= "''cr'''lf'Local FTP Directory                 : " sys$command local_dir
$         if local_dir .eqs. "?" 
$         then 
$           gosub local_dir_help
$           goto lcl_ftpdir
$         endif
$         lcl_ftpproc:
$         read/end=cfg_exit/prompt= "Local FTP Procedure                 : " sys$command local_ftpproc
$         if local_ftpproc .eqs. "?" 
$         then 
$           gosub local_ftpproc_help
$           goto lcl_ftpproc
$         endif
$      endif
$      if f$extract(0,1,local_trans) .eqs. "E" 
$      then
$         local_trans = "EMAIL"
$         local_host = ""
$         local_dir = ""
$         local_login = ""
$         local_password = ""
$         lcl_email:
$         read/end=cfg_exit/prompt= "Local EMAIL Address                 : " sys$command local_email
$         if local_email .eqs. "?" 
$         then 
$           gosub local_email_help
$           goto lcl_email
$         endif
$      endif
$      if f$extract(0,1,local_trans) .eqs. "D" 
$      then
$         local_trans = "DECnet"
$         local_decnet = ""
$         local_host = ""
$         local_dir = ""
$         local_login = ""
$         local_password = ""
$         lcl_decnet_host:
$         read/end=cfg_exit/prompt= "Local DECnet Hostname               : " sys$command local_host
$         if local_host .eqs. "?" 
$         then 
$           gosub local_host_help
$           goto lcl_decnet_host
$         endif
$         lcl_decnet_login:
$         read/end=cfg_exit/prompt= "Local DECnet Username               : " sys$command local_login
$         if local_login .eqs. "?" 
$         then 
$           gosub local_login_help
$           goto lcl_decnet_login
$         endif
$         lcl_decnet_pswd:
$         gosub get_pass
$         lcl_decnet_dir:
$         read/end=cfg_exit/prompt= "''cr'''lf'Local DECnet Directory              : " sys$command local_dir
$         if local_dir .eqs. "?" 
$         then 
$           gosub local_dir_help
$           goto lcl_decnet_dir
$         endif
$      endif
$   endif
$   defau = run_on_reboot
$   runonreboot:
$   read/end=cfg_exit/prompt= "Run RCM on System reboot            : [''defau'] " sys$command run_on_reboot
$   if run_on_reboot .eqs. "" then run_on_reboot = "N"
$   run_on_reboot = f$edit(f$extract(0,1,run_on_reboot), "UPCASE")
$   if run_on_reboot .eqs. "" then run_on_rebot = defau
$   if run_on_reboot .eqs. "?" 
$   then 
$     gosub run_on_reboot_help
$     goto runonreboot
$   endif
$ endif
$ return
$!
$!------------------------------------------------------------------------------------------------------------
$!
$read_config_file:
$ tmpsn_string = ""
$ node_sn_string = ""
$ str = ""
$ need_to_update_cfg = 0
$ cnt_sn=0
$ if f$mode() .eqs. "INTERACTIVE" 
$ then
$   write sys$output ""
$   write sys$output "RCM$DATA:''cfg_file'"
$   write sys$output ""
$ endif
$ open/read/error=error_3 cfg RCM$DATA:'cfg_file'
$ readfile:
$ read/end=end_cfg cfg line
$ msg = ""
$ if f$extract(0,1,line) .eqs. "["
$ then 
$   rbracket = f$locate("]",line)+1
$   semic = f$locate(";",line)
$   semic = semic - rbracket
$   value = f$edit(f$extract(rbracket, semic, line), "TRIM")
$!
$   if f$locate("[COMPANY NAME]", line) .ne. f$length(line) then cmpy_name = value
$   if f$locate("[CONTACT NAME]", line) .ne. f$length(line) then cmpy_c = value
$   if f$locate("[CONTACT TELEPHONE]", line) .ne. f$length(line) then cmpy_tel = value
$   if f$locate("[CONTACT EMAIL]", line) .ne. f$length(line) then cmpy_email = value 
$   if f$locate("[ACCOUNT MANAGER]", line) .ne. f$length(line) then tam_name = value
$   if f$locate("[ACCOUNT MANAGER EMAIL]",line) .ne. f$length(line) 
$   then 
$     tam_email = value
$     uptam_email = f$edit(tam_email, "UPCASE")
$     if f$locate("COMPAQ.COM", uptam_email) .eq. f$length(uptam_email)  
$     then
$          msg = " <-- Must be a Compaq address"
$          need_to_update_cfg = 1
$     endif
$   endif
$   if f$locate("[CUSTOMER ACCESS ID]", line) .ne. f$length(line) 
$   then 
$       badcust = 0
$       cust_id = f$edit(value, "UPCASE")
$       gosub check_custid_format
$       if badcust .eq. 1 
$        then 
$          msg = " <-- Invalid Customer Access ID Format"
$          need_to_update_cfg = 1
$        endif
$   endif
$   if f$locate("[TRANSPORT OPTION]", line) .ne. f$length(line) then trans = f$edit(value, "UPCASE")
$   if f$locate("[COLLECTION FREQUENCY]", line) .ne. f$length(line) then coll_freq = f$edit(value, "UPCASE")
$   if f$locate("[NEXT COLLECTION TIME]", line) .ne. f$length(line) 
$   then 
$      nextime = value
$      if nextime .eqs. "" then nextime = f$time()
$      if f$edit(nextime, "UPCASE") .eqs. "<NOT_DEFINED>" 
$      then 
$          nextime = f$time()  
$          msg = " <-- Invalid Time Format - need to edit Config file"
$          need_to_update_cfg = 1
$      endif
$      define sys$output NLA0:
$      define sys$error NLA0:
$      nex = f$cvtime(nextime, "absolute")
$      stat = $status
$      deass sys$output
$      deass sys$error
$      if (stat .and. 1) .eq. 0
$      then
$          msg = " <-- Invalid Time Format - need to edit Config file"
$          need_to_update_cfg = 1
$      endif
$   endif
$!
$! PTR36-4-487 look for old-format .CFG and force edit mode. PM 18-Feb-1999
$!
$   if f$locate("[SYSTEM SERIAL NUMBER]", line) .ne. f$length(line) 
$   then 
$          msg = " <-- Old Serial Number Format - need to edit Config file"
$          need_to_update_cfg = 1
$   endif
$!
$   if f$locate(" SYSTEM SERIAL NUMBER]", line) .ne. f$length(line) 
$   then 
$      tmpnod = f$extract(1,6,line)
$      checksn:
$        str = value
$        gosub check_sn_format
$        value = str
$        if badsn .eq. 1 
$        then 
$          msg = " <-- Invalid Serial Number Format"
$          need_to_update_cfg = 1
$        endif
$        if badsn .eq. 2 
$        then 
$          partid = -1
$          define sys$output NLA0:    !suppress error if this version of VMS does
$          define sys$error NLA0:     !not support this getsyi item
$          partid = f$getsyi("PARTITION_ID", "''tmpnod'")
$          deassign sys$output
$          deassign sys$error
$          if (partid .eq. -1)
$          then
$             msg = " <-- Duplicate Serial Number"
$             need_to_update_cfg = 1	!PTR36-4-1193 For partitioned systems, duplicate serial numbers are OK
$          endif
$        endif
$      tmpsn_string = tmpsn_string + str + " "
$      node_sn_string = node_sn_string + " " +"( "+ tmpnod + " " + value + " )"
$   endif
$!
$   if f$locate("[MAX ARCHIVES]", line) .ne. f$length(line) then max_archives = value
$   if f$locate("[ARCHIVE DIRECTORY]", line) .ne. f$length(line) then archive_dir =value
$   if f$locate("[COLLECTION DIRECTORY]", line) .ne. f$length(line) then coll_dir =value
$   if f$locate("[FTP AREA]", line) .ne. f$length(line) then ftp_area = value
$   if f$locate("[FTP PROCEDURE]", line) .ne. f$length(line) then ftp_procedure = value
$   if f$locate("[EMAIL ADDRESS]", line) .ne. f$length(line) then email_adr = value
$   if f$locate("[LOCAL SITE]", line) .ne. f$length(line) then local_site = value 
$   if f$locate("[LOCAL TRANSPORT OPTION]", line) .ne. f$length(line) then local_trans = value 
$   if f$locate("[LOCAL EMAIL ADDRESS]", line) .ne. f$length(line) then local_email = value 
$   if (f$locate("[LOCAL HOSTNAME]", line) .ne. f$length(line)) .or. -
       (f$locate("[LOCAL FTP ADDRESS]", line) .ne. f$length(line)) then local_host = value 
$   if f$locate("LOGIN]", line) .ne. f$length(line) then local_login = value 
$   if f$locate("PASSWORD]", line) .ne. f$length(line) 
$   then 
$      local_password = value 
$      if f$edit(f$extract(0,1,local_site), "upcase") .eqs. "Y" .and. f$extract(0,1,local_password) .nes. ""
$      then 
$        gosub isencd
$        if .not. encd
$        then
$           gosub encp
$           msg = " <-- pswd will be encoded as ''local_password'"
$           need_to_update_cfg = 1
$        endif
$      endif
$   endif
$   if f$locate(" UPLOADDIR]", line) .ne. f$length(line) then local_dir = value 
$   if f$locate("[LOCAL FTP PROCEDURE]", line) .ne. f$length(line) then local_ftpproc = value 
$   if f$locate("[RUN ON REBOOT]", line) .ne. f$length(line) then run_on_reboot = value 
$   if f$locate("[FCT BINARY IMAGE]", line) .ne. f$length(line) then fct_image = value 
$   if f$locate("[DATA FOR ANALYSIS]", line) .ne. f$length(line) then anal_data = value 
$   if f$locate("[NODES]", line) .ne. f$length(line) 
$   then 
$      node_string = f$edit(value, "UPCASE, COLLAPSE")
$      gosub get_node_list
$      gosub check_nodes
$!
$      temp_node_string = "," + node_string + ","
$      if f$locate(thisnode, temp_node_string) .eq. f$length(temp_node_string)
$      then
$          msg = " <-- ''thisnode' must be selected"
$          need_to_update_cfg = 1
$      endif
$   endif
$ endif
$ if f$mode() .eqs. "INTERACTIVE" then write sys$output line + msg
$ goto readfile
$ end_cfg:
$ close cfg
$!
$ if f$mode() .eqs. "INTERACTIVE" .and. need_to_update_cfg .eq. 1
$ then
$   write sys$output ""
$   write sys$output "Error in Configuration file. Please correct the invalid entries."
$   write sys$output ""
$   gosub edit_config
$   goto read_config_file
$ endif
$!
$define/system/nolog RCM$DATA 'coll_dir'
$!
$ ans1 = ""
$ if f$mode() .nes. "INTERACTIVE" then return
$ write sys$output ""
$ if f$edit(p1, "UPCASE") .eqs. "-NOW" then return
$ if f$edit(p2, "UPCASE") .eqs. "-SETUP" then return
$!
$ get_respons:
$ ans1 = ""
$ read/end=cfg_exit/prompt= "Do you want to Continue, Edit, or eXit <[C]/E/X> " sys$command ans1
$ if ans1 .eqs. "" then ans1 = "C"
$ if f$edit(ans1,"UPCASE") .eqs. "X" then goto finish_up 
$ if f$extract(0,1,ans1) .eqs. "?" 
$ then 
$   gosub continue_help
$   goto get_respons
$ endif
$ if f$edit(ans1,"UPCASE") .eqs. "E" 
$ then 
$   gosub edit_config
$   goto read_config_file
$ endif
$ if f$edit(ans1,"UPCASE") .eqs. "C" then return
$ goto get_respons
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$ make_zip_name:
$!
$ fname = "RCMO-''thisnode'-''tim'" 
$! 
$! If invoked non-interactively, rename the .Home file to reflect the latest collection time
$! 
$ if f$mode() .nes. "INTERACTIVE"
$ then
$      hfil = f$search("RCM$DATA:*.home",3) 
$      if hfil .nes. ""
$      then
$         rename 'hfil RCM$DATA:'fname'.home
$         define/system/nolog RCM$HOMEFILE 'f$search("RCM$DATA:*.home",4) 
$      else
$        err_msg = "No RCM$DATA:*.HOME file found! (in make_zip_name)"
$        goto error_exit
$      endif
$ endif
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$get_nodes:
$ count = 0
$ write sys$output ""
$ write sys$output "Selecting Nodes to run RCM collection"
$ write sys$output ""
$ write rcm_log "Getting list of nodes:"
$ no_node_selected = 1
$ if f$getsyi("CLUSTER_MEMBER") .eqs. "TRUE" 
$ then 
$     show device/full/out=tmpdev.tmp 'rcm_device'
$     context = ""
$     start:
$      id = f$csid (context)
$      if id .eqs. "" then goto end_csid
$      node = F$GETSYI("NODENAME",,id)
$      machine_name = f$getsyi("HW_NAME", "''node'")
$      node6 = f$extract(0, 6, node + "      ")
$      write rcm_log "''node'"
$      if node .eqs. thisnode                                          
$      then
$        status = 1
$      else
$        define/user sys$output NL:   !suppress 'no strings matched' message
$        define/user sys$error NL:    !
$        search/nooutput/nolog tmpdev.tmp "''node',", "''node'."   ! search for NODE, or NODE.
$        status = $status
$      endif
$      if status .eq. 1 
$      then
$        gosub is_rcmrunning
$        if f$search("rcmr.tmp") .nes. "" then delete rcmr.tmp;*
$        if rcmrunning .eq. 1
$        then
$           write sys$output "Node ''node' cannot be selected, already has RCM process running."
$           goto start
$        endif
$        alph = f$getsyi("HW_MODEL", "''node'") .ge. 1024
$        if f$locate("AlphaServer", machine_name) .ne. f$length(machine_name)
$        then
$          modl = f$extract(f$locate("AlphaServer", machine_name)+12, 5, machine_name)
$          modl = f$edit(f$extract(0, f$locate(" ", modl), modl), "upcase")
$        endif
$        modl = " ''modl' "
$!
$!  if this is a Rawhide/Tincup/Turbolaser then the FRU should be available - currently FRU table 4
$!
$        if f$locate(modl, models) .ne. f$length(models) then fru_ver = "040"
$        ans4 = ""
$        if node .eqs. thisnode
$        then
$          write sys$output "''node6' : (''machine_name'). This node must be selected."
$          ans4 = "Y"
$        else 
$          nodesel:
$          ans4 = ""
$          read/end=cfg_exit/prompt="''node6' : (''machine_name'). Do you want to select Node ''node' ? <[Y]/N> " sys$command ans4
$          ans4 = f$extract(0,1,ans4)
$          if ans4 .eqs. "?"
$          then
$             gosub node_select_help
$             goto nodesel
$          endif
$        endif
$        if f$edit(ans4,"UPCASE") .eqs. "Y" .or. ans4 .eqs. "" 
$        then
$          count = count+1
$          node_'count' = node
$          no_node_selected = 0
$        endif
$      else
$        write rcm_log "''node6' : (''machine_name') does not have ''rcm_device' mounted - skipping"
$        write sys$output "''node6' : (''machine_name') does not have ''rcm_device' mounted - skipping"
$      endif
$      GOTO start
$ else
$   write rcm_log "''thisnode' : (''machine_name') (standalone)"
$   node_1 = thisnode
$   no_node_selected = 0
$   count = 1
$ endif
$ end_csid:
$ if no_node_selected
$ then
$   write sys$output "No Nodes Selected"
$   goto finish_up
$ endif
$ write sys$output ""
$ tempcount = 1
$ nodeloop:
$ if tempcount .gt. count then goto here
$ node = node_'tempcount'
$ if tempcount .eq. 1 
$ then 
$   node_string = "''node'"
$ else
$   node_string = "''node_string',''node'"
$ endif
$ tempcount = tempcount + 1
$ goto nodeloop
$ here:
$ if f$search("RCM$DATA:''cfg_file'") .nes. ""
$ then
$   item = "[NODES]"
$   var = node_string
$   define/user sys$output NLA0:
$   define/user sys$error NLA0:
$   search RCM$DATA:'cfg_file' "[NODES]", "''node_string'"/match=and
$   if $status .ne. 1 then gosub update_cfg_file
$ endif
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$ create_decevent_com:
$ sys_login = f$trnlnm("sys$login")
$ open/write/error=error_6 diag_tmp RCM$DIR:TMP_RCM_DIAG.COM
$ write diag_tmp "$node = F$GETSYI(""NODENAME"")" 
$ write diag_tmp "$define sys$login ''sys_login'"
$ write diag_tmp "$if p1 .eqs. """" then p1 = ""SYS$ERRORLOG:ERRLOG.SYS"""
$ write diag_tmp "$diagnose/translate/include=config/reverse/output=rcm_decevent_'node'.txt 'p1'" 
$ write diag_tmp "$exit"
$ close diag_tmp
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$create_sysman_file:
$ write rcm_log "Creating RCM$DIR:RCM_SYSMAN_TMP.COM"
$ open/write/error=error_6 sysman_tmp RCM$DIR:RCM_SYSMAN_TMP.COM
$ write sysman_tmp "$write sys$output ""Running SYSMAN"" "
$ write sysman_tmp "$MCR SYSMAN"
$ gosub get_node_list
$ write sysman_tmp "SET TIMEOUT 00:00:30"
$ write sysman_tmp "SET PROFILE/PRIV=(''prvs')/DEFAULT=RCM$DATA"       
$ write sysman_tmp "do run/detach/PAGE=300000/IO_BUFF=170000/prior=4/input=RCM$DIR:RCM_COLLECT.COM/out=RCMO-''thisnode'-''tim'.LOG -"
$ write sysman_tmp "/proc=""RCM_COLLECT""/time_l=00:30 sys$system:loginout"
$ write rcm_log "added SYSMAN commands for ''thisnode'"
$ sysman_loop:
$ if tmpcount .gt. count then goto end_sysman
$ sysman_node = node_'tmpcount'
$ if sysman_node .eqs. "" then goto end_sysman
$ dlay = tmpcount * 3    !to stagger each process by 3 seconds
$ mns = dlay/60		
$ scs = dlay - mns*60          
$ dlay = "00:" +  "''f$fao("!2ZL", mns)'" + ":" + "''f$fao("!2ZL", scs)'"
$ if node_'tmpcount' .nes. thisnode 
$ then 
$	write sysman_tmp "SET ENVIRONMENT/NODES=(''sysman_node')"
$  	write sysman_tmp "SET TIMEOUT 00:00:30"
$  	write sysman_tmp "SET PROFILE/PRIV=(''prvs')"       
$       write sysman_tmp "DO DEFINE/SYSTEM/NOLOG RCM$DIR ''rcmdirlog'"
$       write sysman_tmp "DO DEFINE/SYSTEM/NOLOG/TRANSLATE=CONCEALED RCM$ROOT ''rcmroot'" !make sure RCM$ROOT is defined correctly
$       write sysman_tmp "DO DEFINE/SYSTEM/NOLOG RCM$DATA ''rcmdata'"    !make sure RCM$DATA is defined correctly
$       write sysman_tmp "DO DEFINE/SYSTEM/NOLOG RCM$NODE ''installnode'" 
$  	write sysman_tmp "SET PROFILE/DEFAULT=RCM$DATA"       
$  	write sysman_tmp "do run/detach/PAGE=300000/IO_BUFF=170000/prior=4/input=RCM$DIR:RCM_COLLECT.COM/out=RCMO-''sysman_node'-''tim'.LOG -"
$  	write sysman_tmp "/proc=""RCM_COLLECT""/delay=''dlay'/time_l=00:30 sys$system:loginout"
$  	write rcm_log "added SYSMAN commands for ''sysman_node'"
$ endif
$ tmpcount = tmpcount+1
$ goto sysman_loop
$ end_sysman:
$ close sysman_tmp
$ purge RCM$DIR:RCM_SYSMAN_TMP.COM
$return
$!
$!--------------------------------------------------------------------------------------------
$!
$create_home_file:
$ homefile = "''fname'.HOME"
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ delete/log RCM$DATA:*.home;*
$ open/write/error=error_6  hfil RCM$DATA:'homefile'
$ write hfil "''thisnode'"
$ write hfil "''node_string'"
$ write hfil "''cfg_file'"
$ close hfil
$ tmp = f$search("RCM$DATA:''homefile'")
$ define/system/nolog RCM$HOMEFILE 'tmp'
$ return
$!
$!----------------------------------------------------------------------------------------------
$!
$ check_for_frequency:
$   search/out=tmpcfg.tmp/window=(0,2) RCM$DATA:'cfg_file' "[COLLECTION FREQUENCY]"
$   if f$search("tmpcfg.tmp") .eqs. ""
$   then
$      write sys$output "[COLLECTION FREQUENCY] missing from cfg file ''cfg_file'"
$      return
$   endif
$   open/read tmpfil tmpcfg.tmp
$   read/end=endtmpfil tmpfil tmprec
$   freq = f$edit(tmprec, "upcase, compress, trim")
$   read/end=endtmpfil tmpfil tmprec
$   nextime = f$edit(tmprec, "compress, trim")
$   endtmpfil:
$   close tmpfil
$   delete tmpcfg.tmp;
$!
$   rbracket = f$locate("]", freq)+1
$   semic = f$locate(";",freq)
$   semic = semic - rbracket
$   freq = f$edit(f$extract(rbracket, semic, freq), "TRIM")
$   if f$locate(f$extract(0,1,freq), "NDWMQ") .ne. f$len("NDWMQ") then freq = f$extract(0, 1, freq)
$!
$   rbracket = f$locate("]", nextime)+1
$   semic = f$locate(";",nextime)
$   semic = semic - rbracket
$   nextime = f$edit(f$extract(rbracket, semic, nextime), "TRIM")
$!
$   if freq .eqs. "N"       !PTR 36-4-414
$   then
$      freq = ""
$      define sys$output NLA0:
$      define sys$error NLA0: 
$      tsttime = f$cvtime(nextime, "absolute")
$      stat = $status
$      deass sys$output
$      deass sys$error
$      if (stat .and. 1) .EQ. 0 then nextime = f$time()
$   endif
$ return
$!
$!---------------------------------------------------------------------------------------------
$!
$ schedule_collections:
$  if f$loc("]", nextime) .ne. f$len(nextime) 
$  then 
$     rbracket = f$locate("]", nextime)+1
$     semic = f$locate(";",nextime)
$     semic = semic - rbracket
$     nextime = f$edit(f$extract(rbracket, semic, nextime), "TRIM")
$  endif
$  if freq .ne. "" .and. f$loc(f$edit(freq, "UPCASE"), "DWMQ") .ne. f$len("DWMQ")
$  then 		!get the next scheduled date from cfg file
$       nextime = f$cvtime(nextime, "absolute")
$       if ($status .and. 1) .eq. 0 
$       then 
$          write sys$output "Error in nextime"
$       endif
$  else	! freq must be a delta time
$       if nextime .eqs. "" then nextime = f$cvtime("''f$time()'" + "+" +"''freq'", "absolute")
$  endif
$ if freq .nes. "" .or. run_on_reboot .eq. "Y" ! [COLLECTION FREQUENCY] value must be filled in if future collections are required
$ then
$   if f$mode() .eqs. "INTERACTIVE"
$   then       !Check if rcm$startup_'installnode'.com is in SYSMAN Startup database
$	write sys$output ""
$	write sys$output "Adding RCM to SYSMAN STARTUP Database so that RCM Collection schedule will"
$	write sys$output "be maintained when the system reboots."
$	err_msg = "Error writing SYS$STARTUP:RCM$STARTUP_''installnode'.COM"
$	open/write/error=error_exit rcmsysman SYS$COMMON:[SYS$STARTUP]RCM$STARTUP_'installnode'.COM
$	rcmdir = f$trnlnm("RCM$DIR")
$	rcmroot = f$trnlnm("RCM$ROOT")
$	rcmcfg = f$trnlnm("RCM$CONFIGFILE")
$	rcmhme = f$trnlnm("RCM$HOMEFILE")
$	write rcmsysman "$!"
$	write rcmsysman "$!SYS$COMMON:[SYS$STARTUP]RCM$STARTUP_''thisnode'.COM"
$	write rcmsysman "$!This procedure was generated by RCM$DIR:RCM_START.COM ''rcm_ver' on ''f$time()' (''thisnode')"
$	write rcmsysman "$!"
$	write rcmsysman "$!The purpose of this procedure is to preserve the RCM Collection Schedule when the system reboots"
$	write rcmsysman "$!"
$	write rcmsysman "$define/system/nolog RCM$DIR ''rcmdir'"
$	write rcmsysman "$define/system/nolog/translate="CONCEALED" RCM$ROOT ''rcmroot'"
$	write rcmsysman "$define/system/nolog RCM$CONFIGFILE ''rcmcfg'"
$	write rcmsysman "$define/system/nolog RCM$HOMEFILE ''rcmhme'"
$	write rcmsysman "$define/system/nolog RCM$DATA ''coll_dir'"
$	write rcmsysman "$define/system/nolog RCM$NODE ''installnode'"
$	write rcmsysman "$curdir = f$environment(""default"")"
$	write rcmsysman "$set def ''coll_dir'"
$	write rcmsysman "$run/detach/prior=4/inp=RCM$DIR:RCM_START.COM/out=RCM$DATA:RCM_START.LOG/del=00:10/proc=""RCMSTART""/time_l=00:30 sys$system:loginout"
$	write rcmsysman "$set default 'curdir'"
$	write rcmsysman "$exit"
$	close rcmsysman
$	copy SYS$STARTUP:RCM$STARTUP_'installnode'.COM RCM$DIR:RCM$STARTUP_'installnode'.TMP !temp copy
$	purge/nolog SYS$STARTUP:RCM$STARTUP_'installnode'.COM
$	purge/nolog RCM$DIR:RCM$STARTUP_'installnode'.TMP
$ 	define/user sys$output NLA0:
$ 	define/user sys$error NLA0:
$ 	MCR SYSMAN STARTUP SHOW FILE RCM$STARTUP_'node'.COM
$ 	if ($STATUS .and. 1) 
$ 	then
$             MCR SYSMAN STARTUP REMOVE FILE RCM$STARTUP_'installnode'.COM
$	endif
$       MCR SYSMAN STARTUP ADD FILE RCM$STARTUP_'installnode'.COM/nodes=('node_string')
$       MCR SYSMAN STARTUP SHOW FILE
$   endif
$ endif
$!
$!  if interactive or invoked via SYSMAN STARTUP, the date in the cfg file is used directly, otherwise add the delta
$!
$   updateflag = 0
$   passed = 0
$   gosub calc_next_time
$!
$!   if this is the RCM process, change the process name to avoid duplicate process name
$!
$   rcmproc  = 0
$   rcmprocname = 0
$   if f$getjpi("", "prcnam") .eqs. "RCM" 
$   then 
$       set process/name="RCM1"
$       rcmprocname = 1                  !flag to tell this is the scheduled RCM process
$       updateflag = 1
$   else
$       rcmcontext = ""   !check if the RCM process is already running (other than this process)
$       rcmstart:
$       PID = F$PID(CONTEXT)
$       IF PID .EQS. "" THEN goto end_rcmproc
$       if f$getjpi(pid,"prcnam") .eqs. "RCM"   !PTR36-4-496 19-Feb-1999
$       then 
$         rcmproc = 1
$         write sys$output ""
$         write sys$output "RCM Scheduling process is already running! Process ID = ''pid'" 
$         goto end_rcmproc
$       endif
$       goto rcmstart
$       end_rcmproc:
$   endif
$   if rcmproc .eq. 0
$   then 
$      if freq .nes. "" .or. passed .eq. 0 
$      then
$        if f$mode() .eqs. "INTERACTIVE"
$        then 
$           write sys$output ""
$           write sys$output "Scheduling next collection at: ''nextime'" 
$           write sys$output ""
$        endif
$        write rcm_log "Scheduling next collection at: ''nextime'" 
$        run/detach/prior=4/inp=RCM$DIR:RCM_START.COM/out=RCM$DATA:RCM_START.LOG/sched="''nextime'"/proc="RCM"/tim=00:30 sys$system:loginout
$        write sys$output ""
$        if passed .eq. 0 .and. f$mode() .eqs. "INTERACTIVE" 
$        then
$            write sys$output "To collect RCM data now, use @RCM$DIR:RCM_START -now"
$            write sys$output ""
$        endif
$      endif
$   else
$     err_msg = "RCM Process is already running"
$     goto error_exit
$   endif
$!
$!  don't update the .cfg file if interactive unless the [next coll..] field is empty, the cfg file should have next time correct.
$!
$   item = "[NEXT COLLECTION TIME]"
$   var = nextime
$   if f$mode() .nes. "INTERACTIVE" 
$   then 
$      if rcmprocname .eq. 1 then gosub update_cfg_file  !only update the cfg file if started from RCM process
$   else
$      if updateflag .eq. 1 then gosub update_cfg_file
$   endif
$ return
$!
$!-------------------------------------------------------------------------------------------------
$!
$ run_now:
$ write sys$output ""
$ write sys$output "Starting detached jobs on selected nodes: ''node_string'"
$ write sys$output ""
$ write rcm_log "Starting detached jobs on selected nodes, ''node_string'."
$ close rcm_log 
$ gosub delete_old_files   		! moved here to only delete old files when actually starting collection
$ @RCM$DIR:RCM_SYSMAN_TMP.COM/output=RCM$DATA:RCM_SYSMAN_TMP.LOG
$ convert RCM$DATA:RCM_START_'thisnode'.LOG, RCM$DATA:RCM_SYSMAN_TMP.LOG RCM$DATA:RCM_TMP.LOG
$ rename RCM$DATA:RCM_TMP.LOG RCM$DATA:RCM_START_'thisnode'.LOG  
$ delete RCM$DATA:RCM_SYSMAN_TMP.LOG;
$ purge RCM$DATA:RCM_START_'thisnode'.LOG
$!
$ show system/nodes=('node_string')/process="RCM_COLLECT"   !only show the RCM_COLLECT Processes
$ write sys$output ""
$ write sys$output "When collection is complete, data will be Zipped to ''fname'.ZIP"
$ if f$edit(p2, "UPCASE") .eqs. "-SETUP" then return        	  	  
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ delete tmpdev.tmp;*, nodes.tmp;*, cfg.tmp;*
$ if f$mode() .eqs. "INTERACTIVE"
$ then
$   ans = "Y"
$   write sys$output ""
$   write sys$output "In case of problems, all RCM processes can be stopped by executing RCM$DIR:RCM_STOP.COM"
$   write sys$output ""
$   ans = ""
$   read/end=cfg_exit/prompt= "Do you want to run RCM$DIR:RCM_STATUS now (to monitor progress of collection) ([Y]/N)? " sys$command ans
$   if ans .eqs. "" then ans = "Y"
$   if f$edit(ans, "UPCASE") .eqs. "Y" 
$   then
$      @RCM$DIR:RCM_STATUS.COM
$   endif
$ endif
$ return
$!
$!---------------------------------------------------------------------------------------------
$!
$error_1:
$ write sys$output "Error opening RCM_START_''thisnode'.LOG for writing"
$ goto finish_up
$!
$!--------------------------------------------------------------------------------------------
$error_2:
$ write sys$output "Error opening ''cfg_file' for writing"
$ goto finish_up
$!
$!--------------------------------------------------------------------------------------------
$!
$error_3:
$ write sys$output "Error opening ''cfg_file' for reading"
$ goto finish_up
$!
$!--------------------------------------------------------------------------------------------
$!
$error_5:
$ write sys$output "Error opening ''cfg_file'1 for writing"
$ goto finish_up
$!
$!---------------------------------------------------------------------------------------------
$!
$error_6:
$ write sys$output "Error opening file for writing. Status = ''$status'"
$ goto finish_up
$!
$!--------------------------------------------------------------------------------------------
$!
$get_node_list:
$! write sys$output "get_node_list"
$ tmpcount = 1
$ count = 0
$ node_string = f$edit(node_string, "compress,collapse")
$ tmpndes = node_string
$ removecomma:
$   if f$loc(",", tmpndes) .eq. f$len(tmpndes) then goto endremove
$   tmpndes = tmpndes - ","
$   goto removecomma
$ endremove:
$ count = f$len(node_string) - f$len(tmpndes) + 1   !Number of Nodes in node_string
$ tmpcnt = 1
$! write sys$output ""
$ ndeloop:
$   node_'tmpcnt' = f$element(tmpcnt-1, ",", node_string)
$   tmpn = node_'tmpcnt'
$   tmpcnt = tmpcnt + 1
$   if tmpcnt .gt. count then goto endndeloop
$ goto ndeloop
$ endndeloop:
$ return
$!
$!--------------------------------------------------------------------------------------
$!
$ error_exit:
$ write sys$output ""
$ write sys$output err_msg
$ write sys$output ""
$ write rcm_log err_msg
$ close rcm_log 
$ if f$edit(error_email, "UPCASE") .nes. "<NOT_DEFINED>" .and. error_email .nes. ""
$ then
$   if f$locate("@", error_email) .ne. f$len(error_email) 
$   then 
$     if f$edit(f$trnlnm("MAIL$INTERNET_TRANSPORT"),"upcase") .eqs. "SMTP"    !PTR 91-21-121
$     then 
$        mail/subj="''err_msg'" NLA0: 'error_email'           
$     else
$        mail/subj="''err_msg'" NLA0: smtp%"''error_email'"  
$     endif
$   else
$     mail/subj="''err_msg'" NLA0: 'error_email'  
$   endif
$ endif
$ goto finish_up
$!
$!------------------------------------------------------------------------
$!
$ update_cfg_file:
$!     write sys$output "Updating the CFG file to ''var'"
$!     write rcm_log "Updating the CFG file to ''var'"
$     open/read/error=error_3 oldcfg 'cfg_file'
$     open/write/error=error_5 newcfg 'cfg_file'1
$     readcfgfile:
$       read/end=end_cfgf oldcfg line
$       !  copy every line to a new version of the file, except the [<item>] line which is updated
$       if f$locate("''item'", line) .ne. f$len(line)
$       then
$         item = f$extract(0,22,"''item'                     ")
$         write newcfg "''item'                ''var'"
$       else
$         write newcfg line
$       endif
$       goto readcfgfile
$    end_cfgf:
$    close oldcfg
$    close newcfg
$    rename 'cfg_file'1 'cfg_file'
$    return
$!
$!--------------------------------------------------------------------------------------------
$!
$ calc_next_time:
$ search RCM$DATA:'cfg_file' "[NEXT COLLECTION TIME]"/out=nextcoll.tmp
$ if f$search("nextcoll.tmp") .eqs. "" 
$ then
$   write rcm_log "Error in CFG file - no [NEXT COLLECTION TIME] found"
$   write sys$output "Error in CFG file - no [NEXT COLLECTION TIME] found"
$   return
$ endif
$ open/read nextcoll nextcoll.tmp
$ read nextcoll line
$ close nextcoll
$ delete nextcoll.tmp;
$ rbracket = f$locate("]",line)+1
$ semic = f$locate(";",line)
$ semic = semic - rbracket
$ nxt = f$edit(f$extract(rbracket, semic, line), "TRIM")
$ if nxt .eqs. "" .or. f$edit(nxt, "UPCASE") .eqs. "<NOT_DEFINED>" 
$ then 
$     nxt = f$time()
$     passed = 1
$     updateflag = 1
$ else
$    tmpdate = f$cvtime(nxt, "comparison")
$    tmpnxt = nxt
$    now = f$cvtime(f$time(), "comparison")
$    if now .gts. tmpdate 
$    then 
$      nxt = f$time()
$      write sys$output ""
$      write sys$output "Entered time, ''tmpnxt', has passed! Using current time ''nxt'"
$      passed = 1
$      updateflag = 1
$    endif
$ endif
$ if updateflag .eq. 0
$ then
$   nextime = nxt
$   return
$ endif
$ freq = f$edit(freq, "UPCASE")
$ add_time = freq
$ if freq .eqs. "D" then add_time = "1-00:00"
$ if freq .eqs. "W" then add_time = "7-00:00"
$ if freq .eqs. "M" then incm = 0
$ if freq .eqs. "Q" then incm = 2
$ if freq .eqs. "M" .or. freq .eqs. "Q"
$ then
$    mns = "-JAN- -FEB- -MAR- -APR- -MAY- -JUN- -JUL- -AUG- -SEP- -OCT- -NOV- -DEC- -JAN- -FEB- -MAR- "
$    d = f$cvtime(nxt,,"day")
$    if d .gt. 28 then d = 28  !PTR 36-4-1163 - avoid getting bad dates!
$    m = f$cvtime(nxt,,"month")
$    y = f$cvtime(nxt,,"year")
$    nm = f$ele(m + incm, " ", mns)
$    if (m + incm) .ge. 12 then y = y + 1
$    hh = f$cvtime(nxt,,"hour")
$    mm = f$cvtime(nxt,,"minute")
$    nextime = "''d'" + "''nm'" + "''y'" + " ''hh'" + ":" + "''mm'"
$ else
$    nextime = f$cvtime("''nxt'" + "+" + "''add_time'", "absolute")
$ endif
$ return
$!
$!-----------------------------------------------------------------------------------
$!
$  get_item_from_cfg:
$  search/out=ctmp.tmp RCM$DATA:'cfil' "''item'"
$   if $status .eq. 1
$   then
$     open/read ctmp ctmp.tmp 
$     read ctmp line
$     close ctmp
$     rbracket = f$locate("]",line)+1
$     semic = f$locate(";",line)
$     semic = semic - rbracket
$     value = f$edit(f$extract(rbracket, semic, line), "TRIM")
$   endif
$   delete ctmp.tmp;
$  return
$!
$!------------------------------------------------------------------------------
$!
$ get_next_time:
$   item = "[NEXT COLLECTION TIME]"
$   h = f$search("RCM$DATA:*.home",6)
$   if h .nes. ""
$   then
$     open/read hfil 'h
$     read hfil line
$     read hfil line
$     read hfil cfil
$     close hfil
$   endif
$   gosub get_item_from_cfg
$ return
$!
$!------------------------------------------------------------------------------------------------------------
$!
$edit_config:
$!
$ write sys$output ""
$ write sys$output "To update an item in the configuration file, enter a new value at the prompt"
$ write sys$output "or <cr> to keep the existing value."
$ write sys$output ""
$ write sys$output "Enter '?' to get help at any prompt or 'X' to finish editing."
$ write sys$output ""
$!
$ cnam = f$parse("''cfg_file'",,,"name")
$ ctyp = f$parse("''cfg_file'",,,"type")
$ outcfg = cnam + ctyp + "_tmp"
$ cfg_file = cnam + ctyp      ! get rid of version number
$ create 'outcfg'
$ open/append outf 'outcfg'
$ prmt = "[COMPANY NAME]                      : ''cmpy_name' : "
$ ed_company_name:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub cmpy_name_help
$    goto ed_company_name
$ endif
$ if ans1 .nes. "" then cmpy_name = ans1
$ prmt = "[CONTACT NAME]                      : ''cmpy_c' : "
$ ed_contact_name:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub cmpy_c_help
$    goto ed_contact_name
$ endif
$ if ans1 .nes. "" then cmpy_c = ans1
$ prmt = "[CONTACT TELEPHONE]                 : ''cmpy_tel' : "
$ ed_contact_telephone:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub cmpy_tel_help
$    goto ed_contact_telephone
$ endif
$ if ans1 .nes. "" then cmpy_tel = ans1
$ prmt = "[CONTACT EMAIL]                     : ''cmpy_email' : "
$ ed_contact_email:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub cmpy_email_help
$    goto ed_contact_email
$ endif
$ if ans1 .nes. "" then cmpy_email = ans1
$ prmt = "[ACCOUNT MANAGER]                   : ''tam_name' : "
$ ed_account_manager:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub tam_name_help
$    goto ed_account_manager
$ endif
$ if ans1 .nes. "" then tam_name = ans1
$ tam:
$ prmt = "[ACCOUNT MANAGER EMAIL]             : ''tam_email' : "
$ ed_manager_email:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub tam_email_help
$    goto ed_manager_email
$ endif
$ if ans1 .nes. "" then tam_email = ans1
$ uptam_email = f$edit(tam_email, "UPCASE")
$ if f$locate("COMPAQ.COM", uptam_email) .eq. f$length(uptam_email)  
$ then
$       write sys$output ""
$       write sys$output "[ACCOUNT MANAGER EMAIL] - must be a Compaq address" 
$       write sys$output ""
$       goto tam
$ endif
$ prmt = "[CUSTOMER ACCESS ID]                : ''cust_id' : "
$ ed_access_id:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub cust_id_help
$    goto ed_access_id
$ endif
$ if ans1 .nes. "" then cust_id = ans1
$ cust_id =f$edit(cust_id, "UPCASE")
$ badcust = 0
$ gosub check_custid_format
$ if badcust .eq. 1 
$ then 
$   write sys$output ""
$   write sys$output "Customer Access ID must contain Alphanumeric characters or '-', '_', '.'"
$   write sys$output "This is an important field. If you do not know what accessID to use for"
$   write sys$output "this system please ask your Compaq Support Representative."
$   write sys$output ""
$   goto ed_access_id
$ endif
$ prmt = "[TRANSPORT OPTION]                  : ''trans' : "
$ ed_transport_option:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub trans_help
$    goto ed_transport_option
$ endif
$ if ans1 .nes. "" then trans = ans1
$ trans = f$edit(f$extract(0,1,trans), "UPCASE")
$ if f$loc(trans, "FEDM") .eq. f$len("FEDM") 
$ then 
$   write sys$output "Transport Option must be either FTP, Email, DSNlink, or Manual (F/E/D/M) ! "
$   goto ed_transport_option 
$ endif
$ if trans .eqs. "F" then trans = "FTP"
$ if trans .eqs. "E" then trans = "EMAIL"
$ if trans .eqs. "D" then trans = "DSNLINK"
$ if trans .eqs. "M" then trans = "MANUAL TRANSPORT"
$!
$ prmt = "[COLLECTION FREQUENCY]              : ''coll_freq' : "
$ ed_collection_frequency:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub coll_freq_help
$    goto ed_collection_frequency
$ endif
$ if ans1 .nes. "" then coll_freq = ans1
$ if f$loc(f$edit(f$extract(0,1,coll_freq),"UPCASE"), "NDWMQ") .eq. f$len("NDWMQ") 
$ then 
$  	tmp = f$cvtime(coll_freq, "delta")
$  	if ($status .and. 1) then goto nxt_time
$       goto ed_collection_frequency 
$ endif
$ coll_freq = f$edit(f$extract(0,1,coll_freq), "UPCASE")
$ if coll_freq .eqs. "D" then coll_freq = "DAILY"
$ if coll_freq .eqs. "W" then coll_freq = "WEEKLY"
$ if coll_freq .eqs. "M" then coll_freq = "MONTHLY"
$ if coll_freq .eqs. "Q" then coll_freq = "QUARTERLY"
$ if coll_freq .eqs. "N" then coll_freq = "NONE"
$!
$ prmt = "[NEXT COLLECTION TIME]              : ''nextime' : "
$ ed_next_collection:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub nxtcoll_help
$    goto ed_next_collection
$ endif
$ if ans1 .nes. "" then nextime = ans1
$ if nextime .eqs. "" then nextime = f$time()
$ if f$edit(nextime, "UPCASE") .eqs. "<NOT_DEFINED>" then nextime = f$time()
$ define sys$output NLA0:
$ define sys$error NLA0:
$ nex = f$cvtime(nextime, "absolute")
$ stat = $status
$ deass sys$output
$ deass sys$error
$ if (stat .and. 1) .EQ. 0 
$ then 
$    write sys$output "Invalid Time Format, use Absolute time format (DD-MMM-YYYY HH:MM)"
$    goto ed_next_collection
$ endif
$!
$ prmt = "[MAX ARCHIVES]                      : ''max_archives' : " 
$ ed_max_archives:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ ans1 = f$edit(ans1, "upcase,collapse,compress,trim")
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub max_archives_help
$    goto ed_max_archives
$ endif
$ if ans1 .nes. "" then max_archives = ans1
$!
$ prmt = "[ARCHIVE DIRECTORY]                 : ''archive_dir' : " 
$ ed_archive_directory:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ ans1 = f$edit(ans1, "upcase,collapse,compress,trim")
$ if f$edit(ans1, "UPCASE") .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub archive_dir_help
$    goto ed_archive_directory
$ endif
$ if ans1 .nes. "" then archive_dir = ans1
$!
$ prmt = "[COLLECTION DIRECTORY]              : ''coll_dir' : " 
$ ed_collection_directory:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ ans1 = f$edit(ans1, "upcase,collapse,compress,trim")
$ if ans1 .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub coll_dir_help
$    goto ed_collection_directory
$ endif
$ if ans1 .nes. "" then coll_dir = ans1
$ gosub get_dir_spec
$ if invalid_dir .eqs. "TRUE"
$ then
$   ans = ""
$   read/end=cfg_exit/prompt="Directory ''coll_dir' does not exist: Create it [Y]/N : " sys$command ans
$   if ans .eqs. "" then ans = "Y"
$   if f$edit(ans, "upcase") .eqs. "Y"
$   then
$      create/dir 'coll_dir'
$      if ($status .and. 1) .eq. 0 then goto ed_collection_directory
$   else
$      goto ed_collection_directory
$   endif
$ endif
$ olddir = f$environment("default")
$ olddev = f$getdvi(f$parse(olddir,,,"device"),"logvolnam")
$ olddirect = f$parse(olddir,,,"directory","no_conceal") - "]["
$ set default 'coll_dir'
$ newdir = f$environment("default")
$ ndev = f$getdvi(f$parse(newdir,,,"device"),"logvolnam")
$ ndir = f$parse(newdir,,,"directory","no_conceal") - "]["
$ if ndev .nes. olddev .or. ndir .nes. olddirect 
$ then
$   write sys$output "Warning: Changing RCM$DATA directory from ''olddir' to ''newdir'"
$   define/system RCM$DATA 'newdir'
$ endif
$!
$ prmt = "[FTP PROCEDURE]                     : ''ftp_procedure' : " 
$ ans1 = ""
$ ed_ftp_procedure:
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ ans1 = f$edit(ans1, "collapse,compress,trim")
$ if ans1 .eqs. "" .and. f$len(ftp_procedure) .gt. 1 then ans1 = ftp_procedure
$ if ans1 .eqs. "" then ftp_procedure = ans1
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$     gosub ftp_proc_help
$     goto ed_ftp_procedure
$ endif
$ if f$edit(ans1, "upcase") .eqs. "X" then goto ed_writecfg
$ if ans1 .nes. "" then ftp_procedure = ans1
$!
$ prmt = "[LOCAL SITE]                        : ''local_site' : " 
$ ed_local_site:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ ans1 = f$edit(ans1, "upcase,collapse,compress,trim")
$ if ans1 .nes. "" .and. ans1 .nes. "X" then local_site = ans1
$ if ans1 .eqs. "" then ans1 = local_site 
$ if ans1 .eqs. "?" .or. (ans1 .nes. "N" .and. ans1 .nes. "Y" .and. ans1 .nes. "X")
$ then
$    gosub local_site_help
$    goto ed_local_site
$ endif
$ if ans1 .eqs. "X" then goto ed_writecfg
$ if local_site .eqs. "N"
$ then
$    local_trans = ""
$    local_email = ""
$    local_host = ""
$    local_login = ""
$    local_password = ""
$    local_dir = ""
$    local_ftpproc = ""
$ else
$    local_site = "Y"
$    if local_trans .eqs. "" then local_trans = "F"
$    prmt = "[LOCAL TRANSPORT OPTION]            : ''local_trans' : " 
$    ed_local_transport:
$    ans1 = ""
$    read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$    ans1 = f$edit(ans1, "upcase,collapse,compress,trim")
$    if ans1 .eqs. "X" then goto ed_writecfg
$    if ans1 .eqs. "?"
$    then
$       gosub local_trans_help
$       goto ed_local_transport
$    endif
$    if ans1 .nes. "" then local_trans = ans1
$    if ans1 .eqs. "" then ans1 = local_trans 
$    if f$loc(f$extract(0, 1, local_trans), "FED") .eq. f$len("FED") 
$    then 
$      write sys$output "Local Transport Option must be FTP, Email or DECnet"
$      goto ed_local_transport
$    endif
$    local_tr = f$extract(0, 1, local_trans)
$    if local_tr .eqs. "E"
$    then
$       local_host = ""
$       local_login = ""
$       local_password = ""
$       local_dir = ""
$       prmt = "[LOCAL EMAIL ADDRESS]               : ''local_email' : " 
$       ans1 = ""
$       read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$       ans1 = f$edit(ans1, "collapse,compress,trim")
$       if f$edit(ans1, "upcase") .eqs. "X" then goto ed_writecfg
$       if ans1 .nes. "" then local_email = ans1
$    else
$       local_email = ""
$       ed_lcl_host:
$       prmt = "[LOCAL HOSTNAME]                    : ''local_host' : " 
$       ans1 = ""
$       read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$       ans1 = f$edit(ans1, "collapse,compress,trim")
$       if ans1 .nes. "" then local_host = ans1
$       if f$extract(0,1,ans1) .eqs. "?"
$       then
$          gosub local_host_help
$          goto ed_lcl_host
$       endif
$       if f$edit(ans1, "upcase") .eqs. "X" then goto ed_writecfg
$       prmt = "[LOCAL LOGIN]                       : ''local_login' : " 
$       ed_lcl_login:
$       ans1 = ""
$       read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$       ans1 = f$edit(ans1, "collapse,compress,trim")
$       if ans1 .nes. "" then local_login = ans1
$       if f$extract(0,1,ans1) .eqs. "?"
$       then
$          gosub local_login_help
$          goto ed_lcl_login
$       endif
$       if f$edit(ans1, "upcase") .eqs. "X" then goto ed_writecfg
$       gosub get_pass
$       prmt = "[LOCAL UPLOADDIR]                   : ''local_dir' : " 
$       ans1 = ""
$       ed_lcl_ftpdir:
$       read/end=edt_exit/prompt= "''cr'''lf'''prmt'" sys$command ans1
$       if f$extract(0,1,ans1) .eqs. "?"
$       then
$          gosub local_dir_help
$          goto ed_lcl_ftpdir
$       endif
$       if f$edit(ans1, "upcase") .eqs. "X" then goto ed_writecfg
$       if ans1 .nes. "" then local_dir = ans1
$       if ans1 .eqs. "" then ans1 = local_dir 
$       local_dir = f$edit(local_dir, "collapse,compress,trim")
$       if local_dir .eqs. "." then local_dir = ""
$       prmt = "[LOCAL FTP PROCEDURE]               : ''local_ftpproc' : " 
$       ans1 = ""
$       ed_lcl_ftpproc:
$       read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$       ans1 = f$edit(ans1, "collapse,compress,trim")
$       if ans1 .eqs. "" then local_ftpproc = ans1
$       if ans1 .eqs. "" .and. f$len(local_ftpproc) .gt. 1 then ans1 = local_ftpproc
$       if f$extract(0,1,ans1) .eqs. "?"
$       then
$          gosub local_ftpproc_help
$          goto ed_lcl_ftpproc
$       endif
$       if f$edit(ans1, "upcase") .eqs. "X" then goto ed_writecfg
$    endif
$ endif
$!
$ prmt = "[SUPPRESS IP ADDRESSES]             : ''suppress_ip' : " 
$ ans1 = ""
$ ed_suppress_ip:
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ ans1 = f$extract(0,1,f$edit(ans1, "upcase,collapse,compress,trim"))
$ if ans1 .eqs. "" then ans1 = f$extract(0,1,suppress_ip)
$ if ans1 .eqs. "?" .or. (ans1 .nes. "N" .and. ans1 .nes. "Y" .and. ans1 .nes. "X")
$ then
$    gosub suppress_ip_help
$    goto ed_suppress_ip
$ endif
$ if ans1 .eqs. "X" then goto ed_writecfg
$ if ans1 .nes. "" then suppress_ip = ans1
$ if suppress_ip .nes. "Y" then suppress_ip = "N"
$!
$ prmt = "[RUN ON REBOOT]                     : ''run_on_reboot' : " 
$ ans1 = ""
$ ed_run_on_reboot:
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ ans1 = f$extract(0,1,f$edit(ans1, "upcase,collapse,compress,trim"))
$ if ans1 .eqs. "" then ans1 = f$extract(0,1,run_on_reboot)
$ if ans1 .eqs. "?" .or. (ans1 .nes. "N" .and. ans1 .nes. "Y" .and. ans1 .nes. "X")
$ then
$    gosub run_on_reboot_help
$    goto ed_run_on_reboot
$ endif
$ if ans1 .eqs. "X" then goto ed_writecfg
$ if ans1 .nes. "" then run_on_reboot = ans1
$!
$ prmt = "[FCT BINARY IMAGE]                  : ''fct_image' : " 
$ ans1 = ""
$ ed_fct_binary:
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ ans1 = f$extract(0,1,f$edit(ans1, "upcase,collapse,compress,trim"))
$ if ans1  .eqs. "" then ans1 = f$extract(0,1,fct_image)
$ if ans1 .eqs. "?" .or. (ans1 .nes. "N" .and. ans1 .nes. "Y" .and. ans1 .nes. "X")
$ then
$    gosub fct_binary_help
$    goto ed_fct_binary
$ endif
$ if ans1  .eqs. "X" then goto ed_writecfg
$ if ans1 .nes. "" then fct_image = ans1
$!
$ prmt = "[DATA FOR ANALYSIS]                 : ''anal_data' : " 
$ ans1 = ""
$ ed_data_for_analysis:
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ ans1 = f$extract(0,1,f$edit(ans1, "upcase,collapse,compress,trim"))
$ if ans1 .eqs. "X" then goto ed_writecfg
$ if ans1 .eqs. "" then ans1 = f$extract(0,1, anal_data)
$ if ans1 .eqs. "?" .or. (f$loc(ans1, "FLN") .eq. f$len("FLN"))
$ then
$    gosub anal_data_help
$    goto ed_data_for_analysis
$ endif
$ if ans1 .nes. "" then anal_data = ans1
$!
$ prmt = "[NODES]                             : ''node_string' : "
$ ed_nodes:
$ ans1 = ""
$ read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$ ans1 = f$edit(ans1, "upcase,collapse,compress,trim")
$ if ans1 .eqs. "X" then goto ed_writecfg
$ if f$extract(0,1,ans1) .eqs. "?"
$ then
$    gosub nodes_help
$    goto ed_nodes
$ endif
$ if ans1 .nes. "" then node_string = ans1
$ gosub check_nodes
$ if vax_string .nes. "" then node_string = alpha_string + "," + vax_string
$ if f$extract(0, 1, node_string) .eqs. "," then node_string = node_string - ","
$!
$ tmpcnt = 1
$ new_node_sn_string = ""
$ tmpsn_string = ""
$ sn1loop:
$   node_'tmpcnt' = f$element(tmpcnt-1, ",", node_string)
$   if node_'tmpcnt' .eqs. "," then goto endsn1loop
$   tmpnod = node_'tmpcnt'
$   tmpnod = f$extract(0, 6, tmpnod + "      ")
$   tmpsn = f$edit(f$extract(f$locate(" ''tmpnod' ", node_sn_string) + 8, 12, node_sn_string), "compress,trim")
$   if f$loc(" ", tmpsn) .ne. f$len(tmpsn) then tmpsn = f$elem(0, " ", tmpsn)
$   if tmpsn .eqs. "" 
$   then
$     if f$loc(" ''tmpnod' ", old_node_sn_string) .ne. f$len(old_node_sn_string)
$     then 
$       tmpsn = f$edit(f$extract(f$locate(" ''tmpnod' ", old_node_sn_string) + 8, 12, old_node_sn_string), "compress,trim")
$       if f$loc(" ", tmpsn) .ne. f$len(tmpsn) then tmpsn = f$elem(0, " ", tmpsn)
$     else
$       tmpsn = "UNKNOWN"
$     endif
$   endif
$!
$ sn_prmt:    		! Format for Serial Number: MMMMMMMMM   (M = Alphanumeric)
$   if tmpsn .eqs. "" then tmpsn = "UNKNOWN"
$   prmt = "[''tmpnod' SYSTEM SERIAL NUMBER]       : ''tmpsn' : "
$   ans1 = ""
$   read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$   ans1 = f$edit(ans1, "UPCASE")
$   if ans1 .eqs. "X" then goto ed_writecfg
$   if f$extract(0,1,ans1) .eqs. "?"
$   then
$      gosub tmpsn_help
$      goto sn_prmt
$   endif
$   if ans1 .eqs. "" then ans1 = f$edit(tmpsn, "UPCASE")
$   str = ans1
$   gosub check_sn_format
$   ans1 = str
$   if badsn .eq. 1 
$   then 
$     write sys$output ""
$     write sys$output "Serial Number format must be 6-12 alphaNumeric characters"
$     write sys$output ""
$     goto sn_prmt
$   endif
$   if badsn .eq. 2 
$   then 
$     write sys$output ""
$     write sys$output "Serial Number must be unique"
$     write sys$output ""
$     goto sn_prmt
$   endif
$!
$   tmpsn_string = tmpsn_string + ans1 + " "
$   tmps = "( " + tmpnod + " " + ans1 + " )"
$   new_node_sn_string = new_node_sn_string + " " + tmps
$   tmpcnt = tmpcnt + 1
$ goto sn1loop
$ endsn1loop:
$!
$ old_node_sn_string = node_sn_string
$ node_sn_string = new_node_sn_string
$! count = tmpcnt
$!
$ ed_writecfg:
$ write outf ";"
$ write outf "; RCM ''rcm_ver' Configuration file"
$ write outf "; created by RCM_START.COM at ''f$time()'"
$ write outf ";"
$ write outf "[COMPANY NAME]                        " + cmpy_name
$ write outf "[CONTACT NAME]                        " + cmpy_c 
$ write outf "[CONTACT TELEPHONE]                   " + cmpy_tel  
$ write outf "[CONTACT EMAIL]                       " + cmpy_email  
$ write outf "[ACCOUNT MANAGER]                     " + tam_name  
$ write outf "[ACCOUNT MANAGER EMAIL]               " + tam_email  
$ cust_id = f$edit(cust_id, "UPCASE")
$ write outf "[CUSTOMER ACCESS ID]                  " + cust_id
$ trans = f$edit(trans, "UPCASE")
$ write outf "[TRANSPORT OPTION]                    " + trans
$ coll_freq = f$edit(coll_freq, "UPCASE")
$ write outf "[COLLECTION FREQUENCY]                " + coll_freq
$ nextime = f$cvtime(nextime, "absolute")
$ write outf "[NEXT COLLECTION TIME]                " + nextime
$ write outf "[MAX ARCHIVES]                        " + max_archives
$ archdev = f$parse(archive_dir,,,"DEVICE")
$ archdir = f$parse(archive_dir,,,"DIRECTORY")
$ adir = archdev + archdir - "]["
$ define/system/nolog RCM$ARCHIVE 'adir'
$ write outf "[ARCHIVE DIRECTORY]                   " + adir
$ coldev = f$parse(coll_dir,,,"DEVICE")
$ coldir = f$parse(coll_dir,,,"DIRECTORY")
$ datadir = coldev + coldir - "]["
$ write outf "[COLLECTION DIRECTORY]                " + datadir
$ write outf "[FTP AREA]                            " + ftp_area
$ write outf "[FTP PROCEDURE]                       " + ftp_procedure
$ write outf "[EMAIL ADDRESS]                       " + email_adr
$ write outf "[LOCAL SITE]                          " + local_site
$ write outf "[LOCAL TRANSPORT OPTION]              " + local_trans
$ write outf "[LOCAL EMAIL ADDRESS]                 " + local_email
$ write outf "[LOCAL HOSTNAME]                      " + local_host
$ write outf "[LOCAL LOGIN]                         " + local_login
$ write outf "[LOCAL PASSWORD]                      " + local_password
$ write outf "[LOCAL UPLOADDIR]                     " + local_dir
$ write outf "[LOCAL FTP PROCEDURE]                 " + local_ftpproc
$ write outf "[SUPPRESS IP ADDRESSES]               " + suppress_ip
$ write outf "[RUN ON REBOOT]                       " + run_on_reboot
$ write outf "[FCT BINARY IMAGE]                    " + fct_image
$ write outf "[DATA FOR ANALYSIS]                   " + anal_data
$ node_string = f$edit(node_string, "UPCASE, COLLAPSE")
$ write outf "[NODES]                               " + node_string
$!
$ tmpcnt = 1
$ tmplop:
$   tmpnod = node_'tmpcnt'
$   tmpsn  = f$edit(f$extract(f$loc(" ''tmpnod' ", node_sn_string)+8, 12, node_sn_string), "compress,trim")
$   if f$loc(" ", tmpsn) .ne. f$len(tmpsn) then tmpsn = f$elem(0, " ", tmpsn)
$   if f$loc(" )", tmpsn) .ne. f$len(tmpsn) then tmpsn = f$extract(0, f$loc(" )", tmpsn), tmpsn)
$!
$   tmpnod = f$extract(0, 6, tmpnod + "       ")
$   write outf "[''tmpnod' SYSTEM SERIAL NUMBER]         ''tmpsn' "
$   tmpcnt = tmpcnt + 1
$   if tmpcnt .gt. count then goto endtmplop
$   if tmpcnt .ge. 99 then goto endtmplop
$ goto tmplop
$ endtmplop:
$!
$ close outf
$ rename RCM$DATA:'outcfg' RCM$DATA:'cfg_file'
$ purge RCM$DATA:'cfg_file'
$!
$ if f$type(olddir) .nes. "" 
$ then
$  if olddir .nes. newdir
$  then
$    copy 'olddir''cfg_file' 'newdir''cfg_file'
$    delete 'olddir''cfg_file';
$  endif
$ endif
$!
$ return
$!
$!------------------------------------------------------------------------------
$!
$ edt_exit:
$  close outf
$  goto finish_up
$!
$!------------------------------------------------------------------------------
$!
$ check_nodes: 			!check if all nodes in node_string are valid
$!
$! check that 'thisnode' is in the nodestring
$!
$ temp_node_string = "," + node_string + ","
$ if f$locate(thisnode, temp_node_string) .eq. f$length(temp_node_string)
$ then
$    write sys$output "**** ''thisnode' must be one of the selected nodes!"
$ endif
$!
$ if node_string .eqs. "" 
$ then 
$   gosub get_nodes
$ endif
$ show device/full/out=tmpdev.tmp 'rcm_device'
$ tmp_node_string = ""
$ count = 0
$ nodloop:
$   tmpnod = f$edit(f$element(count, "," , node_string), "upcase")
$   if tmpnod .eqs. "," then goto endnodloop
$   count = count + 1
$   if .not. f$getsyi("CLUSTER_MEMBER", tmpnod) .and. tmpnod .nes. thisnode
$   then 
$       write sys$output "**** ''tmpnod' ******* is not a member of this Cluster"
$       goto nodloop
$   endif
$!
$   if tmpnod .eqs. thisnode                                          
$   then
$        status = 1
$   else
$        define/user sys$output NLA0:
$        define/user sys$error NLA0:
$        search tmpdev.tmp "''tmpnod',", "''tmpnod'."  !search for "NODE," or "NODE." 
$        status = $STATUS
$   endif
$   if status .ne. 1 
$   then 
$       write sys$output "''tmpnod' does not have this disk mounted"
$       goto nodloop
$   endif
$!
$!  Check if RCM_COLLECT process is running on the selected node
$!
$   show system/node='tmpnod' /process="RCM_COLLECT"/output=rcmp1.tmp
$   define/user sys$output NLA0:
$   define/user sys$error NLA0:
$   search rcmp1.tmp "RCM_COLLECT"
$   if $severity .eq. 1 
$   then
$!     write sys$output "RCM Collection process is running on ''tmpnod'. Use @RCM$DIR:RCM_STOP to kill all RCM Processes"
$     close/nolog cfg
$     close/nolog outf
$     err_msg = "RCM Collection process is running on ''tmpnod'. Use @RCM$DIR:RCM_STOP to kill all RCM Processes"
$     goto error_exit
$!    goto nodloop
$   endif
$!
$!  Check if RCM Scheduling process is running on the selected node (other than this node)
$!
$   if tmpnod .nes. thisnode
$   then
$     show system/node='tmpnod'/process="RCM"/output=rcmp1.tmp
$     define/user sys$output NLA0:
$     define/user sys$error NLA0:
$     search rcmp1.tmp "RCM"
$     if $severity .eq. 1 
$     then
$!       write sys$output "RCM Scheduling process is running on ''tmpnod'. Use @RCM$DIR:RCM_STOP to kill all RCM Processes"
$       close/nolog cfg
$       close/nolog outf
$       err_msg = "RCM Scheduling process is running on ''tmpnod'. Use @RCM$DIR:RCM_STOP to kill all RCM Processes"
$       goto error_exit
$!      goto nodloop
$     endif
$   endif
$!
$ tmp_node_string = tmp_node_string + "," + tmpnod
$ goto nodloop
$ endnodloop:
$ node_string = f$edit(tmp_node_string - ",", "compress, trim, collapse") 
$ if f$search("rcmp1.tmp") .nes. "" then delete rcmp1.tmp;*
$ delete tmpdev.tmp;*            !PTR36-4-413 change del to delete
$ gosub get_alpha_vax_strings
$ return
$!
$!------------------------------------------------------------------------------
$!
$ replace_bkts:
$ posL = f$locate("<", tmp_str)
$ if posL .eq. f$len(tmp_str) then goto rbkt
$ tmp_str = f$extract(0, posL, tmp_str) + "[" + f$extract(posL + 1, 100, tmp_str)
$ rbkt:
$ posR = f$locate(">", tmp_str)
$ if posR .eq. f$len(tmp_str) then return
$ tmp_str = f$extract(0, posR, tmp_str) + "]" + f$extract(posR + 1, 100, tmp_str)
$ goto replace_bkts
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_serialnums:
$!
$ tmpsn_string = ""
$ str = ""
$!
$ gosub get_alpha_vax_strings
$ if alpha_string .eqs. "" then goto skip_alp
$!
$ gosub alp_sernums
$!
$ skip_alp:
$!
$ if vax_string .eqs. "" then goto endvaxloop
$ cnt = 0
$ vaxloop:
$ tmpnod = f$element(cnt, ",", vax_string)
$ if tmpnod .eqs. "," then goto endvaxloop
$ tmpnod = f$extract(0, 6, tmpnod + "      ")
$!
$ get_vaxsn:   	! Format for Serial Number: 6 to 12 alphanumeric characters
$   prmt = "[''tmpnod' SYSTEM SERIAL NUMBER] (Must be 6 to 12 alphanumeric characters) : "
$   ans1 = ""
$   read/end=edt_exit/prompt= "''prmt'" sys$command ans1
$   if f$extract(0,1,ans1) .eqs. "?"
$   then
$      gosub tmpsn_help
$      goto get_vaxsn
$   endif
$   if ans1 .eqs. "" then goto get_vaxsn
$   ans1 = f$edit(ans1, "UPCASE")
$   str = ans1
$   gosub check_sn_format
$   ans1 = str
$   if badsn .eq. 1 
$   then 
$     write sys$output ""
$     write sys$output "Serial Number format must be 6 to 12 alphaNumeric characters"
$     write sys$output ""
$     goto get_vaxsn
$   endif
$   if badsn .eq. 2 
$   then 
$     write sys$output ""
$     write sys$output "Serial Number must be unique"
$     write sys$output ""
$     goto get_vaxsn
$   endif
$   tmpsn_string = tmpsn_string + str + " "
$   write cfgf "[''tmpnod' SYSTEM SERIAL NUMBER]         ''ans1'"
$!
$ cnt = cnt + 1
$ goto vaxloop
$ endvaxloop:
$ return
$!
$!---------------------------------------------------------------------------------
$!
$ get_alpha_vax_strings:
$!
$! get VAX nodes and Alpha Nodes
$! VAX Nodes will not have System Serial Number in SHOW CPU
$!
$ vax_string = ""
$ alpha_string = ""
$ cnt = 0
$ alploop:
$ tmpnode = f$element(cnt, ",", node_string)
$ if tmpnode .eqs. "," then goto endalploop
$ if f$getsyi("hw_model", "''tmpnode'") .ge. 1024
$ then
$   alpha_string = alpha_string + ",''tmpnode'"
$ else
$   vax_string = vax_string + ",''tmpnode'"
$ endif
$ cnt = cnt + 1
$ goto alploop
$ endalploop:
$ alpha_string = alpha_string - ","
$ vax_string = vax_string - ","
$ return
$!
$!-----------------------------------------------------------------------------------------
$ check_sn_format: 
$ ALP_NUM_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-" 
$ badsn = 0
$!
$! Check if any illegal characters
$ str = f$edit(f$extract(0, f$length(str), str), "upcase,trim")
$ i = 0
$ snlp:
$   char = f$edit(f$extract(i, 1, str), "UPCASE")
$   if f$locate(char, ALP_NUM_CHARS) .eq. f$len(ALP_NUM_CHARS) 
$   then
$        write sys$output ""
$        write sys$output "Serial Number should consist of alphanumeric characters only. ''char' is not allowed"
$        badsn = 1
$        return
$   endif
$   i = i + 1
$   if i .lt. f$len(str) then goto snlp
$!
$ if f$length(str) .lt. 6 .or. f$length(str) .gt. 12 then badsn = 1
$ if badsn .eq. 1 then return
$!
$ partid = -1
$ define sys$output NLA0:    !suppress error if this version of VMS does
$ define sys$error NLA0:     !not support this getsyi item
$ partid = f$getsyi("PARTITION_ID","''tmpnod'") 
$ deassign sys$output
$ deassign sys$error
$ if partid .ne. -1 
$ then 
$     return !skip check for duplicate S/N if partitions PTR36-4-1193
$ endif
$ if f$loc(str, tmpsn_string) .ne. f$len(tmpsn_string) 
$ then 
$    badsn = 2    !duplicate SN detected
$ endif
$ return
$!-------------------------------------------------------------
$!
$ check_custid_format: 
$ badcust = 0
$!
$ VALID_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_-."
$ i = 0
$ custloop:
$   char = f$edit(f$extract(i, 1, cust_id), "UPCASE")
$   if f$locate(char, valid_chars) .eq. f$len(valid_chars) then badcust = 1
$   i = i + 1
$   if i .lt. f$len(cust_id) then goto custloop
$ if badcust .eq. 1 then return
$ return
$!-------------------------------------------------------------
$!
$ get_dir_spec:
$ dir_spec = ""
$ invalid_dir = "TRUE"
$ x = f$parse(coll_dir)
$ if x .nes. "" 
$ then
$   if (f$length(x)-2 .eq. f$locate(".;",x))                          
$   then                                                              
$     if ( (f$length(x)-3 .eq. f$locate("]",x)) .or. (f$length(x)-3 .eq. f$locate(">",x)) )             
$     then                                                            
$       invalid_dir = "FALSE"                                   
$ 	dir_spec = f$extract(0, f$length(x)-2, x)
$     endif                                                           
$   endif                                                             
$ endif
$ return
$!-----------------------------------------------------------------------------
$!
$ create_rcm_run:
$   if f$mode() .nes. "INTERACTIVE" then return
$   write sys$output ""
$   err_msg = "Error writing RCM$DIR:RCM_RUN.COM"
$   open/write/error=error_exit rcmrun RCM$DIR:RCM_RUN.COM
$   rcmdir = f$trnlnm("RCM$DIR")
$   rcmcfg = f$trnlnm("RCM$CONFIGFILE")
$   rcmhme = f$trnlnm("RCM$HOMEFILE")
$   write rcmrun "$define/system/nolog RCM$DIR ''rcmdir'"
$   write rcmrun "$define/system/nolog RCM$CONFIGFILE ''rcmcfg'"
$   write rcmrun "$define/system/nolog RCM$HOMEFILE ''rcmhme'"
$   write rcmrun "$define/system/nolog RCM$DATA ''coll_dir'"
$   write rcmrun "$curdir = f$environment(""default"")"
$   write rcmrun "$set def ''coll_dir'"
$   write rcmrun "$@RCM$DIR:rcm_start -now"
$   write rcmrun "$set default 'curdir'"
$   write rcmrun "$exit"
$   close rcmrun
$   purge/nolog rcm$dir:rcm_run.com
$ return
$!
$!-----------------------------------------------------------------------------------
$ is_rcmrunning:
$ rcmrunning = 0
$ if f$search("rcmr.tmp") .nes. "" then delete rcmr.tmp;*
$ show system/process="RCM*"/node='node'/output=rcmr.tmp
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search rcmr.tmp "RCM_COLLECT"
$ if $severity .eq. 1 
$ then
$   rcmrunning = 1
$   return
$ endif
$!
$! if this is the RCM Process skip next check
$ if f$getjpi("","PRCNAM") .eqs. "RCM" then return
$!
$! If an immediate collection was requested, via "-now" parameter, skip this test
$ if f$edit(p1, "UPCASE") .eqs. "-NOW" then return
$!
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search rcmr.tmp " RCM "
$ if $severity .eq. 1 then rcmrunning = 1
$ return
$!
$!----------------------------------------------------------------
$!
$ get_value:
$  define/user sys$output NLA0:
$  define/user sys$error NLA0:
$  search 'cfg_file' "''tag'"/output=VALUE.TMP
$  if $status .ne. 1 
$  then 
$    value = def_value
$  else
$    open/read val VALUE.TMP
$    read val rec
$    close val
$    delete VALUE.TMP;
$    rec = f$edit(rec, "compress, trim")
$    if f$extract(0, 1, rec) .eqs. "["
$    then 
$      rbracket = f$locate("]", rec)+1
$      semic = f$locate(";",rec)
$      semic = semic - rbracket
$      value = f$edit(f$extract(rbracket, semic, rec), "TRIM")
$    endif
$  endif
$ return
$!------------------------------------------------------------------------
$!
$ alp_sernums:
$! If only one node - don't use SYSMAN (CLUSTER code may not be loaded)
$!
$ if f$element(1, ",", node_string) .eqs. ","
$ then  ! there is only one node in node_string
$   if f$search("snsysman.tmp") .nes. "" then delete snsysman.tmp;*
$   define/user sys$output tmpsn.tmp
$   show cpu/full
$ else
$   open/write snsys snsysman.com
$   write snsys "$MCR SYSMAN"
$   write snsys "SET ENVIRONMENT/NODE=(''alpha_string')
$   write snsys "DO SHOW CPU/FULL"
$   write snsys "EXIT"
$   close snsys
$   @snsysman.com/out=tmpsn.tmp
$   delete snsysman.com;
$ endif
$!
$ convert/fdl=sys$input tmpsn.tmp tmpsn1.tmp
record; format stream;
$ search/out=tmpsn2.tmp/format=passall tmpsn1.tmp ", a","Serial Number =", "Serial Number	=" ! V7.3 has Tab before = !!
$ if $status .ne.1 then return
$!
$ open/read sntmp tmpsn2.tmp
$ str = ""
$ tmpsn = "UNKNOWN"
$ snloop:
$   read/end=endsnloop sntmp snrec
$   snrec = f$edit(snrec, "compress, trim")
$   if f$loc(", a ", snrec) .ne. f$len(snrec) 
$   then    	!     pre-V7.3-1 has: "<node>, a AlphaServer xxx"
$     tmpnod = f$edit(f$element(0, ",", snrec), "compress,trim")
$   else    	!     V7.3-1 has: "System: <node>, AlphaServer xxx"
$     if f$extr(0,8,snrec) .eqs. "System: " then tmpnod = f$edit(f$element(1, " ", snrec), "compress,trim")
$   endif
$   if f$loc("Serial Number", snrec) .ne. f$len(snrec)
$   then
$     tmpsn = f$extract(f$loc("=", snrec)+1, 12, snrec)
$     tmpsn = f$edit(tmpsn, "UPCASE")
$     str = tmpsn
$     gosub check_sn_format
$     tmpsn = str
$     if badsn .ne. 0
$     then
$       get_alpsn:              ! Format for Serial Number: 6 - 12 Alphanumeric characters
$        if badsn .eq. 1 then prmt = "[''tmpnod' SYSTEM SERIAL NUMBER] (Must be 6 to 12 alphanumeric characters) [''tmpsn'] : "
$        if badsn .eq. 2 then prmt = "[''tmpnod' SYSTEM SERIAL NUMBER] (Must be unique)            [''tmpsn'] : "
$        tmpsn = ""
$        read/end=edt_exit/prompt= "''prmt'" sys$command tmpsn
$        tmpsn = f$edit(tmpsn,"UPCASE")
$        if tmpsn .eqs. "" then goto get_alpsn
$        str = tmpsn
$        gosub check_sn_format
$        tmpsn = str
$        if badsn .eq. 1 
$        then 
$          write sys$output ""
$          write sys$output "Serial Number format must be 6 to 12 alphaNumeric characters"
$          write sys$output ""
$          goto get_alpsn
$        endif
$        if badsn .eq. 2 
$        then 
$          write sys$output ""
$          write sys$output "Serial Number must be unique"
$          write sys$output ""
$          goto get_alpsn
$        endif
$     endif
$     tmpnod = f$extract(0, 6, tmpnod + "      ")
$     write cfgf "[''tmpnod' SYSTEM SERIAL NUMBER]         ''tmpsn'"
$     write sys$output "[''tmpnod' SYSTEM SERIAL NUMBER]         ''tmpsn'"
$   endif
$   tmpsn_string = tmpsn_string + str + " "
$   goto snloop
$ endsnloop:
$ close sntmp
$ delete tmpsn*.tmp;*
$ return
$!
$!-------------------------------------------------------------------------
$ encp:
$ enc "''local_password'"
$ if $status .and. 1 then local_password = rep
$ return
$!------------------------------------------------------------------------------
$ get_pass:
$ enc -p
$ if $status .and. 1 then local_password = rep
$ return
$!----------------------------------------------------------------------
$ get_tcpip_prod:
$ __isMultiNet = f$trnlnm("MULTINET_KERNEL_BASE_ADDRESS") .nes. ""
$ __isTCPware = f$trnlnm("TCPWARE_NETCP_MBX") .nes. ""
$ __isPathway = f$trnlnm("TWG$TCP") .nes. ""
$ tcpip = ""
$ if f$search("SYS$SYSTEM:*$UCP.EXE") .nes. "" then tcpip = "Compaq's TCPIP"
$ if __isMultiNet then tcpip = "MULTINET"
$ if __isTCPware then tcpip = "TCPWARE"
$ if __isPathway then tcpip = "PATHWAY"
$ if tcpip .eqs. "" 
$ then 
$   write sys$output "No Tcpip product found on this system."
$ else
$   if tcpip .nes. "Compaq's TCPIP" then write sys$output "Tcpip product installed appears to be ''tcpip'"
$ endif
$ return
$!--------------------------------------------------------------------
$ isencd:
$ tststr = local_password
$ encd = 1
$ allhex = "01234567890abcdef"
$ if f$extr(0,1,tststr) .nes. "x" then encd = 0
$ l = f$len(tststr)
$ remd = l - 2*(l/2)
$ if remd .eq. 0 then encd = 0
$ i = 1
$ hloop:
$  c = f$extr(i, 1, tststr)
$  if f$loc(c, allhex) .eq. f$len(allhex)
$  then
$    encd = 0
$    goto endhloop
$  endif
$  i = i + 1
$  if i .ge. f$len(tststr) then goto endhloop
$ goto hloop
$ endhloop:
$ return
$!---------------------------------------------------------------------
$ cmpy_name_help:
$ write sys$output ""
$ write sys$output "Enter the name of the Company."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ cmpy_c_help:
$ write sys$output ""
$ write sys$output "Enter the name of a contact person at this Company."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ cmpy_tel_help:
$ write sys$output ""
$ write sys$output "Enter a telephone number for the contact person."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ cmpy_email_help:
$ write sys$output ""
$ write sys$output "Enter an Email address for the contact person."
$ write sys$output "Collector error messages will be sent to this Email address." 
$ write sys$output "By default the VMS Username of this account will be used."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ tam_name_help:
$ write sys$output ""
$ write sys$output "Enter the name of the Compaq Technical Account Manager."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ tam_email_help:
$ write sys$output ""
$ write sys$output "Enter the Email address for the Compaq Technical Account Manager."
$ write sys$output "This address must be a Compaq address " 
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ cust_id_help:
$ write sys$output ""
$ write sys$output "The Access ID is a unique identifier that allows you to access"
$ write sys$output "your RCM data on the RCM Server. It is an important field."
$ write sys$output "If you do not know what Access ID to use for this system please"
$ write sys$output "ask your Compaq Support Representative."
$ write sys$output ""
$ write sys$output "Valid characters are any alphanumeric character, or '-', '_', '.'"
$ write sys$output ""
$ write sys$output "Note that the Access ID should be created at the RCM Server before"
$ write sys$output "running a collection so that the RCM data will be assigned to"
$ write sys$output "the correct owner."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ trans_help:
$ write sys$output ""
$ write sys$output "Specify how to transport the data to the RCM Server in Compaq."
$ write sys$output "Valid options are: [F]TP, (E)mail, (D)SNlink, or (M)anual."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ coll_freq_help:
$ write sys$output ""
$ write sys$output "Collections can be scheduled to run at regular intervals or at specific times."
$ write sys$output "Options are: a Delta time (DD-HH:MM), or (D)ay, (W)eek, [M]onth, or (Q)uarter." 
$ write sys$output "Enter N if just one collection is required."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ nxtcoll_help:
$ write sys$output ""
$ write sys$output "Enter the time for the next RCM Collection."
$ write sys$output "Use 'N' to get a collection immediately."
$ write sys$output "You can enter a Delta time or an Absolute time."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ max_archives_help:
$ write sys$output ""
$ write sys$output "Specify the number of old RCM Collections to keep."
$ write sys$output "The default is 10"
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ archive_dir_help:
$ write sys$output ""
$ write sys$output "Specify a directory for the archived RCM Collections."
$ write sys$output "The default is RCM$ROOT:[RCM_ARCHIVE]"
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ coll_dir_help:
$ write sys$output ""
$ write sys$output "Specify a directory for RCM Collections."
$ write sys$output "The default is RCM$ROOT:[DATA]"
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ ftp_proc_help:
$ write sys$output ""
$ write sys$output "If you want to use a custom DCL procedure to FTP the data to Compaq"
$ write sys$output "enter the file specification here. This is necessary if this site uses"
$ write sys$output "a Tcpip product other than Compaq's TCPIP or Multinet.
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ local_site_help:
$ write sys$output ""
$ write sys$output "Valid answers are Y or N."
$ write sys$output "If you want to send a copy of the RCM data to a local site enter Y here."
$ write sys$output "If this system is not connected to the Internet, this option allows you"
$ write sys$output "to send the RCM data to another system which can then forward to Compaq."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ local_trans_help:
$ write sys$output ""
$ write sys$output "Valid options are Ftp, Email or DECnet to send data to the local site."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ local_host_help:
$ write sys$output ""
$ write sys$output "Enter the name of a local system where you want to send a copy of the RCM data."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ local_email_help:
$ write sys$output ""
$ write sys$output "Enter the email address where you want too send a copy of the RCM data."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ local_login_help:
$ write sys$output ""
$ write sys$output "Enter the account name to use on the local system where the data will be sent."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ local_dir_help:
$ write sys$output ""
$ write sys$output "Enter the directory to use on the Local site for local ftp or DECnet copy."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ local_ftpproc_help:
$ write sys$output ""
$ write sys$output "If you want to use a custom DCL procedure to ftp the data, enter the filespec here."
$ write sys$output "This will be necessary if Compaq's TCPIP or Multinet are not installed."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ suppress_ip_help:
$ write sys$output ""
$ write sys$output "Valid answers are Y or N."
$ write sys$output "Some sites do not want IP addresses collected by RCM. If you want"
$ write sys$output "to suppress the collection of IP addresses, set this option to Y."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ run_on_reboot_help:
$ write sys$output ""
$ write sys$output "Valid answers are Y or N."
$ write sys$output "If you want RCM to collect data after a reboot, enter Y to this prompt."
$ write sys$output "The RCM collection will not begin until 10 minutes after the reboot"
$ write sys$output "so that all disks and Cluster nodes are available."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ fct_binary_help:
$ write sys$output ""
$ write sys$output "Valid answers are Y or N."
$ write sys$output "To collect the binary image of the FRU Configuration Tree set this"
$ write sys$output "option to Y. This is to aid in debugging problems and should only" 
$ write sys$output "be set when advised by Compaq."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ anal_data_help:
$ write sys$output ""
$ write sys$output "Must be either F (Full), L (Lif) or N (None)."
$ write sys$output "Setting this Option to L means that only the LIF files are sent to"
$ write sys$output "Compaq to generate Propatch reports."
$ write sys$output "The default setting, F, means all RCM data is transported to the"
$ write sys$output "Compaq RCM Server."
$ write sys$output "If set to N, no data is sent from the Customer site."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ continue_help:
$ write sys$output ""
$ write sys$output "You can exit RCM by entering 'X' at this point. The Config file will be"
$ write sys$output "saved and can be edited manually."
$ write sys$output "If you want to change some options, typing 'E' allows you to modify each option"
$ write sys$output "If you are happy with all the configuration options, enter 'C' to continue"
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ node_select_help:
$ write sys$output ""
$ write sys$output "Enter Y if you want to collect RCM data for node ''node'."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ nodes_help:
$ write sys$output ""
$ write sys$output "Enter the list of Nodes for which you want RCM data."
$ write sys$output ""
$ return
$!----------------------------------------------------------------------
$ tmpsn_help:
$ write sys$output ""
$ write sys$output "The Serial Number for this system is not available automatically."
$ write sys$output "Enter a Serial Number between 6 and 12 Alphanumeric characters."
$ write sys$output ""
$ return
$!
$! RCM_START.COM 		   Pat Moran	2-Feb-2000
$!*****************************************************************************
$!                                                                             
$!                            RCM_START.COM                                     
$!                                                                             
$!****************************************************************************
$!
$!    Copyright 2001 Compaq Information Technologies Group, L.P.
$!
$!    Compaq and the Compaq logo are trademarks of Compaq Information
$!    Technologies Group, L.P. in the U.S. and/or other countries.
$!
$!    Confidential computer software. Valid license from Compaq required for
$!    possession, use or copying. Consistent with FAR 12.211 and 12.212,
$!    Commercial Computer Software, Computer Software Documentation, and
$!    Technical Data for Commercial Items are licensed to the U.S. Government
$!    under vendor's standard commercial license.
$!
$!    Compaq service tool software, including associated documentation, is the
$!    property of and contains confidential technology of Compaq Computer 
$!    Corporation or its affiliates. Service customer is hereby licensed to use
$!    the software only for activities directly relating to the delivery of, 
$!    and only during the term of, the applicable services delivered by Compaq
$!    or its authorized service provider. Customer may not modify or reverse
$!    engineer, remove, or transfer the software or make the software or any
$!    resultant diagnosis or system management data available to other parties
$!    without Compaqs or its authorized service providers consent. Upon 
$!    termination of the services, customer will, at Compaqs or its service
$!    providers option, destroy or return the software and associated
$!    documentation in its possession.
$!
$!****************************************************************************
$!                                                                             
$!      FACILITY                :       OpenVMS RCM Data Collector       
$!
$!      COMMAND FILE            :       RCM_START.COM                           
$!                                                                             
$!      DESCRIPTION             :       Starts the RCM Data Collection process 
$!                                                                             
$!      PROGRAMMER              :       Pat Moran, 10 Jun 1998    
$!
$!      MODIFICATIONS           :       Version V1.0.1   P. Moran 10-Jun-1998
$!                                              V1.0.2   P. Moran 17-Aug-1998 
$!                                              V1.0.3   P. Moran 17-Aug-1998 
$!					                 Improved validation of .CFG file
$!                                              V1.0.4   P. Moran  4-Sep-1998 minor fixes
$!                                              V1.0.5   P. Moran 16-Oct-1998 Update for VAX
$!                                              V2.1.0   P. Moran  3-Nov-1998 Update for RCM V2.1.0
$!                                              V2.1.1   P. Moran  4-Dec-1998 Update for RCM V2.1.1
$!                                                       P. Moran 16-Dec-1998 Add SNs for all nodes to cfg file
$!                                                       P. Moran 14-Jan-1999 PTR36-4-457
$!                                              V2.1.2   P. Moran 19-Jan-1999 Validate SN
$!                                                       P. Moran 17-Feb-1999 PTR36-4-487 detect old .cfg format
$!                                                       P. Moran  1-Mar-1999 PTR36-4-521 prob with rooted directories
$!                                              V2.2     P. Moran 29-Mar-1999 Updated to V2.2
$!                                              V3.0     P. Moran 11-May-1999 Updated to V3.0
$!                                                       reset Default Directory to SYS$STARTUP in RCM_SYSMAN_STARTUP.COM
$!                                              V4.0     P. Moran 28-Mar-2001 Updated to V4.0
$!*****************************************************************************
$!
$! Parameters: p1 Configuration File. (prompts for file if no parameter supplied)
$!
$! Description: This procedure starts the RCM Data collection process.
$!
$!      Steps:
$! 
$!       1) If a configuration file (.CFG) is specified the file is read and displayed.
$!          If no file is specified, it prompts for a filename and asks for configuration 
$!	    information. The configuration file is generated using the answers given. 
$!          
$!	 2) Next the available nodes in the Cluster are shown and an opportunity to 
$!          select or deselect each node is given. This tool was originally intended
$!          for AlphaServer models 1200/4000/4100/8200/8400 only but now any Alpha
$! 	    or VAX system can be selected. However the FRU information will only be 
$! 	    available for the above list of AlphaServers.
$!	    Only nodes which can access the disk where RCM is installed can be selected.
$!	    The node this procedure is running on must be selected.
$!
$!       3) If this procedure is running interactively, an option to start the collection
$!          process immediately is given. The RCM_COLLECT.COM procedure is run on each of 
$!          the selected nodes by invoking SYSMAN and starting a detached process on each 
$!          of the nodes.
$!
$!	 4) If the option to schedule regular collections has been used, the next
$!	    collection is scheduled to run at the 'next collection time' and the customer 
$!          configuration file is updated for the subsequent collection using the 
$!          specified collection frequency. During each collection, the configuration file is 
$!          updated to show the time for the next collection.
$!
$!	 5) When running interactively, the progress of the collection on all the nodes may be
$!          monitored using the RCM$DIR:RCM_STATUS procedure. 
$!	
