$! RCM_COLLECT.COM V4.0-507SP4a  Generation: 791  30-APR-2002 16:42:47.89!!!!>
$ SET SYMBOL/SCOPE=(NOLOCAL,NOGLOBAL)                                    !!!!>
$ rcm_ver = "V4.0-507SP4a"                                               !!!!>
$!*****************************************************************************
$!                                                                             
$!                            RCM_COLLECT.COM                                     
$!                                                                                            
$!*****************************************************************************
$ set noverify
$ set noon
$ start_time = f$time()
$ gosub init_variables
$ close/nolog mkr_log
$ open/write/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log ""
$ write mkr_log "''f$time()' : ''node6' Started RCM collection"
$ close mkr_log
$ if f$type(bld_num) .eqs. "" then bld_num = "Unknown"
$ close/nolog rcm_log
$ open/write/error=error_1 rcm_log rcm_'node'.log
$ write rcm_log "--- START RCM LOG ---"
$ write rcm_log "RCM OpenVMS Data Collector ''rcm_ver'"
$ write rcm_log ""
$ gosub get_homenode
$ fname = "RCMO-''node'-''tim'"  !tim obtained from filename of .home file
$ create 'fname'.txt
$ write sys$output "RCM OpenVMS Data Collector ''rcm_ver'"
$ write sys$output ""
$ start_time = f$time()
$ write rcm_log "RCM_COLLECT started on ''node' at ''start_time' ''tzone'"
$ write rcm_log ""
$ write sys$output ""
$ write sys$output "RCM_COLLECT started on ''node' at ''start_time' ''tzone'"
$ write sys$output ""
$ show system/noprocess/cluster   ! capture uptime info
$ write sys$output ""
$ show log RCM$*
$ write sys$output ""
$ show log svctools*
$ write sys$output ""
$ mcr sysman startup show file    
$ write sys$output ""
$ gosub get_cfg_items
$ if ALPHA
$ then
$   if systype .lt. 34
$   then 
$        gosub run_decevent
$   else
$        gosub run_ct5  		!FRU 5 System - use CT5 collector
$        if f$edit(f$extract(0,1,fct_image),"upcase") .eqs. "Y" 
$        then
$           if f$search("''node'.CT5") .eqs. "" then gosub run_greader
$	 endif
$   endif
$ endif
$ gosub get_operating_system
$ gosub get_node_info
$ gosub get_cluster_info
$ gosub get_cpu_info
$ gosub get_galaxy_info
$ gosub get_rad_info
$ gosub get_scsi_info
$ gosub get_clueconfig_info
$ gosub get_deviceinfo
$ gosub get_extended_deviceinfo
$ gosub get_raidinfo
$ gosub get_tapeinfo
$ gosub get_product_show_product
$ gosub get_vmsinstal_history
$ gosub get_soft_info
$ gosub get_alpha_patches
$ gosub get_vax_patches
$ gosub get_networkinfo
$ gosub get_devices
$ gosub list_hsdevices
$ gosub get_hsjd_info
$ gosub get_hsz_info
$ gosub get_hsg_info       
$ gosub get_license_info
$ gosub get_sysgen
$ gosub get_modparams
$ gosub get_memory
$ gosub get_io_show_bus
$ gosub get_fg_rev
$ gosub get_custinfo
$ gosub get_ctrlinfo
$ gosub get_configinfo
$ gosub get_propatch_data
$ gosub get_adhocfiles
$ write rcm_log ""
$ write rcm_log "--- END RCM LOG ---"
$ write rcm_log ""
$ close rcm_log
$ write sys$output "''f$time()': Creating report for ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Creating output file"
$ close mkr_log
$ convert rcm_'node'.log, 'fname'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ delete rcm_'node'.log;
$ purge 'fname'.txt
$ write sys$output "''f$time()': ''node' Cleaning the output file"
$ CALL clean_file 'fname'.txt
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Creating local Html report"
$ close mkr_log
$ @RCM$DIR:rcm_html.com 'fname'.txt
$ direct/siz/date 'fname'.html
$ if anal_data .eqs. "L" 	!want to transport LIF Files only
$ then
$  define sys$output 'fname'.tmp
$  write sys$output "OpenVMS LIF ONLY"
$  write sys$output ""
$  search/window=(1,5) 'fname'.TXT "--- START RCM OPERATING SYSTEM ---"
$  search/window=(1,5) 'fname'.TXT "--- START RCM NODE ---"
$  search/window=(1,11) 'fname'.TXT "--- START RCM CUSTOMER INFO ---"
$  search/window=(1,11) 'fname'.TXT "--- START RCM CONTROL INFO ---"
$  search/window=(1,29) 'fname'.TXT "--- START RCM CONFIG INFO ---"
$  deassign sys$output
$ endif
$! If this is the homenode, check if all the collections are finished and
$! if not finished, loop every 'wait_interval' until all collections on 
$! the other nodes are complete. Then ZIP all the files.
$ if node .nes. homenode 
$ then 
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' RCM Collection complete"
$   close mkr_log
$   write sys$output "RCM Collection complete on ''node' at ''f$time()'"
$   rename 'mkr_fil' rcm_marker_'node'.log
$   goto finish_collection
$ endif
$!
$! This is the Homenode
$!
$ gosub wait_for_others
$ gosub get_archive_dir
$ gosub zip_files
$ gosub transport_data
$ gosub local_transport
$ gosub create_coll_log
$ gosub move_to_archives
$ gosub add_history
$!
$finish_collection:
$ write sys$output ""
$ write sys$output ""
$ write sys$output ""
$ write sys$output ""
$ purge/nolog *.*
$!
$ if f$search("*''node'.tmp",1) .nes. "" then delete/nolog *'node'.tmp;*
$ if node .eqs. homenode
$ then
$   if f$search("HS*_*.tmp") .nes. "" then delete/nolog HS*_*.tmp;*
$   if f$search("RCM$DIR:HSJD_*.TMP") .nes. "" then delete/nolog RCM$DIR:HSJD_*.TMP;*
$ endif 
$ exit
$!
$!--------------------------------------------------------------------------------------------
$!--------------------------------------------------------------------------------------------
$!
$ init_variables:
$!
$ set default []  ! forces change to [  ], instead of <  > in dir spec 
$!
$ DEFINE/JOB SORTSHR SYS$LIBRARY:SORTSHR.EXE	!PTR 36-4-962 del_oldest_files fails if use Hypersort
$!
$ if f$trnlnm("RCM$DATA") .eqs. "" 
$ then 
$  rdev = f$getdvi(f$parse(f$env("DEFAULT"),,,"device"),"logvolnam")
$  rdir = f$parse(f$env("DEFAULT"),,,"directory","no_conceal") - "]["
$  rdata = rdev + ":" + rdir
$  define/system/nolog RCM$DATA 'rdata'
$ endif
$!
$ if f$trnlnm("RCM$ROOT") .eqs. ""		! PTR 91-21-63 PM  25-Apr-2001
$ then
$   rcmroot = f$parse("RCM$DIR",,,,) - "][" - "].;" + ".]"
$   define/system/nolog/translate=concealed RCM$ROOT 'rcmroot'
$ endif
$!
$ convert := convert
$ delete := delete
$ set := set
$ edit := edit
$ directory := directory   !PTR36-4-508 23-Feb-1999
$ wait_interval = "00:01"
$ ftp_procedure = ""
$ cfg_sn = ""
$ wait_count = 100
$ def_max_archives = 10
$ max_archives = ""
$ archive_dir = ""
$ adhoc_dir = "[.ADHOC]"
$ curdir = f$environment("default")
$ node = f$getsyi("nodename")
$ node6 = f$extract(0, 6, "''node'      ")
$ err_code = 0
$ err_text = "Failed to complete collection"
$ ALPHA = f$getsyi( "HW_MODEL" ) .ge. 1024
$ if ALPHA
$ then
$   systype = f$getsyi("SYSTYPE")
$   arch = "A"
$ else
$   arch = "V"
$ endif
$! get vms-ver
$ vver = f$getsyi("version")
$ vver = f$edit(vver, "trim") - "." - "-"
$ vver = f$integer(f$extract(1,3,vver))
$ if vver .lt. 100 then vver = vver * 10  ! e.g V7.1 becomes 710, V7.1-1 becomes 711 
$ tzone = f$trnlnm("sys$timezone_name")
$ models = " 1200 4000 4100 4X00 8200 8400 GS60 GS60E GS140 "
$ fru_version = "none"
$ fru_ver = "000"
$ machine_name = f$getsyi("HW_NAME")
$ if f$locate("AlphaServer", machine_name) .ne. f$length(machine_name)
$ then
$   modl = f$extract(f$locate("AlphaServer", machine_name)+12, 5, machine_name)
$   modl = f$extract(0, f$locate(" ", modl), modl)
$   if f$locate(modl, models) .ne. f$length(models)
$   then 
$     fru_version = "4.0"
$     fru_ver = 040
$   endif
$ endif
$ fct_image = "N"
$ anal_data = "F"
$ suppress_ip = "N"
$ prev_ndeslist = ""
$ date_time_transport = ""
$ transport_type = ""
$ transport_address = ""
$ local_host = ""
$ local_login = ""
$ local_password = ""
$ local_dir = ""
$ local_ftpproc = ""
$ local_trans = ""
$ local_email = ""
$ dsnlink_address = ""
$ define sys$scratch 'f$environment("default")  ! sys$scratch is not defined when invoked via SYSMAN
$!
$ if f$search("rcm_marker_''node'.mkr") .nes. "" then delete rcm_marker_'node'.mkr;*
$ if f$search("replace.tpu") .eqs. "" then gosub create_tpu_file
$ mkr_fil = "rcm_marker_''node'.mkr"
$ return
$!--------------------------------------------------------------------------------------------
$ get_homenode:
$ homfil = f$search("*.HOME",2)
$ if homfil .eqs. "" then goto finish_collection
$ nam = f$parse(homfil,,,"name")  ! filename --- RCMO-systemid-yyyymmdd-hhmmss
$ tim = f$extract(f$loc("-",nam)+1, 30, nam)
$ tim = f$extract(f$loc("-",tim)+1, 30, tim)
$ collect_time = tim
$ node_string = node   ! initialize
$ open/read home 'homfil'
$ read home homenode
$ read home node_string
$ read home cfg_file
$ close home
$!
$! check if the .CFG file exists	PTR36-4-522
$!
$ if f$search("''cfg_file'") .eqs. "" then goto finish_collection
$!
$! Check if RCM$STARTUP_'installnode'.COM is in SYSMAN STARTUP for this node and system disk
$!
$  installnode = f$trnlnm("RCM$NODE")
$  define/user sys$output NLA0:
$  define/user sys$error NLA0:
$  MCR SYSMAN STARTUP SHOW FILE RCM$STARTUP_'installnode'.COM
$  if ($status .and. 1) .eq. 0
$  then
$     if f$search("RCM$DIR:RCM$STARTUP_''installnode'.TMP") .nes. ""
$     then
$        copy RCM$DIR:RCM$STARTUP_'installnode'.TMP SYS$COMMON:[SYS$STARTUP]RCM$STARTUP_'installnode'.COM
$        purge SYS$COMMON:[SYS$STARTUP]RCM$STARTUP_*.COM
$        MCR SYSMAN STARTUP ADD FILE RCM$STARTUP_'installnode'.COM/node=('node_string')
$        MCR SYSMAN STARTUP SHOW FILE RCM$STARTUP*.COM
$     else
$        write sys$output "RCM$DIR:RCM$STARTUP_''installnode'.TMP not found!"
$     endif
$  endif
$ return
$!--------------------------------------------------------------------------------------------
$run_decevent:
$ if fru_version .eqs. "none"
$ then 
$    open/append/share/error=error_mkr mkr_log 'mkr_fil'
$    write mkr_log "''f$time()' : ''node6' Skipping DECEVENT - not a FRU 4 system"
$    close mkr_log
$    return
$ endif
$!
$! If its VMS V7.2 or greater, get the FRU via SDA> CLUE FRU
$! and then use DECevent to analyze CLUE$FRU.SYS
$! 
$ elog_file = "SYS$ERRORLOG:ERRLOG.SYS"
$ if vver .ge. 720
$ then
$   create/dir [.'node']   !don't want all nodes writing CLUE$FRU.SYS files to same dir!!
$   set default [.'node']
$   show default
$   DEFINE SYS$SCRATCH 'f$environment("default")  ! FRU data will be written to sys$scratch
$   analyze/system
CLUE FRU
EXIT
$   set default [-]
$   DEFINE SYS$SCRATCH 'f$environment("default")  ! redefine sys$scratch back to what it was
$   show default
$   if f$search("[.''node']CLUE$FRU.SYS") .nes. "" 
$   then
$      rename [.'node']CLUE$FRU.SYS []CLUE$FRU_'node'.SYS
$   else
$      create clue$fru_'node'.sys
$   endif
$   delete/nolog 'node'.dir;
$   elog_file = "CLUE$FRU_''node'.SYS"
$ else
$    if f$search("RCM$DIR:FRU.EXE") .eqs. "" then link/sysexe/exe=RCM$DIR:FRU RCM$DIR:FRU
$    RUN RCM$DIR:FRU
$    elog_file = "FRU_''node'.SYS"
$ endif
$!
$ if f$search("SYS$STARTUP:DECEVENT$STARTUP.COM") .eqs. ""
$ then
$    write sys$output "Error: DECevent is not installed on ''node'"
$    write rcm_log "''f$time()': Error: DECevent is not installed on ''node'"
$    open/append/share/error=error_mkr mkr_log 'mkr_fil'
$    write mkr_log "''f$time()' : ''node6' Error: DECEVENT is not installed"
$    close mkr_log
$   return
$ endif
$ if f$trnlnm("DIA$") .eqs. "" 
$ then 
$    write sys$output "Running sys$startup:decevent$startup.com ''node'"
$    write rcm_log "''f$time()': Running sys$startup:decevent$startup.com ''node'"
$    open/append/share/error=error_mkr mkr_log 'mkr_fil'
$    write mkr_log "''f$time()' : ''node6' Running sys$startup:decevent$startup.com"
$    close mkr_log
$    SET SYMBOL/SCOPE=(NOLOCAL,GLOBAL)     ! Decevent$startup defines some global symbols
$    @SYS$STARTUP:DECEVENT$STARTUP.COM
$    SET SYMBOL/SCOPE=(NOLOCAL,NOGLOBAL)                        
$ endif
$! Check DECevent version
$ define/user sys$output diagver_'node'.tmp
$ define sys$login 'f$environment("default")  ! sys$login is not defined when invoked via SYSMAN
$ diagnose exit
$ open/read devent diagver_'node'.tmp
$ read devent drec
$ read devent drec
$ close devent
$ delete/nolog diagver_'node'.tmp;
$ if f$locate("DECevent ", drec) .ne. f$length(drec)
$ then
$   d_vers = f$extract(f$locate("DECevent ", drec)+10, 3, drec)
$   d_vers = f$edit(d_vers, "trim,compress") - "."
$   d_vers = f$integer(d_vers)
$   if d_vers .lt. 27
$   then
$      write sys$output "Error: ''drec' should be at least at V2.7 on ''node'"
$      write rcm_log "''f$time()': Error: ''drec' should be at least at V2.7 on ''node'"
$      open/append/share/error=error_mkr mkr_log 'mkr_fil'
$      write mkr_log "''f$time()' : ''node6' Error: ''drec' should be at least at V2.7"
$      close mkr_log
$      return
$   endif
$ else
$      write sys$output "Error: ''drec' (on ''node')"
$      write rcm_log "''f$time()': Error: ''drec' (on ''node')"
$      open/append/share/error=error_mkr mkr_log 'mkr_fil'
$      write mkr_log "''f$time()' : ''node6' Error: ''drec'"
$      close mkr_log
$      return
$ endif
$!
$ write sys$output "DECevent Version = ''d_vers'"
$ write rcm_log "DECevent Version = ''d_vers'"
$!
$ write sys$output "''f$time()': Running DECevent on ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Running DECEVENT"
$ close mkr_log
$!
$ create rcm_decevent_'node'.txt
$ @RCM$DIR:TMP_RCM_DIAG.COM/output=rcm_diag_'node'.log 'elog_file'
$ write rcm_log "''f$time()': Running DECevent on ''node'"
$!
$ gosub latest_fru
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$latest_fru: 
$ if fru_version .eqs. "none" then goto fru_error
$ write sys$output "''f$time()': Getting latest FRU"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting latest FRU"
$ close mkr_log
$ write rcm_log "''f$time()': Getting latest FRU for ''node'"
$ flag = 0
$!
$ direct/siz/date rcm_decevent_'node'.txt;
$!
$ search rcm_decevent_'node'.txt "* ENTRY"   !to show amount of fru entries in decevent output 
$!
$ open/read/error=fru_error infile rcm_decevent_'node'.txt   
$ msg = "rcm_fru_''node'.txt"
$ open/write/error=error_2 outfile rcm_fru_'node'.txt
$ write outfile "--- START RCM FRU ---"
$ readfile:
$  read/end=finish1 infile line
$  if f$locate("* ENTRY",line) .ne. f$length(line) 
$  then 
$    if flag .eq. 1 
$    then 
$      goto finish1
$    else
$      flag = 1
$      write outfile "''line'"
$      goto readfile
$    endif
$  else
$    write outfile "''line'"
$    goto readfile
$  endif
$!
$finish1:
$ close infile
$ write outfile ""
$ write outfile "--- END RCM FRU ---"
$ write outfile ""
$ close outfile
$!
$ direct/siz/date rcm_fru_'node'.txt
$!
$ convert 'fname'.txt, rcm_fru_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_fru_'node'.txt;, rcm_decevent_'node'.txt;*
$ return
$!
$!---------------------------------------------------------------------
$!
$fru_error:
$ write sys$output "''f$time()': No rcm_decevent_''node'.txt file found - no FRU entries"
$ write rcm_log "''f$time()': No rcm_decevent_''node'.txt file found - no FRU entries"
$ msg = "rcm_fru_''node'.txt"
$ open/write/error=error_2 outfile rcm_fru_'node'.txt
$ write outfile "--- START RCM FRU ---"
$ write outfile ""
$ write outfile "--- END RCM FRU ---"
$ write outfile ""
$ close outfile
$ convert 'fname'.txt, rcm_fru_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_fru_'node'.txt;
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$run_ct5:
$!
$! Alpha Systems with f$getsyi("systype") of 34 or greater support FRU Table 5. Use the CT5 Collector
$! to Collect the FRU entry from memory.
$!
$ write sys$output "''f$time()': Running CT5 Collector on ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Running CT5 Collector"
$ close mkr_log
$!
$ if f$search("RCM$ROOT:[CT5.BIN]GREADER.EXE") .eqs. ""     ! PTR91-21-109 changed from CT5.COM to GREADER.EXE
$ then
$    ! check if CT5 kit has been installed (self-extract kit is in RCM kit)
$    if f$search("RCM$DIR:CT5150_OVMS.EXE") .eqs. ""
$    then
$      write sys$output "Error: CT5 Collector is not installed on ''node'"
$      write sys$output "Alpha Systems with f$getsyi(""systype"") of 34 or greater support FRU Table 5."
$      write sys$output "Use the CT5 Collector to Collect the FRU entry from memory."
$      write sys$output ""
$      write sys$output "Please install the CT5 Collector and then run RCM again."
$      write sys$output ""
$      write rcm_log "''f$time()': Error: CT5 Collector is not installed on ''node'"
$      open/append/share/error=error_mkr mkr_log 'mkr_fil'
$      write mkr_log "''f$time()' : ''node6' Error: CT5 Collector is not installed"
$      close mkr_log
$      return
$    else 	!Expand the CT5 kit
$      curdir = f$environment("default")
$      set def RCM$DIR
$      CT := $RCM$DIR:CT5150_OVMS
$      CT -o                                                     ! overwrite existing files
$      set file/attr=(RFM:STMLF,RAT:CR) RCM$ROOT:[ct5.jars]rcmfru.jar
$      set security/prot=(o:rwed,s:rwed) RCM$ROOT:[ct5]output.dir;*
$      purge/nolog RCM$ROOT:[CT5...]*.*
$      set default 'curdir'
$    endif
$ endif
$!
$! Check if the DESTA Director process is running"
$!
$ nodesta = 0
$ show sys/process="DESTA Director"/noheading/out=desta_'node'.tmp
$ if f$file_attributes("desta_''node'.tmp", "eof") .eq. 0 
$ then 
$   delete desta_'node'.tmp;*
$   write sys$output "''f$time()': DESTA Director process not running - attempting to start on ''node'"
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' Trying to start DESTA Director"
$   close mkr_log
$!
$!  Check if SVCTOOLS_HOME Logical is defined:	
$!
$   if f$trnlnm("SVCTOOLS_HOME") .eqs. ""
$   then
$     if f$search("SYS$STARTUP:DESTA$STARTUP.COM") .eqs. "" 
$     then
$        write sys$output "SYS$STARTUP:DESTA$STARTUP not found! - Cannot start DESTA Director"  
$        write rcm_log "''f$time()': SYS$STARTUP:DESTA$STARTUP not found! - Cannot start DESTA Director"
$        open/append/share/error=error_mkr mkr_log 'mkr_fil'
$        write mkr_log "''f$time()' : ''node6' SYS$STARTUP:DESTA$STARTUP not found! - Cannot start DESTA Director" 
$        close mkr_log
$!
$! 	 run greader to get binary image of FRU
$  	 gosub run_greader
$!
$        return
$     endif
$     write sys$output "Executing SYS$STARTUP:DESTA$STARTUP" 
$     write rcm_log "''f$time()': Executing SYS$STARTUP:DESTA$STARTUP" 
$     open/append/share/error=error_mkr mkr_log 'mkr_fil'
$     write mkr_log "''f$time()' : ''node6' Executing SYS$STARTUP:DESTA$STARTUP" 
$     close mkr_log
$     @SYS$STARTUP:DESTA$STARTUP
$   else
$     DESTA START
$   endif
$!
$   wait 00:10:00
$!
$   show sys/process="DESTA Director"/noheading/out=desta_'node'.tmp
$!
$!  if the DESTA Director process is still not running, bail out.
$   if f$file_attributes("desta_''node'.tmp", "eof") .eq. 0 
$   then 
$      delete desta_'node'.tmp;*
$      write sys$output "''f$time()': DESTA Director could not be started on ''node'"
$      write rcm_log "''f$time()': DESTA Director could not be started on ''node'"
$      open/append/share/error=error_mkr mkr_log 'mkr_fil'
$      write mkr_log "''f$time()' : ''node6' DESTA Director could not be started"
$      close mkr_log
$!
$!     run greader to get binary image of FRU
$      gosub run_greader
$!
$      return
$   else
$      nodesta = 1
$      delete desta_'node'.tmp;*
$      write sys$output "''f$time()': DESTA Director successfully started on ''node'"
$      write rcm_log "''f$time()': DESTA Director successfully started on ''node'"
$      open/append/share/error=error_mkr mkr_log 'mkr_fil'
$      write mkr_log "''f$time()' : ''node6' DESTA Director successfully started"
$      close mkr_log
$   endif
$ endif
$!
$ write sys$output "''f$time()': Looking for Configuration Tree data on ''node'"
$ write rcm_log "''f$time()': Looking for Configuration Tree data on ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Looking for Configuration Tree data"
$ close mkr_log
$!
$ show system/process="DESTA Director"
$ show time
$ define CT5$OUTPUT CT5_'node'.HTML
$ @RCM$ROOT:[CT5.BIN]CT5.COM -m config -w 3600
$ show time
$!
$! If we started DESTA, we should stop it
$!
$ if nodesta .eq. 1
$ then
$   write sys$output "''f$time()': Stopping DESTA Director (because we started it) on ''node'"
$   write rcm_log "''f$time()': Stopping DESTA Director (because we started it) on ''node'"
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' Stopping DESTA Director (because we started it)"
$   close mkr_log
$   DESTA STOP
$   wait 00:00:30
$ endif
$!
$ if f$search("CT5_''node'.HTML") .nes. ""
$ then
$!    Extract the data between the lines CT5START and CT5END
$     define/user sys$output NLA0:
$     define/user sys$error NLA0:
$     search/window=(100000,0)/exact/output=ct5_'node'.tmp/format=passall CT5_'node'.HTML CT5END  ! get from start to CT5END
$     if $status .ne. 1 
$     then 
$        write sys$output "''f$time()': No CT5END tag found in CT5 output on ''node'"
$        write rcm_log "''f$time()': No CT5END tag found in CT5 output on ''node'"
$        open/append/share/error=error_mkr mkr_log 'mkr_fil'
$        write mkr_log "''f$time()' : ''node6' No CT5END tag found in CT5 output"
$        close mkr_log
$!
$! 	 run greader to get binary image of FRU
$  	 gosub run_greader
$!
$        return
$     endif
$     search/remaining/out=ct5_'node'.txt/exact CT5_'node'.TMP/format=passall  CT5START    ! get from CT5START to end
$     delete ct5_'node'.tmp;
$     open/write/error=error_3 hdr ct5_'node'.hdr
$     write hdr ""
$     write hdr "--- START RCM CT5 ---"
$     close hdr
$     open/write/error=error_3  end ct5_'node'.end
$     write end ""
$     write end "--- END RCM CT5 ---"
$     write end "" 
$     close end
$     convert ct5_'node'.hdr, ct5_'node'.txt, ct5_'node'.end rcm_ct5_'node'.txt
$     delete ct5_'node'.hdr;, ct5_'node'.txt;, ct5_'node'.end;
$     convert 'fname'.txt, rcm_ct5_'node'.txt rcm_'node'.tmp
$     rename rcm_'node'.tmp 'fname'.txt
$     purge 'fname'.txt, ct5_'node'.html
$     delete rcm_ct5_'node'.txt;
$     delete CT5_'node'.HTML;             ! dont want to include in ZIP if it OK. i.e. has CT5STARt and CT5END
$ else
$     write sys$output "''f$time()': No output created from CT5 Collector on ''node'"
$     write rcm_log "''f$time()': No output created from CT5 Collector on ''node'"
$     open/append/share/error=error_mkr mkr_log 'mkr_fil'
$     write mkr_log "''f$time()' : ''node6' No output created from CT5 Collector"
$     close mkr_log
$!
$!    run greader to get binary image of FRU
$     gosub run_greader
$!
$ endif
$ return
$!
$!-------------------------------------------------------------------------------------------
$ run_greader:
$   gr := $rcm$root:[ct5.bin]greader.exe 
$!
$   show time
$   gr -s 'node'.CT5 
$   show time
$   direct/size/date *.ct5
$ return
$!--------------------------------------------------------------------------------------------
$!
$ get_operating_system:
$ write sys$output "''f$time()': Getting Operating System details on ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Operating System details on ''node'"
$ close mkr_log
$ write rcm_log "''f$time()': ''node6' Getting Operating System version"
$ open/write/error=error_3  outopfile rcm_op_'node'.txt
$ write outopfile "--- START RCM OPERATING SYSTEM ---"
$ optyp = f$edit(f$getsyi("node_swtype"), "trim")
$ opver = f$edit(f$getsyi("version"), "trim")  !PTR 36-4-538 9-Mar-1999,node_swvers only gets 4 chars
$ cons = ""
$ palv = "" 
$ if ALPHA
$ then
$    cons = f$edit(f$getsyi("console_version"), "trim")
$    palv = f$getsyi("palcode_version")
$    palv = f$edit(f$extract(0, 8, palv), "TRIM")
$ endif
$ write outopfile "Operating System = ''optyp' ''opver'"
$ write outopfile "Console Version = ''cons'"
$ write outopfile "Palcode Version = ''palv'"
$ write outopfile "--- END RCM OPERATING SYSTEM ---"
$ write outopfile ""
$ close outopfile
$!
$ convert 'fname'.txt, rcm_op_'node'.txt rcm_'node'.tmp
$ delete rcm_op_'node'.txt;
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ return
$!--------------------------------------------------------------------------------------------
$!
$!
$!--------------------------------------------------------------------------------------------
$get_node_info:
$ hwname = f$getsyi("hw_name")
$ write sys$output "''f$time()': Getting Node info for ''node' : ''hwname'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Node Info : ''hwname'"
$ close mkr_log
$ write rcm_log "''f$time()': Getting Node Info for ''node' : ''hwname'"
$ dom = "''F$TRNLNM("UCX$INET_DOMAIN")'"
$ open/write/error=error_3  outnodefile rcm_node_'node'.txt
$ write outnodefile "--- START RCM NODE ---"
$ write outnodefile "Node Host Name = ''node'"
$ write outnodefile "Node System Type = ''hwname'"
$ write outnodefile "Node Domain Name = ''dom'"
$ write outnodefile "--- END RCM NODE ---"
$ write outnodefile ""
$ close outnodefile
$!
$ convert 'fname'.txt, rcm_node_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_node_'node'.txt;
$ return
$!--------------------------------------------------------------------------------------------
$!
$!--------------------------------------------------------------------------------------------
$ get_cluster_info:
$ write sys$output "''f$time()': Getting Cluster info"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Cluster info"
$ close mkr_log
$ write rcm_log "''f$time()': Getting Cluster info"
$ open/write/error=error_3  commands RCM_CLUSTER_'node'.INI
$ write commands "add SYS_ID"
$ write commands "add HW_VER"
$ write commands "add HW_TYPE"
$ write commands "set HW_TYPE/width=30"
$ write commands "set SYS_ID/width=20"
$! write commands "remove MEMBER"
$ close commands
$ init_file = "RCM_CLUSTER_''node'.INI"
$ define/nolog/user show_cluster$init 'f$search(init_file)'
$ show cluster/ending=00:00:01/interval=10/output=CLUSTER_'node'.TXT
$ delete RCM_CLUSTER_'node'.INI;*
$!
$!------------------------------------------
$! Go through Cluster output and replace VMS Verions by correct versions - SH CLUS truncates to Vx.y
$! PTR 91-22-268
$!
$ open/read clus cluster_'node'.txt
$ open/write clout cluster_'node'.tmp
$ cloop:
$ read/end=endcloop clus rec
$ xrec = f$edit(rec, "collapse")
$ if xrec .eqs. "" then goto cloop
$ cver = f$ele(5,"|", rec)
$ mem = f$edit(f$ele(6,"|", rec), "trim")
$ if ((mem .eqs. "MEMBER") .or. (mem .eqs. "")) .and. (f$locate("VMS", rec) .ne. f$len(rec)) 
$ then 
$   ver = "???"
$   cnod = f$edit(f$ele(1, "|", rec), "trim")
$   ver = f$edit(f$getsyi("version", "''cnod'"),"trim")
$   if ver .nes "" .and. f$locate(ver,cver) .eq. f$len(cver)
$   then
$     parta = f$extract(0, f$loc("| VMS", rec) + 5, rec)
$     partb = f$extract(f$loc("| VMS", rec) + 10, 20, rec)
$     write clout "''parta' ''ver'''partb'"
$   else
$     write clout rec
$   endif
$ else
$   write clout rec
$ endif
$ goto cloop
$ endcloop:
$ close clus
$ close clout
$ purge cluster_'node'.tmp
$ rename cluster_'node'.tmp cluster_'node'.txt
$ purge cluster_'node'.txt/keep=2
$!--------------------------------------------
$ cluster_alias = "''F$TRNLNM("SYS$CLUSTER_NODE")'" - "::"
$ if cluster_alias .eqs. "" then cluster_alias = "none"
$ open/write/error=error_3  clusfil rcm_cluster_'node'.txt
$ write clusfil "--- START RCM CLUSTER ---"
$ write clusfil ""
$ write clusfil "Cluster Name = ''cluster_alias'"
$ write clusfil ""
$ open/read inclus cluster_'node'.txt
$ clusloop:
$ read/end=endclus inclus clusrec
$ if f$locate("", clusrec) .nes. f$length(clusrec) then goto clusloop
$ if f$locate("View of Cluster", clusrec) .nes. f$length(clusrec) then clusrec = f$edit(clusrec, "compress")
$ tmprec = f$edit(clusrec, "trim")
$ if tmprec .eqs. ""  then goto clusloop
$ write clusfil clusrec
$ goto clusloop
$ endclus:
$ close inclus
$ write clusfil ""
$ write clusfil ""
$ write clusfil "--- END RCM CLUSTER ---"
$ write clusfil ""
$ close clusfil
$ convert 'fname'.txt, rcm_cluster_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_cluster_'node'.txt;, cluster_'node'.txt;*
$ return
$!
$!--------------------------------------------------------------------------------------------
$get_cpu_info:
$ write sys$output "''f$time()': Getting CPU Info"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting CPU Information"
$ close mkr_log
$ write rcm_log "''f$time()': Getting CPU Info"
$ if f$search("cpu_''node'.txt") .nes. "" then delete/nolog cpu_'node'.txt;* ! may be left over from failed coll
$ define/user sys$output cpu_'node'.txt
$ show cpu/full
$!
$ define/user sys$output NLA0:
$ edit/tpu/nosec/nodisplay/command=replace.tpu cpu_'node'.txt  !remove nulls
$ purge/nolog cpu_'node'.txt
$!
$ open/write/error=error_3  hdr cpu_'node'.hdr
$ write hdr "--- START RCM CPU ---"
$ write hdr ""
$ close hdr
$!
$ open/write/error=error_3  end cpu_'node'.end
$ write end ""
$!
$ if .not. ALPHA
$ then   ! for VAX look in Error log to try to get CPU Module and revs - just get TIME STAMP line
$    analyze/error/entry=end:200/out=anaerr_'node'.txt
$    if f$search("anaerr_''node'.txt") .nes. ""
$    then
$       define/user sys$output NLA0:
$       define/user sys$error NLA0:
$       search/out=anaerr1_'node'.txt anaerr_'node'.txt "TIME STAMP"
$       if $STATUS .eq. 1
$       then
$          open/read errfil anaerr1_'node'.txt
$          read errfil errrec
$          close errfil
$!                    !e.g.  TIME STAMP  KA692-AA  CPU Microcode Rev # 2.  CONSOLE FW REV# 2.3
$! 		      !	or could be:
$!                    !e.g.  TIME STAMP  KA7AA-AA  CPU FW REV# 2.  CONSOLE FW REV# 0.3
$          write end ""
$          write end errrec
$          write end ""
$       endif
$    endif   
$ endif
$!
$ write end "--- END RCM CPU ---"
$ write end ""
$ close end
$ convert cpu_'node'.hdr, cpu_'node'.txt, cpu_'node'.end rcm_cpu_'node'.txt
$ delete cpu_'node'.hdr;, cpu_'node'.txt;, cpu_'node'.end; 
$!
$ convert 'fname'.txt, rcm_cpu_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_cpu_'node'.txt;
$ return
$!
$!
$!--------------------------------------------------------------------------------------------
$get_galaxy_info:
$ partid = -1
$!
$ define sys$output NLA0:    !suppress error if this version of VMS does
$ define sys$error NLA0:     !not support this getsyi item
$ partid = f$getsyi("PARTITION_ID")
$ deassign sys$output
$ deassign sys$error
$!
$ if partid .eq. -1 then return 
$!
$ write sys$output "''f$time()': Getting GALAXY Info"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting GALAXY Information"
$ close mkr_log
$ write rcm_log "''f$time()': Getting GALAXY Info"
$ if f$search("galaxy_''node'.txt") .nes. "" then delete/nolog galaxy_'node'.txt;* 
$!
$ define sys$output galaxy_'node'.txt 
$ write sys$output "SCSNODE         = ''f$getsyi("scsnode")'"
$ write sys$output "GALAXY_PLATFORM = ''f$getsyi("galaxy_platform")'" 
$ write sys$output "GALAXY_MEMBER   = ''f$getsyi("galaxy_member")'" 
$ write sys$output "GALAXY_ID       = ''f$getsyi("galaxy_id")'"
$ write sys$output "COMMUNITY_ID    = ''f$getsyi("community_id")'"
$ write sys$output "PARTITION_ID    = ''f$getsyi("partition_id")'"
$ write sys$output  ""
$!
$ analyze/system
SHOW GALAXY
EXIT
$!
$ deassign sys$output
$!
$!
$ open/write/error=error_3  hdr galaxy_'node'.hdr
$ write hdr "--- START RCM GALAXY ---"
$ write hdr ""
$ close hdr
$!
$ open/write/error=error_3  end galaxy_'node'.end
$ write end ""
$ write end "--- END RCM GALAXY ---"
$ write end ""
$ close end
$ convert galaxy_'node'.hdr, galaxy_'node'.txt, galaxy_'node'.end rcm_galaxy_'node'.txt
$ delete galaxy_'node'.hdr;, galaxy_'node'.txt;, galaxy_'node'.end; 
$!
$ convert 'fname'.txt, rcm_galaxy_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_galaxy_'node'.txt;
$ return
$!--------------------------------------------------------------------------------------------
$ get_scsi_info:
$ write sys$output "''f$time()': Getting CLUE SCSI info"
$ if ALPHA
$ then
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' Getting CLUE SCSI Information"
$   close mkr_log
$   write rcm_log "''f$time()': Getting CLUE SCSI Info"
$!
$   open/write/error=error_3  scsifil scsi_'node'.com
$   write scsifil "$analyze/system"
$   write scsifil "SET OUTPUT SCSI_''node'.txt"    ! Can't use /NOINDEX - only introduced in V7
$   write scsifil "CLUE SCSI/SUMMARY"
$   write scsifil "EXIT"
$   write scsifil "$exit"
$   close scsifil
$   @scsi_'node'
$   search/remaining/out=scsi_'node'.txt1 scsi_'node'.txt "table of contents"
$   search/remaining/match=and/out=scsi_'node'.txt2 scsi_'node'.txt1 "(TM)", "Page"
$   search/match=nor/out=scsi_'node'.txt scsi_'node'.txt2 "(TM)", ""  
$   delete scsi_'node'.txt1;
$   delete scsi_'node'.txt2;
$   delete scsi_'node'.com;
$   purge scsi_'node'.txt
$ else
$    open/append/share/error=error_mkr mkr_log 'mkr_fil'
$    write mkr_log "''f$time()' : ''node6' Skipping CLUE SCSI Information (VAX)"
$    close mkr_log
$    create scsi_'node'.txt
$ endif
$ open/write/error=error_3  hdr scsi_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM SCSI ---"
$ close hdr
$ open/write/error=error_3  end scsi_'node'.end
$ write end ""
$ write end "--- END RCM SCSI ---"
$ write end ""
$ close end
$ convert scsi_'node'.hdr, scsi_'node'.txt, scsi_'node'.end rcm_scsi_'node'.txt
$ delete scsi_'node'.hdr;, scsi_'node'.txt;, scsi_'node'.end;
$!
$ convert 'fname'.txt, rcm_scsi_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_scsi_'node'.txt;
$ return
$!
$!--------------------------------------------------------------------------------------------
$ get_clueconfig_info:
$ write sys$output "''f$time()': Getting CLUE CONFIG info"
$ if ALPHA
$ then
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' Getting CLUE CONFIG Information"
$   close mkr_log
$   write rcm_log "''f$time()': Getting CLUE CONFIG Info"
$!
$   open/write/error=error_3  clufil clueconfig_'node'.com
$   write clufil "$analyze/system"
$   write clufil "SET OUTPUT CLUECONFIG_''node'.txt"    ! Can't use /NOINDEX - only introduced in V7
$   write clufil "CLUE CONFIG"
$   write clufil "EXIT"
$   write clufil "$exit"
$   close clufil
$   @clueconfig_'node'
$   search/remaining/out=clueconfig_'node'.txt1 clueconfig_'node'.txt "table of contents"
$   search/remaining/match=and/out=clueconfig_'node'.txt2 clueconfig_'node'.txt1 "(TM)", "Page"
$   search/match=nor/out=clueconfig_'node'.txt clueconfig_'node'.txt2 "(TM)", ""  
$   delete clueconfig_'node'.txt1;
$   delete clueconfig_'node'.txt2;
$   delete clueconfig_'node'.com;
$   purge clueconfig_'node'.txt
$ else
$    open/append/share/error=error_mkr mkr_log 'mkr_fil'
$    write mkr_log "''f$time()' : ''node6' Skipping CLUE CONFIG Information (VAX)"
$    close mkr_log
$    create clueconfig_'node'.txt
$ endif
$ open/write/error=error_3  hdr clueconfig_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM CLUECONFIG ---"
$ close hdr
$ open/write/error=error_3  end clueconfig_'node'.end
$ write end ""
$ write end "--- END RCM CLUECONFIG ---"
$ write end ""
$ close end
$ convert clueconfig_'node'.hdr, clueconfig_'node'.txt, clueconfig_'node'.end rcm_clueconfig_'node'.txt
$ delete clueconfig_'node'.hdr;, clueconfig_'node'.txt;, clueconfig_'node'.end;
$!
$ convert 'fname'.txt, rcm_clueconfig_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_clueconfig_'node'.txt;
$ return
$!
$!------------------------------------------------------------------------
$!
$ get_deviceinfo:
$ write rcm_log "''f$time()': Getting Device details for ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Device details for ''node'"
$ close mkr_log
$ show device d/out=device_'node'.tmp
$ search/output=device1_'node'.tmp device_'node'.tmp mounted
$ delete/nolog/noconf device_'node'.tmp;
$ open/write/error=error_3  devicefil device_'node'.txt
$ open/read device_list device1_'node'.tmp
$ device_loop:
$ read/end=done device_list record
$ device = f$extract(0,f$locate(":",record),record)
$ if .not. f$getdvi(device,"exists") then goto device_loop
$ if .not. f$getdvi(device,"mnt") then goto device_loop
$ if f$getdvi (device,"net") then goto device_loop
$ blkcnt = F$GETDVI(device,"MAXBLOCK")
$ frecnt = F$GETDVI(device,"FREEBLOCKS")
$ volnam = F$EDIT(F$GETDVI(device,"VOLNAM"),"TRIM")
$ devtypnam = f$getdvi(DEVICE, "DEVICE_TYPE_NAME")
$!
$ write devicefil "''device', ''volnam', ''devtypnam', ''blkcnt', ''frecnt'"
$ goto device_loop
$ done:
$ close device_list
$ close devicefil
$ delete device1_'node'.tmp;
$!
$ open/write/error=error_3  hdr device_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM DEVICE ---"
$ write hdr ""
$ close hdr
$ open/write/error=error_3  end device_'node'.end
$ write end ""
$ write end "--- END RCM DEVICE ---"
$ write end ""
$ close end
$ convert device_'node'.hdr, device_'node'.txt, device_'node'.end rcm_device_'node'.txt
$ delete device_'node'.hdr;, device_'node'.txt;, device_'node'.end;
$!
$ convert 'fname'.txt, rcm_device_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_device_'node'.txt;
$ return
$!
$!------------------------------------------------------------------------
$!
$ get_extended_deviceinfo:
$ write rcm_log "''f$time()': Getting Extended Device details for ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Extended Device details for ''node'"
$ close mkr_log
$ get_edeviceinfo:
$ show device d/out=edevice_'node'.tmp
$ search/output=edevice1_'node'.tmp edevice_'node'.tmp ":"
$ delete/nolog/noconf edevice_'node'.tmp;
$ open/write/error=error_3  edevicefil edevice_'node'.txt
$ open/read edevice_list edevice1_'node'.tmp
$ write edevicefil "! device volume  device  blkcnt, frecnt, shdw    volume  logical, root    allocation"
$ write edevicefil "!         name   type                    master  set,     name,   device  class"
$ write edevicefil "!                name                    name,   member           name    "
$ write edevicefil "!"
$ edevice_loop:        
$ read/end=edone edevice_list record
$ device = f$extract(0,f$locate(":",record),record)
$ if .not. f$getdvi(device,"exists") then goto edevice_loop
$ if f$getdvi (device,"net") then goto edevice_loop
$ blkcnt = F$GETDVI(device,"MAXBLOCK")
$ frecnt = F$GETDVI(device,"FREEBLOCKS")
$ volnam = F$EDIT(F$GETDVI(device,"VOLNAM"),"TRIM")
$ devtypnam = f$getdvi(DEVICE, "DEVICE_TYPE_NAME")
$ tmp_shdw_master = f$getdvi(DEVICE,"SHDW_MASTER_NAME")
$ shdw_master_name = f$extract(1,f$locate(":",tmp_shdw_master)-1, tmp_shdw_master)
$ volset_name = f$getdvi(DEVICE,"VOLSETMEM") 
$ logvol_name = f$getdvi(DEVICE,"logvolnam") 
$ tmp_rootdev_name = f$getdvi(DEVICE,"ROOTDEVNAM")
$ rootdev_name = f$extract(1,f$locate(":",tmp_rootdev_name)-1, tmp_rootdev_name)
$ allocation_class = f$getdvi(DEVICE,"alloclass")
$!
$ write edevicefil "''device', ''volnam', ''devtypnam', ''blkcnt', ''frecnt', ''shdw_master_name', ''volset_name', ''logvol_name', ''rootdev_name', ''allocation_class'"
$ goto edevice_loop
$ edone:
$ close edevice_list
$ close edevicefil
$ delete edevice1_'node'.tmp;
$!
$ open/write/error=error_3  hdr edevice_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM DEVICE EXTENDED ---"
$ write hdr ""
$ close hdr
$ open/write/error=error_3  end edevice_'node'.end
$ write end ""
$ write end "--- END RCM DEVICE EXTENDED ---"
$ write end ""
$ close end
$ convert edevice_'node'.hdr, edevice_'node'.txt, edevice_'node'.end rcm_device_'node'.txt
$ delete edevice_'node'.hdr;, edevice_'node'.txt;, edevice_'node'.end;
$!
$ convert 'fname'.txt, rcm_device_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_device_'node'.txt;
$ return
$!
$!------------------------------------------------------------------------
$!
$ get_tapeinfo:
$ write rcm_log "''f$time()': Getting Tape details for ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Tape details for ''node'"
$ close mkr_log
$!
$ create tape_'node'.txt
$ create etape_'node'.txt
$ open/write tapext etape_'node'.txt
$ write tapext "TapeName, Type, Media,  MNT,  Host"
$!
$ TAPE_LIST_CONTEXT = 0
$ TAPELOOP:
$       TAPE_NAME = F$DEVICE("*","TAPE",,TAPE_LIST_CONTEXT)
$       IF (TAPE_NAME .EQS. "") THEN GOTO TAPEDONE
$       show device/full/output=tape_'node'.tmp 'tape_name'
$       append tape_'node'.tmp tape_'node'.txt
$       delete tape_'node'.tmp;*
$       devtypnam = f$getdvi(tape_name,"DEVICE_TYPE_NAME")
$       media_name = f$getdvi(tape_name,"MEDIA_NAME")
$       mnt = f$getdvi(tape_name,"MNT")
$       host_name = f$getdvi(tape_name,"HOST_NAME")
$!       write sys$output "''tape_name', ''devtypnam', ''media_name', ''mnt', ''host_name'"
$       write tapext "''tape_name', ''devtypnam', ''media_name', ''mnt', ''host_name'"
$       GOTO TAPELOOP
$ TAPEDONE:
$!
$ close tapext
$!
$ open/write/error=error_3  hdr tape_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM TAPE ---"
$ write hdr ""
$ close hdr
$ open/write/error=error_3  end tape_'node'.end
$ write end ""
$ write end "--- END RCM TAPE ---"
$ write end ""
$ close end
$ convert tape_'node'.hdr, tape_'node'.txt, tape_'node'.end rcm_tape_'node'.txt
$ delete tape_'node'.hdr;, tape_'node'.txt;*, tape_'node'.end;
$!
$ convert 'fname'.txt, rcm_tape_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_tape_'node'.txt;
$!
$ open/write/error=error_3  hdr etape_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM TAPE EXTENDED ---"
$ write hdr ""
$ close hdr
$ open/write/error=error_3  end etape_'node'.end
$ write end ""
$ write end "--- END RCM TAPE EXTENDED ---"
$ write end ""
$ close end
$ convert etape_'node'.hdr, etape_'node'.txt, etape_'node'.end rcm_tape_'node'.txt
$ delete etape_'node'.hdr;*, etape_'node'.txt;*, etape_'node'.end;*
$!
$ convert 'fname'.txt, rcm_tape_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_tape_'node'.txt;
$ return
$!
$!------------------------------------------------------------------------
$ get_soft_info:
$ DEFINE/nolog LOA SYS$LOADABLE_IMAGES
$ DEFINE/nolog SYS SYS$SYSTEM
$ DEFINE/nolog ROO SYS$SYSROOT
$ DEFINE/nolog SHA SYS$SHARE
$ DEFINE/nolog SDV SYS$SYSDEVICE
$ DEFINE/nolog LOG LNM$FILE_DEV
$!
$ if ALPHA
$ then
$    K_MAJORID = 3
$    IHI_Q_LINKTIME = 8
$    IHD_X_IMGIDOFF = 24   ! From EIHD$L_IMGIDOFF
$    IHI_T_IMGNAM   = 16   ! From EIHI$T_IMGNAM
$    IHI_T_IMGID    = 56   ! From EIHI$T_IMGID
$    IHI_T_LINKID   = 72   ! From EIHI$T_LINKIID
$    offset_bits    = 32
$    PLATFORM      := ALPHA 
$    imgtyp = "A"
$ else
$    K_MAJORID = 12848
$    IHI_Q_LINKTIME = 56
$    IHD_X_IMGIDOFF = 6    ! From IHD$W_IMGIDOFF
$    IHI_T_IMGNAM   = 0    ! From IHI$T_IMGNAM
$    IHI_T_IMGID    = 40   ! From IHI$T_IMGID
$    IHI_T_LINKID   = 64   ! From IHI$T_LINKIID
$    offset_bits    = 16
$    PLATFORM      := VAX 
$    imgtyp = "V"
$ endif
$ offset_bytes = offset_bits/8
$!
$ open/write/error=error_3  softfile RCM_SOFT_'node'.TXT
$!
$ if imgtyp .eqs. "A" then rcmsoft = "RCM$DIR:RCM$SOFT_ALPHA.LIST"
$ if imgtyp .eqs. "V" then rcmsoft = "RCM$DIR:RCM$SOFT_VAX.LIST"
$!
$ if f$search(rcmsoft) .eqs. ""
$ then
$   write sys$output "''rcmsoft' is missing!"
$   write softfile "''rcmsoft' is missing!"
$   close softfile
$   return
$ endif
$!
$ write sys$output "''f$time()': Getting Software details"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Software details"
$ close mkr_log
$ write rcm_log "''f$time()': Getting Software details for ''node'"
$ write softfile ""
$ write softfile "--- START RCM SOFTWARE ---"
$ write softfile ""
$ write softfile "Software List for ''node'"
$ write softfile ""
$ write softfile "Product Name                               UPI Version        Cur V  Disk             Directory                        Image            Linktime"
$ write softfile "_____________________________________________________________________________________________________________________________________"
$!
$ open/read/share soft 'rcmsoft
$ softloop:
$   read/end=endsoft soft rec
$   if f$extract(0,1,rec) .eqs. "!" then goto softloop   !ignore comment lines
$   if f$locate("|", rec) .ne. f$length(rec) then  gosub getdata
$ goto softloop
$endsoft:
$close soft
$!
$ rcmsoft1 = "RCM$DIR:RCM$SOFT_CUSTOM.LIST"
$ if f$search(rcmsoft1) .nes. ""
$ then  
$  write sys$output "''f$time()': Getting Custom Software details"
$  open/append/share/error=error_mkr mkr_log 'mkr_fil'
$  write mkr_log "''f$time()' : ''node6' Getting Custom Software details"
$  close mkr_log
$  write rcm_log "''f$time()': Getting Custom Software details for ''node'"
$  open/read/share soft 'rcmsoft1
$  softloopcust:
$   read/end=endsoftcust soft rec
$   if f$extract(0,1,rec) .eqs. "!" then goto softloopcust   !ignore comment lines
$   if f$locate("|", rec) .ne. f$length(rec) then gosub getdata
$   goto softloopcust
$ endsoftcust:
$!
$!!! insert data from PRODUCT SHOW PRODUCT ( is in file prodhis1_<node>.tmp )
$!
$ if f$search("prodhis1_''node'.tmp") .nes. ""
$ then
$   search prodhis1_'node'.tmp "Installed"/out=prodhis2_'node'.tmp
$   if $severity .ne. 1 then goto finishsoft
$   open/read sfil prodhis2_'node'.tmp
$   sftloop:
$    read/end=endsftloop sfil sftrec
$    desc = f$ele(0," ",sftrec) + " " + f$ele(1, " ",sftrec) + " " + f$ele(2, " ", sftrec)
$    upi = "   "
$    rev = f$ele(3, " ", sftrec)
$    cv = " "
$    dev = " "
$    locn = " "
$    img = " "
$    linktim = " "
$    desc = f$extract(0,42,desc + "                                                       ")
$    upi = f$extract(0,3,upi + "   ")
$    rev = f$extract(0, 15, rev + "                    ")
$    cv = f$extract(0, 6, cv + "      ")
$    dev = dev + "                       "
$    dev = f$extract(0,16,dev)
$    locn = f$extract(0, 32, locn + "                                      ")
$    img = f$extract(0, 16, img + "                                  ")
$    write softfile "''desc'|''upi'|''rev'|''cv'|''dev'|''locn'|''img'|''linktim'"
$    goto sftloop
$   endsftloop:
$   close sfil
$   delete prodhis%_'node'.tmp;*
$ endif
$!
$finishsoft:
$ close soft
$ endif
$write softfile ""
$write softfile "--- END RCM SOFTWARE ---"
$close softfile
$!
$ convert 'fname'.txt, rcm_soft_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_soft_'node'.txt;
$ return
$!
$!---------------------------------------------------------------------------------------
$ getdata:
$   fnam = f$extract(f$locate("|", rec)+2, 100, rec)
$   define/user sys$output NLA0:
$   define/user sys$error NLA0:
$   directory 'fnam
$   if $status .eq. 1 
$   then 
$       desc = f$extract(0, f$locate("|", rec)-6, rec)
$       desc = f$edit(desc, "TRIM")
$       desc =  desc + "                                                 "
$       desc = f$extract(0, 42, desc)
$       cv =  f$extract(f$locate("|", rec)-7, 4, rec)
$       cv = "V" + f$extract(0,2,cv) + "." + f$extract(2,2,cv) - " "
$       upi =  f$extract(f$locate("|", rec)-3, 3, rec)
$ 	num = 0
$ 	softloop1:
$    	   ele = f$edit(f$element(num, ",", fnam), "trim,upcase")
$          if ele .eqs. "," then goto end1
$!
$!         PTR 91-21-55  -- if signature does not specify file type assume .EXE
$!
$          tmpele = ele
$          if f$loc(":", tmpele) .ne. f$len(tmpele) then tmpele = f$extract(f$loc(":", tmpele)+1, 40, tmpele)
$          if f$loc("]", tmpele) .ne. f$len(tmpele) then tmpele = f$extract(f$loc("]", tmpele)+1, 40, tmpele)
$          if f$loc(".", tmpele) .eq. f$len(tmpele) then ele = ele + ".EXE"
$!
$          filspec = f$search(ele)
$          if filspec .nes. "" 
$          then 
$!            Look for the last file spec returned by f$search for this (wildcarded?) image
$!            The last one returned should be the highest rev, eg, RDO60, RDO61, etc
$!            Note: there appears to be a bug in DASC - it will report the rev for RDO60 if RDO60 and RDO61 are present
$             ele = ele + ";"          ! to initialise f$search
$ 	      prev_img = ""
$	      imgloop:
$             filspec = f$search("''ele'")
$             if filspec .eqs. prev_img then goto endimg
$             if filspec .eqs. "" then goto endimg
$             prev_img = filspec
$             goto imgloop
$             endimg:
$             filspec = prev_img
$             dirn = f$parse(filspec,,,"directory")
$             devn = f$parse(filspec,,,"device")
$             locn = devn + dirn
$             if f$locate("LOA:", ele) .ne. f$length(ele) then locn = "SYS$LOADABLE_IMAGES"
$             if f$locate("SYS:", ele) .ne. f$length(ele) then locn = "SYS$SYSTEM"
$             if f$locate("ROO:", ele) .ne. f$length(ele) then locn = "SYS$SYSROOT"
$             if f$locate("SYD:", ele) .ne. f$length(ele) then locn = "SYS$SYSDEVICE"
$             if f$locate("SHA:", ele) .ne. f$length(ele) then locn = "SYS$SHARE"
$             if f$locate("LOG:", ele) .ne. f$length(ele) then locn = "LNM$FILE_DEV"
$             cv = f$extract(0, 6, cv + "      ")
$             dev = f$parse(ele,,,"device", "no_conceal")
$             dev = dev + "                "
$             dev = f$extract(0,16,dev)
$             img = f$parse(filspec,,,"name")
$             locn = f$extract(0, 32, locn + "                                      ")
$             img = f$extract(0, 16, img + "                                  ")
$	      !
$	      ! Now get the rev from the image
$	      !
$             imgok = 0
$!             
$!            PTR 91-21-55 skip get_imgid unless its a .exe
$!
$             if f$loc(".EXE", filspec) .ne. f$len(filspec)
$             then
$                if f$file_attributes("''filspec'", "eof") .ge. 1 then gosub get_imgid  !must be at least 1 block
$             else
$                rev = "               "
$                linktim = "                       "
$                imgok = 1
$             endif
$             !
$             ! write sys$output "''desc' ''imgtyp' ''upi' ''rev' ''cv' ''dev' ''locn' ''linktim'"
$             if imgok .eq. 1 then write softfile "''desc'|''upi'|''rev'|''cv'|''dev'|''locn'|''img'|''linktim'"
$             goto end1
$          endif
$       num = num + 1
$       goto softloop1
$       end1:
$   endif
$return
$!----------------------------------------------------------------------------------------
$!
$get_imgid:
$   rev = "               "
$   linktim = "                       "
$   open/read/share img% 'filspec
$   read img% ihd_buffer
$   close img%
$   if imgtyp .eqs. "A" then majorid = f$cvui(0, 8, f$extract(0, 1, ihd_buffer))
$   if imgtyp .eqs. "V" then majorid = f$cvui(0, 16, f$extract(12, 2, ihd_buffer))
$   if majorid .ne. K_MAJORID
$   then
$      imgok = 0
$      return
$   else
$       imgok = 1
$   endif
$!
$if (IHD_X_IMGIDOFF + offset_bytes) .gt. f$length(ihd_buffer) 
$then 
$	off1 = IHD_X_IMGIDOFF + offset_bytes
$	len1 = f$len(ihd_buffer)
$   	write sys$output "File: ''filspec'"
$	write sys$output "Offset ''off1' greater than buffer length ''len1'"
$	return
$endif
$!
$   ihi_offset = f$cvui( 0, offset_bits, f$extract( IHD_X_IMGIDOFF, offset_bytes, ihd_buffer ) )
$!
$ x = f$len(ihd_buffer) - IHI_T_LINKID - 8
$if ihi_offset .gt. x
$then 
$   	write sys$output "File: ''filspec': Something wrong with offset! (''ihi_offset')"
$	return
$endif
$!
$   len      = f$cvui( 0, 8, f$extract( ihi_offset+IHI_T_IMGNAM, 1, ihd_buffer ) )
$   imgnam   = f$extract( ihi_offset+IHI_T_IMGNAM+1, len,           ihd_buffer )
$   len      = f$cvui( 0, 8, f$extract( ihi_offset+IHI_T_IMGID,  1, ihd_buffer ) )
$   imgid    = f$extract( ihi_offset+IHI_T_IMGID+1,  len,           ihd_buffer )
$   len      = f$cvui( 0, 8, f$extract( ihi_offset+IHI_T_LINKID, 1, ihd_buffer ) )
$   linkid   = f$extract( ihi_offset+IHI_T_LINKID+1, len,           ihd_buffer )
$   offset = ihi_offset+IHI_Q_LINKTIME
$   linktim = f$fao("!%D",offset+f$cvui(32,32,f$fao("!AD",8,ihd_buffer)))
$   rev = imgid
$   rev = rev + "                  "
$   rev = f$extract(0, 15, rev)
$   linktim = linktim + "                 "
$   linktim = f$extract(0, 23, linktim)
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$ get_propatch_data:
$!
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Propatch data"
$ close mkr_log
$ write sys$output "''f$time()': Getting Propatch details"
$!
$ par1 = f$edit(company_name, "compress,trim")
$ @RCM$DIR:rcm_propatch.com 'par1'
$ return
$!
$!---------------------------------------------------------------------------------------------
$!
$ get_alpha_patches:
$!
$! For Alpha look for Patch Information in SYS$UPDATE:VMSINSTAL.HISTORY
$! Alpha Patches will start with ALP
$!
$ if .not. ALPHA then return
$!
$ write sys$output "''f$time()': Getting Alpha patch details"
$ write rcm_log "''f$time()': Getting Alpha patch details for ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Alpha patch details"
$ close mkr_log
$ open/write/error=error_3  patchfile RCM_PATCH_'node'.TXT
$ write patchfile ""
$ write patchfile "--- START RCM PATCHES ---"
$ write patchfile ""
$ if f$search("sys$update:vmsinstal.history") .eqs. "" then goto finishALPpatch
$ write patchfile "Patch Information for Alpha node ''node' from SYS$UPDATE:VMSINSTAL.HISTORY"
$ write patchfile ""
$ write patchfile "Patch Name           Version   Install Date    Status     Node    Installer"
$ write patchfile "____________________________________________________________________________"
$ search/output=tmppatch_'node'.tmp sys$update:vmsinstal.history "| ALP"
$ if f$search("tmppatch_''node'.tmp") .eqs. "" then goto finishALPpatch
$ open/read tmppatch tmppatch_'node'.tmp
$ tmpALPpatchloop:
$ read/end=endALPpatchloop tmppatch patchrec
$ patchrec = f$edit(patchrec, "compress")
$ patch = f$element(1, "|", patchrec)
$ patch = f$edit(patch, "TRIM")
$ if f$extract(0, 3, patch) .nes. "ALP" then goto tmpALPpatchloop
$ if f$extract(0, 5, patch) .eqs. "ALPHA" then goto tmpALPpatchloop
$ patch =  patch + "                    "
$ patch = f$extract(0, 18, patch)
$ rev = f$edit(f$element(2, "|", patchrec), "trim")
$ rev1 = rev - "."
$ if rev1 .lt. (vver/10) then goto tmpALPpatchloop    !PTR 36-4-1162 Only use Vm.n format
$ rev = f$extract(0, 10, "V" + rev + "           ")
$ instal_date = f$edit(f$element(3, "|", patchrec), "trim")
$ if f$len(instal_date) .eq. 10 then instal_date = " ''instal_date'"
$ instal_date = f$extract(0, 12, "''instal_date'         ")
$ stat = f$element(4, "|", patchrec)
$ stat = f$extract(0, 8, "''stat'      ")
$ nod = f$element(6, "|", patchrec)
$ nod = f$extract(0, 8, "''nod'      ")
$ instlr = f$element(7, "|", patchrec)
$ instlr = f$extract(0, 12, "''instlr'          ")
$ write patchfile " ''patch'| ''rev'| ''instal_date'| ''stat'| ''nod'| ''instlr'"
$ goto tmpALPpatchloop
$ endALPpatchloop:
$ close tmppatch
$ if f$search("tmppatch_''node'.tmp") .nes. "" then delete tmppatch_'node'.tmp;*
$ finishALPpatch:
$ write patchfile ""
$ write patchfile "--- END RCM PATCHES ---"
$ close patchfile
$ convert 'fname'.txt, rcm_patch_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_patch_'node'.txt;
$!
$ gosub get_product_history
$!
$ return
$!
$!----------------------------------------------------------------------------------------------
$!
$ get_vax_patches:
$!
$! For VAX look for Patch Information in SYS$HELP and look at Release Notes.
$! VAX Patches will contain a '_' in the filename, or contain 'ECO'.
$! This may not be a complete or accurate list of patches - some release notes
$! may have been deleted and some patches may not follow the above guidelines. 
$!
$ if ALPHA then return
$!
$ write sys$output "''f$time()': Getting VAX patch details"
$ write rcm_log "''f$time()': Getting VAX patch details for ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting VAX patch details"
$ close mkr_log
$ open/write/error=error_3  patchfile RCM_PATCH_'node'.TXT
$ write patchfile ""
$ write patchfile "--- START RCM PATCHES ---"
$ write patchfile ""
$ write patchfile "Patch Information for VAX node ''node' from SYS$HELP Release Notes"
$ write patchfile ""
$ write patchfile "Patch Name                                         Date"
$ write patchfile "__________________________________________________________________"
$ directory/date/col=1/out=tmppatch_'node'.tmp/width=filename=60 sys$help:*ECO*.R*_NOTES, -
sys$help:*_*.R*_NOTES, Y2K.R*_NOTES
$ if f$search("tmppatch_''node'.tmp") .eqs. "" then goto finishVAXpatch
$ open/read tmppatch tmppatch_'node'.tmp
$ tmpVAXpatchloop:
$ read/end=endVAXpatchloop tmppatch patchrec
$ filna = f$extract(0, f$loc(".",patchrec), patchrec)
$ if f$loc("_", filna) .ne. f$len(filna) .or. f$loc("ECO", filna) .ne. f$len(filna) .or. -
f$loc("Y2K", filna) .ne. f$len(filna) 
$ then
$     patchrec = f$edit(patchrec, "compress, trim")
$     patch = f$extract(0, f$loc(".RELEASE", patchrec), patchrec)
$     patch = f$extract(0, 40, "''patch'                                      ")
$     pdate = f$extract(f$loc(" ",patchrec)+1, 60, patchrec)
$     pdate = f$edit(pdate, "trim")
$     if f$len(pdate) .eq. 22 then pdate = " ''pdate'"
$     write patchfile " ''patch' ''pdate'"
$ endif
$ goto tmpVAXpatchloop
$ endVAXpatchloop:
$ if f$search("tmppatch_''node'.tmp") .nes. "" then delete tmppatch_'node'.tmp;*
$ finishVAXpatch:
$ write patchfile ""
$ write patchfile "--- END RCM PATCHES ---"
$ close patchfile
$ convert 'fname'.txt, rcm_patch_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_patch_'node'.txt;
$!
$ gosub get_product_history
$!
$ return
$!
$!--------------------------------------------------------------------------------------
$ get_product_history:       !PTR36-4-538 9-Mar-1999 added Product Show History
$ if ALPHA 
$ then
$   platf = "Alpha"
$ else
$   platf = "VAX"
$ endif
$ write sys$output "''f$time()': Getting ''platf' patch details from PRODUCT SHOW HISTORY"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting ''platf' patch details from PRODUCT SHOW HISTORY"
$ close mkr_log
$!
$ open/write/error=error_3  prodfile RCM_PROD_'node'.TXT
$ write sys$output "''f$time()': Getting ''platf' PRODUCT SHOW HISTORY details"
$ write prodfile ""
$ write prodfile "--- START RCM PRODUCT HISTORY ---"
$ write prodfile ""                                 
$ write prodfile "Patch & Product Information for ''platf' node ''node' from PRODUCT SHOW HISTORY"
$ write prodfile ""
$ define/user sys$output prodhis_'node'.tmp
$ if ALPHA
$ then
$   bas = "AXPVMS"
$ else
$   bas = "VAXVMS"
$ endif
$ product show history/base_sys='bas'/full
$ open/read/error=endprodhis prodhis prodhis_'node'.tmp    !PTR91-21-112 add /error
$ prodloop:
$   read/end=endprodhis prodhis prodrec
$   write prodfile prodrec
$ goto prodloop
$ endprodhis:
$ close prodhis 
$ delete prodhis_'node'.tmp;
$ write prodfile ""
$ write prodfile "--- END RCM PRODUCT HISTORY ---"
$ close prodfile
$ convert 'fname'.txt, rcm_prod_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_prod_'node'.txt;
$return
$!
$!--------------------------------------------------------------------------------------
$ get_product_show_product:
$ if ALPHA 
$ then
$   platf = "Alpha"
$   bas = "AXPVMS"
$ else
$   platf = "VAX"
$   bas = "VAXVMS"
$ endif
$ write sys$output "''f$time()': Getting ''platf' product details from PRODUCT SHOW PRODUCT"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting ''platf' product details from PRODUCT SHOW PRODUCT"
$ close mkr_log
$!
$!
$ open/write/error=error_3  prodfile RCM_PROD1_'node'.TXT
$ write sys$output "''f$time()': Getting ''platf' PRODUCT SHOW PRODUCT details"
$ write prodfile ""
$ write prodfile "--- START RCM PRODUCT SHOW PRODUCT ---"
$ write prodfile ""                                 
$ write prodfile "Installed Products on ''platf' node ''node' from PRODUCT SHOW PRODUCT"
$ write prodfile ""
$ define/user sys$output prodhis1_'node'.tmp
$ product show product/base_sys='bas'/full
$ open/read prodhis prodhis1_'node'.tmp
$ prod1loop:
$   read/end=endprodhis1 prodhis prodrec
$   write prodfile prodrec
$ goto prod1loop
$ endprodhis1:
$ close prodhis 
$ !delete prodhis1_'node'.tmp;            ! need again in software section
$ write prodfile ""
$ write prodfile "--- END RCM PRODUCT SHOW PRODUCT ---"
$ close prodfile
$ convert 'fname'.txt, rcm_prod1_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_prod1_'node'.txt;
$return
$!
$!--------------------------------------------------------------------------------
$ get_vmsinstal_history:
$ if .not. ALPHA then return
$!
$ write sys$output "''f$time()': Getting vmsinstal.history"
$ write rcm_log "''f$time()': Getting vmsinstal.history for ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting vmsinstal.history"
$ close mkr_log
$ open/write/error=error_3  vmfile RCM_VM_'node'.TXT
$ write vmfile ""
$ write vmfile "--- START RCM VMSINSTAL-HISTORY ---"
$ write vmfile ""
$ if f$search("sys$update:vmsinstal.history") .eqs. "" then goto finishvmhist
$ write vmfile "VMSINSTAL data for Alpha node ''node' from SYS$UPDATE:VMSINSTAL.HISTORY"
$ write vmfile ""
$ open/read vmin sys$update:vmsinstal.history
$ vmloop:
$   read/end=endvmloop vmin vmrec
$   write vmfile vmrec
$   goto vmloop
$ endvmloop:
$ close vmin
$ finishvmhist:
$ write vmfile ""
$ write vmfile "--- END RCM VMSINSTAL-HISTORY ---"
$ close vmfile
$ convert 'fname'.txt, rcm_vm_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_vm_'node'.txt;
$ return
$!
$!---------------------------------------------------------------------------------
$!
$ get_networkinfo:
$!
$! for PTR 36-4-801 add support for Multinet and TCPware
$!  
$! Try to detect Multinet, TCPware, Pathway
$!
$ __isMultiNet = f$trnlnm("MULTINET_KERNEL_BASE_ADDRESS") .nes. ""
$ __isTCPware = f$trnlnm("TCPWARE_NETCP_MBX") .nes. ""
$ __isPathway = f$trnlnm("TWG$TCP") .nes. ""
$!
$ tcpip = ""
$ if f$search("SYS$SYSTEM:*$UCP.EXE") .nes. "" then tcpip = "UCX"
$ if __isMultiNet then tcpip = "MULTINET"
$ if __isTCPware then tcpip = "TCPWARE"
$ if __isPathway then tcpip = "PATHWAY"
$!
$ if suppress_ip .eqs. "Y"
$ then
$ 	write rcm_log "''f$time()': Skipping Network info for ''node' (SUPPRESS IP ADDRESSES=Y)"
$ 	open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ 	write mkr_log "''f$time()' : ''node6' Skipping Network info for ''node' (SUPPRESS IP ADDRESSES=Y)"
$ 	close mkr_log
$ 	return
$ endif
$!
$ write rcm_log "''f$time()': Getting Network info for ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Network info"
$ close mkr_log
$!
$ open/write/error=error_3  hdr net_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM NETWORK INFO ---"
$ write hdr ""
$ close hdr
$ open/write/error=error_3  end net_'node'.end
$ write end ""
$ write end "--- END RCM NETWORK INFO ---"
$ write end ""
$ close end
$!
$ define sys$output net_'node'.txt
$!
$ if f$search("SYS$SYSTEM:TCPIP$UCP.EXE") .eqs. "" .and. f$search("SYS$SYSTEM:UCX$UCP.EXE") .eqs. ""
$ then
$    write sys$output "Compaq's TCPIP is not installed on ''node' - SYS$SYSTEM:*$UCP.EXE not found"
$    write rcm_log "''f$time()': Compaq's TCPIP is not installed on ''node' - SYS$SYSTEM:*$UCP.EXE not found"
$    open/append/share/error=error_mkr mkr_log 'mkr_fil'
$    write mkr_log "''f$time()' : ''node6' Compaq's TCPIP is not installed - SYS$SYSTEM:*$UCP.EXE not found"
$    close mkr_log
$!
$       if tcpip .eqs. "MULTINET"
$       then
$          write sys$output "MultiNet is installed on ''node'"
$          write sys$output ""
$          write rcm_log "''f$time()': MultiNet is installed on ''node'"
$          MULTINET SHOW/STATISTICS
$          MULTINET SHOW/INTERFACE SE0
$       endif     
$!
$       if tcpip .eqs. "TCPWARE"
$       then
$          write sys$output "TCPware is installed on ''node'"
$          write sys$output ""
$          write rcm_log "''f$time()':  TCPware is installed on ''node'"
$ NETCU
SHOW INTERFACE
$       endif     
$!
$ else
$    UCX SHOW INTERFACE/FULL 
$    write sys$output ""
$    write sys$output "$ UCX SHOW SERVICES"
$    UCX SHOW SERVICES
$    write sys$output ""
$ endif  
$!
$ if f$search("sys$manager:NET$ROUTING_STARTUP.NCL") .nes. ""
$ then
$   search SYS$MANAGER:NET$ROUTING_STARTUP.NCL "routing type", "routing phaseiv addr"
$ else
$   if (f$extract(3, 1, f$getsyi("decnet_version"))) .eqs. "4"   !DECnet Phase IV
$   then
$      MCR NCP SHOW CHARACTERISTICS NODE 'node' TO nod_'node'.ncp
$      search nod_'node'.ncp type, executor
$      delete nod_'node'.ncp;
$   endif
$ endif
$ deassign sys$output
$!
$ convert net_'node'.hdr, net_'node'.txt, net_'node'.end rcm_net_'node'.txt
$ convert 'fname'.txt, rcm_net_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete net_'node'.hdr;, net_'node'.txt;, net_'node'.end;, rcm_net_'node'.txt;
$ return
$!
$!---------------------------------------------------------------------------------
$!
$ get_devices:
$ write rcm_log "''f$time()': Getting SHOW DEVICE D/FULL info on ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting SHOW DEVICE D/FULL info"
$ close mkr_log
$!
$ open/write/error=error_3  hdr shdev_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM SHOW DEVICE ---"
$ write hdr ""
$ close hdr
$ open/write/error=error_3  end shdev_'node'.end
$ write end ""
$ write end "--- END RCM SHOW DEVICE ---"
$ write end ""
$ close end
$!
$ show device d/full/out=shdev_'node'.txt
$ convert shdev_'node'.hdr, shdev_'node'.txt, shdev_'node'.end rcm_shdev_'node'.txt
$ convert 'fname'.txt, rcm_shdev_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete shdev_'node'.hdr;, shdev_'node'.txt;, shdev_'node'.end;, rcm_shdev_'node'.txt;
$ return
$!
$!---------------------------------------------------------------------------------
$!
$ get_raidinfo:
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ show device DPA0
$ If .not. $status
$ then
$   write rcm_log "''f$time()': Skipping RAID SHOW on ''node'"
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' Skipping RAID SHOW "
$   close mkr_log
$   return
$ endif
$ write rcm_log "''f$time()': Getting RAID SHOW info on ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting RAID SHOW info"
$ close mkr_log
$!
$ open/write/error=error_3  hdr raid_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM RAID SHOW ---"
$ write hdr ""
$ close hdr
$ open/write/error=error_3  end raid_'node'.end
$ write end ""
$ write end "--- END RCM RAID SHOW ---"
$ write end ""
$ close end
$!
$ define sys$error raid_'node'.txt
$ define sys$output raid_'node'.txt
$ RAID SHOW
$ RAID SHOW/SPARESET
$ deassign sys$error
$ deassign sys$output
$!
$!remove CR chars from RAID SHOW output
$!
$ if f$search("cr.tpu") .eqs. "" 
$ then
$   open/write/error=error_3  cr cr.tpu
$   write cr "input_file  := get_info (command_line, ""file_name"");"
$   write cr "work_buffer := create_buffer (""Work"", input_file);"
$   write cr "cr := ascii (13); "
$   write cr "position (beginning_of (work_buffer));"
$   write cr "loop"
$   write cr "    search_stat := search_quietly (cr, forward);"
$   write cr "    exitif search_stat = 0;"
$   write cr "    erase (search_stat);"
$   write cr "endloop;"
$   write cr "write_file (work_buffer);"
$   write cr "quit;"
$   close cr
$ endif
$ define/user sys$output NLA0:
$ EDIT/TPU/NODISPLAY/COMMAND=CR.TPU RAID_'node'.TXT
$ purge RAID_'node'.TXT
$!
$ convert raid_'node'.hdr, raid_'node'.txt, raid_'node'.end rcm_raid_'node'.txt
$ convert 'fname'.txt, rcm_raid_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete raid_'node'.hdr;, raid_'node'.txt;, raid_'node'.end;, rcm_raid_'node'.txt;
$ return
$!
$!--------------------------------------------------------------------------------
$ list_hsdevices:
$ if .not. ALPHA then return
$ if f$extract(1,1,f$getsyi("version")) .lt. 7 then return ! only use rcmscript on V7.*
$ write sys$output "''f$time()': Looking for HSZG and HS devices on ''node'" 
$ write rcm_log "''f$time()': Looking for HSZG and HS devices on ''node'" 
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting HSZG and HS device list" 
$ close mkr_log
$!
$ if f$search("rcm$dir:uuencode_alpha.exe") .eqs. "" then link/exe=rcm$dir:uuencode_alpha rcm$dir:uuencode_alpha 
$ rcmhsx = "mcr rcm$dir:uuencode_alpha -h"
$ if f$search("RCM$DIR:RCMSCRIPT.EXE") .eqs. "" 
$ then 
$      curdir = f$environment("default")
$      set def RCM$DIR
$      rcmhsx
$      set default 'curdir'
$ endif
$ open/write/error=error_3 hdr find_hs_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM HS DEVICES ---"
$ write hdr ""
$ close hdr
$ open/write/error=error_3  end find_hs_'node'.end
$ write end ""
$ write end "--- END RCM HS DEVICES ---"
$ write end ""
$ close end
$ rcmhsx 1  
$ rcmscript = "MCR RCM$DIR:RCMSCRIPT"
$ create hszg_'node'.hdr

Available HSZ/G Devices from RCMSCRIPT -f subsysdata

$ define/user sys$output HSZG_'node'.TXT
$ RCMSCRIPT -f subsysdata
$!
$ create hsj_'node'.hdr

Available HSJ Devices from RCMSCRIPT -j subsysdata

$ define/user sys$output HSJ_'node'.TXT
$ RCMSCRIPT -j subsysdata
$ svr = $severity
$ rcmhsx 0
$ if svr .eq. 1
$ then
$    vfcfil = "HSJ_''node'.TXT"
$    gosub clean_rcmscript_output
$ endif
$ convert find_hs_'node'.hdr, hszg_'node'.hdr,hszg_'node'.txt, hsj_'node'.hdr,hsj_'node'.txt, find_hs_'node'.end rcm_hs_'node'.txt
$ convert 'fname'.txt, rcm_hs_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete find_hs_'node'.hdr;*, hszg_'node'.txt;*, hsj_'node'.txt;*, find_hs_'node'.end;*, rcm_hs_'node'.txt;*
$ delete hszg_'node'.hdr;*, hsj_'node'.hdr;*
$ return
$!------------------------------------------------------------------------------------
$!
$ clean_rcmscript_output:
$ if f$search("tmpteco.com") .eqs. "" 
$ then 
$   esc[0,8]=27
$   open/write tco tmpteco.com
$   write tco "$edit/teco 'p1'"
$   write tco "EX''esc'''esc'"
$   write tco "$exit"
$   close tco
$ endif
$ @tmpteco 'vfcfil'
$ purge 'vfcfil'
$ return
$!
$!---------------------------------------------------------------------------------
$ get_hsjd_info:
$ write sys$output "''f$time()': Looking for HSJD devices on ''node'" 
$ write rcm_log "''f$time()': Looking for HSJD devices on ''node'" 
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting HSJ/HSD device information" 
$ close mkr_log
$!
$ open/write/error=error_3  hdr hsjd_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM HSJ/HSD ---"
$ write hdr ""
$ close hdr
$ open/write/error=error_3  end hsjd_'node'.end
$ write end ""
$ write end "--- END RCM HSJ/HSD ---"
$ write end ""
$ close end
$!
$ create hsjd_'node'.txt
$ gosub load_fydriver
$ gosub make_command_file_hsd
$ gosub make_command_file_hsj
$ gosub get_hsjd
$ gosub finishup_hsjd
$ return
$!
$!----------------------------------------------------------------
$!
$load_fydriver:
$! Now load fydriver if not already loaded
$ show device FYA0
$ If .not. $status
$ then
$   if ALPHA            !PTR36-4-509 23-Feb-1999
$   then
$       mcr sysman io connect fya0:/noadapter/driver=sys$fydriver
$   else
$       mcr sysgen connect fya0/noadapter
$   endif
$ endif
$ return
$!
$!----------------------------------------------------------------
$make_command_file_hsd:
$ open/write/error=error_3  infile hsd_commands_'node'.txt
$ write infile "SHOW THIS_CONTROLLER FULL"
$ write infile "SHOW OTHER_CONTROLLER FULL"
$ write infile "SHOW STORAGESETS FULL"
$ write infile "SHOW UNITS FULL"
$ write infile "SHOW DEVICES FULL"
$ write infile "EXIT"
$ close infile
$ return
$!----------------------------------------------------------------
$make_command_file_hsj:
$ open/write/error=error_3  infile hsj_commands_'node'.txt
$ write infile "SHOW THIS_CONTROLLER FULL"
$ write infile "SHOW OTHER_CONTROLLER FULL"
$ write infile "SHOW STORAGESETS FULL"
$ write infile "SHOW FAILEDSET FULL"
$ write infile "SHOW SPARESETS FULL"
$ write infile "SHOW UNITS FULL"
$ write infile "SHOW DEVICES FULL"
$ write infile "EXIT"
$ close infile
$ return
$!----------------------------------------------------------------
$!
$!
$get_hsjd:
$ create cluster_init_'node'.ini
INITIALIZE
REMOVE SYSTEMS/TYPE=ALL
ADD SYSTEMS /TYPE=("HSJ4","HSJ5","HSJ8","HSD", "RF72")
$ define/nolog show_cluster$init cluster_init_'node'.ini
$ show cluster/output=hsjd_clus_'node'.tmp
$ deassign show_cluster$init
$ delete/nolog cluster_init_'node'.ini;
$!
$ if ALPHA
$ then
$    hsdsa_exe = "RCM$DIR:HSDSA-SCRIPT-ALPHA.EXE"
$ else
$    hsdsa_exe = "RCM$DIR:HSDSA-SCRIPT-VAX.EXE"
$ endif
$ cntdash = 0
$ open/read cluster_file hsjd_clus_'node'.tmp 
$read_line:
$   read/end=finish_hsjd cluster_file line
$   if f$locate("+-----", line) .ne. f$length(line) then cntdash = cntdash + 1
$   if (f$locate("HSD", line) .ne. f$length(line)) .or. (f$locate("HSJ", line) .ne. f$length(line))
$   then
$       hsjd = f$edit(f$element(1, "|", line), "compress,trim")
$       gosub collect_hsjd
$   endif
$   goto read_line
$finish_hsjd:
$ close cluster_file
$ if cntdash .eq. 2 
$ then 
$!  Try to find any additional HSJ/Ds via f$getdvi
$   write sys$output "SHOW CLUSTER data incomplete (>60 nodes)"
$   DEVICE_LIST_CONTEXT = 0
$   open/write/error=error_3  hsjdtmp hsjd_'node'.tmp
$   hsjdLOOPx:
$       DEVICE_NAME = F$DEVICE("*","DISK",,DEVICE_LIST_CONTEXT)
$       IF (DEVICE_NAME .EQS. "") THEN GOTO hsjdxDONE
$       HOST_NAME   = F$GETDVI(DEVICE_NAME, "HOST_NAME")
$       HOST_TYPE   = F$GETDVI(DEVICE_NAME, "HOST_TYPE")
$       ALT_NAME    = F$GETDVI(DEVICE_NAME, "ALT_HOST_NAME")
$       ALT_TYPE    = F$GETDVI(DEVICE_NAME, "ALT_HOST_TYPE")
$       hstyp = F$EXTRACT(0,3,HOST_TYPE)
$       alttyp = F$EXTRACT(0,3,ALT_TYPE)         
$       IF (hstyp.EQS."HSJ") .or. (hstyp.EQS."HSD") .or. (alttyp.EQS."HSJ") .or. (alttyp.EQS."HSD")
$       THEN
$          host_name = f$extract(0, 20, host_name + "                    ")
$          write hsjdtmp "''host_name' ''host_type'"
$       ENDIF
$       GOTO hsjdLOOPx
$   hsjdxdone:
$   close hsjdtmp
$   sort/key=(pos:1,siz:8)/noduplicates hsjd_'node'.tmp hsjd_'node'.srt
$   open/read hsjdsrt hsjd_'node'.srt
$   hsjdsrtloop:
$     read/end=endhsjdsrtloop hsjdsrt line
$     hsjd = f$element(0, " ", line)
$     define/user sys$output NLA0:
$     define/user sys$error NLA0:
$     search hsjd_clus_'node'.tmp " ''hsjd' "   !search SH CLUSTER output for this HSJ/D
$     if $status .ne. 1 
$     then 
$        write sys$output "Need to get HSJD data for ''hsjd'"
$        gosub collect_hsjd
$     endif
$   goto hsjdsrtloop
$   endhsjdsrtloop:
$   close hsjdsrt
$   delete/nolog hsjd_'node'.tmp;*, hsjd_'node'.srt;*
$ endif
$ return
$!
$!-------------------------------------------------------------------------------------------------
$!
$ collect_hsjd:
$       write sys$output "''hsjd'"
$       if f$locate("HSD", line) .ne. f$len(line) 
$       then 
$         write sys$output "Collecting data from HSD ''hsjd'"
$         call make_input_file_hsd 'hsjd'
$       endif
$       if f$locate("HSJ", line) .ne. f$len(line) 
$       then 
$         write sys$output "Collecting data from HSJ ''hsjd'"
$         call make_input_file_hsj 'hsjd'
$       endif
$!
$!     PTR36-4-409 17-Dec-1998  PM Added code to prevent two node collections accessing the same HSJ/D
$!     simultaneously. Only one connection to a HSJ should be made at one time.
$!
$      hcnt = 0
$      hsjd_waitloop:
$      if f$search("RCM$DIR:''hsjd'.LOCK") .nes. ""
$      then
$         write sys$output "''f$time()' Waiting for other process to finish with this HSJ/D..."
$         wait 00:00:30                                           ! wait 30 secs
$         hcnt = hcnt + 1
$         if hcnt .ge. 10 then goto hcontinu
$         goto hsjd_waitloop
$      endif
$      hcontinu:
$      if f$search("RCM$DIR:HSJD_''hsjd'.TMP") .eqs. ""
$      then
$         write sys$output "Spawn started at ''f$time()'"
$         create RCM$DIR:'hsjd'.LOCK
$         spawn/input=hsjd_dat_'node'.tmp/out=NLA0: run 'hsdsa_exe'
$         delete RCM$DIR:'hsjd'.lock;*
$         write sys$output "Spawn ended at ''f$time()'"
$      else
$         write sys$output "''f$time()' Data for ''hsjd' already exists in RCM$DIR:HSJD_''hsjd'.TMP"
$      endif
$      convert hsjd_'node'.txt, RCM$DIR:HSJD_'hsjd'.TMP hsjd_'node'.txt
$ return
$!---------------------------------------
$make_input_file_hsd: SUBROUTINE
$ open/write/error=error_3  infile hsjd_dat_'node'.tmp
$ write infile "hsd_commands_''node'.txt"
$ write infile "RCM$DIR:hsjd_''p1'.tmp"
$ write infile "''p1'"
$ write infile "none"
$ close infile
$ exit
$ENDSUBROUTINE
$!---------------------------------------
$make_input_file_hsj: SUBROUTINE
$ open/write/error=error_3  infile hsjd_dat_'node'.tmp
$ write infile "hsj_commands_''node'.txt"
$ write infile "RCM$DIR:hsjd_''p1'.tmp"
$ write infile "''p1'"
$ write infile "none"
$ close infile
$ exit
$ENDSUBROUTINE
$!---------------------------------------
$!
$finishup_hsjd:
$ purge hsjd*'node'.*
$ convert hsjd_'node'.hdr, hsjd_'node'.txt, hsjd_'node'.end rcm_hsjd_'node'.txt
$ convert 'fname'.txt, rcm_hsjd_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete hsjd_'node'.hdr;, hsjd_'node'.txt;, hsjd_'node'.end;, rcm_hsjd_'node'.txt;
$ delete hsjd*'node'.tmp;*, hs*_commands_'node'.txt;*
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$ get_hsz_info:
$ kg = "K"
$ hszg = "Z"
$ gosub get_hszg_info
$ return
$!
$!------------------------------------------------------------------------------------------------------------
$!
$ get_hsg_info:
$ kg = "G"
$ hszg = "G"
$ gosub get_hszg_info
$ if f$search("rcm$dir:rcmscr_''node'.tmp") .nes. "" then del rcm$dir:rcmscr_'node'.tmp;*
$ if f$search("rcm$dir:rcmscr_*.tmp") .eqs. "" 
$ then
$    if f$search("rcm$dir:rcmscript.exe") .nes. "" then delete rcm$dir:rcmscript.exe;*
$ endif
$ return
$!
$!------------------------------------------------------------------------------------------------------------
$!
$ get_hszg_info:
$ write sys$output "''f$time()': Looking for HS''hszg' devices on ''node'"
$ write rcm_log "''f$time()': Looking for HS''hszg' devices on ''node'"
$!
$ open/write/error=error_3  hdr HS'hszg'_'node'.hdr
$ write hdr ""
$ write hdr "--- START RCM HS''hszg' ---"
$ write hdr ""
$ close hdr
$ open/write/error=error_3  end HS'hszg'_'node'.end
$ write end ""
$ write end "--- END RCM HS''hszg' ---"
$ write end ""
$ close end
$!
$ create HS'hszg'_'node'.TXT
$!
$ if .not. ALPHA
$ then
$   write rcm_log "''f$time()': ''node' Skipping HS''hszg' Information - not implemented on VAX"
$   write sys$output "''f$time()': ''node' Skipping HS''hszg' Information - not implemented on VAX"
$   goto finishhszg  !not implemented on VAX
$ endif
$!
$! PTR36-4-483  15-Feb-1999 get SYS$SYSTEM:SYS$DEVICES.DAT if DEVICE_NAMING is enabled
$!
$ if vver .ge. 710
$ then
$   if f$getsyi("DEVICE_NAMING") .eq. 1
$   then
$     copy SYS$SYSTEM:SYS$DEVICES.DAT sysdev_'node'.tmp
$     convert HS'hszg'_'node'.txt, sysdev_'node'.tmp HS'hszg'_'node'.tmp
$     rename HS'hszg'_'node'.tmp HS'hszg'_'node'.txt
$     delete sysdev_'node'.tmp;
$  endif
$ else
$   vers = f$getsyi("version")
$   write rcm_log "''f$time()': ''node' ''vers'. Must be running at least V7.1 to get HS''hszg' data"
$   write sys$output "''f$time()': ''node' ''vers'. Must be running at least V7.1 to get HS''hszg' data"
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' ''vers'. Must be running at least V7.1 to get HS''hszg' data"
$   close mkr_log
$   goto finishhszg
$ endif
$!
$ gosub check_if_hszg
$ if hszgdev .eq. 0
$ then
$   write rcm_log "''f$time()': ''node' No HS''hszg' devices found"
$   write sys$output "''f$time()': ''node' No HS''hszg' devices found"
$   goto finishhszg   ! if no HSZ/HSG devices - finish up
$ endif
$!
$ if f$search("rcm$dir:uuencode_alpha.exe") .eqs. "" then link/exe=rcm$dir:uuencode_alpha rcm$dir:uuencode_alpha 
$ rcmhsx = "mcr rcm$dir:uuencode_alpha -h"
$ if f$search("RCM$DIR:RCMSCRIPT.EXE") .eqs. "" 
$ then 
$      curdir = f$environment("default")
$      set def RCM$DIR
$      rcmhsx
$      set default 'curdir'
$ endif
$!
$ write sys$output "''f$time()': Looking for HS''hszg' info"
$ write sys$output "''f$time()': Looking for Console LUNs (GG devices) info"
$!
$ if (hszg .eqs. "G") 
$ then
$    SHOW DEVICE/output=gg_'node'.tmp $1$GG !PTR 91-21-118. HSG CCLs always have Allocation class of 1
$    if (($status .and. 1) .eq. 1) 
$    then
$       type gg_'node'.tmp
$       open/read/error=endgg ggs gg_'node'.tmp
$       gg_loop:
$          read/end=endgg ggs ggrec
$          if f$loc("$1$GG", ggrec) .eq. f$len(ggrec) then goto gg_loop
$          ggdev = f$element(0, " ", ggrec)
$          gosub get_ggdata
$          goto gg_loop
$       endgg:
$       close ggs
$       goto finishhszg
$    else    !Try to find how many HSGs are present from Multipath info
$       SHOW DEVICE/MULTIPATH/output=show_multipath_'node'.tmp $1$  !PTR91-21-118, HSGs must be $1$..
$       if (($status .and. 1) .eq. 1) 
$       then
$         SORT/KEY=(POS:61,SIZ:18) show_multipath_'node'.tmp show_multipath_'node'.srt/noduplicates
$         type show_multipath_'node'.srt
$         open/read/error=endmul mul show_multipath_'node'.srt
$         mul_loop:
$            read/end=endmul mul mulrec
$            ggdev = f$element(0, " ", mulrec)
$            if ggdev .nes. "" .and. ggdev .nes. "Device" then gosub get_ggdata
$            goto mul_loop
$         endmul:
$         close mul
$         delete show_multipath_'node'.*;*
$         goto finishhszg
$       endif
$    endif
$ endif
$!
$!   no GG devices found or collecting HSZ info
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' Getting HS''hszg' Information"
$   close mkr_log
$   dkglet = ""
$   dkglist = ""
$   DEVICE_LIST_CONTEXT = 0
$   hszgLOOP:
$       DEVICE_NAME = F$DEVICE("*D''kg'*", "DISK",,DEVICE_LIST_CONTEXT)
$       IF (DEVICE_NAME .EQS. "") THEN GOTO hszgDONE
$       devtypnam = f$getdvi(DEVICE_NAME, "DEVICE_TYPE_NAME")
$       host_name = F$GETDVI(DEVICE_NAME, "HOST_NAME")
$       alt_name  = F$GETDVI(DEVICE_NAME, "ALT_HOST_NAME")
$       write sys$output "''device_name' ''devtypnam'   ''host_name'    ''alt_name'"
$       if f$loc("HS''hszg'",devtypnam) .ne. f$len(devtypnam) .and. (host_name .eqs. node .or. alt_name .eqs. node)
$       then
$          unitno = f$extract(f$locate("D''kg'", device_name) + 3, 6, device_name)
$          if f$len(unitno) .eq. 5
$          then
$               dlen = 5
$          else
$               dlen = 3
$          endif
$          dkglet = f$extract(0, f$locate("D''kg'", device_name) + dlen, device_name)  !PTR36-4-483 12-Feb-1999
$          if f$locate(dkglet, dkglist) .eq. f$len(dkglist)   ! new DK/DG letter
$          then
$             dkglist = dkglist + " ''dkglet'"
$             hszgcnt = 0
$             hszg_waitloop:
$             if f$search("RCM$DIR:HS''hszg'_''dkglet'.LOCK") .nes. ""
$             then
$                write sys$output "''f$time()': Waiting for other process to finish with HS''hszg' on ''dkglet'..."
$                wait 00:00:30                                           ! wait 30 secs
$                hszgcnt = hszgcnt + 1	
$                if hszgcnt .ge. 30 then goto hszgcontinu		 ! give up after 15 mins
$                goto hszg_waitloop
$             endif
$             hszgcontinu:
$             if f$search("RCM$DIR:HS''hszg'_''dkglet'.LOG") .eqs. ""
$             then
$                create RCM$DIR:HS'hszg'_'dkglet'.LOCK                  !PTR36-4-712 PMoran 30-Nov-1999
$                write sys$output "''f$time()': Getting data for HS''hszg' controller for ''device_name'"
$                rcmhsx 1  
$                gosub run_rcmscript
$                rcmhsx 0  
$                delete RCM$DIR:HS'hszg'_'dkglet'.LOCK;*
$                write sys$output "HS''hszg' Collection for ''dkglet' ended at ''f$time()'"
$             else
$                write sys$output "Data for ''dkglet' already exists in RCM$DIR:HS''hszg'_''dkglet'.LOG"
$             endif
$             convert HS'hszg'_'node'.txt, RCM$DIR:HS'hszg'_'dkglet'.LOG HS'hszg'_'node'.tmp
$             rename HS'hszg'_'node'.tmp HS'hszg'_'node'.txt
$          else
$             write sys$output "Already got data for ''device_name'"
$          endif
$       endif
$       GOTO hszgLOOP
$   hszgDONE:
$ delete gg_'node'.tmp;
$!
$finishhszg:
$ convert HS'hszg'_'node'.hdr, HS'hszg'_'node'.txt, HS'hszg'_'node'.end RCM_HS'hszg'_'node'.txt
$ convert 'fname'.txt, RCM_HS'hszg'_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete/nolog HS'hszg'_'node'.hdr;, HS'hszg'_'node'.txt;, HS'hszg'_'node'.end;, RCM_HS'hszg'_'node'.txt;
$ return
$!
$!--------------------------------------------------------------------------------------------
$!
$ check_if_hszg:
$ hszgdev = 0
$ DEVICE_LIST_CONTEXT = 0
$ hszgLOOP_1:
$       DEVICE_NAME = F$DEVICE("*D''kg'*", "DISK",,DEVICE_LIST_CONTEXT)
$       IF (DEVICE_NAME .EQS. "") THEN GOTO hszgDONE_1
$       devtypnam = f$getdvi(DEVICE_NAME, "DEVICE_TYPE_NAME")
$       host_name = F$GETDVI(DEVICE_NAME, "HOST_NAME")
$       alt_name  = F$GETDVI(DEVICE_NAME, "ALT_HOST_NAME")
$       if f$loc("HS''hszg'",devtypnam) .ne. f$len(devtypnam) .and. (host_name .eqs. node .or. alt_name .eqs. node)
$       then
$          hszgdev = 1          ! There are HSZ/HSG devices
$          goto hszgdone_1
$       endif
$       GOTO hszgLOOP_1
$ hszgDONE_1:
$ return
$!
$!-----------------------------------------------------------------------------------------------------
$ get_ggdata:
$!
$ dkglet = ggdev - ":"
$ device_name = dkglet
$ write sys$output "''f$time()': Getting data for HS''hszg' controller for ''device_name'"
$!
$! If the HSG device is being accessed (from another Cluster node), wait until free - or giveup after 30 tries (15 mins)
$!
$ ggcnt = 0
$ gg_waitloop:
$ if f$search("RCM$DIR:''device_name'.LOCK") .nes. ""
$ then
$    write sys$output "''f$time()': Waiting for other process to finish with ''device_name'..."
$    wait 00:00:30                                           ! wait 30 secs
$    ggcnt = ggcnt + 1
$    if ggcnt .ge. 30 
$    then 
$       write sys$output "Skipping ''device_name'"
$       goto ggcontinu
$    endif
$    goto gg_waitloop
$ endif
$!
$ if f$search("RCM$DIR:HS''hszg'_''dkglet'.LOG") .eqs. ""
$ then
$   create RCM$DIR:'device_name'.LOCK
$   rcmhsx 1  
$   gosub run_rcmscript
$   rcmhsx 0  
$   delete RCM$DIR:'device_name'.LOCK;*
$   write sys$output "HS''hszg' Collection for ''dkglet' ended at ''f$time()'"
$ else
$   write sys$output "Data for ''device_name' already in RCM$DIR:HS''hszg'_''dkglet'.LOG"
$ endif
$!
$ convert HS'hszg'_'node'.txt, RCM$DIR:HS'hszg'_'dkglet'.LOG HS'hszg'_'node'.tmp
$ rename HS'hszg'_'node'.tmp HS'hszg'_'node'.txt
$!
$ ggcontinu:
$ return
$!------------------------------------------------------------------------------------------------------------
$!
$ run_rcmscript:
$ if f$search("rcm$dir:rcmscr_''node'.tmp") .eqs. "" then create rcm$dir:rcmscr_'node'.tmp
$ rcmscript = "MCR RCM$DIR:RCMSCRIPT"
$ set ver
$ define sys$output RCM$DIR:HS'hszg'_'dkglet'.LOG
$ RCMSCRIPT -f 'DEVICE_NAME'
SHOW THIS_CONTROLLER FULL
SHOW ASSOCIATIONS FULL
SHOW CONCATSETS FULL
SHOW CONNECTIONS FULL
SHOW REMOTE_COPY FULL
SHOW STORAGESETS FULL
SHOW UNITS FULL
SHOW DEVICES FULL
SHOW OTHER_CONTROLLER FULL
SHOW EMU
$ set nover
$ deassign sys$output
$ search/match=nor/out=RCM$DIR:HS'hszg'_'dkglet'.LOG1 RCM$DIR:HS'hszg'_'dkglet'.LOG "set nover"
$ rename RCM$DIR:HS'hszg'_'dkglet'.LOG1 RCM$DIR:HS'hszg'_'dkglet'.LOG
$ purge RCM$DIR:HS'hszg'_'dkglet'.LOG
$ return
$!
$!----------------------------------------------------------------------------------
$!
$ get_license_info:
$   write sys$output "''f$time()': Getting License information for ''node'"
$   write rcm_log "''f$time()': Getting License information for ''node'"
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' Getting License Information"
$   close mkr_log
$   show license/unit_requirements/out=lic1_'node'.txt
$   license list/full/out=licx_'node'.txt
$   search/out=lic_'node'.txt licx_'node'.txt "Authorization","Product Name:","Units:","PAK Term"
$   delete licx_'node'.txt;
$   open/write/error=error_3  hdr lic_'node'.hdr
$   write hdr ""
$   write hdr "--- START RCM LICENSE ---"
$   write hdr ""
$   close hdr
$   open/write/error=error_3  end lic_'node'.end
$   write end ""
$   write end "--- END RCM LICENSE ---"
$   write end ""
$   close end
$   write sys$output "''f$time()': Formatting License information for ''node'"
$   write rcm_log "''f$time()': Formatting License information for ''node'"
$   fin = 0
$   gosub format_license_data
$   if fin .eq. 1 then return
$   convert lic_'node'.hdr, lic1_'node'.txt, lic2_'node'.txt, lic_'node'.end rcm_license_'node'.txt
$   delete lic_'node'.hdr;, lic_'node'.txt;, lic1_'node'.txt;, lic2_'node'.txt;, lic_'node'.end;
$   convert 'fname'.txt, rcm_license_'node'.txt rcm_'node'.tmp
$   rename rcm_'node'.tmp 'fname'.txt
$   purge 'fname'.txt
$   delete rcm_license_'node'.txt;
$ return
$!
$!-------------------------------------------------------------------------------------------------
$!
$ format_license_data:
$ open/write/error=error_3  outfil lic2_'node'.txt
$ write outfil ""
$ write outfil "License Name               UPI Authorization                  Termination Units"
$ write outfil "------------------------------ ------------------------------ ----------- -----"
$!
$ if ALPHA 
$ then 
$ 	rcmlics_file = "RCM$DIR:RCM$LICS_ALPHA.LIST" 
$ else
$ 	rcmlics_file = "RCM$DIR:RCM$LICS_VAX.LIST" 
$ endif
$!
$ upi = "---"
$!
$ if f$search("LIC_''node'.TXT") .eqs. "" 
$ then 
$     fin = 1
$     return
$ endif
$!
$ incnt = 0
$ open/read inlic LIC_'node'.TXT
$!
$ licloop:
$ read/end=endlic inlic licrec
$ str = "Authorization:"
$ if f$loc("''str'", licrec) .ne. f$len(licrec)
$ then
$     auth = f$extrac(0, 30, f$edit(f$extract(f$loc("''str'", licrec)+f$len(str), 60, licrec), "trim") + "                       ")
$ else
$     str = "Product Name:"
$     if f$loc("''str'", licrec) .ne. f$len(licrec)
$     then
$       incnt = incnt + 1
$       rem = incnt - (incnt/100)*100
$       if rem .eq. 0
$       then
$          write sys$output "''f$time()': ''node6' Processed ''incnt' licenses"
$       endif
$       pd = f$edit(f$extract(f$loc("''str'", licrec)+f$len(str), 60, licrec), "trim")
$       pdo = f$extract(0, 26, pd + "                                       ")
$!	gosub find_match
$     else
$       str = "Units:"
$       if f$loc("''str'", licrec) .ne. f$len(licrec)
$       then
$          unts = f$edit(f$extract(f$loc("''str'", licrec)+f$len(str), 60, licrec), "trim")
$       else
$          str = "PAK Termination Date:"
$          if f$loc("''str'", licrec) .ne. f$len(licrec)
$          then
$             pakt = f$extract(0, 11, f$edit(f$extract(f$loc("''str'", licrec)+f$len(str), 60, licrec), "trim")+ "            ")
$             !write sys$output "''pdo' ''upi' ''auth' ''pakt' ''unts'"
$             write outfil "''pdo' ''upi' ''auth' ''pakt' ''unts'"
$          endif
$       endif
$     endif
$ endif
$!
$ goto licloop
$endlic:
$close inlic
$close outfil
$return
$!
$!------------------------------------------------------------------------------------------------------
$!
$ get_sysgen:
$   write sys$output "''f$time()': Getting SYSGEN parameters for ''node'"
$   write rcm_log "''f$time()': Getting SYSGEN parameters for ''node'"
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' Getting SYSGEN parameters"
$   close mkr_log
$   open/write/error=error_3  hdr sysgen_'node'.hdr
$   write hdr ""
$   write hdr "--- START RCM SYSGEN ---"
$   write hdr ""
$   close hdr
$   open/write/error=error_3  end sysgen_'node'.end
$   write end ""
$   write end "--- END RCM SYSGEN ---"
$   write end ""
$   close end
$!
$ define/user sys$output sysgen_'node'.txt
$ if ALPHA
$ then
$    MCR SYSGEN
SHOW /ALL
SHOW/SPECIAL
$ else
$    MCR SYSGEN
SHOW /ALL
SHOW/SPECIAL
SHOW/BUS                   ! VAX only
SHOW/CONFIG
SHOW/DEVICE
SHOW/DRIVER
$ endif
$!
$   convert sysgen_'node'.hdr, sysgen_'node'.txt, sysgen_'node'.end rcm_sysgen_'node'.txt
$   delete sysgen_'node'.hdr;, sysgen_'node'.txt;, sysgen_'node'.end;
$   convert 'fname'.txt, rcm_sysgen_'node'.txt rcm_'node'.tmp
$   rename rcm_'node'.tmp 'fname'.txt
$   purge 'fname'.txt
$   delete rcm_sysgen_'node'.txt;
$ return
$!
$!------------------------------------------------------------------------------------------------------
$!
$ get_modparams:
$   write sys$output "''f$time()': Getting MODPARAMS.DAT for ''node'"
$   write rcm_log "''f$time()': Getting MODPARAMS.DAT for ''node'"
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' Getting MODPARAMS.DAT"
$   close mkr_log
$   open/write/error=error_3  hdr modparams_'node'.hdr
$   write hdr ""
$   write hdr "--- START RCM MODPARAMS ---"
$   write hdr ""
$   close hdr
$   open/write/error=error_3  end modparams_'node'.end
$   write end ""
$   write end "--- END RCM MODPARAMS ---"
$   write end ""
$   close end
$!
$ define/user sys$output modparams_'node'.txt
$ type SYS$SPECIFIC:[SYSEXE]MODPARAMS.DAT
$!
$   convert modparams_'node'.hdr, modparams_'node'.txt, modparams_'node'.end rcm_modparams_'node'.txt
$   delete modparams_'node'.hdr;, modparams_'node'.txt;, modparams_'node'.end;
$   convert 'fname'.txt, rcm_modparams_'node'.txt rcm_'node'.tmp
$   rename rcm_'node'.tmp 'fname'.txt
$   purge 'fname'.txt
$   delete rcm_modparams_'node'.txt;
$ return
$!
$!------------------------------------------------------------------------------------------------------
$!
$ get_memory:
$   write sys$output "''f$time()': Getting memory information for ''node'"
$   write rcm_log "''f$time()': Getting memory information for ''node'"
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' Getting Memory information"
$   close mkr_log
$   open/write/error=error_3  hdr mem_'node'.hdr
$   write hdr ""
$   write hdr "--- START RCM MEMORY ---"
$   write hdr ""
$   close hdr
$   open/write/error=error_3  end mem_'node'.end
$   write end ""
$   write end "--- END RCM MEMORY ---"
$   write end ""
$   close end
$!
$   show memory/FULL/ALL/output=mem_'node'.txt
$!
$   convert mem_'node'.hdr, mem_'node'.txt, mem_'node'.end rcm_mem_'node'.txt
$   delete mem_'node'.hdr;, mem_'node'.txt;, mem_'node'.end;
$   convert 'fname'.txt, rcm_mem_'node'.txt rcm_'node'.tmp
$   rename rcm_'node'.tmp 'fname'.txt
$   purge 'fname'.txt
$   delete rcm_mem_'node'.txt;
$ return
$!
$!------------------------------------------------------------------------------------------------------
$!
$ get_custinfo:
$ write sys$output "''f$time()': Getting Customer information for ''node'"
$ write rcm_log "''f$time()': Getting Customer information for ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Customer Information"
$ close mkr_log
$!
$ open/write/error=error_3  custinfo rcm_cust_'node'.txt
$ write custinfo ""
$ write custinfo "--- START RCM CUSTOMER INFO ---"
$ write custinfo ""
$ write custinfo "CompanyName=''company_name'"
$ write custinfo "ContactName=''contact_name'"
$ write custinfo "ContactTelephone=''contact_telephone'"
$ write custinfo "ContactEmail=" + contact_email
$ write custinfo "CustomerAccessID=''customer_access_id'"
$ write custinfo "TAMName=''account_manager'"
$ write custinfo "TAMEmail=" + account_manager_email
$ write custinfo ""
$ write custinfo "--- END RCM CUSTOMER INFO ---"
$ write custinfo ""
$ close custinfo
$ convert 'fname'.txt, rcm_cust_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_cust_'node'.txt;
$ return
$!
$!------------------------------------------------------------------------------------------
$!
$ get_ctrlinfo:
$ write sys$output "''f$time()': Getting Control information for ''node'"
$ write rcm_log "''f$time()': Getting Control information for ''node'"
$! open/append/share/error=error_mkr mkr_log 'mkr_fil'
$! write mkr_log "''f$time()' : ''node6' Getting Control Information"
$! close mkr_log
$ archit = "alpha"
$ if .not. ALPHA then archit = "vax"
$!
$ open/write/error=error_3  ctrlinfo rcm_ctrl_'node'.txt
$ write ctrlinfo ""
$ write ctrlinfo "--- START RCM CONTROL INFO ---"
$ write ctrlinfo ""
$ write ctrlinfo "CollectionTime=''collect_time'"
$ write ctrlinfo "SystemSerialNo=''cfg_sn'"
$ write ctrlinfo "FullHostName=''node'.''dom'"
$ write ctrlinfo "Architecture=''archit'"
$ write ctrlinfo "OperatingSystem=''optyp' ''opver'"
$ write ctrlinfo "FRUVersion=''fru_version'"
$ if vver .ge. 720 .and. ALPHA   ! Galaxy Partition Id only valid from V7.2
$ then
$   partid = f$getsyi("PARTITION_ID")
$   write ctrlinfo "PartitionId=''partid'"
$ else
$   write ctrlinfo "PartitionId=-1"
$ endif
$ write ctrlinfo ""
$ write ctrlinfo "--- END RCM CONTROL INFO ---"
$ close ctrlinfo
$ convert 'fname'.txt, rcm_ctrl_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_ctrl_'node'.txt;
$ return
$!
$!----------------------------------------------------------------------------------------------
$!
$ get_configinfo:
$ write sys$output "''f$time()': Getting Configuration information for ''node'"
$ write rcm_log "''f$time()': Getting Configuration information for ''node'"
$! open/append/share/error=error_mkr mkr_log 'mkr_fil'
$! write mkr_log "''f$time()' : ''node6' Getting configuration Information"
$! close mkr_log
$!
$ installation_time = f$file_attributes("RCM$DIR:RCM_START.COM", "rdt")
$!
$ coll_dir = f$environment("default")
$!
$ day_of_week = ""
$ day_of_month = ""
$ time = ""
$!
$ if f$locate(collection_frequency, "DWMQ") .eq. f$length("DWMQ")
$ then 
$   frequency = collection_frequency
$ endif
$ if collection_frequency .eqs. "D" 
$ then 
$   frequency = "daily"
$ endif
$ if collection_frequency .eqs. "W" 
$ then 
$   frequency = "weekly"
$   weekday = f$extract(0,2,f$cvtime(next_collection_time, "comparison", "weekday"))
$   day_of_week = f$locate(day_of_week,"MoTuWeThFrSaSu")/2 + 1
$ endif
$ if collection_frequency .eqs. "M" 
$ then 
$   frequency = "monthly"
$   day_of_month = f$cvtime(next_collection_time, "comparison", "day")
$   if day_of_month .le. 10 then day_of_month = day_of_month - 0 
$ endif
$!
$ if collection_frequency .eqs. "Q" 
$ then 
$   frequency = "quarterly"
$ endif
$!
$ hour = f$cvtime(next_collection_time, "comparison", "hour")
$ minute = f$cvtime(next_collection_time, "comparison", "minute")
$ second = f$cvtime(next_collection_time, "comparison", "second")
$ time = "''hour':''minute':''second'"
$!
$ open/write/error=error_3  configinfo rcm_config_'node'.txt
$ write configinfo ""
$ write configinfo "--- START RCM CONFIG INFO ---"
$ write configinfo ""
$ write configinfo "InstallationTime=''installation_time'"
$ write configinfo "KitVersion=''rcm_ver'"
$ rcm_dir = f$trnlnm("RCM$DIR")
$ write configinfo "KitDirectory=''rcm_dir'"
$ write configinfo "CollectionDirectory=''coll_dir'"
$ write configinfo "ManualDirectory=''f$environment("default")'"
$ arch_dev = f$parse(archive_dir,,,"device")
$ arch_dir = f$parse(archive_dir,,,"directory")
$ archive_dir = arch_dev + arch_dir
$ write configinfo "ArchiveDirectory=''archive_dir'"
$ write configinfo "MaxArchives=''max_archives'"
$ if f$edit(transport_option,"UPCASE") .eqs. "F" then transport_option = "FTP"
$ if f$edit(transport_option,"UPCASE") .eqs. "E" then transport_option = "email"
$ if f$edit(transport_option,"UPCASE") .eqs. "D" then transport_option = "DSNLink"
$ if f$edit(transport_option,"UPCASE") .eqs. "M" then transport_option = "none"
$ write configinfo "TransportOption=" + transport_option
$ write configinfo "EmailAddress=" + email_adr
$ write configinfo "FTPAddress=" + ftp_area   
$ write configinfo "FTPProcedure=" + ftp_procedure  
$ write configinfo "DSNLinkAddress=" + dsnlink_address
$ write configinfo "LocalTransportOption=" + local_trans
$ write configinfo "LocalEmailAddress=" + local_email
$ write configinfo "LocalHost=" + local_host
$ write configinfo "LocalLogin=" + local_login
$! write configinfo "LocalFTPPassword=" 		!Don't write password into collected data file
$ write configinfo "LocalUploadDir=" + local_dir
$ write configinfo "LocalFTPProcedure=" + local_ftpproc
$ write configinfo "SuppressIP=" + suppress_ip
$ write configinfo "Frequency=''frequency'"
$ write configinfo "DayOfWeek=''day_of_week'"
$ write configinfo "DayOfMonth=''day_of_month'"
$ write configinfo "Time=''time'"
$ write configinfo "NextCollectionTime=''next_collection_time'"
$ write configinfo ""
$ write configinfo "--- END RCM CONFIG INFO ---"
$ write configinfo ""
$ close configinfo
$ convert 'fname'.txt, rcm_config_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_config_'node'.txt;
$ return
$!
$!
$!----------------------------------------------------------------------------------------------------
$del_oldest_files:
$ directory []'dfil'/col=1/wid=file=90/out=tmpdir.out/nohead/notrail/date
$ if f$file_attributes("tmpdir.out", "eof") .eq. 0 then return 
$ sort tmpdir.out tmpdir.srt/spec=sys$input
/collating_sequence=
    (
    sequence=("AN","EB","AR","PR","AY","UN","UL","UG","EP","CT","OV","EC",
    " ","0"-"9"),
    fold
    )
/field=(name=year,pos:100,size:4)
/field=(name=month,pos:97,size:2)       ! start at SECOND letter
/field=(name=day,pos:93,size:2)
/field=(name=time,pos:105,size:11)
/key=(year,descending)
/key=(month,descending)
/key=(day,descending)
/key=(time,descending)
$delete/nolog tmpdir.out;
$if f$search("tmpdir.srt") .eqs. "" then return
$open/read tmp tmpdir.srt
$cnt = 0
$loop:
$  read/end=endloop tmp tmprec
$  cnt = cnt + 1
$  fil = f$ele(0, " ", tmprec)
$  if cnt .gt. max_archives then delete/log 'fil'
$goto loop
$endloop:                  
$close tmp
$if cnt .gt. max_archives
$ then
$       open/append/share/error=error_mkr mkr_log 'curdir''mkr_fil'
$       write mkr_log "''f$time()' : ''node6' Deleted old ''dfil' files"
$       close mkr_log
$       write sys$output "''f$time()' : ''node6' Deleted old ''dfil' files"
$ endif
$delete/nolog tmpdir.srt;
$return
$!
$!--------------------------------------------------------------------------------------------------
$ get_io_show_bus:
$ if .not. ALPHA then return 
$ define/user sys$output ioshowbus_'node'.tmp
$ MCR SYSMAN IO SHOW BUS 
$ if $severity .ne. 1 then return
$!
$ write sys$output "''f$time()': Getting SYSMAN IO SHOW BUS for ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting SYSMAN IO SHOW BUS data"
$ close mkr_log
$!
$ open/write/error=error_3 iofile RCM_IO_'node'.TXT
$ write sys$output "''f$time()': Getting SYSMAN IO SHOW BUS dat"
$ write iofile ""
$ write iofile "--- START RCM SYSMAN IO SHOW BUS ---"
$ write iofile ""                                 
$ write iofile "MC SYSMAN IO SHOW BUS"
$ write iofile ""
$!
$ open/read iodat ioshowbus_'node'.tmp
$ ioloop:
$   read/end=endioloop iodat iorec
$   write iofile iorec
$ goto ioloop
$ endioloop:
$ close iodat 
$ delete ioshowbus_'node'.tmp;  
$!
$ write iofile ""
$ write iofile "--- END RCM SYSMAN IO SHOW BUS ---"
$ close iofile
$ convert 'fname'.txt, rcm_io_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_io_'node'.txt;
$return
$!
$!------------------------------------------------------------------------
$ get_fg_rev:
$ show dev fg/out=fg_'node'.tmp
$ open/read/error=endfg fgf fg_'node'.tmp
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting Firmware Rev for FG devices"
$ close mkr_log
$ write sys$output "''f$time()': Trying to get Firmware Rev for FG devices for ''node'"
$ open/write/error=error_3 fgfile RCM_FG_'node'.TXT
$ write fgfile ""
$ write fgfile "--- START RCM SDA FC SHOW DEV FG ---"
$ write fgfile ""
$ fgloop:
$       read/end=endfgloop fgf fgrec
$       if f$extract(0,2,fgrec) .nes. "FG" then goto fgloop
$       fgdev = f$extract(0,f$locate(":",fgrec),fgrec)
$       open/write fgsda fgsda_'node'.com
$       write fgsda "$analyze/system"
$       write fgsda "FC SHOW DEVICE ''fgdev'"
$       write fgsda "EXIT"
$       write fgsda "$exit"
$       close fgsda
$       @fgsda_'node'.com/out=fgsda_'node'.txt
$       open/read/error=endfg fgsda fgsda_'node'.txt
$       fg1loop:
$       read/end=endfg1loop fgsda fgrev
$       if f$loc("FG", fgrev) .ne. f$len(fgrev)
$       then
$         write fgfile fgrev
$         read/end=endfg1loop fgsda fgrev
$         write fgfile fgrev
$       endif
$       goto fg1loop
$       endfg1loop:
$       close fgsda
$       delete/nolog fgsda_'node'.com;
$       goto fgloop
$ endfgloop:
$ close fgf
$ write fgfile ""
$ write fgfile "--- END RCM SDA FC SHOW DEV FG ---"
$ close fgfile
$ convert 'fname'.txt, rcm_fg_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ endfg:
$ close/nolog fgfile
$ if f$search("rcm_fg_''node'.txt") .nes. "" then delete/nolog rcm_fg_'node'.txt;
$ if f$search("fg_''node'.tmp") .nes. "" then delete/nolog fg_'node'.tmp;*
$ return
$!--------------------------------------------------------------------------------------------------
$ get_adhocfiles:
$!
$! If there are .TXT files in the 'adhoc' directory, add them to the output file as long as
$! they are not empty and are less than 10 blocks.
$!
$ define/user sys$output NL:
$ define/user sys$error NL:
$ direct/nohead/column=1/notrailing/sel=siz=(min=1,max=10)/out=adhoc_'node'.lis 'adhoc_dir'*.TXT
$ IF F$FILE("adhoc_''node'.lis", "EOF") .gt. 0
$ then
$   open/write/error=error_3  adhochdr adhoc_'node'.hdr
$   write adhochdr ""
$   write adhochdr "--- START RCM ADHOC INFO ---"
$   write adhochdr ""
$   close adhochdr
$   open/write/error=error_3  adhocend adhoc_'node'.end
$   write adhocend ""
$   write adhocend "--- END RCM ADHOC INFO ---"
$   write adhocend ""
$   close adhocend
$   open/append/share/error=error_mkr mkr_log 'mkr_fil'
$   write mkr_log "''f$time()' : ''node6' Getting files in Adhoc directory"
$   close mkr_log
$!
$   type adhoc_'node'.lis
$!
$   open/write/error=error_3  adw adhoc_'node'.out
$   open/read adh adhoc_'node'.lis
$   adloop:
$     read/end=endadloop adh rec
$     nam = f$parse("''rec'",,,"name")
$     typ = f$parse("''rec'",,,"type")
$     write adw ""
$     write adw "----------------------- ''nam'''typ' -----------------------"
$     write adw ""
$     open/read fil 'rec
$     filoop:
$       read/end=endfiloop fil filrec
$       write adw filrec
$       goto filoop
$     endfiloop:
$     close fil
$     goto adloop
$   endadloop:
$   close adh
$   close adw
$   convert adhoc_'node'.hdr, adhoc_'node'.out, adhoc_'node'.end rcm_adhoc_'node'.txt
$   delete adhoc_'node'.hdr;, adhoc_'node'.end;, adhoc_'node'.out;, adhoc_'node'.lis;
$   convert 'fname'.txt, rcm_adhoc_'node'.txt rcm_'node'.tmp
$   rename rcm_'node'.tmp 'fname'.txt
$   purge 'fname'.txt
$   delete rcm_adhoc_'node'.txt;
$ else
$   write sys$output "No Adhoc files"
$ endif
$ return
$!
$!-------------------------------------------------------------------------------------------------------
$!
$ error_1:
$ write sys$output "Error writing rcm_''node'.log"
$ exit
$!
$!------------------------------------------------------------------------------------------------
$!
$ error_mkr:
$ write sys$output "Error opening ''mkr_fil'"
$ exit
$!
$ error_2:
$ write sys$output "Error opening file rcm_fru_''node'.txt"
$ exit
$!------------------------------------------------------------------------------------------------
$!
$ error_3:
$ write sys$output "Error writing file. Status = ''$STATUS'"
$ exit
$!
$!------------------------------------------------------------------------------------------------
$!
$CLEAN_FILE: SUBROUTINE
$convert 'p1 'p1/fdl=sys$input
RECORD; FORM STREAM;
$exit
$ENDSUBROUTINE
$!
$!-----------------------------------------------------------------------------------------
$!
$ wait_for_others:
$ zipnam = f$parse("''homfil'",,,"name")
$ zipfilname = zipnam
$ zipnam = "''zipnam'.ZIP" 
$!
$ wait_for_completion:
$ loop_cnt = 0
$!
$! get a list of all nodes except the homenode
$!
$ other_nodes = node_string - ",''homenode'" - "''homenode'," - "''homenode'"
$!
$ if other_nodes .eqs. "" then return
$!
$ wait_loop:
$   if f$search("rcmshsys.tmp") .nes. "" then delete rcmshsys.tmp;*
$   show system/nodes=('other_nodes')/proc="RCM_COLLECT"/out=rcmshsys.tmp
$   define/user sys$output NLA0:
$   define/user sys$error  NLA0:
$   search rcmshsys.tmp "RCM_COLLECT"
$   if $severity .eq. 1
$   then
$     loop_cnt = loop_cnt + 1
$     if loop_cnt .gt. 'wait_count'
$     then
$         write sys$output "''f$time()': Seems to be a problem completing RCM Collection!"
$         write sys$output "Looped ''wait_count' times"
$         open/append/share/error=error_mkr mkr_log 'mkr_fil'
$         write mkr_log "''f$time()' : ''node6' Problem completing collection - exceeded ''wait_count' loops"
$         close mkr_log
$         if f$search("rcmshsys.tmp") .nes. "" then delete/nolog rcmshsys.tmp;*
$         goto finish_collection
$     endif
$!
$!    get the names of the nodes where collection is not finished
$!
$     define/user sys$output NLA0:
$     define/user sys$error NLA0:
$     search/out=tmpndes.tmp rcmshsys.tmp " on node "
$     open/read tmpndes tmpndes.tmp
$     ndelist = ""
$     tmpndeloop:
$     read/end=endtmpndeloop tmpndes rec
$     tmpnd = f$edit(f$extract(f$locate("on node", rec)+8, 7, rec), "trim")
$     tmpnd = f$extract(0, f$locate(" ", tmpnd), tmpnd)
$     ndelist = ndelist + " " + tmpnd
$     goto tmpndeloop
$     endtmpndeloop:
$     close tmpndes
$     delete tmpndes.tmp;*
$!
$     write sys$output "''f$time()': RCM Collection still active on''ndelist'"
$!
$     if ndelist .nes. prev_ndeslist
$     then          ! only report incomplete node list when it changes
$       open/append/share/error=error_mkr mkr_log 'mkr_fil'
$       write mkr_log "''f$time()' : ''node6' RCM Collection still active on''ndelist'"
$       close mkr_log
$      endif
$     prev_ndeslist = ndelist
$     if f$search("rcmshsys.tmp") .nes. "" then delete/nolog rcmshsys.tmp;*
$     wait 'wait_interval'
$     goto wait_loop
$  endif
$  if f$search("rcmshsys.tmp") .nes. "" then delete/nolog rcmshsys.tmp;*
$  return
$!
$!-------------------------------------------------------------------------------
$ zip_files:
$!
$ write sys$output "''f$time()': RCM Collection complete on ''node'"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' RCM Collection complete"
$ close mkr_log
$!
$ if ALPHA
$ then
$ 	ZIP = "$RCM$DIR:ZIP-ALPHA.EXE"
$ else
$ 	ZIP = "$RCM$DIR:ZIP-VAX.EXE"
$ endif
$!
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Zipping the collected files to ''zipnam'"
$ close mkr_log
$!
$ rename rcm_marker_'node'.mkr rcm_marker_'node'.log
$!
$ write sys$output "''f$time()': Zipping the collected files to ''zipnam'"
$ write sys$output ""
$ privs = f$getjpi("","PROCPRIV")
$ write sys$output ""
$ write sys$output "Process Privileges:"
$ write/symbol sys$output privs
$ write sys$output ""
$ if f$search("RCM$ARCHIVE:RCM_HISTORY.DAT") .nes. "" 
$ then 
$     type RCM$ARCHIVE:RCM_HISTORY.DAT
$ else
$     write sys$output "No RCM_HISTORY.DAT found"
$ endif
$!
$ write sys$output ""
$!
$ set output_rate   		! Flush output buffer
$!
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ backup/ignore=interlock 'fname'.log 'zipfilname'.log1
$!
$ cfgtmp_file = cfg_file
$!
$! If Local Transport option is FTP or DECnet, Remove the line with the password from the cfg file in the ZIP
$!
$ if f$edit(f$extract(0, 1, local_site), "upcase") .eqs. "Y"
$ then
$   if f$edit(f$extract(0, 1, local_trans), "upcase") .nes. "E"
$   then
$      search/match=nand/out=tmp_'cfg_file' 'cfg_file' "PASSWORD]"
$      cfgtmp_file = "tmp_''cfg_file'"
$   endif 
$ endif  
$!
$ ZIP -l 'zipnam' RCMO*.TXT *.HTML RCM*.LOG* 'cfgtmp_file' *.LIF -x 'fname'.log ! log file will be unavailable  
$ if f$search("*.mkr") .nes. "" then ZIP -l 'zipnam' *.mkr        
$ rename rcm_marker_'node'.log rcm_marker_'node'.mkr
$!
$ if f$search("*FRU*.sys") .nes. ""
$ then
$   ZIP "-V" 'zipnam' *FRU*.sys        
$   delete/nolo *FRU*.sys;*
$ endif
$!
$ if f$search("*.CT5") .nes. ""
$ then
$   ZIP "-V" 'zipnam' *.CT5        
$   delete/nolo *.CT5;*
$ endif
$!
$ if f$search("tmp_''cfg_file'") .nes. "" then delete/nolog tmp_'cfg_file';*
$!
$ if anal_data .eqs. "L" 	!want to transport LIF Files only
$ then
$  lifzip = zipnam - ".ZIP"
$  lifzip = lifzip + "_LIF.ZIP"
$!
$  rename/log RCMO-*-'tim'.TMP *.TXT
$!
$  ZIP -l 'lifzip' RCMO*.TXT *.LIF
$  delete 'fname'.txt;
$  copy/lo 'lifzip' 'zipnam'         ! create a second ZIP file
$ endif
$!
$ write sys$output "Collection complete at ''f$time()'. Data is in RCM$DATA:''zipnam'"
$!
$ if f$search("RCMO*.ZIP",4) .nes. "" 
$ then
$   err_code = 1
$   err_text = "Successful completion"
$ endif
$!
$ directory/size/date/width=filename=50 rcmo*.zip/siz
$ if f$search("*.tpu") .nes. "" then delete/nolog *.tpu;*
$ if f$search("tmpteco.com") .nes. "" then delete/nolog tmpteco.com;*
$ if f$search("SNWKSCMDSCRIPTER$SHOCLUS.*") .nes. "" then delete/nolog SNWKSCMDSCRIPTER$SHOCLUS.*;*
$ return
$!
$!----------------------------------------------------------------------------------------
$!
$ transport_data:
$!
$! Look in .CFG file to see what transport option was specified:
$!
$! 	If Manual, do nothing
$!	If FTP get ftp_area from .cfg file and copy/ftp/binary
$!	If EMAIL, get email_address from .cfg and mail the data
$!      If DSNLink, DSN COPY/TOOL=RCM to COMPAQ
$!
$  define/user sys$output NLA0:
$  define/user sys$error NLA0:
$  search 'cfg_file' "[TRANSPORT OPTION]"/out=trans.tmp
$  if $status .ne. 1 
$  then
$     t_opt = "F" 
$  else
$     open/read trfil trans.tmp
$     read trfil trans
$     close trfil
$     delete/nolo trans.tmp;
$     t_opt = f$extract(f$locate("[TRANSPORT OPTION]", trans) + 20, 50, trans)
$     t_opt = f$edit(t_opt, "trim")
$     t_opt = f$edit(f$extract(0, 1, t_opt), "UPCASE") 
$     if f$locate(t_opt, "FEDM") .eqs. f$length("FEDM") then goto finish_collection
$  endif
$!
$  if t_opt .eqs. "F" then gosub ftp_data
$  if t_opt .eqs. "E" then gosub email_data
$  if t_opt .eqs. "M" then gosub manual_transport
$  if t_opt .eqs. "D" then gosub dsnlink_transport
$  if anal_data .eqs. "L" then delete 'zipnam';   ! delete the LIF only ZIP file 
$ return
$!
$!----------------------------------------------------------------------------------------
$!
$ ftp_data:
$     write sys$output "''f$time()': FTPing the data to Compaq"
$     define/user sys$output NLA0:
$     define/user sys$error NLA0:
$     search 'cfg_file' "[FTP AREA]"/out=ftp.tmp
$     if $status .ne. 1 
$     then 
$       ftp_area = "rcm.support.compaq.com/to_rcm/"  
$     else
$       open/read ftpfil ftp.tmp
$       read ftpfil ft
$       close ftpfil
$       delete/nolo ftp.tmp;
$       ftp_area = f$extract(f$locate("[FTP AREA]", ft) + 11, 60, ft)
$       ftp_area = f$extract(0, f$loc(";",ftp_area), ftp_area) ! in case there is a comment
$       ftp_area = f$edit(ftp_area, "trim")
$     endif
$     transport_type = "FTP"
$     transport_address = ftp_area
$!
$     open/append/share/error=error_mkr mkr_log 'mkr_fil'
$     write mkr_log "''f$time()' : ''node6' FTPing the data to ''ftp_area'"
$     close mkr_log
$!
$!    Check if a customer FTP procedure was specified
$!
$     define/user sys$output NLA0:
$     define/user sys$error NLA0:
$     search 'cfg_file' "[FTP PROCEDURE]"/out=ftpproc.tmp
$     if $status .ne. 1 
$     then 
$       ftp_procedure = ""  
$     else
$       open/read ftpfil ftpproc.tmp
$       read ftpfil ft
$       close ftpfil
$       delete/nolo ftpproc.tmp;
$       ftp_procedure = f$extract(f$locate("[FTP PROCEDURE]", ft) + 16, 80, ft)
$       ftp_procedure = f$extract(0, f$loc(";",ftp_procedure), ftp_procedure) ! in case there is a comment
$       ftp_procedure = f$edit(ftp_procedure, "trim")
$     endif
$!
$     if f$search(ftp_procedure) .nes. ""
$     then
$        @'ftp_procedure' 'zipnam'
$     else
$!       now insert the filename on the RH side of the ftp command
$        quo[0,8] = 34
$        ftp_host = f$extract(0, f$loc("/", ftp_area), ftp_area) ! e.g. rcm.support.compaq.com
$        ftp_dir =f$extract(f$loc("/", ftp_area), 40, ftp_area) ! e.g. /to_rcm/
$!       need syntax: rcm.support.compaq.com::"/to_rcm/file.zip"
$        ftp_fil = ftp_host + "::" + quo + ftp_dir + zipnam + quo
$        copy/ftp/binary/log/verbose 'zipnam' 'ftp_fil'
$     endif
$!
$     date_time_transport = f$time() 
$ return
$!
$!----------------------------------------------------------------------------------------------------------
$!
$  email_data:
$     write sys$output "''f$time()': EMAILing the data to Compaq"
$     define/user sys$output NLA0:
$     define/user sys$error NLA0:
$     search 'cfg_file' "[EMAIL ADDRESS]"/out=email.tmp
$     if $status .ne. 1 
$     then 
$        email_area = "rcm.data@compaq.com"  
$     else
$       open/read emfil email.tmp
$       read emfil em
$       close emfil
$       delete/nolo email.tmp;
$       email_adr = f$extract(f$locate("[EMAIL ADDRESS]", em) + 17, 60, em)
$       email_adr = f$extract(0, f$loc(";",email_adr), email_adr) ! in case there is a comment
$       email_adr = f$edit(email_adr, "trim")
$     endif
$     transport_type = "e-mail"
$     transport_address = email_adr
$     open/append/share/error=error_mkr mkr_log 'mkr_fil'
$     write mkr_log "''f$time()' : ''node6' Emailing the collected files to " + email_adr
$     close mkr_log
$!
$!    need to uuencode the ZIP file
$!
$     gosub setup_uuencode
$!
$     uue 'zipnam' 'zipfilname'.uue
$     open/write/error=error_3  tmpmai tmpmail.com
$     write tmpmai "$MAIL"
$     write tmpmai "SEND/NOSELF/NOEDIT/NOCC ''zipfilname'.uue"
$     if f$edit(f$trnlnm("MAIL$INTERNET_TRANSPORT"),"upcase") .eqs. "SMTP"    !PTR91-21-121
$     then 
$        write tmpmai email_adr
$     else
$        write tmpmai "smtp%""''email_adr'"""
$     endif
$     write tmpmai "RCM DATA ''zipnam'"
$     write tmpmai "EXIT"
$     write tmpmai "$exit"
$     close tmpmai
$!
$     @tmpmail
$     type tmpmail.com
$     delete/nolog tmpmail.com;
$     date_time_transport =  f$time()
$     transport_type = "e-mail"
$     transport_address = email_adr
$ return
$!
$!---------------------------------------------------------------------------------
$!
$ manual_transport:
$    date_time_transport = "unknown"
$    transport_type = "Manual"
$!
$!   need to uuencode the ZIP file
$!
$    gosub setup_uuencode
$    uue 'zipnam' 'zipfilname'.uue
$ return
$!
$!--------------------------------------------------------------------------------------
$!
$ dsnlink_transport:
$!
$!   DSNLink Transport has been specified
$!   Check if DSN V2 or V3 is installed (also allow T versions):
$!
$    transport_type = "DSNLink"
$    transport_address = "unknown"
$    if f$trnlnm("DSN$ROOT") .eqs. "" 
$    then
$        dver = f$trnlnm("DSN$VERSION")
$        if (f$loc("2.", dver) .eq. f$len(dver)) .and. (f$loc("3.", dver) .eq. f$len(dver)) 
$        then 
$              write sys$output "DSNLink V2 or V3 is not installed on this system"
$        endif
$    else    
$!       Send the file via DSNLink...
$        write sys$output "''f$time()': Sending the collected data, ''zipnam', to Compaq via DSNLink"
$        open/append/share/error=error_mkr mkr_log 'mkr_fil'
$        write mkr_log "''f$time()' : ''node6' Sending the collected data to Compaq via DSNLink"
$        close mkr_log
$        dsnfil = zipnam - "ZIP"
$        copy 'zipnam' 'dsnfil'
$        dsnfil = "''dsnfil';"
$        DSN COPY/TOOL=RCM/verbose 'dsnfil' 
$        date_time_transport = f$time() 
$    endif
$ return
$!
$!-----------------------------------------------------------------------------------------------
$!
$ local_transport:
$!
$  if f$edit(local_site, "upcase") .nes. "Y" then return
$  if f$extract(0,1,local_password) .eqs. "x" 
$  then
$    local_password = f$extract(1,40, local_password) 
$    gosub encp
$  endif
$  if f$edit(f$extract(0, 1, local_trans), "upcase") .eqs. "E" then gosub local_email_transport
$  if f$edit(f$extract(0, 1, local_trans), "upcase") .eqs. "F" then gosub local_ftp_transport
$  if f$edit(f$extract(0, 1, local_trans), "upcase") .eqs. "D" then gosub local_decnet_transport
$ return
$!
$!-------------------------------------------------------------------------
$ encp:
$ if ALPHA
$ then
$    if f$search("rcm$dir:uuencode_alpha.exe") .eqs. "" then link/exe=rcm$dir:uuencode_alpha rcm$dir:uuencode_alpha
$    enc := $rcm$dir:uuencode_alpha
$ else
$    if f$search("rcm$dir:uuencode_vax.exe") .eqs. "" then link/exe=rcm$dir:uuencode_vax rcm$dir:uuencode_vax
$    enc := $rcm$dir:uuencode_vax
$ endif
$ enc -d
$ if $status .and. 1 then local_password = rp
$ return
$!-----------------------------------------------------------------------------------------------
$ local_email_transport:
$ if f$search("''zipfilname'.uue") .eqs. ""
$ then
$    gosub setup_uuencode
$    uue 'zipnam' 'zipfilname'.uue
$ endif
$    open/write/error=error_3  tmplocmai tmplocmail.com
$    write tmplocmai "$MAIL"
$    write tmplocmai "SEND/NOSELF/NOEDIT/NOCC ''zipfilname'.uue"
$    if f$locate("@", local_email) .ne. f$length(local_email) -
            .and. f$edit(f$trnlnm("MAIL$INTERNET_TRANSPORT"),"upcase") .nes. "SMTP" 
$    then 
$      lcl_email = "smtp%""''local_email'"""
$    else
       lcl_email = local_email
$    endif
$    write tmplocmai lcl_email
$    write tmplocmai "RCM DATA ''zipnam'"
$    write tmplocmai "EXIT"
$    write tmplocmai "$exit"
$    close tmplocmai
$    purge *.uue
$!
$    @tmplocmail
$    type tmplocmail.com
$    delete/nolog tmplocmail.com;
$ return
$!-----------------------------------------------------------------------------------------------
$ local_ftp_transport:
$!
$! if a local ftp procedure was specified in the .CFG file, use it	PTR 91-21-78
$!
$    if local_dir .eqs. "" then local_dir = "."
$    if f$search(local_ftpproc) .nes. ""
$    then
$      @'local_ftpproc' 'zipnam'
$    else 
$      open/write/error=error_3  tmplocftp tmplocftp.tmp
$      write tmplocftp "cd ''local_dir'"
$      write tmplocftp "type image"
$      write tmplocftp "put ''zipnam'"
$      write tmplocftp "quit"
$      close tmplocftp
$      type tmplocftp.tmp
$      if tcpip .eqs. "MULTINET"
$      then
$         FTP/TAKE_FILE=tmplocftp.tmp 'local_host' /USERNAME="''local_login'" /PASSWORD="''local_password'"
$      else
$         FTP/INPUT=tmplocftp.tmp 'local_host' /USERNAME="''local_login'" /PASSWORD="''local_password'"
$      endif
$      delete tmplocftp.tmp;
$    endif
$ return
$!-----------------------------------------------------------------------------------------------
$!
$ local_decnet_transport:
$!
$    copy 'zipnam' 'local_host'"''local_login' ''local_password'"::'local_dir'/log
$!
$ return
$!------------------------------------------------------------------------------------------------
$!
$ create_coll_log:
$!
$! Create Collection Log file
$!
$!collect_time = yyyymmdd-hhmmss
$ yyyy = f$extract(0,4,collect_time)
$ mm = f$extract(4,2,collect_time)
$ mons = " JAN FEB MAR APR MAY JUN JUL AUG SEP OCT NOV DEC "
$ mmm = f$element(mm, " ", mons)
$ dd = f$extract(6,2,collect_time)
$ hh = f$extract(9,2,collect_time)
$ mm = f$extract(11,2,collect_time)
$ ss = f$extract(13,2,collect_time)
$!
$ date_time_start = "''dd'-''mmm'-''yyyy' ''hh':''mm':''ss'"
$ completion_status = " ''err_code' : ''err_text'"
$ if collection_frequency .eqs. "" 
$ then 
$   collection_type = "On Demand"
$ else
$   collection_type = "Scheduled"
$ endif
$! 
$ open/write/error=error_3  logfil overall.log
$ write logfil "DateTimeStart=''date_time_start'"
$ write logfil "CompletionStatus=''completion_status'"
$ write logfil "CollectionType=''collection_type'"
$ write logfil "DateTimeTransport=''date_time_transport'"
$ write logfil "TransportType=''transport_type'"
$ write logfil "TransportAddress=" + transport_address
$ close logfil
$!
$ set output_rate
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ backup/ignore=interlock 'fname'.log 'zipfilname'.log2
$ convert overall.log, 'zipfilname'.log2 tmp.log
$ rename tmp.log 'zipfilname'-master.log
$ delete/nolog 'zipfilname'.log2;, overall.log;
$ return
$!
$!-----------------------------------------------------------------------------
$!
$ move_to_archives:
$!
$ write sys$output "Storing data in Archive dir"
$! Move collection to archive directory
$!
$ if f$parse(archive_dir) .nes. "" 
$ then 
$       curdir = f$environment("default")
$       SET DEFAULT RCM$ARCHIVE
$       write sys$output "''f$time()': Copying collected data to ''archive_dir'"
$       copy 'curdir'rcm*.zip []
$       copy 'curdir'rcm*.html []
$       copy 'curdir''cfg_file' []
$       set output_rate
$       define/user sys$output NLA0:
$       define/user sys$error NLA0:
$       backup/ignore=interlock 'curdir''fname'.log []'fname'.log/new_version
$!
$       DEFINE LIB$DT_FORMAT LIB$DATE_FORMAT_001,LIB$TIME_FORMAT_001 ! ensure date format is 'normal'
$!
$       dfil = "*.ZIP"
$       gosub del_oldest_files
$       dfil = "*.LOG"
$       gosub del_oldest_files
$       dfil = "*.HTML"
$       gosub del_oldest_files
$       dfil = "*.CFG"
$       gosub del_oldest_files
$ endif
$ return
$!
$!----------------------------------------------------------------------------------
$!
$ add_history:
$!
$ write sys$output "Adding a History Record"
$!   Add a record to the RCM_HISTORY.DAT file
$!
$    rcm_hist = "RCM_HISTORY.DAT"
$    if f$search(rcm_hist) .eqs. ""
$    then
$          open/write/error=error_3  hist 'rcm_hist'
$          write hist "RCM_HISTORY.DAT                          created ''f$time();"
$          write hist "  Date           #Nodes           ZIP       Transport      Next Date"
$          write hist "---------------------------------------------------------------------------"
$    else           
$          open/append hist 'rcm_hist'
$    endif
$!
$    fnam = zipnam - ".ZIP"
$    dt = f$extract(0,16,f$cvtime(start_time, "comparison"))
$    m = node_string
$    cntloop:
$    if f$loc(",",m) .eq. f$len(m) then goto endcnt
$    m = m - ","
$    goto cntloop
$    endcnt:
$    num_nodes = f$len(node_string) - f$len(m) + 1
$    next_collection_time = f$cvtime(next_collection_time, "ABSOLUTE")
$    dmon = f$cvtime(next_collection_time, "comparison", "day")
$    if dmon .le. 10 then next_collection_time = " " + next_collection_time
$    write hist "''dt' ''num_nodes' ''fnam' ''t_opt' ''next_collection_time'"
$    close hist
$    set default 'curdir'
$    delete/since="''start_time'" *.*;*/exclude=(*.log, *.home, *.exe, *.com, rcm*.*, *.lif, *.html, *.lock)
$    define/user sys$output NLA0:
$    define/user sys$error NLA0:
$    rename rcm_marker_'node'.mkr rcm_marker_'node'.log
$    delete/since="''start_time'" RCM$DIR:*.LOG;*, RCM$DIR:*.LOCK;*    !delete HSJ/HSZ  temp files
$ return
$!
$!--------------------------------------------------------------------------------
$!
$ create_tpu_file:
$   open/write/error=error_3  tpufile replace.tpu
$   write tpufile "procedure gsr()"
$   write tpufile "	local rng,rc;"
$   write tpufile "	on_error msg:=fao('Deleted !UL NUL Characters',rc);"
$   write tpufile "		message(msg);"
$   write tpufile "		return;"
$   write tpufile "	endon_error;"
$   write tpufile "	position(beginning_of(main_buffer));"
$   write tpufile "	rc:=0;"
$   write tpufile "	loop rng:=search(ascii(0),forward);"
$   write tpufile "		erase(rng);"
$   write tpufile "		position(end_of(rng));"
$   write tpufile "		rc:=rc+1;"
$   write tpufile "	endloop;"
$   write tpufile "endprocedure"
$   write tpufile "input_file:=get_info(command_line,'file_name');"
$   write tpufile "main_buffer:=create_buffer('main',input_file);"
$   write tpufile "gsr();"
$   write tpufile "exit;"
$   close tpufile
$ return
$!
$!----------------------------------------------------------------------------------
$!
$ setup_uuencode:
$ if ALPHA
$ then
$    uuenc = "uuencode_alpha"
$ else
$    uuenc = "uuencode_vax"
$ endif
$ uuencode = f$search("RCM$DIR:''uuenc'.exe") 
$ if uuencode .eqs. "" then link/exe=RCM$DIR:'uuenc' RCM$DIR:'uuenc'
$ uue := $RCM$DIR:'uuenc'.exe
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_value:
$  define/user sys$output NLA0:
$  define/user sys$error NLA0:
$  search 'cfg_file' "''tag'"/output=VALUE.TMP
$  if $status .ne. 1 
$  then 
$    value = def_value
$  else
$    open/read val VALUE.TMP
$    read val rec
$    close val
$    delete VALUE.TMP;
$    rec = f$edit(rec, "compress, trim")
$    if f$extract(0, 1, rec) .eqs. "["
$    then 
$      rbracket = f$locate("]", rec)+1
$      semic = f$locate(";",rec)
$      semic = semic - rbracket
$      value = f$edit(f$extract(rbracket, semic, rec), "TRIM")
$    endif
$  endif
$ return
$!
$!-------------------------------------------------------------------------------------
$!
$ get_archive_dir:
$!
$! Look in .CFG file to find ARCHIVE Directory and MAX_ARCHIVES
$!
$ def_value = def_max_archives
$ tag = "[MAX ARCHIVES]"
$ gosub get_value
$ max_archives = value
$!
$ def_value = "[.RCM_ARCHIVE]"
$ tag = "[ARCHIVE DIRECTORY]"
$ gosub get_value
$ archive_dir = value
$!
$ if f$parse(archive_dir) .eqs. "" 
$ then 
$    write sys$output "''f$time()': Creating Archive Directory ''archive_dir'"
$    create/directory 'archive_dir'
$ endif
$!
$ if f$trnlnm("RCM$ARCHIVE") .eqs. ""
$ then
$       curdir = f$environment("default")
$	SET DEFAULT 'archive_dir'
$       adev = f$getdvi(f$parse(f$env("DEFAULT"),,,"device"),"logvolnam")
$       adir = f$parse(f$env("DEFAULT"),,,"directory","no_conceal") - "]["
$       arcdir = adev + ":" + adir
$       define/system/nolog RCM$ARCHIVE 'arcdir'
$       SET DEFAULT 'curdir'
$ endif
$ return
$!
$!------------------------------------------------------------------------------------------
$!
$get_rad_info:
$!
$! Only proceed if this is a GS80, GS160, or GS320
$!
$ if f$locate(" GS80 ", machine_name) .ne. f$length(machine_name) then goto get_rad
$ if f$locate(" GS160 ", machine_name) .ne. f$length(machine_name) then goto get_rad
$ if f$locate(" GS320 ", machine_name) .ne. f$length(machine_name) then goto get_rad
$ return
$ get_rad:
$!
$ write sys$output "''f$time()': Getting RAD Info"
$ open/append/share/error=error_mkr mkr_log 'mkr_fil'
$ write mkr_log "''f$time()' : ''node6' Getting RAD Information"
$ close mkr_log
$ write rcm_log "''f$time()': Getting RAD Info"
$ if f$search("rad_''node'.txt") .nes. "" then delete/nolog rad_'node'.txt;* 
$!
$ define sys$output rad_'node'.txt 
$ write sys$output "RAD_MAX_RADS  = ''f$getsyi("rad_max_rads")'"
$ write sys$output "RAD_CPUS      = ''f$getsyi("rad_cpus")'"
$ write sys$output "RAD_MEMSIZE   = ''f$getsyi("rad_memsize")'"
$ write sys$output "RAD_SHMEMSIZE = ''f$getsyi("rad_shmemsize")'"
$ write sys$output  ""
$ write sys$output  "Output from 'radcheck -allprocs'"
$ write sys$output  ""
$ radcheck := $sys$test:radcheck.exe 
$ radcheck -allprocs
$ deassign sys$output
$!
$!
$ open/write/error=error_3  hdr rad_'node'.hdr
$ write hdr "--- START RCM RAD ---"
$ write hdr ""
$ close hdr
$!
$ open/write/error=error_3  end rad_'node'.end
$ write end ""
$ write end "--- END RCM RAD ---"
$ write end ""
$ close end
$ convert rad_'node'.hdr, rad_'node'.txt, rad_'node'.end rcm_rad_'node'.txt
$ delete rad_'node'.hdr;, rad_'node'.txt;, rad_'node'.end; 
$!
$ convert 'fname'.txt, rcm_rad_'node'.txt rcm_'node'.tmp
$ rename rcm_'node'.tmp 'fname'.txt
$ purge 'fname'.txt
$ delete rcm_rad_'node'.txt;
$ return
$!
$!-----------------------------------------------------------------------------------------
$!
$ get_cfg_items:
$ serial_number = ""
$ v1 = "IOP{}asdfghjklASDFGHJKL"   ! use ' to indicated encd and ; as comment char
$ w1 = ":zxcvbnm,./ZXCVBNM<>?"   
$ x1 = "`1234567890-=~!@#$%^&*()"
$ y1 = "_+|qwertyuiop[]QWERTYU\""" 
$ open/read cfgf 'cfg_file'
$ cfgloop:
$ read/end=endcfgloop cfgf cfgrec
$ cfgrec = f$edit(cfgrec, "compress, trim")
$ if f$extract(0, 1, cfgrec) .eqs. "["
$ then 
$   rbracket = f$locate("]", cfgrec)+1
$   semic = f$locate(";",cfgrec)
$   semic = semic - rbracket
$   value = f$edit(f$extract(rbracket, semic, cfgrec), "TRIM")
$ endif
$ if f$locate("[COMPANY NAME]", cfgrec) .ne. f$length(cfgrec) then company_name = value
$ if f$locate("[CONTACT NAME]", cfgrec) .ne. f$length(cfgrec) then contact_name = value
$ if f$locate("[CONTACT TELEPHONE]", cfgrec) .ne. f$length(cfgrec) then contact_telephone = value
$ if f$locate("[CONTACT EMAIL]", cfgrec) .ne. f$length(cfgrec) then contact_email = value
$ if f$locate("[ACCOUNT MANAGER]", cfgrec) .ne. f$length(cfgrec) then account_manager = value
$ if f$locate("[ACCOUNT MANAGER EMAIL]", cfgrec) .ne. f$length(cfgrec) then account_manager_email = value
$ if f$locate("[CUSTOMER ACCESS ID]", cfgrec) .ne. f$length(cfgrec) then customer_access_id = value
$ if f$locate("[TRANSPORT OPTION]", cfgrec) .ne. f$length(cfgrec) then transport_option = value
$ if f$locate("[COLLECTION FREQUENCY]", cfgrec) .ne. f$length(cfgrec) then collection_frequency = f$edit(value, "UPCASE")
$ if f$locate("[NEXT COLLECTION TIME]", cfgrec) .ne. f$length(cfgrec) then next_collection_time = value
$ if f$locate("[FTP AREA]", cfgrec) .ne. f$length(cfgrec) then ftp_area = value
$ if f$locate("[FTP PROCEDURE]", cfgrec) .ne. f$length(cfgrec) then ftp_procedure = value
$ if f$locate("[EMAIL ADDRESS]", cfgrec) .ne. f$length(cfgrec) then email_adr = value
$ if f$locate("[MAX ARCHIVES]", cfgrec) .ne. f$length(cfgrec) then max_archives = value
$ if f$locate("[ARCHIVE DIRECTORY]", cfgrec) .ne. f$length(cfgrec) then archive_dir = value
$ if f$locate("[LOCAL SITE]", cfgrec) .ne. f$length(cfgrec) then local_site = value 
$ if f$locate("[LOCAL TRANSPORT OPTION]", cfgrec) .ne. f$length(cfgrec) then local_trans = value 
$ if f$locate("[LOCAL EMAIL ADDRESS]", cfgrec) .ne. f$length(cfgrec) then local_email = value 
$ if (f$locate("[LOCAL HOSTNAME]", cfgrec) .ne. f$length(cfgrec)) -
   .or. (f$locate("[LOCAL FTP ADDRESS]", cfgrec) .ne. f$length(cfgrec)) then local_host = value 
$ if f$locate("LOGIN]", cfgrec) .ne. f$length(cfgrec) then local_login = value 
$ if f$locate("PASSWORD]", cfgrec) .ne. f$length(cfgrec) then local_password = value 
$ if f$locate(" UPLOADDIR]", cfgrec) .ne. f$length(cfgrec) then local_dir = value 
$ if f$locate("[LOCAL FTP PROCEDURE]", cfgrec) .ne. f$length(cfgrec) then local_ftpproc = value  
$ if f$locate("[SUPPRESS IP ADDRESSES]", cfgrec) .ne. f$length(cfgrec) then suppress_ip = value 
$ if f$locate("[FCT BINARY IMAGE]", cfgrec) .ne. f$length(cfgrec) then fct_image = value 
$ if f$locate("[DATA FOR ANALYSIS]", cfgrec) .ne. f$length(cfgrec) then anal_data = f$edit(f$extract(0,1,value), "upcase") 
$ if f$locate("[NODES]", cfgrec) .ne. f$length(cfgrec) then node_string = f$edit(value, "UPCASE")  !PTR36-4-522 1-Mar-99
$! PTR 36-4-460 18-Jan-1999 PM change node6 to node because compress,trim above removes extra spaces!
$ if f$locate("[''node' SYSTEM SERIAL NUMBER]", cfgrec) .ne. f$length(cfgrec) 
$ then 
$ 	serial_number = value
$       cfg_sn = value
$ endif
$ goto cfgloop
$ endcfgloop:
$ close cfgf
$ if max_archives .eqs. "" then max_archives = def_max_archives
$ if archive_dir .eqs. "" then archive_dir = "[.RCM_ARCHIVE]"
$ if serial_number .eqs. "" then serial_number = "unknown"
$ return
$!
$!----------------------------------------------------------------------
$!
$!  Copyright 2001 Compaq Information Technologies Group, L.P.
$!
$!    Compaq and the Compaq logo are trademarks of Compaq Information
$!    Technologies Group, L.P. in the U.S. and/or other countries.
$!
$!    Confidential computer software. Valid license from Compaq required for
$!    possession, use or copying. Consistent with FAR 12.211 and 12.212,
$!    Commercial Computer Software, Computer Software Documentation, and
$!    Technical Data for Commercial Items are licensed to the U.S. Government
$!    under vendor's standard commercial license.
$!
$!    Compaq service tool software, including associated documentation, is the
$!    property of and contains confidential technology of Compaq Computer 
$!    Corporation or its affiliates. Service customer is hereby licensed to use
$!    the software only for activities directly relating to the delivery of, 
$!    and only during the term of, the applicable services delivered by Compaq
$!    or its authorized service provider. Customer may not modify or reverse
$!    engineer, remove, or transfer the software or make the software or any
$!    resultant diagnosis or system management data available to other parties
$!    without Compaqs or its authorized service providers consent. Upon 
$!    termination of the services, customer will, at Compaqs or its service
$!    providers option, destroy or return the software and associated
$!    documentation in its possession.
$!
$!****************************************************************************
$!                                                                             
$!      FACILITY                :       OpenVMS RCM Data Collector       
$!
$!      COMMAND FILE            :       RCM_COLLECT.COM                           
$!                                                                             
$!      DESCRIPTION             :       Collects the RCM data on each selected node 
$!                                                                             
$!      PROGRAMMER              :       Pat Moran, 10 Jun 1998    
$!
$!      MODIFICATIONS           :       Version V1.0.1   P. Moran 10-Jun-1998
$!                                              V1.0.2 PTR 36-4-127 PM 10-Aug-1998
$!                                              V1.0.3 update to V1.0.3 PM 10-Aug-1998
$!                                              V1.0.4 update to V1.0.4 PM 31-Aug-1998
$!						V1.0.5 PTR36-4-209 fix HSZ collection
$!                                                     Update for VAX 16-Oct-1998
$!						V2.1.0 Update for RCM V2.1.0 3-Nov-1998
$!						V2.1.1 Update for RCM V2.1.1 4-Dec-1998
$!						V2.1.2 Update for RCM V2.1.2 20-Jan-1999
$!						V2.2 Update for RCM V2.2.0 22-Mar-1999
$!						V3.0 Update for RCM V3.0 11-May-1999
$!						V4.0 Update for RCM V4.0 1-Feb-2001
$!*****************************************************************************
