$! RCM_SETUP.COM V4.0-507SP4a  Generation: 353  30-APR-2002 16:43:32.71  !!!!>
$ SET SYMBOL/SCOPE=(NOLOCAL,NOGLOBAL)                                    !!!!>
$ rcm_ver = "V4.0-507SP4a"                                               !!!!>
$!
$! RCM_SETUP.COM  			Pat Moran 2-Feb-2000
$!
$! This procedure is executed in the postinstall phase of PCSI installation
$! of RCM. It defines the RCM$DIR, RCM$ROOT, RCM$DATA, and RCM$NODE logicals and updates the 
$! DESTA.REG file if the logical SVCTOOLS_HOME is defined.
$!
$ set noon
$ node = f$getsyi("NODENAME")
$ ALPHA = f$getsyi( "HW_MODEL" ) .ge. 1024
$ gosub set_rcmdir
$ gosub look_for_oldconfig
$ tmp_ver = f$extract(1,3, rcm_ver) - "."
$ rel_name = "RCM0''tmp_ver'.RELEASE_NOTES;0"
$ copy RCM$DIR:RCM.RELEASE_NOTES SYS$COMMON:[SYSHLP]'rel_name'
$ delete RCM$DIR:RCM.RELEASE_NOTES;*
$!
$ if f$search("RCM$DIR:RCM_STANDALONE.TXT") .nes. "" then $exit  !This is a standalone RCM installation
$!
$ gosub get_common_values
$ gosub update_rcm_defaults
$ gosub add_rcm_to_dri
$ exit
$!
$!---------------------------------------------------------------------------------------------------
$!---------------------------------------------------------------------------------------------------
$!
$ set_rcmdir:
$!
$!   Find where RCM_START.COM is
$!
$ fndloop:
$ rcmstart = f$search("PCSI$DESTINATION:[*...]RCM_START.COM")
$ if rcmstart .eqs. "" 
$ then 
$     write sys$output "Could not find RCM_START.COM"
$     exit
$ endif
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search 'rcmstart' 'rcm_ver'    		!Check that this is the correct version
$ if $status .ne. 1 then goto fndloop
$! sh sym rcmstart
$ rcmdevice = f$parse(rcmstart,,,"DEVICE")
$ rcmdevice = f$getdvi(rcmdevice, "LOGVOLNAM") +":"
$ rcmdirectory = f$parse(rcmstart,,,"DIRECTORY")
$ rcmdir = rcmdevice + rcmdirectory - "]["
$ curdir = f$environment("DEFAULT")
$ set default 'rcmdir'
$ rcmdir = f$parse(f$environment("DEFAULT"),,,,) - "][" - ".;"
$ rcmroot = f$parse(f$environment("DEFAULT"),,,,) - "][" - "].;" + ".]" 
$ rename RCM_START.COM ;0                          ! just to update the Revision Date for Installation Time!! 
$ set default 'curdir'
$!
$ DEFINE/SYSTEM/NOLOG RCM$DIR 'rcmdir'
$ DEFINE/SYSTEM/NOLOG/TRANSLATE=CONCEALED RCM$ROOT 'rcmroot'
$ DEFINE/SYSTEM/NOLOG RCM$NODE 'node'
$!
$ rcmtop = f$trnlnm("RCM$DIR") - ".RCM"
$ DEFINE/SYSTEM/NOLOG RCM$TOP 'rcmtop'
$!
$  if ALPHA
$  then
$    link/exe=rcm$dir:uuencode_alpha rcm$dir:uuencode_alpha
$  else
$    link/exe=rcm$dir:uuencode_vax rcm$dir:uuencode_vax
$  endif
$!
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ MCR SYSMAN STARTUP SHOW FILE RCM$STARTUP.COM        !may be left over from old installation
$ if $STATUS .and. 1                                  !no longer needed
$ then
$     MCR SYSMAN STARTUP REMOVE FILE RCM$STARTUP.COM
$     if f$search("SYS$STARTUP:RCM$STARTUP.COM") .nes. "" then delete/nolog SYS$STARTUP:RCM$STARTUP.COM;*
$ endif
$!
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ MCR SYSMAN STARTUP SHOW FILE RCM$STARTUP_'node'.COM
$ if $STATUS .and. 1 
$ then
$     MCR SYSMAN STARTUP REMOVE FILE RCM$STARTUP_'node'.COM
$     if f$search("SYS$STARTUP:RCM$STARTUP_''node'.COM") .nes. "" then delete/nolog SYS$STARTUP:RCM$STARTUP_'node'.COM;*
$ endif
$!
$! Create SYS$COMMON:[SYS$STARTUP]RCM$STARTUP_<thisnode>.COM and add to SYSMAN STARTUP
$!
$ open/write rcmstartup SYS$COMMON:[SYS$STARTUP]RCM$STARTUP_'node'.COM
$ write rcmstartup "$! SYS$COMMON:[SYS$STARTUP]RCM$STARTUP_''node'.COM  defines RCM Logicals"
$ write rcmstartup "$!"
$ write rcmstartup "$! This procedure was generated by RCM_SETUP.COM during the installation"
$ write rcmstartup "$! of RCM ''rcm_ver' on ''f$time()' Node ''node'"
$ write rcmstartup "$!"
$ write rcmstartup "$ DEFINE/SYSTEM/NOLOG RCM$DIR ''rcmdir'"
$ write rcmstartup "$ DEFINE/SYSTEM/NOLOG/TRANSLATE=CONCEALED RCM$ROOT ''rcmroot'"
$ write rcmstartup "$ DEFINE/SYSTEM/NOLOG RCM$DATA RCM$ROOT:[DATA]"
$ write rcmstartup "$ DEFINE/SYSTEM/NOLOG RCM$NODE ''node'"
$ write rcmstartup "$ exit"
$ close rcmstartup
$!
$ MCR SYSMAN STARTUP ADD FILE RCM$STARTUP_'node'.COM
$!
$ return
$!
$!---------------------------------------------------------------------------------------------------
$!
$ get_common_values:
$!
$ if f$search("SVCTOOLS_HOME:[DESTA.CONFIG]DESTA.REG") .nes. ""
$ then
$   	define/user sys$output desta.tmp
$  	desta dri "GET" "common.UserCompany" 
$   	define/user sys$output NLA0:
$   	define/user sys$error NLA0:
$   	search desta.tmp "common.UserCompany=null"
$   	if $status .eq. 1 
$   	then 
$     	   delete/nolog desta.tmp;
$     	   return   ! if this key is not in DESTA.REG
$   	endif
$!
$       define/user sys$output desta1.tmp
$       desta dri "GET" "common.UserName" "GET" "common.UserPhone" "GET" "common.UserEmail" 
$       append desta1.tmp desta.tmp
$       delete/nolog desta1.tmp;
$   	define/user sys$output desta.tmp
$   	desta dri "GET" "common.UserCompany" 
$   	define/user sys$output NLA0:
$   	define/user sys$error NLA0:
$   	search desta.tmp "common.UserCompany=null"
$   	if $status .eq. 1 
$   	then 
$     	   delete/nolog desta.tmp;
$     	   return   ! if this key is not in DESTA.REG
$   	endif
$!
$   	define/user sys$output desta1.tmp
$   	desta dri "GET" "common.UserName" "GET" "common.UserPhone" "GET" "common.UserEmail" 
$   	append desta1.tmp desta.tmp
$   	delete/nolog desta1.tmp;
$ else
$   	if f$search("[]WEBES_REG_COMMON_INFO.TXT") .nes. ""
$   	then
$      	   usernam = "<undefined>"
$      	   phonen = "<undefined>"
$      	   companyn = "<undefined>"
$      	   email = "<undefined>"
$      	   root = "<undefined>"
$      	   open/read webesreg []WEBES_REG_COMMON_INFO.TXT
$      	   readloop:
$      	   read/end=endreadloop webesreg rec
$      	   if f$loc("Name is ", rec) .ne. f$len(rec) then usernam = f$extract(f$loc("Name is ", rec)+8,30,rec)
$      	   if f$loc("Phone number is ", rec) .ne. f$len(rec) then phonen = f$extract(f$loc("Phone number is ", rec)+16,30,rec)
$      	   if f$loc("Company is ", rec) .ne. f$len(rec) then companyn = f$extract(f$loc("Company is ", rec)+11,30,rec)
$      	   if f$loc("Email address is ", rec) .ne. f$len(rec) then email = f$extract(f$loc("Email address is ", rec)+17,30,rec)
$      	   if f$loc("Root path is ", rec) .ne. f$len(rec) then root = f$extract(f$loc("Root path is ", rec)+13,30,rec)
$      	   goto readloop
$      	   endreadloop:
$      	   close webesreg
$      	   open/write tmpfil desta.tmp
$      	   write tmpfil "common.UserCompany=''companyn'"
$      	   write tmpfil "common.UserName=''usernam'"
$      	   write tmpfil "common.UserPhone=''phonen'"
$      	   write tmpfil "common.UserEmail=''email'"
$      	   close tmpfil
$   	endif
$ endif
$ return
$!
$!---------------------------------------------------------------------------------------------------
$!
$ update_rcm_defaults:
$!
$!   update the RCM$DIR:RCM$DEFAULTS.CFG file with the Common Values from the registry:
$!
$    if f$search("DESTA.TMP") .nes. "" 
$    then
$      open/read dri desta.tmp
$      driloop:
$        read/end=endreg dri drirec
$        if f$locate("common.UserCompany", drirec) .ne. f$length(drirec) then company_name = f$extract(f$locate("=", drirec)+1, 40, drirec)
$        if f$locate("common.UserName", drirec) .ne. f$length(drirec) then contact_name = f$extract(f$locate("=", drirec)+1, 40, drirec)
$        if f$locate("common.UserPhone", drirec) .ne. f$length(drirec) then contact_telephone = f$extract(f$locate("=", drirec)+1, 40, drirec)
$        if f$locate("common.UserEmail", drirec) .ne. f$length(drirec) then contact_email = f$extract(f$locate("=", drirec)+1, 40, drirec)
$        goto driloop
$      endreg:
$      close dri
$    endif
$!
$! update the RCM$DIR:RCM$DEFAULTS.CFG file with the values from RCMINFO.TXT - written by Preconfigure RCM_PRECONFIGURE.COM 
$!
$ tam_name = ""
$ tam_email = ""
$ cust_id = ""
$ tr_opt = ""
$ freq = ""
$ nodes = ""
$ sn = ""
$!
$    if f$search("[]RCMINFO.TXT") .nes. "" 
$    then 
$     open/read/end=endpre pre []RCMINFO.TXT
$     preloop:
$       read/end=endpre pre prerec
$       if f$locate("[ACCOUNT MANAGER]", prerec) .ne. f$length(prerec) then tam_name = prerec
$       if f$locate("[ACCOUNT MANAGER EMAIL]", prerec) .ne. f$length(prerec) then tam_email = prerec
$       if f$locate("[CUSTOMER ACCESS ID]", prerec) .ne. f$length(prerec) then cust_id = prerec
$       if f$locate("[TRANSPORT OPTION]", prerec) .ne. f$length(prerec) then tr_opt = prerec
$       if f$locate("[COLLECTION FREQUENCY]", prerec) .ne. f$length(prerec) then freq = prerec
$       if f$locate("[NODES]", prerec) .ne. f$length(prerec) then nodes = prerec
$       if f$locate(" SYSTEM SERIAL NUMBER]", prerec) .ne. f$length(prerec) then sn = prerec
$       goto preloop
$     endpre:
$     close pre
$    endif
$!
$!   Get the [FTP AREA] and [EMAIL ADDRESS] from the RCM Kits RCM$DEFAULTS.CFG
$!
$    ftp_area = ""
$    email_address = ""
$    if f$search("RCM$DIR:RCM$DEFAULTS.CFG") .nes. "" 
$    then 
$     open/read/end=enddef def RCM$DIR:RCM$DEFAULTS.CFG
$     defloop:
$       read/end=enddef def rec
$       if f$locate("[FTP AREA]", rec) .ne. f$length(rec) then ftp_area = rec
$       if f$locate("[EMAIL ADDRESS]", rec) .ne. f$length(rec) then email_address = rec
$       goto defloop
$     enddef:
$     close def
$    endif
$!
$! If we have recovered an old .CFG file, rename this to RCM$DIR:RCM$DEFAULTS.CFG
$!
$ if f$search("RCM$DATA:''cfg_file'") .nes. "" then rename RCM$DATA:'cfg_file' RCM$DIR:RCM$DEFAULTS.CFG;0
$!
$ open/read/error=norcmcfg oldrcm RCM$DIR:RCM$DEFAULTS.CFG
$ open/write newrcm RCM$DIR:RCM$DEFAULTS.CFGNEW
$ rcmloop:
$   read/end=endrcm oldrcm line
$   if f$locate("[COMPANY NAME]", line) .ne. f$length(line) then line = "[COMPANY NAME]                        ''company_name'" 
$   if f$locate("[CONTACT NAME]", line) .ne. f$length(line) then line = "[CONTACT NAME]                        ''contact_name'" 
$   if f$loc("[CONTACT TELEPHONE]", line) .ne. f$leng(line) then line = "[CONTACT TELEPHONE]                   ''contact_telephone'" 
$   if f$locate("[CONTACT EMAIL]", line) .ne. f$lengt(line) then line = "[CONTACT EMAIL]                       ''contact_email'" 
$   if f$locate("[ACCOUNT MANAGER]", line) .ne. f$length(line) then if tam_name .nes. ""  then line = tam_name 
$   if f$locate("[ACCOUNT MANAGER EMAIL]", line) .ne. f$length(line) then if tam_email .nes. "" then line = tam_email 
$   if f$locate("[CUSTOMER ACCESS ID]", line) .ne. f$length(line) then if cust_id .nes. "" then line = cust_id 
$   if f$locate("[TRANSPORT OPTION]", line) .ne. f$length(line) then if tr_opt .nes. "" then line = tr_opt
$   if f$locate("[COLLECTION FREQUENCY]", line) .ne. f$length(line) then if freq .nes. "" then line = freq 
$   if f$locate("[FTP AREA]", line) .ne. f$length(line) then if ftp_area .nes. "" then line = ftp_area 
$   if f$locate("[EMAIL ADDRESS]", line) .ne. f$length(line) then if email_address .nes. "" then line = email_address 
$   if f$locate("[NODES]", line) .ne. f$length(line) then if nodes .nes. "" then line = nodes 
$   if f$locate(" SYSTEM SERIAL NUMBER]", line) .ne. f$length(line) then if sn .nes. "" then line = sn 
$   write newrcm line
$ goto rcmloop
$ endrcm:
$ close oldrcm
$ close newrcm
$ rename RCM$DIR:RCM$DEFAULTS.CFGNEW RCM$DIR:RCM$DEFAULTS.CFG
$! ty/page rcm$dir:rcm$defaults.cfg
$ purge RCM$DIR:RCM$DEFAULTS.CFG   
$ if f$search("DESTA.TMP") .nes. "" then delete desta.tmp;*
$ if f$search("[]RCMINFO.TXT") .nes. "" then delete []RCMINFO.TXT;* 
$!
$ return
$!
$!---------------------------------------------------------------------------------------------------
$!
$ add_rcm_to_dri:
$!
$ if f$search("SVCTOOLS_HOME:[DESTA.CONFIG]DESTA.REG") .eqs. "" 
$ then 
$  if f$search("[]WEBES_REG_COMMON_INFO.TXT") .nes. "" then gosub add_rcm_to_commoninfo 
$  return
$ endif
$!
$! ADD and SET the RCM Key=Value pairs in the DESTA Registry
$!
$! Check if rcm.Name is already in DESTA.REG
$!
$ define/user sys$output rcmdesta.tmp
$ desta dri "GET" "rcm.Name" 
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search rcmdesta.tmp "rcm.Name=null"
$ if $status .ne. 1 
$ then 
$    delete/nolog rcmdesta.tmp;*
$    return   ! this key is already in DESTA.REG
$ endif
$!
$ desta dri "ADD" "rcm.Name" "SET" "rcm.Name" "RCM" 
$ desta dri "ADD" "rcm.FullName" "SET" "rcm.FullName" "Revision and Configuration Management"
$ desta dri "ADD" "rcm.Version" "SET" "rcm.Version" "''rcm_ver'"   
$ desta dri "ADD" "rcm.InstallDate" "SET" "rcm.InstallDate" "''f$time()'"  
$ desta dri "DEL" "rcm.DeInstallationDate"
$ desta dri "ADD" "rcm.DataCollector.ToolCmd" "SET" "rcm.DataCollector.ToolCmd" "RCM$DIR:RCM_RUN.COM"
$ desta dri "ADD" "rcm.DataCollector.CmdLocation" "SET" "rcm.DataCollector.CmdLocation" "ManagedSys"
$ desta dri "ADD" "rcm.DataCollector.MenuText" "SET" "rcm.DataCollector.MenuText" "RCM Data Collector"
$ desta dri "ADD" "rcm.DataCollector.TooltipText" 
$ desta dri "SET" "rcm.DataCollector.TooltipText" "Run RCM data collector as configured"
$ desta dri "ADD" "rcm.DataCollector.ButtonGraphic" "SET" "rcm.DataCollector.ButtonGraphic" "rcmcollect.gif"
$!
$ purge SVCTOOLS_HOME:[DESTA.CONFIG]DESTA.REG
$ return
$!
$!------------------------------------------------------------------------------------------------
$ add_rcm_to_commoninfo:
$!
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search WEBES_REG_COMMON_INFO.TXT "rcm."
$ if $severity .eq. 1   ! found rcm. entries in the file                               
$ then
$!
$!  now get rid of the old Rcm entries - the Rev and Date will be incorrect
$!
$   define/user sys$output NLA0:
$   define/user sys$error NLA0:
$   search WEBES_REG_COMMON_INFO.TXT "rcm."/match=nor/out=WEBES_REG_COMMON_INFO.TMP
$   rename WEBES_REG_COMMON_INFO.TMP WEBES_REG_COMMON_INFO.TXT
$ endif
$!
$! No rcm. entries in the file, so add them
$!
$ open/append/error=nocommon comm WEBES_REG_COMMON_INFO.TXT
$ write comm "rcm.Name=RCM" 
$ write comm "rcm.FullName=Revision and Configuration Management" 
$ write comm "rcm.Version=''rcm_ver'"
$ write comm "rcm.InstallDate=''f$time()'"  
$ write comm "rcm.DataCollector.ToolCmd=RCM$DIR:RCM_RUN.COM"
$ write comm "rcm.DataCollector.CmdLocation=ManagedSys"
$ write comm "rcm.DataCollector.MenuText=RCM Data Collector"
$ write comm "rcm.DataCollector.TooltipText=Run RCM data collector as configured"
$ write comm "rcm.DataCollector.ButtonGraphic=rcmcollect.gif"
$ close comm
$ nocommon:
$ return
$!
$!--------------------------------------------------------------------------------------------------
$!
$norcmcfg:
$ write sys$output "No RCM$DEFAULTS.CFG file found!"
$ show default
$ exit
$!--------------------------------------------------------------------------------------
$!
$look_for_oldconfig:
$ if f$search("RCM$DIR:DATA.DIR") .eqs. "" then create/dir RCM$ROOT:[DATA]
$ define/system RCM$DATA RCM$ROOT:[DATA]
$!
$ if f$search("SYS$SYSTEM:RCMCONFIG.CFG") .eqs. "" then return
$! 
$ cfg_file = ""
$ tmp_arch = ""
$ open/read cfil SYS$SYSTEM:RCMCONFIG.CFG
$ rcmdloop:
$   read/end=endcfil cfil line
$   if f$extract(0,1,line) .eqs. "["
$   then
$      rbracket = f$locate("]",line)+1
$      semic = f$locate(";",line)
$      semic = semic - rbracket
$      value = f$edit(f$extract(rbracket, semic, line), "TRIM")
$      if f$locate("[CONFIGFILE NAME]",line) .ne. f$length(line) then cfg_file = value
$      if f$locate("[TMP_ARCHIVE DIRECTORY]",line) .ne. f$length(line) then tmp_arch = value
$   endif
$   goto rcmdloop
$ endcfil:
$ close  cfil
$ if cfg_file .eqs. "" then cfg_file = "''node'.cfg"
$ search/output=RCM$DATA:'cfg_file'/match=nor sys$system:rcmconfig.cfg "[TMP_ARCHIVE DIRECTORY]","[CONFIGFILE NAME]"
$ create RCM$DATA:CFGHDR.TMP
$ open/append tmpcf RCM$DATA:CFGHDR.TMP
$ write tmpcf "; Updated by RCM ''rcm_ver'    ''f$time();"
$ close tmpcf
$ convert RCM$DATA:CFGHDR.TMP, RCM$DATA:'cfg_file' RCM$DATA:CFGTMP.TMP
$ delete/nolog RCM$DATA:CFGHDR.TMP;*
$ rename RCM$DATA:CFGTMP.TMP RCM$DATA:'cfg_file'
$ item = "[COLLECTION DIRECTORY]"
$ coll_dir = "RCM$ROOT:[DATA]
$ var = coll_dir
$ gosub update_cfg_file 
$!
$ if tmp_arch .nes. ""
$ then ! only update archive dir if [TMP_ARCHIVE DIRECTORY] is found
$   item = "[ARCHIVE DIRECTORY]"
$   archive_dir = "RCM$ROOT:[RCM_ARCHIVE]
$   if f$search("RCM$DIR:RCM_ARCHIVE.DIR") .eqs. "" then create/dir RCM$ROOT:[RCM_ARCHIVE]
$   var = archive_dir
$   gosub update_cfg_file 
$ endif
$!
$ purge/nolo RCM$DATA:*.CFG
$!
$ if f$search("RCM$DATA:''cfg_file'") .nes. "" then delete/nolog sys$system:rcmconfig.cfg;*
$!
$! Find where the Archives are temporarily stored from the [TMP_ARCHIVE DIRECTORY] 
$! record in the saved copy of the config file)
$!
$! If found, copy the archives back to RCM$ROOT:[RCM_ARCHIVE].
$!
$ if tmp_arch .nes. "" then tmp_arch = tmp_arch - ".RCM_ARCHIVE]" + "]RCM_ARCHIVE.DIR"
$ if f$search(tmp_arch) .nes. ""
$ then
$   adev = f$parse(tmp_arch,,,"DEVICE")
$   adir = f$parse(tmp_arch,,,"DIRECTORY")
$   adir = adir - "]" + ".RCM_ARCHIVE]"
$   copy 'adev''adir'*.* RCM$ROOT:[RCM_ARCHIVE]*.* 
$   if f$search("''adev'''adir'*.*;*") .nes. "" then delete/nolo 'adev''adir'*.*;*
$   delete/nolog 'tmp_arch';
$ endif
$return
$!
$!--------------------------------------------------------------------------------------------
$!
$ update_cfg_file:
$ open/read/error=error_1 oldcfg RCM$DATA:'cfg_file'
$ open/write/error=error_1 newcfg RCM$DATA:'cfg_file'1
$ readcfgfile:
$ read/end=end_cfgf oldcfg line
$ !  copy every line to a new version of the file, except the [<item>] line which is updated
$ if f$locate("''item'", line) .ne. f$len(line)
$ then
$    item = f$extract(0,22,"''item'                     ")
$    write newcfg "''item'                ''var'"
$ else
$    write newcfg line
$ endif
$ goto readcfgfile
$ end_cfgf:
$ close oldcfg
$ close newcfg
$ rename RCM$DATA:'cfg_file'1 RCM$DATA:'cfg_file'
$ return
$!
$!--------------------------------------------------------------------
$!
$ error_1:
$ write sys$output "% error updating CFG file RCM$DATA:''cfg_file'"
$ exit
