
 #! perl -w # H # Nodewatch.pl -- keep an eye out for nodes that drop out of the cluster # and send mail when they do.  use strict;  use Socket;  use VMS::System qw(node_list); use vars qw($debug_level);   # LOCAL CONFIG PORTION # < # Change the variables here to suit your local configuration # K # mail_to is an array of e-mail addressess. the smailer sub takes canonical + # addresses only, so they need to be in <>  : my @mail_to = ('<sugalskd@ous.edu>', '<rutledge@sou.edu>',6                '<dan@sidhe.org>', '<elznerl@oit.edu>',=                '<its-softsys@ous.edu>', '<its-ops@ous.edu>'); G my $mail_to = join ",", @mail_to; # used in the outgoing e-mail message E my $mail_from = '<sugalskd@ous.edu>'; # Who the mail's marked as from G my $sleep_interval = 30;        # The number of seconds between updates   I # Declare the name of the host we're pawning the mail off onto. localhost ? # is probably the best option if we've got a mailserver on this G # machine. If not, change it to another host. *YOU MUST HAVE MAIL RELAY  # PERMISSION ON THIS HOST!* I my $mailhost_name = "ous.edu";  # Don't use this one--it will reject your ,                                 # relay mailG my $mailhost_ip = ""; # The IP address for the mailhost. If left blank, C                       # we'll go try to figure it out. Should be in :                       # packed format, so no 1.2.3.4 here.D my $mailhost_port = 25; # The port to connect to. Except in the mostB                         # bizarre of circumstances, this'll be 25.G my $we_are = ""; # Who we are. Fill this in if your mailserver needs to F                  # know. The only way to find this out locally is withD                  # POSIX::uname. Not everyone has it, and POSIX is aG                  # memory pig anyway. If you don't, we'll try a reverse I                  # lookup from the IP address on this end of things after 4                  # the connection to the mailserver.= $debug_level = 1;               # Spit out debugging messages  #  # END OF LOCAL CONFIG PORTION        # prototype for smailer  sub smailer ($\@\@);  C # define the node list variable and fetch the initial list of nodes   my @last_nodelist = node_list();M my (%current_nodelist, @missing_nodes, @message, @new_nodes, %last_nodelist);   I # We're just going to loop forever, checking for nodes going missing, and  # yell if they have. while (1) {      sleep $sleep_interval;     %current_nodelist = (); (     @current_nodelist{node_list()} = ();(     @last_nodelist{@last_nodelist} = ();     @missing_nodes = ();     @new_nodes = ();       foreach (@last_nodelist) {E         push @missing_nodes, $_  unless exists $current_nodelist{$_};      }        if (@missing_nodes) { (         @message = ("From: $mail_from:",=                     "To: (Cluster transition list) $mail_to", U                     "Subject: Node(s) @missing_nodes have fallen out of the cluster",                      '', M                     'The following nodes have disappeared from the cluster:',                      '', %                     "@missing_nodes",                      '', K                     'These nodes went missing as of ' . scalar(localtime())                      );0         smailer($mail_from, @mail_to, @message);8         print STDERR "Nodes @missing_nodes gone as of ",B                      scalar(localtime()), "\n"    if $debug_level;     }   &     foreach (keys %current_nodelist) {>         push @new_nodes, $_  unless exists $last_nodelist{$_};     }        if (@new_nodes) { '         @message = ("From: $mail_from", =                     "To: (Cluster transition list) $mail_to", J                     "Subject: Node(s) @new_nodes have joined the cluster",                     '', C                     'The following nodes have joined the cluster:',                      '', !                     "@new_nodes",                      '', E                     'These nodes joined as of ' . scalar(localtime())                      );0         smailer($mail_from, @mail_to, @message);9         print STDERR "Nodes @new_nodes showed up as of ", B                      scalar(localtime()), "\n"    if $debug_level;     }   ,     @last_nodelist = keys %current_nodelist;   } H # smailer - quicko sub to send mail. Takes from, a reference to an array? # with the to addresses in it, and a reference to an array with B # the actual formatted mail message in it, minus line terminators. sub smailer ($\@\@){)   my ($from, $to_ref, $message_ref) = @_;     I   my $mailhost_paddr; # Where the packed IP address & port will get stuck    my $they_said;  1   # Translate the port to a number if it's a name S   $mailhost_port = getservbyname($mailhost_port, 'tcp')  if $mailhost_port =~ /\D/; '   # Figure the IP address if we need to -   $mailhost_ip ||= inet_aton($mailhost_name); #   # Build the packed socket address >   $mailhost_paddr = sockaddr_in($mailhost_port, $mailhost_ip);     # Create the socket S   socket(MAILSOCK, PF_INET, SOCK_STREAM, getprotobyname('tcp')) || die "socket:$!";    # Open the socket @   connect(MAILSOCK, $mailhost_paddr) || die "Connect error: $!";
   # Dup it@   open(MAILOUTSOCK, ">&MAILSOCK") || die "Erro dupping, $! $^E";   select(MAILSOCK); 	   $| = 1;    select(MAILOUTSOCK);	   $| = 1;    select(STDOUT);   ;   # Unless we know who we are, we'd better go figure it out 9   my $stuff = getsockname(MAILSOCK) || die "Hey! $^E $!"; /   my ($foo, $bar) = unpack_sockaddr_in($stuff); 8   $we_are = gethostbyaddr($bar, AF_INET) unless $we_are;  B   # Talk to the server. First fetch the initial 'hi there' message   $they_said = <MAILSOCK>;   
   # Say hiC   syswrite(MAILOUTSOCK, "HELO $we_are\cM\cJ", length($we_are) + 7);       # Wait for them to say hi back   $they_said = <MAILSOCK>;   # Make sure we like it(   if (substr($they_said, 0, 1) ne '2') {     # not a 2 response. Bail     close(MAILSOCK);(     die "server said $they_said (why?)";   }      # Tell it who the mail's from F   syswrite(MAILOUTSOCK, "MAIL FROM: $from\cM\cJ", length($from) + 13);     # was it OK?   $they_said = <MAILSOCK>;   chomp $they_said;    # Make sure we like it(   if (substr($they_said, 0, 1) ne '2') {+     # not a 2 response. Bail, but not badly      close(MAILSOCK);(     die "server said $they_said (why?)";   }      # Tell 'em who it's going to$   foreach my $recipient (@$to_ref) {!     # Tell it who the mail's from P     syswrite(MAILOUTSOCK, "RCPT TO: $recipient\cM\cJ", length($recipient) + 11);          # was it OK?     $they_said = <MAILSOCK>;     chomp $they_said;      # Make sure we like it*     if (substr($they_said, 0, 1) ne '2') {-       # not a 2 response. Bail, but not badly        close(MAILSOCK);*       die "server said $they_said (why?)";     }    }       # Time for the message)   syswrite(MAILOUTSOCK, "DATA\cM\cJ", 6);       # was it OK?   $they_said = <MAILSOCK>;   chomp $they_said;    # Make sure we like itN   if ((substr($they_said, 0, 1) ne '2')&& (substr($they_said, 0, 1) ne '3')) {+     # not a 2 response. Bail, but not badly      close(MAILSOCK);(     die "server said $they_said (why?)";   }    G   # Send the message. If a line's got just a period, then send a double E   # period. (SMTP protocol dictates that a message ends with a single ;   # period, and we don't want it ending before we're ready) $   foreach my $line (@$message_ref) {     if ($line eq '.') { +       syswrite(MAILOUTSOCK, "..\cM\cJ", 4);      } else {<       syswrite(MAILOUTSOCK, "$line\cM\cJ", length($line)+2);     }    }      !   # 'Kay, send the closing period &   syswrite(MAILOUTSOCK, ".\cM\cj", 3);   # Did they like the mail?    $they_said = <MAILSOCK>;   chomp $they_said;    # Make sure we like it(   if (substr($they_said, 0, 1) ne '2') {+     # not a 2 response. Bail, but not badly      close(MAILSOCK);(     die "server said $they_said (why?)";   }       # Go away )   syswrite(MAILOUTSOCK, "QUIT\cM\cJ", 6);    close MAILSOCK;    close MAILOUTSOCK;   return 1;  }   