                            xT $      UCX042.B                                                                                                                                                                                                     p               UCX042.B  BACKUP/NOASSIST/COMMENT=VAX/VMS SPKITBLD Procedure/INTER/LOG/VERIFY KITB$:*.* DISK$UCX_BUILD2:[UCX.X42.BL21.PLAT_V.VMS_V55.KIT]UCX042.B/LABEL=(UCX)/SAVE/BLOCK=9000/GROUP=25/NOINIT/NOREWI  VAX/VMS SPKITBLD Procedure  WRIGHT            aLw؛      V5.5 	 _MOOSE:: 
    _SQUIRL$DKB400:  V5.5-2 
  $                                     B * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]BUILD_UCX_SECURITY_DRIVER.COM;1 +  , b   .     / #   4 @       B                    - P    0   1    2   3      K  P   W   O     5   6 !FP'  7 u؛  8          9          G    H  J                              $ !  $ ! Assemble SCDRIVER  $ ! & $ if f$getsyi("arch_name") .EQS. "VAX"@ $ then macro /LIS=ucx_security_driver /OBJ=ucx_security_driver - 	ucx_security_driver: $	link_suffix = ", SYS$SYSTEM:SYS.STB/SELECTIVE /SYSTEM=0"@ $ else	macro /LIS=ucx_security_driver /OBJ=ucx_security_driver -  	sys$input + ucx_security_driver   BUILD_PLATFORM$ALPHA = 1# $	link_suffix = "/SYSEXE=SELECTIVE"  $ endif  $ !  $ ! Link SCDRIVER  $ !  $ driver = "scdriver" 9 $ LINK /EXE='driver' /HEADER /MAP='driver' /FULL /CROSS - 4 	/SYMBOLS='driver' ucx_security_driver 'link_suffix' $exit                                                                                                                                                                                                                                                                                                                                                                                                                                                                            3 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_METHOD.C;1 +  , c   .     / #   4 n                           - P    0   1    2   3      K  P   W   O     5   6 Uga'͙  7 au؛  8          9          G    H  J                            /*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: chess_method.c,v $
 * Revision 1.1.2.5  1995/10/25  13:47:51  Michael_Daniele
 * 	Pass 6 not 0 as value of 'generic' arg to esnmp_trap().
 * 	[1995/10/25  13:45:29  Michael_Daniele]
 *
 * Revision 1.1.2.4  1995/06/30  17:00:50  David_Keeney
 * 	Fix compile warning on type passed to bzero, line 310.
 * 	[1995/06/30  14:35:46  David_Keeney]
 * 
 * 	Cleaned up GETNEXT's
 * 	[1995/04/25  22:50:32  David_Keeney]
 * 
 * 	Initial Checkin
 * 	[1995/04/24  15:58:15  David_Keeney]
 * 
 * Revision 1.1.2.3  1995/06/29  19:33:26  Michael_Daniele
 * 	Cleaned up comments.
 * 	[1995/06/27  17:35:19  Michael_Daniele]
 * 
 * Revision 1.1.2.2  1995/04/26  16:01:22  David_Keeney
 * 	Cleaned up GETNEXT's
 * 	[1995/04/25  22:50:32  David_Keeney]
 * 
 * 	Initial Checkin
 * 	[1995/04/24  15:58:15  David_Keeney]
 * 
 * $EndLog$
 */
/* #pragma ident "@(#)$RCSfile: chess_method.c,v $ $Revision: 1.1.2.5 $ (DEC) $Date: 1995/10/25 13:47:51 $" */
/*
 ************************************************************************
 *                                                                      *
 *  The method routines and internal support code for the Digital UNIX  *
 *  eSNMP example sub-agent.						*
 *									*
 *	Author: Mike Daniele						*
 *	Date:	April, 1995						*
 *									*
 *  The chess MIB represents a repository of chess games.  		*
 *  A game is simply a collection of moves.				*
 *  A move is an ascii string containing algebraic or descriptive	*
 *  chess notation.							*
 *									*
 *  This program does not 'play' chess, it simply provides SNMP access	*
 *  to a database of chess moves, organized into games.			*
 *									*
 *  The MIB is structured as follows:					*
 *									*
 *  General Information:						*
 *	chessProductID	- the objectID of this software			*
 *	chessMaxGames	- max number of games we'll maintain		*
 *	chessNumGames	- current number of games we have		*
 *									*
 *  GameTable		- each game is represented as an entry		*
 *	gameIndex	- unique identifier of this game		*
 *	gameDescr	- description (players, date, tournament, etc)	*
 *	gameNumMoves	- number of moves in this game so far		*
 *	gameStatus	- one of { complete, underway, delete }		*
 *									*
 *  MoveTable		- each move pair (white/black) of each game is	*
 *			  an entry, indexed by {gameIndex, moveIndex}	*
 *	moveIndex	- id of move within a game			*
 *	moveByWhite	- white player's move				*
 *	moveByBlack	- black player's move				*
 *									*
 *  SNMP applications may retrieve any MIB object.			*
 *  SNMP applications may create or delete gameEntries using Sets.	*
 *  SNMP applications may add moves or delete the last move from an	*
 *  an existing game using Sets.					*
 *									*
 *  Traps are sent whenever a good move is accessed.			*
 *									*
 ************************************************************************
 */

#include <errno.h>
#include "esnmp.h"		/* eSNMP definitions and prototypes */
#include "chess_tbl.h"		/* chess subtree object table */

#define  bzero(target, length)           memset ((target), 0, (length))

/************************************************************************
 |  Internal data structures.
 ************************************************************************/

#define MOVE_SIZE 	16
#define DESCR_SIZE 	64
#define	MAX_MOVES 	1024	
#define MAX_GAMES	10 

typedef struct _move {
    struct _move  *next;
    struct _move  *prev;
    unsigned char w[MOVE_SIZE];	/* white move */
    unsigned char b[MOVE_SIZE];	/* black move */
    int	     	  index;	/* Move number */
    int		  sts;		/* In use/free */
} Move;


typedef struct _game {
    Move *moves;			/* ptr to linked list of move structures */
    Move *lastmove;			/* ptr to last on linked list */
    unsigned char descr[DESCR_SIZE];	/* description */
    int  nummoves;			/* current number of moves */
    int  index;				/* its gameIndex */
    int  sts;				/* current status */
} Game;


/************************************************************************
 |  Data declarations.
 ************************************************************************/

/*
 *  We have a static table of available moves.  
 *  and one for available games.  Each game vies
 *  for move resources with the others.
 */
#define NULL 0L

Move move_tbl[MAX_MOVES] = { 	/* Load our default games */

/* Byrne-Fischer, US Championship 1963 */

{ NULL, NULL, "1. d4",        "1...Nf6", 1, 1},
{ NULL, NULL, "2. c4",        "2...g6", 2, 1},
{ NULL, NULL, "3. g3",        "3...c6", 3, 1},
{ NULL, NULL, "4. Bg2",       "4...d5", 4, 1},
{ NULL, NULL, "5. cd",        "5...cd", 5, 1},
{ NULL, NULL, "6. Nc3",       "6...Bg7", 6, 1},
{ NULL, NULL, "7. e3",        "7...O-O", 7, 1},
{ NULL, NULL, "8. Nge2",      "8...Nc6", 8, 1},
{ NULL, NULL, "9. O-O",       "9...b6", 9, 1},
{ NULL, NULL, "10. b3",       "10...Ba6", 10, 1},
{ NULL, NULL, "11. Ba3",      "11...Re8", 11, 1},
{ NULL, NULL, "12. Qd2",      "12...e5", 12, 1},
{ NULL, NULL, "13. de",       "13...Ne5", 13, 1},
{ NULL, NULL, "14. fRd1?",    "14...Nd3!", 14, 1},
{ NULL, NULL, "15. Qc2",      "15...Nxf2!", 15, 1},
{ NULL, NULL, "16. Kxf2",     "16...Ng4+", 16, 1},
{ NULL, NULL, "17. Kg1",      "17...Nxe3", 17, 1},
{ NULL, NULL, "18. Qd2",      "18...Nxg2!", 18, 1},
{ NULL, NULL, "19. Kxg2",     "19...d4!", 19, 1},
{ NULL, NULL, "20. Nxd4",     "20...Bb7+", 20, 1},
{ NULL, NULL, "21. Kf1",      "21...Qd7!", 21, 1},
{ NULL, NULL, "resigns",      "0-1", 22, 1},

/* Anderssen - Lange, Breslau 1859 */

{ NULL, NULL, "1. e4",		"1...e5", 1, 1},
{ NULL, NULL, "2. Nf3",		"2...Nc6", 2, 1},
{ NULL, NULL, "3. Bb5",		"3...Nd4", 3, 1},
{ NULL, NULL, "4. Nxd4",	"4...exd4", 4, 1},
{ NULL, NULL, "5. Bc4",		"5...Nf6", 5, 1},
{ NULL, NULL, "6. e5",		"6...d5", 6, 1},
{ NULL, NULL, "7. Bb3",		"7...Bg4", 7, 1},
{ NULL, NULL, "8. f3",		"8...Ne4", 8, 1},
{ NULL, NULL, "9. O-O",		"9...d3!", 9, 1},
{ NULL, NULL, "10. fxg4",	"10...Bc5+", 10, 1},
{ NULL, NULL, "11. Kh1",	"11...Ng3+!", 11, 1},
{ NULL, NULL, "12. hxg3",	"12...Qg5!", 12, 1},
{ NULL, NULL, "13. Rf5",	"13...h5!", 13, 1},
{ NULL, NULL, "14. gh",		"14...Qxf5", 14, 1},
{ NULL, NULL, "15. g4",		"15...Rxh5+!!", 15, 1},
{ NULL, NULL, "16. gxh5",	"16...Qe4!", 16, 1},
{ NULL, NULL, "17. Qf3",	"17...Qh4+", 17, 1},
{ NULL, NULL, "18. Qh3",	"18...Qe1+", 18, 1},
{ NULL, NULL, "resigns",	"0-1", 19, 1},

/* Stienitz - Von Bardeleben, Hastings 1895 */

{ NULL, NULL, "1. e4",        	"1...e5", 1, 1},
{ NULL, NULL, "2. Nf3",		"2...Nc6", 2, 1},
{ NULL, NULL, "3. Bc4",		"3...Bc5", 3, 1},
{ NULL, NULL, "4. c3",		"4...Nf6", 4, 1},
{ NULL, NULL, "5. d4",		"5...ed", 5, 1},
{ NULL, N                                                                                                                                                                                                                                                                                                           &L $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_METHOD.C;1                                                                            n                               "            ULL, "6. cd",		"6...Bb4+", 6, 1},
{ NULL, NULL, "7. Nc3",		"7...d5", 7, 1},
{ NULL, NULL, "8. ed",		"8...Nxd5", 8, 1},
{ NULL, NULL, "9. O-O",		"9...Be6", 9, 1},
{ NULL, NULL, "10. Bg5",	"10...Be7", 10, 1},
{ NULL, NULL, "11. Bxd5",	"11...Bxd5", 11, 1},
{ NULL, NULL, "12. Nxd5",	"12...Qxd5", 12, 1},
{ NULL, NULL, "13. Bxe7",	"13...Nxe7", 13, 1},
{ NULL, NULL, "14. Re1",	"14...f6", 14, 1},
{ NULL, NULL, "15. Qe2",	"15...Qd7", 15, 1},
{ NULL, NULL, "16. aRc1",	"16...c6?", 16, 1},
{ NULL, NULL, "17. d5!!",	"17...cd", 17, 1},
{ NULL, NULL, "18. Nd4",	"18...Kf7", 18, 1},
{ NULL, NULL, "19. Ne6",	"19...hRc8", 19, 1},
{ NULL, NULL, "20. Qg4!",	"20...g6", 20, 1},
{ NULL, NULL, "21. Ng5+",	"21...Ke8", 21, 1},
{ NULL, NULL, "22. Rxe7+!",	"22...Kf8", 22, 1},
{ NULL, NULL, "23. Rf7+",	"23...Kg8", 23, 1},
{ NULL, NULL, "24. Rg7+!",	"24...Kh8", 24, 1},
{ NULL, NULL, "25. Rxh7+",	"25...resigns", 25, 1},
{ NULL, NULL, "1-0",		"1-0", 26, 1},

/* Daniele - LeBlanc Postal US 84VC110 */

{ NULL, NULL, "1. d4",        	"1...d5", 1, 1},
{ NULL, NULL, "2. c4",		"2...Nf6", 2, 1},
{ NULL, NULL, "3. Nc3",		"3...c6", 3, 1},
{ NULL, NULL, "4. Nf3",		"4...g6", 4, 1},
{ NULL, NULL, "5. Bf4",		"5...Bg7", 5, 1},
{ NULL, NULL, "6. h3",		"6...O-O", 6, 1},
{ NULL, NULL, "7. e3",		"7...dc", 7, 1},
{ NULL, NULL, "8. Bxc4",	"8...b5", 8, 1},
{ NULL, NULL, "9. Bd3",		"9...Nd5", 9, 1},
{ NULL, NULL, "10. Nxd5",	"10...cd", 10, 1},
{ NULL, NULL, "11. O-O",        "11...b4?", 11, 1},
{ NULL, NULL, "12. Qb3",	"12...Na6", 12, 1},
{ NULL, NULL, "13. fRc1",	"13...Bb7", 13, 1},
{ NULL, NULL, "14. Bxa6",	"14...Bxa6", 14, 1},
{ NULL, NULL, "15. Qxb4",	"15...e6", 15, 1},
{ NULL, NULL, "16. Rc6",	"16...Bd3", 16, 1},
{ NULL, NULL, "17. aRc1",	"17...a5", 17, 1},
{ NULL, NULL, "18. Qb7",	"18...a4", 18, 1},
{ NULL, NULL, "19. Bd6!",	"19...Re8", 19, 1},
{ NULL, NULL, "20. Ne5",	"20..Bxe5", 20, 1},
{ NULL, NULL, "21. de",        	"21...Bf5", 21, 1},
{ NULL, NULL, "22. Rc7!",       "22...Rb8", 22, 1},
{ NULL, NULL, "23. Qc6",        "23...Rxb2", 23, 1},
{ NULL, NULL, "24. Qxe8+!",     "24...Qxe8", 24, 1},
{ NULL, NULL, "25. Rc8",        "25...Qxc8", 25, 1},
{ NULL, NULL, "26. Rxc8+",      "26...Kg7", 26, 1},
{ NULL, NULL, "27. Bf8+",       "27...resigns", 27, 1},
{ NULL, NULL, "1-0",        	"1-0", 28, 1}

};

Game game_tbl[MAX_GAMES] = {

{ &move_tbl[0],  &move_tbl[21], "Byrne-Fischer, US Championship 1963",      22, 1, D_gameStatus_complete},
{ &move_tbl[22], &move_tbl[40], "Anderssen - Lange, Breslau 1859",          19, 2, D_gameStatus_complete},
{ &move_tbl[41], &move_tbl[66], "Stienitz - Von Bardeleben, Hastings 1895", 26, 3, D_gameStatus_complete},
{ &move_tbl[67], &move_tbl[94], "Daniele - LeBlanc, U.S. Postal 84VC110",   28, 4, D_gameStatus_complete}

};

static int num_games = 4;

/*
 *   For our productID we're using the one registered for digital Unix.
 */

static char *prod_oid_str = "1.3.6.1.3.4.36.2.15.2"; 
static unsigned int prod_id_elem[10] = { 1,3,6,1,3,4,36,2,15,2 };
static OID prod_oid = { 10, prod_id_elem };

/*
 *  Data for generating the goodMove! trap.
 */

static VARBIND	     trap_vb[2];
 

/*
 *  Because we'll need to access the emitted object table directly,
 *  pick it up here.
 */

static OBJECT *ot;


/*******************************************************************
 |
 |  Support Routines:
 |
 |  This section contains private functions used to support the
 |  method routines for the chess sub-agent.
 |
 |  chess_initialize()	- Called from main(), set up static data
 |			  (initial games & moves, trap VARBINDs, etc)
 |
 |  find_game()		- Handle SNMP lexicographical semantics and identify
 |			  a Game.
 |
 |  load_game()		- Copy the contents of a Game into a gameEntry_type.
 |
 |  find_move()		- Handle SNMP lex semantics and identify a Move. 
 |
 |  load_move()		- Copy the contents of a Move into a moveEntry_type.
 |
 |  gen_trap()		- Generate a goodMove! trap.
 |
 *******************************************************************/

/*******************************************************************
 |
 |  Finish initializing the game and move tables.
 |
 |  Initialize the list of VARBINDs for use later in generating 
 |  traps.
 |
 |  Point our OBJECT ptr to the subtree's object table.
 |  NOTE:  It is not (always) possible to do this as part of 
 |         declaration because the subtree itself is initialized in 
 |	   its declaration.) 
 |
 *******************************************************************/

int chess_initialize(void)
{
    int i;

	ot = chess_subtree.object_tbl;

	/* Fix up the next/prev ptrs in the move tbl. */
	for (i = 1; i < (22+19+26+28); i++)
	{
	    move_tbl[i].next = &move_tbl[i+1]; 
	    move_tbl[i].prev = &move_tbl[i-1]; 
	}
	move_tbl[0].next = &move_tbl[1];
	move_tbl[21].next = NULL;
	move_tbl[22].prev = NULL;
	move_tbl[40].next = NULL;
	move_tbl[41].prev = NULL;
	move_tbl[66].next = NULL;
	move_tbl[67].prev = NULL;
	move_tbl[94].next = NULL;

	bzero((char *)trap_vb, sizeof(trap_vb));
	trap_vb[0].next = &trap_vb[1];

	return(ESNMP_MTHD_noError);	
}


/*******************************************************************
 |
 |  Locate a game_tbl element based on the passed index and 
 |  request type.
 |
 |  This routine implements the SNMP Get and GetNext/Bulk search
 |  semantics.  For ESNMP_ACT_GET we need to find an entry whose
 |  index is = to the requested index.  For GET_NEXT/BULK we need
 |  to find the entry with the lowest index greater than the
 |  requested index.  The table entries are initialized in ascending
 |  order of indexes, but are not guaranteed to stay that way.  So
 |  search the entire table.  Indexes are guaranteed to be between
 |  1 and MAX_GAMES inclusive.
 |
 |  (In our game_tbl array, and element of the array is valid
 |   if its sts field is non-0.) 
 |
 ******************************************************************/

static Game *find_game( int gi, int r )
{
    int i, j;
    unsigned int s = 0xffffffff;

	for (i = 0, j = -1; i < MAX_GAMES; i++)
	{
	   if (game_tbl[i].sts)
	   {
	      if (r == ESNMP_ACT_GET)
	      {
		 if (game_tbl[i].index == gi)
		    return(&game_tbl[i]);
	      }
	      else
		 if ((game_tbl[i].index > gi) && (game_tbl[i].index < s))
		 {
		    s = game_tbl[i].index;
		    j = i;
		 }
	   }
	}
	if (r == ESNMP_ACT_GET)
	   return(NULL);
	else
	   if (j != -1)
	      return(&game_tbl[j]);
	   else
	      return(NULL);
}


/*******************************************************************
 |
 |  Find an unused game tbl entry.
 |
 ******************************************************************/

static Game *find_game_slot()
{
    int i;

	for (i = 0; i < MAX_GAMES; i++)
	{
	   if (!game_tbl[i].sts)
	      return(&game_tbl[i]);
	}
	return(NULL);
}


/*******************************************************************
 |
 |  Copy a Game into a gameEntry_type.
 |
 |  NOTE: This routine does not allocate memory, it simply
 |	  points to the same memory used by the Game.
 |
 ******************************************************************/

static void load_game( gameEntry_type *ge, Game *g )
{
	ge->gameIndex     = g->index;
	ge->gameNumMoves  = g->nummoves;
	ge->gameStatus    = g->sts;
	ge->gameDescr.ptr = g->descr;
	ge->gameDescr.len = strlen(g->descr);
}


/*******************************************************************
 |
 |  Locate a move_tbl element based on the passed indexes and 
 |  request type.
 |
 |  This routine implements the SNMP Get and GetNext/Bulk search
 |  semantics.
 |
 |  The move table is indexed by the combination (gameIndex, moveIndex).
 |  So moveByWhite.2.23 means White's 23rd move in game 2.
 |
 |  For a successful GET action, both game and move index must match
 |  exactly.  
 |
 |  For NEXT/BULK, the logic is a bit more involved.  If requested for
 |  moveByWhite.g.m, we check (in this order) for:
 |
 |	g.n, where n is the smallest move in game g > m
 |
 |	h.l, where h is the smallest game number > g and l is
 |	the lowest move number in game h.
 |
 |  In a nutshell, if asked for game 2's 23 move, but it doesn't have
 |  23 moves, return the first move in game 3.  If there is no game
 |  3, return the first move of game 4, etc.  Fail only if there is
 |  no game (with moves) with a higher index than 2.
 |  
 |  We maintain the list of moves for a game in order of ascending
 |  moveIndex, so we only need to search a game's move lists until we
 |  have a hit.
 |
 ******************************************************************/

static Move *find_move( int gi, int mi, int r, Game **gp )
{
    int srch = mi;
    Game *g;
    Move *m;

	g = find_game(gi, ESNMP_ACT_GET);
	if (r == ESNMP_ACT_GET)
	{
	   if ((!g) || (g->nummoves < srch))
	      r                                                                                                                                                                                                                                                                           -j $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_METHOD.C;1                                                                            n                              WZ "            eturn(NULL);
	}
	else
	{
	   if ((!g) || (g->nummoves <= srch))
	   {
	      g = find_game(gi, r);
	      srch = 0;
	   }
	   if (!g)
	      return(NULL);
	   if (g->nummoves <= srch)
	      return(find_move(g->index+1, 0, r, gp));
	}

	for (m = g->moves; m; m = m->next)
	{
	   if (((r == ESNMP_ACT_GET) && (m->index == srch)) ||
	       ((r != ESNMP_ACT_GET) && (m->index > srch)))
	   {
	      *gp = g; 
	      return(m);
	   }
	}

	return(NULL);
}
 

/*******************************************************************
 |
 |  Copy a Move into a moveEntry_type.
 |
 |  NOTE: This routine does not allocate memory, it simply
 |	  points to the same memory used by the Move.
 |
 ******************************************************************/

static void load_move( moveEntry_type *me, Move *m, Game *g )
{
	   me->gameIndex       = g->index; 
	   me->moveIndex       = m->index;
	   me->moveByWhite.ptr = m->w;
	   me->moveByWhite.len = strlen(m->w);
	   me->moveByBlack.ptr = m->b;
	   me->moveByBlack.len = strlen(m->b);
}


/*******************************************************************
 |
 |  Find an unused move tbl entry.  (A free entry has sts == 0). 
 |
 ******************************************************************/

static Move *find_move_slot()
{
    int i;

	for (i = 0; i < MAX_MOVES; i++)
	{
	   if (!move_tbl[i].sts)
	      return(&move_tbl[i]);
	}
	return(NULL);
}


/*******************************************************************
 |
 |  Reclaim the move tbl entries that are currently being used
 |  by a game tbl entry.  We are passed the head of the move 
 |  list.  Just walk the list and clear the front & back ptrs,
 |  and set sts to 0.
 |
 ******************************************************************/

static void reclaim_move_slots( Move *head )
{
    Move *m = head, *f;

	while(m)
	{
	   f = m->next;
	   m->prev = m->next = NULL;
	   m->sts = 0;
	   m = f;
	}
}


/*******************************************************************
 |
 |  Add a move to a game.  We're passed the Move and Game ptrs.
 |  We assume the Move already has its string data intact, and
 |  simply needs to be inserted at the end of the move list
 |  for this Game.
 |
 ******************************************************************/

static void add_move( Move *m, Game *g )
{
	m->prev = g->lastmove;
	m->next = NULL;
	m->index = ++(g->nummoves);
	m->sts = 1;
	if (g->lastmove)
	   g->lastmove->next = m;
	g->lastmove = m;
	if (!g->moves)
	   g->moves = m;
}


/*******************************************************************
 |
 |  Remove the Move at the end of a Game's move list.
 |  Adjust ptrs only.  In particular, don't clear the string
 |  data.  (It wasn't malloc-ed to begin with, and this permits
 |  easy "UNDOs".  Clear both move ptrs, effectively putting this
 |  Move back on the 'free list'.
 |
 ******************************************************************/

static void kill_move( Game *g )
{
    Move *m;

	if (g->lastmove)
	{
	   m = g->lastmove->prev;
	   if (m)
	      m->next = NULL;
	   g->lastmove->prev = g->lastmove->next = NULL;
	   g->lastmove->sts = 0;
	   if (g->moves == g->lastmove)
	      g->moves = m;
	   g->lastmove = m;
	   --(g->nummoves);
	}
}


/*******************************************************************
 |
 |  Generate the goodMove! trap.
 |  A trap is generated by calling esnmp_trap(generic, specific, vb_list, sysoid).
 |  where:
 |	generic - an integer representing an architected trap type
 |	specific - an integer representing an implementation-specific trap type
 |	vb_list - a linked list of VARBINDs containing data to be included in the
 |	          trap
 |	sysoid - An OID representing the sysObjectID of the sending entity
 |	 	 (If NULL, the value of MIB-II sysObjectID will be used.)
 |
 |  eSNMP expects the correct vb_list when generic != 0, otherwise you can
 |  do whatever you want.  (coldStart, linkdown, etc are generic traps).
 | 
 |  Of course, for a trap receiver program to correctly interpret what you
 |  send, there must exist a MIB specifying these details, and you must do
 |  it correctly.  But eSNMP has no knowledge of those details.
 |
 |  NOTE that when sending enterprise-specific traps, you should specify
 |  	 a value of 6 for 'generic'.  This is the architected SNMP value
 |	 for enterprise-specific (as opposed to coldStart, etc).
 |
 |  Our goodMove trap will contain 2 VarBinds, the value of gameDescr, and
 |  the value of moveByWhite/Black.  We set up the fields in the VarBinds
 |  by using the o_xxx routines to load data, just like usual.  What's
 |  slightly different is that there is no OID at all in these varbinds
 |  (whereas the one in the method struct always has the base oid of the
 |  object pre-loaded).  So we first have to copy the base oid from the
 |  object table. 
 |
 |  NOTE WELL: When we load data into a METHOD's varbind, libesnmp handles virtual memory.
 |	       When we load data into our private varbinds, we have to handle 
 |	       memory ourselves.
 |
 |	       The libesnmp routine free_varbind_data is useful for this.
 |	       It will 
 |		 free the VARBIND.name (free data pointed to by name.ptr, 
 |				        set name.length to 0)
 |		 clear the VARBIND.octet/oid (free data pointed to by ptr and 
 |	         set appropriate len/size t 0) if the VARBIND.type field indicates
 |
 |	       and that's all.  It does not alter any other VARBIND field, nor
 |	       does it free the VARBIND itself. 
 |
 *******************************************************************/
static void gen_trap( OBJECT *moveobj,
	       unsigned char *movedata, 
	       OBJECT *gameobj, 
	       unsigned char *gamedata)
{


	o_string(&trap_vb[1], moveobj, movedata, strlen(movedata));
	clone_oid(&trap_vb[0].name, &ot[I_gameDescr].oid);

	o_string(&trap_vb[0], gameobj, gamedata, strlen(gamedata));
	clone_oid(&trap_vb[1].name, &moveobj->oid);

	esnmp_trap(6, 1, prod_oid_str, trap_vb);     
	free_varbind_data(&trap_vb[0]);
	free_varbind_data(&trap_vb[1]);
}



/*******************************************************************
 |
 |  Method Routines:
 |
 |  This section contains the method routines for the 3 groups
 |  within the chess MIB.  These functions are pointed to by 
 |  elements of the object table defined in chess_tbl.c, and are
 |  called by the libesnmp dispatcher to process SNMP requests
 |  for MIB variables.
 |
 |  <foo>_get functions handle Get, GetNext, and GetBulk operations.
 |  <foo>_set functions handle Set, Commit, Undo, and Cleanup.
 |
 |  chess_get	- The general chess group.
 |
 |  gameEntry_get/set - The game table.
 |
 |  moveEntry_get/set - The move table.
 | 
 *******************************************************************/

/*******************************************************************
 |  SNMP Versions: 
 |
 |  The eSNMP method routine API is based on SNMPv2.  All SNMPv2
 |  datatypes, protocol data units, and error codes are supported
 |  in the API.
 |
 |  The eSNMP error code definitions reflect architected SNMPv2 error
 |  codes.  (The actual values are not identical, the master agent
 |  maps appropriately). 
 |
 |  The eSNMP master-agent is bilingual, meaning it accepts either
 |  v1 or v2 requests.  It maps returned v2 error codes into the
 |  appropriate v1 code.  On a v1 request, the libesnmp code
 |  running in the sub-agents will ignore object table entries
 |  whose datatype is only supported in SNMPv2 (64 bit counters, for instance).
 |
 *******************************************************************/

/*******************************************************************
 |
 |  GET, GETNEXT, GETBULK:
 |
 |  The "Get" method routine handles these three action codes.
 |  The function should either
 |
 |	o update the VARBIND's oid and data fields, and return noError
 |
 |	o return the correct SNMP error code
 |
 |  On a GetRequest (ESNMP_ACT_GET), the possible error codes are:
 |
 |  noSuchObject -	libesnmp returns this when the requested variable binding
 |			does not match an entry in the object table.
 |
 |  noSuchInstance -	method routine returns this when the requested instance is
 |			not available or does not exist.
 |
 |  genErr -		method routine returns this when a general processing
 |			error occurs (e.g., out of memory)
 |
 |  On a GetNextRequest (ESNMP_ACT_GETNEXT) or GetBulkRequest (ESNMP_ACT_GETBULK)
 |  the possible error codes are:
 |
 |  noSuchInstance -	method routine returns this when the lexicographical successor to
 |			the requested instance is not available or does not exist.
 | 
 |  When this happens libesnmp calls method routines for subsequent objects in the
 |  table.  If the table is exhausted li                                                                                                                                                                                                                                                                           hr $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_METHOD.C;1                                                                            n                              V "     0       besnmp will return the v2 exception
 |  endOfMibView.
 |
 |  genErr -		method routine returns this when a general processing
 |			error occurs (e.g., out of memory)
 |
 *******************************************************************/



/*******************************************************************
 |
 |  The GET method routine for the (general) chess group.
 |
 |  Since this group has only 3 simple scalar variables,
 |  we've decided not to use the chess_type data structure.
 |  We just use the static (or constant) data as is.
 |
 |  On a GET, the only valid instance is '0'.
 |
 |  On GETNEXT/GETBULK, there is no valid instance, so we can only
 |  return successfully if instance length == 0.  (If the requested
 |  object is Foo, and all we have is Foo.0, a GETNEXT for Foo.anything
 |  must be failed.)
 |
 |  Note the assumption here that the libesnmp code 'promotes' a
 |  requested object to the subtree's first object, if the requested
 |  object lexi-preceeded it.  For instance, if this MIB is the
 |  lexi first one in the master's registry, and this request arrives:
 |
 |    GetNext{ 0.0 }
 |
 |  we will be called here with incoming == chessProductID, not 0.0.
 | 
 *******************************************************************/

int chess_get( METHOD *method )
{
    VARBIND      *vb       = method->varbind; 
    OID          *incoming = &method->varbind->name;
    OBJECT       *object   = method->object;
    int          arg       = object->object_index;
    int          instlen;
    unsigned int inst;


	/*
	 *  Step 1, validate the requested object instance.
	 */
	instlen = oid2instance(incoming, object, &inst, 1);
	if (method->action == ESNMP_ACT_GET)
	{
	   if ((instlen != 1) || (inst))
	      return(ESNMP_MTHD_noSuchInstance);
	}
	else
	{
	   if (instlen)
	      return(ESNMP_MTHD_noSuchInstance);
	}


	/*
	 *  Step 2, copy the correct instance back into the method's
	 *  variable binding's name.
	 *  We do this now because we know we can return data, and
	 *  we know the only instance we can return is '0'.
	 */
	inst = 0;
	instance2oid(&vb->name, object, &inst, 1);


	/*
	 *  Step 3, find the data (which variable in the chess group 
	 *  is arg indicating?)
	 *
	 *  Then load the proper data into the method's varbind.
	 *  This is done by calling the libesnmp o_xxx routine corresponding
	 *  to the raw data we have.
	 */
	switch(arg)
	{
	   case I_chessProductID:
	      return(o_oid(vb, object, &prod_oid));

	   case I_chessMaxGames:
	      return(o_integer(vb, object, MAX_GAMES));

	   case I_chessNumGames:
	      return(o_integer(vb, object, num_games));

	   default:
	      return(ESNMP_MTHD_noSuchObject);
	}
}



/*******************************************************************
 |
 |  The GET method routine for the gameEntry group.
 |
 |  gameEntries are indexed by a single integer, gameIndex.
 |  So for GET, a valid instance must be of length 1, and exactly
 |  match the index of a game in the game_tbl.  
 |
 |  For GETNEXT/BULK, the instance can be longer than 1, but we
 |  return the game whose index is larger than the first instance
 |  integer.
 |  For example, if the request is GetNext{ gameDescr.2 }, or
 |  GetNext{ gameDescr.2.3.4 }, in both cases we should return
 |  gameDescr for the game with the smallest value of gameIndex that
 |  is larger than 2.
 |
 |  For NEXT/BULK, the instance can be null, in which case we search
 |  for the gameEntry with the smallest index > 0 (since SNMP table
 |  indexes start @ 1).
 | 
 |  For this group we keep a static structure around (that was defined
 |  by the MIB compiler).  This 'cached' data is loaded whenever a request
 |  arrives for something different than what's currently cached.
 |  If we have a cache hit, we load the method->varbind directly from
 |  the cache.
 |
 |  (Since our data is just hanging around in local memory, this really
 |   doesn't buy us much.  But other sub-agents might find this a very
 |   useful optimization.)
 |
 |  NOTE that when you do data caching in a method routine, you need to
 | 	 check that BOTH serial number AND instance match.
 |
 |  method->serial_num is unique during the processing of any request.
 |  That is, new requests always cause serial_num to increment.  But even
 |  within the same SNMP request, 2 objects in your MIB could have been
 |  requested with different instance information, for example
 |
 |    GetRequest{ gameNumMoves.1, gameDescr.2 }
 |
 |  so you need to check instance information as well as serial_num.
 |
 |  This type of caching is useful whenever your sub-agent fetches 'rows'
 |  of data at a time.
 | 
 *******************************************************************/

int gameEntry_get( METHOD *method )
{


        VARBIND      *vb       = method->varbind;
        OID          *incoming = &method->varbind->name;
        OBJECT       *object   = method->object;
        int          arg       = object->object_index;
	Game	     *g;
        int          instlen;
        unsigned int inst;

	static gameEntry_type cache_entry = {0, {0, NULL}, 0, 0};
	static int	      cache_serial_num = 0;

	/*
	 *  Step 1, validate/set up the instance.
	 */
	instlen = oid2instance(incoming, object, &inst, 1);
	if (method->action == ESNMP_ACT_GET)
	{
	   if (instlen != 1)
	      return(ESNMP_MTHD_noSuchInstance);
	}
	else
	   if (instlen <= 0)
	      inst = 0;


	/*
	 *  Step 2, find the correct gameEntry.
	 */
	g = find_game(inst, method->action);
	if (!g)
	   return(ESNMP_MTHD_noSuchInstance);


	/*
	 *  Can we use the cached gameEntry_type structure?
	 *  If not, reload the cache.
	 */
	if ((cache_serial_num != method->serial_num) || (cache_entry.gameIndex != g->index)) 
	{
	   cache_serial_num = method->serial_num;
	   load_game(&cache_entry, g);
	}


	/*
	 *  Step 3, load the instance back into the method's varbind.
	 */
	inst = cache_entry.gameIndex;
	instance2oid(&vb->name, object, &inst, 1);


	/*
	 *  Step 4, load the data into the method's varbind,
	 *  and return the correct status value.
	 */
	switch(arg)
	{
	   case I_gameIndex:
	      return(o_integer(vb, object, cache_entry.gameIndex));

	   case I_gameNumMoves:
	      return(o_integer(vb, object, cache_entry.gameNumMoves));

	   case I_gameStatus:
	      return(o_integer(vb, object, cache_entry.gameStatus));

	   case I_gameDescr:
	      return(o_octet(vb, object, &cache_entry.gameDescr));

	   default:
	      return(ESNMP_MTHD_noSuchObject);
	}	
}


/***********************************************************************
 |									
 |  The GET method routine for the moveEntry group.
 |
 |  This also uses a cached data structure emitted by the MIB compiler.
 |
 |  The semantics for accessing this table (which is indexed by 2 integers)
 |  is implemented in the function find_move().
 |
 |  Note how gameIndex is included in the moveEntry_type data structure.
 |  This is so that all information required by the method routine is in
 |  1 place.  gameIndex is not a variable in the moveEntry group, so it's
 |  value is not loaded back into the method->varbind using an o_xxx routine.
 |  But gameIndex IS used to index the table, so it's value is used in 
 |  the inst[] array, and gets loaded back into method->varbind->name.
 |
 |  When we validate the instance, we now need to check for a length of 2
 |  for GET.  NEXT/BULK may once again permit an instance of any length.
 |  If we don't get enough information in the passed instance OID we
 |  make up 0's.
 |
 ***********************************************************************/

int moveEntry_get( METHOD *method )
{
        VARBIND      *vb       = method->varbind;
        OID          *incoming = &method->varbind->name;
        OBJECT       *object   = method->object;
        int          arg       = object->object_index;
        int          instlen, i;
        unsigned int inst[2];
	Move	     *m;
	Game	     *g;

	static moveEntry_type cache_entry = { 0, {0,NULL}, {0,NULL} };
	static int	      cache_serial_num = 0;


	/*
	 *  Step 1, do initial validation/set up of the instance.
	 */
	instlen = oid2instance(incoming, object, inst, 2);
	if (method->action == ESNMP_ACT_GET)
	{
	   if (instlen != 2)
	      return(ESNMP_MTHD_noSuchInstance);
	}
	else
	{
	   if (instlen < 2)
	      inst[1] = 0;
	   if (instlen < 1)
	      inst[0] = 0;
	}

	/*
	 *  Step 2, find the correct moveEntry.
	 */
	m = find_move(inst[0], inst[1], method->action, &g);
	if (!m)
	   return(ESNMP_MTHD_noSuchInstance);

	/*
	 *  Can we use the cached moveEntry_type structure?
	 *  If not, reload the cache.
	 */
	if ((cache_serial_num != method->serial_num) || 
	    (cache_entry.gameIndex != g->index) || 
	    (cache_entry.moveIndex != m->                                                                                                                                                                                                                                                                           A
 $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_METHOD.C;1                                                                            n                               "     A       index)) 
	{
	   cache_serial_num = method->serial_num;
	   load_move(&cache_entry, m, g);
	}

	/*
	 *  Step 3, load the instance back into the method's varbind.
	 */
	inst[0] = cache_entry.gameIndex;
	inst[1] = cache_entry.moveIndex;
	instance2oid(&vb->name, object, inst, 2);


	/*
	 *  Step 4, if the variable we're returning is moveByWhite/Black,
	 *  check if it's a good move.  In standard chess notation, a good
	 *  move is usually indicated by appending 1 or more exclamation points.
	 *  (For instance, Frank Marshall once played 23 ... Q-KN6!!!.)
	 *  So we simply scan for a '!' character.
	 *
	 *  If we determine this is a good move, generate a goodMove trap.
	 *
	 *  Step 5, load the data back into the method->varbind and
	 *  return the correct status.
	 */
	switch(arg)
	{
	   case I_moveIndex:
	      return(o_integer(vb, object, cache_entry.moveIndex));

	   case I_moveByWhite:
	      if (strstr(cache_entry.moveByWhite.ptr, "!"))
		 gen_trap(object, 
			  cache_entry.moveByWhite.ptr, 
			  &ot[I_gameDescr], 
			  g->descr);
	      return(o_octet(vb, object, &cache_entry.moveByWhite));

	   case I_moveByBlack:
	      if (strstr(cache_entry.moveByBlack.ptr, "!"))
		 gen_trap(object, 
			  cache_entry.moveByBlack.ptr, 
			  &ot[I_gameDescr], 
			  g->descr);
	      return(o_octet(vb, object, &cache_entry.moveByBlack));

	   case I_moveStatus:
	      return(o_integer(vb, object, D_moveStatus_ok));

	   default:
	      return(ESNMP_MTHD_noSuchObject);
	}	
}


/***********************************************************************
 |									
 |  Setting SNMP variables:
 |
 |  SNMP SetRequest PDUs may contain a number of variable bindings.
 |  Each variable binding is a MIB variable and its bound data value.
 |  The MIB variables may or may not belong to the same MIB group.
 |  Those that belong to the same group may or may not contain the
 |  same instance OIDs.  For example:
 |
 |  SetRequest{ sysDescr.0 = "foo", ifAdminStatus.1 = up, ifAdminStatus.2 = down }  
 |
 |  It is typical for Set PDUs to specify MIB variables that share a group
 |  and instance OIDs.  For example:
 |
 |  SetRequest{ moveByWhite.4.5 = "5. Bg2", moveByBlack.4.5 = "5 ...c6" } 
 |
 |  In such cases it is often necessary to determine if the variable bindings
 |  "make sense together".  
 |
 |  The SNMP specifies that Sets be implemented atomically.  That is, either
 |  all requested variable bindings are set, or none are set.  For this reason,
 |  agent code typically contains "set" processing and "undo" processing.  In
 |  the "set" phase one tries to set all variable bindings.  If any were unsuccessful 
 |  the "undo" phase begins, in which one tries to replace the original values of
 |  any MIB variables that were previously set as a result of this SetRequest.
 |
 |  In distributed (extensible) SNMP agents, the problem is compounded by the fact
 |  that multiple sub-agents may be involved in processing the request.
 |
 |  For these reasons our method routines for Sets need to handle these 4
 |  values of method->action:
 |
 |  ESNMP_ACT_SET    -  Test the validity of the variable binding (do you support
 |		        setting the object?  does the instance make sense?  does the
 |		        value make sense?  Are all required variable bindings present?)
 |  ESNMP_ACT_COMMIT -  All the variable bindings have passed the SET phase, so
 |		        actually set the value of the MIB variable.
 |  ESNMP_ACT_UNDO   -  An error was reported during the COMMIT phase.  Undo
 |		        the set you just performed.
 |  ESNMP_ACT_CLEANUP - Your notification that this request is done.  (Free any 
 |			resources you allocated while processing this request.)
 |
 |  Overall processing is as follows:
 | 
 |  Every variable binding is parsed and its object (in the object table)
 |  is located.  A METHOD is created for each object.  These METHODs point
 |  to a ROW_CONTEXT structure, which is useful for handling these phases.
 |  Objects in the same conceptual row all point to the same ROW_CONTEXT.
 |  This determination is made by checking that
 |
 |	the referenced objects are in the same MIB group
 |	the varbind's have the same instance OIDs
 | 
 |  Each ROW_CONTEXT is loaded with the instance information for that
 |  conceptual row.  The ROW_CONTEXT context & save fields are NULLed, 
 |  and the state field is set to ESNMP_SET_UNKNOWN.
 |
 |  The method routine for each object is called, being passed its
 |  METHOD structure with an action code of ESNMP_ACT_SET.
 |  
 |  If all method routines return success, a SINGLE method routine
 |  (the last one called for the row) is called for each row, with
 |  method->action == ESNMP_ACT_COMMIT.
 |
 |  If any row reports failure, all rows that have been successfully committed
 |  are told to UNDO.  This is accomplished by calling a single method routine
 |  for each row (the same one that was called for COMMIT), with 
 |  method->action == ESNMP_ACT_UNDO.
 |
 |  Finally, each row is 'released'.  The same single method routine for
 |  each row is called with method->action == ESNMP_ACT_CLEANUP.  This
 |  occurs for every row, regardless of the results of previous processing.
 |
 |  ESNMP_ACT_SET:
 |
 |  Each object's method routine is called during the SET phase, until
 |  either all objects have been processed, or a method routine
 |  returns an error status value.  (This is the only phase during which 
 |  each object's method routine is called.)  For variable bindings in 
 |  the same conceptual row, method->row points to a common ROW_CONTEXT.
 |
 |  The method->flags bitmask will have the ESNMP_LAST_IN_ROW bit set if
 |  this is the last object being called for this ROW_CONTEXT.  This enables
 |  you to perform a final consistency check since you have seen every 
 |  variable binding for this conceptual row.
 |
 |  The method routine's job in this phase is to determine if the SetRequest
 |  will work, return the correct SNMP error code if not, and prepare any 
 |  context data it needs to actually perform the Set during the COMMIT phase.
 |
 |  SNMPv2 contains a wealth of possible error codes, intended to provide
 |  as much information as possible to the sending application.  SNMPv2
 |  also implies an order of operation when checking the various possible
 |  error conditions.  The following list describes the codes and conditions,
 |  and also shows the implied order.
 |
 |  noAccess:
 |	If the variable binding's name specifies an existing or non-         |
 |    	existent variable to which this request is/would be denied access,   |
 |    	then the value of the Response-PDU's error-status field is set to
 |    	`noAccess', and the value of its error-index field is set to the
 |    	index of the failed variable binding.
 |
 |  The master-agent detects this condition without disturbing the sub-agent.
 |
 | 	Otherwise, if there are no variables which share the same OBJECT     |
 |    	IDENTIFIER prefix as the variable binding's name, and which are      |
 |    	able to be created or modified no matter what new value is           |
 |    	specified, then the value of the Response-PDU's error-status field 
 |	is set to `notWritable', and the value of its error-index field 
 |	is set to the index of the failed variable binding.
 |
 |  libesnmp detects this if no matching table entry exists, or if one exists
 |  but has no Set method routine pointer (refer to the exclusion file).
 |  Method routines may also return this error when the implementation does
 |  not support Setting the variable.
 |
 |	Otherwise, if the variable binding's value field specifies,
 | 	according to the ASN.1 language, a type which is inconsistent with   |
 |	that required for all variables which share the same OBJECT          |
 |	IDENTIFIER prefix as the variable binding's name,                    |
 |	then the value of the Response-PDU's error-status field is set to
 |	`wrongType', and the value of its error-index field is set to the
 |	index of the failed variable binding.
 |
 |  libesnmp detects this condition (by matching the variable binding's type
 |  against that of the object table entry) without disturbing the method routine.
 |
 |	Otherwise, if the variable binding's value field specifies,
 |      according to the ASN.1 language, a length which is inconsistent      |
 |      with that required for all variables which share the same OBJECT     |
 |      IDENTIFIER prefix as the variable binding's name,                    |
 |      then the value of the Response-PDU's error-status field is set to
 |      `wrongLength', and the value of its error-index field is set to the
 |      index of the failed variable binding.
 |
 |  The method routine must detect thi                                                                                                                                                                                                                                                                           =	 $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_METHOD.C;1                                                                            n                              % "     R       s condition.
 |
 |	Otherwise, if the variable binding's value field contains an ASN.1
 |      encoding which is inconsistent with that field's ASN.1 tag, then
 |      the value of the Response-PDU's error-status field is set to
 |      `wrongEncoding', and the value of its error-index field is set to
 |      the index of the failed variable binding.  (Note that not all        |
 |      implementation strategies will generate this error.)                 |
 |
 |  The method routine must detect this condition.
 |
 |	Otherwise, if the variable binding's value field specifies a value
 |      which could under no circumstances be assigned to the variable,
 |      then the value of the Response-PDU's error-status field is set to
 |      `wrongValue', and the value of its error-index field is set to the
 |      index of the failed variable binding.
 |
 |  The method routine must detect this condition.
 |
 |	Otherwise, if the variable binding's name specifies a variable       +
 |      which does not exist and could not ever be created (even though      +
 |      some variables sharing the same OBJECT IDENTIFIER prefix might       +
 |      under some circumstances be able to be created), then the value of   +
 |      the Response-PDU's error-status field is set to `noCreation', and    +
 |      the value of its error-index field is set to the index of the        +
 |      failed variable binding.                                             +
 |
 |  The method routine must detect this condition.
 |
 |	Otherwise, if the variable binding's name specifies a variable
 |      which does not exist but can not be created under the present
 |      circumstances (even though it could be created under other
 |      circumstances), then the value of the Response-PDU's error-status
 |      field is set to `inconsistentName', and the value of its error-
 |      index field is set to the index of the failed variable binding.
 |
 |  The method routine must detect this condition.
 |
 |	Otherwise, if the variable binding's value field specifies a value
 |      that could under other circumstances be assigned to the variable,
 |      but is presently inconsistent, then the value of the Response-PDU's
 |      error-status field is set to `inconsistentValue', and the value of
 |      its error-index field is set to the index of the failed variable
 |      binding.
 |
 |  The method routine must detect this condition.
 |
 |	When, during the above steps, the assignment of the value specified  |
 |      by the variable binding's value field to the specified variable requires
 |      the allocation of a resource which is presently unavailable, then
 |      the value of the Response-PDU's error-status field is set to
 |      `resourceUnavailable', and the value of its error-index field is
 |      set to the index of the failed variable binding.
 |
 |  The method routine must detect this condition.
 |
 |	If the processing of the variable binding fails for a reason other
 |      than listed above, then the value of the Response-PDU's error-
 |      status field is set to `genErr', and the value of its error-index
 |      field is set to the index of the failed variable binding.
 |
 |  The method routine must detect this condition.
 |
 |  Note that libesnmp and the master-agent will eventually determine
 |  the error index to use when generating the response.  Method routines
 |  simply (!) return the correct error code.
 |
 |
 |  method->row->context is intended to hold any data you need to process sets.
 |  (A typical use would be to store the address of one of the emitted 
 |  <foo>_type structures, and load that structure's fields with the values in
 |  method->vb->value>.)
 |
 |  row->state is a bitmask used to indicate processing state.
 |
 |  row->state & row->context are PRIVATE TO THE METHOD ROUTINE, libesnmp
 |  ignores them.
 |
 |  ESNMP_ACT_COMMIT:
 |
 |  Even though several variable bindings may be in a conceptual row, only
 |  the last one (in order of the SetRequest) is processed.  So for all the
 |  METHOD's that point to a common row, only the last method routine is called.
 |
 |  This method routine must have available to it all necessary data and context
 |  to perform the operation.  It must also save a snapshot of current data or
 |  whatever it needs to undo the set if required.
 |  (row->save is intended to hold a pointer to whatever data is needed to
 |  accomplish this.  A typical use is to store the address of an emitted
 |  <foo>_type structure that has been loaded with the current data for the
 |  conceptual row.)
 |
 |  row->save is also PRIVATE TO THE METHOD ROUTINE, libesnmp does not use it.
 |
 |  If the set operation succeeds, return ESNMP_MTHD_noError.  Otherwise return a
 |  value of ESNMP_MTHD_commitFailed.
 | 
 |  If any errors were returned during the COMMIT phase libesnmp enters the
 |  UNDO phase.  If not, it enters the CLEANUP phase.
 |  
 |  NOTE:  UNDO may occur even if the Set operation in your sub-agent is successful,
 |	   (because the SetRequest spanned sub-agents, and a different sub-agent
 |	    failed.)
 |
 |  ESNMP_ACT_UNDO:
 |
 |  For each conceptual row that was successfully comitted, the same method routine
 |  is called with method->action == ESNMP_ACT_UNDO.  (ROW_CONTEXTs that have not
 |  yet been called for COMMIT are not called for UNDO, they are called for CLEANUP.)
 |
 |  The method routine should attempt to restore conditions to what they were before
 |  it executed the COMMIT.  (This is typically done using the data pointed to
 |  by row->save.)
 |
 |  If successfull, return ESNMP_MTHD_noError, otherwise return ESNMP_MTHD_undoFail.
 | 
 |  ESNMP_ACT_CLEANUP:
 |
 |  Regardless of what else has happened, at this point each ROW_CONTEXT participates
 |  in CLEANUP.  The same method routine that was called for COMMIT is called 
 |  with method->action == ESNMP_ACT_CLEANUP.
 |
 |  This indicates the end of processing for the SetRequest.
 |  The method routine should perform whatever cleanup is required (for instance, freeing
 |  dynamic memory that may have been allocated and stored in row->context, etc.)
 |
 |  The function return status value is ignored for the CLEANUP phase.
 |
 ***********************************************************************/


/***********************************************************************
 |									
 |  The SET method routine for the gameEntry group.
 |
 |  Our rules for setting games are:
 |  Creation:
 |	New games can be created.
 |	gameDescr must be present and non-null.
 |	gameIndex may be present, if so, its value must match
 |	the instance in the ROW_CONTEXT.
 |	(We would not accept SetRequest{GameIndex.5 = 6}
 |	gameStatus may be present, if so must be = Underway  
 |
 |  Deletion:
 |	Only gameStatus may be present, must = Delete
 |
 |  Modification:
 |	GameStatus may be present, if so must not = Delete
 |	gameDescr may be present, may be any non-null value
 |
 |  We use the emitted gameEntry_type structure to hold 
 |  data for set context (row->context) and to hold any "before"
 |  data (row->save) if we're deleting or modifying.
 | 
 ***********************************************************************/

int gameEntry_set( METHOD *method )
{
    OBJECT         *object   = method->object;
    VARBIND        *vb       = method->varbind;
    ROW_CONTEXT	   *row	     = method->row;
    int             arg      = object->object_index;
    unsigned int   *inst     = row->instance;
    int            instlen   = row->instance_len;
    gameEntry_type *cur	     = (gameEntry_type *)row->context;
    gameEntry_type *prev     = (gameEntry_type *)row->save;
    static Game	   *g;


	switch (method->action) 
	{

	   case ESNMP_ACT_SET:

	     /*
	      *  First check for non-writeable MIB objects.
	      *  In our example we do not support setting the value
	      *  of gameNumMoves (even tho the MIB spec defines it
	      *  with ACCESS read-write).  This is an implementation-specific
	      *  variation that is "legal" SNMP.
	      *
	      *  We want to return notWriteable before any other error, so check here.
	      *  NOTE: An alternative to performing this check in our code is to
	      *        use the -e option with snmpi.  This tells snmpi to consult a
	      *	       a file defining which MIB variables we exclude Get or Set
	      *	       processing for.  To turn off Set processing for gameNumMoves we
	      *	       would have an entry in the exclusion file of the form
	      *
	      *		gameNumMoves noSET
	      */
	      if (arg == I_gameNumMoves)
	         return(ESNMP_MTHD_notWritable);

	     /*
	      *  If this is the first time this method routine has been cal                                                                                                                                                                                                                                                                           q4 $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_METHOD.C;1                                                                            n                              % "     c       led.
	      *  1.  Make a gameEntry_type and  save it in row->context.
	      *  2.  Validate the instance, and determine if a game with
	      *      this index exists.  If so, save the Game pointer in the
	      *	     static variable g.  (This SetRequest will be processed
	      *	     to completion before any other SNMP requests are processed, so
	      *	     we won't stomp this static data.) 
	      *	     We'll load it's data later.
	      *  3.  Save the row->instance in the context structure.
	      */ 
	      if (!cur)
	      {
		 cur = gameEntry_new();
		 if (!cur)
		    return(ESNMP_MTHD_resourceUnavailable);
	
		 if (instlen != 1)
		    return(ESNMP_MTHD_noCreation);

		 row->context = cur;
		 cur->gameIndex = *inst;
		 g = find_game(*inst, ESNMP_ACT_GET);
	      }	 

	
	      /*
	       *  This section validates the value of each variable binding 
	       *  in the SetRequest for this conceptual row.
	       *
	       *  This is the only chance we get to look at this VARBIND, so
	       *  we need to leave enough information in the ROW_CONTEXT so
	       *  that later on we can figure out if we've been given a valid
	       *  request.
	       *
	       *  If g != NULL, a game entry exists which matches
	       *  the instance info in this ROW_CONTEXT.  So if g is null
	       *  we can't modify or delete, and if it's non-null we can't create.
	       *  The value of g is used to help validate values for variable
	       *  bindings that can be present for both create and modify operations.
	       *
	       *  NOTE:
	       *  How a method routine validates variable bindings and checks for consistency 
	       *  within SetRequest processing IS ENTIRELY PRIVATE.
	       *  Libesnmp does not use the row->state, row->context, or row->save fields.
	       *
	       *  This example program uses the supplied support code to do
	       *  row and field state handling.  This means:
	       *
	       *	o the emitted gameEntry_type structure is used to store data about
	       *	  the current SetRequest, and is pointed to by row->context.
	       *	o the mark[] array in this structure is used to store the
	       *	  state of each variable binding we see.
	       *	o these states are referenced via the macros & defined values
	       *	  in esnmp.h (MARK_CREATE, REQ_FOR_CREATE, etc.) 
	       *  
	       */
	      switch(arg)
	      {
		 case I_gameIndex:	
		 /*
		  *  May only be present on a row creation.  
		  *  It's value must be = the row's instance.
		  *  (SetRequest{gameIndex.3 = 4} makes no sense).
		  *  We've already saved its value in cur->gameIndex.
		  */
		 if (row->state & ~ESNMP_SET_CREATE)
		    return(ESNMP_MTHD_inconsistentValue);
		 if (g)
		    return(ESNMP_MTHD_inconsistentValue);
		 if (cur->gameIndex != vb->value.sl)
		    return(ESNMP_MTHD_inconsistentValue);
		 MARK_CREATE(&cur->gameIndex_mark);
		 row->state = ESNMP_SET_CREATE;
		 break;

		 case I_gameDescr:	
		 /*
		  *  Must be present on creates, optional for modify,
		  *  not allowed on delete.  If present must be non-null.
		  *  Can never be larger than DESCR_SIZE.
		  *
		  *  Copy the vb data into cur->gameDescr.
		  */
		 if ((vb->value.oct.len == 0) || (vb->value.oct.len >= DESCR_SIZE)) 
		    return(ESNMP_MTHD_wrongLength);
		 if (row->state == ESNMP_SET_DELETE)
		    return(ESNMP_MTHD_inconsistentName);
		 if (clone_oct(&cur->gameDescr, &vb->value.oct) == NULL)
		    return(ESNMP_MTHD_resourceUnavailable);
		 MARK_CREATE(&cur->gameDescr_mark);
		 MARK_MODIFY(&cur->gameDescr_mark);
		 if (!row->state)
		    row->state = (g)? ESNMP_SET_MODIFY : ESNMP_SET_CREATE;
		 break;

		 case I_gameStatus:
		 /*
		  *  On Create, must be Underway.
		  *  On Modify, must be Underway or Complete.
		  *  On Delete, must be the only variable binding. 
		  */
		 switch(vb->value.sl)
		 {
		    case D_gameStatus_delete:
		      if (row->state)		/* We were not first. */
			 return(ESNMP_MTHD_inconsistentValue);
		      cur->gameStatus = D_gameStatus_delete;
		      MARK_DELETE(&cur->gameStatus_mark);
		      row->state = ESNMP_SET_DELETE;
		      break;

		    case D_gameStatus_underway:
		      if (row->state & ESNMP_SET_DELETE)
			 return(ESNMP_MTHD_inconsistentValue);
		      cur->gameStatus = D_gameStatus_underway;
		      MARK_CREATE(&cur->gameStatus_mark);
		      MARK_MODIFY(&cur->gameStatus_mark);
		      row->state = (g)? ESNMP_SET_MODIFY : ESNMP_SET_CREATE;
		      break;

		    case D_gameStatus_complete:
		      if (row->state & ~ESNMP_SET_MODIFY)
			 return(ESNMP_MTHD_inconsistentValue);
		      cur->gameStatus = D_gameStatus_complete;
		      MARK_MODIFY(&cur->gameStatus_mark);
		      row->state = ESNMP_SET_MODIFY;
		      break;

		    default:
		      return(ESNMP_MTHD_wrongValue);
		 }
		 break;

		 default:
		    return(ESNMP_MTHD_genErr);

	      }	/* arg */

	      /*
	       *  Now that this variable binding has passed validation,
	       *  check if we're the last one for this row.  If so,
	       *  perform the final consistency check.
	       *
	       *  It's important to do this now, and not at the beginning
	       *  of the COMMIT phase, since errors discovered then would
	       *  cause all variable bindings to go thru COMMIT & UNDO needlessly.
	       *
	       *  Additionally, for Create, check that we can in fact create
	       *  a new game (actually that we have an avialable slot in the
	       *  game_tbl).  Clear this pointer since it's used in the subsequent
	       *  phases to mean an existing instance exists, which it does not!
	       */
	      if (method->flags & ESNMP_LAST_IN_ROW)
	      {
		 switch(row->state)
		 {
		    case ESNMP_SET_CREATE:
		      if ((REQ_FOR_CREATE(&cur->gameDescr_mark) &&
			   OPT_FOR_CREATE(&cur->gameIndex_mark) &&
			   OPT_FOR_CREATE(&cur->gameStatus_mark)) && (!g))
		      {
			 g = find_game_slot();
			 if (g)
			 {
			    g = NULL;
			    return(ESNMP_MTHD_noError);
			 }
			 else
			    return(ESNMP_MTHD_resourceUnavailable);	/* no move slots! */
		      }
		      break;

		    case ESNMP_SET_MODIFY:
		      if ((REQ_FOR_MODIFY(&cur->gameDescr_mark) ||
			   REQ_FOR_MODIFY(&cur->gameStatus_mark)) && (g))
			 return(ESNMP_MTHD_noError);
		      break;

		    case ESNMP_SET_DELETE:
		      if (g)
			 return(ESNMP_MTHD_noError);
		      break;
		 }
		 return(ESNMP_MTHD_inconsistentValue);
	      }
	      else
		 return(ESNMP_MTHD_noError);

	      break;	/* ESNMP_ACT_SET */


	   case ESNMP_ACT_COMMIT:

	      /*
	       *  All that SET phase processing worked, and we've been
	       *  called to COMMIT.
	       *
	       *  1. If an instance of this row exists, load its data now.
	       *     This is in case we need to undo whatever we're doing.
	       *     Saving this "undo" data should be done as close as possible
	       *     to when the COMMIT occurs, if the data in the existing row
	       *     instance is subject to change.  (In our case it's not, but
	       *     we delayed loading the Game data until this point anyway.)
	       *     (In the case of creating a new game, the gameEntry_type in
	       *     row->context is sufficient to undo.)
	       *
	       *  2. Execute the COMMIT.  Return either noError or commitFailed.
	       *
	       *     Note that for a Delete, we can't actually dissolve this Game's
	       *     association with the move tbl, otherwise we'd never be able to
	       *     UNDO if required.  So we leave the Moves and the Game.moves ptr
	       *     intact for now, and set the Game's sts to the special value -1.
	       *     If it's still == -1 in CLEANUP phase, we'll reclaim the Moves then.
	       */
	      if (g)
	      {
		 prev = gameEntry_new();
		 if (prev)
		    load_game(prev, g);
		 else
		    return(ESNMP_MTHD_resourceUnavailable);
	      }
	      switch(row->state)
	      {
		 case ESNMP_SET_CREATE:
		    g = find_game_slot();
		    if (!g)
		       return(ESNMP_MTHD_commitFailed);
		    g->index    = cur->gameIndex;
		    g->nummoves = 0;
		    g->moves    = NULL;	
		    g->lastmove = NULL;	
		    g->sts      = D_gameStatus_underway;
		    strncpy(g->descr, cur->gameDescr.ptr, cur->gameDescr.len);
		    g->descr[cur->gameDescr.len] = '\0';
		    num_games++;
		    return(ESNMP_MTHD_noError);
		    break;
		 case ESNMP_SET_MODIFY:
		    if (REQ_FOR_MODIFY(&cur->gameDescr_mark))
		    {
		       strncpy(g->descr, cur->gameDescr.ptr, cur->gameDescr.len);
		       g->descr[cur->gameDescr.len] = '\0';
		    }
		    if (REQ_FOR_MODIFY(&cur->gameStatus_mark))
		       g->sts = cur->gameStatus;
		    return(ESNMP_MTHD_noError);
		    break;
		 case ESNMP_SET_DELETE:
		    g->sts = -1;		    
		    num_games--;
		    return(ESNMP_MTHD_noError)                                                                                                                                                                                                                                                                           \ $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_METHOD.C;1                                                                            n                              < "     t       ;
		 default:
		    return(ESNMP_MTHD_inconsistentName);
	      } /* row->state */

	   break;  /* ACT_COMMIT */


	   case ESNMP_ACT_UNDO:

	      /*
	       *  A COMMIT failed somewhere after we had successfully completed our COMMIT.
	       *  Undo it.  The static Game ptr g still points to the
	       *  game tbl entry we operated on.  The gameEntry_type pointers
	       *  at this point are:
	       *
	       *	cur = row->context contains the data we loaded when
	       *	      validating the original request.  
	       *
	       *	prev = row->save contains the data that we loaded from
	       *	       the game tbl entry BEFORE doing the set operation
	       *	       (if one existed).
	       *
	       *  So to UNDO, 
	       *
	       *	if we Created, just mark Game.sts as invalid.  This frees
	       *	up the game tbl entry.  There is no memory to free, and
	       *	there are no associated moves since games are created with
	       *	0 moves.
	       *
	       *	if we Modified, just copy the prev data back to the Game.
	       *
	       *	if we Deleted,  all we'd done was set sts = -1.  Just copy
	       *	back the old status.
	       */
	      switch(row->state)
	      {
		 case ESNMP_SET_CREATE:
		    g->sts = 0;
		    num_games--;
		    break;

		 case ESNMP_SET_MODIFY:
		    strncpy(g->descr, prev->gameDescr.ptr, prev->gameDescr.len);
		    g->descr[prev->gameDescr.len] = '\0';
		    g->sts = prev->gameStatus;
		    break; 

		 case ESNMP_SET_DELETE:
		    g->sts = prev->gameStatus;
		    num_games++;
		    break;
	      }
	      return(ESNMP_MTHD_noError);

	      break;  /* ACT_UNDO */


	   case ESNMP_ACT_CLEANUP:

	      /*
	       *  Our main purpose here is to free up the data we created
	       *  for context and undo-ing.  We use the routines that were
	       *  generated by snmpi for this.
	       *
	       *  NOTE: These routines free variable length data pointed to 
	       *        within the structure, as well as the structure itself.
	       *	(In this example, it frees gameDescr.ptr.)  So be aware
	       *	of this when using the emitted structures and free routines. 
	       *
	       *  Since we malloced space for cur->gameDescr (via clone_oct), we'll
	       *  use the generated routine for that gameEntry_type.  But we simply
	       *  re-used the g->descr pointer in prev->gameDescr (via load_game).
	       *  Freeing that pointer would corrupt the game tbl entry, so we
	       *  just free manually (we know there is no other dynamic memory
	       *  that needs reclaiming.) 
	       *
	       *  If the operation was a Delete, and we didn't UNDO, we
	       *  still have to free up the move tbl entries that were associated
	       *  with this game, and give it a real sts value.
	       *
	       *  Finally, clear the static Game ptr so we're not confused next time.
	       */ 
	      if (cur)
		 gameEntry_free(cur);
	      if (prev)
		 free(prev);
	      if (g)
	      {
		 if (g->sts == -1)
		 {
		    reclaim_move_slots(g->moves);
		    g->sts = 0;
		 }
		 g = NULL;
	      }
	      return(ESNMP_MTHD_noError);

	      break; /* ACT_CLEANUP */


	   default:
	      /*
	       *  Bugcheck, this means the METHOD has been corrupted.
	       */
	      abort();


	}  /* method->action */

} /* gameEntry_set */




/***********************************************************************
 |
 |  This is the SET method routine for the moveEntry group.
 |
 |  Our rules for setting moves are:
 |
 |  Creation:
 |	new moveEntry rows may be created
 |	the instance must be 1 greater than the current gameNumMoves
 |	for the specified game (if it has 22 moves, you can create move 23)
 |	moveByWhite must be present
 |	moveByBlack may be present
 |	both must be non-null
 |
 |	creating a move causes gameNumMoves to be incremented
 |
 |  Modification:
 |	moveByWhite or moveByBlack may be modified
 |	to non-null values
 |
 |  Deletion
 |	moveEntry rows may be deleted
 |	only the last move in a game may be deleted	 
 |
 |	deleting a move causes gameNumMoves to be decremented
 |
 |  Since this table is indexed by [gameIndex, moveIndex] we must
 |  receive 2 integers in the row->instance array.  The first must match
 |  an existing game.  the second must either match an existing move
 |  in that game, or be 1 larger than the number of moves in that
 |  game (for a Create).
 |
 ***********************************************************************/
int moveEntry_set( METHOD *method )
{
    OBJECT         *object   = method->object;
    VARBIND        *vb       = method->varbind;
    ROW_CONTEXT	   *row	     = method->row;
    int             arg      = object->object_index;
    unsigned int   *inst     = row->instance;
    int            instlen   = row->instance_len;
    moveEntry_type *cur	     = (moveEntry_type *)row->context;
    moveEntry_type *prev     = (moveEntry_type *)row->save;
    static Game	   *g;
    static Move	   *m;


	switch (method->action) 
	{

	   case ESNMP_ACT_SET:

	      if (!cur)
	      {
		 cur = moveEntry_new();
		 if (!cur)
		    return(ESNMP_MTHD_resourceUnavailable);
	
		 if (instlen != 2)
		    return(ESNMP_MTHD_noCreation);

		 m = find_move(inst[0], inst[1], ESNMP_ACT_GET, &g);
		 if (!m)
		 {
		    g = find_game(inst[0], ESNMP_ACT_GET);
		    if (!g)
		       return(ESNMP_MTHD_inconsistentName);
		    if (g->nummoves + 1 != inst[1])
		       return(ESNMP_MTHD_inconsistentName);
		 }

		 /*
		  *  OK, if m exists it's a modify or delete.
		  *  If not, it's a create.  The 2 indexes are initially valid.
		  */
		 row->context = cur;
		 cur->gameIndex = inst[0];
		 cur->moveIndex = inst[1];
	      }	 

	      switch(arg)
	      {
		 case I_moveIndex:	
		 /*
		  *  May only be present on a row creation.  
		  *  It's value must be = the row's instance.
		  *  (SetRequest{moveIndex.3 = 4} makes no sense).
		  *  We've already saved its value in cur->moveIndex.
		  */
		 if (row->state & ~ESNMP_SET_CREATE)
		    return(ESNMP_MTHD_inconsistentValue);
		 if (m)
		    return(ESNMP_MTHD_inconsistentValue);
		 if (cur->moveIndex != vb->value.sl)
		    return(ESNMP_MTHD_inconsistentValue);
		 MARK_CREATE(&cur->moveIndex_mark);
		 row->state = ESNMP_SET_CREATE;
		 break;

		 case I_moveByWhite:	
		 /*
		  *  Must be present on creates, optional for modify,
		  *  not allowed on delete.  If present must be non-null.
		  *  Can never be larger than MOVE_SIZE.
		  *
		  *  Copy the vb data into cur->moveDescr.
		  */
		 if ((vb->value.oct.len == 0) || (vb->value.oct.len >= MOVE_SIZE)) 
		    return(ESNMP_MTHD_wrongLength);
		 if (row->state == ESNMP_SET_DELETE)
		    return(ESNMP_MTHD_inconsistentValue);
		 if (clone_oct(&cur->moveByWhite, &vb->value.oct) == NULL)
		    return(ESNMP_MTHD_resourceUnavailable);
		 MARK_CREATE(&cur->moveByWhite_mark);
		 MARK_MODIFY(&cur->moveByWhite_mark);
		 if (!row->state)
		    row->state = (m)? ESNMP_SET_MODIFY : ESNMP_SET_CREATE;
		 break;

		 case I_moveByBlack:	
		 /*
		  *  May be present on creates and modify,
		  *  not allowed on delete.  If present must be non-null.
		  *  Can never be larger than MOVE_SIZE.
		  *
		  *  Copy the vb data into cur->moveDescr.
		  */
		 if ((vb->value.oct.len == 0) || (vb->value.oct.len >= MOVE_SIZE)) 
		    return(ESNMP_MTHD_wrongLength);
		 if (row->state == ESNMP_SET_DELETE)
		    return(ESNMP_MTHD_inconsistentValue);
		 if (clone_oct(&cur->moveByBlack, &vb->value.oct) == NULL)
		    return(ESNMP_MTHD_resourceUnavailable);
		 MARK_CREATE(&cur->moveByBlack_mark);
		 MARK_MODIFY(&cur->moveByBlack_mark);
		 if (!row->state)
		    row->state = (m)? ESNMP_SET_MODIFY : ESNMP_SET_CREATE;
		 break;

		 case I_moveStatus:
		 /*
		  *  On Create, must be OK.
		  *  On Delete, must be the only variable binding. 
		  *  Not allowed on Modify.
		  */
		 switch(vb->value.sl)
		 {
		    case D_moveStatus_delete:
		      if (row->state)				/* We were not first varbind */
			 return(ESNMP_MTHD_inconsistentValue);
		      if (!m)
			 return(ESNMP_MTHD_inconsistentValue);
		      if (g->lastmove != m)			/* Not the last move */
			 return(ESNMP_MTHD_inconsistentName);   /* hmmmm... 	     */
		      cur->moveStatus = D_moveStatus_delete;
		      MARK_DELETE(&cur->moveStatus_mark);
		      row->state = ESNMP_SET_DELETE;
		      break;

		    case D_moveStatus_ok:
		      if (row->state & ~ESNMP_SET_CREATE)
			 return(ESNMP_MTHD_inconsistentValue);
		      if (m)
			 return(ESNMP_MTHD_inconsistentValue);
		      cur->moveStatus = D_moveStatus_delete;
		      MARK_CREATE(&cur->moveStatus_mark);
		      row->state = ESNMP_SET_CREATE;
		      break;

		    default:
		      return(ESNMP_MTHD_wrongValue);
		 }
		 break;

	      } /* arg */

	      if (method->f                                                                                                                                                                                                                                                   	                        E$ $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_METHOD.C;1                                                                            n                                           lags & ESNMP_LAST_IN_ROW)
	      {
		 switch(row->state)
		 {
		    case ESNMP_SET_CREATE:
		      if ((REQ_FOR_CREATE(&cur->moveByWhite_mark) &&
			   OPT_FOR_CREATE(&cur->moveByBlack_mark) &&
			   OPT_FOR_CREATE(&cur->moveIndex_mark) &&
			   OPT_FOR_CREATE(&cur->moveStatus_mark)) && (!m))
		      {
			 m = find_move_slot();
			 if (m)
			 {
			    m = NULL;
			    return(ESNMP_MTHD_noError);
			 }
			 else
			    return(ESNMP_MTHD_resourceUnavailable);	/* no move slot! */
		      }
		      break;

		    case ESNMP_SET_MODIFY:
		      if ((REQ_FOR_MODIFY(&cur->moveByWhite_mark) ||
			   REQ_FOR_MODIFY(&cur->moveByBlack_mark)) && (m))
			 return(ESNMP_MTHD_noError);
		      break;

		    case ESNMP_SET_DELETE:
		      if (m)
			 return(ESNMP_MTHD_noError);
		      break;
		 }
		 return(ESNMP_MTHD_inconsistentValue);
	      }
	      else
	         return(ESNMP_MTHD_noError);

	      break;	/* ESNMP_ACT_SET */


	      case ESNMP_ACT_COMMIT:
	      if (m)
	      {
		 prev = moveEntry_new();
		 if (prev)
		    load_move(prev, m, g);
		 else
		    return(ESNMP_MTHD_resourceUnavailable);
	      }
	      switch(row->state)
	      {
		 case ESNMP_SET_CREATE:
		    m = find_move_slot();
		    if (!m)
		       return(ESNMP_MTHD_commitFailed);
		    strncpy(m->w, cur->moveByWhite.ptr, cur->moveByWhite.len);
		    m->w[cur->moveByWhite.len] = '\0';
		    if (REQ_FOR_MODIFY(&cur->moveByBlack_mark))
		    {
		       strncpy(m->b, cur->moveByBlack.ptr, cur->moveByBlack.len);
		       m->b[cur->moveByBlack.len] = '\0';
		    }
		    add_move(m, g);
		    return(ESNMP_MTHD_noError);
		    break;

		 case ESNMP_SET_MODIFY:
		    if (REQ_FOR_MODIFY(&cur->moveByWhite_mark))
		    {
		       strncpy(m->w, cur->moveByWhite.ptr, cur->moveByWhite.len);
		       m->w[cur->moveByWhite.len] = '\0';
		    }
		    if (REQ_FOR_MODIFY(&cur->moveByBlack_mark))
		    {
		       strncpy(m->b, cur->moveByBlack.ptr, cur->moveByBlack.len);
		       m->b[cur->moveByBlack.len] = '\0';
		    }
		    return(ESNMP_MTHD_noError);
		    break;

		 case ESNMP_SET_DELETE:
		    kill_move(g);
		    return(ESNMP_MTHD_noError);
		    break;

		 default:
		    return(ESNMP_MTHD_inconsistentName);
	      } /* row->state */

	   break;  /* ACT_COMMIT */


	   case ESNMP_ACT_UNDO:
	      switch(row->state)
	      {
		 case ESNMP_SET_CREATE:
		    kill_move(g);
		    break;

		 case ESNMP_SET_MODIFY:
		    if (REQ_FOR_MODIFY(&cur->moveByWhite_mark))
		    {
		       strncpy(m->w, prev->moveByWhite.ptr, prev->moveByWhite.len);
		       m->w[prev->moveByWhite.len] = '\0';
		    }
		    if (REQ_FOR_MODIFY(&cur->moveByBlack_mark))
		    {
		       strncpy(m->b, prev->moveByBlack.ptr, prev->moveByBlack.len);
		       m->b[prev->moveByBlack.len] = '\0';
		    }
		    return(ESNMP_MTHD_noError);
		    break; 

		 case ESNMP_SET_DELETE:
		    add_move(m, g);
		    break;
	      }
	      return(ESNMP_MTHD_noError);

	      break;  /* ACT_UNDO */


	      case ESNMP_ACT_CLEANUP:
	      if (cur)
		 moveEntry_free(cur);
	      if (prev)
		 free(prev);
	      m = NULL;
	      g = NULL;
	      return(ESNMP_MTHD_noError);

	      break; /* ACT_CLEANUP */


	   default:
	      /*
	       *  Bugcheck, this means the METHOD has been corrupted.
	       */
	      abort();


	}  /* method->action */

} /* moveEntry_set */



                                                                                                                                                                                                                                                                                           0 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_MIB.C;1 +  , c   .      / #   4 k                           - P    0   1    2   3      K  P   W   O !    5   6 Bլ  7 u؛  8          9          G    H  J               /*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: chess_mib.c,v $
 * Revision 1.1.2.6  1995/10/26  13:35:47  Michael_Daniele
 * 	Always call enmp_term, and fixed build error (WARN) when -DDAEMONIZE.
 * 	[1995/10/25  15:09:48  Michael_Daniele]
 *
 * Revision 1.1.2.5  1995/09/07  12:23:58  David_Keeney
 * 	Fixed compile error, it was set_debug_level that got
 * 	the extra argument, not esnmp_init.  Added new error
 * 	handling logic:
 * 	      *      Rewrote main loop:
 * 	      *      Only restart protocol a max of 3 times.
 * 	      *      Check for protocol errors (like DUPLICATE) after poll(),
 * 	      *      since that's when responses are received.
 * 	      *      Log any error condition.
 * 	[1995/09/06  17:46:58  David_Keeney]
 * 
 * Revision 1.1.2.4  1995/06/30  17:00:52  David_Keeney
 * 	Added REGISTRATION_PRIORITY argument to esnmp_register().
 * 	Added callback function argument to esnmp_init().
 * 	[1995/06/30  14:35:51  David_Keeney]
 * 
 * Revision 1.1.2.3  1995/06/12  18:29:50  David_Keeney
 * 	Replaced DPRINTF with ESNMP_LOG.
 * 	[1995/06/08  17:26:32  David_Keeney]
 * 
 * 	Cleaned up GETNEXT's
 * 	[1995/04/25  22:50:37  David_Keeney]
 * 
 * 	Initial Checkin
 * 	[1995/04/24  15:58:30  David_Keeney]
 * 
 * $EndLog$
 */
/* #pragma ident "@(#)$RCSfile: chess_mib.c,v $ $Revision: 1.1.2.6 $ (DEC) $Date: 1995/10/26 13:35:47 $" */

/*********************************************************************
|                                                                    
|  chess-mib.c    Example Extensible SNMP Subagent 
|
|  This example sub-agent implements the wholly-fictitious
|  chess MIB.
|
|
*********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>

#include "esnmp.h"			  /* esnmp definitions */

#define ARE_YOU_THERE_TIME  30  /* interval between ARE_YOU_THERE messages (seconds)*/
#define RESPONSE_TIMEOUT     0  /* use the default timeout */
#define REGISTRATION_PRIORITY 2
#define RESTARTS            3   /* Attempt to connect 3 times in the face of 'fatal' errors */

extern SUBTREE chess_subtree; 


extern int chess_initialize(void);

static int usage(char *progname);
static void quit(int sig);

#define  rindex(string_ptr, c)  strrchr (string_ptr, c)
#define  bzero(target, length)  memset ((target), 0, (length))


/*****************************************************************************
|  FUNCTION: main
|
|  DESCRIPTION:
|	This routine does the following:
|	    1)  Decode the runtime arguments.
|	    2)  calls esnmp_init() to initialize and send the open.
|	        Calls esnmp_register() for each subtree to be supported
|		when the response the the OPEN is received.  
|	    3)  loops waiting on a select on the socket
|		when an event occures, call esnmp_poll() to read
|		and process the incoming packet.
|	    4)  If the select times out and no messages are pending,
|		send a 'Are-You-There' message.
|	    5)  If the select times out and we are expecting a response,
|	        then restart from the top by sending a CLOSE and an OPEN.
|
|	From these routines I could get the following status codes:
|	   0) ESNMP_LIB_OK            - continue, everything is fine.
|	  -1) ESNMP_LIB_NO_CONNECTION - Cannot send OPEN to Master Agent, restart.
|         -2) ESNMP_LIB_BAD_REG       - Registration error.
|	  -3) ESNMP_LIB_CLOSE         - Received a CLOSE message. restart.
|	  -4) ESNMP_LIB_LOST_CONNECTION- lost connection with Master Agent, restart.
|	  -5) ESNMP_LIB_NOTOK         - negitive response.
|
|  USAGE:  examp [-d][-trace]
|		-d     - don't be a demond
|		-trace - show all trace messages (won't demonize)
|
*****************************************************************************/

int main (int argc, char **argv)
{
    int i;
    int cc; 
    int rc = ESNMP_LIB_OK;
    int starts = 0;
    int response_pending;
    int subsocket = 0;
    fd_set fds_mask;
    fd_set fds_cur;
    struct timeval  cur_timeout;
    int debug_level;
#ifdef DAEMONIZE
    int    daemonize = 1;      /* daemonize by default */
#endif                          /* DAEMONIZE */

    /* initialize the signal handlers */
    signal(SIGINT,   quit);

    /* Decode the command line arguments */
    debug_level = 0;
    for (i = 1; i < argc; i++) {
        if (strcmp(argv[i], "-trace") == 0) {
            debug_level |= TRACE;
        }
#ifdef DAEMONIZE
        else if (!strcmp("-d", argv[i])) {
	    debug_level |= WARNING;  /* send messages to stdout */
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
                        < $      UCX042.B                       c  P  0[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_MIB.C;1                                                                               k                                     
                daemonize = 0;  /* don't be a daemon */
	}
#endif                          /* DAEMONIZE */
        else {
            usage(argv[0]);
            exit(-1);
        }
    }
#ifdef DAEMONIZE
    if (daemonize)
        debug_level |= DAEMON_LOG; /* send log messages to daemon log */
#endif

    set_debug_level(debug_level, NULL);

    chess_initialize();

#ifdef DAEMONIZE
    if (daemonize) {
        if (fork()) {
            _exit(); 
        }           

        else {     
            daemon(0, 0);
        }
    }
#endif                          /* DAEMONIZE */


    /* MAIN LOOP */

    /*
     | Try RESTARTS times to connect to the master agent,
     | unless we are a duplicate.
     */
    while ((starts++ < RESTARTS) && (rc != ESNMP_LIB_DUPLICATE)) {


            /*
             | Initialize and send the OPEN
             */
            ESNMP_LOG(TRACE, ("Initializing eSNMP connection..."));
            rc = esnmp_init(&subsocket, argv[0]);
            if (rc == ESNMP_LIB_OK) {
               FD_ZERO(&fds_mask);
               FD_SET(subsocket, &fds_mask);
               response_pending = TRUE;
            }

            /*
             | Register our subtrees
             */
	    if (rc == ESNMP_LIB_OK) {
	        rc = esnmp_register( &chess_subtree, 
				     RESPONSE_TIMEOUT, 
				     REGISTRATION_PRIORITY);
	    }

            /*
             | Keep reading the eSNMP socket, sending R-U-THERE? whenever
             | we timeout.  esnmp_poll() will process the master's responses,
             | so check specifically for DUPLICATE.
             */
            while(rc == ESNMP_LIB_OK) {
    	        cur_timeout.tv_sec = ARE_YOU_THERE_TIME;
    	        cur_timeout.tv_usec= 0;
		fds_cur = fds_mask;
        	cc = select(FD_SETSIZE,
                    	&fds_cur,
                    	(fd_set *) NULL,
                    	(fd_set *) NULL,
                    	&cur_timeout);

        	if (cc == -1) {
		    if (errno != EINTR) {
		        /* We have an error on the select - should not get any*/
           	        ESNMP_LOG(ERROR, ("select returned:%s\n",strerror(errno)));
                        rc = ESNMP_LIB_LOST_CONNECTION;
		    }
           	    continue;
        	}
		else if (cc == 0) {
		    /* The ARE_YOU_THERE time interval expired */
		    if (!response_pending) {
	                ESNMP_LOG( TRACE, ( "time to send ARE_YOU_THERE\n"));
		        rc = esnmp_are_you_there();
	                response_pending = TRUE;
		    }
		    else {
			/* timeout waiting for a response */
			rc = ESNMP_LIB_LOST_CONNECTION; /* exit the loop and restart */
		    }
		}
		else {
		    /* This must be a valid message - process it */
		    response_pending = FALSE;
		    rc = esnmp_poll();
		}
	    } /* end Message loop */

            /*
             | Trace the error condition.  If we got back a DUPLICATE
             | error stop now.  Otherwise wait and attempt a retry.
             */
            if (rc == ESNMP_LIB_DUPLICATE) {
               ESNMP_LOG( ERROR, ("This process is a duplicate sub-agent."));
            }
            else {
               ESNMP_LOG(ERROR, ("eSNMP error: %i", rc));
               sleep(ARE_YOU_THERE_TIME);
            }

    } /* end restart loop */

    /*
     | We've retried RESTART times or we received a DUPLICATE error.
     | Just say no...  
     */
    ESNMP_LOG( ERROR, ("Terminating..."));
    esnmp_term();
    exit(1);


}

/****************************************************************************
|  FUNCTION: usage
|
|  DESCRIPTION:
|	print the usage
|
|  USAGE:  examp [-d][-trace]
|		-d     - don't be a daemon
|		-trace - show all trace messages
|
|	NOTE: default logging is to the daemon log if the program is 
|	      daemonized.  Otherwise it goes to stdout.
|
*****************************************************************************/
static int usage(char *name)
{
    char *progname;

    if ((progname = rindex(name,'/'))== NULL)
	progname = name;
    else
	progname++;
    (void) fprintf(stderr, "USAGE: %s [-d][-trace]\n", progname);
    (void) fprintf(stderr, "    -d            Don't Daemonize\n");
    (void) fprintf(stderr, "    -trace        print trace messages\n");
    return 1;
}

/****************************************************************************
|  FUNCTION: quit
|
|  DESCRIPTION:
|	The place to go when we get a SIGINT signal
|
*****************************************************************************/
static void quit(int sig)
{
    ESNMP_LOG( TRACE, ( "SIGINT signal -exiting\n"));
    esnmp_term();  /* Send a CLOSE message */
    exit(1);
}
                  1 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_MIB.MY;1 +  , c   .     / #   4 _       {                    - P    0   1    2   3      K  P   W   O     5   6 ]tx  7 ᴔu؛  8          9          G    H  J              
          CHESS-MIB DEFINITIONS ::= BEGIN

          --  Digital UNIX Extensible SNMP Developer's Kit Sample (Chess game) MIB 

          IMPORTS
                  enterprises
                          FROM RFC1155-SMI
                  DisplayString 
                          FROM RFC1213-MIB
                  OBJECT-TYPE
                          FROM RFC-1212;

          --  This MIB Module uses the extended OBJECT-TYPE macro as
          --  defined in [9].



          dec    	OBJECT IDENTIFIER ::= { enterprises 36 }
          ema	 	OBJECT IDENTIFIER ::= { dec 2 }
          sysobjectids  OBJECT IDENTIFIER ::= { ema 15 }
          decosf 	OBJECT IDENTIFIER ::= { sysobjectids 2 }

	  chess		OBJECT IDENTIFIER ::= { decosf 99 }

	  -- All chess moves are represented as ascii strings of printable
	  -- characters.

	  MoveType   ::= DisplayString

	  -- General information about this product and the Games.

	  chessProductID OBJECT-TYPE
                     SYNTAX  OBJECT IDENTIFIER 
                     ACCESS  read-only
                     STATUS  mandatory
                     DESCRIPTION
                             "The value of this object is the registered object identifier 
			      for this product.  A value of (0,0) should be returned
			      if unsupported."
		     ::= { chess 1 } 

          chessMaxGames OBJECT-TYPE
                     SYNTAX  INTEGER
                     ACCESS  read-only
                     STATUS  mandatory
                     DESCRIPTION
                             "The maximum number of games this system can contain."
                     ::= { chess 2 }

          chessNumGames OBJECT-TYPE
                     SYNTAX  INTEGER
                     ACCESS  read-only
                     STATUS  mandatory
                     DESCRIPTION
                             "The number of current of chess games, both completed and active."
                     ::= { chess 3 }


	  -- The Game Table (no pun intended).  There is one entry in the table
	  -- for each chess game recorded in the system.

          gameTable OBJECT-TYPE
              SYNTAX  SEQUENCE OF GameEntry
              ACCESS  not-accessible
              STATUS  mandatory
              DESCRIPTION
		      "The conceptual table of chess games being/fully recorded
		       at this system.  The number of entries in the table is
		       given by the value of chessNumGames."
              ::= { chess 4 }

          gameEntry OBJECT-TYPE
              SYNTAX  GameEntry
              ACCESS  not-accessible
              STATUS  mandatory
              DESCRIPTION
		      "A conceptual entry for each chess game being recorded
		       or completely recorded."
              INDEX { gameIndex }
              ::= { gameTable 1 }

           GameEntry
              ::= SEQUENCE {
			gameIndex    INTEGER,
			gameDescr    DisplayString,
			gameNumMoves INTEGER,
			gameStatus   INTEGER
                  }

           gameIndex OBJECT-TYPE
                     SYNTAX  INTEGER
                     ACCESS  read-write
                     STATUS  mandatory
                     DESCRIPTION
                             "A unique value for each GameEntry.  This object may
			      be set during row addition only."  
                     ::= { gameEntry 1 }

           gameDescr OBJECT-TYPE
                     SYNTAX  DisplayString
                     ACCESS  read-write
                     STATUS  mandatory
                     DESCRIPTION
                             "A textual description of the chess game.
			      Implementors shoul                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          /Z
 $      UCX042.B                       c  P  1[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_MIB.MY;1                                                                              _                              v?             d strive to provide the name of
			      both players, the tournament and round, and the year
			      in which the game was played.  For instance,
			      'Alekhine - Euwe, Bad Kissengen Rnd 9, 1935'."  
                     ::= { gameEntry 2 }

           gameNumMoves OBJECT-TYPE
                     SYNTAX  INTEGER
                     ACCESS  read-write
                     STATUS  mandatory
                     DESCRIPTION
                             "The current number of moves in this game."
                     ::= { gameEntry 3 }

           gameStatus OBJECT-TYPE
                     SYNTAX  INTEGER {
				complete(1),
				underway(2),
				delete(3)
		     }
                     ACCESS  read-write
                     STATUS  mandatory
                     DESCRIPTION
                             "The (row) status of this game.  Setting this object to
			      a value of delete(3) results in the game being logically
			      removed from the system.  This is the only allowable value
			      when setting this object." 
                     ::= { gameEntry 4 }


	  -- The Move Table.  There is one entry in the table
	  -- for each move recorded for each chess game in the system.

          moveTable OBJECT-TYPE
              SYNTAX  SEQUENCE OF MoveEntry
              ACCESS  not-accessible
              STATUS  mandatory
              DESCRIPTION
		      "The conceptual table of chess moves for all games
		       recorded at this system."  
              ::= { chess 5 }

          moveEntry OBJECT-TYPE
              SYNTAX  MoveEntry
              ACCESS  not-accessible
              STATUS  mandatory
              DESCRIPTION
		      "A conceptual entry for each chess move recorded
		       for a game.  An example of how objects in this table
		       are named might be moveByWhite.3.7, which refers to 
		       game 3 move 7."
              INDEX { gameIndex, moveIndex }
              ::= { moveTable 1 }

           MoveEntry
              ::= SEQUENCE {
			moveIndex    INTEGER,
			moveByWhite  MoveType,
		 	moveByBlack  MoveType,
		        moveStatus   INTEGER
                  }

           moveIndex OBJECT-TYPE
                     SYNTAX  INTEGER
                     ACCESS  read-write
                     STATUS  mandatory
                     DESCRIPTION
                             "A unique value for each MoveEntry.  This object may
			      be set during row addition only.  Values of this object
			      range from 1 to gameNumMoves.n, where n is the corresponding
			      value of gameIndex."  
                     ::= { moveEntry 1 }

           moveByWhite OBJECT-TYPE
                     SYNTAX  MoveType
                     ACCESS  read-write
                     STATUS  mandatory
                     DESCRIPTION
			     "The algebraic or descriptive notation representing the
			      move by the player of the white pieces.  An example of
			      a value for this object is 'P-K4', or 'Ne6+!!'."
                     ::= { moveEntry 2 }

           moveByBlack OBJECT-TYPE
                     SYNTAX  MoveType
                     ACCESS  read-write
                     STATUS  mandatory
                     DESCRIPTION
			     "The algebraic or descriptive notation representing the
			      move by the player of the black pieces."
                     ::= { moveEntry 3 }

	   moveStatus  OBJECT-TYPE
                     SYNTAX  INTEGER {
				ok(1),
				delete(2)
		     }
                     ACCESS  read-write
                     STATUS  mandatory
                     DESCRIPTION
			     "Status of this moveEntry.  May be set to a value of
			      Delete only."
                     ::= { moveEntry 4 }

END





                                                                                                                                                                                                                                                                                                                                                                                                                  7 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_SUBAGENT.OPT;1 +  , c   .     / #   4 A       B                   - P    0   1    2   3      K  P   W   O     5   6 	  7 !u؛  8          9          G    H  J                         ! A ! Link options file for building the UCX$CHESS_SUBAGENT.EXE image  !  CHESS_METHOD.OBJ
 CHESS_MIB.OBJ 
 CHESS_TBL.OBJ  UCX$SNMP:UCX$ESNMP.OLB/LIBR  UCX$SNMP:UCX$SNMPUSER.OLB/LIBR UCX$SNMP:UCX$SNMP.OLB/LIBR! SYS$LIBRARY:UCX$IPC_SHR.EXE/SHARE $ SYS$LIBRARY:UCX$ACCESS_SHR.EXE/SHARE SYS$LIBRARY:DECC$SHR.EXE/SHARE                                                                                                                                                                                                            0 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_TBL.C;1 +  , c   .     / #   4                          - P    0   1    2   3      K  P   W   O     5   6 pgQǙ  7 Hu؛  8          9          G    H  J               

/* chess_tbl.c  - object table for subtree 'chess'.
 *
 *       @DEC_COPYRIGHT@
 *
 *       NOTE: This file is created by the dka300:[andre.esnmp.mibcomp.exe]snmpi.exe;1 program from definitions in '[.src]chess.defs'.
 *             Editing this file is not recommended.
 */

#include <stdio.h>
#include <stdlib.h>
#include "chess_tbl.h"

static unsigned int elems[] = {
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99,    /* chess */ 
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99, 1, 0, /* chessProductID */ 
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99, 2, 0, /* chessMaxGames */ 
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99, 3, 0, /* chessNumGames */ 
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99, 4, 1, 1, 0, /* gameIndex */ 
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99, 4, 1, 2, 0, /* gameDescr */ 
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99, 4, 1, 3, 0, /* gameNumMoves */ 
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99, 4, 1, 4, 0, /* gameStatus */ 
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99, 5, 1, 1, 0, /* moveIndex */ 
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99, 5, 1, 2, 0, /* moveByWhite */ 
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99, 5, 1, 3, 0, /* moveByBlack */ 
      1, 3, 6, 1, 4, 1, 36, 2, 15, 2, 99, 5, 1, 4, 0, /* moveStatus */ 
};

static OBJECT objects[] = {
   {I_chessProductID             ,{12, &elems[ 11]}, ESNMP_TYPE_ObjectId   ,chess_get, NULL},
   {I_chessMaxGames              ,{12, &elems[ 24]}, ESNMP_TYPE_Integer32  ,chess_get, NULL},
   {I_chessNumGames              ,{12, &elems[ 37]}, ESNMP_TYPE_Integer32  ,chess_get, NULL},
   {I_gameIndex                  ,{14, &elems[ 50]}, ESNMP_TYPE_Integer32  ,gameEntry_get, gameEntry_set},
   {I_gameDescr                  ,{14, &elems[ 65]}, ESNMP_TYPE_DisplayString,gameEntry_get, gameEntry_set},
   {I_gameNumMoves               ,{14, &elems[ 80]}, ESNMP_TYPE_Integer32  ,gameEntry_get, gameEntry_set},
   {I_gameStatus                 ,{14, &elems[ 95]}, ESNMP_TYPE_Integer32  ,gameEntry_get, gameEntry_set},
   {I_moveIndex                  ,{14, &elems[110]}, ESNMP_TYPE_Integer32  ,moveEntry_get, moveEntry_set},
   {I_moveByWhite                ,{14, &elems[125]}, ESNMP_TYPE_DisplayString,moveEntry_get, moveEntry_set},
   {I_moveByBlack                ,{14, &elems[140]}, ESNMP_TYPE_DisplayString,moveEntry_get, moveEntry_set},
   {I_moveStatus                 ,{14, &elems[155]}, ESNMP_TYPE_Integer32  ,moveEntry_get, moveEntry_set},
};

SUBTREE chess_subtree = { "chess", "1.3.6.1.4.1.36.2.15.2.99", { 11, &elems[0] }, objects, I_moveStatus};




/********************************************************
 *  FUNCTION: gameEntry_new
 *
 *  Allocate gameEntry_type data object for SET.
 ********************************************************/
gameEntry_type *gameEntry_new( void )
{
    gameEntry_type *data;

    data = (gameEntry_type *)calloc(1,sizeof(gameEntry_type));
    return (data);
}


/********************************************************
 *  FUNCTION: gameEntry_free
 *
 *  Free gameEntry_type data object for SET.
 ********************************************************/
void gameEntry_free( gameEntry_type *data)
{
    if (data != NULL) {
        if (data->gameDescr.ptr) 
             free(data->gameDescr.ptr); 
        free(data); 
    }
}



/********************************************************
 *  FUNCTION: moveEntry_new
 *
 *  Allocate moveEntry_type data object for SET.
 ********************************************************/
moveEntry_type *moveEntry_new( void )
{
    moveEntry_type *data;

    data = (moveEntry_type *)calloc(1,sizeof(moveEntry_type));
    return (data);
}


/*******                                                                                                                                                                                           xdn+ $      UCX042.B                       c  P  0[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_TBL.C;1                                                                                                            ;             *************************************************
 *  FUNCTION: moveEntry_free
 *
 *  Free moveEntry_type data object for SET.
 ********************************************************/
void moveEntry_free( moveEntry_type *data)
{
    if (data != NULL) {
        if (data->moveByWhite.ptr) 
             free(data->moveByWhite.ptr); 
        if (data->moveByBlack.ptr) 
             free(data->moveByBlack.ptr); 
        free(data); 
    }
}

                                                                                   0 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]CHESS_TBL.H;1 +  , c   .     / #   4                           - P    0   1    2   3      K  P   W   O     5   6 </QǙ  7 Vu؛  8          9          G    H  J               

/* chess_tbl.h  - include file for the 'chess' subtree method routines
 *
 *       @DEC_COPYRIGHT@
 *
 *       NOTE: This file is created by the dka300:[andre.esnmp.mibcomp.exe]snmpi.exe;1 program from definitions in '[.src]chess.defs'.
 *             Editing this file is not recommended.
 */

#ifndef _CHESS_TBL_H_
#define _CHESS_TBL_H_

#include "esnmp.h"

enum chess_variables {
        I_chessProductID                          ,    /* 0 */ 
        I_chessMaxGames                           ,    /* 1 */ 
        I_chessNumGames                           ,    /* 2 */ 
        I_gameIndex                               ,    /* 3 */ 
        I_gameDescr                               ,    /* 4 */ 
        I_gameNumMoves                            ,    /* 5 */ 
        I_gameStatus                              ,    /* 6 */ 
        I_moveIndex                               ,    /* 7 */ 
        I_moveByWhite                             ,    /* 8 */ 
        I_moveByBlack                             ,    /* 9 */ 
        I_moveStatus                              ,    /* 10 */ 
        MAX_CHESS_TBL_VARIABLES
};

extern int chess_initialize(void);

extern SUBTREE chess_subtree;


/* -- chess family -- */

  /* The group structure for chess  */
typedef struct _chess_type {
    OID   chessProductID;
    int   chessMaxGames;
    int   chessNumGames;

    char chessProductID_mark;
    char chessMaxGames_mark;
    char chessNumGames_mark;
} chess_type;

extern int chess_get(METHOD *method);



/* -- gameEntry family -- */

    /* enumerations for gameEntry group */
#define   D_gameStatus_complete               1
#define   D_gameStatus_underway               2
#define   D_gameStatus_delete                 3

  /* The group structure for gameEntry  (instance index is gameIndex)  */
typedef struct _gameEntry_type {
    int   gameIndex;
    OCT   gameDescr;
    int   gameNumMoves;
    int   gameStatus;

    char gameIndex_mark;
    char gameDescr_mark;
    char gameNumMoves_mark;
    char gameStatus_mark;
} gameEntry_type;

extern int gameEntry_get(METHOD *method);
extern int gameEntry_set( METHOD *method );
extern gameEntry_type *gameEntry_new( void );
extern void gameEntry_free( gameEntry_type *data );



/* -- moveEntry family -- */

    /* enumerations for moveEntry group */
#define   D_moveStatus_ok                     1
#define   D_moveStatus_delete                 2

  /* The group structure for moveEntry  (instance index is gameIndex moveIndex)  */
typedef struct _moveEntry_type {
    int   moveIndex;
    OCT   moveByWhite;
    OCT   moveByBlack;
    int   moveStatus;
    /* NOTE: following field is part of index but not part of group*/
    int   gameIndex;

    char moveIndex_mark;
    char moveByWhite_mark;
    char moveByBlack_mark;
    char moveStatus_mark;
    char gameIndex_mark;
} moveEntry_type;

extern int moveEntry_get(METHOD *method);
extern int moveEntry_set( METHOD *method );
extern moveEntry_type *moveEntry_new( void );
extern void moveEntry_free( moveEntry_type *data );


#endif  /* _CHESS_TBL_H_ Multiple include guard */
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               * * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]DIR.X;1 +  , c   .     / #   4 A       l                   - P    0   1    2   3      K  P   W   O     5 	  6 Ko  7 Acu؛  8          9          G    H  J                      /*3 ** dir.x: Remote OpenVMS directory listing protocol  */  ) /* maximum length of a directory entry */  const MAXNAMELEN = 255;  /* a directory entry */ $ typedef string nametype<MAXNAMELEN>;   /* a link in the listing */ " typedef struct namenode *namelist;   /*" ** A node in the directory listing */ struct namenode { 2     nametype name;   /* name of directory entry */%     namelist next;   /* next entry */      };   /*% ** The result of a READDIR operation.  */& union readdir_res switch (int Errno) {	   case 0: =      namelist list;  /* no error: return directory listing */   
   default:A      void;           /* error occurred: nothing else to return */    };   /*# ** The directory program definition  **/  program DIRPROG {      version DIRVERS {          readdir_res "             READDIR(nametype) = 1;         } = 1;     } = 0x20000076;                                                                                                                                                                  4 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]DIR_EXAMPLE.COM;1 +  , c	   .     / #   4 ?                           - P    0   1    2   3      K  P   W   O     5   6 ܓunp  7 pu؛  8          9          G    H  J                           
 $    SET NOON   $    IF F$TRNLNM("RPC") .EQS. ""	 $    THEN % $        DEFINE /PROCESS RPC UCX$RPC:   $        RPC_LOCALLY_DEFINED = 1	 $    ELSE   $        RPC_LOCALLY_DEFINED = 0
 $    ENDIF $ ? $    WRITE SYS$OUTPUT "Building RPC version of DIR program ..."  $    RPCGEN DIR.X 3 $    CC/DECC/WARNING=DISABLE=(IMPLICITFUNC) DIR_XDR  $ < $    WRITE SYS$OUTPUT "   ... building DIR (RLS) client ..."/ $    CC/DECC/WARNING=DISABLE=(IMPLICITFUNC) RLS 4 $    CC/DECC/WARNING=DISABLE=(IMPLICITFUNC) DIR_CLNT $    LINK RLS,SYS$INPUT/OPTIONS  DIR_CLNT DIR_XDR  SYS$SHARE:UCX$RPCXDR_SHR/SHARE SYS$SHARE:DECC$SHR/SHARE  $    RLS :== $SYS$DISK:[]RLS.EXE $ 6 $    WRITE SYS$OUTPUT "   ... building DIR server ..."3 $    CC/DECC/WARNING=DISABLE=(IMPLICITFUNC) DIR_SVC 6 $    CC/DECC/WARNING=DISABLE=(IMPLICITFUNC) DIR_SERVER# $    LINK DIR_SVC,SYS$INPUT/OPTIONS 
 DIR_SERVER DIR_XDR  SYS$SHARE:UCX$RPCXDR_SHR/SHARE SYS$SHARE:DECC$SHR/SHARE $  $    IF RPC_LOCALLY_DEFINED 	 $    THEN  $        DEASSIGN /PROCESS RPC
 $    ENDIF	 $    EXIT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           1 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]DIR_SERVER.C;1 +  , c   .     / #   4 :       (                    - P    0   1    2   3      K  P   W   O     5   6 Ƹmnp  7 !u؛  8          9          G    H  J               /*6 ** dir_server.c: remote OpenVMS readdir implementation */ #include <errno.h> #include <rms.h>* #include <rpc/rpc.h>   /* Always needed */. #include "dir.h"       /* Created by RPCGEN */  # extern int SYS$PARSE(struct FAB *); $ extern int SYS$SEARCH(struct FAB *);   extern char *malloc();  
 readdir_res *  readdir_1(dirname)     nametype *dirname; { )     char   expanded_name[NAM$C_MAXRSS+1];      struct FAB fab;      struct NAM nam;      namelist       nl;     namelist      *nlp; 1     static readdir_res res; /* must be static! */ *     char   resultant_name[NAM$C_MAXRSS+1];       /*     ** Initialize the FAB.     */     fab = cc$rms_fab;      fab.fab$l_fna = *dirname; %     fab.fab$b_fns = strlen(*dirname); '     fab.fab$l_dna = "SYS$DISK:[]*.*;*"; *     fab.fab$b_dns = strlen(fab.fab$l_dna);       /*     ** Initialize the NAM.     */     nam = cc$rms_nam; "     nam.nam$l_esa = expanded_name;!     nam.nam$b_ess = NAM$C_MAXRSS; #     nam.nam$l_rsa = resultant_name; !     nam.nam$b_rsP                                                                                                   
                        @r $      UCX042.B                       c  P  1[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]DIR_SERVER.C;1                                                                              :                              w             s = NAM$C_MAXRSS;      fab.fab$l_nam = &nam;        /*3     ** Parse the specification and see if it works.      */     if (SYS$PARSE(&fab) & 1) { 	/*  	** Free previous result 	*/ ! 	xdr_free(xdr_readdir_res, &res);   
         /*%         ** Collect directory entries. :         ** Memory allocated here will be freed by xdr_free(         ** next time readdir_1 is called
         */&         nlp = &res.readdir_res_u.list;&         while (SYS$SEARCH(&fab) & 1) {* 	    resultant_name[nam.nam$b_rsl] = '\0';7             nl = (namenode *) malloc(sizeof(namenode));  	    *nlp = nl; 7             nl->name = (char *) malloc(nam.nam$b_name + 7                                        nam.nam$b_type + :                                        nam.nam$b_ver + 1);& 	    strcpy(nl->name, nam.nam$l_name);             nlp = &nl->next;
             }          *nlp = NULL;  
         /*         ** Return the result
         */         res.Errno = 0;         } /* SYS$PARSE() */      else"         res.Errno = fab.fab$l_sts;          return &res;     }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       , * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]ESNMP.H;1 +  , c	   .      / #   4 b        C                   - P    0   1    2   3      K  P   W   O !    5   6 a+s؛  7 au؛  8          9          G    H  J                   /*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: esnmp.h,v $
 *
 * Revision 1.1.2.5  1996/05/13  T. Grady
 *	Added ESNMP_SIGNAL for reporting VMS error conditions
 *
 * Revision 1.1.2.4  1995/06/30  17:00:53  David_Keeney
 * 	Removed subtree_id from VARBIND structure.
 * 	Added callback argument to set_debug_level().
 * 	Added priority argument to esnmp_register().
 * 	Added LOG_CALLBACK typedef and LOG_CALLBACK_ROUTINE definitions.
 * 	[1995/06/30  14:36:01  David_Keeney]
 *
 * Revision 1.1.2.3  1995/06/12  18:29:53  David_Keeney
 * 	Replaced DPRINTF with ESNMP_LOG macro.
 * 	[1995/06/08  17:26:01  David_Keeney]
 * 
 * 	Initial Checkin
 * 	[1995/04/25  23:35:43  David_Keeney]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: esnmp.h,v $ $Revision: 1.1.2.4 $ (DEC) $Date: 1995/06/30 17:00:53 $
 */
/*********************************************************************
|
|  esnmp.h    Extensible SNMP Subagent -  API definitions
|                                                                  
|  Feb 15, 1995 - Version 0.1                                     
|  David Keeney
|
| This is the public API interface file for the DEC OSF/1 Extensible SNMP Agent.
|
*********************************************************************/

#ifndef _ESNMP_H_
#define _ESNMP_H_

/* for C++ compatability */
#ifdef __cplusplus
extern "C" {     
#endif          

#include <stdarg.h>
#include <time.h>

/*
 ******************************************************************************
 *									      *
 * libsnmp API function return values.					      *
 *									      *
 * These are valid status codes returned by			 	      *
 *									      *
 *	esnmp_init, esnmp_open, esnmp_register, esnmp_poll, esnmp_trap,       *
 *	esnmp_unregister, esnmp_term					      *
 *									      *
 ******************************************************************************
 */

#define ESNMP_LIB_OK               0  /* continue, everything is fine. */
#define ESNMP_LIB_NO_CONNECTION   -1  /* Cannot send OPEN to Master Agent, restart after delay. */
#define ESNMP_LIB_BAD_REG         -2  /* Cannot register the subtree, or not initialized. */
#define ESNMP_LIB_CLOSE           -3  /* Received a CLOSE message. restart after a delay. */
#define ESNMP_LIB_LOST_CONNECTION -4  /* lost connection with Master Agent, restart. */
#define ESNMP_LIB_NOTOK           -5  /* a negative response   */
#define ESNMP_LIB_DUPLICATE       -6  /* Duplicate subagent identifer in OPEN */



/*
 ******************************************************************************
 *									      *
 * The data types                        				      *
 *									      *
 ******************************************************************************
 */
#define ESNMP_TYPE_Integer32    (128|1) /* 32-bit INTEGER             */
#define ESNMP_TYPE_OctetString       2  /* OCTET STRING (ASN.1)       */
#define ESNMP_TYPE_ObjectId          3  /* OBJECT IDENTIFIER (ASN.1)  */
#define ESNMP_TYPE_NULL              4  /* NULL (ASN.1)               */
#define ESNMP_TYPE_IpAddress         5  /* IMPLICIT OCTET STRING (4)  */
#define ESNMP_TYPE_Counter32    (128|6) /* 32-bit Counter (unsigned)  */
#define ESNMP_TYPE_Gauge32      (128|7) /* 32-bit Gauge   (unsigned)  */
#define ESNMP_TYPE_TimeTicks    (128|8) /* 32-bit TimeTicks (unsigned)*/
                                       /* in hundreths of a second   */
#define ESNMP_TYPE_DisplayString     9  /* DisplayString (Textual Con)*/
#define ESNMP_TYPE_BitString         10 /* V2, BIT STRING (ASN.1)         */
#define ESNMP_TYPE_NsapAddress       11 /* V2, IMPLICIT OCTET STRING      */
#define ESNMP_TYPE_UInteger32   (128|12)/* V2, 32-bit INTEGER (unsigned)  */
#define ESNMP_TYPE_Counter64         13 /* V2, 64-bit Counter (unsigned)  */
#define ESNMP_TYPE_Opaque            14 /* V2, IMPLICIT OCTET STRING      */
#define ESNMP_TYPE_noSuchObject      15 /* IMPLICIT NULL              */
#define ESNMP_TYPE_noSuchInstance    16 /* IMPLICIT NULL              */
#define ESNMP_TYPE_endOfMibView      17 /* IMPLICIT NULL              */



/*
 ******************************************************************************
 *									      *
 * Method routine function return values.				      *
 *									      *
 * These are  a subset of SNMP codes defined in RFC 1448 (SNMPv2).	      *
 * (The libsnmp code can determine the others before calling method routines.)*
 *									      *
 ******************************************************************************
 */

#define ESNMP_MTHD_noError             0
#define ESNMP_MTHD_genErr              5
#define ESNMP_MTHD_noAccess            6
#define ESNMP_MTHD_wrongLength         8
#define ESNMP_MTHD_wrongEncoding       9
#define ESNMP_MTHD_wrongValue          10
#define ESNMP_MTHD_noCreation          11
#define ESNMP_MTHD_inconsistentValue   12
#define ESNMP_MTHD_resourceUnavailable 13
#define ESNMP_MTHD_commitFailed        14
#define ESNMP_MTHD_undoFailed          15
#define ESNMP_MTHD_notWritable         17
#define ESNMP_MTHD_inconsistentName    18
#define ESNMP_MTHD_noSuchInstance      80
#define ESNMP_MTHD_noSuchObject        81


/*
 ******************************************************************************
 *									      *
 *  Action values (for method->action)					      *
 *									      *
 ******************************************************************************
 */

#define ESNMP_ACT_GET            1
#define ESNMP_ACT_GETNEXT        2
#define ESNMP_ACT_SET            3
#define ESNMP_ACT_COMMIT        10
#define ESNMP_ACT_UNDO          11
#define ESNMP_ACT_GETBULK       12
#define ESNMP_ACT_INFORM        14      /* reserved, not implemented  */
#define ESNMP_ACT_ARE_YOU_THERE 15
#define ESNMP_ACT_CLEANUP       16      /* local to subagent only     */


/*
 ******************************************************************************
 *									      *
 *  Bit definitions for ROW_CONTEXT.state				      *
 *									      *
 ******************************************************************************
 */

#define ESNMP_SET_UNKNOWN	0x00	/* test and inter-variable checks not complete*/
#define ESNMP_SET_CREATE	0x01	/* Ready to commit to Create Row */
#define ESNMP_SET_MODIFY	0x02	/* Ready to commit to Modify Row */
#define ESNMP_SET_DELETE	0x04	/* Ready to commit to delete Row */

/*
 ******************************************************************************
 *									      *
 *  Bit definitions & macros for <foo>_mark byte fields			      *
 *									      *
 ******************************************************************************
 */

#define MARK_FLG_PRESENT	0x01	/* Data value is present */
#define MARK_FLG_CREA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          XԊ} $      UCX042.B                       c	  P  ,[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]ESNMP.H;1                                                                                   b                                "            TE		0x02	/* Data value valid for create */
#define MARK_FLG_MODIFY		0x04	/* Data value valid for modify */
#define MARK_FLG_DELETE		0x08	/* Data value valid for delete */

#define MARK_CREATE(_x_)   *(char *)(_x_) |= (MARK_FLG_CREATE | MARK_FLG_PRESENT)
#define MARK_MODIFY(_x_)   *(char *)(_x_) |= (MARK_FLG_MODIFY | MARK_FLG_PRESENT)
#define MARK_DELETE(_x_)   *(char *)(_x_) |= (MARK_FLG_DELETE | MARK_FLG_PRESENT)

#define REQ_FOR_CREATE(_x_) (*(char *)(_x_) & MARK_FLG_CREATE)
#define REQ_FOR_MODIFY(_x_) (*(char *)(_x_) & MARK_FLG_MODIFY)
#define REQ_FOR_DELETE(_x_) (*(char *)(_x_) & MARK_FLG_DELETE)

#define OPT_FOR_CREATE(_x_) (REQ_FOR_CREATE(_x_) || !(*(char *)(_x_) & MARK_FLG_PRESENT))
#define OPT_FOR_MODIFY(_x_) (REQ_FOR_MODIFY(_x_) || !(*(char *)(_x_) & MARK_FLG_PRESENT))
#define OPT_FOR_DELETE(_x_) (REQ_FOR_DELETE(_x_) || !(*(char *)(_x_) & MARK_FLG_PRESENT))


/*
 ******************************************************************************
 *									      *
 *  Data structures.							      *
 *									      *
 ******************************************************************************
 */

/* Octet String */
typedef struct _oct {
	int len;		        /* length of value in buffer */
	unsigned char *ptr;	        /* pointer to buffer */
} OCT;

/* Object Identifier */
typedef struct _oid {
	int  nelem;                     /* number of elements in oid */
	unsigned int *elements;         /* pointer to array  of elements */
} OID;


typedef struct _method METHOD;

/* MIB Object */
typedef struct _object {
	int object_index;		/* integer identifing this variable in subtree */
	OID oid;			/* OID for this variable */
	int type;			/* Type of variable */
	int (*getfunc)(METHOD *);	/* Function to perform Get/GetNext/GetBulk */
	int (*setfunc)(METHOD *);	/* Function to perform Set/Commit/Undo/Cleanup */
} OBJECT;

/* MIB Subtree */
typedef struct _subtree {
	char   *name;                   /* name of subtree in text form */
        char   *dots;                   /* OID of the subtree base in string dot form */
	OID     oid;			/* OID of the subtree base in binary integer array form*/
        OBJECT *object_tbl;             /* pointer to an array of subtree objects   */
        int     last;                   /* integer id of last item in subtree */
} SUBTREE;

/* Variable Binding */
typedef struct _varbind {
	OID name;			/* Identifier for object */
	int type;			/* ESNMP types */
        union _value {
            unsigned int  ul;		/* Value for Counter32, Gauge32, TimeTicks, UInteger32*/
            unsigned long ul64;		/* Value for Counter64 */
            int           sl;		/* Value for Integer32 */
            OID           oid;		/* Value for OID's */
            OCT           oct;		/* Value for everything else */
        } value;
	struct _varbind *next;		/* pointer to next varbind */
} VARBIND;

/* Trap */
typedef struct _trap {     /* not yet used */
    OID            *enterprise;
    int            generic_trap;
    int            specific_trap;
    unsigned int   time_ticks;
    VARBIND        *varbind;
} TRAP_PDU;

/* Row context for SET's only. */
typedef struct _row_context {
	void       *context;		/* commit context (for sets) */
	void       *save;		/* undo data (for sets) */
        unsigned int *instance;         /* pointer to instance array */
        int        instance_len;        /* number of elements in instance */
        int        state;               /* Update state for Set  */
} ROW_CONTEXT;

/* Method, the sole argument passed to method routines */
struct _method {
	int action;                     /* action to perform - the packet type */
	int serial_num;         	/* serial number for packet */
	int flags;           		/* options flag and  ESNMP_FIRST_IN_ROW flag */
	int repeat_cnt;       		/* for GETBULK        */
	int max_repetitions;		/* for GETBULK        */
	VARBIND    *varbind;		/* Requesting VarBind */
	OBJECT     *object;		/* Object structure for current variable */
        void       *security;           /* placeholder for some security thingie */
	ROW_CONTEXT *row;               /* row data for SET   */
	struct _method *prev;    	/* for SET's only, NULL is head of list*/
	struct _method *next;    	/* for SET's only, NULL is end of list*/
}; /* METHOD */

#define ESNMP_FIRST_IN_ROW 0x80  /* used in flags for marking first method in row (SETs only)*/
#define ESNMP_LAST_IN_ROW  0x40  /* used in flags for marking last  method in row (SETs only)*/

/* structure passed to the external log callback routine */
typedef struct _log_callback {
	int log_level;       /* TRACE, WARNING, ERROR */
	char *text;	     /* pointer to buffer containing text of message */
        /* Note: Additional fields may be added in the future */
} LOG_CALLBACK;

typedef void(*LOG_CALLBACK_ROUTINE)(LOG_CALLBACK *);

#ifdef OPENVMS
typedef unsigned int uint;
#define bzero(target, siz) memset (target, 0, siz)
#endif
/*
 *****************************************************************************
 *                                                                           *
 *  The DEBUG definitions.                                                   *
 *  The ESNMP_LOG macro can be used in the method routines to log messages   *
 *  to the daemon log and to assist in debugging.                            *
 *                                                                           *
 *  Example:   ESNMP_LOG(WARNING,("Cannot open file %s\n", filename));        *
 *                                                                           *
 *****************************************************************************
 */


   /* DPRINTF status codes */
#define ERROR          0x2000   /* Bad things happened, need to restart */
#define WARNING        0x1000   /* Dropping a packet - but continuing */
#define TRACE          0x0080   /* tracing packets */
#define DAEMON_LOG     0x0001   /* if TRUE we are to send log messages to daemon log */
#define EXTERN_LOG     0x0002   /* if TRUE call the callback function to log messages. */

#define ESNMP_LOG(level, x)    {if (is_debug_level(level)) { \
				    esnmp_log(level, esnmp_logs x, __LINE__, __FILE__);}}

#ifdef OPENVMS
#define ESNMP_SIGNAL(cond, level, x) {if (is_debug_level(level)) { \
				    esnmp_log(level, esnmp_logs x, __LINE__, __FILE__); \
				    lib$signal((unsigned int) cond);}}
#endif
/*
 ********************************************************************************
 *										*
 *  Function prototypes for libsnmp routines.					*
 *										*
 ********************************************************************************
 */

#ifndef OPENVMS
int     esnmp_init __((int *ssocket, char *subagent_identifier));
int     esnmp_are_you_there __((void));
int     esnmp_register __((SUBTREE *subtree, int timeout, int priority));
int     esnmp_unregister __((SUBTREE *subtree));
int     esnmp_trap __((int generic_trap, int specific_trap, char *enterprise, VARBIND *vb));
int     esnmp_term __((void));
int     esnmp_poll __((void));
unsigned int esnmp_sysuptime(struct timeval *timestamp);

int 	o_integer __((VARBIND *vb, OBJECT *obj, unsigned long value));
int 	o_octet __((VARBIND *vb, OBJECT *obj, OCT *oct));
int 	o_oid __((VARBIND *vb, OBJECT *obj, OID *oid));
int 	o_string __((VARBIND *vb, OBJECT *obj, unsigned char *ptr, int len));

OID 	*str2oid  __((OID *oid, char *s));
char   	*sprintoid  __((char *buffer, OID *oid));
OID 	*instance2oid  __((OID *new, OBJECT *obj, unsigned int *instance, int len));
int 	oid2instance  __((OID *oid, OBJECT *obj, unsigned int *instance, int max_len));
OID 	*clone_oid  __((OID *new, OID *old));
void 	free_oid  __((OID *oid));
int 	cmp_oid  __((OID *q, OID *p));
int 	cmp_oid_prefix  __((OID *q, OID *class));
int 	inst2ip __((unsigned int *inst, int instLength, unsigned int *ipAddr, 
		int searchType, int carry));
char 	*clone_buf __((char *str, int len));

OCT     *mem2oct  __((OCT *new, char *buffer, int len));
int     cmp_oct __((OCT *oct1, OCT *oct2));
OCT 	*clone_oct  __((OCT *new, OCT *old));
void 	free_oct  __((OCT *oct));
void    free_varbind_data(VARBIND *vb);

void 	print_varbind __((VARBIND *vb, int indent));

void    set_debug_level  __((int stat, LOG_CALLBACK_ROUTINE callback));
int     is_debug_level __((int stat));
void    esnmp_log __((int level, char *text, int line, char *file));
char    *esnmp_logs __((char *format, ...));
#endif

/* for C++ compatability */
#ifdef __cplusplus 
}                 
#endif


#endif  /* _ESNMP_H_  Multiple inclusion guard */

                                                                                                                                                                                                                                                                                                                                                                                                                                                                        y $      UCX042.B                       c  P  *[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]MSG.X;1                                                                                     *                                            * * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]MSG.X;1 +  , c   .     / #   4 *                           - P    0   1    2   3      K  P   W   O     5 	  6 oUo  7 u؛  8          9          G    H  J                      /** ** msg.x: Remote message printing protocol */ program MESSAGEPROG {      version MESSAGEVERS { %         int PRINTMESSAGE(string) = 1;          } = 1;     } = 0x20000099;                                                                                                                                                                                                                                                                                                                                                        4 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]MSG_EXAMPLE.COM;1 +  , c	   .     / #   4 F       :                   - P    0   1    2   3      K  P   W   O     5   6 3np  7 u؛  8          9          G    H  J                           
 $    SET NOON   $    IF F$TRNLNM("RPC") .EQS. ""	 $    THEN % $        DEFINE /PROCESS RPC UCX$RPC:   $        RPC_LOCALLY_DEFINED = 1	 $    ELSE   $        RPC_LOCALLY_DEFINED = 0
 $    ENDIF' $    IF P1 .NES. "" THEN GOTO MAKE$'P1'  $ F $    WRITE SYS$OUTPUT "Building local version of PRINTMSG program ..."4 $    CC/DECC/WARNING=DISABLE=(IMPLICITFUNC) PRINTMSG$ $    LINK PRINTMSG,SYS$INPUT/OPTIONS SYS$SHARE:DECC$SHR/SHARE* $    PRINTMSG :== $SYS$DISK:[]PRINTMSG.EXE $ ? $    WRITE SYS$OUTPUT "Building RPC version of MSG program ..."  $    RPCGEN MSG.X 3 $    CC/DECC/WARNING=DISABLE=(IMPLICITFUNC) MSG_XDR 6 $    WRITE SYS$OUTPUT "   ... building MSG client ..."5 $    CC/DECC/WARNING=DISABLE=(IMPLICITFUNC) RPRINTMSG 4 $    CC/DECC/WARNING=DISABLE=(IMPLICITFUNC) MSG_CLNT% $    LINK RPRINTMSG,SYS$INPUT/OPTIONS  MSG_CLNT MSG_XDR  SYS$SHARE:UCX$RPCXDR_SHR/SHARE SYS$SHARE:DECC$SHR/SHARE, $    RPRINTMSG :== $SYS$DISK:[]RPRINTMSG.EXE $ 6 $    WRITE SYS$OUTPUT "   ... building MSG server ..."3 $    CC/DECC/WARNING=DISABLE=(IMPLICITFUNC) MSG_SVC 6 $    CC/DECC/WARNING=DISABLE=(IMPLICITFUNC) MSG_SERVER# $    LINK MSG_SVC,SYS$INPUT/OPTIONS 
 MSG_SERVER MSG_XDR  SYS$SHARE:UCX$RPCXDR_SHR/SHARE SYS$SHARE:DECC$SHR/SHARE $  $    IF RPC_LOCALLY_DEFINED 	 $    THEN  $        DEASSIGN /PROCESS RPC
 $    ENDIF	 $    EXIT                                                                                                                                                                                                                     1 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]MSG_SERVER.C;1 +  , d   .     / #   4 E                          - P    0   1    2   3      K  P   W   O     5   6 'np  7 !,u؛  8          9          G    H  J               /*? ** msg_server.c: OpenVMS implementation of the remote procedure  ** "printmessage"  */  : #include <descrip.h>  /* OpenVMS descriptor definitions */9 #include <opcdef.h>   /* OpenVMS $SNDOPR() definitions */ ) #include <rpc/rpc.h>  /* always needed */ = #include "msg.h"      /* msg.h will be generated by RPCGEN */   A extern int SYS$SNDOPR(struct dsc$descriptor_s *, unsigned short);    /*# ** Remote version of "printmessage"  */ int *  printmessage_1(msg)      char **msg;  { !     struct dsc$descriptor_s desc;      union { ;         char  buffer[256]; /* Preallocate space for text */          struct opcdef opc;         } message;     static int result;     int status;        /*'     ** Build the message request block.      *//     message.opc.opc$b_ms_type   = OPC$_RQ_RQST; 2     message.opc.opc$b_ms_target = OPC$M_NM_CENTRL;$     message.opc.opc$w_ms_status = 0;$     message.opc.opc$l_ms_rqstid = 0;6     strcpy((char *) &message.opc.opc$l_ms_text, *msg);/     desc.dsc$a_pointer = (char *) &message.opc; >     desc.dsc$w_length  = (char *) &message.opc.opc$l_ms_text -,                          (char *) &message +E                          strlen((char *) &message.opc.opc$l_ms_text); 2     status = SYS$SNDOPR(&desc,        /* MSGBUF */0                          0);          /* CHAN */     if (status & 1)  	result = 1;     else         result = 0;      return &result;      }                                                                                                                                 / * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]PRINTMSG.C;1 +  , d   .     / #   4 E                          - P    0   1    2   3      K  P   W   O     5   6 =mp  7 a9u؛  8          9          G    H  J                 /*5 ** printmsg.c: OpenVMS print a message on the console  */ #include <descrip.h> #include <opcdef.h>  #include <stdio.h> #include <stdlib.h>  #include <string.h>   A extern int SYS$SNDOPR(struct dsc$descriptor_s *, unsigned short);     static int printmessage(char *);   main(argc, argv)     int   argc;      char *argv[];  {      char *message;       if (argc != 2) {:         fprintf(stderr, "usage: %s <message>\n", argv[0]);         exit (1); 	         }      message = argv[1];  !     if (!printmessage(message)) { E         fprintf(stderr,"%s: couldn't print your message\n", argv[0]);          exit (1); 	         } #     printf("Message Delivered!\n"); 
     exit (0);      }    /*? ** Print a message to the console.  Return a Boolean indicating , ** whether the message was actually printed. */
 static int printmessage(msg)      char *msg; { !     struct dsc$descriptor_s desc;      union { ;         char  buffer[256]; /* Preallocate space for text */          struct opcdef opc;         } message;     int status;        /*'     ** Build the message request block.      *//     message.opc.opc$b_ms_type   = OPC$_RQ_RQST; 2     message.opc.opc$b_ms_target = OPC$M_NM_CENTRL;$     message.opc.opc$w_ms_status = 0;$     message.opc.opc$l_ms_rqstid = 0;5     strcpy((char *) &message.opc.opc$l_ms_text, msg); /     desc.dsc$a_pointer = (char *) &message.opc; >     desc.dsc$w_length  = (char *) &message.opc.opc$l_ms_text -,                          (char *) &message +E                          strlen((char *) &message.opc.opc$l_ms_text);      /*'     ** Send the message to the console.      */2     status = SYS$SNDOPR(&desc,        /* MSGBUF */0                          0);          /* CHAN */     if (status & 1)          return 1; 
     return 0;      }                                                                                                                                                                                                                                                               1 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]PWIP$SDA.EXE;1 +  , h	   . 0    / #   4     0   -                    - P    0   1    2   3      K  P   W   O 1    5   6 W؛  7 Fu؛  8          9          G    H  J               0 D `     0205        W     J  h              (   -                   UCX1$SDA                               UCX V4.2-21    ͉כ 05-13                           
                                
       %   
 '   !      !         DECC$SHR_001 O    !       
MTHRTL_001      !        
LIBRTL_001$      +        CMA$TIS_SHR_001   *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               >$  !%  ݬHH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @                                                                                                                                                                                                                                                                                                                                                                          ʩ  $      UCX042.B                       h	  P  1[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]PWIP$SDA.EXE;1                                                                                   0                          "             ЬR|PbQSQR  PSP  ЬP RݬݬݬPb  ϳP}~ݬ  P  P  ϔP P  υPݬP  P  P ^cPР RݬVPPRЬTlQQQP@@QPPlbP  P  P  P ^PР0RݬPnЬ^bQ  Pݬ4Q  P}~8  P  P  ϭPݬDP  P  ϕP}~L  P  P  P  P  P  P ^^PРhRݬQPnЬݬ;P
Ьݬb  P  P ^
PР RݬPnЬ^b ^PР RݬPnЬЬPݬb ^ϮPР RݬϡPnЬ}~b ^PР RݬrPnЬ}~ݬb ^MPР Rݬ@PnЬ}~}~b                                                                                                                                                                                                                                                                                                   UCX$SDA>             ^RЬScPScPP'RR;PR3R/PP"RRPRRPRPA  PcScP ЬRbԢЬQ<aС||Ԣ   P!  QЬPР СPP ' ' '  ' ' '  P"?PЬPРPP ^!  RТPPP p    Dl4\
P?P0DT1 i  PTP1ݢ  PT1 I  PTP1~ݢ  PT1P !  PTP1~ݢ\  PT1iP   PTP1W~ݢ4  PT1AP   PbݢPݢݢ  PT1P   PTP1~ݢ  PT1P u  PTP1~ݢ  PT1P M  PTP1~ݢ  PT1P %  PTP1ݢݢa  PT1nP   PTP1[~ݢ8  PT1EP   PTP13~ݢ  PT1P   PTP1~ݢ  PT1 P   PTP1 ݢݢ  PT1 P ]  PTP1  ~ݢ  ScPT~ݢcPT~ݢcPT~PTrPTfPTZP   PTPJ   PT>PT6PT.P 5  PTbTbT<l~8>  TTP ^  R}bԢݬݬPݬbѢ1 Ѣ1 SPPP @PP   ??PQQz QPQA<P@Ptc
PcѢ1l    ^i  \l:Rbbbbbb-b0b<bhb̔ b b bbAbP     PDV_t_version =       %s    PAV_t_version =       %s             ^  R0~ wP ^  Rݬ¡ Y ^  RЬS$SPPP 5Td
S~S~S dS~d ^m  Rݬ¡ TdЬS$SPPP d
S~S~S dS~dP< ^  R~߭ݬZޭUݬ¡ TdUS$SPPP d
S~S~S dS~dP ^  V(ϯXЬUU:  PWЬTЬS$RTR1 $$SS߭䟭xPSSDT TݭU:  PH2RTR?X:WݭU:  P(2RWRXS)UJXRRPP t^  SWԼ߭ݬ%ѭ1 aVvU~Uݭ  ;UTݭá fTR$RPPP f
R~R~R fR~fݬݬUP
ЭWPeѭ1zWRRPP| ^)  R2  8  6  ZU1߭_PVˏV\\1߭
nݭP1~bݭ  b\0\~ :  ySc߭c        Td߭cr  `  ~d߭cX  B  ~d߭¢c>  $  ~d߭¯c$    ~d߭¼c@~    ~d߭c@~(    ~d߭cb    ~d߭cH    ~d߭c.  l  ~d߭c  N  ~d߭c  0  ~d߭c    ~d߭c    ~d߭*c    ~d߭5c    ~d߭Dcx    ~d߭Sc^  |  ~d߭^cD  ^  ~d߭mc*  @  ~d߭~c  "  ~d߭c    ~d߭c    ~d߭¬c    ~d߭¸c    ~d߭c    ~d߭ct  n  ~d߭cZ  P  ~d߭c@  2  ~d߭c&    ~d߭c    ~d߭)c    ~d߭8c  [  _  M  d߭?c  /  /  !  dh  Jt  Fg  [&PpVUPVU
  UUPP ΀^  R ]  ±Sc  cbP0P~cTdݬc  c  8c  Rc  lcB  c9   c0  ºc'  c  c  c  "c  <c  Vc  pc  c  ¤c  ¾c  c  c  c  &c  @c  Zc  tc  c  ¨c|  cs  cdd`  j2  @dJ  cA  -c8  Jc/  gc&  c¡d¢d3  ϗ1  @d  ¹c  c  c  c  -c  Jc  gc  c  ¡c  ¾c  cd  kP
P"	|  @	Sc  ]	c  z	c	Z  P	&¾	/  	Sc#  	c  
cP   0123456789ABCDEF  %s %s %s ------------------------------ Datagrams Listeners Sessions   nu chan      ucb port st     reads   writes  Frk Ack  Rst Wst   Lst    IP Addr  Max Cur        %3d %4d %08.8X %4d %2d  %3X %3X  %08.8X %08.8X %3X %3X %3X %3X  %3X      Remote address      ->cb_r_dbg.cb_l_tcpIpAddr   ΀^ЬPP  " P?PRRRϦRϠϓ/  @ ΀^  RЬPP 6 V rPB?PϽϦψb.  PSGPϙh	.  PS&Pϐςu^@s.  PSC< ^3  SЬRRPP    ?PTTTϖTϐσ-  @ЬPP 5 U rB?PϽϦψc-  PUGPϙh	-  PU&ϐςu^@r-  PUEP  PPP@ϴQQPP  PʏP@ϚQQP< Π^͠STЬQ<PPU:<~,ݡ8Rb~͠bУP@~PbU<UPxPQPPPQ<QRRP ^  TЬSQެRQbSPS `QQbЬ~~~~Sl,  PRRPP< `^UЬRRPT<~Tݢ8ݢ<ݬM$,  Ue@Sբ4><N~<L~BSePS `ݢ4<n~<l~SePTQP<2~<0~<N~<L~ݢHݢDSePT<P'TS<.~SePTTSݢ@SPTTSc| `^K  SfЬRR(PTբ4,<PTݬ($TݬDpPTݬa\~SVfݬÀ fЬRݢô fݢ fݢ8fݢ<Pf<~ÈfݢfݢfݢP(fݢT\f<~Ðfբ41 <Pݢ@f@Pf*  PUET ݢ@TPTd<.~ fЬR<0~8oTd<2~pdݢDèdݢHdݢ dݢ$DdxЬP Pzd	PØdëWЬR<L~ðTd<N~dݢ(d2,~Pdբ4e `ݢ4fÈdݢ4Ìd<l~d<n~dp,dt`dxÔd|d< (^  T ЬRRPSբ4.<PSݬ&PSݬPSݬ5RUeЬSSSeЬRbcpeݢĨe<~e
~
e~XeݢĐeݢe<~ 	e<~@	eݢx	eݢİ	eݢ  	eݢ$$ 
eݢ((X
e2,~,Đ
e<.~.
e<0~0e<2~2Heݢ44Āeݢ88ĸeݢ<<e<Pݢ@@(e
ݢ@@`eЬSݣDЬRDĘUeݣHHe<L~L
e<N~NH
eݣPPĀ
eݣTTĸ
eգ41 
eУ4R RR
eݭbeݭܟ@e<~xe~
Ĵe~e<~(e<~heݭ蟢Ġeݭ쟢eݭeݭHeP ^  WS|UЬPP   Pj?PPЬU  Ѭ
ݬݬpЬT1 V1 RX~TЬPP : Z uP?Pխf<P`SURUPUSNRVFPխ>SUR3US.RV&Pխ<PSUR
PUSRVRKЬPP1 !  7r?PSTSTrSTЭTV1
UVǀ_RRP    ΀^"  Sx  1 h  ݭݭݭc$Э\R=  UP`~\G                                                                                                                                                                                                                                                                           8g $      UCX042.B                       h	  P  1[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]PWIP$SDA.EXE;1                                                                                   0                         { "            PTD$  P\&r`   \RR  
P0QRRP 8 = B H M U X \ h o y                  EXITHELPDEBUGPWIPTELNETONOFFBREAKPOINTHEADERDATAGRAMSLISTENERSSESSIONSDEFAULTALLTRACEBRIEFFULLRAWBRIEFFULLRAWBRIEFFULLRAWBRIEFFULLRAWSESSIONS   j    ]   P 8 o   7o   *b   U   H   ;   .	& 
c   
                             ~    q    d    W 	   J 
   =u 
   0h    #[    N 
   	A    4    '        
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Internal command parsing error.  pdcb_id =  %x!XL error parsing !AS error parsing !AS error reading command. returning to SDA.   HELP  DEBUG [ON] DEBUG OFF DEBUG BREAKPOINT    PWIP HEADER PWIP DATAGRAMS [ BRIEF | FULL | RAW | NUM ] PWIP LISTENERS [ BRIEF | FULL | RAW | NUM ] PWIP SESSIONS  [ BRIEF | FULL | RAW | NUM ] PWIP [ALL]     ( BRIEF of Datagrams, Listeners & Sessions) PWIP TRACE PWIP DEFAULT   [ BRIEF | FULL | RAW ] (When NUM specified)                                                                                                                                            Device Driver Link Time: !%D Driver Prologue Table entry at %x!XA   Device Driver name of %x!@XB bytes: !AC   Flink=%x!@XA, blink=%x!@XA, type=%x!@XB   Flags=%X!@XL file scan failed with status !XL might not locate !AZ IOC$GL_DPTLIST PWIPDRIVER PWIPDRIVER PDCB_HEAD   TPFLAGS TOTLMBUFS CXBMSIZEPWIP MBUFSMSGSENT DWN_VECTOR ACP_VECTOR   PWIPACP_PID TIMEOUTCNT UNKNOWNCNT LINKDISCONCNT REJECTCNT LINKABORTCNT  CONNECFAILCNT NOLINKSCNT RDSUSPENDEDCNT WRSUSPENDEDCNT INSFMEMCNT UNREACHABLECNT RESOURCEWAITSCNT BLOCKEDXMTSCNT    RCVTCPCCCNT RCVTCPMBUFCNT   ADJTCPCCCNT ADJTCPMBUFCNT UNADJTCPCCCNT     UNADJTCPMBUFCNT ZEROLENTCPXMTSCNT ZEROLENUDPXMTSCNT ADDRVECTORPTR ITRACE_BUF_PTR ITRACE_REC_CNT DRV_WQ ACP_WQ  pwipdriver at %x!XA  pdcb_head  at %x!XA Could not find PWIPdriver image Could not find LDR$GQ_IMAGE_LIST  PWIPacp PID:          !XL  PWIPdriver location:  !XL  PWIPdriver Link Time: !%D    pdcb_head         =  !XL  tpFlags           =  !XL  totlMbufs         =  !XL  CXBmSize          =  !XL  Resource wait     =  !XL  timeoutCnt        =  !XL  unknownCnt        =  !XL  linkdisconCnt     =  !XL  rejectCnt         =  !XL  linkabortCnt      =  !XL  connecfailCnt     =  !XL  nolinksCnt        =  !XL  RDsuspendedCnt    =  !XL  WRsuspendedCnt    =  !XL  insfmemCnt        =  !XL  unreachableCnt    =  !XL  ResourceWaitsCnt  =  !XL  BlockedXmtsCnt    =  !XL  rcvTCPccCnt       =  !XL  rcvTCPmbufCnt     =  !XL  adjTCPccCnt       =  !XL  adjTCPmbufCnt     =  !XL  unadjTCPccCnt     =  !XL  unadjTCPmbufCnt   =  !XL  zeroLenTCPxmtsCnt =  !XL  zeroLenUDPxmtsCnt =  !XL  addrVectorPtr     =  !XL  itrace_buf_ptr    =  !XL  itrace_rec_cnt    =  !XL   Call Down Vector Table:    PDV_l_tcp_header =    !XL    PDV_l_udp_header =    !XL    PDV_a_open_dev =      !XL    PDV_a_close_dev =     !XL    PDV_a_call_down =     !XL   PWIPacp Vector Table:    PAV_a_wq =            !XL    PAV_a_init =          !XL    PAV_a_bind_ack =      !XL    PAV_a_ok_ack =        !XL    PAV_a_error_ack =     !XL    PAV_a_conn_ind =      !XL    PAV_a_conn_con =      !XL    PAV_a_discon_ind =    !XL    PAV_a_tp_ack =        !XL    PAV_a_addr_vec =      !XL    PAV_a_local_addr =    !XL   Error Validating PWIPdriver Work Queue:  Valid PWIPdriver Work Queue:    Queue address =       !XL    wq_a_flink =          !XL    wq_a_blink =          !XL   Error Validating PWIPacp Work Queue:  Valid PWIPacp Work Queue:    Queue address =       !XL    wq_a_flink =          !XL    wq_a_blink =          !XL %s%s%s%s %s%s%s %s%s%s%s%s  %u.%u.%u.%u TCP Session !UL on port !UL UDP Datagram !UL on port !UL TCP Listener !UL on port !UL    Address of pdcb_t                             !XL   Next pdcb_t                       ->cb_a_next !XL   Previous pdcb_t                   ->cb_a_next !XL   UCB address                     ->cb_a_ucxucb !XL   Channel                        ->cb_l_channel !XL       TPI state                        ->cb_w_state     !XW   TPI shim handle                ->cb_l_uHandle !XL   TPI shim vector table            ->cb_a_upvec !XL   Flags                            ->cb_l_flags !XL   Cloned (true=1, false=0)        ->cb_l_cloned !XL   Service type                   ->cb_w_service     !XW   UDP error count     ->cb_r_dbg.cb_l_udpErrCnt !XL       Link state                    ->cb_w_tpLinkSt     !XW   Read state                    ->cb_w_tpReadSt !XW       Write state                  ->cb_w_tpWriteSt     !XW   Read count                     ->cb_l_readcnt !XL   Write count                   ->cb_l_writecnt !XL   Write queue flink       ->cb_r_dwq.dq_a_flink !XL   Write queue blink       ->cb_r_dwq.dq_a_blink !XL     Error Validating Write Queue  Valid Write Queue       Fork count                     ->cb_w_forkcnt     !XW   ACK count                       ->cb_w_ackcnt !XW   mblk for ACP                     ->cb_a_mpacp !XL   Driver request for ACP       ->cb_w_tpRequest     !XW       Address of cicb_t                             !XL   Maximum outstanding            ->ci_w_maximum     !XW   Current outstanding        ->ci_w_outstanding !XW   Waitq flink          ->ci_r_waitq.ciq_a_flink !XL   Waitq blink          ->ci_r_waitq.ciq_a_blink !XL   Sentq flink          ->ci_r_sentq.ciq_a_flink !XL   Sentq blink          ->ci_r_sentq.ciq_a_blink !XL  TCP Session !UL on port !UL UDP Datagram !UL on port !UL TCP Listener !UL on port !UL   !XL Address of pdcb_t        !XL Header - forward link            ->cb_a_flink !XL   !XL Header - backward link           ->cb_a_blink !XL   !XL Header - size                     ->cb_w_size     !XW   !XL Header - type                     ->cb_b_type   !XB     !XL Header - subtype               ->cb_b_subtype !XB   !XL Next pdcb_t                       ->cb_a_next !XL   !XL Previous pdcb_t                   ->cb_a_prev !XL   !XL Service type                   ->cb_w_service     !XW       !XL TPI state                        ->cb_w_state !XW   !XL TPI shim handle                ->cb_l_uHandle !XL   !XL TPI shim vector table            ->cb_a_upvec !XL   !XL Write queue flink       ->cb_r_dwq.dq_a_flink !XL   !XL Write queue blink       ->cb_r_dwq.dq_a_blink !XL   !XL mblk for ACP                     ->cb_a_mpacp !XL   !XL Driver request for ACP       ->cb_w_tpRequest     !XW       !XL Link state                    ->cb_w_tpLinkSt !XW   !XL Read state                    ->cb_w_tpReadSt     !XW       !XL Write state                  ->cb_w_tpWriteSt !XW   !XL Connect indicate CB               ->cb_a_cicb !XL   !XL UCB address                     ->cb_a_ucxucb !XL   !XL Channel                        ->cb_l_channel !XL   !XL UDP error count     ->cb_r_dbg.cb_l_udpErrCnt !XL   !XL TCP address         ->cb_r_dbg.cb_l_tcpIpAddr !XL   !XL Read count                     ->cb_l_readcnt !XL   !XL Write count                   ->cb_l_writecnt !XL   !XL Fork count                     ->cb_w_forkcnt     !XW       !XL ACK count                       ->cb_w_ackcnt !XW   !XL Flags                            ->cb_l_flags !XL   !XL Cloned (true=1, false=0)        ->cb_l_cloned !XL    !XL Address of cicb_t  !XL Header - forward link            ->ci_a_flink !XL   !XL Header - backward link           ->ci_a_blink !XL   !XL Header - size                     ->ci_w_size     !XW   !XL Header - type                     ->ci_b_type   !XB     !XL Header - subtype               ->ci_b_subtype !XB   !XL Maximum outstanding            ->ci_w_maximum     !XW       !XL Current outstanding        ->ci_w_outstanding !XW   !XL Waitq flink          ->ci_r_waitq.ciq_a_flink !XL   !XL Waitq blink          ->ci_r_waitq.ciq_a_blink !XL   !XL Sentq flink          ->ci_r_sentq.ciq_a_flink !XL   !XL Sentq blink          ->ci_r_sentq.ciq_a_blink !XL  Element does not exist   Next: !XL  Start: !XL  End: !XL       !XL: !AF  Trace was not e                                                                                                                                                                                                                                                                            $      UCX042.B                       h	  P  1[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]PWIP$SDA.EXE;1                                                                                   0                               &       nabled                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @  @       l   x                                                             0          J   
                 @                                                                       DECC$SHR                                                       MTHRTL                                                         LIBRTL                                                         CMA$TIS_SHR                                                                                                        UCX$SDA_VECTOR_CALL    SDA$LOCAL_STRLEN	   	   !    !  CALLBACKADDRESSABILITY	!  	      -  
SDA$ADDSYMBOL	-  	7 	H 	G      G  
SDA$GETMEM	G  	m 	z      Z  
SDA$REQMEM	Z  	      `  
SDA$TRYMEM	`  	      f  SDA$NEWPAGE	f  	
      u  
SDA$SKIPLINES	u  	
        SDA$SETHEADING	  	J        SDA$FORMATSUBHEADING	  	o        	SDA$PRINT	  	# 
 K      SDA$PRINTCOLUMNS	  	        SDA$PRINTCOLUMNVALUE	  	        
SDA$SYMBOLIZE	  	4        SDA$SYMBOLVALUE	  	c  .      SDA$ALLOCATE	  	 	     1  SDA$DEALLOCATE	1  	
 	     A  SDA$TRANSLATEADDRESS	A  	 	     G  SDA$TRANSLATEBITS	G  	, 	     M  
SDA$ENSURE	M  	W
      _  SDA$TYPE	_  	      e  SDA$VALIDATEQUEUE	e  	
      u  SDA$READSYMFILE	u  	      {  
SDA$FORMAT	{  	        SDA$DISPLAYHELP	  	%        SDA$SETADDRESS	  	I        SDA$GETADDRESS	  	m        SDA$PARSECOMMAND	  	        SDA$GETINPUT	  	' 	 	  H      SDA$HANDLER	  	        
SDA$GETINPUTD	  	        
SDA$PRINT0	  	J  *      
SDA$PRINT1	  	{  2    I  
SDA$PRINT2	I  	  /    x  
SDA$PRINT3	x  	  2      
SDA$PRINT4	  	  3       $GLOBAL$       $CODE$                                                                                        J   DEFAULT_CLUSTER   6   `   ~                 !  :  L  e  x              /  @  u            	     G  [  {              )  H  X  q                4  J  c  y          A  #  <  Q  j  |            '  M  _                                                                                                                                                                                                      ;     UCX$SDAUCX V4.2-2118-NOV-1997 12:5018-NOV-1997 12:50   VAX-11 Linker V05-13        	.$$ABS$$. 3       SDA$EXTEND_VERSION        
SDA$EXTEND                                                                                                                                                                                                                                                                                                                                                                           * * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]RLS.C;1 +  , d   .     / #   4 ?       8                   - P    0   1    2   3      K  P   W   O     5 	  6 o  7 Aͷu؛  8          9          G    H  J                      /*( * rls.c: Remote directory listing client */ #include <errno.h> #include <rms.h> #include <stdio.h>. #include <rpc/rpc.h>    /* always need this */ #include "dir.h"   main(argc, argv)      int   argc;      char *argv[]; {       CLIENT *cl;      char   *dir;       namelist nl;       readdir_res *result;       char   *server;       if (argc != 3) {?         fprintf(stderr, "usage: %s host directory\n", argv[0]);          exit(1);	         }        server = argv[1];      dir = argv[2];       /*9     ** Create client "handle" used for calling DIRPROG on 6     ** the server designated on the command line.  Use3     ** the tcp protocol when contacting the server.      */6     cl = clnt_create(server, DIRPROG, DIRVERS, "tcp");     if (cl == NULL) { 
         /*5         ** Couldn't establish connection with server. (         ** Print error message and stop.
         */"         clnt_pcreateerror(server);         exit(1);	         }        /*6     ** Call the remote procedure readdir on the server     */!     result = readdir_1(&dir, cl);      if (result == NULL) { 
         /*:         ** An RPC error occurred while calling the server.(         ** Print error message and stop.
         */          clnt_perror(cl, server);         exit(1);	         }        /*9     ** Okay, we successfully called the remote procedure.      */     if (result->Errno != 0) { 
         /**         ** A remote system error occurred.(         ** Print error message and stop.         **/          errno = result->Errno;         perror(dir);         exit(1);	         }        /*,     ** Successfully got a directory listing.     ** Print it out.     */)     for (nl = result->readdir_res_u.list;               nl != NULL;                  nl = nl->next) !         printf("%s\n", nl->name);      exit(0);     }                                                                                                                                                                                                                       0 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]RPRINTMSG.C;1 +  , d   .     / #   4 Q       0                   - P    0   1    2   3      K  P   W   O     5   6 \mp  7 ںu؛  8          9          G    H  J                /*6 ** rprintmsg.c: remote OpenVMS version of "printmsg.c" */   #include <stdio.h>- #include <rpc/rpc.h>     /* always needed  */ @ #include "msg.h"         /* msg.h will be generated by rpcgen */   main(argc, argv)     int   argc;      char *argv[];  {      CLIENT *cl;      char   *message;     int    *result;      char   *server;        if (argc != 3) {=         fprintf(stderr, "usage: %s host message\n", argv[0]);          exit(1);	         }      server = argv[1];      message = argv[2];       /*=     ** Create client "handle" used for calling MESSAGEPROG on :     ** the server designated on the command line.  We tell3     ** the RPC package to use the TCP protocol when      ** contacting the server.      */>     cl = clnt_create(server, MESSAGEPROG, MESSAGEVERS, "tcp");     if (cl == NULL) { 
         /*5         ** Couldn't establish connection with server. (         ** Print error message and stop.
         */"         clnt_pcreateerror(server);         exit(1);	         }        /*=     ** Call the remote procedure "printmessage" on the server      */*     result = printmessage_1(&message, cl);     if (result == NULL) { 
         /*6         ** An error occurred while calling the server.(         ** Print error message and stop.
         */          clnt_perror(cl, server);         exit(1);	         }        /*9     ** Okay, we successfully called the remote procedure.      */     if (*result == 0) { 
         /*2         ** Server was unable to print our message.(         ** Print error message and stop.
         */Q         fprintf(stderr, "%s: %s couldn't print your message\n", argv[0], server);          exit(1);	         }        /*6     ** The message got printed on the server's console     */1     printf("Message delivered to %s!\n", server);      exit(0);     }                                                                                                                                                                                                                                                                                                                                                                                                                            . $      UCX042.B                       J  P  =[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]SYS$NET_SERVICES_UCX.COM;1                                                                  S                               z	             = * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]SYS$NET_SERVICES_UCX.COM;1 +  , J   .      / #   4 S                            - P    0   1    2   3      K  P   W   O !    5   6 |  7 u؛  8          9          G    H  J                   ( $ ! SYS$STARTUP:SYS$NET_SERVICES_UCX.COM $ !  $ ! < $ !  Copyright (c) 1994, 1995 Digital Equipment Corporation,6 $ !  All Rights Reserved.  Unpublished rights reserved3 $ !  under the copyright laws of the United States.  $ ! 8 $ !  The software contained on this media is proprietary3 $ !  to and embodies the confidential technology of 5 $ !  Digital Equipment Corporation.  Possession, use, 5 $ !  duplication or dissemination of the software and 9 $ !  media is authorized only pursuant to a valid written 0 $ !  license from Digital Equipment Corporation. $ ! 4 $ !  RESTRICTED RIGHTS LEGEND   Use, duplication, or4 $ !  disclosure by the U.S. Government is subject to9 $ !  restrictions as set forth in Subparagraph (c)(1)(ii) 3 $ !  of DFARS 252.227-7013, or in FAR 52.227-19, as  $ !  applicable. $ !  $ ! P $ !***************************************************************************** $ !  $ ! P $ !***************************************************************************** $ !  $ !     IDENT V4.1 $ !  $ !++  $ ! Facility:   UCX$INSTALL  $ !  $ ! 4 $ ! Module:     SYS$STARTUP:SYS$NET_SERVICES_UCX.COM $ !  $ ! Abstract:   E $ !   Integrated network support to provide a common DCL interface to J $ !   display information about starting, stopping, and displaying network> $ !   services information about TCP/IP Services for Open VMS. $ ! > $ !   The new DCL commands to obtain this information are SHOW< $ !   NETWORK, START/NETWORK, STOP/NETWORK, and SET NETWORK. $ ! ' $ !	Ramesh Tumkur		6-March-96		created.  $ !  $ !--  $ ! Modification History:  $ ! A $ ! 15-Jul-1996	Ben Doub	Changed FALSE to "FALSE", TRUE to"TRUE". * $ !				Added "SET NETWORK/UPDATE" command. $ !  $ ! I $ ! 25-Sep-1996	Pete Carson	Rework Version Check.  Assume all field tests # $ !				are post V6.2 at this point. * $ !				Add PPPD Callout for >7.1 on Alpha.P $ !***************************************************************************** $ ! initialization $ !  $ TRUE 		= 1 $ FALSE 	= 0 $ check_logical = "TRUE" $ check_version = "TRUE" $ priv_state    = "TRUE" $ file_check    = "TRUE" $ net_check     = "TRUE" $ say 		== "write sys$output"  $ ! N $ !***************************************************************************	 $ ! main:  $ ! N $ !*************************************************************************** $ main:  $	gosub check_privs # $       if priv_state .eqs. "FALSE"  $       thenO $               say "UCX$PRIV-I-ERROR, Requires SYSNAM (system name) privilege" ) $               say "Cannot register UCX"  $               exit
 $       endif  $ ! # $       gosub validate_ucx_logicals & $       if check_logical .eqs. "FALSE" $       thenE $               say "Check if UCX has been configured on this system" ) $               say "Cannot register UCX"  $               exit
 $       endif  $ !	 $ !	fully qualified domain name  $ ! D $ 	NODE = F$EDIT("''NODE'" + "." + "''DOMAIN'","COLLAPSE,LOWERCASE") $ !  $       gosub extract_versions& $       if check_version .eqs. "FALSE" $       then) $               say "Cannot register UCX"  $               exit
 $       endif  $ ! > $	gosub validate_files		! check for startup and shutdown files $	if file_check .eqs. "FALSE"  $	then@ $		say "START/NETWORK, STOP/NETWORK commands cannot be executed" $		exit  $	endif  $ ! C $	gosub check_registration	! check if product is already registered  $	if net_check .eqs. "FALSE" $	then" $       	gosub add_network_command $	else $		gosub update_network_command  $	endif  $ exit $ ! N $ !*************************************************************************** $ ! check_privs  $ ! N $ !*************************************************************************** $ !  $ check_privs:% $ 	priv_state = f$privilege("SYSNAM")  $ return $ ! N $ !*************************************************************************** $ ! validate_ucx_logicals: $ ! N $ !*************************************************************************** $ validate_ucx_logicals:( $       NODE = f$trnlnm("UCX$INET_HOST") $       if node .eqs. "" $       thenG $               say "UCX-F-ERROR, logical UCX$INET_HOST does not exist" ' $               check_logical = "FALSE" 
 $       endif  $ ! , $       DOMAIN = f$trnlnm("UCX$INET_DOMAIN") $       if node .eqs. "" $       thenI $               say "UCX-F-ERROR, logical UCX$INET_DOMAIN does not exist" ' $               check_logical = "FALSE" 
 $       endif  $ ! / $       ADDRESS = f$trnlnm("UCX$INET_HOSTADDR")  $       if address .eqs. ""  $       thenG $               say "UCX-F-ERROR, logical UCX$INET_ADDR does not exist"  $               
 $       endif  $ return $ ! N $ !*************************************************************************** $ ! extract_versions:  $ !  $ ! 
 $ !	Input:  $ !		check_version	Set to "TRUE" $ !	Output: ; $ !		check_version	Set to "FALSE" if no set NETWORK Support 3 $ !		major Version	"0" indicates internal baselevel 3 $ !		minor Version	"0" indicates internal baselevel  $ ! " $ ! Extract VMS base level version1 $ ! set network support exists for v62 and higher = $ ! some beta VMS EFT kits have version numbers of the form:  B $ !	X658 , while SSB kits are of the form XN.N  (x=>char; N =>int)D $ !     DCL network commands exist for versions 6.2 and beyond. ThisJ $ !     routine parses and extracts versions fro these two diff notations. $ ! N $ !*************************************************************************** $ !  $ extract_versions:  $	' $	OpenVMS_Version = f$getsyi("version")  $	Major_Version="0"  $	Minor_Version="0" - $	if f$extract(0,1,OpenVMS_Version) .eqs. "V"  $	then  1 $	! Released Version of VMS, potentially pre V6.2 ? $	    major_version = f$extract(1,f$length(OpenVMS_Version)-1,- # 		f$element(0,".",OpenVMS_Version)) 6 $	    minor_version = f$element(1,".",OpenVMS_Version) $!	strip off "-z" from "Vx.y-z" H $	    if f$locate("-",minor_version) .ne. f$length(minor_version) then -. 		minor_version=f$element(0,"-",minor_version)( $	    if f$integer(major_version) .lt. 6 $	    then  ' $               check_version = "FALSE" 	 $		say -	 B 		    "Error: NETWORK commands not supported for this VMS version" $	    else  / $		if (f$integer(major_version) .eq. 6) .and. - % 			(f$integer(minor_version) .lt. 2)   $		then 
 $		    say -	 B 		    "Error: NETWORK commands not supported for this VMS version" $		    check_version = "FALSE" $		endif $	    endif  $	endif  $ return $ !  $ ! N $ !*************************************************************************** $ ! validate_filesG $ ! ucx$startup.com and ucx$shutdown.com are required for start/network K $ ! and stop/network commands to start/restart network and shutdown network  $ ! respectively. N $ !*************************************************************************** $ !  $ validate_files: 5 $	if f$search("SYS$MANAGER:UCX$STARTUP.COM") .eqs. ""  $	then@ $		say "UCX-F-ERROR, SYS$MANAGER:UCX$STARTUP.COM does not exist" $		file_check = "FALSE"  $	endif  $ ! 6 $	if f$search("SYS$MANAGER:UCX$SHUTDOWN.COM") .eqs. "" $	thenA $		say "UCX-F-ERROR, SYS$MANAGER:UCX$SHUTDOWN.COM does not exist"  $		file_check = "FALSE"  $	endif  $ return $ ! N $ !*************************************************************************** $ ! check_registration $ ! N $ !*************************************************************************** $ !  $ check_registration:  $	ucx_registered = "FALSE"= $ 	MAX_INDEX = f$trnlnm("SYS$NET_SERVICES_1",,,,,"MAX_INDEX")  $ 	if max_index .nes. ""   $	then $ 		i = "0"  $ 		NET_SERVICES_LOOP:8 $ 		if f$trnlnm("SYS$NET_SERVICES_1",,i) .eqs. "TCP/IP"  $		then  $			ucx_registered = "TRUE"  $		endif
 $ 		i = i + 1 S $ 		if (i .les. MAX_INDEX) .and. (.not. ucx_registered) then goto NET_SERVICES_LOOP  $	endif ! $	if ucx_registered .eqs. "FALSE"  $	then $		net_check = "FALSE" $	endif  $ return $ ! N $ !*************************************************************************** $ ! add_network_command: $ ! N $ !*************************************************************************** $ add_network_command: $ pppd_callout =                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ] $      UCX042.B                       J  P  =[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]SYS$NET_SERVICES_UCX.COM;1                                                                  S                                             "" + $ if (f$getsyi("ARCH_NAME") .eqs. "Alpha")   $ then $!	Test for greater than 7.1. / $   if (f$integer(major_version) .gt. 7) .or. - P     ((f$integer(major_version) .eq. 7) .and. (f$integer(minor_version) .ge. 1))-9 	then pppd_callout = "/PPPD_CALLOUT=""UCX$PPPD_CALLOUT""" C $!	Assume internal baselevels are for FTs greater than current one. / $   if (f$integer(major_version) .eq. 0) then - 4 	pppd_callout = "/PPPD_CALLOUT=""UCX$PPPD_CALLOUT""" $ endif  $       SET NETWORK "TCP/IP" -
 		/REGISTER - ?                 /MANUFACTURER="Digital Equipment Corporation" -                  /NODE='NODE' - 		/ADDRESS='ADDRESS' - 		/NETWORK_TYPE="TCP/IP" -) 		/START="@SYS$MANAGER:UCX$STARTUP.COM" - ) 		/STOP="@SYS$MANAGER:UCX$SHUTDOWN.COM" - & 		/COUNTERS="UCX SHOW COMMUNICATION" -) 		/CONNECTIONS="UCX SHOW DEVICE_SOCKET" - + 		/STATUS="UCX SHOW VERSION" 'PPPD_CALLOUT'  $ return $ ! N $ !*************************************************************************** $ ! update_network_command:  $ ! N $ !*************************************************************************** $ update_network_command:  $       SET NETWORK "TCP/IP" - 		/UPDATE -                  /NODE='NODE' - 		/ADDRESS='ADDRESS' $ return                                                                                                                                                                                                                                                                                                                             2 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]TN3270DEF.MAR;1 +  , c   . 0    / #   4 Q   0   $                    - P    0   1    2   3      K  P   W   O 1    5   6 Aͮ8؛  7 u؛  8          9          G    H  J                             $ 	.TITLE	TN3270DEF	Translation Tables 	.IDENT	/V01.01/   ; N ; **************************************************************************** ; *									     *N ; *  Copyright (c) 1993                                                      *> ; *  by DIGITAL Equipment Corporation, Maynard, Mass.			     * ; * 									     * N ; *  This software is furnished under a license and may be used and  copied  *N ; *  only  in  accordance  with  the  terms  of  such  license and with the  *N ; *  inclusion of the above copyright notice.  This software or  any  other  *N ; *  copies  thereof may not be provided or otherwise made available to any  *N ; *  other person.  No title to and ownership of  the  software  is  hereby  * ; *  transferred.							     * ; * 									     * N ; *  The information in this software is subject to change  without  notice  *N ; *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  * ; *  Corporation.							     * ; * 									     * N ; *  DIGITAL assumes no responsibility for the use or  reliability  of  its  *D ; *  software on equipment which is not supplied by DIGITAL.		     * ; *									     *N ; **************************************************************************** ;    ;++  ;  ; FACILITY:	UCX  ; + ; ABSTRACT:	This is the file for generating & ;		an EBCDIC to DEC multi national and ;		DEC multi national to EBCDIC  ;		translation table ;  ; ENVIRONMENT:	VAX/VMS ;  ; AUTHOR:	John Borchek ;  ; CREATION DATE: 31-Jan-1993 ;  ; Mod history:% ; V01.01	Gabriel Shapira		28-May-1993 . ;		Modified comments to explain the file usage ;  ;--    ;+ ;  ; Loadable Translation Tables  ;  ; P ; This file contains a 256 byte EBCDIC to DEC multinational character set (DMCS)G ; and 256 byte DMCS to EBCDIC translation table. The translation tables L ; are as per ANSI X3.26 1970. There is one exception, code hex FF translatesF ; to code hex FF in both tables. All characters in the top half of theG ; DMCS set (128-255) translate to the EBCDIC SUB character (Hex 3F). No H ; EBCDIC characters translate to a character in the top half of the DCMSF ; table. All unnassigned EBCDIC characters translate to the DMCS/ASCIIE ; fill character. This character is defined in this file by assigning ! ; its value to a symbol DMFILL eg  ;	DMFILL = 45.E ; will make backslash ('-') the substitution character. If you do not H ; specify a value for DMFILL it defaults to 92. ('\') the fill character  ; defined by ANSII X3.26 - 1970. ; C ; This file alters the above two tables by the use of the following  ; three macros ;  ; ' ; REVTRA (Fully REVersible TRAnslation) ' ; -------------------------------------  ; G ; This macro overlays an entry in the EBCDIC to DMCS and DMCS to EBCDIC 5 ; translation tables. The macro is invoked as follows  ;  ;	REVTRA	EB, AS		; Comment ; F ; EB is the code for the EBCDIC character, AS is the code for the DMCSM ; character. EB is specified as a 1 or 2 digit hex number. AS is specified as L ; a 1 or 2 digit HEX number or by the 2 character sequence 'x where x is theI ; DMCS character. The second method of specifying EB can only be used for O ; printable ASCII characters. The result of using this macro is that the EBCDIC L ; character EB translates to the DMCS character AS and the DMCS character ASM ; translates to the EBCDIC character EB. Thus fully reversible translation is N ; provided for this character pair. This macro is recommended in preference toM ; the following two macros. The macros EB2AS and AS2EB should only be used if ( ; non reversible translation is desired. ; 
 ; Examples ; 7 ;	REVTRA	4A, A2		; EBCDIC cent sign <--> DMCS cent sign @ ;	REVTRA	5A, '!		; EBCDIC exclamation mark <--> DMCS exclamation ;				; mark  ;  ; $ ; EB2AS (EBCDIC to DMCS translation)$ ; ---------------------------------- ; J ; This macro changes an entry in the EBCDIC to DMCS table but not the DMCS2 ; to EBCDIC table. The macro is invoked as follows ;  ;	EB2AS	EB, AS ; " ; The arguments are as per REVTRA. ; 
 ; Examples ; 5 ;	EB2AS	4A, A2		; EBCDIC cent sign --> DMCS cent sign > ;	EB2AS	5A, '!		; EBCDIC exclamation mark --> DMCS exclamation ;				; mark  ;  ; $ ; AS2EB (DMCS to EBCDIC translation)$ ; ---------------------------------- ; L ; This macro changes an entry in the DMCS to EBCDIC table but not the EBCDIC0 ; to DMCS table. The macro is invoked as follows ;  ;	AS2EB	AS, EB		; Comment  ; " ; The arguments are as per REVTRA. ; 
 ; Examples ; 5 ;	AS2EB	A2, 4A		; DMCS cent sign --> EBCDIC cent sign > ;	AS2EB	'!, 5A		; DMCS exclamation mark --> EBCDIC exclamation ;				; mark  ; E ; This file is edited to produce a loadable translation table for the F ; UCX TELNET/TN3270 client software. To produce a loadable translation, ; table follow the procedure outlined below. ; 6 ; Procedure for producing a loadable translation table6 ; ---------------------------------------------------- ; " ; 1) Create the translation table:J ;    Take a copy of this file and insert calls to the macros REVTRA, EB2ASM ;    and/or AS2EB at the end of this file just before the .END statement. The O ;    following assumes that you have called the copy of this file TN3270DEF.MAR 6 ;    and that it is in your current default directory. ;  ; 2) Assemble this file: ;    $ MACRO/LIST TN3270DEF  ; 
 ; 3) Link:Q ;    Link TN3270DEF.OBJ, it does not matter how you link TN3270DEF as long as the L ;    image is produced with a header. The smallest file is produced with the ;    following command:-# ;    $ LINK/SYSTEM/HEADER TN3270DEF  ; P ;    If you wish you can use the command $ LINK TN3270DEF, this will produce theN ;    warning error that there is no user transfer address. You can ignore thisQ ;    error since you will never be running the image! $ LINK/SHARE TN3270DEF also  ;    works.  ; B ; 4) Copy the resultant image to a place where it is accessible toG ;    everybody that wants to use it. If you wish to make it the default E ;    translation table for UCX TELNET/TN3270 client do the following.  ; 3 ;    $ COPY TN3270DEF.EXE SYS$LIBRARY:TN3270DEF.TBL  ;  	.NLIST    	;  	; Declare MAC$32 if this is the 	; VMS assembler 	; 	.IIF	EQ, <10/2>-5, MAC$32 = 0   	.IIF	NDF MAC$32,	.ENABL	LC 
 	.LIST	MEB   	.SBTTL	Macro definitions    	;! 	; Convert 1 or 2 hex characters	  	; to a hex byte 	; 	.MACRO	.HEX  VAL  	.NLIST  	.DSABL	CRF  	.NCHR	LEN,<STR>	  	.IF	DF, MAC$32  		HEXVAL = ^X<VAL> 	.IFF  		HEXVAL = 0 		.NCHR	.HEX0,<VAL>	
 	.HEX1 = 0 		.IRPC	X,<VAL> 
 		.HEX2 = 16.  		.IIF IDN <X>,<0>, .HEX2 = 0  		.IIF IDN <X>,<1>, .HEX2 = 1  		.IIF IDN <X>,<2>,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            $      UCX042.B                       c  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]TN3270DEF.MAR;1                                                                             Q    0                         } "            .HEX2 = 2  		.IIF IDN <X>,<3>, .HEX2 = 3  		.IIF IDN <X>,<4>, .HEX2 = 4  		.IIF IDN <X>,<5>, .HEX2 = 5  		.IIF IDN <X>,<6>, .HEX2 = 6  		.IIF IDN <X>,<7>, .HEX2 = 7  		.IIF IDN <X>,<8>, .HEX2 = 8. 		.IIF IDN <X>,<9>, .HEX2 = 9. 		.IIF IDN <X>,<A>, .HEX2 = 10.  		.IIF IDN <X>,<B>, .HEX2 = 11.  		.IIF IDN <X>,<C>, .HEX2 = 12.  		.IIF IDN <X>,<D>, .HEX2 = 13.  		.IIF IDN <X>,<E>, .HEX2 = 14.  		.IIF IDN <X>,<F>, .HEX2 = 15.  		.IF GT .HEX2-15.! 			.ERROR	; Invalid HEX character 	 			.MEXIT  		.ENDC  		.IF  EQ .HEX1  	.HEX3 = .HEX2
 	.HEX1 = 1 		.IFF
 	.HEX1 = 0 		.HEX2 = <.HEX3*16.>+.HEX2  		.ENDC  		.ENDR  		HEXVAL = .HEX2 	.ENDC 	.ENABL	CRF  	.LIST 	.ENDM	.HEX  	  	;+ 	; Calculate a value from a string argument  	; 	.MACRO  .VAL  STR
 	VALUE = 0 	.NCHR	LEN,<STR>	  	.IF	NE, LEN-1 		.IF	NE, LEN-2 ; 		.ERROR	; Invalid argument, only 1 or 2 characters allowed  		.MEXIT 		.ENDC  	.ENDC 	CHRNUM = 0  	ITSHEX = 1  	.IRPC	X, <STR>	 	CHRNUM = CHRNUM + 1 	.IF	EQ, CHRNUM - 1  		.IF	DF MAC$32 # 			.IIF	EQ APOS - ^A/X/, ITSHEX = 0  		.IFF# 			.IIF	EQ APOS - <''X>, ITSHEX = 0  		.ENDC  	.IFF  		.IF	DF MAC$32 ! 			.IIF	EQ, ITSHEX, VALUE = ^A/X/  		.IFF! 			.IIF	EQ, ITSHEX, VALUE = <''X>  		.ENDC  	.ENDC 	.ENDR 	.IF	EQ, ITSHEX  		.IF	EQ, EBCARG - 1: 		.ERROR	; EBCDIC argument must be 1 or 2 digit HEX number 		.MEXIT 		.ENDC  	.IFF  		.IF	DF, MAC$32 		VALUE = ^X<STR>  		.IFF 		.HEX	<STR> 		VALUE = HEXVAL 		.ENDC  	.ENDC 	.ENDM   	;A 	; Add an element to the EBCDIC, to DEC multinational translation  	; table 	; 	.MACRO	EB2AS  EB, AS   ' 	EBCARG = 1		; Indicate EBCDIC argument . 	.VAL <EB>		; Compute value of EBCDIC argument9 	. = $EB2AS + VALUE	; Position to correct offset in table & 	EBCARG = 0		; Indicate ASCII argument- 	.VAL <AS>		; Compute value of ASCII argument ( 				; and store the translated character 	.BYTE	VALUE 	.ENDM   	;+ 	; Add an element to the DEC multinational,  	; to EBCDIC translation table 	; 	.MACRO	AS2EB  AS, EB   & 	EBCARG = 0		; Indicate ASCII argument- 	.VAL <AS>		; Compute value of ASCII argument 9 	. = $AS2EB + VALUE	; Position to correct offset in table ' 	EBCARG = 1		; Indicate EBCDIC argument . 	.VAL <EB>		; Compute value of EBCDIC argument( 				; and store the translated character 	.BYTE	VALUE 	.ENDM   	;, 	; Add an element to both translation tables. 	; so that the translation is reversible. Thus 	; 	; REVTRA 5A, '! 	;7 	; would cause EBCDIC '!' to be translated to ASCII '!' ! 	; and ASCII to '!' to EBCDIC '!'  	; 	.MACRO	REVTRA	EB, AS	0 	EB2AS	EB, AS			; Enter in EBCDIC to ASCII table0 	AS2EB	AS, EB			; Enter in ASCII to EBCDIC table 	.ENDM	     * 	.SBTTL	 Context and symbol initialisation   	; 	; Handy symbol for ' and \  	; 	.IF	DF MAC$32 		APOS = ^A/'/ 		EBSSUB = ^X3F  	.IFF  		APOS = '' 	 		.HEX	3F  		EBSSUB = HEXVAL  	.ENDC     	.SBTTL	Table Initialisation   	.IF	DF MAC$32' 		.PSECT	_SNASYS$GLOBAL, NOEXE, RD, WRT  	.IFF  		.PSECT	$$TRTB  	.ENDC   ;+, ; Initialise the DEC multinational to EBCDIC" ; table with EBCDIC SUB character., ; Initialise the EBCDIC to DEC multinational1 ; with the '\' character as per ANSI X3.26 -1970.  ; Note FF maps to FF.  ;-   $EB2AS:: 	.REPT	255. 
 	.BYTE	DMFILL  	.ENDR 	.BYTE	255.  $AS2EB:: 	.REPT	255. 
 	.BYTE	EBSSUB  	.ENDR 	.BYTE	255.     / 	.SBTTL	EBCDIC International translation tables 1 	.SBTTL	International EBCDIC to DEC multinational    	. = $EB2AS  	.BYTE	0.			; NUL --> NUL  	.BYTE	1.			; --> ^A 	.BYTE	2.			; --> ^B 	.BYTE	3.			; --> ^C
 	.BYTE	DMFILLI 	.BYTE	9.			; PT --> HT 
 	.BYTE	DMFILL	 	.BYTE	127.			; --> DEL*
 	.BYTE	DMFILL*
 	.BYTE	DMFILL*
 	.BYTE	DMFILL* 	.BYTE	11.			; --> ^K  	.BYTE	12.			; FF --> FF 	.BYTE	13.			; CR --> CR 	.BYTE	14.			; --> ^N  	.BYTE	15.			; --> ^O    	.BYTE	16.			; --> ^Po 	.BYTE	17.			; SBA --> ^Q	 	.BYTE	18.			; EUA --> ^R  	.BYTE	19.			; IC --> ^S
 	.BYTE	DMFILL 
 	.BYTE	DMFILL  	.BYTE	8.			; --> ^H
 	.BYTE	DMFILL  	.BYTE	24.			; --> ^X  	.BYTE	25.			; EM --> ^Y
 	.BYTE	DMFILL 
 	.BYTE	DMFILLo 	.BYTE	28.			; DUP --> ^\e 	.BYTE	29.			; SF --> ^] 	.BYTE	30.			; FM --> ^^ 	.BYTE	31.			; --> ^_d   	. = $EB2AS + 37.a 	.BYTE	10.			; --> ^Jo 	.BYTE	23.			; --> ^Wt 	.BYTE	27.			; --> ESC
 	.BYTE	DMFILLh
 	.BYTE	DMFILLt
 	.BYTE	DMFILL	
 	.BYTE	DMFILL	
 	.BYTE	DMFILL  	.BYTE	5.			; --> ^E 	.BYTE	6.			; --> ^F 	.BYTE	7.			; --> ^G   	. = $EB2AS + 50.d 	.BYTE	22.			; --> ^Vt
 	.BYTE	DMFILLm
 	.BYTE	DMFILLA
 	.BYTE	DMFILL 
 	.BYTE	DMFILLn 	.BYTE	4.			; --> ^D
 	.BYTE	DMFILL 
 	.BYTE	DMFILLs
 	.BYTE	DMFILLi
 	.BYTE	DMFILLu 	.BYTE	20.			; RA --> ^T 	.BYTE	21.			; --> ^Ue
 	.BYTE	DMFILLi 	.BYTE	26.			; SUB --> SUB   	.BYTE	32.			; SP --> SP
 	.BYTE	DMFILL*
 	.BYTE	DMFILL*
 	.BYTE	DMFILL*
 	.BYTE	DMFILL*
 	.BYTE	DMFILL 
 	.BYTE	DMFILL 
 	.BYTE	DMFILL 
 	.BYTE	DMFILLT
 	.BYTE	DMFILLi 	.BYTE	91.			; CENT --> '[ 	.BYTE	46.			; '. --> '. 	.BYTE	60.			; '< --> '< 	.BYTE	40.			; '( --> '( 	.BYTE	43.			; '+ --> '+ 	.BYTE	33.			; LOG OR --> '!   	.BYTE	38.			; '& --> '&
 	.BYTE	DMFILL 
 	.BYTE	DMFILLr
 	.BYTE	DMFILLb
 	.BYTE	DMFILL8
 	.BYTE	DMFILLM
 	.BYTE	DMFILLs
 	.BYTE	DMFILL 
 	.BYTE	DMFILL 
 	.BYTE	DMFILL  	.BYTE	93.			; '! --> '] 	.BYTE	36.			; '$ --> '$ 	.BYTE	42.			; '* --> '* 	.BYTE	41.			; ') --> ') 	.BYTE	59.			; '; --> '; 	.BYTE	94.			; LOG NOT --> '^o   	.BYTE	45.			; '- --> '- 	.BYTE	47.			; '/ --> '/
 	.BYTE	DMFILL 
 	.BYTE	DMFILLn
 	.BYTE	DMFILLr
 	.BYTE	DMFILLc
 	.BYTE	DMFILLo
 	.BYTE	DMFILLc
 	.BYTE	DMFILLe
 	.BYTE	DMFILLe- 	.BYTE	124.			; Split vertical bar --> LOG ORS 	.BYTE	44.			; ', --> ', 	.BYTE	37.			; '% --> '% 	.BYTE	95.			; '_ --> '_ 	.BYTE	62.			; '> --> '> 	.BYTE	63.			; '? --> '?   	. = $EB2AS + 121. 	.BYTE	96.			; '` --> '` 	.BYTE	58.			; ': --> ': 	.BYTE	35.			; '# --> '# 	.BYTE	64.			; '@ --> '@ 	.BYTE	39.			; '' --> '' 	.BYTE	61.			; '= --> '= 	.BYTE	34.			; '" --> '"  
 	.BYTE	DMFILLr 	.BYTE	97.			; 'a --> 'a 	.BYTE	98.			; 'b --> 'b 	.BYTE	99.			; 'c --> 'c 	.BYTE	100.			; 'd --> 'dA 	.BYTE	101.			; 'e --> 'eh 	.BYTE	102.			; 'f --> 'fo 	.BYTE	103.			; 'g --> 'go 	.BYTE	104.			; 'h --> 'h  	.BYTE	105.			; 'i --> 'is   	. = $EB2AS + 145. 	.BYTE	106.			; 'j --> 'j- 	.BYTE	107.			; 'k --> 'ko 	.BYTE	108.			; 'l --> 'lB 	.BYTE	109.			; 'm --> 'mC 	.BYTE	110.			; 'n --> 'n  	.BYTE	111.			; 'o --> 'ol 	.BYTE	112.			; 'p --> 'p; 	.BYTE	113.			; 'q --> 'qo 	.BYTE	114.			; 'r --> 'r,   	. = $EB2AS + 161. 	.BYTE	126.			; '~ --> '~s 	.BYTE	115.			; 's --> 'sh 	.BYTE	116.			; 't --> 'ta 	.BYTE	117.			; 'u --> 'um 	.BYTE	118.			; 'v --> 've 	.BYTE	119.			; 'w --> 'w  	.BYTE	120.			; 'x --> 'xm 	.BYTE	121.			; 'y --> 'yo 	.BYTE	122.			; 'z --> 'zl   	. = $EB2AS + 192. 	.BYTE	123.			; '{ --> '{o 	.BYTE	65.			; 'A --> 'A 	.BYTE	66.			; 'B --> 'B 	.BYTE	67.			; 'C --> 'C 	.BYTE	68.			; 'D --> 'D 	.BYTE	69.			; 'E --> 'E 	.BYTE	70.			; 'F --> 'F 	.BYTE	71.			; 'G --> 'G 	.BYTE	72.			; 'H --> 'H 	.BYTE	73.			; 'I --> 'I   	. = $EB2AS + 208. 	.BYTE	125.			; '} --> '}r 	.BYTE	74.			; 'J --> 'J 	.BYTE	75.			; 'K --> 'K 	.BYTE	76.			; 'L --> 'L 	.BYTE	77.			; 'M --> 'M 	.BYTE	78.			; 'N --> 'N 	.BYTE	79.			; 'O --> 'O 	.BYTE	80.			; 'P --> 'P 	.BYTE	81.			; 'Q --> 'Q 	.BYTE	82.			; 'R --> 'R   	. = $EB2AS + 224. 	.BYTE	92.			; '\ --> '\
 	.BYTE	DMFILLo 	.BYTE	83.			; 'S --> 'S 	.BYTE	84.			; 'T --> 'T 	.BYTE	85.			; 'U --> 'U 	.BYTE	86.			; 'V --> 'V 	.BYTE	87.			; 'W --> 'W 	.BYTE	88.			; 'X --> 'X 	.BYTE	89.			; 'Y --> 'Y 	.BYTE	90.			; 'Z --> 'Z   	. = $EB2AS + 240. 	.BYTE	48.			; '0 --> '0 	.BYTE	49.			; '1 --> '1 	.BYTE	50.			; '2 --> '2 	.BYTE	51.			; '3 --> '3 	.BYTE	52.			; '4 --> '4 	.BYTE	53.			; '5 --> '5 	.BYTE	54.			; '6 --> '6 	.BYTE	55.			; '7 --> '7 	.BYTE	56.			; '8 --> '8 	.BYTE	57.			; '9 --> '9 g1 	.SBTTL	DEC multinational to International EBCDIC    	. = $AS2EBC 	.BYTE	0.			; NUL --> NULe 	.BYTE	1.			; ^A 	.BYTE	2.			; ^B 	.BYTE	3.			; ^C 	.BYTE	55.			; ^Dp 	.BYTE	45.			; ^Ex 	.BYTE	46.			; ^F	 	.BYTE	47.			; ^G  	.BYTE	22.			; ^Ht 	.BYTE	5.			; HT --> PT  	.BYTE	37.			; ^Jr 	.BYTE	11.			; ^Ka 	.BYTE	12.			; FF --> FF 	.BYTE	13.			; CR --> CR 	.BYTE	14.			; ^Nn 	.BYTE	15.			; ^Oh 	.BYTE	16.			; ^P3 	.BYTE	17.			; ^Q --> SBAd 	.BYTE	18.			; ^R --> EUA  	.BYTE	19.			; ^S --> IC 	.BYTE	60.			; ^T --> RA 	.BYTE	61.			; ^Uc 	.BYTE	50.			; ^Vs 	.BYTE	38.			; ^W- 	.BYTE	24.			; ^X- 	.BYTE	25.			; ^Y --> EM 	.BYTE	63.			; ^Z --> SUBn   	.BYTE	39.			; ESC 	.BYTE	28.			; ^\ --> DUP  	.BYTE	29.			; ^] --> SF 	.BYTE	30.			; ^^ --> FM 	.BYTE	31.			; ^_o 	.BYTE	64.			; S                                                                                                                                                                                                                                                                           
8= $      UCX042.B                       c  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]TN3270DEF.MAR;1                                                                             Q    0                         $             P --> SP 	.BYTE	79.			; '! --> LOG OR 	.BYTE	127.			; '" --> '"a 	.BYTE	123.			; '# --> '#f 	.BYTE	91.			; '$ --> '$ 	.BYTE	108.			; '% --> '%n 	.BYTE	80.			; '& --> '& 	.BYTE	125.			; '' --> ''  	.BYTE	77.			; '( --> '( 	.BYTE	93.			; ') --> ') 	.BYTE	92.			; '* --> '* 	.BYTE	78.			; '+ --> '+ 	.BYTE	107.			; ', --> ',  	.BYTE	96.			; '- --> '- 	.BYTE	75.			; '. --> '. 	.BYTE	97.			; '/ --> '/ 	.BYTE	240.			; '0 --> '0$ 	.BYTE	241.			; '1 --> '1E 	.BYTE	242.			; '2 --> '2u 	.BYTE	243.			; '3 --> '3  	.BYTE	244.			; '4 --> '4e 	.BYTE	245.			; '5 --> '5a 	.BYTE	246.			; '6 --> '6  	.BYTE	247.			; '7 --> '7s 	.BYTE	248.			; '8 --> '8  	.BYTE	249.			; '9 --> '9  	.BYTE	122.			; ': --> ':  	.BYTE	94.			; '; --> '; 	.BYTE	76.			; '< --> '< 	.BYTE	126.			; '= --> '=i 	.BYTE	110.			; '> --> '>  	.BYTE	111.			; '? --> '?h 	.BYTE	124.			; '@ --> '@    	.BYTE	193.			; 'A --> 'AT 	.BYTE	194.			; 'B --> 'Bf 	.BYTE	195.			; 'C --> 'C  	.BYTE	196.			; 'D --> 'DN 	.BYTE	197.			; 'E --> 'E  	.BYTE	198.			; 'F --> 'Ft 	.BYTE	199.			; 'G --> 'Gr 	.BYTE	200.			; 'H --> 'HA 	.BYTE	201.			; 'I --> 'I2 	.BYTE	209.			; 'J --> 'J  	.BYTE	210.			; 'K --> 'K  	.BYTE	211.			; 'L --> 'Le 	.BYTE	212.			; 'M --> 'M  	.BYTE	213.			; 'N --> 'N  	.BYTE	214.			; 'O --> 'O. 	.BYTE	215.			; 'P --> 'PM 	.BYTE	216.			; 'Q --> 'Q  	.BYTE	217.			; 'R --> 'RH 	.BYTE	226.			; 'S --> 'S  	.BYTE	227.			; 'T --> 'T  	.BYTE	228.			; 'U --> 'UH 	.BYTE	229.			; 'V --> 'V> 	.BYTE	230.			; 'W --> 'W> 	.BYTE	231.			; 'X --> 'XN 	.BYTE	232.			; 'Y --> 'YF 	.BYTE	233.			; 'Z --> 'Z	   	.BYTE	74.			; '[ --> CENT 	.BYTE	224.			; '\ --> '\  	.BYTE	90.			; '] --> '! 	.BYTE	95.			; '^ --> LOG NOTH 	.BYTE	109.			; '_ --> '_> 	.BYTE	121.			; '` --> '`>   	.BYTE	129.			; 'a --> 'aN 	.BYTE	130.			; 'b --> 'bI 	.BYTE	131.			; 'c --> 'c  	.BYTE	132.			; 'd --> 'd  	.BYTE	133.			; 'e --> 'e  	.BYTE	134.			; 'f --> 'f> 	.BYTE	135.			; 'g --> 'gT 	.BYTE	136.			; 'h --> 'ha 	.BYTE	137.			; 'i --> 'iI 	.BYTE	145.			; 'j --> 'jX 	.BYTE	146.			; 'k --> 'k= 	.BYTE	147.			; 'l --> 'lH 	.BYTE	148.			; 'm --> 'm	 	.BYTE	149.			; 'n --> 'n= 	.BYTE	150.			; 'o --> 'o  	.BYTE	151.			; 'p --> 'p  	.BYTE	152.			; 'q --> 'qo 	.BYTE	153.			; 'r --> 'r. 	.BYTE	162.			; 's --> 's0 	.BYTE	163.			; 't --> 'tN 	.BYTE	164.			; 'u --> 'u  	.BYTE	165.			; 'v --> 'v, 	.BYTE	166.			; 'w --> 'wo 	.BYTE	167.			; 'x --> 'x. 	.BYTE	168.			; 'y --> 'y  	.BYTE	169.			; 'z --> 'zR   	.BYTE	192.			; '{ --> '{R- 	.BYTE	106.			; LOG OR --> Split vertical barA 	.BYTE	208.			; '} --> '}	 	.BYTE	161.			; '~ --> '~E 	.BYTE	7.			; DEL.  1 	DMFILL	= 92.			; Default DM fill character to '\A  					; as per ANSII X3.26 - 1970 ;U ; INSERT CHANGES HERE. ;C 	.ENDR                                                                                                                                                                                                                                                                                               3 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]TRACEROUTE.EXE;1 +  , nc	   .      / #   4                              - P    0   1    2   3      K  P   W   O !    5   6 Aכ  7 Au؛  8          9          G    H  J                             0 D `     0205        W                                                       
TRACEROUTE                             UCX V4.2-21    כ 05-13                      
               
       ?   !      !         DECC$SHR_001 O    !       
MTHRTL_001      !        
LIBRTL_001$      +        CMA$TIS_SHR_001    @(#)$Header: traceroute.c,v 1.17 89/02/28 21:01:13 van Exp $ (LBL)          dflnrvs:t:q:w:p:m:i:c:  %s: invalid return from getopt: %d
 max ttl must be >1
 port must be >0
    nprobes must be >0
 tos must be 0 to 255
 wait must be >1 sec
  %s: maxtimeouts must be >0
 %s: unknown host %s
  traceroute: packet size must be 0 <= s < %ld
 traceroute: malloc      traceroute: icmp socket traceroute: raw socket  traceroute: SO_RCVBUF traceroute: IP_HDRINCL traceroute: unknown host %s
 %s: cannot resolve address for %s
    traceroute: gethostname %s: cannot translate host name %s
 traceroute: IPOPT_LSRR traceroute to %s (%s)  from %s        , %d hops max, %d byte packets
 (loose-source-routed to %s)
 %2d          %d ms  !   !N  !H  !P  !F  !S  * *** give up ***
 sendto traceroute: wrote %s %d chars, ret=%d
                                    -  8  E  Echo Reply ICMP 1 ICMP 2 Dest Unreachable Source Quench Redirect ICMP 6 ICMP 7 Echo ICMP 9      ICMP 10 Time Exceeded Param Problem Timestamp   Timestamp Reply Info Request Info Reply Mask Request Mask Reply OUT-OF-RANGE packet too short (%d bytes) from %s
 
%d bytes from %s  to %s : icmp type %d (%s) code %d
 %2d: x%08.8lx
   %s  %s (%s)     %d bytes to %s                                                                                                                        %lu.%lu.%lu.%lu  @Kg|    -- : illegal option --  : option requires an argument --                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Usage: traceroute [-dflnrv] [-w wait] [-m max_ttl] [-p port#] [-q nqueries] [-t tos] [-s src_addr] [-i indir_addr] [-c maxtimeouts] host [data size]
                                                                                                                                                                                                                  ^D  VP^VԮnެScTԮ(Z|YTcެ[k  PWW1@  UG  T  XPW?SIWc   HWPPc   q = = = Z = = e }  =   -9I= .?PY1PWݳ l  Rbeݏ  de1PY1uPBhP1WƐ   Rbeݏ  d1;12PhP<PRR1Ƥ ?  Rbeݏ  d1 hP1 Ƹ 
  Rbeݏ  d1 P1 P1 PvhPZZ   1    Rbeݏ  drP
g6hPN y  Rbeݏ  d3Z+hPݳ  D  Rbeݏ  dTck
  PWW1Y
  ݏ        Rbn  ЬTxwSTSmծ    cl  ЮRPѢczW  mbPc'  PR6ݢݲЮW%  b5  (gcd  ݏ    Ѭݣ  P
  &<~*  Rb[  ݏ    (n  POX6  ݏ  }  o 'H  RЮSУ
RZ 2  ʏ  Pȏ   PPy  Pp  ݏ,     ߭<~  ߭<~  ~b  PsƈJ  ݏ,    < @߭<~<~:3  PƠ  ߭   Pƶ  ݏ,  .   ߭<~  ߭<~  U   ϧPѭH  ݏ    MRЭ1	ЮRТLAЭPC;PPѦP*ݼ>  Rb
  ݏ  #  զPq@~l
  P
  ݏ  
  C
  PS*1ݼ(
  Rb^
  ݏ  
  гRbPH f[
  PK4
  ݏ,  {
  ^ЮR(n<
  PbZ
  Rb  
x8
  Rb  rƈ
  Rb  P%^(Pn  Pƨ  Rby    Rba  $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          {n{2 $      UCX042.B                       nc	  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]TRACEROUTE.EXE;1                                                                                                                        1W  U      Y  4  [  Z   {   |WTԮ,ݮ$eԮ017" ֮(ݮ$ݮ,$PSiPS1 ݮ(SDP1 kPRѭXSjЭXRePP / ; G  S _ w?PRReWWTeKTe?We3Te'TePS!iPS1-SS
e֮,A  Rb$֮0Ѯ01

  Ѯ,֮PԮѮ
eWTRTR ֮$Ѯ$1Nծ	n
  nP< ^U {
  ЬTQTP R	RP	Q{RPQPQSQTP RRRPRQPQ{RPPQxQPPCԭ|~TT	  P#߭ݬ < ~	  PUUP ^W2VTdRUb	g b
<~	  ScPe<lPP~cPgP<P~cPN    g$		  PSSgXS/   Y	  яA   ` I	  3`R*PSgR  	  P`  RRP ^  ݬ  ŏ  Q  PƏ  PQPRRP RQQ
PS	PA4SSPP^YЬVVn1wPЬRRRxRWWRVR1"ЬR^(n  PV]  n1+PWWVf[U[RRUR[RRsScRRRxRRRSTRRV	RRM<~  <dRRP7<qRR~  <RRP[RRn1 URRn1 P1 WЬR^(n2  PެXhɂ  Zj^ЮR(n	  Pɔj[SSx~PSɛjShP݇Sɸ  SShn  P^XЬYiRRRxRRR^$ЬR^(n  P@  6PЬV^(n   PW^(nK  PW  ^(n%  Pݬ    ЬPЬQ¡
`@B a  ^ݬ  PRRRSݬ  PRSаRbSSP< ^T\Fd>\@~s  P#.  PRR~r  SHլC3  PU0\%.eG  PRR~7  PbeSSS	  TPެSc  Pcˏ P~cSSRˏ R~SRˏ R~SRˏ R~`s  SSP    ^Џ 쟭xT  ߭߭蟭߭  ЬPЭ`
ЬP`Ԡ   ^YWUe=gSS޼RCbScRR-RX1S  PgX1rgP޼QeR@aPB`SSS:Sݬ  PRyK  ݼQ    A    S6    
'    "  egT޼QePDaQ@aPTge?X1 PRbPP:1 ЬVgPeT@fRDRPRRgBfRDimPggZJ   f        S    
q    l  e?X2gRgBfie!PegT޼PeRD`PB`ReTgiSXXP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @   @                                                !                          x  H	  	  	  	  	  0
  	  	  H  	  	  h        `  8	       	  (                 H        8              
                 @                                                                       DECC$SHR                                                       MTHRTL                                                         LIBRTL                                                         CMA$TIS_SHR                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 7 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1 +  , c   .    / #   4       v                   - P    0   1    2   3      K  P   W   O    5   6 a qכ  7 !u؛  8          9          G    H  J                         0 D `     0205                                                          UCX$ACCESS_SHR                         UCX V4.2-21    !0כ 05-13                       i    
       j   
  l     y      {     }   
       ~   
      B           <    
          
         
    !      !         DECC$SHR_001 O    !       
MTHRTL_001      !        
LIBRTL_001$      +        CMA$TIS_SHR_001     a      -  3  < d6  < 6  7  < x;  v    |     r             -  21 ߏ                                                                                                                                                                                                                                                                                                                                   VP   S^~ݬ~ݏ  A  P*nPP$Џ
PЬRcݬR@+ Тcδ^Ԯ<Ԯլ֮  P1 
  1  {    @ P<R~}  PP~R  P P[  xPЮPM  PRЏ
1WЬYPPQIa՞I  PP      
  '      <   Ԯ(VV[Ik՞1mI<PP Ik<WIОW  Ю  ~@  0<~  ,< Z<t  1 ԮZ֮Z~J  n, n  ЮP@-  4  Z  n  ݾ8  ~PL%P`  Џ"
1
Џ"
PZ{Ю(  8V4<C  <WX]   IZ)    <  <  P(<`(Ԯ<#Ԯ<ЮЮPZ`,IО$<$Vծ(
ЮPRPP(RP0?PRЏ Ю1,(ЮPQQ`QV<RQQQP2PZVZ[2PQQXW, n Pf  D  <00X1 X(X@\  H+ Pc    )  ݮD~P=î<WPW<6<[PPFXF`@FZ[(<DjSZX( 0XeЮ(ЮP`<4PPIО$I`W$P ^Y~ݬ~ЬWWݏ     PZZWgYZY1 1  
Џ
Y1 ЬR}~R;R |!<bV(VVF}Z Pnвnn[k ^ PXPI  H`
<PXP}~ %S PYYWЏ gYZP  [i  Z  Y^XլX  P  kGj, n jݬݬZ~  PXX1!j
Џ
^  
ЏJ
ykiiinlЬVVhݬ6PXXf  PР  <PPPЩQ)Pa3QQWPPRAb՞PЏ
fP@gAО@gP, n  T(T4THQɐQNPɜPݬa`ݩWTD PXXkXfXfԦPVPXXP^7  :  0  PР    |ЬWԮW֮g
  9    ,     VԮ RB՞1 ~BP<SSS  PЮPS~BPРVЦVJC  О  ݮs  PZZX  PѮ֮ZSRbVЮg1]PPQFa՞PYFЏ Pݱf  RYR[  
  @      ݮ  ~PZZZg  PЮP  (  nԮPP@nP?PnR[X1 X@X$8   <<, PZZ'W  k      ~PZZX@nlUY+TTPVPUeU e 	) (TRURY&  h    PZZ[X@ RZYY[X,[1   [no  Rn%  ݮRPZZ9J   )j  @f  \  p  ݮR~PZ  PѮ֮<nY[YЏ ЮZZZg<Z  PЮZP^      PР}    |Ԯ,լ֮,
#        YI՞1o~IPI(~IPРZ<PPP@  О$ Ԯ4  ԮPc֮`      '  ݮ,  ~P[["    Џ [[ (j`ЪnIZ}  (q  P6(( %jP<:  TPL                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            O $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                     A "     	       A  <!   <-    ݮ,:  ~P[[1f  PѮ֠1), n @Ԯ8nP`TTPnPXhTWTԨTU9UPnPh*~ݞ)hT@ Џ  T` UT@TV 1 UU`1 VL  PH  8D  U<H  LLD P00_  k      ~P006WT.T@)TPnPX h8)8PT@ Џ T?UJRRPnPXh~R@oh  Ш  <PVP<HD  LLD P[[$S      ]  ~P[[ <` RvN  `
     \  ݮ,
  ~P[[  PѮ	֠Y[,[P<`[[P   S?  R^@ݏ   ϡPnbb@ݏ   PnP  ^ЬZPp

nnݬ|~ݮ 
~8  PYYмPP;(  
ЏJ
)ݬZݬXPY    PԠ  16}~}~Z}~z  l}~}~ݬZ}~D  R        }~}~ݬZ}~    }~}~ݬZ}~  PY1 լ	[ԮЬ[|~[ݬȓ  PYYkXȰW V Ȕ P8V W$, n gXЬRTRTR|~Vn  PYYdW@ñ  PYYQ
Z~}V~E  PYY;<YY0S~V$  Pn	Џ
YV  PYYY|~V  YPW~[Z  PYYY~H    V   PYY(SV  PYYTR  PYYݮݬV  PYP լ<PмP RЬScգPݣ<c~  PУ(c"RլPP\^ЬW   Ч$Y($gPРV, n Ч,TԮԮ* 0<PYP!2X<XPYP>  [[
<PYP   U1IRR<RPPY>  PP5Э04(Z<RPPZ~WF  PUU8" Z$ $( U ) $Џ UU
Џ  U1  1 "X  (P<XQQP$[%'  $<P<XQQP  P) $Џ U" <P(QQP$U<8  @a.Џ U $(<  ) $Џ UU1U4U1 P<PXIhў  [[XY0 PP54<Ү'[$~W  PUUH(Ihў
Џ  U1 Џ U 	  Z(P<ZPZjj[" <R(SSR$*  $  $(G  )BcЏ UUծj	jЏ UU105U4Y$ UP ^,_   (Ь[<PPPQA  ОRPA  	Q Q	PWRPլЬԮݮݮTd  Pnn1оP8V R RXPQaXЮ$YԮ $k ( [knZW G  UP`Z>Ъv  Zs  |~H`  |~ݬ0PnnhЮ@nna(kj[nQRb
TTTSS Ck՞S<*TCݞCk<~*  PnnSb Snn|~V`  nPݮ~ݮ來  Pnnb}[b$,ݮVB  PnnaZ[RV  PnnV  PnnpЮSݮS ~  Pn @  Pnn+= )!ݮ$@   Pnn	n VS  Pn 1@n~ݬVw  PnPЬZЪ$P<VPVQ<fPP<RRP~n[ݏ <Q~ЬXW|GrGf
Џ eЬP.РY<QP@@ [
@[QPޢh[<P(hFGfhGЮhfhnWЮP^ЬV<U$UЏ X<SROB@ DBe=BeBU< : PXX;ASRX(Ц$[nЦ,WЬ$[04<UUXX1 ~V"  PXX
X41 k<YT1 D@ xDeZTP*@A @e@e@UZYPZ DeDU_ )
Џ XYT1F1sX(n[$4<~ݬVϻPXXP<SS<XXPѬy   WDVWVQ0AV'AcASTЬR<WUDePPXQ^ЬVЦ$ZZ[k  1 ЬXP  ZTUЦ,W<Y  0T$  ~V  Pnn
Џ  4Ԧ8%T-h dEЏ 4Џ P[0Z$Yz  PЬWЧ$P<VPVYXլ
	X(S<YY<W<XQQ~ռ<gT<SPP
PPSTPAXAf<SPPJPE~@RX:@U@+P A U<P~@RAТAfUTPYQ|PЬXШ$P<WPWP[gZ<P~V,FgYY[<PFОQ<ZP(YaG`F<ZYZnVУgZggP^ЬYЩ$Z<P<[)ЬU<nЬWTTV)[EVUXAnTK<PVS?S:~CPTЬQ<UPPRAbTAT
RQX
UPVS<PJ`Ш<P(J`լXЮP ΰ^,   8լ
0Ԯ0Ь8|~ݮ(ݬ݆  Pnn1оZʔ V X8W ʰY<PPYЮ$ЧZV, n i
ݬ~y  Pnnv<nnk[~K,վ,'~KP
(,@"(,8[ЮDU@Ю<(8$  QeQ@<PEQЏ
nnq<SS  RQ'QUP `RR	Џ
nQ	QSQn-8Y~Wq  PR	Џ
nW  Pnnn|~W  1  2P` Y~ݮ ﷥  Pnnn~ݬWJ  Pn1f~WX  Pnn7|~@V  PnnЏ 4n~ݬW  PnnPfԮ g  <k,~W  PnnH|~@V  Pnn0< PЮQ$  A`Џ 4ԧ8Џ nqЏx
Џ  4]Ԯ,  <8~Wo  Pnn"|~@V~W  Pnn
Џh
Џ  4Ю(<$8[441 [f[@[ [< T~W  Pnnn|~@V  PnnV,-$(  D  Dn6[&< PЮT-$(  D`Џ Џ n/Џp
8% [[<[PE`  Џ  10Ѿ ѧ8p
 P1 <@[([DP  KPP0PPfP PP@PD< T~Wק  Pnn@|~@Vo  Pnn(,-$(  D  DnЏ
8RѾ bYݬW  PnQaPP@<V<@PPVScQQVP`Y$Џ  Wʣ  PnnnRէ8
ծЮ8Rլݬ︛  Pnn~ݬW¥  Pnլ"P`ծPѮ`ЮP ^լ
(Ԯ(Ь0|~ݮ$ݬI  PZZ1FоX V Ȕ T8W ȰY<PPYЮ$Ч[X, n iЬP РP`ԮԮ$    	֮$TTЬXP@h՞@~@hRPR<Z
ݢ<b~E  PZZw44Rs  PZZZZX
X~J  PZZA<Џ
ZZ2 XW$l  P	Џ
ZW  PZZZ|~W  ZPݮX  PZZZ|~1Џ  UnԮծ֮
Ѯ[
1 54Ц04<
RYR0~WƤ  PZZ<)0B3Ѯ[
Џ U<P) @i@nT!ЏK
iiЏ  4ԧ8Z54Ю0iTz, ZJ<[~W4  PZZTݮ,~ʎ  PZZ:n)KKiЏ Un#Џ UѮ[

	Џ UԮ,UJ Y$Wc  PZZU4i
ЏK
84Џ[
8*Z !$Џ
4Џ ZЏ 4n8Zլݬݬ  PZZݮ ݬW(  PZP  8^ݬ<P, 0nP`H /nP`P  PnV(   ,n  Ԯ 2      ЬR	$SԮ$RS,~ݮSݬR}  P1 bZ8Vʔ W WʰXP`XP`R$ЮZY[[RݮV  PQ
R~@  P8RX~Vh  P
Џ
V署  Pݮ|~V怒  ЮPX~S  PլЦ4PЦ8`1yR@f  PЮЮ3Ѯ )  PQPaЏ Џ Џ 4jkQPaP`ЮԮHPX,W<P,P,~(Pg,PPWV  gn:  @T  PԮLXnk~8ݮVPЮ&<~ݮR<b~@QPЮR<b~VP-V  PլݬZݾ$V  Pݮ~ݬV   PP^ЬYЩUЩ,VЩ$[T /PP54,0ZTjԮ~Yϟ  PXXsQP-Q  P	Џ XX  7<  W[W<QP!@*@g@Wn QPP`)dX	Џ XЏ  X
XЏ XX41 Џ  XЏ  4<JWWT<Lc  d	^  dQXN OPP5Tj~Y؞  PXX	Џ  X)dGk
Џ XX4)dGkXhT PP5<
UEj~Yy  PXX	Џ  X%QP-Q  PEkW)dgЏ XX4XP,^, n ЬYЩЩPP PnnЬZЏ
PjPҮ|VŬWPPXhլWVVV1 n'Ѭ[[ݨ<h~[#  P[[[PWj 
 Ԯ<P@
PP*<P@QQVVV@PĬP(h@Wj W9P  l^,   Lլ
լլ<PԮ8PP8Ԯ4Ԯ4xQQQa)xQA8P5xQQQaP`֮8xPPP`
ЬPP8  	00@~ݮݬΘ Hw  P1lмV8WƔ X X ưVP`(P`(, n @ Ю$<@VfԦ[81[[P@  О8Џ Ю4@C  QѮQ8 @c  H8 848Џ 8 8#@0   1{ @!  Џz 1X889P<`$Z148                                                                                                                                                                                                                                                                           EW $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                     k "            8108ZPPYЩnnP<`QP!nR~@bSc88	QP8ЩPPPQ aPP
YԦ  PѮP
9Z9,4VݬǕ  P1Ԯ,nЬP`8WY  PB88Џ 4Џ ~ݮ}~ݮVLW\  PhnP<`TSRnP~C`QaEC <R:*RB QQ0:%RB QQ"~WԚ  PWC  PTS
1?ЮP~@8Ԧ9Ь 3d < Ό Δ ΐ Ό VݮݬtM~s  P8fW8  PF88Џ 4Џ !~ݮ}~ݮVLW;  P841 P8ԮnP<`TS6nP~C`Qa)C <R:*RB QQ:%RB QQTS1?Ш<@<PP(P (ݮ(ݮ  nP` Цݮ ~ݮVWL  P WP
Wﻔ  PЮ<@
91$Z1ݮ~ݬWÖ  PЮP_  YЬXЬV(hfԦЬP (h@
ЬP( @,ЬWЧSiP(`c(hcЩP(`cSg(g'
P   ^,(֟   X PԮ  }~08q  Pnn1Ю XȔ W8XШ, n P gPg  $Ш ,  04  56@DHLШZjP<P[VAF<Y, n  i iFj<FFV V[F@[V,͸0p48Ψ <Ш[<>׮V1LЏ
n<QPR~@bS c	PnQPn1<PQ~@aRb#Q~@aRb<PQ~@aRb<ZP~J`QaF,Y, n d idiFF	F
VЏd d P~J`Qa.Fk E)C	
ȩVHF VЮP@,PV F    F   
m  YnWPnnWPnn|~Xu  nP< ^ЬTլ<P~T}~ݬp  PUUUPdSÔ RS6   $RPUUcTݬݬW  լUP <    U^ЬT<PT(Q  PSSwdR	 F! 	RO  PSP   8Sb<P$°PP	< ~e~ݍ  PSSdSTݬePSSP< ^~}~ݬm  P4мR Q U8TRPS@b|~Tԑ  (^ЬP<P }~ݬ97}~}~}~}~  g}~}~}~}~9  h SS   	S   oЬRL	@S   } ~}~ݬR}~ݬ	  }~}~R}~ݬN   e} ~}~ݬR}~ݬ	  HS  } ~}~}~}~ݬ	<(  #S    } ~}~}~}~ݬ	3  P[17լЬԮ~|~ݮݬHl  P[[оX0Z W 8VȰY<PPYnX, n iY$, n  ݬ|~V  P[U    =URP@՞~@Q1RPR~BP<~BPРSO[SZX
ݬXݮVn  P[[6<[[+ݬݮSVbW  PTլT<[T[[|~VU  [PnSݮ  P[[[~1 ըԮШЦXTV+  P[[ݮTݬSݮVz  P[[tUTW[
	ggg[[R-#{ P[[[լݬX@X  P[Ѧ4z Џ 4ݬVL  P[P<   UլмR RЬS<PcգPУT<c~eP9TTeP)У$c RPT"dլPP   ^,   LP



l  nլլ<P:PPQAA  ОR1A6  	Q Q	P,RnP~@c~ݮݬxi  P1мX8YȔ [ [ Ȱ$X$0nP`0(@   (WZ4Ю0$V<mԾԦЬcgP`WnP<`T;TUߥn~ݞ)"UnЮP`<gTg1 Ԯ, n @ ( ծP`Ԯ (j,P @  P @Ю4Ю4,  Z)  |~l  |~ݬ0P>Юd5ЮPZ@(֮ծ P`ЮPЮ@(֮1оЦ@ݬݮ(ݬ,  1USf 
TЦ	n	PPЬQAS\TծfB
Tf<@T
eԮ<
WWWRR 
RPPQaRR}W&RPޠZZj@<~r  PTRPޠZZ<jQQPZj,PSR	 Q<<PReRR`PPЬQAz  r  P9eЮ@
nQa$@$ݮ$Vݬq  PЬQ}4aPPݮ|~Y  1x<ШPԮ<PPZW81ԩ8T~YՊ  P+<ШZWݮ,ݬݮVݮ<Y  P [DЮ4H*Џ[
88Hݮ0ݬݮVݮ<Y`	g   <Hݮ0ݬݮVݮ<Y`	<  PlSШУPУ[kZWݬ  Vݮ@Y0  Pծ!Ю0RЦ8PPTP
P`ԦԮ<e1<ѩ4z Џ 4ݮT~ݬY}  PЮP ЬR<SP~@Q@baaSPP мSR8SУ,THPݬ~ݬy  PЬQ=}4aPբ
Тԣ8S  PݬS܇  ^ЬZЪ,YЪ$VЬ[f,PVЏ n
1 <WAG@ 6nGОTGf-F Df1 Ь XGf(DfGfh WnЏ P 4ЬRbЏ  4Ԫ8,~Z:  Pnn)}~ݬZe  PnnЏK
8$nP^Ь[ݫ,Ы$VЬP,1 nP`nP `4nP`ЬXhЬZ(,Џ  4ԫ8~[  P1}~ ݬ[   PVЏ 
1 <W3G@ (Լ$GОPЬ YGf(@fGfi WЏ PnP`nP `4nP`~[  P(}~ ݬ[   PЏK
8ЮP ^TSdtP`
P`SaP`XUIUd=ЬPWЬQ<VP#PRAbWAWRQSRSbVP PPXUSPЬWPU<Y$YЧ$[ЬZSj<nxnP@dVV)Vjk.VP`-&e	P`	Џ VVVSV1 CX1 <RRwBm<hШBiBYV("p  
`  VVV PVVV
RnRS\VV
W   ~W  PVV1V4VPP$^ЬP WР<YYg1 Ь[ЫVVnnP1ԮY
<iYI<iP<QQPЬ0<QPPQP~@ZjQP<P@ծEnP `
<<`nX(ݨݨUnPРV7<  X1 XgXVVP}P`rXg Ԯ<[ZNJ:Ji<JYծ3VP `
<<`VP(J[ZVPР XcЬX@
Ԯ)<Iծ h
<<h(ШЮP^լЬnnԮ~|~ݮݬt]  P1 nX0Z W 8VȰ[<PP[XY, n k, n [$iݬ|~Vw  PYZX
ݬXݮV_  P:<-ݬݮ@H  PSլS<SЮR~ݬV＀  PRPݮYݮ|  Pݮ~ݬV  PЮPըԮШЦXSVx  P9ݮSݬYݮV
l  PլݬX@u  PѦ4z Џ 4ݮSݬV  PP  ^լЬn@nԮ@~HD~~ݮݬ[  P1(о X0ZȔ Y Y8VȰ,<P@,<[[00$$WXЮ,$Ц , n ,Ь(D1, n ݬ|~Vt  P+kԾ0    Ь$Pk`QakkР01{ԾԾ$P~@Rb#~@QR
R$PP`оRS
ݢ<b~2t  PcݮLRM  Pվ$
ЮЮ$Ծ(ZX
ݬXݮ(V]  P	<miլZZPPQa:ޠQQa(ޠQQa@(@(gZgW8Ч<ЧD*&ݬݮ ݮVyE  PZլZ<P`ZZkkݮ|~1CԮ4լ=֮4P`1P`'Z#վ$ݮXݮ(Vs  P1 @ZZլZ<~|~V|  <P, n Ɠ  ~lﻓ  ~Af  P	ЮhЮ8  P#َ  ݏ"
|~V|  Џ"
PkԮqݮݮݮx  PYk6F  kk)Џ  4|ݾ0ݮݾ,ݾ$@ݬ9  P4Zݮ~ݬV|  1DըԮDkШԮL    MMЦXSSS@|  PZѮ 
Ѯz ?<;վ6M2X$T<d~ݮ$V\ݮ$ݾ0o  PЮ1 Џ  4ݮDZݬݮݮ,Vg  Pe&L
ЏK
8,
Џ[
8ЏK
8
5P`,,'4
 Q<aP@,0~V{  PM[k.()%g
<Ю4ܛ  g84ѮݮXݮ8VPp  PѮ.Ѯz 
Ѯ (Џ  4<(8ZNSKP`R(<(QP
@<RQPR(<(88<PPg1"
ծ8DѦ4z Џ 4k-4)Џ  4|ݾ0ݮݾ,ݾ$@ݬ
  PݮZݬVy  PЮPH^լЬZHZԮH~P(~Zݬ.U  P1j[˔ Y Y8V˰(<P@(<P@<<00X[4Ю($Ц, n (
Q<aP@(@, n լP`
Rb<~?n  PIԾ<Ь$P`QaР<"<XѮX,XP`WԮ81 ԾԾ0P~@Rb~@QRR0P, n h                                                                                                                                                                                                                                                                           )]/ $      UCX042.B                                                                   |it;B|ct;1                                                                                                           2`!            TX&ո>K	#Sy#
&s8z~BEW+<]1ܡ`ctJ`x#TZgeSX?Q2&9/9 m4td429m{RSS)˜)9|iO/4> =уGdE4&+Ad_4VglҲvQ/T`~\jiJ=nȑ8,ĔFIdobv
Ƹ1`#me_$-t_BDaoV0J2pD~,T@Je*/~Vl>\4o-Oɀ4Kp_Rʣf<,<ȼm|
vUZ<W3k4V4A	~>JYѽeh6  D8lӕgRO)(_%"E"GA;RˉVw"]y[qa[Cn
7,qtEQ?s+ƏO]OlL*+#jŜoHSځZVZ"'Noid!-/vEp;Epo yW~=%y$N9:  ;:[č'Jm-
M¤Op#{u>">!<-Km{sB;,\JAA+SeGȖf\ƃٍsJI) ep72@	ˎxt--x Ҋ̴ܤ>/-^hJ3h5vq+Bc
NDe%`JBx'._.Nf.pT}?j'ײ\@|!A02B[1s9jVya\HӨT㍀&
l~I^Jz$8<0[H>?kՀɀZt,W_")x7ѥ-NsѾsv`4UgjvRX>.sq}$D>ip :|zpMA7Ow${F#-( t}cTwKrߢXYP?Ul/0P&X;	Ӧ2T^sz*sY.9 Ď,(CЬ&[7MOPp]˧&(qqr<H>}$8kHh\ yH g٦#ⱓ l"Qq/^L|`oLܑjyl/$^fA@M\x[yjnDe?1՟sy	>|n&{"AO2D+AciD=4IcUlw@(;(+Ɠ@(<-*8Q9%©7'ӰQ*ag*OBqb^82?_lb|<u/0ᦻvkiVXV\FSglp_{R6U4fUy4m%Kdp%>Wil'ZW47qn)D]76hXpWq J"taUI5bd}xɶ/Ӹт$~JDHvk݌EuA4;_B}ێ^_
&`i韕sjeRߔرLj'ݲ'9Zj02jI;6zT	䐗LMs&G0Ct{?_yQnK&o$n1vi3:;_hKN	gv}fKĎK-W Wc>: izכ))磉NN$*2]dbc)O
@ƬTӜd?f,ۭ-]A̶ơ'|l
e"WTƊlt=#EװmBͿ~%WT5Z+Mtwrn䭧<υ˃ȝh0yC"ς: 3cg]i/CɼWzy
w$jU +j4Ku[-QRA:>Z q P<F"y8ܚ{-,G	Po_@hbXr6cײ5K@UQ>`G2yGxQDii:оݤ<2t:v9 }7B'q%XlSKcP(g:Z\ysijLne{c&=p@&pR"E '=sBzho.7:H(4smߞ~)	+2Gg6P&="_;df$8K^8GTZvfFV\6^ݐ*z7gϐ?k5QUxTv4!hgZ".=3<?wm;bQ8P+paD҄8i|u3d͘xğϮETtS䫝3t3g
^lʆkB}EmM+(/D	O8J2ѕlfܜ
vwFY!ry˩NvaVI͸`ެ U ]`-χ
zcO O`V.`dGЋ?1&osu~.פ;#$rh|?s"}#U-{5P %hx$a^8q9o52a2mj
9]|]1ZzHJ4F:W#Ns㧻uW8@
Y=#,kJ=v>&N;4թrKࡸ(=Nͤԑ^ӷhO읺nu{J	ʊǏ|85$`lpeUUFJ_mڍH/Wג6?7.r	*3/8Ȁh)C/8l?|wg*t aS|.@R`IP\3S(isJ4*YoҼSO=e)@9E 5>P>_`;3#=T8mOJbsa<KXu̟C+3f+@mog9cLHFȦVu*1&X LMXۘ[L$/0o\
@J*C|vMcāYJyb@%,:IFz{ r˻*v+Z|!4u2\oV`rwv'+IVm狮i$wth"pK{x}ťw8Vkh6ѐ|*]MYFcW/]IM(rտ쎄!m+ù.aaډ2``9qOexPlt&iyh%5j%͛}ө/42`Kv*hR~apFXgeLGJ4?eQX*BȒB93L<HjYZ2f{Fny"rU0Z5[Ў_`EՓ9,P8 l_\(TXGK9myg7]#-qي~eWɧF~jT~"X<j;7B4lyYe?#f2gplEsi47-{TXǣF@yڞnXRhnΠ W&H]&S0f^oZ {}9Qa>6~y6/	,`ؚNX
vx7(_nbH~6R/,
v0X.`S6n_	9	;[|#r#YId)͇- e6].dP(~1gl?ॴYЋ]ZwN`_lwrF`p.\~V%MM(`yOd!vUT`>G{m8GEJJyVrD+]poDEz0;	0mVq$ DJH";yۗ(=
Uje{|&jZ
T2=$}<tIi
!r%A>8׊Ⲏ)WO9q#
fud ˛"JH^f1믊b+dI豽H.a0#
&FR-mҼP#hq3-'x8nµ #|.[yRk9m't{ 
픡U	!JC&%rpjfX䧀qc|K,*fP%6
(deW}d^aem^]K2-kI/du}Hq(̥/ѮCIǶ撿2'KcI+Q*NQ)T'㴤ZP
r̔!Ƞ\WkǠ	4
y=Ah "A.
lAxdS`sFt{#F(_,~qBLkUXEѿ
=O9;[Q	[QȒܨMpnșp5P;zo4aτ~Є/'ua,e#WCih}o1;zABľ3{'ǲ_r0)KB|-nw[=E
?ۑȁ21]-ȝ)IBw*i/K8x^!nHYeڬ}:SqT	K߭i1i	CBZڙ p27"+4~6B87{UtݭVG+=~Rt&_L'j᝹yJW7%\6
r_Chfxs1}?
˵Po,*-DME*̷}g)M{BAL=%0wz;qofDa$m_
",X;(0a*>?Oa!6`ڐS{s7#D3vL-624i}z	p2ڛȍLJqY}M\{kp	DÂ.;H'| &ּXyqd2]	Kȿ41^Aesj9{Z:Ήe)(rzAYmSӑULwI#УNT'8
<x ުOed^(2a	p39	m{[<:`w^TpuZJevI<vaIz)Y5˯dk]Rk"3E΅K	{MMYվD Iu7%O|edF&ӭ-@q)4
!Ⅽ-lƵdQ	8-ې&4{FuTX1`t輻}"H`/'lx(*l-*X7Ł"a4~PeNY?Dl#]HgBQi9|#_+XV
iI2%XMqkWgnQr>^y
Y@JBFfFմe6&fax=aQruuOŖ c$z\tWTi
Eϴ|*@UO^cDn? ?Fv)`q`8wˋ:D؁ߟtV+5*	
鷰rH	hL?X`vf3%&ե% m
wHE'Xgĉ6#s}S%C+Rwn*t( ;E_IQ_o' 
@:NY0Uʭ6"2,)J_]oacգFn~*DxI%pI)nE,FHXri`NK]9TFkaBba`l ]/Y,f[rLjT%|:ѝhG0l'@XaoHj~ҏ6(ciϐZ-%frDݲ0+hCӇ/u}FQZ2*޳Ύfi.s:*d-7GRG4e9JnYaHZgi\;N1³h3IS'yi{(WM͑"M/ g(^,!,:ZG@:(|2#bV]%\l*dJɝ)H;4 My	N-޴($.`tQھn]1:'| |꼄y>g9rnNÕ፽˽<{b"`Vq@TsR15raR9:"gs7)Qam1B} zR{ϡ--dUoUj}etmVy$A{"R̸s2$H#i+~XPcqP'!:]w}
&\ܗ1IBYthWD|d{zP,릓~#rRױb5J@e:`e0Ɠύ"lMcNd^-œNi+N$onmVAl?se|н_$P/݊ُ[cז	-E.}:
M0QozV,mHAkۗ )F\#Ha%5)Q.W܄[<qA|n%m+Wj;/ɗy]fMA֝Pyԥ!;kN~:$7@,0kʰ	J5k,䲛S2}oIM
=p) TW"(w>5D`򛡲Ho	4W>'!a.vq61~yv4<4?Ma2bÆR7b;MhaS±>$HMfc%xT6!}m޳|qK)>TVΐ;5.?#ͅh@:A* nO?^qP@`mh
{3YEm
sRuv$,W8PvmϭFԥP̢$!SHORڎDjg~>r
MLccC-xl]r(iuXuQnN6Z>J i/YLR s~`G$whuD\RR|ArwŒ>Ca{¦#)K ?ٷV<2(**7?uqn[P]*
HM-s\g>k/oM` |QJғ-:jT!8. G:Xb(:io/pnHeǲT2k7NY7L,ugu1(Wh,(@BD#	m6oRseIlOᯞO'-
bC_= {R"wgahވ?|-2+ڪGmg6?v= ϱ jf^L|w]a?d3,I @z!V͒
(AR@sf{ w57KHÊTZ"(;QUj<)I:r5QvLէzE?Eڕ֚*aX_!p
ygXbxXkgQq fLW%N\&OL
#Yu>KVjc|Ul WތΠMJ@wo2Y_z!2]$bl%'Ӗϳ?~=ssIܤ|vu9J[Q0P;@̥ ??1\Hdc̸>>$Sy`Z0Aj\^%[GKqn ] <4	#"7>̢`G$*ʙNrtc(v%n$fЂ h#Z^v0 |
r9~@p_&/q[(RS98͏NՊ!-zm0X&0'A
,Dtzr蔍:V:8ؾ~/fU@.xUVmr{̓@0&^g~g3찣Jثҹ146vP|(	$0'I̗;QoveWp9G#-x΋L#?DTg▣>)2we^&wIBy֦ͤyӝuICb&<dnr&
zRV9ݑU~K:8053IN;niɹ<sp,P*TGwӋ@dt>w"[D!ExN]-
/AGcClLOC_MGBD2
eST/ MvUkMErETUR AEJ
YUyy*
dkgiuAXRSS; #     nam.nam$l_rsa = resultant_name; !     nam.nam$b_rsP                                                                                                                           A\ $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                     R "     +       оRP
ݢ<b~m  P\XTRF  Pվ0XX0Ծ$
ݬ[ݮ VV  P	<ݬݮݮ<Va?  PPݮ|~Vaw  1, n =  ~Δ 1  ~`  P
ΐ Ю8w  P#N  ݏ"
|~Vw  Џ"
Pݮݮ8ZDs  P[6č  'Џ  4ݾ<ݬݾ8ݾ$ݮ$Vݬe
  P4ݮ~ݬVv  PP`վ0$$ Ю \Џ  xΨ |T΀ , n ΄ LԮdԮD    	֮Deenվen$nЏz 1~V!w  P<LLѮ 
Ѯz 4e0[R<b~ݮVtXݾ0j  P1X#Џ  4ݮL~ݬݮ@ݮ$VZa  P1n-d
ЏK
8(
Џ[
8ЏK
8ԮLZP`JX1 P@PQQ PP, n h(@hЮ\,h~ P,\|[ݮ4Vj  P<TnP@θ QaZz ~{PPPZPZZZPPXPX<6nPЮ\@ (Ψ \\, n Z\Z\n
n0<|Θ gfЮ\P`Ю ,P
Ю,@,PxP(P X<ЮP@xPPP`gЮЧg\LѮ1ծ$1Ю$P@,, n Ψ P`<ݾ, P4T<TQPЮ4R  B`PTQP(T4Ψ x$~μ n(,Ψ Ψ 04L1 ~VWt  P.ԮLXxzЮ\|T΀ |[ݮ4Vh  P1 Ѯ $ 1 ZP`<TPzP ~{PPPZPZZ<TPZPQQXXPΘ Ю\Μ P\, n Z\Z\Ю\Ծ\88f~Vs  P	)Ψ @
Џz @` <0X`h ~ΰ $R<b~ݮH	7  P1Ѯ $ 
Ѯz $1<81ԮdDeeΚ Џ  hQ<aP@վ	(Θ ޜ , n , n Π DPd$X`h Xΰ |~	7  P[R<b~ݮVtXΰ e  P`#<`PxP$($ \Ю\$P`Ю8<Ѯ $ 
Ѯ  <48Џ  4QaPX`'Џ  4ݾ<ݬݾ8ݾ$ݮ$Vݬ  Pݮ~ݬVp  PЮPΠ^լЬ(Ԯ(~0~ݮݬ^L  Pnn1rоZʔ X X8Wʰ<P@[VZ$Ю$ЧY, n <
P@ <
P@n, n լnP`n
Rb<~e  Pnn#<YYnYP`P`Ԯn|fkP~@Rb~@QRfRkPfRM
ݢ<b~e  Pnn1eݮ4Rg>  Pnn	n[nЮЮkfn@
ݬZݮ WM  Pnn'<nnݬݮݮ,W6  Pnnn|~Wn  1ݮݮ(ݮ%k  Pnnn~ݬWn  P4PԮTP`V~Wo  Pnn~ݬݮ0ݮ$WPZ  Pnn1 
Џ[
8ЏK
8P`BކP PQQ PP, n 8( 88 P( zЏ  HЮLLZݮWc  PnnXQa[![<4PzP ~{PPP[P[[<4P[PQQYQY<n(PfSVf[V4nV5#4Ю0~Wn  PnnԮUP`ԾnЏ nTJ4PԮTԮnYHVLLZݮWb  Pnnn $ vQa[<4PzP ~{PPP[P[[<4P[P<UQQPPY3Q<4PPVf[VPV`fU#VD`TT   <n/<4PPVf[V~Wm  Pnn) 13Џz nQTxTX(X`fVP@hԞPV`n $ 	n  <4Џ  4QaPY`nn~ݬWk  PnnP0^ЬYPWgQQ4Џ  ЬZԮ$Z`֮$
ժЪ,MЬPЬPݮQݬ8P	P15ЏÄ
8$
Ю,ԪЬXPVV[Hk՞ʟHkH<PPBHОnЮ,PРԩ8P@Qc<Ua ngJ֩8P=P1 HОnЮ,PРԩ8ԮЮQAP~ծ<|   n`(ݮ( PPЮQ}  A`PP豮<( g֩8Ѯ  2PPncuP*о,nPnQ|  A`PP屮nwP1 $Qa
Ю,PРaaa	Ю,PРоnn
Џz GPnQ8|  A`PP屮<HОP( `,Ѯ  ЮHО 	Hk VЮP^ЬVPP`XXЦWЏ  4լ(BЬPP(`,<
PPRQ@ao{  QRQRP4Xݬ<PA4=ЏÄ
8ЬR<bТ<~ݮVr9  PТQaP4P  H^լ<PլլPԮЬ$Pа РԮ, n ~<x
~~}~ D  Pnn1мV8Wư(V1ݬ|~W]  Pnnwݬ|~WF  PnnaX|P~@RbBQ~@aScR&PQQQaQQR
QAbRXPծ
Юn1;Ю(ZЮt
Z ԦPP$nl
Yi\
[[Xh
y  n(hT
n4Џ  [Yԭ쟭>  X  j  ~PnX;T
XhT	~XW?  PnnXX Pn	, n hnnn|~N}~4ZݮݧHݬ  Pnn
Ч4nn$<n %nz n4nn~ݬW>f  1$$Ю([T
Xt
$:}~|@ݬ  Pnnz n4Ԧ1 nZZk, n   ,	PPjԮ|Џ  DkH,LЏ PPTԮXЏ  \4`dԮ$ԮhHPЏ   "|~04Xݮ<~	lPnnDЧ4nn=l
Yi#i)4ˀP`n@  Pnn1X@ݬW  Pn1 XnЏ  4Џ  n< Цn[զ-|~~4ݏ  PnnЧ4nn	 {{  nԦn&ݮXݮL  PnnЫnԦ>{  :4ЦZjԦ1M@  PnnX@ݬW  Pn1 4TЏ  dЏ  nRbOT~ݮ4ݮXPnn.d+< Ц~Ю0SSW4  PnnGУb
Ц(bn4d+bZjbЏz d@  Pnnbnndb~@ݬW
  Pn14[Џ  kЏ  nYi1#Ю(X, n 7<h(tԮ|Џ  DhH,LԮPHPЏ  02|~~[XݮL~	Pnnk
Ԧ1 ,thx<,PzP ~{PPPPPPP<,PhP, n `<,PxP<QQPHЏ D|~ݦ[Xɏ  L~~	TPnn~ktЮHZЧ8QAjЮPPQ@j@@QPШiiiZjԦiЏz k&@L   Pnn~@ݬW  Pnn4ݬɏ   ~լЧ4PЧ8`nP ЬR$5ммSТT<QQP
S@dPPQ  SAdP ^ЬQSP	P RV8UN<cTP	ݏ  4PWЏz P
TCP`ЬPCdc~Ua  PWW=n#^  UЬPen`ЮԠЏ WWP0^  V8	  X(  h(
, n $Џ ' Џ  n
@WP	  Z
WPPVF|~~Z8Xݮ~	  PYYЮ(YY!Y Yz լ((YPWWWZݏ  PYWWfWJ[AWX7
XPFZ
XYFij ,	  ~(
j(
Fij,	  Z(
jFiXX[W[, n  լWЏ  (((P^ЬXШZмVYV[[Sc1[PP<`RR:ݼD  PWW	Џ
YbP\q  G`PPPFR%ЬW$$ЪѮ'ЏB
YRA ЬPԮ<`РW}R1 jWPG`p  PP$$|Wp  PnXnݮ$  PѮW0Ѯ  &ЮY RB 
WRD $WY$ծ c	<c<Y[P(gYЬPY4[PРVbP   ^լլ<P~4<~~}~:9  P1мX Y 8WȰ(<P@( X<Z ZZn[, n (Ю($Ч,0P`$1 ݬ|~WR  PNSVVF՞xVP(PkV'
 	ݮ,Wv;  P
<ݮ|~;[ݮ$ݮ WL$  P$ݬ$Z[ݮ$Wݬ	  Pݮ~ݬW3\  ЮPݮ ݮݬuX  Pݮ~1ծ$$0ըԮ0VШnP`  nP`VVԮZ1 ֮ŏ  ZQnQ<aPrnQaPhԮPnP`QnR<bP~@a,Q~JaR<bP@ , n  ~ݞ(PnP`xP@kxPQa@ZoѮЏz 1 ݮ$W.\  P?ݮ0ݮ([ݮ$ݮ0WF  P լݬXݮ4WP  PQMԮPŏ  PQޡSnS<cR!PVnQScnQScRP	nQRbP410ѧ4z Џ 4ݮݮ(ݬWKZ  PP^ԮH   W  ЬX  [, n kЏ 	 kԫ<P<`nP!@@Q Qď  QH@nPV1Jŏ  VYH՞HZPHP̞HɌ @(S|~ݮ(  PP`ЮSP`gPPgPPR1 R$ݬ|~$[ݮݮ(ݬ	"ݬ|~$[ݮݮ(ݬ	WPbЮS!VRѮ 
Ѯz SSHiR>   P)VR4PЮ`8PЏ
`ЮPRRV1>nV1PW   ZXЬYiЬV(fj(fhZ1 	y  Sy  SQAcUZUAeUPQ@eT@eTERDb)R-GhRGAGTWW<PRAPQWP ,^լ
լլ<P f   e    ~,P\  `~ݮ}~C3  P1мZʔ Y Y8Vʰ[P`[P`W$h  P <ZXЮ$PT(Чvݮ(ݮ$ݬVﺹPЧV
ݬZ@5  P<</hݬ[ݮ@   P ݮ|~V_V  1ԮnxnP@\nQ~APH 4>xnP<@UnP~@T)Uh  	ԮN                                                                                                                                                                                                                                                                            $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                      "     <       L((UNn
 LN 	ݬ,R  Pu(ժԮ(ЪݮVV  Pcݮ(ݬݮX@	G  PE 
ݮZݮ$ݮV   PվݮZݮVK  Pwվ$rP<`TR^RSޣPP Qa`GP`R<ݬݮV  !Cݬ~WS<c~ݮVPTR(Ѧ4z Џ 4ݮݮݬVT  PЮP ^Yc  i	c  iP<c  QQX<RP@*@a@QScXRPXX1 ZЬWЧ,V(5n@ZЦ04[(04ݬW
U  PXXS)Џ XXAݬWT  PXX$cb  i&(ݬWT  PXЏ  4XZTЧ$YЬ$Ю0[4n5~WT  PX(~WtT  PXY$ЬP
ЦXPt  XЬWg)<PЧV, n )fQQfPPQhP~}~H  ЧQa   ^լE;}~}~}~}~  }~}~}~}~  PY1 Ь[Pլ	ZԮЬZ|~Zݬ>.  PYYjW8Vǔ P P ǰX<PPXn, n hn$WЦUfQR<PPQPRݬ|~V0  PYYZTT
@0  PYY6<TYY(TSPS	V  PЏ
YYY|~VQ  YPZM  PYYY~ݬVeQ  1 VS  PYY{T~@
=  PYY[R/ݬRUVY   ݬR V   PYY%ݬ~ݮV/  PYYV*T  PYY~ݬVP  PYP^PЬSYYЬTWRB՞{~BQ[BZ<U<YVVR~FQX	~FQXF[)XP~FQ<Q<ZnnQ WQQW
<XQQVUVR}W^TRB՞1 ~BPUU)RUMЬSP Pn~@Q~@QVV@U~@QT<VQQPPTRЬPQQTTQXH@ PЬPР$Z~HP<WZWVFFgYFg;VXnF<QQ[~FR<nP@FY~FP[(YAjk~FFgVP ^լ<PPPQA\  ОRPA\  	Q Q
P RP0_~ݮ}~*  P1xмY8Wɔ Z Zɰ(YP`($P`$@   [XPЮ($VԮkԦԮ0, n ЬnԮԮnr֮nP`n~ݞ(4UԮ0nP`IP<`T.TUߥn~ݞ)EЮkP`Tծ,rn P @[  `PnQa	nPnPDXЮPЮPqo  Xno  |~D[o  |~ݬ0P
Ю<1 kЦ0[Ю-, n fծf f<@00Dk
SSSRR B՞RRF~BP/S ~BPݠB<~HB  PRk Rݮ|~WzL  1ZPVPݮDPݬH  Pݮ~ݬWDL  P,(4ЩGWGN  P47,	Ԯ,(4ݮݬݮVݮ\WIP1 (n<PP(P $ݮ$ݮ?nP` ݬ~ݮVW   P1W5PW%K  P
W#I  Pծ0
k	(41$,ѧ4z Џ 4ݮ~ݬW!K  PЮPЬPR[ЬPР$QUЬS<XQWP PTCgCОUC<VQVXPU1 
SST
PPQ<Tn<QZnZSPYYY<PPP@@YZPQ1 b1 AX<[PP	PbP[P<[SSgSbc~CPXXSb CWY#TP@X	@TnPT
PATWT<P~CPAРAfWSZQhP^լ
լլ<P
W  [ X  [ЬP(P~[}~I%  P1 мV8XƔ W WưZJZ$VYR
TTTSS C՞S:S3T$U~Cenݾ C<~>  PSb Sݮ|~$~ݬE  Pݮ~ݬXH  ЮP(ЦXJ  Pq<RPPQKJKОRPu<WZW<Z<PPZ(ZgݮW樂gݬݮ[}X~P3<~XPXG  P
XE  PѨ4z Џ 4ݮ~ݬXG  PP  ^ЬP1A P`Ԯ        }~}~}~ݬ  PZ^1 ЬR<P 
Z
ZԮ
ZR|~ݮZA*  PZZbPP=2Y  	ЏJ
b,R}~΅PZX  Y  PԠX  1Y#}~}~}~ݬ  1Eլ	nԮЬnR<7PPQA.T  ОSPA"T  	Q QSRP~RݮЬ[[!  PZZ1 о X8VȔ W WȰYQRQ <PYPYPP$X
Q, n i
ݬX@$  PZZN<ZZ?RԮ1RݬV]
  PZZVK?  PZZZ|~VJE  ZPݮA  PZZZ~@#E  1 SԮ-Ш~V/G  PZZwVD  PZiTTTS]ZZTծS~VE  PZZ?~ݬR@~0  PZZ%~VF  PZZV=D  PZZ֮Z~@qD  PZ[ЮP  <^լ
$ Ԯ$Ь ,|~ݮ0ݬ   P[[1 о X8VȔ W WȰY<PPYЮ$Цn, n iXZ(R
ݬX@"  P[[B<[[7ݬY@  P[[V=  P[[[|~VC  [PYZݮ(?  P[[[~ݬV[C  1mԮ( Ү  (12[ ծԮ(~VGD  P[[~ݬ@.  P[[Ԯ
1 (4,
nQ<aP@5nP`4
nQ<aPYPЮ04P(P~VC  P[[]Ч48[L~VC  P[[;74Q4P-Q P%~VD  P[[VB  P[[֮Ю,[(,4)(4~VYD  P[[VA  P[[֮1[~ݬVA  P[լ	PЮ`P^լ<P	!P  Z@P  Z~Z}~  PYY1мSÔ T T8RðW<QWQQP XQ$PTSUnuVYP@՞,~@QH 4YVPV
Y
 LN
ݬS   PYY4VU['<YeݬW$H  P[[YY|~R@  1  ݬ=  PYYnnV@У~RA  PYYs`~RB  PYY]R@  OգnУcA  PYY(nݬ  1  PYY/   PYnѢ4z Џ 4Y[ݬR?  PYYP^ЬZЪ0PЪ,XЪ$VЬYCN  PYPUn,P<RQA*A`APScnRQݞW$n	(fP W4(f<[[P[P04<PTqЏ  4TPIОgIО~Z#@  Pnn?)f),nn$~ZA  PUUZw>  PUUUPTT[P !  XP  WP  VP  U^1 ЬR<P
d
	Q

Q
QQPPR|~PQhPSPbSSeQЏJ
b
ZfTЏ"
JgR#`  ݏ   PSPbSS$R|~}~hPSPbSSe
eQfԡgլeԮQ
QQ}~ݬ  PuЮ   S   Q8R<FQ$QAG  T @  PP4լТ4ЬQP<6Т8ݮ~8  | ^ЬUլ<PeP ~~U}~ݬN  PVVVPeTĔ R ST,R0PVVRHPVUݬݬ  'RPVVdSPVVլVP N  [N  Z^1 	(jP1LkԠ~xN  PYb
YY|~~YT  PYYxЮYYqjЏJ
P ^  ݏ   n~jP`]  ԠN  jM  kM  !Ԯ~}~q  PYYYPЮP X R8WHT<FP$P@E  VSUEc3EcRPYYd?EcVW~p9  PYU, n  c@W7  PY|~W:  PЬV<PUЬWXWXUgfSUPÔ T PRPPUUbTPUH ~ 6  PfPUXUgP^ЬP'<XXYPH`L  PY   PРX`YЬP``Y)Yh P<PV"VTDYDP)Yh`Џ PTn$n Ynм W(YhgWX<YPzP ~{PPPPPPPWW<YP<WQQPPnPn<Pn$XFYFV<YPPX, n Wh<WPPX P^ЬP:3РXРXPXPZЬWg[<[PP[  1 ([<[ЮP@Qp[  Qh[  Q Q@PVUnY<VTP>[  @	PnTPYPUYNfnT[Y<P?@jQQY?@P)YD@	n<P<YQQPP"<YP@QQVV[
UjYPY[ЬV[f<P(g<P?@P<gQQV(YH`fլ[ЮP8^(,$ЬXШW>PPS@T<P R1Q,PP@ QP,P皮,P@Ԯ4֮4
@,,UE<[[EgEZERd1{ЬVԮ0V_֮0Q~APnn(P@QQޚ(P4Q@Q 	@U @R@fZR@E'[Ѿf$0_(P@f@Mc|:*ZkQQ:%ZkQQծծ0}Eg2u(P@ h$ծ[YZYծ[Z0C(PY	@f @fYY@Z@YZ4Y0@' F    F   Eg"Y$(4
E,, R1ЬQC$<8$3c0<<SR$SP@V@affT@afT@aPPRSR<$P^ЬYЩT[Џ
PЩXPV, n ZWG՞1 ?G 1 3GkSCC RR<TDR+ZnZZDnRBUTBBURRnTnRBRC
CRRnRRTTUQa)<UUSSDBRS TRCUU
<SSa TRPW@cW	}~ЬRRY{   ZqfmZ f5QZPP
@QPQZPP@@ PZTS$TP                                                                                                                                                                                                                                                                           r,3 $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                     > "     M       @Q@baaU@baU@bPPSTSؚP^ЬPРXРTQPTP<<LЬVЬRW15GGPPTTSB BB<BnBcB
 	D0	D0(8XDUU1UXUԮ,QUPQP ,PUP@<YY@h@Z@Ԯ@[4HU +Ԯ8ծ,H Y[ZUwB
UmY@gE Y$Ѿ$~Y[T:*ZiQQ[:%ZiQQ@ Y$վ$Y[[ծ@2:D 1[Y[HZHծ@Y@4Z4H44ZHZծ@U [
U< H0ծ,[YîXUPP0=Z28. DU"DPP<DPPUPPP<Ԯ8Z(XUxDf,PP<,P(0	D<DPDLW1PP< S  UTЬRТQP1<bS'AcReRR
 RAcPRRTS/<bS'AcRRR
 RAcP
eRRTSPTP^QЬWЧV<gP F`\C  
F`S  F`S  	QPQPЬX=g, n n(gfn^  PhhЏ
PЬPЏ `XP^ЬP`YРXQQQQYQ1 ЬVf[ЦWnZnZZ[Z<Pf1 
vB  
(YhgYf1 SY<YRXRGcb PpP $ e>CcQWQTBhgSr	Q  tY<YQHaQ  7SQZ[R[<[QQWHb(b P	P $ Џ
PRn
[<[QQ  GaRZfP`^ЬPݠPnnV, n Ԯ  nѮ ,Ѯ P P`VP`P`YYzY ~{PPPPPPP<ZIPPRn1BP`P@
PQPP<QWPPfPZYPWP@Ю<RPWP® PP  1XЮHHP(Y`Y, n ZZXGPG`Z1 PZW{W Gݾ"  P[XK@  KhOzX ~{PPPPPPP<XPP P ;(XkjZG$XZ, n jZXW($jZ2PPZ OԊnZZW<WPP X(Whj3Yu  P[P?  K`PWP<WPP O(WkjZ<WPPZZfмXWf?  HgGzW ~{PPPPPPPW P<QQP 1(WhjWZ, n j<PPZWP`ԦW RZG$GG$lGX[>  HkMz[ ~{PPPPPPP[ P<QQP <P([hj[Z, n j<PPZ[W}ZЮP@$@P Pp^ЬZЪЪ$YЪ,ЪHV, n P @8@<8^ PnP8(*N  )N  A( G F    F   i(N  N  V
(M  M  V(M  M  ^0c48PP^ Pn0i48PP] Pn0o48PP] Pn(OM  NM  |VP@N  [(k8] Pn, n P @(IN  HN  ^0c48x] Pn(N  N  l0p48N] PnVP@N  [(k82] Pn, n P @P`1X >X1<TS<QQEP~A`R bS5Q<PR~@bUeRRR P PTQ, n P @5P `X
(L  L  AHgM  [(kC<VP~F`QaP~F`Q<a$׮$$< V1*P~F`Qa(Q~FaR<bPYP,Q~FaRbPPC&0J4R~FbSc~8ݮ8[  PE
0J48ݮ8[ 1)P1 J(IL  HL  <<L  PP0Ю48ݮ8[ Pn0Ю488~j[ Pn0Ю488~G[ Pn0Ю488~$[ PnW
r(K  K  <K  PP(G=P
0J40ݮ08%  <0J40,8Z Pn8Z Pn, n P @V;$Xe, n P 888bZ PnP^ZЬXЬ[~[nЫS<kZkXhXPШS<hZ~9  ~|~  QYd9  P99  XXQddYԮn1 Q0WQVaYi<PPZ1@(fcKZJ  SJ  J  J  xJ  J  J  ~PWW<PPZ<PPSWWkX1 SY2Wi8  PXVV<PPZ(fc
Z<WxI  ZHJ  SEJ  AJ   WW'*J  I  I  J  ~PWW$J  I  I  I  ~PW<PPZWh/W)h Z<PSI  hnkkЮP  }7  PYЬTdwdRФ$U<PExPSBXX.B
W<WQ+aWBОV<WQA<QEaBc	PYPТ<Q<XPQPPXP, n XEaYP37  [ЬPРTXWUR<YVvVZ<ZP@<R@W<WQRQ XQ<UP<XSSPRPUHRQPQ6  aka&P6  `k`<USPSRSU
QPWUYV<UPvH  [^ЬRR  PZZA, n bЬY<PinԼ8nVЏ  4Ԧ81YY  PZZl|P@{,  <QP Q@g,  ОVPЬQ	<PPQPxPPQPԮ^P  PZZZPnWЮg, n ((\ f88VмP X}X,~iǌ WWY, n P iPik, n D hDhЏ   W<|~V  PZHVˏffP^ЬRR#  PVV}, n bXЬPC<`X7Р[1 	  PVVoXPF  K`
F  K`PPЬW<PgnԼ1 W  PVV   PԮ^Pt  PVVVPnZЮj, n (Zgʔ V W, n P fPf(YY(, n D gDgЏ   V<E  E  E  X1(XkʈE  05[,X4, n ` i`i
ʈP^Ь[ЫЫTЫX@WPX hnnԮ$Ԯ4Z8P~J`HnH``H`P~J`Qad<`(()pJ՞1~ծd<PJP~J`Q a
n
(hd<~
  P881(լ
ЬP(dԮ8LT81<TYY1I\P~I`QaQ~IaR bPPLPQQP~I`RbP\(1.L)<LPPPg<Pg ծP>J`Rb?JY1kQ1 ,<PPPY<YV_Q~FaR<bP@0,!Ԯ,ծJJ(P~J`QЮ0aP~F`Qa(d0<PPd <P<QQP (d0, n  c<Vx11Q~IaR<bP@0ծJJ(P~J`QЮ0aQ~IaRbPNPLR~JbS c<ݾd޹  PDPQЮDTD`QPQPЮDdP1
P&(.1~ݮ4J	  P88hЮ8PP_ծ4EXk<XPPЮQA4ޠQQ<a$׮$x$QQQ<aP@@Ю@î$YV~JF@>PAPCPEg(d0lPR(dLNfN`P4<pЮ0tr<hЮdlHjplP88)P,d 0<PP@QQT1Z?ծ4nЮ4QA@P¬PPRPbPVDF@>F@XШdh<F(PF`QaQFaR<bPP(d`4VPx[ Z>  YЏ
X.  W.  VЬRPfbV_O PbPPUݬR}~  PTTSTbSS4SXagSTb!~f~YfjPSS`fkPSSUUUSRXTRH.  PgT5gTg%~f~YfjPSSfkPSSSPRTPΰ^}P@Qa@P,խ	խլխխ<P$~PZԮЬR}|~}~ρPZZЭZZq-  ЏJ
ZZ1X-  VXW3b[<Z(bgSXZЏ"
ZZԦ19|[
ТW$b[1Ԯ 2[ $ЮXi
, n $g$X$Џ"
P, n VF5VPG`<Y,GОP(Y@gVYFFV´$ԮЭЬVԮV*֮f$$[
101X(fhSXfg$ԮЭ$[Д1ЬQaY2[P<YRRPPP[P2>  (Yh<YVOHfHVX<YPVP2[QQPP[ZP	H`ZVPZZ(HjhZ[V1 XXX<nn<$$nQVzQ~{PPPVPVVVVV2[PVPP[P9+  PԠ+  <PQWY, n ViVYWYRZQYHa	nPQPIZnPQPQSQS[<Z<P?@iRS?@RQR?@iZZ1nQ1 ծծg<PP<(0,((0(,J <0P<QQP(J (\)(Sg<PP<QQVzQ~{PPPVPVVVVVVQWX(ihVXS, n VcZէWV<XVXX<gPPX1 SWXPzP ~{PPPSPSSSSSXXWV V[RRSGԞGcVGc<GW<[XI PZZ $ <ZGWX<PPX[ZRЬPZWX`W(  PԠ(  ZP	;  [YԫЬXZXZhVVլ(kAԫ	Џ    WW(  Xɏ   W~|NPWW1hZhլ(kT(  zkի*0(  yPWZЏ
h"(  1k(  
V9'  2~'  '  '  '  '  '  Yk1 W'  FR1 |~'  BP`'  '  PWW.'  '  Rp'  |g'  k?V<i'  3R'WhB'  D'  F'  H'  Z;ЏJ
h2R1u'  +Y($'  P&  ZЏ
hPWPV9  YXլ,ЬUTDieDОP)e`
D8T;VF+Fi<WЬP`W<XFОQ(WaWXVXP^,ЬWЧXD(8[ $ЬVZ<<U1E PP$E[EPP <[PP En  1  
Ef<$P@@$Ԯ<$P<QQP094<$TT1D<P@$8D8 8
88<8Y  d $T\ W U J< P@H~@PРL<Y@ЮD@DHE P,HDE P,,f $T;%  	<[PPZdb 4< P~@P~)Y<[PPZ 6DPPD<PP)Y`<[PPZ 0T1UU<[PPZXI[E<<< ~ݧ$WiP<f <                                                                                                                                                                                                                                                                            ϔ $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                      "     ^       <	<[PPZ
U1Z1 ,Z("Џ ,[<[PPZ
Џz ,,(ZZЏz ,,
Ю,4Ю,P
W  
~W  P,,1SЏz PP^ЬU<PPYP1 Х,PХ$WeTФVլFn5n<nQARn<nQAX4S4R<XQ$Q-S0 RaЏ 4Џ P
<YP2xPQD$D
R<RQAX<XQGaP˰LPNPNPN
PPP^ЬP)"РZРZPZ@ЬWgP(85<Px2  @7[5[Y
YPPnn<Q<[PPQNA8P>2  P62  P PA8/"2  P&YP?@Q?@RQR?@RYYPPnQXVYPPPPUPVVYYT?DnP?@PUPP/UPP?D)P?DP<nQQP)j@8[XVV~[x[UUXYPUP>@T<[P?@d;dSQ<nRRQdR~?@P-SA9 R@[<XPdQQPPXV[XVUVAլЬPV1XXЬP`X<Pѧ(XVլXVP^ЬTФXФTLDHԮDVЬW[,(<<nU1VEPPE@@PP, @PP[ E1|ЬPQQ@@@@<8
@
8P8YY1YQYPQP4U(
4PPU(Y1 Ю<P@iT<Q3ALT<TP@0X@XV@<VF$$F 4MXXTfAdЮ h^0\Ю$`\`d@ PVd`? PV@0Q0P-Q$ P V)U 8Y0Q0P-Q$ P VЏ VVY
@PP[
VPY@PP[8PP	8PPHU;N2dZ-
T&<TP@<P$PL`Џ V@PP[
DnU1[,,1 V64[H,Џ VVH[
([Џz VV3@V	Џ V	@PPH@DV4VP
T
  
4~T  PVV1TЏz PP-ZV  P	dXVVЬPЬWggЏz PgguЬX(h<P@g~XjPYYSgYW@Xݬ PYY-Y(h@XݬPYg
~XjPYRbg
SЬP`SЬP
Pݬ}~RPYYYPgSgbSb~ݬjPYgbPbRPRxRPPgP <Q/P QPPRPP
 QPPRPPP^Ь[iP`Q<aP@,P   Z jԮ44E<YYPP[(4(@@(@@)WK՞1PP[Qa1KPP[Qa@$ЬP(ծԮDjݮ<~Pծ"jݮP11<PQaP1*@8 DQ~@aRbDDQ~@aRb 8@10<n< PPn$nV1VP~F`Q<aWWVn	  gW,, n 1.P~F`QaDxnQQQaPPr<DQWQQ,W,D<D`Wd<HЮLDdP; PѮ<<DP
o  G`DPD, n 1^P@.PDWK1Px~ K <, n PHPL
<HЮL<D`WdDdPR: PR KbDvP  PDbPAPCPEPPD<D1 P+WXhDxD<D<PP(D`\PS~ K/<D`Wdb<HЮL(JHd8PDD<(Dg	4PЮ`D0D$ ѮЮPD<DPP$Vծ0<P< QQPP1Y<P ~ЬQ@nPP `@   n1n*<BP<@RRRRP BP<>Џ
P<Џ
PP^ZЬUeSЬYУ1 Ԯ
<Q1}ZxQWCОPCОCCQCXC[
X<XRBVFi՞&C
XX<XRB<RRCgbZZPF)lfVaR RZSB`0V [B XR;<XTD<TFi<nnT T TB
B<TTRRZ
VLQ1P| VݼЬRRnRDn%ݬ7 PVV;RPѬԼݬ6 PVVЬVVмP, n `VP  ^SЬRb>9ЬPbPPSS"<bnbH   P`@ݬ  SPЏ
[WЬZ1#jST8SУVУ,UХ<YPP<FP$P@
  RЬQJ PPW<WP@Wa5aP P<WQAXPX$X4a4<WP@W<WP@4<WP@<QA0V@bbdbddb[Z  PVV{UPVV}4V_PT|WQA`WA`XTTQW*T[PDXHTd~RS   X[VVP< ЬSУ,THRУ$(""TPUUU4TPUU
U4Ф8UPУ0QPaP
PФbbSPUP4 [&  Z^WW, n P gs4 PYP(gSWЬV( gЦ,VЦ<X.W+(jgSWnWլݬkPY<jPPW(	SWWVnWլݬkPYLW(gSW P@P(`gSW3 PY, n P .W(gSWnW~kPYWnW~kPYnVݬkPYJ3 PYP ЬSУ,RHPT`1`SFRhP
P4Т8TP^ЬU[U[ЬPР4eeЬeР8ЬTPP1 `1 Ф0ZjnnX1 <FP$P@
  RSФ,WVY|P@cQ@cYPVPYQ QЏ
PWPYY2HP`?FcRT~~Fcݧ<RTPY
[Yehվ ^ݮ~PYYjYPЬPPXЬVЦ,WHRЦ$$ WhQS bQSbb b<QTTTWP#Pz Џ PWhPP 
P4Ч8"bbVRN<S~VPPLTS <P<QQP<R$R, n PbЦ0QPaP
PЧP< ЬTФ,SHRФ0P`P
PРU,Ф$$ 	SSP"U	SpP
P4У8bbT`UP< լЏ
PмRS8RPPТ,PР<T<FP$P@m  U4Т ,\"  5X"  0ee)TP}4eHP`~$ecP< ЬTФ,SHRФ$(""USPSP	P 	SP
P4У8Ubb!bTJP   !  [^ЬUePPePUPPnn˔ ˌ XPQQRBkԞQVSSe1 SQAkОP|SQAZRRjiRT[TWgP\DОXS|~ˤ ˬ XP.R
Џk
VVPDQaQYQQi
QTDkPQPgPk
RSkSQQRBkОPQePPSPVePQeQeeSPVP   ~   *    

     6 "    o $ u 	$   3      3      '  *    "  $                                                                                       6     "    3   E!   E6     "    3   E!   E4   D  C 1      WL         ,                H                             
             
          "    *  A                    4                   A B     A    D        T                                  #  2     .    '  C        #  2     .    '  C 4 "         #  2     .    '  C 4 "  C $    C        $          "            A     H   !  C1  AA  C+   C  .      -           t           \                         p  	     )     	    y          I          i          A   H                                                                           X                                                                             UCX$PROXY   UCX$BOOTP   UCX$CONFIGURATION   UCX$EXPORT  UCX$HOSTUCX$NETWORK UCX$ROUTE   UCX$ROUTE_OLD   UCX$SERVICE                                                                                                                                                                                                                                                                                                                                                    	           =   @ E     @    @ E    @    @ E    @    @ E    @    ! !  `    4               ]  	   x  (  9        (  ]                 @ K     p    ` `   8    -      P  H          X                   @ D    8                 ?  @ A   (     =   ` b  H  (  ?                  )   p      @ A       F                @	   %   (  P  h  @ B  x  (  @	               -  ( *       -            H          i                  )        y                I      D  	                               $ *   X       $ *               , J   Y    H  p , J   Y   H  p , J  * L      0 ,    * M      0 , p        L         W    	                                                                (        	                                                                   8                                                                                                                                                                                                                                                                                                                                        ǋ0 $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                      M "     o       $          D        
 ,                                                    D     4     T         8                                                           T                                                                                       d         @                                                    D          t    C    	 L                                                         t             h                                                                                                                                   $                *   0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          &           	           @  F           @      A      B      C      D      E                 !    (  .     	                      (  .                           p  v           @     A      B      C      D      E      F      G       H      I      J      K                 `    H 	 N                                                    X  ^                                                               8  >           @      A      B @     C      D 
      &           @      A    (  .           `      a      b                                                                              !      "      #      $ 
     &      '      )       &           @      A    P 
 V                                                     %    (  .           @      A      B           (      *                         @     *      . @     : @     N @     O      P @     Q @     R @     S      T $     U @     V @     W      X    p             $      *      0      6      7      8      :      ;      <      =      >      Y    0  \     *      F      I      K      L    0  \     *      E      G      M    UCX$BIND_GBL_SYNCH  UCX$ACCESSZN  igUCX$BIND_STATE   <  UCX$BIND_SERVER  T  UCX$BIND_TRANSPORT   l  UCX$BIND_DOMAIN    UCX$BIND_RETRY     UCX$BIND_TIMEOUT   L     d          
       UCX$BIND_SERVER000          LNM$SYSTEM_TABLELNM$PROCESS_TABLE    $   4  P  H                UDP  p  TCP  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
                              *                                                           *                        /   0.0.0.0 UCX$SMTP_   	   _00    .DAT      X                                                                                                              ****,      UCX$INET_HOSTADDR   
 X   X  LNM$SYSTEM_TABLE |     4             @                                 .          +                                          ig      $          igig   @       L          AZ.9az  ig-   Access:  t  ALIAS      File:      RFA:       READ   WRITE      UPDATE     DELETE     KEY    RFA    SEQ    ->     KEY_1:      KEY_2:   0  KEY_3:   @  KEY_4:   P  KEY_5:   `  PARENT   p  RECORD_ID:     ASZ:       RSZ:       NODE:                     (  8  H  X  h  .  UCX$BIND_DOMAIN    UCX$INET_DOMAIN    UCX$INET_HOST   
 (  LNM$SYSTEM_TABLE @                         .COM*%  .                                         TCP UDP         Access:    CONNECT    CLOSE      COUNT:      DISCONNECT  
    File:   $  IFI:     4  ISI:     D  OPEN T        X  .DAT p  UCX  |  UCX-IP-CLIENT   
                                                              Z
                                            23-AUG-1996 0:0:0.0               DEC  @    4        <                                                                                                                                                                                                                                                                                                                                                                                                                                      ?  \  P<  PP
  P1 PM  ЏP    \  P<  PPP1 P  ЏP    \  P<  PPP1 P~  ЏP  \l  P1 P~  ЏP  I  K  \ls  P<1  PPя  P
&  P1 P{~  ЏP      \ t  P<  PPя  P
  P1 P3~  ЏP  ݬݬl  P1 P
~  ЏP      \t  P<  PPя  P
  P1 P}  ЏP      \>v  P<  PPя  P
x  P1 P}}  ЏP  \5  Pa}  ЏP  O  \  P<=  PPP1 P-}  ЏP  #  %  \w  P<  PPя  P
   P1 P|  ЏP      \6x  P<  PPя  P
  P1 P|  ЏP      \x  P<  PPя  P
  P1 PU|  ЏP      \{  P<s  PPя  P
h  P1 P
|  ЏP  [  \}  P<I  PPP1 P{  ЏP  /  \  P<  PPP1 P{  ЏP    \  P<  PPP1 Pq{  ЏP    \2  P<  PP
<  P1 P8{  ЏP    \療  P<  PP
<  P1 Pz  ЏP  u  \>  P<c  PP
<[  P1 Pz  ЏP  D  \  P<2  PPP1 Pz  ЏP  ݬݬݬݬݬ	  廙  P<  PP
<  P1 PLz  ЏP    \%  P<  PP
<  P1 Pz  ЏP    \  P<  PP
<  P1 Py  ЏP  x  \X  P<f  PP
<^  P1 Py  ЏP  G  \  P<5  PPP1 Pmy  ЏP    \漢  P<	  PPP1 P9y  ЏP    ?  \  P<  PP
  P1 Px  ЏP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !Ue $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                     F' "               UCX$DEVICE:         SYS$NET                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               $^T}ЬRբբЬRЬS 1%<,~j  PPR УR$УR($  PX  1 T1 Wu  1 Xŏ  WVFe  F^    PG^(FH  nf  P  䟭  Pݏ
  F  RbPWW  1vWߦ  ݏ
  Џ
T%PЬRТSe  XTTP      QUERY IQUERY    CQUERYM CQUERYU 4 5 6 7 8       UPDATEA UPDATED UPDATEDA        UPDATEM UPDATEMA ZONEINIT       ZONEREF NOERROR (0) FORMERR (1) SERVFAIL (2) NXDOMAIN (3) NOTIMP (4)    REFUSED (5) 6 7 8 9 10 11 12 13 14  NOCHANGE (15)         ^E  P`ݬݬ    ^ЬS  ݬ  PTլS  1U  ЬVV  UeRB0  ܁  Ve<c~ǀ  PӁ  VeRRRB>    VeŁ  VeŁ  Ve
P  Veﷁ  ݬH  ﱁ  ݬ3   敏  ݬ  論  ݬ	  更  ݬ  <~  WgP  ЬVV  Ue<~gP  Ve<~gP  Ve<
~gP  Ve<~  PR1}  ެݾj  R1оnY  >     Z  ݮTЬ[ЬZnYЮ[XZWYԮ< ~ݮWX;  PUVEPP     ծ{  ݮ ݮ  UVVT1bTPUTTPVT2U~O(  P  ݾ2V~'  P  ݾR1<~m~  PRH|  ެVf=  R1  Un  U%  UݬݬTp  PT1 R<~~  PRE>  ެVf  R.  U:  U  UݬݬT  PThR<
~}  PRD
  ެUe  R-Х S  Sy  SݬݬT  PTRן  ݬO  P ^}  R< ~ݬݬݬ=9  PTSCP2"  լ:ݬ  ݬ  TSSP^3}  RЬXЬVЬUЬWY< ~XUV8  PTSBP2  Y:Wi  PWg  XTSSPP^|  RЬXЬVЬUЬWY< ~XUV-8  PTSAP2  Y:W  PW  XTSSPP^%|  Uլh@  @Y1QЬP<SSSPSQPQP{SPPQQXQЬP<S	SP	Q{SPQPQQЬP<SSSPSQPQP{SPPQQWQЬP<S	SP	Q{SPQPQQЬPSSSPSQPQP{SPPQQVQЬPS	SP	Q{SPQPQ@RЬS3SxTzTTSoR  RbP
PRbPV@լRPR `VņSňSSV|RZ  RbP
PRbPWDլVRPR `WœSŔSSWŊR  RbP
PRbPX
լBV>W:լVWRPR `X
şSPŠSSXŖR  @YYP^z  VݬݬݬݬPƢݬq  [1ݬ8  Sc<PZݬc<PXݬ8  PTݬc<PY  GZ"  PSXx"  PRT@YPTRSƶݬ  ݬ  ЬnZ1ZPPT hXxp(
Pv?PPd   1|Pd   001kPN?PXX1 ЬWW}  Y(^(n\  Pݬ5  WY1'Y1^(n[  P ЬUU  Td~UdRxRSRRS~(UdWY1YX8ݬ  Y1PXݬ  ~ݬ6  <P~kݬ  |ݬw  OƐݬf  >ƦݬV  .ƳݬF  ݬ6  ݬ&  ݬݬݬݬ?Pݬ  1PЬR֬bSݬSݬ  SЬR֬bT1ݬTݬ  T1ЬUU  WgUݬݬݬPUgUݬݬݬPݬ5  TdPUgݬdPRRvScPR!UgݬdPRRcPR4UgݬdPRRcPRFUgݬdPRRcPRXUg1hЬRR  RݬݬݬPxR  RݬݬݬP1qPݬƄݬc  Y1VY7Ze   uRgRݬ4  PRƉݬ(  1Ze   uRgRYRƔݬ  1 PY1 ݬ  ^(nX  ЬR֬b~PƬݬ  TYnWѬW:  UЬR֬  SSTݬexSSTˏTRѬWݬ
j  VYݬL  DPЬScRSYݬ-  ݬ
-  YPݬ
  YYnRѬRRݬݬ  Ь[[P Μ^Wy  XYԮݬ  RլRR< ~ݬݬݬK  PS    Sn1@SS,SR<~{s  TdPU<~dP<
~dP<~dPTTT4   լݮݮݮ$Ds  0  SSn1ծծծ	n1PȨZ<SSRU1 լ\ݮZRݮ8.  Pn1ePSSRZ  PTT  ЬSPcTZc  ݮ,R0  PPRU&Pݮ,R0  PPRUլn1Ȑ DhԮH׮1R,1 .  $`1  [     (   Ѭ1ݮZRݮ88Pn1RRk<PVRRk<PWRRk<PURVAURSѮDS1zЮDSDZcZ$PIYZ1KV[ݮZRݮ88P
R1$PRZB  PTTo  ЬSPcTZc#  H1 VUR1 ծH#ЬSUR1 WLUR1 DPЬSUWWԣլ"Z$PTT  PcTZc4QZPSSSPSQPQP{SPPQQZZUTȩSTS䀹  BUi9  3PЮSZcURc4UZUR֮H׮	R,1Ѭ1 ծH1 Y]Y~:  ެTdSPRY4  SB  PBBBȐ B  RRYЬS޳SBcծZ~  ެTdRPSծ/  Rݢ  PCݢChCf  SSЬR޲RCbЬRԢn1Pݮ,  PR[׮1R,1+  4  0@  <   84.  L     WݮZRݮ8HPn1lRZ4PSSDPYSZYDRP<PURRP<PVRRP<PTRUTR1 ݮZRݮ8HPn1RZ4PUUDPVUZVD|S[1Pŏ$  TP@ȰP`VgPSV  TT[S%ŏ$  TUE@SccSS#BEȰUYCe6[
>[[Sď$  SCȰTVdCȴTYdC@TdCSc׮	R,1ݮ,  PR׮1 R,1 ,  T *  YѬ1 ݮZRݮ82)  P1 RRX<PTRRX<PURRX<PWRTWRsV[iPŏ$  VSCȰP`ZiPGCTdd#:W
  PUCȰQdPU@ WRCȰQdP@   	PVV[WR׮	R,1$[1[~
  ެ@о@RPW[1 
  P @ ZXPGPSŏ$  WVFȰRbcF@Yi~XGRPTi о@UGR޲SFȰRDDcTTiGR޲RDbŏ$  WVFYi~XGRPTi"@ UGR޲SFȰRD DcTTiGR޲RDbWW[15ЬR޲RGbѬnЏ
nЮ P^p  V"  SЬTdRʏ RBcRR1 Ѭ1 TJ  PѭW1PT  P~+  ScЬRPbT|b  ԢԢcPcP߭ݲ  ТRԢW1IPЬRTbSbSS.TRbSTrSS.
լn硫  fˏ  Xʏ     T
bSS.bݬݬ ݬݬݬݬ   PQTbS.bXȏ   H  QW1 PT0ݬ*  PR!ݬݬ Rݬݬݬ   PWyP@  ScDݬݬcݬݬݬݬU   PUU	U	͍  UW2PScT!ݬݬ ݬݬݬݬ   PWUWWP| ^n  SЬR4Rݬ  P$R< ~ݬ< ~Â  < ~|~ ݬݬݬ 	7  PU  Ì  VYݬЬTT UݬݬϨPUU.d*ݬ  PRR	  PdRݬdr  UVVPP| ^m  S޼TdPˏ P~Pˏ P~Pˏ P~Pˏ P~à  < ~|~  	6  PU2  ú  V^ЬRRUݬϾPU;~  Po  PTݲ  ТPԠUVVPP ^l  R< ~ ݬݬ 	6  PT    SݬTݬPSSPP^ЬRbb  bެTdRТR/SCbФ RC  SCЬRݢ  ԢެTdRТR/SCbФ RCe  SCЬRݢO  ԢެXhRТR1 UEb1 hW)  VERbhR޲REbRbfERբIThR޲REbR޲RDb"hSER޲RDbfTER޲RDbhR޲REbRݢfERբJThR޲REbR޲RDb#Ш SER޲RDbfTER޲RDbhR޲REbRݢfEfUE1.ЬRݢH  Ԣμ^z  VԮЬTTUЬY  ݬ#  T~T\  Tf  Ѭ   TTe5e  Pм4  1!  ZX+W     ծ1,[܃   PɃ  fￃ  CP$  4j     1PЬRRWd  P ?p  P RݬZ  PR%^  @j=   2  1+PЬTU2R9 RT  gPS%ST2URSRRU2UR RT  gPS                                                                                                                                                                                                                                                   !                        Z) $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                     ۾ "            S#  Ljς   Ă  1ЬU2e~vc  PXX%ﶇ  X0  Rb:  T[XT2TR9 RUp  gPS%SU2TRSRRT2TR RUK  gPSS#L  lj+      1[1ìXRRU2UR12UTT   < RTRR݁  j  PR1nRTTUP1a2UR1Xﲁ   P  f ݬݬ  PP  xjx  ԭa  ԭ|C  ~MPSC  1'Ƅ j1խ(  1֮ݮƐ 1 P ݬݬ  gPX  1 Ɯ j1 <T<iRTR(х  1 ƨ X~ݬ1 海  4/   y   n  x  \m  8լ3`  X      X~ݬ    XT׮1    TTP ^ЬST<~`  PR,R(PݬT  PY1YPPTTR׬	TY1BP<~A`  PRTRPTUЬVVUb  PXXWPXUUUM  <PPUPUUWWTY1 PR׬TY1 <~_  PRPRLTUЬVVU  PXXWPXUUU  <PPUPUUWWTYsR׬TYeP<
~e_  PRPRLTUЬSSU  PWWVPWUUUq  <PSUSUUVVTYRTYYP ^ݬݬ2  PSSR#PSݬ  <PPPЬRRP    ^n  PSݬݬ~  PRSV  RB  P`2  u  F  P`P  6  P`     PRTTP^t  YЬRbݬЬTT  ScТRvբ
TcP%Tc [WЬRТVMfI Z  XWW
.jh [W^( naA  P[~2jh,[VfЬSգt8ެWgo   U
TУRXbSScSNS  VPbg  PPTTK   Bgf U
TbU~Fgf,UR
bScSЬRբ1Lެݾ  ТWg1 оn  [@       ݷ Xݮk ZXgRТVKfRFbRAXX_ݾk ZX^( nPZ~bݾk,ZV
fRbRhݮk U
TgSУRObSJcSEbPPTTK   kݾk U
TbU~nݾk,UR
bScStݮkWg1!v     < ^ur  R>ݬP*  PSUYPPP>#ݬzSl   ݬZ  PT"ݬ SH   ݬ6  PTTcTUUPP q  QЬPP s k { 3 ; C K S [          c aj?P RV RN RF R> R6 R. R& R RRR8RRPP< ^Iq  RHЬTT  ScPUYPLTcPUDPTTcPU/XTcPUPT[   P`*  ЬUUPP< ^p  RtЬSS  TdPU1PvSdPU1oySdPU1[|SdPU1GSdPU13SdPU1SdPU1SdP	U1 SdPU1 SdPU1 SdP
U1 ¢SdPU1 ¨SdPU1 ®SdPU´SdPUk¸SdPdUWSdPeUCSdPfU/SdPUPSl  P`v  ЬUUPP ^
o  Rլ1 ЬPPx             
P?PPd   1 Pd      ^?PP   1 P   |    1 6?P S1 S1 S1 (S1 8S1 PS1 dS1 vSxSpSh°S`SXSPSHS@S8 S0S(S !Sݬ&.  SSP < ^ݬ-  PTݬ   PSTSTPSPUDSTR0Sݬݬ  PP֬RSݬݬ~  PRUPЬUUP  PP ^ip  RЬQQQQ   P S#SSQbQ  bSSPP ^p  Rլ1(ЬPPx                
P?PPd   1 Pd      ?PP   1 P       1 ?PS1 S1 S1 S1  S1 #S1 &S1 ,S|0St3Sl8Sd<S\@STFSLLSDRS<XS4`S,dS$lSpSݬtb  bSSP< n  RxPЬU֬SC`TeSC`STS.PЬQ֬aQU2ЬT֬QA`SdQA`QSQ׬SC`TSC`QQTUUPP< Ln  RxP׬MЬQ֬SC`TaSC`STS2PЬQ֬aQUC׬ЬT֬QA`SdQA`QSQլUP׬SC`TSC`QQTUUP ^7s  X[ЬRբ1R>PSSSY1ТT< ~O{  b  S< ~|~ ~~S 	e"  PZ4   `Sw  I  RbS  S  SY1   5OS  PФRв дR޲Rв ЬW)^(n6  Pݧ   ݧ  Pg Ph B  `RR  RY1ЬShhtP=   `TSRݲݲhԢT  TY1ZsR  P ?hP ZhPZ>   `SЬRݲݲ(hԢS'  SY1ЬRТR(мWЬRвhTS2 STh.PVPVTVS SThPVV@   `SЬRݲݲhԢS  SY1P<~\Q  P<PR.ЬRݲݲBhԢЏz Y1<<SWTS0 SThhPVVTVS SThLPVV@ 9  `SЬRݲ-ݲhԢS  SY1 Pݬ[TW
  PUUPP n  " d^?P1Џ  YPЬSУR(.SRݲݲGhԢЏz YBPЬRТR(1)ЬRݲkݲhԢUYP1YP ^ЬRݲ2ݲn  ԢP   ^n  ZЬSVRRR
R1	P<~iO  P	1	P<~QO  P ݬV}
  PS1	SRRV< ~Vݬݬ  PT1\	TVVE  Sc<PVVc<PnVVF  PVVc<PVR
j  ѮYѮ1Ѯ1sѮ1Ѯ1Ѯ1Ѯ
1Ѯ1Ѯ1Ѯ   11)Ѭ
Ѭ   1r  .  PRbݬ   Ѭ   ݮPݬ  n1V  Ѯ$^(np1  Pݬ  [PѮB^(nF1  Pݬw  RxRSRRS~~ݬV  ݮ&ݬD  q  ݮ4ݬ,  <ݬ  1191}Ѭ
Ѭ   1ibq  .  PRb>ݬ  Ѭ   ݮPFݬ  < ~Vݬݬ  PLݬ  1Rݬo  p  ݮYݬW  ^ݬJ  1PѬ

Ѭ   1p  .  PRb`ݬ  Ѭ   ݮPhݬ  S(VSn  sݬ  SVʂ zݬ  SVSʄ ݬ  SVo  ݮʊ ݬp  ʐ ݬb  1PѬ
Ѭ   1o  .  PRbʒ ݬ  Ѭ   ݮPʚ ݬ  fRVݮʠ ݬ  RV=o  ݮʦ ݬ  ʬ ݬ  1PѬ
Ѭ   1n  .  PRbʮ ݬo  Ѭ   ݮPʶ ݬK  V	  V2P~ʼ ݬ.  < ~Vݬݬ.  P ݬ  1h ݬ  Kn  ݮ ݬ   ݬ  1(Ѭ
Ѭ   1n  .,  PRb ݬ  Ѭ   ݮ+P ݬ[  Ѯ	 SP SS ЬTT4  TݬݬVPVm  ݮ T   ݬ  1_PԮѬ
Ѭ   1F?m  .]  PRb ݬ  Ѭ   ݮ\Pݬ  n1VfRˏ RSS|P[SݬT  PSݬ@  V׮TЮR׮R1 IH  YｻX  WPUUEծ3<TRRikPhPSRݬgc ݬgP<T~$ݬgxUU<TRRRT<TRʏRЮR׮RP1k  ݮ(ݬ  .ݬq  1PѬ   10ݬM  Ѭ   ݮP8ݬ)  < ~Vݬݬ)  PR>ݬ  1bPRVDݬ  < ~Vݬݬ  PRHݬ  1RVNެW    TV  PUVT	ZSP\SUSUg^  TTǟ^ݬE  j  ݮ`ݬ,  fݬ  1 PѬ   voj  .  PRbhݬ  ݮPoЬTT  ScnPʀTc
j  ݮʐTcԮЮP^f  XЬTRS
Џ
Z1zP<~qE  P
Џ
Z1^P<~UE  P$ݬR  PTЏ
Z11PTSSR< ~Rݬݬ  PVЏ
Z1PVRRA  Td<P[RRd<PWRRC  PURRd<PYRS
h    PЬV ?    @ [oWjR{  < WY%^(n'  PG 5  (PY ^(n'  PG   ZP[ZPZZP YXЬRЬSWWQ1 ˏ?QTT   u1 PRRW	U1 P.RQTTWU1 PQTTXQ1 PPP.RQTTTW	U1 P\PSU|PQ^PYìSYYЬVˏQTxTPcTʏ TTPVPSSVSU6XVTXTU$P
PUPQ1bYìSYYUUPP^ЬTЬUUYլ!ЬRb[ЬZjZjZn[S1 P[`nݬ[T~PR7UVVYX1 xRVȏ   VVz  RP{   PQPPìUX1 լRZRUjURURVS.S"PS\   SUYXCSSVUPPSUPP?XPPfS1>UYXìUXXP ЬQQ?P:Pˏ?                                                                                                                                                                                                                                                   "                        / $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                     T "            PRR   PPQPSPQQPìQSSP ЬTT1 ЬSdRRWQyˏ?QUU   I?PQcPP\   SUPUPOQ㚃PbU	ìWVIPP."1V:PˏQUxUPbUUPPRQcRìWVTT1`VVP ЬPPR`PxPQbPPQQSSPP ЬPPQ`PxPRPPRxRRQPPS`PPRxRQcPPQTTP  ЬQ3<PPPPa ЬRPPb   ^a  Uݬ< ~ݬݬ  PRen1TPTRTTS<~?  P<~?  PWTծ1 RRPP M m 9  m m nPf?P ݺ  <`eMPeFP   <"`e2P   <`ePeP   <`en14V<RRTW1 լTݮVTݮ$PR ;  < `en1;PRPPTVV  PRRVRPݮTPPTW>PݮTPPTW$լ ̹  <`een1Ũ RR[RRRRZ׮1~T1u ZY   ݮVTݮ$$PR1BRTTi<PWTTi<PXTTi<PRTW%RT0S[S1 VVPPVP1 W/ݮVTݮ$$P	PT1 PPTVn1 PWRT1 ZRRT1 X5RT1 -PRXXԥլVVPPVQVPSSSPSQPQ{SPPQQSSVRVP5SPS.ЮSVcRTcη  RVRTZ׮	T1ZkԾn   < `en  P ^ЬR.ݬ
  PR( `   c  Pc  R~   Pb ^ЬT<dUU   
<10U   ;Uݤ  <dRB< ~|~  	
  PS$E< ~|~ ݤ 	
  PSS<L1Pݬ< ~S  PS\  <1PR<~e;  UeP[<~ePX<~eP<
~ePWWTSWVԮЬU< [S\  <1SSS1 SPP W  ?    1 ?P 9  <`[  aP[  VP   <"`[  >P   <`[  !P[  P ѵ  <`i[     `1bPXRXR+PVTqP	<1;PRRTXRXR[1 TV1 
1 Z:YݬUTVjPR1 RTTiPWTTiPXTTi<PRT2WSSRTuPTiPXTݬUTVjPReRTSXCЬW
SCSUc
SCgSXc
SCScUE  PRRUR[TV

1/	1%PЬS
RBRb
RBcRb
RBRbݮ2
~S  <1P׮MTVHPݬUTVPR<1PRTTT<PRTRT׮TVծVUU< ЬSЮZXW
WRBRb*2ZYYxYY
WRBRhbԲ YhW
WRBRb׮1TV1Aɲ     ݬUTVPS1 STTPWTTPXTT<PST2WRR	ST1 PЬWUYX
XRBRb-PY
XRBRb PXPPX
XRBRbPPRRSTC
RQЬPAXhYTZ[WGiGiRbjWGikGij GkST׮TV1ЮP^WެYW 1 ެ[n   WSS 1} kZ2GjP2CjRPR%kR2GbP2CbRPRU  PRz  RP{PQPP@kR2GbPCbGbPCbЬP
WRBTdXB`UeV
SRBQadB`RbeXaVbSS լ2G S2RSRWPWW 1Q< ^SެU
SQePARb7  Rݬ
SP@P`  PSTPS
SQePAP`TTPP< SެU
SQePAP`5eQЬR2   TTxTT
SP@Pb`԰ TbS
SP@P`P< PЬP֬`TЬP֬`STQQ   &  Rˏ QP@bPP QQTSQQ     Rˏ QP@bPP QQSTQSPQPTQSRPQRPPUUP QެRA bT   SAdP`c QA ЬSЬP`Acм A`             | ^X  TެUeRRV1 dbФФФ@@S  R<~ŏ  SP@@@  SS< ~BެScRB  PУ Q@B@BPPЬPRRPVVPP^#X  VW Ԧ53  PBЬRբ
BR1 ЬX<hY1 BR1 < ~+PnU.}U}UU  PP_  PT<TRURRSPSSRR~B  8<Z1{.PY   <Z1fPYݨB  <hRBBެUG X  XGh  ŏ  WSCRPbbbCRb52  CRPbWWWPG WBTBBRWbSbSS.WRbSBSW~BRRTRqSU.}ψU}τU
  PP  PQ<QRURRPPPPSSWW
BRRTR<RRլЬfլЬլ
RݬPRZZP ^}ЬSS}螬Se  PP蟭r  PR<RP
PSSQQQP   ^Ь UUT<X  RRRX  <R~1  Pdˏ1U  RPRPPˏU  RPRPP 0|US$PPRU`bR(RWT  BЬU<eR7.UP(W  RW  UX  :  լѬ1 1@P$Wݬ$Sݬ7PRV1RSR$SݬUeSSݬeS/  Pլ1 լ1 P
$Wݬ$SݬPRV1 RSR$S
eSSݬeSS 5SS eSw/  P
nЬUURѬ$RV_SݬRbSSݬbSS SSUbSUUݬS  US/  Pì SVVP                          t^oW  W| ЬYЬZ(˭XR  Ѭ   XXniR  41'(  87,<p.  %￢TI.  G     UxR  1]PѮ4`R  =ŏ  URBgRbЬ0Ь[SAR  [   Sŏ  URBRSbŏ  URBRb1Y$M 4P$ 81ŏ  URBQ  $8P 8$@$1P<[~PͶ>ͶЮ0[잭 $[RPR 8$@$1JPЬSͶ<R9 RS$dPV'VS<ͶRVRRͶ<RR RS$dPVV 8$@$1ЬS<c~PXXͶYXͶ<ͶR; RS$dPV)PVS<ͶRVRRͶ<RR RS$dPVV 8$@$1iY1ìXRRͶ<RR1P<ͶSS   
< RPSR R$YPR1<ͶSRSSͶP1<ͶR1P  4P ŏ  URBO   [ݮ@ ,P[1î4O  SSxSO  RO  Rԭ (Q P RRPQP{RPQPQSQ P RRRPRQPQP{RPPQxQRRC |͸͸ͼ ~,PV1 'O  ծ$( 8Ԯ$ 1  ݬݬ dPX1  <S<jRSR1N  2- @ N  4ŏ  URBRbUoPЬSŏ  URBN  RbcˏhN  RR  
UXS1 $$
$   XS1 PUUN  1׮41$$Þ$  ﭞ n&ծ    <`BP դ  <,`1PƤ  T dPR   `b d ` d`
   ,`SSPP  ^Q  \  $ $$	$ ^Q  \  f  PRR` $$?  PRR`$ | ^ԼЬS<cRR   
<V1BPRݣ   <cRB< ~|~  	PS	<LV1 ݬ SPV1 PެT< R [  `V1 RBPP. @  `V1 PTP  Ue1 Pe  PR< PPRPSS   e< P.@Re< PP@)  C< ~|~  	.PRݬ R/PVUe1r   `VVP| ^U  UԼЬS<cRRV1,Rݣ  (Q<cPPQ~ݡ  < ~|~  	PS
<V1 PݬSP   `V1 PЬScPcPcPecPРPԠcP԰eTЬPРRR  PbPP.
PRbPP.RR  PbPP.
PRbPP.RR  PbPP.
PRbPP.RRw  PdVVP       ^ЬScUЬQP   Pc<aPP PTn   cUTUݬcݬݬ<PRRRW1PcVPcV2fPզզ
Џz W1ЬRТTdݦ9  dPQ<bPPQP	<LW1S2fݦd  ЦRb
R1Pݦ  }Pݦş  ݬ#PXP1 RPްSBcS PRB`R
Џ W1 Pds  dPPdb  dPSSRUxUPPSЬP<`QQSQ	<LWlPxUUUSQPްPA`+PSAPްPA`P`cSQPްPA`APˏXPXW
VVЏ  WWP               (((((                  DDDDDDDDDDAAAAAABBBBBB      
                                                                        \^y  R}b}螢}Џ   d<`}}`}y}vhjlptլ	T1 P|~?^PPQPQTsh 蟭dPSPFl찭|~|~82^~ PSQSQQЭ2^~STTPPδ^x  V}ϦԭW}}($Ϙޭܭͷ>լ	X1VP!螦2
  PSSSX1!P2RRX1BͷU2RURЬR֬EͷbU2RURU@  P2S
ͷRR X1 Cͷ2RѭRMѭUGPЭTTRrSʏ S2RTRBͷRʏ RSRWT2RѭRѭUWXFP2RURRX1PR.bS2RSRЬR֬CͷbS2RSRXXP^WլX1QS
PЬTdRR0$PTRRx   	RX   P֬ЬUeRRTUQzRUˏUTDTTSP                                                                                                                                                                                                                                                   #                         $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                      "            T0UUTS֬CPPLRVˏVTDUU7UaUAUxST
VUVTVS֬PЬUeRRTUQЬTdRR.RRWRX1 ST1ЬTdRʏRBORRTQ	X1 PSRRWPPP  . R |?PЭRvPxTˏ   SSTR`xTˏ SxSSSTˏ  SSTR<xTˏ SxSSSTˏ SxSSSTˏ SSTRXPR  PRRXXP ^ݬ  P
ˏ   PR'Pˏ?PQQ   ˏ  PR	ˏ PRRP ^ݬ  Pˏ PQQR/Pˏ?PQQ   ˏ  PQQR
ˏ   PQQRRPP ^VլW13Q
PЬScRR0PSRRx   	RX   P֬RRSsPRTˏTSCτSSQPS0TTSQ֬CPPDRUˏUSCWTT/TaTATxQS
UTUSUQ֬PRRSЬScRR.RRVRWePQS1%RʏRBRRW;QSSVRRRW#|PRPxQQˏ @SSQPPRQWWP 4^Is  S}<}}аΞRh԰ОPܰؘbPˏ P蘢Pˏ P옢Pˏ PPˏ PTT?ΟX<P@PPQQP ^ЬQQ   xQPɬPR PQ   xQPɬPR	xQPɬPRRR  PRRQQP                        | ^(ޭ(حVFVV([  P  ЬSգѣѣV1 r  UЬTУhbr  ޭ   |~ ݬ~ 	OPSSSV0 мV%edUeUeUeUeUVVP^((͠VFVV({  p  ЬTդX1 q  WЬVФSUcRPUScRUTTЬRТhsq  ޭ|~ ݬ~ 	gPSSSX0 мX%gfWgWgWgWgWXXP ЬQRaPPRQaPRP                                       t^_  [|ԭ(ĭ($R  G  ЬRݢ  PUUPVVSTcR	TScRTSЬUːnSVkޭzޭ͜ Γ  RBRR(ݬ~ PSSSX1  мX1 ЭRBkkeЭRBzzPYRBRR(ːT< WnĞ   VZ UWTޭeݏ   yPSSSXKP  ЬRbz 
bX/PbX(PYTfVfTdTRRWYZXXPP΀^  [|ԭ((  }  ЬU˒nЬRբY1ݢPТkͨ͜ .  RBRR(ݬ~ |PSSSY1I мY1=ЭSCkkeRBRR(ޭݬ~ "PSSSY1 P мY1 ЭRBPRBRR(XːT< WnĞ  VZ UWTޭeݏ   }PSSSYKP  ЬRbz 
bY/PbY(PXTfVfTdTRRWXZYYPP ЬQRaPPRQaPRP   ^  X  w  ެnо Rբ[1 Z W  ЬVhUeRbR`о WeYYRЧSbQcPQPPbPTPRSbQcPQPbQcPPQTTefХ ZUiP2ZR[	P[[P^U  UVď    ެWgS RѣRXYPЬR   eQaP`P.  SaTѡС abVPQdP2VPX	PXXP QPQP&ЬQaPR$PQ֬QPQPۘQPPQRRP                           ^(`(HVF VV(    ެVfRТTY18  XЬWSCdRSS?NЦ TCRRa   fR޲RCbRRz   
ˏ RUfR޲RCbUUCSCRS?CS`bdެVfRТTvdRqSCdRSS?NfTCRRa   fR޲RCbRRz   
ˏ RUfR޲RCbUUCxSCRS?CxSh.jxldHJ  LP }  |~  ЬTTH` 	PSSdS S1 RPB RR(TެUeR޲RDbRT?Х SDDTDRT?D|~  ЬSSH` 	NPUUcU 8UUYXhgSVC R  TCdRR SVSCdRgRFXhUUXho  PXhUUXYYP^(](V( ҋ  @  5  ЬSգY1 P  XЬW+ݣ  Pޭ䛏dȰʞS  ޭ ݋  |~ ݬȟ 	6PSSSYsP мYehgSUC R  TCdRR SUSCdRgREXhVVXh[  PXhVVXYYP ^  S   Ь`RxRP@cP`RRz   xRP@cP`Rz   xRP@P`0  P<~   ЬPЬUЬVЬW<	ZQQQ PZ    	ZPRRP    m^^TXdХХTm	Z<Z |~fPP]~t  ЎSPN|~VT  |~g< ~<X~S SnPS
  ՎPSPP<gPP
PS<f~SPЬUЬV<	ZQQQ PZ    	ZPRRP    m^^XХWh Хm	Z<Z~  ЎSP3|~ X  |~f<#~<W~S SnPS?  ՎPSPЬUЬV<	ZQQQ PZ    	ZPRRP    m^^XХWh Хm	Z<Z~  ЎSP3|~ X  |~f<2~<W~S SnPS  ՎPSPPЬUЬV<	ZQQQ PZ    	ZPRRP  1  m^^TWd ХХm	Z<Z~1  ЎSP3|~T   |~f<'~<W~S SnPS̇  ՎPSPЬUЬV<	ZQQQ PZ    	ZPRRP  x  m^^TWd ХХm	Z<Z~x  ЎSP3|~ T  |~f<'~<W~S SnPS  ՎPSPЬUЬV<	ZQQQ PZ    	ZPRRP    m^^R^^SbSХWХXX  X<P ХХTTdcm	Z<Z~  ЎSP3R |~  |~f<'~<W~S SnPS!  ՎPSPЬUЬV<	ZQQQ PZ    	ZPRRP  ͅ  mХWХXm	Z<Z~  ЎSP3|~X   |~f<#~<W~S SnPS{  ՎPSPЬUЬV<	[QQQ P[    	[PRRP  '  mХWХXХYХZm	[<[~2  ЎSP3|~Z Yh|~f<1~<W~S SnPS̈́  ՎPSPЬUЬV<	[QQQ P[    	[PRRP  y  m^^TХWХXХYХZХХPm<PP`d m	[<[~b  ЎSP3|~ZTYh|~f<1~<W~S SnPS  ՎPSPЬUЬV<	[QQQ P[    	[PRRP    m^^R^^YХWХXХZըhިPP`b<PxPSSiS^^TШUTХЅՅPըRm	[<[~j  ЎSP5Y ZR  |~f<1~<W~S SnPS  ՎPSPЬUЬV<	ZQQQ PZ    	ZPRRP  ХW	Z<Z~^S~~Sݏ  ^P|~ f` <W~ S^ЎSPV<fPPSS@~  ЎSP1|~|~  |~f<4~<W~S SnPS(  ՎPSP<W~VfЬWЬRЬSЬTЬU<	[QQQ P[    	[PRRP    m^ZRQPՁPPR
^<PnR^RSQPՁPPS
^<PnS^STQPՁPPT
^<PnT^TUP#ePQz P ~ХPQz
P PPnQ^U^^Vm	[<[}  Y^^Yi |~iPPi~  ЎXPQ UTSRf|~g<g ~<i~X XnPX  ՎPXPP
,P
<gP,gPg}  QYQ<i~ЬUЬV<	[QQQ P[    	[PRRP    mХWХXХYZm	[<[~  ЎSP3|~Z Yh|~f<0~<W~S SnPS  ՎPSPЬUЬV<	[QQQ P[    	[PRRP  a  m^^R^^YХWХXZըhb <PxPSSiS^^TШUTХЅՅPըRm	[<[~%  ЎSP5 YZR  |~f<0~<W~S SnPS~  ՎPSPЬUЬV<	[QQQ P[    	[PRRP  j~  m^^TХWХXХYХZd Хm	[<[~b~  ЎSP3|~ZTYh|~f<0~<W~S SnPS}  ՎPSPЬUЬV<	ZQQQ PZ    	ZPRRP  }  m^^R^^SSbХWХXXXm<P
 c ccХm	Z<Z~e}  ЎSP3 R|~  |~f<#~<W~S SnPS }  ՎPSPЬUЬV<	ZQQQ PZ    	ZPRRP  |  mХWХXm	Z<Z~|  ЎSP5|~X   |~f< ~<W~S SnPSX|  ՎPSPЬUЬVЬW<	ZQQQ PZ    	ZPRRP   |  m^^YiPPP	({X	{X m	Z<Z |~fhPP~{  ЎSP:|~|~ i|~g<#~<f~S SnPSv{  ՎPSPP<gPP
PS<f~SP$ ЬUUPPPURRP$ ЬUUPPPURRP  PQQP  PQQP                                                    h  n  x                                         ,  .  0  2  4  7  :  =  @  D  WARNING: Fprint_query cannot print 
     HEADER:
 	opcode = %s  , id = %d , rcode = %s
 	header flags:   response  query , auth. answer , truncation , want recursion , recursion avail.  , primary 
	questions = %d    ,  answers = %d ,  auth. records = %d ,  additional = %d

          QUESTIONS:
 	   , type = %s , class = %s
     ANSWERS:
     ->          AUTHORITY RECORDS:
     ->                                                                                                                                                                                                                                                     $                        ϡ $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                     4 "                 ADDITIONAL RECORDS:
     ->   
------------
 (root)  %-30s                                         0 secs %d day%s   s %d hour%s   s %d min%s  s %d sec%s  s (name truncated?)
  
	type = %s, class = %s, ttl = %u (%s), dlen = %d 
   	inet address = %s
 	inet address = %s      , protocol = %d , port = %d
    	address, class = %d, len = %d
 	canonical name =  	preference = %d , mail exchanger =  	mail group member =  	mail box =  	mailbox rename =  	nameserver =   	host name =  
 	CPU=%.*s 	OS=%.*s
 	origin =  
	mail addr =  
	serial=%lu , refresh=%lu (%s) , retry=%lu (%s)  , expire=%lu (%s) , min=%lu (%s)
 	requests =     
	errors =  	%s
 	%cid %ld
 	%cid of length %ld?
   	inet address = %s, protocol = %d
	  %d (type NULL, dlen %d)
 	%.*s 	???
   packet size error (%#x != %#x)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             SendRequest failed
 Failed: %s, num. answers = %d, ns = %d, additional = %d
 Size (%d) too big
 [%s]  %.*s.%.*s Res_mkquery failed
 %u.%u.%u.%u.in-addr.arpa  res_mkquery() failed
 Res_mkquery failed
                    ------------
SendRequest(), len %d
 SendRequest SendRequest SendRequest response truncated
 SendRequest SendRequest SendRequest Timeout %d
 SendRequest ------------
Old answer:
 truncated answer
 ------------
Got answer (%d bytes):
  ------------
Got answer:
           @(#)skip.c	2.2	(ULTRIX)	4/12/89 C_alloc failed
 %-7s  %s
 Addresses: Address: 
	  %c %s 
Aliases: 
	  %c %s Served by:
 - %s
	 
	 %c %s 
	 
	 %c %s 
 

  >> %s a+ > %s w       Success Format error  Server failed Non-existent domain Not implemented Query refused No change No information  Unspecified error Timed out Non-authoritative answer    BAD ERROR VALUE IN  CHAOS   ANY HS unknown query class: %s
 A NS MX CNAME   SOA MB MG MR    WKS PTR HINFO MINFO AXFR  MAILB ANY UINFO   UID GID TXT     unknown query type: %s
                         address name server mail exchanger      cannonical name start of authority zone mailbox domain name mail group member mail rename name null resource record well known service  domain name pointer host        mailbox (MINFO) zone transfer mail box any type user info       user id group id text %d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        IN HS   ANY %d  A NS  CNAME SOA MB MG MX    TXT MR NULL WKS PTR HINFO MINFO AXFR  MAILB MAILA   ANY UINFO   UID GID %d   	

 !"#$%&'()*+,-./0123456789:;<=>?@abcdefghijklmnopqrstuvwxyz[\]^_`abcdefghijklmnopqrstuvwxyz{|}~    UCX$LIST_HOSTS: Res_mkquery failed
 (root)  %-30s  %-5s  %s  %s  (%d, %d)  (dlen = %d?) 			%lu  
  %-30s   %-5s  ***
  %-30s 	%lu 
  %-30s   %-5s %.*s  %-10s  %-10s     %.*s 		%lu 
  %-30s   %-5s  %.*s 		%lu 
  %-30s   %-5s  %-3d    ***
    %s 	%lu  
  %-30s   %-5s  %s =  host server 	%lu 
  %-30s   %-5s  %-3d   %-3d   %d  %s  %u 	%lu  
  %-30s   %-5s  ***
  %s  ***
  %s. ( %s%d     ) 	%lu  
  %-30s  type = %-5s     , class = %-5s
 	%lu
   (root)  %s  %s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         %                        E $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                     X "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       %s.%s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          &                        jq!r $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                     
 "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    .in-addr.arpa.  BG0:  UCX$INET_HOST LNM$FILE_DEV LNM$SYSTEM_TABLE UCX$INET_HOST UCX$INET_DOMAIN                         !UW.!UW.!UW.!UW                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    '                        ص $      UCX042.B                       c  P  7[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ACCESS_SHR.EXE;1                                                                                                     + "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            * *                                                                                                      ! " ip icmp ggp tcp pup udp IP ICMP GGP TCP PUP UDP                                                                                                                     $      5    	     J    ̄    *        5         5    Q     $5    d        ,5    	     |      Ą    45    <5    D      D5    L5 	   T5 
        \5    D          Ԅ        d5    $   
    
   l5 
         t5    |5    l           @     A     H     r    5        5          5    	                5    (         5    5               5    5         Ā5    ̀5    Ԁ5    ܀5    P          D    5    5    \         5    5    5              !     !    !    !    !   ̂ !    !   5 !     "     "   Ă "   5 "     #   5 #   ,   $     '     (   t   )      -      0   4  1      2      5   |  9      @      A   5 B   5 C   $5 D   ,5 E   45 F   <5 G   D5 H   L5 I   T5 J   \5 K   d5 L   l5 M   t5 N   |5 O   5 P   5 Q   5 R   5 S   5 T                                                                                                                                                                             e           UCX$MSG.EXE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @  @   |     <                                           h  	               (  p      x          8     ,                 H                                  H  P  	  x  p  	  x            8   H             
    i                       @                                                                       DECC$SHR                                                       MTHRTL                                                         LIBRTL                                                         CMA$TIS_SHR                                           H  P  X  \                 \  d  l  p      $  (  p  x                    (  H      H  X  h            $  8  `  t             (  <  d  x                   $  0  <  H  |            h       |  4      <                      (  0  8  @  H  P  X  `  h  P  h                          L  T  X  \  x                         $  (  @  d        p  x        ,  T                          ,  <  L  \  l  |                                    $  <  T                         0  @  P  \  `  d  h  l  x          0  H  P  \  @ D H L P T X \ ` d h l p t x |            $ ( , 0 4 8 <      T ` l x                                                                                                                                                                                                                                                                                                                                                                            B     UCX$ACCESS_SHRUCX V4.2-2118-NOV-1997 12:3518-NOV-1997 12:35  VAX-11 Linker V05-13        	.$$ABS$$.    p   UCX$ACCESS_LICENSE      UCX$$APPEND_DOMAIN      UCX$$GET_DOMAIN        UCX$$GET_DOMAIN_IDENT      UCX$$MAKE_DOMAIN_STRUCT      UCX$$MATCH_DOMAIN      UCX$ACCESS_CLOSE      UCX$ACCESS_CLOSE_SEQ   X   UCX$ACCESS_OPEN   `   | UCX$ACCESS_OPEN_SEQ   h   UCX$ACCESS_REM   P   UCX$ACCESS_MOD   @   UCX$ACCESS_GET   H   < UCX$ACCESS_GET_SEQ   8   < UCX$ACCESS_FIN   (   UCX$ACCESS_CREATE   0   < UCX$ACCESS_CREATE_SEQ        UCX$ACCESS_COPY_CONFIG       UCX$ACCESS_ADD       UCX$ACCESS_ADD_SEQ   x     UCX$ACCESS_GET_BIND_ADDRESS       UCX$ACCESS_GET_BIND_ALLHOSTS      UCX$ACCESS_GET_BIND_ONEHOST      UCX$ACCESS_INIT_BIND      UCX$I_ACCEPT   ?  
UCX$I_BIND   s  
UCX$I_CONNECT     UCX$I_GETHOSTADDR     UCX$I_GETHOSTBYADDR     UCX$I_GETHOSTBYNAME   Y  UCX$I_GETHOSTNAME     UCX$I_GETNETBYADDR     UCX$I_GETNETBYNAME     UCX$I_GETNETENT    +  UCX$I_GETPEERNAME   _  UCX$I_GETPROTOBYNAME     UCX$I_GETPROTOBYNUMBER     UCX$I_GETSERVBYNAME   7  UCX$I_GETSERVBYPORT     UCX$I_GETSOCKNAME     UCX$I_GETSOCKOPT     UCX$I_LISTEN     
UCX$I_RECV   T  UCX$I_RECVFROM     
UCX$I_RECVMSG     UCX$I_SCLOSE     UCX$I_SELECT   @  
UCX$I_SEND   y  
UCX$I_SENDMSG     UCX$I_SENDTO     UCX$I_SETSOCKOPT     UCX$I_SHUTDOWN   S  UCX$I_SOCKET      UCX$LIST_HOSTS         UCX$NSLOOKUP_STOP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               (                        5 $      UCX042.B                       Vc	  P  5[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BGDRIVER.EXE;1                                                                                                                     5 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BGDRIVER.EXE;1 +  , Vc	   .     / #   4                             - P    0   1    2   3      K  P   W   O     5   6 oPכ  7 au؛  8          9          G    H  J                           0 D `    0205        tPW                                                       BGDRIVER                               UCX V4.2-21    tPכ 05-13             Q                        8               UCX$BGDRIVE                                                                                      4r       < N x   d     T#    (* (* H   b  (*     (* (* 8) (*    (* (* (* (* (* (* (*                                                                                              ~          }          |          p   < P8! < P8! < P8! < P8! < P8! < P8! < P8! < P8! < P8! < P8! < P8!      8                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       6 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BINDSETUP.COM;1 +  , J   . @    / #   4 f   @   4 h                   - P    0   1    2   3      K  P   W   O A    5   6 Af؛  7 u؛  8          9          G    H  J                         K $!  Copyright (c) 1997 Digital Equipment Corporation.  All rights reserved.  $Start: 	 $Set NoOn  $Debug=(0'UCX$BIND_SETUP_DEBUG)  $GoSub Check_Priv  $GoSub Setup_Local_Symbols $GoSub Translate_Logicals  $If $STATUS .EQS. "%X00000001" $Then  $Deassign Sys$OutPut $Display "" 9 $Display "UCX MUST be started to execute this procedure."  $Display "" 
 $GoTo Exit $EndIf $GoSub Check_BIND_Service  $If $STATUS .EQS. "%X00000001" $Then  $Display "" H $Display "The BIND Server must be configured to execute this procedure." $Display "" 
 $GoTo Exit $EndIf $Get_Option: $Change_Made=0 $Option_Done=0 $Primary_Setup=0 $GoSub Main_Menu& $If Config_Option .EQS. Primary_Option $Then  $Primary_Setup=1 $GoSub Server_Setup  $EndIf@ $If Config_Option .EQS. Secondary_Option Then GoSub Server_SetupC $If Config_Option .EQS. Forwarder_Option Then GoSub Forwarder_Setup = $If Config_Option .EQS. Display_Option Then GoSub Show_Config @ $If Config_Option .EQS. Restart_Option Then GoSub Restart_Server: $If Config_Option .EQS. Test_Option Then GoSub Test_Server> $If Config_Option .EQS. Remove_Option Then GoSub Remove_Config; $If Config_Option .EQS. Help_Option Then GoSub Display_Help 2 $If Config_Option .EQS. Exit_Option Then Goto Exit $If Option_Done  $Then  $GoTo Get_Option $Else < $Display "Invalid configuration option, please try again..." $Wait 00:00:01 $EndIf $Goto Get_Option $Server_Setup:& $On Error Then Goto Server_Input_Error
 $Clear_Screen 
 $Good_Setup=0  $If Primary_Setup .EQ. 0 $Then  $Setup_Type="SECONDARY"  $Else  $Setup_Type="PRIMARY"  $EndIf $Display "" 2 $Display "''Setup_Type' Name Server Configuration" $Display "" D $Read Sys$Command I_Domain /PROMPT="Enter domain [''Inet_Domain']: ". $If I_Domain .eqs."" Then I_Domain=Inet_Domain) $I_Domain=F$Edit(I_Domain, "TRIM,UPCASE")  $Rev=0 $GoSub Create_DB_FileName & $On Error Then Goto Server_Input_Error $I_Filename=I_Filename+".DB"D $Read Sys$Command I_File /PROMPT="Domain database [''I_Filename']: "* $If I_File .eqs. "" Then I_File=I_Filename% $I_File=F$Edit(I_File, "TRIM,UPCASE")  $GoSub Create_Reverse_Address & $On Error Then Goto Server_Input_Error& $Rev_Addr_Plus=Rev_Addr+"IN-ADDR.ARPA"U $Read Sys$Command R_Domain /PROMPT="Enter reverse lookup domain [''Rev_Addr_Plus']: " 0 $If R_Domain .eqs."" Then R_Domain=Rev_Addr_Plus) $R_Domain=F$Edit(R_Domain, "TRIM,UPCASE")  $Rev=1 $GoSub Create_DB_FileName & $On Error Then Goto Server_Input_Error( $I_Filename=I_Filename+"IN-ADDR_ARPA.DB"S $Read Sys$Command R_File /PROMPT="Reverse lookup Domain database [''I_Filename']: " * $If R_File .eqs. "" Then R_File=I_Filename% $R_File=F$Edit(R_File, "TRIM,UPCASE")  $Get_Transfer_Host:  $If Primary_Setup .EQ. 0 $Then & $On Error Then GoTo Server_Input_ErrorO $Read Sys$Command X_Host /PROMPT="Enter host from which to tranfer zone data: "  $If (X_Host .EQS. "")  $Then 7 $Display "Please enter the name of the host from which" 1 $Display "to transfer information for this zone."  $Display ""  $GoTo Get_Transfer_Host  $EndIf	 $Set NoOn / $If .not. Debug Then DEFINE/NOLOG Sys$Error NL: 0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:6 $If Debug Then Display "UCX SHOW HOST/LOCAL ''X_HOST'" $UCX SHOW HOST/LOCAL 'X_HOST $If $Status .EQS. "%X130A80BA" $Then  $DEASSIGN SYS$OUTPUT $Display "" : $Display "Host ''X_HOST is not in the local UCX database." $DEASSIGN SYS$OUTPUT $GoSub Add_Host  $If $STATUS .Eqs. "%X00000001" $Then 9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "  $GoTo Server_Exit  $EndIf $EndIf $EndIf	 $Set NoOn  $Display "" ] $Display "UCX SET CONFIGURATION BIND /PRIMARY=(DOMAIN=0.0.127.IN-ADDR.ARPA,FILE=NAMED.LOCAL)" / $If .not. Debug Then DEFINE/NOLOG Sys$Error NL: 0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:S $UCX SET CONFIGURATION BIND /PRIMARY=(DOMAIN=0.0.127.IN-ADDR.ARPA,FILE=NAMED.LOCAL)  $DEASSIGN SYS$OUTPUT $Display ""  $If Primary_Setup .EQ. 1 $Then Q $Display "UCX SET CONFIGURATION BIND/PRIMARY=(DOMAIN:''I_Domain',FILE:''I_FILE')" / $If .not. Debug Then DEFINE/NOLOG Sys$Error NL: 0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:C $UCX SET CONFIGURATION BIND/PRIMARY=(DOMAIN:'I_DOMAIN,FILE:'I_FILE)  $Else(b $Display "UCX SET CONFIGURATION BIND/SECONDARY=(DOMAIN:''I_Domain',FILE:''I_FILE',HOST:''X_HOST')"/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:g0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:S $UCX SET CONFIGURATION BIND/SECONDARY=(DOMAIN:'I_DOMAIN,FILE:'I_FILE,HOST:'X_HOST')B $EndIf4 $If $Status .EQS. "%X130A8472" Then GoTo Dup_Error_I $DEASSIGN SYS$OUTPUT $Display ""t $If Primary_Setup .EQ. 1 $ThenoW $Display "UCX SET CONFIGURATION BIND/''Setup_Type'=(DOMAIN:''R_Domain',FILE:''R_FILE')" / $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:t0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:G $UCX SET CONFIGURATION BIND/'Setup_Type=(DOMAIN:'R_DOMAIN,FILE:'R_FILE)T $Elseuf $Display "UCX SET CONFIGURATION BIND/''Setup_Type'=(DOMAIN:''R_Domain',FILE:''R_FILE',HOST:''X_HOST')"/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL: 0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:T $UCX SET CONFIGURATION BIND/'Setup_Type=(DOMAIN:'R_DOMAIN,FILE:'R_FILE,HOST:'X_HOST) $EndIf4 $If $Status .EQS. "%X130A8472" Then GoTo Dup_Error_R $DEASSIGN SYS$OUTPUT $Display ""D; $Display "UCX SET CONFIGURATION BIND /CACHE=(FILE=NAMED.CA)x/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:E0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:2 $UCX SET CONFIGURATION BIND /CACHE=(FILE=NAMED.CA)4 $If $Status .EQS. "%X130A8472" Then GoTo Dup_Error_C
 $Good_Setup=1r
 $GoTo Go_Show_
 $Dup_Error_I:r $DEASSIGN SYS$OUTPUT $Display ""T3 $Display "An entry for ''I_Domain' already exists."d
 $GoTo Go_Show 
 $Dup_Error_R:e $DEASSIGN SYS$OUTPUT $Display """3 $Display "An entry for ''R_Domain' already exists."n
 $GoTo Go_Shown
 $Dup_Error_C:  $DEASSIGN SYS$OUTPUT $Display ""I* $Display "A caching entry already exists."
 $Good_Setup=1v	 $Go_Show:C $DEASSIGN SYS$OUTPUT $Display ""GR $Read Sys$Command Junk /PROMPT="Enter <CR> to display the current configuration: " $GoSub Show_Config4 $If (Good_Setup .EQ. 1) .and. (Primary_Setup .EQ. 1) $Thene $GoSub Convert_Local_DB" $Endif: $If (I_Domain .EQS. Inet_Domain) .AND. (Good_Setup .EQ. 1) $ThenI $GoSub Configure_ResolverR $EndIf $Server_Input_Error: $If $STATUS .EQS. "%X0001827A" $Thene $DEASSIGN SYS$OUTPUT $Display ""]9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "D $EndIf
 $Server_Exit:" $Option_Done=1 $ReturnG $Forwarder_Setup:N $Setup_Type="FORWARDER"  $Get_Forwarder_Host:) $On Error Then Goto Forwarder_Input_ErroraU $Read Sys$Command X_Host /PROMPT="Enter ho                                                                                                                                                                   )                        & $      UCX042.B                       J  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BINDSETUP.COM;1                                                                         f    @                          "            st to forward requests outside this zone: "_ $If (X_Host .EQS. "")l $Thene> $Display "Please enter the name of the host to which requests"A $Display "for information outside this zone should be forwarded."p $Display ""a $GoTo Get_Forwarder_Host $EndIf	 $Set NoOn / $If .not. Debug Then DEFINE/NOLOG Sys$Error NL: 0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:6 $If Debug Then Display "UCX SHOW HOST/LOCAL ''X_HOST'" $UCX SHOW HOST/LOCAL 'X_HOST $If $Status .EQS. "%X130A80BA" $Thent $DEASSIGN SYS$OUTPUT $Display ""/; $Display "Host ''X_HOST' is not in the local UCX database."u $GoSub Add_Hostu $If $STATUS .Eqs. "%X00000001" $Then_9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "1 $GoTo Forwarder_Exit $EndIf $EndIf@ $Display "UCX SET CONFIGURATION BIND/FORWARDER=(HOST:''X_HOST')"/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL: 0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:4 $UCX SET CONFIGURATION BIND/FORWARDER=(HOST:'X_HOST) $If $STATUS .Eqs. "%X130A8472" $Then  $DEASSIGN SYS$OUTPUT $Display """: $Display "A forwarder entry for ''X_HOST' already exists!" $EndIf $DEASSIGN SYS$OUTPUT $Display ""hR $Read Sys$Command Junk /PROMPT="Enter <CR> to display the current configuration: " $GoSub Show_Config $Forwarder_Input_Error:0 $If $STATUS .EQS. "%X0001827A" $ThenD $DEASSIGN SYS$OUTPUT $Display ""I9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "T $EndIf $Forwarder_Exit: $Option_Done = 1 $Return 
 $Show_Config:u $On Error Then Goto Show_ExitL $Return_Status=-1 
 $Clear_ScreenO $GoSub Verify_ConfigurationN $If $STATUS .EQS. "%X00000001" $ThenI $Return_Status=1 $GoTo Show_Exit" $EndIf/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:F $Display "",& $Display "UCX SHOW CONFIGURATION BIND" $UCX SHOW CONFIGURATION BIND $Display "" 9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "N $Show_Exit:D $Option_Done = 1 $Return 'Return_Status $Main_Menu:I $On Error Then GoTo Menu_Exite $Config_Option="" 
 $Clear_ScreenU $Display ""yA $Display "   DIGITAL TCP/IP Services for OpenVMS BIND Setup Menu"T $Display ""t) $Display "      1 - Setup Primary Server")+ $Display "      2 - Setup Secondary Server"o+ $Display "      3 - Create Forwarder Entry"$7 $Display "      4 - Display Current BIND Configuration"I $Display ""I+ $Display "      5 - Restart the BIND ServerG( $Display "      6 - Test the BIND Server@ $Display "      7 - Remove the current BIND Server configuration $Display ""o6 $Display "     [?] - Help on setting up a BIND Server"- $Display "     [E] - Exit BIND Configuration"I $Display ""IF $Read Sys$Command Config_Option /PROMPT="Enter configuration option: "5 $Config_Option = F$Edit(Config_Option, "TRIM,UPCASE")s $Menu_Exit: 3 $If Config_Option .EQS. "" Then Config_Option = "E" 	 $Set NoOnD $ReturnO $Translate_Logicals:	 $Set NoOn  $Return_Status = -1$E $Inet_Domain = F$Trnlnm("UCX$INET_DOMAIN","LNM$SYSTEM",,"EXECUTIVE",)a $If Inet_Domain .EQS. "" $ThenD $Display ""G6 $Display "The logical UCX$INET_DOMAIN is not defined." $Return_Status = 1 $EndIfA $Inet_Host = F$Trnlnm("UCX$INET_HOST","LNM$SYSTEM",,"EXECUTIVE",)  $If Inet_Host .EQS. "" $ThenU $Display ""y4 $Display "The logical UCX$INET_HOST is not defined." $Return_Status = 1 $EndIfI $Inet_Hostaddr = F$Trnlnm("UCX$INET_HOSTADDR","LNM$SYSTEM",,"EXECUTIVE",)e $If Inet_Hostaddr .EQS. "" $Thenh $Display ""G8 $Display "The logical UCX$INET_HOSTADDR is not defined." $Return_Status = 1 $EndIfN $Inet_Configuration = F$Trnlnm("UCX$CONFIGURATION","LNM$SYSTEM",,"EXECUTIVE",) $If Inet_Configuration .EQS. ""b $Thent $Display ""E8 $Display "The logical UCX$CONFIGURATION is not defined." $Return_Status = 1 $EndIfB $Inet_Service = F$Trnlnm("UCX$SERVICE","LNM$SYSTEM",,"EXECUTIVE",) $If Inet_Service .EQS. ""  $ThenP $Display """2 $Display "The logical UCX$SERVICE is not defined." $Return_Status = 1 $EndIf/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:p0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL: $SHOW SYSTEM/OUT=BIND.TMPr $SEARCH BIND.TMP UCX$INET_ACPm $If $STATUS .NES. "%X00000001" $Thenr $DEASSIGN SYS$OUTPUT	 $Return 1  $EndIf $Translate_Logicals_Exit:s	 $Set NoOne $Return 'Return_Status $Setup_Local_Symbols:  $Display:=Write Sys$Output $More:=Type/Page $Clear_Screen:= 'More NL:l $Primary_Option = "1"r $Secondary_Option = "2"O $Forwarder_Option = "3"D $Display_Option = "4"L $Restart_Option = "5"n $Test_Option = "6" $Remove_Option = "7" $Help_Option = "?" $Exit_Option = "E" $Config_Option = ""C $I_Domain = ""# $BIND_Loc="SYS$SPECIFIC:[UCX$BIND]"D/ $Help_File="SYS$MANAGER:UCX$BINDSETUP_HELP.TXT"' $Returni $Count_Mask:	 $Set NoOnt $Define sys$Output Int.Tmp $UCX SHOW INTERFACE0 $Deassign Sys$Output# $Sea Int.Tmp "255."/Output=Int1.Tmp> $Open/Read Int Int1.Tmpo $Read Int Int_1d
 $Close Int" $Delete/Nolog Int.Tmp;*,Int1.Tmp;* $Len=F$Length(Int_1) $Loc=F$Locate("255",Int_1)# $Int_1=F$Extract(Loc,Len-Loc,Int_1)t $Int_1=F$Element(0," ",Int_1)u
 $Mask_Count=0S $Mask_Loop:I" $Octet_Mask=F$Element(0,".",Int_1). $If Octet_Mask .NES. "255" Then Goto Mask_Exit $Mask_Count=Mask_Count+1 $Len=F$Length(Int_1) $Loc=F$Locate(".",Int_1)% $Int_1=F$Extract(Loc+1,Len-Loc,Int_1)T $GoTo Mask_LoopR $Mask_exit:n $ReturnR $Create_Reverse_Address:
 $Start = 0 $Tmp_Str=""o $Str=""S $Rev_Addr = Inet_HostaddrI $GoSub Count_MaskS $Addr_Construct: $Len = f$length("''Rev_Addr'")* $If (Len .GT. 0) .and. (Mask_Count .GE. 0) $Then" $Tmp_Str=Str+Tmp_Str $Mask_Count=Mask_Count-1 $ElseO $Rev_Addr=Tmp_Strt $GoTo Rev_Addr_done  $Endif> $Str = f$Extract(Start, f$Locate(".", Rev_Addr), Rev_Addr)+"."; $Rev_Addr=f$Extract(f$Locate(".", Rev_Addr)+1,len,Rev_Addr)e) $If (Len .GE. 0) Then Goto Addr_Constructd $Rev_Addr_Done:u $ReturnF $Create_DB_FileName: $If Revl $Then  $Tmp_Domain=R_Domain% $Start=F$Locate("IN-ADDR",Tmp_Domain)O $Len=F$Length(Tmp_Domain)  $If Start .ne. Len $Thenn) $Tmp_Domain=F$Extract(0,Start,Tmp_Domain)t $EndIf $ElseR $Tmp_Domain=I_Domain $Endif $Start=0 $Tmp_Str=""T $Str=""i $Name_Construct: $Len=F$Length(Tmp_Domain)l $Pos=F$Locate(".", Tmp_Domain)/ $Str = F$Extract(Start, Pos-Start , Tmp_Domain)l $If Pos .LT. Len $Then  $Tmp_Str=Tmp_Str+str+"_"+ $Tmp_Domain=F$Extract(Pos+1,Len,Tmp_Domain)  $GoTo Name_Construct $Elser $Tmp_Str=Tmp_Str+Tmp_Domain  $EndIf $DB_FileName_Done:% $I_Filename=f$Edit(Tmp_Str,"UPCASE")'" $Return 
 $Add_Host:" $On Error Then GoTo Add_Host_Error $Return_Status=-1 H $Read Sys$Command Add_It /Prompt="Would you like to add this host <Y>? " $Ans=F$Extract(0,1,Add_It) $If Ans .eqs. "" Then Ans="Y""4 $If (F$Edit(Ans, "TRIM,UNCOMMENT,UPCASE")) .NES. "Y" $ThenIH $Display "''Setup_Type' setup cannot continue without this information!" $Wait 00:00:02 $Return_Status=1 $GoTo Add_Host_Exit  $EndIf $Ext_Host=F$Extract(0,1,X_HOST)T# $If F$Type(Ext_Host) .EQS. "STRING"  $ThenOT $Read Sys$Command IP_Addr /Prompt="Please enter the IP Address for host ''X_HOST': " $Ip_Name=X_HostM $Else"M $Read Sys$Command IP_Name /Prompt="Please enter the name of host ''X_HOST': "  $IP_Addr=X_HostD $EndIf5 $Display "UCX SET HOST ''IP_NAME'/ADDRESS=''IP_Addr'"=/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:E0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:' $UCX SET HOST 'IP_Name/ADDRESS='IP_Addrn $Add_Host_Error: $If $STATUS .EQS. "%X130A836B" $Then= $DEASSIGN SYS$OUTPUT $Display ""S: $Display "''IP_Name' already exists with another address." $Display ""  $UCX SHOW HOST 'IP_Name/LOCALH $Display ""t< $Display "Address ''IP_Addr' will be used as you requested." $Display ""$ $GoTo Add_Host_ExitY $EndIf $If $STATUS .EQS. "%X0001827A" $ThenQ $DEASSIGN SYS$OUTPUT $Display ""l $Return_Status=1 $GoTo Add_Host_Exitt $EndIf $If $STATUS .EQS. "%X130A80BA" $Thene $DEASSIGN SYS$OUTPUT $Display ""$0 $Display "Address ''IP_Addr' is already in use." $Display ""s $UCX SHOW HOST 'IP_Addr/LOCAL  $Display ""sZ $Display "''Setup_Type setup cannot continue using host ''IP_name with address ''IP_Addr." $Display ""e $Return_Status=1 $GoTo Add_Host_ExitS $EndIf $Add_Host_Exit: 	 $Set NoOnD $Return 'Return_Status $Remove_Config:0 $Return_Status=-1D/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:e $GoSub Show_Config; $If $STATUS .EQS. "%X00000001" Then GoTo Remove_Config_Exits& $On Error Then GoTo Remove_Config_Exit $Display ""e^ $Read Sys$Command Remove_It /Prompt="Are you sure you want to delete this configuration <N>? " $Ans=F$Extract(0,1,Remove_It)t $If Ans .eqs. "" Then Ans="N" 4 $If (F$Edit(Ans, "TRIM,UNCOMMENT,UPCASE")) .EQS. "Y" $Then  $Display ""n' $Display "UCX SET CONFIGURATION NOBIND"E $UCX SET CONFIGURATION NOBIND"                                                                                                                                                                                                                                                   *                        3 $      UCX042.B                       J  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BINDSETUP.COM;1                                                                         f    @                         * "            F $If BIND_Server_Running .EQ. 1 Then @SYS$MANAGER:UCX$BIND_SHUTDOWN.COM/ $Display "BIND configuration removal complete."0 $Elses $Display ""t. $Display "BIND configuration removal aborted." $EndIf $Display ""a9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "* $Remove_Config_Exit: $Option_Done=1 $Return_ $Check_Priv:U $If (f$Privilege("SYSPRV") .EQS. "FALSE") .AND. (f$Privilege("BYPASS") .EQS. "FALSE")I $ThentQ $Write sys$OutPut "SYSPRV or BYPASS privilege is required to run this procedure."_
 $GoTo Exit $EndIf $Returnn $Check_BIND_Service: $Return_Status=-1t $Bind_Server_Running=0 $SEARCH BIND.TMP UCX$BINDR $If $STATUS .EQS. "%X00000001" $Thens $BIND_Server_Running=1 $EndIf $DELETE/NOLOG BIND.TMP;* $DEASSIGN SYS$OUTPUT/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:(0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:C $If Debug Then Display "UCX SHOW CONFIGURATION ENABLE SERVICE BIND"s+ $UCX SHOW CONFIGURATION ENABLE SERVICE BIND  $If $STATUS .NES. "%X00000001" $Thene $DEASSIGN SYS$OUTPUT $Display ""v7 $Display "The BIND Server has not yet been configured." 9 $Display "This is done using SYS$MANAGER:UCX$CONFIG.COM."u $Wait 00:00:02 $Return_Status=1 $EndIf/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:I0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:. $If Debug Then Display "UCX SHOW SERVICE BIND" $UCX SHOW SERVICE BIND $If $STATUS .EQS. "%X130A81A0" $ThenE $DEASSIGN SYS$OUTPUT $Display """+ $Display "The BIND Service is not defined."n9 $Display "This is done using SYS$MANAGER:UCX$CONFIG.COM."  $Wait 00:00:02 $Return_Status=1 $EndIf $DEASSIGN SYS$OUTPUT $Check_BIND_Service_Exit:$	 $Set NoOn+ $Return 'Return_Status $Restart_Server:
 $Clear_ScreenrO $If (Config_Option .eqs. Restart_Option) .or. (Config_Option .eqs. Test_Option)A $Then  $DEASSIGN SYS$OUTPUT $Display ""n* $Display "Restarting the UCX BIND Service"# $@SYS$MANAGER:UCX$BIND_SHUTDOWN.COM  $BIND_Server_Running=0 $Option_Done=1 $EndIf/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL: 0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:0 $If Debug Then Display "UCX ENABLE SERVICE BIND" $UCX ENABLE SERVICE BIND $If $STATUS .NES. "%X130A8372" $Then  $DEASSIGN SYS$OUTPUT $Display ""H, $Display "The BIND Service has been enabled. $Wait 00:00:02 $EndIf $DEASSIGN SYS$OUTPUT/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:h0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:> $If Debug Then Display "Checking for installed BIND images..."+ $Library = "SYS$SYSTEM:UCX$BIND_SERVER.EXE""D $If F$Search (Library) .NES. "" .AND. .NOT. F$File (Library,"KNOWN") $ThenO $DEASSIGN SYS$OUTPUT $Display ""h! $Display "Installing ''Library'."X@ $Display "INSTALL CREATE ''LIBRARY'/HEADER/SHARE/PRIVILEGED=OPER5 $INSTALL CREATE 'LIBRARY/HEADER/SHARE/PRIVILEGED=OPERs $Wait 00:00:02 $EndIf $DEASSIGN SYS$OUTPUT/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:O0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:0 $Library = "SYS$SYSTEM:UCX$BIND_SERVER_XFER.EXE"D $If F$Search (Library) .NES. "" .AND. .NOT. F$File (Library,"KNOWN") $ThenQ $DEASSIGN SYS$OUTPUT $Display ""l! $Display "Installing ''Library'."E@ $Display "INSTALL CREATE ''LIBRARY'/HEADER/SHARE/PRIVILEGED=OPER5 $INSTALL CREATE 'LIBRARY/HEADER/SHARE/PRIVILEGED=OPER  $Wait 00:00:02 $EndIfO $If (Config_Option .eqs. Restart_Option) .or. (Config_Option .eqs. Test_Option)p $Then 	 $Set NoOni $DEASSIGN SYS$OUTPUT $Display ""_* $Display "UCX SET NAME_SERVICE/INITIALIZE"/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:N0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:  $UCX SET NAME_SERVICE/INITIALIZE $EndIf $DEASSIGN SYS$OUTPUT $Returnb $Verify_Configuration:	 $Set NoOn0 $Return_Status=-1R/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:n0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL: $UCX SHOW CONFIGURATION BIND $If $STATUS .EQS. "%X130A8472" $Then  $DEASSIGN SYS$OUTPUT $Display "" ( $Display "No current BIND configuration" $Display ""M9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "C $Return_Status=1 $Endif $DEASSIGN SYS$OUTPUT $Return 'Return_Status
 $Test_Server:E
 $Clear_ScreenM $GoSub Verify_Configuration 9 $If $STATUS .EQS. "%X00000001" Then GoTo Test_Server_ExitD $GoSub Restart_ServerI% $On Error Then GoTo Test_Server_Errord/ $If I_Domain .EQS. "" Then I_Domain=Inet_Domain" $Display "" D $Read Sys$Command Test_Domain /PROMPT="Enter domain [''I_Domain']: "2 $If Test_Domain .EQS. "" Then Test_Domain=I_Domain $Display ""eJ $Display "UCX SHOW HOST/NOLOCAL/SERVER=''Inet_Host'/DOMAIN=''Test_Domain'"< $UCX SHOW HOST/NOLOCAL/SERVER='Inet_Host/DOMAIN='Test_Domain $Display ""C9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "g $Display ""I $Display "Executing:"S $Display "  $MCR UCX$NSLOOKUP"" $Display "  > server ''Inet_Host'"$ $Display "  > ls -l ''Test_Domain'." $Display "  > exit"u $Display ""/ $Open/Write BIND_TMP BIND.TMP # $Write BIND_TMP "$MCR UCX$NSLOOKUP": $Write BIND_TMP "$DECK""% $Write BIND_TMP "server ''Inet_Host'"I& $Write BIND_TMP "ls -l ''Test_Domain'" $Write BIND_TMP "exit" $Write BIND_TMP "$EOD" $Write BIND_TMP "$Exit"  $Close BIND_TMPs
 $@BIND.TMP $DELETE/NOLOG BIND.TMP;* $Display "" 9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "u $GoTo Test_Server_Exit $Test_Server_Error:I $If $STATUS .EQS. "%X0001827A" $Theno $DEASSIGN SYS$OUTPUT $Display ""/9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "I $EndIf $Test_Server_Exit: $DEASSIGN SYS$OUTPUT $Option_Done=1 $ReturnD $Convert_Local_DB:& $On Error Then GoTo Convert_Reverse_DBJ $Read Sys$Command Ans /Prompt="Would you like to populate ''I_File' <Y>? " $Ans=F$Extract(0,1,Ans)r $If Ans .eqs. "" Then Ans="Y"Y* $If (F$Edit(Ans, "TRIM,UPCASE")) .NES. "Y" $ThenR $GoTo Convert_Reverse_DB $Elser $Display ""S $I_File=BIND_Loc+I_Filen? $Display "UCX CONVERT/ULTRIX BIND ''I_File'/DOMAIN=''I_Domain'"T1 $UCX CONVERT/ULTRIX BIND 'I_File/DOMAIN='I_Domain" $Display ""e1 $Display "''I_File' database conversion complete". $EndIf  $If (I_Domain .NES. Inet_Domain) $Thend $Display "" A $Display "Since ''I_Domain' is different than your local domain,"/> $Display "''Inet_Domain, a partial file may have been created. $Display ""E7 $Display "You may need to populate this file manually."  $Display ""Y $EndIfB $Read Sys$Command Junk /PROMPT="Enter <CR> to display ''I_File': "
 $Clear_Screenf $Display ""Y
 $More 'I_Filen $Display ""n9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "O $Convert_Reverse_DB:$ $On Error Then GoTo Convert_DB_ErrorJ $Read Sys$Command Ans /Prompt="Would you like to populate ''R_File' <Y>? " $Ans=F$Extract(0,1,Ans)  $If Ans .eqs. "" Then Ans="Y"O* $If (F$Edit(Ans, "TRIM,UPCASE")) .NES. "Y" $ThenD $GoTo Convert_DB_Exitb $ElseX $Display ""N $R_File=BIND_Loc+R_FileE? $Display "UCX CONVERT/ULTRIX BIND ''R_File'/DOMAIN=''R_Domain'"/1 $UCX CONVERT/ULTRIX BIND 'R_File/DOMAIN='R_Domain  $Display ""I1 $Display "''R_File' database conversion complete"  $EndIf" $If (R_Domain .NES. Rev_Addr_Plus) $Thena $Display ""TA $Display "Since ''R_Domain' is different than your local reverse" B $Display "address, ''Rev_Addr_Plus', a partial file may have been" $Display "created."t $Display ""a7 $Display "You may need to populate this file manually."P $Display ""R $EndIf# $On Error Then GoTo Convert_DB_ExitLB $Read Sys$Command Junk /PROMPT="Enter <CR> to display ''R_File': "
 $Clear_ScreenC $Display "".
 $More 'R_Filen $Display ""S9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "  $GoTo Convert_DB_ExitL $Convert_DB_Error: $If $STATUS .EQS. "%X0001827A" $Then # $On Error Then GoTo Convert_DB_Exitp $DEASSIGN SYS$OUTPUT $Display ""A3 $Display "Database conversion aborted prematurely."_9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "e $EndIf $Convert_DB_Exit:r $Display "" 	 $Set NoOn  $ReturnN $Display_Help:  $File = F$Search("''Help_File'") $If File .EQS. ""S $Then0A $Display "Sorry, help is not available - ''Help_File' not found."r $ElseN $More 'Help_File $EndIf $Display ""y9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "_ $Option_Done = 1 $Return  $Configure_Resolver:	 $Set NoOns $Re=""/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:t0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL: $UCX SHOW CONFIGURATION NAME+ $If $STATUS .EQS. "%X130A8472" Then re="re"o $DEASSIGN SYS$OUTPUT, $On Error Then GoTo Configure_Resolver_Error $Display ""m? $Display "You have configured this system as the ''Setup_Type'"D8 $Display "server for the domain in which it it resides." $Display ""H5 $Display "Would you like to ''re'configure your BIND"nU $Read Sys$Command Ans /Prompt="resolve                                                                                                                                                                                                                                                   +                        I $      UCX042.B                       J  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BINDSETUP.COM;1                                                                         f    @                         & 
     0       r to use ''Inet_Host' as the BIND server <Y>? "y $Ans=F$Extract(0,1,Ans)n $If Ans .eqs. "" Then Ans="Y"l* $If (F$Edit(Ans, "TRIM,UPCASE")) .NES. "Y" $ThenX $GoTo Configure_Resolver_Exitr $Else_ $Goto Setup_Resolver $EndIf $Setup_Resolver:	 $Set NoOn  $Display ""l& $Display "UCX SET NAME/SYSTEM/DISABLE"/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:_0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL: $UCX SET NAME/SYSTEM/DISABLE $DEASSIGN SYS$OUTPUT $Display """) $Display "UCX SET NAME/SYSTEM/NOSERVER=*"$/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:O0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL: $UCX SET NAME/SYSTEM/NOSERVER=*  $DEASSIGN SYS$OUTPUT $Display ""eO $Display "UCX SET NAME/SYSTEM/SERVER=''Inet_Host'/DOMAIN=''Inet_Domain'/ENABLE"l/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:>0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:A $UCX SET NAME/SYSTEM/SERVER='Inet_Host/DOMAIN='Inet_Domain/ENABLE  $DEASSIGN SYS$OUTPUT $Display "" ' $Display "UCX SET CONFIGURATION NONAME"l/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:00 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL: $UCX SET CONFIGURATION NONAME" $DEASSIGN SYS$OUTPUT $Display ""BO $Display "UCX SET CONFIGURATION NAME/SERVER=''Inet_Host'/DOMAIN=''Inet_Domain'"N/ $If .not. Debug Then DEFINE/NOLOG Sys$Error NL:T0 $If .not. Debug Then DEFINE/NOLOG Sys$Output NL:A $UCX SET CONFIGURATION NAME/SERVER='Inet_Host/DOMAIN='Inet_DomainD, $On Error Then GoTo Configure_Resolver_Error $DEASSIGN SYS$OUTPUTa $Read Sys$Command Junk /PROMPT="Enter <CR> to display your running BIND Resolver configuration: "e $Display ""D $UCX SHOW NAME $Display "" c $Read Sys$Command Junk /PROMPT="Enter <CR> to display your permanent BIND Resolver configuration: "C $UCX SHOW CONFIG NAME: $GoTo Configure_Resolver_ExitY $Configure_Resolver_Error: $If $STATUS .EQS. "%X0001827A" $Thene $DEASSIGN SYS$OUTPUT $GoTo Configure_Resolver_Exito $EndIf $Configure_Resolver_Exit:  $On Error Then Return= $Display ""k9 $Read Sys$Command Junk /PROMPT="Enter <CR> to continue: "I $Returns $Exit:
 $Set NoVerify , $Write Sys$OutPut "Exiting UCX$BINDSETUP..." $Exit                                                                                                                                                                                                                                                                                                                                                                                                                                      ; * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BINDSETUP_HELP.TXT;1 +  , J   .     / #   4 I      
                     - P    0   1    2   3      K  P   W   O     5   6 QjԖĚ  7 u؛  8          9          G    H  J                    E UCX$BINDSETUP.COM is designed to step you through three types of BIND 4 Servers -- Primary, Secondary and a Forwarder Entry.  E Additional information on setting up BIND Servers is available in the 6 Digital TCP/IP Services for OpenVMS Management guide.   D Information relating to specific setup commands is available in the ? Digital TCP/IP Services for OpenVMS Command Reference Guide. In C particular, UCX SET CONFIGURATION BIND, is used to create or modify  you BIND Server configuration.  E Online help is also available using UCX> HELP SET CONFIGURATION BIND.    Required Privileges: -------------------   B         UCX$BINDSETUP.COM requires the user to have either SYSPRIV         or BYPASS privilege.   Preliminary Steps: -----------------   ?         Enable the BIND Server using SYS$MANAGER:UCX$CONFIG.COM >         Option 3 - Server Components. This will create two keyC         files in SYS$SPECIFIC:[UCX$BIND]: named.local and named.ca.   A         Note: Do not confuse this with the BIND Resolver (client) =               which is setup using SYS$MANAGER:UCX$CONFIG.COM *               Option 1 - Core environment.  A         UCX must be started prior to running this procedure since @         certain default values are determined from UCX logicals )         that are created when UCX starts.   ! UCX$BINDSETUP Menu Setup Options:   --------------------------------  @         Primary Server - A Primary Server is authoritative for a@                          given domain ("zone"). This is the host>                          which contains the master database ofC                          hostname to Internet address translations.   C         Secondary Server - A Secondary Server receives information  @                            from a Primary Server via a mechanism@                            known as a "zone transfer". The StartB                            of Authority (SOA) record which is sentA                            from the Primary Server during a zone  E                            transfer determines the frequency at which @                            the Secondary Server will request new?                            information from the Primary Server.   C         Forwarder Entry - This entry specifies a particular host to C                           which requests outside our zone are sent. C                           (A form of Internet courtesy so that only I                            a limited number of hosts actually communicate E                            with the root servers listed in named.ca).   D         You can also Display the current BIND configuration from the 	UCX$BINDSETUP.COM main menu.    Key User Input:  --------------  < 	When setting up a Primary or Secondary Server you will need; 	to know the domain for which a configuration entry will be > 	created. By default host-to-IP address information is stored = 	in a database named the same as the domain (with underscores / 	used in place of periods) and ".DB" appended.    < 	You will also be asked for your reverse lookup domain. This; 	allows your server to return the associated IP address if  : 	a hostname is sent to the server. The database is created 	as described above.  9 	An entry for the domain "0.0.127.IN-ADDR.ARPA" using the 9 	file "named.local" is required and will be automatically 6 	created during the Primary or Secondary Server setup.  = 	An entry for the root (".") domain using the file "named.ca" = 	will also be created. This entry is not required and can be   	removed using the command:   % 		UCX> SET CONFIGURATION BIND/NOCACHE   @ 	In either case, the database files are created in the directory 	SYS$SPECIFIC:[UCX$BIND].   A 	If you are creating a Secondary Server the initial input is the  @ 	same as a Primary Server. Additionally, you will also be asked @ 	for the host (Primary Server) from which to transfer zone data.  @ 	If you create a Primary or Secondary Server for the same domainF 	as this system resides you will be asked if you want to [re]configure< 	your BIND Resolver (client) to use this system as it's name' 	server. This is generally recommended.   = 	If you are creating a Forwarder Entry you will only need to  9 	know the host to which requests outside your zone(s) of   	authority will be forwarded.    Other Options:
 -------------   9 	The Restart Server option will shutdown the BIND service ; 	via SYS$MANAGER:UCX$BIND_SHUTDOWN.COM. It will then enable = 	the BIND service, install the required images and initialize  	the server.  9 	The Test Server option restarts the running server then  ; 	executes a UCX SHOW HOST/NOLOCAL and executes UCX$NSLOOKUP 3 	to display the contents of the domain you specify.   8 	The Remove Configuration option deletes the BIND server: 	configuration information and shuts down the BIND server.                                                                                                                                                                                                                                                                                                                 : * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BIND_SHUTDOWN.COM;1 +  , b   .     / #   4 N                          - P    0   1    2   3      K  P   W   O     5   6 >6Ú  7 Du؛  8          9          G    H  J                     $ !+
$ !           UCX$BIND_SHUTDOWN.COM
$ !			Digital TCP/IP Services for OpenVMS Software,
$ !                                 BIND shutdown
$ !
$ !                    COPYRIGHT (C) 1988, 1993, 1994, 1995 BY
$ !                    DIGITAL EQUIPMENT CORPORATION, MAYNARD
$ !                     MASSACHUSETTS.  ALL RIGHTS RESERVED.
$ !
$ !  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
$ !  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
$ !  OF THE ABOVE COPY                                                                                                                                                   ,                        D $      UCX042.B                       b  P  :[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BIND_SHUTDOWN.COM;1                                                                     N                                           RIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
$ !  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
$ !  PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
$ !
$ !  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
$ !  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
$ !
$ !  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
$ !  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
$ !
$ ! Modifications
$ !
$ ! 08-JUL-1992	Michael Kimmel	Perform license checking + disable NFS service
$ !
$ ! 25-FEB-1993	Randy Boyd	Removed DISABLE of portmapper
$ !
$ !  6-APR-1993 B.J. Herbison	Use F$CONTEXT to locate servers
$ !
$ ! 21-JUN-1993 B.J. Herbison	Convert from NFS to BIND
$ !
$ ! 26-JUL-1994	Michael Kimmel	Don't signal "not found" if not enabled
$ !
$ ! 27-Jul-1995	John Gemignani, Jr.	Change product name.
$ !
$ ! 10-May-1996	Ben Doub	delete installed ucx$bind_server image
$ !
$ ! 2-Dec-1996	Ben Doub	delete installed ucx$bind_server_xfer image
$ !
$ !- 
$ REQUIRED_PRIVILEGES = "OPER,WORLD,SYSPRV,SYSNAM"
$ PREV_PRIVS = F$SETPRV(REQUIRED_PRIVILEGES)
$ IF .NOT. F$PRIVILEGE(REQUIRED_PRIVILEGES) THEN GOTO NO_PRIVILEGES
$ !
$ SET NOON
$ IF F$TYPE (UCX$LICENSE_RUN) .EQS. "" -
	THEN @SYS$MANAGER:UCX$UCP_STARTUP
$ !
$ ! Disable the service
$ !
$ BINDENABLE = 0
$ IF .NOT. UCX$LICENSE_RUN THEN GOTO AFTERDEBUG0
$ DEFINE/USER SYS$ERROR NL:
$ DEFINE/USER SYS$OUTPUT NL:
$ UCX CHECK SERVICE BIND
$ BINDENABLE = $STATUS
$ !
$ DEFINE/USER SYS$ERROR NL:
$ DEFINE/USER SYS$OUTPUT NL:
$ UCX DISABLE SERVICE BIND
$ !
$ ON ERROR THEN GOTO AFTERDEBUG0
$ DEFINE/USER SYS$ERROR NL:
$ DEFINE/USER SYS$OUTPUT NL:
$ UCX SET NAME_SERVICE /DEBUG=0
$ WAIT 0:0:3
$ !
$AFTERDEBUG0:
$ ON CONTROL_Y THEN GOTO EXIT
$ ON ERROR THEN GOTO EXIT
$ !
$ INSTALL := $INSTALL/COMMAND_MODE
$ LIBRARY = "SYS$SYSTEM:UCX$BIND_SERVER.EXE"
$ IF F$FILE("''LIBRARY'","KNOWN") THEN INSTALL DELETE 'LIBRARY'
$ LIBRARY = "SYS$SYSTEM:UCX$BIND_SERVER_XFER.EXE"
$ IF F$FILE("''LIBRARY'","KNOWN") THEN INSTALL DELETE 'LIBRARY'
$ !
$ PROCNAM = P1
$ IF PROCNAM .EQS. "" THEN PROCNAM = "UCX$BIND*"
$ IF F$TYPE(context) .eqs. "PROCESS_CONTEXT" THEN -
	temp = F$CONTEXT ("PROCESS", context, "CANCEL")
$ CONTEXT = ""
$ temp = F$CONTEXT ("PROCESS", context, "PRCNAM", procnam, "EQL")
$ temp = F$CONTEXT ("PROCESS", context, "USERNAME", "UCX$BIND", "EQL")
$ server_found = 0
$LOOP:
$   proc = F$PID(CONTEXT)
$   IF proc .EQS. ""
$   THEN
$	IF server_found .eq. 0 .and. BINDENABLE THEN -
		 WRITE SYS$OUTPUT "''PROCNAM' not found"
$	GOTO EXIT
$   ENDIF
$ server_found = 1
$ ON ERROR THEN GOTO EXIT
$ STOP/ID= 'proc' 
$ WRITE SYS$OUTPUT "BIND server process ''proc' stopped"
$ GOTO LOOP
$EXIT:
$ PREV_PRIVS = F$SETPRV(PREV_PRIVS)
$ EXIT
$NO_PRIVILEGES:
$ WRITE SYS$OUTPUT "Insufficient privileges to STOP the BIND Server"
$ WRITE SYS$OUTPUT "BIND Server Requires ''REQUIRED_PRIVILEGES' privileges."
$ GOTO EXIT
                                                                                                                 9 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BIND_STARTUP.COM;1 +  , J   .     / #   4 I                          - P    0   1    2   3      K  P   W   O     5   6 ؛  7 _u؛  8          9          G    H  J                       $ !  $ ! 6 $ !  Copyright (c) Digital Equipment Corporation, 19936 $ !  All Rights Reserved.  Unpublished rights reserved3 $ !  under the copyright laws of the United States.  $ !   8 $ !  The software contained on this media is proprietary4 $ !  to and embodies the confidential technology of 5 $ !  Digital Equipment Corporation.  Possession, use, 5 $ !  duplication or dissemination of the software and 9 $ !  media is authorized only pursuant to a valid written 0 $ !  license from Digital Equipment Corporation. $ ! 5 $ !  RESTRICTED RIGHTS LEGEND   Use, duplication, or  4 $ !  disclosure by the U.S. Government is subject to9 $ !  restrictions as set forth in Subparagraph (c)(1)(ii) 3 $ !  of DFARS 252.227-7013, or in FAR 52.227-19, as  $ !  applicable. $ !+ $ !  $   ON CONTROL_Y THEN GOTO EXIT  $   SET NOON $!C $   data_directory = F$TRNLNM ("UCX$BIND_SERVER_DATA","LNM$SYSTEM") * $   IF "''data_directory'" .EQS. "" THEN -, 	  data_directory = F$ENVIRONMENT("DEFAULT") $!1 $    DEFINE UCX$BIND_SERVER_DATA 'data_directory'  $!; $    IF F$SEARCH ("''data_directory'*.log") .NES. "" THEN - , 		PURGE /NOLOG /KEEP=4 'data_directory'*.log $!F $   image_directory = F$TRNLNM ("UCX$BIND_SERVER_IMAGES","LNM$SYSTEM")I $   IF "''image_directory'" .EQS. "" THEN image_directory = "SYS$SYSTEM:"  $!H $   UCX$BIND_SERVER_XFER :== $ 'image_directory'UCX$BIND_SERVER_XFER.EXE $!, $   RUN 'image_directory'UCX$BIND_SERVER.EXE $! $ EXIT:  $   EXIT                                                                                     ; * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BOOTP_SHUTDOWN.COM;1 +  , =h	   .     / #   4 N                           - P    0   1    2   3      K  P   W   O     5   6 G{#  7 u؛  8          9          G    H  J                     $ !+G $ !          UCX$BOOTP_SHUTDOWN.COM -- VMS/ULTRIX Connection Software,   $ !					 $ ! 7 $ !                         COPYRIGHT (C) 1988, 1992 BY = $ !                    DIGITAL EQUIPMENT CORPORATION, MAYNARD < $ !                     MASSACHUSETTS.  ALL RIGHTS RESERVED. $ ! J $ !  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDM $ !  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION F $ !  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESI $ !  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER N $ !  PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $ ! M $ !  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND N $ !  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $ ! H $ !  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS; $ !  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $ ! " $ ! Command procedure to shutdown: $ !     1. UCX$BOOTP $ !  $ !--  $ !  $ ! 9 $ REQUIRED_PRIVILEGES = "CMKRNL,OPER,WORLD,SYSPRV,SYSNAM" , $ PREV_PRIVS = F$SETPRV(REQUIRED_PRIVILEGES)C $ IF .NOT. F$PRIVILEGE(REQUIRED_PRIVILEGES) THEN GOTO NO_PRIVILEGES  $ ! 
 $ SET NOON( $ IF F$TYPE (UCX$LICENSE_RUN) .EQS. "" -( 	.OR. F$TYPE (UCX$LICENSE_APP) .EQS. ""  $ THEN $	@SYS$MANAGER:UCX$UCP_STARTUP $ ENDIF / $ IF .NOT. UCX$LICENSE_RUN THEN GOTO FIND_BOOTP  $ DEFINE/USER SYS$OUTPUT NL: $ DEFINE/USER SYS$ERROR NL:  $ UCX DISABLE SERVICE BOOTP  $ ! 
 $ FIND_BOOTP:  $ ON CONTROL_Y THEN GOTO EXIT  $ ON ERROR THEN GOTO EXIT  $ !  $ !TEST CODE $ !  $ ON ERROR THEN GOTO EXIT  $ PROCNAM := UCX$BOOTP $ CONTEXT = "" $ LOOP:  $   P1 = F$PID(CONTEXT) & $   IF P1 .EQS. "" THEN GOTO DEINSTALLH $   IF F$EXTRACT(0,9,F$GETJPI(P1,"PRCNAM")) .NES. PROCNAM THEN GOTO LOOP $ !  $ !  $ STOP PROCESS/ID= 'P1'  $ GOTO LOOP  $ !  $ DEINSTALL: $ !   $ ON WARNING THEN GOTO NO_SHARED" $ INSTALL := $INSTALL/COMMAND_MODE $ ! & $ LIBRARY = "SYS$SYSTEM:UCX$BOOTP.EXE"? $ IF F$FILE("''LIBRARY'","KNOWN") THEN INSTALL DELETE 'LIBRARY'  $ !  $ ON ERROR THEN GOTO EXIT  $ CONT_SHUT:. $ IF (F$TRNLNM("UCX$BOOTP_EXTLOG") .NES. "") -* 	THEN DEASSIGN/SYSTEM/EXE UCX$BOOTP_EXTLOG $ ! / $ ! WRITE SYS$OUTPUT "UCX$BOOTP server stopped"  $ !  $ EXIT: % $   PREV_PRIVS = F$SETPRV(PREV_PRIVS)  $ !  $ EXIT $ NO_PRIVILEGES:I $ WRITE SYS$OUTPUT "Insufficient privileges to STOP the UCX$BOOTP server" D $ WRITE SYS$OUTPUT "Required priviliges are '' REQUIRED_PRIVILEGES'" $ GOTO EXIT  $ NO_SHARED:5 $ WRITE SYS$OUTPUT "Failed to delete installed image" 5 $ WRITE SYS$OUTPUT "BOOTP server requires ''LIBRARY'"  $ GOTO CONT_SHUT                                                                                                                                                                                                                                                                                                                                                                                       : * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BOOTP_STARTUP.COM;1 +  , Ah	   .     / #   4 <       `                  - P    0   1    2   3      K  P   W   O     5   6 RTsu  7 yu؛  8          9          G    H  J        `                                                                                                                                                                                                                                                                                                                                                                                  -                        ;^ $      UCX042.B                       Ah	  P  :[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$BOOTP_STARTUP.COM;1                                                                     <                             ]C              $ !  $ ! < $ !  Copyright (c) Digital Equipment Corporation, 1990, 19926 $ !  All Rights Reserved.  Unpublished rights reserved3 $ !  under the copyright laws of the United States.  $ !   8 $ !  The software contained on this media is proprietary4 $ !  to and embodies the confidential technology of 5 $ !  Digital Equipment Corporation.  Possession, use, 5 $ !  duplication or dissemination of the software and 9 $ !  media is authorized only pursuant to a valid written 0 $ !  license from Digital Equipment Corporation. $ ! 5 $ !  RESTRICTED RIGHTS LEGEND   Use, duplication, or  4 $ !  disclosure by the U.S. Government is subject to9 $ !  restrictions as set forth in Subparagraph (c)(1)(ii) 3 $ !  of DFARS 252.227-7013, or in FAR 52.227-19, as  $ !  applicable. $ !+ $ ! * $ SET	 PROCESS /PRIV=(NOALL,NETMBX,TMPMBX) $ RUN	 SYS$SYSTEM:UCX$BOOTP.EXE                                                                                                                                                                              6 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CALLBACKS.COM;1 +  , a	   . 0    / #   4 s   0   . z                   - P    0   1    2   3      K  P   W   O 1    5   6 !lf؛  7 ! u؛  8          9          G    H  J                         K $!  Copyright (c) 1997 Digital Equipment Corporation.  All rights reserved. 8 $if .not. ucx$gl_debug then ucx$l_verify = f$verify( 0 ) $on warning then goto error E $call ucx$'p1 "''p2'" "''p3'" "''p4'" "''p5'" "''p6'" "''p7'" "''p8'" P $if f$type( ucx$l_verify ) .nes. "" then ucx$l_verify = f$verify( ucx$l_verify ) $exit  $error: # $ucx$gl_status == UCX$GL_SS_FAILURE  $exit  $ucx$return_control: subroutine  $set on  $set control=y $exit  $endsubroutine $ucx$ask_any: subroutine$ $ucx$t_prompt = f$edit( p1, "TRIM" ) $ucx$l_cr_flag = p2  $ucx$t_result = p3O $ucx$t_prompt_2 = ucx$gt_prompt_prefix + ucx$t_prompt + ucx$gt_prompt_postfix_2  $'ucx$t_result == """ $ucx$gl_status == UCX$GL_SS_NORMAL $loop: $read sys$command ucx$t_input -  /end_of_file=end_of_file - /error=error -	 /notime -  /prompt="''ucx$t_prompt_2'" - $ucx$t_input == f$edit( ucx$t_input, "TRIM" )   $if ucx$l_cr_flag then goto exit' $if ucx$t_input .eqs. "" then goto loop 
 $goto exit
 $end_of_file:  $ucx$gl_status == UCX$GL_SS_EOF  $exit  $error:  $ucx$gl_status == $status 9 $if ucx$gl_status then ucx$gl_status == UCX$GL_SS_FAILURE / $if ucx$gl_debug then show symbol ucx$gl_status  $exit  $exit: $'ucx$t_result == ucx$t_input  $exit  $endsubroutine $ucx$ask_binary: subroutine $ $ucx$t_prompt = f$edit( p1, "TRIM" ) $ucx$t_default = p2  $ucx$t_result = p3$ $ucx$gl_status == UCX$GL_SS_BADPARAM8 $ucx$t_default = f$edit( ucx$t_default, "TRIM, UPCASE" ) $if ucx$t_default .eqs. "N"  $then  $ucx$t_default = " [NO]" $'ucx$t_result == UCX$GL_FALSE" $ucx$gl_status == UCX$GL_SS_NORMAL $endif $if ucx$t_default .eqs. "Y"  $then  $ucx$t_default = " [YES]"  $'ucx$t_result == UCX$GL_TRUE " $ucx$gl_status == UCX$GL_SS_NORMAL $endif& $if .not. ucx$gl_status then goto exit] $ucx$t_prompt_2 = ucx$gt_prompt_prefix + ucx$t_prompt + ucx$t_default + ucx$gt_prompt_postfix  $loop:# $ucx$gl_status == UCX$GL_SS_FAILURE  $read sys$command ucx$t_input -  /end_of_file=end_of_file -
 /error=exit - 	 /notime -  /prompt="''ucx$t_prompt_2'" , $ucx$t_input = f$edit( ucx$t_input, "TRIM" )" $ucx$gl_status == UCX$GL_SS_NORMAL' $if ucx$t_input .eqs. "" then goto exit 4 $ucx$t_input = "*" + f$edit( ucx$t_input, "UPCASE" ) $ucx$t_answer_list = "*YES,*NO" < $ucx$l_position = f$locate( ucx$t_input, ucx$t_answer_list )5 $if ucx$l_position .eq. f$length( ucx$t_answer_list )  $then 4 $@'ucx$gt_callback message "''ucx$gt_msg_yes_or_no'"! $if .not. ucx$gl_status then exit 
 $goto loop $endif $if ucx$l_position .eq. 0  $then  $'ucx$t_result == 1  $else  $'ucx$t_result == 0  $endif" $ucx$gl_status == UCX$GL_SS_NORMAL
 $goto exit
 $end_of_file:  $ucx$gl_status == UCX$GL_SS_EOF  $exit: $exit  $endsubroutine $ucx$ask_choice: subroutine $ $ucx$t_prompt = f$edit( p1, "TRIM" )% $ucx$t_default = f$edit( p2, "TRIM" ) - $ucx$t_choices = f$edit( p3, "TRIM, UPCASE" )  $ucx$l_choice_length = p4 ' $ucx$t_delimiter = f$edit( p5, "TRIM" ) $ $ucx$t_result = f$edit( p6, "TRIM" )$ $ucx$gl_status == UCX$GL_SS_BADPARAM. $if f$length( ucx$t_choices ) .eq. 0 then exit( $if ucx$l_choice_length .eq. 0 then exit0 $if f$length( ucx$t_delimiter ) .ne. 1 then exit5 $ucx$t_prompt_2 = ucx$gt_prompt_prefix + ucx$t_prompt  $if ucx$t_default .nes. "" $then B $ucx$t_prompt_2 = ucx$t_prompt_2 + " [" + "''ucx$t_default'" + "]" $endif: $ucx$t_prompt_2 = ucx$t_prompt_2 + ucx$gt_prompt_postfix_2) $ucx$l_length = f$length( ucx$t_choices ) . $if ucx$gl_debug then show symbol ucx$l_length $loop: $read sys$command ucx$t_input -  /end_of_file=end_of_file -
 /error=exit - 	 /notime -  /prompt="''ucx$t_prompt_2'" 4 $ucx$t_input = f$edit( ucx$t_input, "TRIM, UPCASE" )= $if ( ucx$t_default .nes. "" ) .and. ( ucx$t_input .eqs. "" )  $then . $ucx$t_input = ucx$t_delimiter + ucx$t_default $endif3 $ucx$l_pos = f$locate( ucx$t_input, ucx$t_choices ) + $if ucx$gl_debug then show symbol ucx$l_pos . $if ucx$l_pos .eq. ucx$l_length then goto loop1 $'ucx$t_result == ucx$l_pos / ucx$l_choice_length " $ucx$gl_status == UCX$GL_SS_NORMAL $exit  $error: # $ucx$gl_status == UCX$GL_SS_FAILURE  $exit 
 $end_of_file:i $ucx$gl_status == UCX$GL_SS_EOFr $exitn $endsubroutine $ucx$ask_number: subroutineb$ $ucx$t_prompt = f$edit( p1, "TRIM" ) $ucx$l_radix = f$integer( p2 )  $ucx$l_minimum = f$integer( p3 )  $ucx$l_maximum = f$integer( p4 )  $ucx$l_default = f$integer( p5 ) $ucx$t_number = p6$ $ucx$gl_status == UCX$GL_SS_BADPARAM= $if ucx$l_radix .eq. 8 then ucx$gl_status == UCX$GL_SS_NORMALt> $if ucx$l_radix .eq. 10 then ucx$gl_status == UCX$GL_SS_NORMAL> $if ucx$l_radix .eq. 16 then ucx$gl_status == UCX$GL_SS_NORMAL& $if .not. ucx$gl_status then goto exit$ $ucx$gl_status == UCX$GL_SS_BADPARAM3 $if ucx$l_minimum .gt. ucx$l_maximum then goto exit_3 $if ucx$l_default .lt. ucx$l_minimum then goto exit_3 $if ucx$l_default .gt. ucx$l_maximum then goto exitd( $if ucx$t_prompt .eqs. "" then goto exit( $if ucx$t_number .eqs. "" then goto exit1 $if ucx$l_radix .eq. 8 then ucx$t_control = "!OL"c2 $if ucx$l_radix .eq. 10 then ucx$t_control = "!ZL"2 $if ucx$l_radix .eq. 16 then ucx$t_control = "!XL"6 $ucx$t_minimum = f$fao( ucx$t_control, ucx$l_minimum )6 $ucx$t_maximum = f$fao( ucx$t_control, ucx$l_maximum )6 $ucx$t_default = f$fao( ucx$t_control, ucx$l_default ): $call ucx$strip_leading_zeros 'ucx$t_minimum ucx$gt_result $ucx$t_minimum = ucx$gt_result: $call ucx$strip_leading_zeros 'ucx$t_maximum ucx$gt_result $ucx$t_maximum = ucx$gt_result: $call ucx$strip_leading_zeros 'ucx$t_default ucx$gt_result $ucx$t_default = ucx$gt_result5 $ucx$t_prompt_1 = ucx$gt_prompt_prefix + ucx$t_prompt C $ucx$t_prompt_2 = " (" + ucx$t_minimum + "-" + ucx$t_maximum + ") "tB $ucx$t_prompt_3 = "["+ ucx$t_default + "]" + ucx$gt_prompt_postfix@ $ucx$t_prompt = ucx$t_prompt_1 + ucx$t_prompt_2 + ucx$t_prompt_3" $ucx$gl_status == UCX$GL_SS_NORMAL $loop: $if .not. ucx$gl_statusg $thent( $call ucx$message "''ucx$gt_msg_invval'" $endif  $read sys$command ucx$t_answer - /end_of_file=end_of_file -
 /error=exit -$	 /notime -R /prompt="''ucx$t_prompt'"_. $ucx$t_answer = f$edit( ucx$t_answer, "TRIM" )" $ucx$gl_status == UCX$GL_SS_NORMAL, $'ucx$t_number == f$integer( ucx$l_default )( $if ucx$t_answer .eqs. "" then goto exitC $call ucx$check_number 'ucx$l_radix "''ucx$t_answer'" ucx$gl_numberf& $if .not. ucx$gl_status then goto loop# $ucx$gl_status == UCX$GL_SS_FAILUREt3 $if ucx$gl_number .lt. ucx$l_minimum then goto loop 3 $if ucx$gl_number .gt. ucx$l_maximum then goto loopt $'ucx$t_number == ucx$gl_number"" $ucx$gl_status == UCX$GL_SS_NORMAL
 $goto exit
 $end_of_file:g $ucx$gl_status == UCX$GL_SS_EOFi $exit: $exite $endsubroutine $ucx$ask_return: subroutineu $ucx$t_prompt = p1 $if ucx$t_prompt .eqs. ""O $theng4 $ucx$t_prompt = "Enter carriage return to continue " $endif3 $ucx$t_prompt = ucx$gt_prompt_prefix + ucx$t_promptt  $read sys$command ucx$t_answer - /end_of_file=end_of_file -
 /error=exit -M	 /notime -t /prompt="''ucx$t_prompt'"M" $ucx$gl_status == UCX$GL_SS_NORMAL $exitu
 $end_of_file:= $ucx$gl_status == UCX$GL_SS_EOFs $exit$ $exit: $exit" $endsubroutine  $ucx$check_component: subroutine/ $ucx$t_component = f$edit( p1, "TRIM,                                                                                                                                                                                                                                                                                                                                                                                                                                                                   .                        /D $      UCX042.B                       a	  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CALLBACKS.COM;1                                                                         s    0                           "            UPCASE" )_0 $ucx$t_components = f$edit( p2, "TRIM, UPCASE" )$ $ucx$t_symbol = f$edit( p3, "TRIM" )" $ucx$gl_status == UCX$GL_SS_NORMAL, $ucx$l_length = f$length( ucx$t_components )" $'ucx$t_symbol == UCX$GL_SS_NORMAL! $if ucx$l_length .eq. 0 then exit : $ucx$l_pos = f$locate( ucx$t_component, ucx$t_components )# $'ucx$t_symbol == UCX$GL_SS_FAILURE$* $if ucx$l_pos .eqs. ucx$l_length then exit" $'ucx$t_symbol == UCX$GL_SS_NORMAL $exit  $endsubroutine" $ucx$check_inet_active: subroutine $ucx$l_wait_count = p1' $ucx$t_wait_time = f$edit( p2, "TRIM" )f$ $ucx$gl_status == UCX$GL_SS_BADPARAM* $if ucx$l_wait_count .lt. 1 then goto exit; $if ucx$t_wait_time .eqs. "" then ucx$t_wait_time = "0:0:1"u# $ucx$gl_status == UCX$GL_SS_FAILURElA $if .not. f$getdvi( ucx$gt_inet_device_name, "EXISTS" ) then exitm $ucx$l_counter = 0 $loop:" $ucx$gl_status == UCX$GL_SS_NORMAL8 $if f$getdvi( ucx$gt_inet_device_name, "MNT" ) then exit $wait 'ucx$t_wait_time" $ucx$l_counter = ucx$l_counter + 16 $if ucx$l_counter .lt. ucx$l_wait_count then goto loop# $ucx$gl_status == UCX$GL_SS_FAILUREe $exitu $endsubroutine $ucx$check_number: subroutinep $ucx$l_radix = p1I $ucx$t_in_number = p2i $ucx$t_out_number = p3$ $ucx$gl_status == UCX$GL_SS_BADPARAM $ucx$t_digits = "" $if ucx$l_radix .eqs. 8r $then  $ucx$t_digits = "01234567" $ucx$t_radix = "%O"A $endif $if ucx$l_radix .eqs. 10 $thenl $ucx$t_digits = "0123456789" $ucx$t_radix = "%D"1 $endif $if ucx$l_radix .eqs. 16 $then " $ucx$t_digits = "0123456789ABCDEF" $ucx$t_radix = "%X"O $endif( $if ucx$t_digits .eqs. "" then goto exit# $ucx$gl_status == UCX$GL_SS_FAILURE * $ucx$l_count = f$length( ucx$t_in_number )% $if ucx$l_count .eq. 0 then goto exitm $ucx$l_index = 0 $loop:; $ucx$t_digit = f$extract( ucx$l_index, 1, ucx$t_in_number )m2 $ucx$l_pos = f$locate( ucx$t_digit, ucx$t_digits ): $if ucx$l_pos .eq. f$length( ucx$t_digits ) then goto exit $ucx$l_index = ucx$l_index + 1/ $if ucx$l_index .le. ucx$l_count then goto loop.0 $ucx$t_in_number = ucx$t_radix + ucx$t_in_number2 $'ucx$t_out_number == f$integer( ucx$t_in_number )" $ucx$gl_status == UCX$GL_SS_NORMAL $exit: $exitf $endsubroutine  $ucx$check_file_prot: subroutine $ucx$t_file_spec = p1o $ucx$t_prot_1 = p2 $if ucx$gl_debug $thenm $show symbol ucx$t_file_spec $show symbol ucx$t_prot_1x $endifF $@'ucx$gt_callback message "''ucx$gt_msg_check_prot'" 'ucx$t_file_spec+ $ucx$t_status = f$search( ucx$t_file_spec )t $if ucx$t_status .eqs. ""o $then ? $@'ucx$gt_callback message "''ucx$gt_msg_fnf'" 'ucx$t_file_specx $ucx$gl_status == UCX$GL_SS_FNF+ $exit  $endifG $@'ucx$gt_callback convert_prot_to_mask "''ucx$t_prot_1'" ucx$gl_mask_1 ! $if .not. ucx$gl_status then exit ; $ucx$t_prot_2 = f$file_attributes( ucx$t_file_spec, "PRO" )iG $@'ucx$gt_callback convert_prot_to_mask "''ucx$t_prot_2'" ucx$gl_mask_2 ! $if .not. ucx$gl_status then exitwI $@'ucx$gt_callback check_prot 'ucx$gl_mask_1 'ucx$gl_mask_2 ucx$gl_mask_3x $if ucx$gl_mask_3 .gt. 0 $thend0 $ucx$t_prot_1 = f$edit( ucx$t_prot_1, "UPCASE" )G $@'ucx$gt_callback message "''ucx$gt_msg_nosuchprot'" "''ucx$t_prot_1'"w# $ucx$gl_status == UCX$GL_SS_FAILURE$ $exitu $endif" $ucx$gl_status == UCX$GL_SS_NORMAL $exit  $endsubroutine $ucx$check_prot: subroutineg $ucx$l_mask_1 = p1 $ucx$l_mask_2 = p2$ $ucx$t_symbol = f$edit( p3, "TRIM" ) $if ucx$gl_debug $then  $show symbol ucx$l_mask_1o $show symbol ucx$l_mask_2c $endif- $ucx$l_mask = ucx$l_mask_1 .and. ucx$l_mask_2 , $if ucx$gl_debug then show symbol ucx$l_mask" $ucx$l_mask = ( .not. ucx$l_mask ), $if ucx$gl_debug then show symbol ucx$l_mask+ $ucx$l_mask = ucx$l_mask .and. ucx$l_mask_1 , $if ucx$gl_debug then show symbol ucx$l_mask $'ucx$t_symbol == ucx$l_mask" $ucx$gl_status == UCX$GL_SS_NORMAL $exita $endsubroutine $ucx$construct_uic: subroutine" $ucx$l_uic_group = f$integer( p1 )# $ucx$l_uic_member = f$integer( p2 )_ $ucx$t_global_symbol = p3 G $'ucx$t_global_symbol == ( ucx$l_uic_group * 65536 ) + ucx$l_uic_member " $ucx$gl_status == UCX$GL_SS_NORMAL $exit: $exitu $endsubroutine% $ucx$convert_prot_to_mask: subroutine 2 $ucx$t_protection = f$edit( p1, "COLLAPSE, TRIM" )" $ucx$t_mask = f$edit( p2, "TRIM" )s $ucx$t_list = "xxxx*,xxx*D,xxx*E,xx*ED,xxx*W,xx*WD,xx*WE,x*WED,xxx*R,xxx*RD,xxx*RE,xx*RED,xx*RW,xx*RWD,x*RWE,*RWED" & $ucx$l_length = f$length( ucx$t_list ). $if ucx$gl_debug then show symbol ucx$l_length $ucx$l_index = 0 $ucx$l_mask = 0_ $loop: $ucx$l_mask = ucx$l_mask * 16g, $if ucx$gl_debug then show symbol ucx$l_mask> $ucx$t_token = f$element( ucx$l_index, ",", ucx$t_protection )/ $ucx$t_token = f$element( 1, "=", ucx$t_token )(/ $if ucx$t_token .eqs. "=" then ucx$t_token = ""R  $ucx$t_token = "*" + ucx$t_token. $ucx$t_token = f$edit( ucx$t_token, "UPCASE" )- $if ucx$gl_debug then show symbol ucx$t_tokenC5 $ucx$l_position = f$locate( ucx$t_token, ucx$t_list )e0 $if ucx$gl_debug then show symbol ucx$l_position# $ucx$gl_status == UCX$GL_SS_FAILUREO. $if ucx$l_position .eq. ucx$l_length then exit0 $if ucx$gl_debug then show symbol ucx$l_position$ $ucx$l_position = ucx$l_position / 6) $ucx$l_mask = ucx$l_mask + ucx$l_position  $ucx$l_index = ucx$l_index + 1% $if ucx$l_index .lt. 4 then goto loopk $'ucx$t_mask == ucx$l_mask" $ucx$gl_status == UCX$GL_SS_NORMAL $exitt $endsubroutine  $ucx$delete_logicals: subroutine2 $ucx$t_logical_name = f$edit( p1, "TRIM, UPCASE" ) $ucx$l_inform = p2' $ucx$t_lnm_table = f$edit( p3, "TRIM" )d) $ucx$t_access_mode = f$edit( p4, "TRIM" )t $ucx$t_excludes = "*" + p5$ $ucx$gl_status == UCX$GL_SS_BADPARAMH $if ucx$l_inform .eq. UCX$GL_TRUE then ucx$gl_status == UCX$GL_SS_NORMALI $if ucx$l_inform .eq. UCX$GL_FALSE then ucx$gl_status == UCX$GL_SS_NORMALC# $if .not. ucx$gl_status then $ exitn3 $ucx$l_excludes_length = f$length( ucx$t_excludes )o+ $ucx$t_message = f$environment( "MESSAGE" )g> $set message /nofacility /noidentification /noseverity /notext; $show logical 'ucx$t_logical_name /output='ucx$gt_file_templ $ucx$gl_status == $statusg $set message 'ucx$t_messagel3 $if ucx$gl_status .eq. UCX$GL_SS_NOTRAN then $ exito $close/nolog ucx$l_infileu# $ucx$gl_status == UCX$GL_SS_FAILURE_4 $ucx$t_full_file_spec = f$search( ucx$gt_file_temp )0 $if ucx$t_full_file_spec .eqs. "" then goto exit4 $open/read/error=exit ucx$l_infile 'ucx$gt_file_temp $loop:7 $read/end_of_file=end_of_file ucx$l_infile ucx$t_recordy. $if ucx$gl_debug then show symbol ucx$t_record8 $ucx$t_record = f$edit( ucx$t_record, "COLLAPSE, TRIM" )( $if ucx$t_record .eqs. "" then goto loop. $ucx$t_token = f$extract( 0, 1, ucx$t_record )( $if ucx$t_token .eqs. "(" then goto loop( $if ucx$t_token .eqs. "=" then goto loop1 $ucx$t_record = f$element( 0, "=", ucx$t_record )uH $ucx$t_record = ucx$t_record - ucx$gt_double_quote - ucx$gt_double_quote4 $if ucx$t_record .eqs. "UCX$L_INFILE" then goto loop. $if ucx$gl_debug then show symbol ucx$t_record: $ucx$l_position = f$locate( ucx$t_record, ucx$t_excludes )< $if ucx$l_position .ne. ucx$l_excludes_length then goto loopA $ucx$t_access_mode_2 = f$trnlnm( ucx$t_record,,,,,"ACCESS_MODE" )m $if ucx$t_access_mode .nes. "*"_ $thend> $if ucx$t_access_mode .nes. ucx$t_access_mode_2 then goto loop $endif $if ucx$l_inform $then_C $@'ucx$gt_callback message "''ucx$gt_msg_delete_lnm'" 'ucx$t_recordt $endifE $ucx$t_qualifiers = "/" + ucx$t_lnm_table + "/" + ucx$t_access_mode_2 ( $deassign'ucx$t_qualifiers 'ucx$t_record
 $goto loop
 $end_of_file:T $close/nolog ucx$l_infilet" $ucx$gl_status == UCX$GL_SS_NORMAL $exit:I $If ucx$t_full_file_spec .nes. "" then delete/nolog 'ucx$t_full_file_speci $exitl $endsubroutine $ucx$decompose_uic: subroutine $ucx$l_uic = p1a $ucx$t_uic_group = p2t $ucx$t_uic_member = p3& $'ucx$t_uic_group == ucx$l_uic / 65536, $'ucx$t_uic_member == ucx$l_uic .and. %xFFFF $exitk $endsubroutine $ucx$find_account: subroutine= $ucx$t_username = p13 $ucx$t_on_severity = f$environment( "ON_SEVERITY" ) 	 $set noong $define/user sys$output nl:l $define/user sys$error nl:  $ucx$gt_uaf show 'ucx$t_username $ucx$gl_status == $statusx0 $if ucx$t_on_severity .nes. "NONE" then $ set on $exits $endsubroutine $ucx$find_devices: subroutineu) $ucx$t_device_name = f$edit( p1, "TRIM" )  $ucx$t_preamble = p2 $ucx$t_epilogue = p3 $ucx$t_device_count = p4$ $ucx$gl_status == UCX$GL_SS_BADPARAM% $if ucx$t_preamble .eqs. "" then exitx% $if ucx$t_epilogue .eqs. "" then exitx) $if ucx$t_device_count .eqs. "" then exith $'ucx$t_device_count == 0d% $ucx$gl_status == UCX$GL_SS_NOSUCHDEVx7 $ucx$l_status = f$getdvi( ucx$t_device_name, "EXISTS" )$  $if .not. ucx$l_status then exit9 $show device 'ucx$t_device_name /output='ucx$gt_file_tempn $close/nolog ucx$l_infile)) $open/read ucx$l_i                                                                                                                                                                                                                                                   /                        Z $      UCX042.B                       a	  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CALLBACKS.COM;1                                                                         s    0                         8              nfile 'ucx$gt_file_tempo $ucx$l_device_count == 0& $ucx$l_preamble_printed = ucx$gl_false $loop:7 $read/end_of_file=end_of_file ucx$l_infile ucx$t_recordC. $if ucx$gl_debug then show symbol ucx$t_record7 $ucx$t_record = f$edit( ucx$t_record, "COMPRESS,TRIM" )s( $if ucx$t_record .eqs. "" then goto loop/ $ucx$l_position = f$locate( ":", ucx$t_record )O? $if ucx$l_position .eq. f$length( ucx$t_record ) then goto loopg8 $ucx$t_device_name_2 = f$element( 0, ":", ucx$t_record )5 $if ucx$gl_debug then show symbol ucx$t_device_name_2 / $if ucx$t_device_name_2 .eqs. "" then goto loop , $ucx$l_device_count = ucx$l_device_count + 1, $if ucx$l_device_count .eq. 1 then goto loop  $if .not. ucx$l_preamble_printed $then * $@'ucx$gt_callback lecture 'ucx$t_preamble% $ucx$l_preamble_printed = ucx$gl_true  $endif0 $ucx$t_device_name_2 = ucx$t_device_name_2 + ":"L $@'ucx$gt_callback message "''ucx$gt_msg_device_found'" 'ucx$t_device_name_2
 $goto loop $error:c $close/nolog ucx$l_infile # $ucx$gl_status == UCX$GL_SS_FAILUREL $goto exit_2
 $end_of_file:L $close/nolog ucx$l_infile= $if ucx$l_device_count .gt. 1c $thena* $@'ucx$gt_callback lecture 'ucx$t_epilogue $endif* $'ucx$t_device_count == ucx$l_device_count" $ucx$gl_status == UCX$GL_SS_NORMAL $exit_2:, $ucx$t_status = f$search( ucx$gt_file_temp )? $if ucx$t_status .nes. "" then delete/nolog 'ucx$gt_file_temp;*t $exit  $endsubroutine $ucx$find_process: subroutine$, $ucx$t_prcnam = f$edit( p1, "TRIM, UPCASE" ) $ucx$l_prefix_flag = p2u $ucx$l_stop_process = p3 $ucx$t_pid_symbol = p4 $ucx$t_context = ""h $loop:# $ucx$t_pid = f$pid( ucx$t_context )c+ $if ucx$gl_debug then show symbol ucx$t_pidi# $ucx$gl_status == UCX$GL_SS_FAILUREo" $if ucx$t_pid .eqs. "" then $ exit1 $ucx$t_prcnam_2 = f$getjpi( ucx$t_pid, "PRCNAM" )w0 $if ucx$gl_debug then show symbol ucx$t_prcnam_2 $if ucx$l_prefix_flagI $theni( $ucx$l_length = f$length( ucx$t_prcnam )> $ucx$t_prcnam_3 = f$extract( 0, ucx$l_length, ucx$t_prcnam_2 ) $endif4 $if ucx$t_prcnam .nes. ucx$t_prcnam_3 then goto loop $'ucx$t_pid_symbol == ucx$t_pid " $ucx$gl_status == UCX$GL_SS_NORMAL& $if .not. ucx$l_stop_process then exit' $stop process/identification='ucx$t_pid.@ $@'ucx$gt_callback "''ucx$gt_msg_srv_shutdown'" 'ucx$gt_prcnam_2 $exite $endsubroutine* $ucx$find_account_by_uic_group: subroutine" $ucx$l_uic_group = f$integer( p1 )2 $ucx$t_uic_group = f$fao( "!OL", ucx$l_uic_group )* $ucx$t_uic = "[" + ucx$t_uic_group + ",*]"3 $ucx$t_on_severity = f$environment( "ON_SEVERITY" )$	 $set noond $define/user sys$output nl:h $define/user sys$error nl:! $ucx$gt_uaf show/brief 'ucx$t_uica $ucx$gl_status == $statusl0 $if ucx$t_on_severity .nes. "NONE" then $ set on $exit  $endsubroutine $ucx$find_file: subroutine $ucx$t_logical_name = p1 $ucx$t_file_spec = p2tF $ucx$t_file_spec_2 = f$parse( ucx$t_logical_name, ucx$t_file_spec,,, )6 $define/process 'ucx$t_logical_name 'ucx$t_file_spec_2. $ucx$t_status = f$search( ucx$t_logical_name )" $ucx$gl_status == UCX$GL_SS_NORMALA $if ucx$t_status .eqs. "" then ucx$gl_status == UCX$GL_SS_FAILUREc $exit  $endsubroutine $ucx$installed_get: subroutine4 $ucx$t_status = f$search( ucx$gt_file_installation ) $if ucx$t_status .eqs. ""o $thenbH $@'ucx$gt_callback message "''ucx$gt_msg_fnf'" 'ucx$gt_file_installation $ucx$gl_status == UCX$GL_SS_FNFs $endif $@'ucx$gt_file_installatione" $ucx$gl_status == UCX$GL_SS_NORMAL $exit  $endsubroutine $ucx$installed_put: subroutine $close/nolog ucx$gl_out_fileF $open/error=error_open/write ucx$gl_out_file 'ucx$gt_file_installation. $write/error=error_write ucx$gl_out_file "$ !"P $write/error=error_write ucx$gl_out_file "$ ! File: " + ucx$gt_file_installation@ $write/error=error_write ucx$gl_out_file "$ ! Date: " + f$time()Q $write/error=error_write ucx$gl_out_file "$ ! User: " + f$getjpi( 0, "USERNAME" )t. $write/error=error_write ucx$gl_out_file "$ !"C $ucx$t_record = "$ UCX$GL_INS_RUN == " + f$string( ucx$gl_ins_run )c5 $write/error=error_write ucx$gl_out_file ucx$t_recordoC $ucx$t_record = "$ UCX$GL_INS_NFS == " + f$string( ucx$gl_ins_nfs )l5 $write/error=error_write ucx$gl_out_file ucx$t_recorduC $ucx$t_record = "$ UCX$GL_INS_APP == " + f$string( ucx$gl_ins_app )f5 $write/error=error_write ucx$gl_out_file ucx$t_record C $ucx$t_record = "$ UCX$GL_CFG_RUN == " + f$string( ucx$gl_cfg_run )R5 $write/error=error_write ucx$gl_out_file ucx$t_record C $ucx$t_record = "$ UCX$GL_CFG_NFS == " + f$string( ucx$gl_cfg_nfs ).5 $write/error=error_write ucx$gl_out_file ucx$t_recordvC $ucx$t_record = "$ UCX$GL_CFG_APP == " + f$string( ucx$gl_cfg_app ) 5 $write/error=error_write ucx$gl_out_file ucx$t_record_ $close/nolog ucx$gl_out_file" $ucx$gl_status == UCX$GL_SS_NORMAL $exit  $error_open:H $@'ucx$gt_callback message "''ucx$gt_openout'" 'ucx$gt_file_installation# $ucx$gl_status == UCX$GL_SS_FAILUREa $exitu
 $error_write:rI $@'ucx$gt_callback message "''ucx$gt_writeerr'" 'ucx4gt_file_installation"# $ucx$gl_status == UCX$GL_SS_FAILURE$ $exitd $endsubroutine $ucx$lecture: subroutine	 $set noonr3 $ucx$t_lecture_name = "UCX$" + f$edit( p1, "TRIM" )$H $library/text ucx$lectures/extract='ucx$t_lecture_name/output=sys$output $ucx$gl_status == $status  $exite $endsubroutine $ucx$message: subroutine $ucx$t_message = p1_ $if ucx$t_message .eqs. "" $then / $ucx$t_message = "F/NOMSG/no message specified"x $endif4 $ucx$t_severity = f$element( 0, "/", ucx$t_message )A $ucx$t_severity_2 = "*" + f$edit( ucx$t_severity, "TRIM,UPCASE" )e# $ucx$t_severity_list = "*S*I*W*E*F"xC $ucx$l_position = f$locate( ucx$t_severity_2, ucx$t_severity_list )u$ $ucx$gl_status == UCX$GL_SS_BADPARAMF $if ucx$l_position .eq. f$length( ucx$t_severity_list ) then goto exit. $ucx$t_id = f$element( 1, "/", ucx$t_message )- $ucx$t_id = f$edit( ucx$t_id, "TRIM,UPCASE" )c0 $ucx$t_text = f$element( 2, "/", ucx$t_message )* $ucx$t_text = f$edit( ucx$t_text, "TRIM" )9 $ucx$t_text = f$fao( ucx$t_text, p2, p3, p4, p5, p6, p7 )Ig $ucx$t_message = "%" + ucx$gt_facility_name + "-" + ucx$t_severity + "-" + ucx$t_id + ", " + ucx$t_textr $ucx$gt_say ucx$t_message_" $ucx$gl_status == UCX$GL_SS_NORMAL $exit: $exit_ $endsubroutine $ucx$set_privileges: subroutineL $ucx$t_privileges_new = p1 $ucx$t_privileges_old = p2" $ucx$gl_status == UCX$GL_SS_NORMAL+ $if ucx$t_privileges_new .eqs. "" then exitwU $if ucx$t_privileges_old .eqs. "" then ucx$t_privileges_old = "ucx$gt_privileges_old"e? $'ucx$t_privileges_old == f$setprv( "''ucx$t_privileges_new'" )!" $ucx$gl_status == UCX$GL_SS_NORMAL9 $if f$privileges( "''ucx$t_privileges_new'" ) then $ exitr1 $@'ucx$gt_callback message "''ucx$gt_msg_setprv'"sI $@'ucx$gt_callback message "''ucx$gt_msg_prvs'" "''ucx$t_privileges_new'"i# $ucx$gl_status == UCX$GL_SS_FAILUREc $exits $endsubroutine$ $ucx$strip_leading_zeros: subroutine $ucx$t_in_string = p1u $ucx$t_global_symbol = p2m $ucx$l_position = 0p $loop:> $ucx$t_digit = f$extract( ucx$l_position, 1, ucx$t_in_string )$ $ucx$l_position = ucx$l_position + 1( $if ucx$t_digit .eqs. "0" then goto loop$ $ucx$l_position = ucx$l_position - 1< $ucx$l_length = f$length( ucx$t_in_string ) - ucx$l_positionS $'ucx$t_global_symbol == f$extract( ucx$l_position, ucx$l_length, ucx$t_in_string )r" $ucx$gl_status == UCX$GL_SS_NORMAL $exitl $endsubroutine                                                                                                                                                                                                                                                                                                                                                                                                                   ; * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CHESS_SUBAGENT.EXE;1 +  , c   .     / #   4                             - P    0   1    2   3      K  P   W   O     5   6 _
כ  7 a
u؛  8          9          G    H  J                     0 D `     0205        
W      g                                             UCX$CHESS_SUBAGENT                     UCX X4.2-21    a7
כ 05-13           S           V T              U    B       V        
       ?   $      +         UCX$IPC_SHR_001 O    !       
MTHRTL_001      !        
LIBRTL_001$      +        CMA$TIS_SHR_001'      !        UCX$ACCESS_SHR_001!      !         DECC$SHR_001                                                                                                                                                                                                                                                                                                                                                                                                                                                                    0                        Ǆ $      UCX042.B                       c  P  ;[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CHESS_SUBAGENT.EXE;1                                                                                                  C "                 1.3.6.1.3.4.36.2.15.2                     $            
                                                                                                                                  ! !                 -trace Initializing eSNMP connection... DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]CHESS_MIB.C;2    select returned:%s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]CHESS_MIB.C;2    time to send ARE_YOU_THERE
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]CHESS_MIB.C;2 This process is a duplicate sub-agent. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]CHESS_MIB.C;2        eSNMP error: %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]CHESS_MIB.C;2 Terminating... DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]CHESS_MIB.C;2        USAGE: %s [-d][-trace]
     -d            Don't Daemonize
          -trace        print trace messages
 SIGINT signal -exiting
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]CHESS_MIB.C;2                      $            c                     $            c                            $            c                            $            c                            $            c                                  $            c                                  $            c                                  $            c                                  $            c                                  $            c                                  $            c                                  $            c                            X                X                X           P     TY `\         	   TY `\            TY `\            TY `\       @     Z a       |  	   Z a 	        	   Z a 
           Z a chess 1.3.6.1.4.1.36.2.15.2.99  0 Out of Memory
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2  %s%u . Out of memory
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2 Out of memory
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2 o_integer; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2   o_integer; value out of range; %lx
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2 Cannot use o_integer for this object type; %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2 o_octet; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2  o_octet; value too big for IpAddress
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2  o_octet; value too big for DisplayString
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2 o_octet; Invalid first byte
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2 o_oid; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2  o_string; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2    o_string; IpAddress does not have length 4
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2        o_string; Wrong data type for a string
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2 gettimeofday returned failure
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;2                                                                    eSNMP can't get Process ID.
  %s_%X eSNMP can't get master agent's address.
  esnmp   udp eSNMP well-known port is not defined.
 %s%d /tmp/esnmp_sub Trying to do registeration before calling esnmp_init().
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 Timeout value %d is out of range.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 Subtree '%s' already marked for registeration
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 Malloc error
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 Trying to send registeration when not opened
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2   Register (%d) subtree '%s'
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 UNREGISTER request, subtree='%s', reason=%d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 Could not send the ARE_YOU_THERE message
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 TRAP: Someone is doing a trap; %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 Could not send TRAP message
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2                 Could not open socket:%s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 eSNMP can't get subagent's host address.
 BInding Socket to port %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 Could not bind port %d to socket: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 Sending (len=%d), %s, to %d.%d.%d.%d, port %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2   Can't send: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 recvfrom returned: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2     Invalid packet length: %d, received %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2 Received %s from %d.%d.%d.%d, port %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;2                                                                                                          0                                	        &  8      ???Message With Zero for action code??? GET     GETNEXT SET TRAP RESPONSE REGISTER UNREGISTER OPEN  CLOSE COMMIT UNDO   GETBULK TRAPV2 INFORM ARE_YOU_THERE     CLEANUP     %s **ERROR %s line %d: %s %s WARNING %s line %d: %s %s %s%d.log /tmp/esnmp_sub  w Starting trace file for %s esnmp: %s  Starting tracefile for %s esnmp: %s a %s %s %s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
               #     ,     8  	   D  
   R     ]     h  
   |                           P     Q     e     f     g     h   (  i   F  j   X  k   j  l     m     n     o     p     q             noError tooBig noSuchName badValue readOnly genErr noAccess wrongType   wrongLength wrongEncoding wrongValue noCreation inconsistentValue   resourceUnavailable commitFailed undoFailed authorizationError  notWritable inconsistentName NoSuchInstance NoSuchObject DPI_otherError DPI_notFound  DPI_alreadyRegistered DPI_higherPriorityRegistered  DPI_mustOpenFirst DPI_notAuthorized DPI_viewSelectionNotSupported DPI_getBulkSelectionNotSupported        DPI_duplicateSubAgentIdentifier DPI_invalidDisplayString  DPI_characterSetSelectionNotSupported DPI_dataError DPI_resourceError Unknown error type %*.*s%s - %s%s, packet id=%d         ALONE,      V1  V2      Unknown Version DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2    , non-repeaters=%d, max-repetitions=%d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2    , error_index=%d, error_code=%d %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2    %*.*s  argument=%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 %*.*sVARBIND OID=%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 %*.*s  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 Integer32 = %ld
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 Counter32 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 Gauge32 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 TimeTicks = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 UInteger32 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 Counter64 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 OctetString =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 IpAddress =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2  DisplayString = "%.*s%s"
 ...too big  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SN                                                                                                                                                                                                                                                   1                        + $      UCX042.B                       c  P  ;[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CHESS_SUBAGENT.EXE;1                                                                                                  ! "            MP]ESNMP_LOG.C;2 NsapAddress =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2  Opaque =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 BitString =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 ObjectId = "%s"
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2  Exception = noSuchObject
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2    Exception = noSuchInstance
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2  Exception = endOfMibView
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 Null-type
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 Invalid data type: 0x%X
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2  -nill-
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 (len=%d) 0x[   %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 %*.*s%s
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2    %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 %02x %*.*s%s]
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2 %s]
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;2                                        esnmp_poll: Could not process a packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2   Incoming Packet
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2   Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2         dispatch - RESPONSE, packet_id=%d %s
   from OPEN from REGISTER DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 RESPONSE to OPEN: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 RESPONSE to OPEN: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 RESPONSE to REGISTRATION of '%s': %s
   Unknown DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2     RESPONSE to REGISTRATION of '%s': OK
 Unknown DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2   Bad response to ARE-YOU-THERE, restart
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 DPI CLOSE received from agent, reason=%d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2   dispatch UNREGISTER
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 Unexpected DPI packet type %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2        requested oid:%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2        object id:%d, dots:%s    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2        no object found,   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 Not a readable object
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2  Method Routine returns: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2   Method routine returned invalid status: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2     %2d requested oid: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2        no more objects found
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2        try obj id:%-3d %s (subtree '%s')  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 Not a readable object
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 (as a GET)  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2    Method Routine returns: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2        Instance out of range
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2   Method routine returned invalid status: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 Extending varbind list one more repeating section
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 SET - test phase, pass 1
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2        requested obj idx:%d, object:%s, dots:%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2              requested oid:%s, object:-null-
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 No object found in object table
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 No set function for this MIB variable
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 Data is of the wrong type; should be %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 No instance in the varbind's OID
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 Out of memory during a set
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 An error has been declared in index %d; cleaning up
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 SET - test phase, pass 2
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2   Method routine returned unknown status: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 method routine declared an error; %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2   SET - commit phase
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2   Method routine declared an error during COMMIT
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 Method routine declared an error during UNDO
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 SET - undo phase
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 Method routine declared an error during UNDO
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2 Invalid data type: 0x%X
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;2     01-JAN-1970 00:00:00.00       :  :  :  $:  .:  4:  @:  H:  P:  ^:  UNDEFINED CONDITION ALERT SUBALERT  EMERGENCY ERROR CRITICAL    WARNING NOTICE  INFORMATIONAL DEBUG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      %s:  
 esnmp_pack: No hdr and Varbind to pack
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;2           Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;2 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;2 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;2 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;2 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;2 Pack: Invalid data type: 0x%X
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;2   esnmp_unpack: No packet to unpack
      DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 Unexpected protocol type: 0x%X
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 Invalid security packet length: %d
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 No Memory - packet dropped
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 Unrecognized packet type: 0x%X
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 Empty Get request packet
       DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 Invalid starting OID format in packet:'%s'
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 Invalid ending OID format in packet:'%s'
       DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 Badly formed DPI packet, length error
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 Badly formed DPI packet, length error
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 Invalid data type: 0x%X
        DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;2 C  @(#)$RCSfile: prnt_lib.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/12/19 16:53:03 $        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated  
Packet Dump: 
 %2.2x         
 PrintVarBindList, vb_ptr->name:
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;2 %s =    %u
 %d
 %d.%d.%d.%d
    PrintVarBindList, vb_ptr->value.oid_value:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;2 %s
 NULL
 PrintVarBindList: Illegal type: 0x%x
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;2 
 %c  
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   2                        4 $      UCX042.B                       c  P  ;[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CHESS_SUBAGENT.EXE;1                                                                                                  0 "     $       %s               at line %d in file %s
 Error code set in packet -      Return packet too big.
 No such variable name.  Index:  %d.
  Bad variable value.  Index:  %d.
 Read only variable:  %d.
 General error:  %d.
 Unknown status code:  %d.
       F  @(#)$RCSfile: oid_lib.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/04/27 19:27:50 $ SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated      PS  VS  XS  \S  `S  dS  hS  lS  rS  S  S  S  S  S  S  S  S  S  S  S  S   T  T   T  0T  @T  PT  XT  hT  xT  T  T  T  T  T  T  T  T  T   U  U   U  8U  @U  TU  \U  pU  xU  U  U  U  U  U  U  U  V  V  (V  <V  GV  \V  jV  V  V  V  V  V  V  V  V  W  W  1W  @W  XW  hW  ~W  W  W  W  W  W  W  W  X  X  X   X  0X  8X  JX  TX  hX  xX  X  X  X  X  X  X  X  X   Y  Y   Y  0Y  @Y  PY  `Y  pY  Y  Y  Y  Y  Y  Y  Y  Y  Z  Z  (Z  6Z  GZ  VZ  gZ  tZ  Z  Z  Z  Z  Z  Z  Z  Z  Z  [  [  ([  <[  H[  \[  h[  }[  [  [  [  [  [  [   \  \  "\  3\  @\  T\  `\  u\  \  \  \  \  \  \  \  ]  ]  )]  8]  P]  \]  q]  ~]  ]  ]  ]  ]  ]  ]  ]  ^  ^  0^  B^  T^  h^  |^  ^  ^  ^  ^  ^  _  _  *_  ;_  @_  N_  `_  p_  _  _  _  _  _  _  _  _  `   `  0`  @`  P`  ``  p`  `  `  `  `  `  `  `  a  a  $a  6a  Da  Xa  la  }a  a  a  a  a  a  a  a  b  b  (b  8b  Jb  \b  mb  b  b  b  b  b  b  b  b  c  c  (c  8c  Hc  Xc  hc  xc  c  c  c  c  c  c  c  c  d  d  "d  3d  >d  Od  ^d  od  |d  d  d  d  d  d  d  d  
e   e  2e  Ge  Ve  le  ve  e  e  e  e  e  e  e  e  e  f  f  (f  8f  Hf  Xf  bf  xf  f  f  f  f  f  f  f  f   g  g   g  0g  @g  Pg  `g  pg  ~g  g  g  g  g  g  g  g  h  h  ,h  @h  Ph  hh  xh  h  h  h  h  h  h  i  i  *i  @i  Ui  ji  i  i  i  i  i  i  i  i  j  
j  j  (j  <j  Nj  dj  vj  j  j  j  j  j  j  k  ,k  Fk  ^k  xk  k  k  k  k  k  l  l  6l  Pl  jl  l  l  l  l  l  m  &m  Am  \m  xm  m  m  m  m  m  n  (n  Cn  \n  xn  n  n  n  n  n  n   o  o  ,o  Fo  Xo  ro  o  o  o  o  p  (p  Bp  \p  tp  p  p  p  p  p  q  &q  @q  \q  zq  q  q  q  q  q  r  (r  8r  Tr  hr  r  r  r  r  r  s   s  4s  Os  bs  }s  s  s  s  s  t   t  2t  Mt  bt  ~t  t  t  t  t  t  u  u  0u  @u  Tu  hu  ~u  u  u  u  u  u   v  v  ,v  @v  Zv  rv  v  v  v  v   w  w  .w  Jw  dw  ~w  w  w  w  w  x  x  1x  Dx  _x  vx  x  x  x  x  x  y  .y  Dy  _y  ty  y  y  y  y  y  
z  %z  >z  \z  pz  z  z  z  z  z  z  {  ({  @{  X{  p{  {  {  {  {  {  |  :|  T|  v|  |  |  |  |  }  }  ,}  @}  X}  l}  }  }  }  }  }  }  }  }  }  ~  (~  @~  Q~  h~  y~  ~  ~  ~  ~  ~  ~  ~       2  @  R  f  x                    0  <  N  ^  p          ʀ  ܀        *  >  P  d  v          ́  ց  ܁              ,  >  L  ^  n          Ƃ  Ԃ          .  >  P  `  n          ȃ  ڃ        &  @  X  p        ̄  ބ      !  4  H  \  p        ą  ׅ        #  4  G  X  l            І  ކ            0  H  X  h  v          ҇          ,  D  V  h  z        ƈ  ܈        2  H  P  \  h  t  z            ȉ  ؉  މ               ccitt 0 iso 1   org 1.3 dod 1.3.6 internet      1.3.6.1 directory 1.3.6.1.1 mgmt  1.3.6.1.2 mib_2   1.3.6.1.2.1 system  1.3.6.1.2.1.1 sysDescr  1.3.6.1.2.1.1.1 sysObjectID     1.3.6.1.2.1.1.2 sysUpTime       1.3.6.1.2.1.1.3 sysContact      1.3.6.1.2.1.1.4 sysName 1.3.6.1.2.1.1.5 sysLocation     1.3.6.1.2.1.1.6 sysServices     1.3.6.1.2.1.1.7 interfaces  1.3.6.1.2.1.2 ifNumber      1.3.6.1.2.1.2.1 ifTable 1.3.6.1.2.1.2.2 ifEntry 1.3.6.1.2.1.2.2.1       ifIndex 1.3.6.1.2.1.2.2.1.1     ifDescr 1.3.6.1.2.1.2.2.1.2 ifType  1.3.6.1.2.1.2.2.1.3 ifMtu   1.3.6.1.2.1.2.2.1.4     ifSpeed 1.3.6.1.2.1.2.2.1.5 ifPhysAddress   1.3.6.1.2.1.2.2.1.6 ifAdminStatus   1.3.6.1.2.1.2.2.1.7 ifOperStatus    1.3.6.1.2.1.2.2.1.8 ifLastChange    1.3.6.1.2.1.2.2.1.9 ifInOctets 1.3.6.1.2.1.2.2.1.10 ifInUcastPkts 1.3.6.1.2.1.2.2.1.11 ifInNUcastPkts 1.3.6.1.2.1.2.2.1.12 ifInDiscards 1.3.6.1.2.1.2.2.1.13 ifInErrors 1.3.6.1.2.1.2.2.1.14  ifInUnknownProtos 1.3.6.1.2.1.2.2.1.15    ifOutOctets 1.3.6.1.2.1.2.2.1.16 ifOutUcastPkts 1.3.6.1.2.1.2.2.1.17    ifOutNUcastPkts 1.3.6.1.2.1.2.2.1.18  ifOutDiscards 1.3.6.1.2.1.2.2.1.19    ifOutErrors 1.3.6.1.2.1.2.2.1.20  ifOutQLen 1.3.6.1.2.1.2.2.1.21 ifSpecific 1.3.6.1.2.1.2.2.1.22 at 1.3.6.1.2.1.3   atTable 1.3.6.1.2.1.3.1 atEntry 1.3.6.1.2.1.3.1.1 atIfIndex 1.3.6.1.2.1.3.1.1.1 atPhysAddress   1.3.6.1.2.1.3.1.1.2 atNetAddress    1.3.6.1.2.1.3.1.1.3 ip  1.3.6.1.2.1.4 ipForwarding  1.3.6.1.2.1.4.1 ipDefaultTTL    1.3.6.1.2.1.4.2 ipInReceives    1.3.6.1.2.1.4.3 ipInHdrErrors   1.3.6.1.2.1.4.4 ipInAddrErrors  1.3.6.1.2.1.4.5 ipForwDatagrams 1.3.6.1.2.1.4.6 ipInUnknownProtos       1.3.6.1.2.1.4.7 ipInDiscards    1.3.6.1.2.1.4.8 ipInDelivers    1.3.6.1.2.1.4.9 ipOutRequests 1.3.6.1.2.1.4.10  ipOutDiscards 1.3.6.1.2.1.4.11  ipOutNoRoutes 1.3.6.1.2.1.4.12 ipReasmTimeout 1.3.6.1.2.1.4.13 ipReasmReqds 1.3.6.1.2.1.4.14 ipReasmOKs 1.3.6.1.2.1.4.15 ipReasmFails 1.3.6.1.2.1.4.16  ipFragOKs 1.3.6.1.2.1.4.17  ipFragFails 1.3.6.1.2.1.4.18  ipFragCreates 1.3.6.1.2.1.4.19    ipAddrTable 1.3.6.1.2.1.4.20    ipAddrEntry 1.3.6.1.2.1.4.20.1  ipAdEntAddr 1.3.6.1.2.1.4.20.1.1 ipAdEntIfIndex 1.3.6.1.2.1.4.20.1.2 ipAdEntNetMask 1.3.6.1.2.1.4.20.1.3 ipAdEntBcastAddr 1.3.6.1.2.1.4.20.1.4  ipAdEntReasmMaxSize 1.3.6.1.2.1.4.20.1.5 ipRouteTable 1.3.6.1.2.1.4.21 ipRouteEntry 1.3.6.1.2.1.4.21.1  ipRouteDest 1.3.6.1.2.1.4.21.1.1 ipRouteIfIndex 1.3.6.1.2.1.4.21.1.2 ipRouteMetric1 1.3.6.1.2.1.4.21.1.3 ipRouteMetric2 1.3.6.1.2.1.4.21.1.4 ipRouteMetric3 1.3.6.1.2.1.4.21.1.5 ipRouteMetric4 1.3.6.1.2.1.4.21.1.6 ipRouteNextHop 1.3.6.1.2.1.4.21.1.7    ipRouteType 1.3.6.1.2.1.4.21.1.8 ipRouteProto 1.3.6.1.2.1.4.21.1.9 ipRouteAge 1.3.6.1.2.1.4.21.1.10 ipRouteMask 1.3.6.1.2.1.4.21.1.11 ipRouteMetric5  1.3.6.1.2.1.4.21.1.12 ipRouteInfo 1.3.6.1.2.1.4.21.1.13 ipNetToMediaTable 1.3.6.1.2.1.4.22  ipNetToMediaEntry 1.3.6.1.2.1.4.22.1  ipNetToMediaIfIndex 1.3.6.1.2.1.4.22.1.1        ipNetToMediaPhysAddress 1.3.6.1.2.1.4.22.1.2 ipNetToMediaNetAddress 1.3.6.1.2.1.4.22.1.3 ipNetToMediaType 1.3.6.1.2.1.4.22.1.4  ipRoutingDiscards 1.3.6.1.2.1.4.23 icmp 1.3.6.1.2.1.5 icmpInMsgs        1.3.6.1.2.1.5.1 icmpInErrors    1.3.6.1.2.1.5.2 icmpInDestUnreachs      1.3.6.1.2.1.5.3 icmpInTimeExcds 1.3.6.1.2.1.5.4 icmpInParmProbs 1.3.6.1.2.1.5.5 icmpInSrcQuenchs        1.3.6.1.2.1.5.6 icmpInRedirects 1.3.6.1.2.1.5.7 icmpInEchos     1.3.6.1.2.1.5.8 icmpInEchoReps  1.3.6.1.2.1.5.9 icmpInTimestamps 1.3.6.1.2.1.5.10   icmpInTimestampReps 1.3.6.1.2.1.5.11        icmpInAddrMasks 1.3.6.1.2.1.5.12 icmpInAddrMaskReps 1.3.6.1.2.1.5.13    icmpOutMsgs 1.3.6.1.2.1.5.14  icmpOutErrors 1.3.6.1.2.1.5.15    icmpOutDestUnreachs 1.3.6.1.2.1.5.16 icmpOutTimeExcds 1.3.6.1.2.1.5.17 icmpOutParmProbs 1.3.6.1.2.1.5.18  icmpOutSrcQuenchs 1.3.6.1.2.1.5.19 icmpOutRedirects 1.3.6.1.2.1.5.20 icmpOutEchos 1.3.6.1.2.1.5.21    icmpOutEchoReps 1.3.6.1.2.1.5.22  icmpOutTimestamps 1.3.6.1.2.1.5.23 icmpOutTimestampReps 1.3.6.1.2.1.5.24 icmpOutAddrMasks 1.3.6.1.2.1.5.25    icmpOutAddrMaskReps 1.3.6.1.2.1.5.26    tcp 1.3.6.1.2.1.6       tcpRtoAlgorithm 1.3.6.1.2.1.6.1 tcpRtoMin       1.3.6.1.2.1.6.2 tcpRtoMax       1.3.6.1.2.1.6.3 tcpMaxConn      1.3.6.1.2.1.6.4 tcpActiveOpens  1.3.6.1.2.1.6.5 tcpPassiveOpens 1.3.6.1.2.1.6.6 tcpAttemptFails 1.3.6.1.2.1.6.7 tcpEstabResets  1.3.6.1.2.1.6.8 tcpCurrEstab    1.3.6.1.2.1.6.9 tcpInSegs 1.3.6.1.2.1.6.10 tcpOutSegs 1.3.6.1.2.1.6.11 tcpRetransSegs 1.3.6.1.2.1.6.12 tcpConnTable 1.3.6.1.2.1.6.13 tcpConnEntry 1.3.6.1.2.1.6.13.1 tcpConnState 1.3.6.1.2.1.6.13.1.1  tcpConnLocalAddress 1.3.6.1.2.1.6.13.1.2 tcpConnLocalPort 1.3.6.1.2.1.6.13.1.3  tcpConnRemAddress 1.3.6.1.2.1.6.13.1.4 tcpConnRemPort 1.3.6.1.2.1.6.13.1.5  tcpInErrs 1.3.6.1.2.1.6.14 tcpOutRsts 1.3.6.1.2.1.6.15  udp 1.3.6.1.2.1.7 udpInDatagrams    1.3.6.1.2.1.7.1 udpNoPorts      1.3.6.1.2.1.7.2 udpInErrors     1.3.6.1.2.1.7.3 udpOutDatagrams 1.3.6.1.2.1.7.4 udpTable        1.3.6.1.2.1.7.5 udpEntry  1.3.6.1.2.1.7.5.1     udpLocalAddress 1.3.6.1.2.1.7.5.1.1 udpLocalPort    1.3.6.1.2.1.7.5.1.2 egp 1.3.6.1.2.1.8 egpInMsgs     1.3.6.1.2.1.8.1 egpInErrors     1.3.6.1.2.1.8.2 egpOutMsgs      1.3.6.1.2.1.8.3 egpOutErrors    1.3.6.1.2.1.8.4 egpNeighTable   1.3.6.1.2.1.8.5 egpNeighEntry 1.3.6.1.2.1.8.5.1 egpNeighState   1.3.6.1.2.1.8.5.1.1 egpNeighAddr    1.3.6.1.2.1.8.5.1.2 egpNeighAs  1.3.6.1.2.1.8.5.1.3 egpNeigh                                                                                                                                                                                                                                                   3                        O $      UCX042.B                       c  P  ;[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CHESS_SUBAGENT.EXE;1                                                                                                   "     5       InMsgs  1.3.6.1.2.1.8.5.1.4 egpNeighInErrs  1.3.6.1.2.1.8.5.1.5 egpNeighOutMsgs 1.3.6.1.2.1.8.5.1.6     egpNeighOutErrs 1.3.6.1.2.1.8.5.1.7 egpNeighInErrMsgs   1.3.6.1.2.1.8.5.1.8 egpNeighOutErrMsgs  1.3.6.1.2.1.8.5.1.9 egpNeighStateUps 1.3.6.1.2.1.8.5.1.10 egpNeighStateDowns 1.3.6.1.2.1.8.5.1.11 egpNeighIntervalHello 1.3.6.1.2.1.8.5.1.12 egpNeighIntervalPoll 1.3.6.1.2.1.8.5.1.13 egpNeighMode 1.3.6.1.2.1.8.5.1.14 egpNeighEventTrigger 1.3.6.1.2.1.8.5.1.15  egpAs       1.3.6.1.2.1.8.6 transmission 1.3.6.1.2.1.10 fddi  1.3.6.1.2.1.10.15 snmpFddiSMT 1.3.6.1.2.1.10.15.1 snmpFddiSMTNumber 1.3.6.1.2.1.10.15.1.1 snmpFddiSMTTable  1.3.6.1.2.1.10.15.1.2 snmpFddiSMTEntry    1.3.6.1.2.1.10.15.1.2.1 snmpFddiSMTIndex  1.3.6.1.2.1.10.15.1.2.1.1 snmpFddiSMTStationId  1.3.6.1.2.1.10.15.1.2.1.2 snmpFddiSMTOpVersionId  1.3.6.1.2.1.10.15.1.2.1.3 snmpFddiSMTHiVersionId  1.3.6.1.2.1.10.15.1.2.1.4 snmpFddiSMTLoVersionId  1.3.6.1.2.1.10.15.1.2.1.5 snmpFddiSMTMACCt  1.3.6.1.2.1.10.15.1.2.1.6 snmpFddiSMTNonMasterCt  1.3.6.1.2.1.10.15.1.2.1.7 snmpFddiSMTMasterCt 1.3.6.1.2.1.10.15.1.2.1.8 snmpFddiSMTPathsAvailable 1.3.6.1.2.1.10.15.1.2.1.9 snmpFddiSMTConfigCapabilities 1.3.6.1.2.1.10.15.1.2.1.10      snmpFddiSMTConfigPolicy 1.3.6.1.2.1.10.15.1.2.1.11  snmpFddiSMTConnectionPolicy 1.3.6.1.2.1.10.15.1.2.1.12 snmpFddiSMTTNotify 1.3.6.1.2.1.10.15.1.2.1.13 snmpFddiSMTStatusReporting 1.3.6.1.2.1.10.15.1.2.1.14  snmpFddiSMTECMState 1.3.6.1.2.1.10.15.1.2.1.15 snmpFddiSMTCFState 1.3.6.1.2.1.10.15.1.2.1.16 snmpFddiSMTHoldState 1.3.6.1.2.1.10.15.1.2.1.17    snmpFddiSMTRemoteDisconnectFlag 1.3.6.1.2.1.10.15.1.2.1.18 snmpFddiSMTStationAction 1.3.6.1.2.1.10.15.1.2.1.19  snmpFddiMAC 1.3.6.1.2.1.10.15.2 snmpFddiMACNumber 1.3.6.1.2.1.10.15.2.1 snmpFddiMACTable  1.3.6.1.2.1.10.15.2.2 snmpFddiMACEntry        1.3.6.1.2.1.10.15.2.2.1 snmpFddiMACSMTIndex 1.3.6.1.2.1.10.15.2.2.1.1 snmpFddiMACIndex  1.3.6.1.2.1.10.15.2.2.1.2 snmpFddiMACFrameStatusCapabilities  1.3.6.1.2.1.10.15.2.2.1.3 snmpFddiMACTMaxGreatestLowerBound 1.3.6.1.2.1.10.15.2.2.1.4 snmpFddiMACTVXGreatestLowerBound  1.3.6.1.2.1.10.15.2.2.1.5 snmpFddiMACPathsAvailable 1.3.6.1.2.1.10.15.2.2.1.6 snmpFddiMACCurrentPath  1.3.6.1.2.1.10.15.2.2.1.7 snmpFddiMACUpstreamNbr  1.3.6.1.2.1.10.15.2.2.1.8 snmpFddiMACOldUpstreamNbr 1.3.6.1.2.1.10.15.2.2.1.9 snmpFddiMACDupAddrTest 1.3.6.1.2.1.10.15.2.2.1.10 snmpFddiMACPathsRequested 1.3.6.1.2.1.10.15.2.2.1.11  snmpFddiMACDownstreamPORTType 1.3.6.1.2.1.10.15.2.2.1.12  snmpFddiMACSMTAddress 1.3.6.1.2.1.10.15.2.2.1.13  snmpFddiMACTReq 1.3.6.1.2.1.10.15.2.2.1.14      snmpFddiMACTNeg 1.3.6.1.2.1.10.15.2.2.1.15      snmpFddiMACTMax 1.3.6.1.2.1.10.15.2.2.1.16  snmpFddiMACTvxValue 1.3.6.1.2.1.10.15.2.2.1.17      snmpFddiMACTMin 1.3.6.1.2.1.10.15.2.2.1.18  snmpFddiMACCurrentFrameStatus 1.3.6.1.2.1.10.15.2.2.1.19    snmpFddiMACFrameCts 1.3.6.1.2.1.10.15.2.2.1.20  snmpFddiMACErrorCts 1.3.6.1.2.1.10.15.2.2.1.21 snmpFddiMACLostCts 1.3.6.1.2.1.10.15.2.2.1.22 snmpFddiMACFrameErrorThreshold 1.3.6.1.2.1.10.15.2.2.1.23 snmpFddiMACFrameErrorRatio 1.3.6.1.2.1.10.15.2.2.1.24    snmpFddiMACRMTState 1.3.6.1.2.1.10.15.2.2.1.25  snmpFddiMACDaFlag 1.3.6.1.2.1.10.15.2.2.1.26 snmpFddiMACUnaDaFlag 1.3.6.1.2.1.10.15.2.2.1.27  snmpFddiMACFrameCondition 1.3.6.1.2.1.10.15.2.2.1.28 snmpFddiMACChipSet 1.3.6.1.2.1.10.15.2.2.1.29  snmpFddiMACAction 1.3.6.1.2.1.10.15.2.2.1.30 snmpFddiPATH 1.3.6.1.2.1.10.15.3 snmpFddiPORT    1.3.6.1.2.1.10.15.4 snmpFddiPORTNumber  1.3.6.1.2.1.10.15.4.1 snmpFddiPORTTable 1.3.6.1.2.1.10.15.4.2 snmpFddiPORTEntry 1.3.6.1.2.1.10.15.4.2.1 snmpFddiPORTSMTIndex  1.3.6.1.2.1.10.15.4.2.1.1 snmpFddiPORTIndex 1.3.6.1.2.1.10.15.4.2.1.2 snmpFddiPORTPCType  1.3.6.1.2.1.10.15.4.2.1.3 snmpFddiPORTPCNeighbor  1.3.6.1.2.1.10.15.4.2.1.4 snmpFddiPORTConnectionPolicies  1.3.6.1.2.1.10.15.4.2.1.5 snmpFddiPORTRemoteMACIndicated  1.3.6.1.2.1.10.15.4.2.1.6 snmpFddiPORTCEState 1.3.6.1.2.1.10.15.4.2.1.7 snmpFddiPORTPathsRequested  1.3.6.1.2.1.10.15.4.2.1.8 snmpFddiPORTMACPlacement  1.3.6.1.2.1.10.15.4.2.1.9 snmpFddiPORTAvailablePaths 1.3.6.1.2.1.10.15.4.2.1.10   snmpFddiPORTMACLoopTime 1.3.6.1.2.1.10.15.4.2.1.11  snmpFddiPORTTBMax 1.3.6.1.2.1.10.15.4.2.1.12 snmpFddiPORTBSFlag 1.3.6.1.2.1.10.15.4.2.1.13 snmpFddiPORTLCTFailCts 1.3.6.1.2.1.10.15.4.2.1.14        snmpFddiPORTLerEstimate 1.3.6.1.2.1.10.15.4.2.1.15 snmpFddiPORTLemRejectCts 1.3.6.1.2.1.10.15.4.2.1.16 snmpFddiPORTLemCts 1.3.6.1.2.1.10.15.4.2.1.17  snmpFddiPORTLerCutoff 1.3.6.1.2.1.10.15.4.2.1.18 snmpFddiPORTLerAlarm 1.3.6.1.2.1.10.15.4.2.1.19 snmpFddiPORTConnectState 1.3.6.1.2.1.10.15.4.2.1.20 snmpFddiPORTPCMState 1.3.6.1.2.1.10.15.4.2.1.21 snmpFddiPORTPCWithhold 1.3.6.1.2.1.10.15.4.2.1.22 snmpFddiPORTLerCondition 1.3.6.1.2.1.10.15.4.2.1.23    snmpFddiPORTChipSet 1.3.6.1.2.1.10.15.4.2.1.24 snmpFddiPORTAction 1.3.6.1.2.1.10.15.4.2.1.25 snmpFddiATTACHMENT 1.3.6.1.2.1.10.15.5 snmpFddiATTACHMENTNumber  1.3.6.1.2.1.10.15.5.1 snmpFddiATTACHMENTTable 1.3.6.1.2.1.10.15.5.2   snmpFddiATTACHMENTEntry 1.3.6.1.2.1.10.15.5.2.1 snmpFddiATTACHMENTSMTIndex  1.3.6.1.2.1.10.15.5.2.1.1   snmpFddiATTACHMENTIndex 1.3.6.1.2.1.10.15.5.2.1.2       snmpFddiATTACHMENTClass 1.3.6.1.2.1.10.15.5.2.1.3 snmpFddiATTACHMENTOpticalBypassPresent  1.3.6.1.2.1.10.15.5.2.1.4 snmpFddiATTACHMENTIMaxExpiration  1.3.6.1.2.1.10.15.5.2.1.5 snmpFddiATTACHMENTInsertedStatus  1.3.6.1.2.1.10.15.5.2.1.6 snmpFddiATTACHMENTInsertPolicy  1.3.6.1.2.1.10.15.5.2.1.7 snmpFddiChipSets  1.3.6.1.2.1.10.15.6 snmpFddiPHYChipSets 1.3.6.1.2.1.10.15.6.1   snmpFddiMACChipSets 1.3.6.1.2.1.10.15.6.2 snmpFddiPHYMACChipSets  1.3.6.1.2.1.10.15.6.3 snmp 1.3.6.1.2.1.11 snmpInPkts 1.3.6.1.2.1.11.1 snmpOutPkts 1.3.6.1.2.1.11.2  snmpInBadVersions 1.3.6.1.2.1.11.3        snmpInBadCommunityNames 1.3.6.1.2.1.11.4 snmpInBadCommunityUses 1.3.6.1.2.1.11.5 snmpInASNParseErrs 1.3.6.1.2.1.11.6  snmpInTooBigs 1.3.6.1.2.1.11.8  snmpInNoSuchNames 1.3.6.1.2.1.11.9        snmpInBadValues 1.3.6.1.2.1.11.10       snmpInReadOnlys 1.3.6.1.2.1.11.11 snmpInGenErrs 1.3.6.1.2.1.11.12 snmpInTotalReqVars  1.3.6.1.2.1.11.13 snmpInTotalSetVars  1.3.6.1.2.1.11.14 snmpInGetRequests 1.3.6.1.2.1.11.15 snmpInGetNexts  1.3.6.1.2.1.11.16 snmpInSetRequests 1.3.6.1.2.1.11.17 snmpInGetResponses  1.3.6.1.2.1.11.18   snmpInTraps 1.3.6.1.2.1.11.19 snmpOutTooBigs  1.3.6.1.2.1.11.20 snmpOutNoSuchNames  1.3.6.1.2.1.11.21 snmpOutBadValues  1.3.6.1.2.1.11.22 snmpOutGenErrs  1.3.6.1.2.1.11.24 snmpOutGetRequests  1.3.6.1.2.1.11.25       snmpOutGetNexts 1.3.6.1.2.1.11.26 snmpOutSetRequests  1.3.6.1.2.1.11.27 snmpOutGetResponses 1.3.6.1.2.1.11.28 snmpOutTraps  1.3.6.1.2.1.11.29 snmpEnableAuthenTraps 1.3.6.1.2.1.11.30 experimental  1.3.6.1.3 dot5  1.3.6.1.3.4 dot5Table 1.3.6.1.3.4.1 dot5Entry       1.3.6.1.3.4.1.1 dot5IfIndex 1.3.6.1.3.4.1.1.1 dot5Commands  1.3.6.1.3.4.1.1.2 dot5RingStatus  1.3.6.1.3.4.1.1.3 dot5RingState 1.3.6.1.3.4.1.1.4 dot5RingOpenStatus  1.3.6.1.3.4.1.1.5 dot5RingSpeed 1.3.6.1.3.4.1.1.6 dot5UpStream  1.3.6.1.3.4.1.1.7 dot5ActMonParticipate 1.3.6.1.3.4.1.1.8 dot5Functional  1.3.6.1.3.4.1.1.9 dot5StatsTable  1.3.6.1.3.4.2 dot5StatsEntry    1.3.6.1.3.4.2.1 dot5StatsIfIndex  1.3.6.1.3.4.2.1.1 dot5StatsLineErrors 1.3.6.1.3.4.2.1.2 dot5StatsBurstErrors  1.3.6.1.3.4.2.1.3 dot5StatsACErrors 1.3.6.1.3.4.2.1.4 dot5StatsAbortTransErrors 1.3.6.1.3.4.2.1.5       dot5StatsInternalErrors 1.3.6.1.3.4.2.1.6 dot5StatsLostFrameErrors  1.3.6.1.3.4.2.1.7   dot5StatsReceiveCongestions 1.3.6.1.3.4.2.1.8 dot5StatsFrameCopiedErrors  1.3.6.1.3.4.2.1.9 dot5StatsTokenErrors 1.3.6.1.3.4.2.1.10 dot5StatsSoftErrors 1.3.6.1.3.4.2.1.11  dot5StatsHardErrors 1.3.6.1.3.4.2.1.12  dot5StatsSignalLoss 1.3.6.1.3.4.2.1.13 dot5StatsTransmitBeacons 1.3.6.1.3.4.2.1.14 dot5StatsRecoverys 1.3.6.1.3.4.2.1.15 dot5StatsLobeWires 1.3.6.1.3.4.2.1.16 dot5StatsRemoves 1.3.6.1.3.4.2.1.17 dot5StatsSingles 1.3.6.1.3.4.2.1.18  dot5StatsFreqErrors 1.3.6.1.3.4.2.1.19  dot5Tests 1.3.6.1.3.4.3 testInsertFunc      1.3.6.1.3.4.3.1 dot5ChipSets  1.3.6.1.3.4.4 chipSetIBM16        1.3.6.1.3.4.4.1 chipSetTItms380 1.3.6.1.3.4.4.2 chipSetTItms380c16      1.3.6.1.3.4.4.3 dot5TimerTable  1.3.6.1.3.4.5 dot5TimerEntry    1.3.6.1.3.4.5.1 dot5TimerIfIndex  1.3.6.1.3.4.5.1.1 dot5TimerReturnRepeat 1.3.6.1.3.4.5.1.2 dot5TimerHolding  1.3.6.1.3.4.5.1.3 dot5TimerQueuePDU 1.3.6.1.3.4.5.1.4 dot5TimerValidTransmit  1.3.6.1.3.4.5.1.5 dot5TimerNoToken  1.3.6.1.3.4.5.1.6 dot5TimerActiveMon  1.3.6.1.3.4.5.1.7 dot5TimerStandbyMon 1.3.6.1.3.4.5.1.8 dot5TimerErrorReport  1.3.6.1.3.4.5.1.9   dot5TimerBeaconTransmit 1.3.6.1.3.4.5.1.10 dot5TimerBeaconReceive 1.3.6.1.3.4.5.1.11    private 1.3.6.1.4   enterprises 1.3.6.1.4.1 unix  1.3.6.1.4.1.4 agents  1.3.6.1.4.1.4.1 fourBSD_isode 1.3.6.1.4.1.4.1.2 peers   1.3.6.1.4.1.4.3 unixd 1.3.6.1.4.1.4.3.1 joint_iso_ccitt                                                                                                                                                                                                                                                    4                        # $      UCX042.B                       @  P  4[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$AKHCFLUU#/.M0O
1                                                                           @                        <v     f       q\ M4t
"F]P?ɇȪ:`1}=4^m#9?ʠ
6b*^u)E>W^3/D i!8&t-ϪՃ71bcAEtk>l`/nd:dwM.klozϺȪ$ߖ,BԆM .A`[!M
f6-РԶ]TbhGHfۍa;XWCw!L n=K(XVBʯT}÷oPULLdjH`7l8>ȰjMeKu,9y\e}uԉW:ԨNbX
4
ePw<W >?	gfs)b(]=-T/e%CN\Ut3;W/ߣO&洢0H>*Cc3Qw621h)~[4b[ʽЗ</XgA:l׎
/Sȝ9~u_U, ʤ Itq@51@Jv^Ax߼ooIGrQ;ik_4Mq+%*
װ2</))͔B534rLg^T-IPs9#w#lVy`t|w[e4Ga7\Hɫʓ5{Nv"A>ύߌ<H%y4J8O1u9.S@-v2
 |̺8zِ3^kRͶ(RSp0F5Q	YBDuZ?FweHJZfm9]п>dm1gAvFHJ_[%kRLP zYCbHz򏄻Mse\{>F[/VO|`m["1DXXDr7&q=xePTnW:oLu ?si%B2{
uMOz/L5=FG"Kq>M}TNQ3
o"΄L6oڻcophtES-.]ԟy]#ƔX2jH(VtT45GaC&xU5l`lKU7Xo 褹Yl|IQ)>$Rq~Xgcڽ̽!L؄yU\A@.9 ^He0c4ߔ7XԸ[J9Xj$sx<QNvJ&*ZLV߆$oqPQq[66+֛LWx!*=\e SxMD4]0%v:y*H+o! A:i.>F5\2|kxb8]饮74GH`xo<A
Z$Zpgg+ܫRU+Cpjbk4q]t?uO͞=t V\.E8!B☠ 	ïgm@!HoRFha \Oc(ȣ=.:=ZAzsl$t7%j銰ohNS-CoCAS: "-DG+BJf)JX曒+Y|Ozrõѣp'Ig)I<炟C|"UϜLxA#7Zjk^ە9k5ewۊimt%p
;f+ǃ5Hםi'=b==P+y^7r$?Vc!xe!S?4ԁW6c2QtzpB(S+?9>kdBV-w|'ycEq:Wyof'm+s7>Rn=}"5?O-!o͜?/&m*2u#g;;OffǍױ&QmQ)nd<9ɄSMoeuBKr仸0#34
|㪺e*_@YW;*-xcԷB*BǹbTY.xU{pAZ[<AwO(FE@d=8UR51Q2T)'ezBU-HPn*NJܑ<ȪwǦQ5at;^Y|L
!x8dG"`>eVA1}!1/60,LGq2jw^\/$~Y&TN& &9FʮΉn$rl>Ex-eƧRhMz]"In߱r`V!J fluv;=uTcd?G[0y܍=+pOFP0mJ <NF*-I!S]eDĲsu	6D2f6-;cR["|[#p<^׉Fۙ .sʝqyds U}W<7jW;leCi᪄z51aKc:nܠ1]1(ܻ/s0j@Shӏ@c;$N$p.vS B׊67ZilK;*["}EEX4GFNj0qh'M0jVp
.R٦a1[X/&
4*:f;CdPVů?{~݆]t9h*c%y	#C*rY"25|+lݏdb?͊ϟ෡YKJ:$A8aW㕌4g?P}] Pu{^QLt<YOJxӶos*:q
!`V߅0ז R/^S)'LkKasL*npG|Љ!OA7]XۼQ{!S=lia,<m[2-=eb?>}#u-{\F;(F_Z>66'뢅;<s&."16Dr0Utoa9^]z<zޕ|LSE>5E˰ެ2-.fV vJX
ŁO .ؼT'^7EB72ҞՂ=l#\tHQc^c`,Bhu^XCYhFntV);@.V98`́~#7USOɊ5FגnY &ck .`{]˩
gQL<oENF.qOƺ2BlXyqm˴9(.حN#ť2bz	@Gi@& (p6&}-P7:Ȓ.T6HdZ?/ӋQ8]}	ތI@"x5zܟǰ[5j\~nsxrQŇxzNd,v4ܲSbNM+kǳ7{op- x*D!Ṓ1EnSh2Dw	>^Ͽ;8l:RIUFz,a1K`afN_*S-B$MqRc0QOEְ
)pa[7\PW]Cml$:KA!/aP(5B^-QxhM;x \HOU@<(ci%"N8~ߞU^
BNbwLO@fT?'A0οibV]zŐ""rMf{	641xV)8;bpu%y(>T¿9Y) ʪ8SEN_pue||Yo1.잽EryFY|FTA
}du}շ@{#>L
ﷵ<%M% KB~,(;+5o[Z^_E읠R	uT뉝kP]k^_ʹ82#[xaSӨ.E}0l]OKB|#9b5wALHC	qa];Ъ2`7_ewrf Os5/(܍FMaÄ92A.
+Aϡ3Q/1mʚ>KoeZŴ58 3b(OZ
(5epNcz[7]Gx8	IFst122bsvD0FO
QcKl_✴MN:mB" ,bR*9RƠbC)67i3Uɓ]ؿzlK6RB
|]N%dISř/ +]_-~I6G<+>0REVCa%&WS}AM;"]69VJ iQ]t\gCBhx\ݷ7Oo|5W@a,u5f L o3UTKf	h}M֣
1uTw~+Js+@ϚTMcs0|zϵ0K.i9-z->r!"ԓJG+"(޽b5rN57ȰΡD8nj@wFs}dX3C̞qk{F_!F.YK%,E;k6X"m8sQ[,=x!La/Qk+p9M8sc8̏bYtzYLarF5ӄ
8sDE#lꭳM0jGen801RB~3!oBX"fkATYrʴ#ebtJc^\d[f3*)9+f"S5/L{Q
Y%ߟO^sfz`T	=>mW|/ǰQc3Ԕ+I5Se.LZ"$!{kr<E?uc%f >܀@c,7@$lF4˷TwiO<?6)\=^MSw+@h6A1ycOY$;\oP H[AWF,[_C	C*%o<0i΅W蠵Mtom#	RHm6[~c<THԀ+`o^ƣzޭzoy@6	RyKJ\R{8?3LE[C`X]ʵ[Kf]W1NNpOE?Iig67+|6vOlv(j	7MāPL(i®pD&YuxMht Q((`AEXb/GGKRK6$Ev<A`FIR}ߘ4+.&%/;m?JuW·7>1]l
E5{ F;=?[zayۙW)Uc8_pY9ʹB~,N3QVk"<4Oo]v7!ceh:؎ 'akDR^d v{E=	<=n1gf%gOΨ=Y|4TA.vć{?Ϻ9{ʏ{`B Lv
@ySZX,f6}SkzzwJIDa7˲QKŢ)~YyWŲv-LBޜru?(hϓ&jCFMxt4kCK*].iFxiD0F|Ydc=P@&l,?HY?u6GmV22Ժ͐PVKZF,?x砧_*-Ϧwj+hMPD*aVꗍ
~7Up NqP@je#ފZqԵǿnrY }N53jg
viC834\~W
 K, 
y3FTI)ȿ.zb΂	{ xǇ>20	]LZ6"zʰf]1z]wY~_LQ*%(>ef؆p"{(%dR*/Ӻ:j,D۶5	cb|}OeU_.9>:d
Qih#Wq0@/xQj37q\E&C(/B<l$g:hHF8g?˰|~Q\b_eG|%9&s^jۗPj!o<7PӁx ]=zhl?泜+#ڹ'p[Q `<Í΅p&Hg S}p1s<7bڬ\Ns3v \RFAa05M`(.a:)AiؚE'GuǶ42pnS b<C=s0>fהVE'	E4FՃ2,S!5	ލ?LSדusPG _ߧ)]^In@<B$]))X݂6d"W*'`f5,+"2㺸ګtthj/@Qѐo-<q`\10TL	cV_Vِn^f3"V%|]̀g9j}҈D%:}CKݔwKMrc99T"Ʊ}(nH4 On\3k:t+5zyj( W~^bNy?4?Iv="?g{W<RaPͷ33Um-CM+:%bIT
fuM1g,UO`7Hn3^wRz|P#9&
Z*=zOmsqPGI ujx̐q A*lq)40 zG[Ža'~lNNlnSm2G$F^8	),>V&SgwÚ={E<y#0ɰA0mpR|L[*<nZ?*Zz`\%Pv$I.Uahpg?.cipZ,4A[Ә]11)&ehQ=r8l`y!:4WM*h8iG_:h8Fb
R@DG E59)x`ۧ $g8HH/_pd
V 8D6. 6l_>l#	LPk7)Q["
tT{ܪp/-vwPS W qC7ⷻ[vgRru5R;H'fU25\И8Dٸoj,뼸Ԗ8*aSHY76Q~c
*+ X;ۀCyc	lJA0g
3_8F
`-[6x>jw <KN--5:@k3)%u~<bfu__7b,.="Lۇ(/DsD8{ZdXww"4 , FMqy=bnķΑjA䉲#@\x	O@`T>wI1cSilU~deڶ

 dĮW@P_5ԭ<8
Mɼ`<߄vH(9F_dwՋBH8QtijR
}CSoQ՗l0=6_^	{q<P,ς7+ᒙdu#j@*2[u%0
.aA'Ǡׂ5=\i`g(ܵ1'ܩ֨RYpY?9:Ԋ#k_ "&SV/oZʅ؅B.`3
=F-71I|k7vcsa4
@]s`bSmAI+Шm/i3U;̃@1`;ͱ!k{RتuLEKqw; Pd	aj
'%Lԣ HbP2)!fE$#V	U?1og97NpSRWU
U40C.^*K΁ziOe^u^G|Ӌk/R <l
H,  ,7 r.<4$R3,&i:80T  ?<R. w&)Dl:6j*M,/*Dw O'<etmdPES H  THE ABOVE COPY                                                                                                                                                   5                        /YM $      UCX042.B                       c  P  ;[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CHESS_SUBAGENT.EXE;1                                                                                                  S< "     F       2 MakeOIDFragFromDot, table lookup failed: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2   MakeOIDFragFromDot, oid_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2 MakeOIDFragFromDot, oid_ptr->oid_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2  MakeOIDFragFromDot, hex:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2    MakeOIDFragFromDot, octal:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2  MakeOIDFragFromDot, decimal:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2 MakeOIDFragFromDot, bad character: %d, %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2 MakeOIDFragFromDot, expected dot: %d %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2 MakeOIDFromDot, illegal OID value %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2  ParseSubIdHex, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2  %1x ParseSubIdHex, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2       ParseSubIdOctal, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2  %1o ParseSubIdOctal, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2 ParseSubIdDecimal, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2    %1d ParseSubIdDecimal, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2   MakeDotFromOID, bad (NULL) OID
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2 MakeDotFromOID, GetStringFromSubIds
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2 %d . .%d             CatOID: Too int: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2 CatOID, cannot malloc oid
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2 CatOID, cannot malloc oid_ptr
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;2 ܐ  @(#)$RCSfile: free_lib.c,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 1994/01/05 20:06:46 $        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated      8	  >	       0  
       Byrne-Fischer, US Championship 1963                                        x  Anderssen - Lange, Breslau 1859                                            X  Stienitz - Von Bardeleben, Hastings 1895                                     Daniele - LeBlanc, U.S. Postal 84VC110                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           1. d4           1...Nf6                       2. c4           2...g6                        3. g3           3...c6                        4. Bg2          4...d5                        5. cd           5...cd                        6. Nc3          6...Bg7                       7. e3           7...O-O                       8. Nge2         8...Nc6                       9. O-O          9...b6          	              10. b3          10...Ba6        
              11. Ba3         11...Re8                      12. Qd2         12...e5                       13. de          13...Ne5        
              14. fRd1?       14...Nd3!                     15. Qc2         15...Nxf2!                    16. Kxf2        16...Ng4+                     17. Kg1         17...Nxe3                     18. Qd2         18...Nxg2!                    19. Kxg2        19...d4!                      20. Nxd4        20...Bb7+                     21. Kf1         21...Qd7!                     resigns         0-1                           1. e4           1...e5                        2. Nf3          2...Nc6                       3. Bb5          3...Nd4                       4. Nxd4         4...exd4                      5. Bc4          5...Nf6                       6. e5           6...d5                        7. Bb3          7...Bg4                       8. f3           8...Ne4                       9. O-O          9...d3!         	              10. fxg4        10...Bc5+       
              11. Kh1         11...Ng3+!                    12. hxg3        12...Qg5!                     13. Rf5         13...h5!        
              14. gh          14...Qxf5                     15. g4          15...Rxh5+!!                  16. gxh5        16...Qe4!                     17. Qf3         17...Qh4+                     18. Qh3         18...Qe1+                     resigns         0-1                           1. e4           1...e5                        2. Nf3          2...Nc6                       3. Bc4          3...Bc5                       4. c3           4...Nf6                       5. d4           5...ed                        6. cd           6...Bb4+                      7. Nc3          7...d5                        8. ed           8...Nxd5                      9. O-O          9...Be6         	              10. Bg5         10...Be7        
              11. Bxd5        11...Bxd5                     12. Nxd5        12...Qxd5                     13. Bxe7        13...Nxe7       
              14. Re1         14...f6                       15. Qe2         15...Qd7                      16. aRc1        16...c6?                      17. d5!!        17...cd                       18. Nd4         18...Kf7                      19. Ne6         19...hRc8                     20. Qg4!        20...g6                       21. Ng5+        21...Ke8                      22. Rxe7+!      22...Kf8                      23. Rf7+        23...Kg8                      24. Rg7+!       24...Kh8                      25. Rxh7+       25...resigns                  1-0             1-0                           1. d4           1...d5                        2. c4           2...Nf6                       3. Nc3          3...c6                        4. Nf3          4...g6                        5. Bf4          5...Bg7                       6. h3           6...O-O                       7. e3           7...dc                        8. Bxc4         8...b5                        9. Bd3          9...Nd5         	              10. Nxd5        10...cd         
              11. O-O         11...b4?                      12. Qb3         12...Na6                      13. fRc1        13...Bb7        
              14. Bxa6        14...Bxa6                     15. Qxb4        15...e6                       16. Rc6         16...Bd3                      17. aRc1        17...a5                       18. Qb7         18...a4                       19. Bd6!        19...Re8                      20. Ne5         20..Bxe5                      21. de          21...Bf5                      22. Rc7!        22...Rb8                      23. Qc6         23...Rxb2                     24. Qxe8+!      24...Qxe8                     25. Rc8         25...Qxc8                     26. Rxc8+       26...Kg7                      27. Bf8+        27...resigns                  1-0             1-0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     < ^>RU;ŀ T0TP@bQTS0S\Lba@PT\0\Lb`STT_   О0b$´` 0 P  hdSSPP| ;RTSVS
NPŏT   SQAPP`4ѬALP`#AbUJPALP`PPPTPTSVSS
ѬUPVŏT   VP@bUUUPP< ^ЬTݬ]PSѬSѣHTJUyPBPSѣHTݬݬ+PSTSUQPѣHTݬݬ L~PU3cQ,   Rbѡ(Tbѡ(T
SQUaQUUP ЬQСP+РRbԱСPбСPԠ,aRaRסH                                                                                                                                                                                                                                                    6                        8 $      UCX042.B                       c  P  ;[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CHESS_SUBAGENT.EXE;1                                                                                                   "     W       ^Rݬ  PݬЬSSh   PdP  ݬ͂  PݬݬP  h  Pݢ)  P   h    ^mUЬRТPPV`SТTdW߭TS  PQbQխPRPPQPRnPԭ߭Tf  WPP  & : FP?PHTV.  PR-
TV  PRPeTV  PRPQRRP^TЬRТPPX`UТWgY߭WUS  PSbSPV1 P	PSԭЬRbݭPU
PV1 PĠ Ĉ L3ЬPРĠ Ĉ SURТLcТHТP
  PĈ ߭Wh  YPP P ( < ZP?PĈ WX  PV@Ĕ WX  PV,Ę WX  PVČ WX  PVQVVP^eTЬRТPPY`UТWgZWU  PSbSPX1PPSԭSԭ߭ЬRbݭݭPVPX1Q ЭPļ LĤ (EЬPР Ĥ RVSЭUХLУ(b  P  Pļ Ĥ Wi  ZPP , p  1 ^?PĤ WY}  PX1 P Ĭ I  PЭPĀ P`Ĭ WĨ WYx  PX_P Ĵ   PЭPĀ P`Ĵ Wİ WY4  PXPWY  PXPQXXP^=5TVЬRТSТWТ Xc[ШYШZhUШnbPP
( 1>?P[1U4   PU
1Z1UhieiωP [PP Y } 1rP?PP	1QP 
1BPe
12PRRR1.Pէ
ѧ@   	1PѨ
1P  P
1RRRRRRRը1  	1 P1 ЧPPt 8  1 P
?Pը1R	RR{P1[RRRRRRR 	GP>PP	1PRRRP
1
P1ЬR1 ШPP    1 F?PRR1 RRR1 RRRt nRŏT   RP@PQa@dS
RR
SS  Ԯ1iP
1`.PRRRR Ԯ1?P Ԯ1/1(Ԯ1!P1 B   PW.WS RТLcТHТPq{  PP
1ШPP    1 6?PRPŏT   RP@PQa@dS
RR
SS SR	1PeL RԢH  RԢ RPݥݥ Rz  ХP R@fԮ14RR"ݥݥ Rz  ХP R@RR
 RХPԮ1 P RPfԮ1 P1 1 ШPP   g X ]P2?P RԢPfGnRݢݢ R$z  nRТP R@ RnSУP RnSУPfԮ[U	Uo
  n	ny   R+ѢPbP`Q`ԠԠ,QP RԢP Ԯ
P y  ЮP^e3UfVЬRТSТXТ YcnЩWЩZiTЩbPP
' ;1?PTo 	  PT
[1PZ[1 ݧgP -g\P PR[1WHPP	[1FPTigЧdnPP R  *1P?PP	[1P [1d[1RRR1fPըѨ	[1Pѩ[1c  P
[1RRRRRRRթ1 	1P1 ըѨ	[1bPѩ[1S  P
[1<RRRRRRRթ1  	1 P1 ѨJѨxթ[1 [1 RѢ [1R	RR?PP	[1P [1RRRP
[1}PЬR1 ЩPP    1 ?PRR1 RRR1 RRR1 RRRv pRP0RP@,Qa@eSRR   SS  [1P
[1P.PRRRR [1P [1[1P[1P1 R   PX>XR S WЧLУ(bu  Pu  P
[1APЩPP  8(1-?PRP0RP@,Qa@eSRR   SS SR	[1Pݤݤ\u  ФP R@RR"ݤݤ R2u  ФP R@ S RТc֢HТH(,ТPS`SbSb[1nPRR"ݤݤ Rt  ФP R@RR"ݤݤ Rt  ФP R@[1P 3[1P[1 P1 ЩPP     1 B?P 1 RR*ЮRݢݢ R+t  ЮRТP R@RR*ЮRݢݢ Rs  ЮRТP R@[c S RТc֢HТH(,ТPS`SbSb[.PT	Tk  ծ
ݮs  | [ s  [P ^;s  1VP^VԮn[Ԯds  XTެZTj1 ެUeYr  WfDir  Pȏ   X^Pе R/Rr  PSRSPSSr  Rbgr  Rbg0r  Rbg~r  TTj X   pЮR֮R1I[1=  Z!  Y  XЬ5r  q  [r    N-  ~jPi(~P~hݾE  PWg~ xq  QP RRPQP{RPQPQSQP RRRPRQPQP{RPPQxQRRCx W '  PWW1 P( x|~< ~$PRR> k`1 <  ~jP" k`P`it~P<  ~hWNR@ծ 3~jPƬ i ~P~h PW PW
PԮ  PWW1;W*<  ~jPN i$~P<  ~h3P<  ~jPW`ip~P<  ~h,p  ЮR֮RW1<  ~  P"ƥy  ƴ<~P<  ~   ;  o  ծ	no  nP ^R~)  P!X  p<-~P~(     |o       ^Do  P\\P  ^ЬPՠ
ݠ^o  ݬTo  P  ^!o  P\\P  ^ЬP,ՠ
ݠo  ЬPՠ
ݠo  ݬo  ^/XVfRЬP`PhUЬTdPsR   jPdSS.UW1;PP>RBfU5Zn  Qˏ SP@aPP
BfP0SSPBfUPW1 PTdP	R   U	R   W1 PЬS1 RcURTxTTTT~m  PS*UTUSm  PT Sm  Dc4P< ~D  P"Ȓ 5  ȡ <~P< ~B  SRЬPR5< ~  P  ~P< ~  WPЬWWP ^拏TެWgQa?PЬUFVSa/  RCVGUl  LVUm  PUSSbЬPP| ^AUЬTդ
ݤl  ԤdЬSЬRcc~l  Pc9գ4< ~  P N
  ]<~P< ~  VGЬPРSRެTdPR  PBRRQެTQdЬRAbQQdЬVVP ЬQЬPРPPaT@SRTRЬQЃaRRTRTP ^5VլW1PЬRբ
ݢk  ԢbЬP	ՠ`螭ԽЭPԠЬRb螭вЭPԠЬP`РUx`SSS~k  PT*USUT
k  PS T3k  Cd4P< ~  P"ƒ   ơ <~P< ~  TRЬPR`ՠWPЬWWP  ^ЬPՠ
ݠj  ЬPԠ   ^SլԬЬRR~Qj  PT0լRݬTAj  PR Tgj  ЬP@d4P< ~  P"Ò   á <~P< ~  TPP ^ЬSSЬRR   PQbcQQPP QռC   SQ T3cPްRЬPްPAbA`TAbA`T
QQTTPP Լլ>ѬT1 PP%ެRbS@c   Td޼Q@ @aPTQPЬRRԬRQPRQQ+ЬSAcRR   	Լ޼PRA`ԬQЬTTP< ^ITЬЬQQQЬUQRRR~h  PS(URUSh  R Sh  Bc4P< ~  P"Ē   ġ <~P< ~
  SQЬPQ`ՠPPЬPP< ^ЬTդЬP	ՠ`UiUcPЬRբЬP	ՠ`UBPU;PdbbSPdSSݢݤg  PUdbUPdbUUP| ^UЬRբ
ݢg  ԢbЬP`РV`SSS~@g  PT'VSVT2g  
S T[g  Cd4P< ~  P"Œ   š <~P< ~  TRЬPR`ՠRPЬRRP  ^ЬPՠ
ݠf  ЬPԠ`| ^Sլլ:< ~*  P"    <~P< ~(  V1 PЬPѠ   RѬ
Ѭ   >< ~  P%ݬ0  T<~P< ~  V1 PЬRТTTT
߬ЬPݠݬ:  PU^PTެݢݬ:  PU9< ~@  P%ݢÉ.  ø<~P< ~;  UUVVP ^ݓRլլ:< ~  P"  <<~P< ~  T1PЬPՠ|ЬQСPPEaa% aaa  EaaE1D?PѼ:< ~f  P"DW  j<K~P< ~d  T1PݬЬPݠݬx9  PS1 PѼ   :< ~  P"   <S~P< ~  T1 PݬЬPݠݬ9  PS1 PЬP`	PP7< ~  P"  <[~P< ~  T>ݬЬPݠݬ8  PS"PݬЬPݠݬ8  PSPSSTTPP ^Rլլ:< ~  P"Q  p<~P< ~  SAPЬPՠ|ЬPѠݬЬPݠݬ8  PQPQQSSPP< ^mSլլ:< ~z  P"æk  <~P< ~x  U1>PլԬЬQСPP   (          1 P?PѬ:< ~  P"   ,<~P< ~  U1 PЬЬ쟭ЬPݠݬ7  PT1 ݬ?ЬPݠݬ6  PTRբ
ݢb  Ԣb[PЬЬ쟭ЬPݠݬ6  PT6< ~<  P"h-  Ð<~P< ~:  TTUUP ^ЬPF`Rբ
ݢa  ԢbЬQˏ   P ѡ
Rբ
ݢ`a  ԢbP ^SլP 8  P6< ~  P"                                                                                                                                                                                                                                                   7                        	 $      UCX042.B                       c  P  ;[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CHESS_SUBAGENT.EXE;1                                                                                                  jO "     h       w  <D~P< ~  T/ 5  PQЬPa`Rďd   RáPƏ'  PRPTTP LOCALHOST P μ^V(
ͼ @5   P	8  f   /ݬR`  PR	ЬRPRR]
  ~ ͽD`  ~ͽ_   _  PR>N  U1J2 ;	`  Rͽ\;_  ;Wͼ_  PRݲ_  Pb2N  U1 Ɣ ƌ a_  PRƘ 
N  U1 Pզ2 7_  P ƿ ._  PU1 ЬRЦbSզPSRBRbSST T_  W_  
PPd
Ww^  T	  PUfUUPP< ^)Rb8<  ~  P" 
  <h~P<  ~  U1լѬ<=<  ~  P%ݬB
  f<n~P<  ~  U1`PTSբvPSP@P`QTUSTPЬPݠݡ]  P;< ~_  P%ݼM
  <z~P< ~Z  U1 SSTuPP~ݢ(]  P:<  ~
  P"  <~P<  ~
  U1 PQPQPP@P`QQТTTSCPЬ`ТPCPЬ`ТPCPЬ` \  PQТPCPQ`ТPCP`bT   PUUUPP^3Td9<  ~%
  P"F  t<~P<  ~#
  X1ЬRRRP@P`P
ՠPQQQU	X1 P~	  P&eݬĬ  <~P~	  S S
\  ݥ\  WgPRegPQRQRRRcPPQФPAP`
ФPAP`VݥV,[  VgPPVeV[  Sn  PXXPP ^ӎSWЬUWV~  P%Ve
  ,<7~P~  ХTRգ1RP@P`PՠTݠZ  PRPRRPPQQT
QP@RbTTV{cvT TZ  ЬUݥZ  PRRRd<<RRR<<RPP  <<Wݥ	Y  T>  PVVRRP ^淚S~  P'ݬݼ	  ,<7~P~  ЬPРTRգ3PRP@P`PՠTݠY  PRPRRPPQQT
QP@RbTTPP ^SR RxY  b<<\\\<<\\\  <<R,  PT5<  ~  P"b  Ì<l~P<  ~  TT\\PP< ^WS~O  P$ݬ=  <~P~K  Rb<<PPP<<PPP  <<ЬЬTլݬTW  PdTUX  <bQPQPPbTAX  PPT<bPP   ~TݬR0  PU[cR*  PTDR  PT5<  ~R  P"C  :<~P<  ~P  TTUUPP ^SգT{R RW  b<<\\\<<\\\  <<	R6  ݣV  ݣV  ԣcTTPP ^yRSբ5SP@P`PՠݬݠV  PSPPSSP  0\ЬPP  QЬPPP@P`P
ՠPRRRPP   < ^ۉR U  PUUI<  ~  P4 U  `V  P  <`~P<  ~  U1 ~U  U  PSRD  UU  U1 ݳtU  prT~  P&<r~	  <z~P~  TpUU  PT<  ~  P9 T  `3U  P<r~L  r<~~P<  ~  UT  UUPP ^qVЬWRR((	P(蚏~K  PE~  <~~~~~P<g~ƨ  <~P~&   <g~ݬݦT  PG~  P3 S  `@T  P   <~P~  RRRPP< ^RЬU߭( < ~ݬݢS  PT]CS  S c`#H c`@< ~B  P0 c`S  PV%  n<~P< ~2  S1 <ePPT<< ~   P'T<e~¨  <~P< ~   SV~   PE~  PQ<*~/~.~-~,~Q  .<
~P~   SSP   ^]~ݬR  PRЬRPRRWR  P  QЬȏ    ȏ 0  Ьd    \QRլ
ҡdPPPRRPP ^3R]~ݬ4R  PSSPЬSѬ   &Ѭ    8ݬݬSbdQ  /ݬݬSb~Q  ݬQ  dЬP` d1`1 	b)  d~VQ  Ph CQ  P¤ݢh;Q  ´ݢhP  PS 	Q  PP  Pb¶SQ  SP  ݢhb!)  `d+ ݢhP  PSSP  SdP  ;P  P@PP
P  P@(  ˏdPP   ^YRެPP~ݬO  QQP 0RQ~AP`'P~AP`~AP`SQ~AP`ܞP	SSPP QЬP@pRRPP| ^͊Td19SPSҤdRRSRPPzЬSĈ	VĐ	VˏSĔ	USĘ	SĠ	SSUЬRbUVТRBpĀ	ݬݬc	İ	<~P~ЬUѥMSPSҤdRRSRPP1WЬRݢݢ	
<~P~1)ѥ1 SPSҤdRRSRPPjЬSУQR~BSc$~BP`Q
~BP`SPR~BP`ܞP	SSЬRݢݢH
l
<~P~
ЬRբ(1 SPSҤdRRSRPPsЬRݢ(ĸ
ݬݬĤ
Ĺ
<~P~?PSPSҤdRRSRPP!
b
<~P~pЬRТ$ScRSSR	   ТRP ^{Rd1LЬP1C`H$QdQQD/H:ݬݬ%;<~P~ЬPՠ<QdQQ<+vݬݬpw<~P~ЬQա1[СPP RS/SSSwSGG	?PP   1P   $ d   $1?PQdQQ41ЬPݠ¬½<~P~PQdQQ,1ЬPݠ<~P~PQdQQ$1ЬPݠ8NG<~P~\PQdQQ1^ЬPݠ|<~P~PQdQQ1ЬPݠ<~P~PQdQQ1ЬPݠ	

<~P~PQdQQ!O
X^
<~P~f~ЬPo  PQdQQ!
 
<"~P~~ЬP'  PQSQҢdPPQPSS1ЬQСPя   PTPTP   
S
SSݡT

<&~P~PQSQҢdPPQPSS!1?@<+~P~M~ЬPV  QSQҢdPPQPSS!v</~P~~ЬP  QSQҢdPPQPSS!µ<3~P~~ЬP  QSQҢdPPQPSS1ЬPHeP,<7~P~:QSQҢdPPQPSS11>X<:~P~QSQҢdPPQPSS1 ¬<=~P~QSQҢdPPQPSS1 `<@~P~nQSQҢdPPQPSSh1<<D~P~-QSQҢdPPQPSS(ЬPݠq<K~P~x^SЬV@TUTңdRRTRUU12<^~P~fxF  fJTUTңdRRTRUU%x,<c~P~:xUYxF  xRRPUYTެZT 1 XW  VT1 z  TP{PQPP1 eYFPQPңdRRPRQQcxNݬݬEhP<p~P~g:PPQPңdRRPRQQxÈhÌ<r~P~gYxUPTz  TP{PQPP D~UYE  UE  PUTTf1eYMTVTңdRRTRVVrxݬݬ<~P~PTUTңdRRTRUU%xr<~P~P  ^ݬݬ"  ^SPR"  PRR|PRR0\Ѭ%< ~\  PRPPR*  R/< ~P H~P< ~R\\P^)U~qP~cŒ ~P~rЬRRejѢdѢ
^ХRbRТPРP`Т(RХS"C  TSRУ(Sݢ dRdSԥݥ+  ԥeԥЬRТPP,   ,X 1V?PЬRRPX~{P! l <~P~zݬ1PЬRRPX~'P!(<
~P~&ݬ13PЬS|S`PXeuXգS
CPXХRPbRТPРP`Т(RХS"1B  TSRУ(Sݢ dRdSԥݥ)  ԥeԥЬR~MP!`>t<!~P~Lݬ1YЬR|R
ψPX~P!Ŭ<,~P~ݬQ1PЬR|R0PXХRPbRТPРP`Т(RХS"A  TSRУ(Sݢ dRdSԥݥ(  ԥeԥЬR~9P!*<9~P~8ݬ1EХRPbRТPРP`Т(RХS"u@  TSRУ(Sݢ dRdSԥݥ'  ԥeԥЬRԢX1~PO޼Sc  pTcrS|SSTTݼHPŊ<E~P~^ЬVԦfT1oզ(9
߭ݦ(?  PЭScRR,
 SS>  PԥЬRѢm   G<  ~P.ݢP<[~P<  ~W1PբG<  ~P.ݢ                                                                                                                                                                                                                                                   8                         $      UCX042.B                       c  P  ;[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CHESS_SUBAGENT.EXE;1                                                                                                  [ "     y       Pl"<_~P<  ~yW1PKե;PХPPRRRW1_ХPPR`R>  եԥS SP17PSPRRRW1S SP1PT  1 TTyPTզe<  ~P>TdSŀSݦPSXfň<}~P<  ~sЬRݢTW1|~-PqTdSSS<~P~>Pզ7~P!(P<~P~W1 X1 P~P(ЬRݢņŰ<~P~ЬRԢX1 ~aP!R<~P~`ЬRݢ(PPSݢS`PXPXЬRԢA< ~P)ЬRݢ4T<~P< ~WPXWWP^WRЬP|` YР$U13V[yWX  ZPe0UPS~fP1 ~fP$eHkPg¤<~P~hS4~fPMHkPcg<~P~h$~fP0gJ<~P~hS8ЬPPSQ<PPʏPˏPP
PPPPգ0~fPg<~P~h ej1 S4УP`PT~fP$TYPg<~P~hTjTPP 7 c c c c S 	?PPP   CPP     5?P^P ejQ ejEЬPY6P<  ~fPT$gP<~P<  ~hЬPYЬPՠ
ХUYU1SSP^SެоR|b |(ԮТ$W[Т$V1оnZ9Y"X nRѢоTR[R
ԮЦWФ,~jP'fHP[Æiâ<V~P~hVPU6~jPi<^~P~h f
  1*P~jP*fHݶPe,iV<d~P~hե1оPRUQ<RPʏPˏPP
RRR-T~jP1CÌiä<m~P~h1'Ѧ).~jP7i<s~P~hPоPѠ
PU4f0ХP`PR~jP$RwP	i<	<~~P~hR1 RPP 6      ?PPP   wPP   W W i?P!fLP0)~jP1 r	iÐ	<~P~hkP)bP^PЬP[T1
P<  ~P$R	o	<~P<  ~|ЬP[T1 PR1֮1оRѢ1 զ1 (1 ծ{~jP*
i^
<~P~h (VR   P;ТRЧЧЧ))!!gbWVЧWPЧWЦV[V1TTP|^VЬPP tttttt1_
?Pզզ^ЦScSУRТP`У(SЦT"5  WTSФ(Tݣ gSgTԦݦ  ԦfԦЬRТ$Ԣ$~P!Ɣ
Ʈ
<~P~Ц[14  nެ4  ZkYզ@,PS)< ~P<S~P< ~ SSUH,PS)< ~P<S~P< ~ S(SRU$Х(UU1< ~P

<#~P< ~ оR
ЮRв Y[PT~P1 TJ~Pqi͘PRHPRd*\<1~P~ 6P~P'i͘PƘ<7~P~ TA~P!<B~P~ЬRЮ1դC~P!Nv<H~P~ЬRЮ1yPѤQѤ	KѩE~RP$ݤƬ@<Q~P~NЬRЮ1 PTäiWA~P!
.
<[~P~ЬRЮ1 ФSCXЦR?բ 3ТQХPѡ$Т QѡWxW~XݡjP
Т  	PТ(RRp1  P ?< ~_P"d
Pƀ
<q~P< ~]ЬR
5PХ RXХ RWХ RԢԵ ȏ   U ֮Ы[1ЬRբe~P$ݢƶ

<~P~ЦT#R1  UTSФ(Tݣ eSeTԦW1TЦSPճ г Rȏ@   Գ TУ(S䚏~YP!"J<<~P~XUЦS12ЬcSУRТP`PT1 TPP T      p  |   d      X  ?PPP   1 PP      zPr?P1 ЬR1 ЬR1 ЬR1 ЬRzPЬR
nPЬRbPЬR
VPЬRJPЬR>P<  ~8P$Tt'Ơ<~P<  ~4ЬRTH~P,TP<~P~ЬRUW1UУ(S11P~P!4H<~P~UЦT1 1 ЬdTФRТP`P1 ~EP!ƀ6ư<~P~DЬRUЦSSTnPPcSФPРP`P<~P!<~P~ЬPUУ(SSTUФ(T1-1 P~P!Jz\<~P~ѦhTЦS_QЬcSУRТP`P<~/P!ƒ <~P~.ЬRTTУ(SWWP< ^zSЬT<dPP~"-  PRU&<d~T-  bУPR`RRUUPP^ЬP`YԠ JPTST?SGPR)YPЬPРPѢЬPRSSTЬRբXjТSUУTUTJUTVVVP@RYPWЬPVRX+PWVT
PWVUUTWVЬRVXXPP< ^ЬQС)PP  S S s  wPV?PЬRRPS\PPѣb)SU1 ЬR)SU1 P2PЬPРQRޱSBcR)RUyPЬP֠PUgЬPРQѠЬR)UJPЬSУPRްPB`T!VP
)UPЬRbh)TUUP  dx\QQPP ^MxTѬ1ЬPP  C g	"?PP   1P   $ 8 L ` t 1?PЬRм1PЬRм1PЬRм1PЬRм1kPЬRм1WPЬR
м1DЬRsPS1+1!ЬROPS11 ЬR+PS1 	1 ЬRPS1 1 ЬRPS1 1 ЬRPSxP
nPЬRkPSTPJPЬRЬ=< ~P%ݬ<V<~P< ~SPSSP        (^RЬS}b蟭Xx蟭'  ߭߭؟ߢ'  ݭ(  Pc
~'  PQQPP (^S}pc䟭蟭Xx蟭'  ߭߭ܟߣt'  ݭ'  ЬRPb
~'  PQQP    ^RެSЬP@b^'  Sݬ>'  G'     ^Sլ3<  ~Pc
(~P<  ~THЬRbЬQaССԢ<bPP~ݡ$R   PTTP^լY1 UЬTVլ1 ެXUW2UPPh$ЬPQQ1 Q1 V1 UЬRbTiT&  PSSTSUUUh~TR~PS%ЬPPPYcPЬPVCPSWUЬPQQ(Q#VSUSTЬPРVլ1/ЬR<bPUPPbYYP| ^SUѬ8< ~|P hnr<~P< ~|V1PЬQաЬP֬`Uѡ1СPP5q55555qqqP?PP   1PP   $ HHHH$ $ $ HHH$ 1-?PЬP֬`ЬP֬`UURR8< ~P"è ò <2~P< ~V1ЬR֬ЬQPʏ PPbЬR֬<Pʏ PPbЬR֬Pʏ PPbЬR֬ˏ PPbU1PЬP֬`ЬP֬`UURR8< ~P"  <D~P< ~V1WЬR֬ЬQ8Pʏ PPbЬR֬0Pʏ PPbЬR֬(Pʏ PPbЬR֬  Pʏ PPbЬR֬Pʏ PPbЬR֬<Pʏ PPbЬR֬Pʏ PPbЬR֬ˏ PPbU1PЬPРTЬR֬xTPʏ PPbЬR֬ˏ TPPbUTURR;< ~P"(2<_~P< ~V1"PTЬPݠݬ"  TTU1 PЬPRURR:< ~:P"h+r<i~P< ~8V1 PЬPRR#R"  PQЬR֬xQPʏ PPbЬR֬ˏ QPPbQQQUZPЬP֬`ЬP֬`UA< ~P)ЬPݠèz<~P< ~VPUVVP ^=VԼYլ6<  ~2Pf%(~P<  ~4X1P,a!  PR2< ~P"<~P< ~RU	X1PЬRPP;<  ~P$~`ƀ ~P<  ~X18<eХPP7 7 7 ]-]]- ]]]1:P?PТТT<bSìTPPSSWբ1 <WPѢP;<  ~P$ݢƸ  ~P<  ~X1ݢ   P 8< ~P!8~P< ~X1@ݢ~ݥ   T<WP¢PPW<W~TUPY1 P1 	SSN  P(gТТT<bSìTPPSSP<PPFT  P(7<  ~P$ݥpƐ~P<  ~YY}US|գ 
ݣ I  У$THФR&ݢ  b~!8R  db!T  գ(
ݣ(  S  UYXXP^Uլ;< ~P"<~P< ~W1ZP[XѬ[1DqZ^  YVS-  PR2< ~P"P`<~P< ~RVW1ЬPՠ$V$VXЬP֬`ݬfjP1 < ~<P%ݬ *P<8~P< ~7VTjФSHУR&ݢ(  b!R|  cǻ!S`  d﫻!eTD  W1
PݬiPPݬ!jP1 <                                                                                                                                                                                                                                                    9                        Z~ $      UCX042.B                       c  P  ;[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CHESS_SUBAGENT.EXE;1                                                                                                  V              ~tP%ݬňbŸ<B~P< ~oVTjФSHУR&ݢ`  b!ձR  c!ﹱS  d!T|  WFPݬiPPЬPѠ"[ݬf'PЬP	XPѬ[1WWP< ^uSRR9< ~iP"Z<j~P< ~gU1bPЬP֬ЬR`ЬP֬`PxPTЬP֬`PPTTRR9< ~P"Px<t~P< ~U1PЬQѡ1СPP;c;;;; ;	:?PP   1`P   $ XXXX$ $ $ XXX$ 1=?PЬP֬ЬR`PxPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PP1,ЬP֬ЬR`Px8PЬP֬`Px0PPPЬP֬`Px(PPPЬP֬`Px PPPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PP1 ЬRTTݬDPU1 TvPЬRRЬPPU\R  PRPFPBP< ~P)ЬPݠð<~P< ~UPЬUUP ^ЬP1 ՠ 
ݠ [  ЬPР$TjФSHУR&ݢ   b!@R  cj!$S  dN!T  ЬRբ(
ݢ(  ݬ   ^|R-u  PS2< ~ P"P`<~P< ~S\\PP ^ЬP1 РTjФSHУR&ݢb!KR*  cu!/S  dY!T  ЬRb9!R     ^ݬ  PЬݬ  PЬ쟭蟭  PQQP ^ݬe  PSPP  PRݬR  RPP ^ |R߭߬߭߭[  PRRPP  ^~R´ q  ЬЬ   ^~SUVެYiRU1 ЬX-  WЩ Tz  UP{XPQPPiRѢ gE ~ gѤiRz  P{PQPP?z  VP{PQPP gz  VP{PQPP gz  VP{PQPP gz  VP{XPQPPVVUU1_   z   ^W}SЬP	V1 Pݠ  2PPP1  ~  <U T'  P~  P@PP
=PPgP,]~T3  PRRPTRRU0V1WP,  ЬP2
QQ1QPPZ Z~ 
P?PP@   1lP@   H    01WP?PЬPݠ4.  1PЬPݠ8  1PЬPаQ~~~a~<  1PЬPݠ&  2PPP1 L~  <*UxT'!  P  P@PP
=PPgP,]~T  PRRPTRRUV1 Pì-  1 PЬRݢ   P1 ݢ1 ð  1 PЬP2
~ö~  <SUT'F  P7  P@PP
>PPgP-]~T  PRRPTRRUVЬPݠPVVPP^zURެTdSRd{  X  WBgPʏ P@hPʏhPд PB`PP 
P
P
dQB PPRP	V1 PRdPRSެRbPSdPв PC`PP 
( 8 8 8 8 8 8 8 8 8 ( 8 8 ( P?P}  V,в PC`~e  SbPSO  VVP ^yRЬS]~ݬ  PQQSS   "  < ^yRެSSSP`TTSSP`UUp	 IpT
TPPP SUx  xP ^yR'  P  P@PP
EPPP0]~ݬ  PSSPЬSSݬ ^xR   2PP ! 1 A Q UZ?P@  ݬX  ݬ~  ݬ   ݬº  ݬ   ^{UЬXhR RRa   1Rz   1 .X1  PW
X  XPWXTW*T   !RbDTW	T   ߔDT~DŰ RbVl  VP~DŰ Sc1  P)fPRcfRP~DŴ Rb  T~DŰ P`~DŰ Rb*
C~k7C<V~V1PW;  XW  WRBPPBPP.WRBPX  PT'lC~ŐC<~`V1PWRxR~  P/C~C<~$T
  V1PWdSWRSR1PP`RR01 PPx   	PX   NC  P1$D~,>D<~T	  V1CP1 C  P1 tD~ŐD<~JTA	  V1 1 R0OR9JC  PjD~D<~T  V1 :PPP`~E~O@E<~T  VgPP`QQ.P?PQ8PP`~sE~ŜE<~gT^  VPSWPSP1RTVVPP ^5xSݬ:PRT<Ѳ2ݲE~E<~R  TPRTTP| ^wSެTִ ִ ԼVд RbRR.1 R1 P  Rд P`Pʏ P@bPP'ݼ*F~HF<~mUp߭|Fݴ 
  P&ÀF~ßF<%~3U6PЬRxbQˏPQPbִ VVд P`PP.P1NUUP| ^vTԼVެSг RbRR.1 R1 г P`PP0г P`PP7(ݼF~"F<A~Uz߭,Gݳ 	  P&0G~QG<K~SU?PЬRxbQˏPQPbֳ 2VPPPV2VPPг P`PP.P1IUUPP| ^uTԼVެSг RbRR.1 R1 г P`PP0г P`PP9(ݼĄG~6ĦG<h~Uz߭Gݳ   P&G~H<r~gU?PЬR
bQˏPQPbֳ 2VPPPV2VPPг P`PP.P1IUUPP ^uRЬP	`ՠ&8H~sXH<~SHPЬQ2a~ݡݬ8   2PPP$H~-°H<~SSSPP^tXRެWRgQ U  T  SBeH+  RPPTݬcHݬc
ݬcRRTZYV~FȰ Rb1    W~Fȴ RbTgSUPRPRP2UPPPUQPQP2URN~Fȴ S޳ SBcPP.PB PP.-P)R%~Fȴ Pް PB`PP.PB PP.PRY~Fȴ Sc  RPVZRYV~FȰ Rb1PZy~JȰ Rbݬ  US~Jȴ R޲ RCbR~Jȴ VЦ TCdPP.USCdPURެVRf)ЬTBdH  ݬZ  RRf۰SSP RЬQ֬ЬP֬aQ`PQP$P2RPPPRЬQ֬ЬP֬aQ`PQP߰RPPެXެWѸ  и Sз SSЬSPTPS&T"hVЦRgU   Q@a@bTPPSTTѼѼüTTPP^
rWZZ   )ZH~p
I<7~Y1 P  PU&@I< ~:[I<<~Y1 xZ~i  P/ǎI< ~ǭI<B~oU  YZPTVެXT   RVQVTPT@ATbSެTS   RVQVSPS@ASbZeUYYPެXެWѸ  и Vз VQV5hZЪUgYЩTAeAdЬPްRЬPްPA`AbS
QQVSSPPެXެWѸ  и Vз VQV5hZЪTgYЩSAdAcЬPްRЬPްPA`AbU+QQV޼S޼RcbUPcbUPUUP    ^ЬP`	`0  ݬ&    ^ЬPՠ
ݠ
  ݬ   P ^ЬP1 РRբ
ݢ  R  ЬR2
RR1 RPP] } 9 	b?PP@   cP@   ; [ [ [ ; OP:?PЬRТS:գ
ݣg  S^   ЬRТSc	cE  S<  ݬ2   ^ЬP1 `Rb	b  R  ЬP2RR   >Р
Rբ
ݢ  R  ЬRТSc	c  S  ЬRТT1ФS"УRݢ(   RSTݬs  P ^ЬPAРT1ФS"УRݢRDS;T2ݬ(                                                                                                                                                                                                                                                                               @   @       (  4                                               
  H        8   .      (        `          8  H  P    H	  X	  	  	  	   
  h  	  
  `    H        ,                  (  X  	  (          0     8              
                 @                                                                       UCX$IPC_SHR                                                    MTHRTL                                                         LIBRTL                                                         CMA$TIS_SHR                                                    UCX$ACCESS_SHR                                                 DECC$SHR                                                                                                                                                                                                                                                                                                                        4 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CLEANUP.COM;1 +  , b	   .      / #   4 n        b                    - P    0   1    2   3      K  P   W   O !    5   6 ۯt  7 u؛  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                :                        H( $      UCX042.B                       b	  P  4[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CLEANUP.COM;1                                                                           n                                "            $ ! UCX$CLEANUP.COM V4.0-02
$ !
$ !  Copyright (c) Digital Equipment Corporation, 1994, 1996
$ !  All Rights Reserved.  Unpublished rights reserved
$ !  under the copyright laws of the United States.
$ !  
$ !  The software contained on this media is proprietary
$ !  to and embodies the confidential technology of 
$ !  Digital Equipment Corporation.  Possession, use,
$ !  duplication or dissemination of the software and
$ !  media is authorized only pursuant to a valid written
$ !  license from Digital Equipment Corporation.
$ !
$ !  RESTRICTED RIGHTS LEGEND   Use, duplication, or 
$ !  disclosure by the U.S. Government is subject to
$ !  restrictions as set forth in Subparagraph (c)(1)(ii)
$ !  of DFARS 252.227-7013, or in FAR 52.227-19, as
$ !  applicable.
$ !	Deletes all UCX$ objects from a VMS system.
$ !	Use this procedure to prepare a system
$ !	for installation of the UCX product.
$ !***********************************************************************
$ !
$ !	Beware User !. 
$ !
$ ucx$l_verify_state = f$verify( 0 )
$ set control=y
$ !
$ @sys$manager:ucx$symbols
$ !
$ TYPE SYS$INPUT
$ DECK

                                UCX$CLEANUP.COM

         This routine removes the entire DIGITAL TCP/IP Services for
         OpenVMS (formerly UCX) product from the system or cluster. 

         Not only will it delete Version 4.x files, but it will also
	 delete most files from previous versions of the product as well.

	 It will NOT leave your system capable of running the previous
	 version of the product.  After the execution of this procedure,
	 it will be necessary to reinstall the DIGITAL TCP/IP Services
	 for OpenVMS from the distribution kit.
	
$ EOD
$ !
$ ucx$t_question = "Do you REALLY want to delete UCX on ''f$getsyi( "NODENAME" )'"
$ @'ucx$gt_callback ask_binary "''ucx$t_question'" N ucx$gl_result
$ if .not. ucx$gl_result then $ exit
$ !
$ call ucx$ask_shutdown
$ !
$ if f$trnlnm("sysuaf") .eqs. ""
$ then
$	define/process sysuaf sys$system:sysuaf.dat
$ endif
$ !
$ ! Get root directory name for this node
$ !
$ ucx$t_root = f$trnlnm( "SYS$SYSROOT" )
$ ucx$t_root = f$element( 1, "[", ucx$t_root )
$ ucx$t_root = f$element( 0, ".", ucx$t_root )
$ ucx$t_message = f$fao( "%UCX-I-ROOTDIR, root directory name is !AS", ucx$t_root )
$ ucx$gt_say ucx$t_message
$ !
$ ! Exclude the following files from being deleted
$ !
$ ucx$t_excludes_cleanup = "ucx$callbacks.com, ucx$cleanup.com, ucx$symbols.com"
$ ucx$t_excludes_general = "*.dat,ucx$nfs_set_fs.com,ucx$cfs_services.exe,ucx$vipcp.exe,ucx$vipcp_startup.com"
$ !
$ ! Construct DELETE command
$ !
$ ucx$t_confirm = "" !"/CONFIRM"
$ ucx$t_excludes = "/exclude=(" + ucx$t_excludes_cleanup + "," + ucx$t_excludes_general + ")"
$ ucx$t_log = "/LOG"
$ !
$ ! Exclude the following logical names from being deleted
$ !
$ ucx$t_lnm_excludes = ""
$ !
$ delete = "delete"
$ delete_2 = "delete" + ucx$t_confirm + ucx$t_excludes + ucx$t_log
$ uaf := "$authorize"
$ !
$ ! Ignore all error conditions
$ !
$ set noon
$ !
$ @'ucx$gt_callback ask_binary "Do you want to cleanup everything" Y -
	ucx$gl_everything
$ ucx$gl_result == UCX$GL_TRUE
$ !
$ if ucx$gl_everything
$	then
$	TYPE SYS$INPUT
$	DECK

                                UCX$CLEANUP.COM

  WARNING: This option will remove the entire DIGITAL TCP/IP Services for
	   OpenVMS (formerly UCX) product from the system or cluster.

	   This includes:
	       o All SMTP mail files, including undelivered mail
	       o All DIGITAL TCP/IP Services for OpenVMS logical names
	       o All DIGITAL TCP/IP Services for OpenVMS service accounts
	       o All DIGITAL TCP/IP Services for OpenVMS Rights List Identifiers
	       o All DIGITAL TCP/IP Services for OpenVMS service account files
	             and directories
	       o All DIGITAL TCP/IP Services for OpenVMS system images and
	             libraries 

	   No further questions will be asked, and your system will NOT be 
	   capable of running the previous version of the product.  

           It will be necessary to reinstall the DIGITAL TCP/IP Services for
	   OpenVMS from the distribution kit after the execution of this
	   procedure.
	
$	EOD
$	@'ucx$gt_callback ask_binary "Do you wish to continue" Y ucx$gl_result
$	if .not. ucx$gl_result then exit
$	endif
$ !
$ ! Delete logical names
$ !
$ if .not. ucx$gl_everything
$	then
$	@'ucx$gt_callback ask_binary "Delete UCX logical names" Y ucx$gl_result
$	endif
$ !
$ if ucx$gl_result
$	then
$	@'ucx$gt_callback delete_logicals ucx$* -
		'ucx$gl_true "SYSTEM" "*" 'ucx$t_lnm_excludes
$	endif
$ !
$ ! Delete the account records from SYSUAF
$ !
$ if .not. ucx$gl_everything
$	then
$	@'ucx$gt_callback ask_binary "Remove account records" Y ucx$gl_result
$	endif
$ !
$ if ucx$gl_result
$	then
$	uaf remove ucx$bootp
$	uaf remove ucx$ftp
$	uaf remove ucx_lpd
$	uaf remove ucx$nfs
$	uaf remove ucx$rexec
$	uaf remove ucx$rsh
$	uaf remove ucx_smtp
$	uaf remove ucx$snmp
$	uaf remove ucx$tftp
$	uaf remove ucx$bind
$	uaf remove ucx$portm
$	uaf remove ucx$pcnfs
$	uaf remove ucx$nobody
$	uaf remove anonymous
$	uaf remove ucx$ntp
$	uaf remove ucx$metric
$	uaf remove ucx$finger
$	uaf remove ucx$pop
$	endif
$ !                                    
$ ! Delete the Rights Identifiers from the rights database.
$ !
$ if .not. ucx$gl_everything
$	then
$	@'ucx$gt_callback ask_binary "Remove rights identifiers" Y ucx$gl_result
$	endif
$ !
$ if ucx$gl_result
$	then
$	uaf remove/identifier ucx$snmp
$	uaf remove/identifier ucx$smtp
$	uaf remove/identifier ucx_smtp
$	uaf remove/identifier ucx_lpd
$	uaf remove/identifier ucx$rsh
$	uaf remove/identifier ucx$rexe
$	uaf remove/identifier ucx$rexec
$	uaf remove/identifier ucx$ftp
$	uaf remove/identifier ucx$aux
$	uaf remove/identifier ucx$nfs
$	uaf remove/identifier ucx$nfs_remote
$	uaf remove/identifier ucx$bind
$	uaf remove/identifier ucx$portm
$	uaf remove/identifier ucx$pcnfs
$	uaf remove/identifier ucx$nobody
$	uaf remove/identifier anonymous
$	uaf remove/identifier ucx$ntp
$	uaf remove/identifier ucx$metric
$	uaf remove/identifier ucx$finger
$	uaf remove/identifier ucx$pop
$	endif
$ !
$ ! Delete files in the UCX$ directories
$ !
$ if .not. ucx$gl_everything
$	then
$	@'ucx$gt_callback ask_binary "Delete files in services directories" Y ucx$gl_result
$	endif
$ !
$ if ucx$gl_result
$	then
$	delete_2 sys$sysdevice:[ucx$ftp]*.*;*
$	delete_2 sys$sysdevice:[ucx$rsh]*.*;*
$	delete_2 sys$sysdevice:[ucx$rexec]*.*;*
$	delete_2 sys$sysdevice:[ucx$snmp]*.*;*
$	delete_2 sys$sysdevice:[ucx$smtp]*.*;*
$	delete_2 sys$sysdevice:[ucx_smtp]*.*;*
$	delete_2 sys$specific:[ucx$smtp]*.*;*
$	delete_2 sys$specific:[ucx_smtp]*.*;*
$!	delete sys$specific:[ucx_lpd...]*.*;* ! Do not do this, user files down
$!                                            ! there
$	delete_2 sys$specific:[ucx_lpd]*.*;*  ! won't do subdirectories, OK
$	delete_2 sys$sysdevice:[ucx$nfs]*.*;*
$	delete_2 sys$sysdevice:[ucx$bootp]*.*;*
$	delete_2 sys$sysdevice:[ucx$tftp]*.*;*
$!	delete_2 sys$sysdevice:[ucx$bind]*.*;* ! don't do this, it's in
$!                                             ! in sys$specific, anyways
$	delete_2 sys$sysdevice:[ucx$portm]*.*;*
$	delete_2 sys$sysdevice:[ucx$pcnfs]*.*;*
$	delete_2 sys$sysdevice:[ucx$nobody]*.*;*
$	delete_2 sys$specific:[ucx$ntp]*.*;*
$	delete_2 sys$specific:[ucx$metric]*.*;*
$	delete_2 sys$sysdevice:[ucx$finger]*.*;*
$	delete_2 sys$sysdevice:[ucx$pop]*.*;*
$	endif
$ !
$ ! Delete the directory files
$ !
$ if .not. ucx$gl_everything
$	then
$	@'ucx$gt_callback ask_binary "Delete service directories" Y ucx$gl_result
$	endif
$ !
$ if ucx$gl_result
$	then
$	delete_2 sys$sysdevice:[000000]ucx$ftp.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$rsh.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$rexec.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$snmp.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$smtp.dir;1
$	delete_2 sys$sysdevice:[000000]ucx_smtp.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$nfs.dir;1
$	delete_2 sys$specific:[000000]ucx$smtp.dir;1
$	delete_2 sys$specific:[000000]ucx_smtp.dir;1
$	delete_2 sys$specific:[000000]ucx_lpd.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$bootp.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$tftp.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$bind.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$portm.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$pcnfs.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$nobody.dir;1
$	delete_2 sys$specific:[000000]ucx$ntp.dir;1
$	delete_2 sys$specific:[000000]ucx$metric.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$finger.dir;1
$	delete_2 sys$sysdevice:[000000]ucx$pop.dir;1
$	endif
$ !
$ ! De-install all known UCX images 
$ !
$ if .not. ucx$gl_everything
$	then
$	@'ucx$gt_callback ask_binary "De-install known images" Y ucx$gl_result
$	endif
$ !
$ if ucx$gl_res                                                                                                                                                                                                                                                   ;                          $      UCX042.B                       b	  P  4[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CLEANUP.COM;1                                                                           n                               c             ult
$	then
$	install delete sys$system:ucx$ftp.exe
$	install delete sys$system:ucx$ftpc.exe
$	install delete sys$system:ucx$ftpd.exe
$	install delete sys$system:ucx$rlogin.exe
$	install delete sys$system:ucx$rsh.exe
$	install delete sys$system:ucx$rcp.exe
$	install delete sys$system:ucx$snmp_agent.exe
$	install delete sys$system:ucx$telnet.exe
$	install delete sys$system:ucx$ucp.exe
$	install delete sys$library:ucx$access_shr.exe
$	install delete sys$library:ucx$cfs_shr.exe
$	install delete sys$library:ucx$smtp_mailshr.exe
$	install delete sys$library:ucx$lpd_shr.exe
$	install delete sys$message:ucx$msg.exe
$	install delete sys$share:ucx$ipc_shr.exe
$	install delete sys$share:ucx$rpcxdr_shr.exe
$	install delete sys$system:ucx$lpq.exe
$	install delete sys$system:ucx$lprm.exe
$	install delete sys$system:ucx$bootp.exe
$	install delete sys$system:ucx$tftp.exe
$	install delete sys$system:ucx$bind_server.exe
$	install delete sys$system:ucx$bind_server_xfer.exe
$	install delete sys$system:ucx$portmapper.exe
$	install delete sys$system:ucx$server_nfs.exe
$	install delete sys$system:ucx$pcnfsd.exe
$	endif
$ !
$ ! delete anonymous directory and files
$ !
$ @'ucx$gt_callback ask_binary "Delete anonymous directory and files" Y ucx$gl_result
$ if ucx$gl_result
$	then
$	delete sys$sysdevice:[anonymous]*.*;*
$	delete sys$sysdevice:[000000]anonymous.dir;1
$	endif
$ !
$ ! Delete UCX library directory hierarchy
$ !
$ if f$search("SYS$SYSROOT:[000000]UCX$LIB.DIR;1") .NES. ""
$ then
$    @'ucx$gt_callback ask_binary "Delete UCX$LIBRARY directories and files" Y ucx$gl_result
$    if ucx$gl_result
$    then
$	delete sys$sysroot:[UCX$LIB.RPC]*.*;*
$	delete sys$sysroot:[UCX$LIB]RPC.DIR;1
$	delete sys$sysroot:[UCX$LIB]*.*;*
$	delete sys$sysroot:[000000]UCX$LIB.DIR;1
$	endif
$ endif
$
$ !
$ ! Delete all files with UCX$ prefix from system disk.
$ !
$ if .not. ucx$gl_everything
$	then
$	@'ucx$gt_callback ask_binary "Delete UCX system files" Y ucx$gl_result
$	endif
$ !
$ if ucx$gl_result
$	then
$	!rename/log sys$system:ucx$*.dat sys$system:ucx$*.old
$	delete_2 sys$help:ucx$*.*;*
$	delete_2 sys$library:ucx$*.*;*
$	delete_2 sys$message:ucx$*.*;*
$	delete_2 sys$startup:ucx$*.*;*
$	delete_2 sys$system:ucx$*.*;*
$	delete_2 sys$loadable_images:ucx$*.*;*
$	delete   sys$sysdevice:['ucx$t_root.syscommon.syshlp.examples.ucx.rpc]*.*;*
$	delete   sys$sysdevice:['ucx$t_root.syscommon.syshlp.examples.ucx]rpc.dir;1
$	delete   sys$sysdevice:['ucx$t_root.syscommon.syshlp.examples.ucx]*.*;*
$	delete   sys$sysdevice:['ucx$t_root.syscommon.syshlp.examples]ucx.dir;1
$	delete   sys$sysdevice:['ucx$t_root.syscommon.systest.ucx]*.*;*
$	delete   sys$sysdevice:['ucx$t_root.syscommon.systest]ucx$*.*;*
$	delete   sys$sysdevice:['ucx$t_root.syscommon.systest]ucx.dir;1
$	endif
$ !
$ ! Rename UCX database files  moved back here
$ !
$ @'ucx$gt_callback ask_binary "Rename UCX database files to OLD" Y ucx$gl_result
$ if ucx$gl_result
$	then
$	rename/log sys$system:ucx$*.dat .old 
$	endif
$ !         
$ !
$ ! Delete any UCX savesets in SYS$UPDATE
$ !
$ if .not. ucx$gl_everything
$	then
$	@'ucx$gt_callback ask_binary "Delete UCX kits in SYS$UPDATE" Y ucx$gl_result
$	endif
$ !
$ if ucx$gl_result
$	then
$		if f$search ("SYS$UPDATE::ALPHA_UCX03%.%") .NES. "" THEN - 
$			delete/log sys$update:ALPHA_ucx03%.%;*
$		if f$search ("SYS$UPDATE::UCX03%.%") .NES. "" THEN - 
$			delete/log sys$update:ucx03%.%;*
$		if f$search ("SYS$UPDATE::ALPHA_UCX04%.%") .NES. "" THEN - 
$			delete/log sys$update:ALPHA_ucx04%.%;*
$		if f$search ("SYS$UPDATE::UCX04%.%") .NES. "" THEN - 
$			delete/log sys$update:ucx04%.%;*
$	endif
$ !
$ ! Scan the system disk to see if we missed any UCX files
$ !
$! directory sys$sysdevice:[000000...]ucx$*.*
$ !
$ ucx$l_verify_state = f$verify( ucx$l_verify_state )
$ exit
$ !
$ ucx$ask_shutdown: subroutine
$ !
$ ucx$gt_file_shutdown == "sys$manager:ucx$shutdown.com"
$ ucx$t_status = f$search( ucx$gt_file_shutdown )
$ if ucx$t_status .nes. "" then goto 1$
$ !
$ ucx$t_message = f$fao( ucx$gt_msg_fnf, ucx$gt_file_shutdown )
$ write sys$output ucx$t_message
$ !
$ @'ucx$gt_callback N "Do you want to continue with the cleanup" ucx$gl_result
$ if ucx$gl_status then ucx$gl_status == ucx$gl_result
$ exit
$ !
$ 1$:
$ !
$ ucx$t_question = "Do you want to shutdown UCX before running cleanup" 
$ @'ucx$gt_callback ask_binary "''ucx$t_question'" Y ucx$gl_result
$ if .not. ucx$gl_status then exit
$ if ucx$gl_result
$	then
$	@'ucx$gt_file_shutdown
$	endif
$ !
$ exit
$ endsubroutine
$ !
$ ! Edit History:
$ !
$ ! 27-SEP-1993	RTB	Modified to kit delete for VAX and Alpha
$ ! 17-NOV-1993 MDK	Exclude deletion of UCX$CFS_SERVICES.EXE
$ ! 17-MAR-1994 RTB	Prompt for database file deletion
$ ! 2-Mar-1995	DMW	Delete anonymous stuff,
$ !                 	comment out deletion of lpd subdirectories, [ucx$bind]
$ !				files
$ !                 	Delete ntp stuff,
$ !			fixed rename of .dat to .old command
$ !			fixed deletion of systest and examples directories
$ ! 24-Apr-1995 MTH	De-install UCX$RCP.EXE.
$ ! 27-Jul-1995 JGJr	Update product name and version numbers.
$ !			Remove SYS$SYSROOT:[UCX$LIB...] as well.
$ ! 29-Sep-1995 JGJr	Cleanup RPC examples.
$ ! 05-Jun-1996 RTB	Add metric, finger, and pop references.
                                                                                                                                                                                                                                                                                                                                                                                                                                           < * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CLEANUP_HELPLIB.COM;1 +  , J   .     / #   4 d       H                   - P    0   1    2   3      K  P   W   O     5   6 ht  7 'u؛  8          9          G    H  J       
            # $ ! UCX$CLEANUP_HELPLIB.COM V4.1-00  $ ! 6 $ !  Copyright (c) Digital Equipment Corporation, 19956 $ !  All Rights Reserved.  Unpublished rights reserved3 $ !  under the copyright laws of the United States.  $ !   8 $ !  The software contained on this media is proprietary4 $ !  to and embodies the confidential technology of 5 $ !  Digital Equipment Corporation.  Possession, use, 5 $ !  duplication or dissemination of the software and 9 $ !  media is authorized only pursuant to a valid written 0 $ !  license from Digital Equipment Corporation. $ ! 5 $ !  RESTRICTED RIGHTS LEGEND   Use, duplication, or  4 $ !  disclosure by the U.S. Government is subject to9 $ !  restrictions as set forth in Subparagraph (c)(1)(ii) 3 $ !  of DFARS 252.227-7013, or in FAR 52.227-19, as  $ !  applicable. $ ! < $ !  Remove obsolete help topics which have accrued from the. $ !  installation of previous versions of UCX. $ ! J $ !*********************************************************************** $    TYPE SYS$INPUT 	 $    DECK    			UCX$CLEANUP_HELPLIB.COM  < 	This command procedure will remove all obsolete help topics= 	which have been placed into SYS$HELP:HELPLIB.HLB by previous 6 	installations of DIGITAL TCP/IP Services for OpenVMS.  > 	In order to properly delete the various topics, a copy of the= 	library is made and modified to ensure that there will be no ; 	problems encountered, as the cleanup may take some time in > 	order to complete.  Once the library has been cleaned up, the= 	new copy will be moved back to SYS$HELP, and the old library  	will be purged away.    $    EOD9 $    READ /PROMPT="Ready to continue? " SYS$COMMAND READY  $    IF .NOT. READY THEN EXIT < $    IF F$SEARCH("SYS$COMMON:[SYSHLP]HELPLIB.HLB;") .NES. ""	 $    THEN Z $        WRITE SYS$OUTPUT "Copying SYS$HELP:HELPLIB.HLB to SYS$HELP:HELPLIB.HLB-TEMPORARY" $        ON ERROR THEN EXIT W $        BACKUP SYS$COMMON:[SYSHLP]HELPLIB.HLB SYS$COMMON:[SYSHLP]HELPLIB.HLB-TEMPORARY d $        WRITE SYS$OUTPUT "Deleting obsolete help topics from the temporary copy of HELPLIB.HLB ..."! $	 CALL CLEANUP "Berkeley_R_Comm"  $        CALL CLEANUP "BOOTP" # $        CALL CLEANUP "BIND_Server" " $        CALL CLEANUP "DEC_TCP/IP" $        CALL CLEANUP "E_mail"$ $        CALL CLEANUP "FTP_overview"% $        CALL CLEANUP "Internet_Mail" # $        CALL CLEANUP "Name_Server" " $        CALL CLEANUP "PORTMAPPER"' $        CALL CLEANUP "Print_(LPR/LPD)" ' $        CALL CLEANUP "Print_(network)" ' $        CALL CLEANUP "Remote_printing" " $        CALL CLEANUP "R                                                                                                                                                                                                                                                                                                                                                                                                                                                                  <                        Xx $      UCX042.B                       J  P  <[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CLEANUP_HELPLIB.COM;1                                                                   d                              6             _Commands"$ $        CALL CLEANUP "R_Facilities" $        CALL CLEANUP "SNMP"# $        CALL CLEANUP "TCP_for_VMS" ' $        CALL CLEANUP "TELNET_overview" ! $        CALL CLEANUP "UCX$TRACE" 
 $ RESTORE:4 $        WRITE SYS$OUTPUT "Purging help library ..."X $        RENAME SYS$COMMON:[SYSHLP]HELPLIB.HLB-TEMPORARY SYS$COMMON:[SYSHLP]HELPLIB.HLB - $        PURGE SYS$COMMON:[SYSHLP]HELPLIB.HLB 
 $    ENDIF	 $    EXIT  $ !  $ CLEANUP: SUBROUTINE 
 $    SET NOON > $    WRITE SYS$OUTPUT "   ... deleting topic """, P1, """ ..." $    SET NOCONTROL=Y	 $ REPEAT: " $    DEFINE /USER SYS$ERROR  NLA0:" $    DEFINE /USER SYS$OUTPUT NLA0:K $    LIBRARY /HELP /DELETE="''P1'" SYS$COMMON:[SYSHLP]HELPLIB.HLB-TEMPORARY 1 $    IF $STATUS .EQ. %X1086109C !%LIBRAR-F-OPENIN 	 $    THEN  $        WAIT 0:0:02.00  $        GOTO REPEAT
 $    ENDIF $    SET CONTROL=Y $    ON ERROR THEN EXIT  $    EXIT $STATUS  $    ENDSUBROUTINE $ !  $ ! Modification history $ !	V4.0-00	John Gemignani, Jr.  $ !		Original implementation.  $ !	V4.1-00 John Gemignani, Jr. A $ !		Make the LIBRARIAN command silent so as not to scare anyone. > $ !		Preserve the protection code with BACKUP instead of copy.P $ !		Spell Berkeley_R_Comm[ands] correctly, and limit the name to 15 characters. $ !	V4.1-01 John Gemignani, Jr. , $ !		Add /HELP to identify the library type.                                                                                                                                                                                                     3 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1 +  , J   . 0   / #   4 v   0  $0                  - P    0   1    2   3      K  P   W   O 1   5   6 qf؛  7 !5u؛  8          9          G    H  J                            K $!  Copyright (c) 1997 Digital Equipment Corporation.  All rights reserved.  $@sys$manager:ucx$symbols " $FILE := SYS$MANAGER:UCX$FIXUP.COM( $IF F$SEARCH ("''FILE'") .NES. "" THEN -	 $ @'FILE'  $CALL SET_UAF_LOGICALS $SET CONTROL=Y! $ON CONTROL_Y THEN GOTO SET_ABORT  $ON WARNING THEN GOTO EXIT $SAY = "WRITE SYS$OUTPUT"  $INFORM = "CALL UCX$INFORM"  $WARN = "CALL UCX$WARN"  $UCX_WAIT == 0 $UCX_DELAY == 0 H $REQUIRED_PRIVS = "SYSPRV, SYSNAM, OPER, DETACH, BYPASS, CMKRNL, ALTPRI"& $PREV_PRIVS = F$SETPRV(REQUIRED_PRIVS)= $IF .NOT. F$PRIVILEGE(REQUIRED_PRIVS) THEN GOTO NO_PRIVILEGES B $DEFINE/SYSTEM/NOLOG UCX$EXAMPLES SYS$COMMON:[SYSHLP.EXAMPLES.UCX]% $IF F$TYPE (UCX$LICENSE_RUN) .NES. ""  $THEN  $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL:% $DELETE/SYMBOL/GLOBAL UCX$LICENSE_RUN  $ENDIFn $IF ("''UCX$CONT_ETHERNET'".NES. "") .OR. ("''UCX$CONT_FDDI'".NES. "") .OR. ("''UCX$CONT_TOKEN_RING'".NES. "") $THEN  $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL:' $DELETE/SYMBOL/GLOBAL UCX$CONT_ETHERNET  $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL:# $DELETE/SYMBOL/GLOBAL UCX$CONT_FDDI  $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL:) $DELETE/SYMBOL/GLOBAL UCX$CONT_TOKEN_RING  $ENDIF! $@SYS$MANAGER:UCX$UCP_STARTUP.COM  $TYPE SYS$INPUT  $DECK   ( 		TCP/IP Network Configuration Procedure  8 	This procedure helps you define the parameters required< 	to run DIGITAL TCP/IP Services for OpenVMS on this system.    $ EOD  $CONFIG_OPTIONS == "INVALID" $IF P1 .EQS. "SERVER"  $THEN 5 $SAY "The 'configure all server' option is selected."  $SAY " " $CONFIG_OPTIONS == "SERVER"  $ENDIF $IF P1 .EQS. "CLIENT"  $THEN 5 $SAY "The 'configure all client' option is selected."  $SAY " " $CONFIG_OPTIONS == "CLIENT"  $ENDIF $IF P1 .EQS. "MINIMUM" $THEN 6 $SAY "The 'Minimum configuration' option is selected." $SAY " " $CONFIG_OPTIONS == "MINIMUM" $ENDIF $IF P1 .EQS. "WORKSTATION" $THEN : $SAY "The 'Workstation configuration' option is selected." $SAY " "  $CONFIG_OPTIONS == "WORKSTATION" $ENDIF $IF P1 .EQS. "ALL" $THEN 6 $SAY "The 'configure all options' option is selected." $SAY " " $CONFIG_OPTIONS == "ALL" $ENDIF) $IF P1 .EQS. "" THEN CONFIG_OPTIONS == "" " $IF CONFIG_OPTIONS .EQS. "INVALID" $THEN C $SAY "Invalid configuration P1 option - continuing with no options"  $SAY " " $CONFIG_OPTIONS == ""  $ENDIF $IF CONFIG_OPTIONS .NES. ""  $THEN  $IF P3 .NES. ""  $THEN  $IF P3 .EQS. "CLUSTER" $THEN  $OPT3 = "cluster wide" $ELSE 
 $OPT3 = ""C $SAY "Invalid configuration P3 option - continuing with no options"  $SAY " " $CONFIG_OPTIONS == ""  $P2 = "" $ENDIF $ENDIF $IF P2 .NES. ""  $THEN 2 $IF ((P2 .NES. "ENABLE").AND.(P2 .NES. "DISABLE")) $THEN K $SAY "Invalid configuration P2 option - You must specify ENABLE or DISABLE" ! $SAY "Continuing with no options"  $SAY " " $CONFIG_OPTIONS == ""  $ELSE  $IF P2 .EQS. "ENABLE" THEN -? SAY "The 'silent mode' ENABLE ''OPT3' option is also selected."  $IF P2 .EQS. "DISABLE" THEN - @ SAY "The 'silent mode' DISABLE ''OPT3' option is also selected." $SAY " " $ENDIF $ELSE P $SAY "No P2 configuration option specified - You must specify ENABLE or DISABLE"! $SAY "Continuing with no options"  $SAY " " $CONFIG_OPTIONS == ""  $ENDIF $ENDIF $TYPE SYS$INPUT  $DECK   C 	Checking TCP/IP Services for OpenVMS configuration database files.    $ EOD  $UCX$MADE_FILE = "FALSE", $IF F$TRNLNM ("UCX$SERVICE") .EQS. "" THEN -F DEFINE/SYSTEM/EXECUTIVE UCX$SERVICE SYS$COMMON:[SYSEXE]UCX$SERVICE.DAT% $IF F$SEARCH ("UCX$SERVICE") .EQS. ""  $THEN $ $FILE_LOG = F$TRNLNM ("UCX$SERVICE") $INFORM "	Creating ''FILE_LOG'"  $UCX CREATE SERVICE  $UCX$MADE_FILE = "TRUE" 	 $SET NOON  $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL:, $UCX SET CONFIG ENABLE NOSERVICE */NOCONFIRM $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL:3 $UCX SET CONFIG ENABLE NOSERVICE */COMMON/NOCONFIRM  $SET ON  $ENDIF
 $CREATE_HOST: ! $FILE_LOG = F$TRNLNM ("UCX$HOST") - $IF FILE_LOG .EQS. "" THEN GOTO TRY_HOST_FILE % $FILE_NAME = F$SEARCH ("''FILE_LOG'") , $IF FILE_NAME .NES. "" THEN GOTO CREATE_NETW $INFORM "	Creating ''FILE_LOG'"$ $GOTO UCX_CREATE_HOSTF $TRY_HOST_FILE:R1 $FILE_NAME = F$SEARCH ("SYS$SYSTEM:UCX$HOST.DAT")H, $IF FILE_NAME .NES. "" THEN GOTO CREATE_NETW3 $INFORM "	Creating SYS$COMMON:[SYSEXE]UCX$HOST.DAT"AA $DEFINE/SYSTEM/EXECUTIVE UCX$HOST SYS$COMMON:[SYSEXE]UCX$HOST.DATC $UCX_CREATE_HOST:  $UCX CREATE HOST $UCX$MADE_FILE = "TRUE"Y
 $CREATE_NETW:E$ $FILE_LOG = F$TRNLNM ("UCX$NETWORK")- $IF FILE_LOG .EQS. "" THEN GOTO TRY_NETW_FILEP% $FILE_NAME = F$SEARCH ("''FILE_LOG'")G, $IF FILE_NAME .NES. "" THEN GOTO CREATE_ROUT $INFORM "	Creating ''FILE_LOG'"Y $GOTO UCX_CREATE_NETWE $TRY_NETW_FILE:E4 $FILE_NAME = F$SEARCH ("SYS$SYSTEM:UCX$NETWORK.DAT"), $IF FILE_NAME .NES. "" THEN GOTO CREATE_ROUT6 $INFORM "	Creating SYS$COMMON:[SYSEXE]UCX$NETWORK.DAT"G $DEFINE/SYSTEM/EXECUTIVE UCX$NETWORK SYS$COMMON:[SYSEXE]UCX$NETWORK.DATO $UCX_CREATE_NETW:. $UCX CREATE NETWORK/ $UCX$MADE_FILE = "TRUE"F
 $CREATE_ROUT:R $OLD_REC_SIZ = 542 $NEW_REC_SIZ = 579 $UCX$GL_CONVERT == UCX$GL_FALSE " $FILE_LOG = F$TRNLNM ("UCX$ROUTE") $IF FILE_LOG .NES. ""$ $THEND$ $FILE_NAME = F$SEARCH("''FILE_LOG'") $IF FILE_NAME .NES. "" $THEN/3 $REC_SIZ = F$FILE_ATTRIBUTES("''FILE_NAME'", "MRS")A $IF REC_SIZ .NE. NEW_REC_SIZ $THENN  $DEFINE/SYSTEM/EXECUTIVE/NOLOG -* UCX$ROUTE SYS$COMMON:[SYSEXE]UCX$ROUTE.DAT $GOTO ROUT_RENAMEp $ELSEr $GOTO CREATE_PROX  $ENDIF $ELSES $GOTO ROUT_CREAT $ENDIF $ENDIFI $DEFINE/EXECUTIVE/SYSTEM/NOLOG UCX$ROUTE SYS$COMMON:[SYSEXE]UCX$ROUTE.DAT " $FILE_LOG = F$TRNLNM ("UCX$ROUTE"); $FILE_NAME = F$SEARCH("SYS$SPECIFIC:[SYSEXE]UCX$ROUTE.DAT")E $IF FILE_NAME .NES. "" $THENT3 $REC_SIZ = F$FILE_ATTRIBUTES("''FILE_NAME'", "MRS")c3 $IF REC_SIZ .NES. NEW_REC_SIZ THEN GOTO ROUT_RENAMEF $ELSE19 $FILE_NAME = F$SEARCH("SYS$COMMON:[SYSEXE]UCX$ROUTE.DAT")  $IF FILE_NAME .NES. "" $THEN 3 $REC_SIZ = F$FILE_ATTRIBUTES("''FILE_NAME'", "MRS")O $IF REC_SIZ .NES. NEW_REC_SIZW $THENi $GOTO ROUT_RENAMEp $ELSE  $GOTO CREATE_PROX" $ENDIF $ELSEN $GOTO ROUT_CREAT $ENDIF $ENDIF
 $ROUT_RENAME:T $IF "''FILE_NAME'" .EQS. ""l $THENs4 $WARN "	UCX$CONFIG ERROR: UCX$ROUTE was not defined" $GOTO CREATE_PROX1 $ENDIF/ $IF REC_SIZ .EQS. OLD_REC_SIZ THEN GOTO ROUT_V1.- $FILE_OLD = F$PARSE(FILE_NAME,,,"DEVICE") + -t$ F$PARSE(FILE_NAME,,,"DIRECTORY") + - F$PARSE(FILE_NAME,,,"NAME") + -  ".OLD". $DEFINE/PROCESS/NOLOG UCX$ROUTE_OLD 'FILE_OLD'* $FILE_LOG_OLD = F$TRNLNM ("UCX$ROUTE_OLD")$ $RENAME/NOLOG 'FILE_NAME' 'FILE_OLD' $TYPE SYS$INPUT  $DECKn  9 	A V1.3 UC                                                                                                                                                                                                                                                                                                                                                                                                                                                                  =                        ICO $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                         "            X$ROUTE database has been found on your system.   @ 	This version of DIGITAL TCP/IP for OpenVMS requires a different= 	UCX$ROUTE file format than earlier versions.  This change isL 	required for SMTP support.o  ? 	You may choose to have this procedure populate a new UCX$ROUTE"& 	database with your existing database.  > 	Your old UCX$ROUTE database will be renamed with an extention 	of .OLD   $ EODE $ASK_ROUTE:  $READ SYS$COMMAND ANS - H /PROMPT="Do you want to convert your existing UCX$ROUTE database? [Y]: "+ $ANS = F$EDIT(ANS, "TRIM,UNCOMMENT,UPCASE")E $UCX$GL_STATUS == 1f& $IF ("''f$extract(0,1,ANS)'" .NES. "") $THENN' $IF ("''f$extract(0,1,ANS)'" .EQS. "N")o $THENs $UCX$GL_STATUS == 0_ $ELSE ; $IF ("''f$extract(0,1,ANS)'" .NES. "Y") THEN GOTO ASK_ROUTE  $ENDIF $ENDIF $ROUT_CREAT: $INFORM "	Creating ''FILE_LOG'"  $UCX CREATE ROUTEE $UCX$MADE_FILE = "TRUE"( $IF UCX$GL_CONVERT $THENN4 $INFORM "	Converting existing UCX$ROUTE database to" $SAY "	''FILE_LOG'"  $SAY " "	 $SET NOONR $ANALYZE/RMS UCX$ROUTE/FDL@ $CONVERT/NOSORT/CREATE/FDL=UCX$ROUTE.FDL UCX$ROUTE_OLD UCX$ROUTE $DELETE/NOLOG UCX$ROUTE.FDL;*M" $SET FILE UCX$ROUTE/PROTECT=(W:RE) $SET ONS $ENDIF $GOTO CREATE_PROXR	 $ROUT_V1:N $TYPE SYS$INPUTI $DECKE  @ 	This version of DIGITAL TCP/IP for OpenVMS requires a different> 	UCX$ROUTE file format than found on this system. This change . 	was required for SMTP support in Version 2.0.  D 	A V1.2 or earlier UCX$ROUTE database has been found on your system.  F 	This database cannot be converted using this configuration procedure.   	Therefore:I  . 		A new UCX$ROUTE database will be created as:" 		SYS$COMMON:[SYSEXE]UCX$ROUTE.DAT  6 		Your old UCX$ROUTE database will be renamed with an  		extention of .OLD_     $ EODR- $FILE_OLD = F$PARSE(FILE_NAME,,,"DEVICE") + - $ F$PARSE(FILE_NAME,,,"DIRECTORY") + - F$PARSE(FILE_NAME,,,"NAME") + -X ".OLD". $DEFINE/PROCESS/NOLOG UCX$ROUTE_OLD 'FILE_OLD'* $FILE_LOG_OLD = F$TRNLNM ("UCX$ROUTE_OLD")$ $RENAME/NOLOG 'FILE_NAME' 'FILE_OLD' $INFORM "	Creating ''FILE_LOG'"E $UCX CREATE ROUTEE $UCX$MADE_FILE = "TRUE"N
 $CREATE_PROX:O $NEW_REC_SIZ = 343 $UCX$CONVERT = "F"" $FILE_LOG = F$TRNLNM ("UCX$PROXY") $IF FILE_LOG .NES. ""E $THENA$ $FILE_NAME = F$SEARCH("''FILE_LOG'") $IF FILE_NAME .NES. "" $THENC3 $REC_SIZ = F$FILE_ATTRIBUTES("''FILE_NAME'", "MRS")$ $IF REC_SIZ .NE. NEW_REC_SIZ $THENE  $DEFINE/SYSTEM/EXECUTIVE/NOLOG -* UCX$PROXY SYS$COMMON:[SYSEXE]UCX$PROXY.DAT 		    UCX$CONVERT = "T"I $GOTO PROXY_RENAME $ELSER $GOTO PROXY_SET5 $ENDIF $ELSEZ $GOTO PROXY_CREATV $ENDIF $ENDIFI $DEFINE/SYSTEM/EXECUTIVE/NOLOG UCX$PROXY SYS$COMMON:[SYSEXE]UCX$PROXY.DATF" $FILE_LOG = F$TRNLNM ("UCX$PROXY"); $FILE_NAME = F$SEARCH("SYS$SPECIFIC:[SYSEXE]UCX$PROXY.DAT")" $IF FILE_NAME .NES. "" $THEN_3 $REC_SIZ = F$FILE_ATTRIBUTES("''FILE_NAME'", "MRS")E $IF REC_SIZ .NES. NEW_REC_SIZ[ $THENU $UCX$CONVERT = "T" $GOTO PROXY_RENAME $ENDIF $ELSEP9 $FILE_NAME = F$SEARCH("SYS$COMMON:[SYSEXE]UCX$PROXY.DAT")F $IF FILE_NAME .NES. "" $THENR3 $REC_SIZ = F$FILE_ATTRIBUTES("''FILE_NAME'", "MRS")$ $IF REC_SIZ .NES. NEW_REC_SIZE $THENA $UCX$CONVERT = "T" $GOTO PROXY_RENAME $ELSE  $GOTO PROXY_SET" $ENDIF $ELSES $GOTO PROXY_CREATT $ENDIF $ENDIF $PROXY_RENAME: $IF "''FILE_NAME'" .EQS. ""N $THENO4 $WARN "	UCX$CONFIG ERROR: UCX$PROXY was not defined" $GOTO CREATE_CONFIG" $ENDIF $TYPE SYS$INPUT" $DECK   I 	This version of DIGITAL TCP/IP Services for OpenVMS requires a different_/ 	UCX$PROXY file format than earlier versions.  T  < 	A V1.3 or earlier UCX$PROXY database has been found on your
 	system.    - 	A new UCX$PROXY database will be created as: 1 	SYS$COMMON:[SYSEXE]UCX$PROXY.DAT, and it will beT0 	populated with the data from your old database.  > 	Your old UCX$PROXY database will be renamed with an extention 	of .OLD   $ EODN- $FILE_OLD = F$PARSE(FILE_NAME,,,"DEVICE") + -M$ F$PARSE(FILE_NAME,,,"DIRECTORY") + - F$PARSE(FILE_NAME,,,"NAME") + -_ ".OLD". $DEFINE/PROCESS/NOLOG UCX$PROXY_OLD 'FILE_OLD'* $FILE_LOG_OLD = F$TRNLNM ("UCX$PROXY_OLD")$ $RENAME/NOLOG 'FILE_NAME' 'FILE_OLD'
 $PROXY_CREAT:  $SAY " "F $INFORM " For security purposes the Proxy Database is created with no"D $INFORM " world access. This denies non-privileged users the use of"4 $INFORM " commands which access the Proxy Database." $INFORM " "t $INFORM "	Creating ''FILE_LOG'"h $SAY " " $UCX CREATE PROXYY $READ SYS$COMMAND ANS -eM /PROMPT="Do you want to grant world read access to non-privileged users? [N]"$+ $ANS = F$EDIT(ANS, "TRIM,UNCOMMENT,UPCASE")r' $IF ("''f$extract(0,1,ANS)'" .EQS. "Y")" $THEN=# $SET FILE/PROT=W:RE/NOLOG UCX$PROXYE $SAY " "- $INFORM "	''FILE_LOG' Protection set to W:RE". $ENDIF $UCX$MADE_FILE = "TRUE", $IF UCX$CONVERT" $THENE4 $INFORM "	Converting existing UCX$PROXY database to" $SAY "	''FILE_LOG'"H $SAY " " $ANALYZE/RMS UCX$PROXY/FDL* $CONVERT/NOSORT/CREATE/FDL=UCX$PROXY.FDL - UCX$PROXY_OLD UCX$PROXYX $DELETE/NOLOG UCX$PROXY.FDL;*L $ENDIF $PROXY_SET:F $CREATE_CONFIG:e $OLD_REC_SIZ = 8192a $NEW_REC_SIZ = 8192 - 512' $UCX$GL_CONVERT == UCX$GL_FALSEE $UCX$GL_V3_UPGRADE == "FALSE"S* $FILE_LOG = F$TRNLNM ("UCX$CONFIGURATION") $IF FILE_LOG .NES. ""  $THENT$ $FILE_NAME = F$SEARCH("''FILE_LOG'") $IF FILE_NAME .NES. "" $THEN 3 $REC_SIZ = F$FILE_ATTRIBUTES("''FILE_NAME'", "MRS")  $IF REC_SIZ .NE. NEW_REC_SIZ $THENp2 $DEFINE/SYSTEM/EXECUTIVE/NOLOG UCX$CONFIGURATION -( SYS$COMMON:[SYSEXE]UCX$CONFIGURATION.DAT $GOTO CONFIG_RENAMEs $ELSEi $GOTO CHECK_FILESA $ENDIF $ELSEr $GOTO CONFIG_CREAT $ENDIF $ENDIF2 $DEFINE/SYSTEM/EXECUTIVE/NOLOG UCX$CONFIGURATION -( SYS$COMMON:[SYSEXE]UCX$CONFIGURATION.DAT* $FILE_LOG = F$TRNLNM ("UCX$CONFIGURATION")C $FILE_NAME = F$SEARCH("SYS$SPECIFIC:[SYSEXE]UCX$CONFIGURATION.DAT")X $IF FILE_NAME .NES. "" $THEN 3 $REC_SIZ = F$FILE_ATTRIBUTES("''FILE_NAME'", "MRS") 5 $IF REC_SIZ .NES. NEW_REC_SIZ THEN GOTO CONFIG_RENAME, $ELSECA $FILE_NAME = F$SEARCH("SYS$COMMON:[SYSEXE]UCX$CONFIGURATION.DAT")S $IF FILE_NAME .NES. "" $THEN'3 $REC_SIZ = F$FILE_ATTRIBUTES("''FILE_NAME'", "MRS")/ $IF REC_SIZ .NES. NEW_REC_SIZI $THEN	 $GOTO CONFIG_RENAMEE $ELSEC $GOTO CHECK_FILESM $ENDIF $ELSEE $GOTO CONFIG_CREAT $ENDIF $ENDIF $CONFIG_RENAME:= $IF "''FILE_NAME'" .EQS. ""U $THENY< $WARN "	UCX$CONFIG ERROR: UCX$CONFIGURATION was not defined" $GOTO CHECK_FILESE $ENDIF $UCX$GL_V3_UPGRADE == "TRUE"- $FILE_OLD = F$PARSE(FILE_NAME,,,"DEVICE") + -_$ F$PARSE(FILE_NAME,,,"DIRECTORY") + - F$PARSE(FILE_NAME,,,"NAME") + -X ".OLD"6 $DEFINE/PROCESS/NOLOG UCX$CONFIGURATION_OLD 'FILE_OLD'2 $FILE_LOG_OLD = F$TRNLNM ("UCX$CONFIGURATION_OLD")$ $RENAME/NOLOG 'FILE_NAME' 'FILE_OLD' $TYPE SYS$INPUTT $DECKU  A 	A V2.0 UCX$CONFIGURATION database has been found on your system.$  I 	This version of DIGITAL TCP/IP Services for OpenVMS requires a differentAE 	UCX$CONFIGURATION file format than earlier versions.  This change isI( 	required for Bind Server (DNS) support.  G 	You may choose to have this procedure populate a new UCX$CONFIGURATIONF& 	database with your existing database.  F 	Your old UCX$CONFIGURATION database will be renamed with an extention 	of .OLD   $ EOD, $ASK_CONFIG: $READ SYS$COMMAND ANS -EP /PROMPT="Do you want to convert your existing UCX$CONFIGURATION database? [Y]: "+ $ANS = F$EDIT(ANS, "TRIM,UNCOMMENT,UPCASE")  $UCX$GL_CONVERT == 1& $IF ("''f$extract(0,1,ANS)'" .NES. "") $THENF' $IF ("''f$extract(0,1,ANS)'" .EQS. "N")T $THENE $UCX$GL_CONVERT == 0 $ELSEN< $IF ("''f$extract(0,1,ANS)'" .NES. "Y") THEN GOTO ASK_CONFIG $ENDIF $ENDIF $CONFIG_CREAT: $INFORM "	Creating ''FILE_LOG'"  $UCX CREATE CONFIGURATIONe $UCX$MADE_FILE = "TRUE"  $IF UCX$GL_CONVERT $THENs< $INFORM "	Converting existing UCX$CONFIGURATION database to" $SAY "	''FILE_LOG'"R $SAY " "	 $SET NOONb" $ANALYZE/RMS UCX$CONFIGURATION/FDL2 $CONVERT/NOSORT/CREATE/FDL=UCX$CONFIGURATION.FDL -' UCX$CONFIGURATION_OLD UCX$CONFIGURATION % $DELETE/NOLOG UCX$CONFIGURATION.FDL;*,* $SET FILE UCX$CONFIGURATION/PROTECT=(W:RE) $SET ON- $ENDIF
 $CHECK_FILES:NJ $IF .NOT. UCX$MADE_FILE THEN INFORM "	No new database files were created."" $IF UCX$GL_V3_UPGRADE .EQS. "TRUE" $THEN/	 $SET NOON_* $WARN "Performing V3.0/V4.0 upgrade tasks" $SAY " "7 $SAY " Renaming V2.0 UCX$INET_SET_INTERFACES.COM file."nH $IF F$SEARCH ("SYS$MANAGER:UCX$INET_SET_INTERFACES.COM") .NES. "" THEN -b $ RENAME/NOLOG SYS$MANAGER:UCX$INET_SET_INTERFACES.COM;0 SYS$MANAGER:UCX$INET_SET_INTERFACES.OLD;0H $IF F$SEARCH ("SYS$MANAGER:UCX$INET_SET_INTERFACES.COM") .NES. "" THEN -8 $ DELETE/NOLOG SYS$MANAGER:UCX$INET_SET_INTERFACES.COM;*0 $SAY " Renaming V2.0 UCX$RSHD_STARTUP.COM file."C $IF F$SEARCH ("SYS$SYSDEVICE:[UCX$                                                                                                                                                                                                                                                   >                        v $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                        9` "            RSH]UCX$RSHD_STARTUP.COM").NES.""R $THEN 8 $PURGE/NOLOG SYS$SYSDEVICE:[UCX$RSH]UCX$RSHD_STARTUP.COMi $RENAME/NOLOG SYS$SYSDEVICE:[UCX$RSH]UCX$RSHD_STARTUP.COM;0 SYS$SYSDEVICE:[UCX$RSH]UCX$RSHD_STARTUP.OLD;0R $ENDIF2 $SAY " Renaming V2.0 UCX$REXECD_STARTUP.COM file."G $IF F$SEARCH ("SYS$SYSDEVICE:[UCX$REXEC]UCX$REXECD_STARTUP.COM").NES.""L $THENR< $PURGE/NOLOG SYS$SYSDEVICE:[UCX$REXEC]UCX$REXECD_STARTUP.COMq $RENAME/NOLOG SYS$SYSDEVICE:[UCX$REXEC]UCX$REXECD_STARTUP.COM;0 SYS$SYSDEVICE:[UCX$REXEC]UCX$REXECD_STARTUP.OLD;0A $ENDIF' $SAY " Deleting obsolete driver files."U/ $IF F$SEARCH ("SYS$SYSTEM:BGDRIVER.EXE").NES.""A $THENS< $SAY "     Deleting SYS$SYSTEM:BGDRIVER.EXE - Obsolete file"' $DELETE/NOLOG SYS$SYSTEM:BGDRIVER.EXE;*" $ENDIF/ $IF F$SEARCH ("SYS$SYSTEM:TNDRIVER.EXE").NES.""E $THENE< $SAY "     Deleting SYS$SYSTEM:TNDRIVER.EXE - Obsolete file"' $DELETE/NOLOG SYS$SYSTEM:TNDRIVER.EXE;*T $ENDIF! $SAY " Removing V2.0 NFS Account"G $IF .NOT. $STATUS THEN EXIT 0/ $DEFINE/USER SYS$OUTPUT NL:N $DEFINE/USER SYS$ERROR NL: $UCX$UAF SHOW UCX$NFSD' $IF $STATUS THEN UCX$UAF REMOVE UCX$NFSI. $SAY " Renaming V2.0 NFS startup file to .old"F $IF F$SEARCH ("SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_STARTUP.COM") .NES. "" -k THEN RENAME/NOLOG SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_STARTUP.COM;* SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_STARTUP.OLD;*L. $SAY " Removing V2.0 portmapper service entry" $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL:! $UCX SHOW SERVICE PORTMAPPER/PERM"7 $IF $STATUS THEN UCX SET NOSERVICE/NOCONFIRM PORTMAPPERF $SET ONE $ENDIF	 $SET NOONCC $IF F$TRNLNM ("UCX$TDF") .NES. "" THEN DEASSIGN/SYSTEM/EXEC UCX$TDF_ $DEFINE/USER SYS$OUTPUT NL:. $DEFINE/USER SYS$ERROR NL: $UCX GENERATE TIME/ $IF $STATUS .AND. F$TRNLNM ("UCX$TDF") .EQS. ""E $THENF $DEFINE/USER SYS$OUTPUT NL:" $DEFINE/USER SYS$ERROR NL: $UCX SET CONF NOTIME $ENDIF	 $SET NOON, $UCX$DOMAIN_NAME = ""S $UCX$LOCAL_NAME = "". $IF F$TRNLNM ("UCX$INET_HOST") .NES. "" THEN -" DEASSIGN/SYSTEM/EXEC UCX$INET_HOST0 $IF F$TRNLNM ("UCX$INET_DOMAIN") .NES. "" THEN -$ DEASSIGN/SYSTEM/EXEC UCX$INET_DOMAIN $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:e $UCX GENERATE DOMAIN $IF $STATUSe $THENf/ $UCX$DOMAIN_NAME = F$TRNLNM ("UCX$INET_DOMAIN")i, $UCX$LOCAL_NAME = F$TRNLNM ("UCX$INET_HOST") $ENDIF $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:S $UCX GENERATE SERVICE /CONFIGo $UCX$UICG == 0 $UCX$UICM == 0 $PSWRD == "" $GUIC_SAID == "FALSE"hP $SERV_LIST = "BIND:BOOTP:TFTP:FTP:FTP_CLIENT:LPD:LPD_CLIENT:NFS:NFS_CLIENT:" + -E "PCNFS:PORTMAPPER:RLOGIN:RSH:REXEC:SMTP:SNMP:NTPD:METRIC:TELNET:" + -N( "POP:PWIP_DRIVER:INET_DRIVER:FINGER:RMT" $SERV_LIST_M = 24G $SERV_LIST_N = 0 $MENU0_TODO_L = "0"( $MENU0_TODO_N = 0T $MENUA_TODO_L = "0"O $MENUA_TODO_N = 0' $MENUB_TODO_L = "0". $MENUB_TODO_N = 0I $MENUC_TODO_L = "0"N $MENUC_TODO_N = 0T $MENUD_TODO_L = "0"  $MENUD_TODO_N = 0" $MENUE_TODO_L = "0"" $MENUE_TODO_N = 0T $M0_CORE = "1"
 $M0_CLI = "2"C
 $M0_SRV = "3"I $M0_OPTL = "4" $M0_SHUT = "5" $M0_STRT = "6"
 $M0_TST = "7"X $MA_BIND = "1" $MA_DOMN = "2" $MA_ROUT = "3" $MA_INTE = "4" $MA_TIME = "5" $MB_FTP = "01" $MB_LPD = "02" $MB_NFS = "03" $MB_RCOM = "04"S $MB_RLOG = "05"E $MB_SMTP = "06"A $MB_TELN = "07"T $MC_BIND = "01"L $MC_BOOTP = "02" $MC_TFTP = "03"G $MC_FTP = "04" $MC_LPD = "05" $MC_NFS = "06" $MC_PCNFS = "07" $MC_PORT = "08"C $MC_TELN = "09"R $MC_SNMP = "10"T $MC_NTPD = "11"E $MC_METRIC = "12"T $MC_POP = "13" $MC_FINGER = "14"w $MC_RMT = "15" $CONFIG_OPTA = "" @ $CONFIG_OPTS = ""		!Silent mode - "1" for enable "2" for disable! $IF CONFIG_OPTIONS .EQS. "CLIENT"" $THENY, $IF P2 .EQS. "ENABLE" THEN CONFIG_OPTS = "1"- $IF P2 .EQS. "DISABLE" THEN CONFIG_OPTS = "2"_ $GOSUB MENU_B_ALLE# $MENUB_TODO_L = MENUB_TODO_L + ":E"G  $MENUB_TODO_N = MENUB_TODO_N + 1+ $MENU0_TODO_L = MENU0_TODO_L + ":''M0_CLI'"   $MENU0_TODO_N = MENU0_TODO_N + 1 $GOTO MENU_0_LOOP. $ENDIF! $IF CONFIG_OPTIONS .EQS. "SERVER"U $THEN_, $IF P2 .EQS. "ENABLE" THEN CONFIG_OPTS = "1"- $IF P2 .EQS. "DISABLE" THEN CONFIG_OPTS = "2"S $GOSUB MENU_C_ALL$# $MENUC_TODO_L = MENUC_TODO_L + ":E"P  $MENUC_TODO_N = MENUC_TODO_N + 1+ $MENU0_TODO_L = MENU0_TODO_L + ":''M0_SRV'"V  $MENU0_TODO_N = MENU0_TODO_N + 1 $GOTO MENU_0_LOOPX $ENDIF $IF CONFIG_OPTIONS .EQS. "ALL" $THENn, $IF P2 .EQS. "ENABLE" THEN CONFIG_OPTS = "1"- $IF P2 .EQS. "DISABLE" THEN CONFIG_OPTS = "2"S $GOSUB MENU_0_ALLL $GOSUB MENU_A_ALLL $GOSUB MENU_B_ALLC $GOSUB MENU_C_ALLS $GOTO MENU_0_LOOP/ $ENDIF" $IF CONFIG_OPTIONS .EQS. "MINIMUM" $THENO, $IF P2 .EQS. "ENABLE" THEN CONFIG_OPTS = "1"- $IF P2 .EQS. "DISABLE" THEN CONFIG_OPTS = "2"e $GOSUB MENU_0_ALLE* $MENUA_TODO_L = "0" + ":''MA_INTE'" + ":E" $MENUA_TODO_N = 2l4 $IF .NOT. UCX$LICENSE_RUN .OR. .NOT. UCX$LICENSE_APP $THEN  $MENUB_TODO_L = "0"X $MENUB_TODO_N = 0$ $MENUC_TODO_L = "0"N $MENUC_TODO_N = 0E $ELSEE $MENUB_TODO_L = "0:01:05:07:E" $MENUB_TODO_N = 4o9 $MENUC_TODO_L = "0" + ":''MC_FTP'" + ":''MC_TELN'" + ":E"F $MENUC_TODO_N = 32 $ENDIF $GOTO MENU_0_LOOP  $ENDIF& $IF CONFIG_OPTIONS .EQS. "WORKSTATION" $THENF, $IF P2 .EQS. "ENABLE" THEN CONFIG_OPTS = "1"- $IF P2 .EQS. "DISABLE" THEN CONFIG_OPTS = "2"Y $GOSUB MENU_0_ALLS $IF .NOT. UCX$LICENSE_RUN  $THENH: $MENUA_TODO_L = "0" + ":''MA_INTE'" + ":''MA_TIME'" + ":E" $MENUA_TODO_N = 3Y $ELSEVG $MENUA_TODO_L = "0" + ":''MA_DOMN'" + ":''MA_INTE'" + ":''MA_ROUT'" + -.$ ":''MA_BIND'" + ":''MA_TIME'" + ":E" $MENUA_TODO_N = 6D $ENDIF4 $IF .NOT. UCX$LICENSE_RUN .OR. .NOT. UCX$LICENSE_APP $THENV $MENUB_TODO_L = "0"  $MENUB_TODO_N = 0X $MENUC_TODO_L = "0"I $MENUC_TODO_N = 0T $ELSEE$ $MENUB_TODO_L = "0:01:04:05:06:07:E" $MENUB_TODO_N = 6D9 $MENUC_TODO_L = "0" + ":''MC_FTP'" + ":''MC_TELN'" + ":E"  $MENUC_TODO_N = 3R $ENDIF $GOTO MENU_0_LOOP  $ENDIF $MENU_0_START:! $ON CONTROL_Y THEN GOTO SET_ABORTD $ON WARNING THEN GOTO EXIT $CALL CREATE_CONTROLLERS	 $TEMP = 0C $IF MENU0_TODO_N .EQ. 0 .OR. -I F$LOCATE (":''M0_CORE'",MENU0_TODO_L) .EQ. F$LENGTH (MENU0_TODO_N) THEN -) TEMP = 1 $IF MENUA_TODO_N .EQ. 0 .OR. -I F$LOCATE (":''MA_INTE'",MENUA_TODO_L) .EQ. F$LENGTH (MENUA_TODO_N) THEN -E TEMP = TEMP + 2O% $IF TEMP .EQ. 0 THEN GOTO MENU_0_LOOPN	 $SET NOONO" $UCX$INTERFACE_CONFIGURED = "TRUE" $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:T $UCX SHOW CONFIG INTE /CONFIG$ $IF .NOT. $STATUSO $THENE# $UCX$INTERFACE_CONFIGURED = "FALSE"F $SET ONS $TYPE SYS$INPUTU $DECKR  A 	DIGITAL TCP/IP Services for OpenVMS requires a definition for atG> 	least one interface.  There are no interfaces defined on this 	system.   $    EODM $INFORM "	Please select the Interface option from the Core Environment Menu."E $ENDIF
 $MENU_0_LOOP:V! $ON CONTROL_Y THEN GOTO SET_ABORTI $ON WARNING THEN GOTO EXIT $SET ONT $MENU_EXIT = 0, $IF MENU0_TODO_N .EQ. 0 THEN GOTO ASK_MENU_0- $CONFIG_OPT0 = F$ELEMENT (1,":",MENU0_TODO_L)_! $UCX$MENU_TODO_L = "MENU0_TODO_L"C! $UCX$MENU_TODO_N = "MENU0_TODO_N"   $UCX$MENU_TODO_ELE = CONFIG_OPT0 $GOSUB UCX$REM_TODO  $GOTO SKIP_MENU_0" $ASK_MENU_0: $SET ONR! $ON CONTROL_Y THEN GOTO SET_ABORT= $ON WARNING THEN GOTO EXIT $IF UCX$LICENSE_APP" $THEN_
 $CLI_T0 = " "_
 $SRV_T0 = " "_ $ELSE"& $CLI_T0 = "Requires UCX-IP-CLIENT PAK"& $SRV_T0 = "Requires UCX-IP-CLIENT PAK" $ENDIF $CALL CLEAR_SCREEN $SAY " "> $SAY "	DIGITAL TCP/IP Services for OpenVMS Configuration Menu" $SAY " " $SAY "	Configuration options:" $SAY " "  $SAY "		 1  -  Core environment", $SAY "		 2  -  Client components  ''CLI_T0'", $SAY "		 3  -  Server components  ''SRV_T0'"# $SAY "		 4  -  Optional components"  $SAY " "< $SAY "		 5  -  Shutdown DIGITAL TCP/IP Services for OpenVMS"B $SAY "	         6  -  Startup DIGITAL TCP/IP Services for OpenVMS" $SAY "		 7  -  Run tests"I $SAY " "' $SAY "		 A  -  Configure options 1 - 3"T, $SAY "		[E] -  Exit configuration procedure" $SAY " " $CONFIG_OPTS = ""TD $READ SYS$COMMAND CONFIG_OPT0 /PROMPT="Enter configuration option: "; $CONFIG_OPT0 = F$EDIT(CONFIG_OPT0, "TRIM,UNCOMMENT,UPCASE")F $IF CONFIG_OPT0 .EQS. "" $THENR $CONFIG_OPT0 = "E" $ELSEN- $CONFIG_OPT0 = F$EDIT (CONFIG_OPT0, "UPCASE")A $ENDIF
 $SKIP_MENU_0:  $UCX$VAL_OPT0 = 0_3 $IF CONFIG_OPT0 .EQS. M0_CORE THEN GOTO MENU_A_LOOPD2 $IF CONFIG_OPT0 .EQS. M0_CLI THEN GOTO MENU_B_LOOP2 $IF CONFIG_OPT0 .EQS. M0_SRV THEN GOTO MENU_C_LOOP4 $IF CONFIG_OPT0 .EQS. M0_OPTL THEN GOSUB MENU_E_LOOP4 $IF CONFIG_OPT0 .EQS. M0_SHUT THEN GOSUB UCXSHUTDOWN3 $IF CONFIG_OPT0 .EQS. M0_STRT THEN GOSUB UCXRESTART 2 $IF CONFIG_OPT0 .EQS. M0_TST THEN GOTO MENU_D_LOOP" $IF F$EXTRACT(0, 1, CONFIG_OPT0) -# .EQS. "A"     THEN GOSUB MENU_0_ALLS" $IF F$EXTRACT(0, 1, CONFIG_OPT0) -$ .EQS. "E"     THEN GOTO                                                                                                                                                                                                                                                    ?                        S $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                         "     0        MENU_0_EXIT $IF .NOT. UCX$VAL_OPT0 $THENG> $SAY "Invalid configuration option selected, please try again" $GOTO ASK_MENU_0 $ENDIF $GOTO MENU_0_LOOPC
 $UCXSHUTDOWN:O $UCX$VAL_OPT0 = 1E $SAY "Begin Shutdown..." $SAY " "  $@SYS$MANAGER:UCX$SHUTDOWN "UCP"# $WARN "Shutdown request completed."M	 $RETURN 1  $UCXRESTART: $UCX$VAL_OPT0 = 1 6 $IF .NOT.F$GETDVI("BG:","EXISTS") THEN GOTO DO_STARTUP3 $IF .NOT.F$GETDVI("BG:","MNT") THEN GOTO DO_STARTUP  $SAY " "> $WARN "DIGITAL TCP/IP Services for OpenVMS is already started"A $SAY "You must first do a shutdown before a startup can be done."T $SAY " "	 $RETURN 1_ $DO_STARTUP: $SAY "Begin Startup..."E $SAY " " $@SYS$MANAGER:UCX$STARTUP.COM " $WARN "Startup request completed."	 $RETURN 1V
 $MENU_0_EXIT:  $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:. $UCX SHOW CONFIG INTE /CONFIG  $IF .NOT. $STATUS_ $THEN  $TYPE SYS$INPUT  $DECKE  A 	DIGITAL TCP/IP Services for OpenVMS requires a definition for atN> 	least one interface.  There are no interfaces defined on this; 	system and therefore DIGITAL TCP/IP Services will not run.M   $    EODK $CALL ASK_BINARY "Do you want to exit configuration anyway" N ucx$gl_resultT& $IF .NOT. UCX$GL_STATUS THEN GOTO EXIT $IF .NOT. UCX$GL_RESULTE $THENDS $INFORM "Please select the Interface option from the Core Environment Menu option.". $GOTO ASK_MENU_0 $ENDIF $ENDIF
 $GOTO EXIT $MENU_0_ALL: $UCX$VAL_OPT0 = 1) $IF .NOT. UCX$LICENSE_RUNU $THENN $MENU0_TODO_L = "0:1"E $MENU0_TODO_N = 1U $ELSEL $MENU0_TODO_L = "0:1:2:3"_ $MENU0_TODO_N = 3T $IF CONFIG_OPTS .NES. "" $THENT# $MENU0_TODO_L = MENU0_TODO_L + ":E"R  $MENU0_TODO_N = MENU0_TODO_N + 1 $ENDIF $ENDIF $RETURNN
 $MENU_A_LOOP:U! $ON CONTROL_Y THEN GOTO SET_ABORTI $ON WARNING THEN GOTO EXIT $SET ONI $CONFIG_OPTB = ""  $CONFIG_OPTC = ""S $CONFIG_OPTD = ""  $UCX$VAL_OPT0 = 1T $IF MENUA_TODO_N .EQ. 0S $THENe$ $IF MENU_EXIT THEN GOTO MENU_0_START $GOTO ASK_MENU_A $ENDIF- $CONFIG_OPTA = F$ELEMENT (1,":",MENUA_TODO_L)I! $UCX$MENU_TODO_L = "MENUA_TODO_L" ! $UCX$MENU_TODO_N = "MENUA_TODO_N"n  $UCX$MENU_TODO_ELE = CONFIG_OPTA $GOSUB UCX$REM_TODOE $GOTO SKIP_MENU_AN $ASK_MENU_A: $SET ONO $IF UCX$LICENSE_RUNI $THEN_
 $RUN_TA = " "H $ELSE & $RUN_TA = "Requires UCX-IP-CLIENT PAK" $ENDIF $CALL CLEAR_SCREEN $SAY " "O $SAY "	DIGITAL TCP/IP Services for OpenVMS Core Environment Configuration Menu"_ $SAY " " $SAY "	Configuration options:" $SAY " ". $SAY "		 1  -  BIND Resolver        ''RUN_TA'". $SAY "		 2  -  Domain               ''RUN_TA'". $SAY "		 3  -  Routing              ''RUN_TA'" $SAY "		 4  -  Interfaces" $SAY "		 5  -  Time Zone"T $SAY " "' $SAY "		 A  -  Configure options 1 - 5"A $SAY "		[E] -  Exit menu"D $SAY " "D $READ SYS$COMMAND CONFIG_OPTA /PROMPT="Enter configuration option: "; $CONFIG_OPTA = F$EDIT(CONFIG_OPTA, "TRIM,UNCOMMENT,UPCASE")  $IF CONFIG_OPTA .EQS. "" $THEN  $CONFIG_OPTA = "E" $ELSES- $CONFIG_OPTA = F$EDIT (CONFIG_OPTA, "UPCASE")t $ENDIF
 $SKIP_MENU_A:Y $MENU_EXIT = 0 $UCX$VAL_OPTA = 0AL $IF CONFIG_OPTA .EQS. "1" .AND. UCX$LICENSE_RUN THEN GOSUB UCX$BIND_RESOLVERE $IF CONFIG_OPTA .EQS. "2" .AND. UCX$LICENSE_RUN THEN GOSUB UCX$DOMAIN F $IF CONFIG_OPTA .EQS. "3" .AND. UCX$LICENSE_RUN THEN GOSUB UCX$ROUTING3 $IF CONFIG_OPTA .EQS. "4" THEN GOSUB UCX$INTERFACESO1 $IF CONFIG_OPTA .EQS. "5" THEN GOSUB UCX$TIMEZONEC" $IF F$EXTRACT(0, 1, CONFIG_OPTA) - .EQS. "A" THEN GOSUB MENU_A_ALLG" $IF F$EXTRACT(0, 1, CONFIG_OPTA) -" .EQS. "E" THEN GOTO  MENU_A_RETURN $IF .NOT. UCX$VAL_OPTA $THENDA $INFORM "Invalid configuration option selected, please try again"R $GOTO ASK_MENU_A $ENDIF $GOTO MENU_A_LOOPS $MENU_A_RETURN:O $MENU_EXIT = 1 $MENUA_TODO_L = "0"0 $MENUA_TODO_N = 0_ $GOTO MENU_0_START $MENU_A_ALL: $UCX$VAL_OPTA = 1_ $IF .NOT. UCX$LICENSE_RUNS $THENU3 $MENUA_TODO_L = "0" + ":''MA_INTE'" + ":''MA_TIME'"R $MENUA_TODO_N = 2T $ELSEIG $MENUA_TODO_L = "0" + ":''MA_DOMN'" + ":''MA_INTE'" + ":''MA_ROUT'" + -F ":''MA_BIND'" + ":''MA_TIME'"G $MENUA_TODO_N = 5I $ENDIF $IF CONFIG_OPTS .NES. "" $THENE# $MENUA_TODO_L = MENUA_TODO_L + ":E"T  $MENUA_TODO_N = MENUA_TODO_N + 1 $ENDIF	 $RETURN 1p
 $MENU_B_LOOP:p! $ON CONTROL_Y THEN GOTO SET_ABORT  $ON WARNING THEN GOTO EXIT $SET ONO $CONFIG_OPTC = ""  $UCX$SO = "" $UCX$VAL_OPT0 = 1S $IF MENUB_TODO_N .EQ. 0$ $THENN# $IF MENU_EXIT THEN GOTO MENU_A_LOOPe $GOTO ASK_MENU_B $ENDIF- $CONFIG_OPTB = F$ELEMENT (1,":",MENUB_TODO_L)B! $UCX$MENU_TODO_L = "MENUB_TODO_L" ! $UCX$MENU_TODO_N = "MENUB_TODO_N"   $UCX$MENU_TODO_ELE = CONFIG_OPTB $GOSUB UCX$REM_TODOc $GOTO SKIP_MENU_Bl $ASK_MENU_B:	 $SET NOON  $SERV_LIST_N = 0
 $SERV_LOOP_B: 4 $SERV_LIST_E = F$ELEMENT (SERV_LIST_N,":",SERV_LIST): $IF F$TRNLNM ("UCX$''SERV_LIST_E'_ENABLE") .NES. "" THEN -- DEASSIGN/SYSTEM/EXEC UCX$'SERV_LIST_E'_ENABLE" $SERV_LIST_N = SERV_LIST_N + 16 $IF SERV_LIST_N .NE. SERV_LIST_M THEN GOTO SERV_LOOP_B $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL: $UCX GENER SERV /CONFIGE $IF .NOT. UCX$LICENSE_APPs $THENe) $FTP_TB = "UCX-IP-CLIENT PAK is required"o) $LPD_TB = "UCX-IP-CLIENT PAK is required"n) $NFS_TB = "UCX-IP-CLIENT PAK is required"C* $RSHL_TB = "UCX-IP-CLIENT PAK is required"* $RLOG_TB = "UCX-IP-CLIENT PAK is required"* $SMTP_TB = "UCX-IP-CLIENT PAK is required"* $TELN_TB = "UCX-IP-CLIENT PAK is required" $ELSEE $FTP_TB = "Disabled" $LPD_TB = "Disabled" $NFS_TB = "Disabled" $RSHL_TB = "Disabled"o $RLOG_TB = "Disabled"  $SMTP_TB = "Disabled"X $TELN_TB = "Disabled"V $ENDIFG $IF F$TRNLNM ("UCX$FTP_CLIENT_ENABLE") .NES. "" THEN FTP_TB = "Enabled"TG $IF F$TRNLNM ("UCX$LPD_CLIENT_ENABLE") .NES. "" THEN LPD_TB = "Enabled"OG $IF F$TRNLNM ("UCX$NFS_CLIENT_ENABLE") .NES. "" THEN NFS_TB = "Enabled"TC $IF F$TRNLNM ("UCX$REXEC_ENABLE") .NES. "" THEN RSHL_TB = "Enabled"OD $IF F$TRNLNM ("UCX$RLOGIN_ENABLE") .NES. "" THEN RLOG_TB = "Enabled"B $IF F$TRNLNM ("UCX$SMTP_ENABLE") .NES. "" THEN SMTP_TB = "Enabled"D $IF F$TRNLNM ("UCX$TELNET_ENABLE") .NES. "" THEN TELN_TB = "Enabled" $SET ONS $CALL CLEAR_SCREEN $SAY " "P $SAY "	DIGITAL TCP/IP Services for OpenVMS Client Components Configuration Menu" $SAY " " $SAY "	Configuration options:" $SAY " "* $SAY "		 1  -  FTP              ''FTP_TB'"* $SAY "		 2  -  LPR/LPD          ''LPD_TB'"* $SAY "		 3  -  NFS Client       ''NFS_TB'"+ $SAY "		 4  -  REXEC and RSH    ''RSHL_TB'"A+ $SAY "		 5  -  RLOGIN           ''RLOG_TB'"Y+ $SAY "		 6  -  SMTP             ''SMTP_TB'"n+ $SAY "		 7  -  TELNET           ''TELN_TB'"Y $SAY " "' $SAY "		 A  -  Configure options 1 - 7"  $SAY "		[E] -  Exit menu"_ $SAY " "D $READ SYS$COMMAND CONFIG_OPTB /PROMPT="Enter configuration option: "; $CONFIG_OPTB = F$EDIT(CONFIG_OPTB, "TRIM,UNCOMMENT,UPCASE")  $IF CONFIG_OPTB .EQS. "" $THEN	 $CONFIG_OPTB = "E" $ELSE-9 $IF (CONFIG_OPTB .NES. "E") .AND. (CONFIG_OPTB .NES. "A")N $THENG( $IF F$LENGTH (CONFIG_OPTB) .EQ. 1 THEN -$ CONFIG_OPTB = "0" + "''CONFIG_OPTB'" $ENDIF- $CONFIG_OPTB = F$EDIT (CONFIG_OPTB, "UPCASE")T $ENDIF
 $SKIP_MENU_B:" $MENU_EXIT = 0 $UCX$VAL_OPTB = 0N0 $IF .NOT. UCX$LICENSE_APP THEN GOTO MENU_B_NOLIC4 $IF CONFIG_OPTB .EQS. "01" THEN GOSUB UCX$FTP_CLIENT4 $IF CONFIG_OPTB .EQS. "02" THEN GOSUB UCX$LPD_CLIENT4 $IF CONFIG_OPTB .EQS. "03" THEN GOSUB UCX$NFS_CLIENT. $IF CONFIG_OPTB .EQS. "04" THEN GOSUB UCX$RCOM0 $IF CONFIG_OPTB .EQS. "05" THEN GOSUB UCX$RLOGIN. $IF CONFIG_OPTB .EQS. "06" THEN GOSUB UCX$SMTP0 $IF CONFIG_OPTB .EQS. "07" THEN GOSUB UCX$TELNET" $IF F$EXTRACT(0, 1, CONFIG_OPTB) -  .EQS. "A"  THEN GOSUB MENU_B_ALL $MENU_B_NOLIC:" $IF F$EXTRACT(0, 1, CONFIG_OPTB) -# .EQS. "E"  THEN GOTO  MENU_B_RETURNA $IF .NOT. UCX$VAL_OPTB $THENdA $INFORM "Invalid configuration option selected, please try again"A $GOTO ASK_MENU_B $ENDIF $GOTO MENU_B_LOOPO $MENU_B_RETURN:  $MENU_EXIT = 1 $MENUB_TODO_L = "0"  $MENUB_TODO_N = 0A $GOTO MENU_A_LOOPU $MENU_B_ALL: $UCX$VAL_OPTB = 1I4 $IF .NOT. UCX$LICENSE_RUN .OR. .NOT. UCX$LICENSE_APP $THEN' $MENUB_TODO_L = "0"D $MENUB_TODO_N = 0M $ELSED( $MENUB_TODO_L = "0:01:02:03:04:05:06:07" $MENUB_TODO_N = 7F $IF CONFIG_OPTS .NES. "" $THEN # $MENUB_TODO_L = MENUB_TODO_L + ":E"G  $MENUB_TODO_N = MENUB_TODO_N + 1 $ENDIF $ENDIF	 $RETURN 1  $UCX$FTP_CLIENT: $UCX$VAL_OPTB = 1D $UCX$SO = "FTP"M $UCX$APROX = 0 $UCX$CDIR = "" $UCX$CLUSTER = 1 $UCX$ENA_SRV = "FTP_CLIENT"S $UCX$HASCONF = ""C
 $UCX$PRIV = 0  $UCX$PSEUDO = 1T $GOSUB UCX$SERV_MENU	 $RETURN 1  $UCX$FTP_CLIENT_ACT: $UCX$FTP_CLIENT_SET:	 $RETURN 1_ $UCX$LPD_CLIENT: $UCX$VAL_OPTB = 1E $UCX$SO = "LPD"O $UCX$APROX = 0 $UCX$CDIR = "UCX_LPD"L $UCX$CP = 4_% $UCX$CCOM = "UCX$LPD_RCV_STARTUP.COM"O $UCX$CDEV = "SYS$SPECIFIC" $UCX$CLUSTER = 0 $UCX$ENA_S                                                                                                                                                                                                                                                   @                        (v $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                         "     A       RV = "LPD_CLIENT"  $UCX$HASCONF = ""I
 $UCX$PRIV = 1_ $UCX$PSEUDO = 1I $GOSUB UCX$SERV_MENU	 $RETURN 1, $UCX$LPD_CLIENT_ACT: $GOSUB UCX$LPD_ACT $UCX$LPD_CLIENT_SET:	 $RETURN 1S $UCX$NFS_CLIENT: $UCX$VAL_OPTB = 1A $UCX$SO = "NFS"N $UCX$APROX = 0 $UCX$CDIR = "" $UCX$CLUSTER = 0 $UCX$ENA_SRV = "NFS_CLIENT"F $UCX$HASCONF = "" 
 $UCX$PRIV = 0S $UCX$PSEUDO = 1  $GOSUB UCX$SERV_MENU" $IF UCX$ENABS .NE. 0 THEN RETURN 1	 $SET NOON  $DEFINE/USER SYS$OUTPUT NL:r $DEFINE/USER SYS$ERROR NL: $UCX SHOW CONF TIME  $IF .NOT. $STATUSL $THENK $SAY " "+ $SAY "	A time zone has not been configured"e $SAY " "G $INFORM "	WARNING: NFS will not function if a time zone is not defined"q $SAY " ": $SAY "	You will be asked to configure the time zone later" $SAY " " $IF MENUA_TODO_N .EQ. 0 .OR. -B F$LOCATE (":''MA_TIME'",MENUA_TODO_L) .EQ. F$LENGTH (MENUA_TODO_L) $THENi, $MENUA_TODO_L = MENUA_TODO_L + ":''MA_TIME'"  $MENUA_TODO_N = MENUA_TODO_N + 1 $ENDIF $ENDIF $SET ONE	 $RETURN 1I $UCX$NFS_CLIENT_SET:	 $RETURN 1E $UCX$NFS_CLIENT_ACT: $CALL CREATE_NOBODY$ $RETURN $STATUSC
 $MENU_C_LOOP:.! $ON CONTROL_Y THEN GOTO SET_ABORTI $ON WARNING THEN GOTO EXIT $SET ON  $CONFIG_OPTB = ""E $UCX$SO = "" $UCX$VAL_OPT0 = 1I $IF MENUC_TODO_N .EQ. 0R $THEN=# $IF MENU_EXIT THEN GOTO MENU_B_LOOPN $GOTO ASK_MENU_C $ENDIF- $CONFIG_OPTC = F$ELEMENT (1,":",MENUC_TODO_L)E! $UCX$MENU_TODO_L = "MENUC_TODO_L""! $UCX$MENU_TODO_N = "MENUC_TODO_N"Y  $UCX$MENU_TODO_ELE = CONFIG_OPTC $GOSUB UCX$REM_TODO  $GOTO SKIP_MENU_Ca $ASK_MENU_C:	 $SET NOONY $SERV_LIST_N = 0
 $SERV_LOOP_C:"4 $SERV_LIST_E = F$ELEMENT (SERV_LIST_N,":",SERV_LIST): $IF F$TRNLNM ("UCX$''SERV_LIST_E'_ENABLE") .NES. "" THEN -* DEASS/SYSTEM/EXEC UCX$'SERV_LIST_E'_ENABLE $SERV_LIST_N = SERV_LIST_N + 16 $IF SERV_LIST_N .NE. SERV_LIST_M THEN GOTO SERV_LOOP_C $DEFINE/USER SYS$OUTPUT NL:S $DEFINE/USER SYS$ERROR NL: $UCX GENER SERV /CONFIG  $IF .NOT. UCX$LICENSE_APPt $THEN-& $FTP_TC = "Requires UCX-IP-CLIENT PAK"& $LPD_TC = "Requires UCX-IP-CLIENT PAK"' $PORT_TC = "Requires UCX-IP-CLIENT PAK"_' $TELN_TC = "Requires UCX-IP-CLIENT PAK"T' $SNMP_TC = "Requires UCX-IP-CLIENT PAK"E' $NTPD_TC = "Requires UCX-IP-CLIENT PAK"I) $METRIC_TC = "Requires UCX-IP-CLIENT PAK""& $POP_TC = "Requires UCX-IP-CLIENT PAK") $FINGER_TC = "Requires UCX-IP-CLIENT PAK"I& $RMT_TC = "Requires UCX-IP-CLIENT PAK" $ELSE_ $FTP_TC = "Disabled" $LPD_TC = "Disabled" $PORT_TC = "Disabled"O $TELN_TC = "Disabled"$ $SNMP_TC = "Disabled"E $NTPD_TC = "Disabled"O $METRIC_TC = "Disabled"  $POP_TC = "Disabled" $FINGER_TC = "Disabled"  $RMT_TC = "Disabled" $ENDIF $IF .NOT. UCX$LICENSE_UCXU $THENF $BIND_TC = "Requires UCX PAK"  $BOOT_TC = "Requires UCX PAK"O $TFTP_TC = "Requires UCX PAK"  $NFS_TC = "Requires UCX PAK" $PCNFS_TC = "Requires UCX PAK" $ELSEG $BIND_TC = "Disabled"O $BOOT_TC = "Disabled"X $TFTP_TC = "Disabled") $NFS_TC = "Disabled" $PCNFS_TC = "Disabled" $ENDIFD $IF F$TRNLNM ("UCX$BIND_ENABLE")   .NES. "" THEN BIND_TC = "Enabled"D $IF F$TRNLNM ("UCX$BOOTP_ENABLE")  .NES. "" THEN BOOT_TC = "Enabled"D $IF F$TRNLNM ("UCX$TFTP_ENABLE")   .NES. "" THEN TFTP_TC = "Enabled"C $IF F$TRNLNM ("UCX$FTP_ENABLE")    .NES. "" THEN FTP_TC = "Enabled"NC $IF F$TRNLNM ("UCX$LPD_ENABLE")    .NES. "" THEN LPD_TC = "Enabled" C $IF F$TRNLNM ("UCX$NFS_ENABLE")    .NES. "" THEN NFS_TC = "Enabled"TE $IF F$TRNLNM ("UCX$PCNFS_ENABLE")  .NES. "" THEN PCNFS_TC = "Enabled"4H $IF F$TRNLNM ("UCX$PORTMAPPER_ENABLE") .NES. "" THEN PORT_TC = "Enabled"D $IF F$TRNLNM ("UCX$TELNET_ENABLE") .NES. "" THEN TELN_TC = "Enabled"D $IF F$TRNLNM ("UCX$SNMP_ENABLE")   .NES. "" THEN SNMP_TC = "Enabled"D $IF F$TRNLNM ("UCX$NTPD_ENABLE")   .NES. "" THEN NTPD_TC = "Enabled"H $IF F$TRNLNM ("UCX$METRIC_ENABLE")   .NES. "" THEN METRIC_TC = "Enabled"B $IF F$TRNLNM ("UCX$POP_ENABLE")   .NES. "" THEN POP_TC = "Enabled"F $IF F$TRNLNM ("UCX$FINGER_ENABLE") .NES. "" THEN FINGER_TC = "Enabled"@ $IF F$TRNLNM ("UCX$RMT_ENABLE") .NES. "" THEN RMT_TC = "Enabled" $SET ONL $CALL CLEAR_SCREEN $SAY " "P $SAY "	DIGITAL TCP/IP Services for OpenVMS Server Components Configuration Menu" $SAY " " $SAY "	Configuration options:" $SAY ") $SAY "		 1  -  BIND           ''BIND_TC'":) $SAY "		 2  -  BOOTP          ''BOOT_TC'" ) $SAY "		 3  -  TFTP           ''TFTP_TC'" ( $SAY "		 4  -  FTP            ''FTP_TC'"( $SAY "		 5  -  LPR/LPD        ''LPD_TC'"( $SAY "		 6  -  NFS            ''NFS_TC'"* $SAY "		 7  -  PC-NFS         ''PCNFS_TC'") $SAY "		 8  -  PORTMAPPER     ''PORT_TC'"1) $SAY "		 9  -  TELNET/RLOGIN  ''TELN_TC'" ) $SAY "		10  -  SNMP           ''SNMP_TC'"T) $SAY "		11  -  NTP            ''NTPD_TC'" 0 $SAY "	        12  -  METRIC	      ''METRIC_TC'"* $SAY "	        13  -  POP	      ''POP_TC'"+ $SAY "		14  -  FINGER         ''FINGER_TC'" ( $SAY "		15  -  RMT            ''RMT_TC'" $SAY " "( $SAY "		 A  -  Configure options 1 - 15" $SAY "		[E] -  Exit menu"M $SAY " "D $READ SYS$COMMAND CONFIG_OPTC /PROMPT="Enter configuration option: "; $CONFIG_OPTC = F$EDIT(CONFIG_OPTC, "TRIM,UNCOMMENT,UPCASE")F $IF CONFIG_OPTC .EQS. "" $THENU $CONFIG_OPTC = "E" $ELSE - $CONFIG_OPTC = F$EDIT (CONFIG_OPTC, "UPCASE") 9 $IF (CONFIG_OPTC .NES. "E") .AND. (CONFIG_OPTC .NES. "A")E $THENI( $IF F$LENGTH (CONFIG_OPTC) .EQ. 1 THEN -$ CONFIG_OPTC = "0" + "''CONFIG_OPTC'" $ENDIF $ENDIF
 $SKIP_MENU_C:. $MENU_EXIT = 0 $UCX$VAL_OPTC = 0G0 $IF .NOT. UCX$LICENSE_APP THEN GOTO MENU_C_NOLICC $IF CONFIG_OPTC .EQS. "01" .AND. UCX$LICENSE_UCX THEN GOSUB UCX$DNSOE $IF CONFIG_OPTC .EQS. "02" .AND. UCX$LICENSE_UCX THEN GOSUB UCX$BOOTP_D $IF CONFIG_OPTC .EQS. "03" .AND. UCX$LICENSE_UCX THEN GOSUB UCX$TFTP- $IF CONFIG_OPTC .EQS. "04" THEN GOSUB UCX$FTPT- $IF CONFIG_OPTC .EQS. "05" THEN GOSUB UCX$LPD C $IF CONFIG_OPTC .EQS. "06" .AND. UCX$LICENSE_UCX THEN GOSUB UCX$NFSEE $IF CONFIG_OPTC .EQS. "07" .AND. UCX$LICENSE_UCX THEN GOSUB UCX$PCNFSL- $IF CONFIG_OPTC .EQS. "08" THEN GOSUB UCX$RPCD? $IF CONFIG_OPTC .EQS. "09" THEN GOSUB UCX$TELNET_RLOGIN_MESSAGER. $IF CONFIG_OPTC .EQS. "10" THEN GOSUB UCX$SNMP. $IF CONFIG_OPTC .EQS. "11" THEN GOSUB UCX$NTPD0 $IF CONFIG_OPTC .EQS. "12" THEN GOSUB UCX$METRIC- $IF CONFIG_OPTC .EQS. "13" THEN GOSUB UCX$POPs0 $IF CONFIG_OPTC .EQS. "14" THEN GOSUB UCX$FINGER- $IF CONFIG_OPTC .EQS. "15" THEN GOSUB UCX$RMTT" $IF F$EXTRACT(0, 1, CONFIG_OPTC) -  .EQS. "A"  THEN GOSUB MENU_C_ALL $MENU_C_NOLIC:" $IF F$EXTRACT(0, 1, CONFIG_OPTC) -# .EQS. "E"  THEN GOTO  MENU_C_RETURN- $IF .NOT. UCX$VAL_OPTC $THEN A $INFORM "Invalid configuration option selected, please try again"C $GOTO ASK_MENU_C $ENDIF $GOTO MENU_C_LOOP_ $MENU_C_RETURN:  $MENU_EXIT = 1 $MENUC_TODO_L = "0"D $MENUC_TODO_N = 0C $GOTO MENU_B_LOOPT $MENU_C_ALL: $UCX$VAL_OPTC = 1T4 $IF .NOT. UCX$LICENSE_RUN .OR. .NOT. UCX$LICENSE_APP $THENB $MENUC_TODO_L = "0"X $MENUC_TODO_N = 0" $ELSEs $IF CONFIG_OPTIONS .EQS. "ALL" $THEN" $IF UCX$LICENSE_UCXe $THENAW $MENUC_TODO_L = "0" + ":''MC_BIND'" + ":''MC_BOOTP'" + ":''MC_TFTP'" + ":''MC_FTP'" + -Tr ":''MC_LPD'" + ":''MC_PORT'" + ":''MC_NFS'" + ":''MC_PCNFS'" + ":''MC_SNMP'" + ":''MC_NTPD'" + ":''MC_METRIC'" + -- ":''MC_POP'" + ":''MC_FINGER'" + ":''MC_RMT'"H $MENUC_TODO_N = 15 $ENDIF $ELSEM $IF UCX$LICENSE_UCX  $THEN"@ $MENUC_TODO_L = "0:01:02:03:04:05:06:07:08:09:10:11:12:13:14:15" $MENUC_TODO_N = 15 $ELSEdE $MENUC_TODO_L = "0" + ":''MC_FTP'" + ":''MC_LPD'" + ''MC_FINGER'" + - m ":''MC_PORT'" + ":''MC_TELN'" + ":''MC_SNMP'" + ":''MC_NTPD'" + ":''MC_METRIC'" + ":''MC_POP'" + ":''MC_RMT'". $MENUC_TODO_N = 9  $ENDIF $ENDIF $IF CONFIG_OPTS .NES. "" $THEN)# $MENUC_TODO_L = MENUC_TODO_L + ":E"I  $MENUC_TODO_N = MENUC_TODO_N + 1 $ENDIF $ENDIF	 $RETURN 1b
 $MENU_D_LOOP:L! $ON CONTROL_Y THEN GOTO SET_ABORTH $ON WARNING THEN GOTO EXIT $SET ON( $UCX$VAL_OPT0 = 1  $IF MENUD_TODO_N .EQ. 0" $THEN"# $IF MENU_EXIT THEN GOTO MENU_0_LOOP  $GOTO ASK_MENU_D $ENDIF- $CONFIG_OPTD = F$ELEMENT (1,":",MENUD_TODO_L)N! $UCX$MENU_TODO_L = "MENUD_TODO_L" ! $UCX$MENU_TODO_N = "MENUD_TODO_N".  $UCX$MENU_TODO_ELE = CONFIG_OPTD $GOSUB UCX$REM_TODOE $GOTO SKIP_MENU_DE $ASK_MENU_D: $SET ONS $CALL CLEAR_SCREEN $TYPE SYS$INPUT  $DECKD  . 	DIGITAL TCP/IP Services for OpenVMS TEST Menu   	Test options: 	" 		 1  -  Internet IVPi 		 2  -  SNMP IVP    		 A  -  Tests 1 - 2 		[E] -  Exit menu   $ EODS; $READ SYS$COMMAND CONFIG_OPTD /PROMPT="Enter test option: " ; $CONFIG_OPTD = F$EDIT(CONFIG_OPTD, "TRIM,UNCOMMENT,UPCASE")C $IF CONFIG_OPTD .EQS. "" $THEN  $CONFIG_OPTD = "E" $ELSEN- $CONFIG_OPTD = F$EDIT (CONFIG_OPTD, "UPCASE")  $ENDIF
 $SKIP_MENU_D:S $MENU_EXIT = 0 $UCX$VAL_OPTD = 0T/ $IF CONFIG_OPTD .EQS. "1"  THEN GOTO  DOINETIVP / $IF CONFIG_OPTD .EQS. "2"  THEN GO                                                                                                                                                                                                                                                   A                        ~& $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                        h- "     R       TO  DOSNMPIVP"" $IF F$EXTRACT(0, 1, CONFIG_OPTD) -  .EQS. "A"  THEN GOSUB MENU_D_ALL" $IF F$EXTRACT(0, 1, CONFIG_OPTD) -# .EQS. "E"  THEN GOTO  MENU_D_RETURN  $IF .NOT. UCX$VAL_OPTD $THEN 0 $SAY "Invalid option selected, please try again" $GOTO ASK_MENU_D $ENDIF $GOTO MENU_D_LOOP  $MENU_D_RETURN:i $MENU_EXIT = 1 $MENUD_TODO_L = "0"  $MENUD_TODO_N = 0= $GOTO MENU_C_LOOPn $MENU_D_ALL: $UCX$VAL_OPTD = 1( $MENUD_TODO_L = "0:1:2:E"T $MENUD_TODO_N = 3F	 $RETURN 1S $DOINETIVP:  $UCX$VAL_OPTD = 1  $SAY "Begin IVP..."= $SAY " "" $@SYS$SYSROOT:[SYSTEST]UCX$IVP.COM $WARN "IVP request completed." $GOTO MENU_D_LOOPE $DOSNMPIVP:G $UCX$VAL_OPTD = 2Q $SAY "Begin SNMP IVP..." $SAY " "- $run SYS$SYSROOT:[SYSTEST.UCX]UCX$SNMPIVP.EXEM# $WARN "SNMP IVP request completed."  $GOTO MENU_D_LOOPP
 $MENU_E_LOOP:U! $ON CONTROL_Y THEN GOTO SET_ABORT" $ON WARNING THEN GOTO EXIT $SET ON$ $UCX$VAL_OPT0 = 1T $IF MENUE_TODO_N .EQ. 0C $THENX# $IF MENU_EXIT THEN GOTO MENU_0_LOOPT $GOTO ASK_MENU_E $ENDIF- $CONFIG_OPTE = F$ELEMENT (1,":",MENUE_TODO_L)E! $UCX$MENU_TODO_L = "MENUE_TODO_L"O! $UCX$MENU_TODO_N = "MENUE_TODO_N"$  $UCX$MENU_TODO_ELE = CONFIG_OPTE $GOSUB UCX$REM_TODOT $GOTO SKIP_MENU_E  $ASK_MENU_E: $SET ON0 $CALL CLEAR_SCREEN $TYPE SYS$INPUTC $DECKL  N     DIGITAL TCP/IP Services for OpenVMS Optional Components Configuration Menu   	Configuration options:S 	R 		 1  -  Configure PWIP Driver2 		 2  -  Configure SRI QIO Interface (INET Driver)5 		 3  -  Set up Anonymous FTP Account and Directories$   		[E] -  Exit menu   $ EOD1; $READ SYS$COMMAND CONFIG_OPTE /PROMPT="Enter test option: " ; $CONFIG_OPTE = F$EDIT(CONFIG_OPTE, "TRIM,UNCOMMENT,UPCASE")I $IF CONFIG_OPTE .EQS. "" $THEN  $CONFIG_OPTE = "E" $ELSEC- $CONFIG_OPTE = F$EDIT (CONFIG_OPTE, "UPCASE")G $ENDIF
 $SKIP_MENU_E:E $MENU_EXIT = 0 $UCX$VAL_OPTE = 0C0 $IF CONFIG_OPTE .EQS. "1"  THEN GOSUB PWIP_SETUP0 $IF CONFIG_OPTE .EQS. "2"  THEN GOSUB INET_SETUP5 $IF CONFIG_OPTE .EQS. "3"  THEN GOSUB ANONYMOUS_SETUPN" $IF F$EXTRACT(0, 1, CONFIG_OPTE) -  .EQS. "A"  THEN GOSUB MENU_E_ALL" $IF F$EXTRACT(0, 1, CONFIG_OPTE) -# .EQS. "E"  THEN GOTO  MENU_E_RETURN. $IF .NOT. UCX$VAL_OPTE $THENC0 $SAY "Invalid option selected, please try again" $GOTO ASK_MENU_E $ENDIF $GOTO MENU_E_LOOPE $MENU_E_RETURN:  $MENU_EXIT = 1 $MENUE_TODO_L = "0"  $MENUE_TODO_N = 0' $GOTO MENU_0_LOOP_ $MENU_E_ALL: $UCX$VAL_OPTE = 1_ $MENUE_TODO_L = "0:1:2:3:E"C $MENUE_TODO_N = 4N	 $RETURN 1M $PWIP_SETUP: $UCX$VAL_OPTE = 1: $UCX$SO = "" $UCX$APROX = 0 $UCX$CDIR = "" $UCX$CP = 0  $UCX$CCOM = "" $UCX$CDEV = "" $UCX$CLUSTER = 0 $UCX$ENA_SRV = "PWIP_DRIVER" $UCX$HASCONF = ""0
 $UCX$PRIV = 0" $UCX$PSEUDO = 1  $GOSUB UCX$SERV_MENU	 $RETURN 1  $UCX$PWIP_DRIVER_ACT:P $UCX$PWIP_DRIVER_SET: 	 $RETURN 1R $INET_SETUP: $UCX$VAL_OPTE = 1' $UCX$SO = "" $UCX$APROX = 0 $UCX$CDIR = "" $UCX$CP = 0_ $UCX$CCOM = "" $UCX$CDEV = "" $UCX$CLUSTER = 0 $UCX$ENA_SRV = "INET_DRIVER" $UCX$HASCONF = ""_
 $UCX$PRIV = 0  $UCX$PSEUDO = 1E $GOSUB UCX$SERV_MENU	 $RETURN 1R $UCX$INET_DRIVER_ACT:L $UCX$INET_DRIVER_SET:T	 $RETURN 1H $ANONYMOUS_SETUP:G $CALL CREATE_ANONYMOUS $UCX$VAL_OPTE = 1 	 $RETURN 1N $EXIT:7 $IF F$TRNLNM("UCX$START") .NES. "" THEN CLOSE UCX$START_5 $IF F$TRNLNM("UCX$ANON") .NES. "" THEN CLOSE UCX$ANONO $S = $STATUS" $PREV_PRIVS = F$SETPRV(PREV_PRIVS) $EXIT SN $SET_ABORT:O $SAY " "0 $SAY "	Network configuration procedure aborted." $SAY " "
 $GOTO EXIT $NO_PRIVILEGES:T $SAY " "5 $SAY "	Insufficient privileges to run UCX$CONFIG.COM"P> $SAY "	This procedure requires ",REQUIRED_PRIVS," privileges." $SAY " "
 $GOTO EXIT $ERROR_NOTCOPE:  $SAY " "C $SAY "	WARNING - UCX$CONFIG.COM is not compatible with UCX$UCP.EXE"T $SAY " "C $SAY "	          Please  either  deinstall  SYS$SYSTEM:UCX$UCP.EXE"MC $SAY "	          or  perform @SYS$MANAGER:UCX$SHUTDOWN, and  rerun"   $SAY "	          UCX$CONFIG.COM" $SAY " "
 $GOTO EXIT $ERROR_INVALID_ADDRESS:M $SAY " "$ $SAY "	Invalid host address format." $SAY " "	 $RETURN 1O $ERROR_ADDRESS_INUSE:G $SAY " "A $SAY "	Internet address is already assigned to another interface"E $SAY " " $SET ON 	 $RETURN 1  $ERROR_DUP_ADDRESS:O $SAY " "? $SAY "	This Internet address is used by host: ''UCX$CONFIG_P1'"  $SAY " " $SET ONi	 $RETURN 1l $UCX$DOMAIN: $UCX$VAL_OPTA = 1S $SAY " " $SAY "DOMAIN Configuration"M $SAY " "	 $SET NOON_ $UCX$DOMAIN_NAME = ""  $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:L $UCX GENERATE DOMAIN? $IF $STATUS THEN UCX$DOMAIN_NAME = F$TRNLNM ("UCX$INET_DOMAIN")I $SET_DOMAIN: $UCX$DEFAULT = ""YG $IF UCX$DOMAIN_NAME .NES. "" THEN UCX$DEFAULT = " [''UCX$DOMAIN_NAME']"P8 $READ/END_OF_FILE=DOMAIN_ERROR SYS$COMMAND DOMAIN_NAME -/ /PROMPT="Enter Internet domain''UCX$DEFAULT': ""L $IF DOMAIN_NAME .EQS. "" .AND. UCX$DOMAIN_NAME .NES. "" THEN GOTO SKIP_D_SETP $IF f$locate("""",DOMAIN_NAME) .NE. f$length(DOMAIN_NAME) THEN GOTO DOMAIN_ERROR; $IF DOMAIN_NAME .NES. "" THEN UCX$DOMAIN_NAME = DOMAIN_NAMEI3 $IF UCX$DOMAIN_NAME .EQS. "" THEN GOTO DOMAIN_ERRORT@ $UCX SET CONFIGURATION COMMUNICATION/DOMAIN="''UCX$DOMAIN_NAME'"( $IF .NOT. $STATUS THEN GOTO DOMAIN_ERROR $UCX GENERATE DOMAIN $IF .NOT. $STATUSU $THENNB $WARN "UCX$CONFIG ERROR: Error while generating valid domain name" $ENDIF $SKIP_D_SET:	 $RETURN 10 $DOMAIN_ERROR:2 $SAY "You must enter a valid Internet domain name" $GOTO SET_DOMAIN $UCX$INTERFACES: $UCX$VAL_OPTA = 1  $SAY " " $SAY "INTERFACE Configuration" $SAY " "" $ON ERROR THEN GOTO EXIT_INTERFACE $CALL CREATE_CONTROLLERS" $UCX$EDEV = "''UCX$CONT_ETHERNET'" $IF UCX$EDEV .EQS. "" THEN -D UCX$EDEV = "0 XE:DE XQ:QE ES:SE ET:NE EX:XE EF:FE EZ:ZE EC:CE ER:RE" $UCX$ECON = "0 A B C D E F G H"E $UCX$ETXT = "Ethernet") $UCX$EDATA = "UCX$EDEV UCX$ECON UCX$ETXT"E $UCX$FDEV = "''UCX$CONT_FDDI'" $IF UCX$FDEV .EQS. "" THEN -> UCX$FDEV = "0 FC:CF FX:FF FA:AF FW:WF FR:RF FQ:QF CL:IF EL:LF" $UCX$FCON = "0 A B C D"  $UCX$FTXT = "FDDI") $UCX$FDATA = "UCX$FDEV UCX$FCON UCX$FTXT"T$ $UCX$TDEV = "''UCX$CONT_TOKEN_RING'" $IF UCX$TDEV .EQS. "" THEN - UCX$TDEV = "0 IC:CT IR:RT" $UCX$TCON = "0 A B C D"T $UCX$TTXT = "Token_Ring") $UCX$TDATA = "UCX$TDEV UCX$TCON UCX$TTXT"T2 $UCX$DATA_LIST = "0 UCX$EDATA UCX$FDATA UCX$TDATA" $UCX$DATA_ELE = 0E $UCX$VALID_LIST = "0"n $UCX$VALID_ITEMS = 0 $GET_DEVICE_DATA:E  $UCX$DATA_ELE = UCX$DATA_ELE + 1< $UCX$DATA_ITM = F$ELEMENT (UCX$DATA_ELE, " ", UCX$DATA_LIST)5 $IF UCX$DATA_ITM .EQS. " " THEN GOTO END_FIND_DEVICESL! $UCX$DEVICE_DATA = 'UCX$DATA_ITM'3, $UCX$TEMP = F$ELEMENT(0," ",UCX$DEVICE_DATA) $UCX$DEVICE_LIST = 'UCX$TEMP'S, $UCX$TEMP = F$ELEMENT(1," ",UCX$DEVICE_DATA) $UCX$CONTROL_LIST = 'UCX$TEMP', $UCX$TEMP = F$ELEMENT(2," ",UCX$DEVICE_DATA) $UCX$DEV_TXT = 'UCX$TEMP'0 $UCX$DEVICE_ELE = 0X $UCX$NEW_DEVICE = "TRUE"
 $NEXT_DEVICE:R$ $UCX$DEVICE_ELE = UCX$DEVICE_ELE + 1B $UCX$DEVICE_ENTRY = F$ELEMENT (UCX$DEVICE_ELE," ",UCX$DEVICE_LIST)8 $IF UCX$DEVICE_ENTRY .EQS. " " THEN GOTO GET_DEVICE_DATA1 $UCX$DEVNAME = F$ELEMENT (0,":",UCX$DEVICE_ENTRY)E? $IF .NOT. F$GETDVI (UCX$DEVNAME,"EXISTS") THEN GOTO NEXT_DEVICEP $UCX$CONTROL_ELE = 0 $NEXT_CONTROLLER: & $UCX$CONTROL_ELE = UCX$CONTROL_ELE + 1B $UCX$CONTROLLER = F$ELEMENT (UCX$CONTROL_ELE," ",UCX$CONTROL_LIST)2 $IF UCX$CONTROLLER .EQS. " " THEN GOTO NEXT_DEVICE1 $UCX$VMSDEV = UCX$DEVNAME + UCX$CONTROLLER + "0:"$B $IF .NOT. F$GETDVI (UCX$VMSDEV,"EXISTS") THEN GOTO NEXT_CONTROLLERN $UCX$DEV = F$ELEMENT (1,":",UCX$DEVICE_ENTRY) + F$STRING (UCX$CONTROL_ELE - 1)	 $SET NOONi
 $UCX$DEVC = 0o $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL:! $UCX SHOW CONFIG INTERF 'UCX$DEV'u $IF $STATUS THEN UCX$DEVC = 1  $SET ON  $CONFIG_TXT = UCX$VMSDEVH $IF .NOT. UCX$DEVC THEN CONFIG_TXT = "''CONFIG_TXT'  * Not Configured *" $IF UCX$NEW_DEVICE $THENn $SAY " "F $SAY "	The ''UCX$DEV_TXT' device(s) on your system are: ''CONFIG_TXT'" $ELSEY@ $SAY "	                                           ''CONFIG_TXT'" $ENDIFI $UCX$VALID_LIST = UCX$VALID_LIST + " ''UCX$VMSDEV'''UCX$DEV':''UCX$DEVC'" & $UCX$VALID_ITEMS = UCX$VALID_ITEMS + 1 $UCX$NEW_DEVICE = "FALSE"m $GOTO NEXT_CONTROLLER  $END_FIND_DEVICES: $UCX$ASSIGNED_LIST = "0" $UCX$BROAD_MASK_LIST = "0" $UCX$CLUSTER = 0 $UCX$NET_MASK_LIST = "0" $UCX$USED_ITEMS = 0E $UCX$USED_LIST = ""S $UCX$USED_SIZE = 0 $UCX$VALID_ELE = 04 $IF UCX$VALID_ITEMS .EQ. 0 THEN GOTO NO_MORE_DEVICES $GET_NEXT_DEVICE:M $SET ONX" $UCX$VALID_ELE = UCX$VALID_ELE + 1 $DEFINE_NEXT_DEVICE:8 $UCX$TEMP = F$ELEMENT (UCX$VALID_ELE," ",UCX$VALID_LIST)0 $IF UCX$TEMP .EQS. " " THEN GOTO NO_MORE_DEVICES. $UCX$VMSDEV = F$ELEMENT (0,":",UCX$TEMP) + ":"% $UCX$DEV = F$ELEMENT (1,":",UCX$TEMP)D& $UCX$DEVC = F$ELEMEN                                                                                                                                                                                                                                                   B                        wk3 $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                         "     c       T (2,":",UCX$TEMP) $TEMP = F$TYPE (UCX$DEVC)E $SAY " "% $IF UCX$CLUSTER THEN GOTO SET_CLUSTERLK $SAY "	Start of configuration questions for Internet interface ''UCX$DEV'."$ $GOTO GET_HOST_NAMEA
 $SET_CLUSTER:"J $SAY "	Start of cluster host questions for Internet interface ''UCX$DEV'." $UCX$NAME_TXT = "CLUSTER "> $UCX$NET_DEF = F$ELEMENT (UCX$VALID_ELE," ",UCX$NET_MASK_LIST)B $UCX$BROAD_DEF = F$ELEMENT (UCX$VALID_ELE," ",UCX$BROAD_MASK_LIST) $GET_HOST_NAME:U# $UCX$TEMP = F$EXTRACT (1,1,UCX$DEV)M $UCX$TEMP = "UCX$''UCX$TEMP'TXTT $UCX$DEV_TXT = 'UCX$TEMP'E= $SAY "	''UCX$DEV' is the ''UCX$DEV_TXT' device ''UCX$VMSDEV'"U $UCX$INTE_P0 == "0"r $UCX$INTE_P1 == "0"i $UCX$INTE_P2 == "0"F $UCX$INTE_P3 == "0"R $UCX$INTE_C0 == "0"  $UCX$INTE_C1 == "0"a $UCX$INTE_C2 == "0"n $UCX$INTE_C3 == "0"A $IF .NOT. UCX$DEVC $THENV* $SAY "	''UCX$DEV' has not been configured" $RECON = ""S $ELSE 
 $RECON = "re"G	 $SET NOONT- $UCX SHOW CONFIG INTER 'UCX$DEV' /FULL/CONFIG' $IF UCX$CLUSTERT $THEN  $UCX$INTE_P0 == UCX$INTE_C0$ $UCX$INTE_P1 == UCX$INTE_C1T $UCX$INTE_P2 == UCX$INTE_C2R $UCX$INTE_P3 == UCX$INTE_C3E $SET ON  $ENDIF $ENDIF $SAY " " $SKIP_INTE = 0N $call ask_binary "Do you want to ''RECON'configure ''UCX$DEV'" Y ucx$gl_result/ $if .not. ucx$gl_status then goto END_INTERFACER $if .not. ucx$gl_resultX $THEN , $IF .NOT. UCX$DEVC THEN GOTO GET_NEXT_DEVICE $UCX$NEW_ADDRESS = UCX$INTE_P1 $UCX$NET_MASK = UCX$INTE_P2_ $UCX$BROAD_MASK = UCX$INTE_P3H $SKIP_INTE = 1 $GOTO SET_USED_ADDRESS $ENDIF $UCX$DEFAULT = ""X@ $IF UCX$INTE_P0 .NES. "0" THEN UCX$DEFAULT = " [''UCX$INTE_P0']" $XHOSTNAME1: $UCX$HOST_NAME = "" 7 $READ/END_OF_FILE=XHOSTNAME SYS$COMMAND UCX$HOST_NAME -UD /PROMPT="Enter unqualified ''UCX$NAME_TXT'host name''UCX$DEFAULT': " $XHOSTNAME:_= $IF f$locate("""",UCX$HOST_NAME) .NE. f$length(UCX$HOST_NAME)A $THENQ $SAY " "N $SAY "Quotes are not required to preserve case, please reenter without quotes" $SAY " " $GOTO XHOSTNAME1 $ENDIF $IF UCX$HOST_NAME .EQS. "" $THEN , $IF .NOT. UCX$DEVC THEN GOTO GET_NEXT_DEVICE- $IF UCX$DEVC THEN UCX$HOST_NAME = UCX$INTE_P0, $ENDIF# $IF UCX$HOST_NAME .NES. UCX$INTE_P0  $THENV $UCX$INTE_P1 == 0N $UCX$INTE_P2 == 0  $UCX$INTE_P3 == 0X $ENDIF$ $hlen = F$LENGTH("''UCX$HOST_NAME'") $IF UCX$DOMAIN_NAME .NES. "" $THEN,9 $dpos = F$LOCATE("''UCX$DOMAIN_NAME'","''UCX$HOST_NAME'")G $IF DPOS .NE. HLEN $THENE4 $IF F$EXTRACT(dpos-1,1,"''UCX$HOST_NAME'") .EQS. "." $THENC& $dlen = F$LENGTH("''UCX$DOMAIN_NAME'") $IF HLEN-DPOS .EQ. DLEN THEN -6 UCX$HOST_NAME = F$EXTRACT(0,dpos-1,"''UCX$HOST_NAME'") $HLEN = hlen - (dlen+1)  $ENDIF $ENDIF $ENDIF( $dpos = F$LOCATE(".","''UCX$HOST_NAME'") $IF DPOS .NE. HLEN $THENUJ $SAY "The ''UCX$HOST_NAME host name string contains a ""."". This string "/ $SAY "may incorrectly contain the domain name."V] $call ask_binary "Is ''UCX$HOST_NAME' the the correct unqualified host name?" Y ucx$gl_result , $if .not. ucx$gl_status then goto XHOSTNAME1, $if .not. ucx$gl_result then goto XHOSTNAME1 $ENDIF $UCX$NEW_HOST = 0D $UCX$MODIFY_HOST = 0 $UCX$PRIME_NAME = " "  $UCX$ADDRESS_LIST = " "O	 $SET NOON" $DEFINE/USER SYS$ERROR NL:1 $UCX GENERATE HOST /LOCAL/NAME "''UCX$HOST_NAME'""- $IF .NOT. $STATUS THEN GOTO ERROR_HOST_ACCESSeL $IF UCX$CONFIG_P1 .NES. " " THEN UCX GENERATE HOST /LOCAL "''UCX$CONFIG_P1'" $UCX$PRIME_NAME = UCX$CONFIG_P1L! $UCX$ADDRESS_LIST = UCX$CONFIG_P2E $UCX$REMAIN = 0 + UCX$CONFIG_P3V $IF UCX$GL_DEBUG $THENE6 $WRITE SYS$OUTPUT "UCX$PRIME_NAME = ''ucx$prime_name'": $WRITE SYS$OUTPUT "UCX$ADDRESS_LIST = ''ucx$address_list'". $WRITE SYS$OUTPUT "UCX$REMAIN = ''ucx$remain'" $ENDIF5 $IF UCX$PRIME_NAME .EQS. " " THEN GOTO HOST_NOT_FOUNDU $HOST_FOUND: $SET OND $UCX$PRIME_ADDRESS = " " $UCX$ADDRESSES = 0 $SAY " "D $SAY "	''UCX$NAME_TXT'Host ''UCX$HOST_NAME' exists in the database."- $IF UCX$HOST_NAME .NES. UCX$PRIME_NAME THEN - 9 SAY "	''UCX$HOST_NAME is an alias for ''UCX$PRIME_NAME'."T, $IF UCX$REMAIN .GT. 1 THEN GOTO HOST_FOUND_1% $UCX$PRIME_ADDRESS = UCX$ADDRESS_LISTFG $IF F$LOCATE(UCX$PRIME_ADDRESS,UCX$USED_LIST) .LT. UCX$USED_SIZE THEN -  GOTO HOST_FOUND_2E $SAY " " $GOTO ASK_ADDRESSH $HOST_FOUND_1: $SAY " "1 $SAY "	This host has multiple Internet addresses"t0 $IF UCX$USED_ITEMS .EQ. 0 THEN GOTO HOST_FOUND_3 $HOST_FOUND_2: $SAY " "5 $SAY "	Addresses which have been assigned to another"'7 $SAY "	interface are flagged with ""*"", and cannot be"(: $IF UCX$CLUSTER THEN SAY "	assigned to this cluster host."= $IF .NOT. UCX$CLUSTER THEN SAY "	assigned to this interface."  $SAY " " $HOST_FOUND_3:1 $SAY "	The Internet addresses for this host are:"D $SAY " " $DISPLAY_ADDRESS_LOOP:A $UCX$ONE_ADDRESS = F$ELEMENT (UCX$ADDRESSES,",",UCX$ADDRESS_LIST) 8 $IF UCX$ONE_ADDRESS .EQS. "," THEN GOTO ASK_MULT_ADDRESS7 $UCX$ONE_ADDRESS = F$EDIT (UCX$ONE_ADDRESS, "COLLAPSE")  $UCX$FLAG = " "0E $IF F$LOCATE(UCX$ONE_ADDRESS,UCX$USED_LIST) .LT. UCX$USED_SIZE THEN -  UCX$FLAG = "*"; $SAY "                      ''UCX$FLAG' ''UCX$ONE_ADDRESS'"U? $IF UCX$FLAG .EQS. " " .AND. UCX$PRIME_ADDRESS .EQS. " " THEN -T# UCX$PRIME_ADDRESS = UCX$ONE_ADDRESSU5 $IF UCX$FLAG .EQS. "*" .AND. UCX$REMAIN .NE. 0 THEN -R UCX$REMAIN = UCX$REMAIN - 1E" $UCX$ADDRESSES = UCX$ADDRESSES + 1 $GOTO DISPLAY_ADDRESS_LOOP $NO_MORE_DEVICES:  $GOTO NO_MORE_DEVICES1 $ASK_MULT_ADDRESS: $SAY " "
 $ASK_ADDRESS:a $UCX$INTE_D1 = 0 $UCX$DEFADDR = ""t: $IF UCX$REMAIN .NE. 0 THEN UCX$DEFADDR = UCX$PRIME_ADDRESS8 $IF UCX$INTE_P1 .NES. "0" THEN UCX$DEFADDR = UCX$INTE_P1 $IF UCX$DEFADDR .EQS. "" $THEN  $UCX$DEFAULT = ""_ $ELSE1# $UCX$DEFAULT = " [''UCX$DEFADDR'] "X $ENDIF# $READ SYS$COMMAND UCX$NEW_ADDRESS -N0 /PROMPT="Enter Internet address''UCX$DEFAULT': "? $IF UCX$NEW_ADDRESS .EQS. "" THEN UCX$NEW_ADDRESS = UCX$DEFADDR$ $IF UCX$NEW_ADDRESS .EQS. "" $THENi $GOSUB ERROR_INVALID_ADDRESS $GOTO ASK_ADDRESSO $ENDIF: $IF UCX$NEW_ADDRESS .NES. UCX$INTE_P1 THEN UCX$INTE_D1 = 1 $CHECK_ADDRESS:YF $IF UCX$NEW_ADDRESS .EQS. UCX$PRIME_ADDRESS THEN GOTO CHECK_ADDRESS_1A	 $SET NOON" $DEFINE/USER SYS$ERROR NL:) $UCX CHECK HOST_ADDRESS 'UCX$NEW_ADDRESS' % $IF $STATUS THEN GOTO CHECK_ADDRESS_1_ $GOSUB ERROR_INVALID_ADDRESS $GOTO ASK_ADDRESSE $CHECK_ADDRESS_1:C  $UCX$NEW_ADDRESS = UCX$CONFIG_P2 $CHECK_ADDRESS_1A:3 $IF UCX$USED_ITEMS .EQ. 0 THEN GOTO CHECK_ADDRESS_2 E $IF F$LOCATE(UCX$NEW_ADDRESS,UCX$USED_LIST) .GE. UCX$USED_SIZE THEN -E GOTO CHECK_ADDRESS_2 $GOSUB ERROR_ADDRESS_INUSE $GOTO ASK_ADDRESSP $CHECK_ADDRESS_2:E5 $IF F$LOCATE(UCX$NEW_ADDRESS,UCX$ADDRESS_LIST) .GE. - 1 F$LENGTH (UCX$ADDRESS_LIST) THEN UCX$NEW_HOST = 1 ) $IF .NOT. UCX$NEW_HOST THEN GOTO ASK_NETM  $DEFINE/USER SYS$ERROR NL:0 $UCX GENERATE HOST /LOCAL/NAME 'UCX$NEW_ADDRESS'5 $IF UCX$CONFIG_P1 .EQS. " " THEN GOTO CHECK_ADDRESS_3I $GOSUB ERROR_DUP_ADDRESS $GOTO ASK_ADDRESST $CHECK_ADDRESS_3:i0 $IF UCX$REMAIN .EQ. 0 THEN GOTO SET_MULT_ADDRESSD $IF UCX$ADDRESSES .EQ. 0 .AND. .NOT. UCX$NEW_HOST THEN GOTO ASK_NETM $TYPE SYS$INPUTc $DECKl  : 	You have specified an alternate address  for  this  host.  : 	If you would like the host  to  be  a  gateway, in  otherA         words, a host with multiple addresses, then answer YES toM 	the following question.    : 	If you would like to modify the host's  Internet  address: 	in the UCX$HOST database, then answer NO to the following
 	question.   $ EODSJ $call ask_binary "Define multiple addresses for this host" Y ucx$gl_result/ $if .not. ucx$gl_status then goto END_INTERFACEE, $if ucx$gl_result then goto set_mult_address $DELETE_UCX_HOST:C $UCX$MODIFY_HOST = 1 $GOTO ASK_NETM $SET_MULT_ADDRESS: $UCX$ADDRESSES = 1 $GOTO ASK_NETM $HOST_NOT_FOUND: $UCX$PRIME_NAME = UCX$HOST_NAMES $UCX$ADDRESSES = 0 $UCX$NEW_HOST = 1E $UCX$INTE_D1 = 1 $ASK_HOST_NOT_FOUND: $SET ON_# $READ SYS$COMMAND UCX$NEW_ADDRESS -U7 /PROMPT="Enter Internet address for ''UCX$HOST_NAME': "Y	 $SET NOONM $DEFINE/USER SYS$ERROR NL:) $UCX CHECK HOST_ADDRESS 'UCX$NEW_ADDRESS' ( $IF $STATUS THEN GOTO CHECK_ADDRESS_NF_1 $GOSUB ERROR_INVALID_ADDRESS $GOTO ASK_HOST_NOT_FOUND $CHECK_ADDRESS_NF_1:  $UCX$NEW_ADDRESS = UCX$CONFIG_P2 $DEFINE/USER SYS$ERROR NL:0 $UCX GENERATE HOST /LOCAL/NAME 'UCX$NEW_ADDRESS'. $IF UCX$CONFIG_P1 .EQS. " " THEN GOTO ASK_NETM $GOSUB ERROR_DUP_ADDRESS $GOTO ASK_HOST_NOT_FOUND
 $ASK_NETM:$ $IF UCX$CLUSTER THEN GOTO ASK_NETM_1	 $SET NOONE $DEFINE/USER SYS$ERROR NL:, $UCX GENERATE NETWORK_MASK 'UCX$NEW_ADDRESS' $UCX$NET_DEF = UCX$CONFIG_P2 $ASK_NETM_1: $UCX$INTE_D2 = 08 $IF UCX$INTE_P2 .NES. "0" THEN UCX$NET_DEF = UCX$INTE_P2 $SET ONs  $READ SYS$COMMAND UCX$NET_MASK -M /PROMPT="Enter Internet network mask for ''UCX$HOST_NAME' [''UCX$NET_DEF']: "N- $IF UCX$NET_MASK .NE                                                                                                                                                                                                                                                   C                        ^Ľ $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                        Q^ "     t       S. "" THEN GOTO CHECK_NETs $UCX$NET_MASK = UCX$NET_DEFA $GOTO ASK_BROADM $CHECK_NET:=7 $IF UCX$NET_MASK .NES. UCX$INTE_P2 THEN UCX$INTE_D2 = 1$	 $SET NOON  $DEFINE/USER SYS$ERROR NL:& $UCX CHECK MASK_ADDRESS 'UCX$NET_MASK'  $IF $STATUS THEN GOTO ASK_BROADM $SAY " "- $SAY "	Invalid Internet network mask format."L $SAY " " $GOTO ASK_NETM_1 $ASK_BROADM:& $IF UCX$CLUSTER THEN GOTO ASK_BROADM_1 $DEFINE/USER SYS$ERROR NL:L $UCX GENERATE BROADCAST_MASK 'UCX$NEW_ADDRESS'/ NETWORK_MASK= 'UCX$NET_MASK' $UCX$BROAD_DEF = UCX$CONFIG_P2 $ASK_BROADM_1: $UCX$INTE_D3 = 0: $IF UCX$INTE_P3 .NES. "0" THEN UCX$BROAD_DEF = UCX$INTE_P3 $SET ONS" $READ SYS$COMMAND UCX$BROAD_MASK -H /PROMPT="Enter broadcast mask for ''UCX$HOST_NAME' [''UCX$BROAD_DEF']: "1 $IF UCX$BROAD_MASK .NES. "" THEN GOTO CHECK_BROAD  $UCX$BROAD_MASK = UCX$BROAD_DEFF $GOTO ADDRESSES_OK
 $CHECK_BROAD:N9 $IF UCX$BROAD_MASK .NES. UCX$INTE_P3 THEN UCX$INTE_D3 = 1A	 $SET NOON" $DEFINE/USER SYS$ERROR NL:( $UCX CHECK MASK_ADDRESS 'UCX$BROAD_MASK'" $IF $STATUS THEN GOTO ADDRESSES_OK $SAY " " $SAY "	Invalid broadcast mask."r $SAY " " $GOTO ASK_BROADM_1 $ADDRESSES_OK: $SET ON ! $IF "''UCX$DOMAIN_NAME'" .NES. ""  $THEN_' $DOMAIN_NAME = "."+"''UCX$DOMAIN_NAME'"V $ELSED $DOMAIN_NAME = ""R $ENDIF $SAY " "; $SAY "	The following parameters will be used to define the"K $IF .NOT. UCX$CLUSTER_ $THEN & $SAY "	Internet interface ''UCX$DEV':" $SAY " ": $SAY "		Host name:         ''UCX$HOST_NAME'''DOMAIN_NAME'" $ELSEU7 $SAY "	cluster host for Internet interface ''UCX$DEV':"  $SAY " ": $SAY "		CLUSTER host name: ''UCX$HOST_NAME'''DOMAIN_NAME'" $ENDIF. $SAY "		Internet address:  ''UCX$NEW_ADDRESS'"+ $SAY "		Network mask:      ''UCX$NET_MASK'"S- $SAY "		Broadcast mask:    ''UCX$BROAD_MASK'"T $SAY " "7 $call ask_binary "Is the above correct" Y ucx$gl_resultD/ $if .not. ucx$gl_status then goto END_INTERFACEE4 $if .not. ucx$gl_result then goto define_next_device
 $MODIFY_HOST:C1 $IF .NOT. UCX$MODIFY_HOST THEN GOTO MODIFY_HOST_1C	 $SET NOONT $DEFINE/USER SYS$ERROR NL:- $UCX SET NOHOST/NOCONFIRM "''UCX$PRIME_NAME'"A $SET ONE $MODIFY_HOST_1:C $UCX$HOST_OPT = ""4 $UCX$UPCASE_NAME = F$EDIT (UCX$PRIME_NAME, "UPCASE")@ $IF UCX$UPCASE_NAME .EQS. UCX$PRIME_NAME THEN GOTO MODIFY_HOST_2	 $SET NOON_ $DEFINE/USER SYS$ERROR NL:0 $UCX GENERATE HOST /LOCAL/NAME 'UCX$UPCASE_NAME' $SET ONPK $IF UCX$CONFIG_P1 .EQS. " " THEN UCX$HOST_OPT = "/ALIAS=''UCX$UPCASE_NAME'"h $MODIFY_HOST_2:oL $IF .NOT. UCX$NEW_HOST .AND. UCX$HOST_OPT .EQS. "" THEN GOTO END_MODIFY_HOST	 $SET NOONr $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL: H $UCX SET HOST "''UCX$PRIME_NAME'" /ADDR='UCX$NEW_ADDRESS' 'UCX$HOST_OPT' $END_MODIFY_HOST:n7 $IF UCX$ADDRESSES .EQ. 0 THEN CONF_HOST = UCX$HOST_NAME_9 $IF UCX$ADDRESSES .NE. 0 THEN CONF_HOST = UCX$NEW_ADDRESSe- $IF UCX$CLUSTER THEN GOTO DEFINE_CLUSTER_HOSTE $UCX$NET_DEF = UCX$NET_MASKn $UCX$BROAD_DEF = UCX$BROAD_MASKC8 $IF UCX$INTE_D1 .OR. UCX$INTE_D2 .OR. UCX$INTE_D3 THEN -V UCX SET CONF INTE 'UCX$DEV'/HOST='CONF_HOST'/NETW='UCX$NET_MASK'/BROA='UCX$BROAD_MASK' $IF UCX$USED_ITEMS .EQ. 00 $THENN $IF UCX$LOCAL_NAME .EQS. ""1 $THENH	 $SET NOONN. $UCX SET CONFIG COMM/LOCAL="''UCX$PRIME_NAME'" $DEFINE/USER SYS$OUTPUT NL:d $DEFINE/USER SYS$ERROR NL: $UCX GENERATE DOMAIN $IF .NOT. $STATUS: $THENCB $WARN "UCX$CONFIG ERROR: Error while generating valid domain name" $ENDIF, $UCX$LOCAL_NAME = F$TRNLNM ("UCX$INET_HOST") $SET ONU $ENDIF $ENDIF $SET_USED_ADDRESS:6 $UCX$USED_LIST = UCX$USED_LIST + " " + UCX$NEW_ADDRESS$ $UCX$USED_ITEMS = UCX$USED_ITEMS + 1) $UCX$USED_SIZE = F$LENGTH (UCX$USED_LIST)TA $UCX$BROAD_MASK_LIST = UCX$BROAD_MASK_LIST + " " + UCX$BROAD_MASKK; $UCX$NET_MASK_LIST = UCX$NET_MASK_LIST + " " + UCX$NET_MASKF $IF .NOT. SKIP_INTE: $THENG $SAY " "H $SAY "	End of configuration questions for Internet interface ''UCX$DEV'" $SAY " " $ENDIF $GOTO GET_NEXT_DEVICE0 $DEFINE_CLUSTER_HOST:X8 $IF UCX$INTE_D1 .OR. UCX$INTE_D2 .OR. UCX$INTE_D3 THEN -Z UCX SET CONF INTE 'UCX$DEV'/CLUS='CONF_HOST'/C_NETW='UCX$NET_MASK'/C_BROA='UCX$BROAD_MASK' $SAY " "G $SAY "	End of cluster host questions for Internet interface ''UCX$DEV'"E $SAY " " $GOTO GET_NEXT_DEVICEU $NO_MORE_DEVICES1:4 $IF UCX$VALID_ITEMS .EQ. 0 THEN GOTO ERROR_NO_DEVICE' $IF UCX$CLUSTER THEN GOTO END_INTERFACEIC $IF .NOT. F$GETSYI ("CLUSTER_MEMBER") .OR. UCX$VALID_ITEMS .EQ. 0 -w THEN GOTO END_INTERFACE" $TYPE SYS$INPUTM $DECKK    & 	This CPU is a member of a VMScluster.  7 	You may specify that the Internet interface(s) on thisA0 	CPU will participate in an Internet VMScluster.  7 	An Internet VMScluster can be configured so  that  all_7 	cluster members appear to remote network  hosts  as  aX 	single virtual host.A  7 	The Internet VMScluster is identified by  its  clusters7 	host name and address, and must be activated  on  eachA8 	of  the   hosts  that  are  members  of  the  Internet          VMScluster.    $ EOD_ $SET ONK= $call ask_binary "Define Internet VMScluster" N ucx$gl_result / $if .not. ucx$gl_status then goto END_INTERFACEX/ $if .not. ucx$gl_result then goto END_INTERFACE  $INIT_CLUSTER_HOST:K $UCX$CLUSTER = 1 $UCX$VALID_ELE = 1 $GOTO DEFINE_NEXT_DEVICE $END_INTERFACE:E $INFORM " "T	 $RETURN 1' $EXIT_INTERFACE: $SAY " "C $WARN "	WARNING - Error encountered during interface configuration"A $SAY " " $RETURN $STATUS  $ERROR_HOST_ACCESS:p $SAY " ": $WARN "	WARNING - could not access the UCX$HOST database." $SAY " "
 $RETURN 44 $ERROR_NO_DEVICE:  $SAY " "J $WARN "	WARNING - no Ethernet device on system ,''f$getsyi(""nodename"")'" $SAY " "
 $RETURN 44
 $UCX$ROUTING:U $SAY " "$ $SAY "DYNAMIC ROUTING Configuration" $SAY " " $UCX$VAL_OPTA = 1E% $IF .NOT. UCX$LICENSE_RUN THEN EXIT 1'	 $SET NOOND $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL: $UCX SHOW CONFIG START ROUTI $IF $STATUS  $THEN"	 $TEMP = 1_
 $RECON = "re"a $UCX SHOW CONFIG START ROUTI $ELSEn	 $TEMP = 0s $RECON = ""t $SAY " "0 $SAY "	Dynamic routing has not been configured." $ENDIF $TYPE SYS$INPUTC $DECKN  5 	If you enable dynamic routing, this host will listen 6 	for all dynamic routing information coming from other. 	hosts to update its internal routing tables. 2 	It will also supply its own Internet addresses to) 	routing requests made from remote hosts.E   $ EODR $SET ONTS $call ask_binary "Do you want to ''RECON'configure dynamic routing" Y ucx$gl_resultO- $if .not. ucx$gl_status then goto END_ROUTINGO* $if ucx$gl_result then goto ROUTING_CONFIG	 $SET NOONA $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:. $UCX SHOW ROUTE/DEFAULT/PERM $IF $STATUS_ $THENS
 $RECON = "re"N9 $SAY "The current configuration for the default route is:T $UCX SHOW ROUTE/DEFAULT/PERM $ELSEN $RECON = ""U $SAY " "0 $SAY "	A default route has not been configured." $ENDIFS $call ask_binary "Do you want to ''RECON'configure a default route" Y ucx$gl_resultI- $if .not. ucx$gl_status then goto END_ROUTINGU- $if .not. ucx$gl_result then goto END_ROUTINGX $GET_DEF_GATE: $UCX$DEFAULT_GATE = ""5 $READ/END_OF_FILE=XGDG SYS$COMMAND UCX$DEFAULT_GATE -D; /PROMPT="Enter your Default Gateway host name or address: "' $XGDG:C $IF f$locate("""",UCX$DEFAULT_GATE) .NE. f$length(UCX$DEFAULT_GATE)S $THENN $SAY " "N $SAY "Quotes are not required to preserve case, please reenter without quotes" $SAY " " $GOTO GET_DEF_GATE $ENDIF	 $SET NOON  $DEFINE/USER SYS$ERROR NL:4 $UCX GENERATE HOST /LOCAL/NAME "''UCX$DEFAULT_GATE'". $IF .NOT. $STATUS .OR. UCX$CONFIG_P1 .EQS. " " $THEN) $DEFINE/USER SYS$ERROR NL:- $UCX CHECK HOST_ADDRESS "''UCX$DEFAULT_GATE'"I $IF .NOT. $STATUSA $THEN  $SAY " "> $SAY "	''UCX$DEFAULT_GATE' is not in the local host database." $SAY " " $INVALID_GATEWAY_ADDR:$ $READ SYS$COMMAND UCX$DEFGATE_ADDR -: /PROMPT="Enter Internet address for ''UCX$DEFAULT_GATE': " $DEFINE/USER SYS$ERROR NL:* $UCX CHECK HOST_ADDRESS 'UCX$DEFGATE_ADDR' $IF .NOT. $STATUSe $THENt $GOSUB ERROR_INVALID_ADDRESS $GOTO INVALID_GATEWAY_ADDR $ENDIF $DEFINE/USER SYS$ERROR NL:1 $UCX GENERATE HOST /LOCAL/NAME 'UCX$DEFGATE_ADDR'C $IF UCX$CONFIG_P1 .NES. " "S $THENH $GOSUB ERROR_DUP_ADDRESS7 $INFORM "WARNING: Default gateway route is not defined"  $SAY " " $SET ONI $GOTO END_ROUTING' $ENDIF $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL: ? $UCX SET HOST "''UCX$DEFAULT_GATE'" /ADDRESS='UCX$DEFGATE_ADDR'S $ELSEN $SAY " "> $SAY "	''UCX$DEFAULT_GATE' is not in the local host database."B $SAY "	If you want to enter the default gateway in the local host"< $SAY "	database, enter its host name. Otherwise, enter <CR>. $SAY " " $XX_REENT_GNAME: $UCX$GATEWAY_NAM = ""l4 $READ/END_OF_FILE=XGRE SYS$COMMAND UCX$GATEW                                                                                                                                                                                                                                                   D                        X_c $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                        R "            AY_NAM -2 /PROMPT="Enter the Default Gateway host name []: " $XGRE:A $IF f$locate("""",UCX$GATEWAY_NAM) .NE. f$length(UCX$GATEWAY_NAM)A $THENe $SAY " "N $SAY "Quotes are not required to preserve case, please reenter without quotes" $SAY " " $GOTO XX_REENT_GNAME $ENDIF $IF UCX$GATEWAY_NAM .NES. "" $THEN  $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:a> $UCX SET HOST "''UCX$GATEWAY_NAM'" /ADDRESS='UCX$DEFAULT_GATE' $ENDIF $SAY " " $ENDIF $ENDIF $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:_' $UCX SET NOROUTE/DEFAULT/PERM/NOCONFIRML $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:I9 $UCX SET ROUTE/DEFAULT/PERM/GATEWAY="''UCX$DEFAULT_GATE'"	 $SET ON  $GOTO END_ROUTINGu $ROUTING_CONFIG: $ROUT_SUPPLY = "F" $ROUT_DEF = "F"U $IF TEMP $THENCW $call ask_binary "Do you want to disable dynamic routing configuration" N ucx$gl_resultR- $if .not. ucx$gl_status then goto END_ROUTING	 $if ucx$gl_resulte $THENe $INFORM " "'; $SAY "	Dynamic routing will now be configured as disabled."U $SAY " "	 $SET NOONA $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:  $UCX SET CONFIG START NOROUTIE $GOTO END_ROUTING  $ENDIF $ENDIF $TYPE SYS$INPUTF $DECKR  6 	If you enable the 'supply' option of dynamic routing,5 	this host will supply dynamic routing information toS6 	other hosts on the network whether it is acting as an 	internetwork gateway or not.b   $ EODgb $call ask_binary "Do you want this host to supply its dynamic routing information" N ucx$gl_result- $if .not. ucx$gl_status then goto set_routingm- $if .not. ucx$gl_result then goto set_routinga $ROUTING_OPTION: $ROUT_SUPPLY = "T" $TYPE SYS$INPUT  $DECKu  3 	There can be one and only one host on your networkO.         which defines a default network route.  B         If you want this host to supply the default network route,8         then all packets which cannot be routed to their: 	destination host or network will be routed via this host.     $ EODL\ $call ask_binary "Do you want this host to supply the default network route" N ucx$gl_result- $if .not. ucx$gl_status then goto END_ROUTING - $if .not. ucx$gl_result then goto set_routing" $ROUT_DEF = "T"u
 $SET_ROUTING:t $IF ROUT_SUPPLY .EQS. "T"  $THENs $IF ROUT_DEF .EQS. "T" $THENN, $UCX SET CONFIG START ROUTI /SUPPLY=DEFAULT" $ELSEt# $UCX SET CONFIG START ROUTI /SUPPLYU $ENDIF $ELSE$% $UCX SET CONFIG START ROUTI /NOSUPPLYD $ENDIF
 $END_ROUTING:G	 $RETURN 1R $UCX$TIMEZONE: $UCX$VAL_OPTA = 1X $askgeo:/ $IF CONFIG_OPTS .EQS. "" THEN CALL CLEAR_SCREENn $type sys$input' $deck:   TIME ZONE ConfigurationA  C 	Please answer the following questions to configure your time zone.t  B 	Select your geographic area using the options in the table below.   		Selection	Geographic AreaE" 		-------------------------------- 		u		USA 		ea		Eastern Australia/ 		ca		Central Australia" 		wa		Western AustraliaU 		ee		Eastern Europe 		ce		Central Europe 		we		Western Europe 		g 		Greenwich $ 		n		None of the above (enter hours) 	       [E]		Exit menu! 		-------------------------------n     $ eodh6 $READ SYS$COMMAND GEOLOC /PROMPT="Enter your choice: "1 $GEOLOC = F$EDIT(GEOLOC, "TRIM,UNCOMMENT,UPCASE")r& $if geoloc .eqs. "" then goto  TZ_Exit* $geoloc_list = "/U/EA/CA/WA/EE/CE/WE/G/N/"J $if f$locate("/''geoloc'/", geoloc_list) .lt. f$length(geoloc_list) then - $ goto TZ_Proceed18 $if f$extract(0, 1, geoloc) .eqs. "E" then goto  TZ_Exit $goto askgeo
 $TZ_Proceed1:C) $geoloc = f$fao("!AS!AS", geoloc, "_geo") 6 $if (geoloc .eqs. "N_geo") .OR. (geoloc .eqs. "G_geo") $then  $dstdef = "FALSE"t $goto 'geoloc' $endif $say " "	 $dstloop:Tl $READ SYS$COMMAND DAYSAV /PROMPT="Does your area alternate between Daylight Savings and Standard time [Y]: "1 $DAYSAV = F$EDIT(DAYSAV, "TRIM,UNCOMMENT,UPCASE")" $if daysav .eqs. ""i $thenn $dstdef = "TRUE" $goto 'geoloc' $endif  $daysav = f$extract (0,1,daysav) $if daysav .eqs. "N" $thent $dstdef = "FALSE"s	 $dst = ""e $goto 'geoloc' $endif $if daysav .eqs. "Y" $thenG $dstdef = "TRUE" $goto 'geoloc' $elseS $say "Please answer YES or NO"
 $goto dstloope $endif $U_geo:h/ $IF CONFIG_OPTS .EQS. "" THEN CALL CLEAR_SCREENE $type sys$inpute $deckX  6 	Select the time zone for your area, using the options 	listed in the table below.    		Selection	Time Zone  		-------------------------- 		e		Eastern 		c		Central
 		m		MountainE 		p		Pacific 		g 		Greenwich  		-------------------------    $ 	eod8 $READ SYS$COMMAND TIMEZONE /PROMPT="Enter your choice: "5 $TIMEZONE = F$EDIT(TIMEZONE, "TRIM,UNCOMMENT,UPCASE"):% $if timezone .eqs. "" then goto U_geoT $timezone_list = "E/C/M/P/G/"L0 $if f$locate(timezone+"/", timezone_list) .eq. -' f$length(timezone_list) then goto U_geoE- $timezone = f$fao("!AS!AS", timezone, "_std")_ $goto 'timezone' $E_std:  $std = "EST"
 $stdval = "5" + $if dstdef then dst = "EDT4,M4.1.0,M10.5.0"o
 $goto doneasks $C_std:m $std = "CST"
 $stdval = "6"c+ $if dstdef then dst = "CDT5,M4.1.0,M10.5.0"t
 $goto doneask  $M_std:l $std = "MST"
 $stdval = "7"'+ $if dstdef then dst = "MDT6,M4.1.0,M10.5.0"e
 $goto doneaskU $P_std:" $std = "PST"
 $stdval = "8"S+ $if dstdef then dst = "PDT7,M4.1.0,M10.5.0"X
 $goto doneaskR $G_std:E $G_geo:N $std = "GMT"
 $stdval = "0"T $if dstdef then dst = ""
 $goto doneaskt $EA_geo: $std = "EST" $stdval = "-10"t $if dstdef then dst = "EST"r
 $goto doneaski $CA_geo: $std = "CST" $stdval = "-10:30" $if dstdef then dst = "CST"w
 $goto doneaskn $WA_geo: $std = "WST" $stdval = "-8" $if dstdef then dst = ""
 $goto doneaskt $EE_geo: $std = "EET" $stdval = "-2" $if dstdef then dst = "DST"e
 $goto doneask  $CE_geo: $std = "MET" $stdval = "-1" $if dstdef then dst = "MET DST"Y
 $goto doneaskY $WE_geo: $std = "WET"
 $stdval = "0"n $if dstdef then dst = "WET DST" 
 $goto doneaske $N_geo:e $say " "E $say "	You may enter the number of hours (-12 to 12) in time west of"r $say "	Greenwich." $say " "@ $READ SYS$COMMAND TIMEZONE /PROMPT="Enter the number of hours: "5 $TIMEZONE = F$EDIT(TIMEZONE, "TRIM,UNCOMMENT,UPCASE")i% $if timezone .eqs. "" then goto N_geoh	 $std = ""e( $stdval = f$fao("!AS!AS","GMT",timezone)	 $dst = "" 	 $doneask:N $if .not. dstdef $then$' $logname = f$fao("!AS!AS", std, stdval)E $elseu/ $logname = f$fao("!AS!AS!AS", std, stdval, dst)E $endif $mcc_tdf == -(stdval)E? $ucx set configuration time "''logname'" /DIFFER = "''mcc_tdf'"T $say " "	 $TZ_Exit:S	 $RETURN 1D $ucx$ask_shutdown:8 $IF .NOT.F$GETDVI("BG:","EXISTS") THEN GOTO EXIT_ASKSHUT5 $IF .NOT.F$GETDVI("BG:","MNT") THEN GOTO EXIT_ASKSHUT  $TYPE SYS$INPUTE $DECKT  E 	In order to complete this configuration, the DIGITAL TCP/IP ServicesoG 	for OpenVMS software must be shutdown. If you DO NOT want the softwaret9 	to be shutdown now, answer NO to the following question.a   $ EOD.: $call ask_binary "Do you want to continue" N ucx$gl_result. $if .not. ucx$gl_status then goto exit_askshut $if ucx$gl_resulti $thena $@SYS$MANAGER:UCX$SHUTDOWN.COM! $@SYS$MANAGER:UCX$UCP_STARTUP.COM	 $endif $EXIT_ASKSHUT:	 $RETURN 1  $ucx$bind_resolver:o $SAY " "" $SAY "BIND RESOLVER Configuration" $SAY " "	 $SET NOON- $UCX$VAL_OPTA = 1h $UCX$NAME_P0 == "" $UCX$NAME_P1 == "0"  $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:U $UCX SHOW CONFIG NAME /FULL  $IF .NOT. $STATUS  $THEN_ $TYPE SYS$INPUTW $DECK/) 	A BIND resolver has not been configured.c  H 	DIGITAL TCP/IP Services for OpenVMS supports the Berkeley Internet NameH 	Domain (BIND) resolver.  BIND is a network service that enables clientsF 	to name resources or objects and share information with other objects 	on the network.  > 	Before configuring your system as a BIND resolver, you should? 	first be sure that there is at least one system on the networka< 	configured as either a BIND primary or secondary server for
 	this domain.T $       EODM $ELSEE3 $SAY "A BIND resolver has already been configured." " $UCX SHOW CONFIG NAME /FULL/CONFIG $SET ONx $SAY " "B $call ask_binary "Do you want to reconfigure BIND" N ucx$gl_resultA $if ucx$gl_status .AND. ucx$gl_result then goto START_NEXT_SERVER 	 $RETURN 1t $ENDIF $SAY " " $SET ONl $TYPE SYS$INPUTr $DECKg6 	You can specify a BIND server by its address or name;4 	however, if specified by name, an entry for it must  	exist in the UCX$HOST database.  0 	You will be asked one question for each server.2 	Press Return at the prompt to terminate the list.   $ EODE $START_NEXT_SERVER:  $UCX$SERVER_LIST = ""c $UCX$SERVER_ELE = 0  $UCX$BIND_CONFIG = 0 $GET_NEXT_SERVER:  $UCX$BIND_SERVER = ""O9 $READ/END_OF_FILE=XSRVRNAME SYS$COMMAND UCX$BIND_SERVER -N) /PROMPT = "Enter your BIND server name: ".                                                                                                                                                                                                                                                   E                          $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                         "             $XSRVRNAME:gA $IF f$locate("""",UCX$BIND_SERVER) .NE. f$length(UCX$BIND_SERVER)/ $THENz $SAY " "N $SAY "Quotes are not required to preserve case, please reenter without quotes" $SAY " " $GOTO GET_NEXT_SERVER' $ENDIF: $IF UCX$BIND_SERVER .EQS. "" .AND. UCX$SERVER_ELE .EQ. 0 - .AND. UCX$NAME_P1 .EQS. "0"e $THENC $SAY " "( $INFORM "	WARNING : No servers defined."8 $SAY "	          The BIND resolver will not be enabled." $SAY " "	 $RETURN 1  $ENDIF9 $IF UCX$BIND_SERVER .EQS. "" THEN GOTO DEFINE_BIND_PARAMSU	 $SET NOON  $DEFINE/USER SYS$ERROR NL:3 $UCX GENERATE HOST /LOCAL/NAME "''UCX$BIND_SERVER'" . $IF .NOT. $STATUS .OR. UCX$CONFIG_P1 .EQS. " " $THEN0 $DEFINE/USER SYS$ERROR NL:, $UCX CHECK HOST_ADDRESS "''UCX$BIND_SERVER'" $IF .NOT. $STATUSs $THENe $SAY " "= $SAY "	''UCX$BIND_SERVER' is not in the local host database."" $SAY " " $INVALID_SERVER_ADDR:g# $READ SYS$COMMAND UCX$SERVER_ADDR - 9 /PROMPT="Enter Internet address for ''UCX$BIND_SERVER': "E	 $SET NOONd $DEFINE/USER SYS$ERROR NL:) $UCX CHECK HOST_ADDRESS 'UCX$SERVER_ADDR' ) $IF $STATUS THEN GOTO CHECK_SERVER_ADDR_2  $GOSUB ERROR_INVALID_ADDRESS $GOTO INVALID_SERVER_ADDRs $CHECK_SERVER_ADDR_2:0 $DEFINE/USER SYS$ERROR NL:0 $UCX GENERATE HOST /LOCAL/NAME 'UCX$SERVER_ADDR'6 $IF UCX$CONFIG_P1 .EQS. " " THEN GOTO ADD_SERVER_ENTRY $GOSUB ERROR_DUP_ADDRESS $GOTO GET_NEXT_SERVERY $ADD_SERVER_ENTRY:	 $SET NOONe $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:R= $UCX SET HOST "''UCX$BIND_SERVER'" /ADDRESS='UCX$SERVER_ADDR'  $SET ONe $ELSEa $SAY " "= $SAY "	''UCX$BIND_SERVER' is not in the local host database."d9 $SAY "	If you want to enter the server in the local host"u> $SAY "	database, enter the server name. Otherwise, enter <CR>. $SAY " "" $READ SYS$COMMAND UCX$SERVER_NAM -, /PROMPT="Enter remote BIND server name []: " $IF UCX$SERVER_NAM .NES. ""u $THENs	 $SET NOONI $DEFINE/USER SYS$ERROR NL: $DEFINE/USER SYS$OUTPUT NL:I< $UCX SET HOST "''UCX$SERVER_NAM'" /ADDRESS='UCX$BIND_SERVER' $SET ON  $ENDIF $SAY " " $ENDIF $ENDIFF $IF UCX$SERVER_ELE .NE. 0 THEN UCX$SERVER_LIST = UCX$SERVER_LIST + ","$ $UCX$SERVER_ELE = UCX$SERVER_ELE + 19 $UCX$SERVER_LIST = UCX$SERVER_LIST + "''UCX$BIND_SERVER'"  $GOTO GET_NEXT_SERVERc $DEFINE_BIND_PARAMS:3 $IF UCX$SERVER_ELE .EQ. 0 THEN GOTO DEFINE_BIND_DOMs $NUM = 0 $UCX$LIST = "" $SET_NEXT_SERVER:l6 $UCX$BIND_SERVER = F$ELEMENT(NUM,",", UCX$SERVER_LIST)- $IF NUM .NE. 0 THEN UCX$LIST = UCX$LIST + "," 3 $UCX$LIST = UCX$LIST + """""''UCX$BIND_SERVER'"""""D $NUM = NUM + 15 $IF NUM .NE. UCX$SERVER_ELE THEN GOTO SET_NEXT_SERVERX	 $SET NOON  $DEFINE/USER SYS$OUTPUT NL:F $DEFINE/USER SYS$ERROR NL: $UCX SET CONFIG NONAME1 $UCX SET CONFIG NAME /CONFIG /SERVER=('UCX$LIST')  $DEFINE_BIND_DOM:N* $IF UCX$DOMAIN_NAME .NES. "" THEN RETURN 1	 $TEMP = 0c $IF MENUA_TODO_N .EQ. 0 .OR. -I F$LOCATE (":''MA_DOMN'",MENUA_TODO_L) .EQ. F$LENGTH (MENUA_TODO_N) THEN -D TEMP = 1 $IF TEMP .EQ. 0 THEN RETURN 1s $TYPE SYS$INPUTc $DECKb  1 	You must provide the domain name in order to runh8 	the BIND resolver. This information should be available* 	from your Internet network administrator.  4 	You will now be asked to configure the domain name. $ EOD S $MENUA_TODO_L = "0:''MA_DOMN'" + F$EXTRACT(1,F$LENGTH(MENUA_TODO_L)-1,MENUA_TODO_L)   $MENUA_TODO_N = MENUA_TODO_N + 1	 $RETURN 1  $UCX$REM_TODO: $RNUM = 'UCX$MENU_TODO_N'x& $IF RNUM .EQ. 0 THEN GOTO END_REM_MENU $RELE = ":''UCX$MENU_TODO_ELE'"e% $RTOTL = F$LENGTH ('UCX$MENU_TODO_L')s+ $RSUBL = F$LOCATE (RELE, 'UCX$MENU_TODO_L') " $IF RSUBL .EQ. RTOTL THEN RETURN 1 $RNUM = RNUM - 1 $'UCX$MENU_TODO_N' = RNUMv& $IF RNUM .EQ. 0 THEN GOTO END_REM_MENU $RELEL = F$LENGTH (RELE)@ $'UCX$MENU_TODO_L' = F$EXTRACT (0, RSUBL, 'UCX$MENU_TODO_L') + -3 F$EXTRACT (RSUBL + RELEL, RTOTL, 'UCX$MENU_TODO_L')t $IF RNUM .NE. 0 THEN RETURN 1. $END_REM_MENU: $'UCX$MENU_TODO_L' = "0"	 $RETURN 1" $UCX$SERV_MENU:L	 $SET NOONX/ $IF CONFIG_OPTS .EQS. "" THEN CALL CLEAR_SCREENE $IF UCX$PSEUDO $THENF $TSRV = UCX$SO  $IF (UCX$SO .EQS. "NTPD") .OR. - (UCX$SO .EQS. "METRIC") .OR. - (UCX$SO .EQS. "RMT") $THEN$ $TEMP2 = "''TSRV' SERVER") $UCX$SO = "" $ELSEN $TEMP2 = "''TSRV' CLIENT"" $ENDIF $ELSEa $TSRV = UCX$ENA_SRVe $TEMP2 = "''TSRV' SERVER"w $ENDIF $SAY " " $SAY "''TEMP2' Configuration"  $SAY " " $IF UCX$CDIR .NES. ""  $THEN.
 $TEMP = "" $DEFINE/USER SYS$OUTPUT NL:P $DEFINE/USER SYS$ERROR NL: $UCX$UAF SHOW 'UCX$CDIR'$ $IF .NOT. $STATUS THEN TEMP = "not "/ $SAY "Service is ''TEMP'defined in the SYSUAF."  $ENDIF $UCX$SERV_P0 == "0"I $UCX$SERVS = 0 $IF .NOT. UCX$PSEUDO $THENM $DEFINE/USER SYS$OUTPUT NL:S $DEFINE/USER SYS$ERROR NL:. $UCX SHOW SERV 'UCX$ENA_SRV' /PERM/FULL/CONFIG $UCX$SERVS = $STATUS
 $TEMP = "" $IF .NOT. UCX$SERVS/ $THENS $TEMP = "not " $UCX$SERV_P0 == "1"' $ENDIF= $SAY "Service is ''TEMP'defined in the UCX$SERVICE database."B $ENDIF $UCX$APROXS = UCX$SERV_P0t $IF (UCX$APROX .AND. UCX$SERVS)S $THEND
 $TEMP = ""+ $IF UCX$APROXS .EQS. "0" THEN TEMP = "not "r- $SAY "  Application proxy is ''TEMP'enabled."S $SAY " "A $SAY "By default, DIGITAL TCP/IP Services for OpenVMS configures"R= $SAY "services to require proxies for remote access.  If thisV? $SAY "restriction is removed, any host on the network will have - $SAY "unrestricted access to ''UCX$ENA_SRV'."/ $SAY " " $ENDIF $UCX$CONFS = 0 $IF UCX$HASCONF .NES. "" $THEN  $DEFINE/USER SYS$OUTPUT NL:R $DEFINE/USER SYS$ERROR NL: $UCX SHOW CONF 'UCX$ENA_SRV' $UCX$CONFS = $STATUS
 $TEMP = ""& $IF .NOT. UCX$CONFS THEN TEMP = "not "I $SAY "Configuration is ''temp'defined in the UCX$CONFIGURATION database."a $ENDIF $UCX$ENABS = 0 $TMP = 17 $IF .NOT. UCX$SERVS .AND. .NOT. UCX$PSEUDO THEN TMP = 0a2 $IF .NOT. UCX$CONFS .AND. UCX$HASCONF THEN TMP = 0
 $IF .NOT. TMPt $THENe $IF UCX$CLUSTER, $THEN< $DEFINE/USER SYS$OUTPUT NL:M $DEFINE/USER SYS$ERROR NL:0 $UCX SET CONF ENABL NOSERV 'UCX$ENA_SRV' /COMMON $ENDIF $DEFINE/USER SYS$OUTPUT NL:I $DEFINE/USER SYS$ERROR NL:( $UCX SET CONF ENABL NOSERV 'UCX$ENA_SRV' $ENDIFL $IF UCX$CLUSTER .AND. .NOT. F$GETSYI ("CLUSTER_MEMBER") THEN UCX$CLUSTER = 0 $UCX$CLUSTS = UCX$CLUSTERE $UCX$PRIVS = "0" $UCX$SERV_P1 == "0"E $IF UCX$SERVS .OR. UCX$PSEUDO  $THENV $DEFINE/USER SYS$OUTPUT NL:= $DEFINE/USER SYS$ERROR NL:0 $UCX SHOW CONF ENABL SERVI 'UCX$ENA_SRV' /CONFIG $IF $STATUS  $THENV $UCX$ENABS = 1) $IF UCX$PRIV THEN UCX$PRIVS = UCX$SERV_P1S $ENDIF $IF UCX$CLUSTERl $THENB $DEFINE/USER SYS$OUTPUT NL:" $DEFINE/USER SYS$ERROR NL:8 $UCX SHOW CONF ENABL SERVI 'UCX$ENA_SRV' /CONFIG /COMMON $IF $STATUSC $THENS $UCX$ENABS = UCX$ENABS + 2@ $IF UCX$ENABS .EQ. 2 .AND. UCX$PRIV THEN UCX$PRIVS = UCX$SERV_P1 $ENDIF $ENDIF $ENDIF $IF UCX$PRIV $THENR
 $TEMP = ""+ $IF UCX$APROXS .EQS. "0" THEN TEMP = "not "A5 $SAY "  Nonprivileged user access is ''TEMP'enabled."I $SAY " "A $SAY "By default, DIGITAL TCP/IP Services for OpenVMS configures" E $SAY "LPD such that nonprivileged users cannot modify queue entries."_ $SAY " " $ENDIF $UCX$DIS_APXS = "" $UCX$DIS_COMS = "" $UCX$DIS_PRVS = "" $UCX$DIS_SPES = "" $UCX$ENA_APXS = "" $UCX$ENA_COMS = "" $UCX$ENA_PRVS = "" $UCX$ENA_SPES = "" $IF UCX$ENABS .EQ. 0 $THENr: $IF F$TRNLNM ("UCX$''UCX$ENA_SRV'_ENABLE") .NES. "" THEN -- DEASSIGN/SYSTEM/EXEC UCX$'UCX$ENA_SRV'_ENABLE  $UCX$ENA_COMS = "UCX$ENA_COM"L $UCX$ENA_SPES = "UCX$ENA_SPE"O; $IF CONFIG_OPTS .EQS. "" THEN SAY "Service is not enabled."T $ELSER
 $IF UCX$ENABS_ $THENx $IF UCX$ENABS .EQ. 1 $THENN $UCX$DIS_SPES = "UCX$DIS_SPE"U $UCX$ENA_COMS = "UCX$ENA_COM"  $IF CONFIG_OPTS .EQS. "" THEN -L* SAY "Service is enabled on specific node." $ELSEO $UCX$ENA_SPES = "UCX$DIS_SPE"- $UCX$DIS_COMS = "UCX$DIS_COM"  $IF CONFIG_OPTS .EQS. "" THEN -_7 SAY "Service is enabled on specific and cluster nodes."T $ENDIF $ELSE  $UCX$ENA_SPES = "UCX$ENA_SPE"C $UCX$DIS_COMS = "UCX$DIS_COM"EH $IF CONFIG_OPTS .EQS. "" THEN SAY "Service is enabled on cluster nodes." $ENDIF $ENDIF $IF .NOT. UCX$CLUSTS $THENS $UCX$ENA_COMS = "" $UCX$DIS_COMS = "" $ENDIF $IF CONFIG_OPTS .EQS. "" $THENF $SAY " "' $SAY "	''TEMP2' configuration options:"  $SAY " " $UCX$SERV_MENU_L = "0" $UCX$SERV_MENU_N = 0 $IF UCX$ENA_COMS .NES. ""V $THENU& $UCX$SERV_MENU_N = UCX$SERV_MENU_N + 19 $SAY "		''UCX$SERV_MENU_N' - Enable service on all nodes"SF $UCX$SERV_MENU_L = UCX$SERV_MENU_L + ":''UCX$SERV_MENU_N'*UCX$ENA_COM" $ENDIF $IF UCX$ENA_SPES .NES. ""T $THEN"& $UCX$SERV_MENU_N = UCX$SERV_MENU_N + 19 $SAY "		''UCX$SERV_MENU_N' - Enable service on this node"AF $UCX$SERV_MENU_L = UCX$SERV_MENU_L + ":''UCX$SERV_MENU_N'*UCX$ENA_SPE" $ENDIF $IF UCX$DIS_COMS .NES. ""X $THEN=& $UCX$SERV_MENU_N = UCX$S                                                                                                                                                                                                                                                   F                        L]& $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                        ! "            ERV_MENU_N + 1: $SAY "		''UCX$SERV_MENU_N' - Disable service on all nodes"F $UCX$SERV_MENU_L = UCX$SERV_MENU_L + ":''UCX$SERV_MENU_N'*UCX$DIS_COM" $ENDIF $IF UCX$DIS_SPES .NES. ""M $THENt& $UCX$SERV_MENU_N = UCX$SERV_MENU_N + 1: $SAY "		''UCX$SERV_MENU_N' - Disable service on this node"F $UCX$SERV_MENU_L = UCX$SERV_MENU_L + ":''UCX$SERV_MENU_N'*UCX$DIS_SPE" $ENDIF $IF (UCX$APROX .AND. UCX$SERVS)T $THENP $IF UCX$APROXS .EQS. "0" $THENr& $UCX$SERV_MENU_N = UCX$SERV_MENU_N + 12 $SAY "		''UCX$SERV_MENU_N' - Require proxy access"E $UCX$SERV_MENU_L = UCX$SERV_MENU_L +":''UCX$SERV_MENU_N'*UCX$ENA_APX"i $UCX$ENA_APXS = "UCX$ENA_APX"d $ELSEo& $UCX$SERV_MENU_N = UCX$SERV_MENU_N + 17 $SAY "		''UCX$SERV_MENU_N' - Proxy access not required"UE $UCX$SERV_MENU_L = UCX$SERV_MENU_L +":''UCX$SERV_MENU_N'*UCX$DIS_APX"  $UCX$DIS_APXS = "UCX$DIS_APX": $ENDIF $ENDIF# $IF UCX$PRIV .AND. UCX$ENABS .NE. 0  $THEN  $IF UCX$PRIVS .EQ. "0" $THENM& $UCX$SERV_MENU_N = UCX$SERV_MENU_N + 1O $SAY "		''UCX$SERV_MENU_N' - Non-privileged users can delete LPD queue entries" E $UCX$SERV_MENU_L = UCX$SERV_MENU_L +":''UCX$SERV_MENU_N'*UCX$ENA_PRV"$ $UCX$ENA_PRVS = "UCX$ENA_PRV"P $ELSEI& $UCX$SERV_MENU_N = UCX$SERV_MENU_N + 1R $SAY "		''UCX$SERV_MENU_N' - Non-privileged users cannot delete LPD queue entries"E $UCX$SERV_MENU_L = UCX$SERV_MENU_L +":''UCX$SERV_MENU_N'*UCX$DIS_PRV"D $UCX$DIS_PRVS = "UCX$DIS_PRV"S $ENDIF $ENDIF& $UCX$SERV_MENU_N = UCX$SERV_MENU_N + 1 $SAY " ". $SAY "		E - Exit ''UCX$ENA_SRV' configuration" $SAY " "7 $UCX$SERV_MENU_L = UCX$SERV_MENU_L + ":E*UCX$SERV_EXIT"= $ELSE  $CLUSTFLG = "" $IF CONFIG_OPTS .EQS. "1"F $THENR, $IF P3 .EQS. "CLUSTER" THEN GOTO UCX$ENA_COM $GOTO UCX$ENA_SPEL $ENDIF, $IF P3 .EQS. "CLUSTER" THEN GOTO UCX$DIS_COM $GOTO UCX$DIS_SPEC $ENDIF $SET ONR $ASK_SERV_MENU:SB $READ SYS$COMMAND SERV_OPTA /PROMPT="Enter configuration option: "7 $SERV_OPTA = F$EDIT(SERV_OPTA, "TRIM,UNCOMMENT,UPCASE")$. $IF SERV_OPTA .EQS. "" THEN GOTO UCX$SERV_EXIT  $IF F$EXTRACT(0, 1, SERV_OPTA) -! .EQS. "E" THEN GOTO UCX$SERV_EXITU	 $TEMP = 0U $ASK_SERV_MENU_L:  $TEMP = TEMP + 1 $IF TEMP .GT. UCX$SERV_MENU_N  $THEN$> $SAY "Invalid configuration option selected, please try again" $SAY " " $GOTO ASK_SERV_MENUS $ENDIF/ $TEMPELE = F$ELEMENT (TEMP,":",UCX$SERV_MENU_L)n$ $TEMPOPT = F$ELEMENT (0,"*",TEMPELE) $IF TEMPOPT .EQS. SERV_OPTAd $THENu% $TEMPROUT = F$ELEMENT (1,"*",TEMPELE)S $CLUSTFLG = "" $GOTO 'TEMPROUT' $ENDIF $GOTO ASK_SERV_MENU_L 
 $UCX$DIS_COM:A $CLUSTFLG = "/COMMON" 
 $UCX$DIS_SPE:P	 $SET NOONU3 $UCX SET CONF ENABL NOSERV 'UCX$ENA_SRV' 'CLUSTFLG'$ $GOTO UCX$SERV_EXITA
 $UCX$ENA_COM:. $CLUSTFLG = "/COMMON"N
 $UCX$ENA_SPE:X $IF UCX$CDIR .NES. "" THEN -H CALL CREATE_ACCOUNT 'UCX$CDIR' 'UCX$CP' 'UCX$CCOM' 'UCX$CDEV' 'UCX$CNUM' $IF .NOT. UCX$SERVSr $THEN  $GOSUB UCX$'UCX$ENA_SRV'_SET) $IF .NOT. $STATUS THEN GOTO UCX$SERV_MENUE $ENDIF $GOSUB UCX$'UCX$ENA_SRV'_ACT $IF .NOT. $STATUSE $THEN 0 $IF CONFIG_OPTS .EQS. "" THEN GOTO UCX$SERV_MENU $SAY " "1 $SAY "*** ''UCX$ENA_SRV' will NOT be enabled ***"S $SAY " " $GOTO UCX$SERV_EXITS $ENDIF3 $IF UCX$PSEUDO THEN CLUSTFLG = CLUSTFLG + "/PSEUDO"b1 $UCX SET CONF ENABL SERV 'UCX$ENA_SRV' 'CLUSTFLG'  $GOTO UCX$SERV_EXITX
 $UCX$DIS_APX:X+ $UCX SET SERVICE 'UCX$ENA_SRV' /FLAG=NOAPPLE $GOTO UCX$SERV_MENUi
 $UCX$ENA_APX:n) $UCX SET SERVICE 'UCX$ENA_SRV' /FLAG=APPL  $GOTO UCX$SERV_MENUU
 $UCX$DIS_PRV:"	 $SET NOONC $CLUSTFLG = ""2 $UCX SET CONF ENAB NOSERV 'UCX$ENA_SRV' 'CLUSTFLG'3 $IF UCX$PSEUDO THEN CLUSTFLG = CLUSTFLG + "/PSEUDO"R0 $UCX SET CONF ENAB SERV 'UCX$ENA_SRV' 'CLUSTFLG' $GOTO UCX$SERV_MENUU
 $UCX$ENA_PRV:U	 $SET NOONR $CLUSTFLG = ""2 $UCX SET CONF ENAB NOSERV 'UCX$ENA_SRV' 'CLUSTFLG'3 $IF UCX$PSEUDO THEN CLUSTFLG = CLUSTFLG + "/PSEUDO"R8 $UCX SET CONF ENAB SERV 'UCX$ENA_SRV' /NOPRIV 'CLUSTFLG' $GOTO UCX$SERV_MENUE $UCX$SERV_EXIT:E$ $IF UCX$SO .EQS. "NFS" THEN RETURN 1! $IF UCX$SO .EQS. "" THEN RETURN 1XA $IF CONFIG_OPTB .EQS. "" .AND. CONFIG_OPTC .EQS. "" THEN RETURN 1 & $IF CONFIG_OPTS .NES. "" THEN RETURN 1
 $TEMP = ""	 $SET NOONU $DEFINE/USER SYS$OUTPUT NL:' $DEFINE/USER SYS$ERROR NL:+ $UCX SHOW CONF ENABL SERVI 'UCX$SO' /CONFIGS" $IF $STATUS THEN GOTO UCX$SERV_SOE $IF UCX$CLUSTERF $THENC $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL:3 $UCX SHOW CONF ENABL SERVI 'UCX$SO' /CONFIG /COMMONi" $IF $STATUS THEN GOTO UCX$SERV_SOE $ENDIF $TEMP = " not" $UCX$SERV_SOE: $IF UCX$PSEUDO $THENI $TSRV = UCX$SO $TEMP2 = "''TSRV' SERVER" ! $UCX$MENU_TODO_L = "MENUC_TODO_L"S! $UCX$MENU_TODO_N = "MENUC_TODO_N"S $UCX$MENU_TODO_ELE = MC_'TSRV' $ELSEy $TSRV = UCX$ENA_SRVE $TEMP2 = "''TSRV' CLIENT"'! $UCX$MENU_TODO_L = "MENUB_TODO_L"X! $UCX$MENU_TODO_N = "MENUB_TODO_N"  $UCX$MENU_TODO_ELE = MB_'TSRV' $ENDIF $GOSUB UCX$REM_TODON $SAY " "& $SAY "The ''TEMP2' is''TEMP' enabled." $SAY " " $SET ONLD $call ask_binary "Do you want to configure ''TEMP2'" N ucx$gl_result% $if ucx$gl_status .AND. ucx$gl_resultE $THENE $CONFIG_OPTB = ""C $CONFIG_OPTC = ""T $GOSUB UCX$'UCX$SO'N $ENDIF	 $RETURN 1+ $UCX$BOOTP:' $UCX$VAL_OPTC = 1N $UCX$APROX = 0 $UCX$CDIR = "UCX$BOOTP"e $UCX$CP = 4X# $UCX$CCOM = "UCX$BOOTP_STARTUP.COM"C $UCX$CDEV = "SYS$SYSDEVICE" 
 $UCX$CNUM = 0  $UCX$CLUSTER = 1 $UCX$ENA_SRV = "BOOTP" $UCX$HASCONF = ""1
 $UCX$PRIV = 0$ $UCX$PSEUDO = 0n $GOSUB UCX$SERV_MENU	 $SET NOONP $DEFINE/USER SYS$OUTPUT NL:E $DEFINE/USER SYS$ERROR NL: $UCX SHOW CONF ENABL SERV TFTP $IF .NOT. $STATUSX $THENV $DEFINE/USER SYS$OUTPUT NL:_ $DEFINE/USER SYS$ERROR NL:& $UCX SHOW CONF ENABL SERV TFTP /COMMON $IF .NOT. $STATUS  $THEN" $SAY " "8 $SAY "	The TFTP service is not configured to be enabled" $SAY " "7 $INFORM "	WARNING: BOOTP will not function if the TFTP"L$ $SAY "	         service is disabled" $SAY " " $IF MENUC_TODO_N .EQ. 0 .OR. -B F$LOCATE (":''MC_TFTP'",MENUC_TODO_L) .EQ. F$LENGTH (MENUC_TODO_L) $THENU, $MENUC_TODO_L = MENUC_TODO_L + ":''MC_TFTP'"  $MENUC_TODO_N = MENUC_TODO_N + 1/ $SAY "	You will now be asked to configure TFTP"  $ELSEV1 $SAY "	You will be asked to configure TFTP later"C $ENDIF $SAY " " $ENDIF $ENDIF	 $RETURN 1$ $UCX$BOOTP_SET: , $SAY "Creating ''UCX$ENA_SRV' Service Entry"? $ucx set serv bootp /port=67/prot=udp/flag=ucx/user=ucx$bootp - 9 /proce=ucx$bootp/file='UCX$CDEV':['UCX$CDIR']'UCX$CCOM' -V? /log=(file:sys$sysdevice:[ucx$bootp]ucx$bootp_startup.log, all)  $RETURN $STATUSE $UCX$BOOTP_ACT:)	 $SET NOONP" $FILE_LOG = F$TRNLNM ("UCX$BOOTP")- $IF FILE_LOG .EQS. "" THEN GOTO TRY_BOOT_FILE % $FILE_NAME = F$SEARCH ("''FILE_LOG'")V% $IF FILE_NAME .NES. "" THEN RETUREN 1/ $SAY "	Creating ''FILE_LOG'" $GOTO UCX_CREATE_BOOTN $TRY_BOOT_FILE:N2 $FILE_NAME = F$SEARCH ("SYS$SYSTEM:UCX$BOOTP.DAT")$ $IF FILE_NAME .NES. "" THEN RETURN 11 $SAY "	Creating SYS$COMMON:[SYSEXE]UCX$BOOTP.DAT"CE $DEFINE/SYSTEM/EXECU/NOLOG UCX$BOOTP SYS$COMMON:[SYSEXE]UCX$BOOTP.DATC $UCX_CREATE_BOOT:G $UCX CREATE BOOTPR $RETURN $STATUS 	 $UCX$DNS:N $UCX$VAL_OPTC = 1E $UCX$APROX = 0 $UCX$CDIR = "UCX$BIND" $UCX$CP = 4A" $UCX$CCOM = "UCX$BIND_STARTUP.COM" $UCX$CDEV = "SYS$SPECIFIC"
 $UCX$CNUM = 0" $UCX$CLUSTER = 0 $UCX$ENA_SRV = "BIND"* $UCX$HASCONF = "" 
 $UCX$PRIV = 0  $UCX$PSEUDO = 0S $GOSUB UCX$SERV_MENU" $IF UCX$ENABS .EQ. 0 THEN RETURN 1* $IF UCX$DOMAIN_NAME .NES. "" THEN RETURN 1	 $TEMP = 0I $IF MENUA_TODO_N .EQ. 0 .OR. -I F$LOCATE (":''MA_DOMN'",MENUA_TODO_L) .EQ. F$LENGTH (MENUA_TODO_N) THEN -X TEMP = 1 $IF TEMP .EQ. 0 THEN RETURN 1G $TYPE SYS$INPUTU $DECKD  1 	You must provide the domain name in order to runN+ 	SMTP. This information should be availableS* 	from your Internet network administrator.   $ EODC; $INFORM "	You will be asked to configure the domain later."  $MENUA_TODO_L = "0:''MA_DOMN'"  $MENUA_TODO_N = MENUA_TODO_N + 1	 $RETURN 1A $UCX$BIND_SET:, $SAY "Creating ''UCX$ENA_SRV' Service Entry"L $ucx set serv bind /port=53/prot=tcp/flag=ucx/user=ucx$bind/proce=ucx$bind -9 /inact=0/limit=1/file='UCX$CDEV':['UCX$CDIR']'UCX$CCOM' -E< /log=(file:sys$specific:[ucx$bind]ucx$bind_startup.log, all)) $ucx set serv bind /protocol=udp/flag=ucxR $RETURN $STATUSO $UCX$BIND_ACT:	 $SET NOON  $DEFINE/USER SYS$OUTPUT NL:N $DEFINE/USER SYS$ERROR NL: $UCX SHOW CONFIG BIND /ON=*S $IF $STATUSL $THEN' $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL: $UCX SHOW CONFIG BINDD $IF $STATUSS $THEN 
 $UCX$DEFC = 1S $ELSEE $SAY " "< $SAY "This option cannot be performed on this cluster node." $SAY " "? $SAY "Another node in this cluster has already been configured"$; $SAY "as the Bind Server, and only one cluster node can be"U# $SAY "configured as a bind server."X $SAY " "C $WARN "You must be logged into the corre                                                                                                                                                                                                                                                   G                        %T $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                        # "            ct cluster node to perform"  $WARN "bind server operations."L $SAY " "	 $RETURN 0O $ENDIF $ENDIF $IF UCX$DOMAIN_NAME .EQS. "" $THENN $TYPE SYS$INPUTO $DECKM  1 	You must provide the domain name in order to runY6 	the BIND Server. This information should be available* 	from your Internet network administrator.  < 	You will be asked to configure the domain later.  After you: 	have performed this task, you may choose to configure the
 	BIND Server.D	 $     EOD  $INFORM " "P	 $TEMP = 0L $IF MENUA_TODO_N .EQ. 0 .OR. -I F$LOCATE (":''MA_DOMN'",MENUA_TODO_L) .EQ. F$LENGTH (MENUA_TODO_N) THEN -U TEMP = 1 $IF TEMP .NE. 0  $THENU $MENUA_TODO_L = "0:''MA_DOMN'"  $MENUA_TODO_N = MENUA_TODO_N + 1 $ENDIF	 $RETURN 0  $ENDIF $IF UCX$LOCAL_NAME .EQS. ""U $THENN: $SAY "	Cannot create NAMED.CA and NAMED.LOCAL because Core) $SAY "	Environment has not been defined."T $SAY " "	 $RETURN 0D $ENDIF< $IF F$SEARCH ("SYS$SPECIFIC:[UCX$BIND]NAMED.LOCAL") .EQS. "" $THENS2 $SAY "	Creating SYS$SPECIFIC:[UCX$BIND]NAMED.LOCAL< $IF F$SEARCH ("SYS$SPECIFIC:[UCX$BIND]NAMED.TMP") .NES. "" -4 THEN DELETE/NOLOG SYS$SPECIFIC:[UCX$BIND]NAMED.TMP;*4 $OPEN/WRITE UCX$DNS SYS$SPECIFIC:[UCX$BIND]NAMED.TMP $WRITE UCX$DNS ";"? $WRITE UCX$DNS "; BIND data file for local loopback interface."L $WRITE UCX$DNS ";"D $WRITE UCX$DNS "; Provided for DIGITAL TCP/IP Services for OpenVMS." $WRITE UCX$DNS ";"v $WRITE UCX$DNS "@	    IN	SOA	''UCX$LOCAL_NAME'.''ucx$domain_name'. postmaster.''UCX$LOCAL_NAME'.''ucx$domain_name'. ("' $WRITE UCX$DNS "			1986012101 ; Serial"B" $WRITE UCX$DNS "			3600	; Refresh" $WRITE UCX$DNS "			300	; Retry"r$ $WRITE UCX$DNS "			3600000	; Expire"% $WRITE UCX$DNS "			14400 )	; Minimum"UA $WRITE UCX$DNS "	    IN	NS	''UCX$LOCAL_NAME'.''ucx$domain_name'."oL $WRITE UCX$DNS "0	    IN	PTR	loopback.''UCX$LOCAL_NAME'.''ucx$domain_name'."( $WRITE UCX$DNS "1	    IN	PTR	localhost." $CLOSE UCX$DNSM $RENAME SYS$SPECIFIC:[UCX$BIND]NAMED.TMP SYS$SPECIFIC:[UCX$BIND]NAMED.LOCAL;0N/ $PURGE/NOLOG SYS$SPECIFIC:[UCX$BIND]NAMED.LOCALI $ENDIF9 $IF F$SEARCH ("SYS$SPECIFIC:[UCX$BIND]NAMED.CA") .EQS. ""S $THEN"/ $SAY "	Creating SYS$SPECIFIC:[UCX$BIND]NAMED.CA"< $IF F$SEARCH ("SYS$SPECIFIC:[UCX$BIND]NAMED.TMP") .NES. "" -4 THEN DELETE/NOLOG SYS$SPECIFIC:[UCX$BIND]NAMED.TMP;*' $CREATE SYS$SPECIFIC:[UCX$BIND]NAMED.CAG $DECKCF ;       This file holds the information on root name servers needed to8 ;       initialize cache of Internet domain name servers; ;       (e.g. reference this file in the "cache  .  <file>" 8 ;       configuration file of BIND domain name servers). ;=3 ;	Provided for DIGITAL TCP/IP Services for OpenVMS.R ;EE ;       This file is made available by InterNIC registration servicesE ;       under anonymous FTP as2 ;           file                /domain/named.root3 ;           on server           FTP.RS.INTERNIC.NET=/ ;       -OR- under Gopher at    RS.INTERNIC.NETUD ;           under menu          InterNIC Registration Services (NSI)> ;              submenu          InterNIC Registration Archives* ;           file                named.root ;i$ ;       last update:    Jan 22, 19972 ;       related version of root zone:   1997012200 ;  ;U ; formerly NS.INTERNIC.NET ;B? .                        3600000  IN  NS    A.ROOT-SERVERS.NET.s6 A.ROOT-SERVERS.NET.      3600000      A     198.41.0.4 ;$ ; formerly NS1.ISI.EDU ;l? .                        3600000      NS    B.ROOT-SERVERS.NET.u7 B.ROOT-SERVERS.NET.      3600000      A     128.9.0.107r ;c ; formerly C.PSI.NET ; ? .                        3600000      NS    C.ROOT-SERVERS.NET.N7 C.ROOT-SERVERS.NET.      3600000      A     192.33.4.12S ;I ; formerly TERP.UMD.EDUN ;S? .                        3600000      NS    D.ROOT-SERVERS.NET.B7 D.ROOT-SERVERS.NET.      3600000      A     128.8.10.90" ;  ; formerly NS.NASA.GOV ; ? .                        3600000      NS    E.ROOT-SERVERS.NET. : E.ROOT-SERVERS.NET.      3600000      A     192.203.230.10 ;e ; formerly NS.ISC.ORGt ;n? .                        3600000      NS    F.ROOT-SERVERS.NET.R7 F.ROOT-SERVERS.NET.      3600000      A     192.5.5.241r ;m ; formerly NS.NIC.DDN.MILa ;n? .                        3600000      NS    G.ROOT-SERVERS.NET.E8 G.ROOT-SERVERS.NET.      3600000      A     192.112.36.4 ;  ; formerly AOS.ARL.ARMY.MILu ; ? .                        3600000      NS    H.ROOT-SERVERS.NET.r7 H.ROOT-SERVERS.NET.      3600000      A     128.63.2.53  ;f ; formerly NIC.NORDU.NET ;r? .                        3600000      NS    I.ROOT-SERVERS.NET. 9 I.ROOT-SERVERS.NET.      3600000      A     192.36.148.17E ;_& ; temporarily housed at NSI (InterNIC) ;'? .                        3600000      NS    J.ROOT-SERVERS.NET.I7 J.ROOT-SERVERS.NET.      3600000      A     198.41.0.10M ;A& ; temporarily housed at NSI (InterNIC) ; ? .                        3600000      NS    K.ROOT-SERVERS.NET.r7 K.ROOT-SERVERS.NET.      3600000      A     198.41.0.11n
 ; End of Filee $    EOD, $PURGE/NOLOG SYS$SPECIFIC:[UCX$BIND]NAMED.CA $ENDIF	 $RETURN 1X	 $UCX$FTP:. $UCX$VAL_OPTB = 1T $UCX$VAL_OPTC = 1n $UCX$SO = "FTP_CLIENT" $UCX$APROX = 0 $UCX$CDIR = "UCX$FTP"I $UCX$CP = 10" $UCX$CCOM = "UCX$FTPD_STARTUP.COM" $UCX$CDEV = "SYS$SYSDEVICE"M
 $UCX$CNUM = 0/ $UCX$CLUSTER = 1 $UCX$ENA_SRV = "FTP" $UCX$HASCONF = ""D
 $UCX$PRIV = 0U $UCX$PSEUDO = 0t
 $UCX$BLM = 96l
 $UCX$DLM = 96f $UCX$ALM = 250 $GOSUB UCX$SERV_MENU" $DELETE/SYMBOL/LOCAL/NOLOG UCX$BLM" $DELETE/SYMBOL/LOCAL/NOLOG UCX$DLM" $DELETE/SYMBOL/LOCAL/NOLOG UCX$ALM	 $RETURN 1L
 $UCX$FTP_SET:m, $SAY "Creating ''UCX$ENA_SRV' Service Entry"C $ucx set serv ftp /port=21/flag=ucx/user=ucx$ftp/process=ucx$ftpd -X: /inact=5/limit=10/file='UCX$CDEV':['UCX$CDIR']'UCX$CCOM' -< /log=(file:sys$sysdevice:[ucx$ftp]ucx$ftpd_startup.log, all) $RETURN $STATUSW
 $UCX$FTP_ACT: 	 $RETURN 1U	 $UCX$LPD:M $UCX$VAL_OPTB = 1e $UCX$VAL_OPTC = 1S $UCX$SO = "LPD_CLIENT" $UCX$APROX = 1 $UCX$CDIR = "UCX_LPD"  $UCX$CP = 4S% $UCX$CCOM = "UCX$LPD_RCV_STARTUP.COM"D $UCX$CDEV = "SYS$SPECIFIC"
 $UCX$CNUM = 0P $UCX$CLUSTER = 0 $UCX$ENA_SRV = "LPD" $UCX$HASCONF = ""E
 $UCX$PRIV = 0] $UCX$PSEUDO = 0D $GOSUB UCX$SERV_MENU	 $RETURN 1U
 $UCX$LPD_SET:A, $SAY "Creating ''UCX$ENA_SRV' Service Entry"C $ucx set serv lpd /port=515/flag=ucx/user=ucx_lpd/process=ucx$lpd -.: /inact=5/limit=10/file='UCX$CDEV':['UCX$CDIR']'UCX$CCOM' -> /log=(file:sys$specific:[ucx_lpd]ucx$lpd_rcv_startup.log, all) $RETURN $STATUSo
 $UCX$LPD_ACT:t	 $SET NOON A $IF (F$SEARCH("SYS$SPECIFIC:[UCX_LPD]UCX$PRINTCAP.DAT")) .EQS. ""  $THENr< $SAY "Creating SYS$SPECIFIC:[UCX_LPD]UCX$PRINTCAP.DAT file."O $COPY/NOLOG SYS$MANAGER:UCX$PRINTCAP.DAT SYS$SPECIFIC:[UCX_LPD]UCX$PRINTCAP.DATrH $IF .NOT. $STATUS THEN SAY "%UCX-W-FNF - No Printcap source file found."D $SET FILE/PROTECTION=(S:RWED,O:RWED,G:RE,W:RE)/OWNER_UIC=[UCX_LPD] -& SYS$SPECIFIC:[UCX_LPD]UCX$PRINTCAP.DAT $ENDIF $SET ON  $TYPE SYS$INPUTe $DECK   A 	DIGITAL TCP/IP Services for OpenVMS supports Line Printer Daemon. 	Protocol (see RFC 1179)   	LPD requires the following: 	   - Name of the local queue  	   - Name of the remote queue 	   - Name of the remote hosti, 	   - Spooling directory for the local queue  G         To add or delete printers in the UCX PRINTCAP database, use the0-         $RUN SYS$SYSTEM:UCX$LPRSETUP command.    $ EOD  $INFORM " "0	 $RETURN 1 	 $UCX$NFS:R $UCX$VAL_OPTC = 1S! $ON CONTROL_Y THEN GOTO NFS_ABORT 	 $SET NOON  $DEFINE/USER SYS$OUTPUT NL:l $DEFINE/USER SYS$ERROR NL: $UCX$UAF SHOW UCX$NFST $IF .NOT. $STATUSO $THENE $READ SYS$COMMAND NUM_CLI - C /PROMPT="Approximately how many NFS Clients will be served? [10]: " ' $IF NUM_CLI .GT. 500 THEN NUM_CLI = 500 & $IF NUM_CLI .EQS. "" THEN NUM_CLI = 10 $ELSE.
 $NUM_CLI = 10  $ENDIF $SET ON. $UCX$APROX = 0 $UCX$CDIR = "UCX$NFS"0 $UCX$CP = 10! $UCX$CCOM = "UCX$NFS_STARTUP.TMP"S $UCX$CDEV = "SYS$SYSDEVICE"  $UCX$CNUM = NUM_CLIo $UCX$DEF = 1 $UCX$CLUSTER = 0 $UCX$ENA_SRV = "NFS" $UCX$HASCONF = ""T
 $UCX$PRIV = 0  $UCX$PSEUDO = 0T $GOSUB UCX$SERV_MENU" $IF UCX$ENABS .NE. 0 THEN RETURN 1	 $SET NOON  $DEFINE/USER SYS$OUTPUT NL:3 $DEFINE/USER SYS$ERROR NL:$ $UCX SHOW CONF ENABL SERV PORTMAPPER $IF .NOT. $STATUS9 $THEN4 $DEFINE/USER SYS$OUTPUT NL:. $DEFINE/USER SYS$ERROR NL:, $UCX SHOW CONF ENABL SERV PORTMAPPER /COMMON $IF .NOT. $STATUST $THEN3 $SAY " "> $SAY "	The portmapper service is not configured to be enabled" $SAY " "; $INFORM "	WARNING: NFS will not function if the portmapper"R$ $SAY "	         service is disabled" $SAY " " $IF MENUC_TODO_N .EQ. 0 .OR. -B F$LOCATE (":''MC_PORT'",MENUC_TODO_L) .EQ. F$LENGTH (MENUC_TODO_L) $THENS, $MENUC_TODO_L = MENUC_TODO_L + ":''MC_PORT'"  $MENUC_TOD                                                                                                                                                                                                                                                   H                        mк $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                        8 "            O_N = MENUC_TODO_N + 19 $SAY "	You will now be asked to configure the portmapper"S $ELSEO; $SAY "	You will be asked to configure the portmapper later"  $ENDIF $SAY " " $ENDIF $ENDIF	 $SET NOON  $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL: $UCX SHOW CONF TIMEr $IF .NOT. $STATUST $THEN3 $SAY " "+ $SAY "	A time zone has not been configured"D $SAY " "E $WARN "	WARNING: NFS will not function if a time zone is not defined"U $SAY " ": $SAY "	You will be asked to configure the time zone later" $SAY " " $IF MENUA_TODO_N .EQ. 0 .OR. -B F$LOCATE (":''MA_TIME'",MENUA_TODO_L) .EQ. F$LENGTH (MENUA_TODO_L) $THENC, $MENUA_TODO_L = MENUA_TODO_L + ":''MA_TIME'"  $MENUA_TODO_N = MENUA_TODO_N + 1 $ENDIF $ENDIF $SET ONU	 $RETURN 1l
 $UCX$NFS_SET:f, $SAY "Creating ''UCX$ENA_SRV' Service Entry"J $ucx set serv nfs /port=2049/prot=udp/flag=ucx/user=ucx$nfs/proc=ucx$nfs - /sock=(r:64000,s:64000) -R@ /limi=1/inac=0/file='UCX$CDEV':['UCX$CDIR']UCX$NFS_STARTUP.COM -9 /log=(f:sys$sysdevice:[ucx$nfs]ucx$nfs_startup.log,all) -e /RPC=(P=100003,V=(L=2,H=2))t% $IF .NOT. $STATUS THEN RETURN $STATUSO	 $SET NOON( $DEFINE/USER SYS$OUTPUT NL:c $DEFINE/USER SYS$ERROR NL: $UCX SHOW SERV MOUNT /FULL/PERMR $IF $STATUS THEN RETURN $STATUST* $SAY "Creating MOUNT pseudo Service Entry"D $ucx set serv mount /port=10/prot=udp/flag=ucx/user=ucx$nfs/limi=1 -( /proc=ucx$nfs_m/sock=(r:64000,s:64000) -9 /inac=0/file=sys$sysdevice:[ucx$nfs]ucx$nfs_startup.com -A9 /log=(f:sys$sysdevice:[ucx$nfs]ucx$nfs_startup.log,all) -D /RPC=(P=100005,V=(L=1,H=1))  $RETURN $STATUSL
 $UCX$NFS_ACT:"J $IF UCX$ENA_COMS .NES. "" THEN UCX SET CONFIG ENABLE SERVICE MOUNT /COMMONB $IF UCX$ENA_SPES .NES. "" THEN UCX SET CONFIG ENABLE SERVICE MOUNTL $IF UCX$DIS_COMS .NES. "" THEN UCX SET CONFIG ENABLE NOSERVICE MOUNT /COMMOND $IF UCX$DIS_SPES .NES. "" THEN UCX SET CONFIG ENABLE NOSERVICE MOUNTD $IF F$SEARCH ("SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_STARTUP.COM") .EQS. "" $THENg $SAY " "; $SAY "	Creating SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_STARTUP.COM":F $IF F$SEARCH ("SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_STARTUP.TMP") .NES. "" -> THEN DELETE/NOLOG SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_STARTUP.TMP;*@ $OPEN/WRITE UCX$START SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_STARTUP.TMP $WRITE UCX$START "$ !+"$+ $WRITE UCX$START "$ !  UCX$NFS_STARTUP.COM"U $CALL ADD_COPYRIGHT UCX$STARTe $WRITE UCX$START "$ !-"t0 $WRITE UCX$START "$ ON CONTROL_Y THEN GOTO EXIT" $WRITE UCX$START "$ SET NOON"  $WRITE UCX$START "$ !"% $WRITE UCX$START "$ IF P1 .NES. """""  $WRITE UCX$START "$ THEN"s( $WRITE UCX$START "$	FILE = F$SEARCH(P1)"' $WRITE UCX$START "$	IF FILE .EQS. """""r $WRITE UCX$START "$	THEN"a5 $WRITE UCX$START "$		VERSION = F$ELEMENT(1,"";"",P1)"a, $WRITE UCX$START "$		IF VERSION .EQS. "";""" $WRITE UCX$START "$		THEN"4 $WRITE UCX$START "$ 			NAME = F$ELEMENT(0,"";"",P1)"> $WRITE UCX$START "$ 			P1 = ""","'","'NAME'"" + "";"" + ""1""" $WRITE UCX$START "$		ENDIF"O $WRITE UCX$START "$		GOTO RUN" $WRITE UCX$START "$	ENDIF" $WRITE UCX$START "$!" 4 $WRITE UCX$START "$ 	NAME = F$ELEMENT(0,"";"",FILE)"* $WRITE UCX$START "$	FILE = F$SEARCH(NAME)"6 $WRITE UCX$START "$	VERSION = F$ELEMENT(1,"";"",FILE)"* $WRITE UCX$START "$	VERSION = VERSION + 1"K $WRITE UCX$START "$ 	P1 = ""","'","'NAME'"" + "";"" + ""","'","'VERSION'"""C $WRITE UCX$START "$	GOTO PURGE"X $WRITE UCX$START "$ ENDIF" $WRITE UCX$START "$!""8 $WRITE UCX$START "$ HOST = F$TRNLNM (""UCX$INET_HOST"")"E $WRITE UCX$START "$ HOST = F$EXTRACT(0, F$LOCATE (""."",HOST), HOST)"Ub $WRITE UCX$START "$ FILE = F$SEARCH(""SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_","'","'HOST'_LOGFILE.LOG"")"' $WRITE UCX$START "$ IF FILE .EQS. """""S $WRITE UCX$START "$ THEN" Y $WRITE UCX$START "$ 	P1 = ""SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_","'","'HOST'_LOGFILE.LOG;1"""p $WRITE UCX$START "$ 	GOTO RUN" $WRITE UCX$START "$ ENDIF" $WRITE UCX$START "$!" 3 $WRITE UCX$START "$ NAME = F$ELEMENT(0,"";"",FILE)"v6 $WRITE UCX$START "$ VERSION = F$ELEMENT(1,"";"",FILE)"* $WRITE UCX$START "$ VERSION = VERSION + 1"J $WRITE UCX$START "$ P1 = ""","'","'NAME'"" + "";"" + ""","'","'VERSION'""" $WRITE UCX$START "$!"E $WRITE UCX$START "$PURGE:"1 $WRITE UCX$START "$ FILE = F$ELEMENT(0,"";"",P1)"S. $WRITE UCX$START "$ PURGE/NOLOG/KEEP=4 'FILE'"4 $WRITE UCX$START "$ VERSION = F$ELEMENT(1,"";"",P1)"J $WRITE UCX$START "$ P1 = ""","'","'FILE'"" + "";"" + ""","'","'VERSION'""" $WRITE UCX$START "$!"  $WRITE UCX$START "$RUN:", $WRITE UCX$START "$ ON ERROR THEN GOTO EXIT"/ $WRITE UCX$START "$ DEFINE/USER SYS$ERROR 'P1'"n6 $WRITE UCX$START "$ RUN SYS$SYSTEM:UCX$SERVER_NFS.EXE" $WRITE UCX$START "$ !" $WRITE UCX$START "$EXIT:"Y $WRITE UCX$START "$ EXIT"  $CLOSE UCX$START4 $RENAME SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_STARTUP.TMP -, SYS$SYSDEVICE:[UCX$NFS]UCX$NFS_STARTUP.COM;0 $ENDIF1 $IF ("''F$TRNLNM ("UCX$EXPORT")'".EQS. "") THEN -DE DEFINE/SYSTEM/EXEC/NOLOG UCX$EXPORT SYS$COMMON:[SYSEXE]UCX$EXPORT.DAT $ $FILE_NAME = F$SEARCH ("UCX$EXPORT") $IF FILE_NAME .EQS. "" $THENc2 $SAY "	Creating SYS$COMMON:[SYSEXE]UCX$EXPORT.DAT" $UCX CREATE EXPORT $SAY " "G $INFORM " For security purposes the Export Database is created with no"sD $INFORM " world access. This denies non-privileged users the use of"5 $INFORM " commands which access the Export database."  $SAY " " $READ SYS$COMMAND ANS -UM /PROMPT="Do you want to grant world read access to non-privileged users? [N]"g+ $ANS = F$EDIT(ANS, "TRIM,UNCOMMENT,UPCASE")o' $IF ("''f$extract(0,1,ANS)'" .EQS. "Y")f $THEN1$ $SET FILE/PROT=W:RE/NOLOG UCX$EXPORT $SAY " ". $INFORM "	''FILE_NAME' Protection set to W:RE" $ENDIF $ENDIF	 $RETURN 1v $NO_NFSLIC:u $SAY " "2 $WARN "No NFS License loaded - NFS not configured" $SAY " " $RETURN 8596 $NFS_ERROR:$ $SAY " "2 $WARN "%UCX-F-NFSACC - Error in NFS configuration. $SAY " " $RETURN $STATUS. $NFS_ABORT:S' $IF "''F$TRNLNM("UCX$START")'" .NES. ""I $THEN. $CLOSE UCX$START $ENDIF
 $RETURN 44 $UCX$PCNFS:/ $UCX$VAL_OPTC = 1_ $UCX$APROX = 0 $UCX$CDIR = "UCX$PCNFS"N $UCX$CP = 4T$ $UCX$CCOM = "UCX$PCNFSD_STARTUP.COM" $UCX$CDEV = "SYS$SYSDEVICE" 
 $UCX$CNUM = 0Y $UCX$CLUSTER = 0 $UCX$ENA_SRV = "PCNFS" $UCX$HASCONF = ""C
 $UCX$PRIV = 0R $UCX$PSEUDO = 0E $GOSUB UCX$SERV_MENU" $IF UCX$ENABS .NE. 0 THEN RETURN 1	 $SET NOOND $DEFINE/USER SYS$OUTPUT NL:P $DEFINE/USER SYS$ERROR NL:$ $UCX SHOW CONF ENABL SERV PORTMAPPER $IF .NOT. $STATUSS $THEN  $DEFINE/USER SYS$OUTPUT NL:U $DEFINE/USER SYS$ERROR NL:, $UCX SHOW CONF ENABL SERV PORTMAPPER /COMMON $IF .NOT. $STATUSA $THENN $SAY " "> $SAY "	The portmapper service is not configured to be enabled" $SAY " "> $INFORM "	WARNING: PC-NFS will not function if the portmapper"$ $SAY "	         service is disabled" $SAY " "5 $SAY "	You will be asked to configure the portmapper"T $SAY " " $CONFIG_OPTN = ":''MC_PORT'" $IF MENUC_TODO_N .EQ. 0 .OR. -B F$LOCATE (":''MC_PORT'",MENUC_TODO_L) .EQ. F$LENGTH (MENUC_TODO_L) $THENE* $MENUC_TODO_L = MENUC_TODO_L + CONFIG_OPTN  $MENUC_TODO_N = MENUC_TODO_N + 1 $ENDIF $ENDIF $ENDIF $SET ON 	 $RETURN 1S $UCX$PCNFS_SET: , $SAY "Creating ''UCX$ENA_SRV' Service Entry"D $ucx set service pcnfs /port=5151/prot=tcp/flag=ucx/user=ucx$pcnfs -! /proc=ucx$pcnfsd/inact=0/limi=1 -A7 /file=sys$sysdevice:[ucx$pcnfs]ucx$pcnfsd_startup.com - > /log=(f:sys$sysdevice:[ucx$pcnfs]ucx$pcnfsd_startup.log,all) - /RPC=(P=150001,V=(L=1,H=2))P $IF $STATUS THEN -( UCX SET SERVICE PCNFS /PROT=UDP/FLAG=UCX $RETURN $STATUSO $UCX$PCNFS_ACT:U	 $RETURN 1 
 $UCX$RCOM: $UCX$VAL_OPTB = 1  $UCX$VAL_OPTC = 1  $UCX$APROX = 0 $UCX$CDIR = "UCX$RSH"W $UCX$CP = 10" $UCX$CCOM = "UCX$RSHD_STARTUP.COM" $UCX$CDEV = "SYS$SYSDEVICE"X
 $UCX$CNUM = 0= $UCX$CLUSTER = 1 $UCX$ENA_SRV = "RSH" $UCX$HASCONF = ""G
 $UCX$PRIV = 0W $UCX$PSEUDO = 0  $GOSUB UCX$SERV_MENU $UCX$CDIR = "UCX$REXEC"  $UCX$CP = 10$ $UCX$CCOM = "UCX$REXECD_STARTUP.COM" $UCX$CDEV = "SYS$SYSDEVICE"E $UCX$CLUSTER = 1 $UCX$ENA_SRV = "REXEC" $UCX$HASCONF = """ $GOSUB UCX$SERV_MENU	 $RETURN 1 
 $UCX$RSH_SET:T, $SAY "Creating ''UCX$ENA_SRV' Service Entry"7 $ucx set serv rsh /port=514/flag=ucx/process=ucx$rshd -XC /inact=5/limit=3/file=sys$sysdevice:[ucx$rsh]ucx$rshd_startup.com -ND /log=(accept,activ,addr,deact,connect,error,exit,modify,reject,time) $RETURN $STATUSE $UCX$REXEC_SET:A, $SAY "Creating ''UCX$ENA_SRV' Service Entry"; $ucx set serv rexec /port=512/flag=ucx/process=ucx$rexecd -EG /inact=5/limit=3/file=sys$sysdevice:[ucx$rexec]ucx$rexecd_startup.com -"< /log=(accept,activ,addr,deact,error,exit,modify,reject,time) $RETURN $STATUSN
 $UCX$RSH_ACT:S $UCX$REXEC_ACT:T	 $return 1I $UCX$RLOGIN: $UCX$VAL_OPTB = 1E $UCX$VAL_OPTC = 1  $UCX$APROX = 0 $UCX$CDIR = "" $UCX$CLUSTER = 1 $UCX$ENA_SRV = "RLOGIN"  $UCX$HASCONF = ""T
                                                                                                                                                                                                                                                    I                        {ʊ $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                         "            $UCX$PRIV = 0I $UCX$PSEUDO = 0X $GOSUB UCX$SERV_MENU	 $RETURN 1Y $UCX$RLOGIN_SET:, $SAY "Creating ''UCX$ENA_SRV' Service Entry"M $ucx set serv rlogin /port=513/flag=ucx/socket=(keep,receiv:3000,send:3000) -EC /inact=1/limit=50 /reject=message="UCX RLOGIN Connection refused" -RK /log=(accept,activ,noaddr,deact,conn,error,login,logout,modify,reject,time)  $RETURN $STATUSY $UCX$RLOGIN_ACT:	 $RETURN 1A	 $UCX$RPC:E $UCX$VAL_OPTB = 1" $UCX$VAL_OPTC = 1u $UCX$APROX = 0 $UCX$CDIR = "UCX$PORTM"t $UCX$CP = 4 # $UCX$CCOM = "UCX$PORTM_STARTUP.COM"o $UCX$CDEV = "SYS$SYSDEVICE""
 $UCX$CNUM = 0m $UCX$CLUSTER = 1 $UCX$ENA_SRV = "PORTMAPPER"" $UCX$HASCONF = ""N
 $UCX$PRIV = 0P $UCX$PSEUDO = 0  $GOSUB UCX$SERV_MENU $IF UCX$ENABS .NE. 0 $THEN] $SAY " "K $WARN " WARNING: NFS and PC-NFS will not function with portmapper disabled"" $SAY " " $ENDIF	 $RETURN 1R $UCX$PORTMAPPER_SET:, $SAY "Creating ''UCX$ENA_SRV' Service Entry"E $ucx set serv portmapper /port=111/prot=tcp/flag=ucx/user=ucx$portm - ? /proc=ucx$portm/inac=0/file='UCX$CDEV':['UCX$CDIR']'UCX$CCOM' - = /log=(f:sys$sysdevice:[ucx$portm]ucx$portm_startup.log,all) -f /RPC=(P=100000,V=(L=2,H=2))  $IF $STATUS THEN -- UCX SET SERVICE PORTMAPPER /PROT=UDP/FLAG=UCXT% $IF .NOT. $STATUS THEN RETURN $STATUS  $UCX$PORTMAPPER_ACT:	 $RETURN 1 
 $UCX$SMTP: $UCX$VAL_OPTB = 1  $UCX$VAL_OPTC = 1C $UCX$APROX = 0 $UCX$CDIR = "UCX_SMTP" $UCX$CP = 4E' $UCX$CCOM = "UCX$SMTP_RECV_STARTUP.COM"X $UCX$CDEV = "SYS$SPECIFIC"
 $UCX$CNUM = 0H $UCX$CLUSTER = 0 $UCX$ENA_SRV = "SMTP"  $UCX$HASCONF = "1"
 $UCX$PRIV = 0$ $UCX$PSEUDO = 0  $GOSUB UCX$SERV_MENU" $IF UCX$ENABS .EQ. 0 THEN RETURN 1* $IF UCX$DOMAIN_NAME .NES. "" THEN RETURN 1	 $TEMP = 0P $IF MENUA_TODO_N .EQ. 0 .OR. -I F$LOCATE (":''MA_DOMN'",MENUA_TODO_L) .EQ. F$LENGTH (MENUA_TODO_N) THEN -A TEMP = 1 $IF TEMP .EQ. 0 THEN RETURN 1A $TYPE SYS$INPUTY $DECKS  1 	You must provide the domain name in order to runn+ 	SMTP. This information should be availablei* 	from your Internet network administrator.   $ EODe; $INFORM "	You will be asked to configure the domain later."f $MENUA_TODO_L = "0:''MA_DOMN'"  $MENUA_TODO_N = MENUA_TODO_N + 1	 $RETURN 1O $UCX$SMTP_SET:" $SAY "Creating SMTP Service Entry"E $ucx set serv smtp /port=25/flag=ucx/user=ucx_smtp/process=ucx$smtp -+: /inact=5/limit=10/file='UCX$CDEV':['UCX$CDIR']'UCX$CCOM' -A /log=(file:sys$specific:[ucx_smtp]ucx$smtp_recv_startup.log, all)' $RETURN $STATUSv $UCX$SMTP_ACT: $IF .NOT. UCX$CONFSo $THEN/ $UCX SET CONFIGURATION SMTPn/ $UCX SET CONFIGURATION SMTP/OPTIONS=TOP_HEADERSy $ENDIF	 $RETURN 1n
 $UCX$SNMP: $UCX$VAL_OPTC = 1l $UCX$APROX = 0 $UCX$CDIR = "UCX$SNMP" $UCX$CP = 4," $UCX$CCOM = "UCX$SNMP_STARTUP.COM" $UCX$CDEV = "SYS$SYSDEVICE" 
 $UCX$CNUM = 0P $UCX$CLUSTER = 1 $UCX$ENA_SRV = "SNMP"P $UCX$HASCONF = "1"
 $UCX$PRIV = 0  $UCX$PSEUDO = 0  $GOSUB UCX$SERV_MENU" $IF UCX$ENABS .NE. 0 THEN RETURN 1	 $SET NOON  $DEFINE/USER SYS$OUTPUT NL:T $DEFINE/USER SYS$ERROR NL: $UCX SHOW SERVICE ESNMP  $IF .NOT. $STATUS1 $THENE $SAY " "2 $SAY "	SNMP Service exists without eSNMP service." $SAY "	Creating eSNMP Service."X $SAY " "6 $ucx set serv esnmp /port=242/prot=udp/process=ESNMP - /user=ucx$snmp/file=nl:S $ENDIF	 $SET NOONU $DEFINE/USER SYS$OUTPUT NL:E $DEFINE/USER SYS$ERROR NL: $UCX SHOW CONF TIMET $IF .NOT. $STATUST $THENY $SAY " "+ $SAY "	A time zone has not been configured"  $SAY " "H $INFORM "	WARNING: SNMP will not function if a time zone is not defined" $SAY " ": $SAY "	You will be asked to configure the time zone later" $SAY " " $CONFIG_OPTN = ":''MA_TIME'" $IF MENUA_TODO_N .EQ. 0 .OR. -@ F$LOCATE (CONFIG_OPTN,MENUA_TODO_L) .EQ. F$LENGTH (MENUA_TODO_L) $THENg* $MENUA_TODO_L = MENUA_TODO_L + CONFIG_OPTN  $MENUA_TODO_N = MENUA_TODO_N + 1 $ENDIF $ENDIF $SET ONl	 $RETURN 1a $UCX$SNMP_SET:, $SAY "Creating ''UCX$ENA_SRV' Service Entry"M $ucx set serv snmp /port=161/prot=udp/flag=ucx/user=ucx$snmp/proce=ucx$snmp - 9 /inact=0/limit=1/file='UCX$CDEV':['UCX$CDIR']'UCX$CCOM' -X= /log=(file:sys$sysdevice:[ucx$snmp]ucx$snmp_startup.log, all)X $IF $STATUS THEN RETURN $STATUSS	 $SET NOON_ $DEFINE/USER SYS$OUTPUT NL:_ $DEFINE/USER SYS$ERROR NL: $UCX SHOW SERV ESNMP /FULL/PERMs $IF $STATUS THEN RETURN $STATUSkK $ucx set serv esnmp /port=242/prot=udp/process=ESNMP/user=ucx$snmp/file=nl:O $RETURN $STATUSf $UCX$SNMP_ACT: $IF UCX$CONFS THEN RETURN 1n $TYPE SYS$INPUTu $DECKy  : 	To configure the SNMP agent, you must provide information8 	for one or more communities. A community consists of an9 	access type (which will be set to read), and one or moreO9 	remote host internet addresses.  Enter <return> when you & 	have no more information to be added.  
 	Example:  		Community	Type	Addresses   		public		read	0.0.0.0   		examplecomm	read	130.180.4.5 					130.180.6.2 					130.180.5.4  ; 	WARNING - the community name is case sensitive.  Lowercasep)         names must be enclosed in quotes.R   $ EODR
 $PUB_COMM: $READ SYS$COMMAND UCX$TEMP -: /PROMPT="Do you want to provide the public community [Y]:"5 $UCX$TEMP = F$EDIT(UCX$TEMP, "TRIM,UNCOMMENT,UPCASE")l) $IF UCX$TEMP .EQS. "" THEN UCX$TEMP = "Y"g$ $UCX$TEMP = F$EXTRACT (0,1,UCX$TEMP)* $IF UCX$TEMP .EQS. "N" THEN GOTO COMM_NAME) $IF UCX$TEMP .NES. "Y" THEN GOTO PUB_COMM E $UCX SET CONFIGURATION SNMP /COMMUN="public"/TYPE=READ/ADDRES=0.0.0.0 
 $ASK_NAME:R $READ SYS$COMMAND UCX$TEMP /PROMPT="Do you want to provide another community [N]:"5 $UCX$TEMP = F$EDIT(UCX$TEMP, "TRIM,UNCOMMENT,UPCASE") ) $IF UCX$TEMP .EQS. "" THEN UCX$TEMP = "N"S$ $UCX$TEMP = F$EXTRACT (0,1,UCX$TEMP)$ $IF UCX$TEMP .EQS. "N" THEN GOTO MOM) $IF UCX$TEMP .NES. "Y" THEN GOTO ASK_NAME  $COMM_NAME:U
 $UCX$TEMP = 0I $UCX$ADDR_LIST = ""E= $READ SYS$COMMAND UCX$COMM_N /PROMPT="Enter community name: " % $IF UCX$COMM_N .EQS. "" THEN GOTO MOMO $COMM_ADDR:D6 $READ SYS$COMMAND UCX$COMM_A /PROMPT="Enter address: "* $IF UCX$COMM_A .EQS. "" THEN GOTO SET_COMM $IF UCX$COMM_A .NES. "0.0.0.0" $THENr	 $SET NOONo $DEFINE/USER SYS$ERROR NL:$ $UCX CHECK HOST_ADDRESS 'UCX$COMM_A'- $IF .NOT. $STATUS THEN GOTO COMM_INVALID_ADDRo $ENDIF< $IF UCX$TEMP .NE. 0 THEN UCX$ADDR_LIST = UCX$ADDR_LIST + "," $UCX$TEMP = UCX$TEMP + 1+ $UCX$ADDR_LIST = UCX$ADDR_LIST + UCX$COMM_A  $GOTO COMM_ADDRS $COMM_INVALID_ADDR:i $SAY ""e$ $SAY " Invalid host address format." $SAY ""u $SET ONc $GOTO COMM_ADDRx
 $SET_COMM:' $IF UCX$TEMP .EQ. 0 THEN GOTO COMM_NAMER' $IF UCX$TEMP .EQ. 1 THEN GOTO SET_COMM1u* $UCX$ADDR_LIST = "(" + UCX$ADDR_LIST + ")" $SET_COMM1:v	 $SET NOON_ $DEFINE/USER SYS$OUTPUT NL:T $DEFINE/USER SYS$ERROR NL:= $UCX SET CONFI SNMP/COMM="''UCX$COMM_N'"/ADDR='UCX$ADDR_LIST'F $IF .NOT. $STATUSS $THENU $SAY ""T? $SAY "	WARNING: incorrect data, failed to enter it in database.X/ $SAY "	Please check parameters and enter again.S $SAY ""  $ENDIF $SET ON  $GOTO COMM_NAME  $MOM:A $TYPE SYS$INPUTU $DECKO  < 	To configure the TCP/IP MOM you must provide the following 
 	information: $ 		- contact person(s) for the system 		- location of the system  	 	Example:S 		Larry AnonymousO
 		42 Oak Lane  		Anytown, BQ, 99999 	E $ EODYB $READ SYS$COMMAND SNMP$CONTACT /PROMPT="Enter contact person(s): "G $READ SYS$COMMAND SNMP$LOC /PROMPT="Enter the location of the system: "p	 $SET NOONP $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL: $UCX SET CONFIG SNMP - /CONTACT="''SNMP$CONTACT'" - /LOCATION=FIRST="''SNMP$LOC'"A	 $RETURN 1Y $UCX$TELNET: $UCX$VAL_OPTB = 1s $UCX$VAL_OPTC = 1d $UCX$APROX = 0 $UCX$CDIR = "" $UCX$CLUSTER = 1 $UCX$ENA_SRV = "TELNET"o $UCX$HASCONF = """
 $UCX$PRIV = 0l $UCX$PSEUDO = 0f $GOSUB UCX$SERV_MENU	 $RETURN 1" $UCX$TELNET_SET:, $SAY "Creating ''UCX$ENA_SRV' Service Entry"9 $ucx set serv telnet /port=23/flag=ucx/inact=1/limit=50 -T& /socket=(keep,receiv:3000,send:3000) -? /log=(activ,noaddr,deact,conn,error,login,logout,modify,reject)D $RETURN $STATUST $UCX$TELNET_ACT:	 $RETURN 1" $UCX$TELNET_RLOGIN_MESSAGE:c $UCX$VAL_OPTC = 1s $SAY " "L $INFORM "Telnet and Rlogin are enabled from the client menu. If you wish to"M $SAY "disable the Telnet or Rlogin server then you must disable the service."x $SAY " "	 $RETURN 1l
 $UCX$TFTP: $UCX$VAL_OPTC = 1A $UCX$APROX = 0 $UCX$CDIR = "UCX$TFTP" $UCX$CP = 4N" $UCX$CCOM = "UCX$TFTP_STARTUP.COM" $UCX$CDEV = "SYS$SYSDEVICE"U
 $UCX$CNUM = 0S $UCX$CLUSTER = 1 $UCX$ENA_SRV = "TFTP"t $UCX$HASCONF = ""u
 $UCX$PRIV = 0l $UCX$PSEUDO = 0S $GOSUB UCX$SERV_MENU $IF UCX$ENABS .NE. 0 $THENn $SAY " "< $WARN " WARNING: BOOTP will not function with TFTP disabled" $SAY " " $ENDIF	 $RETURN 1  $UCX$TFTP_SET:" $SAY "Creating TFTP Service Entry"= $ucx set serv tftp /port=69/prot=udp/f                                                                                                                                                                                                                                                   J                        KWb $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                        +K "            lag=ucx/user=ucx$tftp -oE /process=ucx$tftp/file=SYS$SYSDEVICE:[UCX$TFTP]UCX$TFTP_STARTUP.COM -t> /log=(file:sys$sysdevice:[ucx$tftp]ucx$tftpd_startup.log, all) $RETURN $STATUS0 $UCX$TFTP_ACT:	 $SET NOON0+ $TFTP_DIR = "SYS$SYSDEVICE:[UCX$TFTP_ROOT]" B $IF (F$SEARCH("SYS$SYSDEVICE:[000000]UCX$TFTP_ROOT.DIR")) .EQS. "" $THENe4 $CREATE/DIRECTORY 'TFTP_DIR' /OWNER_UIC=[UCX$TFTP] -" /PROTECTION=(S:RWE,O:RWE,G:RE,W:E) $ELSEoB $SET FILE/PROTECTION=(S:RWE,O:RWE,G:RE,W:E)/OWNER_UIC=[UCX$TFTP] -' SYS$SYSDEVICE:[000000]UCX$TFTP_ROOT.DIR$ $ENDIF $IF .NOT. $STATUS  $THEN : $SAY "	$UCX-W-DIRERR - Error creating UCX$TFTP Directory." $SAY " "	 $RETURN 0  $ENDIF	 $RETURN 1" $UCX$METRIC: $UCX$VAL_OPTC = 1CH $UCX$SO = "METRIC"              ! Used to change menu header to "SERVER" $UCX$APROX = 0 $UCX$CDIR = "UCX$METRIC" $UCX$CP = 4i$ $UCX$CCOM = "UCX$METRIC_STARTUP.COM" $UCX$CDEV = "SYS$SPECIFIC"
 $UCX$CNUM = 0  $UCX$CLUSTER = 0 $UCX$ENA_SRV = "METRIC"S $UCX$HASCONF = ""R
 $UCX$PRIV = 0M $UCX$PSEUDO = 1. $GOSUB UCX$SERV_MENU	 $RETURN 1E $UCX$METRIC_ACT:	 $RETURN 1M $UCX$METRIC_SET:	 $RETURN 1  $UCX$FINGER: $UCX$APROX = 0) $UCX$CCOM = "UCX$FINGER_SRVR_STARTUP.COM"m $UCX$CP = 10 $UCX$CDEV = "SYS$SYSDEVICE"N $UCX$CDIR = "UCX$FINGER" $UCX$CLUSTER = 1
 $UCX$CNUM = 0M $UCX$ENA_SRV = "FINGER"  $UCX$HASCONF = "" 
 $UCX$PRIV = 0O $UCX$PSEUDO = 0A $UCX$VAL_OPTB = 1T $UCX$VAL_OPTC = 1D $GOSUB UCX$SERV_MENU	 $RETURN 1E $UCX$FINGER_SET:, $SAY "Creating ''UCX$ENA_SRV' Service Entry"N $ucx set serv FINGER /port=79/flag=listen/user=ucx$finger/process=ucx$finger -: /inact=5/limit=10/file='UCX$CDEV':['UCX$CDIR']'UCX$CCOM' -C /log=(file:'UCX$CDEV':['UCX$CDIR']ucx$finger_srvr_startup.log, all)Y $RETURN $STATUSd $UCX$FINGER_ACT:	 $RETURN 1T	 $UCX$RMT:  $UCX$APROX = 0 $UCX$CCOM = "" $UCX$CP = 10 $UCX$CDEV = "" $UCX$CDIR = "" $UCX$CLUSTER = 0
 $UCX$CNUM = 0X $UCX$ENA_SRV = "RMT" $UCX$HASCONF = ""S
 $UCX$PRIV = 0T $UCX$SO = "RMT"S $UCX$PSEUDO = 1T $UCX$VAL_OPTB = 1E $UCX$VAL_OPTC = 1C $GOSUB UCX$SERV_MENU	 $RETURN 1D
 $UCX$RMT_SET:T	 $RETURN 1T
 $UCX$RMT_ACT:E	 $RETURN 1T	 $UCX$POP:R $UCX$VAL_OPTC = 1a $UCX$APROX = 0 $UCX$CDIR = "UCX$POP"Y $UCX$CP = 10& $UCX$CCOM = "UCX$POP_RECV_STARTUP.COM" $UCX$CDEV = "SYS$SYSDEVICE"M
 $UCX$CNUM = 0  $UCX$CLUSTER = 1 $UCX$ENA_SRV = "POP" $UCX$HASCONF = ""u
 $UCX$PRIV = 0h $UCX$PSEUDO = 0f
 $UCX$BLM = 65 
 $UCX$DLM = 60s
 $UCX$TLM = 34m $GOSUB UCX$SERV_MENU" $DELETE/SYMBOL/LOCAL/NOLOG UCX$BLM" $DELETE/SYMBOL/LOCAL/NOLOG UCX$DLM" $DELETE/SYMBOL/LOCAL/NOLOG UCX$TLM	 $RETURN 1A
 $UCX$POP_SET:e! $SAY "Creating POP Service Entry"OH $ucx set serv POP /port=110/flag=nolisten/user=ucx$POP/process=ucx$POP -: /inact=5/limit=10/file='UCX$CDEV':['UCX$CDIR']'UCX$CCOM' -? /log=(file:sys$specific:[ucx$POP]ucx$POP_recv_startup.log, all)S $RETURN $STATUS 
 $UCX$POP_ACT:X	 $RETURN 1U
 $UCX$NTPD: $UCX$VAL_OPTC = 1 : $UCX$SO = "NTPD"		! Used to change menu header to "SERVER" $UCX$APROX = 0 $UCX$CDIR = "UCX$NTP"" $UCX$CP = 4  $UCX$CCOM = "DUMMY.COM"S $UCX$CDEV = "SYS$SPECIFIC"
 $UCX$CNUM = 0E $UCX$CLUSTER = 0 $UCX$ENA_SRV = "NTPD"  $UCX$HASCONF = ""r
 $UCX$PRIV = 02 $UCX$PSEUDO = 11 $GOSUB UCX$SERV_MENU	 $RETURN 1v $UCX$NTPD_ACT:@ $IF F$SEARCH ("SYS$SPECIFIC:[UCX$NTP]UCX$NTP.TEMPLATE") .EQS. "" $THENT $SAY " "7 $SAY "	Creating SYS$SPECIFIC:[UCX$NTP]UCX$NTP.TEMPLATE"A= $IF F$SEARCH ("SYS$SPECIFIC:[UCX$NTP]UCX$NTP.TMP") .NES. "" -a5 THEN DELETE/NOLOG SYS$SPECIFIC:[UCX$NTP]UCX$NTP.TMP;*"7 $OPEN/WRITE UCX$START SYS$SPECIFIC:[UCX$NTP]UCX$NTP.TMP L $WRITE UCX$START ";       Copyright (c) Digital Equipment Corporation, 1995" $WRITE UCX$START " "J $WRITE UCX$START ";                        Example NTP Configuration File" $WRITE UCX$START " "G $WRITE UCX$START "; This template needs to be renamed to ucx$ntp.conf."X $WRITE UCX$START " "\ $WRITE UCX$START "; The Network Time Protocol (NTP) provides synchronized timekeeping among"Z $WRITE UCX$START "; a set of distributed time servers and clients. The local OpenVMS host"_ $WRITE UCX$START "; maintains an NTP configuration file, UCX$NTP.CONF, of participating peers."eV $WRITE UCX$START "; UCX$NTP.CONF is maintained in the UCX$NTP sys$specific directory." $WRITE UCX$START " "] $WRITE UCX$START "; The system manager populating this file determines with which peer hosts"Ca $WRITE UCX$START "; the local hosts should negotiate and synchronize. These are hosts with which"/[ $WRITE UCX$START "; you regularly exchange data and where accurate time coordination is an"T\ $WRITE UCX$START "; important factor.  Include at least one (but preferably two) peer hosts"* $WRITE UCX$START "; that you are assured:" $WRITE UCX$START " ", $WRITE UCX$START ";	* provide accurate time"W $WRITE UCX$START ";	* synchronize to Internet Time Servers (if they are not themselves"". $WRITE UCX$START ";	  Internet Time Servers)." $WRITE UCX$START " "Z $WRITE UCX$START "; Two hosts provide reliability in case one of the two hosts goes down." $WRITE UCX$START " "^ $WRITE UCX$START "; The NTP peer configuration file is dynamic and does not require a restart"( $WRITE UCX$START "; after being edited." $WRITE UCX$START " "\ $WRITE UCX$START "; Samples entries follow.  Replace them with your own peers. The order of"a $WRITE UCX$START "; the items is irrelevant. Each line  not commented with a "";"" or ""!"" must"Ub $WRITE UCX$START "; begin with the word peer and be followed by the peer host's internet address." $WRITE UCX$START " "! $WRITE UCX$START "peer 18.72.0.3"S" $WRITE UCX$START "peer 130.43.2.2"! $WRITE UCX$START "peer 16.1.0.22"e $WRITE UCX$START " "> $WRITE UCX$START ";                        UCX$NTP_TZ Logical" $WRITE UCX$START " "] $WRITE UCX$START "; The logical UCX$NTP_TZ stores the UT offset (in seconds) and is required"__ $WRITE UCX$START "; for timezone offset information. For example, in Boston MA during Daylight"U] $WRITE UCX$START "; Savings Time (EST5EDT4), UCX$NTP_TZ is -040000, which can be defined in,"U_ $WRITE UCX$START "; for example, SYS$COMMON:[SYSMGR]UCX$NTPD_STARTUP.COM with the DCL command:"V $WRITE UCX$START " "7 $WRITE UCX$START ";	$ DEFINE/SYSTEM UCX$NTP_TZ -040000"T $WRITE UCX$START " "[ $WRITE UCX$START "; This needs to be defined before NTP is started; edit the commented out" ] $WRITE UCX$START "; definition of UCX$NTP_TZ in SYS$COMMON:[SYSMGR]UCX$NTPD_STARTUP.COM with" [ $WRITE UCX$START "; the value for your timezone offset and remove the semi-colon to permit" ] $WRITE UCX$START "; the definition of the UCX$NTP_TZ logical when NTP is instantiated by the"N $WRITE UCX$START "; procedure."L $CLOSE UCX$START+ $RENAME SYS$SPECIFIC:[UCX$NTP]UCX$NTP.TMP - ( SYS$SPECIFIC:[UCX$NTP]UCX$NTP.TEMPLATE;0 $ENDIF $UCX$NTPD_SET:	 $RETURN 11 $ADD_COPYRIGHT: SUBROUTINE $WRITE 'P1' "$ !" D $WRITE 'P1' "$ !  Copyright (c) Digital Equipment Corporation, 1995"D $WRITE 'P1' "$ !  All Rights Reserved.  Unpublished rights reserved"A $WRITE 'P1' "$ !  under the copyright laws of the United States."X $WRITE 'P1' "$ !"dF $WRITE 'P1' "$ !  The software contained on this media is proprietary"A $WRITE 'P1' "$ !  to and embodies the confidential technology of"IC $WRITE 'P1' "$ !  Digital Equipment Corporation.  Possession, use,"SC $WRITE 'P1' "$ !  duplication or dissemination of the software and"RG $WRITE 'P1' "$ !  media is authorized only pursuant to a valid written"M> $WRITE 'P1' "$ !  license from Digital Equipment Corporation." $WRITE 'P1' "$ !"EB $WRITE 'P1' "$ !  RESTRICTED RIGHTS LEGEND   Use, duplication, or"B $WRITE 'P1' "$ !  disclosure by the U.S. Government is subject to"G $WRITE 'P1' "$ !  restrictions as set forth in Subparagraph (c)(1)(ii)" A $WRITE 'P1' "$ !  of DFARS 252.227-7013, or in FAR 52.227-19, as"S $WRITE 'P1' "$ !  applicable." $WRITE 'P1' "$ !"  $exite $ENDSUBROUTINE $ADD_NOMODIFY: SUBROUTINE" $WRITE 'P1' "$ !"TG $WRITE 'P1' "$ !  This command procedure is written and deleted by the"TO $WRITE 'P1' "$ !  DIGITAL TCP/IP Services for OpenVMS configuration procedure."i $WRITE 'P1' "$ !"W> $WRITE 'P1' "$ !        DO NOT MODIFY THIS COMMAND PROCEDURE." $WRITE 'P1' "$ !"hG $WRITE 'P1' "$ !  Any site specific changes should be done in the site"N? $WRITE 'P1' "$ !  specific command procedure UCX$SYSTARTUP.COM"  $WRITE 'P1' "$ !"C $exity $ENDSUBROUTINE $INIT_GROUP_UIC: SUBROUTINE ! $ON CONTROL_Y THEN GOTO UIC_ABORTg $IF .NOT $STATUS THEN EXIT 0	 $SET NOONh1 $TEMP = F$IDENTIFIER("UCX$AUX", "NAME_TO_NUMBER")t $SET ONn $IF TEMP .NE. 0h $THEN  $TEMP = F$FAO ("!%U",TEMP) $TEMP = F$ELEMENT (0,",",TEMP)" $UCX$UICG == F$EXTRACT (1,10,TEMP)( $IF ("''GUIC_SAID'" .NES. "TRUE") THEN -B SAY "The UCX$AUX identifier already exists with value ''UCX$UI                                                                                                                                                                                                                                                   K                        [ $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                         "            CG'" $GUIC_SAID == "TRUE" $exit 1  $ENDIF $UCX$UICG == 375> $IF F$TRNLNM("UCX$ASK_GROUP_UIC") .EQS. "" THEN GOTO ADD_IDENT $SAY " ": $SAY "	UCX Auxiliary Service requires an UIC group number"( $SAY "	to create the services accounts." $SAY " " $GET_UIC_GROUP: 	 $SET NOONS= $READ SYS$COMMAND UCX$UICG /PROMPT="Enter UIC group number: "c $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL: $TEMP = f$integer(%O'UCX$UICG')r $IF .NOT. $STATUS  $THENm$ $SAY "Please enter an Octal number." $GOTO GET_UIC_GROUPe $ENDIF $ADD_IDENT:I4 $IF F$IDENTIFIER("UCX$AUX", "NAME_TO_NUMBER") .EQ. 0 $THEN  $AUX_GROUP = 0. $AUX_GROUP[16,16] = F$INTEGER("%O''UCX$UICG'") $AUX_GROUP[0,16] = -1l6 $IF F$IDENTIFIER(AUX_GROUP, "NUMBER_TO_NAME") .NES. "" $THENW4 $SAY "That group number ''UIC$UICG' already exists."= $SAY "UCX requires a unique group number.  Please try again."" $GOTO GET_UIC_GROUPe $ENDIF $ENDIF> $SAY "Creating UCX$AUX identifier with a value of ''UCX$UICG'"	 $SET NOONI $DEFINE/USER SYS$OUTPUT NL:S $DEFINE/USER SYS$ERROR NL:3 $UCX$UAF ADD/IDENT UCX$AUX/VALUE=UIC:['UCX$UICG',*]U $SET ON" $exit 1i $UIC_ABORT:Z $EXIT 44 $ENDSUBROUTINE $SET_UAF_LOGICALS: SUBROUTINEI( $UCX$UAF :== "$SYS$SYSTEM:AUTHORIZE.EXE" $IF F$TRNLNM("SYSUAF") .EQS. ""d $THENa4 $ucx$sysuaf = f$parse("SYSUAF","SYS$SYSTEM:.DAT",,,) $if ucx$sysuaf .EQS. ""h $then - $WARN "%UCX-F-FNF, file not found SYSUAF.DAT"l $exit 0M $endif& $define/process SYSUAF "''ucx$sysuaf'" $ENDIF# $IF F$TRNLNM("RIGHTSLIST") .EQS. ""A $THEN 8 $ucx$rights = f$parse("RIGHTSLIST","SYS$SYSTEM:.DAT",,,) $if ucx$rights .EQS. ""n $then 0 $WARN %UCX-F-FNF, file not found RIGHTSLIST.DAT" $exit 0  $endif* $define/process RIGHTSLIST "''ucx$rights'" $ENDIF $exit 1X $ENDSUBROUTINE $INIT_MEMBER_UIC: SUBROUTINE $UCX$IDENT == 'P1t	 $SET NOONs1 $TEMP = F$IDENTIFIER(UCX$IDENT, "NAME_TO_NUMBER")X $IF TEMP .NE. 0i $THENo $TEMP = F$FAO ("!%U",TEMP) $TEMP = F$ELEMENT (1,",",TEMP)# $UCX$UICM == F$ELEMENT (0,"]",TEMP)O> $SAY "''UCX$IDENT' already exists with a value of ''UCX$UICM'" $SET ON[ $EXIT 1C $ENDIF $AUX_GROUP = 0. $AUX_GROUP[16,16] = F$INTEGER("%O''UCX$UICG'") $UCX$UICM_DEC = UCX$UICM / 10WA $UCX$UICM_DEC = UCX$UICM_DEC * 8 + (UCX$UICM - UCX$UICM_DEC * 10) 
 $INCR_MEMBER:!  $UCX$UICM_DEC = UCX$UICM_DEC + 1 $UCX$UICM == UCX$UICM_DEC / 8 : $UCX$UICM == UCX$UICM * 10 + (UCX$UICM_DEC - UCX$UICM * 8)- $AUX_GROUP[0,16] = F$INTEGER("%O''UCX$UICM'")c7 $TEMP_IDENT = F$IDENTIFIER(AUX_GROUP, "NUMBER_TO_NAME") , $IF TEMP_IDENT .EQS. "" THEN GOTO ASK_MEMBER4 $IF TEMP_IDENT .EQS. UCX$IDENT THEN GOTO MEMBER_DONE $GOTO INCR_MEMBER  $ASK_MEMBER: $SET ONc
 $MEMBER_DONE:i $exit 1  $ENDSUBROUTINE $CREATE_ACCOUNT: subroutines% $ON CONTROL_Y THEN GOTO ACCOUNT_ABORTi $CALL GET_PASSWORD $UCX$IDENT == "''P1'"t) $UCX$ACC == "''f$extract(0,8,UCX$IDENT)'"! $UCX$SES = 'P2'$ $UCX$STRT == "''P3'" $UCX$DDEV == "''P4'" - ":" $IF "''P5'" .EQ. 0 $THENo $IF F$TYPE (UCX$DLM) .NES. ""s $THEN DLM = UCX$DLM1 $ELSE DLM = 18 $ENDIF $IF F$TYPE (UCX$BLM) .NES. "") $THEN BLM = UCX$BLM$ $ELSE BLM = 18 $ENDIF $IF F$TYPE (UCX$ALM) .NES. ""W $THEN ALM = UCX$ALMc $ELSE ALM = 1001 $ENDIF $IF F$TYPE (UCX$FLM) .NES. ""N $THEN FLM = UCX$FLM  $ELSE FLM = 50 $ENDIF $IF F$TYPE (UCX$ELM) .NES. ""e $THEN ELM = UCX$ELMe $ELSE ELM = 100W $ENDIF $IF F$TYPE (UCX$TLM) .NES. ""  $THEN TLM = UCX$TLMt $ELSE TLM = 15 $ENDIF $IF F$TYPE (UCX$WSQ) .NES. ""  $THEN WSQ = UCX$WSQH $ELSE WSQ = 512U $ENDIF $IF F$TYPE (UCX$WSX) .NES. ""$ $THEN WSX = UCX$WSX  $ELSE WSX = 512  $ENDIF $IF F$TYPE (UCX$PQ) .NES. "" $THEN PQ = UCX$PQo $ELSE PQ = 10240 $ENDIF  $IF F$TYPE (UCX$BYT_LM) .NES. "" $THEN BYT_LM = UCX$BYT_LM:4 $ELSE BYT_LM = ((3300*UCX$SES)+(6000*UCX$SES)+15000) $ENDIF $ELSEE $DLM = 1024+('P5'*10)T
 $BLM = 400 $ALM = 'DLM'+'BLM'+1024+'P5' $FLM = 1024+('P5') $ELM = 3000h $TLM = 20+('P5'/5) $WSQ = 20000 $WSX = 20000 $PQ = 20000" $BYT_LM = 400000 $ENDIF	 $SET NOONT $DEFINE/USER SYS$OUTPUT NL:S $DEFINE/USER SYS$ERROR NL: $UCX$UAF SHOW 'UCX$IDENT'x $IF .NOT. $STATUSC $THEN" $IF UCX$UICG .EQ. 0" $THEN  $CALL INIT_GROUP_UIC# $IF .NOT. $STATUS THEN EXIT $STATUSI $ENDIF $CALL INIT_MEMBER_UIC UCX$IDENT"# $IF .NOT. $STATUS THEN EXIT $STATUSe $DEFINE/USER SYS$OUTPUT NL:" $DEFINE/USER SYS$ERROR NL:= $UCX$UAF ADD 'UCX$IDENT'/OWNER='UCX$IDENT'/ACCOUNT='UCX$ACC'-N /CLI=DCL/CLITA=DCLTABLES-I /UIC=['UCX$UICG','UCX$UICM']-R) /DEVICE='UCX$DDEV'/DIRECTORY='UCX$IDENT'-:) /NETWORK/NOINTERACTIVE/NOBATCH/NOREMOTE -T' /FLAGS=(RESTRICTED,NODISUSER,NOCAPTIVE)  $IF .NOT. $STATUST $THENI $SAY " ", $WARN "	Error creating ''UCX$IDENT' Account" $SAY " " $GOTO ERRORE $ENDIF $DEFINE/USER SYS$OUTPUT NL:O $DEFINE/USER SYS$ERROR NL: $UCX$UAF MODIFY 'UCX$IDENT'-. /PRIV=(TMPMBX,NETMBX)/DEFPRIV=(TMPMBX,NETMBX)-$ /LGICMD=LOGIN/PRIO=8/PASSWO='PSWRD'-4 /ASTLM='ALM'/BYTLM='BYT_LM'/FILLM='FLM'/TQELM='TLM'-/ /BIOLM='BLM'/DIOLM='DLM'/ENQLM='ELM'/PGFL='PQ'-G" /WSDEF=350/WSEXT='WSX'/WSQUO='WSQ' $IF .NOT. $STATUSA $THENt $SAY " "- $WARN "	Error modifying ''UCX$IDENT' Account"S $SAY " " $GOTO ERRORF $ENDIF $ELSER4 $IF F$IDENTIFIER(UCX$IDENT, "NAME_TO_NUMBER") .EQ. 0 $THEN  $SAY ", $WARN "Rightlist Identifier does not exist." $SAY " $GOTO ERRORL $ENDIF $ENDIF $DEFINE/USER SYS$OUTPUT NL:H $DEFINE/USER SYS$ERROR NL:, $SHOW QUOTA/DISK='UCX$DDEV'/USER='UCX$IDENT' $IF $STATUS .EQ. %X3E4 $THEN) $QUOTA = UCX$SES*10000 $OPEN/WRITE QUOTA QUOTA.TMP,) $WRITE QUOTA "$ RUN SYS$SYSTEM:DISKQUOTA"d $WRITE QUOTA "USE ''UCX$DDEV'"C $WRITE QUOTA "ADD ''UCX$IDENT' /PERMQUOTA=''QUOTA' /OVERDRAFT=1000"x $WRITE QUOTA "EXIT"G $CLOSE QUOTA $@QUOTA.TMP, $DEFINE/USER SYS$OUTPUT NL:  $DEFINE/USER SYS$ERROR NL: $DELETE/NOLOG QUOTA.TMP;*" $ENDIF1 $SERV_DIR = "''UCX$DDEV'"+":["+"''UCX$IDENT'"+"]"sH $IF (F$SEARCH("''UCX$DDEV'"+":[000000]"+"''UCX$IDENT'"+".DIR")) .EQS. "" $THEN 7 $CREATE/DIRECTORY 'SERV_DIR' /OWNER_UIC=['UCX$IDENT'] -O" /PROTECTION=(S:RWE,O:RWE,G:RE,W:E) $ELSE E $SET FILE/PROTECTION=(S:RWE,O:RWE,G:RE,W:E)/OWNER_UIC=['UCX$IDENT'] -E" 'UCX$DDEV':[000000]'UCX$IDENT'.DIR $ENDIF! $IF .NOT. $STATUS THEN GOTO ERRORM  $FILE_NAME = SERV_DIR + UCX$STRT' $FILE_NAME2 = "SYS$MANAGER:" + UCX$STRTED $IF F$SEARCH(FILE_NAME) .EQS. "" .AND. F$SEARCH(FILE_NAME2) .NES. "" $THEND $COPY 'FILE_NAME2' 'FILE_NAME' $SET FILE 'FILE_NAME' -  /OWNER=['UCX$IDENT'] -% /PROTECTION=(S:RWED,O:RWED,G:RE,W:RE)  $ENDIF! $IF .NOT. $STATUS THEN GOTO ERRORC# $FILE_NAME = SERV_DIR + "LOGIN.COM"F  $IF F$SEARCH(FILE_NAME) .EQS. "" $THEN , $OPEN/WRITE/ERROR=EXIT AUX_LOGIN 'FILE_NAME'Y $WRITE AUX_LOGIN "$! login.com for DIGITAL TCP/IP Services for OpenVMS Auxiliary service"_ $CLOSE/ERROR=EXIT AUX_LOGINK $SET FILE 'FILE_NAME' -E /OWNER=['UCX$IDENT'] -% /PROTECTION=(S:RWED,O:RWED,G:RE,W:RE)s $ENDIF! $IF .NOT. $STATUS THEN GOTO ERRORC $exit: $SET ON 
 $EXIT $STATUS' $error:U $DEFINE/USER SYS$OUTPUT NL:X $DEFINE/USER SYS$ERROR NL: $UCX$UAF REMOVE 'UCX$IDENT'D $SAY " "L $SAY "	Configuration error during account creation for ''UCX$IDENT' Account"1 $WARN " %UCX-E-NOCONFIG - Service not configured"( $SAY " " $SET ON  $EXIT 0  $account_abort:  $DEFINE/USER SYS$OUTPUT NL:( $DEFINE/USER SYS$ERROR NL: $UCX$UAF REMOVE 'UCX$IDENT'1 $SAY " "5 $INFORM " Aborting account creation at user request."E $SAY " " $EXIT 44 $endsubroutine $CLEAR_SCREEN: subroutine  $IF UCX_WAIT $THEN < $READ SYS$COMMAND ANS /PROMPT="Press Return to continue ..." $ELSE   $IF UCX_DELAY THEN WAIT 00:00:04 $ENDIF $UCX_WAIT == 0 $UCX_DELAY == 0H $TYPE/PAGE NL: $exitD $endsubroutine $GET_PASSWORD: subroutineS $IF "''PSWRD'" .NES. ""  $THENE3 $IF "''PWD5'" .EQS. "" THEN GOTO ALLOCATE_PASSWORDSo	 $PWDN = 1=
 $FIND_PASSWD:  $IF PWD'PWDN .NES. ""  $THEN" $PSWRD == PWD'PWDN $PWD'PWDN == ""Y $EXIT 13 $ELSE$ $PWDN = PWDN + 1 $ENDIF% $IF PWDN .LE. 5 THEN GOTO FIND_PASSWDT+ $SAY "Password logic error - Using default"F $PSWRD == ijnmkskdfj $EXIT 1  $ENDIF $ALLOCATE_PASSWORDS:= $IF F$SEARCH("SYS$MANAGER:UCXCONFIG-PWD.TMP") .NES. "" THEN -N- DELETE /NOLOG SYS$MANAGER:UCXCONFIG-PWD.TMP;*R  $ON ERROR THEN GOTO GEN_PWD_DONE6 $DEFINE /USER SYS$OUTPUT SYS$MANAGER:UCXCONFIG-PWD.TMP $SET PASSWORD/GEN=8T INVALIDC $GEN_PWD_DONE:= $IF F$SEARCH("SYS$MANAGER:UCXCONFIG-PWD.TMP") .EQS. "" THEN -" GOTO PSWD_FILE_ERR- $SET PROT=(G,W) SYS$MANAGER:UCXCONFIG-PWD.TMP" $ON ERROR THEN GOTO NO_CHANGES $PWD1 == ""C $PWD2 == ""R $PWD3 == ""A $PWD4 == ""C $PWD5 == ""L	 $PWDN = 1A; $OPEN/READ UCXCONFIG$PWD_FILE SYS$MANAGER:UCXCONFIG-PWD.TMPR
 $PWD_LOOP:* $READ /END=CLOSE UCXCONFIG$PWD_FILE RECORD $PWD = F$ELEMENT(0," ",RECORD)# $IF PWD .EQS. "" THEN GOTO PWD_LOOPT $PWD                                                                                                                                                                                                                                                   L                        (_Q $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                        ` "     
      'PWDN' == PWD  $PWDN = PWDN + 1" $IF PWDN .LE. 5 THEN GOTO PWD_LOOP $NO_CHANGES:' $IF PWDN .LT. 2 THEN GOTO PSWD_FILE_ERRD $CLOSE:R $CLOSE UCXCONFIG$PWD_FILED	 $SET NOONE $DEFINE/USER SYS$OUTPUT NL:E $DEFINE/USER SYS$ERROR NL:- $DELETE/NOLOG SYS$MANAGER:UCXCONFIG-PWD.TMP;*B $PSWRD == PWD1 $PWD1 == ""L $EXIT 1  $PSWD_FILE_ERR:M2 $WARN " Error generating password - Using default" $PSWRD == "knme3rovne" $exit 1A $endsubroutine $CREATE_NOBODY: SUBROUTINEE $IF (F$IDENTIFIER("UCX$NOBODY", "NAME_TO_NUMBER") .NE. 0) THEN EXIT 1D	 $SET NOONX $UCX$NUICG == 3375@ $IF F$TRNLNM("UCX$ASK_GROUP_UIC") .EQS. "" THEN GOTO ADD_ACCOUNT $SAY " "E $SAY "	UCX$NOBODY Account requires a UIC group number that is unique"FK $SAY "	For security reasons no other accounts should be in the same group."A $SAY " " $GET_UIC_GROUP:O $READ SYS$COMMAND UCX$NUICG - B /PROMPT="Enter a unique UIC group number for the NOBODY account: " $DEFINE/USER SYS$OUTPUT NL:I $DEFINE/USER SYS$ERROR NL:  $TEMP = f$integer(%O'UCX$NUICG') $IF .NOT. $STATUSX $THENC$ $SAY "Please enter an Octal number." $GOTO GET_UIC_GROUPF $ENDIF
 $ADD_ACCOUNT:  $DEFINE/USER SYS$OUTPUT NL:E $DEFINE/USER SYS$ERROR NL:$ $UCX$UAF SHOW/BRIEF [''UCX$NUICG',*] $IF $STATUSD $THEN:  $DEFINE/USER SYS$OUTPUT ACCT.TMP $DEFINE/USER SYS$ERROR NL: $UCX$UAF SHOW/BRIEF ANONYMOUS' $DEFINE/USER SYS$OUTPUT NL:S $DEFINE/USER SYS$ERROR NL:  $SEARCH ACCT.TMP "[''UIC$UICG'," $IF $STATUS .NE. 1 $THEN$3 $SAY "The group number ''UIC$UICG' already exists."F= $SAY "The UCX$NOBODY account requires a unique group number."C $SAY " " $SAY "Please try again." $DELETE/NOLOG ACCT.TMP;* $GOTO GET_UIC_GROUP. $ELSES $DELETE/NOLOG ACCT.TMP;* $ENDIF $ENDIF $SET ONE $SAY " "" $SAY "Creating UCX$NOBODY Account" $SAY " " $UCX$UICG_SAVE = UCX$UICGE $UCX$UICG == UCX$NUICGD $CALL CREATE_ACCOUNT "UCX$NOBODY" 4 "UCX$NOBODY.DAT" "SYS$SYSDEVICE" $NSTAT = $STATUS $UCX$UICG == UCX$UICG_SAVE $exit NSTATR $ENDSUBROUTINE $CREATE_ANONYMOUS: SUBROUTINEX8 $IF (F$IDENTIFIER("ANONYMOUS", "NAME_TO_NUMBER") .NE. 0) $THENl $SAY " "E $WARN "The Anonymous account already exists. If you wish to recreate"U9 $SAY "this account then first remove it using AUTHORIZE."F $SAY " " $GOTO ANON_EXITT $ENDIF9 $NOBODY_ID = F$IDENTIFIER("UCX$NOBODY", "NAME_TO_NUMBER")S $IF (NOBODY_ID .NE. 0) $THENS" $FTP_GRP = F$FAO ("!%U",NOBODY_ID)$ $FTP_GRP = F$ELEMENT (0,",",FTP_GRP)$ $FTP_GRP = F$ELEMENT (1,"[",FTP_GRP) $ELSE  $FTP_GRP = "3375"U $ENDIF $UCX$NUICG == FTP_GRPf $SAY " "K $SAY "	The ANONYMOUS Account defaults to UCX$NOBODY UIC group number. For " K $SAY "	security reasons it is a good idea not to configure other accounts " ' $SAY "	in the same group as ANONYMOUS.". $SAY " " $GET_UIC_GROUP:d	 $SET NOON @ $READ/END_OF_FILE=ANON_ERROR/ERROR=ANON_ERROR SYS$COMMAND UICG -O /PROMPT="Enter the UIC group number for the ANONYMOUS account [''UCX$NUICG']: "0 $IF UICG .EQS. ""W $THEN0 $UCX$NUICG == FTP_GRPP $ELSEN $UCX$NUICG == UICG $ENDIF $DEFINE/USER SYS$OUTPUT NL:I $DEFINE/USER SYS$ERROR NL:  $TEMP = f$integer(%O'UCX$NUICG') $IF .NOT. $STATUSD $THEND$ $SAY "Please enter an Octal number." $GOTO GET_UIC_GROUPW $ENDIF
 $ADD_ACCOUNT:D $DEFINE/USER SYS$OUTPUT NL:P $DEFINE/USER SYS$ERROR NL:$ $UCX$UAF SHOW/BRIEF [''UCX$NUICG',*] $IF $STATUSl $THENr  $DEFINE/USER SYS$OUTPUT ACCT.TMP $DEFINE/USER SYS$ERROR NL: $UCX$UAF SHOW/BRIEF UCX$NOBODY $DEFINE/USER SYS$OUTPUT NL:. $DEFINE/USER SYS$ERROR NL:  $SEARCH ACCT.TMP "[''UIC$UICG'," $IF $STATUS .NE. 1 $THENT $DELETE/NOLOG ACCT.TMP;* $SAY " "Q $SAY "That group number, ''UIC$UICG', already exists, and contains user entries."  $SAY " "I $CALL ASK_BINARY "Do you still wish to use this group ID" Y UCX$GL_RESULTS/ $IF .NOT. UCX$GL_STATUS THEN GOTO GET_UIC_GROUP / $IF .NOT. UCX$GL_RESULT THEN GOTO GET_UIC_GROUP= $ELSEP $DELETE/NOLOG ACCT.TMP;* $ENDIF $ENDIF
 $ANON_DEV: $UCX$ANON_DEV = "SYS$SYSDEVICE"A $SAY " "F $SAY "By default, the ANONYMOUS account will be created with its root"$ $SAY "directory on the system disk."5 $CALL ASK_BINARY "Is this acceptable" Y ucx$gl_resultD, $if .not. ucx$gl_status then goto ANON_ERROR $if .not. ucx$gl_resultN $THEN H $READ/END_OF_FILE=ANON_ERROR/ERROR=ANON_ERROR SYS$COMMAND UCX$ANON_DEV -P /PROMPT="Enter the default device for the ANONYMOUS account [''UCX$ANON_DEV']: "B $IF "''UCX$ANON_DEV'" .EQS. "" THEN UCX$ANON_DEV = "SYS$SYSDEVICE"3 $IF (F$GETDVI("''UCX$ANON_DEV'","DEVCLASS")) .NE. 1s $THENa< $SAY "''UCX$ANON_DEV' is not a disk device. Please reenter." $UCX$ANON_DEV = "SYS$SYSDEVICE"T $GOTO ANON_DEV $ENDIF $ENDIF $SAY " "! $SAY "Creating ANONYMOUS Account"N $SAY " " $UCX$UICG_SAVE = UCX$UICGR $UCX$UICG == UCX$NUICGE $CALL CREATE_ACCOUNT "ANONYMOUS" 4 "UCX$NOBODY.DAT" "''UCX$ANON_DEV'"o $NSTAT = $STATUS $UCX$UICG == UCX$UICG_SAVE$ $IF .NOT. NSTAT THEN GOTO ERROR_EXIT $DEFINE/USER SYS$OUTPUT NL:" $DEFINE/USER SYS$ERROR NL: $UCX$UAF SHOW ANONYMOUSP $IF $STATUSa $THEN  $DEFINE/USER SYS$OUTPUT NL:D $DEFINE/USER SYS$ERROR NL: $UCX$UAF MODIFY ANONYMOUS -Sv /NOPASSWORD/LGICMD=_NL:/FLAGS=(DisCtlY,DefCLI,LockPwd,Restricted,DisWelcome,DisNewMail,DisMail,DisReport,DisReconnect) $IF .NOT. $STATUSD $THEND $SAY " "@ $WARN "	Error modifying ANONYMOUS Account Flags, check account." $SAY " " $ENDIFC $IF (F$SEARCH("''UCX$ANON_DEV'"+":[000000]ANONYMOUS.DIR")) .NES. ""  $THEN/A $SET FILE/PROTECTION=(S:RWE,O:RWE,G:RE,W:RE)/OWNER_UIC=[SYSTEM] -S$ 'UCX$ANON_DEV':[000000]ANONYMOUS.DIR  $SET DIRECTORY/VERSION_LIMIT=3 -! 'UCX$ANON_DEV':[000000.ANONYMOUS]Y $ENDIF $ELSEb $SAY " "O $WARN "%UCX-E-ANONCRE - ANONYMOUS Account creation error, account not created."e $GOTO ANON_ERROR $ENDIFW $CALL ASK_BINARY "Do you want to allow ANONYMOUS users to create files" N ucx$gl_resultT, $if .not. ucx$gl_status then goto ANON_ERROR $if ucx$gl_resultB $THENo2 $SERV_DIR = "''UCX$ANON_DEV'"+":[ANONYMOUS.INPUT]"C $IF (F$SEARCH("''UCX$ANON_DEV'"+":[000000]ANONYMOUS.DIR")) .NES. """ $THENDB $CREATE/DIRECTORY/VERSION_LIMIT=1 'SERV_DIR' /OWNER_UIC=[SYSTEM] -) /PROTECTION=(S:RWED,O:RWED,G:RWED,W:RWED)N $ENDIF $ELSET7 $SERV_DIR = "''UCX$ANON_DEV'"+":[ANONYMOUS]INPUT.DIR;*"YI $IF (F$SEARCH("''UCX$ANON_DEV'"+":[000000.ANONYMOUS]INPUT.DIR")) .NES. ""U $THEN" $DELETE 'SERV_DIR' $ENDIF $ENDIF $ANON_EXIT:.2 $IF F$TRNLNM ("UCX$FTP_ANONYMOUS") .EQS. "" THEN -E DEFINE UCX$FTP_ANONYMOUS SYS$SYSDEVICE:[UCX$FTP]UCX$FTP_ANONYMOUS.LOG + $IF F$SEARCH ("UCX$FTP_ANONYMOUS") .NES. ""F $THEN=& $SET FILE/PROT=W:RWE UCX$FTP_ANONYMOUS $ELSET& $OPEN/WRITE UCX$ANON UCX$FTP_ANONYMOUS $WRITE UCX$ANON "$ !+"@ $WRITE UCX$ANON "$ ! Anonymous Log File - Created by UCX$CONFIG" $WRITE UCX$ANON "$ !+" $CLOSE UCX$ANON"& $SET FILE/PROT=W:RWE UCX$FTP_ANONYMOUS $ENDIF $EXIT 1r $ANON_ERROR:
 $EXIT $STATUSa $ERROR_EXIT: $EXIT NSTATS $ENDSUBROUTINE $ask_binary: subroutineA$ $ucx$t_prompt = f$edit( p1, "TRIM" ) $ucx$t_default = p2- $ucx$t_result = p3  $ucx$gl_status == 268435456 + 208 $ucx$t_default = f$edit( ucx$t_default, "TRIM, UPCASE" ) $if ucx$t_default .eqs. "N"N $thenN $ucx$t_default = " [NO]" $'ucx$t_result == 0L $ucx$gl_status == 268435456 + 1T $endif $if ucx$t_default .eqs. "Y"N $thenA $ucx$t_default = " [YES]"e $'ucx$t_result == 1" $ucx$gl_status == 268435456 + 1A $endif& $if .not. ucx$gl_status then goto exit= $ucx$t_prompt_2 = "* " + ucx$t_prompt + ucx$t_default + " ? "I $loop: $ucx$gl_status == 268435456O $read sys$command ucx$t_input -E /end_of_file=end_of_file -
 /error=exit -D	 /notime -S /prompt="''ucx$t_prompt_2'"S, $ucx$t_input = f$edit( ucx$t_input, "TRIM" ) $ucx$gl_status == 268435456 + 1L' $if ucx$t_input .eqs. "" then goto exitt4 $ucx$t_input = "*" + f$edit( ucx$t_input, "UPCASE" ) $ucx$t_answer_list = "*YES,*NO"L< $ucx$l_position = f$locate( ucx$t_input, ucx$t_answer_list )5 $if ucx$l_position .eq. f$length( ucx$t_answer_list )U $then 4 $SAY "UCX-W-YESNO - you may enter YES, NO or CTRL\Z"
 $goto loop $endif $if ucx$l_position .eq. 0_ $thenU $'ucx$t_result == 1S $elseA $'ucx$t_result == 0d $endif $ucx$gl_status == 268435456 + 1a
 $goto exit
 $end_of_file:i# $ucx$gl_status == 268435456 + 98938S $exit: $exiti $endsubroutine $CREATE_CONTROLLERS: subroutines	 $SET NOONg $UCX GENERATE CONTROLLER  $IF "''UCX$CONT_LOCAL'" .EQS. "" $THEN=1 $UCX DEFINE COMMUNICATION LO /INTER=L /TYPE=LOCALV0 $UCX DEFINE COMMUNICATION WI /INTER=W /TYPE=WIRE $UCX GENERATE CONTROLLER $ENDIF1 $STRING_LENGTH = F$LENGTH("''UCX$CONT_ETHERNET'")=D $IF F$LOCATE("EC:","''UCX$CONT_ETHERNET'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION EC /INTER=C /TYPE=(ETHER,CLUST)D $IF F$LOCATE("XE:","''UCX$CONT_ETHERNET'") .EQ. STRING_LENGTH THEN -8 UCX                                                                                                                                                                                                                                                    M                        a $      UCX042.B                       J  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CONFIG.COM;1                                                                            v    0                        G            DEFINE COMMUNICATION XE /INTER=D /TYPE=(ETHER,CLUST)D $IF F$LOCATE("EF:","''UCX$CONT_ETHERNET'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION EF /INTER=F /TYPE=(ETHER,CLUST)D $IF F$LOCATE("ET:","''UCX$CONT_ETHERNET'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION ET /INTER=N /TYPE=(ETHER,CLUST)D $IF F$LOCATE("XQ:","''UCX$CONT_ETHERNET'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION XQ /INTER=Q /TYPE=(ETHER,CLUST)D $IF F$LOCATE("ER:","''UCX$CONT_ETHERNET'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION ER /INTER=R /TYPE=(ETHER,CLUST)D $IF F$LOCATE("ES:","''UCX$CONT_ETHERNET'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION ES /INTER=S /TYPE=(ETHER,CLUST)D $IF F$LOCATE("EX:","''UCX$CONT_ETHERNET'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION EX /INTER=X /TYPE=(ETHER,CLUST)D $IF F$LOCATE("EZ:","''UCX$CONT_ETHERNET'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION EZ /INTER=Z /TYPE=(ETHER,CLUST)D $IF F$LOCATE("EW:","''UCX$CONT_ETHERNET'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION EW /INTER=W /TYPE=(ETHER,CLUST)D $IF F$LOCATE("EO:","''UCX$CONT_ETHERNET'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION EO /INTER=O /TYPE=(ETHER,CLUST)- $STRING_LENGTH = F$LENGTH("''UCX$CONT_FDDI'")E@ $IF F$LOCATE("FW:","''UCX$CONT_FDDI'") .EQ. STRING_LENGTH THEN -7 UCX DEFINE COMMUNICATION FW /INTER=W /TYPE=(FDDI,CLUST)"@ $IF F$LOCATE("FA:","''UCX$CONT_FDDI'") .EQ. STRING_LENGTH THEN -7 UCX DEFINE COMMUNICATION FA /INTER=A /TYPE=(FDDI,CLUST)E@ $IF F$LOCATE("FC:","''UCX$CONT_FDDI'") .EQ. STRING_LENGTH THEN -7 UCX DEFINE COMMUNICATION FC /INTER=C /TYPE=(FDDI,CLUST)]@ $IF F$LOCATE("FX:","''UCX$CONT_FDDI'") .EQ. STRING_LENGTH THEN -7 UCX DEFINE COMMUNICATION FX /INTER=F /TYPE=(FDDI,CLUST)"@ $IF F$LOCATE("FR:","''UCX$CONT_FDDI'") .EQ. STRING_LENGTH THEN -7 UCX DEFINE COMMUNICATION FR /INTER=R /TYPE=(FDDI,CLUST)"@ $IF F$LOCATE("FQ:","''UCX$CONT_FDDI'") .EQ. STRING_LENGTH THEN -7 UCX DEFINE COMMUNICATION FQ /INTER=Q /TYPE=(FDDI,CLUST) @ $IF F$LOCATE("CL:","''UCX$CONT_FDDI'") .EQ. STRING_LENGTH THEN -3 UCX DEFINE COMMUNICATION CL /INTER=I /TYPE=(FDDI) -R /DESCRIPTION="ATM Classical IP"F@ $IF F$LOCATE("EL:","''UCX$CONT_FDDI'") .EQ. STRING_LENGTH THEN -3 UCX DEFINE COMMUNICATION EL /INTER=L /TYPE=(FDDI) -p /DESCRIPTION="ATM Emulated LAN"x3 $STRING_LENGTH = F$LENGTH("''UCX$CONT_TOKEN_RING'")=F $IF F$LOCATE("IC:","''UCX$CONT_TOKEN_RING'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION IC /INTER=C /TYPE=(TOKEN,CLUST)F $IF F$LOCATE("IR:","''UCX$CONT_TOKEN_RING'") .EQ. STRING_LENGTH THEN -8 UCX DEFINE COMMUNICATION IR /INTER=R /TYPE=(TOKEN,CLUST)/ $STRING_LENGTH = F$LENGTH("''UCX$CONT_SERIAL'") B $IF F$LOCATE("SL:","''UCX$CONT_SERIAL'") .EQ. STRING_LENGTH THEN -5 UCX DEFINE COMMUNICATION SL /INTER=S /TYPE=(SERIAL) -  /DESCRIPTION="SLIP"t, $STRING_LENGTH = F$LENGTH("''UCX$CONT_PPP'")? $IF F$LOCATE("PP:","''UCX$CONT_PPP'") .EQ. STRING_LENGTH THEN -p2 UCX DEFINE COMMUNICATION PP /INTER=P /TYPE=(PPP) -& /DESCRIPTION="Point to Point Protocol" $UCX GENERATE CONTROLLER $SET ONs $exite $endsubroutine $UCX$WARN: subroutinei $UCX_WAIT == 1 $SAY "''P1'" $exit: $exitt $endsubroutine $UCX$INFORM: subroutinee $UCX_DELAY == 1x $SAY "''P1'" $exit  $endsubroutine $NOT_YET: subroutine $SAY " "= $WARN "Sorry, but this function is not currently implemented"" $SAY " " $exitd $endsubroutine                                                                                                                                                                                                                             : * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$DNFS_SHUTDOWN.COM;1 +  ,  c   .     / #   4 T       V                   - P    0   1    2   3      K  P   W   O     5   6  ?  7 aBu؛  8          9          G    H  J         
            $ !+
$ !           UCX$DNFS_SHUTDOWN.COM -- Digital TCP/IP Services for OpenVMS Software,
$ !                                    NFS Client shutdown
$ !
$ !                        COPYRIGHT (C) 1994, 1995 BY
$ !                    DIGITAL EQUIPMENT CORPORATION, MAYNARD
$ !                     MASSACHUSETTS.  ALL RIGHTS RESERVED.
$ !
$ !  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
$ !  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
$ !  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
$ !  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
$ !  PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
$ !
$ !  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
$ !  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
$ !
$ !  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
$ !  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
$ !
$ ! Modifications
$ !
$ ! 13-Jun-1994	Michael Kimmel		Initial with DNFC_SHUTDOWN as prototype
$ !
$ !- 
$ REQUIRED_PRIVILEGES = "OPER,WORLD,SYSPRV,SYSNAM,CMKRNL"
$ PREV_PRIVS = F$SETPRV(REQUIRED_PRIVILEGES)
$ IF .NOT. F$PRIVILEGE(REQUIRED_PRIVILEGES) THEN GOTO NO_PRIVILEGES
$ !
$ ON CONTROL_Y THEN GOTO EXIT
$ ON ERROR THEN GOTO EXIT
$ !
$ ! Dismount all DNFS devices.
$ !
$ SHUTDOWN$DISMOUNT_DNFS_LOOP:
$    SET NOON
$    DEVICE = F$DEVICE("*DNFS*")
$    IF DEVICE .NES. ""
$    THEN
$	IF F$GETDVI(DEVICE,"MNT") THEN UCX DISMOUNT 'DEVICE'
$       GOTO SHUTDOWN$DISMOUNT_DNFS_LOOP
$       ENDIF
$EXIT:
$ !
$ LIBRARY = F$TRNLNM ("UCX$DNFSDISMOUNT")
$ IF LIBRARY .NES. ""
$ THEN
$	IF F$FILE (LIBRARY,"KNOWN") THEN INSTALL DELETE 'LIBRARY'
$	DEASS/SYSTEM/EXEC UCX$DNFSDISMOUNT
$ ENDIF
$ LIBRARY = F$TRNLNM ("UCX$DNFSMOUNT")
$ IF LIBRARY .NES. ""
$ THEN
$	IF F$FILE (LIBRARY,"KNOWN") THEN INSTALL DELETE 'LIBRARY'
$	DEASS/SYSTEM/EXEC UCX$DNFSMOUNT
$ ENDIF
$ !
$ tmp = F$TRNLNM ("UCX$DNFSACP")
$ IF tmp .NES. "" THEN DEASS/SYSTEM/EXEC UCX$DNFSACP
$ tmp = F$TRNLNM ("UCX$DNFSDRIVER")
$ IF tmp .NES. "" THEN DEASS/SYSTEM/EXEC UCX$DNFSDRIVER
$ !
$ PREV_PRIVS = F$SETPRV(PREV_PRIVS)
$ EXIT
$NO_PRIVILEGES:
$ WRITE SYS$OUTPUT "Insufficient privileges to DISMOUNT the NFS Client Devices"
$ WRITE SYS$OUTPUT "NFS Client Shutdown Requires ''REQUIRED_PRIVILEGES' privileges."
$ GOTO EXIT
                                                                                                                                                                                       2 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP.OLB;1 +  , c
   .     / #   4                             - P    0   1    2   3      K  P   W   O     5   6 Aqt؛  7 Ou؛  8          9          G    H  J                               %
   VAX-11 Librarian V04-00        qt؛ !_qt؛ !                      +      2         K                                                                                                                                                                                                                                                                                                                                                                                                             ]         E   	CLONE_BUFE   	CLONE_OCTE   	CLONE_OIDE   CMP_OCTE   CMP_OIDE   CMP_OID_PREFIX3    ESNMP_ARE_YOU_THERE   ESNMP_GETSHM3    
ESNMP_INITV   d 	ESNMP_LOGV   d 
ESNMP_LOGSq    
ESNMP_POLL3    ESNMP_REGISTERE   ESNMP_SYSUPTIME3    
ESNMP_TERM3    
ESNMP_TRAP3    ESNMP_UNREGISTER    FFSE   FREE_OCTE   FREE_OIDE   FREE_VARBIND_DATA   GETCLOCK   GETTIMEOFDAYE   INST2IPE   INSTANCE2OIDV   d IS_DEBUG_LEVELE   MEM2OCTE   OID2INSTANCE                     ESNMPLIB_VECTORS3    
ESNMP_INITE   	ESNMP_LIBV   d 	ESNMP_LOGk   z 
ESNMP_PACKq    
ESNMP_POLL    ESNMP_UNPACK   OS_MIBS_SHM    STRINGS   8 SYSLOG   TIME                                                                                                                                                                                                                                                                                                                                        k   z __ENCODE_VARBINDq    __ENQUEUE_TRAPk   z __ESNMP_PACK3    __ESNMP_SEND_REGISTERq    __ESNMP_TIMEBASE    __ESNMP_UNPACK    
__FREE_HDR    __FREE_VARBINDV   d __GET_ACTION_CODE3    __GET_MAX_SUBTREES3    
__GET_SUBTREEq    __LOAD_VALUE    
__NEW_VARBINDV   d __PRINT_HDRV   d 
__PRINT_OCTETV   d __PRINT_VARBIND3    
__RECV_PACKET3    
__SEND_PACKET3    __SET_ESNMP_STATEV   d __SET_PROGNAMEV   d __SNMPERRORTEXT                                                                                                                                                                                                       N                        1A $      UCX042.B                       c  P  4[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$CKNTTM-IEI0$lk
v
1                                                                                               :             }p_O\ʼfMW'缾ɳ}'% $`	 /h&	+4if%x"bJ
/L-rX>b4d7HQ~v Z nz&Nv$TUhR48SCU|RgR/'Wg
Ϻя{	dъC5y8V0h
Z0dۭϼc;ʋ軃9Z? 7ڿ=6yj5e>B8K ZNAVU O8qړ,cDB~37KDAwę;ùPԤ]~φr\3dk-i	V	F&2k_]u^
BI,>q%X5E;k:bF$op=&eZz:"=m]"C%s' ^{M:DU
3^Ȏ.47Rd	v7I!.} )K!d)A\i焨Pk2T6 C\{`öf0d`$K5Fؒ7
Md-MfTz4	Q^mdNC*w}(u+F?£J'mn$$ne;R64Oҍ/dM=, KXv$%Yq^Eb"C<JzWRoAR5 x9M-X.<z}޵mu-_ۣBR˥afo0,&zڈcSCNo?ʽ82BQFcw9QiKcGZmc4bRJ}7J.UDT_v1J
e5
Zb{s)uh1P~q`vOץDЀ4=9<5;o֘Scm
IH,Ur9!ɓ.79X}ĦbXDFcw@Rk'iDoײ5O-Ѐ*-]i|HȠ-#".L^9rV>l-tvC3q;Y)lkg#{9!ݣwAҭVztPK]XzQh+PEw/J2u\x_C2z#{qJ10*ݥ@,Ti	<iZMLL͋*ˣE2'hBt'}[~5e@ qm=ӟ+pɀUփIsF)+L,fc'%.߽o2tv4Nȡ*2)s	st#:TZ
SZl~͓!Je@l2L.T0/cr
#|NOIxH|KSz|Kf.}MY~h1nJk$<ȸ|Bcn%ͨo

۟p)FmeExtƭOg/ (\Hꩩ<P	JZ>N|n,~FD̶*-]U-5N_HX[/Hjm|plz`Pw[Y{ssp!#4u(@]@Il
#|ϣ,Ȧo2gxPuS4ʔ$:j~"H2:3wL3LG=51ϯBx6|zUh[u|9L<BQ7+nVUG!]hqF=&FBG<X҉+ilhsyv[#UalU#>~i! +|#Jsѳ" xl~Hș)wCs\I@W{pm!IR[F5'Q_3ԯU!@7OIvMqX<X 2CF6,h&QNtճȆy@t:"t#(Rz,qO GDyVLmy3{=dYY
A
6je^?p_MH?BڵK|YQ=391DGm1DEfEx FRR^cfs [K6>37mz٪145~l#\sJ;儏ף3*l7$]вZDWã~K`
 pIk.|3mImZwG:7->saqS7>n3 O2fJ ln́p5+o-zԛ,:!xC硛 Cӥg\pL1yưQ,e^7P`}cib!DYطf TZsu2b!T"_MVhGc*X|l ?iaçֺMetEtK/TqC0><K
CI0)MK;̬~_6z{_ua53fy

i=pR4X1f{h5iD\7w.Q/K "a`E@<#]{$3_SJcT'qWW%O[' @,D#}mqyƠQU䴋y<lx
AXahFP@!3JH)+&y[ubUg[qTWI}`#Y33v&7E9)xTR>fagjeZo.@8q67?˘6ή6,ď_Jڧ#+s:B:l^u cy`䣠RCge]ZaeL]/C{YFM jƎY# 
zb} 7.liIJ$5}|tQ /b^R	L:;BpBO~CLT_jՄj(F^J\qLL1}ǡO ik^K5&cc`!ˢcOr
TH^1X@0-?)JL00?%p.jӤr]<.h;q'o<?l6fA׼jvM]2A6H\6Gbe䫽N&TI[Cffo	XycO7ؚ$EOO!4k9tf/{p
eMD#(3jD_|G$CP89洑?/!\漣}2I"A|Q}wg3?Sڑ8ج"%
OI'iWo&y\D>\lG&?,fܩw R,B7ZMg1[r{1۝{d%䐹(D0q*aiȅ$+^ 3<@8u%.N]|Zh]M:$eDd!b%saO(!}txб[9nŨ%HF^;@iFŦC*l6Q{  mk[x.WO{^I0<H,aGЧQI#| .;DL3^ 
Vf-FbwLZe|qኯD8AoPiHz^r(!;metnTf>525y3]&#gaY75fzRC!*I2s._m`I/(;8NSoƹ[JW	UF-<9}pXuLũfekP 90۞cQHi
g0M%&3dlA)uBnب=Q6ɴ(s{/꣰:o	md'=26X UзàzX(wvf(dBRk+ZL<TsOhNaXSϡ	j[	kj[rIoˊfsZe%ôXjh˽>lHF
Ƈ0%m>un1 7˦q
;+3KAZ%jeȨCmo"	E]cj_,'mIQ򕑮M_΂*vb |SSu9uأp.r|HM;JX	gO0]0ξx9&WI8><1VkiyщYYiom
jq+{8[<t6vM-f[l|[_)w#쎀MoYL8*T=lCXN"eFn@
fS䠫{>"x.iao$
0ŮD)^2?@Afoxw@{azD}xH*t=GXhqE#|$j!.xo[OEvfH9B7qџ'1:xS.k3͕Q2>:*7d8@4H*#MHI!0kTٓ܋HSPxzEz{Cy'nYd)W*&:[r~bu ?`ܛ<5[޷
w^0f$mxS@CCGxnDW%>G-2U
I
"*f	\K*	
%auS#@-sJAfQ^?=Q8&A#4<#߸u!%='8R3GQruO$_LZpW1 Z[}g "EhXHCj7HkԼq>qdchF<ъʣI<L{I%>i)!Ez_:EY3}F|1%ja}~p.a֨VZE]ym]ReH4~r	V3~qu[-qmlmug/a@!&  *rd[r_']g~W>(1]jӎ]I!y)I,q-+LUR!kP{|&ƩOh11}sG:C{eXkCj3ӓkl:?6=U0zx~
R$ݨ޻m +J [8G2+TtxѸ}6iۯRV:1RjlLA+I93iN^Sg!:ݍ!%:#pSF͢yp61Al32NqX \$a)e:|.oZ#cuU#x
|h}0ǚƓ{˶LŮWchevJL6WDX:pd6-)e.8'~(#f-l`)XW XK_m,%a QՒE 
EK|
R_Ly"dGr s JBJM_:'`dBǑ2`TK8VkⱏF#|
6cK=Rx?YިFA}Gv+m!\%5jrvŐsz3D]!쑶qzj,}{>bOY[Ƥ.QiO*?,<E3  zi`^yU& :.aZ{CX{5uglR Bۄ:nvۛ	~9{iuxrِ&=uA*eb兊=d-=v+;5.ADtlQO@}Mxf xfԻɴ͒*Pmo(Iv AyB	Fh$,:r~"!ޭ{ NqP9Ts}Vy/00Z!\4 Y,a\X/V	M.ںo[؋/387d&|yJBo"^k*n
ެ?CqlW7/&͐qERM,`T6cLoľy0a)3B
8XE)IC*јi!=$UaWaTM_@(d*kBЮמ0&McLi7BEiLIԃO&/ueKu2)OBp~yM`Vԯ<s-DM wG"iZ;}S
Į=6Af"~爿 &	ОL=X'dnvŌ[~WB{uvc[~N>*2H"6
P#pBFPm`".סyiΘ$꿯Ϯu;dFrc. yǕނ"9! N]7	?WND@JCt/E(#y6a5JY
1*-^JhhYƉ׭.J52qL?v'1&8/f"SlQD&0sYKQTI13I¼gmΧazgǜp'b.DMpN4=8SL
0e6yL/,\;cm'<{+,D	0J3C&_\
nanHOx],h:xɶ7ꋶo5kf}	`Yi}7Z*_6LYSa?y]oS]OaSc4m+_ҙgi S^f尉Y
$|#":n0;Gew$AɄkNǣӎAݗ.ф,(R7U{P\/6Բ<fQR-5A+hՔ
XWЬ
R%\]NW\=|ٹ~%,~q!woMn|]4wǋ;3lsK˳SSZ~dcd]>Q2<ß+|:"qn[
vf~}lEH.v̽FHJkM0㇞0@~r[W>E?mDHF=PM nE*-Nmg)xdY gu'<ּI?\n_>W){R+@PǵN	Ii=a"\DRxUg298ʰ9Hz5@+wwM:
U\[/n0ݸjfb9$n"V445ITul~<K"$S=u &&kW+'bh}XYma0𳢱צ2md\TN?_Dk5%3
=u^ܾ8+W`.teǏ/{c@[_~ۍݡۨʲYb3~I4rfF`dTeb|Cϯ=%M9"C&cؼ= (-Fm:PQ3Fn^՛U^ۃw
	VBeM=qyJ$w~/ػ	)MP L\weoxd*p|c'>tE*e&H*k%=/f
gR
r47{pհ6E{+Lƞz8!9 B"eRyLX<*gC*leevrf$G A޾^~ʜ<?7+:_&e3
z=ߔpoeԍwtۖڂb	CTƤߩڬxGjWŕq@2ۡU}2'NBLKPБH>Q.YI<X:'}x)KvAd LHa >^Ux!v0Nqn}14LW
3{zGu
tFf=}NK[zర	DLynD01x;'˶6Y,IOwJ3aQYp?,4&e_8$y`&*
-C&]_ڏ9ag֥ˇcDC`LP5: #%{Sh*>5'a5Oˑ{-,^SA勒wMN 7.Nj=4D+R^v|*U[kzR@@#O$B.LAۄFTUhOǃU]^I.=F).b励AHJxzֿ>~D;$%Nqx\ĥV   d __SET_PROGNAMEV   d __SNMPERRORTEXT                                                                                                                                                                                                       O                        P $      UCX042.B                       c
  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP.OLB;1                                                                                                           E "            I              FREE_OID   OID2INSTANCE   
__DO_UNREG   __SNMPERRORTEXT                                                                                                                                                                                                                                                                                                                                                                                                                                                        8 OPENLOGE   	O_INTEGERE   O_OCTETE   O_OIDE   O_STRINGV   d 
PRINT_VARBINDV   d SET_DEBUG_LEVELE   	SPRINTOIDE   STR2OID    
STRCASECMP    STRDUP   8 SYSLOG3    __DOTS2SUBTREE3    
__DO_UNREG                                                                                                                                                                                                                                                                                              E   FREE_VARBIND_DATA   GETCLOCK   GETIFBYNAME   GETTIMEOFDAYE   INST2IPE   INSTANCE2OIDV   d IS_DEBUG_LEVELE   MEM2OCTE   OID2INSTANCE                                                                                                                                                                                                                                                                                                                                                 	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         P                         $      UCX042.B                       c
  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP.OLB;1                                                                                                           a "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               #                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               %                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               &                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Q                        jK $      UCX042.B                       c
  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP.OLB;1                                                                                                            "     '       (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               +                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               -                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                4   1       qt؛ V1.0-02                         :     
ESNMP_INITV1.0-0219-NOV-1997 13:04                   DEC C V5.0-003 .PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 PReceived %s from %d.%d.%d.%d, port %d
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 PInvalid packet length: %d, received %d
 nPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 VPrecvfrom returned: %s
  PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 PCan't s 5   end: %s
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 PSending (len=%d), %s, to %d.%d.%d.%d, port %d
 rPDISK$UCX_B UILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 LPCould not bind port %d to socket: %s
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 PBInding Socket to port %d
 PeSNMP can't get subagent's host address.
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 PCould not open socket:%s
 :PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNM 6   P]ESNMP_INIT.C;3 PCould not send TRAP message
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 PTRAP: Someone is doing a tra p; %d
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 bPCould not send the ARE_YOU_THERE message
 ,PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 PUNREGISTER request, subtree='%s', reason=%d
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 PRegister (%d) subtree '%s'
 tPDISK$UCX_BUILD2:[UCX.X42.BL21. 7   SRC.SNMP]ESNMP_INIT.C;3 FPTrying to send registeration when not opened
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 PMalloc error 
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 PSubtree '%s' already marked for registeration
 fPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 BPTimeout value %d is out of range.
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3  PTrying to do registeration before calling esnmp_init().
  P/tm 8   p/esnmp_sub  P%s%d  PeSNMP well-known port is not defined.
  Pudp  Pesnmp bPeSNMP can't get master agent's address.
 \P%s_%X >PeSNMP can'  
DECC$CLOSE  
ESNMP_LOGS  	ESNMP_LOG  IS_DEBUG_LEVEL  DPRINTF  DECC$GETPID  
ESNMP_TERM  GETTIMEOFDAY  DECC$GETSERVBYNAME  DECC$GETHOSTBYNAME  __GET_ACTION_CODE  __SET_PROGNAME  __ENCODE_VARBIND  __ESNMP_TIMEBASE  __ENQUEUE_TRAP  
__SEND_PACKET  __ESNMP_SEND_REGISTER  	DECC$TIME  DECC$GE                                                                                                                                                                                                                                                   R                        <C $      UCX042.B                       c
  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP.OLB;1                                                                                                           X "     8        9   TSOCKNAME  DECC$GETHOSTNAME  
DECC$RECVFROM  DECC$SENDTO  	DECC$BIND  DECC$SOCKET  
DECC$STRERROR  DECC$STRLEN t get Process ID.
 <P  PLOCALHOST P μ^ V(
ͼ  __ESNMP_TIMEBASE P GETTIMEOFDAYf  
ESNMP_TERM/ݬ DECC$STRRCHRPR	ЬRPRR __SET_PROGNAME~ ͽ DECC$MEMSET~ͽ DECC$GETHOSTNAME  DECC$GETPIDPR> DPRINTFU1J2 ; DECC$MEMSETRͽ\; 
DECC$DSPRINTF;Wͼ DECC$GETHOSTB :   YNAMEPRݲ DECC$MEMCPYPb DPRINTFU1 Ɣ ƌ  DECC$GETSERVBYNAMEPRƘ  DPRINTFU1 P զ2  DECC$GETPIDP ƿ  
DECC$DSPRINTFPU1 ЬRЦbSզPSRBRbSST T DECC$MEMSETW DECC$STRLEN
PPd
W DECC$STRCPYT 
__SEND_PACKETPUfUUPP< ^ Rb8<  ~ IS_DEBUG_LEVELP"  
ESNMP_LOGS<h~P<  ~ 	ESNMP_LOGU1լ ;   Ѭ<=<  ~ IS_DEBUG_LEVELP%ݬB 
ESNMP_LOGSf<n~P<  ~ 	ESNMP_LOGU1`PTSբvPSP@P`QTUSTPЬPݠݡ DECC$STRCMPP;< ~ IS_DEBUG_LEVELP%ݼ 
ESNMP_LOGS<z~P< ~ 	ESNMP_LOGU1 SSTuPP~ݢ DECC$REALLOCP:<  ~ IS_DEBUG_LEVELP" 
ESNMP_LOGS<~P<  ~ 	ESNMP_LOGU1 PQPQPP@P`QQТTTSCPЬ`ТPCPЬ`ТPCPЬ`  	DECC$TIMEPQТPCPQ <   `ТPCP`bT __ESNMP_SEND_REGISTERPUUUPP^ Td9<  ~ IS_DEBUG_LEVELP"F 
ESNMP_LOGSt<~P<  ~  	ESNMP_LOGX1ЬRRRP@P`P
ՠPQQQU	X1 P~ IS_DEBUG_LEVELP&eݬĬ 
ESNMP_LOGS<~P~ 	ESNMP_LOGS S DECC$MEMSETݥ DECC$STRLENWgPRegPQRQRRRcPPQФPAP`
ФPAP`VݥV DECC$STRCPYVgPPVeV DECC$STRCPYS 
__SE =   ND_PACKETPXXPP ^ SWЬUWV~ IS_DEBUG_LEVELP%Ve 
ESNMP_LOGS,<7~P~ 	ESNMP_LOGХTRգ1RP@P`PTݠ DECC$STRCMPPRPRRPPQQT
QP@RbTTV{cvT T DECC$MEMSETЬUݥ DECC$STRLENPRRRd<<RRR<<RPP  <<Wݥ	 DECC$STRCPYT 
__SEND_PACKETPVVRRP ^ S~ IS_DEBUG_LEVELP'ݬݼ 
ESNMP_LOGS,<7~P~ 	ESNMP_LOG >   ЬPРTRգ3PRP@P`PՠTݠ DECC$STRCMPPRPRRPPQQT
QP@RbTTPP ^ SR R DECC$MEMSETb<<\\\<<\\\  <<R 
__SEND_PACKETPT5<  ~ IS_DEBUG_LEVELP"b 
ESNMP_LOGSÌ<l~P<  ~ 	ESNMP_LOGTT\\PP< ^ S~ IS_DEBUG_LEVELP$ݬ 
ESNMP_LOGS<~P~ 	ESNMP_LOGRb<<PPP<<PPP  <<ЬЬTլݬ ?   T DECC$STRCPYPdT DECC$STRLEN<bQPQPPbT DECC$STRLENPPT<bPP   ~TݬR __ENCODE_VARBINDPU[cR  __ENQUEUE_TRAPPTDR 
__SEND_PACKETPT5<  ~ IS_DEBUG_LEVELP" 
ESNMP_LOGS:<~P<  ~ 	ESNMP_LOGTTUUPP ^ SգT{R R DECC$MEMSETb<<\\\<<\\\  <<	R 
__SEND_PACKETݣ DECC$GETSOCKNAMEݣ 
DECC$CLOSEԣcTTPP ^ RSբ5 @   SP@P`Pՠݬݠ DECC$STRCMPPSPPSSP   \ЬPP  QЬPPP@P`P
ՠPRRRPP    < ^ R  DECC$SOCKETPUUI<  ~ IS_DEBUG_LEVELP4  CMA$TIS_ERRNO_GET_ADDR` 
DECC$STRERRORP 
ESNMP_LOGS<`~P<  ~ 	ESNMP_LOGU1 ~ DECC$GETHOSTNAME DECC$GETHOSTBYNAMEPS DPRINTFU 
DECC$CLOSEU1 ݳt DECC$MEMCPYprT~ IS_DEBUG_LEVELP&< A   r~ 
ESNMP_LOGS<z~P~ 	ESNMP_LOGTpU 	DECC$BINDPT<  ~ IS_DEBUG_LEVELP9  CMA$TIS_ERRNO_GET_ADDR`   R    
ESNMP_INIT     
esnmp_init       esnmp_register       __esnmp_send_register ]    D  esnmp_unregister 0    t  
__do_unreg         esnmp_are_you_there        
esnmp_trap F    	  
esnmp_term      	  __dots2subtree L     	  __get_max_subtrees     B     	  
__get_subtree 2     0
  __set_esnmp_state      <
  open_socket i      
__send_packet        
__recv_packe  DECC$MEMSET  DECC$STRRCHR  DECC$STRCMP  DECC$STRCPY  DECC$MEMCPY  CMA$TIS_ERRNO_GET_ADDR  DECC$REALLOC  
DECC$DSPRINTF 
      
ESNMP_INIT 
    < ESNMP_REGISTER 
    __ESNMP_SEND_REGISTER 
  D   ESNMP_UNREGISTER 
  t   
__DO_UNREG 
      ESNMP_ARE_YOU_THERE 
    < 
ESNMP_TRAP 
  	   
ESNMP_TERM C    
  	   __DOTS2SUBTREE 
  	    __GET_MAX_SUBTREES 
  	   
__GET_SUBTREE 
  0
    __SET_ESNMP_STATE 
     
__SEND_PACKET  
DECC$STRERRORP<r~L 
ESNMP_LOGSr<~~P<  ~ 	ESNMP_LOGU 
DECC$CLOSEUUPP ^ VЬWRR((	P(蚏~ IS_DEBUG_LEVELPE~ __GET_ACTION_CODE<~~~~~P<g~ƨ 
ESNMP_LOGS<~P~ 	ESNMP_LOG <g~ݬݦ DECC$SENDTOPG~ IS_DEBUG_LEVELP3  CMA$TIS_ERRNO_GET_ADDR D   ` 
DECC$STRERRORP 
ESNMP_LOGS <~P~ 	ESNMP_LOGRRRPP< ^ RЬU߭( < ~ݬݢ  t .  		    S        	   D 2 	}    
	 q   $       E     
   	 	    
    
	             6  
    < 
__RECV_PACKET  
  $CODE d  $DATA 
DECC$RECVFROMPT] CMA$TIS_ERRNO_GET_ADDRS c`#H c`@< ~ IS_DEBUG_LEVELP0 c` 
DECC$STRERRORPV 
ESNMP_LOGSn<~P< ~ 	ESNM F   P_LOGS1 <ePPT<< ~ IS_DEBUG_LEVELP'T<e~¨ 
ESNMP_LOGS<~P< ~ 	ESNMP_LOGSV~ IS_DEBUG_LEVELPE~ __GET_ACTION_CODEPQ<*~/~.~-~,~Q 
ESNMP_LOGS.<
~P~ 	ESNMP_LOGSSP        w w 1       aqt؛ V1.0-01                         9     	ESNMP_LIBV1.0-0119-NOV-1997 13:04                    DEC C V5.0-003PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 Pgettimeofday returned failure
 PDISK$UC G   X_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 hPo_string; Wrong data type for a string
 ,PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3  Po_string; IpAddress does not have length 4
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 Po_string; Null Varbind or object
 pPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 QPo_oid; Null Varbind or object
  PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 Po_octet; Invalid first byte
 PDISK$UC H   X_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 Po_octet; value too big for DisplayString
 jPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 DPo_octet; value too big for IpAddress
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 Po_octet; Null Varbind or object
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 PCannot use o_integer for this object type; % d
 TPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 0Po_integer; value out of range; I    %lx
  PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3  Po_integer; Null Varbind or object
  PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3  POut of memory
 ]PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 NPOut of memory
 LP. GP%s%u PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 POut of Memory
  P0   P^ XVfRЬP`PhU ȬTdPsR   jPdSS.UW1;PP>RBfU5 DECC$GA___CTYPEQˏ SP@aP                                                                                                                                                                                                                                                   S                        Ge $      UCX042.B                       c
  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP.OLB;1                                                                                                           v "     I        J   P
BfP0SSPBfUPW1 PTdP	R   U	R   W1 PЬS1 RcURTxTTTT~ DECC$MALLOCPS*UTUS DECC$MEMCPYPT S DECC$MEMSETDc4P< ~ IS_DEBUG_LEVELP"Ȓ  
ESNMP_LOGSȡ <~P< ~ 	ESNMP_LOGSRЬPR5< ~ IS_DEBUG_LEVELP 
ESNMP_LOGS~P< ~ 	ESNMP_LOGWPЬWWP ^ TެWgQa?PЬUFVSa/  R CVGU 
DECC$DSPRINTFLVU DECC$STRLENPUSSbЬPP| ^  K   UЬTդ
ݤ 	DECC$FREEԤdЬSЬRcc~ DECC$CALLOCPc9գ4< ~ IS_DEBUG_LEVELP N 
ESNMP_LOGS]<~P< ~ 	ESNMP_LOGVGЬPРSRެTdPR  PBRRQެTQdЬRAbQQdЬVVP ЬQЬPРPPaT@SRTRЬQЃaRRTRTP ^ VլW1PЬRբ
ݢ 	DECC$FREEԢbЬP	ՠ`螭ԽЭPԠЬRb螭вЭPԠЬP`РUx`SSS~ DECC$MALLOCPT*USUT DECC$M L   EMCPYPS T DECC$MEMSETCd4P< ~ IS_DEBUG_LEVELP"ƒ  
ESNMP_LOGSơ <~P< ~ 	ESNMP_LOGTRЬPR`ՠWPЬWWP  ^ЬPՠ
ݠ 	DECC$FREEЬPԠ   ^ SլԬЬRR~ DECC$MALLOCPT0լRݬT DECC$MEMCPYPR T DECC$MEMSETЬP@d4P< ~ IS_DEBUG_LEVELP"Ò  
ESNMP_LOGSá <~P< ~ 	ESNMP_LOGTPP ^ЬSSЬRR   DECC$GA___CTYPE  GETTIMEOFDAY  CMP_OID_PREFIX  
ESNMP_LOGS  	ESN M   MP_LOG  IS_DEBUG_LEVEL  STR2OID  __LOAD_VALUE  __ESNMP_TIMEBASE  DECC$STRLEN  DECC$MEMSET  DECC$MEMCMP  DECC$MEMCPY  
DECC$DSPRINTF  DECC$MALLOC  	DECC$FREE  DECC$CALLOC 
      STR2OID 
     	SPRINTOID 
    | INSTANCE2OID 
     OID2INSTANCE 
     	CLONE_OID 
      FREE_OID 
  <   	CLONE_BUF 
     CMP_OID 
     CMP_OID_PREFIX  CMP_OID_PREFIXPQbcQQPP QռC   SQ T3cPްRЬPްPAbA`TAbA`T N   
QQTTPP Լլ>ѬT1 PP%ެRbS@c   Td޼Q@ @aPTQPЬRRԬRQPRQQ+ЬSAcRR   	Լ޼PRA`ԬQЬTTP< ^ TЬЬQQQЬUQRRR~ DECC$MALLOCPS(URUS DECC$MEMCPYR S DECC$MEMSETBc4P< ~ IS_DEBUG_LEVELP"Ē  
ESNMP_LOGSġ <~P< ~ 	ESNMP_LOGSQЬPQ`ՠPPЬPP< ^ЬTդЬP	ՠ`UiUcPЬRբЬP	ՠ`UBPU;Pdb O   bSPdSSݢݤ DECC$MEMCMPPUdbUPdbUUP| ^ UЬRբ
ݢ 	DECC$FREEԢbЬP`РV`SSS~ DECC$MALLOCPT'VSVT DECC$MEMCPY
S T DECC$MEMSETCd4P< ~ IS_DEBUG_LEVELP"Œ  
ESNMP_LOGSš <~P< ~ 	ESNMP_LOGTRЬPR`ՠRPЬRRP  ^ЬPՠ
ݠ 	DECC$FREEЬPԠ`| ^ Sլլ:< ~ IS_DEBUG_LEVELP"  
ESNMP_LOGS <~P< ~ 	ESNMP_LOGV1 PЬPѠ   RѬ P   
Ѭ   >< ~ IS_DEBUG_LEVELP%ݬ0 
ESNMP_LOGST<~P< ~ 	ESNMP_LOGV1 PЬRТTTT
߬ЬPݠݬ __LOAD_VALUEPU^PTެݢݬ __LOAD_VALUEPU9< ~ IS_DEBUG_LEVELP%ݢÉ 
ESNMP_LOGSø<~P< ~ 	ESNMP_LOGUUVVP ^ Rլլ:< ~ IS_DEBUG_LEVELP" 
ESNMP_LOGS<<~P< ~  	ESNMP_LOGT1PЬPՠ|ЬQСPP 	P1D?PѼ:< ~ IS_DEBUG_LEVELP"D Q    
ESNMP_LOGSj<K~P< ~ 	ESNMP_LOGT1PݬЬPݠݬ __LOAD_VALUEPS1 PѼ   :< ~ IS_DEBUG_LEVELP"  
ESNMP_LOGS<S~P< ~ 	ESNMP_LOGT1 PݬЬPݠݬ __LOAD_VALUEPS1 PЬP`	PP7< ~ IS_DEBUG_LEVELP" 
ESNMP_LOGS<[~P< ~ 	ESNMP_LOGT>ݬЬPݠݬ __LOAD_VALUEPS"PݬЬPݠݬ   R    	ESNMP_LIB      str2oid       	sprintoid b       instance2oid        R    oid2instance @       	clone_oid       free_oid $     <  	clone_buf        cmp_oid )       cmp_oid_prefix R     L  inst2ip        mem2oct        cmp_oct      ,  	clone_oct        free_oct $       	o_integer ?    T	  o_octet     0  o_oid        o_stri __LOAD_VALUEPSPSSTTPP ^ Rլլ:< ~ IS_DEBUG_LEVELP"Q 
ESNMP_LOGS S   p<~P< ~ 	ESNMP_LOGSAPЬPՠ|ЬPѠݬЬPݠݬ __LOAD_VALUEPQPQQSSPP< ^ Sլլ:< ~ IS_DEBUG_LEVELP"æ 
ESNMP_LOGS<~P< ~ 	ESNMP_LOGU1>PլԬЬQСPP BP1 P?PѬ:< ~ IS_DEBUG_LEVELP"  
ESNMP_LOGS,<~P< ~ 	ESNMP_LOGU1 PЬЬ쟭ЬPݠݬ  __LOAD_VALUEPT1 ݬ STR2OIDЬPݠݬ __LOAD_VALUEPTRբ
ݢ 	DECC$FREEԢb[PЬ T   쟭ЬPݠݬ __LOAD_VALUEPT6< ~ IS_DEBUG_LEVELP"h 
ESNMP_LOGSÐ<~P< ~ 	ESNMP_LOGTTUUP ^ЬPF`Rբ
ݢ 	DECC$FREEԢbЬQˏ   P ѡ
Rբ
ݢ 	DECC$FREEԢbP ^ SլP  GETTIMEOFDAYP6< ~ IS_DEBUG_LEVELP" 
ESNMP_LOGS<D~P< ~ 	ESNMP_LOGT/   ng     T
  free_varbind_data R     
  esnmp_sysuptime    		     *  	 U       2    	
   & 6 	i
    	l
    / 	
   ~ 3        	 >  '  	9   "   	G   @    +   -  
 V     -   #   1  >	    
  L   INST2IP 
    < MEM2OCT 
    < CMP_OCT 
  ,  | 	CLONE_OCT 
      FREE_OCT 
    | 	O_INTEGER 
  T	   O_OCTET 
  0   O_OID 
    < O_STRING 
  T
   FREE_VARBIND_DATA 
  
   ESNMP_SYSUPTIME  7  $CODE   $DATA|  __ESNMP_TIMEBASEPQЬPa`Rďd   RáP W   '  PRPTTP (P   (           	PEaa% aaa  EaaE        w w 1       Aaqt؛ V1.0-02                         9     	ESNMP_LOGV1.0-0219-NOV-1997 13:04                    DEC C V5.0-003 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 P%s]
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 P  P%*.*s%s]
 P%02x PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 P%s
 PPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]E X   SNMP_LOG.C;3 NP  EP%*.*s%s
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 P%s
 P(len=%d) 0x[ PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 P-nill-
 PDISK$UCX_BUILD2:[UCX.X42.BL21 .SRC.SNMP]ESNMP_LOG.C;3 qPInvalid data type: 0x%X
 <PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 1PNull-type
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 PException = endOfMibView
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESN Y   MP_LOG.C;3 PException = noSuchInstance
 XPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 >PException = noSuchObject
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 PObjectId = "%s"
 PDISK$UCX_BUILD2: [UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 PBitString =  PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 vPOpaque =  @PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 1PNsapAddress =  
PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_ Z   LOG.C;3 
P...too big 
PDisplayString = "%.*s%s"
 
PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 
PIpAddress =  ^
PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 O
POctetString =  
PDISK$UCX_BUILD2:[UCX.X42.BL 21.SRC.SNMP]ESNMP_LOG.C;3 	
PCounter64 = %lu
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 PUInteger32 = %lu
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 |PTimeTicks = %lu
 GPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.                                                                                                                                                                                                                                                   T                         ^ $      UCX042.B                       c
  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP.OLB;1                                                                                                           z "     Z        [   SNMP]ESNMP_LOG.C;3 8PGauge32 = %lu
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 PCounter32 = %lu
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 PInteger32 = %ld
 wPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_L OG.C;3 pP%*.*s ;PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 %P%*.*sVARBIND OID=%s
 
PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 
P
 
PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 
P%*.*s  ar \   gument=%s
 l
PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 H
P, error_index=%d, error_code=%d %s
 
PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 	P, non-repeaters=%d, max-repetitions=%d
 	PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ES NMP_LOG.C;3 	PUnknown Version 	PV2  	PV1  	PALONE,  c	P%*.*s%s - %s%s, packet id=%d P	PUnknown error type P         *   3   <   C   L   X	   d
   r ]      }   
                  P   Q   e   f   $g   2h   Hi   fj   xk   l   m   n   o   
	p   0	q   >	>	PDPI_resourceError 0	PDPI_dataError 
	PDPI_characterSetSelectionNotSupported PDPI_invalidDisplayString PDPI_duplicateSubAgentIdentifier PDPI_getBulkSelectionNotSupported PDPI_viewSelectionNotSupported xPDPI_notAuthorized fPDPI_mustOp ^   enFirst HPDPI_higherPriorityRegistered 2PDPI_alreadyRegistered $PDPI_notFound PDPI_otherError PNoSuchObject PNoSuchInstance PinconsistentName PnotWritable PauthorizationError PundoFailed PcommitFailed PresourceUnavailable  PinconsistentValue }PnoCreation rPwrongValue dPwrongEncoding XPwrongLength LPwrongType CPnoAccess <PgenErr 3PreadOnly *PbadValue PnoSuchName PtooBig PnoError P%s  _   P%s P%s  Pa PStarting tracefile for %s esnmp: %s PStarting trace file for %s esnmp: %s Pw P/tmp/esnmp_sub P%s%d.log P%s ~P%s WARNING %s line %d: %s dP%s **ERROR %s line %d: %s pP      ")08?FXXPCLEANUP FPARE_YOU_THERE ?PINFORM 8PTRAPV2 0PGETBULK )PUNDO "PCOMMIT PCLOSE POPEN PUNREGISTER PREGISTER  PRESPONSE  PTRAP  PS `   ET  PGETNEXT  PGET  P???Message With Zero for action code??? dP 0    P ^]~ݬ DECC$STRRCHRPRЬRPRR  DECC$STRCPYP   QЬ ȏ    ȏ 0  Ьd     QRլ
ҡdPPPRRPP ^ R]~ݬ  DECC$STRRCHRPSSPЬSѬ   &Ѭ    8ݬݬSbd 
DECC$DSPRINTF/ݬݬSb~ 
DECC$DSPRINTFݬ 
DECC$DSPRINTFdЬ P` d1`1 	b OPENLOG a   d~ DECC$MALLOCPh  DECC$GETPIDP¤ݢh 
DECC$DSPRINTF´ݢh 
DECC$FOPENPS  	DECC$TIMEP 
DECC$CTIMEPb¶S 
DECC$DFPRINTFS DECC$FCLOSEݢhb SYSLOG`d+ ݢh 
DECC$FOPENPSS      LOG_CALLBACK  	SPRINTOID  
ESNMP_LOGS  SYSLOG  DECC$GETPID  	ESNMP_LOG  
__PRINT_OCTET  __PRINT_VARBIND  
DECC$CTIME  	DECC$TIME  OPENLOG  DECC$STRLEN  DECC$STRRCHR  DECC$STRCPY  DECC$MALLOC b     DECC$DVSPRINTF  
DECC$DSPRINTF  DECC$DPRINTF  
DECC$DFPRINTF  
DECC$FOPEN  DECC$FCLOSE 
       __SET_PROGNAME 
  4     SET_DEBUG_LEVEL 
  h    IS_DEBUG_LEVEL 
      	ESNMP_LOG 
  h   
ESNMP_LOGS 
     __SNMPERRORTEXT   
DECC$DFPRINTFS DECC$FCLOSE; DECC$STRLENP@PP
 DECC$STRLENP@ SYSLOGˏdP DECC$DPRINTF ^ RެPP~ݬ DECC$DVSPRINTFQQP  RQ~AP`'P~AP c   `~AP`SQ~AP`ܞP	SSPP  QЬP@pRRPP| ^ Td19SPSҤdRRSRPPzЬSĈ	VĐ	VˏSĔ	USĘ	SĠ	SSUЬRbUVТRBpĀ	ݬݬc	 
ESNMP_LOGSİ	<~P~ 	ESNMP_LOGЬUѥMSPSҤdRRSRPP1WЬRݢݢ	 
ESNMP_LOGS
<~P~ 	ESNMP_LOG1)ѥ1 SPSҤdRRSRPPjЬSУQR~BSc$~BP`Q
~BP`SPR~BP`ܞP	SSЬRݢݢH
 
ESNMP_LOGSl
<~P~ d    	ESNMP_LOGЬRբ(1 SPSҤdRRSRPPsЬRݢ(ĸ
ݬݬĤ
 
ESNMP_LOGSĹ
<~P~ 	ESNMP_LOG?PSPSҤdRRSRPP!
 
ESNMP_LOGS
<~P~ 	ESNMP_LOGЬRТ$ScRSSR __PRINT_VARBINDТRP ^  Rd1LЬP1C`H 	SPRINTOIDQdQQD/H:ݬݬ% 
ESNMP_LOGS;<~P~ 	ESNMP_LOGЬPՠ<QdQQ<+vݬݬp 
ESNMP_LOGSw<~P~ 	ESNMP_LOGЬQա1[СPP  1 e   P	?PP   1P    hP1?PQdQQ41ЬPݠ¬ 
ESNMP_LOGS½<~P~ 	ESNMP_LOGPQdQQ,1ЬPݠ 
ESNMP_LOGS<~P~ 	ESNMP_LOGPQdQQ$1ЬPݠ8 
ESNMP_LOGSG<~P ~ 	ESNMP_LOGPQdQQ1^ЬPݠ| 
ESNMP_LOGS<~P~ 	ESNMP_LOGPQdQQ1ЬPݠ 
ESNMP_LOGS<~P~ 	ESNMP_LOGPQdQQ1ЬPݠ	
 
ESNMP_LOGS f   
<~P~ 	ESNMP_LOGPQdQQ!O
 
ESNMP_LOGS^
<~P~ 	ESNMP_LOG~ЬP 
__PRINT_OCTETPQdQQ!
 
ESNMP_LOGS 
<"~P~ 	ESNMP_LOG~ЬP 
__PRINT_OCTETPQSQҢdPPQPSS1ЬQСPя   PTPTP   
S
SSݡT
 
ESNMP_LOGS
<&~P~ 	ESNMP_LOGPQSQҢdPPQPSS!1 
ESNMP_LOGS@<+~P~ 	ESNMP_LOG~ЬP 
__PRINT_OCTETQSQ g   ҢdPPQPSS!v 
ESNMP_LOGS</~P~ 	ESNMP_LOG~ЬP 
__PRINT_OCTETQSQҢdPPQPSS!µ 
ESNMP_LOGS<3~P~ 	ESNMP_LOG~ЬP 
__PRINT_OCTETQSQҢdPPQPSS1ЬPH 	SPRINTOIDP  
ESNMP_LOGS<7~P~ 	ESNMP_LOGQSQҢdPPQPSS11> 
ESNMP_LOGSX<:~P~ 	ESNMP_LOGQSQҢdPPQPSS1  
ESNMP_LOGS¬<=~P~ 	ESNMP_LOGQ h   SQҢdPPQPSS1  
ESNMP_LOGS<@~P~ 	ESNMP_LOGQSQҢdPPQPSSh1 
ESNMP_LOGS<<D~P~ 	ESNMP_LOGQSQҢdPPQPSS(ЬPݠq 
ESNMP_LOGS<K~P~ 	ESNMP_LOGx^ SЬV@TUTңdRRTRUU12 
ESNMP_LOGS<^~P~ 	ESNMP_LOGfx 
DECC$DSPRINTFfJTUTңdRRTRUU%x 
ESNMP_LOGS<c~P~ 	ESNMP_LOGxUYx DECC$STRLENxR i   RPUYTެZT 1  
ESNMP_LOGSX 	ESNMP_LOGW  VT1 z  TP{PQPP1 eYFPQPңdRRPRQQcxNݬݬEhP<p~P~g:PPQPңdRRPR԰QQxÈhÌ<r~P~gYxUPTz  TP{PQPP D~U 
DECC$DSPRINTFU    R    	ESNMP_LOG      __set_progname 2     4   set_debug_level 4     h   is_debug_level "        	esnmp_log     h  
esnmp_logs +       __SNMPErrorText E      j     __get_action_code        __print_hdr N    D  __print_varbind c      
__print_octet e      
print_varbind    		       /  
  <  9 	
   ? 
       	 ?         k        	 q
      
     __GET_ACTION_CODE 
    | __PRINT_HDR 
  D   __PRINT_VARBIND 
    
__PRINT_OCTET 
      
PRINT_VARBIND  #  $CODE A  $DATA 	   LOG_CALLBACK ? DECC$STRLENPUTTf1eYMTVTңdRRTRVVrxݬݬ 
ESNMP_LOGS<~P~ 	ESNMP_LOGPTUTңdRRTRUU%x 
ESNMP_LOGS<~P~ 	ESNMP_LOGP  ^                                                                                                                                                                                                                                                   U                        / $      UCX042.B                       c
  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP.OLB;1                                                                                                            "     k        l   ݬ __PRINT_VARBIND PP$ d   $ 
PRS/SSSwSGG         w w 1       nqt؛ V1.0-01                         :     
ESNMP_PACKV1.0-0119-NOV-1997 13:04                   DEC C V5.0-003 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 PPack: Invalid data type: 0x%X
 rPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 hPToo Big
 2PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 (PToo Big
  PDISK m   $UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3  PToo Big
  PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3  PToo Big
 rPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 hPToo Big
 (PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SN MP]ESNMP_PACK.C;3  Pesnmp_pack: No hdr and Varbind to pack
   P ^ Sլ3<  ~ IS_DEBUG_LEVELPc 
ESNMP_LOGS(~P<  ~ 	ESNMP_LOGTHЬRbЬQaССԢ<bPP~ݡ$R __ENCODE_VARBIND n   PTTP^լY1 UЬTVլ1 ެXUW2UPPh$ЬPQQ1 Q1 V1 UЬRbT 	SPRINTOIDT DECC$STRLENPSSTSUUUh~TR~PS%ЬPPPYcPЬPVCPSWUЬPQQ(Q#VSUSTЬPРVլ1/ЬR<bPUPPbYYP| ^ SUѬ8< ~ IS_DEBUG_LEVELP h 
ESNMP_LOGSr<~P< ~ 	ESNMP_LOGV1PЬQաЬP֬`Uѡ1СPP /PP?PP   1PP    hP1-?PЬP o   `ЬP֬`UURR8< ~ IS_DEBUG_LEVELP"è  
ESNMP_LOGSò <2~P< ~ 	ESNMP_LOGV1ЬR֬ЬQPʏ PPbЬR֬<Pʏ PPbЬR֬Pʏ PPbЬR֬ˏ PPbU1PЬP֬`ЬP֬`UURR8< ~  IS_DEBUG_LEVELP"  
ESNMP_LOGS <D~P< ~ 	ESNMP_LOGV1WЬR֬ЬQ8Pʏ PPbЬR֬0Pʏ PPbЬR֬(Pʏ PPbЬR֬  Pʏ PPbЬR֬Pʏ PPbЬR֬<Pʏ PPbЬR֬Pʏ PPbЬR֬ˏ p    PPbU1PЬPРTЬR֬xTPʏ PPbЬR֬ˏ TPPbUTURR;< ~ IS_DEBUG_LEVELP"( 
ESNMP_LOGS2<_~P< ~ 	ESNMP_LOGV1"PTЬPݠݬ DECC$MEMCPYTTU1 PЬPRURR:< ~ v  R    
ESNMP_PACK      __esnmp_pack         __encode_varbind       encode_value G  		'	     o      		 }  v 3 q        	SPRINTOID  
ESNMP_LOGS  	ESNMP_LOG  IS_DEBUG_LEVEL  __ENCODE_VARBIND  DECC$STRLEN  DECC$MEMCPY 
       __ESNMP_PACK 
     __ENCODE_VARBIND    $CODE   $DATA} IS_DEBUG_LEVELP"h 
ESNMP_LOGSr<i~P< ~ 	ESNMP_LOGV1 PЬPRR 	SPRINTOIDR DECC$STRLENPQЬR֬xQPʏ PPbЬR֬ˏ QPPbQQQUZPЬP֬` r   P֬`UA< ~ IS_DEBUG_LEVELP)ЬPݠè 
ESNMP_LOGS<~P< ~ 	ESNMP_LOGVPUVVP PP$ HHHH$ $ $ HHH$  P5q55555qqq         w w 1       {qt؛ V1.0-01                         :     
ESNMP_POLLV1.0-0119-NOV-1997 13:04                   DEC C V5.0-003 VPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 <PInvalid data type: 0x%X
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 POut of memory
  s   PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 PMethod routine declared an error during UNDO
 \PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 JPSET - undo phase
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 PMethod routine declared an error during UNDO
 PDISK$UCX_BUILD2:[UCX.X42. BL21.SRC.SNMP]ESNMP_POLL.C;3 PMethod routine declared an error during COMMIT
 HPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 4PSET - commit ph t   ase
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Pmethod routine declared an error; %s
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 tPMethod routine returned unknown status: %d
 <PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 "PSET - test phase, pass 2
 
PDISK$UCX_BUILD2:[UCX.X42.BL21 .SRC.SNMP]ESNMP_POLL.C;3 
PAn error has been declared in index %d; cleaning up
 
PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 d
POut of u    memory during a set
 .
PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 
PNo instance in the varbind's OID
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 PData is of the wrong type; should be %d
 vPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 NPNo set function for this MIB variable
 PDISK$UCX_BUILD 2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 PNo object found in object table
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 P    v       requested oid:%s, object:-null-
 \PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 *P       requested obj idx:%d, object:%s, dots:%s
 
PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 
POut of memory
 
PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 
PSET - test phase, pass 1
 ^
PDISK$UCX_BUILD2:[UCX.X42.BL21.S RC.SNMP]ESNMP_POLL.C;3 *
PExtending varbind list one more repeating section
 	PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3  w   	PMethod routine returned invalid status: %d
 	PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 r	P       Instance out of range
 <	PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 	P   Method Routine returns: %s
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 P(as a GET) PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 PNot a readable object
 VPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 ,P       try obj id:%-3d %s ( x   subtree '%s') PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 P       no more objects found
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 P    %2d requested oid: %s
 PPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 $PMethod routine returned invalid status: %d
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   P Method Routine returns: %s
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 PNot a readable object
 JP y   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 0P       no object found,  PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 P       object id:%d, dots:%s   PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 P       requested oid:%s
 TPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 4PUnexpected DPI packet type %d
 PDISK$ UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 P  dispatch UNREGISTER
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SN z   MP]ESNMP_POLL.C;3 PDPI CLOSE received from agent, reason=%d
 PPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 (PBad response to ARE-YOU-THERE, restart
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 PUnknown P  RESPONSE to REGISTRATION of '%s': OK
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 PUnknown XPRESPONSE to REGIST RATION of '%s': %s
 "PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 PRESPONSE to OPEN: %s
  {   PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 PRESPONSE to OPEN: %s
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 |Pfrom REGISTER rPfrom OPEN HP  dispatch - RESPONSE, packet_id=%d %s
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 P  Resulting Packet
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 P  Resulting Packet
   	CLONE_OCT  CMP_OID_PREFIX  	CLONE_OID  CMP_OID  	SPRINTOID  
ESNMP_LOGS  	ESNMP_LOG  |    IS_DEBUG_LEVEL  __SNMPERRORTEXT  __PRINT_HDR  __LOAD_VALUE  __FREE_VARBIND  
__NEW_VARBIND  
__FREE_HDR  __ESNMP_UNPACK  __ESNMP_PACK  
__RECV_PACKET  
__SEND_PACKET  __SET_ESNMP_STATE  
__DO_UNREG  __ESNMP_SEND_REGISTER  __DOTS2SUBTREE  __GET_MAX_SUBTREES  
__GET_SUBTREE  DECC$MEMCMP  DECC$MEMCPY  DECC$MALLOCtPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 `P  Resulting Packet
 (PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PO                                                                                                                                                                                                                                                   V                        Ű $      UCX042.B                       c
  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP.OLB;1                                                                                                           *	 "     |        }   LL.C;3 P  Resulting Packet
  PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3  P  Resulting Packet
  PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 ~P  Incoming Packet
 HPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3  Pesnmp_poll: Could not process a packet
   P ^ S 
__RECV_PACKETPR  __ESNMP_UNPACKPRR|PRR0\Ѭ%< ~\ __ESNMP_PACKPR 
__SEND_PACKETPR 
__FREE_HDRR/ ~   < ~ IS_DEBUG_LEVELP  
ESNMP_LOGSH~P< ~ 	ESNMP_LOGR\\P^ U~ IS_DEBUG_LEVELP~ 
ESNMP_LOGSŒ ~P~ 	ESNMP_LOGЬRR __PRINT_HDRejѢdѢ
^ХRbRТPРP`Т(RХS" 	DECC$FREETSRУ(Sݢ dRdSԥݥ __FREE_VARBINDԥeԥЬRТPP P1V?PЬRRPX~ IS_DEBUG_LEVELP!  
ESNMP_LOGS <~P~ 	ESNMP_LOGݬ __PRINT_HDR1PЬRRPX    ~ IS_DEBUG_LEVELP! 
ESNMP_LOGS(<
~P~ 	ESNMP_LOGݬ __PRINT_HDR13PЬS|S`PXeuXգS
CPXХRPbRТPРP`Т(RХS" 	DECC$FREETSRУ(Sݢ dRdSԥݥ __FREE_VARBINDԥeԥЬR~ IS_DEBUG_LEVELP!` 
ESNMP_LOGSt<!~P~ 	ESNMP_LOGݬ  __PRINT_HDR1YЬR|R
ψPX~ IS_DEBUG_LEVELP!Ŭ 
ESNMP_LOGS<,~P~ 	ESNMP_LOGݬ __PRINT_HD    R1PЬR|R0PXХRPbRТPРP`Т(RХS" 	DECC$FREETSRУ(Sݢ dRdSԥݥ __FREE_VARBINDԥeԥЬR~ IS_DEBUG_LEVELP! 
ESNMP_LOGS<9~P~ 	ESNMP_LOGݬ __PRINT_HDR1EХRPbRТPРP`Т(RХS" 	DECC$FREETSRУ(Sݢ dRdSԥݥ  __FREE_VARBINDԥeԥЬRԢX1~ IS_DEBUG_LEVELPO޼Sc  pTcrS|SSTTݼH 
ESNMP_LOGSŊ<E~P~ 	ESNM    P_LOGЬVԦfT1oզ(9
߭ݦ( DECC$STRTOULPЭScRR,
 SS DECC$STRTOULPԥЬRѢm   G<  ~ IS_DEBUG_LEVELP.ݢ __SNMPERRORTEXTP 
ESNMP_LOGS<[~P<  ~ 	ESNMP_LOGW1PբG<  ~ IS_DEBUG_LEVELP.ݢ __SNMPERRORTEXTP 
ESNMP_LOGS"<_~P<  ~ 	ESNMP_LOGW1P  __SET_ESNMP_STATEե;PХP 
__SEND_PACKETPRRRW1_ХPPR`R 	DECC$FREEեԥS  __GET_MAX_SUBTREESSP17    PS __ESNMP_SEND_REGISTERPRRRW1S  __GET_MAX_SUBTREESSP1PT  1 TT 
__GET_SUBTREEPTզe<  ~ IS_DEBUG_LEVELP>TdSŀSݦ __SNMPERRORTEXTPSX 
ESNMP_LOGSň<}~P<  ~ 	ESNMP_LOGЬRݢT 
__DO_UNREGW1|~ IS_DEBUG_LEVELPqTdSSS 
ESNMP_LOGS<~P~  	ESNMP_LOG>Pզ7~ IS_DEBUG_LEVELP!( 
ESNMP_LOGSP<~P~ 	ESNMP_LOGW1 X1 P~ IS_DEBUG_LEVEL    P(ЬRݢņ 
ESNMP_LOGSŰ<~P~ 	ESNMP_LOGЬRԢX1 ~ IS_DEBUG_LEVELP! 
ESNMP_LOGS<~P~ 	ESNMP_LOGЬRݢ( __DOTS2SUBTREEP 
__GET_SUBTREEPSݢS 
__DO_UNREGPXPXЬRԢA< ~ IS_DEBUG_LEVELP)ЬRݢ4 
ESNMP_LOGST<~P< ~ 	ESNMP_LOGWPXWWP^ RЬP| ` YР$U13 IS_DEBUG_LEVELV 	SPRINTOID[ 
ESNMP_LOGSW 	ESNMP_LOGX __LOAD_VALUEZPe0UPS~f    P1 ~fP$eHkPg¤<~P~hS4~fPMHkPcg<~P~h$~fP0gJ<~P~hS8ЬPPSQ<PPʏPˏPP
PPPPգ0~fPg<~P~h ej1 S4УP`PT~fP$T __SNMPERRORTEXTPg<~P~hTjTPP  I
P	?PPP   CPP     i
P5?P^P ejQ ejEЬPY6P<  ~fPT$gP<~P<  ~hЬPYЬPՠ
    UYU1SSP^ SެоR|b |(ԮТ$W[Т$V1оn IS_DEBUG_LEVELZ 	SPRINTOID 
ESNMP_LOGSY 	ESNMP_LOGX 	CLONE_OID nRѢоTR[R
ԮЦWФ,~jP'fHP[Æiâ<V~P~hVPU6~jPi<^~P~h f __LOAD_VALUE1*P~jP*fHݶPe,iV<d~P~hե1оP RUQ<RPʏPˏPP
RRR-T~jP1CÌiä<m~P~h1'Ѧ).~jP7    i<s~ݳP~hPоPѠ
PU4f0ХP`PR~jP$R __SNMPERRORTEXTP	i<	<~~P~hR1 RPP  .
P?PPP   wPP    M
Pi?P!f CMP_OIDP0)~jP1 r	iÐ	<~P~hkP)bP^PЬP[T1
P<  ~ IS_DEBUG_LEVELP$R	 
ESNMP_LOGS	<~P<  ~ 	ESNMP_LOGЬP[T1 PR1֮1оRѢ1 զ1 (1 ծ{~jP*
i^
<~P~h (    VR  
__NEW_VARBINDP;ТRЧЧЧ))!!gbWVЧWPЧWЦV[V1TTP|^ VЬPP P1_
?Pզզ^ЦScSУRТP`У(SЦT" 	DECC$FREEWTSФ(Tݣ gSgTԦݦ __FREE_VARBINDԦfԦЬRТ$Ԣ$~ IS_DEBUG_LEVELP!Ɣ
 
ESNMP_LOGSƮ
<~P~ 	ESNMP_LOGЦ[1 DECC$CALLOCn IS_DEBUG_LEVEL 
ESNMP_LOGS 	ESNMP_LOGެ 	SPRINTOID DECC$MEMCMPZkYզ@,    PS)< ~P<S~P< ~ SSUH,PS)< ~P<S~P< ~ ЀS(SRU$Х(UU1< ~P

<#~P< ~ оR
ЮRв Y[PT~P1 TJ~Pqi͘PRHPRd*\<1~P~ 6P~P'i͘PƘ<7~P~ TA~ IS_DEBUG_LEVELP!  
ESNMP_LOGS<B~P~ 	ESNMP_LOGЬRЮ1դC~ IS_DEBUG_LEVELP!N 
ESNMP_LOGS    v<H~P~ 	ESNMP_LOGЬRЮ1yPѤQѤ	KѩE~ IS_DEBUG_LEVELP$ݤƬ 
ESNMP_LOGS<Q~P~ 	ESNMP_LOGЬRЮ1 PTäiWA~ IS_DEBUG_LEVELP!
 
ESNMP_LOGS.
<[~P~ 	ESNMP_LOGЬRЮ1 ФSCXЦR?բ 3ТQХPѡ$Т QѡWxW~XݡjP
Т  	PТ(RRp DECC$MALLOCP ?< ~  IS_DEBUG_LEVELP"d
 
ESNMP_LOGSƀ
<q~P< ~ 	ESNMP_LOGЬR
5PХ RXХ RWХ RԢԵ ȏ       U ֮Ы[1ЬRբe~ IS_DEBUG_LEVELP$ݢƶ
 
ESNMP_LOGS
<~P~ 	ESNMP_LOGЦT# 	DECC$FREEUTSФ(Tݣ eSeTԦW1TЦSPճ г Rȏ@   Գ TУ(S䚏~ IS_DEBUG_LEVELP!" 
ESNMP_LOGS<<~P~ 	ESNMP_LOGUЦS12ЬcSУRТP`PT1 TPP  bP?PPP   1 PP    PzPr?P1 ЬR 1 ЬR1 ЬR1 ЬRzPЬR
nPЬRbPЬR
VPЬRJPЬR>P<  ~     IS_DEBUG_LEVELP$Tt 
ESNMP_LOGSƠ<~P<  ~ 	ESNMP_LOGЬRTH~ IS_DEBUG_LEVELP,T __SNMPERRORTEXTP 
ESNMP_LOGS<~P~ 	ESNMP_LOGЬRUW1UУ(S11P~ IS_DEBUG_LEVELP!4 
ESNMP_LOGSH<~P~ 	ESNMP_LOGUЦT1 1 ЬdTФRТP`P1 ~ IS_DEBUG_LEVELP!ƀ 
ESNMP_LOGSư<~P ~ 	ESNMP_LOGЬRUЦSSTnPPcSФPРP`P<~ IS_DEBUG_LEVELP!     
ESNMP_LOGS<~P~ 	ESNMP_LOGЬPUУ(SSTUФ(T1-1 P~ IS_DEBUG_LEVELP!J 
ESNMP_LOGS\<~P~ 	ESNMP_LOGѦhTЦS_QЬcSУRТP`P<~ IS_DEBUG_LEVELP!ƒ 
ESNMP_LOGS<~P~ 	ESNMP_LOGЬRTTУ(SWWP< ^ SЬT<dPP~ DECC$MALLOCPRU&<d~T DECC$MEMCPYbУPR`RRU UPP^ЬP`YԠ  __GET_MAX_SUBTREESPTST?S 
__GET_SUBTREEPR)Y C    MP_OID_PREFIXPЬPРPѢЬPRSSTЬRբXjТSUУTUTJUTVVVP@RY CMP_OID_PREFIXPWЬPVRX+PWVT
PWVUUTWVЬRVXXPP< ^ЬQС)PP  PwPV?PЬRRPS\PPѣb)SU1 ЬR)SU1 P2PЬPРQRޱSBcR)RUyPЬP֠PUgЬPРQѠЬR)UJPЬSУPRްPB`T! CMP_OIDP
)U PЬRb 	CLONE_OID)TUUP   \QQPP ^ TѬ1ЬP                                                                                                                                                                                                                                                   W                        )~Y $      UCX042.B                       c
  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP.OLB;1                                                                                                            "                P P	"?PP   1P    P1?PЬRм1PЬRм1PЬRм1PЬRм1kPЬRм1WPЬR
м1DЬR 	CLONE_OCTPS1+1!ЬR 	CLONE_OCTPS11 ЬR 	CLONE_OCTPS1 	1 ЬR 	CLONE_OCTPS1 1 ЬR 	CLONE_OCTPS1 1 ЬR 	CLONE_OCTPS   R    
ESNMP_POLL      
esnmp_poll         esnmp_dis    patch   
    do_get d    
  
do_getnext   
    do_set     T  __enqueue_trap R       find_object        
find_next_obj        __esnmp_timebase        __load_value >  		z	                		+
 <   	6
 v         "      	
 
  ~ ?           	   ) N	    	    	   ~ .
       	(   ! 		     E   h 	O   O   	Y   1 3	    	   ' 	 L  ;  , :  	W
   * 	i
 h   E  ' C T         	DECC$FREE  DECC$CALLOC  DECC$STRTOUL 
       
ESNMP_POLL 
  T  < __ENQUEUE_TRAP 
      __ESNMP_TIMEBASE 
     __LOAD_VALUE    $CODE   $DATAxP
nPЬR 	CLONE_OIDPSTPJPЬRЬ=< ~ IS_DEBUG_LEVELP%ݬ< 
ESNMP_LOGSV<~P< ~ 	ESNMP_LOGSPSSP P$ 8 L ` t  P  C g P S S s   P    <PT      p  |   d          X   P tttttt I
PW W  "
P6       e
P   =
P7 c c c c S  P,   ,X         w w 1       qt؛ V1.0-01                         <     ESNMP_UNPACKV1.0-0119-NOV-1997 13:04                   DEC C V5.0-003 `PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 PPOut of memory
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 POut of memory
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3     PInvalid data type: 0x%X
 xPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 PPBadly formed DPI packet, length error
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 PBadly formed DPI packet, length error
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SR C.SNMP]ESNMP_UNPACK.C;3 PInvalid ending OID format in packet:'%s'
 PPDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3  PInvalid starting OID format in packet:'%s'
 PDISK$UCX_BUILD2:[UCX.X42.BL2    1.SRC.SNMP]ESNMP_UNPACK.C;3 PEmpty Get request packet
 PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 pPUnrecognized packet type: 0x%X
 8PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 PNo Memory - packet dropped
  PDISK$UCX_BUILD2:[UCX.X42.BL21. SRC.SNMP]ESNMP_UNPACK.C;3  PInvalid security packet length: %d
  PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 `PUnexpected protocol type: 0x%X
 (PDISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP    ]ESNMP_UNPACK.C;3  Pesnmp_unpack: No packet to unpack
   P^ VԼYլ6<  ~ IS_DEBUG_LEVELPf 
ESNMP_LOGS(~P<  ~ 	ESNMP_LOGX1P, DECC$CALLOCPR2< ~ IS_DEBUG_LEVELP" 
ESNMP_LOGS<~P< ~ 	ESNMP_LOGRU	X1PЬRPP ;<  ~ IS_DEBUG_LEVELP$~` 
ESNMP_LOGSƀ ~P<  ~ 	ESNMP_LOGX18<eХPP P1:P?PТТT<bSìTPPSSWբ1 <WPѢP;<  ~ IS_DEBUG_LE    VELP$ݢƸ  
ESNMP_LOGS ~P<  ~ 	ESNMP_LOGX1ݢ DECC$MALLOCP 8< ~ IS_DEBUG_LEVELP! 
ESNMP_LOGS8~P< ~ 	ESNMP_LOGX1@ݢ~ݥ  DECC$MEMCPYT<WP¢PPW<W~TUPY1 P1 	SS STRDUPP(gТТT<bSìTPPSSP<PPFT STRDUPP(7<  ~ IS_DEBUG_LEVELP$ݥp 
ESNMP_LOGSƐ~P<  ~ 	ESNMP_LOGYY}US|գ 
ݣ  	DECC$FREEУ$THФR&ݢ __FREE_VARBINDb FREE_VARBIND_DA    TA! FREE_OIDR 	DECC$FREEd FREE_VARBIND_DATA! FREE_OIDT 	DECC$FREEգ(
ݣ( 	DECC$FREES 	DECC$FREEUYXXP^ Uլ;< ~ IS_DEBUG_LEVELP" 
ESNMP_LOGS<~P< ~ 	ESNMP_LOGW1ZP[XѬ[1D STR2OIDZ DECC$STRLENYVS-  DECC$CALLOCPR2< ~ IS_DEBUG_LEVELP"P 
ESNMP_LOGS`<~P< ~ 	ESNMP_LOGRVW1ЬPՠ$V$VXЬP֬`ݬfjP1 < ~ IS_DEBUG_LEVELP    %ݬ  
ESNMP_LOGSP<8~P< ~ 	ESNMP_LOGVTjФSHУR&ݢ __FREE_VARBINDb FREE_VARBIND_DATA! FREE_OIDR 	DECC$FREEc FREE_VARBIND_DATA! FREE_OIDS 	DECC$FREEd FREE_VARBIND_DATA! FREE_OIDT 	DECC$FREEW1
PݬiPPݬ!jP1 < ~   IS_DEBUG_LEVELP%ݬň 
ESNMP_LOGSŸ<B~P< ~ 	ESNMP_LOGVTjФSHУR&ݢ __FREE_VARBINDb FREE_VARBIND_DATA! FREE_OIDR 	DECC$FREEc FREE_V    ARBIND_DATA! FREE_OIDS 	DECC$FREEd FREE_VARBIND_DATA! FREE_OIDT 	DECC$FREEWFPݬiPPЬPѠ"[ݬf'PЬP	XPѬ[1WWP< ^ SRR9< ~ IS_DEBUG_LEVELP" 
ESNMP_LOGS<j~P< ~ 	ESNMP_LOGU1bPЬP֬ЬR`ЬP֬`PxPTЬP֬`PPTTRR9< ~ IS_DEBUG_LEVELP"P 
ESNMP_LOGSx<t~P< ~ 	ESNMP_LOGU1PЬQѡ1СPP P	:?PP   1`P    P    1=?PЬP֬ЬR`PxPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PP1,ЬP֬ЬR`Px8PЬP֬`Px0PPPЬP֬`Px(PPPЬP֬`Px PPPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PP1 ЬRTTݬ 	CLONE_BUFPU1 TvPЬRRЬP STR2OIDPU\R   DECC$STRLENPRPFPBP< ~ IS_DEBUG_LEVELP)ЬPݠð 
ESNMP_LOGS<~P< ~ 	ESNMP_LOGUPЬUUP ^ЬP1 ՠ 
ݠ  	DECC$FREEЬPР$TjФSHУ    R&ݢ __FREE_VARBINDb FREE_VARBIND_DATA! FREE_OIDR 	DECC$FREEc FREE_VARBIND_DATA! FREE_OIDS 	DECC$FREEd FREE_VARBIND_DATA! FREE_OIDT 	DECC$FREEЬRբ(
ݢ( 	DECC$FREEݬ 	DECC$FREE ^ R- DECC$CALLOCPS2< ~ IS_DEBUG_LEVELP"P   R    ESNMP_UNPACK      __esnmp_unpack        decode_data       decode_value     |  
__free_hdr      ,	  
__new_varbind U         	  __free_varbind    		C	      	    	 ˑˑ		   w ,  $    Y  FREE_OID  FREE_VARBIND_DATA  	CLONE_BUF  STR2OID  STRDUP  
ESNMP_LOGS  	ESNMP_LOG  IS_DEBUG_LEVEL  __FREE_VARBIND      DECC$MALLOC  	DECC$FREE  DECC$CALLOC  DECC$STRLEN  DECC$MEMCPY 
      __ESNMP_UNPACK 
  |   
__FREE_HDR 
  ,	   
__NEW_VARBIND 
  	   __FREE_VARBIND  #
  $CODE   $DATA  
ESNMP_LOGS`<~P< ~ 	ESNMP_LOGS\\PP ^ЬP1 РTjФSHУR&ݢ __FREE_VARBINDb FREE_VARBIND_DATA! FREE_OIDR 	DECC$FREEc FREE_VARBIND_DATA! FREE_OIDS 	DECC$FREEd FREE_VARBIND_DATA! FREE_OIDT 	DECC$FREEЬRb FR                                                                                                                                                                                                                                                   X                        B $      UCX042.B                       c
  P  2[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP.OLB;1                                                                                                                        
    EE_VARBIND_DATA! FREE_OIDR 	DECC$FREE P$ XXXX$ $ $ XXX$  P;c;;;; ;  P7 7 7 ]-]]- ]]]        w w 1       !*qt؛ V1.0                            =     ESNMPLIB_VECTORSV1.017-NOV-1997 17:11                    VAX MACRO V5.4-3I  MACRO/NOLIST/OBJECT=OBJ$:ESNMPLIB_VECTORS.OBJ SRC$:ESNMPLIB_VECTORS.MAR   "V1.0"      ESNMPLIB_VECTORS  	CLONE_BUF  	CLONE_OCT  	CLONE_OID  CMP_OCT  CMP_OID  CMP_OID_    PREFIX  ESNMP_ARE_YOU_THERE  
ESNMP_INIT  	ESNMP_LOG  
ESNMP_LOGS  
ESNMP_POLL  ESNMP_REGISTER  ESNMP_SYSUPTIME  
ESNMP_TERM  
ESNMP_TRAP  ESNMP_UNREGISTER  FREE_OCT  FREE_OID  FREE_VARBIND_DATA  INSTANCE2OID  IS_DEBUG_LEVEL  MEM2OCT  OID2INSTANCE  	O_INTEGER  O_OCTET  O_OID  O_STRING  SET_DEBUG_LEVEL  	SPRINTOID  STR2OID          	.  ABS  .    P   	    ESNMP$VECTOR PA	CLONE_BUF	CLONE_BUF& 	CLONE_BUF3A	CLONE_OCT	CL    ONE_OCT& 	CLONE_OCT3A	CLONE_OID	CLONE_OID& 	CLONE_OID3ACMP_OCTCMP_OCT& CMP_OCT3ACMP_OIDCMP_OID& CMP_OID3ACMP_OID_PREFIXCMP_OID_PREFIX& CMP_OID_PREFIX3A
ESNMP_INIT
ESNMP_INIT& 
ESNMP_INIT3AESNMP_REGISTERESNMP_REGISTER& ESNMP_REGISTER3AESNMP_UNREGISTERESNMP_UNREGISTER& ESNMP_UNREGISTER3AESNMP_ARE_YOU_THEREESNMP_ARE_YOU_THERE & ESNMP_ARE_YOU_THERE3AESNMP_SYSUPTIMEESNMP_SYSUPTIME& ESNMP_SYSUPTIME3A
ESNMP    _TRAP
ESNMP_TRAP& 
ESNMP_TRAP3A
ESNMP_TERM
ESNMP_TERM& 
ESNMP_TERM3A	ESNMP_LOG	ESNMP_LOG& 	ESNMP_LOG3A
ESNMP_LOGS
ESNMP_LOGS& 
ESNMP_LOGS3A
ESNMP_POLL
ESNMP_POLL& 
ESNMP_POLL3AFREE_OCTFREE_OCT& FREE_OCT3AFREE_OIDFREE_OID& FREE_OID3AFREE_VARBIND_DATAFREE_VARBIND_DATA& FREE_VARBIND_DATA3AINSTANCE2OID INSTANCE2OID& INSTANCE2OID3AIS_DEBUG_LEVELIS_DEBUG_LEVEL& IS_DEBUG_LEVEL3AMEM2OCTMEM2OCT& MEM2OCT3    AOID2INSTANCEOID2INSTANCE& OID2INSTANCE3A	O_INTEGER	O_INTEGER& 	O_INTEGER3AO_OCTETO_OCTET& O_OCTET3AO_OIDO_OID& O_OID3AO_STRINGO_STRING& O_STRING3ASET_DEBUG_LEVELSET_DEBUG_LEVEL& SET_DEBUG_LEVEL3A	SPRINTOID	SPRINTOID& 	SPRINTOID3ASTR2OIDSTR2OID& STR2OID  3    ESNMP$VECTOR       w w 1       a7qt؛ V1.0                            1     TIMEV1.019-NOV-1997 13:04                    DEC C V5.0-003    z   R    TIME     getclock v        gettimeofday w   		         DECC$ABS  LIB$EDIV  
LIB$SUB_TIMES  
SYS$GETTIM  
SYS$BINTIM 
      GETCLOCK 
      GETTIMEOFDAY     $CODE    $DATA P  P01-JAN-1970 00:00:00.00   P      (^ RЬS}b蟭 
SYS$BINTIM 
SYS$GETTIM蟭 
LIB$SUB_TIMES߭߭؟ߢ LIB$EDIVݭ DECC$ABSPc
~ DECC$ABSPQQPP (^     S}pc䟭蟭 
SYS$BINTIM 
SYS$GETTIM蟭 
LIB$SUB_TIMES߭߭ܟߣ LIB$EDIVݭ DECC$ABSЬRPb
~ DECC$ABSPQQP        w w 1       qt؛ V1.0                            4     STRINGSV1.019-NOV-1997 13:04                   DEC C V5.0-003   R    STRINGS      
strcasecmp O   
  P   strdup 2   
     ffs 3   		X     8       LIB$FFS  DECC$STR    CPY  STR$CASE_BLIND_COMPARE  DECC$STRLEN  DECC$MALLOC 
        
STRCASECMP 
  P    STRDUP 
      FFS     $CODE     $DATA 
  P  ^ݬ DECC$STRLENPЬݬ DECC$STRLENPЬ쟭蟭 STR$CASE_BLIND_COMPAREPQQP ^ݬ DECC$STRLENPSPP DECC$MALLOCPRݬR DECC$STRCPYRPP ^ |R߭߬߭߭ LIB$FFSPRRPP        w w 1       Qqt؛ V1.0-01                         ;     OS_MIBS_SHMV1.0    -0119-NOV-1997 13:04                    DEC C V5.0-003   R    OS_MIBS_SHM     esnmp_getshm         getifbyname f   		    C    	    
 P      
SYSTEMDATA      
ADAPTERTBL      IFTABLE      INTERFACECOUNT  
SYS$CRMPSC  ESNMP_GETSHM  DECC$MEMSET  DECC$STRNCMP 
     < ESNMP_GETSHM 
     | GETIFBYNAME    $CODE m   $DATA    SYS_ERRLIST    SYS_NERR     	   
SYSTEMDATA 	   
ADAPTERTBL 	   IFTABLE 	   INTERFACECOUNTXPESNMPD_SHARED_MEMORY  PS(PCopyright 1993 SNMP Research, Incorporated  PSNMP Research Distribution version 12.1   P           < ^ R}}螢XբTТTT|PЏ US|~ <f~|~ ݏ	 
  ߢT 
SYS$CRMPSCP\\\  ST2SU ݢT DECC$MEMSETТT\(  ТT\̀ ТTTTPP| ^ U TV  ESNMP_GETSHMSe<ŏ`  SQdPA\P`RbPb~ DEC	    C$STRNCMPPSVSSeVRRP       w w 1       !_qt؛ V1.0-02                         6     SYSLOGV1.0-0217-NOV-1997 17:11                   DEC C V5.0-003o   R
    SYSLOG      openlog    
     syslog :   		          e   
DECC$DVPRINTF  DECC$DPRINTF 
        OPENLOG 
      SYSLOG  >   $CODE   $DATA 9P
 P %s:   P(<BLV\hpx  PDEBUG xPINFORMATIONAL pPNOTICE      hPWARNING \PCRITICAL VPERROR LPEMERGENCY BPSUBALERT <PALERT (PUNDEFINED CONDITION   P   ^ RެSЬP@b DECC$DPRINTFSݬ 
DECC$DVPRINTF DECC$DPRINTF         w w                                                                                                                                                                                                                                                                                                            9 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1 +  , c
   .     / #   4                             - P    0   1    2   3      K  P   W   O     5   6 5|t؛  7 \u؛  8          9          G    H  J                       0 D `     0205        q{tX     f $                                              UCX$ESNMP_SERVER                       UCX V4.2-21    q{t؛ 05-13           Y           Y Z      [        
       ?   '      !        UCX$ACCESS_SHR_001 O    !       
MTHRTL_001      !        
LIBRTL_001$      +        CMA$TIS_SHR_001!      !         DECC$SHR_001    @(#)$RCSfile: main.c,v $ $Revision: 1.1.5.8 $ (DEC) $Date: 1995/12/06 18:38:25 $    SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated  usage: snmpd
       -apwarn -aperror -aptrace -apall -d warning: -d may go away in the future
  snmpd: Trying to get socket snmpd:  Trying to bind socket Unable to bind to socket -- is another agent running?
    Exiting...
 Cannot initialize extensible SNMP, exiting...
 select returned -1 on snmpd sockets: %s
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAIN.C;3 Received Zero-Length packet from %s
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAIN.C;3 queing incoming SNMP Packet, len=%d from:%s     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAIN.C;3 gettimeofday returned failure
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAIN.C;3 SR_AGT_CONF_DIR /etc  %s/%s snmpEnableAuthenTraps community trap    Can't set up shared memory. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAIN.C;3 read read_write write      Unable to allocate community space.
        DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAIN.C;3 Unable to allocate community space.
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAIN.C;3    Unable to allocate trap_community space.
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAIN.C;3 Unable to allocate trap_community space.
       DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAIN.C;3 D  @(#)$RCSfile: mgmt.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/04/27 19:30:37 $    SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated  do_mgmt: error parsi                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Y                        ;G $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                     "            ng packet -- dropping packet
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MGMT.C;3 build_snmpv1_response %s: Failed to build PDU.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MGMT.C;3 %s: Failed to make octetstring.
        DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MGMT.C;3 %s: Failed to make authentication.
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MGMT.C;3 %s: Failed to build authentication.
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MGMT.C;3         findContextInfo %s: No matching community in table.
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MGMT.C;3 make_error_pdu: Malloc of out_pdu_ptr failed.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MGMT.C;3 Internal error: unknown counter case (%d) in make_error_pdu
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MGMT.C;3 SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated     %u  bad oid character   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3     Can't allocate DPI hdr. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3 No dh to pack.  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3 pack %s request %d to subagent '%s'.    GET     GETNEXT GETBULK SET COMMIT UNDO CLEANUP     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3 packet too big...   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3      varbind item %d, %s %s %s  big oid string... up to     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3 Unexpected type %d in pack_data.    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3 mstr_unpack - packet size (%d) too small
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3 Unsupported pkt type %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3      invalid OID %s DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3  unpack - invalid data length %d, varbind: %s   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3 Unknown datatype %i, in varbind: %s DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3 Recvd exception VB w/ non-null length. varbind:%s   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3 Received unknown data type %i, varbind:%s   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3  unpack - error in MakeVarBindWithValue, varbind:%s DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3  unpack - invalid data for type %d, varbind:%s  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_DPI.C;3     SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated                         x  Rcv failed on mstr: %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3   Unknown DPI type %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3  %u,%u OPEN subagent '%s' DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3 OPEN: Duplicate subagent '%s' DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3 Can't allocate new subagent. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3 Can't bind sub skt: %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3      Closing subagent %s, reason: %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3    Register '%s'(%s) pri=%d from subagent '%s'. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3   Already registered '%s' DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3      Already registered '%s' DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3  malloc error
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3 Malloc error; Did not get %s %s %s %s %s %s
   'grp'   'oid'   'end'  'grpend'   'reg'  'name' DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3  malloc error
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3  malloc error
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3  malloc error
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3  malloc error
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3  malloc error
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3    ALL ALL Unregister  '%s' from subagent '%s'. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3     /usr/tmp/snmpd_dump.log w Can't open dump file: %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3   snmpd SUBTREE registry = 

 %s up to %s
      %s (pri=%-3d), subagent %-20s registration '%s' (%s)
 ACTIVE   INACTIVE 
   Sendto failed: %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3 Invalid enterprise string in trap msg. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_MR.C;3        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated                      esnmp   udp eSNMP well-known port is not defined
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_SR.C;3 sigaction: INT     sigaction: TERM can't allocate srq DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_SR.C;3   sr que full DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_SR.C;3 Internal error. (Invalid packet type)
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_SR.C;3  Sendto failed: %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_SR.C;3  SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated                                        DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 New SNMP Packet: %s.   GET GETNEXT GETBULK SET   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 Can't serialize. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 Can't send to %s: %s DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3    Closing connection with %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3  mstr_tr: recvfrom on %i returned %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 No sub for recvd tr. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3  sub - skt mismatch. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 Obtained response %d from %s%s , with error  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 No rqst for received tr. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3  Expected a RESPONSE: got type %i. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 Expected id: %i got: %i; ignored DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3  unpack error
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 Obtained varbind item %d DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 Expected vb! DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 EXCEPTION in item %d DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3      Timeout DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3      Returning SNMP Response DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 Returning SNMP Response with error DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 Can't make output Pdu. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3 Getclock: %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3  Can't map error number %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MSTR_TR.C;3        !  @(#)$RCSfile: snmpv1.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/04/27 19:33:02 $  SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated  do_snmpv1: Authentication failure
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]SNMPV1.C;3 do_snmpv1: Error parsing pdu packlet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]SNMPV1.C;3       <#  @(#)$RCSfile: trap.c,v $ $Revision: 1.1.6.2 $ (DEC) $Date: 1995/10/26 19:21:17 $    SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated          do_trap %s: host db doesn't know self.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3 %s: cannot get socket for trap.
        DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3                     SendTrap_comm %s: unable to clone local addr.
      DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3 %s unable to make tmp_enterprise OID.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3 %s cannot make pdu.
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3 %s: Cannot link varbind with pdu.
      DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3 %s unable to BuildPdu()
        DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3 %s unable to make octet string.
        DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3 %s unable to make auth header.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3 %s unable to make octet string.
        DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3 %s: Sending trap pdu to %s.
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3 %s: Sendto failed, unable to send trap to manager.
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]TRAP.C;3 SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated      ESNMPD_SHARED_MEMORY    01-JAN-1970 00:00:00.00      (  (  (  (  (  )  )  )   )  .)  UNDEFINED CONDITION ALERT SUBALERT  EMERGENCY ERROR CRITICAL    WARNING NOTICE  INFORMATIONAL DEBUG                                                                                                                                                                                                                                                                                                                                                                                                                                                                Z                        ,u( $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                    ] "                                                                                                                                                                                                                                                                                                                                     %s:  
  Unexpected error condition in status, reading configuration database.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]VMS_CONFIG.C;3 Unexpected error condition in iosb, reading configuration database.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]VMS_CONFIG.C;3 ucx$snmpEnableAuthenTrap ucx$snmpEnableSets ucx$snmpenableauthentrap  1 LNM$SYSTEM_TABLE Unexpected error condition in status, writing configuration database.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]VMS_CONFIG.C;3 Unexpected error condition in iosb, writing configuration database.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]VMS_CONFIG.C;3 Unexpected error condition in status, setting UCX$SNMPENABLEAUTHRAPS logical.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]VMS_CONFIG.C;3   Unexpected error condition in status, reading SNMP community data.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]VMS_CONFIG.C;3 Unexpected error condition in iosb, reading SNMP community data.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]VMS_CONFIG.C;3 This system is not licensed to run the eSNMP Agent.
      D/  @(#)$RCSfile: auth_lib.c,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 1994/01/05 20:06:18 $        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated MakeAuthentication, auth_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]AUTH_LIB.C;3 BuildAuthentication, packlet malloc
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]AUTH_LIB.C;3 BuildAuthentication, NO PDU.
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]AUTH_LIB.C;3 BuildAuthentication malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]AUTH_LIB.C;3 ParseAuthentication, auth_ptr malloc
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]AUTH_LIB.C;3 ParseAuthentication, ParseSequence:
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]AUTH_LIB.C;3 ParseAuthentication, version:
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]AUTH_LIB.C;3 ParseAuthentication: version failure.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]AUTH_LIB.C;3     ParseAuthentication, community
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]AUTH_LIB.C;3     3  @(#)$RCSfile: bld_pkt.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/08/11 12:19:19 $ SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated BuildPdu, varbindlen:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3 BuildPdu,varbindlenlen:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3 BuildPdu, temp_data_len (1)
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3 BuildPdu, temp_data_len (2)
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3    BuildPdu, bad pdu type: %x
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3 BuildPdu, lenlen:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3 BuildPdu, pdu_ptr->packlet malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3  BuildPdu, pdu_ptr->packlet->octet_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3    AddVarBind, AddOID
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3  AddVarBind, AddOctetString
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3      BuildPdu, bad pdu_ptr->type - II. Should not happen:%x
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3      FindLenVarBind, lenlen
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3      FindLenOctetString, NULL input
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3  FindLenOctetString, lenlen
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3  FindLenOID, lenlen
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3 Lenlen: Length greater than 0x01000000???
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3 AddVarBind, lenlen:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3    AddVarBind, AddOID
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3  AddVarBind, AddOID
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3  AddVarBind, AddOctetString
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3 AddVarBind, value: Illegal type: 0x%x
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3 AddOctetString,lenlen
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3 AddOID,lenlen
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]BLD_PKT.C;3        ;  @(#)$RCSfile: make_lib.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/04/27 19:27:30 $        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated MakeOctetString: Bad octetstring length: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3     MakeOctetString, os_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOctetString, octet_ptr malloc
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOID: Bad sid string length: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOID, oid_ptr malloc
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOID, oid_ptr->oid_ptr malloc
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeVarBind: Null object parameter.
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeVarBind: object->oid is NULL.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeVarBind, vb malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeVarBind: cannot malloc vb->name.
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeVarBind: Illegal type: 0x%x
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeVarBindWithValue: Null object OID.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeVarBindWithValue, vb malloc
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeVarBindWithValue: cannot malloc vb->name.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeVarBindWithValue: Illegal type: 0x%x
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeVarBindWithNull: Null object OID.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3     MakeVarBindWithNull, vb malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeVarBindWithNull: cannot malloc vb->name.
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 make_varbind, vb_ptr malloc
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 make_varbind: Illegal type: 0x%x
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakePdu, pdu_ptr malloc
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakePdu: Trap type but no Enterprise.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakePdu: Trap type but no Agent_addr.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakePdu: illegal type: 0x%x
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 LinkVarBind: Trying to add Null Variable
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOctetStringFromText, os_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOctetStringFromText, octet_ptr malloc
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOctetStringFromHex, os_ptr malloc
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOctetStringFromHex, octet_ptr malloc
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 %x      MakeOIDFromHex, oid_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3     MakeOIDFromHex, oid_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 %x CloneOID: clone oid struct malloc
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 CloneOID: clone oid malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 ClonePartialOID: clone oid struct malloc
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 ClonePartialOID: clone oid malloc
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeLenOID: passed in null oid
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeLenOID: Too int: %d
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeLenOID: Zero length OID
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeLenOID: cannot malloc oid
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeLenOID: cannot malloc oid_ptr
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOIDSubLen:  A null OID was passed in
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOIDSubLen: Too int %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOIDSubLen: Cannot make Zero-Length OID
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOIDSubLen: cannot malloc oid
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 MakeOIDSubLen: cannot malloc oid_ptr
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 CloneVarBindList: value passed in is NULL
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 CloneVarBindList:  NULL return from CloneVarBind.
  DISK                                                                                                                                                                                                                                                   [                        T $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                    t "     '       $UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 CloneVarBind: value passed in is NULL
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 CloneVarBind: Cannot malloc out_vb
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3     CloneVarBind: Unable to clone vb->name
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 CloneVarBind: Unable to clone vb->value.oid_value
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 CloneVarBind: Unable to clone vb->value.os_value
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3 CloneVarBind: Illegal type: 0x%x
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]MAKE_LIB.C;3     tN  @(#)$RCSfile: free_lib.c,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 1994/01/05 20:06:46 $        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated      ,O  @(#)$RCSfile: prse_pkt.c,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 1994/01/05 20:07:01 $        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated ParsePdu, bad packlet in auth_ptr->packlet:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, pdu_ptr malloc
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, pdu_type
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, length
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, bad length:
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, request_id
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3     ParsePdu, error_status
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, error_index
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, enterprise
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, agent_addr
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, generic_trap
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, specific_trap
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, time-ticks
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, bad pdu_type: %x
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, ParseSequence failure
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParsePdu, vb_ptr
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseVarBind, ParseSequence failure
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseVarBind, vb_ptr
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseVarBind, vb_ptr->name
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseVarBind, vb_ptr->value.ul_value
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseVarBind, vb_ptr->value.sl_value
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseVarBind, vb_ptr->value.oid_value
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseVarBind, vb_ptr->value.os_value
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseVarBind, ParseNull
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseVarBind, value: Illegal type: 0x%x
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseVarBind, past end of packet.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseOctetString, type error.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseOctetString, length error.
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseOctetString, os_ptr
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseOctetString, past end of packet.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseOID, type error.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseOID, type %x not OBJECT_ID_TYPE
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseOID, length error.
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseOID: Bad sid string length: %ld
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseOID, oid_ptr malloc
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseOID, oid_ptr malloc
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseOID, past end of packet.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 parsed_unsignedinteger, type error.
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseUInt, length error.
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 parsed_unsignedinteger, length error: l%d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3     ParseUInt, past end of packet.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 parsed_signedinteger, type error.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseInt, length error.
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 parsed_signedinteger, length error: %ld
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseInt, past end of packet.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseNull, Unexpected type: %x
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseNull, length error.
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseNull, length nonzero.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3     ParseNull, past end of packet.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseSequence, Unexpected type: %x
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseSequence, length error.
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseSequence, past end of packet.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseType, past end of packet.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 no such type in ParseType (%d) (0x%x)
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseLength: lenlen invalid: (%d).
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 ParseLength, past end of packet.
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRSE_PKT.C;3 Db  @(#)$RCSfile: oid_lib.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/04/27 19:27:50 $ SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated      n  n  n  n  n  n  n  n  n  n  n  n  n  n  n  n  o  o  o  (o  8o  Ho  Xo  ho  xo  o  o  o  o  o  o  o  o  o  
p  p  (p  0p  @p  Hp  `p  hp  p  p  p  p  p  p  p  p  p  q  q  (q  <q  Lq  `q  pq  q  q  q  q  q  q  q  q  
r  r  .r  @r  Xr  dr  yr  r  r  r  r  r  r  r  s  s  -s  8s  Ms  Ps  `s  hs  xs  s  s  s  s  s  s  s  s  s  
t  t  (t  8t  Ht  Xt  ht  xt  t  t  t  t  t  t  t   u  u   u  0u  >u  Pu  ^u  pu  ~u  u  u  u  u  u  u  u  u  v  v  $v  0v  Bv  Pv  dv  pv  v  v  v  v  v  v  v  v  
w  w  4w  Hw  ]w  jw  {w  w  w  w  w  w  w  w  x  x  )x  8x  Mx  \x  qx  x  x  x  x  x  x  x  x  y  y  .y  Dy  Py  fy  xy  y  y  y  y  y  y  
z  $z  9z  Jz  `z  rz  z  z  z  z  z  z  z  z   {  {   {  0{  @{  X{  h{  x{  {  {  {  {  {  {  {   |  |  (|  9|  L|  `|  l|  ~|  |  |  |  |  |  |  |  
}  }  -}  >}  O}  \}  p}  }  }  }  }  }  }  }   ~  ~  (~  ,~  @~  P~  `~  p~  ~  ~  ~  ~  ~  ~  ~  ~          0  @  P  `  j  {                      ,  A  R  h  z          π  ڀ             0  @  P  `  p            Ё            (  8  H  X  h  x          Ƃ  ؂           ,  @  P  d  t          ԃ        $  5  J  ]  r        Ǆ  Ԅ           0  =  L  R  d  p          ԅ         ,  B  \  t        ؆        6  P  d  ~      Ї      $  @  [  n        Ԉ        2  P  p        ̉          0  H  `  t        ފ      4  V  p        ֋      "  <  S  n        ތ         @  P  p        Ѝ        8  L  h  |      Ŏ        8  L  h  z      Ə        *  <  W  d  x        Ɛ  ؐ         .  H  Z  t        ԑ      .  H  \  v      ƒ        0  L  ^  y              ,  G  Z  v        ה         ;  R  m        ӕ        (  B  X  p        Ԗ      (  @  Z        ؗ      4  N  `  t        ʘ            (  4  F  X  p          ԙ          0  @  X  h  z          Ԛ      
    ,  >  P  d  x          ̛  ޛ        $  8  P  `  r          ̜  ޜ          $  0  :  H  X  h  t          ȝ  ֝          .  <  N  d  v          Ȟ  ؞        "  8  J  \  n        ʟ        &  B  T  i  |        ̠          2  E  X  k  |        ȡ  ܡ          &  4  H  X  h  x          Т                                                                                                                                                                                                                                                         \                        [ $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                    x "     8           ,  >  P  b  t        £  ֣        $  8  P  c  z            ¤  Ф  ؤ             &  8  H          ccitt 0 iso 1   org 1.3 dod 1.3.6 internet      1.3.6.1 directory 1.3.6.1.1 mgmt  1.3.6.1.2 mib_2   1.3.6.1.2.1 system  1.3.6.1.2.1.1 sysDescr  1.3.6.1.2.1.1.1 sysObjectID     1.3.6.1.2.1.1.2 sysUpTime       1.3.6.1.2.1.1.3 sysContact      1.3.6.1.2.1.1.4 sysName 1.3.6.1.2.1.1.5 sysLocation     1.3.6.1.2.1.1.6 sysServices     1.3.6.1.2.1.1.7 interfaces  1.3.6.1.2.1.2 ifNumber      1.3.6.1.2.1.2.1 ifTable 1.3.6.1.2.1.2.2 ifEntry 1.3.6.1.2.1.2.2.1       ifIndex 1.3.6.1.2.1.2.2.1.1     ifDescr 1.3.6.1.2.1.2.2.1.2 ifType  1.3.6.1.2.1.2.2.1.3 ifMtu   1.3.6.1.2.1.2.2.1.4     ifSpeed 1.3.6.1.2.1.2.2.1.5 ifPhysAddress   1.3.6.1.2.1.2.2.1.6 ifAdminStatus   1.3.6.1.2.1.2.2.1.7 ifOperStatus    1.3.6.1.2.1.2.2.1.8 ifLastChange    1.3.6.1.2.1.2.2.1.9 ifInOctets 1.3.6.1.2.1.2.2.1.10 ifInUcastPkts 1.3.6.1.2.1.2.2.1.11 ifInNUcastPkts 1.3.6.1.2.1.2.2.1.12 ifInDiscards 1.3.6.1.2.1.2.2.1.13 ifInErrors 1.3.6.1.2.1.2.2.1.14  ifInUnknownProtos 1.3.6.1.2.1.2.2.1.15    ifOutOctets 1.3.6.1.2.1.2.2.1.16 ifOutUcastPkts 1.3.6.1.2.1.2.2.1.17    ifOutNUcastPkts 1.3.6.1.2.1.2.2.1.18  ifOutDiscards 1.3.6.1.2.1.2.2.1.19    ifOutErrors 1.3.6.1.2.1.2.2.1.20  ifOutQLen 1.3.6.1.2.1.2.2.1.21 ifSpecific 1.3.6.1.2.1.2.2.1.22 at 1.3.6.1.2.1.3   atTable 1.3.6.1.2.1.3.1 atEntry 1.3.6.1.2.1.3.1.1 atIfIndex 1.3.6.1.2.1.3.1.1.1 atPhysAddress   1.3.6.1.2.1.3.1.1.2 atNetAddress    1.3.6.1.2.1.3.1.1.3 ip  1.3.6.1.2.1.4 ipForwarding  1.3.6.1.2.1.4.1 ipDefaultTTL    1.3.6.1.2.1.4.2 ipInReceives    1.3.6.1.2.1.4.3 ipInHdrErrors   1.3.6.1.2.1.4.4 ipInAddrErrors  1.3.6.1.2.1.4.5 ipForwDatagrams 1.3.6.1.2.1.4.6 ipInUnknownProtos       1.3.6.1.2.1.4.7 ipInDiscards    1.3.6.1.2.1.4.8 ipInDelivers    1.3.6.1.2.1.4.9 ipOutRequests 1.3.6.1.2.1.4.10  ipOutDiscards 1.3.6.1.2.1.4.11  ipOutNoRoutes 1.3.6.1.2.1.4.12 ipReasmTimeout 1.3.6.1.2.1.4.13 ipReasmReqds 1.3.6.1.2.1.4.14 ipReasmOKs 1.3.6.1.2.1.4.15 ipReasmFails 1.3.6.1.2.1.4.16  ipFragOKs 1.3.6.1.2.1.4.17  ipFragFails 1.3.6.1.2.1.4.18  ipFragCreates 1.3.6.1.2.1.4.19    ipAddrTable 1.3.6.1.2.1.4.20    ipAddrEntry 1.3.6.1.2.1.4.20.1  ipAdEntAddr 1.3.6.1.2.1.4.20.1.1 ipAdEntIfIndex 1.3.6.1.2.1.4.20.1.2 ipAdEntNetMask 1.3.6.1.2.1.4.20.1.3 ipAdEntBcastAddr 1.3.6.1.2.1.4.20.1.4  ipAdEntReasmMaxSize 1.3.6.1.2.1.4.20.1.5 ipRouteTable 1.3.6.1.2.1.4.21 ipRouteEntry 1.3.6.1.2.1.4.21.1  ipRouteDest 1.3.6.1.2.1.4.21.1.1 ipRouteIfIndex 1.3.6.1.2.1.4.21.1.2 ipRouteMetric1 1.3.6.1.2.1.4.21.1.3 ipRouteMetric2 1.3.6.1.2.1.4.21.1.4 ipRouteMetric3 1.3.6.1.2.1.4.21.1.5 ipRouteMetric4 1.3.6.1.2.1.4.21.1.6 ipRouteNextHop 1.3.6.1.2.1.4.21.1.7    ipRouteType 1.3.6.1.2.1.4.21.1.8 ipRouteProto 1.3.6.1.2.1.4.21.1.9 ipRouteAge 1.3.6.1.2.1.4.21.1.10 ipRouteMask 1.3.6.1.2.1.4.21.1.11 ipRouteMetric5  1.3.6.1.2.1.4.21.1.12 ipRouteInfo 1.3.6.1.2.1.4.21.1.13 ipNetToMediaTable 1.3.6.1.2.1.4.22  ipNetToMediaEntry 1.3.6.1.2.1.4.22.1  ipNetToMediaIfIndex 1.3.6.1.2.1.4.22.1.1        ipNetToMediaPhysAddress 1.3.6.1.2.1.4.22.1.2 ipNetToMediaNetAddress 1.3.6.1.2.1.4.22.1.3 ipNetToMediaType 1.3.6.1.2.1.4.22.1.4  ipRoutingDiscards 1.3.6.1.2.1.4.23 icmp 1.3.6.1.2.1.5 icmpInMsgs        1.3.6.1.2.1.5.1 icmpInErrors    1.3.6.1.2.1.5.2 icmpInDestUnreachs      1.3.6.1.2.1.5.3 icmpInTimeExcds 1.3.6.1.2.1.5.4 icmpInParmProbs 1.3.6.1.2.1.5.5 icmpInSrcQuenchs        1.3.6.1.2.1.5.6 icmpInRedirects 1.3.6.1.2.1.5.7 icmpInEchos     1.3.6.1.2.1.5.8 icmpInEchoReps  1.3.6.1.2.1.5.9 icmpInTimestamps 1.3.6.1.2.1.5.10   icmpInTimestampReps 1.3.6.1.2.1.5.11        icmpInAddrMasks 1.3.6.1.2.1.5.12 icmpInAddrMaskReps 1.3.6.1.2.1.5.13    icmpOutMsgs 1.3.6.1.2.1.5.14  icmpOutErrors 1.3.6.1.2.1.5.15    icmpOutDestUnreachs 1.3.6.1.2.1.5.16 icmpOutTimeExcds 1.3.6.1.2.1.5.17 icmpOutParmProbs 1.3.6.1.2.1.5.18  icmpOutSrcQuenchs 1.3.6.1.2.1.5.19 icmpOutRedirects 1.3.6.1.2.1.5.20 icmpOutEchos 1.3.6.1.2.1.5.21    icmpOutEchoReps 1.3.6.1.2.1.5.22  icmpOutTimestamps 1.3.6.1.2.1.5.23 icmpOutTimestampReps 1.3.6.1.2.1.5.24 icmpOutAddrMasks 1.3.6.1.2.1.5.25    icmpOutAddrMaskReps 1.3.6.1.2.1.5.26    tcp 1.3.6.1.2.1.6       tcpRtoAlgorithm 1.3.6.1.2.1.6.1 tcpRtoMin       1.3.6.1.2.1.6.2 tcpRtoMax       1.3.6.1.2.1.6.3 tcpMaxConn      1.3.6.1.2.1.6.4 tcpActiveOpens  1.3.6.1.2.1.6.5 tcpPassiveOpens 1.3.6.1.2.1.6.6 tcpAttemptFails 1.3.6.1.2.1.6.7 tcpEstabResets  1.3.6.1.2.1.6.8 tcpCurrEstab    1.3.6.1.2.1.6.9 tcpInSegs 1.3.6.1.2.1.6.10 tcpOutSegs 1.3.6.1.2.1.6.11 tcpRetransSegs 1.3.6.1.2.1.6.12 tcpConnTable 1.3.6.1.2.1.6.13 tcpConnEntry 1.3.6.1.2.1.6.13.1 tcpConnState 1.3.6.1.2.1.6.13.1.1  tcpConnLocalAddress 1.3.6.1.2.1.6.13.1.2 tcpConnLocalPort 1.3.6.1.2.1.6.13.1.3  tcpConnRemAddress 1.3.6.1.2.1.6.13.1.4 tcpConnRemPort 1.3.6.1.2.1.6.13.1.5  tcpInErrs 1.3.6.1.2.1.6.14 tcpOutRsts 1.3.6.1.2.1.6.15  udp 1.3.6.1.2.1.7 udpInDatagrams    1.3.6.1.2.1.7.1 udpNoPorts      1.3.6.1.2.1.7.2 udpInErrors     1.3.6.1.2.1.7.3 udpOutDatagrams 1.3.6.1.2.1.7.4 udpTable        1.3.6.1.2.1.7.5 udpEntry  1.3.6.1.2.1.7.5.1     udpLocalAddress 1.3.6.1.2.1.7.5.1.1 udpLocalPort    1.3.6.1.2.1.7.5.1.2 egp 1.3.6.1.2.1.8 egpInMsgs     1.3.6.1.2.1.8.1 egpInErrors     1.3.6.1.2.1.8.2 egpOutMsgs      1.3.6.1.2.1.8.3 egpOutErrors    1.3.6.1.2.1.8.4 egpNeighTable   1.3.6.1.2.1.8.5 egpNeighEntry 1.3.6.1.2.1.8.5.1 egpNeighState   1.3.6.1.2.1.8.5.1.1 egpNeighAddr    1.3.6.1.2.1.8.5.1.2 egpNeighAs  1.3.6.1.2.1.8.5.1.3 egpNeighInMsgs  1.3.6.1.2.1.8.5.1.4 egpNeighInErrs  1.3.6.1.2.1.8.5.1.5 egpNeighOutMsgs 1.3.6.1.2.1.8.5.1.6     egpNeighOutErrs 1.3.6.1.2.1.8.5.1.7 egpNeighInErrMsgs   1.3.6.1.2.1.8.5.1.8 egpNeighOutErrMsgs  1.3.6.1.2.1.8.5.1.9 egpNeighStateUps 1.3.6.1.2.1.8.5.1.10 egpNeighStateDowns 1.3.6.1.2.1.8.5.1.11 egpNeighIntervalHello 1.3.6.1.2.1.8.5.1.12 egpNeighIntervalPoll 1.3.6.1.2.1.8.5.1.13 egpNeighMode 1.3.6.1.2.1.8.5.1.14 egpNeighEventTrigger 1.3.6.1.2.1.8.5.1.15  egpAs       1.3.6.1.2.1.8.6 transmission 1.3.6.1.2.1.10 fddi  1.3.6.1.2.1.10.15 snmpFddiSMT 1.3.6.1.2.1.10.15.1 snmpFddiSMTNumber 1.3.6.1.2.1.10.15.1.1 snmpFddiSMTTable  1.3.6.1.2.1.10.15.1.2 snmpFddiSMTEntry    1.3.6.1.2.1.10.15.1.2.1 snmpFddiSMTIndex  1.3.6.1.2.1.10.15.1.2.1.1 snmpFddiSMTStationId  1.3.6.1.2.1.10.15.1.2.1.2 snmpFddiSMTOpVersionId  1.3.6.1.2.1.10.15.1.2.1.3 snmpFddiSMTHiVersionId  1.3.6.1.2.1.10.15.1.2.1.4 snmpFddiSMTLoVersionId  1.3.6.1.2.1.10.15.1.2.1.5 snmpFddiSMTMACCt  1.3.6.1.2.1.10.15.1.2.1.6 snmpFddiSMTNonMasterCt  1.3.6.1.2.1.10.15.1.2.1.7 snmpFddiSMTMasterCt 1.3.6.1.2.1.10.15.1.2.1.8 snmpFddiSMTPathsAvailable 1.3.6.1.2.1.10.15.1.2.1.9 snmpFddiSMTConfigCapabilities 1.3.6.1.2.1.10.15.1.2.1.10      snmpFddiSMTConfigPolicy 1.3.6.1.2.1.10.15.1.2.1.11  snmpFddiSMTConnectionPolicy 1.3.6.1.2.1.10.15.1.2.1.12 snmpFddiSMTTNotify 1.3.6.1.2.1.10.15.1.2.1.13 snmpFddiSMTStatusReporting 1.3.6.1.2.1.10.15.1.2.1.14  snmpFddiSMTECMState 1.3.6.1.2.1.10.15.1.2.1.15 snmpFddiSMTCFState 1.3.6.1.2.1.10.15.1.2.1.16 snmpFddiSMTHoldState 1.3.6.1.2.1.10.15.1.2.1.17    snmpFddiSMTRemoteDisconnectFlag 1.3.6.1.2.1.10.15.1.2.1.18 snmpFddiSMTStationAction 1.3.6.1.2.1.10.15.1.2.1.19  snmpFddiMAC 1.3.6.1.2.1.10.15.2 snmpFddiMACNumber 1.3.6.1.2.1.10.15.2.1 snmpFddiMACTable  1.3.6.1.2.1.10.15.2.2 snmpFddiMACEntry        1.3.6.1.2.1.10.15.2.2.1 snmpFddiMACSMTIndex 1.3.6.1.2.1.10.15.2.2.1.1 snmpFddiMACIndex  1.3.6.1.2.1.10.15.2.2.1.2 snmpFddiMACFrameStatusCapabilities  1.3.6.1.2.1.10.15.2.2.1.3 snmpFddiMACTMaxGreatestLowerBound 1.3.6.1.2.1.10.15.2.2.1.4 snmpFddiMACTVXGreatestLowerBound  1.3.6.1.2.1.10.15.2.2.1.5 snmpFddiMACPathsAvailable 1.3.6.1.2.1.10.15.2.2.1.6 snmpFddiMACCurrentPath  1.3.6.1.2.1.10.15.2.2.1.7 snmpFddiMACUpstreamNbr  1.3.6.1.2.1.10.15.2.2.1.8 snmpFddiMACOldUpstreamNbr 1.3.6.1.2.1.10.15.2.2.1.9 snmpFddiMACDupAddrTest 1.3.6.1.2.1.10.15.2.2.1.10 snmpFddiMACPathsRequested 1.3.6.1.2.1.10.15.2.2.1.11  snmpFddiMACDownstreamPORTType 1.3.6.1.2.1.10.15.2.2.1.12  snmpFddiMACSMTAddress 1.3.6.1.2.1.10.15.2.2.1.13  snmpFddiMACTReq 1.3.6.1.2.1.10.15.2.2.1.14      snmpFddiMACTNeg 1.3.6.1.2.1.10.15.2.2.1.15      snmpFddiMACTMax 1.3.6.1.2.1.10.15.2.2.1.16  snmpFddiMACTvxValue 1.3.6.1.2.1.10.15.2.2.1.17      snmpFddiMACTMin 1.3.6.1.2.1.10.15.2.2.1.18  snmpFddiMACCurrentFrameStatus 1.3.6.1.2.1.10.15.2.2.1.19    snmpFddiMACFrameCts 1.3.6.1.2.1.10.15.2.2.1.20  snmpFddiMACErrorCts 1.3.6.1.2.1.10.15.2.2.1.21 snmpFddiMACLostCts 1.3.6.1.2.1.10.15.2.2.1.22 snmpFddiMACFrameErrorThreshold 1.3.6.1.2.1.10.15.2.2.1.23 snmpFddiMACFrameErrorRatio 1.3.6.1.2.1.10.15.2.2.1.24    snmpFddiMACRMTState 1.3.6.1.2.1.10.15.2.2.1.25  snmpFddiMACDaFlag 1.3.6.1.2.1.10.15.2.2.1.26 snmpFddiMACUnaDaFlag 1.3.6.1.2.1.10.15.2.2.1.27  snmpFddiMACFrameCondition 1.3.6.1.2.1.10.15.2.2.1.28 snmpF                                                                                                                                                                                                                                                   ]                        s $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                     "     I       ddiMACChipSet 1.3.6.1.2.1.10.15.2.2.1.29  snmpFddiMACAction 1.3.6.1.2.1.10.15.2.2.1.30 snmpFddiPATH 1.3.6.1.2.1.10.15.3 snmpFddiPORT    1.3.6.1.2.1.10.15.4 snmpFddiPORTNumber  1.3.6.1.2.1.10.15.4.1 snmpFddiPORTTable 1.3.6.1.2.1.10.15.4.2 snmpFddiPORTEntry 1.3.6.1.2.1.10.15.4.2.1 snmpFddiPORTSMTIndex  1.3.6.1.2.1.10.15.4.2.1.1 snmpFddiPORTIndex 1.3.6.1.2.1.10.15.4.2.1.2 snmpFddiPORTPCType  1.3.6.1.2.1.10.15.4.2.1.3 snmpFddiPORTPCNeighbor  1.3.6.1.2.1.10.15.4.2.1.4 snmpFddiPORTConnectionPolicies  1.3.6.1.2.1.10.15.4.2.1.5 snmpFddiPORTRemoteMACIndicated  1.3.6.1.2.1.10.15.4.2.1.6 snmpFddiPORTCEState 1.3.6.1.2.1.10.15.4.2.1.7 snmpFddiPORTPathsRequested  1.3.6.1.2.1.10.15.4.2.1.8 snmpFddiPORTMACPlacement  1.3.6.1.2.1.10.15.4.2.1.9 snmpFddiPORTAvailablePaths 1.3.6.1.2.1.10.15.4.2.1.10   snmpFddiPORTMACLoopTime 1.3.6.1.2.1.10.15.4.2.1.11  snmpFddiPORTTBMax 1.3.6.1.2.1.10.15.4.2.1.12 snmpFddiPORTBSFlag 1.3.6.1.2.1.10.15.4.2.1.13 snmpFddiPORTLCTFailCts 1.3.6.1.2.1.10.15.4.2.1.14        snmpFddiPORTLerEstimate 1.3.6.1.2.1.10.15.4.2.1.15 snmpFddiPORTLemRejectCts 1.3.6.1.2.1.10.15.4.2.1.16 snmpFddiPORTLemCts 1.3.6.1.2.1.10.15.4.2.1.17  snmpFddiPORTLerCutoff 1.3.6.1.2.1.10.15.4.2.1.18 snmpFddiPORTLerAlarm 1.3.6.1.2.1.10.15.4.2.1.19 snmpFddiPORTConnectState 1.3.6.1.2.1.10.15.4.2.1.20 snmpFddiPORTPCMState 1.3.6.1.2.1.10.15.4.2.1.21 snmpFddiPORTPCWithhold 1.3.6.1.2.1.10.15.4.2.1.22 snmpFddiPORTLerCondition 1.3.6.1.2.1.10.15.4.2.1.23    snmpFddiPORTChipSet 1.3.6.1.2.1.10.15.4.2.1.24 snmpFddiPORTAction 1.3.6.1.2.1.10.15.4.2.1.25 snmpFddiATTACHMENT 1.3.6.1.2.1.10.15.5 snmpFddiATTACHMENTNumber  1.3.6.1.2.1.10.15.5.1 snmpFddiATTACHMENTTable 1.3.6.1.2.1.10.15.5.2   snmpFddiATTACHMENTEntry 1.3.6.1.2.1.10.15.5.2.1 snmpFddiATTACHMENTSMTIndex  1.3.6.1.2.1.10.15.5.2.1.1   snmpFddiATTACHMENTIndex 1.3.6.1.2.1.10.15.5.2.1.2       snmpFddiATTACHMENTClass 1.3.6.1.2.1.10.15.5.2.1.3 snmpFddiATTACHMENTOpticalBypassPresent  1.3.6.1.2.1.10.15.5.2.1.4 snmpFddiATTACHMENTIMaxExpiration  1.3.6.1.2.1.10.15.5.2.1.5 snmpFddiATTACHMENTInsertedStatus  1.3.6.1.2.1.10.15.5.2.1.6 snmpFddiATTACHMENTInsertPolicy  1.3.6.1.2.1.10.15.5.2.1.7 snmpFddiChipSets  1.3.6.1.2.1.10.15.6 snmpFddiPHYChipSets 1.3.6.1.2.1.10.15.6.1   snmpFddiMACChipSets 1.3.6.1.2.1.10.15.6.2 snmpFddiPHYMACChipSets  1.3.6.1.2.1.10.15.6.3 snmp 1.3.6.1.2.1.11 snmpInPkts 1.3.6.1.2.1.11.1 snmpOutPkts 1.3.6.1.2.1.11.2  snmpInBadVersions 1.3.6.1.2.1.11.3        snmpInBadCommunityNames 1.3.6.1.2.1.11.4 snmpInBadCommunityUses 1.3.6.1.2.1.11.5 snmpInASNParseErrs 1.3.6.1.2.1.11.6  snmpInTooBigs 1.3.6.1.2.1.11.8  snmpInNoSuchNames 1.3.6.1.2.1.11.9        snmpInBadValues 1.3.6.1.2.1.11.10       snmpInReadOnlys 1.3.6.1.2.1.11.11 snmpInGenErrs 1.3.6.1.2.1.11.12 snmpInTotalReqVars  1.3.6.1.2.1.11.13 snmpInTotalSetVars  1.3.6.1.2.1.11.14 snmpInGetRequests 1.3.6.1.2.1.11.15 snmpInGetNexts  1.3.6.1.2.1.11.16 snmpInSetRequests 1.3.6.1.2.1.11.17 snmpInGetResponses  1.3.6.1.2.1.11.18   snmpInTraps 1.3.6.1.2.1.11.19 snmpOutTooBigs  1.3.6.1.2.1.11.20 snmpOutNoSuchNames  1.3.6.1.2.1.11.21 snmpOutBadValues  1.3.6.1.2.1.11.22 snmpOutGenErrs  1.3.6.1.2.1.11.24 snmpOutGetRequests  1.3.6.1.2.1.11.25       snmpOutGetNexts 1.3.6.1.2.1.11.26 snmpOutSetRequests  1.3.6.1.2.1.11.27 snmpOutGetResponses 1.3.6.1.2.1.11.28 snmpOutTraps  1.3.6.1.2.1.11.29 snmpEnableAuthenTraps 1.3.6.1.2.1.11.30 experimental  1.3.6.1.3 dot5  1.3.6.1.3.4 dot5Table 1.3.6.1.3.4.1 dot5Entry       1.3.6.1.3.4.1.1 dot5IfIndex 1.3.6.1.3.4.1.1.1 dot5Commands  1.3.6.1.3.4.1.1.2 dot5RingStatus  1.3.6.1.3.4.1.1.3 dot5RingState 1.3.6.1.3.4.1.1.4 dot5RingOpenStatus  1.3.6.1.3.4.1.1.5 dot5RingSpeed 1.3.6.1.3.4.1.1.6 dot5UpStream  1.3.6.1.3.4.1.1.7 dot5ActMonParticipate 1.3.6.1.3.4.1.1.8 dot5Functional  1.3.6.1.3.4.1.1.9 dot5StatsTable  1.3.6.1.3.4.2 dot5StatsEntry    1.3.6.1.3.4.2.1 dot5StatsIfIndex  1.3.6.1.3.4.2.1.1 dot5StatsLineErrors 1.3.6.1.3.4.2.1.2 dot5StatsBurstErrors  1.3.6.1.3.4.2.1.3 dot5StatsACErrors 1.3.6.1.3.4.2.1.4 dot5StatsAbortTransErrors 1.3.6.1.3.4.2.1.5       dot5StatsInternalErrors 1.3.6.1.3.4.2.1.6 dot5StatsLostFrameErrors  1.3.6.1.3.4.2.1.7   dot5StatsReceiveCongestions 1.3.6.1.3.4.2.1.8 dot5StatsFrameCopiedErrors  1.3.6.1.3.4.2.1.9 dot5StatsTokenErrors 1.3.6.1.3.4.2.1.10 dot5StatsSoftErrors 1.3.6.1.3.4.2.1.11  dot5StatsHardErrors 1.3.6.1.3.4.2.1.12  dot5StatsSignalLoss 1.3.6.1.3.4.2.1.13 dot5StatsTransmitBeacons 1.3.6.1.3.4.2.1.14 dot5StatsRecoverys 1.3.6.1.3.4.2.1.15 dot5StatsLobeWires 1.3.6.1.3.4.2.1.16 dot5StatsRemoves 1.3.6.1.3.4.2.1.17 dot5StatsSingles 1.3.6.1.3.4.2.1.18  dot5StatsFreqErrors 1.3.6.1.3.4.2.1.19  dot5Tests 1.3.6.1.3.4.3 testInsertFunc      1.3.6.1.3.4.3.1 dot5ChipSets  1.3.6.1.3.4.4 chipSetIBM16        1.3.6.1.3.4.4.1 chipSetTItms380 1.3.6.1.3.4.4.2 chipSetTItms380c16      1.3.6.1.3.4.4.3 dot5TimerTable  1.3.6.1.3.4.5 dot5TimerEntry    1.3.6.1.3.4.5.1 dot5TimerIfIndex  1.3.6.1.3.4.5.1.1 dot5TimerReturnRepeat 1.3.6.1.3.4.5.1.2 dot5TimerHolding  1.3.6.1.3.4.5.1.3 dot5TimerQueuePDU 1.3.6.1.3.4.5.1.4 dot5TimerValidTransmit  1.3.6.1.3.4.5.1.5 dot5TimerNoToken  1.3.6.1.3.4.5.1.6 dot5TimerActiveMon  1.3.6.1.3.4.5.1.7 dot5TimerStandbyMon 1.3.6.1.3.4.5.1.8 dot5TimerErrorReport  1.3.6.1.3.4.5.1.9   dot5TimerBeaconTransmit 1.3.6.1.3.4.5.1.10 dot5TimerBeaconReceive 1.3.6.1.3.4.5.1.11    private 1.3.6.1.4   enterprises 1.3.6.1.4.1 unix  1.3.6.1.4.1.4 agents  1.3.6.1.4.1.4.1 fourBSD_isode 1.3.6.1.4.1.4.1.2 peers   1.3.6.1.4.1.4.3 unixd 1.3.6.1.4.1.4.3.1 joint_iso_ccitt 2 MakeOIDFragFromDot, table lookup failed: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3   MakeOIDFragFromDot, oid_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFragFromDot, oid_ptr->oid_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  MakeOIDFragFromDot, hex:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3    MakeOIDFragFromDot, octal:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  MakeOIDFragFromDot, decimal:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFragFromDot, bad character: %d, %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFragFromDot, expected dot: %d %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFromDot, illegal OID value %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  ParseSubIdHex, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  %1x ParseSubIdHex, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3       ParseSubIdOctal, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  %1o ParseSubIdOctal, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 ParseSubIdDecimal, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3    %1d ParseSubIdDecimal, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3   MakeDotFromOID, bad (NULL) OID
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeDotFromOID, GetStringFromSubIds
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 %d . .%d             CatOID: Too int: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 CatOID, cannot malloc oid
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 CatOID, cannot malloc oid_ptr
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 $  @(#)$RCSfile: prnt_lib.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/12/19 16:53:03 $        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated  
Packet Dump: 
 %2.2x         
 PrintVarBindList, vb_ptr->name:
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;3 %s =    %u
 %d
 %d.%d.%d.%d
    PrintVarBindList, vb_ptr->value.oid_value:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;3 %s
 NULL
 PrintVarBindList: Illegal type: 0x%x
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;3 
 %c  
                                                                                                                                                                                                                                %s               at line %d in file %s
 Error code set in packet -      Return packet too big.
 No such variable name.  Index:  %d.
  Bad variable value.  Index:  %d.
 Read only variable:  %d.
 General error:  %d.
 Unknown status code:  %d.
                                                                                                                                                                                                                                                                                                                                                                                                                                                          0                                                                                                                                                                                                                                                                                                             ^                        hJ $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                    / "     Z                                                                                       @+                 ,  snmpd.conf                                                                                                                                                                                                                                                                                                                                                                                                                ^M\̬ .  P  ֲ  H^ò  X[MVH^Xt[MV|SRn S  P~   L   t  PS0SS  P@cRR/Su  P@cS6>  ެTݴ ٭  < 0(SެYSi1 dZ   U  W CjePȏ 0  1  C eP
ȏ    w C eP
ȏ  [ C eP
ȏ  ?C  eP   RbgPƬ   Rbg~y  SSi1G T  2n~5  P   PT  &  RT  P3R.(    RT  PRR1FӰ  Rb}  ƀ  Rbi     1I  PkPR1bkRtSt~ h  kRSt+Pd< ~  ƀ<~  ?      ).  PѨƌ  Rbǯ    TȐ <Ȍ ~ ݯ  QШP R
RP
Q{RPQPQSQШP RRRPRQPQP{RPPQxQRRCQШP RRPQP{RPQPQSQШP RRRPRQPQP{RPPQxQRRC  |~|~0C   =  ( P}Ȍ |~P< ~  PRR[ 4  ` @   !  `خ  Pƻ<  ~  <~     `  1oPR1eQШP R
RP
Q{RPQPQTQШP RRRPRQPQP{RPPQxQUDPRRUWQШP R
RP
Q{RPQPQSQШP RRRPRQPQP{RPPQxQRRRRCPYUDPQШP RRPQP{RPQPQSQШP RRRPRQPQP{RPPQxQRRCPP5  W1 LL < ~ݨE  PW8^(n<  P< ~  @<~n  1PTUTSˏ SRR   RRRRE<U~TW,,  ^(nĬ  PWp~  Ơ<~  Y    -  1lڵP  ˏ PP   PPP ^yS*GR }F  P < ~  <6~p  cPďd   Pã\Ə'  \P\QQPP ^FR ɫ  PS0SSޫ  P@c\\/Sʫ  P@cS6  n   ^5S^FR &D  PcP\2lc\tTt~ ]  c\Tt,Pd< ~  <~x  3      P ^SER C  PcP\.lc\tTt~ ժ  c\Ttd< ~  <~    P^+!<  ~ |  Rb< ~ b( bU<  ~ޟI  PT1    W   V%  X!U	 URT)PBSUSg	SfRRT<  ~ h< ~ hU<  ~ޟI  PT1{P< ^]DR°ЬUUD  ScP T-PµUcP!TPUcP!TPTTPP ^V
UCSfTAŏL   ~  Pe~< ~Ǥ  <~3  W1 UPz  TP{PQPPCTŏL   T~e  PR%(< ~q  P<~ݤ  W]Re@~ݬŏL   fPeR@h  ŏL   fPeR@DRЬbŏL   fRB RЬbŏL   fPeR@HRfbffWWPP| ^ITUBSe>ŏD   À~ѧ  Pd(Ä< ~ﴣ  ð<~   V1 Pz  eP{ÀPQPPGeÀRŏD   R~d  PR(< ~`  <~̣  V9PRd@~ݬŏD   eRB W  ŏD   ePdR@@RЬbeeVVP   ^AGRP߭ݬݬJ  PS:Pѭ
P¬ ~ﵢ   ~"  SPP< ^FRU|SݬK  2PPP&&~g  @<~Ӣ  1 ЬPРPݠ`pb  PT'p *  <~  1 PT3G  PS&   <~a  ePTݬSVG  2PPP&  ﵡ  H<~!  %PУQU<U~aݬu  SPlS	SaH  T	Tv  UP^EUЬTd2dSެXhRRRSSdԼW1   V*RŏL   WSC>  PRЦPѠRUPCDP``?RPŏL   WTDhPݰ  PxRDb|xS7WWc1vŀŐ~  Ÿ<a~  SSP ^DR|~|~ ݬݬݬݬ	h  PS&< ~.  <~  T1 ЬPРР"ԠЬPP ' 7 W G KP?PPPVPPTFPPX6PP\&PݬH< ~  <B~  STTP   ^iGUլ#xSSSS^  PЬWRPެVfP`:PЬTS`,  RCXT  TC  PT.SSbڔtЬWWP^FSVfRWЬTdP1 R   1 PdUU.WPX1 PPZRBfWQ~  QdPʏ P@aPP
BfP0UUPBfW%\< ~a  p~Ϟ  XoPTdPR   1yR   XLR)  PTX8xR~  PTޡ  XPRdxR~ݤϡ  TXXP ^  PRTQPbԢЬP@`bx`SSSSx  PRm  TSЬPݠݢa  RTTPP ^լR1PݬvPQRaaPPP@PQRRP ^ES  PR"è < ~   <3~j    R  УT\֣T\R\\P ^ЬSЬЬcЬRR|  RǠ  <cQPQQcЬRRPP^iDUЬRТ[* < ~V  <~  1PRbVV[ݬ  SS`cPShZPSpYASxX2S
|W#SŃTSňSŐSSTTWWXXYYZZެnо R8<~ݮ8~  Ŕ<~  RR
1R1R1ZެTdRZ1  Y,   ZRд PB`P`PѠ 1jд PBQa1ZPBP`iPSд PBP`iVSPSSS'~  <~L  1VSVЬXZRд PBChд PBP`FhFhiPPVд PBP`FhFhiPPVд PBP`iPd   0W
д PBP`Wд PBP`iP
BSPHSд PBP`SWZ~  L<~w  PP1д PBP`SV~FhS4PQQQPQVZdPZ1oVԮ   P^AWUЬP2
RRVvRVlPRV`PRVTPR@   VDPRA   V3RB   V#RC   VRD   VPVЬP2
QQ1 QPPC     Pb?PP@   1 P@        1 P6?PTX1ЬPPTPPSRT1 SPS`RRT1 PЬPРSRxcRRX1 USPUt  PT]PTVPЬPРRТTTXzTbU  ,ЬP2
~ǀ< ~  Ǥ<~X  TT2ЬP֬V`ЬR֬2TSˏ SPxPPPbʏ SSTTXXPP^?TXѬ,ݬ< ~m  <:~ٗ  W1 PЬSPP@ $ p p p p t t t t t p ZP?PVRݬRVlPX_PUU3  PRRUPRPR=ݬRU:PX-*P~8< ~  P<f~,  WXWWP^>UԮnЬVլ1  p      nV׬V VP$Vň~;  Ř<~淪  1lVPTTVTVPTTVTPP2<PPxPPP2<PRPPRR2<RRRPP*ݮ R~  <~.  1PRR   $1 R(1 R,1 R41 R@[1 R   AZ1 R   BYtR   CXaRDWRR	QDPR   P1PRT!RSRRRRSSTTPPQQWWXXYYZZ[[4Ю4,Ю,(Ю($$XXP/ݮ VP`~0< ~  T<~  1PXRR1 RPPf     
P?PP@   1 P@    < < <  ?PP   1 P   p p p 1 P?PޭPPW<2TTPPSRT1 SQSaRRT1 PVPW<2PPVlP<2RRVS  PWRVS<2P"ݮ ň< ~ż<~W+ޭW$Pݮ X~< ~<~WWnWX~ ݮ iW  PSݮ h  ԮS!ݮ P~ń<~SPnԣЬRbSSb:PЮRSS*Pݮ X~Ÿ~ג  <~C  	լ1Xծ
ݮqg  nRRP    P@\ԬT   ^@U < ~m  PW(   `p< ~4  Ň ~  SWVYX\T\VSjPSTTV1PP/  # # # #      ; 1 "?PV V-VWXXRQ!Ѣ,<P<*\P\Q\
PaQ\\1 |~ WPSoS\XTT <l~\q
  PM   `< ~!  <8~  ~ż < ~   ~i  8^>X|ZЬSR#Pѣ,<Q<*PQPRT
PbRTTYЬRPP^z :?Pj  ݬݬPW
eZ1kP8
~B  <~ﮐ  8TR8TH  PRS
PbRSSV1VW1	VU PT:|~ T( <d~T  PST  SS6W+  8P< ~  n<~  mZ1  V  wPYfZjPЬR~Y  PRPYfZFPYݬφPZ5YfZ*PYݬϢ
PZ                                                                                                                                                                                                                                                      _                        |) $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                     "     k       P   PP[ZݬPTLTSЬUU <c~S  P) (  `< ~  <8~   hR*ެT  Sѣ,dP<Q<*PQPRPbRP< ^]<UX~A  PT$š< ~$  ž<~  1 X~ T5  Rb	PbRbTbRЬS<<
ݬ(  8  TϻP7 $  `< ~  <~  T]  RTRRP ^};SЬRR  X  bPТТPb`բ
ݢ  ݬЬR8@< ~  `Џ  ~~  Rِ   ^ PSDd	R)( <c~S  ݢ  bRS  P^:TЬS<cUUVpX1WW  VP  RPRRZPĔZެVfR8ЬR<~WZĖ~*  <(~  ФTS1 ;  UPѣf6WݣeP*W~  <1~Q  gX1PУRDPѣf6WݣeP*WH~  `<8~
  gX1PТRcS1r8K  PS&Ĕ~[  Ģ<A~ǋ  qX1yW*  YiP WiPW.PݣPЬV<0ФXR֤XR( ݣtP$ЬUUZiP<
R	R,PХ,4գ գգգ$
գգ1 գ 	[P[գ

ZPZգ
YPYգ$
WPWգ
$VP&Vգ
,UP-UUVWYZ[~  4<U~|  Sϑh~  v<]~V  qX	S
PXXPP^7WެYi1V[ЧTS1-iZ﹁  X~ݣݪhP1 ~ݣiRݢhP1 ެUeRѢ00	9Ѣ((2ЬPc`УSУRPbPPTcRPԣCPSTУQ(eRѢ00ePѠ00Ѡ((PQTСQЬRФRԢV1P~ݣiRݢhPX~ݣݢhPG߭߭߭SݬTPRݭPRRݭPRRݭϵPRRV1~iRݢݣhP1 ~ݢݣhP1 УRcbPcTcRУRSQRMУTԣ߭߭߭ݬS϶ PR
S6RV1 ݭ(ݭ ݭTSRRݬPRRVhP~ݣiRݢhP(УRЬbЬTЬRSbУRV,PS[cS1[	ЬkPЬTЬRb[VVPP^]5TԼԼԼЬRݢQPWݢDPX ݢPU ݢPVUVWXSU	U  V	V  W[  X[  Ī~ﴆ  ĸ<6~   qY1G~ЬSݣЬRݢ~  P_ݣݢR"PLW'[  X[  U1  V(  ~9  <F~牢  qY1 P~ЬSݣЬRݢ'~  PkݢݣRϦ PXWZ  XZ  U  V  ЬRbYb.~ﰅ  <<W~  qYDPЬRݢNZ  Wݢ \  U ݢ2Z  Xݢ$@  V$RYYPP< ^]3T8  PSU1 PݬFPݬ8P ݣP  ݣxP$ЬRݢf$  PݢX$  PТ00Т((ТТ,,4գ գգգ$
գգ*S+p~  ~<~  USUUP^u2SVfXЬR	VVVTPøTެWgR8Tü~   <~  УTT]4  UPgVݤVeP
4\XФR(PgVݢVeP
4\XТRdTXRRPP ^1RЬQСP*a`СPСaPССPС`$СTaPССPa`PaTݬ P^I1SУTX1 h1 J  VW  U  TPhWXRW\R/\+PѢ!ݬݢfPPТRЬ\R\RQ\KPghgRXX\WR\3PݬeТԢݬ$dТ$$Ԣ$RPЬ\ТRP\hXh1cP ^ЬRݢW  ݢW  բ 
ݢ   ЬRբ$
ݢ$	  ЬRբ
ݢ  ЬRբ
ݢ  ݬم  | ^0Uե\cԥ\VХTTSTSФR P4ТRWRSУR4TVfRPХTRPTVdRRT HP ^/ST0T*  PW- ҄  `2< ~D  K<{~ﰁ  PÀW  УTU]  VPݥ$ݥ ÜWfUR2RUTTݢݢТ\8ݢ0TêWfТRΟWfeUW{  W  | ^.SУTR1  Ux  V~ݢefP1 Ѭ   _~ݢݬzx  P"ݬP  PPݢ   Pݢ$  PRTQP~ݢefP4ݬoPf  PW  PRTPbR18TTPP ^мR%ݢ &  Pݢ$  PRSPSSPP ^-RTЬPSS  P.S`PT?< ~?  f<~  TTS	P^SSݬЬPݠݠ?  T	TS  < ^   PTTU1 ЬQR(Scb߭<~T~  PTu  UN߭RTZ  PTU  U.RT  PT1  U
ЬPTUUPP ^ PS?|~ S\ЬP( <c~S6ρ  PRSׁ  RRP    ^   
  < ^Sn3\phh  PR#t }  ̚ ~~  U1 PXZ z  PT	U1 P߭<~T  PT  U1 XT:  PT  U1 P|   P ߀  T  UJ   P   T}  U|cԣ  ~  TUUPP| ^MT&2VݬݬTPU1 U?  PS1 dRCPѢ52Q2PQP(ТPѠ

ݢ#  ݢQ  USbRѤa  PQ/USЬԡdaQdaRQQ֤ < ~{  <+~|  "P8< ~{  D<0~{  S'Q  UV"   ^1Rբ7բ2ТТ\ЬP`PPbԢԲТ\вע P| ^R0UТSTV?ݣݣa  PQT1 PУ\2PP      8 ( 1 P?P\HT1 r\LT1 b\Dѱ!
Q\|mD\TУ\\ ݬ
~PVAP\<2P\@"Pw z  Ş<~z  TVTV        ^R/Sլ1 ݬТPݠ<PTlТPРТP TO}  P+ |  `< ~fy  <~y  PݬN  ТPݠN  ТPݠ   ݢ|  Ԣ $        ^$ ݯ-}    \տ\\P^0SU|X\ |  ЬT2RR   V$PR   VPR   VPVx~x  z~x  V	 W4PV Q#V PV R RRPPQQWWí ~!x   ~x  ~{  P	Y1 PФR1 P߭߭2~ݢ%PQTUP߰\@l\Qlߤ\@ߙ\@\Эlߋ\@\Эl}\@\Rlp\@\lPXUXYPUТR1uYWA\Ф7RЬ-R2\\   $\   \   Ԣ 9PYY  PYYRYRX 	P\ P ^W|UϪRUwPߜPU\LRbUL`\lRТTФS bPSP^Sd\4V\Ѣ,Т,V	TVWTVU3\UW$R ЦSRRRP< ^-TRТRԢ S1^Pգ1L< ~SϹJP)< ~u  "<~v  U1P( <~ݣFy  P^QУP \\PQP{\PQPQRQУP \\\P\QPQP{\PPQxQ\BX\BQ1 P x  `Dy  P8U< ~t  j<~_u   Xx  `(ULPSP.8Ġ< ~t  ļ<~u   S%U
cS1UUPP< ^TaRT1 Ex  UTQHPA`RbS4УRբ	ݢeԢTQ PARbbeTR	PBScPBRbbeTSPCRbլ'PCRb	bH  TQߺPARbTϬRT1R< ^R UBeV  PS%ѬЬQSPxPPPBaSQxRTQTPRR TTPP^'+U:R  PԮЬXYTDh  PV!YVRxRRRDhVSxTWSWPTT WWn1r  as  [   < ~ݮv  PV"Vݮ< ~<^~k1Wծ1NPZG< ~\<h~k1#ѪnŐ< ~Ť<m~k1 PЪTWէ
SPSS8<~~ <t~kT7< ~P<y~k1PRRRń< ~Ŧ<~~k1w<S<RSR#RS< ~<~k1IPէgRЧԮ@VP+.< ~<<~k*RԮ1 PTXRT1 ScRTQAbP`PѠZ1 ARb1 ծ1 УPPP

PPϼPנzP*bϥPנTo~ň<~k)Ż< ~<~kgPԮ3PРPX
TTPXT4PT1"ЬVYRBfPS YSPxPPPBfSQxRTQTPRR TTn1R   | ^'SVRբ1aѢ	Ѣ1RϦRբ1EѢ
V !TχRT1%TPt\@\lP2
\\   2
\\   \   1 T~Ho  <M~o   PѠ\\T1 P߭߭TRB \lDPUc\֬\Bl\UlPB\\\B߹\B\Эl߫\B\Эlߝ\B\lC  ߊ\B\l|\s\TPTb\T1TRբGբBV! ψPT *PTT(+RT #PR
Rۼ
RRբբ)RТRRR

RR P  P ^RQ 1 СPP } } } } } } _ } iP?Pό\լ
Rv\Ь ϳ ZPQ/]\QR!PL\լ  &R V ^%R\  = P4\H~m  P<                                                                                                                                                                                                                                                   `                        \qF $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                     "     |       ~qm  \Ԭ | ^$Tﶻ\ЬUV϶\լ1 Ĉ~l  Ġ<M~m  |~|~|~ ݥ
~	4  PS1(2\\   Q\SUS1VRD\R1 PRP0\@\lS5  R\R1 P~l  <l~}l  \ЬRRPP 1 1 1 1 1 1 9 I I I I 9 I A A A 9 9 I )?PR\@P\8P\0P\(PRĴ< ~k  <~k  \U_Rݢ\ݥ
~PSS )< ~Hk  @<w~k  SCVRRϟn  $ 9o   ~ &o  QP R	RP	Q{RPQPQSQP RRRPRQPQ{RPPQxQ\C̸\CŸQﵸP RRPQP{RPQPQSQP RRRPRQPQ{RPPQxQ\Cp\Ci< ^\  3 (\\τm  $ n   ~ n  QP \
\P
Q{\PQPQRQطP \\\P\QPQ{\PPQxQ\Bﰷ\B勺QP RRPQP{RPQPQ\QxP RRRPRQPQ{RPPQxQRLTRLM<ŷ ^ R  P8\լìPP\լԬϻ\Эϱ\ЬS.P 1l  `s< ~h  <~i  SSP ^Y'R߭ݬݬݬ
PSR2Pѭ=¬ ~Dh   ~h  Pta|~N   SPP ^&Rݬ>  PS)￶P~g  (~Hh  SP ^'Sլð R~Hk  P?=k  Pð ð ð "k  PRݲð Ak  ð 'ø  < ~;g   ~g  Pð ì V k  Pì 'ø < ~f  8~Xg  P߭ <~ì j  R:Pì ݬݬݬݬQŏD   RP@a    RRGլ
ݬ<  ԬP^&VԮ|ZY|WЬRТ@nݬI'  P'|Ɗ~$f  ư<~f  1ݬ3  PZ)|~e  <~Zf  1IPxRx PݬݬݮZ|~R~	-  PX'|8~e  P<~ f  1ԮZݬu7  PY@YX.  2PRR)|ƀ~Be  ƨ<'~e  1PYXE  2PRR)|~e  <2~ne  1]P.  P[)|(~d  P<7~6e  1%P[	  PW&|ƀ~d  Ơ<<~d  1 [XW	  2PRR'|~Td  <C~d  1 nl2 ~Sh  Pjh^(ln=h  P|(~ d  H<K~ld  h ЧRݢbݬg  P)|x< ~c  ư<Q~)d  PrRgRpW	Wu
  X	X09  Z	Z/8  Y	YJ8  ծ
ݮ7  [	[7              < ^=(R}}螢XբTТTT|PЏ US|~ <f~|~ ݏ	 
  ߢTxP\\\  ST2SU ݢTf  ТT\( 﫯ТT\̀練ТTTTPP| ^UTV ;Se<ŏ`  SQdPA\P`RbPb~)f  PSVSSeVRRP        (^'RЬS}b蟭Xx蟭De  ߭߭؟ߢ5e  ݭge  Pc
~Xe  PQQPP (^'S}pc䟭蟭Xx蟭d  ߭߭ܟߣd  ݭd  ЬRPb
~d  PQQP   ^ݬݬݬd  PQQP   ^&RެSЬP@bd  Sݬ~d  od      ^ݬd  PЬݬd  PЬ쟭蟭c  PQQP ^ݬd  PSPPgd  PRݬR2d  RPP ^ |R߭߬߭߭c  PRRPP                 @          A           B                                          %                               | x^'Vͼ(<̀̈́>~͈͔͐>|͔ͼ͜>zͨ͠>xͬ<~ ac  ( Sc  |~ П̀ i~ 	Ib  PSS+< ~^  Hr~Z_  S1b  T1 SS,~< ~^   x~&_  Sa  TvˏͼRR	PR b  PRˏͼRRR[b  PR<~ݬb  TTPP| d^S&V}͸&ͼ}Ͱ@ʹ}ͨBͬ(<lp>jtͼ|>h̀Э͈>f͔͌>d͘PT10ЬSRRa  ЬSR8a  ( ya  |~ l i~ 	v`  PSS0S< ~]  ƚ~}]  ST`  T1 PSS,< ~\  ~E]  S`  TWЬR J|~ͨͰ͸_  PSS/L< ~\  Ɯ~\  S_  TPTTP δ^$V(0QޞͼЬʹޞ͸< ~ =`  <  ~ +`  |~ ݬޟ i~ 	!_  PSS/< ~[  <;~/\  S_  W1 SS8S )N< ~[  Ɛ<C~[  S^  WVP 9_  US TURUCBd"_  CRRRSRUU G_  UWWP ^A#RS߭;^  P
^  SS\\P ^
'R^  PS&³ < ~Z   ~[  TP S^  cЬSTTP^&UЬRݢ/  Ԣ^^  P(< ~@Z  4<~Z  Y1PЬRԲլ(h~
Z  ň<~yZ  Y1 PмRТVЬTd  PRݤ
  2RRPRVRWW
  2PXФSXRWRФRݢ]  P'ż< ~Y  <~Y  YbPЬSгЭR֭0bWX߭  c߭  ݣ߭^  RVЬSЭQ֭г PB`aRRVYYP ^ЬRݢ-  ݢ-  R\  P ^%SԼЬV\  PT(< ~X  4<~Y  W1P T\  d?V߭C  PUUFh~[X  Ð<~X  TRݢ,  ݢ,  R	\  W1AURRVVRRV?V߭<  Pd2PPG~W  <~PX  TRݢe,  ݢ[,  R[  W1 dL~W  @<~X  TRݢ,  ݢ,  RG[  
W|P?V߭7  PGx~8W  Ø<~W  TRݢ+  ݢ+  RZ  WPìíV~ݭ  PTWWP   ^&WЬRݢ  PѮ$ǫ ~V   ~W  [1ЮRR   STPR   SDPR   S4PR   S$P{~=V  Ǧ<'~V  S2Snn& ~V  ~|V  [1 PnYYЬR2PP       T 1'P?PЬRݢ
3	  UePTݢePSݢePR2TQ2SPPQ2RPPQYQZ1ЬRݢ  PVݢ  PUТSSPʏ PT.PSPʏ PTSPʏ PTTTRxRRR PRPSPPTTPPX2VR2UPPR2XPPRYRZЬRݢ
  2PSS&A~T  ^~<U  [1PSZЬRТU'ǐ~T  ǰ<]~U  V1 PХRR   STPR   SDPR   S4PR   S$P{~1T  Ǧ<'~T  S2STT&~T   <c~oT  V
PTVVVRR$Ǒ~S  Ǯ~6T  [1RZ/PЬR2~~S   ~T  [1ZRR   SUPR   SDPR   S4PR   S$P{~-S  Ǧ<'~S  S2SXX&3~R  F~lS  [1PV  P%y< ~R  ǜ~6S  [1ЬScRXPZPcRݢV  P 1< ~R  ~R  cIV  c[1gЬRв ЭS֭2Pʏ PPcޭTXUZVUdRdVbDdSdUP   PPcRU)PdQdRUPPxPPPPxPVPʏ PPaRRUЬR2PP       E 1 ?PЬRݢ
߭V  Scݢ߭cݢ߭c1 ЬRݢ
߭
  2PPP%4~bQ  H~Q  [1SЬRݢ@~߭_	  2PPP'|~Q  ǘ~Q  [1
PЬRݢ߭  ݢ߭  ݢC~߭  ;PЬR2~~P  <~!Q  b<%  b[1 ЭR֭0bޭSnTЮUT
cRcUbCcQcTP   PPaRT)PcQcRTPPxPPPPxPUPʏ PPaRRTЬRRݢ߭>  2PPPb$  b[P[[PP| ^TЬRU1 ݢPVVU1 2Q2PQPbbSS   RUPS   RDPS   R4PS   R$P{~aO  Ħ<'~O  R2RSS&@~3O  X<0~O  UPSPPVPUUP< ^Rլ'~N  °<]~XO  U1 PЬPРQQ   STPQ   SDPQ   S4PQ   S$P{~}N  ¦<'~N  S2STT&~ON   <c~N  UPTQЬPQUUPP ^)WRS2TެUT lХ T V2SQAf   RBPePްPA`PP @  R&PP    RPP   RPR2SPPPS2SPPdRPP   SRP   SDPP   S4PP   S$P{~IM  Ǧ<'~M  S2STT&4~M  H<~M  SPTPRPPSSPP ЬQQPʏ PR.PQPʏ PRQPʏ PRRRPxPPP QPQPPRRPPQQPP ЬQxQP PPPP   G1 xPʏ PRxPʏ PRRRPxPPPPxPPP\RXxQPʏ PP   R!PxQPʏ PP   RPRRPxPPPPxPPPRRRPPQQPP ^RЬPP   STPP   SDPP   S4PP   S$P{~aK  ¦<'~K  SSPP< ѬЬP`Q`aPެRв Sֲ ެUeP   PPcTe.Х Sв Qֲ                                                                                                                                                                                                                                                    a                        ܘL $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                    Ia "            TSPPxPPPPxPPʏ PPaTTS^VЬSX1լX1PcRR   SUPR   SDPR   S4PR   S$P{~eJ  Ʀ<'~J  S2SWW&~7J  <U~J  X1BЬP`R`0bPSWTмUT
cRcUbFPcQcTP   PPaRT)PcQcRTPPxPPPPxPUPʏ PPaRRTЬRݢݬ  2PPP&$~I  8<]~I  X1ЬR2
RR18RPPY 1 
q 	j?PP@   1P@        1 P>?PЬPݠ2
~ݬO  1ЬPݠ2
~ݬ  1 ЬPݠ2
~ݬK  2PPP1 l~H  ƀ<t~!I  X1 P1 ЬPݠ2
~ݬ   2PPP{ƴ~hH  <~H  XtPRPЬSЬR2
PcRcʏ PPbcRcb,ЬR2
~~H  *<~}H  XЬP֠PЬRݢݬPXXPP^VЬRТSS   RTPS   RDPS   R4PS   R$P{~uG  Ʀ<'~G  R2RXX&]~GG  t<~G  Y1 ЬRbSbˏ PPcRTXUЬRТWUdRdWbEPdPdUR   RR`SU)PdQdSUPPxPPPPxPWPʏ PPaSSURެTdSR S  PcQcB aRRYYP^YSެUյ SR meT   W2RQAg   SBPePްPA`PP @  S&PP    SPP   SPS2RPPPR2RPPdSVV   RRV   RDPV   R4PV   R$P{~E  ɦ<'~F  R2RXX&ɧ~{E  ɶ<~E  [1ЬRbTbˏ PPdRUXVSWV
eReWbFPeTeVR   RRdSV)PeReSVPPxPPPPxPWPʏ PPbSSVЬUe1eЬRbSb(PPcЬRbTbХR(bSSSdX2RެZR 1  W2XRB   ЬP`S`jPްPB`c1PjSBVV @  7ЬTdQdxBPʏ   Pȏ   PPadQdˏBPPa1cV    SЬUeTexBPʏ  Pȏ   PPdeTexBPʏ   Pȏ   PPdeQeˏBPPa1V   sЬUeTexBPʏ Pȏ   PPdeTexBPʏ  Pȏ   PPdeTexBPʏ   Pȏ   PPdeQeˏBPPa1 PЬUeTexBPʏPȏ   PPdeTexBPʏ Pȏ   PPdeTexBPʏ  Pȏ   PPdeTexBPʏ   Pȏ   PPdeQeˏBPPa2XPPPX2XPPg1[[P ЬSSRʏ RW.PSRʏ RWSRʏ RWWWRxRRR SRSRRWЬRbSbˏ PPcRUQWVQ
eReVbCeTeQR   RRdSQ)PeReSQPPxPPPPxPVPʏ PPbSSQWHެSг Rֳ bTWkWUPг Rֳ TUQxQQʏ QQ PQPPPbTTW8SW2 TWUdRdSUQxQQʏ QQ PQPPPbSSWشRRPP ЬSxSP PPRR   G1 xPʏ PWxPʏ PWWWRxRRRRxRPP\WXxSPʏ PP   W!PxSPʏ PP   WPWWRxRRRRxRPPWWЬRbSbˏ PPcRTUWVU
dRdVbCdSdUP   PPcRU)PdQdRUPPxPPPPxPVPʏ PPaRRUSW1   RWTbQbSTPxPPʏ PPPxPPPaSSWڴPP ЬRbQbˏ PPabPb` < ^RѬ   &ݬ³ ~?   ~@  U1 C  PT&< ~v?  8~?  UjPdѬЬSPSSLC  Pd/l< ~/?  ~?  T  UPݬݬdB  ЬTUUP  ^ЬPݠ`PQQP< ^TѬ   *ݬ~>  <8~?  U1 PB  PR&< ~z>  8<=~>  UzPԢxPPPSPSSLB  P.l< ~.>  Đ<E~>  R  U%PެSPc Q@a@PPcЬbRUUP ^Sլ'< ~=  <k~3>  T1PP& < ~=  D<o~>  T1A  PR&x< ~f=  Ð<s~=  T1l RwA  լݬ5  PP
  Pբ%< ~=  <~q=  T1ݢPЬQ
QQ1 QPPV    n 
P?PP@   1 P@   \    \ p?PмݢP1 PмݢPsPЬݢ%P[PЬݢ%PCP:PЬP~ < ~<  D<~t<  R  TPRTTP ^Sլ'x< ~;  à<~+<  T1P?  PR&< ~;  <~;  T1 R?  լݬݬ3  PPݬ  Pբ%,< ~);  \<~;  T1ݢP
Ѭ1 ЬPPx     ?PP@   1 P@    8 8 8  ?PP   1 P   p p p p?PмݢP1 PмݢPkPЬݢ-PSPЬݢ-P;P2PݬÐ< ~:  ü<@~:  R  TRTTP ^Sլ'< ~9  <b~;:  T1 P=  PR&P< ~9  p<g~:  T{P R=  լݬݬ1  PPݬ  Pբ%ä< ~99  <s~9  TݢP
RTTPP ^S<  PR&< ~8  (<~F9  T1ЬݢP
ԢԢbѬ1 ЬPPW    o P?PP@   1 P@   \    \ p?PЬݢQP1 PЬݢPkPЬݢPSPЬݢP;P2Pݬ\~7  À<~F8  R  TRTTP ^S&;  PR&ô< ~7  <>~7  T1 Ԣb|
|ЬPP       , 1 Pr?PЬ
ЬЬ1 Pլ/~7  ,<f~7  R  T1 Pլ/`~6  È<l~P7  R  TRPЬ
ЬЬЬ Ь$1ݬü~6  <z~7  R5  TRTTP ^eRլ'	~P6  <	<~6  S/PЬPՠ"ЬЬ"SЬPР"QЬЬ"SSP< ^
T9  PR&p	< ~5  Ę	<~J6  U{Pbݬ9  PѢТSSS9  Pb/	< ~5  	<~5  R
  UPPբ Q@a@ PPRUUPP| ^=
S;9  PU&,
< ~5  T
<~5  V1#eԥݬ19  PPRRRTTT8  Pe/È
< ~4  ô
<~35  UN	  V1 TЬR2TPP(1 R1 bP1 ߭
R8  PUV1 2TP@  R7  PRJbPP -8  Qʏ P@aPP,bP'R#bPP 8  Qʏ P@aPPbP2TPPPT2TPP(RbP1e2TUVVPP| ^T7  PU&
< ~3  <@~"4  V1:ԥݬ7  PPxPPPݬ7  PPxPRRRl7  P.H< ~N3  h<H~3  U7  V1 SЬRS(1 R1 bP1 ߭ĜR6  P1 PЭC R6  PRMbPP 6  Qʏ P@aPP/bP*PR#bPP 6  Qʏ P@aPPbPSS(!RbP߭ĜR
6  P1uSeUVVPP< ^U
TլU1 PG6  PR.ğ< ~*2  <t~2  R  U1 bԢЬP`ՠRUnxPPPSSS5  P&< ~1  <~.2  U'PPެSP У Q@@PPaмbRUUPP^u	VլX1 Pg5  PT.H< ~J1  t<~1  T  X1 dԤЬP`ՠTX1 xRRRSSS 5  P&ƨ< ~0  <~N1  X;PެWgRgPRP!gUЬQU   SURPB@RRSЬdTXXPP| ^Tլ' 
< ~k0   
<~0  V1PмUURR   'RT
~20  p
<~0  V1 U$Ĥ
~	0  
<~u0  V1 3  PS&
< ~/  <~B0  VoPURxR~3  P/L< ~/  p<~0  Sb3  V+PUQU RУPAAQQUUcSVVPP ^ATլ'Ĥ~,/  <~/  W1PмVVRR   'R~.   <~^/  W1 V'T~.  Ā<~4/  W1 P2  PS&Ĵ< ~.  <~.  W{PVRxRRRRUPUUd2  P.< ~F.  4<~.  S
2  W&QVЬRУPAAQQVVcSWWPP ^S|Uլ%h~-  Ô<<~F.  WfPЬT[PTW   PR.< ~-  <C~
.  V  W!VRVURURRUФTVWWP| ^QUլ'0~<-  X<r~-  V1PЬT1  PS&Ō< ~-  Ű<x~n-  V1dc

ԣԣݤjP0< ~,  <~ -  S  V11P2
QQ1 QPPI    Q 	?PP@   1 P@   p    p 1 Pr?PФ1 Ф1 ݤP1 D< ~
,  x<~y,  S   V1 P1 ФRݢbPjŬ< ~+  <~.,  S   V@:P6P2
~< ~+  8<~+  S[   VPSVVP   ^ЬP`	`(/  ݬ/    ^ЬPՠ
ݠ/  ݬ.  P ^ЬP1 РRբ
ݢ.  R.  ЬR2
RR1 RPP] } 9 	b?PP@   cP@   ; [ [ [ ; OP:?PЬRТS:գ
ݣ_.  SV.   ЬRТSc	c=.  S4.  ݬ*.   ^ЬP1 `Rb	b.  R-  ЬP2RR   >Р
Rբ
ݢ-  R-  ЬRТSc	c-  S-  ЬRТT1ФS"УRݢ(   RSTݬk-  P ^ЬPAРT1ФS"УRݢRDS;T2ݬ(   ^UTЬRТR	bբ%ĳ ~
)   ~                                                                                                                                                                                                                                                   b                        ! $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                     "            w)  X1kPЬRвТRV&,  PS'< ~(  0~0)  X1$Pc|ԣ|ޭQVUaRabWaU)ĸ< ~}(  <~(  U1 P2WRR1 RPP~  ~ ~ ~ 
P?PP0kP0_ g g g g g g g g g g g g g g g _ _ _ _ _ P?PP   'P        P?PWU*P2WRRR '  4<~$(  UUW2WPP.d~'  x~'  S'X1PWV߭\  PRR,Ĭ~='  ~'  SX1RPPV.~'  ~t'  SX1_P2WPP       1`?P?V߭
  P
2PP,@~&  X~'  S9X1?V߭
  P2PP,Đ~M&  Ĩ~&  SX1?V߭I
  P2PP1~%  ~k&  SX1V1V߭  P
.(~%  @~(&  S[X1P?V߭A  P/t~x%  Č~%  SX1P?V߭q  P2PP,~)%  ~%  SX1?V߭%  P2PP,~$  (~J%  S}X15?V߭	  P2PP`\~$  t~$  S1X1 2P2W~Ĩ~^$  < ~$  SX1 ?V߭y  P,~$  <	~$  SXqѭVhPV߭d   PR/P~#  d<~@$  SsX,P֣գRR"PУ"PRR"ѭVSXXPP< ^S?ݬݬ  P'Ø~P#  <9~#  T1P7'  PR&< ~#  <>~#  T1ԢԢԢЬP`UݬP  P.@~"  \<O~?#  RT1dЬQUaPPaPPU`QQ1QPP < F?PP@   1P@      1P?P
ݬݬ<  P2
PP1Ð~"  ø<f~"  RT1P1m
ݬݬ	  P2
PP1H~!  <q~1"  RT1VP1
ݬݬK  P1 H~w!  p<z~!  RJT11 
ݬݬ   P1 ä~,!  <~!  RT1 P~P
ݬݬd
  2PPP` ~   <~I!  RTo2P2
~P~   |<~!  R|T;ЬQUaPPa&ð< ~j   <~   TPRTTP< ^iSЬRЬQbPb`TbQ'ø< ~   <~   R1 2TQQ1 QPP~  ~ ~ ~ 
P?PP0kP0_ g g g g g g g g g g g g g g g _ _ _ _ _ Pf?PP   'P        P>?PTR*P2TPPP X  4<~  RЬPR`2RPP&	~#  (	<~  U1 Pݬݬ
  PRR'\	~  À	<~P  U1 PRݼPT'ô	~  	<~  UKRQR P`QQRѼ(
< ~d  ,
<~  UTUUP^a
XЬTЬSdRdbUdS'ȸ< ~  <~  T1 2URR1 RPP~  ~ ~ ~ 
P?PP0kP0_ g g g g g g g g g g g g g g g _ _ _ _ _ P^?PP   'P        P6?PUT*P2URRR P  4<~  TTS2SPP&`
~  x
<~  Z1P2SRR(RȬ
~  
<~[  Z1Pݬݬ
  PYY'~  $<~  Z1PY   'YX~~  Ȁ<~  Z1`g   PU&ȴ< ~J  <"~  Z1,ԥY	eUZ1YRxR~   P/< ~   <3~k  UZ1 ެTд RbRQRP(RRPQP{RPQPQд Sִ ХRcS(bPPSeХRԢVYWVWIPХSeQxAcRд P`PʏPRPAcд Pִ `PPeYPVPeP@VVWѼ/T< ~+  t<L~  UZPUZZP ^!UЬTЬSdRdbVdS'Ÿ< ~  <~?  S1 2VRR1 RPP~  ~ ~ ~ 
P^?PP0kP0_ g g g g g g g g g g g g g g g _ _ _ _ _ P?PP   'P        P?PVS*P2VRRR   4<~|  SЬRSb2SPP&Ũ~  <~G  W1 Pݬݬ  PVV'
~   
<~  W1 PVV6޼R P,VT
~_  ŀ
<~  WjPެRв ScPS V|SVPв Pֲ xTQ`PQPTSSVѼ(Ÿ
< ~  
<	~d  WTWWP^UWЬQЬSaRabTaS)Ÿ< ~  <~  S1 P2TRR1 RPP~  ~ ~ ~ 
P.?PP0kP0_ g g g g g g g g g g g g g g g _ _ _ _ _ P?PP   'P        P?PTS*P2TRRR   4<~L  SЬRSb2SPP&~  0<$~  X1 Pݬݬ  PVV'd~l  ŀ<)~  X1 PV+VŴ~>  <.~  X1 ެRв ScPPTTSVPв Pֲ xWQ`PQPWSSVVQQPxQPxPTPPWQQѼ+< ~  4<?~#  XPWXXP< ^SЬRЬQbPb`UbQ'ø< ~c  <~  T1 2UQQ1 QPP~  ~ ~ ~ 
P?PP0kP0_ g g g g g g g g g g g g g g g _ _ _ _ _ P?PP   'P        P?PUT*P2UPPP   4<~  TЬRTb2TPP*Ph~m  È<_~  bT1 ݬݬK  PRR'ü~,  <e~  TYPR$~  (<j~m  T.Ѽ%`< ~  À<o~A  TTTPP< ^ SЬRЬQbPb`UbQ'ø< ~  <~  T1 2UQQ1 QPP~  ~ ~ ~ 
P?PP0kP0_ g g g g g g g g g g g g g g g _ _ _ _ _ P?PP   'P        P?PUT*P2UPPP   4<~0  TЬRTb2TPP0*Pô~  <~  bTpݬݬo  PUU'~P  ,<~  T2PѼ%`< ~!  Ä<~  TUTTP ^!RЬQaPa`Ta&¸< ~  <~B  S1 2TQQ1 QPP~  ~ ~ ~ 
Pb?PP0kP0_ g g g g g g g g g g g g g g g _ _ _ _ _ P"?PP   'P        P?PTS*P2TPPP   4<~  SSP ^VЬScRcbTT   TW1 ˏTUUU'Uh~  ƌ<~  WT|SU RbPbxTQ`PQPTSSUѼ&< ~b  <~  WTWWP ^wUЬXhR RRa   1Rz   1 .X  PW
X3  XPWXTW*T   !RbDTW	T   ߔDT~DŰ RbV  VP~DŰ Sc  P)fPRcfRP~DŴ RbJ  T~DŰ P`~DŰ Rb*
C~;  7C<V~  V1PW  X  WRBPPBPP.WRBP  PT'lC~  ŐC<~0  V1PWRxR~  P/C~  C<~  T3V1PWdSWRSR1PP`RR01 PPx   	PX   NC  P1$D~  >D<~h  TV1CP1 C  P1 tD~  ŐD<~  TYV1 1 R0OR9JC  PjD~[  D<~  TV1 :PPP`~E~  @E<~  TVgPP`QQ.P?PQ8PP`~sE~
  ŜE<~7  TvVPSWPSP1RTVVPP ^Sݬ:PRT<Ѳ2ݲE~\
  E<~
  RTPRTTP| ^iSެTִ ִ ԼVд RbRR.1 R1 P  Rд P`Pʏ P@bPP'ݼ*F~  HF<~=
  Up߭|Fݴ C  P&ÀF~  ßF<%~
  U6PЬRxbQˏPQPbִ VVд P`PP.P1NUUP| ^}TԼVެSг RbRR.1 R1 г P`PP0г P`PP7(ݼF~  F<A~^  Uz߭,Gݳ c  P&0G~  QG<K~#  U?PЬRxbQˏPQPbֳ 2VPPPV2VPPг P`PP.P1IUUPP| ^
TԼVެSг RbRR.1 R1 г P`PP0г P`PP9(ݼĄG~  ĦG<h~r  Uz߭Gݳ w  P&G~
  H<r~7  U?PЬR
bQˏPQPbֳ 2VPPPV2VPPг P`PP.P1IUUPP ^	RЬP	`ՠ&8H~C
  XH<~
  SHPЬQ2a~ݡݬ8   2PPP$H~	  °H<~i
  SSSPP^	XRެWRgQ U  TM
  SBeH
  RPPTݬcHݬc
ݬcRRTZYV~FȰ Rb1    W~Fȴ RbTgSUPRPRP2UPPPUQPQP2URN~Fȴ S޳ SBcPP.PB PP.-P)R%~Fȴ Pް PB`PP.PB PP.PRY~Fȴ Sc  RPVZRYV~FȰ Rb1PZy~JȰ Rbݬz  US~Jȴ R޲ RCbR~Jȴ VЦ TCdPP.USCdPURެVRf)ЬTBdH?  ݬ  RRf۰SSP RЬQ֬ЬP֬aQ`PQP$P2RPPPRЬQ֬ЬP֬aQ`PQP߰RPPެXެWѸ  и Sз SSЬSPTPS&T"hVЦRgU   Q@a@bTPPSTTѼѼüTTPP^WZZ   )ZH~@  
I<7~  Y1 P'  PU&@I< ~
  [I<<~                                                                                                                                                                                                                                                   c                        . $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                    p             v  Y1 xZ~
  P/ǎI< ~  ǭI<B~?  U
  YZPTVެXT   RVQVTPT@ATbSެTS   RVQVSPS@ASbZeUYYPެXެWѸ  и Vз VQV5hZЪUgYЩTAeAdЬPްRЬPްPA`AbS
QQVSSPPެXެWѸ  и Vз VQV5hZЪTgYЩSAdAcЬPްRЬPްPA`AbU+QQV޼S޼RcbUPcbUPUUP   ^NR´ 	  ЬЬ   ^]NSUVެYiRU1 ЬX  WЩ Tz  UP{XPQPPiRѢ gE ~ gѤiRz  P{PQPP?z  VP{PQPP gz  VP{PQPP gz  VP{PQPP gz  VP{XPQPPVVUU1_   
   ^{RWtMSЬP	V1 Pݠ2PPP1  ~  <U T'1  P"  P@PP
=PPgP,]~TO  PRRPTRRUV1WP,)  ЬP2
QQ1QPPZ Z~ 
P?PP@   1lP@   H    01WP?PЬPݠ4  1PЬPݠ8  1PЬPаQ~~~a~<~  1PЬPݠV2PPP1 L~  <*UxT'  P  P@PP
=PPgP,]~T  PRRPTRRU,V1 Pì  1 PЬRݢ   P1 ݢ1 ð  1 PЬP2
~ö~  <SUT'  P  P@PP
>PPgP-]~T  PRRPTRRUPVЬPݠPVVPP^QJURެTdSRd  X  WBgPʏ P@hPʏhPд PB`PP 
P
P
dQB PPRP	V1 PRdPRSެRbPSdPв PC`PP 
( 8 8 8 8 8 8 8 8 8 ( 8 8 ( P?P
  V,в PC`~  SbPS  VVP ^MIRЬS]~ݬ  PQQSS     < ^IRެSSSP`TTSSP`UUp	 ﱞpT
TPPMP SUx%  xP ^HR'  P  P@PP
EPPYMP0]~ݬ  PSSPЬSSݬ ^HR   2PP ! 1 A Q UZ?P@e  ݬXV  ݬ~F  ݬ 6  ݬº&  ݬ                                                                                                                                                                                                                                                                                                                                                                                               @   @       L  X                                           @   p   P           H      
  H        8   H   /      8      (          `  	  	  	    
      	   
  0
       8    ,               x  X  H  P  @  H	  X	  	  	  8	  	             (              d  
                 @                                                                       UCX$ACCESS_SHR                                                 MTHRTL                                                         LIBRTL                                                         CMA$TIS_SHR                                                    DECC$SHR                                                                                                                                                                                                                                                                                                                                                    6 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SHR.EXE;1 +  , c
   .     / #   4         j                  - P    0   1    2   3      K  P   W   O     5   6 wt؛  7 !ju؛  8          9          G    H  J                          0 D `     0205        bvtX                                    	             	   
UCX$ESNMP_SHR                          UCX V4.2-21    Abvt؛ 05-13           8            E 8   
  :     }   
    $      +         UCX$IPC_SHR_001'      !        UCX$ACCESS_SHR_001       !        VAXCRTL_001 O    !       
MTHRTL_001      !        
LIBRTL_001$      +        CMA$TIS_SHR_001!      !         DECC$SHR_001  ^o  XVfRЬP`PhUЬTdPsR   jPdSS.UW1;PP>RBfU5  Qˏ SP@aPP
BfP0SSPBfUPW1 PTdP	R   U	R   W1 PЬS1 RcURTxTTTT~  PS*UTUS  PT S  Dc4P< ~D  P"Ȓ 5  ȡ <~P< ~B  SRЬPR5< ~  P  ~P< ~  WPЬWWP ^in  TެWgQa?PЬUFVSa/  RCVGU  LVU  PUSSbЬPP| ^n  UЬTդ
ݤ  ԤdЬSЬRcc~  Pc9գ4< ~  P N
  ]<~P< ~  VGЬPРSRެTdPR  PBRRQެTQdЬRAbQQdЬVVP ЬQЬPРPPaT@SRTRЬQЃaRRTRTP ^l  VլW1PЬRբ
ݢ  ԢbЬP	ՠ`螭ԽЭPԠЬRb螭вЭPԠЬP`РUx`SSS~O  PT*USUTA  PS T7  Cd4P< ~  P"ƒ   ơ <~P< ~  TRЬPR`ՠWPЬWWP  ^ЬPՠ
ݠ  ЬPԠ   ^k  SլԬЬRR~  PT0լRݬTu  PR Tk  ЬP@d4P< ~  P"Ò   á <~P< ~  TPP ^ЬSSЬRR   PQbcQQPP QռC   SQ T3cPްRЬPްPAbA`TAbA`T
QQTTPP Լլ>ѬT1 PP%ެRbS@c   Td޼Q@ @aPTQPЬRRԬRQPRQQ+ЬSAcRR   	Լ޼PRA`ԬQЬTTP< ^
j  TЬЬQQQЬUQRRR~  PS(URUS  R S  Bc4P< ~  P"Ē   ġ <~P< ~
  SQЬPQ`ՠPPЬPP< ^ЬTդЬP	ՠ`UiUcPЬRբЬP	ՠ`UBPU;PdbbSPdSSݢݤ  PUdbUPdbUUP| ^h  UЬRբ
ݢ  ԢbЬP`РV`SSS~t  PT'VSVTf  
S T_  Cd4P< ~  P"Œ   š <~P< ~  TRЬPR`ՠRPЬRRP  ^ЬPՠ
ݠ  ЬPԠ`| ^g  Sլլ:< ~*  P"    <~P< ~(  V1 PЬPѠ   RѬ
Ѭ   >< ~  P%ݬ0  T<~P< ~  V1 PЬRТTTT
߬ЬPݠݬ:  PU^PTެݢݬ:  PU9< ~@  P%ݢÉ.  ø<~P< ~;  UUVVP ^f  Rլլ:< ~  P"  <<~P< ~  T1PЬPՠ|ЬQСPPEaa% aaa  EaaE1D?PѼ:< ~f  P"DW  j<K~P< ~d  T1PݬЬPݠݬx9  PS1 PѼ   :< ~  P"   <S~P< ~  T1 PݬЬPݠݬ9  PS1 PЬP`	PP7< ~  P"  <[~P< ~  T>ݬЬPݠݬ8  PS"PݬЬPݠݬ8  PSPSSTTPP ^d  Rլլ:< ~  P"Q  p<~P< ~  SAPЬPՠ|ЬPѠݬЬPݠݬ8  PQPQQSSPP< ^1d  Sլլ:< ~z  P"æk  <~P< ~x  U1>PլԬЬQСPP   (          1 P?PѬ:< ~  P"   ,<~P< ~  U1 PЬЬ쟭ЬPݠݬ7  PT1 ݬ?ЬPݠݬ6  PTRբ
ݢ  Ԣb[PЬЬ쟭ЬPݠݬ6  PT6< ~<  P"h-  Ð<~P< ~:  TTUUP ^ЬPF`Rբ
ݢo  ԢbЬQˏ   P ѡ
Rբ
ݢ@  ԢbP ^Mb  SլP 8  P6< ~  P"w  <D~P< ~  T/ 5  PQЬPa`Rďd   RáPƏ'  PRPTTP LOCALHOST P μ^f  V(
ͼ @5   P	8  f   /ݬ&  PR	ЬRPRR]
  ~ ͽH  ~ͽ     PR>N  U1J2 ;
  Rͽ\;  ;Wͼ  PRݲ  Pb2N  U1 Ɣ ƌ   PRƘ 
N  U1 Pզ2 c  P ƿ b  PU1 ЬRЦbSզPSRBRbSST T  W  
PPd
W                                                                                                                                                                                                                                                                                                                                                                                                                                                                  d                        {< $      UCX042.B                       c
  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SHR.EXE;1                                                                                                        "     
         T	  PUfUUPP< ^d  Rb8<  ~  P" 
  <h~P<  ~  U1լѬ<=<  ~  P%ݬB
  f<n~P<  ~  U1`PTSբvPSP@P`QTUSTPЬPݠݡ  P;< ~_  P%ݼM
  <z~P< ~Z  U1 SSTuPP~ݢH  P:<  ~
  P"  <~P<  ~
  U1 PQPQPP@P`QQТTTSCPЬ`ТPCPЬ`ТPCPЬ`   PQТPCPQ`ТPCP`bT   PUUUPP^b  Td9<  ~%
  P"F  t<~P<  ~#
  X1ЬRRRP@P`P
ՠPQQQU	X1 P~	  P&eݬĬ  <~P~	  S S  ݥ  WgPRegPQRQRRRcPPQФPAP`
ФPAP`VݥVL  VgPPVeV7  Sn  PXXPP ^a  SWЬUWV~  P%Ve
  ,<7~P~  ХTRգ1RP@P`PՠTݠ  PRPRRPPQQT
QP@RbTTV{cvT T  ЬUݥ  PRRRd<<RRR<<RPP  <<Wݥ	  T>  PVVRRP ^i`  S~  P'ݬݼ	  ,<7~P~  ЬPРTRգ3PRP@P`PՠTݠ  PRPRRPPQQT
QP@RbTTPP ^_  SR R|  b<<\\\<<\\\  <<R,  PT5<  ~  P"b  Ì<l~P<  ~  TT\\PP< ^_  S~O  P$ݬ=  <~P~K  Rb<<PPP<<PPP  <<ЬЬTլݬT  PdTY  <bQPQPPbTE  PPT<bPP   ~TݬR0  PU[cR*  PTDR  PT5<  ~R  P"C  :<~P<  ~P  TTUUPP ^]  SգT{R R  b<<\\\<<\\\  <<	R6  ݣ  ݣ
  ԣcTTPP ^=]  RSբ5SP@P`Pՠݬݠ  PSPPSSP  \  \ЬPP \  QЬPPP@P`P
ՠPRRRPP   \  < ^\  R !  PUUI<  ~  P4   `  P  <`~P<  ~  U1 ~    PSRD  U  U1 ݳt  prT~  P&<r~	  <z~P~  TpU8  PT<  ~  P9   `  P<r~L  r<~~P<  ~  U  UUPP ^5[  VЬWRR((	P(蚏~K  PE~  <~~~~~P<g~ƨ  <~P~&   <g~ݬݦC  PG~  P3   `  P   <~P~  RRRPP< ^MZ  RЬU߭( < ~ݬݢ  PT]_  S c`#H c`@< ~B  P0 c`~  PV%  n<~P< ~2  S1 <ePPT<< ~   P'T<e~¨  <~P< ~   SV~   PE~  PQ<*~/~.~-~,~Q  .<
~P~   SSP   ^]~ݬ  PRЬRPRRf`  w  P  T`  QЬ  ȏ    ȏ 0  Ьd     `  QRլ
ҡdPPPRRPP ^_  R]~ݬ  PSSPЬSѬ   &Ѭ    8ݬݬSbd  /ݬݬSb~  ݬ  dЬ  P` d1`1 	b)  d~  Ph o  P¤ݢho  ´ݢh  PS 5  P  Pb¶S  S  ݢhb!)  `d+ ݢh  PSS  S  ;  P@PP
  P@(  ˏdP2   ^^  RެPP~ݬ  QQP ]  RQ~AP`'P~AP`~AP`SQ~AP`ܞP	SSPP ]  QЬP@pRRPP| ^]  Td19SPSҤdRRSRPPzЬSĈ	VĐ	VˏSĔ	USĘ	SĠ	SSUЬRbUVТRBpĀ	ݬݬc	İ	<~P~ЬUѥMSPSҤdRRSRPP1WЬRݢݢ	
<~P~1)ѥ1 SPSҤdRRSRPPjЬSУQR~BSc$~BP`Q
~BP`SPR~BP`ܞP	SSЬRݢݢH
l
<~P~
ЬRբ(1 SPSҤdRRSRPPsЬRݢ(ĸ
ݬݬĤ
Ĺ
<~P~?PSPSҤdRRSRPP!
b
<~P~pЬRТ$ScRSSR	   ТRP ^?[  Rd1LЬP1C`H$QdQQD/H:ݬݬ%;<~P~ЬPՠ<QdQQ<+vݬݬpw<~P~ЬQա1[СPP RS/SSSwSGG	?PP   1P   $ d   $1?PQdQQ41ЬPݠ¬½<~P~PQdQQ,1ЬPݠ<~P~PQdQQ$1ЬPݠ8NG<~P~\PQdQQ1^ЬPݠ|<~P~PQdQQ1ЬPݠ<~P~PQdQQ1ЬPݠ	

<~P~PQdQQ!O
X^
<~P~f~ЬPo  PQdQQ!
 
<"~P~~ЬP'  PQSQҢdPPQPSS1ЬQСPя   PTPTP   
S
SSݡT

<&~P~PQSQҢdPPQPSS!1?@<+~P~M~ЬPV  QSQҢdPPQPSS!v</~P~~ЬP  QSQҢdPPQPSS!µ<3~P~~ЬP  QSQҢdPPQPSS1ЬPHeP,<7~P~:QSQҢdPPQPSS11>X<:~P~QSQҢdPPQPSS1 ¬<=~P~QSQҢdPPQPSS1 `<@~P~nQSQҢdPPQPSSh1<<D~P~-QSQҢdPPQPSS(ЬPݠq<K~P~x^T  SЬV@TUTңdRRTRUU12<^~P~fx  fJTUTңdRRTRUU%x,<c~P~:xUYx  xRRPUYTެZT 1 XW  VT1 z  TP{PQPP1 eYFPQPңdRRPRQQcxNݬݬEhP<p~P~g:PPQPңdRRPRQQxÈhÌ<r~P~gYxUPTz  TP{PQPP D~U  U  PUTTf1eYMTVTңdRRTRVVrxݬݬ<~P~PTUTңdRRTRUU%xr<~P~P  ^ݬݬ"  ^d  SPR"  PRR|PRR0\Ѭ%< ~\  PRPPR*  R/< ~P H~P< ~R\\P^c  U~qP~cŒ ~P~rЬRRejѢdѢ
^ХRbRТPРP`Т(RХS"  TSRУ(Sݢ dRdSԥݥ+  ԥeԥЬRТPP,   ,X 1V?PЬRRPX~{P! l <~P~zݬ1PЬRRPX~'P!(<
~P~&ݬ13PЬS|S`PXeuXգS
CPXХRPbRТPРP`Т(RХS"  TSRУ(Sݢ dRdSԥݥ)  ԥeԥЬR~MP!`>t<!~P~Lݬ1YЬR|R
ψPX~P!Ŭ<,~P~ݬQ1PЬR|R0PXХRPbRТPРP`Т(RХS"  TSRУ(Sݢ dRdSԥݥ(  ԥeԥЬR~9P!*<9~P~8ݬ1EХRPbRТPРP`Т(RХS"U  TSRУ(Sݢ dRdSԥݥ'  ԥeԥЬRԢX1~PO޼Sc  pTcrS|SSTTݼHPŊ<E~P~^ЬVԦfT1oզ(9
߭ݦ(7  PЭScRR,
 SS  PԥЬRѢm   G<  ~P.ݢP<[~P<  ~W1PբG<  ~P.ݢPl"<_~P<  ~yW1PKե;PХPPRRRW1_ХPPR`R  եԥS SP17PSPRRRW1S SP1PT  1 TTyPTզe<  ~P>TdSŀSݦPSXfň<}~P<  ~sЬRݢTW1|~-PqTdSSS<~P~>Pզ7~P!(P<~P~W1 X1 P~P(ЬRݢņŰ<~P~ЬRԢX1 ~a                                                                                                                                                                                                                                                   e                        G $      UCX042.B                       c
  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SHR.EXE;1                                                                                                       em "            P!R<~P~`ЬRݢ(PPSݢS`PXPXЬRԢA< ~P)ЬRݢ4T<~P< ~WPXWWP^\  RЬP|` YР$U13V[yWX  ZPe0UPS~fP1 ~fP$eHkPg¤<~P~hS4~fPMHkPcg<~P~h$~fP0gJ<~P~hS8ЬPPSQ<PPʏPˏPP
PPPPգ0~fPg<~P~h ej1 S4УP`PT~fP$TYPg<~P~hTjTPP 7 c c c c S 	?PPP   CPP     5?P^P ejQ ejEЬPY6P<  ~fPT$gP<~P<  ~hЬPYЬPՠ
ХUYU1SSP^Y  SެоR|b |(ԮТ$W[Т$V1оnZ9Y"X nRѢоTR[R
ԮЦWФ,~jP'fHP[Æiâ<V~P~hVPU6~jPi<^~P~h f
  1*P~jP*fHݶPe,iV<d~P~hե1оPRUQ<RPʏPˏPP
RRR-T~jP1CÌiä<m~P~h1'Ѧ).~jP7i<s~P~hPоPѠ
PU4f0ХP`PR~jP$RwP	i<	<~~P~hR1 RPP 6      ?PPP   wPP   W W i?P!fLP0)~jP1 r	iÐ	<~P~hkP)bP^PЬP[T1
P<  ~P$R	o	<~P<  ~|ЬP[T1 PR1֮1оRѢ1 զ1 (1 ծ{~jP*
i^
<~P~h (VR   P;ТRЧЧЧ))!!gbWVЧWPЧWЦV[V1TTP|^U  VЬPP tttttt1_
?Pզզ^ЦScSУRТP`У(SЦT"  WTSФ(Tݣ gSgTԦݦ  ԦfԦЬRТ$Ԣ$~P!Ɣ
Ʈ
<~P~Ц[1  nެ  ZkYզ@,PS)< ~P<S~P< ~ SSUH,PS)< ~P<S~P< ~ S(SRU$Х(UU1< ~P

<#~P< ~ оR
ЮRв Y[PT~P1 TJ~Pqi͘PRHPRd*\<1~P~ 6P~P'i͘PƘ<7~P~ TA~P!<B~P~ЬRЮ1դC~P!Nv<H~P~ЬRЮ1yPѤQѤ	KѩE~RP$ݤƬ@<Q~P~NЬRЮ1 PTäiWA~P!
.
<[~P~ЬRЮ1 ФSCXЦR?բ 3ТQХPѡ$Т QѡWxW~XݡjP
Т  	PТ(RRp  P ?< ~_P"d
Pƀ
<q~P< ~]ЬR
5PХ RXХ RWХ RԢԵ ȏ   U ֮Ы[1ЬRբe~P$ݢƶ

<~P~ЦT#2  UTSФ(Tݣ eSeTԦW1TЦSPճ г Rȏ@   Գ TУ(S䚏~YP!"J<<~P~XUЦS12ЬcSУRТP`PT1 TPP T      p  |   d      X  ?PPP   1 PP      zPr?P1 ЬR1 ЬR1 ЬR1 ЬRzPЬR
nPЬRbPЬR
VPЬRJPЬR>P<  ~8P$Tt'Ơ<~P<  ~4ЬRTH~P,TP<~P~ЬRUW1UУ(S11P~P!4H<~P~UЦT1 1 ЬdTФRТP`P1 ~EP!ƀ6ư<~P~DЬRUЦSSTnPPcSФPРP`P<~P!<~P~ЬPUУ(SSTUФ(T1-1 P~P!Jz\<~P~ѦhTЦS_QЬcSУRТP`P<~/P!ƒ <~P~.ЬRTTУ(SWWP< ^UM  SЬT<dPP~V  PRU&<d~TE  bУPR`RRUUPP^ЬP`YԠ JPTST?SGPR)YPЬPРPѢЬPRSSTЬRբXjТSUУTUTJUTVVVP@RYPWЬPVRX+PWVT
PWVUUTWVЬRVXXPP< ^ЬQС)PP  S S s  wPV?PЬRRPS\PPѣb)SU1 ЬR)SU1 P2PЬPРQRޱSBcR)RUyPЬP֠PUgЬPРQѠЬR)UJPЬSУPRްPB`T!VP
)UPЬRbh)TUUP  (K  \QQPP ^K  TѬ1ЬPP  C g	"?PP   1P   $ 8 L ` t 1?PЬRм1PЬRм1PЬRм1PЬRм1kPЬRм1WPЬR
м1DЬRsPS1+1!ЬROPS11 ЬR+PS1 	1 ЬRPS1 1 ЬRPS1 1 ЬRPSxP
nPЬRkPSTPJPЬRЬ=< ~P%ݬ<V<~P< ~SPSSP        (^YZ  RЬS}b蟭Xx蟭  ߭߭؟ߢ  ݭ#  Pc
~  PQQPP (^Y  S}pc䟭蟭Xx蟭  ߭߭ܟߣ  ݭ  ЬRPb
~  PQQP    ^Y  RެSЬP@b~  SݬZ  g     ^[  Sլ3<  ~Pc
(~P<  ~THЬRbЬQaССԢ<bPP~ݡ$R   PTTP^լY1 UЬTVլ1 ެXUW2UPPh$ЬPQQ1 Q1 V1 UЬRbTiT̲  PSSTSUUUh~TR~PS%ЬPPPYcPЬPVCPSWUЬPQQ(Q#VSUSTЬPРVլ1/ЬR<bPUPPbYYP| ^IZ  SUѬ8< ~|P hnr<~P< ~|V1PЬQաЬP֬`Uѡ1СPP5q55555qqqP?PP   1PP   $ HHHH$ $ $ HHH$ 1-?PЬP֬`ЬP֬`UURR8< ~P"è ò <2~P< ~V1ЬR֬ЬQPʏ PPbЬR֬<Pʏ PPbЬR֬Pʏ PPbЬR֬ˏ PPbU1PЬP֬`ЬP֬`UURR8< ~P"  <D~P< ~V1WЬR֬ЬQ8Pʏ PPbЬR֬0Pʏ PPbЬR֬(Pʏ PPbЬR֬  Pʏ PPbЬR֬Pʏ PPbЬR֬<Pʏ PPbЬR֬Pʏ PPbЬR֬ˏ PPbU1PЬPРTЬR֬xTPʏ PPbЬR֬ˏ TPPbUTURR;< ~P"(2<_~P< ~V1"PTЬPݠݬ  TTU1 PЬPRURR:< ~:P"h+r<i~P< ~8V1 PЬPRR#R  PQЬR֬xQPʏ PPbЬR֬ˏ QPPbQQQUZPЬP֬`ЬP֬`UA< ~P)ЬPݠèz<~P< ~VPUVVP ^X  VԼYլ6<  ~2Pf%(~P<  ~4X1P,y  PR2< ~P"<~P< ~RU	X1PЬRPP;<  ~P$~`ƀ ~P<  ~X18<eХPP7 7 7 ]-]]- ]]]1:P?PТТT<bSìTPPSSWբ1 <WPѢP;<  ~P$ݢƸ  ~P<  ~X1ݢ:  P 8< ~P!8~P< ~X1@ݢ~ݥ   T<WP¢PPW<W~TUPY1 P1 	SSN  P(gТТT<bSìTPPSSP<PPFT  P(7<  ~P$ݥpƐ~P<  ~YY}US|գ 
ݣ )  У$THФR&ݢ  b~!8R  db!T۪  գ(
ݣ(̪  Sê  UYXXP^T  Uլ;< ~P"<~P< ~W1ZP[XѬ[1DqZb  YVS-6  PR2< ~P"P`<~P< ~RVW1ЬPՠ$V$VXЬP֬`ݬfjP1 < ~<P%ݬ *P<8~P< ~7VTjФSHУR&ݢ(  b!R\  cǻ!S@  d﫻!eT$  W1
PݬiPPݬ!jP1 < ~tP%ݬňbŸ<B~P< ~oVTjФSHУR&ݢ`  b!ձR  c!ﹱSx  d!T\  WFPݬiPPЬPѠ"[ݬf'PЬP	XPѬ[1WWP< ^9R  SRR9< ~iP"Z<j~P< ~gU1bPЬP֬ЬR`ЬP֬`PxPTЬP֬`PPTTRR9< ~P"Px<t~P< ~U1PЬQѡ1СPP;c;;;; ;	:?PP   1`P   $ XXXX$ $ $ XXX$                                                                                                                                                                                                                                                    f                        ZN
 $      UCX042.B                       c
  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SHR.EXE;1                                                                                                        "     ,       1=?PЬP֬ЬR`PxPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PP1,ЬP֬ЬR`Px8PЬP֬`Px0PPPЬP֬`Px(PPPЬP֬`Px PPPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PP1 ЬRTTݬDPU1 TvPЬRRЬPPU\Rǥ  PRPFPBP< ~P)ЬPݠð<~P< ~UPЬUUP ^ЬP1 ՠ 
ݠ ;  ЬPР$TjФSHУR&ݢ   b!@R  cj!$S  dN!TǤ  ЬRբ(
ݢ(  ݬ   ^N  R-  PS2< ~ P"P`<~P< ~S\\PP ^ЬP1 РTjФSHУR&ݢb!KR
  cu!/S  dY!Tң  ЬRb9!R     ^ݬ  PЬݬ  PЬ쟭蟭Т  PQQP ^ݬi  PSPPG  PRݬR  RPP ^ |R߭߬߭߭w  PRRPP  ^Q  R´   ЬЬ   ^Q  SUVެYiRU1 ЬXM  WЩ Tz  UP{XPQPPiRѢ gE ~ gѤiRz  P{PQPP?z  VP{PQPP gz  VP{PQPP gz  VP{PQPP gz  VP{XPQPPVVUU1_      ^/  WP  SЬP	V1 Pݠ  2PPP1  ~  <U T'  P  P@PP
=PPgP,]~T  PRRPTRRU0V1WP,  ЬP2
QQ1QPPZ Z~ 
P?PP@   1lP@   H    01WP?PЬPݠ4N  1PЬPݠ86  1PЬPаQ~~~a~<  1PЬPݠ&  2PPP1 L~  <*UxT'%  P  P@PP
=PPgP,]~T  PRRPTRRUV1 PìM  1 PЬRݢ   P1 ݢ1 ð  1 PЬP2
~ö~  <SUT'J  P;  P@PP
>PPgP-]~T  PRRPTRRUVЬPݠPVVPP^M  URެTdSRd  X  WBgPʏ P@hPʏhPд PB`PP 
P
P
dQB PPRP	V1 PRdPRSެRbPSdPв PC`PP 
( 8 8 8 8 8 8 8 8 8 ( 8 8 ( P?P  V,в PC`~  SbPSo  VVP ^}L  RЬS]~ݬb  PQQSS   B  < ^EL  RެSSSP`TTSSP`UUp	 IpT
TPP  P SUx͜  xP ^K  R'  P  P@PP
EPP
  P0]~ݬp  PSSPЬSSݬ ^IK  R   2PP ! 1 A Q UZ?P@  ݬX  ݬ~֛  ݬ ƛ  ݬº  ݬ   ^N  UЬXhR RRa   1Rz   1 .XM  PW
XÛ  XPWXTW*T   !RbDTW	T   ߔDT~DŰ RbVp  VP~DŰ Sc  P)fPRcfRP~DŴ Rb֚  T~DŰ P`~DŰ Rb*
C~k7C<V~V1PWW  Xw  WRBPPBPP.WRBP  PT'lC~ŐC<~`V1PWRxR~Q  P/C~C<~$T
  V1PWdSWRSR1PP`RR01 PPx   	PX   NC  P1$D~,>D<~T	  V1CP1 C  P1 tD~ŐD<~JTA	  V1 1 R0OR9JC  PjD~D<~T  V1 :PPP`~E~O@E<~T  VgPP`QQ.P?PQ8PP`~sE~ŜE<~gT^  VPSWPSP1RTVVPP ^J  Sݬ:PRT<Ѳ2ݲE~E<~R  TPRTTP| ^J  SެTִ ִ ԼVд RbRR.1 R1 PƗ  Rд P`Pʏ P@bPP'ݼ*F~HF<~mUp߭|Fݴ   P&ÀF~ßF<%~3U6PЬRxbQˏPQPbִ VVд P`PP.P1NUUP| ^I  TԼVެSг RbRR.1 R1 г P`PP0г P`PP7(ݼF~"F<A~Uz߭,Gݳ   P&0G~QG<K~SU?PЬRxbQˏPQPbֳ 2VPPPV2VPPг P`PP.P1IUUPP| ^H  TԼVެSг RbRR.1 R1 г P`PP0г P`PP9(ݼĄG~6ĦG<h~Uz߭Gݳ   P&G~H<r~gU?PЬR
bQˏPQPbֳ 2VPPPV2VPPг P`PP.P1IUUPP ^G  RЬP	`ՠ&8H~sXH<~SHPЬQ2a~ݡݬ8   2PPP$H~-°H<~SSSPP^EG  XRެWRgQ U  T  SBeH_  RPPTݬcHݬc
ݬcRRTZYV~FȰ Rb1    W~Fȴ RbTgSUPRPRP2UPPPUQPQP2URN~Fȴ S޳ SBcPP.PB PP.-P)R%~Fȴ Pް PB`PP.PB PP.PRY~Fȴ Sc  RPVZRYV~FȰ Rb1PZy~JȰ Rbݬ  US~Jȴ R޲ RCbR~Jȴ VЦ TCdPP.USCdPURެVRf)ЬTBdH  ݬv  RRf۰SSP RЬQ֬ЬP֬aQ`PQP$P2RPPPRЬQ֬ЬP֬aQ`PQP߰RPPެXެWѸ  и Sз SSЬSPTPS&T"hVЦRgU   Q@a@bTPPSTTѼѼüTTPP^D  WZZ   )ZH~p
I<7~Y1 Pӑ  PU&@I< ~:[I<<~Y1 xZ~  P/ǎI< ~ǭI<B~oUj  YZPTVެXT   RVQVTPT@ATbSެTS   RVQVSPS@ASbZeUYYPެXެWѸ  и Vз VQV5hZЪUgYЩTAeAdЬPްRЬPްPA`AbS
QQVSSPPެXެWѸ  и Vз VQV5hZЪTgYЩSAdAcЬPްRЬPްPA`AbU+QQV޼S޼RcbUPcbUPUUP    ^ЬP`	`  ݬ    ^ЬPՠ
ݠ  ݬ  P ^ЬP1 РRբ
ݢ  R  ЬR2
RR1 RPP] } 9 	b?PP@   cP@   ; [ [ [ ; OP:?PЬRТS:գ
ݣG  S>   ЬRТSc	c%  S  ݬ   ^ЬP1 `Rb	b  R  ЬP2RR   >Р
Rբ
ݢ  R  ЬRТSc	c  S  ЬRТT1ФS"УRݢ(   RSTݬS  P ^ЬPAРT1ФS"УRݢRDS;T2ݬ(                                                                                                                                                                                                                                                                                                    6|  < ~ 練 ʖ <  6 
 R<  ڨ     j   ﾞ| R ﺭ< : | V  b<   N 漣                                                                                                                                                                                                                                                                                0 Out of Memory
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3  %s%u . Out of memory
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 Out of memory
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 o_integer; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3   o_integer; value out of range; %lx
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 Cannot use o_integer for this object type; %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 o_octet; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3  o_octet; value too big for IpAddress
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3  o_octet; value too big for DisplayString
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 o_octet; Invalid first byte
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 o_oid; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3  o_string; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3    o_string; IpAddress does not have length 4
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3        o_string; Wrong data type for a string
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 gettimeofday returned failure
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3                                                                    eSNMP can't get Process ID.
  %s_%X eSNMP can't get master agent's address.
  esnmp   udp eSNMP well-known port is not defined.
 %s%d /tmp/esnmp_sub Trying to do                                                                                                                                                                                                                                                    g                        +6 $      UCX042.B                       c
  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SHR.EXE;1                                                                                                       \ "     =       registeration before calling esnmp_init().
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Timeout value %d is out of range.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Subtree '%s' already marked for registeration
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Malloc error
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Trying to send registeration when not opened
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3   Register (%d) subtree '%s'
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 UNREGISTER request, subtree='%s', reason=%d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Could not send the ARE_YOU_THERE message
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 TRAP: Someone is doing a trap; %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Could not send TRAP message
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3                 Could not open socket:%s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 eSNMP can't get subagent's host address.
 BInding Socket to port %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Could not bind port %d to socket: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Sending (len=%d), %s, to %d.%d.%d.%d, port %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3   Can't send: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 recvfrom returned: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3     Invalid packet length: %d, received %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Received %s from %d.%d.%d.%d, port %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3                                                                                                          0          @}  h}  p}  x}  |}  }  }  }  }  }  }  }  }  }  }  }  }      ???Message With Zero for action code??? GET     GETNEXT SET TRAP RESPONSE REGISTER UNREGISTER OPEN  CLOSE COMMIT UNDO   GETBULK TRAPV2 INFORM ARE_YOU_THERE     CLEANUP     %s **ERROR %s line %d: %s %s WARNING %s line %d: %s %s %s%d.log /tmp/esnmp_sub  w Starting trace file for %s esnmp: %s  Starting tracefile for %s esnmp: %s a %s %s %s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ă     ˃     ԃ       	     
               
   $     8     E     P     d     p  P     Q     e     f     g     h   Є  i     j      k     l   0  m   X  n   x  o     p     q   ƅ          noError tooBig noSuchName badValue readOnly genErr noAccess wrongType   wrongLength wrongEncoding wrongValue noCreation inconsistentValue   resourceUnavailable commitFailed undoFailed authorizationError  notWritable inconsistentName NoSuchInstance NoSuchObject DPI_otherError DPI_notFound  DPI_alreadyRegistered DPI_higherPriorityRegistered  DPI_mustOpenFirst DPI_notAuthorized DPI_viewSelectionNotSupported DPI_getBulkSelectionNotSupported        DPI_duplicateSubAgentIdentifier DPI_invalidDisplayString  DPI_characterSetSelectionNotSupported DPI_dataError DPI_resourceError Unknown error type %*.*s%s - %s%s, packet id=%d         ALONE,      V1  V2      Unknown Version DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3    , non-repeaters=%d, max-repetitions=%d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3    , error_index=%d, error_code=%d %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3    %*.*s  argument=%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 %*.*sVARBIND OID=%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 %*.*s  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Integer32 = %ld
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Counter32 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Gauge32 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 TimeTicks = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 UInteger32 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Counter64 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 OctetString =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 IpAddress =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3  DisplayString = "%.*s%s"
 ...too big  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 NsapAddress =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3  Opaque =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 BitString =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 ObjectId = "%s"
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3  Exception = noSuchObject
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3    Exception = noSuchInstance
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3  Exception = endOfMibView
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Null-type
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Invalid data type: 0x%X
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3  -nill-
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 (len=%d) 0x[   %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 %*.*s%s
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3    %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 %02x %*.*s%s]
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 %s]
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3                                        esnmp_poll: Could not process a packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Incoming Packet
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3         dispatch - RESPONSE, packet_id=%d %s
   from OPEN from REGISTER DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 RESPONSE to OPEN: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 RESPONSE to OPEN: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 RESPONSE to REGISTRATION of '%s': %s
   Unknown DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     RESPONSE to REGISTRATION of '%s': OK
 Unknown DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Bad response to ARE-YOU-THERE, restart
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 DPI CLOSE received from agent, reason=%d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   dispatch UNREGISTER
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Unexpected DPI packet type %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        requested oid:%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        object id:%d, dots:%s    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        no object found,   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Not a readable object
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3  Method Routine returns: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Method routine returned invalid status: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     %2d requested oid: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        no more objects found
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        try obj id:%-3d %s (subtree '%s')  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Not a readable object
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 (as a GET)  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3    Method Routine re                                                                                                                                                                                                                                                   h                        W $      UCX042.B                       c
  P  9[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SERVER.EXE;1                                                                                                    ; 4            <.kF3\mlBq%	 9Y:$¤l4-5R)O!r A"\֠K
֞櫀pi	l%{nl˧h0W9ﰖW<cX|y
h[vdMd%!irwe
`soG5J2,i%șM
s!BR}+&ԭse':+Y)fE`D2*ݎ@a2MtL/<8E]LHa٣xu'o$0mfT\.l5eWЁ~8
xeZPlq'rJu裶hknS3N@~f&gߠsRοG淣fP/ȼ{Q9X5@$	ף	MZb^iD0U:
6hl,ވjz;K2H Ulk/b}4f3NGg4tŃ7ob8W[5Q2fBj-62YhȭF7IJZu!0YA$jMp,WkfBu0I9n>qRBDM*i B@!k
`p"!|e\2H2FLEZPAs㔵IW0Ťw$g~[囲s+/_%]VU:흝'SbM#lDy@U'ǮE`7^ݭ
rky#ОfrlY9B9gZ{e:k}XtЩA.˼FY5/C-owY9OB~
7,kbı-ցc&՛7}Mm,ʦ>aHcD	
?HƨMat?hѲϰ˛gE+j,֬$->e,QEU)p<	
҉^9``/Gtn+YP^@YZrh7ܴ)%y#h<o2ΗBIkɝ) W=g4qKF-܁s_}-Ng]?@ډԣT[\Ѡh*E>/(r!^{s~8
eg'}[J5ݩ0CYpBd*n:'lԱ&Vy ?5C
Z~<ԁObr];)W{Cl᫜)0_9@n<Q|[vc[-D|\pݵ3;FuN2|cz(t{iۗl!enJoc1#,E_t6?r]tбx]dv5uf8J=\3Cڣd^lf?ސ̾dAQ(i
>,AG<1˾]ғ{n}]0rA 
*SKX}U_o_6O!Z%`vP\7g}EF!*@l#	n!xY-3_@
=

Obt	b
<`VIJ[L#uÛ~eB:Ø scuR(+F&"p
ޕmf4ì W{ͣ^f)piL|!;$y,f|+P!)k#҄=Gfp ghLP	RHNNqܘ jƥ+AΠU%`~k~w#JOFpaRo-`yJb3ǩ,3X+TAomxG)B?Qfٚb!ܾ`AQW[
e%YWYdKf%h0[ޮSX^^(yk(/nXr)k!@w
a8&5@%6rZI\Gx4Is[Yb	{_K1R*o}hSgIߢSL4
,Xi;*ut0{SWB\r2SH{/?/XGX"Hj]`R\~=jfG4\?6rlT.^W~orӪ:ɰS̓+V<yC*
{{1&Ja:;.Iehy틆bKCLX/$2ny$TW
jRnSurWh4<qP qڛ$SR|H~-nIvY\H2їS9|CJno	/XJ<+(
d|y*BE@3z͸[u-] .Z$Q_T$[rTS ,RDhZp<ʲ<}y,JђuL&Ghm}Y=aCI.EӃbH2F4k?%xk{iyNQ^3?e䎶ffg!W3)E,$bhwB4cB?z5k:(qbWY@t$c'A9	"SPOG=T쎤/F<`^?feH\qw.$W;ln
V*Rɺ)QLg]i?b&qZREr`EUJy:;9 C1iU]gݨ5WTZ^K5Z@|J9d046=MxesWM;Ks?NV434n\d&$#|WnHr	rg6\ԭ_)?CmNJQr@`	֮|AD7h^B 
PO}.cO]F+,I5 FskB\Gzے..gKkr7`/3*z.n(∟hf|(7}*!>$*AV24GNۡ
gL}y|%ց*-ZQ[.|KĢ>F%R4OKUy2H"kw8[|i@Y]Juʞ\_5?]\Nhq ęo*/ʷo6io_1-W/^6Pݞ)!1_ݖR8R\V@uS3$pMoEk*oL3Kڌ[E^э*#{U 7S\n9jH6ouLH宍r)t9/+E{ӾJluW؄F6L)qK 	oYyN˃uVKy;
9
[F5즹őO:tKgU.(K$MO/cq8]rt$HQ$@ZAkT_Q}11H/'FHpO|\Qf1Hx$ܗ;,98y U;
'AUF0xIScȜ,Rf^w<FP2Ĕh?>J'bZ4o*mwY>#~?.4)y-듂GtBއ^d aнB7O`я}I
2]Դ4
sI,7]ۭkT͐ǳ?;x^"a[n&lY^ZrSܽ%]{QQ&N;uiLE nXڮn.gh<x\|&0S0
 7<=pzJBҲMxMϱF:@H?/c 53-_;'DoX1|Bx_$T=z"9psu/VA40Xp$q ?Ϛ)_	HX L#S*M#q&,t͗8uxG%`o>eE1F$m蔄<W\S-6o|AP#j7V#!=(n1rJ6\ A=TFy>!m er4@~c٩n%< xNsdL[:&$'%t1up~w!KCPypuJm1' }-cyZҧHcHQ]8unhZ𫢠i'u -P
 N/[Q40`ހlVPe+pΗB	θDou8"sGz,J(Xi}F/WuSYRh=HQ6NEvFWU3BZ!\- ŧ00l-nXSIXvZ]^bATʣ^R!<uMBF0
q@HFޯ-TaZ
I>W"
cI
5EkZ}<Ce:*/ܲZ-HQƜI(WtEQ tx<YGbJ_V%]@aUߨ0B}n߹YV`DPSWX㢲JL)VdҧgV5sɮ;8*=jW}n\-~R$V[[0/wǭpT)g%tn*E0[UL(>N\eJ#jXGe+6OzZ@nm9LfeM
Zz*k:Ae	vt{,ޟvR$Wo,sGpEf.d"w.jáN#>vd턈\eѭ%$BtXS86@d'&7PIZPeXJwӀRmz x:N"5VR^:`+M04P{`*U@7`\,+B<SVy	T_*Qm;d_1ga
509DWLzJq.ט %'^{,8leʎ?MaLXBEGwX[2aK=1{h=)t=2~*o[^{ו9kFMSRbv ֤Y3Ɛ͹SiN'N`Q.XOq Z΋(N ErRIw~K `V=đC;V?IrdӚGH\|6XFV=x`0fCAmFcee⒲HV/gRDk|HVĚ/CSiꔔ)}"!6( :fUɽak|='#2 ZgpfXbP+ Xn.Rk`f4/"&$%14_:TFh7;i>crޓMV:H"p)XbTcL"ƌ<bhtfr}(Mu9]
bis4.49:mmJpiq?|Sdf2po]zL)B]cI!㘻@h(l/In|xO((XI_e|J=WL^<od^)z3]Id$j`GIwyblϼ釚`? Yoe:go^{ŧPP*{̻j1Z {bK=T EV٢1<1oN{w>WO}N7|0aQоȀQv$J"zvD28Z_֎IQ8|fsX'3x65.'R5oFVR+(d)Qg=A2{Y#R8բM|✂F&رhą%>嶽t#yܚ')	f~ qOQwX6<*\;GoEZ<)5ҚE$EJFsǠ'O;&sXX䣏V[Bطk7V#)QF%,G
Y`F^)K:c%YN]p@*;Ibil8/fPƚRi <	:Ti GCJpGWǬ`$òK-.pb6i\y3PE.05Lz@79L\h/!t_mDki]`/*-| %?lwL6
(8{L9'x	SpOMp[H۴G#`*1,AzT@/O0ߎ$l5s	q/!Oh_}3Gq֠KCH)c/
#=mH,[b5E{}czּFc>/we[]t$s@~.0.}Li'+/_hH@Rܛt{[j=yvsOuAA8i)`CjgG,!J4@䆒  0A+(rjD*aCC^KĻ<7t+/ċA<66U"FoZb/Vd${Pz$o=g蔽?ZUVk[/ژ̝\f<&K^-& C/FOpwע(S
 ͔qv ?g&'Kl-dI+saoN3n)j"j<ap9yNUe7r`5"zRwj7p;вhk=O,nW/Ӷ<L]U8ʐǇq}ggzj7k$G!:rtc*=*K+n/˂WO<HػɠVi
T ]C͂pNF	a%c/ފXD71}Uu~(A-x>yjT/
)tB=sJdrK;*<7+KiCCf))aFxgeޏ"Ń(uI+n'7kXd22b	$hh߇y"fo_%
#q˓y숒C,_sAEC2Zt
ASGh9;nA]$^	h#czUݸ/X9B`@`WŻU<l1 jxܥ(9'ÄzG^|CI,ċZ3]0{xUbN]w aJ)
FJ΄ɗu+qJݪkja1*T&/qt[,!L*YqלgX/CF=6Ј\`m&Mr߶pr:v?9Q0ЂIqOyc~z8[>$Sn1EsxzW9Ltw'l4|~~#26nZwls!H:;vh	#}OIEʤJja$ho)D{mMxź'K>~yƜΪ!@#g9HP,D>trXVbg
WƮdgu&8*?*Ð\ 7 jp׊;z[.,x_F4W}M?j.ajwyך&G	)~V_kmA(tIL~QI0eԚ/{
IFCl"%!lۅJU"%Q8.B	QNLoMe?CQ
ȭ6sߛjFUIS	l#0Gwӗ`6хDr^`L(;R,\|U|%Upq  }*7R0JRa!kjs0#yjs'%z t'ܗ
D~,lddi?_B$+f,*7PR5+O)*kLvKEm$ ~
;܆DzV9Wכ4]|e<FR)5tŮ냐	qtp>`p9Z4*
}'CL|1=lTc>6j8Xb`bps{|ÞDȕ+)m2(WY('J?5O ܴ]/Fo$:̂ߪsgU;Jxr(O]q	Hie9!ozdxGITO5XCQћγgB:%@i:ǄŠYFz Eo&<An8Ѧz"pO%:R,T^t1p.٫ ]Ɵ'AמӸ˔Ô?пWz-m1rM<n@^Lc
{+%:mu蝠jb~&Vtc ]G_xx 	^"3B],$'	yUtOSpb                                                                                                                                                                                                                                                   i                        Hc" $      UCX042.B                       c
  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SHR.EXE;1                                                                                                        "     N       turns: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        Instance out of range
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Method routine returned invalid status: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Extending varbind list one more repeating section
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 SET - test phase, pass 1
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        requested obj idx:%d, object:%s, dots:%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3              requested oid:%s, object:-null-
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 No object found in object table
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 No set function for this MIB variable
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Data is of the wrong type; should be %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 No instance in the varbind's OID
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Out of memory during a set
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 An error has been declared in index %d; cleaning up
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 SET - test phase, pass 2
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Method routine returned unknown status: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 method routine declared an error; %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   SET - commit phase
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Method routine declared an error during COMMIT
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Method routine declared an error during UNDO
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 SET - undo phase
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Method routine declared an error during UNDO
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Invalid data type: 0x%X
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     01-JAN-1970 00:00:00.00             ̠  ֠  ܠ          UNDEFINED CONDITION ALERT SUBALERT  EMERGENCY ERROR CRITICAL    WARNING NOTICE  INFORMATIONAL DEBUG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      %s:  
 esnmp_pack: No hdr and Varbind to pack
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3           Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 Pack: Invalid data type: 0x%X
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3   esnmp_unpack: No packet to unpack
      DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Unexpected protocol type: 0x%X
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Invalid security packet length: %d
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 No Memory - packet dropped
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Unrecognized packet type: 0x%X
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Empty Get request packet
       DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Invalid starting OID format in packet:'%s'
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Invalid ending OID format in packet:'%s'
       DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Badly formed DPI packet, length error
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Badly formed DPI packet, length error
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Invalid data type: 0x%X
        DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3   @(#)$RCSfile: prnt_lib.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/12/19 16:53:03 $        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated  
Packet Dump: 
 %2.2x         
 PrintVarBindList, vb_ptr->name:
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;3 %s =    %u
 %d
 %d.%d.%d.%d
    PrintVarBindList, vb_ptr->value.oid_value:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;3 %s
 NULL
 PrintVarBindList: Illegal type: 0x%x
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;3 
 %c  
                                                                                                                                                                                                                                %s               at line %d in file %s
 Error code set in packet -      Return packet too big.
 No such variable name.  Index:  %d.
  Bad variable value.  Index:  %d.
 Read only variable:  %d.
 General error:  %d.
 Unknown status code:  %d.
         @(#)$RCSfile: oid_lib.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/04/27 19:27:50 $ SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated                         (  0  :  D  J  T  \  h  p  ~          Ⱥ  غ              0  @  P  \  j  x            Ȼ               8  @  T  d  x          м          '  6  K  X  m  x        Ľ  ٽ         &  4  L  X  n  x            Ⱦ  ؾ             4  D  X  \  j  x          ȿ  ؿ          (  @  P  `  p                        -  8  I  V  h  r                      %  4  I  X  m  ~                    ,  A  P  e  t                    &  ;  F  \  h  ~                  $  @  X  m                      (  8  P  `  p                      (  9  L  `  x                     %  6  G  X  j  |                    *  ;  L  `  t                          0  @  P  `  p                        $  5  B  U  b  x                    /  :  L  P  ^  p                     
     0  D  T  h  l  z                      &  8  H  \  l                       4  H  \  p                  '  4  I  ^  t                        4  H  `  r                 8  R  d  ~              0  P  h                 4  O  b  }               ,  @  R  h  z                 >  X  z              6  N  h              "  >  T  p                0  @  \  z            
  %  D  _  z            
  &  @  [  n                  &  8  N  `  x                4  T  n              &  @  [  x                @  X  s                7  P  k                3  F  a  t                 4  P  h              8  Z  t                 *  B  X  ]  l  w                  !  4  F  T  f  x                     4  F  X  j  z                    ,  >  P  b  r                    ,  >  T  f  t  ~                        (  6  H  \  n  |                    (  8  J  \  p                   *  D  X  t                  ,  @  S  l                     (  <  F  T  h  x                       0  @  R  d  z                  "  6  H  \  n                      "  0  8  H  V  h  p                  ccitt 0                                                                                                                                                                                                                                                    j                        ) $      UCX042.B                       c
  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SHR.EXE;1                                                                                                       T "     _       iso 1   org 1.3 dod 1.3.6 internet      1.3.6.1 directory 1.3.6.1.1 mgmt  1.3.6.1.2 mib_2   1.3.6.1.2.1 system  1.3.6.1.2.1.1 sysDescr  1.3.6.1.2.1.1.1 sysObjectID     1.3.6.1.2.1.1.2 sysUpTime       1.3.6.1.2.1.1.3 sysContact      1.3.6.1.2.1.1.4 sysName 1.3.6.1.2.1.1.5 sysLocation     1.3.6.1.2.1.1.6 sysServices     1.3.6.1.2.1.1.7 interfaces  1.3.6.1.2.1.2 ifNumber      1.3.6.1.2.1.2.1 ifTable 1.3.6.1.2.1.2.2 ifEntry 1.3.6.1.2.1.2.2.1       ifIndex 1.3.6.1.2.1.2.2.1.1     ifDescr 1.3.6.1.2.1.2.2.1.2 ifType  1.3.6.1.2.1.2.2.1.3 ifMtu   1.3.6.1.2.1.2.2.1.4     ifSpeed 1.3.6.1.2.1.2.2.1.5 ifPhysAddress   1.3.6.1.2.1.2.2.1.6 ifAdminStatus   1.3.6.1.2.1.2.2.1.7 ifOperStatus    1.3.6.1.2.1.2.2.1.8 ifLastChange    1.3.6.1.2.1.2.2.1.9 ifInOctets 1.3.6.1.2.1.2.2.1.10 ifInUcastPkts 1.3.6.1.2.1.2.2.1.11 ifInNUcastPkts 1.3.6.1.2.1.2.2.1.12 ifInDiscards 1.3.6.1.2.1.2.2.1.13 ifInErrors 1.3.6.1.2.1.2.2.1.14  ifInUnknownProtos 1.3.6.1.2.1.2.2.1.15    ifOutOctets 1.3.6.1.2.1.2.2.1.16 ifOutUcastPkts 1.3.6.1.2.1.2.2.1.17    ifOutNUcastPkts 1.3.6.1.2.1.2.2.1.18  ifOutDiscards 1.3.6.1.2.1.2.2.1.19    ifOutErrors 1.3.6.1.2.1.2.2.1.20  ifOutQLen 1.3.6.1.2.1.2.2.1.21 ifSpecific 1.3.6.1.2.1.2.2.1.22 at 1.3.6.1.2.1.3   atTable 1.3.6.1.2.1.3.1 atEntry 1.3.6.1.2.1.3.1.1 atIfIndex 1.3.6.1.2.1.3.1.1.1 atPhysAddress   1.3.6.1.2.1.3.1.1.2 atNetAddress    1.3.6.1.2.1.3.1.1.3 ip  1.3.6.1.2.1.4 ipForwarding  1.3.6.1.2.1.4.1 ipDefaultTTL    1.3.6.1.2.1.4.2 ipInReceives    1.3.6.1.2.1.4.3 ipInHdrErrors   1.3.6.1.2.1.4.4 ipInAddrErrors  1.3.6.1.2.1.4.5 ipForwDatagrams 1.3.6.1.2.1.4.6 ipInUnknownProtos       1.3.6.1.2.1.4.7 ipInDiscards    1.3.6.1.2.1.4.8 ipInDelivers    1.3.6.1.2.1.4.9 ipOutRequests 1.3.6.1.2.1.4.10  ipOutDiscards 1.3.6.1.2.1.4.11  ipOutNoRoutes 1.3.6.1.2.1.4.12 ipReasmTimeout 1.3.6.1.2.1.4.13 ipReasmReqds 1.3.6.1.2.1.4.14 ipReasmOKs 1.3.6.1.2.1.4.15 ipReasmFails 1.3.6.1.2.1.4.16  ipFragOKs 1.3.6.1.2.1.4.17  ipFragFails 1.3.6.1.2.1.4.18  ipFragCreates 1.3.6.1.2.1.4.19    ipAddrTable 1.3.6.1.2.1.4.20    ipAddrEntry 1.3.6.1.2.1.4.20.1  ipAdEntAddr 1.3.6.1.2.1.4.20.1.1 ipAdEntIfIndex 1.3.6.1.2.1.4.20.1.2 ipAdEntNetMask 1.3.6.1.2.1.4.20.1.3 ipAdEntBcastAddr 1.3.6.1.2.1.4.20.1.4  ipAdEntReasmMaxSize 1.3.6.1.2.1.4.20.1.5 ipRouteTable 1.3.6.1.2.1.4.21 ipRouteEntry 1.3.6.1.2.1.4.21.1  ipRouteDest 1.3.6.1.2.1.4.21.1.1 ipRouteIfIndex 1.3.6.1.2.1.4.21.1.2 ipRouteMetric1 1.3.6.1.2.1.4.21.1.3 ipRouteMetric2 1.3.6.1.2.1.4.21.1.4 ipRouteMetric3 1.3.6.1.2.1.4.21.1.5 ipRouteMetric4 1.3.6.1.2.1.4.21.1.6 ipRouteNextHop 1.3.6.1.2.1.4.21.1.7    ipRouteType 1.3.6.1.2.1.4.21.1.8 ipRouteProto 1.3.6.1.2.1.4.21.1.9 ipRouteAge 1.3.6.1.2.1.4.21.1.10 ipRouteMask 1.3.6.1.2.1.4.21.1.11 ipRouteMetric5  1.3.6.1.2.1.4.21.1.12 ipRouteInfo 1.3.6.1.2.1.4.21.1.13 ipNetToMediaTable 1.3.6.1.2.1.4.22  ipNetToMediaEntry 1.3.6.1.2.1.4.22.1  ipNetToMediaIfIndex 1.3.6.1.2.1.4.22.1.1        ipNetToMediaPhysAddress 1.3.6.1.2.1.4.22.1.2 ipNetToMediaNetAddress 1.3.6.1.2.1.4.22.1.3 ipNetToMediaType 1.3.6.1.2.1.4.22.1.4  ipRoutingDiscards 1.3.6.1.2.1.4.23 icmp 1.3.6.1.2.1.5 icmpInMsgs        1.3.6.1.2.1.5.1 icmpInErrors    1.3.6.1.2.1.5.2 icmpInDestUnreachs      1.3.6.1.2.1.5.3 icmpInTimeExcds 1.3.6.1.2.1.5.4 icmpInParmProbs 1.3.6.1.2.1.5.5 icmpInSrcQuenchs        1.3.6.1.2.1.5.6 icmpInRedirects 1.3.6.1.2.1.5.7 icmpInEchos     1.3.6.1.2.1.5.8 icmpInEchoReps  1.3.6.1.2.1.5.9 icmpInTimestamps 1.3.6.1.2.1.5.10   icmpInTimestampReps 1.3.6.1.2.1.5.11        icmpInAddrMasks 1.3.6.1.2.1.5.12 icmpInAddrMaskReps 1.3.6.1.2.1.5.13    icmpOutMsgs 1.3.6.1.2.1.5.14  icmpOutErrors 1.3.6.1.2.1.5.15    icmpOutDestUnreachs 1.3.6.1.2.1.5.16 icmpOutTimeExcds 1.3.6.1.2.1.5.17 icmpOutParmProbs 1.3.6.1.2.1.5.18  icmpOutSrcQuenchs 1.3.6.1.2.1.5.19 icmpOutRedirects 1.3.6.1.2.1.5.20 icmpOutEchos 1.3.6.1.2.1.5.21    icmpOutEchoReps 1.3.6.1.2.1.5.22  icmpOutTimestamps 1.3.6.1.2.1.5.23 icmpOutTimestampReps 1.3.6.1.2.1.5.24 icmpOutAddrMasks 1.3.6.1.2.1.5.25    icmpOutAddrMaskReps 1.3.6.1.2.1.5.26    tcp 1.3.6.1.2.1.6       tcpRtoAlgorithm 1.3.6.1.2.1.6.1 tcpRtoMin       1.3.6.1.2.1.6.2 tcpRtoMax       1.3.6.1.2.1.6.3 tcpMaxConn      1.3.6.1.2.1.6.4 tcpActiveOpens  1.3.6.1.2.1.6.5 tcpPassiveOpens 1.3.6.1.2.1.6.6 tcpAttemptFails 1.3.6.1.2.1.6.7 tcpEstabResets  1.3.6.1.2.1.6.8 tcpCurrEstab    1.3.6.1.2.1.6.9 tcpInSegs 1.3.6.1.2.1.6.10 tcpOutSegs 1.3.6.1.2.1.6.11 tcpRetransSegs 1.3.6.1.2.1.6.12 tcpConnTable 1.3.6.1.2.1.6.13 tcpConnEntry 1.3.6.1.2.1.6.13.1 tcpConnState 1.3.6.1.2.1.6.13.1.1  tcpConnLocalAddress 1.3.6.1.2.1.6.13.1.2 tcpConnLocalPort 1.3.6.1.2.1.6.13.1.3  tcpConnRemAddress 1.3.6.1.2.1.6.13.1.4 tcpConnRemPort 1.3.6.1.2.1.6.13.1.5  tcpInErrs 1.3.6.1.2.1.6.14 tcpOutRsts 1.3.6.1.2.1.6.15  udp 1.3.6.1.2.1.7 udpInDatagrams    1.3.6.1.2.1.7.1 udpNoPorts      1.3.6.1.2.1.7.2 udpInErrors     1.3.6.1.2.1.7.3 udpOutDatagrams 1.3.6.1.2.1.7.4 udpTable        1.3.6.1.2.1.7.5 udpEntry  1.3.6.1.2.1.7.5.1     udpLocalAddress 1.3.6.1.2.1.7.5.1.1 udpLocalPort    1.3.6.1.2.1.7.5.1.2 egp 1.3.6.1.2.1.8 egpInMsgs     1.3.6.1.2.1.8.1 egpInErrors     1.3.6.1.2.1.8.2 egpOutMsgs      1.3.6.1.2.1.8.3 egpOutErrors    1.3.6.1.2.1.8.4 egpNeighTable   1.3.6.1.2.1.8.5 egpNeighEntry 1.3.6.1.2.1.8.5.1 egpNeighState   1.3.6.1.2.1.8.5.1.1 egpNeighAddr    1.3.6.1.2.1.8.5.1.2 egpNeighAs  1.3.6.1.2.1.8.5.1.3 egpNeighInMsgs  1.3.6.1.2.1.8.5.1.4 egpNeighInErrs  1.3.6.1.2.1.8.5.1.5 egpNeighOutMsgs 1.3.6.1.2.1.8.5.1.6     egpNeighOutErrs 1.3.6.1.2.1.8.5.1.7 egpNeighInErrMsgs   1.3.6.1.2.1.8.5.1.8 egpNeighOutErrMsgs  1.3.6.1.2.1.8.5.1.9 egpNeighStateUps 1.3.6.1.2.1.8.5.1.10 egpNeighStateDowns 1.3.6.1.2.1.8.5.1.11 egpNeighIntervalHello 1.3.6.1.2.1.8.5.1.12 egpNeighIntervalPoll 1.3.6.1.2.1.8.5.1.13 egpNeighMode 1.3.6.1.2.1.8.5.1.14 egpNeighEventTrigger 1.3.6.1.2.1.8.5.1.15  egpAs       1.3.6.1.2.1.8.6 transmission 1.3.6.1.2.1.10 fddi  1.3.6.1.2.1.10.15 snmpFddiSMT 1.3.6.1.2.1.10.15.1 snmpFddiSMTNumber 1.3.6.1.2.1.10.15.1.1 snmpFddiSMTTable  1.3.6.1.2.1.10.15.1.2 snmpFddiSMTEntry    1.3.6.1.2.1.10.15.1.2.1 snmpFddiSMTIndex  1.3.6.1.2.1.10.15.1.2.1.1 snmpFddiSMTStationId  1.3.6.1.2.1.10.15.1.2.1.2 snmpFddiSMTOpVersionId  1.3.6.1.2.1.10.15.1.2.1.3 snmpFddiSMTHiVersionId  1.3.6.1.2.1.10.15.1.2.1.4 snmpFddiSMTLoVersionId  1.3.6.1.2.1.10.15.1.2.1.5 snmpFddiSMTMACCt  1.3.6.1.2.1.10.15.1.2.1.6 snmpFddiSMTNonMasterCt  1.3.6.1.2.1.10.15.1.2.1.7 snmpFddiSMTMasterCt 1.3.6.1.2.1.10.15.1.2.1.8 snmpFddiSMTPathsAvailable 1.3.6.1.2.1.10.15.1.2.1.9 snmpFddiSMTConfigCapabilities 1.3.6.1.2.1.10.15.1.2.1.10      snmpFddiSMTConfigPolicy 1.3.6.1.2.1.10.15.1.2.1.11  snmpFddiSMTConnectionPolicy 1.3.6.1.2.1.10.15.1.2.1.12 snmpFddiSMTTNotify 1.3.6.1.2.1.10.15.1.2.1.13 snmpFddiSMTStatusReporting 1.3.6.1.2.1.10.15.1.2.1.14  snmpFddiSMTECMState 1.3.6.1.2.1.10.15.1.2.1.15 snmpFddiSMTCFState 1.3.6.1.2.1.10.15.1.2.1.16 snmpFddiSMTHoldState 1.3.6.1.2.1.10.15.1.2.1.17    snmpFddiSMTRemoteDisconnectFlag 1.3.6.1.2.1.10.15.1.2.1.18 snmpFddiSMTStationAction 1.3.6.1.2.1.10.15.1.2.1.19  snmpFddiMAC 1.3.6.1.2.1.10.15.2 snmpFddiMACNumber 1.3.6.1.2.1.10.15.2.1 snmpFddiMACTable  1.3.6.1.2.1.10.15.2.2 snmpFddiMACEntry        1.3.6.1.2.1.10.15.2.2.1 snmpFddiMACSMTIndex 1.3.6.1.2.1.10.15.2.2.1.1 snmpFddiMACIndex  1.3.6.1.2.1.10.15.2.2.1.2 snmpFddiMACFrameStatusCapabilities  1.3.6.1.2.1.10.15.2.2.1.3 snmpFddiMACTMaxGreatestLowerBound 1.3.6.1.2.1.10.15.2.2.1.4 snmpFddiMACTVXGreatestLowerBound  1.3.6.1.2.1.10.15.2.2.1.5 snmpFddiMACPathsAvailable 1.3.6.1.2.1.10.15.2.2.1.6 snmpFddiMACCurrentPath  1.3.6.1.2.1.10.15.2.2.1.7 snmpFddiMACUpstreamNbr  1.3.6.1.2.1.10.15.2.2.1.8 snmpFddiMACOldUpstreamNbr 1.3.6.1.2.1.10.15.2.2.1.9 snmpFddiMACDupAddrTest 1.3.6.1.2.1.10.15.2.2.1.10 snmpFddiMACPathsRequested 1.3.6.1.2.1.10.15.2.2.1.11  snmpFddiMACDownstreamPORTType 1.3.6.1.2.1.10.15.2.2.1.12  snmpFddiMACSMTAddress 1.3.6.1.2.1.10.15.2.2.1.13  snmpFddiMACTReq 1.3.6.1.2.1.10.15.2.2.1.14      snmpFddiMACTNeg 1.3.6.1.2.1.10.15.2.2.1.15      snmpFddiMACTMax 1.3.6.1.2.1.10.15.2.2.1.16  snmpFddiMACTvxValue 1.3.6.1.2.1.10.15.2.2.1.17      snmpFddiMACTMin 1.3.6.1.2.1.10.15.2.2.1.18  snmpFddiMACCurrentFrameStatus 1.3.6.1.2.1.10.15.2.2.1.19    snmpFddiMACFrameCts 1.3.6.1.2.1.10.15.2.2.1.20  snmpFddiMACErrorCts 1.3.6.1.2.1.10.15.2.2.1.21 snmpFddiMACLostCts 1.3.6.1.2.1.10.15.2.2.1.22 snmpFddiMACFrameErrorThreshold 1.3.6.1.2.1.10.15.2.2.1.23 snmpFddiMACFrameErrorRatio 1.3.6.1.2.1.10.15.2.2.1.24    snmpFddiMACRMTState 1.3.6.1.2.1.10.15.2.2.1.25  snmpFddiMACDaFlag 1.3.6.1.2.1.10.15.2.2.1.26 snmpFddiMACUnaDaFlag 1.3.6.1.2.1.10.15.2.2.1.27  snmpFddiMACFrameCondition 1.3.6.1.2.1.10.15.2.2.1.28 snmpFddiMACChipSet 1.3.6.1.2.1.10.15.2.2.1.29  snmpFddiMACAction 1.3.6.1.2.1.10.15.2.2.1.30 snmpFddiPATH 1.3.6.1.2.1.10.15.3 snmpFddiPORT    1.3.6.1.2.1.10.15.4 snmp                                                                                                                                                                                                                                                   k                        ]s $      UCX042.B                       c
  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SHR.EXE;1                                                                                                       t "     p       FddiPORTNumber  1.3.6.1.2.1.10.15.4.1 snmpFddiPORTTable 1.3.6.1.2.1.10.15.4.2 snmpFddiPORTEntry 1.3.6.1.2.1.10.15.4.2.1 snmpFddiPORTSMTIndex  1.3.6.1.2.1.10.15.4.2.1.1 snmpFddiPORTIndex 1.3.6.1.2.1.10.15.4.2.1.2 snmpFddiPORTPCType  1.3.6.1.2.1.10.15.4.2.1.3 snmpFddiPORTPCNeighbor  1.3.6.1.2.1.10.15.4.2.1.4 snmpFddiPORTConnectionPolicies  1.3.6.1.2.1.10.15.4.2.1.5 snmpFddiPORTRemoteMACIndicated  1.3.6.1.2.1.10.15.4.2.1.6 snmpFddiPORTCEState 1.3.6.1.2.1.10.15.4.2.1.7 snmpFddiPORTPathsRequested  1.3.6.1.2.1.10.15.4.2.1.8 snmpFddiPORTMACPlacement  1.3.6.1.2.1.10.15.4.2.1.9 snmpFddiPORTAvailablePaths 1.3.6.1.2.1.10.15.4.2.1.10   snmpFddiPORTMACLoopTime 1.3.6.1.2.1.10.15.4.2.1.11  snmpFddiPORTTBMax 1.3.6.1.2.1.10.15.4.2.1.12 snmpFddiPORTBSFlag 1.3.6.1.2.1.10.15.4.2.1.13 snmpFddiPORTLCTFailCts 1.3.6.1.2.1.10.15.4.2.1.14        snmpFddiPORTLerEstimate 1.3.6.1.2.1.10.15.4.2.1.15 snmpFddiPORTLemRejectCts 1.3.6.1.2.1.10.15.4.2.1.16 snmpFddiPORTLemCts 1.3.6.1.2.1.10.15.4.2.1.17  snmpFddiPORTLerCutoff 1.3.6.1.2.1.10.15.4.2.1.18 snmpFddiPORTLerAlarm 1.3.6.1.2.1.10.15.4.2.1.19 snmpFddiPORTConnectState 1.3.6.1.2.1.10.15.4.2.1.20 snmpFddiPORTPCMState 1.3.6.1.2.1.10.15.4.2.1.21 snmpFddiPORTPCWithhold 1.3.6.1.2.1.10.15.4.2.1.22 snmpFddiPORTLerCondition 1.3.6.1.2.1.10.15.4.2.1.23    snmpFddiPORTChipSet 1.3.6.1.2.1.10.15.4.2.1.24 snmpFddiPORTAction 1.3.6.1.2.1.10.15.4.2.1.25 snmpFddiATTACHMENT 1.3.6.1.2.1.10.15.5 snmpFddiATTACHMENTNumber  1.3.6.1.2.1.10.15.5.1 snmpFddiATTACHMENTTable 1.3.6.1.2.1.10.15.5.2   snmpFddiATTACHMENTEntry 1.3.6.1.2.1.10.15.5.2.1 snmpFddiATTACHMENTSMTIndex  1.3.6.1.2.1.10.15.5.2.1.1   snmpFddiATTACHMENTIndex 1.3.6.1.2.1.10.15.5.2.1.2       snmpFddiATTACHMENTClass 1.3.6.1.2.1.10.15.5.2.1.3 snmpFddiATTACHMENTOpticalBypassPresent  1.3.6.1.2.1.10.15.5.2.1.4 snmpFddiATTACHMENTIMaxExpiration  1.3.6.1.2.1.10.15.5.2.1.5 snmpFddiATTACHMENTInsertedStatus  1.3.6.1.2.1.10.15.5.2.1.6 snmpFddiATTACHMENTInsertPolicy  1.3.6.1.2.1.10.15.5.2.1.7 snmpFddiChipSets  1.3.6.1.2.1.10.15.6 snmpFddiPHYChipSets 1.3.6.1.2.1.10.15.6.1   snmpFddiMACChipSets 1.3.6.1.2.1.10.15.6.2 snmpFddiPHYMACChipSets  1.3.6.1.2.1.10.15.6.3 snmp 1.3.6.1.2.1.11 snmpInPkts 1.3.6.1.2.1.11.1 snmpOutPkts 1.3.6.1.2.1.11.2  snmpInBadVersions 1.3.6.1.2.1.11.3        snmpInBadCommunityNames 1.3.6.1.2.1.11.4 snmpInBadCommunityUses 1.3.6.1.2.1.11.5 snmpInASNParseErrs 1.3.6.1.2.1.11.6  snmpInTooBigs 1.3.6.1.2.1.11.8  snmpInNoSuchNames 1.3.6.1.2.1.11.9        snmpInBadValues 1.3.6.1.2.1.11.10       snmpInReadOnlys 1.3.6.1.2.1.11.11 snmpInGenErrs 1.3.6.1.2.1.11.12 snmpInTotalReqVars  1.3.6.1.2.1.11.13 snmpInTotalSetVars  1.3.6.1.2.1.11.14 snmpInGetRequests 1.3.6.1.2.1.11.15 snmpInGetNexts  1.3.6.1.2.1.11.16 snmpInSetRequests 1.3.6.1.2.1.11.17 snmpInGetResponses  1.3.6.1.2.1.11.18   snmpInTraps 1.3.6.1.2.1.11.19 snmpOutTooBigs  1.3.6.1.2.1.11.20 snmpOutNoSuchNames  1.3.6.1.2.1.11.21 snmpOutBadValues  1.3.6.1.2.1.11.22 snmpOutGenErrs  1.3.6.1.2.1.11.24 snmpOutGetRequests  1.3.6.1.2.1.11.25       snmpOutGetNexts 1.3.6.1.2.1.11.26 snmpOutSetRequests  1.3.6.1.2.1.11.27 snmpOutGetResponses 1.3.6.1.2.1.11.28 snmpOutTraps  1.3.6.1.2.1.11.29 snmpEnableAuthenTraps 1.3.6.1.2.1.11.30 experimental  1.3.6.1.3 dot5  1.3.6.1.3.4 dot5Table 1.3.6.1.3.4.1 dot5Entry       1.3.6.1.3.4.1.1 dot5IfIndex 1.3.6.1.3.4.1.1.1 dot5Commands  1.3.6.1.3.4.1.1.2 dot5RingStatus  1.3.6.1.3.4.1.1.3 dot5RingState 1.3.6.1.3.4.1.1.4 dot5RingOpenStatus  1.3.6.1.3.4.1.1.5 dot5RingSpeed 1.3.6.1.3.4.1.1.6 dot5UpStream  1.3.6.1.3.4.1.1.7 dot5ActMonParticipate 1.3.6.1.3.4.1.1.8 dot5Functional  1.3.6.1.3.4.1.1.9 dot5StatsTable  1.3.6.1.3.4.2 dot5StatsEntry    1.3.6.1.3.4.2.1 dot5StatsIfIndex  1.3.6.1.3.4.2.1.1 dot5StatsLineErrors 1.3.6.1.3.4.2.1.2 dot5StatsBurstErrors  1.3.6.1.3.4.2.1.3 dot5StatsACErrors 1.3.6.1.3.4.2.1.4 dot5StatsAbortTransErrors 1.3.6.1.3.4.2.1.5       dot5StatsInternalErrors 1.3.6.1.3.4.2.1.6 dot5StatsLostFrameErrors  1.3.6.1.3.4.2.1.7   dot5StatsReceiveCongestions 1.3.6.1.3.4.2.1.8 dot5StatsFrameCopiedErrors  1.3.6.1.3.4.2.1.9 dot5StatsTokenErrors 1.3.6.1.3.4.2.1.10 dot5StatsSoftErrors 1.3.6.1.3.4.2.1.11  dot5StatsHardErrors 1.3.6.1.3.4.2.1.12  dot5StatsSignalLoss 1.3.6.1.3.4.2.1.13 dot5StatsTransmitBeacons 1.3.6.1.3.4.2.1.14 dot5StatsRecoverys 1.3.6.1.3.4.2.1.15 dot5StatsLobeWires 1.3.6.1.3.4.2.1.16 dot5StatsRemoves 1.3.6.1.3.4.2.1.17 dot5StatsSingles 1.3.6.1.3.4.2.1.18  dot5StatsFreqErrors 1.3.6.1.3.4.2.1.19  dot5Tests 1.3.6.1.3.4.3 testInsertFunc      1.3.6.1.3.4.3.1 dot5ChipSets  1.3.6.1.3.4.4 chipSetIBM16        1.3.6.1.3.4.4.1 chipSetTItms380 1.3.6.1.3.4.4.2 chipSetTItms380c16      1.3.6.1.3.4.4.3 dot5TimerTable  1.3.6.1.3.4.5 dot5TimerEntry    1.3.6.1.3.4.5.1 dot5TimerIfIndex  1.3.6.1.3.4.5.1.1 dot5TimerReturnRepeat 1.3.6.1.3.4.5.1.2 dot5TimerHolding  1.3.6.1.3.4.5.1.3 dot5TimerQueuePDU 1.3.6.1.3.4.5.1.4 dot5TimerValidTransmit  1.3.6.1.3.4.5.1.5 dot5TimerNoToken  1.3.6.1.3.4.5.1.6 dot5TimerActiveMon  1.3.6.1.3.4.5.1.7 dot5TimerStandbyMon 1.3.6.1.3.4.5.1.8 dot5TimerErrorReport  1.3.6.1.3.4.5.1.9   dot5TimerBeaconTransmit 1.3.6.1.3.4.5.1.10 dot5TimerBeaconReceive 1.3.6.1.3.4.5.1.11    private 1.3.6.1.4   enterprises 1.3.6.1.4.1 unix  1.3.6.1.4.1.4 agents  1.3.6.1.4.1.4.1 fourBSD_isode 1.3.6.1.4.1.4.1.2 peers   1.3.6.1.4.1.4.3 unixd 1.3.6.1.4.1.4.3.1 joint_iso_ccitt 2 MakeOIDFragFromDot, table lookup failed: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3   MakeOIDFragFromDot, oid_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFragFromDot, oid_ptr->oid_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  MakeOIDFragFromDot, hex:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3    MakeOIDFragFromDot, octal:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  MakeOIDFragFromDot, decimal:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFragFromDot, bad character: %d, %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFragFromDot, expected dot: %d %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFromDot, illegal OID value %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  ParseSubIdHex, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  %1x ParseSubIdHex, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3       ParseSubIdOctal, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  %1o ParseSubIdOctal, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 ParseSubIdDecimal, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3    %1d ParseSubIdDecimal, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3   MakeDotFromOID, bad (NULL) OID
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeDotFromOID, GetStringFromSubIds
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 %d . .%d             CatOID: Too int: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 CatOID, cannot malloc oid
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 CatOID, cannot malloc oid_ptr
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3   @(#)$RCSfile: free_lib.c,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 1994/01/05 20:06:46 $        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @  @                                                      
  H        8   %      (        `             8  H  P          H	  X	  	  	  	   
  h  	  
  `       8  H            ,              
                 @                                                                       UCX$IPC_SHR                                                    UCX$ACCESS_SHR                                                 VAXCRTL                                                        MTHRTL                                                         LIBRTL                                                         CMA$TIS_SHR                                                    DECC$SHR                               *                      Ă  ̂  Ԃ  ܂                  $  ,  4  <  D  L  T  \  d  l  t  |      |  |   }  }  }  }  }  }  }  }   }  $}  (}  ,}  0}  4}  8}                                                                                                                                                                                                                                                                   l                        @6Q $      UCX042.B                       c
  P  6[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$ESNMP_SHR.EXE;1                                                                                                       x                     D  L  P  T  X  \  `  d  h  l  p  t  x  |                                    Į  Ȯ  ̮  Ю  Ԯ  خ  ܮ                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                    į  ȯ  ̯  Я  ԯ  د  ܯ                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                    İ  Ȱ  ̰  а  ԰  ذ  ܰ                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                    ı  ȱ  ̱  б  Ա  ر  ܱ                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                    Ĳ  Ȳ  ̲  в  Բ  ز  ܲ                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                    ĳ  ȳ  ̳  г  Գ  س  ܳ                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                    Ĵ  ȴ  ̴  д  Դ  ش  ܴ                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                    ĵ  ȵ  ̵  е  Ե  ص  ܵ                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                    Ķ  ȶ  ̶  ж  Զ  ض  ܶ                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                    ķ  ȷ  ̷  з  Է  ط  ܷ                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                    ĸ  ȸ  ̸  и  Ը  ظ  ܸ                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                    Ĺ  ȹ  ̹  й  Թ  ع  ܹ                                                                              A     
UCX$ESNMP_SHRUCX V4.2-2119-NOV-1997 13:0619-NOV-1997 13:06   VAX-11 Linker V05-13        	.$$ABS$$.    xn   
ESNMP_POLL   n    SET_DEBUG_LEVEL   n   IS_DEBUG_LEVEL   hn   	ESNMP_LOG   pn   
ESNMP_LOGS   0n   
ESNMP_INIT   8n  < ESNMP_REGISTER   @n   ESNMP_UNREGISTER   Hn   ESNMP_ARE_YOU_THERE   Xn  < 
ESNMP_TRAP   `n   
ESNMP_TERM   n  STR2OID   n   	SPRINTOID   n  | INSTANCE2OID   n   OID2INSTANCE   n   	CLONE_OID   n    FREE_OID    n   	CLONE_BUF    n   CMP_OID   (n   CMP_OID_PREFIX   n  < MEM2OCT   n  < CMP_OCT     n  | 	CLONE_OCT   n    FREE_OCT   n  | 	O_INTEGER   n   O_OCTET   n   O_OID   n  < O_STRING   n   FREE_VARBIND_DATA   Pn   ESNMP_SYSUPTIME     4  LOGLEVEL    @  NULLOID     H  ZEROOID                                                                                                                                                                      < * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$FINGER_SHUTDOWN.COM;1 +  , b   .     / #   4 U       d                    - P    0   1    2   3      K  P   W   O     5   6 
'  7 u؛  8          9          G    H  J                    $ !+U $ !      UCX$FINGER_SRVR_SHUTDOWN.COM -- Digital TCP/IP Services for OpenVMS Software 6 $ !                             FINGER Server Shutdown $ !					 $ ! 6 $ !  Copyright (c) Digital Equipment Corporation, 19966 $ !  All Rights Reserved.  Unpublished rights reserved3 $ !  under the copyright laws of the United States.  $ !   8 $ !  The software contained on this media is proprietary4 $ !  to and embodies the confidential technology of 5 $ !  Digital Equipment Corporation.  Possession, use, 5 $ !  duplication or dissemination of the software and 9 $ !  media is authorized only pursuant to a valid written 0 $ !  license from Digital Equipment Corporation. $ ! 5 $ !  RESTRICTED RIGHTS LEGEND   Use, duplication, or  4 $ !  disclosure by the U.S. Government is subject to9 $ !  restrictions as set forth in Subparagraph (c)(1)(ii) 3 $ !  of DFARS 252.227-7013, or in FAR 52.227-19, as  $ !  applicable. $ !  $ ! O $ !****************************************************************************  $ !  $ !  MODIFICATIONS:  $ ! 9 $ !  6-MAY-96	Ben Doub		Adapted from ucx$pop_shutdown.com  $ ! & $ !  1997-02-11 Lee Tibbert UCX 4.2-10B $ !		Only give the "server stopped" message if we actually shut it
 $ !		down. $ !  $ !--  $  $ SAY = "WRITE SYS$OUTPUT" $ !  $ ! Check out privileges $ ! - $ REQUIRED_PRIVS = "SYSPRV,OPER,SYSNAM,WORLD" ' $ PREV_PRIVS = F$SETPRV(REQUIRED_PRIVS) > $ IF .NOT. F$PRIVILEGE(REQUIRED_PRIVS) THEN GOTO NO_PRIVILEGES $ ON CONTROL_Y THEN GOTO EXIT  $ ON ERROR THEN GOTO EXIT  $ !  $ DEFINE/USER SYS$OUTPUT NL: $ DEFINE/USER SYS$ERROR NL:  $ !  $ UCX DISABLE SERVICE FINGER $ !  $ DEINSTALL: $ !   $ ON WARNING THEN GOTO NO_SHARED" $ INSTALL := $INSTALL/COMMAND_MODE $ ! . $ LIBRARY = "SYS$SYSTEM:UCX$FINGER_SERVER.EXE"? $ IF F$FILE("''LIBRARY'","KNOWN") THEN INSTALL DELETE 'LIBRARY' ' $ LIBRARY = "SYS$SYSTEM:UCX$FINGER.EXE" ? $ IF F$FILE("''LIBRARY'","KNOWN") THEN INSTALL DELETE 'LIBRARY'  $ !  $ SHUT_FINGER: $ PROCNAM := UCX$FINGER  $ CONTEXT = "" $ LOOP1: $   P1 = F$PID(CONTEXT) * $   IF P1 .EQS. "" THEN GOTO PROCLIST_DONE: $   IF F$GETJPI(P1,"PRCNAM") .NES. PROCNAM THEN GOTO LOOP1 $ !  $   STOP PROCESS/ID= 'p1' # $   SAY "UCX$FINGER server stopped"  $ !  $ PROCLIST_DONE: $ !  $ EXIT:   $ IF F$TYPE(PREV_PRIVS) .NES. "" $   THEN% $   PREV_PRIVS = F$SETPRV(PREV_PRIVS) 	 $   ENDIF  $ EXIT $ !  $ NO_PRIVILEGES:= $ SAY "Insufficient privileges to STOP the UCX$FINGER server" 2 $ SAY "Required priviliges are '' required_privs'" $ GOTO EXIT  $ !  $ NO_SHARED:( $ SAY "Failed to delete installed image") $ SAY "FINGER server requires ''LIBRARY'"  $ GOTO SHUT_FINGER                                                                                                                                                                                                                                                                                                                                                                                                                                         @ * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$FINGER_SRVR_STARTUP.COM;1 +  , b   .     / #   4 O       D                   - P    0   1    2   3      K  P   W   O     5   6 \%  7 u؛  8          9          G    H  J                $ !+G $ !  UCX$FINGER_SRVR_STARTUP.COM -- Digital TCP/IP Services for OpenVMS , $ !                    FINGER Server Startup $ !  $ ! 6 $ !  Copyright (c) Digital Equipment Corporation, 19966 $ !  All Rights Reserved.  Unpublished rights reserved3 $ !  under the copyright laws of the United States.  $ !   8 $ !  The software contained on this media is proprietary4 $ !  to and embodies the confidential technology of 5 $ !  Digital Equipment Corporation.  Possession, use, 5 $ !  duplication or dissemination of the software and 9 $ !  media is authorized only pursuant to a valid written 0 $ !  license from Digital Equipment Corporation. $ ! 5 $ !  RESTRICTED RIGHTS LEGEND   Use, duplication, or  4 $ !  disclosure by the U.S. Government is subject to9 $ !  restrictions as set forth in Subparagraph (c)(1)(ii) 3 $ !  of DFARS 252.227-7013, or in FAR 52.227-19, as  $ !  applicable. $ !  $ ! O $ !****************************************************************************  $ !  $ !  MODIFICATIONS:  $ ! /                                                                                                                                                    m                        9 $      UCX042.B                       b  P  @[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$FINGER_SRVR_STARTUP.COM;1                                                               O                              1             $ !  6-MAY-96   Ben Doub                Created  $ ! ' $ !  24-Nov-96	BD			Purge old log files  $ !--  $!: $! To turn on finger forwarding simply uncomment next line $! DEFINE UCX$FINGER_FORWARD 1 $!& $ RUN SYS$SYSTEM:UCX$FINGER_SERVER.EXE $ ! $ $ SAVE=5+2*f$getsyi("CLUSTER_NODES") $ PURGE/KEEP='save'  $ !  $ EXIT                                                                                                                                                                                                         2 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$FIXUP.COM;1 +  , a	   .     / #   4 T       h                   - P    0   1    2   3      K  P   W   O     5   6 Af؛  7 Av؛  8          9          G    H  J                             K $!  Copyright (c) 1997 Digital Equipment Corporation.  All rights reserved. 9 $ucx$t_file_1 = "SYS$SPECIFIC:[SYSLIB]UCX$ACCESS_SHR.EXE"  $ucx$t_file_2 = ""Q $ucx$t_file_2 = ucx$t_file_2 + f$parse( ucx$t_file_1,,, "DEVICE", "SYNTAX_ONLY" ) T $ucx$t_file_2 = ucx$t_file_2 + f$parse( ucx$t_file_1,,, "DIRECTORY", "SYNTAX_ONLY" )O $ucx$t_file_2 = ucx$t_file_2 + f$parse( ucx$t_file_1,,, "NAME", "SYNTAX_ONLY" ) % $ucx$t_file_2 = ucx$t_file_2 + ".OLD" ( $ucx$l_status = f$search( ucx$t_file_1 ) $if ucx$l_status .nes. ""  $then : $ucx$l_status = f$file_attributes( ucx$t_file_1, "KNOWN" )A $if ucx$l_status .eqs. "TRUE" then $ install remove 'ucx$t_file_1 # $rename 'ucx$t_file_1 'ucx$t_file_2  $endif( $ucx$l_status = f$search( ucx$t_file_2 ) $if ucx$l_status .nes. ""  $then : $set message/nofacility/noidentification/noseverity/notext $delete/nolog 'ucx$t_file_2;* 2 $set message/facility/identification/severity/text $endif' $oldmessage == f$environment("MESSAGE") ; $set message /notext/nofacility/noidentification/noseverity 	 $set noon ) $delete/nolog sys$manager:ucx$fixup.com;*  $set message 'oldmessage'  $exit                                                                                                                                                                                                                                                                                                                                                                                                                                      : * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$FTPD_SHUTDOWN.COM;1 +  , a   .     / #   4 T       6                   - P    0   1    2   3      K  P   W   O     5   6 2|  7 v؛  8          9          G    H  J                     $ !+
$ !          UCX$FTPD_SHUTDOWN.COM -- Digital TCP/IP Services for OpenVMS Software, 
$ !					
$ !
$ !                         COPYRIGHT (C) 1993, 1997 BY
$ !                    DIGITAL EQUIPMENT CORPORATION, MAYNARD
$ !                     MASSACHUSETTS.  ALL RIGHTS RESERVED.
$ !
$ !  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
$ !  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
$ !  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
$ !  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
$ !  PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
$ !
$ !  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
$ !  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
$ !
$ !  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
$ !  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
$ !
$ ! Command procedure to shutdown:
$ !     1. UCX$FTPD
$ !
$ !
$ !	MODIFICATIONS:
$ !
$ ! 1997-02-11	Lee Tibbert	UCX V4.2-10
$ !		Only give "Server stopped" message if we actually stop 
$ !		server.
$ !--
$ !
$ !
$ REQUIRED_PRIVILEGES = "CMKRNL,OPER,WORLD,SYSPRV,SYSNAM"
$ PREV_PRIVS = F$SETPRV(REQUIRED_PRIVILEGES)
$ IF .NOT. F$PRIVILEGE(REQUIRED_PRIVILEGES) THEN GOTO NO_PRIVILEGES
$ !
$ SET NOON
$ IF F$TYPE (UCX$LICENSE_RUN) .EQS. "" -
	.OR. F$TYPE (UCX$LICENSE_APP) .EQS. "" 
$ THEN
$	@SYS$MANAGER:UCX$UCP_STARTUP
$ ENDIF
$ IF .NOT. UCX$LICENSE_RUN THEN GOTO FIND_FTP
$ DEFINE/USER SYS$OUTPUT NL:
$ DEFINE/USER SYS$ERROR NL:
$ UCX DISABLE SERVICE FTP
$ !
$ FIND_FTP:
$ ON CONTROL_Y THEN GOTO EXIT
$ ON ERROR THEN GOTO EXIT
$ !
$ !TEST CODE
$ !
$ PROCNAM := FTPC_
$ CONTEXT = ""
$ LOOP:
$ P1 = F$PID(CONTEXT)
$ IF P1 .EQS. "" THEN GOTO SHUT_FTPD
$ STAT = F$GETJPI(P1,"PRCNAM")
$ IF F$EXTRACT(0,5,STAT) .NES. PROCNAM THEN GOTO LOOP
$!
$ STOP PROCESS/ID= 'P1'
$ GOTO LOOP
$ !
$ SHUT_FTPD:
$ ON ERROR THEN GOTO EXIT
$ PROCNAM := UCX$FTPD
$ CONTEXT = ""
$ LOOP1:
$   P1 = F$PID(CONTEXT)
$   IF P1 .EQS. "" THEN GOTO DEINSTALL
$   IF F$GETJPI(P1,"PRCNAM") .NES. PROCNAM THEN GOTO LOOP1
$ !
$ !
$   STOP PROCESS/ID= 'P1'
$   WRITE SYS$OUTPUT "UCX$FTPD server stopped"
$ !
$ DEINSTALL:
$ !
$ ON WARNING THEN GOTO NO_SHARED
$ INSTALL := $INSTALL/COMMAND_MODE
$ !
$ LIBRARY = "SYS$SYSTEM:UCX$FTP.EXE"
$ IF F$FILE("''LIBRARY'","KNOWN") THEN INSTALL DELETE 'LIBRARY'
$ LIBRARY = "SYS$SYSTEM:UCX$FTPD.EXE"
$ IF F$FILE("''LIBRARY'","KNOWN") THEN INSTALL DELETE 'LIBRARY'
$ LIBRARY = "SYS$SYSTEM:UCX$FTPC.EXE"
$ IF F$FILE("''LIBRARY'","KNOWN") THEN INSTALL DELETE 'LIBRARY'
$ !
$ ON ERROR THEN GOTO EXIT
$ CONT_SHUT:
$ IF (F$TRNLNM("UCX$FTP_EXTLOG") .NES. "") -
	THEN DEASSIGN/SYSTEM/EXE UCX$FTP_EXTLOG
$ IF (F$TRNLNM("UCX$FTP_WNDSIZ") .NES. "") -
	THEN DEASSIGN/SYSTEM/EXE UCX$FTP_WNDSIZ
$ IF (F$TRNLNM("UCX$FTP_HOST") .NES. "") -
	THEN DEASSIGN/SYSTEM/EXE UCX$FTP_HOST
$ IF (F$TRNLNM( "UCX$FTPC_SES") .NES. "") -
	THEN DEASSIGN/SYSTEM/EXE UCX$FTPC_SES
$ !
$ !
$ EXIT:
$   PREV_PRIVS = F$SETPRV(PREV_PRIVS)
$ !
$ EXIT
$ NO_PRIVILEGES:
$ WRITE SYS$OUTPUT "Insufficient privileges to STOP the UCX$FTPD server"
$ WRITE SYS$OUTPUT "Required priviliges are '' REQUIRED_PRIVILEGES'"
$ GOTO EXIT
$ NO_SHARED:
$ WRITE SYS$OUTPUT "Failed to delete installed image"
$ WRITE SYS$OUTPUT "FTP server requires ''LIBRARY'"
$ GOTO CONT_SHUT 
                                                                                                                                                                                                                       9 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$FTPD_STARTUP.COM;1 +  , a   .     / #   4 B                          - P    0   1    2   3      K  P   W   O     5   6 1  7 %v؛  8          9          G    H  J                       $ !  $ ! B $ !  Copyright (c) Digital Equipment Corporation, 1990, 1992, 19936 $ !  All Rights Reserved.  Unpublished rights reserved3 $ !  under the copyright laws of the United States.  $ !   8 $ !  The software contained on this media is proprietary4 $ !  to and embodies the confidential technology of 5 $ !  Digital Equipment Corporation.  Possession, use, 5 $ !  duplication or dissemination of the software and 9 $ !  media is authorized only pursuant to a valid written 0 $ !  license from Digital Equipment Corporation. $ ! 5 $ !  RESTRICTED RIGHTS LEGEND   Use, duplication, or  4 $ !  disclosure by the U.S. Government is subject to9 $ !  restrictions as set forth in Subparagraph (c)(1)(ii) 3 $ !  of DFARS 252.227-7013, or in FAR 52.227-19, as  $ !  applicable. $ !+ $ ! $ $ SAVE=5+2*f$getsyi("CLUSTER_NODES") $ PURGE/KEEP='save' 7 $ DEFINE SYS$OUTPUT SYS$SYSDEVICE:[UCX$FTP]UCX$FTPD.LOG 6 $ DEFINE SYS$ERROR SYS$SYSDEVICE:[UCX$FTP]UCX$FTPD.LOG $ RUN SYS$SYSTEM:UCX$FTPD.EXE  $ !  $ EXIT                         6 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$FTPSERVER.COM;1 +  , a   .     / #   4 <       (                   - P    0   1    2   3      K  P   W   O     5   6 @>ӥ  7 av؛  8          9          G    H  J                          $ !  $ ! < $ !  Copyright (c) Digital Equipment Corporation, 1990, 19926 $ !  All Rights Reserved.  Unpublished rights reserved3 $ !  under the copyright laws of the United States.  $ !   8 $ !  The software contained on this media is proprietary4 $ !  to and embodies the confidential technology of 5 $ !  Digital Equipment Corporation.  Possession, use, 5 $ !  duplication or dissemination of the software and 9 $ !  media is authorized only pursuant to a valid written 0 $ !  license from Digital Equipment Corporation. $ ! 5 $ !  RESTRICTED RIGHTS LEGEND   Use, duplication, or  4 $ !  disclosure by the U.S. Government is subject to9 $ !  restrictions as set forth in Subparagraph (c)(1)(ii) 3 $ !  of DFARS 252.227-7013, or in FAR 52.227-19, as  $ !  applicable. $ !  $ RUN SYS$SYSTEM:UCX$FTPC                                                                                                                                                                                                                                                                             n                        }m $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1                                                                                                                       3 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1 +  , c   .     / #   4                             - P    0   1    2   3      K  P   W   O     5   6 a¤t؛  7 A@
v؛  8          9          G    H  J                              0 D `    0205        tX    b                                                
UCX$HR_MIB                             UCX V4.2-21    t؛ 05-13             P   Z           V [      \        
       ?   '      !        UCX$ACCESS_SHR_001 O    !       
MTHRTL_001      !        
LIBRTL_001$      +        CMA$TIS_SHR_001!      !         DECC$SHR_001          x      -warn -error -trace -d %s starting, Version %s
 0.1 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3 Initializing eSNMP connection... DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3  select returned:%s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3  time to send ARE_YOU_THERE
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3 Timeout waiting for response from master agent.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3  This process is a duplicate sub-agent.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3 Restarting protocol: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3 Terminating... DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3    USAGE: %s 
 SIGINT signal -exiting
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3  Poll timer
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3      Unable to get socket device channel for info.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3   Unable to get socket for inet info: %s.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OS_MIBS.C;3     X  v        %  :      Continue, everything is fine. Cannot Send OPEN to Master Agent. Cannot register the subtree, or not initialized. Received a CLOSE message. restart after a delay. Lost connection with Master Agent (snmpd). A negative response. Duplicate sub-agent. Another sub-agent with this name already running. Unknown error code                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  	                 	          8     	          8     	   ,       8     	   T              	   |              	                 	                         D      	      $	     D      
      T	  	   D            	     D            	     D    
      	     D            
     D            D
                 t
                 
  	               
                                  4                 d                                                        @            $     @            T                                                                    
     h            D
     h             t
     h      !      
     h      "      
     h      #           X      $      4     X      %      d     X      &           X      '           X      (           X      )      $     X      *      T     X  `  +           X  `  ,   	        (      -                 .                 /      <           0      l           1                 2                 3             ,  4      ,     <      5      \     <      6   	        H      7   	        H      8           P      9           P      :      <     P      ;      l     P      <           P      host 1.3.6.1.2.1.25                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             TBL_MACHINE_SLOT/$GETSPI DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_CPU.C;3 CPU %2.2x %s      do_slots/$GETSPI DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_CPU.C;3 upd_aug_from_slot/load_hr_device DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_CPU.C;3 Can't malloc slot_arrays DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_CPU.C;3 $GETSPI not found, hrProcessorLoad unavailable DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_CPU.C;3 CPU %2.2x %s EXE$GETSPI SPISHR        upd_aug_from_slot/hrm_cpu_get DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_CPU.C;3                                                                                                                                                                                                                                                           
                                                                                          
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     o                         $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1                                                                                                           "                                                                                                                                                                                                            Can't malloc new hrm_dev_t DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_DEV.C;3                                                                   _LT _FT _VT can't add disk entry DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_DEV.C;3     can't add network entry DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_DEV.C;3  _IM _IK _G  _SO _AU _VI _LR SYS$SYSDEVICE LNM$SYSTEM_TABLE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Can't allocate StrgCache entry. DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_STRG.C;3                                                                                                                                                                     $  hrm_strg Initial $GETSYI    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_STRG.C;3 PageFiles SwapFiles NonPagedPool  PagedPool GlobalPages GlobalSections      hrm_strg Refresh $GETSYI    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_STRG.C;3     
   (#                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               Can't malloc hrm_proc_t DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_SW.C;3                                                                                                                                                                                                                                                                                                  *       )      )                                                                                                                                                                                          SYS$TIMEZONE_DIFFERENTIAL LNM$SYSTEM_TABLE                          localtime: %i DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]HRM_SYS.C;3       %d                     +         h*                                                                                  eSNMP can't get Process ID.
  %s_%X eSNMP can't get master agent's address.
  esnmp   udp eSNMP well-known port is not defined.
 %s%d /tmp/esnmp_sub Trying to do registeration before calling esnmp_init().
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Timeout value %d is out of range.
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Subtree '%s' already marked for registeration
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Malloc error
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Trying to send registeration when not opened
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3   Register (%d) subtree '%s'
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 UNREGISTER request, subtree='%s', reason=%d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Could not send the ARE_YOU_THERE message
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 TRAP: Someone is doing a trap; %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Could not send TRAP message
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3                 Could not open socket:%s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 eSNMP can't get subagent's host address.
 BInding Socket to port %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Could not bind port %d to socket: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Sending (len=%d), %s, to %d.%d.%d.%d, port %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3   Can't send: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 recvfrom returned: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3     Invalid packet length: %d, received %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3 Received %s from %d.%d.%d.%d, port %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_INIT.C;3                                                                                                          0          3   4  4  4  4  4  "4  +4  64  <4  B4  I4  P4  X4  _4  f4  x4      ???Message With Zero for action code??? GET     GETNEXT SET TRAP RESPONSE REGISTER UNREGISTER OPEN  CLOSE COMMIT UNDO   GETBULK TRAPV2 INFORM ARE_YOU_THERE     CLEANUP     %s **ERROR %s line %d: %s %s WARNING %s line %d: %s %s %s%d.log /tmp/esnmp_sub  w Starting trace file for %s esnmp: %s  Starting tracefile for %s esnmp: %s a %s %s %s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  0:     8:     ?:     J:     S:     \:     c:     l:     x:  	   :  
   :     :     :  
   :     :     :     :     :     ;  P   ;  Q   (;  e   5;  f   D;  g   R;  h   h;  i   ;  j   ;  k   ;  l   ;  m   ;  n   <  o   *<  p   P<  q   ^<          noError tooBig noSuchName badValue readOnly genErr noAccess wrongType   wrongLength wrongEncoding wrongValue noCreation inconsistentValue   resourceUnavailable commitFailed undoFailed authorizationError  notWritable inconsistentName NoSuchInstance NoSuchObject DPI_otherError DPI_notFound  DPI_alreadyRegistered DPI_higherPriorityRegistered  DPI_mustOpenFirst DPI_notAuthorized DPI_viewSelectionNotSupported DPI_getBulkSelectionNotSupported        DPI_duplicateSubAgentIdentifier DPI_invalidDisplayString  DPI_characterSetSelectionNotSupported DPI_dataError DPI_resourceError Unknown error type %*.*s%s - %s%s, packet id=%d         ALONE,      V1  V2      Unknown Version DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3    , non-repeaters=%d, max-repetitions=%d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3    , error_index=%d, error_code=%d %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3    %*.*s  argument=%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 %*.*sVARBIND OID=%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 %*.*s  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Integer32 = %ld
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Counter32 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Gauge32 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 TimeTicks = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 UInteger32 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Counter64 = %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 OctetString =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 IpAddress =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3  DisplayString = "%.*s%s"
 ...too big  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 NsapAddress =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3  Opaque =  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 BitString =  DISK$UCX_BUILD2:[UCX.X42.BL21.                                                                                                                                                                                                                                                   p                        ֝ $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1                                                                                                          _ "     "       SRC.SNMP]ESNMP_LOG.C;3 ObjectId = "%s"
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3  Exception = noSuchObject
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3    Exception = noSuchInstance
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3  Exception = endOfMibView
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Null-type
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 Invalid data type: 0x%X
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3  -nill-
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 (len=%d) 0x[   %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 %*.*s%s
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3    %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 %02x %*.*s%s]
   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3 %s]
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LOG.C;3                                        esnmp_poll: Could not process a packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Incoming Packet
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     Resulting Packet
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3         dispatch - RESPONSE, packet_id=%d %s
   from OPEN from REGISTER DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 RESPONSE to OPEN: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 RESPONSE to OPEN: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 RESPONSE to REGISTRATION of '%s': %s
   Unknown DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     RESPONSE to REGISTRATION of '%s': OK
 Unknown DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Bad response to ARE-YOU-THERE, restart
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 DPI CLOSE received from agent, reason=%d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   dispatch UNREGISTER
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Unexpected DPI packet type %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        requested oid:%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        object id:%d, dots:%s    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        no object found,   DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Not a readable object
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3  Method Routine returns: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Method routine returned invalid status: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     %2d requested oid: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        no more objects found
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        try obj id:%-3d %s (subtree '%s')  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Not a readable object
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 (as a GET)  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3    Method Routine returns: %s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        Instance out of range
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Method routine returned invalid status: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Extending varbind list one more repeating section
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 SET - test phase, pass 1
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3        requested obj idx:%d, object:%s, dots:%s
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3              requested oid:%s, object:-null-
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 No object found in object table
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 No set function for this MIB variable
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Data is of the wrong type; should be %d
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 No instance in the varbind's OID
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Out of memory during a set
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 An error has been declared in index %d; cleaning up
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 SET - test phase, pass 2
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Method routine returned unknown status: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 method routine declared an error; %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   SET - commit phase
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3   Method routine declared an error during COMMIT
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Method routine declared an error during UNDO
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 SET - undo phase
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Method routine declared an error during UNDO
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3 Invalid data type: 0x%X
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_POLL.C;3     0 Out of Memory
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3  %s%u . Out of memory
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 Out of memory
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 o_integer; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3   o_integer; value out of range; %lx
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 Cannot use o_integer for this object type; %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 o_octet; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3  o_octet; value too big for IpAddress
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3  o_octet; value too big for DisplayString
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 o_octet; Invalid first byte
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 o_oid; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3  o_string; Null Varbind or object
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3    o_string; IpAddress does not have length 4
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3        o_string; Wrong data type for a string
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3 gettimeofday returned failure
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_LIB.C;3        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated      ESNMPD_SHARED_MEMORY    01-JAN-1970 00:00:00.00      \  \  \  \  \  ]  ]  ]   ]  .]  UNDEFINED CONDITION ALERT SUBALERT  EMERGENCY ERROR CRITICAL    WARNING NOTICE  INFORMATIONAL DEBUG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      %s:  
 esnmp_pack: No hdr and Varbind to pack
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3           Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 Too Big
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3 Pack: Invalid data type: 0x%X
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_PACK.C;3   esnmp_unpack: No packet to unpack
      DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Unexpected protocol type: 0x%X
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Invalid security packet length: %d
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 No Memory - packet dropped
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Unrecognized packet type: 0x%X
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Empty Get request packet
       DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Invalid starting OID format in packet:'%s'
     DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Invalid ending OID format in packet:'%s'
       DISK$UCX                                                                                                                                                                                                                                                   q                        s9 $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1                                                                                                          q "     3       _BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Badly formed DPI packet, length error
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Badly formed DPI packet, length error
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Invalid data type: 0x%X
        DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 Out of memory
  DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]ESNMP_UNPACK.C;3 e  @(#)$RCSfile: prnt_lib.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/12/19 16:53:03 $        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated  
Packet Dump: 
 %2.2x         
 PrintVarBindList, vb_ptr->name:
    DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;3 %s =    %u
 %d
 %d.%d.%d.%d
    PrintVarBindList, vb_ptr->value.oid_value:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;3 %s
 NULL
 PrintVarBindList: Illegal type: 0x%x
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]PRNT_LIB.C;3 
 %c  
                                                                                                                                                                                                                                %s               at line %d in file %s
 Error code set in packet -      Return packet too big.
 No such variable name.  Index:  %d.
  Bad variable value.  Index:  %d.
 Read only variable:  %d.
 General error:  %d.
 Unknown status code:  %d.
       i  @(#)$RCSfile: oid_lib.c,v $ $Revision: 1.1.4.2 $ (DEC) $Date: 1995/04/27 19:27:50 $ SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated       v  &v  (v  ,v  0v  4v  8v  <v  Bv  Pv  Xv  bv  lv  rv  |v  v  v  v  v  v  v  v  v  v   w  w   w  (w  8w  Hw  Xw  hw  xw  w  w  w  w  w  w  w  w  w  x  x  $x  ,x  @x  Hx  `x  hx  |x  x  x  x  x  x  x  x  y  y  ,y  :y  Oy  ^y  sy  y  y  y  y  y  y  y  z  z  (z  8z  Nz  \z  tz  z  z  z  z  z  z  z  z  z   {  {  {  ${  8{  H{  \{  l{  {  {  {  {  {  {  {  {  {   |  |   |  0|  @|  P|  h|  x|  |  |  |  |  |  |  |  |  }  }  &}  7}  D}  U}  `}  q}  ~}  }  }  }  }  }  }  }  }  ~  ~  ,~  8~  M~  \~  q~  ~  ~  ~  ~  ~  ~  ~      $  0  E  T  i  x                     ,  A  N  c  n          ̀  ؀         $  8  L  h          ҁ            0  @  P  `  x          Ȃ              0  @  P  a  t          ԃ          (  <  M  ^  o          Ƅ  ׄ          ,  =  R  c  t          ȅ  ؅          (  8  H  X  h  x          Ȇ  ؆            .  ?  L  ]  j  }        ɇ  ڇ        &  <  F  W  b  t  x          Ȉ  ؈          (  2  H  X  l  |            Љ              0  @  N  `  p          Ȋ  ؊           8  H  \  p          ҋ        %  :  O  \  q          Ō  Ԍ  ڌ          4  F  \  p        ʍ        .  H  `  z        ؎         :  X  x      ȏ        ,  H  \  w        ؐ      ,  H  T  h  z        Б        (  B  f        ޒ      ,  D  ^  v      ē  ۓ      ,  J  f  |      Ȕ  ؔ      $  8  X  h        ԕ        2  M  l        Ԗ        2  N  h        ė  ߗ         $  8  N  `  v        И        *  B  \  |      Й        4  N  h        Ԛ        /  F  h        ϛ        /  D  _  x      Ü  ڜ      ,  @  [  n        ʝ        (  @  \  x      Ȟ    
  $  F  `        ֟        (  <  R  j              Π        !  8  I  \  n  |        ȡ          "  6  H  \  n          Ƣ  آ           .  @  T  f  x          أ           4  F  T  f  |            ¤  Ф            .  >  P  ^  p          ĥ  ֥           0  >  P  `  r          Ҧ        (  @  R  l        ʧ  ܧ        ,  @  T  h  {        ͨ          (  <  P  d  n  |          Щ           (  8  F  X  h  z        ƪ  ت        &  8  J  ^  p          ث           ,  8  D  J  X  `  p  ~            Ь          ccitt 0 iso 1   org 1.3 dod 1.3.6 internet      1.3.6.1 directory 1.3.6.1.1 mgmt  1.3.6.1.2 mib_2   1.3.6.1.2.1 system  1.3.6.1.2.1.1 sysDescr  1.3.6.1.2.1.1.1 sysObjectID     1.3.6.1.2.1.1.2 sysUpTime       1.3.6.1.2.1.1.3 sysContact      1.3.6.1.2.1.1.4 sysName 1.3.6.1.2.1.1.5 sysLocation     1.3.6.1.2.1.1.6 sysServices     1.3.6.1.2.1.1.7 interfaces  1.3.6.1.2.1.2 ifNumber      1.3.6.1.2.1.2.1 ifTable 1.3.6.1.2.1.2.2 ifEntry 1.3.6.1.2.1.2.2.1       ifIndex 1.3.6.1.2.1.2.2.1.1     ifDescr 1.3.6.1.2.1.2.2.1.2 ifType  1.3.6.1.2.1.2.2.1.3 ifMtu   1.3.6.1.2.1.2.2.1.4     ifSpeed 1.3.6.1.2.1.2.2.1.5 ifPhysAddress   1.3.6.1.2.1.2.2.1.6 ifAdminStatus   1.3.6.1.2.1.2.2.1.7 ifOperStatus    1.3.6.1.2.1.2.2.1.8 ifLastChange    1.3.6.1.2.1.2.2.1.9 ifInOctets 1.3.6.1.2.1.2.2.1.10 ifInUcastPkts 1.3.6.1.2.1.2.2.1.11 ifInNUcastPkts 1.3.6.1.2.1.2.2.1.12 ifInDiscards 1.3.6.1.2.1.2.2.1.13 ifInErrors 1.3.6.1.2.1.2.2.1.14  ifInUnknownProtos 1.3.6.1.2.1.2.2.1.15    ifOutOctets 1.3.6.1.2.1.2.2.1.16 ifOutUcastPkts 1.3.6.1.2.1.2.2.1.17    ifOutNUcastPkts 1.3.6.1.2.1.2.2.1.18  ifOutDiscards 1.3.6.1.2.1.2.2.1.19    ifOutErrors 1.3.6.1.2.1.2.2.1.20  ifOutQLen 1.3.6.1.2.1.2.2.1.21 ifSpecific 1.3.6.1.2.1.2.2.1.22 at 1.3.6.1.2.1.3   atTable 1.3.6.1.2.1.3.1 atEntry 1.3.6.1.2.1.3.1.1 atIfIndex 1.3.6.1.2.1.3.1.1.1 atPhysAddress   1.3.6.1.2.1.3.1.1.2 atNetAddress    1.3.6.1.2.1.3.1.1.3 ip  1.3.6.1.2.1.4 ipForwarding  1.3.6.1.2.1.4.1 ipDefaultTTL    1.3.6.1.2.1.4.2 ipInReceives    1.3.6.1.2.1.4.3 ipInHdrErrors   1.3.6.1.2.1.4.4 ipInAddrErrors  1.3.6.1.2.1.4.5 ipForwDatagrams 1.3.6.1.2.1.4.6 ipInUnknownProtos       1.3.6.1.2.1.4.7 ipInDiscards    1.3.6.1.2.1.4.8 ipInDelivers    1.3.6.1.2.1.4.9 ipOutRequests 1.3.6.1.2.1.4.10  ipOutDiscards 1.3.6.1.2.1.4.11  ipOutNoRoutes 1.3.6.1.2.1.4.12 ipReasmTimeout 1.3.6.1.2.1.4.13 ipReasmReqds 1.3.6.1.2.1.4.14 ipReasmOKs 1.3.6.1.2.1.4.15 ipReasmFails 1.3.6.1.2.1.4.16  ipFragOKs 1.3.6.1.2.1.4.17  ipFragFails 1.3.6.1.2.1.4.18  ipFragCreates 1.3.6.1.2.1.4.19    ipAddrTable 1.3.6.1.2.1.4.20    ipAddrEntry 1.3.6.1.2.1.4.20.1  ipAdEntAddr 1.3.6.1.2.1.4.20.1.1 ipAdEntIfIndex 1.3.6.1.2.1.4.20.1.2 ipAdEntNetMask 1.3.6.1.2.1.4.20.1.3 ipAdEntBcastAddr 1.3.6.1.2.1.4.20.1.4  ipAdEntReasmMaxSize 1.3.6.1.2.1.4.20.1.5 ipRouteTable 1.3.6.1.2.1.4.21 ipRouteEntry 1.3.6.1.2.1.4.21.1  ipRouteDest 1.3.6.1.2.1.4.21.1.1 ipRouteIfIndex 1.3.6.1.2.1.4.21.1.2 ipRouteMetric1 1.3.6.1.2.1.4.21.1.3 ipRouteMetric2 1.3.6.1.2.1.4.21.1.4 ipRouteMetric3 1.3.6.1.2.1.4.21.1.5 ipRouteMetric4 1.3.6.1.2.1.4.21.1.6 ipRouteNextHop 1.3.6.1.2.1.4.21.1.7    ipRouteType 1.3.6.1.2.1.4.21.1.8 ipRouteProto 1.3.6.1.2.1.4.21.1.9 ipRouteAge 1.3.6.1.2.1.4.21.1.10 ipRouteMask 1.3.6.1.2.1.4.21.1.11 ipRouteMetric5  1.3.6.1.2.1.4.21.1.12 ipRouteInfo 1.3.6.1.2.1.4.21.1.13 ipNetToMediaTable 1.3.6.1.2.1.4.22  ipNetToMediaEntry 1.3.6.1.2.1.4.22.1  ipNetToMediaIfIndex 1.3.6.1.2.1.4.22.1.1        ipNetToMediaPhysAddress 1.3.6.1.2.1.4.22.1.2 ipNetToMediaNetAddress 1.3.6.1.2.1.4.22.1.3 ipNetToMediaType 1.3.6.1.2.1.4.22.1.4  ipRoutingDiscards 1.3.6.1.2.1.4.23 icmp 1.3.6.1.2.1.5 icmpInMsgs        1.3.6.1.2.1.5.1 icmpInErrors    1.3.6.1.2.1.5.2 icmpInDestUnreachs      1.3.6.1.2.1.5.3 icmpInTimeExcds 1.3.6.1.2.1.5.4 icmpInParmProbs 1.3.6.1.2.1.5.5 icmpInSrcQuenchs        1.3.6.1.2.1.5.6 icmpInRedirects 1.3.6.1.2.1.5.7 icmpInEchos     1.3.6.1.2.1.5.8 icmpInEchoReps  1.3.6.1.2.1.5.9 icmpInTimestamps 1.3.6.1.2.1.5.10   icmpInTimestampReps 1.3.6.1.2.1.5.11        icmpInAddrMasks 1.3.6.1.2.1.5.12 icmpInAddrMaskReps 1.3.6.1.2.1.5.13    icmpOutMsgs 1.3.6.1.2.1.5.14  icmpOutErrors 1.3.6.1.2.1.5.15    icmpOutDestUnreachs 1.3.6.1.2.1.5.16 icmpOutTimeExcds 1.3.6.1.2.1.5.17 icmpOutParmProbs 1.3.6.1.2.1.5.18  icmpOutSrcQuenchs 1.3.6.1.2.1.5.19 icmpOutRedirects 1.3.6.1.2.1.5.20 icmpOutEchos 1.3.6.1.2.1.5.21    icmpOutEchoReps 1.3.6.1.2.1.5.22  icmpOutTimestamps 1.3.6.1.2.1.5.23 icmpOutTimestampReps 1.3.6.1.2.1.5.24 icmpOutAddrMasks 1.3.6.1.2.1.5.25    icmpOutAddrMaskReps 1.3.6.1.2.1.5.26    tcp 1.3.6.1.2.1.6       tcpRtoAlgorithm 1.3.6.1.2.1.6.1 tcpRtoMin       1.3.6.1.                                                                                                                                                                                                                                                   r                        S $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1                                                                                                          , "     D       2.1.6.2 tcpRtoMax       1.3.6.1.2.1.6.3 tcpMaxConn      1.3.6.1.2.1.6.4 tcpActiveOpens  1.3.6.1.2.1.6.5 tcpPassiveOpens 1.3.6.1.2.1.6.6 tcpAttemptFails 1.3.6.1.2.1.6.7 tcpEstabResets  1.3.6.1.2.1.6.8 tcpCurrEstab    1.3.6.1.2.1.6.9 tcpInSegs 1.3.6.1.2.1.6.10 tcpOutSegs 1.3.6.1.2.1.6.11 tcpRetransSegs 1.3.6.1.2.1.6.12 tcpConnTable 1.3.6.1.2.1.6.13 tcpConnEntry 1.3.6.1.2.1.6.13.1 tcpConnState 1.3.6.1.2.1.6.13.1.1  tcpConnLocalAddress 1.3.6.1.2.1.6.13.1.2 tcpConnLocalPort 1.3.6.1.2.1.6.13.1.3  tcpConnRemAddress 1.3.6.1.2.1.6.13.1.4 tcpConnRemPort 1.3.6.1.2.1.6.13.1.5  tcpInErrs 1.3.6.1.2.1.6.14 tcpOutRsts 1.3.6.1.2.1.6.15  udp 1.3.6.1.2.1.7 udpInDatagrams    1.3.6.1.2.1.7.1 udpNoPorts      1.3.6.1.2.1.7.2 udpInErrors     1.3.6.1.2.1.7.3 udpOutDatagrams 1.3.6.1.2.1.7.4 udpTable        1.3.6.1.2.1.7.5 udpEntry  1.3.6.1.2.1.7.5.1     udpLocalAddress 1.3.6.1.2.1.7.5.1.1 udpLocalPort    1.3.6.1.2.1.7.5.1.2 egp 1.3.6.1.2.1.8 egpInMsgs     1.3.6.1.2.1.8.1 egpInErrors     1.3.6.1.2.1.8.2 egpOutMsgs      1.3.6.1.2.1.8.3 egpOutErrors    1.3.6.1.2.1.8.4 egpNeighTable   1.3.6.1.2.1.8.5 egpNeighEntry 1.3.6.1.2.1.8.5.1 egpNeighState   1.3.6.1.2.1.8.5.1.1 egpNeighAddr    1.3.6.1.2.1.8.5.1.2 egpNeighAs  1.3.6.1.2.1.8.5.1.3 egpNeighInMsgs  1.3.6.1.2.1.8.5.1.4 egpNeighInErrs  1.3.6.1.2.1.8.5.1.5 egpNeighOutMsgs 1.3.6.1.2.1.8.5.1.6     egpNeighOutErrs 1.3.6.1.2.1.8.5.1.7 egpNeighInErrMsgs   1.3.6.1.2.1.8.5.1.8 egpNeighOutErrMsgs  1.3.6.1.2.1.8.5.1.9 egpNeighStateUps 1.3.6.1.2.1.8.5.1.10 egpNeighStateDowns 1.3.6.1.2.1.8.5.1.11 egpNeighIntervalHello 1.3.6.1.2.1.8.5.1.12 egpNeighIntervalPoll 1.3.6.1.2.1.8.5.1.13 egpNeighMode 1.3.6.1.2.1.8.5.1.14 egpNeighEventTrigger 1.3.6.1.2.1.8.5.1.15  egpAs       1.3.6.1.2.1.8.6 transmission 1.3.6.1.2.1.10 fddi  1.3.6.1.2.1.10.15 snmpFddiSMT 1.3.6.1.2.1.10.15.1 snmpFddiSMTNumber 1.3.6.1.2.1.10.15.1.1 snmpFddiSMTTable  1.3.6.1.2.1.10.15.1.2 snmpFddiSMTEntry    1.3.6.1.2.1.10.15.1.2.1 snmpFddiSMTIndex  1.3.6.1.2.1.10.15.1.2.1.1 snmpFddiSMTStationId  1.3.6.1.2.1.10.15.1.2.1.2 snmpFddiSMTOpVersionId  1.3.6.1.2.1.10.15.1.2.1.3 snmpFddiSMTHiVersionId  1.3.6.1.2.1.10.15.1.2.1.4 snmpFddiSMTLoVersionId  1.3.6.1.2.1.10.15.1.2.1.5 snmpFddiSMTMACCt  1.3.6.1.2.1.10.15.1.2.1.6 snmpFddiSMTNonMasterCt  1.3.6.1.2.1.10.15.1.2.1.7 snmpFddiSMTMasterCt 1.3.6.1.2.1.10.15.1.2.1.8 snmpFddiSMTPathsAvailable 1.3.6.1.2.1.10.15.1.2.1.9 snmpFddiSMTConfigCapabilities 1.3.6.1.2.1.10.15.1.2.1.10      snmpFddiSMTConfigPolicy 1.3.6.1.2.1.10.15.1.2.1.11  snmpFddiSMTConnectionPolicy 1.3.6.1.2.1.10.15.1.2.1.12 snmpFddiSMTTNotify 1.3.6.1.2.1.10.15.1.2.1.13 snmpFddiSMTStatusReporting 1.3.6.1.2.1.10.15.1.2.1.14  snmpFddiSMTECMState 1.3.6.1.2.1.10.15.1.2.1.15 snmpFddiSMTCFState 1.3.6.1.2.1.10.15.1.2.1.16 snmpFddiSMTHoldState 1.3.6.1.2.1.10.15.1.2.1.17    snmpFddiSMTRemoteDisconnectFlag 1.3.6.1.2.1.10.15.1.2.1.18 snmpFddiSMTStationAction 1.3.6.1.2.1.10.15.1.2.1.19  snmpFddiMAC 1.3.6.1.2.1.10.15.2 snmpFddiMACNumber 1.3.6.1.2.1.10.15.2.1 snmpFddiMACTable  1.3.6.1.2.1.10.15.2.2 snmpFddiMACEntry        1.3.6.1.2.1.10.15.2.2.1 snmpFddiMACSMTIndex 1.3.6.1.2.1.10.15.2.2.1.1 snmpFddiMACIndex  1.3.6.1.2.1.10.15.2.2.1.2 snmpFddiMACFrameStatusCapabilities  1.3.6.1.2.1.10.15.2.2.1.3 snmpFddiMACTMaxGreatestLowerBound 1.3.6.1.2.1.10.15.2.2.1.4 snmpFddiMACTVXGreatestLowerBound  1.3.6.1.2.1.10.15.2.2.1.5 snmpFddiMACPathsAvailable 1.3.6.1.2.1.10.15.2.2.1.6 snmpFddiMACCurrentPath  1.3.6.1.2.1.10.15.2.2.1.7 snmpFddiMACUpstreamNbr  1.3.6.1.2.1.10.15.2.2.1.8 snmpFddiMACOldUpstreamNbr 1.3.6.1.2.1.10.15.2.2.1.9 snmpFddiMACDupAddrTest 1.3.6.1.2.1.10.15.2.2.1.10 snmpFddiMACPathsRequested 1.3.6.1.2.1.10.15.2.2.1.11  snmpFddiMACDownstreamPORTType 1.3.6.1.2.1.10.15.2.2.1.12  snmpFddiMACSMTAddress 1.3.6.1.2.1.10.15.2.2.1.13  snmpFddiMACTReq 1.3.6.1.2.1.10.15.2.2.1.14      snmpFddiMACTNeg 1.3.6.1.2.1.10.15.2.2.1.15      snmpFddiMACTMax 1.3.6.1.2.1.10.15.2.2.1.16  snmpFddiMACTvxValue 1.3.6.1.2.1.10.15.2.2.1.17      snmpFddiMACTMin 1.3.6.1.2.1.10.15.2.2.1.18  snmpFddiMACCurrentFrameStatus 1.3.6.1.2.1.10.15.2.2.1.19    snmpFddiMACFrameCts 1.3.6.1.2.1.10.15.2.2.1.20  snmpFddiMACErrorCts 1.3.6.1.2.1.10.15.2.2.1.21 snmpFddiMACLostCts 1.3.6.1.2.1.10.15.2.2.1.22 snmpFddiMACFrameErrorThreshold 1.3.6.1.2.1.10.15.2.2.1.23 snmpFddiMACFrameErrorRatio 1.3.6.1.2.1.10.15.2.2.1.24    snmpFddiMACRMTState 1.3.6.1.2.1.10.15.2.2.1.25  snmpFddiMACDaFlag 1.3.6.1.2.1.10.15.2.2.1.26 snmpFddiMACUnaDaFlag 1.3.6.1.2.1.10.15.2.2.1.27  snmpFddiMACFrameCondition 1.3.6.1.2.1.10.15.2.2.1.28 snmpFddiMACChipSet 1.3.6.1.2.1.10.15.2.2.1.29  snmpFddiMACAction 1.3.6.1.2.1.10.15.2.2.1.30 snmpFddiPATH 1.3.6.1.2.1.10.15.3 snmpFddiPORT    1.3.6.1.2.1.10.15.4 snmpFddiPORTNumber  1.3.6.1.2.1.10.15.4.1 snmpFddiPORTTable 1.3.6.1.2.1.10.15.4.2 snmpFddiPORTEntry 1.3.6.1.2.1.10.15.4.2.1 snmpFddiPORTSMTIndex  1.3.6.1.2.1.10.15.4.2.1.1 snmpFddiPORTIndex 1.3.6.1.2.1.10.15.4.2.1.2 snmpFddiPORTPCType  1.3.6.1.2.1.10.15.4.2.1.3 snmpFddiPORTPCNeighbor  1.3.6.1.2.1.10.15.4.2.1.4 snmpFddiPORTConnectionPolicies  1.3.6.1.2.1.10.15.4.2.1.5 snmpFddiPORTRemoteMACIndicated  1.3.6.1.2.1.10.15.4.2.1.6 snmpFddiPORTCEState 1.3.6.1.2.1.10.15.4.2.1.7 snmpFddiPORTPathsRequested  1.3.6.1.2.1.10.15.4.2.1.8 snmpFddiPORTMACPlacement  1.3.6.1.2.1.10.15.4.2.1.9 snmpFddiPORTAvailablePaths 1.3.6.1.2.1.10.15.4.2.1.10   snmpFddiPORTMACLoopTime 1.3.6.1.2.1.10.15.4.2.1.11  snmpFddiPORTTBMax 1.3.6.1.2.1.10.15.4.2.1.12 snmpFddiPORTBSFlag 1.3.6.1.2.1.10.15.4.2.1.13 snmpFddiPORTLCTFailCts 1.3.6.1.2.1.10.15.4.2.1.14        snmpFddiPORTLerEstimate 1.3.6.1.2.1.10.15.4.2.1.15 snmpFddiPORTLemRejectCts 1.3.6.1.2.1.10.15.4.2.1.16 snmpFddiPORTLemCts 1.3.6.1.2.1.10.15.4.2.1.17  snmpFddiPORTLerCutoff 1.3.6.1.2.1.10.15.4.2.1.18 snmpFddiPORTLerAlarm 1.3.6.1.2.1.10.15.4.2.1.19 snmpFddiPORTConnectState 1.3.6.1.2.1.10.15.4.2.1.20 snmpFddiPORTPCMState 1.3.6.1.2.1.10.15.4.2.1.21 snmpFddiPORTPCWithhold 1.3.6.1.2.1.10.15.4.2.1.22 snmpFddiPORTLerCondition 1.3.6.1.2.1.10.15.4.2.1.23    snmpFddiPORTChipSet 1.3.6.1.2.1.10.15.4.2.1.24 snmpFddiPORTAction 1.3.6.1.2.1.10.15.4.2.1.25 snmpFddiATTACHMENT 1.3.6.1.2.1.10.15.5 snmpFddiATTACHMENTNumber  1.3.6.1.2.1.10.15.5.1 snmpFddiATTACHMENTTable 1.3.6.1.2.1.10.15.5.2   snmpFddiATTACHMENTEntry 1.3.6.1.2.1.10.15.5.2.1 snmpFddiATTACHMENTSMTIndex  1.3.6.1.2.1.10.15.5.2.1.1   snmpFddiATTACHMENTIndex 1.3.6.1.2.1.10.15.5.2.1.2       snmpFddiATTACHMENTClass 1.3.6.1.2.1.10.15.5.2.1.3 snmpFddiATTACHMENTOpticalBypassPresent  1.3.6.1.2.1.10.15.5.2.1.4 snmpFddiATTACHMENTIMaxExpiration  1.3.6.1.2.1.10.15.5.2.1.5 snmpFddiATTACHMENTInsertedStatus  1.3.6.1.2.1.10.15.5.2.1.6 snmpFddiATTACHMENTInsertPolicy  1.3.6.1.2.1.10.15.5.2.1.7 snmpFddiChipSets  1.3.6.1.2.1.10.15.6 snmpFddiPHYChipSets 1.3.6.1.2.1.10.15.6.1   snmpFddiMACChipSets 1.3.6.1.2.1.10.15.6.2 snmpFddiPHYMACChipSets  1.3.6.1.2.1.10.15.6.3 snmp 1.3.6.1.2.1.11 snmpInPkts 1.3.6.1.2.1.11.1 snmpOutPkts 1.3.6.1.2.1.11.2  snmpInBadVersions 1.3.6.1.2.1.11.3        snmpInBadCommunityNames 1.3.6.1.2.1.11.4 snmpInBadCommunityUses 1.3.6.1.2.1.11.5 snmpInASNParseErrs 1.3.6.1.2.1.11.6  snmpInTooBigs 1.3.6.1.2.1.11.8  snmpInNoSuchNames 1.3.6.1.2.1.11.9        snmpInBadValues 1.3.6.1.2.1.11.10       snmpInReadOnlys 1.3.6.1.2.1.11.11 snmpInGenErrs 1.3.6.1.2.1.11.12 snmpInTotalReqVars  1.3.6.1.2.1.11.13 snmpInTotalSetVars  1.3.6.1.2.1.11.14 snmpInGetRequests 1.3.6.1.2.1.11.15 snmpInGetNexts  1.3.6.1.2.1.11.16 snmpInSetRequests 1.3.6.1.2.1.11.17 snmpInGetResponses  1.3.6.1.2.1.11.18   snmpInTraps 1.3.6.1.2.1.11.19 snmpOutTooBigs  1.3.6.1.2.1.11.20 snmpOutNoSuchNames  1.3.6.1.2.1.11.21 snmpOutBadValues  1.3.6.1.2.1.11.22 snmpOutGenErrs  1.3.6.1.2.1.11.24 snmpOutGetRequests  1.3.6.1.2.1.11.25       snmpOutGetNexts 1.3.6.1.2.1.11.26 snmpOutSetRequests  1.3.6.1.2.1.11.27 snmpOutGetResponses 1.3.6.1.2.1.11.28 snmpOutTraps  1.3.6.1.2.1.11.29 snmpEnableAuthenTraps 1.3.6.1.2.1.11.30 experimental  1.3.6.1.3 dot5  1.3.6.1.3.4 dot5Table 1.3.6.1.3.4.1 dot5Entry       1.3.6.1.3.4.1.1 dot5IfIndex 1.3.6.1.3.4.1.1.1 dot5Commands  1.3.6.1.3.4.1.1.2 dot5RingStatus  1.3.6.1.3.4.1.1.3 dot5RingState 1.3.6.1.3.4.1.1.4 dot5RingOpenStatus  1.3.6.1.3.4.1.1.5 dot5RingSpeed 1.3.6.1.3.4.1.1.6 dot5UpStream  1.3.6.1.3.4.1.1.7 dot5ActMonParticipate 1.3.6.1.3.4.1.1.8 dot5Functional  1.3.6.1.3.4.1.1.9 dot5StatsTable  1.3.6.1.3.4.2 dot5StatsEntry    1.3.6.1.3.4.2.1 dot5StatsIfIndex  1.3.6.1.3.4.2.1.1 dot5StatsLineErrors 1.3.6.1.3.4.2.1.2 dot5StatsBurstErrors  1.3.6.1.3.4.2.1.3 dot5StatsACErrors 1.3.6.1.3.4.2.1.4 dot5StatsAbortTransErrors 1.3.6.1.3.4.2.1.5       dot5StatsInternalErrors 1.3.6.1.3.4.2.1.6 dot5StatsLostFrameErrors  1.3.6.1.3.4.2.1.7   dot5StatsReceiveCongestions 1.3.6.1.3.4.2.1.8 dot5StatsFrameCopiedErrors  1.3.6.1.3.4.2.1.9 dot5StatsTokenErrors 1.3.6.1.3.4.2.1                                                                                                                                                                                                                                                   s                        W; $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1                                                                                                          H "     U       .10 dot5StatsSoftErrors 1.3.6.1.3.4.2.1.11  dot5StatsHardErrors 1.3.6.1.3.4.2.1.12  dot5StatsSignalLoss 1.3.6.1.3.4.2.1.13 dot5StatsTransmitBeacons 1.3.6.1.3.4.2.1.14 dot5StatsRecoverys 1.3.6.1.3.4.2.1.15 dot5StatsLobeWires 1.3.6.1.3.4.2.1.16 dot5StatsRemoves 1.3.6.1.3.4.2.1.17 dot5StatsSingles 1.3.6.1.3.4.2.1.18  dot5StatsFreqErrors 1.3.6.1.3.4.2.1.19  dot5Tests 1.3.6.1.3.4.3 testInsertFunc      1.3.6.1.3.4.3.1 dot5ChipSets  1.3.6.1.3.4.4 chipSetIBM16        1.3.6.1.3.4.4.1 chipSetTItms380 1.3.6.1.3.4.4.2 chipSetTItms380c16      1.3.6.1.3.4.4.3 dot5TimerTable  1.3.6.1.3.4.5 dot5TimerEntry    1.3.6.1.3.4.5.1 dot5TimerIfIndex  1.3.6.1.3.4.5.1.1 dot5TimerReturnRepeat 1.3.6.1.3.4.5.1.2 dot5TimerHolding  1.3.6.1.3.4.5.1.3 dot5TimerQueuePDU 1.3.6.1.3.4.5.1.4 dot5TimerValidTransmit  1.3.6.1.3.4.5.1.5 dot5TimerNoToken  1.3.6.1.3.4.5.1.6 dot5TimerActiveMon  1.3.6.1.3.4.5.1.7 dot5TimerStandbyMon 1.3.6.1.3.4.5.1.8 dot5TimerErrorReport  1.3.6.1.3.4.5.1.9   dot5TimerBeaconTransmit 1.3.6.1.3.4.5.1.10 dot5TimerBeaconReceive 1.3.6.1.3.4.5.1.11    private 1.3.6.1.4   enterprises 1.3.6.1.4.1 unix  1.3.6.1.4.1.4 agents  1.3.6.1.4.1.4.1 fourBSD_isode 1.3.6.1.4.1.4.1.2 peers   1.3.6.1.4.1.4.3 unixd 1.3.6.1.4.1.4.3.1 joint_iso_ccitt 2 MakeOIDFragFromDot, table lookup failed: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3   MakeOIDFragFromDot, oid_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFragFromDot, oid_ptr->oid_ptr malloc
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  MakeOIDFragFromDot, hex:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3    MakeOIDFragFromDot, octal:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  MakeOIDFragFromDot, decimal:
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFragFromDot, bad character: %d, %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFragFromDot, expected dot: %d %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeOIDFromDot, illegal OID value %lu
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  ParseSubIdHex, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  %1x ParseSubIdHex, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3       ParseSubIdOctal, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3  %1o ParseSubIdOctal, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 ParseSubIdDecimal, bad digit: %s
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3    %1d ParseSubIdDecimal, serious error.
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3   MakeDotFromOID, bad (NULL) OID
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 MakeDotFromOID, GetStringFromSubIds
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 %d . .%d             CatOID: Too int: %d
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 CatOID, cannot malloc oid
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3 CatOID, cannot malloc oid_ptr
 DISK$UCX_BUILD2:[UCX.X42.BL21.SRC.SNMP]OID_LIB.C;3   @(#)$RCSfile: free_lib.c,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 1994/01/05 20:06:46 $        SNMP Research Distribution version 12.1 Copyright 1993 SNMP Research, Incorporated                             <       $                                                                                             k\                                                                                                                                                                                                                                                   Π^  KXPΠ^KXԮn[ԮόRRЬ  RŬ  < UUTެZTj1 ެWЧ Y  VDi}  P	ȏ   U}gSDcfPȏ    UdPDcfPȏ   UKPDc$fP<cR]~R'  PSRSSSȴ6  Rb    TTj1]U< U U
I  ~6I  P%@ݼ'"K  D<'~P~1I     ЮR֮R1[1H  0J  4H  [Ь<  }  ,m    $M   A  UV     ~4Pw8Ș <R~P~kݾE:  PYg~ x  QP RRPQP{RPQPQSQP RRRPRQPQP{RPPQxQRRCx(RB Y BPYRBYUSW	~CeRb 0~CeRWPb~CRWbVTZ	~DfRb 0~DfRZPb~DRZbY1PW 0 PUЏVS~CgRUbTTVTVSSVVVWW( x|~< ~(PRRF $`1V<  ~4P' $`$P < <z~P<  ~kY1R1 U 0 PVR~BeSc~BeScV~BTdcRPPRRPPR-~4P1 8<9~P~k1 R1 ծ(3~4P80<~P~k PY(h< ~4Pc8Ȕ<~P< ~kY;PԮ(TSU~CdRb 0~CdRUPb~CRUbԮ PYY1-Y,<  ~4Pu8<~P<  ~kXP< ~4P@YS	S	ȁTPSR~BRbTT#<<<~P< ~k  ЮR֮RY1b<  ~D  P"oF  ~<~P<  ~D  {  ծ	nm  Ю P ^-FR~D  P!F  <,~P~D   E?    P ^ERP1 ¸W   P¸C< ~D  P3   `\L¼E  <~P< ~
D  ¸SBS  PP2< ~C  P"TE  <i~P< ~C  PLL\\P ^ER¸W   P¸C< ~ZC  P3 K  `\L¼:E  <~P< ~GC  ¸\\P    ^+  P\\P  ^ЬP,ՠ
ݠn  ЬPՠ
ݠ[  ݬQ    ^+<  P\\P  ^ЬP,ՠ
ݠ  ЬPՠ
ݠ  ݬ    ^A~  P\\PP  ^ЬPeՠ
ݠʤ  ЬPՠ
ݠ  ЬPՠ
ݠ  ЬPՠ,
ݠ,  ЬPՠ4
ݠ4~  ݬt  P  ^3\  P\\P  ^ЬPRՠ
ݠ>  ЬPՠ
ݠ+  ЬPՠ
ݠ  ЬPՠ 
ݠ   ݬ      ^N   /   X(   y   z    ^   P  QP  QP  QP  QP  QP  QP 
          <
p=ף ^
YRSHP RST>@X|~ P P`P  9< ~@  P"BrB  [<V~P< ~@  PPPP^qXWRbnլѬ	1UPЧ0XPШRԢJШXԮn1ެ[k !SCYI@1 Ѭ1 Ǡ 1~ $RRXXI@ТΨI8Ǩ Ǩ 
ǜ Ǡ Yǎݨ$  P ШV(!C fԦ! )  JN^1 TPI@XШVЦZѬ:Z)RfRЦZRRZ!R(!B jfЦNRNZfJ֮Ѯn1Ч0TФRҢNSSJNФTԮЮP ^VRS u  PP,  1 ݢ4ϴP7< ~>  P" x@  ±<s~P< ~>  Sfݢ4P9< ~=>  P".@  <|~P< ~;>  SPЬQСPՠJ00SSPP^VWY|UT[S!DDRRH|\ԧd*/  P0P4<~ 87  Rb< ~ b< ~  RB@RR@   <H~ҟ  ScPx<H~cP|<H~cPǀ էxէ|ǀ ;< ~=  P"8?  Q<~P< ~=  n1PЧxhЧ|lǀ px4|8ǀ < Pǈ P8< ~<  P"Ǆ>  ǳ< ~P< ~<  n1ѧ@8	Ч<@PЧ8@Ǆ |ǀ Ǆ PЧ|Ǆ ѧtlЧptЧltݧ@WPn1Dѧ@8	Ч<@PЧ8@Ǆ |ǀ Ǆ PЧ|Ǆ ѧtlЧptЧltݧ@ѧ@8Ч<@Ч8@Ǆ |ǀ Ǆ PЧ|Ǆ ЧlRЧpTѧtRTtPRtSbSRdRRVUSVUUVTշl(!TRB8SS@   C8TCTTlUշp)!URB<SS@   C8UCUUp|RR@   B8SRR@   Vǜ S1ǜ |YY!1B  b  Z@   (ZXH8X@   XH8	X@   XZ   PVn1[VPV0V[g
Ԧ 4~P$FBզ$V"  n1CԦ4V~Pݦ$  V  n1PX@   1 fXݦ$Z  P Ц\H8PP @ h 1 P?P!HR(!B8lԬ! )NJ[P!HR(!B<))lԬ|J! 4P!HR(!B<)!HR(!B8)lJNRΦH8VH@Ǩ ZPnVeYYT1CǤ ǜ Ǡ nЮ P ^QR}}  ;     P\\PP^PYX[Щ0R( P`Ѣ`ѢPТRR1cПF TTPP,  fݩ4QP	Z1>Pݩ4P9< ~
8  P"9  *<H~P< ~8  Z1 TТSWգJ
գNգRWW1 4P`VУTdUЩ4QaPPUXVX!QaPPUXVXVKänäSS¤S	S¤	S
S¤
SS¤SS¤SSäSѮ  [ЬS[[)nPNPPVPTNPVPPfPT`%TdC      TjT(cТZZZP  ^O\ݬ@ݬ@ςѬ@8Ь<@Ь8@̄ |̀ ̄ PЬ|̄ ѬtlЬptЬltP ^NSЬRТPPW`TТ                                                                                                                                                                                                                                                   t                        +[ $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1                                                                                                           "     f       UeV߭UTb  PQbQPRt	PQԭݼݭ]PPRNPiUga  V
V+P]UWj  PReUWg  PRQRRP@             
           ^ESRN~  PS8< ~5  P"y7  <8~P< ~5  ST?N~ S  Т\֢\,(Т\SlТSbSSTTPP ^RRЬQСPa`aPСQСQbbա>
ݡ>\   Q    ^  	    ^     L^Y,RT }ϳ>n}ϭ
QP[Z
X@WBVUS;Rͼdd\PѬFԬBl\|B
>>
 "$>(,.0>48:<>@DFDH>LP*R@T>XQ\^<`>dPhj8l>p[tv4x>|Z⭂>
X0>W {>S(>;U,>R$>ͼİVȰʞ>|ԭnX
  1  W  $  Z  [   2  3   2   R ? P(P1"|~  P1SRRS1 (,S1 PRS1 P   SuSjPB   	
RSUĀ{gPS?PĄ{gPS'PĈ{gPSP1RP1JS15X< \L><\L>ϵPR\R\\X
 PRբ>ݢ>(բ$ݢ$(P< \\PP<\\P~jP>}>< \\\>< \\\>>~kТ>\P<\\\Т>P< \\\\kPJ~jP$<P< \\PPя   P P ݢ Т>\ݬݢ$k<>PPТ$\ L`D4000
\\F\1n\ 1z\C   1b\F   1j\b   16\   11#P0\\:FĠDP\.$\J   \`   \a   	\b   F
PF UXP&jPSE S,US	R#\լ	Ь\լRТSUU9< ~ PČġ<~P< ~$R1B1PQ<P\\PQP{\PQPQ	c1xPc1oPFPi1\P$1 FĘ i>f  PV1/UXP
jPSE
 S,US	R#\լ	Ь\լRТSUU9< ~ P<~P< ~$R1B1PVcТ	1B1zF8i1hPF i1TP${gPF 1 P({gP
FĈ1 P,{gPc}PPC   : F F F F F F F F F F F F : : : F : : : F : : P?P
FF PF i1 F i~0{gP4{gPF8KP8{gP
F,P<{gPFPFHiѢBԢBBѮ(X
  1dd\PլB	\ЬP`l\RRPP ^IR' P`Ѣ`ѢPbRRբRТP`PRPPPP< `^HR}V@}RN웏\ͦUͤ|S\>ͦ|c` PSSb<ͦ\LͦUͰͲcʹ>ͤ͸|ͼ|~ ͨͰ  PSc  PcP\Ь
SP ^ݬ  PTGR8SТ>QСSS"<aPPTDcP<>~Sݬ>  PbRRSSPP  ^ЬPՠBPPP^1GTЬRТPPW`UТVfX߭VUU  PSbSPU1P	PSԭЬPdѭh)ЬRbݭPSТdЭhSllSSPU1 VgpT  XPP - A U i } 1 P?PݣVWfZ  PUiVWn]  PUU VW~[  PUA(VWF]  PU-ݣ0VWZ  PUݣ4VWZ  PUQUUP  ^ЬPՠB
PPP ^!SެRbPРTPcc"cQPѡbЬPР	PСQЬPՠ$
ݠ$c  T	TV      P' RbѠbѠPРPP&ЬRРРQabСССSPSSP ^aISЬRТPPV`TТUeW߭UT{S  PQbQPT1 P	PQԭѭ,ЬPѠ()ЬRbݭ0$PPT~PТ(Э,@UfBR  WPP ' O ; MZ?Pݣ0UV>X  PT5ݣ4UV*X  PT!ݣ<UVX  PT
QTPQTTP  ^ЬPՠB
PPP ^SެRbPРTPcc"cQPѡbЬPР	PСQЬPݠ$t  T	Tg  ݬ V' RbѦbѦPЦVV
(
WWWP ^GSЬRТPPV`TТUeW߭UTQ  PQbQPRT	PQԭݼݭ4YP	PR/P8UfP  Wݣ4UVV  PRQRRP ^GR~Q  PS8< ~$  P"p&  <V~P< ~$  T9P~ S-  Т\֢\b\լPЬ\լS\cSTTP  ^ЬQaPССPa`QÆ  P< ^FSЬRRTUУPѬRPTR
TPRPT+~  PTB 
B TPUTTP ^eFRW|TVT\LHScLJScLLScLPS>cTT\LHS$cLJScLLS cLPS>&cTT\LHS,cLJScLLS(cLPS>.cTT\LHS<cLJScLLS8cLPS>>cT< T\LHScLJScLLScLPScTT\L SDcL ScL  S@cL¤ S>FcTT\L SLcL ScL  SHcL¤ S>NcTT\L STcL ScL  SPcL¤ S>VcTT\L S\cL ScL  SXcL¤ S>^cTT\L SdcL ScL  S`cL¤ S>fcTT\L SlcL ScL  ShcL¤ S>ncTT\L ScL ScL  ScL¤ Sc|~H|~0P9< ~e!  P"lV#  <~P< ~c!  V1O0TT\LHS4cLJSkcLLS0cLPS>6cTT\LHScLJScLLScLPSc|~H|~0PSQPЏ   \
\P
Q{\PQPQ@Ţ@0\Q\P\
\P
Q{\PQPQ P\\E \V1¼   ԬU TP\\E \V1G   ԬU P\\E \V1 N   ԬU P\\E \V1    (ԬU P\\E \V1  ΁  QPТ@SSPQP{SPQPQԬU CP\\E \V7 v   8Ԭ~   PVVVPP< ^yASѬU1PПF RѬRPP,  U1 PR|~Ü |~0P:< ~r  P"c   $<~P< ~p  U1 P RU@ RP@ RU_H RXH TU?`RQRPУ@R	RP	Q{RPQPQRUP`8UUP ^ԭݬݬ߭fPSdЭPZЬRРbЭPРЭPРЭPРЭPР ЭP ЭP   PТRЭPР$SPSSP ^?SЬRТPPV`TТUeW߭UTKI  PQbQPT1P	PQԭЬPÄÈ1ЬRݢbݭXP
PT1 PТÄЭÈXUfH  WPP 0 D X l   1 Pr?PXUVM  PT|\UVQ  PThdUVO  PTTlUVM  PT@pUVM  PT,t	QTPtUVM  PTQTTP  ѼQPPP ^M>SЬRТPPW`UТTdV߭TUG  PQbQխPRGPPQPR6PԭV(գ#߭TUF  ݣTWL  PRQRRP| ^IASVcR3 PѢ`գ	PԢRU1 PѢ`RVbRM}  PT4< ~  PS  (<~P< ~  / T/}  ЬRdգԤVTfTcTUUPP| ^@TUѬV1KPПF SUSRR,  V10PդԤP$ P|4Ѥ0	  1 P|~<    P0Ѥ0֤4 	 ֤8 ϔPS_ RQRPRRPQP{RPQPQ   PP   PF?PPPѤ0	  1O0UdR+bSѢUSeSdR{  URRUSRФ4Ф8iVVPP   ?\<  |$Ԭ, <> @> D HJ L> P T#V X> \ `b d> h l
n p> t xz |> ̀  ̄ ̆  ̈ > ̌  ̐ ̒  ̔ >̘ |̜ ̤ ̨ ̪ ̬ >
̰ |̴ ̼ PP< ^=Tݬ\PU1 PЬRЬQdP PQѠRQѠR`PPSUjЬRУb$У(ԢԢ< ~ y  |~Ĩ  { P0Ѥ0<
~ݢy  <
UUPP ^ݬPTPЬRЬQ=P PQѠRQѠR`PPSTЬPУУУ`TTP ^<SЬRТVfTТUeW߭UTB  PQbQPT1P
PQЬP`d<ÄЬRݢbݭpGPТ`Эd
dQT1 pUfsA  WPP- 0 D X l t  1 P?PpUVeG  PTptUVH  PT\|UVYJ  PTHÄUViH  PT4QT.PÔUV
G  PTØUVF  PTQTTP  ѼPP ^Y;SЬRТVfTТUeW߭UTVA  PQbQPT1 P
PQЬPäè8ЬRݢbݭìPТäЭèPèQTMôUf@  W4
W5+PìUV                                                                                                                                                                                                                                                   u                        V $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1                                                                                                            "     w       F  PTðUVE  PTQTTP| ^ЬRТUeSТTdV߭TSq@  PQbQխPRAPQPR2Pԭ߭Tei?  V, TU{E  PRPQRRP               | ΐ^=SЬRТT}ϭОÐ }̭Ȟê ̛Vͪ}Ͱû ʹUПF b$xPA< ~E  P&RR 1   ~P< ~?  ЬR%1͸pPRRJ  R1 ͸͐1 P͐PRVذڞ>ͪ|ԭ쟭П PUU
<ͪRB2 RB͐RRUc<ͪR\Џ/Iͬͬt  P/ͬRя0IRRж  <RRͨ!PͨPͨ
P
ͨ2͐~Yt  Pd3͒3͔3͖3͘3͚2͜R
RR2ͨRяRIR  @R-U+UU2ͨ~s  <PP	2ͨ~s  PRz  RP{<PQPP
ЬR%RRPP^H;RYXWVUTSX	>Q>U	R>W  >V>ȰT̰>԰Sذ
ڞ >|ԭ|~🭜|~0<\L<\\\PP< ^I:TЬUUϡP}URЬSSPQ"z )*QQFUPqi((UR`r  ѢPPr  PPP ^9SЬRТUeVТTdW߭TV;  PQbQխPR1EPQPR15ԭЬPݠ,PQR1߭TV:  WPP  =   a   1 ^?PPP1 ,TU@  PR1 1 QP1 0TUA  PR1 1 TP1 DTUg@  PR~PvPUPmHTUF@  PR]VPVPMLTU&@  PR=6P<TUMA  PR$JBTU?  PRPQRRP  ѼPP LOCALHOST P μ^W9V(
ͼ @5   PaG  f   /ݬzp  PR	ЬRPRR]
  ~ ͽTp  ~ͽo   o  PR>]  U1J2 ;p  Rͽ\;o  ;Wͼo  PRݲo  Pb]  U1 Ɣ ƌ io  PRƘ e]  U1 Pզ2 ?o  P ƿ No  PU1 ЬRЦbSզPSRBRbSST T+o  Wn  
PPd
Wn  T	  PUfUUPP< ^u7Rb8<  ~  P" 
  <h~P<  ~  U1լѬ<=<  ~  P%ݬB
  f<n~P<  ~  U1`PTSբvPSP@P`QTUSTPЬPݠݡn  P;< ~_  P%ݼM
  <z~P< ~Z  U1 SSTuPP~ݢ<m  P:<  ~
  P"  <~P<  ~
  U1 PQPQPP@P`QQТTTSCPЬ`ТPCPЬ`ТPCPЬ` 6m  PQТPCPQ`ТPCP`bT   PUUUPP^5Td9<  ~%
  P"F  t<~P<  ~#
  X1ЬRRRP@P`P
ՠPQQQU	X1 P~	  P&eݬĬ  <~P~	  S Sl  ݥk  WgPRegPQRQRRRcPPQФPAP`
ФPAP`VݥVtk  VgPPVeV_k  Sn  PXXPP ^4SWЬUWV~  P%Ve
  ,<7~P~  ХTRգ1RP@P`PՠTݠk  PRPRRPPQQT
QP@RbTTV{cvT Tj  ЬUݥj  PRRRd<<RRR<<RPP  <<Wݥ	/j  T>  PVVRRP ^2S~  P'ݬݼ	  ,<7~P~  ЬPРTRգ3PRP@P`PՠTݠi  PRPRRPPQQT
QP@RbTTPP ^C2SR Ri  b<<\\\<<\\\  <<R,  PT5<  ~  P"b  Ì<l~P<  ~  TT\\PP< ^1S~O  P$ݬ=  <~P~K  Rb<<PPP<<PPP  <<ЬЬTլݬT8h  PdT=h  <bQPQPPbT)h  PPT<bPP   ~TݬRC@  PU[cR*  PTDR  PT5<  ~R  P"C  :<~P<  ~P  TTUUPP ^[0SգT{R Rg  b<<\\\<<\\\  <<	R6  ݣf  ݣf  ԣcTTPP ^/RSբ5SP@P`Pՠݬݠf  PSPPSSP  |/\ЬPP l/QЬPPP@P`P
ՠPRRRPP   5/< ^'/R f  PUUI<  ~  P4 e  `If  P  <`~P<  ~  U1 ~e  e  PSS  Ue  U1 ݳte  prT~  P&<r~	  <z~P~  TpUe  PT<  ~  P9 d  `_e  P<r~L  r<~~P<  ~  Ud  UUPP ^-VЬWRR((	P(蚏~K  PE~  <~~~~~P<g~ƨ  <~P~&   <g~ݬݦ#d  PG~  P3 c  `ld  P   <~P~  RRRPP< ^,RЬU߭( < ~ݬݢc  PT][c  S c`#H c`@< ~B  P0 c`c  PV%  n<~P< ~2  S1 <ePPT<< ~   P'T<e~¨  <~P< ~   SV~   PE~  PQ<*~/~.~-~,~Q  .<
~P~   SSP   ^]~ݬb  PRЬRPRR2b  P  2QЬgȏ    ȏ 0  Ьd    2QRլ
ҡdPPPRRPP ^2R]~ݬ\b  PSSPЬSѬ   &Ѭ    8ݬݬSbda  /ݬݬSb~a  ݬa  dЬzP` d1`1 	b8  d~~a  Ph Ka  P¤ݢh[a  ´ݢh`  PS a  P`  Pb¶S<a  S`  ݢhby8  `d+ ݢh`  PSS`  Sx`  ;`  P@PP
`  P@8  ˏdP&`   ^0RެPP~ݬ`  QQP |0RQ~AP`'P~AP`~AP`SQ~AP`ܞP	SSPP 40QЬP@pRRPP| ^0Td19SPSҤdRRSRPPzЬSĈ	VĐ	VˏSĔ	USĘ	SĠ	SSUЬRbUVТRBpĀ	ݬݬc	İ	<~P~ЬUѥMSPSҤdRRSRPP1WЬRݢݢ	
<~P~1)ѥ1 SPSҤdRRSRPPjЬSУQR~BSc$~BP`Q
~BP`SPR~BP`ܞP	SSЬRݢݢH
l
<~P~
ЬRբ(1 SPSҤdRRSRPPsЬRݢ(ĸ
ݬݬĤ
Ĺ
<~P~?PSPSҤdRRSRPP!
b
<~P~pЬRТ$ScRSSR	   ТRP ^-Rd1LЬP1C`H&  QdQQD/H:ݬݬ%;<~P~ЬPՠ<QdQQ<+vݬݬpw<~P~ЬQա1[СPP RS/SSSwSGG	?PP   1P   $ d   $1?PQdQQ41ЬPݠ¬½<~P~PQdQQ,1ЬPݠ<~P~PQdQQ$1ЬPݠ8NG<~P~\PQdQQ1^ЬPݠ|<~P~PQdQQ1ЬPݠ<~P~PQdQQ1ЬPݠ	

<~P~PQdQQ!O
X^
<~P~f~ЬPo  PQdQQ!
 
<"~P~~ЬP'  PQSQҢdPPQPSS1ЬQСPя   PTPTP   
S
SSݡT

<&~P~PQSQҢdPPQPSS!1?@<+~P~M~ЬPV  QSQҢdPPQPSS!v</~P~~ЬP  QSQҢdPPQPSS!µ<3~P~~ЬP  QSQҢdPPQPSS1ЬPHY!  P,<7~P~:QSQҢdPPQPSS11>X<:~P~QSQҢdPPQPSS1 ¬<=~P~QSQҢdPPQPSS1 `<@~P~nQSQҢdPPQPSSh1<<D~P~-QSQҢdPPQPSS(ЬPݠq<K~P~x^c'SЬV@TUTңdRRTRUU12<^~P~fxV  fJTUTңdRRTRUU%x,<c~P~:xUYx}V  xRRPUYTެZT 1 XW  VT1 z  TP{PQPP1 eYFPQPңdRRPRQQcxNݬݬEhP<p~P~g:PPQPңdRRPRQQxÈhÌ<r~P~gYxUPTz  TP{PQPP D~UyU  UxU  PUTTf1eYMTVTңdRRTRVVrxݬݬ<~P~PTUTңdRRTRUU%xr                                                                                                                                                                                                                                                   v                        Pԟ@ $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1                                                                                                           "            <~P~P  ^ݬݬ"  ^/7SPR2  PRR|PRR0\Ѭ%< ~\,  PRPPRB:  R/< ~P H~P< ~R\\P^u6U~qP~cŒ ~P~rЬRRejѢdѢ
^ХRbRТPРP`Т(RХS"S  TSRУ(Sݢ dRdSԥݥ`:  ԥeԥЬRТPP,   ,X 1V?PЬRRPX~{P! l <~P~zݬ1PЬRRPX~'P!(<
~P~&ݬ13PЬS|S`PXeuXգS
CPXХRPbRТPРP`Т(RХS"R  TSRУ(Sݢ dRdSԥݥ8  ԥeԥЬR~MP!`>t<!~P~Lݬ1YЬR|R
ψPX~P!Ŭ<,~P~ݬQ1PЬR|R0PXХRPbRТPРP`Т(RХS"Q  TSRУ(Sݢ dRdSԥݥ7  ԥeԥЬR~9P!*<9~P~8ݬ1EХRPbRТPРP`Т(RХS"]P  TSRУ(Sݢ dRdSԥݥ47  ԥeԥЬRԢX1~PO޼Sc  pTcrS|SSTTݼHPŊ<E~P~^ЬVԦfT1oզ(9
߭ݦ(/O  PЭScRR,
 SSO  PԥЬRѢm   G<  ~P.ݢP<[~P<  ~W1PբG<  ~P.ݢPl"<_~P<  ~yW1PKե;PХPPRRRW1_ХPPR`RN  եԥS SP17PSPRRRW1S SP1PT  1 TTyPTզe<  ~P>TdSŀSݦPSXfň<}~P<  ~sЬRݢTW1|~-PqTdSSS<~P~>Pզ7~P!(P<~P~W1 X1 P~P(ЬRݢņŰ<~P~ЬRԢX1 ~aP!R<~P~`ЬRݢ(PPSݢS`PXPXЬRԢA< ~P)ЬRݢ4T<~P< ~WPXWWP^.RЬP|` YР$U13V  [yWX  ZPe0UPS~fP1 ~fP$eHkPg¤<~P~hS4~fPMHkPcg<~P~h$~fP0gJ<~P~hS8ЬPPSQ<PPʏPˏPP
PPPPգ0~fPg<~P~h ej1 S4УP`PT~fP$TYPg<~P~hTjTPP 7 c c c c S 	?PPP   CPP     5?P^P ejQ ejEЬPY6P<  ~fPT$gP<~P<  ~hЬPYЬPՠ
ХUYU1SSP^?,SެоR|b |(ԮТ$W[Т$V1оnZ-  Y"X   nRѢоTR[R
ԮЦWФ,~jP'fHP[Æiâ<V~P~hVPU6~jPi<^~P~h f
  1*P~jP*fHݶPe,iV<d~P~hե1оPRUQ<RPʏPˏPP
RRR-T~jP1CÌiä<m~P~h1'Ѧ).~jP7i<s~P~hPоPѠ
PU4f0ХP`PR~jP$RwP	i<	<~~P~hR1 RPP 6      ?PPP   wPP   W W i?P!f@  P0)~jP1 r	iÐ	<~P~hkP)bP^PЬP[T1
P<  ~P$R	o	<~P<  ~|ЬP[T1 PR1֮1оRѢ1 զ1 (1 ծ{~jP*
i^
<~P~h (VR 	-  P;ТRЧЧЧ))!!gbWVЧWPЧWЦV[V1TTP|^k(VЬPP tttttt1_
?Pզզ^ЦScSУRТP`У(SЦT"E  WTSФ(Tݣ gSgTԦݦt,  ԦfԦЬRТ$Ԣ$~P!Ɣ
Ʈ
<~P~Ц[1E  nެ
  D  ZkYզ@,PS)< ~P<S~P< ~ SSUH,PS)< ~P<S~P< ~ S(SRU$Х(UU1< ~P

<#~P< ~ оR
ЮRв Y[PT~P1 TJ~Pqi͘PRHPRd*\<1~P~ 6P~P'i͘PƘ<7~P~ TA~P!<B~P~ЬRЮ1դC~P!Nv<H~P~ЬRЮ1yPѤQѤ	KѩE~RP$ݤƬ@<Q~P~NЬRЮ1 PTäiWA~P!
.
<[~P~ЬRЮ1 ФSCXЦR?բ 3ТQХPѡ$Т QѡWxW~XݡjP
Т  	PТ(RRpA  P ?< ~_P"d
Pƀ
<q~P< ~]ЬR
5PХ RXХ RWХ RԢԵ ȏ   U ֮Ы[1ЬRբe~P$ݢƶ

<~P~ЦT#:A  UTSФ(Tݣ eSeTԦW1TЦSPճ г Rȏ@   Գ TУ(S䚏~YP!"J<<~P~XUЦS12ЬcSУRТP`PT1 TPP T      p  |   d      X  ?PPP   1 PP      zPr?P1 ЬR1 ЬR1 ЬR1 ЬRzPЬR
nPЬRbPЬR
VPЬRJPЬR>P<  ~8P$Tt'Ơ<~P<  ~4ЬRTH~P,TP<~P~ЬRUW1UУ(S11P~P!4H<~P~UЦT1 1 ЬdTФRТP`P1 ~EP!ƀ6ư<~P~DЬRUЦSSTnPPcSФPРP`P<~P!<~P~ЬPUУ(SSTUФ(T1-1 P~P!Jz\<~P~ѦhTЦS_QЬcSУRТP`P<~/P!ƒ <~P~.ЬRTTУ(SWWP< ^SЬT<dPP~J=  PRU&<d~T%=  bУPR`RRUUPP^ЬP`YԠ JPTST?SGPR)Y  PЬPРPѢЬPRSSTЬRբXjТSUУTUTJUTVVVP@RY  PWЬPVRX+PWVT
PWVUUTWVЬRVXXPP< ^ЬQС)PP  S S s  wPV?PЬRRPS\PPѣb)SU1 ЬR)SU1 P2PЬPРQRޱSBcR)RUyPЬP֠PUgЬPРQѠЬR)UJPЬSУPRްPB`T!J  P
)UPЬRb\  )TUUP  \QQPP ^TѬ1ЬPP  C g	"?PP   1P   $ 8 L ` t 1?PЬRм1PЬRм1PЬRм1PЬRм1kPЬRм1WPЬR
м1DЬRg  PS1+1!ЬRC  PS11 ЬR  PS1 	1 ЬR  PS1 1 ЬR  PS1 1 ЬR  PSxP
nPЬR_  PSTPJPЬRЬ=< ~P%ݬ<V<~P< ~SPSSP  ^,XVfRЬP`PhUЬTdPsR   jPdSS.UW1;PP>RBfU58  Qˏ SP@aPP
BfP0SSPBfUPW1 PTdP	R   U	R   W1 PЬS1 RcURTxTTTT~8  PS*UTUS7  PT S8  Dc4P< ~PP"Ȓ Aȡ <~P< ~NSRЬPR5< ~P~P< ~WPЬWWP ^]+TެWgQa?PЬUFVSa/  RCVGU7  LVU	7  PUSSbЬPP| ^*UЬTդ
ݤ6  ԤdЬSЬRcc~6  Pc9գ4< ~$P N]<~P< ~$VGЬPРSRެTdPR  PBRRQެTQdЬRAbQQdЬVVP ЬQЬPРPPaT@SRTRЬQЃaRRTRTP ^)VլW1PЬRբ
ݢ5  ԢbЬP	ՠ`螭ԽЭPԠЬRb螭вЭPԠЬP`РUx`SSS~O5  PT*USUT-5  PS TO5  Cd4P< ~P"ƒ ơ <~P< ~TRЬPR`ՠWPЬWWP  ^ЬPՠ
ݠ4  ЬPԠ   ^(SլԬЬRR~4  PT0լRݬTa4  PR T4  ЬP@d4P< ~P"Ò á <~P< ~TPP ^ЬSSЬRR   PQbcQQPP QռC   SQ T3cPްRЬPްPAbA`TAbA`T
QQTTPP Լլ>ѬT1 PP%ެRbS@c   Td޼Q@ @aPTQPЬRRԬRQPRQQ+ЬSAcRR   	Լ޼PRA`ԬQЬTTP< ^'TЬЬ                                                                                                                                                                                                                                                   w                        [z $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1                                                                                                          :S "            QQQЬUQRRR~2  PS(URUS2  R S2  Bc4P< ~P"Ē 	ġ <~P< ~SQЬPQ`ՠPPЬPP< ^ЬTդЬP	ՠ`UiUcPЬRբЬP	ՠ`UBPU;PdbbSPdSSݢݤ1  PUdbUPdbUUP| ^%UЬRբ
ݢ1  ԢbЬP`РV`SSS~t1  PT'VSVTR1  
S Tw1  Cd4P< ~P"Œ š <~P< ~TRЬPR`ՠRPЬRRP  ^ЬPՠ
ݠ0  ЬPԠ`| ^$Sլլ:< ~6P" ' <~P< ~4V1 PЬPѠ   RѬ
Ѭ   >< ~P%ݬ0T<~P< ~V1 PЬRТTTT
߬ЬPݠݬPU^PTެݢݬPU9< ~LP%ݢÉ:ø<~P< ~GUUVVP ^#Rլլ:< ~P"<<~P< ~T1PЬPՠ|ЬQСPPEaa% aaa  EaaE1D?PѼ:< ~rP"Dcj<K~P< ~pT1PݬЬPݠݬPS1 PѼ   :< ~P" <S~P< ~T1 PݬЬPݠݬ$PS1 PЬP`	PP7< ~P"<[~P< ~T>ݬЬPݠݬPS"PݬЬPݠݬPSPSSTTPP ^!Rլլ:< ~P"Qp<~P< ~SAPЬPՠ|ЬPѠݬЬPݠݬPQPQQSSPP< ^%!Sլլ:< ~P"æw<~P< ~U1>PլԬЬQСPP   (          1 P?PѬ:< ~
P" ,<~P< ~U1 PЬЬ쟭ЬPݠݬPT1 ݬ?ЬPݠݬPTRբ
ݢ	,  Ԣb[PЬЬ쟭ЬPݠݬPT6< ~HP"h9Ð<~P< ~FTTUUP ^ЬPF`Rբ
ݢ+  ԢbЬQˏ   P ѡ
Rբ
ݢT+  ԢbP ^ASլP   P6< ~P"<D~P< ~T/ PQЬPa`Rďd   RáPƏ'  PRPTTP            < ^#R}}螢XբTТTT|PЏ US|~ <f~|~ ݏ	 
  ߢTxP\\\  ST2SU ݢTB*  ТT\( {ТT\̀{ТTTTPP| ^{U{TV ;Se<ŏ`  SQdPA\P`RbPb~)  PSVSSeVRRP        (^#RЬS}b蟭Xx蟭(  ߭߭؟ߢ(  ݭ)  Pc
~(  PQQPP (^"S}pc䟭蟭Xx蟭7(  ߭߭ܟߣ((  ݭ(  ЬRPb
~(  PQQP    ^E"RެSЬP@b(  Sݬ'  (     ^$Sլ3<  ~Pc(~P<  ~THЬRbЬQaССԢ<bPP~ݡ$R   PTTP^լY1 UЬTVլ1 ެXUW2UPPh$ЬPQQ1 Q1 V1 UЬRbTTX'  PSSTSUUUh~TR~PS%ЬPPPYcPЬPVCPSWUЬPQQ(Q#VSUSTЬPРVլ1/ЬR<bPUPPbYYP| ^	#SUѬ8< ~$P hr<~P< ~$V1PЬQաЬP֬`Uѡ1СPP5q55555qqqP?PP   1PP   $ HHHH$ $ $ HHH$ 1-?PЬP֬`ЬP֬`UURR8< ~<P"è -ò <2~P< ~:V1ЬR֬ЬQPʏ PPbЬR֬<Pʏ PPbЬR֬Pʏ PPbЬR֬ˏ PPbU1PЬP֬`ЬP֬`UURR8< ~P" u <D~P< ~V1WЬR֬ЬQ8Pʏ PPbЬR֬0Pʏ PPbЬR֬(Pʏ PPbЬR֬  Pʏ PPbЬR֬Pʏ PPbЬR֬<Pʏ PPbЬR֬Pʏ PPbЬR֬ˏ PPbU1PЬPРTЬR֬xTPʏ PPbЬR֬ˏ TPPbUTURR;< ~OP"(@2<_~P< ~MV1"PTЬPݠݬy#  TTU1 PЬPRURR:< ~P"hr<i~P< ~V1 PЬPRRR#  PQЬR֬xQPʏ PPbЬR֬ˏ QPPbQQQUZPЬP֬`ЬP֬`UA< ~8P)ЬPݠè"<~P< ~/VPUVVP ^ VԼYլ6<  ~ڿPf(~P<  ~ܿX1P,)"  PR2< ~P"<~P< ~RU	X1PЬRPP;<  ~GP$~`5ƀ ~P<  ~CX18<eХPP7 7 7 ]-]]- ]]]1:P?PТТT<bSìTPPSSWբ1 <WPѢP;<  ~P$ݢƸ  ~P<  ~X1ݢ   P 8< ~LP!=8~P< ~KX1@ݢ~ݥ z   T<WP¢PPW<W~TUPY1 P1 	SSN  P(gТТT<bSìTPPSSP<PPFT  P(7<  ~P$ݥpƐ~P<  ~YY}US|գ 
ݣ   У$THФR&ݢ  b!R  d!T  գ(
ݣ(|  Ss  UYXXP^Uլ;< ~￼P"ﰾ<~P< ~ｼW1ZP[XѬ[1D
Z  YVS-  PR2< ~QP"PB`<~P< ~ORVW1ЬPՠ$V$VXЬP֬`ݬfjP1 < ~P%ݬ ҽP<8~P< ~߻VTjФSHУR&ݢ(  b!9R  cc!S  dG!T  W1
PݬiPPݬ!jP1 < ~P%ݬň
Ÿ<B~P< ~VTjФSHУR&ݢ`  b!qRD  c!US(  d!9T  WFPݬiPPЬPѠ"[ݬf'PЬP	XPѬ[1WWP< ^SRR9< ~P"<j~P< ~U1bPЬP֬ЬR`ЬP֬`PxPTЬP֬`PPTTRR9< ~P"Px<t~P< ~U1PЬQѡ1СPP;c;;;; ;	:?PP   1`P   $ XXXX$ $ $ XXX$ 1=?PЬP֬ЬR`PxPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PP1,ЬP֬ЬR`Px8PЬP֬`Px0PPPЬP֬`Px(PPPЬP֬`Px PPPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PxPPPЬP֬`PP1 ЬRTTݬPU1 TvPЬRRЬP|PU\RS  PRPFPBP< ~ＷP)ЬPݠð惡<~P< ~ﳷUPЬUUP ^ЬP1 ՠ 
ݠ   ЬPР$TjФSHУR&ݢ   b"!R  c!S  d!Tw  ЬRբ(
ݢ(d  ݬZ   ^R-=  PS2< ~喝P"P`<~P< ~禮S\\PP ^ЬP1 РTjФSHУR&ݢb-!R  c!S  d!T  ЬRb!Rb     ^ݬ5  PЬݬ"  PЬ쟭蟭h  PQQP ^ݬ  PSPP  PRݬR  RPP ^ |R߭߬߭߭  PRRPP  ^}R´ -  ЬЬ   ^MSUVެYiRU1 ЬX  WЩ Tz  UP{XPQPPiRѢ gE ~ gѤiRz  P{PQPP?z  VP{PQPP gz  VP{PQPP gz  VP{PQPP gz  VP{XPQPPVVUU1_   6   ^ChWdSЬP	V1 Pݠ  2PPP1  ~  <U T'  P  P@PP
=PPgP,]~T  PRRPTRRU0V1WP,U  ЬP2
QQ1QPPZ Z~ 
P?PP@   1lP@   H    01WP?PЬPݠ4  1PЬPݠ8  1PЬPаQ~~~a~<  1PЬPݠ&  2PPP1 L~  <*UxT'  P  P@PP
=PPgP,]~T  PRRPTRRUV1 Pì  1 PЬRݢ   P1 ݢ1 ð  1 PЬP2
~ö~  <SUT'  P  P@PP
>PPgP-]~T  PRRPTRRUVЬPݠPVVPP^AURެTdSRd  X  WBgPʏ P@hPʏhPд PB`PP 
P
P
dQB PPRP	V1 PRdPRSެRbPSdPв PC`PP 
( 8 8 8 8 8 8 8 8 8 ( 8 8 ( P?P9  V,в PC`~!  SbPS  VVP ^=RЬS]~ݬ^  PQQSS     < ^RެSSSP`TTSSP`UUp	 IpT
TPPcP SUxi  xP ^R'  P|  P@PP
EPP!cP0]~ݬl  PSSPЬSSݬ ^	R   2PP ! 1 A Q UZ?P@                                                                                                                                                                                                                                                   x                        PN $      UCX042.B                       c  P  3[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$HR_MIB.EXE;1                                                                                                                         ݬX  ݬ~r  ݬ b  ݬºR  ݬB   ^gUЬXhR RRa   1Rz   1 .X  PW
XO  XPWXTW*T   !RbDTW	T   ߔDT~DŰ RbV  VP~DŰ Sc  P)fPRcfRP~DŴ Rb  T~DŰ P`~DŰ Rb*
C~k7C<V~V1PW  XG  WRBPPBPP.WRBP(  PT'lC~ŐC<~`V1PWRxR~  P/C~C<~$T
  V1PWdSWRSR1PP`RR01 PPx   	PX   NC  P1$D~,>D<~T	  V1CP1 C  P1 tD~ŐD<~JTA	  V1 1 R0OR9JC  PjD~D<~T  V1 :PPP`~E~O@E<~T  VgPP`QQ.P?PQ8PP`~sE~ŜE<~gT^  VPSWPSP1RTVVPP ^Sݬ:PRT<Ѳ2ݲE~E<~R  TPRTTP| ^YSެTִ ִ ԼVд RbRR.1 R1 P  Rд P`Pʏ P@bPP'ݼ*F~HF<~mUp߭|Fݴ   P&ÀF~ßF<%~3U6PЬRxbQˏPQPbִ VVд P`PP.P1NUUP| ^mTԼVެSг RbRR.1 R1 г P`PP0г P`PP7(ݼF~"F<A~Uz߭,Gݳ 
  P&0G~QG<K~SU?PЬRxbQˏPQPbֳ 2VPPPV2VPPг P`PP.P1IUUPP| ^TԼVެSг RbRR.1 R1 г P`PP0г P`PP9(ݼĄG~6ĦG<h~Uz߭Gݳ 
  P&G~H<r~gU?PЬR
bQˏPQPbֳ 2VPPPV2VPPг P`PP.P1IUUPP ^RЬP	`ՠ&8H~sXH<~SHPЬQ2a~ݡݬ8   2PPP$H~-°H<~SSSPP^XRެWRgQ U  T  SBeH  RPPTݬcHݬc
ݬcRRTZYV~FȰ Rb1    W~Fȴ RbTgSUPRPRP2UPPPUQPQP2URN~Fȴ S޳ SBcPP.PB PP.-P)R%~Fȴ Pް PB`PP.PB PP.PRY~Fȴ Sc  RPVZRYV~FȰ Rb1PZy~JȰ Rbݬ  US~Jȴ R޲ RCbR~Jȴ VЦ TCdPP.USCdPURެVRf)ЬTBdH  ݬ  RRf۰SSP RЬQ֬ЬP֬aQ`PQP$P2RPPPRЬQ֬ЬP֬aQ`PQP߰RPPެXެWѸ  и Sз SSЬSPTPS&T"hVЦRgU   Q@a@bTPPSTTѼѼüTTPP^
WZZ   )ZH~p
I<7~Y1 Po  PU&@I< ~:[I<<~Y1 xZ~9  P/ǎI< ~ǭI<B~oU  YZPTVެXT   RVQVTPT@ATbSެTS   RVQVSPS@ASbZeUYYPެXެWѸ  и Vз VQV5hZЪUgYЩTAeAdЬPްRЬPްPA`AbS
QQVSSPPެXެWѸ  и Vз VQV5hZЪTgYЩSAdAcЬPްRЬPްPA`AbU+QQV޼S޼RcbUPcbUPUUP    ^ЬP`	`  ݬ    ^ЬPՠ
ݠ  ݬ  P ^ЬP1 РRբ
ݢi  R`  ЬR2
RR1 RPP] } 9 	b?PP@   cP@   ; [ [ [ ; OP:?PЬRТS:գ
ݣ  S   ЬRТSc	c  S  ݬ   ^ЬP1 `Rb	b  R  ЬP2RR   >Р
Rբ
ݢq  Rh  ЬRТSc	cQ  SH  ЬRТT1ФS"УRݢ(   RSTݬ  P ^ЬPAРT1ФS"УRݢRDS;T2ݬ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @   @       <  H                                               
  H  
             8   0            ,           8  H  P  X	  	  	  	   
  	  
  `    (  `  8	             H         8                  (  X  H	  	  	  h  (              `  
                 @                                                                       UCX$ACCESS_SHR                                                 MTHRTL                                                         LIBRTL                                                         CMA$TIS_SHR                                                    DECC$SHR                                                                                                                                                                                                                                                                                                                                                                    4 * [UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$INETACP.EXE;1 +  , `c	   . p    / #   4     p   k                     - P    0   1    2   3      K  P   W   O q    5   6 |כ  7 Mv؛  8          9          G    H  J                            0 D `    0205        E{W       z                                              UCX$INETACP                            UCX V4.2-21    3E{כ 05-13          > P  Q  P  P  P  P  P  P  P   #             $   
   &     %       '     ,   
   .     =       ?     Y   
   [     Z       \     [        l       ]     m      ^     n      _     p      a     w     h     x   
  i     ?   "      !        
SECURESHR_001#      !       SECURESHRP_001      !        
LIBRTL_001'      !        UCX$ACCESS_SHR_001!      !         DECC$SHR_001 O    !       
MTHRTL_001$      +        CMA$TIS_SHR_001   |   |  E  S<<1 <l PУ8R1 ТT1 <PПL@ Q@aVѤ`xP0{P0{P  SU~E P4P1 ЎPʏ  ( <ԥ8Х4U	яU枟C QСQѡTФTP0+RP0+ڎ<l P0b{<P$E  "E  < Q0*PR
E  bԢПXPР`
 
<Q0*PRD   
 D  D  ¨ПHD hi  D  QСRbR0QQaQHQQaށQaށQaށQaށQQaށQaށQaށQaށQaށ°°°´  B<|<<(Џ$  Џ  Џ  Џ  Џ`  P@<|<H<ЏD  Џ  Џ  Џ  Џ  PP¦ P  PPDЏH  < PP¨ <y  PP P <¨ [[PQQx<[  QQ[P<X  QQQPp<D  PP P <¦ [[PQQt<&  QQ[P<#  QQQPl        ¢   £   ¡ ¤ ¥       PP P`  X  PP0      v
x     Ԣ|  @8<@qB  S~E 4P1 R8< У4S	яS.B  SC QaSaE 	4P1 ڎP> x  ~E P4P1 ЎPA  PР8P) E P4P1 ЎPڎ w  >E P4P1 ЎPڎ w  >A  
P￠  0wPﲠ     bw  ~E P4P1 ЎP}E P4P1 ЎPڎ 8w  <OA  ~<qn  ~<_  ~<_  ~<_  ~<_  ~|~h@  UХ8Tʏ  ( <ԥ8Х4U	яU(P
0[&ФQ0vC RТRѢQСQP0/&S@  Q@  P0&G@         TЬP0$iYY[YV,PP| ЬV@  R v  ~E 4P1 [~k[[YP- [~k[[YP[~k[[YP
[~k[[YE P4P1 ЎPڎ u  P@QQQBQQƮ  ƨ Ɯ U1 ]u  ~E 4P1 Ɯ Q??  PР4PяP
PQP,PE P4P1 ЎPڎ u  P1 (RƤ R1 PŤ S1x УTФWWQaQWQզѡPPEƬ  ƨ Pݏ,   ƨ `PƮ H  Q  RƤ ЦxP'PPz F#P ]   V\     RƤ R11{>  RY:>  Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                  y                        P(S $      UCX042.B                       `c	  P  4[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$INETACP.EXE;1                                                                                p                         q "            С0YЬXdSУ,V@PPPBPPƮ |~|~ݏT   &\  |~ <q ~<h~  PƮ 
@  QS  P[  <$"P<h~Ƹ PPQ`PPQSPƢ cPУU%Y0Y Y=  P22 PtУ PY0Y [  PPPE    0K!Ƣ Ɯ 
<  R  P<Y<YZ  P r  ~E 4P1 VХ4U	яUU<Х0PPYѥ YxС00С  8V8 Ŭ ȏ   xVX[VfVV[%E 	4P1 ڎ Yr  U0 Pƨ XE 	4P1 ڎ -r  U1l E 	4P1 ڎ r  Ŭ ;  P P
t220p Ʈ ?  [    Ʈ R1VY0%Ʈ R0zPR
>  Q*  Y  PPR
JA  Q  P%>  8_  <h4_   Ŭ #_  _  k[  =  X _  W[   |~Q[  C[  P|~|~  |~ <4~</[  ~ <[  ~<Y<X Z< Y<` Z  P p  ~E 4P1 ZSУSSZMSà P	PXУ,VE 	4P1 ڎP09% jp  Ʈ =  ZZ    1J [VfVV[E 	4P1 ڎ +p  Pƨ XE 	4P1 ڎ p   Ƭ Ʈ )A  ]     9  ƨ X  Ʈ X  P?  QJ  P@h  Z<P0P<PjjRY< QЪPPQЪP
PPQЪPPQЪ$PPPQЪ,PPPQ<4PPQxPPPQ<<PPQxPPPQ<DPPQxPPPQ\QЪpPP?1FPPQ<xPPQ<ʀ PPQQQQ  <LP0MP [[PjP~@k[RV Sʌ QЪS(acS$Ъ ( ac Ъ(S,((acЪ$0S4(0acЪ,8S<(8acЪ4@SDSXQW(@ac<@PxPPRP~BT~BUSdeWQЁRЪ<HSLSXQW(Hac<HPxPPRP~BT~BUSdeWQЁRЪDPSTSXQW(Pac<PPxPPRP~BT~BUSdeWQЁRSlЪ\h(hacSƀ Ъp|(|ac֦| Sƈ ЪxƄ (Ƅ acƆ SƐ ʀ ƌ (ƌ acƎ <Ƅ Pƈ Q0{<ƌ PƐ QQR0*{ЪLXЪP\}T`jЪЪ}dpԦrƢ PժlԦxѪlPЪlPPxʈ Ɣ  gb6  PР4PRяPI QСQ䱡զѡV8V8 Qttrtr1ư PP`PƸ PP`P0 1  Ơ R  PP<Ơ P* P1 aUUƜ V8U  U  U  U  |~|~ U  |~d  <#~<Ơ ~ P
ud  PP1 7  X X|~  |~Ud  <#~<Ơ ~ P];d  PPSiW  ЦcW  W@XW XWݏ,P    |~d  <#~<Ơ ~ P
c  PP<Ơ ~Ơ HX X|~  |~c  <#~<Ơ ~ Pc  PP4PX X|~  |~c  <#~<Ơ ~ P
kc  PP1 Ŭ PVP 07  P0P  P =j  ~E 4P1 fkYP1+ (SSRbRSR¢ bP	 0ߺE 	4P1 ڎ i  @QQQBQQƮ 3    Ʈ :  W  ﯆  U    P2b  Z<P1l < P [R  X[Q  XQjQ~Ak[[YAhXiYY[%Ѫ@PPPBPPɮ PP  Yh1 1 l YVְ SFƢ УU|~|~  |~ < ~<(~ <5  Q5  R(P0t&  0ɸ SSUcSSU" à ݏ    à `ֺl *     Eh  ~E 4P1 ɜ P %2  PР4P1~ яPupՠ0 Q&СQ թ	ѡ
ա81  Q
С00С  ȏ   xPUE 	4P1 ڎ g  091LiPPE P4P1 ЎPڎ g   1/ ɠ )|~|~  |~ <4~<ɠ ~ <ɠ ~ /g  ~E 4P1 1  PР4P0яP'8Y80  Qݵ2׷2 Ŭ E P4P1 ЎPڎ f  ɜ YVƮ 	8  T  遲  ɢ K f  ~E 4P1 RP0Xi(E P4P1 ЎPڎ bf  
YP 0P<P^  Z<PM  <jM  PM  P< P^  Z<PQ  <jQ  PQ  횏Pq^  Z<P<hM  jd^  PR^  Z<P<Q  jE^  P<PY0
 <`Y0 s  X0 &^  [<^  Z}ZPQRh be  ~E 4P1 A/  X< PMIhW[4Z0<ZQQ0P5ЧV<Zg(Zk]  VPЧP|gP0PE P4P1 ЎPڎ d  <XY	<hYr  X00<PY	<`Y2]  Z<']  [SVIbW[g<LPg]   ]  (g\  XY@<gS\  WWSgPPPgQQPPgPPPQQPPWWSVSP<XY	<hY0d   /  {/  -  Џ2  P<i\  SS<DP0X\  TlodLOdP  P &\  TPSQ`` `0`9PQQH  V'PH  O  H    P<O  VV[  .-  Yˏ    [  W<.  FW	<.  TW	<~.   b  ~E P4P1 ЎP0P1 E P4P1 ЎPڎE[  I<Pb0P\ b  0()[  ([  W  [  .W  W  Qﱍ  -  ¯   gb  0a<P Wb  QPa-   -  E P4P1 ЎPڎRZT|-  |-  |-  E P4P1 ЎPڎ a  1 E P4P1 ЎPڎ a  "P  [;-  
3-  0,  WЏB   [3Z  YZ  XP xa  0Q a  Pq+  x+  f+  0Z0rP,  TZS+  QR0P1%У c+  У$_+  U+  ,  ,  Џ,  У,  У,  0&,  TZ|,  YPjY  S `  0 `  P*  1 Q0p1 OY  R~E P4P1 ЎPˏ    R  Fj	 Tj E P4P1 ЎPڎ(X  X  7R  X  ) R  Q  QL  PX  *  SУU}X  80)  0S|u+  |w+  |y+  <+  LX  +  ?+  ++  1X   9+  S:+  [0P	Q0I1X   X  4+  S+  [*  <*  *  0dP	Q01WM  1I|~|~ݏHI   |~X  <'~<*  ~ P	Q01W  <W  PQ01  )   )  <W  P9(  P)  <4PQ0x1 яc	c<{W  P9(  P(  S4*  )*   m^  ~E P4P1 ЎPQS)  [E PA`&SSS@CTQE ԤDQD QQE P4P1 ЎPڎ ^  <P  cV  PP	Q0 1 2L  f|~|~ݏPI   |~V  <c~<c~ PP	(  hV  /aV  (  MV  HV  Q<9V  P<cP* PakZW<(  T"(  Y
P ]  0 %]  '0<(  T0<(  T0<(  T0RZժd<PhU  T YU  S<TU  Vˏ    ZU  W0 P|A(  |C(  |E(  T-(  YP0eU  T P~E P4P1 ЎPQd   ѪTQЪTRQTСTTRTE P4P1 ЎPڎ<P:SZRТTRRТTR W<P%<DP)ZdiP̺VV<P:G'  ?'  %  Џ2  P%  Y	< PQ<T  ST  TVW o[  ~E P4P1 ЎP0CE P4P1 ЎPڎP A[  Q&  (&  <DP¯ < P  [  0l$  P`PՠTРTPRP<DP < PZ<DPRZAS  ЪdR< P1pЪdRP0tZRS  
 Z  1L P0Y Z  Т|[9k5$  0z$  $Ru$  q$  S$  Z$  H$  0G$  
G$  R0RZЪdR& ´   h aH   dR Y  P0 Y  d9Ԫd(_R  ^R  8O  OR  /N  N  Q  +R  HZR Y  P0hZR Y  (R  R  K  Q  )K  K  Q  P*R  `#  SУU}R  80	H#  0 $Y    У|[kk[ Y  [1 03 УdZ(ʸ ʴ   h 9G   <TbTXЫHP 0pЏ<$  Ы@<$  ЫD8$   "$  Y"  
P tX  0M
 ~X   *0% <T0 <$T$0
 <0T00 F  !|~|~  |~Q  <~<T~ <T~ÏT   !  SУTSÀ У|[
 H   H  H  Qø P_  У|P0 0
PPPPz P P   P     P     	   TЬP0ÏT   E!  SУTSÀ У|["  "  $"  0"  Ы"  Ы"  Ы "  Ы,"  wO  rO  ի	 dO  ի  XO  y"  	PTV"  Y V  0 V  P	 0 У|[00 +O   PP"  <!  FP	<!  TP	<!  !  N  0cP0 	PT!  Y $V  0
 .V  PK0r QQQQQ VG   RG  P0,0G wG   sG  EG  Qv~  УdYɀ À  F   F  P0~<9!  T0]</!  T0Q<%!  T0E<!  T09PÏT   W  RТTRТ|[<T0<T0<$T$0<0T00M  1 M  M  ի	 M  ի  M  M   |   v   M  |o   |q   |s   ,0,P1vL   F   @   $:   04   0   ,    (   ,      SУ R E   E  E  Q|  У R E   E  E  Q|  L  PL  Q:@PP  Q  :     :  :  P_9  bL  X9  [L    ?  <P?  %  WYYޟLM XhXY?  PР,Q  P< PYY%w%  WޟA XXVhXXVמ$PQQg)Q`Y%PLƜ [УVƤ P
< PL(4Ƭ ˬ Ƭ @ У,V!  @ @  PPP@   @PPƐ<(PM?  Ƒ<У,P	 x$  w@  z  P3  1УV|~  @   <4~ P<  @  h4q>  @ Ƭ У,Y8Y'ɮ <P0V{
ɮ #                                                                                                                                                                                                                                                     z                        T5 $      UCX042.B                       `c	  P  4[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$INETACP.EXE;1                                                                                p                         t "            ?    |~|~  |~J  <4~<4~ <4~1uSH~E P4P1 ЎP  Rc  E P4P1 ЎPڎä  PUd  R ~E P4P1 ЎP S 0< Q0 PE P4P1 ЎPڎ1 RS  R
     E P4P1 ЎPڎ Uä T  RP~E /P1 P]cb򏠻
 P|E 	/P1 ڎ  P$  Q0{PQ?,  Q?:! :P|bQ
RP
8# ~E 4P1   E 	4P1 ڎ<& m|~nR~nS|~^T ` PPPP7?  Q[X% <bP d>  d?cbX P=  QcQRb[p% < & m|~nR~nS|~^T ` PPPP>  PQ5ЬPbP d=  d?cbX P
=  P<cQ0 <>  TdԤԤЏ  ЏINTEЏRnetЏ    Џ    Џ     $&A'(*,>(Q`.>.QSПhM U0' <  PG  P-G  Q}}}}}G  PF  Q}}}}}У,PP`PRF  [zRPV<f~<VަR괠
DG  8G  ",G  |F   PQF  [F  1 eF  kF  F  bF  WF  QMF  1x FF  Q(F  k"F  AH  P(PF  PF  PF  F  * 3P4F  
<,PP(F  R  SPP*}P	F  8Q<
QE  < P}AUF  HF  @$Pʣ@7F  
ʣD1F   PP  F  P  UХ8RПXT0 }PE  PE  <$PQ T < PQQ37rrqkqh Hh h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h A^dh gh Q
.^ ^ ^ ^ 6879^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ |v|n~j{Q%$ywyJz6ܴ[D[DL L L L L L L L L L L L L L L L L L L L L L L L L fQ"mu    hg        f1< <PQP IK  #ȏ   $ LK  P
   Q0lv6  K  U0K,      Џ2  P  
  0Z=C        0xQ0k P  0   !        00 0 ПXT0$    0| 0   SУU}DC  80@P WJ  00 aJ  Pя   P0\ Q*  R< PQbSУTSï QQ   1P I  0ʏ   $ I   I  ~E P4P1 ЎP0E P4P1 ЎPڎ I  <:B  PPPPB  >(P#B  nB  > QY|~  Ym    ]B  ݏ  ɰ  
  	   TЬP0<
 7   0  	   TЬP0ЬR 
բ` @*1s  	   TЬP0mЬR @ ;բ`6° ,5RS H  P0 H  P  h  7   0<P  Q0*qSSRY0 ÏT   ]  RТTRS0z H  Y	< PQiP@  S@  T -H  ~E P4P1 ЎP0E P4P1 ЎPڎ H  P1 < PSТdY1 <Pw [YR0l P[`  Q0r  P  ɴ P5 @S+|~  YY u@  ݏ  ɰ  
Q  Q0crP 5  ]5  Q< P<PPPz F#P 2@    "@    Pd  Q0oW5    O5   Q   Տ    ' Џ
  Q]P1 RS   0P1w 0УLP2`$ 4`  QQQQ9       )  P	ȏ    УLP 
03PPRð PSPRPЫ@RТlSP E  0~E P4P1 ЎP0hE P4P1 ЎPڎ E  0t0(<~SPb
Т|PР@PРlS
~E P4P1 ЎPP  Q~E /P1 P]ca򏠻
 P|E 	/P1 ڎE P4P1 ЎPڎ  P

Т|PР@PРlS  0
0P
0Џ   P
0PPXBY7  Z7  [1| U D  p D  0SP0IPPX-Y%7  ZL7  [11Џ         YZTS`SP0ЎSPPX8Yg7  Z7  [1 QÜгTR~E 4P1 ˏ    R  
  1u 0E 	4P1 ڎ C  0mPPX7Y7  Z7  [1m ð Pð GSV(`d5  `%5  5  Q0n<PSE 	4P1 ڎЏ|   X7Y6  Z6  [ .C  SV(`dk`YjZQ0GnXQ0]P 7  6  Q00nVSð P
ð S0 ЎS0
XPSv P B  0~E P4P1 ЎP0.ÜP E P4P1 ЎPڎ B  01	0<~SV(`d7  `*6  6  Q0ymSv v  U !B  p (B  0 Sv P0ÜQгTR~E 4P1 ˏ    R   1H 0E 	4P1 ڎ A  SV(`d#6  `*5  5  Q0l<PSv E 	4P1 ڎ A  0n	Џ   PSv  S        ЬS PУPpR  Q~E /P1 P]ca򏠻
 P|E 	/P1 ڎ  0w~ SV
  SУ,T<QTP1 Rư 2U1 UQɏ   QPPPQdR(R<bTRTSУQS<TTTQxQQxQQRяi Pư QРQU<bTRTSS<Tư RQTP~ ~ SV8  @8   !8  HpLHH(H8  pu8   #g8  Pƀ TPP(PQ8  ƀ <8   #.8  XƐ \XX(X8  Ɛ 8   #7  `Ơ d``(`7  Ơ ȏ    ~ ~  |~y  PPRR1|~|~ i  |~a:  <#~<~  PRR1 B:  RR1 ð UQ Q|~  |~ :  <#~<~  PRR1U :  RR1H ХTЄV?ЄTQ Q|~  |~9  <#~<~  @   TVR|~   |~9  < ~<~  |~|~  |~~9  <4~<~  <~RP~  |~PPP1|~ 59  3  P< ~ P1`$9  P
h# P9  }9   }9   < 9     8  18  1 |~ PP1<PST* TS$PP1QaQQ QQ С(ПA P<"TPT<@PT01  PРP$ P1T8  #Ѡ`J8  ПXPѠ`98  <@P1eԣ T:_  QTLTd |~|~
8  |~7  <'~<~  P1
7  PP1 7   7  ô 7  ø 7  ü h|~|~7  |~7  <~<~  P1 c7  PP1 ~7   y7   t7   hb7   Z7   R7   N7   F7   >7   |~|~)7  |~6  <~<~  P1) 6  PP1 0P<~P/0 PT<~<~TP? U~Х(PE 1 ڠSQ0PЎS0$(0,4Ŝ 8}ż (Х<<"  PPP0`(Р,РŜ |ż Sż 
<  4P4P 4P$E 
Х(P1 ڎh?? h? US~Х(PE 1 ڠПA P<"QQPP0`(Р,РŜ }(ż ԥ  <	N P  T  T 4P 4P$0P4PPT
 Q0PQ0PE 
Х(P1 ڎЎSh?h?ô 4  ø 4  ü 4  |~|~4  |~4  <#~<~  h? 4   4   4  |~|~4  |~d4  <~<~  2<	QУT U~PE 1 @tM  Ŵ 1s ~Х(PE 1 ڠ xĴ Ŵ  @ŕ Š  XXXХ\\ԥ\ȏ   <ʏ   @E 
Х(P1 ڎQE 
P1 ڎQPP+ |~ PP<~P2 ÜRP 7  0P0P0 7  SV(`d,  `.,  ,  Q0bVPw P QRB  PPPQRB  PPPQRB  PPPQRB  P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      HH  B   XI     Q                   
    9                                                                                                                 Ph  `h      ̌  ݌        2
  @
    <J    DJ     ; PJ  !AS!ASHost: !UB.!UB.!UB.!UB Remote user: !AC VMS user: !AC   J  Add Proxy -  J  Delete Proxy -   J  !AS!UW:  J  _!UW J  _BG # J  !ASdetected !AS exiting before !AS   K    INTERnet ACP shutdown  4K  INTERnet ACP Error  
 PK  INTERnet ACP    	 hK  'socket'    	 |K  'accept'     K   incoming User Information:  K   Abort Request   K   Connection Request  K   Connection Request on   L   Accept Request   L   Reject Request  8L  - IP address access list -   \L  - service limit -    xL  - total service limit -  L  - unprivileged port -    L  - no proxy cache -   L  - proxy cache empty -   ) L  - remote IP address not in proxy cache -     (M  - no VMS user names -    HM  - no user information -  hM  - VMS user name not found -  M  - no client user names -     M  - client user name not found -   M  from      M  , M  INTERnet ACP AUX                                                                                                                                                                                                                                                   {                        @D $      UCX042.B                       `c	  P  4[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$INETACP.EXE;1                                                                                p                         H "     )       S error during process exit , $N  INTERnet ACP AUXS - IOC$VERIFY call failure  XN  - host IP addr       tN  - VMS user:  N  - client user:  # N  UCX$RSHD - Permission denied !AS!AC UCX$RSHD - Permission denied
  N  !AS!AS!AS !AC !AC    O  !AS!AS!AS!AS!AS!AS   $O  !AS!AS!AS!AS	 8O  Activate     LO   Server 
 \O  Timeout Idle     tO  Deactivate   O  Modify   O  SYS$SYSTEM:LOGINOUT.EXE       	 O  !AS!AS!AS    O  TELNET   O  RLOGIN   O  Login    P  Logout   P  Abort  "P  _TNA       (j  TNATNDRIVER    Hj   Dj    Lj  |P  P  P  P  P   Q  Q  8Q   P  UCX$TELNET_VTA   P  UCX$TELNET_FREE_UCB  P  UCX$TELNET_FREE_BUF  P  UCX$TELNET_MESSAGE   P  UCX$RLOGIN_VTA   Q  UCX$RLOGIN_FREE_UCB  $Q  UCX$RLOGIN_FREE_BUF  @Q  UCX$RLOGIN_MESSAGE        fQ  !AS Status = !AS, ~Q  INTERnet ACP failed to set the Cluster Timer Q  INTERnet ACP AUXS failure ( Q  INTERnet ACP Remote TTY Request Aborted % R  INTERnet ACP Remote TTY Illegal Call / 1R  INTERnet ACP Remote Terminal Accept Fatal Error2 hR  INTERnet ACP failed to start the Internet Cluster #INTERnet ACP IRP allocation failureINTERnet LoadedINTERnet Load FailedINTERnet StartedINTERnet Shutdown&INTERnet ACP Recover Abnormal ShutdownINTERnet ACP Abnormal Exit INTERnet ACP Start Cluster Timer!INTERnet ACP Gave up Cluster Name%INTERnet ACP Process creation successINTERnet ACP DECnet abortINTERnet ACP DECnet disconnectINTERnet ACP DECnet exitINTERnet ACP DECnet pathlostINTERnet ACP DECnet protocolINTERnet ACP DECnet thirdpartyINTERnet ACP DECnet timeoutINTERnet ACP DECnet netshurINTERnet ACP DECnet confirmINTERnet ACP DECnet intmsgINTERnet ACP DECnet rejectINTERnet ACP DECnet connec(INTERnet ACP Remote Terminal Accept Call'INTERnet ACP Remote Terminal Close Call(INTERnet ACP Remote Terminal IRP Release4INTERnet ACP Remote Terminal Services START - TELNET3INTERnet ACP Remote Terminal Services STOP - TELNET4INTERnet ACP Remote Terminal Services START - RLOGIN3INTERnet ACP Remote Terminal Services STOP - RLOGIN   0123456789ABCDEF hV  BG0:    ty        xy       y  y    |y           V  LNM$SYSTEM_TABLE V  UCX$SLIP_TRACE                                                                                                                                                                                                                                                                                                      X  !AS!UW          X                                   DX  _BG    X   WX  _BG               X     X  zX                                                          X    X                                                X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              UCX INTERnet V3.0            tc  UCX$INTERNET_SERVICES                                  (Y     c                                                                                                                                                                                                                                                                      d  BG: BG  d  UCX$INET_ACP_LOG d  UCX$INET_USE_ALTS    e  LNM$SYSTEM_TABLE  (Y  c          <e  LNM$PROCESS_TABLE    Xe  SYS$DISK he  SYS$SYSROOT: |e  [SYSEXE]INTERnet   F   H  I                                                                                                                                                                                                                                                                                                                     f  _______________        g         g  _BG65353:_BG65535:$                                                                                                                                                                                                                                                                                                                 (Y                                    qh                                                                                                                                                                                                                                                                                                                  i  !AS!UW        i                                   i  _BG    i   i  _BG                          DP                                                           hj  dj                                         j          Request from Remote Host: ---.---.---.---. Port: -----                                                                                                                                                                                                                                                                          8   j         (Y  O  O  k                                                                  (l  $l   / ,l  $l          SYSTEM        `l                                                                                                                                                                                                                                                                                          YACP or driver attempted to $PRINT at an IPL greater than ASTDEL with a pageable executive                                                                                                                                                                                                                                                                  0   n  INTERnet ACP Lost Sync on ____Data Link Channels-INTERnet ACP Restarted     Data Link Channels5INTERnet ACP Restart once more     Data Link Channels2   o  5   o  INTERnet ACP Restart     Data Link Channels FailedINTERnet ACP Restart     Data Link Channels Succeeded)INTERnet ACP                                                                                                                                                                                                                                                   |                        '5 $      UCX042.B                       `c	  P  4[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$INETACP.EXE;1                                                                                p                          "     :        Created INTERnet interface:                 )INTERnet ACP Deleted INTERnet interface:                 %INTERnet ACP Created SLIP interface:                 %INTERnet ACP Deleted SLIP interface:                 -INTERnet ACP Failure Opening SLIP interface:                 BINTERnet ACP Failure Creating SLIP interface on virtual terminal:                 8INTERnet ACP Failure Creating IFNET for SLIP interface:                 7INTERnet ACP Failed Creating IFNET for SLIP interface:                 !INTERnet ACP Failure Code =      7INTERnet ACP Failure doing SETMODE for SLIP interface:                 *INTERnet ACP Re-activated SLIP interface:                 *INTERnet ACP De-activated SLIP interface:                 .INTERnet ACP Forcibly Deleted SLIP interface:                 .INTERnet ACP enabled VMS INTERnet cluster on:                 /INTERnet ACP disabled VMS INTERnet cluster on:                 @   s                                                                         s                                                                                                                                                                                                                                                                            	 u  u                                  
          0u  LNM$JOB  @u  UCX$INET_ROUTED_INPUT     $u  hu                u                                                                                                           u  SYS$SYSTEM:UCX$INET_ROUTING.EXE  v  UCX$INET_ROUTED   (v  SYS$MANAGER:UCX$INET_ROUTING.LOG Pv  NLA0:                   d      
   I 
  .  
  ^                                                                                                       UCX$INETACP_                   v      /M   

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             t
 PvяTRUE3 P5яTRUEpa  YЉPH| `Z|P$u  Px Չ  P1   P1   6  P1  5|~2P }   P	я   PB    P   0 P N   ЎPl*  u`+  g  1   VD 	5D  Տ    ' ПTP`ПXUЏ   }l}ň Х|V,> ,3 ПXTȏ   $  CPP1 <P* PaUUХ,PРd}D 0FPsuUХ8RxP .  0 8  P4<PС'Q$BХ8RQ09, !  <PPQ0",0uЎP
          Ѭ1y ]^4  4  B 4  4  X  ^0]$  4  m4  ^Ў]Џ   P  O4  Z4  H4  ^Ў]E4  ]^,4    &4  4  ^Ў]PQј < ПXTp0 < ПXTx0   	   TЬP0N dr  R¤P¤Ώ  Pz F#P ~|~ n  У,V@QQQBQQƮ УPР0sP;0 PQ
P 50 ?Ʈ 
Q0\*Ʈ   PJƮ #Z  <PP 0 Ʈ nPhQk'  (Y 1mYgz<hvi~vm<`NTJXP1*1WWiW.W#1 У PI <hXRRiRR<(i<WiWWX$ià PРQQiРP<(Q`h<à P  à SZW<8XWPXPPX(X<.(WCcWXXQWZ[*XBWK[SZ(8<Ц8QQAgWgWAk[k[AhXhXk1 ʜ XWW< @W |~ WݏT   h P   WW   Ժ 9 |~   <h~ P<h~h1A|~|~Xg|~:<#~<h~  Pɰ PP ݏ"  <~ݦXݦ\ `i 
Pƨ ʠ 03cIÏ   5Ц$P^n^P^n^Q<R <(R|~PQݏti  c|~ <# ~<R~  ^^ B VhЦxP)PPz F#P  V  У,VУ[Ƣ @QQQBQQƮ 8P1 PV1#ˤ Q1*[Uա(1СD[1ЫQ} Ơ (1 "1   (OPP1 <(P* P1 aUUV8(P|~PݏXj    |~<< ~<Ơ ~ P1 <PP1   o}=cPP`Pԣ<T@ԣLà ԣ8ԣHԣP*ԣ4ԣ 0O SP}60UƢ 500<P<P0*<PƮ <PQ0$0à X$Џ]  Q! P1tɏ   QRà RXhУQ QС(P1яI  PЏI  P|~ P|~h< ~<(~ P1	hPP1 R<U*QPPƔ QQ1P
*P*Uݴ*1m<*PxPQxPPQPP*U1RԣTT<QWWPPƕ ,QQ 1	Pa	Pz PPU1U1 QVQ<WTQPPƖ "QQ 15Pa	Pz PPU1 U1 QgQQ<QRTƗ QQ   1 U1 QTPPR|~  R|~h< ~<(~ P1 hPP1 *գ4	0 P1 << T$'SVVPP(PVgPP(PgVPP(PcVSP*գ40b PH<PPcִ Ƣ |~P S  |~h< ~<(~ PhPPS<PPRXP  RP0d>  4PP1H|~ ݏJ    |~<'~<(~ PuPPk|~|~ |~k<#~<4~ P0RPP&x   R R<4P1 }}sq|~ ݏJ    |~<#~<4~ PPP	P C}C*=|~ ݏXj    |~<2~<4~ P
PP<4~ԣ4>R  !|~|~  |~ <4~<4~ <PУ4P* PaUU V8Ʈ 2}Z}t  }Zo1r| 
   TЬP0|
[ЬS0  à У UУ,VŤ Y1o Щ(R\RR|~|~R
|~y< ~<4~ P3\PPTd
dd[TR[[/[[ à ݏ   à `[ݨ|~|~S|~ < ~<4~ գ44P
УP<(P<QR
AbQ
AbQAbRbQ|~|~Qb|~ <0~<`~ < ЬSУ,R° PPQ`PPQSP¢ cPTSU0tЬSУUУ,VŤ R0B8PƢ 07R0' $PV
<P00SP}p0 Ƣ (WWP`PWPPVfQ 0< PP PРZƄ [<kP=ЫQ[xPP[P-[PWxWWZGaƆ PWPW[W[Ξƌ [kƆ PPZPPPZQQPPZ<kPPЫQ[xPP[P5[PWxWW~GaY˩ZXXiƎ PWPW[W[ƲƎ PPPV&QVXXXQQWчggPЧgPWX޺PVgRVXRWgPPPgQQPPgPPPQQPPʧgWWXRWXRXRWg}gP}g}PWWXں R~TЬP0Ο J~TЬP0 MTЬP0 JTЬP0 |TЬP0R< PIb[JbZЬX|~|~ݏT   !|~<q ~<h~  PϽQP  <pP<$"PPPXh# P< PPYkU< PQPRZ[ [[[PkY[Y0Z<P0P<WÏ   WV8WW<LPZ( jʌ WW(Vʌ KrWWЪ   ( (0(08088ZSЩDQSXQW<@PP8@xPPP~@hT~@gUQ<eRR@@ZSЩLQSXQW<HPP@HxPPP~@hT~@gUQ<eRRHHZSЩTQSXQW<PPPH`xPPP~@hT~@gUQ<eRR`h`t|t|<Ʉ PP|ʄ <ʀ Sʄ WZWWSgPPPgQQPPgPPPQQPPWWS   VVPY<P Z1 <[<L  [[ŏP   [P PxPPPP  HP }Zx[P QQjPQQx[PPQQԪԪԪ[ 0	 P\<[1 <$P1z0|PTV֪Y1x[WjWTQiaQVVVWPWV1 PWPfP~n\ѮUP~}n~Ѯ  &    nnS  ЮQ(acЮPЮQЮS(PacЮSЮQ^-^ЎSЎQЎPP    PP(acЎP(PacU<RjVSxSSSRХP<TU` PTURx[VjVЉfԦ\1c<[1ZЦX0P֪
PPYTX11xQQQQXTiSSSSUS                                                                                                                                                                                                                                                   }                        n $      UCX042.B                       `c	  P  4[UCX.X42.BL21.PLAT_V.VMS_V55.KIT.B]UCX$INETACP.EXE;1                                                                                p                         x "     K        X<WxWWWXW1Q1 Wh W~n\ѮUW~}n~Ѯ  &    nnS  ЮQ(acЮPЮQЮS(PacЮSЮQ^-^ЎSЎQЎPP    PP(acЎP(Pac UxWWW[XQVRePѠQPRPRU Q UW<WЪP`X ` PW<[x[XXXVhԨ
PPPPYQPW3(Pa
QY, n WcXV<[12ЦX0 P֪
1x<P11xQQQQXTiSSSSUS X<WxWWWXW1 Wh W~n\ѮUW~}n~Ѯ  &    nnS  ЮQ(acЮPЮQЮS(PacЮSЮQ^-^ЎSЎQЎPP    PP(acЎP(Pac U <WЪPѠX  PWﺏ <[x[XXXVhԨ
PPPPYQPW1(Pa
, n WcXX\P B
Y  P QjUjUQiS[R>Q	eUTQQR+QRPxPPxPTDeTSd	PPRPQPQPQ[RViWWWQRFQRPxPPxPTXTTWSSUSxPTXTPPRPQPQPXTiWWW[9WSXS&Uhahz PPPSP	 T[PY< P{Z 0P ᷤ
1  Q<RêTSxSSSRR1 xRWTU<RЪP QѠQ  PRW dW~n\ѮUW~}n~Ѯ  &    nnS  ЮQ(acЮPЮQЮS(PacЮSЮQ^-^ЎSЎQЎPP    PP(acЎP(Pac
\T
1	 Q<RêTSxSSSRR1 xRWTU<RЪP Q`Q ` PRaPѠQP[UP[ Q URW dW~n\ѮUW~}n~Ѯ  &    nnS  ЮQ(acЮPЮQЮS(PacЮSЮQ^-^ЎSЎQЎPP    PP(acЎP(Pac
1 Q<RjVSxSSSRR1 xRWVUСP<TU` PTQURWfW~n\ѮUW~}n~Ѯ  &    nnS  ЮQ(acЮPЮQЮS(PacЮSЮQ^-^ЎSЎQЎPP    PP(acЎP(Pac ׮P B
vY  PeY< PBZ  <[0P< PTVY<[ЦX*
 
XT%0Pf'VU<[[Y0RP֪T\<[1PPYЬX0|P֪PY< PZ  < P<[0PTVY<[ЦX*
XT0P֪T\<[1PPYЬX0P֪Pw0'jn]aP6IB0.0JÏ   Wf\XPA0!%ͳXP<PQ0
8ϯJXP?0;ͯ4Ц$PPP*QQPP!wXP1Y)iPPYiܭXP1Ʈ 瑩Q'
  Nգ4I|~|~  |~ <4~<4~ У P8ȏ   <<  <4~ԣ4|~|~  |~ <4~<(~ ȏ   <<8 Ŭ <(~uQ0	Ʈ <PQ000(Ʈ ﳭQ4	  0tp1nR201*% PxPPPP 1P10[P101.B1hV\DQ ~Z1U<[
ꞣY0P1*֪TVЬ$YYPPYY<[c1 ЦXЬ$YYPPY*
 
XT>	00P.fVU<[[Y0,P1mﮮ1 ֪dЬ$YYY <[1X ФXլ 
B	00mP$*
 
 X<[[1!1S֪h1 hxУP<yXP< P Q#<PQPQ
QP|~|~Pa|~ <0~<(~ 0Ʈ _UP06P0KƮ nttrtrȧP22424<7|~ ݏXj    |~t<2~<(~ P
<[PP0EPh# PYP0P  Ŭ  Ŭ 5ʏ   x<PПXT3 Ơ (Ơ <(~n<ʏ   < 
NУ YJ|~|~S|~ < ~<4~ <ʏ   < 
NХ00Х   ɬ  ɬ cּ Ƣ S
vpP0̪k%۪^QD|~|~ݦ|ր |~ <0~<(~ 0Ʈ ϒmR	YP^iS򏠻
 P|
 1
1W QQ \ܞnQL ǃQ    =FУPQ 2IoQ0=MzУUUS}Q  W0(rS1BbU}/80+T2c1!<Pٵ	CƵz(q<pYmZX	< YZЏ  R1 <Qjo1 JOa:?&+6-1	<YZ< YZЏ  RQ[ִﷴ<Pя  P1$(P$ﳴS|T<, n (c<W0\PPP<pP+P<iXFYZ1 1 [1 [}йWWV<1[йWgj1oiW: Xg<P,WQVV<xV<XXV³(VgjXP12W1>йW1wéWV%iWYjYZQaVYYZQaVY1YjYZQaVY1~ Y Y	 GRC@ BZ<YP Y< P(PjP~     P  J  m|3    Sݏ    J  P
{H   xbH6 	I    P<PQ1PPP
Q@? A?X -^XP%i r {              *4>HR\L L L L L L L L L L L L  P*4 >HR[dmv'Q+/Q"8QVQ8Q]Q1_QQCQ[Qg12VQ7QYQڞoQўmQȞ~QQ狼Q1﷫Q1ʫQ1߫Q1Q1Q1zQ1p&Q1f7Q1\Q1R9Q1H4Q1>SQ14qQ1*>Q1 QTﲬQKݬQB	Q9Q0Q'Q   ЬQЏPP ЬQ   P| .PSS^^S}P~ПXV}l (c}PЏ@  cԣ(Pa^S^TПhM U0' S^|  < PQЏ  P |~ ݏ   ݏT    P3|~  r <f~ P<Q~1|~|~ݏT   H g  <1~<~ P2QQ0 P<~1(}       <~ ݟ܂ *nXRLX
PF D<-~1 Pp# P,PPPz P |~ } x|~ E  >Pȏ   $ȏ   $PwЏ   PkPDʏ   $NPz P  L        `   Џ   PPʏ   $P    TЬP vm~| $hS+RP]cb򏠻
 P|  <;~P   ʪУV<h﫪XP1 Q:X|v飯   ﯪPP1 <PPP1g P1X u4Ƭ Ƭ P!U|Q d 
P1 *{RRQp1 <~  ﾩУV<h}XP1|Q:Xpj   PP1y<PPP1U>(P>P1/|~ ݏfX    |~F<2~<9~ P1 <'PP1 |~ ݏnX    |~
<'~<~ P1 <PP1 PӨ4Q88Ƭ Ƭ 	PqŲQ Qd ZP1f *RR_QNQA~PPE 1 @tM ЎPС00E PP1 ЎPڎ1 <!~jQ
PȹU d                                                                                                                   