                            i $      DCEVAXMUPA013.A                                                                                                                                                                                              %p               DCEVAXMUPA013.A  BACKUP/NOASSIST/COMMENT=VAX/VMS SPKITBLD Procedure/INTER/LOG/VERIFY DECW$KITD:[*...]*.*; _$2$DIA24:[DCE.DECC_V13_BL4_MUPA_MAY05.][SYSUPD]DCEVAXMUPA013.A/LABEL=(DCEVAXMUPA)/SAVE/BLOCK=9000/GROUP=25  VAX/VMS SPKITBLD Procedure  GBDBUILD       @   L       V5.5	 	 _OPNSME:: 
  
  _$2$DIA24:  V5.5-2 
  $                        * [SYSHLP]EXAMPLES.DIR;1 +  , 6   .     /  @   4                            - 6    0   1    2   3     K  P   W   O     5   6 p&   7 $   8          9          G  @  H  J  I                     DCE.DIR  ;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         * [SYSHLP.EXAMPLES]DCE.DIR;1 +  , ;   .     /  @   4                            - 6    0   1    2   3     K  P   W   O     5   6 L   7 02   8          9          G  @  H   J  I                 DTSS.DIR ;     GDE_DCE_APPS.DIR -     	POSIX.DIR  4     RPC.DIR  3     SX.DIR =                                                                                                                                                                                                                                                                                                                                                                                                                         * [SYSHLP.EXAMPLES.DCE]DTSS.DIR;1 +  , ;   .     /  @   4                            - ;    0   1    2   3     K  P   W   O     5   6 ~'   7 P,:   8          9          G  @  H   J  I                            DCE$DTS_PROVIDER.C 2   &  DCE$DTS_PROVIDER_BUILD.COM /7   (  DCE$DTS_PROVIDER_GC1000.EXE  :   &  DCE$DTS_PROVIDER_HOPF.EXE  l7   &  DCE$DTS_PROVIDER_NULL.EXE  y3   &  DCE$DTS_PROVIDER_PSTI.EXE  4   &  DCE$DTS_PROVIDER_SPEC.EXE  5   &  DCE$DTS_PROVIDER_START.COM 1   &  DCE$DTS_PROVIDER_TRAC.EXE  6                                                                                                                                                                             . * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3 +  , 2   .     /  @   4 S       
                    - ;    0   1    2   3      K  P   W   O     5   6 %86Պ  7 [   8          9          G  @  H   J                  /* ** @OSF_COPYRIGHT@ */ /*#  *	Module dts_spectracom_provider.c   *	Version V1.0   */  /*  * Copyright (c) 1990, 1991 by0  * Digital Equipment Corporation, Maynard, Mass.  *H  * This software is furnished under a license and may be used and copiedH  * only  in  accordance  with  the  terms  of such  license and with theH  * inclusion of the above copyright notice.  This software or any  otherH  * copies thereof may not be provided or otherwise made available to anyH  * other person.  No title to and ownership of the  software  is  hereby  * transferred.   *H  * The information in this software  is subject to change without noticeH  * and  should  not be  construed  as  a commitment by Digital Equipment  * Corporation.   *H  * Digital assumes no responsibility for the use or  reliability  of its:  * software on equipment which is not supplied by Digital.  *>  * FACILITY:	Distributed Time Synchronization Service (DECdts)  *C  * ABSTRACT:    Implements a DECdts Time Provider which obtains the 5  *		time from a Spectracom radio clock connected to a   *		terminal line.  *5  * ENVIRONMENT:	OSF Distributed Computing Environment   *:  * AUTHORS:     Digital Distributed Time Service (DECdts).-  *		Distributed Processing Engineering (DPE).   *                  * DATE:	June 20, 1990  *  */    /*/  *                           DESCRIPTION OF THE   *			   SPECTRACOM RADIO CLOCK  *  E  *	The SPECTRACOM-8170 and NetClock-2 are WWVB receivers suitable for E  *	connection to a serial port. These function within the majority of +  *	North America. They are manufactured by:   *  *		SPECTRACOM CORPORATION  *		101 Despatch Drive#  *		East Rochester, New York, 14445   *		(716) 381-4827  *E  *	Contact SPECTRACOM about availability of products suitable for use 
  *	in Europe.   *M  * --------------------------------------------------------------------------   */   M /* -------------------------------------------------------------------------- +  *	Compiling and Running the time provider.   *@  *    Two steps are required to build the time provider program:  *A  *    1. Generate the interface file dtsprovider.h and the server @  *       stub code dtsprovider_sstub.c by compiling the IDL file@  *       /usr/include/dce/dtsprovider.idl with the IDL compiler.>  *       Note that only the server stub needs to be generated.
  *            C  *       % idl -client none -no_mepv -keep c_source dtsprovider.idl   *F  *    2. Compile the C source code and link with the libdce.so library  *G  *       % cc -I. -std1 dts_spectracom_provider.c dtsprovider_sstub.c \ 7  *         -ldce -lpthreads -lc_r -lmach -o dtsprovider   *  *A  *    To run the program interactively, simply type 'dtsprovider'   *  *	% dtsprovider  *D  *	The provider will then ask you to enter the following parameters:  *E  *	1. The name of the device to which the radio clock is connected,     *	   '/dev/tty02' for example. =  *	2. The poll period, which is the number of seconds between @  *	   queries.  Entering 60 for example would cause the provider#  *	   to be queried once a minute.  B  *	3. The Base inaccuracy, which is the number of milliseconds of >  *	   systematic inaccuracy in the timestamps delivered by theE  *	   radio clock. The default value is 100 ms. If the times returned A  *	   by the provider are systematically incorrect, then the base *  *	   inaccuracy may need to be increased.<  *	4. The number of timestamps read at each synchronization.=  *         The range is 1 to 6 readings and the default is 4. <  *	5. The 'disallow clock set' flag which causes the serviceA  *         to enable or disable clock adjustments which DTS would A  *         otherwise cause. This is useful during TP development. >  *         Setting 'disallow clock set' to TRUE disables clock  *         adjustments. C  *      6. The 'output trace' flag enables and disables the logging A  *         of TP tracing information to standard output.  Setting A  *         the output trace flag to true causes information to be   *         logged.  *C  *	The provider can also be run in the background using the command   *	line interface:  *'  *		% dtsprovider -d /dev/tty02 -p 60 &   *>  *	To view the valid command line arguments start the provider=  *	interactively and then exit. The arguments will displayed.   */    /* Include Files: */  ? #pragma  nostandard		/* A VMS only Module                    */  #include <iodef.h> #include <ssdef.h> #include <descrip.h> #include <lnmdef.h>  #include <ctype.h>   #include <socket.h>  /* #include fd.h */    #include <pthread.h> #include <stdio.h> #include <string.h>  #include <fcntl.h> /* #include <sgtty.h> */ #include <time.h> 0 #include <dce/utc.h>		/* utc library routines */E #include <dce/dtsprovider.h>	/* This file is generated by the NIDL */ # 				/* compiler from dtsprovider */ 3 #include <dce/dce_error.h>	/* DCE error messages */ 6 #include <dce/dce_cf.h>		/* DCE config declarations */ /*  	  *	MACROS   */  /*
  *  Constants   */ 
 #ifdef VMS  . typedef struct IOsb {				/* IO status Block */     unsigned short status;     unsigned short byteCount;      unsigned long  devStatus;      } IOsb;    /*D  * This structure contains the current service synch serial number. C  * The message is sent to the Time Provider to wake it into sending &  * a time response message (TPrspMsg).  */  typedef struct TPreqMsg  {      unsigned short version_major;     unsigned short version_minor;B    unsigned long TPsyncID; 		/* service synch. Serial Number    */ } TPreqMsg;    /*5  * Time Provider message to the se                                                                                                                                                                                                                                                                                                                          _ $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                              % "            rver contains a set )  * of time stamps or a time out response.   */  typedef struct TPrspMsg  { !     unsigned short version_major; !     unsigned short version_minor; ?     unsigned short status;        	/* TPI message status 		  */ H     unsigned short TPmsgType;      	/* type of message (control,data) */L     unsigned long TPsyncID;             /* message/synchronization ID     */
     union      { 5 	TPctlMsg     TPctlMsg;    	/* Message contents		  */  	TPtimeMsg    TimeMsg;
     } TPdata;  }  TPrspMsg;    
 #endif VMS   /*  * Threadsafe macros  */  #if _DECTHREADS_  - #define BEGIN_NONREENTRANT cma_lock_global(); - #define END_NONREENTRANT cma_unlock_global();    #else    #define BEGIN_NONREENTRANT #define END_NONREENTRANT   #endif /* _DECTHREADS_ */  /**  * Tracing Macro, Execute the code only if  * the TRACING flag is set.   */ M #define TraceIf(Code)	if (TRACING) {BEGIN_NONREENTRANT Code END_NONREENTRANT}  /*  * Get the next argument#  * from the command line interface.   */ L #define GETNEXTARG(argcount) if (++i >= argcount) { PrintHelp (); exit(1); } /*  * FD macros  */  #ifndef FD_SET #define	NFDBITS		32  #define	FD_SETSIZE	32 K #define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS))) L #define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))L #define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))7 #define FD_ZERO(p)	memset((char *)(p), 0, sizeof(*(p)))  #endif /*)  * Spectracom character conversion macros   */ + #define CVT_ASCII_TO_INT(chr) ((chr) - '0') 0 #define CVT_ASCII_TO_INT_AND_ADD(chrhi, chrlo) \; 	((CVT_ASCII_TO_INT(chrhi) << 6) + CVT_ASCII_TO_INT(chrlo))      /*  *	Conversion factors   */   ! #define K_NS_PER_SEC	(1000000000)  #define K_MS_PER_SEC	(1000) 1 #define K_NS_PER_MS	(K_NS_PER_SEC / K_MS_PER_SEC)  #define K_100NS_PER_MS  (10000)    /*  *	Literals   */    #define SPECTRACOM_PROMPT		"T"  B #define MAX_RESPONSE_LENGTH	(100)	/* Length of maximum response	*/C #define MIN_RESPONSE_LENGTH	(26)	/* Length of minimum valid resp.*/   ? #define K_SPECTRACOM_TIMEOUT	(5)	/* Allow 5 seconds for radio	*  					 * clock to respond		*/2 #define K_SPECTRACOM_RETRY	(2)	/* Retry twice			*/  C #define SPECTRACOM_BAUD		(B9600)	/* Baud rate of Spectracom term.*/    /*%  *  Maximum/Minimum parameters for TP   */ B #define K_MIN_INACCURACY     (10)	/* Allow for at least 10 ms of	* 					 * systematic inaccuracy	* ' 					 * in each radio clock response.*/ 0 #define K_MAX_INACCURACY     (10 * K_MS_PER_SEC)% 					/* Allow for at most 10 sec of	* # 					 * inacc in each radio clock	*  					 * response			*/ C #define K_MIN_POLLRATE	     (30)	/* Minimum time between synchs.	*/ I #define K_MAX_POLLRATE       (60 * 60)	/* Maximum time between synchs.	*/   C #define K_MAX_DEV_NAME	     (255)	/* largest device name string.	*/    /*   *	Default Control/Config Values  */ D #define K_DEF_INACCURACY     (30)          /* 30 ms inacc. in each	*" 					    * radio clock response	*/E #define K_DEF_TMORATE	     (1 * 60)	   /* Let service wait 1 minute	*  					    * for provider to		*  					    * succeed.			*/G #define K_DEF_POLLRATE       (2 * 60)	   /* Query the radio clock     * & 					    * every 2 minutes to get    * 					    * the time			*/= #define K_DEF_TIMESTAMPS     (4)	   /* Read the radio clock	* ! 					    * 4 times each synch.	*/ ; #define K_DEF_NOCLOCKSET     (0)	   /* Allow the clock to	*  					    * be set.			*/ = #define K_DEF_TRACING	     (0)	   /* Time Provider tracing	*/    /*  *     RPC definitions  */   K #define ABORT                (1)    /* abort the TP if error in RPC call */ E #define CONTINUE             (0)    /* continue after an RPC error */ L #define K_MAX_NUM_THREADS    (1)    /* Maximum number of threads we allow */   /*4  * This macro checks if an error occurred in an RPC <  * call. Print the message if this is the case. Exit the TPP3  * process if requested by the caller of the macro.   */   9 #define ProcessRPCerror(st, message, code)              \ 9    {                                                    \ 2 	if ((st) != rpc_s_ok)                           \2 	{                                               \ 	   int _locstat;				\+ 	   char _rpcmsg[dce_c_error_string_len];	\  							\2 	   dce_error_inq_text((st),                     \9                               (unsigned char *)_rpcmsg, \ 9                               &_locstat);               \  	   BEGIN_NONREENTRANT				\ = 	   (void)fprintf(stderr, "%s - %s\n", (message), _rpcmsg); \              END_NONREENTRANT				\9            if ((code) == ABORT)                         \m2 	       exit(1);                                 \2 	}                                               \    }   , /*  *	Forward Definitions  */u  
 int Delay ();i void PrintError ();  void PrintISO ();  void PrintTimes ();  void PrintHelp (); void InterActiveInput ();i void CommandLineInput ();i int ReadTimes ();o int QueryProvider(); int ParseTime ();a void InitializeTPdefaults( );    /*  * RPC global definitionsr  *  6  * Entry point vector for routines called from the DTS/  * deamon (RPC client) to the TPP (RPC server).s  */r  6 globaldef time_provider_v1_0_epv_t time_provider_epv = {e     ContactProvider,     ServerRequestProviderTime* };   /* n  * Global Variabless  */n
 #ifdef VMSI $DESCRIPTOR(TSTPLOG,  "DCE$DTS_TSTP_MBX");	/* tpts mailbox             */ I $DESCRIPTOR(TPTSLOG,  "DCE$DTS_TPTS_MBX");	/* tstp mailbox             */ J $DESCRIPTOR(TPDEVICE, "DCE$DTS_TP_DEVICE");	/* Device name parameter    */N $DESCRIPTOR(TPINACC,  "DCE$DTS_TP_INACCURACY");	/* Inaccuracy parameter     */M $DESCRIPTOR(TPRATE,   "DCE$DTS_TP_POLL_RATE");	/* Poll rate parameter      */AO $DESCRIPTOR(TPSTAMPS, "DCE$DTS_TP_TIME_STAMPS");	/* Time stamps parameter    */gP $DESCRIPTOR(MAXERROR, "DCE$DTS_TP_MAXERROR");     /* Max error allowed on TP  */P $DESCRIPTOR(FIRSTSYNC,"DCE$DTS_TP_FIRSTSYNC");    /* Always synch first time  */P $DESCRIPTOR(VERBOSE,  "DCE$DTS_TP_VERBOSE");      /* Print info out.          */  M $DESCRIPTOR(PROCESS_NAME, "DCE$DTS_PROVIDER");	/* Process name when OK     */iM /* $DESCRIPTOR(LNM_TABLE,"LNM$SYSTEM_TABLE") ;	/* Table to search          */hK $DESCRIPTOR(LNM_TABLE,"LNM$PROCESS_TABLE") ;	/* Table to search          */a  N unsigned long  FIRSTSYNCH;                      /* always synch first time  */N unsigned long  MAXTPERROR;                      /* Max error on TP.         */N unsigned long  ISVERBOSE;                       /* Print info.              */N unsigned long  SYNCHCOUNT;                      /* current synch. number    */  4 static int	ttchan;				/* channel number of term   */  E char devicename[K_MAX_DEV_NAME+1]= "\0";	     /* name of TP device	*/s   #endifK unsigned long  RETRIES;                       /* time stamps at each sync*/o  J unsigned long  TIMESTAMP = K_DEF_TIMESTAMPS; /* time stamps at each sync*/  L unsigned long  TMORATE   = K_DEF_TMORATE;    /* provider response timeout */  J unsigned long  POLLRATE  = K_DEF_POLLRATE;   /* seconds between TP syncs*/  J unsigned long  NOCLOCKSET= K_DEF_NOCLOCKSET; /* clock set               */  J unsigned long  TRACING   = K_DEF_TRACING;    /* output tracing          */  F unsigned long  INACCURACY= K_DEF_INACCURACY; /* provider inaccuracy	*/  3 unsigned long  INACC;			 /* inacc in nanoseconds	*/e    < struct tm INACC_TM;			 /* inaccuracy of each time reading */  4 int providerFD;				 /* provider file descriptor   */       /* */ vms_setup()e {      char value[255];     unsigned long status;oA     unsigned long attr = LNM$M_CASE_BLIND;	/* attributes mask */ h     short size;      struct { 	    short bufln ; 	    short itmcd ; 	    long *bufad ; 	    long *rtnln ; 	    long term;m:         } itmlst = { 255, LNM$_STRING, &value, &size, 0 };         /*,      * Set the process name to dtss$provider      */ 2     if (!(status = SYS$SETPRN( &PROCESS_NAME ))&1) 	exit(status);  A     status = SYS$TRNLNM(&attr, &LNM_TABLE, &TPRATE, 0, &itmlst );s     if ((status & 1))z     {  	value[size] = '\0';	 !         POLLRATE = atoi( value );4     } ;      C     status = SYS$TRNLNM(&attr, &LNM_TABLE, &TPSTAMPS, 0, &itmlst );e     if ((status & 1))t     {h 	value[size] = '\0';	 "         TIMESTAMP = atoi( value );C 	if (TIMESTAMP > K_MAX_TIMESTAMPS || TIMESTAMP < K_MIN_TIMESTAMPS )U 	{D 	    fprintf(stderr,"The time stamp value is out of legal range\n");0 	    fprintf(stderr,"Legal Range is %d to %d\n",) 		    K_MIN_TIMESTAMPS,K_MAX_TIMESTAMPS);u
 	    exit(1);* 	}     }      B     status = SYS$TRNLNM(&attr, &LNM_TABLE, &TPINACC, 0, &itmlst );     if ((status                                                                                                                                                                                                                                                                            J t $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                              .             & 1))      {  	value[size] = '\0';	s$         INACCURACY = atoi( value ) ;     } ;   A     status = SYS$TRNLNM(&attr, &LNM_TABLE, &TPRATE, 0, &itmlst );l     if ((status & 1))      {r 	value[size] = '\0';	t!         POLLRATE = atoi( value );y     } ;      C     status = SYS$TRNLNM(&attr, &LNM_TABLE, &MAXERROR, 0, &itmlst );      if ((status & 1))c     {o 	value[size] = '\0';	.#         MAXTPERROR = atoi( value );n     } ;      B     status = SYS$TRNLNM(&attr, &LNM_TABLE, &VERBOSE, 0, &itmlst );     if ((status & 1))e     {. 	value[size] = '\0';	 "         ISVERBOSE = atoi( value );         TRACING =  ISVERBOSE;      } ;<     D     status = SYS$TRNLNM(&attr, &LNM_TABLE, &FIRSTSYNC, 0, &itmlst );     if ((status & 1))h     {* 	value[size] = '\0';	m#         FIRSTSYNCH = atoi( value );r     } ;           value[0] = '\0';C     status = SYS$TRNLNM(&attr, &LNM_TABLE, &TPDEVICE, 0, &itmlst );      if ((status & 1))      {  	value[size] = '\0';	t     strcpy (devicename,value);     } ;       }s   s /*  *++
  *  main()  *  *  Functional Description:n  *  *	Main Loop for the TP.  *  *  Inputs:   *7  *	argc, argv - standard command line input parameters.T  *
  *  Outputs: t  *  *	None.  *    *  Value Returned:     *  *	None.  *  *--  */( main(argc, argv)	 int	argc;u
 char	*argv[];  {      #ifndef VMSe     struct sgttyb ttyb;  #endif  K     int             numThreads;         /* Max number of threads created *//K     uuid_t          TP_uuid;            /* UUID for this interface       */ J     unsigned32	    status;             /* status return values          */J     unsigned long	statusL;             /* status return values          */     int i, sts;tH     unsigned32    maxCalls;         /* Max # of concurrent calls this */H                                     /* server can receive.            */H     rpc_binding_vector_p_t bind_vector;  /* vector of binding handles */L                                          /* over which server can receive */L                         !                              /* remote procedure calls.       */*     unsigned_char_t *machinePrincipalName;         /* _#      *  read the startup parametersc      */_#     InitializeTPdefaults(&POLLRATE,_ 			 &TIMESTAMP,f 			 &INACCURACY,
 			 &TMORATE,  			 &NOCLOCKSET,
 			 &RETRIES,M 			 &FIRSTSYNCH, 			 &MAXTPERROR, 			 &ISVERBOSE);       /*+     ** get any logicals that might be there_     */     vms_setup();  +     if ((argc < 3) && !strlen(devicename) )o     {o 	PrintHelp ();         InterActiveInput();A     }o4     else if (argc > 1) CommandLineInput(argc, argv);       /*&      * Echo back the input parameters.      */ (     fprintf(stderr,"PARAMETERS SET:\n");2     fprintf(stderr,"TP_DEVICE:		%s\n",devicename);C     fprintf(stderr,"TP_INACCURACY:      %d seconds\n", INACCURACY);(A     fprintf(stderr,"TP_POLL_RATE:       %d seconds\n", POLLRATE);]E     fprintf(stderr,"TP_TIME_STAMPS:     %d timestamps\n", TIMESTAMP);iC     fprintf(stderr,"TP_MAXERROR:        %d seconds\n", MAXTPERROR); J     fprintf(stderr,"TP_FIRSTSYNC:       %s\n", FIRSTSYNCH?"TRUE":"FALSE");M     fprintf(stderr,"TP_VERBOSE:         %s\n\n\n", ISVERBOSE?"TRUE":"FALSE");h       /*1      * Convert the user specified inaccuracy intoS#      * a TM struct for use with APIP      */	>     INACC_TM.tm_year = INACC_TM.tm_mon = INACC_TM.tm_mday = 0;     INACC_TM.tm_hour = 0; 7     INACC_TM.tm_min = INACCURACY / (60 * K_MS_PER_SEC);"$     INACCURACY %= 60 * K_MS_PER_SEC;0     INACC_TM.tm_sec = INACCURACY / K_MS_PER_SEC;     INACCURACY %= K_MS_PER_SEC;i%     INACC = INACCURACY * K_NS_PER_MS;C       /*?      * Open the radio clock file descriptor for read and write./      */    #ifndef VMST #ifndef _AIX9     if ((providerFD = open(devicename, O_RDWR, 0)) < 0) {t- 	PrintError("dtsprovider: open radio clock");i	 	exit(1);e     }T        /*       * Set tty for exclusive use      */r     BEGIN_NONREENTRANT2     sts = ioctl(providerFD, TIOCEXCL, (char *) 0);     END_NONREENTRANT       if (sts < 0) {= 	PrintError("dtsprovider: setting radio clock to excl. use");	 	(void) close(providerFD);	 	exit(1);      }     #else	       /*A      * AIX does not support IOCTL with TIOCEXCL for a tty device.d:      * so we have to use the O_EXCL flag in the open call.      */*    B     if ((providerFD = open(devicename, O_EXCL | O_RDWR, 0)) < 0) {- 	PrintError("dtsprovider: open radio clock"); 	 	exit(1);_     }C    #endif     /*      * Set to cooked modeh      */   6     ttyb.sg_ispeed = ttyb.sg_ospeed = SPECTRACOM_BAUD;%     ttyb.sg_erase = ttyb.sg_kill = 0;	#     ttyb.sg_flags = EVENP|ODDP|RAW;	     BEGIN_NONREENTRANT7     sts = ioctl (providerFD, TIOCSETP, (char *) &ttyb);i     END_NONREENTRANT     if (sts < 0) {= 	PrintError("dtsprovider: setting terminal characteristics");S 	(void) close(providerFD);	 	exit(1);      }    #else  	/* * 	 * Initialize the time provider hardware. 	 */       if ( !(InitTP() & 1 ) )  	{1 	    PrintError("dtsprovider: init radio clock");T 		exit(status);i 	} #endif       /* CJ      * The rest of this code (in main) is relevant to RPC. Initialize the N      * server by registering the interface and the protocol sequence with the K      * RPC run-time library. Then, listen for calls coming from a client.  aD      * There is only one Time Provider RPC server per node and only .      * one client invokes it (the DTS daemon).      */t       /*@      * Create a null type UUID for registering the TPP interface      */s(     uuid_create_nil (&TP_uuid, &status);       /*?      * Register the TPP interface with the RPC run-time library=      */)8     rpc_server_register_if (time_provider_v1_0_s_ifspec, 			    &TP_uuid,* 			    (rpc_mgr_epv_t) &time_provider_epv, 			    &status);     /*;      * If not a successful interface registration, exit TPP       */      ProcessRPCerror (status,/ 		     "Unable to register interface for TPP",   		     ABORT);       /*G      * Tell the RPC run-time to listen for remote procedure calls usingsB      * all supported protocol sequences.  Since there is only one F      * client sending calls (The DTS time service), the maximum number.      * of concurrent calls should be only one.      */      maxCalls = 1; *     rpc_server_use_all_protseqs (maxCalls, 			         &status);      ProcessRPCerror (status, d5 		     "TPP unable to register protocol sequences ", ; 		     ABORT);       /* i=      * Get the vector of bindings over which this server can i&      * receive remote procedure calls.      */u  4     rpc_server_inq_bindings (&bind_vector, &status);>     ProcessRPCerror (status, "Can't inquire bindings", ABORT);       /*>      * If trace has been enabled, check the binding vector to ,      * confirm that the TPP server is there.      */        TraceIf(5 	    rpc_server_inq_bindings (&bind_vector, &status);d%             ProcessRPCerror (status, T) 			     "Can't inquire bindings", ABORT); * 	    for (i=0; i< bind_vector->count; i++) 	    {  		unsigned_char_p_t str_binding; 		; 		rpc_binding_to_string_binding (bind_vector->binding_h[i],  					       &str_binding,D 					       &status);I= 		ProcessRPCerror (status, "Can't bind to string", CONTINUE);O 		if (status == rpc_s_ok)a8 		   fprintf (stderr, "Got binding: %s\n", str_binding);* 		rpc_string_free (&str_binding, &status); 	    } 	    );        /*E      * Add address information for this Time Provider to the endpoint,F      * mapper database. The endpoint map is managed by the RPC daemon,C      * which creates and deletes elements on behalf of RPC servers.       */P  1     rpc_ep_register (time_provider_v1_0_s_ifspec,e 		     bind_vector,$ 		     NULL,5 		     (unsigned_char_p_t)"Spectracom Time Provider",  		     &status);K     ProcessRPCerror (status, "Can't register with endpoint mapper", ABORT);l       /*&      * Free up memory allocated by RPC      */ 4     rpc_binding_vector_free (&bind_vector, &status);       /*B      * Obtain the name of the machine's principal and register an G      * authentication service to use for authenticated remote procedure G      * calls coming from the t      -       ime service daemon.  HostName is NULL, soaC      * this routine implicitely gets the host name and returns the         * machine's principal name.      */i  M     dce_cf_prin_name_from_host ((char *)NULL, (char **)&machinePrincipalName,n*                                 &statusL);F     ProcessRPCerror (statusL, "Can't get machine's host name", ABORT);  8     rpc_server_register_auth_info (machinePrincipalName, 				  rpc_c_authn_dce_private, 				  NULL,n 				  NULL,n 				  &status);E  E     ProcessRPCer                                                                                                                                                                                                                                           q; $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                                    .       ror (status, "Can't register authentication", ABORT);I         /*<      * At this point we listen for incoming calls from a DTS=      * daemon client program (running as a server) that wantsn=      * to synchronize with the Time Provider.  RPC dispatchesN2      * the requests to the appropriate procedures.      */d  #     numThreads = K_MAX_NUM_THREADS;   
     TraceIf (/9 	     fprintf(stderr, "Listening for connections ...\n");  	     );  ,     rpc_server_listen (numThreads, &status);H     ProcessRPCerror (status, "RPC listen terminated abnormally", ABORT);   }o /* End of main program*/     /*  *++  *  ValidateTime()  *  *  Functional Description:   *D  *  This routine confirms that the time returned from the system, isB  *  within MAXTPERROR seconds of the time returned by the external  *  device.e  *  *  Inputs:   *2  *      systemTime  - time returned by the system.;  *      externalTime- time returned by the external device.;  *  *  Implicit Inputs: (  *%  *	SYNCHCOUNT - current synch number.S:  *      FIRSTSYNCH - allow first synch to always validate.;  *      MAXTPERROR - greatest difference between two times.E  *
  *  Outputs:    *  *	None.  *  *  Implicit Outputs:  M  * P
  *      None.A-  *                                              *  Value Returned:  a  *        *    Returns TRUE iff9  *      (abs(externalTime - systemTime) <= MAXTPERROR) ||S'  *      (FIRSTSYNCH && SYNCHCOUNT == 1)   *  *  Side Effects:   *  *	None.  *  *--  */,) int ValidateTime(systemTime,externalTime)  struct utc *systemTime;s struct utc *externalTime;( {l utc_t              result; struct timespec    inaccsp;A struct reltimespec timesp;       /* s:      * find the difference between the system time and the+      * time reported by the external clock.t      */T7     if (utc_subtime(&result,systemTime,externalTime) ||f0 	utc_abstime(&result,&result)                 ||* 	utc_binreltime(&timesp,&inaccsp,&result))	 	exit(0);        /*7      * if the difference is less than the max error, or .      * if first synch is enabled, return true.      */ 2     return( ((SYNCHCOUNT == 1) && (FIRSTSYNCH)) ||% 	    (timesp.tv_sec <= MAXTPERROR) );= }      N      &G /**********************************************************************l  *1  *	DTS TP/TS REMOTE PROCEDURE CALL (RPC) ROUTINESr  *H  **********************************************************************/   /*  *++  *  ContactProvider()   *  *  Functional Description:e  *G  *     This procedure is invoked by a remote client to initiate contact*G  *     with the Time Provider Program.  The task of this routine is to r>  *     send an initial control response message to the client.  *     u  *    *  Inputs: @  *       bind_handle         - pointer to the rpc_binding_handle3  *                             passed by the client B  *       TimeServiceRequest  - pointer to a structure with control,  *                             information.   *  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:E  *       TMOresponse   - pointer to time response message returned to H  *                       the client (the DTS server) which will identify3  *                       this TPP server as active.   *B  *       ComStatus     - This status is used by RPC to detect any E  *                       communication errors between the client and  E  *                       the server.  We return the value rpc_s_ok if ;  *                       the call was successfully invoked.   *  *  Implicit Outputs:e  *  *	None.  *  *  Value Return      5       ed:   *  *  *  Side Effects:e  *  *  *--  */   ; void ContactProvider( bind_handle, TMOresponse, ComStatus )_ handle_t        bind_handle; TPctlMsg       *TMOresponse; error_status_t *ComStatus; {        TraceIf(8 	    fprintf(stderr, "Executing ContactProvider ...\n"); 	    );	       /*B      * Prepare a time out response message to issue to the service7      * which will identify this process as active, and  D      * tell the service how long it must wait for the time response.      */n8     TMOresponse->status = (unsigned short)K_TPI_SUCCESS;%     TMOresponse->nextPoll = POLLRATE;*$     TMOresponse->timeout  = TMORATE;)     TMOresponse->noClockSet = NOCLOCKSET;"     *ComStatus = rpc_s_ok;   } /* End of ContactProvider */   ( /*  *++  *  ServerRequestProviderTime()I  *  *  Functional Description:"  *  *        *    *  Inputs:,:  *       bind_handle   - pointer to the rpc_binding_handle-  *                       passed by the clientP  *  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:F  *       TimeResponse   - This structure contains the time stamps and >  *                        version info returned to the client.  *C  *       ComStatus      - This status is used by RPC to detect any *F  *                        communication errors between the client and F  *                        the server.  We return the value rpc_s_ok if<  *                        the call was successfully invoked.  *        *  *  Implicit Outputs:t  *  *	None.  *  *  Value Returned:   *  *  *  Side Effects:i  *  *  *--  */UF void  ServerRequestProviderTime( bind_handle, timeResponse, ComStatus) handle_t       bind_handle;  TPtimeMsg      *timeResponse;A error_status_t *ComStatus; {d     int errStatus;       TraceIf(A 	   fprintf(stderr, "Executing ServerRequestProviderTime ...\n");  	    );        /*7      * Return the number of time stamps in the message.       */o  -     timeResponse->timeStampCount = TIMESTAMP;O          /*4      * Send the requests to the provider and get the      * results.c      */	?     errStatus = ReadTimes(TIMESTAMP, providerFD, timeResponse);        /*A      * Check to see if the times were read by the child properly. @      * Return success if the times are there, failure otherwise.      */f  E     timeResponse->status = errStatus ? K_TPI_FAILURE : K_TPI_SUCCESS;(         TraceIf(' 	    (void)printf("Reply written :\n");  	    PrintTimes(timeResponse); 	    );h       /*A      * return RPC status to the caller.  This status is used for b@      * signaling communication errors to the client, in case it F      * cannot bind to the server, or the server crashes while handlingD      * an RPC call.  Return rpc_s_ok, since Time Provider errors are.      * returned in the timeResponse structure.      */        *ComStatus = rpc_s_ok;  ( } /* End of ServerRequestProviderTime */ mD /*******************************************************************  *  *		User Interface Routineso  *E  *******************************************************************/i   /*  *++  *  CommandLineInput()  *  *  Functional Description:y  *6  *	Set the Time provider control parameters using the "  *	user's command line parameters.  *    *  Inputs:   *  *	argv - argv from main.*  *  *  Outputs:  *  *	None.  * s  *  Value Returned:l  *  *	None.  *  *--  */ ! void CommandLineInput(argc, argv) 
 int  argc;
 char *argv[];t { 
     int i;       for (i=1 ; i<argc ; i++)     {  	if (argv[i][0] != '-')i 	{ 	    PrintHelp ();
 	    exit(1);  	} P
         else h	         {n 	    /* $ 	     * Accept upper and lower case. 	     */! 	    switch (tolower(argv[i][1]))P 	    {
 		case 'o': {_ 		    GETNEXTARG(argc);,- 		    if (1 != sscanf(argv[i],"%d",&TRACING))c 		    {t 			(void) fprintf(stderr, / 				"-o:Output value is out of legal range\n");  			PrintHelp (); 			exit(1);f 		    }  		    break; 		}   
 		case 'c': {l 		    GETNEXTARG(argc);t0 		    if (1 != sscanf(argv[i],"%d",&NOCLOCKSET)) 		    {p 			(void) fprintf(stderr, 1 				"-c:Clockset value is out of legal range\n");D 			PrintHelp (); 			exit(1);u 		    }  		    break; 		}l  
 		case 'p': {  		    GETNEXTARG(argc);l0 		    if (1 != sscanf(argv[i],"%d",&POLLRATE) ||  			POLLRATE < K_MIN_POLLRATE ||  			POLLRATE > K_MAX_POLLRATE)  		    {b 			(void) fprintf(stderr, 1 				"-p:Pollrate value is out of legal range\n");t 			PrintHelp (); 			exit(1);h 		    }v 		    break; 		}c  
 		case 'i': {d 		    GETNEXTARG(argc); 4 		    if (1 != sscanf(argv[i], "%d", &INACCURACY) ||$ 			INACCURACY < K_MIN_INACCURACY || ! 			INACCURACY > K_MAX_INACCURACY)  		    {r 			(void) fprintf(stderr, 3 				"-i:Inaccuracy value is out of legal range\n");e 			PrintHelp();  			exit(1);  		    }  		    break; 		}_  
 		case 't': {e 		    GETNEXTARG(argc); 3 		    if (1 != sscanf(argv[i], "%d", &TIMESTAMP) ||e# 			TIMESTAMP < K_MIN_TIMESTAMPS || i  			TIMESTAMP > K_MAX_TIMESTAMPS) 		    {n 			(void) fprintf(stderr,	3 				"-t:Time stamp count is out of legal range\n");n 			PrintHelp();  		                                                                                                                                                                                                                                                           UI $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                              e)      ?       	exit(1);i 		    }	 		    break; 		}   
 		case 'd': {  		    GETNEXTARG(argc);t( 		    (void)strcpy(devicename, argv[i]);7             strcpy (TPDEVICE.dsc$a_pointer,devicename);i7             TPDEVICE.dsc$w_length = strlen(devicename);  		    break; 		}    		default: { 		    PrintHelp(); 		    exit(1); 		}t 	    }	/* switch */m
 	}	/* else */      }		/* for */ }a e /*  *++  *  InteractiveInput()  *  *  Functional Description:b  *6  *	Set the Time provider control parameters using the    *	user's interactive responses.  *    *  Inputs:   *  *	None.  *  *  Outputs:  *  *	None.  * e  *  Value Returned:&  *  *	None.  *  *--  */  void InterActiveInput()w {      char inputLine[512];     3     (void) printf("\n\n\nEnter the Device Name: "); (     (void) fgets(inputLine, 512, stdin);2     (void) sscanf(inputLine, "%255s", devicename);          /*      * Get the POLLRATE       */tD     (void) printf("Enter the Poll Rate in Seconds[%d]: ", POLLRATE);(     (void) fgets(inputLine, 512, stdin);/     (void) sscanf(inputLine, "%d", &POLLRATE); l?     if (POLLRATE < K_MIN_POLLRATE || POLLRATE > K_MAX_POLLRATE)i     {nE 	(void) fprintf(stderr, "-p:Pollrate value is out of legal range\n");*	 	exit(1);i     }a       /*      * Get the Inaccuracy       */;@     (void) printf("Enter the Inaccuracy[%d(ms)]: ", INACCURACY);(     (void) fgets(inputLine, 512, stdin);0     (void) sscanf(inputLine, "%d", &INACCURACY);G     if (INACCURACY < K_MIN_INACCURACY || INACCURACY > K_MAX_INACCURACY)o     {uG 	(void) fprintf(stderr, "-i:Inaccuracy value is out of legal range\n");p	 	exit(1);t     }i       /*      * Get the timestamp count      */r@     (void) printf("Enter the Timestamp Count[%d]: ", TIMESTAMP);(     (void) fgets(inputLine, 512, stdin);.     (void) sscanf(inputLine, "%d",&TIMESTAMP);E     if (TIMESTAMP < K_MIN_TIMESTAMPS || TIMESTAMP > K_MAX_TIMESTAMPS)      {(G 	(void) fprintf(stderr, "-t:Time stamp count is out of legal range\n");l	 	exit(1);h     }&       /*&      * Get the disallow clock set flag      */eD     (void) printf("Disallow clock set[%d(Y:1,N:0)] : ", NOCLOCKSET);(     (void) fgets(inputLine, 512, stdin);/     (void) sscanf(inputLine, "%d",&NOCLOCKSET);t       /*       * Get the Output Trace flag      */P<     (void) printf("Output Trace [%d(Y:1,N:0)] : ", TRACING);(     (void) fgets(inputLine, 512, stdin);,     (void) sscanf(inputLine, "%d",&TRACING);   }l e /*  *++  *  Delay()e  *  *  Functional Description:t  *$  *	Print out error text to the user.  *    *  Inputs:   *  *	None.  *  *  Outputs:  *  *	None.  * .  *  Value Returned:-  *  *	None.  *  *--  */t int Delay (secs) unsigned secs; {* #if _DECTHREADS_     timespec_t interval;       interval.tv_sec = secs;      interval.tv_nsec = 0; )     if (pthread_delay_np (&interval) < 0)      { ) 	PrintError("dtsprovider: cannot delay");m 	return (1);     }| #else      unsigned sleep();H       sleep(secs); #endif       return (0);n   } /* End of routine Delay */ e /*  *++  *  PrintError()  *  *  Functional Description:u  *$  *	Print out error text to the user.  *    *  Inputs:m  *  *	None.  *  *  Outputs:  *  *	None.  *    *  Value Returned:h  *  *	None.  *  *--  */e void PrintError (errorString)o char *errorString; {o     BEGIN_NONREENTRANT       perror (errorString);e       END_NONREENTRANT }s /* End of routine PrintError */    /*  *++  *  PrintHelp(),  *  *  Functional Description:   *#  *	Print out help text to the user.t  *    *  Inputs:o  *  *	None.  *  *  Outputs:  *  *	None.  *    *  Value Returned:   *  *	None.  *  *--  */Y void PrintHelp() {p     (void) fprintf(stderr,- 		   "usage:\tdtsprovider -d device-name\n");*     (void) fprintf(stderr,6 		   "\t\t[-p pollrate, range %d : %d, default %d]\n",3 		   K_MIN_POLLRATE,K_MAX_POLLRATE,K_DEF_POLLRATE);*     (void) fprintf(stderr,H      "\t\t[-i milliseconds of inaccuracy, range %d : %d, default %d]\n",; 		   K_MIN_INACCURACY, K_MAX_INACCURACY, K_DEF_INACCURACY);i     (void) fprintf(stderr,8 		   "\t\t[-t timestamps, range %d : %d, default %d]\n",9 		   K_MIN_TIMESTAMPS,K_MAX_TIMESTAMPS,K_DEF_TIMESTAMPS);g     (void) fprintf(stderr,K      "\t\t[-c disallow clock set, range 0(false) : 1(true), default %d]\n",_ 		   K_DEF_NOCLOCKSET);      (void) fprintf(stderr,E      "\t\t[-o output trace, range 0(false) : 1(true), default %d]\n",r 		   K_DEF_TRACING); }  /* End of routine PrintHelp */  B /*****************************************************************  *  *	Device Dependent code	- e#  *			Spectracom radio clock control   *C  *****************************************************************/  /*  *++  *  ReadTimes()c  *  *  Functional Description:   *4  *	Parse out time stamps from the radio clock input.  *    *  Inputs:i  *0  *	timeStamps - the number of timestamps to read#  *	fd - radio clock file descriptor   *  *  Outputs:  *3  *	tpTimeMsg - buffer to return the timestamp data.k  *    *  Value Returned:u  *  *	0 - Success  *	-1 - Failureu  *  *--  */ * int ReadTimes( timeStamps, fd, tpTimeMsg ) unsigned long timeStamps;n int fd;e TPtimeMsg  *tpTimeMsg; {e5     int i;                          /* temp, index */r     int retry;     int status;        retry = K_SPECTRACOM_RETRY;x       /*"      * Now Read The Time Stamps.  K      * Note that this loop will terminate having read timeStamps timestamps =      * or exhausting retry retries. and thus is non-infinite.t      */e  
     i = 0;     while ( i < timeStamps ) {C 	status = QueryProvider( fd, &tpTimeMsg->timeStampList[i].TPtime,  S- 				&tpTimeMsg->timeStampList[i].beforeTime,  - 				&tpTimeMsg->timeStampList[i].afterTime );s   	if (status & 1) {A 	   status = ValidateTime(&tpTimeMsg->timeStampList[i].afterTime,/1 			         &tpTimeMsg->timeStampList[i].TPtime);  	   if (!(status & 1))D 	       PrintValidationError(&tpTimeMsg->timeStampList[i].afterTime,6   			            &tpTimeMsg->timeStampList[i].TPtime);     }e   	if (status & 1) { 	    i += 1;	 	} else {  	    if (retry-- == 0) 		return(0); 	}       }s       return(0); }c a /*  *++  *  InitTP()  *  *  Functional Description:o  *  *G  *  This is the first routine called by the DECdts time provider, it is D  *  called at the beginning of each synchronization.  This allows us%  *  do any necessary initializations.   *  *    *  Inputs:   *  *	None.  *  *  Implicit Inputs:  *  *	The TP year info is valid.c:  *	Note that the TP does not read any year info.  The year;  *	info is manually dialed into the hardware by setting thes9  *	appropriate DIP switches.  If the DIP switches are notnA  *	set correctly, the year and date info of the TP may be faulty.P+  *	The DIP switches must be set each year. *  *;  *	On the PSTI, it is also possible to issue an SY command t2  *	to initialize the year info at machine startup.  *  *  Outputs:  *  *  *  Implicit Outputs:   *  *        *  Value Returned:*  *:  *	The Value returned by this routine directly impacts the8  *	result of a synchronization.  If this routi      M       ne returns8  *	failure, then the DECdts Time Provider will abort the  *	synchronization.  R  *  *	1 if success, 0 otherwise.t  *  *  *  Side Effects:d  *  *	None.  *--  */  InitTP() {      unsigned long status;e   #ifndef TP_NULLs     /*D      * Assign a channel to the terminal port device connected to the      * TP device.r      */ E     status = SYS$ASSIGN(&TPDEVICE,    	 	/* device name descriptor */ & 			&providerFD, 		/* channel number */  			0,	       		/* access mode */ 			0);			/* mailbox */ #elsec     /*E      * The NULL TP example does not perform any I/O with the externalr      * time source.e      */a     status = 1;  #endif       return( status );    }P /* End of routine initTP */t e /*  *++  *  ExitTP()  *  *  Functional Description:t  *I  *  This is the last user routine called by the DECdts time provider.  It*I  *  allows us to detach the TP's IPC channel to the Time service process.eH  *  It also allows this process to detach from the Time Provider device.  *  *  *    *  Inputs:*  *8  *	providerFD (ttchan)	- channel to time provider device  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *  *	None.  *  *  Implicit Outputs:   *  *	None.  *  *  Value Returned:*  *  *	status	- Status of deassign.s  *  *  Side Effects:   *  *	None.  *--  */* ExitTP( ttchan ) unsigned short ttchan; {a     unsigned long status;   "     status = SYS$DASSGN( ttchan );       return( status );0 }= /* End of routine ExitTP */;    
 /*  #endif /* */                                                                                                                                                                                                                                                            s $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                               "     P          #ifndef VMS    /*  *++  *  QueryProvider()t  *  *  Functional Description:   *H  *      Query the provider for the time. Generate the timestamp triplet.  *    *  Inputs:   *   *	fd - file descriptor to read.  *  *  Outputs:  *>  *	providerTime - return utc time, the time read from provider7  *	beforeTime - the utc just before the command is sent	=  *	afterTime - the utc just after the on time marker arrived.s  * (  *  Value Returned:S  *-  *	-1	Unequivocal failure - Radio clock fault:  *	0	Success'  *	1	Timeout failure - retry warranted.p  *  *--  */) int O QueryProvider(int fd, utc_t *providerTime, utc_t *beforeTime, utc_t *afterTime)( {=B     struct timeval timeout;		/* time out value for select       */A     char dataLine[MAX_RESPONSE_LENGTH];	/* Response buffer		   */r;     fd_set readfds;			/* mask of file descriptors        */i3     int	n;				/* file descriptor selected on     */cP     int nfds = fd+1;                    /* number of file descripts to select */     int ioctl_arg;     int status;I       /*$      * Flush input and output queues      */      ioctl_arg = 0;   #ifndef VMS	     BEGIN_NONREENTRANT6     status = ioctl(fd, TIOCFLUSH, (char *)&ioctl_arg);     END_NONREENTRANT     if (status < 0) {': 	PrintError("dtsprovider: can't flush radio clock input");
 	exit (1);     }) #endif       /*      * Prepare for select	      */P     FD_ZERO(&readfds);     FD_SET(fd, &readfds);t*     timeout.tv_sec = K_SPECTRACOM_TIMEOUT;     timeout.tv_usec = 0;       /*       * Record 'before' timestamp      */ #     (void) utc_gettime(beforeTime);g       /*+      * Write 'Query' command to radio clock       */yF     if (write(fd, SPECTRACOM_PROMPT, (sizeof(SPECTRACOM_PROMPT)-1)) !=! 	(sizeof(SPECTRACOM_PROMPT)-1)) {a> 	PrintError("dtsprovider: can't send command to radio clock");	 	exit(1);/     }h       /*9      * Wait for the reply by watching the file descriptort      */)=     if ((n = select(nfds, &readfds, (fd_set *)0, (fd_set *)0,r%                     &timeout)) < 0) {'/ 	PrintError("dtsprovider: radio clock select"); 	 	exit(1);*     }u       /*      * Record 'after' timestampn      */ "     (void) utc_gettime(afterTime);       /*"      * Check for timeout in select      */      if (n == 0) {\ 	BEGIN_NONREENTRANTe7 	(void) fprintf(stderr, "dtsprovider:\t* Timeout *\n");i 	END_NONREENTRANT, 	return(1);i     };       /*?      * Wait so that all the characters are in and read the liner      */ 
     Delay(2);[0     n = read(fd, dataLine, MAX_RESPONSE_LENGTH);"     if (n < MIN_RESPONSE_LENGTH) {
 	if (n < 0) {LA             PrintError("dtsprovider: error reading radio clock");L	 	} else {  	    BEGIN_NONREENTRANTr 	    (void) fprintf(stderr,fN                       "dtsprovider: radio clock returned only %d bytes\n", n); 	    END_NONREENTRANTt 	    dataLine[n] = '\0';> 	    (void) fprintf(stderr, "time returned - %s\n", dataLine);	         }) 	return(1);L	     }    &     dataLine[n] = '\0';C       /*C      * Now parse the radio clock data to determine the actual time.p      */e.     return(ParseTime(providerTime, dataLine)); }p #endif   #ifdef TP_PSTI /*;  **********************************************************(  *		PSTI Specific Routines. ;  **********************************************************   */i   /*  * PSTI specific constants  */ B #define M_PSTI_AVAIL		0x08	/* bit to test for time availability */; #define M_PSTI_OUT_OF_SPEC	0x40	/* out of spec time mask */u8 #define M_PSTI_HARD_FAULT	0x20	/* PSTI hardware fault */B #define M_PSTI_SIGNAL_FAULT	0x10	/* PSTI signal fault time mask */  H #define PSTI_PROMPT             "QA0000"/* prompt string for OEM time */@ #define PSTI_RESPONSE_LENGTH     (13)	/* bytes returned by QA */M #define PSTI_NOCLOCKSET          (0)     /* allow the clock to be affected */rM #define PSTI_POLL_RATE           (60)    /* sixty seconds between tp polls */ M #define PSTI_TIME_STAMPS         (3)     /* number of time samples to read */ K #define PSTI_INACCURACY          (30)    /* 30ms of inaccuracy default   */ L #define PSTI_TMORATE             (30)	 /* 30 secs to respond to TS request*/  K #define PSTI_QIO_TIMEOUT         (3)	 /* seconds till read QIO times out */iP #define PSTI_RETRIES             (5)     /* allow 5 retries after a TP failure*/6 #define PSTI_ISVERBOSE		 (1)     /* generate output */L #define PSTI_MAXTPERROR          (60)    /* ignore deltas greater than 60 */L #define PSTI_FIRSTSYNCH          (1)     /* synch up the first time thru  */   /*  B  * There are only 6 bits of valid data in any PSTI data byte.  Bit9  * 7 and 0 are used for parity checks and other purposes.t8  * Mask07 strips bit 7 and bit 0 from a PSTI data byte, +  * then it normalizes the data into a byte.   */ 6 #define Mask07( dataByte )  (( dataByte & 0x7F) >> 1 )   /*J  * Mask07AndAdd  strips non data bits from two bytes and then concatenatesI  * them into a single value.  Used for data that does not fit in a single   * byte of information.c  */l2 #define Mask07AndAdd(dataByteHi, dataByteLo)     \5 		( Mask07(dataByteLo) + ( Mask07(dataByteHi) << 6 )):     /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:d  *A  *  Initialize the default input parameters for the external time 
  *  provider.n  *  *  *    *  Inputs:d  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll rateL7  *    timestamp- int to be set to the default number ofsD  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).n@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should notpE  *               be affected by the results of the TP synch, false ifGC  *               the clock can be modified by the results of the TP*  *               synch.*E  *    retries -  int to be set to the number of times the program is  7  *               allowed to resend a request after the *=  *               external time source has returned a failure. G  *    firstsync- boolean, assume that the time returned by the external >  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, the 2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messages #  *               will be displayed.   *  *    *  Implicit Outputs:r  *    none.r  *        *  Value Returned:r  *    none.C  *  *  Side Effects:   *    none.   *  *--  */.- void InitializeTPdefaults(pollrate,timestamp,a 			  inaccuracy,tmorate, 			  clockSet,retries, 			  firstsynch,maxtperror,i 			  isverbose)  int *pollrate,     *timestamp,      *inaccuracy,
     *tmorate,u     *clockSet,
     *retries,m     *firstsynch,     *maxtperror,     *isverbose;s {]8     *pollrate  = PSTI_POLL_RATE;    /* seconds        */8     *timestamp = PSTI_TIME_STAMPS;  /* int, 1-6       */8     *inaccuracy= PSTI_INACCURACY;   /* milliseconds   */8     *tmorate   = PSTI_TMORATE;      /* seconds        */8     *clockSet  = PSTI_NOCLOCKSET;   /* int, t/f - 1/0 */8     *retries   = PSTI_RETRIES;      /* int > 0        */8     *firstsynch= PSTI_FIRSTSYNCH;   /* int > 0        */8     *maxtperror= PSTI_MAXTPERROR;   /* seconds        */:     *isverbose = PSTI_ISVERBOSE;      /* int > 0        */ }i) /* End of routine InitializeTPdefaults */      o /*  *++  *  QueryProvider()   *  *  Functional Description:h  *B  *  This routine issues a single QA300 command to the PSTI device.?  *  It returns the Binary Absolute Time represented by the PSTI*  *  data returned.  *  *    *  Inputs:   *2  *	ttchan - The active channel to the PSTI device.  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *1  *	TPtime - The Time returned by the PSTI device.e  * s  *  Implicit Outputs:t  *  *        *  Value Returned:o  *(  *	0 - Failure - The PSTI device failed.4  *      1 - Success - The PSTI device was contacted.  *  *  Side Effects:   *  *  *--  */  int D QueryProvider(int ttchan, struct utc *TPtime,struct utc *beforeTime,C                                              struct utc *afterTime)l {r     /*=      * Passing Binary encoded data. See PSTI dip switches fora@      * baud.  Set                                                                                                                                                                                                                                                                            0"] $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                              \Z "     a       terminal characteristics for Eightbit,pasall,       * pasthru.t      */s(     char TPdata[PSTI_RESPONSE_LENGTH+1];     int  status;     int  retSize;	.     IOsb  TPIOSB;		/* status block for PSTI */     struct {long null;) 	    long mask;} term_mask = {0, 0x0000};    			        /*r0    				 * now a structure to set the terminator  				 * character for the read.
    				 */  %     (void) utc_gettime( beforeTime );        /*C      * post qiow read to the psti with a timeout.  This also purges02      * the input buffer of any residue characters.      */e+     status = SYS$QIOW(0,			/* event flag */ & 		      ttchan,			/* channel number */- 		      IO$_READPROMPT |		/* function code */P 			IO$M_TIMED |n 			IO$M_NOECHO | 			IO$M_PURGE,( 		      &TPIOSB,			/* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */3 		      TPdata,	       		/* buffer for user data */c; 		      PSTI_RESPONSE_LENGTH,	/* buffer size of response */ ; 		      PSTI_QIO_TIMEOUT,	        /* P3; secs to timeout */ : 		      &term_mask,		/* P4: mask specifying terminators */. 		      PSTI_PROMPT, 		/* P5; prompt string */9 		      strlen(PSTI_PROMPT)); 	/* P6; length of prompt */O    $     (void) utc_gettime( afterTime );       if ( !(status & 1) )     {eC 	(void) fprintf(stderr, "M_PSTI: QIO Status failure %x\n", status);t         return ( status );     }      if ( !(TPIOSB.status & 1) )      {=B         (void) fprintf(stderr, "M_PSTI: IOSB Status failure %x\n", 		       TPIOSB.status);!         return ( TPIOSB.status );*     }        /*5      * check that we got the correct number of bytes. #      * Otherwise return hard error.n      */ 2     if (TPIOSB.byteCount != PSTI_RESPONSE_LENGTH)      {s? 	(void) fprintf(stderr, "M_PSTI: response length failure %x\n",u 		       TPIOSB.byteCount);r 	return(0);f     }      /*F      * Check all the status bits, make sure this time is truely valid.      * Additional stamps?       */ '     if ( !(TPdata[0] & M_PSTI_AVAIL) ) a     { : 	(void) fprintf(stderr, "M_PSTI: time not Available %x\n", 		       TPdata[0]); 	return(0);      }P)     if ( TPdata[0] & M_PSTI_OUT_OF_SPEC )*     {i< 	(void) fprintf(stderr, "M_PSTI: out of spec detected %x\n", 		       TPdata[0]); 	return(0);      }d*     if ( TPdata[0] & M_PSTI_SIGNAL_FAULT )     { < 	(void) fprintf(stderr, "M_PSTI: out of spec detected %x\n", 		       TPdata[0]); 	return(0);t     }c(     if ( TPdata[0] & M_PSTI_HARD_FAULT )     { ; 	(void) fprintf(stderr, "M_PSTI: hard fault detected %x\n",_ 		       TPdata[0]); 	return(0);      }u    p     /*=      * Convert the data returned by the PSTI into struct utc.       */R)     return(CvtTPtoUTC( TPdata, TPtime ));    }    c /*  *++  *  CvtTPtoUTC()  *  *  Functional Description:t  *C  * This routine converts the response string of the PSTI QA command %  * into a Binary Absolute Time value.l  *  *  *    *  Inputs:(  *&  *	respString - The QA command string.  *  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *$  *	TPtime - The converted utc value.  *  *  Implicit Outputs:u  * t  *	None.  *        *  Value Returned:e  * r  *	None.  *  *  Side Effects:*  *    *	None.  *  *--  */M CvtTPtoUTC( TPdata, TPtime )
 char *TPdata;( struct utc *TPtime;M   {)    long		tns, ins;    struct tm	time, inacc;a       /*  '      * convert bytes 2 and 3 into msec.       */ =     tns = (Mask07AndAdd(TPdata[2], TPdata[3])) * K_NS_PER_MS;f       /* c0      * convert bytes 4,5,6 into sec, mins, hours      */ $     time.tm_sec = Mask07(TPdata[4]);$     time.tm_min = Mask07(TPdata[5]);%     time.tm_hour = Mask07(TPdata[6]);c       /*-      * convert bytes 7 and 8 into day of yeara      */;5     time.tm_yday = Mask07AndAdd(TPdata[7],TPdata[8]);         /* =:      * convert byte 9 (offset from 1986) into current year      */*3     time.tm_year = 1986 + Mask07(TPdata[9]) - 1900;        /*  &      * get it yearday into mon and day      */ G     MonthDay (time.tm_year, time.tm_yday, &time.tm_mon, &time.tm_mday);M     time.tm_isdst = 0;       /*      * Get the inaccuracy       */L  -     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;i"     inacc.tm_min = 0;                  inacc.tm_hour = 0;     inacc.tm_yday = 0;     inacc.tm_isdst = 0; 4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;  6     if (utc_mkgmtime(TPtime, &time, tns, &inacc, ins)) 	return(0);t     else 	return(1);d   }\ /* End of routine CvtTPtoUTC */r   L /*  *++  *  MonthDay()  *  *  Functional Description:w  *B  *  This routine Converts the current year, and the current day of2  *  the year (ie 174th day of 1989) to a month andC  *  day in month format ( 12 - 31 - 1989 ).  This serves to convert*;  *  the PSTI date into something we can more easily handle.*  *  *    *  Inputs:*  * *-  *	currYear - The current year as an integer.c)  *	yearDay - The current day in the year.8  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *-  *	currMonth - The numerical month ( 1 - 12 )n1  *	dayInMonth   - The day in the month ( 1 - 31 )   * n  *  Implicit Outputs:x  *	   *	None.  *  *  Value Returned:d  *  *	None.  *  *  Side Effects:"  *  *	None.  *  *--  */ 2 MonthDay(currYear, yearDay, currMonth, dayInMonth)* int	currYear;				/* current year - 1900 */! int	yearDay;				/* day of year */o% int	*currMonth;				/* ptr to month */E- int	*dayInMonth;				/* ptr to day of month */p {s   int dayTab [2] [13] = {M5 	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, 6 	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};; 			/* table for get_month and day from day of year input */	     int	i, leap;    1 	leap = (currYear%4 == 0 && currYear%100 != 0) || '                (currYear+300)%400 == 0;*+ 	for (i=1; yearDay > dayTab[leap] [i]; i++)/! 	    yearDay -= dayTab[leap] [i];e   	*currMonth = i-1; 	*dayInMonth = yearDay;e }t #endif f #ifdef TP_GC1000 /*;  **********************************************************S  *		GC1000 Specific Routines. ;  **********************************************************   */s  H #define GC1000_PROMPT          " "	/* Prompt string for clock trigger */K #define GC1000_RESPONSE_LENGTH (24)	/* Number of bytes returned by clock */ L #define GC1000_NOCLOCKSET      (0)      /* allow the clock to be affected */L #define GC1000_POLL_RATE       (60)     /* sixty seconds between tp polls */L #define GC1000_TIME_STAMPS     (3)      /* number of time samples to read */J #define GC1000_INACCURACY      (30)     /* 30ms of inaccuracy default   */J #define GC1000_TMORATE         (30)	/* 30 secs to respond to TS request */H #define GC1000_QIO_TIMEOUT     (3)	/* seconds till read QIO times out */P #define GC1000_RETRIES         (5)      /* allow 5 retries after a TP failure */< #define GC1000_ISVERBOSE       (1)     /* generate output */J #define GC1000_MAXTPERROR      (60)    /* ignore deltas greater than 60 */J #define GC1000_FIRSTSYNCH      (1)     /* synch up the first time thru  */   /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:e  *A  *  Initialize the default input parameters for the external timer
  *  provider.   *  *  *    *  Inputs:e  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll rate 7  *    timestamp- int to be set to the default number of D  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).o@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should notaE  *               be affected by the results of the TP synch, false ifrC  *               the clock can be modified by the results of the TPr  *               synch. E  *    retries -  int to be set to the number of times the program is  7  *               allowed to resend a request after the  =  *               external time source has returned a failure. G  *    firstsync- boolean, assume that the time returned by the externaln>  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, theo2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messagesp#  *               will be displayed.c  *  *  * t  *  Implic                                                                                                                                                                                                                                                                           C $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                              m "     r       it Outputs:,  *    none.s  *        *  Value Returned:p  *    none.i  *  *  Side Effects:l  *    none._  *  *--  */*- void InitializeTPdefaults(pollrate,timestamp,S 			  inaccuracy,tmorate, 			  clockSet,retries, 			  firstsynch, maxtperror, 			  isverbose)a int *pollrate,     *timestamp,n     *inaccuracy,
     *tmorate,T     *clockSet,
     *retries,/     *firstsynch,     *maxtperror,     *isverbose;    { :     *pollrate  = GC1000_POLL_RATE;    /* seconds        */:     *timestamp = GC1000_TIME_STAMPS;  /* int, 1-6       */:     *inaccuracy= GC1000_INACCURACY;   /* seconds        */:     *tmorate   = GC1000_TMORATE;      /* seconds        */:     *clockSet  = GC1000_NOCLOCKSET;   /* int, t/f - 1/0 */:     *retries   = GC1000_RETRIES;      /* int > 0        */:     *firstsynch= GC1000_FIRSTSYNCH;   /* int > 0        */:     *maxtperror= GC1000_MAXTPERROR;   /* seconds        */<     *isverbose = GC1000_ISVERBOSE;      /* int > 0        */   } ) /* End of routine InitializeTPdefaults */p     /*  *++  *  QueryProvider()e  *  *  Functional Description:   *F  *  This routine issues a single trigger command to the GC1000 device.A  *  It returns the Binary Absolute Time represented by the GC1000   *  data returned.  *  *    *  Inputs:   *4  *	ttchan - The active channel to the GC1000 device.  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *3  *	TPtime - The Time returned by the GC1000 device.   * s  *  Implicit Outputs:a  *  *        *  Value Returned:*  **  *	0 - Failure - The GC1000 device failed.6  *      1 - Success - The GC1000 device was contacted.  *  *  Side Effects:;  *  *  *--  */    int D QueryProvider(int ttchan, struct utc *TPtime,struct utc *beforeTime,C                                              struct utc *afterTime)  {r*     char TPdata[GC1000_RESPONSE_LENGTH+1];     int  status;0     IOsb  TPIOSB;		/* status block for GC1000 */  %     (void) utc_gettime( beforeTime );*          /*D      * post qiow read to the clock with a timeout.  This also purges2      * the input buffer of any residue characters.      */O+     status = SYS$QIOW(0,			/* event flag */*& 		      ttchan,			/* channel number */- 		      IO$_READPROMPT |		/* function code */	 			IO$M_TIMED |	 			IO$M_NOECHO | 			IO$M_PURGE,( 		      &TPIOSB,			/* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */3 		      TPdata,	       		/* buffer for user data */S= 		      GC1000_RESPONSE_LENGTH,	/* buffer size of response */O5 		      GC1000_QIO_TIMEOUT,	/* P3; secs to timeout */a& 		      0,			/* P4: terminator mask */0 		      GC1000_PROMPT, 		/* P5; prompt string */; 		      strlen(GC1000_PROMPT)); 	/* P6; length of prompt */     $     (void) utc_gettime( afterTime );       if ( !(status & 1) )     { E 	(void) fprintf(stderr, "M_GC1000: QIO Status failure %x\n", status);          return ( status );     }      if ( !(TPIOSB.status & 1) )      { D         (void) fprintf(stderr, "M_GC1000: IOSB Status failure %x\n", 		       TPIOSB.status);!         return ( TPIOSB.status );      }        /*5      * check that we got the correct number of bytes. #      * Otherwise return hard error. "      * (Subtract one for the <CR>)      */S6     if (TPIOSB.byteCount != GC1000_RESPONSE_LENGTH-1)      {eA 	(void) fprintf(stderr, "M_GC1000: response length failure %x\n",  		       TPIOSB.byteCount);l 	return(0);i     }e     /*=      * Check the return buffer to make sure it's a valid time       *	buf[0:1]	HoursM      *  buf[2]		':'       *  buf[3:4]        MinutesT      *  buf[5]		':'       *  buf[6:7]        Secondst      *  buf[8]		'.'       *  buf[9]		Tenths      *  buf[10:14]	blankso      *  buf[15:16]      Montht      *  buf[17]		'/'      *  buf[18:19]	Day      *  buf[20]		'/'      *  buf[21:22]	YearP      *  buf[23]         <CR>      */i     if ( TPdata[0] == '?' )      {cC /*	(void) fprintf(stderr, "M_GC1000: clock not synchronized\n"); */t 	return(0);_     }U       /*9      * If tenths of seconds are '?', then we are drifting\      */      if ( TPdata[9] == '?' )      {u #ifdef DEBUG 	TPdata[9] = '0';e #elsee> /*	(void) fprintf(stderr, "M_GC1000: time not accurate\n"); */ 	return(0);, #endif     }        /*,      * Check delimiters for proper positions      */i!     if ( ( TPdata[2] != ':' ) || t!          ( TPdata[5] != ':' ) || o!          ( TPdata[8] != '.' ) || i"          ( TPdata[17] != '/' ) ||            ( TPdata[20] != '/' ) )     {rG 	(void) fprintf(stderr, "M_GC1000: time/date string format invalid\n");* 	return(0);      }e       /*)      * Check fields for proper charactersn      */ $     if ( !( isdigit(TPdata[0]) ) ||  	 !( isdigit(TPdata[1]) ) ||   	 !( isdigit(TPdata[3]) ) || T 	 !( isdigit(TPdata[4]) ) || * 	 !( isdigit(TPdata[6]) ) ||   	 !( isdigit(TPdata[7]) ) || r 	 !( isdigit(TPdata[9]) ) ||   	 !( isdigit(TPdata[15]) ) ||  	 !( isdigit(TPdata[16]) ) ||  	 !( isdigit(TPdata[18]) ) ||  	 !( isdigit(TPdata[19]) ) ||  	 !( isdigit(TPdata[21]) ) ||  	 !( isdigit(TPdata[22]) ) )     {eF 	(void) fprintf(stderr, "M_GC1000: time/date field format invalid\n"); 	return(0);=     }(    a     /*?      * Convert the data returned by the GC1000 into struct utc.;      */e)     return(CvtTPtoUTC( TPdata, TPtime ));)   }      /*  *++  *  CvtTPtoUTC()  *  *  Functional Description:e  *:  * This routine converts the response string of the GC1000%  * into a Binary Absolute Time value.n  *    *  Inputs:   *-  *	The GC1000 date/time string in the format:m4  *		"HH:MM:SS.D_____MM/DD/YY" (where '_' is a space)  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *$  *	TPtime - The converted utc value.  *  *  Implicit Outputs:   *    *	None.  *        *  Value Returned:   *    *	None.  *  *  Side Effects:   * C  *	None.  *  *--  */_ CvtTPtoUTC( TPdata, TPtime )
 char *TPdata;i struct utc *TPtime;)   {t"    long		tns, ins, dns, dns_inacc;-    struct tm	time, inacc, delta, delta_inacc;     struct utc   TPdelta;    struct utc   TPraw;       /* *#      * convert all fields in recorde      */h1     if ( sscanf( TPdata, "%d:%d:%d.%d %d/%d/%d", 9A                 &time.tm_hour, &time.tm_min, &time.tm_sec, &tns,  E                 &time.tm_mon, &time.tm_mday, &time.tm_year ) == EOF )      {*I 	(void) fprintf(stderr, "M_GC1000: time/date field conversion failed\n");r 	return(0);y     }c       /* i9      * convert tenths of seconds (hundreds of ms) into ns*      */:"     tns = tns * 100 * K_NS_PER_MS;       /* 1)      * Adjust the months to be zero basedh      */        time.tm_mon -= 1;t       /*  !      * Zero out the unused fieldsd      */N       time.tm_wday = 0;s     time.tm_yday = 0;*     time.tm_isdst = 0;       /*      * Get the inaccuracy       */e  -     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;	     inacc.tm_min = 0;	     inacc.tm_hour = 0;     inacc.tm_yday = 0;     inacc.tm_isdst = 0;m4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;  6     if (utc_mkgmtime(&TPraw, &time, tns, &inacc, ins)) 	return(0);,       /*,      * Adjust the time for the clock delays:-      *  1.00 seconds from trigger to responseaA      *  0.024 seconds from response to processed ( at 9600 baud )       */u       delta.tm_hour = 0;     delta.tm_min = 0;a     delta.tm_sec = 1;      delta.tm_wday = 0;     delta.tm_mday = 0;     delta.tm_mon = 0;a     delta.tm_year = 0;     delta.tm_yday = 0;     delta.tm_isdst = 0;*     dns = 24 * K_NS_PER_MS;*       delta_inacc.tm_hour = 0;     delta_inacc.tm_min  = 0;     delta_inacc.tm_sec  = 0;     delta_inacc.tm_wday = 0;     delta_inacc.tm_mday = 0;     delta_inacc.tm_mon  = 0;     delta_inacc.tm_year = 0;     delta_inacc.tm_yday = 0;     delta_inacc.tm_isdst= 0;     dns_inacc = 0;  F     if (utc_mkreltime(&TPdelta, &delta, dns, &delta_inacc, dns_inacc)) 	return(0);s  .     if (utc_addtime(TPtime, &TPdelta, &TPraw)) 	return(0);      else 	return(1);t   }a /* End of routine CvtTPtoUTC */I #endif   #ifdef TP_SPEC /*;  **********************************************************0#  * 		Spectracom Specific  Routines. ;  **********************************************************I  */e /*)  * Spectracom character conversion macros   */a+ #define CVT_ASCII_TO_INT(chr) ((chr) - '0') 0 #define CVT_ASCII_TO_INT_AND_ADD(chrhi, chrlo) \; 	((CVT_ASCII_TO_INT(chrhi) << 6) + CVT_ASCII_TO_INT(chrlo))r     /*  *	Literalsf  */C  > #define M_SPECTRACOM_CLOCK_RESET   (0x1)    /* Clock reset		*/@ #define M_SPECTRACOM_YEAR_MISMATCH (0x2)    /* Year mismatch		*/? #define M_SPECTRACOM_AVAIL	   (0x4)    /* Time not available	*/x                                                                                                                                                                                                                                                   	                        Px= $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                              C "            ? #define M_SPECTRACOM_SIGNAL_FAULT  (0x8)    /* Signal fault		*/lA #define M_SPECTRACOM_HARD_FAULT	   (0x10)   /* Hardware fault		*/sC #define M_SPECTRACOM_OUT_OF_SPEC   (0x20)   /* Time out of spec		*/e  9 #define M_SPECTRACOM_PM_TIME	   (0x8)	/* PM indication	*/e8 #define M_SPECTRACOM_12_HR	   (0x10)	/* 12 hour mode		*/  K #define SPECTRACOM_NOCLOCKSET    (0)   /* allow the clock to be affected */eK #define SPECTRACOM_POLL_RATE     (60)  /* sixty seconds between tp polls */tK #define SPECTRACOM_TIME_STAMPS   (3)   /* number of time samples to read */ I #define SPECTRACOM_INACCURACY    (30)  /* 30ms of inaccuracy default   */ P #define SPECTRACOM_TMORATE       (30)  /* 30 seconds to respond to TS request */I #define SPECTRACOM_RETRIES       (2)  /* allow 2 errors per radio read */f #define SPECTRACOM_PROMPT	 "T"  K #define SPECTRACOM_RESPONSE_LENGTH      (26) /* Length of valid response */   G #define SPECTRACOM_TIMEOUT	        (30) /* Allow 30 seconds for radio *r( 					      * clock to respond to TS	  */L #define SPECTRACOM_QIO_TIMEOUT           (5) /* Allow  5 secs to respond  */C #define SPECTRACOM_RETRY	         (2) /* Retry twice on error 	  */t8 #define SPECTRACOM_ISVERBOSE		 (1) /* generate output */P #define SPECTRACOM_MAXTPERROR            (60)/* ignore deltas greater than 60 */P #define SPECTRACOM_FIRSTSYNCH            (1) /* synch up the first time thru  */     r /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:   *A  *  Initialize the default input parameters for the external times
  *  provider.s  *  *  *    *  Inputs:n  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll ratea7  *    timestamp- int to be set to the default number ofeD  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).i@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should notcE  *               be affected by the results of the TP synch, false if C  *               the clock can be modified by the results of the TPf  *               synch.NE  *    retries -  int to be set to the number of times the program is c7  *               allowed to resend a request after the *=  *               external time source has returned a failure.sG  *    firstsync- boolean, assume that the time returned by the externaln>  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, thec2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messages #  *               will be displayed.   *  *  * d  *  Implicit Outputs:-  *    none.e  *        *  Value Returned:s  *    none.0  *  *  Side Effects:   *    none.E  *  *--  */*- void InitializeTPdefaults(pollrate,timestamp,  			  inaccuracy,tmorate, 			  clockSet,retries, 			  firstsynch,maxtperror,  			  isverbose)t int *pollrate,     *timestamp,t     *inaccuracy,
     *tmorate,      *clockSet,
     *retries,	     *firstsynch,     *maxtperror,     *isverbose;i { >     *pollrate  = SPECTRACOM_POLL_RATE;    /* seconds        */>     *timestamp = SPECTRACOM_TIME_STAMPS;  /* int, 1-6       */>     *inaccuracy= SPECTRACOM_INACCURACY;   /* seconds        */>     *tmorate   = SPECTRACOM_TIMEOUT;      /* seconds        */>     *clockSet  = SPECTRACOM_NOCLOCKSET;   /* int, t/f - 1/0 */>     *retries   = SPECTRACOM_RETRIES;      /* int > 0        */>     *firstsynch= SPECTRACOM_FIRSTSYNCH;   /* int > 0        */>     *maxtperror= SPECTRACOM_MAXTPERROR;   /* seconds        */@     *isverbose = SPECTRACOM_ISVERBOSE;      /* int > 0        */   }0) /* End of routine InitializeTPdefaults */      /*  *++  *  QueryProvider()/  *  *  Functional Description:   *H  *      Query the provider for the time. Generate the timestamp triplet.  *    *  Inputs:c  *  *	ttchan - channel to read.  *  *  Outputs:  *8  *	TPtime - return utc time, the time read from provider7  *	beforeTime - the utc just before the command is sent =  *	afterTime - the utc just after the on time marker arrived.d  * "  *  Value Returned:   *-  *	-1	Unequivocal failure - Radio clock faulte  *	0	Success'  *	1	Timeout failure - retry warranted.k  *  *--  */e int R QueryProvider ( int ttchan, utc_t  *TPtime, utc_t  *beforeTime, utc_t  *afterTime) {eH     char TPdata[SPECTRACOM_RESPONSE_LENGTH + 1];   /* Response buffer	*/     int  status;     int  retSize;	4     IOsb  TPIOSB;		/* status block for spectracom */     struct {long null;) 	    long mask;} term_mask = {0, 0x0000};    			        /*r0    				 * now a structure to set the terminator  				 * character for the read.
    				 */       /*       * Record 'before' timestamp      */ #     (void) utc_gettime(beforeTime);*       /*I      * post qiow read to the spectracom with a timeout.  This also purges 2      * the input buffer of any residue characters.      */ +     status = SYS$QIOW(0,			/* event flag */ & 		      ttchan,			/* channel number */- 		      IO$_READPROMPT |		/* function code */1 			IO$M_TIMED |n 			IO$M_NOECHO | 			IO$M_PURGE,( 		      &TPIOSB,			/* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */3 		      TPdata,	       		/* buffer for user data */ A 		      SPECTRACOM_RESPONSE_LENGTH, /* buffer size of response */ ; 		      SPECTRACOM_QIO_TIMEOUT,	  /* P3; secs to timeout */m: 		      &term_mask,		/* P4: mask specifying terminators */4 		      SPECTRACOM_PROMPT, 		/* P5; prompt string */? 		      strlen(SPECTRACOM_PROMPT)); 	/* P6; length of prompt */        /*      * Record 'after' timestamp       */p"     (void) utc_gettime(afterTime);       if ( !(status & 1) )     {(C 	(void) fprintf(stderr, "M_SPEC: QIO Status failure %x\n", status);          return ( status );     }0     if ( !(TPIOSB.status & 1) )      { K         (void) fprintf(stderr, "M_SPEC: IOSB Status failure %x bytes %d\n",T 		       TPIOSB.status,d 		       TPIOSB.byteCount);i!         return ( TPIOSB.status );g     }t       /*5      * check that we got the correct number of bytes.[#      * Otherwise return hard error.)      */(8     if (TPIOSB.byteCount != SPECTRACOM_RESPONSE_LENGTH)      { ? 	(void) fprintf(stderr, "M_SPEC: response length failure %x\n",\ 		       TPIOSB.byteCount);  	return(0);      }n.     TPdata[SPECTRACOM_RESPONSE_LENGTH] = '\0';       /*C      * Now parse the radio clock data to determine the actual time.*      */v&     return(ParseTime(TPtime, TPdata)); }e * /*  *++  *  ParseTime()t  *  *  Functional Description:   *A  *	Convert the radio clock text data string into a numerical utc.G  *    *  Inputs:i  *(  *	buffer - the radio clock data string.  *  *  Outputs:  *&  *	utcTime - utc returned by the parse  *    *  Value Returned:   *  *	1 - Success  * 	0 - Failure   *  *--  */t int ParseTime (utcTime, buffer)  struct utc *utcTime; char   *buffer;. {*!     static char daytab[2][13] = {.5 	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},P6 	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};          struct tm timetm;t     struct tm inacc;     unsigned long ins;     unsigned long tns;     char status;     int leapyear;e
     int i;       /*%      * Convert and parse status bytes"      */%     status = buffer[2];        if (status == '*') { 	(void) fprintf(stderr,,L                   "dtssprovider: Spectracom manually set, ignoring time\n"); 	return(0);      }(       if (status == '?') {F 	(void) fprintf(stderr, "dtssprovider: Spectracom has lost signal\n"); 	return(0);h     }c       if (buffer[3] == '$') {  	(void) fprintf(stderr, B 		       "dtssprovider: Spectracom year incorrect in switches\n"); 	return(0);*     }        /*%      * Check clock qualtity indicator       */d       if (buffer[3] == 'A')e4 	ins += 9 * K_NS_PER_MS;		/* Add additional 9 ms. */     else if (buffer[3] == 'B')5 	ins += 99 * K_NS_PER_MS;	/* Add additional 99 ms. */C     else if (buffer[3] == 'C')7 	ins += 499 * K_NS_PER_MS;	/* Add additional 499 ms. */;     else if (buffer[3] == 'D')% 	return(0);			/* Clock too far out */S  5     if ((buffer[0] != '\015' || buffer[1] != '\n') ||cL         (buffer[13] != ':') || (buffer[16] != ':') || (buffer[                                                                                                                                                                                                                                                   
                        0 $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                              T "            19] != '.')) {= 	(void) fprintf(stderr, "dtssprovider: radio clock fault\n"); : 	(void) fprintf(stderr, "time returned - %26s\n", buffer); 	return(0);t     }u       /*I      * Convert bytes 2 and 3 into year. If the result is before 1990, thee%      * century most have rolled over.a      */t  7     timetm.tm_year = CVT_ASCII_TO_INT(buffer[4]) * 10 +=# 		     CVT_ASCII_TO_INT(buffer[5]);      if (timetm.tm_year < 90) 	timetm.tm_year += 100;        /*0      * Convert bytes 5, 6 and 7 into day of year      */e8     timetm.tm_yday = CVT_ASCII_TO_INT(buffer[7]) * 100 +) 		     CVT_ASCII_TO_INT(buffer[8]) * 10 +m# 		     CVT_ASCII_TO_INT(buffer[9]);        /*(      * Convert bytes 9 and 10 into hours      */l8     timetm.tm_hour = CVT_ASCII_TO_INT(buffer[11]) * 10 +$ 		     CVT_ASCII_TO_INT(buffer[12]);       /*+      * Convert bytes 12 and 13 into minuteso      */ 7     timetm.tm_min = CVT_ASCII_TO_INT(buffer[14]) * 10 +*# 		    CVT_ASCII_TO_INT(buffer[15]);*       /*+      * Convert bytes 15 and 16 into seconds*      */*7     timetm.tm_sec = CVT_ASCII_TO_INT(buffer[17]) * 10 + # 		    CVT_ASCII_TO_INT(buffer[18]);c       /*3      * Convert bytes 18, 19 and 20 into nanosecondsn      */I/     tns = (CVT_ASCII_TO_INT(buffer[20]) * 100 +_' 	   CVT_ASCII_TO_INT(buffer[21]) * 10 +)0 	   CVT_ASCII_TO_INT(buffer[22])) * K_NS_PER_MS;       /*%      * Compute month and day of monthd      */PL     leapyear = ((timetm.tm_year % 4 == 0) && (timetm.tm_year % 100 != 0)) ||+                (timetm.tm_year % 400 == 0);f$     timetm.tm_mday = timetm.tm_yday;8     for (i=1; timetm.tm_mday > daytab[leapyear][i]; i++)' 	timetm.tm_mday -= daytab[leapyear][i];      timetm.tm_mon = i-1;       /*      * Check values*      */f2     if (timetm.tm_sec > 60 ||			/* Leap seconds */         timetm.tm_min > 59 ||  	timetm.tm_hour > 23 ||	 	timetm.tm_yday > 366) {= 	(void) fprintf(stderr, "dtssprovider: radio clock fault\n");n: 	(void) fprintf(stderr, "time returned - %26s\n", buffer); 	return(0);d     }P       /*B      * Convert the data returned by radio clock into a struct utc.      * Call the DTSS API      */s5     (void)memset((void *)&inacc,0,sizeof(struct tm));E-     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;u4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;K     return((utc_mkgmtime(utcTime, &timetm, tns, &inacc, ins)== 0) ? 1 : 0);R   }R #endif   H #ifdef TP_TRAC /*;  **********************************************************(!  * 		Traconex Specific  Routines.r  *;  **********************************************************O  */O   /*'  * Traconex character conversion macros/  */f+ #define CVT_ASCII_TO_INT(chr) ((chr) - '0')i0 #define CVT_ASCII_TO_INT_AND_ADD(chrhi, chrlo) \; 	((CVT_ASCII_TO_INT(chrhi) << 6) + CVT_ASCII_TO_INT(chrlo))    /*  *  Traconex Literalsr  */ 9 #define M_TRACONEX_CLOCK_RESET	 (0x1)	/* Clock reset			*/ ; #define M_TRACONEX_YEAR_MISMATCH (0x2)	/* Year mismatch		*/a9 #define M_TRACONEX_AVAIL	 (0x4)	/* Time not available		*/ ; #define M_TRACONEX_SIGNAL_FAULT	 (0x8)	/* Signal fault			*/s; #define M_TRACONEX_HARD_FAULT	 (0x10)	/* Hardware fault		*/p> #define M_TRACONEX_OUT_OF_SPEC	 (0x20)	/* Time out of spec		*/  6 #define M_TRACONEX_PM_TIME	 (0x8)	/* PM indication		*/5 #define M_TRACONEX_12_HR	 (0x10)	/* 12 hour mode			*/o  & #define TRACONEX_PROMPT		 "\003QU0000"$ #define TRACONEX_PROMPT_LENGTH   (9)  J #define TRACONEX_RESPONSE_LENGTH (10) /* Length of valid resp.          */  C #define TRACONEX_TIMEOUT       (45)   /* Allow 45 seconds for TPP	*t. 				       * to respond to TS               */A #define TRACONEX_RETRY	       (5)    /* Retry 5 times		        */lJ #define TRACONEX_QIO_TIMEOUT   (30)   /* allow 30 secs for radio to resp*/J #define TRACONEX_NOCLOCKSET    (0)    /* allow the clock to be affected */J #define TRACONEX_POLL_RATE     (60)   /* sixty seconds between tp polls */J #define TRACONEX_TIME_STAMPS   (3)    /* number of time samples to read */J #define TRACONEX_INACCURACY    (30)   /* 30ms of inaccuracy default     */J #define TRACONEX_ISVERBOSE     (1)    /* generate output                */J #define TRACONEX_MAXTPERROR    (60)   /* ignore deltas greater than 60  */J #define TRACONEX_FIRSTSYNCH    (1)    /* synch up the first time thru   */     l /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:t  *A  *  Initialize the default input parameters for the external time 
  *  provider.l  *  *  *    *  Inputs:r  *    None.b  *  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll rate 7  *    timestamp- int to be set to the default number of D  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).t@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should not E  *               be affected by the results of the TP synch, false if C  *               the clock can be modified by the results of the TPt  *               synch.EE  *    retries -  int to be set to the number of times the program is  7  *               allowed to resend a request after the E=  *               external time source has returned a failure.SG  *    firstsync- boolean, assume that the time returned by the external*>  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, thei2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messagese#  *               will be displayed.v  *  *  * r  *  Implicit Outputs:f  *    none.n  *        *  Value Returned:u  *    none.   *  *  Side Effects:v  *    none.*  *  *--  */d- void InitializeTPdefaults(pollrate,timestamp,  			  inaccuracy,tmorate, 			  clockSet,retries, 			  firstsynch,maxtperror,  			  isverbose)e int *pollrate,     *timestamp,t     *inaccuracy,
     *tmorate,m     *clockSet,
     *retries,C     *firstsynch,     *maxtperror,     *isverbose;    {sA     *pollrate  = TRACONEX_POLL_RATE;         /* seconds        */sA     *timestamp = TRACONEX_TIME_STAMPS;       /* int, 1-6       */{A     *inaccuracy= TRACONEX_INACCURACY;        /* seconds        */eA     *tmorate   = TRACONEX_TIMEOUT;           /* seconds        */ A     *clockSet  = TRACONEX_NOCLOCKSET;        /* int, t/f - 1/0 */bA     *retries   = TRACONEX_RETRY;             /* int > 0        */hA     *firstsynch= TRACONEX_FIRSTSYNCH;        /* int > 0        */dA     *maxtperror= TRACONEX_MAXTPERROR;        /* seconds        */*C     *isverbose = TRACONEX_ISVERBOSE;           /* int > 0        */	 }f) /* End of routine InitializeTPdefaults */_   O /*  *++  *  QueryProvider()I  *  *  Functional Description:   *H  *      Query the provider for the time. Generate the timestamp triplet.  *    *  Inputs:r  *  *	ttchan - channel to read.  *  *  Outputs:  *8  *	TPtime - return utc time, the time read from provider>  *	beforeTime - the utc just before the on time marker arrived=  *	afterTime - the utc just after the on time marker arrived.   * t  *  Value Returned:t  *4  *	-1	Unequivocal failure - Stratum too far from TP.  *	0	Success&  *	1	Timeout failure - retry warented.  *  *--  */t   int D QueryProvider(int ttchan, struct utc *TPtime,struct utc *beforeTime,C                                              struct utc *afterTime)  {      /*&      * Posting and reading characters.9      * See Traconex DIP switches for speed and parity forr      * data exchange.       */SF     char TPdata[TRACONEX_RESPONSE_LENGTH+1];	/* Response buffer		   */@     static char traconex_prompt_string[TRACONEX_PROMPT_LENGTH] =(     {0,'0','3','Q','U','0','0','0','0'};     int  status;     int  retSize;	.     IOsb  TPIOSB;		/* status block for PSTI */     struct {long null;) 	    long mask;} term_mask = {0, 0x0000};	   			        /*e0    				 * now a structure to set the terminator  				 * character for the read.
    				 */            /*       * Record 'before' timestamp      */i#     (void) utc_gettime(beforeTime);T       /*C      * post qiow read to the psti with a timeout.  This also purgesp2      * the input buffer of any residue characters.      */a+     status = SYS$QIOW(0,			/* event flag */b& 		      ttchan,			/* channel number */- 		                                                                                                                                                                                                                                                                              $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                              0 "                IO$_READPROMPT |		/* function code */y 			IO$M_TIMED |  			IO$M_NOECHO | 			IO$M_PURGE,( 		      &TPIOSB,			/* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */3 		      TPdata,	       		/* buffer for user data */,? 		      TRACONEX_RESPONSE_LENGTH,	/* buffer size of response */37 		      TRACONEX_QIO_TIMEOUT,	/* P3; secs to timeout */t: 		      &term_mask,		/* P4: mask specifying terminators */7 		      traconex_prompt_string,	/* P5; prompt string */r; 		      TRACONEX_PROMPT_LENGTH); /* P6; length of prompt */e       /*      * Record 'after' timestamp       */t"     (void) utc_gettime(afterTime);       if ( !(status & 1) )     {:C 	(void) fprintf(stderr, "M_TRAC: QIO Status failure %x\n", status);          return ( status );     }p     if ( !(TPIOSB.status & 1) )t     {aB         (void) fprintf(stderr, "M_TRAC: IOSB Status failure %x\n", 		       TPIOSB.status);E 	(void) fprintf(stderr, "M_TRAC: Bytes Read: %d\n",TPIOSB.byteCount);;  !         return ( TPIOSB.status );      }k       /*5      * check that we got the correct number of bytes.e#      * Otherwise return hard error.d      */ 6     if (TPIOSB.byteCount != TRACONEX_RESPONSE_LENGTH)      {S? 	(void) fprintf(stderr, "M_TRAC: response length failure %x\n",i 		       TPIOSB.byteCount);d 	return(0);4     }*     /*C      * Now parse the radio clock data to determine the actual time.       */b    &     return(ParseTime(TPtime, TPdata)); }    /*  *++  *  ParseTime()u  *  *  Functional Description:=  *A  *	Convert the radio clock text data string into a numerical utc.   *    *  Inputs:t  *(  *	buffer - the radio clock data string.  *  *  Outputs:  *&  *	utcTime - utc returned by the parse  *    *  Value Returned:r  *#  *	0 - Buffer, parse was successfull  *	-1 - hard Failure. '  *	1 - Temporary failure - Retry later.f  *  *--  */  int ParseTime (utcTime, buffer)) struct utc *utcTime; char   *buffer;t {m!     static char daytab[2][13] = {n5 	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},i6 	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};          struct tm timetm;)     struct tm inacc;     unsigned long ins;     unsigned long tns;     int status1, status2;s     int leapyear;e
     int i;       /*%      * Convert and parse status bytesA      */N*     status1 = CVT_ASCII_TO_INT(buffer[0]);*     status2 = CVT_ASCII_TO_INT(buffer[1]);  +     if (status1 & M_TRACONEX_OUT_OF_SPEC) { 7 	(void) printf("dtssprovider: Traconex out of spec\n");* 	return(0);s     }   *     if (status1 & M_TRACONEX_HARD_FAULT) {9 	(void)printf("dtssprovider: Traconex hardware fault\n");I 	return(0);)     }   ,     if (status1 & M_TRACONEX_SIGNAL_FAULT) {8 	(void) printf("dtssprovider: Traconex signal fault\n"); 	return(0);      }_  (     if (!(status1 & M_TRACONEX_AVAIL)) {> 	(void) printf("dtssprovider: Traconex time not available\n"); 	return(0);y     }t  -     if (status1 & M_TRACONEX_YEAR_MISMATCH) { 9 	(void) printf("dtssprovider: Traconex year mismatch\n");i 	return(0);%     }        /*%      * Convert bytes 2 and 3 into ms.o      */iI     tns = (CVT_ASCII_TO_INT_AND_ADD(buffer[2], buffer[3])) * K_NS_PER_MS;r       /*9      * Convert bytes 4, 5 and 6 into secs, mins and hours       */ 0     timetm.tm_sec = CVT_ASCII_TO_INT(buffer[4]);0     timetm.tm_min = CVT_ASCII_TO_INT(buffer[5]);1     timetm.tm_hour = CVT_ASCII_TO_INT(buffer[6]);e       /*+      * Handle 12/24 hour and Military modesi      */r%     if (status2 & M_TRACONEX_12_HR) {r$ 	if (status2 & M_TRACONEX_PM_TIME) {4 	    if (timetm.tm_hour != 12) timetm.tm_hour += 12;	 	} else {*2 	    if (timetm.tm_hour == 12) timetm.tm_hour = 0; 	}     },       /*-      * Convert bytes 7 and 8 into day of yearS      */uD     timetm.tm_yday = CVT_ASCII_TO_INT_AND_ADD(buffer[7], buffer[8]);        /*u3       * Convert byte 9 (offset from 1986) into year        */?     timetm.tm_year = CVT_ASCII_TO_INT(buffer[9]) + 1986 - 1900;*      *     /*%      * Compute month and day of months      */*L     leapyear = ((timetm.tm_year % 4 == 0) && (timetm.tm_year % 100 != 0)) ||+                (timetm.tm_year % 400 == 0);f$     timetm.tm_mday = timetm.tm_yday;8     for (i=1; timetm.tm_mday > daytab[leapyear][i]; i++)' 	timetm.tm_mday -= daytab[leapyear][i];T     timetm.tm_mon = i-1;       /*      * Check valuesn      */N2     if (timetm.tm_sec > 60 ||			/* Leap seconds */         timetm.tm_min > 59 ||/ 	timetm.tm_hour > 23 ||f 	timetm.tm_yday > 366) {= 	(void) fprintf(stderr, "dtssprovider: radio clock fault\n");(A 	(void) fprintf(stderr, "time returned - %d %d:%02d:%02d.%09d\n",*E                        timetm.tm_yday, timetm.tm_hour, timetm.tm_min,t+                        timetm.tm_sec, tns);0     }P       /*B      * Convert the data returned by radio clock into a struct utc.      * Call the DTSS API      */"5     (void)memset((void *)&inacc,0,sizeof(struct tm));N-     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;.4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;L     return((utc_mkgmtime(utcTime, &timetm, tns, &inacc, ins) == 0) ? 1 : 0);     }n #endif R #ifdef TP_HOPF /*;  **********************************************************(  *		HOPF Specific Routines. ;  **********************************************************t  */o   /*  * HOPF specific constants  */P2 #define M_HOPF_FLAG_STX		2	/* 'STX' header flag */ /*  * HOPF status byte 1_  */SF #define M_HOPF_TIME_RADIO	0x08	/* bit to test for time availability */8 #define M_HOPF_TIME_CLOCK	0x04	/* internal clock mode */0 #define M_HOPF_DST_IND		0x02	/* DST indicator */3 #define M_HOPF_DST_ANN		0x01	/* DST announcement */0 /*  * HOPF status byte 2r  */ 0 #define M_HOPF_UTC_IND		0x08	/* UTC indicator *// #define M_HOPF_WEEK_DAY		0x07	/* day of week */+  M #define HOPF_NOCLOCKSET          (0)     /* allow the clock to be affected */eM #define HOPF_POLL_RATE           (60)    /* sixty seconds between tp polls */*M #define HOPF_TIME_STAMPS         (3)     /* number of time samples to read */ K #define HOPF_INACCURACY          (30)    /* 30ms of inaccuracy default   */-L #define HOPF_TMORATE             (30)	 /* 30 secs to respond to TS request*/  : #define HOPF_PROMPT "g02"	 /* prompt string for TP time */E #define HOPF_RESPONSE_LENGTH 18	 /* max. # of bytes returned by TP */oP #define HOPF_RESPONSE_NUMLEN 15	 /* min # of numerical bytes required from TP */   #define HOPF_QIO_TIMEOUT1   1eD #define HOPF_QIO_TIMEOUT2   2	 /* seconds till read QIO times out */H #define HOPF_RETRIES        5    /* allow 5 retries after a TP failure*/5 #define HOPF_ISVERBOSE	    1    /* generate output */fD #define HOPF_MAXTPERROR     60   /* ignore deltas greater than 60 */D #define HOPF_FIRSTSYNCH     1    /* synch up the first time thru  */ t e /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:t  *A  *  Initialize the default input parameters for the external timea
  *  provider.i  *  *  *    *  Inputs:o  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll rateh7  *    timestamp- int to be set to the default number ofeD  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).*@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should not E  *               be affected by the results of the TP synch, false ifaC  *               the clock can be modified by the results of the TP   *               synch.pE  *    retries -  int to be set to the number of times the program is k7  *               allowed to resend a request after the  =  *               external time source has returned a failure. G  *    firstsync- boolean, assume that the time returned by the external/>  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, the 2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messageso#  *               will be displayed.o  *  *  * *  *  Implicit Outputs:O  *    none.;  *        *  Value Returned:	  *    none.o  *  *  Side Effects:e  *    none.   *  *--  */*- void InitializeTPdefaults(pollrate,timestamp,i 			  inaccuracy,tmorate, 			  clo                                                                                                                                                                                                                                                                           S	 $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                              < "            ckSet,retries, 			  firstsynch,maxtperror,e 			  isverbose)u int *pollrate,     *timestamp,r     *inaccuracy,
     *tmorate,t     *clockSet,
     *retries,      *firstsynch,     *maxtperror,     *isverbose;r {h8     *pollrate  = HOPF_POLL_RATE;    /* seconds        */8     *timestamp = HOPF_TIME_STAMPS;  /* int, 1-6       */8     *inaccuracy= HOPF_INACCURACY;   /* seconds        */8     *tmorate   = HOPF_TMORATE;      /* seconds        */8     *clockSet  = HOPF_NOCLOCKSET;   /* int, t/f - 1/0 */8     *retries   = HOPF_RETRIES;      /* int > 0        */8     *firstsynch= HOPF_FIRSTSYNCH;   /* int > 0        */8     *maxtperror= HOPF_MAXTPERROR;   /* seconds        */:     *isverbose = HOPF_ISVERBOSE;      /* int > 0        */   } ) /* End of routine InitializeTPdefaults */_   /*  *++  *  QueryProvider()   *  *  Functional Description:p  *B  *  This routine issues a single 'g02' command to the HOPF device.?  *  It returns the Binary Absolute Time represented by the HOPF   *  data returned.  *  *    *  Inputs:n  *2  *	ttchan - The active channel to the HOPF device.  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *1  *	TPtime - The Time returned by the HOPF device.   * *  *  Implicit Outputs:'  *  *        *  Value Returned:c  *(  *	0 - Failure - The HOPF device failed.4  *      1 - Success - The HOPF device was contacted.  *  *  Side Effects:f  *  *  *--  */c   int D QueryProvider(int ttchan, struct utc *TPtime,struct utc *beforeTime,C                                              struct utc *afterTime)o {      /*9      * passing binary encoded data.  Set terminal char toI%      * eightbit,passall, and pasthru.,      */ (     char HOPFdata[HOPF_RESPONSE_LENGTH];     int  status;     int  retSize;	     int count,i,temp; 0     IOsb  hopfIOSB;		/* status block for HOPF */     struct {long null;) 	    long mask;} term_mask = {0, 0x0008};    			        /*k0    				 * now a structure to set the terminator $ 				 * character 'ETX' for the read.
    				 */       /*H      * First, post a qiow read to the HOPF with a timeout first to purge2      * the input buffer of any residue characters.      */i  +     status = SYS$QIOW(0,			/* event flag */d& 		      ttchan,			/* channel number */+ 		      IO$_READVBLK |		/* function code */u 			IO$M_TIMED |  			IO$M_PURGE,0 		      &hopfIOSB,	        /* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */5 		      HOPFdata,	       		/* buffer for user data */I; 		      HOPF_RESPONSE_LENGTH,	/* buffer size of response */k4 		      HOPF_QIO_TIMEOUT1,	/* P3; secs to timeout */2 		      0,			/* P4: mask specifying terminators */% 		      0,	 		/* P5; prompt string */R) 		      0);		 	/* P6; length of prompt */p       /*-      * Next, get the internal UTC time first.	      */I  %     (void) utc_gettime( beforeTime );        /*>      * Now, post a qiow write to the HOPF to ask for UTC time.      */b  +     status = SYS$QIOW(0,			/* event flag */ & 		      ttchan,			/* channel number */+ 		      IO$_WRITEVBLK,		/* function code */e0 		      &hopfIOSB,	        /* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */5 		      HOPF_PROMPT,     		/* buffer for user data */y: 		      strlen(HOPF_PROMPT),	/* buffer size of response */& 		      0,			/* P3; secs to timeout */2 		      0,			/* P4: mask specifying terminators */% 		      0,	 		/* P5; prompt string */f) 		      0); 			/* P6; length of prompt */t       /*E      * Now, post a qiow read to the HOPF with a timeout and a special,      * terminator of "ETX".3      */,  +     status = SYS$QIOW(0,			/* event flag */t& 		      ttchan,			/* channel number */+ 		      IO$_READVBLK |		/* function code */  			IO$M_TIMED,0 		      &hopfIOSB,	        /* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */5 		      HOPFdata,	       		/* buffer for user data */_; 		      HOPF_RESPONSE_LENGTH,	/* buffer size of response */C4 		      HOPF_QIO_TIMEOUT2,	/* P3; secs to timeout */: 		      &term_mask,		/* P4: mask specifying terminators */% 		      0,	 		/* P5; prompt string */o) 		      0);		 	/* P6; length of prompt */r       /**      * Now get the internal UTC time last.      */   $     (void) utc_gettime( afterTime );       /*H      * Now do the various checks to ensure that we have a valid UTC time%      * string from the HOPF receiver.t      */v       if ( !(status & 1) )     { C 	(void) fprintf(stderr, "M_HOPF: QIO Status failure %x\n", status);s         return ( status );     })  !     if ( !(hopfIOSB.status & 1) )      {nB         (void) fprintf(stderr, "M_HOPF: IOSB Status failure %x\n", 		       hopfIOSB.status);#         return ( hopfIOSB.status );C     }b       /*     *  First check for 'STX'     */  *     if ( HOPFdata[0] != M_HOPF_FLAG_STX )      {;A 	(void) fprintf(stderr, "M_HOPF: Missing STX %s\n", HOPFdata[0]);o         return ( 0 );u       }e       /*E      * Now search for the 'LF' which terminates the numerical string.s      */C  (     for (i=0; i< hopfIOSB.byteCount;i++)     {{ 	if (HOPFdata[i] == '\n' )
 		count = i ;h     }1       /*D      * Check the position of 'LF' to ensure that we got the correct       * number of bytes.b      */d  '     if (count != HOPF_RESPONSE_NUMLEN) t     {== 	(void) fprintf(stderr, "M_HOPF: string length failure %x\n",  		       count); 	return(0);o     }        /*3      * Now convert status bytes for various checks.f      */1        temp = (HOPFdata[1] - '0' );       if ( HOPFdata[1] > '9' )       {*& 	    temp = (HOPFdata[1] - 'A' ) + 10;     }(       HOPFdata[1] = temp ;        temp = (HOPFdata[2] - '0' );       if ( HOPFdata[2] > '9' ) =     {.& 	    temp = (HOPFdata[2] - 'A' ) + 10;     }[       HOPFdata[2] = temp ;       /*5      * Check that we got the correct number of bytes. #      * Otherwise return hard error.       */e  3     if (hopfIOSB.byteCount < HOPF_RESPONSE_NUMLEN) t     { ? 	(void) fprintf(stderr, "M_HOPF: response length failure %x\n",d 		       hopfIOSB.byteCount);: 	return(0);f     })       /*F      * Check all the status bits, make sure this time is truely valid.      */        /* m4      * First check, if receiver gets radio datagram.      */t  .     if ( !(HOPFdata[1] & M_HOPF_TIME_RADIO) )      {e@ 	(void) fprintf(stderr, "M_HOPF: radio time not Available %x\n", 		       HOPFdata[1]); 	return(0);(     }&       /* e/      * Now check, if internal clock is running.       */S  -     if ( !(HOPFdata[1] & M_HOPF_TIME_CLOCK) )S     {;> 	(void) fprintf(stderr, "M_HOPF: no internal clock time %x\n", 		       HOPFdata[1]); 	return(0);i     }_       /* *%      * Now check, if we got UTC time.*      */*  *     if ( !(HOPFdata[2] & M_HOPF_UTC_IND) )     {*3 	(void) fprintf(stderr, "M_HOPF: no UTC time %x\n",  		       HOPFdata[2]); 	return(0);P     }n         /*(      * Now convert the data to integers.      */s  *      for ( i=3;i<HOPF_RESPONSE_NUMLEN;i++)      { 	temp = HOPFdata[i] - '0' ;  	HOPFdata[i] = temp ;_      }       /*=      * Convert the data returned by the HOPF into struct utc.o      */f  -     return(CvtHOPFtoUTC( HOPFdata, TPtime ));    }*     /*  *++  *  CvtHOPFtoUTC()  *  *  Functional Description:a  *F  * This routine converts the response string of the HOPF 'g02' command%  * into a Binary Absolute Time value.l  *  *  *    *  Inputs:f  *&  *	TPdata - The 'g02' response string.  *  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *$  *	TPtime - The converted utc value.  *  *  Implicit Outputs:R  *    *	None.  *        *  Value Returned:u  * *  *	None.  *  *  Side Effects:   * 0  *	None.  *  *--  */t" CvtHOPFtoUTC( HOPFdata, HOPFtime ) char *HOPFdata;t struct utc *HOPFtime;    {n    long		tns,ins;G    struct tm	time, inacc;e       /* P(      * Convert bytes 3 and 4 into hours.      */n  3     time.tm_hour = 10 * HOPFdata[3] + HOPFdata[4] ;T       /* e*      * Convert bytes 5 and 6 into minutes.      */   2     time.tm_min = 10 * HOPFdata[5] + HOPFdata[6] ;       /* r*      * Convert bytes 7 and 8 into seconds.      */1  2     time.tm_sec = 10 * HOPFdata[7] + HOPFdata[8] ;       /* g0      * Convert bytes 9 and 10 into day of month.      */   4     time.tm_mday = 10 * HOPFdata[9] + HOPFdata[10] ;         /* a2      * Convert bytes 11 and 12 into month of year.      */n  4     time.tm_mon = 10 * HOPFdata[11] + HOPFdata[12] ;       /* r      * Adjust month (0 - 11).       */        time.tm_mon -= 1;         /*  1      * Convert bytes 13 and 14 into year - 1900 .o      */   5     time.tm_year = 10 * HOPFdata[13] + HOP                                                                                                                                                                                                                                                   
                        cTa $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                               "            Fdata[14] ;        /*!      * Now get day of week first.e      */i  5     time.tm_wday = ( HOPFdata[2] & M_HOPF_WEEK_DAY );l       /*      * Now get DST indicator.t      */e  5     time.tm_isdst = ( HOPFdata[1] & M_HOPF_DST_IND );e       /*  /      * Now convert month and day into yearday. e      */n  F     YearDay (time.tm_year, time.tm_mon, time.tm_mday, &time.tm_yday );       /*      * Get the inaccuracyi      */t  -     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;d     inacc.tm_min = 0;T     inacc.tm_hour = 0;     inacc.tm_yday = 0;     inacc.tm_isdst = 0;u4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;     tns = 0;       /*     * Now get UTC time     */   8     if (utc_mkgmtime(HOPFtime, &time, tns, &inacc, ins))     	return(0);e     else     	return(1);u      }i! /* End of routine CvtHOPFtoUTC */s   t /*  *++
  *  YearDay()t  *  *  Functional Description:o  *B  *  This routine converts the current year, and the current day ofC  *  the current month into the day of the year ( ie 174th of 1989 )r&  *  to be stored in the time string.    *  *    *  Inputs:a  * c-  *	currYear - The current year as an integer.o-  *	currMonth - The numerical month ( 0 - 11 )e1  *	dayInMonth   - The day in the month ( 1 - 31 )   *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *)  *	yearDay - The current day in the year.   * n  *  Implicit Outputs:   *	i  *	None.  *  *  Value Returned:-  *  *	None.  *  *  Side Effects:l  *  *	None.  *  *--  */r1 YearDay(currYear, currMonth, dayInMonth, yearDay)c* int	currYear;				/* current year - 1900 */% int	currMonth;				/* current month */,% int	dayInMonth;				/* day of month */r) int	*yearDay;				/* ptr to day of year */, {      /*3    * table to convert month and day to day of year.c    */      int dayTab [2] [13] = {_5 	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},P6 	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};     int	i, leap;    1 	leap = (currYear%4 == 0 && currYear%100 != 0) || '                (currYear+300)%400 == 0;H   	for (i=1; i < currMonth; i++)" 	    *yearDay += dayTab[leap] [i];   	*yearDay += dayInMonth ;  }m     #endif /* TP_HOPF */   * #ifdef TP_NULL /*;  **********************************************************   *		NULL TP Specific Routines. P  *;  *   The null time provider is an uncompleted time providerl9  *   that uses the NOCLOCKSET function.  NOCLOCKSET beingc8  *   set to 1, instructs the time service to ignore the :  *   the time which the tp program returns, but to include5  *   set the system inaccuracy to the returned value.t8  *   This is useful if the system is being controlled by;  *   a time service other than DTSS, or if the system clockH=  *   is being controlled at the hardware level by an accuratea>  *   clock.  In either case, the system clock is not affected.  *;  **********************************************************E  */s  N #define NULL_NOCLOCKSET          (1)     /* allow only inacc to be affected */N #define NULL_POLL_RATE           (60)    /* sixty seconds between tp polls  */N #define NULL_TIME_STAMPS         (3)     /* number of time samples to read  */N #define NULL_INACCURACY          (30)    /* 30ms of inaccuracy default      */L #define NULL_TMORATE             (30)	 /* 30 secs to respond to TS request*/N #define NULL_RETRIES             (1)     /* allow 1 retries                 */6 #define NULL_ISVERBOSE		 (1)     /* generate output */L #define NULL_MAXTPERROR          (60)    /* ignore deltas greater than 60 */L #define NULL_FIRSTSYNCH          (1)     /* synch up the first time thru  */ i /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:.  *A  *  Initialize the default input parameters for the external timeh
  *  provider.l  *  *  *    *  Inputs:D  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll ratel7  *    timestamp- int to be set to the default number of D  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).	@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should not*E  *               be affected by the results of the TP synch, false if*C  *               the clock can be modified by the results of the TP	  *               synch. E  *    retries -  int to be set to the number of times the program is  7  *               allowed to resend a request after the  =  *               external time source has returned a failure.fG  *    firstsync- boolean, assume that the time returned by the external >  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, the 2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messagesn#  *               will be displayed.	  *  * o  *  Implicit Outputs:E  *    none.h  *        *  Value Returned:l  *    none.   *  *  Side Effects:   *    none./  *  *--  */ - void InitializeTPdefaults(pollrate,timestamp,e 			  inaccuracy,tmorate, 			  clockSet,retries, 			  firstsynch,maxtperror,  			  isverbose)T int *pollrate,     *timestamp,      *inaccuracy,
     *tmorate,i     *clockSet,
     *retries,,     *firstsynch,     *maxtperror,     *isverbose;e {h8     *pollrate  = NULL_POLL_RATE;    /* seconds        */8     *timestamp = NULL_TIME_STAMPS;  /* int, 1-6       */8     *inaccuracy= NULL_INACCURACY;   /* milliseconds   */8     *tmorate   = NULL_TMORATE;      /* seconds        */8     *clockSet  = NULL_NOCLOCKSET;   /* int, t/f - 1/0 */8     *retries   = NULL_RETRIES;      /* int > 0        */8     *firstsynch= NULL_FIRSTSYNCH;   /* int > 0        */8     *maxtperror= NULL_MAXTPERROR;   /* seconds        */:     *isverbose = NULL_ISVERBOSE;      /* int > 0        */ }.) /* End of routine InitializeTPdefaults */)   /*  *++  *  QueryProvider()c  *  *  Functional Description:(  *"  *     Return the inaccuracy only.  *  *    *  Inputs:e  *2  *	ttchan - The active channel to the HOPF device.  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *1  *	TPtime - The Time returned by the HOPF device.*  *    *  Implicit Outputs:S  *  *        *  Value Returned:d  *(  *	0 - Failure - The HOPF device failed.4  *      1 - Success - The HOPF device was contacted.  *  *  Side Effects:   *  *  *--  */s int D QueryProvider(int ttchan, struct utc *TPtime,struct utc *beforeTime,C                                              struct utc *afterTime); {r long ins,inst,tns; struct tm inacc,inacctm,timetm;u       /*D      *  Depending upon the clock implementation, the time and/or theG      *  inaccuracy could also be read from the time device using RS232 1H      *  for example. In that case, the radio time provider examples may        *  provide useful examples.C      *  In the following example, the inaccuracy as defined by the aC      *  user inaccuracy value is converted and returned to the time @      *  server.  Since the noclockset bit was set to one in the @      *  initialization routine, the actual time is ignored, but 8      *  the system inaccuracy is nonmonotonically set by@      *  the server to the value returned in the inacc tm struct.      */k     /**      * Get the inaccuracy into a tm struct      */ -     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;i"     inacc.tm_min = 0;                  inacc.tm_hour = 0;     inacc.tm_yday = 0;     inacc.tm_isdst = 0;(4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;  "     (void)utc_gettime(beforeTime);:     (void)utc_localtime(NULL,&timetm,&tns,&inacctm,&inst);7     (void)utc_mklocaltime(TPtime,&timetm,0,&inacc,ins);O!     (void)utc_gettime(afterTime);e       return;  }e #endif  /* TP_NULL */        #ifndef VMS]   /*  *++  *  ParseTime()   *  *  Functional Description:   *A  *	Convert the radio clock text data string into a numerical utc.   *    *  Inputs:(  *(  *	buffer - the radio clock data string.  *  *  Outputs:  *&  *	utcTime - utc returned by the parse  * t  *  Value Returned:.  *#  *	0 - Buffer, parse was successfulN  *	-1 - hard Failure. '  *	1 - Temporary failure - Retry later.]  *  *--  */  int  ParseTime (utcTime, buffer)t utc_t *utcTime;  char   *buffer                                                                                                                                                                                                                                                                           9U* $      DCEVAXMUPA013.A                2  ;  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;3                                                                                 S                              &O             ;u {o!     static char daytab[2][13] = {T5 	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},H6 	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};          struct tm timetm;s     unsigned long ins;     unsigned long tns;     char status;     int leapyear;*
     int i;       /*      * Copy base inaccuracye      */      ins = INACC;       /*%      * Convert and parse status bytes*      */      status = buffer[2];        if (status == '*') { 	BEGIN_NONREENTRANT  	(void) fprintf(stderr, K                   "dtsprovider: Spectracom manually set, ignoring time\n");P 	END_NONREENTRANTO 	return(1);r     }a       if (status == '?') { 	BEGIN_NONREENTRANTiE 	(void) fprintf(stderr, "dtsprovider: Spectracom has lost signal\n");d 	END_NONREENTRANT      }        /*%      * Check clock qualtity indicator       */        if (buffer[3] == 'A')a4 	ins += 9 * K_NS_PER_MS;		/* Add additional 9 ms. */     else if (buffer[3] == 'B')5 	ins += 99 * K_NS_PER_MS;	/* Add additional 99 ms. */      else if (buffer[3] == 'C')7 	ins += 499 * K_NS_PER_MS;	/* Add additional 499 ms. */b     else if (buffer[3] == 'D')% 	return(1);			/* Clock too far out */O       if (buffer[3] == '$') {  	BEGIN_NONREENTRANTe 	(void) fprintf(stderr,oA 		       "dtsprovider: Spectracom year incorrect in switches\n");F 	END_NONREENTRANT*     }   5     if ((buffer[0] != '\015' || buffer[1] != '\n') ||=L         (buffer[13] != ':') || (buffer[16] != ':') || (buffer[19] != '.')) { 	BEGIN_NONREENTRANTr< 	(void) fprintf(stderr, "dtsprovider: radio clock fault\n");: 	(void) fprintf(stderr, "time returned - %26s\n", buffer); 	END_NONREENTRANTE 	return(1);      }        /*I      * Convert bytes 4 and 5 into year. If the result is before 1990, theF%      * century most have rolled over.n      */h  7     timetm.tm_year = CVT_ASCII_TO_INT(buffer[4]) * 10 +y# 		     CVT_ASCII_TO_INT(buffer[5]);.     if (timetm.tm_year < 90) 	timetm.tm_year += 100;*       /*0      * Convert bytes 7, 8 and 9 into day of year      */n8     timetm.tm_yday = CVT_ASCII_TO_INT(buffer[7]) * 100 +) 		     CVT_ASCII_TO_INT(buffer[8]) * 10 +C# 		     CVT_ASCII_TO_INT(buffer[9]);        /*)      * Convert bytes 11 and 12 into hours       */(8     timetm.tm_hour = CVT_ASCII_TO_INT(buffer[11]) * 10 +$ 		     CVT_ASCII_TO_INT(buffer[12]);       /*+      * Convert bytes 14 and 15 into minutes       */ 7     timetm.tm_min = CVT_ASCII_TO_INT(buffer[14]) * 10 +s# 		    CVT_ASCII_TO_INT(buffer[15]);n       /*+      * Convert bytes 15 and 16 into secondsy      */e7     timetm.tm_sec = CVT_ASCII_TO_INT(buffer[17]) * 10 +r# 		    CVT_ASCII_TO_INT(buffer[18]);        /*3      * Convert bytes 20, 21 and 22 into nanosecondsT      */c/     tns = (CVT_ASCII_TO_INT(buffer[20]) * 100 +n' 	   CVT_ASCII_TO_INT(buffer[21]) * 10 +I0 	   CVT_ASCII_TO_INT(buffer[22])) * K_NS_PER_MS;       /*%      * Compute month and day of monthm      */tL     leapyear = ((timetm.tm_year % 4 == 0) && (timetm.tm_year % 100 != 0)) ||+                (timetm.tm_year % 400 == 0);a$     timetm.tm_mday = timetm.tm_yday;8     for (i=1; timetm.tm_mday > daytab[leapyear][i]; i++)' 	timetm.tm_mday -= daytab[leapyear][i];I     timetm.tm_mon = i-1;       /*      * Check valueso      */e2     if (timetm.tm_sec > 60 ||			/* Leap seconds */         timetm.tm_min > 59 ||  	timetm.tm_hour > 23 ||_ 	timetm.tm_yday > 366) { 	BEGIN_NONREENTRANT3< 	(void) fprintf(stderr, "dtsprovider: radio clock fault\n");: 	(void) fprintf(stderr, "time returned - %26s\n", buffer); 	END_NONREENTRANT  	return(1);(     }r       /*=      * Convert the data returned by radio clock into a utc_t.a      * Call the UTC API       */o@     return(utc_mkgmtime(utcTime, &timetm, tns, &INACC_TM, ins));   }* #endif    * /*;  **********************************************************i  *		Debugging  Routines.;  **********************************************************s  */N /*  *++  *  PrintTimes()  *  *  Functional Description:c  *4  *	Print out the contents of a time response message  *    *  Inputs:s  *9  *	timeResponse - the time response message to print out.d  *  *  Outputs:  *  *	None.  * s  *  Value Returned:l  *  *	None.  *  *--  */t void PrintTimes(timeResponse)  TPtimeMsg  *timeResponse;o {d     int  i;a  .     if (timeResponse->status == K_TPI_FAILURE)     {e" 	(void) printf("K_TPI_FAILURE\n");F         (void) printf("******************************************\n"); 	return;     }K  %     (void) printf("K_TPI_SUCCESS\n");t)     (void) printf("Time Stamps   : %d\n", " 		  timeResponse->timeStampCount);6     for (i = 0; i < timeResponse->timeStampCount; i++)     {u! 	(void) printf("Before Time\t:");d6 	PrintISO(&timeResponse->timeStampList[i].beforeTime);! 	(void) printf("\nTP Time\t\t:");T2 	PrintISO(&timeResponse->timeStampList[i].TPtime);" 	(void) printf("\nAfter Time\t:");5 	PrintISO(&timeResponse->timeStampList[i].afterTime);  	(void) printf("\n\n");(     }/B     (void) printf("******************************************\n"); }e l /*  *++  *  PrintISO()  *  *  Functional Description:)  *8  *	Print out a binary absolute time as an LOCAL ISO time  *    *  Inputs:)  *$  *	utcTime - the address of a utc_t.  *  *  Outputs:  *  *	None.  * t  *  Value Returned:t  *  *	None.  *  *--  */  void PrintISO(utcTime) utc_t *utcTime;  {      char	gmTimeStr[50];   A     (void) utc_ascgmtime (gmTimeStr, sizeof(gmTimeStr), utcTime);-     printf ("%s\t", gmTimeStr);b }o   * /*  *++  *  PrintValidationError()  *  *  Functional Description:   *;  *      The timeprovider is returning invalid times, report   *      to the user.  *    *  Inputs:e  *
  *      None.   *  *  Implicit Inputs:  *  *	SYNCHCOUNT,MAXTPERROR.t  *  *  Outputs:  *  *	None.  * s  *  Implicit Outputs:a  *  *        *  Value Returned:e  *	  * 	None.   *  *  Side Effects:t  *
  *      None.t  *  *--  */ - PrintValidationError(systemTime,externalTime)t struct utc *systemTime;i struct utc *externalTime;o {c char timestr[UTC_MAX_STR_LEN];  S     fprintf(stderr,"\n!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!\n");e;     fprintf(stderr,"The external time did not validate\n");e=     fprintf(stderr,"Synchronization Count: %u\n",SYNCHCOUNT);n=     fprintf(stderr,"Error Tolerance:       %u\n",MAXTPERROR);r6     utc_ascgmtime(timestr,UTC_MAX_STR_LEN,systemTime);:     fprintf(stderr,"System Time:           %s\n",timestr);8     utc_ascgmtime(timestr,UTC_MAX_STR_LEN,externalTime);:     fprintf(stderr,"External Device Time:  %s\n",timestr);-     fprintf(stderr,"\n!!!!!!!!!!!!!!!!!!\n");*      }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_BUILD.COM;3 +  , /7   .     /  @   4 J                           - ;    0   1    2   3      K  P   W   O     5   6 e5؊  7 a   8          9          G  @  H   J                          $!4 $! This DCL Command Procedure will compile and link & $! the DCE/DTS Time Provider examples. $!( $! Derermine compiler and linker options $! $ @DCE:DCE$CC_TEST $ cc := cc'f$trnlnm("dce$cc")' $!  $ $ If( f$trnlnm("dce$cc") .eqs. " " )J $ Then  options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options"' $ Else  options = "dce:dce.opt/options"  $ Endif  $!& $ if F$Edit(P1,"upcase") .eqs. "DEBUG" $ then	  $    debug = "/debug"  $    list  = "/list" $    opt   = "/NOopt"  $ else $    debug = ""  $    list  = ""  $    opt   = "" / $    write sys$output "P1 default - NOdebug..."  $ endif  $! $ prename := DCE$DTS_PROVIDER  $! $ name   = "NULL" 
 $ gosub build  $ name   = "SPEC" 
 $ gosub build  $ name   = "TRAC" 
 $ gosub build  $ name   = "PSTI" 
 $ gosub build  $ name   = "HOPF" 
 $ gosub build  $ name   = "GC1000" 
 $ gosub build  $ exit $ !  $ build:2 $ write sys$output " ** Compile ''name' Provider "6 $ cc 'debug 'list 'opt 'standard /OBJ='prename'_'name-1         /G_FLO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          DP $      DCEVAXMUPA013.A                /7  ;  6[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_BUILD.COM;3                                                                         J                              }'             AT/DEFINE=(TP_'name'=1) 'prename'.c  $ ! / $ write sys$output " ** Link ''name' Provider " 4 $ link'debug'/exe='prename'_'name 'prename'_'name, --              dce:dtsprovider_sstub, 'options'  $ return $ !                                                                                                                                                                                                                                                                                                                            7 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_GC1000.EXE;3 +  , :   . 8    /  @   4     8   7                     - ;    0   1    2   3      K  P   W   O 9    5   6 XS~A  7 g   8          9          G  @  H   J                         0 D `     0205        P@~     d                                                DCE$DTS_PROVIDER_GC1000                DCE V1.3-9503053P@ 05-13                             
               2   
  4     ?   $ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001!      !         DECC$SHR_001    D  DCE$DTS_TSTP_MBX DCE$DTS_TPTS_MBX DCE$DTS_TP_DEVICE DCE$DTS_TP_INACCURACY DCE$DTS_TP_POLL_RATE DCE$DTS_TP_TIME_STAMPS   DCE$DTS_TP_MAXERROR DCE$DTS_TP_FIRSTSYNC DCE$DTS_TP_VERBOSE DCE$DTS_PROVIDER  LNM$PROCESS_TABLE     The time stamp value is out of legal range
 Legal Range is %d to %d
 PARAMETERS SET:
       TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TRUE  FALSE TP_VERBOSE:         %s


 TRUE  FALSE dtsprovider: init radio clock %s - %s
 Unable to register interface for TPP %s - %s
 TPP unable to register protocol sequences  %s - %s
 Can't inquire bindings %s - %s
 Can't inquire bindings %s - %s
 Can't bind to string Got binding: %s
 Spectracom Time Provider %s - %s
  Can't register with endpoint mapper %s - %s
  Can't get machine's host name %s - %s
  Can't register authentication Listening for connections ...
 %s - %s
 RPC listen terminated abnormally Executing ContactProvider ...
 Executing ServerRequestProviderTime ...
 Reply written :
 %d -o:Output value is out of legal range
 %d -c:Clockset value is out of legal range
 %d -p:Pollrate value is out of legal range
 %d -i:Inaccuracy value is out of legal range
 %d -t:Time stamp count is out of legal range
 


Enter the Device Name:   %255s Enter the Poll Rate in Seconds[%d]:  %d -p:Pollrate value is out of legal range
 Enter the Inaccuracy[%d(ms)]:  %d -i:Inaccuracy value is out of legal range
 Enter the Timestamp Count[%d]:  %d -t:Time stamp count is out of legal range
 Disallow clock set[%d(Y:1,N:0)] :  %d Output Trace [%d(Y:1,N:0)] :  %d  dtsprovider: cannot delay usage:	dtsprovider -d device-name
  		[-p pollrate, range %d : %d, default %d]
 		[-i milliseconds of inaccuracy, range %d : %d, default %d]
 		[-t timestamps, range %d : %d, default %d]
 		[-c disallow clock set, range 0(false) : 1(true), default %d]
 		[-o output trace, range 0(false) : 1(true), default %d]
     M_GC1000: QIO Status failure %x
  M_GC1000: IOSB Status failure %x
 M_GC1000: response length failure %x
 M_GC1000: time/date string format invalid
  M_GC1000: time/date field format invalid
 %d:%d:%d.%d %d/%d/%d M_GC1000: time/date field conversion failed
 K_TPI_FAILURE
    ******************************************
 K_TPI_SUCCESS
  Time Stamps   : %d
 Before Time	:   
TP Time		: 
After Time	: 

    ******************************************
 %s	 
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
  The external time did not validate
 Synchronization Count: %u
 Error Tolerance:       %u
 System Time:           %s
 External Device Time:  %s
 
!!!!!!!!!!!!!!!!!!
                                                                                                                                                                                                                                                                                                                                                x                                 <        *   <   R   g                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.               ^VtW\Џ   (ȭ>mPSRSRR	ST   |g߭P2RBUT  P Og߭PV2RB T  Pfff5 T  RbS  S  RbS  S   g߭P2RBS  P% g߭P2RB{S  P8 g߭P2RBFS  P `g߭P"2RBS  PP dg߭P2RBR  PB g߭P2RB	R  ^_R  Z[_Sn-RBTkPDQU"VWXY<bd`aefg<hi 7Ѭ1 pQ  P1 ØQ  P`Q  Rbx~<~üQ  P`b<'~
Q  P`b&Q  P`b TQ  P`b ÕQ  P`b B  Ѭ
ݬݬ  )WQ  P`"Q  Td@:Q  P`dkP(Q  P`dpQ  P`dÐP  P`døP  P`dBRRRP  P`dK	RPRRP  P`d|ԪԪQkPЏ`  R
RP
Q{RPQPQQkPЏ`  RRRPRQPQP{RPPQQkQkPЏ  R
RP
Q{RPQPQjQkPЏ  RRRPRQPQ{RPPQQkŏ@B kL|~PP'"R LN  RO   @N  DO  DM  Dc`M  DF4HDM   M  HI@KO  P`O   M  !O  D`M  DF0ͨD[M   M  ͨwnN  P`N   uM  N  D<L  DF,D M   9M  ëâN  P`aN   M  mN  1	 L  D<L  DF(hDL   L  h*N  P`M   L   N  R<1 M  TPD$<PBL  D9 DL   TL  M  P`d 9L  D$ M  P`dD$K  RR<1t K  D <1K  DF(DK   K  (4*M  P`L   K  L  D<#K  @8 6K  @F͈@K   RK  ͈bXL  P`zL   3K  L  D|~8J  DFDJ   J  ÊÀQL  P`L   J  'L  R>" J  èL  P`K   J  DR5J  DFHD4J   mJ  HK  P`K   NJ  K  nn  P  (^ݬݬJ  P%蟭I  P蟭I  P	 MK  Q$ѭQQP ^
R6" I  K  P`J   I  ЬP`    ^S" QI  J  P`J   :I  ЬRpRZ`M  Pbb" H  97J  R   H     ^M[XYRUެW                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          v/1 $      DCEVAXMUPA013.A                :  ;  7[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_GC1000.EXE;3                                                                             8                         m "            Ug1I  TI  VI  ZP޼PE`P`PP-1 I  P`dx~<~¼I  P`d<'~
I  P`d&I  P`d TI  P`d uI  P`df1%P޼PE`P~!I  Pc   myyyyyyyyy1 yyyQ1RP"?PUUg1 I  P`dx~<~¼H  P`d<'~
H  P`d&H  P`d TH  P`d H  P`dfkJ޼PE`jP11MiH  P`dYH  P`dx~<~¼>H  P`d<'~
%H  P`d&H  P`d TG  P`d G  P`df1UUg1 G  P`dx~<~¼G  P`d<'~
G  P`d&~G  P`d TlG  P`d ZG  P`dft޼PE`jP1w)G  P`dG  P`dx~<~¼F  P`d<'~
F  P`d&F  P`d TF  P`d F  P`df1[UUg1 F  P`dx~<~¼mF  P`d<'~
TF  P`d&>F  P`d T,F  P`d F  P`dfh ޼PE`jPhh  1£E  P`dE  P`dx~<~¼E  P`d<'~
E  P`d&E  P`d TsE  P`d aE  P`df1PUUg1 <E  P`dx~<~¼!E  P`d<'~
E  P`d&D  P`d TD  P`d D  P`df-޼PE`jP
'  1OD  P`dwD  P`dx~<~¼\D  P`d<'~
CD  P`d&-D  P`d TD  P`d 	D  P`df1PUUg1 C  P`dx~<~¼C  P`d<'~
C  P`d&C  P`d TC  P`d vC  P`df9޼PE`jP 13C  P`B  C  P`dx~<~¼C  P`d<'~
B  P`d&B  P`d TB  P`d B  P`df1aPUU1 B  P`VB  Scx~<~¼iB  P`c<'~
PB  P`c&:B  P`c T(B  P`c B  P`cA  ޼PE`ZA  MݩA  =A  Pi1 A  P`A  Scx~<~¼A  P`c<'~
A  P`c&uA  P`c TcA  P`c QA  P`c2A  UUg18P< ^TSUR(@  @  \l< ~@  GD@  cJ@  @  \l< ~@  co}@  c	c  r@  \lS@  f@  dA@  _@  \l< ~0@  dº@  d
	d'  ½'@  \l?  @  e?  ?  \l< ~?  e?  ee?  \l?  ?  d6}?  ?  \l< ~l?  :YS?  \>?  \?  \ݬ < ~,?  Vz?   ^	SЬԭ=  P"~R =  R>   =  PPP  ^ p=   >   b=   ^R>  \l>  Scx~<~¼>  \lc<'~
{>  \lc&e>  \lc TS>  \lc A>  \l  ^YZRnVլ1ެ[Ы U=  Ww<   0VP@(0VP@0VP@ݬ  PXP1kQ0VP@(T0VP@SST"<  P%؟	<  P؟蟭;  P	 h=  QiѭjQQXX1 kQ0VP@(S0VP@T	8=  P`g	(=  P`gi	=  P`gj
=  P`gS2.
<  P`gT2I
<  P`gd
<  P`gXVPnPnPPPV1P  ^|~GaPP\\PP  ^<~PQQP  <Լ< $  ,^Sݬr:  ;  P |~<~ݬ  PRݬ5:  RR;  P`;  RT1P<QQQ;  P`k;  <T1<PPP{;  P`E;  T1PP?T1PPP?T1PPP:$PP:PP.PP/	PP/>;  P`:  T1:P;  RPʏ P@bPP1 Pʏ P@bPP1 Pʏ P@bPP1 Pʏ P@bPP1 Pʏ P@bPP1 Pʏ P@bPP1 Pʏ P@bPPrPʏ P@bPP_Pʏ P@bPPLPʏ P@bPP9Pʏ P@bPP&Pʏ P@bPPPʏ P@bPPj9  P`9  Tݬ   PTTP< D^Sğ߭߭Ôݬ	s9  Pé9  P`N9  U1ŏd   Pŏ@B P׭|ԭQPЏ  RRPQP{RPQPQ||QPЏ  RRRPRQPQ{RPPQŏ@B QTTݭԟJ7  PUuP|lhԭ|t||Џ 6nT|HD\|PX|`RRDTh6  PUP؟ݬ6  PUUUP d^3Rռ8  8  P	8  ެWgSݣ$	7  Uգ1 7  TЧ Su6  V8	d0UP@2fʟ	dH	d0UP@2f	dT	d0UP@(2fff	db	dUUh	Q7   8^MRݬ25  ʟ	  %7   8^!R	67  P`7  Sc	7  P`c		7  P`c
6  P`cݬ2Z5  ʟ.
6  P`cݬ285  ʟI
6  P`cd
6  P`c ^ 5  ݬ26  PR 5  RP ^ 4  ݬ6  PR 4  RP ^ 4  ݬ5  PR 4  RP ^ 4  ݬ~5  PR 4  RP ^ 4  ݬݬ5  PR q4  RP ^ \4  ݬN5  PR L4  RP ^ 84  ݬݬݬ5  PR "4  RPP ^ 4  ݬݬ4  PR 3  RP ^ 3  ެPPSSݬݬ4  PRS 3  RP ^ 3  ݬݬ4  PR 3  RP ^ 3  ݬݬ4  PR u3  RP ^ `3  ݬݬݬݬa4  PR G3  RPP ^ 03  ݬݬݬ4  PR 3  RPP ^ 3  ݬݬݬ4  PR 2  RPP ^ 2  ݬ3  PR 2  RP ^ 2  ݬݬݬݬ3  PR 2  RPP ^ 2  ݬ3  PR t2  RP ^ `2  ݬ3  PR P2  RP ^ <2  ݬn3  PR ,2  RP ^ 2  ެPPSSݬ2  PRS 1  RP ^ 1  ݬ2  PR 1  RP ^ 1  ݬݬ2  PR 1  RP  ^ 1  ݬ2   1  P  ^ |1  ݬݬS2   l1  P ^ X1  ެPPSSݬݬ92  PRS 91  RP ^ $1   1  PR 1  R\\P ^  1  ݬ1  PR 0  RP ^ 0  ݬ2  PR 0  RP ^ 0  ݬ~1  PR 0  RP ^ 0  ެPPSSݬݬi1  PRS q0  RP ^ \0  ެPPSSݬ<1  PRS @0  RP ^ ,0  ެPPSSݬݬ
1  PRS 
0  RP                                                                                                                                                                                                                                                                                                                                                                       e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P        ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSy                                                                                                                                                                                                                                                                           U^ $      DCEVAXMUPA013.A                :  ;  7[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_GC1000.EXE;3                                                                             8                          "     !       nchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (        TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP/IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock Adjustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTSUPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *                                                                                                                                                                                                                                                                                Æ7 $      DCEVAXMUPA013.A                :  ;  7[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_GC1000.EXE;3                                                                             8                          
     2          CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                     @   @       ,  8                                             p   x                H              x   @         `      8      3          (    x           
      X
  P
  H
  @
  8
  0
  (
   
  
  
  
   
                                  x  p  h  `  X  P  H  @  8  0  (       +   
               (       @        p          X  0  P    8  @  `  P  X          x       0    x      (  h            ,           b   
                 @                                                                       DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        DECC$SHR                                                                                                                                                                                                                                                                                                                    5 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_HOPF.EXE;3 +  , l7   . 8    /  @   4     8   7                     - ;    0   1    2   3      K  P   W   O 9    5   6 H  7 
n   8          9          G  @  H   J                           0 D `     0205        NG~     d                                                DCE$DTS_PROVIDER_HOPF                  DCE V1.3-950305NG 05-13                             
               2   
  4     ?   $ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001!      !         DECC$SHR_001  X    DCE$DTS_TSTP_MBX DCE$DTS_TPTS_MBX DCE$DTS_TP_DEVICE DCE$DTS_TP_INACCURACY DCE$DTS_TP_POLL_RATE DCE$DTS_TP_TIME_STAMPS   DCE$DTS_TP_MAXERROR DCE$DTS_TP_FIRSTSYNC DCE$DTS_TP_VERBOSE DCE$DTS_PROVIDER  LNM$PROCESS_TABLE     The time stamp value is out of legal range
 Legal Range is %d to %d
 PARAMETERS SET:
       TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TRUE  FALSE TP_VERBOSE:         %s


 TRUE  FALSE dtsprovider: init radio clock %s - %s
 Unable to register interface for TPP %s - %s
 TPP unable to register protocol sequences  %s - %s
 Can't inquire bindings %s - %s
 Can't inquire bindings %s - %s
 Can't bind to string Got binding: %s
 Spectracom Time Provider %s - %s
  Can't register with endpoint mapper %s - %s
  Can't get machine's host name %s - %s
  Can't register authentication Listening for connections ...
 %s - %s
 RPC listen terminated abnormally Executing ContactProvider ...
 Executing ServerRequestProviderTime ...
 Reply written :
 %d -o:Output value is out of legal range
 %d -c:Clockset value is out of legal range
 %d -p:Pollrate value is out of legal range
 %d -i:Inaccuracy value is out of legal range
 %d -t:Time stamp count is out of legal range
 


Enter the Device Name:   %255s Enter the Poll Rate in Seconds[%d]:  %d -p:Pollrate value is out of legal range
 Enter the Inaccuracy[%d(ms)]:  %d -i:Inaccuracy value is out of legal range
 Enter the Timestamp Count[%d]:  %d -t:Time stamp count is out of legal range
 Disallow clock set[%d(Y:1,N:0)] :  %d Output Trace [%d(Y:1,N:0)] :  %d  dtsprovider: cannot delay usage:	dtsprovider -d device-name
  		[-p pollrate, range %d : %d, default %d]
 		[-i milliseconds of inaccuracy, range %d : %d, default %d]
 		[-t timestamps, range %d : %d, default %d]
 		[-c disallow clock set, range 0(false) : 1(true), default %d]
 		[-o output trace, range 0(false) : 1(true), default %d]
 g02 g02 M_HOPF: QIO Status failure %x
  M_HOPF: IOSB Status failure %x
 M_HOPF: Missing STX %s
 M_HOPF: string length failure %x
   M_HOPF: response length failure %x
 M_HOPF: radio time not Available %x
 M_HOPF: no internal clock time %x
 M_HOPF: no UTC time %x
 K_TPI_FAILURE
  ******************************************
 K_TPI_SUCCESS
  Time Stamps   : %d
 Before Time	:   
TP Time		: 
After Time	: 

    ******************************************
 %s	 
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
  The external time did not validate
 Synchronization Count: %u
 Error Tolerance:       %u
 System Time:           %s
 External Device Time:  %s
 
!!!!!!!!!!!!!!!!!!
                                                                                                                                                                                                                                                                                                                                                x                                 <        *   <   R   g                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.                                                                                                      ^?VW=\Џ   (W>PSRSRR	ST   g߭P2RBS  P g߭PV2RBS  Pfff5 S  RbfS  S  RbNS  aS   ^g߭P2RB7S  P 1g߭P2RBS  P g߭P2RBR  P g߭P"2RBR  P=P g߭P2RB\R  P Bg߭P2RBR  ^Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            u $      DCEVAXMUPA013.A                l7  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_HOPF.EXE;3                                                                               8                         5 "            Z[SnRTkPQUVGWXiY<bd`aefg<hi 7Ѭ1  }Q  P1 ØQ  P`KQ  Rbx~<~ü^Q  P`b<'~
EQ  P`b&/Q  P`b TQ  P`b ÕQ  P`b B  Ѭ
ݬݬ  )P  P`P  Td4@P  P`dkPP  P`ddpP  P`djÐP  P`d0ønP  P`dRRRGP  P`d	RPRRP  P`d|ԪԪQkPЏ`  R
RP
Q{RPQPQQkPЏ`  RRRPRQPQP{RPPQQkQkPЏ  R
RP
Q{RPQPQjQkPЏ  RRRPRQPQ{RPPQQkŏ@B k|~0JPP'"R M  RO   M  DO  DKM  DcMM  DF4HDDM   uM  HI@N  P`N   VM  N  DL  DF0ͨDL   M  ͨwnzN  P`DN   L  PN  D<L  DF,DL   L  ëâN  P`M   L  M  1	 L  D< L  DF(hD#L   TL  hM  P`|M   5L  M  R<1 [M  TPD$<PBK  D9 DK   K  :M  P`d K  D$ M  P`dD$XK  RR<1t K  D <&K  DF(DK   FK  (4*L  P`nL   'K  zL  D<J  @8 J  @F͈@J   J  ͈bX8L  P`L   J  L  D|~8WJ  DFDJJ   {J  ÊÀK  P`K   \J  K  R" =J  èK  P`mK   &J  DRI  DFHDI   I  HSK  P`K   I  )K  nn  P  (^ݬݬI  P%蟭zI  P蟭^I  P	 J  QCѭQQP ^R" 5I  J  P`eJ   I  ЬP`=])    ^ASj" H  ?J  P`	J   H  ЬR RM  Pbb" H  9I  Rz   kH     ^[~XYRUެWUg1nI  TI  VhI  ZP޼PE`P`PP-1 kI  P`dx~<~¼PI  P`d<'~
7I  P`d&!I  P`d TI  P`d H  P`df1%P޼PE`P~H  Pc   myyyyyyyyy1 yyyQ1RP?PUUg1 H  P`dx~<~¼qH  P`d<'~
XH  P`d&BH  P`d T0H  P`d H  P`dfkJ޼PE`jP11MG  P`dG  P`dx~<~¼G  P`d<'~
G  P`d&G  P`d TG  P`d sG  P`df1UUg1 PG  P`dx~<~¼5G  P`d<'~
G  P`d&G  P`d TF  P`d F  P`dft޼PE`jP1wF  P`dF  P`dx~<~¼F  P`d<'~
mF  P`d&WF  P`d TEF  P`d 3F  P`df1[UUg1 F  P`dx~<~¼E  P`d<'~
E  P`d&E  P`d TE  P`d E  P`dfh ޼PE`jPhh  1£gE  P`dWE  P`dx~<~¼<E  P`d<'~
#E  P`d&
E  P`d TD  P`d D  P`df1PUUg1 D  P`dx~<~¼D  P`d<'~
D  P`d&zD  P`d ThD  P`d VD  P`df޼PE`jP
'  1OD  P`dC  P`dx~<~¼C  P`d<'~
C  P`d&C  P`d TC  P`d C  P`df1PUUg1 lC  P`dx~<~¼QC  P`d<'~
8C  P`d&"C  P`d TC  P`d B  P`df޼PE`jP1B  P`B  B  P`dx~<~¼B  P`d<'~
sB  P`d&]B  P`d TKB  P`d 9B  P`df1aPUU1 B  P`A  Scx~<~¼A  P`c<'~
A  P`c&A  P`c TA  P`c A  P`cA  ޼PE`cA  ݩSA  JA  Pi1 NA  P`A  Scx~<~¼,A  P`c<'~
A  P`c&@  P`c T@  P`c @  P`c@  UUg18P< ^'ThS}UR(f@  @  \l< ~U@  D<@  cJ+@  I@  \l< ~@  co@  c	c  r@  \l?  ?  d?  ?  \l< ~?  dº?  d
	d'  ½?  \ly?  ?  eg?  ?  \l< ~V?  eA?  eeQ?  \l?  .?  6?  #?  \l< ~>  Y>  \>  >  \ݬ < ~>  z>   ^SЬԭ6=  P"~R =  Ri>   =  PPP  ^ <   A>   <   ^1R>>  \l	>  Scx~<~¼>  \lc<'~
>  \lc&=  \lc T=  \lc =  \l  ^YeZRnVլ1ެ[Ы U^=  W;   0VP@(0VP@0VP@ݬ  PXP1kQ0VP@(T0VP@SST;  P%؟;  P؟蟭y;  P	 <  QibѭjQQXX1 kQ0VP@(S0VP@T	<  P`g	<  P`gi	<  P`gj
<  P`gS2.
n<  P`gT2I
P<  P`gd
@<  P`gXVPnPnPPPV1P  ^|~PP\\PP  ^<~PQQP  <Լ< $ | 0^S}|~ |~<~ЬUU ޟ Tdݬ9  N;  |~|~P|~0U dPR|~|~𚏱~U dPRݬ9  RR;  P`:  RT1{P<RRR:  P`:  <T1TPPP:  P`:  T10Q<RQRAPP
QVQQRVV0:  P`M:  T1 P0PRP9P
PRRטP0PRP9P
PRR<PPPT':  P`9  T1 RRRx:  P`9  TrPRRRÝ9  P`9  TNPRRR9  P`9  T*PP@Q0QQ@PPݬ   PTTPH^ЬST
TRTRtT
TRTRpT
TRTRl	T
T
RTRxT
TRTR||
T
TRTRRˏRRˏRЭX|WxZV(h 䭐Yz  XP{PQPPz  XP{d   PQPP,  XRz  RP{  PQPPYYTSW4TRBRCbfSSWZfQPЏ  RRPQP{RPQPQH|L|dQPЏ  RRRPRQPQP{RPPQŏ@B QUXUHXlݬg6  PRPRRP| ^(h ⭘Vz  P{PQPPz  P{d   PQPP,  Rz  RP{  PQPPVVPSެUSeЬT4PRBRCbdSSe   d^?Rռ7  7  P	7  ެWgSݣ$	6  Uգ1 6  TЧ Sy5  V8	d0UP@2fʟ	dH	d0UP@2f	dT	d0UP@(2fff	db	dUUh	U6   8^YRݬ24  ʟ	  )6   8^-R	:6  P`6  Sc	#6  P`c	
6  P`c
5  P`cݬ2^4  ʟ.
5  P`cݬ2<4  ʟI
5  P`cd
5  P`c ^ 4  ݬ65  PR 4  RP ^ 3  ݬ5  PR 3  RP ^ 3  ݬ4  PR 3  RP ^ 3  ݬ4  PR 3  RP ^ 3  ݬݬ4  PR u3  RP ^ `3  ݬR4  PR P3  RP ^ <3  ݬݬݬ4  PR &3  RPP ^ 3  ݬݬ3  PR 2  RP ^ 2  ެPPSSݬݬ3  PRS 2  RP ^ 2  ݬݬ3  PR 2  RP ^ 2  ݬݬ3  PR y2  RP ^ d2  ݬݬݬݬe3  PR K2  RPP ^ 42  ݬݬݬ3  PR 2  RPP ^ 2  ݬݬݬ3  PR 1  RPP ^ 1  ݬ2  PR 1  RP ^ 1  ݬݬݬݬ2  PR 1  RPP ^ 1  ݬ2  PR x1  RP ^ d1  ݬ2  PR T1  RP ^ @1  ݬr2  PR 01  RP ^ 1  ެPPSSݬ1  PRS  1  RP ^ 0  ݬ1  PR 0  RP ^ 0  ݬݬ1  PR 0  RP  ^ 0  ݬ1   0  P  ^ 0  ݬݬW1   p0  P ^ \0  ެPPSSݬݬ=1  PRS =0  RP ^ (0   0  PR 0  R\\P ^ 0  ݬ0  PR /  RP ^ /  ݬ1  PR /  RP ^ /  ݬ~0  PR /  RP ^ /  ެPPSSݬݬm0  PRS u/  RP ^ `/  ެPPSSݬ@0  PRS D/  RP ^ 0/  ެPPSSݬݬ0  PRS /  RP                                                                                                                                                                                                                                                                                                                                                                                    V?B $      DCEVAXMUPA013.A                l7  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_HOPF.EXE;3                                                                               8                         9 "                      e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P        ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSynchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (        TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP/IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock Adjustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTS                                                                                                                                                                                                                                                                           K= $      DCEVAXMUPA013.A                l7  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_HOPF.EXE;3                                                                               8                               .       UPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *        CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                     @   @       $  0                                             p   x                H              x   @      `  8      3          (    x           
      X
  P
  H
  @
  8
  0
  (
   
  
  
  
   
                                  x  p  h  `  X  P  H  @  8  0  (       +   
               (       @        p          X  0  P    8  @  `  P  X          x       0    x      (  h            ,           b   
                 @                                                                       DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        DECC$SHR                                                                                                                                                                                                                                                                                                                            5 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_NULL.EXE;3 +  , y3   . 4    /  @   4     4   4                     - ;    0   1    2   3      K  P   W   O 5    5   6 .O  7 u   8          9          G  @  H   J                           0 D `     0205        N~     ^                                                DCE$DTS_PROVIDER_NULL                  DCE V1.3-950305nN 05-13                             	               /   
  1     ?   $ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001!      !         DECC$SHR_001      DCE$DTS_TSTP_MBX DCE$DTS_TPTS_MBX DCE$DTS_TP_DEVICE DCE$DTS_TP_INACCURACY DCE$DTS_TP_POLL_RATE DCE$DTS_TP_TIME_STAMPS   DCE$DTS_TP_MAXERROR DCE$DTS_TP_FIRSTSYNC DCE$DTS_TP_VERBOSE DCE$DTS_PROVIDER  LNM$PROCESS_TABLE     The time stamp value is out of legal range
 Legal Range is %d to %d
 PARAMETERS SET:
       TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TRUE  FALSE TP_VERBOSE:         %s


 TRUE  FALSE dtsprovider: init radio clock %s - %s
 Unable to register interface for TPP %s - %s
 TPP unable to register protocol sequences  %s - %s
 Can't inquire bindings %s - %s
 Can't inquire bindings %s - %s
 Can't bind to string Got binding: %s
 Spectracom Time Provider %s - %s
  Can't register with endpoint mapper %s - %s
  Can't get machine's host name %s - %s
  Can't register authentication Listening for connections ...
 %s - %s
 RPC listen terminated abnormally Executing ContactProvider ...
 Executing ServerRequestProviderTime ...
 Reply written :
 %d -o:Output value is out of legal range
 %d -c:Clockset value is out of legal range
 %d -p:Pollrate value is out of legal range
 %d -i:Inaccuracy value is out of legal range
 %d -t:Time stamp count is out of legal range
 


Enter the Device Name:   %255s Enter the Poll Rate in Seconds[%d]:  %d -p:Pollrate value is out of legal range
 Enter the Inaccuracy[%d(ms)]:  %d -i:Inaccuracy value is out of legal range
 Enter the Timestamp Count[%d]:  %d -t:Time stamp count is out of legal range
 Disallow clock set[%d(Y:1,N:0)] :  %d Output Trace [%d(Y:1,N:0)] :  %d  dtsprovider: cannot delay usage:	dtsprovider -d device-name
  		[-p pollrate, range %d : %d, default %d]
 		[-i milliseconds of inaccuracy, range %d : %d, default %d]
 		[-t timestamps, range %d : %d, default %d]
 		[-c disallow clock set, range 0(false) : 1(true), default %d]
 		[-o output trace, range 0(false) : 1(true), default %d]
 K_TPI_FAILURE
  ******************************************
 K_TPI_SUCCESS
  Time Stamps   : %d
 Before Time	:   
TP Time		: 
After Time	: 

    ******************************************
 %s	 
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
  The external time did not validate
 Synchronization Count: %u
 Error Tolerance:       %u
 System Time:           %s
 External Device Time:  %s
 
!!!!!!!!!!!!!!!!!!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Ci $      DCEVAXMUPA013.A                y3  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_NULL.EXE;3                                                                               4                         G "                                                                                                                                                                                                            x                                 <        *   <   R   g                                                                                                                                                                                                                   Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.               ^VlW\Џ   (ȭ>ePSRSRR	S{P   tg߭P2RBQP  P
 Gg߭PV2RBP  Pfff5 P  RbO  O  RbO  O   g߭P2RBO  P g߭P2RBwO  P0 g߭P2RBBO  P Xg߭P"2RB
O  PP \g߭P2RBN  P: g߭P2RBN  ^[N  Z[_Sn%R:TkP<Q	UVWXY<bd`aefg<hi 6Ѭ1 gM  P1 ØM  P`M  Rbx~<~üM  P`b<'~
M  P`b&M  P`b TM  P`b Õ~M  P`b   PѬ
ݬݬ  )OM  P`M  Td@2M  P`dkP M  P`dp
M  P`dÐL  P`døL  P`d6RRRL  P`d?	RPRRL  P`d|ԪԪQkPЏ`  R
RP
Q{RPQPQQkPЏ`  RRRPRQPQP{RPPQQkQkPЏ  R
RP
Q{RPQPQjQkPЏ  RRRPRQPQ{RPPQQkŏ@B k@DI  DcI  DF4HDI   $J  HI@K  P`LK   J  XK  DI  DF0ͨDI   I  ͨwn)K  P`J   I  J  D<8I  DF,D;I   pI  ëâJ  P`J   QI  J  1 2I  D<H  DF(hDH   I  haJ  P`+J   H  7J  R<1 
J  TD$<PBLH  D9 DWH   H  I  P`d qH  D$ I  P`dD$H  RR<1t 5H  D <eG  DF(DG   G  (4*TI  P`I   G  *I  D<_G  @8 rG  @F͈@UG   G  ͈bXH  P`H   kG  H  D|~8G  DFDF   +G  ÊÀH  P`SH   G  _H  Rr" F  èSH  P`H   F  DRqF  DFHDpF   F  HH  P`G   F  G  nn  P  (^ݬݬ?F  P%蟭*F  P蟭
F  P	 G  QXѭ%QQP ^IRj" E  KG  P`G   E  ЬP`    ^S" E  F  P`F   rE  ЬRRM  Pbb" 2E  9oF  Rj   E     ^["XKYDRUެWUg1F  T3F  VF  ZP޼PE`P`PP-1 F  P`dx~<~¼ F  P`d<'~
E  P`d&E  P`d TE  P`d E  P`df1%P޼PE`P~YE  Pc   myyyyyyyyy1 yyyQ1RP^?PUUg1 <E  P`dx~<~¼!E  P`d<'~
E  P`d&D  P`d TD  P`d D  P`dfkJ޼PE`jP11MD  P`dD  P`dx~<~¼vD  P`d<'~
]D  P`d&GD  P`d T5D  P`d #D  P`df1UUg1  D  P`dx~<~¼C  P`d<'~
C  P`d&C  P`d TC  P`d C  P`df1t޼PE`jP1waC  P`dQC  P`dx~<~¼6C  P`d<'~
C  P`d&C  P`d TB  P`d B  P`df1[UUg1 B  P`dx~<~¼B  P`d<'~
B  P`d&vB  P`d TdB  P`d RB  P`dfh ޼PE`jPhh  1£B  P`dB  P`dx~<~¼A  P`d<'~
A  P`d&A  P`d TA  P`d A  P`df1PUUg1 tA  P`dx~<~¼YA  P`d<'~
@A  P`d&*A  P`d TA  P`d A  P`dfa޼PE`jPH
?'  1O@  P`d@  P`dx~<~¼@  P`d<'~
{@  P`d&e@  P`d TS@  P`d A@  P`df1PUUg1 @  P`dx~<~¼@  P`d<'~
?  P`d&?  P`d T?  P`d ?  P`dfm޼PE`jPTK1k?  P`5?  W?  P`dx~<~¼<?  P`d<'~
#?  P`d&
?  P`d T>  P`d >  P`df1aPUU1 >  P`>  Scx~<~¼>  P`c<'~
>  P`c&r>  P`c T`>  P`c N>  P`c/>  ޼PE`>  ݩ>  q=  Pi1 =  P`=  Scx~<~¼=  P`c<'~
=  P`c&=  P`c T=  P`c =  P`cj=  UUg18P< ^TS!U.R(=  4=  \l< ~=  {D<  cJ<  <  \l< ~<  co<  c	c  r<  \l<  <  dy<  <  \l< ~h<  dºS<  d
	d'  ½_<  \l)<  <<  e<  5<  \l< ~<  e;  ee<  \l;  ;  6;  ;  \l< ~;  nY;  \v;  ;  \ݬ < ~d;  zI;   ^ESЬԭ9  P"~R 9  R;   9  PPP  ^ 9   :   9   ^R:  \l:  Scx~<~¼:  \lc<'~
:  \lc&:  \lc T:  \lc y:  \l  ^[@SXլ1.ެоU8  
:  Y8   0XP@W0XP@T0XP@(ZQkPЏ  RRPQP{RPQPQl|p|QkPЏ  RRRPRQPQP{RPPQŏ@B QVTdh 8  Vl W7  ZnVV11оQ0XP@(T0XP@RRT7  P%؟7  P؟蟭7  P	 
9  RoѭRRVV1 оQ0XP@(T0XP@WÐ8  P`i8  P`i8  P`iN	8  P`iT222&	x8  P`iW222A	X8  P`i\	H8  P`iVXPЮP׮PRX1RRP  \\PP  ^<~PQQP  << $  ^Q*PЏ  RRPQP{RPQPQ||QPЏ  RRRPRQPQ{RPPQŏ@B QSݬ5  ߭߭ 5  S ݬ5  ݬ5   d^Rռ6  6  P6  ެWgSݣ6  Uգ1 6  TЧ S95  V0d0UP@2fʟd@d0UP@2fdLd0UP@(2fffdZdUU`6   8^Rݬ24  ʟ  5   8^R5  P`5  Sc5  P`c5  P`cm	5  P`cݬ24  ʟ&	5  P`cݬ23  ʟA	s5  P`c\	c5  P`c ^ 3  ݬ4  PR 3  RP ^ 3  ݬ4  PR 3  RP ^ 3  ݬb4  PR 3  RP ^ l3  ݬB4  PR \3  RP ^ H3  ݬݬk4  PR 53  RP ^  3  ݬ4  PR 3  RP ^ 2  ݬݬݬD4  PR 2  RPP ^ 2  ݬݬ3  PR 2  RP ^ 2  ެPPSSݬݬ3  PRS 2  RP ^ t2  ݬݬg3  PR a2  RP ^ L2  ݬݬC3  PR 92  RP ^ $2  ݬݬݬݬ%3  PR 2  RPP ^ 1  ݬݬݬ2  PR 1  RPP ^ 1  ݬݬݬ2  PR 1  RPP ^ 1  ݬ2  PR 1  RP ^ x1  ݬݬݬݬ}2  PR _1  RPP ^ H1  ݬF2  PR 81  RP ^ $1  ݬN2  PR 1  RP ^  1  ݬ22  PR 0  RP ^ 0  ެPPSSݬ1  PRS 0  RP ^ 0  ݬ1                                                                                                                                                                                                                                                                            $      DCEVAXMUPA013.A                y3  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_NULL.EXE;3                                                                               4                         	 "              PR 0  RP ^ 0  ݬݬ1  PR u0  RP  ^ `0  ݬz1   S0  P  ^ @0  ݬݬ1   00  P ^ 0  ެPPSSݬݬ0  PRS /  RP ^ /   0  PR /  R\\P ^ /  ݬ0  PR /  RP ^ /  ݬ0  PR /  RP ^ |/  ݬ~~0  PR h/  RP ^ T/  ެPPSSݬݬ-0  PRS 5/  RP ^  /  ެPPSSݬ 0  PRS /  RP ^ .  ެPPSSݬݬ/  PRS .  RP                                               e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P        ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSynchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (        TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP/IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock Adjustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B                                                                                                                                                                                                                                                                                  9N $      DCEVAXMUPA013.A                y3  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_NULL.EXE;3                                                                               4                               *        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTSUPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *        CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                     @   @       (  4                                             p   x                H              x   @         `  8      3          (    x           
      X
  P
  H
  @
  8
  0
  (
   
  
  
  
   
                                  x  p  h  `  X  P  H  @  8  0  (       +   
               (       @        p          X  0  P    8  @  `  P  X          x       0    x      (  h            ,           \   
                 @                                                                       DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        DECC$SHR                                                                                                                                                                                                                                                                                                                        5 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_PSTI.EXE;3 +  , 4   . 8    /  @   4     8   7                     - ;    0   1    2   3      K  P   W   O 9    5   6 (  7 Bz   8          9          G  @  H   J                           0 D `     0205        &~     d                                                DCE$DTS_PROVIDER_PSTI                  DCE V1.3-950305& 05-13                             
               2   
  4     ?   $ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001!      !         DECC$SHR_001  X    DCE$DTS_TSTP_MBX DCE$DTS_TPTS_MBX DCE$DTS_TP_DEVICE DCE$DTS_TP_INACCURACY DCE$DTS_TP_POLL_RATE DCE$DTS_TP_TIME_STAMPS   DCE$DTS_TP_MAXERROR DCE$DTS_TP_FIRSTSYNC DCE$DTS_TP_VERBOSE DCE$DTS_PROVIDER  LNM$PROCESS_TABLE     The time stamp value is out of legal range
 Legal Range is %d to %d
 PARAMETERS SET:
       TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TRUE  FALSE TP_VERBOSE:         %s


 TRUE  FALSE dtsprovider: init radio clock %s - %s
 Unable to register interface for TPP %s - %s
 TPP unable to register protocol sequences  %s - %s
 Can't inquire bindings %s - %s
 Can't inquire bindings %s - %s
 Can't bind to string Got binding: %s
 Spectracom Time Provider %s - %s
  Can't register with endpoint mapper %s - %s
  Can't get machine's host name %s - %s
  Can't register authentication Listening for connections ...
 %s - %s
 RPC listen terminated abnormally Executing ContactProvider ...
 Executing ServerRequestProviderTime ...
 Reply written :
 %d -o:Output value is out of legal range
 %d -c:Clockset value is out of legal range
 %d -p:Pollrate value is out of legal range
 %d -i:Inaccuracy value is out of legal range
 %d -t:Time stamp count is out of legal range
 


Enter the Device Name:   %255s Enter the Poll Rate in Seconds[%d]:  %d -p:Pollrate value is out of legal range
 Enter the Inaccuracy[%d(ms)]:  %d -i:Inaccuracy value is out of legal range
 Enter the Timestamp Count[%d]:  %d -t:Time stamp count is out of legal range
 Disallow clock set[%d(Y:1,N:0)] :  %d Output Trace [%d(Y:1,N:0)] :  %d  dtsprovider: cannot delay usage:	dtsprovider -d device-name
  		[-p pollrate, range %d : %d, default %d]
 		[-i milliseconds of inaccuracy, range %d : %d, default %d]
 		[-t timestamps, range %d : %d, default %d]
 		[-c disallow clock set, range 0(false) : 1(true), default %d]
 		[-o output trace, range 0(false) : 1(true), default %d]
 QA0000 QA0000 M_PSTI: QIO Status failure %x
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              HL $      DCEVAXMUPA013.A                4  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_PSTI.EXE;3                                                                               8                          "            M_PSTI: IOSB Status failure %x
 M_PSTI: response length failure %x
 M_PSTI: time not Available %x
 M_PSTI: out of spec detected %x
 M_PSTI: out of spec detected %x
    M_PSTI: hard fault detected %x
 K_TPI_FAILURE
  ******************************************
 K_TPI_SUCCESS
  Time Stamps   : %d
 Before Time	:   
TP Time		: 
After Time	: 

    ******************************************
 %s	 
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
  The external time did not validate
 Synchronization Count: %u
 Error Tolerance:       %u
 System Time:           %s
 External Device Time:  %s
 
!!!!!!!!!!!!!!!!!!
                                                                                                                                                                                                                                                                                                                                                x                                 <        *   <   R   g                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.                                                                                                       ^/VW=\Џ   (W>PSRSRR	ST   g߭P2RBS  P g߭PV2RBS  Pfff5 S  RbfS  S  RbNS  aS   Ng߭P2RB7S  P !g߭P2RBS  P g߭P2RBR  Pz g߭P"2RBR  P-P g߭P2RB\R  P 2g߭P2RBR  ^Q  Zv[SnRTkPQUV7WxXYY<bd`aefg<hi 7Ѭ1 }Q  P1 ØQ  P`KQ  Rbx~<~ü^Q  P`b<'~
EQ  P`b&/Q  P`b TQ  P`b ÕQ  P`b B  Ѭ
ݬݬ  )P  P`P  Td$@P  P`dkPP  P`dTpP  P`dZÐP  P`d ønP  P`dRRRGP  P`d	RPRRP  P`d|ԪԪQkPЏ`  R
RP
Q{RPQPQQkPЏ`  RRRPRQPQP{RPPQQkQkPЏ  R
RP
Q{RPQPQjQkPЏ  RRRPRQPQ{RPPQQkŏ@B k|~ :PP'"R M  RO   M  DO  DKM  DcMM  DF4HDDM   uM  HI@N  P`N   VM  N  DL  DF0ͨDL   M  ͨwnzN  P`DN   L  PN  D<L  DF,DL   L  ëâN  P`M   L  M  1	 L  D< L  DF(hD#L   TL  hM  P`|M   5L  M  R<1 [M  TPD$<PBK  D9 DK   K  :M  P`d K  D$ M  P`dD$XK  RR<1t K  D <&K  DF(DK   FK  (4*L  P`nL   'K  zL  D<J  @8 J  @F͈@J   J  ͈bX8L  P`L   J  L  D|~8WJ  DFDJJ   {J  ÊÀK  P`K   \J  K  R" =J  èK  P`mK   &J  DRI  DFHDI   I  HSK  P`K   I  )K  nn  P  (^ݬݬI  P%蟭zI  P蟭^I  P	 J  Q3ѭqQQP ^R" 5I  J  P`eJ   I  ЬP`-M    ^ASZ" H  ?J  P`	J   H  ЬRRM  Pbb" H  9I  R~   kH     ^[nXYRUެWUg1nI  TI  VhI  ZP޼PE`P`PP-1 kI  P`dx~<~¼PI  P`d<'~
7I  P`d&!I  P`d TI  P`d H  P`df1%P޼PE`P~H  Pc   myyyyyyyyy1 yyyQ1RP?PUUg1 H  P`dx~<~¼qH  P`d<'~
XH  P`d&BH  P`d T0H  P`d H  P`dfkJ޼PE`jP11MG  P`dG  P`dx~<~¼G  P`d<'~
G  P`d&G  P`d TG  P`d sG  P`df1UUg1 PG  P`dx~<~¼5G  P`d<'~
G  P`d&G  P`d TF  P`d F  P`df}t޼PE`jP1wF  P`dF  P`dx~<~¼F  P`d<'~
mF  P`d&WF  P`d TEF  P`d 3F  P`df1[UUg1 F  P`dx~<~¼E  P`d<'~
E  P`d&E  P`d TE  P`d E  P`dfh ޼PE`jPhh  1£gE  P`dWE  P`dx~<~¼<E  P`d<'~
#E  P`d&
E  P`d TD  P`d D  P`df1PUUg1 D  P`dx~<~¼D  P`d<'~
D  P`d&zD  P`d ThD  P`d VD  P`df޼PE`jP
'  1OD  P`dC  P`dx~<~¼C  P`d<'~
C  P`d&C  P`d TC  P`d C  P`df1PUUg1 lC  P`dx~<~¼QC  P`d<'~
8C  P`d&"C  P`d TC  P`d B  P`df޼PE`jP1B  P`B  B  P`dx~<~¼B  P`d<'~
sB  P`d&]B  P`d TKB  P`d 9B  P`df1aPUU1 B  P`A  Scx~<~¼A  P`c<'~
A  P`c&A  P`c TA  P`c A  P`cA  ޼PE`cA  ݩSA  JA  Pi1 NA  P`A  Scx~<~¼,A  P`c<'~
A  P`c&@  P`c T@  P`c @  P`c@  UUg18P< ^TXSmUR(f@  @  \l< ~U@  D<@  cJ+@  I@  \l< ~@  co@  c	c  r@  \l?  ?  d?  ?  \l< ~?  dº?  d
	d'  ½?  \ly?  ?  eg?  ?  \l< ~V?  eA?  eeQ?  \l?  .?  6?  #?  \l< ~>  Y>  \>  >  \ݬ < ~>  z>   ^SЬԭ6=  P"~R =  Ri>   =  PPP  ^ <   A>   <   ^1R>>  \l	>  Scx~<~¼>  \lc<'~
>  \lc&=  \lc T=  \lc =  \l  ^|YUZRnVլ1ެ[Ы U^=  W;   0VP@(0VP@0VP@ݬ  PXP1kQ0VP@(T0VP@SST;  P%؟;  P؟蟭y;  P	 <  QiRѭjQQXX1 kQ0VP@(S0VP@T	<  P`g	<  P`gi	<  P`gj
<  P`gS2
n<  P`gT29
P<  P`gT
@<  P`gXVPnPnPPPV1P  ^|~PP\\PP  ^<~PQQP  <Լ< $  (^R}ݬ9  u;  P
|~<~ݬ  PSݬ9  SSG;  P`;  ST1 P<QQQ !;  P`:  <T1 <PP
P :  P`:  T1 QQQD:  P`:  T~PQQQc:  P`~:  TZPQQQ:  P`Z:  T6PQQQ¨l:  P`6:  TPݬ   PTTP ^ЬQPʏPxPRPʏPxPPxPPP                                                                                                                                                                                                                                                                           ;$%k $      DCEVAXMUPA013.A                                                                   qd?Z[5O.M3                                                                                                        jp	     [       ":w=ɱ:܇@Gn[U%Բ,2QCm!d'[Rfo;xeVŮU pN	":B;B1,j0J|Aӷg#aߚG=MeE
j<K꽐Y1`kR: 6PaTʽ͇`̪p[4Jd	_mG@?׉X@/m4
k<<]iXp'MZaJi@Xρ0qVԹX_ߒQ0)A
^<#^@5fz  {P"n'R@.Je0lӷ)zϡYA͛ XEuj7xG[th
y	Ԓ:(ysߛ0TBkcMOVJyBO
p b[_HfՇ0`ZbvYd7Դu~Dfs&Ǘ"H8]u{9wc,]ktqvct]'3|A,?ʮOOlI웬	Jx՞zf0{sO]F6/dXڢe)QZ-Q7EUB_FD\ږ|Ok|)ꖄ푈o_(i 90Ě_F灉SƏ`)Q10HӰw:fsV7AYGYfO~8L<u=)rW#@aO^bckS-4>(BgoBtVhPmekS̤)F1~!&*$/⻹_C2fV#~:CgaeDβf@pRt1-D!,dxՈe1N	@a#'\yސ#5#X׾ɐj,m2$~K(6bZxy;,,ͣM
*~y@!uW;ڳ[Ϭ=xOjxk2{+x4Y{[	ќE;">+B~8:Y3dNDU}?NdBs`U!	>?kquE&p氄u!6[T0J0f$s
YH?d7p3#x&{s-I{E\k_;1% ͗N߮Tq#\Rk1]{7w9cP)}!<.5j[_ݟHؓJvhQҰY6䌒oYX/+{˵H^GM6&X08	{~eP^&J`xP5E
Bq7fdٸz͘F=F8f"(|Z֍`$DsLCjF{PmfG$gU6=_59onh=3<sndOJsu)Jl;t Юr)VZ#+d=7y5_apnC)0K&0(QVNV=**'~+eʑ¨Ԁ
\(8
|)0z0H-hO^Y{LQa`MU6D'Ďwmq<`.EqGp_U[UB]o(p٣o3}֧?ۨ|t1͵?0	j@3"yfm{Α
^/WA1(QktHR'A{p	(%wɔa
IjÍA56b|FRk8"7tG2,B
&*!^Ncňgwt6lPEVZ؃ eϭOtXL)	'	\1`&K$_n.U$'a3-Ul/@t¸SbXiTjfFߌ>c34b[@hD5տQ|Z4
9V1JFVQHS=n-h8mq.	`&vP1!9'7ULl[RԶ
m^$M+A
.[Ȟ"^59ٻhUhoDMUn=z!*0l:k8o(+0IFOͷZm+ԃ-iwcRHȍRDV\;1Lb_$PhAdZfI* -
(߃$ȍֆaۧ @̞x?PcڇRv~'ѸFtO_VKI2O%	Tj]Z?ǂXF٘ "
"Z~d_FW86}R@Xh$!Nw;d*AMbN>4xZswÃ"6I{aȶ!fS6-o*{L8XwQKՁ!H-'TA4}[OeHE,;vcb9F6dZ>i͂S|Eq>"fXD{qg,5NTϗ`Se9
uFzAdm:CX&5ᥣk}[k?4/@BY.mM1V׸L΋T)fA'E?O|hW|&x`xFܣ<
v,3IpSO) V|Ev(ǝ'vF?[C:.GBȊx}p9p~$+!Ah{)pŽI`Y7TY6w5BzQ˝8MR~-ذ6wkBD+~)f<wwt-+2Fa+yތyᗑ]ٶ!={JͧrᆿR&ACx/|FZ;JNV.AEfYk(J~u3U5d\3h٘|q(]!Vw#m@ߧS|s  vLS sFfS}ĥy9٪@К9Qt#(@O-d06	Ioptfߚ	`N]1H1Hts|_d	q{G:@X쉭T$"RbkƦ]3g]ȩ;Dٛe5lc	˽b
vkZ9FG:$l*|׿GÞK&?UP)ĜϏOH7zg:.NckBSB*Ϛ%y9=O& w%:#?7!^̌0
IK/~UsD+H=~6L^e*l|f`,m]b&V.prumM>'4q왘5TS@עY
b$)ԋ)w PKxmiHq˯ !T,F
K'qh1suEp֢8k:&&ոcг~YtRY{yʹ30xӫcP:'ׄ@< $J|}TC	~D钓dh7N96
q<uT݋h^h5)]/V(@3:J	a+oBׄ]' f?
&u
7'|8
+LGXHݝ&}t,Y2՝Z̧te8:Ovb:,Y.ôDq+ⷯ(H`̮mp:ڃ6vQ
+ݫm=yߔ\OsU!-jJ-GF5!kveҙpФ ī/+(6;r&v!E"@&ar+(	Hyi>i)ذb79kA"Lt;m\cQw
#3Ubl<qߞ!eU0~"0`ny+ႵFlE"N!/FSĄвP%7#~3;ۄiy7Db
TX"GȘˍj+1qԅXg]<'DF:X ҭj4.bFΫTU+_I+nx7p9XxByˆg6:ˈ87k<opO@i	} e3E;=,kC@vQ6InciR9ϧdB*D[G=GH騭@]N\%<fU6lP-sSxbiXLs߆AöZ'r)@0	^Yv^-I/{Ev+Ps1.ؤݝw^'dֺ)# ߗfUڮ5g|.S(AjKT/jmDY&TX)s?0RY
MvNܼˋ?\Shh%u$BS]?y x? "yY^h$Lfd\ꞃQ?|<yrHUI%ob=Ӹ  fIA_G@'Mؿ%/%	K^kd!I[XIlɼPxה	ӉmoIo%&Eɝ11uHËc|@zr9dz{AUn'!":u٧+gDdvXVEy{PY-
/qg/HnE.It˃A?ބ<νӕݹrQ@h6+#LDVAYX1V(t}
s:42;,]pN+ȃ%(3
HC%$`VT"yՆcdHW(85+MKI7
)ӱ\NUn	ۈƌ[9c2:+ZQ;BES!
ְ`&ϬA׋?- Gikf&QaIFdSۀG= hbҧ'&'2lw`5SB|&⺒7DXTgMKw7 F&q׹F3uW k ]
	w-)dX+@c,B+F&V&ax_mk8
Կ8Z6\$*JaU}4e;{gRۖ9RDM'vHMgMthov:}T.cb>RGWi#C#,w<dX=U3ϱ6'M	G?$0M:K(EԢa Q{::f/IyJ#Φn:-N/3u$![M*'c~HJ@PVڰ$po9>l5$B\6ڥH!zN!2MuHZ{ܬߕ(Erq2z$UKt]Wa`4X,×=5]:xˏ.)4E.(㟧P4
ө%Wۦ]9t[_qXyyv`k
	XĻcoKe,-F
;{v(eRG2Jd~2e+ `3b;h3QΊ`׭^*dH|(<}ئ`Uf[r:0XR?9-s6ytYt]=v߅_X 2ŐIxHs8bf,|2ŜOȎv7U.'TJثpPK]OJPȨ$&<UHH`Ս'ys-dIf4U>v@/d)B.@ϯ41*pbV
ՉzC@eTQ+y7
+?
GG@O2ש9rq:W
2hEgKFvNk>x1U̠H>'H1@[5e,upɌ%׿raJ{nWngݝYh֌p `uمjav||RZr^:iJ'pbO/R4+lh99W$Ξ0x7T*":v}dQS]P0P`%Q} 0%rAy.C~WߊO_uN`3
- ??Y/畀!y<>ANl3RRS2_ES_!r6x4[Jo}1qup[iEw;6tCd,У%t;"$NH9[h]ft;,ϛn-7"fs05^aÕ
4{T36D?npF@_3[B!ZG`&)PNT9eӮ0=΋J̾L;2JP%k3VbNFY
/,C^9h"ގ0q
APYv}:ݜ$l
ߤQr	_.U1ظy}ż{;V% ]~OCvUcGlƎ\ɪ rdBbMޫ5L,,~5R(
rab8?T=SP Zzy	>b"K	LSi<Z~4GtN:_@g6k{~esZH琺C"/fJ'	CL@J"AoTȄ9
CbtòӮˌD٤WcۊӂUg^Z aJzMYÉNq8
glj]kScbWRFA(ӯ'{*Z]_b2|l\Ys@	>뻰ICzi;
ޅ \HH+nXRYnǒ ScTI70XoJA6)BIɹ#yLc^A%%+t! òܑ?_L)FeU^sgi8*wf8҉f݋9x _¤gj4(J^΅xNED=GL9	P\`)I鐉;Z/|btט')N8:ʈH\_Lz>縀zf-C>:ˊgYw+AAF2_*?`Gˢ(G|eNsG=4X:ϤiIhY?;[0KLShĕCF^
_m2nM8ǅG5IDg1>d۶QhgK>x8E׵͐!"~	<]:Yr)%+ҞW濬$@HLl:BDTR2m4wbA-Ǘk20#n~?1;-*쒬L QCAH-$3 
gͤNػIJ i-0pOat1ݿk٫IfH cdk&qhZ8ȝV-dؐlҋ6AY麓ϸW~*shJ4DwDy--߃:'b6AEr<ro_Ҕ68w.)B00	o}2U*PRԤ2\wC)}s6߬7#$gM&°[bQVu#6A<ڬ#Ji~Iŗc|PƝ^!*uQ_J*ǲcJ@VO$cIP5yҎ]
7{H|{$~I[v|Ugzр ;z8]hZw)dRXG\9^1)l@u=?S)alXJIEATIۉ44k8+RNRas¦eoX"O7xl.*qX }|Tc[wYI>Ϭkwԑ gy󞹣EV|äuW$!!FD2veg{6nHuO:Xz=I?x/xmwW٢N9Vdo_c?-s48Iy@P*T;S1dei:ӏ7͋O걶fa^ջd(ԬJƜ-l<9`zDmFYYdنh8ױS_(!HЯG#DB)͡bfNKcsZ|8AlQpUpWz
ZWIj+h:ύ!P6e%8<<O;!
@hs2TJ!>$	1=UʚHRqʓx!$Q#A`rikbR`qc^ /O+*c	    ProcessRPCer                                                                                                                                                                                                                                           o $      DCEVAXMUPA013.A                4  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_PSTI.EXE;3                                                                               8                          "            Rŏ@B RTPʏPxPؘPʏPxPܘPʏPxPPʏPxPRPʏPxPPxPPRP	PʏPxPP  PP쟭䟭ݭݭ   ԭQPЏ  RRPQP{RPQPQ||QPЏ  RRRPRQPQ{RPPQŏ@B QSSTݬw7  PRPRRP| ^(h 䭘Vz  P{PQPPz  P{d   PQPP,  Rz  RP{  PQPPVVTS4TRBRѬCb!4TRBRCbS4TRBRѬCbSЬ  d^;Rռ8  8  P	8  ެWgSݣ	7  Uգ1 7  TЧ Su6  V(	d0UP@2fʟ	d8	d0UP@2f	dD	d0UP@(2fff	dR	dUUX	Q7   8^URݬ25  ʟ	  %7   8^)R	67  P`7  Sc	7  P`c		7  P`c
6  P`cݬ2Z5  ʟ
6  P`cݬ285  ʟ9
6  P`cT
6  P`c ^ 5  ݬ26  PR 5  RP ^ 4  ݬ6  PR 4  RP ^ 4  ݬ5  PR 4  RP ^ 4  ݬ~5  PR 4  RP ^ 4  ݬݬ5  PR q4  RP ^ \4  ݬN5  PR L4  RP ^ 84  ݬݬݬ5  PR "4  RPP ^ 4  ݬݬ4  PR 3  RP ^ 3  ެPPSSݬݬ4  PRS 3  RP ^ 3  ݬݬ4  PR 3  RP ^ 3  ݬݬ4  PR u3  RP ^ `3  ݬݬݬݬa4  PR G3  RPP ^ 03  ݬݬݬ4  PR 3  RPP ^ 3  ݬݬݬ4  PR 2  RPP ^ 2  ݬ3  PR 2  RP ^ 2  ݬݬݬݬ3  PR 2  RPP ^ 2  ݬ3  PR t2  RP ^ `2  ݬ3  PR P2  RP ^ <2  ݬn3  PR ,2  RP ^ 2  ެPPSSݬ2  PRS 1  RP ^ 1  ݬ2  PR 1  RP ^ 1  ݬݬ2  PR 1  RP  ^ 1  ݬ2   1  P  ^ |1  ݬݬS2   l1  P ^ X1  ެPPSSݬݬ92  PRS 91  RP ^ $1   1  PR 1  R\\P ^  1  ݬ1  PR 0  RP ^ 0  ݬ2  PR 0  RP ^ 0  ݬ~1  PR 0  RP ^ 0  ެPPSSݬݬi1  PRS q0  RP ^ \0  ެPPSSݬ<1  PRS @0  RP ^ ,0  ެPPSSݬݬ
1  PRS 
0  RP                                                                                                                                                                                                                                                                                                                                                                               e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P        ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSynchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (        TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP/IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock A                                                                                                                                                                                                                                                                           Ji $      DCEVAXMUPA013.A                4  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_PSTI.EXE;3                                                                               8                         b      )       djustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTSUPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *        CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                     @   @       $  0                                             p   x                H              x   @      `  8      3          (    x           
      X
  P
  H
  @
  8
  0
  (
   
  
  
  
   
                                  x  p  h  `  X  P  H  @  8  0  (       +   
               (       @        p          X  0  P    8  @  `  P  X          x       0    x      (  h            ,           b   
                 @                                                                       DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        DECC$SHR                                                                                                                                                                                                                                                                                                                            5 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_SPEC.EXE;3 +  , 5   . 8    /  @   4     8   7                     - ;    0   1    2   3      K  P   W   O 9    5   6 1  7 ]   8          9          G  @  H   J                           0 D `     0205        /~     d                                                DCE$DTS_PROVIDER_SPEC                  DCE V1.3-950305B/ 05-13                             
               2   
  4     ?   $ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001!      !         DECC$SHR_001                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
 $      DCEVAXMUPA013.A                5  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_SPEC.EXE;3                                                                               8                         @ "              L  DCE$DTS_TSTP_MBX DCE$DTS_TPTS_MBX DCE$DTS_TP_DEVICE DCE$DTS_TP_INACCURACY DCE$DTS_TP_POLL_RATE DCE$DTS_TP_TIME_STAMPS   DCE$DTS_TP_MAXERROR DCE$DTS_TP_FIRSTSYNC DCE$DTS_TP_VERBOSE DCE$DTS_PROVIDER  LNM$PROCESS_TABLE     The time stamp value is out of legal range
 Legal Range is %d to %d
 PARAMETERS SET:
       TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TRUE  FALSE TP_VERBOSE:         %s


 TRUE  FALSE dtsprovider: init radio clock %s - %s
 Unable to register interface for TPP %s - %s
 TPP unable to register protocol sequences  %s - %s
 Can't inquire bindings %s - %s
 Can't inquire bindings %s - %s
 Can't bind to string Got binding: %s
 Spectracom Time Provider %s - %s
  Can't register with endpoint mapper %s - %s
  Can't get machine's host name %s - %s
  Can't register authentication Listening for connections ...
 %s - %s
 RPC listen terminated abnormally Executing ContactProvider ...
 Executing ServerRequestProviderTime ...
 Reply written :
 %d -o:Output value is out of legal range
 %d -c:Clockset value is out of legal range
 %d -p:Pollrate value is out of legal range
 %d -i:Inaccuracy value is out of legal range
 %d -t:Time stamp count is out of legal range
 


Enter the Device Name:   %255s Enter the Poll Rate in Seconds[%d]:  %d -p:Pollrate value is out of legal range
 Enter the Inaccuracy[%d(ms)]:  %d -i:Inaccuracy value is out of legal range
 Enter the Timestamp Count[%d]:  %d -t:Time stamp count is out of legal range
 Disallow clock set[%d(Y:1,N:0)] :  %d Output Trace [%d(Y:1,N:0)] :  %d  dtsprovider: cannot delay usage:	dtsprovider -d device-name
  		[-p pollrate, range %d : %d, default %d]
 		[-i milliseconds of inaccuracy, range %d : %d, default %d]
 		[-t timestamps, range %d : %d, default %d]
 		[-c disallow clock set, range 0(false) : 1(true), default %d]
 		[-o output trace, range 0(false) : 1(true), default %d]
 T T M_SPEC: QIO Status failure %x
 M_SPEC: IOSB Status failure %x bytes %d
 M_SPEC: response length failure %x
   dtssprovider: Spectracom manually set, ignoring time
 dtssprovider: Spectracom has lost signal
 dtssprovider: Spectracom year incorrect in switches
 dtssprovider: radio clock fault
 time returned - %26s
 dtssprovider: radio clock fault
  time returned - %26s
 K_TPI_FAILURE
    ******************************************
 K_TPI_SUCCESS
  Time Stamps   : %d
 Before Time	:   
TP Time		: 
After Time	: 

    ******************************************
 %s	 
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
  The external time did not validate
 Synchronization Count: %u
 Error Tolerance:       %u
 System Time:           %s
 External Device Time:  %s
 
!!!!!!!!!!!!!!!!!!
                                                                                                                                                                                                                                                                                                                                                x                                 <        *   <   R   g                                                                                                                                                                                                                                                                                                                                   Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.                       ^/VW\Џ   (>PSRSRR	SsT   g߭P2RBIT  P g߭PV2RBT  Pfff5 	T  RbS  S  RbS  S   Og߭P2RBS  P "g߭P2RBoS  P g߭P2RB:S  P{ g߭P"2RBS  P.P g߭P2RBR  P 3g߭P2RBzR  ^OR  Zv[WSnRTkPQUV7WxXYY<bd`aefg<hi 7Ѭ1 Q  P1 ØQ  P`Q  Rbx~<~üQ  P`b<'~
Q  P`b&Q  P`b TQ  P`b ÕwQ  P`b B  Ѭ
ݬݬ  )KQ  P`Q  Td$@.Q  P`dkPQ  P`dTpQ  P`dZÐP  P`d øP  P`dRRRP  P`d	RPRRP  P`d|ԪԪQkPЏ`  R
RP
Q{RPQPQQkPЏ`  RRRPRQPQP{RPPQQkQkPЏ  R
RP
Q{RPQPQjQkPЏ  RRRPRQPQ{RPPQQkŏ@B k|~ :PP'"R <N  RO   0N  DO  DM  DcM  DF4HDM   M  HI@?O  P`O   M  O  DXM  DF0ͨDSM   M  ͨwnN  P`N   eM  N  D<L  DF,DL   )M  ëâN  P`QN   
M  aN  1	 L  D<L  DF(hDL   L  hN  P`M   L  M  R<1 M  TPD$<PBL  D9 DL   DL  M  P`d )L  D$ M  P`dD$K  RR<1t K  D <K  DF(D}K   K  (4*M  P`L   K  L  D<K  @8 .K  @F͈@K   BK  ͈bXL  P`jL   #K  zL  D|~8J  DFDJ   J  ÊÀEL  P`L   J  L  R" J  èL  P`K   J  DR-J  DFHD,J   ]J  HK  P`K   >J  K  nn  P  (^ݬݬI  P%蟭I  P蟭I  P	 AK  Q3ѭqQQP ^R" I  K  P`J   I  ЬP`-M    ^SZ" AI  J  P`qJ   *I  ЬRRM  Pbb" H  9'J  Rj   H     ^[nXY RUެWUg1I  TI  VI  ZP޼PE`P`PP-1 I  P`dx~<~¼I  P`d<'~
I  P`d&I  P`d T{I  P`d iI  P`df1%P޼PE`P~I  Pc   myyyyyyyyy1 yyyQ1RP?PUUg1 H  P`dx~<~¼H  P`d<'~
H  P`d&H  P`d TH  P`d H  P`dfkJ޼PE`jP11M]H  P`dMH  P`dx~<~¼2H  P`d<'~
H  P`d&H  P`d TG  P`d G  P`df1UUg1 G  P`dx~<~¼G  P`d<'~
G  P`d&rG  P`d T`G  P`d NG  P`df}t޼PE`jP1wG  P`d
G  P`dx~<~¼F  P`d<'~
F  P`d&F  P`d TF  P`d F  P`df1[UUg1 |F  P`dx~<~¼aF  P`d<'~
HF  P`d&2F  P`d T F  P`d F  P`dfh ޼PE`jPhh  1£E  P`dE  P`dx~<~¼E  P`d<'~
E  P`d&yE  P`d TgE  P`d UE  P`df1PUUg1 0E  P`dx~<~¼E  P`d<'~
D  P`d&D  P`d TD  P`d D  P`df޼PE`jP
'  1O{D  P`dkD  P`dx~<~¼PD  P`d<'~
7D  P`d&!D  P`d TD  P`d C  P`df1PUUg1 C  P`dx~<~¼C  P`d<'~
C  P`d&C  P`d T|C  P`d jC  P`df޼PE`jP1'C  P`B  C  P`dx~<~¼B  P`d<'~
B  P`d&B  P`d TB  P`d B  P`df1aPUU1 B  P`FB  Scx~<~¼]B  P`c<'~
DB  P`c&.B  P`c TB                                                                                                                                                                                                                                                                             X $      DCEVAXMUPA013.A                5  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_SPEC.EXE;3                                                                               8                         x "            P`c 
B  P`cA  ޼PE`A  ݩA  A  Pi1 A  P`A  Scx~<~¼A  P`c<'~
A  P`c&iA  P`c TWA  P`c EA  P`c&A  UUg18P< ^TXSmUR(@  @  \l< ~@  D@  cJ@  @  \l< ~@  com@  c	c  r}@  \lC@  Z@  d1@  S@  \l< ~ @  dº@  d
	d'  ½@  \l?  ?  e?  ?  \l< ~?  e?  ee?  \l?  ?  6m?  ?  \l< ~\?  YC?  \.?  P?  \ݬ < ~?  z?   ^SЬԭ=  P"~R =  R>   z=  PPP  ^ `=   >   R=   ^R>  \lq>  Scx~<~¼>  \lc<'~
o>  \lc&Y>  \lc TG>  \lc 5>  \l  ^|YUZRnVլ1ެ[Ы U=  Wg<   0VP@(0VP@0VP@ݬ  PXP1kQ0VP@(T0VP@SST<  P%؟;  P؟蟭;  P	 \=  QiRѭjQQXX1 kQ0VP@(S0VP@T 
,=  P`g\
=  P`gi

=  P`gj
<  P`gS2¶
<  P`gT2
<  P`g
<  P`gXVPnPnPPPV1P  ^|~PP\\PP  ^<~PQQP  <Լ< $  4^R}(ݬd:  ;  P|~<~ݬ  PSݬ&:  SS;  P`y;  ST_<QQ!<~Q;  P`S;  <T8<PPPg;  P`-;  T短ݬ   PTTP ^TЬRSSRR*Z;  Rb:  V1$PSRR?Đ:  Rb:  V1PЬRRR$ĺ:  Rb:  V1PЬRRRA   @T U:PRB   U&PRC   "UPRD   V1PЬP`RR
$RR

RR:RR:	RR.0.:  Rb9  ݬ	:  Rb9  V1"ЬPQ0Q
QR0RRQѭZ   d   옠S0Sďd   SR0R
RRS	R0RRSQ0Q
QR0RRQQ0Q
QR0RRQܘQ0Q
QR0RRQؘS0Sďd   SR0R
RRSR0RSRŏ@B RWUz  P{PQPPz  P{d   PQPPz  P{  PQPPUUSЭQ
SRQRB@RѭR(P
SPQP@@PPQ
SPQP@@PѭPQѭ<ѭ;ѭ
ѭn  1&	8  Rba8  ݬH	8  RbJ8  V1 $ N8  QZPЏ  RRPQP{RPQPQQ3PЏ  RRRPRQPQP{RPPQŏ@B QSSWݬ_6  PVPVVPP d^Rռ^	7  p	7  P	}7  ެWgSݣ¬	h7  Uգ1 X7  TЧ S5  V	d0UP@2fʟ
d	d0UP@2f
d	d0UP@(2fff
d	dUU	6   8^Rݬ2U5  ʟ
  6   8^R 
6  P`}6  Sc\
6  P`c
6  P`c
s6  P`cݬ24  ʟ¶
Q6  P`cݬ24  ʟ
/6  P`c
6  P`c ^ 4  ݬ5  PR 4  RP ^ l4  ݬ5  PR \4  RP ^ H4  ݬ5  PR 84  RP ^ $4  ݬ4  PR 4  RP ^  4  ݬݬ#5  PR 3  RP ^ 3  ݬ4  PR 3  RP ^ 3  ݬݬݬ4  PR 3  RPP ^ 3  ݬݬc4  PR u3  RP ^ `3  ެPPSSݬݬ94  PRS A3  RP ^ ,3  ݬݬ4  PR 3  RP ^ 3  ݬݬ3  PR 2  RP ^ 2  ݬݬݬݬ3  PR 2  RPP ^ 2  ݬݬݬ3  PR 2  RPP ^ 2  ݬݬݬ3  PR j2  RPP ^ T2  ݬj3  PR D2  RP ^ 02  ݬݬݬݬ53  PR 2  RPP ^  2  ݬ2  PR 1  RP ^ 1  ݬ3  PR 1  RP ^ 1  ݬ2  PR 1  RP ^ 1  ެPPSSݬt2  PRS x1  RP ^ d1  ݬf2  PR T1  RP ^ @1  ݬݬk2  PR -1  RP  ^ 1  ݬ22   1  P  ^ 0  ݬݬ1   0  P ^ 0  ެPPSSݬݬ1  PRS 0  RP ^ 0   m1  PR 0  R\\P ^ |0  ݬJ1  PR l0  RP ^ X0  ݬ1  PR H0  RP ^ 40  ݬ~61  PR  0  RP ^ 0  ެPPSSݬݬ0  PRS /  RP ^ /  ެPPSSݬ0  PRS /  RP ^ /  ެPPSSݬݬ0  PRS /  RP                                                                                                                                                                                                                                           e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P        ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSynchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_                                                                                                                                                                                                                                                                            |_ $      DCEVAXMUPA013.A                5  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_SPEC.EXE;3                                                                               8                         3 "     %       COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (        TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP/IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock Adjustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTSUPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *        CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                     @   @       (  4                                             p   x                H              x   @      `  8      3          (    x           
      X
  P
  H
  @
  8
  0
  (
   
  
  
  
   
                                  x  p  h  `  X  P  H  @  8  0  (       ,   
               (       @        p          X  0  P    8  @  `  P  X          x       0    x        (  h            ,           b   
                 @                                                                       DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                                                                                                                                                                                                                                                                                               *q $      DCEVAXMUPA013.A                5  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_SPEC.EXE;3                                                                               8                         Y      6                   CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        DECC$SHR                                                                                                                                                                                                                                                                                                                        6 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_START.COM;3 +  , 1   .     /  @   4 ]                           - ;    0   1    2   3      K  P   W   O 
    5   6 vKl  7 w   8          9          G  @  H   J                          $ ! D $ !	DTSS_TP_START.COM - Procedure to start the DCE/DTS Time Provider $ !  $ !  $ ! TO RUN:  $ ! D $ !     command line parameters can be passed or logical names used.& $ !	"usage: dtsprovider -d device-name? $ !        [-p pollrate, range 30 : 3600 default 120] (seconds) H $ !        [-i milliseconds of inaccuracy, range 10 : 10000, default 30]% $ !        [-t timestamps, default 4] G $ !        [-c disallow clock set, range 0(false) : 1(true), default 0] A $ !        [-o output trace, range 0(false) : 1(true), default 0]  $ !  $ ! ; $ !	Four logical names are translated at program start from C $ !	the system logical name table which control the characteristics 4 $ !      of the time provider's operation, they are: $ !  $ !	Logical name		< $ !	  DTSS$_TP_DEVICE :   Device to which provider attached.D $ !              This is usually an RS232 port to which the providerE $ !              radio is attatched.  The terminal characteristics of C $ !              the port must be set using the 'set term/perm' DCL H $ !              command.  Each provider type requires specific settingsL $ !              which are documented in the provider specific documentation# $ !              in the code below.  $ ! ' $ !           Format: Any ASCII string.  $ ! ; $ !	  DTSS$_TP_INACCURACY  :   Systematic inaccuracy in ms. D $ !              Each radio clock specifies the amount of systematicC $ !              inaccuracy which is returned with each time-stamp. D $ !              This is usually proportional to the number of milesG $ !              the device is physically located from the transmission J $ !              center from which time is read.  The inaccuracy specifiedH $ !              by this parameter is added to the times returned to the $ !              time server.  $ ! - $ !           Format: a non-negative integer.  $ ! A $ !	  DTSS$_TP_POLL_RATE   :   Rate in seconds that the device is F $ !              polled.  This value will override the DTSS management9 $ !              parameter 'synchronization hold down'.    $ ! L $ !           Format: an integer (seconds) in the range 1 second to 31 days; $ !                           C $ !	   DTSS$_TP_TIME_STAMPS :   This parameter specifies the number B $ !              of timestamps which are read and returned to the 5 $ !              time server at each synchronization.  $ ! 6 $ !           Format: an integer in the range 1 to 6;  $ ! / $ !     The following two are not implemented    $ ! C $ !         DTSS$_TP_MAXERROR : If the difference between the time  @ $ !              provider and the local clock differs more than F $ !              maxerror, then the timeprovider is considered faulty,. $ !              and its timestamp is ignored. $ ! 7 $ !           Format: a non-negative integer (seconds).  $ ! @ $ !         DTSS$_TP_FIRSTSYNC : If this value is TRUE, then theC $ !              DTSS$TP_MAXERROR parameter is ignored on the first ! $ !              synchronization.  $ ! 1 $ !           Format: 0 , false;  otherwise TRUE.  $ ! 6 $ !         DTSS$_TP_VERBOSE : Display info to std out $ !         / $ !           Format: 0, false; otherwise TRUE.  $ ! E $ !      This is an example session, only setting the dtss$_tp_device 6 $ !      logical is required, all others are optional: $ !  $ ! @ $ ! set the terminal characteristics.  The exact characteristicsC $ ! are specific to the external device.  Important characteristics < $ ! to consider are buad rate and parity.  After setting the> $ ! terminal characteristics, set host _TTA3:/dte, can be usedA $ ! to test the external device and the terminal characteristics.  $ ! C $ !      set DEVICE equal to the device name for the time provider.  $ device    = "TTA1:" + $ write sys$output "Default - device TTA1:"  $ ! B $ !      set this to the brand id for the time provider being used! $ !             Spectracom = SPEC " $ !             Psti       = PSTI # $ !             GC1000     = GC1000 ! $ !             Traconex   = TRAC ! $ !             Hopf       = HOPF  $ tmbrand   :=  spec $ ! ( $ procedure = f$environment("PROCEDURE")P $ path      = f$parse(procedure,,,"DEVICE") + f$parse(procedure,,,"DIRECTORY")   $  $ ! : $ ! now define the time provider logicals, only the device/ $ ! name is required or pass them as parameters  $ ! ] $ if (F$mode() .NES. "INTERACTIVE") .or. (F$edit(P1,"upcase") .EQS. "DEBUG") then goto pass_1  $ ! - $ ! run the provider detatched at priority 10  $ !  $ ' $ run sys$system:loginout.exe /detach -          /input = 'procedure -          /priority=10 -'         /process_name=DCE$DTS_PROVIDE - :      	/output=dce$local:[var.adm.time]dce$dts_tp_out.log -7     	/error=dce$local:[var.adm.time]dce$dts_tp_err.log  J $ write sys$output "Output/Error log location -> DCE$LOCAL:[VAR.ADM.TIME]" $ !  $ exit $ ! 	 $ PASS_1: C $ ! define DCE$DTS_TP_DEVICE       'device	! your device - required ? $ ! define DCE$DTS_TP_TIME_STAMPS  4		! read 4 times each synch > $ ! define DCE$DTS_TP_POLL_RATE    30		! synch each 30 seconds= $ ! define DCE$DTS_TP_VERBOSE      1		! Verbose output to log  $ 1 $ set term 'device /passall/pasthru/eightbit/perm ; $ mcr 'path'dce$dts_provider_'tmbrand -d 'device -t 4 -p 30  $! $ exit                                                                                                                                                                                                                                                                                                                                                                                               5 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_TRAC.EXE;3 +  , 6   . 8    /  @   4     8   7                     - ;    0   1    2   3      K  P   W   O 9    5   6 9  7    8          9          G  @  H   J                           0 D `     0205        7~     d                                                DCE$DTS_PROVIDER_TRAC                  DCE V1.3-950305]7 05-13                             
               2   
  4     ?   $ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001!      !         DECC$SHR_001    L  DCE$DTS_TSTP_MBX DCE$DTS_TPTS_MBX DCE$DTS_TP_DEVICE DCE$DTS_TP_INACCURACY DCE$DTS_TP_POLL_RATE DCE$DTS_TP_TIME_STAMPS   DCE$DTS_TP_MAXERROR DCE$DTS_TP_FIRSTSYNC DCE$DTS_TP_VERBOSE DCE$DTS_PROVIDER  LNM$PROCESS_TABLE     The time stamp value is out of legal range
 Legal Range is %d to %d
 PARAMETERS SET:
       TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TRUE  FALSE TP_VERBOSE:         %s


 TRUE  FALSE dtsprovider: init radio clock %s - %s
 Unable to register interface for TPP %s - %s
 TPP unable to register protocol sequences  %s - %s
 Can't inquire bindings %s - %s
 Can't inquire bindings %s - %s
 Can't bind to string Got binding: %s
 Spectracom Time Provider %s - %s
  Can't register with endpoint mapper %s - %s
  Can't get machine's host name %s - %s
  Can't register authentication Listening for connections ...
 %s - %s
 RPC listen terminated abnormally Executing Conta                                                                                                                                                   !                        D $      DCEVAXMUPA013.A                6  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_TRAC.EXE;3                                                                               8                         z "            ctProvider ...
 Executing ServerRequestProviderTime ...
 Reply written :
 %d -o:Output value is out of legal range
 %d -c:Clockset value is out of legal range
 %d -p:Pollrate value is out of legal range
 %d -i:Inaccuracy value is out of legal range
 %d -t:Time stamp count is out of legal range
 


Enter the Device Name:   %255s Enter the Poll Rate in Seconds[%d]:  %d -p:Pollrate value is out of legal range
 Enter the Inaccuracy[%d(ms)]:  %d -i:Inaccuracy value is out of legal range
 Enter the Timestamp Count[%d]:  %d -t:Time stamp count is out of legal range
 Disallow clock set[%d(Y:1,N:0)] :  %d Output Trace [%d(Y:1,N:0)] :  %d  dtsprovider: cannot delay usage:	dtsprovider -d device-name
  		[-p pollrate, range %d : %d, default %d]
 		[-i milliseconds of inaccuracy, range %d : %d, default %d]
 		[-t timestamps, range %d : %d, default %d]
 		[-c disallow clock set, range 0(false) : 1(true), default %d]
 		[-o output trace, range 0(false) : 1(true), default %d]
  03QU0000M_TRAC: QIO Status failure %x
 M_TRAC: IOSB Status failure %x
 M_TRAC: Bytes Read: %d
 M_TRAC: response length failure %x
     dtssprovider: Traconex out of spec
 dtssprovider: Traconex hardware fault
 dtssprovider: Traconex signal fault
 dtssprovider: Traconex time not available
  dtssprovider: Traconex year mismatch
 dtssprovider: radio clock fault
  time returned - %d %d:%02d:%02d.%09d
 K_TPI_FAILURE
    ******************************************
 K_TPI_SUCCESS
  Time Stamps   : %d
 Before Time	:   
TP Time		: 
After Time	: 

    ******************************************
 %s	 
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
  The external time did not validate
 Synchronization Count: %u
 Error Tolerance:       %u
 System Time:           %s
 External Device Time:  %s
 
!!!!!!!!!!!!!!!!!!
                                                                                                                                                                                                                                                                                                                                            x                                 <        *   <   R   g                                                                                                                                                                                                                                                                                                           Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.                       ^GVW\Џ   (>PSRSRR	SsT   g߭P2RBIT  P g߭PV2RBT  Pfff5 	T  RbS  S  RbS  S   gg߭P2RBS  P :g߭P2RBoS  P g߭P2RB:S  P g߭P"2RBS  PFP g߭P2RBR  P Kg߭P2RBzR  ^OR  Z[WSnRTkPQUVOWXqY<bd`-aefg<hi 7Ѭ1 Q  P1 ØQ  P`Q  Rbx~<~üQ  P`b<'~
Q  P`b&Q  P`b TQ  P`b ÕwQ  P`b B  Ѭ
ݬݬ  )KQ  P`Q  Td<@.Q  P`dkPQ  P`dlpQ  P`drÐP  P`d8øP  P`dRRRP  P`d	RPRRP  P`d|ԪԪQkPЏ`  R
RP
Q{RPQPQQkPЏ`  RRRPRQPQP{RPPQQkQkPЏ  R
RP
Q{RPQPQjQkPЏ  RRRPRQPQ{RPPQQkŏ@B k|~8RPP'"R <N  RO   0N  DO  DM  DcM  DF4HDM   M  HI@?O  P`O   M  O  DXM  DF0ͨDSM   M  ͨwnN  P`N   eM  N  D<L  DF,DL   )M  ëâN  P`QN   
M  aN  1	 L  D<L  DF(hDL   L  hN  P`M   L  M  R<1 M  TPD$<PBL  D9 DL   DL  M  P`d )L  D$ M  P`dD$K  RR<1t K  D <K  DF(D}K   K  (4*M  P`L   K  L  D<K  @8 .K  @F͈@K   BK  ͈bXL  P`jL   #K  zL  D|~8J  DFDJ   J  ÊÀEL  P`L   J  L  R" J  èL  P`K   J  DR-J  DFHD,J   ]J  HK  P`K   >J  K  nn  P  (^ݬݬI  P%蟭I  P蟭I  P	 AK  QKѭQQP ^R" I  K  P`J   I  ЬP`Ee1    ^Sr" AI  J  P`qJ   *I  ЬRRM  Pbb" H  9'J  R   H     ^[XY RUެWUg1I  TI  VI  ZP޼PE`P`PP-1 I  P`dx~<~¼I  P`d<'~
I  P`d&I  P`d T{I  P`d iI  P`df1%P޼PE`P~I  Pc   myyyyyyyyy1 yyyQ1RP?PUUg1 H  P`dx~<~¼H  P`d<'~
H  P`d&H  P`d TH  P`d H  P`dfkJ޼PE`jP11M]H  P`dMH  P`dx~<~¼2H  P`d<'~
H  P`d&H  P`d TG  P`d G  P`df1UUg1 G  P`dx~<~¼G  P`d<'~
G  P`d&rG  P`d T`G  P`d NG  P`dft޼PE`jP1wG  P`d
G  P`dx~<~¼F  P`d<'~
F  P`d&F  P`d TF  P`d F  P`df1[UUg1 |F  P`dx~<~¼aF  P`d<'~
HF  P`d&2F  P`d T F  P`d F  P`dfh ޼PE`jPhh  1£E  P`dE  P`dx~<~¼E  P`d<'~
E  P`d&yE  P`d TgE  P`d UE  P`df1PUUg1 0E  P`dx~<~¼E  P`d<'~
D  P`d&D  P`d TD  P`d D  P`df޼PE`jP
'  1O{D  P`dkD  P`dx~<~¼PD  P`d<'~
7D  P`d&!D  P`d TD  P`d C  P`df1PUUg1 C  P`dx~<~¼C  P`d<'~
C  P`d&C  P`d T|C  P`d jC  P`df޼PE`jP1'C  P`B  C  P`dx~<~¼B  P`d<'~
B  P`d&B  P`d TB  P`d B  P`df1aPUU1 B  P`FB  Scx~<~¼]B  P`c<'~
DB  P`c&.B  P`c TB  P`c 
B  P`cA  ޼PE`A  ݩA  A  Pi1 A  P`A  Scx~<~¼A  P`c<'~
A  P`c&iA  P`c TWA  P`c EA  P`c&A  UUg18P< ^/TpSUR(@  @  \l< ~@  D@  cJ@  @  \l< ~@  com@  c	c  r}@  \lC@  Z@  d1@  S@  \l< ~ @  dº@  d
	d'  ½@  \l?  ?  e?  ?  \l< ~?  e?  ee?  \l?  ?  6m?  ?  \l< ~\?  YC?  \.?  P?  \ݬ < ~?  z?   ^SЬԭ=  P"~R =  R>   z=  PPP  ^ `=   >   R=   ^R>  \lq>  Scx~<~¼>  \lc<'~
o>  \lc&Y>  \lc TG>  \lc 5>  \l  ^Ym                                                                                                                                                                                                                                                   "                        L $      DCEVAXMUPA013.A                6  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_TRAC.EXE;3                                                                               8                           "            ZRnVլ1ެ[Ы U=  Wg<   0VP@(0VP@0VP@ݬ  PXP1kQ0VP@(T0VP@SST<  P%؟;  P؟蟭;  P	 \=  QijѭjQQXX1 kQ0VP@(S0VP@T<
,=  P`gx
=  P`gi

=  P`gj·
<  P`gS2
<  P`gT2
<  P`g<  P`gXVPnPnPPPV1P  ^|~PP\\PP  ^<~PQQP  <-Լ< $  $^R}(ݬd:  	
|~<~ݬ  PSݬ1:  SS;  P`;  STsP<QQ5Q;  P`_;  <~;  P`G;  <T5<PP
P0[;  P`!;  Tݬ   PTTP ^TЬP`R0RSR0RUSp:  V1:SĔ:  V1&SĻ:  V1S:  V1S	:  V1ЬPR0RxRQR0RQRŏ@B RWR0RؘR0RܘR0RUUѭ	ѭԭЬPR0RxRQR0RRQ	R  RRUz  P{PQPPz  P{d   PQPPz  P{  PQPPUUSЭQ
SRQRBTRѭR&
SPQP@TPPQ
SPQP@TPѭPQѭ<ѭ;ѭ
ѭn  62	9  RbI9  WݭݭݭݭT	a9  Rb'9  $ 19  QUPЏ  RRPQP{RPQPQQ/PЏ  RRRPRQPQP{RPPQŏ@B QSSWݬC7  PVPVVPP d^Rռz	z8  	o8  P¸	a8  ެWgSݣ	L8  Uգ1 <8  TЧ S6  V	d0UP@2fʟ8
d	d0UP@2f8
d	d0UP@(2fff8
d
dUU
7   8^Rݬ296  ʟ8
  7   8^R<
7  P`a7  Scx
7  P`c
m7  P`c·
W7  P`cݬ25  ʟ
57  P`cݬ25  ʟ
7  P`c7  P`c ^ t5  ݬ6  PR d5  RP ^ P5  ݬr6  PR @5  RP ^ ,5  ݬ5  PR 5  RP ^ 5  ݬ5  PR 4  RP ^ 4  ݬݬ6  PR 4  RP ^ 4  ݬ5  PR 4  RP ^ 4  ݬݬݬ5  PR 4  RPP ^ l4  ݬݬG5  PR Y4  RP ^ D4  ެPPSSݬݬ5  PRS %4  RP ^ 4  ݬݬ5  PR 3  RP ^ 3  ݬݬ4  PR 3  RP ^ 3  ݬݬݬݬ4  PR 3  RPP ^ 3  ݬݬݬl4  PR z3  RPP ^ d3  ݬݬݬp4  PR N3  RPP ^ 83  ݬN4  PR (3  RP ^ 3  ݬݬݬݬ4  PR 2  RPP ^ 2  ݬ3  PR 2  RP ^ 2  ݬ3  PR 2  RP ^ 2  ݬ3  PR 2  RP ^ x2  ެPPSSݬX3  PRS \2  RP ^ H2  ݬJ3  PR 82  RP ^ $2  ݬݬO3  PR 2  RP  ^ 1  ݬ3   1  P  ^ 1  ݬݬ2   1  P ^ 1  ެPPSSݬݬ2  PRS 1  RP ^ 1   Q2  PR w1  R\\P ^ `1  ݬ.2  PR P1  RP ^ <1  ݬr2  PR ,1  RP ^ 1  ݬ~2  PR 1  RP ^ 0  ެPPSSݬݬ1  PRS 0  RP ^ 0  ެPPSSݬ1  PRS 0  RP ^ 0  ެPPSSݬݬm1  PRS m0  RP                                                                                                                                                                                                                                                                                                                                                                                                                                                                               e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P        ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSynchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (        TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP                                                                                                                                                                                                                                                   #                        6 $      DCEVAXMUPA013.A                6  ;  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_TRAC.EXE;3                                                                               8                         	       '       /IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock Adjustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTSUPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *        CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                     @   @       (  4                                             p   x                H              x   @      `  8      3          (    x           
      X
  P
  H
  @
  8
  0
  (
   
  
  
  
   
                                  x  p  h  `  X  P  H  @  8  0  (       ,   
               (       @        p          X  0  P    8  @  `  P  X          x       0    x        (  h            ,           b   
                 @                                                                       DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        DECC$SHR                                                                                                                                                                                                                                                                                                                        ' * [SYSHLP.EXAMPLES.DCE]GDE_DCE_APPS.DIR;1 +  , -   .     /  @   4                            - ;    0   1    2   3     K  P   W   O     5   6 P[   7 F@   8          9          G  @  H   J  I                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        $                        j34 $      DCEVAXMUPA013.A                -  ;  '[SYSHLP.EXAMPLES.DCE]GDE_DCE_APPS.DIR;1                                                                                                                                   ARITHMETIC.DIR 0     
INVENTORY.DIR  %	/     REMOTE_FILE.DIR  04     TRANSFER_DATA.DIR  0?                                                                                                                                                                                                                                                                                                                                                                                                                       2 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS]ARITHMETIC.DIR;1 +  , 0   .     /  @   4                            - -    0   1    2   3     K  P   W   O     5   6 "   7 ǘ   8          9          G  @  H   J  I                         ARITHMETIC.SAV $	:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  = * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.ARITHMETIC]ARITHMETIC.SAV;1 +  , $	:   . @    /  @   4   ~  @   @      ~               - 0    0   1    2   3      K  P   W   O A    5   6 `ad  7 X   8          9          G  @  H   J                                              P ~      ARITHMETIC.SAV                                                                                                                                                                                               P                ARITHMETIC.SAV9  BACKUP SRC$:*.* OBJ$:ARITHMETIC.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @    	Fd      V5.5	 	 _OPNDCE:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                           # * [RPCARITHMETIC.SRC]ARITHMETIC.COM;1 +  , _-7   .     /  @   4 L                          - a\   0   1    2   3      K  P   W   O     5   6 Yt  7 Eut  8          9          G  @  H  J $ N                   ?                    $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! $! Abstract:: $!	ARITHMETIC.COM -- Builds the arithmetic example program $! Modification History:, $!	03-Sep-1993 FWB Modified for VMS DCE V1.1 $!* $! Determine which compiler is being used. $ @DCE:DCE$CC_TEST $! $! Determine option files $ $ If( f$trnlnm("dce$cc") .eqs. " " )I $ THEN	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options" & $ ELSE	options = "dce:dce.opt/options" $ ENDIF - $! Enable the universal IDL command interface  $idl := mcr dce$idl  $ # $! Compile the interface definition  $idl -v arithmetic.idl $ ) $! Build the local version of the example ! $cc/define=LOCAL client,procedure 1 $link/exe=LOCAL_CLIENT client,procedure,'options' $ $delete client.obj;*,procedure.obj;* $  $! Build the arithmetic client
 $cc client' $link client,arithmetic_cstub,'options'  $  $! Build the arithmetic server $cc/list server,procedure 1 $link server,procedure,arithmetic_sstub,'options'  $ 6 $! Define the entry for the server in the name service8 $ ARITHMETIC_SERVER_ENTRY == "/.:/arithmetic_serverhost" $ 5 $! Define the entry for the client to find the server 2 $ RPC_DEFAULT_ENTRY == "/.:/arithmetic_serverhost"                                                        # * [RPCARITHMETIC.SRC]ARITHMETIC.IDL;1 +  , l-7   .     /  @   4 P                         - a\   0   1    2   3      K  P   W   O     5   6 b]  7 i]  8          9 #ΚL!b  G  @  H  J $ N                   ?                   /* FILE NAME: arithmetic.idl 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* This Interface Definition Language file represents a basic arithmetic    */
/* procedure that a remote procedure call application can use.              */
[
uuid(C985A380-255B-11C9-A50B-08002B0ECEF1)/* Universal Unique ID          <CO>*/
]
interface arithmetic                      /* interface name is arithmetic <CO>*/
{
   const unsigned short ARRAY_SIZE = 10;/* an unsigned integer constant   <CO>*/
   typedef long long_array[ARRAY_SIZE]; /* an array type of long integers <CO>*/

   void sum_arrays ( /* The sum_arrays procedure does not return a value  <CO>*/
      [in] long_array a,                /* 1st parameter is passed in       */
      [in] long_array b,                /* 2nd parameter is passed in       */
      [out] long_array c                /* 3rd parameter is passed out      */
   );
}
                                                                                                           # * [RPCARITHMETIC.SRC]CHECK_STATUS.H;1 +  , r-5   .     /  @   4 P       %                  - a\   0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                   /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                                                                                                                                          * [RPCARITHMETIC.SRC]CLIENT.C;1 +  , ~-3   .     /  @   4 L       .                   - a\   0   1    2   3      K  P   W   O     5   6 F]  7 I  G]  8          9 #ΚL!b  G  @  H  J $ N                   ?                         /* FILE NAME: client.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
**  This is the client module of the arithmetic example.
*/
#include <stdio.h>
#include "arithmetic.h"    /* the header file created by the IDL compiler */

long_array a ={100,200,345,23,67,65,0,0,0,0};
long_array b ={4,0,2,3,1,7,5,9,6,8};

main ()
{
   long_array    result; 
   int i;

   sum_arrays(a, b, result);         /* A Remote Procedure Call <CO>*/
   puts("sums:");
   for(i = 0; i < ARRAY_SIZE; i++)
      printf("%ld\n", result[i]);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 * [RPCARITHMETIC.SRC]CLIENT.COM;1 +  , %.8   .     /  @   4 D                          - a\   0   1    2   3      K  P   W   O     5   6 

  7 B 

  8          9          G  @  H  J $ N                                                                                                                                                                    %                        _S $      DCEVAXMUPA013.A                $	:  0  =[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.ARITHMETIC]ARITHMETIC.SAV;1                                                                    ~   ~@                          "              ?                       5 $! Define the entry for the client to find the server D $ inquire host "Enter server host name inside quotes (ie. ""host"")"/ $ RPC_DEFAULT_ENTRY == "/.:/arithmetic_''host'"  $ sho sym RPC_DEFAULT_ENTRY / $ write sys$output "Running the CLIENT program"  $ run client                                                                                                                                                                                                                                                               * [RPCARITHMETIC.SRC]CLIENT.SH;1 +  , -.=   .     /  @   4 6                           - a\   0   1    2   3      K  P   W   O     5   6 `G'  7  8'  8          9          G  @  H  J $ N                   ?                        echo "Enter the arithmetic server host name"
read CLIENTHOST ETC
echo "Server host: $CLIENTHOST$ETC will be accessed"
def_log RPC_DEFAULT_ENTRY "/.:/arithmetic_$CLIENTHOST"
client
del_log RPC_DEFAULT_ENTRY
#
                                                                                                                                                                                                                                                                                                                               * [RPCARITHMETIC.SRC]MAKEFILE.;1 +  , !!   .     /  @   4 N                           - a\   0   1    2   3      K  P   W   O 	    5   6 9W  7 MRW  8          9          G  @  H  J $ N                   ?                        # FILE NAME: Makefile 
# Makefile for OpenVMS/POSIX  arithmetic example application program
#
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
# definitions for this make file
#
DCL_IDL= dcl mcr dce\$$idl
IDL= $(DCL_IDL)
CFLAGS_INIT = -U VMS -I. 
IDL_CFLAGS= -v -keep c_source 
CC = c89
OPTFILE= /vms/sys0/syscommon/dce\$$library/dce.opt
APPL=arithmetic
IDLCMD=$(IDL) 
#LIBS=-ldce -lcma -li -ldnet   #dce and internationalization libraries
#CFLAGS=   
#CC=cc 
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`

default: interface machine

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi


#
# COMPLETE BUILD of the application
#
build:	local ostubs client server


#
# LOCAL BUILD of the client application to test locally
#       
local:	 client.c procedure.c
		$(CC) $(C_FLAGS) -DLOCAL -o local_client client.c procedure.c 
# 		remove object files so they do not interfere with a real build
		rm client.o procedure.o


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl $(IDL_CFLAGS)

# STUB OBJECTS BUILD
ostubs: $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL)_cstub.c $(APPL)_sstub.c 
	$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c

#
# CLIENT BUILD 
#
client:	$(APPL).h client.o $(APPL)_cstub.o 
	   $(CC) $(C_FLAGS) -o client client.o $(APPL)_cstub.o $(OPTFILE) 


#
# SERVER BUILD 
#
server:	$(APPL).h server.o procedure.o $(APPL)_sstub.o
	   $(CC) $(C_FLAGS) -o server server.o procedure.o $(APPL)_sstub.o $(OPTFILE)
clean:
	rm $(APPL).h *.o $(APPL)_cstub.c $(APPL)_sstub.c client server

                                                                                                                                                                                                                                                                                                                                       " * [RPCARITHMETIC.SRC]MAKEFILE.OSF1;1 +  , !"   .     /  @   4 K                         - a\   0   1    2   3      K  P   W   O 	    5   6 K3a  7 a  8          9 #ΚL!b  G  @  H  J $ N                   ?                    # FILE NAME: Makefile 
# Makefile for the arithmetic application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
#
# definitions for this make file
#
APPL=arithmetic
IDLCMD=idl -v
LIBS=-ldce -lcma    #dce and thread libraries 
CFLAGS= -D_USER_THREADS_ 
CC=cc 


#
# COMPLETE BUILD of the application
#
all:	local interface client server


#
# LOCAL BUILD of the client application to test locally
#       
local:	interface client.c procedure.c
	   $(CC)   -DLOCAL -o local_client client.c procedure.c
# remove object files so they do not interfere with a real build
	   rm client.o procedure.o


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl


#
# CLIENT BUILD 
#
client:	$(APPL).h client.o $(APPL)_cstub.o 
	   $(CC) $(CFLAGS) -o client client.o $(APPL)_cstub.o $(LIBS) 


#
# SERVER BUILD 
#
server:	$(APPL).h server.o procedure.o $(APPL)_sstub.o
	   $(CC) $(CFLAGS) -o server server.o procedure.o $(APPL)_sstub.o $(LIBS)
                                                                                                                                            * [RPCARITHMETIC.SRC]PROCEDURE.C;1 +  , 8.<   .     /  @   4 P                         - a\   0   1    2   3      K  P   W   O     5   6 [M]  7 WN]  8          9 #ΚL!b  G  @  H  J $ N                   ?                      /* FILE NAME: procedure.c 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/*  An implementation of the procedure defined in the arithmetic interface. */
#include <stdio.h>
#include "arithmetic.h"

void sum_arrays(a, b, c)    /* implementation of the sum_arrays procedure <CO>*/
   long_array a;
   long_array b;
   long_array c;
   {
      int i;

      for(i = 0; i < ARRAY_SIZE; i++)
         c[i] = a[i] + b[i];    /* array elements are each added together <CO>*/
   }
                * [RPCARITHMETIC.SRC]README.LIS;1 +  , T!   .     /  @   4 k                         - a\   0   1    2   3      K  P   W   O     5   6 W  7 +B  8          9          G  @  H  J $ N                   ?                       
taken from Appendix C of Guide to Writing DCE Applications, by John Shirley




			COPYRIGHT (C) 1993 BY
                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
                  MASSACHUSETTS.  ALL RIGHTS RESERVED.

 THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
 ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
 OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY                                                                                                                                                                                                                                                   &                        @( $      DCEVAXMUPA013.A                $	:  0  =[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.ARITHMETIC]ARITHMETIC.SAV;1                                                                    ~   ~@                          "              OTHER COPIES
 THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
 PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.

 THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.

 DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
 SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.




                                                                        C
        _________________________________________________________________

                                               The Arithmetic Application


              The arithmetic application makes a remote procedure call
              to a procedure named sum_arrays, which adds together the
              values for the same array index in two long integer arrays
              and returns the sums in another array of long integers.

              The application demonstrates the basics of a distributed
              application with a remote procedure call and includes these
              features:

              o  Defining a simple array in an interface definition

              o  Using the automatic binding method

              o  Exporting a server to the name service

              o  Checking the error status of RPC runtime calls

    How to Build The Application

      To create the NONDISTRIBUTED LOCAL test of the application,
      enter the following command:

         For the OpenVMS/POSIX environment copy files from the DCE examples
         directory to your POSIX accessible directory):
         	psx> cd /mydev/mydir
	 	psx> copy /usr/dce/examples/gde_dce_apps/arithmetic/*  .

            Build the local version of the example
                psx> make 			(currently this will actually 
						 build all versions)

         For the OpenVMS environment copy files from the DCE examples directory
         to your local directory:
         	C$ set default mydisk:[mydirectory]
         	C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.arithmetic]*.* []
         	C$ @arithmetic

	      	    Running ARITHMETIC.COM creates all the executables (lcoal
	            and Distributed) for the arithmetic application.

      To build the DISTRIBUTED application
  
         For the OpenVMS/POSIX environment, enter the following:

	 	psx> make 


    How to Run The Application

      To run the LOCAL test on OpenVMS, define a foreign command with the 
      full directory specification:

         C$ local_client :== "$mydisk:[arith-directory]local_client.exe"

      Then, to run the NONDISTRIBUTED LOCAL test of the application
      on any system, enter the following command:

         C$ local_client

      To run the server of the DISTRIBUTED application, set the
      application-specific environment variable ARITHMETIC_SERVER_ENTRY 
      to the server entry name /.:/arithmetic_serverhost, where "serverhost" 
      is the name of your server system. (The server.com for OpenVMS and
      server.sh for OpenVMS/POSIX will set the environment variable)

      For the OpenVMS/POSIX environment, enter the following:

	 psx> server.sh 

	 Enter the server host name, principal and password in double 
	 quotes at the prompts.
              
      For the OpenVMS environment, enter the following:

         Define the following command:

         S$ server :== @mydisk:[arith-directory]server.com


         Then, to run the server, enter the following command:

         S$ server  

      Enter the server host name, principal and password in double quotes at 
      the prompts.

      Server exports a binding to the (CDS) Name Service. The principal 
      logging in must be a member of the "/.:/subsys/dce/cds-server" group 
      (via rgy_edit) or cell_admin to successfully export the binding.  
     
      To log in the OpenVMS environment:
	 S$ dce_login
	   (and enter the username and password)

      To log in the OpenVMS/POSIX environment:
         S> dce_login
	   (and enter the username and password)
            
            
      To run the client of the distributed application, set the
      RPC environment variable RPC_DEFAULT_ENTRY to the server
      entry name /.:/arithmetic_serverhost. The serverhost is
      the server host name, not the client host name. (The 
      client.com for OpenVMS and client.sh for OpenVMS/POSIX will 
      set the environment variable)

      For the OpenVMS/POSIX environment, enter the following:

	 psx> client.sh 
	 
         and enter client host name at the prompt, RPC_DEFAULT_ENTRY will be 
	 set

      For the OpenVMS environment, the symbol is defined in client.com.
      Define the following command:

         C$ client :== @mydisk:[arith-directory]client.com ! Enter server host name as instructed at prompt

      Then, to run the client, enter the following command:

         S$ client

         Enter the server host name as instructed at the prompt



              Application Files

              Makefile:  The Makefile contains descriptions of how the
              application is compiled in under VMS/POSIX. Use the compilation "make", to
              create all the executable files for the application. Use
	      "make clean" first to rebuild the .h, .o and executables.

              Makefile.osf1:  The Makefile for OSF/1 systems.

	      arithmetic.com: This file builds all the arithmetic
	      executables.

              client.sh:  This file is a shell script to set 
              RPC_DEFAULT_ENTRY execute the client.

              server.sh:  This file is a shell script to set the
              environment and execute the server.

              client.com:  This file is a command procedure file to set the
              environment and execute the client.

              server.com:  This file is a command procedure file to set the
              environment and execute the server.

              arithmetic.idl:  The interface definition contains the
              description of the constants, data types, and procedures
              for the interface.

              client.c:  For this application, the client initializes two
              arrays, calls the remote procedure sum_arrays, and displays
              the results of the returned array.

              procedure.c:  This is the remote procedure implementation.

              server.c:  The server is initialized with a series of RPC
              runtime calls.

              check_status.h:  The CHECK_STATUS macro is defined to
              interpret error status codes that may return from RPC
              runtime calls.




                                                                                                    * [RPCARITHMETIC.SRC]SERVER.C;1 +  , <.4   .     /  @   4 Q                          - a\   0   1    2   3      K  P   W   O 	    5   6 	@}]  7 铚}]  8          9 #ΚL!b  G  @  H  J $ N                   ?                         /* FILE NAME: server.c
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include "arithmetic.h"             /* header created by the idl compiler <CO>*/
#include "check_status.h"           /* header with the CHECK_STATUS macro   */

main ()
{
   unsigned32           status;          /* error status (nbase.h)          */
   rpc_binding_vector_t *binding_vector; /*set of binding handles(rpcbase.h)*/
   unsigned_char_t      *entry_name; /*entry name for name service (lbase.h)*/
   char *getenv();

   rpc_server_register_if(     /* register interface with the RPC runtime <CO>*/
      arithmetic_v0_0_s_ifspec,   /* interface specification (arithmetic.h) */
      NULL, 
      NULL,                     
      &status                   /* error status */
   );
   CHECK_STATUS(status, "Can't register interface\n", ABORT);

   rpc_server_use_all_protseqs(        /* establish protocol sequences    <CO>*/
      rpc_c_protseq_max_reqs_default,  /* queue size for calls   (rpcbase.h)*/
      &status
   );
   CHECK_STATUS(status, "Can't establish protocol sequences\n", ABORT);

   rpc_server_inq_bindings(   /* get set of this server's binding handles <CO>*/
      &binding_vector,
      &status
   ); 
   CHECK_STATUS(status, "Can't get binding handles\n", ABORT);

   entry_name = (unsigned_char_t *)getenv("ARITHMETIC_SERVER_ENTRY");
   rpc_ns_binding_export(       /* establish name service database entry  <CO>*/
      rpc_c_ns_syntax_default,     /* syntax of the entry name  (rpcbase.h) */
      entry_name,                  /* entry name for name service           */                                                                                                                                                                                                                                                   '                        , $      DCEVAXMUPA013.A                $	:  0  =[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.ARITHMETIC]ARITHMETIC.SAV;1                                                                    ~   ~@                                1       
      arithmetic_v0_0_s_ifspec,    /* interface specification (arithmetic.h)*/
      binding_vector,              /* the set of server binding handles     */
      NULL,
      &status 
   );
   CHECK_STATUS(status, "Can't export to name service database\n", ABORT);

   rpc_ep_register(           /* register endpoints in local endpoint map <CO>*/
      arithmetic_v0_0_s_ifspec,   /* interface specification (arithmetic.h) */
      binding_vector,             /* the set of server binding handles      */
      NULL,                     
      NULL,                       
      &status 
   );
   CHECK_STATUS(status, "Can't add address to the endpoint map\n", ABORT);
   
   rpc_binding_vector_free(         /* free set of server binding handles <CO>*/
      &binding_vector,
      &status
   ); 
   CHECK_STATUS(status, "Can't free server binding handles and vector\n", ABORT);

   puts("Listening for remote procedure calls...");
   rpc_server_listen(                 /* listen for remote calls          <CO>*/
      rpc_c_listen_max_calls_default, /*concurrent calls to server (rpcbase.h)*/
      &status
   );
   CHECK_STATUS(status, "rpc listen failed\n", ABORT);
}   
                                                                                                                                                                                                                                                                                      * [RPCARITHMETIC.SRC]SERVER.COM;1 +  , {*K   .     /  @   4 y       "                    - a\   0   1    2   3      K  P   W   O     5   6 s>@  7 ^d>@  8          9          G  @  H  J $ N                   ?                       I $! Insure DCE creds & define the entry for the server in the name service % $ if  f$trnlmn("krb5ccname") .EQS. ""  $ theny $ 	write sys$output "dce_login must be run first: The Principal needs registry group membership in subsys/dce/cds-server" 4 $	write sys$output "OR use the cell_admin principal" $ 	goto exit $ endif A $! Define the server host name as part of ARITHMETIC_SERVER_ENTRY F $ inquire host "Enter server host name inside quotes (ie. ""host"")"  5 $ ARITHMETIC_SERVER_ENTRY == "/.:/arithmetic_''host'"  $ run server $ exit:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            * [RPCARITHMETIC.SRC]SERVER.SH;1 +  , .9   .     /  @   4 p                          - a\   0   1    2   3      K  P   W   O     5   6 h|ݲ  7 ƣݲ  8          9          G  @  H  J $ N                   ?                        # Shell to check credentials and establish enviromental for the Arithmetic Server.  Burgher
# 14-Oct-1993 FWB Modified for dce_login executable & to insure dce_login was performed before server is invoked
#
CREDS=`show_log KRB5CCNAME |grep FILE`
#echo "CREDS = $CREDS"	
if [ -z "$CREDS" ]
then
	echo " dce_login must be run first: Use a principal with registry group membership in subsys/dce/cds-server"
	echo " OR use the cell_admin principal:"
	exit 1
fi
echo "Enter the arithmetic server host name:"
read SERVERHOST
ARITHMETIC_SERVER_ENTRY="/.:/arithmetic_$SERVERHOST"
export ARITHMETIC_SERVER_ENTRY
trap 'while true
do 
break
done' INT QUIT TERM EXIT
server
echo "Arithmetic Server exiting"
#
                                                                                                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS]INVENTORY.DIR;1 +  , %	/   .     /  @   4                            - -    0   1    2   3     K  P   W   O     5   6 
g   7    8          9          G  @  H   J  I                          EXPLICIT.DIR '	.     IMPLICIT.DIR /:     
INVENTORY.SAV  &	3                                                                                                                                                                                                                                                                                                                                                                                                                                                             : * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]EXPLICIT.DIR;1 +  , '	.   .     /  @   4                            - %	/    0   1    2   3     K  P   W   O     5   6 p3   7    8          9          G  @  H   J  I                                                                                                                                                                      (                         $      DCEVAXMUPA013.A                '	.  %	/  :[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]EXPLICIT.DIR;1                                                                                                  =              
INVENEXPL.SAV  	.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]INVENEXPL.SAV;1 +  , 	.   . @    /  @   4   ~  @   @      ~               - '	.    0   1    2   3      K  P   W   O A    5   6 h~e  7    8          9          G  @  H   J                                                       h, ~      
INVENEXPL.SAV                                                                                                                                                                                                p              
  INVENEXPL.SAVo  BACKUP RESD$:[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]*.*; OBJ$:INVENEXPL.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   HQe      V5.5	 	 _OPNSME:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8        @             E * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]CHECK_STATUS.H;1 +  , ,C   .     /  @   4 P       %                  - \   0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                 /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                                                                                                                           P             J * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]DO_IMPORT_BINDING.C;1 +  , B,?   .     /  @   4 R                          - \   0   1    2   3      K  P   W   O 	    5   6  !  7 Rg  8          9          G  @  H  J $ N                   ?                
            " /* FILE NAME: do_import_binding.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <string.h>  #include "inventory.h" #include "check_status.h"   # extern void do_interpret_binding();   R void do_import_binding(entry_name, binding_h) /* Get binding from name service. */P char                   entry_name[];        /* entry name to begin search     */P rpc_binding_handle_t   *binding_h;          /* a binding handle (rpcbase.h)   */ { P    unsigned32      status;                  /* error status (nbase.h)         */P    rpc_ns_handle_t import_context;          /* required to import (rpcbase.h) */P    char            protseq[20];             /* protocol sequence              */  R    rpc_ns_binding_import_begin(/* set context to import binding handles     <CO>*/P       rpc_c_ns_syntax_default,       /* use default syntax                    */P       (unsigned_char_t *)entry_name, /* begin search with this name           */P       inventory_v1_0_c_ifspec,       /* interface specification (inventory.h) */P       NULL,                          /* no optional object UUID required      */P       &import_context,               /* import context obtained               */
       &status     ); 7    CHECK_STATUS(status, "Can't begin import:", RESUME);       while(1) {   R       rpc_ns_binding_import_next( /* import a binding handle                <CO>*/P          import_context,          /* context from rpc_ns_binding_import_begin */P          binding_h,               /* a binding handle is obtained             */          &status       );       if(status != rpc_s_ok) {H          CHECK_STATUS(status, "Can't import a binding handle:", RESUME);          break;        }   R       /** application specific selection criteria (by protocol sequence) ***<CO>*/1       do_interpret_binding(*binding_h ,protseq);  P       if(strcmp(protseq, "ncacn_ip_tcp") == 0)  /* select connection protocol */          break;        else {R          rpc_binding_free(         /* free binding information not selected <CO>*/             binding_h,             &status           ); I          CHECK_STATUS(status, "Can't free binding information:", RESUME);        }     } /*end while */   R    rpc_ns_binding_import_done(   /* done with import context                <CO>*/P       &import_context,           /* obtained from rpc_ns_binding_import_begin */
       &status     );     return;     }                                                                     P             M * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]DO_INTERPRET_BINDING.C;1 +  , J,?   .     /  @   4 P                          - \   0   1    2   3      K  P   W   O 	    5   6  pV!  7 }zg  8          9          G  @  H  J $ N                   ?                         % /* FILE NAME: do_interpret_binding.c   ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */D /* Interpret binding information and return the protocol sequence */ #include <stdio.h> #include <dce/rpc.h> #include <string.h>  #include "check_status.h"   0 void do_interpret_binding(binding, protocol_seq)N rpc_binding_handle_t binding;    /* binding handle to interpret (rpcbase.h) */N char                 *protocol_seq;    /* protocol sequence to obtain       */ { N    unsigned32      status;             /* error status                      */N    unsigned_char_t *string_binding;    /* string of binding info. (lbase.h) */N    unsigned_char_t *protseq;           /* binding component of interest     */  P    rpc_binding_to_string_binding(/* convert binding information to string <CO>*/N       binding,                            /* the binding handle to convert  */N       &string_binding,                    /* the string of binding data     */
       &status     ); =    CHECK_STATUS(status, "Can't get string binding:", RESUME);   P    rpc_string_binding_parse(          /* get components of string binding <CO>*/N       string_binding,           /* the string of binding data               */O       NULL,                     /* an object UUID string is not obtained    */  N       &protseq,                 /* a protocol sequence string IS obtained   */N       NULL,                     /* a network address string is not obtained */N       NULL,                     /* an endpoint string is not obtained       */N       NULL,                     /* a network options string is not obtained */
       &status     ); ?    CHECK_STATUS(status, "Can't parse string binding:", RESUME);   *    strcpy(protocol_seq, (char *)protseq);   P    /* free all strings allocated by other runtime routines                <CO>*/.    rpc_string_free(&string_binding,  &status);/    rpc_string_free(&protseq,         &status);  
    return; }                                                             P             M * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]EXPLICIT-INVENTORY.ACF;1 +  , YU   .     /  @   4 M                         - \   0   1    2   3      K  P   W   O     5   6 z]  7 '{]  8          9 #ΚL!b  G  @  H  J $ N                   ?                         /* FILE NAME: inventory.acf (explicit version)
**  Copyright (c)                                                                                                                                                                                                                                                                                                                                                                                                                                                  )                         $      DCEVAXMUPA013.A                	.  '	.  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]INVENEXPL.SAV;1                                                             ~   ~@                          "             1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/*  This Attribute Configuration File is used in conjunction with the     */
/*  associated IDL file (inventory.idl) when the IDL compiler is invoked. */ 
[
explicit_handle           /* explicit binding method */
]
interface  inventory      /* The interface name must match the idl file */
{     
}
                                                                                @             C * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]EXPLICIT.COM;1 +  , j,;   .     /  @   4 V       j                   - \   0   1    2   3      K  P   W   O     5   6   7   8          9          G  @  H  J $ N                   ?                    $!9 $! EXPLICIT.COM -- Builds the inventory example utilizing  $!	the explicit binding method $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $!J $! Determine which compiler is being used and establish the linker options $ @DCE:DCE$CC_TEST& $ If( f$trnlnm( "dce$cc") .eqs. " " )	I $ then	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options" & $ else	options = "dce:dce.opt/options" $ endif  $!- $! Enable the universal IDL command interface  $idl := mcr dce$idl  $ " $! Compile the interface defintion5 $idl -v -cpp_cmd inventory.idl -DINV_EXP -server none  $ I $! No local build is developed for the explicit client because the remote G $! procedure implementations for the server have been developed without F $! explicit binding.  In order to test this client locally, the remoteG $! procedure implementations need to have a binding handle as the first 
 $! parameter.  $  $! Build the inventory client P $cc/g_float/include=([])  explicit_client,do_import_binding,do_interpret_bindingV $link explicit_client,do_import_binding,do_interpret_binding,inventory_cstub,'options'                                                                                                                                                    @             H * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]EXPLICIT_CLIENT.C;1 +  , U   .     /  @   4 Y       
                    - \   0   1    2   3      K  P   W   O 
    5   6  I#  7 .h  8          9          G  @  H  J $ N                   ?                /* FILE NAME: explicit_client.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */N /******* Client of the inventory application with explicit method ***********/ #include <stdio.h>   #include <stdlib.h>  #include <ctype.h>P #include "inventory.h"         /* header file created by the IDL compiler <CO>*/    extern void do_import_binding();  M char instructions[] = "Type character followed by appropriate argument(s).\n\ 7    Is part available?               a  [part_number]\n\ 7    What is part name?               n  [part_number]\n\ 7    Get part description.            d  [part_number]\n\ 7    What is part price?              p  [part_number]\n\ 7    What is part quantity?           q  [part_number]\n\ 7    What are subparts of this part?  s  [part_number]\n\ ?    Order part.                      o  part_number  quantity\n\ (    REDISPLAY                        r\n\)    EXIT                             e\n";    main() { N    part_record part;                /* structure for all data about a part  */N    part_list   *subparts;           /* pointer to parts list data structure */N    account_num account = 1234;      /* a user account number                */  B    rpc_binding_handle_t binding_h;  /* declare a binding handle */      int i, num_args, done = 0;     long result; 0    char input[100], selection[20], quantity[20];    char *strcpy();      puts(instructions);    part.number = 0;     strcpy(quantity, "");  N #ifndef LOCAL                       /* find server in name service database */9    do_import_binding("/.:/inventory_group", &binding_h);   #endif     N    while(!done) {            /* user makes selections and each is processed */;       printf("Selection: ");  fflush(stdout);  gets(input); O       num_args = sscanf(input, "%s%ld%s", selection, &(part.number), quantity);   &       switch (tolower(selection[0])) {P       case 'a': if (is_part_available(binding_h, part.number))          /*<CO>*/*                    puts("available: Yes");                 else)                    puts("available: No");                  break;P       case 'n': whatis_part_name(binding_h, part.number, part.name);    /*<CO>*//                 printf("name:%s\n", part.name);                  break;#       case 'd': part.description =  P                    get_part_description(binding_h, part.number);        /*<CO>*/?                 printf("description:\n%s\n", part.description); ,                 if(part.description != NULL)K                    free(part.description);      /* free memory allocated */                  break;  Q       case 'p': whatis_part_price(binding_h, part.number, &(part.price));/*<CO>*/ >                 printf("price:%10.2f\n", part.price.per_unit);                 break;  X       case 'q': whatis_part_quantity(binding_h, part.number, &(part.quantity)); /*<CO>*//                 if(part.quantity.units == ITEM) K                    printf("total items:%ld\n", part.quantity.total.number); 4                 else if(part.quantity.units == GRAM)N                    printf("total grams:%10.2f\n", part.quantity.total.weight);8                 else if(part.quantity.units == KILOGRAM)N                    printf("total kilos:%10.2f\n", part.quantity.total.weight);                 break;P       case 's': whatare_subparts(binding_h, part.number, &subparts);    /*<CO>*/3                 for(i = 0; i < subparts->size; i++) 9                    printf("%ld  ", subparts->numbers[i]); K                 printf("\ntotal number of subparts:%ld\n", subparts->size); N                 free(subparts);        /* free memory for conformant struct */                 break;"       case 'o': if(num_args < 3) {0                    puts("Not enough arguments");                    break;                  } E                 /* Assume KILOGRAM units and assign quantity input */ /                 part.quantity.units = KILOGRAM; <                 part.quantity.total.weight = atof(quantity);                 result =  Y                    order_part(binding_h, part.number, &(part.quantity), account);/*<CO>*/                   if(result > 0) {2                    if(part.quantity.units == ITEM)P                       printf("ordered %ld items\n", part.quantity.total.number);7                    else if(part.quantity.units == GRAM) S                       printf("ordered %10.2f grams\n", part.quantity.total.weight); ;                    else if(part.quantity.units == KILOGRAM) S                       printf("ordered %10.2f kilos\n", part.quantity.total.weight);                  } (                 else { /* error cases */@                    if(result == -1) puts("Invalid part number");B                    else if(result == -2) puts("Invalid quantity");H                    else if(result == -3) puts("Invalid account number");                 }                  break;N       case 'r':   /* redisplay selection or bad input displays instructions */,       default:  puts(instructions);  break; !       case 'e': done = 1;  break;        } /*end case */     } /* end while */ } /* end main() */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       *                        T $      DCEVAXMUPA013.A                	.  '	.  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]INVENEXPL.SAV;1                                                             ~   ~@                         F "     !                                                                                                                                       P             J * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]EXPLICIT_CLIENT.COM;1 +  , G:   .     /  @   4 ,       f                   - \   0   1    2   3      K  P   W   O     5   6  HSe  7  e  8          9          G  @  H  J $ N                   ?                            , $ rpc_default_entry == "/.:/inventory_group" $ define sys$input sys$command $ run explicit_client                                                                                                                                                                                                                                                                                                                                                                                                                         @             I * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]EXPLICIT_CLIENT.SH;1 +  , ]o:   .     /  @   4 /       [                   - \   0   1    2   3      K  P   W   O     5   6 ^e  7  e  8          9          G  @  H  J $ N                   ?             def_log RPC_DEFAULT_ENTRY "/.:/inventory_group"
explicit_client
del_log RPC_DEFAULT_ENTRY

                                                                                                                                                                                                                                                                                                                                                                                                                                     @             D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]INVENTORY.IDL;1 +  , L@   .     /  @   4 P       4                  - \   0   1    2   3      K  P   W   O 	    5   6 ؤe  7 `e  8          9          G  @  H  J $ N                   ?                  /* FILE NAME: inventory.idl 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
[
uuid(008B3C84-93A5-11C9-85B0-08002B147A61), /* universal unique identifier<CO>*/
version(1.0),                               /* version of this interface  <CO>*/
pointer_default(ptr)                        /* pointer default            <CO>*/
] interface  inventory                      /* interface name             <CO>*/
{
   const long MAX_STRING = 30;                /* constant for string size <CO>*/

   typedef long     part_num;                    /* inventory part number <CO>*/

   typedef [string] char part_name[MAX_STRING+1];/* name of part          <CO>*/

   typedef [string, ptr] char *paragraph;        /* description of part   <CO>*/

   typedef enum {
      ITEM, GRAM, KILOGRAM
   } part_units;                                 /* units of measurement  <CO>*/

   typedef struct part_price {                   /* price of part         <CO>*/
      part_units units;
      double     per_unit;
   } part_price;

   typedef union switch(part_units units) total {/* quantity of part      <CO>*/
      case ITEM:     long int number;
      case GRAM:
      case KILOGRAM: double   weight;
   } part_quantity;

   typedef struct part_list{                     /* list of part numbers  <CO>*/
      long                     size;           /* number of parts in array  */
      [size_is(size)] part_num numbers[*];     /* conformant array of parts */
   } part_list;

   typedef struct part_record {                  /* data for each part      */
      part_num      number;
      part_name     name;
      paragraph     description;
      part_price    price;
      part_quantity quantity;
      part_list     subparts;    
   } part_record;

   typedef long account_num;                     /* user account number     */

   /************************ Procedure Declarations *************************/
   boolean is_part_available(           /* return true if in inventory    <CO>*/
#ifdef INV_EXP
      [in] handle_t binding_h,
#endif
      [in] part_num number              /* input part number */
   );

   void whatis_part_name(               /* get part name from inventory   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,           /* input part number */
      [out] part_name name              /* output part name  */
   );

   paragraph get_part_description(      /* return a pointer to a string   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number
   );

   void whatis_part_price(              /* get part price from inventory    */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num   number,
      [out] part_price *price
   );

   void whatis_part_quantity(           /* get part quantity from inventory */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num      number,
      [out] part_quantity *quantity
   );

   void whatare_subparts(               /* get list of subpart numbers      */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,
      [out] part_list **subparts        /* structure containing the array <CO>*/
   );

   /* Order part from inventory with part number, quantity desired, and     */
   /* account number.  If inventory does not have enough, output lesser     */
   /* quantity ordered.  Return values:  1=ordered OK,                      */
   /* -1=invalid part, -2=invalid quantity, -3=invalid account.             */

   long order_part(   /* order part from inventory, return OK or error code */
#ifdef INV_EXP
      [in]     handle_t binding_h,
#endif
      [in]     part_num      number,
      [in,out] part_quantity *quantity,               /* quantity ordered <CO>*/
      [in]     account_num   account
   );
} /* end of interface definition */
                                                                                                                                                                                                            @             H * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]MAKEFILE.EXPLICIT;1 +  , U    .     /  @   4 \                         - \   0   1    2   3      K  P   W   O 	    5   6 \  7   8          9          G  @  H  J $ N                   ?              # FILE NAME: makefile 
# Makefile for the inventory application (explicit version)
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
# 13-Aug-1993 burgher Modified file to build under VMS/POSIX on VAX/AXP
#
# definitions for this make file 
#
APPL=inventory
DCL_IDL= dcl mcr dce\$$idl
IDL_FLAGS= -v -cpp_cmd -DINV_EXP -keep c_source
IDLCMD=$(DCL_IDL) $(IDL_FLAGS)
CFLAGS_INIT = -U VMS -I. -G
#LIBDCE=-ldce -lcma -li -ldnet        # dce and internationalization libraries
CC= c89
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`
OPTFILE= /vms/sys0/syscommon/dce\$$library/dce.opt # dce and internationalization libraries 
MAKE= make -f makefile.explicit

#
# COMPLETE BUILD of the application.
#

default: interface machine

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi
                                        
build:	ostubs client 

#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sst                                                                                                                                                                                                                                                   +                        5pK $      DCEVAXMUPA013.A                	.  '	.  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]INVENEXPL.SAV;1                                                             ~   ~@                         ے      2       ub.c
#<COMMENT>Build the interface definition from pieces shown in book
#<ENDCOMMENT>
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl
#
# STUBS BUILD
#
ostubs:	$(APPL)_cstub.o $(APPL)_sstub.o
$(APPL)_cstub.o	$(APPL)_sstub.o:	$(APPL)_cstub.c	$(APPL)_sstub.c
	$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c

#
# CLIENT BUILD 
#
client:	explicit_client
explicit_client:	explicit_client.o $(APPL)_cstub.o do_import_binding.o\
			do_interpret_binding.o
	$(CC) $(C_FLAGS) -o explicit_client explicit_client.o \
	do_import_binding.o do_interpret_binding.o \
	$(APPL)_cstub.o $(OPTFILE)

explicit_client.o:	explicit_client.c
			$(CC) $(C_FLAGS) -c explicit_client.c
do_import_binding.o:	do_import_binding.c
			$(CC) $(C_FLAGS) -c do_import_binding.c
do_interpret_binding.o:	do_interpret_binding.c
			$(CC) $(C_FLAGS) -c do_interpret_binding.c
clean:
	rm -f *.o $(APPL).h i_server explicit_client 
#<ENDCOMMENT>
                                                                                                   @             D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]MAKEFILE.OSF1;1 +  , O)   .     /  @   4 S                          - \   0   1    2   3      K  P   W   O 	    5   6 5a  7 a  8          9 #ΚL!b  G  @  H  J $ N                   ?      
            # FILE NAME: Makefile 
# Makefile for the inventory application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
#
# definitions for this make file 
#
APPL=inventory
IDLCMD=idl -v
LIBDCE=-ldce -lcma      # dce and thread libraries
CHECK=../arithmetic     # directory containing check_status.h
CFLAGS= -D_USER_THREADS_
CC= cc 


#
# COMPLETE BUILD of the application.
#
all:	local interface client server


#
# LOCAL BUILD of the application to test locally.
#
local:	interface i_client.c i_procedures.c implement_inventory.c
	   $(CC) $(CFLAGS) -DLOCAL -o local_i_client.exe i_client.c \
		  i_procedures.c implement_inventory.c
#remove the object files so they do not interfere with a real build
	   rm i_client.o i_procedures.o implement_inventory.o 


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl


#
# CLIENT BUILD 
#
client:	i_client
i_client:	i_client.o $(APPL)_cstub.o
	   $(CC) $(CFLAGS) -o i_client.exe i_client.o $(APPL)_cstub.o $(LIBDCE)


#
# SERVER BUILD 
#
server:	i_server
i_server:	$(APPL).h i_server.o i_procedures.o implement_inventory.o $(APPL)_sstub.o
	   $(CC) $(CFLAGS) -I$(CHECK) -o i_server.exe i_server.o i_procedures.o \
		   implement_inventory.o \
		   $(APPL)_sstub.o $(LIBDCE)
i_server.o:	i_server.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c i_server.c
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       : * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]IMPLICIT.DIR;1 +  , /:   .     /  @   4                            - %	/    0   1    2   3     K  P   W   O     5   6 8   7    8          9          G  @  H   J  I                 
INVENIMPL.SAV  /F                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1 +  , /F   .     /  @   4   ~           ~               - /:    0   1    2   3      K  P   W   O     5   6 H5e  7 T   8          9          G  @  H   J                                                       jg ~      
INVENIMPL.SAV                                                                                                                                                                                                i              
  INVENIMPL.SAVo  BACKUP RESD$:[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]*.*; OBJ$:INVENIMPL.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   e      V5.5	 	 _OPNSME:: 
  
  _$2$DIA24:  V5.5-2 
  ~   p                                                                                                                                   ,                        R!a3 $      DCEVAXMUPA013.A                /F  /:  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                         " "                 8        @             E * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]CHECK_STATUS.H;1 +  , ,C   .     /  @   4 P       %                  - \   0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                 /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                                                                                                                           P             J * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]DO_IMPORT_BINDING.C;1 +  , B,?   .     /  @   4 R                          - \   0   1    2   3      K  P   W   O 	    5   6  !  7 Rg  8          9          G  @  H  J $ N                   ?                
            " /* FILE NAME: do_import_binding.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <string.h>  #include "inventory.h" #include "check_status.h"   # extern void do_interpret_binding();   R void do_import_binding(entry_name, binding_h) /* Get binding from name service. */P char                   entry_name[];        /* entry name to begin search     */P rpc_binding_handle_t   *binding_h;          /* a binding handle (rpcbase.h)   */ { P    unsigned32      status;                  /* error status (nbase.h)         */P    rpc_ns_handle_t import_context;          /* required to import (rpcbase.h) */P    char            protseq[20];             /* protocol sequence              */  R    rpc_ns_binding_import_begin(/* set context to import binding handles     <CO>*/P       rpc_c_ns_syntax_default,       /* use default syntax                    */P       (unsigned_char_t *)entry_name, /* begin search with this name           */P       inventory_v1_0_c_ifspec,       /* interface specification (inventory.h) */P       NULL,                          /* no optional object UUID required      */P       &import_context,               /* import context obtained               */
       &status     ); 7    CHECK_STATUS(status, "Can't begin import:", RESUME);       while(1) {   R       rpc_ns_binding_import_next( /* import a binding handle                <CO>*/P          import_context,          /* context from rpc_ns_binding_import_begin */P          binding_h,               /* a binding handle is obtained             */          &status       );       if(status != rpc_s_ok) {H          CHECK_STATUS(status, "Can't import a binding handle:", RESUME);          break;        }   R       /** application specific selection criteria (by protocol sequence) ***<CO>*/1       do_interpret_binding(*binding_h ,protseq);  P       if(strcmp(protseq, "ncacn_ip_tcp") == 0)  /* select connection protocol */          break;        else {R          rpc_binding_free(         /* free binding information not selected <CO>*/             binding_h,             &status           ); I          CHECK_STATUS(status, "Can't free binding information:", RESUME);        }     } /*end while */   R    rpc_ns_binding_import_done(   /* done with import context                <CO>*/P       &import_context,           /* obtained from rpc_ns_binding_import_begin */
       &status     );     return;     }                                                                     P             M * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]DO_INTERPRET_BINDING.C;1 +  , J,?   .     /  @   4 P                          - \   0   1    2   3      K  P   W   O 	    5   6  pV!  7 }zg  8          9          G  @  H  J $ N                   ?                         % /* FILE NAME: do_interpret_binding.c   ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */D /* Interpret binding information and return the protocol sequence */ #include <stdio.h> #include <dce/rpc.h> #include <string.h>  #include "check_status.h"   0 void do_interpret_binding(binding, protocol_seq)N rpc_binding_handle_t binding;    /* binding handle to interpret (rpcbase.h) */N char                 *protocol_seq;    /* protocol sequence to obtain       */ { N    unsigned32      status;             /* error status                      */N    unsigned_char_t *string_binding;    /* string of binding info. (lbase.h) */N    unsigned_char_t *protseq;           /* binding component of interest     */  P    rpc_binding_to_string_binding(/* convert binding information to string <CO>*/N       binding,                            /* the binding handle to convert  */N       &string_binding,                    /* the string of binding data     */
       &status     ); =    CHECK_STATUS(status, "Can't get string binding:", RESUME);   P    rpc_string_binding_parse(          /* get components of string binding <CO>*/N       string_binding,           /* the string of binding data               */O       NULL,                     /* an object UUID string is not obtained    */  N       &protseq,                 /* a protocol sequence string IS obtained   */N       NULL,                     /* a network address string is not obtained */N       NULL,                     /* an endpoint string is not obtained       */N       NULL,                     /* a network options string is not obtained */
       &status     ); ?    CHECK_STATUS(status, "Can't parse string binding:", RESUME);   *    strcpy(protocol_seq, (char *)protseq);   P    /* free all strings allocated by other runtime routines                <CO>*/.    rpc_string_free(&string_binding,  &status);/    rpc_string_free(&protseq,         &status);  
    return; }                                                             P             L * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLEMENT_INVENTORY.C;1 +  , r,>   .     /  @   4 p      
 =                   - \   0   1    2   3      K  P   W   O     5   6  !]  7 )Sh  8          9          G  @  H  J $ N                   ?                          /* FILE NAME: implement_inventory.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* A sample implementation of an inventory.                                 */
/* For simplicity, a few inventory items are maintained in the inventory.   */
/* The valid numbers are printed when the open_inventory() procedure is     */
/* called so the user knows what numbers to test.                           */
#include <stdio.h>
#include "inventory.h"
#define MAX_PARTS    10        /* maximum number of parts in this inventory */
#define MAX_SUBPARTS 5         /* maximum number of subparts for a part     */

static part_record *rec[MAX_PARTS]; /* array of pointers for this inventory */
static inventory_is_open = 0;       /* flag is reset to non-zero when open  */

/* Data for empty record or unknown part number */
static part_record no_part = {0,"UNKNOWN"};
static part_num    no_subparts[MAX_SUBPARTS];


void open_inventory()  /***** setup inventory *******************************/
{
   int i,j;
   unsigned size;
   char *malloc(), *strcpy(), *strncpy();

   /* Allocate memory for the inventory array.  Each part gets the size of  */
   /* a part_record plus enough memory for a subpart list.  Since the       */
   /* subpart list is already defined in the part_record as an array of 1,  */
   /* the new array memory only needs to be MAX_SUBPARTS-1 in size.       */
   for(i = 0; i < MAX_PARTS; i++) {
      size = sizeof(part_record) + (sizeof(part_num) * (MAX_SUBPARTS-1));
      rec[i] = (part_record *)malloc(size);
   }
   /* assign some data to th                                                                                                                                                                                                                                                   -                         $      DCEVAXMUPA013.A                /F  /:  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                          "            e inventory array (part of an exercise machine) */
   rec[0]->number                = 102;
   strncpy((char *)rec[0]->name, "electronics display module", MAX_STRING);
   rec[0]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[0]->description,
      "The electronics display module is a liquid crystal display containing\n\
a timer, counter, metronome, and calorie counter.");
   rec[0]->price.units           = ITEM;
   rec[0]->price.per_unit        = 7.00;
   rec[0]->quantity.units        = rec[0]->price.units;
   rec[0]->quantity.total.number = 432;
   rec[0]->subparts.size         = 4;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < rec[0]->subparts.size; i++) /* values used are not relevant */
      rec[0]->subparts.numbers[i] = rec[0]->number + 1 + i;

   rec[1]->number                = 203;
   strncpy((char *)rec[1]->name, "base assembly", MAX_STRING);
   rec[1]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[1]->description,
      "The base assembly rests on the floor to stabilize the machine.\n\
The arm and bench assemblies are attached to it.");
   rec[1]->price.units           = ITEM;
   rec[1]->price.per_unit        = 85.00;
   rec[1]->quantity.units        = rec[1]->price.units;
   rec[1]->quantity.total.number = 1078;
   rec[1]->subparts.size         = 5;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < rec[1]->subparts.size; i++) /* values used are not relevant */
      rec[1]->subparts.numbers[i] = rec[1]->number + 17 + i;

   rec[2]->number                = 444;
   strncpy((char *)rec[2]->name, "ballast", MAX_STRING);
   rec[2]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[2]->description,
      "The ballast is used to counter balance the force exerted by the user.");
   rec[2]->price.units           = KILOGRAM;
   rec[2]->price.per_unit        = 1.59;
   rec[2]->quantity.units        = rec[2]->price.units;
   rec[2]->quantity.total.weight = 13456.2;
   rec[2]->subparts.size         = 0;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < MAX_SUBPARTS; i++)  /* zero out subpart array */
      rec[2]->subparts.numbers[i] = no_subparts[i];

   /* fill in rest of inventory as "empty" data */
   for(i = 3; i < MAX_PARTS; i++) {
      rec[i] = &no_part;
      for(j = 0; j < MAX_SUBPARTS; j++)
         rec[i]->subparts.numbers[j] = no_subparts[j];
   }
   puts("Part numbers in inventory:");
   for(i = 0; i < MAX_PARTS; i++)
      if(rec[i]->number > 0)
         printf("%ld\n", rec[i]->number);
   inventory_is_open = 1;
   return;
}


void close_inventory()  /**** close inventory *******************************/
{ 
   /* Undo whatever is done in open_inventory.  Free memory and so forth.   */
   /* (not implemented) */
   return;
}


int read_part_record(number, part_ptr) /** get record for this part number **/
part_num number;
part_record **part_ptr;
{
   int i;

   if(inventory_is_open == 0)
      open_inventory();
   *part_ptr = &no_part;                      /* initialize assuming no part */
   for(i = 0; i < MAX_PARTS; i++)             /* search the inventory        */
      if(rec[i]->number == number) {          /* found the part              */
         *part_ptr = rec[i];
         break;
      }
   if( (*part_ptr)->number > 0)
      return(1);  
   else                                       /* not a valid part            */
      return(0);
}


int write_part_record(part)  /*** update inventory for this part number *****/
part_record *part;
{
   int i;

   if(inventory_is_open == 0)
      open_inventory();
   for(i = 0; i < MAX_PARTS; i++)
      if(rec[i]->number == part->number) {
         rec[i] = part;   /* overwrite inventory with new data */
         return(1);
      }
   return(0);
}

/*<COMMENT> dump the part data to the screen.
static dump_part_record(index)
int index;
{
   printf("number input:%ld  part number:%ld\n", number, rec[index]->number);
   printf("part name:%s\n", rec[index]->name);
   printf("description:%s\n", rec[index]->description);
   printf("price:%f per %s\n", rec[index]->price.per_unit, (rec[index]->price.units == ITEM) ? "item" : "gram");
   printf("quantity:");
   switch(rec[index]->quantity.units) {
   case ITEM: printf("%ld items\n", rec[index]->quantity.total.number); break;
   case GRAM: printf("%f grams\n", rec[index]->quantity.total.weight); break;
   case KILOGRAM: printf("%f kilos\n", rec[index]->quantity.total.weight); break;
   }
   printf("subparts: ");
   for(i = 0; i < rec[index]->subparts.size; i++)
      printf("%ld  ", rec[index]->subparts.numbers[i]);
   printf("\n");
}<ENDCOMMENT>*/
                                                                                                                                                                                                                                                                                                                                                                                                                                                                   P             M * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLICIT-INVENTORY.ACF;1 +  , y,B   .     /  @   4 N                         - \   0   1    2   3      K  P   W   O     5   6 ]  7 =]  8          9 #ΚL!b  G  @  H  J $ N                   ?                         /* FILE NAME: inventory.acf (implicit version)
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/*  This Attribute Configuration File is used in conjunction with the     */
/*  associated IDL file (inventory.idl) when the IDL compiler is invoked. */ 
[
implicit_handle(handle_t global_binding_h)   /* implicit binding method <CO>*/
]
interface  inventory      /* The interface name must match the idl file <CO>*/
{     
}
                                                  @             C * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLICIT.COM;1 +  , L1   .     /  @   4 p       z                   - \   0   1    2   3      K  P   W   O     5   6 5iT	  7 Yn	  8          9          G  @  H  J $ N                   ?                    $!9 $! IMPLICIT.COM -- Builds the inventory example utilizing  $!	the implicit binding method $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! $!J $! Determine which compiler is being used and establish the linker options $ @DCE:DCE$CC_TEST' $ If( f$trnlnm( "dce$cc" ) .eqs. " " )	 I $ then	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options" & $ else	options = "dce:dce.opt/options" $ endif  $!- $! Enable the universal IDL command interface  $idl := mcr dce$idl  $ " $! Compile the interface defintion+ $idl -v -cpp_cmd inventory.idl -server none  $ ) $! Build the local version of the example V $cc/g_float/define=LOCAL/include=([]) implicit_client,i_procedures,implement_inventoryZ $link/exe=local_implicit_client implicit_client,i_procedures,implement_inventory,'options'J $delete implicit_client.obj;*,i_procedures.obj;*,implement_inventory.obj;* $  $! Build the inventory client p $cc/g_float/include=([]) implicit_client,do_import_binding,do_interpret_binding,i_procedures,implement_inventoryV $link implicit_client,do_import_binding,do_interpret_binding,inventory_cstub,'options'                                                                                                                                    @             H * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLICIT_CLIENT.C;1 +  , '/4   .     /  @   4 T      
                   - \   0   1    2   3      K  P   W   O 
    5   6 e  7 e  8          9          G  @  H  J $ N                   ?                /* FILE NAME:                                                                                                                                                                                                                                                    .                        
 $      DCEVAXMUPA013.A                /F  /:  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                         w "     $       implicit_client.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */N /******* Client of the inventory application with implicit method ***********/ #include <stdio.h>   #include <stdlib.h>  #include <ctype.h>  P #include "inventory.h"         /* header file created by the IDL compiler <CO>*/    extern void do_import_binding();  M char instructions[] = "Type character followed by appropriate argument(s).\n\ 7    Is part available?               a  [part_number]\n\ 7    What is part name?               n  [part_number]\n\ 7    Get part description.            d  [part_number]\n\ 7    What is part price?              p  [part_number]\n\ 7    What is part quantity?           q  [part_number]\n\ 7    What are subparts of this part?  s  [part_number]\n\ ?    Order part.                      o  part_number  quantity\n\ (    REDISPLAY                        r\n\)    EXIT                             e\n";   & rpc_binding_handle_t	global_binding_h;   main() { N    part_record part;                /* structure for all data about a part  */N    part_list   *subparts;           /* pointer to parts list data structure */N    account_num account = 1234;      /* a user account number                */      int i, num_args, done = 0;     long result; 0    char input[100], selection[20], quantity[20];    char *strcpy();      puts(instructions);    part.number = 0;     strcpy(quantity, "");  N #ifndef LOCAL                       /* find server in name service database */@    do_import_binding("/.:/inventory_group", &global_binding_h);  #endif     N    while(!done) {            /* user makes selections and each is processed */;       printf("Selection: ");  fflush(stdout);  gets(input); O       num_args = sscanf(input, "%s%ld%s", selection, &(part.number), quantity);   &       switch (tolower(selection[0])) {P       case 'a': if (is_part_available(part.number))                     /*<CO>*/*                    puts("available: Yes");                 else)                    puts("available: No");                  break;P       case 'n': whatis_part_name(part.number, part.name);               /*<CO>*//                 printf("name:%s\n", part.name);                  break;P       case 'd': part.description = get_part_description(part.number);   /*<CO>*/?                 printf("description:\n%s\n", part.description); ,                 if(part.description != NULL)K                    free(part.description);      /* free memory allocated */                  break;  P       case 'p': whatis_part_price(part.number, &(part.price));          /*<CO>*/>                 printf("price:%10.2f\n", part.price.per_unit);                 break;  P       case 'q': whatis_part_quantity(part.number, &(part.quantity));    /*<CO>*//                 if(part.quantity.units == ITEM) K                    printf("total items:%ld\n", part.quantity.total.number); 4                 else if(part.quantity.units == GRAM)N                    printf("total grams:%10.2f\n", part.quantity.total.weight);8                 else if(part.quantity.units == KILOGRAM)N                    printf("total kilos:%10.2f\n", part.quantity.total.weight);                 break;P       case 's': whatare_subparts(part.number, &subparts);               /*<CO>*/3                 for(i = 0; i < subparts->size; i++) 9                    printf("%ld  ", subparts->numbers[i]); K                 printf("\ntotal number of subparts:%ld\n", subparts->size); N                 free(subparts);        /* free memory for conformant struct */                 break;"       case 'o': if(num_args < 3) {0                    puts("Not enough arguments");                    break;                  } E                 /* Assume KILOGRAM units and assign quantity input */ /                 part.quantity.units = KILOGRAM; <                 part.quantity.total.weight = atof(quantity);T                 result = order_part(part.number, &(part.quantity), account);/*<CO>*/                  if(result > 0) {2                    if(part.quantity.units == ITEM)P                       printf("ordered %ld items\n", part.quantity.total.number);7                    else if(part.quantity.units == GRAM) S                       printf("ordered %10.2f grams\n", part.quantity.total.weight); ;                    else if(part.quantity.units == KILOGRAM) S                       printf("ordered %10.2f kilos\n", part.quantity.total.weight);                  } (                 else { /* error cases */@                    if(result == -1) puts("Invalid part number");B                    else if(result == -2) puts("Invalid quantity");H                    else if(result == -3) puts("Invalid account number");                 }                  break;N       case 'r':   /* redisplay selection or bad input displays instructions */,       default:  puts(instructions);  break; !       case 'e': done = 1;  break;        } /*end case */     } /* end while */ } /* end main() */                                                                                          P             J * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLICIT_CLIENT.COM;1 +  , G3   .     /  @   4 ,       f                   - \   0   1    2   3      K  P   W   O     5   6 @e  7 @tξe  8          9          G  @  H  J $ N                   ?                            , $ rpc_default_entry == "/.:/inventory_group" $ define sys$input sys$command $ run implicit_client                                                                                                                                                                                                                                                                                                                                                                                                                         @             I * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLICIT_CLIENT.SH;1 +  , `o<   .     /  @   4 /       [                   - \   0   1    2   3      K  P   W   O     5   6 6ue  7 @eue  8          9          G  @  H  J $ N                   ?             def_log RPC_DEFAULT_ENTRY "/.:/inventory_group"
implicit_client
del_log RPC_DEFAULT_ENTRY

                                                                                                                                                                                                                                                                                                                                                                                                                                     @             D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENTORY.IDL;1 +  , L@   .     /  @   4 P       4                  - \   0   1    2   3      K  P   W   O 	    5   6 ؤe  7 `e  8          9          G  @  H  J $ N                   ?                  /* FILE NAME: inventory.idl 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
[
uuid(008B3C84-93A5-11C9-85B0-08002B147A61), /* universal unique identifier<CO>*/
version(1.0),                               /* version of this interface  <CO>*/
pointer_default(ptr)                        /* pointer default            <CO>*/
] interface  inventory                      /* interface name             <CO>*/
{
   const long MAX_STRING = 30;                /* constant for string size <CO>*/

   typedef long     part_num;                    /* inventory part number <CO>*/

   typedef [string] char part_name[MAX_STRING+1];/* name of part          <CO>*/

   typedef [string, ptr] char *paragraph;        /* description of part   <CO>*/

   typedef enum {
      ITEM, GRAM, KILOGRAM
   } part_units;                                 /* units of measurement  <CO>*/

   typedef struct part_price {                   /* price of part         <CO>*/
      part_units units;
      double     per_unit;
   } part_price;

   typedef union switch(part_units units) total {/* quantity of part      <CO>*/
      case ITEM:     long int number;
      case GRAM:
      case KILOGRAM: double   weight;
   } part_quantity;

   typedef struct part_list{                     /* list of part numbers  <CO>*/
      long                     size;           /* number of parts in array  */
      [size_is(size)] part_num numbers[*];     /* conformant array of parts */
   } part_list;

   ty                                                                                                                                                                                                                                                   /                        ԙS $      DCEVAXMUPA013.A                /F  /:  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                          "     5       pedef struct part_record {                  /* data for each part      */
      part_num      number;
      part_name     name;
      paragraph     description;
      part_price    price;
      part_quantity quantity;
      part_list     subparts;    
   } part_record;

   typedef long account_num;                     /* user account number     */

   /************************ Procedure Declarations *************************/
   boolean is_part_available(           /* return true if in inventory    <CO>*/
#ifdef INV_EXP
      [in] handle_t binding_h,
#endif
      [in] part_num number              /* input part number */
   );

   void whatis_part_name(               /* get part name from inventory   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,           /* input part number */
      [out] part_name name              /* output part name  */
   );

   paragraph get_part_description(      /* return a pointer to a string   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number
   );

   void whatis_part_price(              /* get part price from inventory    */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num   number,
      [out] part_price *price
   );

   void whatis_part_quantity(           /* get part quantity from inventory */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num      number,
      [out] part_quantity *quantity
   );

   void whatare_subparts(               /* get list of subpart numbers      */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,
      [out] part_list **subparts        /* structure containing the array <CO>*/
   );

   /* Order part from inventory with part number, quantity desired, and     */
   /* account number.  If inventory does not have enough, output lesser     */
   /* quantity ordered.  Return values:  1=ordered OK,                      */
   /* -1=invalid part, -2=invalid quantity, -3=invalid account.             */

   long order_part(   /* order part from inventory, return OK or error code */
#ifdef INV_EXP
      [in]     handle_t binding_h,
#endif
      [in]     part_num      number,
      [in,out] part_quantity *quantity,               /* quantity ordered <CO>*/
      [in]     account_num   account
   );
} /* end of interface definition */
                                                                                                                                                                                                            @             E * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]I_PROCEDURES.C;1 +  , E0   .     /  @   4 P      
                     - \   0   1    2   3      K  P   W   O     5   6  !   7 "j  8          9          G  @  H  J $ N                   ?     
             /* FILE NAME: i_procedures.c   **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */P /*** Implementation of the remote procedures for the inventory application. ***/ #include <stdio.h> #include "inventory.h" #include <stdlib.h>  #include <string.h>  #ifdef LOCALN    /* stub support procedures are redefined for a local test of application */ #define rpc_ss_allocate mallocN    /* In a distributed RPC application, rpc_ss_free is called automatically */N    /* by the server stub. In a local test, data is not automatically freed. */ #define rpc_ss_free free #endif   int read_part_record();  int write_part_record();  % idl_boolean is_part_available(number)  part_num number; { H    part_record *part;                   /* a pointer to a part record */
    int found;      ,    found = read_part_record(number, &part);     if(found)       return(idl_true);     else        return(idl_false); }     # void whatis_part_name(number, name)  part_num  number;  part_name name;  {   H    part_record *part;                   /* a pointer to a part record */    char * strncpy();   #    read_part_record(number, &part); 9    strncpy((char *)name, (char *)part->name, MAX_STRING); 
    return; }     & paragraph get_part_description(number) part_num  number;  { H    part_record *part;                   /* a pointer to a part record */    paragraph description;     int size;    char *strcpy();  *    if( read_part_record(number, &part) ) {K       /* Allocated data that is returned to the client must be allocated */ K       /* with the rpc_ss_allocate stub support routine.                  */ 3       size = strlen((char *)part->description) + 1; ?       description = (paragraph)rpc_ss_allocate((unsigned)size); =       strcpy((char *)description, (char *)part->description);     }    else        description = NULL;     return(description);  }     % void whatis_part_price(number, price)  part_num   number; part_price  *price;  { H    part_record *part;                   /* a pointer to a part record */     $    read_part_record(number, &part); $    price->units = part->price.units;*    price->per_unit = part->price.per_unit;
    return; }     + void whatis_part_quantity(number, quantity)  part_num      number;  part_quantity *quantity; {   H    part_record *part;                   /* a pointer to a part record */     $    read_part_record(number, &part); *    quantity->units = part->quantity.units;    switch(quantity->units) {F       case ITEM: quantity->total.nump                                                                                                                                                           <.a ~      
INVENIMPL.SAV                  E0  .<  E[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]I_PROCEDURES.C;1                                                          P                                           ber = part->quantity.total.number;                  break;        case KILOGRAM:F       case GRAM: quantity->total.weight = part->quantity.total.weight;                  break;     }
    return; }     * void whatare_subparts(number, subpart_ptr) part_num  number;  part_list **subpart_ptr; { F    part_record *part;                   /* pointer to a part record */	    int i;     int size;   #    read_part_record(number, &part);   N    /* Allocated data that is output to the client must be allocated with    */N    /* the rpc_ss_allocate stub support routine.  Allocate for a part_list   */N    /* struct plus the array of subpart numbers.  Remember the part_list     */N    /* struct already has an array with one element, hence the -1.           */K    size = sizeof(part_list) + (sizeof(part_num) * (part->subparts.size-1)); ?    *subpart_ptr = (part_list *)rpc_ss_allocate((unsigned)size);       /* fill in the values */ .    (*subpart_ptr)->size = part->subparts.size;,    for(i = 0; i < (*subpart_ptr)->size; i++)=       (*subpart_ptr)->numbers[i] = part->subparts.numbers[i]; 
    return; }     2 idl_long_int order_part(number, quantity, account) part_num      number;  part_quantity *quantity; account_num   account; { >    part_record *part;           /* pointer to a part record */  5    long error = 1;  /* assume no error to start */        /* Test for valid input */ P    if( !read_part_record(number, &part) ) /* invalid part number input        */        error = -1;               P    else if(quantity->units == ITEM)       /* invalid quantity input           */9       error = (quantity->total.number <= 0) ? -2 : error; B    else if(quantity->units == GRAM || quantity->units == KILOGRAM);       error = (quantity->total.weight <= 0.0) ? -2 : error; P    /* else if()                              invalid account, not implemented */%    /*    error = -3;               */     if(error < 0)       return(error);  I    /* convert input quantity & units if units are not correct for part */ 0    if(quantity->units != part->quantity.units) {J       if(part->quantity.units == ITEM)     /* convert weight to items   */G          quantity->total.number = (idl_long_int)quantity->total.weight; J       else if(quantity->units == ITEM)     /* convert items to weight   */I          quantity->total.weight = (idl_long_float)quantity->total.number; J       else if(quantity->units == GRAM && part->quantity.units == KILOGRAM)K          quantity->total.weight /= 1000.0; /* convert grams to kilograms */ J       else if(quantity->units == KILOGRAM && part->quantity.units == GRAM)K          quantity->total.weight *= 1000.0; /* convert kilograms to grams */ -       quantity->units = part->quantity.units;     }  4    /* check if enough in inventory for this order */!                                                                                                                                                                                                                                                    0                        UԊ $      DCEVAXMUPA013.A                /F  /:  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                         z7 "     F          switch(part->quantity.units) { 
    case ITEM: >       if(part->quantity.total.number > quantity->total.number)=          /* reduce quantity in inventory by amount ordered */ ?          part->quantity.total.number -= quantity->total.number;        else {H          /* order all available and reduce quantity in inventory to 0 */>          quantity->total.number = part->quantity.total.number;)          part->quantity.total.number = 0;        }        break;    case KILOGRAM: 
    case GRAM: >       if(part->quantity.total.weight > quantity->total.weight)=          /* reduce quantity in inventory by amount ordered */ ?          part->quantity.total.weight -= quantity->total.weight;        else {J          /* order all available and reduce quantity in inventory to 0.0 */>          quantity->total.weight = part->quantity.total.weight;+          part->quantity.total.weight = 0.0;        }        break;    }     5    write_part_record(part);    /* update inventory */       return(1); /* order ok */ }                                                                                                                                                                                                                                                                                 @             H * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]MAKEFILE.IMPLICIT;1 +  , G<   .     /  @   4 \                          - \   0   1    2   3      K  P   W   O 	    5   6 H{  7   8          9          G  @  H  J $ N                   ?              # FILE NAME: makefile 
# Makefile for the inventory application 
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
# 13-Aug-1993 burgher Modified file to build under VMS/POSIX on VAX/AXP
#
# definitions for this make file 
#
APPL=inventory
DCL_IDL= dcl mcr dce\$$idl
IDL_FLAGS= -v -cpp_cmd -keep c_source
IDLCMD=$(DCL_IDL) $(IDL_FLAGS)
CFLAGS_INIT = -U VMS -I. -G
#LIBDCE=-ldce -lcma -li -ldnet        # dce and internationalization libraries
CC= c89
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`
OPTFILE= /vms/sys0/syscommon/dce\$$library/dce.opt # dce and internationalization libraries 
MAKE=make -f makefile.implicit

#
# COMPLETE BUILD of the application.
#

default: interface machine

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi
                                        
build:	local ostubs client 

#
# LOCAL BUILD of the application to test locally.
#
local:	implicit_client.c i_procedures.c implement_inventory.c
	$(CC) $(C_FLAGS) -DLOCAL -o local_implicit_client \
		implicit_client.c i_procedures.c implement_inventory.c
	#remove the object files so they do not interfere with a real build
	rm implicit_client.o 

#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c
#<COMMENT>Build the interface definition from pieces shown in book
#<ENDCOMMENT>
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl
#
# STUBS BUILD
#
ostubs:	$(APPL)_cstub.o $(APPL)_sstub.o
$(APPL)_cstub.o	$(APPL)_sstub.o:	$(APPL)_cstub.c	$(APPL)_sstub.c
	$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c

#
# CLIENT BUILD 
#
client:	implicit_client
implicit_client:	implicit_client.o $(APPL)_cstub.o do_import_binding.o\
			do_interpret_binding.o
	$(CC) $(C_FLAGS) -o implicit_client implicit_client.o \
	do_import_binding.o do_interpret_binding.o \
	$(APPL)_cstub.o $(OPTFILE)

implicit_client.o:	implicit_client.c
			$(CC) $(C_FLAGS) -c implicit_client.c
do_import_binding.o:	do_import_binding.c
			$(CC) $(C_FLAGS) -c do_import_binding.c
do_interpret_binding.o:	do_interpret_binding.c
			$(CC) $(C_FLAGS) -c do_interpret_binding.c
clean:
	rm -f *.o $(APPL).h i_server implicit_client local_implicit_client 
#<ENDCOMMENT>
                                                                                                                                                                                                                                                                                                     @             D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]MAKEFILE.OSF1;1 +  , O)   .     /  @   4 S                          - \   0   1    2   3      K  P   W   O 	    5   6 5a  7 a  8          9 #ΚL!b  G  @  H  J $ N                   ?      
            # FILE NAME: Makefile 
# Makefile for the inventory application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
#
# definitions for this make file 
#
APPL=inventory
IDLCMD=idl -v
LIBDCE=-ldce -lcma      # dce and thread libraries
CHECK=../arithmetic     # directory containing check_status.h
CFLAGS= -D_USER_THREADS_
CC= cc 


#
# COMPLETE BUILD of the application.
#
all:	local interface client server


#
# LOCAL BUILD of the application to test locally.
#
local:	interface i_client.c i_procedures.c implement_inventory.c
	   $(CC) $(CFLAGS) -DLOCAL -o local_i_client.exe i_client.c \
		  i_procedures.c implement_inventory.c
#remove the object files so they do not interfere with a real build
	   rm i_client.o i_procedures.o implement_inventory.o 


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl


#
# CLIENT BUILD 
#
client:	i_client
i_client:	i_client.o $(APPL)_cstub.o
	   $(CC) $(CFLAGS) -o i_client.exe i_client.o $(APPL)_cstub.o $(LIBDCE)


#
# SERVER BUILD 
#
server:	i_server
i_server:	$(APPL).h i_server.o i_procedures.o implement_inventory.o $(APPL)_sstub.o
	   $(CC) $(CFLAGS) -I$(CHECK) -o i_server.exe i_server.o i_procedures.o \
		   implement_inventory.o \
		   $(APPL)_sstub.o $(LIBDCE)
i_server.o:	i_server.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c i_server.c
                                                                                                                                                                                                                                                                                              R                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 1                        7u $      DCEVAXMUPA013.A                /F  /:  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                          "     W                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          2                        . $      DCEVAXMUPA013.A                /F  /:  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                         CD "     h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          3                        9 $      DCEVAXMUPA013.A                /F  /:  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                               y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ; * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1 +  , &	3   .     /  @   4   ~           ~               - %	/    0   1    2   3      K  P   W   O     5   6 Pe  7 c   8          9          G  @  H   J                                                " ~      
INVENTORY.SAV                                                                                                                                                                                                              
  INVENTORY.SAVf  BACKUP RESD$:[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]*.*; OBJ$:INVENTORY.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   (.e      V5.5	 	 _OPNSME:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8 @             < * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]CHECK_STATUS.H;1 +  , ,C   .     /  @   4 P       %                  - \   0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                          /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                                                                                                                           0             7 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]CLIENT.SH;1 +  , ,>   .     /  @   4       T                    - \   0   1    2   3      K  P   W   O     5   6 80  7 +  8          9          G  @  H  J $ N                   ?               def_log RPC_DEFAULT_ENTRY "/.:/inventory_group"
i_client
del_log RPC_DEFAULT_ENTRY

                                                                                                                                                                                                                                                                                                                                                                                                                                                        : * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]EXPLICIT.DIR;1 +  , $?   .     /  @   4                            - } %   0  1    2   3     K  P   W   O     5   6 hSd  7 H,d  8          9          G  @  H  J  I ` N                            ?      ?	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @             C * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]IMPLEMENT_INVENTORY.C;1 +  , r,>   .     /  @   4 p      
 =                   - \   0   1    2   3      K  P   W   O     5   6  !]  7 )Sh  8          9          G  @  H  J $ N                   ?                   /* FILE NAME: implement_inventory.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* A sample implementation of an inventory.                                 */
/* For simplicity, a few inventory items are maintained in the inventory.   */
/* The valid numbers are printed when the open_inventory() procedure is     */
/* called so the user knows what numbers to test.                           */
#include <stdio.h>
#include "inventory.h"
#define MAX_PARTS    10        /* maximum number of parts in this inventory */
#define MAX_SUBPARTS 5         /* maximum number of subparts for a part     */

static part_record *rec[MAX_PARTS]; /* array of pointers for this inventory */
static inventory_is_open = 0;       /* flag is reset to non-zero when open  */

/* Data for empty record or unknown part number */
static part_record no_part = {0,"UNKNOWN"};
static part_num    no_subparts[MAX_SUBPARTS];


void open_inventory()  /***** setup inventory *******************************/
{
   int i,j;
   unsigned size;
   char *malloc(), *strcpy(), *strncpy();

   /*                                                                                                                                                                                                                                                                                                                                                                                                                                                                  4                        /O0 $      DCEVAXMUPA013.A                v!  1  Q[SYSHLP.EXAMPLES.DCE]DTSS]DCE$DTS_UIT90	 d g~DD*->caL.SAV;1                                                                8                                      \kI%i`zM/Zak,wQޕנ^=vz$ Z:%,g+k9fI*Ѽi#+#Lcm	b87=rڽCf9xh\(HnvD`%}}3j
N+OM.*G C?<6a	p"$oy&+WHW90o*#$d]D\#w1x[{_B}(X22W qw63k,P}{g]ŸÚݍb(jΞNJ1u{Kݓ^T~ N(
γ-De]0w# שF7 +=eF+%6N>S@ob}Lh	JW#w><H-V}@C|`moOI
ôP ST
rCqiy[߸4C,m4*ީ-WxHJͬ&E$aPĈ,ᴙ:&RvUzߜXދ,y+'oa!/"&o֎h+j;KJ[ qk,3[W*&{UP~;@ζxp]QߐUl2;飹0XѼ-,i^ʒoSx&ShwkƌbeCH*q`H4xYzfu*Z >%5; kf!^t>}b9*J"If8Դ!pt䷏*(aa%۱1Z1'1rlO[$]vȒ!9 Քpj-Ebd[|e7" 8~@m7Bc+m,yȸz˾׻'VΥ*	\dn9
dhRהR۩@DjUz>I[sa
XzzS~2|%szpLBDħ BkOxBdRPRd@Pۂ&ut\r|Je|KJэZyZ*	KCH#-
m˼e{ė;'fдemD8'XD$hY|%ER!)afa	<תifm cQWCiB!㫋ؗNF˚VoQ7$GDvC_`XBTi
n	J=V-4tgٲaV?xq=jmuGdς잰QXsX :MBUq܋:|R΄<~z=h>Z2dq*4̱&S<|ѤS7i䜼rq={2HhB3=rI2%ȍuRƿvRHZ|yJJj++l\w|'tv4ܝhjBrQ৿b{DO7ؔR$/Liu)|䓍JӟwUeWj_Gnv#ka
tri'#;tlAKks	G}b)$_u4	Av66 <
0`jfco9a[O0ʌ9cdz *swMpΡQo%[vCL޲Iw~otni"5]Ktiz2nkxrj<&#ʢ!~ ,t~ۄ]kd6ArvD/{<Ӻ,L_0c迦:1Z܃i39I9d
qa8YUZsAHjzk"ChP9/\מ6?cÜ¨pSٙԖONFcfjK&U/:o#,m=
@2퇜z}eh`<ՎdT#%5Fmc	~#2;%zb}ot kޖ|dYe:4uRj6#/te+sJ#D[u+(+G=
H`Rmk^׼b	fx38\?b=/XY3%"xQtAǴi,B)pOL^Y>fPL$e"Bg!-8la
@F6ZKg7*
YJOtd0V[@?BE	w(K
DVjLZ졽)	Mw`gU~>e+Ehd@q6K:È&Tm]%SV_#OuE8 41vDbը!aHF^=@i!&[msDAR!yLW(fqp%y]<L9wN"3B"	6Fm[~+-6^:\\ {wx^LějvA{XgaXZ`qhH xaf%Uj=y1Ȟ0mZ!Al.}@+RyI1TJ!T>̓DWe2si+j.|K@w7uM+Pg=Q0;U'K4lq_?0r8}!庿b
fVU
}f5{v?alS
ч|tdO7Fyg2eoC9(VpKnHű{cn۰	G
Oe{vv(k8c2ӵ0on1_fMT/p``a2D>ZkQ"b]oyrJCX>K+7=fGa7-cG^5rJyD)v`iǰmO_ 8riqd?%H*b6&R WM%KX<1N,	I*I?QN7YC[w ,EsCo=zo~B#e74^̨DjZ3 (<椃D9<"l?r0.%>Ϡl⠏y8^_ف՞aɖ|
=ŨՖ<BwuǠ+]g˨a1mz9u6(c=H]TSiɗ]CXk `KyχE
Q@!l0ʞ85EotqSuϧvzF\$9gGBȀ-&b$D5+Pƚ9kS|"^t7
,9/L`۵@Z-aDڹ_sQ4ݝL	
0<3Z8zUhO/D)j~?TQNw#\ )mE# dRgy`o>oicO8-oL4Ƈl%PCw浴iA*`ؿduL_9vG/bun6'4цQ`3X(_*9IemNyI[z\Z*·e9 ؞x<{lMmۘ5t+	knW}D1tsREn[_}kxUMm#n~=Q_#tYEIv
!qpI-v;9|i!7owQvqߚ1
[|5yҗ,xByNv*mVRmu
.FlNt8?ma5
3jUA@*̞l؇⩼=:蜱n9vďTW2~ M̹L9Ub5e3_фJirZm{U,Q鼮3T鎮OI6>!x Hrѵh6Fu(mˏ,xDk)tDz͔cBc4&L]XV;dV_
Dd vnW|E/kL#i',ei浿$<'t̚غϊb }<hё73C1x@xt"wz͡ׯ-p$.wZ۰yz1g`JM?Tyb
Z1\B|ekH"O<_0hl?Yc<zak$?*;9m ئP31BSzZJG&[xAXӟWO	#a7R!i#/+ӽحGIy)aR(OGߖEV+*C'N*gpe#s.-S<|}G\@:= I/e`BN
;OC2]wE{
P󸞡Y
0TFY+^
K*AЫ)W{n4^&96<0
+2$Z5z=u?|_ȭ{VuIڍ)pͩk>Qdk-0\NP,CP
[ZU_*nYҖwqT2o1!8'8Owze;'!f}*\0I-gVFT-fMP^}rEKfIr7˻ǯ&8|}D*Tc;SH龾c N=EŦfh}jع %E:'Pkei|G'EJ7 s7*-mLRŻ0ؖ(71|)̕4QN*b#=lxv0γ$c?&8V,=ߞr [vv-Ff=T!(|(jjcc~;>2Gr<u閍l?ɮHseC.bZhYdFm"W*ro!kfj#bZ}qmNc(VBUӔ_a})*$|!|@ŷ2e]Aw	|
橒9x"39k]?[)Էhp,48FAQvH~)}
dI/
BZHP:ݎ0kL@]<Ա
3Zm
n5Deo.Q, 9.gnpH$)IH_1@DysfacrSG/P5	p'bvspxp3:c~%r57k
:%8nvȏk{2>KdUsrqKR5)z3N]P{!~t߁
JdD#6GУ%n@NS@q*>(D"EFMF0C/~A::48Z9'8IKy1
R
6=H͕:ުlzy4*cDM0b=ٽQٳnF,޲6z^Mo"D&qaoqw	1uԾ [*_ƴ+7<)/{cƀbN?<a4vlOHҘGP գ8IUH0L3
VPS-LZkϾ0oyR-9Z(-'щA歉}A%!bOt)/p{b٥2r=c	>P*!"	TzR9D7q7Cj&\ˁEMx]wgT'?Z[E=]h.3z:c=C/>1`2M;Qz0˺;sK5{DU;͉2Atq	=m}GBUsꄫ1b Pd@r}ѡ4ֽI<VZW¡TTc+z,1.j
# O=G?s }K/_9TFV\:6	f
2#x?;Wj3I.
:Dvh9Xky&рm5+omG%7Շ:'$j$QJ dYJȹ_.Snb	u7/Z7o鋊 rMrHӟd#[65-4KP5ͬ	S(cj%;NZFާNh79p+~ڎadJHJϮ3:Ve;a7$?1nday6׭8GڏSpUˊ&q:ia엋
f)"Bdo*nDcJ(^>.fkcG9YR1o5b[ȀƏ7<JUc2ѳepߠ@t}.(agTT:Tp4l%'3yh+(\"{x9V;qUeͽe;ywޡ<sN c/$K,ڰ'tLҬXR3s"(iVVT.tȖ<D
g~_͉7k$(2?$Nwܫ
)v1b(sIF
ڢq3Q_	Ā#xXU  ~&v6\~軵`ʆ&Āqb{G+˝(4D(ܨklèwo3
AߡT1 kz&A/APspt ::}ޛvysS:'ڬi/hxwƟI$SudOB n@	8'A4(%{B%~$k?o#\r\85s{1x頷ܓس?#J-6/3؛{KufU`:8OMA'IA۫z

vVJyyU}|<ڮ]h*
?&MX]囋Q"ju;FT!	0
 &(W.>7m Աζ_GƢSq\eFیкx:&DIQro	|xs%{TRaK$k h6t[fiT\:{p?.IܴU4)XjT:.z_(/.',fF_Ăjc幾hƛ"5n9N8}`M
zCdpSgҞ>G,0%<`m\Ą;PqޯHZjS87tS0<'>0^'XUT` 8L'f$4jzM Ք++`XXGTy!rl\j-rGf?s
[TadOM"#4P$@Mۍ{n(.AeGs-\K?x)2Lk.C/;C׏PB4CO`ՎS,iJvOZʚI-.y~Qg}Żj6/EU2GFq24碚<[X-mdQ5GpoQhquzݨ`|%H=d.`Gfh.Axxv_.vgpi.19'b'kŤLG^_784qFBJetg oΛK18EK
WY kVGb~~:")c I_?2XeAq(R	%e$\xUb(6JNc͈#`:HHzC  Wp@V(AE h2\]\x~lE6h)1 p#|K͔3M%eioU?N;'0hw^eO<?I7ڂ$yp1/+&PHy4^HH蓱jzne[H93ú&doeA;JЭEE3]𚒷u*l<cmqulܒ >xR3JѽbMnơ5\"[S2!wkab1MOkgtjm̊EwGkhG|3>ٔWc??XX\4o@'[K耷+Pj1/d)Cv/5n7)	n@ӭEA)=ۼ)szlj+r3I5TSC'7@^y<ڴuH:eZ+DُHwǹ&7gGWm
.g~L6`$swO mAaemm<k?TNS26NzуyGɁ^i{I %>Wj6E8lNxj}4aoVL &e(+esPI rXnvc4@os,\^nnla$s`sYWG1/(]Dobt75.5-2 
  ~   p                                                                                                                                   5                        =k $      DCEVAXMUPA013.A                &	3  %	/  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                         k "             Allocate memory for the inventory array.  Each part gets the size of  */
   /* a part_record plus enough memory for a subpart list.  Since the       */
   /* subpart list is already defined in the part_record as an array of 1,  */
   /* the new array memory only needs to be MAX_SUBPARTS-1 in size.       */
   for(i = 0; i < MAX_PARTS; i++) {
      size = sizeof(part_record) + (sizeof(part_num) * (MAX_SUBPARTS-1));
      rec[i] = (part_record *)malloc(size);
   }
   /* assign some data to the inventory array (part of an exercise machine) */
   rec[0]->number                = 102;
   strncpy((char *)rec[0]->name, "electronics display module", MAX_STRING);
   rec[0]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[0]->description,
      "The electronics display module is a liquid crystal display containing\n\
a timer, counter, metronome, and calorie counter.");
   rec[0]->price.units           = ITEM;
   rec[0]->price.per_unit        = 7.00;
   rec[0]->quantity.units        = rec[0]->price.units;
   rec[0]->quantity.total.number = 432;
   rec[0]->subparts.size         = 4;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < rec[0]->subparts.size; i++) /* values used are not relevant */
      rec[0]->subparts.numbers[i] = rec[0]->number + 1 + i;

   rec[1]->number                = 203;
   strncpy((char *)rec[1]->name, "base assembly", MAX_STRING);
   rec[1]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[1]->description,
      "The base assembly rests on the floor to stabilize the machine.\n\
The arm and bench assemblies are attached to it.");
   rec[1]->price.units           = ITEM;
   rec[1]->price.per_unit        = 85.00;
   rec[1]->quantity.units        = rec[1]->price.units;
   rec[1]->quantity.total.number = 1078;
   rec[1]->subparts.size         = 5;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < rec[1]->subparts.size; i++) /* values used are not relevant */
      rec[1]->subparts.numbers[i] = rec[1]->number + 17 + i;

   rec[2]->number                = 444;
   strncpy((char *)rec[2]->name, "ballast", MAX_STRING);
   rec[2]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[2]->description,
      "The ballast is used to counter balance the force exerted by the user.");
   rec[2]->price.units           = KILOGRAM;
   rec[2]->price.per_unit        = 1.59;
   rec[2]->quantity.units        = rec[2]->price.units;
   rec[2]->quantity.total.weight = 13456.2;
   rec[2]->subparts.size         = 0;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < MAX_SUBPARTS; i++)  /* zero out subpart array */
      rec[2]->subparts.numbers[i] = no_subparts[i];

   /* fill in rest of inventory as "empty" data */
   for(i = 3; i < MAX_PARTS; i++) {
      rec[i] = &no_part;
      for(j = 0; j < MAX_SUBPARTS; j++)
         rec[i]->subparts.numbers[j] = no_subparts[j];
   }
   puts("Part numbers in inventory:");
   for(i = 0; i < MAX_PARTS; i++)
      if(rec[i]->number > 0)
         printf("%ld\n", rec[i]->number);
   inventory_is_open = 1;
   return;
}


void close_inventory()  /**** close inventory *******************************/
{ 
   /* Undo whatever is done in open_inventory.  Free memory and so forth.   */
   /* (not implemented) */
   return;
}


int read_part_record(number, part_ptr) /** get record for this part number **/
part_num number;
part_record **part_ptr;
{
   int i;

   if(inventory_is_open == 0)
      open_inventory();
   *part_ptr = &no_part;                      /* initialize assuming no part */
   for(i = 0; i < MAX_PARTS; i++)             /* search the inventory        */
      if(rec[i]->number == number) {          /* found the part              */
         *part_ptr = rec[i];
         break;
      }
   if( (*part_ptr)->number > 0)
      return(1);  
   else                                       /* not a valid part            */
      return(0);
}


int write_part_record(part)  /*** update inventory for this part number *****/
part_record *part;
{
   int i;

   if(inventory_is_open == 0)
      open_inventory();
   for(i = 0; i < MAX_PARTS; i++)
      if(rec[i]->number == part->number) {
         rec[i] = part;   /* overwrite inventory with new data */
         return(1);
      }
   return(0);
}

/*<COMMENT> dump the part data to the screen.
static dump_part_record(index)
int index;
{
   printf("number input:%ld  part number:%ld\n", number, rec[index]->number);
   printf("part name:%s\n", rec[index]->name);
   printf("description:%s\n", rec[index]->description);
   printf("price:%f per %s\n", rec[index]->price.per_unit, (rec[index]->price.units == ITEM) ? "item" : "gram");
   printf("quantity:");
   switch(rec[index]->quantity.units) {
   case ITEM: printf("%ld items\n", rec[index]->quantity.total.number); break;
   case GRAM: printf("%f grams\n", rec[index]->quantity.total.weight); break;
   case KILOGRAM: printf("%f kilos\n", rec[index]->quantity.total.weight); break;
   }
   printf("subparts: ");
   for(i = 0; i < rec[index]->subparts.size; i++)
      printf("%ld  ", rec[index]->subparts.numbers[i]);
   printf("\n");
}<ENDCOMMENT>*/
                                                                                                                                                                                                                                                                                                                                                                                                                                                                               : * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]IMPLICIT.DIR;1 +  , .<   .     /  @   4                            - } %   0  1    2   3     K  P   W   O     5   6 Gd  7 (OUd  8          9          G  @  H  J  I ` N                            ?      ?	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @             ; * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.COM;1 +  , ,/9   .     /  @   4 U                           - \   0   1    2   3      K  P   W   O 	    5   6 E8<w  7 f<w  8          9          G  @  H  J $ N                   ?               
             $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! $! Abstract:8 $!	INVENTORY.COM -- Builds the inventory example program $! $! Modification History:- $! 	26-Aug-1993 FWB Modified for VMS DCE V1.1  $!- $@DCE:DCE$CC_TEST                             K $! Determine which compiler is being used and establish the linker options  ' $ If( f$trnlnm("dce$cc") .eqs. " " )    H $ Then	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options' $ Else	options = "dce:dce.opt/options"   $ Endif  $!- $! Enable the universal IDL command interface  $idl := mcr dce$idl " $! Compile the interface defintion $idl -cpp_cmd inventory.idl  $! $!cc := cc'f$trnlnm("dce$cc")' $!) $! Build the local version of the example U $cc/g_float/define=("CC$mixed_float",LOCAL) i_client,i_procedures,implement_inventory L $link/exe=local_i_client i_client,i_procedures,implement_inventory,'options' $!C $delete i_client.obj;*,i_procedures.obj;*,implement_inventory.obj;*  $! $! Build the inventory client , $cc/g_float/define="CC$mixed_float" i_client, $link i_client,inventory_cst                                                                                                                                                                                                                                                   6                         $      DCEVAXMUPA013.A                &	3  %	/  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                         T "            ub.obj,'options' $! $! Build the inventory server  $cc/g_float i_server, $cc/g_float i_procedures,implement_inventoryI $link i_server,i_procedures,implement_inventory,inventory_sstub,'options'  $!                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @             ; * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.IDL;1 +  , L@   .     /  @   4 P       4                  - \   0   1    2   3      K  P   W   O 	    5   6 ؤe  7 `e  8          9          G  @  H  J $ N                   ?                           /* FILE NAME: inventory.idl 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
[
uuid(008B3C84-93A5-11C9-85B0-08002B147A61), /* universal unique identifier<CO>*/
version(1.0),                               /* version of this interface  <CO>*/
pointer_default(ptr)                        /* pointer default            <CO>*/
] interface  inventory                      /* interface name             <CO>*/
{
   const long MAX_STRING = 30;                /* constant for string size <CO>*/

   typedef long     part_num;                    /* inventory part number <CO>*/

   typedef [string] char part_name[MAX_STRING+1];/* name of part          <CO>*/

   typedef [string, ptr] char *paragraph;        /* description of part   <CO>*/

   typedef enum {
      ITEM, GRAM, KILOGRAM
   } part_units;                                 /* units of measurement  <CO>*/

   typedef struct part_price {                   /* price of part         <CO>*/
      part_units units;
      double     per_unit;
   } part_price;

   typedef union switch(part_units units) total {/* quantity of part      <CO>*/
      case ITEM:     long int number;
      case GRAM:
      case KILOGRAM: double   weight;
   } part_quantity;

   typedef struct part_list{                     /* list of part numbers  <CO>*/
      long                     size;           /* number of parts in array  */
      [size_is(size)] part_num numbers[*];     /* conformant array of parts */
   } part_list;

   typedef struct part_record {                  /* data for each part      */
      part_num      number;
      part_name     name;
      paragraph     description;
      part_price    price;
      part_quantity quantity;
      part_list     subparts;    
   } part_record;

   typedef long account_num;                     /* user account number     */

   /************************ Procedure Declarations *************************/
   boolean is_part_available(           /* return true if in inventory    <CO>*/
#ifdef INV_EXP
      [in] handle_t binding_h,
#endif
      [in] part_num number              /* input part number */
   );

   void whatis_part_name(               /* get part name from inventory   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,           /* input part number */
      [out] part_name name              /* output part name  */
   );

   paragraph get_part_description(      /* return a pointer to a string   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number
   );

   void whatis_part_price(              /* get part price from inventory    */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num   number,
      [out] part_price *price
   );

   void whatis_part_quantity(           /* get part quantity from inventory */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num      number,
      [out] part_quantity *quantity
   );

   void whatare_subparts(               /* get list of subpart numbers      */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,
      [out] part_list **subparts        /* structure containing the array <CO>*/
   );

   /* Order part from inventory with part number, quantity desired, and     */
   /* account number.  If inventory does not have enough, output lesser     */
   /* quantity ordered.  Return values:  1=ordered OK,                      */
   /* -1=invalid part, -2=invalid quantity, -3=invalid account.             */

   long order_part(   /* order part from inventory, return OK or error code */
#ifdef INV_EXP
      [in]     handle_t binding_h,
#endif
      [in]     part_num      number,
      [in,out] part_quantity *quantity,               /* quantity ordered <CO>*/
      [in]     account_num   account
   );
} /* end of interface definition */
                                                                                                                                                                                                            0             8 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]I_CLIENT.C;1 +  , E&   .     /  @   4 T      
                     - \   0   1    2   3      K  P   W   O 
    5   6    7 
j  8          9          G  @  H  J $ N                   ?               /* FILE NAME: i_client.c   **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */N /******************** Client of the inventory application *******************/ #include <stdio.h>   #include <stdlib.h> P #include "inventory.h"         /* header file created by the IDL compiler <CO>*/ #include <ctype.h>  M char instructions[] = "Type character followed by appropriate argument(s).\n\ 7    Is part available?               a  [part_number]\n\ 7    What is part name?               n  [part_number]\n\ 7    Get part description.            d  [part_number]\n\ 7    What is part price?              p  [part_number]\n\ 7    What is part quantity?           q  [part_number]\n\ 7    What are subparts of this part?  s  [part_number]\n\ ?    Order part.                      o  part_number  quantity\n\ (    REDISPLAY                        r\n\)    EXIT                             e\n";    main() { N    part_record part;                /* structure for all data about a part  */N    part_list   *subparts;           /* pointer to parts list data structure */N    account_num account = 1234;      /* a user account number                */      int i, num_args, done = 0;     long result; 0    char input[100], selection[20], quantity[20];    char *strcpy();      puts(instructions);    part.number = 0;     strcpy(quantity, "");N    while(!done) {            /* user makes selections and each is processed */;       printf("Selection: ");  fflush(stdout);  gets(input); O       num_args = sscanf(input, "%s%ld%s", selection, &(part.number), quantity);   &       switch (tolower(selection[0])) {P       case 'a': if (is_part_available(part.number))                     /*<CO>*/*                    puts("available: Yes");                 else)                    puts("available: No");                  break;P       case 'n': whatis_part_name(part.number, part.name);               /*<CO>*//                 printf("name:%s\n", part.name);                  break;P       case 'd': part.description = get_part_description(part.number);   /*<CO>*/?                 printf("description:\n%s\n", part.description); ,                 if(part.description != NULL)K                    free(part.description);      /* free memory allocated */                  break;  P       case 'p': whatis_part_price(part.number, &(part.price));          /*<CO>*/>                 printf("price:%10.2f\n", part.price.per_unit);                 break;  P       case 'q': whatis_part_quantity(part.number, &(part.quantity));    /*<CO>*//                 if(part.quantity.units == ITEM) K                    printf("total items:%ld\n", part.quantity.total.number); 4                 else if(part.quantity.units == GRAM)N                    printf("total grams:%10.2f\n", part.quantity.total.weight);8                 else if(part.quantity.units == KILOGRAM)N                    printf("total kilos:%10.2f\n", part.quantity.total.weight);                 break;P       case 's': whatare_subparts(part.number, &subparts);               /*<CO>*/3                 for(i = 0; i < subparts->size; i++) 9                    printf("%ld  ", subparts->numbers[i]); K                 printf("\ntotal number of                                                                                                                                                                                                                                                    7                        qɡ $      DCEVAXMUPA013.A                &	3  %	/  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                         R "     -       subparts:%ld\n", subparts->size); N                 free(subparts);        /* free memory for conformant struct */                 break;"       case 'o': if(num_args < 3) {0                    puts("Not enough arguments");                    break;                  } E                 /* Assume KILOGRAM units and assign quantity input */ /                 part.quantity.units = KILOGRAM; <                 part.quantity.total.weight = atof(quantity);T                 result = order_part(part.number, &(part.quantity), account);/*<CO>*/                  if(result > 0) {2                    if(part.quantity.units == ITEM)P                       printf("ordered %ld items\n", part.quantity.total.number);7                    else if(part.quantity.units == GRAM) S                       printf("ordered %10.2f grams\n", part.quantity.total.weight); ;                    else if(part.quantity.units == KILOGRAM) S                       printf("ordered %10.2f kilos\n", part.quantity.total.weight);                  } (                 else { /* error cases */@                    if(result == -1) puts("Invalid part number");B                    else if(result == -2) puts("Invalid quantity");H                    else if(result == -3) puts("Invalid account number");                 }                  break;N       case 'r':   /* redisplay selection or bad input displays instructions */,       default:  puts(instructions);  break; !       case 'e': done = 1;  break;        } /*end case */     } /* end while */ } /* end main() */                                                                                                                                                                                                                                                                                                                                                      @             : * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]I_CLIENT.COM;1 +  , E0   .     /  @   4 ,       ^                   - \   0   1    2   3      K  P   W   O     5   6 o  7  4o  8          9          G  @  H  J $ N                   ?                            , $ rpc_default_entry == "/.:/inventory_group" $ define sys$input sys$command $ run i_client                                                                                                                                                                                                                                                                                                                                                                                                                                @             < * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]I_PROCEDURES.C;1 +  , E0   .     /  @   4 P      
                     - \   0   1    2   3      K  P   W   O     5   6  !   7 "j  8          9          G  @  H  J $ N                   ?                           /* FILE NAME: i_procedures.c   **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */P /*** Implementation of the remote procedures for the inventory application. ***/ #include <stdio.h> #include "inventory.h" #include <stdlib.h>  #include <string.h>  #ifdef LOCALN    /* stub support procedures are redefined for a local test of application */ #define rpc_ss_allocate mallocN    /* In a distributed RPC application, rpc_ss_free is called automatically */N    /* by the server stub. In a local test, data is not automatically freed. */ #define rpc_ss_free free #endif   int read_part_record();  int write_part_record();  % idl_boolean is_part_available(number)  part_num number; { H    part_record *part;                   /* a pointer to a part record */
    int found;      ,    found = read_part_record(number, &part);     if(found)       return(idl_true);     else        return(idl_false); }     # void whatis_part_name(number, name)  part_num  number;  part_name name;  {   H    part_record *part;                   /* a pointer to a part record */    char * strncpy();   #    read_part_record(number, &part); 9    strncpy((char *)name, (char *)part->name, MAX_STRING); 
    return; }     & paragraph get_part_description(number) part_num  number;  { H    part_record *part;                   /* a pointer to a part record */    paragraph description;     int size;    char *strcpy();  *    if( read_part_record(number, &part) ) {K       /* Allocated data that is returned to the client must be allocated */ K       /* with the rpc_ss_allocate stub support routine.                  */ 3       size = strlen((char *)part->description) + 1; ?       description = (paragraph)rpc_ss_allocate((unsigned)size); =       strcpy((char *)description, (char *)part->description);     }    else        description = NULL;     return(description);  }     % void whatis_part_price(number, price)  part_num   number; part_price  *price;  { H    part_record *part;                   /* a pointer to a part record */     $    read_part_record(number, &part); $    price->units = part->price.units;*    price->per_unit = part->price.per_unit;
    return; }     + void whatis_part_quantity(number, quantity)  part_num      number;  part_quantity *quantity; {   H    part_record *part;                   /* a pointer to a part record */     $    read_part_record(number, &part); *    quantity->units = part->quantity.units;    switch(quantity->units) {F       case ITEM: quantity->total.number = part->quantity.total.number;                  break;        case KILOGRAM:F       case GRAM: quantity->total.weight = part->quantity.total.weight;                  break;     }
    return; }     * void whatare_subparts(number, subpart_ptr) part_num  number;  part_list **subpart_ptr; { F    part_record *part;                   /* pointer to a part record */	    int i;     int size;   #    read_part_record(number, &part);   N    /* Allocated data that is output to the client must be allocated with    */N    /* the rpc_ss_allocate stub support routine.  Allocate for a part_list   */N    /* struct plus the array of subpart numbers.  Remember the part_list     */N    /* struct already has an array with one element, hence the -1.           */K    size = sizeof(part_list) + (sizeof(part_num) * (part->subparts.size-1)); ?    *subpart_ptr = (part_list *)rpc_ss_allocate((unsigned)size);       /* fill in the values */ .    (*subpart_ptr)->size = part->subparts.size;,    for(i = 0; i < (*subpart_ptr)->size; i++)=       (*subpart_ptr)->numbers[i] = part->subparts.numbers[i]; 
    return; }     2 idl_long_int order_part(number, quantity, account) part_num      number;  part_quantity *quantity; account_num   account; { >    part_record *part;           /* pointer to a part record */  5    long error = 1;  /* assume no error to start */        /* Test for valid input */ P    if( !read_part_record(number, &part) ) /* invalid part number input        */        error = -1;               P    else if(quantity->units == ITEM)       /* invalid quantity input           */9       error = (quantity->total.number <= 0) ? -2 : error; B    else if(quantity->units == GRAM || quantity->units == KILOGRAM);       error = (quantity->total.weight <= 0.0) ? -2 : error; P    /* else if()                              invalid account, not implemented */%    /*    error = -3;               */     if(error < 0)       return(error);  I    /* convert input quantity & units if units are not correct for part */ 0    if(quantity->units != part->quantity.units) {J       if(part->quantity.units == ITEM)     /* convert weight to items   */G          quantity->total.number = (idl_long_int)quantity->total.weight; J       else if(quantity->units == ITEM)     /* convert items to weight   */I          quantity->total.weight = (idl_long_float)quantity->total.number; J       else if(quantity->units == GRAM && part->quantity.units == KILOGRAM)K          quantity->total.weight /= 1000.0; /* convert grams to kilograms */ J       else if(quantity->units == KILOGRAM && part->quantity.units == GRAM)K          quantity->total.weight *= 1000.0; /* convert kilograms to grams */ -       quantity->units = part->quantity.units;     }  4    /* check if enough in inventory for this order */!    switch(part->quantity.units) { 
    case ITEM: >       if(part->quantity.total.number > quantity->total.number)=          /* reduce quantity in inventory by amount ordered */ ?          part->quantity.total.number -= quantity->total.numb                                                                                                                                                                                                                                                   8                        z, $      DCEVAXMUPA013.A                &	3  %	/  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                         cM "     >       er;        else {H          /* order all available and reduce quantity in inventory to 0 */>          quantity->total.number = part->quantity.total.number;)          part->quantity.total.number = 0;        }        break;    case KILOGRAM: 
    case GRAM: >       if(part->quantity.total.weight > quantity->total.weight)=          /* reduce quantity in inventory by amount ordered */ ?          part->quantity.total.weight -= quantity->total.weight;        else {J          /* order all available and reduce quantity in inventory to 0.0 */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ^ ~      
INVENTORY.SAV                  E0  } %  <[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]I_PROCEDURES.C;1                                                                   P                                    
       >          quantity->total.weight = part->quantity.total.weight;+          part->quantity.total.weight = 0.0;        }        break;    }     5    write_part_record(part);    /* update inventory */       return(1); /* order ok */ }                                                                                                                                                                                                                                                                                 0             8 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]I_SERVER.C;1 +  , O-   .     /  @   4 V       '                   - \   0   1    2   3      K  P   W   O     5   6 折  7 囶折  8          9          G  @  H  J $ N                   ?              /* FILE NAME: i_server.c 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#if defined(VMS)
#include <descrip.h>
#include <ssdef.h>
#include <lnmdef.h>
#include <starlet.h>
#endif
#include <ctype.h>
#include "inventory.h"              /* header created by the IDL compiler <CO>*/
#include "check_status.h"           /* contains the CHECK_STATUS macro      */
#define STRINGLEN 50

void open_inventory();
void close_inventory();

main (argc, argv)
int argc;
char *argv[];
{
   unsigned32           status;          /* error status (nbase.h)        <CO>*/
                                         /* RPC vectors                   <CO>*/
   rpc_binding_vector_t *binding_vector; /* binding handle list (rpcbase.h) */
   rpc_protseq_vector_t *protseq_vector; /*protocol sequence list(rpcbase.h)*/

   char entry_name[STRINGLEN];           /* name service entry name         */
   char group_name[STRINGLEN];           /* name service group name         */
   char annotation[STRINGLEN];           /* annotation for endpoint map     */
   static char hostname[STRINGLEN];  
   char *strcpy(), *strcat();    
   /************************** REGISTER INTERFACE ***************************/
   rpc_server_register_if(                                             /* <CO>*/
      inventory_v1_0_s_ifspec,     /* interface specification (inventory.h) */
      NULL,
      NULL,
      &status
   );
   CHECK_STATUS(status, "Can't register interface:", ABORT);            /*<CO>*/
  
   /****************** CREATING SERVER BINDING INFORMATION ******************/
   if(argc > 1) {
      rpc_server_use_protseq(             /* use a protocol sequence      <CO>*/
         (unsigned_char_t *)argv[1],      /* the input protocol sequence    */
         rpc_c_protseq_max_calls_default, /* (rpcbase.h)                    */
         &status
      );    
      CHECK_STATUS(status, "Can't use this protocol sequence:", ABORT);
   }
   else {
      puts("You can invoke the server with a protocol sequence argument.");
      rpc_server_use_all_protseqs(        /* use all protocol sequences   <CO>*/
         rpc_c_protseq_max_calls_default, /* (rpcbase.h)                    */
         &status
      );    
      CHECK_STATUS(status, "Can't register protocol sequences:", ABORT);
   }

   rpc_server_inq_bindings(     /* get all binding information for server <CO>*/
      &binding_vector,
      &status
   );
   CHECK_STATUS(status, "Can't get binding information:", ABORT);

   /*************************** ADVERTISE SERVER ****************************/

   strcpy(entry_name, "/.:/inventory_");

    /*
     * get the host name and initialize the entry name in the table
     */

#if defined(VMS)
    /*
     *  Use sys$trnlnm() to remove dependency on UCX.
     *  NOTE that we do not use sys$getsyi() since not every system
     *  have SCSNODE defined.
     */
{
    $DESCRIPTOR (sys_table, "LNM$SYSTEM_TABLE");
    $DESCRIPTOR (dnet_name,  "SYS$NODE");
    $DESCRIPTOR (inet_name,  "UCX$INET_HOST");
    static int	hostname_len;
    long lnm_status;

    struct
    {
          short   buf_len;
          short   item_code;
          char    *buf_addr;
          int     *ret_len;
          int     *null_item;
    } itmlst = {
                STRINGLEN,
                LNM$_STRING,
                hostname,
                &hostname_len,
                NULL
               };

    lnm_status = sys$trnlnm (0, &sys_table, &dnet_name, 0, &itmlst);

    if (lnm_status != SS$_NORMAL)
    {
       lnm_status = sys$trnlnm (0, &sys_table, &inet_name, 0, &itmlst);
       if (lnm_status != SS$_NORMAL)
       {
       fprintf (stderr, "Failed to execute SYS$TRNLNM\n");
       exit (lnm_status);
       }
    }
    else
       /*
        *  Remove trailing "::" for Decnet
        */
        hostname [hostname_len - 2] = '\0';
}
#else
   gethostname(hostname, STRINGLEN);
#endif
   strcat(entry_name, hostname);
   rpc_ns_binding_export(          /* export to a name service database   <CO>*/
      rpc_c_ns_syntax_default,     /* syntax of entry name (rpcbase.h)      */
      (unsigned_char_t *)entry_name, /* name of entry in name service       */
      inventory_v1_0_s_ifspec,     /* interface specification (inventory.h) */
      binding_vector,              /* binding information                   */
      NULL,                        /* no object UUIDs exported              */
      &status 
   );
   CHECK_STATUS(status, "Can't export to name service database:", RESUME);

   strcpy(group_name, "/.:/inventory_group");
   rpc_ns_group_mbr_add(           /* add as member of name service group <CO>*/
      rpc_c_ns_syntax_default,       /* syntax of group name (rpcbase.h)    */
      (unsigned_char_t *)group_name, /* name of group in name service       */
      rpc_c_ns_syntax_default,       /* syntax of member name (rpcbase.h)   */
      (unsigned_char_t *)entry_name, /* name of member in name service      */
      &status 
   );
   CHECK_STATUS(status, "Can't add group member to name service database:", RESUME);

   /*************************** MANAGE ENDPOINTS ****************************/
   strcpy(annotation, "Inventory interface");
   rpc_ep_register(                /* add endpoints to local endpoint map <CO>*/
      inventory_v1_0_s_ifspec,     /* interface specification (inventory.h) */
      binding_vector,              /* vector of server binding handles      */
      NULL,                        /* no object UUIDs to register           */
      (unsigned_char_t *)annotation, /* annotation supplied (not required)  */
      &status 
   );
   CHECK_STATUS(status, "Can't add endpoints to local endpoint map:", RESUME);

   rpc_binding_vector_free(                /* free server binding handles <CO>*/
      &binding_vector,
      &status
   );
   CHECK_STATUS(status, "Can't free server binding handles:", RESUME);

   open_inventory();                      /* application specific procedure */

   /******************* LISTEN FOR REMOTE PROCEDURE CALLS *******************/
   TRY                                 /* thread exception handling macro <CO>*/
      rpc_server_listen(                                                /*<CO>*/
         1,                  /* process one remote procedure call at a time */
         &status
      );
      CHECK_STATUS(status, "rpc listen failed:", RESUME);

   FINALLY                                /* error recovery and cleanup     */
      close_inventory();                  /* application specific procedure */
      rpc_server_in                                                                                                                                                                                                                                                   9                        ^ $      DCEVAXMUPA013.A                &	3  %	/  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                          "     O       q_bindings(                 /* get binding information <CO>*/
         &binding_vector,
         &status
      );
      CHECK_STATUS(status, "Can't get binding information:", RESUME);

      rpc_ep_unregister(      /* remove endpoints from local endpoint map <CO>*/
         inventory_v1_0_s_ifspec,  /* interface specification (inventory.h) */
         binding_vector,           /* vector of server binding handles      */
         NULL,                     /* no object UUIDs                       */
         &status 
      );
      CHECK_STATUS(status, "Can't remove endpoints from local endpoint map:", RESUME);

      rpc_binding_vector_free(             /* free server binding handles <CO>*/
         &binding_vector,
         &status
      );  
      CHECK_STATUS(status, "Can't free server binding handles:", RESUME);

      puts("\nServer quit!");
   ENDTRY
}  /* END SERVER INITIALIZATION */
                                                                                                                                                                                                                         @             @ * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]LOCAL_I_CLIENT.COM;1 +  , U   .     /  @   4 ,       d                   - \   0   1    2   3      K  P   W   O     5   6 f  7 0f  8          9          G  @  H  J $ N                   ?                      , $ rpc_default_entry == "/.:/inventory_group" $ define sys$input sys$command $ run local_i_client                                                                                                                                                                                                                                                                                                                                                                                                                          @             ? * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]LOCAL_I_CLIENT.SH;1 +  , U'   .     /  @   4 /       Z                   - \   0   1    2   3      K  P   W   O     5   6 Wi  7 Wi  8          9          G  @  H  J $ N                   ?                       def_log RPC_DEFAULT_ENTRY "/.:/inventory_group"
local_i_client
del_log RPC_DEFAULT_ENTRY

                                                                                                                                                                                                                                                                                                                                                                                                                                      @             > * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]MAKEFILE.GENERAL;1 +  , F0   .     /  @   4 \                         - \   0   1    2   3      K  P   W   O 	    5   6   7 $  8          9          G  @  H  J $ N                   ?                        # FILE NAME: makefile 
# Makefile for the inventory application 
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
# 13-Aug-1993 burgher Modified file to build under VMS/POSIX on VAX/AXP
#
# definitions for this make file 
#
APPL=inventory
DCL_IDL= dcl mcr dce\$$idl
IDL_FLAGS= -v -cpp_cmd -keep c_source
IDLCMD=$(DCL_IDL) $(IDL_FLAGS)
CFLAGS_INIT = -U VMS -I. -G
#LIBDCE=-ldce -lcma -li -ldnet        # dce and internationalization libraries
CHECK=../arithmetic     # directory containing check_status.h 
CC= c89
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`
OPTFILE= /vms/sys0/syscommon/dce\$$library/dce.opt # dce and internationalization libraries 
MAKE=make -f makefile.general

#
# COMPLETE BUILD of the application.
#

default: interface machine

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi
                                        
build:	local ostubs client server

#
# LOCAL BUILD of the application to test locally.
#
local:	i_client.c i_procedures.c implement_inventory.c
	$(CC) $(C_FLAGS) -DLOCAL -o local_i_client i_client.c \
		i_procedures.c implement_inventory.c
	#remove the object files so they do not interfere with a real build
	rm i_client.o i_procedures.o implement_inventory.o 


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c
#<COMMENT>Build the interface definition from pieces shown in book
#<ENDCOMMENT>
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl

#
# STUBS BUILD
#
ostubs:	$(APPL)_cstub.o $(APPL)_sstub.o
$(APPL)_cstub.o	$(APPL)_sstub.o:	$(APPL)_cstub.c	$(APPL)_sstub.c
	$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c

#
# CLIENT BUILD 
#
client:	i_client
i_client:	i_client.o $(APPL)_cstub.o
	   $(CC) $(C_FLAGS) -o i_client i_client.o $(APPL)_cstub.o $(OPTFILE)

i_client.o:	i_client.c
			$(CC) $(C_FLAGS) -c i_client.c

#
# SERVER BUILD 
#
server:	i_server
i_server:	$(APPL).h i_server.o i_procedures.o implement_inventory.o $(APPL)_sstub.o
	   $(CC) $(C_FLAGS) -I$(CHECK) -o i_server i_server.o i_procedures.o \
		   implement_inventory.o \
		   $(APPL)_sstub.o $(OPTFILE)

i_server.o:	i_server.c
			$(CC) $(C_FLAGS) -c i_server.c

i_procedures.o:	i_procedures.c
			$(CC) $(C_FLAGS) -c i_procedures.c

implement_inventory.o:	implement_inventory.c
			$(CC) $(C_FLAGS) -c implement_inventory.c

clean:
	rm -f *.o $(APPL).h i_server i_client local_i_client 
#<ENDCOMMENT>
                                                                               @             ; * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]MAKEFILE.OSF1;1 +  , O)   .     /  @   4 S                          - \   0   1    2   3      K  P   W   O 	    5   6 5a  7 a  8          9 #ΚL!b  G  @  H  J $ N                   ?               
            # FILE NAME: Makefile 
# Makefile for the inventory application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
#
# definitions for this make file 
#
APPL=inventory
IDLCMD=idl -v
LIBDCE=-ldce -lcma      # dce and thread libraries
CHECK=../arithmetic     # directory containing check_status.h
CFLAGS= -D_USER_THREADS_
CC= cc 


#
# COMPLETE BUILD of the application.
#
all:	local interface client server


#
# LOCAL BUILD of the application to test locally.
#
local:	interface i_client.c i_procedures.c implement_inventory.c
	   $(CC) $(CFLAGS) -DLOCAL -o local_i_client.exe i_client.c \
		  i_procedures.c implement_inventory.c
#remove the object files so they do not interfere w                                                                                                                                                                                                                                                   :                        ĭ $      DCEVAXMUPA013.A                &	3  %	/  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                         Z> "     `       ith a real build
	   rm i_client.o i_procedures.o implement_inventory.o 


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl


#
# CLIENT BUILD 
#
client:	i_client
i_client:	i_client.o $(APPL)_cstub.o
	   $(CC) $(CFLAGS) -o i_client.exe i_client.o $(APPL)_cstub.o $(LIBDCE)


#
# SERVER BUILD 
#
server:	i_server
i_server:	$(APPL).h i_server.o i_procedures.o implement_inventory.o $(APPL)_sstub.o
	   $(CC) $(CFLAGS) -I$(CHECK) -o i_server.exe i_server.o i_procedures.o \
		   implement_inventory.o \
		   $(APPL)_sstub.o $(LIBDCE)
i_server.o:	i_server.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c i_server.c
                                                                                                                                                                                                                                                                                             0             8 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]README.LIS;1 +  , o=   .     /  @   4 b       T                  - \   0   1    2   3      K  P   W   O     5   6 
  7 
  8          9          G  @  H  J $ N                   ?  ,            
taken from Appendix D of Guide to Writing DCE Applications, by John Shirley

 




                      COPYRIGHT (C) 1993 BY
                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
                  MASSACHUSETTS.  ALL RIGHTS RESERVED.

THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.

THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.

DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.






                                                                        D
        _________________________________________________________________

                                                The Inventory Application


              The inventory application allows a user to inquire about
              and order from a simple inventory. Data structures are
              defined in the interface definition for the following
              items:

                 Part number (to identify a part)
                 Part name
                 Part description
                 Part price
                 Quantity of part
                 Part list
                 Account number (to identify a user)

              Procedures are also defined in the interface definition to
              do the following:

                 Confirm if a part is available.
                 Obtain a part name.
                 Obtain a part description.
                 Obtain a part price.
                 Obtain the quantity of parts available.
                 Obtain a list of subpart numbers.
                 Order a part.

              The application demonstrates many features of IDL and RPC
              application development including:

              o  Using strings, pointers, structures, a union, and a
                 conformant array.

              o  Allocating new memory in a remote procedure for data
                 returned to the client using stub support routines.
                 The get_part_description and whatare_subparts remote
                 procedures demonstrate server allocation of a string and
                 a conformant structure.

              o  Managing protocol sequences, interpreting binding
                 information, selecting binding information, and using
                 exception handler macros.

              o  Variations on a client using ACFs and the automatic,
                 implicit, and explicit binding methods.

              o  Finding a server by importing from a name service
                 database.

   How to build the executables
	For the OpenVMS/POSIX environments:

		psx> cd /mydev/mydir
	 	psx> copy /usr/dce/examples/gde_dce_apps/inventory/* .
		psx> mkdir /mydev/mydir/explicit		
		psx> cd /mydev/mydir/explicit
		psx> copy /usr/dce/examples/gde_dce_apps/inventory/explicit * .
		psx> mkdir /mydev/mydir/implicit    
		psx> cd /mydev/mydir/explicit
		psx> copy /usr/dce/examples/gde_dce_apps/inventory/implicit * .
		
		In /mydev/mydir
                psx> make -f makefile.general 
	             This builds the server, i_client and local_i_client
	
		In /mydev/mydir/implicit
		psx> make -f makefile.implicit
	             This builds the implicit clients (local and distributed)

		In /mydev/mydir/explicit
		psx> make -f makefile.explicit
		     This builds the explicit clients (local and distributed)
	NOTE: After building each type of client cleanup the environment for
	      files left behind from previous builds:
	
		psx> make -f makefile.[general or implicit or explicit] clean

	For OpenVMS environments:

	Running INVENTORY.COM creates all the top-level executables for the 
        inventory application.

         	C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.inventory]*.* []
                C$ @inventory

	Build the Implicit version
		C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.inventory.implicit]*.* []
		C$ @implicit

	Build the Implicit version
		C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.inventory.explicit]*.* []
		C$ @explicit

   How to Run the Application

        To run the NONDISTRIBUTED LOCAL test of the application,
        enter the following commands:

	   For the OpenVMS/POSIX environments:

         	psx> local_i_client


    	   For OpenVMS environments, define a foreign command with the full 
	   directory specification:
         
         	C$ local_i_client :== "$mydisk:[inven-directory]local_i_client.exe"
         	C$ local_i_client


   	To run the server of the distributed application, first perform 
	dce_login as a principal that is a member of the 
	/.:/subsys/dce/cds-servers group or use cell_admin. 

	   For the OpenVMS/POSIX environment, enter the following commands:
              
         	psx> dce_login
			# Principal entered must be a member 
	                  of /.:/subsys/dce/cds-servers, or use cell_admin    
	 	psx> server.sh     
                        # Checks presence of credentials and invokes inventory 
	                  server 

	   For the OpenVMS environment, 	Define a foreign command with the full directory specification:

	 	S$ dce_login ! reply with principal name & password at prompts 
         	S$ i_server :== $mydisk:[inven-directory]i_server.exe              

	        Then, to run the server of the application, enter the 
	        following command:

	         S$ i_server

	To run the client of the distributed application:

	   For the OpenVMS/POSIX environment, enter the following command:
              	
         	psx> implicit_client.sh 
		     # This script sets RPC_DEFAULT_ENTRY = /.:/inventory_group & invokes i_client              
		     # and runs the implicit client.

         	psx> explicit_client.sh 
		     # This script sets RPC_DEFAULT_ENTRY = /.:/inventory_group & invokes i_client              
		     # and runs the explicit client.

           For the OpenVMS environments, the symbol is defined in i_client.com.
	   Enter the following commands:
              
	        C$ implicit_client :== @mydisk:[inven-directory]implicit_client.com              
	        C$ implicit_client 
		   For the implicit client

	        C$ explicit_client :== @mydisk:[inven-directory]explicit_client.com              
	        C$ explicit_client 
		   For the explicit client

 

              Application Files

              Makefile.general:  The Makefile contains descriptions of how the
              application (server, i_client and local_i_client) is compiled. 

              Makefile.implicit:  The Makefile contains descriptions of how the
              implicit client (local and distributed) is compiled. 

              Makefile.explicit:  The Makefile contains descriptions of how the
              explicit client (local and distributed) is compiled. 

              Makefile.osf1:  The Makefile for OSF/1 systems.

              inventory.com: The command procedure file for building on 
	      OpenVMS systems.

              i_client.sh:  This file is a shell scr                                                                                                                                                                                                                                                   ;                        걏6 $      DCEVAXMUPA013.A                &	3  %	/  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                         ǧ      q       ipt to set the
              environment and execute the client (i_client) that uses automatic
              binding management.

              i_client.com:  This file is a command procedure file to set the
              environment and execute the client (i_client) that uses automatic
              binding management.

              implicit_client.sh:  This file is a shell script to set the
              environment and execute the implicit client.

              implicit_client.com:  This file is a command procedure file to set the
              environment and execute the implicit client.

              explicit_client.sh:  This file is a shell script to set the
              environment and execute the explicit client.

              explicit_client.com:  This file is a command procedure file to set the
              environment and execute the explicit client.

	      server.sh:  This file is a shell script to set the environment
	      and execute the explicit client.

              inventory.idl:  The interface definition contains the
              description of the constants, data types, and procedures
              for the interface.

              i_client.c:  For this application, the client displays
              the instructions for the user and in a loop processes user
              input until exit is selected. Each remote procedure is
              exercised depending on the input from the user.

              i_procedures.c:  This is the implementation of all the
              remote procedures defined in this interface.

              implement_inventory.c:  This is the implementation of the
              inventory database. For simplicity, only three inventory
              items are included. The part numbers for these are printed
              when the inventory is opened.

              i_server.c:  The server is initialized with a series of
              runtime calls prior to servicing remote procedure calls. In
              addition to the required calls, this server also selects a
              specific protocol sequence, uses exception handling macros,
              and does some basic cleanup when the server quits.

              implicit-inventory.acf:  An attribute configuration file
              is used to customize how you use an interface. In this
              application it is used to select the implicit binding
              method.

              implicit_client.c:  This client imports a binding
              handle from the name service database.

              do_import_binding.c:  This contains the do_import_
              binding procedure, which shows how to import a binding
              handle from the name service database.

              do_interpret_binding.c:  This contains the do_
              interpret_binding procedure, which shows how to obtain the
              binding information a binding handle references.

              explicit.com: The command procedure file for building
              the explicit client. 

              The server for the explicit client is the same as the one
              for the automatic and implicit clients.

              explicit-inventory.acf:  An attribute configuration file
              is used to customize how you use an interface. In this
              application it is used to select the explicit binding
              method for all remote procedures in the interface.

              explicit_client.c:  This client imports a binding
              handle from the name service database. All procedures have
              a binding handle as the first parameter.

              Note: explicit/implicit Example Programs are not supported in the EFT release.



                                                                                                                                                                            0             7 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]SERVER.SH;1 +  , U"   .     /  @   4 t       <                   - \   0   1    2   3      K  P   W   O     5   6 (j𳒗  7 𳒗  8          9          G  @  H  J $ N                   ?               # Shell to check credentials and establish enviromental for the Arithmetic Server.  Burgher
# 19-Oct-1993 FWB Modified for dce_login executable & to insure dce_login was performed before server is invoked
#
CREDS=`show_log KRB5CCNAME |grep FILE`
#echo "CREDS = $CREDS"
if [ -z "$CREDS" ]
then
        echo " dce_login must be run first: Use a principal with registry group membership in subsys/dce/cds-server"
        echo " OR use the cell_admin principal:"
        exit 1
fi
trap 'while true
do 
break
done' INT QUIT TERM EXIT
i_server
echo "Inventory Server Exiting"
#
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          3 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS]REMOTE_FILE.DIR;1 +  , 04   .     /  @   4                            - -    0   1    2   3     K  P   W   O     5   6 ~N   7    8          9          G  @  H   J  I                        REMOTE_FILE.SAV  0:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ? * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1 +  , 0:   .     /  @   4   ~           ~               - 04    0   1    2   3      K  P   W   O     5   6 e  7 0   8          9          G  @  H   J                                            " ~      REMOTE_FILE.SAV                                                                                                                                                                                                              REMOTE_FILE.SAV:  BACKUP SRC$:*.* OBJ$:REMOTE_FILE.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   7e      V5.5	 	 _OPENUP:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                         $ * [RPCREMOTE                                                                                                                                                   <                        ,B $      DCEVAXMUPA013.A                0:  04  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                         [ "            _FILE.SRC]CHECK_STATUS.H;1 +  , 5,C   .     /  @   4 P       %                  - *<    0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                  /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                                                                                                                                         ' * [RPCREMOTE_FILE.SRC]CONTEXT_RUNDOWN.C;1 +  , .I   .     /  @   4 N       *                   - *<   0   1    2   3      K  P   W   O     5   6 1]  7 QȖ]  8          9 #ΚL!b  G  @  H  J $ N                   ?               /* FILE NAME: context_rundown.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include "remote_file.h"

void filehandle_rundown(remote_fh)  
filehandle remote_fh;               /* the context handle is passed in      */
{
   fprintf(stderr, "Server executing context rundown\n");
   if( (FILE *)remote_fh != stdout )
      fclose( (FILE *)remote_fh );  /* the file is closed if client is gone */
   remote_fh = NULL;                /* must set context handle to NULL      */
   return;   
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ) * [RPCREMOTE_FILE.SRC]DO_STRING_BINDING.C;1 +  , 8,<   .     /  @   4 Y                          - *<    0   1    2   3      K  P   W   O 	    5   6 }BTF  7 uTF  8          9          G  @  H  J $ N                   ?             /* FILE NAME: do_string_binding.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* Find a server binding handle from strings of binding information        */
/* including protocol sequence, host address, and server process endpoint. */
#include <stdio.h>
#include <dce/rpc.h>
#include "check_status.h"               /* contains the CHECK_STATUS macro */
#include "remote_file.h"

int do_string_binding(host, binding_h) /* return=0 if binding valid,  else -1 */
char             host[];  /* server host name or network address is input <CO>*/
rpc_binding_handle_t *binding_h;      /* binding handle is output (rpcbase.h) */
{
   rpc_protseq_vector_t *protseq_vector; /* protocol sequence list (rpcbase.h)*/
   unsigned_char_t      *string_binding; /* string of binding info. (lbase.h) */
   unsigned32           status;          /* error status (nbase.h)            */
   int                  i, result;

   rpc_network_inq_protseqs( /* obtain a list of valid protocol sequences <CO>*/
      &protseq_vector,               /* list of protocol sequences obtained */ 
      &status
   );
   CHECK_STATUS(status, "Can't get protocol sequences:", ABORT);

   /* loop through protocol sequences until a binding handle is obtained */
   for(i=0; i < protseq_vector->count; i++) {

      rpc_string_binding_compose(  /* make string binding from components <CO>*/
         NULL,                           /* no object UUIDs are required    */
         protseq_vector->protseq[i],     /* protocol sequence               */
         (unsigned_char_t *)host,        /* host name or network address    */
         NULL,                           /* no endpoint is required         */
         NULL,                           /* no network options are required */
         &string_binding,                /* the constructed string binding  */
         &status
      );
      CHECK_STATUS(status, "Can't compose a string binding:", RESUME);
   
      rpc_binding_from_string_binding(/* convert string to binding handle <CO>*/
         string_binding,            /* input string binding                 */
         binding_h,                 /* binding handle is obtained here      */
         &status
      );
      if(status != rpc_s_ok) {
         result = -1;
         CHECK_STATUS(status, "Can't convert string to binding handle:", RESUME);
      }
      else 
         result = 0;

      rpc_string_free(                     /* free string binding created <CO>*/
         &string_binding, 
         &status
      );
      CHECK_STATUS(status, "Can't free string binding:", RESUME);

      rpc_ep_resolve_binding(
         *binding_h,                /* binding handle is obtained here      */
         remote_file_v1_0_c_ifspec,/* if spec is required here             */
         &status
      );

      if(status != rpc_s_ok) {
         result = -1;
         CHECK_STATUS(status, "Can't get endpoint information:", RESUME);
	 rpc_binding_free(
	    binding_h,
	    &status
	 );
	 CHECK_STATUS(status, "Can't free binding handle:", RESUME); 
      }
      else
         result = 0;

      if(result == 0)
	 break;                        /* got a valid binding */
      else
	 fprintf(stderr, "  %s:%s is not a server registered binding, trying next binding...\n",
		    protseq_vector->protseq[i],(unsigned_char_t *)host);
   }

   rpc_protseq_vector_free(        /* free the list of protocol sequences <CO>*/
      &protseq_vector, 
      &status
   );
   CHECK_STATUS(status, "Can't free protocol sequence vector:", RESUME);
   if (result == 0)
   {
	rpc_binding_to_string_binding(
	    *binding_h,
	    &string_binding,
	    &status
	);
	CHECK_STATUS(status, "Can't convert binding to string binding:", RESUME);
	fprintf(stderr, "Using string binding: %s\n", string_binding);
	rpc_string_free(    /* free string binding created <CO>*/
         &string_binding, 
         &status
	);
	CHECK_STATUS(status, "Can't free string binding:", RESUME);
   }
   return(result);
}
                                                                                                          * [RPCREMOTE_FILE.SRC]GET_ARGS.C;1 +  , <,7   .     /  @   4 J       1                   - *<    0   1    2   3      K  P   W   O     5   6 QK]  7 a]  8          9 #ΚL!b  G  @  H  J $ N                   ?                      /* FILE NAME: get_args.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h> 

get_args(argc, argv, local_fh, host, remote_name)
int  argc;
char *argv[];
FILE **local_fh;
char host[];
char remote_name[];
{
   char local_name[100];
   char *strcpy();
   void exit();

   switch(argc) {
   case 1:
   case 2: printf("Usage: %s [local_file] host [remote_file]\n", argv[0]);
           puts("Use \"\" for local stdin.");
           exit(0);
           break;
   case 3: strcpy(local_name, argv[1]);  /* use the same file name */
           strcpy(remote_name, local_name);
           strcpy(host, argv[2]);
           break;
   default: strcpy(local_name, argv[1]);
           strcpy(host, argv[2]);
           strcpy(remote_name, argv[3]);
           break;
   }
   if(strlen(local_name) == 0) {
      (*local_fh) = stdin;
      puts("Using stdin.  Type input:");
   }
   else
      if( ( (*local_fh) = fopen(local_name, "r")) == NULL ) {
         puts("Cannot open local file");
         exit(1);
      }
   return;
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  =                        H%w $      DCEVAXMUPA013.A                0:  04  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                         Ɲ "                                                                                                                                                                                                                                                           * [RPCREMOTE_FILE.SRC]MAKEFILE.;1 +  , .A   .     /  @   4 \                         - *<   0   1    2   3      K  P   W   O 	    5   6 (t  7 :u  8          9          G  @  H  J $ N                   ?                       # FILE NAME: Makefile 
# Makefile for the remote_file application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
# 27-Jul-1993 Burgher Modified for OpenVMS/POSIX & added .o and .c target/dep statements
#
# definitions for this make file
#
DCL_IDL= dcl mcr dce\$$idl
IDL= $(DCL_IDL)
CFLAGS_INIT = -U VMS -I.
IDL_CFLAGS= -v -keep c_source
CC = c89
LIBDCE=/vms/sys0/syscommon/dce\$$library/dce.opt    # dce and internationalization libraries
APPL=remote_file
IDLCMD= $(IDL) $(IDL_CFLAGS)
CHECK=../arithmetic      # Directory containing check_status.h
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`

default: interface machine

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi  

#
# COMPLETE BUILD of the distributed application.
#

#
# INTERFACE BUILD 
#
interface:	$(APPL).h  $(APPL)_cstub.c $(APPL)_sstub.c
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl

build:	local ostubs client server

#
# LOCAL BUILD of the client application to test locally.
#

local:
local_r_client:	r_client.c get_args.c r_procedures.c
		$(CC) $(C_FLAGS) -DLOCAL -o local_r_client \
		r_client.c get_args.c r_procedures.c
		# 	remove object files so they do not interfere with a real build
		rm r_client.o get_args.o r_procedures.o 

# STUB OBJECTS BUILD
#
ostubs: $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL)_cstub.c $(APPL)_sstub.c
			$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c

#
# CLIENT BUILD 
#
client:	r_client
r_client:	$(APPL).h r_client.o get_args.o do_string_binding.o $(APPL)_cstub.o
			$(CC) $(C_FLAGS) -o r_client r_client.o \
			get_args.o do_string_binding.o $(APPL)_cstub.o $(LIBDCE)

r_client.o:		r_client.c
					$(CC) $(C_FLAGS) -c r_client.c

get_args.o:		get_args.c
					$(CC) $(C_FLAGS) -c get_args.c

do_string_binding.o:	do_string_binding.c
				$(CC) $(C_FLAGS) -I$(CHECK) -c do_string_binding.c
	
#
# SERVER BUILD 
#
server:	r_server 
r_server:	$(APPL).h r_server.o r_procedures.o context_rundown.o $(APPL)_sstub.o 
			$(CC) $(C_FLAGS) -I$(CHECK) -o r_server r_server.o \
			r_procedures.o context_rundown.o $(APPL)_sstub.o $(LIBDCE)

r_server.o:	r_server.c
			$(CC) $(C_FLAGS) -I$(CHECK) -c r_server.c
                        
context_rundown.o:	context_rundown.c
			$(CC) $(C_FLAGS) -c context_rundown.c
                        
r_procedures.o:		r_procedures.c
					$(CC) $(C_FLAGS) -c r_procedures.c

clean:
	rm -f r_client r_server *.o $(APPL)*stub.c $(APPL).h 
                                 * [RPCREMOTE_FILE.SRC]README.LIS;1 +  , .@   .     /  @   4 K       6                   - *<   0   1    2   3      K  P   W   O     5   6 M  7 4N  8          9          G  @  H  J $ N                   ?                      
taken from Appendix E of Guide to Writing DCE Applications, by John Shirley

 


	                  COPYRIGHT (C) 1993 BY
		   DIGITAL EQUIPMENT CORPORATION, MAYNARD
                    MASSACHUSETTS.  ALL RIGHTS RESERVED.

THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.

THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.

DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.






                                                                        E
        _________________________________________________________________

                                              The Remote_file Application


              The remote_file client copies ASCII data from the client to
              the server. The source can be a data file or the standard
              input of the client. The target on the server system is
              either a file or the server standard output. The remote_
              file application demonstrates some advanced features of IDL
              and RPC application development including the following:

              o  Using a context handle with a context rundown procedure.

              o  Using the explicit binding method with a primitive
                 binding handle.

              o  Finding a server using strings of binding information.


   How to Build the Application

              To run the local test of the application, use an ASCII text
              file as input and a new data file as output. The host is
              not relevant for the local test. 

	For OpenVMS/POSIX environments, enter the following commands:
		psx> cd	/dev/mydir/examp_dir
		psx> copy /usr/dce/examples/gde_dce_apps/remote_file/*.* .
		psx> make 

	For OpenVMS systems, enter the following commands:

		C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.remote_file]*.* []
		C$ @remote_file

	           Running REMOTE_FILE.COM creates all (Local and distributed)
	           the executables for the remote_file application.

   How to Run the Application

	To run the LOCAL / NONDISTRIBUTED test 

	   For OpenVMS/POSIX environments:

		psx> local_r_client input  host  output

	   For OpenVMS environments:

	      Define a foreign command with the full directory specification:

		C$ local_r_client :== $mydisk:[rem-directory]local_r_client.exe

              Then, run the client:

		C$ local_r_client input  host  output

	To run the DISTRIBUTED test

	   Server For OpenVMS/POSIX environments, enter the following command:

		psx> r_server

	   Server For OpenVMS environments, enter the following command:

	      Define a foreign command with the full directory specification:

		S$ r_server :== $mydisk:[rem-directory]r_server.exe

              Then, run the server:

		S$ r_server

	To run the client of the distributed application to
	transfer ASCII data, use an ASCII text file as input and
	a new data file on the server host as output If the server
	is running on a remote host use the network address as the
	"host". 


	   Client for OpenVMS/POSIX, enter the following command:

		psx> r_client. input  host  output

	   Client for OpenVMS systems, enter the following command:

	      Define a foreign command with the full directory specification:

		C$ r_client :== $mydisk:[rem-directory]r_client.exe

              Then, run the client:

		C$ r_client input  host  output




              Application Files

              Makefile:  This Makefile contains descriptions of how the
              application is compiled for OpenVMS/POSIX.

	      remote_file.com:  The command procedure file for building the 
	      application on OpenVMS systems.

              remote_file.idl:  The interface definition contains the
              description of the data types and procedures for the
              interface.

                                                                                                                                                                                                                                                           >                        ލM $      DCEVAXMUPA013.A                0:  04  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                         bw "     $             r_client.c:  For this application, the client interprets
              the user input by calling the application specific
              procedure get_args. A binding handle representing the
              information about a client-server relationship is obtained
              from strings of binding information. The remote procedure
              remote_open is called to open the server target file. A
              buffer is allocated for a conformant array. The application
              loops reading source data and sending the buffer of data
              to the target with a remote procedure call to remote_send.
              Finally, the remote procedure remote_close is called to
              close the target file.

              get_args.c:  The user input is interpreted to obtain the
              name of a local client ASCII file of source data, the
              server host to use, and the server target file.

              do_string_binding.c:  This contains the do_string_binding
              procedure which shows how to find a server from strings
              of binding information. A host name or network address is
              input and then combined with a generated protocol sequence
              to create a valid binding handle which is returned as a
              parameter.

              r_procedures.c:  This is the implementation of the remote
              procedures defined in the remote_file interface.

              context_rundown.c:  This is the implementation of a context
              rundown procedure which is called automatically by the
              server stub if communication breaks between a client and
              a server which is maintaining context for the client. For
              this application, the context is a file handle of a server
              data file. This context rundown procedure closes the file.


              r_server.c:  The server is initialized with a series of
              runtime calls prior to servicing remote procedure calls.
              In this application, all protocol sequences available are
              registered. The server is not advertised in a name service
              database. The server's dynamic endpoints are added to the
              server's local endpoint map. A client finds this server
              by constructing a string binding containing a protocol
              sequence and the host name or network address.




                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        % * [RPCREMOTE_FILE.SRC]REMOTE_FILE.COM;1 +  , @,H   .     /  @   4 L       
                   - *<    0   1    2   3      K  P   W   O 	    5   6 d  7 Uڲd  8          9          G  @  H  J $ N                   ?     
             $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! $! Abstract:= $!	REMOTE_FILE.COM -- Builds the remote_file example program   $! $! Modification History:, $! 01-Sep-1993 fwb Modified for VMS DCE V1.1 $!J $! Determine which compiler is being used and establish the linker options $ @DCE:DCE$CC_TEST' $ If( f$trnlnm( "dce$cc" ) .eqs. " " )	 I $ Then	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options" & $ Else	options = "dce:dce.opt/options" $ Endif - $! Enable the universal IDL command interface  $idl := mcr dce$idl  $ " $! Compile the interface defintion $idl  remote_file.idl  $   $ cc/g_float/include=[] r_server $ cc := cc'f$trnlnm("dce$cc")' $ ) $! Build the local version of the example B $cc/g_float/define=LOCAL/include=[] r_client,get_args,r_proceduresA $link/exe=local_r_client r_client,get_args,r_procedures,'options' 8 $delete r_client.obj;*,get_args.obj;*,r_procedures.obj;* $  $! Build the remote_file client / $cc/g_float r_client,get_args,do_string_binding E $link r_client,get_args,do_string_binding,remote_file_cstub,'options'  $  $! Build the remote_file server 3 $cc/g_float/include=[] r_procedures,context_rundown G $link r_server,r_procedures,context_rundown,remote_file_sstub,'options'  $ > $! Example command definitions to invoke r_server and r_clientJ $ local_r_client == "$ " + f$environment("DEFAULT") + "local_r_client.exe"> $ r_server == "$ " + f$environment("DEFAULT") + "r_server.exe"> $ r_client == "$ " + f$environment("DEFAULT") + "r_client.exe"                                                                                                                                                                                                                                                                  % * [RPCREMOTE_FILE.SRC]REMOTE_FILE.IDL;1 +  , `P/   .     /  @   4 N       ^                  - *<    0   1    2   3      K  P   W   O     5   6 ]  7 ]  8          9 #ΚL!b  G  @  H  J $ N                   ?                 /* FILE NAME: remote_file.idl 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
[
uuid(016B2B80-F9B4-11C9-B31A-08002B111685),
version(1.0)
]
interface remote_file  /* file manipulation on a remote system */
{
   typedef [context_handle] void *filehandle;  /*<CO>*/
   typedef                  byte buffer[];

filehandle remote_open(       /* open for write  <CO>*/
   [in] handle_t binding_h,   /* explicit primitive binding handle     */
   [in, string] char name[],  /* if name is null, use stdout in server */
   [in, string] char mode[]   /* values can be "r", "w", or "a"        */
);

long remote_send(
   [in] filehandle fh,                         /*<CO>*/                       
   [in, max_is(max)] buffer buf,
   [in] long max
);

void remote_close(
   [in,out] filehandle *fh                     /*<CO>*/
);
}
                                                                                                                                                                                  * [RPCREMOTE_FILE.SRC]R_CLIENT.C;1 +  , ^Q0   .     /  @   4 P       H                   - *<    0   1    2   3      K  P   W   O 	    5   6 {bbw  7 2bw  8          9          G  @  H  J $ N                   ?          
            /* FILE NAME: r_client.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <string.h>
#include "remote_file.h"
#define MAX 200         /* maximum line length for a file */

void get_args( int argc,
               char *argv[], 
	       FILE **local_fh, 
               char host[], 
               char remote_name[] );

int do_string_binding( char host[],
                       rpc_binding_handle_t *binding_h );

main(argc, argv)
int argc;
char *argv[];
{
   FILE         *local_fh;            /* file handle for client file input  */
   char         host[100];        /* name or network address of remote host */
   idl_char     remote_name[100];     /* name of remote file                */
   rpc_binding_handle_t binding_h;    /* binding handle                     */
   filehandle   remote_fh;            /* context handle                     */
   buffer       *buf_ptr;             /* buffer pointer for data sent       */
   int          size;                 /* size of data buffer                */
   void exit();
   char *malloc();

   get_args(argc, argv, &local_fh, host, (char *)remote_name);
#ifndef LOCAL   
   if(do_string_binding(host, &binding_h) < 0) {                                                                                                                                                                                                                                                       ?                         $      DCEVAXMUPA013.A                0:  04  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                          "     5                           /*<CO>*/
      fprintf(stderr, "Cannot get binding\n");
      exit(1);
   }
#endif
   remote_fh = remote_open(binding_h, remote_name, (idl_char *)"w");    /*<CO>*/
   if(remote_fh == NULL) {
      fprintf(stderr, "Cannot open remote file\n");
      exit(1);
   }
   /* A conformant array has an array size of 1 in the header file so       */
   /* memory must be allocated for the rest of the array elements desired.  */
   /* The MAX_IS attribute in the interface definition defines a variable   */
   /* representing the maximum index value for the array and since arrays   */
   /* in C begin with 0, memory must be allocated for MAX+1 elements.       */
   buf_ptr = (buffer *)malloc((MAX+1) * sizeof(buffer));

   while( fgets((char *)buf_ptr, MAX, local_fh) != NULL) {
      size = (int)strlen((char *)buf_ptr); /* data sent will not include \0 */
      if( remote_send(remote_fh, (*buf_ptr), size) < 1) {               /*<CO>*/
         fprintf(stderr, "Cannot write to remote file\n");
         exit(1);
      }
   }
   remote_close(&remote_fh);                                            /*<CO>*/
}
                                                                                                                                                                                                      $ * [RPCREMOTE_FILE.SRC]R_PROCEDURES.C;1 +  , .>   .     /  @   4 U       _                   - *<   0   1    2   3      K  P   W   O     5   6  :TF  7  TF  8          9          G  @  H  J $ N                   ?                  /* FILE NAME: r_procedures.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "remote_file.h"

filehandle remote_open(binding_h, name, mode)  /*<CO>*/
rpc_binding_handle_t binding_h;
idl_char             name[];
idl_char             mode[];
{
   FILE *FILEh;

   if(strlen((char *)name) == 0)            /* no file name given */
      if(strcmp((char *)mode, "r") == 0)
         FILEh = NULL;                 /* cannot read nonexistent file        */
      else FILEh = stdout;             /* use server stdout instead of a file */

   else if(access((char *)name, F_OK) == 0) /* file exists */
      if(strcmp((char *)mode, "w") == 0)
#ifdef VMS
	FILEh = fopen((char *)name, (char *)mode);  /* open for write */
#else
        FILEh = NULL;                 /* do not overwrite existing file      */
#endif
      else FILEh = fopen((char *)name, (char *)mode);  /* open for read or append */

   else                             /* file does not exist  */
      if(strcmp((char *)mode, "r") == 0) 
         FILEh = NULL;                 /* cannot read nonexistent file        */
      else FILEh = fopen((char *)name, (char *)mode);  /* open for write or append */

   return( (filehandle)FILEh );        /* cast FILE handle to context handle  */
}


idl_long_int remote_send(fh, buf, max)         /*<CO>*/
filehandle fh;
buffer buf;
idl_long_int max;
{
   /* write data to the file (context), which is cast as a FILE pointer */
   return( fwrite(buf, sizeof(buffer), max, (FILE *)fh) );
}


void remote_close(fh)                          /*<CO>*/
filehandle *fh;   /* the client stub needs the changed value upon return */
{
   if( (FILE *)(*fh) != stdout )
      fclose( (FILE *)(*fh) );
   (*fh) = NULL;         /* assign NULL to the context handle to free it */
   return;
}
                                                                                                                                                                                 * [RPCREMOTE_FILE.SRC]R_SERVER.C;1 +  , Q5   .     /  @   4 P       v                    - *<    0   1    2   3      K  P   W   O 	    5   6  -4RF  7  TF  8          9          G  @  H  J $ N                   ?                      /* FILE NAME: r_server.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include "remote_file.h"               /* header created by the idl compiler */
#include "check_status.h"              /* contains the CHECK_STATUS macro    */
main ()
{
   int			  i;
   unsigned32             status;          /* error status (nbase.h)         */
   rpc_binding_vector_t   *binding_vector; /* binding handle list (rpcbase.h)*/

   rpc_server_register_if(       /* register interface with the RPC runtime */
      remote_file_v1_0_s_ifspec, /* handle for interface specification      */
      NULL,                     
      NULL,                     
      &status                   /* error status */
   );
   CHECK_STATUS(status, "Can't register interface\n", ABORT);

   rpc_server_use_all_protseqs(            /* establish protocol sequences  */
      rpc_c_protseq_max_reqs_default,      /* queue length for remote calls */
      &status
   );
   CHECK_STATUS(status, "Can't establish protocol sequences\n", ABORT);

   rpc_server_inq_bindings(     /* get set of this server's binding handles */
      &binding_vector,
      &status
   ); 
   CHECK_STATUS(status, "Can't get binding handles\n", ABORT);

   rpc_ep_register(                /* add endpoint to local endpoint map    */
      remote_file_v1_0_s_ifspec,   /* handle for interface specification    */
      binding_vector,              /* vector of server binding handles      */
      NULL,                        /* P                                                                                                                           @V ~      REMOTE_FILE.SAV                Q5  *<   [RPCREMOTE_FILE.SRC]R_SERVER.C;1                                                                                               P                                           no object UUIDs to register           */
      (unsigned_char_t *)"remote_file server", /* annotation (not required) */
      &status 
   );
   CHECK_STATUS(status, "Can't add endpoints to local endpoint map:", ABORT);

   for (i = 0; i < binding_vector->count; i++)
   {
        unsigned_char_p_t sb;

        rpc_binding_to_string_binding(
	    binding_vector->binding_h[i],
	    &sb,
	    &status
	);
	CHECK_STATUS(status, "Can't get string binding:", RESUME);

        fprintf (stderr, "Got binding: %s\n", sb);

        rpc_string_free(
	    &sb,
	    &status
	);
	CHECK_STATUS(status, "Can't free string binding:", RESUME);
    }
   puts("Listening for remote procedure calls...");
   TRY
      rpc_server_listen(                   /* listen for remote calls       */
         rpc_c_listen_max_calls_default,   /* number of threads             */
         &status
      );
      CHECK_STATUS(status, "rpc listen failed:", RESUME);
   FINALLY
      puts("Removing endpoints from local endpoint map.");
      rpc_ep_unregister(     /* remove endpoints from local endpoint map    */
         remote_file_v1_0_s_ifspec,  /* handle for interface specificaiton  */
         binding_vector,             /* vector of server binding handles    */
         NULL,                       /* no object UUIDs to unregister       */
         &status 
      );
      CHECK_STATUS(status, "Can't remove endpoints from endpoint map:", RESUME);

      rpc_binding_vector_free(               /* free set of binding handles */
         &binding_vector,
         &status
      ); 
      CHECK_STATUS(status, "Can't free binding handles and vector\n", ABORT);
   ENDTRY
}
                                                                                                                                                                                                                                                                                                                                                                                                                         * [RPCREMOTE_FILE.SRC]UNISTD.H;1 +  , T"   .     /  @   4        &                    - *<   0   1    2   3      K  P   W   O     5   6 `
T{A  7 UUF  8          9 $AF  G  @  H  J $ N                   ?                         #include <unixio.h>  #define F_OK 4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @                        6 $      DCEVAXMUPA013.A                0:  04  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                          "     F                                                                                       q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 A                        Lvi $      DCEVAXMUPA013.A                0:  04  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                         3: "     W                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          B                        Yw $      DCEVAXMUPA013.A                0:  04  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                          "     h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          C                        Z $      DCEVAXMUPA013.A                0:  04  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                         
I      y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   5 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS]TRANSFER_DATA.DIR;1 +  , 0?   .     /  @   4                            - -    0   1    2   3     K  P   W   O     5   6 pY   7 #   8          9          G  @  H   J  I                      TRANSFER_DATA.SAV  
08                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               C * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1 +  , 
08   .     /  @   4   ~           ~               - 0?    0   1    2   3      K  P   W   O     5   6 	e  7 0E   8          9          G  @  H   J                                                        6 ~      TRANSFER_DATA.SAV                                                                                                                                                                                            T                TRANSFER_DATA.SAV<  BACKUP SRC$:*.* OBJ$:TRANSFER_DATA.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   x״e      V5.5	 	 _OPNSME:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                       * [RPCTRANSFER_DAT.SRC]BINDING.C;1 +  , -/4   .     /  @   4 U                          - -7    0   1    2   3      K  P   W   O     5   6  ?(  7 &0"  8          9          G  @  H  J $ N                   ?                       /* FILE NAME: binding.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */G #include "transfer_data.h"     /* header created by the IDL compiler */ G #include "check_status.h"      /* contains the CHECK_STATUS macro    */     P handle_t file_spec_bind(spec)  /* binding procedure for customized handle <CO>*/ file_spec spec;  { "    rpc_binding_handle_t binding_h;    int do_string_binding();   5    if(do_string_binding(spec.host, &binding_h) < 0) { .       fprintf(stderr, "Cannot get binding\n");       exit(1);    }    return(binding_h);  }   U void file_spec_unbind(spec, binding_h) /*unbind procedure for customized handle<CO>*/  file_spec spec;  handle_t binding_h;  {   )    unsigned32 status;  /* error status */   )    rpc_binding_free(&binding_h, &status); >    CHECK_STATUS(status, "Can't free binding handle:", RESUME);
    return; }                                                                                                                                   % * [RPCTRANSFER_DAT.SRC]CHECK_STATUS.H;1 +  , #M;   .     /  @   4 P       %                  - -7   0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                 /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                                                                                                                                         % * [RPCTRANSFER_DAT.SRC]CLIENT_ALLOC.C;1 +  , >M9   .     /  @   4 P                          - -7   0   1    2   3      K  P   W   O     5   6  o]  7 F0"  8          9          G  @  H  J $ N                   ?                 /* FILE NAME: client_alloc.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include "transfer_data.h"
#include "pipe_state.h"

#define BUFFER_SIZE 2000
idl_short_float client_buffer[BUFFER_SIZE];

void client_alloc(state, bsize, buf, bcount)     /* allocation for a pipe <CO>*/
pipe_state          *state;           /* coordinates pipe procedure calls <CO>*/
idl_ulong_int       bsize;            /* desired size of buffer in bytes  <CO>*/
idl_short_float     **buf;            /* allocated buffer                 <CO>*/
idl_ulong_int       *bcount;          /* allocated buffer size in bytes   <CO>*/
{
    *buf = client_buffer;
    *bcount = BUFFER_SIZE;
    return;
}
                                                                                                                                                                                                                                                                                                                ' * [RPCTRANSFER_DAT.SRC]CLIENT_RECEIVE.C;1 +  , E!   .     /  @   4p                                                                                                                                   D                        QxD $      DCEVAXMUPA013.A                
08  0?  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                         } "     
        P                           - -7    0   1    2   3      K  P   W   O 	    5   6  <l  7 ``0"  8          9          G  @  H  J $ N                   ?                /* FILE NAME: client_receive.c   ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */7 /* Client for customized handle and output pipe test */  #include <stdio.h> #include <string.h>  #include "transfer_data.h"P #include "pipe_state.h"  /* definition of a state structure for pipe data <CO>*/ void exit();   main(argc, argv)	 int argc; 
 char *argv[];  { I    file_spec  cust_binding_h;            /* customized binding handle  */     pipe_state state;P    pipe_type  data;                      /* a pipe structure is allocated <CO>*/     char       local_target[100];/               /* procedures in other modules */ (    void       client_alloc(),out_push();    void       receive_floats();        /* get user input */     if(argc < 4) { H       printf("USAGE: %s  local_target  host  remote_source\n", argv[0]);       exit(0);    }  7    /* initialize customized binding handle structure */ !    strcpy(local_target, argv[1]); 0    strcpy((char *)cust_binding_h.host, argv[2]);4    strcpy((char *)cust_binding_h.filename, argv[3]);   "    /* initialize pipe structure */!    state.filename = local_target;     state.filehandle = -1;     state.start_output = true; P    data.state = (rpc_ss_pipe_state_t)&state;     /* initialize pipe state <CO>*/P    data.alloc = client_alloc; /* initialize alloc procedure for a pipe    <CO>*/P    data.push = out_push;      /* Initialize push procedure for output pipe<CO>*/     P    receive_floats(cust_binding_h, &data);/* procedure with an output pipe <CO>*/ }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               $ * [RPCTRANSFER_DAT.SRC]CLIENT_SEND.C;1 +  ,  E"   .     /  @   4 P                           - -7    0   1    2   3      K  P   W   O 	    5   6   7 @}0"  8          9          G  @  H  J $ N                   ?                   /* FILE NAME: client_send.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */6 /* Client for customized handle and input pipe test */ #include <stdio.h> #include <string.h>  #include "transfer_data.h"P #include "pipe_state.h"  /* definition of a state structure for pipe data <CO>*/   void exit();   main(argc, argv)	 int argc; 
 char *argv[];  { I    file_spec  cust_binding_h;            /* customized binding handle  */     pipe_state state;P    pipe_type  data;                      /* a pipe structure is allocated <CO>*/     char       local_source[100];/               /* procedures in other modules */ (    void       client_alloc(), in_pull();    void       send_floats();       /* get user input */     if(argc < 4) { H       printf("USAGE: %s  local_source  host  remote_target\n", argv[0]);       exit(0);    }7    /* initialize customized binding handle structure */ !    strcpy(local_source, argv[1]); 1    strcpy((char *)cust_binding_h.host, argv[2]);  5    strcpy((char *)cust_binding_h.filename, argv[3]);     "    /* initialize pipe structure */!    state.filename = local_source;     state.filehandle = -1;     state.start_output = false;P    data.state = (rpc_ss_pipe_state_t)&state;     /* initialize pipe state <CO>*/P    data.alloc = client_alloc; /* initialize alloc procedure for a pipe    <CO>*/P    data.pull = in_pull;       /* Initialize pull procedure for input pipe <CO>*/     P    send_floats(cust_binding_h, data); /* remote procedure with input pipe <CO>*/ }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       0             * * [RPCTRANSFER_DAT.SRC]DO_STRING_BINDING.C;1 +  , O(   .     /  @   4 Q       O                  - -7   0   1    2   3      K  P   W   O 	    5   6 ]  7   8          9          G  @  H  J $ N                   ?                            /* FILE NAME: do_string_binding.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* Find a server binding handle from strings of binding information        */
/* including protocol sequence, host address, and server process endpoint. */
#include <stdio.h>
#include <dce/rpc.h>
#include "check_status.h"               /* contains the CHECK_STATUS macro */

int do_string_binding(host, binding_h) /* return=0 if binding valid,  else -1 */
char             host[];  /* server host name or network address is input <CO>*/
rpc_binding_handle_t *binding_h;      /* binding handle is output (rpcbase.h) */
{
   rpc_protseq_vector_t *protseq_vector; /* protocol sequence list (rpcbase.h)*/
   unsigned_char_t      *string_binding; /* string of binding info. (lbase.h) */
   unsigned32           status;          /* error status (nbase.h)            */
   int                  i, result;

   rpc_network_inq_protseqs( /* obtain a list of valid protocol sequences <CO>*/
      &protseq_vector,               /* list of protocol sequences obtained */ 
      &status
   );
   CHECK_STATUS(status, "Can't get protocol sequences:", ABORT);

   /* loop through protocol sequences until a binding handle is obtained */
   for(i=0; i < protseq_vector->count; i++) {

      rpc_string_binding_compose(  /* make string binding from components <CO>*/
         NULL,                           /* no object UUIDs are required    */
         protseq_vector->protseq[i],     /* protocol sequence               */
         (unsigned_char_t *)host,        /* host name or network address    */
         NULL,                           /* no endpoint is required         */
         NULL,                           /* no network options are required */
         &string_binding,                /* the constructed string binding  */
         &status
      );
      CHECK_STATUS(status, "Can't compose a string binding:", RESUME);
   
      rpc_binding_from_string_binding(/* convert string to binding handle <CO>*/
         string_binding,            /* input string binding                 */
         binding_h,                 /* binding handle is obtained here      */
         &status
      );
      if(status != rpc_s_ok) {
         result = -1;
         CHECK_STATUS(status, "Can't convert string to binding handle:", RESUME);
      }
      else 
         result = 0;

      rpc_string_free(                     /* free string binding created <CO>*/
         &string_binding, 
         &status
      );
      CHECK_STATUS(status, "Can't free string binding:", RESUME);
      if(result == 0)  break;                        /* got a valid binding */
   }

   rpc_protseq_vector_free(        /* free the list of protocol sequences <CO>*/
      &protseq_vector, 
      &status
   );
   CHECK_STATUS(status, "Can't free protocol sequence vector:", RESUME);
   return(result);
}
                                                                                                                                                                                               # * [RPCTRANSFER_DAT.SRC]FLOAT_UTIL.C;1 +  , O1   .     /  @   4 V                          - -7   0   1    2   3      K  P   W   O 	    5   6  [v  7 `ʝ0"  8          9          G  @  H  J $ N                   ?       
             /* FILE NAME: float_util.c   ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */D /* utility to generate or read a file of float data to test pipes */ #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <sys/file.h>  #if defined(VMS)   #include <unixio.h>  #endif                                                                                                                                                                                                                                                     E                        ϯn $      DCEVAXMUPA013.A                
08  0?  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                         !              void exit(); static write_floats(); static read_floats();    main(argc, argv)	 int argc; 
 char *argv[];  { "    char choice[20], filename[100];      if(argc == 1)  { ?       printf("Usage: %s [write | read] [filename]\n", argv[0]); 3       puts("Enter w to create a file, r to read:");        gets(choice);     }    else        strcpy(choice, argv[1]);    if(argc > 2)         strcpy(filename, argv[2]);    else        strcpy(filename, "");       if(choice[0] == 'w')        write_floats(filename);     else        read_floats(filename); }    write_floats(file) char file[]; {     char filename[100];    int filehand;    long num, i;     float *buf, x;          strcpy(filename, file);    if(strlen(filename) == 0) {0       puts("enter name of data file to create");       gets(filename);     }A    filehand = open(filename, O_CREAT | O_TRUNC | O_WRONLY, 0777);     if(filehand == 0) {C       fprintf(stderr, "Cannot open file %s for write\n", filename);        exit(0);    }.    puts("enter number of data items desired");    fscanf(stdin, "%ld", &num);.    buf = (float *)malloc(sizeof(float) * num);M    for(i=0, x=1.1; i < num; i++, x+=0.4567) {  /* insert arbitrary numbers */        buf[i] =  x;       printf("%f\n", buf[i]);     }A    write(filehand, (char *)buf, (int)(sizeof(float) * num) );         close(filehand);  }      read_floats(file)  char file[]; {     char filename[100];    int filehand;*    long num, i, total, bytesread, numread;    float *buf;      strcpy(filename, file);    if(strlen(filename) == 0) {.       puts("enter name of data file to read");       gets(filename);     }-    filehand = open(filename, O_RDONLY, NULL);     if(filehand == 0) {@       fprintf(stderr, "Cannot open file %s for read", filename);       exit(0);    }    num = 5; total = 0;.    buf = (float *)malloc(sizeof(float) * num);V    while((bytesread = read(filehand, (char *)buf, (int)(sizeof(float) * num) )) > 0) {(       numread = bytesread/sizeof(float);        for(i=0; i < numread; i++)           printf("%f  ", buf[i]);       puts("");        total+=numread;     }&    printf("Total read: %ld\n", total);    close(filehand);  }                                         * [RPCTRANSFER_DAT.SRC]IN_PULL.C;1 +  , &E.   .     /  @   4 P                           - -7    0   1    2   3      K  P   W   O 	    5   6    7 ս0"  8          9          G  @  H  J $ N                   ?                       /* FILE NAME: in_pull.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <sys/file.h>  #if defined(VMS) #include <unixio.h>  #endif #include "transfer_data.h"N #include "pipe_state.h"    /* definition of a state structure for pipe data */ void exit();  P void in_pull(state, buf, esize, ecount)/* input pipe uses a pull procedure<CO>*/P pipe_state      *state;               /* coordinates pipe procedure calls <CO>*/P idl_short_float *buf;                 /* buffer of data pulled            <CO>*/P idl_ulong_int   esize;                /* maximum element count in buffer  <CO>*/P idl_ulong_int   *ecount;              /* actual element count in buffer   <CO>*/ { I    /* for this application, open local source file if not open already */ !    if(state->filehandle == -1) {  @       state->filehandle = open(state->filename, O_RDONLY, NULL);#       if(state->filehandle == -1) { L          fprintf(stderr, "Cannot open file %s for read\n", state->filename);          exit(0);        }     },    /* process buffer for your application */P    *ecount = read(state->filehandle, buf, (sizeof(float)*esize))/sizeof(float);   P    /* To signal the end of data, pull procedure must set the count to 0   <CO>*/H    if(*ecount == 0) {  /* end of data reached, do application cleanup */!       close(state->filehandle);   P       /* if pipe is an in/out parameter, set the flag for push procedure  <CO>*/"       state->start_output = true;     }
    return; }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       * [RPCTRANSFER_DAT.SRC]MAKEFILE.;1 +  , oB   .     /  @   4 N      	                    - -7   0   1    2   3      K  P   W   O 
    5   6 %!  7 x7  8          9          G  @  H  J $ N                   ?                      # FILE NAME: Makefile 
# Makefile for the customized handle and pipes application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL      %        EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
# 01-Sep-1993 fwb Modified for OpenVMS/DCE POSIX
# definitions for this make file
#
APPL=transfer_data
DCL_IDL= dcl mcr dce\$$idl
IDL_CFLAGS= -v -keep c_source
IDL= $(DCL_IDL) $(IDL_CFLAGS)
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`
CFLAGS_INIT = -U VMS -I.
CC = c89
OPTFILE=/vms/sys0/syscommon/dce\$$library/dce.opt

default:	interface machine

#
# INTERFACE BUILD 
#

interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
		$(IDL) $(APPL).idl

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi

build:		utility	local	client	server
#
# COMPLETE BUILD of the application

#
# BUILD OF UTILITY to create and read files of float data  
#
utility:	float_util
float_util:	float_util.c
	$(CC) $(C_FLAGS) -o float_util float_util.c 

#
# LOCAL BUILD of the clients to test locally.
#
local:	local_client_send  local_client_receive

local_client_send:	client_send.c client_alloc.c in_pull.c \
			   send_floats.c
	   $(CC) $(C_FLAGS) -DLOCAL -I. -o local_client_send \
		client_send.c client_alloc.c in_pull.c send_floats.c 
# remove object files so they do not interfere with a real build
	   rm  client_send.o  send_floats.o  client_alloc.o  in_pull.o     

local_client_receive:	client_receive.c client_alloc.c out_push.c \
			   receive_floats.c
	   $(CC) $(C_FLAGS) -DLOCAL -I. \
		-o local_client_receive client_receive.c \
		client_alloc.c out_push.c receive_floats.c
# remove object files so they do not interfere with a real build
		rm  client_receive.o receive_floats.o client_alloc.o out_push.o

#
# CLIENT BUILDS  
#
client:	client_send	client_receive      

client_send:	client_send.o client_alloc.o in_pull.o \
		binding.o do_string_binding.o $(APPL)_cstub.o 
		$(CC) $(C_FLAGS) -o client_send \
			client_send.o client_alloc.o in_pull.o \
			binding.o do_string_binding.o $(APPL)_cstub.o $(OPTFILE)

client_send.o:	client_send.c
		$(CC) $(C_FLAGS) -c client_send.c
in_pull.o:	in_pull.c
		$(CC) $(C_FLAGS) -I. -c in_pull.c

client_receive:	client_receive.o client_alloc.o out_push.o \
		binding.o do_string_binding.o $(APPL)_cstub.o 
		$(CC) $(C_FLAGS) -o client_receive \
			client_receive.o client_alloc.o out_push.o \
			binding.o do_string_binding.o \
			$(APPL)_cstub.o $(OPTFILE)

client_receive.o:	client_receive.c 
		$(CC) $(C_FLAGS) -c client_receive.c 

out_push.o:	out_push.c
		$(CC) $(C_FLAGS) -I. -c out_push.c

$(APPL)_cstub.o:	$(APPL)_cstub.c
		$(CC) $(C_FLAGS) -c $(APPL)_cstub.c
#
# modules needed by both clients 
#
client_alloc.o:	client_alloc.c
		$(C                                                                                                                                                                                                                                   F                          $      DCEVAXMUPA013.A                
08  0?  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                         D "     ,       C) $(C_FLAGS) -I. -c client_alloc.c

binding.o:	binding.c
		$(CC) $(C_FLAGS) -c binding.c
	   
# module needed from remote_file application 
do_string_binding.o:	do_string_binding.c
		$(CC) $(C_FLAGS) -c do_string_binding.c


#
# SERVER BUILD.  Notice the server stub auxiliary file is required. 
#
server:	t_server
t_server:	$(APPL).h t_server.o send_floats.o receive_floats.o $(APPL)_sstub.o 
		$(CC) $(C_FLAGS) -o t_server t_server.o \
			send_floats.o receive_floats.o \
			$(APPL)_sstub.o $(OPTFILE)

t_server.o:	t_server.c
		$(CC) $(C_FLAGS) -c t_server.c

$(APPL)_sstub.o:	$(APPL)_sstub.c
		$(CC) $(C_FLAGS) -I. -c $(APPL)_sstub.c

clean:
	rm -f *.o $(APPL).h $(APPL)*stub.c local_client_receive \
		float_util t_server client_send client_receive
                                                                            $ * [RPCTRANSFER_DAT.SRC]MAKEFILE.OSF1;1 +  , U   .     /  @   4 ]      	                    - -7   0   1    2   3      K  P   W   O 
    5   6 +<a  7 8=a  8          9 #ΚL!b  G  @  H  J $ N                   ?                  # FILE NAME: Makefile 
# Makefile for the customized handle and pipes application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
#
# definitions for this make file
#
APPL=transfer_data
IDLCMD=idl -v  
CHECK=../arithmetic      # Directory containing check_status.h
LIBDCE=-ldce -lcma       # dce and thread libraries 
CFLAGS= -D_USER_THREADS_ 
CC= cc 


#
# COMPLETE BUILD of the application
#
all:	utility local interface client server


#
# BUILD OF UTILITY to create and read files of float data  
#
utility:	float_util
float_util:	float_util.c
	$(CC) $(CFLAGS) -o float_util.exe float_util.c 


#
# LOCAL BUILD of the clients to test locally.
#
local:	interface  local_client_send  local_client_receive

local_client_send:	client_send.c client_alloc.c in_pull.c \
			   send_floats.c
	   $(CC) $(CFLAGS) -DLOCAL -I. -o local_client_send.exe \
		   client_send.c client_alloc.c in_pull.c send_floats.c 
# remove object files so they do not interfere with a real build
	   rm  client_send.o  send_floats.o  client_alloc.o  in_pull.o     

local_client_receive:	client_receive.c client_alloc.c out_push.c \
			   receive_floats.c
	   $(CC) $(CFLAGS) -DLOCAL -I. \
		   -o local_client_receive.exe client_receive.c \
		   client_alloc.c out_push.c receive_floats.c
# remove object files so they do not interfere with a real build
	   rm  client_receive.o receive_floats.o client_alloc.o out_push.o


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o $(APPL)_saux.o
$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o $(APPL)_saux.o:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl


#
# CLIENT BUILDS  
#
client:	client_send  client_receive 
client_send:	client_send.o client_alloc.o in_pull.o \
		   binding.o do_string_binding.o $(APPL)_cstub.o 
	   $(CC) $(CFLAGS) -I$(CHECK) -o client_send.exe \
		   client_send.o client_alloc.o in_pull.o \
		   binding.o do_string_binding.o $(APPL)_cstub.o $(LIBDCE)
client_send.o:	client_send.c
	   $(CC) $(CFLAGS) -c client_send.c
in_pull.o:	in_pull.c
	   $(CC) $(CFLAGS) -I. -c in_pull.c

client_receive:	client_receive.o client_alloc.o out_push.o \
		   binding.o do_string_binding.o $(APPL)_cstub.o 
	   $(CC) $(CFLAGS) -I$(CHECK) -o client_receive.exe \
		   client_receive.o client_alloc.o out_push.o \
		   binding.o do_string_binding.o $(APPL)_cstub.o $(LIBDCE)
client_receive.o:	client_receive.c 
	   $(CC) $(CFLAGS) -c client_receive.c 
out_push.o:	out_push.c
	   $(CC) $(CFLAGS) -I. -c out_push.c

#
# modules needed by both clients 
#
client_alloc.o:	client_alloc.c
	   $(CC) $(CFLAGS) -I. -c client_alloc.c

binding.o:	binding.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c binding.c
	   
# module needed from remote_file application 
do_string_binding.o:	../remote_file/do_string_binding.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c ../remote_file/do_string_binding.c


#
# SERVER BUILD.  Notice the server stub auxiliary file is required. 
#
server:	t_server
t_server:	$(APPL).h t_server.o send_floats.o receive_floats.o $(APPL)_sstub.o $(APPL)_saux.o 
	   $(CC) $(CFLAGS) -I$(CHECK) -o t_server.exe t_server.o \
		   send_floats.o receive_floats.o \
		   $(APPL)_sstub.o $(APPL)_saux.o $(LIBDCE)

t_server.o:	t_server.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c t_server.c
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             ! * [RPCTRANSFER_DAT.SRC]OUT_PUSH.C;1 +  , o<   .     /  @   4 O       z                   - -7   0   1    2   3      K  P   W   O 	    5   6   7 }1"  8          9          G  @  H  J $ N                   ?                      /* FILE NAME: out_push.c ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <sys/file.h>  #if defined(VMS)   #include <unixio.h>  #endif   #include "transfer_data.h"N #include "pipe_state.h"    /* definition of a state structure for pipe data */ void exit();  O void out_push(state, buf, ecount)  /* output pipe needs a push procedure <CO>*/ O pipe_state    *state;              /* coordinates pipe procedure calls   <CO>*/ O idl_char      *buf;                /* buffer of data pushed              <CO>*/ O idl_ulong_int ecount;              /* number of elements for buffer      <CO>*/  {   O    /* If pipe is an in/out parameter, a state turn around may be needed  <CO>*/ $    if(state->start_output == true) {K       /* A turn around may mean the file pointer is set to the beginning */ K       /* of the file or the file is closed and reopended for write.      */ K       /* The flag must be reset so this code can only be executed once.  */ "       state->start_output = false;    }  I    /* for this application, open local target file if not open already */      if(state->filehandle == -1) {I       if(ecount <= 0)   /* if first buffer is empty, don't do anything */           return;0       state->filehandle = open(state->filename, F                                   O_CREAT | O_TRUNC | O_WRONLY, 0777);#       if(state->filehandle == -1) { M          fprintf(stderr, "Cannot open file %s for write\n", state->filename);           exit(0);        }     }O    /* To detect the end of data, push routine must test the count for 0. <CO>*/ M    if(ecount == 0)                      /* do application specific cleanup */         close(state->filehandle); M    else                                 /* process buffer for application  */ B       write(state->filehandle, buf, (sizeof(float) * ecount));    
    return; }                                                                                                                                                   # * [RPCTRANSFER_DAT.SRC]PIPE_STATE.H;1 +  , G;   .     /  @   4 O                         - -7    0   1    2   3      K  P   W   O     5   6 A ]  7 !z]  8          9 #ΚL!b  G  @  H  J $ N                   ?                   /* FILE NAME: pipe_state.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* Definition of an application specific state structure of client pipe data */
typedef struct pipe_state { 
   char *filename;              /* name of cli                                                                                                                                                                                                                                                   G                        Kُ $      DCEVAXMUPA013.A                
08  0?  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                         R "     =       ent data file   */
   int  filehandle;             /* handle of client data file */
   int  start_output;           /* a flag needed only if parameter is in/out */
} pipe_state;
                                                                            ! * [RPCTRANSFER_DAT.SRC]README.LIS;1 +  , U!   .     /  @   4 N       b                   - -7   0   1    2   3      K  P   W   O     5   6 (  7 )  8          9          G  @  H  J $ N                   ?                     
taken from Appendix F of Guide to Writing DCE Applications, by John Shirley

 



                      COPYRIGHT (C) 1993 BY
                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
                  MASSACHUSETTS.  ALL RIGHTS RESERVED.

THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY O                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ~      TRANSFER_DATA.SAV              U!  -7  ![RPCTRANSFER_DAT.SRC]README.LIS;1                                                                                              N                             W4             THER
PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.

THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.

DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.

02-Sep-1993 fwb Text for OpenVMS POSIX added




                                                                        F
        _________________________________________________________________

                                            The Transfer_data Application


              There are two clients for the transfer_data application.
              One sends a binary file of floating point data from a
              client to a server and the other receives a binary file
              of floating point data from a server. The transfer_data
              application demonstrates the following advanced features of
              IDL and RPC application development including:

              o  Using input and output pipes.

              o  Using the explicit binding method.

              o  Using a customized binding handle and the associated
                 bind and unbind procedures.


    How to Build the Application

	For OpenVMS/POSIX environments, enter the following commands:
		psx> cd /dev/mydir/transfer_data
		psx> copy /usr/dce/examples/gde_dce_apps/transfer_data/* .
		psx> make 

 	For OpenVMS environments, enter the following commands:

		C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.transfer_data]*.* []
		C$ @transfer_data

	            Running TRANSFER_DATA.COM creates all the executables 
	            for the transfer_data application.

   How to Run the Application

      To create a binary file of float data for the application:

	For OpenVMS/POSIX environments:

		psx> float_util write datafile_name
 
        For OpenVMS environments, define a foreign command with the full 
	directory specification:

		C$ float_util :== $mydisk:[trans-directory]float_util.exe

	  Then, to run the utility program, enter the following command

		C$ float_util write datafile_name


      To run the LOCAL / NONDISTRIBUTED tests of the application, use the 
      binary file of float data as a source file and a new data file
      as the target file. The host is not relevant for the local
      test. 

	For OpenVMS/POSIX environments, enter the following commands:

		psx> local_client_send source  host  target
		psx> local_client_receive target  host  source

	For OpenVMS environments define the following commands:

		C$ local_client_send :== -
		_C$ $mydisk:[trans-directory]local_client_send.exe

		C$ local_client_receive :== -
		_C$ $mydisk:[trans-directory]local_client_receive.exe

      Then, to run the LOCAL NONDISTRIBUTED tests of the application,
      enter the following commands:

		C$ local_client_send source  host  target
		C$ local_client_receive target  host  source

      To run the server for the clients of the DISTRIBUTED application:

	For OpenVMS/POSIX environments, enter the following command:

		psx> t_server

	For OpenVMS environments, enter the following commands:

		S$ t_server :== $mydisk:[trans-directory]t_server.exe

              Then, to run the server, enter the following command:
	
		S$ t_server

	      
      To run the client of the distributed application the network
      address of a remote server is needed for "host" (ex. 16.33.3.92)  
      If the server is running on your local node "host" can be the node name.

	For OpenVMS/POSIX environments, enter the following commands:

		psx> client_send  source  host  target
		psx> client_receive target  host  source

	For OpenVMS environments, enter the following commands:

		C$ client_send :== $mydisk:[trans-directory]client_send.exe
		C$ client_receive :== $mydisk:[trans-directory]client_receive.exe

              Then, to run the client, enter the following commands:

		C$ client_send source  host  target
		C$ client_receive target  host  source


              Application Files

              Makefile:  The Makefile contains descriptions of how the
              application is compiled in the OpenVMS POSIX Environment.
	      Previous builds can be cleaned up by entering:

psx> make clean

              Makefile.osf1:  The Makefile for OSF/1 systems.

              transfer_data.com:  The command procedure file for OpenVMS 
	      systems.

              float_util.c:  This contains code that generates and writes
              a binary file of float data or reads a binary file of float
              data.

              transfer_data.idl:  The interface definition contains the
              description of the constants, data types, and procedures
              for the interface.

              client_send.c:  This client demonstrates use of a pipe that
              is an input parameter. The customized binding handle is
              initialized, the pipe structure is initialized for an input
              pipe, and the remote procedure send_floats is called to
              transfer pipe data to the server.

              client_receive.c:  This client demonstrates use of a pipe
              that is an output parameter. The customized binding handle
              is initialized, the pipe structure is initialized for an
              output pipe, and the remote procedure receive_floats is
              called to transfer pipe data from the server to the client.

              binding.c:  This contains the bind and unbind procedures
              the client stub calls to obtain and free a binding handle.
              After the customized binding information is initialized in
              the client application, the binding is handled entirely by
              the client stub with these routines.

              send_floats.c:  This contains the implementation of the
              send_floats remote procedure.

              receive_floats.c:  This contains the implementation of the
              receive_floats remote procedure.

              t_server.c:  The server is initialized with a series of
              runtime calls prior to servicing remote procedure calls.
              In this application, all protocol sequences available are
              registered. The server is not advertised in a name service
              database. The server's dynamic endpoints are added to the
              server's local endpoint map. A client finds this server
              by constructing a string binding containing a protocol
              sequence and the host name or network address.

              pipe_state.h:  For this application, the pipe state
              is a structure containing a client file name, its file
              handle, and a state turn around flag.

              client_alloc.c:  This contains the client_alloc
                                                                                                                                                                                                                                                        H                        Z7 $      DCEVAXMUPA013.A                
08  0?  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                          "     N                procedure which the client stub calls to allocate a buffer
              for pipe data.

              in_pull.c:  This contains the in_pull procedure which
              the client stub calls to process input pipe data.

              out_push.c:  This contains the out_push procedure
              which the client stub calls to process output pipe data.




                                                                                                                                                                                                                                                                                                                                                                                                                                            ' * [RPCTRANSFER_DAT.SRC]RECEIVE_FLOATS.C;1 +  , U!   .     /  @   4 P                           - -7   0   1    2   3      K  P   W   O 	    5   6 Kq  7  wv1"  8          9          G  @  H  J $ N                   ?                /* FILE NAME: receive_floats.c   ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <sys/file.h>  #if defined(VMS)   #include <unixio.h>  #endif   #include "transfer_data.h" #define MAX_ELEMENTS  1000  N void receive_floats(c_b_h, out_data)   /* copy server file data to a client */9 file_spec c_b_h;          /* customized binding handle */  pipe_type *out_data; {     int             file_h;K    idl_short_float buf[MAX_ELEMENTS];       /* pipe data buffer          */ K    idl_ulong_int   element_count;           /* number of elements pushed */     int             nbytes;     +    /* open local file on server for read */ :    file_h = open((char *)c_b_h.filename, O_RDONLY, NULL); 3    nbytes = sizeof(idl_short_float) * MAX_ELEMENTS;       if(file_h > 0) {        while(true)  {P          /*****        application specific process of buffer        *****<CO>*/M          element_count = read(file_h, buf, nbytes) / sizeof(idl_short_float); &          if(element_count == 0) break;  P          out_data->push(     /* push routine is used for an output pipe   <CO>*/N             out_data->state, /* the state is controlled by the stub         */N             buf,             /* the buffer of data to send                  */N             element_count    /* the number of data elements to send         */          );        }        close(file_h);    }  P    out_data->push(out_data->state, buf, 0);    /* 0 indicates end of pipe <CO>*/
    return; }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             $ * [RPCTRANSFER_DAT.SRC]SEND_FLOATS.C;1 +  , G9   .     /  @   4 P                           - -7    0   1    2   3      K  P   W   O 	    5   6  b  7  u1"  8          9          G  @  H  J $ N                   ?                   /* FILE NAME: send_floats.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <sys/file.h>  #if defined(VMS) #include <unixio.h>  #endif #include "transfer_data.h" #define MAX_ELEMENTS  1000  G void send_floats(c_b_h, in_data) /* copy input data to a server file */ G file_spec  c_b_h;                /* customized binding handle        */  pipe_type in_data; {     int             file_h;L    idl_short_float buf[MAX_ELEMENTS];        /* pipe data buffer          */L    idl_ulong_int   element_count;            /* number of elements pulled */  ,    /* open local file on server for write */M    file_h = open((char *)c_b_h.filename, O_CREAT | O_TRUNC | O_WRONLY, 0777); N    if(file_h < 0)      /* If can't open file, need to discard the pipe data */1       file_h = open("/dev/null", O_WRONLY, NULL);   P    while(true) {             /* entire pipe must be processed             <CO>*/P       (in_data.pull)(        /* pull routine is used for an input pipe    <CO>*/N          in_data.state,      /* state is controlled by the stub             */N          buf,                /* the buffer to be filled                     */N          MAX_ELEMENTS,       /* maximum number of data elements in buffer   */N          &element_count      /* actual number of elements in the buffer     */       );P       if(element_count == 0) break;      /* 0 count signals pipe is empty <CO>*/P       /****          application specific process of buffer        ****   <CO>*/D       write(file_h, buf, (sizeof(idl_short_float) * element_count));    }      close(file_h); 
    return; }                                                                                                                                                                                                                                                                                                                                                                                                           ( * [RPCTRANSFER_DAT.SRC]TRANSFER_DATA.COM;1 +  , G<   .     /  @   4 b                           - -7    0   1    2   3      K  P   W   O 	    5   6 nw  7 dKSnw  8          9          G  @  H  J $ N                   ?               $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! Abstract:A $! 	TRANSFER_DATA.COM -- Builds the transfer_data example program  $! $! Modification History:0 $! 02-Sep-1993 fwb Modified for OpenVMS/DCE V1.1 $! $@DCE:DCE$CC_TEST  $!cc := cc'f$trnlnm("dce$cc")' $! Determine option files $ $ IF( f$trnlnm("dce$cc") .eqs " " ) I $ THEN	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options" & $ ELSE	options = "dce:dce.opt/options" $ ENDIF  $!- $! Enable the universal IDL command interface  $idl := mcr dce$idl  $ " $! Compile the interface defintion $idl -v transfer_data.idl  $ = $! Make ULTRIX-style reference for #include <sys/file.h> work  $ define sys sys$library $! $ cc/g_float t_server  $! $ cc := cc'f$trnlnm("dce$cc")' $!' $! Build the float_util utility program  $cc/g_float float_util $link float_util,'options' $ ) $! Build the local version of the example R $cc/g_float/define=LOCAL/include=([]) client_send,send_floats,client_alloc,in_pullR $link/exe=local_client_send client_send,send_floats,client_alloc,in_pull,'options'L $delete client_send.obj;*,send_floats.obj;*,client_alloc.obj;*,in_pull.obj;* $ Y $cc/g_float/define=LOCAL/include=([]) client_receive,receive_floats,client_alloc,out_push \ $link/exe=local_client_receive client_receive,receive_floats,client_alloc,out_push,'options'S $delete client_receive.obj;*,receive_floats.obj;*,client_alloc.obj;*,out_push.obj;*  $ % $! Build files common to both clients ? $cc/g_float/include=([]) binding,client_alloc,do_string_binding  $ - $! Build the transfer_data client client_send , $cc/g_float/include=([]) client_send,in_pull^ $link client_send,transfer_data_cstub,client_alloc,in_pull,binding,do_string_binding,'options' $ 0 $! Build the transfer_data client client_receive0 $cc/g_float/include=([]) client_receive,out_pushb $link client_receive,transfer_data_cstub,client_alloc,out_push,binding,do_string_binding,'options' $ ! $! Build the transfer_data server & $cc/g_float send_floats,receive_floatsG $link t_server,send_floats,receive_floats,transfer_d                                                                                                                                                                                                                                                   I                        f)% $      DCEVAXMUPA013.A                
08  0?  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                         uK "     _       ata_sstub,'options'  $  $! Example command defintions B $ float_util == "$ " + f$environment("DEFAULT") + "float_util.exe"P $ local_client_send == "$ " + f$environment("DEFAULT") + "local_client_send.exe"D $ client_send == "$ " + f$environment("DEFAULT") + "client_send.exe"J $ client_receive == "$ " + f$environment("DEFAULT") + "client_receive.exe"                                                                                                                                                                                                                                                                                                                                                                                            ( * [RPCTRANSFER_DAT.SRC]TRANSFER_DATA.IDL;1 +  , U   .     /  @   4 K                         - -7   0   1    2   3      K  P   W   O     5   6 aD]  7 !!D]  8          9 #ΚL!b  G  @  H  J $ N                   ?              /* FILE NAME: transfer_data.idl 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
[
uuid(A6876974-F555-11CA-BAE1-08002B245A28),
version(1.0) 
]
interface transfer_data   /* data transfer to and from a remote system */
{
   const long NAME_LENGTH = 200;

   typedef [handle] struct {          /* a customized handle type */
      char host[NAME_LENGTH+1];
      char filename[NAME_LENGTH+1];
   } file_spec; 

   typedef pipe float pipe_type;      /* a pipe data type            <CO>*/

void send_floats(       /* send pipe of floats to a file on the server */
   [in] file_spec  cust_binding_h,    /* customized binding for server */
   [in] pipe_type data                /* input pipe of float data    <CO>*/
);

void receive_floats(   /* get pipe of floats from a file on the server */
   [in] file_spec  cust_binding_h,    /* customized binding for server */
   [out] pipe_type *data              /* output pipe of float data   <CO>*/
);
}
                                                       ! * [RPCTRANSFER_DAT.SRC]T_SERVER.C;1 +  , U   .     /  @   4 P                          - -7   0   1    2   3      K  P   W   O 	    5   6  \]  7 n1"  8          9          G  @  H  J $ N                   ?                     /* FILE NAME: t_server.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include "transfer_data.h"             /* header created by the idl compiler */
#include "check_status.h"              /* contains the CHECK_STATUS macro    */
main ()
{
   unsigned32             status;          /* error status (nbase.h)         */
   rpc_binding_vector_t   *binding_vector; /* binding handle list (rpcbase.h)*/

   rpc_server_register_if(       /* register interface with the RPC runtime */
      transfer_data_v1_0_s_ifspec, /* handle to interface specification     */
      NULL,                     
      NULL,                     
      &status                   /* error status */
   );
   CHECK_STATUS(status, "Can't register interface\n", ABORT);

   rpc_server_use_all_protseqs(            /* establish protocol sequences  */
      rpc_c_protseq_max_reqs_default,      /* queue length for remote calls */
      &status
   );
   CHECK_STATUS(status, "Can't establish protocol sequences\n", ABORT);

   rpc_server_inq_bindings(     /* get set of this server's binding handles */
      &binding_vector,
      &status
   ); 
   CHECK_STATUS(status, "Can't get binding handles\n", ABORT);

   rpc_ep_register(                /* add endpoint to local endpoint map    */
      transfer_data_v1_0_s_ifspec, /* handle to interface specification     */
      binding_vector,              /* vector of server binding handles      */
      NULL,                        /* no object UUIDs to register           */
      (unsigned_char_t *)"transfer_data server", /* annotation (not required) */
      &status 
   );
   CHECK_STATUS(status, "Can't add endpoints to local endpoint map:", ABORT);

   puts("Listening for remote procedure calls...");
   TRY
      rpc_server_listen(                   /* listen for remote calls       */
         rpc_c_listen_max_calls_default,   /* number of threads             */
         &status
      );
      CHECK_STATUS(status, "rpc listen failed:", RESUME);
   FINALLY
      puts("Removing endpoints from local endpoint map.");
      rpc_ep_unregister(     /* remove endpoints from local endpoint map    */
         transfer_data_v1_0_s_ifspec, /* handle to interface specification  */
         binding_vector,             /* vector of server binding handles    */
         NULL,                       /* no object UUIDs to unregister       */
         &status 
      );
      CHECK_STATUS(status, "Can't remove endpoints from endpoint map:", RESUME);

      rpc_binding_vector_free(               /* free set of binding handles */
         &binding_vector,
         &status
      ); 
      CHECK_STATUS(status, "Can't free binding handles and vector\n", ABORT);
   ENDTRY
}
                                                                                                                                                                                                                                                                                                                      *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 J                        7 $      DCEVAXMUPA013.A                
08  0?  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                         ѡ      p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * [SYSHLP.EXAMPLES.DCE]POSIX.DIR;1 +  , 4   .     /  @   4                            - ;    0   1    2   3     K  P   W   O     5   6    7 PaF   8          9          G  @  H   J  I                           	POSIX.SAV  1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       & * [SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1 +  , 1   .     /  @   4   ~           ~               - 4    0   1    2   3      K  P   W   O     5   6 .d  7     8          9          G  @  H   J                                                                                                                                                                                                               K                        2A $      DCEVAXMUPA013.A                1  4  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                         tu "                                         ~      	POSIX.SAV                                                                                                                                                                                                                  	  POSIX.SAV4  BACKUP SRC$:*.* OBJ$:POSIX.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   ȏpd      V5.5	 	 _OPNSME:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                     * [POSIX.SRC]ACL_EDIT.;1 +  , .?   .     /  @   4        	                     - R\   0   1    2   3      K  P   W   O     5   6 x\  7 _d  8          9          G  @  H  J $ N                   ?                 0 D `     0205        q+       h  
                                   _0_35800499_ACL_EDIT_PSX_VAX           V1.0           vq+ 05-13                                             
       ?   $ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !         DECC$SHR_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001#      +        POSIXC$SHR_001  h
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
         ^  ݬݬ"  Pw  ݭp  խЭP   P    P      '  Տ      }      Տ        DPP  RP+`P  AP`P  $P	`Py  PP[  PP  PPC  PPU  P``P<  P``P#  PP  PP   uPP   @\kЬ_ޯAPKEPQl`7.)мPQl` @\                    @   @                                                              P   H   @   8         L                   @   <   ,   (   $   D   H             0          
   
                 @                                                                       DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DECC$SHR                                                       DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        
POSIXC$SHR                                                                                             VMS_ACL_EDIT 
  main G   		
         POSIXC$INIT h
  POSIXC$$INITIALIZE P
  POSIXC$$PRIVATE_ERRNO \
  POSIXC$$PRIVATE_VMSERR    LIB$INITIALIZE      ERRNO       ERRNO$     4  
VAXC$ERRNO     4  VAXC$ERRNO$       ENVIRON       STDIN    $  STDOUT      STDERR    ,  TZNAME       DAYLIGHT    (  TIMEZONE      OPTARG      OPTERR      OPTIND      OPTOPT      SIGNGAM       _IOTABLE    P
  $CODED                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   * [POSIX.SRC]CDSCP.;1 +  , .7   .     /  @   4        
                     - R\   0   1    2   3      K  P   W   O     5   6 3l|  7 Hud  8          9          G  @  H  J $ N                   ?                    0 D `     0205        <       h   
                                   _0_3580022F_CDSCP_PSX_VAX              V1.0           < 05-13                                             
       ?   % '    !        DCE$UTIL_SHR_001$ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001!      !         DECC$SHR_001      !      h  
SMGSHR_001#      +        POSIXC$SHR_001  T
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ^  ݬݬ*  Pݭ  խЭP  P    P      ;  Տ    +        Տ        XPP  fP?`P  UP.`P  8P`P  3PPo  PP  PPW  PPi  P``PP  P``P7  PP%  PP  PP   @\ЬsޯAd_YPQl`KB=мPQl` @+\                                        @   @                                                      0O       P   H   @   8      
   L                   @   <   ,   (   $   D   H           0          
   
                 @                                                                       DCE$UTIL_SHR                                                   DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        DECC$SHR                                                       SMGSHR                                                         
POSIXC$SHR                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                L                        |VN $      DCEVAXMUPA013.A                1  4  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                         y "                                                                
VMS_MGMT_MAIN  
  main <   9 
         POSIXC$INIT T
  POSIXC$$INITIALIZE <
  POSIXC$$PRIVATE_ERRNO H
  POSIXC$$PRIVATE_VMSERR    LIB$INITIALIZE      ERRNO       ERRNO$     4  
VAXC$ERRNO     4  VAXC$ERRNO$       ENVIRON       STDIN    $  STDOUT      STDERR    ,  TZNAME       DAYLIGHT    (  TIMEZONE      OPTARG      OPTERR      OPTIND      OPTOPT      SIGNGAM       _IOTABLE    <
  $CODED                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * [POSIX.SRC]DCE_DEFS.SH;1 +  , .9   .     /  @   4                          - R\   0   1    2   3      K  P   W   O     5   6 `'oRg  7 LSg  8          9          G  @  H  J $ N                   ?              #!/bin/sh
# This script is called from /etc/profile to set up DCE specific environment for
# the user.
#
#
# Add path /usr/dce/bin to the users path name
#
if [ -L /usr/dce/bin ]
then
	export PATH=$PATH:/usr/dce/bin
	echo /usr/dce/bin added to PATH
else
	echo /usr/dce/bin does not exist! PATH not updated!
fi
#
# Provide aliases for DCL calls to VMS images
#
alias -x rpccp="dcl mcr sys\\\$system:dce\\\$rpccp.exe"
#
#
#
                                                                                                        * [POSIX.SRC]DCE_LOGIN.;1 +  , !%   .      /  @   4                              - R\   0   1    2   3      K  P   W   O !    5   6 Se_~  7 od  8          9          G  @  H  J $ N                   ?   $             0 D `     0205               hX                                     _0_3580023F_DCE_LOGIN_PSX_VAX          V1.0            05-13                                                
       ?   $ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !         DECC$SHR_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001#      +        POSIXC$SHR_001  ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         KRB5CCNAME  LNM$PROCESS Error: Cannot acquire logical name "%d"
 def_log %s '%s'  Error: cannot define %s logical name
 -c  -exec -e Command must be specified after -exec
 Usage: %s [username] [password] [-c] [-exec | -e <cmd_string> ]
 Illegal argument %s
 Usage: %s [username] [password] [-c] [-exec | -e <cmd_string> ]
 Enter Principal Name:  Enter Password:   Validation error: %s
 Password must be changed!
 Credentials obtained from local registry.
 Validated from local override entry, no network credentials obtained.
 Unable to set context: %s
   Sorry.
Password Validation Failure.  - %s
  
   Sorry.
User Identification Failure.  - %s
  
 dce_login_noexec  %s
 KRB5CCNAME  Unable to execute %s
 
 An OpenVMS POSIX child C shell is now being created
  Unable to establish User Principal's Credentials
 SHELL       /bin/sh Unable to execute %s
                      < ^}ϋRR(ݬ	  PЬRR>RRݬ  PP`RR=
<RRR  PC2R B2RRRF
  PV  PPݬϻ0   P  Δ^ݬݬϹ͕  ͕
  P Pݬϝ
  ЏPP ^
  
SRT L H D 441_4P޼Q@a{
  PD1_P;4P޼Q@aS
  P$4P޼Q@a6
  Pb4PP;bPPP	  ޼P`	bPPP	  	  4QЬPAPP1 1 PL4P޼Q@aL1 HZݏ   4P޼Q@a	   4P޼Q@a}	  P 4P޼Q@ag	  HH4P޼Q@aϋbPPP	  ޼P`τbPPP	    4PP441fL1 χ  bPPP  bP PPݏ     PLL
|  L  P00QLPAPP
0QLP A0PP,  PLL
#  L2   $ L  P1H7Џ   00 ϫ  P,,
  PP  D* 8@$6  P<(P 8@$  P<<1  '(X   X%  @bPPP  8bPPP  8bPPP  H $o   1(X W  X  t  TPx   *(X   XK  
<    R$   *(X   X  
    ޼P`  P+  Pϻ     1 P&  ϓt  1 >PccCc*P

(  c  [&  Q  y  
  ϕ  PPP
ϋPPP޼PP`ЬP ݬP  Pb  	  TTTP     P    P    @  G  Տ    7        Տ        PP  Pg`P  PV`P  lPE`P  gPP{  %PP  GPPc  PPu  P``P\  P``PC  PP1  PP  PP%   @\ЬޯAPQl`sjeмPQl` @S\                                                                                                                                                                                                                                                                                                                                                                                                                                           M                         $      DCEVAXMUPA013.A                1  4  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                         ? "     #                                                                                                                                                               @   @                                                    x      h              P   H   @   8               .   	            
      X
  P
  H
  @
  8
  0
  (
   
  
  
  
   
                                  x  p  h  `  X  P  H  @  8  0  (             L                   @   <   ,   (   $   D   H           0  x  `           X         h  `  p             
                 @                                                                       DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DECC$SHR                                                       DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        
POSIXC$SHR                                                                                                                                                                                                                                                                                                                                         	DCE_LOGIN 
  
getenv_log      
setenv_log [      main 1  		t)
  S   
 
	)   "       
        POSIXC$INIT ,  POSIXC$$INITIALIZE   POSIXC$$PRIVATE_ERRNO    POSIXC$$PRIVATE_VMSERR    LIB$INITIALIZE      ERRNO       ERRNO$     @  
VAXC$ERRNO     @  VAXC$ERRNO$       ENVIRON    ,  STDIN    0  STDOUT    (  STDERR    8  TZNAME      DAYLIGHT    4  TIMEZONE      OPTARG      OPTERR      OPTIND      OPTOPT    $  SIGNGAM       _IOTABLE      $CODED                                                                                                                                                                                                                                    * [POSIX.SRC]KDESTROY.;1 +  , .:   .     /  @   4        	                     - R\   0   1    2   3      K  P   W   O     5   6 3  7 ٩d  8          9          G  @  H  J $ N                   ?                 0 D `     0205               h  
                                   _0_3580024C_KDESTROY_PSX_VAX           V1.0           􀐘 05-13                                             
       ?   $ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !         DECC$SHR_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001#      +        POSIXC$SHR_001  p
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
         ^  ݬݬ"  Pw  PխPPh  խЭP   P    P        Տ      u      Տ      y  <PP  JP#`P  9P`P~  P`Pq  PPS  PPy  PP;  PPM  P``P4  P``P  PP	  PP   mPP    @\cЬWޯAHC=PQl`/&!мPQl` @\            @   @                                                              P   H   @   8         L                   @   <   ,   (   $   D   H             0          
   
                 @                                                                       DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DECC$SHR                                                       DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        
POSIXC$SHR                                                                                             VMS_KDESTROY 
  main O   		
         POSIXC$INIT p
  POSIXC$$INITIALIZE X
  POSIXC$$PRIVATE_ERRNO d
  POSIXC$$PRIVATE_VMSERR    LIB$INITIALIZE      ERRNO       ERRNO$     4  
VAXC$ERRNO     4  VAXC$ERRNO$       ENVIRON       STDIN    $  STDOUT      STDERR    ,  TZNAME       DAYLIGHT    (  TIMEZONE      OPTARG      OPTERR      OPTIND      OPTOPT      SIGNGAM       _IOTABLE    X
  $CODED                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     * [POSIX.SRC]KINIT.;1 +  , @.<   .     /  @   4        	                     - R\   0   1    2   3      K  P   W   O     5 	  6 is  7 hd  8          9          G  @  H  J $ N                   ?                    0 D `     0205        G)       h  
                                   _0_35800282_KINIT_PSX_VAX              V1.0           ^nG) 05-13                                             
       ?   $ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !         DECC$SHR_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001#      +        POSIXC$SHR_001  p
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 N                        3% $      DCEVAXMUPA013.A                <:  <$  ^[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.S\J,:
 
h	pTA.SAV;1                                                              ~   ~                          8            )M)k}J$=x`{E
^VcX#WxLQ71eYIiE</]=m3Wxcfy1}ILe&K`E.b3.T$_y(!n5N|)uiy[s[a/i?\bts\ .e0Cy &D.RP,NB}'&i-]C(5/rBjO
h^d=a_:1(ߥp=8B6L_wRPxN&RYoL\ipv3'h\yC<Q%0X{]z	P?ej|q=~CN7n؆Pv={d:(OP]*Fq<z<3>[b4S)vn;Iu]=>ta|-hjuG@d\~kFbx6@ zrx9N}~ <V
C+>]Z@TegW+6tI
^pe_hn"2s7t 4I~_E?c+[S¬Ǵ[I<XׄspZwAr`%~}tW.wsMAQTtZ(v=D!@&y^
	g}*9^J,N?ѾpwF
; tN/ܳ<z>'jaoeE|OuPqPStVI0W}w- Xy
Hc:q/Ed'[j0c`sw5={S{feg_4?!ij_=oO`'34}
qxX=x4:M~(y*z=Ygi$.n{>pxbW)lQ7r%78-"\ksh4jto^UdVyXt|lDl4Kbw+JTaZ|,.+Z!?sD<e
2P$([h0J0d)EoYH[e=!zmn|#"]RCʳ!;0O>~"5k0PygEUR+NAY_LEvPW/X,RI<k2TT}WAopuV0jH`h2.5v#sW"	}
f{wH>p`!I;0@T	q{u	np2.=?(NOIsG|eJj%Kut9? "gZU"6MEݦe= \JeE&rqz bȷ3UzQ	,͠kT;rtkA'+i0cHI?+	x/l.ˢ@2cDDSS$KB.Kk{4enܗ5cQ_k=)Խ$1jKbv41h&	8Ww^oON4I"}Bc?#6i8A_2AE7DeW~!"Tt!Mm~qFkVAPV*u/#27jjUX?	Fw?g(

TV^4-^UM|㣜
 )z"E]-K[
qr<Ko(RcK\	U\IxXe#CR/!	JBX
b
!>y:&8[<A_(mYg;k;h^{UV(J Md&j)n{8DX#  "etT7y|4!}!D,5>+0X&y#|5G|U9TcR({q%(;E[/.v	.wpY!m[j޴#޽ƞ'O܋܋|uɀɽQۤaȟǾ˸݁ԙ#[KHVoGCՑ_.ᦎ觲ky҅uK%WVm]W·Ɲ6锻ۨ}Դo$Q3fљ(ۗǬ뙰āǱڬ⇨ȅ곅К	-㗹擻ǩܓ퀕d͞ټà*HϊM`nĶ^{Y~_)h{`~XЍuTmv%9t¥?@c/ć皨RB}Ir._Dbh0{
kNX]d3/CXA`5G<3+n퇼y
t4jR_#YvdqLOOA wНfW+Eԟ59XU;X̨}E$ZE]=Hmw
eMR֦uqAQ
>[d}"jW|}$Mqn	Rnl8H%{fe]t:gV"RKw!)S'ǊݷWZr:FChJE=G."6DT|M&GB(ٽyuQ5Q	>Xx<<$ <
wqs;H>Fo-/S/i@ԄEE)Ɂz{2YTᨌ_&-Yd;vA]~`ų6 d#VR`eTF$v4_3T`r\{Q
AArg#!eP;k6m-,>ip
:׳sDctlPԸcLI%}U7~oPDqkp)9?yy"I4B$A:ڇ)QV3ĲAi&_=fGp>s"xgִN#Pfƌ0,%Èd|!M*ymaN0M_ʷZl
A^yra зT~dRCu;țfhsʐ"8b'R^Dwhч
0I}dYڑ.DQx兑'E#QD#)@jꇠFNMr.`y hrjYdmQɼ3W.gȒSWmdzf`'
	'Ыы$m:˱'bO`'J#)F`!cѴuxO]iS ѭ&8!{v015u]M).RvKT s#Di[1~%߀ʳ륐(Hky\̾'Ѕ
i÷(Tf3S[ـ:IMЍܬתTۑܰD37ϺBYȏDiO}ܯ2 񅯛VA&L&K6X9&'DXЀ;5$و|f21xXfħ­ۣ(Z--(ؿTZl㔷E 6 =w|Ϩ1Ap▛ɩV{˾] ]}\\>'Qbc,qQ*IR&[`EeLjez2j,t@V2;\PHS
QoS`	Ivze"Lk2cЙ52Rj@O>yuE;OD'l!sKf`]^XO2HMW^Q?Pxk?V4YsNuv<6_~>[^9G{FQD1/=[oJ?1%02![{S?2j#@|.5N7Rb&7]YnCJI  SKi-bau{G/OVY@s4a{aqt	{h2(,#{8}^BU%uK.J\ O(9^YOUtԡ棨ʀB
B_c\wNm dW,%QS6f32:f(07opyZ=g]>lp#UY(_;|;4SdhQ*^i7Ljh^ndn@Y]9C{FL1=4_j;TkHV0clR6oPtQW;k%:*2#iB{S4
bvwNFq4"Kc-eS)<͠ĴǪƓӆӋڄĥ؁ܾʠ妜Ƭ򇍑޺âʂ丨ƂN삵ِ!ܰךϨӧƂȑڝۭ)㝞2q̜)g3OX՚p,WDhR4iԸ脋̯uB,2һ¿円ٖȮж'֘޴9v!aĀMƔ:ٴ귺۝a:СVUB,-@y{OR+%%'B?#	=O,`Lx'\It?n-r
x9^(DOP(QT}T	"ec/lmaJ9YlBx).SI!2O\$	s&}lkNI&H:zT4B)tS<^}<G(r,qU5t;u&"]L$Fm{._9n!v!+@aF G8OwYicVwy#Sbz,/%7v4)Ed!p{	\{g
*Q!E%ZGMG3ZHC)&xF6F&dvI2Trs'
y1YY4q}#:'M3LYo0T(f=	,dF_xq7glD@^a0'7$.(eerG4n9Z
RfQ	
y:4>.<n7J0mv.$qbPfL+Bn%P1&2I.~GC  /bzim!_ A0nzk'RPEa,Fg~-{|ic8l N
 eJ;fU;<3sGCz^-@x >sLJdY>n0AEP#teDLr:]lJ$d8?/TNy'9HUuW[GJ#G2=ۉ
:i*V
GOjFZhx`+h"u.h2lIPB2jY73'Q)%opoyVm]o߃.a0UV~i~,uh^aRVU෌7~,}_督f.xf+>;>Afo Zą8(W1x׭4˵t:!+9U=jgl=%Eߐ_0ȽuE/~oK!/ G)+hۙXbyzǹf5ǟ[Z_ĐCحȱ>SVWL>'BM'!%EX_\
ӻkVR`NY\b<Q`7!G Pws)YFffh"
&
YK2EB}jj%5xT|'+2gYCFъ_-ڎF.Df#>u
c,*8!G8@Z&
SM	#hzZ48efqw0iGB_9zy;>>s[}zy;+md!LRQ?jG?.B[WaAvGPP%7nAL
:FTd8Ssv^V)$	&:@M@S}J_YxF{~}{e3=sP=^@wT?j嵪3,n
T>pT:;aVV>{Xd,Wut&G@!T-k%/@)!Ny1rcB	 I$i=utrs2W&BC'
ٸ\2(crvPZNP/alu^!B/,2-
:qIwUj {D]c,|c''HbiIO1S/a	z (&mNJYogtrevz[k6 hLw#Xy|8dmOO
C1~j"*Ftd6wN.*)ZM|]|)C=H A$5\\CgNkvs Y	!vH6`aj miQ0OD@;b+Re?9YolF !27MlK:2^$]d!c.,5}EfFUg[MXXDX=!.K[pbHpP|d	:H	(	]\*u>fHRU,\7I.zm.*6Je)|ms$w;3PjId}B53RM8*oki/8AeO=pu@9<GV|`@U{vCSN9<Z["<e6Eg/yqD]zZ3&$ZDyulCG Ocu ysJjFsE3-Zވׄ
R
UY>)brlauyAu~:(2Loкya
rwzRkq^n2bHEG>kOz|eD,
*h:e
+u?w[\6-[4)w5Lqj
8<U`a+I@
q%^bYk?UekFB{θG'$3:Tx	ea5u^<)PqC=CbW:f= l.,!\I)o	x6r/ʉ~`RP\fq<٘݅Ġoel
:Œqǜд/נuQaڿBeLa0txQPԶoȒןѬbܰC	߻pU!l,݄Q8cFۮܨ$xCZ_cUgc{'bMzYW'p݊g&kJ7bŨPƇ* Gt5z[&ePQT<,@9]U0n!D?b$\ 0IQ/_ZF'!jKVrO`P.Tglf*gsnCȌInYiBGV;Źn
-$!?U] RP?\Mu<WIxϩYdZ4ITnQ	.Z8|w-xvBq3k9BV&ZRڪ֖
x\82&y@KFU=fĔ8X?B(y_b
hg<H`P/H&E(ffiAW+~l?6nZ	Tjq@
scupXT**@t&ldFx(").^^vu
B/zi`7S>"yh`[pXW}VJ͘͢
˵G"Mk|M3hvP-wUMA̤3B>ٵz7 o~#=vյN՚)=
ů6s\?ǟpz/}^A,@`j4MRglh Ϯ}>oz[מ1*ɪڗq>-OߊYS)u-(Wc)\̋T<	M&>q_5"iKV82bD@nL̕uAG1U]jIMl̅ߦ8 BQ
?u55lЀelC]%kk
z+ o}M	J `4.sKKM_fUS6	fGaO΅p!EW7በtvwEQu7KX?еfe+=R5Кȏr#coKQHA=M6kD\}	
^8yרw0J+i.Þumbtb&d.SeOg$l[">jWLUh5ˎMcې]/{Go᳛DZH!o<!$4<L˪0SubʷnG@ܼL+C)oĀd⋭\V1tkEabv=G&8xAКjkT_fZ	.-zX:je4RqUݕ}CgB/ȵ5eMC0}nxHHAC&#(
ed*+ts`|VRHAQ&UoHVy(.1 9ArԤak5(r$vXDb8WD\)o0)R (K{PpTpRGY$OK; vlpU66tޅ]`}Jc5#JjtH9eV$^ ^W]YRKv zб}#BS^QL@o7W,
Pc>."J8M0sdJCN@y3xn_4i-4ibxN" mvaD<.nn	MKQ~ZP,?Rxu"Zu?X*Dq)5_X=nlCws+,m]B y#H~p0Iv6ad'[=
&7$'w9$޸R
h߻|2o+A5J6R4awRF|8z:M}DeZD\jØ>Ս̕2nR4r
۫`5Rܲwd+ɽy_ٻ$u"G:y/D3w|֒&n/yz
U]:\w4~\+Rc
J<S%?`Q8֦Irt:xLF G|H`Z0%'&h贙LMkF|`)n6c."r	O8Ygohli CApfX_,i]H-ɔMS%MJ6.HEdd9*fr/[dz7Eܘⱃ"6?ĥ1<`98MwMfh	yCZ*OkVx^`D"j|:2)77	gk;<a4sJJyJG5IiOl%i
WtCX-ibuFqV4Z</hILoC"Z2-3qnSX|4v.a<7vrq	Ld ea1+CL;<1]RgP3{~=Fq"-I'0rBh991	eOpZ0H6uB5PIsp
7E]EN[afdmX.p 	$wg!GA*4zHV57,y#X [,PCVRONSFRPDyT.SRC]CLIENt^QECEIVE.C;1 + &*,[JbRGMKTk    /  @   4p                                                                                                                                   O                         $      DCEVAXMUPA013.A                1  4  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                          "     4                                                                                                                                                                                                                                                       
         ^  ݬݬ"  Pw  PխPPh  խЭP   P    P        Տ      u      Տ      y  <PP  JP#`P  9P`P~  P`Pq  PPS  PPy  PP;  PPM  P``P4  P``P  PP	  PP   mPP    @\cЬWޯAHC=PQl`/&!мPQl` @\            @   @                                                              P   H   @   8         L                   @   <   ,   (   $   D   H             0          
   
                 @                                                                       DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DECC$SHR                                                       DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        
POSIXC$SHR                                                                                             	VMS_KINIT 
  main O   		
         POSIXC$INIT p
  POSIXC$$INITIALIZE X
  POSIXC$$PRIVATE_ERRNO d
  POSIXC$$PRIVATE_VMSERR    LIB$INITIALIZE      ERRNO       ERRNO$     4  
VAXC$ERRNO     4  VAXC$ERRNO$       ENVIRON       STDIN    $  STDOUT      STDERR    ,  TZNAME       DAYLIGHT    (  TIMEZONE      OPTARG      OPTERR      OPTIND      OPTOPT      SIGNGAM       _IOTABLE    X
  $CODED                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        * [POSIX.SRC]KLIST.;1 +  , C.7   .     /  @   4        	                     - R\   0   1    2   3      K  P   W   O     5 
  6 [  7 Ⱥd  8          9          G  @  H  J $ N                   ?       
             0 D `     0205        l       h  
                                   _0_358002AE_KLIST_PSX_VAX              V1.0           ޕl 05-13                                             
       ?   $ 
     !         DCE$LIB_SHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001!      !         DECC$SHR_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001#      +        POSIXC$SHR_001  p
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
         ^  ݬݬ"  Pw  PխPPh  խЭP   P    P        Տ      u      Տ      y  <PP  JP#`P  9P`P~  P`Pq  PPS  PPy  PP;  PPM  P``P4  P``P  PP	  PP   mPP    @\cЬWޯAHC=PQl`/&!мPQl` @\            @   @                                                              P   H   @   8         L                   @   <   ,   (   $   D   H             0          
   
                 @                                                                       DCE$LIB_SHR                                                    CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Ov ~      	POSIX.SAV                      C.7  R\  [POSIX.SRC]KLIST.;1                                                                                                                                          _                                         DECC$SHR                                                       DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        
POSIXC$SHR                                                                                             	VMS_KLIST 
  main O   		
         POSIXC$INIT p
  POSIXC$$INITIALIZE X
  POSIXC$$PRIVATE_ERRNO d
  POSIXC$$PRIVATE_VMSERR    LIB$INITIALIZE      ERRNO       ERRNO$     4  
VAXC$ERRNO     4  VAXC$ERRNO$       ENVIRON       STDIN    $  STDOUT      STDERR    ,  TZNAME       DAYLIGHT    (  TIMEZONE      OPTARG      OPTERR      OPTIND      OPTOPT      SIGNGAM       _IOTABLE    X
  $CODED                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        * [POSIX.SRC]NSEDIT.;1 +  , J.;   .     /  @   4        	                     - R\   0   1    2   3      K  P   W   O     5   6 Zs  7 d  8          9          G  @  H  J $ N                   ?                   0 D `     0205        r=         (                                          _0_2740A017_NSEDIT                     DCE T1.2-940319r 05-13                                             
       ?   '      !        DCE$NSEDIT_SHR_001&      !        DECW$XMLIBSHR_001$      +        CMA$TIS_SHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001.       !     
  DECW                                                                                                                                                                                                                                                   P                        ڨ $      DCEVAXMUPA013.A                1  4  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                         J      E       $TRANSPORT_COMMON_001' 7     +        dDECW$DWTLIBSHR_001%     !        dDECW$XLIBSHR_001!      !        DTSS$SHR_001)      !         CMA$OPEN_LIB_SHR_001$      !         CMA$LIB_SHR_001%      +        CMA$OPEN_RTL_001       +        
CMA$RTL_001!      !         DECC$SHR_001$ 
     !         DCE$LIB_SHR_001#      +        POSIXC$SHR_001  p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.  ^u  ݬݬ  Pݭ[  P    P    P        Տ      u      Տ      y  <PP  JP#`P  9P`P~  P`Pq  PPS  PPy  PP;  PPM  P``P4  P``P  PP	  PP  mPP   @\cЬWޯAHC=PQl`/&!мPQl` @\                                                                                                                                                                                                                                                                            @   @                                                                P   H   @   8         L                   @   <   ,   (   $   D   H           0             
                 @                                                                       DCE$NSEDIT_SHR                                                 
DECW$XMLIBSHR                                                  VAXCRTL                                                        CMA$TIS_SHR                                                    LIBRTL                                                         MTHRTL                                                         DECW$TRANSPORT_COMMON                                          DECW$DWTLIBSHR                                                 DECW$XLIBSHR                                                   DTSS$SHR                                                       CMA$OPEN_LIB_SHR                                               CMA$LIB_SHR                                                    CMA$OPEN_RTL                                                   CMA$RTL                                                        DECC$SHR                                                       DCE$LIB_SHR                                                    
POSIXC$SHR                                                                                                                                                                                                                             e                                                                                                                                                                                                                                                                                                                                                                                                                                                                    M                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Q                        i $      DCEVAXMUPA013.A                1  4  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                         g "     V                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          R                        G$ $      DCEVAXMUPA013.A                1  4  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                         9 "     g                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          S                        zcK $      DCEVAXMUPA013.A                1  4  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                         ^      x                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     * [SYSHLP.EXAMPLES.DCE]RPC.DIR;1 +  , 3   .     /  @   4                            - ;    0   1    2   3     K  P   W   O     5   6    7 {L   8          9          G  @  H   J  I                             BOOK.DIR 4     MATRIX1.DIR  6     MATRIX2.DIR  }2     PAYROLL.DIR  1     
PHONEBOOK.DIR  3     	TEST1.DIR  3     	TEST2.DIR  7                                                                                                                                                                                                                                                                                                                                                              # * [SYSHLP.EXAMPLES.DCE.RPC]BOOK.DIR;1 +  , 4   .     /  @   4                            - 3    0   1    2   3     K  P   W   O     5   6 0   7 ,   8          9          G  @  H   J  I                        BOOK.SAV 6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ( * [SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3 +  , 6   . <   /  @   4   ~  <  <     ~               - 4    0   1    2   3      K  P   W   O =   5   6   7 ]   8          9          G  @  H   J                                                   ]	; ~      BOOK.SAV                                                                                                                                                                                                     S                BOOK.SAV3  BACKUP SRC$:*.* OBJ$:BOOK.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   ,      V5.5	 	 _OPNSME:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                       * [RPCBOOK.SRC]BOOK.ACF;1 +  , _;   .     /  @   4 L                         - ^=    0   1    2   3      K  P   W   O     5   6 L9c  7 {THM9c  8          9          G  @  H  J $ N                   ?               /* 
**			COPYRIGHT (C) 1993 BY
**                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
**                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
**
** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
** ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
** OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
** THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
** PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
**
** THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
** SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
**
** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
** SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
**
**
**  NAME
**
**      book.acf
**
**  FACILITY:
**
**      RPC example program - BOOK calendar.
**
**  ABSTRACT:
**
**  Attribute Configuration File for the remote interface to the
**  BOOK server.
**
*/

interface book
{

/*
 * simply declare a comm_status argument for each routine
 * in the server interface
 */
 
book_fill_week
(
    [comm_status]       rpc_comm_status
);

book_get_booking
(
    [comm_status]       rpc_comm_status
);

book_put_booking
(
    [comm_status]       rpc_comm_status
);

book_remove_booking
(
    [comm_status]       rpc_comm_status
);

book_update_file
(
    [comm_status]       rpc_comm_status
);

}
                                                                                                           * [RPCBOOK.SRC]BOOK.C;1 +  , `8   . d    /  @   4 n   d   b                    - ^=    0   1    2   3      K  P   W   O e    5   6  xA  7 @W:$  8          9          G  @  H  J $ N                   ?     r             /*   **			COPYRIGHT (C) 1993 BY9 **                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 **                  MASSACHUSETTS.  ALL RIGHTS RESERVED. **H ** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK ** ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D ** OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG ** THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L ** PERSON.                                                                                                                                                                                                                                                                                                                                                                                                                  T                        YB $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        K "              NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. **K ** THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L ** SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. **F ** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 ** SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  ** ** **  NAME ** **      book.c **
 **  FACILITY:  **+ **      RPC example program - BOOK calendar  **
 **  ABSTRACT:  **A **  This is the client program that presents the interactive user ! **  interface to the BOOK server.  ** **  %a%private_begin ** **  MODIFICATION HISTORY:  **< **  28-jun-93 sinkewicz added changes for ansi-c compliance ; **  11-may-92 hsiao     pass an argument to exit() function 8 **  02-Mar-92 harrow    modify to use idl-supplied types? **  11-feb-92 sudama    change to use cuserid() for portability < **  20-nov-91 sudama    convert to use book_status argument;0 **                      fix bug in show_calendar< **  03-oct-91 sudama    add interface spec to import_begin()J **  21-aug-91 sudama    add server binding import; add comments and formatE **                      add rpc comm status check to all remote calls ) **  16-apr-91 sudama    original creation  ** **  %a%private_end   ** */ #include <stdio.h> #include <stdlib.h>  #include <time.h>  #include <dce/dce_error.h> #include "book.h"  #if defined(VMS) #include <unixio.h>  #endif  & #define book_c_date_string_max      26% #define book_c_time_string_max      6   
 int strcmp(); 
 int strlen();  char *strcpy();   static int unpack_date_string();  static int unpack_system_date();   static this_week();  static main_loop();  static get_string(); int toupper(); static int show_agenda();  static int create_booking(); static int show_calendar();  static int delete_booking(); static int show_booking(); static int go_to_week(); static help(); static write_date(); static int modify_booking(); static int repeat_booking(); static int get_day();  static int get_time(); static int write_booking();  static write_time();   /*   * for terminal escape sequences  */ & #define ESC                         27  " #define REPORT_DCE_ERROR(status) \ { \ =     dce_error_inq_text (status, error_text, &error_status); \  \      if (error_status != -1) \      { \ =         printf (">>> rpc runtime error: %s\n", error_text); \      } \ 
     else \     { \ H         printf (">>> rpc runtime error: no error text translation\n"); \     } \  }   8 idl_char                book_name[book_c_book_name_max];. rpc_binding_handle_t    binding_handle = NULL;    book_booking_record_t   booking;  = idl_short_int week[book_c_days_in_week][book_c_times_in_day];  idl_short_int week_date; idl_short_int day; idl_short_int time_of_day;  1 idl_char      error_text[dce_c_error_string_len];  int           error_status;     char          *month_name[12] = ;                 { "JAN", "FEB", "MAR", "APR", "MAY", "JUN", =                   "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };   L /*************************************************************************** **? **  The client intialization routine to be executed on startup.  **L ***************************************************************************/   main (argc, argv)    int         argc;  char        *argv[];   { #     rpc_ns_handle_t import_context; %     unsigned_char_p_t string_binding;      unsigned32      status; ,     idl_ulong_int   book_status = book_s_ok;$     error_status_t  rpc_comm_status;            /*@      * if a user was specified in the command argument, use it -6      * otherwise, use the name for the current account      */      if (argc > 1)      { $         strcpy (book_name, argv[1]);     }      else     { +         strcpy (book_name, cuserid (NULL));      }        /*/      * set the current week to the current date       */      this_week();       /*B      * set up a search context in order to import a binding handle3      * for a book server from the directory service       */ !     rpc_ns_binding_import_begin (           rpc_c_ns_syntax_default,-         (unsigned_char_t *) ".:/book_server",          book_v1_0_c_ifspec, 
         NULL,          &import_context,         &status);               if (status != rpc_s_ok)      { "         REPORT_DCE_ERROR (status);         exit(EXIT_FAILURE);      }        /*<      * keep searching until a usable binding handle is found      */ "     while (binding_handle == NULL)     { 
         /*D          * import a single binding handle, then try it in a real RPC          */ N         rpc_ns_binding_import_next (import_context, &binding_handle, &status);           if (status != rpc_s_ok) 	         { &             REPORT_DCE_ERROR (status);             exit(EXIT_FAILURE); 	         }   
         /*G          * convert the binding information obtained to a string binding           */ %         rpc_binding_to_string_binding ;                 (binding_handle, &string_binding, &status);            if (status != rpc_s_ok) 	         { &             REPORT_DCE_ERROR (status);             exit(EXIT_FAILURE); 	         }   
         /*B          * only use this binding if it's for the datagram protocol          */    	/* + 	 * To filter uncomment the following line: > 	 *  if ((strncmp ((char *) string_binding, "ncadg", 5)) == 0) 	 */' 	if (1)  /* In place of above filter */ 	         {              /*5              * update the booking file, counting back ,              * the specified number of weeks              */              book_update_file (                 binding_handle,                  book_name,=                 week_date - (book_c_retirement_interval * 7),                  &book_status, "                 &rpc_comm_status);  )             if (book_status != book_s_ok) 
             { B                 printf ("book: unable to access %s\n", book_name);#                 exit(EXIT_FAILURE); 
             }                /*H              * if the call doesn't get through, clear the binding handle7              * and try to import another server binding               */ ,             if (rpc_comm_status != rpc_s_ok)
             { 3                 REPORT_DCE_ERROR (rpc_comm_status);   <                 rpc_binding_free (&binding_handle, &status);
             } 	         }          else	         {              /*;              * if this binding handle isn't useful, free it               */ 8             rpc_binding_free (&binding_handle, &status);	         }   
         /**          * free the string binding as well          */ 3         rpc_string_free (&string_binding, &status); 	     }            /*      * free the search context      */ :     rpc_ns_binding_import_done (&import_context, &status);          if (status != rpc_s_ok)      { "         REPORT_DCE_ERROR (status);         exit(EXIT_FAILURE);      }        /*=      * enter the main loop to respond to interactive commands       */      printf ("\n");       main_loop(); }   L /*************************************************************************** **2 ** The main loop for accepting user command input. **L ***************************************************************************/   main_loop()  {      char        command[2];        for (;;)     {          printf ("BOOK> ");  
         /*B          * wait for command input, then upcase the first character          */          get_string (command);   *         command[0] = toupper (command[0]);           switch (command[0]) 	         {              case 'A': /                 if (show_agenda() == idl_false)                  { @                     printf ("Unable to access %s\n", book_name);                 }                  break;               case 'B': 2                 if (create_booking() == idl_false)                 { @                     printf ("Unable to access %s\n", book_name);                 }                  break;  -             case 'C': show_calendar(); break;                case 'D': 2                 if (delete_booking() == idl_false)                 { @                     printf ("Unable to access %s\n", book_name);                 }                  break;  )             case 'E': exit(EXIT_SUCCESS);                case 'F': 0                 if (show_booking() == idl_false)                 { @                     printf ("Unable to access %s\n", book_name);                 }                  break;               case 'G': .                 if (go_to_week() == idl_false)                 { @                     printf ("Unable to access %s\n", boo                                                                                                                                                                                                                                                   U                        =2i $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        D "            k_name);                 }                  break;  $             case 'H': help(); break;               case 'L':                  week_date -= 7; 2                 printf ("Current week starting ");6                 write_date (week_date); printf ("\n");                 break;               case 'M': 2                 if (modify_booking() == idl_false)                 { @                     printf ("Unable to access %s\n", book_name);                 }                  break;               case 'N':                  week_date += 7; 2                 printf ("Current week starting ");6                 write_date (week_date); printf ("\n");                 break;  )             case 'Q': exit(EXIT_SUCCESS);                           case 'R': 2                 if (repeat_booking() == idl_false)                 { @                     printf ("Unable to access %s\n", book_name);                 }                  break;               case 'T':                  this_week();2                 printf ("Current week starting ");6                 write_date (week_date); printf ("\n");                 break;  5             default: printf ("Not a BOOK command\n");U	         }      }R }R .L /*************************************************************************** **D **  Get the next input string.  This is a thread-synchronous versionD **  of what gets() does. It has to be used because gets() may not beF **  thread-safe (in some threads implementations). If gets() is calledD **  it will block the whole process, which will prevent the protocol@ **  timer threads in the RPC runtime from executing as required. ** **  Inputs:T **      none ** **  Outputs:1 **	string = pointer to string buffer to be filledR ** **  Returns:3 **      idl_true for success, idl_false for failureL **L ***************************************************************************/   get_string (string)k   char        *string;   {*#     char        char_buf, *str_ptr;n     int         status;          /*2      * make sure we're starting with a clean slate      */*     fflush (stdout);     fflush (stderr);       /*J      * use read() to do input, which is thread-safe in this implementation      */n     for (str_ptr = string;<         ((status = read (fileno (stdin), &char_buf, 1))) > 0"             && (char_buf != '\n'); 	*str_ptr++ = char_buf);       /*+      * see if anything was actually read in       */ )     if (status <= 0 && str_ptr == string)n     {  	return (idl_false);     }n       /*&      * null-terminate the input string      */t     *str_ptr++ = '\0';       return (idl_true); }b iL /*************************************************************************** **0 **  Create a new booking in the server database. ** **  Returns:3 **      idl_true for success, idl_false for failure> **L ***************************************************************************/  k create_booking() {)     idl_short_int   begins;f     idl_short_int   ends;t     idl_short_int   previous;c     char            reply[2];       idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;         /*F      * fill in the current week of time slots from the server database      */c     book_fill_week (         binding_handle,_         book_name,         week_date,
         week,o         &book_status,i         &rpc_comm_status);  !     if (book_status != book_s_ok)o     {;         return (idl_false);e     };  $     if (rpc_comm_status != rpc_s_ok)     {a+         REPORT_DCE_ERROR (rpc_comm_status);i         return (idl_false);i     }i       /*)      * collect details of the new bookings      */e     printf ("Day of week: ");         if ((day = get_day()) == -1)     {R         return (idl_true);     }n       printf ("Time begins: ");r  $     if ((begins = get_time()) == -1)     {          return (idl_true);     }c       printf ("Time finish: ");)  "     if ((ends = get_time()) == -1)     {          return (idl_true);     }e       ends--;l       if (ends <= begins)      {h8         printf ("How could it end before it starts?\n");         return (idl_true);     }N       reply[0] = 'y';c     previous = idl_false;r       /*E      * check to see if the new booking conflicts with an existing one       */_K     for (time_of_day = begins / 30; time_of_day < ends / 30; time_of_day++)s     {e#         if (week[day][time_of_day]) 	         {               previous = idl_true;             break;	         }"     },       if (previous)      {J
         /*I          * if there is a conflict, see what the user wants to do about it*          */*         if (!write_booking()) 	         {i             return (idl_false);e	         }p  >         printf ("\nDo you wish to cancel this meeting [n]? ");         get_string (reply);r  3         if ((reply[0] == 'y') || (reply[0] == 'Y')) 	         {p             /*C              * if this is an overwrite, remove the previous booking2'              * from the server databases              */;!             book_remove_booking (u                 binding_handle,s                 book_name,                  week_date + day,!                 time_of_day * 30,t                 &book_status,c"                 &rpc_comm_status);  )             if (book_status != book_s_ok) 
             {o/                 printf ("Meeting cancelled\n"); 
             }e             else
             { 2                 printf ("Error in book access\n");#                 return (idl_false);d
             }   ,             if (rpc_comm_status != rpc_s_ok)
             { 3                 REPORT_DCE_ERROR (rpc_comm_status);a#                 return (idl_false);*
             }e	         }      }v  /     if ((reply[0] == 'y') || (reply[0] == 'Y'))t     { 
         /*+          * get the rest of the booking info           */ <         printf ("Meeting who: "); get_string (booking.name);@         printf ("Meets where: "); get_string (booking.location);7         printf ("Notes: "); get_string (booking.notes); '         booking.date = week_date + day;i$         booking.time_start = begins;          booking.time_end = ends;  
         /*7          * write the new booking to the server database           */t         book_put_booking (             binding_handle,              book_name,               &booking,              &book_status,              &rpc_comm_status);  %         if (book_status != book_s_ok) 	         { .             printf ("Error in book access\n");             return (idl_false);n	         }u  (         if (rpc_comm_status != rpc_s_ok)	         { /             REPORT_DCE_ERROR (rpc_comm_status);              return (idl_false); 	         }*     }        return (idl_true); }  sL /*************************************************************************** **. **  Remove a booking from the server database. ** **  Returns:3 **      idl_true for success, idl_false for failurer **L ***************************************************************************/  c delete_booking() {e     char            reply[2];       idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;         /*F      * fill in the current week of time slots from the server database      */      book_fill_week (         binding_handle,          book_name, s         week_date, (         week,          &book_status,          &rpc_comm_status);  !     if (book_status != book_s_ok)a     {          return (idl_false);R     }   $     if (rpc_comm_status != rpc_s_ok)     {i+         REPORT_DCE_ERROR (rpc_comm_status);d         return (idl_false);d     }        printf ("Day of week: ");         if ((day = get_day()) == -1)     {a         return (idl_true);     }        printf ("Time of day: ");p  )     if ((time_of_day = get_time()) == -1)n     {(         return (idl_true);     }        time_of_day /= 30;  +     if (time_of_day == book_c_times_in_day)      {h         time_of_day = 17;f     }e        if (!week[day][time_of_day])     {d:         printf ("No meeting is scheduled at this time\n");     }      else     {t         if (!write_booking())*	         {              return (idl_false); 	         }          else	         {              reply[0] = 'y'; B             printf ("\nDo you wish to cancel this meeting [n]? ");             get_string (reply);   7             if ((reply[0] == 'y') || (reply[0] == 'Y'))E
             { %                 book_remove_booking ( $                     binding_handle,                      book_name,%                     week_date + day, *&                     time_of_day * 30, !                                                                                                                                                                                                                                                                        V                         $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        r "     )       &book_status,T&                     &rpc_comm_status);  -                 if (book_status == book_s_ok)*                 {*3                     printf ("Meeting cancelled\n");                  }                  else                 {>6                     printf ("Error in book access\n");'                     return (idl_false);*                 }i  0                 if (rpc_comm_status != rpc_s_ok)                 { 7                     REPORT_DCE_ERROR (rpc_comm_status); '                     return (idl_false);f                 } 
             } 	         }      }(       return (idl_true); }_ eL /*************************************************************************** **A **  Update a booking in the server database with new information.  ** **  Returns:3 **      idl_true for success, idl_false for failure  **L ***************************************************************************/   modify_booking() {'     char            line[255];      idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;         /*F      * fill in the current week of time slots from the server database      */      book_fill_week (         binding_handle,          book_name,           week_date, g         week,          &book_status,          &rpc_comm_status);  !     if (book_status != book_s_ok)      {          return (idl_false);a     }   $     if (rpc_comm_status != rpc_s_ok)     {_+         REPORT_DCE_ERROR (rpc_comm_status);          return (idl_false);l     }c       printf ("Day of week: ");         if ((day = get_day()) == -1)     {          return (idl_true);     }        printf ("Time of day: ");   )     if ((time_of_day = get_time()) == -1)C     {w         return (idl_true);     }r       time_of_day /= 30;  +     if (time_of_day == book_c_times_in_day)      {'         time_of_day = 17;o     }o        if (!week[day][time_of_day])     { :         printf ("No meeting is scheduled at this time\n");     }      else     {          if (!write_booking()) 	         {'             return (idl_false);7	         }            book_remove_booking (r             binding_handle,              book_name,             week_date + day, a             time_of_day * 30,              &book_status,              &rpc_comm_status);  %         if (book_status != book_s_ok)a	         { .             printf ("Error in book access\n");             return (idl_false); 	         }   (         if (rpc_comm_status != rpc_s_ok)	         { /             REPORT_DCE_ERROR (rpc_comm_status);n             return (idl_false); 	         }   6         printf ("\nMeeting who: "); get_string (line);           if (strlen (line))	         {o(             strcpy (booking.name, line);	         }*  4         printf ("Meets where: "); get_string (line);           if (strlen (line))	         {i,             strcpy (booking.location, line);	         }f  .         printf ("Notes: "); get_string (line);           if (strlen (line))	         {r)             strcpy (booking.notes, line); 	         }            book_put_booking (             binding_handle,              book_name, C             &booking,              &book_status,s             &rpc_comm_status);  %         if (book_status != book_s_ok)t	         {R.             printf ("Error in book access\n");             return (idl_false);*	         }*  (         if (rpc_comm_status != rpc_s_ok)	         {*/             REPORT_DCE_ERROR (rpc_comm_status);n             return (idl_false);f	         }n     }n       return (idl_true); }*  L /*************************************************************************** **B **  Repeat an existing booking in the server database for n weeks. ** **  Returns:3 **      idl_true for success, idl_false for failurer **L ***************************************************************************/   repeat_booking() {*     char            line[32];*     int             n;      idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;            /*F      * fill in the current week of time slots from the server database      */      book_fill_week (         binding_handle,          book_name, *         week_date, *         week,          &book_status,*         &rpc_comm_status);  !     if (book_status != book_s_ok)*     {e         return (idl_false);s     }   $     if (rpc_comm_status != rpc_s_ok)     {*+         REPORT_DCE_ERROR (rpc_comm_status);*         return (idl_false);g     }        printf ("Day of week: ");         if ((day = get_day()) == -1)     {          return (idl_true);     }l       printf ("Time of day: ");s  )     if ((time_of_day = get_time()) == -1)      {          return (idl_true);     }        time_of_day /= 30;  +     if (time_of_day == book_c_times_in_day)      {i         time_of_day = 17;k     }         if (!week[day][time_of_day])     { :         printf ("No meeting is scheduled at this time\n");     }=     else     {          if (!write_booking())e	         {              return (idl_false);o	         }          else	         {(G             printf ("\nHow many weeks would you like to repeat [0]? ");*             get_string (line);$             sscanf (line, "%d", &n);                for (; n >= 1; n--) 
             { "                 booking.date += 7;                   /*;                  * append the new record at the end of file                   */e"                 book_put_booking ($                     binding_handle,                      book_name, (                     &booking, !                     &book_status, &                     &rpc_comm_status);  -                 if (book_status != book_s_ok)                  {[6                     printf ("Error in book access\n");'                     return (idl_false);s                 }n  0                 if (rpc_comm_status != rpc_s_ok)                 {37                     REPORT_DCE_ERROR (rpc_comm_status);_'                     return (idl_false);=                 } 
             } 	         }      }        return (idl_true); }   L /*************************************************************************** **1 **  Display the full agenda for the current week.  ** **  Returns:3 **      idl_true for success, idl_false for failureD **L ***************************************************************************/  f
 show_agenda()' {       int             slot_filled;     char            ch;       idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;         /*F      * fill in the current week of time slots from the server database      */      book_fill_week (         binding_handle,          book_name,           week_date,           week,          &book_status,          &rpc_comm_status);  !     if (book_status != book_s_ok)      {          return (idl_false);      }   $     if (rpc_comm_status != rpc_s_ok)     {e+         REPORT_DCE_ERROR (rpc_comm_status);          return (idl_false);      }f       /*/      * paint the screen with the resulting dataa      */ &     printf ("%c[1;1H%c[2J", ESC, ESC);:     printf ("Agenda of %s for week starting ", book_name);     write_date (week_date);a:     printf ("\n----------------------------------------");:     printf ("----------------------------------------\n");F     printf ("Time|    %c[1mMonday%c[m    |   %c[1mTuesday%c[m    |  ",         ESC, ESC, ESC, ESC);A     printf ("%c[1mWednesday%c[m   |   %c[1mThursday%c[m   |    ",e         ESC, ESC, ESC, ESC);0     printf ("%c[1mFriday%c[m    |\n", ESC, ESC);8     printf ("----------------------------------------");:     printf ("----------------------------------------\n");       /*L      * check each time slot in the week to see if there is an active booking      */ K     for (time_of_day = 0; time_of_day < book_c_times_in_day; time_of_day++)      {m!         if (time_of_day % 2 == 0) 	         {_             ch = '|';r!             if (time_of_day < 10)k
             {_N                 printf (" %c[1m%2d%c[m |", ESC, ((time_of_day / 2) + 8), ESC);
             }s             else
             {pN                 printf (" %c[1m%2d%c[m |", ESC, ((time_of_day / 2) - 4), ESC);
             } 	         }n         else	         {*             ch = '+';(             printf ("    +");*	         }*  P         for (slot_filled = idl_false, day = 0; day < book_c_days_in_week; day++)	         {d'             if (week[day][time_of_day])r
             { '                 slot_filled = idl_true;*
             }*	         }*           if (slot_filled)	         { ;             for (day = 0; day < book_c_days_in_week; day++)_
             {k,                                                                                                                                                                                                                                                    W                        d $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        7 "     :                       if (!week[day][time_of_day])                 {*4                     printf ("              %c", ch);                 }                  else                 {a                     /*G                      * for each time slot that shows a booking, get the F                      * details of the booking from the server database                      */ &                     book_get_booking ((                         binding_handle, "                         book_name,)                         week_date + day,  *                         time_of_day * 30, !                         &booking,e%                         &book_status, *                         &rpc_comm_status);  1                     if (book_status != book_s_ok)                      { :                         printf ("Error in book access\n");+                         return (idl_false);e                     }   4                     if (rpc_comm_status != rpc_s_ok)                     {l;                         REPORT_DCE_ERROR (rpc_comm_status); +                         return (idl_false);                      }   A                     if (time_of_day == (booking.time_start / 30))l                     { :                         printf (" %c[1;7m%-12.12s%c[m %c",8                             ESC, booking.name, ESC, ch);                     }k                     else                     { I                         if (time_of_day == (booking.time_start / 30) + 1)                          {0>                             printf (" %c[1m> %-10.10s%c[m %c",@                                 ESC, booking.location, ESC, ch);                         }                          else                         { A                             printf (" %c[1m     \"      %c[m %c", .                                 ESC, ESC, ch);                         })                     }                  }f
             }u               printf ("\n");	         }          else	         {EG             printf ("              %c              %c              %c",                  ch, ch, ch);B             printf ("              %c              %c\n", ch, ch);	         }*     }*  8     printf ("----------------------------------------");:     printf ("----------------------------------------\n");       return (idl_true); }e rL /*************************************************************************** **, **  Show the details of a specified booking. ** **  Returns:3 **      idl_true for success, idl_false for failurea **L ********************************************************                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          nZ` ~      BOOK.SAV                       `8  ^=  [RPCBOOK.SRC]BOOK.C;1                                                                                                          n     d                          R     :       *******************/  e show_booking() {m      idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;            /*F      * fill in the current week of time slots from the server database      */      book_fill_week (         binding_handle,          book_name,           week_date, s         week,          &book_status,          &rpc_comm_status);  !     if (book_status != book_s_ok)      {          return (idl_false);c     }   $     if (rpc_comm_status != rpc_s_ok)     {t+         REPORT_DCE_ERROR (rpc_comm_status);r         return (idl_false);T     }d       printf ("Day of week: ");=        if ((day = get_day()) == -1)     {n         return (idl_true);     }_       printf ("Time of day: ");   )     if ((time_of_day = get_time()) == -1)e     {          return (idl_true);     }]       time_of_day /= 30;  +     if (time_of_day == book_c_times_in_day)t     {;         time_of_day = 17;      }         if (!week[day][time_of_day])     { :         printf ("No meeting is scheduled at this time\n");     }      else     {i         if (!write_booking())k	         {              return (idl_false); 	         }o         else	         { ?             printf ("\nLocation: %.70s\n\n", booking.location);k.             printf ("%.70s\n", booking.notes);	         }r     }o       return (idl_true); }e nL /*************************************************************************** **< **  Display information on a booking in the server database. ** **  Returns:3 **      idl_true for success, idl_false for failure) **L ***************************************************************************/  o write_booking(); {       idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;            /*9      * lookup the specified record in the server databasei      */      book_get_booking (         binding_handle,          book_name,         week_date + day, r         time_of_day * 30,          &booking,          &book_status,k         &rpc_comm_status);  !     if (book_status != book_s_ok)m     { *         printf ("Error in book access\n");         return (idl_false);t     }   $     if (rpc_comm_status != rpc_s_ok)     { +         REPORT_DCE_ERROR (rpc_comm_status);s         return (idl_false);d     })       /*&      * display the booking information      */ N     printf ("\nYou have a previously scheduled meeting with %c[1m%.12s%c[m\n",          ESC, booking.name, ESC);     printf ("on %c[1m", ESC);        switch (day)     {*)         case 0: printf ("Monday"); break;**         case 1: printf ("Tuesday"); break;,         case 2: printf ("Wednesday"); break;+         case 3: printf ("Thursday"); break;a)         case 4: printf ("Friday"); break;*     }*  )     printf ("%c[m from %c[1m", ESC, ESC);/$     write_time (booking.time_start);'     printf ("%c[m to %c[1m", ESC, ESC);;"     write_time (booking.time_end);     printf ("%c[m\n", ESC);s       return (idl_true); }* lL /***************************************************************************L ****************************************************************************L **************************************************************************** **H **  The rest of the code consists of local operations which have nothingC **  specific to do with to do with distribution of the application.E **L ****************************************************************************L ****************************************************************************L ***************************************************************************/ tL /*************************************************************************** **1 **  Convert day, month and year to a julian date.  ** **  Returns: **      julian date  **L ***************************************************************************/  d% int date_to_julian (day, month, year)e   int         day; int         month; int         year;    {      int         date;     
     date = 0;l  )     for (year -= 61; year > 3; year -= 4)n     {          date += 1461;t     })       date += year * 365;(  #     if ((year == 3) && (month > 2))      {          day++;     }>       switch (month)     { "         case 2 : day += 31; break;"         case 3 : day += 59; break;"         case 4 : day += 90; break;#         case 5 : day += 120; break; #         case 6 : day += 151; break; #         case 7 : day += 181; break; #         case 8 : day += 212; break; #         case 9 : day += 243; break; #         case 10: day += 273; break; #         case 11: day += 304; break; #         case 12: day += 334; break;      }        date += day;     return (date); }  kL /*************************************************************************** **2 **  Convert ASCII day format input to a day value. ** **  Returns: **      day valueO **L ***************************************************************************/  	 get_day()  {      char        week_day[2];     int         day = -1;      int         i;         get_string (week_day);       for (i = 0; i < 2; i++)*     {*,         week_day[i] = toupper (week_day[i]);     }        switch (week_day[0])     {s!         case 'M': day = 0; break;          case 'T':*                switch (week_day[1])
             {*)                 case 'U': da                                                                                                                                                                                                                                                   X                        $n. $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        ޷ "     K       y = 1; break; )                 case 'H': day = 3; break; 
             }_             break;  !         case 'W': day = 2; break; !         case 'F': day = 4; break;e     }        if (day == -1)     { %         printf ("Not a valid day\n");(     }        return (day);  }  oL /*************************************************************************** **4 **  Convert ASCII time format input to a time value. ** **  Returns: **      time value **L ***************************************************************************/  (
 get_time() {)     int         time, t1, t2; 4     char        time_string[book_c_time_string_max];         t1 = t2 = 0;     get_string (time_string); 0     sscanf (time_string, "%d %*c %d", &t1, &t2);       if (t1 < 8);     {r         t1 += 12;)     }         time = ((t1 - 8) * 60) + t2;  #     if ((time < 0) || (time > 540))-     {-;         printf ("Time is not in the range 8:00 to 5:00\n");n         time = -1;     }%       return (time); }, CL /*************************************************************************** **; **  Set the current date to a date that is fully specified.  ** **  Returns:3 **      idl_true for success, idl_false for failure" **L ***************************************************************************/   go_to_week() { +     int         new_date, day, month, year;i.     char        ndate[book_c_date_string_max];    0     printf ("Go to date: "); get_string (ndate);  8     if (unpack_date_string (ndate, &day, &month, &year))     {r5         new_date = date_to_julian (day, month, year);            if ((new_date % 7) < 2)m	         {(:             printf ("Sorry, we never work on weekends\n");	         }          else	         {r8             week_date = (new_date - (new_date % 7)) + 2;.             printf ("Current week starting ");#             write_date (week_date);              printf ("\n");	         }      }      else     {d/         printf ("Improperly formatted date\n");      }        return (idl_true); }e dL /*************************************************************************** **7 **  Display a help message showing the command options.  **L ***************************************************************************/   help() {      char        reply[2];d    #     printf ("%c[2J%c[H", ESC, ESC);   4     printf ("\n\nBOOK %c[1mHELP%c[m\n\n", ESC, ESC);  5     printf ("        %c[1mAgenda%c[m    ", ESC, ESC); <     printf ("-  Display the agenda for the current week\n");  5     printf ("        %c[1mBook%c[m      ", ESC, ESC);h?     printf ("-  Schedule a new meeting in the current week\n");   5     printf ("        %c[1mCalendar%c[m  ", ESC, ESC); 7     printf ("-  Display the current calendar range\n");   5     printf ("        %c[1mDelete%c[m    ", ESC, ESC); A     printf ("-  Remove an existing meeting from the schedule\n");   5     printf ("        %c[1mExit%c[m      ", ESC, ESC); 2     printf ("-  Terminate calendar processing\n");  5     printf ("        %c[1mFocus%c[m     ", ESC, ESC); <     printf ("-  Show the details of a specified meeting\n");  5     printf ("        %c[1mGoto%c[m      ", ESC, ESC); 7     printf ("-  Set the agenda to a different week\n");   5     printf ("        %c[1mHelp%c[m      ", ESC, ESC);E.     printf ("-  Display this help message\n");  5     printf ("        %c[1mLast%c[m      ", ESC, ESC); 8     printf ("-  Set the agenda to the previous week\n");  5     printf ("        %c[1mModify%c[m    ", ESC, ESC);(>     printf ("-  Modify the details of a specified meeting\n");  5     printf ("        %c[1mNext%c[m      ", ESC, ESC); 4     printf ("-  Set the agenda to the next week\n");  5     printf ("        %c[1mQuit%c[m      ", ESC, ESC); 2     printf ("-  Terminate calendar processing\n");  5     printf ("        %c[1mRepeat%c[m    ", ESC, ESC); 1     printf ("-  Extend a meeting for n weeks\n");   5     printf ("        %c[1mThis%c[m      ", ESC, ESC); 7     printf ("-  Set the agenda to the current week\n");n       printf ("\n\n");  H     printf ("Do you need the command format [n]? "); get_string (reply);  /     if ((reply[0] == 'y') || (reply[0] == 'Y'))      { '         printf ("%c[2J%c[H", ESC, ESC); D         printf ("\n\nBOOK commands have the following format:\n\n");S         printf ("     o  Top level commands may be entered as a single letter,\n");r         printf ("        ");O         printf ("upper or lower case. For example:  %c[1ma%c[m  =  Agenda\n\n",-             ESC, ESC);         printf ("     o  ");P         printf ("Days may be entered as a single letter, with the exception\n");U         printf ("        of Tuesday and Thursday, which require two letters. For\n"); &         printf ("        example:  ");F         printf ("%c[1mm%c[m  =  Monday,  %c[1mtu%c[m  =  Tuesday\n\n",              ESC, ESC, ESC, ESC);S         printf ("     o  Times are entered as a string, in the format hh : mm.\n"); Q         printf ("        Any non-digit character can be used as a separator,\n");eT         printf ("        and the minutes if (omitted default to 0. For example:\n");n         printf ("        %c[1m8:00%c[m = Eight AM, %c[1m3%c[m = Three PM, %c[1m4 50%c[m = Four-fifty PM.\n\n",*             ESC, ESC, ESC, ESC, ESC, ESC);T         printf ("     o  Dates are entered as strings, in the format dd-mmm-yy.\n");O         printf ("        For example:  %c[1m3-Jun-82%c[m  =  June 3, 1982\n\n",_             ESC, ESC);         printf ("     o  ");P         printf ("Account names are entered as a string. Sub-directories are\n");         printf ("        ");P         printf ("allowed. For example:  %c[1mDoe.Dates%c[m  =  [DOE.DATES]\n\n",             ESC, ESC);     }; }   L /*************************************************************************** **1 **  Convert a julian date to day, month and year.  **L ***************************************************************************/   ' julian_to_date (date, day, month, year)    int         date;_ int         *day;o int         *month;  int         *year;   {(E     *year = (((date / 1461) * 4) + ((date % 1461) / 365) + 61) % 100;s     date = (date % 1461) % 365;      *month = 1;u       if (date > 31)     {*         (*month)++;*         date -= 31;*     }*  %     if ((*month > 1) && (date > 28)) m     {n$         if (((*year - 64) % 4) != 0)	         {n             (*month)++;s             date -= 28;l	         }*         else	         {*             if (date > 29)
             {*                 (*month)++;                  date -= 29;a
             }_	         }p     }s  @     if ((*month > 2) && (date > 31)) { (*month)++; date -= 31; }@     if ((*month > 3) && (date > 30)) { (*month)++; date -= 30; }@     if ((*month > 4) && (date > 31)) { (*month)++; date -= 31; }@     if ((*month > 5) && (date > 30)) { (*month)++; date -= 30; }@     if ((*month > 6) && (date > 31)) { (*month)++; date -= 31; }@     if ((*month > 7) && (date > 31)) { (*month)++; date -= 31; }@     if ((*month > 8) && (date > 30)) { (*month)++; date -= 30; }@     if ((*month > 9) && (date > 31)) { (*month)++; date -= 31; }A     if ((*month > 10) && (date > 30)) { (*month)++; date -= 30; }i       *day = date; }f \L /*************************************************************************** **? **  Paint the screen with a calendar based on the current date.a **L ***************************************************************************/   show_calendar()  { 
     struct     {W         int         year;          int         number;b         int         length;f         int         first_day;     } months[4];  &     static short    month_length[12] =K                         { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };e       int         d, w, m, x, y;     int         count[4];u!     int         day, month, year;*$     int         sday, smonth, syear;     int         month_date;*         /*      * get the system date      */*0     unpack_system_date (&sday, &smonth, &syear);              /*G      * fill in the data for the four month window - starting last month       */o4     julian_to_date (week_date, &day, &month, &year);     month--;       /*      * adjust for december      */*     if (month == 0)*     {*         month = 12;*         year--;*     }*  $     for (m = 0; m < 4; m++, month++)     {*
         /*5          * do next month, adjusting for year-end wrap*          */*         if (month > 12)*	         {*             month %= 12;             year++;*	         }*           months[m].year = year;!         months[m].number = month;:3         months[m].length = month_length[month - 1];*                                                                                                                                                                                                                                                     Y                         $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        C. "     \       
         /*;          * adjust length of february if this is a leap year(          */e,         if ((month == 2) && (year % 4 == 0))	         { "             months[m].length = 29;	         }a  
         /*:          * get the julian date for the first of this month          */ 5         month_date = date_to_julian (1, month, year);3  
         /*6          * mark the day of the week the first falls on          */ -         months[m].first_day = month_date % 7;3  %         if (months[m].first_day == 0)y	         {a$             months[m].first_day = 7;	         }      }:  &     printf ("%c[2;1H%c[2J", ESC, ESC);  '     for (y = 0; y < 4; count[y++] = 1);1  @     printf ("                     Calendar for week starting ");     write_date (week_date);a     printf ("\n");M     printf ("                     ------------------------------------\n\n");e       for (y = 0; y <= 2; y += 2)*     {*J         printf ("          S  %c[7m M   T   W   T   F %c[m  S", ESC, ESC);P         printf ("              S  %c[7m M   T   W   T   F %c[m  S\n", ESC, ESC);9         printf ("        +---+---+---+---+---+---+---+");*=         printf ("          +---+---+---+---+---+---+---+\n");            for (w = 0; w < 6; w++) 	         { #             for (x = 0; x < 2; x++)o
             {;                 if (w < 3)                 {wO                     printf ("    %c  ", month_name[months[x+y].number - 1][w]);                  }                  else                 {y'                     printf ("       ");e                 }k  (                 for (d = 1; d <= 7; d++)                 { J                     if (((count[x+y] == 1) && (d < months[x+y].first_day))=                         || (count[x+y] > months[x+y].length))                      {y(                         printf ("    ");                     }*                     else                     {*                         /*E                          * if this is the current date, highlight it,l?                          * otherwise just display it ordinarily*                          */i=                         if ((months[x+y].number == smonth) &&sP                             (count[x+y] == sday) && (months[x+y].year == syear))                         {,N                             printf ("  %c[1;5m%2d%c[m", ESC, count[x+y], ESC);                         }6                         else                         { 7                             printf ("%4d", count[x+y]);)                         }   %                         count[x+y]++;*                     }*                 }*                   if (x == 0)*                 {a$                     printf ("    ");                 }                  else                 {o"                     printf ("\n");                 }*
             }*	         }*  $         if (y == 0) printf ("\n\n");     }e     printf ("\n"); }r  L /*************************************************************************** **6 **  Set the current week according to the system time. **L ***************************************************************************/    this_week()f {n!     int         day, month, year;          /*:      * get the current system time (date) in unpacked form      */ -     unpack_system_date (&day, &month, &year);        /*-      * get julian date for first of this weekt      */;2     week_date = date_to_julian (day, month, year);2     week_date = (week_date - (week_date % 7)) + 2; }   L /*************************************************************************** **9 **  Extract the day, month and year from the system time.* **L ***************************************************************************/  % unpack_system_date (day, month, year)*   int         *day;* int         *month;  int         *year;   {      time_t	system_time;n      struct tm   *time_structure;         /*+      * get the current system time and date       */      time (&system_time);       /*/      * convert binary value to a time structurec      */e.     time_structure = localtime (&system_time);       /*B      * then extract the appropriate information from the structure      */ #     *day = time_structure->tm_mday; (     *month = time_structure->tm_mon + 1;$     *year = time_structure->tm_year; }n (L /*************************************************************************** **> **  Extract the day, month and year from an ASCII date string. ** **  Returns:3 **      idl_true for success, idl_false for failure" **L ***************************************************************************/  2 unpack_date_string (date_string, day, month, year)   char        date_string[]; int         *day;  int         *month;g int         *year;   {n      char        month_string[4];     int         i;    C     sscanf (date_string, "%d-%[^-]%*c%d", day, month_string, year);        for (i = 0; i < 4; i++)C     { 4         month_string[i] = toupper (month_string[i]);     }   6     if (strcmp (month_string, "JAN") == 0) *month = 1;;     else if (strcmp (month_string, "FEB") == 0) *month = 2; ;     else if (strcmp (month_string, "MAR") == 0) *month = 3; ;     else if (strcmp (month_string, "APR") == 0) *month = 4;f;     else if (strcmp (month_string, "MAY") == 0) *month = 5; ;     else if (strcmp (month_string, "JUN") == 0) *month = 6;[;     else if (strcmp (month_string, "JUL") == 0) *month = 7;i;     else if (strcmp (month_string, "AUG") == 0) *month = 8; ;     else if (strcmp (month_string, "SEP") == 0) *month = 9;n<     else if (strcmp (month_string, "OCT") == 0) *month = 10;<     else if (strcmp (month_string, "NOV") == 0) *month = 11;<     else if (strcmp (month_string, "DEC") == 0) *month = 12;     else return (idl_false);  "     if (*year > 99) *year -= 1900;       return (idl_true); };  L /*************************************************************************** **. **  Display a time value in ASCII time format. **L ***************************************************************************/  C write_time (time)(   int      time;   {r     int         minutes, hours;i         minutes = time % 60;     hours = (time / 60) + 8;       if (hours > 12)d     {c         hours -= 12;     })  '     printf ("%d:%02d", hours, minutes);  }   L /*************************************************************************** **6 **  Display a julian date in ASCII date string format. **L ***************************************************************************/  c write_date (date)d   int      date;   { !     int         day, month, year;n         /*5      * convert the julian date to day, month and year       */[/     julian_to_date (date, &day, &month, &year);1:     printf ("%d-%s-%02d", day, month_name[month-1], year); }CESC, ESC);T         printf ("     o  Dates are entered as strings, in the format dd-mmm-yy.\n");O         printf ("               * [RPCBOOK.SRC]BOOK.COM;1 +  , aC   .     /  @   4 L                          - ^=    0   1    2   3      K  P   W   O     5   6 >u  7 6S(u  8          9          G  @  H  J $ N                   ?                $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! $! Abstract:. $!	BOOK.COM -- Builds the book example program $! $! Modification History:1 $! 	31-Aug-1993 fwb Modified for OpenVMS DCE V1.1  $!  : $! Establish compiler-specific arguments to the CC command $ @DCE:DCE$CC_TEST $! Determine option files $ $ If( f$trnlnm("dce$cc") .eqs. " " )J $ Then  options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options"' $ Else  options = "dce:dce.opt/options"  $ Endif  $!- $! Enable the universal IDL command interface   $ idl := $sys$system:dce$idl.exe $ # $! Compile the interface definition A $! -keep all is used to keep the IDL output for training purposes 6 $                                                                                                                                                                                                                                                    Z                        6n $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                         "     m       idl book.idl -keep all -trace all -trace log_manager $! $ cc := cc'f$trnlnm("dce$cc")'' $! Compile the client application files  $ cc book.c  $  $! Link the client application  $ link book,book_cstub,'options'# $ write sys$output "BOOK.EXE done."  $ ' $! Compile the server application files  $ cc book_main.c,book_mgr.c  $  $! Link the server application8 $ link/exe=bookd book_main,book_mgr,book_sstub,'options'$ $ write sys$output "BOOKD.EXE done."                                                                                                                                * [RPCBOOK.SRC]BOOK.IDL;1 +  , b:   .     /  @   4 L                          - ^=    0   1    2   3      K  P   W   O 
    5   6 {'Y9c  7 Y9c  8          9          G  @  H  J $ N                   ?               /* 
**			COPYRIGHT (C) 1993 BY
**                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
**                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
**
** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
** ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
** OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
** THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
** PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
**
** THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
** SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
**
** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
** SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
**
**
**  NAME
**
**      book.idl
**
**  FACILITY:
**
**      RPC example program - BOOK calendar.
**
**  ABSTRACT:
**
**  Definitions of types/constants and procedures that make up the
**  remote interface to the BOOK server.
**
*/

[
uuid(0fe3973c-2fc5-11ca-bfb5-08002b1bb4f5),
version(1.0)
]

interface book
{

const long book_c_file_name_max     = 256;
const long book_c_book_name_max     = book_c_file_name_max - 5;

const long book_c_days_in_week      = 5;
const long book_c_times_in_day      = 18;

/*
 * how many weeks appointments are kept around
 */
const long book_c_retirement_interval = 8;

const long book_c_name_max          = 12;
const long book_c_location_max      = 70;
const long book_c_notes_max         = 70;

const long book_s_ok                = 0;
const long book_s_error             = 1;

typedef struct
{
    short       date;
    short       time_start;
    short       time_end;
    char        name[book_c_name_max];
    char        location[book_c_location_max];
    char        notes[book_c_notes_max];
} book_booking_record_t;

typedef [ptr] book_booking_record_t *book_booking_record_p_t;

/*
 * declare each routine in the server interface
 */
 
void book_fill_week
(
    [in]    handle_t        binding_handle,
    [in]    char            book_name[book_c_book_name_max],
    [in]    short           date,
    [out]   short           week[book_c_days_in_week][book_c_times_in_day],
    [out]   error_status_t  *book_status
);

void book_get_booking
(
    [in]    handle_t        binding_handle,
    [in]    char            book_name[book_c_book_name_max],
    [in]    short           date,
    [in]    short           time,
    [out]   book_booking_record_t *booking,
    [out]   error_status_t  *book_status
);

void book_put_booking
(
    [in]    handle_t        binding_handle,
    [in]    char            book_name[book_c_book_name_max],
    [in]    book_booking_record_p_t booking,
    [out]   error_status_t  *book_status
);

void book_remove_booking
(
    [in]    handle_t        binding_handle,
    [in]    char            book_name[book_c_book_name_max],
    [in]    short           date,
    [in]    short           time,
    [out]   error_status_t  *book_status
);

void book_update_file
(
    [in]    handle_t        binding_handle,
    [in]    char            book_name[book_c_book_name_max],
    [in]    short           date,
    [out]   error_status_t  *book_status
);

}
                                                                                                                                                                                                                                                                                                                                                                                   * [RPCBOOK.SRC]BOOK.OPT;1 +  , c8   .     /  @   4                            - ^=    0   1    2   3      K  P   W   O     5   6 ǋ.  7 *S  8          9          G  @  H  J $ N                   ?                sys$share:dce$lib_shr/share                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * [RPCBOOK.SRC]BOOK_MAIN.C;1 +  , d8   .     /  @   4 S      	                    - ^=    0   1    2   3      K  P   W   O 
    5   6 }A  7  ;$  8          9          G  @  H  J $ N                   ?                             /*   **			COPYRIGHT (C) 1993 BY9 **                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 **                  MASSACHUSETTS.  ALL RIGHTS RESERVED. **H ** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK ** ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D ** OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG ** THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L ** PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. **K ** THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L ** SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. **F ** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 ** SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  ** ** **  NAME ** **      book_main.c  **
 **  FACILITY:  **+ **      RPC example program - BOOK calendar  **
 **  ABSTRACT:  **F **  This is the server "main" program that executes on server startup.J **  It creates an environment for the server to run, then starts listening **  for client requests. ** */ #include <pthread.h> #include <stdio.h> #include <stdlib.h>  #include <dce/dce_error.h> #include "rpcserver.h" #include "book.h"   % #define     book_c_server_if_count  1   " #define REPORT_DCE_ERROR(status) \ { \ Q     dce_error_inq_text (status, (unsigned_char_t *) error_text, &error_status); \  \      if (error_status == 0) \     { \ ;         fprintf (stderr, "DCE status: %s\n", error_text); \      } \ 
     else \     { \ S         fprintf (stderr, "DCE status: %x (no error text translation)\n", status); \      } \  }   3 INTERNAL char   error_text[dce_c_error_string_len];  INTERNAL int    error_status;  int strncmp();   /*M  * the global file mutex - initialized here, and used by the manager routines   */ * pthread_mutex_t         book_g_file_mutex;  L /*************************************************************************** **F **  The server initialization routine that executes on server startup. **L ***************************************************************************/   main (argc, argv)    int             argc;  char            *argv[];   {      int                     i;.     rpc_if_descriptor_t     if_descriptors[1];4     char                    *program_name = "bookd";<     char                    *server_name = ".:/book_server";2     char                    *logfile = "book.log";1     char                    *logfile_name = NULL; B     unsigned int            mode = rpc_c_server_mode_no_privilege;#     error_status_t          status; (     int                     init_status;         /*"      * check out command arguments      */      for (i = 1; i < argc; i++)     { 
         /*!          * check for "debug" mode           */ .         if ((strncmp (argv[i], "-d", 2)) == 0)	         { ,             mode |= rpc_c_server_mode_debug;	         }   
         /*"          * check for "verify" mode          */ .         if ((strncmp (argv[i], "-v", 2)) == 0)	         { -                                                                                                                                                                                                                                                    [                        P/ $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        z] "     ~                   mode |= rpc_c_server_mode_verify; 	         }   
         /*#          * check for "logging" mode           */ .         if ((strncmp (argv[i], "-l", 2)) == 0)	         { #             logfile_name = logfile; 	         }      }        /*4      * call the common server initialization routine      */ 5     if_descriptors[0].if_handle = book_v1_0_s_ifspec; (     if_descriptors[0].object_ids = NULL;(     if_descriptors[0].annotation = NULL;  B     if ((init_status                                                           gL ~      BOOK.SAV                       d8  ^=  [RPCBOOK.SRC]BOOK_MAIN.C;1                                                                                                     S                                            = rpc_server_init (program_name, server_name,6         1, if_descriptors, mode, NULL, &status)) != 0)     { "         REPORT_DCE_ERROR (status);         exit (init_status);      }        /*'      * initialize the global file mutex       */ G     pthread_mutex_init (&book_g_file_mutex, pthread_mutexattr_default);        /*$      * detach from the user terminal      */ +     if (! (mode & rpc_c_server_mode_debug))      {          if ((init_status =J             rpc_server_detach (program_name, logfile_name, &status)) != 0)	         { &             REPORT_DCE_ERROR (status);             exit (init_status); 	         }      }        /*      * wait for a remote call       */ @     rpc_server_listen (rpc_c_listen_max_calls_default, &status);          if (status != rpc_s_ok)      {          fprintf (stderr,I             "(%s) Error in rpc_server_listen - Exiting\n", program_name); "         REPORT_DCE_ERROR (status);         exit (EXIT_FAILURE);     }   
     exit (0);  }                                   * [RPCBOOK.SRC]BOOK_MGR.C;1 +  , e?   . ,    /  @   4 L   ,   )                     - ^=    0   1    2   3      K  P   W   O -    5   6 wA  7 `:;$  8          9          G  @  H  J $ N                   ? R             /*   **			COPYRIGHT (C) 1993 BY9 **                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 **                  MASSACHUSETTS.  ALL RIGHTS RESERVED. **H ** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK ** ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D ** OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG ** THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L ** PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. **K ** THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L ** SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. **F ** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 ** SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  ** ** **  NAME ** **      book_mgr.c **
 **  FACILITY:  **+ **      RPC example program - BOOK calendar  **
 **  ABSTRACT:  **@ **  These are the server "manager" routines that actually handle **  incoming client requests.  ** */   #include <pthread.h> #include <stdio.h> #include <stdlib.h>  #include "book.h"    /*C  * Since the file system used for maintaining the calendar database C  * doesn't preserve updates from multiple readers and writers, in a H  * multi-threaded server we have to insure this doesn't happen. A simpleJ  * way to do this is to have a single mutex lock that must be taken beforeH  * any file operations can be performed. This will cause any thread that8  * wants to do a write to block until the mutex is free.  *E  * The downside of this implementation is that only one calendar file J  * can be open for reading or writing at any time. A better implementationC  * would keep a list of available calendar files, with a mutex lock D  * associated with each list entry. A thread that wanted to access aH  * calendar file would search the list for the name of the calendar, andH  * take out the lock on that entry. This would at least allow concurrent3  * operations on multiple different calendar files.   *  F  * Even more sophisticated implementations might take into account theI  * fact that it is ok for a file to be open for multiple readers, as long   * as there are no writers.   */    ) extern pthread_mutex_t book_g_file_mutex;   L /*************************************************************************** **@ **  Return to the client the current week of time slots based on, **  the booking information in the database. ** **  Inputs: ' **      binding_handle = client binding , **      book_name = string name of book user0 **      date = date of first day in current week ** **  Outputs:B **      week = array of time slots (booleans) for the current weekI **             (each time slot is idl_true if there is an active booking) . **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int. **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int **L ***************************************************************************/   void book_fill_week  #ifdef IDL_PROTOTYPES  ( )       /* [in] */ handle_t binding_handle, :       /* [in] */ idl_char book_name[book_c_file_name_max],$       /* [in] */ idl_short_int date,,       /* [out] */ idl_short_int week[5][18],.       /* [out] */ error_status_t *book_status,1       /* [out] */ error_status_t *rpc_comm_status  )  #else B 	(binding_handle, book_name, date, week, book_status, comm_status) handle_t        binding_handle; 0 idl_char        book_name[book_c_file_name_max]; idl_short_int   date; ? idl_short_int   week[book_c_days_in_week][book_c_times_in_day];  error_status_t  *book_status;  error_status_t  *comm_status;  #endif   { 0     idl_char    file_name[book_c_file_name_max];     FILE        *book;)     book_booking_record_t booking_record;      int         i, j;      int         pointer;         /*@      * create a filename for the booking file from the book name      */ 5     sprintf ((char*)file_name, "%s.book", book_name);        /**      * take out the global file mutex lock      */ #     pthread_setcancel (CANCEL_OFF); ,     pthread_mutex_lock (&book_g_file_mutex);          /*>      * open the existing file for read access at the beginning      */ 7     if ((book = fopen ((char*)file_name, "r")) == NULL)      { 
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;      }        /*!      * clear out the current week       */ -     for (i = 0; i < book_c_days_in_week; i++)      { 1         for (j = 0; j < book_c_times_in_day; j++) 	         { #             week[i][j] = idl_false; 	         }      }        /*+      * read each record in the booking file       */ +     while (fread ((char *) &booking_record, 1         sizeof (book_booking_record_t), 1, book))      { 
         /*8          * see if this booking falls in the current week          */ *         if ((booking_record.date >= date) C             && (booking_record.date <= date + book_c_days_in_week)) 	         {              /*L              * fill in the time slot for each time contained in this booking              */ 6             for (j = (booking_record.time_start / 30);9                 j <= (booking_record.time_end / 30); j++) 
             { ?                 week[booking_record.date - date][j] = idl_true; 
             } 	         }      }        /*      * close the booking file       */      fclose (book);       /*&      * free the global file mutex lock      */ .     pthread_mutex_unlock (&book_g_file_mutex);"     pthread_setcancel (CANCEL_ON);!     *book_status = book_s_ok;          return;  }   L /*************************************************************************** **@ **  Return to the client the booking information in the database" **  for a specified date and time. ** **  Inputs: ' **      binding_handle = client binding , **      book_name = string name of book user" **      date = date of the booking" **      time = time of the booking ** **  Outputs:/ **      booking = record of booking information . **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int **L ***************************************************************************/   void book_get_booking  #ifdef IDL_PROTOTYPES  ( )       /* [in] */ handle_t binding_handle, :       /* [in] */ idl_char book                                                                                                                                                                                                                                                   \                        gB8 $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        Q "            _name[book_c_file_name_max],$       /* [in] */ idl_short_int date,$       /* [in] */ idl_short_int time,1       /* [out] */ book_booking_record_t *booking, .       /* [out] */ error_status_t *book_status,1       /* [out] */ error_status_t *rpc_comm_status  )  #else 	 K 	(binding_handle, book_name, date, time, booking, book_status, comm_status)    handle_t        binding_handle; 0 idl_char        book_name[book_c_file_name_max]; idl_short_int   date;  idl_short_int   time;  book_booking_record_t *booking;  error_status_t   *book_status; error_status_t   *comm_status;   #endif   { 0     idl_char    file_name[book_c_file_name_max];     FILE        *book;)     book_booking_record_t booking_record;          /*@      * create a filename for the booking file from the book name      */ 5     sprintf ((char*)file_name, "%s.book", book_name);        /**      * take out the global file mutex lock      */ #     pthread_setcancel (CANCEL_OFF); ,     pthread_mutex_lock (&book_g_file_mutex);          /*>      * open the existing file for read access at the beginning      */ 7     if ((book = fopen ((char*)file_name, "r")) == NULL)      { 
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);(         *book_status = book_s_error;             return;      }        /*+      * read each record in the booking file       */ +     while (fread ((char *) &booking_record, 1         sizeof (book_booking_record_t), 1, book))      { 
         /*,          * see if there is a date/time match          */ '         if (date == booking_record.date 1             && (time >= booking_record.time_start 4                 && time <= booking_record.time_end))	         {              /*B              * on a match, return the booking record to the client              */ &             *booking = booking_record;               fclose (book);               /*.              * free the global file mutex lock              */ 6             pthread_mutex_unlock (&book_g_file_mutex);*             pthread_setcancel (CANCEL_ON);%             *book_status = book_s_ok;              return; 	         }      }        fclose (book);       /*&      * free the global file mutex lock      */ .     pthread_mutex_unlock (&book_g_file_mutex);"     pthread_setcancel (CANCEL_ON);      *book_status = book_s_error;     return;  }   L /*************************************************************************** **: **  Write a record of booking information to the database. ** **  Inputs: ' **      binding_handle = client binding , **      book_name = string name of book user/ **      booking = record of booking information  ** **  Outputs:. **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int **L ***************************************************************************/   void book_put_booking B     (binding_handle, book_name, booking, book_status, comm_status)   handle_t        binding_handle;  idl_char        book_name[];  book_booking_record_p_t booking; idl_ulong_int   *book_status;  idl_ulong_int   *comm_status;    { 0     idl_char    file_name[book_c_file_name_max];     FILE        *book;         /*@      * create a filename for the booking file from the book name      */ 5     sprintf ((char*)file_name, "%s.book", book_name);        /**      * take out the global file mutex lock      */ #     pthread_setcancel (CANCEL_OFF); ,     pthread_mutex_lock (&book_g_file_mutex);          /*B      * open the existing file for read and write access at the end      */T8     if ((book = fopen ((char*)file_name, "a+")) == NULL)     {A
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;O     }O     else     {I
         /*?          * append the new record at the end of the booking fileD          */ &         if ((fwrite ((char *) booking,;             sizeof (book_booking_record_t), 1, book)) != 1)R	         {*             fclose (book);               /*.              * free the global file mutex lock              */M6             pthread_mutex_unlock (&book_g_file_mutex);*             pthread_setcancel (CANCEL_ON);(             *book_status = book_s_error;             return; 	         }            fclose (book);  
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);!         *book_status = book_s_ok;e         return;      }u }< rL /*************************************************************************** **G **  Remove a specified record of booking information from the database.n ** **  Inputs:e' **      binding_handle = client binding , **      book_name = string name of book user" **      date = date of the booking" **      time = time of the booking ** **  Outputs:. **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int **L ***************************************************************************/   void book_remove_booking #ifdef IDL_PROTOTYPESn ( )       /* [in] */ handle_t binding_handle,b:       /* [in] */ idl_char book_name[book_c_file_name_max],$       /* [in] */ idl_short_int date,$       /* [in] */ idl_short_int time,.       /* [out] */ error_status_t *book_status,1       /* [out] */ error_status_t *rpc_comm_status  )t #else 	hB 	(binding_handle, book_name, date, time, book_status, comm_status)   handle_t        binding_handle;r0 idl_char        book_name[book_c_file_name_max]; idl_short_int   date;o idl_short_int   time;h error_status_t  *book_status;e error_status_t  *comm_status;  #endif h { 0     idl_char    file_name[book_c_file_name_max];     FILE        *book;)     book_booking_record_t booking_record;*         /*@      * create a filename for the booking file from the book name      */m5     sprintf ((char*)file_name, "%s.book", book_name);t       /**      * take out the global file mutex lock      */n#     pthread_setcancel (CANCEL_OFF);f,     pthread_mutex_lock (&book_g_file_mutex);          /*E      * open the existing file for read/modify access at the beginningh      */ 8     if ((book = fopen ((char*)file_name, "r+")) == NULL)     { 
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;*     }*       /*+      * read each record in the booking file*      */ +     while (fread ((char *) &booking_record, 1         sizeof (book_booking_record_t), 1, book))      {n
         /*,          * see if there is a date/time match          */o'         if (date == booking_record.date_4             && (time >= booking_record.time_start &&1                 time <= booking_record.time_end))o	         {              /*=              * on a match, mark the current record as deleted               */i$             booking_record.date = 0;               /*F              * back up and write the deleted record back into the file              */i@             fseek (book, - (sizeof (book_booking_record_t)), 1);  1             if (fwrite ((char *) &booking_record,c9                 sizeof (book_booking_record_t), 1, book))r
             {_                 fclose (book);                   /*2                  * free the global file mutex lock                  */b:                 pthread_mutex_unlock (&book_g_file_mutex);.                 pthread_setcancel (CANCEL_ON);)                 *book_status = book_s_ok;_                 return; 
             }e	         }o     }e       fclose (book);       /*&      * free the global file mutex lock      */n.     pthread_mutex_unlock (&book_g_file_mutex);"     pthread_setcancel (CANCEL_ON);      *book_status = book_s_error;     return;  }k  L /*************************************************************************** **J **  Update the database of booking information. Removes records previouslyJ **  marked for deletion, as well as entries older than the specified date. ** **  Inputs:d' **      binding_handle = client bindingj, **      book_name = string name of book user8 **      date = date marking beginning of active bookings ** **  Outputs:. **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int **L ***************************************************************************/   void b                                                                                                                                                                                                                                                   ]                        B $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        1 "            ook_update_filel #ifdef IDL_PROTOTYPES  ( )       /* [in] */ handle_t binding_handle,>:       /* [in] */ idl_char book_name[book_c_file_name_max],$       /* [in] */ idl_short_int date,.       /* [out] */ error_status_t *book_status,1       /* [out] */ error_status_t *rpc_comm_status  )  #else < 	(binding_handle, book_name, date, book_status, comm_status)   handle_t        binding_handle; 0 idl_char        book_name[book_c_file_name_max]; idl_short_int   date;t error_status_t  *book_status;  error_status_t  *comm_status;* #endif   {e0     idl_char    file_name[book_c_file_name_max];0     idl_char    temp_name[book_c_file_name_max];2     idl_char    backup_name[book_c_file_name_max];     FILE        *book;     FILE        *new_book;     FILE        *backup;     int         backup_open;)     book_booking_record_t booking_record;*     int         status;          /*@      * create filenames for the booking files from the book name      */e5     sprintf ((char*)file_name, "%s.book", book_name);d5     sprintf ((char*)temp_name, "%s.temp", book_name);f       /**      * take out the global file mutex lock      */t#     pthread_setcancel (CANCEL_OFF); ,     pthread_mutex_lock (&book_g_file_mutex);          /*>      * open the existing file for read access at the beginning      */l7     if ((book = fopen ((char*)file_name, "r")) == NULL)*     {*
         /*/          * if it's not there, try to create oneI          */ ;         if ((book = fopen ((char*)file_name, "w")) == NULL)n	         {a             /*.              * free the global file mutex lock              */*6             pthread_mutex_unlock (&book_g_file_mutex);*             pthread_setcancel (CANCEL_ON);(             *book_status = book_s_error;             return;*	         }a         else	         {d             fclose (book);               /*.              * free the global file mutex lock              */_6             pthread_mutex_unlock (&book_g_file_mutex);*             pthread_setcancel (CANCEL_ON);%             *book_status = book_s_ok;s             return;r	         }t     }m       /*@      * open a new booking file for write access at the beginning      */ ;     if ((new_book = fopen ((char*)temp_name, "w")) == NULL)      { 
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;      }_       backup_open = idl_false;       /*/      * copy all valid records into the new fileg      */ +     while (fread ((char *) &booking_record,f2         sizeof (book_booking_record_t), 1, book))      { 
         /*"          * discard deleted records          */           if (booking_record.date)	         {_             /*D              * if booking has not expired, write it to the new file,4              * otherwise write it to the backup file              */n,             if (booking_record.date >= date)
             {k6                 if ((fwrite ((char *) &booking_record,G                     sizeof (book_booking_record_t), 1, new_book)) == 0)h                 { "                     fclose (book);&                     fclose (new_book);$                     fclose (backup);                       /*6                      * free the global file mutex lock                      */o>                     pthread_mutex_unlock (&book_g_file_mutex);2                     pthread_setcancel (CANCEL_ON);0                     *book_status = book_s_error;                     return;                  }_
             }_             else
             {_!                 if (!backup_open)                  {_                     /*G                      * open the backup file for write access at the end                       */ G                     sprintf ((char*)backup_name, "%s.back", book_name);n=                     backup = fopen ((char*)backup_name, "a"); +                     backup_open = idl_true;*                 }*                   /*8                  * append this record to the backup file                  */ 6                 if ((fwrite ((char *) &booking_record,E                     sizeof (book_booking_record_t), 1, backup)) == 0)n                 { "                     fclose (book);&                     fclose (new_book);$                     fclose (backup);                       /*6                      * free the global file mutex lock                      */n>                     pthread_mutex_unlock (&book_g_file_mutex);2                     pthread_setcancel (CANCEL_ON);0                     *book_status = book_s_error;                     return;_                 }t
             } 	         }      }n       fclose (book);     fclose (new_book);       /*9      * rename the new booking file to replace the old onet      */a4     if (rename ((char*)temp_name, (char*)file_name))     {n
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;e     }        /*&      * free the global file mutex lock      */m.     pthread_mutex_unlock (&book_g_file_mutex);"     pthread_setcancel (CANCEL_ON);     *book_status = book_s_ok;u     return;b }_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;O     }O     else     {I
         /*?          * append the new record at the end of the booking fileD          */ &         if ((fwrite ((char *) booking,;             sizeof (book_booking_record_t), 1,              * [RPCBOOK.SRC]MAKEFILE.;1 +  , f:   .     /  @   4 R                            - ^=    0   1    2   3      K  P   W   O     5   6 @  7 	@  8          9          G  @  H  J $ N                   ?               DCL_IDL= dcl mcr dce\$$idl IDL= $(DCL_IDL)  CFLAGS_INIT = -U VMS -I. IDL_CFLAGS= -v -keep c_source  CC = c892 OPTFILE= /vms/sys0/syscommon/dce\$$library/dce.opt	 APPL=book  IDLCMD=$(IDL)  ALIGN = -W member_alignment  MACHINE_TYPE:=`uname -Wh`    default: interface machine   machine:. 	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \- 	echo "Complile & Link for VMS/Posix VAX" ; \ 9 	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\ 3 	else ; echo "Compile & Link for VMS/Posix AXP:" ;\ @ 	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\ 	fi    build: ostubs book bookd   #  # INTERFACE BUILD  # 4 interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c6 $(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl$ 	$(IDLCMD) $(APPL).idl $(IDL_CFLAGS)   # STUB OBJECTS BUILD' ostubs:	$(APPL)_cstub.o $(APPL)_sstub.o @ $(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL)_cstub.c $(APPL)_sstub.c4 	$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c   #  # CLIENT BUILD   # ) book:	$(APPL).h $(APPL).o $(APPL)_cstub.o A 	$(CC) $(C_FLAGS) -o $(APPL) $(APPL).o $(APPL)_cstub.o $(OPTFILE)    $(APPL).o: $(APPL).c 	$(CC) $(C_FLAGS) -c $(APPL).c   #  # SERVER BUILD   # 3 bookd:	$(APPL)_main.o $(APPL)_mgr.o $(APPL)_sstub.o R 	$(CC) $(C_FLAGS) -o bookd $(APPL)_main.o $(APPL)_mgr.o $(APPL)_sstub.o $(OPTFILE)   $(APPL)_main.o:	$(APPL)_main.c% 		$(CC) $(C_FLAGS) -c $(APPL)_main.c     $(APPL)_mgr.o:	$(APPL)_mgr.c" 	$(CC) $(C_FLAGS) -c $(APPL)_mgr.c     clean:2 	rm -f $(APPL) bookd *.o $(APPL)_*stub.c $(APPL).h              * [RPCBOOK.SRC]README.LIS;1 +  , g>   .     /  @   4 e       V                   - ^=    0   1    2   3      K  P   W   O 
    5   6 hq>  7 ȾA>  8          9          G  @  H  J $ N                   ?               ! 		       BOOK Example Application   J /------------------------------------------------------------------------/ 			COPYRIGHT (C) 1993 BY7                  DIGITAL EQUIPMENT CORPORATION, MAYNARD 6                   MASSACHUSETTS.  ALL RIGHTS RESERVED.  F  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDI  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION B  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESE  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER J  PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.  I  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND J  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.  D  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS7  SOFTWARE ON E                                                                                                                                                                                                                                                   ^                        Ow $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        " "            QUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.   J /------------------------------------------------------------------------/  A The Distributed Calendar (BOOK) program is a fairly sophisticated E client/server application that makes use of a number of DCE services. E The program registers transport endpoints with the RPC daemon, and it D exports server binding information to the directory service. It alsoH demonstrates some minimal use of mutex locks to protect resources on the, server from access by multiple call threads.  H You can run this example application by building the necessary programs,L running the server, then running the client. Each step is discussed in turn, below.     1) Building the BOOK Programs     D    To build the BOOK example programs, enter the following commands:  !    In OpenVMS POSIX environments:         psx> cd /dev/mydir -      psx> copy /usr/dce/examples/rpc/book/* .       psx> make      On OpenVMS systems:  ;      $ copy sys$common:[syshlp.examples.dce.rpc.book]*.* []   '      Then, enter the following command:           $ @book.com  G      If the command procedure successfully builds each executable, you  G      receive a message informing you that an executable has been built.        	            2) Running the BOOKD Server   F    After the build is complete, you can run the server and the client.P    Both are built with the ability to log all events with the RPC Event Logger. <    See the Product Guide chapter on the RPC Event Logger for;    information about activating and using the event logger.   Q    To run the server on OpenVMS, you must perform dce_login ( use principal with  a    /.:/sybsys/dce/cds-server group membership or use cell_admin p/p) and define a foreign command *    with the full directory specification :  1      $ bookd :== "$mydisk:[mydirectory]bookd.exe"   0    Start the server with the following commands:      On OpenVMS            $ bookd -v            On OpenVMS/POSIX   c      psx> dce_login #Enter a principal/password that has /.:/sybsys/dce/cds-server group membership  			 or use cell_admin p/p e      psx> server.sh -v  # Checks for presence of credentials and invokes book server in verbose mode    C    The server accepts the following optional command arguments that F    affect the initialization sequence. The syntax for specifying these3    arguments is the same on both VMS and VMS/POSIX.          Argument    Description   L       -d          (Debug mode) Do not create a child process (run the server)                   in the parent process).   F       -v          (Verbose mode) Display informational messages during!                   initialization.   C   The server calls a useful set of initialization routines from the D   DCE library. These are shipped in rpcserver.c and rpcserver.h. TheE   first call, rpc_server_init(), creates (forks) a process to run the C   server (on UNIX systems) and initializes the RPC runtime with the F   appropriate parameters. The program does this before any other calls@   are made by the server to the RPC runtime and before any otherE   threads calls are made (because thread context is not guaranteed to E   be preserved across a fork).  After performing other initialization B   functions (this program initializes a global mutex), the programD   makes a second call to rpc_server_detach(). This call releases theE   terminal associated with the parent process, after which the parent F   process is free to exit. The server then starts listening for client   requests.        3) Running the BOOK Client      J    Once the server is running, you can run the client on the same host, orI    on any other host in the network that is configured to run in the same     cell as the server host.   B    To run the client on OpenVMS, you must define a foreign command)    with the full directory specification:   /      $ book :== "$mydisk:[mydirectory]book.exe"       Start the client on OpenVMS:          book [name]       On OpenVMS/POSIX         psx> book [name]    E    The [name] parameter is optional, and specifies whose calendar you     wish to use.   C    The client imports server binding information from the directory E    service, and causes the server to update the calendar file for the I    account in which the client is running. The client has a help facility F    that lists the commands that you can execute to modify the calendar    database on the server.  F    You can execute the client as many times as desired, as long as the    server is still running.   F    If you are building the programs on OpenVMS/POSIX, you can clean upE    the directory for this application so that you can build it again.      Enter the following command:        psx> make clean   F    This feature is not currently available on OpenVMS. You must delete    old files manually.                                                                                                                                                                                                                                                                                                                                                                                                                                                           * [RPCBOOK.SRC]RPCSERVER.C;3 +  , hA   . 4    /  @   4 S   4   2                    - ^=    0   1    2   3      K  P   W   O 5    5   6 u  7 r  8          9          G  @  H  J $ N                   ?                             /* **  Copyright (c) 1991 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** **  %a%copyright(,**  )  ** **  NAME ** **      rpcserver.c  **
 **  FACILITY:  ** **      DCE RPC  **
 **  ABSTRACT:  **+ **      Useful RPC server utility routines.  ** **  %a%private_begin ** **  MODIFICATION HISTORY:  **7 **  11-jun-93 ferris    change freopen mode from A to a J **  25-jan-92 magid     in rpc_server_init(), convert the pid to a string I **                      before allocating the annotation string to ensure 1 **                      we don't overwrite memory ? **  16-dec-92 martin    add inclusion of vaxcshr.h for deccrtl. , **  31-Mar-92 keegan    add #include errno.h> **  23-feb-92 sudama    add no_privilege flag to mode argumentI **  19-feb-91 sudama    change error handling, add explicit output status D **  07-feb-92 htink     use DceError to provide locking of cat files1 **  23-jan-92 sudama    add interface descriptors ) **  20-jan-92 sudama    original creation  ** **  %a                                                           DF ~      BOOK.SAV                       hA  ^=  [RPCBOOK.SRC]RPCSERVER.C;3                                                                                                     S     4                         ұ             %private_end   ** */  ) #if defined(VAX) && defined(USE_DECC_RTL)  #include <vaxcshr.h> #endif   #include <pthread.h> #include <stdio.h> #include <errno.h> #include <stdlib.h>  #include <string.h> " #if defined(UNIX) || defined(unix) #include <time.h>  #include <unistd.h>  #include <sys/types.h> #include <sys/file.h>  #include <sys/wait.h>  #include <sys/ioctl.h> #endif #include <dce/rpc.h> #include <rpcserver.h>  " #if defined(UNIX) || defined(unix)! int         parent_child_pipe[2];  #endif   /* **++' **  ROUTINE NAME:       rpc_server_init  **9 **  SCOPE:              PRIVATE - declared in rpcserver.h  ** **  DESCRIPTION: **I **  (optionally) Fork a process to execute the server, and initialize the F **  RPC runtime in preparation for the server to listen for RPC calls. ** **  INPUTS:  **6 **      program_name    The name of the server daemon.J **      server_name     The name of the directory service entry into whichE **                      server binding information is to b \            e exported. I **                      If NULL, no binding information will be exported. G **      if_count        A count of the number of RPC server interfaces. J **      if_descriptors  An array of size if_count of interface descriptorsE **                      to be registered with the RPC runtime and the F **                      endpoint mapper, and exported to the directory8 **                      service. For each if descriptor: **E **                      if_handle = interface handle generated by idl M **                      object_ids = vector of object uuid's to be registered L **                          with ep mapper and exported to directory serviceO **                          along with this interface; NULL                                                                                                                                                                                                                                                    _                        BM $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                         "            if no object uuid's K **                      annotation = annotation field to be registered with @ **                          ep mapper along with this interface;E **                          NULL to use default based on program name  **M **                      Note that the first interface descriptor in the array J **                      will be used to check if there is already a serverF **                      of this type running, so it should contain theG **                      descriptor of some interface that will uniquely J **                      identify the server. Furthermore, the first objectM **                      id in the vector for the first interface will be used G **                      in the test, so in the event there is no unique N **                      interface for the server, an object id can be suppliedJ **                      that will uniquely identify a server of a specific **                      type.  **                      C **      mode            A bit mask containing the following fields:  **N **                      rpc_c_server_mode_debug - don't create a child processF **                          and don't require privileges to run serverH **                      rpc_c_server_mode_verify - display informational: **                          messages during initializationI **                      rpc_c_server_mode_no_if_register - don't register ; **                          interfaces with the RPC runtime I **                      rpc_c_server_mode_no_ep_register - don't register 9 **                          interfaces with the ep mapper F **                      rpc_c_server_mode_no_privilege - don't require4 **                          privileges to run server ** **  INPUT/OUTPUTS:      none ** **  OUTPUTS: **M **     binding_vector   A vector of generated server bindings, comprising the L **                      protocol sequences actually supported by the server.6 **                      NULL on input if not required.J **      status          The status of the operation. This will be rpc_s_okJ **                      if the operation succeeds. If the operation fails,L **                      it will either be rpc_s_ok, or some DCE error statusJ **                      providing specific information on the cause of the  **                      failure. ** **  IMPLICIT INPUTS:    none ** **  IMPLICIT OUTPUTS:   none **4 **  FUNCTION VALUE:     0 for success, 1 for failure ** **  SIDE EFFECTS:       none ** **-- */  7 PRIVATE int rpc_server_init (program_name, server_name, ;     if_count, if_descriptors, mode, binding_vector, status)   & char                    *program_name;% char                    *server_name; ! unsigned int            if_count; ' rpc_if_descriptor_p_t   if_descriptors;  unsigned int            mode; ( rpc_binding_vector_p_t  *binding_vector;  error_status_t          *status;   {      int                     i;9     rpc_binding_vector_p_t  server_binding_vector = NULL; ,     char                    *ep_name = NULL;(     char                    *annotation;'     uuid_vector_p_t         object_ids; 4     error_status_t          local_status = rpc_s_ok;(     error_status_t          temp_status;)     char                    pid_buf[128];        /*7      * if the caller wants output status, initialize it       */      if (status)      {          *status = rpc_s_ok;      }   " #if defined(UNIX) || defined(unix)     { )         int                     uid, pid; -         char                    dummy_buffer;        /         if (! (mode & rpc_c_server_mode_debug)) 	         { :             if (! (mode & rpc_c_server_mode_no_privilege))
             {                  /*B                  * must be root (uid=0) to start the server daemon                  */                  uid = getuid();                         if (uid != 0)                  { $                     fprintf (stderr,H "(%s) You must have system privileges to start this server - Exiting\n",&                         program_name);                     return (1);                  } 
             }                /*J              * create a pipe on which the parent will listen for the childI              * to tell it that's it's ok to exit - which happens later on #              * in rpc_server_detach               *I              * this is here to try to insure that the parent doesn't exit K              * before the server is actually listening, to avoid messing up L              * something else that might be started in sequence that dependsH              * on this server - but it's not totally reliable, since theO              * child has to report *before* it actually calls rpc_server_listen               */ 0             if ((pipe (parent_child_pipe)) != 0)
             {              	fprintf (stderr, M                     "(%s) Unable to establish parent/child pipe - Exiting\n", "                     program_name);             	return (1);
             }                /*;              * fork a daemon process to execute this server               */              pid = fork();                /*1              * return an error if the fork failed               */              if (pid == -1)
             {                   fprintf (stderr,B "(%s) Unable to fork child process to execute server - Exiting\n","                     program_name);             	return (1);
             }                if (pid > 0)
             {      	    	int e_status;                 	/*A     	    	 * the parent waits for the child to report, then exits                   */ *             	close (parent_child_pipe[1]);  O             	read (parent_child_pipe[0], &dummy_buffer, sizeof (dummy_buffer));   5     	    	if (waitpid (pid, &e_status, WNOHANG) != 0)              	{,     	    	    exit (WEXITSTATUS (e_status));             	}     	    	else             	{     	    	    exit (0);              	}
             }                /*"              * the child continues              */ )             close (parent_child_pipe[0]);   0             if (mode & rpc_c_server_mode_verify)
             { C             	fprintf (stdout, "(%s) Created server process [%d]\n", ,                     program_name, getpid());
             }      	}     }  #endif       /*:      * set up the runtime to use all supported protocols -G      * first with the assumption that the one or more of the interfaces 3      * in the list has well-known endpoints defined       */ "     for (i = 0; i < if_count; i++)     { G         rpc_server_use_all_protseqs_if (rpc_c_protseq_max_reqs_default, 8             if_descriptors[i].if_handle, &local_status);  
         /*D          * if the same well-known endpoint is used for more than oneN          * interface, the call might fail because the soecket is already bound          */ )         if ((local_status != rpc_s_ok) && 5             (local_status != rpc_s_cant_bind_socket)) 	         { 2             if (local_status != rpc_s_no_protseqs)
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,S                         "(%s) Error in rpc_server_use_all_protseqs_if - Exiting\n", &                         program_name);                 } "                 goto EXIT_HANDLER;
             } 	         }      }        /*6      * accomodate the use of dynamic endpoints as well      */bP     rpc_server_use_all_protseqs (rpc_c_protseq_max_reqs_default, &local_status);  !     if (local_status != rpc_s_ok)s     { +         if (mode & rpc_c_server_mode_debug)*	         {A             fprintf (stderr,H                 "(%s) Error in rpc_server_use_all_protseqs - Exiting\n",                 program_name);	         }e         goto EXIT_HANDLER;     }j       /**      * get back what is actually supported      */nD     rpc_server_inq_bindings (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)t     {i+         if (mode & rpc_c_server_mode_debug)s	         {s             fprintf (stderr,D                 "(%s) Error in rpc_server_inq_bindings - Exiting\n",                 program_name);	         }          goto EXIT_HANDLER;     }d       /*F      * for each binding in the vector, try to contact a running server      */l6     for (i = 0; i < server_binding_vector->count; i++)     {j
         /*5          * clear any existing endpoint in the binding/          */eO         rpc_binding_reset (server_binding_vector->binding_h[i], &local_status);a  %         if (local_status != rpc_s_ok).	         {e/             if (mode & rpc_c_server_mode_debug)N
                                                                                                                                                                                                                                                    `                        #% $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        n "                        {uO                 fprintf (stderr, "(%s) Error in rpc_binding_reset - Exiting\n",<"                     program_name);
             }/             goto EXIT_HANDLER;	         }c  
         /*I          * if there are any object id's for the first interface, use them]8          * to disambiguate servers of the same interface          */ 1         if (if_descriptors[0].object_ids != NULL)r	         { H             rpc_binding_set_object (server_binding_vector->binding_h[i],F                 if_descriptors[0].object_ids->uuid[0], &local_status);  -             if ((local_status != rpc_s_ok) && 7                 (local_status != ept_s_not_registered)) 
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,K                         "(%s) Error in rpc_binding_set_object - Exiting\n", &                         program_name);                 }f"                 goto EXIT_HANDLER;
             }n	         }i  
         /*C          * resolve this binding to see if an endpoint is registered           */mD         rpc_ep_resolve_binding (server_binding_vector->binding_h[i],8             if_descriptors[0].if_handle, &local_status);  )         if ((local_status != rpc_s_ok) &&h3             (local_status != ept_s_not_registered)) 	         { /             if (mode & rpc_c_server_mode_debug)s
             {                   fprintf (stderr,G                     "(%s) Error in rpc_ep_resolve_binding - Exiting\n",h"                     program_name);
             }              goto EXIT_HANDLER;	         }l  
         /*C          * if there is a server registered for this binding, try toe+          * contact it to see if it's actives          */e%         if (local_status == rpc_s_ok) 	         {e             /*>              * set the comm timeout to a relatively short wait              */ $             rpc_mgmt_set_com_timeoutH                 (server_binding_vector->binding_h[i], 1, &local_status);  )             if (local_status != rpc_s_ok)a
             { 3                 if (mode & rpc_c_server_mode_debug)r                 {e$                     fprintf (stderr,M                         "(%s) Error in rpc_mgmt_set_com_timeout - Exiting\n",s&                         program_name);                 } "                 goto EXIT_HANDLER;
             }u  ,             if (rpc_mgmt_is_server_listeningD                 (server_binding_vector->binding_h[i], &temp_status))
             {                   fprintf (stderr,K "(%s) Please verify that no other %s is active on this system - Exiting\n",_0                     program_name, program_name);O                 rpc_binding_vector_free (&server_binding_vector, &temp_status); M                 errno = 0;      /* this return (1) is NOT a system failure */                  return (1);n
             }*	         }      }        /*      * free the binding vector      */ D     rpc_binding_vector_free (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)_     {r+         if (mode & rpc_c_server_mode_debug) 	         {s             fprintf (stderr,D                 "(%s) Error in rpc_binding_vector_free - Exiting\n",                 program_name);	         }v         goto EXIT_HANDLER;     }e     (     if (mode & rpc_c_server_mode_verify)     {rM         fprintf (stdout, "(%s) Server protocols registered\n", program_name);l     }c       /*2      * get back what is actually supported (again)      */nD     rpc_server_inq_bindings (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)      { +         if (mode & rpc_c_server_mode_debug) 	         {              fprintf (stderr,D                 "(%s) Error in rpc_server_inq_bindings - Exiting\n",                 program_name);	         }f         goto EXIT_HANDLER;     }r  (     if (mode & rpc_c_server_mode_verify)     {C         fprintf (stdout,H             "(%s) Server binding information inquired\n", program_name);     }o       /*3      * Display the pid using the host's convention.sD      * VMS displays pids in hex. Everyone else seems to use decimal.      */h  #if defined(VMS) || defined(vms)(     sprintf (pid_buf, "[%X]", getpid()); #elsen(     sprintf (pid_buf, "[%d]", getpid()); #endif       /*I      * construct a name to annotate the ep map entry. Add 1 char for the gF      * space between program name and the pid. Add 1 char for the null      * terminating char.      */tO     ep_name = (char *) (malloc (strlen (program_name) + strlen (pid_buf) + 2));           if (ep_name == NULL)     { +         if (mode & rpc_c_server_mode_debug) 	         {sJ             fprintf (stderr, "(%s) Unable to allocate memory - Exiting\n",                 program_name);	         }]'         local_status = rpc_s_no_memory;o         goto EXIT_HANDLER;     }*  6     sprintf (ep_name, "%s %s", program_name, pid_buf);     "     for (i = 0; i < if_count; i++)     { 8         if (! (mode & rpc_c_server_mode_no_if_register))	         {              /*6              * register the interface with the runtime              */ "             rpc_server_register_ifI                 (if_descriptors[i].if_handle, NULL, NULL, &local_status);   )             if (local_status != rpc_s_ok)s
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,K                         "(%s) Error in rpc_server_register_if - Exiting\n", &                         program_name);                 } "                 goto EXIT_HANDLER;
             }   0             if (mode & rpc_c_server_mode_verify)
             {c                  fprintf (stdout,I                     "(%s) Server interfaces registered\n", program_name);-
             }l	         }      
         /*9          * check the optional fields in the if descriptorr          */n)         if (if_descriptors[i].object_ids) 	         {r6             object_ids = if_descriptors[i].object_ids;	         }          else	         {m             object_ids = NULL;	         }   8         if (! (mode & rpc_c_server_mode_no_ep_register))	         { -             if (if_descriptors[i].annotation)a
             {p:                 annotation = if_descriptors[i].annotation;
             }e             else
             { %                 annotation = ep_name; 
             }e               /*?              * register the dynamic endpoints that were created               */rP             rpc_ep_register (if_descriptors[i].if_handle, server_binding_vector,K                 object_ids, (unsigned_char_t *) annotation, &local_status);   )             if (local_status != rpc_s_ok) 
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,D                         "(%s) Error in rpc_ep_register - Exiting\n",&                         program_name);                 } "                 goto EXIT_HANDLER;
             }	  0             if (mode & rpc_c_server_mode_verify)
             {o                  fprintf (stdout,H                     "(%s) Server endpoints registered\n", program_name);
             }p	         }_            if (server_name != NULL)	         {              /*B              * export the server bindings to the directory service              */S#             rpc_ns_binding_export ( (                 rpc_c_ns_syntax_default,0                 (unsigned_char_t *) server_name,,                 if_descriptors[i].if_handle,&                 server_binding_vector,                 object_ids,                  &local_status);_  )             if (local_status != rpc_s_ok)r
             {(3                 if (mode & rpc_c_server_mode_debug)                  {e$                     fprintf (stderr,J                         "(%s) Error in rpc_ns_binding_export - Exiting\n",&                         program_name);                 } "                 goto EXIT_HANDLER;
             }w  0             if (mode & rpc_c_server_mode_verify)
             {                   fprintf (stdout,P                     "(%s) Server binding information exported\n", program_name);
             }t	         }      }*    
 EXIT_HANDLER:        /*8      * free the name used for the ep database annotation      */      if (ep_name != NULL)     {e         free (ep_name);      }        /*:      * free the binding vector, unless the caller wants it      */c?     if ((local_status == rpc_s_ok) && (binding_vector != NULL))p     {p-     	*binding_vector = server_binding_vector;o%         server_binding_vector = NULL;      }      else                                                                                                                                                                                                                                                        a                        _v $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        H "            { *         if (server_binding_vector != NULL)	         {rK             rpc_binding_vector_free (&server_binding_vector, &temp_status); 	         }e	     }       !     if (local_status != rpc_s_ok)_     {;
         /*>          * pass back the failure status if the caller wants it          */o         if (status)b	         {e#             *status = local_status;m	         }a         return (1);      }f       return (0);p }_ s /* **++) **  ROUTINE NAME:       rpc_server_detach* **9 **  SCOPE:              PRIVATE - declared in rpcserver.hs ** **  DESCRIPTION: **F **  Detach the server from the user terminal and (optionally) redirect$ **  stdout and stderr to a log file. ** **  INPUTS:t **6 **      program_name    The name of the server daemon.@ **      logfile_name    The full pathname of the server logfile.D **                      If NULL, no logfile will be created - stdoutC **                      and stderr will be redirected to /dev/null.  ** **  INPUT/OUTPUTS:      none ** **  OUTPUTS: **J **      status          The status of the operation. This will be rpc_s_okJ **                      if the operation succeeds. If the operation fails,L **                      it will either be rpc_s_ok, or some DCE error statusJ **                      providing specific information on the cause of the  **                      failure. ** **  IMPLICIT INPUTS:    none ** **  IMPLICIT OUTPUTS:   none **4 **  FUNCTION VALUE:     0 for success, 1 for failure ** **  SIDE EFFECTS:       none ** **-- */  B PRIVATE int rpc_server_detach (program_name, logfile_name, status)  & char                    *program_name;& char                    *logfile_name;  error_status_t          *status;   {      /*7      * if the caller wants output status, initialize itf      */t     if (status)t     {b         *status = rpc_s_ok;t     }   " #if defined(UNIX) || defined(unix)     {b$         int                     tty;)         FILE                    *logfile;g(         time_t                  systime;    
         /*F          * we must reassign stdout and stderr to files or we'll end upE          * spewing some random garbage into a random terminal at some           * random future time 
          *M          * do this before detaching the terminal, so we can report errors andd&          * exit if anything goes wrong          */i!         if (logfile_name != NULL) 	         { :             logfile = freopen (logfile_name, "a", stdout);                if (logfile == NULL)
             {                   fprintf (stderr,F                     "(%s) Unable to reassign program I/O - Exiting\n","                     program_name);                 return (1); 
             }s
         }    &         else	         { 9             logfile = freopen ("/dev/null", "w", stdout);u                if (logfile == NULL)
             {                   fprintf (stderr,F                     "(%s) Unable to reassign program I/O - Exiting\n","                     program_name);                 return (1); 
             }g	         }   +         setvbuf (logfile, NULL, _IONBF, 0);            if ((dup2 (1,2)) == -1)*	         {s             fprintf (stderr,B                 "(%s) Unable to reassign program I/O - Exiting\n",                 program_name);             return (1); 	         }   
         /*(          * write a header to the logfile          */t         time (&systime);B         fprintf (stdout, "[%d] %s\n", getpid(), ctime (&systime));.                                               . #ifdef _BSD                                   .         if (setpgrp(0, getpid()) < 0) {       .             fprintf (stderr,                  H                 "(%s) Unable to create a new process group - Exiting\n",.                 program_name);                .             return(1);                        .         }                                     .                                               .         if (setreuid (0,0) < 0) {             .             fprintf (stderr,                  ;                 "(%s) Unable to set uids to 0 - Exiting\n",i.                 program_name);                .             return(1);                        .         }                                     .                                               
         /*&          * detach from controlling tty          */ 3         if ((tty = open ("/dev/tty", O_RDWR)) >= 0) 	         { /             ioctl (tty, TIOCNOTTY, (char *) 0);i             close (tty);         }                                     #else                          if (setsid() < 0) {&             fprintf (stderr,B                 "(%s) Unable to set process group id - Exiting\n",                 program_name);             return(1);         }                      if (setuid(0) < 0) {             fprintf (stderr,:                 "(%s) Unable to set uid to 0 - Exiting\n",                 program_name);             return(1);         }              #endif                  
         /*M          * inform the parent that we're ready to process requests (by closing_7          * the pipe, and causing the parent to wake up)           */(%         close (parent_child_pipe[1]);      }  #endif       return (0);  }                                                                                                                                              * [RPCBOOK.SRC]RPCSERVER.C;2 +  , h=   . 4    /  @   4 S   4   2                    - ^=    0   1    2   3      K  P   W   O 5    5   6 u  7 G(  8          9          G  @  H  J $ N                   ?                             /* **  Copyright (c) 1991 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** **  %a%copyright(,**  )  ** **  NAME ** **      rpcserver.c  **
 **  FACILITY:  ** **      DCE RPC  **
 **  ABSTRACT:  **+ **      Useful RPC server utility routines.  ** **  %a%private_begin ** **  MODIFICATION HISTORY:  **7 **  11-jun-93 ferris    change freopen mode from A to a J **  25-jan-92 magid     in rpc_server_init(), convert the pid to a string I **                      before allocating the annotation string to ensure 1 **                      we don't overwrite memory ? **  16-dec-92 martin    add inclusion of vaxcshr.h for deccrtl. , **  31-Mar-92 keegan    add #include errno.h> **  23-feb-92 sudama    add no_privilege flag to mode argumentI **  19-feb-91 sudama    change error handling, add explicit output status D **  07-feb-92 htink     use DceError to provide locking of cat files1 **  23-jan-92 sudama    add interface descriptors ) **  20-jan-92 sudama    original creation  ** **  %a%private_end   ** */  ) #if defined(VAX) && defined(USE_DECC_RTL)  #include <vaxcshr.h> #endif   #include <pthread.h> #include <stdio.h> #include <errno.h> #include <stdlib.h>  #include <string.h> " #if defined(UNIX) || defined(unix) #include <time.h>  #include <unistd.h>  #include <sys/types.h> #include <sys/file.h>  #include <sys/wait.h>  #include <sys/ioctl.h> #endif #include <dce/rpc.h> #include <rpcserver.h>  " #if defined(UNIX) || defined(unix)! int         parent_child_pipe[2];  #endif   /* **++' **  ROUTINE NAME:       rpc_server_init  **9 **  SCOPE:              PRIVATE - declared in rpcserver.h  ** **  DESCRIPTION: **I **  (optionally) Fork a process to execute the server, and initialize the F **  RPC runtime in preparation for the server to listen for RPC calls. ** **  INPUTS:  **6 **      program_name    The name of the server daemon.J **      server_name     The name of the directory service entry into whichE **                      server binding information is to be exported. I **                      If NULL, no binding information will be exported. G **      if_count        A count of the number of RPC server interfaces. J **      if_descriptors  An array of size if_count of interface descriptorsE **                      to be registered with the RPC runtime and the F **                      endpoint mapper, and exported to the directory8 **                      service. For each if descriptor: **E **                      if_handle = interface handle generated by idl M **                      object_ids = vector of object uuid's to be registered L **                          with ep mapper and exported to directory serviceO **                          along with this interface; NULL if no object uuid's K **                      annotation = annotation field to be registered with @ **                          ep mapper along with this interface;E **                                                                                                                                                                                                                                                                           b                        8,i $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        W "              NULL to use default based on program name  **M **                      Note that the first interface descriptor in the array J **                      will be used to check if there is already a serverF **                      of this type running, so it should contain theG **                      descriptor of some interface that will uniquely J **                      identify the server. Furthermore, the first objectM **                      id in the vector for the first interface will be used G **                      in the test, so in the event there is no unique N **                      interface for the server, an object id can be suppliedJ **                      that will uniquely identify a server of a specific **                      type.  **                      C **      mode            A bit mask containing the following fields:  **N **                      rpc_c_server_mode_debug - don't create a child processF **                          and don't require privileges to run serverH **                      rpc_c_server_mode_verify - display informational: **                          messages during initializationI **                      rpc_c_server_mode_no_if_register - don't register ; **                          interfaces with the RPC runtime I **                      rpc_c_server_mode_no_ep_register - don't register 9 **                          interfaces with the ep mapper F **                      rpc_c_server_mode_no_privilege - don't require4 **                          privileges to run server ** **  INPUT/OUTPUTS:      none ** **  OUTPUTS: **M **     binding_vector   A vector of generated server bindings, comprising the L **                      protocol sequences actually supported by the server.6 **                      NULL on input if not required.J **      status          The status of the operation. This will be rpc_s_okJ **                      if the operation succeeds. If the operation fails,L **                      it will either be rpc_s_ok, or some DCE error statusJ **                      providing specific information on the cause of the  **                      failure. ** **  IMPLICIT INPUTS:    none ** **  IMPLICIT OUTPUTS:   none **4 **  FUNCTION VALUE:     0 for success, 1 for failure ** **  SIDE EFFECTS:       none ** **-- */  7 PRIVATE int rpc_server_init (program_name, server_name, ;     if_count, if_descriptors, mode, binding_vector, status)   & char                    *program_name;% char                    *server_name; ! unsigned int            if_count; ' rpc_if_descriptor_p_t   if_descriptors;  unsigned int            mode; ( rpc_binding_vector_p_t  *binding_vector;  error_status_t          *status;   {      int                     i;9     rpc_binding_vector_p_t  server_binding_vector = NULL; ,     char                    *ep_name = NULL;(     char                    *annotation;'     uuid_vector_p_t         object_ids; 4     error_status_t          local_status = rpc_s_ok;(     error_status_t          temp_status;)     char                    pid_buf[128];        /*7      * if the caller wants output status, initialize it       */      if (status)      {          *status = rpc_s_ok;      }   " #if defined(UNIX) || defined(unix)     { )         int                     uid, pid; -         char                    dummy_buffer;        /         if (! (mode & rpc_c_server_mode_debug)) 	         { :             if (! (mode & rpc_c_server_mode_no_privilege))
             {                  /*B                  * must be root (uid=0) to start the server daemon                  */                  uid = getuid();                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ~      BOOK.SAV                       h=  ^=  [RPCBOOK.SRC]RPCSERVER.C;2                                                                                                     S     4                         Ƴ J                        if (uid != 0)                  { $                     fprintf (stderr,H "(%s) You must have system privileges to start this server - Exiting\n",&                         program_name);                     return (1);                  } 
             }                /*J              * create a pipe on which the parent will listen for the childI              * to tell it that's it's ok to exit - which happens later on #              * in rpc_server_detach               *I              * this is here to try to insure that the parent doesn't exit K              * before the server is actually listening, to avoid messing up L              * something else that might be started in sequence that dependsH              * on this server - but it's not totally reliable, since theO              * child has to report *before* it actually calls rpc_server_listen               */ 0             if ((pipe (parent_child_pipe)) != 0)
             {              	fprintf (stderr, M                     "(%s) Unable to establish parent/child pipe - Exiting\n", "                     program_name);             	return (1);
             }                /*;              * fork a daemon process to execute this server               */              pid = fork();                /*1              * return an error if the fork failed               */              if (pid == -1)
             {                   fprintf (stderr,B "(%s) Unable to fork child process to execute server - Exiting\n","                     program_name);             	return (1);
             }                if (pid > 0)
             {      	    	int e_status;                 	/*A     	    	 * the parent waits for the child to report, then exits                   */ *             	close (parent_child_pipe[1]);  O             	read (parent_child_pipe[0], &dummy_buffer, sizeof (dummy_buffer));   5     	    	if (waitpid (pid, &e_status, WNOHANG) != 0)              	{,     	    	    exit (WEXITSTATUS (e_status));             	}     	    	else             	{     	    	    exit (0);              	}
             }                /*"              * the child continues              */ )             close (parent_child_pipe[0]);   0             if (mode & rpc_c_server_mode_verify)
             { C             	fprintf (stdout, "(%s) Created server process [%d]\n", ,                     program_name, getpid());
             }      	}     }  #endif       /*:      * set up the runtime to use all supported protocols -G      * first with the assumption that the one or more of the interfaces 3      * in the list has well-known endpoints defined       */ "     for (i = 0; i < if_count; i++)     { G         rpc_server_use_all_protseqs_if (rpc_c_protseq_max_reqs_default, 8             if_descriptors[i].if_handle, &local_status);  
         /*D          * if the same well-known endpoint is used for more than oneN          * interface, the call might fail because the soecket is already bound          */ )         if ((local_status != rpc_s_ok) && 5             (local_status != rpc_s_cant_bind_socket)) 	         { 2             if (local_status != rpc_s_no_protseqs)
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,S                         "(%s) Error in rpc_server_use_all_protseqs_if - Exiting\n", &                         program_name);                 } "                 goto EXIT_HANDLER;
             } 	         }      }        /*6      * accomodate the use of dynamic endpoints as well      */bP     rpc_server_use_all_protseqs (rpc_c_protseq_max_reqs_default, &local_status);  !     if (local_status != rpc_s_ok)s     { +         if (mode & rpc_c_server_mode_debug)*	         {A             fprintf (stderr,H                 "(%s) Error in rpc_server_use_all_protseqs - Exiting\n",                 program_name);	         }e         goto EXIT_HANDLER;     }j       /**      * get back what is actually supported      */nD     rpc_server_inq_bindings (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)t     {i+         if (mode & rpc_c_server_mode_debug)s	         {s             fprintf (stderr,D                 "(%s) Error in rpc_server_inq_bindings - Exiting\n",                                                                                                                                                                                                                                                            c                        a $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        ; "                   program_name);	         }          goto EXIT_HANDLER;     }d       /*F      * for each binding in the vector, try to contact a running server      */l6     for (i = 0; i < server_binding_vector->count; i++)     {j
         /*5          * clear any existing endpoint in the binding/          */eO         rpc_binding_reset (server_binding_vector->binding_h[i], &local_status);a  %         if (local_status != rpc_s_ok).	         {e/             if (mode & rpc_c_server_mode_debug)N
             {uO                 fprintf (stderr, "(%s) Error in rpc_binding_reset - Exiting\n",<"                     program_name);
             }/             goto EXIT_HANDLER;	         }c  
         /*I          * if there are any object id's for the first interface, use them]8          * to disambiguate servers of the same interface          */ 1         if (if_descriptors[0].object_ids != NULL)r	         { H             rpc_binding_set_object (server_binding_vector->binding_h[i],F                 if_descriptors[0].object_ids->uuid[0], &local_status);  -             if ((local_status != rpc_s_ok) && 7                 (local_status != ept_s_not_registered)) 
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,K                         "(%s) Error in rpc_binding_set_object - Exiting\n", &                         program_name);                 }f"                 goto EXIT_HANDLER;
             }n	         }i  
         /*C          * resolve this binding to see if an endpoint is registered           */mD         rpc_ep_resolve_binding (server_binding_vector->binding_h[i],8             if_descriptors[0].if_handle, &local_status);  )         if ((local_status != rpc_s_ok) &&h3             (local_status != ept_s_not_registered)) 	         { /             if (mode & rpc_c_server_mode_debug)s
             {                   fprintf (stderr,G                     "(%s) Error in rpc_ep_resolve_binding - Exiting\n",h"                     program_name);
             }              goto EXIT_HANDLER;	         }l  
         /*C          * if there is a server registered for this binding, try toe+          * contact it to see if it's actives          */e%         if (local_status == rpc_s_ok) 	         {e             /*>              * set the comm timeout to a relatively short wait              */ $             rpc_mgmt_set_com_timeoutH                 (server_binding_vector->binding_h[i], 1, &local_status);  )             if (local_status != rpc_s_ok)a
             { 3                 if (mode & rpc_c_server_mode_debug)r                 {e$                     fprintf (stderr,M                         "(%s) Error in rpc_mgmt_set_com_timeout - Exiting\n",s&                         program_name);                 } "                 goto EXIT_HANDLER;
             }u  ,             if (rpc_mgmt_is_server_listeningD                 (server_binding_vector->binding_h[i], &temp_status))
             {                   fprintf (stderr,K "(%s) Please verify that no other %s is active on this system - Exiting\n",_0                     program_name, program_name);O                 rpc_binding_vector_free (&server_binding_vector, &temp_status); M                 errno = 0;      /* this return (1) is NOT a system failure */                  return (1);n
             }*	         }      }        /*      * free the binding vector      */ D     rpc_binding_vector_free (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)_     {r+         if (mode & rpc_c_server_mode_debug) 	         {s             fprintf (stderr,D                 "(%s) Error in rpc_binding_vector_free - Exiting\n",                 program_name);	         }v         goto EXIT_HANDLER;     }e     (     if (mode & rpc_c_server_mode_verify)     {rM         fprintf (stdout, "(%s) Server protocols registered\n", program_name);l     }c       /*2      * get back what is actually supported (again)      */nD     rpc_server_inq_bindings (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)      { +         if (mode & rpc_c_server_mode_debug) 	         {              fprintf (stderr,D                 "(%s) Error in rpc_server_inq_bindings - Exiting\n",                 program_name);	         }f         goto EXIT_HANDLER;     }r  (     if (mode & rpc_c_server_mode_verify)     {C         fprintf (stdout,H             "(%s) Server binding information inquired\n", program_name);     }o       /*3      * Display the pid using the host's convention.sD      * VMS displays pids in hex. Everyone else seems to use decimal.      */h  #if defined(VMS) || defined(vms)(     sprintf (pid_buf, "[%X]", getpid()); #elsen(     sprintf (pid_buf, "[%d]", getpid()); #endif       /*I      * construct a name to annotate the ep map entry. Add 1 char for the gF      * space between program name and the pid. Add 1 char for the null      * terminating char.      */tO     ep_name = (char *) (malloc (strlen (program_name) + strlen (pid_buf) + 2));           if (ep_name == NULL)     { +         if (mode & rpc_c_server_mode_debug) 	         {sJ             fprintf (stderr, "(%s) Unable to allocate memory - Exiting\n",                 program_name);	         }]'         local_status = rpc_s_no_memory;o         goto EXIT_HANDLER;     }*  6     sprintf (ep_name, "%s %s", program_name, pid_buf);     "     for (i = 0; i < if_count; i++)     { 8         if (! (mode & rpc_c_server_mode_no_if_register))	         {              /*6              * register the interface with the runtime              */ "             rpc_server_register_ifI                 (if_descriptors[i].if_handle, NULL, NULL, &local_status);   )             if (local_status != rpc_s_ok)s
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,K                         "(%s) Error in rpc_server_register_if - Exiting\n", &                         program_name);                 } "                 goto EXIT_HANDLER;
             }   0             if (mode & rpc_c_server_mode_verify)
             {c                  fprintf (stdout,I                     "(%s) Server interfaces registered\n", program_name);-
             }l	         }      
         /*9          * check the optional fields in the if descriptorr          */n)         if (if_descriptors[i].object_ids) 	         {r6             object_ids = if_descriptors[i].object_ids;	         }          else	         {m             object_ids = NULL;	         }   8         if (! (mode & rpc_c_server_mode_no_ep_register))	         { -             if (if_descriptors[i].annotation)a
             {p:                 annotation = if_descriptors[i].annotation;
             }e             else
             { %                 annotation = ep_name; 
             }e               /*?              * register the dynamic endpoints that were created               */rP             rpc_ep_register (if_descriptors[i].if_handle, server_binding_vector,K                 object_ids, (unsigned_char_t *) annotation, &local_status);   )             if (local_status != rpc_s_ok) 
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,D                         "(%s) Error in rpc_ep_register - Exiting\n",&                         program_name);                 } "                 goto EXIT_HANDLER;
             }	  0             if (mode & rpc_c_server_mode_verify)
             {o                  fprintf (stdout,H                     "(%s) Server endpoints registered\n", program_name);
             }p	         }_            if (server_name != NULL)	         {              /*B              * export the server bindings to the directory service              */S#             rpc_ns_binding_export ( (                 rpc_c_ns_syntax_default,0                 (unsigned_char_t *) server_name,,                 if_descriptors[i].if_handle,&                 server_binding_vector,                 object_ids,                  &local_status);_  )             if (local_status != rpc_s_ok)r
             {(3                 if (mode & rpc_c_server_mode_debug)                  {e$                     fprintf (stderr,J                         "(%s) Error in rpc_ns_binding_export - Exiting\n",&                         program_name);                 } "                 goto EXIT_HANDLER;
             }w  0             if (mode & rpc_c_server_mode_verify)
             {                   fprintf (stdout,P                     "(%s) Server binding information                                                                                                                                                                                                                                                   d                        <$ $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        7 "            exported\n", program_name);
             }t	         }      }*    
 EXIT_HANDLER:        /*8      * free the name used for the ep database annotation      */      if (ep_name != NULL)     {e         free (ep_name);      }        /*:      * free the binding vector, unless the caller wants it      */c?     if ((local_status == rpc_s_ok) && (binding_vector != NULL))p     {p-     	*binding_vector = server_binding_vector;o%         server_binding_vector = NULL;      }      else     { *         if (server_binding_vector != NULL)	         {rK             rpc_binding_vector_free (&server_binding_vector, &temp_status); 	         }e	     }       !     if (local_status != rpc_s_ok)_     {;
         /*>          * pass back the failure status if the caller wants it          */o         if (status)b	         {e#             *status = local_status;m	         }a         return (1);      }f       return (0);p }_ s /* **++) **  ROUTINE NAME:       rpc_server_detach* **9 **  SCOPE:              PRIVATE - declared in rpcserver.hs ** **  DESCRIPTION: **F **  Detach the server from the user terminal and (optionally) redirect$ **  stdout and stderr to a log file. ** **  INPUTS:t **6 **      program_name    The name of the server daemon.@ **      logfile_name    The full pathname of the server logfile.D **                      If NULL, no logfile will be created - stdoutC **                      and stderr will be redirected to /dev/null.  ** **  INPUT/OUTPUTS:      none ** **  OUTPUTS: **J **      status          The status of the operation. This will be rpc_s_okJ **                      if the operation succeeds. If the operation fails,L **                      it will either be rpc_s_ok, or some DCE error statusJ **                      providing specific information on the cause of the  **                      failure. ** **  IMPLICIT INPUTS:    none ** **  IMPLICIT OUTPUTS:   none **4 **  FUNCTION VALUE:     0 for success, 1 for failure ** **  SIDE EFFECTS:       none ** **-- */  B PRIVATE int rpc_server_detach (program_name, logfile_name, status)  & char                    *program_name;& char                    *logfile_name;  error_status_t          *status;   {      /*7      * if the caller wants output status, initialize itf      */t     if (status)t     {b         *status = rpc_s_ok;t     }   " #if defined(UNIX) || defined(unix)     {b$         int                     tty;)         FILE                    *logfile;g(         time_t                  systime;    
         /*F          * we must reassign stdout and stderr to files or we'll end upE          * spewing some random garbage into a random terminal at some           * random future time 
          *M          * do this before detaching the terminal, so we can report errors andd&          * exit if anything goes wrong          */i!         if (logfile_name != NULL) 	         { :             logfile = freopen (logfile_name, "a", stdout);                if (logfile == NULL)
             {                   fprintf (stderr,F                     "(%s) Unable to reassign program I/O - Exiting\n","                     program_name);                 return (1); 
             }s
         }    &         else	         { 9             logfile = freopen ("/dev/null", "w", stdout);u                if (logfile == NULL)
             {                   fprintf (stderr,F                     "(%s) Unable to reassign program I/O - Exiting\n","                     program_name);                 return (1); 
             }g	         }   +         setvbuf (logfile, NULL, _IONBF, 0);            if ((dup2 (1,2)) == -1)*	         {s             fprintf (stderr,B                 "(%s) Unable to reassign program I/O - Exiting\n",                 program_name);             return (1); 	         }   
         /*(          * write a header to the logfile          */t         time (&systime);B         fprintf (stdout, "[%d] %s\n", getpid(), ctime (&systime));.                                               . #ifdef _BSD                                   .         if (setpgrp(0, getpid()) < 0) {       .             fprintf (stderr,                  H                 "(%s) Unable to create a new process group - Exiting\n",.                 program_name);                .             return(1);                        .         }                                     .                                               .         if (setreuid (0,0) < 0) {             .             fprintf (stderr,                  ;                 "(%s) Unable to set uids to 0 - Exiting\n",i.                 program_name);                .             return(1);                        .         }                                     .                                               
         /*&          * detach from controlling tty          */ 3         if ((tty = open ("/dev/tty", O_RDWR)) >= 0) 	         { /             ioctl (tty, TIOCNOTTY, (char *) 0);i             close (tty);         }                                     #else                          if (setsid() < 0) {&             fprintf (stderr,B                 "(%s) Unable to set process group id - Exiting\n",                 program_name);             return(1);         }                      if (setuid(0) < 0) {             fprintf (stderr,:                 "(%s) Unable to set uid to 0 - Exiting\n",                 program_name);             return(1);         }              #endif                  
         /*M          * inform the parent that we're ready to process requests (by closing_7          * the pipe, and causing the parent to wake up)           */(%         close (parent_child_pipe[1]);      }  #endif       return (0);  }                                                                                                                                              * [RPCBOOK.SRC]RPCSERVER.H;3 +  , $   .     /  @   4 >                          - ^=   0   1    2   3      K  P   W   O     5   6 Fyw>  7   8          9          G  @  H  J $ N                   ?                            #ifndef RPCSERVER_H
#define RPCSERVER_H
/*
**  Copyright (c) 1991 by
**      Digital Equipment Corporation, Maynard, Mass.
**
**  %a%copyright(,**  )
**
**  NAME:
**
**      rpcserver.h
**
**  FACILITY:
**
**      DCE RPC
**
**  ABSTRACT:
**
**      Useful RPC server utility functions.
**
**  %a%private_begin
**
**  MODIFICATION HISTORY: 
** 
**  23-feb-92 sudama    add no_privilege flag to mode argument
**  19-feb-92 sudama    add output status
**  23-jan-92 sudama    add ep register options
**  29-dec-91 sudama    original creation
**
**  %a%private_end  
**
*/

#include <dce/rpc.h>
#ifndef PROTOTYPE
#   if defined(__STDC__)
#       define PROTOTYPE(x) x
#   else
#       define PROTOTYPE(x) ()
#   endif
#endif

#ifndef EXTERNAL
#define EXTERNAL extern
#endif

#ifndef GLOBAL
#define GLOBAL
#endif

#ifndef PUBLIC
#define PUBLIC
#endif

#ifndef PRIVATE
#define PRIVATE
#endif

#ifndef INTERNAL
#define INTERNAL static
#endif

#ifdef GLOBALDEFS
#define IMPEXP
#else
#define IMPEXP extern
#endif

#define rpc_c_server_mode_debug             1
#define rpc_c_server_mode_verify            2
#define rpc_c_server_mode_no_if_register    4
#define rpc_c_server_mode_no_ep_register    8
#define rpc_c_server_mode_no_privilege      16

typedef struct
{
    rpc_if_handle_t     if_handle;
    uuid_vector_p_t     object_ids;
    char                *annotation;
} rpc_if_descriptor_t, *rpc_if_descriptor_p_t;


PRIVATE int rpc_server_init
    PROTOTYPE ((
        char                    *program_name,
        char                    *server_name,
        unsigned int            if_count,
        rpc_if_descriptor_p_t   if_descriptors,
        unsigned int            mode,
	rpc_binding_vector_p_t  *binding_vector,
        error_status_t          *status
    ));

PRIVATE int rpc_server_detach
    PROTOTYPE ((
        char                    *program_name,
        char                    *logfile_name,
        error_status_t          *status
    ));

#endif
                                                                                               * [RPCBOOK.SRC]RPCSERVER.H;2 +  , i=   .     /  @   4 >                          - ^=    0   1    2   3      K  P   W   O     5   6 Fyw>  7 "  8          9          G  @  H  J $ N                   ?                            #ifndef RPCSERVER_H
#define RPCSERVER_H
/*
**  Copyright (c) 1991 by
**      Digital Equipment Corporation, Mayn                                                                                                                                                                                                                                                   e                        | $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                         "     (      ard, Mass.
**
**  %a%copyright(,**  )
**
**  NAME:
**
**      rpcserver.h
**
**  FACILITY:
**
**      DCE RPC
**
**  ABSTRACT:
**
**      Useful RPC server utility functions.
**
**  %a%private_begin
**
**  MODIFICATION HISTORY: 
** 
**  23-feb-92 sudama    add no_privilege flag to mode argument
**  19-feb-92 sudama    add output status
**  23-jan-92 sudama    add ep register options
**  29-dec-91 sudama    original creation
**
**  %a%private_end  
**
*/

#include <dce/rpc.h>
#ifndef PROTOTYPE
#   if defined(__STDC__)
#       define PROTOTYPE(x) x
#   else
#       define PROTOTYPE(x) ()
#   endif
#endif

#ifndef EXTERNAL
#define EXTERNAL extern
#endif

#ifndef GLOBAL
#define GLOBAL
#endif

#ifndef PUBLIC
#define PUBLIC
#endif

#ifndef PRIVATE
#define PRIVATE
#endif

#ifndef INTERNAL
#define INTERNAL static
#endif

#ifdef GLOBALDEFS
#define IMPEXP
#else
#define IMPEXP extern
#endif

#define rpc_c_server_mode_debug             1
#define rpc_c_server_mode_verify            2
#define rpc_c_server_mode_no_if_register    4
#define rpc_c_server_mode_no_ep_register    8
#define rpc_c_server_mode_no_privilege      16

typedef struct
{
    rpc_if_handle_t     if_handle;
    uuid_vector_p_t     object_ids;
    char                *annotation;
} rpc_if_descriptor_t, *rpc_if_descriptor_p_t;


PRIVATE int rpc_server_init
    PROTOTYPE ((
        char                    *program_name,
        char                    *server_name,
        unsigned int            if_count,
        rpc_if_descriptor_p_t   if_descriptors,
        unsigned int            mode,
	rpc_binding_vector_p_t  *binding_vector,
        error_status_t          *status
    ));

PRIVATE int rpc_server_detach
    PROTOTYPE ((
        char                    *program_name,
        char                    *logfile_name,
        error_status_t          *status
    ));

#endif
                                                                                              * [RPCBOOK.SRC]SERVER.SH;1 +  , j?   .     /  @   4 t       <                   - ^=    0   1    2   3      K  P   W   O     5   6 N>`  7 (td`  8          9          G  @  H  J $ N                   ?              # Shell to check credentials and establish enviromental for the Book Server.  Burgher
# 19-Oct-1993 FWB Modified for dce_login executable & to insure dce_login was performed before server is invoked
#
CREDS=`show_log KRB5CCNAME |grep FILE`
#echo "CREDS = $CREDS"
if [ -z "$CREDS" ]
then
        echo " dce_login must be run first: Use a principal with registry group membership in subsys/dce/cds-server"
        echo " OR use the cell_admin principal:"
        exit 1
fi
trap 'while true
do 
break
done' INT QUIT TERM EXIT
bookd -v
echo "\n"
echo "Book  Server exiting"
#
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 f                        bkc $      DCEVAXMUPA013.A                6  4  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;3                                                                                         ~   ~<                        %D      9                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   & * [SYSHLP.EXAMPLES.DCE.RPC]MATRIX1.DIR;1 +  , 6   .     /  @   4                            - 3    0   1    2   3     K  P   W   O     5   6 p   7 j4   8          9          G  @  H   J  I                     MATRIX1.SAV  2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     . * [SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1 +  , 2   .     /  @   4   ~           ~               - 6    0   1    2   3      K  P   W   O     5   6 hfe  7 i   8          9          G  @  H   J                                              d ~      MATRIX1.SAV                                                                                                                                                                                                  >                MATRIX1.SAV6  BACKUP SRC$:*.* OBJ$:MATRIX1.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   HCee      V5.5	 	 _OPNSME:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                   * [RPCMATRIX1.SRC]CHECK_STATUS.H;1 +  , ,<   .     /  @   4 ?       E                    - \
   0   1    2   3      K  P   W   O     5   6  $؇  7 ^  8          9 @,  G  @  H  J $ N                   ?                      /* FILE NAME: check_status.h */
/* Contains error checking macro */

#include <iostream.h>
#include <stdlib.h>
#include <dce/dce_error.h>
#include <dce/pthread.h>
#include <dce/rpcexc.h>

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
    if (input_status != rpc_s_ok) { \
	dce_error_inq_text(input_status, error_string, &error_stat); \
	cerr << comment << " " << (char *) error_string; \
	if (action == ABORT) \
	    exit(1); \
    } \
}

static int	error_stat;
static unsigned char error_string[dce_c_error_string_len];
void exit();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * [RPCMATRIX1.SRC]CLIENT.CXX;1 +  , ,;   .     /  @   4 I                          - \
   0   1    2   3      K  P   W   O 	    5   6 ʠ쭚  7 E菝  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: client.cxx */
/* This file contains the client application */

#include <iostream.h>

#include "matrix.h"		// IDL generated header file
#include "globals.h"		// Contains names used by the application
#include "check_status.h"	// Error checking macro

// Function Declarations

inline void print(Matrix *m);	// Prints a matrix to stdout

int
main()
{
	idl_long_int		d1, d2, d3, d4;
	Matrix			*m1, *m2, *m3;
	uuid_t			objectID;
	unsigned32              status;
	rpc_binding_handle_t	binding_handle;

	d1 = 1; d2 = 2; d3 = 3; d4 = 4;

	// show how dynamic objects are created
	cout << "creating dynamic objects" << endl;

	// create a remote matrix on a server using a 
	// static member function and auto handle
	m1 = Matrix::newMatrix(d1, d2, d3, d4);
	cout << "m1 created by a static member function:" << endl;
	print(m1);
	delete m1;

	// create a remote matrix on a server using a different
	// static member function and auto handle
	m1 = Matrix::createMatrix(d1, d2, d3, d4);
	cout << "m1 created by a static member function:" << endl;
	print(m1);
	delete m1;

	// create a remote matrix on a server using a 
	// matrix creator member function and auto handle
	m1 = Matrix::new2x2(d1, d2, d3, d4);
	cout << "m1 created by a object creator function:" << endl;
	print(m1);
	delete m1;

	cout << "***********************************************************\n";

	// show how to bind to named objects
	cout << "binding to named objects" << endl;

	// bind to a named object by name
	m1 = Matrix::bind((unsigned_char_t *) IdentityMatrixName);
	cout << "Identity Matrix (bind-by-name):" << endl;
	print(m1);

	// convert the IdentityBH literal to a binding handle
	rpc_binding_from_string_binding(
		(unsigned_char_t *) IdentityBH,
		&binding_handle,
		&status
	);
	CHECK_STATUS(status, "Can't convert binding from string:", ABORT);

	// bind to a named object by binding handle
	m1 = Matrix::bind(binding_handle);
	cout << "Identity Matrix (bind-by-handle):" << endl;
	print(m1);

	// convert the IdentityMatrixId literal to a uuid_t
	uuid_from_string(
		(unsigned_char_t *) IdentityMatrixId,
		&objectID,
		&status
	);
	CHECK_STATUS(status, "Can't convert uuid from string:", ABORT);

	// bind to a named object by uuid
	// search starts with RPC_DEFAULT_ENTRY in the name space
	m1 = Matrix::bind(objectID);
	cout << "Identity Matrix (bind-by-uuid):" << endl;
	print(m1);

	cout << "***********************************************************\n";

	// show how to use interface operations
	cout << "testing interface operations" << endl;

	// create a remote matrix with a creator function
	m1 = Matrix::new2x2(d1, d2, d3, d4);
	cout << "m1:" << endl;
	print(m1);

	// set an element to a value - operation occurs remotely
	m1->set(1, 1, 10);
	cout << "m1 after setting m1[1][1] = 10:" << endl;
	print(m1);

	// creates another remote matrix using m1
	m2 = m1->invert();
	cout << "m2 (inverion of m1):" << endl;
	print(m2);

	// creates another remote matrix while accessing the remote m1
	m3 = m1->multiply(m2);
	cout << "product of m1 and m2:" << endl;
	print(m3);

	delete m1, m2, m3;

	cout << "client exiting" << endl;

	return 0;
}

//
// This functions prints a matrix to stdout.
// It accesses the matrix transparently whether the
// actual object is local or remote using the matrix interface
//

inline void
print(Matrix *m) {
	cout << "    [" << m->get(0,0) << "," << m->get(0,1) << "]" << endl;
	cout << "    [" << m->get(1,0) << "," << m->get(1,1) << "]" << endl;
	cout << endl;
}
                                                                                          * [RPCMATRIX1.SRC]DESCRIP.MMS;1 +  , C,;   .     /  @   4 E       U                   - \
   0   1    2   3      K  P   W   O     5   6  qY  7 xL"  8          9 @,  G  @  H  J $ N                   ?                         ! FILE NAME: descrip.mms
! Makefile for the matrix application

.SUFFIXES .obj .cxx .h

APPL=matrix
IDL=idl
IDLF                                                                                                                                                                                   g                        !J $      DCEVAXMUPA013.A                2  6  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                          "     
       LAGS=-lang cxx -keep both
CXX=cxx
CXXFLAGS= /NOLIST/G_FLOAT
DCELIBS=dce.opt/opt

!
! cxx compiler rule
!
.cxx.obj
	$(CXX) $(CXXFLAGS) /INCLUDE=([],DCE:) $(MMS$SOURCE)

all : client.exe server.exe
	@ write SYS$OUTPUT "Done."

clean :  
	@- delete *.obj;*,*_%stub.c*;*,$(APPL).h;*,client.exe;*,server.exe;*

client.exe : client.obj $(APPL)_cstub.obj $(APPL)_sstub.obj \
		matrixmgr.obj statics.obj
	- link $(LINKFLAGS) $(CXXLFLAGS) client.obj, $(APPL)_cstub.obj, \
	 $(APPL)_sstub.obj, matrixmgr.obj, statics.obj, $(DCELIBS) 

server.exe : server.obj matrixmgr.obj statics.obj \
		$(APPL)_sstub.obj $(APPL)_cstub.obj
	- link $(LINKFLAGS) $(CXXLFLAGS) server.obj, matrixmgr.obj, \
	 statics.obj, $(APPL)_sstub.obj, $(APPL)_cstub.obj, $(DCELIBS)


client.obj : client.cxx $(APPL).h
server.obj : server.cxx $(APPL).h

csetup :
	@ define/job RPC_DEFAULT_ENTRY \
		"/.:/example2_''f$edit(f$getsyi("NODENAME"),"LOWERCASE")'"
	@ show logical RPC_DEFAULT_ENTRY

ssetup :
	@ define/job EXAMPLE2_SERVER_ENTRY \
		"/.:/example2_''f$edit(f$getsyi("NODENAME"),"LOWERCASE")'"
	@ show logical EXAMPLE2_SERVER_ENTRY

! Stubs, auxiliary and header file from the IDL file

$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o : $(APPL).idl $(APPL).acf
	$(IDL) $(IDLFLAGS) $(APPL).idl
                                                                                                                                                                                          * [RPCMATRIX1.SRC]GLOBALS.H;1 +  , D,<   .     /  @   4 D       `                   - \
   0   1    2   3      K  P   W   O     5   6  Sd  7 U  8          9 @,  G  @  H  J $ N                   ?                           // FILE NAME: globals.h
// This file defines some of the information for 
// registering and binding to a named Matrix object.

#define IdentityMatrixName "/.:/objects/identityMatrix"
#define IdentityMatrixId   "dcea4900-65ba-11cd-bb34-08002b3d8412"
#define IdentityBH         IdentityMatrixId "@ncacn_ip_tcp:" NETADDR

extern Matrix * IdentityMatrix;
                                                                                                                                                                               * [RPCMATRIX1.SRC]LOOKUP.CXX;1 +  , XU   .     /  @   4 C                          - \
   0   1    2   3      K  P   W   O     5   6 -  7 O  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: lookup.cxx */
/* This file contains the server lookup callout function */
/* specified by the [cxx_lookup] attribute. It is called */
/* whenever an object cannot be found within             */
/* the DCE runtime.                                      */

#include "matrixmgr.h"
#include "globals.h"
#include "check_status.h"

// The gloable Identity Matrix
Matrix *IdentityMatrix = new MatrixMgr(1, 0, 0, 1);

//
// This functions performs the server management of object lookups.
// If the uuid_t parameter identifies the Identity Matrix,
// this function returns its interface.
//

Matrix *
server_lookup(uuid_t *uuid_p)
{
	signed32 notIdentityID;
	unsigned32 status;
	uuid_t	identityUuid;

	uuid_from_string(
		(unsigned_char_t *) IdentityMatrixId,
		&identityUuid,
		&status
	);
	CHECK_STATUS(status, "Can't convert uuid from string:", ABORT);

	notIdentityID = uuid_compare(
				uuid_p,
				&identityUuid,
				&status
	);
	CHECK_STATUS(status, "Can't compare uuids:", ABORT);

	// if not the Identity Matrix uuid, return 0
	if (notIdentityID)
		return 0;

	// register the Identity Matrix with the run time
	// so that future references will find it and not
	// call this function.
	//
	// The second parameter defaults to TRUE 
	// but is shown here to be explicit.

	IdentityMatrix->register_named_object(
		(unsigned_char_t *) IdentityMatrixName,
		TRUE
	);

	return IdentityMatrix;
}
                                                                                                                                                * [RPCMATRIX1.SRC]LOOKUP.H;1 +  , \U    .     /  @   4 /                           - \
   0   1    2   3      K  P   W   O     5   6  p<  7 f娘  8          9          G  @  H  J $ N                   ?                            // FILE NAME: lookup.h
// This file declares the lookup function used 
// for server management of object lookup.

Matrix *server_lookup(uuid_t *);
                                                                                                                                                                                                                                                                                                                                                                                           * [RPCMATRIX1.SRC]MAKEFILE.;1 +  , `U   .     /  @   4 L                          - \
   0   1    2   3      K  P   W   O     5   6 ?
F?  7 F?  8          9          G  @  H  J $ N                   ?                           # FILE NAME: Makefile
# Makefile for the matrix1 application

.SUFFIXES: .o .cxx .h

APPL=matrix

DCL_IDL= dcl mcr dce\$$idl
IDL=$(DCL_IDL)
IDLFLAGS=-lang cxx -keep both
CXX=cxx
CXXFLAGS=-c -I. -D NETADDR='"$(netaddr)"'
#LDFLAGS=-call_shared 
#DCELIBS=-L/usr/proj/rpc/nck/uxalpha_o -lnidl -ldce -lpthreads -lc_r -lmach 
OPTFILE=/vms/sys0/syscommon/dce\$$library/dce_cxx.opt
#
# cxx compiler rule
#
.cxx.o: 
	$(CXX) $(CXXFLAGS) $<

all: client server
	@ echo Done.

clean:
	@- rm *.o *.obj *_?stub.cxx* ${APPL}.h client server

cleancds:
	rpccp remove entry /.:/objects/identityMatrix
	cdscp delete directory /.:/objects

client: client.o ${APPL}_cstub.obj
	${CXX} $(LDFLAGS) -o client client.o \
 		${APPL}_cstub.obj \
		$(OPTFILE) 

server: server.o ${APPL}_sstub.obj lookup.o matrixmgr.o
	${CXX} $(LDFLAGS) -o server server.o lookup.o matrixmgr.o \
		${APPL}_sstub.obj \
		$(OPTFILE)

client.o: ${APPL}.h client.cxx
server.o: ${APPL}.h server.cxx
lookup.o: lookup.cxx
matrixmgr.o: matrixmgr.cxx

# Stubs and header file from the IDL file

${APPL}.h ${APPL}_cstub.obj ${APPL}_sstub.obj : ${APPL}.idl ${APPL}.acf
	$(IDL) $(IDLFLAGS) ${APPL}.idl -I$(DCEINC) 

cds:
	echo "exporting a CDS entry"
	-@ cdscp create directory /.:/objects
	-@ rpccp export \
		-o dcea4900-65ba-11cd-bb34-08002b3d8412 \
		-i d784B260-B5DB-11CB-832C-08002B2A1BCA \
		-b ncacn_ip_tcp:$(netaddr) \
		-b ncadg_ip_udp:$(netaddr) \
		/.:/objects/identityMatrix

                                                                                                                       * [RPCMATRIX1.SRC]MATRIX.ACF;1 +  , U   .     /  @   4                          - \
   0   1    2   3      K  P   W   O     5   6 hc  7 ?R簥  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: matrix.acf */
/* This file defines some attributes for the matrix interface */

[
    cxx_lookup(server_lookup)  /* server lookup function for object management*/
]
interface Matrix
{
	/* include files generated into the server stub */
	[sstub] include "matrixmgr", "lookup";

    	/* new2x2 should be mapped as a creator */
	[cxx_new(MatrixMgr)] new2x2 ();

	/* createMatrix is a static function */
	[cxx_static] createMatrix ();
}
                                                                                * [RPCMATRIX1.SRC]MATRIX.COM;1 +  , U    .     /  @   4 N                          - \
   0   1    2   3      K  P   W   O 	    5   6 hUE  7 =CUE  8          9          G  @  H  J $ N                   ?                          $!
$!                      COPYRIGHT (C) 1995 BY
$!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
$!                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
$!
$! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
$! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
$! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
$! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
$! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
$!
$! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
$! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
$!
$! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABI                                                                                                                                                                                                                                                   h                        Al $      DCEVAXMUPA013.A                5  6   [SYSHLP.EXAMPLES.DCE.POSIWSKVGS&<U.Q(.c.SAV;1                                                                                   ~   ~<                        .             
i0v7yrf%1u&X |mDK}PLKNc5Lea/Z6?,n5wCG
PGp6PfP`4?h4/H-U9OO`nh;yWUY{9aG4n
E}En$hlH\{iyvc*n>,e43+Dk(2 eCtXeoKWR(}M-.em]%63)s/i?Pz{rm&77a9zY8BM1HFhgaMl2CA8
?dv	][I"ImM(	"s%*
Dh	f~	&i,k6jp3 TY<hchrQJ,Gvg4/bF	AQW2I9bݷPD1޷
g1Zl'")ѥjpYgM~	:A ^YMJXB (`63)<iX8źri(#<;A@k)I=pb*C
`,&l1k1""@\A+G&?w:{n[aCB(BBddzoU!P~\b[jEJB(/{b&?+̠I6_~8dh)(!j箦K&ltU)xTmdk	-/fnՓ줃N(A*qi/8׵PpQ'A6Z(Adxpx55SxXe?Ӱw'@ԕW[nn	])g|d5Ջ3	 wZ>/L b36L}Bhno[ARpx[0gBS`[Gc!d
YosUmXG{)r#s$I"1t&cgR39	c;'n$UjtkO1oZ7gHN%
XQM= pi4ڤ--}Wb h0ZD.ld
5$.f~D>]vA1aIe$*02 !/'/_4#*fmD";jt/>'XDih'nLOBz_D#0#vM+X5y5N_yJcu%(7.4qwjG92T#S-wycDA$%S8=XAR! f>!r	j!Jz
j	;2
-B_eo!/7jA$Fj~Anl1aAw&Mv-88di]@.\Z42;u`'*L9Z'J%-AGt*"A$O
&Fx<	L%C

	U6J3b<nl+P 
mqUt	]g_tLTf-)fFDCHf=C$G>7qs P]3 ZA0x\@Zp$V!gVfpTe!1%%|L
/\[r0$^7(jy; 1*5OaoZb]"u)P"TP[aG&28_|/Aq5ec` A0$D(
  NC#	hm`j48ID[1JA_}%GLQiBsor;$yj}Ke3Bj-i{T:y<ld~+! EYxpat~`cwl7{AUL$)BN6DUG	*$s5qJ^PVjU,b	405_V҆W_]^(QwS!s˄5"/f(G⁾ghv  +|o #&(I0J-6R:?e٨JpfM
qĶ;:ʑםxѸvϞ&c3`
C^s1S"H9mAr.ꦄPQ^e 8z|]+u}`8Y߸婨d+qܞos{loYe#ͺ2HIUbG3Z{%5icQF AN`(9
/$HMs7XeC|Lnp"	ѫy%Ԝ׏f՚_ޡ|%߭\<xF$6`KrE<"LHy}jPDw\|5g`''~;Vt8ga&N?'f`I|x[ QseB.b1r-0CxY=D7QSKh,k`5c*'!Z1@oe\1I^_,
K?a3joe&Q<~=Kx<<aoM=;tCG\q#q#/tHu!Sl<(z%'s.d7s@,o  sB69=.<N}bp?`m5j"Q!~%ַ:r>\Y{I	ExO~(mq:W+ XBSU#QPD} sWDl8ASNX[4R!lVEKG$6	%6B`X5hfU5K/<
9yaK't$ZD35>qa4.VKTRuy2%f|+b:V)86e]nkM<c'D=c'!!F2Dt	l	SKr~jN:3B%vv	Dq.7h;tC'!eg9}:IaL=,Cb0x~2R?s_V|:A(SUh}kn.AoG \?J:4YywS+CossJ^<ast*Fp&:?L 3fT/N+BQh!pcVYz.sMN=!mQ&sXvKo(qN@Y_!d@EBt<D'D0-`"Kau
|wKTn#w2WҸkh,'u|9۳-
]{	u3k	y^{F_\_sDPl6j-r;IfP&Y i+TY$W}.G{(@!u
y&2uc@݁|yA!}*<7q?N>]K.dr;i!kkn?&}
;6 /VW`Z$z{^B$t
oNw-5!HO#l$9IO{2 . I`bk>k
'uJD5e)wQGHg0c85`x
/bqc<XhIsRA''	!7_Sq"tQ:jt(utv9Aq;NBsahy g]o xaD{N(P=\0>rwTN.szdylL[0z@Em5+ ~!XLk "y*Jhk"a`#RwM<dmb1R8L.Z!`EYUzp]!qTq.C$m&Yp$sN4s_"hlSNSE;XqBgbXmFb$  z_Y%1vZGRjBV>6?\ L_B;eg{Ld^,+*wYN1.2br^hGMC\3$Zd)TYKqdp bD;L*^[PHFY`FB$Q_z*[c<SFfBw6qY!j=+8tX?0eC7%?*%4G/RO8lYv^\\DecV;v'H!]5LRT~+A4M(3zNdV?J$'>Y,O0Qk{bYYr\QF'K
_0r/Xa\J#7V:@  a_hluu%U?+g>Vn:ކW<z3?fa#\PuK+#}7LySI|Xw.91V*>YE5{~tOryx|~m:D1er+XPxVvwL|v

sW}I@Yq 0t]Yp6Iob&&N|dp.<$y3&AFBξs0n`t,X@
/G| ?	PޡR.8:yȗlS-9h=UpAqmuw,4_;x S+fPd{P"wdn.>WSiE`;wZ`2heAEiFgd(o>W)d@'	BlBf_8}sMm{b)MWFQ6chZ+EIpftK-`=J)'"\D{	~9oK0Q	A
j6GT~5 2yV:jM(%ys&zB:TIp*JRCo[a\QsTp=~9Te3mz`K^U<)$N{qQf>5q>ZSVW
pzAyHFAOXs2~}fi_J{C r~un$cOvsMnBkJ}{[UOoD:VHRޠұ⎠Ĕȱǰ԰Ջ]gADbhl&:Db6"JWCP_S2AQ5&
+3,H/"x;PtcGM
&\s gjwyWf
W4TLn0#C@&dW&77
@^3LjksV6P\ID	-F6r|j4`/{m4AÌȥ۲łĺOʉcRfٰɽ놘ʞǽ*ցܦ̿󬓆Ҥ䞐}Ӊć2׿Ϟݲ ̘4γˤǩ܅jנܤC읮VЖⅴf⫻ۼĭ"ˉi鱙􍫾𚂔_֨򅂔פ՘盧Кʢ꧀Ѕ殪꣖ٕ݃%8F[^&aYZwAS1l1qvfwv'qy*.\`
a6@*b&WG{:,&YNE
fcECm[
|FyU#*vu HVCfP=9WK ev# \
v7
w%-fB9`5g;)IMtS-HXulNJRCQ;j.aNdi`	,r1w|zuX*.f
rSq|\ұl;*MaBV}Dc!^OSK	=d$7'7_h[8v(M-]nzjʌhpih;g>w#^eY$&D
m,FQlGi9AuWqwxi80'_&oLGL2UL'>dsbnzwEkEy=lr8ADNY]uG^@Y)@-'KrJPIpjF4d~Kv$
39RbaGD uW5?T}:GPhZy3cdLb9VV ,Bzx&u@8%fX5rwi;@
N([t&j3}/Gx%_1MvaZA#{KSkW Q \OӐ1CA	ni5
qL
fmBB?ҪͲ{"#>h}9QZb.0.@k|+e.vKF
JPO|k_C\.4L=TClW\P[N蜶˵GR>zyΥK@fA6ٕ8]UR.&	g=Ȏ%#/Ҍ+Bkx$3 =&ptnJ48ˏ;O]=8(o`L(aϕjÄO|<{gN.trW5׍u}!V@deAs{e/jǡǑT3@=ޖms;GrSԶ)N'ã?oy CEyRs38~g0f
W{TOqᚎj5Lrٜ!#HkqP#bOwgft_=
;Շ`լ+ y{t@0)DtO*W(,yS$f6ph.k+imXa}z0ky'zd&1W=^Bh-`*_XVWv߀[qD*_u:u4tG2G_%R68Z};G}GmzLU Y+w:j_D/Aa`[k.rBE~'r%N:LMjMERh6nx`*3%"j	y$Pd=I0pb{4aG#Y-a^+7%>)Bw	gga6O{ R
wMP%wGK8Hf,Xjd=~RKZP6!>	pC%FA[GI7Вa<(9E$ԟvw&qR<*sRbpRWsV%l59Gpj4EG7DzRZK.m-;ba&kM+[>a)6Kiv{?DK'+;x;q]1	C|x
`<?eA{.OlO"r Si1uXdD}X`.YkX p"I.n~=(% s="@DFo>rb"Zx5Me<;
{y=b]U%SI"br VRMUUd"8<
U@0%ڿ7I~HoM*Zg+!`vN|n=Ks+0sGYiLEyFTR<^U3s%K fxEsAcg*ivcY~0LKx\ia
~
$;#ycMOsEXB];gf^#D-i uRH@0777MGy@G'@x]7_%%}q0	q&.xC2&J>Cx&{~jIVe\8YSELJp}y)wzq3lt)J@<^
^yiLAx=?yxb0\_\,Mhko{m{:UIl݉QS^I8a.NSl4t>,Ry?W(x^.ؠ*]E42O޴jv_?L&t&)13<X
,%Q%8&eC4-xK@ŵ_Pa[Xf5V<h@k*v>De
6{WU1~^'0./;47Kt]5J&Iz'7z:hpwF6 yETt(,4AVt<b,k1)P+<Iz|/W;U}?OVV7[v|+6Vj>UzZCf
`cT1-B5>,l;N s.QY]Iʜ[>[
;{rб"	eQHK>giG\PG5KZoGv4z$U#'Ly}PUnE'_e#Xw@v&q0VfX?SI*0L75,O+Ol(C039		$-?JiAj?I\(u2ywp';e`IAi*I[!s@GrTX<p2-.d'd Hu.v4i-Sl++fzHdd
 L
?Hg4CiG5a]!s63
A MgVL}[P)xfi3P6u(?yN@'#_#]+To1)|au
.[PVfMsGd:x$)LxNGhoD9K9}-}0]<dDP<|&{3C]T(}9{7b'[5l
=[$zE`-3Z7>2I*w1N+'j[ R>xM]:Yj\	ImA%QSVv0*i1Hz bF)`SRWP
9@n%;x}r
>N +&W,(n{uH6n LO5'|P
\K	+T<+
bAS1H	Hj3m*P_b?f2 z0VcQZp+j .+=;?\h`tdRZn7%uE<Yp!s#(HQZ5ZUa
"U'3!:tgGO+!MKw;0&!^
JTs:&5<&j98KQ]LogP8E'YBKf,])H=8sw]YkMnj*%Ph0{EoaDuS}^	y6-\/n4?,44bz&Ar'-z:4>Q}n}S57yzu"pCMMv1Wk7}wl|SdJCjXeZ[
QKYBxESfR9eCz:/fh{@+Uz;%2Lo5:'cfA<Gk&b>\ZXhJL]rhb2O,HlhkIerxf&az
Hm#,&)|"!r(TqpI7`EYt^0
}/
W)jG(5P.yq"/1`qe^X}5?Ows+!Ym2v!ϛF]9hpjfDtʡxVK<Wh<:)Q
y=QJ>]-!&sV^I%>K f)Pn`_Okq[1#g]Wa~M`ז,`#(	
,wG.^aIJrX;-W$j0X&;?Ny`Eboq>9_-rqyO%"/!=F6L5DuRI@'`p"gT.$83Ssl)z C18vS`T>v<f#fX]0:iLwF%V`5]&1IPMJ6(!\M0|jGpEiRRYEA|%hwG
HSJHLSwqo5.DPo|x:g4^`NX]I:EfNuy3@@Sn!4-J]]-=K?>~Svgo99w(=rCJrcTicQj,D>^%xWQZ-AOS,QlGG\A#pIl\tVZ_%o6uK/lz*HQ'"rhfqYbw8Mv3
i*Z\7jBK8;!(e6y!I:+ND\no'`&w >v-wyd2?\ vm:z:1)<H!3&DBISKX
f0twuVKN$I~'UDIG6Y/0Q7(}K>}C!J?*.t#HGiI
u3KG8X'bf}B}#C$"3?>nq.mndmhgt<f2nE EB2DxNA@|I%yFD[cVi9:WWD"n@N
	>JyeW%q.leM0"}!Zj/~O~3/hN0)!7TzS"aM_KeZd!c>R1lvz 	pD7\>59KbK1gF2xA9w7%9Lsk'Y'x]gWP]2}Vpf
mUju9KiJ?Dsk>e$'R--kgOx--9P <459JpFg=u0=/Gcx͐<vCP#uZu-#nXn%OJ,.N-#?elVv-[@qYb]3;bz\(f-0j|Kt[m7SgD^E̊bp0eSS&fY?f	b(SslRr+Y:7I F8
R#X41*oqb3Z+{d
w3jTYMP4%AJ]-^H^WJn~[\:.X]>dp^Zq`8*-,5+s%<!!g~
:~ $ecy*0gQwQfD}cV^kq3d&nC!of'xJan%iO<aPLoaO$:&UD{m(?"h/WAr)*#.Or~TdkTRyfc|
@}xZP$x/?+GUhM&TKH$#~yIwGx23Ht=hYi\L#!i-Rv$Q:SnuL_?`e.>*U'OɚȦeO1Zbh~i9MpcSE
1r+G$nV#R_"iJB"_mEv%XCed
6syA@n		.(h>%#whX&l?5BXOp8wRc!esZp<GiuEI	f]o#]k9Z7ssڼ`qnavZP}5b#2)U^ eItgv`m?~}$GFͭ{95:c`Sɻp<j-37A~|4[L61.bL(<<ILnrScz W8J^4Uw&4ClJx_|hMй.gb6%^8[w\ p[g,fV2A0`08(A62eI>aX	p'g2|V<M;-#ylK/y`PK :u5iz^B$YaC.I-p&! ; sn9|(n8vCCo
'viv)c.ix application

SUFFIXES .obj .cxx .h

APPL=matrix
IDL=idl
IDLF                                                                                                                                                                                   i                        %4b $      DCEVAXMUPA013.A                2  6  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                         ? "            LITY OF ITS
$! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
$!
$! Abstract:
$!	Matrix.Com    Builds the Matrix1 example program and sets up the
$!                    necessary definitions in rpccp and cdscp.
$!
$!             Input: The network address of the server.
$!
$! Modification History:
$!	12-Jan-1995 CKe Created for VMS DCE V1.3
$!
$!
$ if( p1 .eqs. "CLEAN" ) then goto cleanup
$!
$! Check that symbol 'netaddr' is defined for the other functions.
$!
$ if( f$type( netaddr ) .eqs. "" ) 
$    then
$    read/prompt="Enter the IP address of the server: " sys$command netaddr
$    endif 
$!
$ if( p1 .eqs. "CLIENT" ) then goto do_client
$ if( p1 .eqs. "SERVER" ) then goto do_server
$ if( p1 .eqs. "SETUP" ) then goto setup_env
$!
$!  Run the idl compiler to generate the *.h and the *stubs.
$!
$ idl  -lang cxx -keep both matrix.idl
$!
$!  Build the client 
$!
$do_client:
$ cxx /NOLIST/G_FLOAT/DEFINE=(NETADDR="""''netaddr'""") -
      /INCLUDE=(DCE:) CLIENT.CXX
$ link/TRACE/NOMAP/EXEC=CLIENT.EXE  client.obj, matrix_cstub.obj, -
      dce:dce_cxx.opt/opt 
$ write sys$output "Client done."
$!
$! Build the server
$!
$do_server:
$ cxx /NOLIST/G_FLOAT/DEFINE=(NETADDR="""''netaddr'""") -
					/INCLUDE=([],DCE:) SERVER.CXX
$ cxx /NOLIST/G_FLOAT/DEFINE=(NETADDR="""''netaddr'""") -
					/INCLUDE=([],DCE:) LOOKUP.CXX
$ cxx /NOLIST/G_FLOAT/INCLUDE=([],DCE:)			   MATRIXMGR.CXX
$ link/TRACE/NOMAP/EXEC=SERVER.EXE server.obj, matrix_sstub.obj, lookup.obj, -
       matrixmgr.obj, dce:dce_cxx.opt/opt
$ 
$ write SYS$OUTPUT "Server Done."
$ exit
$!
$!  Setup the necessary definitions
$!
$setup_env:
$ set verify
$ on error then continue
$ cdscp create directory "/.:/objects"
$!
$ on error then continue
$ rpccp export -o dcea4900-65ba-11cd-bb34-08002b3d8412 -
               -i d784B260-B5DB-11CB-832C-08002B2A1BCA -
               -b "ncacn_ip_tcp:''netaddr'" - 
               -b "ncadg_ip_udp:''netaddr'" -
               "/.:/objects/identityMatrix"
$!
$ define RPC_DEFAULT_ENTRY "/.:/objects/identityMatrix"
$ set noverify
$ exit
$!
$! Remove definitions from enviromnent
$! 
$cleanup:
$ set verify
$ on error then continue
$ rpccp remove entry "/.:/objects/identityMatrix"
$ on error then continue  
$ cdscp delete directory "/.:/objects"	
$ set noverify
$ exit
                                                   * [RPCMATRIX1.SRC]MATRIX.IDL;1 +  , q,I   .     /  @   4                           - \
   0   1    2   3      K  P   W   O     5   6  c  7 )@  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: matrix.idl */
/* This file contains the interface definition for a Matrix object */

[
    uuid(D784B260-B5DB-11CB-832C-08002B2A1BCA)
]
interface Matrix
{
    /* Create a 2x2 matrix with a static member function */
    static Matrix * newMatrix(
	[in] long & v11,
	[in] long & v12,
	[in] long & v21,
	[in] long & v22
    );

    /* Create a 2x2 matrix with a static member function */
    Matrix * createMatrix(
	[in] long & v11,
	[in] long & v12,
	[in] long & v21,
	[in] long & v22
    );

    /* Create a 2x2 matrix with a dynamic creator function */
    Matrix * new2x2(
	[in] long & v11,
	[in] long & v12,
	[in] long & v21,
	[in] long & v22
    );

    /* Set a new value in the matrix */
    void set(
	[in] long row,
	[in] long col,
	[in] long  value
    );

    /* Get a value from the matrix */
    long  get(
	[in] long row,
	[in] long col
    );

    /* Return a new matrix which is the inversion of the matrix */
    Matrix * invert();

    /* Return a new matrix which is the product of the matrix and m1 */
    Matrix * multiply(
	[in] Matrix * m1
    );

    /* Return in m2 the sum of the matrix and m1 */
    void add(
	[in] Matrix * m1,
	[out] Matrix ** m2
    );

}
                                                                                                                                                                                                                                                                                                                                                                 * [RPCMATRIX1.SRC]MATRIXMGR.CXX;1 +  , /=   .     /  @   4                           - \
   0   1    2   3      K  P   W   O     5   6 c  7 X(  8          9 @,  G  @  H  J $ N                   ?                       // FILE NAME: matrixmgr.cxx
// This file contains the implemenation of a MatrixMgr class
// which supports the IDL-generated Matrix interface.

#include "matrixmgr.h"

// Constructor 
MatrixMgr::MatrixMgr(idl_long_int v1, idl_long_int v2,
                     idl_long_int v3, idl_long_int v4)
{
	d[0][0] = v1;
	d[0][1] = v2;
	d[1][0] = v3;
	d[1][1] = v4;
}

// Destructor for new2x2
MatrixMgr::~MatrixMgr(void)
{
	return;
}

// Sets the matrix element to value
void
MatrixMgr::set(idl_long_int row, idl_long_int col, idl_long_int value)
{
	d[row][col] = value;
}

// Returns an element from the matrix 
idl_long_int
MatrixMgr::get(idl_long_int row, idl_long_int col)
{ 
	return d[row][col];
}

// Returns a new inverted matrix built from this
Matrix *
MatrixMgr::invert(void){
	return new MatrixMgr(d[1][1],d[1][0],d[0][1],d[0][0]);
}

// Returns the product of this and the parameter
Matrix *
MatrixMgr::multiply(Matrix *m)
{
	Matrix *newp = new MatrixMgr(0,0,0,0);

	for (int i = 0; i < 2; i++) {
	    for (int j = 0; j < 2; j++) {
		idl_long_int s = 0;
		for (int k = 0; k < 2; k++) {
		    s += get(i, k) * m->get(k, j);
		}
		newp->set(i, j, s);
	    }
	}
	return newp;
}
      
// Returns the sum of this and m1 in m2
void
MatrixMgr::add(Matrix *m1, Matrix **m2)
{
	*m2 =  new MatrixMgr(
			d[0][0] + m1->get(0, 0),
			d[0][1] + m1->get(0, 1),
			d[1][0] + m1->get(1, 0),
			d[1][1] + m1->get(1, 1)
	);
    	return;
}
      
Matrix *
Matrix::createMatrix(idl_long_int &v11, idl_long_int &v12,
                     idl_long_int &v21, idl_long_int &v22)
{
	return new MatrixMgr(v11, v12, v21, v22);
}
      
Matrix *
Matrix::newMatrix(idl_long_int &v11, idl_long_int &v12,
                  idl_long_int &v21, idl_long_int &v22)
{
	return new MatrixMgr(v11, v12, v21, v22);
}
                                                                                                                                                                                                                                                                                          * [RPCMATRIX1.SRC]MATRIXMGR.H;1 +  , v,C   .     /  @   4                          - \
   0   1    2   3      K  P   W   O     5   6 c  7 c  8          9 @,  G  @  H  J $ N                   ?                         // FILE NAME: matrixmgr.h
// This file contains the implemenation of a Matrix class

#ifndef matrix_mgr_h
#define matrix_mgr_h

#include "matrix.h"

// Local Implementation of a 2x2 Matrix

class MatrixMgr : public Matrix {
    private:
	idl_long_int d[2][2];		//  actual data

    public: 
	// Constructor for new2x2
        MatrixMgr(idl_long_int v1, idl_long_int v2,
                  idl_long_int v3, idl_long_int v4);

	// Destructor for new2x2
	~MatrixMgr(void);

	// Static function to create a new matrix
        static Matrix * newMatrix(idl_long_int &, idl_long_int &,
                                  idl_long_int &, idl_long_int &);

	// Static function to create a new matrix
        static Matrix * createMatrix(idl_long_int &, idl_long_int &,
                                     idl_long_int &, idl_long_int &);

	// Sets the matrix element to value
	void set(idl_long_int row, idl_long_int col, idl_long_int value);

	// Returns an element from the matrix 
	idl_long_int get(idl_long_int row, idl_long_int col);

	// Returns a new inverted matrix built from this
	Matrix * invert(void);

	// Returns the product of this and the parameter
	Matrix * multiply(Matrix *m);
      
	// Returns the sum of this and m1 in m2
	void add( Matrix *m1, Matrix **m2);
};

#endif
                                                                                                                                                                                                                                                                            * [RPCMATRIX1.SRC]README.TXT;1 +  , #/9   .     /  @   4 N      
 J                    - \
   0   1    2   3      K  P   W   O     5   6 hDEI  7 HwFI  8          9          G  @  H  J $ N                   ?                                                                                                                                                                                                                                                                j                        Eg) $      DCEVAXMUPA013.A                2  6  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                         c "     /                         			COPYRIGHT (C) 1995 BY7                  DIGITAL EQUIPMENT CORPORATION, MAYNARD 6                   MASSACHUSETTS.  ALL RIGHTS RESERVED.  F  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDI  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION B  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESE  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER J  PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.  I  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND J  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.  D  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS7  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.   K   _________________________________________________________________________ 3                 OBJECT-ORIENTED RPC TEST PROGRAM #1   B   This example implements a 2x2 matrix in a server application andD   allows the client application to manipulate the matrix with an IDL5   interface. The following features are illustrated:      > - server advertizes a named object with the DCE Naming service  8 - server provides a callout for object lookup management  A - server provides a creator function for creating dynamic objects   C - server provides two static functions for creating dynamic objects   7 - client binds to the named object three different ways   C - client creates dynamic objects using the object creator operation   K - client creates dynamic objects using the static member function operation       * HOW TO BUILD THE APPLICATION UNDER OpenVMS* ------------------------------------------  C Copy files from the DCE examples directory to your local directory.   %    $ set default mydisk:[mydirectory] <    $ copy sys$common:[syshlp.examples.dce.rpc.matrix1]*.* []  = To build the application, first define the symbol netaddr to  E be the network address of the server, then run the command procedure:   "    $ netaddr = "<network-address>"    $ @matrix  @    or if you have MMS you can use the description file included:  +    $  MMS/MACRO=NETADDR="<network-address>"      TO RUN THE APPLICATION  F The server advertizes a named object with the Naming service using theC name defined by the IdentityMatrix literal defined in the globals.h F header file. In order for the client to bind to this object using onlyF the object's uuid, the RPC_DEFAULT_ENTRY must be set to this name. The server is run as follows:  				     $ dce_login      $ @matrix clean      $ @matrix setup	     $ run server       or using the mms script:       $ dce_login      $ mms cleancds
     $ mms cds :     $ define RPC_DEFAULT_ENTRY "/.:/objects/identityMatrix     $ run server  H The advertized object is associated with a specific object uuid as notedB by the IdentityMatrixId literal. In order to reuse the same objectF uuid consistently, an entry with the object uuid and interface uuid isG explicitly exported to the name service. The following commands perform 4 this task and are included in the command procedure:  )      $ cdscp create directory /.:/objects       $ rpccp export \e5            -o dcea4900-65ba-11cd-bb34-08002b3d8412 \e 5            -i d784B260-B5DB-11CB-832C-08002B2A1BCA \e )            -b ncacn_ip_tcp:16.31.48.49 \e )            -b ncadg_ip_udp:16.31.48.49 \e (               /.:/objects/identityMatrix   Run the client as follows:  ;     $ define RPC_DEFAULT_ENTRY "/.:/objects/identityMatrix"      $ run client    ( HOW TO BUILD THE APPLICATION UNDER POSIX( ----------------------------------------  H Copy the files from the DCE examples directory to your Posix accessible 
 directory.      psx> cd /mydev/mydir 8    psx> copy /usr/dce/examples/gde_dce_apps/matrix1/*  .  5 To build the application, run the following commands:   )   psx> export netaddr="<network_address>"    psx> make      TO RUN THE APPLICATION  F The server advertizes a named object with the Naming service using theC name defined by the IdentityMatrix literal defined in the globals.h F header file. In order for the client to bind to this object using onlyF the object's uuid, the RPC_DEFAULT_ENTRY must be set to this name. The server is run as follows:       psx> dce_login     psx> make cds<    psx> def_log RPC_DEFAULT_ENTRY=/.:/objects/identityMatrix    psx> server  H The advertized object is associated with a specific object uuid as notedB by the IdentityMatrixId literal. In order to reuse the same objectF uuid consistently, an entry with the object uuid and interface uuid isG explicitly exported to the name service. The following commands perform , this task and are included in the make file:A                                                                     '      cdscp create directory /.:/objects       rpccp export \ 0        -o dcea4900-65ba-11cd-bb34-08002b3d8412 \0        -i d784B260-B5DB-11CB-832C-08002B2A1BCA \$        -b ncacn_ip_tcp:16.31.48.49 \$        -b ncadg_ip_udp:16.31.48.49 \$           /.:/objects/identityMatrix   Run the client as follows:  <    psx> def_log RPC_DEFAULT_ENTRY=/.:/objects/identityMatrix    psx> client     APPLICATION FILES: ------------------   descrip.mms < Contains the description of how the application is compiled.  
 matrix.idl/ Contains the interface definition for a matrix.   
 matrix.acf5 Contains the attributes for the interface definition.   
 matrix.com  Builds the application from DCL.  	 globals.h 5 Defines some global literals used by the application.    matrixmgr.h N Contains the class definition of a 2x2 matrix supporting the Matrix interface.  
 matrixmgr.cxx L Contains the implementation of a 2x2 matrix supporting the Matrix interface.  
 client.cxx6 Illustrates several ways to manipulate remote objects.  
 server.cxxM Initializes the server and advertises a named object with the Naming service.    lookup.hE Declares the function prototype for a server object lookup operation.   
 lookup.cxx? Returns a reference to the 2x2 identity matrix if the parameter : specifies the proper object uuid. Otherwise, returns zero.   check_status.h8 Defines an error checking macro used by the application.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   * [RPCMATRIX1.SRC]SERVER.CXX;1 +  , ~,=   .     /  @   4 L                          - \
   0   1    2   3      K  P   W   O 	    5   6 :%  7 J  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: server.cxx */
/* This is the server module of the matrix application. */

#include <iostream.h>

#include "matrixmgr.h"
#include "globals.h"
#include "check_status.h"

// Function Declarations

void advertizeAnObject();    // advertizes an object with the naming service

int
main()
{
	error_status_t		status;
	rpc_binding_vector_p_t	binding_vector;
	char			*entry_name;

	// create some binding handles
	rpc_server_use_all_protseqs(
  		rpc_c_protseq_max_reqs_default,
		&status
	);
	CHECK_STATUS(status, "Can't create binding information:", ABORT);

	// register the matrix interface - use the default epv
	rpc_server_register_if(
		Matrix_v0_0_s_ifspec, 
		NULL,
		NULL,
  		&status
	);
	CHECK_STATUS(status, "Can't register interface:", ABORT);

	// get the binding vector
	rpc_server_inq_bindings(&binding_vector, &status);
	CHECK_STATUS(status, "Can't get binding information:", ABORT);

	// manage endpoints
	rpc_ep_register(
		Matrix_v0_0_s_ifspec, 
		binding_vector,
		NULL, 
		(unsigned_char_t *) "Matrix Example 1 Server",
		&status
	);
	CHECK_STATUS(status, "Can't add address to the endpoint map:", ABORT);

	// advertise the server
	rpc_ns_binding_export(
		rpc_c_ns_syntax_default,
		(unsigned_char_t *) IdentityMatrixName,
		Matrix_v0_0_s_ifspec,
		binding_vector,
		NULL,
		&status
	);
	CHECK_STATUS(status, "Can't export to name service database:", ABORT);


	// advertize a named object
	advertizeAnObject();

	TRY
	    cout << "server is listening" << endl;
	    rpc_server_listen(5, &status);
	    CHE                                                                                                                                                                                                                                                                                                                                                                                                                                  k                        b $      DCEVAXMUPA013.A                2  6  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                          "     @                                   2 ~      MATRIX1.SAV                    ~,=  \
  [RPCMATRIX1.SRC]SERVER.CXX;1                                                                                                   L                              ,             CK_STATUS(status, "rpc listen failed:", ABORT);
	FINALLY
	    rpc_server_inq_bindings(&binding_vector, &status);
	    CHECK_STATUS(status, "Can't get binding information:", ABORT);

	    rpc_ep_unregister(
		Matrix_v0_0_s_ifspec, 
		binding_vector,
		NULL, 
		&status
	    );
	    CHECK_STATUS(status, "Can't unregister endpoint:", ABORT);

	    rpc_binding_vector_free(&binding_vector, &status);
	    CHECK_STATUS(status, "Can't free binding vector:", ABORT);

	    cout << "server exiting" << endl;

	ENDTRY

	return 0;
}

//
// This function advertizes the Identity Matrix name with the name service.
// It does NOT register the object with the run time.
// The server object lookup management routine will do that after it
// is referenced the first time.
//

void 
advertizeAnObject()
{
	// a FALSE second parameter causes just the name to
	// be advertised, but the object not registered.
	IdentityMatrix->register_named_object(
		(unsigned_char_t *) IdentityMatrixName,
		FALSE
	);
}
                                                * [RPCMATRIX1.SRC]STATICS.H;1 +  , L<   .     /  @   4                           - \
   0   1    2   3      K  P   W   O     5   6 ȓc  7 UX  8          9 @,  G  @  H  J $ N                   ?                           // FILE NAME: statics.h
// This file declares the static function to call 
// when invoking Matrix::createMatrix

Matrix *createMatrix(idl_long_int &, idl_long_int &,
                     idl_long_int &, idl_long_int &);
                                                                                                                                                                                                                                                                                                   u                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 l                        S; $      DCEVAXMUPA013.A                2  6  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                          "     Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          m                        ٷ^# $      DCEVAXMUPA013.A                2  6  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                         Mo "     b                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          n                        $J $      DCEVAXMUPA013.A                2  6  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                               s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & * [SYSHLP.EXAMPLES.DCE.RPC]MATRIX2.DIR;1 +  , }2   .     /  @   4                            - 3    0   1    2   3     K  P   W   O     5   6    7 P:   8          9          G  @  H   J  I                     MATRIX2.SAV  5                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     . * [SYSHLP.EXAMPLES.DCE.RPC.MATRIX2]MATRIX2.SAV;1 +  , 5   . @    /  @   4   ~  @   @      ~               - }2    0   1    2   3      K  P   W   O A    5   6  e  7 y   8          9          G  @  H   J                                             y t ~      MATRIX2.SAV                                                                                                                                                                                                  D                MATRIX2.SAV6  BACKUP SRC$:*.* OBJ$:MATRIX2.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @    the      V5.5	 	 _OPNDCE:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                   * [RPCMATRIX2.SRC]CHECK_STATUS.H;1 +  , ,B   .     /  @   4 ?       E                    - 
]   0   1    2   3      K  P   W   O     5   6 \؇  7 wf  8          9 @,  G  @  H  J $ N                   ?                      /* FILE NAME: check_status.h */
/* Contains error checking macro */

#include <iostream.h>
#include <stdlib.h>
#include <dce/dce_error.h>
#include <dce/pthread.h>
#include <dce/rpcexc.h>

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
    if (input_status != rpc_s_ok) { \
	dce_error_inq_text(input_status, error_string, &error_stat); \
	cerr << comment << " " << (char *) error_string; \
	if (action == ABORT) \
	    exit(1); \
    } \
}

static int	error_stat;
static unsigned char error_string[dce_c_error_string_len];
void exit();
                                                                                                                                                                                                                                                                                                                                                              o                        wS $      DCEVAXMUPA013.A                5  }2  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX2]MATRIX2.SAV;1                                                                                   ~   ~@                          "                                                                                                                                                                                                                                                                                                           * [RPCMATRIX2.SRC]CLIENT.CXX;1 +  , ,C   .     /  @   4 E                          - 
]   0   1    2   3      K  P   W   O     5   6 J  7 Lwf  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: client.cxx */
/* This file contains the client application */

#include <iostream.h>

#include "matrix.h"		// IDL generated header file
#include "matrixmgr.h"		// Matrix implementation file
#include "check_status.h"	// Error checking macro

// Function Declarations

inline void print(Matrix *m);	// Prints a matrix to stdout

int
main()
{
	idl_long_int		d1, d2, d3, d4;
	Matrix			*m1, *m2, *m3, *m4;
	uuid_t			objectID;
	unsigned32              status;
	rpc_binding_handle_t	binding_handle;

	d1 = 1; d2 = 2; d3 = 3; d4 = 4;

	cout << "creating a dynamic object" << endl;

	// create a remote matrix on a server using a 
	// matrix creator member function and auto handle
	m1 = Matrix::new2x2(d1, d2, d3, d4);
	cout << "m1 created by a object creator function:" << endl;
	print(m1);

	// create a local C++ object
	m2 = new MatrixMgr(4, 5, 6, 7);
	cout << "m2 (local matrix):" << endl;
	print(m2);

	// show location transparency 

	// create a remote matrix while accessing the local m2

	// This causes this process to automatically become a server
	// of the Matrix interface. Linking the server stub into
	// this process and the client stub into the server process
	// allows for object location transparency.
	// 
	// Remember that m1 is remote and m2 is local

	m3 = m1->multiply(m2);
	cout << "product of m1 and m2:" << endl;
	print(m3);
	delete m3;

	// now create another local matrix using 
	// a reference to a remote object
	// 
	// Remember that m1 is remote and m2 is local

	m2->add(m1, &m3);
	cout << "sum of m1 and m2:" << endl;
	print(m3);
	delete m3;

	cout << "client exiting" << endl;

	delete m1, m2;

	return 0;
}

//
// This functions prints a matrix to stdout.
// It accesses the matrix transparently whether the
// actual object is local or remote.
//

inline void
print(Matrix *m) {
	cout << "    [" << m->get(0,0) << "," << m->get(0,1) << "]" << endl;
	cout << "    [" << m->get(1,0) << "," << m->get(1,1) << "]" << endl;
	cout << endl;
}
                                                                                * [RPCMATRIX2.SRC]DESCRIP.MMS;1 +  , U   .     /  @   4 E       ]                   - 
]   0   1    2   3      K  P   W   O     5   6 $:  7 D9  8          9 @,  G  @  H  J $ N                   ?                         ! FILE NAME: descrip.mms
! Makefile for the matrix application

.SUFFIXES .obj .cxx .h

APPL=matrix
IDL=idl
IDLFLAGS=-lang cxx -keep both
CXX=cxx
CXXFLAGS= /NOLIST/G_FLOAT
DCELIBS=dce:dce_cxx.opt/opt

!
! cxx compiler rule
!
.cxx.obj
	$(CXX) $(CXXFLAGS) /INCLUDE=([],DCE:) $(MMS$SOURCE)

all : client.exe server.exe
	@ write SYS$OUTPUT "Done."

clean :  
	@- delete *.obj;*,*_%stub.c*;*,$(APPL).h;*,client.exe;*,server.exe;*

client.exe : client.obj $(APPL)_cstub.obj $(APPL)_sstub.obj \
		matrixmgr.obj statics.obj
	- link $(LINKFLAGS) $(CXXLFLAGS) client.obj, $(APPL)_cstub.obj, \
	 $(APPL)_sstub.obj, matrixmgr.obj, statics.obj, $(DCELIBS) 

server.exe : server.obj matrixmgr.obj statics.obj \
		$(APPL)_sstub.obj $(APPL)_cstub.obj
	- link $(LINKFLAGS) $(CXXLFLAGS) server.obj, matrixmgr.obj, \
	 statics.obj, $(APPL)_sstub.obj, $(APPL)_cstub.obj, $(DCELIBS)


client.obj : client.cxx $(APPL).h
server.obj : server.cxx $(APPL).h

csetup :
	@ define/job RPC_DEFAULT_ENTRY \
		"/.:/example2_''f$edit(f$getsyi("NODENAME"),"LOWERCASE")'"
	@ show logical RPC_DEFAULT_ENTRY

ssetup :
	@ define/job EXAMPLE2_SERVER_ENTRY \
		"/.:/example2_''f$edit(f$getsyi("NODENAME"),"LOWERCASE")'"
	@ show logical EXAMPLE2_SERVER_ENTRY

! Stubs, auxiliary and header file from the IDL file

$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o : $(APPL).idl $(APPL).acf
	$(IDL) $(IDLFLAGS) $(APPL).idl
                                                                                                                                                                                  * [RPCMATRIX2.SRC]MAKEFILE.;1 +  , U   .     /  @   4 K       H                    - 
]   0   1    2   3      K  P   W   O     5   6 
!  7 X3!  8          9          G  @  H  J $ N                   ?                           # FILE NAME: Makefile
# Makefile for the matrix2 application

.SUFFIXES: .o .cxx .h

APPL=matrix

DCL_IDL= dcl mcr dce\$$idl
IDL=$(DCL_IDL)
IDLFLAGS=-lang cxx -keep both
CXX=cxx
CXXFLAGS=-c -I.
#LDFLAGS=-call_shared 
#DCELIBS=-L/usr/proj/rpc/nck/uxalpha_o -lnidl -ldce -lpthreads -lc_r -lmach
OPTFILE=/vms/sys0/syscommon/dce\$$library/dce_cxx.opt
#
# cxx compiler rule
#
.cxx.o: 
	$(CXX) $(CXXFLAGS) $<

all: client server
	@ echo Done.

clean:
	@- rm *.o *.obj *_?stub.cxx* ${APPL}.h client server

client: client.o ${APPL}_cstub.obj ${APPL}_sstub.obj matrixmgr.o statics.o
	${CXX} $(LDFLAGS) -o client client.o matrixmgr.o statics.o \
 		${APPL}_cstub.obj ${APPL}_sstub.obj \
		${OPTFILE} 

server: server.o ${APPL}_sstub.obj ${APPL}_cstub.obj matrixmgr.o statics.o
	${CXX} $(LDFLAGS) -o server server.o matrixmgr.o statics.o \
		${APPL}_sstub.obj ${APPL}_cstub.obj \
		${OPTFILE}

client.o: ${APPL}.h client.cxx 
server.o: ${APPL}.h server.cxx 

# Stubs and header file from the IDL file

${APPL}.h ${APPL}_cstub.obj ${APPL}_sstub.obj : ${APPL}.idl ${APPL}.acf
	$(IDL) $(IDLFLAGS) ${APPL}.idl
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       * [RPCMATRIX2.SRC]MATRIX.ACF;1 +  , U   .     /  @   4                          - 
]   0   1    2   3      K  P   W   O     5   6  5Zd  7 .xf  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: matrix.acf */
/* This file defines some attributes for the matrix interface */

interface Matrix
{
	/* include files generated into the server stub */
	[sstub] include "matrixmgr", "statics";

    	/* new2x2 should be mapped as a creator */
	[cxx_new(MatrixMgr)] new2x2 ();

	/* createMatrix is a static function that */
	/* calls ClassFactory on the server    */
	[cxx_static(ClassFactory)] createMatrix ();
}
                                                                                                      * [RPCMATRIX2.SRC]MATRIX.COM;1 +  , {/F   .     /  @   4 N                          - 
]   0   1    2   3      K  P   W   O     5   6 n  7 f&  8          9 @,  G  @  H  J $ N                   ?                          $!
$!                      COPYRIGHT (C) 1995 BY
$!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
$!                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
$!
$! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
$! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
$! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
$! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
$! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
$!
$! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
$! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
$!
$! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
$! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
$!
$! Abstract:
$!	Matrix.Com    Builds the Matrix2 example program and sets up the
$!                    necessary definitions in rpccp and cdscp.
$!
$! Modification History:
$!	12-Jan-1995 CKe Created for VMS DCE V1.3
$!
$!
$ if( p1 .eqs. "COMPILE" ) then goto do_compile
$ if( p1 .eqs. "CLIENT" ) then goto do_client
$ if( p1 .eqs. "SERVER" ) then goto do_server
$!
$!  Run t                                                                                                                                                                                                                                                   p                        )C $      DCEVAXMUPA013.A                5  }2  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX2]MATRIX2.SAV;1                                                                                   ~   ~@                          "            he idl compiler to generate the *.h and the *stubs.
$!
$ idl  -lang cxx -keep both matrix.idl
$!
$! Do the common compiles first
$!
$ do_compile:
$ cxx /NOLIST/G_FLOAT /INCLUDE=([],DCE:) MATRIXMGR.CXX
$ cxx /NOLIST/G_FLOAT /INCLUDE=([],DCE:) STATICS.CXX
$!
$!  Build the client 
$!
$do_client:
$ cxx /NOLIST/G_FLOAT /INCLUDE=([],DCE:) CLIENT.CXX
$ link /TRACE/NOMAP/EXEC=CLIENT.EXE  client.obj, matrix_cstub.obj, -
        matrix_sstub.obj, matrixmgr.obj, statics.obj, dce:dce_cxx.opt/opt 
$ write sys$output "Client done."
$!
$! Build the server
$!
$do_server:
$ cxx /NOLIST/G_FLOAT /INCLUDE=([],DCE:) SERVER.CXX
$ link /TRACE/NOMAP/EXEC=SERVER.EXE  server.obj, matrixmgr.obj, statics.obj, -
       matrix_cstub.obj, matrix_sstub.obj, dce:dce_cxx.opt/opt 
$ write SYS$OUTPUT "Server Done."
$ exit
$!
$ exit
                                                       * [RPCMATRIX2.SRC]MATRIX.IDL;1 +  , U   .     /  @   4                           - 
]   0   1    2   3      K  P   W   O     5   6  5Zd  7 Suhxf  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: matrix.idl */
/* This file contains the interface definition for a Matrix object */

[
    uuid(a3dc86be-e788-11cd-ab91-08002b3d8412)
]
interface Matrix
{
    /* Create a 2x2 matrix with a static member function */
    Matrix * createMatrix (
	[in] long & v11,
	[in] long & v12,
	[in] long & v21,
	[in] long & v22
    );

    /* Create a 2x2 matrix with a dynamic creator function */
    Matrix * new2x2(
	[in] long & v11,
	[in] long & v12,
	[in] long & v21,
	[in] long & v22
    );

    /* Set a new value in the matrix */
    void set(
	[in] long row,
	[in] long col,
	[in] long value
    );

    /* Get a value from the matrix */
    long get(
	[in] long row,
	[in] long col
    );

    /* Return a new matrix which is the inversion of the matrix */
    Matrix * invert();

    /* Return a new matrix which is the product of the matrix and m1 */
    Matrix * multiply(
	[in] Matrix * m1
    );

    /* Return in m2 the sum of the matrix and m1 */
    void add(
	[in] Matrix * m1,
	[out] Matrix ** m2
    );

}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            * [RPCMATRIX2.SRC]MATRIXMGR.CXX;1 +  , }/@   .     /  @   4                          - 
]   0   1    2   3      K  P   W   O     5   6  5Zd  7 xf  8          9 @,  G  @  H  J $ N                   ?                       // FILE NAME: matrixmgr.cxx
// This file contains the implementation of a MatrixMgr class
// which supports the IDL-generated Matrix interface.

#include "matrixmgr.h"

// Constructor 
MatrixMgr::MatrixMgr(idl_long_int v1, idl_long_int v2,
                     idl_long_int v3, idl_long_int v4)
{
	d[0][0] = v1;
	d[0][1] = v2;
	d[1][0] = v3;
	d[1][1] = v4;
}

// Destructor for new2x2
MatrixMgr::~MatrixMgr(void)
{
	return;
}

// Sets the matrix element to value
void
MatrixMgr::set(idl_long_int row, idl_long_int col, idl_long_int value)
{
	d[row][col] = value;
}

// Returns an element from the matrix 
idl_long_int
MatrixMgr::get(idl_long_int row, idl_long_int col)
{ 
	return d[row][col];
}

// Returns a new inverted matrix built from this
Matrix *
MatrixMgr::invert(void){
	return new MatrixMgr(d[1][1],d[1][0],d[0][1],d[0][0]);
}

// Returns the product of this and the parameter
Matrix *
MatrixMgr::multiply(Matrix *m)
{
	Matrix *newp = new MatrixMgr(0,0,0,0);

	for (int i = 0; i < 2; i++) {
	    for (int j = 0; j < 2; j++) {
		idl_long_int s = 0;
		for (int k = 0; k < 2; k++) {
		    s += get(i, k) * m->get(k, j);
		}
		newp->set(i, j, s);
	    }
	}
	return newp;
}
      
// Returns the sum of this and m1 in m2
void
MatrixMgr::add(Matrix *m1, Matrix **m2)
{
	*m2 =  new MatrixMgr(
			d[0][0] + m1->get(0, 0),
			d[0][1] + m1->get(0, 1),
			d[1][0] + m1->get(1, 0),
			d[1][1] + m1->get(1, 1)
	);
    	return;
}
                                                                                                                             * [RPCMATRIX2.SRC]MATRIXMGR.H;1 +  , /5   .     /  @   4       N                    - 
]   0   1    2   3      K  P   W   O     5   6 {Zd  7 xf  8          9 @,  G  @  H  J $ N                   ?                         // FILE NAME: matrixmgr.h
// This file contains the implementation of a Matrix class

#ifndef matrix_mgr_h
#define matrix_mgr_h

#include "matrix.h"

// Local Implementation of a 2x2 Matrix

class MatrixMgr : public Matrix {
    private:
	idl_long_int d[2][2];		//  actual data

    public: 
	// Constructor for new2x2
        MatrixMgr(idl_long_int v1, idl_long_int v2,
                  idl_long_int v3, idl_long_int v4);

	// Destructor for new2x2
	~MatrixMgr(void);

	// Static function that a new matrix
        static Matrix * createMatrix(idl_long_int &, idl_long_int &,
                                     idl_long_int &, idl_long_int &);

	// Sets the matrix element to value
	void set(idl_long_int row, idl_long_int col, idl_long_int value);

	// Returns an element from the matrix 
	idl_long_int get(idl_long_int row, idl_long_int col);

	// Returns a new inverted matrix built from this
	Matrix * invert(void);

	// Returns the product of this and the parameter
	Matrix * multiply(Matrix *m);
      
	// Returns the sum of this and m1 in m2
	void add( Matrix *m1, Matrix **m2);
};

#endif
                                                                                                                                                                                                                                                                                                                                                                                                                                                                 * [RPCMATRIX2.SRC]README.TXT;1 +  , .;   .     /  @   4 N      	                    - 
]   0   1    2   3      K  P   W   O 
    5   6 _J  7 J  8          9          G  @  H  J $ N                   ?                               			COPYRIGHT (C) 1995 BY7                  DIGITAL EQUIPMENT CORPORATION, MAYNARD 6                   MASSACHUSETTS.  ALL RIGHTS RESERVED.  F  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDI  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION B  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESE  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER J  PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.  I  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND J  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.  D  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS7  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.   K   _________________________________________________________________________ 3                 OBJECT-ORIENTED RPC TEST PROGRAM #2   B   This example implements a 2x2 matrix in a server application andD   allows the client application to manipulate the matrix with an IDLB   interface.  The location transparency feature of IDL C++ support    is emphasized in this example.  ( The following features are illustrated:   A - server provides a creator function for creating dynamic objects   ; - server provides a static functions and overrides the name   C - client creates dynamic objects using the object creator operation   L - client create local objects and interfaces to it with the Matrix interface  K - client performs local Matrix operations while referencing a remote object   K - client performs remote Matrix operations while referencing a local object     * HOW TO BUILD THE APPLICATION UNDER OpenVMS* ------------------------------------------  C Copy files from the DCE examples directory to your local directory.   %    $ set default mydisk:[mydirectory] <    $ copy sys$common:[syshlp.examples.dce.rpc.matrix1]*.* []  = To build the application, first de                                                                                                                                                                                                                                                   q                         $      DCEVAXMUPA013.A                5  }2  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX2]MATRIX2.SAV;1                                                                                   ~   ~@                         { "     &       fine the symbol netaddr to  E be the network address of the server, then run the command procedure:       $ @matrix  @    or if you have MMS you can use the description file included:  	    $  MMS      TO RUN THE APPLICATION  B This applications makes use of the auto_handle feature of IDL. TheF server registers the binding handle under the name as specified by theB environment vriable EXAMPLE2_SERVER_ENTRY. The client must set theE RPC_DEFAULT_ENTRY environment variable to this value vefore starting   the process.       $ dce_loginC    $ define EXAMPLE2_SERVER_ENTRY "/.:/example2_<server_host_name>"     $ run server    Run the client as follows:  @    $ define RPC_DEFAULT_ENTRY  "/.:/example2_<server_host_name>"    $ run client     ( HOW TO BUILD THE APPLICATION UNDER POSIX( ----------------------------------------  H Copy the files from the DCE examples directory to your Posix accessible 
 directory.      psx> cd /mydev/mydir /    psx> copy /usr/dce/examples/rpc/matrix2/*  .   5 To build the application, run the following commands:      psx> make      TO RUN THE APPLICATION  B This applications makes use of the auto_handle feature of IDL. TheF server registers the binding handle under the name as specified by theC environment variable EXAMPLE2_SERVER_ENTRY. The client must set the E RPC_DEFAULT_ENTRY environment variable to this value vefore starting   the process.       psx> dce_login E    psx> export EXAMPLE2_SERVER_ENTRY=/.:/example2_<server_host_name>      psx> server     Run the client as follows:  C    psx> def_log  RPC_DEFAULT_ENTRY  /.:/example2_<server_host_name>     psx> client     APPLICATION FILES: ------------------   descrip.mms < Contains the description of how the application is compiled.   matrix.com  ! Builds the applications from DCL.   
 matrix.idl/ Contains the interface definition for a matrix.   
 matrix.acf5 Contains the attributes for the interface definition.    matrixmgr.h N Contains the class definition of a 2x2 matrix supporting the Matrix interface.  
 matrixmgr.cxx L Contains the implementation of a 2x2 matrix supporting the Matrix interface.  
 client.cxx6 Illustrates several ways to manipulate remote objects.  
 server.cxxM Initializes the server and advertises a named object with the Naming service.   	 statics.h ? Declares the function prototype for the ClassFactory operation.    statics.cxx 9 Creates and returns a reference to a 2x2 identity matrix.    check_status.h8 Defines an error checking macro used by the application.                                                                                                                         * [RPCMATRIX2.SRC]SERVER.CXX;1 +  , .6   .     /  @   4 G                          - 
]   0   1    2   3      K  P   W   O     5   6  5J  7 #~yf  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: server.cxx */
/* This is the server module of the matrix application. */

#include <iostream.h>

#include "matrixmgr.h"
#include "check_status.h"

int
main()
{
	error_status_t		status;
	rpc_binding_vector_p_t	binding_vector;
	unsigned_char_t 	*entry_name;

	// create some binding handles
	rpc_server_use_all_protseqs(
  		rpc_c_protseq_max_reqs_default,
		&status
	);
	CHECK_STATUS(status, "Can't create binding information:", ABORT);

	// register the matrix interface - use the default epv
	rpc_server_register_if(
		Matrix_v0_0_s_ifspec, 
		NULL,
		NULL,
  		&status
	);
	CHECK_STATUS(status, "Can't register interface:", ABORT);

	// get the binding vector
	rpc_server_inq_bindings(&binding_vector, &status);
	CHECK_STATUS(status, "Can't get binding information:", ABORT);

	// manage endpoints
	rpc_ep_register(
		Matrix_v0_0_s_ifspec, 
		binding_vector,
		NULL, 
		(unsigned_char_t *) "Test Server",
		&status
	);
	CHECK_STATUS(status, "Can't add address to the endpoint map:", ABORT);

	// advertise the server
	entry_name = (unsigned_char_t *) getenv("EXAMPLE2_SERVER_ENTRY");
	rpc_ns_binding_export(
		rpc_c_ns_syntax_default,
		entry_name,
		Matrix_v0_0_s_ifspec,
		binding_vector,
		NULL,
		&status
	);
	CHECK_STATUS(status, "Can't export to name service database:", ABORT);

	TRY
	    cout << "server is listening" << endl;
	    rpc_server_listen(5, &status);
	    CHECK_STATUS(status, "rpc listen failed:", ABORT);
	FINALLY
	    rpc_server_inq_bindings(&binding_vector, &status);
	    CHECK_STATUS(status, "Can't get binding information:", ABORT);

	    rpc_ep_unregister(
		Matrix_v0_0_s_ifspec, 
		binding_vector,
		NULL, 
		&status
	    );
	    CHECK_STATUS(status, "Can't unregister endpoint:", ABORT);

	    rpc_binding_vector_free(&binding_vector, &status);
	    CHECK_STATUS(status, "Can't free binding vector:", ABORT);

	    cout << "server exiting" << endl;

	ENDTRY

	return 0;
}
                                                                                                                                                * [RPCMATRIX2.SRC]STATICS.CXX;1 +  , )a   .     /  @   4       q                   - 
]   0   1    2   3      K  P   W   O     5   6  bZd  7 8yf  8          9 @,  G  @  H  J $ N                   ?                         /* FILE NAME: statics.cxx */
/* This file is the implementation of the static */
/* member function as specified by the           */
/* [cxx_static(ClassFactory)] ACF attribute.  */

#include "matrixmgr.h"

Matrix *
ClassFactory(idl_long_int & v11, idl_long_int & v12,
             idl_long_int & v21, idl_long_int & v22)
{
	return new MatrixMgr(v11, v12, v21, v22);
}
                                                                                                                                                              * [RPCMATRIX2.SRC]STATICS.H;1 +  , .A   .     /  @   4                           - 
]   0   1    2   3      K  P   W   O     5   6  bZd  7 }[yf  8          9 @,  G  @  H  J $ N                   ?                           // FILE NAME: statics.h
// This file declares the static function to call 
// when invoking Matrix::createMatrix

Matrix *ClassFactory(idl_long_int &, idl_long_int &, 
                     idl_long_int &, idl_long_int &);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   r                        ` $      DCEVAXMUPA013.A                5  }2  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX2]MATRIX2.SAV;1                                                                                   ~   ~@                         b      7                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & * [SYSHLP.EXAMPLES.DCE.RPC]PAYROLL.DIR;1 +  , 1   .     /  @   4                            - 3    0   1    2   3     K  P   W   O     5   6 E   7 П@   8          9          G  @  H   J  I                     PAYROLL.SAV  8                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     . * [SYSHLP.EXAMPLES.DCE.RPC.PAYROLL]PAYROLL.SAV;1 +  , 8   . @    /  @   4   ~  @   @      ~               - 1    0   1    2   3      K  P   W   O A    5   6  e  7 І   8          9          G  @  H   J                                             ` ~      PAYROLL.SAV                                                                                                                                                                                                                  PAYROLL.SAV7  BACKUP SRC$:*.* OBJ$:PAYROLL.SAV/SAVE_SET/GROUPS_SIZE=0  GBDBUILD       @    e      V5.5	 	 _OPENUP:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                 * [RPCPAYROLL.SRC]DCE_LIB.OPT;1 +  , T   .     /  @   4                            - *9   0   1    2   3      K  P   W   O     5   6 @c  7 (Cئ  8          9   G  @  H  J $ N                   ?                          DCE$LIB_SHR/SHARE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * [RPCPAYROLL.SRC]MAKEFILE.;1 +  , T   .     /  @   4 K       ~                   - *9   0   1    2   3      K  P   W   O 	    5   6 (  7 hHئ  8          9   G  @  H  J $ N                   ?               
            #
#                      COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#

DCELIBS = $(LIBLOC) -ldce -lpthreads -lmach -lc_r -lm
FFLAGS = -c
FLIBS = -lfor -lutil -lUfor -lm -lots
FORTRAN = f77
I18NLIB = 
IDL = idl
IDLFLAGS = -trace all -lang fortran -standard extended
LINKFLAGS = 

# Default target - build client and server
all : print_pay server
	@- cp /dev/null build.timestamp

# Target to build "local" (non-RPC) application in single image
local : local_print_pay
	@- cp /dev/null buildl.timestamp

# Target to run local application
run_local :
	FORT4=payroll.dat; export FORT4; local_print_pay

# Target to clean up non-source files
clean :
	@- rm server server.o manager.o payroll_sstub.o
	@- rm print_pay print_p                                                                                                                                                                                   s                        PG $      DCEVAXMUPA013.A                8  1  .[SYSHLP.EXAMPLES.DCE.RPC.PAYROLL]PAYROLL.SAV;1                                                                                   ~   ~@                         ^ "            ay.o payroll_cstub.o
	@- rm payroll.for payroll.for_h
	@- rm build.timestamp
	@- rm buildl.timestamp local_print_pay
	@- rm server.log

server : server.o manager.o payroll_sstub.o
	$(CC) $(LINKFLAGS) -o $@ server.o manager.o payroll_sstub.o \
$(FLIBS) $(DCELIBS)

print_pay : print_pay.o payroll_cstub.o
	$(FORTRAN) $(LINKFLAGS) -o $@ print_pay.o payroll_cstub.o \
$(FLIBS) $(DCELIBS)

print_pay.o : print_pay.for payroll.for
	$(FORTRAN) $(FFLAGS) -o $@ print_pay.for

payroll.for : payroll.idl
	$(IDL) $(IDLFLAGS) payroll.idl

payroll_cstub.o : payroll.idl
	$(IDL) $(IDLFLAGS) payroll.idl

server.o : server.c payroll.for_h
	$(CC) $(CFLAGS) -o $@ server.c

payroll.for_h : payroll.idl
	$(IDL) $(IDLFLAGS) payroll.idl

manager.o : manager.for payroll.for
	$(FORTRAN) $(FFLAGS) -o $@ manager.for

payroll_sstub.obj : payroll.idl
	$(IDL) $(IDLFLAGS) payroll.idl

local_print_pay : print_pay.o manager.o
	$(FORTRAN) $(LINKFLAGS) -o $@ print_pay.o manager.o $(FLIBS) $(I18NLIB)
                                                                                                                                                 * [RPCPAYROLL.SRC]MANAGER.FOR;1 +  , T   .     /  @   4 O       4                    - *9   0   1    2   3      K  P   W   O     5   6 hSئ  7 hئ  8          9   G  @  H  J $ N                   ?                         ,         SUBROUTINE CALCULATE_PAY(CARDS, PAY)C         INCLUDE 'payroll.for'    ! Created by the IDL compiler from 7                                  !    file PAYROLL.IDL.  C G C	COPYRIGHT (C) 1993 BY DIGITAL EQUIPMENT CORP., MAYNARD MASSACHUSETTS. O C       The structure of a time card is described in included file PAYROLL.FOR. "         RECORD /TIMECARD/ CARDS(7)         INTEGER*4 PAY          INTEGER*4 I            PAY = 0          DO 10 I = 1, 7% C	    The basic ho