@ [INHERIT ('SYS$SHARE:STARLET', 'SYS$SHARE:PASCAL$STR_ROUTINES')]   PROGRAM TCPIPSym;     {Author:    John E. Babbitt, Jr."             Cutler & Company, Inc.             503 Airport Road             Medford, OR  97504:             E-mail: john@cutler.com (alt: john@eskimo.com)    Date:      May 11, 1995  B  Abstract:  Constructs a printer symbiont with TCP/IP sockets callC             capabilities.  Requires MadGoat's NETLIB v2.0 software. ?             Because of NETLIB, can support most TCP/IP package.   %             To create the executable:                    $ MACRO PSMDEF!                 $ PASCAL TCPIPSYM H                 $ LINK/NODEBUG/NOTRACE TCPIPSYM,PSMDEF,SYS$INPUT:/OPTION(                   SYS$SHARE:NETLIB/SHARE  -             To set up a TCP/IP printer queue:   7                 $ COPY TCPIPSYM.EXE SYS$COMMON:[SYSEXE] <                 $ INITIALIZE/QUEUE/START/PROCESSOR=TCPIPSYM-@                     /ON="printer1.where.com:9100" MY_TCPIP_QUEUE  "             To print to the queue:  8                 $ PRINT/QUEUE=MY_TCPIP_QUEUE MY_FILE.TXT  J             Copyrighted 1995 by John E. Babbitt, Jr.  All rights reserved.I             This program may be freely distributed.  No part of it may be I             sold.  No warranty or support implied.  Use at your own risk.     Modifications:   '     May 11, 1995 - John E. Babbitt, Jr. &         Initial release to the public. }   $ {Declare PSM constants used within.} VAR PSM$K_Close,     PSM$K_Open,      PSM$K_Output,      PSM$K_Write,6     PSM$K_Write_NoFormat:   [EXTERNAL, VALUE] INTEGER;  # {Declare PSM routines used within.} $ [ASYNCHRONOUS, EXTERNAL (PSM$Print)] FUNCTION PSM$Print%    (Streams:    UNSIGNED := %IMMED 0; %     BufSiz:     UNSIGNED := %IMMED 0; %     WorkSiz:    UNSIGNED := %IMMED 0) #               : UNSIGNED; EXTERNAL;   & [ASYNCHRONOUS, EXTERNAL (PSM$Replace)] FUNCTION PSM$Replace    (Code:       UNSIGNED; =     %IMMED [ASYNCHRONOUS, UNBOUND] FUNCTION Routine: INTEGER) #               : UNSIGNED; EXTERNAL;    {Declare local variables.}= VAR Status:     UNSIGNED;                       {status code}   P {||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}   FUNCTION TCPIPOutputN    (RequestId:      UNSIGNED;                   {request ID        - not used}N     WorkArea:       UNSIGNED;                   {work area         - not used}?     FuncCode:       UNSIGNED;                   {function code} F     VAR FuncDesc:   DSC1$TYPE;                  {function description}N     VAR FuncArg:    UNSIGNED)                   {function argument - not used}=                   : UNSIGNED;                   {status code}   F {Abstract:  Performs appropriate actions as requested by the symbiont.    Modifications:  }    {Declare local types.}? TYPE UWord = [WORD] 0..65535;                   {unsigned word}   & {Declare NETLIB routines used within.}( [ASYNCHRONOUS, EXTERNAL (NetLib_Socket)] FUNCTION NetLib_Socket    (VAR Socket:     UNSIGNED) '                   : UNSIGNED; EXTERNAL;   1 [ASYNCHRONOUS, EXTERNAL (NetLib_Connect_By_Name)]  FUNCTION NetLib_Connect_By_Name     (Socket:         UNSIGNED; :     HostName:       PACKED ARRAY[L1..H1: INTEGER] OF CHAR;     Port:           UWord)'                   : UNSIGNED; EXTERNAL; ' [ASYNCHRONOUS, EXTERNAL (NetLib_Write)]  FUNCTION NetLib_Write     (Socket:         UNSIGNED;      Buffer:         UNSIGNED) '                   : UNSIGNED; EXTERNAL;   ' [ASYNCHRONOUS, EXTERNAL (NetLib_Close)]  FUNCTION NetLib_Close     (Socket:         UNSIGNED) '                   : UNSIGNED; EXTERNAL;    {Declare local variables.}H VAR IPAddress:  VARYING[255] OF CHAR;           {remote host IP address}E     IPPort:     UWord;                          {remote host IP port} @     PrvMask:    Prv$Type;                       {privilege mask}?     Socket:     [STATIC] UNSIGNED;              {TCP/IP socket} =     Status:     UNSIGNED;                       {status code}   P {||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}   PROCEDURE ParseString H    (VAR IPAddress:  VARYING[U] OF CHAR;         {remote host IP address}E     VAR IPPort:     UWord);                     {remote host IP port}   I {Abstract:  Parses given IP address/port string into separate components.     Modifications:  }    {Declare local constants.}! CONST DefaultAddress = 'printer';        DefaultPort    = 9100;   {Declare local variables.}D VAR PortGiven:      BOOLEAN;                    {TRUE if port given}>     PortIndex:      INTEGER;                    {search index}=     Status:         UNSIGNED;                   {status code}   P {||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}   FUNCTION tonumericD    (string:     VARYING[U] OF CHAR;             {string to evaluate}@     VAR number: UWord)                          {value returned}D               : BOOLEAN;                        {TRUE if successful}  D {Abstract:  Converts string to numeric.  Returns TRUE if successful.    Modifications:  }    VAR i:  INTEGER;   BEGIN   {tonumeric}   (     {Attempt to read string as numeric.}.     READV (string, number, ERROR := CONTINUE);  #     {TRUE if READV was successful.}      tonumeric := STATUSV = 0;    END;    {tonumeric}   P {||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}   BEGIN   {ParseString}        {Apply default if blank.} 3     IF IPAddress.LENGTH = 0 THEN WRITEV (IPAddress, *       DefaultAddress, ":", DefaultPort:1);  '     {Strip quotes from string, if any.} +     IF IPAddress[1] = '"' THEN IPAddress := 0       SUBSTR (IPAddress, 2, IPAddress.LENGTH-2);  $     {Determine if IP port is given.}(     PortIndex := INDEX (IPAddress, ':');D     PortGiven := (PortIndex > 0) AND (PortIndex < IPAddress.LENGTH);  ;     {Get IP port from string.  Use default if non-numeric.} >     IF NOT PortGiven OR_ELSE NOT tonumeric (SUBSTR (IPAddress,<       PortIndex+1, IPAddress.LENGTH-PortIndex), IPPort) THEN         IPPort := DefaultPort;  @     {Remove IP port from IP address.  Use default if malformed.}     IF PortIndex = 1 THEN #         IPAddress := DefaultAddress      ELSE IF PortIndex > 1 THEN8         IPAddress := SUBSTR (IPAddress, 1, PortIndex-1);   END;    {ParseString}   P {||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}   BEGIN   {TCPIPOutput}        {Open a channel to device.} !     IF FuncCode = PSM$K_Open THEN        BEGIN   -         {Enable NETMBX privilege for TCP/IP.}          PrvMask := ZERO;%         PrvMask.Prv$V_NetMbx := TRUE; '         Status := $SetPrv (1, PrvMask);            {Get a socket.} &         IF ODD (Status) THEN Status :=!           NetLib_Socket (Socket);   )         {Get IP Address and Port string.} &         IF ODD (Status) THEN Status :=8           Str$Copy_DX (%DESCR IPAddress, %REF FuncDesc);  (         {Separate IP Port from Address.}         IF ODD (Status) THEN*           ParseString (IPAddress, IPPort);  $         {Connect to printer device.}&         IF ODD (Status) THEN Status :==           NetLib_Connect_By_Name (Socket, IPAddress, IPPort);   	       END        {Write data to device.} N     ELSE IF (FuncCode = PSM$K_Write) OR (FuncCode = PSM$K_Write_NoFormat) THEN6         Status := NetLib_Write (Socket, %REF FuncDesc)       {Close channel to device.}'     ELSE IF FuncCode = PSM$K_Close THEN '         Status := NetLib_Close (Socket)   5     {Let normal symbiont take care of other actions.} "     ELSE Status := PSM$_FunNotSup;  )     {Return status code to the symbiont.}      TCPIPOutput := Status;   END;    {TCPIPOutput}   P {||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}   BEGIN   {TCPIPSym}  6     {Replace the normal output routine with this one.}=     Status := PSM$Replace (PSM$K_Output, %IMMED TCPIPOutput); ,     IF NOT ODD (Status) THEN $Exit (Status);       {Start the symbiont.}      Status := PSM$Print (1);     $Exit (Status);    END.    {TCPIPSym}