 @Part(CKUNIX,root="kuser")" @string[-ckversion="5A(180) BETA"]$ @define(exx=example,above 2,below 1)F @define(d4=description,leftmargin +4,indent -4,group,blanklines hinge)F @define(d8=description,leftmargin +8,indent -8,group,blanklines hinge)I @define(d128=description,leftmargin +12,indent -8,group,blanklines hinge) G @define(d62=description,leftmargin +6,indent -2,group,blanklines hinge) G @define(d84=description,leftmargin +8,indent -4,group,blanklines hinge)  @Chapter<C-Kermit># @index<C-Kermit>@index<UNIX Kermit>    @case(device,file="********@* F This document is formatted as an ordinary, plain text ASCII disk file.* Typeset copies are available from Columbia> University.  Changes should be made to CKUKER.MSS.@*********")   @Begin<Description,spread 0.2>H @i(Program:)@\Frank da Cruz (Columbia University), contributions by many others.    @i(Language:)@\C  K @i(Documentation:)@\Christine Gianone, Frank da Cruz (Columbia University).     @i(Version:)@\@value(-ckversion)   @i(Date: )@\May 26, 1992 @end<Description>   / @subheading<C-Kermit Capabilities At A Glance:> , @begin<format,leftmargin +2,above 1,below 1>' @tabclear()@tabset(3.5inches,4.0inches)  Local operation:@\Yes  Remote operation:@\Yes Transfer text files:@\Yes  Transfer binary files:@\Yes  International text:@\Yes Wildcard send:@\Yes   File transfer interruption:@\Yes  Filename collision actions:@\Yes Can time out:@\Yes 8th-bit prefixing:@\Yes  Repeat count prefixing:@\Yes Alternate block checks:@\Yes  Automatic parity detection:@\Yes Dynamic packet length:@\Yes  CONNECT mode:@\Yes. Terminal emulation:@\Depends on implementation Key mapping:@\Yes  Communication settings:@\Yes$ Transmit BREAK:@\Yes (most versions)  Support for dialout modems:@\Yes6 TCP/IP support:@\Yes (some versions, Berkeley sockets). X.25 support:@\Yes (SUN versions with SunLink)! IBM mainframe communication:@\Yes  Transaction logging:@\Yes  Session logging:@\Yes  Debug logging:@\Yes  Packet logging:@\Yes Act as server:@\Yes  Talk to server:@\Yes Advanced server functions:@\Yes  Security for server:@\Yes  Local file management:@\Yes  Command/Init files:@\Yes Long packets:@\Yes Sliding Windows:@\Yes  File attributes packets:@\Yes  Command macros:@\Yes! Script programming language:@\Yes # Raw file transmit and capture:@\Yes  @end<format>
 @newpage() @begin<quotation,indent 0> @bar()  I @i<IMPORTANT NOTICE:> The user manual for the current release of C-Kermit F is @i"Using C-Kermit", by Frank @w<da Cruz> and Christine M@. Gianone,I published by Digital Press, Burlington, MA.  Publication date: Fall 1992. N After Fall 1992, call Digital Press at 1-800-344-4825 for further information. @bar() @end<quotation>    @section(Acknowledgements)  M Thanks to the dozens of people who have been involved in C-Kermit development E over the years, especially Bill Catchings, Jeff Damens and Chris Maio L (formerly of Columbia University), and Herm Fischer of Encino, CA, for theirN roles in its initial development.  And special thanks to those who put so much, work into features or testing of version 5A:/ @begin(format, above 1, below 1, leftmargin +4) > Kristoffer Eriksson (Peridot Konsult AB, @uoum()rebro, Sweden)B Bo Kullmar (Sveriges Riksbank (Central Bank of Sweden), Stockholm), Tor Lillqvist (Helsinki University, Finland)C Warren H@. Tucker (Tridom Corporation, Mountain Park, Georgia, USA) B Peter Mauzey (AT&T Bell Laboratories, Middletown, New Jersey, USA)7 Terry Kennedy (St Peters College, Jersey City, NJ, USA) : Chuck Hedrick (Rutgers University, New Brunswick, NJ, USA), Joe R@. Doupnik (Utah State University, USA)B Hirofumi Fujii (Japan National Lab for High Energy Physics, Tokyo)0 Ken Yap (University of Rochester, New York, USA)= Marcello Frutig (Catholic University, Rio de Janeiro, Brazil) 2 Paul Placeway (BBN, Cambridge, Massachusetts, USA)= Mark Buda (Digital Equipment Corporation, New Hampshire, USA) ? William Bader (Software Consulting Services, Nazareth, PA, USA) : Steve Walton (California State University Northridge, USA)0 Rick Watson (University of Texas at Austin, USA)( Peter Svanberg (Royal Techn. HS, Sweden)2 Michel Robitaille (University of Montreal, Canada)> Kai Uwe Rommel (Technische Universit@aum()t Muenchen, Germany)" Paul Kline (Drake University, USA)/ Chris Adie (Edinburgh University, Scotland, UK) ? Chris Armstrong (Brookhaven National Laboratory, New York, USA) - James Harvey (Indiana/Purdue University, USA) 3 Bob Larson (University of Southern California, USA) ( Christian Hemsing (RWTH Aachen, Germany)8 Bruce J@. Moore (Allen-Bradley Co, Highland Heights, OH) @end(format)  H Kristoffer, Bo, Warren, and Peter comprised the "modem committee", whichL worked long and hard to rationalize C-Kermit's treatment of modem signals inJ the many and varied UNIX environments.  Kristoffer and Bo also contributedN much code to the UNIX-specific support modules.  Kristoffer deserves a specialI Archaeology Achievement Award for a detailed study and unraveling of many J years' accretions of incomprehensible "magic" in the infamous @q<ckutio.c>N module (a collection of supposedly simple functions that give the emphatic lie: to all claims that UNIX is a "portable operating system").  O Ken got the TCP/IP support started by supplying the socket-opening code for the F Berkeley UNIX version.  Marcello supplied the SunLink X.25 code.  PaulH Placeway, Rick Watson, Peter Svanberg, Paul Kline, and Michel RobitailleH contributed enormously to the Macintosh version (and continue to do so).H The two Chris's, and more recently Kai-Uwe, for the OS/2 version; Terry,J William, James, Mark for the VAX/VMS version; Steve for the Amiga version;? Christian for the OS-9 version; Bruce for the Atari ST version.   O Chuck found and fixed many bugs and contributed many valuable insights, as well / as writing the UNIX "man page" for C-Kermit 5A.   L And thanks to the indefatigable and omniscient Joe Doupnik (author of MS-DOSI Kermit), who worked closely with the authors on the design of the sliding I window algorithms, the script programming language, and the international K character set support during the joint development effort for MS-DOS Kermit N 3.0 and C-Kermit 5A (and in his spare time, Joe lent a hand with the AT&T 7300N UNIX PC version of C-Kermit).  And finally, thanks to the dozens (hundreds) ofH others who tested C-Kermit on dozens (hundreds) of hardware and softwareL platforms and contributed bug reports, fixes, new features, and suggestions: @begin<format,above 1>3    Chris Adie, Edinburgh U, Scotland (OS/2 support) 0    Robert Adsett, University of Waterloo, Canada    Larry Afrin, Clemson U     Barry Archer, U of Missouri<    Robert Andersson, International Systems A/S, Oslo, Norway2    Chris Armstrong, Brookhaven National Lab (OS/2)"    William Bader, Moravian College    Fuat Baran, CUCCA    Stan Barber, Rice U    Jim Barbour, U of Colorado     Donn Baumgartner, Dell     Nelson Beebe, U of Utah    Karl Berry, UMB    Dean W Bettinger, SUNY     Gary Bilkus    Marc Boucher, U of Montreal    Charles Brooks, EDN    Bob Brown    Mike Brown, Purdue U 0    Jack Bryans, California State U at Long Beach    Mark Buda, DEC (VAX/VMS) B    Bjorn Carlsson, Stockholm University Computer Centre QZ, Sweden$    Bill Catchings, formerly of CUCCA"    Bob Cattani, Columbia U CS Dept'    Davide Cervone, Rochester University     Seth Chaiklin, Denmark B    John Chandler, Harvard U / Smithsonian Astronomical Observatory&    John L Chmielewski, AT&T, Lisle, IL    Howard Chu, U of Michigan"    Bill Coalson, McDonnell Douglas!    Bertie Coopersmith, London, UK 6    Chet Creider, University of Western Ontario, Canada    Alan Crosswell, CUCCA!    Jeff Damens, formerly of CUCCA     Mark Davies, Bath U, UK    S. Dezawa, Fujifilm, Japan     Joe R. Doupnik, Utah State U     Frank Dreano (Honeywell) (    John Dunlap, University of Washington!    David Dyck, John Fluke Mfg Co.     Bernie Eiben, DEC;    Kristoffer Eriksson, Peridot Konsult AB, Oerebro, Sweden "    John R. Evans, IRS, Kansas City    Glenn Everhart, RCA Labs D    Herm Fischer, Encino, CA (extensive contributions to version 4.0)    Carl Fongheiser, CWRUI    Marcello Frutig, Catholic University, Sao Paulo, Brazil (X.25 support) I    Hirofumi Fujii, Japan Nat'l Lab for High Energy Physics, Tokyo (Kanji)     Chuck Fuller, PSC    Andy Fyfe, Caltech     Christine M. Gianone, CUCCA    John Gilmore, UC Berkeley    German Goldszmidt, IBM     Alistair Gorman, New Zealand     Chris Green, Essex U, UK (    Alan Grieg, Dundee Tech, Scotland, UK    Yekta Gursel, MIT    Jim Guyton, Rand Corp    Michael Haertel    Marion Hakanson    John Hamilston, Iowa State U     Simon Hania, Netherlands     Stan Hanks, Rice U.    Ken Harrenstein, SRI '    James Harvey, Indiana/Purdue U (VMS) 
    Rob Healey     Chuck Hedrick, Rutgers U A    Ron Heiby, Technical Systems Division, Motorola Computer Group     Steve Hemminger, Tektronix 1    Christian Hemsing, RWTH Aachen, Germany (OS-9) )    Andrew Herbert, Monash Univ, Australia     Mike Hickey, ITI     R E Hill     Bill Homer, Cray Research0    Randy Huntziger, National Library of Medicine    Larry Jacobs, Transarc *    Steve Jenkins, Lancaster University, UK!    Mark B Johnson, Apple Computer     Eric F Jones, AT&T     Luke Jones, AT&T $    Peter Jones, U of Quebec Montreal    Phil Julian, SAS Institute (    Mic Kaczmarczik, U of Texas at AustinM    Sergey Kartashoff, Inst. of Precise Mechanics & Computer Equipment, Moscow     Howie Kaye, CUCCA0    Rob Kedoin, Linotype Co, Hauppauge, NY (OS/2)    Mark Kennedy, IBMI    Terry Kennedy, St Peter's College, Jersey City, NJ (VAX/VMS, 2.11 BSD)     Douglas Kingston, morgan.com &    Tom Kloos, Sequent Computer Systems$    Jim Knutson, U of Texas at Austin!    David Kricker, Encore Computer     Thomas Krueger, UWM,    Bo Kullmar, Central Bank of Sweden, Kista    John Kunze, UC Berkeley    Bob Larson, USC (OS-9) *    Bert Laverman, Groningen U, Netherlands    Steve Layton     David Lawyer, UC Irvine    S.O. Lidie, Lehigh U .    Tor Lillqvist, Helsinki University, Finland    Dean Long(    Kevin Lowey, U of Saskatchewan (OS/2)"    Andy Lowry, Columbia UniversityF    David MacKenzie, Environmental Defense Fund, University of Maryland/    John Mackin, University of Sidney, Australia     Martin Maclaren, Bath U, UK!    Chris Maio, Columbia U CS Dept (    Fulvio Marino, Olivetti, Ivrea, Italy    Peter Mauzey, AT&T     Tye McQueen, Utah State U    Ted Medin    Hellmuth Michaelis (    Leslie Mikesell, American Farm Bureau    Martin Minow, DEC (VAX/VMS)    Pawan Mistra, Bellcore "    Ken Mizialko, IBM, Manassas, VA    Ray Moody, Purdue UC    Bruce J Moore, Allen-Bradley Co, Highland Heights, OH (Atari ST)     Steve Morley, Convex $    Peter Mossel, Columbia University    Tony Movshon, NYU)    Lou Muccioli, Swanson Analysis Systems 
    Dan Murphy     Gary Mussar    John Nall, FSU (    Jack Nelson, University of Pittsburgh7    Jim Noble, Planning Research Corporation (Macintosh)     Ian O'Brien, Bath U, UK
    John Owens 2    Andr@eac() Pirard, University of Liege, Belgium1    Paul Placeway, Ohio State U (Macintosh & more) 9    Piet W. Plomp, ICCE, Groningen University, Netherlands     Ken Poulton, HP Labs     Manfred Prange, Oakland U    Frank Prindle, NADC    Tony Querubin, U of Hawaii 
    Anton Rang 
    Scott Ribe '    Alan Robiette, Oxford University, UK )    Michel Robitaille, U of Montreal (Mac) B    Kai Uwe Rommel, Technische Universit@aum()t M@uum()nchen (OS/2)    Larry Rosenman (Amiga)     Jay Rouman, U of Michigan9    Jack Rouse, SAS Institute (Data General and/or Apollo) '    Stew Rubenstein, Harvard U (VAX/VMS) $    Bill Schilit, Columbia University    Eric Schnoebelen, Convex     Benn Schreiber, DEC1    Dan Schullman, DEC (modems, DIAL command, etc)     John Schultz, 3M "    Steven Schultz, Contel (PDP-11)%    APPP Scorer, Leeds Polytechnic, UK (    Gordon Scott, Micro Focus, Newbury UK(    Gisbert W. Selke, WIdO, Bonn, Germany-    David Sizeland, U of London Medical School     Fridrik Skulason, Iceland
    Dave Slate     Bradley Smith, UCLA    Richard S Smith, Cal State     Ryan Stanisfer, UNTG    Bertil Stenstroem, Stockholm University Computer Centre (QZ), Sweden *    Peter Svanberg, Royal Techn. HS, Sweden2    Andy Tanenbaum, Vrije U, Amsterdam, Netherlands+    Markku Toijala, Helsinki U of Technology     Rick Troxel, NIH 0    Warren Tucker, Tridom Corp, Mountain Park, GA    Dave Tweten, AMES-NAS    G Uddeborg, Sweden #    Walter Underwood, Ford Aerospace /    Pieter Van Der Linden, Centre Mondial, Paris     Ge van Geldorp, Netherlands;    Fred van Kempen, MINIX User Group, Voorhout, Netherlands     Wayne Van Pelt, GE/CRD *    Mark Vasoll, Oklahoma State U (V7 UNIX)'    Konstantin Vinogradov, ICSTI, Moscow     Paul Vixie, DEC    Dimitri Vulis, CUNY    Roger Wallace, Raytheon4    Stephen Walton, Calif State U, Northridge (Amiga)/    Jamie Watson, Adasoft, Switzerland (RS/6000) &    Rick Watson, U of Texas (Macintosh)    Robert Weiner    Lauren Weinstein *    Joachim Wiesel, U of Karlsruhe, Germany    Michael Williams, UCLA     Nate Williams, U of Montana    David Wilson )    Patrick Wolfe, Kuck & Associates, Inc. -    Gregg Wonderly, Oklahoma State U (V7 UNIX) 0    Farrell Woods, Concurrent (formerly Masscomp)2    Dave Woolley, CAP Communication Systems, London    Jack Woolley, SCT Corp     Frank Wortner    Ken Yap, U of Rochester    John Zeeff, Ann Arbor, MI @end<format>   @section(Introduction)  N C-Kermit is a communication software program written in C that provides a fullN implementation of the Kermit file transfer protocol, plus terminal connection,K modem dialing, file management, and a powerful script programming language. L An important goal of C-Kermit is transportability to different computers andG operating systems.  To date, C-Kermit (one release or another) has been L adapted to UNIX (most versions), VAX/VMS, Data General AOS/VS, IBM OS/2, theG Apple Macintosh, the Commodore Amiga, the Atari ST, Apollo Aegis, OS-9,  NCR 9800/VE, and others.  J C-Kermit offers you several methods of interaction.  On UNIX, VAX/VMS, andC most other systems, you have access to Kermit's interactive command E parser, and you can also invoke Kermit with command line options.  On K workstations like the Macintosh, there is a mouse-and-window interface with L pull-down menus, radio buttons, and so forth.  In some cases, you have both.  J Interactive operation gives you full access to all of C-Kermit's features.F Command-line invocation gives you access to a small but useful subset.= Command-line operation is described in Section @ref(-cmdlin).   K The main part of document concentrates on the general features of C-Kermit. G Sections specific to certain systems -- UNIX, VAX/VMS, OS/2, the Amiga, 2 OS-9 -- appear at the end.  Material about some ofB the implementations remains to be added.  Macintosh Kermit will be% documented in a separate publication.   G PLEASE NOTE: This manual describes a full-featured version of C-Kermit. F However, some computers do not have address spaces (or C compilers, orL linkers) capable of supporting all Kermit's features, so some features mightG be missing from your version.  See the file @q<ckuins.doc> for details.   - @section(Kermit Software for Other Computers)   F Kermit software is available from Columbia University for almost everyI known computer and operating system, written in a wide variety languages. D For a catalog of Kermit software and ordering information, write to:, @begin<format,leftmargin +2,above 1,below 1> Kermit Distribution 3 Columbia University Center for Computing Activities  612 West 115th Street  New York, NY  10025  USA  @end<format> or call:, @begin<format,leftmargin +2,above 1,below 1> (USA) (212) 854-3703 @end<format>  E MS-DOS Kermit for the IBM PC, PS/2, and compatibles is also available 7 in bookstores, computer stores, and from the publisher:   " @begin<text,leftmargin +2,above 1>M Christine M. Gianone, @i"Using MS-DOS Kermit", Second Edition, Digital Press, : Bedford, MA, 1991, 345 pages.  Packaged with MS-DOS Kermit> for the IBM PC, PS/2, and compatibles on a 5.25-inch diskette.  , @begin<format,leftmargin +4,above 1,below 1> Order Number: EY-H893E-DPN! Digital Press ISBN: 1-55558-082-3n! Prentice Hall ISBN: 0-13-952276-Xl  - Internation Edition Order Number: EY-H893E-DIr/ International Prentice Hall ISBN: 0-13-953043-6( @end<format>I US single-copy price: $34.95; quantity discounts available.  Available inlE computer bookstores or directly from Digital Press.  In the USA, calloC Digital Press toll-free 1-800-344-4825 to order; major credit cardsiG accepted.  Overseas, order through your bookstore or your local Digital> Equipment Corporation branch.e
 @end<text>  + @begin<transparent,need 6>@end<transparent>f, A German-language edition is also available:  * @begin<text,leftmargin +2,above 1,below 1>7 Christine M. Gianone, @i"MS-DOS Kermit, Das universelle*J Kommunikationsprogramm", Verlag Heinz Heise, Hannover, Germany (1991), 414( pages.  Translated by Gisbert W@. Selke.A Packaged with version 3.11 of MS-DOS Kermit for the IBM PC, PS/2,nG and compatibles on a 5.25-inch diskette, including German language helps files.  ISBN 3-88229-006-4
 @end<text>   @section(Interactive Operation)t  N C-Kermit's interactive command prompt is "@q(C-Kermit>)".  In response to thisO prompt, you can type any valid interactive C-Kermit command.  C-Kermit executessL the command and then prompts you for another command.  The process continues, until you instruct the program to terminate.  M Commands begin with a keyword, normally an English verb, such as "send".  YourE may omit trailing characters from any keyword, as long as you specifyYL sufficient characters to distinguish it from any other keyword valid in thatO field.  Certain commonly-@|used keywords (such as "send", "receive", "connect")mE also have special non-@|unique abbreviations ("s" for "send", "r" for  "receive", "c" for "connect").  E Command keywords can be entered in either upper or lower case, or any J combination.  This manual shows command keywords in uppercase for clarity.  J Certain characters have special functions while you are typing interactive	 commands:r+ @Begin(Description,leftmargin +8,indent -4)rE @q(?)@\Question mark, typed at any point in a command, will produce a:L message explaining what is possible or expected at that point.  Depending onM the context, the message may be a brief phrase, a menu of keywords, or a listgH of files.  Use "?" liberally to feel your way through Kermit's commands.  I @q(ESC)@\(The Escape or Altmode key) -- Request completion of the currentoK keyword or filename, or insertion of a default value.  The result will be az& beep if the requested operation fails.  1 @q(TAB)@\(The horizontal Tab key) -- Same as ESC.F  M @q(DEL)@\(The Delete or Rubout key) -- Delete the previous character from theoG command.  You may also use BS (Backspace, Control-H) for this function.s  F @q(^W)@\(Control-W) -- Erase the rightmost word from the command line.  0 @q(^U)@\(Control-U) -- Erase the entire command.  5 @q(^R)@\(Control-R) -- Redisplay the current command.d  + @q(^C)@\(Control-C) -- Interrupt a command.n  H @q(SP)@\(Space) -- Delimits fields (keywords, filenames, numbers) within
 a command.  M @q(CR)@\(Carriage Return) -- Enters the command for execution.  LF (Linefeed)r3 or FF (formfeed) may also be used for this purpose.S  H @q(\)@\(Backslash) -- Enter any of the above characters into the commandI literally.  To enter a backslash, type two backslashes in a row (@q[\\]).pK A backslash at the end of a command line causes the next line to be treated H as a continuation line; this is useful for readability in command files.H Backslash is also used to introduce special characters, variable names, > and functions.  These are explained in Section @ref(-bkslash).  G @q(^Z)@\(Control-Z) -- On systems (like Berkeley UNIX, Ultrix) with jobcF control, Control-Z is supposed to suspend Kermit, i.e. put it into theK @index<Background> @i<background> in such a way that it can be brought back F into the foreground (e.g. with an '@q<fg>' shell command) with all its settings intact. @End(Description)PI You may type the editing characters (@q[DEL], @q[^W], etc) repeatedly, toWM delete all the way back to the prompt.  No action will be performed until theeL command is entered by typing carriage return, linefeed, or formfeed.  If youJ make any mistakes, you will receive an informative error message and a newJ prompt -- make liberal use of `@q[?]' and ESC to feel your way through theN commands.  One important command is "help" -- you should use it the first time you run C-Kermit.s  K Comments may be entered as entire commands, or may appear at the end of anyeM command.  Comments are introduced by semicolon (@q[;]) or pound sign (@q[#]).   N Interactive C-Kermit accepts commands from files as well as from the keyboard.L When you start C-Kermit, the program looks for a special file, the @i<KermitM Initialization File> in your home or current directory (first it looks in the K home directory, then in the current one) and executes any commands it findslH there.  These commands must be in interactive format, not command-@|lineM format.  The name of the initialization file is @q<.kermrc> in UNIX and OS-9, 4 and @q<CKERMIT.INI> in most other operating systems.  6 Here is a brief list of C-Kermit interactive commands: @begin(format,spread 0)o1 @tabclear()@tabset(1.5inches,2.0inches,2.5inches)tB @>@q<;>@\  Introduce a full-line or trailing comment (also @q<#>).H @>@q<!>@\  Execute a system command or enter system command interpreter. @>@q<@@>@\  Same as @q<!>.; @>ASK@\  Prompt the user, store user's reply in a variable. A @>ASKQ@\  Like ASK, but, but doesn't echo (useful for passwords).2> @>ASSIGN@\  Assign an evaluated string to a variable or macro.) @>BUG@\  Instructions for reporting bugs. 6 @>BYE@\  Terminate and log out a remote Kermit server.- @>CD@\  Change Working Directory (also, CWD).a3 @>CLEAR@\  Clear communication device input buffer.m+ @>CLOSE@\  Close a log or other local file.h+ @>COMMENT@\  Introduce a full-line comment.uB @>CONNECT@\  Establish a terminal connection to a remote computer. @>DECLARE@\  Declare an array.> @>DECREMENT@\  Subtract one (or other number) from a variable.' @>DEFINE@\  Define a variable or macro.t# @>DELETE@\  Delete a file or files. " @>DIAL@\  Dial a telephone number.+ @>DIRECTORY@\  Display a directory listing. J @>DISABLE@\  Disallow access to selected features during server operation. @>DO@\  Execute a macro.% @>ECHO@\  Display text on the screen.n% @>ELSE@\  ELSE-part of an IF command.uF @>ENABLE@\  Allow access to selected features during server operation.! @>END@\  A command file or macro.aD @>EXIT@\  Exit from the program, closing all open files and devices.E @>FINISH@\  Instruct a remote Kermit server to exit, but not log out.n7 @>FOR@\  Execute commands repeatedly in a counted loop.s/ @>GET@\  Get files from a remote Kermit server.l= @>GOTO@\  Go to a labeled command in a command file or macro.b4 @>HANGUP@\  Hang up the phone or network connection.5 @>HELP@\  Display a help message for a given command.e4 @>IF@\  Conditionally execute the following command.7 @>INCREMENT@\  Add one (or other number) to a variable. G @>INPUT@\  Match characters from another computer against a given text.aD @>LOG@\  Open a log file -- debugging, packet, session, transaction.@ @>MAIL@\  Send a file as electronic mail to a specified address.1 @>MSEND@\  Multiple SEND -- send a list of files. 3 @>OPEN@\  Open a local file for reading or writing.l* @>OUTPUT@\  Send text to another computer.4 @>PAD@\  (X.25 version only) Give X.25 PAD commands.4 @>PAUSE@\  Do nothing for a given number of seconds.1 @>PRINT@\  Print a local file on a local printer.r= @>PUSH@\  Invoke host system interactive command interpreter.r2 @>PWD@\  Display current working device/directory. @>QUIT@\  Same as EXIT.M( @>READ@\  Read a line from a local file.0 @>RECEIVE@\  Passively wait for files to arrive.9 @>REDIAL@\  Redial the most recently dialed phone number.aF @>REINPUT@\  Reexamine text previously received from another computer.E @>REMOTE@\  Issue file management commands to a remote Kermit server.a& @>RENAME@\  Change the name of a file.0 @>RETURN@\  Return from a user-defined function.) @>RUN@\  Run a program or system command.g. @>SCRIPT@\  Execute a UUCP-style login script. @>SEND@\  Send files.l# @>SERVER@\  Begin server operation.J  @>SET@\  Set various parameters.+ @>SHOW@\  Display values of SET parameters. , @>SPACE@\  Display current disk space usage.A @>STATISTICS@\  Display statistics about most recent transaction. H @>STOP@\  Stop executing macro or command file and return to the prompt.5 @>SUSPEND@\  Put the Kermit program in the backgound.J' @>TAKE@\  Execute commands from a file. * @>TELNET@\  Start a TCP/IP TELNET session./ @>TRANLATE@\  Translate a file's character set.a3 @>TRANSMIT@\  Upload a file with no error checking.e' @>TYPE@\  Display a file on the screen. > @>VERSION@\  Display the program version number on the screen./ @>WAIT@\  Wait for the specified modem signals.iA @>WHILE@\  Execute commands repeatedly while a condition is true. & @>WRITE@\  Write text to a local file. @>XIF@\  Extended IF command.R @end(format)  M On most computers, C-Kermit can be started simply by typing the word "kermit"rG (followed by carriage return).  If no command-line "action options" are L included, Kermit will automatically enter interactive prompting mode.  Let'sI begin by looking at a few of C-Kermit's basic interactive commands.  MostcJ important of all when you are just beginning are the commands to exit from% the program and to get help about it.H  ' @subheading(The EXIT and QUIT Commands)o   Syntax: EXIT [ @i<number> ]  Syntax: QUIT [ @i<number> ]y  A These two commands are identical.  Both of them do the following:s   @begin(itemize,spread 0)L Hangs up the modem, if the communications line supports data terminal ready.  I Relinquish access to any communication line assigned via SET LINE, or anyl) network connection obtained via SET HOST.e  O Relinquish any uucp and multiuser locks on the communications line (UNIX only).S  # Close all open logs or other files.e  ; Attempt to insure that your terminal is returned to normal.t
 @end(itemize)DI After exit from C-Kermit, your default directory will be the same as when H you started the program.  The EXIT command is issued implicitly wheneverO C-Kermit halts normally, e.g. after a command line invocation, or after certaina kinds of interruptions.C  @ C-Kermit returns an exit status of zero, except when an error isK encountered, where the exit status is set to a nonzero number, depending onhL the operating system.  In UNIX, the exit status is the sum of 1 (if any SENDJ commands failed), 2 (if any RECEIVE or GET commands failed), and 4 (if anyN REMOTE commands failed).  If you give a number after the EXIT or QUIT command,  that number is returned instead.  + @begin(comment) (this is no longer true???)sI With background operation (e.g., `@q(&)' at end of invoking command line)rN driven by scripted interactive commands (redirected standard input and/or takeN files), any failed interactive command (such as failed dial or script attempt) causes the fatal error exit.
 @end(comment)y   @subheading(The HELP Command)w  ? Syntax: HELP [ { @i<command>, { SET, REMOTE } @i<parameter> } ]n  H Brief help messages or menus are always available at interactive commandK level by typing a question mark at any point.  A slightly more verbose formnE of help is available through the HELP command.  The HELP command with G no arguments prints a brief summary of how to enter commands and how to@H get further help.  HELP may be followed by one of the top-level C-KermitG command keywords, such as SEND, to request information about a command. G Commands such as SET and REMOTE have a further level of help.  Thus youi@ may type HELP, HELP SET, or HELP SET PARITY; each will provide a) successively more detailed level of help.    @subheading(The TAKE Command)c   Syntax: @q<TAKE >@i<fn1>  F The TAKE command instructs C-Kermit to execute commands from the namedH file.  The file may contain any interactive C-Kermit commands, includingE TAKE; command files may be nested to any reasonable depth, but it mayaJ not contain text to be sent to a remote system during the CONNECT command;D Use scripts for that (see sections @ref<-macros> and @ref<-scrcmd>).  K Echoing of commands from TAKE files and handling of errors during TAKE filer1 execution are controlled by the SET TAKE command.T  N Comments may be included in take-command files.  Whole-line comments may beginD with the word COMMENT.  Both trailing and whole-line comments can be6 introduced using semicolon or pound sign, for example: @begin(example)G9 COMMENT - Commands to dial out out using a Hayes modem...G2 set modem hayes        ; Specify the kind of modem1 set line /dev/ttyh8    ; Select a terminal device & set speed 19200        ; Set the speed( dial 7654321           ; Dial the number
 @end(example)a  N TAKE-command files are in exactly the same syntax as interactive commands.  IfK you want to include special characters like question mark or backslash that L you would have to quote with backslash when typing interactive commands, youM must quote these characters the same way in command files.  Long lines may be ; continued by ending them with a single backslash or a dash:l @begin(example)  set\ modem\ hayese set-
 line /dev- /ttyh8
 @end(example) M Continued lines cannot have trailing comments.  If you put a trailing comment M after the dash, then Kermit will not treat the line as continued.  If you putdM a dash at the end of a trailing comment, then Kermit will treat the next liner! as a continuation of the comment.l  K An implicit TAKE command is executed upon your C-Kermit initialization file,N (@q<.kermrc> in UNIX, @q<CKERMIT.INI> elsewhere) when C-Kermit starts up, uponK either interactive or command-line invocation.  The initialization file may I contain SET or other commands you want to be in effect at all times.  FordM instance, you might want override the default action when incoming files havelE the same names as existing files -- in that case, put a command like:C& @example(set file collision overwrite)  G Under UNIX, you may also use the shell's redirection mechanism to causes) C-Kermit to execute commands from a file:v @example(kermit < cmdfile)6 or you can even pipe commands in from another process: @example(command | kermit)  % @section(Establishing the Connection)e  F In order to talk about a connection between two computers, we a way toI distinguish between them.  The @i<local> computer is the one that you aretI using most directly -- a PC or workstation on your desk, or a timesharinglD computer that you are using from a terminal.  Kermit lets you make aK connection from the local computer to a @i<remote> computer, for example bymN dialing it up with a modem.  The Kermit program on your local computer is saidI to be in "local mode" and the Kermit program on the remote computer is ina "remote mode".  N C-Kermit can be used in either @i<remote> or @i<local> mode.  If you are usingK C-Kermit in remote mode, you can skip ahead to Section @ref(-filxfer), Fileo	 Transfer.n  I If you are using C-Kermit in local mode, you must have one of three kindsl& of connections to the remote computer: @begin(enumerate) H A hardwired asynchronous serial connection, either directly to the otherF computer, or through some kind of terminal server or switching device.  A A dialup connection, which you establish by dialing with a modem.e   A network connection.e @end(enumerate)oH To prepare C-Kermit for these connections, several preliminary steps are> necessary using the SET command, which is described in Section @ref(-setshow), below: @begin(enumerate)vK Direct connection: SET LINE @i<device-name>, SET SPEED @i<bits-per-second>.c  I Dialup connection, which you establish by dialing with a modem: SET MODEMdM @i<modem-type>, SET LINE @i<device-name>, SET SPEED @i<bits-per-second>, DIALl @i<phone-number>.c  G Network connection: SET HOST @i<network-host-name>.  If your version of I C-Kermit supports more than one type of network, give the appropriate SETPH NETWORK command before the SET HOST command (the default network type is9 TCP/IP).  (Also see the TELNET command, described below.)  @end(enumerate)tM In addition, you must establish whatever other communication related settings5G are appropriate for the connection, including PARITY, DUPLEX, FLOW, andeD HANDSHAKE.  Having done all this, you can use the CONNECT command toN begin a terminal session with the remote computer, and once connected, you can initiate file transfers.  ! @subheading(The SET LINE Command)s  # Syntax: @q<SET LINE> [ @i<device> ]l  G Close any previously open network, terminal, or modem connection.  If adM device name is given, try to open the device for communication.  If no deviceeK name is given, revert to the default mode of communication (normally remoteg mode).  ! @subheading(The SET HOST Command)e  1 Syntax: @q<SET HOST> [ @i<host> [ @i<service> ] ]i  I Close any previously open network, terminal, or modem connection.  If the,K current network type (see SET NETWORK) is TCP/IP, the @i<host> field can bekN specified as an IP host name or a numeric IP host address, followed optionallyM by a TCP service name or port number (the default service is TELNET, TCP port0H number 23).  If the network type is X.25, the @i<host> field is an X.121L address, and there is no service field.  If no host name is given, revert to9 the default mode of communication (normally remote mode).u    @subheading(The CONNECT Command)  H The CONNECT command (C is a special abbreviation for CONNECT) links yourM terminal to another computer as if it were a local terminal to that computer,cM through the device specified in the most recent SET LINE or SET HOST command,oI or through the default device if your system is a PC or workstation.  AllvM characters you type at your keyboard are sent out the communication line (andeD if you have SET DUPLEX HALF, also displayed on your screen), and allJ characters arriving at the communication port are displayed on the screen.N Current settings of speed, parity, duplex, and flow-@|control are honored, andH the data connection is 7 bits wide unless you have given the command SETJ TERMINAL BYTESIZE 8.  If you have issued a LOG SESSION command, everythingG you see on your screen will also be recorded to your session log.  This L provides a way to "capture" files from remote systems that don't have Kermit programs available.n  N To get back to your own system, you must type the "escape character", which isK Control-@|Backslash (@q[^\]) unless you have changed it with the SET ESCAPE G command, followed by a single-@|character command, such as C for "closenJ connection".  Single-@|character commands may be entered in upper or lower case.  They include:6 @begin(description,leftmargin +8,indent -6,spread 0.4)G @q<C>@\Return to C-Kermit.  If you gave an interactive CONNECT command, L return to the C-Kermit prompt.  If you gave a -c or -n option on the command; line, close the connection and return to the system prompt.r  - @q<B>@\Send a BREAK signal (about 0.275 sec).C  0 @q<L>@\Send a Long BREAK signal (about 1.5 sec).   @q<0>@\(zero) send a null.  1 @q<S>@\Give a status report about the connection.c   @q<H>@\Hangup the phone.  M @q<!>@\Escape to the system command processor "under" Kermit.  Exit or logoutC" to return to your CONNECT session.  " @q<Z>@\Suspend Kermit (UNIX only).  - @q<\nnn>@\A character in backslash-code form.   D @q[^\]@\Send Control-Backslash itself (whatever you have defined theC escape character to be, typed twice in a row sends one copy of it).@ @end(description)sF Uppercase and control equivalents for (most of) these letters are alsoJ accepted.  A space typed after the escape character is ignored.  Any other character will produce a beep.  M The connect command simply displays incoming characters on the screen.  It isnL assumed any screen control sequences sent by the host will be handled by theK firmware or emulation software in your terminal or PC@foot(Several C-Kermit H implementations include terminal emulators, notably Macintosh and OS/2).  A It is sometimes useful to see exactly what characters the host isdM transmitting, rather than having your terminal or emulator interpret them forcN you.  If you give the command SET DEBUG SESSION, then during CONNECT, C-KermitL will display control characters using "uparrow" notation, for example @q<^A>K for Control-A, @q<^B> for Control-B, etc, @q<^[> for ESC.  8-bit characters * are preceded by a tilde (@q<~>) character.  ) @subheading(The DIAL and REDIAL Commands)   ' Syntax: @q(DIAL )@i(telephone-number)@*  Syntax: @q(REDIAL)  4 @index<Modem>@index<Dialout Modem>@index<Autodialer>  N The DIAL command controls dialout modems; you should have already issued a SETL MODEM command to identify the type of modem to be used for dialing, and thenL SET LINE and SET SPEED commands to identify the terminal device to which theI modem is connected, plus any desired SET CARRIER and SET DIAL commands tof/ modify the behavior of the DIAL command itself.h  8 In the DIAL command, you supply the phone number and theG Kermit program feeds it to the modem in the appropriate format and then.J interprets dialer return codes and modem signals to inform you whether theK call was completed.  These actions are based upon built-in knowledge of theqM control sequences and responses of each make and model of modem that C-Kermitm knows about.  C The telephone-@|number may contain imbedded modem-@|dialer commandsnI appropriate to the selected modem type, such as comma for Hayes pause, oroM `@q(&)' for Ventel dialtone-@|wait and `@q(%)' for Ventel pause (consult youre modem manual for details).  M The REDIAL command is exactly like the DIAL command, except it uses the phoneA6 number you specified in your most recent DIAL command.  J At the time of this writing, support is included for the following modems: @begin(itemize,spread 0) AT&T 7300 Internal Modem  J AT&T 2212C, 2224B, 2224CEO, and 2296A switched network modems in AT&T mode  ( AT&T Digital Terminal Data Module (DTDM)   Cermetek Info-Mate 212Aa   Concord Condor CDS 220   Courier HSTI   DEC DF03-AC-   DEC DF100 Series   DEC DF200 Series   General DataComm 212A/ED    Hayes Smartmodem and compatibles   IBM/Siemens/Rolm 9751 CBX DCMc   Microcom AX-9624   Penril   Racal VadicE  ( Telebit Trailblazer, T1000, T1600, T2500   US Robotics 212A   Ventel
 @end(itemize)lE Support for new modems is added to the program from time to time; youI1 can check the current list by typing SET MODEM ?.g  I There are also two "generic" modem types -- DIRECT (i.e. no modem at all,cJ so that no attempt is made to deal with modem signals), and UNKNOWN (whichH tells C-Kermit to attempt to honor modem signals, but leaves the dialing6 mechanism unspecified).  NONE is a synonym for DIRECT.  J The device used for dialing out is the one selected in the most recent SETJ LINE command (or on a workstation, the default line if no SET LINE command was given).  On UNIX systems, 7 the DIAL command attempts to lock the terminal device'sa" path and to establish a call on anN exclusive basis.  If it is desired to dial a call and then return to the shellN (such as to do Kermit activities depending on standard in/out redirection), itA is necessary to place the dialed call under one device name (say,aK "@q</dev/cua0>") and then escape to the shell @i<within Kermit> on a linked-N device which is separate from the dialed line (say, "@q</dev/cul0>").  This isK the same technique used by uucp (to allow locks to be placed separately fors dialing and conversing).  O Because modem dialers have strict requirements to override the carrier-@|detect O signal most UNIX implementations expect, the sequence for dialing is more rigidu. than most other C-Kermit procedures.  Example: @begin(example)r @ux<kermit> 5 C-Kermit>@ux<set modem hayes>      ; SET MODEM first!>C C-Kermit>@ux<set carrier auto>     ; Then SET CARRIER if necessary,X3 C-Kermit>@ux<set line /dev/acu2>   ; Then SET LINE,E4 C-Kermit>@ux<set speed 2400>       ; Then SET SPEED,@ C-Kermit>@ux<set dial display on>  ; Then SET DIAL if necessary,7 C-Kermit>@ux<dial 9,5551212>       ; and finally, DIAL.>: Connected!                         ; If DIAL completes OK,5 C-Kermit>@ux<connect>              ; you can CONNECT.U @i(logon, do things) @ux<^\c>
 C-Kermit> ...UB C-Kermit>@ux<quit>                 ; Disconnect & unlock the line.
 @end(example)p  N In general, C-Kermit requires that the modem provide the "carrier detect" (CD)G signal when a call is in progress, and remove that signal when the call M completes or the line drops.  If a modem switch setting is available to forcesO CD, it should normally not be in that setting.  C-Kermit also requires (on most H systems) that the modem track the computer's "data terminal ready" (DTR)M signal.  If a switch setting is available to simulate DTR asserted within theoK modem, then it should normally not be in that setting.  Otherwise the modemfN will be unable to hang up at the end of a call or when interrupts are received
 by Kermit.  J If you want to interrupt a DIAL command in progress (for instance, becauseE you just realize that you gave it the wrong number), type a Control-CnF get back to command level.  If you are a UNIX user and your "interruptD character" is defined as something besides Ctrl-C, use that instead.  L PROBLEMS: The DIAL command hangs up the phone (see HANGUP) prior to dialing.M Because of the problems described for HANGUP, certain UNIX configurations areaL unable to use DIAL when it does this.  To work around this problem, give theJ command SET DIAL HANGUP OFF before giving the DIAL command.  If DIAL stillG doesn't work right, start over again but this time give the command SETb CARRIER OFF prior to SET LINE.  K See the command summary for a description of SET DIAL options.  You can use J SET DIAL to modify the modem initialization string, the timeout period for call completion, and so on.   N Hayes and Hayes-compatible, as well as Telebit, modem dialing is supported forN both word and digit result codes, and C-Kermit will also attempt to adjust itsN communication speed in case these modems complete a call at a lower speed thanI it was placed at (if you have a speed-matching modem, you can defeat thisiH action by giving the command SET DIAL SPEED-MATCHING ON before dialing).   @subheading(The HANGUP Command)c  H The HANGUP command attempts to hang up the modem on a local-mode dialoutH connection established by SET LINE, or to hang up the network connectionG established by SET HOST, in order to break the connection.  On terminaltK devices, Kermit accomplishes the hangup by momentarily turning off the Datat# Terminal Ready (DTR) RS-232 signal.m  M The means used to drop DTR and bring it back up again are highly dependent on G the computer, the version of UNIX, the communication device, the devicedK driver, the modem being used, and even the cable that connects the modem toIN the communication device.  Therefore you might find that this command fails to operate as it should.i  J If the HANGUP command fails to hang up a phone connection, then maybe yourF modem is configured to ignore DTR.  You should make sure your modem isN configured to pay attention to the computer's DTR signal.  Another possibilityN is that your cable is giving the modem a constant DTR signal, looped back fromC its own DSR signal; in that case, replace your cable with a regularn straight-through modem cable.s  H If the HANGUP command does indeed hang up the phone connection, but thenL you can't communicate with the modem any more to establish a new connection,M your version of UNIX may have dropped the DTR signal without bringing it backfJ up again properly.  To work around this problem, give the SET LINE commandL (with no device name) to close the current device, and then another SET LINE8 command specifying the original device to open it again.   @subheading(The TELNET Command)T  / Syntax: @q(TELNET) [ @i<host> [ @i<service> ] ]T  N The TELNET command can be used in C-Kermit implementations that support TCP/IPK networking.  TELNET is simply a shorthand for SET HOST followed by CONNECT.CI If you give an IP host name (or number), Kermit closes any currently open L connection and begins a new one to the given host.  If the TCP/IP connectionG is made successfully, Kermit puts itself into CONNECT mode for terminaltJ emulation.  If you give a TELNET command without a hostname, the currentlyJ active TCP/IP session (if any) is resumed; if there is no current session,I you'll get an error message.  The @i<service> can be a TCP port number orE1 service name; the default is 23, the TELNET port.a   @section(File Transfer)n @label(-filxfer)  M Kermit programs can transfer files correctly and completely, using the KermitgL file transfer protocol.  A Kermit program must be running on both computers. Here is the normal procedure:d @begin(enumerate)a" Run Kermit on your local computer.  M Make the appropriate communication settings (such as modem type, line, speed,S
 parity, etc).i  B Establish a connection to the remote computer (DIAL if necessary).   CONNECT to the remote computer.a  + Log in to the remote computer if necessary.l  F Start Kermit on the remote computer and tell it to send (or receive) a file (or files).  $ "Escape back" to the local computer.  ? Tell the local computer to receive (or send) a file (or files).  @end(enumerate)   G When transferring files, C-Kermit converts between upper and lower casepM filenames and between LF and CRLF line terminators automatically, unless told N to do otherwise.  When binary files must be transferred, the program should beK instructed not to perform LF/CRLF conversion (@q[-i] on the command line ora/ SET FILE TYPE BINARY interactively; see below).   B If C-Kermit is in local mode, the screen is continously updated toL show the progress of the file transer.  A dot is printed for every four data) packets, other packets are shown by type: 6 @begin(description,leftmargin +6, indent -2, spread 0)! I@\Exchange Parameter Informationn   R@\Receive Initiationr   S@\Send Initiatiationt   A@\Attribute Packeti   F@\File Header   G@\Generic Server Commandh   C@\Remote Host Command  ! N@\Negative Acknowledgement (NAK)x   E@\Fatal Error   T@\Indicates a timeout occurrede  A Q@\Indicates a damaged, undesired, or illegal packet was receivedt  + @q<%>@\Indicates a packet was retransmittede @end(description)mF You may type the following interruption commands during file transfer:4 @begin(description,leftmargin +6,indent -2,spread 0)> F@\Interrupt the current File, and go on to the next (if any).  @ X@\Interrupt the entire Batch of files, terminate the operation.   R@\Resend the current packet.m  K E@\Error: terminate the current operation immediately and return to prompt.o  5 A@\Display a status report for the current operation.r @end(description)m  ) @i(EMERGENCY EXIT:)@index<Emergency Exit> N When running C-Kermit in remote mode, if you have started a protocol operationI (sending or receiving a file, server command wait, etc), you can type twonC Control-C's directly to the UNIX Kermit program ("connect" first if  necessary):b @display<Control-C Control-C>@' This will cause the program to display,t @display<@q[^C^C...]>n& and return you to the C-Kermit prompt.  L Before initiating a file transfer, you should be sure that all communicationL and protocol-related settings are correct.  Version 5A of Kermit attempts toG make things easier for you in this area in several ways, for example byoI recognizing file attributes (text or binary, character set, etc) from theiL other Kermit if it sends them.  @index<Parity>If your parity is set to NONE,N C-Kermit automatically recognizes parity bits on received packets, and adjustsI its parity accordingly.  But it's better to set these C-Kermit parameters E directly yourself to avoid any confusion that might result from theseo automatic adjustments.   @subheading<The SEND Command>>  % Syntax:  @q<SEND >@i(fn) [ @i<rfn1> ]i  M Send the file or files denoted by @i(fn) to the other Kermit, which should be G running as a server, or which should be given the RECEIVE command.  ThecC SEND command may be abbreviated to S, even though S is not a uniquesK abbreviation for a top-level C-Kermit command.  Each file is sent under itsmE own name (as described above, or as specified by the 'set file names' E command).  If the second form of the SEND command is used, i.e@. withaF @i(fn1) denoting a single file, @i(rfn1) may be specified as a name to send it under.  For example:" @example[send sows.ear silk.purse]G sends the file @q[sows.ear] but tells the other Kermit that its name ism @q[silk.purse].e   @subheading<The MSEND Command>  7 Syntax:  @q<MSEND >@i(fn) [ @i<fn> [ @i<fn> [ ... ] ] ].  L The MSEND command also sends one or more files, but unlike the SEND command,L it allows you to give a list of files to send, and it does @i<not> allow youM to specify an alternate name.  The MSEND file specifications are separated bya spaces.e  % @index<Wildcard>@index<Metacharacter>aL Both the SEND and MSEND commands allow you to use wildcard (meta) charactersL to specify groups of files.  Exactly which wildcard characters are availableL depend on the host operating system and other factors.  In VAX/VMS, they areI `@q[*]' and `@q[%]'.  In UNIX they are `@q[~]', `@q[*]', and `@q[?]'.  IfoJ `@q[?]'  is to be included, it must be prefixed by `@q[\]' to override itsM normal function of providing help.  The `@q[*]' character matches any string,rA and `@q[?]' (UNIX) or `@q[%]' (VMS) matches any single character.i  D When @i(fn) contains `@q[*]' or `@q[?]' characters, there is a limitG to the number of files that can be matched, which varies from system tooJ system.  If you get the message "Too many files match" then you'll have toI make a more judicious selection.  For example, if @i(fn) was of the form: ( @example(usr/longname/anotherlongname/*)K then C-Kermit's string space will fill up rapidly -- try using CD to changecA your directory to the path in question and reissuing the command.   M Wildcards do not descend through a directory tree.  Only files in the currentX  or specified directory are sent.  I In UNIX versions of C-Kermit only, `@q[~]' is treated as a meta charactertI if it is the first character in the file specification. If it is followedrJ immediately by a slash, a space, or end of line, then your login directoryL name is substituted.  If it is followed immediately by a username, then thatM user's login directory name is substituted.  (In VAX/VMS, you can use logicalT6 names in the file specification for the same purpose.)   @b<Wildcard Notation for UNIX>  N Normally, C-Kermit expands wildcard characters itself by searching through theF disk and matching names against the pattern you specify.  But Kermit'sJ pattern-matching abilities are limited to the metacharacters listed above.I UNIX shells like csh and ksh, on the other hand, offer notations for filedH groups, like `@q([bcdfhjlns]og)' or `@q(*.{txt,doc})' that Kermit cannotF handle on its own.  Kermit lets you get at these capabilities with the command:  , @q<SET WILDCARD-EXPANSION { KERMIT, SHELL }>  J The default is KERMIT, meaning Kermit itself expands wildcards in SEND andJ MSEND, as well as what it receives while in server mode from GET commands.L The SHELL option means Kermit calls upon the user's preferred shell (via theG SHELL environment variable, or failing that, the user's login shell vian getpwuid) to expand them.c  J Advantages of the SHELL method include more flexibility in file selection,K consistency with the user's shell, and ability to handle a larger number of\G files.  But there are drawbacks.  It's noticably slower.  Characters insJ filenames that are special to the shell (like |, &, `, etc) must be quotedH with \ (this is not necessary when Kermit expands).  And the same KermitE command (SEND, MSEND, or GET sent to a server) may behave differentlydO depending on what your login shell is.  For example, @qq<{aaa,bbb}> is expanded.L by the csh, but taken literally by sh and ksh; @qq<[a-z]> is expanded by csh# and ksh, but taken literally by sh.e  H The expansion is done by passing "echo " concatenated with your filespecM to the shell.  This assumes that echo is a built-in shell command, or if it'slI not, then the echo program is in the user's path (risky).  "echo" is usedxI rather than "ls -d" because ls says "xxx not found" if xxx does not existeN (unfortunately, the csh version of "echo" says "echo: no match" if you give itJ a string containing metacharacters and no files match, wherease sh and kshN simply echo the string back at you).  It doesn't matter much, because C-KermitM checks each word that is returned for its existence as a file (but of course,eJ you could have a file called "echo:", "no", or "match"...).  And then whatN happens if your have a file called "@q<-n>"?  ("@q<echo> @q<-n>" is a command.H Refer to a file called "@q<-n>" in the current directory as "@q<./-n>").   @b<Text vs Binary Files>  & @index<Binary Files>@index<Attributes>J When C-Kermit sends each file, it also sends certain information about theI file in an "attribute packet", provided the other Kermit agrees to acceptRB attribute packets.  This information includes the size, type (textN or binary, determined from the "-i" command-line option or the "set file type"N command), creation date, and a code to let the other Kermit know that the fileL is being sent from a UNIX system.  The other Kermit may accept or refuse theM file based upon these attributes, for example, if it doesn't have enough diske, space to store a file of the specified size.  I The file type attribute allows C-Kermit, when sending a file, to tell the I receiving whether it should be in text or binary mode.  Therefore, if theoK receiving Kermit has this feature, it is not necessay to give it a SET FILEV, TYPE command to "match modes" with C-Kermit.  L @i<Note> -- C-Kermit sends only from the current or specified directory.  ItD does not traverse directory trees.  If the source directory containsK subdirectories, they will be skipped.  By the same token, C-Kermit does notbL create directories when receiving files.  If you have a need to do this, youA can pipe tar through C-Kermit, as shown in the example in sectionrJ @ref(-cmdlin), or under AT&T System III/V UNIX you can use cpio, or BACKUP under VAX/VMS, etc.   A @i<Another Note> -- The SEND command skips over "invisible" filesoO that match the file specification; UNIX systems usually treat files whose names M start with a dot (like @q(.login), @q(.cshrc), and @q(.kermrc)) as invisible.0C If you want to send these, include the dot in your filespec, as in:e @example(send .*)o    @subheading<The RECEIVE Command>   Syntax:  @q<RECEIVE> [@i<fn1>]  M Passively wait for files to arrive from the other Kermit, which must be given K the SEND command -- the RECEIVE command does not work in conjunction with aNM server (use GET for that).  If @i(fn1) is specified, store the first incomingdC file under that name.  The RECEIVE command may be abbreviated to R.   & @index(Binary Files)@index<Attributes>F Incoming file data is normally decoded and stored according to whetherF C-Kermit is in text or binary mode.  But if the other Kermit sends theI file-type attribute, this will override C-Kermit's file-type setting on a M per-file basis.  Therefore, it is possible for another Kermit program to sendoM C-Kermit a mixture of text and binary files, so long as the type of each fileeL is indicated in the Attribute packet.  For text files, C-Kermit will performO character-set translation if a known transfer character set is indicated in thee; Attribute packet (see section on International Characters).l  H C-Kermit also attempts to store the incoming file with the creation dateH that is specified in the Attribute packet.  C-Kermit does not attempt toB verify disk space against the announced size of the incoming file.  J You can control C-Kermit's use of these attributes using the SET ATTRIBUTE command.  # @subheading(The STATISTICS Command)p  M The STATISTICS command displays information about the most recent Kermit filemM transfer or other protocol transaction, including file and communication linetN input and output, timing and efficiency, as well as what encoding options wereH in effect (such as 8th-bit prefixing, repeat-@|count compression, packet lengths, window size).  ( @subheading(Non-Protocol Data Transfers)  M It is also possible to transfer files with other computers that do not have a N Kermit program available.  To send a file to such a computer, use the TRANSMIT command:   Syntax: @q<TRANSMIT> @i<fn1>  I This command sends the named file without error checking, obeying currente< settings for file type (text or binary), parity, and duplex.  N In text mode, send the file a line at a time, with character translations doneH according to the current file and transfer character sets, using the SETN TRANSMIT PROMPT character (linefeed, @q<\10>, by default) as a line turnaroundE character.  That is, send a line from the file, wait until the prompttM character comes in response, then send the next line, and so on.  If zero (0)oG is specified for the prompt character, then send the whole file withouteJ waiting for any response or echo from the host.  Don't try this unless youK know that the host can successfully process long continuous bursts of inputeL characters.  Each line is terminated by a carriage return, just as you wouldH type it at a terminal.  Linefeeds are stripped unless you have given theM command SET TRANSMIT LINEFEED ON.  The computer to which you are transmitting K the file should be prepared to receive it, for instance into a text editor.e  L In binary mode, send all the characters of the file with no modification andF no line turnaround handshake (the TRANSMIT PROMPT setting is ignored).) Use binary mode only if you know that thecE computer or device to which you are transmitting the file can receivei/ arbitrary patterns of characters at full speed.T  N If you want to transmit 8-bit data over a 7-bit connection (i.e. PARITY is notJ NONE), you can use SET TRANSMIT LOCKING-SHIFT ON to have Kermit send SO/SIM shifts around your 8-bit characters.  The TRANSMIT command can be interruptedl) by typing Ctrl-C.  Also see SET TRANSMIT.w  H The opposite of TRANSMIT is LOG SESSION, which lets you capture files orN screen data from remote computers during CONNECT, also without error checking.  M XMIT may be used as a synonym for TRANSMIT in the TRANSMIT, SET TRANSMIT, andb SHOW TRANSMIT commands.D  ) @section(Being and Using a Kermit Server)b @label(-server)P  M The SERVER command places C-Kermit in "server mode" on the currently selectedaM communication device or network connection.  All further commands must arrive M as valid Kermit packets from the Kermit on the other end of the line.  If youeK are running C-Kermit on the remote computer, then you should escape back tonN your local computer after you give C-Kermit the SERVER command, and then issueL all further commands to the C-Kermit server from your local Kermit's commandN prompt.  It is also possible to work the other way: your local computer is theJ Kermit server and the remote computer issues the commands -- this can onlyL work if the remote Kermit is driven by a TAKE command file (which should end with the command FINISH).c  J The C-Kermit server can respond to the following commands from the client:5 @begin(format,spread 0,above 1,below 1,leftmargin +2)e @tabclear()@tabset(2.25inches)) @ux<Client Command>@\@ux<Server Response>t   GET@\  Sends files   SEND@\  Receives files=   MAIL@\  Sends incoming files as e-mail to specified addresse#   BYE@\  Attempts to log itself outs4   FINISH@\  Exits to level from which it was invoked:   REMOTE CD@\  Changes working directory (also, remote cd)-   REMOTE DIRECTORY@\  Sends directory listingv    REMOTE DELETE@\  Removes files)   REMOTE HELP@\  Lists these capabilitiesa.   REMOTE HOST@\  Executes a UNIX shell command<   REMOTE KERMIT@\  Sends a Kermit command to a Kermit server=   REMOTE LOGIN@\  Login to a Kermit server that requires thiso.   REMOTE LOGOUT@\  Logout from a Kermit server/   REMOTE PRINT@\  Receives a file and prints ito$   REMOTE SET@\  Changes its settings.   REMOTE SPACE@\  Reports about its disk usage+   REMOTE TYPE@\  Sends files to your screenm%   REMOTE WHO@\  Shows who's logged iny @end(format)  J If the Kermit server is directed at an external line (i.e. it is in "localN mode") then the console may be used for other work if you SET FILE DISPLAY OFFL and run it in the background; normally the program expects the console to beG used to observe file transfers and enter status queries or to interruptTN commands.  The way to get C-Kermit into background@index<Background> operationM from interactive command level varies from system to system (e.g. on BerkeleyhI UNIX you would halt the program with @q(^Z) and then use the C-Shell 'bg'xH command to continue it in the background).  The more common method is toE invoke the program with the desired command line arguments, including ) "@q(-q)", and with a terminating "@q(&)".e  G The C-Kermit server will accept a list of files in GET commands sent byaH the client, similar to the list you can give to the MSEND command, e.g.: @begin<example>a3 MS-Kermit>@ux[get ~joe/new.txt /etc/termcap ../*.c]c
 @end<example>NJ The file specifications are separated by spaces.  If you need to include a< space in a filename, quote it with a backslash, for example: @begin<example>e8 MS-Kermit>@ux<get node"user\ passwd"::dev:[dir]name.ext>
 @end<example>m4 If you need to include a backslash, use two of them.  J When the UNIX Kermit server is given a REMOTE HOST command, it executes itM using the shell invoked upon login, e.g. the Bourne shell, the Korn Shell, oreH the Berkeley C-Shell (or whatever the user has set her SHELL environment variable to be).  M The server can issue periodic NAK packets.  You can control the rate at whichIK this happens via SET SERVER TIMEOUT.  Specifiying a value of zero instructshM C-Kermit not to do this at all.  A nonzero value, n, makes a NAK appear everyoM n seconds during server command wait.  This is useful if the client Kermit isbJ not capable of timeouts, and a packet that it sends to the server is lost.# The default server timeout is zero.r  M SECURITY.  Before putting C-Kermit into server mode, you can give it commandscN to restrict the types of access it allows to clients.  The command is DISABLE.K You can turn these accesses back on using the ENABLE command.  Here are thegK items that can be controlled in this way, with the effect of DISABLE noted.aK CAUTION: If you leave HOST enabled, the client can get around some of these ' restrictions with REMOTE HOST commands.s @begin(description,spread 0)> BYE@\Ignore BYE commands from the client, stay in server mode.  K CD@\Don't let the client change directories, or send files to, or get files.L from, or delete or type files in, any but the current directory, nor inquire- about space in any but the current directory.l  . DELETE@\Don't let the client delete any files.  < DIRECTORY@\Don't let the client request a directory listing.  D FINISH@\Ignore FINISH commands from the client, stay in server mode.  $ GET@\Don't let the client GET files.  2 HOST@\Ignore REMOTE HOST commands from the client.  7 SEND@\Don't accept files that the client tries to send.   0 SET@\Refuse REMOTE SET commands from the client.  4 SPACE@\Refuse REMOTE SPACE commands from the client.  2 TYPE@\Refuse REMOTE TYPE commands from the client.  0 WHO@\Refuse REMOTE WHO commands from the client.   ALL@\All of the above. @end(description)g  " @subheading(Using a Kermit Server)  A C-Kermit may itself request services from a remote Kermit server.fM To send a file to a Kermit server, use the SEND command, just as you would to)M send a file to a Kermit program that has been given the RECEIVE command.  But N you cannot use the RECEIVE command to get a file from a Kermit server, becauseM the RECEIVE command just waits passively for a file to arrive, but the servertJ has not been told which file to send.  For this, you need the GET command:   Syntax:@q<  GET >@i<rfn> @begin(example)E     @i<or>: GETy             @i(rfn))             @i(fn1)d
 @end(example)l  I The GET command requests a remote Kermit server to send the named file ore+ files, it must be used in place of RECEIVE.nA Since a remote file specification (or list) might contain spaces,tM which normally delimit fields of a C-Kermit command, an alternate form of thenN command is provided to allow the inbound file to be given a new name: type GETM alone on a line, and you will be prompted separately for the remote and local1! file specifications, for example:m @Begin(Example)s C-Kermit>@ux(get) -  Remote file specification: @ux(profile exec)l0  Local name to store it under: @ux(profile.exec)
 @End(Example)tI If a `@q[?]' is to be included in the remote file specification, you musttI prefix it with `@q[\]' to suppress its normal function of providing help.l  D If you have started a multiline GET command, you may escape from itsL lower-@|level prompts by typing a carriage return in response to the prompt, e.g. @Begin(Example)E C-Kermit>@ux(get)o$  Remote file specification: @ux(foo)@  Local name to store it under: @i<(Type a carriage return here)> (cancelled)t	 C-Kermit>a
 @End(Example)c  J After the GET command has been entered, the file transfer proceeds exactlyD as if you had given a SEND command to the other Kermit and a RECEIVE command to this one.  I In addition to SEND and GET, the following commands may also be sent fromiK C-Kermit to a Kermit server.  If the server does not support a command thattL you send to it, it will respond with a message like "Unknown server command"" or "Unimplemented REMOTE command". @begin(d84)aM REMOTE CD [@i(directory)]@\Request the server to change its default directory I (and/or device) to the one you specify.  If none is specified, the serveryK is requested to return to its primary default directory (normally the logine directory).i  N REMOTE DELETE @i<rfn>@\The server is requested to delete the specified file or files.  G REMOTE DIRECTORY [@i(rfn)]@\The server is requested to send a directory J listing of the specifed files.  If no files are specified, then the server@ should send a listing of all the files in the current directory.  I REMOTE HELP@\The server is requested to send to your screen a list of the-9 commands that you may issue to it from your local Kermit.   J REMOTE HOST @i(command)@\The server is requested to ask its host operating$ system to execute the given command.  N REMOTE KERMIT @i(command)@\The remote server is requested to execute the given5 command, which is in its own (Kermit program) syntax.s  M REMOTE LOGIN @i(userid) @i(password) [@i(account)]@\If a remote Kermit server K has been set up to require to provide a user ID and password before you cantH gain access to it, use this command to send it the user ID and password.  K REMOTE LOGOUT@\Remove your access from a remote Kermit server that you havei REMOTE LOGIN'ed to.   M REMOTE PRINT @i(file) [@i(options)]@\The file is sent to the server, which is,M requested via Attribute packet to print it on its printer using the specified) print options.  L REMOTE SET @i<parameter> @i<value>@\The server is requested to set the givenE parameter to the specified value.  Use question mark to find out whatsJ parameters and values are available.  The meanings of these parameters andK values are explained in the section on the SET command, below.  Perhaps then9 most useful one is REMOTE SET FILE TYPE { TEXT, BINARY }.e  K REMOTE SPACE [@i(dir)]@\The server is requested to report on available diskpN space in the specified device and/or directory, or in the current area if none
 specified.  M REMOTE TYPE [@i(rfn)]@\The server is requested to send the specified file forr display on your screen.r  N REMOTE WHO [@i(user)]@\The server is requested to send a list of the users whoN are logged in on its computer.  If a username is given, information about that user is requested.  M BYE @i(and) FINISH:@\When connected to a remote Kermit server, these commandsiK cause the remote server to terminate; FINISH returns it to Kermit or system}O command level (depending on the implementation or how the program was invoked);n' BYE also requests it to log itself out.b	 @end(d84)h  & @section(International Character Sets)  L Text files may be written in languages other than English, and in most casesK that means that they contain non-ASCII characters such as accented letters,hH special punctuation marks, etc.  Many different character sets have beenM devised to represent different languages.  These character sets are sometimescM specific to a particular computer manufacturer, and sometimes they conform toaJ one standard or another.  The Kermit file transfer protocol permits KermitM programs to exchange files written in different character sets by translatingcK between each computer's local file character set and a standard set that is"4 used "on the wire".  Here are the relevant commands: @begin(d84)-K SET FILE TYPE TEXT@\Character set translation is not done at all unless thee file type is text.  L SET TRANSFER CHARACTER-SET @i<name>@\Tell C-Kermit which character set is toE be used on the wire, i.e. within the Kermit packets.  The choices areaN TRANSPARENT (no translation, this is the default), ASCII (translate to/from USF ASCII), LATIN1 (ISO 8859-1 Latin Alphabet 1), CYRILLIC-ISO (ISO 8859-5M Latin/Cyrillic Alphabet), and JAPANESE-EUC.  Synonym: SET XFER CHARACTER-SET."  M SET FILE CHARACTER-SET @i<name>@\Tell C-Kermit which character set is used in I the local file, ASCII, or any of a dozen or so 7-bit national replacementeL character sets (NRCs) such as ITALIAN, NORWEGIAN, etc, or an 8-bit characterD set like LATIN1, DEC-Multinational, DG-International, NEXT (for NeXTL workstations), CP437 or CP850 (for IBM or Xenix systems), APPLE (for A/UX onO the Macintosh); CP866, KOI8-CYRILLIC, CYRILLIC-ISO, and SHORT-KOI for Cyrillic; D and JAPANESE-EUC, DEC-KANJI, SHIFT-JIS, and JIS7 for Japanese Kanji.  E SET LANGUAGE @i<name>@\Enable certain language-specific translations,rF especially for DUTCH, ICELANDIC, GERMAN, RUSSIAN, and the ScandinavianH languages.  In particular, SET LANGUAGE RUSSIAN makes Kermit treat ASCIIH as if it were SHORT-KOI when it is a FILE or TRANSFER character set, andJ the corresponding TRANSFER or FILE character set is an 8-bit Cyrillic set.  K TRANSLATE @i<file1> @i<cs1> @i<cs2> [ @i<file2> ]@\Translate the local fileyN @i<file1> from the character set @i<cs1> into the character set @i<cs2>.  BothK character sets may be selected from C-Kermit's repertoire of file characterIL sets.  The result is stored in @i<file2> or (if @i<file2> is not specified),N displayed on the screen.  If LANGUAGE is set to RUSSIAN, ISO Latin-Cyrillic isM used as the intermediate standard character set during translation, otherwiseV; ISO Latin Alphabet 1 is used.  Does not yet work for Kanji.t	 @end(d84)t4 The SET commands are described in more detail later.  I When sending a file, C-Kermit translates the file from the specified file N character set into the specified transfer character set, and an identifier forM the selected transfer character set is included in the file attribute packet,BN if use of attribute packets has been negotiated and a SET ATTR [CHARACTER-SET] OFF command has not been given.i  M When receiving, C-Kermit translates from the specified transfer character set,F to the specified file character set or, if a transfer character set isL identified in the incoming attribute packet it is used instead.  If the fileK character set is ASCII and special characters are being received, then theydH are translated by stripping diacritical marks and aiming for the closestL possible 1-to-1 translation on a per-character basis.  But if a SET LANGUAGEI command has been given, special translations can be done.  For example iftN LANGUAGE has been set to GERMAN and the local file character set is ASCII, andJ a file arrives with a transfer character set of LATIN1, then C-Kermit willL translate German umlaut-vowels into the corresponding vowels followed by theM letter e, and German double-s into two s's.  Similar translations take effectI for other languages.  K If unwanted effects appear because of Kermit's translation, you can disablef2 this feature with SET ATTRIBUTE CHARACTER-SET OFF.  I When transferring text that contains long runs of 8-bit data over a 7-bittM communication channel, efficiency can be improved with the following command:m @begin(d84)kI SET TRANSFER LOCKING-SHIFT { OFF, ON, FORCED }@\Specifies whether lockingtN shifts should be used by Kermit when encoding and decoding packets.  A lockingI shift is a special character, Ctrl-N (Shift-Out, SO), that means that allTK the following characters, up to the next Ctrl-O (Shift-In, SI), are to havelN their 8th bits set to 1 upon receipt.  For long runs of 8-bit characters, thisJ is more efficient than Kermit's regular "single shift" method of prefixingH each 8-bit character by an @q<&>-sign.  Synonym: SET XFER LOCKING-SHIFT. The options are:
 @begin<d4>M ON@\This is the default setting.  If PARITY is not NONE, try to negotiate thedL use of locking shift protocol with the other Kermit, and use it if the other@ Kermit agrees.  If PARITY is NONE, locking shifts won't be used.   OFF@\Don't use locking shifts.  N FORCED@\Use locking shifts, regardless of the parity setting and negotiations.M Automatically disables the use of 8th-bit prefixing (single shifts).  For the L file sender, this command lets data be sent to the receiver with embedded SOE and SI characters, which can be processed properly by many terminals,eL printers, and other devices.  For the file receiver, this command forces the@ treatment of SO and SI characters in the data as shift commands. @end<d4>	 @end(d84),I Locking shifts are most effective for text written in non-Roman alphabetsrE and encoded in standard 8-bit character sets like ISO Latin/Cyrillic,hE ISO Latin/Arabic, ISO Latin/Hebrew, ISO Latin/Greek, or Japanese EUC.wF Locking-shift status is displayed by the SHOW and STATISTICS commands.   @section(Logging Things)  D Kermit's actions during terminal connection and file transfer can be. logged in several ways, using the LOG command:  > Syntax: @q<LOG {DEBUGGING, PACKETS, SESSION, TRANSACTIONS} >@~# [ @i(fn1) [ { APPEND, NEW }=NEW ] ]t  C C-Kermit's progress may be logged in various ways.  The LOG command E opens a log, the CLOSE command closes it.  In addition, all open logstF are closed by the EXIT and QUIT commands.  A name may be specified forF a log file; if the name is omitted, the file is created with a defaultE name as shown below.  If the keyword APPEND is included at the end ofsM the command, then if the specified file exists, it is appended to rather thand: written over; if it does not exist, a new file is created.  
 @begin(d4)I LOG DEBUGGING@\This produces a voluminous log of the internal workings ofdO C-Kermit, of use to Kermit developers or maintainers in tracking down suspectednA bugs in the C-Kermit program.  Use of this feature slows down the E Kermit protocol and fills up your disk.  Default name: @q(debug.log).n  L LOG PACKETS@\This produces a record of all the packets that go in and out ofI the communication port.  This log is of use to Kermit maintainers who areeE tracking down protocol problems in either C-Kermit or any Kermit thatt9 C-Kermit is connected to.  Default name:  @q(packet.log).   N LOG SESSION@\This log will contain a copy of everything you see on your screenI during the CONNECT command, except for local messages or interaction withd7 local escape commands.  Default name:  @q(session.log).2  L LOG TRANSACTIONS@\The transaction log is a record of all the files that wereK sent or received while transaction logging was in effect.  It includes timedC stamps and statistics, filename transformations, and records of anyvF errors that may have occurred.  The transaction log allows you to haveC long unattended file transfer sessions without fear of missing someE7 vital screen message.  Default name:  @q(transact.log).e @end(d4)H The CLOSE command closes the named log, e.g. CLOSE DEBUG, CLOSE SESSION.  M @i<Note:>  Debug and Transaction logs are a compile-time option; C-Kermit mayvI be compiled without these logs, in which case it will run faster, it willEJ take up less space on the disk, but the commands relating to them will not be present.O   @section(Local File Management)u  F C-Kermit allows the following local file management functions from its interactive command level:+ @begin(description,leftmargin +4,indent -4)e CD [@i<directory-name>]@\ L Changes Kermit's working device and/or directory to the one given, or to theL user's default directory and/or device if the name is omitted.  This commandM affects only the Kermit process and any processes it may subsequently create.p3 You may use CWD and SET DEFAULT as synonyms for CD.d  N DELETE @i<fn>@\Deletes (removes, erases) file @i<fn>, which may be the name ofG a single file or a wildcard specification containing @q<*> and/or @q<?>n4 characters.  You may use RM as a synonym for DELETE.  M DIRECTORY [@i(fn)]@\Displays a listing of the files whose names match @i(fn),iM which may be the name of a single file or a wildcard specification containing"I @q<*> and/or @q<?> characters.  If no @i<fn> is given, C-Kermit lists allbL files in the current device and/or directory.  The format of and informationM provided in the listing depends on the operating system.  You may use LS as aa synonym for DIRECTORY.  I PWD@\(Print Working Directory) Display the current working (default) filemH device and/or directory.  You may use SHOW DEFAULT as a synonym for PWD.  F PRINT @i<fn1> [ @i<options> ]@\Print the local file @i<fn1> on a localL printer.  Options can be included after the filename, for example, to selectJ a particular printer.  The options are in the format of the local system's printing command.h  M RENAME @i<fn1> @i<fn2>@\Changes the name of file @i<fn1> to @i<fn2>.  You mayS use MV as a synonym for RENAME..  H SPACE@\Displays information about disk space and/or quota in the current directory and device.a  K TYPE @i<fn>@\Display the named file on the screen.  May be interrupted withoG Ctrl-C, and on most systems the display can be stopped and resumed withuH Ctrl-S and Ctrl-Q, respectively.  You may use CAT as a synonym for TYPE.  . { @q(@@), @q(!), RUN, PUSH }@\@begin(multiple)G The @i<command> is executed by your computer's operating system commandfL interpreter (UNIX shell, VMS DCL, etc).  If no command is specified, then anI interactive session is started; exiting from this session, e.g. by typing M Control-D or 'exit' to a UNIX shell, or LOGOUT to VMS DCL, will return you totN C-Kermit command level.  Use the `@q(!)' command to provide file management orM other functions not explicitly provided by C-Kermit commands.  @q<!>, @q<@@>,w4 RUN, and PUSH are all synonyms for the same command.  	 @comment{rK If you include the "@q(>)" character before the command, then the command'seK output will not be displayed on your screen, but rather it will be sent outpI the communication device selected in the most recent SET LINE or SET HOSTb command. }t @end(multiple) @end(description)h  # @section(The SET and SHOW Commands)@ @label(-setshow)  I Since Kermit is designed to allow diverse computers to communicate, it islF often necessary to issue special instructions to allow Kermit to adaptH to peculiarities of the other computer or the communication path.  TheseK instructions are accomplished by the SET command.  The following parameterse may be SET:P @begin(format,spread 0)c1 @tabclear()@tabset(1.5inches,2.0inches,2.5inches)E; @>ATTRIBUTES@\  Turn Attribute packet processing on or off. 4 @>BACKGROUND@\  Force foreground or background mode.1 @>BLOCK-CHECK@\  Level of packet error detection.-2 @>BUFFERS@\  Send and receive packet buffer sizes.: @>CARRIER@\  Treatment of carrier on terminal connections.0 @>CASE@\  Controls treatment of alphabetic case.- @>COMMAND@\  Character set size for commands.  @>COUNT@\  For counted loops.t0 @>DEBUG@\  Log or display debugging information. @>DEFAULT@\  Default directory. 8 @>DELAY@\  How long to wait before sending first packet.& @>DIAL@\  Parameters for DIAL command.5 @>DUPLEX@\  Specify which side echoes during CONNECT. 8 @>ESCAPE@\  Prefix for "escape commands" during CONNECT.& @>FILE@\  Set various file parameters.> @>FLOW-CONTROL@\  Communication line full-duplex flow control.C @>HANDSHAKE@\  Communication line half-duplex turnaround character.i$ @>HOST@\  Specify network host name.< @>INCOMPLETE@\  Disposition for incompletely received files.- @>INPUT@\  Control behavior of INPUT command.oB @>LANGUAGE@\  Enable language-specific character-set translations.) @>LINE@\  Communication line device name.p. @>MACRO@\  Control aspects of macro execution.= @>MODEM-DIALER@\  Type of modem-dialer on communication line.x0 @>PAD@\  (X.25 systems only) X.3 PAD parameters.0 @>PARITY@\  Communication line character parity.> @>PROMPT@\  The C-Kermit program's interactive command prompt., @>RECEIVE@\  Parameters for inbound packets.' @>RETRY@\  Packet retransmission limit.n. @>SCRIPT@\  Parameters for the SCRIPT command.* @>SEND@\  Parameters for outbound packets., @>SERVER@\  Parameters for server operation.C @>SESSION-LOG@\  (UNIX only) Session log file type, text or binary.x$ @>SPEED@\  Communication line speed.$ @>SUSPEND@\  Enable/Disable SUSPEND.1 @>TAKE@\  Control aspects of TAKE file execution.-" @>TERMINAL@\  Terminal parameters.' @>TRANSFER@\  File transfer parameters.t< @>TRANSMIT@\  Control aspects of TRANSMIT command execution.8 @>UNKNOWN@\  Specify handling of unknown character sets.- @>WINDOW@\  File transfer packet window size.a= @>WILDCARD@\  (UNIX only) Kermit vs shell wildcard expansion.e2 @>X.25@\  (X.25 systems only) X.25 call parameters @end(format)  9 The SHOW command may be used to display current settings.mL Here is a  summary of settings available in C-Kermit, listed alphabetically.
 @begin(d4) @index<Attributes>3 SET ATTRIBUTES@\ Tells C-Kermit whether to exchangeIJ file attribute (A) packets@index<Attribute Packets>, or whether to includeE specified attributes within the A packets it sends, or whether to paynK attention to specific attributes in A packets it receives.  When the use ofDO A packets has been negotiated, C-Kermit enables and uses the ones listed below.sL When sending files, C-Kermit responds to an Attribute refusal from the otherE computer by not sending the specified file.  For example, if C-KermiteL announces in the A packet that the file is 100K long, the other Kermit couldK refuse the file because of insufficient disk space, and then C-Kermit wouldr not send it.
 @begin(d4)O SET ATTRIBUTE CHARACTER-SET { ON, OFF }@\Turn the character-set attribute ON orrM OFF.  If ON, C-Kermit includes a code for the transfer character set in the AeN packet when sending a file, and when receiving a file, C-Kermit will translateK from the character set (if any) specified in the incoming A packet into the K current file character set (see SET FILE), if the transfer character set isu$ known to C-Kermit (see SET UNKNOWN).  L SET ATTRIBUTE DATE { ON, OFF }@\If ON, C-Kermit includes the file's creationL date in the A packet when sending a file, and stores incoming files with theI creation dates (if any) given in the incoming A packets.  Beware: on somehN computers, incremental backups might skip over files with creation dates older than the most recent backup.  N SET ATTRIBUTE DISPOSITION { ON, OFF }@\The MAIL and REMOTE PRINT commands workJ by setting "dispositions" of Mail and Print in the A packet when sending aJ file.  SET ATTR DISP OFF will cause C-Kermit to ignore this and store such3 files on disk rather than mailing or printing them.   I SET ATTRIBUTE LENGTH { ON, OFF }@\When sending files, C-Kermit puts their K length in the A packet, so the receiving system has an opportunity to checkeM and/or allocate disk space in advance, and to refuse the file if there is notiK enough disk space.  If you believe that files are being unjustly refused on H the basis of length, you can SET ATTR LENGTH OFF.  When receiving files,@ C-Kermit presently ignores the length announced in the A packet.  H SET ATTRIBUTE OS-SPECIFIC { ON, OFF }@\Certain versions of Kermit conveyN operating-system specific file information in the A packet, which is primarilyL useful when transferring files between like systems, such as VMS to VMS.  IfL you find this feature is interfering with successful file transfer, SET ATTR OS OFF.i  F SET ATTRIBUTE SYSTEM-ID { ON, OFF }@\The A packet also includes a codeN identifying the file's operating system of origin, so that the receiver of theK file can decide whether to pay attention to the OS-SPECIFIC attribute.  User) SET ATTR SYS OFF to disable this feature.d  M SET ATTRIBUTES ALL { ON, OFF }@\You can turn all the above off using SET ATTRr- ALL OFF, and back on using SET ATTR ALL ON.  o  M SET ATTRIBUTES { ON, OFF }@\This command turns the attribute mechanism itselftH on or off, without disturbing the settings of the individual attributes. It is on by default. @end(d4)  K SET BACKGROUND { OFF, ON }@\Use SET BACKGROUND off to make your prompts and I messages appear in case they have disappeared because Kermit thinks it is H running in the background (for example, if you are running it through anK output filter, as in "kermit | vt100").  You can accomplish the same effect , using the @q<-z> option on the command line.  O SET BLOCK-CHECK {1, 2, 3}@\ Determines the level of per-packet error detection.tK "1" is a single-@|character 6-bit checksum, folded to include the values of M all bits from each character.  "2" is a 2-character, 12-bit checksum.  "3" isRJ a 3-character, 16-bit cyclic redundancy check (CRC).  The higher the blockG check, the better the error detection and correction and the higher theaI resulting overhead.  Type 1 is most commonly used; it is supported by allnI Kermit implementations, and it has proven adequate in most circumstances.TK Types 2 or 3 should be used when transferring 8-bit data or when using longf packets.  K SET BUFFERS @i<n1> @i<n2>@\Allows you to change the total buffer space usedcJ for sending packets (@i<n1>) and receiving packets (@i<n2>), if Kermit hasN been configured to allow dynamic buffer allocation.  The bigger you make them,N the longer your packets can be, and the more window slots you can use.  To seeB the default values for your version of Kermit, type SHOW PROTOCOL.  J SET CARRIER {AUTO, ON [@i<n>], OFF}@\Specifies C-Kermit's treatment of theG Carrier (CD, DCD, or RLSD) RS-232 signal on terminal device connections  obtained via SET LINE:
 @begin(d4)6 SET CARRIER ON@\Means to require carrier at all times;N SET LINE will not return until carrier appears (handy for setting Kermit up toD wait for a call to come in), and a fatal error will occur if carrierL disappears during CONNECT or file transfer.  A nice side effect is that whenM you log out from the remote computer, you will be put back at C-Kermit prompteM level automatically if the remote system drops carrier properly.  If you wantbG to set a time limit on how long SET LINE will wait for carrier, you cansH include an optional number after SET CARRIER ON to specify the number ofN seconds to wait before timing out and returning to the prompt, for example SET CARRIER ON 30.  I SET CARRIER OFF means to ignore carrier at all times.  Useful for direct,tL nonmodem connections, or misbehaving modem connections.  Should only be usedL when necessary, because it takes away the ability of Kermit to automatically! detect a broken phone connection.e  I SET CARRIER AUTO means to require carrier during CONNECT but not at othertN times.  AUTO is the default.  SET CARRIER ON does not affect the DIAL command. @end(d4)  J SET CASE { ON, OFF }@\Tells C-Kermit whether to pay attention to or ignoreF alphabetic case in string matching operations, including INPUT and IF.! Default is OFF, i.e. ignore case.n  L SET COMMAND BYTESIZE { 7, 8 }@\Normally, C-Kermit's command processor stripsJ off the 8th bit of any character you type, in case your data connection toH C-Kermit has parity.  If there is no parity and you want to use an 8-bitF international character set in your commands (for example, in the ECHOH command, or in filenames), use SET COMMAND BYTESIZE 8.  The command alsoL applies to the connection between your terminal (if any) and C-Kermit duringK terminal emulation (CONNECT), as opposed to the connection between C-Kermit 0 and the remote host (see SET TERMINAL BYTESIZE).  G SET COUNT @i<n>@\For use with counted loops.  See the section on scripti language programming.o  G SET DEFAULT @i<directory>@\Change default directory.  Equivalent to CD.m  > SET DIAL DISPLAY { ON, OFF }@\Show dialing activity on screen.  O SET DIAL HANGUP { ON, OFF }@\Normally, the DIAL command will attempt to hang upgN the phone before dialing a new call.  This is done by momentarily dropping theK Data Terminal Ready (DTR) signal on the currently selected terminal device.SK Unfortunately, the method for doing this is ill-defined in some versions ofiK UNIX, and in some cases DTR goes down and stays down, which can prevent alltK further communication between the computer and the modem.  If you find thatON the DIAL command does not work for you at all, try giving the command SET DIALG HANGUP OFF before giving the DIAL command.  This will prevent DIAL from 1 hanging up the phone before dialing the new call.m  I SET DIAL INIT-STRING @i<string>@\Replace Kermit's built-in initializationeN string with @i<string>, which may contain backslash codes to represent control characters.i  L SET DIAL MNP-ENABLE { ON, OFF }@\Enable or disable MNP protocol negotiationsL by the modem.  Normally off.  This command presently applies only to Telebit modems.   J SET DIAL KERMIT-SPOOF { OFF, ON }@\Enable modem's "Kermit spoof" if it has one.  H SET DIAL SPEED-MATCHING { OFF, ON }@\Tells whether the modem's interfaceI speed is locked.  Default is OFF, meaning the modem changes its interfaceoL speed to match the connection speed, for example if you place a call at 2400J bps and it is answered at 1200 bps.  Use ON if your modem is configured to do speed matching.  J SET DIAL TIMEOUT @i<number>@\Seconds to wait for a response from the modemF when dialing before giving up and declaring that the call could not beJ completed.  If you don't give this command, Kermit calculates its own dialM timeout based on the modem type, length of the phone number, and transmissionSI speed.  If that interval isn't long enough, use this command to specify ap longer one.e  M SET DEBUG { ON, OFF, SESSION }@\SET DEBUG ON is equivalent to LOG DEBUG.  SET K DEBUG SESSION means to display incoming control and 8-bit characters on theAI screen using special notation (see CONNECT).  SET DEBUG OFF turns off all 
 debugging.  I SET DELAY @i(n)@\How many seconds to wait before sending the first packetdM after a SEND command.  Used in remote mode to give you time to escape back totL your local Kermit and issue a RECEIVE command before the first Kermit packet appears.  Normally 5 seconds.a  O SET DUPLEX {FULL, HALF}@\For use during CONNECT.  Specifies which side is doing E the echoing; FULL means the other side, HALF means C-Kermit must echomM your keystrokes itself.  Normally FULL.  Use half when communicating with IBM N mainframes over linemode connections, and on similar half-duplex or local-echo0 connections.  Synonym: SET LOCAL-ECHO {OFF, ON}.  E SET ESCAPE-CHARACTER @i(cc)@\For use during CONNECT to get C-Kermit'srK attention.  The escape character acts as a prefix to an escape command, for N instance to close the connection and return to C-Kermit or UNIX command level.J The normal escape character is Control-Backslash (ASCII 28).  See CONNECT.  " SET FILE @i<parameter> @i<value>@\" Establish file-related parameters:
 @begin(d4)E SET FILE BYTESIZE { 7, 8 }@\Normally 8.  If 7, strip the 8th bit fromt file data during file transfer.v  O SET FILE CHARACTER-SET @i<name>@\tells the encoding of the local file, ASCII bycJ default.  The names DUTCH, GERMAN, FRENCH, etc, refer to 7-bit ASCII-based@ national replacement character (NRC) sets.  CP866, CYRILLIC-ISO,L and KOI8-CYRILLIC refer to sets used in the Soviet Union and other countries> that use the Cyrillic alphabet.  Latin-1 is the 8-bit ISO 8859L Latin Alphabet 1.  JAPANESE-EUC, DEC-KANJI, JIS7, and SHIFT-JIS are JapaneseF Kanji sets.  Type SET FILE CHAR ? for a complete list.  When receivingK files, C-Kermit translates from the transfer character set specified in theoK most recent SET TRANSFER CHARACTER-SET command or else the one announced iniH the Attribute packet (if any) into the file character set.  When sendingG files, C-Kermit translates from the current file character set into then current transfer character set.i  L SET FILE COLLISION @i<action>@\Tells what to do when a file arrives that has4 the same name as an existing file.  The actions are:
 @begin(d4)  I BACKUP@\(default) Rename the old file to a new, unique name and store thesN incoming file under the name it arrived with.  The "new unique" name is simplyL a new generation on VAX/VMS.  In UNIX, a "generation number" appended to theL filename, separated by a tilde, as in @q<oofa.txt.~8~>@foot{The new name forK the arriving file is of the form @q(foo.~)@i(n)@q(~), where foo is the name(N they share and @i(n) is a "generation number"; if @i(foo) exists, then the newK file will be called @q(foo.~1~).  If @q(foo) and @q(foo.~1~) exist, the newrN file will be @q(foo.~2~), and so on.  If the new name would be longer than theN maximum length for a filename, then characters are deleted from the end first,J for instance, @q(thelongestname) on a system with a limit of 14 characters  would become @q(thelonges.~1~).} @begin(quotation)e* WARNING: UNIX C-Kermit presently offers noM method of automatically limiting the number of versions of a file that can be K created, so if too many of them pile up, you'll have to delete the ones youaM don't need by hand.  Or, because the version number syntax is compatible with = GNU EMACS backup files, you can use EMACS to do this for you.c @end(quotation)E, In OS/2, Kermit constructs names of the formK @q(FZZ)@i(n)@q(.BAR), where @q(FZZ.BAR) is the name they share and @i(n) isyG a "generation number"; if @q(FZZ.BAR) exists, then the new file will be H called @q(FZZ00001.BAR).  If @q(FZZ.BAR) and @q(FZZ00001.BAR) exist, theF new file will be @q(FZZ00002.BAR), and so on.  If the common name wereL more than 6 characters long (eg @q(GOODDATA.DAT)), then the new name for the2 arriving file would be @q(GOODD001.DAT) and so on.  M OVERWRITE@\Overwrite (replace) the existing file.  The existing file is gone,nL destroyed.  Even if the file transfer fails or the incoming file is refused. Use with caution.s  N APPEND@\Append the incoming file to the end of the existing file.  This optionJ is useful for adding information to a log file, but it should be used withN caution to avoid, for example, joining two files of different types (like text and binary).  K DISCARD@\Refuse and/or discard the incoming file.  This option is handy forfJ resuming multi-file transmissions that were broken.  Only those files that: were not successfully transferred before will be accepted.  L RENAME@\Give the incoming file a unique name, like the BACKUP option, exceptH that the incoming file gets the new name, rather than the existing file.  L UPDATE@\Accept the incoming file only if it is newer than the existing file.H This feature depends on the creation date field in the attribute packet. @end(d4)  O SET FILE DISPLAY { ON, OFF }@\Normally ON; when in local mode, display progressiD of file transfers on the screen (stdout), and watch the keyboard forN interruptions.  If OFF (-q on command line) none of this is done, and the fileB transfer may proceed in the background oblivious to any other work" concurrently done at the keyboard.  I SET FILE NAMES {CONVERTED, LITERAL}@\Normally CONVERTED, which means thataE outbound filenames have device, directory, and/or path specificationsUM stripped, lowercase letters raised to upper, tildes and extra periods changedeK to X's, and an X inserted in front of any name that starts with period.  In E VMS, the generation number is also stripped.  For UNIX only, incominglK filenames have uppercase letters lowered.  LITERAL means that none of thesetK conversions are done; therefore, any directory path appearing in a receivedLN file specification must exist and be write-accessible.  When literal naming isJ being used, the sender should not use path names in the file specificationA unless the same path exists on the target system and is writable.e  M SET FILE RECORD-LENGTH @i<n>@\Tells the record length for fixed-format files,uG or the maximum record length for variable-format files, on systems likep4 VAX/VMS where record-length is a meaningful concept.  C SET FILE TYPE {BINARY, TEXT}@\The file type is normally text, whichfL means that conversion is done between the local computer's record format andN Kermit's standard transfer format, for example between UNIX newline charactersN and Kermit's carriage-@|return/@|linefeed sequences.  BINARY means to transmitM file contents without conversion.  Binary (`@q(-i)' in command line notation)rJ is necessary for binary files, and desirable in all file transfers between% like systems to cut down on overhead.m  - For VAX/VMS, these are the file type options:n  M SET FILE TYPE TEXT@\Regular Text mode.  Applies to incoming files only.  When < SENDing files, C-Kermit determines their type automatically.  N SET FILE TYPE BINARY [ { FIXED, UNDEFINED } ]@\Applies to incoming files only.I Binary mode: incoming files are stored with no translation or conversion.LF The default record format is FIXED, but you can specify UNDEFINED too.  J SET FILE TYPE IMAGE@\This one applies to both incoming and outbound files.N For incoming files, it's just like BINARY FIXED.  For outbound files, it meansK just send the blocks of the file as they are stored on the disk, and ignore\A the file's RMS attributes.  SET FILE TYPE BLOCK is a synonym (forW compatibility with Kermit-32).  J SET FILE WARNING { ON, OFF }@\SET FILE WARNING is an old command, somewhatG misnamed.  SET FILE COLLISION (above) should be used instead.  SET FILEs. WARNING ON is equivalent to SET FILE COLLISIONN RENAME and SET FILE WARNING OFF is equivalent to SET FILE COLLISION OVERWRITE. @end(d4)   @begin<multiple>N SET FLOW-CONTROL {DTR/CD, NONE, RTS/CTS, XON/XOFF}@\Normally XON/XOFF for fullI duplex flow control.  Should be set to NONE if the other system cannot dosM Xon/Xoff flow control, or if you have issued a SET HANDSHAKE command.  If set H to XON/XOFF, then HANDSHAKE should be set to NONE.  This setting appliesM during both terminal connection and file transfer.  @i<Warning:> This command A may have no effect on certain UNIX systems, where Kermit puts theaE communication line into "rawmode" and rawmode precludes flow control.H  N The DTR/CD and RTS/CTS options are two kinds of "hardware flow control", usingK special wires (other than the data wires) in the connector.  These forms ofeG flow control (especially RTS/CTS) are especially useful with high-speedeJ modems and similar devices.  But these options are only available in thoseE versions of C-Kermit whose underlying operating system supports them.   H Certain versions of UNIX, such as that on the NeXT, provide RTS/CTS flowF control in a different way, namely in the device driver.  For example,L /dev/cua is the first dialout port on the NeXT without RTS/CTS flow control,G and /dev/cufa is the same port, but with built-in RTS/CTS flow control.u   @end<multiple>  N SET HANDSHAKE {XON, XOFF, CR, LF, BELL, ESC, NONE}@\Normally NONE.  Otherwise,I half-duplex communication line turnaround handshaking is done during file"F transfer, which means C-Kermit will not reply to a packet until it hasK received the indicated handshake character or has timed out waiting for it;dN the handshake setting applies only during file transfer.  If you SET HANDSHAKE4 to other than NONE, then FLOW should be set to NONE.  J SET HOST @i<name>@\For communicating over a network rather than a terminalB device.  Presently supported only for Berkeley-based or other UNIXK implementations using the socket interface to a TCP/IP network, for VAX/VMS - with the TGV MultiNet TCP/IP package, and forFK SunLink X.25.  For TCP/IP networks, the @i<name> is the hostname or IP hosttI number of a host on the network, optionally followed by a colon and an IPKN service number.  By default, C-Kermit connects to the telnet (virtual terminalM server) socket on TCP/IP connections.  For X.25 networks, the @i<name> is thet X.121 address.  L SET INCOMPLETE {DISCARD, KEEP}@\Disposition for incompletely received files.F If an incoming file is interrupted or an error occurs during transfer,D the part that was received so far is normally discarded.  If you SET0 INCOMPLETE KEEP then partial files will be kept.  J SET INPUT {CASE, ECHO, TIMEOUT-ACTION}@\Controls the behavior of the INPUT0 command.  See the section on script programming.  M SET KEY @i<n> [ @i<string> ]@\Key mapping for CONNECT mode.  Tell Kermit that I when you press the key whose code is @i<n> during CONNECT mode, it shouldaL substitute the @i<string> in its place.  The string is entered in the nativeD character set of your computer, or you can use backslash codes.  TheH characters are subject to the same translation and shifting rules as theM characters you would enter manually at the keyboard during CONNECT mode.  The M code @i<n> must be a number between 0 and 255 (higher numbers are possible onvF some computers, like OS/2, if Kermit knows how to read your computer'sK keyboard scan codes).  A key mapping for code @i<n> applies to @i<all> keys-L that produce this code, for example SET KEY \9 \27 assigns the code 27 (ESC)J to the TAB key and to the CTRL-I key.  To find out a key's code, enter theN SHOW KEY command, then press the key or key combination.  Entering the SET KEYN for key @i<n> without specifying a @i<string> results in removing any previousN key mapping for key @i<n>, i.e. @i<n> sends itself.  Key mappings do not applyL to escape-character arguments.  If the escape character appears in a SET KEYE @i<string>, it is treated as an ordinary data character, but if a keyoJ definition is exactly one character long, and that character is the escape1 character, it is treated as the escape character.t  G SET LANGUAGE {ICELANDIC, GERMAN, NORWEGIAN, RUSSIAN, ...}@\For use withoJ international text file transfer.  If you tell Kermit what language a textN file is written in, then Kermit might be able to apply certain transliterationG tricks when translating between the file character set and the transfer,@ character set.  See the section on international character sets.  % SET LINE [@i<terminal-device-name>]@\n @begin<multiple>K The device name for the communication line to be used for file transfer andrK terminal connection, e.g. @q(/dev/ttyi3) on a UNIX system or @q<TXA0:> on a 0 VAX/VMS computer.  If you specify a device name,L Kermit will be in @i<local mode>, and you should remember to issue any otherK necessary SET commands, such as SET SPEED (on UNIX, at least, the SET SPEEDrN command is not strictly necessary -- Kermit will use the line's current speed,N but you should use SET SPEED anyway, so that you be sure that speed you desire is actually being used).  F If you omit the device name, Kermit will revert to its default mode ofI operation.  If you specify the default device name (@q(/dev/tty) in UNIX,fM @q<TT:> in VMS), Kermit will enter remote mode (useful when logged in throughlG the "back port" of a system normally used as a local-mode workstation).c  H Whenever you give a SET LINE command, C-Kermit closes any currently openJ communication device before attempting to open the new one.  Therefore SETC LINE is also useful for closing and hanging up a dialed connection.e  I When UNIX Kermit enters local mode, it attempts to synchronize with othermK programs (like uucp) that use external communication lines so as to preventoG two programs using the same line at once; before attempting to lock theIN specified line, it will close and unlock any external line that was previouslyK in use.  If your system does not allow you to have write access to the uucpaK lock directory, then you will receive a message like "Sorry, access to lockeM denied."  In this case, you must ask your system administrator to ensure that J uucp lockfiles are set up correctly and Kermit is installed correctly.  IfJ Kermit were to use the external line without proper coordination with uucpD (and even other copies of Kermit), then two or more users could findH themselves using the same line at the same time, which would prevent all useful communication.E  J If you SET LINE to a communication port that has a modem attached, and youL have SET CARRIER ON, then the SET LINE command will not return until carrierK appears on the device.  This is useful for setting up a Kermit program thateL other people can dial in to.  You can control the amount of time Kermit willM wait for carrier using SET CARRIER ON @i<n>, where n is the number of secondspM to wait for a connection before timing out.  You can also interrupt a blockede" SET LINE command by typing Ctrl-C. @end<multiple>  L SET MACRO { ECHO, ERROR } { ON, OFF }@\Tells whether the individual commandsK that comprise a macro should be echoed on the screen during macro executiondK (normally they are not), and whether an error during macro execution should,K terminate the macro immediately (normally it does not).  See the section on  script programming.L  & SET MODEM-DIALER @i<name>@\The type ofG modem @index<Autodialer> dialer on the communication line; the @i<name>lL identifies the modem type: DIRECT, HAYES, RACALVADIC, VENTEL, etc.  "Direct"H indicates either there is no dialout modem, or that if the line requiresJ carrier detection to open, then SET LINE will hang waiting for an incomingN call.  HAYES, VENTEL, and the others indicate that SET LINE will prepare for aG subsequent DIAL command for the given dialer.  UNKNOWN means a modem isEL attached, but of an unknown or unsupported type.  Support for new dialers isM added from time to time, so type SET MODEM ? for a list of those supported incG your copy of Kermit.  Also see the description of the DIAL and SET DIALnK commands.  @i<NOTE:> the SET MODEM command must be given @i<before> the SET.1 LINE command if you plan to use the DIAL command.r  M SET NETWORK {TCP/IP, X.25}@\Select the type of network that is to be used forcJ SET HOST connections.  TCP/IP is presently available for UNIX systems thatL support the Berkeley sockets library (such as BSD-based UNIXes, HP-UX, XenixC with Excelan TCP/IP) and for VAX/VMS with the TGV MultiNet library.hM X.25 is available only for SUNs with the SunLink product (see section on X.25E	 support).q   SET PAD@\(See X.25 section)E  N SET PARITY {EVEN, ODD, MARK, SPACE, NONE}@\Specify character parity for use inM packets and terminal connection, normally NONE.  If other than NONE, C-Kermit.M will seek to use the 8th-bit prefixing mechanism for transferring 8-bit data, I which can be used successfully only if the other Kermit agrees during thetN automatic feature negotiation phase; if not, 8-bit data cannot be successfullyJ transferred.  In Berkeley-based UNIX implementations, if you SET PARITY toH other than NONE, this will also enable Xon/Xoff flow control during fileH transfer if FLOW is set to XON/XOFF; otherwise, flow control is not doneL (because the communication line must be opened in "raw mode" for 8-bit data,C which precludes the use of Xon/Xoff flow control in Berkeley UNIX).:  M SET PROMPT [@i<text>]@\The given text will be substituted for "@q(C-Kermit)>" L as this program's prompt.  If the text is omitted, the prompt will revert toM "@q(C-Kermit>)".  If the text is enclosed in { curly braces }, the braces areUH stripped and any leading and trailing blanks are retained.  The text may contain backslash codes.  M SET QUIET {ON, OFF}@\Normally OFF.  Various informational messages are issued N by the user interface.  ON suppresses these messages (but not error messages).' Equivalent to '-q' on the command line.A  4 SET RECEIVE @i<parameter> @i<value>@\(See SET SEND.)  H SET RETRY @i<n>@\Specify the maximum number of times a particular packetN can be retransmitted (because of timeout or transmission errors) before Kermit2 gives up and declares the file transfer a failure.  = SET {SEND, RECEIVE} @i<parameter> @i<value>@\@begin(multiple)iK These commands are used to modify the normal formats and procedures used byHM the Kermit file transfer protocol.  Normally they are not necessary, but theyhN can be used to overcome unusual obstacles, or to improve Kermit's performance.  K The SET RECEIVE command lets you tell the other Kermit how it should formatuM the packets it sends to you.  Give SET RECEIVE commands to the Kermit that isiJ going to receive files.  If you plan to transfer files in both directions,* give SET RECEIVE commands to both Kermits.  L The SET SEND command rarely needs to be used.  It is for overriding what theK the other Kermit requests, and should be necessary only if you cannot use a H SET RECEIVE command to modify the parameter in question on the receiving Kermit.a @end(multiple)
 @begin(d4)N SET {RECEIVE, SEND} END-OF-PACKET @i(cc)@\Specifies the control character thatL marks the end of a Kermit packet.  Normally 13 (carriage return), which most Kermit implementations require.i  K SET {RECEIVE, SEND} PACKET-LENGTH @i(n)@\Specify the maximum packet length,aJ normally 90.  Shorter packet lengths can be useful on noisy lines, or withK systems or front ends or networks that have small buffers.  The shorter thelK packet, the higher the overhead, but the lower the chance of a packet beinguN corrupted by noise, and the less time to retransmit corrupted packets.  If youM request a length greater than 94, "long packets" are used, which is a featureoL that not all other Kermit programs support (most popular ones do).  C-KermitK can send and receive packets up to about 2000 characters in length.  If youhL use longer packets, you should also request a stronger error checking methodL (see SET BLOCK-CHECK).  SET SEND PACKET-LENGTH overrides the value requestedF by the other Kermit during protocol initiation unless the other Kermit requests a shorter length.  J SET {RECEIVE, SEND} PAD-CHARACTER @i(cc)@\SET RECEIVE PAD-CHARACTER allowsF C-Kermit to request the other Kermit to use @i(cc) as a pad character.H Default @i(cc) is NUL, ASCII 0.  C-Kermit normally does not need to haveF incoming packets preceded with pad characters.  SET SEND PAD-CHARACTERK designates a character to send before each packet.  Normally, none is sent.qH Outbound padding is sometimes necessary for communicating with slow halfN duplex systems that provide no other means of line turnaround control.  It canN also be used to send special characters to communications equipment that needsN to be put in "transparent" or "no echo" mode, when this can be accomplished in* by feeding it a certain control character.  N SET {RECEIVE, SEND} PADDING @i(n)@\How many pad characters to request or send, normally 0.o  H SET {RECEIVE, SEND} START-OF-PACKET @i(number)@\The normal Kermit packetI prefix is Control-A (1); this command changes the prefix C-Kermit puts onfN outbound packets.  The only reasons this should ever be changed would be: SomeJ piece of equipment somewhere between the two Kermit programs will not passG through a Control-A; or, some piece of of equipment similarly placed iscI echoing its input.  In the latter case, the recipient of such an echo caneJ change the packet prefix for outbound packets to be different from that ofK arriving packets, so that the echoed packets will be ignored.  The oppositeEN Kermit must also be told to change the prefix for its inbound packets (use SET= RECEIVE START on one Kermit and SET SEND START on the other).d  I SET {RECEIVE, SEND} TIMEOUT @i(n)@\Normally, each Kermit partner sets itshH packet timeout interval based on what the opposite Kermit requests.  SETI RECEIVE TIMEOUT allows you to override the normal procedure and specify a@L timeout interval for C-Kermit to use when waiting for packets from the otherN Kermit.  If you specify 0, then no timeouts will occur, and C-Kermit will waitN forever for expected packets to arrive (relying on the other Kermit to provideK the timeout function).  SET SEND TIMEOUT specifies the number of seconds to G wait for a packet before timing it out and retransmitting or requestingR retransmission.e @end(d4)  J SET SCRIPT ECHO {ON, OFF}@\Tell whether the SCRIPT command should echo itsA interactions with the remote host on your screen.  ON by default.r  L SET SERVER DISPLAY {ON, OFF}@\Specify whether C-Kermit, when in server mode,J should put a file transfer display on the screen when it is in local mode.
 Normally OFF.C  < SET SERVER TIMEOUT @i<n>@\Specify the time interval @i<n> inG seconds for the C-Kermit server to send NAK packets while waiting for akL command packet.  These NAKs are intended to break deadlocks in case a clientK Kermit that cannot time out sends a command packet which is lost.  However,dM the server command-wait NAKs can interfere with originate/answer devices thatfN are to be used for answering.  For example, you can run a C-Kermit server on aM modem line that normally dials out, so that people can dial in to it and giverK Kermit commands.  While waiting for the phone call to come, the server NAKsiH might "wake up" the modem and put it into originate mode, preventing the" incoming call from being answered.  F SET SESSION-LOG { BINARY, TEXT }@\Specify how the session log is to beG written.  TEXT is the default, meaning that lines are written using thetH convention of the local system; for example, UNIX session logs will haveL carriage returns (and certain other extraneous characters like NUL) omitted.9 BINARY means to record all characters in the session log.s  : SET SPEED @i<n>@\The transmission speed in bits per secondK ("baud rate") for the communication line specified in SET LINE (but not SETsK HOST).  This command cannot be used to change the speed of your own consolelJ terminal.  Some computers are set up in such a way that you must give thisM command after a SET LINE command before you can use the line.  Type SET SPEED-F ? to see what speeds are available.  Use speeds greater than 9600 withN caution, since they are not necessarily supported by the communication devicesO on your computer or the other computer, or the communication path between them.   F SET SUSPEND { OFF, ON }@\(UNIX only) On UNIX versions that support jobE control, C-Kermit can normally be put in the background by typing theNI suspend character (usually Ctrl-\), or giving C-Kermit the SUSPEND (or Z)sI command, or by using the Z connect-mode escape.  SET SUSPEND OFF disablesEI this feature.  This is useful when suspending doesn't work right (e.g. onsK certain UNIX implementations that have bugs) or when you are running Kermiti under the Bourne shell.a  A SET TAKE { ECHO, ERROR } { ON, OFF }@\SET TAKE ECHO tells whethercJ commands from a TAKE file are displayed on the screen as they are executedM (normally they are not).  SET TAKE ERROR controls whether execution of a TAKEiJ command file should be terminated if an error occurs (normally it is not).  N SET TERMINAL @i<parameter> @i<value>@\Used for specifying terminal parameters.
 @begin(d4)J SET TERMINAL BYTESIZE { 7, 8 }@\tells the character size to be used on theJ communication line between the local C-Kermit and the remote Kermit duringN terminal emulation (C-Kermit CONNECT command).  It's 7 by default, which meansI that the high-order (8th) bit is stripped from each incoming and outgoinghN character.  Use 8 for 8-bit character sets like ISO Latin Alphabet 1, but thisJ will work only if the connection really is 8-bits no-parity.  Compare with SET COMMAND BYTESIZE.N  G SET TERMINAL CHARACTER SET <remote-set> [ <local-set> ]@\For use duringaI CONNECT.  Specify the character set that is being sent to C-Kermit by thelL remote computer, and specify which local character set to translate it into.N If the local character set is omitted, the current file character set is used.F The choices for the character sets are the same as for C-Kermit's fileH character sets (see SET FILE CHARACTER-SET).  SET TERMINAL CHARACTER-SETM TRANSPARENT (which is Kermit's startup default) means no translation is done.XE Equivalently, no translation is done if the local and remote sets areAL specified to be the same.  When they are different, translation goes throughN the Latin Alphabet 1 unless the local character set is Cyrillic-based in whichA case it goes through the Latin/Cyrillic Alphabet.  Kanji terminal ! character-sets are not supported.h  E SET TERMINAL LOCKING-SHIFT { OFF, ON }@\Tells C-Kermit whether to use2H Shift-In/Shift-Out (Ctrl-O and Ctrl-N) to switch between 7-bit and 8-bitG characters during CONNECT.  Applies to the Kermit-to-remote part of thelF connection only, and it applies to both the characters you type and to7 those Kermit receives from the remote.  OFF by default.P  F SET TERMINAL NEWLINE { ON, OFF }@\OFF is the default.  When ON, Kermit: sends CRLF whenever you type CR during terminal emulation.  I SET TERMINAL TYPE { VT100, TEK }@\(OS/2 C-Kermit only) Select the type ofp terminal to emulate. @end(d4)D Terminal parameters can be displayed with the SHOW TERMINAL command.  L SET TRANSFER CHARACTER-SET @i<name>@\Tells what character set should be usedG for file data within Kermit packets during transfer of text files.  Thed choices are:
 @begin(d4)/ TRANSPARENT@\Don't translate characters at all.   K ASCII@\Means to use the 7-bit ASCII (American Standard Code for Information.E Interchange) character set.  If the local file character set containsrM characters that do not occur in ASCII (like accented letters), represent themp in ASCII the best way possible.k  K CYRILLIC-ISO@\Means to use the ISO 8859-5 Latin/Cyrillic Alphabet, which is D capable of representing Russian, Ukrainian, Bulgarian, Serbian, etc.  C LATIN1@\Means to use ISO 8859 Latin Alphabet 1, which is capable ofdN representing most western European languages (English, German, Spanish, Dutch,6 Italian, Norwegian, Danish, Swedish, Portuguese, etc).  M JAPANESE-EUC@\Means to use Japanese Extended UNIX Code, which is a mixture ofaK 7-bit Roman (Japanese ISO 646, similar to ASCII), single-byte Katakana, andT double-byte JIS X 0208 Kanji.  @end(d4)  K SET TRANSMIT @i<parameter> @i<value>@\Controls the behavior of the TRANSMITnE command, used for uploading files to computers that don't have Kermitc- programs.  See TRANSMIT.  The parameters are:N
 @begin(d4)L ECHO { OFF, ON }@\Controls whether the characters that are sent to the other? computer are also displayed on your screen.  The default is ON.e  B EOF @i<string>@\String to send after sending the file, for example% SET TRANSMIT EOF \4 to send a Ctrl-D.e  N FILL @i<character>@\ASCII value of character to insert into blank lines.  SomeI computers ignore blank lines, others might terminate the upload when theymL receive a blank line.  Use this command to insert a character, such as space" (32) or X (88), in any blank line.  M LINEFEED { ON, OFF }@\Transmit linefeed as well as carriage return at the end ) of each line.  Normally, only CR is sent.i  J LOCKING-SHIFT { ON, OFF }@\Whether to send the locking-shift characters SOM (Ctrl-N) and SI (Ctrl-O) around 8-bit characters when transmitting and PARITY  is not NONE.  K PAUSE @i<n>@\Number of milliseconds (1000 milliseconds = 1 second) to pauseeJ after sending each line of a text file, or each character of a binary file7 (according to SET FILE TYPE).  Maximum 1000, default 0.d  C PROMPT @i<n>@\ASCII value of character to look for from host beforelK sending next line, normally LF (10), in text mode only; 0 means not to waiteK for any responses from the host -- just send all the characters in a steadyEN stream.  This command has no effect in binary mode (i.e. when FILE TYPE is set to BINARY).t @end(d4) Synonym: SET XMIT.  J SET UNKNOWN-CHAR-SET { DISCARD, KEEP }@\Tells what to do if a file arrivesN whose Attribute packet announces a transfer character set unknown to C-Kermit.  M SET WILDCARD-EXPANSION { KERMIT, SHELL }@\(UNIX only) Tells who should expandiM wildcard characters in SEND and similar commands: KERMIT (the default) or thel6 user's preferred UNIX shell (such as sh, csh, or ksh).   @begin(multiple)O SET WINDOW @i<n>@\Select a window size.  This refers to Kermit's sliding windowyJ packet transport protocol.  Normally, Kermit sends a packet, waits for theM reply, then sends the next packet, and so on.  This is called "stop and wait"sN operation, corresponding to a window size of 1, and is supported by all KermitN programs.  If you select a window size greater than 1, and if the other KermitN supports sliding windows, then multiple packets (up to the window size) can beK sent before any replies are required.  This allows file transfer to operate I efficiently over connections that have long delays, like over public dataR networks or through satellites.l  M With a sufficiently large window size, transmission can be continuous with no M pauses or delays.  The maximum window size is 31, but sizes greater than 5 ort 10 are rarely necessary.  M Sliding windows may be used in conjunction with long packets, but the maximumi9 length for packets decreases with increasing window size.p  L Kermit uses the "selective retransmission" technique, so that if packets areF damaged during sliding windows transfers, only the damaged packets are retransmitted. @end(multiple)   SET X.25@\(See X.25 section) @end(d4)   @subheading(The SHOW Command)r   Syntax: @q<SHOW> @i<category>   C The SHOW command with the default argument of "parameters" displayseF the values of most of the SET parameters described above.  If you typeL a category name after SHOW, then a more detailed report of parameters withinG the named category are displayed, for example SHOW COMMUNICATIONS, SHOWrA PROTOCOL.  Type SHOW ? to see a list of the available categories.n   @section(Backslash Notation) @label(-bkslash)  N @q<\> (backslash) in any command means that what follows is not ordinary text,N but rather a code, variable, or function whose value is to be substituted intoN the command at that point.  The character after the backslash identifies which kind of quantity this is: 4 @begin(description,leftmargin +6,indent -2,spread 0). @q<%>@\A user-defined simple (scalar) variable   @q<&>@\an array referenceh   @q<$>@\an environment variable  % @q<v>@\(or @q<V>) a built-in variablev   @q<f>@\(or @q<F>) a function  , @q<d>@\(or @q<D>) a decimal (base 10) number  * @q<o>@\(or @q<O>) an octal (base 8) number  0 @q<x>@\(or @q<X>) a hexadecimal (base 16) number  % @q<\>@\the backslash character itself   : @q<\b>@\(or @q<\B>) the BREAK signal (OUTPUT command only)  = @q<\l>@\(or @q<\L>) a Long BREAK signal (OUTPUT command only)S  0 @i<a decimal digit>@\a 1-3 digit decimal number.  > @i<anything else>@\The following character is taken literally. @end(description)(E Variables, arrays, functions, etc, are explained in the next section.yE Numbers can be expressed in backslash notation in the following ways: 
 @begin(d4)N @q<\{...}>@\A grouped number, braces discarded, e.g. \{17}5 is not the same as \175.r  H @q<\>@i<nnn>@\(1-3 decimal digits) replaced by binary number 0-255, e.g.. @q<\13> represents carriage return (ASCII 13).  5 @q<\d>@i<nnn> or @q<\D>@i<nnn> - Same as @q<\>@i<nnn>r  K @q<\o>@i<nnn> or @q<\O>@i<nnn> (1-3 octal digits) replaced by binary numberN 0-255.  M @q<\x>@i<nn> or @q<\X>@i<nn> (2 hexadecimal digits) replaced by binary numberX 0-255. @end(d4)E Numbers expressed in backslash notation are typically used to expressnK nonprintable ASCII characters within character strings, or in commands thatn< want you to enter the ASCII value of a character.  Examples: @begin(example)i3 echo \7Wake up!\7            ; A message with beeps : echo \27[H\27[J              ; VT100 clear-screen sequence6 set pad-character \o177      ; The ASCII character DEL
 @end(example)   3 @section(Macros, Variables, and Script Programming)e @label(-macros)   K C-Kermit's script programming language is based upon that of MS-DOS Kermit,tK and it is in most ways upwards compatible with it, meaning that many MS-DOSgL Kermit script programs (or TAKE files in general) will work in C-Kermit withL little or no modification.  C-Kermit also has a SCRIPT command that providesI a terse but cryptic shorthand for automating certain kinds of interactives' operations (see Section @ref<-scrcmd>).r   @subsection(Variables)  M A variable name is of the form @q<\%@i(i)>, where @i(i) is a single letter or@N digit.  Letter-variables are different from digit-variables, which are used asK macro parameters.  The alphabetic case of a letter-variable doesn't matter:e( @q<\%a> is the same variable as @q<\%A>.  L All variables have character strings as values.  A variable is considered toM exist if its value is a string of at least one character in length, otherwiset% it is "undefined" and does not exist.e  B A value is given to a variable using the DEFINE or ASSIGN command:
 @begin(d4)I DEFINE @i<name> [ @i<text> ]@\The named variable (or macro, see below) isaL created, with @i<text> as a value.  If a macro or variable of the given nameL already exists, its definition is replaced with the new one.  The given textL is copied into the definition literally.  If it contains any variable names,J functions references, etc, these are simply copied, rather than evaluated.  L ASSIGN @i<name> @i<text>@\The text is evaluated, and then the named variableI or macro's value is set to the evaluated text.  This differs from DEFINE,AF which does not evaluate the text, but rather copies it literally.  TheM distinction between ASSIGN and DEFINE doesn't matter unless the text containsdM variable names.  With ASSIGN, the contents of the variable is copied, wherease0 with DEFINE, the name of the variable is copied. @end(d4)7 To illustrate the difference between DEFINE and ASSIGN:  @begin(example)  def \%a Monday def \%b Today is \%a assign \%c Today is \%ah def \%a Tuesdayh echo \%b echo \%c
 @end(example)pK The definition of @q<\%b> is "@q<Today is \%a>", so that whenever the valueoM of @q<\%a> changes, so does the value of @q<\%b>.  The definition of @q<\%c>,u@ however, is fixed as "@q<Today is Monday>", because "@q<Monday>"? was the value of @q<\%a> at the time that @q<\%c> was assigned.r  M A variable can be used in any Kermit command simply by referring to its name:. @example(echo \%a)I and variables can be undefined by DEFINEing or ASSIGNing nothing to them,u for example: @example(define \%a)  . You can define variables with long names, too:) @example(define telephone-number 7654321) K But you have to refer to them in a special way, @q<\m(>@i<name>@q<)>, e.g.:n# @example<echo \m(telephone-number)>p  J A special kind of variable is called an @i<array>.  This is simply a list,B in which each element has a number.  An array reference looks likeL @q<\&a[>@i<i>@q<]>.  The @q<\&> means this is an array element rather than aJ simple variable, the letter tells which array it is (a, b, c, ..., z), andJ the brackets enclose an @i<index> which tells which member of the array isK being referred to: 1, 2, 3, etc.  The index can be a number, or it can be atK variable or function (even another array element) that has a numeric value.m7 Array indices must be (or evaluate to) zero or greater.t  O Arrays have to be declared before you can use them, so Kermit will know how bignH the array is and can create storage for it.  The command is DECLARE, for example: @example(DECLARE \&A[100])L This tells Kermit to create an array called @q<\&a> with 100 elements.  OnceJ an array is declared, its elements can be used just like simple variables: @example(DEFINE \&A[3] Tuesday)r+ An entire array can be destroyed like this:f @example(DECLARE \&A[0])M If you refer to an element of an array that is not declared, the reference ist replaced by the empty string.o  K The array @q<\&@@[]> is predeclared.  It contains the command line that theeK Kermit program was invoked with, one word per array element.  The number of D elements in the array is given in the built-in variable @q<\v(args)> (described later).  Example:! @example<$ @ux[kermit -p e -b 3]>dA Here @q<\&@@[0]> is the Kermit program's file specification, likenN @q</usr/local/bin/kermit>; @q<\&@@[1]> is @q<-p>, @q<\&@@[2]> is @q<e>, and so on.   I The simple variables @q<\%a..\%z> and the arrays @q<\&a[]..\&z[]> are alleK @i<global>, which means they can be referenced from anywhere in your scriptt4 program, including from within a TAKE file or macro.  N You can list the names and values of all existing global simple variables withJ the SHOW GLOBALS command, and you can list the names and dimensions of all! declared arrays with SHOW ARRAYS.    @subsection(Macros)r  L A Kermit macro is a list of one or more Kermit commands that can be referredF to by a single name.  Like variables, macros are created by the DEFINE (or ASSIGN) command:E @example(define ibm set parity mark, set duplex half, set handsh xon) M and unlike variables, macros do not have weird-looking names; macro names cant be ordinary words.  M Once a macro is defined, you can execute all of its commands simply by typingo the macro's name:i @example(C-Kermit>@ux[ibm])r  N If you have defined a macro that has the same name as one of Kermit's built-inI commands, you will have to insert the word DO before the name in order toi3 execute the macro rather than the built-in command:n @example(C-Kermit>@ux[do ibm])3 (you can also use the word DO to invoke any macro).vL In these examples, "IBM" and "DO IBM" are the @i<macro invocations>.  If youI follow a macro invocation by one or more "words" (a word is a sequence of}K characters delimited by spaces, or else at the end of a line), then each ofgN these words is assigned to a digit-variable that is accessible to the commandsL within the macro definition.  These trailing "words" are called the @i<macroG parameters>.  The first parameter is assigned to @q<\%1>, the second toeK @q<\%2>, and so on, up to a maximum of nine.  The variable @q<\%0> contains  the name of the macro: @begin(example)s9 define demo echo \%0: \%1 \%2 \%3 \%4 \%5 \%6 \%7 \%8 \%9n- demo this is a test of macro argument passings
 @end(example)   J Variables that do not have corresponding parameters are undefined (empty).N The number of arguments passed to the macro is available in the named variableF \v(argc)@foot(which, for compatibility with MS-DOS Kermit, may also be; referred to simply as ARGC, but only within IF conditions.)vK Macro parameters are @i<local> to the macro they are passed to.  If macro AeK invokes macro B, macro B gets its own set of parameters, which are separatetL from macro A's, so that macro A still has its own parameters available afterH macro B has completed.  The variables @q<\%0..\%9> may be used as globalK variables at "top level", when no macros are active, by assigning values to ( them in the normal way.  To demonstrate: @begin(example)r' define xx echo \%1, yy Sneezy, echo \%1o' define yy echo \%1, zz Grumpy, echo \%1g define zz echo \%1	 xx Sleepyl
 @end(example){O Try this, and you'll see how the value of @q<\%1> is saved and restored at eachl level.  ; Macro parameter words may be grouped into single parametersnN by enclosing them in braces.  Try the following example to see how this works: @begin(example)a define msg echo \%0: \%12 msg this is another test of macro argument passing8 msg {this is yet another test of macro argument passing}
 @end(example)ZG You can have a macro list its arguments on your screen by including thee3 command SHOW ARGUMENTS within the macro definition.i  K You can list the names and definitions of all existing macros with the SHOWaM MACROS command.  If you include a name, as in "SHOW MACROS FOO", it will list N the definition(s) of only those macros whose names start with the character(s) you have specified.   F If you define a macro named ON_EXIT, it will be executed automatically when the Kermit program exits.   @subsection(Named Variables)  L Built-in named variables are read-only, you cannot change them.  Their namesO are of the form @q<\v(name)>, in which the v can be lower or uppercase, and thetK parentheses are required around the variable name.  If you refer to a named M variable that does not exist, it will be evaluated as the empty (zero-length)e" string.  C-Kermit's variables are: @begin(d84)EC @q<\v(argc)>@\number of arguments passed to currently active macro.u  L @q<\v(args)>@\number of arguments passed to the program on the command line.@ The program argument vector is assigned to the array @q<\&@@[]>.  M @q<\v(count)>@\current value of COUNT (loop control via SET COUNT, IF COUNT).r  > @q<\v(cpu)>@\CPU hardware type, if known, otherwise "unknown".  O @q<\v(date)>@\current date in @i<dd mmm yyyy> format (e.g. 8 Feb 1990 or 10 NovE 1990)L  3 @q<\v(directory)>@\current device and/or directory.2  I @q<\v(filespec)>@\file specification from most recent SEND, MSEND, or GETh8 command, or the name of the file most recently received.  - @q<\v(fsize)>@\size of last file transferred.b  1 @q<\v(home)>@\user's home (login) directory name.i    @q<\v(host)>@\computer hostname.  - @q<\v(input)>@\current INPUT buffer contents.e  ; @q<\v(line)>@\current communication device or network host.i  = @q<\v(ndate)>@\current date in numeric format, e.g. 19901225.   G @q<\v(ntime)>@\current time in seconds since midnight, 0 through 86399.l  N @q<\v(platform)>@\name specific machine or environment C-Kermit was built for.  4 @q<\v(return)>@\Value of most recent RETURN command.  L @q<\v(speed)>@\Transmission speed of current communication device, if known.B (A spurious value of 38400 might be reported for pseudoterminals.)  J @q<\v(status)>@\0 if the previous command succeeded, nonzero if it failed.  H @q<\v(system)>@\name of generic operating system C-Kermit was built for, such as UNIX or VMS.  G @q<\v(tfsize)>@\total size of all files in the last group of files thatb was transferred.  L @q<\v(time)>@\current time in hh:mm:ss 24-hour clock format (e.g. 13:45:23).  C @q<\v(ttyfd)>@\file descriptor of communication device (UNIX only).   4 @q<\v(version)>@\numeric version number of C-Kermit.	 @end(d84)oJ You can use these variables in any Kermit command where their values would make sense:a1 @example<echo It is \v(time) o'clock on \v(date)> K A @q<\v>-variable's name can be abbreviated, as long as the abbreviation isaD enough to distinguish it from all the other built-in variable names: @q<\v(dir)>, @q<\v(ver)>, etc.  J You can get a listing of Kermit's built-in variables and their values with the SHOW VARIABLES command.,   @subsection(Built-in Functions)e  K Built-in functions are of the form @q<\f>@i<name>(@i<args>).  The F and thegL name can be upper or lower case.  The @i<args> are a comma-separated list ofJ arguments.  The function reference is replaced by its value.  For example: @begin(example)t define \%a ABC123XYZ define \%b ...\Flower(\%a)... 
 @end(example) 6 results in a value of @q<...abc123xyz...> for @q<\%b>.  I The names of built-in functions and variables can be abbreviated to theirtE minimum unique length, for example @q<\feval(1+1)>, @q<\v(dir)>, etc.tL C-Kermit's functions include string-oriented functions that return a string: @begin(d84)EF @q<\Fliteral(>@i<arg>@q<)>@\Copies its argument literally, without any evaluation.i  K @q<\Fcharacter(>@i<arg>@q<)>@\Returns the single character corresponding totI its argument, which must be numeric.  For example, @q<\fchar(65)> is 'A',cN @q<\fchar(193)> is A-acute (in the Latin-1).  If you give a negative number or= a number larger than 255, only the low-order 8 bits are used.   M @q<\Fsubstr(>@i<arg1>@q<,>@i<arg2>@q<,>@q<arg3>@q<)>@\Substring of the stringII @i<arg1> starting at position @i<arg2>, of length @i<arg3>.  @i<arg2> andtI @i<arg3> must be numbers or variables that have numeric values.  Example:e' @example<echo \fsubst(hello there,7,5)>n8 extracts the word "there".  The following is equivalent: @begin(example)e define \%a hello there define \%b 7 define \%c 5 echo \fsubst(\%a,\%b,\%c)B
 @end(example)d  K @q<\Flower(>@i<arg>@q<)>@\Converts all uppercase letters in its argument to  lowercase, for example:s @begin(example)t define \%a FINEs! echo This is a \flower(\%a Mess).i
 @end(example)A prints "This is a fine mess."\  K @q<\Fupper(>@i<arg>@q<)>@\Converts all lowercase letters in its argument too
 uppercase.  G @q<\Freverse(>@i<arg>@q<)>@\Reverses the order of the characters in itsk6 argument, for example @q<\frev(mupeen)> is @q<neepum>.  N @q<\Frepeat(>@i<arg1>@q<,>@i<arg2>@q<)>@\Repeats the first argument the number3 of times given by the second argument, for example:t @example<echo +\frep(-+,10)># produces @q<+-+-+-+-+-+-+-+-+-+-+>.t  K @q<\Flpad(>@i<text>@q<,>@i<n>@q<,>@i<c>@q<)>@\Left-pads the @i<text> out tomO length @i<n> with character @i<c>.  If @i<c> is omitted, blank (space) is used.t  L @q<\Frpad(>@i<text>@q<,>@i<n>@q<,>@i<c>@q<)>@\Right-pads the @i<text> out toO length @i<n> with character @i<c>.  If @i<c> is omitted, blank (space) is used.f  M @q<\Fexecute(>@i<macroname> @i<macro-args>@q<)>@\Execute the named macro withsJ the given parameters (if any), return the macro's RETURN value if any (see RETURN).  E @q<\Fcontents(>@i<variable-name>@q<)>@\Returns the current definitionuG (contents) of a variable.  If the definition includes variable names oraD function references, these are copied literally, without evaluation.  K @q<\Fdefinition(>@i<macro-name>@q<)>@\Returns the literal definition of thee named macro.	 @end(d84)e  3 Here are the string functions that return a number:s @begin(d84)nE @q<\Flength(>@i<arg>@q<)>@\Returns the length of the argument string.\  L @q<\Findex(>@i<arg1>@q<,>@i<arg2>@q<,>@i<arg3>@q<)>@\Returns the position ofM the first occurrence string @i<arg1> in string @i<arg2>, starting at positiondB @i<arg3>.  If @i<arg3> is omitted, then starting at the beginning.	 @end(d84)e   File functions:f @begin(d84)nI @q<\Ffiles(>@i<filespec>@q<)>@\Returns the number of files that match they9 given file specification, for example @q<\ffiles(ck*.c)>.   J @q<\Fnextfile()>@\Returns the next filename that matches the @q<\Ffiles>()L file specification.  Use this in a counted loop (see below) after executing  @q<\Ffiles()>.	 @end(d84)    Integer arithmetic functions:u @begin(d84)vL @q<\Fmax(>@i<arg1>@q<,>@i<arg2>@q<)>@\Returns the maximum of its two numeric
 arguments.  L @q<\Fmin(>@i<arg1>@q<,>@i<arg2>@q<)>@\Returns the minimum of its two numeric
 arguments.  J @q<\Feval(>@i<expression>@q<)>@\Evaluates the given arithmetic expression.F The operands of the expression can be numeric strings or variables, orJ functions that evaluate to numeric strings.  The precedence is the normal,J intuitive algebraic (or programming) precedence, and can be altered by theI use of parentheses, which have higher precedence than any other operator.iH Spaces may be used to separate operators from operands, but they are not	 required.q	 @end(d84)gK Table @ref(-arith) shows the types of expressions accepted by @q<\feval()>.m
 @begin<table>i @bar() @blankspace(1)2 @case[device,postscript="@begin(example,size -1)", else="@begin(example)"]f7 Operator  Fix   Precedence   Operation          Exampler  C  (   )              1         Group             (\%a + 3) * (\%1-5)n?    !      Post      2         Factorial         \%x! - (\%x-2)!   4    ~      Pre       3         Logical NOT       ~\%n4    -      Pre       3         Negative          -\%n  5    ^      In        4         Raise to power    2^\%p   7    *      In        5         Multiply          \%c * 5r7    /      In        5         Divide            \%c / 5e7    %      In        5         Modulus           \%c % 5 7    &      In        5         Logical AND       \%c & 5b  9    +      In        6         Add               \%t + \%ur8    -      In        6         Subtract          27 - \%x7    |      In        6         Logical OR        \%z | 4u7    #      In        6         Exclusive OR      \%z # 4k:    @@      In        6         Greatest Common   \%z @@ 30 			      Divisor
 @end(example) ' @caption<\feval() Arithmetic Functions>T @tag<-arith> @bar() @end<table>e  M You can list the names of Kermit's built-in functions with the SHOW FUNCTIONS- command.  F Two Kermit commands are also available to perform simple arithmetic on
 variables:
 @begin(d4)H INCREMENT @i<name> [@i<value>]@\Add @i<value> to the named variable.  IfL @i<value> is omitted, add 1.  If the variable does not have a numeric value,@ this command has no effect.  Examples: @q<inc \%a, incr \%b 10>.  O DECREMENT @i<name> [@i<value>]@\Subtract @i<value> from the named variable.  If J @i<value> is omitted, subtract 1.  If the variable does not have a numeric# value, this command has no effect.   @end(d4)   @subsection(Script Programming)e  B Kermit's script programming language lets you write procedures, orK @i<programs>, that can include any Kermit command.  Variables and functionsiN can be referenced at practically any point in any command.  Control structuresJ are provided for decision making, transfer of control, looping, scoping ofN variables, and so forth.  A script program can be a TAKE file, a macro, or any combination of the two.D  F The basic idea of a script program is to automate tasks that you wouldI normally do "by hand" when interacting with another computer: dialing the M modem, negotiating through network boxes and front ends, logging in, etc etc.lM You can also write programs to manage local files, or to do anything that you. could do manually with Kermit.  M To automate interaction with another computer, you need a replacement for the N CONNECT command.  This comes in two parts, an OUTPUT command that "types" whatH you would type during CONNECT, and an INPUT command that reads the other5 computer's responses, plus a couple related commands:t+ @begin(description,leftmargin +4,indent -4)aJ OUTPUT @i<text>@\Send the text to the other computer.  The text can be anyI combination of plain ordinary characters, backslash codes, variables, andmI functions.  To send a BREAK signal, include @q<\\B> in the OUTPUT string.nB To send a Long BREAK signal, include @q<\\L> in the OUTPUT string.  L INPUT @i<timeout> @i<text>@\Read responses from the other computer.  Wait upM to @i<timeout> seconds for the specified text to appear.  If the text appears L within the timeout interval, the command succeeds immediately.  Otherwise itH fails.  The @i<text> can contain any combination of ordinary characters,J backslash codes, variables, and functions.  If you want to include leadingI and/or trailing blanks in the INPUT text, surround it with braces, as in:e @example<input 10 {login: }>= INPUT can be interrupted with Ctrl-C, in which case it fails.   K REINPUT @i<timeout> @i<text>@\Searches previous responses from the computer N for the given text.  The timeout parameter is ignored.  The previous responsesK are stored in the INPUT buffer, which is 256 characters long, and which maym0 also be accessed via the @q<\v(input)> variable.  O ECHO [ @i<text> ]@\Display the text on the local screen, followed by a newline.eN The text can contain any combination of backslash codes, variables, functions, etc.  I CLEAR@\Clear any as-yet-unread characters from the communication device's,
 input buffer.r  M PAUSE [ @i<n> ]@\Do nothing for the indicated number of seconds.  If a numberrN is not given, pause for 1 second.  If anything is typed on the keyboard duringM the pause interval, "wake up".  PAUSE can be interrupted by typing Ctrl-C (oru- any other character), in which case it fails.a  E WAIT [ @i<n> [ { CD, CTS, DSR } ] ]@\Wait up to @i<n> seconds for theiI specified modem signals to appear on the currently selected communicationrK device.  If you don't include any modem signal names, WAIT is equivalent tocM PAUSE.  If you include one or more signal names (separated by spaces), KermitbH will wait for @i<all> of the specified signals to appear.  If they don'tM appear within the alloted time, or if the device does not have modem control,rM then the command will fail.  You may interrupt the WAIT command by typing any L character at the keyboard, in which case the command will fail.  The commandK will also fail if modem-signal support is not included in C-Kermit for yourmH particular operating system version.  The modem signals are: CD (carrier7 detect), CTS (Clear To Send), and DSR (Data Set Ready).$ @end(description)  Example: @begin(example)h4 wait 10 cd dsr      ; Wait 5 seconds for CD and DSR.& if success goto ok  ; Test the result.
 @end(example)sK WAIT can be interrupted by typing Ctrl-C (or any other character), in which& case it fails.  A The behavior of the INPUT command can be controlled by SET INPUT: + @begin(description,leftmargin +4,indent -4)aK SET [ INPUT ] CASE {IGNORE, OBSERVE}@\Tells whether alphabetic case mattersbH when searching the remote computer's responses for the INPUT text.  ThisM setting also affects C-Kermit's other string comparison operations, includinga3 IF EQUAL, IF LGT, etc (IF command described later).m  J SET INPUT ECHO { ON, OFF }@\Tells whether the characters read by the INPUT' command should be echoed on the screen.o  L SET INPUT TIMEOUT-ACTION { PROCEED, QUIT }@\Tells whether the script program> should continue or stop immediately if an INPUT command fails. @end(description)o  J At this point Kermit needs a decision making mechanism to tell whether theM INPUT command succeeded or failed.  This is the IF command.  Note that IF canh: be used after INPUT only if you SET INPUT TIMEOUT PROCEED.+ @begin(description,leftmargin +4,indent -4) N IF [NOT] @i<condition> @i<command>@\If the @i<condition> is satisfied, executeK the following Kermit @i<command>.  If the word NOT is included, execute the . command if the condition is @i<not> satisfied.M Only one command may be given, and it must appear on the same line as the IF.  @end(description)dA The IF command supports a wide variety of conditions.  These are:s @begin(d84)o+ IF SUCCESS@\The previous command succeeded.g  ( IF FAILURE@\The previous command failed.  < IF DEFINED @i<name>@\The named variable or macro is defined.  G IF BACKGROUND@\Kermit is running in the background or with its standard  input and output redirected.  G IF COUNT@\Subtract one from COUNT, execute the command if the result is " greater than zero (see SET COUNT).  - IF EXIST @i<filename>@\The named file exists.%  9 IF NUMERIC @i<variable>@\The variable's value is numeric.s  I IF EQUAL @i<s1 s2>@\s1 and s2 (character strings or variables) are equal.n  L IF LLT @i<s1 s2>@\s1 is lexically (alphabetically) less than s2.  Use IF NOT! LGT for less-@|than-@|or-@|equal.c  O IF LGT @i<s1 s1>@\s1 is lexically (alphabetically) greater than s2.  Use IF NOTu$ LLT for greater-@|than-@|or-@|equal.  N IF = @i<n1 n2>@\n1 and n2 (numbers or variables containing numbers) are equal.  C IF < @i<n1 n2>@\n1 is arithmetically less than n2. Use IF NOT > form less-@|than-@|or-@|equal.   I IF > @i<n1 n2>@\n1 is arithmetically greater than n2\n.  Use IF NOT < fori greater-@|than-@|or-@|equal.	 @end(d84) H String comparisons in IF EQUAL, IF LGT, and IF LLT treat alphabetic caseN according to SET INPUT CASE {IGNORE, OBSERVE}.  You can also use @q<\fupper()>G and @q<\flower()> to force caseless comparisons if INPUT CASE is set toe OBSERVE.  G Arithmetic comparisons work with numeric constants, variables and arrayqK elements that evaluate to a numeric string, functions that return a numericgN value, and the special "MS-DOS Kermit compatibility" variables COUNT, VERSION,E and ARGC, which can only appear in this context.  Numeric strings are\M converted to binary integers before comparison, and may be positive, zero, orr= negative.  Floating point ("real") numbers are not supported.a  L The IF command may be followed on the next line by an ELSE command, which isM executed if the IF condition is not true, and which is not executed if the IFl condition is true.  Example: @begin(example)d IF < \%x 10 ECHO It's less ELSE echo It's not less 
 @end(example)   M As in any programming language, it is desirable to be able to go to differentaN places in the program based on the decisions made by IF commands.  The command for going-to is:+ @begin(description,leftmargin +4,indent -4)a@ GOTO @i<label>@\Go to the command which follows the named label. @end(description)mJ A label is a word beginning with a colon (:) on the left margin.  Example: @begin(example)e IF < \%x 10 goto less  echo It's not less goto fin :less  ECHO It's less :fin
 @end(example)   M Several other commands are especially useful in conditional contexts, i.e. asr objects of IF commands:r+ @begin(description,leftmargin +4,indent -4) H STOP@\Stop executing the current script program (TAKE file or macro) andK return immediately to C-Kermit prompt level (or, if Kermit was invoked with<9 command-line action arguments, exit C-Kermit altogether).t  M END [ @i<n> ]@\Go "up" one command level.  Exit the currently executing macrowH or TAKE file, and return to the invoking TAKE file or macro.  Or, if theN current TAKE file or macro was invoked from @q(C-Kermit>) prompt level, returnM to the prompt.  Or, if Kermit was invoked with command-line action arguments,oK exit C-Kermit.  If a value is given, it is used to set the SUCCESS flag (ifzA the value is zero) or the FAILURE flag (if the value is nonzero).l. You can use POP as a synonym for this command.  H RETURN [@i<value>]@\For use within macros.  Just like END, except that aL return value may be set.  This is for use with the @q<\fexecute()> function,? which allows you to write user-defined functions.  For example:m @begin(example)e def sum if = \%1 1 return 1,- :   else return \feval(\%1 + \fexecute(sum \feval(\%1 - 1)))
 @end(example)oG This function, called SUM, returns the sum of all the numbers from 1 to)? whatever number (1 or greater) it was called with, for example:  @example<echo \fexec(sum 5)>G prints the number 15.  Notice that this function calls itself; C-Kermit ! functions are allowed to do this.i @end(description)m  K Although the object command of an IF or ELSE statement may only be a singleML command, that command is allowed to be a macro invocation or a TAKE command.M This provides a kind of statement grouping that can be used to avoid a lot ofaL confusing GOTOs.  A more flexible kind of statement grouping is available in  the XIF ("extended IF") command:+ @begin(description,leftmargin +4,indent -4)oG XIF @i<condition> { @i<command-list> } [ ELSE {  @i<command-list> } ]@\uG In this extended form, braces are required to enclose a comma-separatedqL list of one or more commands, and the ELSE clause is on the same line as the XIF.  Example:I @case<device,postscript="@begin(example,size -1)",else="@begin(example)"> A xif < \%x 10 {ech Less,def \%m 10} else {ec Not less,def \%m \%x}e
 @end(example) J Here the appropriate message is echoed, depending on the value of @q<\%x>,F and the minimum of @q<\%x> and 10 is assigned to the variable @q<\%m>.N Commands like this one can be broken onto multiple lines for clarity, but only5 if you use dash (or backslash) for line continuation:. @begin(example)b xif < \%x 10 { -     echo Less, -     def \%m 10 -
 } else { -     echo Not less, -     def \%m \%x -  }.
 @end(example)  @end(description) 4 WARNING: RETURN or END statements should not be used within an XIF command.  8 @subheading(Other Ways of Assigning Values to Variables)  K Sometimes it is desirable for a script program to interact with you as wellnL as with the remote computer.  For example, you should not store passwords onM disk, so you can't write script programs that contain them.  However, you canaL write script programs that prompt you for your password.  This is done using the ASK or ASKQ command:+ @begin(description,leftmargin +4,indent -4)fK ASK @i<name> @i<prompt>@\Print the prompt on the screen and wait for you to8L type a line of text (terminated by carriage return), and assign this line ofJ text to the named variable (but without the carriage return), for example: @begin(example)n ask \%p Password:e
 output \%p\13i
 @end(example) G The prompt may be enclosed in { curly braces } to retain leading and/orr trailing spaces.  D ASKQ @i<name> @i<prompt>@\Just like ASK, but it "asks quietly".  TheB characters you type do not echo.  Especially useful for passwords. @end(description)w  K GETOK @i<text>@\Asks a "yes or no" question.  The @i<text> is the question.,J Enclose it in curly braces to preserve leading or trailing spaces.  If theK user replies "Yes" or "OK" (or any abbreviation of these), the SUCCESS flagaI is set (for IF SUCCESS).  If she replies "N" or "No", the FAILURE flag is  set.  K Now, with IF, branching, ASK, and so forth, we can add to our login script:oI @case<device,postscript="@begin(example,size -1)",else="@begin(example)">a @tabclear()@tabdivide(2): define error echo Error: \%1, end@\; Error-handling macro.7 set input timeout proceed@\; Don't quit if INPUT fails.@8 set input case ignore@\; Alphabetic case doesn't matter.* set input echo off@\; Don't need to watch.. output \13@\; Send carriage return (ASCII 13).2 input 5 login:@\; Wait 5 secs for "login:" prompt.> if fail error {No login prompt}@\; Give up if it doesn't come.2 output myuserid\13@\; Send user ID followed by CR.. input 5 password:@\; Wait for password prompt.A if fail error {No password prompt}@\; Give up if it doesn't come. - ask \%p Password:@\; Prompt user for password'( output \%p\13@\; Send it, followed by CR, input 30 $\32@\; Wait for system prompt "$ "? if fail error {No system prompt}@\; Give up if it doesn't come.i connect@\; Got it, connect.a
 @end(example)r  , @subheading(Reading and Writing Local Files)  K It is also possible to assign data from local files to variables.  In fact,oG C-Kermit includes an entire input and output system for local files andt	 commands:r+ @begin(description,leftmargin +4,indent -4)R OPEN @i<mode> @i<filename>@\K For use with READ and WRITE commands.  Open the local file in the specifiedtJ mode: READ, WRITE, or APPEND.  !READ and !WRITE mean to read from or write2 to a system command rather than a file.  Examples: @begin(example)a OPEN READ oofa.txt OPEN !READ ls ck[uwc].[cwh] 
 @end(example)qK The first example reads lines from the file @q<oofa.txt>.  The second readseM filenames from a UNIX directory listing; this gives you a way to select filesuJ using your UNIX shell's filename-@|matching metacharacters, which are more% powerful than Kermit's built-in ones.f  N READ @i<name>@\The next line from the current OPEN READ or OPEN !READ file is K assigned to the named variable, for example @q<READ \%A>.  If no more lineso& remain in the file, the command fails.   WRITE @i<name> @i<text>@\ J Writes the given text to the named log or file.  The text text may includeJ backslash codes, and is not terminated by a newline unless you include theB appropriate code.  The name parameter can be any of the following:4 @begin(description,leftmargin +4,indent -4,spread 0)	 DEBUG-LOGr  8 FILE (the OPEN WRITE, OPEN !WRITE, or OPEN APPEND file).  
 PACKET-LOG  K SCREEN (just like ECHO except that WRITE does not supply a line terminator)d   SESSION-LOGe   TRANSACTION-LOGs @end(description)   F CLOSE @i<name>@\Closes the named file.  A READ or !READ file is closedL automatically when end-of-file (EOF) is encountered during a READ operation,L but it does no harm to close it again.  WRITE, !WRITE, and APPEND files must9 be closed explicitly.  Examples: CLOSE READ, CLOSE WRITE.  @end(description) L A typical script program for reading and writing files might look like this: @begin(example)( @tabclear@tabdivide(2), set take error off@\; So EOF can be handled.' open read foo@\; Open input file "foo". ) open write bar@\; Open output file "bar".s! def \%c 0@\; Make a line counter.n  :loop@\; Loop to read all lines.# read \%a@\; Read one line into \%a. ( if fail goto done@\; Catch EOF this way.  increment \%c@\; Count the line.5 write file \%c. \fupp(\%a)\10@\; Format and write it. " goto loop@\; Go back and get more. :done  close read@\; Finished,  close write@\; close the files. " echo All done.@\; Print a message.
 @end(example)   K The previous example shows a loop, which is a common programming construct.RK It is always desirable to avoid infinite loops.  The READ example does this	1 by testing for end of file (EOF) with IF FAILURE.r   @subheading(Counted Loops)  K Kermit also provides for "finite", or counted, loops, in several varieties:i+ @begin(description,leftmargin +4,indent -4) K SET COUNT / IF COUNT@\Here a special variable, COUNT, is set.  The IF COUNT:H command decrements the count variable, and if the result is greater than" zero, executes the object command: @begin(example)r set count 5t :loop  echo \v(count) if count goto loop else echo Zero!:
 @end(example)c  > FOR@q< >@i<variable>@q< >@i<iv>@q< >@i<fv>@q< >@i<step>@q< >@~/ {@q< >@i<command>,@q< >@i<command>,@q< ... >}@\dC The FOR loop is controlled by a loop @i<variable> which is assignedoJ an initial value (@i<iv>), gets tested against a final value (@i<fv>), andI gets incremented by a @i<step> value.  If the step value is positive, the>J loop exits when the loop variable is greater than the final value.  If theN step is negative, the loop exits when the variable becomes less than the final8 value.  Example (cute way to print the 9's times table): @begin(example),7 for \%i 0 9 1 { assign \%j \feval(9-\%i), echo \%i\%j }c
 @end(example)b FOR loops can be nested: @begin(example) 3 for \%i 1 5 1 { for \%j 5 \%i -1 { echo \%i:\%j } }o
 @end(example)a  K WHILE@q< >@i<condition>@q< >{@q< >@i<command>,@q< >@i<command>,@q< ... >}@\rD The commands are executed as long as the @i<condition> is true.  The8 conditions are the same as for the IF command.  Example: @begin(example)o# while not exist foo.bar { sleep 1 } 
 @end(example)h5 This loop waits until file named @q<foo.bar> appears.N @end(description)cI FOR and WHILE loops can be nested in any combination.  Both FOR and WHILEnJ loops may be exited or continued prematurely using the following commands:+ @begin(description,leftmargin +4,indent -4)r9 BREAK@\Exit from the closest enclosing FOR or WHILE loop.   K CONTINUE@\Begin the next iteration (if any) of the closest enclosing FOR or  WHILE loop immediately.e @end(description)   J WARNING: RETURN and END commands should not be used in the object commands of FOR, WHILE, or XIF.  @ Here's a script program example that has nothing to do with dataL communication or file transfer, but which illustrates the control structuresM of the script language, the use of arrays, statement grouping, file i/o, etc:rI @case<device,postscript="@begin(example,size -1)",else="@begin(example)">c@ ; Kermit script program to read a file of numbers into an array,< ; sort the array numerically, and display the sorted result. ;/9 def \%d 100                   ; Allow up to 100 elements.e1 dcl &a[\%d]		      ; Declare a 100-element array. 6 set take error off            ; To handle EOF on READ.; open read numbers.dat         ; Open this file for reading.m  . ; Read each line into a separate array element ;m echo Reading...  for \%n 1 \%d 1 { -s     read \&a[\%n], -     if fail break -2 }cB decr \%n                      ; Subtract one for read that failed.9                               ; Check for too many lines.l xif > \%n \%d { -e"     echo Too many lines in file, -
     stop - }i0 echo Array initialized: \%n elements, sorting...  : ; Sort the array using the (slow) "bubble sort" algorithm. ;i assign \%m \feval(\%n-1) for \%i 1 \%m 1 { -@     for \%j \%i \%n 1 { -e 	xif > \&a[\%i] \&a[\%j] { - 	    assign \%t \&a[\%i], -   	    assign \&a[\%i] \&a[\%j], - 	    assign \&a[\%j] \%t - 	} -     } -w }    ; Display the sorted array.b ;y echo sorted.: for \%i 1 \%n 1 { echo \flpad(\%i,3). \flpad(\&a[\%i],5) }
 @end(example)C   @section(The SCRIPT Command) @label(-scrcmd)   K The SCRIPT command allows connection and login sequences to be specified iniD a single, cryptic line in the style of the UNIX uucp @q<L.sys> file.  : Syntax: @q(SCRIPT )@i(expect send )[@i(expect send)] . . .  L "expect" has the syntax: @i(expect)[@i(-send-expect)[@i(-send-expect)[...]]]  H The SCRIPT command carries on a "canned dialog" with a remote system, inO which data is sent according to the remote system's responses.  The typical usen3 is for logging in to a remote system automatically.   ) A login script is a sequence of the form:l- @example(@i<expect send [expect send] . . .>)dL where @i(expect) is a prompt or message to be issued by the remote site, andG @i(send) is the string (names, numbers, etc) to return, and expects aredN separated from sends by spaces.  The send may also be the keyword EOT, to sendN Control-D, or BREAK, to send a break signal.  Letters in sends may be prefixed1 by `@q[~]' to send special characters, including:y4 @begin(description,leftmargin +8,indent -4,spread 0) @q(~b)@\backspace   
 @q(~s)@\spacen  8 @q(~q)@\`@q[?]'(trapped by Kermit's command interpreter)   @q(~n)@\linefeed   @q(~r)@\carriage return\   @q(~t)@\tabl   @q(~')@\single quote   @q(~-)@\dash (hyphen)    @q(~~)@\tilde itself   @q(~")@\double quote   @q(~x)@\XON (Control-Q)i  & @q(~c)@\don't append a carriage return  C @q(~)@i(o[o[o]])@ @ octal representation of an ASCII character codeN  + @q(~d)@\delay approx 1/3 second during sende  H @q(~w)@i([d[d]])@ @ wait specified interval during expect, then time out   @q(\\b)@\send a BREAK signal @end(description) O As with some UUCP systems, sent strings are followed by @q(~r) unless they havee	 a @q(~c).i  J Only the last 7 characters in each expect are matched.  A null @i(expect),J e.g. @q(~0) or two adjacent dashes, causes a short delay before proceeding: to the next send sequence.  A null expect always succeeds.  F As with UUCP, if the expect string does not arrive, the script attemptF fails.  If you expect that a sequence might not arrive, as with UUCP, 3 conditional sequences may be expressed in the form: - @example(@i<-send-expect[-send-expect[...]]>)tE where dashed sequences are followed as long as previous expects fail.sB Timeouts for expects can be specified using @q(~w); @q(~w) with no arguments waits 15 seconds.T  A @i(expect-send) transactions can be easily be debugged by logginggD transactions.  This records all exchanges, both expected and actual.G The script execution will also be logged in the session log, if that isg
 activated.  G Note that `@q[\]' characters in login scripts, as in any other C-KermittE interactive commands, must be doubled up.  A line may be ended with an  single `@q[\]' for continuation.   Example one:  I Using a modem, dial a UNIX host site.  Expect "login" (...gin), and if itmD doesn't come, simply send a null string with a @q(~r).  (Some UNIXesH require either an EOT or a BREAK instead of the null sequence, dependingD on the particular site's "logger" program.)  After providing user idF and password, respond "x" to a question-mark prompt, expect the BourneH shell "@q($)" prompt (and send return if it doesn't arrive).  Then cd toC directory kermit, and run the program called "wermit", entering the 1 interactive connect state after wermit is loaded.s @begin(example)u set modem ventel set line /dev/tty77c
 set baud 1200a dial 9&5551212: script gin:--gin:--gin: smith ssword: mysecret ~q x $--$ \  cd~skermit $ wermit connectT
 @end(example)e@ Note that SET LINE is issued @i<after> SET MODEM, but @i<before>, SET BAUD or other line-@|related parameters.   Example two:   @index(TELENET) L Using a modem, dial the Telenet network.  This network expects three returnsM with slight delays between them.  These are sent following null expects.  TheuO single return is here sent as a null string, with a return appended by default.tI Four returns are sent to be safe before looking for the prompt.  Then thexN Telenet id and password are entered.  Then Telenet is instructed to connect toL a host site (c 12345).  The host has a data switch that asks "which system";N the script responds "myhost" (if the "which system" prompt doesn't appear, theM Telenet connect command is reissued).  The script waits for an @qq"@@" prompt L from the host, then sends the user ID ("joe") and password ("secret"), looksO for another @qq<@@> prompt, runs Kermit, and in response to the Kermit's promptaJ (which ends in @qq[>]), gives the commands "set parity even" and "server".D Files are then exchanged.  The commands are in a take file; note theI continuation of the 'script' command onto several lines using the `@q[\]'  terminator.  @begin(example)  set modem hayesr set line /dev/acus set speed 1200 set parity mark) dial 9,5551212/ script ~0 ~0 ~0 ~0 ~0 ~0 ~0 ~0 @@--@@--@@ id~s\o4 aa001122 = 002211 @@ c~s12345 ystem-c~s12345-ystem \< myhost @@ joe~ssecret @@ kermit > set~sparity~seven > server send some.stuff  get some.otherstuff  byea quit
 @end(example)mD Since these commands may be executed totally in the background, theyH can also be scheduled.  A typical shell script, which might be scheduled9 by cron, would be as follows (csh used for this example):<   @begin(example)o #r; # Keep trying to dial and log onto remote host and exchange"5 # files, wait 10 minutes before retrying if it fails.w #  cd someplace while ( 1 )h+     kermit < ./tonight.cmd >> nightly.log &u     if ( ! $status ) break
     sleep 600q endr
 @end(example)vI File @q(tonight.cmd) might have two takes in it, for example, one to takeiD a file with the set modem, set line, set baud, dial, and script, andE a second take of a file with send/get commands for the remote server.v9 The last lines of @q(tonight.cmd) should be BYE and QUIT.o    @section(Command Line Operation) @label(-cmdlin)   H A subset of Kermit's commands is available using UNIX-style command lineJ options, on operating systems that support passing of command-line options/ to programs through the "argv, argc" mechanism.f  K The C-Kermit command line syntax mostly conforms to the @ux(Proposed Syntax)J Standards for UNIX System Commands) put forth by Kathy Hemenway and HeleneM Armitage of AT&T Bell Laboratories in @i(UNIX/World), Vol.1, No.3, 1984.  The  rules that apply are:s @begin(itemize,spread 0)A Command names must be between 2 and 9 characters ("kermit" is 6).r  > Command names must include lower case letters and digits only.  % An option name is a single character.l  ! Options are delimited by '@q(-)'.   H Options with no arguments may be grouped (bundled) behind one delimiter.  $ Option-arguments cannot be optional.  > Arguments immediately follow options, separated by whitespace.  % The order of options does not matter."  A '@q(-)' preceded and followed by whitespace means standard input. 
 @end(itemize)nG A group of bundled options may end with an option that has an argument.d  7 The following notation is used in command descriptions:i @begin(d84)m@ @i(fn)@\A file specification, possibly containing the "wildcard"M characters `@q[*]' or `@q[?]' (`@q[*]' matches all character strings, `@q[?]'p matches any single character).  L @i(fn1)@\A UNIX file specification which may not contain `@q[*]' or `@q[?]'.  M @i(rfn)@\A remote file specification in the remote system's own syntax, which>- may denote a single file or a group of files.o  M @i(rfn1)@\A remote file specification which should denote only a single file.y  ) @i(n)@\A decimal number between 0 and 94.i  F @i(c)@\A decimal number between 0 and 127 representing the value of an ASCII character.  ? @i(cc)@\A decimal number between 0 and 31, or else exactly 127,s5 representing the value of an ASCII control character.t  0 @q([ ])@\Any field in square braces is optional.  5 @q({x,y,z})@\Alternatives are listed in curly braces.i	 @end(d84)   H C-Kermit command line options may specify any combination of actions andG settings.  If C-Kermit is invoked with a command line that specifies nowJ actions, then it will issue a prompt and begin interactive dialog.  ActionD options specify either protocol transactions or terminal connection.  K An implicit TAKE command is executed upon your C-Kermit initialization file<L when C-Kermit starts up, upon either interactive or command-line invocation.M This file may contain C-Kermit interactive-mode commands, which are explained  later.  J In addition, if the first command line argument is the name of an existingF file, C-Kermit will read that file and execute Kermit interactive-modeO commands from it, in addition to (and after) your initialization file (if any).p Example:) @example<$ @ux[kermit cmdfile -b 3 -p m]>hK In UNIX, this feature allows you to invoke C-Kermit by "running" a C-Kermitp/ command file, if its first line is of the form:t @example<#!/dir/kermit> M That is, number sign followed by exclamation point, followed by the full file J specification of the Kermit program.  You must also give this file execute permission:s! @example<$ @ux[chmod +x cmdfile]>sK Then you can run this file as if it were a program, and it will feed itself  to C-Kermit automatically: @example[$ @ux<cmdfile>]3 You can even include C-Kermit command line options:e+ @example[$ @ux<cmdfile -l /dev/ttyh8 -p e>]eM If you want the shell prompt to return automatically at the end of this file,;I include an EXIT command at the end of it.  Otherwise you will receive then* C-Kermit prompt when the file is finished.  ) Here are C-Kermit's command-line options:n @begin<d84> K @q(=)@\Ignore all command-line options that follow (but make them availabler% to the user in the array @q<\&@@[]>).u  J @q(-Y )@\(uppercase) Do not execute commands from the initialization file.  J @q(-y )@i(fn)@\Read commands from the specified file instead of the normal initialization file.  M @q(-C ")@i<command, command, >@q<...">@\Execute the interactive-mode commandsuJ after the initialization file (if any), the other command-line options (ifM any), and the command or application file (if any).  The command list must be $ enclosed in double quotes.  Example:8 @example(kermit -C "set file type binary, set window 2")I The commands in this list are assigned to a macro called @q<cl_commands>,sK so you can also execute them later during your session simply by typing then name of this macro: # @example(C-Kermit>@ux[cl_commands]) L The -C option does is not considered an "action" option, even if the commandM list contains action commands, so if there are no other action commands amongrN the command-line arguments, the C-Kermit prompt appears after the last commandK in the list is executed.  To defeat this behavior, include EXIT as the lasto command:+ @example(kermit -C "echo \27[2J\27H, exit")e  J @q(-S )@\("Stay") This option tells C-Kermit to issue its prompt and enterJ interactive command mode, even if the command-line options included action	 commands.s	 @end<d84>@  % These are the file-transfer commands:P @begin<d84>ED @q(-s )@i(fn)@\Send the specified file or files.  If @i(fn) containsF wildcard (meta) characters, the UNIX shell expands it into a list.  OnA non-UNIX systems, Kermit expands any wildcard characters.  @i(fn)i# may also be a list of files, as in:l. @example<kermit -s ckcmai.c ckuker.h mail.txt>E If @i(fn) is '@q[-]' then kermit sends from standard input, which mayo come from a file:b @example(kermit -s - < foo.bar)d or a parallel process:( @example(ls -l | grep cmg | kermit -s -)% You cannot use this mechanism to send H terminal typein.  If you want to send a file whose actual name is @qq(-)* you can precede it with a path name, as in @example(kermit -s ./-)i  E @q(-r)@\Receive a file or files.  Wait passively for files to arrive.a  E @q(-k)@\Receive (passively) a file or files, sending them to standardt1 output.  This option can be used in several ways:d+ @begin(description,leftmargin +4,indent -4)aJ @q(kermit -k)@\Displays the incoming files on your screen; to be used only in "local mode" (see below).  L @q(kermit -k > )@i(fn1)@\Sends the incoming file or files to the named file,F @i(fn1).  If more than one file arrives, all are concatenated together into the single file @i(fn1).u  D @q(kermit -k | command)@\Pipes the incoming data (single or multiple& files) to the indicated command, as in) @example'kermit -k | sort > sorted.stuff't @end(description)   J @q(-a )@i(fn1)@\If you have specified a file transfer option, you may giveG an alternate name for a single file with the @q(-a) ("as") option.  Forl example, @example'kermit -s foo -a bar'E sends the file @q(foo) telling the receiver that its name is @q(bar).a@ If more than one file arrives or is sent, only the first file is affected by the @q(-a) option: @example'kermit -ra baz'6 stores the first incoming file under the name @q(baz).  L @q(-x)@\Begin server operation.  May be used in either local or remote mode.	 @end(d84)v  C Before proceeding, a few words about remote and local operation areNJ necessary.  C-Kermit is "local" if it is running on PC or workstation thatE you are using directly, or if it is running on a multiuser system andoH transferring files over an external communication line -- not your job'sJ controlling terminal or console.  C-Kermit is remote if it is running on aK multiuser system and transferring files over its own controlling terminal'sqC communication line (normally @q</dev/tty>), connected to your PC or< workstation.  L If you are running C-Kermit on a PC, it is normally used in local mode, withM the "back port" designated for file transfer and terminal connection, and theeN keyboard and screen available to control or interrupt the file transfer and toM display its status.  If you are running C-Kermit on a multiuser (timesharing)nJ system, it is in remote mode unless you explicitly point it at an externalF line for file transfer or terminal connection.  The following command 7 determines whether C-Kermit is in local or remote mode:    @begin(d84) @ @q(-l )@i(dev)@\Line  -- Specify a terminal line to use for file( transfer and terminal connection, as in: @example'kermit -l /dev/ttyi5'J You can also give an open file descriptor for a serial communication (tty) device.r	 @end(d84)m  G When an external line is being used, you will also need some additionald< options for successful communication with the remote system:   @begin(d84)rK @q(-b )@i(n)@\Bits per second -- Specify the transmission speed in bits per D second ("baud rate") for the line given in the @q(-l) option, as in:& @example'kermit -l /dev/ttyi5 -b 9600'G This option should always be included with the @q(-l) option, since theo= speed of an external line is not necessarily what you expect.e  O @q(-p )@i(x)@\Parity -- e,o,m,s,n (even, odd, mark, space, or none).  If parityRN is other than none, then Kermit's 8th-bit prefixing mechanism will be used forI transferring 8-bit binary data, provided the opposite Kermit agrees.  Theo default parity is none.f  H @q(-t)@\Specifies half duplex, line turnaround with XON as the handshakeI character, used mainly for communicating with IBM mainframes in linemode.p  L @q(-m)@i(name)@\Modem type -- hayes, penril, vadic, etc.  For a complete andJ up-to-date list, run C-Kermit interactively and type "set modem ?".  Note:G name must be given in lowercase, but can be abbreviated, e.g. "hay" for  "hayes".	 @end(d84)a  G If you wish to use a network connection rather than a terminal line for 3 communication, use the following options rather -l:  @begin(d84) E @q(-j )@i(name)@\Host -- Specify a network host name.  This option ismH currently supported for TCP/IP Telnet connections on Berkeley-based UNIXM implementations only, and for VAX/VMS when equipped with TGV MultiNet TCP/IP.eM The speed (-b) parameter does not apply to network connections.  The name can I be an IP host name, an IP host number (containing dots), or either one ofzM these followed by a colon and then a TCP service name or number.  It can also I be just a number, in which case it is assumed to be a file descriptor for ! an open TCP/IP TELNET connection.[  D @q(-X )@i(address)@\X.25 address -- Specify an X.25 network address.  K @q(-Z )@i(number)@\X.25 file descriptor -- Specify a file descriptor for anb% X.25 connection that is already open.c	 @end(d84)%  I The following commands may be used only with a C-Kermit which is in locall mode.c   @begin(d84)CG @q(-g )@i(rfn)@\Actively request a remote server to send the named file N or files; @i(rfn) is a file specification in the remote host's own syntax.  IfL @i(fn) happens to contain any special shell characters, like space, '@q(*)',3 '@q([)', '@q(~)', etc, these must be quoted, as in:  @example'kermit -g x\*.\?' or:c" @example'kermit -g "profile exec"'  3 @q(-f)@\Send a 'finish' command to a remote server.   E @q(-c)@\Establish a terminal connection over the specified or defaultt@ communication line, before any protocol transaction takes place.; Get back to the local system by typing the escape characterr8 (normally Control-Backslash) followed by the letter 'c'.  F @q(-n)@\Like @q(-c), but @i(after) a protocol transaction takes place;J @q(-c) and @q(-n) may both be used in the same command.  The use of @q(-n)  and @q(-c) is illustrated below.	 @end(d84) O If the other Kermit is on a remote system, the @q(-l) and @q(-b) options shouldg< also be included with the @q(-r), @q(-k), or @q(-s) options.  0 Several other command-line options are provided: @begin(d84)r @index(Binary Files)O @q(-i)@\Specifies that files should be sent or received exactly "as is" with noiM conversions.  This option is necessary for transmitting binary files.  It mayqI also be used in UNIX-to-UNIX transfers (it must be given to @i<both> UNIX O Kermit programs), where it will improve performance by circumventing the normal\K text-file conversions, and will allow mixture of text and binary files in atO single file group.  But only use it if character-set translation is not needed.i  L @q(-w)@\Writeover -- An incoming file should write over any existing file ofN the same name.  Changes the default behavior, which is to back up the existing! file before creating the new one.o  K @q(-e @i<n>)@\Extended packet length -- Specify that C-Kermit is allowed toeJ receive packets up to length @i<n>, where @i<n> may be between 10 and someN large number, like 1000 or 2000, depending on the system.  The default maximumL length for received packets is 90.  Packets longer than 94 will be used onlyK if the other Kermit supports, and agrees to use, the "long packet" protocole# extension, and if you request them.   E @q(-v @i<n>)@\Window size -- Specify that C-Kermit is allowed to sendoM and receive files using a window size of @i<n>.  That is, up to @i<n> packets K may be sent before acknowledgements are required.  This speeds up transfersdJ in most situations, especially long distance network connections.  DefaultM window size is 1, maximum is 32.  Sizes greater than 1 work only if the othera Kermit supports this option.  J @q(-q)@\Quiet -- Suppress screen update during file transfer, for instance6 to allow a file transfer to proceed in the background.  I @q(-z)@\Force foreground mode: even if Kermit thinks it is running in thesD background, this will make it issue its normal prompts and messages. Example: @example(kermit -z | vt100),  K @q(-d)@\Debug -- Record debugging information in the file @q(debug.log) in dB the current directory.  Use this option if you believe the program8 is misbehaving, and show the resulting log to your local Kermit maintainer.  E @q(-h)@\Help -- Display a brief synopsis of the command line options.n	 @end(d84)oE The command line may contain no more than one protocol action option.l   @begin(comment)7M Files are sent with their own names, except that lowercase letters are raisedrO to upper, pathnames are stripped off, certain special characters like (`@q[~]')EH and (`@q[#]') are changed to `@q(X)', and if the file name begins with aJ period, an `@q(X)' is inserted before it.  Incoming files are stored underM their own names except that uppercase letters are lowered, and, if @q(-w) wastK specified, a "generation number" is appended to the name if it has the samerM name as an existing file which would otherwise be overwritten.  If the @q(-a)sH option is included, then the same rules apply to its argument.  The fileD transfer display shows any transformations performed upon filenames.
 @end(comment).  2 During transmission, files are encoded as follows: @begin(itemize)o8 Control characters are converted to prefixed printables.  D Sequences of repeated characters are collapsed via repeat counts, ifK the other Kermit is also capable of repeated-@|character compression.  Thisc$ feature is negotiated automatically.  H If parity is being used on the communication line, data characters with I the 8th (parity) bit on are specially prefixed, provided the other KermitcE is capable of 8th-bit prefixing; if not, 8-bit binary files cannot be L successfully transferred.  This feature is negotiated if you give the @q(-p) option.   J Conversion is done between UNIX newlines and carriage-@|return-@|linefeed 1 sequences unless the @q(-i) option was specified. 
 @end(itemize)2  # @subheading(Command Line Examples:)t  ) @exx(kermit -l /dev/ttyi5 -b 1200 -cn -r)pH This command connects you to the system on the other end of @q(ttyi5) atA 1200 baud, where you presumably log in and run Kermit with a SEND H command.  After you escape back, C-Kermit waits for a file (or files) toD arrive.  When the file transfer is completed, you are reconnected to) the remote system so that you can logout.n  4 @exx(kermit -l /dev/ttyi4 -b 1800 -cntp m -r -a foo)H This command is like the preceding one, except the remote system in thisE case uses half duplex communication with mark parity.  The first files. that arrives is stored under the name @q(foo).  + @exx(kermit -l /dev/ttyi6 -b 9600 -c | tek),F This example uses Kermit to connect your terminal to the system at theB other end of @q(ttyi6).  The C-Kermit terminal connection does notH provide any particular terminal emulation, so C-Kermit's standard i/o isG piped through a (hypothetical) program called tek, which performs (say)  Tektronix emulation.  & @exx(kermit -l /dev/ttyi6 -b 9600 -nf)H This command would be used to shut down a remote server and then connectG to the remote system, in order to log out or to make further use of it.tM The @q(-n) option is invoked @i(after) @q(-f) (@q[-c] would have been invoked  before).  / @exx(kermit -l /dev/ttyi6 -b 9600 -qg foo.\* &) M This command causes C-Kermit to be invoked in the background, getting a group N of files from a remote server (note the quoting of the `@q[*]' character).  NoA display occurs on the screen, and the keyboard is not sampled forlD interruption commands.  This allows other work to be done while file0 transfers proceed in the background.  UNIX only.  D @exx(kermit -l /dev/ttyi6 -b 9600 -g foo.\* > foo.log < /dev/null &)K This command is like the previous one, except the file transfer display hassO been redirected to the file @q(foo.log).  Standard input is also redirected, tor< prevent C-Kermit from sampling it for interruption commands.   @exx(kermit -iwx)fK This command starts up C-Kermit as a server.  Files are transmitted with nonG newline/@|carriage-@|return-@|linefeed conversion; the @q(-i) option iseG necessary for binary file transfer and recommended for UNIX-@|to-@|UNIX O transfers.  Incoming files that have the same names as existing files are givena new, unique names.  " @exx(kermit -l /dev/ttyi6 -b 9600)G This command sets the communication line and speed.  Since no action ishI specified, C-Kermit issues a prompt and enters an interactive dialog withfG you.  Any settings given on the command line remain in force during they" dialog, unless explicitly changed.   @exx(kermit)F This command starts up Kermit interactively with all default settings.  F The next example shows how UNIX Kermit might be used to send an entireH directory tree from one UNIX system to another, using the tar program asL Kermit's standard input and output.  On the originating system, in this case. the remote, type (for instance):@label(-uxtar)  ' @exx(tar cf - /usr/fdc | kermit -is - )cM This causes tar to send the directory @q(/usr/fdc) (and all its files and allmM its subdirectories and all their files...) to standard output instead of to atK tape; kermit receives this as standard input and sends it as a binary file.mI On the receiving system, in this case the local one, type (for instance):   2 @exx(kermit -il /dev/ttyi5 -b 9600 -k | tar xf - )L Kermit receives the tar archive, and sends it via standard output to its ownM copy of tar, which extracts from it a replica of the original directory tree.i  K A final example shows how a UNIX compression utility might be used to speedt up Kermit file transfers:  @begin(example) - compress file | kermit -is -     (@i(sender))u/ kermit -ik | uncompress          (@i(receiver))p @end(example)	   @section(UNIX Specifics)  ! @subsection(The UNIX File System)C  M Consult your UNIX manual for details about the file system under your versiont? of UNIX.  In general, UNIX files have lowercase names, possiblyaN containing one or more dots or other special characters.  UNIX directories areD tree-@|structured.  Directory levels are separated by slash (@qq[/]) characters.  For example,c @example(/usr/foo/bar)K denotes the file @q(bar) in the directory @q(/usr/foo).  Alphabetic case ispM significant in UNIX file and directory names, i.e. @qq<a> is a different filepJ (or directory) from @qq<A>.  Wildcard or "meta" characters allow groups ofL files to be specified.  @qq(*) matches any string; @qq(?) matches any single
 character.  J When C-Kermit is invoked with file arguments specified on the UNIX commandK line, the UNIX shell (Bourne Shell, C-Shell, K-Shell, etc) expands the metamO characters itself, and in this case a wider variety is available.  For example,@M @example(kermit -s ~/ck[uvm]*.{upd,bwr}]) is expanded by the Berkeley C-ShellaM into a list of all the files in the user's home directory (@q[~/]) that starthO with the characters "@q(ck)", followed by a single character @qq(u), @qq(v), or O @qq(m), followed by zero or more characters, followed by a dot, followed by one M of the strings @qq(upd) or @qq(bwr).  Internally, the C-Kermit program itselfT3 expands only the @qq(*) and @qq(?) meta characters.   N UNIX files are linear (sequential) streams of 8-bit bytes.  Text files consistL of 7-bit ASCII or ISO-646 NRC characters, with the high-@|order bit off (0),I or in very recent versions of UNIX, of 8-bit characters in an ASCII-basedmM international standard character set such as ISO 8859 Latin Alphabet 1.  TextrN file lines are separated by the UNIX newline character, which is linefeed (LF,G ASCII 10).  This distinguishes UNIX text files from those on most otherhB ASCII-based stream file systems, in which lines are separated by aJ carriage-@|return linefeed sequence (CRLF, ASCII 13, followed by linefeed,K ASCII 10).  Binary files are likely to contain data in the high bits of the < file bytes, and have no particular line or record structure.   @subsection<UUCP Lock Files>  E UNIX has no built-in way of obtaining exclusive access to an externaleO communication line.  When you issue the 'set line' command to UNIX Kermit, UNIX@I would normally grant you access to the line even if some other process isaI making use of it.  The method adopted by most UNIX systems to handle thisnL situation is the "UUCP lock file".  UUCP, the UNIX-@|to-@|UNIX Copy program,G creates a file in its directory (usually @q(/usr/spool/uucp), but oftenhD elsewhere) with a name like @q(LCK..)@i(name), where @i(name) is the) device name, for instance @q(LCK..tty07).   G UNIX Kermit uses UUCP lock files in order to avoid conflicts with UUCP,fI tip, or other programs that follow this convention, including other userst, running Kermit itself.  Whenever you attemptJ to access an external line using the 'set line' command or `@q(-l)' on the command line, Kermit looksH in the UUCP directory for a lock file corresponding to that device.  ForE instance, if you 'set line /dev/ttyi6' then Kermit looks for the fileq$ @example(/usr/spool/uucp/LCK..ttyi6)D If it finds this file, it gives you an error message and a directory= listing of the file so that you can see who is using it, e.g.n @begin(example)1> -r--r--r--  1 fdc    8 Feb  7 13:02 /usr/spool/uucp/LCK..ttyi6
 @end(example)lF In this case, you would look up user fdc to find out how soon the line will become free.i  E This convention requires that the uucp directory be publicly readablesJ and writable.  If it is not, the program will issue an appropriate warning message.  N If no lock file is found, UNIX Kermit will attempt create one, thus preventingF anyone who subsequently tries to run Kermit, UUCP, cu, tip, or similarM programs on the same line from gaining access until you release the line.  IfiN Kermit could not create the lock file (for instance because the uucp directory> is write-@|protected), then you will receive an error message.  L Even when the lock directory is writable and readable, the locking mechanismL depends upon all users using the same name for the same device.  If a deviceM has more than one path associated with it, then a lock can be circumvented byt using an alias.r  N When a lock-@|creating program abruptly terminates, e.g. because it crashes orI is killed via shell command, the lock file remains in the uucp directory,nL spuriously indicating that the line is in use.  If the lock file is owned byL yourself, you may remove it.  Otherwise, you'll have to get the owner or theJ system manager to remove it, or else wait for a system task to do so; uucpM supports a function (uuclean) which removes these files after a predeterminedoE age -- uucp sites tend to run this function periodically via crontab.b  G Locking is not needed, or used, if communications occur over the user's , login terminal line (normally @q[/dev/tty]).  9 @subsection(C-Kermit under Berkeley or System III/V UNIX)e  N C-Kermit may be interrupted at command level or during file transfer by typingL Control-C.  The program will perform its normal exit function, restoring theO terminal and releasing any lock.  If a protocol transaction was in progress, aneI error packet will be sent to the opposite Kermit so that it can terminate  cleanly.  K C-Kermit may be invoked in the background ("@q(&)" on shell commmand line).)C If a background process is "killed", the user will have to manuallylI remove any lock file and may need to restore the modem.  This is because  @ the kill signal (@q<kill(@i[x],9)>) cannot be trapped by Kermit.  N During execution of a system command ('directory', 'cd', or `@q(!)'), C-KermitK can often be returned to command level by typing a single Control-C.  (WithoM System III/V, the usual interrupt function (often the DEL key) is replaced by  Control-C.)   O Under Berkeley UNIX only: C-Kermit may also be interrupted by @q(^Z) to put thed process in the background.  J Control-C, Control-Z, and Control-@q(\) lose their normal functions duringJ terminal connection and also during file transfer when the controlling tty" line is being used for packet i/o.  C If you are running C-Kermit in "quiet mode" in the foreground, thensI interrupting the program with a console interrupt like Control-C will notoI restore the terminal to normal conversational operation.  This is becausepK the system call to enable console interrupt traps will cause the program to I block if it's running in the background, and the primary reason for quiet J mode is to allow the program to run in the background without blocking, so- that you can do other work in the foreground.t  G If C-Kermit is run in the background ("&" on shell commmand line), theneC the interrupt signal (Control-C) (and System III/V quit signal) areCE ignored.  This prevents an interrupt signal intended for a foregroundnJ job (say a compilation) from being trapped by a background Kermit session.  ) @subsection(C-Kermit on the AT&T UNIX PC)T   @index<UNIX PC> J For UNIX PC owners here are a couple of hints.  The name of the phone lineC devices are @q</dev/ph0> and @q</dev/ph1>. The RS232 serial port iss @q</dev/tty000>.  $ Dialing out with the internal modem: @begin(example)o C-Kermit>@ux<set line /dev/ph0>i C-Kermit>@ux<set speed 1200> C-Kermit>@ux<set modem att7300>w! C-Kermit>@ux<dial (123) 555-1212>X
 @end(example)pK Or use @q</dev/ph1> for the second phone line.	Control-C will terminate thenK dialer.  The telephone line must be in the DATA state; C-Kermit will remindc1 you of this if it finds the line in VOICE state. f  & Connecting via the RS232C serial port: @begin(example) 
 $ @ux<kermit>r" C-Kermit>@ux<set line /dev/tty000> C-Kermit>@ux<set speed 9600>     @i[(start doing work...)]p.     @i[(after exiting C-Kermit you may type:)]
 @end<example> I C-Kermit automatically handles disabling and enabling logins on the phonep lines and RS-232 port.   @section(X.25 Support)   @index<X.25>M This section applies only to UNIX C-Kermit on SUN computers that are attachedd. to X.25 networks via the SunLink X.25 product.   To use an X.25 connection: @begin<example>  C-Kermit>@ux[set network x.25] C-Kermit>@ux[set host aaaaaaa] C-Kermit>@ux[connect]t
 @end<example> J where aaaaaaa is the X.121 address of the host you wish to connect to.  AnG X.121 address is a many-digit number consisting of a 4-digit DNIC (Data L Network Identification Code) followed by an NTN (Network Terminal Number) upH to 10 digits in length, or a 3-digit DCC (Data Country Code) followed byC a country-dependent NN (National Number) up to 11 digits in length.t  F The following connect-mode escapes apply to X.25 terminal connections:  
 @begin<d4>4 Ctrl-\H@\Hangup - Close the X.25 network connection.  3 Ctrl-\I@\Interrupt - Send an X.25 interrupt packet.a  ( Ctrl-\R@\Reset the X.25 virtual circuit. @end<d4>  K The following special commands can be used to control your X.25 connection:v
 @begin(d4)* HANGUP@\Close the X.25 network connection.  * PAD CLEAR@\Clear the X.25 virtual circuit.  - PAD INTERRUPT@\Send an X.25 Interrupt packet.u  * PAD RESET@\Reset the X.25 virtual circuit.    PAD STATUS@\X.25 status request.  F SET PAD BREAK-ACTION @i<n>@\X.3 Parameter 7.  What PAD should do if itL receives a BREAK signal.  0 = nothing, 1 = send Interrupt packet, 2 = reset,I 4 = send Indication Of Break PAD message, 8 = escape to PAD, 16 = discardi% output.  Default = 21 (= 16 + 4 + 1).   ) SET PAD BREAK-CHARACTER @i<n>@\Default 0.n  N SET PAD LINE-DELETE @i<n>@\X.3 Parameter 17.  0-127 = ASCII value of character6 to be used for erasing a line.  Default = 21 (Ctrl-U).  I SET PAD CHARACTER-DELETE @i<n>@\X.3 Parameter 16.  0-127 = ASCII value oftD character to be used for erasing a character.  Default = 8 (Ctrl-H = Backspace).i  N SET PAD CR-PADDING @i<n>@\X.3 Parameter 9, Padding After Carriage Return (CR).K 0-255.  Number of padding characters PAD should send to DTE after sending ao CR.  Default = 0.u  L SET PAD DISCARD-OUTPUT { 0, 1 }@\X.3 Parameter 8.  0 = normal data delivery,! 1 = discard output.  Default = 0.w  E SET PAD LINE-DISPLAY @i<n>@\X.3 Parameter 18.  0-127 = ASCII value of > character to redisplay an edited line.  Default = 18 (Ctrl-R).  L SET PAD ECHO { 0, 1 }@\X.3 Parameter 2.  0 = PAD will not echo, 1 = PAD will echo.  Default = 1.   H SET PAD EDITING { 0, 1 }@\X.3 Parameter 15.  0 = No editing, 1 = editing allowed.  Default = 1.  J SET PAD ESCAPE { 0, 1 }@\X.3 Parameter 1.  0 = Escape to PAD not possible, 1 = Ctrl-P escapes to PAD.  N SET PAD FORWARD @i<n>@\X.3 Parameter 3, Data Forwarding Characters.  0 = none,= 1 = any alphanumeric, 2 = carriage return, etc.  Default = 2.n  J SET PAD LF-PADDING @i<n>@\X.3 Parameter 14. 0-255 padding characters to be) sent by PAD after linefeed.  Default = 0.e  H SET PAD LF-INSERT @i<n>@\X.3 Parameter 13, Linefeed (LF) insertion afterL carriage return (CR).  0 = no LF insertion, 1 = PAD inserts LF after each CRH sent to DTE, 2 = PAD inserts LF after each CR received from DTE, 4 = PAD  echoes LF as CRLF.  Default = 0.  K SET PAD LINE-FOLD @i<n>@\X.3 Parameter 10, Line Folding.  0 = none, 1-255 =nO number of graphic characters per line after which to insert folding characters.d Default = 0.  K SET PAD PAD-FLOW-CONTROL { 0, 1 }@\X.3 Parameter 5.  0 = No flow control by,B PAD, 1 = PAD may send Xon/Xoff flow control to user.  Default = 0.  J SET PAD SERVICE-SIGNALS { 0, 1 }@\X.3 parameter 6, PAD Service and CommandN Signals.  0 = PAD service signals are not sent to DTE, 1 = PAD service signals sent.  Default = 1.y  F SET PAD TIMEOUT @i<n>@\X.3 Parameter 4, Data forwarding timeout, 0-255G (twentieths of a second).  Default = 0 (no data forwarding on timeout).e   @begin(comment) L SET PAD TRANSMISSION-RATE @i<n>@\X.3 Parameter 11 (read-only).  0 = 110 bps,O 2 = 300 bps, 3 = 1200 bps, 11 = 75/1200 bps, 12 = 2400 bps, 14 = 9600 bps, etc.i! This command doesn't do anything.u
 @end(comment)   M SET PAD USER-FLOW-CONTROL { 0, 1 }@\X.3 Parameter 12.  0 = no flow control by J user, 1 = user device may send Xon/Xoff flow control to PAD.  Default = 0.  F SET X.25 CALL-USER-DATA { ON [ text ], OFF }@\OFF = no call user data,3 ON @i<text> sends the given text during call setup.v  I SET X.25 CLOSED-USER-GROUP { OFF, ON @i<n> }@\OFF = no closed user group,gC ON @i<n> specifies the user group number, 0 to 99.  OFF by default.i  I SET X.25 REVERSE-CHARGE { OFF, ON }@\OFF = caller pays, ON = callee pays.l Default is OFF.0 @end(d4)    @section(C-Kermit under VAX/VMS)   This section contributed byy9 Terry Kennedy, St. Peter's College, Jersey City, NJ, USA.i  i! @subsection<File Transfer Issues>a  bE VMS provides a plethora of file formats, most of which have no directaM equivalent on other operating systems (especially the other operating systemsoJ that C-Kermit runs under).  Thus, the user is faced with the issue of fileN format conversion.  VMS C-Kermit attempts to make this as painless as possibleM by mapping the various file formats to canonical form on transmission, and bydF creating the simplest file structure upon reception.  Various C-KermitJ commands may be used to give C-Kermit "hints" about what the user desires.M Some of these work only when sending files, others only when receiving files.c  First, let's discuss some terms:  s/ @b<BINARY TRANSFER MODE (SET FILE TYPE BINARY)>p  rJ When sending a file, C-Kermit/VMS reads bytes from the file and sends themE without any kind of interpretation, translation, or reformatting.  Ino< particular, no characters are inserted at record boundaries.   L When receiving files, C-Kermit/VMS collects bytes and writes them to disk atM intervals.  The file is created as "Fixed" organization, with the record size9M specifed by the user with SET FILE RECORD-LENGTH, or the default value of 512dL if the user does not override it.  For both send and receive operations, theK RMS attribute "First free byte" is used.  Thus, VMS C-Kermit can operate onaI files where the file size (in bytes) is not an exact multiple of the file  record size.  r+ @b<TEXT TRANSFER MODE (SET FILE TYPE TEXT)>k  iM When sending files, C-Kermit/VMS attempts to convert the file to a form whicheN has the proper delimiters for "canonical Kermit protocol" form.  Specifically,L CR and LF characters are inserted as needed at the end of each record.  ThisL is normally an easy task, but is complicated by some VMS file types (such asI the "Fortran carriage control" type).  On reception, files are created as|L "Sequential variable, carriage return carriage control".  C-Kermit uses a CRJ followed immediately by a LF as a record delimiter.  Lone CR's or LF's are0 written as part of a record if they are present.  1 @b<LABELED TRANSFER MODE (SET FILE TYPE LABELED)>/  G When in this mode, C-Kermit/VMS gathers information about the file fromnN various sources, such as the file's directory entry, ACL's, etc. and transmitsN it as part of the file data. This is called a LABELED FILE. Such files are notF usable on non-VMS systems, but may be stored on such systems and laterG restored to another (or the same) VAX. An external utility named CKVCVTa7 reconstitutes the file as it was, with various options.e  H Other systems should treat labeled files as simple files of TYPE BINARY.  7 Now, let's discuss the actions of sending or receiving:t   L @paragraph<Sending Files from VMS C-Kermit> The requested file is opened andJ the VMS file characteristics are examined.  Files of format "Undefined" orG "Fixed" are sent as binary files, other formats are sent as text files.)  H @b<SET FILE TYPE IMAGE>.  This forces the file to be sent as a stream ofN bytes, regardless of file characteristics, with a file type of binary declaredK in the attribute packet.  This is useful for cases where other applications L generate file contents with inappropriate file characteristics (for example,M a stream-LF file which is actually binary data).  This should only be used astF a last resort, as [normally] RMS inserts bytes in the file for controlO purposes, and these bytes are transmitted (and misinterpreted by the receiving   system).  G @b<SET FILE TYPE LABELED> forces the file to be sent in labeled format,dI with C-Kermit reading the file from the disk as in IMAGE mode, and with aC5 file type of binary declared in the attribute packet.   + @paragraph<Receiving Files to VMS C-Kermit>l  ? The characteristics supplied in the file's attribute packet areeM used to determine the desired file type.  If no attribute packet arrives, theiL current SET FILE TYPE setting, TEXT or BINARY, is used.  If the current fileK type is IMAGE, BINARY is used.  SET FILE TYPE UNDEFINED forces the received I file to be written with RMS RECORD FORMAT UNDEFINED for compatbility withqM some software that uses non-RMS routines for manipulating files.  This optioncM should normally not be used, as you will generate files VMS can't do anything  with.   1 If the current FILE TYPE is LABELED, the incomingtM file is handled in LABELED mode if (a) its attribute packet declares its typeeK to be binary, OR (b) there is no attribute packet.  If the attribute packetcK says the file type is text, C-Kermit rejects the file. At the present time,]K C-Kermit does not understand received labeled files, and you should use thel( external CKVCVT utility to convert them.   # @subsection<PRACTICAL APPLICATIONS>   l7 @paragraph<Between a VMS System and a Different System>o  wI The defaults should function properly, provided that the receiving systemsJ uses the "stream-of-bytes" philosophy of UNIX.  Extensive testing has beenM done between VMS C-Kermit and UNIX C-Kermit, as well as MS-DOS Kermit.  OthereK systems may require a re-thinking of the transfer strategy, but this author  [tmk] considers it unlikely.  r @paragraph<Between VMS Systems>n  eG The goal of the defaults is to produce useful output in the majority ofnH cases.  If you need to transfer binary files where record boundaries areK important and don't occur at fixed intervals (such as .OBJ files), or where.H the file semantics are extensive and not propagated by C-Kermit (such asH DDIF files, indexed files, or files with extended semantics stored in an? ACE, such as PCSA file service contents), you have two options.   . @begin<enumerate>lI SET FILE TYPE LABELED.  Give this command to the sending C-Kermit system,tH receive the file on the target VMS system, and extract the contents with CKVCVT.l  nJ Encapsulate these files using VMS BACKUP, transfer the BACKUP saveset, andJ then restore it on the target system.  BACKUP produces output files with aL simple fixed length record structure.  You should specify an explicit record( size on the BACKUP command line such as:3 @example<BACKUP *.* FILES.BCK/SAVE_SET/RECORD=8192>PJ and give the record size to the receiving Kermit with the command SET FILE* RECORD-LENGTH before sending your saveset. @end<enumerate>k  q/ @subsection<Compatibility with Bliss-32 Kermit>m  fJ Testing has shown that the two Kermits make similar assumptions about fileJ characteristics.  A variety of files were uploaded from MS-DOS to VMS withH Bliss-32 Kermit, using a variety of transfer modes, and then returned toG MS-DOS with C-Kermit and a byte-for-byte comparison was performed.  ThetJ reverse operation was then tried and tested.  No discrepancies were found.F Although this does not guarantee 100% compatibility, it is very close.
 Equivalences:f% @begin<example,leftmargin 0,size -1> L- C-Kermit/VMS                  Bliss Kermit-32   e1 SET FILE TYPE TEXT            SET FILE TYPE ASCIIoG SET FILE TYPE BINARY [FIXED]  SET FILE TYPE BINARY, SET FILE TYPE FIXED $ SET FILE TYPE BIN UNDEF       (none)1 SET FILE TYPE IMAGE           SET FILE TYPE BLOCK $ SET FILE TYPE LABELED         (none)
 @end<example>b  mG Note: There is no distinction between SET FILE TYPE BINARY and FIXED inrH C-Kermit/VMS, and none is needed.  C-Kermit determines the file type andK length automatically when sending, and when receiving binary files, createseF a fixed-format file and marks the true end using the "first free byte"L mechanism of RMS.  EXCEPT if you have given the command SET FILE TYPE BINARYI UNDEFINED, in which case the file is stored with the RMS record format ofaE UNDEFINED rather than fixed (but in the same format as a fixed file).c  e% @subsection<Date and Time Attributes>k  rN The VMS C-Kermit server sends the file's creation date in the attribute packetH when a file is sent.  When receiving files, if there was valid date/timeN information in the attribute packet, C-Kermit will set the new file's creationJ date/time to the value provided.  The file will be marked as being revisedH once (initial creation), on the current date/time.  This is necessary toN ensure that the file will be detected as "new" by VMS BACKUP.  You should alsoL note that if a file with a creation date in the future (as perceived by VMS)K is received from a remote Kermit, the system will report "File has creationpJ date in the future" to your system management if they use the ANALYZE/DISK4 command before the file's creation date has occured.  cL VMS C-Kermit has the command SET FILE COLLISION UPDATE, which can be used toK reject files when there is a newer file than the incoming one with the same(N name.  If you use this option, be aware that due to system clock skew, you mayH be able to send the file several times in succession before VMS C-kermit8 rejects it as [now] being older than the one on the VAX.  l! @subsection<File Size Attributes>o  J When sending files, VMS C-Kermit fills in the file size information in theI attribute packet. Note that the reported sizes may differ from the actualt: size due to insertion of CR/LF characters on transmission.  M For received files, VMS C-Kermit checks checks for sufficient free disk spaceaJ if the remote Kermit supplies file size information. If there isn't enoughK space on the disk, VMS C-Kermit will reject the file. Please note that usermJ quotas are not checked. The logic to do so is quite complicated, and wouldK lead to VMS C-Kermit rejecting files that could be received. As an example,eI consider a user with EXQUOTA privilege. In general, a file size rejectioneM by VMS C-Kermit means the file will not fit; the lack of a rejection does notsK guarantee that the file will fit. Consider a small file being received ontorI an RX50 floppy. If debugging is turned on, the debug output will fill then. floppy before the file is completely received.  J If the device for the received file is not a disk (for example, the system/ lineprinter) the file is assumed to always fit.r  " @subsection<SET FILE TYPE LABELED>  I Labeled files contain various pieces of information needed to reconstructmH the file. At the moment, this is handled by an external utility known asH CKVCVT. Some items are always restored and other are not restored unlessL the user explicitly asks for them. File characteristics are always restored.I The file name is restored (de-truncated). However, the complete directoryrK specification is not used to recreate the file unless explicitly requested.nI This means that converted files will normally be restored to your currentaJ directory. Similarly, file ownership is assigned to you unless you specifyL that the original owner be retained. Note that the two previous options willM require privileges. The file backup date is normally cleared so that the fileh1 will be backed up. This action may be overridden.p  J File ACE's are normally not restored. This is an all-or-nothing operation,K as there are many types of ACE's under VMS. The most common usage of an ACEsH is to grant/deny file access to other users. However, various other usesN exist. Some examples are: RMS Journaling, RMS Statistics, DDIF, and Pathworks.K Note that ACE's are transported in binary mode, which means that protectiontG ACE's may wind up applying to incorrect users if you move files between.O different VMS systems with ACE's enabled. Also, note that you can create ACE's -F which you cannot see with DIR/FULL unless you have SECURITY privilege.N However, you should be able to view (but not modify) them with EDIT/ACL. This K also means that you will not be able to delete these ACE's without deletinghA the file, which is another reason they are normally not restored.2  K RMS Journaling files are a special case. Journaling will not be enabled foreK a received labeled file. A DIR/FULL will show the journaling ACE, which youoL can use to determine the correct journaling paramters if you wish to journalK the new file. Note that if you restore the file to another disk (even if itdK is on the same system) the journaling information will display incorrectly.u2 This is a limit of the DEC RMS Journaling product.   @subsection<Reporting Problems>T  NG If you have a file that does not transfer correctly, or that exhibits aaK problem when moved one way with Bliss-32 Kermit and the back with C-Kermit, J we would be interested in seeing it (especially if it's small 8-).  PleaseH make a BACKUP saveset of it under VMS, and send the saveset along to theJ BUGS address (use the command BUG in C-Kermit for up-to-date information).H Please include any specific information you think would be useful.  As aL bare minimum, please give the Kermit version number(s), the VMS version, and1 the compiler version (if you re-compiled Kermit).e  2+ @subsection<Sections that need to be added>X   G Hints for users and system managers on configuring their VMS system andTG terminal devices for best use with Kermit -- BYTLM quotas, Alt-typahead.J buffers, etc etc.  What are the sysgen options, what SET TERMINAL commands7 (if any) should be used before running C-Kermit, etc...k   @section(C-Kermit under OS/2)1  F This section describes special considerations for using C-Kermit under OS/2.i  J C-Kermit 4E(72) was adapted to OS/2 by Chris Adie of Edinburgh University,N Scotland, UK.  The OS/2-specific code was adapted to version 5A(179) and partsM of it were rewritten by Kai Uwe Rommel of the Technical University of Munich,r Germany.  A C-Kermit is a protected-mode program.  It will not run in the DOS D compatability environment.  This means that it will continue runningC (eg transferring files) even when it is not the foreground session.T  < The OS/2 C-Kermit initialization file is called CKERMIT.INI.  E @i(All numbers in the C-Kermit documentation are decimal unless notedt otherwise.)0   @subsection(Requirements)<  H C-Kermit will run on a computer with an 80286 or 80386 processor runningJ OS/2 version 1.0 or higher.  It runs in character mode - in other words itE is not a Presentation Manager application.  However, it will run in a J Presentation Manager window as a character application.  Normally, though,= you would run it from the command processor (CMD.EXE) prompt.E   @subsection(The Serial Port)  B Naturally, a serial port (COM1 through COM4) is required. The OS/2A serial port device driver must be loaded using a line like one ofa% the following in the CONFIG.SYS file:A   @begin(example)\ @tabset(2 inches)- @\DEVICE=COM01.SYS @i(or)@\DEVICE=COM02.SYS @i(or)@\DEVICE=COM.SYS
 @end(example)F  F COM01.SYS is used for PC/AT - type machines, while for PS/2s COM02.SYSE must be used. C-Kermit @i'will not work' if this device driver is nottE loaded. (It provides the Category 1 IOCTLs which are used extensivelycH within the program.) COM01.SYS and COM02.SYS are used for version 1.x ofF OS/2 only. For the version 2.0 of OS/2 (soon to be released), only one1 driver COM.SYS exists for both types of machines.a  G The connecting cable and the modem (or other computer, PAD etc to whichwA your computer is connected) must satisfy the requirements of your E computer's RS232 interface.  In particular, the computer will provideSG two output control signals (RTS and DTR), and may expect to see signals,H on four input lines (DCD, DSR, CTS, RI).  The precise behaviour of these> lines is software configurable (for instance by using the OS/2> '@q(MODE)' command), and C-Kermit makes no attempt to impose a  particular method of using them.  H By default, the DTR and RTS line will both go ON when C-Kermit opens the3 comms port, and they will go OFF when it is closed.p  H The default behaviour for the input lines is that DSR and CTS must be ONG to enable the port to work.  If the modem you are connected to does not E provide these signals, you can 'loop back' the RTS output signal from M the computer to DSR and CTS, using a suitably modified cable.  An alternativeeJ is to use the MODE command to disable the DSR and CTS inputs.  To do this,? type a command similar to the following at the OS/2 CMD prompt:s @begin(example)u/ MODE COM1:9600,N,8,1,OCTS=OFF,ODSR=OFF,IDSR=OFFR
 @end(example), You can check the effect using:l @begin(example)l	 MODE COM1 
 @end(example)cH which reports the current settings of COM1.  Note that on some machines,G C-Kermit may appear to work even although DSR and CTS are not connectedsH to anything, nor disabled using '@q(MODE)'.  This is because unconnectedH input lines tend to 'float high'.  Although this situation may not causeE any problems, it is not good practice - you should explicitly disablee the inputs as above.  G The '@q(MODE)' utility also allows you to change the baud rate, parity,o? number of data bits and number of stop bits.  C-Kermit providestG facilities for changing the baud rate and parity too (see later in this.D manual), but when it starts up, it resets the parity to none and theC number of data bits to 8.  Any changes to baud rate and parity will + remain in effect after C-Kermit terminates.t  J If you change the parity within C-Kermit, it will ajust the number of dataI bits to cope.  There is no way of changing the number of stop bits withinh$ C-Kermit: use '@q(MODE)' to do this.  F There is also no way to change the hardware flow control settings fromB within C-Kermit. There are too many possible settings for the OS/2D serial driver to duplicate all '@q(MODE)' options into C-Kermit. YouG can use '@q(MODE)' to adjust the hardware flow control and the settingstG are used by C-Kermit without modification. You can, however, change then+ software flow control from within C-Kermit.e   @subsection(Emergency Exit)r  ) @i(EMERGENCY EXIT:)@index<Emergency Exit>nJ The Control-C and Control-Break keys cannot be used to terminate C-Kermit.I To terminate C-Kermit unconditionally, you can select it in the task listkE and choose 'Terminate' (OS/2 1.x) or select it in the window list anda3 choose the 'Close' option from the menu (OS/2 2.0).l  E C-Kermit returns an exit status of zero, except when a fatal error is M encountered, when the exit status is set to one.  This can be used in a batchmL file, to take some action depending on whether the operation was successful.C For instance, suppose the file @q(SEND.CMD) contains the following:e @begin(example)c echo Sending %1 out port %2  kermit -ql COM%2 -b 9600 -s %1 if ERRORLEVEL 1 goto badends echo Transferred succcessfully!a goto end :badend  echo Transfer problems!A :end
 @end(example)T+ To send a file @q(FOO.BAS), you could type:/ @exx(send foo.bas 2)G to send it to another computer running Kermit, connected to port COM2. rG If the transfer completed OK, you would get the message '@q(Transferred  successfully!)'.  ! @subsection(The OS/2 File System)y  M The features of the OS/2 file system of greatest interest to Kermit users areaM the form of the file specifications, and the formats of the files themselves.iG Note that the following discussion refers to the MS-DOS compatible fileeG system supported by initial versions of OS/2.  Installable file systemscJ are not covered here - they are significantly different, and the extent toG which C-Kermit will work under such file systems is unknown (because noaB installable file system has been released at the time of writing).   @paragraph(File Specifications)L  ( OS/2 file specifications are of the form  0 @exx(@c[DEVICE@q(:\)PATHNAME@q(\)NAME@q(.)TYPE])  R where @c{DEVICE} stands for a single character identifier (for instance, @q(A) forK the first floppy disk, @q(C) for the first fixed disk, @q(D) for a RAM diskiL emulator) followed by a colon ('@q(:)'), @c[PATHNAME] is up to 63 charactersD of identifier(s) (up to 8 characters each) surrounded by backslashesN ('@q(\)'), @c[NAME] is an identifier of up to 8 characters, and @c[TYPE] is anG identifier of up to 3 characters in length.  Device and pathname may beEC omitted.  The first backslash in the pathname may be omitted if theiH specified path is relative to the current directory.  In the path field,I '@q(.)' means the current directory, '@q(..)' means the parent directory.t  B Note that the name, type and path length restrictions apply to theE original FAT file system of OS/2. The HPFS file system added in latertF revisions does not have such hard restrictions. However, C-Kermit willB not take much advantage of the long HPFS file names except that it- recognizes them when sending/receiving files.   F The device and directory specification is normally omitted, but can beI specified in all C-Kermit commands.  Device and directory pathnames, whenhK omitted, default to either the user's current disk and directory, or to the L current directory search path as specified in the PATH environment variable,8 depending on the context in which the file name appears.  F The C-Kermit command line parser treats backslash characters speciallyE and thus requires you either to enter two backslashs when you want to F enter one in a file specification or to enter a forward slash instead.* The following two commands are equivalent. @begin(example).# C-Kermit>@ux[send c:\\autoexec.bat]O" C-Kermit>@ux[send c:/autoexec.bat]
 @end(example)f  E @i[NAME.TYPE] is sufficient to specify a file on the current disk andtF directory, and only this information is sent along by C-Kermit with an outgoing file (by default).e  F The device, path, name, and type fields may contain uppercase letters,H digits, and the special characters '@q[-]' (dash), '@q[_]' (underscore),B '@q[$]' (dollar sign), '@q[&]' (ampersand), '@q[#]' (number sign),G '@q[@@]' (at sign), '@q[!]' (exclamation mark), '@q[']' (single quote),oB '@q[()]' (parentheses), '@q[{}]' (curly braces), '@q[^]' (caret orH circumflex), '@q[~]' (tilde), and '@q[`]' (accent grave).  Normally, you? should confine your filenames to letters and digits for maximuma? transportability to non-OS/2 systems (by default, C-Kermit williH translate filenames being sent by converting non-alphanumeric charactersD to '@q(X)').  When you type lowercase letters in filenames, they areH converted automatically to uppercase.  There are no imbedded or trailingH spaces.  Other characters may not be included; there is no mechanism forG "quoting" otherwise illegal characters in filenames.  The fields of the B file specification are set off from one another by the punctuation. indicated above (ie colon, backslash and dot).  F The name field is the primary identifier for the file.  The type, alsoE called the extension or suffix, is an indicator which, by convention,eK tells what kind of file we have.  For instance @q[FOO.BAS] is the source of F a BASIC program named FOO; @q[FOO.OBJ] might be the relocatable objectL module produced by compiling @q[FOO.BAS]; @q[FOO.EXE] could be an executableC program produced by loading @q[FOO.OBJ], and so forth.  @q[.EXE] isw* the normal suffix for executable programs.  = OS/2 allows a group of files to be specified in a single fileoI specification by including the special "wildcard" characters, '@q[*]' and N '@q[?]'.  A '@q[*]' matches any string of characters from the current positionJ to the end of the field, including no characters at all; a '@q[?]' matches. any single character.  Here are some examples: @begin(description)  @tabclear()@tabset(1.5 inches)O @q[*.BAS]@\All files of type BAS (BASIC source files) in the current directory.E  , @q[FOO.*]@\Files of all types with name FOO.  - @q[F*.*]@\All files whose names start with F.G  Q @q[*.?]@\All files with types exactly one character long, or with no type at all.b @end(description)sO Wildcard  notation  is used on many computer systems in similar ways, and it iseM the mechanism most commonly used to instruct Kermit to send a group of files.e  G You should bear in mind that other (non-OS/2) systems may use differentaL wildcard characters.  For instance VMS and the DEC-20 use '@q[%]' instead ofJ '@q[?]' as the single character wildcard; when using C-Kermit to request aE wildcard file group from a Kermit-20 server, the OS/2 '@q[?]' must bee replaced by the DEC-20 '@q[%]'.x   @paragraph(File Formats)  F OS/2 systems store files as streams of 8-bit bytes, with no particularC distinction among text, program code, and binary files.  ASCII textiF files consist of lines separated by carriage-return-linefeed sequencesD (CRLFs), and this conforms exactly to the way Kermit represents text files during transmission.  H OS/2 (unlike CP/M) knows the exact end of a file because it keeps a byteF count in the directory, so one would expect no particular confusion inF this regard. However, certain MS-DOS and OS/2 programs continue to use? the CP/M convention of terminating a text file with a Control-Z ? character. This may cause problems when the file is transferreduG elsewhere, since other systems may object to the Control-Z. By default,oF therefore, C-Kermit treats the first Control-Z it finds in the file asH being equivalent to end-of-file. The Control-Z is not transmitted to theA other system. Of course, this leads to problems when transferringoD non-text files, when we @i(do) want any Control-Zs in the file to beF sent. To achieve this, the C-Kermit '@q(set file type binary)' commandD may be used. The opposite, '@q(set file type text)', is the default.   @subsection(Terminal Emulation)s  K The CONNECT-mode escape character is Ctrl-] (Ctrl-Rightbracket) by default, H but you can change it to any other control character with the SET ESCAPE command.  I In connect mode, C-Kermit emulates a DEC VT102 terminal.  See the sectionc< "Terminal Emulation" for details of how the emulation works.  ; In CONNECT mode, keyboard input is obtained through the KBDc@ subsystem, and screen output is through the VIO subsystem. It is. therefore impossible to redirect terminal I/O.  L When you issue a '@q(connect)' command the first time after starting Kermit,C the screen clears and the cursor is positioned at the top left-handeF corner.  You can log into the remote host computer as normal.  In thisJ mode, the PC emulates a DEC VT102 terminal, so any control codes or escape@ sequences received from the host will be actioned appropriately.  5 The 25th line on the screen is used as a status line,nK giving the name of the communications port, the current transmission speed,e and how to obtain help.f  C Some keys on the VT102 keyboard have no direct equivalent on the PCrF keyboard.  The following table shows the mapping which obtains betweenE VT102 keys and PC keys.  Note that the @q(Alt) @i(n) combinations usetB the number keys along the top row of the keyboard, not the numeric keypad.    @begin(verbatim,need 22) @tabclear @tabset(2 inches)i @ux(VT102)@\@ux(IBMPC)   Delete@\Delc PF1@\F1a PF2@\F2e PF3@\F3i PF4@\F4s Keypad 0@\Alt 0n Keypad 1@\Alt 1t Keypad 2@\Alt 2t Keypad 3@\Alt 3o Keypad 4@\Alt 4r Keypad 5@\Alt 5u Keypad 6@\Alt 6r Keypad 7@\Alt 7m Keypad 8@\Alt 8e Keypad 9@\Alt 9a Keypad minus@\F5 or F6 Keypad comma@\F7 or F8 Keypad dot@\F9 Keypad enter@\F10t No Scroll@\Scroll-Lock @end(verbatim)  G The PC's '@q(Scroll-Lock)' key (equivalent to the VT102 '@q(No Scroll)'vH key) freezes the data on the screen. It is typically used when listing aC long file, to prevent information being scrolled off the top of thelH screen. Note that the Control-S and Control-Q (Xon/Xoff) keys should notH be used for this purpose if '@q(flow)' is set to '@q(xon/xoff)', becauseD they interfere with the correct operation of the comms device driverF flow control. When the '@q(Scroll-Lock)' key is pressed, an '@q(xoff)'H will be sent automatically when the device driver's receive buffer fills9 up, and an '@q(xon)' will be sent as it empties after theiD '@q(Scroll-Lock)' key has been pressed a second time to unfreeze theH screen. All other keys are ignored when the screen is frozen. The status2 line indicates when the emulator is in this state.  H Information which scrolls off the top of the screen is not in fact lost,G but is stored in an "extended display buffer", which can be examined byaF pressing the '@q(PgUp)' key. The extended display buffer can contain aE number of screenfulls of data, and the '@q(PgUp)' and '@q(PgDn)' keyslB can be used to range freely through this data. If any other key isH pressed while the extended display buffer is visible, the current screenC contents are redisplayed and the keystroke is sent to the host. ThefF '@q(PgUp)' and '@q(PgDn)' keys may be used even when the host is stillD sending data. If Xon/Xoff flow control is in effect, no data will be lost.<  1 The following VT102 features are not implemented:s @begin(itemize)r Smooth scrolling   132-column modeh   Alternate character ROM-  	 LED lamps 
 @end(itemize)-  5 The VT102 keyboard autorepeat mode is always enabled.   M When in connect mode, typing the escape character (Control-@q(])) followed byaL a @q<?> for help will display a "pop-up" help window, indicating the optionsO available.  If @q(^]c) is typed to close the connection, the screen is restoreduE to its state when the '@q(connect)' command was issued.  A subsequentM/ '@q(connect)' will re-display the VT102 screen.o  H The control codes and escape sequences recognised by the VT102 emulationI are listed below.  For full details of the effects of these codes, pleasen consult the VT102 manual.h   @begin(example,leftmargin 0)/ @tabclear()@tabset(1.4 inches,2 inches,3inches)t- ENQ@\5@\Send answerback message "OS/2 Kermit"l BEL@\7@\Sound beep BS@\8@\Cursor left TAB@\9@\Cursor to next tab stop2 LF@\10@\Cursor downs
 VT@\11@\As LFc
 FF@\12@\As LFo CR@\13@\Cursor to left margin  SO@\14@\Select G1 character setO SI@\15@\Select G0 character seti CAN@\24@\Cancel escape sequence- SUB@\26@\As CAN  ESC@\26@\See below Others@\@\Ignoredf   ESC 7@\Save cursor positiono ESC 8@\Restore cursor position ESC D@\Index ESC E@\Next line  ESC H@\Set tab at current column ESC M@\Reverse index ESC Z@\Identify terminal ESC c@\Reset$ ESC =@\Enter application keypad mode# ESC >@\Exit application keypad mode 9 ESC # 3@\Double height and width emulation, top half linea< ESC # 4@\Double height and width emulation, bottom half line  ESC # 5@\Single height and width1 ESC # 6@\Single height and double width emulations! ESC # 8@\Screen alignment displaye+ @tabclear()@tabset(2inch,3inch,4inch,5inch)S2 ESC ( @i(g)@\G0 designator - @i(g) = A,B or 0 only2 ESC ) @i(g)@\G1 designator - @i(g) = A,B or 0 only ESC [ @i(Pn) A@\Cursor upi ESC [ @i(Pn) B@\Cursor downn ESC [ @i(Pn) C@\Cursor right ESC [ @i(Pn) D@\Cursor left - ESC [ @i(Pl) ;@i(Pc) H@\Direct cursor addressD- ESC [ @i(Pl) ;@i(Pc) f@\Direct cursor address = ESC [ @i(Pn) c@\Identify report - response is ESC [ ? 6 ; 2 c  ESC [ 3 g@\Clear all tabsi' ESC [ 0 g@\Clear tabs at current columno3 ESC [ ? @i(Pn) h@\Set DEC private mode, shown belowe5 ESC [ ? @i(Pn) l@\Reset DEC private mode, shown below)  K     @ux<mode no.>        @ux<mode>            @ux<set>           @ux<reset>   8         1           Cursor key      Application   Cursor6         2           ANSI/VT52       N/A           VT528         5           Screen          Reverse       Normal:         6           Origin          Relative      Absolute5         7           Wraparound      On            Offe  9 ESC [ @i(Pn) h@\Set mode - modes supported as shown belowC; ESC [ @i(Pn) l@\Reset mode - modes supported as shown belowc  K     @ux<mode no.>        @ux<mode>            @ux<set>           @ux<reset>e  5         2           Keyboard lock   On            OffR9         4           Insert          Insert        Replace 4        20           Newline         CR LF         CR  6 ESC @i(Pn) i@\Printer/screen on/off - 4 to 7 supported ESC [ 5 n@\Status report! ESC [ 6 n@\Cursor position reportr* ESC [ @i(Pn) x@\Request terminal parameter2 ESC [ @i(Pn) ;@i(Pn) r@\Set top and bottom margins! ESC [ 0 J@\Erase to end of screene) ESC [ 1 J@\Erase from beginning of screen  ESC [ 2 J@\Erase all of screen ESC [ 0 K@\Erase to end of lineO' ESC [ 1 K@\Erase from beginning of linea ESC [ 2 K@\Erase all of line" ESC [ @i(Pn) L@\Insert blank lines ESC [ @i(Pn) M@\Delete lines( ESC [ @i(Pn) @@@\Insert blank characters! ESC [ @i(Pn) P@\Delete characters'A ESC [ @i(Ps) ;@i(Ps) ; ..;@i(Ps) m@ @ @ @ Character attributes orsI ESC [ @i(Ps) ;@i(Ps) ; ..;@i(Ps) }@ @ @ @ Character attributes, as below:a 0       Default settings 1       High intensity 4       Underlineh
 5       Blinkt 7       Reverset 8       Invisibleu- 30-37   sets foreground colour to be as shownF         30      black          31      redu         32      greenl         33      yellow         34      blue         35      magenta1         36      cyan         37      whitea- 40-47   sets background colour to be as shown          40      black,         41      red@         42      greenu         43      yellow         44      blue         45      magentai         46      cyan         47      whited
 @end(example) L Note that the default character set for both G0 and G1 is '@q(A)', ie the UK character set.  K The following escape sequences are recognised when the emulator is put into-4 VT52 mode by receiving the sequence @q(ESC [ ? 2 l).   @begin(example,leftmargin 0)/ @tabclear()@tabset(1.4 inches,2 inches,3inches)h ESC A@\Cursor up ESC B@\Cursor down ESC C@\Cursor righta ESC D@\Cursor leftup ESC F@\Enter graphics mode ESC G@\Exit graphics modes ESC H@\Cursor to home  ESC I@\Reverse line feed ESC J@\Erase to end of screen  ESC K@\Erase to end of liney$ ESC Y @i(l c)@\Direct cursor address ESC Z@\Identify $ ESC =@\Enter application keypad mode# ESC >@\Exit application keypad model ESC <@\Enter ANSI mode
 @end(example)i4 The escape sequences below are accepted but ignored. @begin(example)d/ @tabclear()@tabset(1.4 inches,2 inches,3inches)u) ESC O @i(x)@\where @i(x) is any character ) ESC ? @i(x)@\where @i(x) is any character  ESC [ @i(Pn) q@\Load LEDso
 @end(example)e   @subsection(Keyboard mapping)o  F The OS/2 version of C-Kermit provides the same keyboard mapping as theG UNIX version. A particular key can be mapped to itself (default for allnI keys), to another key (single key stroke) or to a sequence of key strokesy9 (a macro text). Use the SET KEY command for this purpose.(  F An extension was made to the standard SET KEY command to allow mappingE of the additional PC keyboard keys. Unlike the UNIX version, the OS/2eG version knows of 768 rather than only 256 keys. The keys 0..255 are the G usual ASCII and extended ASCII (8-bit PC-specific) characters while allnH extended keys (such as cursor and function keys) in various combinationsF with SHIFT, CONTROL and ALT are known as 256..767 to C-Kermit. To findH out what the number of some key is, enter the SHOW KEY command and pressF that key. The SHOW KEY command will then report the key number and the current assignment.a  B Note that a few extended keys have a special meaning to the VT-102G emulator in CONNECT mode. The cursor keys, for example, send the VT-102MC cursor key escape sequences while Page-Up and Page-Down are used ton) control the emulator's scrollback buffer.h  D That means, the CONNECT mode knows a few key numbers and treats themD specially. If you map another key to the code of one of this specialD known keys, that other key will also function like this special key.  6 @subsection(OS/2 C-Kermit Restrictions and Known Bugs)   @begin(enumerate, spread 1)2 @ux(Server breakout):tH There is no way of stopping server operation from the keyboard, short of
 Control-C.   @ux(Debugging log):dH There is very little debugging information logged from the OS/2-specific7 parts of the program (it was developed using Codeview).    @ux(Terminal emulation):> If the host sends the escape sequence to put the terminal intoF 132-column mode, and subsequently sends data which would appear in theG rightmost 52 columns, this may mess up the existing data on the screen.f= Really the emulator should ignore any data for these columns.    @ux(File type):[. The way Control-Z is handled could be better. # We need a '@q(set ctrlz {on, off})'e like MS-DOS Kermit.q  5 A better display of progress of a transfer is needed.n @end(enumerate)   8 @subsection(Invoking OS/2 C-Kermit from Another Program)  N If you are writing a communications program and wish to incorporate the KermitN protocol within it, one way is to use the OS/2 function call @q(DosExecPgm) toE call up C-Kermit.  You would supply the instructions for Kermit using N command-line options, and Kermit would do the transfer, returning back to your program when it had finished.S  L The only problem with this scenario is that you might already have opened upM the COM port within your program, so that when Kermit tries to do the same ittI gets an error code back from @q(DosOpen).  The @q(-u) command line optiondL gets round this problem.  It uses the fact that a child process inherits theM open file handles of its parent.  @q(-u) takes one numeric parameter which isrO the handle of the COM port in question, and it must occur in front of any other G command-line parameter which accesses the COM port.  The following is aiM complete C program written using the Microsoft C compiler version 5.1 and thelM Microsoft OS/2 Software Development Toolkit, which illustrates how to use thewI @q(-u) command-line option (NOTE: the UNIX version uses @q(-l) for this).l   @begin(verbatim) #define	INCL_BASEs #include <os2.h> /*9  *	Example of how to use the C-Kermit -u option to invoket*  *	Kermit from another program under OS/2.  */N main(int argc, char *argv[]) { HFILE	ttyfd; USHORT	action;
 int	err,i; char	failname[80]; char	args[80]; RESULTCODES	res;) struct dcb {			/* Device control block */  	USHORT write_timeout; 	USHORT read_timeout;t 	BYTE flags1, flags2, flags3;  	BYTE error_replacement; 	BYTE break_replacement; 	BYTE xon_char;[ 	BYTE xoff_char;	 } ttydcb;m   	/*** Open a file ***/< 	if (err=DosOpen(argv[1],&ttyfd,&action,0L,0,1,0x0012,0L)) {. 		printf("Error %d opening %s\n",err,argv[1]);
 		exit(1); 	}4 	if (err=DosDevIOCtl(&ttydcb,NULL,0x0073,1,ttyfd)) {4 		printf("Error %d from IOCTL on %s\n",err,argv[1]);     		exit(1); 	} 	ttydcb.flags3 &= 0xF9; 8 	ttydcb.flags3 |= 0x04;	/* Read "some" data from line */* 	DosDevIOCtl(NULL,&ttydcb,0x0053,1,ttyfd);   	/*** Call kermit ***/ 	strcpy(args,"ckoker");' 	i = strlen(args);
 	args[i++]=0;e. 	sprintf(&args[i],"-u %d -q -s test.c",ttyfd); 	i += strlen(&args[i]);e
 	args[i++]=0;d
 	args[i++]=0;p9 	if (err=DosExecPgm(failname,80,EXEC_SYNC,args,NULL,&res,c 						    "KERMIT.EXE")) {, 		printf("Error %d executing Kermit\n",err);
 		exit(1); 	} 	e  	/*** Print out return code ***/3 	printf("Termination code %d\n",res.codeTerminate);b+ 	printf("Result code %d\n",res.codeResult);r   	/*** Close the file ***/. 	if (err=DosClose(ttyfd)) {e. 		printf("Error %d closing %s\n",err,argv[1]); 	} }n @end(verbatim)  ) @section(C-Kermit on the Commodore Amiga)]  = This section written mostly by Jack Rouse and Stephen Walton.b  J This version of Amiga Kermit is a port of the UNIX C-Kermit which attemptsI to reproduce as much of the functionality of UNIX version as possible.  IoH had two main goals in porting C-Kermit:  I wanted a reliable remote fileE transfer utility, and I wanted to investigate the use of the AmigaDOSy and Exec environments.  ? Amiga Kermit currently provides a line oriented user interface.  The DIALD and SCRIPT commands are as yet unimplemented.  Therefore, only Amiga" specific features are noted below.   @subsection(Invoking C-Kermit)  E Amiga Kermit is usually invoked from a CLI process.  However, you can)G also start it from a Tool type icon, at least for the version of KermitrH compiled with Manx Aztec C.  Create a Tool icon, called @q<Kermit.info>,D and make sure that it contains a ToolType entry for WINDOW= followedE by some window specification.  This is actually a small dummy window,i- as C Kermit will open and use its own window.e  ' From a CLI window, you generally enter:s @example(KERMIT) or @example(RUN KERMIT)I to execute Kermit and start up the Kermit command interpreter.  Make suretK you set your stack to at least 10000 with the AmigaDOS Stack command first. 5 Kermit will create its own window and greet you with:  @begin(example)i=    C-Kermit S/W, @value(-ckversion) 8 Feb 92, Commodore Amigas    Type ? or 'help' for help    C-Kermit>
 @end(example)q  E The cursor will appear following the C-Kermit> prompt.  Typing ? will = produce a list of the items that can be entered at any point.g  F Typing ? at various points during command entry will help you navigateH through the command processor.  The 'help' command is also quite useful.  H The Kermit command processor is normally exited with the 'QUIT' command.F During Kermit protocol, you can type CTRL-C or CTRL-D to interrupt andF exit Kermit.  Depending on the version of the C runtime libraries usedJ to link Kermit, the interrupt may also be active during command input, butF it is disabled during connect mode.  You will get a requestor when theK interrupt is activated to allow you to choose to continue Kermit.  However,sD any serial read or write that was interrupted will still be aborted.  F Kermit can also be used without the command processor by specifying anH action on the command line.  You can enter 'kermit -h' at the CLI promptL to get a list of command line options.  However, unless input is redirected,H or the -q (quiet) option is specified, Kermit will still create a windowE for protocol monitoring and interruption.  'KERMIT <*' can be used toyI run Kermit completely within the CLI window; however, this does not allowCG you to enter control characters, and no console input is seen until youoL enter return.  Input and output can be redirected to files to take advantageH of C-Kermit command line file transfer options.  Unfortunately, AmigaDOS does not implement pipes (yet).i  6 @subsection<Kermit Serial Initialization and Settings>  F Amiga Kermit uses the serial device or a reasonable emulation thereof.G Three sources are used to initialize the serial parameters.  First, the/E default serial configuration, as set by Preferences, is copied.  ThisiI includes baud rate, and under version 1.2 of the Workbench, parity, modemhD control (7-wire vs. 3-wire), and flow control.  Second, command line@ parameters can be used to override these settings.  For example: @example(kermit -b 1200 -p e)eD can be used to select 1200 baud and even parity independently of theH Preferences settings.  Finally, if the command processor is used, KermitK looks for a @q".kermrc" initialization file, first in the @q"s:" directory,kF then in the current directory, providing that the disk containing eachJ directory is present in the Amiga.  The @q".kermrc" file contains C-KermitM commands which can be used to initialize the C-Kermit environment as desired.n  G The Kermit SET LINE command has a special form in Amiga Kermit, namely:," @example(SET LINE @i<device/unit>)  N where @i"device" is the name of a device (including the @q<.device> extension)G and @i"unit" is the unit number.  The default setting is equivalent to: " @example(SET LINE serial.device/0)  G The modem control mode is currently selected by 'SET MODEM type', whichpH has two choices: 'DIRECT', for 3-wire control, and 'GENERIC', for 7-wireJ control.  Because of the way the serial device operates, this setting onlyE has an effect when the serial device is opened after previously beingtJ closed, which occurs only when the serial line is used after Kermit starts> or after '<escape>H' is used to hang up and exit connect mode.  C Kermit allows you to set any baud rate between 110 and 292000 baud;rD however, it will complain if the baud rate is nonstandard.  Rates ofI 110 and 111 baud are implemented as 112 baud.  Rates above 38400 baud caneI be used for connect mode, but they are not very useful for file transfer.yC The file transfer rate is limited by packet retries due to transferw9 errors, and the overhead time spent constructing packets.   F Amiga Kermit uses the serial device in shared mode.  This allows otherH programs, like dialers, to use the serial line at the same time, withoutJ exiting Kermit.  This could also allow in theory a terminal emulator to beK used simultaneously with Kermit.  However, if two programs are reading fromhJ the serial line at the same time, the results are unpredictable.  Any suchJ program, therefore, would have to be disabled from reading while Kermit isL performing file transfer or is in connect mode.  Note that Kermit since doesL its own parity generation and stripping, so it always sets the serial device+ to use eight bit characters with no parity.    @subsection<Amiga Wildcards>  G Both the SEND command invoked from the Amiga and a GET sent to an AmigaaC in server mode use allow wildcarding, in the UNIX style.  Thus, '*'hC wildcard matches an arbitrary string while '?' matches an arbitrarymK character.  Therefore, to get all the C source files which begin with 'cki' 1 from the Amiga server, you could use the command:e @begin(example)d    C-Kermit>@ux[get cki*.c]y
 @end(example) ? Multiple '*' wildcards can be used in a pattern.  Remember, thepH wildcarding that is used in local and remote server commands that invoke' AmigaDOS commands is the AmigaDOS form.r  & @subsection(Local and Remote Commands)  J Amiga Kermit provides several ways to invoke AmigaDOS commands from withinL Kermit.  Entering '!' at the Kermit prompt will create a CLI process runningK in its own window, and wait for it to terminate.  The form '! command' will J invoke the given command command with its output going to Kermit's window.J There is currently no way to pause the output of commands invoked his way,G other than the stopgap use of the right mouse button.  The form 'REMOTEsJ HOST command' can be sent to the Amiga server to execute the given commandF remotely on the Amiga.  Because of the way AmigaDOS Execute() functionJ works, commands invoked in either the '! command' or 'REMOTE HOST command'E forms have NIL: as their standard input.  Some AmigaDOS commands thatoJ require input, such as DiskCopy and Format, do not recognize the immediateI end of file that they receive under this condition, causing them to hang.S  E In addition to the methods given above, various AmigaDOS commands are E invoked by local Kermit commands, and generic remote commands.  Thesea are listed below:e% @begin<example,leftmargin 0, above 1>iL @ux<AmigaDOS command>    @ux<Local command>      @ux<Remote generic command>: DELETE files        --none--           REMOTE DELETE files8 TYPE files          --none--           REMOTE TYPE files3 INFO                SPACE              REMOTE SPACEr7 LIST obj            DIRECTORY obj      REMOTE DIRECTORY 1 STATUS              --none--           REMOTE WHOg
 @end<example>)  J Any parameters to these commands are expected to use AmigaDOS conventions,I including AmigaDOS wildcarding.  Note that in order to pass a '?' throughn? the C-Kermit command processor, it must be prefixed with a '\'.e  K You can change the current directory of the Kermit process locally with theeG CWD command and remotely with REMOTE CWD.  The local CWD command printsnF out the name of the current directory afterwards.  If no new directoryH is given, the current directory is not changed, so CWD alone can be used, to determine where the current directory is.   @subsection<Server Mode>  E Amiga Kermit completely implements server mode, including the abilityuF to execute CLI commands remotely.  Currently CLI commands are executedE with their standard output directed to RAM:PIPE-HOLDER, which is then B written back to the commanding Kermit after the command completes.  J There are a few limitations on the commands that can be executed remotely.E First of all, if they produce voluminous output, the output should beeE redirected (redirection is supported on the REMOTE HOST command line)RA to avoid using all free memory for the output file.  However, the F commanding Kermit will probably timeout in the middle of the execution> of any such command.  The best way to use these commands is to @begin<example> .    REMOTE HOST RUN command >outfile parameters
 @end<example> E then use REMOTE WHO (which invokes STATUS) to monitor the command forl completion.   B The input stream for remote commands is NIL:, which is not handledH intelligently by all Amiga commands.  For example, 'REMOTE HOST diskcopyH df0: to df1:' hangs indefinitely while waiting for NIL: to press return.H Finally, since each command is executed in a separate CLI, commands thatG set unshared process parameters, like 'cd',  will have null effect (butl& 'REMOTE CWD dir' can be used instead).  D While server mode is active, AmigaDOS requestors are disabled.  ThisK avoids requiring operator intervention to reset a requestore when the Amiga F server is told to use a file on a disk that does not exist or is writeK protected.  However, disabled requestors are currently not inherited by thehA CLI processes that the server creates to execute remote commands. I Therefore, a remote AmigaDOS command can still cause the server to becomel hung.   D To shut down the Amiga server, enter BYE or FINISH at the commandingD Kermit.  FINISH exits to whatever level the server was invoked from,( while BYE exits Amiga Kermit altogether.   @subsection<Connect Mode>n  C Connect mode on Amiga Kermit currently provides you with a standardm> AmigaDOS console device window.  Using the default Preferences? setting, this gives a 23 row by 77 column screen.  However, the A MoreRows program allows you to increase the size of the WorkbenchCC window beyond the 640 by 200 default size; increasing the number of C rows by 8 and the number of columns by 16 will allow a 24 row by 80 B column Kermit window.  The Amiga console device is used to provideE ANSI terminal emulation.  While you are in connect mode, you can give C single character commands which are prefixed by an escape charactere> which can be set from within C-Kermit.  By default, the escapeA character is CTRL-\.  You can use '<escape>H' to close the serial C device and exit connect mode, which makes the DTR line drop causing & most modems to hang up the phone line.  G You can currently get a 25 by 80 screen in Kermit by means of a kludge.eH Entering the Kermit command line (backslashes will be echoed only once):6 @example(ECHO \\033[25t\\033[80u\\033[0x\\033[0y\\014)H activates console device private escape sequences that cause the consoleG to use a 25 by 80 region, overwriting the borders of the Kermit window.mF Using window gadgets will cause the borders to be redisplayed, but theE display can be cleaned up by typing ctrl-L in command mode.  To reset7; the window to its normal condition, allowing resizing, use: 0 @example(ECHO \\033[t\\033[u\\033[x\\033[y\\014)I and then activate a window gadget to refresh the borders.  These commandsu% can be placed into Kermit TAKE files.   H In addition to the standard connect mode commands, extra logging controlH has been added.  If a session log file is open, the '<escape>Q' sequenceD allows you to temporarily suspend logging.  The '<escape>R' sequence) resumes logging if it has been suspended.m  H Features have also been added to prevent deadlocks while in connect modeF due to spurious XOFF's or bad modem control line states.  When connectJ mode is unable to send serial output, keyboard characters are queued untilI they can be transmitted.  Queuing continues as long as space is available L in the output buffer.  If the buffer, which is 64 characters long, fills up,I the next keyboard input is discarded and the display 'beeps'.  To get outtK of a deadlock situation, you can either exit connect mode, or send a break.)F In either case, the output queue is flushed, and current serial outputE character is given one second to finish transmitting.  If it does notgJ complete, the output is aborted, and XOFF mode reset as appropriate.  ThenE connect mode is exited or a break is sent, as specified.  When output D characters are queued, connect status (accessed by '<escape>S') will0 indicate the number of queued output characters.   @section(C-Kermit under OS-9)   I C-Kermit was adapted to OS-9 by Christian Hemsing, RWTH, Aachen, Germany,aI and Bob Larson of the University of Southern California.  This section ofu, the manual was written by Christian Hemsing.  K The commands and operation of OS-9 C-Kermit should be identical to those ofeG UNIX C-Kermit, with the exceptions noted here and in the "beware file".e  ' The initialization file is @q<.kermrc>.a    @subsection<OS-9/68K Background>  I OS-9/68k is a multiuser, multitasking operating system designed to run on(M all Motorola 680x0 family processors from Microware Systems Corporation, 1900 G N.W. 114th Street, Des Moines, Iowa 50332 (Trademarks: Microware, OS-9,  OS-9/68000, OS-9000).h  B Due to its modular design, most of the code is completely hardwareM independent, so it can be easily be ported to a different hardware by writingK new device drivers.   K The original (1980) OS-9/6809 was designed for the Motorola 6809 processor.tL Later (1983) they switched to the 680x0 family and released OS-9/68000.  ForI speed and compactness reasons most of the OS-9/68000 kernel is written inwN 680x0 assembler language.  Now there is a so-called OS-9000 by Microware.  ItsN kernel is written in C and thus it is portable.  It is presently available forK 680x0 and Intel's 80386/486, and Microware plans to add further support fornL RISC and CISC processors.  (C-Kermit has not yet been tested under OS-9000.)  C The 100% ROM-able, fast, compact code in conjunction with real-time)I capabilities make OS-9/68k ideal for ROM-based systems used in measuring, K controlling, etc.  It has found a wide acceptance within the scientific ando industrial world.O  H Yet, a full disk based OS-9/68k offers a program development environmentN similar to UNIX. This includes (of course, limited) UNIX sofware compatibilityO at C source code level, source code level debugging, UNIX I/O model, UNIX task  & model, UNIX-like shell and networking.  I A number of UNIX utilities like lex, yacc, lint, etc, have been ported tot	 OS-9/68k./   The basic commands of OS-9 are:p @begin<description,spread 0> DEL@\delete a file   DELDIR@\delete a directory   MAKDIR@\create a directory   DIR@\directory listing  ' PROCS@\show currently running processeso  " LIST@\type contents of a text file   CHD@\change working directoryg   PD@\print working directory  @end<description>"  L All commands can be given a @q<"-?"> as a switch, which will display a brief" (usually sufficient) help message.  I All command references (like all references to names on OS-9/68k) are NOTyF case sensitive (switches, though, may be case sensitive since they are$ interpreted by the running program).   @subsection<OS-9/68K Devices>X  J All devices (terminal lines, networks, disks) can have arbitrary names but the usual convention is:   @ux<Terminal lines>: @begin<format> @tabclear()@tabset(1inch)R!    @q<term>@\the console terminal     @q<t1>@\terminal line #1     @q<:>#    @q<t>@i<n>@\terminal line #@i<n>d @end<format>   @ux<Hard disks>: @begin<format> @tabclear()@tabset(1inch)t    @q<h0>@\hard disk #0h    @q<h1>@\hard disk #1     @q<:>    @q<h>@i<n>@\harddisk #@i<n> @end<format>   @ux<Floppy disks (diskettes)>: @begin<format> @tabclear()@tabset(1inch)h    @q<d0>@\floppy disk drive #0s    @q<d1>@\floppy disk drive #1n    @q<:>'    @q<d>@i<n>@\floppy disk drive #@i<n>m @end<format>  I A path name starting with a slash ("/") must always include a device nameeI as the first field.  For example, the C-Kermit command SET LINE /T3 woulda! select the terminal line @q</t3>.   M The console terminal is either a real terminal, or the screen and keyboard ofoK a workstation such as a Macintosh, Amiga, or Atari ST that is running OS-9.aG Terminal emulation is not done by OS-9 C-Kermit, but rather by the real L terminal or the workstation console driver.  This includes the capability to. display national and international characters.  % @subsection<The OS-9/68K File System>   B The file system is tree-structured just like the UNIX file system. @example</h0/chris>i5 means the directory  or file "chris" on hard disk #0.o @example<chris/rubbish> K means the subdirectory or file "rubbish" in the subdirectory "chris" of thee current directory.  J The command "chd" without any parameters will always take you to your home
 directory.  H Names of files, directories, devices, and commands are case-independent.J Filenames may contain letters, digits, period, underline, and dollar sign.D They are stored with upper and lower case preserved, but case is not# significant when referring to them.o    E Wildcard expansion is performed by the shell with two metacharacters:y+ @begin<description,leftmargin +4,indent -2> 9 @q<*>@\stands for an arbitrary string of arbitrary lengthr! @q<?>@\denotes a single charactero @end<description>h  I C-Kermit/OS-9 also expands wildcards itself, using the same notation, forg example: @begin(example)y C-Kermit>send ck*.\?
 @end(example) G (Note: the question mark must be prefixed by "\" to override its normalo# function of giving a help message.)b  H OS-9/68k files are sequential streams of 8-bit bytes, just like in UNIX,N except that carriage return (CR, ASCII 13) is the line terminator, rather thanL linefeed (LF, ASCII 10).  Binary files are simply streams of arbitrary 8-bitJ bytes.  The OS-9 operating system and utilities are "8-bit clean", so textH files can use any ASCII-based character set that is compatible with yourH display and data entry devices, for example ISO 8859-1 Latin Alphabet 1.  G Unlike UNIX, OS-9/68k has a built-in method to gain exclusive access tosM devices, so no lock files are needed.  The user will be told if the device isn already in use.   ' @subsection<To Build C-Kermit for OS-9>w  7 Collect all the C-Kermit source files into a directory:,D @example<ckc*.c, ckc*.h, cku*.c, cku*.h, ckwart.c, ckcpro.w, ck9*.*>  J There are two makefiles: @q<ck9ker.mak> and @q<ck9ker.gcc>.  If you have aO running version of the GNU C compiler, use @q<ck9ker.gcc> (it produces smaller, J more efficient code); otherwise use @q<ck9ker.mak> which uses the standardJ OS-9/68k C compiler.  Read the appropropriate makefile, edit the necessaryN changes mentioned there, create the subdirectories, and make the new Kermit by typing:b @example(make -f=ck9ker.mak) or:n @example(make -f=ck9ker.gcc)  M Read the "beware file" @q<ck9ker.bwr> for hints relating to the OS-9 terminal  driver. 