/* Jacket for <stat.h>. */

#include stat

#ifndef __MODE_T
#  define __MODE_T 1
    typedef unsigned short mode_t;
#endif /* ndef __MODE_T */

#ifndef S_IRWXU
#  define S_IRWXU 0000700     /* read,write,execute perm: owner */
#endif
#ifndef S_IRUSR
#  define S_IRUSR 0000400     /* read permission: owner */
#endif
#ifndef S_IWUSR
#  define S_IWUSR 0000200     /* write permission: owner */
#endif
#ifndef S_IRWXG
#  define S_IRWXG 0000070     /* read,write,execute perm: group */
#endif
#ifndef S_IRWXO
#  define S_IRWXO 0000007     /* read,write,execute perm: other */
#endif
#ifndef S_IRWXUGO
#  define S_IRWXUGO (S_IRWXU|S_IRWXG|S_IRWXO)         /* 0777. */
#endif
#ifndef S_ISDIR
#  define S_ISDIR(m) (((m)& S_IFMT) == S_IFDIR)
#endif /* ndef S_ISDIR */
#ifndef S_ISREG
#  define S_ISREG(m) (((m)& S_IFMT) == S_IFREG)
#endif /* ndef S_ISREG */

/* Macros for futimens and utimensat.  */
#ifndef UTIME_NOW
# define UTIME_NOW (-1)
# define UTIME_OMIT (-2)
#endif

