8 *   Extr_Col.For -- column oriented routines for Extract2 *                   [also command line processing]J *                                                       Pat Rankin, Oct'88J *                                                         modified, Jul'89; *  log  Expand_Tabs ( col_cnt, col_list, record$, rec_len ) + *  sub  Select_Substring ( range, rec_dsc ) > *  log  Select_Columns ( col_cnt, col_list, record$, rec_len )0 *  i*4  Process_Column_List( size, list, first )% *  i*4  Param_Init ( outfile, o_len ) 0 *  sub  Give_Signal ( condition, param, status ) *              logical function=      &    Expand_Tabs ( col_cnt, col_list, record$, rec_len )  	!= 	!   Replace tab characters with the proper number of spaces. @ 	!   We're constrained by expanding in place (which makes things  	!   absurdly over-complicated). 	!E 	!   Tab stops are defined to be every 8th column:  1, 9, 17, 25, ...  	! 	implicit none C     called by:& *       subroutine      Process_Record C     constant5 	character *1    tAB             !ascii tab character D 	byte            CR,  BS,  rUB   !carriage return, backspace, rubout? 	parameter     ( tAB = CHAR(9),  CR = 13,  BS = 8,  rUB = 127 ) 4 	parameter       tAB_SIZE = 8,  tAB_CACHE_SIZE = 256 C     input:B 	integer *4      col_cnt,        !number of elements in col_list[]G      &                  col_list(2,*)   !list of column ranges (sorted)  C     input/output: 2 	character *(*)  record$         !one line of data> 	integer *2      rec_len         !functional length of record$ C     local: 	logical         result 2 	integer *4      length,  pos,  old_pos,  end_col,7      &                  added_len,  chunk_len,  log_pos . 	integer *2      len_word,  pos_word,  spaces,2      &                  cache_ptr,  tab_cnt,  idx,3      &                  pos_cache(2,tAB_CACHE_SIZE) 7 	  equivalence ( length, len_word ),  ( pos, pos_word )  	character *1    c$  	byte            c< 	  equivalence ( c$, c )         !simplify character testing C     functions:/ 	intrinsic       INDEX,  ZEXT,  MOD,  MIN,  LEN   @ 	result = .false.                !(*not really implemented yet*)6 	length = ZEXT(rec_len)          ! unsigned i*2 -> i*4B 	if ( length .eq. 0 )  GOTO 91   !nothing to do if record is empty     11  continueG 	if ( col_cnt .gt. 0 ) then      !got column range(s) [limits interest] F 	    end_col = MIN( col_list(2,col_cnt), LEN(record$))   !final column 	else ? 	    end_col = LEN(record$)      !need to process entire record  	end if - 	if ( end_col .lt. length )  length = end_col   0 C     find first tab; if none, we can return now$ 	pos = INDEX( record$(:length), tAB)E 	if ( pos .eq. 0 .or. pos .gt. end_col )  GOTO 91        !leave as is    C G C     first pass:  identify tab positions and determine ultimate length  C / 	old_pos = 0             !previous tab location F 	log_pos = 0             !logical column position after last characterG 	added_len = 0           !number of additional characters due to spaces : 	cache_ptr = 0           !index into list of tab locations 	tab_cnt = 0 	do while ( pos .gt. 0 ) 	    pos = old_pos + posO C         figure out our logical position (determines # of spaces for this tab) " 	    do idx = old_pos + 1, pos - 1 		c$ = record$(idx:idx) > 		if ( (c .and. '7F'x) .ge. ' '           !printable character7      &            .and. (c .and. '7F'x) .ne. rUB ) then  		    log_pos = log_pos + 1 : 		else if ( c .eq. CR ) then              !carriage return 		    log_pos = 0 @ 		else if ( c .eq. BS .and. log_pos .gt. 0 ) then     !backspace 		    log_pos = log_pos - 1  *               elseK *                   non-printable character does not advance logical column  		end if 	    end do 0 	    spaces = tAB_SIZE - MOD( log_pos, tAB_SIZE) 	    log_pos = log_pos + spaces 5 	    if ( pos + added_len - 1 + spaces .gt. end_col ) <      &              spaces = end_col - (pos + added_len - 1)' 	    added_len = added_len + spaces - 1  C         store tab's position 	    tab_cnt = tab_cnt + 1 	    cache_ptr = cache_ptr + 1F 	    if ( cache_ptr .gt. tAB_CACHE_SIZE )  cache_ptr = 1         !wrap& 	    pos_cache(1,cache_ptr) = pos_word$ 	    pos_cache(2,cache_ptr) = spaces C         look for next tab  	    old_pos = pos 	    pos = 0@ 	    if ( old_pos .lt. length )          !ok to look for new pos@      &              pos = INDEX( record$(old_pos+1:length), tAB)N 	    if ( pos + old_pos + added_len .gt. end_col )  pos = 0  !past last column 	end do !while more tabs   C < C     second pass:  replace tabs with spaces (right to left) C 7 	pos = length + 1        !just past end of input string , 	if ( length + added_len .lt. end_col ) then! 	    end_col = length + added_len  	else " 	    pos = end_col - added_len + 1 	end if & 	length = end_col        !save end_col. 	do idx = MIN( tab_cnt, tAB_CACHE_SIZE), 1, -1 	    old_pos = pos& 	    pos_word = pos_cache(1,cache_ptr)$ 	    spaces = pos_cache(2,cache_ptr)" 	    chunk_len = old_pos - pos - 1 	    if ( chunk_len .gt. 0 )H      &   record$(end_col-chunk_len+1:end_col) = record$(pos+1:old_pos-1)+ 	    end_col = end_col - chunk_len - spaces , 	    record$(end_col+1:end_col+spaces) = ' ' 	    cache_ptr = cache_ptr - 1F 	    if ( cache_ptr .eq. 0 )  cache_ptr = tAB_CACHE_SIZE         !wrap 	end do !next cached position  C D C     if we couldn't handle them all this time, start all over again( C           ******** NOT TESTED ******** C ( 	if ( tab_cnt .gt. tAB_CACHE_SIZE ) then( 	    record$(pos:) = record$(end_col+1:)( 	    length = length - (end_col+1 - pos) 	    rec_len = len_word 7 	    length = pos        !optimization to limit index() F 	    GOTO 11     !****                                           !LOOP 	end if   C     done: set output parameter 	rec_len = len_word      91  continue 	Expand_Tabs = result  	return        end !of Expand_Tabs         5       subroutine  Select_Substring ( range, rec_dsc )  	!9 	!   Modify a string descriptor to reference a substring. > 	!   [Optimization used when selecting a single column range.] 	! 	implicit none C     called by:& *       subroutine      Process_Record C     constant: @ 	include 'f_inc:Dsc.F'                   !descriptor definitions C     input:< 	integer *4      range(2)                !start & end values C     input/output: ? 	record /dsc/    rec_dsc                 !descriptor for record  C     local:  	integer *4      length,  offset 	integer *2      length_word& 	  equivalence ( length, length_word ) C     functions:! 	intrinsic       MAX,  MIN,  ZEXT    	offset = range(1) - 1 c     caculate length = 	length = MAX(MIN(range(2), ZEXT(rec_dsc.d_len)) - offset, 0)  c     update descriptor fields= 	if ( offset .gt. 0 )  rec_dsc.d_adr = rec_dsc.d_adr + offset  	rec_dsc.d_len = length_word   	return        end !of Select_Substring               logical functionH      &   Select_Columns ( col_cnt, col_list, in_rec$, outrec$, rec_len ) 	!< 	!   Replace record with specific columns.  ['col_cnt' >= 1]B 	!   Returns true if data copied into output record, false if it's? 	!   left in input record (due to selecting columns 1..n only).  	! 	implicit none C     called by:& *       subroutine      Process_Record C     input:I 	integer *4      col_cnt,                !number of entries in 'col_list' K      &                  col_list(2,*)           !sorted list of range pairs 6 	character *(*)  in_rec$                 !input string
 C     output: F 	character *(*)  outrec$                 !output string (len >= input) C     input/output: H 	integer *2      rec_len                 !record length (before & after) C     local:G 	logical         result                  !true=>outrec$, false=>in_rec$ 5 	integer         indx                    !array index # 	integer *4      next,  last,  ltmp  	integer *2      last_word" 	  equivalence ( last, last_word ) C     functions:  	intrinsic       LEN,  MIN,  MAX  6 	result = .false.        !data not copied into outrec$D 	if ( col_cnt .le. 0 )  GOTO 92          ![this should never happen]  N C     check whether first column range includes left-most part of input stringB 	if ( col_list(1,1) .gt. 1 ) then        !skipping start of string6 	    indx = 0            !start with first column pair. 	    last = 0            !end of string so far7 	else            !beginning of string is being included 4 	    indx = 1            !skip to second column pair? 	    last = MIN( col_list(2,1), LEN(in_rec$)) !end of 1st range  	end if C 	if ( indx .eq. 0 .or. col_cnt .gt. 1 ) then     !need to copy data = 	    result = .true.     !data is being copied into 'outrec$' J 	    if ( indx .eq. 1 )  outrec$(:last) = in_rec$(:last) !copy 1st segment 	end if     C     loop through column ranges 	do while ( indx .lt. col_cnt ) + 	    indx = indx + 1     !next column range D 	    next = col_list(1,indx)                     !start of substring' 	    if ( next .le. LEN(in_rec$) ) then A 		ltmp = MIN( col_list(2,indx), LEN(in_rec$)) - next + 1  !length 7 		outrec$(last+1:last+ltmp) = in_rec$(next:next+ltmp-1)  		last = last + ltmp< 	    else        !request column(s) past end of input record* 		indx = col_cnt + 1      !force loop exit 	    end if ! 	end do  !loop: next column range - 	rec_len = last_word     !store return length     92   continue 	Select_Columns = result 	return        end !of Select_Columns        =       integer *4 function  Process_Column_List ( size, list )  	!; 	!   Convert strings into integers.  Overwrite the original ? 	!   string descriptors with the values.  Each string is either B 	!   a single number or a pair of numbers separated by '-' or ':'. 	!> 	!   The list of ranges are sorted into ascending sequence andA 	!   then overlapping ranges are consolidated.  Also, if the size D 	!   of the list is negative then first element of the list was "-",& 	!   so the ranges are to be inverted:1 	!       ("-","5-10","15-20") -> (1-4,11-14,21-*)  	! 	implicit none C     called by:" *       function        Param_Init C     constant: > 	include '($SHRdef)/nolist'              !shared message codes? 	include 'f_inc:Dsc.F'                   !($DSCdef) descriptors @ 	structure /dsc_or_range/        !custom structure for this task 	  union 	    map; 	      record /dsc/  descrip             !string descriptor] 	    end map 	    map9 	      integer *4    low,  high          !pair of numbers  	    end map 	  end union 	end structure !dsc_or_range7 	parameter       mAX_COLUMN = '0000FFFF'x        !65535r C     input/output:bC 	integer *4      size            !number of elements (might change)cE 	record /dsc_or_range/ list(*)   !raw input strings -> numeric rangess C     local: 	record /dsc_or_range/ work_. 	integer         indx,  pos,  len_tmp,  offset! 	integer *4      sts,  low,  highu C     functions:( 	integer         STR$COMPARE,  LIB$INDEX 	integer *4      STR$FREE1_DX,M      &                  OTS$CVT_TI_L            !convert text integer to longd 	intrinsic       ABS,  MIN   C / C     first pass:  convert strings into numberso CaA 	work.descrip.d_quad(1) = 0  !dsc: type & class unspecified (Z,Z)i 	sts = 1I 	if ( size .eq. -1 )  sts = SHR$_VALERR  !what columns are we discarding?a	 	indx = 0 + 	do while ( sts .and. indx .LT. ABS(size) )  C         get next string!7 	    indx = indx + 1             !increment array index=G 	    work.descrip.d_len = list(indx).descrip.d_len       !string length,G 	    work.descrip.d_adr = list(indx).descrip.d_adr       !  "   addressu
 	    low  = 0s
 	    high = 0 6 C         check for range (by looking for punctuation)D 	    pos = LIB$INDEX( work.descrip, ':')         !find colon or dash; 	    if ( pos .eq. 0 )  pos = LIB$INDEX( work.descrip, '-')i 	    if ( pos .eq. 0 ) then 8 C             single number  (treat as a range of "n:n")< 		sts = OTS$CVT_TI_L( work.descrip, low)  !convert to binary6 		high = low              !'range' covers single value	 	    elsee< C             range  (note special handling for leading '-')7 		len_tmp = work.descrip.d_len    !save original lengthlB 		work.descrip.d_len = pos - 1    !reduce length: start thru punct 		if ( pos .eq. 1c!      &            .or. pos .eq. 2!H      &               .and. STR$COMPARE( work.descrip, '*') .eq. 0 ) then: C                 (negative => nogood unless special case); 		    if ( indx .eq. 1    !first element:  implied column 1 ?      &                .or. indx .eq. 2 .and. size .lt. 0 ) then 6 			low = 1         !starting column of '1' was implied
 		    else 			sts = SHR$_VALERR 		    end if% 		else    !convert string into numberi, 		    sts = OTS$CVT_TI_L( work.descrip, low) 		end if$ 		if ( sts ) then         !ok so farD C                 adjust descriptor to point to right part of string( 		    work.descrip.d_len = len_tmp - pos3 		    work.descrip.d_adr = work.descrip.d_adr + pos)$ 		    if ( work.descrip.d_len .eq. 06      &                  .or. work.descrip.d_len .eq. 1H      &                      .and. STR$COMPARE( work.descrip, '*') .eq. 0H      &              ) then  !only ok for last element (or inversion '-')4 			high = mAX_COLUMN       !guaranteed end of record 			if ( indx .lt. ABS(size)iB      &                    .and. ( indx .gt. 1 .or. size .gt. 0 ) )1      &                          sts = SHR$_VALERR ) 		    else    !convert string into number * 			sts = OTS$CVT_TI_L( work.descrip, high) 		    end if  		end if !low value converted ok% 	    end if !punctuation pos => rangex  @ 	    if ( sts    !if ok so far, check for invalid range value(s)F      &        .and. ( high .lt. low .or. low .lt. 1 .or. high .lt. 1 )      &      ) then& 		sts = SHR$_VALERR       !value error	 	    else : C             replace descriptor data with pair of numbers$ 		work.low  = MIN(  low, mAX_COLUMN)$ 		work.high = MIN( high, mAX_COLUMN)4 		if ( list(indx).descrip.d_cls .eq. DSC$K_CLASS_D )O      &                  call STR$FREE1_DX( list(indx).descrip)  !release memory- 		list(indx).low  = work.low 		list(indx).high = work.high  	    end if  	end do !next indx         if ( sts ) then& C ( C     second pass:  clean up the numbers C 5 	do indx = 2, ABS(size)          !sort the short list  	    low = list(indx).low , 	    if ( low .lt. list(indx - 1).low ) then 		high = list(indx).high 		pos = indx - 16 		do while ( pos .gt. 0 .and. low .lt. list(pos).low )( 		    list(pos + 1).low  = list(pos).low) 		    list(pos + 1).high = list(pos).higha 		    pos = pos - 1s 		end do !sort loopi 		list(pos + 1).low  = low 		list(pos + 1).high = highs 	    end if  	end do !next indx Cc 	if ( size .lt. 0 ) then4 C         convert exclusion list into inclusion list 	    size = ABS(size)oB 	    list(1).low = 1     !(element '1' had been used only for "-") 	    offset = 1iH 	    if ( list(2).low .le. 1 ) then      !excluding left-most part (1:x)A 		list(1).low = list(2).high + 1  !so include beyond that (x+1:?)t 		offset = 2 	    end if  	    do indx = offset + 1, sizeeB 		list(indx - offset).high = list(indx).low - 1   !copy next 'low'  		if (  list(indx - offset).highE      &           .lt. list(indx - offset).low  )  offset = offset + 1_ 		if ( offset .eq. 1F      &           .or. list(indx).high .ge. list(indx - (offset-1)).lowD      &          )  list(indx - (offset-1)).low = list(indx).high + 1 	    end dod 	    size = size - (offset-1) F 	    list(size).high = mAX_COLUMN    !exclude (p:q) -> include (q+1:*); 	    if ( list(size).low .gt. mAX_COLUMN )  size = size - 1  	elser- C         consolidate redundant column rangesf 	    offset = 1l 	    do indx = offset + 1, sizev7 		if ( list(indx).low .le. list(indx - offset).high + 1i=      &          ) then          !overlap exists; eliminate itc: 		    if ( list(indx).high .gt. list(indx - offset).high )F      &                      list(indx - offset).high = list(indx).high 		    offset = offset + 1   		else if ( offset .gt. 1 ) then3 		    list(indx - (offset-1)).low  = list(indx).lowt4 		    list(indx - (offset-1)).high = list(indx).high 		end if 	    end dor3 	    if ( offset .gt. 1 )  size = size - (offset-1)r 	end ife  1 C     if possible, optimize list out of existence + 	if ( size .eq. 1 .and. list(1).low  .eq. 1 G      &                   .and. list(1).high .eq. mAX_COLUMN )  size = 0i       end if !stsl   	Process_Column_List = sts 	return_!       end !of Process_Column_List'        8       integer *4 function  Param_Init ( outfile, o_len ) 	! 	!   Process the command line. 	!D 	!   Note: label for input file changed from "INPUT" to "INPUT_EXTR"C 	!       to make it different from everything in RUN and MCR.  This E 	!       is to ensure that we get a syntax error if we're not invokednC 	!       as a native command (so that we can then parse the commandX 	!       ourself). 	! 	implicit none C     called by:& *       program         Extract (main) C     constant: > 	include '($SHRdef)/nolist'              !shared message codesC 	include 'f_inc:Cli.F'                   !command line routine defstF 	parameter       mAX_RECORD = '7FFFFFFF'x        !largest positive i*4  0 	character *(*)  fACILITY_VERB,  fACILITY_PROMPTK 	parameter     ( fACILITY_VERB   = 'EXTRACT' )   !also in main, Give_Signal': 	parameter     ( fACILITY_PROMPT = fACILITY_VERB // '> ' )G 	external        Extract_Cmd     !command tables ($ set command/object)o C     global output: 	include 'Extract.F'
 C     output:uH 	character *(*)  outfile                 !output filename (from /output)= 	integer *2      o_len                   !length of 'outfile'  C     local:? 	character *8    qualif                  !holds a qualifer name$< 	integer *2      qlen                    !length of 'qualif'1 	integer *4      got_start,  got_end,  got_count,n2      &                  expand_tabs,  sts,  tmpsts C     functions: 	integer         LIB$MATCH_COND - 	integer *4      Cli_Present,  Cli_Get_Value, *      &                  Cli_Parse_Command,6      &                  Get_Inp_List,  Get_Cli_Number,,      &                  Process_Column_List,       &                  STR$TRIM   C     input file(s)u4 	inp_cnt = 0             !number of input file specs> 	sts = Get_Inp_List( 'INPUT_EXTR', inp_siz, inp_list, inp_cnt)5 	if ( LIB$MATCH_COND( sts, CLI$_SYNTAX) .gt. 0 ) then L C         syntax error indicates we weren't invoked as a native dcl command,? C             so we now want to generate a command and parse iti? 	    sts = Cli_Parse_Command( Extract_Cmd,       !command tablelB      &                              fACILITY_VERB,      !"EXTRACT"D      &                              fACILITY_PROMPT)    !"EXTRACT> "& 	    if ( sts )  !if ok, now try againH      &      sts = Get_Inp_List( 'INPUT_EXTR', inp_siz, inp_list,inp_cnt) 	end if.. C     output file (/NOoutput is not supported) 	if ( sts ) then 	    o_len = 03 	    sts = Cli_Get_Value( 'OUTPUT', outfile, o_len):2 	    if ( LIB$MATCH_COND( sts, CLI$_ABSENT) .gt. 0!      &        .or. o_len .eq. 0 ) L      &              sts = STR$TRIM( outfile, 'SYS$OUTPUT', o_len)   !default 	end ifxF 	if ( .not. sts )  goto 98       !give up [avoid nested if's]    !GOTO  F C     check whether user wants each file indentified before processingN C         2 = never, 1 = always, 0 = iff list, wildcard, or searchlist in spec
 	identify = 0s" 	tmpsts = Cli_Present( 'IDENTIFY')9 	if ( LIB$MATCH_COND( tmpsts, CLI$_PRESENT) .gt. 0 ) then  	    identify = 1 > 	else if ( LIB$MATCH_COND( tmpsts, CLI$_NEGATED) .gt. 0 ) then 	    identify = 2e 	end ift  @ C     check for /translate={ ascii_to_ebcdic | ebcdic_to_ascii }
 	xlate = 0& 	if ( Cli_Present( 'TRANSLATE') ) then: 	    if ( Cli_Present( 'TRANSLATE.ASCII_TO_EBCDIC') ) then0 		xlate = 1       !ascii -> ebcdic (after /edit)? 	    else if ( Cli_Present( 'TRANSLATE.EBCDIC_TO_ASCII') ) then 1 		xlate = 2       !ebcdic -> ascii (before /edit)' 	    end if! 	end ifeI 	if ( identify .eq. 0 .and. xlate .eq. 1 )  identify = 2 !save some griefn  F C     check whether user cares about fixed-header portion of vfc files% 	use_vfc = 0             !/vfc=ignore-' 	if ( Cli_Present( 'VFC_HEADER') ) then:0 	    if ( Cli_Present( 'VFC_HEADER.DATA') ) then> 		use_vfc = 1     !/vfc=data  (treat header as part of record)5 	    else if ( Cli_Present( 'VFC_HEADER.KEEP') ) theni/ 		use_vfc = 2     !/vfc=keep  (preserve header)' 	    end if  	end if   O C     initialize extraction limits [tail=0, head=0, record:count=0 not allowed]f) 	start_val = 0           !starting recordc' 	end_val = 0             !ending records+ 	count_val = 0           !number of recordsg  9 	qlen = 0                !length of qualifier name string  	block_mode = .FALSE.c# 	if ( Cli_Present( 'BLOCKS') ) thenm 	    block_mode = .TRUE.C 	    identify = 2        !'never' (don't want id message in output)!+ 	    call STR$TRIM( qualif, 'BLOCKS', qlen)d) 	else if ( Cli_Present( 'RECORDS') ) then>, 	    call STR$TRIM( qualif, 'RECORDS', qlen)& 	else if ( Cli_Present( 'HEAD') ) then+ 	    sts = Get_Cli_Number( 'HEAD', end_val) > 	    start_val = 1                       !first record of file 	    if ( end_val .eq. 0 ) thenE. 		if ( sts )  sts = SHR$_VALERR   !value error$ 	    else if ( end_val .lt. 0 ) then8 		end_val = end_val - 1           !drop last 'n' records 	    end ifi& 	else if ( Cli_Present( 'TAIL') ) then- 	    sts = Get_Cli_Number( 'TAIL', start_val)s= 	    end_val = -1                        !last record of filea! 	    if ( start_val .eq. 0 ) then . 		if ( sts )  sts = SHR$_VALERR   !value error& 	    else if ( start_val .lt. 0 ) then9 		start_val = -( start_val - 1 )  !skip first 'n' records_" 	    else        !standard /tail=n: 		start_val = -start_val          !relative to end of file 	    end if  	else C C         default action is to display the first record of the fileb9 C             unless some sort of conversion is requestedr 	    start_val = 1 	    end_val = 1 	    if ( Cli_Present( 'EDIT')(      &      .or. Cli_Present( 'COLUMNS'),      &      .or. Cli_Present( 'EXPAND_TABS')I      &      .or. Cli_Present( 'TRANSLATE') )  end_val = -1    !whole filen 	end ifi  I 	if ( sts .and. qlen .gt. 0 ) then       !'qualif'=="RECORDS" or "BLOCKS" M C         check for "START", "END", and "COUNT" keywords and get their valuesr6 	    got_start = Cli_Present( qualif(:qlen)//'.START') 	    if ( got_start .and. sts )rH      &         sts = Get_Cli_Number( qualif(:qlen)//'.START', start_val)2 	    got_end = Cli_Present( qualif(:qlen)//'.END') 	    if ( got_end .and. sts ) H      &             sts = Get_Cli_Number( qualif(:qlen)//'.END', end_val)6 	    got_count = Cli_Present( qualif(:qlen)//'.COUNT') 	    if ( got_count .and. sts )0H      &         sts = Get_Cli_Number( qualif(:qlen)//'.COUNT', count_val)  7 	    if ( sts .and. (  got_start .and. start_val .eq. 0s>      &                   .or. got_end   .and. end_val   .eq. 0C      &                   .or. got_count .and. count_val .le. 0  ) )d<      &              sts = SHR$_VALERR           !value error 	else !skip adjustments below	 	    got_start = .FALSE. 	    got_end   = .FALSE. 	    got_count = .FALSE. 	end if !sts & got qual    	if ( sts ) then Cc3 C         set start & end, using count if necessaryT COD 	    if ( start_val .eq. 0 )  start_val = 1      !first line of fileC 	    if ( end_val   .eq. 0 )  end_val = -1       !last line of filer   	    if ( got_start ) then 		if ( got_count ) then ) 		    end_val = start_val + count_val - 1o2 		    if ( start_val .lt. 0 .and. end_val .ge. 0 )(      &                      end_val = -1 		end if 	    else if ( got_end ) then_ 		if ( got_count ) then	) 		    start_val = end_val - count_val + 1k2 		    if ( end_val .gt. 0 .and. start_val .le. 0 ))      &                      start_val = 1a 		end ifD 	    else if ( got_count ) then          !'count' only => 1..'count'6 		end_val = count_val             !(start remains '1') 	    end if   F 	    if ( end_val .eq. -1 )  end_val = mAX_RECORD    !largest possible   	end if !sts  / C     miscellaneous record modification options)* 	expand_tabs = Cli_Present( 'EXPAND_TABS')* 	numbered_output = Cli_Present( 'NUMBERS')  - C     process column inclusion/exclusion list  	col_cnt = 0. 	if ( sts .and. Cli_Present( 'COLUMNS') ) then? 	    sts = Get_Inp_List( 'COLUMNS', col_siz, col_list, col_cnt) $ 	    if ( sts .and. col_cnt .ne. 0 )G      &              sts = Process_Column_List( col_cnt, %VAL(col_list))l 	end if.  A 	if ( col_cnt .ne. 0 .or. xlate .eq. 1 .or. numbered_output) thenxK C         tab expansion is the default iff column processing or translationwM C             from ascii to ebcdic is requested or if numbering is being doneo< 	    if ( LIB$MATCH_COND( expand_tabs, CLI$_ABSENT) .gt. 0 )(      &              expand_tabs = .TRUE. 	end if < 	detab = ( (expand_tabs.and.1).eq. 1 )   !.and. xlate .ne. 2  	 	edit = 0v 	if ( Cli_Present( 'EDIT') ).      &          call Parse_Edit_Options( edit)I C         (should clear 'detab' if edit.collapse or edit.compress set and 4 C          column extraction is not being performed)   	key_index = 0" 	if ( Cli_Present( 'INDEX') ) then. 	    sts = Get_Cli_Number( 'INDEX', key_index)@ 	    if ( sts .and. (key_index .lt. 0 .or. key_index .gt. 254) )<      &              sts = SHR$_VALERR           !value error 	end ift     98    continue 	Param_Init = sts  	return.       end !of Param_Init        :       subroutine  Give_Signal ( condition, param, status ) 	!5 	!   Display an error message rather than signalling.-7 	!   Special handling given for some input file errors.  	! 	implicit none C     called by:& *       program         Extract (main) C     constant::F 	character *(*)  fACILITY_NAME           !(also defined in Param_Init), 	parameter     ( fACILITY_NAME = 'EXTRACT' )M *-      include '($CLIMSGdef)/list'             !command interpreter messageslG 	parameter       CLI$_INVRFM = '000388D2'x       !invalid record formatp: 	include '($RMSdef)/nolist'              !rms status codes= 	include '($SHRdef)/nolist'              !shared message defs 9 	include 'f_inc:Dsc.F'                   !descriptor defs  C     input:# 	integer *4      condition,  status  	record /dsc/    param C     local: 	integer *4      msgvec(0:7) 	logical         ok  C     functions: 	integer         LIB$MATCH_CONDs  5 	msgvec(0) = 4           !vector contains 4 longwordsoJ 	msgvec(1) = condition .or. '08000002'x  !severity=error, facility=non-sys; 	msgvec(2) = 1                           !1 fao arg follows  	msgvec(3) = %LOC(param)G 	msgvec(4) = status                      !secondary condition (rms sts)u7 	msgvec(5) = 0                           !dummy rms stv G 	msgvec(6) = 0           !extend vector as safety precaution (just in -lH 	msgvec(7) = 0           !+case 'status' is accvio--should never happen)  K C     If the error status is 'file locked by another user' or 'insufficient N C         privilege (protection violation)' then treat it as a warning insteadG C         of an error so that we can procede with any additional files. A 	ok = (  LIB$MATCH_COND( status, RMS$_FLK, RMS$_PRV, CLI$_INVRFM)a      &        .gt. 0M      &    .and. LIB$MATCH_COND( condition, SHR$_OPENOUT)    !not output error       &         .eq. 0  )K 	if ( ok )  msgvec(1) = msgvec(1) .and. .not. 7  !set severity to 'warning'e  * 	call SYS$PUTMSG( msgvec,, fACILITY_NAME,)  B 	if ( ok )  status = status .or. 1       !transform into 'success'6 	status = status .or. '10000000'x        !message seen 	returnE       end !of Give_Signal 